"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTable = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Paginator = require("../paginator/Paginator");

var _DomHandler = _interopRequireDefault(require("../utils/DomHandler"));

var _ObjectUtils = _interopRequireDefault(require("../utils/ObjectUtils"));

var _FilterUtils = _interopRequireDefault(require("../utils/FilterUtils"));

var _ScrollableView = require("./ScrollableView");

var _TableBody = require("./TableBody");

var _TableFooter = require("./TableFooter");

var _TableHeader = require("./TableHeader");

var _TableLoadingBody = require("./TableLoadingBody");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DataTable = /*#__PURE__*/function (_Component) {
  _inherits(DataTable, _Component);

  var _super = _createSuper(DataTable);

  function DataTable(props) {
    var _this;

    _classCallCheck(this, DataTable);

    _this = _super.call(this, props);
    _this.state = {};

    if (!_this.props.onPage) {
      _this.state.first = props.first;
      _this.state.rows = props.rows;
    }

    if (!_this.props.onSort) {
      _this.state.sortField = props.sortField;
      _this.state.sortOrder = props.sortOrder;
      _this.state.multiSortMeta = props.multiSortMeta;
    }

    if (!_this.props.onFilter) {
      _this.state.filters = props.filters;
    }

    if (_this.isStateful()) {
      _this.restoreState(_this.state);
    }

    _this.onPageChange = _this.onPageChange.bind(_assertThisInitialized(_this));
    _this.onSort = _this.onSort.bind(_assertThisInitialized(_this));
    _this.onFilter = _this.onFilter.bind(_assertThisInitialized(_this));
    _this.onColumnResizeStart = _this.onColumnResizeStart.bind(_assertThisInitialized(_this));
    _this.onHeaderCheckboxClick = _this.onHeaderCheckboxClick.bind(_assertThisInitialized(_this));
    _this.onColumnDragStart = _this.onColumnDragStart.bind(_assertThisInitialized(_this));
    _this.onColumnDragOver = _this.onColumnDragOver.bind(_assertThisInitialized(_this));
    _this.onColumnDragLeave = _this.onColumnDragLeave.bind(_assertThisInitialized(_this));
    _this.onColumnDrop = _this.onColumnDrop.bind(_assertThisInitialized(_this));
    _this.onVirtualScroll = _this.onVirtualScroll.bind(_assertThisInitialized(_this));
    _this.frozenSelectionMode = null;
    return _this;
  }

  _createClass(DataTable, [{
    key: "getFirst",
    value: function getFirst() {
      return this.props.onPage ? this.props.first : this.state.first;
    }
  }, {
    key: "getRows",
    value: function getRows() {
      return this.props.onPage ? this.props.rows : this.state.rows;
    }
  }, {
    key: "getSortField",
    value: function getSortField() {
      return this.props.onSort ? this.props.sortField : this.state.sortField;
    }
  }, {
    key: "getSortOrder",
    value: function getSortOrder() {
      return this.props.onSort ? this.props.sortOrder : this.state.sortOrder;
    }
  }, {
    key: "getMultiSortMeta",
    value: function getMultiSortMeta() {
      return this.props.onSort ? this.props.multiSortMeta : this.state.multiSortMeta;
    }
  }, {
    key: "getFilters",
    value: function getFilters() {
      return this.props.onFilter ? this.props.filters : this.state.filters;
    }
  }, {
    key: "getStorage",
    value: function getStorage() {
      switch (this.props.stateStorage) {
        case 'local':
          return window.localStorage;

        case 'session':
          return window.sessionStorage;

        case 'custom':
          return null;

        default:
          throw new Error(this.props.stateStorage + ' is not a valid value for the state storage, supported values are "local", "session" and "custom".');
      }
    }
  }, {
    key: "isCustomStateStorage",
    value: function isCustomStateStorage() {
      return this.props.stateStorage === 'custom';
    }
  }, {
    key: "isStateful",
    value: function isStateful() {
      return this.props.stateKey != null || this.isCustomStateStorage();
    }
  }, {
    key: "saveState",
    value: function saveState() {
      var state = {};

      if (this.props.paginator) {
        state.first = this.getFirst();
        state.rows = this.getRows();
      }

      var sortField = this.getSortField();

      if (sortField) {
        state.sortField = sortField;
        state.sortOrder = this.getSortOrder();
      }

      var multiSortMeta = this.getMultiSortMeta();

      if (multiSortMeta) {
        state.multiSortMeta = multiSortMeta;
      }

      if (this.hasFilter()) {
        state.filters = this.getFilters();
      }

      if (this.props.resizableColumns) {
        this.saveColumnWidths(state);
      }

      if (this.props.reorderableColumns) {
        state.columnOrder = this.state.columnOrder;
      }

      if (this.props.expandedRows) {
        state.expandedRows = this.props.expandedRows;
      }

      if (this.props.selection && this.props.onSelectionChange) {
        state.selection = this.props.selection;
      }

      if (this.isCustomStateStorage()) {
        if (this.props.customSaveState) {
          this.props.customSaveState(state);
        }
      } else {
        var storage = this.getStorage();

        if (Object.keys(state).length) {
          storage.setItem(this.props.stateKey, JSON.stringify(state));
        }
      }

      if (this.props.onStateSave) {
        this.props.onStateSave(state);
      }
    }
  }, {
    key: "clearState",
    value: function clearState() {
      var storage = this.getStorage();

      if (storage && this.props.stateKey) {
        storage.removeItem(this.props.stateKey);
      }
    }
  }, {
    key: "restoreState",
    value: function restoreState(state) {
      var restoredState = {};

      if (this.isCustomStateStorage()) {
        if (this.props.customRestoreState) {
          restoredState = this.props.customRestoreState();
        }
      } else {
        var storage = this.getStorage();
        var stateString = storage.getItem(this.props.stateKey);

        if (stateString) {
          restoredState = JSON.parse(stateString);
        }
      }

      if (restoredState && Object.keys(restoredState).length) {
        if (this.props.paginator) {
          if (this.props.onPage) {
            this.props.onPage({
              first: restoredState.first,
              rows: restoredState.rows
            });
          } else {
            state.first = restoredState.first;
            state.rows = restoredState.rows;
          }
        }

        if (restoredState.sortField) {
          if (this.props.onSort) {
            this.props.onSort({
              sortField: restoredState.sortField,
              sortOrder: restoredState.sortOrder
            });
          } else {
            state.sortField = restoredState.sortField;
            state.sortOrder = restoredState.sortOrder;
          }
        }

        if (restoredState.multiSortMeta) {
          if (this.props.onSort) {
            this.props.onSort({
              multiSortMeta: restoredState.multiSortMeta
            });
          } else {
            state.multiSortMeta = restoredState.multiSortMeta;
          }
        }

        if (restoredState.filters) {
          if (this.props.onFilter) {
            this.props.onFilter({
              filters: restoredState.filters
            });
          } else {
            state.filters = restoredState.filters;
          }
        }

        if (this.props.resizableColumns) {
          this.columnWidthsState = restoredState.columnWidths;
          this.tableWidthState = restoredState.tableWidth;
        }

        if (this.props.reorderableColumns) {
          state.columnOrder = restoredState.columnOrder;
        }

        if (restoredState.expandedRows && this.props.onRowToggle) {
          this.props.onRowToggle({
            data: restoredState.expandedRows
          });
        }

        if (restoredState.selection && this.props.onSelectionChange) {
          this.props.onSelectionChange({
            value: restoredState.selection
          });
        }

        if (this.props.onStateRestore) {
          this.props.onStateRestore(restoredState);
        }
      }
    }
  }, {
    key: "saveColumnWidths",
    value: function saveColumnWidths(state) {
      var widths = [];

      var headers = _DomHandler.default.find(this.container, '.p-datatable-thead > tr > th');

      headers.map(function (header) {
        return widths.push(_DomHandler.default.getOuterWidth(header));
      });
      state.columnWidths = widths.join(',');

      if (this.props.columnResizeMode === 'expand') {
        state.tableWidth = this.props.scrollable ? _DomHandler.default.findSingle(this.container, '.p-datatable-scrollable-header-table').style.width : _DomHandler.default.getOuterWidth(this.table) + 'px';
      }
    }
  }, {
    key: "restoreColumnWidths",
    value: function restoreColumnWidths() {
      if (this.columnWidthsState) {
        var widths = this.columnWidthsState.split(',');

        if (this.props.columnResizeMode === 'expand' && this.tableWidthState) {
          if (this.props.scrollable) {
            this.setScrollableItemsWidthOnExpandResize(null, this.tableWidthState, 0);
          } else {
            this.table.style.width = this.tableWidthState;
            this.container.style.width = this.tableWidthState;
          }
        }

        if (this.props.scrollable) {
          var headerCols = _DomHandler.default.find(this.container, '.p-datatable-scrollable-header-table > colgroup > col');

          var bodyCols = _DomHandler.default.find(this.container, '.p-datatable-scrollable-body-table > colgroup > col');

          headerCols.map(function (col, index) {
            return col.style.width = widths[index] + 'px';
          });
          bodyCols.map(function (col, index) {
            return col.style.width = widths[index] + 'px';
          });
        } else {
          var headers = _DomHandler.default.find(this.table, '.p-datatable-thead > tr > th');

          headers.map(function (header, index) {
            return header.style.width = widths[index] + 'px';
          });
        }
      }
    }
  }, {
    key: "onPageChange",
    value: function onPageChange(event) {
      if (this.props.onPage) this.props.onPage(event);else this.setState({
        first: event.first,
        rows: event.rows
      });

      if (this.props.onValueChange) {
        this.props.onValueChange();
      }
    }
  }, {
    key: "createPaginator",
    value: function createPaginator(position, totalRecords, data) {
      var className = 'p-paginator-' + position;
      return /*#__PURE__*/_react.default.createElement(_Paginator.Paginator, {
        first: this.getFirst(),
        rows: this.getRows(),
        pageLinkSize: this.props.pageLinkSize,
        className: className,
        onPageChange: this.onPageChange,
        template: this.props.paginatorTemplate,
        totalRecords: totalRecords,
        rowsPerPageOptions: this.props.rowsPerPageOptions,
        currentPageReportTemplate: this.props.currentPageReportTemplate,
        leftContent: this.props.paginatorLeft,
        rightContent: this.props.paginatorRight,
        alwaysShow: this.props.alwaysShowPaginator
      });
    }
  }, {
    key: "onSort",
    value: function onSort(event) {
      var sortField = event.sortField;
      var sortOrder = this.props.defaultSortOrder;
      var multiSortMeta;
      var eventMeta;
      this.columnSortable = event.sortable;
      this.columnSortFunction = event.sortFunction;
      this.columnField = event.sortField;

      if (this.props.sortMode === 'multiple') {
        var metaKey = event.originalEvent.metaKey || event.originalEvent.ctrlKey;
        multiSortMeta = this.getMultiSortMeta();

        if (multiSortMeta && multiSortMeta instanceof Array) {
          var sortMeta = multiSortMeta.find(function (sortMeta) {
            return sortMeta.field === sortField;
          });
          sortOrder = sortMeta ? this.getCalculatedSortOrder(sortMeta.order) : sortOrder;
        }

        var newMetaData = {
          field: sortField,
          order: sortOrder
        };

        if (sortOrder) {
          if (!multiSortMeta || !metaKey) {
            multiSortMeta = [];
          }

          this.addSortMeta(newMetaData, multiSortMeta);
        } else if (this.props.removableSort && multiSortMeta) {
          this.removeSortMeta(newMetaData, multiSortMeta);
        }

        eventMeta = {
          multiSortMeta: multiSortMeta
        };
      } else {
        sortOrder = this.getSortField() === sortField ? this.getCalculatedSortOrder(this.getSortOrder()) : sortOrder;

        if (this.props.removableSort) {
          sortField = sortOrder ? sortField : null;
        }

        eventMeta = {
          sortField: sortField,
          sortOrder: sortOrder
        };
      }

      if (this.props.onSort) {
        this.props.onSort(eventMeta);
      } else {
        eventMeta.first = 0;
        this.setState(eventMeta);
      }

      if (this.props.onValueChange) {
        this.props.onValueChange(this.processData({
          sortField: sortField,
          sortOrder: sortOrder,
          multiSortMeta: multiSortMeta
        }));
      }
    }
  }, {
    key: "getCalculatedSortOrder",
    value: function getCalculatedSortOrder(currentOrder) {
      return this.props.removableSort ? currentOrder ? currentOrder < 0 ? 0 : -1 : 1 : currentOrder * -1;
    }
  }, {
    key: "addSortMeta",
    value: function addSortMeta(meta, multiSortMeta) {
      var index = -1;

      for (var i = 0; i < multiSortMeta.length; i++) {
        if (multiSortMeta[i].field === meta.field) {
          index = i;
          break;
        }
      }

      if (index >= 0) multiSortMeta[index] = meta;else multiSortMeta.push(meta);
    }
  }, {
    key: "removeSortMeta",
    value: function removeSortMeta(meta, multiSortMeta) {
      var index = -1;

      for (var i = 0; i < multiSortMeta.length; i++) {
        if (multiSortMeta[i].field === meta.field) {
          index = i;
          break;
        }
      }

      if (index >= 0) {
        multiSortMeta.splice(index, 1);
      }

      multiSortMeta = multiSortMeta.length > 0 ? multiSortMeta : null;
    }
  }, {
    key: "sortSingle",
    value: function sortSingle(data, sortField, sortOrder) {
      var value = _toConsumableArray(data);

      if (this.columnSortable && this.columnSortFunction) {
        value = this.columnSortFunction({
          field: this.getSortField(),
          order: this.getSortOrder()
        });
      } else {
        value.sort(function (data1, data2) {
          var value1 = _ObjectUtils.default.resolveFieldData(data1, sortField);

          var value2 = _ObjectUtils.default.resolveFieldData(data2, sortField);

          var result = null;
          if (value1 == null && value2 != null) result = -1;else if (value1 != null && value2 == null) result = 1;else if (value1 == null && value2 == null) result = 0;else if (typeof value1 === 'string' && typeof value2 === 'string') result = value1.localeCompare(value2, undefined, {
            numeric: true
          });else result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
          return sortOrder * result;
        });
      }

      return value;
    }
  }, {
    key: "sortMultiple",
    value: function sortMultiple(data, multiSortMeta) {
      var _this2 = this;

      var value = _toConsumableArray(data);

      if (this.columnSortable && this.columnSortFunction) {
        var meta = multiSortMeta.find(function (meta) {
          return meta.field === _this2.columnField;
        });
        var field = this.columnField;
        var order = meta ? meta.order : this.defaultSortOrder;
        value = this.columnSortFunction({
          field: field,
          order: order
        });
      } else {
        value.sort(function (data1, data2) {
          return _this2.multisortField(data1, data2, multiSortMeta, 0);
        });
      }

      return value;
    }
  }, {
    key: "multisortField",
    value: function multisortField(data1, data2, multiSortMeta, index) {
      var value1 = _ObjectUtils.default.resolveFieldData(data1, multiSortMeta[index].field);

      var value2 = _ObjectUtils.default.resolveFieldData(data2, multiSortMeta[index].field);

      var result = null;

      if (typeof value1 === 'string' || value1 instanceof String) {
        if (value1.localeCompare && value1 !== value2) {
          return multiSortMeta[index].order * value1.localeCompare(value2, undefined, {
            numeric: true
          });
        }
      } else {
        result = value1 < value2 ? -1 : 1;
      }

      if (value1 === value2) {
        return multiSortMeta.length - 1 > index ? this.multisortField(data1, data2, multiSortMeta, index + 1) : 0;
      }

      return multiSortMeta[index].order * result;
    }
  }, {
    key: "filter",
    value: function filter(value, field, mode) {
      this.onFilter({
        value: value,
        field: field,
        matchMode: mode
      });
    }
  }, {
    key: "onFilter",
    value: function onFilter(event) {
      var currentFilters = this.getFilters();
      var newFilters = currentFilters ? _objectSpread({}, currentFilters) : {};
      if (!this.isFilterBlank(event.value)) newFilters[event.field] = {
        value: event.value,
        matchMode: event.matchMode
      };else if (newFilters[event.field]) delete newFilters[event.field];

      if (this.props.onFilter) {
        this.props.onFilter({
          filters: newFilters
        });
      } else {
        this.setState({
          first: 0,
          filters: newFilters
        });
      }

      if (this.props.onValueChange) {
        this.props.onValueChange(this.processData({
          filters: newFilters
        }));
      }
    }
  }, {
    key: "hasFilter",
    value: function hasFilter() {
      var filters = this.getFilters() || this.props.globalFilter;
      return filters && Object.keys(filters).length > 0;
    }
  }, {
    key: "isFilterBlank",
    value: function isFilterBlank(filter) {
      if (filter !== null && filter !== undefined) {
        if (typeof filter === 'string' && filter.trim().length === 0 || filter instanceof Array && filter.length === 0) return true;else return false;
      }

      return true;
    }
  }, {
    key: "hasFooter",
    value: function hasFooter() {
      if (this.props.children) {
        if (this.props.footerColumnGroup) {
          return true;
        } else {
          return this.hasChildrenFooter(this.props.children);
        }
      } else {
        return false;
      }
    }
  }, {
    key: "hasChildrenFooter",
    value: function hasChildrenFooter(children) {
      var hasFooter = false;

      if (children) {
        if (children instanceof Array) {
          for (var i = 0; i < children.length; i++) {
            hasFooter = hasFooter || this.hasChildrenFooter(children[i]);
          }
        } else {
          return children.props && children.props.footer !== null;
        }
      }

      return hasFooter;
    }
  }, {
    key: "onColumnResizeStart",
    value: function onColumnResizeStart(event) {
      var containerLeft = _DomHandler.default.getOffset(this.container).left;

      this.resizeColumn = event.columnEl;
      this.resizeColumnProps = event.columnProps;
      this.columnResizing = true;
      this.lastResizerHelperX = event.originalEvent.pageX - containerLeft + this.container.scrollLeft;
      this.bindColumnResizeEvents();
    }
  }, {
    key: "onColumnResize",
    value: function onColumnResize(event) {
      var containerLeft = _DomHandler.default.getOffset(this.container).left;

      _DomHandler.default.addClass(this.container, 'p-unselectable-text');

      this.resizerHelper.style.height = this.container.offsetHeight + 'px';
      this.resizerHelper.style.top = 0 + 'px';
      this.resizerHelper.style.left = event.pageX - containerLeft + this.container.scrollLeft + 'px';
      this.resizerHelper.style.display = 'block';
    }
  }, {
    key: "onColumnResizeEnd",
    value: function onColumnResizeEnd(event) {
      var delta = this.resizerHelper.offsetLeft - this.lastResizerHelperX;
      var columnWidth = this.resizeColumn.offsetWidth;
      var newColumnWidth = columnWidth + delta;
      var minWidth = this.resizeColumn.style.minWidth || 15;

      if (columnWidth + delta > parseInt(minWidth, 10)) {
        if (this.props.columnResizeMode === 'fit') {
          var nextColumn = this.resizeColumn.nextElementSibling;
          var nextColumnWidth = nextColumn.offsetWidth - delta;

          if (newColumnWidth > 15 && nextColumnWidth > 15) {
            if (this.props.scrollable) {
              var scrollableView = this.findParentScrollableView(this.resizeColumn);

              var scrollableBodyTable = _DomHandler.default.findSingle(scrollableView, 'table.p-datatable-scrollable-body-table');

              var scrollableHeaderTable = _DomHandler.default.findSingle(scrollableView, 'table.p-datatable-scrollable-header-table');

              var scrollableFooterTable = _DomHandler.default.findSingle(scrollableView, 'table.p-datatable-scrollable-footer-table');

              var resizeColumnIndex = _DomHandler.default.index(this.resizeColumn);

              this.resizeColGroup(scrollableHeaderTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
              this.resizeColGroup(scrollableBodyTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
              this.resizeColGroup(scrollableFooterTable, resizeColumnIndex, newColumnWidth, nextColumnWidth);
            } else {
              this.resizeColumn.style.width = newColumnWidth + 'px';

              if (nextColumn) {
                nextColumn.style.width = nextColumnWidth + 'px';
              }
            }
          }
        } else if (this.props.columnResizeMode === 'expand') {
          if (this.props.scrollable) {
            this.setScrollableItemsWidthOnExpandResize(this.resizeColumn, newColumnWidth, delta);
          } else {
            this.table.style.width = this.table.offsetWidth + delta + 'px';
            this.resizeColumn.style.width = newColumnWidth + 'px';
          }
        }

        if (this.props.onColumnResizeEnd) {
          this.props.onColumnResizeEnd({
            element: this.resizeColumn,
            column: this.resizeColumnProps,
            delta: delta
          });
        }

        if (this.isStateful()) {
          this.saveState();
        }
      }

      this.resizerHelper.style.display = 'none';
      this.resizeColumn = null;
      this.resizeColumnProps = null;

      _DomHandler.default.removeClass(this.container, 'p-unselectable-text');

      this.unbindColumnResizeEvents();
    }
  }, {
    key: "setScrollableItemsWidthOnExpandResize",
    value: function setScrollableItemsWidthOnExpandResize(column, newColumnWidth, delta) {
      var scrollableView = column ? this.findParentScrollableView(column) : this.container;

      var scrollableBody = _DomHandler.default.findSingle(scrollableView, '.p-datatable-scrollable-body');

      var scrollableHeader = _DomHandler.default.findSingle(scrollableView, '.p-datatable-scrollable-header');

      var scrollableFooter = _DomHandler.default.findSingle(scrollableView, '.p-datatable-scrollable-footer');

      var scrollableBodyTable = _DomHandler.default.findSingle(scrollableBody, 'table.p-datatable-scrollable-body-table');

      var scrollableHeaderTable = _DomHandler.default.findSingle(scrollableHeader, 'table.p-datatable-scrollable-header-table');

      var scrollableFooterTable = _DomHandler.default.findSingle(scrollableFooter, 'table.p-datatable-scrollable-footer-table');

      var scrollableBodyTableWidth = column ? scrollableBodyTable.offsetWidth + delta : newColumnWidth;
      var scrollableHeaderTableWidth = column ? scrollableHeaderTable.offsetWidth + delta : newColumnWidth;
      var isContainerInViewport = this.container.offsetWidth >= scrollableBodyTableWidth;

      var setWidth = function setWidth(container, table, width, isContainerInViewport) {
        if (container && table) {
          container.style.width = isContainerInViewport ? width + _DomHandler.default.calculateScrollbarWidth(scrollableBody) + 'px' : 'auto';
          table.style.width = width + 'px';
        }
      };

      setWidth(scrollableBody, scrollableBodyTable, scrollableBodyTableWidth, isContainerInViewport);
      setWidth(scrollableHeader, scrollableHeaderTable, scrollableHeaderTableWidth, isContainerInViewport);
      setWidth(scrollableFooter, scrollableFooterTable, scrollableHeaderTableWidth, isContainerInViewport);

      if (column) {
        var resizeColumnIndex = _DomHandler.default.index(column);

        this.resizeColGroup(scrollableHeaderTable, resizeColumnIndex, newColumnWidth, null);
        this.resizeColGroup(scrollableBodyTable, resizeColumnIndex, newColumnWidth, null);
        this.resizeColGroup(scrollableFooterTable, resizeColumnIndex, newColumnWidth, null);
      }
    }
  }, {
    key: "findParentScrollableView",
    value: function findParentScrollableView(column) {
      if (column) {
        var parent = column.parentElement;

        while (parent && !_DomHandler.default.hasClass(parent, 'p-datatable-scrollable-view')) {
          parent = parent.parentElement;
        }

        return parent;
      } else {
        return null;
      }
    }
  }, {
    key: "resizeColGroup",
    value: function resizeColGroup(table, resizeColumnIndex, newColumnWidth, nextColumnWidth) {
      if (table) {
        var colGroup = table.children[0].nodeName === 'COLGROUP' ? table.children[0] : null;

        if (colGroup) {
          var col = colGroup.children[resizeColumnIndex];
          var nextCol = col.nextElementSibling;
          col.style.width = newColumnWidth + 'px';

          if (nextCol && nextColumnWidth) {
            nextCol.style.width = nextColumnWidth + 'px';
          }
        } else {
          throw new Error("Scrollable tables require a colgroup to support resizable columns");
        }
      }
    }
  }, {
    key: "bindColumnResizeEvents",
    value: function bindColumnResizeEvents() {
      var _this3 = this;

      this.documentColumnResizeListener = document.addEventListener('mousemove', function (event) {
        if (_this3.columnResizing) {
          _this3.onColumnResize(event);
        }
      });
      this.documentColumnResizeEndListener = document.addEventListener('mouseup', function (event) {
        if (_this3.columnResizing) {
          _this3.columnResizing = false;

          _this3.onColumnResizeEnd(event);
        }
      });
    }
  }, {
    key: "unbindColumnResizeEvents",
    value: function unbindColumnResizeEvents() {
      document.removeEventListener('document', this.documentColumnResizeListener);
      document.removeEventListener('document', this.documentColumnResizeEndListener);
    }
  }, {
    key: "findParentHeader",
    value: function findParentHeader(element) {
      if (element.nodeName === 'TH') {
        return element;
      } else {
        var parent = element.parentElement;

        while (parent.nodeName !== 'TH') {
          parent = parent.parentElement;
          if (!parent) break;
        }

        return parent;
      }
    }
  }, {
    key: "onColumnDragStart",
    value: function onColumnDragStart(event) {
      if (this.columnResizing) {
        event.preventDefault();
        return;
      }

      this.iconWidth = _DomHandler.default.getHiddenElementOuterWidth(this.reorderIndicatorUp);
      this.iconHeight = _DomHandler.default.getHiddenElementOuterHeight(this.reorderIndicatorUp);
      this.draggedColumn = this.findParentHeader(event.target);
      event.dataTransfer.setData('text', 'b'); // Firefox requires this to make dragging possible
    }
  }, {
    key: "onColumnDragOver",
    value: function onColumnDragOver(event) {
      var dropHeader = this.findParentHeader(event.target);

      if (this.props.reorderableColumns && this.draggedColumn && dropHeader) {
        event.preventDefault();

        var containerOffset = _DomHandler.default.getOffset(this.container);

        var dropHeaderOffset = _DomHandler.default.getOffset(dropHeader);

        if (this.draggedColumn !== dropHeader) {
          var targetLeft = dropHeaderOffset.left - containerOffset.left; //let targetTop =  containerOffset.top - dropHeaderOffset.top;

          var columnCenter = dropHeaderOffset.left + dropHeader.offsetWidth / 2;
          this.reorderIndicatorUp.style.top = dropHeaderOffset.top - containerOffset.top - (this.iconHeight - 1) + 'px';
          this.reorderIndicatorDown.style.top = dropHeaderOffset.top - containerOffset.top + dropHeader.offsetHeight + 'px';

          if (event.pageX > columnCenter) {
            this.reorderIndicatorUp.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.iconWidth / 2) + 'px';
            this.reorderIndicatorDown.style.left = targetLeft + dropHeader.offsetWidth - Math.ceil(this.iconWidth / 2) + 'px';
            this.dropPosition = 1;
          } else {
            this.reorderIndicatorUp.style.left = targetLeft - Math.ceil(this.iconWidth / 2) + 'px';
            this.reorderIndicatorDown.style.left = targetLeft - Math.ceil(this.iconWidth / 2) + 'px';
            this.dropPosition = -1;
          }

          this.reorderIndicatorUp.style.display = 'block';
          this.reorderIndicatorDown.style.display = 'block';
        }
      }
    }
  }, {
    key: "onColumnDragLeave",
    value: function onColumnDragLeave(event) {
      if (this.props.reorderableColumns && this.draggedColumn) {
        event.preventDefault();
        this.reorderIndicatorUp.style.display = 'none';
        this.reorderIndicatorDown.style.display = 'none';
      }
    }
  }, {
    key: "onColumnDrop",
    value: function onColumnDrop(event) {
      event.preventDefault();

      if (this.draggedColumn) {
        var dragIndex = _DomHandler.default.index(this.draggedColumn);

        var dropIndex = _DomHandler.default.index(this.findParentHeader(event.target));

        var allowDrop = dragIndex !== dropIndex;

        if (allowDrop && (dropIndex - dragIndex === 1 && this.dropPosition === -1 || dragIndex - dropIndex === 1 && this.dropPosition === 1)) {
          allowDrop = false;
        }

        if (allowDrop) {
          var columns = this.state.columnOrder ? this.getColumns() : _react.default.Children.toArray(this.props.children);

          _ObjectUtils.default.reorderArray(columns, dragIndex, dropIndex);

          var columnOrder = [];

          var _iterator = _createForOfIteratorHelper(columns),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var column = _step.value;
              columnOrder.push(column.props.columnKey || column.props.field);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          this.setState({
            columnOrder: columnOrder
          });

          if (this.props.onColReorder) {
            this.props.onColReorder({
              originalEvent: event,
              dragIndex: dragIndex,
              dropIndex: dropIndex,
              columns: columns
            });
          }
        }

        this.reorderIndicatorUp.style.display = 'none';
        this.reorderIndicatorDown.style.display = 'none';
        this.draggedColumn.draggable = false;
        this.draggedColumn = null;
        this.dropPosition = null;
      }
    }
  }, {
    key: "onVirtualScroll",
    value: function onVirtualScroll(event) {
      var _this4 = this;

      if (this.virtualScrollTimer) {
        clearTimeout(this.virtualScrollTimer);
      }

      this.virtualScrollTimer = setTimeout(function () {
        if (_this4.props.onVirtualScroll) {
          _this4.props.onVirtualScroll({
            first: (event.page - 1) * _this4.props.rows,
            rows: _this4.props.virtualScroll ? _this4.props.rows * 2 : _this4.props.rows
          });
        }
      }, this.props.virtualScrollDelay);
    }
  }, {
    key: "exportCSV",
    value: function exportCSV() {
      var _this5 = this;

      var data = this.processData();
      var csv = "\uFEFF";

      var columns = _react.default.Children.toArray(this.props.children); //headers


      for (var i = 0; i < columns.length; i++) {
        if (columns[i].props.field) {
          csv += '"' + (columns[i].props.header || columns[i].props.field) + '"';

          if (i < columns.length - 1) {
            csv += this.props.csvSeparator;
          }
        }
      } //body


      data.forEach(function (record, i) {
        csv += '\n';

        for (var _i = 0; _i < columns.length; _i++) {
          var column = columns[_i],
              field = column.props.field;

          if (column.props.exportable && field) {
            var cellData = _ObjectUtils.default.resolveFieldData(record, field);

            if (cellData != null) {
              if (_this5.props.exportFunction) {
                cellData = _this5.props.exportFunction({
                  data: cellData,
                  field: field
                });
              } else cellData = String(cellData).replace(/"/g, '""');
            } else cellData = '';

            csv += '"' + cellData + '"';

            if (_i < columns.length - 1) {
              csv += _this5.props.csvSeparator;
            }
          }
        }
      });
      var blob = new Blob([csv], {
        type: 'text/csv;charset=utf-8;'
      });

      if (window.navigator.msSaveOrOpenBlob) {
        navigator.msSaveOrOpenBlob(blob, this.props.exportFilename + '.csv');
      } else {
        var link = document.createElement("a");
        link.style.display = 'none';
        document.body.appendChild(link);

        if (link.download !== undefined) {
          link.setAttribute('href', URL.createObjectURL(blob));
          link.setAttribute('download', this.props.exportFilename + '.csv');
          link.click();
        } else {
          csv = 'data:text/csv;charset=utf-8,' + csv;
          window.open(encodeURI(csv));
        }

        document.body.removeChild(link);
      }
    }
  }, {
    key: "closeEditingCell",
    value: function closeEditingCell() {
      if (this.props.editMode !== "row") {
        document.body.click();
      }
    }
  }, {
    key: "onHeaderCheckboxClick",
    value: function onHeaderCheckboxClick(event) {
      var selection;

      if (!event.checked) {
        var visibleData = this.hasFilter() ? this.processData() : this.props.value;
        selection = _toConsumableArray(visibleData);
      } else {
        selection = [];
      }

      if (this.props.onSelectionChange) {
        var originalEvent = event.originalEvent,
            rest = _objectWithoutProperties(event, ["originalEvent"]);

        this.props.onSelectionChange(_objectSpread({
          originalEvent: originalEvent,
          value: selection
        }, rest));
      }
    }
  }, {
    key: "filterLocal",
    value: function filterLocal(value, localFilters) {
      var filteredValue = [];
      var filters = localFilters || this.getFilters();

      var columns = _react.default.Children.toArray(this.props.children);

      for (var i = 0; i < value.length; i++) {
        var localMatch = true;
        var globalMatch = false;

        for (var j = 0; j < columns.length; j++) {
          var col = columns[j];
          var columnField = col.props.filterField || col.props.field;
          var filterMeta = filters ? filters[columnField] : null; //local

          if (filterMeta) {
            var filterValue = filterMeta.value;

            var dataFieldValue = _ObjectUtils.default.resolveFieldData(value[i], columnField);

            var filterMatchMode = filterMeta.matchMode || col.props.filterMatchMode;
            var filterConstraint = filterMatchMode === 'custom' ? col.props.filterFunction : _FilterUtils.default[filterMatchMode];

            if (!filterConstraint(dataFieldValue, filterValue, this.props.filterLocale)) {
              localMatch = false;
            }

            if (!localMatch) {
              break;
            }
          }

          if (!col.props.excludeGlobalFilter && this.props.globalFilter && !globalMatch) {
            globalMatch = _FilterUtils.default['contains'](_ObjectUtils.default.resolveFieldData(value[i], columnField), this.props.globalFilter, this.props.filterLocale);
          }
        }

        var matches = localMatch;

        if (this.props.globalFilter) {
          matches = localMatch && globalMatch;
        }

        if (matches) {
          filteredValue.push(value[i]);
        }
      }

      if (filteredValue.length === value.length) {
        filteredValue = value;
      }

      return filteredValue;
    }
  }, {
    key: "processData",
    value: function processData(localState) {
      var data = this.props.value;

      if (!this.props.lazy) {
        if (data && data.length) {
          var sortField = localState && localState.sortField || this.getSortField();
          var sortOrder = localState && localState.sortOrder || this.getSortOrder();
          var multiSortMeta = localState && localState.multiSortMeta || this.getMultiSortMeta();

          if (sortField || multiSortMeta && multiSortMeta.length) {
            if (this.props.sortMode === 'single') data = this.sortSingle(data, sortField, sortOrder);else if (this.props.sortMode === 'multiple') data = this.sortMultiple(data, multiSortMeta);
          }

          var localFilters = localState && localState.filters || this.getFilters();

          if (localFilters || this.props.globalFilter) {
            data = this.filterLocal(data, localFilters);
          }
        }
      }

      return data;
    }
  }, {
    key: "isAllSelected",
    value: function isAllSelected() {
      var visibleData = this.hasFilter() ? this.processData() : this.props.value;
      return this.props.selection && visibleData && visibleData.length && this.props.selection.length === visibleData.length;
    }
  }, {
    key: "getFrozenColumns",
    value: function getFrozenColumns(columns) {
      var frozenColumns = null;

      var _iterator2 = _createForOfIteratorHelper(columns),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var col = _step2.value;

          if (col.props.frozen) {
            frozenColumns = frozenColumns || [];
            frozenColumns.push(col);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return frozenColumns;
    }
  }, {
    key: "getScrollableColumns",
    value: function getScrollableColumns(columns) {
      var scrollableColumns = null;

      var _iterator3 = _createForOfIteratorHelper(columns),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var col = _step3.value;

          if (!col.props.frozen) {
            scrollableColumns = scrollableColumns || [];
            scrollableColumns.push(col);
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return scrollableColumns;
    }
  }, {
    key: "getFrozenSelectionModeInColumn",
    value: function getFrozenSelectionModeInColumn(columns) {
      if (Array.isArray(columns)) {
        var _iterator4 = _createForOfIteratorHelper(columns),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var col = _step4.value;
            if (col.props.selectionMode) return col.props.selectionMode;
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return null;
    }
  }, {
    key: "createTableHeader",
    value: function createTableHeader(value, columns, columnGroup) {
      return /*#__PURE__*/_react.default.createElement(_TableHeader.TableHeader, {
        value: value,
        onSort: this.onSort,
        sortField: this.getSortField(),
        sortOrder: this.getSortOrder(),
        multiSortMeta: this.getMultiSortMeta(),
        columnGroup: columnGroup,
        resizableColumns: this.props.resizableColumns,
        onColumnResizeStart: this.onColumnResizeStart,
        onFilter: this.onFilter,
        onHeaderCheckboxClick: this.onHeaderCheckboxClick,
        headerCheckboxSelected: this.isAllSelected(),
        reorderableColumns: this.props.reorderableColumns,
        onColumnDragStart: this.onColumnDragStart,
        filters: this.getFilters(),
        onColumnDragOver: this.onColumnDragOver,
        onColumnDragLeave: this.onColumnDragLeave,
        onColumnDrop: this.onColumnDrop,
        tabIndex: this.props.tabIndex
      }, columns);
    }
  }, {
    key: "createTableBody",
    value: function createTableBody(value, columns, frozen) {
      return /*#__PURE__*/_react.default.createElement(_TableBody.TableBody, {
        value: value,
        first: this.getFirst(),
        rows: this.getRows(),
        lazy: this.props.lazy,
        paginator: this.props.paginator,
        dataKey: this.props.dataKey,
        compareSelectionBy: this.props.compareSelectionBy,
        selectionMode: this.props.selectionMode,
        selection: this.props.selection,
        metaKeySelection: this.props.metaKeySelection,
        frozen: frozen,
        frozenSelectionMode: this.frozenSelectionMode,
        onSelectionChange: this.props.onSelectionChange,
        onRowClick: this.props.onRowClick,
        onRowDoubleClick: this.props.onRowDoubleClick,
        onRowSelect: this.props.onRowSelect,
        onRowUnselect: this.props.onRowUnselect,
        contextMenuSelection: this.props.contextMenuSelection,
        onContextMenuSelectionChange: this.props.onContextMenuSelectionChange,
        onContextMenu: this.props.onContextMenu,
        expandedRows: this.props.expandedRows,
        onRowToggle: this.props.onRowToggle,
        rowExpansionTemplate: this.props.rowExpansionTemplate,
        onRowExpand: this.props.onRowExpand,
        onRowCollapse: this.props.onRowCollapse,
        responsive: this.props.responsive,
        emptyMessage: this.props.emptyMessage,
        virtualScroll: this.props.virtualScroll,
        virtualRowHeight: this.props.virtualRowHeight,
        loading: this.props.loading,
        groupField: this.props.groupField,
        rowGroupMode: this.props.rowGroupMode,
        rowGroupHeaderTemplate: this.props.rowGroupHeaderTemplate,
        rowGroupFooterTemplate: this.props.rowGroupFooterTemplate,
        sortField: this.getSortField(),
        rowClassName: this.props.rowClassName,
        onRowReorder: this.props.onRowReorder,
        editMode: this.props.editMode,
        rowEditorValidator: this.props.rowEditorValidator,
        onRowEditInit: this.props.onRowEditInit,
        onRowEditSave: this.props.onRowEditSave,
        onRowEditCancel: this.props.onRowEditCancel,
        expandableRowGroups: this.props.expandableRowGroups,
        showRowReorderElement: this.props.showRowReorderElement,
        showSelectionElement: this.props.showSelectionElement
      }, columns);
    }
  }, {
    key: "createTableLoadingBody",
    value: function createTableLoadingBody(columns) {
      if (this.props.virtualScroll) {
        return /*#__PURE__*/_react.default.createElement(_TableLoadingBody.TableLoadingBody, {
          columns: columns,
          rows: this.getRows()
        });
      } else {
        return null;
      }
    }
  }, {
    key: "createTableFooter",
    value: function createTableFooter(columns, columnGroup) {
      if (this.hasFooter()) return /*#__PURE__*/_react.default.createElement(_TableFooter.TableFooter, {
        columnGroup: columnGroup
      }, columns);else return null;
    }
  }, {
    key: "createScrollableView",
    value: function createScrollableView(value, columns, frozen, headerColumnGroup, footerColumnGroup, totalRecords) {
      return /*#__PURE__*/_react.default.createElement(_ScrollableView.ScrollableView, {
        columns: columns,
        header: this.createTableHeader(value, columns, headerColumnGroup),
        body: this.createTableBody(value, columns, frozen),
        loadingBody: this.createTableLoadingBody(columns),
        frozenBody: this.props.frozenValue ? this.createTableBody(this.props.frozenValue, columns, true) : null,
        footer: this.createTableFooter(columns, footerColumnGroup),
        tableStyle: this.props.tableStyle,
        tableClassName: this.props.tableClassName,
        scrollHeight: this.props.scrollHeight,
        frozen: frozen,
        frozenWidth: this.props.frozenWidth,
        virtualScroll: this.props.virtualScroll,
        virtualRowHeight: this.props.virtualRowHeight,
        rows: this.props.rows,
        totalRecords: totalRecords,
        onVirtualScroll: this.onVirtualScroll,
        loading: this.props.loading
      });
    }
  }, {
    key: "getColumns",
    value: function getColumns() {
      var columns = _react.default.Children.toArray(this.props.children);

      if (columns && columns.length) {
        if (this.props.reorderableColumns && this.state.columnOrder) {
          var orderedColumns = [];

          var _iterator5 = _createForOfIteratorHelper(this.state.columnOrder),
              _step5;

          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var columnKey = _step5.value;
              var column = this.findColumnByKey(columns, columnKey);

              if (column) {
                orderedColumns.push(column);
              }
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }

          return [].concat(orderedColumns, _toConsumableArray(columns.filter(function (item) {
            return orderedColumns.indexOf(item) < 0;
          })));
        } else {
          return columns;
        }
      }

      return null;
    }
  }, {
    key: "findColumnByKey",
    value: function findColumnByKey(columns, key) {
      if (columns && columns.length) {
        for (var i = 0; i < columns.length; i++) {
          var child = columns[i];

          if (child.props.columnKey === key || child.props.field === key) {
            return child;
          }
        }
      }

      return null;
    }
  }, {
    key: "getTotalRecords",
    value: function getTotalRecords(data) {
      return this.props.lazy ? this.props.totalRecords : data ? data.length : 0;
    }
  }, {
    key: "reset",
    value: function reset() {
      var state = {};

      if (!this.props.onPage) {
        state.first = this.props.first;
        state.rows = this.props.rows;
      }

      if (!this.props.onSort) {
        state.sortField = this.props.sortField;
        state.sortOrder = this.props.sortOrder;
        state.multiSortMeta = this.props.multiSortMeta;
      }

      if (!this.props.onFilter) {
        state.filters = this.props.filters;
      }

      this.resetColumnOrder();

      if (Object.keys(state).length) {
        this.setState(state);
      }
    }
  }, {
    key: "resetColumnOrder",
    value: function resetColumnOrder() {
      var columns = _react.default.Children.toArray(this.props.children);

      var columnOrder = [];

      var _iterator6 = _createForOfIteratorHelper(columns),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var column = _step6.value;
          columnOrder.push(column.props.columnKey || column.props.field);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      this.setState({
        columnOrder: columnOrder
      });
    }
  }, {
    key: "renderLoader",
    value: function renderLoader() {
      var iconClassName = (0, _classnames.default)('p-datatable-loading-icon pi-spin', this.props.loadingIcon);
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "p-datatable-loading"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "p-datatable-loading-overlay p-component-overlay"
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "p-datatable-loading-content"
      }, /*#__PURE__*/_react.default.createElement("i", {
        className: iconClassName
      })));
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.isStateful() && this.props.resizableColumns) {
        this.restoreColumnWidths();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      if (this.isStateful()) {
        this.saveState();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this6 = this;

      var value = this.processData();
      var columns = this.getColumns();
      var totalRecords = this.getTotalRecords(value);
      var className = (0, _classnames.default)('p-datatable p-component', {
        'p-datatable-responsive': this.props.responsive,
        'p-datatable-resizable': this.props.resizableColumns,
        'p-datatable-resizable-fit': this.props.resizableColumns && this.props.columnResizeMode === 'fit',
        'p-datatable-scrollable': this.props.scrollable,
        'p-datatable-virtual-scrollable': this.props.virtualScroll,
        'p-datatable-auto-layout': this.props.autoLayout,
        'p-datatable-hoverable-rows': this.props.rowHover || this.props.selectionMode
      }, this.props.className);
      var paginatorTop = this.props.paginator && this.props.paginatorPosition !== 'bottom' && this.createPaginator('top', totalRecords);
      var paginatorBottom = this.props.paginator && this.props.paginatorPosition !== 'top' && this.createPaginator('bottom', totalRecords);

      var headerFacet = this.props.header && /*#__PURE__*/_react.default.createElement("div", {
        className: "p-datatable-header"
      }, this.props.header);

      var footerFacet = this.props.footer && /*#__PURE__*/_react.default.createElement("div", {
        className: "p-datatable-footer"
      }, this.props.footer);

      var resizeHelper = this.props.resizableColumns && /*#__PURE__*/_react.default.createElement("div", {
        ref: function ref(el) {
          _this6.resizerHelper = el;
        },
        className: "p-column-resizer-helper p-highlight",
        style: {
          display: 'none'
        }
      });

      var tableContent = null;

      var resizeIndicatorUp = this.props.reorderableColumns && /*#__PURE__*/_react.default.createElement("span", {
        ref: function ref(el) {
          _this6.reorderIndicatorUp = el;
        },
        className: "pi pi-arrow-down p-datatable-reorder-indicator-up",
        style: {
          position: 'absolute',
          display: 'none'
        }
      });

      var resizeIndicatorDown = this.props.reorderableColumns && /*#__PURE__*/_react.default.createElement("span", {
        ref: function ref(el) {
          _this6.reorderIndicatorDown = el;
        },
        className: "pi pi-arrow-up p-datatable-reorder-indicator-down",
        style: {
          position: 'absolute',
          display: 'none'
        }
      });

      var loader;

      if (this.props.loading) {
        loader = this.renderLoader();
      }

      if (Array.isArray(columns)) {
        if (this.props.scrollable) {
          this.frozenSelectionMode = this.frozenSelectionMode || this.getFrozenSelectionModeInColumn(columns);
          var frozenColumns = this.getFrozenColumns(columns);
          var scrollableColumns = frozenColumns ? this.getScrollableColumns(columns) : columns;
          var frozenView, scrollableView;

          if (frozenColumns) {
            frozenView = this.createScrollableView(value, frozenColumns, true, this.props.frozenHeaderColumnGroup, this.props.frozenFooterColumnGroup, totalRecords);
          }

          scrollableView = this.createScrollableView(value, scrollableColumns, false, this.props.headerColumnGroup, this.props.footerColumnGroup, totalRecords);
          tableContent = /*#__PURE__*/_react.default.createElement("div", {
            className: "p-datatable-scrollable-wrapper"
          }, frozenView, scrollableView);
        } else {
          var tableHeader = this.createTableHeader(value, columns, this.props.headerColumnGroup);
          var tableBody = this.createTableBody(value, columns, false);
          var tableFooter = this.createTableFooter(columns, this.props.footerColumnGroup);
          tableContent = /*#__PURE__*/_react.default.createElement("div", {
            className: "p-datatable-wrapper"
          }, /*#__PURE__*/_react.default.createElement("table", {
            style: this.props.tableStyle,
            role: "grid",
            className: this.props.tableClassName,
            ref: function ref(el) {
              _this6.table = el;
            }
          }, tableHeader, tableFooter, tableBody));
        }
      }

      return /*#__PURE__*/_react.default.createElement("div", {
        id: this.props.id,
        className: className,
        style: this.props.style,
        ref: function ref(el) {
          _this6.container = el;
        }
      }, loader, headerFacet, paginatorTop, tableContent, paginatorBottom, footerFacet, resizeHelper, resizeIndicatorUp, resizeIndicatorDown);
    }
  }]);

  return DataTable;
}(_react.Component);

exports.DataTable = DataTable;

_defineProperty(DataTable, "defaultProps", {
  id: null,
  value: null,
  header: null,
  footer: null,
  style: null,
  className: null,
  tableStyle: null,
  tableClassName: null,
  paginator: false,
  paginatorPosition: 'bottom',
  alwaysShowPaginator: true,
  paginatorTemplate: 'FirstPageLink PrevPageLink PageLinks NextPageLink LastPageLink RowsPerPageDropdown',
  paginatorLeft: null,
  paginatorRight: null,
  pageLinkSize: 5,
  rowsPerPageOptions: null,
  currentPageReportTemplate: '({currentPage} of {totalPages})',
  first: null,
  rows: null,
  totalRecords: null,
  lazy: false,
  sortField: null,
  sortOrder: null,
  multiSortMeta: null,
  sortMode: 'single',
  defaultSortOrder: 1,
  removableSort: false,
  emptyMessage: null,
  selectionMode: null,
  selection: null,
  onSelectionChange: null,
  contextMenuSelection: null,
  onContextMenuSelectionChange: null,
  compareSelectionBy: 'deepEquals',
  dataKey: null,
  metaKeySelection: true,
  headerColumnGroup: null,
  footerColumnGroup: null,
  frozenHeaderColumnGroup: null,
  frozenFooterColumnGroup: null,
  rowExpansionTemplate: null,
  expandedRows: null,
  onRowToggle: null,
  responsive: false,
  resizableColumns: false,
  columnResizeMode: 'fit',
  reorderableColumns: false,
  filters: null,
  globalFilter: null,
  filterLocale: undefined,
  scrollable: false,
  scrollHeight: null,
  virtualScroll: false,
  virtualScrollDelay: 150,
  virtualRowHeight: 28,
  frozenWidth: null,
  frozenValue: null,
  csvSeparator: ',',
  exportFilename: 'download',
  rowGroupMode: null,
  autoLayout: false,
  rowClassName: null,
  rowGroupHeaderTemplate: null,
  rowGroupFooterTemplate: null,
  loading: false,
  loadingIcon: 'pi pi-spinner',
  tabIndex: '0',
  stateKey: null,
  stateStorage: 'session',
  editMode: 'cell',
  expandableRowGroups: false,
  rowHover: false,
  showSelectionElement: null,
  showRowReorderElement: null,
  onColumnResizeEnd: null,
  onSort: null,
  onPage: null,
  onFilter: null,
  onVirtualScroll: null,
  onRowClick: null,
  onRowDoubleClick: null,
  onRowSelect: null,
  onRowUnselect: null,
  onRowExpand: null,
  onRowCollapse: null,
  onContextMenu: null,
  onColReorder: null,
  onRowReorder: null,
  onValueChange: null,
  rowEditorValidator: null,
  onRowEditInit: null,
  onRowEditSave: null,
  onRowEditCancel: null,
  exportFunction: null,
  customSaveState: null,
  customRestoreState: null,
  onStateSave: null,
  onStateRestore: null
});

_defineProperty(DataTable, "propTypes", {
  id: _propTypes.default.string,
  value: _propTypes.default.array,
  header: _propTypes.default.any,
  footer: _propTypes.default.any,
  style: _propTypes.default.object,
  className: _propTypes.default.string,
  tableStyle: _propTypes.default.any,
  tableClassName: _propTypes.default.string,
  paginator: _propTypes.default.bool,
  paginatorPosition: _propTypes.default.string,
  alwaysShowPaginator: _propTypes.default.bool,
  paginatorTemplate: _propTypes.default.string,
  paginatorLeft: _propTypes.default.any,
  paginatorRight: _propTypes.default.any,
  pageLinkSize: _propTypes.default.number,
  rowsPerPageOptions: _propTypes.default.array,
  currentPageReportTemplate: _propTypes.default.string,
  first: _propTypes.default.number,
  rows: _propTypes.default.number,
  totalRecords: _propTypes.default.number,
  lazy: _propTypes.default.bool,
  sortField: _propTypes.default.string,
  sortOrder: _propTypes.default.number,
  multiSortMeta: _propTypes.default.array,
  sortMode: _propTypes.default.string,
  defaultSortOrder: _propTypes.default.number,
  removableSort: _propTypes.default.bool,
  emptyMessage: _propTypes.default.any,
  selectionMode: _propTypes.default.string,
  selection: _propTypes.default.any,
  onSelectionChange: _propTypes.default.func,
  compareSelectionBy: _propTypes.default.string,
  dataKey: _propTypes.default.string,
  metaKeySelection: _propTypes.default.bool,
  headerColumnGroup: _propTypes.default.any,
  footerColumnGroup: _propTypes.default.any,
  frozenHeaderColumnGroup: _propTypes.default.any,
  frozenFooterColumnGroup: _propTypes.default.any,
  rowExpansionTemplate: _propTypes.default.func,
  expandedRows: _propTypes.default.oneOfType([_propTypes.default.array, _propTypes.default.object]),
  onRowToggle: _propTypes.default.func,
  responsive: _propTypes.default.bool,
  resizableColumns: _propTypes.default.bool,
  columnResizeMode: _propTypes.default.string,
  reorderableColumns: _propTypes.default.bool,
  filters: _propTypes.default.object,
  globalFilter: _propTypes.default.any,
  filterLocale: _propTypes.default.string,
  scrollable: _propTypes.default.bool,
  scrollHeight: _propTypes.default.string,
  virtualScroll: _propTypes.default.bool,
  virtualScrollDelay: _propTypes.default.number,
  virtualRowHeight: _propTypes.default.number,
  frozenWidth: _propTypes.default.string,
  frozenValue: _propTypes.default.array,
  csvSeparator: _propTypes.default.string,
  exportFilename: _propTypes.default.string,
  rowGroupMode: _propTypes.default.string,
  autoLayout: _propTypes.default.bool,
  rowClassName: _propTypes.default.func,
  rowGroupHeaderTemplate: _propTypes.default.func,
  rowGroupFooterTemplate: _propTypes.default.func,
  loading: _propTypes.default.bool,
  loadingIcon: _propTypes.default.string,
  tabIndex: _propTypes.default.string,
  stateKey: _propTypes.default.string,
  stateStorage: _propTypes.default.string,
  editMode: _propTypes.default.string,
  expandableRowGroups: _propTypes.default.bool,
  rowHover: _propTypes.default.bool,
  showSelectionElement: _propTypes.default.func,
  showRowReorderElement: _propTypes.default.func,
  onColumnResizeEnd: _propTypes.default.func,
  onSort: _propTypes.default.func,
  onPage: _propTypes.default.func,
  onFilter: _propTypes.default.func,
  onVirtualScroll: _propTypes.default.func,
  onRowClick: _propTypes.default.func,
  onRowDoubleClick: _propTypes.default.func,
  onRowSelect: _propTypes.default.func,
  onRowUnselect: _propTypes.default.func,
  onRowExpand: _propTypes.default.func,
  onRowCollapse: _propTypes.default.func,
  onContextMenu: _propTypes.default.func,
  onColReorder: _propTypes.default.func,
  onRowReorder: _propTypes.default.func,
  onValueChange: _propTypes.default.func,
  rowEditorValidator: _propTypes.default.func,
  onRowEditInit: _propTypes.default.func,
  onRowEditSave: _propTypes.default.func,
  onRowEditCancel: _propTypes.default.func,
  exportFunction: _propTypes.default.func,
  customSaveState: _propTypes.default.func,
  customRestoreState: _propTypes.default.func,
  onStateSave: _propTypes.default.func,
  onStateRestore: _propTypes.default.func
});