import * as React from 'react';
import TooltipOptions from '../tooltip/TooltipOptions';

interface MultiSelectProps {
    id?: string;
    name?: string;
    value?: any;
    options?: any[];
    optionLabel?: string;
    optionValue?: string;
    style?: object;
    className?: string;
    scrollHeight?: string;
    placeholder?: string;
    fixedPlaceholder?: boolean;
    disabled?: boolean;
    filter?: boolean;
    filterBy?: string;
    filterMatchMode?: string;
    filterPlaceholder?: string;
    filterLocale?: string;
    tabIndex?: boolean;
    dataKey?: string;
    inputId?: string;
    required?: boolean;
    appendTo?: HTMLElement;
    tooltip?: any;
    tooltipOptions?: TooltipOptions;
    ariaLabelledBy?: string;
    maxSelectedLabels?: number;
    selectedItemsLabel?: string;
    itemTemplate?(item: any): JSX.Element | undefined;
    selectedItemTemplate?(value: any): JSX.Element | undefined;
    onChange?(e: {originalEvent: Event, value: any, target: {name: string, id: string, value: any}}): void;
    onFocus?(event: Event): void;
    onBlur?(event: Event): void;
}

export class MultiSelect extends React.Component<MultiSelectProps,any> {}
