"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _DomHandler = _interopRequireDefault(require("../utils/DomHandler"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Tooltip = /*#__PURE__*/function () {
  function Tooltip(props) {
    _classCallCheck(this, Tooltip);

    this.target = props.target;
    this.targetContainer = props.targetContainer;
    this.content = props.content;
    this.options = props.options || {};
    this.options.event = this.options.event || 'hover';
    this.options.position = this.options.position || 'right';
    this.bindEvents();
  }

  _createClass(Tooltip, [{
    key: "bindEvents",
    value: function bindEvents() {
      if (this.options.event === 'hover') {
        this.mouseEnterListener = this.onMouseEnter.bind(this);
        this.mouseLeaveListener = this.onMouseLeave.bind(this);
        this.clickListener = this.onClick.bind(this);
        this.target.addEventListener('mouseenter', this.mouseEnterListener);
        this.target.addEventListener('mouseleave', this.mouseLeaveListener);
        this.target.addEventListener('click', this.clickListener);
      } else if (this.options.event === 'focus') {
        this.focusListener = this.onFocus.bind(this);
        this.blurListener = this.onBlur.bind(this);
        this.target.addEventListener('focus', this.focusListener);
        this.target.addEventListener('blur', this.blurListener);
      }
    }
  }, {
    key: "unbindEvents",
    value: function unbindEvents() {
      if (this.options.event === 'hover') {
        this.target.removeEventListener('mouseenter', this.mouseEnterListener);
        this.target.removeEventListener('mouseleave', this.mouseLeaveListener);
        this.target.removeEventListener('click', this.clickListener);
      } else if (this.options.event === 'focus') {
        this.target.removeEventListener('focus', this.focusListener);
        this.target.removeEventListener('blur', this.blurListener);
      }

      this.unbindDocumentResizeListener();
    }
  }, {
    key: "onMouseEnter",
    value: function onMouseEnter() {
      if (!this.container && !this.showTimeout) {
        this.activate();
      }
    }
  }, {
    key: "onMouseLeave",
    value: function onMouseLeave() {
      this.deactivate();
    }
  }, {
    key: "onFocus",
    value: function onFocus() {
      this.activate();
    }
  }, {
    key: "onBlur",
    value: function onBlur() {
      this.deactivate();
    }
  }, {
    key: "onClick",
    value: function onClick() {
      this.deactivate();
    }
  }, {
    key: "activate",
    value: function activate() {
      var _this = this;

      this.clearHideTimeout();
      if (this.options.showDelay) this.showTimeout = setTimeout(function () {
        _this.show();
      }, this.options.showDelay);else this.show();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      var _this2 = this;

      this.clearShowTimeout();
      if (this.options.hideDelay) this.hideTimeout = setTimeout(function () {
        _this2.hide();
      }, this.options.hideDelay);else this.hide();
    }
  }, {
    key: "clearShowTimeout",
    value: function clearShowTimeout() {
      if (this.showTimeout) {
        clearTimeout(this.showTimeout);
        this.showTimeout = null;
      }
    }
  }, {
    key: "clearHideTimeout",
    value: function clearHideTimeout() {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
        this.hideTimeout = null;
      }
    }
  }, {
    key: "clearTimeouts",
    value: function clearTimeouts() {
      this.clearShowTimeout();
      this.clearHideTimeout();
    }
  }, {
    key: "updateContent",
    value: function updateContent(content) {
      this.content = content;
    }
  }, {
    key: "show",
    value: function show() {
      if (!this.content) {
        return;
      }

      this.create();
      this.align();

      _DomHandler.default.fadeIn(this.container, 250);

      this.container.style.zIndex = ++_DomHandler.default.zindex;
      this.bindDocumentResizeListener();
    }
  }, {
    key: "hide",
    value: function hide() {
      this.remove();
    }
  }, {
    key: "create",
    value: function create() {
      this.container = document.createElement('div');
      var tooltipArrow = document.createElement('div');
      tooltipArrow.className = 'p-tooltip-arrow';
      this.container.appendChild(tooltipArrow);
      this.tooltipText = document.createElement('div');
      this.tooltipText.className = 'p-tooltip-text'; //todo: JSX support

      this.tooltipText.innerHTML = this.content;
      this.container.appendChild(this.tooltipText);
      document.body.appendChild(this.container);
      this.container.style.display = 'inline-block';
    }
  }, {
    key: "remove",
    value: function remove() {
      if (this.container && this.container.parentElement) {
        document.body.removeChild(this.container);
      }

      this.unbindDocumentResizeListener();
      this.clearTimeouts();
      this.container = null;
    }
  }, {
    key: "align",
    value: function align() {
      switch (this.options.position) {
        case 'top':
          this.alignTop();

          if (this.isOutOfBounds()) {
            this.alignBottom();
          }

          break;

        case 'bottom':
          this.alignBottom();

          if (this.isOutOfBounds()) {
            this.alignTop();
          }

          break;

        case 'left':
          this.alignLeft();

          if (this.isOutOfBounds()) {
            this.alignRight();

            if (this.isOutOfBounds()) {
              this.alignTop();

              if (this.isOutOfBounds()) {
                this.alignBottom();
              }
            }
          }

          break;

        case 'right':
          this.alignRight();

          if (this.isOutOfBounds()) {
            this.alignLeft();

            if (this.isOutOfBounds()) {
              this.alignTop();

              if (this.isOutOfBounds()) {
                this.alignBottom();
              }
            }
          }

          break;

        default:
          throw new Error('Invalid position:' + this.options.position);
      }
    }
  }, {
    key: "getHostOffset",
    value: function getHostOffset() {
      var target = this.targetContainer || this.target;
      var offset = target.getBoundingClientRect();

      var targetLeft = offset.left + _DomHandler.default.getWindowScrollLeft();

      var targetTop = offset.top + _DomHandler.default.getWindowScrollTop();

      return {
        left: targetLeft,
        top: targetTop
      };
    }
  }, {
    key: "alignRight",
    value: function alignRight() {
      this.preAlign('right');
      var target = this.targetContainer || this.target;
      var hostOffset = this.getHostOffset();

      var left = hostOffset.left + _DomHandler.default.getOuterWidth(target);

      var top = hostOffset.top + (_DomHandler.default.getOuterHeight(target) - _DomHandler.default.getOuterHeight(this.container)) / 2;
      this.container.style.left = left + 'px';
      this.container.style.top = top + 'px';
    }
  }, {
    key: "alignLeft",
    value: function alignLeft() {
      this.preAlign('left');
      var target = this.targetContainer || this.target;
      var hostOffset = this.getHostOffset();

      var left = hostOffset.left - _DomHandler.default.getOuterWidth(this.container);

      var top = hostOffset.top + (_DomHandler.default.getOuterHeight(target) - _DomHandler.default.getOuterHeight(this.container)) / 2;
      this.container.style.left = left + 'px';
      this.container.style.top = top + 'px';
    }
  }, {
    key: "alignTop",
    value: function alignTop() {
      this.preAlign('top');
      var target = this.targetContainer || this.target;
      var hostOffset = this.getHostOffset();
      var left = hostOffset.left + (_DomHandler.default.getOuterWidth(target) - _DomHandler.default.getOuterWidth(this.container)) / 2;

      var top = hostOffset.top - _DomHandler.default.getOuterHeight(this.container);

      this.container.style.left = left + 'px';
      this.container.style.top = top + 'px';
    }
  }, {
    key: "alignBottom",
    value: function alignBottom() {
      this.preAlign('bottom');
      var target = this.targetContainer || this.target;
      var hostOffset = this.getHostOffset();
      var left = hostOffset.left + (_DomHandler.default.getOuterWidth(target) - _DomHandler.default.getOuterWidth(this.container)) / 2;

      var top = hostOffset.top + _DomHandler.default.getOuterHeight(target);

      this.container.style.left = left + 'px';
      this.container.style.top = top + 'px';
    }
  }, {
    key: "preAlign",
    value: function preAlign(position) {
      this.container.style.left = -999 + 'px';
      this.container.style.top = -999 + 'px';
      var defaultClassName = 'p-tooltip p-component p-tooltip-' + position;
      this.container.className = this.options.className ? defaultClassName + ' ' + this.options.className : defaultClassName;
    }
  }, {
    key: "isOutOfBounds",
    value: function isOutOfBounds() {
      var offset = this.container.getBoundingClientRect();
      var targetTop = offset.top;
      var targetLeft = offset.left;

      var width = _DomHandler.default.getOuterWidth(this.container);

      var height = _DomHandler.default.getOuterHeight(this.container);

      var viewport = _DomHandler.default.getViewport();

      return targetLeft + width > viewport.width || targetLeft < 0 || targetTop < 0 || targetTop + height > viewport.height;
    }
  }, {
    key: "bindDocumentResizeListener",
    value: function bindDocumentResizeListener() {
      this.resizeListener = this.onWindowResize.bind(this);
      window.addEventListener('resize', this.resizeListener);
    }
  }, {
    key: "unbindDocumentResizeListener",
    value: function unbindDocumentResizeListener() {
      if (this.resizeListener) {
        window.removeEventListener('resize', this.resizeListener);
        this.resizeListener = null;
      }
    }
  }, {
    key: "onWindowResize",
    value: function onWindowResize() {
      this.hide();
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this.unbindEvents();
      this.remove();
      this.target = null;
      this.targetContainer = null;
    }
  }]);

  return Tooltip;
}();

exports.default = Tooltip;