"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ObjectUtils = _interopRequireDefault(require("./ObjectUtils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _createForOfIteratorHelper(o) { if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (o = _unsupportedIterableToArray(o))) { var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var it, normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var FilterUtils = /*#__PURE__*/function () {
  function FilterUtils() {
    _classCallCheck(this, FilterUtils);
  }

  _createClass(FilterUtils, null, [{
    key: "filter",
    value: function filter(value, fields, filterValue, filterMatchMode, filterLocale) {
      var filteredItems = [];

      var filterText = _ObjectUtils.default.removeAccents(filterValue).toLocaleLowerCase(filterLocale);

      if (value) {
        var _iterator = _createForOfIteratorHelper(value),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var item = _step.value;

            var _iterator2 = _createForOfIteratorHelper(fields),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var field = _step2.value;

                var fieldValue = _ObjectUtils.default.removeAccents(String(_ObjectUtils.default.resolveFieldData(item, field))).toLocaleLowerCase(filterLocale);

                if (FilterUtils[filterMatchMode](fieldValue, filterText, filterLocale)) {
                  filteredItems.push(item);
                  break;
                }
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      return filteredItems;
    }
  }, {
    key: "startsWith",
    value: function startsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.slice(0, filterValue.length) === filterValue;
    }
  }, {
    key: "contains",
    value: function contains(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.indexOf(filterValue) !== -1;
    }
  }, {
    key: "endsWith",
    value: function endsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
    }
  }, {
    key: "equals",
    value: function equals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() === filter.getTime();else return _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "notEquals",
    value: function notEquals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return false;
      }

      if (value === undefined || value === null) {
        return true;
      }

      if (value.getTime && filter.getTime) return value.getTime() !== filter.getTime();else return _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "in",
    value: function _in(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      for (var i = 0; i < filter.length; i++) {
        if (_ObjectUtils.default.equals(value, filter[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "lt",
    value: function lt(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() < filter.getTime();else return value < parseFloat(filter);
    }
  }, {
    key: "lte",
    value: function lte(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() <= filter.getTime();else return value <= parseFloat(filter);
    }
  }, {
    key: "gt",
    value: function gt(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() > filter.getTime();else return value > parseFloat(filter);
    }
  }, {
    key: "gte",
    value: function gte(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() >= filter.getTime();else return value >= parseFloat(filter);
    }
  }]);

  return FilterUtils;
}();

exports.default = FilterUtils;