/**
 *
 * DataTable Design Tokens
 *
 * @module datatable
 *
 */

import type { ColorScheme as CS, DesignTokens, ExtendedCSS, ExtendedTokens } from '..';

/**
 * Design Token Sections
 */
export declare namespace DataTableTokenSections {
    interface Root {
        /**
         * Transition duration of root
         *
         * @designToken datatable.transition.duration
         */
        transitionDuration?: string;
        /**
         * Border color of root
         *
         * @designToken datatable.border.color
         */
        borderColor?: string;
    }

    interface Header {
        /**
         * Background of header
         *
         * @designToken datatable.header.background
         */
        background?: string;
        /**
         * Border color of header
         *
         * @designToken datatable.header.border.color
         */
        borderColor?: string;
        /**
         * Color of header
         *
         * @designToken datatable.header.color
         */
        color?: string;
        /**
         * Border width of header
         *
         * @designToken datatable.header.border.width
         */
        borderWidth?: string;
        /**
         * Padding of header
         *
         * @designToken datatable.header.padding
         */
        padding?: string;
        /**
         * Sm of header
         */
        sm?: {
            /**
             * Sm padding of header
             *
             * @designToken datatable.header.sm.padding
             */
            padding?: string;
        };
        /**
         * Lg of header
         */
        lg?: {
            /**
             * Lg padding of header
             *
             * @designToken datatable.header.lg.padding
             */
            padding?: string;
        };
    }

    interface HeaderCell {
        /**
         * Background of header cell
         *
         * @designToken datatable.header.cell.background
         */
        background?: string;
        /**
         * Hover background of header cell
         *
         * @designToken datatable.header.cell.hover.background
         */
        hoverBackground?: string;
        /**
         * Selected background of header cell
         *
         * @designToken datatable.header.cell.selected.background
         */
        selectedBackground?: string;
        /**
         * Border color of header cell
         *
         * @designToken datatable.header.cell.border.color
         */
        borderColor?: string;
        /**
         * Color of header cell
         *
         * @designToken datatable.header.cell.color
         */
        color?: string;
        /**
         * Hover color of header cell
         *
         * @designToken datatable.header.cell.hover.color
         */
        hoverColor?: string;
        /**
         * Selected color of header cell
         *
         * @designToken datatable.header.cell.selected.color
         */
        selectedColor?: string;
        /**
         * Gap of header cell
         *
         * @designToken datatable.header.cell.gap
         */
        gap?: string;
        /**
         * Padding of header cell
         *
         * @designToken datatable.header.cell.padding
         */
        padding?: string;
        /**
         * Focus ring of header cell
         */
        focusRing?: {
            /**
             * Focus ring width of header cell
             *
             * @designToken datatable.header.cell.focus.ring.width
             */
            width?: string;
            /**
             * Focus ring style of header cell
             *
             * @designToken datatable.header.cell.focus.ring.style
             */
            style?: string;
            /**
             * Focus ring color of header cell
             *
             * @designToken datatable.header.cell.focus.ring.color
             */
            color?: string;
            /**
             * Focus ring offset of header cell
             *
             * @designToken datatable.header.cell.focus.ring.offset
             */
            offset?: string;
            /**
             * Focus ring shadow of header cell
             *
             * @designToken datatable.header.cell.focus.ring.shadow
             */
            shadow?: string;
        };
        /**
         * Sm of header cell
         */
        sm?: {
            /**
             * Sm padding of header cell
             *
             * @designToken datatable.header.cell.sm.padding
             */
            padding?: string;
        };
        /**
         * Lg of header cell
         */
        lg?: {
            /**
             * Lg padding of header cell
             *
             * @designToken datatable.header.cell.lg.padding
             */
            padding?: string;
        };
    }

    interface ColumnTitle {
        /**
         * Font weight of column title
         *
         * @designToken datatable.column.title.font.weight
         */
        fontWeight?: string;
    }

    interface Row {
        /**
         * Background of row
         *
         * @designToken datatable.row.background
         */
        background?: string;
        /**
         * Hover background of row
         *
         * @designToken datatable.row.hover.background
         */
        hoverBackground?: string;
        /**
         * Selected background of row
         *
         * @designToken datatable.row.selected.background
         */
        selectedBackground?: string;
        /**
         * Color of row
         *
         * @designToken datatable.row.color
         */
        color?: string;
        /**
         * Hover color of row
         *
         * @designToken datatable.row.hover.color
         */
        hoverColor?: string;
        /**
         * Selected color of row
         *
         * @designToken datatable.row.selected.color
         */
        selectedColor?: string;
        /**
         * Focus ring of row
         */
        focusRing?: {
            /**
             * Focus ring width of row
             *
             * @designToken datatable.row.focus.ring.width
             */
            width?: string;
            /**
             * Focus ring style of row
             *
             * @designToken datatable.row.focus.ring.style
             */
            style?: string;
            /**
             * Focus ring color of row
             *
             * @designToken datatable.row.focus.ring.color
             */
            color?: string;
            /**
             * Focus ring offset of row
             *
             * @designToken datatable.row.focus.ring.offset
             */
            offset?: string;
            /**
             * Focus ring shadow of row
             *
             * @designToken datatable.row.focus.ring.shadow
             */
            shadow?: string;
        };
        /**
         * Striped background of row
         *
         * @designToken datatable.row.striped.background
         */
        stripedBackground?: string;
    }

    interface BodyCell {
        /**
         * Border color of body cell
         *
         * @designToken datatable.body.cell.border.color
         */
        borderColor?: string;
        /**
         * Padding of body cell
         *
         * @designToken datatable.body.cell.padding
         */
        padding?: string;
        /**
         * Sm of body cell
         */
        sm?: {
            /**
             * Sm padding of body cell
             *
             * @designToken datatable.body.cell.sm.padding
             */
            padding?: string;
        };
        /**
         * Lg of body cell
         */
        lg?: {
            /**
             * Lg padding of body cell
             *
             * @designToken datatable.body.cell.lg.padding
             */
            padding?: string;
        };
        /**
         * Selected border color of body cell
         *
         * @designToken datatable.body.cell.selected.border.color
         */
        selectedBorderColor?: string;
    }

    interface FooterCell {
        /**
         * Background of footer cell
         *
         * @designToken datatable.footer.cell.background
         */
        background?: string;
        /**
         * Border color of footer cell
         *
         * @designToken datatable.footer.cell.border.color
         */
        borderColor?: string;
        /**
         * Color of footer cell
         *
         * @designToken datatable.footer.cell.color
         */
        color?: string;
        /**
         * Padding of footer cell
         *
         * @designToken datatable.footer.cell.padding
         */
        padding?: string;
        /**
         * Sm of footer cell
         */
        sm?: {
            /**
             * Sm padding of footer cell
             *
             * @designToken datatable.footer.cell.sm.padding
             */
            padding?: string;
        };
        /**
         * Lg of footer cell
         */
        lg?: {
            /**
             * Lg padding of footer cell
             *
             * @designToken datatable.footer.cell.lg.padding
             */
            padding?: string;
        };
    }

    interface ColumnFooter {
        /**
         * Font weight of column footer
         *
         * @designToken datatable.column.footer.font.weight
         */
        fontWeight?: string;
    }

    interface Footer {
        /**
         * Background of footer
         *
         * @designToken datatable.footer.background
         */
        background?: string;
        /**
         * Border color of footer
         *
         * @designToken datatable.footer.border.color
         */
        borderColor?: string;
        /**
         * Color of footer
         *
         * @designToken datatable.footer.color
         */
        color?: string;
        /**
         * Border width of footer
         *
         * @designToken datatable.footer.border.width
         */
        borderWidth?: string;
        /**
         * Padding of footer
         *
         * @designToken datatable.footer.padding
         */
        padding?: string;
        /**
         * Sm of footer
         */
        sm?: {
            /**
             * Sm padding of footer
             *
             * @designToken datatable.footer.sm.padding
             */
            padding?: string;
        };
        /**
         * Lg of footer
         */
        lg?: {
            /**
             * Lg padding of footer
             *
             * @designToken datatable.footer.lg.padding
             */
            padding?: string;
        };
    }

    interface DropPoint {
        /**
         * Color of drop point
         *
         * @designToken datatable.drop.point.color
         */
        color?: string;
    }

    interface ColumnResizer {
        /**
         * Width of column resizer
         *
         * @designToken datatable.column.resizer.width
         */
        width?: string;
    }

    interface ResizeIndicator {
        /**
         * Width of resize indicator
         *
         * @designToken datatable.resize.indicator.width
         */
        width?: string;
        /**
         * Color of resize indicator
         *
         * @designToken datatable.resize.indicator.color
         */
        color?: string;
    }

    interface SortIcon {
        /**
         * Color of sort icon
         *
         * @designToken datatable.sort.icon.color
         */
        color?: string;
        /**
         * Hover color of sort icon
         *
         * @designToken datatable.sort.icon.hover.color
         */
        hoverColor?: string;
        /**
         * Size of sort icon
         *
         * @designToken datatable.sort.icon.size
         */
        size?: string;
    }

    interface LoadingIcon {
        /**
         * Size of loading icon
         *
         * @designToken datatable.loading.icon.size
         */
        size?: string;
    }

    interface RowToggleButton {
        /**
         * Hover background of row toggle button
         *
         * @designToken datatable.row.toggle.button.hover.background
         */
        hoverBackground?: string;
        /**
         * Selected hover background of row toggle button
         *
         * @designToken datatable.row.toggle.button.selected.hover.background
         */
        selectedHoverBackground?: string;
        /**
         * Color of row toggle button
         *
         * @designToken datatable.row.toggle.button.color
         */
        color?: string;
        /**
         * Hover color of row toggle button
         *
         * @designToken datatable.row.toggle.button.hover.color
         */
        hoverColor?: string;
        /**
         * Selected hover color of row toggle button
         *
         * @designToken datatable.row.toggle.button.selected.hover.color
         */
        selectedHoverColor?: string;
        /**
         * Size of row toggle button
         *
         * @designToken datatable.row.toggle.button.size
         */
        size?: string;
        /**
         * Border radius of row toggle button
         *
         * @designToken datatable.row.toggle.button.border.radius
         */
        borderRadius?: string;
        /**
         * Focus ring of row toggle button
         */
        focusRing?: {
            /**
             * Focus ring width of row toggle button
             *
             * @designToken datatable.row.toggle.button.focus.ring.width
             */
            width?: string;
            /**
             * Focus ring style of row toggle button
             *
             * @designToken datatable.row.toggle.button.focus.ring.style
             */
            style?: string;
            /**
             * Focus ring color of row toggle button
             *
             * @designToken datatable.row.toggle.button.focus.ring.color
             */
            color?: string;
            /**
             * Focus ring offset of row toggle button
             *
             * @designToken datatable.row.toggle.button.focus.ring.offset
             */
            offset?: string;
            /**
             * Focus ring shadow of row toggle button
             *
             * @designToken datatable.row.toggle.button.focus.ring.shadow
             */
            shadow?: string;
        };
    }

    interface Filter {
        /**
         * Inline gap of filter
         *
         * @designToken datatable.filter.inline.gap
         */
        inlineGap?: string;
        /**
         * Overlay select of filter
         */
        overlaySelect?: {
            /**
             * Overlay select background of filter
             *
             * @designToken datatable.filter.overlay.select.background
             */
            background?: string;
            /**
             * Overlay select border color of filter
             *
             * @designToken datatable.filter.overlay.select.border.color
             */
            borderColor?: string;
            /**
             * Overlay select border radius of filter
             *
             * @designToken datatable.filter.overlay.select.border.radius
             */
            borderRadius?: string;
            /**
             * Overlay select color of filter
             *
             * @designToken datatable.filter.overlay.select.color
             */
            color?: string;
            /**
             * Overlay select shadow of filter
             *
             * @designToken datatable.filter.overlay.select.shadow
             */
            shadow?: string;
        };
        /**
         * Overlay popover of filter
         */
        overlayPopover?: {
            /**
             * Overlay popover background of filter
             *
             * @designToken datatable.filter.overlay.popover.background
             */
            background?: string;
            /**
             * Overlay popover border color of filter
             *
             * @designToken datatable.filter.overlay.popover.border.color
             */
            borderColor?: string;
            /**
             * Overlay popover border radius of filter
             *
             * @designToken datatable.filter.overlay.popover.border.radius
             */
            borderRadius?: string;
            /**
             * Overlay popover color of filter
             *
             * @designToken datatable.filter.overlay.popover.color
             */
            color?: string;
            /**
             * Overlay popover shadow of filter
             *
             * @designToken datatable.filter.overlay.popover.shadow
             */
            shadow?: string;
            /**
             * Overlay popover padding of filter
             *
             * @designToken datatable.filter.overlay.popover.padding
             */
            padding?: string;
            /**
             * Overlay popover gap of filter
             *
             * @designToken datatable.filter.overlay.popover.gap
             */
            gap?: string;
        };
        /**
         * Rule of filter
         */
        rule?: {
            /**
             * Rule border color of filter
             *
             * @designToken datatable.filter.rule.border.color
             */
            borderColor?: string;
        };
        /**
         * Constraint list of filter
         */
        constraintList?: {
            /**
             * Constraint list padding of filter
             *
             * @designToken datatable.filter.constraint.list.padding
             */
            padding?: string;
            /**
             * Constraint list gap of filter
             *
             * @designToken datatable.filter.constraint.list.gap
             */
            gap?: string;
        };
        /**
         * Constraint of filter
         */
        constraint?: {
            /**
             * Constraint focus background of filter
             *
             * @designToken datatable.filter.constraint.focus.background
             */
            focusBackground?: string;
            /**
             * Constraint selected background of filter
             *
             * @designToken datatable.filter.constraint.selected.background
             */
            selectedBackground?: string;
            /**
             * Constraint selected focus background of filter
             *
             * @designToken datatable.filter.constraint.selected.focus.background
             */
            selectedFocusBackground?: string;
            /**
             * Constraint color of filter
             *
             * @designToken datatable.filter.constraint.color
             */
            color?: string;
            /**
             * Constraint focus color of filter
             *
             * @designToken datatable.filter.constraint.focus.color
             */
            focusColor?: string;
            /**
             * Constraint selected color of filter
             *
             * @designToken datatable.filter.constraint.selected.color
             */
            selectedColor?: string;
            /**
             * Constraint selected focus color of filter
             *
             * @designToken datatable.filter.constraint.selected.focus.color
             */
            selectedFocusColor?: string;
            /**
             * Constraint separator of filter
             */
            separator?: {
                /**
                 * Constraint separator border color of filter
                 *
                 * @designToken datatable.filter.constraint.separator.border.color
                 */
                borderColor?: string;
            };
            /**
             * Constraint padding of filter
             *
             * @designToken datatable.filter.constraint.padding
             */
            padding?: string;
            /**
             * Constraint border radius of filter
             *
             * @designToken datatable.filter.constraint.border.radius
             */
            borderRadius?: string;
        };
    }

    interface PaginatorTop {
        /**
         * Border color of paginator top
         *
         * @designToken datatable.paginator.top.border.color
         */
        borderColor?: string;
        /**
         * Border width of paginator top
         *
         * @designToken datatable.paginator.top.border.width
         */
        borderWidth?: string;
    }

    interface PaginatorBottom {
        /**
         * Border color of paginator bottom
         *
         * @designToken datatable.paginator.bottom.border.color
         */
        borderColor?: string;
        /**
         * Border width of paginator bottom
         *
         * @designToken datatable.paginator.bottom.border.width
         */
        borderWidth?: string;
    }

    /* Static Sections */
    type ColorScheme = CS<DataTableDesignTokens>;
    type CSS = ExtendedCSS;
    type Extend = ExtendedTokens;
}

/**
 *
 * _DataTable Design Tokens_
 *
 * @group components
 * @module datatable
 * @see
 * --- ---
 * **Compatible Libraries**
 *
 * [![PrimeNG](https://i.postimg.cc/63f7jVST/primeng-icon-24.png)](https://primeng.org/theming/styled)
 * [![PrimeVue](https://i.postimg.cc/cC1vVgyh/primevue-icon-24.png)](https://primevue.org/theming/styled)
 * --- ---
 * **Figma UI Kit**
 *
 * [PrimeNG](https://primeng.org/uikit) | [PrimeVue](https://primevue.org/uikit)
 *
 */
export interface DataTableDesignTokens extends DesignTokens<DataTableDesignTokens> {
    /**
     * Used to pass tokens of the root section
     */
    root?: DataTableTokenSections.Root;
    /**
     * Used to pass tokens of the header section
     */
    header?: DataTableTokenSections.Header;
    /**
     * Used to pass tokens of the header cell section
     */
    headerCell?: DataTableTokenSections.HeaderCell;
    /**
     * Used to pass tokens of the column title section
     */
    columnTitle?: DataTableTokenSections.ColumnTitle;
    /**
     * Used to pass tokens of the row section
     */
    row?: DataTableTokenSections.Row;
    /**
     * Used to pass tokens of the body cell section
     */
    bodyCell?: DataTableTokenSections.BodyCell;
    /**
     * Used to pass tokens of the footer cell section
     */
    footerCell?: DataTableTokenSections.FooterCell;
    /**
     * Used to pass tokens of the column footer section
     */
    columnFooter?: DataTableTokenSections.ColumnFooter;
    /**
     * Used to pass tokens of the footer section
     */
    footer?: DataTableTokenSections.Footer;
    /**
     * Used to pass tokens of the drop point section
     */
    dropPoint?: DataTableTokenSections.DropPoint;
    /**
     * Used to pass tokens of the column resizer section
     */
    columnResizer?: DataTableTokenSections.ColumnResizer;
    /**
     * Used to pass tokens of the resize indicator section
     */
    resizeIndicator?: DataTableTokenSections.ResizeIndicator;
    /**
     * Used to pass tokens of the sort icon section
     */
    sortIcon?: DataTableTokenSections.SortIcon;
    /**
     * Used to pass tokens of the loading icon section
     */
    loadingIcon?: DataTableTokenSections.LoadingIcon;
    /**
     * Used to pass tokens of the row toggle button section
     */
    rowToggleButton?: DataTableTokenSections.RowToggleButton;
    /**
     * Used to pass tokens of the filter section
     */
    filter?: DataTableTokenSections.Filter;
    /**
     * Used to pass tokens of the paginator top section
     */
    paginatorTop?: DataTableTokenSections.PaginatorTop;
    /**
     * Used to pass tokens of the paginator bottom section
     */
    paginatorBottom?: DataTableTokenSections.PaginatorBottom;
}
