"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ObjectUtils = _interopRequireDefault(require("./ObjectUtils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var FilterUtils = /*#__PURE__*/function () {
  function FilterUtils() {
    _classCallCheck(this, FilterUtils);
  }

  _createClass(FilterUtils, null, [{
    key: "startsWith",
    value: function startsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.slice(0, filterValue.length) === filterValue;
    }
  }, {
    key: "contains",
    value: function contains(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.indexOf(filterValue) !== -1;
    }
  }, {
    key: "endsWith",
    value: function endsWith(value, filter, filterLocale) {
      if (filter === undefined || filter === null || filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      var filterValue = _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);

      var stringValue = _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale);

      return stringValue.indexOf(filterValue, stringValue.length - filterValue.length) !== -1;
    }
  }, {
    key: "equals",
    value: function equals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() === filter.getTime();else return _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) === _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "notEquals",
    value: function notEquals(value, filter, filterLocale) {
      if (filter === undefined || filter === null || typeof filter === 'string' && filter.trim() === '') {
        return false;
      }

      if (value === undefined || value === null) {
        return true;
      }

      if (value.getTime && filter.getTime) return value.getTime() !== filter.getTime();else return _ObjectUtils.default.removeAccents(value.toString()).toLocaleLowerCase(filterLocale) !== _ObjectUtils.default.removeAccents(filter.toString()).toLocaleLowerCase(filterLocale);
    }
  }, {
    key: "in",
    value: function _in(value, filter) {
      if (filter === undefined || filter === null || filter.length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      for (var i = 0; i < filter.length; i++) {
        if (_ObjectUtils.default.equals(value, filter[i])) {
          return true;
        }
      }

      return false;
    }
  }, {
    key: "lt",
    value: function lt(value, filter) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() < filter.getTime();else return value < parseFloat(filter);
    }
  }, {
    key: "lte",
    value: function lte(value, filter) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() <= filter.getTime();else return value <= parseFloat(filter);
    }
  }, {
    key: "gt",
    value: function gt(value, filter) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() > filter.getTime();else return value > parseFloat(filter);
    }
  }, {
    key: "gte",
    value: function gte(value, filter) {
      if (filter === undefined || filter === null || filter.trim && filter.trim().length === 0) {
        return true;
      }

      if (value === undefined || value === null) {
        return false;
      }

      if (value.getTime && filter.getTime) return value.getTime() >= filter.getTime();else return value >= parseFloat(filter);
    }
  }]);

  return FilterUtils;
}();

exports.default = FilterUtils;
