"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ConfirmationEventBus = _interopRequireDefault(require("./ConfirmationEventBus"));

var _useconfirm = require("../useconfirm");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = {
  install: function install(app) {
    var ConfirmationService = {
      require: function require(options) {
        _ConfirmationEventBus.default.emit('confirm', options);
      },
      close: function close() {
        _ConfirmationEventBus.default.emit('close');
      }
    };
    app.config.globalProperties.$confirm = ConfirmationService;
    app.provide(_useconfirm.PrimeVueConfirmSymbol, ConfirmationService);
  }
};
exports.default = _default;
