"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _ToastEventBus = _interopRequireDefault(require("./ToastEventBus"));

var _usetoast = require("../usetoast");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = {
  install: function install(app) {
    var ToastService = {
      add: function add(message) {
        _ToastEventBus.default.emit('add', message);
      },
      removeGroup: function removeGroup(group) {
        _ToastEventBus.default.emit('remove-group', group);
      },
      removeAllGroups: function removeAllGroups() {
        _ToastEventBus.default.emit('remove-all-groups');
      }
    };
    app.config.globalProperties.$toast = ToastService;
    app.provide(_usetoast.PrimeVueToastSymbol, ToastService);
  }
};
exports.default = _default;
