import e from"primevue/button";import t from"primevue/progressbar";import i from"primevue/message";import{DomHandler as l}from"primevue/utils";import s from"primevue/ripple";import{resolveComponent as o,resolveDirective as a,openBlock as n,createElementBlock as p,createElementVNode as d,withDirectives as r,normalizeClass as u,normalizeStyle as h,withKeys as c,toDisplayString as f,createBlock as m,createCommentVNode as g,Fragment as b,renderList as v,withCtx as y,createTextVNode as F,createVNode as C,renderSlot as B}from"vue";var L={name:"FileUpload",emits:["select","uploader","before-upload","progress","upload","error","before-send","clear","remove"],props:{name:{type:String,default:null},url:{type:String,default:null},mode:{type:String,default:"advanced"},multiple:{type:Boolean,default:!1},accept:{type:String,default:null},disabled:{type:Boolean,default:!1},auto:{type:Boolean,default:!1},maxFileSize:{type:Number,default:null},invalidFileSizeMessage:{type:String,default:"{0}: Invalid file size, file size should be smaller than {1}."},invalidFileTypeMessage:{type:String,default:"{0}: Invalid file type, allowed file types: {1}."},fileLimit:{type:Number,default:null},invalidFileLimitMessage:{type:String,default:"Maximum number of files exceeded, limit is {0} at most."},withCredentials:{type:Boolean,default:!1},previewWidth:{type:Number,default:50},chooseLabel:{type:String,default:null},uploadLabel:{type:String,default:null},cancelLabel:{type:String,default:null},customUpload:{type:Boolean,default:!1},showUploadButton:{type:Boolean,default:!0},showCancelButton:{type:Boolean,default:!0},chooseIcon:{type:String,default:"pi pi-plus"},uploadIcon:{type:String,default:"pi pi-upload"},cancelIcon:{type:String,default:"pi pi-times"},style:null,class:null},duplicateIEEvent:!1,data:()=>({uploadedFileCount:0,files:[],messages:[],focused:!1,progress:null}),methods:{onFileSelect(e){if("drop"!==e.type&&this.isIE11()&&this.duplicateIEEvent)return void(this.duplicateIEEvent=!1);this.messages=[],this.files=this.files||[];let t=e.dataTransfer?e.dataTransfer.files:e.target.files;for(let e of t)this.isFileSelected(e)||this.validate(e)&&(this.isImage(e)&&(e.objectURL=window.URL.createObjectURL(e)),this.files.push(e));this.$emit("select",{originalEvent:e,files:this.files}),this.fileLimit&&this.checkFileLimit(),this.auto&&this.hasFiles&&!this.isFileLimitExceeded()&&this.upload(),"drop"!==e.type&&this.isIE11()?this.clearIEInput():this.clearInputElement()},choose(){this.$refs.fileInput.click()},upload(){if(this.customUpload)this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.$emit("uploader",{files:this.files}),this.clear();else{let e=new XMLHttpRequest,t=new FormData;this.$emit("before-upload",{xhr:e,formData:t});for(let e of this.files)t.append(this.name,e,e.name);e.upload.addEventListener("progress",(e=>{e.lengthComputable&&(this.progress=Math.round(100*e.loaded/e.total)),this.$emit("progress",{originalEvent:e,progress:this.progress})})),e.onreadystatechange=()=>{4===e.readyState&&(this.progress=0,e.status>=200&&e.status<300?(this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.$emit("upload",{xhr:e,files:this.files})):this.$emit("error",{xhr:e,files:this.files}),this.clear())},e.open("POST",this.url,!0),this.$emit("before-send",{xhr:e,formData:t}),e.withCredentials=this.withCredentials,e.send(t)}},clear(){this.files=[],this.messages=null,this.$emit("clear"),this.isAdvanced&&this.clearInputElement()},onFocus(){this.focused=!0},onBlur(){this.focused=!1},isFileSelected(e){if(this.files&&this.files.length)for(let t of this.files)if(t.name+t.type+t.size===e.name+e.type+e.size)return!0;return!1},isIE11:()=>!!window.MSInputMethodContext&&!!document.documentMode,validate(e){return this.accept&&!this.isFileTypeValid(e)?(this.messages.push(this.invalidFileTypeMessage.replace("{0}",e.name).replace("{1}",this.accept)),!1):!(this.maxFileSize&&e.size>this.maxFileSize)||(this.messages.push(this.invalidFileSizeMessage.replace("{0}",e.name).replace("{1}",this.formatSize(this.maxFileSize))),!1)},isFileTypeValid(e){let t=this.accept.split(",").map((e=>e.trim()));for(let i of t){if(this.isWildcard(i)?this.getTypeClass(e.type)===this.getTypeClass(i):e.type==i||this.getFileExtension(e).toLowerCase()===i.toLowerCase())return!0}return!1},getTypeClass:e=>e.substring(0,e.indexOf("/")),isWildcard:e=>-1!==e.indexOf("*"),getFileExtension:e=>"."+e.name.split(".").pop(),isImage:e=>/^image\//.test(e.type),onDragEnter(e){this.disabled||(e.stopPropagation(),e.preventDefault())},onDragOver(e){this.disabled||(l.addClass(this.$refs.content,"p-fileupload-highlight"),e.stopPropagation(),e.preventDefault())},onDragLeave(){this.disabled||l.removeClass(this.$refs.content,"p-fileupload-highlight")},onDrop(e){if(!this.disabled){l.removeClass(this.$refs.content,"p-fileupload-highlight"),e.stopPropagation(),e.preventDefault();const t=e.dataTransfer?e.dataTransfer.files:e.target.files;(this.multiple||t&&1===t.length)&&this.onFileSelect(e)}},onBasicUploaderClick(){this.hasFiles?this.upload():this.$refs.fileInput.click()},remove(e){this.clearInputElement();let t=this.files.splice(e,1)[0];this.files=[...this.files],this.$emit("remove",{file:t,files:this.files})},clearInputElement(){this.$refs.fileInput.value=""},clearIEInput(){this.$refs.fileInput&&(this.duplicateIEEvent=!0,this.$refs.fileInput.value="")},formatSize(e){if(0===e)return"0 B";let t=Math.floor(Math.log(e)/Math.log(1e3));return parseFloat((e/Math.pow(1e3,t)).toFixed(3))+" "+["B","KB","MB","GB","TB","PB","EB","ZB","YB"][t]},isFileLimitExceeded(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount&&this.focused&&(this.focused=!1),this.fileLimit&&this.fileLimit<this.files.length+this.uploadedFileCount},checkFileLimit(){this.isFileLimitExceeded()&&this.messages.push(this.invalidFileLimitMessage.replace("{0}",this.fileLimit.toString()))},onMessageClose(){this.messages=null}},computed:{isAdvanced(){return"advanced"===this.mode},isBasic(){return"basic"===this.mode},advancedChooseButtonClass(){return["p-button p-component p-fileupload-choose",this.class,{"p-disabled":this.disabled,"p-focus":this.focused}]},basicChooseButtonClass(){return["p-button p-component p-fileupload-choose",this.class,{"p-fileupload-choose-selected":this.hasFiles,"p-disabled":this.disabled,"p-focus":this.focused}]},advancedChooseIconClass(){return["p-button-icon p-button-icon-left pi-fw",this.chooseIcon]},basicChooseButtonIconClass(){return["p-button-icon p-button-icon-left",!this.hasFiles||this.auto?this.uploadIcon:this.chooseIcon]},basicChooseButtonLabel(){return this.auto?this.chooseButtonLabel:this.hasFiles?this.files.map((e=>e.name)).join(", "):this.chooseButtonLabel},hasFiles(){return this.files&&this.files.length>0},chooseDisabled(){return this.disabled||this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount},uploadDisabled(){return this.disabled||!this.hasFiles||this.fileLimit&&this.fileLimit<this.files.length},cancelDisabled(){return this.disabled||!this.hasFiles},chooseButtonLabel(){return this.chooseLabel||this.$primevue.config.locale.choose},uploadButtonLabel(){return this.uploadLabel||this.$primevue.config.locale.upload},cancelButtonLabel(){return this.cancelLabel||this.$primevue.config.locale.cancel}},components:{FileUploadButton:e,FileUploadProgressBar:t,FileUploadMessage:i},directives:{ripple:s}};const I={key:0,class:"p-fileupload p-fileupload-advanced p-component"},w={class:"p-fileupload-buttonbar"},x=["multiple","accept","disabled"],S={class:"p-button-label"},k={key:1,class:"p-fileupload-files"},E=["alt","src","width"],D={class:"p-fileupload-filename"},M={key:2,class:"p-fileupload-empty"},$={key:1,class:"p-fileupload p-fileupload-basic p-component"},U={class:"p-button-label"},z=["accept","disabled","multiple"];!function(e,t){void 0===t&&(t={});var i=t.insertAt;if(e&&"undefined"!=typeof document){var l=document.head||document.getElementsByTagName("head")[0],s=document.createElement("style");s.type="text/css","top"===i&&l.firstChild?l.insertBefore(s,l.firstChild):l.appendChild(s),s.styleSheet?s.styleSheet.cssText=e:s.appendChild(document.createTextNode(e))}}("\n.p-fileupload-content {\n    position: relative;\n}\n.p-fileupload-row {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n}\n.p-fileupload-row > div {\n    -webkit-box-flex: 1;\n        -ms-flex: 1 1 auto;\n            flex: 1 1 auto;\n    width: 25%;\n}\n.p-fileupload-row > div:last-child {\n    text-align: right;\n}\n.p-fileupload-content .p-progressbar {\n    width: 100%;\n    position: absolute;\n    top: 0;\n    left: 0;\n}\n.p-button.p-fileupload-choose {\n    position: relative;\n    overflow: hidden;\n}\n.p-button.p-fileupload-choose input[type=file] {\n    display: none;\n}\n.p-fileupload-choose.p-fileupload-choose-selected input[type=file] {\n    display: none;\n}\n.p-fileupload-filename {\n    word-break: break-all;\n}\n.p-fluid .p-fileupload .p-button {\n    width: auto;\n}\n"),L.render=function(e,t,i,l,s,L){const T=o("FileUploadButton"),O=o("FileUploadProgressBar"),P=o("FileUploadMessage"),N=a("ripple");return L.isAdvanced?(n(),p("div",I,[d("div",w,[r((n(),p("span",{class:u(L.advancedChooseButtonClass),style:h(i.style),onClick:t[1]||(t[1]=(...e)=>L.choose&&L.choose(...e)),onKeydown:t[2]||(t[2]=c(((...e)=>L.choose&&L.choose(...e)),["enter"])),onFocus:t[3]||(t[3]=(...e)=>L.onFocus&&L.onFocus(...e)),onBlur:t[4]||(t[4]=(...e)=>L.onBlur&&L.onBlur(...e)),tabindex:"0"},[d("input",{ref:"fileInput",type:"file",onChange:t[0]||(t[0]=(...e)=>L.onFileSelect&&L.onFileSelect(...e)),multiple:i.multiple,accept:i.accept,disabled:L.chooseDisabled},null,40,x),d("span",{class:u(L.advancedChooseIconClass)},null,2),d("span",S,f(L.chooseButtonLabel),1)],38)),[[N]]),i.showUploadButton?(n(),m(T,{key:0,label:L.uploadButtonLabel,icon:i.uploadIcon,onClick:L.upload,disabled:L.uploadDisabled},null,8,["label","icon","onClick","disabled"])):g("",!0),i.showCancelButton?(n(),m(T,{key:1,label:L.cancelButtonLabel,icon:i.cancelIcon,onClick:L.clear,disabled:L.cancelDisabled},null,8,["label","icon","onClick","disabled"])):g("",!0)]),d("div",{ref:"content",class:"p-fileupload-content",onDragenter:t[5]||(t[5]=(...e)=>L.onDragEnter&&L.onDragEnter(...e)),onDragover:t[6]||(t[6]=(...e)=>L.onDragOver&&L.onDragOver(...e)),onDragleave:t[7]||(t[7]=(...e)=>L.onDragLeave&&L.onDragLeave(...e)),onDrop:t[8]||(t[8]=(...e)=>L.onDrop&&L.onDrop(...e))},[L.hasFiles?(n(),m(O,{key:0,value:s.progress},null,8,["value"])):g("",!0),(n(!0),p(b,null,v(s.messages,(e=>(n(),m(P,{severity:"error",key:e,onClose:L.onMessageClose},{default:y((()=>[F(f(e),1)])),_:2},1032,["onClose"])))),128)),L.hasFiles?(n(),p("div",k,[(n(!0),p(b,null,v(s.files,((e,t)=>(n(),p("div",{class:"p-fileupload-row",key:e.name+e.type+e.size},[d("div",null,[L.isImage(e)?(n(),p("img",{key:0,role:"presentation",alt:e.name,src:e.objectURL,width:i.previewWidth},null,8,E)):g("",!0)]),d("div",D,f(e.name),1),d("div",null,f(L.formatSize(e.size)),1),d("div",null,[C(T,{type:"button",icon:"pi pi-times",onClick:e=>L.remove(t)},null,8,["onClick"])])])))),128))])):g("",!0),e.$slots.empty&&!L.hasFiles?(n(),p("div",M,[B(e.$slots,"empty")])):g("",!0)],544)])):L.isBasic?(n(),p("div",$,[(n(!0),p(b,null,v(s.messages,(e=>(n(),m(P,{severity:"error",key:e,onClose:L.onMessageClose},{default:y((()=>[F(f(e),1)])),_:2},1032,["onClose"])))),128)),r((n(),p("span",{class:u(L.basicChooseButtonClass),style:h(i.style),onMouseup:t[12]||(t[12]=(...e)=>L.onBasicUploaderClick&&L.onBasicUploaderClick(...e)),onKeydown:t[13]||(t[13]=c(((...e)=>L.choose&&L.choose(...e)),["enter"])),onFocus:t[14]||(t[14]=(...e)=>L.onFocus&&L.onFocus(...e)),onBlur:t[15]||(t[15]=(...e)=>L.onBlur&&L.onBlur(...e)),tabindex:"0"},[d("span",{class:u(L.basicChooseButtonIconClass)},null,2),d("span",U,f(L.basicChooseButtonLabel),1),L.hasFiles?g("",!0):(n(),p("input",{key:0,ref:"fileInput",type:"file",accept:i.accept,disabled:i.disabled,multiple:i.multiple,onChange:t[9]||(t[9]=(...e)=>L.onFileSelect&&L.onFileSelect(...e)),onFocus:t[10]||(t[10]=(...e)=>L.onFocus&&L.onFocus(...e)),onBlur:t[11]||(t[11]=(...e)=>L.onBlur&&L.onBlur(...e))},null,40,z))],38)),[[N]])])):g("",!0)};export{L as default};
