import{openBlock as e,createElementBlock as t,normalizeClass as i,createElementVNode as a,toDisplayString as s,createCommentVNode as n}from"vue";var o={name:"Knob",emits:["update:modelValue","change"],data:()=>({radius:40,midX:50,midY:50,minRadians:4*Math.PI/3,maxRadians:-Math.PI/3}),props:{modelValue:{type:Number,default:null},size:{type:Number,default:100},disabled:{type:Boolean,default:!1},readonly:{type:Boolean,default:!1},step:{type:Number,default:1},min:{type:Number,default:0},max:{type:Number,default:100},valueColor:{type:String,default:"var(--primary-color, Black)"},rangeColor:{type:String,default:"var(--surface-border, LightGray)"},textColor:{type:String,default:"var(--text-color-secondary, Black)"},strokeWidth:{type:Number,default:14},showValue:{type:Boolean,default:!0},valueTemplate:{type:String,default:"{value}"}},methods:{updateValue(e,t){let i=e-this.size/2,a=this.size/2-t,s=Math.atan2(a,i),n=-Math.PI/2-Math.PI/6;this.updateModel(s,n)},updateModel(e,t){let i;if(e>this.maxRadians)i=this.mapRange(e,this.minRadians,this.maxRadians,this.min,this.max);else{if(!(e<t))return;i=this.mapRange(e+2*Math.PI,this.minRadians,this.maxRadians,this.min,this.max)}let a=Math.round((i-this.min)/this.step)*this.step+this.min;this.$emit("update:modelValue",a),this.$emit("change",a)},mapRange:(e,t,i,a,s)=>(e-t)*(s-a)/(i-t)+a,onClick(e){this.disabled||this.readonly||this.updateValue(e.offsetX,e.offsetY)},onMouseDown(e){this.disabled||this.readonly||(window.addEventListener("mousemove",this.onMouseMove),window.addEventListener("mouseup",this.onMouseUp),e.preventDefault())},onMouseUp(e){this.disabled||this.readonly||(window.removeEventListener("mousemove",this.onMouseMove),window.removeEventListener("mouseup",this.onMouseUp),e.preventDefault())},onTouchStart(e){this.disabled||this.readonly||(window.addEventListener("touchmove",this.onTouchMove),window.addEventListener("touchend",this.onTouchEnd),e.preventDefault())},onTouchEnd(e){this.disabled||this.readonly||(window.removeEventListener("touchmove",this.onTouchMove),window.removeEventListener("touchend",this.onTouchEnd),e.preventDefault())},onMouseMove(e){this.disabled||this.readonly||(this.updateValue(e.offsetX,e.offsetY),e.preventDefault())},onTouchMove(e){if(!this.disabled&&!this.readonly&&1==e.touches.length){const t=this.$el.getBoundingClientRect(),i=e.targetTouches.item(0),a=i.clientX-t.left,s=i.clientY-t.top;this.updateValue(a,s)}}},computed:{containerClass(){return["p-knob p-component",{"p-disabled":this.disabled}]},rangePath(){return`M ${this.minX} ${this.minY} A ${this.radius} ${this.radius} 0 1 1 ${this.maxX} ${this.maxY}`},valuePath(){return`M ${this.zeroX} ${this.zeroY} A ${this.radius} ${this.radius} 0 ${this.largeArc} ${this.sweep} ${this.valueX} ${this.valueY}`},zeroRadians(){return this.min>0&&this.max>0?this.mapRange(this.min,this.min,this.max,this.minRadians,this.maxRadians):this.mapRange(0,this.min,this.max,this.minRadians,this.maxRadians)},valueRadians(){return this.mapRange(this.modelValue,this.min,this.max,this.minRadians,this.maxRadians)},minX(){return this.midX+Math.cos(this.minRadians)*this.radius},minY(){return this.midY-Math.sin(this.minRadians)*this.radius},maxX(){return this.midX+Math.cos(this.maxRadians)*this.radius},maxY(){return this.midY-Math.sin(this.maxRadians)*this.radius},zeroX(){return this.midX+Math.cos(this.zeroRadians)*this.radius},zeroY(){return this.midY-Math.sin(this.zeroRadians)*this.radius},valueX(){return this.midX+Math.cos(this.valueRadians)*this.radius},valueY(){return this.midY-Math.sin(this.valueRadians)*this.radius},largeArc(){return Math.abs(this.zeroRadians-this.valueRadians)<Math.PI?0:1},sweep(){return this.valueRadians>this.zeroRadians?0:1},valueToDisplay(){return this.valueTemplate.replace(/{value}/g,this.modelValue)}}};const h=["width","height"],d=["d","stroke-width","stroke"],r=["d","stroke-width","stroke"],u=["fill"];!function(e,t){void 0===t&&(t={});var i=t.insertAt;if(e&&"undefined"!=typeof document){var a=document.head||document.getElementsByTagName("head")[0],s=document.createElement("style");s.type="text/css","top"===i&&a.firstChild?a.insertBefore(s,a.firstChild):a.appendChild(s),s.styleSheet?s.styleSheet.cssText=e:s.appendChild(document.createTextNode(e))}}("\n@-webkit-keyframes dash-frame {\n100% {\n        stroke-dashoffset: 0;\n}\n}\n@keyframes dash-frame {\n100% {\n        stroke-dashoffset: 0;\n}\n}\n.p-knob-range {\n    fill: none;\n    -webkit-transition: stroke .1s ease-in;\n    transition: stroke .1s ease-in;\n}\n.p-knob-value {\n    -webkit-animation-name: dash-frame;\n            animation-name: dash-frame;\n    -webkit-animation-fill-mode: forwards;\n            animation-fill-mode: forwards;\n    fill: none;\n}\n.p-knob-text {\n    font-size: 1.3rem;\n    text-align: center;\n}\n"),o.render=function(o,l,m,p,c,f){return e(),t("div",{class:i(f.containerClass)},[(e(),t("svg",{viewBox:"0 0 100 100",width:m.size,height:m.size,onClick:l[0]||(l[0]=(...e)=>f.onClick&&f.onClick(...e)),onMousedown:l[1]||(l[1]=(...e)=>f.onMouseDown&&f.onMouseDown(...e)),onMouseup:l[2]||(l[2]=(...e)=>f.onMouseUp&&f.onMouseUp(...e)),onTouchstart:l[3]||(l[3]=(...e)=>f.onTouchStart&&f.onTouchStart(...e)),onTouchend:l[4]||(l[4]=(...e)=>f.onTouchEnd&&f.onTouchEnd(...e))},[a("path",{d:f.rangePath,"stroke-width":m.strokeWidth,stroke:m.rangeColor,class:"p-knob-range"},null,8,d),a("path",{d:f.valuePath,"stroke-width":m.strokeWidth,stroke:m.valueColor,class:"p-knob-value"},null,8,r),m.showValue?(e(),t("text",{key:0,x:50,y:57,"text-anchor":"middle",fill:m.textColor,class:"p-knob-text"},s(f.valueToDisplay),9,u)):n("",!0)],40,h))],2)};export{o as default};
