"use strict";var e=require("primevue/button"),t=require("primevue/ripple"),i=require("primevue/tooltip"),n=require("primevue/utils"),s=require("vue");function l(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var o=l(e),r=l(t),a=l(i),c={name:"SpeedDial",emits:["click","show","hide"],props:{model:null,visible:{type:Boolean,default:!1},direction:{type:String,default:"up"},transitionDelay:{type:Number,default:30},type:{type:String,default:"linear"},radius:{type:Number,default:0},mask:{type:Boolean,default:!1},disabled:{type:Boolean,default:!1},hideOnClickOutside:{type:Boolean,default:!0},buttonClass:null,maskStyle:null,maskClass:null,showIcon:{type:String,default:"pi pi-plus"},hideIcon:null,rotateAnimation:{type:Boolean,default:!0},tooltipOptions:null,style:null,class:null},documentClickListener:null,container:null,list:null,data(){return{d_visible:this.visible,isItemClicked:!1}},watch:{visible(e){this.d_visible=e}},mounted(){if("linear"!==this.type){const e=n.DomHandler.findSingle(this.container,".p-speeddial-button"),t=n.DomHandler.findSingle(this.list,".p-speeddial-item");if(e&&t){const i=Math.abs(e.offsetWidth-t.offsetWidth),n=Math.abs(e.offsetHeight-t.offsetHeight);this.list.style.setProperty("--item-diff-x",i/2+"px"),this.list.style.setProperty("--item-diff-y",n/2+"px")}}this.hideOnClickOutside&&this.bindDocumentClickListener()},beforeMount(){this.unbindDocumentClickListener()},methods:{onItemClick(e,t){t.command&&t.command({originalEvent:e,item:t}),this.hide(),this.isItemClicked=!0,e.preventDefault()},onClick(e){this.d_visible?this.hide():this.show(),this.isItemClicked=!0,this.$emit("click",e)},show(){this.d_visible=!0,this.$emit("show")},hide(){this.d_visible=!1,this.$emit("hide")},calculateTransitionDelay(e){const t=this.model.length;return(this.d_visible?e:t-e-1)*this.transitionDelay},calculatePointStyle(e){const t=this.type;if("linear"!==t){const i=this.model.length,n=this.radius||20*i;if("circle"===t){const t=2*Math.PI/i;return{left:`calc(${n*Math.cos(t*e)}px + var(--item-diff-x, 0px))`,top:`calc(${n*Math.sin(t*e)}px + var(--item-diff-y, 0px))`}}if("semi-circle"===t){const t=this.direction,s=Math.PI/(i-1),l=`calc(${n*Math.cos(s*e)}px + var(--item-diff-x, 0px))`,o=`calc(${n*Math.sin(s*e)}px + var(--item-diff-y, 0px))`;if("up"===t)return{left:l,bottom:o};if("down"===t)return{left:l,top:o};if("left"===t)return{right:o,top:l};if("right"===t)return{left:o,top:l}}else if("quarter-circle"===t){const t=this.direction,s=Math.PI/(2*(i-1)),l=`calc(${n*Math.cos(s*e)}px + var(--item-diff-x, 0px))`,o=`calc(${n*Math.sin(s*e)}px + var(--item-diff-y, 0px))`;if("up-left"===t)return{right:l,bottom:o};if("up-right"===t)return{left:l,bottom:o};if("down-left"===t)return{right:o,top:l};if("down-right"===t)return{left:o,top:l}}}return{}},getItemStyle(e){return{transitionDelay:`${this.calculateTransitionDelay(e)}ms`,...this.calculatePointStyle(e)}},bindDocumentClickListener(){this.documentClickListener||(this.documentClickListener=e=>{this.d_visible&&this.isOutsideClicked(e)&&this.hide(),this.isItemClicked=!1},document.addEventListener("click",this.documentClickListener))},unbindDocumentClickListener(){this.documentClickListener&&(document.removeEventListener("click",this.documentClickListener),this.documentClickListener=null)},isOutsideClicked(e){return this.container&&!(this.container.isSameNode(e.target)||this.container.contains(e.target)||this.isItemClicked)},containerRef(e){this.container=e},listRef(e){this.list=e}},computed:{containerClass(){return[`p-speeddial p-component p-speeddial-${this.type}`,{[`p-speeddial-direction-${this.direction}`]:"circle"!==this.type,"p-speeddial-opened":this.d_visible,"p-disabled":this.disabled},this.class]},buttonClassName(){return["p-speeddial-button p-button-rounded",{"p-speeddial-rotate":this.rotateAnimation&&!this.hideIcon},this.buttonClass]},iconClassName(){return this.d_visible&&this.hideIcon?this.hideIcon:this.showIcon},maskClassName(){return["p-speeddial-mask",{"p-speeddial-mask-visible":this.d_visible},this.maskClass]}},components:{SDButton:o.default},directives:{ripple:r.default,tooltip:a.default}};const d=["href","target","onClick"];!function(e,t){void 0===t&&(t={});var i=t.insertAt;if(e&&"undefined"!=typeof document){var n=document.head||document.getElementsByTagName("head")[0],s=document.createElement("style");s.type="text/css","top"===i&&n.firstChild?n.insertBefore(s,n.firstChild):n.appendChild(s),s.styleSheet?s.styleSheet.cssText=e:s.appendChild(document.createTextNode(e))}}("\n.p-speeddial {\n    position: absolute;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    z-index: 1;\n}\n.p-speeddial-list {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-transition: top 0s linear 0.2s;\n    transition: top 0s linear 0.2s;\n    pointer-events: none;\n}\n.p-speeddial-item {\n    -webkit-transform: scale(0);\n            transform: scale(0);\n    opacity: 0;\n    -webkit-transition: opacity 0.8s, -webkit-transform 200ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    transition: opacity 0.8s, -webkit-transform 200ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    transition: transform 200ms cubic-bezier(0.4, 0, 0.2, 1) 0ms, opacity 0.8s;\n    transition: transform 200ms cubic-bezier(0.4, 0, 0.2, 1) 0ms, opacity 0.8s, -webkit-transform 200ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    will-change: transform;\n}\n.p-speeddial-action {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    border-radius: 50%;\n    position: relative;\n    overflow: hidden;\n}\n.p-speeddial-circle .p-speeddial-item,\n.p-speeddial-semi-circle .p-speeddial-item,\n.p-speeddial-quarter-circle .p-speeddial-item {\n    position: absolute;\n}\n.p-speeddial-rotate {\n    -webkit-transition: -webkit-transform 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    transition: -webkit-transform 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    transition: transform 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    transition: transform 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms, -webkit-transform 250ms cubic-bezier(0.4, 0, 0.2, 1) 0ms;\n    will-change: transform;\n}\n.p-speeddial-mask {\n    position: absolute;\n    left: 0;\n    top: 0;\n    width: 100%;\n    height: 100%;\n    opacity: 0;\n    -webkit-transition: opacity 250ms cubic-bezier(0.25, 0.8, 0.25, 1);\n    transition: opacity 250ms cubic-bezier(0.25, 0.8, 0.25, 1);\n}\n.p-speeddial-mask-visible {\n    pointer-events: none;\n    opacity: 1;\n    -webkit-transition: opacity 400ms cubic-bezier(0.25, 0.8, 0.25, 1);\n    transition: opacity 400ms cubic-bezier(0.25, 0.8, 0.25, 1);\n}\n.p-speeddial-opened .p-speeddial-list {\n    pointer-events: auto;\n}\n.p-speeddial-opened .p-speeddial-item {\n    -webkit-transform: scale(1);\n            transform: scale(1);\n    opacity: 1;\n}\n.p-speeddial-opened .p-speeddial-rotate {\n    -webkit-transform: rotate(45deg);\n            transform: rotate(45deg);\n}\n\n/* Direction */\n.p-speeddial-direction-up {\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: reverse;\n        -ms-flex-direction: column-reverse;\n            flex-direction: column-reverse;\n}\n.p-speeddial-direction-up .p-speeddial-list {\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: reverse;\n        -ms-flex-direction: column-reverse;\n            flex-direction: column-reverse;\n}\n.p-speeddial-direction-down {\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n}\n.p-speeddial-direction-down .p-speeddial-list {\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n}\n.p-speeddial-direction-left {\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-orient: horizontal;\n    -webkit-box-direction: reverse;\n        -ms-flex-direction: row-reverse;\n            flex-direction: row-reverse;\n}\n.p-speeddial-direction-left .p-speeddial-list {\n    -webkit-box-orient: horizontal;\n    -webkit-box-direction: reverse;\n        -ms-flex-direction: row-reverse;\n            flex-direction: row-reverse;\n}\n.p-speeddial-direction-right {\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    -webkit-box-orient: horizontal;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: row;\n            flex-direction: row;\n}\n.p-speeddial-direction-right .p-speeddial-list {\n    -webkit-box-orient: horizontal;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: row;\n            flex-direction: row;\n}\n"),c.render=function(e,t,i,n,l,o){const r=s.resolveComponent("SDButton"),a=s.resolveDirective("tooltip"),c=s.resolveDirective("ripple");return s.openBlock(),s.createElementBlock(s.Fragment,null,[s.createElementVNode("div",{ref:o.containerRef,class:s.normalizeClass(o.containerClass),style:s.normalizeStyle(i.style)},[s.renderSlot(e.$slots,"button",{toggle:o.onClick},(()=>[s.createVNode(r,{type:"button",class:s.normalizeClass(o.buttonClassName),icon:o.iconClassName,onClick:t[0]||(t[0]=e=>o.onClick(e)),disabled:i.disabled},null,8,["class","icon","disabled"])])),s.createElementVNode("ul",{ref:o.listRef,class:"p-speeddial-list",role:"menu"},[(s.openBlock(!0),s.createElementBlock(s.Fragment,null,s.renderList(i.model,((t,n)=>(s.openBlock(),s.createElementBlock("li",{key:n,class:"p-speeddial-item",style:s.normalizeStyle(o.getItemStyle(n)),role:"none"},[e.$slots.item?(s.openBlock(),s.createBlock(s.resolveDynamicComponent(e.$slots.item),{key:1,item:t},null,8,["item"])):s.withDirectives((s.openBlock(),s.createElementBlock("a",{key:0,href:t.url||"#",role:"menuitem",class:s.normalizeClass(["p-speeddial-action",{"p-disabled":t.disabled}]),target:t.target,onClick:e=>o.onItemClick(e,t)},[t.icon?(s.openBlock(),s.createElementBlock("span",{key:0,class:s.normalizeClass(["p-speeddial-action-icon",t.icon])},null,2)):s.createCommentVNode("",!0)],10,d)),[[a,{value:t.label,disabled:!i.tooltipOptions},i.tooltipOptions],[c]])],4)))),128))],512)],6),i.mask?(s.openBlock(),s.createElementBlock("div",{key:0,class:s.normalizeClass(o.maskClassName),style:s.normalizeStyle(i.maskStyle)},null,6)):s.createCommentVNode("",!0)],64)},module.exports=c;
