"use strict";var e=require("primevue/utils"),t=require("vue"),n={name:"Splitter",emits:["resizeend"],props:{layout:{type:String,default:"horizontal"},gutterSize:{type:Number,default:4},stateKey:{type:String,default:null},stateStorage:{type:String,default:"session"}},dragging:!1,mouseMoveListener:null,mouseUpListener:null,size:null,gutterElement:null,startPos:null,prevPanelElement:null,nextPanelElement:null,nextPanelSize:null,prevPanelSize:null,panelSizes:null,prevPanelIndex:null,mounted(){if(this.panels&&this.panels.length){let t=!1;if(this.isStateful()&&(t=this.restoreState()),!t){let t=[...this.$el.children].filter((t=>e.DomHandler.hasClass(t,"p-splitter-panel"))),n=[];this.panels.map(((e,s)=>{let i=(e.props&&e.props.size?e.props.size:null)||100/this.panels.length;n[s]=i,t[s].style.flexBasis="calc("+i+"% - "+(this.panels.length-1)*this.gutterSize+"px)"})),this.panelSizes=n}}},beforeUnmount(){this.clear(),this.unbindMouseListeners()},methods:{isSplitterPanel:e=>"SplitterPanel"===e.type.name,onResizeStart(t,n){this.gutterElement=t.currentTarget,this.size=this.horizontal?e.DomHandler.getWidth(this.$el):e.DomHandler.getHeight(this.$el),this.dragging=!0,this.startPos="horizontal"===this.layout?t.pageX:t.pageY,this.prevPanelElement=this.gutterElement.previousElementSibling,this.nextPanelElement=this.gutterElement.nextElementSibling,this.prevPanelSize=100*(this.horizontal?e.DomHandler.getOuterWidth(this.prevPanelElement,!0):e.DomHandler.getOuterHeight(this.prevPanelElement,!0))/this.size,this.nextPanelSize=100*(this.horizontal?e.DomHandler.getOuterWidth(this.nextPanelElement,!0):e.DomHandler.getOuterHeight(this.nextPanelElement,!0))/this.size,this.prevPanelIndex=n,e.DomHandler.addClass(this.gutterElement,"p-splitter-gutter-resizing"),e.DomHandler.addClass(this.$el,"p-splitter-resizing")},onResize(e){let t;t=this.horizontal?100*e.pageX/this.size-100*this.startPos/this.size:100*e.pageY/this.size-100*this.startPos/this.size;let n=this.prevPanelSize+t,s=this.nextPanelSize-t;this.validateResize(n,s)&&(this.prevPanelElement.style.flexBasis="calc("+n+"% - "+(this.panels.length-1)*this.gutterSize+"px)",this.nextPanelElement.style.flexBasis="calc("+s+"% - "+(this.panels.length-1)*this.gutterSize+"px)",this.panelSizes[this.prevPanelIndex]=n,this.panelSizes[this.prevPanelIndex+1]=s)},onResizeEnd(t){this.isStateful()&&this.saveState(),this.$emit("resizeend",{originalEvent:t,sizes:this.panelSizes}),e.DomHandler.removeClass(this.gutterElement,"p-splitter-gutter-resizing"),e.DomHandler.removeClass(this.$el,"p-splitter-resizing"),this.clear()},onGutterMouseDown(e,t){this.onResizeStart(e,t),this.bindMouseListeners()},onGutterTouchStart(e,t){this.onResizeStart(e,t),e.preventDefault()},onGutterTouchMove(e){this.onResize(e),e.preventDefault()},onGutterTouchEnd(e){this.onResizeEnd(e),e.preventDefault()},bindMouseListeners(){this.mouseMoveListener||(this.mouseMoveListener=e=>this.onResize(e),document.addEventListener("mousemove",this.mouseMoveListener)),this.mouseUpListener||(this.mouseUpListener=e=>{this.onResizeEnd(e),this.unbindMouseListeners()},document.addEventListener("mouseup",this.mouseUpListener))},validateResize(t,n){let s=e.ObjectUtils.getVNodeProp(this.panels[0],"minSize");if(this.panels[0].props&&s&&s>t)return!1;let i=e.ObjectUtils.getVNodeProp(this.panels[1],"minSize");return!(this.panels[1].props&&i&&i>n)},unbindMouseListeners(){this.mouseMoveListener&&(document.removeEventListener("mousemove",this.mouseMoveListener),this.mouseMoveListener=null),this.mouseUpListener&&(document.removeEventListener("mouseup",this.mouseUpListener),this.mouseUpListener=null)},clear(){this.dragging=!1,this.size=null,this.startPos=null,this.prevPanelElement=null,this.nextPanelElement=null,this.prevPanelSize=null,this.nextPanelSize=null,this.gutterElement=null,this.prevPanelIndex=null},isStateful(){return null!=this.stateKey},getStorage(){switch(this.stateStorage){case"local":return window.localStorage;case"session":return window.sessionStorage;default:throw new Error(this.stateStorage+' is not a valid value for the state storage, supported values are "local" and "session".')}},saveState(){this.getStorage().setItem(this.stateKey,JSON.stringify(this.panelSizes))},restoreState(){const t=this.getStorage().getItem(this.stateKey);if(t){return this.panelSizes=JSON.parse(t),[...this.$el.children].filter((t=>e.DomHandler.hasClass(t,"p-splitter-panel"))).forEach(((e,t)=>{e.style.flexBasis="calc("+this.panelSizes[t]+"% - "+(this.panels.length-1)*this.gutterSize+"px)"})),!0}return!1}},computed:{containerClass(){return["p-splitter p-component","p-splitter-"+this.layout]},panels(){const e=[];return this.$slots.default().forEach((t=>{this.isSplitterPanel(t)?e.push(t):t.children instanceof Array&&t.children.forEach((t=>{this.isSplitterPanel(t)&&e.push(t)}))})),e},gutterStyle(){return this.horizontal?{width:this.gutterSize+"px"}:{height:this.gutterSize+"px"}},horizontal(){return"horizontal"===this.layout}}};const s=["onMousedown","onTouchstart","onTouchmove","onTouchend"],i=[t.createElementVNode("div",{class:"p-splitter-gutter-handle"},null,-1)];!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var s=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===n&&s.firstChild?s.insertBefore(i,s.firstChild):s.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}("\n.p-splitter {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -ms-flex-wrap: nowrap;\n        flex-wrap: nowrap;\n}\n.p-splitter-vertical {\n    -webkit-box-orient: vertical;\n    -webkit-box-direction: normal;\n        -ms-flex-direction: column;\n            flex-direction: column;\n}\n.p-splitter-panel {\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1;\n}\n.p-splitter-panel-nested {\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n}\n.p-splitter-panel .p-splitter {\n    -webkit-box-flex: 1;\n        -ms-flex-positive: 1;\n            flex-grow: 1;\n    border: 0 none;\n}\n.p-splitter-gutter {\n    -webkit-box-flex: 0;\n        -ms-flex-positive: 0;\n            flex-grow: 0;\n    -ms-flex-negative: 0;\n        flex-shrink: 0;\n    display: -webkit-box;\n    display: -ms-flexbox;\n    display: flex;\n    -webkit-box-align: center;\n        -ms-flex-align: center;\n            align-items: center;\n    -webkit-box-pack: center;\n        -ms-flex-pack: center;\n            justify-content: center;\n    cursor: col-resize;\n}\n.p-splitter-horizontal.p-splitter-resizing {\n    cursor: col-resize;\n    -webkit-user-select: none;\n       -moz-user-select: none;\n        -ms-user-select: none;\n            user-select: none;\n}\n.p-splitter-horizontal > .p-splitter-gutter > .p-splitter-gutter-handle {\n    height: 24px;\n    width: 100%;\n}\n.p-splitter-horizontal > .p-splitter-gutter {\n    cursor: col-resize;\n}\n.p-splitter-vertical.p-splitter-resizing {\n    cursor: row-resize;\n    -webkit-user-select: none;\n       -moz-user-select: none;\n        -ms-user-select: none;\n            user-select: none;\n}\n.p-splitter-vertical > .p-splitter-gutter {\n    cursor: row-resize;\n}\n.p-splitter-vertical > .p-splitter-gutter > .p-splitter-gutter-handle {\n    width: 24px;\n    height: 100%;\n}\n"),n.render=function(e,n,l,r,o,a){return t.openBlock(),t.createElementBlock("div",{class:t.normalizeClass(a.containerClass)},[(t.openBlock(!0),t.createElementBlock(t.Fragment,null,t.renderList(a.panels,((e,n)=>(t.openBlock(),t.createElementBlock(t.Fragment,{key:n},[(t.openBlock(),t.createBlock(t.resolveDynamicComponent(e))),n!==a.panels.length-1?(t.openBlock(),t.createElementBlock("div",{key:0,class:"p-splitter-gutter",style:t.normalizeStyle(a.gutterStyle),onMousedown:e=>a.onGutterMouseDown(e,n),onTouchstart:e=>a.onGutterTouchStart(e,n),onTouchmove:e=>a.onGutterTouchMove(e,n),onTouchend:e=>a.onGutterTouchEnd(e,n)},i,44,s)):t.createCommentVNode("",!0)],64)))),128))],2)},module.exports=n;
