"use strict";var e=require("primevue/ripple"),t=require("primevue/utils"),n=require("vue");function a(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var i={name:"TabView",emits:["update:activeIndex","tab-change","tab-click"],props:{activeIndex:{type:Number,default:0},lazy:{type:Boolean,default:!1},scrollable:{type:Boolean,default:!1},tabindex:{type:Number,default:0},selectOnFocus:{type:Boolean,default:!1},previousButtonProps:{type:null,default:null},nextButtonProps:{type:null,default:null}},data(){return{id:this.$attrs.id,d_activeIndex:this.activeIndex,isPrevButtonDisabled:!0,isNextButtonDisabled:!1}},watch:{"$attrs.id":function(e){this.id=e||t.UniqueComponentId()},activeIndex(e){this.d_activeIndex=e,this.scrollInView({index:e})}},mounted(){this.id=this.id||t.UniqueComponentId(),this.updateInkBar(),this.scrollable&&this.updateButtonState()},updated(){this.updateInkBar()},methods:{isTabPanel:e=>"TabPanel"===e.type.name,isTabActive(e){return this.d_activeIndex===e},getTabProp:(e,t)=>e.props?e.props[t]:void 0,getKey(e,t){return this.getTabProp(e,"header")||t},getTabHeaderActionId(e){return`${this.id}_${e}_header_action`},getTabContentId(e){return`${this.id}_${e}_content`},onScroll(e){this.scrollable&&this.updateButtonState(),e.preventDefault()},onPrevButtonClick(){const e=this.$refs.content,n=t.DomHandler.getWidth(e)-this.getVisibleButtonWidths(),a=e.scrollLeft-n;e.scrollLeft=a<=0?0:a},onNextButtonClick(){const e=this.$refs.content,n=t.DomHandler.getWidth(e)-this.getVisibleButtonWidths(),a=e.scrollLeft+n,i=e.scrollWidth-n;e.scrollLeft=a>=i?i:a},onTabClick(e,t,n){this.changeActiveIndex(e,t,n),this.$emit("tab-click",{originalEvent:e,index:n})},onTabKeyDown(e,t,n){switch(e.code){case"ArrowLeft":this.onTabArrowLeftKey(e);break;case"ArrowRight":this.onTabArrowRightKey(e);break;case"Home":this.onTabHomeKey(e);break;case"End":this.onTabEndKey(e);break;case"PageDown":this.onPageDownKey(e);break;case"PageUp":this.onPageUpKey(e);break;case"Enter":case"Space":this.onTabEnterKey(e,t,n)}},onTabArrowRightKey(e){const t=this.findNextHeaderAction(e.target.parentElement);t?this.changeFocusedTab(e,t):this.onTabHomeKey(e),e.preventDefault()},onTabArrowLeftKey(e){const t=this.findPrevHeaderAction(e.target.parentElement);t?this.changeFocusedTab(e,t):this.onTabEndKey(e),e.preventDefault()},onTabHomeKey(e){const t=this.findFirstHeaderAction();this.changeFocusedTab(e,t),e.preventDefault()},onTabEndKey(e){const t=this.findLastHeaderAction();this.changeFocusedTab(e,t),e.preventDefault()},onPageDownKey(e){this.scrollInView({index:this.$refs.nav.children.length-2}),e.preventDefault()},onPageUpKey(e){this.scrollInView({index:0}),e.preventDefault()},onTabEnterKey(e,t,n){this.changeActiveIndex(e,t,n),e.preventDefault()},findNextHeaderAction(e,n=!1){const a=n?e:e.nextElementSibling;return a?t.DomHandler.hasClass(a,"p-disabled")||t.DomHandler.hasClass(a,"p-tabview-ink-bar")?this.findNextHeaderAction(a):t.DomHandler.findSingle(a,".p-tabview-header-action"):null},findPrevHeaderAction(e,n=!1){const a=n?e:e.previousElementSibling;return a?t.DomHandler.hasClass(a,"p-disabled")||t.DomHandler.hasClass(a,"p-tabview-ink-bar")?this.findPrevHeaderAction(a):t.DomHandler.findSingle(a,".p-tabview-header-action"):null},findFirstHeaderAction(){return this.findNextHeaderAction(this.$refs.nav.firstElementChild,!0)},findLastHeaderAction(){return this.findPrevHeaderAction(this.$refs.nav.lastElementChild,!0)},changeActiveIndex(e,t,n){this.getTabProp(t,"disabled")||this.d_activeIndex===n||(this.d_activeIndex=n,this.$emit("update:activeIndex",n),this.$emit("tab-change",{originalEvent:e,index:n}),this.scrollInView({index:n}))},changeFocusedTab(e,n){if(n&&(t.DomHandler.focus(n),this.scrollInView({element:n}),this.selectOnFocus)){const t=parseInt(n.parentElement.dataset.index,10),a=this.tabs[t];this.changeActiveIndex(e,a,t)}},scrollInView({element:e,index:t=-1}){const n=e||this.$refs.nav.children[t];n&&n.scrollIntoView&&n.scrollIntoView({block:"nearest"})},updateInkBar(){let e=this.$refs.nav.children[this.d_activeIndex];this.$refs.inkbar.style.width=t.DomHandler.getWidth(e)+"px",this.$refs.inkbar.style.left=t.DomHandler.getOffset(e).left-t.DomHandler.getOffset(this.$refs.nav).left+"px"},updateButtonState(){const e=this.$refs.content,{scrollLeft:n,scrollWidth:a}=e,i=t.DomHandler.getWidth(e);this.isPrevButtonDisabled=0===n,this.isNextButtonDisabled=parseInt(n)===a-i},getVisibleButtonWidths(){const{prevBtn:e,nextBtn:n}=this.$refs;return[e,n].reduce(((e,n)=>n?e+t.DomHandler.getWidth(n):e),0)},getTabHeaderClass(e,t){return["p-tabview-header",this.getTabProp(e,"headerClass"),{"p-highlight":this.d_activeIndex===t,"p-disabled":this.getTabProp(e,"disabled")}]},getTabContentClass(e){return["p-tabview-panel",this.getTabProp(e,"contentClass")]}},computed:{contentClasses(){return["p-tabview p-component",{"p-tabview-scrollable":this.scrollable}]},tabs(){return this.$slots.default().reduce(((e,t)=>(this.isTabPanel(t)?e.push(t):t.children&&t.children instanceof Array&&t.children.forEach((t=>{this.isTabPanel(t)&&e.push(t)})),e)),[])},prevButtonAriaLabel(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.previous:void 0},nextButtonAriaLabel(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.next:void 0}},directives:{ripple:a(e).default}};const o={class:"p-tabview-nav-container"},r=["tabindex","aria-label"],l=[n.createElementVNode("span",{class:"pi pi-chevron-left","aria-hidden":"true"},null,-1)],s={ref:"nav",class:"p-tabview-nav",role:"tablist"},d=["data-index"],c=["id","tabindex","aria-disabled","aria-selected","aria-controls","onClick","onKeydown"],p={key:0,class:"p-tabview-title"},h={ref:"inkbar",class:"p-tabview-ink-bar",role:"presentation","aria-hidden":"true"},b=["tabindex","aria-label"],v=[n.createElementVNode("span",{class:"pi pi-chevron-right","aria-hidden":"true"},null,-1)],u={class:"p-tabview-panels"},m=["aria-labelledby"];!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var a=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===n&&a.firstChild?a.insertBefore(i,a.firstChild):a.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}("\n.p-tabview-nav-container {\n    position: relative;\n}\n.p-tabview-scrollable .p-tabview-nav-container {\n    overflow: hidden;\n}\n.p-tabview-nav-content {\n    overflow-x: auto;\n    overflow-y: hidden;\n    scroll-behavior: smooth;\n    scrollbar-width: none;\n    overscroll-behavior: contain auto;\n}\n.p-tabview-nav {\n    display: flex;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    flex: 1 1 auto;\n}\n.p-tabview-header-action {\n    cursor: pointer;\n    user-select: none;\n    display: flex;\n    align-items: center;\n    position: relative;\n    text-decoration: none;\n    overflow: hidden;\n}\n.p-tabview-ink-bar {\n    display: none;\n    z-index: 1;\n}\n.p-tabview-header-action:focus {\n    z-index: 1;\n}\n.p-tabview-title {\n    line-height: 1;\n    white-space: nowrap;\n}\n.p-tabview-nav-btn {\n    position: absolute;\n    top: 0;\n    z-index: 2;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-tabview-nav-prev {\n    left: 0;\n}\n.p-tabview-nav-next {\n    right: 0;\n}\n.p-tabview-nav-content::-webkit-scrollbar {\n    display: none;\n}\n"),i.render=function(e,t,a,i,f,g){const w=n.resolveDirective("ripple");return n.openBlock(),n.createElementBlock("div",{class:n.normalizeClass(g.contentClasses)},[n.createElementVNode("div",o,[a.scrollable&&!f.isPrevButtonDisabled?n.withDirectives((n.openBlock(),n.createElementBlock("button",n.mergeProps({key:0,ref:"prevBtn",type:"button",class:"p-tabview-nav-prev p-tabview-nav-btn p-link",tabindex:a.tabindex,"aria-label":g.prevButtonAriaLabel,onClick:t[0]||(t[0]=(...e)=>g.onPrevButtonClick&&g.onPrevButtonClick(...e))},a.previousButtonProps),l,16,r)),[[w]]):n.createCommentVNode("",!0),n.createElementVNode("div",{ref:"content",class:"p-tabview-nav-content",onScroll:t[1]||(t[1]=(...e)=>g.onScroll&&g.onScroll(...e))},[n.createElementVNode("ul",s,[(n.openBlock(!0),n.createElementBlock(n.Fragment,null,n.renderList(g.tabs,((e,t)=>(n.openBlock(),n.createElementBlock("li",n.mergeProps({key:g.getKey(e,t),style:g.getTabProp(e,"headerStyle"),class:g.getTabHeaderClass(e,t),role:"presentation","data-index":t},g.getTabProp(e,"headerProps")),[n.withDirectives((n.openBlock(),n.createElementBlock("a",n.mergeProps({id:g.getTabHeaderActionId(t),class:"p-tabview-nav-link p-tabview-header-action",tabindex:g.getTabProp(e,"disabled")||!g.isTabActive(t)?-1:a.tabindex,role:"tab","aria-disabled":g.getTabProp(e,"disabled"),"aria-selected":g.isTabActive(t),"aria-controls":g.getTabContentId(t),onClick:n=>g.onTabClick(n,e,t),onKeydown:n=>g.onTabKeyDown(n,e,t)},g.getTabProp(e,"headerActionProps")),[e.props&&e.props.header?(n.openBlock(),n.createElementBlock("span",p,n.toDisplayString(e.props.header),1)):n.createCommentVNode("",!0),e.children&&e.children.header?(n.openBlock(),n.createBlock(n.resolveDynamicComponent(e.children.header),{key:1})):n.createCommentVNode("",!0)],16,c)),[[w]])],16,d)))),128)),n.createElementVNode("li",h,null,512)],512)],544),a.scrollable&&!f.isNextButtonDisabled?n.withDirectives((n.openBlock(),n.createElementBlock("button",n.mergeProps({key:1,ref:"nextBtn",type:"button",class:"p-tabview-nav-next p-tabview-nav-btn p-link",tabindex:a.tabindex,"aria-label":g.nextButtonAriaLabel,onClick:t[2]||(t[2]=(...e)=>g.onNextButtonClick&&g.onNextButtonClick(...e))},a.nextButtonProps),v,16,b)),[[w]]):n.createCommentVNode("",!0)]),n.createElementVNode("div",u,[(n.openBlock(!0),n.createElementBlock(n.Fragment,null,n.renderList(g.tabs,((e,t)=>(n.openBlock(),n.createElementBlock(n.Fragment,{key:g.getKey(e,t)},[!a.lazy||g.isTabActive(t)?n.withDirectives((n.openBlock(),n.createElementBlock("div",n.mergeProps({key:0,style:g.getTabProp(e,"contentStyle"),class:g.getTabContentClass(e),role:"tabpanel","aria-labelledby":g.getTabHeaderActionId(t)},g.getTabProp(e,"contentProps")),[(n.openBlock(),n.createBlock(n.resolveDynamicComponent(e)))],16,m)),[[n.vShow,!!a.lazy||g.isTabActive(t)]]):n.createCommentVNode("",!0)],64)))),128))])],2)},module.exports=i;
