import{DomHandler as e}from"primevue/utils";import{openBlock as t,createElementBlock as i,normalizeClass as a,createElementVNode as n,normalizeStyle as l,createCommentVNode as s}from"vue";var r={name:"Slider",emits:["update:modelValue","change","slideend"],props:{modelValue:[Number,Array],min:{type:Number,default:0},max:{type:Number,default:100},orientation:{type:String,default:"horizontal"},step:{type:Number,default:null},range:{type:Boolean,default:!1},disabled:{type:Boolean,default:!1},tabindex:{type:Number,default:0},"aria-labelledby":{type:String,default:null},"aria-label":{type:String,default:null}},dragging:!1,handleIndex:null,initX:null,initY:null,barWidth:null,barHeight:null,dragListener:null,dragEndListener:null,beforeUnmount(){this.unbindDragListeners()},methods:{updateDomData(){let t=this.$el.getBoundingClientRect();this.initX=t.left+e.getWindowScrollLeft(),this.initY=t.top+e.getWindowScrollTop(),this.barWidth=this.$el.offsetWidth,this.barHeight=this.$el.offsetHeight},setValue(e){let t,i=e.touches?e.touches[0].pageX:e.pageX,a=e.touches?e.touches[0].pageY:e.pageY;t="horizontal"===this.orientation?100*(i-this.initX)/this.barWidth:100*(this.initY+this.barHeight-a)/this.barHeight;let n=(this.max-this.min)*(t/100)+this.min;if(this.step){const e=this.range?this.modelValue[this.handleIndex]:this.modelValue,t=n-e;t<0?n=e+Math.ceil(n/this.step-e/this.step)*this.step:t>0&&(n=e+Math.floor(n/this.step-e/this.step)*this.step)}else n=Math.floor(n);this.updateModel(e,n)},updateModel(e,t){let i,a=parseFloat(t.toFixed(10));this.range?(i=this.modelValue?[...this.modelValue]:[],0==this.handleIndex?(a<this.min?a=this.min:a>=this.max&&(a=this.max),i[0]=a):(a>this.max?a=this.max:a<=this.min&&(a=this.min),i[1]=a)):(a<this.min?a=this.min:a>this.max&&(a=this.max),i=a),this.$emit("update:modelValue",i),this.$emit("change",i)},onDragStart(t,i){this.disabled||(e.addClass(this.$el,"p-slider-sliding"),this.dragging=!0,this.updateDomData(),this.range&&this.modelValue[0]===this.max?this.handleIndex=0:this.handleIndex=i,t.currentTarget.focus(),t.preventDefault())},onDrag(e){this.dragging&&(this.setValue(e),e.preventDefault())},onDragEnd(t){this.dragging&&(this.dragging=!1,e.removeClass(this.$el,"p-slider-sliding"),this.$emit("slideend",{originalEvent:t,value:this.modelValue}))},onBarClick(t){this.disabled||e.hasClass(t.target,"p-slider-handle")||(this.updateDomData(),this.setValue(t))},onMouseDown(e,t){this.bindDragListeners(),this.onDragStart(e,t)},onKeyDown(e,t){switch(this.handleIndex=t,e.code){case"ArrowDown":case"ArrowLeft":this.decrementValue(e,t),e.preventDefault();break;case"ArrowUp":case"ArrowRight":this.incrementValue(e,t),e.preventDefault();break;case"PageDown":this.decrementValue(e,t,!0),e.preventDefault();break;case"PageUp":this.incrementValue(e,t,!0),e.preventDefault();break;case"Home":this.updateModel(e,this.min),e.preventDefault();break;case"End":this.updateModel(e,this.max),e.preventDefault()}},decrementValue(e,t,i=!1){let a;a=this.range?this.step?this.modelValue[t]-this.step:this.modelValue[t]-1:this.step?this.modelValue-this.step:!this.step&&i?this.modelValue-10:this.modelValue-1,this.updateModel(e,a),e.preventDefault()},incrementValue(e,t,i=!1){let a;a=this.range?this.step?this.modelValue[t]+this.step:this.modelValue[t]+1:this.step?this.modelValue+this.step:!this.step&&i?this.modelValue+10:this.modelValue+1,this.updateModel(e,a),e.preventDefault()},bindDragListeners(){this.dragListener||(this.dragListener=this.onDrag.bind(this),document.addEventListener("mousemove",this.dragListener)),this.dragEndListener||(this.dragEndListener=this.onDragEnd.bind(this),document.addEventListener("mouseup",this.dragEndListener))},unbindDragListeners(){this.dragListener&&(document.removeEventListener("mousemove",this.dragListener),this.dragListener=null),this.dragEndListener&&(document.removeEventListener("mouseup",this.dragEndListener),this.dragEndListener=null)}},computed:{containerClass(){return["p-slider p-component",{"p-disabled":this.disabled,"p-slider-horizontal":"horizontal"===this.orientation,"p-slider-vertical":"vertical"===this.orientation}]},horizontal(){return"horizontal"===this.orientation},vertical(){return"vertical"===this.orientation},rangeStyle(){if(this.range){const e=this.rangeEndPosition>this.rangeStartPosition?this.rangeEndPosition-this.rangeStartPosition:this.rangeStartPosition-this.rangeEndPosition,t=this.rangeEndPosition>this.rangeStartPosition?this.rangeStartPosition:this.rangeEndPosition;return this.horizontal?{left:t+"%",width:e+"%"}:{bottom:t+"%",height:e+"%"}}return this.horizontal?{width:this.handlePosition+"%"}:{height:this.handlePosition+"%"}},handleStyle(){return this.horizontal?{left:this.handlePosition+"%"}:{bottom:this.handlePosition+"%"}},handlePosition(){return this.modelValue<this.min?0:this.modelValue>this.max?100:100*(this.modelValue-this.min)/(this.max-this.min)},rangeStartPosition(){return this.modelValue&&this.modelValue[0]?100*(this.modelValue[0]<this.min?0:this.modelValue[0]-this.min)/(this.max-this.min):0},rangeEndPosition(){return this.modelValue&&2===this.modelValue.length?100*(this.modelValue[1]>this.max?100:this.modelValue[1]-this.min)/(this.max-this.min):100},rangeStartHandleStyle(){return this.horizontal?{left:this.rangeStartPosition+"%"}:{bottom:this.rangeStartPosition+"%"}},rangeEndHandleStyle(){return this.horizontal?{left:this.rangeEndPosition+"%"}:{bottom:this.rangeEndPosition+"%"}}}};const o=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"],d=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"],h=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"];!function(e,t){void 0===t&&(t={});var i=t.insertAt;if(e&&"undefined"!=typeof document){var a=document.head||document.getElementsByTagName("head")[0],n=document.createElement("style");n.type="text/css","top"===i&&a.firstChild?a.insertBefore(n,a.firstChild):a.appendChild(n),n.styleSheet?n.styleSheet.cssText=e:n.appendChild(document.createTextNode(e))}}("\n.p-slider {\n    position: relative;\n}\n.p-slider .p-slider-handle {\n    position: absolute;\n    cursor: grab;\n    touch-action: none;\n    display: block;\n}\n.p-slider-range {\n    position: absolute;\n    display: block;\n}\n.p-slider-horizontal .p-slider-range {\n    top: 0;\n    left: 0;\n    height: 100%;\n}\n.p-slider-horizontal .p-slider-handle {\n    top: 50%;\n}\n.p-slider-vertical {\n    height: 100px;\n}\n.p-slider-vertical .p-slider-handle {\n    left: 50%;\n}\n.p-slider-vertical .p-slider-range {\n    bottom: 0;\n    left: 0;\n    width: 100%;\n}\n"),r.render=function(e,r,u,m,g,p){return t(),i("div",{class:a(p.containerClass),onClick:r[15]||(r[15]=(...e)=>p.onBarClick&&p.onBarClick(...e))},[n("span",{class:"p-slider-range",style:l(p.rangeStyle)},null,4),u.range?s("",!0):(t(),i("span",{key:0,class:"p-slider-handle",style:l(p.handleStyle),onTouchstart:r[0]||(r[0]=e=>p.onDragStart(e)),onTouchmove:r[1]||(r[1]=e=>p.onDrag(e)),onTouchend:r[2]||(r[2]=e=>p.onDragEnd(e)),onMousedown:r[3]||(r[3]=e=>p.onMouseDown(e)),onKeydown:r[4]||(r[4]=e=>p.onKeyDown(e)),tabindex:u.tabindex,role:"slider","aria-valuemin":u.min,"aria-valuenow":u.modelValue,"aria-valuemax":u.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":u.orientation},null,44,o)),u.range?(t(),i("span",{key:1,class:"p-slider-handle",style:l(p.rangeStartHandleStyle),onTouchstart:r[5]||(r[5]=e=>p.onDragStart(e,0)),onTouchmove:r[6]||(r[6]=e=>p.onDrag(e)),onTouchend:r[7]||(r[7]=e=>p.onDragEnd(e)),onMousedown:r[8]||(r[8]=e=>p.onMouseDown(e,0)),onKeydown:r[9]||(r[9]=e=>p.onKeyDown(e,0)),tabindex:u.tabindex,role:"slider","aria-valuemin":u.min,"aria-valuenow":u.modelValue?u.modelValue[0]:null,"aria-valuemax":u.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":u.orientation},null,44,d)):s("",!0),u.range?(t(),i("span",{key:2,class:"p-slider-handle",style:l(p.rangeEndHandleStyle),onTouchstart:r[10]||(r[10]=e=>p.onDragStart(e,1)),onTouchmove:r[11]||(r[11]=e=>p.onDrag(e)),onTouchend:r[12]||(r[12]=e=>p.onDragEnd(e)),onMousedown:r[13]||(r[13]=e=>p.onMouseDown(e,1)),onKeydown:r[14]||(r[14]=e=>p.onKeyDown(e,1)),tabindex:u.tabindex,role:"slider","aria-valuemin":u.min,"aria-valuenow":u.modelValue?u.modelValue[1]:null,"aria-valuemax":u.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":u.orientation},null,44,h)):s("",!0)],2)};export{r as default};
