"use strict";var e=require("primevue/basecomponent"),t=require("primevue/ripple"),n=require("primevue/tooltip"),i=require("primevue/utils"),o=require("vue");function l(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var s=l(e),r=l(t),a=l(n),c={name:"DockSub",extends:s.default,emits:["focus","blur"],props:{position:{type:String,default:"bottom"},model:{type:Array,default:null},templates:{type:null,default:null},exact:{type:Boolean,default:!0},tooltipOptions:null,menuId:{type:String,default:null},tabindex:{type:Number,default:0},"aria-label":{type:String,default:null},"aria-labelledby":{type:String,default:null}},data(){return{id:this.menuId,currentIndex:-3,focused:!1,focusedOptionIndex:-1}},watch:{menuId(e){this.id=e||i.UniqueComponentId()}},mounted(){this.id=this.id||i.UniqueComponentId()},methods:{getItemId(e){return`${this.id}_${e}`},getItemProp:(e,t)=>e&&e.item?i.ObjectUtils.getItemValue(e.item[t]):void 0,getPTOptions(e,t){return this.ptm(t,{context:{active:this.isItemActive(e)}})},isSameMenuItem:e=>e.currentTarget&&(e.currentTarget.isSameNode(e.target)||e.currentTarget.isSameNode(e.target.closest(".p-menuitem"))),isItemActive(e){return e===this.focusedOptionIndex},onListMouseLeave(){this.currentIndex=-3},onItemMouseEnter(e){this.currentIndex=e},onItemActionClick(e,t){t&&t(e)},onItemClick(e,t){if(this.isSameMenuItem(e)){const n=this.getItemProp(t,"command");n&&n({originalEvent:e,item:t.item})}},onListFocus(e){this.focused=!0,this.changeFocusedOptionIndex(0),this.$emit("focus",e)},onListBlur(e){this.focused=!1,this.focusedOptionIndex=-1,this.$emit("blur",e)},onListKeyDown(e){switch(e.code){case"ArrowDown":"left"!==this.position&&"right"!==this.position||this.onArrowDownKey(),e.preventDefault();break;case"ArrowUp":"left"!==this.position&&"right"!==this.position||this.onArrowUpKey(),e.preventDefault();break;case"ArrowRight":"top"!==this.position&&"bottom"!==this.position||this.onArrowDownKey(),e.preventDefault();break;case"ArrowLeft":"top"!==this.position&&"bottom"!==this.position||this.onArrowUpKey(),e.preventDefault();break;case"Home":this.onHomeKey(),e.preventDefault();break;case"End":this.onEndKey(),e.preventDefault();break;case"Enter":case"Space":this.onSpaceKey(e),e.preventDefault()}},onArrowDownKey(){const e=this.findNextOptionIndex(this.focusedOptionIndex);this.changeFocusedOptionIndex(e)},onArrowUpKey(){const e=this.findPrevOptionIndex(this.focusedOptionIndex);this.changeFocusedOptionIndex(e)},onHomeKey(){this.changeFocusedOptionIndex(0)},onEndKey(){this.changeFocusedOptionIndex(i.DomHandler.find(this.$refs.list,"li.p-dock-item:not(.p-disabled)").length-1)},onSpaceKey(){const e=i.DomHandler.findSingle(this.$refs.list,`li[id="${this.focusedOptionIndex}"]`),t=e&&i.DomHandler.findSingle(e,".p-dock-link");t?t.click():e&&e.click()},findNextOptionIndex(e){const t=[...i.DomHandler.find(this.$refs.list,"li.p-dock-item:not(.p-disabled)")].findIndex((t=>t.id===e));return t>-1?t+1:0},findPrevOptionIndex(e){const t=[...i.DomHandler.find(this.$refs.list,"li.p-dock-item:not(.p-disabled)")].findIndex((t=>t.id===e));return t>-1?t-1:0},changeFocusedOptionIndex(e){const t=i.DomHandler.find(this.$refs.list,"li.p-dock-item:not(.p-disabled)");let n=e>=t.length?t.length-1:e<0?0:e;this.focusedOptionIndex=t[n].getAttribute("id")},itemClass(e,t,n){return["p-dock-item",{"p-focus":this.isItemActive(n),"p-disabled":this.disabled(e),"p-dock-item-second-prev":this.currentIndex-2===t,"p-dock-item-prev":this.currentIndex-1===t,"p-dock-item-current":this.currentIndex===t,"p-dock-item-next":this.currentIndex+1===t,"p-dock-item-second-next":this.currentIndex+2===t}]},linkClass(e){return["p-dock-link",{"router-link-active":e&&e.isActive,"router-link-active-exact":this.exact&&e&&e.isExactActive}]},disabled:e=>"function"==typeof e.disabled?e.disabled():e.disabled},computed:{focusedOptionId(){return-1!==this.focusedOptionIndex?this.focusedOptionIndex:null}},directives:{ripple:r.default,tooltip:a.default}};const d=["id","aria-orientation","aria-activedescendant","tabindex","aria-label","aria-labelledby"],p=["id","aria-label","aria-disabled","onClick","onMouseenter"],m=["href","target","onClick"],u=["href","target"];c.render=function(e,t,n,i,l,s){const r=o.resolveComponent("router-link"),a=o.resolveDirective("ripple"),c=o.resolveDirective("tooltip");return o.openBlock(),o.createElementBlock("div",o.mergeProps({class:"p-dock-list-container"},e.ptm("container")),[o.createElementVNode("ul",o.mergeProps({ref:"list",id:l.id,class:"p-dock-list",role:"menu","aria-orientation":"bottom"===n.position||"top"===n.position?"horizontal":"vertical","aria-activedescendant":l.focused?s.focusedOptionId:void 0,tabindex:n.tabindex,"aria-label":e.ariaLabel,"aria-labelledby":e.ariaLabelledby,onFocus:t[0]||(t[0]=(...e)=>s.onListFocus&&s.onListFocus(...e)),onBlur:t[1]||(t[1]=(...e)=>s.onListBlur&&s.onListBlur(...e)),onKeydown:t[2]||(t[2]=(...e)=>s.onListKeyDown&&s.onListKeyDown(...e)),onMouseleave:t[3]||(t[3]=(...e)=>s.onListMouseLeave&&s.onListMouseLeave(...e))},e.ptm("menu")),[(o.openBlock(!0),o.createElementBlock(o.Fragment,null,o.renderList(n.model,((e,t)=>(o.openBlock(),o.createElementBlock("li",o.mergeProps({key:t,id:s.getItemId(t),class:s.itemClass(e,t,s.getItemId(t)),role:"menuitem","aria-label":e.label,"aria-disabled":s.disabled(e),onClick:t=>s.onItemClick(t,e),onMouseenter:e=>s.onItemMouseEnter(t)},s.getPTOptions(s.getItemId(t),"menuitem")),[o.createElementVNode("div",o.mergeProps({class:"p-menuitem-content"},s.getPTOptions(s.getItemId(t),"content")),[n.templates.item?(o.openBlock(),o.createBlock(o.resolveDynamicComponent(n.templates.item),{key:1,item:e,index:t},null,8,["item","index"])):(o.openBlock(),o.createElementBlock(o.Fragment,{key:0},[e.to&&!s.disabled(e)?(o.openBlock(),o.createBlock(r,{key:0,to:e.to,custom:""},{default:o.withCtx((({navigate:i,href:l,isActive:r,isExactActive:d})=>[o.withDirectives((o.openBlock(),o.createElementBlock("a",o.mergeProps({href:l,class:s.linkClass({isActive:r,isExactActive:d}),target:e.target,tabindex:"-1","aria-hidden":"true",onClick:t=>s.onItemActionClick(t,e,i)},s.getPTOptions(s.getItemId(t),"action")),[n.templates.icon?(o.openBlock(),o.createBlock(o.resolveDynamicComponent(n.templates.icon),{key:1,item:e},null,8,["item"])):o.withDirectives((o.openBlock(),o.createElementBlock("span",o.mergeProps({key:0,class:["p-dock-icon",e.icon]},s.getPTOptions(s.getItemId(t),"icon")),null,16)),[[a]])],16,m)),[[c,{value:e.label,disabled:!n.tooltipOptions},n.tooltipOptions]])])),_:2},1032,["to"])):o.withDirectives((o.openBlock(),o.createElementBlock("a",o.mergeProps({key:1,href:e.url,class:s.linkClass(),target:e.target,tabindex:"-1","aria-hidden":"true"},s.getPTOptions(s.getItemId(t),"action")),[n.templates.icon?(o.openBlock(),o.createBlock(o.resolveDynamicComponent(n.templates.icon),{key:1,item:e},null,8,["item"])):o.withDirectives((o.openBlock(),o.createElementBlock("span",o.mergeProps({key:0,class:["p-dock-icon",e.icon]},s.getPTOptions(s.getItemId(t),"icon")),null,16)),[[a]])],16,u)),[[c,{value:e.label,disabled:!n.tooltipOptions},n.tooltipOptions]])],64))],16)],16,p)))),128))],16,d)],16)};var f={name:"Dock",extends:s.default,props:{position:{type:String,default:"bottom"},model:null,class:null,style:null,tooltipOptions:null,exact:{type:Boolean,default:!0},menuId:{type:String,default:null},tabindex:{type:Number,default:0},"aria-label":{type:String,default:null},"aria-labelledby":{type:String,default:null}},computed:{containerClass(){return["p-dock p-component",`p-dock-${this.position}`,this.class]}},components:{DockSub:c}};!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var i=document.head||document.getElementsByTagName("head")[0],o=document.createElement("style");o.type="text/css","top"===n&&i.firstChild?i.insertBefore(o,i.firstChild):i.appendChild(o),o.styleSheet?o.styleSheet.cssText=e:o.appendChild(document.createTextNode(e))}}("\n.p-dock {\n    position: absolute;\n    z-index: 1;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    pointer-events: none;\n}\n.p-dock-list-container {\n    display: flex;\n    pointer-events: auto;\n}\n.p-dock-list {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-dock-item {\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    will-change: transform;\n}\n.p-dock-link {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    position: relative;\n    overflow: hidden;\n    cursor: default;\n}\n.p-dock-item-second-prev,\n.p-dock-item-second-next {\n    transform: scale(1.2);\n}\n.p-dock-item-prev,\n.p-dock-item-next {\n    transform: scale(1.4);\n}\n.p-dock-item-current {\n    transform: scale(1.6);\n    z-index: 1;\n}\n\n/* Position */\n/* top */\n.p-dock-top {\n    left: 0;\n    top: 0;\n    width: 100%;\n}\n.p-dock-top .p-dock-item {\n    transform-origin: center top;\n}\n\n/* bottom */\n.p-dock-bottom {\n    left: 0;\n    bottom: 0;\n    width: 100%;\n}\n.p-dock-bottom .p-dock-item {\n    transform-origin: center bottom;\n}\n\n/* right */\n.p-dock-right {\n    right: 0;\n    top: 0;\n    height: 100%;\n}\n.p-dock-right .p-dock-item {\n    transform-origin: center right;\n}\n.p-dock-right .p-dock-list {\n    flex-direction: column;\n}\n\n/* left */\n.p-dock-left {\n    left: 0;\n    top: 0;\n    height: 100%;\n}\n.p-dock-left .p-dock-item {\n    transform-origin: center left;\n}\n.p-dock-left .p-dock-list {\n    flex-direction: column;\n}\n"),f.render=function(e,t,n,i,l,s){const r=o.resolveComponent("DockSub");return o.openBlock(),o.createElementBlock("div",o.mergeProps({class:s.containerClass,style:n.style},e.ptm("root")),[o.createVNode(r,{model:n.model,templates:e.$slots,exact:n.exact,tooltipOptions:n.tooltipOptions,position:n.position,menuId:n.menuId,"aria-label":e.ariaLabel,"aria-labelledby":e.ariaLabelledby,tabindex:n.tabindex,pt:e.pt},null,8,["model","templates","exact","tooltipOptions","position","menuId","aria-label","aria-labelledby","tabindex","pt"])],16)},module.exports=f;
