"use strict";var e=require("primevue/basecomponent"),t=require("primevue/utils"),i=require("vue");function a(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var n={name:"Slider",extends:a(e).default,emits:["update:modelValue","change","slideend"],props:{modelValue:[Number,Array],min:{type:Number,default:0},max:{type:Number,default:100},orientation:{type:String,default:"horizontal"},step:{type:Number,default:null},range:{type:Boolean,default:!1},disabled:{type:Boolean,default:!1},tabindex:{type:Number,default:0},"aria-labelledby":{type:String,default:null},"aria-label":{type:String,default:null}},dragging:!1,handleIndex:null,initX:null,initY:null,barWidth:null,barHeight:null,dragListener:null,dragEndListener:null,beforeUnmount(){this.unbindDragListeners()},methods:{updateDomData(){let e=this.$el.getBoundingClientRect();this.initX=e.left+t.DomHandler.getWindowScrollLeft(),this.initY=e.top+t.DomHandler.getWindowScrollTop(),this.barWidth=this.$el.offsetWidth,this.barHeight=this.$el.offsetHeight},setValue(e){let t,i=e.touches?e.touches[0].pageX:e.pageX,a=e.touches?e.touches[0].pageY:e.pageY;t="horizontal"===this.orientation?100*(i-this.initX)/this.barWidth:100*(this.initY+this.barHeight-a)/this.barHeight;let n=(this.max-this.min)*(t/100)+this.min;if(this.step){const e=this.range?this.modelValue[this.handleIndex]:this.modelValue,t=n-e;t<0?n=e+Math.ceil(n/this.step-e/this.step)*this.step:t>0&&(n=e+Math.floor(n/this.step-e/this.step)*this.step)}else n=Math.floor(n);this.updateModel(e,n)},updateModel(e,t){let i,a=parseFloat(t.toFixed(10));this.range?(i=this.modelValue?[...this.modelValue]:[],0==this.handleIndex?(a<this.min?a=this.min:a>=this.max&&(a=this.max),i[0]=a):(a>this.max?a=this.max:a<=this.min&&(a=this.min),i[1]=a)):(a<this.min?a=this.min:a>this.max&&(a=this.max),i=a),this.$emit("update:modelValue",i),this.$emit("change",i)},onDragStart(e,i){this.disabled||(t.DomHandler.addClass(this.$el,"p-slider-sliding"),this.dragging=!0,this.updateDomData(),this.range&&this.modelValue[0]===this.max?this.handleIndex=0:this.handleIndex=i,e.currentTarget.focus(),e.preventDefault())},onDrag(e){this.dragging&&(this.setValue(e),e.preventDefault())},onDragEnd(e){this.dragging&&(this.dragging=!1,t.DomHandler.removeClass(this.$el,"p-slider-sliding"),this.$emit("slideend",{originalEvent:e,value:this.modelValue}))},onBarClick(e){this.disabled||t.DomHandler.hasClass(e.target,"p-slider-handle")||(this.updateDomData(),this.setValue(e))},onMouseDown(e,t){this.bindDragListeners(),this.onDragStart(e,t)},onKeyDown(e,t){switch(this.handleIndex=t,e.code){case"ArrowDown":case"ArrowLeft":this.decrementValue(e,t),e.preventDefault();break;case"ArrowUp":case"ArrowRight":this.incrementValue(e,t),e.preventDefault();break;case"PageDown":this.decrementValue(e,t,!0),e.preventDefault();break;case"PageUp":this.incrementValue(e,t,!0),e.preventDefault();break;case"Home":this.updateModel(e,this.min),e.preventDefault();break;case"End":this.updateModel(e,this.max),e.preventDefault()}},decrementValue(e,t,i=!1){let a;a=this.range?this.step?this.modelValue[t]-this.step:this.modelValue[t]-1:this.step?this.modelValue-this.step:!this.step&&i?this.modelValue-10:this.modelValue-1,this.updateModel(e,a),e.preventDefault()},incrementValue(e,t,i=!1){let a;a=this.range?this.step?this.modelValue[t]+this.step:this.modelValue[t]+1:this.step?this.modelValue+this.step:!this.step&&i?this.modelValue+10:this.modelValue+1,this.updateModel(e,a),e.preventDefault()},bindDragListeners(){this.dragListener||(this.dragListener=this.onDrag.bind(this),document.addEventListener("mousemove",this.dragListener)),this.dragEndListener||(this.dragEndListener=this.onDragEnd.bind(this),document.addEventListener("mouseup",this.dragEndListener))},unbindDragListeners(){this.dragListener&&(document.removeEventListener("mousemove",this.dragListener),this.dragListener=null),this.dragEndListener&&(document.removeEventListener("mouseup",this.dragEndListener),this.dragEndListener=null)}},computed:{containerClass(){return["p-slider p-component",{"p-disabled":this.disabled,"p-slider-horizontal":"horizontal"===this.orientation,"p-slider-vertical":"vertical"===this.orientation}]},horizontal(){return"horizontal"===this.orientation},vertical(){return"vertical"===this.orientation},rangeStyle(){if(this.range){const e=this.rangeEndPosition>this.rangeStartPosition?this.rangeEndPosition-this.rangeStartPosition:this.rangeStartPosition-this.rangeEndPosition,t=this.rangeEndPosition>this.rangeStartPosition?this.rangeStartPosition:this.rangeEndPosition;return this.horizontal?{left:t+"%",width:e+"%"}:{bottom:t+"%",height:e+"%"}}return this.horizontal?{width:this.handlePosition+"%"}:{height:this.handlePosition+"%"}},handleStyle(){return this.horizontal?{left:this.handlePosition+"%"}:{bottom:this.handlePosition+"%"}},handlePosition(){return this.modelValue<this.min?0:this.modelValue>this.max?100:100*(this.modelValue-this.min)/(this.max-this.min)},rangeStartPosition(){return this.modelValue&&this.modelValue[0]?100*(this.modelValue[0]<this.min?0:this.modelValue[0]-this.min)/(this.max-this.min):0},rangeEndPosition(){return this.modelValue&&2===this.modelValue.length?100*(this.modelValue[1]>this.max?100:this.modelValue[1]-this.min)/(this.max-this.min):100},rangeStartHandleStyle(){return this.horizontal?{left:this.rangeStartPosition+"%"}:{bottom:this.rangeStartPosition+"%"}},rangeEndHandleStyle(){return this.horizontal?{left:this.rangeEndPosition+"%"}:{bottom:this.rangeEndPosition+"%"}}}};const l=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"],s=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"],r=["tabindex","aria-valuemin","aria-valuenow","aria-valuemax","aria-labelledby","aria-label","aria-orientation"];!function(e,t){void 0===t&&(t={});var i=t.insertAt;if(e&&"undefined"!=typeof document){var a=document.head||document.getElementsByTagName("head")[0],n=document.createElement("style");n.type="text/css","top"===i&&a.firstChild?a.insertBefore(n,a.firstChild):a.appendChild(n),n.styleSheet?n.styleSheet.cssText=e:n.appendChild(document.createTextNode(e))}}("\n.p-slider {\n    position: relative;\n}\n.p-slider .p-slider-handle {\n    position: absolute;\n    cursor: grab;\n    touch-action: none;\n    display: block;\n}\n.p-slider-range {\n    position: absolute;\n    display: block;\n}\n.p-slider-horizontal .p-slider-range {\n    top: 0;\n    left: 0;\n    height: 100%;\n}\n.p-slider-horizontal .p-slider-handle {\n    top: 50%;\n}\n.p-slider-vertical {\n    height: 100px;\n}\n.p-slider-vertical .p-slider-handle {\n    left: 50%;\n}\n.p-slider-vertical .p-slider-range {\n    bottom: 0;\n    left: 0;\n    width: 100%;\n}\n"),n.render=function(e,t,a,n,o,d){return i.openBlock(),i.createElementBlock("div",i.mergeProps({class:d.containerClass,onClick:t[15]||(t[15]=(...e)=>d.onBarClick&&d.onBarClick(...e))},e.ptm("root")),[i.createElementVNode("span",i.mergeProps({class:"p-slider-range",style:d.rangeStyle},e.ptm("range")),null,16),a.range?i.createCommentVNode("",!0):(i.openBlock(),i.createElementBlock("span",i.mergeProps({key:0,class:"p-slider-handle",style:d.handleStyle,onTouchstart:t[0]||(t[0]=e=>d.onDragStart(e)),onTouchmove:t[1]||(t[1]=e=>d.onDrag(e)),onTouchend:t[2]||(t[2]=e=>d.onDragEnd(e)),onMousedown:t[3]||(t[3]=e=>d.onMouseDown(e)),onKeydown:t[4]||(t[4]=e=>d.onKeyDown(e)),tabindex:a.tabindex,role:"slider","aria-valuemin":a.min,"aria-valuenow":a.modelValue,"aria-valuemax":a.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":a.orientation},e.ptm("handle")),null,16,l)),a.range?(i.openBlock(),i.createElementBlock("span",i.mergeProps({key:1,class:"p-slider-handle",style:d.rangeStartHandleStyle,onTouchstart:t[5]||(t[5]=e=>d.onDragStart(e,0)),onTouchmove:t[6]||(t[6]=e=>d.onDrag(e)),onTouchend:t[7]||(t[7]=e=>d.onDragEnd(e)),onMousedown:t[8]||(t[8]=e=>d.onMouseDown(e,0)),onKeydown:t[9]||(t[9]=e=>d.onKeyDown(e,0)),tabindex:a.tabindex,role:"slider","aria-valuemin":a.min,"aria-valuenow":a.modelValue?a.modelValue[0]:null,"aria-valuemax":a.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":a.orientation},e.ptm("startHandler")),null,16,s)):i.createCommentVNode("",!0),a.range?(i.openBlock(),i.createElementBlock("span",i.mergeProps({key:2,class:"p-slider-handle",style:d.rangeEndHandleStyle,onTouchstart:t[10]||(t[10]=e=>d.onDragStart(e,1)),onTouchmove:t[11]||(t[11]=e=>d.onDrag(e)),onTouchend:t[12]||(t[12]=e=>d.onDragEnd(e)),onMousedown:t[13]||(t[13]=e=>d.onMouseDown(e,1)),onKeydown:t[14]||(t[14]=e=>d.onKeyDown(e,1)),tabindex:a.tabindex,role:"slider","aria-valuemin":a.min,"aria-valuenow":a.modelValue?a.modelValue[1]:null,"aria-valuemax":a.max,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,"aria-orientation":a.orientation},e.ptm("endHandler")),null,16,r)):i.createCommentVNode("",!0)],16)},module.exports=n;
