"use strict";var e=require("primevue/basecomponent"),t=require("primevue/icons/chevronleft"),n=require("primevue/icons/chevronright"),a=require("primevue/ripple"),i=require("primevue/utils"),o=require("vue");function r(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var s=r(e),l=r(t),c=r(n),d=r(a),p={name:"TabView",extends:s.default,emits:["update:activeIndex","tab-change","tab-click"],props:{activeIndex:{type:Number,default:0},lazy:{type:Boolean,default:!1},scrollable:{type:Boolean,default:!1},tabindex:{type:Number,default:0},selectOnFocus:{type:Boolean,default:!1},previousButtonProps:{type:null,default:null},nextButtonProps:{type:null,default:null},prevIcon:{type:String,default:void 0},nextIcon:{type:String,default:void 0}},data(){return{id:this.$attrs.id,d_activeIndex:this.activeIndex,isPrevButtonDisabled:!0,isNextButtonDisabled:!1}},watch:{"$attrs.id":function(e){this.id=e||i.UniqueComponentId()},activeIndex(e){this.d_activeIndex=e,this.scrollInView({index:e})}},mounted(){this.id=this.id||i.UniqueComponentId(),this.updateInkBar(),this.scrollable&&this.updateButtonState()},updated(){this.updateInkBar()},methods:{isTabPanel:e=>"TabPanel"===e.type.name,isTabActive(e){return this.d_activeIndex===e},getTabProp:(e,t)=>e.props?e.props[t]:void 0,getKey(e,t){return this.getTabProp(e,"header")||t},getTabHeaderActionId(e){return`${this.id}_${e}_header_action`},getTabContentId(e){return`${this.id}_${e}_content`},getTabPT(e,t){return this.ptmo(this.getTabProp(e,"pt"),t,{props:e.props,parent:{props:this.$props,state:this.$data}})},onScroll(e){this.scrollable&&this.updateButtonState(),e.preventDefault()},onPrevButtonClick(){const e=this.$refs.content,t=i.DomHandler.getWidth(e),n=e.scrollLeft-t;e.scrollLeft=n<=0?0:n},onNextButtonClick(){const e=this.$refs.content,t=i.DomHandler.getWidth(e)-this.getVisibleButtonWidths(),n=e.scrollLeft+t,a=e.scrollWidth-t;e.scrollLeft=n>=a?a:n},onTabClick(e,t,n){this.changeActiveIndex(e,t,n),this.$emit("tab-click",{originalEvent:e,index:n})},onTabKeyDown(e,t,n){switch(e.code){case"ArrowLeft":this.onTabArrowLeftKey(e);break;case"ArrowRight":this.onTabArrowRightKey(e);break;case"Home":this.onTabHomeKey(e);break;case"End":this.onTabEndKey(e);break;case"PageDown":this.onPageDownKey(e);break;case"PageUp":this.onPageUpKey(e);break;case"Enter":case"Space":this.onTabEnterKey(e,t,n)}},onTabArrowRightKey(e){const t=this.findNextHeaderAction(e.target.parentElement);t?this.changeFocusedTab(e,t):this.onTabHomeKey(e),e.preventDefault()},onTabArrowLeftKey(e){const t=this.findPrevHeaderAction(e.target.parentElement);t?this.changeFocusedTab(e,t):this.onTabEndKey(e),e.preventDefault()},onTabHomeKey(e){const t=this.findFirstHeaderAction();this.changeFocusedTab(e,t),e.preventDefault()},onTabEndKey(e){const t=this.findLastHeaderAction();this.changeFocusedTab(e,t),e.preventDefault()},onPageDownKey(e){this.scrollInView({index:this.$refs.nav.children.length-2}),e.preventDefault()},onPageUpKey(e){this.scrollInView({index:0}),e.preventDefault()},onTabEnterKey(e,t,n){this.changeActiveIndex(e,t,n),e.preventDefault()},findNextHeaderAction(e,t=!1){const n=t?e:e.nextElementSibling;return n?i.DomHandler.hasClass(n,"p-disabled")||i.DomHandler.hasClass(n,"p-tabview-ink-bar")?this.findNextHeaderAction(n):i.DomHandler.findSingle(n,".p-tabview-header-action"):null},findPrevHeaderAction(e,t=!1){const n=t?e:e.previousElementSibling;return n?i.DomHandler.hasClass(n,"p-disabled")||i.DomHandler.hasClass(n,"p-tabview-ink-bar")?this.findPrevHeaderAction(n):i.DomHandler.findSingle(n,".p-tabview-header-action"):null},findFirstHeaderAction(){return this.findNextHeaderAction(this.$refs.nav.firstElementChild,!0)},findLastHeaderAction(){return this.findPrevHeaderAction(this.$refs.nav.lastElementChild,!0)},changeActiveIndex(e,t,n){this.getTabProp(t,"disabled")||this.d_activeIndex===n||(this.d_activeIndex=n,this.$emit("update:activeIndex",n),this.$emit("tab-change",{originalEvent:e,index:n}),this.scrollInView({index:n}))},changeFocusedTab(e,t){if(t&&(i.DomHandler.focus(t),this.scrollInView({element:t}),this.selectOnFocus)){const n=parseInt(t.parentElement.dataset.index,10),a=this.tabs[n];this.changeActiveIndex(e,a,n)}},scrollInView({element:e,index:t=-1}){const n=e||this.$refs.nav.children[t];n&&n.scrollIntoView&&n.scrollIntoView({block:"nearest"})},updateInkBar(){let e=this.$refs.nav.children[this.d_activeIndex];this.$refs.inkbar.style.width=i.DomHandler.getWidth(e)+"px",this.$refs.inkbar.style.left=i.DomHandler.getOffset(e).left-i.DomHandler.getOffset(this.$refs.nav).left+"px"},updateButtonState(){const e=this.$refs.content,{scrollLeft:t,scrollWidth:n}=e,a=i.DomHandler.getWidth(e);this.isPrevButtonDisabled=0===t,this.isNextButtonDisabled=parseInt(t)===n-a},getVisibleButtonWidths(){const{prevBtn:e,nextBtn:t}=this.$refs;return[e,t].reduce(((e,t)=>t?e+i.DomHandler.getWidth(t):e),0)},getTabHeaderClass(e,t){return["p-tabview-header",this.getTabProp(e,"headerClass"),{"p-highlight":this.d_activeIndex===t,"p-disabled":this.getTabProp(e,"disabled")}]},getTabContentClass(e){return["p-tabview-panel",this.getTabProp(e,"contentClass")]}},computed:{contentClasses(){return["p-tabview p-component",{"p-tabview-scrollable":this.scrollable}]},tabs(){return this.$slots.default().reduce(((e,t)=>(this.isTabPanel(t)?e.push(t):t.children&&t.children instanceof Array&&t.children.forEach((t=>{this.isTabPanel(t)&&e.push(t)})),e)),[])},prevButtonAriaLabel(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.previous:void 0},nextButtonAriaLabel(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.next:void 0}},directives:{ripple:d.default},components:{ChevronLeftIcon:l.default,ChevronRightIcon:c.default}};const h=["tabindex","aria-label"],b=["data-index"],v=["id","tabindex","aria-disabled","aria-selected","aria-controls","onClick","onKeydown"],u=["tabindex","aria-label"],m=["aria-labelledby"];!function(e,t){void 0===t&&(t={});var n=t.insertAt;if(e&&"undefined"!=typeof document){var a=document.head||document.getElementsByTagName("head")[0],i=document.createElement("style");i.type="text/css","top"===n&&a.firstChild?a.insertBefore(i,a.firstChild):a.appendChild(i),i.styleSheet?i.styleSheet.cssText=e:i.appendChild(document.createTextNode(e))}}("\n.p-tabview-nav-container {\n    position: relative;\n}\n.p-tabview-scrollable .p-tabview-nav-container {\n    overflow: hidden;\n}\n.p-tabview-nav-content {\n    overflow-x: auto;\n    overflow-y: hidden;\n    scroll-behavior: smooth;\n    scrollbar-width: none;\n    overscroll-behavior: contain auto;\n}\n.p-tabview-nav {\n    display: flex;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n    flex: 1 1 auto;\n}\n.p-tabview-header-action {\n    cursor: pointer;\n    user-select: none;\n    display: flex;\n    align-items: center;\n    position: relative;\n    text-decoration: none;\n    overflow: hidden;\n}\n.p-tabview-ink-bar {\n    display: none;\n    z-index: 1;\n}\n.p-tabview-header-action:focus {\n    z-index: 1;\n}\n.p-tabview-title {\n    line-height: 1;\n    white-space: nowrap;\n}\n.p-tabview-nav-btn {\n    position: absolute;\n    top: 0;\n    z-index: 2;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n.p-tabview-nav-prev {\n    left: 0;\n}\n.p-tabview-nav-next {\n    right: 0;\n}\n.p-tabview-nav-content::-webkit-scrollbar {\n    display: none;\n}\n"),p.render=function(e,t,n,a,i,r){const s=o.resolveDirective("ripple");return o.openBlock(),o.createElementBlock("div",o.mergeProps({class:r.contentClasses},e.ptm("root")),[o.createElementVNode("div",o.mergeProps({class:"p-tabview-nav-container"},e.ptm("navcontainer")),[n.scrollable&&!i.isPrevButtonDisabled?o.withDirectives((o.openBlock(),o.createElementBlock("button",o.mergeProps({key:0,ref:"prevBtn",type:"button",class:"p-tabview-nav-prev p-tabview-nav-btn p-link",tabindex:n.tabindex,"aria-label":r.prevButtonAriaLabel,onClick:t[0]||(t[0]=(...e)=>r.onPrevButtonClick&&r.onPrevButtonClick(...e))},{...n.previousButtonProps,...e.ptm("prevbutton")}),[o.renderSlot(e.$slots,"previcon",{},(()=>[(o.openBlock(),o.createBlock(o.resolveDynamicComponent(n.prevIcon?"span":"ChevronLeftIcon"),o.mergeProps({"aria-hidden":"true",class:n.prevIcon},e.ptm("previcon")),null,16,["class"]))]))],16,h)),[[s]]):o.createCommentVNode("",!0),o.createElementVNode("div",o.mergeProps({ref:"content",class:"p-tabview-nav-content",onScroll:t[1]||(t[1]=(...e)=>r.onScroll&&r.onScroll(...e))},e.ptm("navcontent")),[o.createElementVNode("ul",o.mergeProps({ref:"nav",class:"p-tabview-nav",role:"tablist"},e.ptm("nav")),[(o.openBlock(!0),o.createElementBlock(o.Fragment,null,o.renderList(r.tabs,((e,t)=>(o.openBlock(),o.createElementBlock("li",o.mergeProps({key:r.getKey(e,t),style:r.getTabProp(e,"headerStyle"),class:r.getTabHeaderClass(e,t),role:"presentation","data-index":t},{...r.getTabProp(e,"headerProps"),...r.getTabPT(e,"root"),...r.getTabPT(e,"header")}),[o.withDirectives((o.openBlock(),o.createElementBlock("a",o.mergeProps({id:r.getTabHeaderActionId(t),class:"p-tabview-nav-link p-tabview-header-action",tabindex:r.getTabProp(e,"disabled")||!r.isTabActive(t)?-1:n.tabindex,role:"tab","aria-disabled":r.getTabProp(e,"disabled"),"aria-selected":r.isTabActive(t),"aria-controls":r.getTabContentId(t),onClick:n=>r.onTabClick(n,e,t),onKeydown:n=>r.onTabKeyDown(n,e,t)},{...r.getTabProp(e,"headerActionProps"),...r.getTabPT(e,"headeraction")}),[e.props&&e.props.header?(o.openBlock(),o.createElementBlock("span",o.mergeProps({key:0,class:"p-tabview-title"},r.getTabPT(e,"headertitle")),o.toDisplayString(e.props.header),17)):o.createCommentVNode("",!0),e.children&&e.children.header?(o.openBlock(),o.createBlock(o.resolveDynamicComponent(e.children.header),{key:1})):o.createCommentVNode("",!0)],16,v)),[[s]])],16,b)))),128)),o.createElementVNode("li",o.mergeProps({ref:"inkbar",class:"p-tabview-ink-bar",role:"presentation","aria-hidden":"true"},e.ptm("inkbar")),null,16)],16)],16),n.scrollable&&!i.isNextButtonDisabled?o.withDirectives((o.openBlock(),o.createElementBlock("button",o.mergeProps({key:1,ref:"nextBtn",type:"button",class:"p-tabview-nav-next p-tabview-nav-btn p-link",tabindex:n.tabindex,"aria-label":r.nextButtonAriaLabel,onClick:t[2]||(t[2]=(...e)=>r.onNextButtonClick&&r.onNextButtonClick(...e))},{...n.nextButtonProps,...e.ptm("nextbutton")}),[o.renderSlot(e.$slots,"nexticon",{},(()=>[(o.openBlock(),o.createBlock(o.resolveDynamicComponent(n.nextIcon?"span":"ChevronRightIcon"),o.mergeProps({"aria-hidden":"true",class:n.nextIcon},e.ptm("nexticon")),null,16,["class"]))]))],16,u)),[[s]]):o.createCommentVNode("",!0)],16),o.createElementVNode("div",o.mergeProps({class:"p-tabview-panels"},e.ptm("panelcontainer")),[(o.openBlock(!0),o.createElementBlock(o.Fragment,null,o.renderList(r.tabs,((e,t)=>(o.openBlock(),o.createElementBlock(o.Fragment,{key:r.getKey(e,t)},[!n.lazy||r.isTabActive(t)?o.withDirectives((o.openBlock(),o.createElementBlock("div",o.mergeProps({key:0,style:r.getTabProp(e,"contentStyle"),class:r.getTabContentClass(e),role:"tabpanel","aria-labelledby":r.getTabHeaderActionId(t)},{...r.getTabProp(e,"contentProps"),...r.getTabPT(e,"root"),...r.getTabPT(e,"content")}),[(o.openBlock(),o.createBlock(o.resolveDynamicComponent(e)))],16,m)),[[o.vShow,!!n.lazy||r.isTabActive(t)]]):o.createCommentVNode("",!0)],64)))),128))],16)],16)},module.exports=p;
