"use strict";var e=require("primevue/basecomponent"),t=require("primevue/usestyle"),n=require("primevue/ripple"),o=require("primevue/tooltip"),i=require("primevue/utils"),r=require("vue");function a(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var c=a(e),l=a(n),s=a(o),d=t.useStyle("\n.p-dock {\n    position: absolute;\n    z-index: 1;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    pointer-events: none;\n}\n\n.p-dock-list-container {\n    display: flex;\n    pointer-events: auto;\n}\n\n.p-dock-list {\n    margin: 0;\n    padding: 0;\n    list-style: none;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-dock-item {\n    transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);\n    will-change: transform;\n}\n\n.p-dock-link {\n    display: flex;\n    flex-direction: column;\n    align-items: center;\n    justify-content: center;\n    position: relative;\n    overflow: hidden;\n    cursor: default;\n}\n\n.p-dock-item-second-prev,\n.p-dock-item-second-next {\n    transform: scale(1.2);\n}\n\n.p-dock-item-prev,\n.p-dock-item-next {\n    transform: scale(1.4);\n}\n\n.p-dock-item-current {\n    transform: scale(1.6);\n    z-index: 1;\n}\n\n/* Position */\n/* top */\n.p-dock-top {\n    left: 0;\n    top: 0;\n    width: 100%;\n}\n\n.p-dock-top .p-dock-item {\n    transform-origin: center top;\n}\n\n/* bottom */\n.p-dock-bottom {\n    left: 0;\n    bottom: 0;\n    width: 100%;\n}\n\n.p-dock-bottom .p-dock-item {\n    transform-origin: center bottom;\n}\n\n/* right */\n.p-dock-right {\n    right: 0;\n    top: 0;\n    height: 100%;\n}\n\n.p-dock-right .p-dock-item {\n    transform-origin: center right;\n}\n\n.p-dock-right .p-dock-list {\n    flex-direction: column;\n}\n\n/* left */\n.p-dock-left {\n    left: 0;\n    top: 0;\n    height: 100%;\n}\n\n.p-dock-left .p-dock-item {\n    transform-origin: center left;\n}\n\n.p-dock-left .p-dock-list {\n    flex-direction: column;\n}\n",{name:"dock",manual:!0}),u={name:"BaseDock",extends:c.default,props:{position:{type:String,default:"bottom"},model:null,class:null,style:null,tooltipOptions:null,exact:{type:Boolean,default:!0},menuId:{type:String,default:null},tabindex:{type:Number,default:0},"aria-label":{type:String,default:null},"aria-labelledby":{type:String,default:null}},css:{classes:{root:function(e){return["p-dock p-component","p-dock-".concat(e.props.position)]},container:"p-dock-list-container",menu:"p-dock-list",menuitem:function(e){var t=e.instance,n=e.processedItem,o=e.index;return["p-dock-item",{"p-focus":t.isItemActive(e.id),"p-disabled":t.disabled(n),"p-dock-item-second-prev":t.currentIndex-2===o,"p-dock-item-prev":t.currentIndex-1===o,"p-dock-item-current":t.currentIndex===o,"p-dock-item-next":t.currentIndex+1===o,"p-dock-item-second-next":t.currentIndex+2===o}]},content:"p-menuitem-content",action:function(e){return["p-dock-link",{"router-link-active":e.isActive,"router-link-active-exact":e.props.exact&&e.isExactActive}]},icon:"p-dock-icon"},loadStyle:d.load},provide:function(){return{$parentInstance:this}}};function p(e){return k(e)||h(e)||f(e)||m()}function m(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function f(e,t){if(e){if("string"==typeof e)return b(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?b(e,t):void 0}}function h(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function k(e){if(Array.isArray(e))return b(e)}function b(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,o=new Array(t);n<t;n++)o[n]=e[n];return o}var y={name:"DockSub",hostName:"Dock",extends:c.default,emits:["focus","blur"],props:{position:{type:String,default:"bottom"},model:{type:Array,default:null},templates:{type:null,default:null},exact:{type:Boolean,default:!0},tooltipOptions:null,menuId:{type:String,default:null},tabindex:{type:Number,default:0},"aria-label":{type:String,default:null},"aria-labelledby":{type:String,default:null}},data:function(){return{id:this.menuId,currentIndex:-3,focused:!1,focusedOptionIndex:-1}},watch:{menuId:function(e){this.id=e||i.UniqueComponentId()}},mounted:function(){this.id=this.id||i.UniqueComponentId()},methods:{getItemId:function(e){return"".concat(this.id,"_").concat(e)},getItemProp:function(e,t){return e&&e.item?i.ObjectUtils.getItemValue(e.item[t]):void 0},getPTOptions:function(e,t,n){return this.ptm(e,{context:{index:n,item:t,active:this.isItemActive(this.getItemId(n))}})},isSameMenuItem:function(e){return e.currentTarget&&(e.currentTarget.isSameNode(e.target)||e.currentTarget.isSameNode(e.target.closest('[data-pc-section="menuitem"]')))},isItemActive:function(e){return e===this.focusedOptionIndex},onListMouseLeave:function(){this.currentIndex=-3},onItemMouseEnter:function(e){this.currentIndex=e},onItemActionClick:function(e,t){t&&t(e)},onItemClick:function(e,t){if(this.isSameMenuItem(e)){var n=this.getItemProp(t,"command");n&&n({originalEvent:e,item:t.item})}},onListFocus:function(e){this.focused=!0,this.changeFocusedOptionIndex(0),this.$emit("focus",e)},onListBlur:function(e){this.focused=!1,this.focusedOptionIndex=-1,this.$emit("blur",e)},onListKeyDown:function(e){switch(e.code){case"ArrowDown":"left"!==this.position&&"right"!==this.position||this.onArrowDownKey(),e.preventDefault();break;case"ArrowUp":"left"!==this.position&&"right"!==this.position||this.onArrowUpKey(),e.preventDefault();break;case"ArrowRight":"top"!==this.position&&"bottom"!==this.position||this.onArrowDownKey(),e.preventDefault();break;case"ArrowLeft":"top"!==this.position&&"bottom"!==this.position||this.onArrowUpKey(),e.preventDefault();break;case"Home":this.onHomeKey(),e.preventDefault();break;case"End":this.onEndKey(),e.preventDefault();break;case"Enter":case"Space":this.onSpaceKey(e),e.preventDefault()}},onArrowDownKey:function(){var e=this.findNextOptionIndex(this.focusedOptionIndex);this.changeFocusedOptionIndex(e)},onArrowUpKey:function(){var e=this.findPrevOptionIndex(this.focusedOptionIndex);this.changeFocusedOptionIndex(e)},onHomeKey:function(){this.changeFocusedOptionIndex(0)},onEndKey:function(){this.changeFocusedOptionIndex(i.DomHandler.find(this.$refs.list,'li[data-pc-section="menuitem"][data-p-disabled="false"]').length-1)},onSpaceKey:function(){var e=i.DomHandler.findSingle(this.$refs.list,'li[id="'.concat("".concat(this.focusedOptionIndex),'"]')),t=e&&i.DomHandler.findSingle(e,'[data-pc-section="action"]');t?t.click():e&&e.click()},findNextOptionIndex:function(e){var t=p(i.DomHandler.find(this.$refs.list,'li[data-pc-section="menuitem"][data-p-disabled="false"]')).findIndex((function(t){return t.id===e}));return t>-1?t+1:0},findPrevOptionIndex:function(e){var t=p(i.DomHandler.find(this.$refs.list,'li[data-pc-section="menuitem"][data-p-disabled="false"]')).findIndex((function(t){return t.id===e}));return t>-1?t-1:0},changeFocusedOptionIndex:function(e){var t=i.DomHandler.find(this.$refs.list,'li[data-pc-section="menuitem"][data-p-disabled="false"]');this.focusedOptionIndex=t[e>=t.length?t.length-1:e<0?0:e].getAttribute("id")},disabled:function(e){return"function"==typeof e.disabled?e.disabled():e.disabled}},computed:{focusedOptionId:function(){return-1!==this.focusedOptionIndex?this.focusedOptionIndex:null}},directives:{ripple:l.default,tooltip:s.default}},v=["id","aria-orientation","aria-activedescendant","tabindex","aria-label","aria-labelledby"],x=["id","aria-label","aria-disabled","onClick","onMouseenter","data-p-focused","data-p-disabled"],g=["href","target","onClick"],I=["href","target"];y.render=function(e,t,n,o,i,a){var c=r.resolveComponent("router-link"),l=r.resolveDirective("ripple"),s=r.resolveDirective("tooltip");return r.openBlock(),r.createElementBlock("div",r.mergeProps({class:e.cx("container")},e.ptm("container")),[r.createElementVNode("ul",r.mergeProps({ref:"list",id:i.id,class:e.cx("menu"),role:"menu","aria-orientation":"bottom"===n.position||"top"===n.position?"horizontal":"vertical","aria-activedescendant":i.focused?a.focusedOptionId:void 0,tabindex:n.tabindex,"aria-label":e.ariaLabel,"aria-labelledby":e.ariaLabelledby,onFocus:t[0]||(t[0]=function(){return a.onListFocus&&a.onListFocus.apply(a,arguments)}),onBlur:t[1]||(t[1]=function(){return a.onListBlur&&a.onListBlur.apply(a,arguments)}),onKeydown:t[2]||(t[2]=function(){return a.onListKeyDown&&a.onListKeyDown.apply(a,arguments)}),onMouseleave:t[3]||(t[3]=function(){return a.onListMouseLeave&&a.onListMouseLeave.apply(a,arguments)})},e.ptm("menu")),[(r.openBlock(!0),r.createElementBlock(r.Fragment,null,r.renderList(n.model,(function(t,o){return r.openBlock(),r.createElementBlock("li",r.mergeProps({key:o,id:a.getItemId(o),class:e.cx("menuitem",{processedItem:t,index:o,id:a.getItemId(o)}),role:"menuitem","aria-label":t.label,"aria-disabled":a.disabled(t),onClick:function(e){return a.onItemClick(e,t)},onMouseenter:function(e){return a.onItemMouseEnter(o)}},a.getPTOptions("menuitem",t,o),{"data-p-focused":a.isItemActive(a.getItemId(o)),"data-p-disabled":a.disabled(t)||!1}),[r.createElementVNode("div",r.mergeProps({class:e.cx("content")},a.getPTOptions("content",t,o)),[n.templates.item?(r.openBlock(),r.createBlock(r.resolveDynamicComponent(n.templates.item),{key:1,item:t,index:o},null,8,["item","index"])):(r.openBlock(),r.createElementBlock(r.Fragment,{key:0},[t.to&&!a.disabled(t)?(r.openBlock(),r.createBlock(c,{key:0,to:t.to,custom:""},{default:r.withCtx((function(i){var c=i.navigate,d=i.href,u=i.isActive,p=i.isExactActive;return[r.withDirectives((r.openBlock(),r.createElementBlock("a",r.mergeProps({href:d,class:e.cx("action",{isActive:u,isExactActive:p}),target:t.target,tabindex:"-1","aria-hidden":"true",onClick:function(e){return a.onItemActionClick(e,t,c)}},a.getPTOptions("action",t,o)),[n.templates.icon?(r.openBlock(),r.createBlock(r.resolveDynamicComponent(n.templates.icon),{key:1,item:t,class:r.normalizeClass(e.cx("icon"))},null,8,["item","class"])):r.withDirectives((r.openBlock(),r.createElementBlock("span",r.mergeProps({key:0,class:[e.cx("icon"),t.icon]},a.getPTOptions("icon",t,o)),null,16)),[[l]])],16,g)),[[s,{value:t.label,disabled:!n.tooltipOptions},n.tooltipOptions]])]})),_:2},1032,["to"])):r.withDirectives((r.openBlock(),r.createElementBlock("a",r.mergeProps({key:1,href:t.url,class:e.cx("action"),target:t.target,tabindex:"-1","aria-hidden":"true"},a.getPTOptions("action",t,o)),[n.templates.icon?(r.openBlock(),r.createBlock(r.resolveDynamicComponent(n.templates.icon),{key:1,item:t,class:r.normalizeClass(e.cx("icon"))},null,8,["item","class"])):r.withDirectives((r.openBlock(),r.createElementBlock("span",r.mergeProps({key:0,class:[e.cx("icon"),t.icon]},a.getPTOptions("icon",t,o)),null,16)),[[l]])],16,I)),[[s,{value:t.label,disabled:!n.tooltipOptions},n.tooltipOptions]])],64))],16)],16,x)})),128))],16,v)],16)};var O={name:"Dock",extends:u,computed:{containerClass:function(){return[this.class,this.cx("root")]}},components:{DockSub:y}};O.render=function(e,t,n,o,i,a){var c=r.resolveComponent("DockSub");return r.openBlock(),r.createElementBlock("div",r.mergeProps({class:a.containerClass,style:e.style},e.ptm("root"),{"data-pc-name":"dock"}),[r.createVNode(c,{model:e.model,templates:e.$slots,exact:e.exact,tooltipOptions:e.tooltipOptions,position:e.position,menuId:e.menuId,"aria-label":e.ariaLabel,"aria-labelledby":e.ariaLabelledby,tabindex:e.tabindex,pt:e.pt,unstyled:e.unstyled},null,8,["model","templates","exact","tooltipOptions","position","menuId","aria-label","aria-labelledby","tabindex","pt","unstyled"])],16)},module.exports=O;
