"use strict";var e=require("primevue/focustrap"),t=require("primevue/portal"),n=require("primevue/utils"),i=require("primevue/basecomponent"),a=require("primevue/usestyle"),r=require("primevue/icons/times"),o=require("primevue/ripple"),l=require("primevue/icons/chevronleft"),s=require("primevue/icons/chevronright"),c=require("vue"),u=require("primevue/icons/chevrondown"),d=require("primevue/icons/chevronup");function m(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var p=m(e),h=m(t),v=m(i),f=m(r),b=m(o),g=m(l),y=m(s),I=m(u),x=m(d),w=a.useStyle("\n.p-galleria-content {\n    display: flex;\n    flex-direction: column;\n}\n\n.p-galleria-item-wrapper {\n    display: flex;\n    flex-direction: column;\n    position: relative;\n}\n\n.p-galleria-item-container {\n    position: relative;\n    display: flex;\n    height: 100%;\n}\n\n.p-galleria-item-nav {\n    position: absolute;\n    top: 50%;\n    margin-top: -0.5rem;\n    display: inline-flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n}\n\n.p-galleria-item-prev {\n    left: 0;\n    border-top-left-radius: 0;\n    border-bottom-left-radius: 0;\n}\n\n.p-galleria-item-next {\n    right: 0;\n    border-top-right-radius: 0;\n    border-bottom-right-radius: 0;\n}\n\n.p-galleria-item {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: 100%;\n    width: 100%;\n}\n\n.p-galleria-item-nav-onhover .p-galleria-item-nav {\n    pointer-events: none;\n    opacity: 0;\n    transition: opacity 0.2s ease-in-out;\n}\n\n.p-galleria-item-nav-onhover .p-galleria-item-wrapper:hover .p-galleria-item-nav {\n    pointer-events: all;\n    opacity: 1;\n}\n\n.p-galleria-item-nav-onhover .p-galleria-item-wrapper:hover .p-galleria-item-nav.p-disabled {\n    pointer-events: none;\n}\n\n.p-galleria-caption {\n    position: absolute;\n    bottom: 0;\n    left: 0;\n    width: 100%;\n}\n\n/* Thumbnails */\n.p-galleria-thumbnail-wrapper {\n    display: flex;\n    flex-direction: column;\n    overflow: auto;\n    flex-shrink: 0;\n}\n\n.p-galleria-thumbnail-prev,\n.p-galleria-thumbnail-next {\n    align-self: center;\n    flex: 0 0 auto;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n    position: relative;\n}\n\n.p-galleria-thumbnail-prev span,\n.p-galleria-thumbnail-next span {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n}\n\n.p-galleria-thumbnail-container {\n    display: flex;\n    flex-direction: row;\n}\n\n.p-galleria-thumbnail-items-container {\n    overflow: hidden;\n    width: 100%;\n}\n\n.p-galleria-thumbnail-items {\n    display: flex;\n}\n\n.p-galleria-thumbnail-item {\n    overflow: auto;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    cursor: pointer;\n    opacity: 0.5;\n}\n\n.p-galleria-thumbnail-item:hover {\n    opacity: 1;\n    transition: opacity 0.3s;\n}\n\n.p-galleria-thumbnail-item-current {\n    opacity: 1;\n}\n\n/* Positions */\n/* Thumbnails */\n.p-galleria-thumbnails-left .p-galleria-content,\n.p-galleria-thumbnails-right .p-galleria-content {\n    flex-direction: row;\n}\n\n.p-galleria-thumbnails-left .p-galleria-item-wrapper,\n.p-galleria-thumbnails-right .p-galleria-item-wrapper {\n    flex-direction: row;\n}\n\n.p-galleria-thumbnails-left .p-galleria-item-wrapper,\n.p-galleria-thumbnails-top .p-galleria-item-wrapper {\n    order: 2;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnail-wrapper,\n.p-galleria-thumbnails-top .p-galleria-thumbnail-wrapper {\n    order: 1;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnail-container,\n.p-galleria-thumbnails-right .p-galleria-thumbnail-container {\n    flex-direction: column;\n    flex-grow: 1;\n}\n\n.p-galleria-thumbnails-left .p-galleria-thumbnail-items,\n.p-galleria-thumbnails-right .p-galleria-thumbnail-items {\n    flex-direction: column;\n    height: 100%;\n}\n\n/* Indicators */\n.p-galleria-indicators {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-galleria-indicator > button {\n    display: inline-flex;\n    align-items: center;\n}\n\n.p-galleria-indicators-left .p-galleria-item-wrapper,\n.p-galleria-indicators-right .p-galleria-item-wrapper {\n    flex-direction: row;\n    align-items: center;\n}\n\n.p-galleria-indicators-left .p-galleria-item-container,\n.p-galleria-indicators-top .p-galleria-item-container {\n    order: 2;\n}\n\n.p-galleria-indicators-left .p-galleria-indicators,\n.p-galleria-indicators-top .p-galleria-indicators {\n    order: 1;\n}\n\n.p-galleria-indicators-left .p-galleria-indicators,\n.p-galleria-indicators-right .p-galleria-indicators {\n    flex-direction: column;\n}\n\n.p-galleria-indicator-onitem .p-galleria-indicators {\n    position: absolute;\n    display: flex;\n}\n\n.p-galleria-indicator-onitem.p-galleria-indicators-top .p-galleria-indicators {\n    top: 0;\n    left: 0;\n    width: 100%;\n    align-items: flex-start;\n}\n\n.p-galleria-indicator-onitem.p-galleria-indicators-right .p-galleria-indicators {\n    right: 0;\n    top: 0;\n    height: 100%;\n    align-items: flex-end;\n}\n\n.p-galleria-indicator-onitem.p-galleria-indicators-bottom .p-galleria-indicators {\n    bottom: 0;\n    left: 0;\n    width: 100%;\n    align-items: flex-end;\n}\n\n.p-galleria-indicator-onitem.p-galleria-indicators-left .p-galleria-indicators {\n    left: 0;\n    top: 0;\n    height: 100%;\n    align-items: flex-start;\n}\n\n/* FullScreen */\n.p-galleria-mask {\n    position: fixed;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    display: flex;\n    align-items: center;\n    justify-content: center;\n}\n\n.p-galleria-close {\n    position: absolute;\n    top: 0;\n    right: 0;\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    overflow: hidden;\n}\n\n.p-galleria-mask .p-galleria-item-nav {\n    position: fixed;\n    top: 50%;\n    margin-top: -0.5rem;\n}\n\n/* Animation */\n.p-galleria-enter-active {\n    transition: all 150ms cubic-bezier(0, 0, 0.2, 1);\n}\n\n.p-galleria-leave-active {\n    transition: all 150ms cubic-bezier(0.4, 0, 0.2, 1);\n}\n\n.p-galleria-enter-from,\n.p-galleria-leave-to {\n    opacity: 0;\n    transform: scale(0.7);\n}\n\n.p-galleria-enter-active .p-galleria-item-nav {\n    opacity: 0;\n}\n\n/* Keyboard Support */\n.p-items-hidden .p-galleria-thumbnail-item {\n    visibility: hidden;\n}\n\n.p-items-hidden .p-galleria-thumbnail-item.p-galleria-thumbnail-item-active {\n    visibility: visible;\n}\n",{name:"galleria",manual:!0}),S={name:"BaseGalleria",extends:v.default,props:{id:{type:String,default:null},value:{type:Array,default:null},activeIndex:{type:Number,default:0},fullScreen:{type:Boolean,default:!1},visible:{type:Boolean,default:!1},numVisible:{type:Number,default:3},responsiveOptions:{type:Array,default:null},showItemNavigators:{type:Boolean,default:!1},showThumbnailNavigators:{type:Boolean,default:!0},showItemNavigatorsOnHover:{type:Boolean,default:!1},changeItemOnIndicatorHover:{type:Boolean,default:!1},circular:{type:Boolean,default:!1},autoPlay:{type:Boolean,default:!1},transitionInterval:{type:Number,default:4e3},showThumbnails:{type:Boolean,default:!0},thumbnailsPosition:{type:String,default:"bottom"},verticalThumbnailViewPortHeight:{type:String,default:"300px"},showIndicators:{type:Boolean,default:!1},showIndicatorsOnItem:{type:Boolean,default:!1},indicatorsPosition:{type:String,default:"bottom"},baseZIndex:{type:Number,default:0},maskClass:{type:String,default:null},containerStyle:{type:null,default:null},containerClass:{type:null,default:null},containerProps:{type:null,default:null},prevButtonProps:{type:null,default:null},nextButtonProps:{type:null,default:null}},css:{classes:{mask:function(e){var t=e.instance;return["p-galleria-mask p-component-overlay p-component-overlay-enter",{"p-input-filled":"filled"===t.$primevue.config.inputStyle,"p-ripple-disabled":!1===t.$primevue.config.ripple}]},root:function(e){var t=e.instance,n=t.$attrs.showThumbnails&&t.getPositionClass("p-galleria-thumbnails",t.$attrs.thumbnailsPosition),i=t.$attrs.showIndicators&&t.getPositionClass("p-galleria-indicators",t.$attrs.indicatorsPosition);return["p-galleria p-component",{"p-galleria-fullscreen":t.$attrs.fullScreen,"p-galleria-indicator-onitem":t.$attrs.showIndicatorsOnItem,"p-galleria-item-nav-onhover":t.$attrs.showItemNavigatorsOnHover&&!t.$attrs.fullScreen},n,i]},closeButton:"p-galleria-close p-link",closeIcon:"p-galleria-close-icon",header:"p-galleria-header",content:"p-galleria-content",footer:"p-galleria-footer",itemWrapper:"p-galleria-item-wrapper",itemContainer:"p-galleria-item-container",previousItemButton:function(e){return["p-galleria-item-prev p-galleria-item-nav p-link",{"p-disabled":e.instance.isNavBackwardDisabled()}]},previousItemIcon:"p-galleria-item-prev-icon",item:"p-galleria-item",nextItemButton:function(e){return["p-galleria-item-next p-galleria-item-nav p-link",{"p-disabled":e.instance.isNavForwardDisabled()}]},nextItemIcon:"p-galleria-item-next-icon",caption:"p-galleria-caption",indicators:"p-galleria-indicators p-reset",indicator:function(e){return["p-galleria-indicator",{"p-highlight":e.instance.isIndicatorItemActive(e.index)}]},indicatorButton:"p-link",thumbnailWrapper:"p-galleria-thumbnail-wrapper",thumbnailContainer:"p-galleria-thumbnail-container",previousThumbnailButton:function(e){return["p-galleria-thumbnail-prev p-link",{"p-disabled":e.instance.isNavBackwardDisabled()}]},previousThumbnailIcon:"p-galleria-thumbnail-prev-icon",thumbnailItemsContainer:"p-galleria-thumbnail-items-container",thumbnailItems:"p-galleria-thumbnail-items",thumbnailItem:function(e){var t=e.instance,n=e.index;return["p-galleria-thumbnail-item",{"p-galleria-thumbnail-item-current":e.activeIndex===n,"p-galleria-thumbnail-item-active":t.isItemActive(n),"p-galleria-thumbnail-item-start":t.firstItemAciveIndex()===n,"p-galleria-thumbnail-item-end":t.lastItemActiveIndex()===n}]},thumbnailItemContent:"p-galleria-thumbnail-item-content",nextThumbnailButton:function(e){return["p-galleria-thumbnail-next p-link",{"p-disabled":e.instance.isNavForwardDisabled()}]},nextThumbnailIcon:"p-galleria-thumbnail-next-icon"},loadStyle:w.load},provide:function(){return{$parentInstance:this}}},k={name:"GalleriaItem",hostName:"Galleria",extends:v.default,emits:["start-slideshow","stop-slideshow","update:activeIndex"],props:{circular:{type:Boolean,default:!1},activeIndex:{type:Number,default:0},value:{type:Array,default:null},showItemNavigators:{type:Boolean,default:!0},showIndicators:{type:Boolean,default:!0},slideShowActive:{type:Boolean,default:!0},changeItemOnIndicatorHover:{type:Boolean,default:!0},autoPlay:{type:Boolean,default:!1},templates:{type:null,default:null},id:{type:String,default:null}},mounted:function(){this.autoPlay&&this.$emit("start-slideshow")},methods:{getIndicatorPTOptions:function(e){return{context:{highlighted:this.activeIndex===e}}},next:function(){this.$emit("update:activeIndex",this.circular&&this.value.length-1===this.activeIndex?0:this.activeIndex+1)},prev:function(){this.$emit("update:activeIndex",this.circular&&0===this.activeIndex?this.value.length-1:0!==this.activeIndex?this.activeIndex-1:0)},stopSlideShow:function(){this.slideShowActive&&this.stopSlideShow&&this.$emit("stop-slideshow")},navBackward:function(e){this.stopSlideShow(),this.prev(),e&&e.cancelable&&e.preventDefault()},navForward:function(e){this.stopSlideShow(),this.next(),e&&e.cancelable&&e.preventDefault()},onIndicatorClick:function(e){this.stopSlideShow(),this.$emit("update:activeIndex",e)},onIndicatorMouseEnter:function(e){this.changeItemOnIndicatorHover&&(this.stopSlideShow(),this.$emit("update:activeIndex",e))},onIndicatorKeyDown:function(e,t){switch(e.code){case"Enter":case"Space":this.stopSlideShow(),this.$emit("update:activeIndex",t),e.preventDefault();break;case"ArrowDown":case"ArrowUp":e.preventDefault()}},isIndicatorItemActive:function(e){return this.activeIndex===e},isNavBackwardDisabled:function(){return!this.circular&&0===this.activeIndex},isNavForwardDisabled:function(){return!this.circular&&this.activeIndex===this.value.length-1},ariaSlideNumber:function(e){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.slideNumber.replace(/{slideNumber}/g,e):void 0},ariaPageLabel:function(e){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.pageLabel.replace(/{page}/g,e):void 0}},computed:{activeItem:function(){return this.value[this.activeIndex]},ariaSlideLabel:function(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.slide:void 0}},components:{ChevronLeftIcon:g.default,ChevronRightIcon:y.default},directives:{ripple:b.default}},B=["disabled"],P=["id","aria-label","aria-roledescription"],C=["disabled"],$=["aria-label","aria-selected","aria-controls","onClick","onMouseenter","onKeydown","data-p-highlight"];function O(e){return A(e)||N(e)||D(e)||V()}function V(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function D(e,t){if(e){if("string"==typeof e)return T(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?T(e,t):void 0}}function N(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function A(e){if(Array.isArray(e))return T(e)}function T(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,i=new Array(t);n<t;n++)i[n]=e[n];return i}k.render=function(e,t,n,i,a,r){var o=c.resolveDirective("ripple");return c.openBlock(),c.createElementBlock("div",c.mergeProps({class:e.cx("itemWrapper")},e.ptm("itemWrapper")),[c.createElementVNode("div",c.mergeProps({class:e.cx("itemContainer")},e.ptm("itemContainer")),[n.showItemNavigators?c.withDirectives((c.openBlock(),c.createElementBlock("button",c.mergeProps({key:0,type:"button",class:e.cx("previousItemButton"),onClick:t[0]||(t[0]=function(e){return r.navBackward(e)}),disabled:r.isNavBackwardDisabled()},e.ptm("previousItemButton")),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.previousitemicon||"ChevronLeftIcon"),c.mergeProps({class:e.cx("previousItemIcon")},e.ptm("previousItemIcon")),null,16,["class"]))],16,B)),[[o]]):c.createCommentVNode("",!0),c.createElementVNode("div",c.mergeProps({id:n.id+"_item_"+n.activeIndex,class:e.cx("item"),role:"group","aria-label":r.ariaSlideNumber(n.activeIndex+1),"aria-roledescription":r.ariaSlideLabel},e.ptm("item")),[n.templates.item?(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.item),{key:0,item:r.activeItem},null,8,["item"])):c.createCommentVNode("",!0)],16,P),n.showItemNavigators?c.withDirectives((c.openBlock(),c.createElementBlock("button",c.mergeProps({key:1,type:"button",class:e.cx("nextItemButton"),onClick:t[1]||(t[1]=function(e){return r.navForward(e)}),disabled:r.isNavForwardDisabled()},e.ptm("nextItemButton")),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.nextitemicon||"ChevronRightIcon"),c.mergeProps({class:e.cx("nextItemIcon")},e.ptm("nextItemIcon")),null,16,["class"]))],16,C)),[[o]]):c.createCommentVNode("",!0),n.templates.caption?(c.openBlock(),c.createElementBlock("div",c.mergeProps({key:2,class:e.cx("caption")},e.ptm("caption")),[n.templates.caption?(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.caption),{key:0,item:r.activeItem},null,8,["item"])):c.createCommentVNode("",!0)],16)):c.createCommentVNode("",!0)],16),n.showIndicators?(c.openBlock(),c.createElementBlock("ul",c.mergeProps({key:0,class:e.cx("indicators")},e.ptm("indicators")),[(c.openBlock(!0),c.createElementBlock(c.Fragment,null,c.renderList(n.value,(function(t,i){return c.openBlock(),c.createElementBlock("li",c.mergeProps({key:"p-galleria-indicator-".concat(i),class:e.cx("indicator",{index:i}),tabindex:"0","aria-label":r.ariaPageLabel(i+1),"aria-selected":n.activeIndex===i,"aria-controls":n.id+"_item_"+i,onClick:function(e){return r.onIndicatorClick(i)},onMouseenter:function(e){return r.onIndicatorMouseEnter(i)},onKeydown:function(e){return r.onIndicatorKeyDown(e,i)}},e.ptm("indicator",r.getIndicatorPTOptions(i)),{"data-p-highlight":r.isIndicatorItemActive(i)}),[n.templates.indicator?c.createCommentVNode("",!0):(c.openBlock(),c.createElementBlock("button",c.mergeProps({key:0,type:"button",tabindex:"-1",class:e.cx("indicatorButton")},e.ptm("indicatorButton",r.getIndicatorPTOptions(i))),null,16)),n.templates.indicator?(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.indicator),{key:1,index:i},null,8,["index"])):c.createCommentVNode("",!0)],16,$)})),128))],16)):c.createCommentVNode("",!0)],16)};var _={name:"GalleriaThumbnails",hostName:"Galleria",extends:v.default,emits:["stop-slideshow","update:activeIndex"],props:{containerId:{type:String,default:null},value:{type:Array,default:null},numVisible:{type:Number,default:3},activeIndex:{type:Number,default:0},isVertical:{type:Boolean,default:!1},slideShowActive:{type:Boolean,default:!1},circular:{type:Boolean,default:!1},responsiveOptions:{type:Array,default:null},contentHeight:{type:String,default:"300px"},showThumbnailNavigators:{type:Boolean,default:!0},templates:{type:null,default:null},prevButtonProps:{type:null,default:null},nextButtonProps:{type:null,default:null}},startPos:null,thumbnailsStyle:null,sortedResponsiveOptions:null,data:function(){return{d_numVisible:this.numVisible,d_oldNumVisible:this.numVisible,d_activeIndex:this.activeIndex,d_oldActiveItemIndex:this.activeIndex,totalShiftedItems:0,page:0}},watch:{numVisible:function(e,t){this.d_numVisible=e,this.d_oldNumVisible=t},activeIndex:function(e,t){this.d_activeIndex=e,this.d_oldActiveItemIndex=t}},mounted:function(){this.createStyle(),this.calculatePosition(),this.responsiveOptions&&this.bindDocumentListeners()},updated:function(){var e=this.totalShiftedItems;this.d_oldNumVisible===this.d_numVisible&&this.d_oldActiveItemIndex===this.d_activeIndex||((e=this.d_activeIndex<=this.getMedianItemIndex()?0:this.value.length-this.d_numVisible+this.getMedianItemIndex()<this.d_activeIndex?this.d_numVisible-this.value.length:this.value.length-this.d_numVisible<this.d_activeIndex&&this.d_numVisible%2==0?-1*this.d_activeIndex+this.getMedianItemIndex()+1:-1*this.d_activeIndex+this.getMedianItemIndex())!==this.totalShiftedItems&&(this.totalShiftedItems=e),this.$refs.itemsContainer.style.transform=this.isVertical?"translate3d(0, ".concat(e*(100/this.d_numVisible),"%, 0)"):"translate3d(".concat(e*(100/this.d_numVisible),"%, 0, 0)"),this.d_oldActiveItemIndex!==this.d_activeIndex&&(document.body.setAttribute("data-p-items-hidden","false"),!this.isUnstyled&&n.DomHandler.removeClass(this.$refs.itemsContainer,"p-items-hidden"),this.$refs.itemsContainer.style.transition="transform 500ms ease 0s"),this.d_oldActiveItemIndex=this.d_activeIndex,this.d_oldNumVisible=this.d_numVisible)},beforeUnmount:function(){this.responsiveOptions&&this.unbindDocumentListeners(),this.thumbnailsStyle&&this.thumbnailsStyle.parentNode.removeChild(this.thumbnailsStyle)},methods:{step:function(e){var t=this.totalShiftedItems+e;e<0&&-1*t+this.d_numVisible>this.value.length-1?t=this.d_numVisible-this.value.length:e>0&&t>0&&(t=0),this.circular&&(e<0&&this.value.length-1===this.d_activeIndex?t=0:e>0&&0===this.d_activeIndex&&(t=this.d_numVisible-this.value.length)),this.$refs.itemsContainer&&(document.body.setAttribute("data-p-items-hidden","false"),!this.isUnstyled&&n.DomHandler.removeClass(this.$refs.itemsContainer,"p-items-hidden"),this.$refs.itemsContainer.style.transform=this.isVertical?"translate3d(0, ".concat(t*(100/this.d_numVisible),"%, 0)"):"translate3d(".concat(t*(100/this.d_numVisible),"%, 0, 0)"),this.$refs.itemsContainer.style.transition="transform 500ms ease 0s"),this.totalShiftedItems=t},stopSlideShow:function(){this.slideShowActive&&this.stopSlideShow&&this.$emit("stop-slideshow")},getMedianItemIndex:function(){var e=Math.floor(this.d_numVisible/2);return this.d_numVisible%2?e:e-1},navBackward:function(e){this.stopSlideShow();var t=0!==this.d_activeIndex?this.d_activeIndex-1:0;this.d_numVisible-(t+this.totalShiftedItems)-1>this.getMedianItemIndex()&&(-1*this.totalShiftedItems!=0||this.circular)&&this.step(1),this.$emit("update:activeIndex",this.circular&&0===this.d_activeIndex?this.value.length-1:t),e.cancelable&&e.preventDefault()},navForward:function(e){this.stopSlideShow();var t=this.d_activeIndex===this.value.length-1?this.value.length-1:this.d_activeIndex+1;t+this.totalShiftedItems>this.getMedianItemIndex()&&(-1*this.totalShiftedItems<this.getTotalPageNumber()-1||this.circular)&&this.step(-1),this.$emit("update:activeIndex",this.circular&&this.value.length-1===this.d_activeIndex?0:t),e.cancelable&&e.preventDefault()},onItemClick:function(e){this.stopSlideShow();var t=e;if(t!==this.d_activeIndex){var n=t+this.totalShiftedItems,i=0;t<this.d_activeIndex?(i=this.d_numVisible-n-1-this.getMedianItemIndex())>0&&-1*this.totalShiftedItems!=0&&this.step(i):(i=this.getMedianItemIndex()-n)<0&&-1*this.totalShiftedItems<this.getTotalPageNumber()-1&&this.step(i),this.$emit("update:activeIndex",t)}},onThumbnailKeydown:function(e,t){switch("Enter"!==e.code&&"Space"!==e.code||(this.onItemClick(t),e.preventDefault()),e.code){case"ArrowRight":this.onRightKey();break;case"ArrowLeft":this.onLeftKey();break;case"Home":this.onHomeKey(),e.preventDefault();break;case"End":this.onEndKey(),e.preventDefault();break;case"ArrowUp":case"ArrowDown":e.preventDefault();break;case"Tab":this.onTabKey()}},onRightKey:function(){var e=n.DomHandler.find(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"]'),t=this.findFocusedIndicatorIndex();this.changedFocusedIndicator(t,t+1===e.length?e.length-1:t+1)},onLeftKey:function(){var e=this.findFocusedIndicatorIndex();this.changedFocusedIndicator(e,e-1<=0?0:e-1)},onHomeKey:function(){var e=this.findFocusedIndicatorIndex();this.changedFocusedIndicator(e,0)},onEndKey:function(){var e=n.DomHandler.find(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"]'),t=this.findFocusedIndicatorIndex();this.changedFocusedIndicator(t,e.length-1)},onTabKey:function(){var e=O(n.DomHandler.find(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"]')),t=e.findIndex((function(e){return!0===n.DomHandler.getAttribute(e,"data-p-active")})),i=n.DomHandler.findSingle(this.$refs.itemsContainer,'[tabindex="0"]'),a=e.findIndex((function(e){return e===i.parentElement}));e[a].children[0].tabIndex="-1",e[t].children[0].tabIndex="0"},findFocusedIndicatorIndex:function(){var e=O(n.DomHandler.find(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"]')),t=n.DomHandler.findSingle(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"] > [tabindex="0"]');return e.findIndex((function(e){return e===t.parentElement}))},changedFocusedIndicator:function(e,t){var i=n.DomHandler.find(this.$refs.itemsContainer,'[data-pc-section="thumbnailitem"]');i[e].children[0].tabIndex="-1",i[t].children[0].tabIndex="0",i[t].children[0].focus()},onTransitionEnd:function(){this.$refs.itemsContainer&&(document.body.setAttribute("data-p-items-hidden","true"),!this.isUnstyled&&n.DomHandler.addClass(this.$refs.itemsContainer,"p-items-hidden"),this.$refs.itemsContainer.style.transition="")},onTouchStart:function(e){var t=e.changedTouches[0];this.startPos={x:t.pageX,y:t.pageY}},onTouchMove:function(e){e.cancelable&&e.preventDefault()},onTouchEnd:function(e){var t=e.changedTouches[0];this.changePageOnTouch(e,this.isVertical?t.pageY-this.startPos.y:t.pageX-this.startPos.x)},changePageOnTouch:function(e,t){t<0?this.navForward(e):this.navBackward(e)},getTotalPageNumber:function(){return this.value.length>this.d_numVisible?this.value.length-this.d_numVisible+1:0},createStyle:function(){var e;this.thumbnailsStyle||(this.thumbnailsStyle=document.createElement("style"),this.thumbnailsStyle.type="text/css",n.DomHandler.setAttribute(this.thumbnailsStyle,"nonce",null===(e=this.$primevue)||void 0===e||null===(e=e.config)||void 0===e||null===(e=e.csp)||void 0===e?void 0:e.nonce),document.body.appendChild(this.thumbnailsStyle));var t="\n                #".concat(this.containerId,' [data-pc-section="thumbnailitem"] {\n                    flex: 1 0 ').concat(100/this.d_numVisible,"%\n                }\n            ");if(this.responsiveOptions&&!this.isUnstyled){this.sortedResponsiveOptions=O(this.responsiveOptions),this.sortedResponsiveOptions.sort((function(e,t){var n=e.breakpoint,i=t.breakpoint;return-1*(null==n&&null!=i?-1:null!=n&&null==i?1:null==n&&null==i?0:"string"==typeof n&&"string"==typeof i?n.localeCompare(i,void 0,{numeric:!0}):n<i?-1:n>i?1:0)}));for(var i=0;i<this.sortedResponsiveOptions.length;i++){var a=this.sortedResponsiveOptions[i];t+="\n                        @media screen and (max-width: ".concat(a.breakpoint,") {\n                            #").concat(this.containerId," .p-galleria-thumbnail-item {\n                                flex: 1 0 ").concat(100/a.numVisible,"%\n                            }\n                        }\n                    ")}}this.thumbnailsStyle.innerHTML=t},calculatePosition:function(){if(this.$refs.itemsContainer&&this.sortedResponsiveOptions){for(var e=window.innerWidth,t={numVisible:this.numVisible},n=0;n<this.sortedResponsiveOptions.length;n++){var i=this.sortedResponsiveOptions[n];parseInt(i.breakpoint,10)>=e&&(t=i)}this.d_numVisible!==t.numVisible&&(this.d_numVisible=t.numVisible)}},bindDocumentListeners:function(){var e=this;this.documentResizeListener||(this.documentResizeListener=function(){e.calculatePosition()},window.addEventListener("resize",this.documentResizeListener))},unbindDocumentListeners:function(){this.documentResizeListener&&(window.removeEventListener("resize",this.documentResizeListener),this.documentResizeListener=null)},isNavBackwardDisabled:function(){return!this.circular&&0===this.d_activeIndex||this.value.length<=this.d_numVisible},isNavForwardDisabled:function(){return!this.circular&&this.d_activeIndex===this.value.length-1||this.value.length<=this.d_numVisible},firstItemAciveIndex:function(){return-1*this.totalShiftedItems},lastItemActiveIndex:function(){return this.firstItemAciveIndex()+this.d_numVisible-1},isItemActive:function(e){return this.firstItemAciveIndex()<=e&&this.lastItemActiveIndex()>=e},ariaPageLabel:function(e){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.pageLabel.replace(/{page}/g,e):void 0}},computed:{ariaPrevButtonLabel:function(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.prevPageLabel:void 0},ariaNextButtonLabel:function(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.nextPageLabel:void 0}},components:{ChevronLeftIcon:g.default,ChevronRightIcon:y.default,ChevronUpIcon:x.default,ChevronDownIcon:I.default},directives:{ripple:b.default}};function E(e){return E="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},E(e)}function j(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);t&&(i=i.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,i)}return n}function L(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?j(Object(n),!0).forEach((function(t){H(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):j(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function H(e,t,n){return(t=R(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function R(e){var t=F(e,"string");return"symbol"===E(t)?t:String(t)}function F(e,t){if("object"!==E(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!==E(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}var U=["disabled","aria-label"],M=["data-p-active","aria-selected","aria-controls","onKeydown","data-p-galleria-thumbnail-item-current","data-p-galleria-thumbnail-item-active","data-p-galleria-thumbnail-item-start","data-p-galleria-thumbnail-item-end"],K=["tabindex","aria-label","aria-current","onClick"],q=["disabled","aria-label"];function G(e){return G="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},G(e)}function z(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);t&&(i=i.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,i)}return n}function W(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?z(Object(n),!0).forEach((function(t){Z(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):z(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function Z(e,t,n){return(t=X(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function X(e){var t=Y(e,"string");return"symbol"===G(t)?t:String(t)}function Y(e,t){if("object"!==G(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!==G(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}_.render=function(e,t,n,i,a,r){var o=c.resolveDirective("ripple");return c.openBlock(),c.createElementBlock("div",c.mergeProps({class:e.cx("thumbnailWrapper")},e.ptm("thumbnailWrapper")),[c.createElementVNode("div",c.mergeProps({class:e.cx("thumbnailContainer")},e.ptm("thumbnailContainer")),[n.showThumbnailNavigators?c.withDirectives((c.openBlock(),c.createElementBlock("button",c.mergeProps({key:0,class:e.cx("previousThumbnailButton"),disabled:r.isNavBackwardDisabled(),type:"button","aria-label":r.ariaPrevButtonLabel,onClick:t[0]||(t[0]=function(e){return r.navBackward(e)})},L(L({},n.prevButtonProps),e.ptm("previousThumbnailButton"))),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.previousthumbnailicon||(n.isVertical?"ChevronUpIcon":"ChevronLeftIcon")),c.mergeProps({class:e.cx("previousThumbnailIcon")},e.ptm("previousThumbnailIcon")),null,16,["class"]))],16,U)),[[o]]):c.createCommentVNode("",!0),c.createElementVNode("div",c.mergeProps({class:e.cx("thumbnailItemsContainer"),style:{height:n.isVertical?n.contentHeight:""}},e.ptm("thumbnailItemsContainer")),[c.createElementVNode("div",c.mergeProps({ref:"itemsContainer",class:e.cx("thumbnailItems"),role:"tablist",onTransitionend:t[1]||(t[1]=function(){return r.onTransitionEnd&&r.onTransitionEnd.apply(r,arguments)}),onTouchstart:t[2]||(t[2]=function(e){return r.onTouchStart(e)}),onTouchmove:t[3]||(t[3]=function(e){return r.onTouchMove(e)}),onTouchend:t[4]||(t[4]=function(e){return r.onTouchEnd(e)})},e.ptm("thumbnailItems")),[(c.openBlock(!0),c.createElementBlock(c.Fragment,null,c.renderList(n.value,(function(t,i){return c.openBlock(),c.createElementBlock("div",c.mergeProps({key:"p-galleria-thumbnail-item-".concat(i),class:e.cx("thumbnailItem",{index:i,activeIndex:n.activeIndex}),role:"tab","data-p-active":n.activeIndex===i,"aria-selected":n.activeIndex===i,"aria-controls":n.containerId+"_item_"+i,onKeydown:function(e){return r.onThumbnailKeydown(e,i)}},e.ptm("thumbnailItem"),{"data-p-galleria-thumbnail-item-current":n.activeIndex===i,"data-p-galleria-thumbnail-item-active":r.isItemActive(i),"data-p-galleria-thumbnail-item-start":r.firstItemAciveIndex()===i,"data-p-galleria-thumbnail-item-end":r.lastItemActiveIndex()===i}),[c.createElementVNode("div",c.mergeProps({class:e.cx("thumbnailItemContent"),tabindex:n.activeIndex===i?"0":"-1","aria-label":r.ariaPageLabel(i+1),"aria-current":n.activeIndex===i?"page":void 0,onClick:function(e){return r.onItemClick(i)}},e.ptm("thumbnailItemContent")),[n.templates.thumbnail?(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.thumbnail),{key:0,item:t},null,8,["item"])):c.createCommentVNode("",!0)],16,K)],16,M)})),128))],16)],16),n.showThumbnailNavigators?c.withDirectives((c.openBlock(),c.createElementBlock("button",c.mergeProps({key:1,class:e.cx("nextThumbnailButton"),disabled:r.isNavForwardDisabled(),type:"button","aria-label":r.ariaNextButtonLabel,onClick:t[5]||(t[5]=function(e){return r.navForward(e)})},L(L({},n.nextButtonProps),e.ptm("nextThumbnailButton"))),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(n.templates.nextthumbnailicon||(n.isVertical?"ChevronDownIcon":"ChevronRightIcon")),c.mergeProps({class:e.cx("nextThumbnailIcon")},e.ptm("nextThumbnailIcon")),null,16,["class"]))],16,q)),[[o]]):c.createCommentVNode("",!0)],16)],16)};var J={name:"GalleriaContent",hostName:"Galleria",extends:v.default,inheritAttrs:!1,interval:null,emits:["activeitem-change","mask-hide"],data:function(){return{id:this.$attrs.id||n.UniqueComponentId(),activeIndex:this.$attrs.activeIndex,numVisible:this.$attrs.numVisible,slideShowActive:!1}},watch:{"$attrs.value":function(e){e&&e.length<this.numVisible&&(this.numVisible=e.length)},"$attrs.activeIndex":function(e){this.activeIndex=e},"$attrs.numVisible":function(e){this.numVisible=e},"$attrs.autoPlay":function(e){e?this.startSlideShow():this.stopSlideShow()}},updated:function(){this.$emit("activeitem-change",this.activeIndex)},beforeUnmount:function(){this.slideShowActive&&this.stopSlideShow()},methods:{getPTOptions:function(e){return this.ptm(e,{props:W(W({},this.$attrs),{},{pt:this.pt,unstyled:this.unstyled})})},isAutoPlayActive:function(){return this.slideShowActive},startSlideShow:function(){var e=this;this.interval=setInterval((function(){e.activeIndex=e.$attrs.circular&&e.$attrs.value.length-1===e.activeIndex?0:e.activeIndex+1}),this.$attrs.transitionInterval),this.slideShowActive=!0},stopSlideShow:function(){this.interval&&clearInterval(this.interval),this.slideShowActive=!1},getPositionClass:function(e,t){var n=["top","left","bottom","right"].find((function(e){return e===t}));return n?"".concat(e,"-").concat(n):""},isVertical:function(){return"left"===this.$attrs.thumbnailsPosition||"right"===this.$attrs.thumbnailsPosition}},computed:{closeAriaLabel:function(){return this.$primevue.config.locale.aria?this.$primevue.config.locale.aria.close:void 0}},components:{GalleriaItem:k,GalleriaThumbnails:_,TimesIcon:f.default},directives:{ripple:b.default}};function Q(e){return Q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Q(e)}function ee(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);t&&(i=i.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,i)}return n}function te(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ee(Object(n),!0).forEach((function(t){ne(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ee(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function ne(e,t,n){return(t=ie(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function ie(e){var t=ae(e,"string");return"symbol"===Q(t)?t:String(t)}function ae(e,t){if("object"!==Q(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!==Q(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}var re=["id"],oe=["aria-label"],le=["aria-live"];J.render=function(e,t,n,i,a,r){var o=c.resolveComponent("GalleriaItem"),l=c.resolveComponent("GalleriaThumbnails"),s=c.resolveDirective("ripple");return e.$attrs.value&&e.$attrs.value.length>0?(c.openBlock(),c.createElementBlock("div",c.mergeProps({key:0,id:a.id,class:[e.cx("root"),e.$attrs.containerClass],style:e.$attrs.containerStyle},te(te({},e.$attrs.containerProps),r.getPTOptions("root")),{"data-pc-name":"galleria"}),[e.$attrs.fullScreen?c.withDirectives((c.openBlock(),c.createElementBlock("button",c.mergeProps({key:0,autofocus:"",type:"button",class:e.cx("closeButton"),"aria-label":r.closeAriaLabel,onClick:t[0]||(t[0]=function(t){return e.$emit("mask-hide")})},r.getPTOptions("closeButton")),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(e.$attrs.templates.closeicon||"TimesIcon"),c.mergeProps({class:e.cx("closeIcon")},r.getPTOptions("closeIcon")),null,16,["class"]))],16,oe)),[[s]]):c.createCommentVNode("",!0),e.$attrs.templates&&e.$attrs.templates.header?(c.openBlock(),c.createElementBlock("div",c.mergeProps({key:1,class:e.cx("header")},r.getPTOptions("header")),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(e.$attrs.templates.header)))],16)):c.createCommentVNode("",!0),c.createElementVNode("div",c.mergeProps({class:e.cx("content"),"aria-live":e.$attrs.autoPlay?"polite":"off"},r.getPTOptions("content")),[c.createVNode(o,{id:a.id,activeIndex:a.activeIndex,"onUpdate:activeIndex":t[1]||(t[1]=function(e){return a.activeIndex=e}),slideShowActive:a.slideShowActive,"onUpdate:slideShowActive":t[2]||(t[2]=function(e){return a.slideShowActive=e}),value:e.$attrs.value,circular:e.$attrs.circular,templates:e.$attrs.templates,showIndicators:e.$attrs.showIndicators,changeItemOnIndicatorHover:e.$attrs.changeItemOnIndicatorHover,showItemNavigators:e.$attrs.showItemNavigators,autoPlay:e.$attrs.autoPlay,onStartSlideshow:r.startSlideShow,onStopSlideshow:r.stopSlideShow,pt:e.pt,unstyled:e.unstyled},null,8,["id","activeIndex","slideShowActive","value","circular","templates","showIndicators","changeItemOnIndicatorHover","showItemNavigators","autoPlay","onStartSlideshow","onStopSlideshow","pt","unstyled"]),e.$attrs.showThumbnails?(c.openBlock(),c.createBlock(l,{key:0,activeIndex:a.activeIndex,"onUpdate:activeIndex":t[3]||(t[3]=function(e){return a.activeIndex=e}),slideShowActive:a.slideShowActive,"onUpdate:slideShowActive":t[4]||(t[4]=function(e){return a.slideShowActive=e}),containerId:a.id,value:e.$attrs.value,templates:e.$attrs.templates,numVisible:a.numVisible,responsiveOptions:e.$attrs.responsiveOptions,circular:e.$attrs.circular,isVertical:r.isVertical(),contentHeight:e.$attrs.verticalThumbnailViewPortHeight,showThumbnailNavigators:e.$attrs.showThumbnailNavigators,prevButtonProps:e.$attrs.prevButtonProps,nextButtonProps:e.$attrs.nextButtonProps,onStopSlideshow:r.stopSlideShow,pt:e.pt,unstyled:e.unstyled},null,8,["activeIndex","slideShowActive","containerId","value","templates","numVisible","responsiveOptions","circular","isVertical","contentHeight","showThumbnailNavigators","prevButtonProps","nextButtonProps","onStopSlideshow","pt","unstyled"])):c.createCommentVNode("",!0)],16,le),e.$attrs.templates&&e.$attrs.templates.footer?(c.openBlock(),c.createElementBlock("div",c.mergeProps({key:2,class:e.cx("footer")},r.getPTOptions("footer")),[(c.openBlock(),c.createBlock(c.resolveDynamicComponent(e.$attrs.templates.footer)))],16)):c.createCommentVNode("",!0)],16,re)):c.createCommentVNode("",!0)};var se={name:"Galleria",extends:S,inheritAttrs:!1,emits:["update:activeIndex","update:visible"],container:null,mask:null,data:function(){return{containerVisible:this.visible}},updated:function(){this.fullScreen&&this.visible&&(this.containerVisible=this.visible)},beforeUnmount:function(){this.fullScreen&&n.DomHandler.removeClass(document.body,"p-overflow-hidden"),this.mask=null,this.container&&(n.ZIndexUtils.clear(this.container),this.container=null)},methods:{onBeforeEnter:function(e){n.ZIndexUtils.set("modal",e,this.baseZIndex||this.$primevue.config.zIndex.modal)},onEnter:function(e){this.mask.style.zIndex=String(parseInt(e.style.zIndex,10)-1),n.DomHandler.addClass(document.body,"p-overflow-hidden"),this.focus()},onBeforeLeave:function(){!this.isUnstyled&&n.DomHandler.addClass(this.mask,"p-component-overlay-leave")},onAfterLeave:function(e){n.ZIndexUtils.clear(e),this.containerVisible=!1,n.DomHandler.removeClass(document.body,"p-overflow-hidden")},onActiveItemChange:function(e){this.activeIndex!==e&&this.$emit("update:activeIndex",e)},maskHide:function(){this.$emit("update:visible",!1)},containerRef:function(e){this.container=e},maskRef:function(e){this.mask=e},focus:function(){var e=this.container.$el.querySelector("[autofocus]");e&&e.focus()}},components:{GalleriaContent:J,Portal:h.default},directives:{focustrap:p.default}},ce=["role","aria-modal"];se.render=function(e,t,n,i,a,r){var o=c.resolveComponent("GalleriaContent"),l=c.resolveComponent("Portal"),s=c.resolveDirective("focustrap");return e.fullScreen?(c.openBlock(),c.createBlock(l,{key:0},{default:c.withCtx((function(){return[a.containerVisible?(c.openBlock(),c.createElementBlock("div",c.mergeProps({key:0,ref:r.maskRef,class:[e.cx("mask"),e.maskClass],role:e.fullScreen?"dialog":"region","aria-modal":e.fullScreen?"true":void 0},e.ptm("mask")),[c.createVNode(c.Transition,c.mergeProps({name:"p-galleria",onBeforeEnter:r.onBeforeEnter,onEnter:r.onEnter,onBeforeLeave:r.onBeforeLeave,onAfterLeave:r.onAfterLeave,appear:""},e.ptm("transition")),{default:c.withCtx((function(){return[e.visible?c.withDirectives((c.openBlock(),c.createBlock(o,c.mergeProps({key:0,ref:r.containerRef,onMaskHide:r.maskHide,templates:e.$slots,onActiveitemChange:r.onActiveItemChange,pt:e.pt,unstyled:e.unstyled},e.$props),null,16,["onMaskHide","templates","onActiveitemChange","pt","unstyled"])),[[s]]):c.createCommentVNode("",!0)]})),_:1},16,["onBeforeEnter","onEnter","onBeforeLeave","onAfterLeave"])],16,ce)):c.createCommentVNode("",!0)]})),_:1})):(c.openBlock(),c.createBlock(o,c.mergeProps({key:1,templates:e.$slots,onActiveitemChange:r.onActiveItemChange,pt:e.pt,unstyled:e.unstyled},e.$props),null,16,["templates","onActiveitemChange","pt","unstyled"]))},module.exports=se;
