import e from"primevue/basecomponent";import{useStyle as t}from"primevue/usestyle";import{openBlock as a,createElementBlock as n,mergeProps as i,createElementVNode as o,toDisplayString as s,createCommentVNode as u}from"vue";var r=t("\n@keyframes dash-frame {\n    100% {\n        stroke-dashoffset: 0;\n    }\n}\n.p-knob-range {\n    fill: none;\n    transition: stroke 0.1s ease-in;\n}\n.p-knob-value {\n    animation-name: dash-frame;\n    animation-fill-mode: forwards;\n    fill: none;\n}\n.p-knob-text {\n    font-size: 1.3rem;\n    text-align: center;\n}\n",{name:"knob",manual:!0}),l={name:"Knob",extends:{name:"BaseKnob",extends:e,props:{modelValue:{type:Number,default:null},size:{type:Number,default:100},disabled:{type:Boolean,default:!1},readonly:{type:Boolean,default:!1},step:{type:Number,default:1},min:{type:Number,default:0},max:{type:Number,default:100},valueColor:{type:String,default:"var(--primary-color, Black)"},rangeColor:{type:String,default:"var(--surface-border, LightGray)"},textColor:{type:String,default:"var(--text-color-secondary, Black)"},strokeWidth:{type:Number,default:14},showValue:{type:Boolean,default:!0},valueTemplate:{type:String,default:"{value}"},tabindex:{type:Number,default:0},"aria-labelledby":{type:String,default:null},"aria-label":{type:String,default:null}},css:{classes:{root:function(e){return["p-knob p-component",{"p-disabled":e.props.disabled}]},range:"p-knob-range",value:"p-knob-value",label:"p-knob-text"},loadStyle:r.load},provide:function(){return{$parentInstance:this}}},emits:["update:modelValue","change"],data:function(){return{radius:40,midX:50,midY:50,minRadians:4*Math.PI/3,maxRadians:-Math.PI/3}},methods:{updateValue:function(e,t){var a=Math.atan2(this.size/2-t,e-this.size/2),n=-Math.PI/2-Math.PI/6;this.updateModel(a,n)},updateModel:function(e,t){var a;if(e>this.maxRadians)a=this.mapRange(e,this.minRadians,this.maxRadians,this.min,this.max);else{if(!(e<t))return;a=this.mapRange(e+2*Math.PI,this.minRadians,this.maxRadians,this.min,this.max)}var n=Math.round((a-this.min)/this.step)*this.step+this.min;this.$emit("update:modelValue",n),this.$emit("change",n)},updateModelValue:function(e){this.$emit("update:modelValue",e>this.max?this.max:e<this.min?this.min:e)},mapRange:function(e,t,a,n,i){return(e-t)*(i-n)/(a-t)+n},onClick:function(e){this.disabled||this.readonly||this.updateValue(e.offsetX,e.offsetY)},onMouseDown:function(e){this.disabled||this.readonly||(window.addEventListener("mousemove",this.onMouseMove),window.addEventListener("mouseup",this.onMouseUp),e.preventDefault())},onMouseUp:function(e){this.disabled||this.readonly||(window.removeEventListener("mousemove",this.onMouseMove),window.removeEventListener("mouseup",this.onMouseUp),e.preventDefault())},onTouchStart:function(e){this.disabled||this.readonly||(window.addEventListener("touchmove",this.onTouchMove),window.addEventListener("touchend",this.onTouchEnd),e.preventDefault())},onTouchEnd:function(e){this.disabled||this.readonly||(window.removeEventListener("touchmove",this.onTouchMove),window.removeEventListener("touchend",this.onTouchEnd),e.preventDefault())},onMouseMove:function(e){this.disabled||this.readonly||(this.updateValue(e.offsetX,e.offsetY),e.preventDefault())},onTouchMove:function(e){if(!this.disabled&&!this.readonly&&1==e.touches.length){var t=this.$el.getBoundingClientRect(),a=e.targetTouches.item(0);this.updateValue(a.clientX-t.left,a.clientY-t.top)}},onKeyDown:function(e){if(!this.disabled&&!this.readonly)switch(e.code){case"ArrowRight":case"ArrowUp":e.preventDefault(),this.updateModelValue(this.modelValue+1);break;case"ArrowLeft":case"ArrowDown":e.preventDefault(),this.updateModelValue(this.modelValue-1);break;case"Home":e.preventDefault(),this.$emit("update:modelValue",this.min);break;case"End":e.preventDefault(),this.$emit("update:modelValue",this.max);break;case"PageUp":e.preventDefault(),this.updateModelValue(this.modelValue+10);break;case"PageDown":e.preventDefault(),this.updateModelValue(this.modelValue-10)}}},computed:{rangePath:function(){return"M ".concat(this.minX," ").concat(this.minY," A ").concat(this.radius," ").concat(this.radius," 0 1 1 ").concat(this.maxX," ").concat(this.maxY)},valuePath:function(){return"M ".concat(this.zeroX," ").concat(this.zeroY," A ").concat(this.radius," ").concat(this.radius," 0 ").concat(this.largeArc," ").concat(this.sweep," ").concat(this.valueX," ").concat(this.valueY)},zeroRadians:function(){return this.mapRange(this.min>0&&this.max>0?this.min:0,this.min,this.max,this.minRadians,this.maxRadians)},valueRadians:function(){return this.mapRange(this.modelValue,this.min,this.max,this.minRadians,this.maxRadians)},minX:function(){return this.midX+Math.cos(this.minRadians)*this.radius},minY:function(){return this.midY-Math.sin(this.minRadians)*this.radius},maxX:function(){return this.midX+Math.cos(this.maxRadians)*this.radius},maxY:function(){return this.midY-Math.sin(this.maxRadians)*this.radius},zeroX:function(){return this.midX+Math.cos(this.zeroRadians)*this.radius},zeroY:function(){return this.midY-Math.sin(this.zeroRadians)*this.radius},valueX:function(){return this.midX+Math.cos(this.valueRadians)*this.radius},valueY:function(){return this.midY-Math.sin(this.valueRadians)*this.radius},largeArc:function(){return Math.abs(this.zeroRadians-this.valueRadians)<Math.PI?0:1},sweep:function(){return this.valueRadians>this.zeroRadians?0:1},valueToDisplay:function(){return this.valueTemplate.replace(/{value}/g,this.modelValue)}}},d=["width","height","tabindex","aria-valuemin","aria-valuemax","aria-valuenow","aria-labelledby","aria-label"],h=["d","stroke-width","stroke"],m=["d","stroke-width","stroke"],c=["fill"];l.render=function(e,t,r,l,p,f){return a(),n("div",i({class:e.cx("root")},e.ptm("root"),{"data-pc-name":"knob"}),[(a(),n("svg",i({viewBox:"0 0 100 100",role:"slider",width:e.size,height:e.size,tabindex:e.readonly||e.disabled?-1:e.tabindex,"aria-valuemin":e.min,"aria-valuemax":e.max,"aria-valuenow":e.modelValue,"aria-labelledby":e.ariaLabelledby,"aria-label":e.ariaLabel,onClick:t[0]||(t[0]=function(){return f.onClick&&f.onClick.apply(f,arguments)}),onKeydown:t[1]||(t[1]=function(){return f.onKeyDown&&f.onKeyDown.apply(f,arguments)}),onMousedown:t[2]||(t[2]=function(){return f.onMouseDown&&f.onMouseDown.apply(f,arguments)}),onMouseup:t[3]||(t[3]=function(){return f.onMouseUp&&f.onMouseUp.apply(f,arguments)}),onTouchstart:t[4]||(t[4]=function(){return f.onTouchStart&&f.onTouchStart.apply(f,arguments)}),onTouchend:t[5]||(t[5]=function(){return f.onTouchEnd&&f.onTouchEnd.apply(f,arguments)})},e.ptm("svg")),[o("path",i({d:f.rangePath,"stroke-width":e.strokeWidth,stroke:e.rangeColor,class:e.cx("range")},e.ptm("range")),null,16,h),o("path",i({d:f.valuePath,"stroke-width":e.strokeWidth,stroke:e.valueColor,class:e.cx("value")},e.ptm("value")),null,16,m),e.showValue?(a(),n("text",i({key:0,x:50,y:57,"text-anchor":"middle",fill:e.textColor,class:e.cx("label")},e.ptm("label")),s(f.valueToDisplay),17,c)):u("",!0)],16,d))],16)};export{l as default};
