import BaseStyle from 'primevue/base/style';

var inlineStyles = {
  mask: function mask(_ref) {
    var position = _ref.position;
    return {
      position: 'fixed',
      height: '100%',
      width: '100%',
      left: 0,
      top: 0,
      display: 'flex',
      justifyContent: position === 'left' ? 'flex-start' : position === 'right' ? 'flex-end' : 'center',
      alignItems: position === 'top' ? 'flex-start' : position === 'bottom' ? 'flex-end' : 'center'
    };
  }
};
var classes = {
  mask: function mask(_ref2) {
    var instance = _ref2.instance,
      props = _ref2.props;
    var positions = ['left', 'right', 'top', 'bottom'];
    var pos = positions.find(function (item) {
      return item === props.position;
    });
    return ['p-sidebar-mask', {
      'p-component-overlay p-component-overlay-enter': props.modal,
      'p-sidebar-mask-scrollblocker': props.blockScroll,
      'p-sidebar-visible': instance.containerVisible,
      'p-sidebar-full': instance.fullScreen
    }, pos ? "p-sidebar-".concat(pos) : ''];
  },
  root: function root(_ref3) {
    var instance = _ref3.instance;
    return ['p-sidebar p-component', {
      'p-ripple-disabled': instance.$primevue.config.ripple === false,
      'p-sidebar-full': instance.fullScreen
    }];
  },
  header: 'p-sidebar-header',
  title: 'p-sidebar-header-content',
  closeButton: 'p-sidebar-close p-sidebar-icon p-link',
  closeIcon: 'p-sidebar-close-icon',
  content: 'p-sidebar-content'
};
var SidebarStyle = BaseStyle.extend({
  name: 'sidebar',
  classes: classes,
  inlineStyles: inlineStyles
});

export { SidebarStyle as default };
