this.primevue = this.primevue || {};
this.primevue.checkbox = (function (CheckIcon, utils, BaseComponent, CheckboxStyle, vue) {
    'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    var CheckIcon__default = /*#__PURE__*/_interopDefaultLegacy(CheckIcon);
    var BaseComponent__default = /*#__PURE__*/_interopDefaultLegacy(BaseComponent);
    var CheckboxStyle__default = /*#__PURE__*/_interopDefaultLegacy(CheckboxStyle);

    var script$1 = {
      name: 'BaseCheckbox',
      "extends": BaseComponent__default["default"],
      props: {
        value: null,
        modelValue: null,
        binary: Boolean,
        name: {
          type: String,
          "default": null
        },
        trueValue: {
          type: null,
          "default": true
        },
        falseValue: {
          type: null,
          "default": false
        },
        variant: {
          type: String,
          "default": null
        },
        invalid: {
          type: Boolean,
          "default": false
        },
        disabled: {
          type: Boolean,
          "default": false
        },
        readonly: {
          type: Boolean,
          "default": false
        },
        required: {
          type: Boolean,
          "default": false
        },
        tabindex: {
          type: Number,
          "default": null
        },
        inputId: {
          type: String,
          "default": null
        },
        inputClass: {
          type: [String, Object],
          "default": null
        },
        inputStyle: {
          type: Object,
          "default": null
        },
        ariaLabelledby: {
          type: String,
          "default": null
        },
        ariaLabel: {
          type: String,
          "default": null
        }
      },
      style: CheckboxStyle__default["default"],
      provide: function provide() {
        return {
          $parentInstance: this
        };
      }
    };

    function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
    function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
    function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
    function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
    function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
    function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
    var script = {
      name: 'Checkbox',
      "extends": script$1,
      inheritAttrs: false,
      emits: ['update:modelValue', 'change', 'focus', 'blur'],
      methods: {
        getPTOptions: function getPTOptions(key) {
          var _ptm = key === 'root' ? this.ptmi : this.ptm;
          return _ptm(key, {
            context: {
              checked: this.checked,
              disabled: this.disabled
            }
          });
        },
        onChange: function onChange(event) {
          var _this = this;
          if (!this.disabled && !this.readonly) {
            var newModelValue;
            if (this.binary) {
              newModelValue = this.checked ? this.falseValue : this.trueValue;
            } else {
              if (this.checked) newModelValue = this.modelValue.filter(function (val) {
                return !utils.ObjectUtils.equals(val, _this.value);
              });else newModelValue = this.modelValue ? [].concat(_toConsumableArray(this.modelValue), [this.value]) : [this.value];
            }
            this.$emit('update:modelValue', newModelValue);
            this.$emit('change', event);
          }
        },
        onFocus: function onFocus(event) {
          this.$emit('focus', event);
        },
        onBlur: function onBlur(event) {
          this.$emit('blur', event);
        }
      },
      computed: {
        checked: function checked() {
          return this.binary ? this.modelValue === this.trueValue : utils.ObjectUtils.contains(this.value, this.modelValue);
        }
      },
      components: {
        CheckIcon: CheckIcon__default["default"]
      }
    };

    var _hoisted_1 = ["data-p-highlight", "data-p-disabled"];
    var _hoisted_2 = ["id", "value", "name", "checked", "tabindex", "disabled", "readonly", "required", "aria-labelledby", "aria-label", "aria-invalid"];
    function render(_ctx, _cache, $props, $setup, $data, $options) {
      var _component_CheckIcon = vue.resolveComponent("CheckIcon");
      return vue.openBlock(), vue.createElementBlock("div", vue.mergeProps({
        "class": _ctx.cx('root')
      }, $options.getPTOptions('root'), {
        "data-p-highlight": $options.checked,
        "data-p-disabled": _ctx.disabled
      }), [vue.createElementVNode("input", vue.mergeProps({
        id: _ctx.inputId,
        type: "checkbox",
        "class": [_ctx.cx('input'), _ctx.inputClass],
        style: _ctx.inputStyle,
        value: _ctx.value,
        name: _ctx.name,
        checked: $options.checked,
        tabindex: _ctx.tabindex,
        disabled: _ctx.disabled,
        readonly: _ctx.readonly,
        required: _ctx.required,
        "aria-labelledby": _ctx.ariaLabelledby,
        "aria-label": _ctx.ariaLabel,
        "aria-invalid": _ctx.invalid || undefined,
        onFocus: _cache[0] || (_cache[0] = function () {
          return $options.onFocus && $options.onFocus.apply($options, arguments);
        }),
        onBlur: _cache[1] || (_cache[1] = function () {
          return $options.onBlur && $options.onBlur.apply($options, arguments);
        }),
        onChange: _cache[2] || (_cache[2] = function () {
          return $options.onChange && $options.onChange.apply($options, arguments);
        })
      }, $options.getPTOptions('input')), null, 16, _hoisted_2), vue.createElementVNode("div", vue.mergeProps({
        "class": _ctx.cx('box')
      }, $options.getPTOptions('box')), [vue.renderSlot(_ctx.$slots, "icon", {
        checked: $options.checked,
        "class": vue.normalizeClass(_ctx.cx('icon'))
      }, function () {
        return [$options.checked ? (vue.openBlock(), vue.createBlock(_component_CheckIcon, vue.mergeProps({
          key: 0,
          "class": _ctx.cx('icon')
        }, $options.getPTOptions('icon')), null, 16, ["class"])) : vue.createCommentVNode("", true)];
      })], 16)], 16, _hoisted_1);
    }

    script.render = render;

    return script;

})(primevue.icons.check, primevue.utils, primevue.basecomponent, primevue.checkbox.style, Vue);
