"use strict";var e=require("primevue/button"),t=require("primevue/icons/plus"),l=require("primevue/icons/times"),n=require("primevue/icons/upload"),o=require("primevue/message"),i=require("primevue/progressbar"),s=require("primevue/ripple"),a=require("primevue/utils"),r=require("primevue/basecomponent"),c=require("primevue/fileupload/style"),u=require("primevue/badge"),p=require("vue");function d(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}var f=d(e),m=d(t),h=d(l),g=d(n),y=d(o),v=d(i),b=d(s),B=d(r),F={name:"BaseFileUpload",extends:B.default,props:{name:{type:String,default:null},url:{type:String,default:null},mode:{type:String,default:"advanced"},multiple:{type:Boolean,default:!1},accept:{type:String,default:null},disabled:{type:Boolean,default:!1},auto:{type:Boolean,default:!1},maxFileSize:{type:Number,default:null},invalidFileSizeMessage:{type:String,default:"{0}: Invalid file size, file size should be smaller than {1}."},invalidFileTypeMessage:{type:String,default:"{0}: Invalid file type, allowed file types: {1}."},fileLimit:{type:Number,default:null},invalidFileLimitMessage:{type:String,default:"Maximum number of files exceeded, limit is {0} at most."},withCredentials:{type:Boolean,default:!1},previewWidth:{type:Number,default:50},chooseLabel:{type:String,default:null},uploadLabel:{type:String,default:null},cancelLabel:{type:String,default:null},customUpload:{type:Boolean,default:!1},showUploadButton:{type:Boolean,default:!0},showCancelButton:{type:Boolean,default:!0},chooseIcon:{type:String,default:void 0},uploadIcon:{type:String,default:void 0},cancelIcon:{type:String,default:void 0},style:null,class:null},style:d(c).default,provide:function(){return{$parentInstance:this}}},C={name:"FileContent",hostName:"FileUpload",extends:B.default,emits:["remove"],props:{files:{type:Array,default:function(){return[]}},badgeSeverity:{type:String,default:"warning"},badgeValue:{type:String,default:null},previewWidth:{type:Number,default:50},templates:{type:null,default:null}},methods:{formatSize:function(e){var t,l=(null===(t=this.$primevue.config.locale)||void 0===t?void 0:t.fileSizeTypes)||["B","KB","MB","GB","TB","PB","EB","ZB","YB"];if(0===e)return"0 ".concat(l[0]);var n=Math.floor(Math.log(e)/Math.log(1024)),o=parseFloat((e/Math.pow(1024,n)).toFixed(3));return"".concat(o," ").concat(l[n])}},components:{FileUploadButton:f.default,FileUploadBadge:d(u).default,TimesIcon:h.default}},k=["alt","src","width"];function S(e){return L(e)||x(e)||w(e)||I()}function I(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function x(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function L(e){if(Array.isArray(e))return D(e)}function E(e,t){var l="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(!l){if(Array.isArray(e)||(l=w(e))||t&&e&&"number"==typeof e.length){l&&(e=l);var n=0,o=function(){};return{s:o,n:function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}},e:function(e){throw e},f:o}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var i,s=!0,a=!1;return{s:function(){l=l.call(e)},n:function(){var e=l.next();return s=e.done,e},e:function(e){a=!0,i=e},f:function(){try{s||null==l.return||l.return()}finally{if(a)throw i}}}}function w(e,t){if(e){if("string"==typeof e)return D(e,t);var l=Object.prototype.toString.call(e).slice(8,-1);return"Object"===l&&e.constructor&&(l=e.constructor.name),"Map"===l||"Set"===l?Array.from(e):"Arguments"===l||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(l)?D(e,t):void 0}}function D(e,t){(null==t||t>e.length)&&(t=e.length);for(var l=0,n=new Array(t);l<t;l++)n[l]=e[l];return n}C.render=function(e,t,l,n,o,i){var s=p.resolveComponent("FileUploadBadge"),a=p.resolveComponent("TimesIcon"),r=p.resolveComponent("FileUploadButton");return p.openBlock(!0),p.createElementBlock(p.Fragment,null,p.renderList(l.files,(function(t,n){return p.openBlock(),p.createElementBlock("div",p.mergeProps({key:t.name+t.type+t.size,class:e.cx("file")},e.ptm("file")),[p.createElementVNode("img",p.mergeProps({role:"presentation",class:e.cx("thumbnail"),alt:t.name,src:t.objectURL,width:l.previewWidth},e.ptm("thumbnail")),null,16,k),p.createElementVNode("div",p.mergeProps({class:e.cx("details")},e.ptm("details")),[p.createElementVNode("div",p.mergeProps({class:e.cx("fileName")},e.ptm("fileName")),p.toDisplayString(t.name),17),p.createElementVNode("span",p.mergeProps({class:e.cx("fileSize")},e.ptm("fileSize")),p.toDisplayString(i.formatSize(t.size)),17),p.createVNode(s,{value:l.badgeValue,class:p.normalizeClass(e.cx("badge")),severity:l.badgeSeverity,unstyled:e.unstyled,pt:e.ptm("badge")},null,8,["value","class","severity","unstyled","pt"])],16),p.createElementVNode("div",p.mergeProps({class:e.cx("actions")},e.ptm("actions")),[p.createVNode(r,{onClick:function(t){return e.$emit("remove",n)},text:"",rounded:"",severity:"danger",class:p.normalizeClass(e.cx("removeButton")),unstyled:e.unstyled,pt:e.ptm("removeButton")},{icon:p.withCtx((function(o){return[l.templates.fileremoveicon?(p.openBlock(),p.createBlock(p.resolveDynamicComponent(l.templates.fileremoveicon),{key:0,class:p.normalizeClass(o.class),file:t,index:n},null,8,["class","file","index"])):(p.openBlock(),p.createBlock(a,p.mergeProps({key:1,class:o.class,"aria-hidden":"true"},e.ptm("removeButton").icon),null,16,["class"]))]})),_:2},1032,["onClick","class","unstyled","pt"])],16)],16)})),128)};var $={name:"FileUpload",extends:F,inheritAttrs:!1,emits:["select","uploader","before-upload","progress","upload","error","before-send","clear","remove","remove-uploaded-file"],duplicateIEEvent:!1,data:function(){return{uploadedFileCount:0,files:[],messages:[],focused:!1,progress:null,uploadedFiles:[]}},methods:{onFileSelect:function(e){if("drop"!==e.type&&this.isIE11()&&this.duplicateIEEvent)this.duplicateIEEvent=!1;else{this.messages=[],this.files=this.files||[];var t,l=E(e.dataTransfer?e.dataTransfer.files:e.target.files);try{for(l.s();!(t=l.n()).done;){var n=t.value;this.isFileSelected(n)||this.validate(n)&&(this.isImage(n)&&(n.objectURL=window.URL.createObjectURL(n)),this.files.push(n))}}catch(e){l.e(e)}finally{l.f()}this.$emit("select",{originalEvent:e,files:this.files}),this.fileLimit&&this.checkFileLimit(),this.auto&&this.hasFiles&&!this.isFileLimitExceeded()&&this.upload(),"drop"!==e.type&&this.isIE11()?this.clearIEInput():this.clearInputElement()}},choose:function(){this.$refs.fileInput.click()},upload:function(){var e=this;if(this.customUpload)this.fileLimit&&(this.uploadedFileCount+=this.files.length),this.$emit("uploader",{files:this.files}),this.clear();else{var t=new XMLHttpRequest,l=new FormData;this.$emit("before-upload",{xhr:t,formData:l});var n,o=E(this.files);try{for(o.s();!(n=o.n()).done;){var i=n.value;l.append(this.name,i,i.name)}}catch(e){o.e(e)}finally{o.f()}t.upload.addEventListener("progress",(function(t){t.lengthComputable&&(e.progress=Math.round(100*t.loaded/t.total)),e.$emit("progress",{originalEvent:t,progress:e.progress})})),t.onreadystatechange=function(){var l;4===t.readyState&&(e.progress=0,t.status>=200&&t.status<300?(e.fileLimit&&(e.uploadedFileCount+=e.files.length),e.$emit("upload",{xhr:t,files:e.files})):e.$emit("error",{xhr:t,files:e.files}),(l=e.uploadedFiles).push.apply(l,S(e.files)),e.clear())},t.open("POST",this.url,!0),this.$emit("before-send",{xhr:t,formData:l}),t.withCredentials=this.withCredentials,t.send(l)}},clear:function(){this.files=[],this.messages=null,this.$emit("clear"),this.isAdvanced&&this.clearInputElement()},onFocus:function(){this.focused=!0},onBlur:function(){this.focused=!1},isFileSelected:function(e){if(this.files&&this.files.length){var t,l=E(this.files);try{for(l.s();!(t=l.n()).done;){var n=t.value;if(n.name+n.type+n.size===e.name+e.type+e.size)return!0}}catch(e){l.e(e)}finally{l.f()}}return!1},isIE11:function(){return!!window.MSInputMethodContext&&!!document.documentMode},validate:function(e){return this.accept&&!this.isFileTypeValid(e)?(this.messages.push(this.invalidFileTypeMessage.replace("{0}",e.name).replace("{1}",this.accept)),!1):!(this.maxFileSize&&e.size>this.maxFileSize)||(this.messages.push(this.invalidFileSizeMessage.replace("{0}",e.name).replace("{1}",this.formatSize(this.maxFileSize))),!1)},isFileTypeValid:function(e){var t,l=this.accept.split(",").map((function(e){return e.trim()})),n=E(l);try{for(n.s();!(t=n.n()).done;){var o=t.value;if(this.isWildcard(o)?this.getTypeClass(e.type)===this.getTypeClass(o):e.type==o||this.getFileExtension(e).toLowerCase()===o.toLowerCase())return!0}}catch(e){n.e(e)}finally{n.f()}return!1},getTypeClass:function(e){return e.substring(0,e.indexOf("/"))},isWildcard:function(e){return-1!==e.indexOf("*")},getFileExtension:function(e){return"."+e.name.split(".").pop()},isImage:function(e){return/^image\//.test(e.type)},onDragEnter:function(e){this.disabled||(e.stopPropagation(),e.preventDefault())},onDragOver:function(e){this.disabled||(!this.isUnstyled&&a.DomHandler.addClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!0),e.stopPropagation(),e.preventDefault())},onDragLeave:function(){this.disabled||(!this.isUnstyled&&a.DomHandler.removeClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!1))},onDrop:function(e){if(!this.disabled){!this.isUnstyled&&a.DomHandler.removeClass(this.$refs.content,"p-fileupload-highlight"),this.$refs.content.setAttribute("data-p-highlight",!1),e.stopPropagation(),e.preventDefault();var t=e.dataTransfer?e.dataTransfer.files:e.target.files;(this.multiple||t&&1===t.length)&&this.onFileSelect(e)}},onBasicUploaderClick:function(e){this.hasFiles?this.upload():0===e.button&&this.$refs.fileInput.click()},remove:function(e){this.clearInputElement();var t=this.files.splice(e,1)[0];this.files=S(this.files),this.$emit("remove",{file:t,files:this.files})},removeUploadedFile:function(e){var t=this.uploadedFiles.splice(e,1)[0];this.uploadedFiles=S(this.uploadedFiles),this.$emit("remove-uploaded-file",{file:t,files:this.uploadedFiles})},clearInputElement:function(){this.$refs.fileInput.value=""},clearIEInput:function(){this.$refs.fileInput&&(this.duplicateIEEvent=!0,this.$refs.fileInput.value="")},formatSize:function(e){var t,l=(null===(t=this.$primevue.config.locale)||void 0===t?void 0:t.fileSizeTypes)||["B","KB","MB","GB","TB","PB","EB","ZB","YB"];if(0===e)return"0 ".concat(l[0]);var n=Math.floor(Math.log(e)/Math.log(1024)),o=parseFloat((e/Math.pow(1024,n)).toFixed(3));return"".concat(o," ").concat(l[n])},isFileLimitExceeded:function(){return this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount&&this.focused&&(this.focused=!1),this.fileLimit&&this.fileLimit<this.files.length+this.uploadedFileCount},checkFileLimit:function(){this.isFileLimitExceeded()&&this.messages.push(this.invalidFileLimitMessage.replace("{0}",this.fileLimit.toString()))},onMessageClose:function(){this.messages=null}},computed:{isAdvanced:function(){return"advanced"===this.mode},isBasic:function(){return"basic"===this.mode},chooseButtonClass:function(){return[this.cx("chooseButton"),this.class]},basicChooseButtonLabel:function(){return this.auto?this.chooseButtonLabel:this.hasFiles?this.files.map((function(e){return e.name})).join(", "):this.chooseButtonLabel},hasFiles:function(){return this.files&&this.files.length>0},hasUploadedFiles:function(){return this.uploadedFiles&&this.uploadedFiles.length>0},chooseDisabled:function(){return this.disabled||this.fileLimit&&this.fileLimit<=this.files.length+this.uploadedFileCount},uploadDisabled:function(){return this.disabled||!this.hasFiles||this.fileLimit&&this.fileLimit<this.files.length},cancelDisabled:function(){return this.disabled||!this.hasFiles},chooseButtonLabel:function(){return this.chooseLabel||this.$primevue.config.locale.choose},uploadButtonLabel:function(){return this.uploadLabel||this.$primevue.config.locale.upload},cancelButtonLabel:function(){return this.cancelLabel||this.$primevue.config.locale.cancel},completedLabel:function(){return this.$primevue.config.locale.completed},pendingLabel:function(){return this.$primevue.config.locale.pending}},components:{FileUploadButton:f.default,FileUploadProgressBar:v.default,FileUploadMessage:y.default,FileContent:C,PlusIcon:m.default,UploadIcon:g.default,TimesIcon:h.default},directives:{ripple:b.default}},U=["multiple","accept","disabled"],P=["accept","disabled","multiple"];$.render=function(e,t,l,n,o,i){var s=p.resolveComponent("FileUploadButton"),a=p.resolveComponent("FileUploadProgressBar"),r=p.resolveComponent("FileContent"),c=p.resolveComponent("FileUploadMessage"),u=p.resolveDirective("ripple");return i.isAdvanced?(p.openBlock(),p.createElementBlock("div",p.mergeProps({key:0,class:e.cx("root")},e.ptmi("root")),[p.createElementVNode("input",p.mergeProps({ref:"fileInput",type:"file",onChange:t[0]||(t[0]=function(){return i.onFileSelect&&i.onFileSelect.apply(i,arguments)}),multiple:e.multiple,accept:e.accept,disabled:i.chooseDisabled},e.ptm("input")),null,16,U),p.createElementVNode("div",p.mergeProps({class:e.cx("buttonbar")},e.ptm("buttonbar")),[p.renderSlot(e.$slots,"header",{files:o.files,uploadedFiles:o.uploadedFiles,chooseCallback:i.choose,uploadCallback:i.upload,clearCallback:i.clear},(function(){return[p.withDirectives((p.openBlock(),p.createElementBlock("span",p.mergeProps({class:i.chooseButtonClass,style:e.style,onClick:t[1]||(t[1]=function(){return i.choose&&i.choose.apply(i,arguments)}),onKeydown:t[2]||(t[2]=p.withKeys((function(){return i.choose&&i.choose.apply(i,arguments)}),["enter"])),onFocus:t[3]||(t[3]=function(){return i.onFocus&&i.onFocus.apply(i,arguments)}),onBlur:t[4]||(t[4]=function(){return i.onBlur&&i.onBlur.apply(i,arguments)}),tabindex:"0"},e.ptm("chooseButton")),[p.renderSlot(e.$slots,"chooseicon",{class:p.normalizeClass(e.cx("chooseIcon"))},(function(){return[(p.openBlock(),p.createBlock(p.resolveDynamicComponent(e.chooseIcon?"span":"PlusIcon"),p.mergeProps({class:[e.cx("chooseIcon"),e.chooseIcon],"aria-hidden":"true"},e.ptm("chooseIcon")),null,16,["class"]))]})),p.createElementVNode("span",p.mergeProps({class:e.cx("chooseButtonLabel")},e.ptm("chooseButtonLabel")),p.toDisplayString(i.chooseButtonLabel),17)],16)),[[u]]),e.showUploadButton?(p.openBlock(),p.createBlock(s,{key:0,label:i.uploadButtonLabel,onClick:i.upload,disabled:i.uploadDisabled,unstyled:e.unstyled,pt:e.ptm("uploadButton")},{icon:p.withCtx((function(t){return[p.renderSlot(e.$slots,"uploadicon",{},(function(){return[(p.openBlock(),p.createBlock(p.resolveDynamicComponent(e.uploadIcon?"span":"UploadIcon"),p.mergeProps({class:[t.class,e.uploadIcon],"aria-hidden":"true"},e.ptm("uploadButton").icon,{"data-pc-section":"uploadbuttonicon"}),null,16,["class"]))]}))]})),_:3},8,["label","onClick","disabled","unstyled","pt"])):p.createCommentVNode("",!0),e.showCancelButton?(p.openBlock(),p.createBlock(s,{key:1,label:i.cancelButtonLabel,onClick:i.clear,disabled:i.cancelDisabled,unstyled:e.unstyled,pt:e.ptm("cancelButton")},{icon:p.withCtx((function(t){return[p.renderSlot(e.$slots,"cancelicon",{},(function(){return[(p.openBlock(),p.createBlock(p.resolveDynamicComponent(e.cancelIcon?"span":"TimesIcon"),p.mergeProps({class:[t.class,e.cancelIcon],"aria-hidden":"true"},e.ptm("cancelButton").icon,{"data-pc-section":"cancelbuttonicon"}),null,16,["class"]))]}))]})),_:3},8,["label","onClick","disabled","unstyled","pt"])):p.createCommentVNode("",!0)]}))],16),p.createElementVNode("div",p.mergeProps({ref:"content",class:e.cx("content"),onDragenter:t[5]||(t[5]=function(){return i.onDragEnter&&i.onDragEnter.apply(i,arguments)}),onDragover:t[6]||(t[6]=function(){return i.onDragOver&&i.onDragOver.apply(i,arguments)}),onDragleave:t[7]||(t[7]=function(){return i.onDragLeave&&i.onDragLeave.apply(i,arguments)}),onDrop:t[8]||(t[8]=function(){return i.onDrop&&i.onDrop.apply(i,arguments)})},e.ptm("content"),{"data-p-highlight":!1}),[p.renderSlot(e.$slots,"content",{files:o.files,uploadedFiles:o.uploadedFiles,removeUploadedFileCallback:i.removeUploadedFile,removeFileCallback:i.remove,progress:o.progress,messages:o.messages},(function(){return[i.hasFiles?(p.openBlock(),p.createElementBlock(p.Fragment,{key:0},[p.createVNode(a,{value:o.progress,showValue:!1,unstyled:e.unstyled,pt:e.ptm("progressbar")},null,8,["value","unstyled","pt"]),p.createVNode(r,{files:o.files,onRemove:i.remove,badgeValue:i.pendingLabel,previewWidth:e.previewWidth,templates:e.$slots,unstyled:e.unstyled,pt:e.pt},null,8,["files","onRemove","badgeValue","previewWidth","templates","unstyled","pt"])],64)):p.createCommentVNode("",!0),(p.openBlock(!0),p.createElementBlock(p.Fragment,null,p.renderList(o.messages,(function(t){return p.openBlock(),p.createBlock(c,{key:t,severity:"error",onClose:i.onMessageClose,unstyled:e.unstyled,pt:e.ptm("message")},{default:p.withCtx((function(){return[p.createTextVNode(p.toDisplayString(t),1)]})),_:2},1032,["onClose","unstyled","pt"])})),128)),p.createVNode(r,{files:o.uploadedFiles,onRemove:i.removeUploadedFile,badgeValue:i.completedLabel,badgeSeverity:"success",previewWidth:e.previewWidth,templates:e.$slots,unstyled:e.unstyled,pt:e.pt},null,8,["files","onRemove","badgeValue","previewWidth","templates","unstyled","pt"])]})),!e.$slots.empty||i.hasFiles||i.hasUploadedFiles?p.createCommentVNode("",!0):(p.openBlock(),p.createElementBlock("div",p.mergeProps({key:0,class:e.cx("empty")},e.ptm("empty")),[p.renderSlot(e.$slots,"empty")],16))],16)],16)):i.isBasic?(p.openBlock(),p.createElementBlock("div",p.mergeProps({key:1,class:e.cx("root")},e.ptmi("root")),[(p.openBlock(!0),p.createElementBlock(p.Fragment,null,p.renderList(o.messages,(function(t){return p.openBlock(),p.createBlock(c,{key:t,severity:"error",onClose:i.onMessageClose,unstyled:e.unstyled,pt:e.ptm("messages")},{default:p.withCtx((function(){return[p.createTextVNode(p.toDisplayString(t),1)]})),_:2},1032,["onClose","unstyled","pt"])})),128)),p.withDirectives((p.openBlock(),p.createElementBlock("span",p.mergeProps({class:i.chooseButtonClass,style:e.style,onMouseup:t[12]||(t[12]=function(){return i.onBasicUploaderClick&&i.onBasicUploaderClick.apply(i,arguments)}),onKeydown:t[13]||(t[13]=p.withKeys((function(){return i.choose&&i.choose.apply(i,arguments)}),["enter"])),onFocus:t[14]||(t[14]=function(){return i.onFocus&&i.onFocus.apply(i,arguments)}),onBlur:t[15]||(t[15]=function(){return i.onBlur&&i.onBlur.apply(i,arguments)}),tabindex:"0"},e.ptm("chooseButton")),[!i.hasFiles||e.auto?p.renderSlot(e.$slots,"uploadicon",{key:0,class:p.normalizeClass(e.cx("uploadIcon"))},(function(){return[(p.openBlock(),p.createBlock(p.resolveDynamicComponent(e.uploadIcon?"span":"UploadIcon"),p.mergeProps({class:[e.cx("uploadIcon"),e.uploadIcon],"aria-hidden":"true"},e.ptm("uploadIcon")),null,16,["class"]))]})):p.renderSlot(e.$slots,"chooseicon",{key:1,class:p.normalizeClass(e.cx("chooseIcon"))},(function(){return[(p.openBlock(),p.createBlock(p.resolveDynamicComponent(e.chooseIcon?"span":"PlusIcon"),p.mergeProps({class:[e.cx("chooseIcon"),e.chooseIcon],"aria-hidden":"true"},e.ptm("chooseIcon")),null,16,["class"]))]})),p.createElementVNode("span",p.mergeProps({class:e.cx("label")},e.ptm("label")),p.toDisplayString(i.basicChooseButtonLabel),17),i.hasFiles?p.createCommentVNode("",!0):(p.openBlock(),p.createElementBlock("input",p.mergeProps({key:2,ref:"fileInput",type:"file",accept:e.accept,disabled:e.disabled,multiple:e.multiple,onChange:t[9]||(t[9]=function(){return i.onFileSelect&&i.onFileSelect.apply(i,arguments)}),onFocus:t[10]||(t[10]=function(){return i.onFocus&&i.onFocus.apply(i,arguments)}),onBlur:t[11]||(t[11]=function(){return i.onBlur&&i.onBlur.apply(i,arguments)})},e.ptm("input")),null,16,P))],16)),[[u]])],16)):p.createCommentVNode("",!0)},module.exports=$;
