#!/usr/bin/env node
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js
var require_ms = __commonJS({
  "../../node_modules/.pnpm/ms@2.1.2/node_modules/ms/index.js"(exports2, module2) {
    var s4 = 1e3;
    var m4 = s4 * 60;
    var h4 = m4 * 60;
    var d4 = h4 * 24;
    var w4 = d4 * 7;
    var y4 = d4 * 365.25;
    module2.exports = function(val, options2) {
      options2 = options2 || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse2(val);
      } else if (type === "number" && isFinite(val)) {
        return options2.long ? fmtLong2(val) : fmtShort2(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse2(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match4 = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match4) {
        return;
      }
      var n3 = parseFloat(match4[1]);
      var type = (match4[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n3 * y4;
        case "weeks":
        case "week":
        case "w":
          return n3 * w4;
        case "days":
        case "day":
        case "d":
          return n3 * d4;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n3 * h4;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n3 * m4;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n3 * s4;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n3;
        default:
          return void 0;
      }
    }
    __name(parse2, "parse");
    function fmtShort2(ms2) {
      var msAbs = Math.abs(ms2);
      if (msAbs >= d4) {
        return Math.round(ms2 / d4) + "d";
      }
      if (msAbs >= h4) {
        return Math.round(ms2 / h4) + "h";
      }
      if (msAbs >= m4) {
        return Math.round(ms2 / m4) + "m";
      }
      if (msAbs >= s4) {
        return Math.round(ms2 / s4) + "s";
      }
      return ms2 + "ms";
    }
    __name(fmtShort2, "fmtShort");
    function fmtLong2(ms2) {
      var msAbs = Math.abs(ms2);
      if (msAbs >= d4) {
        return plural2(ms2, msAbs, d4, "day");
      }
      if (msAbs >= h4) {
        return plural2(ms2, msAbs, h4, "hour");
      }
      if (msAbs >= m4) {
        return plural2(ms2, msAbs, m4, "minute");
      }
      if (msAbs >= s4) {
        return plural2(ms2, msAbs, s4, "second");
      }
      return ms2 + " ms";
    }
    __name(fmtLong2, "fmtLong");
    function plural2(ms2, msAbs, n3, name) {
      var isPlural = msAbs >= n3 * 1.5;
      return Math.round(ms2 / n3) + " " + name + (isPlural ? "s" : "");
    }
    __name(plural2, "plural");
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/common.js
var require_common = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/common.js"(exports2, module2) {
    function setup(env2) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env2).forEach((key) => {
        createDebug[key] = env2[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash = 0;
        for (let i3 = 0; i3 < namespace.length; i3++) {
          hash = (hash << 5) - hash + namespace.charCodeAt(i3);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      __name(selectColor, "selectColor");
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug27(...args3) {
          if (!debug27.enabled) {
            return;
          }
          const self2 = debug27;
          const curr = Number(new Date());
          const ms2 = curr - (prevTime || curr);
          self2.diff = ms2;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          args3[0] = createDebug.coerce(args3[0]);
          if (typeof args3[0] !== "string") {
            args3.unshift("%O");
          }
          let index2 = 0;
          args3[0] = args3[0].replace(/%([a-zA-Z%])/g, (match4, format2) => {
            if (match4 === "%%") {
              return "%";
            }
            index2++;
            const formatter = createDebug.formatters[format2];
            if (typeof formatter === "function") {
              const val = args3[index2];
              match4 = formatter.call(self2, val);
              args3.splice(index2, 1);
              index2--;
            }
            return match4;
          });
          createDebug.formatArgs.call(self2, args3);
          const logFn = self2.log || createDebug.log;
          logFn.apply(self2, args3);
        }
        __name(debug27, "debug");
        debug27.namespace = namespace;
        debug27.useColors = createDebug.useColors();
        debug27.color = createDebug.selectColor(namespace);
        debug27.extend = extend;
        debug27.destroy = createDebug.destroy;
        Object.defineProperty(debug27, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v3) => {
            enableOverride = v3;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug27);
        }
        return debug27;
      }
      __name(createDebug, "createDebug");
      function extend(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      __name(extend, "extend");
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        let i3;
        const split = (typeof namespaces === "string" ? namespaces : "").split(/[\s,]+/);
        const len = split.length;
        for (i3 = 0; i3 < len; i3++) {
          if (!split[i3]) {
            continue;
          }
          namespaces = split[i3].replace(/\*/g, ".*?");
          if (namespaces[0] === "-") {
            createDebug.skips.push(new RegExp("^" + namespaces.slice(1) + "$"));
          } else {
            createDebug.names.push(new RegExp("^" + namespaces + "$"));
          }
        }
      }
      __name(enable, "enable");
      function disable() {
        const namespaces = [
          ...createDebug.names.map(toNamespace),
          ...createDebug.skips.map(toNamespace).map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      __name(disable, "disable");
      function enabled(name) {
        if (name[name.length - 1] === "*") {
          return true;
        }
        let i3;
        let len;
        for (i3 = 0, len = createDebug.skips.length; i3 < len; i3++) {
          if (createDebug.skips[i3].test(name)) {
            return false;
          }
        }
        for (i3 = 0, len = createDebug.names.length; i3 < len; i3++) {
          if (createDebug.names[i3].test(name)) {
            return true;
          }
        }
        return false;
      }
      __name(enabled, "enabled");
      function toNamespace(regexp) {
        return regexp.toString().substring(2, regexp.toString().length - 2).replace(/\.\*\?$/, "*");
      }
      __name(toNamespace, "toNamespace");
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      __name(coerce, "coerce");
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      __name(destroy, "destroy");
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    __name(setup, "setup");
    module2.exports = setup;
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/browser.js"(exports2, module2) {
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.storage = localstorage();
    exports2.destroy = (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports2.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    __name(useColors, "useColors");
    function formatArgs(args3) {
      args3[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args3[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c3 = "color: " + this.color;
      args3.splice(1, 0, c3, "color: inherit");
      let index2 = 0;
      let lastC = 0;
      args3[0].replace(/%[a-zA-Z%]/g, (match4) => {
        if (match4 === "%%") {
          return;
        }
        index2++;
        if (match4 === "%c") {
          lastC = index2;
        }
      });
      args3.splice(lastC, 0, c3);
    }
    __name(formatArgs, "formatArgs");
    exports2.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports2.storage.setItem("debug", namespaces);
        } else {
          exports2.storage.removeItem("debug");
        }
      } catch (error2) {
      }
    }
    __name(save, "save");
    function load() {
      let r3;
      try {
        r3 = exports2.storage.getItem("debug");
      } catch (error2) {
      }
      if (!r3 && typeof process !== "undefined" && "env" in process) {
        r3 = process.env.DEBUG;
      }
      return r3;
    }
    __name(load, "load");
    function localstorage() {
      try {
        return localStorage;
      } catch (error2) {
      }
    }
    __name(localstorage, "localstorage");
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.j = function(v3) {
      try {
        return JSON.stringify(v3);
      } catch (error2) {
        return "[UnexpectedJSONParseError]: " + error2.message;
      }
    };
  }
});

// ../../node_modules/.pnpm/has-flag@4.0.0/node_modules/has-flag/index.js
var require_has_flag = __commonJS({
  "../../node_modules/.pnpm/has-flag@4.0.0/node_modules/has-flag/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (flag, argv = process.argv) => {
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const position = argv.indexOf(prefix + flag);
      const terminatorPosition = argv.indexOf("--");
      return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };
  }
});

// ../../node_modules/.pnpm/supports-color@7.2.0/node_modules/supports-color/index.js
var require_supports_color = __commonJS({
  "../../node_modules/.pnpm/supports-color@7.2.0/node_modules/supports-color/index.js"(exports2, module2) {
    "use strict";
    var os6 = require("os");
    var tty = require("tty");
    var hasFlag = require_has_flag();
    var { env: env2 } = process;
    var forceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
      forceColor = 0;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = 1;
    }
    if ("FORCE_COLOR" in env2) {
      if (env2.FORCE_COLOR === "true") {
        forceColor = 1;
      } else if (env2.FORCE_COLOR === "false") {
        forceColor = 0;
      } else {
        forceColor = env2.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env2.FORCE_COLOR, 10), 3);
      }
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    __name(translateLevel, "translateLevel");
    function supportsColor(haveStream, streamIsTTY) {
      if (forceColor === 0) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (haveStream && !streamIsTTY && forceColor === void 0) {
        return 0;
      }
      const min = forceColor || 0;
      if (env2.TERM === "dumb") {
        return min;
      }
      if (process.platform === "win32") {
        const osRelease = os6.release().split(".");
        if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env2) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => sign in env2) || env2.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env2) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env2.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env2.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env2) {
        const version3 = parseInt((env2.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env2.TERM_PROGRAM) {
          case "iTerm.app":
            return version3 >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env2.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env2.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env2) {
        return 1;
      }
      return min;
    }
    __name(supportsColor, "supportsColor");
    function getSupportLevel(stream3) {
      const level = supportsColor(stream3, stream3 && stream3.isTTY);
      return translateLevel(level);
    }
    __name(getSupportLevel, "getSupportLevel");
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: translateLevel(supportsColor(true, tty.isatty(1))),
      stderr: translateLevel(supportsColor(true, tty.isatty(2)))
    };
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/node.js
var require_node = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/node.js"(exports2, module2) {
    var tty = require("tty");
    var util4 = require("util");
    exports2.init = init;
    exports2.log = log4;
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.destroy = util4.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports2.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = require_supports_color();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports2.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error2) {
    }
    exports2.inspectOpts = Object.keys(process.env).filter((key) => {
      return /^debug_/i.test(key);
    }).reduce((obj, key) => {
      const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_2, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    __name(useColors, "useColors");
    function formatArgs(args3) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c3 = this.color;
        const colorCode = "\x1B[3" + (c3 < 8 ? c3 : "8;5;" + c3);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args3[0] = prefix + args3[0].split("\n").join("\n" + prefix);
        args3.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args3[0] = getDate() + name + " " + args3[0];
      }
    }
    __name(formatArgs, "formatArgs");
    function getDate() {
      if (exports2.inspectOpts.hideDate) {
        return "";
      }
      return new Date().toISOString() + " ";
    }
    __name(getDate, "getDate");
    function log4(...args3) {
      return process.stderr.write(util4.format(...args3) + "\n");
    }
    __name(log4, "log");
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    __name(save, "save");
    function load() {
      return process.env.DEBUG;
    }
    __name(load, "load");
    function init(debug27) {
      debug27.inspectOpts = {};
      const keys = Object.keys(exports2.inspectOpts);
      for (let i3 = 0; i3 < keys.length; i3++) {
        debug27.inspectOpts[keys[i3]] = exports2.inspectOpts[keys[i3]];
      }
    }
    __name(init, "init");
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.o = function(v3) {
      this.inspectOpts.colors = this.useColors;
      return util4.inspect(v3, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v3) {
      this.inspectOpts.colors = this.useColors;
      return util4.inspect(v3, this.inspectOpts);
    };
  }
});

// ../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/index.js
var require_src = __commonJS({
  "../../node_modules/.pnpm/debug@4.3.4/node_modules/debug/src/index.js"(exports2, module2) {
    if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
      module2.exports = require_browser();
    } else {
      module2.exports = require_node();
    }
  }
});

// ../../node_modules/.pnpm/color-name@1.1.4/node_modules/color-name/index.js
var require_color_name = __commonJS({
  "../../node_modules/.pnpm/color-name@1.1.4/node_modules/color-name/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/conversions.js
var require_conversions = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/conversions.js"(exports2, module2) {
    var cssKeywords = require_color_name();
    var reverseKeywords = {};
    for (const key of Object.keys(cssKeywords)) {
      reverseKeywords[cssKeywords[key]] = key;
    }
    var convert2 = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    module2.exports = convert2;
    for (const model of Object.keys(convert2)) {
      if (!("channels" in convert2[model])) {
        throw new Error("missing channels property: " + model);
      }
      if (!("labels" in convert2[model])) {
        throw new Error("missing channel labels property: " + model);
      }
      if (convert2[model].labels.length !== convert2[model].channels) {
        throw new Error("channel and label counts mismatch: " + model);
      }
      const { channels, labels } = convert2[model];
      delete convert2[model].channels;
      delete convert2[model].labels;
      Object.defineProperty(convert2[model], "channels", { value: channels });
      Object.defineProperty(convert2[model], "labels", { value: labels });
    }
    convert2.rgb.hsl = function(rgb) {
      const r3 = rgb[0] / 255;
      const g3 = rgb[1] / 255;
      const b3 = rgb[2] / 255;
      const min = Math.min(r3, g3, b3);
      const max = Math.max(r3, g3, b3);
      const delta = max - min;
      let h4;
      let s4;
      if (max === min) {
        h4 = 0;
      } else if (r3 === max) {
        h4 = (g3 - b3) / delta;
      } else if (g3 === max) {
        h4 = 2 + (b3 - r3) / delta;
      } else if (b3 === max) {
        h4 = 4 + (r3 - g3) / delta;
      }
      h4 = Math.min(h4 * 60, 360);
      if (h4 < 0) {
        h4 += 360;
      }
      const l3 = (min + max) / 2;
      if (max === min) {
        s4 = 0;
      } else if (l3 <= 0.5) {
        s4 = delta / (max + min);
      } else {
        s4 = delta / (2 - max - min);
      }
      return [h4, s4 * 100, l3 * 100];
    };
    convert2.rgb.hsv = function(rgb) {
      let rdif;
      let gdif;
      let bdif;
      let h4;
      let s4;
      const r3 = rgb[0] / 255;
      const g3 = rgb[1] / 255;
      const b3 = rgb[2] / 255;
      const v3 = Math.max(r3, g3, b3);
      const diff = v3 - Math.min(r3, g3, b3);
      const diffc = /* @__PURE__ */ __name(function(c3) {
        return (v3 - c3) / 6 / diff + 1 / 2;
      }, "diffc");
      if (diff === 0) {
        h4 = 0;
        s4 = 0;
      } else {
        s4 = diff / v3;
        rdif = diffc(r3);
        gdif = diffc(g3);
        bdif = diffc(b3);
        if (r3 === v3) {
          h4 = bdif - gdif;
        } else if (g3 === v3) {
          h4 = 1 / 3 + rdif - bdif;
        } else if (b3 === v3) {
          h4 = 2 / 3 + gdif - rdif;
        }
        if (h4 < 0) {
          h4 += 1;
        } else if (h4 > 1) {
          h4 -= 1;
        }
      }
      return [
        h4 * 360,
        s4 * 100,
        v3 * 100
      ];
    };
    convert2.rgb.hwb = function(rgb) {
      const r3 = rgb[0];
      const g3 = rgb[1];
      let b3 = rgb[2];
      const h4 = convert2.rgb.hsl(rgb)[0];
      const w4 = 1 / 255 * Math.min(r3, Math.min(g3, b3));
      b3 = 1 - 1 / 255 * Math.max(r3, Math.max(g3, b3));
      return [h4, w4 * 100, b3 * 100];
    };
    convert2.rgb.cmyk = function(rgb) {
      const r3 = rgb[0] / 255;
      const g3 = rgb[1] / 255;
      const b3 = rgb[2] / 255;
      const k = Math.min(1 - r3, 1 - g3, 1 - b3);
      const c3 = (1 - r3 - k) / (1 - k) || 0;
      const m4 = (1 - g3 - k) / (1 - k) || 0;
      const y4 = (1 - b3 - k) / (1 - k) || 0;
      return [c3 * 100, m4 * 100, y4 * 100, k * 100];
    };
    function comparativeDistance(x, y4) {
      return (x[0] - y4[0]) ** 2 + (x[1] - y4[1]) ** 2 + (x[2] - y4[2]) ** 2;
    }
    __name(comparativeDistance, "comparativeDistance");
    convert2.rgb.keyword = function(rgb) {
      const reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      let currentClosestDistance = Infinity;
      let currentClosestKeyword;
      for (const keyword of Object.keys(cssKeywords)) {
        const value = cssKeywords[keyword];
        const distance = comparativeDistance(rgb, value);
        if (distance < currentClosestDistance) {
          currentClosestDistance = distance;
          currentClosestKeyword = keyword;
        }
      }
      return currentClosestKeyword;
    };
    convert2.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert2.rgb.xyz = function(rgb) {
      let r3 = rgb[0] / 255;
      let g3 = rgb[1] / 255;
      let b3 = rgb[2] / 255;
      r3 = r3 > 0.04045 ? ((r3 + 0.055) / 1.055) ** 2.4 : r3 / 12.92;
      g3 = g3 > 0.04045 ? ((g3 + 0.055) / 1.055) ** 2.4 : g3 / 12.92;
      b3 = b3 > 0.04045 ? ((b3 + 0.055) / 1.055) ** 2.4 : b3 / 12.92;
      const x = r3 * 0.4124 + g3 * 0.3576 + b3 * 0.1805;
      const y4 = r3 * 0.2126 + g3 * 0.7152 + b3 * 0.0722;
      const z = r3 * 0.0193 + g3 * 0.1192 + b3 * 0.9505;
      return [x * 100, y4 * 100, z * 100];
    };
    convert2.rgb.lab = function(rgb) {
      const xyz = convert2.rgb.xyz(rgb);
      let x = xyz[0];
      let y4 = xyz[1];
      let z = xyz[2];
      x /= 95.047;
      y4 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? x ** (1 / 3) : 7.787 * x + 16 / 116;
      y4 = y4 > 8856e-6 ? y4 ** (1 / 3) : 7.787 * y4 + 16 / 116;
      z = z > 8856e-6 ? z ** (1 / 3) : 7.787 * z + 16 / 116;
      const l3 = 116 * y4 - 16;
      const a3 = 500 * (x - y4);
      const b3 = 200 * (y4 - z);
      return [l3, a3, b3];
    };
    convert2.hsl.rgb = function(hsl) {
      const h4 = hsl[0] / 360;
      const s4 = hsl[1] / 100;
      const l3 = hsl[2] / 100;
      let t22;
      let t32;
      let val;
      if (s4 === 0) {
        val = l3 * 255;
        return [val, val, val];
      }
      if (l3 < 0.5) {
        t22 = l3 * (1 + s4);
      } else {
        t22 = l3 + s4 - l3 * s4;
      }
      const t1 = 2 * l3 - t22;
      const rgb = [0, 0, 0];
      for (let i3 = 0; i3 < 3; i3++) {
        t32 = h4 + 1 / 3 * -(i3 - 1);
        if (t32 < 0) {
          t32++;
        }
        if (t32 > 1) {
          t32--;
        }
        if (6 * t32 < 1) {
          val = t1 + (t22 - t1) * 6 * t32;
        } else if (2 * t32 < 1) {
          val = t22;
        } else if (3 * t32 < 2) {
          val = t1 + (t22 - t1) * (2 / 3 - t32) * 6;
        } else {
          val = t1;
        }
        rgb[i3] = val * 255;
      }
      return rgb;
    };
    convert2.hsl.hsv = function(hsl) {
      const h4 = hsl[0];
      let s4 = hsl[1] / 100;
      let l3 = hsl[2] / 100;
      let smin = s4;
      const lmin = Math.max(l3, 0.01);
      l3 *= 2;
      s4 *= l3 <= 1 ? l3 : 2 - l3;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      const v3 = (l3 + s4) / 2;
      const sv = l3 === 0 ? 2 * smin / (lmin + smin) : 2 * s4 / (l3 + s4);
      return [h4, sv * 100, v3 * 100];
    };
    convert2.hsv.rgb = function(hsv) {
      const h4 = hsv[0] / 60;
      const s4 = hsv[1] / 100;
      let v3 = hsv[2] / 100;
      const hi = Math.floor(h4) % 6;
      const f3 = h4 - Math.floor(h4);
      const p3 = 255 * v3 * (1 - s4);
      const q = 255 * v3 * (1 - s4 * f3);
      const t5 = 255 * v3 * (1 - s4 * (1 - f3));
      v3 *= 255;
      switch (hi) {
        case 0:
          return [v3, t5, p3];
        case 1:
          return [q, v3, p3];
        case 2:
          return [p3, v3, t5];
        case 3:
          return [p3, q, v3];
        case 4:
          return [t5, p3, v3];
        case 5:
          return [v3, p3, q];
      }
    };
    convert2.hsv.hsl = function(hsv) {
      const h4 = hsv[0];
      const s4 = hsv[1] / 100;
      const v3 = hsv[2] / 100;
      const vmin = Math.max(v3, 0.01);
      let sl;
      let l3;
      l3 = (2 - s4) * v3;
      const lmin = (2 - s4) * vmin;
      sl = s4 * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l3 /= 2;
      return [h4, sl * 100, l3 * 100];
    };
    convert2.hwb.rgb = function(hwb) {
      const h4 = hwb[0] / 360;
      let wh = hwb[1] / 100;
      let bl = hwb[2] / 100;
      const ratio = wh + bl;
      let f3;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      const i3 = Math.floor(6 * h4);
      const v3 = 1 - bl;
      f3 = 6 * h4 - i3;
      if ((i3 & 1) !== 0) {
        f3 = 1 - f3;
      }
      const n3 = wh + f3 * (v3 - wh);
      let r3;
      let g3;
      let b3;
      switch (i3) {
        default:
        case 6:
        case 0:
          r3 = v3;
          g3 = n3;
          b3 = wh;
          break;
        case 1:
          r3 = n3;
          g3 = v3;
          b3 = wh;
          break;
        case 2:
          r3 = wh;
          g3 = v3;
          b3 = n3;
          break;
        case 3:
          r3 = wh;
          g3 = n3;
          b3 = v3;
          break;
        case 4:
          r3 = n3;
          g3 = wh;
          b3 = v3;
          break;
        case 5:
          r3 = v3;
          g3 = wh;
          b3 = n3;
          break;
      }
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.cmyk.rgb = function(cmyk) {
      const c3 = cmyk[0] / 100;
      const m4 = cmyk[1] / 100;
      const y4 = cmyk[2] / 100;
      const k = cmyk[3] / 100;
      const r3 = 1 - Math.min(1, c3 * (1 - k) + k);
      const g3 = 1 - Math.min(1, m4 * (1 - k) + k);
      const b3 = 1 - Math.min(1, y4 * (1 - k) + k);
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.xyz.rgb = function(xyz) {
      const x = xyz[0] / 100;
      const y4 = xyz[1] / 100;
      const z = xyz[2] / 100;
      let r3;
      let g3;
      let b3;
      r3 = x * 3.2406 + y4 * -1.5372 + z * -0.4986;
      g3 = x * -0.9689 + y4 * 1.8758 + z * 0.0415;
      b3 = x * 0.0557 + y4 * -0.204 + z * 1.057;
      r3 = r3 > 31308e-7 ? 1.055 * r3 ** (1 / 2.4) - 0.055 : r3 * 12.92;
      g3 = g3 > 31308e-7 ? 1.055 * g3 ** (1 / 2.4) - 0.055 : g3 * 12.92;
      b3 = b3 > 31308e-7 ? 1.055 * b3 ** (1 / 2.4) - 0.055 : b3 * 12.92;
      r3 = Math.min(Math.max(0, r3), 1);
      g3 = Math.min(Math.max(0, g3), 1);
      b3 = Math.min(Math.max(0, b3), 1);
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.xyz.lab = function(xyz) {
      let x = xyz[0];
      let y4 = xyz[1];
      let z = xyz[2];
      x /= 95.047;
      y4 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? x ** (1 / 3) : 7.787 * x + 16 / 116;
      y4 = y4 > 8856e-6 ? y4 ** (1 / 3) : 7.787 * y4 + 16 / 116;
      z = z > 8856e-6 ? z ** (1 / 3) : 7.787 * z + 16 / 116;
      const l3 = 116 * y4 - 16;
      const a3 = 500 * (x - y4);
      const b3 = 200 * (y4 - z);
      return [l3, a3, b3];
    };
    convert2.lab.xyz = function(lab) {
      const l3 = lab[0];
      const a3 = lab[1];
      const b3 = lab[2];
      let x;
      let y4;
      let z;
      y4 = (l3 + 16) / 116;
      x = a3 / 500 + y4;
      z = y4 - b3 / 200;
      const y22 = y4 ** 3;
      const x2 = x ** 3;
      const z2 = z ** 3;
      y4 = y22 > 8856e-6 ? y22 : (y4 - 16 / 116) / 7.787;
      x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 8856e-6 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y4 *= 100;
      z *= 108.883;
      return [x, y4, z];
    };
    convert2.lab.lch = function(lab) {
      const l3 = lab[0];
      const a3 = lab[1];
      const b3 = lab[2];
      let h4;
      const hr = Math.atan2(b3, a3);
      h4 = hr * 360 / 2 / Math.PI;
      if (h4 < 0) {
        h4 += 360;
      }
      const c3 = Math.sqrt(a3 * a3 + b3 * b3);
      return [l3, c3, h4];
    };
    convert2.lch.lab = function(lch) {
      const l3 = lch[0];
      const c3 = lch[1];
      const h4 = lch[2];
      const hr = h4 / 360 * 2 * Math.PI;
      const a3 = c3 * Math.cos(hr);
      const b3 = c3 * Math.sin(hr);
      return [l3, a3, b3];
    };
    convert2.rgb.ansi16 = function(args3, saturation = null) {
      const [r3, g3, b3] = args3;
      let value = saturation === null ? convert2.rgb.hsv(args3)[2] : saturation;
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      let ansi = 30 + (Math.round(b3 / 255) << 2 | Math.round(g3 / 255) << 1 | Math.round(r3 / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert2.hsv.ansi16 = function(args3) {
      return convert2.rgb.ansi16(convert2.hsv.rgb(args3), args3[2]);
    };
    convert2.rgb.ansi256 = function(args3) {
      const r3 = args3[0];
      const g3 = args3[1];
      const b3 = args3[2];
      if (r3 === g3 && g3 === b3) {
        if (r3 < 8) {
          return 16;
        }
        if (r3 > 248) {
          return 231;
        }
        return Math.round((r3 - 8) / 247 * 24) + 232;
      }
      const ansi = 16 + 36 * Math.round(r3 / 255 * 5) + 6 * Math.round(g3 / 255 * 5) + Math.round(b3 / 255 * 5);
      return ansi;
    };
    convert2.ansi16.rgb = function(args3) {
      let color = args3 % 10;
      if (color === 0 || color === 7) {
        if (args3 > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      const mult = (~~(args3 > 50) + 1) * 0.5;
      const r3 = (color & 1) * mult * 255;
      const g3 = (color >> 1 & 1) * mult * 255;
      const b3 = (color >> 2 & 1) * mult * 255;
      return [r3, g3, b3];
    };
    convert2.ansi256.rgb = function(args3) {
      if (args3 >= 232) {
        const c3 = (args3 - 232) * 10 + 8;
        return [c3, c3, c3];
      }
      args3 -= 16;
      let rem;
      const r3 = Math.floor(args3 / 36) / 5 * 255;
      const g3 = Math.floor((rem = args3 % 36) / 6) / 5 * 255;
      const b3 = rem % 6 / 5 * 255;
      return [r3, g3, b3];
    };
    convert2.rgb.hex = function(args3) {
      const integer = ((Math.round(args3[0]) & 255) << 16) + ((Math.round(args3[1]) & 255) << 8) + (Math.round(args3[2]) & 255);
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.hex.rgb = function(args3) {
      const match4 = args3.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match4) {
        return [0, 0, 0];
      }
      let colorString = match4[0];
      if (match4[0].length === 3) {
        colorString = colorString.split("").map((char) => {
          return char + char;
        }).join("");
      }
      const integer = parseInt(colorString, 16);
      const r3 = integer >> 16 & 255;
      const g3 = integer >> 8 & 255;
      const b3 = integer & 255;
      return [r3, g3, b3];
    };
    convert2.rgb.hcg = function(rgb) {
      const r3 = rgb[0] / 255;
      const g3 = rgb[1] / 255;
      const b3 = rgb[2] / 255;
      const max = Math.max(Math.max(r3, g3), b3);
      const min = Math.min(Math.min(r3, g3), b3);
      const chroma = max - min;
      let grayscale;
      let hue;
      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max === r3) {
        hue = (g3 - b3) / chroma % 6;
      } else if (max === g3) {
        hue = 2 + (b3 - r3) / chroma;
      } else {
        hue = 4 + (r3 - g3) / chroma;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert2.hsl.hcg = function(hsl) {
      const s4 = hsl[1] / 100;
      const l3 = hsl[2] / 100;
      const c3 = l3 < 0.5 ? 2 * s4 * l3 : 2 * s4 * (1 - l3);
      let f3 = 0;
      if (c3 < 1) {
        f3 = (l3 - 0.5 * c3) / (1 - c3);
      }
      return [hsl[0], c3 * 100, f3 * 100];
    };
    convert2.hsv.hcg = function(hsv) {
      const s4 = hsv[1] / 100;
      const v3 = hsv[2] / 100;
      const c3 = s4 * v3;
      let f3 = 0;
      if (c3 < 1) {
        f3 = (v3 - c3) / (1 - c3);
      }
      return [hsv[0], c3 * 100, f3 * 100];
    };
    convert2.hcg.rgb = function(hcg) {
      const h4 = hcg[0] / 360;
      const c3 = hcg[1] / 100;
      const g3 = hcg[2] / 100;
      if (c3 === 0) {
        return [g3 * 255, g3 * 255, g3 * 255];
      }
      const pure = [0, 0, 0];
      const hi = h4 % 1 * 6;
      const v3 = hi % 1;
      const w4 = 1 - v3;
      let mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v3;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w4;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v3;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w4;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v3;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w4;
      }
      mg = (1 - c3) * g3;
      return [
        (c3 * pure[0] + mg) * 255,
        (c3 * pure[1] + mg) * 255,
        (c3 * pure[2] + mg) * 255
      ];
    };
    convert2.hcg.hsv = function(hcg) {
      const c3 = hcg[1] / 100;
      const g3 = hcg[2] / 100;
      const v3 = c3 + g3 * (1 - c3);
      let f3 = 0;
      if (v3 > 0) {
        f3 = c3 / v3;
      }
      return [hcg[0], f3 * 100, v3 * 100];
    };
    convert2.hcg.hsl = function(hcg) {
      const c3 = hcg[1] / 100;
      const g3 = hcg[2] / 100;
      const l3 = g3 * (1 - c3) + 0.5 * c3;
      let s4 = 0;
      if (l3 > 0 && l3 < 0.5) {
        s4 = c3 / (2 * l3);
      } else if (l3 >= 0.5 && l3 < 1) {
        s4 = c3 / (2 * (1 - l3));
      }
      return [hcg[0], s4 * 100, l3 * 100];
    };
    convert2.hcg.hwb = function(hcg) {
      const c3 = hcg[1] / 100;
      const g3 = hcg[2] / 100;
      const v3 = c3 + g3 * (1 - c3);
      return [hcg[0], (v3 - c3) * 100, (1 - v3) * 100];
    };
    convert2.hwb.hcg = function(hwb) {
      const w4 = hwb[1] / 100;
      const b3 = hwb[2] / 100;
      const v3 = 1 - b3;
      const c3 = v3 - w4;
      let g3 = 0;
      if (c3 < 1) {
        g3 = (v3 - c3) / (1 - c3);
      }
      return [hwb[0], c3 * 100, g3 * 100];
    };
    convert2.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert2.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert2.gray.rgb = function(args3) {
      return [args3[0] / 100 * 255, args3[0] / 100 * 255, args3[0] / 100 * 255];
    };
    convert2.gray.hsl = function(args3) {
      return [0, 0, args3[0]];
    };
    convert2.gray.hsv = convert2.gray.hsl;
    convert2.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert2.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert2.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert2.gray.hex = function(gray) {
      const val = Math.round(gray[0] / 100 * 255) & 255;
      const integer = (val << 16) + (val << 8) + val;
      const string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.rgb.gray = function(rgb) {
      const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/route.js
var require_route = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/route.js"(exports2, module2) {
    var conversions = require_conversions();
    function buildGraph() {
      const graph = {};
      const models = Object.keys(conversions);
      for (let len = models.length, i3 = 0; i3 < len; i3++) {
        graph[models[i3]] = {
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    __name(buildGraph, "buildGraph");
    function deriveBFS(fromModel) {
      const graph = buildGraph();
      const queue2 = [fromModel];
      graph[fromModel].distance = 0;
      while (queue2.length) {
        const current = queue2.pop();
        const adjacents = Object.keys(conversions[current]);
        for (let len = adjacents.length, i3 = 0; i3 < len; i3++) {
          const adjacent = adjacents[i3];
          const node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue2.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    __name(deriveBFS, "deriveBFS");
    function link3(from, to) {
      return function(args3) {
        return to(from(args3));
      };
    }
    __name(link3, "link");
    function wrapConversion(toModel, graph) {
      const path32 = [graph[toModel].parent, toModel];
      let fn2 = conversions[graph[toModel].parent][toModel];
      let cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path32.unshift(graph[cur].parent);
        fn2 = link3(conversions[graph[cur].parent][cur], fn2);
        cur = graph[cur].parent;
      }
      fn2.conversion = path32;
      return fn2;
    }
    __name(wrapConversion, "wrapConversion");
    module2.exports = function(fromModel) {
      const graph = deriveBFS(fromModel);
      const conversion = {};
      const models = Object.keys(graph);
      for (let len = models.length, i3 = 0; i3 < len; i3++) {
        const toModel = models[i3];
        const node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/index.js
var require_color_convert = __commonJS({
  "../../node_modules/.pnpm/color-convert@2.0.1/node_modules/color-convert/index.js"(exports2, module2) {
    var conversions = require_conversions();
    var route = require_route();
    var convert2 = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn2) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args3) {
        const arg0 = args3[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args3 = arg0;
        }
        return fn2(args3);
      }, "wrappedFn");
      if ("conversion" in fn2) {
        wrappedFn.conversion = fn2.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRaw, "wrapRaw");
    function wrapRounded(fn2) {
      const wrappedFn = /* @__PURE__ */ __name(function(...args3) {
        const arg0 = args3[0];
        if (arg0 === void 0 || arg0 === null) {
          return arg0;
        }
        if (arg0.length > 1) {
          args3 = arg0;
        }
        const result = fn2(args3);
        if (typeof result === "object") {
          for (let len = result.length, i3 = 0; i3 < len; i3++) {
            result[i3] = Math.round(result[i3]);
          }
        }
        return result;
      }, "wrappedFn");
      if ("conversion" in fn2) {
        wrappedFn.conversion = fn2.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRounded, "wrapRounded");
    models.forEach((fromModel) => {
      convert2[fromModel] = {};
      Object.defineProperty(convert2[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert2[fromModel], "labels", { value: conversions[fromModel].labels });
      const routes = route(fromModel);
      const routeModels = Object.keys(routes);
      routeModels.forEach((toModel) => {
        const fn2 = routes[toModel];
        convert2[fromModel][toModel] = wrapRounded(fn2);
        convert2[fromModel][toModel].raw = wrapRaw(fn2);
      });
    });
    module2.exports = convert2;
  }
});

// ../../node_modules/.pnpm/ansi-styles@4.3.0/node_modules/ansi-styles/index.js
var require_ansi_styles = __commonJS({
  "../../node_modules/.pnpm/ansi-styles@4.3.0/node_modules/ansi-styles/index.js"(exports2, module2) {
    "use strict";
    var wrapAnsi16 = /* @__PURE__ */ __name((fn2, offset) => (...args3) => {
      const code = fn2(...args3);
      return `\x1B[${code + offset}m`;
    }, "wrapAnsi16");
    var wrapAnsi256 = /* @__PURE__ */ __name((fn2, offset) => (...args3) => {
      const code = fn2(...args3);
      return `\x1B[${38 + offset};5;${code}m`;
    }, "wrapAnsi256");
    var wrapAnsi16m = /* @__PURE__ */ __name((fn2, offset) => (...args3) => {
      const rgb = fn2(...args3);
      return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    }, "wrapAnsi16m");
    var ansi2ansi = /* @__PURE__ */ __name((n3) => n3, "ansi2ansi");
    var rgb2rgb = /* @__PURE__ */ __name((r3, g3, b3) => [r3, g3, b3], "rgb2rgb");
    var setLazyProperty = /* @__PURE__ */ __name((object, property, get) => {
      Object.defineProperty(object, property, {
        get: () => {
          const value = get();
          Object.defineProperty(object, property, {
            value,
            enumerable: true,
            configurable: true
          });
          return value;
        },
        enumerable: true,
        configurable: true
      });
    }, "setLazyProperty");
    var colorConvert;
    var makeDynamicStyles = /* @__PURE__ */ __name((wrap2, targetSpace, identity4, isBackground) => {
      if (colorConvert === void 0) {
        colorConvert = require_color_convert();
      }
      const offset = isBackground ? 10 : 0;
      const styles = {};
      for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
        const name = sourceSpace === "ansi16" ? "ansi" : sourceSpace;
        if (sourceSpace === targetSpace) {
          styles[name] = wrap2(identity4, offset);
        } else if (typeof suite === "object") {
          styles[name] = wrap2(suite[targetSpace], offset);
        }
      }
      return styles;
    }, "makeDynamicStyles");
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          blackBright: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.gray = styles.color.blackBright;
      styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
      styles.color.grey = styles.color.blackBright;
      styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;
      for (const [groupName, group] of Object.entries(styles)) {
        for (const [styleName, style] of Object.entries(group)) {
          styles[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
      }
      Object.defineProperty(styles, "codes", {
        value: codes,
        enumerable: false
      });
      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      setLazyProperty(styles.color, "ansi", () => makeDynamicStyles(wrapAnsi16, "ansi16", ansi2ansi, false));
      setLazyProperty(styles.color, "ansi256", () => makeDynamicStyles(wrapAnsi256, "ansi256", ansi2ansi, false));
      setLazyProperty(styles.color, "ansi16m", () => makeDynamicStyles(wrapAnsi16m, "rgb", rgb2rgb, false));
      setLazyProperty(styles.bgColor, "ansi", () => makeDynamicStyles(wrapAnsi16, "ansi16", ansi2ansi, true));
      setLazyProperty(styles.bgColor, "ansi256", () => makeDynamicStyles(wrapAnsi256, "ansi256", ansi2ansi, true));
      setLazyProperty(styles.bgColor, "ansi16m", () => makeDynamicStyles(wrapAnsi16m, "rgb", rgb2rgb, true));
      return styles;
    }
    __name(assembleStyles, "assembleStyles");
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/util.js
var require_util = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/util.js"(exports2, module2) {
    "use strict";
    var stringReplaceAll = /* @__PURE__ */ __name((string, substring, replacer) => {
      let index2 = string.indexOf(substring);
      if (index2 === -1) {
        return string;
      }
      const substringLength = substring.length;
      let endIndex = 0;
      let returnValue = "";
      do {
        returnValue += string.substr(endIndex, index2 - endIndex) + substring + replacer;
        endIndex = index2 + substringLength;
        index2 = string.indexOf(substring, endIndex);
      } while (index2 !== -1);
      returnValue += string.substr(endIndex);
      return returnValue;
    }, "stringReplaceAll");
    var stringEncaseCRLFWithFirstIndex = /* @__PURE__ */ __name((string, prefix, postfix, index2) => {
      let endIndex = 0;
      let returnValue = "";
      do {
        const gotCR = string[index2 - 1] === "\r";
        returnValue += string.substr(endIndex, (gotCR ? index2 - 1 : index2) - endIndex) + prefix + (gotCR ? "\r\n" : "\n") + postfix;
        endIndex = index2 + 1;
        index2 = string.indexOf("\n", endIndex);
      } while (index2 !== -1);
      returnValue += string.substr(endIndex);
      return returnValue;
    }, "stringEncaseCRLFWithFirstIndex");
    module2.exports = {
      stringReplaceAll,
      stringEncaseCRLFWithFirstIndex
    };
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/templates.js
var require_templates = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/templates.js"(exports2, module2) {
    "use strict";
    var TEMPLATE_REGEX = /(?:\\(u(?:[a-f\d]{4}|\{[a-f\d]{1,6}\})|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
    var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
    var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
    var ESCAPE_REGEX = /\\(u(?:[a-f\d]{4}|{[a-f\d]{1,6}})|x[a-f\d]{2}|.)|([^\\])/gi;
    var ESCAPES = /* @__PURE__ */ new Map([
      ["n", "\n"],
      ["r", "\r"],
      ["t", "	"],
      ["b", "\b"],
      ["f", "\f"],
      ["v", "\v"],
      ["0", "\0"],
      ["\\", "\\"],
      ["e", "\x1B"],
      ["a", "\x07"]
    ]);
    function unescape2(c3) {
      const u3 = c3[0] === "u";
      const bracket = c3[1] === "{";
      if (u3 && !bracket && c3.length === 5 || c3[0] === "x" && c3.length === 3) {
        return String.fromCharCode(parseInt(c3.slice(1), 16));
      }
      if (u3 && bracket) {
        return String.fromCodePoint(parseInt(c3.slice(2, -1), 16));
      }
      return ESCAPES.get(c3) || c3;
    }
    __name(unescape2, "unescape");
    function parseArguments(name, arguments_) {
      const results = [];
      const chunks = arguments_.trim().split(/\s*,\s*/g);
      let matches;
      for (const chunk of chunks) {
        const number = Number(chunk);
        if (!Number.isNaN(number)) {
          results.push(number);
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, (m4, escape2, character) => escape2 ? unescape2(escape2) : character));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
      return results;
    }
    __name(parseArguments, "parseArguments");
    function parseStyle(style) {
      STYLE_REGEX.lastIndex = 0;
      const results = [];
      let matches;
      while ((matches = STYLE_REGEX.exec(style)) !== null) {
        const name = matches[1];
        if (matches[2]) {
          const args3 = parseArguments(name, matches[2]);
          results.push([name].concat(args3));
        } else {
          results.push([name]);
        }
      }
      return results;
    }
    __name(parseStyle, "parseStyle");
    function buildStyle(chalk63, styles) {
      const enabled = {};
      for (const layer of styles) {
        for (const style of layer.styles) {
          enabled[style[0]] = layer.inverse ? null : style.slice(1);
        }
      }
      let current = chalk63;
      for (const [styleName, styles2] of Object.entries(enabled)) {
        if (!Array.isArray(styles2)) {
          continue;
        }
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }
        current = styles2.length > 0 ? current[styleName](...styles2) : current[styleName];
      }
      return current;
    }
    __name(buildStyle, "buildStyle");
    module2.exports = (chalk63, temporary) => {
      const styles = [];
      const chunks = [];
      let chunk = [];
      temporary.replace(TEMPLATE_REGEX, (m4, escapeCharacter, inverse, style, close2, character) => {
        if (escapeCharacter) {
          chunk.push(unescape2(escapeCharacter));
        } else if (style) {
          const string = chunk.join("");
          chunk = [];
          chunks.push(styles.length === 0 ? string : buildStyle(chalk63, styles)(string));
          styles.push({ inverse, styles: parseStyle(style) });
        } else if (close2) {
          if (styles.length === 0) {
            throw new Error("Found extraneous } in Chalk template literal");
          }
          chunks.push(buildStyle(chalk63, styles)(chunk.join("")));
          chunk = [];
          styles.pop();
        } else {
          chunk.push(character);
        }
      });
      chunks.push(chunk.join(""));
      if (styles.length > 0) {
        const errMessage = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
        throw new Error(errMessage);
      }
      return chunks.join("");
    };
  }
});

// ../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/index.js
var require_source = __commonJS({
  "../../node_modules/.pnpm/chalk@4.1.2/node_modules/chalk/source/index.js"(exports2, module2) {
    "use strict";
    var ansiStyles = require_ansi_styles();
    var { stdout: stdoutColor, stderr: stderrColor } = require_supports_color();
    var {
      stringReplaceAll,
      stringEncaseCRLFWithFirstIndex
    } = require_util();
    var { isArray } = Array;
    var levelMapping = [
      "ansi",
      "ansi",
      "ansi256",
      "ansi16m"
    ];
    var styles = /* @__PURE__ */ Object.create(null);
    var applyOptions = /* @__PURE__ */ __name((object, options2 = {}) => {
      if (options2.level && !(Number.isInteger(options2.level) && options2.level >= 0 && options2.level <= 3)) {
        throw new Error("The `level` option should be an integer from 0 to 3");
      }
      const colorLevel = stdoutColor ? stdoutColor.level : 0;
      object.level = options2.level === void 0 ? colorLevel : options2.level;
    }, "applyOptions");
    var ChalkClass = class {
      constructor(options2) {
        return chalkFactory(options2);
      }
    };
    __name(ChalkClass, "ChalkClass");
    var chalkFactory = /* @__PURE__ */ __name((options2) => {
      const chalk64 = {};
      applyOptions(chalk64, options2);
      chalk64.template = (...arguments_) => chalkTag(chalk64.template, ...arguments_);
      Object.setPrototypeOf(chalk64, Chalk.prototype);
      Object.setPrototypeOf(chalk64.template, chalk64);
      chalk64.template.constructor = () => {
        throw new Error("`chalk.constructor()` is deprecated. Use `new chalk.Instance()` instead.");
      };
      chalk64.template.Instance = ChalkClass;
      return chalk64.template;
    }, "chalkFactory");
    function Chalk(options2) {
      return chalkFactory(options2);
    }
    __name(Chalk, "Chalk");
    for (const [styleName, style] of Object.entries(ansiStyles)) {
      styles[styleName] = {
        get() {
          const builder = createBuilder(this, createStyler(style.open, style.close, this._styler), this._isEmpty);
          Object.defineProperty(this, styleName, { value: builder });
          return builder;
        }
      };
    }
    styles.visible = {
      get() {
        const builder = createBuilder(this, this._styler, true);
        Object.defineProperty(this, "visible", { value: builder });
        return builder;
      }
    };
    var usedModels = ["rgb", "hex", "keyword", "hsl", "hsv", "hwb", "ansi", "ansi256"];
    for (const model of usedModels) {
      styles[model] = {
        get() {
          const { level } = this;
          return function(...arguments_) {
            const styler = createStyler(ansiStyles.color[levelMapping[level]][model](...arguments_), ansiStyles.color.close, this._styler);
            return createBuilder(this, styler, this._isEmpty);
          };
        }
      };
    }
    for (const model of usedModels) {
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get() {
          const { level } = this;
          return function(...arguments_) {
            const styler = createStyler(ansiStyles.bgColor[levelMapping[level]][model](...arguments_), ansiStyles.bgColor.close, this._styler);
            return createBuilder(this, styler, this._isEmpty);
          };
        }
      };
    }
    var proto = Object.defineProperties(() => {
    }, {
      ...styles,
      level: {
        enumerable: true,
        get() {
          return this._generator.level;
        },
        set(level) {
          this._generator.level = level;
        }
      }
    });
    var createStyler = /* @__PURE__ */ __name((open4, close2, parent2) => {
      let openAll;
      let closeAll;
      if (parent2 === void 0) {
        openAll = open4;
        closeAll = close2;
      } else {
        openAll = parent2.openAll + open4;
        closeAll = close2 + parent2.closeAll;
      }
      return {
        open: open4,
        close: close2,
        openAll,
        closeAll,
        parent: parent2
      };
    }, "createStyler");
    var createBuilder = /* @__PURE__ */ __name((self2, _styler, _isEmpty) => {
      const builder = /* @__PURE__ */ __name((...arguments_) => {
        if (isArray(arguments_[0]) && isArray(arguments_[0].raw)) {
          return applyStyle(builder, chalkTag(builder, ...arguments_));
        }
        return applyStyle(builder, arguments_.length === 1 ? "" + arguments_[0] : arguments_.join(" "));
      }, "builder");
      Object.setPrototypeOf(builder, proto);
      builder._generator = self2;
      builder._styler = _styler;
      builder._isEmpty = _isEmpty;
      return builder;
    }, "createBuilder");
    var applyStyle = /* @__PURE__ */ __name((self2, string) => {
      if (self2.level <= 0 || !string) {
        return self2._isEmpty ? "" : string;
      }
      let styler = self2._styler;
      if (styler === void 0) {
        return string;
      }
      const { openAll, closeAll } = styler;
      if (string.indexOf("\x1B") !== -1) {
        while (styler !== void 0) {
          string = stringReplaceAll(string, styler.close, styler.open);
          styler = styler.parent;
        }
      }
      const lfIndex = string.indexOf("\n");
      if (lfIndex !== -1) {
        string = stringEncaseCRLFWithFirstIndex(string, closeAll, openAll, lfIndex);
      }
      return openAll + string + closeAll;
    }, "applyStyle");
    var template;
    var chalkTag = /* @__PURE__ */ __name((chalk64, ...strings) => {
      const [firstString] = strings;
      if (!isArray(firstString) || !isArray(firstString.raw)) {
        return strings.join(" ");
      }
      const arguments_ = strings.slice(1);
      const parts = [firstString.raw[0]];
      for (let i3 = 1; i3 < firstString.length; i3++) {
        parts.push(
          String(arguments_[i3 - 1]).replace(/[{}\\]/g, "\\$&"),
          String(firstString.raw[i3])
        );
      }
      if (template === void 0) {
        template = require_templates();
      }
      return template(chalk64, parts.join(""));
    }, "chalkTag");
    Object.defineProperties(Chalk.prototype, styles);
    var chalk63 = Chalk();
    chalk63.supportsColor = stdoutColor;
    chalk63.stderr = Chalk({ level: stderrColor ? stderrColor.level : 0 });
    chalk63.stderr.supportsColor = stderrColor;
    module2.exports = chalk63;
  }
});

// ../../node_modules/.pnpm/yocto-queue@0.1.0/node_modules/yocto-queue/index.js
var require_yocto_queue = __commonJS({
  "../../node_modules/.pnpm/yocto-queue@0.1.0/node_modules/yocto-queue/index.js"(exports2, module2) {
    var Node = class {
      constructor(value) {
        this.value = value;
        this.next = void 0;
      }
    };
    __name(Node, "Node");
    var Queue = class {
      constructor() {
        this.clear();
      }
      enqueue(value) {
        const node = new Node(value);
        if (this._head) {
          this._tail.next = node;
          this._tail = node;
        } else {
          this._head = node;
          this._tail = node;
        }
        this._size++;
      }
      dequeue() {
        const current = this._head;
        if (!current) {
          return;
        }
        this._head = this._head.next;
        this._size--;
        return current.value;
      }
      clear() {
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
      }
      get size() {
        return this._size;
      }
      *[Symbol.iterator]() {
        let current = this._head;
        while (current) {
          yield current.value;
          current = current.next;
        }
      }
    };
    __name(Queue, "Queue");
    module2.exports = Queue;
  }
});

// ../../node_modules/.pnpm/p-limit@3.1.0/node_modules/p-limit/index.js
var require_p_limit = __commonJS({
  "../../node_modules/.pnpm/p-limit@3.1.0/node_modules/p-limit/index.js"(exports2, module2) {
    "use strict";
    var Queue = require_yocto_queue();
    var pLimit = /* @__PURE__ */ __name((concurrency) => {
      if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
        throw new TypeError("Expected `concurrency` to be a number from 1 and up");
      }
      const queue2 = new Queue();
      let activeCount = 0;
      const next = /* @__PURE__ */ __name(() => {
        activeCount--;
        if (queue2.size > 0) {
          queue2.dequeue()();
        }
      }, "next");
      const run = /* @__PURE__ */ __name(async (fn2, resolve2, ...args3) => {
        activeCount++;
        const result = (async () => fn2(...args3))();
        resolve2(result);
        try {
          await result;
        } catch {
        }
        next();
      }, "run");
      const enqueue = /* @__PURE__ */ __name((fn2, resolve2, ...args3) => {
        queue2.enqueue(run.bind(null, fn2, resolve2, ...args3));
        (async () => {
          await Promise.resolve();
          if (activeCount < concurrency && queue2.size > 0) {
            queue2.dequeue()();
          }
        })();
      }, "enqueue");
      const generator = /* @__PURE__ */ __name((fn2, ...args3) => new Promise((resolve2) => {
        enqueue(fn2, resolve2, ...args3);
      }), "generator");
      Object.defineProperties(generator, {
        activeCount: {
          get: () => activeCount
        },
        pendingCount: {
          get: () => queue2.size
        },
        clearQueue: {
          value: () => {
            queue2.clear();
          }
        }
      });
      return generator;
    }, "pLimit");
    module2.exports = pLimit;
  }
});

// ../../node_modules/.pnpm/p-locate@5.0.0/node_modules/p-locate/index.js
var require_p_locate = __commonJS({
  "../../node_modules/.pnpm/p-locate@5.0.0/node_modules/p-locate/index.js"(exports2, module2) {
    "use strict";
    var pLimit = require_p_limit();
    var EndError = class extends Error {
      constructor(value) {
        super();
        this.value = value;
      }
    };
    __name(EndError, "EndError");
    var testElement = /* @__PURE__ */ __name(async (element, tester) => tester(await element), "testElement");
    var finder = /* @__PURE__ */ __name(async (element) => {
      const values = await Promise.all(element);
      if (values[1] === true) {
        throw new EndError(values[0]);
      }
      return false;
    }, "finder");
    var pLocate = /* @__PURE__ */ __name(async (iterable, tester, options2) => {
      options2 = {
        concurrency: Infinity,
        preserveOrder: true,
        ...options2
      };
      const limit = pLimit(options2.concurrency);
      const items = [...iterable].map((element) => [element, limit(testElement, element, tester)]);
      const checkLimit = pLimit(options2.preserveOrder ? 1 : Infinity);
      try {
        await Promise.all(items.map((element) => checkLimit(finder, element)));
      } catch (error2) {
        if (error2 instanceof EndError) {
          return error2.value;
        }
        throw error2;
      }
    }, "pLocate");
    module2.exports = pLocate;
  }
});

// ../../node_modules/.pnpm/locate-path@6.0.0/node_modules/locate-path/index.js
var require_locate_path = __commonJS({
  "../../node_modules/.pnpm/locate-path@6.0.0/node_modules/locate-path/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var fs37 = require("fs");
    var { promisify: promisify12 } = require("util");
    var pLocate = require_p_locate();
    var fsStat = promisify12(fs37.stat);
    var fsLStat = promisify12(fs37.lstat);
    var typeMappings = {
      directory: "isDirectory",
      file: "isFile"
    };
    function checkType({ type }) {
      if (type in typeMappings) {
        return;
      }
      throw new Error(`Invalid type specified: ${type}`);
    }
    __name(checkType, "checkType");
    var matchType = /* @__PURE__ */ __name((type, stat2) => type === void 0 || stat2[typeMappings[type]](), "matchType");
    module2.exports = async (paths2, options2) => {
      options2 = {
        cwd: process.cwd(),
        type: "file",
        allowSymlinks: true,
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fsStat : fsLStat;
      return pLocate(paths2, async (path_) => {
        try {
          const stat2 = await statFn(path32.resolve(options2.cwd, path_));
          return matchType(options2.type, stat2);
        } catch {
          return false;
        }
      }, options2);
    };
    module2.exports.sync = (paths2, options2) => {
      options2 = {
        cwd: process.cwd(),
        allowSymlinks: true,
        type: "file",
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fs37.statSync : fs37.lstatSync;
      for (const path_ of paths2) {
        try {
          const stat2 = statFn(path32.resolve(options2.cwd, path_));
          if (matchType(options2.type, stat2)) {
            return path_;
          }
        } catch {
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/path-exists@4.0.0/node_modules/path-exists/index.js
var require_path_exists = __commonJS({
  "../../node_modules/.pnpm/path-exists@4.0.0/node_modules/path-exists/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var { promisify: promisify12 } = require("util");
    var pAccess = promisify12(fs37.access);
    module2.exports = async (path32) => {
      try {
        await pAccess(path32);
        return true;
      } catch (_2) {
        return false;
      }
    };
    module2.exports.sync = (path32) => {
      try {
        fs37.accessSync(path32);
        return true;
      } catch (_2) {
        return false;
      }
    };
  }
});

// ../../node_modules/.pnpm/find-up@5.0.0/node_modules/find-up/index.js
var require_find_up = __commonJS({
  "../../node_modules/.pnpm/find-up@5.0.0/node_modules/find-up/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var locatePath = require_locate_path();
    var pathExists = require_path_exists();
    var stop = Symbol("findUp.stop");
    module2.exports = async (name, options2 = {}) => {
      let directory = path32.resolve(options2.cwd || "");
      const { root } = path32.parse(directory);
      const paths2 = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name(async (locateOptions) => {
        if (typeof name !== "function") {
          return locatePath(paths2, locateOptions);
        }
        const foundPath = await name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = await runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path32.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path32.dirname(directory);
      }
    };
    module2.exports.sync = (name, options2 = {}) => {
      let directory = path32.resolve(options2.cwd || "");
      const { root } = path32.parse(directory);
      const paths2 = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name((locateOptions) => {
        if (typeof name !== "function") {
          return locatePath.sync(paths2, locateOptions);
        }
        const foundPath = name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath.sync([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path32.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path32.dirname(directory);
      }
    };
    module2.exports.exists = pathExists;
    module2.exports.sync.exists = pathExists.sync;
    module2.exports.stop = stop;
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/windows.js
var require_windows = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/windows.js"(exports2, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs37 = require("fs");
    function checkPathExt(path32, options2) {
      var pathext = options2.pathExt !== void 0 ? options2.pathExt : process.env.PATHEXT;
      if (!pathext) {
        return true;
      }
      pathext = pathext.split(";");
      if (pathext.indexOf("") !== -1) {
        return true;
      }
      for (var i3 = 0; i3 < pathext.length; i3++) {
        var p3 = pathext[i3].toLowerCase();
        if (p3 && path32.substr(-p3.length).toLowerCase() === p3) {
          return true;
        }
      }
      return false;
    }
    __name(checkPathExt, "checkPathExt");
    function checkStat(stat2, path32, options2) {
      if (!stat2.isSymbolicLink() && !stat2.isFile()) {
        return false;
      }
      return checkPathExt(path32, options2);
    }
    __name(checkStat, "checkStat");
    function isexe(path32, options2, cb) {
      fs37.stat(path32, function(er, stat2) {
        cb(er, er ? false : checkStat(stat2, path32, options2));
      });
    }
    __name(isexe, "isexe");
    function sync(path32, options2) {
      return checkStat(fs37.statSync(path32), path32, options2);
    }
    __name(sync, "sync");
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/mode.js
var require_mode = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/mode.js"(exports2, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs37 = require("fs");
    function isexe(path32, options2, cb) {
      fs37.stat(path32, function(er, stat2) {
        cb(er, er ? false : checkStat(stat2, options2));
      });
    }
    __name(isexe, "isexe");
    function sync(path32, options2) {
      return checkStat(fs37.statSync(path32), options2);
    }
    __name(sync, "sync");
    function checkStat(stat2, options2) {
      return stat2.isFile() && checkMode(stat2, options2);
    }
    __name(checkStat, "checkStat");
    function checkMode(stat2, options2) {
      var mod = stat2.mode;
      var uid = stat2.uid;
      var gid = stat2.gid;
      var myUid = options2.uid !== void 0 ? options2.uid : process.getuid && process.getuid();
      var myGid = options2.gid !== void 0 ? options2.gid : process.getgid && process.getgid();
      var u3 = parseInt("100", 8);
      var g3 = parseInt("010", 8);
      var o3 = parseInt("001", 8);
      var ug = u3 | g3;
      var ret = mod & o3 || mod & g3 && gid === myGid || mod & u3 && uid === myUid || mod & ug && myUid === 0;
      return ret;
    }
    __name(checkMode, "checkMode");
  }
});

// ../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/index.js
var require_isexe = __commonJS({
  "../../node_modules/.pnpm/isexe@2.0.0/node_modules/isexe/index.js"(exports2, module2) {
    var fs37 = require("fs");
    var core;
    if (process.platform === "win32" || global.TESTING_WINDOWS) {
      core = require_windows();
    } else {
      core = require_mode();
    }
    module2.exports = isexe;
    isexe.sync = sync;
    function isexe(path32, options2, cb) {
      if (typeof options2 === "function") {
        cb = options2;
        options2 = {};
      }
      if (!cb) {
        if (typeof Promise !== "function") {
          throw new TypeError("callback not provided");
        }
        return new Promise(function(resolve2, reject2) {
          isexe(path32, options2 || {}, function(er, is) {
            if (er) {
              reject2(er);
            } else {
              resolve2(is);
            }
          });
        });
      }
      core(path32, options2 || {}, function(er, is) {
        if (er) {
          if (er.code === "EACCES" || options2 && options2.ignoreErrors) {
            er = null;
            is = false;
          }
        }
        cb(er, is);
      });
    }
    __name(isexe, "isexe");
    function sync(path32, options2) {
      try {
        return core.sync(path32, options2 || {});
      } catch (er) {
        if (options2 && options2.ignoreErrors || er.code === "EACCES") {
          return false;
        } else {
          throw er;
        }
      }
    }
    __name(sync, "sync");
  }
});

// ../../node_modules/.pnpm/which@2.0.2/node_modules/which/which.js
var require_which = __commonJS({
  "../../node_modules/.pnpm/which@2.0.2/node_modules/which/which.js"(exports2, module2) {
    var isWindows2 = process.platform === "win32" || process.env.OSTYPE === "cygwin" || process.env.OSTYPE === "msys";
    var path32 = require("path");
    var COLON = isWindows2 ? ";" : ":";
    var isexe = require_isexe();
    var getNotFoundError = /* @__PURE__ */ __name((cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" }), "getNotFoundError");
    var getPathInfo = /* @__PURE__ */ __name((cmd, opt) => {
      const colon = opt.colon || COLON;
      const pathEnv = cmd.match(/\//) || isWindows2 && cmd.match(/\\/) ? [""] : [
        ...isWindows2 ? [process.cwd()] : [],
        ...(opt.path || process.env.PATH || "").split(colon)
      ];
      const pathExtExe = isWindows2 ? opt.pathExt || process.env.PATHEXT || ".EXE;.CMD;.BAT;.COM" : "";
      const pathExt = isWindows2 ? pathExtExe.split(colon) : [""];
      if (isWindows2) {
        if (cmd.indexOf(".") !== -1 && pathExt[0] !== "")
          pathExt.unshift("");
      }
      return {
        pathEnv,
        pathExt,
        pathExtExe
      };
    }, "getPathInfo");
    var which = /* @__PURE__ */ __name((cmd, opt, cb) => {
      if (typeof opt === "function") {
        cb = opt;
        opt = {};
      }
      if (!opt)
        opt = {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      const step = /* @__PURE__ */ __name((i3) => new Promise((resolve2, reject2) => {
        if (i3 === pathEnv.length)
          return opt.all && found.length ? resolve2(found) : reject2(getNotFoundError(cmd));
        const ppRaw = pathEnv[i3];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path32.join(pathPart, cmd);
        const p3 = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        resolve2(subStep(p3, i3, 0));
      }), "step");
      const subStep = /* @__PURE__ */ __name((p3, i3, ii) => new Promise((resolve2, reject2) => {
        if (ii === pathExt.length)
          return resolve2(step(i3 + 1));
        const ext = pathExt[ii];
        isexe(p3 + ext, { pathExt: pathExtExe }, (er, is) => {
          if (!er && is) {
            if (opt.all)
              found.push(p3 + ext);
            else
              return resolve2(p3 + ext);
          }
          return resolve2(subStep(p3, i3, ii + 1));
        });
      }), "subStep");
      return cb ? step(0).then((res) => cb(null, res), cb) : step(0);
    }, "which");
    var whichSync = /* @__PURE__ */ __name((cmd, opt) => {
      opt = opt || {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (let i3 = 0; i3 < pathEnv.length; i3++) {
        const ppRaw = pathEnv[i3];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path32.join(pathPart, cmd);
        const p3 = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        for (let j = 0; j < pathExt.length; j++) {
          const cur = p3 + pathExt[j];
          try {
            const is = isexe.sync(cur, { pathExt: pathExtExe });
            if (is) {
              if (opt.all)
                found.push(cur);
              else
                return cur;
            }
          } catch (ex) {
          }
        }
      }
      if (opt.all && found.length)
        return found;
      if (opt.nothrow)
        return null;
      throw getNotFoundError(cmd);
    }, "whichSync");
    module2.exports = which;
    which.sync = whichSync;
  }
});

// ../../node_modules/.pnpm/path-key@3.1.1/node_modules/path-key/index.js
var require_path_key = __commonJS({
  "../../node_modules/.pnpm/path-key@3.1.1/node_modules/path-key/index.js"(exports2, module2) {
    "use strict";
    var pathKey = /* @__PURE__ */ __name((options2 = {}) => {
      const environment = options2.env || process.env;
      const platform2 = options2.platform || process.platform;
      if (platform2 !== "win32") {
        return "PATH";
      }
      return Object.keys(environment).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
    }, "pathKey");
    module2.exports = pathKey;
    module2.exports.default = pathKey;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/resolveCommand.js
var require_resolveCommand = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/resolveCommand.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var which = require_which();
    var getPathKey = require_path_key();
    function resolveCommandAttempt(parsed, withoutPathExt) {
      const env2 = parsed.options.env || process.env;
      const cwd = process.cwd();
      const hasCustomCwd = parsed.options.cwd != null;
      const shouldSwitchCwd = hasCustomCwd && process.chdir !== void 0 && !process.chdir.disabled;
      if (shouldSwitchCwd) {
        try {
          process.chdir(parsed.options.cwd);
        } catch (err) {
        }
      }
      let resolved;
      try {
        resolved = which.sync(parsed.command, {
          path: env2[getPathKey({ env: env2 })],
          pathExt: withoutPathExt ? path32.delimiter : void 0
        });
      } catch (e3) {
      } finally {
        if (shouldSwitchCwd) {
          process.chdir(cwd);
        }
      }
      if (resolved) {
        resolved = path32.resolve(hasCustomCwd ? parsed.options.cwd : "", resolved);
      }
      return resolved;
    }
    __name(resolveCommandAttempt, "resolveCommandAttempt");
    function resolveCommand(parsed) {
      return resolveCommandAttempt(parsed) || resolveCommandAttempt(parsed, true);
    }
    __name(resolveCommand, "resolveCommand");
    module2.exports = resolveCommand;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/escape.js
var require_escape = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/escape.js"(exports2, module2) {
    "use strict";
    var metaCharsRegExp = /([()\][%!^"`<>&|;, *?])/g;
    function escapeCommand(arg2) {
      arg2 = arg2.replace(metaCharsRegExp, "^$1");
      return arg2;
    }
    __name(escapeCommand, "escapeCommand");
    function escapeArgument(arg2, doubleEscapeMetaChars) {
      arg2 = `${arg2}`;
      arg2 = arg2.replace(/(\\*)"/g, '$1$1\\"');
      arg2 = arg2.replace(/(\\*)$/, "$1$1");
      arg2 = `"${arg2}"`;
      arg2 = arg2.replace(metaCharsRegExp, "^$1");
      if (doubleEscapeMetaChars) {
        arg2 = arg2.replace(metaCharsRegExp, "^$1");
      }
      return arg2;
    }
    __name(escapeArgument, "escapeArgument");
    module2.exports.command = escapeCommand;
    module2.exports.argument = escapeArgument;
  }
});

// ../../node_modules/.pnpm/shebang-regex@3.0.0/node_modules/shebang-regex/index.js
var require_shebang_regex = __commonJS({
  "../../node_modules/.pnpm/shebang-regex@3.0.0/node_modules/shebang-regex/index.js"(exports2, module2) {
    "use strict";
    module2.exports = /^#!(.*)/;
  }
});

// ../../node_modules/.pnpm/shebang-command@2.0.0/node_modules/shebang-command/index.js
var require_shebang_command = __commonJS({
  "../../node_modules/.pnpm/shebang-command@2.0.0/node_modules/shebang-command/index.js"(exports2, module2) {
    "use strict";
    var shebangRegex = require_shebang_regex();
    module2.exports = (string = "") => {
      const match4 = string.match(shebangRegex);
      if (!match4) {
        return null;
      }
      const [path32, argument] = match4[0].replace(/#! ?/, "").split(" ");
      const binary = path32.split("/").pop();
      if (binary === "env") {
        return argument;
      }
      return argument ? `${binary} ${argument}` : binary;
    };
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/readShebang.js
var require_readShebang = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/util/readShebang.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var shebangCommand = require_shebang_command();
    function readShebang(command) {
      const size = 150;
      const buffer = Buffer.alloc(size);
      let fd;
      try {
        fd = fs37.openSync(command, "r");
        fs37.readSync(fd, buffer, 0, size, 0);
        fs37.closeSync(fd);
      } catch (e3) {
      }
      return shebangCommand(buffer.toString());
    }
    __name(readShebang, "readShebang");
    module2.exports = readShebang;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/parse.js
var require_parse = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/parse.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var resolveCommand = require_resolveCommand();
    var escape2 = require_escape();
    var readShebang = require_readShebang();
    var isWin = process.platform === "win32";
    var isExecutableRegExp = /\.(?:com|exe)$/i;
    var isCmdShimRegExp = /node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;
    function detectShebang(parsed) {
      parsed.file = resolveCommand(parsed);
      const shebang = parsed.file && readShebang(parsed.file);
      if (shebang) {
        parsed.args.unshift(parsed.file);
        parsed.command = shebang;
        return resolveCommand(parsed);
      }
      return parsed.file;
    }
    __name(detectShebang, "detectShebang");
    function parseNonShell(parsed) {
      if (!isWin) {
        return parsed;
      }
      const commandFile = detectShebang(parsed);
      const needsShell = !isExecutableRegExp.test(commandFile);
      if (parsed.options.forceShell || needsShell) {
        const needsDoubleEscapeMetaChars = isCmdShimRegExp.test(commandFile);
        parsed.command = path32.normalize(parsed.command);
        parsed.command = escape2.command(parsed.command);
        parsed.args = parsed.args.map((arg2) => escape2.argument(arg2, needsDoubleEscapeMetaChars));
        const shellCommand = [parsed.command].concat(parsed.args).join(" ");
        parsed.args = ["/d", "/s", "/c", `"${shellCommand}"`];
        parsed.command = process.env.comspec || "cmd.exe";
        parsed.options.windowsVerbatimArguments = true;
      }
      return parsed;
    }
    __name(parseNonShell, "parseNonShell");
    function parse2(command, args3, options2) {
      if (args3 && !Array.isArray(args3)) {
        options2 = args3;
        args3 = null;
      }
      args3 = args3 ? args3.slice(0) : [];
      options2 = Object.assign({}, options2);
      const parsed = {
        command,
        args: args3,
        options: options2,
        file: void 0,
        original: {
          command,
          args: args3
        }
      };
      return options2.shell ? parsed : parseNonShell(parsed);
    }
    __name(parse2, "parse");
    module2.exports = parse2;
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/enoent.js
var require_enoent = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/lib/enoent.js"(exports2, module2) {
    "use strict";
    var isWin = process.platform === "win32";
    function notFoundError(original, syscall) {
      return Object.assign(new Error(`${syscall} ${original.command} ENOENT`), {
        code: "ENOENT",
        errno: "ENOENT",
        syscall: `${syscall} ${original.command}`,
        path: original.command,
        spawnargs: original.args
      });
    }
    __name(notFoundError, "notFoundError");
    function hookChildProcess(cp2, parsed) {
      if (!isWin) {
        return;
      }
      const originalEmit = cp2.emit;
      cp2.emit = function(name, arg1) {
        if (name === "exit") {
          const err = verifyENOENT(arg1, parsed, "spawn");
          if (err) {
            return originalEmit.call(cp2, "error", err);
          }
        }
        return originalEmit.apply(cp2, arguments);
      };
    }
    __name(hookChildProcess, "hookChildProcess");
    function verifyENOENT(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawn");
      }
      return null;
    }
    __name(verifyENOENT, "verifyENOENT");
    function verifyENOENTSync(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawnSync");
      }
      return null;
    }
    __name(verifyENOENTSync, "verifyENOENTSync");
    module2.exports = {
      hookChildProcess,
      verifyENOENT,
      verifyENOENTSync,
      notFoundError
    };
  }
});

// ../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/index.js
var require_cross_spawn = __commonJS({
  "../../node_modules/.pnpm/cross-spawn@7.0.3/node_modules/cross-spawn/index.js"(exports2, module2) {
    "use strict";
    var cp2 = require("child_process");
    var parse2 = require_parse();
    var enoent = require_enoent();
    function spawn4(command, args3, options2) {
      const parsed = parse2(command, args3, options2);
      const spawned = cp2.spawn(parsed.command, parsed.args, parsed.options);
      enoent.hookChildProcess(spawned, parsed);
      return spawned;
    }
    __name(spawn4, "spawn");
    function spawnSync(command, args3, options2) {
      const parsed = parse2(command, args3, options2);
      const result = cp2.spawnSync(parsed.command, parsed.args, parsed.options);
      result.error = result.error || enoent.verifyENOENTSync(result.status, parsed);
      return result;
    }
    __name(spawnSync, "spawnSync");
    module2.exports = spawn4;
    module2.exports.spawn = spawn4;
    module2.exports.sync = spawnSync;
    module2.exports._parse = parse2;
    module2.exports._enoent = enoent;
  }
});

// ../../node_modules/.pnpm/strip-final-newline@2.0.0/node_modules/strip-final-newline/index.js
var require_strip_final_newline = __commonJS({
  "../../node_modules/.pnpm/strip-final-newline@2.0.0/node_modules/strip-final-newline/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (input) => {
      const LF = typeof input === "string" ? "\n" : "\n".charCodeAt();
      const CR = typeof input === "string" ? "\r" : "\r".charCodeAt();
      if (input[input.length - 1] === LF) {
        input = input.slice(0, input.length - 1);
      }
      if (input[input.length - 1] === CR) {
        input = input.slice(0, input.length - 1);
      }
      return input;
    };
  }
});

// ../../node_modules/.pnpm/npm-run-path@4.0.1/node_modules/npm-run-path/index.js
var require_npm_run_path = __commonJS({
  "../../node_modules/.pnpm/npm-run-path@4.0.1/node_modules/npm-run-path/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var pathKey = require_path_key();
    var npmRunPath = /* @__PURE__ */ __name((options2) => {
      options2 = {
        cwd: process.cwd(),
        path: process.env[pathKey()],
        execPath: process.execPath,
        ...options2
      };
      let previous;
      let cwdPath = path32.resolve(options2.cwd);
      const result = [];
      while (previous !== cwdPath) {
        result.push(path32.join(cwdPath, "node_modules/.bin"));
        previous = cwdPath;
        cwdPath = path32.resolve(cwdPath, "..");
      }
      const execPathDir = path32.resolve(options2.cwd, options2.execPath, "..");
      result.push(execPathDir);
      return result.concat(options2.path).join(path32.delimiter);
    }, "npmRunPath");
    module2.exports = npmRunPath;
    module2.exports.default = npmRunPath;
    module2.exports.env = (options2) => {
      options2 = {
        env: process.env,
        ...options2
      };
      const env2 = { ...options2.env };
      const path33 = pathKey({ env: env2 });
      options2.path = env2[path33];
      env2[path33] = module2.exports(options2);
      return env2;
    };
  }
});

// ../../node_modules/.pnpm/mimic-fn@2.1.0/node_modules/mimic-fn/index.js
var require_mimic_fn = __commonJS({
  "../../node_modules/.pnpm/mimic-fn@2.1.0/node_modules/mimic-fn/index.js"(exports2, module2) {
    "use strict";
    var mimicFn = /* @__PURE__ */ __name((to, from) => {
      for (const prop of Reflect.ownKeys(from)) {
        Object.defineProperty(to, prop, Object.getOwnPropertyDescriptor(from, prop));
      }
      return to;
    }, "mimicFn");
    module2.exports = mimicFn;
    module2.exports.default = mimicFn;
  }
});

// ../../node_modules/.pnpm/onetime@5.1.2/node_modules/onetime/index.js
var require_onetime = __commonJS({
  "../../node_modules/.pnpm/onetime@5.1.2/node_modules/onetime/index.js"(exports2, module2) {
    "use strict";
    var mimicFn = require_mimic_fn();
    var calledFunctions = /* @__PURE__ */ new WeakMap();
    var onetime = /* @__PURE__ */ __name((function_, options2 = {}) => {
      if (typeof function_ !== "function") {
        throw new TypeError("Expected a function");
      }
      let returnValue;
      let callCount = 0;
      const functionName = function_.displayName || function_.name || "<anonymous>";
      const onetime2 = /* @__PURE__ */ __name(function(...arguments_) {
        calledFunctions.set(onetime2, ++callCount);
        if (callCount === 1) {
          returnValue = function_.apply(this, arguments_);
          function_ = null;
        } else if (options2.throw === true) {
          throw new Error(`Function \`${functionName}\` can only be called once`);
        }
        return returnValue;
      }, "onetime");
      mimicFn(onetime2, function_);
      calledFunctions.set(onetime2, callCount);
      return onetime2;
    }, "onetime");
    module2.exports = onetime;
    module2.exports.default = onetime;
    module2.exports.callCount = (function_) => {
      if (!calledFunctions.has(function_)) {
        throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`);
      }
      return calledFunctions.get(function_);
    };
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/core.js
var require_core = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/core.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SIGNALS = void 0;
    var SIGNALS = [
      {
        name: "SIGHUP",
        number: 1,
        action: "terminate",
        description: "Terminal closed",
        standard: "posix"
      },
      {
        name: "SIGINT",
        number: 2,
        action: "terminate",
        description: "User interruption with CTRL-C",
        standard: "ansi"
      },
      {
        name: "SIGQUIT",
        number: 3,
        action: "core",
        description: "User interruption with CTRL-\\",
        standard: "posix"
      },
      {
        name: "SIGILL",
        number: 4,
        action: "core",
        description: "Invalid machine instruction",
        standard: "ansi"
      },
      {
        name: "SIGTRAP",
        number: 5,
        action: "core",
        description: "Debugger breakpoint",
        standard: "posix"
      },
      {
        name: "SIGABRT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "ansi"
      },
      {
        name: "SIGIOT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "bsd"
      },
      {
        name: "SIGBUS",
        number: 7,
        action: "core",
        description: "Bus error due to misaligned, non-existing address or paging error",
        standard: "bsd"
      },
      {
        name: "SIGEMT",
        number: 7,
        action: "terminate",
        description: "Command should be emulated but is not implemented",
        standard: "other"
      },
      {
        name: "SIGFPE",
        number: 8,
        action: "core",
        description: "Floating point arithmetic error",
        standard: "ansi"
      },
      {
        name: "SIGKILL",
        number: 9,
        action: "terminate",
        description: "Forced termination",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGUSR1",
        number: 10,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGSEGV",
        number: 11,
        action: "core",
        description: "Segmentation fault",
        standard: "ansi"
      },
      {
        name: "SIGUSR2",
        number: 12,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGPIPE",
        number: 13,
        action: "terminate",
        description: "Broken pipe or socket",
        standard: "posix"
      },
      {
        name: "SIGALRM",
        number: 14,
        action: "terminate",
        description: "Timeout or timer",
        standard: "posix"
      },
      {
        name: "SIGTERM",
        number: 15,
        action: "terminate",
        description: "Termination",
        standard: "ansi"
      },
      {
        name: "SIGSTKFLT",
        number: 16,
        action: "terminate",
        description: "Stack is empty or overflowed",
        standard: "other"
      },
      {
        name: "SIGCHLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "posix"
      },
      {
        name: "SIGCLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "other"
      },
      {
        name: "SIGCONT",
        number: 18,
        action: "unpause",
        description: "Unpaused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGSTOP",
        number: 19,
        action: "pause",
        description: "Paused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGTSTP",
        number: 20,
        action: "pause",
        description: 'Paused using CTRL-Z or "suspend"',
        standard: "posix"
      },
      {
        name: "SIGTTIN",
        number: 21,
        action: "pause",
        description: "Background process cannot read terminal input",
        standard: "posix"
      },
      {
        name: "SIGBREAK",
        number: 21,
        action: "terminate",
        description: "User interruption with CTRL-BREAK",
        standard: "other"
      },
      {
        name: "SIGTTOU",
        number: 22,
        action: "pause",
        description: "Background process cannot write to terminal output",
        standard: "posix"
      },
      {
        name: "SIGURG",
        number: 23,
        action: "ignore",
        description: "Socket received out-of-band data",
        standard: "bsd"
      },
      {
        name: "SIGXCPU",
        number: 24,
        action: "core",
        description: "Process timed out",
        standard: "bsd"
      },
      {
        name: "SIGXFSZ",
        number: 25,
        action: "core",
        description: "File too big",
        standard: "bsd"
      },
      {
        name: "SIGVTALRM",
        number: 26,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGPROF",
        number: 27,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGWINCH",
        number: 28,
        action: "ignore",
        description: "Terminal window size changed",
        standard: "bsd"
      },
      {
        name: "SIGIO",
        number: 29,
        action: "terminate",
        description: "I/O is available",
        standard: "other"
      },
      {
        name: "SIGPOLL",
        number: 29,
        action: "terminate",
        description: "Watched event",
        standard: "other"
      },
      {
        name: "SIGINFO",
        number: 29,
        action: "ignore",
        description: "Request for process information",
        standard: "other"
      },
      {
        name: "SIGPWR",
        number: 30,
        action: "terminate",
        description: "Device running out of power",
        standard: "systemv"
      },
      {
        name: "SIGSYS",
        number: 31,
        action: "core",
        description: "Invalid system call",
        standard: "other"
      },
      {
        name: "SIGUNUSED",
        number: 31,
        action: "terminate",
        description: "Invalid system call",
        standard: "other"
      }
    ];
    exports2.SIGNALS = SIGNALS;
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/realtime.js
var require_realtime = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/realtime.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SIGRTMAX = exports2.getRealtimeSignals = void 0;
    var getRealtimeSignals = /* @__PURE__ */ __name(function() {
      const length = SIGRTMAX - SIGRTMIN + 1;
      return Array.from({ length }, getRealtimeSignal);
    }, "getRealtimeSignals");
    exports2.getRealtimeSignals = getRealtimeSignals;
    var getRealtimeSignal = /* @__PURE__ */ __name(function(value, index2) {
      return {
        name: `SIGRT${index2 + 1}`,
        number: SIGRTMIN + index2,
        action: "terminate",
        description: "Application-specific signal (realtime)",
        standard: "posix"
      };
    }, "getRealtimeSignal");
    var SIGRTMIN = 34;
    var SIGRTMAX = 64;
    exports2.SIGRTMAX = SIGRTMAX;
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/signals.js
var require_signals = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/signals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getSignals = void 0;
    var _os = require("os");
    var _core = require_core();
    var _realtime = require_realtime();
    var getSignals = /* @__PURE__ */ __name(function() {
      const realtimeSignals = (0, _realtime.getRealtimeSignals)();
      const signals = [..._core.SIGNALS, ...realtimeSignals].map(normalizeSignal);
      return signals;
    }, "getSignals");
    exports2.getSignals = getSignals;
    var normalizeSignal = /* @__PURE__ */ __name(function({
      name,
      number: defaultNumber,
      description,
      action,
      forced = false,
      standard
    }) {
      const {
        signals: { [name]: constantSignal }
      } = _os.constants;
      const supported = constantSignal !== void 0;
      const number = supported ? constantSignal : defaultNumber;
      return { name, number, description, supported, action, forced, standard };
    }, "normalizeSignal");
  }
});

// ../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/main.js
var require_main = __commonJS({
  "../../node_modules/.pnpm/human-signals@2.1.0/node_modules/human-signals/build/src/main.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.signalsByNumber = exports2.signalsByName = void 0;
    var _os = require("os");
    var _signals = require_signals();
    var _realtime = require_realtime();
    var getSignalsByName = /* @__PURE__ */ __name(function() {
      const signals = (0, _signals.getSignals)();
      return signals.reduce(getSignalByName, {});
    }, "getSignalsByName");
    var getSignalByName = /* @__PURE__ */ __name(function(signalByNameMemo, { name, number, description, supported, action, forced, standard }) {
      return {
        ...signalByNameMemo,
        [name]: { name, number, description, supported, action, forced, standard }
      };
    }, "getSignalByName");
    var signalsByName = getSignalsByName();
    exports2.signalsByName = signalsByName;
    var getSignalsByNumber = /* @__PURE__ */ __name(function() {
      const signals = (0, _signals.getSignals)();
      const length = _realtime.SIGRTMAX + 1;
      const signalsA = Array.from({ length }, (value, number) => getSignalByNumber(number, signals));
      return Object.assign({}, ...signalsA);
    }, "getSignalsByNumber");
    var getSignalByNumber = /* @__PURE__ */ __name(function(number, signals) {
      const signal = findSignalByNumber(number, signals);
      if (signal === void 0) {
        return {};
      }
      const { name, description, supported, action, forced, standard } = signal;
      return {
        [number]: {
          name,
          number,
          description,
          supported,
          action,
          forced,
          standard
        }
      };
    }, "getSignalByNumber");
    var findSignalByNumber = /* @__PURE__ */ __name(function(number, signals) {
      const signal = signals.find(({ name }) => _os.constants.signals[name] === number);
      if (signal !== void 0) {
        return signal;
      }
      return signals.find((signalA) => signalA.number === number);
    }, "findSignalByNumber");
    var signalsByNumber = getSignalsByNumber();
    exports2.signalsByNumber = signalsByNumber;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/error.js
var require_error = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/error.js"(exports2, module2) {
    "use strict";
    var { signalsByName } = require_main();
    var getErrorPrefix = /* @__PURE__ */ __name(({ timedOut, timeout: timeout2, errorCode, signal, signalDescription, exitCode, isCanceled }) => {
      if (timedOut) {
        return `timed out after ${timeout2} milliseconds`;
      }
      if (isCanceled) {
        return "was canceled";
      }
      if (errorCode !== void 0) {
        return `failed with ${errorCode}`;
      }
      if (signal !== void 0) {
        return `was killed with ${signal} (${signalDescription})`;
      }
      if (exitCode !== void 0) {
        return `failed with exit code ${exitCode}`;
      }
      return "failed";
    }, "getErrorPrefix");
    var makeError = /* @__PURE__ */ __name(({
      stdout,
      stderr,
      all,
      error: error2,
      signal,
      exitCode,
      command,
      escapedCommand,
      timedOut,
      isCanceled,
      killed,
      parsed: { options: { timeout: timeout2 } }
    }) => {
      exitCode = exitCode === null ? void 0 : exitCode;
      signal = signal === null ? void 0 : signal;
      const signalDescription = signal === void 0 ? void 0 : signalsByName[signal].description;
      const errorCode = error2 && error2.code;
      const prefix = getErrorPrefix({ timedOut, timeout: timeout2, errorCode, signal, signalDescription, exitCode, isCanceled });
      const execaMessage = `Command ${prefix}: ${command}`;
      const isError3 = Object.prototype.toString.call(error2) === "[object Error]";
      const shortMessage = isError3 ? `${execaMessage}
${error2.message}` : execaMessage;
      const message2 = [shortMessage, stderr, stdout].filter(Boolean).join("\n");
      if (isError3) {
        error2.originalMessage = error2.message;
        error2.message = message2;
      } else {
        error2 = new Error(message2);
      }
      error2.shortMessage = shortMessage;
      error2.command = command;
      error2.escapedCommand = escapedCommand;
      error2.exitCode = exitCode;
      error2.signal = signal;
      error2.signalDescription = signalDescription;
      error2.stdout = stdout;
      error2.stderr = stderr;
      if (all !== void 0) {
        error2.all = all;
      }
      if ("bufferedData" in error2) {
        delete error2.bufferedData;
      }
      error2.failed = true;
      error2.timedOut = Boolean(timedOut);
      error2.isCanceled = isCanceled;
      error2.killed = killed && !timedOut;
      return error2;
    }, "makeError");
    module2.exports = makeError;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stdio.js
var require_stdio = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stdio.js"(exports2, module2) {
    "use strict";
    var aliases2 = ["stdin", "stdout", "stderr"];
    var hasAlias = /* @__PURE__ */ __name((options2) => aliases2.some((alias) => options2[alias] !== void 0), "hasAlias");
    var normalizeStdio = /* @__PURE__ */ __name((options2) => {
      if (!options2) {
        return;
      }
      const { stdio } = options2;
      if (stdio === void 0) {
        return aliases2.map((alias) => options2[alias]);
      }
      if (hasAlias(options2)) {
        throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases2.map((alias) => `\`${alias}\``).join(", ")}`);
      }
      if (typeof stdio === "string") {
        return stdio;
      }
      if (!Array.isArray(stdio)) {
        throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``);
      }
      const length = Math.max(stdio.length, aliases2.length);
      return Array.from({ length }, (value, index2) => stdio[index2]);
    }, "normalizeStdio");
    module2.exports = normalizeStdio;
    module2.exports.node = (options2) => {
      const stdio = normalizeStdio(options2);
      if (stdio === "ipc") {
        return "ipc";
      }
      if (stdio === void 0 || typeof stdio === "string") {
        return [stdio, stdio, stdio, "ipc"];
      }
      if (stdio.includes("ipc")) {
        return stdio;
      }
      return [...stdio, "ipc"];
    };
  }
});

// ../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/signals.js
var require_signals2 = __commonJS({
  "../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/signals.js"(exports2, module2) {
    module2.exports = [
      "SIGABRT",
      "SIGALRM",
      "SIGHUP",
      "SIGINT",
      "SIGTERM"
    ];
    if (process.platform !== "win32") {
      module2.exports.push(
        "SIGVTALRM",
        "SIGXCPU",
        "SIGXFSZ",
        "SIGUSR2",
        "SIGTRAP",
        "SIGSYS",
        "SIGQUIT",
        "SIGIOT"
      );
    }
    if (process.platform === "linux") {
      module2.exports.push(
        "SIGIO",
        "SIGPOLL",
        "SIGPWR",
        "SIGSTKFLT",
        "SIGUNUSED"
      );
    }
  }
});

// ../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/index.js
var require_signal_exit = __commonJS({
  "../../node_modules/.pnpm/signal-exit@3.0.7/node_modules/signal-exit/index.js"(exports2, module2) {
    var process2 = global.process;
    var processOk = /* @__PURE__ */ __name(function(process3) {
      return process3 && typeof process3 === "object" && typeof process3.removeListener === "function" && typeof process3.emit === "function" && typeof process3.reallyExit === "function" && typeof process3.listeners === "function" && typeof process3.kill === "function" && typeof process3.pid === "number" && typeof process3.on === "function";
    }, "processOk");
    if (!processOk(process2)) {
      module2.exports = function() {
        return function() {
        };
      };
    } else {
      assert = require("assert");
      signals = require_signals2();
      isWin = /^win/i.test(process2.platform);
      EE = require("events");
      if (typeof EE !== "function") {
        EE = EE.EventEmitter;
      }
      if (process2.__signal_exit_emitter__) {
        emitter = process2.__signal_exit_emitter__;
      } else {
        emitter = process2.__signal_exit_emitter__ = new EE();
        emitter.count = 0;
        emitter.emitted = {};
      }
      if (!emitter.infinite) {
        emitter.setMaxListeners(Infinity);
        emitter.infinite = true;
      }
      module2.exports = function(cb, opts2) {
        if (!processOk(global.process)) {
          return function() {
          };
        }
        assert.equal(typeof cb, "function", "a callback must be provided for exit handler");
        if (loaded === false) {
          load();
        }
        var ev = "exit";
        if (opts2 && opts2.alwaysLast) {
          ev = "afterexit";
        }
        var remove = /* @__PURE__ */ __name(function() {
          emitter.removeListener(ev, cb);
          if (emitter.listeners("exit").length === 0 && emitter.listeners("afterexit").length === 0) {
            unload();
          }
        }, "remove");
        emitter.on(ev, cb);
        return remove;
      };
      unload = /* @__PURE__ */ __name(function unload2() {
        if (!loaded || !processOk(global.process)) {
          return;
        }
        loaded = false;
        signals.forEach(function(sig) {
          try {
            process2.removeListener(sig, sigListeners[sig]);
          } catch (er) {
          }
        });
        process2.emit = originalProcessEmit;
        process2.reallyExit = originalProcessReallyExit;
        emitter.count -= 1;
      }, "unload");
      module2.exports.unload = unload;
      emit = /* @__PURE__ */ __name(function emit2(event, code, signal) {
        if (emitter.emitted[event]) {
          return;
        }
        emitter.emitted[event] = true;
        emitter.emit(event, code, signal);
      }, "emit");
      sigListeners = {};
      signals.forEach(function(sig) {
        sigListeners[sig] = /* @__PURE__ */ __name(function listener() {
          if (!processOk(global.process)) {
            return;
          }
          var listeners = process2.listeners(sig);
          if (listeners.length === emitter.count) {
            unload();
            emit("exit", null, sig);
            emit("afterexit", null, sig);
            if (isWin && sig === "SIGHUP") {
              sig = "SIGINT";
            }
            process2.kill(process2.pid, sig);
          }
        }, "listener");
      });
      module2.exports.signals = function() {
        return signals;
      };
      loaded = false;
      load = /* @__PURE__ */ __name(function load2() {
        if (loaded || !processOk(global.process)) {
          return;
        }
        loaded = true;
        emitter.count += 1;
        signals = signals.filter(function(sig) {
          try {
            process2.on(sig, sigListeners[sig]);
            return true;
          } catch (er) {
            return false;
          }
        });
        process2.emit = processEmit;
        process2.reallyExit = processReallyExit;
      }, "load");
      module2.exports.load = load;
      originalProcessReallyExit = process2.reallyExit;
      processReallyExit = /* @__PURE__ */ __name(function processReallyExit2(code) {
        if (!processOk(global.process)) {
          return;
        }
        process2.exitCode = code || 0;
        emit("exit", process2.exitCode, null);
        emit("afterexit", process2.exitCode, null);
        originalProcessReallyExit.call(process2, process2.exitCode);
      }, "processReallyExit");
      originalProcessEmit = process2.emit;
      processEmit = /* @__PURE__ */ __name(function processEmit2(ev, arg2) {
        if (ev === "exit" && processOk(global.process)) {
          if (arg2 !== void 0) {
            process2.exitCode = arg2;
          }
          var ret = originalProcessEmit.apply(this, arguments);
          emit("exit", process2.exitCode, null);
          emit("afterexit", process2.exitCode, null);
          return ret;
        } else {
          return originalProcessEmit.apply(this, arguments);
        }
      }, "processEmit");
    }
    var assert;
    var signals;
    var isWin;
    var EE;
    var emitter;
    var unload;
    var emit;
    var sigListeners;
    var loaded;
    var load;
    var originalProcessReallyExit;
    var processReallyExit;
    var originalProcessEmit;
    var processEmit;
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/kill.js
var require_kill = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/kill.js"(exports2, module2) {
    "use strict";
    var os6 = require("os");
    var onExit = require_signal_exit();
    var DEFAULT_FORCE_KILL_TIMEOUT = 1e3 * 5;
    var spawnedKill = /* @__PURE__ */ __name((kill, signal = "SIGTERM", options2 = {}) => {
      const killResult = kill(signal);
      setKillTimeout(kill, signal, options2, killResult);
      return killResult;
    }, "spawnedKill");
    var setKillTimeout = /* @__PURE__ */ __name((kill, signal, options2, killResult) => {
      if (!shouldForceKill(signal, options2, killResult)) {
        return;
      }
      const timeout2 = getForceKillAfterTimeout(options2);
      const t5 = setTimeout(() => {
        kill("SIGKILL");
      }, timeout2);
      if (t5.unref) {
        t5.unref();
      }
    }, "setKillTimeout");
    var shouldForceKill = /* @__PURE__ */ __name((signal, { forceKillAfterTimeout }, killResult) => {
      return isSigterm(signal) && forceKillAfterTimeout !== false && killResult;
    }, "shouldForceKill");
    var isSigterm = /* @__PURE__ */ __name((signal) => {
      return signal === os6.constants.signals.SIGTERM || typeof signal === "string" && signal.toUpperCase() === "SIGTERM";
    }, "isSigterm");
    var getForceKillAfterTimeout = /* @__PURE__ */ __name(({ forceKillAfterTimeout = true }) => {
      if (forceKillAfterTimeout === true) {
        return DEFAULT_FORCE_KILL_TIMEOUT;
      }
      if (!Number.isFinite(forceKillAfterTimeout) || forceKillAfterTimeout < 0) {
        throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`);
      }
      return forceKillAfterTimeout;
    }, "getForceKillAfterTimeout");
    var spawnedCancel = /* @__PURE__ */ __name((spawned, context) => {
      const killResult = spawned.kill();
      if (killResult) {
        context.isCanceled = true;
      }
    }, "spawnedCancel");
    var timeoutKill = /* @__PURE__ */ __name((spawned, signal, reject2) => {
      spawned.kill(signal);
      reject2(Object.assign(new Error("Timed out"), { timedOut: true, signal }));
    }, "timeoutKill");
    var setupTimeout = /* @__PURE__ */ __name((spawned, { timeout: timeout2, killSignal = "SIGTERM" }, spawnedPromise) => {
      if (timeout2 === 0 || timeout2 === void 0) {
        return spawnedPromise;
      }
      let timeoutId;
      const timeoutPromise = new Promise((resolve2, reject2) => {
        timeoutId = setTimeout(() => {
          timeoutKill(spawned, killSignal, reject2);
        }, timeout2);
      });
      const safeSpawnedPromise = spawnedPromise.finally(() => {
        clearTimeout(timeoutId);
      });
      return Promise.race([timeoutPromise, safeSpawnedPromise]);
    }, "setupTimeout");
    var validateTimeout = /* @__PURE__ */ __name(({ timeout: timeout2 }) => {
      if (timeout2 !== void 0 && (!Number.isFinite(timeout2) || timeout2 < 0)) {
        throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout2}\` (${typeof timeout2})`);
      }
    }, "validateTimeout");
    var setExitHandler = /* @__PURE__ */ __name(async (spawned, { cleanup: cleanup2, detached }, timedPromise) => {
      if (!cleanup2 || detached) {
        return timedPromise;
      }
      const removeExitHandler = onExit(() => {
        spawned.kill();
      });
      return timedPromise.finally(() => {
        removeExitHandler();
      });
    }, "setExitHandler");
    module2.exports = {
      spawnedKill,
      spawnedCancel,
      setupTimeout,
      validateTimeout,
      setExitHandler
    };
  }
});

// ../../node_modules/.pnpm/is-stream@2.0.1/node_modules/is-stream/index.js
var require_is_stream = __commonJS({
  "../../node_modules/.pnpm/is-stream@2.0.1/node_modules/is-stream/index.js"(exports2, module2) {
    "use strict";
    var isStream = /* @__PURE__ */ __name((stream3) => stream3 !== null && typeof stream3 === "object" && typeof stream3.pipe === "function", "isStream");
    isStream.writable = (stream3) => isStream(stream3) && stream3.writable !== false && typeof stream3._write === "function" && typeof stream3._writableState === "object";
    isStream.readable = (stream3) => isStream(stream3) && stream3.readable !== false && typeof stream3._read === "function" && typeof stream3._readableState === "object";
    isStream.duplex = (stream3) => isStream.writable(stream3) && isStream.readable(stream3);
    isStream.transform = (stream3) => isStream.duplex(stream3) && typeof stream3._transform === "function";
    module2.exports = isStream;
  }
});

// ../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/buffer-stream.js
var require_buffer_stream = __commonJS({
  "../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/buffer-stream.js"(exports2, module2) {
    "use strict";
    var { PassThrough: PassThroughStream } = require("stream");
    module2.exports = (options2) => {
      options2 = { ...options2 };
      const { array } = options2;
      let { encoding } = options2;
      const isBuffer = encoding === "buffer";
      let objectMode = false;
      if (array) {
        objectMode = !(encoding || isBuffer);
      } else {
        encoding = encoding || "utf8";
      }
      if (isBuffer) {
        encoding = null;
      }
      const stream3 = new PassThroughStream({ objectMode });
      if (encoding) {
        stream3.setEncoding(encoding);
      }
      let length = 0;
      const chunks = [];
      stream3.on("data", (chunk) => {
        chunks.push(chunk);
        if (objectMode) {
          length = chunks.length;
        } else {
          length += chunk.length;
        }
      });
      stream3.getBufferedValue = () => {
        if (array) {
          return chunks;
        }
        return isBuffer ? Buffer.concat(chunks, length) : chunks.join("");
      };
      stream3.getBufferedLength = () => length;
      return stream3;
    };
  }
});

// ../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/index.js
var require_get_stream = __commonJS({
  "../../node_modules/.pnpm/get-stream@6.0.1/node_modules/get-stream/index.js"(exports2, module2) {
    "use strict";
    var { constants: BufferConstants } = require("buffer");
    var stream3 = require("stream");
    var { promisify: promisify12 } = require("util");
    var bufferStream = require_buffer_stream();
    var streamPipelinePromisified = promisify12(stream3.pipeline);
    var MaxBufferError = class extends Error {
      constructor() {
        super("maxBuffer exceeded");
        this.name = "MaxBufferError";
      }
    };
    __name(MaxBufferError, "MaxBufferError");
    async function getStream(inputStream, options2) {
      if (!inputStream) {
        throw new Error("Expected a stream");
      }
      options2 = {
        maxBuffer: Infinity,
        ...options2
      };
      const { maxBuffer } = options2;
      const stream4 = bufferStream(options2);
      await new Promise((resolve2, reject2) => {
        const rejectPromise = /* @__PURE__ */ __name((error2) => {
          if (error2 && stream4.getBufferedLength() <= BufferConstants.MAX_LENGTH) {
            error2.bufferedData = stream4.getBufferedValue();
          }
          reject2(error2);
        }, "rejectPromise");
        (async () => {
          try {
            await streamPipelinePromisified(inputStream, stream4);
            resolve2();
          } catch (error2) {
            rejectPromise(error2);
          }
        })();
        stream4.on("data", () => {
          if (stream4.getBufferedLength() > maxBuffer) {
            rejectPromise(new MaxBufferError());
          }
        });
      });
      return stream4.getBufferedValue();
    }
    __name(getStream, "getStream");
    module2.exports = getStream;
    module2.exports.buffer = (stream4, options2) => getStream(stream4, { ...options2, encoding: "buffer" });
    module2.exports.array = (stream4, options2) => getStream(stream4, { ...options2, array: true });
    module2.exports.MaxBufferError = MaxBufferError;
  }
});

// ../../node_modules/.pnpm/merge-stream@2.0.0/node_modules/merge-stream/index.js
var require_merge_stream = __commonJS({
  "../../node_modules/.pnpm/merge-stream@2.0.0/node_modules/merge-stream/index.js"(exports2, module2) {
    "use strict";
    var { PassThrough: PassThrough2 } = require("stream");
    module2.exports = function() {
      var sources = [];
      var output = new PassThrough2({ objectMode: true });
      output.setMaxListeners(0);
      output.add = add;
      output.isEmpty = isEmpty;
      output.on("unpipe", remove);
      Array.prototype.slice.call(arguments).forEach(add);
      return output;
      function add(source) {
        if (Array.isArray(source)) {
          source.forEach(add);
          return this;
        }
        sources.push(source);
        source.once("end", remove.bind(null, source));
        source.once("error", output.emit.bind(output, "error"));
        source.pipe(output, { end: false });
        return this;
      }
      __name(add, "add");
      function isEmpty() {
        return sources.length == 0;
      }
      __name(isEmpty, "isEmpty");
      function remove(source) {
        sources = sources.filter(function(it) {
          return it !== source;
        });
        if (!sources.length && output.readable) {
          output.end();
        }
      }
      __name(remove, "remove");
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stream.js
var require_stream = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/stream.js"(exports2, module2) {
    "use strict";
    var isStream = require_is_stream();
    var getStream = require_get_stream();
    var mergeStream = require_merge_stream();
    var handleInput = /* @__PURE__ */ __name((spawned, input) => {
      if (input === void 0 || spawned.stdin === void 0) {
        return;
      }
      if (isStream(input)) {
        input.pipe(spawned.stdin);
      } else {
        spawned.stdin.end(input);
      }
    }, "handleInput");
    var makeAllStream = /* @__PURE__ */ __name((spawned, { all }) => {
      if (!all || !spawned.stdout && !spawned.stderr) {
        return;
      }
      const mixed = mergeStream();
      if (spawned.stdout) {
        mixed.add(spawned.stdout);
      }
      if (spawned.stderr) {
        mixed.add(spawned.stderr);
      }
      return mixed;
    }, "makeAllStream");
    var getBufferedData = /* @__PURE__ */ __name(async (stream3, streamPromise) => {
      if (!stream3) {
        return;
      }
      stream3.destroy();
      try {
        return await streamPromise;
      } catch (error2) {
        return error2.bufferedData;
      }
    }, "getBufferedData");
    var getStreamPromise = /* @__PURE__ */ __name((stream3, { encoding, buffer, maxBuffer }) => {
      if (!stream3 || !buffer) {
        return;
      }
      if (encoding) {
        return getStream(stream3, { encoding, maxBuffer });
      }
      return getStream.buffer(stream3, { maxBuffer });
    }, "getStreamPromise");
    var getSpawnedResult = /* @__PURE__ */ __name(async ({ stdout, stderr, all }, { encoding, buffer, maxBuffer }, processDone) => {
      const stdoutPromise = getStreamPromise(stdout, { encoding, buffer, maxBuffer });
      const stderrPromise = getStreamPromise(stderr, { encoding, buffer, maxBuffer });
      const allPromise = getStreamPromise(all, { encoding, buffer, maxBuffer: maxBuffer * 2 });
      try {
        return await Promise.all([processDone, stdoutPromise, stderrPromise, allPromise]);
      } catch (error2) {
        return Promise.all([
          { error: error2, signal: error2.signal, timedOut: error2.timedOut },
          getBufferedData(stdout, stdoutPromise),
          getBufferedData(stderr, stderrPromise),
          getBufferedData(all, allPromise)
        ]);
      }
    }, "getSpawnedResult");
    var validateInputSync = /* @__PURE__ */ __name(({ input }) => {
      if (isStream(input)) {
        throw new TypeError("The `input` option cannot be a stream in sync mode");
      }
    }, "validateInputSync");
    module2.exports = {
      handleInput,
      makeAllStream,
      getSpawnedResult,
      validateInputSync
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/promise.js
var require_promise = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/promise.js"(exports2, module2) {
    "use strict";
    var nativePromisePrototype = (async () => {
    })().constructor.prototype;
    var descriptors = ["then", "catch", "finally"].map((property) => [
      property,
      Reflect.getOwnPropertyDescriptor(nativePromisePrototype, property)
    ]);
    var mergePromise = /* @__PURE__ */ __name((spawned, promise) => {
      for (const [property, descriptor] of descriptors) {
        const value = typeof promise === "function" ? (...args3) => Reflect.apply(descriptor.value, promise(), args3) : descriptor.value.bind(promise);
        Reflect.defineProperty(spawned, property, { ...descriptor, value });
      }
      return spawned;
    }, "mergePromise");
    var getSpawnedPromise = /* @__PURE__ */ __name((spawned) => {
      return new Promise((resolve2, reject2) => {
        spawned.on("exit", (exitCode, signal) => {
          resolve2({ exitCode, signal });
        });
        spawned.on("error", (error2) => {
          reject2(error2);
        });
        if (spawned.stdin) {
          spawned.stdin.on("error", (error2) => {
            reject2(error2);
          });
        }
      });
    }, "getSpawnedPromise");
    module2.exports = {
      mergePromise,
      getSpawnedPromise
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/command.js
var require_command = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/lib/command.js"(exports2, module2) {
    "use strict";
    var normalizeArgs = /* @__PURE__ */ __name((file2, args3 = []) => {
      if (!Array.isArray(args3)) {
        return [file2];
      }
      return [file2, ...args3];
    }, "normalizeArgs");
    var NO_ESCAPE_REGEXP = /^[\w.-]+$/;
    var DOUBLE_QUOTES_REGEXP = /"/g;
    var escapeArg = /* @__PURE__ */ __name((arg2) => {
      if (typeof arg2 !== "string" || NO_ESCAPE_REGEXP.test(arg2)) {
        return arg2;
      }
      return `"${arg2.replace(DOUBLE_QUOTES_REGEXP, '\\"')}"`;
    }, "escapeArg");
    var joinCommand = /* @__PURE__ */ __name((file2, args3) => {
      return normalizeArgs(file2, args3).join(" ");
    }, "joinCommand");
    var getEscapedCommand = /* @__PURE__ */ __name((file2, args3) => {
      return normalizeArgs(file2, args3).map((arg2) => escapeArg(arg2)).join(" ");
    }, "getEscapedCommand");
    var SPACES_REGEXP = / +/g;
    var parseCommand = /* @__PURE__ */ __name((command) => {
      const tokens = [];
      for (const token of command.trim().split(SPACES_REGEXP)) {
        const previousToken = tokens[tokens.length - 1];
        if (previousToken && previousToken.endsWith("\\")) {
          tokens[tokens.length - 1] = `${previousToken.slice(0, -1)} ${token}`;
        } else {
          tokens.push(token);
        }
      }
      return tokens;
    }, "parseCommand");
    module2.exports = {
      joinCommand,
      getEscapedCommand,
      parseCommand
    };
  }
});

// ../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/index.js
var require_execa = __commonJS({
  "../../node_modules/.pnpm/execa@5.1.1/node_modules/execa/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var childProcess = require("child_process");
    var crossSpawn = require_cross_spawn();
    var stripFinalNewline = require_strip_final_newline();
    var npmRunPath = require_npm_run_path();
    var onetime = require_onetime();
    var makeError = require_error();
    var normalizeStdio = require_stdio();
    var { spawnedKill, spawnedCancel, setupTimeout, validateTimeout, setExitHandler } = require_kill();
    var { handleInput, getSpawnedResult, makeAllStream, validateInputSync } = require_stream();
    var { mergePromise, getSpawnedPromise } = require_promise();
    var { joinCommand, parseCommand, getEscapedCommand } = require_command();
    var DEFAULT_MAX_BUFFER = 1e3 * 1e3 * 100;
    var getEnv = /* @__PURE__ */ __name(({ env: envOption, extendEnv, preferLocal, localDir, execPath }) => {
      const env2 = extendEnv ? { ...process.env, ...envOption } : envOption;
      if (preferLocal) {
        return npmRunPath.env({ env: env2, cwd: localDir, execPath });
      }
      return env2;
    }, "getEnv");
    var handleArguments = /* @__PURE__ */ __name((file2, args3, options2 = {}) => {
      const parsed = crossSpawn._parse(file2, args3, options2);
      file2 = parsed.command;
      args3 = parsed.args;
      options2 = parsed.options;
      options2 = {
        maxBuffer: DEFAULT_MAX_BUFFER,
        buffer: true,
        stripFinalNewline: true,
        extendEnv: true,
        preferLocal: false,
        localDir: options2.cwd || process.cwd(),
        execPath: process.execPath,
        encoding: "utf8",
        reject: true,
        cleanup: true,
        all: false,
        windowsHide: true,
        ...options2
      };
      options2.env = getEnv(options2);
      options2.stdio = normalizeStdio(options2);
      if (process.platform === "win32" && path32.basename(file2, ".exe") === "cmd") {
        args3.unshift("/q");
      }
      return { file: file2, args: args3, options: options2, parsed };
    }, "handleArguments");
    var handleOutput = /* @__PURE__ */ __name((options2, value, error2) => {
      if (typeof value !== "string" && !Buffer.isBuffer(value)) {
        return error2 === void 0 ? void 0 : "";
      }
      if (options2.stripFinalNewline) {
        return stripFinalNewline(value);
      }
      return value;
    }, "handleOutput");
    var execa7 = /* @__PURE__ */ __name((file2, args3, options2) => {
      const parsed = handleArguments(file2, args3, options2);
      const command = joinCommand(file2, args3);
      const escapedCommand = getEscapedCommand(file2, args3);
      validateTimeout(parsed.options);
      let spawned;
      try {
        spawned = childProcess.spawn(parsed.file, parsed.args, parsed.options);
      } catch (error2) {
        const dummySpawned = new childProcess.ChildProcess();
        const errorPromise = Promise.reject(makeError({
          error: error2,
          stdout: "",
          stderr: "",
          all: "",
          command,
          escapedCommand,
          parsed,
          timedOut: false,
          isCanceled: false,
          killed: false
        }));
        return mergePromise(dummySpawned, errorPromise);
      }
      const spawnedPromise = getSpawnedPromise(spawned);
      const timedPromise = setupTimeout(spawned, parsed.options, spawnedPromise);
      const processDone = setExitHandler(spawned, parsed.options, timedPromise);
      const context = { isCanceled: false };
      spawned.kill = spawnedKill.bind(null, spawned.kill.bind(spawned));
      spawned.cancel = spawnedCancel.bind(null, spawned, context);
      const handlePromise2 = /* @__PURE__ */ __name(async () => {
        const [{ error: error2, exitCode, signal, timedOut }, stdoutResult, stderrResult, allResult] = await getSpawnedResult(spawned, parsed.options, processDone);
        const stdout = handleOutput(parsed.options, stdoutResult);
        const stderr = handleOutput(parsed.options, stderrResult);
        const all = handleOutput(parsed.options, allResult);
        if (error2 || exitCode !== 0 || signal !== null) {
          const returnedError = makeError({
            error: error2,
            exitCode,
            signal,
            stdout,
            stderr,
            all,
            command,
            escapedCommand,
            parsed,
            timedOut,
            isCanceled: context.isCanceled,
            killed: spawned.killed
          });
          if (!parsed.options.reject) {
            return returnedError;
          }
          throw returnedError;
        }
        return {
          command,
          escapedCommand,
          exitCode: 0,
          stdout,
          stderr,
          all,
          failed: false,
          timedOut: false,
          isCanceled: false,
          killed: false
        };
      }, "handlePromise");
      const handlePromiseOnce = onetime(handlePromise2);
      handleInput(spawned, parsed.options.input);
      spawned.all = makeAllStream(spawned, parsed.options);
      return mergePromise(spawned, handlePromiseOnce);
    }, "execa");
    module2.exports = execa7;
    module2.exports.sync = (file2, args3, options2) => {
      const parsed = handleArguments(file2, args3, options2);
      const command = joinCommand(file2, args3);
      const escapedCommand = getEscapedCommand(file2, args3);
      validateInputSync(parsed.options);
      let result;
      try {
        result = childProcess.spawnSync(parsed.file, parsed.args, parsed.options);
      } catch (error2) {
        throw makeError({
          error: error2,
          stdout: "",
          stderr: "",
          all: "",
          command,
          escapedCommand,
          parsed,
          timedOut: false,
          isCanceled: false,
          killed: false
        });
      }
      const stdout = handleOutput(parsed.options, result.stdout, result.error);
      const stderr = handleOutput(parsed.options, result.stderr, result.error);
      if (result.error || result.status !== 0 || result.signal !== null) {
        const error2 = makeError({
          stdout,
          stderr,
          error: result.error,
          signal: result.signal,
          exitCode: result.status,
          command,
          escapedCommand,
          parsed,
          timedOut: result.error && result.error.code === "ETIMEDOUT",
          isCanceled: false,
          killed: result.signal !== null
        });
        if (!parsed.options.reject) {
          return error2;
        }
        throw error2;
      }
      return {
        command,
        escapedCommand,
        exitCode: 0,
        stdout,
        stderr,
        failed: false,
        timedOut: false,
        isCanceled: false,
        killed: false
      };
    };
    module2.exports.command = (command, options2) => {
      const [file2, ...args3] = parseCommand(command);
      return execa7(file2, args3, options2);
    };
    module2.exports.commandSync = (command, options2) => {
      const [file2, ...args3] = parseCommand(command);
      return execa7.sync(file2, args3, options2);
    };
    module2.exports.node = (scriptPath, args3, options2 = {}) => {
      if (args3 && !Array.isArray(args3) && typeof args3 === "object") {
        options2 = args3;
        args3 = [];
      }
      const stdio = normalizeStdio.node(options2);
      const defaultExecArgv = process.execArgv.filter((arg2) => !arg2.startsWith("--inspect"));
      const {
        nodePath = process.execPath,
        nodeOptions = defaultExecArgv
      } = options2;
      return execa7(
        nodePath,
        [
          ...nodeOptions,
          scriptPath,
          ...Array.isArray(args3) ? args3 : []
        ],
        {
          ...options2,
          stdin: void 0,
          stdout: void 0,
          stderr: void 0,
          stdio,
          shell: false
        }
      );
    };
  }
});

// ../../node_modules/.pnpm/p-try@2.2.0/node_modules/p-try/index.js
var require_p_try = __commonJS({
  "../../node_modules/.pnpm/p-try@2.2.0/node_modules/p-try/index.js"(exports2, module2) {
    "use strict";
    var pTry = /* @__PURE__ */ __name((fn2, ...arguments_) => new Promise((resolve2) => {
      resolve2(fn2(...arguments_));
    }), "pTry");
    module2.exports = pTry;
    module2.exports.default = pTry;
  }
});

// ../../node_modules/.pnpm/p-limit@2.3.0/node_modules/p-limit/index.js
var require_p_limit2 = __commonJS({
  "../../node_modules/.pnpm/p-limit@2.3.0/node_modules/p-limit/index.js"(exports2, module2) {
    "use strict";
    var pTry = require_p_try();
    var pLimit = /* @__PURE__ */ __name((concurrency) => {
      if (!((Number.isInteger(concurrency) || concurrency === Infinity) && concurrency > 0)) {
        return Promise.reject(new TypeError("Expected `concurrency` to be a number from 1 and up"));
      }
      const queue2 = [];
      let activeCount = 0;
      const next = /* @__PURE__ */ __name(() => {
        activeCount--;
        if (queue2.length > 0) {
          queue2.shift()();
        }
      }, "next");
      const run = /* @__PURE__ */ __name((fn2, resolve2, ...args3) => {
        activeCount++;
        const result = pTry(fn2, ...args3);
        resolve2(result);
        result.then(next, next);
      }, "run");
      const enqueue = /* @__PURE__ */ __name((fn2, resolve2, ...args3) => {
        if (activeCount < concurrency) {
          run(fn2, resolve2, ...args3);
        } else {
          queue2.push(run.bind(null, fn2, resolve2, ...args3));
        }
      }, "enqueue");
      const generator = /* @__PURE__ */ __name((fn2, ...args3) => new Promise((resolve2) => enqueue(fn2, resolve2, ...args3)), "generator");
      Object.defineProperties(generator, {
        activeCount: {
          get: () => activeCount
        },
        pendingCount: {
          get: () => queue2.length
        },
        clearQueue: {
          value: () => {
            queue2.length = 0;
          }
        }
      });
      return generator;
    }, "pLimit");
    module2.exports = pLimit;
    module2.exports.default = pLimit;
  }
});

// ../../node_modules/.pnpm/p-locate@4.1.0/node_modules/p-locate/index.js
var require_p_locate2 = __commonJS({
  "../../node_modules/.pnpm/p-locate@4.1.0/node_modules/p-locate/index.js"(exports2, module2) {
    "use strict";
    var pLimit = require_p_limit2();
    var EndError = class extends Error {
      constructor(value) {
        super();
        this.value = value;
      }
    };
    __name(EndError, "EndError");
    var testElement = /* @__PURE__ */ __name(async (element, tester) => tester(await element), "testElement");
    var finder = /* @__PURE__ */ __name(async (element) => {
      const values = await Promise.all(element);
      if (values[1] === true) {
        throw new EndError(values[0]);
      }
      return false;
    }, "finder");
    var pLocate = /* @__PURE__ */ __name(async (iterable, tester, options2) => {
      options2 = {
        concurrency: Infinity,
        preserveOrder: true,
        ...options2
      };
      const limit = pLimit(options2.concurrency);
      const items = [...iterable].map((element) => [element, limit(testElement, element, tester)]);
      const checkLimit = pLimit(options2.preserveOrder ? 1 : Infinity);
      try {
        await Promise.all(items.map((element) => checkLimit(finder, element)));
      } catch (error2) {
        if (error2 instanceof EndError) {
          return error2.value;
        }
        throw error2;
      }
    }, "pLocate");
    module2.exports = pLocate;
    module2.exports.default = pLocate;
  }
});

// ../../node_modules/.pnpm/locate-path@5.0.0/node_modules/locate-path/index.js
var require_locate_path2 = __commonJS({
  "../../node_modules/.pnpm/locate-path@5.0.0/node_modules/locate-path/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var fs37 = require("fs");
    var { promisify: promisify12 } = require("util");
    var pLocate = require_p_locate2();
    var fsStat = promisify12(fs37.stat);
    var fsLStat = promisify12(fs37.lstat);
    var typeMappings = {
      directory: "isDirectory",
      file: "isFile"
    };
    function checkType({ type }) {
      if (type in typeMappings) {
        return;
      }
      throw new Error(`Invalid type specified: ${type}`);
    }
    __name(checkType, "checkType");
    var matchType = /* @__PURE__ */ __name((type, stat2) => type === void 0 || stat2[typeMappings[type]](), "matchType");
    module2.exports = async (paths2, options2) => {
      options2 = {
        cwd: process.cwd(),
        type: "file",
        allowSymlinks: true,
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fsStat : fsLStat;
      return pLocate(paths2, async (path_) => {
        try {
          const stat2 = await statFn(path32.resolve(options2.cwd, path_));
          return matchType(options2.type, stat2);
        } catch (_2) {
          return false;
        }
      }, options2);
    };
    module2.exports.sync = (paths2, options2) => {
      options2 = {
        cwd: process.cwd(),
        allowSymlinks: true,
        type: "file",
        ...options2
      };
      checkType(options2);
      const statFn = options2.allowSymlinks ? fs37.statSync : fs37.lstatSync;
      for (const path_ of paths2) {
        try {
          const stat2 = statFn(path32.resolve(options2.cwd, path_));
          if (matchType(options2.type, stat2)) {
            return path_;
          }
        } catch (_2) {
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/find-up@4.1.0/node_modules/find-up/index.js
var require_find_up2 = __commonJS({
  "../../node_modules/.pnpm/find-up@4.1.0/node_modules/find-up/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var locatePath = require_locate_path2();
    var pathExists = require_path_exists();
    var stop = Symbol("findUp.stop");
    module2.exports = async (name, options2 = {}) => {
      let directory = path32.resolve(options2.cwd || "");
      const { root } = path32.parse(directory);
      const paths2 = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name(async (locateOptions) => {
        if (typeof name !== "function") {
          return locatePath(paths2, locateOptions);
        }
        const foundPath = await name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = await runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path32.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path32.dirname(directory);
      }
    };
    module2.exports.sync = (name, options2 = {}) => {
      let directory = path32.resolve(options2.cwd || "");
      const { root } = path32.parse(directory);
      const paths2 = [].concat(name);
      const runMatcher = /* @__PURE__ */ __name((locateOptions) => {
        if (typeof name !== "function") {
          return locatePath.sync(paths2, locateOptions);
        }
        const foundPath = name(locateOptions.cwd);
        if (typeof foundPath === "string") {
          return locatePath.sync([foundPath], locateOptions);
        }
        return foundPath;
      }, "runMatcher");
      while (true) {
        const foundPath = runMatcher({ ...options2, cwd: directory });
        if (foundPath === stop) {
          return;
        }
        if (foundPath) {
          return path32.resolve(directory, foundPath);
        }
        if (directory === root) {
          return;
        }
        directory = path32.dirname(directory);
      }
    };
    module2.exports.exists = pathExists;
    module2.exports.sync.exists = pathExists.sync;
    module2.exports.stop = stop;
  }
});

// ../../node_modules/.pnpm/is-arrayish@0.2.1/node_modules/is-arrayish/index.js
var require_is_arrayish = __commonJS({
  "../../node_modules/.pnpm/is-arrayish@0.2.1/node_modules/is-arrayish/index.js"(exports2, module2) {
    "use strict";
    module2.exports = /* @__PURE__ */ __name(function isArrayish(obj) {
      if (!obj) {
        return false;
      }
      return obj instanceof Array || Array.isArray(obj) || obj.length >= 0 && obj.splice instanceof Function;
    }, "isArrayish");
  }
});

// ../../node_modules/.pnpm/error-ex@1.3.2/node_modules/error-ex/index.js
var require_error_ex = __commonJS({
  "../../node_modules/.pnpm/error-ex@1.3.2/node_modules/error-ex/index.js"(exports2, module2) {
    "use strict";
    var util4 = require("util");
    var isArrayish = require_is_arrayish();
    var errorEx = /* @__PURE__ */ __name(function errorEx2(name, properties) {
      if (!name || name.constructor !== String) {
        properties = name || {};
        name = Error.name;
      }
      var errorExError = /* @__PURE__ */ __name(function ErrorEXError(message2) {
        if (!this) {
          return new ErrorEXError(message2);
        }
        message2 = message2 instanceof Error ? message2.message : message2 || this.message;
        Error.call(this, message2);
        Error.captureStackTrace(this, errorExError);
        this.name = name;
        Object.defineProperty(this, "message", {
          configurable: true,
          enumerable: false,
          get: function() {
            var newMessage = message2.split(/\r?\n/g);
            for (var key in properties) {
              if (!properties.hasOwnProperty(key)) {
                continue;
              }
              var modifier = properties[key];
              if ("message" in modifier) {
                newMessage = modifier.message(this[key], newMessage) || newMessage;
                if (!isArrayish(newMessage)) {
                  newMessage = [newMessage];
                }
              }
            }
            return newMessage.join("\n");
          },
          set: function(v3) {
            message2 = v3;
          }
        });
        var overwrittenStack = null;
        var stackDescriptor = Object.getOwnPropertyDescriptor(this, "stack");
        var stackGetter = stackDescriptor.get;
        var stackValue = stackDescriptor.value;
        delete stackDescriptor.value;
        delete stackDescriptor.writable;
        stackDescriptor.set = function(newstack) {
          overwrittenStack = newstack;
        };
        stackDescriptor.get = function() {
          var stack2 = (overwrittenStack || (stackGetter ? stackGetter.call(this) : stackValue)).split(/\r?\n+/g);
          if (!overwrittenStack) {
            stack2[0] = this.name + ": " + this.message;
          }
          var lineCount = 1;
          for (var key in properties) {
            if (!properties.hasOwnProperty(key)) {
              continue;
            }
            var modifier = properties[key];
            if ("line" in modifier) {
              var line = modifier.line(this[key]);
              if (line) {
                stack2.splice(lineCount++, 0, "    " + line);
              }
            }
            if ("stack" in modifier) {
              modifier.stack(this[key], stack2);
            }
          }
          return stack2.join("\n");
        };
        Object.defineProperty(this, "stack", stackDescriptor);
      }, "ErrorEXError");
      if (Object.setPrototypeOf) {
        Object.setPrototypeOf(errorExError.prototype, Error.prototype);
        Object.setPrototypeOf(errorExError, Error);
      } else {
        util4.inherits(errorExError, Error);
      }
      return errorExError;
    }, "errorEx");
    errorEx.append = function(str, def) {
      return {
        message: function(v3, message2) {
          v3 = v3 || def;
          if (v3) {
            message2[0] += " " + str.replace("%s", v3.toString());
          }
          return message2;
        }
      };
    };
    errorEx.line = function(str, def) {
      return {
        line: function(v3) {
          v3 = v3 || def;
          if (v3) {
            return str.replace("%s", v3.toString());
          }
          return null;
        }
      };
    };
    module2.exports = errorEx;
  }
});

// ../../node_modules/.pnpm/json-parse-even-better-errors@2.3.1/node_modules/json-parse-even-better-errors/index.js
var require_json_parse_even_better_errors = __commonJS({
  "../../node_modules/.pnpm/json-parse-even-better-errors@2.3.1/node_modules/json-parse-even-better-errors/index.js"(exports2, module2) {
    "use strict";
    var hexify = /* @__PURE__ */ __name((char) => {
      const h4 = char.charCodeAt(0).toString(16).toUpperCase();
      return "0x" + (h4.length % 2 ? "0" : "") + h4;
    }, "hexify");
    var parseError = /* @__PURE__ */ __name((e3, txt, context) => {
      if (!txt) {
        return {
          message: e3.message + " while parsing empty string",
          position: 0
        };
      }
      const badToken = e3.message.match(/^Unexpected token (.) .*position\s+(\d+)/i);
      const errIdx = badToken ? +badToken[2] : e3.message.match(/^Unexpected end of JSON.*/i) ? txt.length - 1 : null;
      const msg = badToken ? e3.message.replace(/^Unexpected token ./, `Unexpected token ${JSON.stringify(badToken[1])} (${hexify(badToken[1])})`) : e3.message;
      if (errIdx !== null && errIdx !== void 0) {
        const start = errIdx <= context ? 0 : errIdx - context;
        const end = errIdx + context >= txt.length ? txt.length : errIdx + context;
        const slice = (start === 0 ? "" : "...") + txt.slice(start, end) + (end === txt.length ? "" : "...");
        const near = txt === slice ? "" : "near ";
        return {
          message: msg + ` while parsing ${near}${JSON.stringify(slice)}`,
          position: errIdx
        };
      } else {
        return {
          message: msg + ` while parsing '${txt.slice(0, context * 2)}'`,
          position: 0
        };
      }
    }, "parseError");
    var JSONParseError = class extends SyntaxError {
      constructor(er, txt, context, caller) {
        context = context || 20;
        const metadata = parseError(er, txt, context);
        super(metadata.message);
        Object.assign(this, metadata);
        this.code = "EJSONPARSE";
        this.systemError = er;
        Error.captureStackTrace(this, caller || this.constructor);
      }
      get name() {
        return this.constructor.name;
      }
      set name(n3) {
      }
      get [Symbol.toStringTag]() {
        return this.constructor.name;
      }
    };
    __name(JSONParseError, "JSONParseError");
    var kIndent = Symbol.for("indent");
    var kNewline = Symbol.for("newline");
    var formatRE = /^\s*[{\[]((?:\r?\n)+)([\s\t]*)/;
    var emptyRE = /^(?:\{\}|\[\])((?:\r?\n)+)?$/;
    var parseJson = /* @__PURE__ */ __name((txt, reviver, context) => {
      const parseText = stripBOM(txt);
      context = context || 20;
      try {
        const [, newline = "\n", indent4 = "  "] = parseText.match(emptyRE) || parseText.match(formatRE) || [, "", ""];
        const result = JSON.parse(parseText, reviver);
        if (result && typeof result === "object") {
          result[kNewline] = newline;
          result[kIndent] = indent4;
        }
        return result;
      } catch (e3) {
        if (typeof txt !== "string" && !Buffer.isBuffer(txt)) {
          const isEmptyArray = Array.isArray(txt) && txt.length === 0;
          throw Object.assign(new TypeError(
            `Cannot parse ${isEmptyArray ? "an empty array" : String(txt)}`
          ), {
            code: "EJSONPARSE",
            systemError: e3
          });
        }
        throw new JSONParseError(e3, parseText, context, parseJson);
      }
    }, "parseJson");
    var stripBOM = /* @__PURE__ */ __name((txt) => String(txt).replace(/^\uFEFF/, ""), "stripBOM");
    module2.exports = parseJson;
    parseJson.JSONParseError = JSONParseError;
    parseJson.noExceptions = (txt, reviver) => {
      try {
        return JSON.parse(stripBOM(txt), reviver);
      } catch (e3) {
      }
    };
  }
});

// ../../node_modules/.pnpm/lines-and-columns@1.2.4/node_modules/lines-and-columns/build/index.js
var require_build = __commonJS({
  "../../node_modules/.pnpm/lines-and-columns@1.2.4/node_modules/lines-and-columns/build/index.js"(exports2) {
    "use strict";
    exports2.__esModule = true;
    exports2.LinesAndColumns = void 0;
    var LF = "\n";
    var CR = "\r";
    var LinesAndColumns = function() {
      function LinesAndColumns2(string) {
        this.string = string;
        var offsets = [0];
        for (var offset = 0; offset < string.length; ) {
          switch (string[offset]) {
            case LF:
              offset += LF.length;
              offsets.push(offset);
              break;
            case CR:
              offset += CR.length;
              if (string[offset] === LF) {
                offset += LF.length;
              }
              offsets.push(offset);
              break;
            default:
              offset++;
              break;
          }
        }
        this.offsets = offsets;
      }
      __name(LinesAndColumns2, "LinesAndColumns");
      LinesAndColumns2.prototype.locationForIndex = function(index2) {
        if (index2 < 0 || index2 > this.string.length) {
          return null;
        }
        var line = 0;
        var offsets = this.offsets;
        while (offsets[line + 1] <= index2) {
          line++;
        }
        var column = index2 - offsets[line];
        return { line, column };
      };
      LinesAndColumns2.prototype.indexForLocation = function(location) {
        var line = location.line, column = location.column;
        if (line < 0 || line >= this.offsets.length) {
          return null;
        }
        if (column < 0 || column > this.lengthOfLine(line)) {
          return null;
        }
        return this.offsets[line] + column;
      };
      LinesAndColumns2.prototype.lengthOfLine = function(line) {
        var offset = this.offsets[line];
        var nextOffset = line === this.offsets.length - 1 ? this.string.length : this.offsets[line + 1];
        return nextOffset - offset;
      };
      return LinesAndColumns2;
    }();
    exports2.LinesAndColumns = LinesAndColumns;
    exports2["default"] = LinesAndColumns;
  }
});

// ../../node_modules/.pnpm/js-tokens@4.0.0/node_modules/js-tokens/index.js
var require_js_tokens = __commonJS({
  "../../node_modules/.pnpm/js-tokens@4.0.0/node_modules/js-tokens/index.js"(exports2) {
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
    exports2.matchToToken = function(match4) {
      var token = { type: "invalid", value: match4[0], closed: void 0 };
      if (match4[1])
        token.type = "string", token.closed = !!(match4[3] || match4[4]);
      else if (match4[5])
        token.type = "comment";
      else if (match4[6])
        token.type = "comment", token.closed = !!match4[7];
      else if (match4[8])
        token.type = "regex";
      else if (match4[9])
        token.type = "number";
      else if (match4[10])
        token.type = "name";
      else if (match4[11])
        token.type = "punctuator";
      else if (match4[12])
        token.type = "whitespace";
      return token;
    };
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/identifier.js
var require_identifier = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/identifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isIdentifierChar = isIdentifierChar;
    exports2.isIdentifierName = isIdentifierName;
    exports2.isIdentifierStart = isIdentifierStart;
    var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0898-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F";
    var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938, 6, 4191];
    var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    function isInAstralSet(code, set) {
      let pos = 65536;
      for (let i3 = 0, length = set.length; i3 < length; i3 += 2) {
        pos += set[i3];
        if (pos > code)
          return false;
        pos += set[i3 + 1];
        if (pos >= code)
          return true;
      }
      return false;
    }
    __name(isInAstralSet, "isInAstralSet");
    function isIdentifierStart(code) {
      if (code < 65)
        return code === 36;
      if (code <= 90)
        return true;
      if (code < 97)
        return code === 95;
      if (code <= 122)
        return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes);
    }
    __name(isIdentifierStart, "isIdentifierStart");
    function isIdentifierChar(code) {
      if (code < 48)
        return code === 36;
      if (code < 58)
        return true;
      if (code < 65)
        return false;
      if (code <= 90)
        return true;
      if (code < 97)
        return code === 95;
      if (code <= 122)
        return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
    }
    __name(isIdentifierChar, "isIdentifierChar");
    function isIdentifierName(name) {
      let isFirst = true;
      for (let i3 = 0; i3 < name.length; i3++) {
        let cp2 = name.charCodeAt(i3);
        if ((cp2 & 64512) === 55296 && i3 + 1 < name.length) {
          const trail = name.charCodeAt(++i3);
          if ((trail & 64512) === 56320) {
            cp2 = 65536 + ((cp2 & 1023) << 10) + (trail & 1023);
          }
        }
        if (isFirst) {
          isFirst = false;
          if (!isIdentifierStart(cp2)) {
            return false;
          }
        } else if (!isIdentifierChar(cp2)) {
          return false;
        }
      }
      return !isFirst;
    }
    __name(isIdentifierName, "isIdentifierName");
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/keyword.js
var require_keyword = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/keyword.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isKeyword = isKeyword;
    exports2.isReservedWord = isReservedWord;
    exports2.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
    exports2.isStrictBindReservedWord = isStrictBindReservedWord;
    exports2.isStrictReservedWord = isStrictReservedWord;
    var reservedWords = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    var keywords = new Set(reservedWords.keyword);
    var reservedWordsStrictSet = new Set(reservedWords.strict);
    var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
    function isReservedWord(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }
    __name(isReservedWord, "isReservedWord");
    function isStrictReservedWord(word, inModule) {
      return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
    }
    __name(isStrictReservedWord, "isStrictReservedWord");
    function isStrictBindOnlyReservedWord(word) {
      return reservedWordsStrictBindSet.has(word);
    }
    __name(isStrictBindOnlyReservedWord, "isStrictBindOnlyReservedWord");
    function isStrictBindReservedWord(word, inModule) {
      return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
    }
    __name(isStrictBindReservedWord, "isStrictBindReservedWord");
    function isKeyword(word) {
      return keywords.has(word);
    }
    __name(isKeyword, "isKeyword");
  }
});

// ../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/index.js
var require_lib = __commonJS({
  "../../node_modules/.pnpm/@babel+helper-validator-identifier@7.19.1/node_modules/@babel/helper-validator-identifier/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    Object.defineProperty(exports2, "isIdentifierChar", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierChar;
      }
    });
    Object.defineProperty(exports2, "isIdentifierName", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierName;
      }
    });
    Object.defineProperty(exports2, "isIdentifierStart", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierStart;
      }
    });
    Object.defineProperty(exports2, "isKeyword", {
      enumerable: true,
      get: function() {
        return _keyword.isKeyword;
      }
    });
    Object.defineProperty(exports2, "isReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindOnlyReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindOnlyReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictReservedWord;
      }
    });
    var _identifier = require_identifier();
    var _keyword = require_keyword();
  }
});

// ../../node_modules/.pnpm/escape-string-regexp@1.0.5/node_modules/escape-string-regexp/index.js
var require_escape_string_regexp = __commonJS({
  "../../node_modules/.pnpm/escape-string-regexp@1.0.5/node_modules/escape-string-regexp/index.js"(exports2, module2) {
    "use strict";
    var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
    module2.exports = function(str) {
      if (typeof str !== "string") {
        throw new TypeError("Expected a string");
      }
      return str.replace(matchOperatorsRe, "\\$&");
    };
  }
});

// ../../node_modules/.pnpm/color-name@1.1.3/node_modules/color-name/index.js
var require_color_name2 = __commonJS({
  "../../node_modules/.pnpm/color-name@1.1.3/node_modules/color-name/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/conversions.js
var require_conversions2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/conversions.js"(exports2, module2) {
    var cssKeywords = require_color_name2();
    var reverseKeywords = {};
    for (key in cssKeywords) {
      if (cssKeywords.hasOwnProperty(key)) {
        reverseKeywords[cssKeywords[key]] = key;
      }
    }
    var key;
    var convert2 = module2.exports = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    for (model in convert2) {
      if (convert2.hasOwnProperty(model)) {
        if (!("channels" in convert2[model])) {
          throw new Error("missing channels property: " + model);
        }
        if (!("labels" in convert2[model])) {
          throw new Error("missing channel labels property: " + model);
        }
        if (convert2[model].labels.length !== convert2[model].channels) {
          throw new Error("channel and label counts mismatch: " + model);
        }
        channels = convert2[model].channels;
        labels = convert2[model].labels;
        delete convert2[model].channels;
        delete convert2[model].labels;
        Object.defineProperty(convert2[model], "channels", { value: channels });
        Object.defineProperty(convert2[model], "labels", { value: labels });
      }
    }
    var channels;
    var labels;
    var model;
    convert2.rgb.hsl = function(rgb) {
      var r3 = rgb[0] / 255;
      var g3 = rgb[1] / 255;
      var b3 = rgb[2] / 255;
      var min = Math.min(r3, g3, b3);
      var max = Math.max(r3, g3, b3);
      var delta = max - min;
      var h4;
      var s4;
      var l3;
      if (max === min) {
        h4 = 0;
      } else if (r3 === max) {
        h4 = (g3 - b3) / delta;
      } else if (g3 === max) {
        h4 = 2 + (b3 - r3) / delta;
      } else if (b3 === max) {
        h4 = 4 + (r3 - g3) / delta;
      }
      h4 = Math.min(h4 * 60, 360);
      if (h4 < 0) {
        h4 += 360;
      }
      l3 = (min + max) / 2;
      if (max === min) {
        s4 = 0;
      } else if (l3 <= 0.5) {
        s4 = delta / (max + min);
      } else {
        s4 = delta / (2 - max - min);
      }
      return [h4, s4 * 100, l3 * 100];
    };
    convert2.rgb.hsv = function(rgb) {
      var rdif;
      var gdif;
      var bdif;
      var h4;
      var s4;
      var r3 = rgb[0] / 255;
      var g3 = rgb[1] / 255;
      var b3 = rgb[2] / 255;
      var v3 = Math.max(r3, g3, b3);
      var diff = v3 - Math.min(r3, g3, b3);
      var diffc = /* @__PURE__ */ __name(function(c3) {
        return (v3 - c3) / 6 / diff + 1 / 2;
      }, "diffc");
      if (diff === 0) {
        h4 = s4 = 0;
      } else {
        s4 = diff / v3;
        rdif = diffc(r3);
        gdif = diffc(g3);
        bdif = diffc(b3);
        if (r3 === v3) {
          h4 = bdif - gdif;
        } else if (g3 === v3) {
          h4 = 1 / 3 + rdif - bdif;
        } else if (b3 === v3) {
          h4 = 2 / 3 + gdif - rdif;
        }
        if (h4 < 0) {
          h4 += 1;
        } else if (h4 > 1) {
          h4 -= 1;
        }
      }
      return [
        h4 * 360,
        s4 * 100,
        v3 * 100
      ];
    };
    convert2.rgb.hwb = function(rgb) {
      var r3 = rgb[0];
      var g3 = rgb[1];
      var b3 = rgb[2];
      var h4 = convert2.rgb.hsl(rgb)[0];
      var w4 = 1 / 255 * Math.min(r3, Math.min(g3, b3));
      b3 = 1 - 1 / 255 * Math.max(r3, Math.max(g3, b3));
      return [h4, w4 * 100, b3 * 100];
    };
    convert2.rgb.cmyk = function(rgb) {
      var r3 = rgb[0] / 255;
      var g3 = rgb[1] / 255;
      var b3 = rgb[2] / 255;
      var c3;
      var m4;
      var y4;
      var k;
      k = Math.min(1 - r3, 1 - g3, 1 - b3);
      c3 = (1 - r3 - k) / (1 - k) || 0;
      m4 = (1 - g3 - k) / (1 - k) || 0;
      y4 = (1 - b3 - k) / (1 - k) || 0;
      return [c3 * 100, m4 * 100, y4 * 100, k * 100];
    };
    function comparativeDistance(x, y4) {
      return Math.pow(x[0] - y4[0], 2) + Math.pow(x[1] - y4[1], 2) + Math.pow(x[2] - y4[2], 2);
    }
    __name(comparativeDistance, "comparativeDistance");
    convert2.rgb.keyword = function(rgb) {
      var reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      var currentClosestDistance = Infinity;
      var currentClosestKeyword;
      for (var keyword in cssKeywords) {
        if (cssKeywords.hasOwnProperty(keyword)) {
          var value = cssKeywords[keyword];
          var distance = comparativeDistance(rgb, value);
          if (distance < currentClosestDistance) {
            currentClosestDistance = distance;
            currentClosestKeyword = keyword;
          }
        }
      }
      return currentClosestKeyword;
    };
    convert2.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert2.rgb.xyz = function(rgb) {
      var r3 = rgb[0] / 255;
      var g3 = rgb[1] / 255;
      var b3 = rgb[2] / 255;
      r3 = r3 > 0.04045 ? Math.pow((r3 + 0.055) / 1.055, 2.4) : r3 / 12.92;
      g3 = g3 > 0.04045 ? Math.pow((g3 + 0.055) / 1.055, 2.4) : g3 / 12.92;
      b3 = b3 > 0.04045 ? Math.pow((b3 + 0.055) / 1.055, 2.4) : b3 / 12.92;
      var x = r3 * 0.4124 + g3 * 0.3576 + b3 * 0.1805;
      var y4 = r3 * 0.2126 + g3 * 0.7152 + b3 * 0.0722;
      var z = r3 * 0.0193 + g3 * 0.1192 + b3 * 0.9505;
      return [x * 100, y4 * 100, z * 100];
    };
    convert2.rgb.lab = function(rgb) {
      var xyz = convert2.rgb.xyz(rgb);
      var x = xyz[0];
      var y4 = xyz[1];
      var z = xyz[2];
      var l3;
      var a3;
      var b3;
      x /= 95.047;
      y4 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y4 = y4 > 8856e-6 ? Math.pow(y4, 1 / 3) : 7.787 * y4 + 16 / 116;
      z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l3 = 116 * y4 - 16;
      a3 = 500 * (x - y4);
      b3 = 200 * (y4 - z);
      return [l3, a3, b3];
    };
    convert2.hsl.rgb = function(hsl) {
      var h4 = hsl[0] / 360;
      var s4 = hsl[1] / 100;
      var l3 = hsl[2] / 100;
      var t1;
      var t22;
      var t32;
      var rgb;
      var val;
      if (s4 === 0) {
        val = l3 * 255;
        return [val, val, val];
      }
      if (l3 < 0.5) {
        t22 = l3 * (1 + s4);
      } else {
        t22 = l3 + s4 - l3 * s4;
      }
      t1 = 2 * l3 - t22;
      rgb = [0, 0, 0];
      for (var i3 = 0; i3 < 3; i3++) {
        t32 = h4 + 1 / 3 * -(i3 - 1);
        if (t32 < 0) {
          t32++;
        }
        if (t32 > 1) {
          t32--;
        }
        if (6 * t32 < 1) {
          val = t1 + (t22 - t1) * 6 * t32;
        } else if (2 * t32 < 1) {
          val = t22;
        } else if (3 * t32 < 2) {
          val = t1 + (t22 - t1) * (2 / 3 - t32) * 6;
        } else {
          val = t1;
        }
        rgb[i3] = val * 255;
      }
      return rgb;
    };
    convert2.hsl.hsv = function(hsl) {
      var h4 = hsl[0];
      var s4 = hsl[1] / 100;
      var l3 = hsl[2] / 100;
      var smin = s4;
      var lmin = Math.max(l3, 0.01);
      var sv;
      var v3;
      l3 *= 2;
      s4 *= l3 <= 1 ? l3 : 2 - l3;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      v3 = (l3 + s4) / 2;
      sv = l3 === 0 ? 2 * smin / (lmin + smin) : 2 * s4 / (l3 + s4);
      return [h4, sv * 100, v3 * 100];
    };
    convert2.hsv.rgb = function(hsv) {
      var h4 = hsv[0] / 60;
      var s4 = hsv[1] / 100;
      var v3 = hsv[2] / 100;
      var hi = Math.floor(h4) % 6;
      var f3 = h4 - Math.floor(h4);
      var p3 = 255 * v3 * (1 - s4);
      var q = 255 * v3 * (1 - s4 * f3);
      var t5 = 255 * v3 * (1 - s4 * (1 - f3));
      v3 *= 255;
      switch (hi) {
        case 0:
          return [v3, t5, p3];
        case 1:
          return [q, v3, p3];
        case 2:
          return [p3, v3, t5];
        case 3:
          return [p3, q, v3];
        case 4:
          return [t5, p3, v3];
        case 5:
          return [v3, p3, q];
      }
    };
    convert2.hsv.hsl = function(hsv) {
      var h4 = hsv[0];
      var s4 = hsv[1] / 100;
      var v3 = hsv[2] / 100;
      var vmin = Math.max(v3, 0.01);
      var lmin;
      var sl;
      var l3;
      l3 = (2 - s4) * v3;
      lmin = (2 - s4) * vmin;
      sl = s4 * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l3 /= 2;
      return [h4, sl * 100, l3 * 100];
    };
    convert2.hwb.rgb = function(hwb) {
      var h4 = hwb[0] / 360;
      var wh = hwb[1] / 100;
      var bl = hwb[2] / 100;
      var ratio = wh + bl;
      var i3;
      var v3;
      var f3;
      var n3;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      i3 = Math.floor(6 * h4);
      v3 = 1 - bl;
      f3 = 6 * h4 - i3;
      if ((i3 & 1) !== 0) {
        f3 = 1 - f3;
      }
      n3 = wh + f3 * (v3 - wh);
      var r3;
      var g3;
      var b3;
      switch (i3) {
        default:
        case 6:
        case 0:
          r3 = v3;
          g3 = n3;
          b3 = wh;
          break;
        case 1:
          r3 = n3;
          g3 = v3;
          b3 = wh;
          break;
        case 2:
          r3 = wh;
          g3 = v3;
          b3 = n3;
          break;
        case 3:
          r3 = wh;
          g3 = n3;
          b3 = v3;
          break;
        case 4:
          r3 = n3;
          g3 = wh;
          b3 = v3;
          break;
        case 5:
          r3 = v3;
          g3 = wh;
          b3 = n3;
          break;
      }
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.cmyk.rgb = function(cmyk) {
      var c3 = cmyk[0] / 100;
      var m4 = cmyk[1] / 100;
      var y4 = cmyk[2] / 100;
      var k = cmyk[3] / 100;
      var r3;
      var g3;
      var b3;
      r3 = 1 - Math.min(1, c3 * (1 - k) + k);
      g3 = 1 - Math.min(1, m4 * (1 - k) + k);
      b3 = 1 - Math.min(1, y4 * (1 - k) + k);
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.xyz.rgb = function(xyz) {
      var x = xyz[0] / 100;
      var y4 = xyz[1] / 100;
      var z = xyz[2] / 100;
      var r3;
      var g3;
      var b3;
      r3 = x * 3.2406 + y4 * -1.5372 + z * -0.4986;
      g3 = x * -0.9689 + y4 * 1.8758 + z * 0.0415;
      b3 = x * 0.0557 + y4 * -0.204 + z * 1.057;
      r3 = r3 > 31308e-7 ? 1.055 * Math.pow(r3, 1 / 2.4) - 0.055 : r3 * 12.92;
      g3 = g3 > 31308e-7 ? 1.055 * Math.pow(g3, 1 / 2.4) - 0.055 : g3 * 12.92;
      b3 = b3 > 31308e-7 ? 1.055 * Math.pow(b3, 1 / 2.4) - 0.055 : b3 * 12.92;
      r3 = Math.min(Math.max(0, r3), 1);
      g3 = Math.min(Math.max(0, g3), 1);
      b3 = Math.min(Math.max(0, b3), 1);
      return [r3 * 255, g3 * 255, b3 * 255];
    };
    convert2.xyz.lab = function(xyz) {
      var x = xyz[0];
      var y4 = xyz[1];
      var z = xyz[2];
      var l3;
      var a3;
      var b3;
      x /= 95.047;
      y4 /= 100;
      z /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y4 = y4 > 8856e-6 ? Math.pow(y4, 1 / 3) : 7.787 * y4 + 16 / 116;
      z = z > 8856e-6 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
      l3 = 116 * y4 - 16;
      a3 = 500 * (x - y4);
      b3 = 200 * (y4 - z);
      return [l3, a3, b3];
    };
    convert2.lab.xyz = function(lab) {
      var l3 = lab[0];
      var a3 = lab[1];
      var b3 = lab[2];
      var x;
      var y4;
      var z;
      y4 = (l3 + 16) / 116;
      x = a3 / 500 + y4;
      z = y4 - b3 / 200;
      var y22 = Math.pow(y4, 3);
      var x2 = Math.pow(x, 3);
      var z2 = Math.pow(z, 3);
      y4 = y22 > 8856e-6 ? y22 : (y4 - 16 / 116) / 7.787;
      x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
      z = z2 > 8856e-6 ? z2 : (z - 16 / 116) / 7.787;
      x *= 95.047;
      y4 *= 100;
      z *= 108.883;
      return [x, y4, z];
    };
    convert2.lab.lch = function(lab) {
      var l3 = lab[0];
      var a3 = lab[1];
      var b3 = lab[2];
      var hr;
      var h4;
      var c3;
      hr = Math.atan2(b3, a3);
      h4 = hr * 360 / 2 / Math.PI;
      if (h4 < 0) {
        h4 += 360;
      }
      c3 = Math.sqrt(a3 * a3 + b3 * b3);
      return [l3, c3, h4];
    };
    convert2.lch.lab = function(lch) {
      var l3 = lch[0];
      var c3 = lch[1];
      var h4 = lch[2];
      var a3;
      var b3;
      var hr;
      hr = h4 / 360 * 2 * Math.PI;
      a3 = c3 * Math.cos(hr);
      b3 = c3 * Math.sin(hr);
      return [l3, a3, b3];
    };
    convert2.rgb.ansi16 = function(args3) {
      var r3 = args3[0];
      var g3 = args3[1];
      var b3 = args3[2];
      var value = 1 in arguments ? arguments[1] : convert2.rgb.hsv(args3)[2];
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      var ansi = 30 + (Math.round(b3 / 255) << 2 | Math.round(g3 / 255) << 1 | Math.round(r3 / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert2.hsv.ansi16 = function(args3) {
      return convert2.rgb.ansi16(convert2.hsv.rgb(args3), args3[2]);
    };
    convert2.rgb.ansi256 = function(args3) {
      var r3 = args3[0];
      var g3 = args3[1];
      var b3 = args3[2];
      if (r3 === g3 && g3 === b3) {
        if (r3 < 8) {
          return 16;
        }
        if (r3 > 248) {
          return 231;
        }
        return Math.round((r3 - 8) / 247 * 24) + 232;
      }
      var ansi = 16 + 36 * Math.round(r3 / 255 * 5) + 6 * Math.round(g3 / 255 * 5) + Math.round(b3 / 255 * 5);
      return ansi;
    };
    convert2.ansi16.rgb = function(args3) {
      var color = args3 % 10;
      if (color === 0 || color === 7) {
        if (args3 > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      var mult = (~~(args3 > 50) + 1) * 0.5;
      var r3 = (color & 1) * mult * 255;
      var g3 = (color >> 1 & 1) * mult * 255;
      var b3 = (color >> 2 & 1) * mult * 255;
      return [r3, g3, b3];
    };
    convert2.ansi256.rgb = function(args3) {
      if (args3 >= 232) {
        var c3 = (args3 - 232) * 10 + 8;
        return [c3, c3, c3];
      }
      args3 -= 16;
      var rem;
      var r3 = Math.floor(args3 / 36) / 5 * 255;
      var g3 = Math.floor((rem = args3 % 36) / 6) / 5 * 255;
      var b3 = rem % 6 / 5 * 255;
      return [r3, g3, b3];
    };
    convert2.rgb.hex = function(args3) {
      var integer = ((Math.round(args3[0]) & 255) << 16) + ((Math.round(args3[1]) & 255) << 8) + (Math.round(args3[2]) & 255);
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.hex.rgb = function(args3) {
      var match4 = args3.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match4) {
        return [0, 0, 0];
      }
      var colorString = match4[0];
      if (match4[0].length === 3) {
        colorString = colorString.split("").map(function(char) {
          return char + char;
        }).join("");
      }
      var integer = parseInt(colorString, 16);
      var r3 = integer >> 16 & 255;
      var g3 = integer >> 8 & 255;
      var b3 = integer & 255;
      return [r3, g3, b3];
    };
    convert2.rgb.hcg = function(rgb) {
      var r3 = rgb[0] / 255;
      var g3 = rgb[1] / 255;
      var b3 = rgb[2] / 255;
      var max = Math.max(Math.max(r3, g3), b3);
      var min = Math.min(Math.min(r3, g3), b3);
      var chroma = max - min;
      var grayscale;
      var hue;
      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max === r3) {
        hue = (g3 - b3) / chroma % 6;
      } else if (max === g3) {
        hue = 2 + (b3 - r3) / chroma;
      } else {
        hue = 4 + (r3 - g3) / chroma + 4;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert2.hsl.hcg = function(hsl) {
      var s4 = hsl[1] / 100;
      var l3 = hsl[2] / 100;
      var c3 = 1;
      var f3 = 0;
      if (l3 < 0.5) {
        c3 = 2 * s4 * l3;
      } else {
        c3 = 2 * s4 * (1 - l3);
      }
      if (c3 < 1) {
        f3 = (l3 - 0.5 * c3) / (1 - c3);
      }
      return [hsl[0], c3 * 100, f3 * 100];
    };
    convert2.hsv.hcg = function(hsv) {
      var s4 = hsv[1] / 100;
      var v3 = hsv[2] / 100;
      var c3 = s4 * v3;
      var f3 = 0;
      if (c3 < 1) {
        f3 = (v3 - c3) / (1 - c3);
      }
      return [hsv[0], c3 * 100, f3 * 100];
    };
    convert2.hcg.rgb = function(hcg) {
      var h4 = hcg[0] / 360;
      var c3 = hcg[1] / 100;
      var g3 = hcg[2] / 100;
      if (c3 === 0) {
        return [g3 * 255, g3 * 255, g3 * 255];
      }
      var pure = [0, 0, 0];
      var hi = h4 % 1 * 6;
      var v3 = hi % 1;
      var w4 = 1 - v3;
      var mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v3;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w4;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v3;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w4;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v3;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w4;
      }
      mg = (1 - c3) * g3;
      return [
        (c3 * pure[0] + mg) * 255,
        (c3 * pure[1] + mg) * 255,
        (c3 * pure[2] + mg) * 255
      ];
    };
    convert2.hcg.hsv = function(hcg) {
      var c3 = hcg[1] / 100;
      var g3 = hcg[2] / 100;
      var v3 = c3 + g3 * (1 - c3);
      var f3 = 0;
      if (v3 > 0) {
        f3 = c3 / v3;
      }
      return [hcg[0], f3 * 100, v3 * 100];
    };
    convert2.hcg.hsl = function(hcg) {
      var c3 = hcg[1] / 100;
      var g3 = hcg[2] / 100;
      var l3 = g3 * (1 - c3) + 0.5 * c3;
      var s4 = 0;
      if (l3 > 0 && l3 < 0.5) {
        s4 = c3 / (2 * l3);
      } else if (l3 >= 0.5 && l3 < 1) {
        s4 = c3 / (2 * (1 - l3));
      }
      return [hcg[0], s4 * 100, l3 * 100];
    };
    convert2.hcg.hwb = function(hcg) {
      var c3 = hcg[1] / 100;
      var g3 = hcg[2] / 100;
      var v3 = c3 + g3 * (1 - c3);
      return [hcg[0], (v3 - c3) * 100, (1 - v3) * 100];
    };
    convert2.hwb.hcg = function(hwb) {
      var w4 = hwb[1] / 100;
      var b3 = hwb[2] / 100;
      var v3 = 1 - b3;
      var c3 = v3 - w4;
      var g3 = 0;
      if (c3 < 1) {
        g3 = (v3 - c3) / (1 - c3);
      }
      return [hwb[0], c3 * 100, g3 * 100];
    };
    convert2.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert2.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert2.gray.rgb = function(args3) {
      return [args3[0] / 100 * 255, args3[0] / 100 * 255, args3[0] / 100 * 255];
    };
    convert2.gray.hsl = convert2.gray.hsv = function(args3) {
      return [0, 0, args3[0]];
    };
    convert2.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert2.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert2.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert2.gray.hex = function(gray) {
      var val = Math.round(gray[0] / 100 * 255) & 255;
      var integer = (val << 16) + (val << 8) + val;
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert2.rgb.gray = function(rgb) {
      var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/route.js
var require_route2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/route.js"(exports2, module2) {
    var conversions = require_conversions2();
    function buildGraph() {
      var graph = {};
      var models = Object.keys(conversions);
      for (var len = models.length, i3 = 0; i3 < len; i3++) {
        graph[models[i3]] = {
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    __name(buildGraph, "buildGraph");
    function deriveBFS(fromModel) {
      var graph = buildGraph();
      var queue2 = [fromModel];
      graph[fromModel].distance = 0;
      while (queue2.length) {
        var current = queue2.pop();
        var adjacents = Object.keys(conversions[current]);
        for (var len = adjacents.length, i3 = 0; i3 < len; i3++) {
          var adjacent = adjacents[i3];
          var node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue2.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    __name(deriveBFS, "deriveBFS");
    function link3(from, to) {
      return function(args3) {
        return to(from(args3));
      };
    }
    __name(link3, "link");
    function wrapConversion(toModel, graph) {
      var path32 = [graph[toModel].parent, toModel];
      var fn2 = conversions[graph[toModel].parent][toModel];
      var cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path32.unshift(graph[cur].parent);
        fn2 = link3(conversions[graph[cur].parent][cur], fn2);
        cur = graph[cur].parent;
      }
      fn2.conversion = path32;
      return fn2;
    }
    __name(wrapConversion, "wrapConversion");
    module2.exports = function(fromModel) {
      var graph = deriveBFS(fromModel);
      var conversion = {};
      var models = Object.keys(graph);
      for (var len = models.length, i3 = 0; i3 < len; i3++) {
        var toModel = models[i3];
        var node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/index.js
var require_color_convert2 = __commonJS({
  "../../node_modules/.pnpm/color-convert@1.9.3/node_modules/color-convert/index.js"(exports2, module2) {
    var conversions = require_conversions2();
    var route = require_route2();
    var convert2 = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn2) {
      var wrappedFn = /* @__PURE__ */ __name(function(args3) {
        if (args3 === void 0 || args3 === null) {
          return args3;
        }
        if (arguments.length > 1) {
          args3 = Array.prototype.slice.call(arguments);
        }
        return fn2(args3);
      }, "wrappedFn");
      if ("conversion" in fn2) {
        wrappedFn.conversion = fn2.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRaw, "wrapRaw");
    function wrapRounded(fn2) {
      var wrappedFn = /* @__PURE__ */ __name(function(args3) {
        if (args3 === void 0 || args3 === null) {
          return args3;
        }
        if (arguments.length > 1) {
          args3 = Array.prototype.slice.call(arguments);
        }
        var result = fn2(args3);
        if (typeof result === "object") {
          for (var len = result.length, i3 = 0; i3 < len; i3++) {
            result[i3] = Math.round(result[i3]);
          }
        }
        return result;
      }, "wrappedFn");
      if ("conversion" in fn2) {
        wrappedFn.conversion = fn2.conversion;
      }
      return wrappedFn;
    }
    __name(wrapRounded, "wrapRounded");
    models.forEach(function(fromModel) {
      convert2[fromModel] = {};
      Object.defineProperty(convert2[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert2[fromModel], "labels", { value: conversions[fromModel].labels });
      var routes = route(fromModel);
      var routeModels = Object.keys(routes);
      routeModels.forEach(function(toModel) {
        var fn2 = routes[toModel];
        convert2[fromModel][toModel] = wrapRounded(fn2);
        convert2[fromModel][toModel].raw = wrapRaw(fn2);
      });
    });
    module2.exports = convert2;
  }
});

// ../../node_modules/.pnpm/ansi-styles@3.2.1/node_modules/ansi-styles/index.js
var require_ansi_styles2 = __commonJS({
  "../../node_modules/.pnpm/ansi-styles@3.2.1/node_modules/ansi-styles/index.js"(exports2, module2) {
    "use strict";
    var colorConvert = require_color_convert2();
    var wrapAnsi16 = /* @__PURE__ */ __name((fn2, offset) => function() {
      const code = fn2.apply(colorConvert, arguments);
      return `\x1B[${code + offset}m`;
    }, "wrapAnsi16");
    var wrapAnsi256 = /* @__PURE__ */ __name((fn2, offset) => function() {
      const code = fn2.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};5;${code}m`;
    }, "wrapAnsi256");
    var wrapAnsi16m = /* @__PURE__ */ __name((fn2, offset) => function() {
      const rgb = fn2.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    }, "wrapAnsi16m");
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.grey = styles.color.gray;
      for (const groupName of Object.keys(styles)) {
        const group = styles[groupName];
        for (const styleName of Object.keys(group)) {
          const style = group[styleName];
          styles[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
        Object.defineProperty(styles, "codes", {
          value: codes,
          enumerable: false
        });
      }
      const ansi2ansi = /* @__PURE__ */ __name((n3) => n3, "ansi2ansi");
      const rgb2rgb = /* @__PURE__ */ __name((r3, g3, b3) => [r3, g3, b3], "rgb2rgb");
      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      styles.color.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 0)
      };
      styles.color.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 0)
      };
      styles.color.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 0)
      };
      styles.bgColor.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 10)
      };
      styles.bgColor.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 10)
      };
      styles.bgColor.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 10)
      };
      for (let key of Object.keys(colorConvert)) {
        if (typeof colorConvert[key] !== "object") {
          continue;
        }
        const suite = colorConvert[key];
        if (key === "ansi16") {
          key = "ansi";
        }
        if ("ansi16" in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }
        if ("ansi256" in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }
        if ("rgb" in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }
      return styles;
    }
    __name(assembleStyles, "assembleStyles");
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../../node_modules/.pnpm/has-flag@3.0.0/node_modules/has-flag/index.js
var require_has_flag2 = __commonJS({
  "../../node_modules/.pnpm/has-flag@3.0.0/node_modules/has-flag/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (flag, argv) => {
      argv = argv || process.argv;
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const pos = argv.indexOf(prefix + flag);
      const terminatorPos = argv.indexOf("--");
      return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
    };
  }
});

// ../../node_modules/.pnpm/supports-color@5.5.0/node_modules/supports-color/index.js
var require_supports_color2 = __commonJS({
  "../../node_modules/.pnpm/supports-color@5.5.0/node_modules/supports-color/index.js"(exports2, module2) {
    "use strict";
    var os6 = require("os");
    var hasFlag = require_has_flag2();
    var env2 = process.env;
    var forceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
      forceColor = false;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = true;
    }
    if ("FORCE_COLOR" in env2) {
      forceColor = env2.FORCE_COLOR.length === 0 || parseInt(env2.FORCE_COLOR, 10) !== 0;
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    __name(translateLevel, "translateLevel");
    function supportsColor(stream3) {
      if (forceColor === false) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (stream3 && !stream3.isTTY && forceColor !== true) {
        return 0;
      }
      const min = forceColor ? 1 : 0;
      if (process.platform === "win32") {
        const osRelease = os6.release().split(".");
        if (Number(process.versions.node.split(".")[0]) >= 8 && Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env2) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some((sign) => sign in env2) || env2.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env2) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env2.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env2.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env2) {
        const version3 = parseInt((env2.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env2.TERM_PROGRAM) {
          case "iTerm.app":
            return version3 >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env2.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env2.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env2) {
        return 1;
      }
      if (env2.TERM === "dumb") {
        return min;
      }
      return min;
    }
    __name(supportsColor, "supportsColor");
    function getSupportLevel(stream3) {
      const level = supportsColor(stream3);
      return translateLevel(level);
    }
    __name(getSupportLevel, "getSupportLevel");
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: getSupportLevel(process.stdout),
      stderr: getSupportLevel(process.stderr)
    };
  }
});

// ../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/templates.js
var require_templates2 = __commonJS({
  "../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/templates.js"(exports2, module2) {
    "use strict";
    var TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
    var STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
    var STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
    var ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
    var ESCAPES = /* @__PURE__ */ new Map([
      ["n", "\n"],
      ["r", "\r"],
      ["t", "	"],
      ["b", "\b"],
      ["f", "\f"],
      ["v", "\v"],
      ["0", "\0"],
      ["\\", "\\"],
      ["e", "\x1B"],
      ["a", "\x07"]
    ]);
    function unescape2(c3) {
      if (c3[0] === "u" && c3.length === 5 || c3[0] === "x" && c3.length === 3) {
        return String.fromCharCode(parseInt(c3.slice(1), 16));
      }
      return ESCAPES.get(c3) || c3;
    }
    __name(unescape2, "unescape");
    function parseArguments(name, args3) {
      const results = [];
      const chunks = args3.trim().split(/\s*,\s*/g);
      let matches;
      for (const chunk of chunks) {
        if (!isNaN(chunk)) {
          results.push(Number(chunk));
        } else if (matches = chunk.match(STRING_REGEX)) {
          results.push(matches[2].replace(ESCAPE_REGEX, (m4, escape2, chr) => escape2 ? unescape2(escape2) : chr));
        } else {
          throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
        }
      }
      return results;
    }
    __name(parseArguments, "parseArguments");
    function parseStyle(style) {
      STYLE_REGEX.lastIndex = 0;
      const results = [];
      let matches;
      while ((matches = STYLE_REGEX.exec(style)) !== null) {
        const name = matches[1];
        if (matches[2]) {
          const args3 = parseArguments(name, matches[2]);
          results.push([name].concat(args3));
        } else {
          results.push([name]);
        }
      }
      return results;
    }
    __name(parseStyle, "parseStyle");
    function buildStyle(chalk63, styles) {
      const enabled = {};
      for (const layer of styles) {
        for (const style of layer.styles) {
          enabled[style[0]] = layer.inverse ? null : style.slice(1);
        }
      }
      let current = chalk63;
      for (const styleName of Object.keys(enabled)) {
        if (Array.isArray(enabled[styleName])) {
          if (!(styleName in current)) {
            throw new Error(`Unknown Chalk style: ${styleName}`);
          }
          if (enabled[styleName].length > 0) {
            current = current[styleName].apply(current, enabled[styleName]);
          } else {
            current = current[styleName];
          }
        }
      }
      return current;
    }
    __name(buildStyle, "buildStyle");
    module2.exports = (chalk63, tmp2) => {
      const styles = [];
      const chunks = [];
      let chunk = [];
      tmp2.replace(TEMPLATE_REGEX, (m4, escapeChar, inverse, style, close2, chr) => {
        if (escapeChar) {
          chunk.push(unescape2(escapeChar));
        } else if (style) {
          const str = chunk.join("");
          chunk = [];
          chunks.push(styles.length === 0 ? str : buildStyle(chalk63, styles)(str));
          styles.push({ inverse, styles: parseStyle(style) });
        } else if (close2) {
          if (styles.length === 0) {
            throw new Error("Found extraneous } in Chalk template literal");
          }
          chunks.push(buildStyle(chalk63, styles)(chunk.join("")));
          chunk = [];
          styles.pop();
        } else {
          chunk.push(chr);
        }
      });
      chunks.push(chunk.join(""));
      if (styles.length > 0) {
        const errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
        throw new Error(errMsg);
      }
      return chunks.join("");
    };
  }
});

// ../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/index.js
var require_chalk = __commonJS({
  "../../node_modules/.pnpm/chalk@2.4.2/node_modules/chalk/index.js"(exports2, module2) {
    "use strict";
    var escapeStringRegexp = require_escape_string_regexp();
    var ansiStyles = require_ansi_styles2();
    var stdoutColor = require_supports_color2().stdout;
    var template = require_templates2();
    var isSimpleWindowsTerm = process.platform === "win32" && !(process.env.TERM || "").toLowerCase().startsWith("xterm");
    var levelMapping = ["ansi", "ansi", "ansi256", "ansi16m"];
    var skipModels = /* @__PURE__ */ new Set(["gray"]);
    var styles = /* @__PURE__ */ Object.create(null);
    function applyOptions(obj, options2) {
      options2 = options2 || {};
      const scLevel = stdoutColor ? stdoutColor.level : 0;
      obj.level = options2.level === void 0 ? scLevel : options2.level;
      obj.enabled = "enabled" in options2 ? options2.enabled : obj.level > 0;
    }
    __name(applyOptions, "applyOptions");
    function Chalk(options2) {
      if (!this || !(this instanceof Chalk) || this.template) {
        const chalk63 = {};
        applyOptions(chalk63, options2);
        chalk63.template = function() {
          const args3 = [].slice.call(arguments);
          return chalkTag.apply(null, [chalk63.template].concat(args3));
        };
        Object.setPrototypeOf(chalk63, Chalk.prototype);
        Object.setPrototypeOf(chalk63.template, chalk63);
        chalk63.template.constructor = Chalk;
        return chalk63.template;
      }
      applyOptions(this, options2);
    }
    __name(Chalk, "Chalk");
    if (isSimpleWindowsTerm) {
      ansiStyles.blue.open = "\x1B[94m";
    }
    for (const key of Object.keys(ansiStyles)) {
      ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), "g");
      styles[key] = {
        get() {
          const codes = ansiStyles[key];
          return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
        }
      };
    }
    styles.visible = {
      get() {
        return build.call(this, this._styles || [], true, "visible");
      }
    };
    ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), "g");
    for (const model of Object.keys(ansiStyles.color.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      styles[model] = {
        get() {
          const level = this.level;
          return function() {
            const open4 = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
            const codes = {
              open: open4,
              close: ansiStyles.color.close,
              closeRe: ansiStyles.color.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    }
    ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), "g");
    for (const model of Object.keys(ansiStyles.bgColor.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get() {
          const level = this.level;
          return function() {
            const open4 = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
            const codes = {
              open: open4,
              close: ansiStyles.bgColor.close,
              closeRe: ansiStyles.bgColor.closeRe
            };
            return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
          };
        }
      };
    }
    var proto = Object.defineProperties(() => {
    }, styles);
    function build(_styles, _empty, key) {
      const builder = /* @__PURE__ */ __name(function() {
        return applyStyle.apply(builder, arguments);
      }, "builder");
      builder._styles = _styles;
      builder._empty = _empty;
      const self2 = this;
      Object.defineProperty(builder, "level", {
        enumerable: true,
        get() {
          return self2.level;
        },
        set(level) {
          self2.level = level;
        }
      });
      Object.defineProperty(builder, "enabled", {
        enumerable: true,
        get() {
          return self2.enabled;
        },
        set(enabled) {
          self2.enabled = enabled;
        }
      });
      builder.hasGrey = this.hasGrey || key === "gray" || key === "grey";
      builder.__proto__ = proto;
      return builder;
    }
    __name(build, "build");
    function applyStyle() {
      const args3 = arguments;
      const argsLen = args3.length;
      let str = String(arguments[0]);
      if (argsLen === 0) {
        return "";
      }
      if (argsLen > 1) {
        for (let a3 = 1; a3 < argsLen; a3++) {
          str += " " + args3[a3];
        }
      }
      if (!this.enabled || this.level <= 0 || !str) {
        return this._empty ? "" : str;
      }
      const originalDim = ansiStyles.dim.open;
      if (isSimpleWindowsTerm && this.hasGrey) {
        ansiStyles.dim.open = "";
      }
      for (const code of this._styles.slice().reverse()) {
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
      }
      ansiStyles.dim.open = originalDim;
      return str;
    }
    __name(applyStyle, "applyStyle");
    function chalkTag(chalk63, strings) {
      if (!Array.isArray(strings)) {
        return [].slice.call(arguments, 1).join(" ");
      }
      const args3 = [].slice.call(arguments, 2);
      const parts = [strings.raw[0]];
      for (let i3 = 1; i3 < strings.length; i3++) {
        parts.push(String(args3[i3 - 1]).replace(/[{}\\]/g, "\\$&"));
        parts.push(String(strings.raw[i3]));
      }
      return template(chalk63, parts.join(""));
    }
    __name(chalkTag, "chalkTag");
    Object.defineProperties(Chalk.prototype, styles);
    module2.exports = Chalk();
    module2.exports.supportsColor = stdoutColor;
    module2.exports.default = module2.exports;
  }
});

// ../../node_modules/.pnpm/@babel+highlight@7.18.6/node_modules/@babel/highlight/lib/index.js
var require_lib2 = __commonJS({
  "../../node_modules/.pnpm/@babel+highlight@7.18.6/node_modules/@babel/highlight/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = highlight2;
    exports2.getChalk = getChalk;
    exports2.shouldHighlight = shouldHighlight;
    var _jsTokens = require_js_tokens();
    var _helperValidatorIdentifier = require_lib();
    var _chalk = require_chalk();
    var sometimesKeywords = /* @__PURE__ */ new Set(["as", "async", "from", "get", "of", "set"]);
    function getDefs(chalk63) {
      return {
        keyword: chalk63.cyan,
        capitalized: chalk63.yellow,
        jsxIdentifier: chalk63.yellow,
        punctuator: chalk63.yellow,
        number: chalk63.magenta,
        string: chalk63.green,
        regex: chalk63.magenta,
        comment: chalk63.grey,
        invalid: chalk63.white.bgRed.bold
      };
    }
    __name(getDefs, "getDefs");
    var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
    var BRACKET = /^[()[\]{}]$/;
    var tokenize;
    {
      const JSX_TAG = /^[a-z][\w-]*$/i;
      const getTokenType = /* @__PURE__ */ __name(function(token, offset, text) {
        if (token.type === "name") {
          if ((0, _helperValidatorIdentifier.isKeyword)(token.value) || (0, _helperValidatorIdentifier.isStrictReservedWord)(token.value, true) || sometimesKeywords.has(token.value)) {
            return "keyword";
          }
          if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.slice(offset - 2, offset) == "</")) {
            return "jsxIdentifier";
          }
          if (token.value[0] !== token.value[0].toLowerCase()) {
            return "capitalized";
          }
        }
        if (token.type === "punctuator" && BRACKET.test(token.value)) {
          return "bracket";
        }
        if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
          return "punctuator";
        }
        return token.type;
      }, "getTokenType");
      tokenize = /* @__PURE__ */ __name(function* (text) {
        let match4;
        while (match4 = _jsTokens.default.exec(text)) {
          const token = _jsTokens.matchToToken(match4);
          yield {
            type: getTokenType(token, match4.index, text),
            value: token.value
          };
        }
      }, "tokenize");
    }
    function highlightTokens(defs, text) {
      let highlighted = "";
      for (const {
        type,
        value
      } of tokenize(text)) {
        const colorize = defs[type];
        if (colorize) {
          highlighted += value.split(NEWLINE).map((str) => colorize(str)).join("\n");
        } else {
          highlighted += value;
        }
      }
      return highlighted;
    }
    __name(highlightTokens, "highlightTokens");
    function shouldHighlight(options2) {
      return !!_chalk.supportsColor || options2.forceColor;
    }
    __name(shouldHighlight, "shouldHighlight");
    function getChalk(options2) {
      return options2.forceColor ? new _chalk.constructor({
        enabled: true,
        level: 1
      }) : _chalk;
    }
    __name(getChalk, "getChalk");
    function highlight2(code, options2 = {}) {
      if (code !== "" && shouldHighlight(options2)) {
        const chalk63 = getChalk(options2);
        const defs = getDefs(chalk63);
        return highlightTokens(defs, code);
      } else {
        return code;
      }
    }
    __name(highlight2, "highlight");
  }
});

// ../../node_modules/.pnpm/@babel+code-frame@7.18.6/node_modules/@babel/code-frame/lib/index.js
var require_lib3 = __commonJS({
  "../../node_modules/.pnpm/@babel+code-frame@7.18.6/node_modules/@babel/code-frame/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.codeFrameColumns = codeFrameColumns;
    exports2.default = _default;
    var _highlight = require_lib2();
    var deprecationWarningShown = false;
    function getDefs(chalk63) {
      return {
        gutter: chalk63.grey,
        marker: chalk63.red.bold,
        message: chalk63.red.bold
      };
    }
    __name(getDefs, "getDefs");
    var NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
    function getMarkerLines(loc, source, opts2) {
      const startLoc = Object.assign({
        column: 0,
        line: -1
      }, loc.start);
      const endLoc = Object.assign({}, startLoc, loc.end);
      const {
        linesAbove = 2,
        linesBelow = 3
      } = opts2 || {};
      const startLine = startLoc.line;
      const startColumn = startLoc.column;
      const endLine = endLoc.line;
      const endColumn = endLoc.column;
      let start = Math.max(startLine - (linesAbove + 1), 0);
      let end = Math.min(source.length, endLine + linesBelow);
      if (startLine === -1) {
        start = 0;
      }
      if (endLine === -1) {
        end = source.length;
      }
      const lineDiff = endLine - startLine;
      const markerLines = {};
      if (lineDiff) {
        for (let i3 = 0; i3 <= lineDiff; i3++) {
          const lineNumber = i3 + startLine;
          if (!startColumn) {
            markerLines[lineNumber] = true;
          } else if (i3 === 0) {
            const sourceLength = source[lineNumber - 1].length;
            markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
          } else if (i3 === lineDiff) {
            markerLines[lineNumber] = [0, endColumn];
          } else {
            const sourceLength = source[lineNumber - i3].length;
            markerLines[lineNumber] = [0, sourceLength];
          }
        }
      } else {
        if (startColumn === endColumn) {
          if (startColumn) {
            markerLines[startLine] = [startColumn, 0];
          } else {
            markerLines[startLine] = true;
          }
        } else {
          markerLines[startLine] = [startColumn, endColumn - startColumn];
        }
      }
      return {
        start,
        end,
        markerLines
      };
    }
    __name(getMarkerLines, "getMarkerLines");
    function codeFrameColumns(rawLines, loc, opts2 = {}) {
      const highlighted = (opts2.highlightCode || opts2.forceColor) && (0, _highlight.shouldHighlight)(opts2);
      const chalk63 = (0, _highlight.getChalk)(opts2);
      const defs = getDefs(chalk63);
      const maybeHighlight = /* @__PURE__ */ __name((chalkFn, string) => {
        return highlighted ? chalkFn(string) : string;
      }, "maybeHighlight");
      const lines = rawLines.split(NEWLINE);
      const {
        start,
        end,
        markerLines
      } = getMarkerLines(loc, lines, opts2);
      const hasColumns = loc.start && typeof loc.start.column === "number";
      const numberMaxWidth = String(end).length;
      const highlightedLines = highlighted ? (0, _highlight.default)(rawLines, opts2) : rawLines;
      let frame = highlightedLines.split(NEWLINE, end).slice(start, end).map((line, index2) => {
        const number = start + 1 + index2;
        const paddedNumber = ` ${number}`.slice(-numberMaxWidth);
        const gutter = ` ${paddedNumber} |`;
        const hasMarker = markerLines[number];
        const lastMarkerLine = !markerLines[number + 1];
        if (hasMarker) {
          let markerLine = "";
          if (Array.isArray(hasMarker)) {
            const markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
            const numberOfMarkers = hasMarker[1] || 1;
            markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), " ", markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");
            if (lastMarkerLine && opts2.message) {
              markerLine += " " + maybeHighlight(defs.message, opts2.message);
            }
          }
          return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line.length > 0 ? ` ${line}` : "", markerLine].join("");
        } else {
          return ` ${maybeHighlight(defs.gutter, gutter)}${line.length > 0 ? ` ${line}` : ""}`;
        }
      }).join("\n");
      if (opts2.message && !hasColumns) {
        frame = `${" ".repeat(numberMaxWidth + 1)}${opts2.message}
${frame}`;
      }
      if (highlighted) {
        return chalk63.reset(frame);
      } else {
        return frame;
      }
    }
    __name(codeFrameColumns, "codeFrameColumns");
    function _default(rawLines, lineNumber, colNumber, opts2 = {}) {
      if (!deprecationWarningShown) {
        deprecationWarningShown = true;
        const message2 = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";
        if (process.emitWarning) {
          process.emitWarning(message2, "DeprecationWarning");
        } else {
          const deprecationError = new Error(message2);
          deprecationError.name = "DeprecationWarning";
          console.warn(new Error(message2));
        }
      }
      colNumber = Math.max(colNumber, 0);
      const location = {
        start: {
          column: colNumber,
          line: lineNumber
        }
      };
      return codeFrameColumns(rawLines, location, opts2);
    }
    __name(_default, "_default");
  }
});

// ../../node_modules/.pnpm/parse-json@5.2.0/node_modules/parse-json/index.js
var require_parse_json = __commonJS({
  "../../node_modules/.pnpm/parse-json@5.2.0/node_modules/parse-json/index.js"(exports2, module2) {
    "use strict";
    var errorEx = require_error_ex();
    var fallback2 = require_json_parse_even_better_errors();
    var { default: LinesAndColumns } = require_build();
    var { codeFrameColumns } = require_lib3();
    var JSONError = errorEx("JSONError", {
      fileName: errorEx.append("in %s"),
      codeFrame: errorEx.append("\n\n%s\n")
    });
    var parseJson = /* @__PURE__ */ __name((string, reviver, filename) => {
      if (typeof reviver === "string") {
        filename = reviver;
        reviver = null;
      }
      try {
        try {
          return JSON.parse(string, reviver);
        } catch (error2) {
          fallback2(string, reviver);
          throw error2;
        }
      } catch (error2) {
        error2.message = error2.message.replace(/\n/g, "");
        const indexMatch = error2.message.match(/in JSON at position (\d+) while parsing/);
        const jsonError = new JSONError(error2);
        if (filename) {
          jsonError.fileName = filename;
        }
        if (indexMatch && indexMatch.length > 0) {
          const lines = new LinesAndColumns(string);
          const index2 = Number(indexMatch[1]);
          const location = lines.locationForIndex(index2);
          const codeFrame = codeFrameColumns(
            string,
            { start: { line: location.line + 1, column: location.column + 1 } },
            { highlightCode: true }
          );
          jsonError.codeFrame = codeFrame;
        }
        throw jsonError;
      }
    }, "parseJson");
    parseJson.JSONError = JSONError;
    module2.exports = parseJson;
  }
});

// ../../node_modules/.pnpm/semver@5.7.1/node_modules/semver/semver.js
var require_semver = __commonJS({
  "../../node_modules/.pnpm/semver@5.7.1/node_modules/semver/semver.js"(exports2, module2) {
    exports2 = module2.exports = SemVer;
    var debug27;
    if (typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG)) {
      debug27 = /* @__PURE__ */ __name(function() {
        var args3 = Array.prototype.slice.call(arguments, 0);
        args3.unshift("SEMVER");
        console.log.apply(console, args3);
      }, "debug");
    } else {
      debug27 = /* @__PURE__ */ __name(function() {
      }, "debug");
    }
    exports2.SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var re = exports2.re = [];
    var src = exports2.src = [];
    var R = 0;
    var NUMERICIDENTIFIER = R++;
    src[NUMERICIDENTIFIER] = "0|[1-9]\\d*";
    var NUMERICIDENTIFIERLOOSE = R++;
    src[NUMERICIDENTIFIERLOOSE] = "[0-9]+";
    var NONNUMERICIDENTIFIER = R++;
    src[NONNUMERICIDENTIFIER] = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
    var MAINVERSION = R++;
    src[MAINVERSION] = "(" + src[NUMERICIDENTIFIER] + ")\\.(" + src[NUMERICIDENTIFIER] + ")\\.(" + src[NUMERICIDENTIFIER] + ")";
    var MAINVERSIONLOOSE = R++;
    src[MAINVERSIONLOOSE] = "(" + src[NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[NUMERICIDENTIFIERLOOSE] + ")";
    var PRERELEASEIDENTIFIER = R++;
    src[PRERELEASEIDENTIFIER] = "(?:" + src[NUMERICIDENTIFIER] + "|" + src[NONNUMERICIDENTIFIER] + ")";
    var PRERELEASEIDENTIFIERLOOSE = R++;
    src[PRERELEASEIDENTIFIERLOOSE] = "(?:" + src[NUMERICIDENTIFIERLOOSE] + "|" + src[NONNUMERICIDENTIFIER] + ")";
    var PRERELEASE = R++;
    src[PRERELEASE] = "(?:-(" + src[PRERELEASEIDENTIFIER] + "(?:\\." + src[PRERELEASEIDENTIFIER] + ")*))";
    var PRERELEASELOOSE = R++;
    src[PRERELEASELOOSE] = "(?:-?(" + src[PRERELEASEIDENTIFIERLOOSE] + "(?:\\." + src[PRERELEASEIDENTIFIERLOOSE] + ")*))";
    var BUILDIDENTIFIER = R++;
    src[BUILDIDENTIFIER] = "[0-9A-Za-z-]+";
    var BUILD = R++;
    src[BUILD] = "(?:\\+(" + src[BUILDIDENTIFIER] + "(?:\\." + src[BUILDIDENTIFIER] + ")*))";
    var FULL = R++;
    var FULLPLAIN = "v?" + src[MAINVERSION] + src[PRERELEASE] + "?" + src[BUILD] + "?";
    src[FULL] = "^" + FULLPLAIN + "$";
    var LOOSEPLAIN = "[v=\\s]*" + src[MAINVERSIONLOOSE] + src[PRERELEASELOOSE] + "?" + src[BUILD] + "?";
    var LOOSE = R++;
    src[LOOSE] = "^" + LOOSEPLAIN + "$";
    var GTLT = R++;
    src[GTLT] = "((?:<|>)?=?)";
    var XRANGEIDENTIFIERLOOSE = R++;
    src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + "|x|X|\\*";
    var XRANGEIDENTIFIER = R++;
    src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + "|x|X|\\*";
    var XRANGEPLAIN = R++;
    src[XRANGEPLAIN] = "[v=\\s]*(" + src[XRANGEIDENTIFIER] + ")(?:\\.(" + src[XRANGEIDENTIFIER] + ")(?:\\.(" + src[XRANGEIDENTIFIER] + ")(?:" + src[PRERELEASE] + ")?" + src[BUILD] + "?)?)?";
    var XRANGEPLAINLOOSE = R++;
    src[XRANGEPLAINLOOSE] = "[v=\\s]*(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[XRANGEIDENTIFIERLOOSE] + ")(?:" + src[PRERELEASELOOSE] + ")?" + src[BUILD] + "?)?)?";
    var XRANGE = R++;
    src[XRANGE] = "^" + src[GTLT] + "\\s*" + src[XRANGEPLAIN] + "$";
    var XRANGELOOSE = R++;
    src[XRANGELOOSE] = "^" + src[GTLT] + "\\s*" + src[XRANGEPLAINLOOSE] + "$";
    var COERCE = R++;
    src[COERCE] = "(?:^|[^\\d])(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "})(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:$|[^\\d])";
    var LONETILDE = R++;
    src[LONETILDE] = "(?:~>?)";
    var TILDETRIM = R++;
    src[TILDETRIM] = "(\\s*)" + src[LONETILDE] + "\\s+";
    re[TILDETRIM] = new RegExp(src[TILDETRIM], "g");
    var tildeTrimReplace = "$1~";
    var TILDE = R++;
    src[TILDE] = "^" + src[LONETILDE] + src[XRANGEPLAIN] + "$";
    var TILDELOOSE = R++;
    src[TILDELOOSE] = "^" + src[LONETILDE] + src[XRANGEPLAINLOOSE] + "$";
    var LONECARET = R++;
    src[LONECARET] = "(?:\\^)";
    var CARETTRIM = R++;
    src[CARETTRIM] = "(\\s*)" + src[LONECARET] + "\\s+";
    re[CARETTRIM] = new RegExp(src[CARETTRIM], "g");
    var caretTrimReplace = "$1^";
    var CARET = R++;
    src[CARET] = "^" + src[LONECARET] + src[XRANGEPLAIN] + "$";
    var CARETLOOSE = R++;
    src[CARETLOOSE] = "^" + src[LONECARET] + src[XRANGEPLAINLOOSE] + "$";
    var COMPARATORLOOSE = R++;
    src[COMPARATORLOOSE] = "^" + src[GTLT] + "\\s*(" + LOOSEPLAIN + ")$|^$";
    var COMPARATOR = R++;
    src[COMPARATOR] = "^" + src[GTLT] + "\\s*(" + FULLPLAIN + ")$|^$";
    var COMPARATORTRIM = R++;
    src[COMPARATORTRIM] = "(\\s*)" + src[GTLT] + "\\s*(" + LOOSEPLAIN + "|" + src[XRANGEPLAIN] + ")";
    re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], "g");
    var comparatorTrimReplace = "$1$2$3";
    var HYPHENRANGE = R++;
    src[HYPHENRANGE] = "^\\s*(" + src[XRANGEPLAIN] + ")\\s+-\\s+(" + src[XRANGEPLAIN] + ")\\s*$";
    var HYPHENRANGELOOSE = R++;
    src[HYPHENRANGELOOSE] = "^\\s*(" + src[XRANGEPLAINLOOSE] + ")\\s+-\\s+(" + src[XRANGEPLAINLOOSE] + ")\\s*$";
    var STAR = R++;
    src[STAR] = "(<|>)?=?\\s*\\*";
    for (i3 = 0; i3 < R; i3++) {
      debug27(i3, src[i3]);
      if (!re[i3]) {
        re[i3] = new RegExp(src[i3]);
      }
    }
    var i3;
    exports2.parse = parse2;
    function parse2(version3, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version3 instanceof SemVer) {
        return version3;
      }
      if (typeof version3 !== "string") {
        return null;
      }
      if (version3.length > MAX_LENGTH) {
        return null;
      }
      var r3 = options2.loose ? re[LOOSE] : re[FULL];
      if (!r3.test(version3)) {
        return null;
      }
      try {
        return new SemVer(version3, options2);
      } catch (er) {
        return null;
      }
    }
    __name(parse2, "parse");
    exports2.valid = valid;
    function valid(version3, options2) {
      var v3 = parse2(version3, options2);
      return v3 ? v3.version : null;
    }
    __name(valid, "valid");
    exports2.clean = clean;
    function clean(version3, options2) {
      var s4 = parse2(version3.trim().replace(/^[=v]+/, ""), options2);
      return s4 ? s4.version : null;
    }
    __name(clean, "clean");
    exports2.SemVer = SemVer;
    function SemVer(version3, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version3 instanceof SemVer) {
        if (version3.loose === options2.loose) {
          return version3;
        } else {
          version3 = version3.version;
        }
      } else if (typeof version3 !== "string") {
        throw new TypeError("Invalid Version: " + version3);
      }
      if (version3.length > MAX_LENGTH) {
        throw new TypeError("version is longer than " + MAX_LENGTH + " characters");
      }
      if (!(this instanceof SemVer)) {
        return new SemVer(version3, options2);
      }
      debug27("SemVer", version3, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      var m4 = version3.trim().match(options2.loose ? re[LOOSE] : re[FULL]);
      if (!m4) {
        throw new TypeError("Invalid Version: " + version3);
      }
      this.raw = version3;
      this.major = +m4[1];
      this.minor = +m4[2];
      this.patch = +m4[3];
      if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
        throw new TypeError("Invalid major version");
      }
      if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
        throw new TypeError("Invalid minor version");
      }
      if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
        throw new TypeError("Invalid patch version");
      }
      if (!m4[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m4[4].split(".").map(function(id) {
          if (/^[0-9]+$/.test(id)) {
            var num = +id;
            if (num >= 0 && num < MAX_SAFE_INTEGER) {
              return num;
            }
          }
          return id;
        });
      }
      this.build = m4[5] ? m4[5].split(".") : [];
      this.format();
    }
    __name(SemVer, "SemVer");
    SemVer.prototype.format = function() {
      this.version = this.major + "." + this.minor + "." + this.patch;
      if (this.prerelease.length) {
        this.version += "-" + this.prerelease.join(".");
      }
      return this.version;
    };
    SemVer.prototype.toString = function() {
      return this.version;
    };
    SemVer.prototype.compare = function(other) {
      debug27("SemVer.compare", this.version, this.options, other);
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return this.compareMain(other) || this.comparePre(other);
    };
    SemVer.prototype.compareMain = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    };
    SemVer.prototype.comparePre = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      var i4 = 0;
      do {
        var a3 = this.prerelease[i4];
        var b3 = other.prerelease[i4];
        debug27("prerelease compare", i4, a3, b3);
        if (a3 === void 0 && b3 === void 0) {
          return 0;
        } else if (b3 === void 0) {
          return 1;
        } else if (a3 === void 0) {
          return -1;
        } else if (a3 === b3) {
          continue;
        } else {
          return compareIdentifiers(a3, b3);
        }
      } while (++i4);
    };
    SemVer.prototype.inc = function(release, identifier) {
      switch (release) {
        case "premajor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc("pre", identifier);
          break;
        case "preminor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc("pre", identifier);
          break;
        case "prepatch":
          this.prerelease.length = 0;
          this.inc("patch", identifier);
          this.inc("pre", identifier);
          break;
        case "prerelease":
          if (this.prerelease.length === 0) {
            this.inc("patch", identifier);
          }
          this.inc("pre", identifier);
          break;
        case "major":
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case "minor":
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case "patch":
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        case "pre":
          if (this.prerelease.length === 0) {
            this.prerelease = [0];
          } else {
            var i4 = this.prerelease.length;
            while (--i4 >= 0) {
              if (typeof this.prerelease[i4] === "number") {
                this.prerelease[i4]++;
                i4 = -2;
              }
            }
            if (i4 === -1) {
              this.prerelease.push(0);
            }
          }
          if (identifier) {
            if (this.prerelease[0] === identifier) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = [identifier, 0];
              }
            } else {
              this.prerelease = [identifier, 0];
            }
          }
          break;
        default:
          throw new Error("invalid increment argument: " + release);
      }
      this.format();
      this.raw = this.version;
      return this;
    };
    exports2.inc = inc;
    function inc(version3, release, loose, identifier) {
      if (typeof loose === "string") {
        identifier = loose;
        loose = void 0;
      }
      try {
        return new SemVer(version3, loose).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    }
    __name(inc, "inc");
    exports2.diff = diff;
    function diff(version1, version22) {
      if (eq(version1, version22)) {
        return null;
      } else {
        var v1 = parse2(version1);
        var v22 = parse2(version22);
        var prefix = "";
        if (v1.prerelease.length || v22.prerelease.length) {
          prefix = "pre";
          var defaultResult = "prerelease";
        }
        for (var key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v22[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    }
    __name(diff, "diff");
    exports2.compareIdentifiers = compareIdentifiers;
    var numeric = /^[0-9]+$/;
    function compareIdentifiers(a3, b3) {
      var anum = numeric.test(a3);
      var bnum = numeric.test(b3);
      if (anum && bnum) {
        a3 = +a3;
        b3 = +b3;
      }
      return a3 === b3 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a3 < b3 ? -1 : 1;
    }
    __name(compareIdentifiers, "compareIdentifiers");
    exports2.rcompareIdentifiers = rcompareIdentifiers;
    function rcompareIdentifiers(a3, b3) {
      return compareIdentifiers(b3, a3);
    }
    __name(rcompareIdentifiers, "rcompareIdentifiers");
    exports2.major = major;
    function major(a3, loose) {
      return new SemVer(a3, loose).major;
    }
    __name(major, "major");
    exports2.minor = minor;
    function minor(a3, loose) {
      return new SemVer(a3, loose).minor;
    }
    __name(minor, "minor");
    exports2.patch = patch;
    function patch(a3, loose) {
      return new SemVer(a3, loose).patch;
    }
    __name(patch, "patch");
    exports2.compare = compare;
    function compare(a3, b3, loose) {
      return new SemVer(a3, loose).compare(new SemVer(b3, loose));
    }
    __name(compare, "compare");
    exports2.compareLoose = compareLoose;
    function compareLoose(a3, b3) {
      return compare(a3, b3, true);
    }
    __name(compareLoose, "compareLoose");
    exports2.rcompare = rcompare;
    function rcompare(a3, b3, loose) {
      return compare(b3, a3, loose);
    }
    __name(rcompare, "rcompare");
    exports2.sort = sort;
    function sort(list, loose) {
      return list.sort(function(a3, b3) {
        return exports2.compare(a3, b3, loose);
      });
    }
    __name(sort, "sort");
    exports2.rsort = rsort;
    function rsort(list, loose) {
      return list.sort(function(a3, b3) {
        return exports2.rcompare(a3, b3, loose);
      });
    }
    __name(rsort, "rsort");
    exports2.gt = gt;
    function gt(a3, b3, loose) {
      return compare(a3, b3, loose) > 0;
    }
    __name(gt, "gt");
    exports2.lt = lt;
    function lt(a3, b3, loose) {
      return compare(a3, b3, loose) < 0;
    }
    __name(lt, "lt");
    exports2.eq = eq;
    function eq(a3, b3, loose) {
      return compare(a3, b3, loose) === 0;
    }
    __name(eq, "eq");
    exports2.neq = neq;
    function neq(a3, b3, loose) {
      return compare(a3, b3, loose) !== 0;
    }
    __name(neq, "neq");
    exports2.gte = gte;
    function gte(a3, b3, loose) {
      return compare(a3, b3, loose) >= 0;
    }
    __name(gte, "gte");
    exports2.lte = lte;
    function lte(a3, b3, loose) {
      return compare(a3, b3, loose) <= 0;
    }
    __name(lte, "lte");
    exports2.cmp = cmp;
    function cmp(a3, op, b3, loose) {
      switch (op) {
        case "===":
          if (typeof a3 === "object")
            a3 = a3.version;
          if (typeof b3 === "object")
            b3 = b3.version;
          return a3 === b3;
        case "!==":
          if (typeof a3 === "object")
            a3 = a3.version;
          if (typeof b3 === "object")
            b3 = b3.version;
          return a3 !== b3;
        case "":
        case "=":
        case "==":
          return eq(a3, b3, loose);
        case "!=":
          return neq(a3, b3, loose);
        case ">":
          return gt(a3, b3, loose);
        case ">=":
          return gte(a3, b3, loose);
        case "<":
          return lt(a3, b3, loose);
        case "<=":
          return lte(a3, b3, loose);
        default:
          throw new TypeError("Invalid operator: " + op);
      }
    }
    __name(cmp, "cmp");
    exports2.Comparator = Comparator;
    function Comparator(comp, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (comp instanceof Comparator) {
        if (comp.loose === !!options2.loose) {
          return comp;
        } else {
          comp = comp.value;
        }
      }
      if (!(this instanceof Comparator)) {
        return new Comparator(comp, options2);
      }
      debug27("comparator", comp, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      this.parse(comp);
      if (this.semver === ANY) {
        this.value = "";
      } else {
        this.value = this.operator + this.semver.version;
      }
      debug27("comp", this);
    }
    __name(Comparator, "Comparator");
    var ANY = {};
    Comparator.prototype.parse = function(comp) {
      var r3 = this.options.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
      var m4 = comp.match(r3);
      if (!m4) {
        throw new TypeError("Invalid comparator: " + comp);
      }
      this.operator = m4[1];
      if (this.operator === "=") {
        this.operator = "";
      }
      if (!m4[2]) {
        this.semver = ANY;
      } else {
        this.semver = new SemVer(m4[2], this.options.loose);
      }
    };
    Comparator.prototype.toString = function() {
      return this.value;
    };
    Comparator.prototype.test = function(version3) {
      debug27("Comparator.test", version3, this.options.loose);
      if (this.semver === ANY) {
        return true;
      }
      if (typeof version3 === "string") {
        version3 = new SemVer(version3, this.options);
      }
      return cmp(version3, this.operator, this.semver, this.options);
    };
    Comparator.prototype.intersects = function(comp, options2) {
      if (!(comp instanceof Comparator)) {
        throw new TypeError("a Comparator is required");
      }
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      var rangeTmp;
      if (this.operator === "") {
        rangeTmp = new Range(comp.value, options2);
        return satisfies(this.value, rangeTmp, options2);
      } else if (comp.operator === "") {
        rangeTmp = new Range(this.value, options2);
        return satisfies(comp.semver, rangeTmp, options2);
      }
      var sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
      var sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
      var sameSemVer = this.semver.version === comp.semver.version;
      var differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
      var oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options2) && ((this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<"));
      var oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options2) && ((this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">"));
      return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
    };
    exports2.Range = Range;
    function Range(range2, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (range2 instanceof Range) {
        if (range2.loose === !!options2.loose && range2.includePrerelease === !!options2.includePrerelease) {
          return range2;
        } else {
          return new Range(range2.raw, options2);
        }
      }
      if (range2 instanceof Comparator) {
        return new Range(range2.value, options2);
      }
      if (!(this instanceof Range)) {
        return new Range(range2, options2);
      }
      this.options = options2;
      this.loose = !!options2.loose;
      this.includePrerelease = !!options2.includePrerelease;
      this.raw = range2;
      this.set = range2.split(/\s*\|\|\s*/).map(function(range3) {
        return this.parseRange(range3.trim());
      }, this).filter(function(c3) {
        return c3.length;
      });
      if (!this.set.length) {
        throw new TypeError("Invalid SemVer Range: " + range2);
      }
      this.format();
    }
    __name(Range, "Range");
    Range.prototype.format = function() {
      this.range = this.set.map(function(comps) {
        return comps.join(" ").trim();
      }).join("||").trim();
      return this.range;
    };
    Range.prototype.toString = function() {
      return this.range;
    };
    Range.prototype.parseRange = function(range2) {
      var loose = this.options.loose;
      range2 = range2.trim();
      var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
      range2 = range2.replace(hr, hyphenReplace);
      debug27("hyphen replace", range2);
      range2 = range2.replace(re[COMPARATORTRIM], comparatorTrimReplace);
      debug27("comparator trim", range2, re[COMPARATORTRIM]);
      range2 = range2.replace(re[TILDETRIM], tildeTrimReplace);
      range2 = range2.replace(re[CARETTRIM], caretTrimReplace);
      range2 = range2.split(/\s+/).join(" ");
      var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
      var set = range2.split(" ").map(function(comp) {
        return parseComparator(comp, this.options);
      }, this).join(" ").split(/\s+/);
      if (this.options.loose) {
        set = set.filter(function(comp) {
          return !!comp.match(compRe);
        });
      }
      set = set.map(function(comp) {
        return new Comparator(comp, this.options);
      }, this);
      return set;
    };
    Range.prototype.intersects = function(range2, options2) {
      if (!(range2 instanceof Range)) {
        throw new TypeError("a Range is required");
      }
      return this.set.some(function(thisComparators) {
        return thisComparators.every(function(thisComparator) {
          return range2.set.some(function(rangeComparators) {
            return rangeComparators.every(function(rangeComparator) {
              return thisComparator.intersects(rangeComparator, options2);
            });
          });
        });
      });
    };
    exports2.toComparators = toComparators;
    function toComparators(range2, options2) {
      return new Range(range2, options2).set.map(function(comp) {
        return comp.map(function(c3) {
          return c3.value;
        }).join(" ").trim().split(" ");
      });
    }
    __name(toComparators, "toComparators");
    function parseComparator(comp, options2) {
      debug27("comp", comp, options2);
      comp = replaceCarets(comp, options2);
      debug27("caret", comp);
      comp = replaceTildes(comp, options2);
      debug27("tildes", comp);
      comp = replaceXRanges(comp, options2);
      debug27("xrange", comp);
      comp = replaceStars(comp, options2);
      debug27("stars", comp);
      return comp;
    }
    __name(parseComparator, "parseComparator");
    function isX(id) {
      return !id || id.toLowerCase() === "x" || id === "*";
    }
    __name(isX, "isX");
    function replaceTildes(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceTilde(comp2, options2);
      }).join(" ");
    }
    __name(replaceTildes, "replaceTildes");
    function replaceTilde(comp, options2) {
      var r3 = options2.loose ? re[TILDELOOSE] : re[TILDE];
      return comp.replace(r3, function(_2, M, m4, p3, pr) {
        debug27("tilde", comp, _2, M, m4, p3, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m4)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p3)) {
          ret = ">=" + M + "." + m4 + ".0 <" + M + "." + (+m4 + 1) + ".0";
        } else if (pr) {
          debug27("replaceTilde pr", pr);
          ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + (+m4 + 1) + ".0";
        } else {
          ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + (+m4 + 1) + ".0";
        }
        debug27("tilde return", ret);
        return ret;
      });
    }
    __name(replaceTilde, "replaceTilde");
    function replaceCarets(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceCaret(comp2, options2);
      }).join(" ");
    }
    __name(replaceCarets, "replaceCarets");
    function replaceCaret(comp, options2) {
      debug27("caret", comp, options2);
      var r3 = options2.loose ? re[CARETLOOSE] : re[CARET];
      return comp.replace(r3, function(_2, M, m4, p3, pr) {
        debug27("caret", comp, _2, M, m4, p3, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m4)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p3)) {
          if (M === "0") {
            ret = ">=" + M + "." + m4 + ".0 <" + M + "." + (+m4 + 1) + ".0";
          } else {
            ret = ">=" + M + "." + m4 + ".0 <" + (+M + 1) + ".0.0";
          }
        } else if (pr) {
          debug27("replaceCaret pr", pr);
          if (M === "0") {
            if (m4 === "0") {
              ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + m4 + "." + (+p3 + 1);
            } else {
              ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + (+m4 + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + (+M + 1) + ".0.0";
          }
        } else {
          debug27("no pr");
          if (M === "0") {
            if (m4 === "0") {
              ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + m4 + "." + (+p3 + 1);
            } else {
              ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + (+m4 + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m4 + "." + p3 + " <" + (+M + 1) + ".0.0";
          }
        }
        debug27("caret return", ret);
        return ret;
      });
    }
    __name(replaceCaret, "replaceCaret");
    function replaceXRanges(comp, options2) {
      debug27("replaceXRanges", comp, options2);
      return comp.split(/\s+/).map(function(comp2) {
        return replaceXRange(comp2, options2);
      }).join(" ");
    }
    __name(replaceXRanges, "replaceXRanges");
    function replaceXRange(comp, options2) {
      comp = comp.trim();
      var r3 = options2.loose ? re[XRANGELOOSE] : re[XRANGE];
      return comp.replace(r3, function(ret, gtlt, M, m4, p3, pr) {
        debug27("xRange", comp, ret, gtlt, M, m4, p3, pr);
        var xM = isX(M);
        var xm = xM || isX(m4);
        var xp = xm || isX(p3);
        var anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m4 = 0;
          }
          p3 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m4 = 0;
              p3 = 0;
            } else {
              m4 = +m4 + 1;
              p3 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m4 = +m4 + 1;
            }
          }
          ret = gtlt + M + "." + m4 + "." + p3;
        } else if (xm) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (xp) {
          ret = ">=" + M + "." + m4 + ".0 <" + M + "." + (+m4 + 1) + ".0";
        }
        debug27("xRange return", ret);
        return ret;
      });
    }
    __name(replaceXRange, "replaceXRange");
    function replaceStars(comp, options2) {
      debug27("replaceStars", comp, options2);
      return comp.trim().replace(re[STAR], "");
    }
    __name(replaceStars, "replaceStars");
    function hyphenReplace($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = ">=" + fM + ".0.0";
      } else if (isX(fp)) {
        from = ">=" + fM + "." + fm + ".0";
      } else {
        from = ">=" + from;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = "<" + (+tM + 1) + ".0.0";
      } else if (isX(tp)) {
        to = "<" + tM + "." + (+tm + 1) + ".0";
      } else if (tpr) {
        to = "<=" + tM + "." + tm + "." + tp + "-" + tpr;
      } else {
        to = "<=" + to;
      }
      return (from + " " + to).trim();
    }
    __name(hyphenReplace, "hyphenReplace");
    Range.prototype.test = function(version3) {
      if (!version3) {
        return false;
      }
      if (typeof version3 === "string") {
        version3 = new SemVer(version3, this.options);
      }
      for (var i4 = 0; i4 < this.set.length; i4++) {
        if (testSet(this.set[i4], version3, this.options)) {
          return true;
        }
      }
      return false;
    };
    function testSet(set, version3, options2) {
      for (var i4 = 0; i4 < set.length; i4++) {
        if (!set[i4].test(version3)) {
          return false;
        }
      }
      if (version3.prerelease.length && !options2.includePrerelease) {
        for (i4 = 0; i4 < set.length; i4++) {
          debug27(set[i4].semver);
          if (set[i4].semver === ANY) {
            continue;
          }
          if (set[i4].semver.prerelease.length > 0) {
            var allowed = set[i4].semver;
            if (allowed.major === version3.major && allowed.minor === version3.minor && allowed.patch === version3.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    }
    __name(testSet, "testSet");
    exports2.satisfies = satisfies;
    function satisfies(version3, range2, options2) {
      try {
        range2 = new Range(range2, options2);
      } catch (er) {
        return false;
      }
      return range2.test(version3);
    }
    __name(satisfies, "satisfies");
    exports2.maxSatisfying = maxSatisfying;
    function maxSatisfying(versions, range2, options2) {
      var max = null;
      var maxSV = null;
      try {
        var rangeObj = new Range(range2, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v3) {
        if (rangeObj.test(v3)) {
          if (!max || maxSV.compare(v3) === -1) {
            max = v3;
            maxSV = new SemVer(max, options2);
          }
        }
      });
      return max;
    }
    __name(maxSatisfying, "maxSatisfying");
    exports2.minSatisfying = minSatisfying;
    function minSatisfying(versions, range2, options2) {
      var min = null;
      var minSV = null;
      try {
        var rangeObj = new Range(range2, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v3) {
        if (rangeObj.test(v3)) {
          if (!min || minSV.compare(v3) === 1) {
            min = v3;
            minSV = new SemVer(min, options2);
          }
        }
      });
      return min;
    }
    __name(minSatisfying, "minSatisfying");
    exports2.minVersion = minVersion;
    function minVersion(range2, loose) {
      range2 = new Range(range2, loose);
      var minver = new SemVer("0.0.0");
      if (range2.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range2.test(minver)) {
        return minver;
      }
      minver = null;
      for (var i4 = 0; i4 < range2.set.length; ++i4) {
        var comparators = range2.set[i4];
        comparators.forEach(function(comparator) {
          var compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!minver || gt(minver, compver)) {
                minver = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error("Unexpected operation: " + comparator.operator);
          }
        });
      }
      if (minver && range2.test(minver)) {
        return minver;
      }
      return null;
    }
    __name(minVersion, "minVersion");
    exports2.validRange = validRange;
    function validRange(range2, options2) {
      try {
        return new Range(range2, options2).range || "*";
      } catch (er) {
        return null;
      }
    }
    __name(validRange, "validRange");
    exports2.ltr = ltr;
    function ltr(version3, range2, options2) {
      return outside(version3, range2, "<", options2);
    }
    __name(ltr, "ltr");
    exports2.gtr = gtr;
    function gtr(version3, range2, options2) {
      return outside(version3, range2, ">", options2);
    }
    __name(gtr, "gtr");
    exports2.outside = outside;
    function outside(version3, range2, hilo, options2) {
      version3 = new SemVer(version3, options2);
      range2 = new Range(range2, options2);
      var gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version3, range2, options2)) {
        return false;
      }
      for (var i4 = 0; i4 < range2.set.length; ++i4) {
        var comparators = range2.set[i4];
        var high = null;
        var low = null;
        comparators.forEach(function(comparator) {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options2)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options2)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version3, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version3, low.semver)) {
          return false;
        }
      }
      return true;
    }
    __name(outside, "outside");
    exports2.prerelease = prerelease;
    function prerelease(version3, options2) {
      var parsed = parse2(version3, options2);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    }
    __name(prerelease, "prerelease");
    exports2.intersects = intersects;
    function intersects(r1, r22, options2) {
      r1 = new Range(r1, options2);
      r22 = new Range(r22, options2);
      return r1.intersects(r22);
    }
    __name(intersects, "intersects");
    exports2.coerce = coerce;
    function coerce(version3) {
      if (version3 instanceof SemVer) {
        return version3;
      }
      if (typeof version3 !== "string") {
        return null;
      }
      var match4 = version3.match(re[COERCE]);
      if (match4 == null) {
        return null;
      }
      return parse2(match4[1] + "." + (match4[2] || "0") + "." + (match4[3] || "0"));
    }
    __name(coerce, "coerce");
  }
});

// ../../node_modules/.pnpm/spdx-license-ids@3.0.12/node_modules/spdx-license-ids/index.json
var require_spdx_license_ids = __commonJS({
  "../../node_modules/.pnpm/spdx-license-ids@3.0.12/node_modules/spdx-license-ids/index.json"(exports2, module2) {
    module2.exports = [
      "0BSD",
      "AAL",
      "ADSL",
      "AFL-1.1",
      "AFL-1.2",
      "AFL-2.0",
      "AFL-2.1",
      "AFL-3.0",
      "AGPL-1.0-only",
      "AGPL-1.0-or-later",
      "AGPL-3.0-only",
      "AGPL-3.0-or-later",
      "AMDPLPA",
      "AML",
      "AMPAS",
      "ANTLR-PD",
      "ANTLR-PD-fallback",
      "APAFML",
      "APL-1.0",
      "APSL-1.0",
      "APSL-1.1",
      "APSL-1.2",
      "APSL-2.0",
      "Abstyles",
      "Adobe-2006",
      "Adobe-Glyph",
      "Afmparse",
      "Aladdin",
      "Apache-1.0",
      "Apache-1.1",
      "Apache-2.0",
      "App-s2p",
      "Arphic-1999",
      "Artistic-1.0",
      "Artistic-1.0-Perl",
      "Artistic-1.0-cl8",
      "Artistic-2.0",
      "BSD-1-Clause",
      "BSD-2-Clause",
      "BSD-2-Clause-Patent",
      "BSD-2-Clause-Views",
      "BSD-3-Clause",
      "BSD-3-Clause-Attribution",
      "BSD-3-Clause-Clear",
      "BSD-3-Clause-LBNL",
      "BSD-3-Clause-Modification",
      "BSD-3-Clause-No-Military-License",
      "BSD-3-Clause-No-Nuclear-License",
      "BSD-3-Clause-No-Nuclear-License-2014",
      "BSD-3-Clause-No-Nuclear-Warranty",
      "BSD-3-Clause-Open-MPI",
      "BSD-4-Clause",
      "BSD-4-Clause-Shortened",
      "BSD-4-Clause-UC",
      "BSD-Protection",
      "BSD-Source-Code",
      "BSL-1.0",
      "BUSL-1.1",
      "Baekmuk",
      "Bahyph",
      "Barr",
      "Beerware",
      "BitTorrent-1.0",
      "BitTorrent-1.1",
      "Bitstream-Vera",
      "BlueOak-1.0.0",
      "Borceux",
      "C-UDA-1.0",
      "CAL-1.0",
      "CAL-1.0-Combined-Work-Exception",
      "CATOSL-1.1",
      "CC-BY-1.0",
      "CC-BY-2.0",
      "CC-BY-2.5",
      "CC-BY-2.5-AU",
      "CC-BY-3.0",
      "CC-BY-3.0-AT",
      "CC-BY-3.0-DE",
      "CC-BY-3.0-IGO",
      "CC-BY-3.0-NL",
      "CC-BY-3.0-US",
      "CC-BY-4.0",
      "CC-BY-NC-1.0",
      "CC-BY-NC-2.0",
      "CC-BY-NC-2.5",
      "CC-BY-NC-3.0",
      "CC-BY-NC-3.0-DE",
      "CC-BY-NC-4.0",
      "CC-BY-NC-ND-1.0",
      "CC-BY-NC-ND-2.0",
      "CC-BY-NC-ND-2.5",
      "CC-BY-NC-ND-3.0",
      "CC-BY-NC-ND-3.0-DE",
      "CC-BY-NC-ND-3.0-IGO",
      "CC-BY-NC-ND-4.0",
      "CC-BY-NC-SA-1.0",
      "CC-BY-NC-SA-2.0",
      "CC-BY-NC-SA-2.0-FR",
      "CC-BY-NC-SA-2.0-UK",
      "CC-BY-NC-SA-2.5",
      "CC-BY-NC-SA-3.0",
      "CC-BY-NC-SA-3.0-DE",
      "CC-BY-NC-SA-3.0-IGO",
      "CC-BY-NC-SA-4.0",
      "CC-BY-ND-1.0",
      "CC-BY-ND-2.0",
      "CC-BY-ND-2.5",
      "CC-BY-ND-3.0",
      "CC-BY-ND-3.0-DE",
      "CC-BY-ND-4.0",
      "CC-BY-SA-1.0",
      "CC-BY-SA-2.0",
      "CC-BY-SA-2.0-UK",
      "CC-BY-SA-2.1-JP",
      "CC-BY-SA-2.5",
      "CC-BY-SA-3.0",
      "CC-BY-SA-3.0-AT",
      "CC-BY-SA-3.0-DE",
      "CC-BY-SA-4.0",
      "CC-PDDC",
      "CC0-1.0",
      "CDDL-1.0",
      "CDDL-1.1",
      "CDL-1.0",
      "CDLA-Permissive-1.0",
      "CDLA-Permissive-2.0",
      "CDLA-Sharing-1.0",
      "CECILL-1.0",
      "CECILL-1.1",
      "CECILL-2.0",
      "CECILL-2.1",
      "CECILL-B",
      "CECILL-C",
      "CERN-OHL-1.1",
      "CERN-OHL-1.2",
      "CERN-OHL-P-2.0",
      "CERN-OHL-S-2.0",
      "CERN-OHL-W-2.0",
      "CNRI-Jython",
      "CNRI-Python",
      "CNRI-Python-GPL-Compatible",
      "COIL-1.0",
      "CPAL-1.0",
      "CPL-1.0",
      "CPOL-1.02",
      "CUA-OPL-1.0",
      "Caldera",
      "ClArtistic",
      "Community-Spec-1.0",
      "Condor-1.1",
      "Crossword",
      "CrystalStacker",
      "Cube",
      "D-FSL-1.0",
      "DL-DE-BY-2.0",
      "DOC",
      "DRL-1.0",
      "DSDP",
      "Dotseqn",
      "ECL-1.0",
      "ECL-2.0",
      "EFL-1.0",
      "EFL-2.0",
      "EPICS",
      "EPL-1.0",
      "EPL-2.0",
      "EUDatagrid",
      "EUPL-1.0",
      "EUPL-1.1",
      "EUPL-1.2",
      "Elastic-2.0",
      "Entessa",
      "ErlPL-1.1",
      "Eurosym",
      "FDK-AAC",
      "FSFAP",
      "FSFUL",
      "FSFULLR",
      "FTL",
      "Fair",
      "Frameworx-1.0",
      "FreeBSD-DOC",
      "FreeImage",
      "GD",
      "GFDL-1.1-invariants-only",
      "GFDL-1.1-invariants-or-later",
      "GFDL-1.1-no-invariants-only",
      "GFDL-1.1-no-invariants-or-later",
      "GFDL-1.1-only",
      "GFDL-1.1-or-later",
      "GFDL-1.2-invariants-only",
      "GFDL-1.2-invariants-or-later",
      "GFDL-1.2-no-invariants-only",
      "GFDL-1.2-no-invariants-or-later",
      "GFDL-1.2-only",
      "GFDL-1.2-or-later",
      "GFDL-1.3-invariants-only",
      "GFDL-1.3-invariants-or-later",
      "GFDL-1.3-no-invariants-only",
      "GFDL-1.3-no-invariants-or-later",
      "GFDL-1.3-only",
      "GFDL-1.3-or-later",
      "GL2PS",
      "GLWTPL",
      "GPL-1.0-only",
      "GPL-1.0-or-later",
      "GPL-2.0-only",
      "GPL-2.0-or-later",
      "GPL-3.0-only",
      "GPL-3.0-or-later",
      "Giftware",
      "Glide",
      "Glulxe",
      "HPND",
      "HPND-sell-variant",
      "HTMLTIDY",
      "HaskellReport",
      "Hippocratic-2.1",
      "IBM-pibs",
      "ICU",
      "IJG",
      "IPA",
      "IPL-1.0",
      "ISC",
      "ImageMagick",
      "Imlib2",
      "Info-ZIP",
      "Intel",
      "Intel-ACPI",
      "Interbase-1.0",
      "JPNIC",
      "JSON",
      "Jam",
      "JasPer-2.0",
      "LAL-1.2",
      "LAL-1.3",
      "LGPL-2.0-only",
      "LGPL-2.0-or-later",
      "LGPL-2.1-only",
      "LGPL-2.1-or-later",
      "LGPL-3.0-only",
      "LGPL-3.0-or-later",
      "LGPLLR",
      "LPL-1.0",
      "LPL-1.02",
      "LPPL-1.0",
      "LPPL-1.1",
      "LPPL-1.2",
      "LPPL-1.3a",
      "LPPL-1.3c",
      "LZMA-SDK-9.11-to-9.20",
      "LZMA-SDK-9.22",
      "Latex2e",
      "Leptonica",
      "LiLiQ-P-1.1",
      "LiLiQ-R-1.1",
      "LiLiQ-Rplus-1.1",
      "Libpng",
      "Linux-OpenIB",
      "Linux-man-pages-copyleft",
      "MIT",
      "MIT-0",
      "MIT-CMU",
      "MIT-Modern-Variant",
      "MIT-advertising",
      "MIT-enna",
      "MIT-feh",
      "MIT-open-group",
      "MITNFA",
      "MPL-1.0",
      "MPL-1.1",
      "MPL-2.0",
      "MPL-2.0-no-copyleft-exception",
      "MS-LPL",
      "MS-PL",
      "MS-RL",
      "MTLL",
      "MakeIndex",
      "Minpack",
      "MirOS",
      "Motosoto",
      "MulanPSL-1.0",
      "MulanPSL-2.0",
      "Multics",
      "Mup",
      "NAIST-2003",
      "NASA-1.3",
      "NBPL-1.0",
      "NCGL-UK-2.0",
      "NCSA",
      "NGPL",
      "NICTA-1.0",
      "NIST-PD",
      "NIST-PD-fallback",
      "NLOD-1.0",
      "NLOD-2.0",
      "NLPL",
      "NOSL",
      "NPL-1.0",
      "NPL-1.1",
      "NPOSL-3.0",
      "NRL",
      "NTP",
      "NTP-0",
      "Naumen",
      "Net-SNMP",
      "NetCDF",
      "Newsletr",
      "Nokia",
      "Noweb",
      "O-UDA-1.0",
      "OCCT-PL",
      "OCLC-2.0",
      "ODC-By-1.0",
      "ODbL-1.0",
      "OFL-1.0",
      "OFL-1.0-RFN",
      "OFL-1.0-no-RFN",
      "OFL-1.1",
      "OFL-1.1-RFN",
      "OFL-1.1-no-RFN",
      "OGC-1.0",
      "OGDL-Taiwan-1.0",
      "OGL-Canada-2.0",
      "OGL-UK-1.0",
      "OGL-UK-2.0",
      "OGL-UK-3.0",
      "OGTSL",
      "OLDAP-1.1",
      "OLDAP-1.2",
      "OLDAP-1.3",
      "OLDAP-1.4",
      "OLDAP-2.0",
      "OLDAP-2.0.1",
      "OLDAP-2.1",
      "OLDAP-2.2",
      "OLDAP-2.2.1",
      "OLDAP-2.2.2",
      "OLDAP-2.3",
      "OLDAP-2.4",
      "OLDAP-2.5",
      "OLDAP-2.6",
      "OLDAP-2.7",
      "OLDAP-2.8",
      "OML",
      "OPL-1.0",
      "OPUBL-1.0",
      "OSET-PL-2.1",
      "OSL-1.0",
      "OSL-1.1",
      "OSL-2.0",
      "OSL-2.1",
      "OSL-3.0",
      "OpenSSL",
      "PDDL-1.0",
      "PHP-3.0",
      "PHP-3.01",
      "PSF-2.0",
      "Parity-6.0.0",
      "Parity-7.0.0",
      "Plexus",
      "PolyForm-Noncommercial-1.0.0",
      "PolyForm-Small-Business-1.0.0",
      "PostgreSQL",
      "Python-2.0",
      "Python-2.0.1",
      "QPL-1.0",
      "Qhull",
      "RHeCos-1.1",
      "RPL-1.1",
      "RPL-1.5",
      "RPSL-1.0",
      "RSA-MD",
      "RSCPL",
      "Rdisc",
      "Ruby",
      "SAX-PD",
      "SCEA",
      "SGI-B-1.0",
      "SGI-B-1.1",
      "SGI-B-2.0",
      "SHL-0.5",
      "SHL-0.51",
      "SISSL",
      "SISSL-1.2",
      "SMLNJ",
      "SMPPL",
      "SNIA",
      "SPL-1.0",
      "SSH-OpenSSH",
      "SSH-short",
      "SSPL-1.0",
      "SWL",
      "Saxpath",
      "SchemeReport",
      "Sendmail",
      "Sendmail-8.23",
      "SimPL-2.0",
      "Sleepycat",
      "Spencer-86",
      "Spencer-94",
      "Spencer-99",
      "SugarCRM-1.1.3",
      "TAPR-OHL-1.0",
      "TCL",
      "TCP-wrappers",
      "TMate",
      "TORQUE-1.1",
      "TOSL",
      "TU-Berlin-1.0",
      "TU-Berlin-2.0",
      "UCL-1.0",
      "UPL-1.0",
      "Unicode-DFS-2015",
      "Unicode-DFS-2016",
      "Unicode-TOU",
      "Unlicense",
      "VOSTROM",
      "VSL-1.0",
      "Vim",
      "W3C",
      "W3C-19980720",
      "W3C-20150513",
      "WTFPL",
      "Watcom-1.0",
      "Wsuipa",
      "X11",
      "X11-distribute-modifications-variant",
      "XFree86-1.1",
      "XSkat",
      "Xerox",
      "Xnet",
      "YPL-1.0",
      "YPL-1.1",
      "ZPL-1.1",
      "ZPL-2.0",
      "ZPL-2.1",
      "Zed",
      "Zend-2.0",
      "Zimbra-1.3",
      "Zimbra-1.4",
      "Zlib",
      "blessing",
      "bzip2-1.0.6",
      "copyleft-next-0.3.0",
      "copyleft-next-0.3.1",
      "curl",
      "diffmark",
      "dvipdfm",
      "eGenix",
      "etalab-2.0",
      "gSOAP-1.3b",
      "gnuplot",
      "iMatix",
      "libpng-2.0",
      "libselinux-1.0",
      "libtiff",
      "mpi-permissive",
      "mpich2",
      "mplus",
      "psfrag",
      "psutils",
      "xinetd",
      "xpp",
      "zlib-acknowledgement"
    ];
  }
});

// ../../node_modules/.pnpm/spdx-exceptions@2.3.0/node_modules/spdx-exceptions/index.json
var require_spdx_exceptions = __commonJS({
  "../../node_modules/.pnpm/spdx-exceptions@2.3.0/node_modules/spdx-exceptions/index.json"(exports2, module2) {
    module2.exports = [
      "389-exception",
      "Autoconf-exception-2.0",
      "Autoconf-exception-3.0",
      "Bison-exception-2.2",
      "Bootloader-exception",
      "Classpath-exception-2.0",
      "CLISP-exception-2.0",
      "DigiRule-FOSS-exception",
      "eCos-exception-2.0",
      "Fawkes-Runtime-exception",
      "FLTK-exception",
      "Font-exception-2.0",
      "freertos-exception-2.0",
      "GCC-exception-2.0",
      "GCC-exception-3.1",
      "gnu-javamail-exception",
      "GPL-3.0-linking-exception",
      "GPL-3.0-linking-source-exception",
      "GPL-CC-1.0",
      "i2p-gpl-java-exception",
      "Libtool-exception",
      "Linux-syscall-note",
      "LLVM-exception",
      "LZMA-exception",
      "mif-exception",
      "Nokia-Qt-exception-1.1",
      "OCaml-LGPL-linking-exception",
      "OCCT-exception-1.0",
      "OpenJDK-assembly-exception-1.0",
      "openvpn-openssl-exception",
      "PS-or-PDF-font-exception-20170817",
      "Qt-GPL-exception-1.0",
      "Qt-LGPL-exception-1.1",
      "Qwt-exception-1.0",
      "Swift-exception",
      "u-boot-exception-2.0",
      "Universal-FOSS-exception-1.0",
      "WxWindows-exception-3.1"
    ];
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/scan.js
var require_scan = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/scan.js"(exports2, module2) {
    "use strict";
    var licenses = [].concat(require_spdx_license_ids()).concat(require_spdx_license_ids());
    var exceptions = require_spdx_exceptions();
    module2.exports = function(source) {
      var index2 = 0;
      function hasMore() {
        return index2 < source.length;
      }
      __name(hasMore, "hasMore");
      function read(value) {
        if (value instanceof RegExp) {
          var chars2 = source.slice(index2);
          var match4 = chars2.match(value);
          if (match4) {
            index2 += match4[0].length;
            return match4[0];
          }
        } else {
          if (source.indexOf(value, index2) === index2) {
            index2 += value.length;
            return value;
          }
        }
      }
      __name(read, "read");
      function skipWhitespace() {
        read(/[ ]*/);
      }
      __name(skipWhitespace, "skipWhitespace");
      function operator() {
        var string;
        var possibilities = ["WITH", "AND", "OR", "(", ")", ":", "+"];
        for (var i3 = 0; i3 < possibilities.length; i3++) {
          string = read(possibilities[i3]);
          if (string) {
            break;
          }
        }
        if (string === "+" && index2 > 1 && source[index2 - 2] === " ") {
          throw new Error("Space before `+`");
        }
        return string && {
          type: "OPERATOR",
          string
        };
      }
      __name(operator, "operator");
      function idstring() {
        return read(/[A-Za-z0-9-.]+/);
      }
      __name(idstring, "idstring");
      function expectIdstring() {
        var string = idstring();
        if (!string) {
          throw new Error("Expected idstring at offset " + index2);
        }
        return string;
      }
      __name(expectIdstring, "expectIdstring");
      function documentRef() {
        if (read("DocumentRef-")) {
          var string = expectIdstring();
          return { type: "DOCUMENTREF", string };
        }
      }
      __name(documentRef, "documentRef");
      function licenseRef() {
        if (read("LicenseRef-")) {
          var string = expectIdstring();
          return { type: "LICENSEREF", string };
        }
      }
      __name(licenseRef, "licenseRef");
      function identifier() {
        var begin = index2;
        var string = idstring();
        if (licenses.indexOf(string) !== -1) {
          return {
            type: "LICENSE",
            string
          };
        } else if (exceptions.indexOf(string) !== -1) {
          return {
            type: "EXCEPTION",
            string
          };
        }
        index2 = begin;
      }
      __name(identifier, "identifier");
      function parseToken() {
        return operator() || documentRef() || licenseRef() || identifier();
      }
      __name(parseToken, "parseToken");
      var tokens = [];
      while (hasMore()) {
        skipWhitespace();
        if (!hasMore()) {
          break;
        }
        var token = parseToken();
        if (!token) {
          throw new Error("Unexpected `" + source[index2] + "` at offset " + index2);
        }
        tokens.push(token);
      }
      return tokens;
    };
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/parse.js
var require_parse2 = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/parse.js"(exports2, module2) {
    "use strict";
    module2.exports = function(tokens) {
      var index2 = 0;
      function hasMore() {
        return index2 < tokens.length;
      }
      __name(hasMore, "hasMore");
      function token() {
        return hasMore() ? tokens[index2] : null;
      }
      __name(token, "token");
      function next() {
        if (!hasMore()) {
          throw new Error();
        }
        index2++;
      }
      __name(next, "next");
      function parseOperator(operator) {
        var t5 = token();
        if (t5 && t5.type === "OPERATOR" && operator === t5.string) {
          next();
          return t5.string;
        }
      }
      __name(parseOperator, "parseOperator");
      function parseWith() {
        if (parseOperator("WITH")) {
          var t5 = token();
          if (t5 && t5.type === "EXCEPTION") {
            next();
            return t5.string;
          }
          throw new Error("Expected exception after `WITH`");
        }
      }
      __name(parseWith, "parseWith");
      function parseLicenseRef() {
        var begin = index2;
        var string = "";
        var t5 = token();
        if (t5.type === "DOCUMENTREF") {
          next();
          string += "DocumentRef-" + t5.string + ":";
          if (!parseOperator(":")) {
            throw new Error("Expected `:` after `DocumentRef-...`");
          }
        }
        t5 = token();
        if (t5.type === "LICENSEREF") {
          next();
          string += "LicenseRef-" + t5.string;
          return { license: string };
        }
        index2 = begin;
      }
      __name(parseLicenseRef, "parseLicenseRef");
      function parseLicense() {
        var t5 = token();
        if (t5 && t5.type === "LICENSE") {
          next();
          var node2 = { license: t5.string };
          if (parseOperator("+")) {
            node2.plus = true;
          }
          var exception = parseWith();
          if (exception) {
            node2.exception = exception;
          }
          return node2;
        }
      }
      __name(parseLicense, "parseLicense");
      function parseParenthesizedExpression() {
        var left4 = parseOperator("(");
        if (!left4) {
          return;
        }
        var expr = parseExpression();
        if (!parseOperator(")")) {
          throw new Error("Expected `)`");
        }
        return expr;
      }
      __name(parseParenthesizedExpression, "parseParenthesizedExpression");
      function parseAtom() {
        return parseParenthesizedExpression() || parseLicenseRef() || parseLicense();
      }
      __name(parseAtom, "parseAtom");
      function makeBinaryOpParser(operator, nextParser) {
        return /* @__PURE__ */ __name(function parseBinaryOp() {
          var left4 = nextParser();
          if (!left4) {
            return;
          }
          if (!parseOperator(operator)) {
            return left4;
          }
          var right5 = parseBinaryOp();
          if (!right5) {
            throw new Error("Expected expression");
          }
          return {
            left: left4,
            conjunction: operator.toLowerCase(),
            right: right5
          };
        }, "parseBinaryOp");
      }
      __name(makeBinaryOpParser, "makeBinaryOpParser");
      var parseAnd = makeBinaryOpParser("AND", parseAtom);
      var parseExpression = makeBinaryOpParser("OR", parseAnd);
      var node = parseExpression();
      if (!node || hasMore()) {
        throw new Error("Syntax error");
      }
      return node;
    };
  }
});

// ../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/index.js
var require_spdx_expression_parse = __commonJS({
  "../../node_modules/.pnpm/spdx-expression-parse@3.0.1/node_modules/spdx-expression-parse/index.js"(exports2, module2) {
    "use strict";
    var scan = require_scan();
    var parse2 = require_parse2();
    module2.exports = function(source) {
      return parse2(scan(source));
    };
  }
});

// ../../node_modules/.pnpm/spdx-correct@3.1.1/node_modules/spdx-correct/index.js
var require_spdx_correct = __commonJS({
  "../../node_modules/.pnpm/spdx-correct@3.1.1/node_modules/spdx-correct/index.js"(exports2, module2) {
    var parse2 = require_spdx_expression_parse();
    var spdxLicenseIds = require_spdx_license_ids();
    function valid(string) {
      try {
        parse2(string);
        return true;
      } catch (error2) {
        return false;
      }
    }
    __name(valid, "valid");
    var transpositions = [
      ["APGL", "AGPL"],
      ["Gpl", "GPL"],
      ["GLP", "GPL"],
      ["APL", "Apache"],
      ["ISD", "ISC"],
      ["GLP", "GPL"],
      ["IST", "ISC"],
      ["Claude", "Clause"],
      [" or later", "+"],
      [" International", ""],
      ["GNU", "GPL"],
      ["GUN", "GPL"],
      ["+", ""],
      ["GNU GPL", "GPL"],
      ["GNU/GPL", "GPL"],
      ["GNU GLP", "GPL"],
      ["GNU General Public License", "GPL"],
      ["Gnu public license", "GPL"],
      ["GNU Public License", "GPL"],
      ["GNU GENERAL PUBLIC LICENSE", "GPL"],
      ["MTI", "MIT"],
      ["Mozilla Public License", "MPL"],
      ["Universal Permissive License", "UPL"],
      ["WTH", "WTF"],
      ["-License", ""]
    ];
    var TRANSPOSED = 0;
    var CORRECT = 1;
    var transforms = [
      function(argument) {
        return argument.toUpperCase();
      },
      function(argument) {
        return argument.trim();
      },
      function(argument) {
        return argument.replace(/\./g, "");
      },
      function(argument) {
        return argument.replace(/\s+/g, "");
      },
      function(argument) {
        return argument.replace(/\s+/g, "-");
      },
      function(argument) {
        return argument.replace("v", "-");
      },
      function(argument) {
        return argument.replace(/,?\s*(\d)/, "-$1");
      },
      function(argument) {
        return argument.replace(/,?\s*(\d)/, "-$1.0");
      },
      function(argument) {
        return argument.replace(/,?\s*(V\.|v\.|V|v|Version|version)\s*(\d)/, "-$2");
      },
      function(argument) {
        return argument.replace(/,?\s*(V\.|v\.|V|v|Version|version)\s*(\d)/, "-$2.0");
      },
      function(argument) {
        return argument[0].toUpperCase() + argument.slice(1);
      },
      function(argument) {
        return argument.replace("/", "-");
      },
      function(argument) {
        return argument.replace(/\s*V\s*(\d)/, "-$1").replace(/(\d)$/, "$1.0");
      },
      function(argument) {
        if (argument.indexOf("3.0") !== -1) {
          return argument + "-or-later";
        } else {
          return argument + "-only";
        }
      },
      function(argument) {
        return argument + "only";
      },
      function(argument) {
        return argument.replace(/(\d)$/, "-$1.0");
      },
      function(argument) {
        return argument.replace(/(-| )?(\d)$/, "-$2-Clause");
      },
      function(argument) {
        return argument.replace(/(-| )clause(-| )(\d)/, "-$3-Clause");
      },
      function(argument) {
        return argument.replace(/\b(Modified|New|Revised)(-| )?BSD((-| )License)?/i, "BSD-3-Clause");
      },
      function(argument) {
        return argument.replace(/\bSimplified(-| )?BSD((-| )License)?/i, "BSD-2-Clause");
      },
      function(argument) {
        return argument.replace(/\b(Free|Net)(-| )?BSD((-| )License)?/i, "BSD-2-Clause-$1BSD");
      },
      function(argument) {
        return argument.replace(/\bClear(-| )?BSD((-| )License)?/i, "BSD-3-Clause-Clear");
      },
      function(argument) {
        return argument.replace(/\b(Old|Original)(-| )?BSD((-| )License)?/i, "BSD-4-Clause");
      },
      function(argument) {
        return "CC-" + argument;
      },
      function(argument) {
        return "CC-" + argument + "-4.0";
      },
      function(argument) {
        return argument.replace("Attribution", "BY").replace("NonCommercial", "NC").replace("NoDerivatives", "ND").replace(/ (\d)/, "-$1").replace(/ ?International/, "");
      },
      function(argument) {
        return "CC-" + argument.replace("Attribution", "BY").replace("NonCommercial", "NC").replace("NoDerivatives", "ND").replace(/ (\d)/, "-$1").replace(/ ?International/, "") + "-4.0";
      }
    ];
    var licensesWithVersions = spdxLicenseIds.map(function(id) {
      var match4 = /^(.*)-\d+\.\d+$/.exec(id);
      return match4 ? [match4[0], match4[1]] : [id, null];
    }).reduce(function(objectMap, item) {
      var key = item[1];
      objectMap[key] = objectMap[key] || [];
      objectMap[key].push(item[0]);
      return objectMap;
    }, {});
    var licensesWithOneVersion = Object.keys(licensesWithVersions).map(/* @__PURE__ */ __name(function makeEntries(key) {
      return [key, licensesWithVersions[key]];
    }, "makeEntries")).filter(/* @__PURE__ */ __name(function identifySoleVersions(item) {
      return item[1].length === 1 && item[0] !== null && item[0] !== "APL";
    }, "identifySoleVersions")).map(/* @__PURE__ */ __name(function createLastResorts(item) {
      return [item[0], item[1][0]];
    }, "createLastResorts"));
    licensesWithVersions = void 0;
    var lastResorts = [
      ["UNLI", "Unlicense"],
      ["WTF", "WTFPL"],
      ["2 CLAUSE", "BSD-2-Clause"],
      ["2-CLAUSE", "BSD-2-Clause"],
      ["3 CLAUSE", "BSD-3-Clause"],
      ["3-CLAUSE", "BSD-3-Clause"],
      ["AFFERO", "AGPL-3.0-or-later"],
      ["AGPL", "AGPL-3.0-or-later"],
      ["APACHE", "Apache-2.0"],
      ["ARTISTIC", "Artistic-2.0"],
      ["Affero", "AGPL-3.0-or-later"],
      ["BEER", "Beerware"],
      ["BOOST", "BSL-1.0"],
      ["BSD", "BSD-2-Clause"],
      ["CDDL", "CDDL-1.1"],
      ["ECLIPSE", "EPL-1.0"],
      ["FUCK", "WTFPL"],
      ["GNU", "GPL-3.0-or-later"],
      ["LGPL", "LGPL-3.0-or-later"],
      ["GPLV1", "GPL-1.0-only"],
      ["GPL-1", "GPL-1.0-only"],
      ["GPLV2", "GPL-2.0-only"],
      ["GPL-2", "GPL-2.0-only"],
      ["GPL", "GPL-3.0-or-later"],
      ["MIT +NO-FALSE-ATTRIBS", "MITNFA"],
      ["MIT", "MIT"],
      ["MPL", "MPL-2.0"],
      ["X11", "X11"],
      ["ZLIB", "Zlib"]
    ].concat(licensesWithOneVersion);
    var SUBSTRING = 0;
    var IDENTIFIER = 1;
    var validTransformation = /* @__PURE__ */ __name(function(identifier) {
      for (var i3 = 0; i3 < transforms.length; i3++) {
        var transformed = transforms[i3](identifier).trim();
        if (transformed !== identifier && valid(transformed)) {
          return transformed;
        }
      }
      return null;
    }, "validTransformation");
    var validLastResort = /* @__PURE__ */ __name(function(identifier) {
      var upperCased = identifier.toUpperCase();
      for (var i3 = 0; i3 < lastResorts.length; i3++) {
        var lastResort = lastResorts[i3];
        if (upperCased.indexOf(lastResort[SUBSTRING]) > -1) {
          return lastResort[IDENTIFIER];
        }
      }
      return null;
    }, "validLastResort");
    var anyCorrection = /* @__PURE__ */ __name(function(identifier, check3) {
      for (var i3 = 0; i3 < transpositions.length; i3++) {
        var transposition = transpositions[i3];
        var transposed = transposition[TRANSPOSED];
        if (identifier.indexOf(transposed) > -1) {
          var corrected = identifier.replace(
            transposed,
            transposition[CORRECT]
          );
          var checked = check3(corrected);
          if (checked !== null) {
            return checked;
          }
        }
      }
      return null;
    }, "anyCorrection");
    module2.exports = function(identifier, options2) {
      options2 = options2 || {};
      var upgrade = options2.upgrade === void 0 ? true : !!options2.upgrade;
      function postprocess(value) {
        return upgrade ? upgradeGPLs(value) : value;
      }
      __name(postprocess, "postprocess");
      var validArugment = typeof identifier === "string" && identifier.trim().length !== 0;
      if (!validArugment) {
        throw Error("Invalid argument. Expected non-empty string.");
      }
      identifier = identifier.trim();
      if (valid(identifier)) {
        return postprocess(identifier);
      }
      var noPlus = identifier.replace(/\+$/, "").trim();
      if (valid(noPlus)) {
        return postprocess(noPlus);
      }
      var transformed = validTransformation(identifier);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = anyCorrection(identifier, function(argument) {
        if (valid(argument)) {
          return argument;
        }
        return validTransformation(argument);
      });
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = validLastResort(identifier);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      transformed = anyCorrection(identifier, validLastResort);
      if (transformed !== null) {
        return postprocess(transformed);
      }
      return null;
    };
    function upgradeGPLs(value) {
      if ([
        "GPL-1.0",
        "LGPL-1.0",
        "AGPL-1.0",
        "GPL-2.0",
        "LGPL-2.0",
        "AGPL-2.0",
        "LGPL-2.1"
      ].indexOf(value) !== -1) {
        return value + "-only";
      } else if ([
        "GPL-1.0+",
        "GPL-2.0+",
        "GPL-3.0+",
        "LGPL-2.0+",
        "LGPL-2.1+",
        "LGPL-3.0+",
        "AGPL-1.0+",
        "AGPL-3.0+"
      ].indexOf(value) !== -1) {
        return value.replace(/\+$/, "-or-later");
      } else if (["GPL-3.0", "LGPL-3.0", "AGPL-3.0"].indexOf(value) !== -1) {
        return value + "-or-later";
      } else {
        return value;
      }
    }
    __name(upgradeGPLs, "upgradeGPLs");
  }
});

// ../../node_modules/.pnpm/validate-npm-package-license@3.0.4/node_modules/validate-npm-package-license/index.js
var require_validate_npm_package_license = __commonJS({
  "../../node_modules/.pnpm/validate-npm-package-license@3.0.4/node_modules/validate-npm-package-license/index.js"(exports2, module2) {
    var parse2 = require_spdx_expression_parse();
    var correct = require_spdx_correct();
    var genericWarning = 'license should be a valid SPDX license expression (without "LicenseRef"), "UNLICENSED", or "SEE LICENSE IN <filename>"';
    var fileReferenceRE = /^SEE LICEN[CS]E IN (.+)$/;
    function startsWith(prefix, string) {
      return string.slice(0, prefix.length) === prefix;
    }
    __name(startsWith, "startsWith");
    function usesLicenseRef(ast) {
      if (ast.hasOwnProperty("license")) {
        var license = ast.license;
        return startsWith("LicenseRef", license) || startsWith("DocumentRef", license);
      } else {
        return usesLicenseRef(ast.left) || usesLicenseRef(ast.right);
      }
    }
    __name(usesLicenseRef, "usesLicenseRef");
    module2.exports = function(argument) {
      var ast;
      try {
        ast = parse2(argument);
      } catch (e3) {
        var match4;
        if (argument === "UNLICENSED" || argument === "UNLICENCED") {
          return {
            validForOldPackages: true,
            validForNewPackages: true,
            unlicensed: true
          };
        } else if (match4 = fileReferenceRE.exec(argument)) {
          return {
            validForOldPackages: true,
            validForNewPackages: true,
            inFile: match4[1]
          };
        } else {
          var result = {
            validForOldPackages: false,
            validForNewPackages: false,
            warnings: [genericWarning]
          };
          if (argument.trim().length !== 0) {
            var corrected = correct(argument);
            if (corrected) {
              result.warnings.push(
                'license is similar to the valid expression "' + corrected + '"'
              );
            }
          }
          return result;
        }
      }
      if (usesLicenseRef(ast)) {
        return {
          validForNewPackages: false,
          validForOldPackages: false,
          spdx: true,
          warnings: [genericWarning]
        };
      } else {
        return {
          validForNewPackages: true,
          validForOldPackages: true,
          spdx: true
        };
      }
    };
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host-info.js
var require_git_host_info = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host-info.js"(exports2, module2) {
    "use strict";
    var gitHosts = module2.exports = {
      github: {
        "protocols": ["git", "http", "git+ssh", "git+https", "ssh", "https"],
        "domain": "github.com",
        "treepath": "tree",
        "filetemplate": "https://{auth@}raw.githubusercontent.com/{user}/{project}/{committish}/{path}",
        "bugstemplate": "https://{domain}/{user}/{project}/issues",
        "gittemplate": "git://{auth@}{domain}/{user}/{project}.git{#committish}",
        "tarballtemplate": "https://codeload.{domain}/{user}/{project}/tar.gz/{committish}"
      },
      bitbucket: {
        "protocols": ["git+ssh", "git+https", "ssh", "https"],
        "domain": "bitbucket.org",
        "treepath": "src",
        "tarballtemplate": "https://{domain}/{user}/{project}/get/{committish}.tar.gz"
      },
      gitlab: {
        "protocols": ["git+ssh", "git+https", "ssh", "https"],
        "domain": "gitlab.com",
        "treepath": "tree",
        "bugstemplate": "https://{domain}/{user}/{project}/issues",
        "httpstemplate": "git+https://{auth@}{domain}/{user}/{projectPath}.git{#committish}",
        "tarballtemplate": "https://{domain}/{user}/{project}/repository/archive.tar.gz?ref={committish}",
        "pathmatch": /^[/]([^/]+)[/]((?!.*(\/-\/|\/repository\/archive\.tar\.gz\?=.*|\/repository\/[^/]+\/archive.tar.gz$)).*?)(?:[.]git|[/])?$/
      },
      gist: {
        "protocols": ["git", "git+ssh", "git+https", "ssh", "https"],
        "domain": "gist.github.com",
        "pathmatch": /^[/](?:([^/]+)[/])?([a-z0-9]{32,})(?:[.]git)?$/,
        "filetemplate": "https://gist.githubusercontent.com/{user}/{project}/raw{/committish}/{path}",
        "bugstemplate": "https://{domain}/{project}",
        "gittemplate": "git://{domain}/{project}.git{#committish}",
        "sshtemplate": "git@{domain}:/{project}.git{#committish}",
        "sshurltemplate": "git+ssh://git@{domain}/{project}.git{#committish}",
        "browsetemplate": "https://{domain}/{project}{/committish}",
        "browsefiletemplate": "https://{domain}/{project}{/committish}{#path}",
        "docstemplate": "https://{domain}/{project}{/committish}",
        "httpstemplate": "git+https://{domain}/{project}.git{#committish}",
        "shortcuttemplate": "{type}:{project}{#committish}",
        "pathtemplate": "{project}{#committish}",
        "tarballtemplate": "https://codeload.github.com/gist/{project}/tar.gz/{committish}",
        "hashformat": function(fragment) {
          return "file-" + formatHashFragment(fragment);
        }
      }
    };
    var gitHostDefaults = {
      "sshtemplate": "git@{domain}:{user}/{project}.git{#committish}",
      "sshurltemplate": "git+ssh://git@{domain}/{user}/{project}.git{#committish}",
      "browsetemplate": "https://{domain}/{user}/{project}{/tree/committish}",
      "browsefiletemplate": "https://{domain}/{user}/{project}/{treepath}/{committish}/{path}{#fragment}",
      "docstemplate": "https://{domain}/{user}/{project}{/tree/committish}#readme",
      "httpstemplate": "git+https://{auth@}{domain}/{user}/{project}.git{#committish}",
      "filetemplate": "https://{domain}/{user}/{project}/raw/{committish}/{path}",
      "shortcuttemplate": "{type}:{user}/{project}{#committish}",
      "pathtemplate": "{user}/{project}{#committish}",
      "pathmatch": /^[/]([^/]+)[/]([^/]+?)(?:[.]git|[/])?$/,
      "hashformat": formatHashFragment
    };
    Object.keys(gitHosts).forEach(function(name) {
      Object.keys(gitHostDefaults).forEach(function(key) {
        if (gitHosts[name][key])
          return;
        gitHosts[name][key] = gitHostDefaults[key];
      });
      gitHosts[name].protocols_re = RegExp("^(" + gitHosts[name].protocols.map(function(protocol) {
        return protocol.replace(/([\\+*{}()[\]$^|])/g, "\\$1");
      }).join("|") + "):$");
    });
    function formatHashFragment(fragment) {
      return fragment.toLowerCase().replace(/^\W+|\/|\W+$/g, "").replace(/\W+/g, "-");
    }
    __name(formatHashFragment, "formatHashFragment");
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host.js
var require_git_host = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/git-host.js"(exports2, module2) {
    "use strict";
    var gitHosts = require_git_host_info();
    var extend = Object.assign || /* @__PURE__ */ __name(function _extend(target, source) {
      if (source === null || typeof source !== "object")
        return target;
      var keys = Object.keys(source);
      var i3 = keys.length;
      while (i3--) {
        target[keys[i3]] = source[keys[i3]];
      }
      return target;
    }, "_extend");
    module2.exports = GitHost;
    function GitHost(type, user, auth, project, committish, defaultRepresentation, opts2) {
      var gitHostInfo = this;
      gitHostInfo.type = type;
      Object.keys(gitHosts[type]).forEach(function(key) {
        gitHostInfo[key] = gitHosts[type][key];
      });
      gitHostInfo.user = user;
      gitHostInfo.auth = auth;
      gitHostInfo.project = project;
      gitHostInfo.committish = committish;
      gitHostInfo.default = defaultRepresentation;
      gitHostInfo.opts = opts2 || {};
    }
    __name(GitHost, "GitHost");
    GitHost.prototype.hash = function() {
      return this.committish ? "#" + this.committish : "";
    };
    GitHost.prototype._fill = function(template, opts2) {
      if (!template)
        return;
      var vars = extend({}, opts2);
      vars.path = vars.path ? vars.path.replace(/^[/]+/g, "") : "";
      opts2 = extend(extend({}, this.opts), opts2);
      var self2 = this;
      Object.keys(this).forEach(function(key) {
        if (self2[key] != null && vars[key] == null)
          vars[key] = self2[key];
      });
      var rawAuth = vars.auth;
      var rawcommittish = vars.committish;
      var rawFragment = vars.fragment;
      var rawPath = vars.path;
      var rawProject = vars.project;
      Object.keys(vars).forEach(function(key) {
        var value = vars[key];
        if ((key === "path" || key === "project") && typeof value === "string") {
          vars[key] = value.split("/").map(function(pathComponent) {
            return encodeURIComponent(pathComponent);
          }).join("/");
        } else {
          vars[key] = encodeURIComponent(value);
        }
      });
      vars["auth@"] = rawAuth ? rawAuth + "@" : "";
      vars["#fragment"] = rawFragment ? "#" + this.hashformat(rawFragment) : "";
      vars.fragment = vars.fragment ? vars.fragment : "";
      vars["#path"] = rawPath ? "#" + this.hashformat(rawPath) : "";
      vars["/path"] = vars.path ? "/" + vars.path : "";
      vars.projectPath = rawProject.split("/").map(encodeURIComponent).join("/");
      if (opts2.noCommittish) {
        vars["#committish"] = "";
        vars["/tree/committish"] = "";
        vars["/committish"] = "";
        vars.committish = "";
      } else {
        vars["#committish"] = rawcommittish ? "#" + rawcommittish : "";
        vars["/tree/committish"] = vars.committish ? "/" + vars.treepath + "/" + vars.committish : "";
        vars["/committish"] = vars.committish ? "/" + vars.committish : "";
        vars.committish = vars.committish || "master";
      }
      var res = template;
      Object.keys(vars).forEach(function(key) {
        res = res.replace(new RegExp("[{]" + key + "[}]", "g"), vars[key]);
      });
      if (opts2.noGitPlus) {
        return res.replace(/^git[+]/, "");
      } else {
        return res;
      }
    };
    GitHost.prototype.ssh = function(opts2) {
      return this._fill(this.sshtemplate, opts2);
    };
    GitHost.prototype.sshurl = function(opts2) {
      return this._fill(this.sshurltemplate, opts2);
    };
    GitHost.prototype.browse = function(P, F, opts2) {
      if (typeof P === "string") {
        if (typeof F !== "string") {
          opts2 = F;
          F = null;
        }
        return this._fill(this.browsefiletemplate, extend({
          fragment: F,
          path: P
        }, opts2));
      } else {
        return this._fill(this.browsetemplate, P);
      }
    };
    GitHost.prototype.docs = function(opts2) {
      return this._fill(this.docstemplate, opts2);
    };
    GitHost.prototype.bugs = function(opts2) {
      return this._fill(this.bugstemplate, opts2);
    };
    GitHost.prototype.https = function(opts2) {
      return this._fill(this.httpstemplate, opts2);
    };
    GitHost.prototype.git = function(opts2) {
      return this._fill(this.gittemplate, opts2);
    };
    GitHost.prototype.shortcut = function(opts2) {
      return this._fill(this.shortcuttemplate, opts2);
    };
    GitHost.prototype.path = function(opts2) {
      return this._fill(this.pathtemplate, opts2);
    };
    GitHost.prototype.tarball = function(opts_) {
      var opts2 = extend({}, opts_, { noCommittish: false });
      return this._fill(this.tarballtemplate, opts2);
    };
    GitHost.prototype.file = function(P, opts2) {
      return this._fill(this.filetemplate, extend({ path: P }, opts2));
    };
    GitHost.prototype.getDefaultRepresentation = function() {
      return this.default;
    };
    GitHost.prototype.toString = function(opts2) {
      if (this.default && typeof this[this.default] === "function")
        return this[this.default](opts2);
      return this.sshurl(opts2);
    };
  }
});

// ../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/index.js
var require_hosted_git_info = __commonJS({
  "../../node_modules/.pnpm/hosted-git-info@2.8.9/node_modules/hosted-git-info/index.js"(exports2, module2) {
    "use strict";
    var url = require("url");
    var gitHosts = require_git_host_info();
    var GitHost = module2.exports = require_git_host();
    var protocolToRepresentationMap = {
      "git+ssh:": "sshurl",
      "git+https:": "https",
      "ssh:": "sshurl",
      "git:": "git"
    };
    function protocolToRepresentation(protocol) {
      return protocolToRepresentationMap[protocol] || protocol.slice(0, -1);
    }
    __name(protocolToRepresentation, "protocolToRepresentation");
    var authProtocols = {
      "git:": true,
      "https:": true,
      "git+https:": true,
      "http:": true,
      "git+http:": true
    };
    var cache = {};
    module2.exports.fromUrl = function(giturl, opts2) {
      if (typeof giturl !== "string")
        return;
      var key = giturl + JSON.stringify(opts2 || {});
      if (!(key in cache)) {
        cache[key] = fromUrl(giturl, opts2);
      }
      return cache[key];
    };
    function fromUrl(giturl, opts2) {
      if (giturl == null || giturl === "")
        return;
      var url2 = fixupUnqualifiedGist(
        isGitHubShorthand(giturl) ? "github:" + giturl : giturl
      );
      var parsed = parseGitUrl(url2);
      var shortcutMatch = url2.match(/^([^:]+):(?:[^@]+@)?(?:([^/]*)\/)?([^#]+)/);
      var matches = Object.keys(gitHosts).map(function(gitHostName) {
        try {
          var gitHostInfo = gitHosts[gitHostName];
          var auth = null;
          if (parsed.auth && authProtocols[parsed.protocol]) {
            auth = parsed.auth;
          }
          var committish = parsed.hash ? decodeURIComponent(parsed.hash.substr(1)) : null;
          var user = null;
          var project = null;
          var defaultRepresentation = null;
          if (shortcutMatch && shortcutMatch[1] === gitHostName) {
            user = shortcutMatch[2] && decodeURIComponent(shortcutMatch[2]);
            project = decodeURIComponent(shortcutMatch[3].replace(/\.git$/, ""));
            defaultRepresentation = "shortcut";
          } else {
            if (parsed.host && parsed.host !== gitHostInfo.domain && parsed.host.replace(/^www[.]/, "") !== gitHostInfo.domain)
              return;
            if (!gitHostInfo.protocols_re.test(parsed.protocol))
              return;
            if (!parsed.path)
              return;
            var pathmatch = gitHostInfo.pathmatch;
            var matched = parsed.path.match(pathmatch);
            if (!matched)
              return;
            if (matched[1] !== null && matched[1] !== void 0) {
              user = decodeURIComponent(matched[1].replace(/^:/, ""));
            }
            project = decodeURIComponent(matched[2]);
            defaultRepresentation = protocolToRepresentation(parsed.protocol);
          }
          return new GitHost(gitHostName, user, auth, project, committish, defaultRepresentation, opts2);
        } catch (ex) {
          if (ex instanceof URIError) {
          } else
            throw ex;
        }
      }).filter(function(gitHostInfo) {
        return gitHostInfo;
      });
      if (matches.length !== 1)
        return;
      return matches[0];
    }
    __name(fromUrl, "fromUrl");
    function isGitHubShorthand(arg2) {
      return /^[^:@%/\s.-][^:@%/\s]*[/][^:@\s/%]+(?:#.*)?$/.test(arg2);
    }
    __name(isGitHubShorthand, "isGitHubShorthand");
    function fixupUnqualifiedGist(giturl) {
      var parsed = url.parse(giturl);
      if (parsed.protocol === "gist:" && parsed.host && !parsed.path) {
        return parsed.protocol + "/" + parsed.host;
      } else {
        return giturl;
      }
    }
    __name(fixupUnqualifiedGist, "fixupUnqualifiedGist");
    function parseGitUrl(giturl) {
      var matched = giturl.match(/^([^@]+)@([^:/]+):[/]?((?:[^/]+[/])?[^/]+?)(?:[.]git)?(#.*)?$/);
      if (!matched) {
        var legacy = url.parse(giturl);
        if (legacy.auth && typeof url.URL === "function") {
          var authmatch = giturl.match(/[^@]+@[^:/]+/);
          if (authmatch) {
            var whatwg = new url.URL(authmatch[0]);
            legacy.auth = whatwg.username || "";
            if (whatwg.password)
              legacy.auth += ":" + whatwg.password;
          }
        }
        return legacy;
      }
      return {
        protocol: "git+ssh:",
        slashes: true,
        auth: matched[1],
        host: matched[2],
        port: null,
        hostname: matched[2],
        hash: matched[4],
        search: null,
        query: null,
        pathname: "/" + matched[3],
        path: "/" + matched[3],
        href: "git+ssh://" + matched[1] + "@" + matched[2] + "/" + matched[3] + (matched[4] || "")
      };
    }
    __name(parseGitUrl, "parseGitUrl");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/homedir.js
var require_homedir = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/homedir.js"(exports2, module2) {
    "use strict";
    var os6 = require("os");
    module2.exports = os6.homedir || /* @__PURE__ */ __name(function homedir2() {
      var home = process.env.HOME;
      var user = process.env.LOGNAME || process.env.USER || process.env.LNAME || process.env.USERNAME;
      if (process.platform === "win32") {
        return process.env.USERPROFILE || process.env.HOMEDRIVE + process.env.HOMEPATH || home || null;
      }
      if (process.platform === "darwin") {
        return home || (user ? "/Users/" + user : null);
      }
      if (process.platform === "linux") {
        return home || (process.getuid() === 0 ? "/root" : user ? "/home/" + user : null);
      }
      return home || null;
    }, "homedir");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/caller.js
var require_caller = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/caller.js"(exports2, module2) {
    module2.exports = function() {
      var origPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(_2, stack3) {
        return stack3;
      };
      var stack2 = new Error().stack;
      Error.prepareStackTrace = origPrepareStackTrace;
      return stack2[2].getFileName();
    };
  }
});

// ../../node_modules/.pnpm/path-parse@1.0.7/node_modules/path-parse/index.js
var require_path_parse = __commonJS({
  "../../node_modules/.pnpm/path-parse@1.0.7/node_modules/path-parse/index.js"(exports2, module2) {
    "use strict";
    var isWindows2 = process.platform === "win32";
    var splitWindowsRe = /^(((?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?[\\\/]?)(?:[^\\\/]*[\\\/])*)((\.{1,2}|[^\\\/]+?|)(\.[^.\/\\]*|))[\\\/]*$/;
    var win32 = {};
    function win32SplitPath(filename) {
      return splitWindowsRe.exec(filename).slice(1);
    }
    __name(win32SplitPath, "win32SplitPath");
    win32.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = win32SplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0] === allParts[1] ? allParts[0] : allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    var splitPathRe = /^((\/?)(?:[^\/]*\/)*)((\.{1,2}|[^\/]+?|)(\.[^.\/]*|))[\/]*$/;
    var posix = {};
    function posixSplitPath(filename) {
      return splitPathRe.exec(filename).slice(1);
    }
    __name(posixSplitPath, "posixSplitPath");
    posix.parse = function(pathString) {
      if (typeof pathString !== "string") {
        throw new TypeError(
          "Parameter 'pathString' must be a string, not " + typeof pathString
        );
      }
      var allParts = posixSplitPath(pathString);
      if (!allParts || allParts.length !== 5) {
        throw new TypeError("Invalid path '" + pathString + "'");
      }
      return {
        root: allParts[1],
        dir: allParts[0].slice(0, -1),
        base: allParts[2],
        ext: allParts[4],
        name: allParts[3]
      };
    };
    if (isWindows2)
      module2.exports = win32.parse;
    else
      module2.exports = posix.parse;
    module2.exports.posix = posix.parse;
    module2.exports.win32 = win32.parse;
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/node-modules-paths.js
var require_node_modules_paths = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/node-modules-paths.js"(exports2, module2) {
    var path32 = require("path");
    var parse2 = path32.parse || require_path_parse();
    var getNodeModulesDirs = /* @__PURE__ */ __name(function getNodeModulesDirs2(absoluteStart, modules) {
      var prefix = "/";
      if (/^([A-Za-z]:)/.test(absoluteStart)) {
        prefix = "";
      } else if (/^\\\\/.test(absoluteStart)) {
        prefix = "\\\\";
      }
      var paths2 = [absoluteStart];
      var parsed = parse2(absoluteStart);
      while (parsed.dir !== paths2[paths2.length - 1]) {
        paths2.push(parsed.dir);
        parsed = parse2(parsed.dir);
      }
      return paths2.reduce(function(dirs, aPath) {
        return dirs.concat(modules.map(function(moduleDir) {
          return path32.resolve(prefix, aPath, moduleDir);
        }));
      }, []);
    }, "getNodeModulesDirs");
    module2.exports = /* @__PURE__ */ __name(function nodeModulesPaths(start, opts2, request2) {
      var modules = opts2 && opts2.moduleDirectory ? [].concat(opts2.moduleDirectory) : ["node_modules"];
      if (opts2 && typeof opts2.paths === "function") {
        return opts2.paths(
          request2,
          start,
          function() {
            return getNodeModulesDirs(start, modules);
          },
          opts2
        );
      }
      var dirs = getNodeModulesDirs(start, modules);
      return opts2 && opts2.paths ? dirs.concat(opts2.paths) : dirs;
    }, "nodeModulesPaths");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/normalize-options.js
var require_normalize_options = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/normalize-options.js"(exports2, module2) {
    module2.exports = function(x, opts2) {
      return opts2 || {};
    };
  }
});

// ../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/implementation.js
var require_implementation = __commonJS({
  "../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/implementation.js"(exports2, module2) {
    "use strict";
    var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
    var slice = Array.prototype.slice;
    var toStr = Object.prototype.toString;
    var funcType = "[object Function]";
    module2.exports = /* @__PURE__ */ __name(function bind(that) {
      var target = this;
      if (typeof target !== "function" || toStr.call(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
      }
      var args3 = slice.call(arguments, 1);
      var bound;
      var binder = /* @__PURE__ */ __name(function() {
        if (this instanceof bound) {
          var result = target.apply(
            this,
            args3.concat(slice.call(arguments))
          );
          if (Object(result) === result) {
            return result;
          }
          return this;
        } else {
          return target.apply(
            that,
            args3.concat(slice.call(arguments))
          );
        }
      }, "binder");
      var boundLength = Math.max(0, target.length - args3.length);
      var boundArgs = [];
      for (var i3 = 0; i3 < boundLength; i3++) {
        boundArgs.push("$" + i3);
      }
      bound = Function("binder", "return function (" + boundArgs.join(",") + "){ return binder.apply(this,arguments); }")(binder);
      if (target.prototype) {
        var Empty = /* @__PURE__ */ __name(function Empty2() {
        }, "Empty");
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
      }
      return bound;
    }, "bind");
  }
});

// ../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/index.js
var require_function_bind = __commonJS({
  "../../node_modules/.pnpm/function-bind@1.1.1/node_modules/function-bind/index.js"(exports2, module2) {
    "use strict";
    var implementation = require_implementation();
    module2.exports = Function.prototype.bind || implementation;
  }
});

// ../../node_modules/.pnpm/has@1.0.3/node_modules/has/src/index.js
var require_src2 = __commonJS({
  "../../node_modules/.pnpm/has@1.0.3/node_modules/has/src/index.js"(exports2, module2) {
    "use strict";
    var bind = require_function_bind();
    module2.exports = bind.call(Function.call, Object.prototype.hasOwnProperty);
  }
});

// ../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/core.json
var require_core2 = __commonJS({
  "../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      "inspector/promises": [">= 19"],
      "node:inspector/promises": [">= 19"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "node:test": [">= 16.17 && < 17", ">= 18"],
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: ">= 13.4 && < 13.5",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// ../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/index.js
var require_is_core_module = __commonJS({
  "../../node_modules/.pnpm/is-core-module@2.11.0/node_modules/is-core-module/index.js"(exports2, module2) {
    "use strict";
    var has = require_src2();
    function specifierIncluded(current, specifier) {
      var nodeParts = current.split(".");
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i3 = 0; i3 < 3; ++i3) {
        var cur = parseInt(nodeParts[i3] || 0, 10);
        var ver = parseInt(versionParts[i3] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        }
        if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    __name(specifierIncluded, "specifierIncluded");
    function matchesRange(current, range2) {
      var specifiers = range2.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i3 = 0; i3 < specifiers.length; ++i3) {
        if (!specifierIncluded(current, specifiers[i3])) {
          return false;
        }
      }
      return true;
    }
    __name(matchesRange, "matchesRange");
    function versionIncluded(nodeVersion, specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      var current = typeof nodeVersion === "undefined" ? process.versions && process.versions.node : nodeVersion;
      if (typeof current !== "string") {
        throw new TypeError(typeof nodeVersion === "undefined" ? "Unable to determine current node version" : "If provided, a valid node version is required");
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i3 = 0; i3 < specifierValue.length; ++i3) {
          if (matchesRange(current, specifierValue[i3])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(current, specifierValue);
    }
    __name(versionIncluded, "versionIncluded");
    var data = require_core2();
    module2.exports = /* @__PURE__ */ __name(function isCore(x, nodeVersion) {
      return has(data, x) && versionIncluded(nodeVersion, data[x]);
    }, "isCore");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/async.js
var require_async = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/async.js"(exports2, module2) {
    var fs37 = require("fs");
    var getHomedir = require_homedir();
    var path32 = require("path");
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var isCore = require_is_core_module();
    var realpathFS = process.platform !== "win32" && fs37.realpath && typeof fs37.realpath.native === "function" ? fs37.realpath.native : fs37.realpath;
    var homedir2 = getHomedir();
    var defaultPaths = /* @__PURE__ */ __name(function() {
      return [
        path32.join(homedir2, ".node_modules"),
        path32.join(homedir2, ".node_libraries")
      ];
    }, "defaultPaths");
    var defaultIsFile = /* @__PURE__ */ __name(function isFile(file2, cb) {
      fs37.stat(file2, function(err, stat2) {
        if (!err) {
          return cb(null, stat2.isFile() || stat2.isFIFO());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    }, "isFile");
    var defaultIsDir = /* @__PURE__ */ __name(function isDirectory(dir3, cb) {
      fs37.stat(dir3, function(err, stat2) {
        if (!err) {
          return cb(null, stat2.isDirectory());
        }
        if (err.code === "ENOENT" || err.code === "ENOTDIR")
          return cb(null, false);
        return cb(err);
      });
    }, "isDirectory");
    var defaultRealpath = /* @__PURE__ */ __name(function realpath(x, cb) {
      realpathFS(x, function(realpathErr, realPath2) {
        if (realpathErr && realpathErr.code !== "ENOENT")
          cb(realpathErr);
        else
          cb(null, realpathErr ? x : realPath2);
      });
    }, "realpath");
    var maybeRealpath = /* @__PURE__ */ __name(function maybeRealpath2(realpath, x, opts2, cb) {
      if (opts2 && opts2.preserveSymlinks === false) {
        realpath(x, cb);
      } else {
        cb(null, x);
      }
    }, "maybeRealpath");
    var defaultReadPackage = /* @__PURE__ */ __name(function defaultReadPackage2(readFile7, pkgfile, cb) {
      readFile7(pkgfile, function(readFileErr, body) {
        if (readFileErr)
          cb(readFileErr);
        else {
          try {
            var pkg2 = JSON.parse(body);
            cb(null, pkg2);
          } catch (jsonErr) {
            cb(null);
          }
        }
      });
    }, "defaultReadPackage");
    var getPackageCandidates = /* @__PURE__ */ __name(function getPackageCandidates2(x, start, opts2) {
      var dirs = nodeModulesPaths(start, opts2, x);
      for (var i3 = 0; i3 < dirs.length; i3++) {
        dirs[i3] = path32.join(dirs[i3], x);
      }
      return dirs;
    }, "getPackageCandidates");
    module2.exports = /* @__PURE__ */ __name(function resolve2(x, options2, callback) {
      var cb = callback;
      var opts2 = options2;
      if (typeof options2 === "function") {
        cb = opts2;
        opts2 = {};
      }
      if (typeof x !== "string") {
        var err = new TypeError("Path must be a string.");
        return process.nextTick(function() {
          cb(err);
        });
      }
      opts2 = normalizeOptions(x, opts2);
      var isFile = opts2.isFile || defaultIsFile;
      var isDirectory = opts2.isDirectory || defaultIsDir;
      var readFile7 = opts2.readFile || fs37.readFile;
      var realpath = opts2.realpath || defaultRealpath;
      var readPackage = opts2.readPackage || defaultReadPackage;
      if (opts2.readFile && opts2.readPackage) {
        var conflictErr = new TypeError("`readFile` and `readPackage` are mutually exclusive.");
        return process.nextTick(function() {
          cb(conflictErr);
        });
      }
      var packageIterator = opts2.packageIterator;
      var extensions = opts2.extensions || [".js"];
      var includeCoreModules = opts2.includeCoreModules !== false;
      var basedir = opts2.basedir || path32.dirname(caller());
      var parent2 = opts2.filename || basedir;
      opts2.paths = opts2.paths || defaultPaths();
      var absoluteStart = path32.resolve(basedir);
      maybeRealpath(
        realpath,
        absoluteStart,
        opts2,
        function(err2, realStart) {
          if (err2)
            cb(err2);
          else
            init(realStart);
        }
      );
      var res;
      function init(basedir2) {
        if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
          res = path32.resolve(basedir2, x);
          if (x === "." || x === ".." || x.slice(-1) === "/")
            res += "/";
          if (/\/$/.test(x) && res === basedir2) {
            loadAsDirectory(res, opts2.package, onfile);
          } else
            loadAsFile(res, opts2.package, onfile);
        } else if (includeCoreModules && isCore(x)) {
          return cb(null, x);
        } else
          loadNodeModules(x, basedir2, function(err2, n3, pkg2) {
            if (err2)
              cb(err2);
            else if (n3) {
              return maybeRealpath(realpath, n3, opts2, function(err3, realN) {
                if (err3) {
                  cb(err3);
                } else {
                  cb(null, realN, pkg2);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent2 + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      __name(init, "init");
      function onfile(err2, m4, pkg2) {
        if (err2)
          cb(err2);
        else if (m4)
          cb(null, m4, pkg2);
        else
          loadAsDirectory(res, function(err3, d4, pkg3) {
            if (err3)
              cb(err3);
            else if (d4) {
              maybeRealpath(realpath, d4, opts2, function(err4, realD) {
                if (err4) {
                  cb(err4);
                } else {
                  cb(null, realD, pkg3);
                }
              });
            } else {
              var moduleError = new Error("Cannot find module '" + x + "' from '" + parent2 + "'");
              moduleError.code = "MODULE_NOT_FOUND";
              cb(moduleError);
            }
          });
      }
      __name(onfile, "onfile");
      function loadAsFile(x2, thePackage, callback2) {
        var loadAsFilePackage = thePackage;
        var cb2 = callback2;
        if (typeof loadAsFilePackage === "function") {
          cb2 = loadAsFilePackage;
          loadAsFilePackage = void 0;
        }
        var exts = [""].concat(extensions);
        load(exts, x2, loadAsFilePackage);
        function load(exts2, x3, loadPackage) {
          if (exts2.length === 0)
            return cb2(null, void 0, loadPackage);
          var file2 = x3 + exts2[0];
          var pkg2 = loadPackage;
          if (pkg2)
            onpkg(null, pkg2);
          else
            loadpkg(path32.dirname(file2), onpkg);
          function onpkg(err2, pkg_, dir3) {
            pkg2 = pkg_;
            if (err2)
              return cb2(err2);
            if (dir3 && pkg2 && opts2.pathFilter) {
              var rfile = path32.relative(dir3, file2);
              var rel = rfile.slice(0, rfile.length - exts2[0].length);
              var r3 = opts2.pathFilter(pkg2, x3, rel);
              if (r3)
                return load(
                  [""].concat(extensions.slice()),
                  path32.resolve(dir3, r3),
                  pkg2
                );
            }
            isFile(file2, onex);
          }
          __name(onpkg, "onpkg");
          function onex(err2, ex) {
            if (err2)
              return cb2(err2);
            if (ex)
              return cb2(null, file2, pkg2);
            load(exts2.slice(1), x3, pkg2);
          }
          __name(onex, "onex");
        }
        __name(load, "load");
      }
      __name(loadAsFile, "loadAsFile");
      function loadpkg(dir3, cb2) {
        if (dir3 === "" || dir3 === "/")
          return cb2(null);
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir3)) {
          return cb2(null);
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir3))
          return cb2(null);
        maybeRealpath(realpath, dir3, opts2, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return loadpkg(path32.dirname(dir3), cb2);
          var pkgfile = path32.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (!ex)
              return loadpkg(path32.dirname(dir3), cb2);
            readPackage(readFile7, pkgfile, function(err3, pkgParam) {
              if (err3)
                cb2(err3);
              var pkg2 = pkgParam;
              if (pkg2 && opts2.packageFilter) {
                pkg2 = opts2.packageFilter(pkg2, pkgfile);
              }
              cb2(null, pkg2, dir3);
            });
          });
        });
      }
      __name(loadpkg, "loadpkg");
      function loadAsDirectory(x2, loadAsDirectoryPackage, callback2) {
        var cb2 = callback2;
        var fpkg = loadAsDirectoryPackage;
        if (typeof fpkg === "function") {
          cb2 = fpkg;
          fpkg = opts2.package;
        }
        maybeRealpath(realpath, x2, opts2, function(unwrapErr, pkgdir) {
          if (unwrapErr)
            return cb2(unwrapErr);
          var pkgfile = path32.join(pkgdir, "package.json");
          isFile(pkgfile, function(err2, ex) {
            if (err2)
              return cb2(err2);
            if (!ex)
              return loadAsFile(path32.join(x2, "index"), fpkg, cb2);
            readPackage(readFile7, pkgfile, function(err3, pkgParam) {
              if (err3)
                return cb2(err3);
              var pkg2 = pkgParam;
              if (pkg2 && opts2.packageFilter) {
                pkg2 = opts2.packageFilter(pkg2, pkgfile);
              }
              if (pkg2 && pkg2.main) {
                if (typeof pkg2.main !== "string") {
                  var mainError = new TypeError("package \u201C" + pkg2.name + "\u201D `main` must be a string");
                  mainError.code = "INVALID_PACKAGE_MAIN";
                  return cb2(mainError);
                }
                if (pkg2.main === "." || pkg2.main === "./") {
                  pkg2.main = "index";
                }
                loadAsFile(path32.resolve(x2, pkg2.main), pkg2, function(err4, m4, pkg3) {
                  if (err4)
                    return cb2(err4);
                  if (m4)
                    return cb2(null, m4, pkg3);
                  if (!pkg3)
                    return loadAsFile(path32.join(x2, "index"), pkg3, cb2);
                  var dir3 = path32.resolve(x2, pkg3.main);
                  loadAsDirectory(dir3, pkg3, function(err5, n3, pkg4) {
                    if (err5)
                      return cb2(err5);
                    if (n3)
                      return cb2(null, n3, pkg4);
                    loadAsFile(path32.join(x2, "index"), pkg4, cb2);
                  });
                });
                return;
              }
              loadAsFile(path32.join(x2, "/index"), pkg2, cb2);
            });
          });
        });
      }
      __name(loadAsDirectory, "loadAsDirectory");
      function processDirs(cb2, dirs) {
        if (dirs.length === 0)
          return cb2(null, void 0);
        var dir3 = dirs[0];
        isDirectory(path32.dirname(dir3), isdir);
        function isdir(err2, isdir2) {
          if (err2)
            return cb2(err2);
          if (!isdir2)
            return processDirs(cb2, dirs.slice(1));
          loadAsFile(dir3, opts2.package, onfile2);
        }
        __name(isdir, "isdir");
        function onfile2(err2, m4, pkg2) {
          if (err2)
            return cb2(err2);
          if (m4)
            return cb2(null, m4, pkg2);
          loadAsDirectory(dir3, opts2.package, ondir);
        }
        __name(onfile2, "onfile");
        function ondir(err2, n3, pkg2) {
          if (err2)
            return cb2(err2);
          if (n3)
            return cb2(null, n3, pkg2);
          processDirs(cb2, dirs.slice(1));
        }
        __name(ondir, "ondir");
      }
      __name(processDirs, "processDirs");
      function loadNodeModules(x2, start, cb2) {
        var thunk = /* @__PURE__ */ __name(function() {
          return getPackageCandidates(x2, start, opts2);
        }, "thunk");
        processDirs(
          cb2,
          packageIterator ? packageIterator(x2, start, thunk, opts2) : thunk()
        );
      }
      __name(loadNodeModules, "loadNodeModules");
    }, "resolve");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.json
var require_core3 = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.json"(exports2, module2) {
    module2.exports = {
      assert: true,
      "node:assert": [">= 14.18 && < 15", ">= 16"],
      "assert/strict": ">= 15",
      "node:assert/strict": ">= 16",
      async_hooks: ">= 8",
      "node:async_hooks": [">= 14.18 && < 15", ">= 16"],
      buffer_ieee754: ">= 0.5 && < 0.9.7",
      buffer: true,
      "node:buffer": [">= 14.18 && < 15", ">= 16"],
      child_process: true,
      "node:child_process": [">= 14.18 && < 15", ">= 16"],
      cluster: ">= 0.5",
      "node:cluster": [">= 14.18 && < 15", ">= 16"],
      console: true,
      "node:console": [">= 14.18 && < 15", ">= 16"],
      constants: true,
      "node:constants": [">= 14.18 && < 15", ">= 16"],
      crypto: true,
      "node:crypto": [">= 14.18 && < 15", ">= 16"],
      _debug_agent: ">= 1 && < 8",
      _debugger: "< 8",
      dgram: true,
      "node:dgram": [">= 14.18 && < 15", ">= 16"],
      diagnostics_channel: [">= 14.17 && < 15", ">= 15.1"],
      "node:diagnostics_channel": [">= 14.18 && < 15", ">= 16"],
      dns: true,
      "node:dns": [">= 14.18 && < 15", ">= 16"],
      "dns/promises": ">= 15",
      "node:dns/promises": ">= 16",
      domain: ">= 0.7.12",
      "node:domain": [">= 14.18 && < 15", ">= 16"],
      events: true,
      "node:events": [">= 14.18 && < 15", ">= 16"],
      freelist: "< 6",
      fs: true,
      "node:fs": [">= 14.18 && < 15", ">= 16"],
      "fs/promises": [">= 10 && < 10.1", ">= 14"],
      "node:fs/promises": [">= 14.18 && < 15", ">= 16"],
      _http_agent: ">= 0.11.1",
      "node:_http_agent": [">= 14.18 && < 15", ">= 16"],
      _http_client: ">= 0.11.1",
      "node:_http_client": [">= 14.18 && < 15", ">= 16"],
      _http_common: ">= 0.11.1",
      "node:_http_common": [">= 14.18 && < 15", ">= 16"],
      _http_incoming: ">= 0.11.1",
      "node:_http_incoming": [">= 14.18 && < 15", ">= 16"],
      _http_outgoing: ">= 0.11.1",
      "node:_http_outgoing": [">= 14.18 && < 15", ">= 16"],
      _http_server: ">= 0.11.1",
      "node:_http_server": [">= 14.18 && < 15", ">= 16"],
      http: true,
      "node:http": [">= 14.18 && < 15", ">= 16"],
      http2: ">= 8.8",
      "node:http2": [">= 14.18 && < 15", ">= 16"],
      https: true,
      "node:https": [">= 14.18 && < 15", ">= 16"],
      inspector: ">= 8",
      "node:inspector": [">= 14.18 && < 15", ">= 16"],
      _linklist: "< 8",
      module: true,
      "node:module": [">= 14.18 && < 15", ">= 16"],
      net: true,
      "node:net": [">= 14.18 && < 15", ">= 16"],
      "node-inspect/lib/_inspect": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_client": ">= 7.6 && < 12",
      "node-inspect/lib/internal/inspect_repl": ">= 7.6 && < 12",
      os: true,
      "node:os": [">= 14.18 && < 15", ">= 16"],
      path: true,
      "node:path": [">= 14.18 && < 15", ">= 16"],
      "path/posix": ">= 15.3",
      "node:path/posix": ">= 16",
      "path/win32": ">= 15.3",
      "node:path/win32": ">= 16",
      perf_hooks: ">= 8.5",
      "node:perf_hooks": [">= 14.18 && < 15", ">= 16"],
      process: ">= 1",
      "node:process": [">= 14.18 && < 15", ">= 16"],
      punycode: ">= 0.5",
      "node:punycode": [">= 14.18 && < 15", ">= 16"],
      querystring: true,
      "node:querystring": [">= 14.18 && < 15", ">= 16"],
      readline: true,
      "node:readline": [">= 14.18 && < 15", ">= 16"],
      "readline/promises": ">= 17",
      "node:readline/promises": ">= 17",
      repl: true,
      "node:repl": [">= 14.18 && < 15", ">= 16"],
      smalloc: ">= 0.11.5 && < 3",
      _stream_duplex: ">= 0.9.4",
      "node:_stream_duplex": [">= 14.18 && < 15", ">= 16"],
      _stream_transform: ">= 0.9.4",
      "node:_stream_transform": [">= 14.18 && < 15", ">= 16"],
      _stream_wrap: ">= 1.4.1",
      "node:_stream_wrap": [">= 14.18 && < 15", ">= 16"],
      _stream_passthrough: ">= 0.9.4",
      "node:_stream_passthrough": [">= 14.18 && < 15", ">= 16"],
      _stream_readable: ">= 0.9.4",
      "node:_stream_readable": [">= 14.18 && < 15", ">= 16"],
      _stream_writable: ">= 0.9.4",
      "node:_stream_writable": [">= 14.18 && < 15", ">= 16"],
      stream: true,
      "node:stream": [">= 14.18 && < 15", ">= 16"],
      "stream/consumers": ">= 16.7",
      "node:stream/consumers": ">= 16.7",
      "stream/promises": ">= 15",
      "node:stream/promises": ">= 16",
      "stream/web": ">= 16.5",
      "node:stream/web": ">= 16.5",
      string_decoder: true,
      "node:string_decoder": [">= 14.18 && < 15", ">= 16"],
      sys: [">= 0.4 && < 0.7", ">= 0.8"],
      "node:sys": [">= 14.18 && < 15", ">= 16"],
      "node:test": ">= 18",
      timers: true,
      "node:timers": [">= 14.18 && < 15", ">= 16"],
      "timers/promises": ">= 15",
      "node:timers/promises": ">= 16",
      _tls_common: ">= 0.11.13",
      "node:_tls_common": [">= 14.18 && < 15", ">= 16"],
      _tls_legacy: ">= 0.11.3 && < 10",
      _tls_wrap: ">= 0.11.3",
      "node:_tls_wrap": [">= 14.18 && < 15", ">= 16"],
      tls: true,
      "node:tls": [">= 14.18 && < 15", ">= 16"],
      trace_events: ">= 10",
      "node:trace_events": [">= 14.18 && < 15", ">= 16"],
      tty: true,
      "node:tty": [">= 14.18 && < 15", ">= 16"],
      url: true,
      "node:url": [">= 14.18 && < 15", ">= 16"],
      util: true,
      "node:util": [">= 14.18 && < 15", ">= 16"],
      "util/types": ">= 15.3",
      "node:util/types": ">= 16",
      "v8/tools/arguments": ">= 10 && < 12",
      "v8/tools/codemap": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/consarray": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/csvparser": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/logreader": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/profile_view": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      "v8/tools/splaytree": [">= 4.4 && < 5", ">= 5.2 && < 12"],
      v8: ">= 1",
      "node:v8": [">= 14.18 && < 15", ">= 16"],
      vm: true,
      "node:vm": [">= 14.18 && < 15", ">= 16"],
      wasi: ">= 13.4 && < 13.5",
      worker_threads: ">= 11.7",
      "node:worker_threads": [">= 14.18 && < 15", ">= 16"],
      zlib: ">= 0.5",
      "node:zlib": [">= 14.18 && < 15", ">= 16"]
    };
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.js
var require_core4 = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/core.js"(exports2, module2) {
    var current = process.versions && process.versions.node && process.versions.node.split(".") || [];
    function specifierIncluded(specifier) {
      var parts = specifier.split(" ");
      var op = parts.length > 1 ? parts[0] : "=";
      var versionParts = (parts.length > 1 ? parts[1] : parts[0]).split(".");
      for (var i3 = 0; i3 < 3; ++i3) {
        var cur = parseInt(current[i3] || 0, 10);
        var ver = parseInt(versionParts[i3] || 0, 10);
        if (cur === ver) {
          continue;
        }
        if (op === "<") {
          return cur < ver;
        } else if (op === ">=") {
          return cur >= ver;
        }
        return false;
      }
      return op === ">=";
    }
    __name(specifierIncluded, "specifierIncluded");
    function matchesRange(range2) {
      var specifiers = range2.split(/ ?&& ?/);
      if (specifiers.length === 0) {
        return false;
      }
      for (var i3 = 0; i3 < specifiers.length; ++i3) {
        if (!specifierIncluded(specifiers[i3])) {
          return false;
        }
      }
      return true;
    }
    __name(matchesRange, "matchesRange");
    function versionIncluded(specifierValue) {
      if (typeof specifierValue === "boolean") {
        return specifierValue;
      }
      if (specifierValue && typeof specifierValue === "object") {
        for (var i3 = 0; i3 < specifierValue.length; ++i3) {
          if (matchesRange(specifierValue[i3])) {
            return true;
          }
        }
        return false;
      }
      return matchesRange(specifierValue);
    }
    __name(versionIncluded, "versionIncluded");
    var data = require_core3();
    var core = {};
    for (mod in data) {
      if (Object.prototype.hasOwnProperty.call(data, mod)) {
        core[mod] = versionIncluded(data[mod]);
      }
    }
    var mod;
    module2.exports = core;
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/is-core.js
var require_is_core = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/is-core.js"(exports2, module2) {
    var isCoreModule = require_is_core_module();
    module2.exports = /* @__PURE__ */ __name(function isCore(x) {
      return isCoreModule(x);
    }, "isCore");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/sync.js
var require_sync = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/lib/sync.js"(exports2, module2) {
    var isCore = require_is_core_module();
    var fs37 = require("fs");
    var path32 = require("path");
    var getHomedir = require_homedir();
    var caller = require_caller();
    var nodeModulesPaths = require_node_modules_paths();
    var normalizeOptions = require_normalize_options();
    var realpathFS = process.platform !== "win32" && fs37.realpathSync && typeof fs37.realpathSync.native === "function" ? fs37.realpathSync.native : fs37.realpathSync;
    var homedir2 = getHomedir();
    var defaultPaths = /* @__PURE__ */ __name(function() {
      return [
        path32.join(homedir2, ".node_modules"),
        path32.join(homedir2, ".node_libraries")
      ];
    }, "defaultPaths");
    var defaultIsFile = /* @__PURE__ */ __name(function isFile(file2) {
      try {
        var stat2 = fs37.statSync(file2, { throwIfNoEntry: false });
      } catch (e3) {
        if (e3 && (e3.code === "ENOENT" || e3.code === "ENOTDIR"))
          return false;
        throw e3;
      }
      return !!stat2 && (stat2.isFile() || stat2.isFIFO());
    }, "isFile");
    var defaultIsDir = /* @__PURE__ */ __name(function isDirectory(dir3) {
      try {
        var stat2 = fs37.statSync(dir3, { throwIfNoEntry: false });
      } catch (e3) {
        if (e3 && (e3.code === "ENOENT" || e3.code === "ENOTDIR"))
          return false;
        throw e3;
      }
      return !!stat2 && stat2.isDirectory();
    }, "isDirectory");
    var defaultRealpathSync = /* @__PURE__ */ __name(function realpathSync(x) {
      try {
        return realpathFS(x);
      } catch (realpathErr) {
        if (realpathErr.code !== "ENOENT") {
          throw realpathErr;
        }
      }
      return x;
    }, "realpathSync");
    var maybeRealpathSync = /* @__PURE__ */ __name(function maybeRealpathSync2(realpathSync, x, opts2) {
      if (opts2 && opts2.preserveSymlinks === false) {
        return realpathSync(x);
      }
      return x;
    }, "maybeRealpathSync");
    var defaultReadPackageSync = /* @__PURE__ */ __name(function defaultReadPackageSync2(readFileSync, pkgfile) {
      var body = readFileSync(pkgfile);
      try {
        var pkg2 = JSON.parse(body);
        return pkg2;
      } catch (jsonErr) {
      }
    }, "defaultReadPackageSync");
    var getPackageCandidates = /* @__PURE__ */ __name(function getPackageCandidates2(x, start, opts2) {
      var dirs = nodeModulesPaths(start, opts2, x);
      for (var i3 = 0; i3 < dirs.length; i3++) {
        dirs[i3] = path32.join(dirs[i3], x);
      }
      return dirs;
    }, "getPackageCandidates");
    module2.exports = /* @__PURE__ */ __name(function resolveSync(x, options2) {
      if (typeof x !== "string") {
        throw new TypeError("Path must be a string.");
      }
      var opts2 = normalizeOptions(x, options2);
      var isFile = opts2.isFile || defaultIsFile;
      var readFileSync = opts2.readFileSync || fs37.readFileSync;
      var isDirectory = opts2.isDirectory || defaultIsDir;
      var realpathSync = opts2.realpathSync || defaultRealpathSync;
      var readPackageSync = opts2.readPackageSync || defaultReadPackageSync;
      if (opts2.readFileSync && opts2.readPackageSync) {
        throw new TypeError("`readFileSync` and `readPackageSync` are mutually exclusive.");
      }
      var packageIterator = opts2.packageIterator;
      var extensions = opts2.extensions || [".js"];
      var includeCoreModules = opts2.includeCoreModules !== false;
      var basedir = opts2.basedir || path32.dirname(caller());
      var parent2 = opts2.filename || basedir;
      opts2.paths = opts2.paths || defaultPaths();
      var absoluteStart = maybeRealpathSync(realpathSync, path32.resolve(basedir), opts2);
      if (/^(?:\.\.?(?:\/|$)|\/|([A-Za-z]:)?[/\\])/.test(x)) {
        var res = path32.resolve(absoluteStart, x);
        if (x === "." || x === ".." || x.slice(-1) === "/")
          res += "/";
        var m4 = loadAsFileSync(res) || loadAsDirectorySync(res);
        if (m4)
          return maybeRealpathSync(realpathSync, m4, opts2);
      } else if (includeCoreModules && isCore(x)) {
        return x;
      } else {
        var n3 = loadNodeModulesSync(x, absoluteStart);
        if (n3)
          return maybeRealpathSync(realpathSync, n3, opts2);
      }
      var err = new Error("Cannot find module '" + x + "' from '" + parent2 + "'");
      err.code = "MODULE_NOT_FOUND";
      throw err;
      function loadAsFileSync(x2) {
        var pkg2 = loadpkg(path32.dirname(x2));
        if (pkg2 && pkg2.dir && pkg2.pkg && opts2.pathFilter) {
          var rfile = path32.relative(pkg2.dir, x2);
          var r3 = opts2.pathFilter(pkg2.pkg, x2, rfile);
          if (r3) {
            x2 = path32.resolve(pkg2.dir, r3);
          }
        }
        if (isFile(x2)) {
          return x2;
        }
        for (var i3 = 0; i3 < extensions.length; i3++) {
          var file2 = x2 + extensions[i3];
          if (isFile(file2)) {
            return file2;
          }
        }
      }
      __name(loadAsFileSync, "loadAsFileSync");
      function loadpkg(dir3) {
        if (dir3 === "" || dir3 === "/")
          return;
        if (process.platform === "win32" && /^\w:[/\\]*$/.test(dir3)) {
          return;
        }
        if (/[/\\]node_modules[/\\]*$/.test(dir3))
          return;
        var pkgfile = path32.join(maybeRealpathSync(realpathSync, dir3, opts2), "package.json");
        if (!isFile(pkgfile)) {
          return loadpkg(path32.dirname(dir3));
        }
        var pkg2 = readPackageSync(readFileSync, pkgfile);
        if (pkg2 && opts2.packageFilter) {
          pkg2 = opts2.packageFilter(pkg2, dir3);
        }
        return { pkg: pkg2, dir: dir3 };
      }
      __name(loadpkg, "loadpkg");
      function loadAsDirectorySync(x2) {
        var pkgfile = path32.join(maybeRealpathSync(realpathSync, x2, opts2), "/package.json");
        if (isFile(pkgfile)) {
          try {
            var pkg2 = readPackageSync(readFileSync, pkgfile);
          } catch (e3) {
          }
          if (pkg2 && opts2.packageFilter) {
            pkg2 = opts2.packageFilter(pkg2, x2);
          }
          if (pkg2 && pkg2.main) {
            if (typeof pkg2.main !== "string") {
              var mainError = new TypeError("package \u201C" + pkg2.name + "\u201D `main` must be a string");
              mainError.code = "INVALID_PACKAGE_MAIN";
              throw mainError;
            }
            if (pkg2.main === "." || pkg2.main === "./") {
              pkg2.main = "index";
            }
            try {
              var m5 = loadAsFileSync(path32.resolve(x2, pkg2.main));
              if (m5)
                return m5;
              var n4 = loadAsDirectorySync(path32.resolve(x2, pkg2.main));
              if (n4)
                return n4;
            } catch (e3) {
            }
          }
        }
        return loadAsFileSync(path32.join(x2, "/index"));
      }
      __name(loadAsDirectorySync, "loadAsDirectorySync");
      function loadNodeModulesSync(x2, start) {
        var thunk = /* @__PURE__ */ __name(function() {
          return getPackageCandidates(x2, start, opts2);
        }, "thunk");
        var dirs = packageIterator ? packageIterator(x2, start, thunk, opts2) : thunk();
        for (var i3 = 0; i3 < dirs.length; i3++) {
          var dir3 = dirs[i3];
          if (isDirectory(path32.dirname(dir3))) {
            var m5 = loadAsFileSync(dir3);
            if (m5)
              return m5;
            var n4 = loadAsDirectorySync(dir3);
            if (n4)
              return n4;
          }
        }
      }
      __name(loadNodeModulesSync, "loadNodeModulesSync");
    }, "resolveSync");
  }
});

// ../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/index.js
var require_resolve = __commonJS({
  "../../node_modules/.pnpm/resolve@1.22.1/node_modules/resolve/index.js"(exports2, module2) {
    var async = require_async();
    async.core = require_core4();
    async.isCore = require_is_core();
    async.sync = require_sync();
    module2.exports = async;
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/extract_description.js
var require_extract_description = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/extract_description.js"(exports2, module2) {
    module2.exports = extractDescription;
    function extractDescription(d4) {
      if (!d4)
        return;
      if (d4 === "ERROR: No README data found!")
        return;
      d4 = d4.trim().split("\n");
      for (var s4 = 0; d4[s4] && d4[s4].trim().match(/^(#|$)/); s4++)
        ;
      var l3 = d4.length;
      for (var e3 = s4 + 1; e3 < l3 && d4[e3].trim(); e3++)
        ;
      return d4.slice(s4, e3).join(" ").trim();
    }
    __name(extractDescription, "extractDescription");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/typos.json
var require_typos = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/typos.json"(exports2, module2) {
    module2.exports = {
      topLevel: {
        dependancies: "dependencies",
        dependecies: "dependencies",
        depdenencies: "dependencies",
        devEependencies: "devDependencies",
        depends: "dependencies",
        "dev-dependencies": "devDependencies",
        devDependences: "devDependencies",
        devDepenencies: "devDependencies",
        devdependencies: "devDependencies",
        repostitory: "repository",
        repo: "repository",
        prefereGlobal: "preferGlobal",
        hompage: "homepage",
        hampage: "homepage",
        autohr: "author",
        autor: "author",
        contributers: "contributors",
        publicationConfig: "publishConfig",
        script: "scripts"
      },
      bugs: { web: "url", name: "url" },
      script: { server: "start", tests: "test" }
    };
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/fixer.js
var require_fixer = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/fixer.js"(exports2, module2) {
    var semver2 = require_semver();
    var validateLicense = require_validate_npm_package_license();
    var hostedGitInfo = require_hosted_git_info();
    var isBuiltinModule = require_resolve().isCore;
    var depTypes = ["dependencies", "devDependencies", "optionalDependencies"];
    var extractDescription = require_extract_description();
    var url = require("url");
    var typos = require_typos();
    var fixer = module2.exports = {
      warn: function() {
      },
      fixRepositoryField: function(data) {
        if (data.repositories) {
          this.warn("repositories");
          data.repository = data.repositories[0];
        }
        if (!data.repository)
          return this.warn("missingRepository");
        if (typeof data.repository === "string") {
          data.repository = {
            type: "git",
            url: data.repository
          };
        }
        var r3 = data.repository.url || "";
        if (r3) {
          var hosted = hostedGitInfo.fromUrl(r3);
          if (hosted) {
            r3 = data.repository.url = hosted.getDefaultRepresentation() == "shortcut" ? hosted.https() : hosted.toString();
          }
        }
        if (r3.match(/github.com\/[^\/]+\/[^\/]+\.git\.git$/)) {
          this.warn("brokenGitUrl", r3);
        }
      },
      fixTypos: function(data) {
        Object.keys(typos.topLevel).forEach(function(d4) {
          if (data.hasOwnProperty(d4)) {
            this.warn("typo", d4, typos.topLevel[d4]);
          }
        }, this);
      },
      fixScriptsField: function(data) {
        if (!data.scripts)
          return;
        if (typeof data.scripts !== "object") {
          this.warn("nonObjectScripts");
          delete data.scripts;
          return;
        }
        Object.keys(data.scripts).forEach(function(k) {
          if (typeof data.scripts[k] !== "string") {
            this.warn("nonStringScript");
            delete data.scripts[k];
          } else if (typos.script[k] && !data.scripts[typos.script[k]]) {
            this.warn("typo", k, typos.script[k], "scripts");
          }
        }, this);
      },
      fixFilesField: function(data) {
        var files = data.files;
        if (files && !Array.isArray(files)) {
          this.warn("nonArrayFiles");
          delete data.files;
        } else if (data.files) {
          data.files = data.files.filter(function(file2) {
            if (!file2 || typeof file2 !== "string") {
              this.warn("invalidFilename", file2);
              return false;
            } else {
              return true;
            }
          }, this);
        }
      },
      fixBinField: function(data) {
        if (!data.bin)
          return;
        if (typeof data.bin === "string") {
          var b3 = {};
          var match4;
          if (match4 = data.name.match(/^@[^/]+[/](.*)$/)) {
            b3[match4[1]] = data.bin;
          } else {
            b3[data.name] = data.bin;
          }
          data.bin = b3;
        }
      },
      fixManField: function(data) {
        if (!data.man)
          return;
        if (typeof data.man === "string") {
          data.man = [data.man];
        }
      },
      fixBundleDependenciesField: function(data) {
        var bdd = "bundledDependencies";
        var bd = "bundleDependencies";
        if (data[bdd] && !data[bd]) {
          data[bd] = data[bdd];
          delete data[bdd];
        }
        if (data[bd] && !Array.isArray(data[bd])) {
          this.warn("nonArrayBundleDependencies");
          delete data[bd];
        } else if (data[bd]) {
          data[bd] = data[bd].filter(function(bd2) {
            if (!bd2 || typeof bd2 !== "string") {
              this.warn("nonStringBundleDependency", bd2);
              return false;
            } else {
              if (!data.dependencies) {
                data.dependencies = {};
              }
              if (!data.dependencies.hasOwnProperty(bd2)) {
                this.warn("nonDependencyBundleDependency", bd2);
                data.dependencies[bd2] = "*";
              }
              return true;
            }
          }, this);
        }
      },
      fixDependencies: function(data, strict) {
        var loose = !strict;
        objectifyDeps(data, this.warn);
        addOptionalDepsToDeps(data, this.warn);
        this.fixBundleDependenciesField(data);
        ["dependencies", "devDependencies"].forEach(function(deps) {
          if (!(deps in data))
            return;
          if (!data[deps] || typeof data[deps] !== "object") {
            this.warn("nonObjectDependencies", deps);
            delete data[deps];
            return;
          }
          Object.keys(data[deps]).forEach(function(d4) {
            var r3 = data[deps][d4];
            if (typeof r3 !== "string") {
              this.warn("nonStringDependency", d4, JSON.stringify(r3));
              delete data[deps][d4];
            }
            var hosted = hostedGitInfo.fromUrl(data[deps][d4]);
            if (hosted)
              data[deps][d4] = hosted.toString();
          }, this);
        }, this);
      },
      fixModulesField: function(data) {
        if (data.modules) {
          this.warn("deprecatedModules");
          delete data.modules;
        }
      },
      fixKeywordsField: function(data) {
        if (typeof data.keywords === "string") {
          data.keywords = data.keywords.split(/,\s+/);
        }
        if (data.keywords && !Array.isArray(data.keywords)) {
          delete data.keywords;
          this.warn("nonArrayKeywords");
        } else if (data.keywords) {
          data.keywords = data.keywords.filter(function(kw) {
            if (typeof kw !== "string" || !kw) {
              this.warn("nonStringKeyword");
              return false;
            } else {
              return true;
            }
          }, this);
        }
      },
      fixVersionField: function(data, strict) {
        var loose = !strict;
        if (!data.version) {
          data.version = "";
          return true;
        }
        if (!semver2.valid(data.version, loose)) {
          throw new Error('Invalid version: "' + data.version + '"');
        }
        data.version = semver2.clean(data.version, loose);
        return true;
      },
      fixPeople: function(data) {
        modifyPeople(data, unParsePerson);
        modifyPeople(data, parsePerson);
      },
      fixNameField: function(data, options2) {
        if (typeof options2 === "boolean")
          options2 = { strict: options2 };
        else if (typeof options2 === "undefined")
          options2 = {};
        var strict = options2.strict;
        if (!data.name && !strict) {
          data.name = "";
          return;
        }
        if (typeof data.name !== "string") {
          throw new Error("name field must be a string.");
        }
        if (!strict)
          data.name = data.name.trim();
        ensureValidName(data.name, strict, options2.allowLegacyCase);
        if (isBuiltinModule(data.name))
          this.warn("conflictingName", data.name);
      },
      fixDescriptionField: function(data) {
        if (data.description && typeof data.description !== "string") {
          this.warn("nonStringDescription");
          delete data.description;
        }
        if (data.readme && !data.description)
          data.description = extractDescription(data.readme);
        if (data.description === void 0)
          delete data.description;
        if (!data.description)
          this.warn("missingDescription");
      },
      fixReadmeField: function(data) {
        if (!data.readme) {
          this.warn("missingReadme");
          data.readme = "ERROR: No README data found!";
        }
      },
      fixBugsField: function(data) {
        if (!data.bugs && data.repository && data.repository.url) {
          var hosted = hostedGitInfo.fromUrl(data.repository.url);
          if (hosted && hosted.bugs()) {
            data.bugs = { url: hosted.bugs() };
          }
        } else if (data.bugs) {
          var emailRe = /^.+@.*\..+$/;
          if (typeof data.bugs == "string") {
            if (emailRe.test(data.bugs))
              data.bugs = { email: data.bugs };
            else if (url.parse(data.bugs).protocol)
              data.bugs = { url: data.bugs };
            else
              this.warn("nonEmailUrlBugsString");
          } else {
            bugsTypos(data.bugs, this.warn);
            var oldBugs = data.bugs;
            data.bugs = {};
            if (oldBugs.url) {
              if (typeof oldBugs.url == "string" && url.parse(oldBugs.url).protocol)
                data.bugs.url = oldBugs.url;
              else
                this.warn("nonUrlBugsUrlField");
            }
            if (oldBugs.email) {
              if (typeof oldBugs.email == "string" && emailRe.test(oldBugs.email))
                data.bugs.email = oldBugs.email;
              else
                this.warn("nonEmailBugsEmailField");
            }
          }
          if (!data.bugs.email && !data.bugs.url) {
            delete data.bugs;
            this.warn("emptyNormalizedBugs");
          }
        }
      },
      fixHomepageField: function(data) {
        if (!data.homepage && data.repository && data.repository.url) {
          var hosted = hostedGitInfo.fromUrl(data.repository.url);
          if (hosted && hosted.docs())
            data.homepage = hosted.docs();
        }
        if (!data.homepage)
          return;
        if (typeof data.homepage !== "string") {
          this.warn("nonUrlHomepage");
          return delete data.homepage;
        }
        if (!url.parse(data.homepage).protocol) {
          data.homepage = "http://" + data.homepage;
        }
      },
      fixLicenseField: function(data) {
        if (!data.license) {
          return this.warn("missingLicense");
        } else {
          if (typeof data.license !== "string" || data.license.length < 1 || data.license.trim() === "") {
            this.warn("invalidLicense");
          } else {
            if (!validateLicense(data.license).validForNewPackages)
              this.warn("invalidLicense");
          }
        }
      }
    };
    function isValidScopedPackageName(spec) {
      if (spec.charAt(0) !== "@")
        return false;
      var rest = spec.slice(1).split("/");
      if (rest.length !== 2)
        return false;
      return rest[0] && rest[1] && rest[0] === encodeURIComponent(rest[0]) && rest[1] === encodeURIComponent(rest[1]);
    }
    __name(isValidScopedPackageName, "isValidScopedPackageName");
    function isCorrectlyEncodedName(spec) {
      return !spec.match(/[\/@\s\+%:]/) && spec === encodeURIComponent(spec);
    }
    __name(isCorrectlyEncodedName, "isCorrectlyEncodedName");
    function ensureValidName(name, strict, allowLegacyCase) {
      if (name.charAt(0) === "." || !(isValidScopedPackageName(name) || isCorrectlyEncodedName(name)) || strict && !allowLegacyCase && name !== name.toLowerCase() || name.toLowerCase() === "node_modules" || name.toLowerCase() === "favicon.ico") {
        throw new Error("Invalid name: " + JSON.stringify(name));
      }
    }
    __name(ensureValidName, "ensureValidName");
    function modifyPeople(data, fn2) {
      if (data.author)
        data.author = fn2(data.author);
      ["maintainers", "contributors"].forEach(function(set) {
        if (!Array.isArray(data[set]))
          return;
        data[set] = data[set].map(fn2);
      });
      return data;
    }
    __name(modifyPeople, "modifyPeople");
    function unParsePerson(person) {
      if (typeof person === "string")
        return person;
      var name = person.name || "";
      var u3 = person.url || person.web;
      var url2 = u3 ? " (" + u3 + ")" : "";
      var e3 = person.email || person.mail;
      var email = e3 ? " <" + e3 + ">" : "";
      return name + email + url2;
    }
    __name(unParsePerson, "unParsePerson");
    function parsePerson(person) {
      if (typeof person !== "string")
        return person;
      var name = person.match(/^([^\(<]+)/);
      var url2 = person.match(/\(([^\)]+)\)/);
      var email = person.match(/<([^>]+)>/);
      var obj = {};
      if (name && name[0].trim())
        obj.name = name[0].trim();
      if (email)
        obj.email = email[1];
      if (url2)
        obj.url = url2[1];
      return obj;
    }
    __name(parsePerson, "parsePerson");
    function addOptionalDepsToDeps(data, warn3) {
      var o3 = data.optionalDependencies;
      if (!o3)
        return;
      var d4 = data.dependencies || {};
      Object.keys(o3).forEach(function(k) {
        d4[k] = o3[k];
      });
      data.dependencies = d4;
    }
    __name(addOptionalDepsToDeps, "addOptionalDepsToDeps");
    function depObjectify(deps, type, warn3) {
      if (!deps)
        return {};
      if (typeof deps === "string") {
        deps = deps.trim().split(/[\n\r\s\t ,]+/);
      }
      if (!Array.isArray(deps))
        return deps;
      warn3("deprecatedArrayDependencies", type);
      var o3 = {};
      deps.filter(function(d4) {
        return typeof d4 === "string";
      }).forEach(function(d4) {
        d4 = d4.trim().split(/(:?[@\s><=])/);
        var dn = d4.shift();
        var dv = d4.join("");
        dv = dv.trim();
        dv = dv.replace(/^@/, "");
        o3[dn] = dv;
      });
      return o3;
    }
    __name(depObjectify, "depObjectify");
    function objectifyDeps(data, warn3) {
      depTypes.forEach(function(type) {
        if (!data[type])
          return;
        data[type] = depObjectify(data[type], type, warn3);
      });
    }
    __name(objectifyDeps, "objectifyDeps");
    function bugsTypos(bugs, warn3) {
      if (!bugs)
        return;
      Object.keys(bugs).forEach(function(k) {
        if (typos.bugs[k]) {
          warn3("typo", k, typos.bugs[k], "bugs");
          bugs[typos.bugs[k]] = bugs[k];
          delete bugs[k];
        }
      });
    }
    __name(bugsTypos, "bugsTypos");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/warning_messages.json
var require_warning_messages = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/warning_messages.json"(exports2, module2) {
    module2.exports = {
      repositories: "'repositories' (plural) Not supported. Please pick one as the 'repository' field",
      missingRepository: "No repository field.",
      brokenGitUrl: "Probably broken git url: %s",
      nonObjectScripts: "scripts must be an object",
      nonStringScript: "script values must be string commands",
      nonArrayFiles: "Invalid 'files' member",
      invalidFilename: "Invalid filename in 'files' list: %s",
      nonArrayBundleDependencies: "Invalid 'bundleDependencies' list. Must be array of package names",
      nonStringBundleDependency: "Invalid bundleDependencies member: %s",
      nonDependencyBundleDependency: "Non-dependency in bundleDependencies: %s",
      nonObjectDependencies: "%s field must be an object",
      nonStringDependency: "Invalid dependency: %s %s",
      deprecatedArrayDependencies: "specifying %s as array is deprecated",
      deprecatedModules: "modules field is deprecated",
      nonArrayKeywords: "keywords should be an array of strings",
      nonStringKeyword: "keywords should be an array of strings",
      conflictingName: "%s is also the name of a node core module.",
      nonStringDescription: "'description' field should be a string",
      missingDescription: "No description",
      missingReadme: "No README data",
      missingLicense: "No license field.",
      nonEmailUrlBugsString: "Bug string field must be url, email, or {email,url}",
      nonUrlBugsUrlField: "bugs.url field must be a string url. Deleted.",
      nonEmailBugsEmailField: "bugs.email field must be a string email. Deleted.",
      emptyNormalizedBugs: "Normalized value of bugs field is an empty object. Deleted.",
      nonUrlHomepage: "homepage field must be a string url. Deleted.",
      invalidLicense: "license should be a valid SPDX license expression",
      typo: "%s should probably be %s."
    };
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/make_warning.js
var require_make_warning = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/make_warning.js"(exports2, module2) {
    var util4 = require("util");
    var messages = require_warning_messages();
    module2.exports = function() {
      var args3 = Array.prototype.slice.call(arguments, 0);
      var warningName = args3.shift();
      if (warningName == "typo") {
        return makeTypoWarning.apply(null, args3);
      } else {
        var msgTemplate = messages[warningName] ? messages[warningName] : warningName + ": '%s'";
        args3.unshift(msgTemplate);
        return util4.format.apply(null, args3);
      }
    };
    function makeTypoWarning(providedName, probableName, field) {
      if (field) {
        providedName = field + "['" + providedName + "']";
        probableName = field + "['" + probableName + "']";
      }
      return util4.format(messages.typo, providedName, probableName);
    }
    __name(makeTypoWarning, "makeTypoWarning");
  }
});

// ../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/normalize.js
var require_normalize = __commonJS({
  "../../node_modules/.pnpm/normalize-package-data@2.5.0/node_modules/normalize-package-data/lib/normalize.js"(exports2, module2) {
    module2.exports = normalize;
    var fixer = require_fixer();
    normalize.fixer = fixer;
    var makeWarning = require_make_warning();
    var fieldsToFix = [
      "name",
      "version",
      "description",
      "repository",
      "modules",
      "scripts",
      "files",
      "bin",
      "man",
      "bugs",
      "keywords",
      "readme",
      "homepage",
      "license"
    ];
    var otherThingsToFix = ["dependencies", "people", "typos"];
    var thingsToFix = fieldsToFix.map(function(fieldName) {
      return ucFirst(fieldName) + "Field";
    });
    thingsToFix = thingsToFix.concat(otherThingsToFix);
    function normalize(data, warn3, strict) {
      if (warn3 === true)
        warn3 = null, strict = true;
      if (!strict)
        strict = false;
      if (!warn3 || data.private)
        warn3 = /* @__PURE__ */ __name(function(msg) {
        }, "warn");
      if (data.scripts && data.scripts.install === "node-gyp rebuild" && !data.scripts.preinstall) {
        data.gypfile = true;
      }
      fixer.warn = function() {
        warn3(makeWarning.apply(null, arguments));
      };
      thingsToFix.forEach(function(thingName) {
        fixer["fix" + ucFirst(thingName)](data, strict);
      });
      data._id = data.name + "@" + data.version;
    }
    __name(normalize, "normalize");
    function ucFirst(string) {
      return string.charAt(0).toUpperCase() + string.slice(1);
    }
    __name(ucFirst, "ucFirst");
  }
});

// ../../node_modules/.pnpm/read-pkg@5.2.0/node_modules/read-pkg/index.js
var require_read_pkg = __commonJS({
  "../../node_modules/.pnpm/read-pkg@5.2.0/node_modules/read-pkg/index.js"(exports2, module2) {
    "use strict";
    var { promisify: promisify12 } = require("util");
    var fs37 = require("fs");
    var path32 = require("path");
    var parseJson = require_parse_json();
    var readFileAsync3 = promisify12(fs37.readFile);
    module2.exports = async (options2) => {
      options2 = {
        cwd: process.cwd(),
        normalize: true,
        ...options2
      };
      const filePath = path32.resolve(options2.cwd, "package.json");
      const json = parseJson(await readFileAsync3(filePath, "utf8"));
      if (options2.normalize) {
        require_normalize()(json);
      }
      return json;
    };
    module2.exports.sync = (options2) => {
      options2 = {
        cwd: process.cwd(),
        normalize: true,
        ...options2
      };
      const filePath = path32.resolve(options2.cwd, "package.json");
      const json = parseJson(fs37.readFileSync(filePath, "utf8"));
      if (options2.normalize) {
        require_normalize()(json);
      }
      return json;
    };
  }
});

// ../../node_modules/.pnpm/read-pkg-up@7.0.1/node_modules/read-pkg-up/index.js
var require_read_pkg_up = __commonJS({
  "../../node_modules/.pnpm/read-pkg-up@7.0.1/node_modules/read-pkg-up/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var findUp2 = require_find_up2();
    var readPkg = require_read_pkg();
    module2.exports = async (options2) => {
      const filePath = await findUp2("package.json", options2);
      if (!filePath) {
        return;
      }
      return {
        packageJson: await readPkg({ ...options2, cwd: path32.dirname(filePath) }),
        path: filePath
      };
    };
    module2.exports.sync = (options2) => {
      const filePath = findUp2.sync("package.json", options2);
      if (!filePath) {
        return;
      }
      return {
        packageJson: readPkg.sync({ ...options2, cwd: path32.dirname(filePath) }),
        path: filePath
      };
    };
  }
});

// ../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/package.json
var require_package = __commonJS({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/package.json"(exports2, module2) {
    module2.exports = {
      name: "dotenv",
      version: "16.0.3",
      description: "Loads environment variables from .env file",
      main: "lib/main.js",
      types: "lib/main.d.ts",
      exports: {
        ".": {
          require: "./lib/main.js",
          types: "./lib/main.d.ts",
          default: "./lib/main.js"
        },
        "./config": "./config.js",
        "./config.js": "./config.js",
        "./lib/env-options": "./lib/env-options.js",
        "./lib/env-options.js": "./lib/env-options.js",
        "./lib/cli-options": "./lib/cli-options.js",
        "./lib/cli-options.js": "./lib/cli-options.js",
        "./package.json": "./package.json"
      },
      scripts: {
        "dts-check": "tsc --project tests/types/tsconfig.json",
        lint: "standard",
        "lint-readme": "standard-markdown",
        pretest: "npm run lint && npm run dts-check",
        test: "tap tests/*.js --100 -Rspec",
        prerelease: "npm test",
        release: "standard-version"
      },
      repository: {
        type: "git",
        url: "git://github.com/motdotla/dotenv.git"
      },
      keywords: [
        "dotenv",
        "env",
        ".env",
        "environment",
        "variables",
        "config",
        "settings"
      ],
      readmeFilename: "README.md",
      license: "BSD-2-Clause",
      devDependencies: {
        "@types/node": "^17.0.9",
        decache: "^4.6.1",
        dtslint: "^3.7.0",
        sinon: "^12.0.1",
        standard: "^16.0.4",
        "standard-markdown": "^7.1.0",
        "standard-version": "^9.3.2",
        tap: "^15.1.6",
        tar: "^6.1.11",
        typescript: "^4.5.4"
      },
      engines: {
        node: ">=12"
      }
    };
  }
});

// ../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/lib/main.js
var require_main2 = __commonJS({
  "../../node_modules/.pnpm/dotenv@16.0.3/node_modules/dotenv/lib/main.js"(exports2, module2) {
    var fs37 = require("fs");
    var path32 = require("path");
    var os6 = require("os");
    var packageJson6 = require_package();
    var version3 = packageJson6.version;
    var LINE = /(?:^|^)\s*(?:export\s+)?([\w.-]+)(?:\s*=\s*?|:\s+?)(\s*'(?:\\'|[^'])*'|\s*"(?:\\"|[^"])*"|\s*`(?:\\`|[^`])*`|[^#\r\n]+)?\s*(?:#.*)?(?:$|$)/mg;
    function parse2(src) {
      const obj = {};
      let lines = src.toString();
      lines = lines.replace(/\r\n?/mg, "\n");
      let match4;
      while ((match4 = LINE.exec(lines)) != null) {
        const key = match4[1];
        let value = match4[2] || "";
        value = value.trim();
        const maybeQuote = value[0];
        value = value.replace(/^(['"`])([\s\S]*)\1$/mg, "$2");
        if (maybeQuote === '"') {
          value = value.replace(/\\n/g, "\n");
          value = value.replace(/\\r/g, "\r");
        }
        obj[key] = value;
      }
      return obj;
    }
    __name(parse2, "parse");
    function _log(message2) {
      console.log(`[dotenv@${version3}][DEBUG] ${message2}`);
    }
    __name(_log, "_log");
    function _resolveHome(envPath) {
      return envPath[0] === "~" ? path32.join(os6.homedir(), envPath.slice(1)) : envPath;
    }
    __name(_resolveHome, "_resolveHome");
    function config2(options2) {
      let dotenvPath = path32.resolve(process.cwd(), ".env");
      let encoding = "utf8";
      const debug27 = Boolean(options2 && options2.debug);
      const override = Boolean(options2 && options2.override);
      if (options2) {
        if (options2.path != null) {
          dotenvPath = _resolveHome(options2.path);
        }
        if (options2.encoding != null) {
          encoding = options2.encoding;
        }
      }
      try {
        const parsed = DotenvModule.parse(fs37.readFileSync(dotenvPath, { encoding }));
        Object.keys(parsed).forEach(function(key) {
          if (!Object.prototype.hasOwnProperty.call(process.env, key)) {
            process.env[key] = parsed[key];
          } else {
            if (override === true) {
              process.env[key] = parsed[key];
            }
            if (debug27) {
              if (override === true) {
                _log(`"${key}" is already defined in \`process.env\` and WAS overwritten`);
              } else {
                _log(`"${key}" is already defined in \`process.env\` and was NOT overwritten`);
              }
            }
          }
        });
        return { parsed };
      } catch (e3) {
        if (debug27) {
          _log(`Failed to load ${dotenvPath} ${e3.message}`);
        }
        return { error: e3 };
      }
    }
    __name(config2, "config");
    var DotenvModule = {
      config: config2,
      parse: parse2
    };
    module2.exports.config = DotenvModule.config;
    module2.exports.parse = DotenvModule.parse;
    module2.exports = DotenvModule;
  }
});

// ../../node_modules/.pnpm/arg@5.0.2/node_modules/arg/index.js
var require_arg = __commonJS({
  "../../node_modules/.pnpm/arg@5.0.2/node_modules/arg/index.js"(exports2, module2) {
    var flagSymbol = Symbol("arg flag");
    var ArgError = class extends Error {
      constructor(msg, code) {
        super(msg);
        this.name = "ArgError";
        this.code = code;
        Object.setPrototypeOf(this, ArgError.prototype);
      }
    };
    __name(ArgError, "ArgError");
    function arg2(opts2, {
      argv = process.argv.slice(2),
      permissive = false,
      stopAtPositional = false
    } = {}) {
      if (!opts2) {
        throw new ArgError(
          "argument specification object is required",
          "ARG_CONFIG_NO_SPEC"
        );
      }
      const result = { _: [] };
      const aliases2 = {};
      const handlers = {};
      for (const key of Object.keys(opts2)) {
        if (!key) {
          throw new ArgError(
            "argument key cannot be an empty string",
            "ARG_CONFIG_EMPTY_KEY"
          );
        }
        if (key[0] !== "-") {
          throw new ArgError(
            `argument key must start with '-' but found: '${key}'`,
            "ARG_CONFIG_NONOPT_KEY"
          );
        }
        if (key.length === 1) {
          throw new ArgError(
            `argument key must have a name; singular '-' keys are not allowed: ${key}`,
            "ARG_CONFIG_NONAME_KEY"
          );
        }
        if (typeof opts2[key] === "string") {
          aliases2[key] = opts2[key];
          continue;
        }
        let type = opts2[key];
        let isFlag = false;
        if (Array.isArray(type) && type.length === 1 && typeof type[0] === "function") {
          const [fn2] = type;
          type = /* @__PURE__ */ __name((value, name, prev = []) => {
            prev.push(fn2(value, name, prev[prev.length - 1]));
            return prev;
          }, "type");
          isFlag = fn2 === Boolean || fn2[flagSymbol] === true;
        } else if (typeof type === "function") {
          isFlag = type === Boolean || type[flagSymbol] === true;
        } else {
          throw new ArgError(
            `type missing or not a function or valid array type: ${key}`,
            "ARG_CONFIG_VAD_TYPE"
          );
        }
        if (key[1] !== "-" && key.length > 2) {
          throw new ArgError(
            `short argument keys (with a single hyphen) must have only one character: ${key}`,
            "ARG_CONFIG_SHORTOPT_TOOLONG"
          );
        }
        handlers[key] = [type, isFlag];
      }
      for (let i3 = 0, len = argv.length; i3 < len; i3++) {
        const wholeArg = argv[i3];
        if (stopAtPositional && result._.length > 0) {
          result._ = result._.concat(argv.slice(i3));
          break;
        }
        if (wholeArg === "--") {
          result._ = result._.concat(argv.slice(i3 + 1));
          break;
        }
        if (wholeArg.length > 1 && wholeArg[0] === "-") {
          const separatedArguments = wholeArg[1] === "-" || wholeArg.length === 2 ? [wholeArg] : wholeArg.slice(1).split("").map((a3) => `-${a3}`);
          for (let j = 0; j < separatedArguments.length; j++) {
            const arg3 = separatedArguments[j];
            const [originalArgName, argStr] = arg3[1] === "-" ? arg3.split(/=(.*)/, 2) : [arg3, void 0];
            let argName = originalArgName;
            while (argName in aliases2) {
              argName = aliases2[argName];
            }
            if (!(argName in handlers)) {
              if (permissive) {
                result._.push(arg3);
                continue;
              } else {
                throw new ArgError(
                  `unknown or unexpected option: ${originalArgName}`,
                  "ARG_UNKNOWN_OPTION"
                );
              }
            }
            const [type, isFlag] = handlers[argName];
            if (!isFlag && j + 1 < separatedArguments.length) {
              throw new ArgError(
                `option requires argument (but was followed by another short argument): ${originalArgName}`,
                "ARG_MISSING_REQUIRED_SHORTARG"
              );
            }
            if (isFlag) {
              result[argName] = type(true, argName, result[argName]);
            } else if (argStr === void 0) {
              if (argv.length < i3 + 2 || argv[i3 + 1].length > 1 && argv[i3 + 1][0] === "-" && !(argv[i3 + 1].match(/^-?\d*(\.(?=\d))?\d*$/) && (type === Number || typeof BigInt !== "undefined" && type === BigInt))) {
                const extended = originalArgName === argName ? "" : ` (alias for ${argName})`;
                throw new ArgError(
                  `option requires argument: ${originalArgName}${extended}`,
                  "ARG_MISSING_REQUIRED_LONGARG"
                );
              }
              result[argName] = type(argv[i3 + 1], argName, result[argName]);
              ++i3;
            } else {
              result[argName] = type(argStr, argName, result[argName]);
            }
          }
        } else {
          result._.push(wholeArg);
        }
      }
      return result;
    }
    __name(arg2, "arg");
    arg2.flag = (fn2) => {
      fn2[flagSymbol] = true;
      return fn2;
    };
    arg2.COUNT = arg2.flag((v3, name, existingCount) => (existingCount || 0) + 1);
    arg2.ArgError = ArgError;
    module2.exports = arg2;
  }
});

// ../../node_modules/.pnpm/min-indent@1.0.1/node_modules/min-indent/index.js
var require_min_indent = __commonJS({
  "../../node_modules/.pnpm/min-indent@1.0.1/node_modules/min-indent/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (string) => {
      const match4 = string.match(/^[ \t]*(?=\S)/gm);
      if (!match4) {
        return 0;
      }
      return match4.reduce((r3, a3) => Math.min(r3, a3.length), Infinity);
    };
  }
});

// ../../node_modules/.pnpm/strip-indent@3.0.0/node_modules/strip-indent/index.js
var require_strip_indent = __commonJS({
  "../../node_modules/.pnpm/strip-indent@3.0.0/node_modules/strip-indent/index.js"(exports2, module2) {
    "use strict";
    var minIndent = require_min_indent();
    module2.exports = (string) => {
      const indent4 = minIndent(string);
      if (indent4 === 0) {
        return string;
      }
      const regex = new RegExp(`^[ \\t]{${indent4}}`, "gm");
      return string.replace(regex, "");
    };
  }
});

// ../../node_modules/.pnpm/@prisma+prisma-fmt-wasm@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/prisma-fmt-wasm/src/prisma_fmt_build.js
var require_prisma_fmt_build = __commonJS({
  "../../node_modules/.pnpm/@prisma+prisma-fmt-wasm@4.11.0-57.8fde8fef4033376662cad983758335009d522acb/node_modules/@prisma/prisma-fmt-wasm/src/prisma_fmt_build.js"(exports2, module2) {
    var imports = {};
    imports["__wbindgen_placeholder__"] = module2.exports;
    var wasm;
    var { TextDecoder, TextEncoder } = require("util");
    var cachedTextDecoder = new TextDecoder("utf-8", { ignoreBOM: true, fatal: true });
    cachedTextDecoder.decode();
    var cachedUint8Memory0 = new Uint8Array();
    function getUint8Memory0() {
      if (cachedUint8Memory0.byteLength === 0) {
        cachedUint8Memory0 = new Uint8Array(wasm.memory.buffer);
      }
      return cachedUint8Memory0;
    }
    __name(getUint8Memory0, "getUint8Memory0");
    function getStringFromWasm0(ptr, len) {
      return cachedTextDecoder.decode(getUint8Memory0().subarray(ptr, ptr + len));
    }
    __name(getStringFromWasm0, "getStringFromWasm0");
    var heap = new Array(32).fill(void 0);
    heap.push(void 0, null, true, false);
    var heap_next = heap.length;
    function addHeapObject(obj) {
      if (heap_next === heap.length)
        heap.push(heap.length + 1);
      const idx = heap_next;
      heap_next = heap[idx];
      heap[idx] = obj;
      return idx;
    }
    __name(addHeapObject, "addHeapObject");
    var WASM_VECTOR_LEN = 0;
    var cachedTextEncoder = new TextEncoder("utf-8");
    var encodeString = typeof cachedTextEncoder.encodeInto === "function" ? function(arg2, view) {
      return cachedTextEncoder.encodeInto(arg2, view);
    } : function(arg2, view) {
      const buf = cachedTextEncoder.encode(arg2);
      view.set(buf);
      return {
        read: arg2.length,
        written: buf.length
      };
    };
    function passStringToWasm0(arg2, malloc, realloc) {
      if (realloc === void 0) {
        const buf = cachedTextEncoder.encode(arg2);
        const ptr2 = malloc(buf.length);
        getUint8Memory0().subarray(ptr2, ptr2 + buf.length).set(buf);
        WASM_VECTOR_LEN = buf.length;
        return ptr2;
      }
      let len = arg2.length;
      let ptr = malloc(len);
      const mem = getUint8Memory0();
      let offset = 0;
      for (; offset < len; offset++) {
        const code = arg2.charCodeAt(offset);
        if (code > 127)
          break;
        mem[ptr + offset] = code;
      }
      if (offset !== len) {
        if (offset !== 0) {
          arg2 = arg2.slice(offset);
        }
        ptr = realloc(ptr, len, len = offset + arg2.length * 3);
        const view = getUint8Memory0().subarray(ptr + offset, ptr + len);
        const ret = encodeString(arg2, view);
        offset += ret.written;
      }
      WASM_VECTOR_LEN = offset;
      return ptr;
    }
    __name(passStringToWasm0, "passStringToWasm0");
    var cachedInt32Memory0 = new Int32Array();
    function getInt32Memory0() {
      if (cachedInt32Memory0.byteLength === 0) {
        cachedInt32Memory0 = new Int32Array(wasm.memory.buffer);
      }
      return cachedInt32Memory0;
    }
    __name(getInt32Memory0, "getInt32Memory0");
    module2.exports.format = function(schema, params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(schema, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        const ptr1 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len1 = WASM_VECTOR_LEN;
        wasm.format(retptr, ptr0, len0, ptr1, len1);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    function getObject(idx) {
      return heap[idx];
    }
    __name(getObject, "getObject");
    function dropObject(idx) {
      if (idx < 36)
        return;
      heap[idx] = heap_next;
      heap_next = idx;
    }
    __name(dropObject, "dropObject");
    function takeObject(idx) {
      const ret = getObject(idx);
      dropObject(idx);
      return ret;
    }
    __name(takeObject, "takeObject");
    module2.exports.get_config = function(params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.get_config(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        var r22 = getInt32Memory0()[retptr / 4 + 2];
        var r3 = getInt32Memory0()[retptr / 4 + 3];
        var ptr1 = r0;
        var len1 = r1;
        if (r3) {
          ptr1 = 0;
          len1 = 0;
          throw takeObject(r22);
        }
        return getStringFromWasm0(ptr1, len1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(ptr1, len1);
      }
    };
    module2.exports.get_dmmf = function(params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.get_dmmf(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        var r22 = getInt32Memory0()[retptr / 4 + 2];
        var r3 = getInt32Memory0()[retptr / 4 + 3];
        var ptr1 = r0;
        var len1 = r1;
        if (r3) {
          ptr1 = 0;
          len1 = 0;
          throw takeObject(r22);
        }
        return getStringFromWasm0(ptr1, len1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(ptr1, len1);
      }
    };
    module2.exports.lint = function(input) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(input, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.lint(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.validate = function(params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.validate(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        if (r1) {
          throw takeObject(r0);
        }
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
      }
    };
    module2.exports.native_types = function(input) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(input, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.native_types(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.referential_actions = function(input) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(input, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        wasm.referential_actions(retptr, ptr0, len0);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.preview_features = function() {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        wasm.preview_features(retptr);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.text_document_completion = function(schema, params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(schema, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        const ptr1 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len1 = WASM_VECTOR_LEN;
        wasm.text_document_completion(retptr, ptr0, len0, ptr1, len1);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.code_actions = function(schema, params) {
      try {
        const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
        const ptr0 = passStringToWasm0(schema, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len0 = WASM_VECTOR_LEN;
        const ptr1 = passStringToWasm0(params, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
        const len1 = WASM_VECTOR_LEN;
        wasm.code_actions(retptr, ptr0, len0, ptr1, len1);
        var r0 = getInt32Memory0()[retptr / 4 + 0];
        var r1 = getInt32Memory0()[retptr / 4 + 1];
        return getStringFromWasm0(r0, r1);
      } finally {
        wasm.__wbindgen_add_to_stack_pointer(16);
        wasm.__wbindgen_free(r0, r1);
      }
    };
    module2.exports.debug_panic = function() {
      wasm.debug_panic();
    };
    var AdoNetString = class {
      static __wrap(ptr) {
        const obj = Object.create(AdoNetString.prototype);
        obj.ptr = ptr;
        return obj;
      }
      __destroy_into_raw() {
        const ptr = this.ptr;
        this.ptr = 0;
        return ptr;
      }
      free() {
        const ptr = this.__destroy_into_raw();
        wasm.__wbg_adonetstring_free(ptr);
      }
      constructor(s4) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(s4, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          wasm.adonetstring_new(retptr, ptr0, len0);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          var r22 = getInt32Memory0()[retptr / 4 + 2];
          if (r22) {
            throw takeObject(r1);
          }
          return AdoNetString.__wrap(r0);
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      get(key) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          wasm.adonetstring_get(retptr, this.ptr, ptr0, len0);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v1;
          if (r0 !== 0) {
            v1 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v1;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      set(key, value) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          const ptr1 = passStringToWasm0(value, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len1 = WASM_VECTOR_LEN;
          wasm.adonetstring_set(retptr, this.ptr, ptr0, len0, ptr1, len1);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v22;
          if (r0 !== 0) {
            v22 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v22;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      to_string() {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          wasm.adonetstring_to_string(retptr, this.ptr);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          return getStringFromWasm0(r0, r1);
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
          wasm.__wbindgen_free(r0, r1);
        }
      }
    };
    __name(AdoNetString, "AdoNetString");
    module2.exports.AdoNetString = AdoNetString;
    var JdbcString = class {
      static __wrap(ptr) {
        const obj = Object.create(JdbcString.prototype);
        obj.ptr = ptr;
        return obj;
      }
      __destroy_into_raw() {
        const ptr = this.ptr;
        this.ptr = 0;
        return ptr;
      }
      free() {
        const ptr = this.__destroy_into_raw();
        wasm.__wbg_jdbcstring_free(ptr);
      }
      constructor(s4) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(s4, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          wasm.jdbcstring_new(retptr, ptr0, len0);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          var r22 = getInt32Memory0()[retptr / 4 + 2];
          if (r22) {
            throw takeObject(r1);
          }
          return JdbcString.__wrap(r0);
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      sub_protocol() {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          wasm.jdbcstring_sub_protocol(retptr, this.ptr);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          return getStringFromWasm0(r0, r1);
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
          wasm.__wbindgen_free(r0, r1);
        }
      }
      server_name() {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          wasm.jdbcstring_server_name(retptr, this.ptr);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v0;
          if (r0 !== 0) {
            v0 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v0;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      instance_name() {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          wasm.jdbcstring_instance_name(retptr, this.ptr);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v0;
          if (r0 !== 0) {
            v0 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v0;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      port() {
        const ret = wasm.jdbcstring_port(this.ptr);
        return ret === 16777215 ? void 0 : ret;
      }
      get(key) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          wasm.adonetstring_get(retptr, this.ptr, ptr0, len0);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v1;
          if (r0 !== 0) {
            v1 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v1;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      set(key, value) {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          const ptr0 = passStringToWasm0(key, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len0 = WASM_VECTOR_LEN;
          const ptr1 = passStringToWasm0(value, wasm.__wbindgen_malloc, wasm.__wbindgen_realloc);
          const len1 = WASM_VECTOR_LEN;
          wasm.adonetstring_set(retptr, this.ptr, ptr0, len0, ptr1, len1);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          let v22;
          if (r0 !== 0) {
            v22 = getStringFromWasm0(r0, r1).slice();
            wasm.__wbindgen_free(r0, r1 * 1);
          }
          return v22;
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
        }
      }
      to_string() {
        try {
          const retptr = wasm.__wbindgen_add_to_stack_pointer(-16);
          wasm.jdbcstring_to_string(retptr, this.ptr);
          var r0 = getInt32Memory0()[retptr / 4 + 0];
          var r1 = getInt32Memory0()[retptr / 4 + 1];
          return getStringFromWasm0(r0, r1);
        } finally {
          wasm.__wbindgen_add_to_stack_pointer(16);
          wasm.__wbindgen_free(r0, r1);
        }
      }
    };
    __name(JdbcString, "JdbcString");
    module2.exports.JdbcString = JdbcString;
    module2.exports.__wbindgen_error_new = function(arg0, arg1) {
      const ret = new Error(getStringFromWasm0(arg0, arg1));
      return addHeapObject(ret);
    };
    module2.exports.__wbindgen_string_new = function(arg0, arg1) {
      const ret = getStringFromWasm0(arg0, arg1);
      return addHeapObject(ret);
    };
    module2.exports.__wbg_setmessage_7cbe93c6f7b2b123 = function(arg0, arg1) {
      global.PRISMA_WASM_PANIC_REGISTRY.set_message(getStringFromWasm0(arg0, arg1));
    };
    module2.exports.__wbindgen_throw = function(arg0, arg1) {
      throw new Error(getStringFromWasm0(arg0, arg1));
    };
    var path32 = require("path").join(__dirname, "prisma_fmt_build_bg.wasm");
    var bytes = require("fs").readFileSync(path32);
    var wasmModule = new WebAssembly.Module(bytes);
    var wasmInstance = new WebAssembly.Instance(wasmModule, imports);
    wasm = wasmInstance.exports;
    module2.exports.__wasm = wasm;
  }
});

// ../internals/package.json
var require_package2 = __commonJS({
  "../internals/package.json"(exports2, module2) {
    module2.exports = {
      name: "@prisma/internals",
      version: "4.11.0",
      description: "This package is intended for Prisma's internal use",
      main: "dist/index.js",
      types: "dist/index.d.ts",
      repository: {
        type: "git",
        url: "https://github.com/prisma/prisma.git",
        directory: "packages/internals"
      },
      homepage: "https://www.prisma.io",
      author: "Tim Suchanek <suchanek@prisma.io>",
      bugs: "https://github.com/prisma/prisma/issues",
      license: "Apache-2.0",
      scripts: {
        dev: "DEV=true node -r esbuild-register helpers/build.ts",
        build: "node -r esbuild-register helpers/build.ts",
        test: "jest --verbose",
        prepublishOnly: "pnpm run build"
      },
      files: [
        "README.md",
        "dist",
        "!**/libquery_engine*",
        "!dist/get-generators/engines/*",
        "scripts"
      ],
      devDependencies: {
        "@swc/core": "1.2.204",
        "@swc/jest": "0.2.24",
        "@types/jest": "29.4.0",
        "@types/node": "14.14.31",
        "@types/resolve": "1.20.2",
        esbuild: "0.15.13",
        jest: "29.4.1",
        "jest-junit": "15.0.0",
        "mock-stdin": "1.0.0",
        "ts-node": "10.9.1",
        typescript: "4.9.5",
        yarn: "1.22.19"
      },
      dependencies: {
        "@prisma/debug": "workspace:*",
        "@prisma/engine-core": "workspace:*",
        "@prisma/engines": "workspace:*",
        "@prisma/fetch-engine": "workspace:*",
        "@prisma/generator-helper": "workspace:*",
        "@prisma/get-platform": "workspace:*",
        "@prisma/prisma-fmt-wasm": "4.11.0-57.8fde8fef4033376662cad983758335009d522acb",
        archiver: "5.3.1",
        arg: "5.0.2",
        chalk: "4.1.2",
        "checkpoint-client": "1.1.23",
        "cli-truncate": "2.1.0",
        dotenv: "16.0.3",
        "escape-string-regexp": "4.0.0",
        execa: "5.1.1",
        "find-up": "5.0.0",
        "fp-ts": "2.13.1",
        "fs-extra": "11.1.0",
        "fs-jetpack": "5.1.0",
        "global-dirs": "3.0.1",
        globby: "11.1.0",
        "has-yarn": "2.1.0",
        "is-windows": "^1.0.2",
        "is-wsl": "^2.2.0",
        "new-github-issue-url": "0.2.1",
        "node-fetch": "2.6.9",
        "npm-packlist": "5.1.3",
        open: "7",
        ora: "5.4.1",
        "p-map": "4.0.0",
        prompts: "2.4.2",
        "read-pkg-up": "7.0.1",
        "replace-string": "3.1.0",
        resolve: "1.22.1",
        "string-width": "4.2.3",
        "strip-ansi": "6.0.1",
        "strip-indent": "3.0.0",
        "temp-dir": "2.0.0",
        "temp-write": "4.0.0",
        tempy: "1.0.1",
        "terminal-link": "2.1.1",
        tmp: "0.2.1",
        "ts-pattern": "^4.0.1"
      },
      sideEffects: false
    };
  }
});

// ../../node_modules/.pnpm/fp-ts@2.13.1/node_modules/fp-ts/lib/function.js
var require_function = __commonJS({
  "../../node_modules/.pnpm/fp-ts@2.13.1/node_modules/fp-ts/lib/function.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getEndomorphismMonoid = exports2.not = exports2.SK = exports2.hole = exports2.pipe = exports2.untupled = exports2.tupled = exports2.absurd = exports2.decrement = exports2.increment = exports2.tuple = exports2.flow = exports2.flip = exports2.constVoid = exports2.constUndefined = exports2.constNull = exports2.constFalse = exports2.constTrue = exports2.constant = exports2.unsafeCoerce = exports2.identity = exports2.apply = exports2.getRing = exports2.getSemiring = exports2.getMonoid = exports2.getSemigroup = exports2.getBooleanAlgebra = void 0;
    var getBooleanAlgebra = /* @__PURE__ */ __name(function(B) {
      return function() {
        return {
          meet: function(x, y4) {
            return function(a3) {
              return B.meet(x(a3), y4(a3));
            };
          },
          join: function(x, y4) {
            return function(a3) {
              return B.join(x(a3), y4(a3));
            };
          },
          zero: function() {
            return B.zero;
          },
          one: function() {
            return B.one;
          },
          implies: function(x, y4) {
            return function(a3) {
              return B.implies(x(a3), y4(a3));
            };
          },
          not: function(x) {
            return function(a3) {
              return B.not(x(a3));
            };
          }
        };
      };
    }, "getBooleanAlgebra");
    exports2.getBooleanAlgebra = getBooleanAlgebra;
    var getSemigroup = /* @__PURE__ */ __name(function(S3) {
      return function() {
        return {
          concat: function(f3, g3) {
            return function(a3) {
              return S3.concat(f3(a3), g3(a3));
            };
          }
        };
      };
    }, "getSemigroup");
    exports2.getSemigroup = getSemigroup;
    var getMonoid = /* @__PURE__ */ __name(function(M) {
      var getSemigroupM = (0, exports2.getSemigroup)(M);
      return function() {
        return {
          concat: getSemigroupM().concat,
          empty: function() {
            return M.empty;
          }
        };
      };
    }, "getMonoid");
    exports2.getMonoid = getMonoid;
    var getSemiring = /* @__PURE__ */ __name(function(S3) {
      return {
        add: function(f3, g3) {
          return function(x) {
            return S3.add(f3(x), g3(x));
          };
        },
        zero: function() {
          return S3.zero;
        },
        mul: function(f3, g3) {
          return function(x) {
            return S3.mul(f3(x), g3(x));
          };
        },
        one: function() {
          return S3.one;
        }
      };
    }, "getSemiring");
    exports2.getSemiring = getSemiring;
    var getRing = /* @__PURE__ */ __name(function(R) {
      var S3 = (0, exports2.getSemiring)(R);
      return {
        add: S3.add,
        mul: S3.mul,
        one: S3.one,
        zero: S3.zero,
        sub: function(f3, g3) {
          return function(x) {
            return R.sub(f3(x), g3(x));
          };
        }
      };
    }, "getRing");
    exports2.getRing = getRing;
    var apply2 = /* @__PURE__ */ __name(function(a3) {
      return function(f3) {
        return f3(a3);
      };
    }, "apply");
    exports2.apply = apply2;
    function identity4(a3) {
      return a3;
    }
    __name(identity4, "identity");
    exports2.identity = identity4;
    exports2.unsafeCoerce = identity4;
    function constant2(a3) {
      return function() {
        return a3;
      };
    }
    __name(constant2, "constant");
    exports2.constant = constant2;
    exports2.constTrue = constant2(true);
    exports2.constFalse = constant2(false);
    exports2.constNull = constant2(null);
    exports2.constUndefined = constant2(void 0);
    exports2.constVoid = exports2.constUndefined;
    function flip(f3) {
      return function() {
        var args3 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          args3[_i] = arguments[_i];
        }
        if (args3.length > 1) {
          return f3(args3[1], args3[0]);
        }
        return function(a3) {
          return f3(a3)(args3[0]);
        };
      };
    }
    __name(flip, "flip");
    exports2.flip = flip;
    function flow2(ab, bc, cd, de, ef, fg, gh, hi, ij) {
      switch (arguments.length) {
        case 1:
          return ab;
        case 2:
          return function() {
            return bc(ab.apply(this, arguments));
          };
        case 3:
          return function() {
            return cd(bc(ab.apply(this, arguments)));
          };
        case 4:
          return function() {
            return de(cd(bc(ab.apply(this, arguments))));
          };
        case 5:
          return function() {
            return ef(de(cd(bc(ab.apply(this, arguments)))));
          };
        case 6:
          return function() {
            return fg(ef(de(cd(bc(ab.apply(this, arguments))))));
          };
        case 7:
          return function() {
            return gh(fg(ef(de(cd(bc(ab.apply(this, arguments)))))));
          };
        case 8:
          return function() {
            return hi(gh(fg(ef(de(cd(bc(ab.apply(this, arguments))))))));
          };
        case 9:
          return function() {
            return ij(hi(gh(fg(ef(de(cd(bc(ab.apply(this, arguments)))))))));
          };
      }
      return;
    }
    __name(flow2, "flow");
    exports2.flow = flow2;
    function tuple() {
      var t5 = [];
      for (var _i = 0; _i < arguments.length; _i++) {
        t5[_i] = arguments[_i];
      }
      return t5;
    }
    __name(tuple, "tuple");
    exports2.tuple = tuple;
    function increment(n3) {
      return n3 + 1;
    }
    __name(increment, "increment");
    exports2.increment = increment;
    function decrement(n3) {
      return n3 - 1;
    }
    __name(decrement, "decrement");
    exports2.decrement = decrement;
    function absurd(_2) {
      throw new Error("Called `absurd` function which should be uncallable");
    }
    __name(absurd, "absurd");
    exports2.absurd = absurd;
    function tupled(f3) {
      return function(a3) {
        return f3.apply(void 0, a3);
      };
    }
    __name(tupled, "tupled");
    exports2.tupled = tupled;
    function untupled(f3) {
      return function() {
        var a3 = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          a3[_i] = arguments[_i];
        }
        return f3(a3);
      };
    }
    __name(untupled, "untupled");
    exports2.untupled = untupled;
    function pipe7(a3, ab, bc, cd, de, ef, fg, gh, hi) {
      switch (arguments.length) {
        case 1:
          return a3;
        case 2:
          return ab(a3);
        case 3:
          return bc(ab(a3));
        case 4:
          return cd(bc(ab(a3)));
        case 5:
          return de(cd(bc(ab(a3))));
        case 6:
          return ef(de(cd(bc(ab(a3)))));
        case 7:
          return fg(ef(de(cd(bc(ab(a3))))));
        case 8:
          return gh(fg(ef(de(cd(bc(ab(a3)))))));
        case 9:
          return hi(gh(fg(ef(de(cd(bc(ab(a3))))))));
        default: {
          var ret = arguments[0];
          for (var i3 = 1; i3 < arguments.length; i3++) {
            ret = arguments[i3](ret);
          }
          return ret;
        }
      }
    }
    __name(pipe7, "pipe");
    exports2.pipe = pipe7;
    exports2.hole = absurd;
    var SK = /* @__PURE__ */ __name(function(_2, b3) {
      return b3;
    }, "SK");
    exports2.SK = SK;
    function not(predicate) {
      return function(a3) {
        return !predicate(a3);
      };
    }
    __name(not, "not");
    exports2.not = not;
    var getEndomorphismMonoid = /* @__PURE__ */ __name(function() {
      return {
        concat: function(first, second) {
          return flow2(first, second);
        },
        empty: identity4
      };
    }, "getEndomorphismMonoid");
    exports2.getEndomorphismMonoid = getEndomorphismMonoid;
  }
});

// ../../node_modules/.pnpm/ansi-escapes@4.3.2/node_modules/ansi-escapes/index.js
var require_ansi_escapes = __commonJS({
  "../../node_modules/.pnpm/ansi-escapes@4.3.2/node_modules/ansi-escapes/index.js"(exports2, module2) {
    "use strict";
    var ansiEscapes = module2.exports;
    module2.exports.default = ansiEscapes;
    var ESC = "\x1B[";
    var OSC = "\x1B]";
    var BEL = "\x07";
    var SEP = ";";
    var isTerminalApp = process.env.TERM_PROGRAM === "Apple_Terminal";
    ansiEscapes.cursorTo = (x, y4) => {
      if (typeof x !== "number") {
        throw new TypeError("The `x` argument is required");
      }
      if (typeof y4 !== "number") {
        return ESC + (x + 1) + "G";
      }
      return ESC + (y4 + 1) + ";" + (x + 1) + "H";
    };
    ansiEscapes.cursorMove = (x, y4) => {
      if (typeof x !== "number") {
        throw new TypeError("The `x` argument is required");
      }
      let ret = "";
      if (x < 0) {
        ret += ESC + -x + "D";
      } else if (x > 0) {
        ret += ESC + x + "C";
      }
      if (y4 < 0) {
        ret += ESC + -y4 + "A";
      } else if (y4 > 0) {
        ret += ESC + y4 + "B";
      }
      return ret;
    };
    ansiEscapes.cursorUp = (count = 1) => ESC + count + "A";
    ansiEscapes.cursorDown = (count = 1) => ESC + count + "B";
    ansiEscapes.cursorForward = (count = 1) => ESC + count + "C";
    ansiEscapes.cursorBackward = (count = 1) => ESC + count + "D";
    ansiEscapes.cursorLeft = ESC + "G";
    ansiEscapes.cursorSavePosition = isTerminalApp ? "\x1B7" : ESC + "s";
    ansiEscapes.cursorRestorePosition = isTerminalApp ? "\x1B8" : ESC + "u";
    ansiEscapes.cursorGetPosition = ESC + "6n";
    ansiEscapes.cursorNextLine = ESC + "E";
    ansiEscapes.cursorPrevLine = ESC + "F";
    ansiEscapes.cursorHide = ESC + "?25l";
    ansiEscapes.cursorShow = ESC + "?25h";
    ansiEscapes.eraseLines = (count) => {
      let clear = "";
      for (let i3 = 0; i3 < count; i3++) {
        clear += ansiEscapes.eraseLine + (i3 < count - 1 ? ansiEscapes.cursorUp() : "");
      }
      if (count) {
        clear += ansiEscapes.cursorLeft;
      }
      return clear;
    };
    ansiEscapes.eraseEndLine = ESC + "K";
    ansiEscapes.eraseStartLine = ESC + "1K";
    ansiEscapes.eraseLine = ESC + "2K";
    ansiEscapes.eraseDown = ESC + "J";
    ansiEscapes.eraseUp = ESC + "1J";
    ansiEscapes.eraseScreen = ESC + "2J";
    ansiEscapes.scrollUp = ESC + "S";
    ansiEscapes.scrollDown = ESC + "T";
    ansiEscapes.clearScreen = "\x1Bc";
    ansiEscapes.clearTerminal = process.platform === "win32" ? `${ansiEscapes.eraseScreen}${ESC}0f` : `${ansiEscapes.eraseScreen}${ESC}3J${ESC}H`;
    ansiEscapes.beep = BEL;
    ansiEscapes.link = (text, url) => {
      return [
        OSC,
        "8",
        SEP,
        SEP,
        url,
        BEL,
        text,
        OSC,
        "8",
        SEP,
        SEP,
        BEL
      ].join("");
    };
    ansiEscapes.image = (buffer, options2 = {}) => {
      let ret = `${OSC}1337;File=inline=1`;
      if (options2.width) {
        ret += `;width=${options2.width}`;
      }
      if (options2.height) {
        ret += `;height=${options2.height}`;
      }
      if (options2.preserveAspectRatio === false) {
        ret += ";preserveAspectRatio=0";
      }
      return ret + ":" + buffer.toString("base64") + BEL;
    };
    ansiEscapes.iTerm = {
      setCwd: (cwd = process.cwd()) => `${OSC}50;CurrentDir=${cwd}${BEL}`,
      annotation: (message2, options2 = {}) => {
        let ret = `${OSC}1337;`;
        const hasX = typeof options2.x !== "undefined";
        const hasY = typeof options2.y !== "undefined";
        if ((hasX || hasY) && !(hasX && hasY && typeof options2.length !== "undefined")) {
          throw new Error("`x`, `y` and `length` must be defined when `x` or `y` is defined");
        }
        message2 = message2.replace(/\|/g, "");
        ret += options2.isHidden ? "AddHiddenAnnotation=" : "AddAnnotation=";
        if (options2.length > 0) {
          ret += (hasX ? [message2, options2.length, options2.x, options2.y] : [options2.length, message2]).join("|");
        } else {
          ret += message2;
        }
        return ret + BEL;
      }
    };
  }
});

// ../../node_modules/.pnpm/supports-hyperlinks@2.3.0/node_modules/supports-hyperlinks/index.js
var require_supports_hyperlinks = __commonJS({
  "../../node_modules/.pnpm/supports-hyperlinks@2.3.0/node_modules/supports-hyperlinks/index.js"(exports2, module2) {
    "use strict";
    var supportsColor = require_supports_color();
    var hasFlag = require_has_flag();
    function parseVersion(versionString) {
      if (/^\d{3,4}$/.test(versionString)) {
        const m4 = /(\d{1,2})(\d{2})/.exec(versionString);
        return {
          major: 0,
          minor: parseInt(m4[1], 10),
          patch: parseInt(m4[2], 10)
        };
      }
      const versions = (versionString || "").split(".").map((n3) => parseInt(n3, 10));
      return {
        major: versions[0],
        minor: versions[1],
        patch: versions[2]
      };
    }
    __name(parseVersion, "parseVersion");
    function supportsHyperlink(stream3) {
      const { env: env2 } = process;
      if ("FORCE_HYPERLINK" in env2) {
        return !(env2.FORCE_HYPERLINK.length > 0 && parseInt(env2.FORCE_HYPERLINK, 10) === 0);
      }
      if (hasFlag("no-hyperlink") || hasFlag("no-hyperlinks") || hasFlag("hyperlink=false") || hasFlag("hyperlink=never")) {
        return false;
      }
      if (hasFlag("hyperlink=true") || hasFlag("hyperlink=always")) {
        return true;
      }
      if ("NETLIFY" in env2) {
        return true;
      }
      if (!supportsColor.supportsColor(stream3)) {
        return false;
      }
      if (stream3 && !stream3.isTTY) {
        return false;
      }
      if (process.platform === "win32") {
        return false;
      }
      if ("CI" in env2) {
        return false;
      }
      if ("TEAMCITY_VERSION" in env2) {
        return false;
      }
      if ("TERM_PROGRAM" in env2) {
        const version3 = parseVersion(env2.TERM_PROGRAM_VERSION);
        switch (env2.TERM_PROGRAM) {
          case "iTerm.app":
            if (version3.major === 3) {
              return version3.minor >= 1;
            }
            return version3.major > 3;
          case "WezTerm":
            return version3.major >= 20200620;
          case "vscode":
            return version3.major > 1 || version3.major === 1 && version3.minor >= 72;
        }
      }
      if ("VTE_VERSION" in env2) {
        if (env2.VTE_VERSION === "0.50.0") {
          return false;
        }
        const version3 = parseVersion(env2.VTE_VERSION);
        return version3.major > 0 || version3.minor >= 50;
      }
      return false;
    }
    __name(supportsHyperlink, "supportsHyperlink");
    module2.exports = {
      supportsHyperlink,
      stdout: supportsHyperlink(process.stdout),
      stderr: supportsHyperlink(process.stderr)
    };
  }
});

// ../../node_modules/.pnpm/terminal-link@2.1.1/node_modules/terminal-link/index.js
var require_terminal_link = __commonJS({
  "../../node_modules/.pnpm/terminal-link@2.1.1/node_modules/terminal-link/index.js"(exports2, module2) {
    "use strict";
    var ansiEscapes = require_ansi_escapes();
    var supportsHyperlinks = require_supports_hyperlinks();
    var terminalLink3 = /* @__PURE__ */ __name((text, url, { target = "stdout", ...options2 } = {}) => {
      if (!supportsHyperlinks[target]) {
        if (options2.fallback === false) {
          return text;
        }
        return typeof options2.fallback === "function" ? options2.fallback(text, url) : `${text} (\u200B${url}\u200B)`;
      }
      return ansiEscapes.link(text, url);
    }, "terminalLink");
    module2.exports = (text, url, options2 = {}) => terminalLink3(text, url, options2);
    module2.exports.stderr = (text, url, options2 = {}) => terminalLink3(text, url, { target: "stderr", ...options2 });
    module2.exports.isSupported = supportsHyperlinks.stdout;
    module2.exports.stderr.isSupported = supportsHyperlinks.stderr;
  }
});

// ../../node_modules/.pnpm/crypto-random-string@2.0.0/node_modules/crypto-random-string/index.js
var require_crypto_random_string = __commonJS({
  "../../node_modules/.pnpm/crypto-random-string@2.0.0/node_modules/crypto-random-string/index.js"(exports2, module2) {
    "use strict";
    var crypto4 = require("crypto");
    module2.exports = (length) => {
      if (!Number.isFinite(length)) {
        throw new TypeError("Expected a finite number");
      }
      return crypto4.randomBytes(Math.ceil(length / 2)).toString("hex").slice(0, length);
    };
  }
});

// ../../node_modules/.pnpm/unique-string@2.0.0/node_modules/unique-string/index.js
var require_unique_string = __commonJS({
  "../../node_modules/.pnpm/unique-string@2.0.0/node_modules/unique-string/index.js"(exports2, module2) {
    "use strict";
    var cryptoRandomString = require_crypto_random_string();
    module2.exports = () => cryptoRandomString(32);
  }
});

// ../../node_modules/.pnpm/temp-dir@2.0.0/node_modules/temp-dir/index.js
var require_temp_dir = __commonJS({
  "../../node_modules/.pnpm/temp-dir@2.0.0/node_modules/temp-dir/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var os6 = require("os");
    var tempDirectorySymbol = Symbol.for("__RESOLVED_TEMP_DIRECTORY__");
    if (!global[tempDirectorySymbol]) {
      Object.defineProperty(global, tempDirectorySymbol, {
        value: fs37.realpathSync(os6.tmpdir())
      });
    }
    module2.exports = global[tempDirectorySymbol];
  }
});

// ../../node_modules/.pnpm/array-union@2.1.0/node_modules/array-union/index.js
var require_array_union = __commonJS({
  "../../node_modules/.pnpm/array-union@2.1.0/node_modules/array-union/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (...arguments_) => {
      return [...new Set([].concat(...arguments_))];
    };
  }
});

// ../../node_modules/.pnpm/merge2@1.4.1/node_modules/merge2/index.js
var require_merge2 = __commonJS({
  "../../node_modules/.pnpm/merge2@1.4.1/node_modules/merge2/index.js"(exports2, module2) {
    "use strict";
    var Stream2 = require("stream");
    var PassThrough2 = Stream2.PassThrough;
    var slice = Array.prototype.slice;
    module2.exports = merge2;
    function merge2() {
      const streamsQueue = [];
      const args3 = slice.call(arguments);
      let merging = false;
      let options2 = args3[args3.length - 1];
      if (options2 && !Array.isArray(options2) && options2.pipe == null) {
        args3.pop();
      } else {
        options2 = {};
      }
      const doEnd = options2.end !== false;
      const doPipeError = options2.pipeError === true;
      if (options2.objectMode == null) {
        options2.objectMode = true;
      }
      if (options2.highWaterMark == null) {
        options2.highWaterMark = 64 * 1024;
      }
      const mergedStream = PassThrough2(options2);
      function addStream() {
        for (let i3 = 0, len = arguments.length; i3 < len; i3++) {
          streamsQueue.push(pauseStreams(arguments[i3], options2));
        }
        mergeStream();
        return this;
      }
      __name(addStream, "addStream");
      function mergeStream() {
        if (merging) {
          return;
        }
        merging = true;
        let streams = streamsQueue.shift();
        if (!streams) {
          process.nextTick(endStream);
          return;
        }
        if (!Array.isArray(streams)) {
          streams = [streams];
        }
        let pipesCount = streams.length + 1;
        function next() {
          if (--pipesCount > 0) {
            return;
          }
          merging = false;
          mergeStream();
        }
        __name(next, "next");
        function pipe7(stream3) {
          function onend() {
            stream3.removeListener("merge2UnpipeEnd", onend);
            stream3.removeListener("end", onend);
            if (doPipeError) {
              stream3.removeListener("error", onerror);
            }
            next();
          }
          __name(onend, "onend");
          function onerror(err) {
            mergedStream.emit("error", err);
          }
          __name(onerror, "onerror");
          if (stream3._readableState.endEmitted) {
            return next();
          }
          stream3.on("merge2UnpipeEnd", onend);
          stream3.on("end", onend);
          if (doPipeError) {
            stream3.on("error", onerror);
          }
          stream3.pipe(mergedStream, { end: false });
          stream3.resume();
        }
        __name(pipe7, "pipe");
        for (let i3 = 0; i3 < streams.length; i3++) {
          pipe7(streams[i3]);
        }
        next();
      }
      __name(mergeStream, "mergeStream");
      function endStream() {
        merging = false;
        mergedStream.emit("queueDrain");
        if (doEnd) {
          mergedStream.end();
        }
      }
      __name(endStream, "endStream");
      mergedStream.setMaxListeners(0);
      mergedStream.add = addStream;
      mergedStream.on("unpipe", function(stream3) {
        stream3.emit("merge2UnpipeEnd");
      });
      if (args3.length) {
        addStream.apply(null, args3);
      }
      return mergedStream;
    }
    __name(merge2, "merge2");
    function pauseStreams(streams, options2) {
      if (!Array.isArray(streams)) {
        if (!streams._readableState && streams.pipe) {
          streams = streams.pipe(PassThrough2(options2));
        }
        if (!streams._readableState || !streams.pause || !streams.pipe) {
          throw new Error("Only readable stream can be merged.");
        }
        streams.pause();
      } else {
        for (let i3 = 0, len = streams.length; i3 < len; i3++) {
          streams[i3] = pauseStreams(streams[i3], options2);
        }
      }
      return streams;
    }
    __name(pauseStreams, "pauseStreams");
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/array.js
var require_array = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/array.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.splitWhen = exports2.flatten = void 0;
    function flatten(items) {
      return items.reduce((collection, item) => [].concat(collection, item), []);
    }
    __name(flatten, "flatten");
    exports2.flatten = flatten;
    function splitWhen(items, predicate) {
      const result = [[]];
      let groupIndex = 0;
      for (const item of items) {
        if (predicate(item)) {
          groupIndex++;
          result[groupIndex] = [];
        } else {
          result[groupIndex].push(item);
        }
      }
      return result;
    }
    __name(splitWhen, "splitWhen");
    exports2.splitWhen = splitWhen;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/errno.js
var require_errno = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/errno.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isEnoentCodeError = void 0;
    function isEnoentCodeError(error2) {
      return error2.code === "ENOENT";
    }
    __name(isEnoentCodeError, "isEnoentCodeError");
    exports2.isEnoentCodeError = isEnoentCodeError;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/fs.js
var require_fs = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/fs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createDirentFromStats = void 0;
    var DirentFromStats = class {
      constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
      }
    };
    __name(DirentFromStats, "DirentFromStats");
    function createDirentFromStats(name, stats) {
      return new DirentFromStats(name, stats);
    }
    __name(createDirentFromStats, "createDirentFromStats");
    exports2.createDirentFromStats = createDirentFromStats;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/path.js
var require_path = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/path.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.removeLeadingDotSegment = exports2.escape = exports2.makeAbsolute = exports2.unixify = void 0;
    var path32 = require("path");
    var LEADING_DOT_SEGMENT_CHARACTERS_COUNT = 2;
    var UNESCAPED_GLOB_SYMBOLS_RE = /(\\?)([()*?[\]{|}]|^!|[!+@](?=\())/g;
    function unixify(filepath) {
      return filepath.replace(/\\/g, "/");
    }
    __name(unixify, "unixify");
    exports2.unixify = unixify;
    function makeAbsolute(cwd, filepath) {
      return path32.resolve(cwd, filepath);
    }
    __name(makeAbsolute, "makeAbsolute");
    exports2.makeAbsolute = makeAbsolute;
    function escape2(pattern) {
      return pattern.replace(UNESCAPED_GLOB_SYMBOLS_RE, "\\$2");
    }
    __name(escape2, "escape");
    exports2.escape = escape2;
    function removeLeadingDotSegment(entry) {
      if (entry.charAt(0) === ".") {
        const secondCharactery = entry.charAt(1);
        if (secondCharactery === "/" || secondCharactery === "\\") {
          return entry.slice(LEADING_DOT_SEGMENT_CHARACTERS_COUNT);
        }
      }
      return entry;
    }
    __name(removeLeadingDotSegment, "removeLeadingDotSegment");
    exports2.removeLeadingDotSegment = removeLeadingDotSegment;
  }
});

// ../../node_modules/.pnpm/is-extglob@2.1.1/node_modules/is-extglob/index.js
var require_is_extglob = __commonJS({
  "../../node_modules/.pnpm/is-extglob@2.1.1/node_modules/is-extglob/index.js"(exports2, module2) {
    module2.exports = /* @__PURE__ */ __name(function isExtglob(str) {
      if (typeof str !== "string" || str === "") {
        return false;
      }
      var match4;
      while (match4 = /(\\).|([@?!+*]\(.*\))/g.exec(str)) {
        if (match4[2])
          return true;
        str = str.slice(match4.index + match4[0].length);
      }
      return false;
    }, "isExtglob");
  }
});

// ../../node_modules/.pnpm/is-glob@4.0.3/node_modules/is-glob/index.js
var require_is_glob = __commonJS({
  "../../node_modules/.pnpm/is-glob@4.0.3/node_modules/is-glob/index.js"(exports2, module2) {
    var isExtglob = require_is_extglob();
    var chars2 = { "{": "}", "(": ")", "[": "]" };
    var strictCheck = /* @__PURE__ */ __name(function(str) {
      if (str[0] === "!") {
        return true;
      }
      var index2 = 0;
      var pipeIndex = -2;
      var closeSquareIndex = -2;
      var closeCurlyIndex = -2;
      var closeParenIndex = -2;
      var backSlashIndex = -2;
      while (index2 < str.length) {
        if (str[index2] === "*") {
          return true;
        }
        if (str[index2 + 1] === "?" && /[\].+)]/.test(str[index2])) {
          return true;
        }
        if (closeSquareIndex !== -1 && str[index2] === "[" && str[index2 + 1] !== "]") {
          if (closeSquareIndex < index2) {
            closeSquareIndex = str.indexOf("]", index2);
          }
          if (closeSquareIndex > index2) {
            if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
              return true;
            }
            backSlashIndex = str.indexOf("\\", index2);
            if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
              return true;
            }
          }
        }
        if (closeCurlyIndex !== -1 && str[index2] === "{" && str[index2 + 1] !== "}") {
          closeCurlyIndex = str.indexOf("}", index2);
          if (closeCurlyIndex > index2) {
            backSlashIndex = str.indexOf("\\", index2);
            if (backSlashIndex === -1 || backSlashIndex > closeCurlyIndex) {
              return true;
            }
          }
        }
        if (closeParenIndex !== -1 && str[index2] === "(" && str[index2 + 1] === "?" && /[:!=]/.test(str[index2 + 2]) && str[index2 + 3] !== ")") {
          closeParenIndex = str.indexOf(")", index2);
          if (closeParenIndex > index2) {
            backSlashIndex = str.indexOf("\\", index2);
            if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
              return true;
            }
          }
        }
        if (pipeIndex !== -1 && str[index2] === "(" && str[index2 + 1] !== "|") {
          if (pipeIndex < index2) {
            pipeIndex = str.indexOf("|", index2);
          }
          if (pipeIndex !== -1 && str[pipeIndex + 1] !== ")") {
            closeParenIndex = str.indexOf(")", pipeIndex);
            if (closeParenIndex > pipeIndex) {
              backSlashIndex = str.indexOf("\\", pipeIndex);
              if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
                return true;
              }
            }
          }
        }
        if (str[index2] === "\\") {
          var open4 = str[index2 + 1];
          index2 += 2;
          var close2 = chars2[open4];
          if (close2) {
            var n3 = str.indexOf(close2, index2);
            if (n3 !== -1) {
              index2 = n3 + 1;
            }
          }
          if (str[index2] === "!") {
            return true;
          }
        } else {
          index2++;
        }
      }
      return false;
    }, "strictCheck");
    var relaxedCheck = /* @__PURE__ */ __name(function(str) {
      if (str[0] === "!") {
        return true;
      }
      var index2 = 0;
      while (index2 < str.length) {
        if (/[*?{}()[\]]/.test(str[index2])) {
          return true;
        }
        if (str[index2] === "\\") {
          var open4 = str[index2 + 1];
          index2 += 2;
          var close2 = chars2[open4];
          if (close2) {
            var n3 = str.indexOf(close2, index2);
            if (n3 !== -1) {
              index2 = n3 + 1;
            }
          }
          if (str[index2] === "!") {
            return true;
          }
        } else {
          index2++;
        }
      }
      return false;
    }, "relaxedCheck");
    module2.exports = /* @__PURE__ */ __name(function isGlob(str, options2) {
      if (typeof str !== "string" || str === "") {
        return false;
      }
      if (isExtglob(str)) {
        return true;
      }
      var check3 = strictCheck;
      if (options2 && options2.strict === false) {
        check3 = relaxedCheck;
      }
      return check3(str);
    }, "isGlob");
  }
});

// ../../node_modules/.pnpm/glob-parent@5.1.2/node_modules/glob-parent/index.js
var require_glob_parent = __commonJS({
  "../../node_modules/.pnpm/glob-parent@5.1.2/node_modules/glob-parent/index.js"(exports2, module2) {
    "use strict";
    var isGlob = require_is_glob();
    var pathPosixDirname = require("path").posix.dirname;
    var isWin32 = require("os").platform() === "win32";
    var slash = "/";
    var backslash = /\\/g;
    var enclosure = /[\{\[].*[\}\]]$/;
    var globby2 = /(^|[^\\])([\{\[]|\([^\)]+$)/;
    var escaped = /\\([\!\*\?\|\[\]\(\)\{\}])/g;
    module2.exports = /* @__PURE__ */ __name(function globParent(str, opts2) {
      var options2 = Object.assign({ flipBackslashes: true }, opts2);
      if (options2.flipBackslashes && isWin32 && str.indexOf(slash) < 0) {
        str = str.replace(backslash, slash);
      }
      if (enclosure.test(str)) {
        str += slash;
      }
      str += "a";
      do {
        str = pathPosixDirname(str);
      } while (isGlob(str) || globby2.test(str));
      return str.replace(escaped, "$1");
    }, "globParent");
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/utils.js
var require_utils = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/utils.js"(exports2) {
    "use strict";
    exports2.isInteger = (num) => {
      if (typeof num === "number") {
        return Number.isInteger(num);
      }
      if (typeof num === "string" && num.trim() !== "") {
        return Number.isInteger(Number(num));
      }
      return false;
    };
    exports2.find = (node, type) => node.nodes.find((node2) => node2.type === type);
    exports2.exceedsLimit = (min, max, step = 1, limit) => {
      if (limit === false)
        return false;
      if (!exports2.isInteger(min) || !exports2.isInteger(max))
        return false;
      return (Number(max) - Number(min)) / Number(step) >= limit;
    };
    exports2.escapeNode = (block, n3 = 0, type) => {
      let node = block.nodes[n3];
      if (!node)
        return;
      if (type && node.type === type || node.type === "open" || node.type === "close") {
        if (node.escaped !== true) {
          node.value = "\\" + node.value;
          node.escaped = true;
        }
      }
    };
    exports2.encloseBrace = (node) => {
      if (node.type !== "brace")
        return false;
      if (node.commas >> 0 + node.ranges >> 0 === 0) {
        node.invalid = true;
        return true;
      }
      return false;
    };
    exports2.isInvalidBrace = (block) => {
      if (block.type !== "brace")
        return false;
      if (block.invalid === true || block.dollar)
        return true;
      if (block.commas >> 0 + block.ranges >> 0 === 0) {
        block.invalid = true;
        return true;
      }
      if (block.open !== true || block.close !== true) {
        block.invalid = true;
        return true;
      }
      return false;
    };
    exports2.isOpenOrClose = (node) => {
      if (node.type === "open" || node.type === "close") {
        return true;
      }
      return node.open === true || node.close === true;
    };
    exports2.reduce = (nodes) => nodes.reduce((acc, node) => {
      if (node.type === "text")
        acc.push(node.value);
      if (node.type === "range")
        node.type = "text";
      return acc;
    }, []);
    exports2.flatten = (...args3) => {
      const result = [];
      const flat = /* @__PURE__ */ __name((arr) => {
        for (let i3 = 0; i3 < arr.length; i3++) {
          let ele = arr[i3];
          Array.isArray(ele) ? flat(ele, result) : ele !== void 0 && result.push(ele);
        }
        return result;
      }, "flat");
      flat(args3);
      return result;
    };
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/stringify.js
var require_stringify = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/stringify.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    module2.exports = (ast, options2 = {}) => {
      let stringify2 = /* @__PURE__ */ __name((node, parent2 = {}) => {
        let invalidBlock = options2.escapeInvalid && utils.isInvalidBrace(parent2);
        let invalidNode = node.invalid === true && options2.escapeInvalid === true;
        let output = "";
        if (node.value) {
          if ((invalidBlock || invalidNode) && utils.isOpenOrClose(node)) {
            return "\\" + node.value;
          }
          return node.value;
        }
        if (node.value) {
          return node.value;
        }
        if (node.nodes) {
          for (let child of node.nodes) {
            output += stringify2(child);
          }
        }
        return output;
      }, "stringify");
      return stringify2(ast);
    };
  }
});

// ../../node_modules/.pnpm/is-number@7.0.0/node_modules/is-number/index.js
var require_is_number = __commonJS({
  "../../node_modules/.pnpm/is-number@7.0.0/node_modules/is-number/index.js"(exports2, module2) {
    "use strict";
    module2.exports = function(num) {
      if (typeof num === "number") {
        return num - num === 0;
      }
      if (typeof num === "string" && num.trim() !== "") {
        return Number.isFinite ? Number.isFinite(+num) : isFinite(+num);
      }
      return false;
    };
  }
});

// ../../node_modules/.pnpm/to-regex-range@5.0.1/node_modules/to-regex-range/index.js
var require_to_regex_range = __commonJS({
  "../../node_modules/.pnpm/to-regex-range@5.0.1/node_modules/to-regex-range/index.js"(exports2, module2) {
    "use strict";
    var isNumber = require_is_number();
    var toRegexRange = /* @__PURE__ */ __name((min, max, options2) => {
      if (isNumber(min) === false) {
        throw new TypeError("toRegexRange: expected the first argument to be a number");
      }
      if (max === void 0 || min === max) {
        return String(min);
      }
      if (isNumber(max) === false) {
        throw new TypeError("toRegexRange: expected the second argument to be a number.");
      }
      let opts2 = { relaxZeros: true, ...options2 };
      if (typeof opts2.strictZeros === "boolean") {
        opts2.relaxZeros = opts2.strictZeros === false;
      }
      let relax = String(opts2.relaxZeros);
      let shorthand = String(opts2.shorthand);
      let capture = String(opts2.capture);
      let wrap2 = String(opts2.wrap);
      let cacheKey = min + ":" + max + "=" + relax + shorthand + capture + wrap2;
      if (toRegexRange.cache.hasOwnProperty(cacheKey)) {
        return toRegexRange.cache[cacheKey].result;
      }
      let a3 = Math.min(min, max);
      let b3 = Math.max(min, max);
      if (Math.abs(a3 - b3) === 1) {
        let result = min + "|" + max;
        if (opts2.capture) {
          return `(${result})`;
        }
        if (opts2.wrap === false) {
          return result;
        }
        return `(?:${result})`;
      }
      let isPadded = hasPadding(min) || hasPadding(max);
      let state = { min, max, a: a3, b: b3 };
      let positives = [];
      let negatives = [];
      if (isPadded) {
        state.isPadded = isPadded;
        state.maxLen = String(state.max).length;
      }
      if (a3 < 0) {
        let newMin = b3 < 0 ? Math.abs(b3) : 1;
        negatives = splitToPatterns(newMin, Math.abs(a3), state, opts2);
        a3 = state.a = 0;
      }
      if (b3 >= 0) {
        positives = splitToPatterns(a3, b3, state, opts2);
      }
      state.negatives = negatives;
      state.positives = positives;
      state.result = collatePatterns(negatives, positives, opts2);
      if (opts2.capture === true) {
        state.result = `(${state.result})`;
      } else if (opts2.wrap !== false && positives.length + negatives.length > 1) {
        state.result = `(?:${state.result})`;
      }
      toRegexRange.cache[cacheKey] = state;
      return state.result;
    }, "toRegexRange");
    function collatePatterns(neg, pos, options2) {
      let onlyNegative = filterPatterns(neg, pos, "-", false, options2) || [];
      let onlyPositive = filterPatterns(pos, neg, "", false, options2) || [];
      let intersected = filterPatterns(neg, pos, "-?", true, options2) || [];
      let subpatterns = onlyNegative.concat(intersected).concat(onlyPositive);
      return subpatterns.join("|");
    }
    __name(collatePatterns, "collatePatterns");
    function splitToRanges(min, max) {
      let nines = 1;
      let zeros = 1;
      let stop = countNines(min, nines);
      let stops = /* @__PURE__ */ new Set([max]);
      while (min <= stop && stop <= max) {
        stops.add(stop);
        nines += 1;
        stop = countNines(min, nines);
      }
      stop = countZeros(max + 1, zeros) - 1;
      while (min < stop && stop <= max) {
        stops.add(stop);
        zeros += 1;
        stop = countZeros(max + 1, zeros) - 1;
      }
      stops = [...stops];
      stops.sort(compare);
      return stops;
    }
    __name(splitToRanges, "splitToRanges");
    function rangeToPattern(start, stop, options2) {
      if (start === stop) {
        return { pattern: start, count: [], digits: 0 };
      }
      let zipped = zip(start, stop);
      let digits = zipped.length;
      let pattern = "";
      let count = 0;
      for (let i3 = 0; i3 < digits; i3++) {
        let [startDigit, stopDigit] = zipped[i3];
        if (startDigit === stopDigit) {
          pattern += startDigit;
        } else if (startDigit !== "0" || stopDigit !== "9") {
          pattern += toCharacterClass(startDigit, stopDigit, options2);
        } else {
          count++;
        }
      }
      if (count) {
        pattern += options2.shorthand === true ? "\\d" : "[0-9]";
      }
      return { pattern, count: [count], digits };
    }
    __name(rangeToPattern, "rangeToPattern");
    function splitToPatterns(min, max, tok, options2) {
      let ranges = splitToRanges(min, max);
      let tokens = [];
      let start = min;
      let prev;
      for (let i3 = 0; i3 < ranges.length; i3++) {
        let max2 = ranges[i3];
        let obj = rangeToPattern(String(start), String(max2), options2);
        let zeros = "";
        if (!tok.isPadded && prev && prev.pattern === obj.pattern) {
          if (prev.count.length > 1) {
            prev.count.pop();
          }
          prev.count.push(obj.count[0]);
          prev.string = prev.pattern + toQuantifier(prev.count);
          start = max2 + 1;
          continue;
        }
        if (tok.isPadded) {
          zeros = padZeros(max2, tok, options2);
        }
        obj.string = zeros + obj.pattern + toQuantifier(obj.count);
        tokens.push(obj);
        start = max2 + 1;
        prev = obj;
      }
      return tokens;
    }
    __name(splitToPatterns, "splitToPatterns");
    function filterPatterns(arr, comparison, prefix, intersection, options2) {
      let result = [];
      for (let ele of arr) {
        let { string } = ele;
        if (!intersection && !contains(comparison, "string", string)) {
          result.push(prefix + string);
        }
        if (intersection && contains(comparison, "string", string)) {
          result.push(prefix + string);
        }
      }
      return result;
    }
    __name(filterPatterns, "filterPatterns");
    function zip(a3, b3) {
      let arr = [];
      for (let i3 = 0; i3 < a3.length; i3++)
        arr.push([a3[i3], b3[i3]]);
      return arr;
    }
    __name(zip, "zip");
    function compare(a3, b3) {
      return a3 > b3 ? 1 : b3 > a3 ? -1 : 0;
    }
    __name(compare, "compare");
    function contains(arr, key, val) {
      return arr.some((ele) => ele[key] === val);
    }
    __name(contains, "contains");
    function countNines(min, len) {
      return Number(String(min).slice(0, -len) + "9".repeat(len));
    }
    __name(countNines, "countNines");
    function countZeros(integer, zeros) {
      return integer - integer % Math.pow(10, zeros);
    }
    __name(countZeros, "countZeros");
    function toQuantifier(digits) {
      let [start = 0, stop = ""] = digits;
      if (stop || start > 1) {
        return `{${start + (stop ? "," + stop : "")}}`;
      }
      return "";
    }
    __name(toQuantifier, "toQuantifier");
    function toCharacterClass(a3, b3, options2) {
      return `[${a3}${b3 - a3 === 1 ? "" : "-"}${b3}]`;
    }
    __name(toCharacterClass, "toCharacterClass");
    function hasPadding(str) {
      return /^-?(0+)\d/.test(str);
    }
    __name(hasPadding, "hasPadding");
    function padZeros(value, tok, options2) {
      if (!tok.isPadded) {
        return value;
      }
      let diff = Math.abs(tok.maxLen - String(value).length);
      let relax = options2.relaxZeros !== false;
      switch (diff) {
        case 0:
          return "";
        case 1:
          return relax ? "0?" : "0";
        case 2:
          return relax ? "0{0,2}" : "00";
        default: {
          return relax ? `0{0,${diff}}` : `0{${diff}}`;
        }
      }
    }
    __name(padZeros, "padZeros");
    toRegexRange.cache = {};
    toRegexRange.clearCache = () => toRegexRange.cache = {};
    module2.exports = toRegexRange;
  }
});

// ../../node_modules/.pnpm/fill-range@7.0.1/node_modules/fill-range/index.js
var require_fill_range = __commonJS({
  "../../node_modules/.pnpm/fill-range@7.0.1/node_modules/fill-range/index.js"(exports2, module2) {
    "use strict";
    var util4 = require("util");
    var toRegexRange = require_to_regex_range();
    var isObject = /* @__PURE__ */ __name((val) => val !== null && typeof val === "object" && !Array.isArray(val), "isObject");
    var transform2 = /* @__PURE__ */ __name((toNumber) => {
      return (value) => toNumber === true ? Number(value) : String(value);
    }, "transform");
    var isValidValue = /* @__PURE__ */ __name((value) => {
      return typeof value === "number" || typeof value === "string" && value !== "";
    }, "isValidValue");
    var isNumber = /* @__PURE__ */ __name((num) => Number.isInteger(+num), "isNumber");
    var zeros = /* @__PURE__ */ __name((input) => {
      let value = `${input}`;
      let index2 = -1;
      if (value[0] === "-")
        value = value.slice(1);
      if (value === "0")
        return false;
      while (value[++index2] === "0")
        ;
      return index2 > 0;
    }, "zeros");
    var stringify2 = /* @__PURE__ */ __name((start, end, options2) => {
      if (typeof start === "string" || typeof end === "string") {
        return true;
      }
      return options2.stringify === true;
    }, "stringify");
    var pad = /* @__PURE__ */ __name((input, maxLength, toNumber) => {
      if (maxLength > 0) {
        let dash = input[0] === "-" ? "-" : "";
        if (dash)
          input = input.slice(1);
        input = dash + input.padStart(dash ? maxLength - 1 : maxLength, "0");
      }
      if (toNumber === false) {
        return String(input);
      }
      return input;
    }, "pad");
    var toMaxLen = /* @__PURE__ */ __name((input, maxLength) => {
      let negative = input[0] === "-" ? "-" : "";
      if (negative) {
        input = input.slice(1);
        maxLength--;
      }
      while (input.length < maxLength)
        input = "0" + input;
      return negative ? "-" + input : input;
    }, "toMaxLen");
    var toSequence = /* @__PURE__ */ __name((parts, options2) => {
      parts.negatives.sort((a3, b3) => a3 < b3 ? -1 : a3 > b3 ? 1 : 0);
      parts.positives.sort((a3, b3) => a3 < b3 ? -1 : a3 > b3 ? 1 : 0);
      let prefix = options2.capture ? "" : "?:";
      let positives = "";
      let negatives = "";
      let result;
      if (parts.positives.length) {
        positives = parts.positives.join("|");
      }
      if (parts.negatives.length) {
        negatives = `-(${prefix}${parts.negatives.join("|")})`;
      }
      if (positives && negatives) {
        result = `${positives}|${negatives}`;
      } else {
        result = positives || negatives;
      }
      if (options2.wrap) {
        return `(${prefix}${result})`;
      }
      return result;
    }, "toSequence");
    var toRange = /* @__PURE__ */ __name((a3, b3, isNumbers, options2) => {
      if (isNumbers) {
        return toRegexRange(a3, b3, { wrap: false, ...options2 });
      }
      let start = String.fromCharCode(a3);
      if (a3 === b3)
        return start;
      let stop = String.fromCharCode(b3);
      return `[${start}-${stop}]`;
    }, "toRange");
    var toRegex = /* @__PURE__ */ __name((start, end, options2) => {
      if (Array.isArray(start)) {
        let wrap2 = options2.wrap === true;
        let prefix = options2.capture ? "" : "?:";
        return wrap2 ? `(${prefix}${start.join("|")})` : start.join("|");
      }
      return toRegexRange(start, end, options2);
    }, "toRegex");
    var rangeError = /* @__PURE__ */ __name((...args3) => {
      return new RangeError("Invalid range arguments: " + util4.inspect(...args3));
    }, "rangeError");
    var invalidRange = /* @__PURE__ */ __name((start, end, options2) => {
      if (options2.strictRanges === true)
        throw rangeError([start, end]);
      return [];
    }, "invalidRange");
    var invalidStep = /* @__PURE__ */ __name((step, options2) => {
      if (options2.strictRanges === true) {
        throw new TypeError(`Expected step "${step}" to be a number`);
      }
      return [];
    }, "invalidStep");
    var fillNumbers = /* @__PURE__ */ __name((start, end, step = 1, options2 = {}) => {
      let a3 = Number(start);
      let b3 = Number(end);
      if (!Number.isInteger(a3) || !Number.isInteger(b3)) {
        if (options2.strictRanges === true)
          throw rangeError([start, end]);
        return [];
      }
      if (a3 === 0)
        a3 = 0;
      if (b3 === 0)
        b3 = 0;
      let descending = a3 > b3;
      let startString = String(start);
      let endString = String(end);
      let stepString = String(step);
      step = Math.max(Math.abs(step), 1);
      let padded = zeros(startString) || zeros(endString) || zeros(stepString);
      let maxLen = padded ? Math.max(startString.length, endString.length, stepString.length) : 0;
      let toNumber = padded === false && stringify2(start, end, options2) === false;
      let format2 = options2.transform || transform2(toNumber);
      if (options2.toRegex && step === 1) {
        return toRange(toMaxLen(start, maxLen), toMaxLen(end, maxLen), true, options2);
      }
      let parts = { negatives: [], positives: [] };
      let push = /* @__PURE__ */ __name((num) => parts[num < 0 ? "negatives" : "positives"].push(Math.abs(num)), "push");
      let range2 = [];
      let index2 = 0;
      while (descending ? a3 >= b3 : a3 <= b3) {
        if (options2.toRegex === true && step > 1) {
          push(a3);
        } else {
          range2.push(pad(format2(a3, index2), maxLen, toNumber));
        }
        a3 = descending ? a3 - step : a3 + step;
        index2++;
      }
      if (options2.toRegex === true) {
        return step > 1 ? toSequence(parts, options2) : toRegex(range2, null, { wrap: false, ...options2 });
      }
      return range2;
    }, "fillNumbers");
    var fillLetters = /* @__PURE__ */ __name((start, end, step = 1, options2 = {}) => {
      if (!isNumber(start) && start.length > 1 || !isNumber(end) && end.length > 1) {
        return invalidRange(start, end, options2);
      }
      let format2 = options2.transform || ((val) => String.fromCharCode(val));
      let a3 = `${start}`.charCodeAt(0);
      let b3 = `${end}`.charCodeAt(0);
      let descending = a3 > b3;
      let min = Math.min(a3, b3);
      let max = Math.max(a3, b3);
      if (options2.toRegex && step === 1) {
        return toRange(min, max, false, options2);
      }
      let range2 = [];
      let index2 = 0;
      while (descending ? a3 >= b3 : a3 <= b3) {
        range2.push(format2(a3, index2));
        a3 = descending ? a3 - step : a3 + step;
        index2++;
      }
      if (options2.toRegex === true) {
        return toRegex(range2, null, { wrap: false, options: options2 });
      }
      return range2;
    }, "fillLetters");
    var fill = /* @__PURE__ */ __name((start, end, step, options2 = {}) => {
      if (end == null && isValidValue(start)) {
        return [start];
      }
      if (!isValidValue(start) || !isValidValue(end)) {
        return invalidRange(start, end, options2);
      }
      if (typeof step === "function") {
        return fill(start, end, 1, { transform: step });
      }
      if (isObject(step)) {
        return fill(start, end, 0, step);
      }
      let opts2 = { ...options2 };
      if (opts2.capture === true)
        opts2.wrap = true;
      step = step || opts2.step || 1;
      if (!isNumber(step)) {
        if (step != null && !isObject(step))
          return invalidStep(step, opts2);
        return fill(start, end, 1, step);
      }
      if (isNumber(start) && isNumber(end)) {
        return fillNumbers(start, end, step, opts2);
      }
      return fillLetters(start, end, Math.max(Math.abs(step), 1), opts2);
    }, "fill");
    module2.exports = fill;
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/compile.js
var require_compile = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/compile.js"(exports2, module2) {
    "use strict";
    var fill = require_fill_range();
    var utils = require_utils();
    var compile = /* @__PURE__ */ __name((ast, options2 = {}) => {
      let walk = /* @__PURE__ */ __name((node, parent2 = {}) => {
        let invalidBlock = utils.isInvalidBrace(parent2);
        let invalidNode = node.invalid === true && options2.escapeInvalid === true;
        let invalid = invalidBlock === true || invalidNode === true;
        let prefix = options2.escapeInvalid === true ? "\\" : "";
        let output = "";
        if (node.isOpen === true) {
          return prefix + node.value;
        }
        if (node.isClose === true) {
          return prefix + node.value;
        }
        if (node.type === "open") {
          return invalid ? prefix + node.value : "(";
        }
        if (node.type === "close") {
          return invalid ? prefix + node.value : ")";
        }
        if (node.type === "comma") {
          return node.prev.type === "comma" ? "" : invalid ? node.value : "|";
        }
        if (node.value) {
          return node.value;
        }
        if (node.nodes && node.ranges > 0) {
          let args3 = utils.reduce(node.nodes);
          let range2 = fill(...args3, { ...options2, wrap: false, toRegex: true });
          if (range2.length !== 0) {
            return args3.length > 1 && range2.length > 1 ? `(${range2})` : range2;
          }
        }
        if (node.nodes) {
          for (let child of node.nodes) {
            output += walk(child, node);
          }
        }
        return output;
      }, "walk");
      return walk(ast);
    }, "compile");
    module2.exports = compile;
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/expand.js
var require_expand = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/expand.js"(exports2, module2) {
    "use strict";
    var fill = require_fill_range();
    var stringify2 = require_stringify();
    var utils = require_utils();
    var append = /* @__PURE__ */ __name((queue2 = "", stash = "", enclose = false) => {
      let result = [];
      queue2 = [].concat(queue2);
      stash = [].concat(stash);
      if (!stash.length)
        return queue2;
      if (!queue2.length) {
        return enclose ? utils.flatten(stash).map((ele) => `{${ele}}`) : stash;
      }
      for (let item of queue2) {
        if (Array.isArray(item)) {
          for (let value of item) {
            result.push(append(value, stash, enclose));
          }
        } else {
          for (let ele of stash) {
            if (enclose === true && typeof ele === "string")
              ele = `{${ele}}`;
            result.push(Array.isArray(ele) ? append(item, ele, enclose) : item + ele);
          }
        }
      }
      return utils.flatten(result);
    }, "append");
    var expand = /* @__PURE__ */ __name((ast, options2 = {}) => {
      let rangeLimit = options2.rangeLimit === void 0 ? 1e3 : options2.rangeLimit;
      let walk = /* @__PURE__ */ __name((node, parent2 = {}) => {
        node.queue = [];
        let p3 = parent2;
        let q = parent2.queue;
        while (p3.type !== "brace" && p3.type !== "root" && p3.parent) {
          p3 = p3.parent;
          q = p3.queue;
        }
        if (node.invalid || node.dollar) {
          q.push(append(q.pop(), stringify2(node, options2)));
          return;
        }
        if (node.type === "brace" && node.invalid !== true && node.nodes.length === 2) {
          q.push(append(q.pop(), ["{}"]));
          return;
        }
        if (node.nodes && node.ranges > 0) {
          let args3 = utils.reduce(node.nodes);
          if (utils.exceedsLimit(...args3, options2.step, rangeLimit)) {
            throw new RangeError("expanded array length exceeds range limit. Use options.rangeLimit to increase or disable the limit.");
          }
          let range2 = fill(...args3, options2);
          if (range2.length === 0) {
            range2 = stringify2(node, options2);
          }
          q.push(append(q.pop(), range2));
          node.nodes = [];
          return;
        }
        let enclose = utils.encloseBrace(node);
        let queue2 = node.queue;
        let block = node;
        while (block.type !== "brace" && block.type !== "root" && block.parent) {
          block = block.parent;
          queue2 = block.queue;
        }
        for (let i3 = 0; i3 < node.nodes.length; i3++) {
          let child = node.nodes[i3];
          if (child.type === "comma" && node.type === "brace") {
            if (i3 === 1)
              queue2.push("");
            queue2.push("");
            continue;
          }
          if (child.type === "close") {
            q.push(append(q.pop(), queue2, enclose));
            continue;
          }
          if (child.value && child.type !== "open") {
            queue2.push(append(queue2.pop(), child.value));
            continue;
          }
          if (child.nodes) {
            walk(child, node);
          }
        }
        return queue2;
      }, "walk");
      return utils.flatten(walk(ast));
    }, "expand");
    module2.exports = expand;
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/constants.js
var require_constants = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/constants.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      MAX_LENGTH: 1024 * 64,
      CHAR_0: "0",
      CHAR_9: "9",
      CHAR_UPPERCASE_A: "A",
      CHAR_LOWERCASE_A: "a",
      CHAR_UPPERCASE_Z: "Z",
      CHAR_LOWERCASE_Z: "z",
      CHAR_LEFT_PARENTHESES: "(",
      CHAR_RIGHT_PARENTHESES: ")",
      CHAR_ASTERISK: "*",
      CHAR_AMPERSAND: "&",
      CHAR_AT: "@",
      CHAR_BACKSLASH: "\\",
      CHAR_BACKTICK: "`",
      CHAR_CARRIAGE_RETURN: "\r",
      CHAR_CIRCUMFLEX_ACCENT: "^",
      CHAR_COLON: ":",
      CHAR_COMMA: ",",
      CHAR_DOLLAR: "$",
      CHAR_DOT: ".",
      CHAR_DOUBLE_QUOTE: '"',
      CHAR_EQUAL: "=",
      CHAR_EXCLAMATION_MARK: "!",
      CHAR_FORM_FEED: "\f",
      CHAR_FORWARD_SLASH: "/",
      CHAR_HASH: "#",
      CHAR_HYPHEN_MINUS: "-",
      CHAR_LEFT_ANGLE_BRACKET: "<",
      CHAR_LEFT_CURLY_BRACE: "{",
      CHAR_LEFT_SQUARE_BRACKET: "[",
      CHAR_LINE_FEED: "\n",
      CHAR_NO_BREAK_SPACE: "\xA0",
      CHAR_PERCENT: "%",
      CHAR_PLUS: "+",
      CHAR_QUESTION_MARK: "?",
      CHAR_RIGHT_ANGLE_BRACKET: ">",
      CHAR_RIGHT_CURLY_BRACE: "}",
      CHAR_RIGHT_SQUARE_BRACKET: "]",
      CHAR_SEMICOLON: ";",
      CHAR_SINGLE_QUOTE: "'",
      CHAR_SPACE: " ",
      CHAR_TAB: "	",
      CHAR_UNDERSCORE: "_",
      CHAR_VERTICAL_LINE: "|",
      CHAR_ZERO_WIDTH_NOBREAK_SPACE: "\uFEFF"
    };
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/parse.js
var require_parse3 = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/lib/parse.js"(exports2, module2) {
    "use strict";
    var stringify2 = require_stringify();
    var {
      MAX_LENGTH,
      CHAR_BACKSLASH,
      CHAR_BACKTICK,
      CHAR_COMMA,
      CHAR_DOT,
      CHAR_LEFT_PARENTHESES,
      CHAR_RIGHT_PARENTHESES,
      CHAR_LEFT_CURLY_BRACE,
      CHAR_RIGHT_CURLY_BRACE,
      CHAR_LEFT_SQUARE_BRACKET,
      CHAR_RIGHT_SQUARE_BRACKET,
      CHAR_DOUBLE_QUOTE,
      CHAR_SINGLE_QUOTE,
      CHAR_NO_BREAK_SPACE,
      CHAR_ZERO_WIDTH_NOBREAK_SPACE
    } = require_constants();
    var parse2 = /* @__PURE__ */ __name((input, options2 = {}) => {
      if (typeof input !== "string") {
        throw new TypeError("Expected a string");
      }
      let opts2 = options2 || {};
      let max = typeof opts2.maxLength === "number" ? Math.min(MAX_LENGTH, opts2.maxLength) : MAX_LENGTH;
      if (input.length > max) {
        throw new SyntaxError(`Input length (${input.length}), exceeds max characters (${max})`);
      }
      let ast = { type: "root", input, nodes: [] };
      let stack2 = [ast];
      let block = ast;
      let prev = ast;
      let brackets = 0;
      let length = input.length;
      let index2 = 0;
      let depth = 0;
      let value;
      let memo = {};
      const advance = /* @__PURE__ */ __name(() => input[index2++], "advance");
      const push = /* @__PURE__ */ __name((node) => {
        if (node.type === "text" && prev.type === "dot") {
          prev.type = "text";
        }
        if (prev && prev.type === "text" && node.type === "text") {
          prev.value += node.value;
          return;
        }
        block.nodes.push(node);
        node.parent = block;
        node.prev = prev;
        prev = node;
        return node;
      }, "push");
      push({ type: "bos" });
      while (index2 < length) {
        block = stack2[stack2.length - 1];
        value = advance();
        if (value === CHAR_ZERO_WIDTH_NOBREAK_SPACE || value === CHAR_NO_BREAK_SPACE) {
          continue;
        }
        if (value === CHAR_BACKSLASH) {
          push({ type: "text", value: (options2.keepEscaping ? value : "") + advance() });
          continue;
        }
        if (value === CHAR_RIGHT_SQUARE_BRACKET) {
          push({ type: "text", value: "\\" + value });
          continue;
        }
        if (value === CHAR_LEFT_SQUARE_BRACKET) {
          brackets++;
          let closed = true;
          let next;
          while (index2 < length && (next = advance())) {
            value += next;
            if (next === CHAR_LEFT_SQUARE_BRACKET) {
              brackets++;
              continue;
            }
            if (next === CHAR_BACKSLASH) {
              value += advance();
              continue;
            }
            if (next === CHAR_RIGHT_SQUARE_BRACKET) {
              brackets--;
              if (brackets === 0) {
                break;
              }
            }
          }
          push({ type: "text", value });
          continue;
        }
        if (value === CHAR_LEFT_PARENTHESES) {
          block = push({ type: "paren", nodes: [] });
          stack2.push(block);
          push({ type: "text", value });
          continue;
        }
        if (value === CHAR_RIGHT_PARENTHESES) {
          if (block.type !== "paren") {
            push({ type: "text", value });
            continue;
          }
          block = stack2.pop();
          push({ type: "text", value });
          block = stack2[stack2.length - 1];
          continue;
        }
        if (value === CHAR_DOUBLE_QUOTE || value === CHAR_SINGLE_QUOTE || value === CHAR_BACKTICK) {
          let open4 = value;
          let next;
          if (options2.keepQuotes !== true) {
            value = "";
          }
          while (index2 < length && (next = advance())) {
            if (next === CHAR_BACKSLASH) {
              value += next + advance();
              continue;
            }
            if (next === open4) {
              if (options2.keepQuotes === true)
                value += next;
              break;
            }
            value += next;
          }
          push({ type: "text", value });
          continue;
        }
        if (value === CHAR_LEFT_CURLY_BRACE) {
          depth++;
          let dollar = prev.value && prev.value.slice(-1) === "$" || block.dollar === true;
          let brace = {
            type: "brace",
            open: true,
            close: false,
            dollar,
            depth,
            commas: 0,
            ranges: 0,
            nodes: []
          };
          block = push(brace);
          stack2.push(block);
          push({ type: "open", value });
          continue;
        }
        if (value === CHAR_RIGHT_CURLY_BRACE) {
          if (block.type !== "brace") {
            push({ type: "text", value });
            continue;
          }
          let type = "close";
          block = stack2.pop();
          block.close = true;
          push({ type, value });
          depth--;
          block = stack2[stack2.length - 1];
          continue;
        }
        if (value === CHAR_COMMA && depth > 0) {
          if (block.ranges > 0) {
            block.ranges = 0;
            let open4 = block.nodes.shift();
            block.nodes = [open4, { type: "text", value: stringify2(block) }];
          }
          push({ type: "comma", value });
          block.commas++;
          continue;
        }
        if (value === CHAR_DOT && depth > 0 && block.commas === 0) {
          let siblings = block.nodes;
          if (depth === 0 || siblings.length === 0) {
            push({ type: "text", value });
            continue;
          }
          if (prev.type === "dot") {
            block.range = [];
            prev.value += value;
            prev.type = "range";
            if (block.nodes.length !== 3 && block.nodes.length !== 5) {
              block.invalid = true;
              block.ranges = 0;
              prev.type = "text";
              continue;
            }
            block.ranges++;
            block.args = [];
            continue;
          }
          if (prev.type === "range") {
            siblings.pop();
            let before = siblings[siblings.length - 1];
            before.value += prev.value + value;
            prev = before;
            block.ranges--;
            continue;
          }
          push({ type: "dot", value });
          continue;
        }
        push({ type: "text", value });
      }
      do {
        block = stack2.pop();
        if (block.type !== "root") {
          block.nodes.forEach((node) => {
            if (!node.nodes) {
              if (node.type === "open")
                node.isOpen = true;
              if (node.type === "close")
                node.isClose = true;
              if (!node.nodes)
                node.type = "text";
              node.invalid = true;
            }
          });
          let parent2 = stack2[stack2.length - 1];
          let index3 = parent2.nodes.indexOf(block);
          parent2.nodes.splice(index3, 1, ...block.nodes);
        }
      } while (stack2.length > 0);
      push({ type: "eos" });
      return ast;
    }, "parse");
    module2.exports = parse2;
  }
});

// ../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/index.js
var require_braces = __commonJS({
  "../../node_modules/.pnpm/braces@3.0.2/node_modules/braces/index.js"(exports2, module2) {
    "use strict";
    var stringify2 = require_stringify();
    var compile = require_compile();
    var expand = require_expand();
    var parse2 = require_parse3();
    var braces = /* @__PURE__ */ __name((input, options2 = {}) => {
      let output = [];
      if (Array.isArray(input)) {
        for (let pattern of input) {
          let result = braces.create(pattern, options2);
          if (Array.isArray(result)) {
            output.push(...result);
          } else {
            output.push(result);
          }
        }
      } else {
        output = [].concat(braces.create(input, options2));
      }
      if (options2 && options2.expand === true && options2.nodupes === true) {
        output = [...new Set(output)];
      }
      return output;
    }, "braces");
    braces.parse = (input, options2 = {}) => parse2(input, options2);
    braces.stringify = (input, options2 = {}) => {
      if (typeof input === "string") {
        return stringify2(braces.parse(input, options2), options2);
      }
      return stringify2(input, options2);
    };
    braces.compile = (input, options2 = {}) => {
      if (typeof input === "string") {
        input = braces.parse(input, options2);
      }
      return compile(input, options2);
    };
    braces.expand = (input, options2 = {}) => {
      if (typeof input === "string") {
        input = braces.parse(input, options2);
      }
      let result = expand(input, options2);
      if (options2.noempty === true) {
        result = result.filter(Boolean);
      }
      if (options2.nodupes === true) {
        result = [...new Set(result)];
      }
      return result;
    };
    braces.create = (input, options2 = {}) => {
      if (input === "" || input.length < 3) {
        return [input];
      }
      return options2.expand !== true ? braces.compile(input, options2) : braces.expand(input, options2);
    };
    module2.exports = braces;
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/constants.js
var require_constants2 = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/constants.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var WIN_SLASH = "\\\\/";
    var WIN_NO_SLASH = `[^${WIN_SLASH}]`;
    var DOT_LITERAL = "\\.";
    var PLUS_LITERAL = "\\+";
    var QMARK_LITERAL = "\\?";
    var SLASH_LITERAL = "\\/";
    var ONE_CHAR = "(?=.)";
    var QMARK = "[^/]";
    var END_ANCHOR = `(?:${SLASH_LITERAL}|$)`;
    var START_ANCHOR = `(?:^|${SLASH_LITERAL})`;
    var DOTS_SLASH = `${DOT_LITERAL}{1,2}${END_ANCHOR}`;
    var NO_DOT = `(?!${DOT_LITERAL})`;
    var NO_DOTS = `(?!${START_ANCHOR}${DOTS_SLASH})`;
    var NO_DOT_SLASH = `(?!${DOT_LITERAL}{0,1}${END_ANCHOR})`;
    var NO_DOTS_SLASH = `(?!${DOTS_SLASH})`;
    var QMARK_NO_DOT = `[^.${SLASH_LITERAL}]`;
    var STAR = `${QMARK}*?`;
    var POSIX_CHARS = {
      DOT_LITERAL,
      PLUS_LITERAL,
      QMARK_LITERAL,
      SLASH_LITERAL,
      ONE_CHAR,
      QMARK,
      END_ANCHOR,
      DOTS_SLASH,
      NO_DOT,
      NO_DOTS,
      NO_DOT_SLASH,
      NO_DOTS_SLASH,
      QMARK_NO_DOT,
      STAR,
      START_ANCHOR
    };
    var WINDOWS_CHARS = {
      ...POSIX_CHARS,
      SLASH_LITERAL: `[${WIN_SLASH}]`,
      QMARK: WIN_NO_SLASH,
      STAR: `${WIN_NO_SLASH}*?`,
      DOTS_SLASH: `${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$)`,
      NO_DOT: `(?!${DOT_LITERAL})`,
      NO_DOTS: `(?!(?:^|[${WIN_SLASH}])${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      NO_DOT_SLASH: `(?!${DOT_LITERAL}{0,1}(?:[${WIN_SLASH}]|$))`,
      NO_DOTS_SLASH: `(?!${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      QMARK_NO_DOT: `[^.${WIN_SLASH}]`,
      START_ANCHOR: `(?:^|[${WIN_SLASH}])`,
      END_ANCHOR: `(?:[${WIN_SLASH}]|$)`
    };
    var POSIX_REGEX_SOURCE = {
      alnum: "a-zA-Z0-9",
      alpha: "a-zA-Z",
      ascii: "\\x00-\\x7F",
      blank: " \\t",
      cntrl: "\\x00-\\x1F\\x7F",
      digit: "0-9",
      graph: "\\x21-\\x7E",
      lower: "a-z",
      print: "\\x20-\\x7E ",
      punct: "\\-!\"#$%&'()\\*+,./:;<=>?@[\\]^_`{|}~",
      space: " \\t\\r\\n\\v\\f",
      upper: "A-Z",
      word: "A-Za-z0-9_",
      xdigit: "A-Fa-f0-9"
    };
    module2.exports = {
      MAX_LENGTH: 1024 * 64,
      POSIX_REGEX_SOURCE,
      REGEX_BACKSLASH: /\\(?![*+?^${}(|)[\]])/g,
      REGEX_NON_SPECIAL_CHARS: /^[^@![\].,$*+?^{}()|\\/]+/,
      REGEX_SPECIAL_CHARS: /[-*+?.^${}(|)[\]]/,
      REGEX_SPECIAL_CHARS_BACKREF: /(\\?)((\W)(\3*))/g,
      REGEX_SPECIAL_CHARS_GLOBAL: /([-*+?.^${}(|)[\]])/g,
      REGEX_REMOVE_BACKSLASH: /(?:\[.*?[^\\]\]|\\(?=.))/g,
      REPLACEMENTS: {
        "***": "*",
        "**/**": "**",
        "**/**/**": "**"
      },
      CHAR_0: 48,
      CHAR_9: 57,
      CHAR_UPPERCASE_A: 65,
      CHAR_LOWERCASE_A: 97,
      CHAR_UPPERCASE_Z: 90,
      CHAR_LOWERCASE_Z: 122,
      CHAR_LEFT_PARENTHESES: 40,
      CHAR_RIGHT_PARENTHESES: 41,
      CHAR_ASTERISK: 42,
      CHAR_AMPERSAND: 38,
      CHAR_AT: 64,
      CHAR_BACKWARD_SLASH: 92,
      CHAR_CARRIAGE_RETURN: 13,
      CHAR_CIRCUMFLEX_ACCENT: 94,
      CHAR_COLON: 58,
      CHAR_COMMA: 44,
      CHAR_DOT: 46,
      CHAR_DOUBLE_QUOTE: 34,
      CHAR_EQUAL: 61,
      CHAR_EXCLAMATION_MARK: 33,
      CHAR_FORM_FEED: 12,
      CHAR_FORWARD_SLASH: 47,
      CHAR_GRAVE_ACCENT: 96,
      CHAR_HASH: 35,
      CHAR_HYPHEN_MINUS: 45,
      CHAR_LEFT_ANGLE_BRACKET: 60,
      CHAR_LEFT_CURLY_BRACE: 123,
      CHAR_LEFT_SQUARE_BRACKET: 91,
      CHAR_LINE_FEED: 10,
      CHAR_NO_BREAK_SPACE: 160,
      CHAR_PERCENT: 37,
      CHAR_PLUS: 43,
      CHAR_QUESTION_MARK: 63,
      CHAR_RIGHT_ANGLE_BRACKET: 62,
      CHAR_RIGHT_CURLY_BRACE: 125,
      CHAR_RIGHT_SQUARE_BRACKET: 93,
      CHAR_SEMICOLON: 59,
      CHAR_SINGLE_QUOTE: 39,
      CHAR_SPACE: 32,
      CHAR_TAB: 9,
      CHAR_UNDERSCORE: 95,
      CHAR_VERTICAL_LINE: 124,
      CHAR_ZERO_WIDTH_NOBREAK_SPACE: 65279,
      SEP: path32.sep,
      extglobChars(chars2) {
        return {
          "!": { type: "negate", open: "(?:(?!(?:", close: `))${chars2.STAR})` },
          "?": { type: "qmark", open: "(?:", close: ")?" },
          "+": { type: "plus", open: "(?:", close: ")+" },
          "*": { type: "star", open: "(?:", close: ")*" },
          "@": { type: "at", open: "(?:", close: ")" }
        };
      },
      globChars(win32) {
        return win32 === true ? WINDOWS_CHARS : POSIX_CHARS;
      }
    };
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/utils.js
var require_utils2 = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/utils.js"(exports2) {
    "use strict";
    var path32 = require("path");
    var win32 = process.platform === "win32";
    var {
      REGEX_BACKSLASH,
      REGEX_REMOVE_BACKSLASH,
      REGEX_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_GLOBAL
    } = require_constants2();
    exports2.isObject = (val) => val !== null && typeof val === "object" && !Array.isArray(val);
    exports2.hasRegexChars = (str) => REGEX_SPECIAL_CHARS.test(str);
    exports2.isRegexChar = (str) => str.length === 1 && exports2.hasRegexChars(str);
    exports2.escapeRegex = (str) => str.replace(REGEX_SPECIAL_CHARS_GLOBAL, "\\$1");
    exports2.toPosixSlashes = (str) => str.replace(REGEX_BACKSLASH, "/");
    exports2.removeBackslashes = (str) => {
      return str.replace(REGEX_REMOVE_BACKSLASH, (match4) => {
        return match4 === "\\" ? "" : match4;
      });
    };
    exports2.supportsLookbehinds = () => {
      const segs = process.version.slice(1).split(".").map(Number);
      if (segs.length === 3 && segs[0] >= 9 || segs[0] === 8 && segs[1] >= 10) {
        return true;
      }
      return false;
    };
    exports2.isWindows = (options2) => {
      if (options2 && typeof options2.windows === "boolean") {
        return options2.windows;
      }
      return win32 === true || path32.sep === "\\";
    };
    exports2.escapeLast = (input, char, lastIdx) => {
      const idx = input.lastIndexOf(char, lastIdx);
      if (idx === -1)
        return input;
      if (input[idx - 1] === "\\")
        return exports2.escapeLast(input, char, idx - 1);
      return `${input.slice(0, idx)}\\${input.slice(idx)}`;
    };
    exports2.removePrefix = (input, state = {}) => {
      let output = input;
      if (output.startsWith("./")) {
        output = output.slice(2);
        state.prefix = "./";
      }
      return output;
    };
    exports2.wrapOutput = (input, state = {}, options2 = {}) => {
      const prepend = options2.contains ? "" : "^";
      const append = options2.contains ? "" : "$";
      let output = `${prepend}(?:${input})${append}`;
      if (state.negated === true) {
        output = `(?:^(?!${output}).*$)`;
      }
      return output;
    };
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/scan.js
var require_scan2 = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/scan.js"(exports2, module2) {
    "use strict";
    var utils = require_utils2();
    var {
      CHAR_ASTERISK,
      CHAR_AT,
      CHAR_BACKWARD_SLASH,
      CHAR_COMMA,
      CHAR_DOT,
      CHAR_EXCLAMATION_MARK,
      CHAR_FORWARD_SLASH,
      CHAR_LEFT_CURLY_BRACE,
      CHAR_LEFT_PARENTHESES,
      CHAR_LEFT_SQUARE_BRACKET,
      CHAR_PLUS,
      CHAR_QUESTION_MARK,
      CHAR_RIGHT_CURLY_BRACE,
      CHAR_RIGHT_PARENTHESES,
      CHAR_RIGHT_SQUARE_BRACKET
    } = require_constants2();
    var isPathSeparator = /* @__PURE__ */ __name((code) => {
      return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
    }, "isPathSeparator");
    var depth = /* @__PURE__ */ __name((token) => {
      if (token.isPrefix !== true) {
        token.depth = token.isGlobstar ? Infinity : 1;
      }
    }, "depth");
    var scan = /* @__PURE__ */ __name((input, options2) => {
      const opts2 = options2 || {};
      const length = input.length - 1;
      const scanToEnd = opts2.parts === true || opts2.scanToEnd === true;
      const slashes = [];
      const tokens = [];
      const parts = [];
      let str = input;
      let index2 = -1;
      let start = 0;
      let lastIndex = 0;
      let isBrace = false;
      let isBracket = false;
      let isGlob = false;
      let isExtglob = false;
      let isGlobstar = false;
      let braceEscaped = false;
      let backslashes = false;
      let negated = false;
      let negatedExtglob = false;
      let finished = false;
      let braces = 0;
      let prev;
      let code;
      let token = { value: "", depth: 0, isGlob: false };
      const eos = /* @__PURE__ */ __name(() => index2 >= length, "eos");
      const peek = /* @__PURE__ */ __name(() => str.charCodeAt(index2 + 1), "peek");
      const advance = /* @__PURE__ */ __name(() => {
        prev = code;
        return str.charCodeAt(++index2);
      }, "advance");
      while (index2 < length) {
        code = advance();
        let next;
        if (code === CHAR_BACKWARD_SLASH) {
          backslashes = token.backslashes = true;
          code = advance();
          if (code === CHAR_LEFT_CURLY_BRACE) {
            braceEscaped = true;
          }
          continue;
        }
        if (braceEscaped === true || code === CHAR_LEFT_CURLY_BRACE) {
          braces++;
          while (eos() !== true && (code = advance())) {
            if (code === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance();
              continue;
            }
            if (code === CHAR_LEFT_CURLY_BRACE) {
              braces++;
              continue;
            }
            if (braceEscaped !== true && code === CHAR_DOT && (code = advance()) === CHAR_DOT) {
              isBrace = token.isBrace = true;
              isGlob = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (braceEscaped !== true && code === CHAR_COMMA) {
              isBrace = token.isBrace = true;
              isGlob = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (code === CHAR_RIGHT_CURLY_BRACE) {
              braces--;
              if (braces === 0) {
                braceEscaped = false;
                isBrace = token.isBrace = true;
                finished = true;
                break;
              }
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_FORWARD_SLASH) {
          slashes.push(index2);
          tokens.push(token);
          token = { value: "", depth: 0, isGlob: false };
          if (finished === true)
            continue;
          if (prev === CHAR_DOT && index2 === start + 1) {
            start += 2;
            continue;
          }
          lastIndex = index2 + 1;
          continue;
        }
        if (opts2.noext !== true) {
          const isExtglobChar = code === CHAR_PLUS || code === CHAR_AT || code === CHAR_ASTERISK || code === CHAR_QUESTION_MARK || code === CHAR_EXCLAMATION_MARK;
          if (isExtglobChar === true && peek() === CHAR_LEFT_PARENTHESES) {
            isGlob = token.isGlob = true;
            isExtglob = token.isExtglob = true;
            finished = true;
            if (code === CHAR_EXCLAMATION_MARK && index2 === start) {
              negatedExtglob = true;
            }
            if (scanToEnd === true) {
              while (eos() !== true && (code = advance())) {
                if (code === CHAR_BACKWARD_SLASH) {
                  backslashes = token.backslashes = true;
                  code = advance();
                  continue;
                }
                if (code === CHAR_RIGHT_PARENTHESES) {
                  isGlob = token.isGlob = true;
                  finished = true;
                  break;
                }
              }
              continue;
            }
            break;
          }
        }
        if (code === CHAR_ASTERISK) {
          if (prev === CHAR_ASTERISK)
            isGlobstar = token.isGlobstar = true;
          isGlob = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_QUESTION_MARK) {
          isGlob = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_LEFT_SQUARE_BRACKET) {
          while (eos() !== true && (next = advance())) {
            if (next === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance();
              continue;
            }
            if (next === CHAR_RIGHT_SQUARE_BRACKET) {
              isBracket = token.isBracket = true;
              isGlob = token.isGlob = true;
              finished = true;
              break;
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (opts2.nonegate !== true && code === CHAR_EXCLAMATION_MARK && index2 === start) {
          negated = token.negated = true;
          start++;
          continue;
        }
        if (opts2.noparen !== true && code === CHAR_LEFT_PARENTHESES) {
          isGlob = token.isGlob = true;
          if (scanToEnd === true) {
            while (eos() !== true && (code = advance())) {
              if (code === CHAR_LEFT_PARENTHESES) {
                backslashes = token.backslashes = true;
                code = advance();
                continue;
              }
              if (code === CHAR_RIGHT_PARENTHESES) {
                finished = true;
                break;
              }
            }
            continue;
          }
          break;
        }
        if (isGlob === true) {
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
      }
      if (opts2.noext === true) {
        isExtglob = false;
        isGlob = false;
      }
      let base = str;
      let prefix = "";
      let glob = "";
      if (start > 0) {
        prefix = str.slice(0, start);
        str = str.slice(start);
        lastIndex -= start;
      }
      if (base && isGlob === true && lastIndex > 0) {
        base = str.slice(0, lastIndex);
        glob = str.slice(lastIndex);
      } else if (isGlob === true) {
        base = "";
        glob = str;
      } else {
        base = str;
      }
      if (base && base !== "" && base !== "/" && base !== str) {
        if (isPathSeparator(base.charCodeAt(base.length - 1))) {
          base = base.slice(0, -1);
        }
      }
      if (opts2.unescape === true) {
        if (glob)
          glob = utils.removeBackslashes(glob);
        if (base && backslashes === true) {
          base = utils.removeBackslashes(base);
        }
      }
      const state = {
        prefix,
        input,
        start,
        base,
        glob,
        isBrace,
        isBracket,
        isGlob,
        isExtglob,
        isGlobstar,
        negated,
        negatedExtglob
      };
      if (opts2.tokens === true) {
        state.maxDepth = 0;
        if (!isPathSeparator(code)) {
          tokens.push(token);
        }
        state.tokens = tokens;
      }
      if (opts2.parts === true || opts2.tokens === true) {
        let prevIndex;
        for (let idx = 0; idx < slashes.length; idx++) {
          const n3 = prevIndex ? prevIndex + 1 : start;
          const i3 = slashes[idx];
          const value = input.slice(n3, i3);
          if (opts2.tokens) {
            if (idx === 0 && start !== 0) {
              tokens[idx].isPrefix = true;
              tokens[idx].value = prefix;
            } else {
              tokens[idx].value = value;
            }
            depth(tokens[idx]);
            state.maxDepth += tokens[idx].depth;
          }
          if (idx !== 0 || value !== "") {
            parts.push(value);
          }
          prevIndex = i3;
        }
        if (prevIndex && prevIndex + 1 < input.length) {
          const value = input.slice(prevIndex + 1);
          parts.push(value);
          if (opts2.tokens) {
            tokens[tokens.length - 1].value = value;
            depth(tokens[tokens.length - 1]);
            state.maxDepth += tokens[tokens.length - 1].depth;
          }
        }
        state.slashes = slashes;
        state.parts = parts;
      }
      return state;
    }, "scan");
    module2.exports = scan;
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/parse.js
var require_parse4 = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/parse.js"(exports2, module2) {
    "use strict";
    var constants = require_constants2();
    var utils = require_utils2();
    var {
      MAX_LENGTH,
      POSIX_REGEX_SOURCE,
      REGEX_NON_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_BACKREF,
      REPLACEMENTS
    } = constants;
    var expandRange = /* @__PURE__ */ __name((args3, options2) => {
      if (typeof options2.expandRange === "function") {
        return options2.expandRange(...args3, options2);
      }
      args3.sort();
      const value = `[${args3.join("-")}]`;
      try {
        new RegExp(value);
      } catch (ex) {
        return args3.map((v3) => utils.escapeRegex(v3)).join("..");
      }
      return value;
    }, "expandRange");
    var syntaxError = /* @__PURE__ */ __name((type, char) => {
      return `Missing ${type}: "${char}" - use "\\\\${char}" to match literal characters`;
    }, "syntaxError");
    var parse2 = /* @__PURE__ */ __name((input, options2) => {
      if (typeof input !== "string") {
        throw new TypeError("Expected a string");
      }
      input = REPLACEMENTS[input] || input;
      const opts2 = { ...options2 };
      const max = typeof opts2.maxLength === "number" ? Math.min(MAX_LENGTH, opts2.maxLength) : MAX_LENGTH;
      let len = input.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      const bos = { type: "bos", value: "", output: opts2.prepend || "" };
      const tokens = [bos];
      const capture = opts2.capture ? "" : "?:";
      const win32 = utils.isWindows(options2);
      const PLATFORM_CHARS = constants.globChars(win32);
      const EXTGLOB_CHARS = constants.extglobChars(PLATFORM_CHARS);
      const {
        DOT_LITERAL,
        PLUS_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOT_SLASH,
        NO_DOTS_SLASH,
        QMARK,
        QMARK_NO_DOT,
        STAR,
        START_ANCHOR
      } = PLATFORM_CHARS;
      const globstar = /* @__PURE__ */ __name((opts3) => {
        return `(${capture}(?:(?!${START_ANCHOR}${opts3.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      }, "globstar");
      const nodot = opts2.dot ? "" : NO_DOT;
      const qmarkNoDot = opts2.dot ? QMARK : QMARK_NO_DOT;
      let star = opts2.bash === true ? globstar(opts2) : STAR;
      if (opts2.capture) {
        star = `(${star})`;
      }
      if (typeof opts2.noext === "boolean") {
        opts2.noextglob = opts2.noext;
      }
      const state = {
        input,
        index: -1,
        start: 0,
        dot: opts2.dot === true,
        consumed: "",
        output: "",
        prefix: "",
        backtrack: false,
        negated: false,
        brackets: 0,
        braces: 0,
        parens: 0,
        quotes: 0,
        globstar: false,
        tokens
      };
      input = utils.removePrefix(input, state);
      len = input.length;
      const extglobs = [];
      const braces = [];
      const stack2 = [];
      let prev = bos;
      let value;
      const eos = /* @__PURE__ */ __name(() => state.index === len - 1, "eos");
      const peek = state.peek = (n3 = 1) => input[state.index + n3];
      const advance = state.advance = () => input[++state.index] || "";
      const remaining = /* @__PURE__ */ __name(() => input.slice(state.index + 1), "remaining");
      const consume = /* @__PURE__ */ __name((value2 = "", num = 0) => {
        state.consumed += value2;
        state.index += num;
      }, "consume");
      const append = /* @__PURE__ */ __name((token) => {
        state.output += token.output != null ? token.output : token.value;
        consume(token.value);
      }, "append");
      const negate = /* @__PURE__ */ __name(() => {
        let count = 1;
        while (peek() === "!" && (peek(2) !== "(" || peek(3) === "?")) {
          advance();
          state.start++;
          count++;
        }
        if (count % 2 === 0) {
          return false;
        }
        state.negated = true;
        state.start++;
        return true;
      }, "negate");
      const increment = /* @__PURE__ */ __name((type) => {
        state[type]++;
        stack2.push(type);
      }, "increment");
      const decrement = /* @__PURE__ */ __name((type) => {
        state[type]--;
        stack2.pop();
      }, "decrement");
      const push = /* @__PURE__ */ __name((tok) => {
        if (prev.type === "globstar") {
          const isBrace = state.braces > 0 && (tok.type === "comma" || tok.type === "brace");
          const isExtglob = tok.extglob === true || extglobs.length && (tok.type === "pipe" || tok.type === "paren");
          if (tok.type !== "slash" && tok.type !== "paren" && !isBrace && !isExtglob) {
            state.output = state.output.slice(0, -prev.output.length);
            prev.type = "star";
            prev.value = "*";
            prev.output = star;
            state.output += prev.output;
          }
        }
        if (extglobs.length && tok.type !== "paren") {
          extglobs[extglobs.length - 1].inner += tok.value;
        }
        if (tok.value || tok.output)
          append(tok);
        if (prev && prev.type === "text" && tok.type === "text") {
          prev.value += tok.value;
          prev.output = (prev.output || "") + tok.value;
          return;
        }
        tok.prev = prev;
        tokens.push(tok);
        prev = tok;
      }, "push");
      const extglobOpen = /* @__PURE__ */ __name((type, value2) => {
        const token = { ...EXTGLOB_CHARS[value2], conditions: 1, inner: "" };
        token.prev = prev;
        token.parens = state.parens;
        token.output = state.output;
        const output = (opts2.capture ? "(" : "") + token.open;
        increment("parens");
        push({ type, value: value2, output: state.output ? "" : ONE_CHAR });
        push({ type: "paren", extglob: true, value: advance(), output });
        extglobs.push(token);
      }, "extglobOpen");
      const extglobClose = /* @__PURE__ */ __name((token) => {
        let output = token.close + (opts2.capture ? ")" : "");
        let rest;
        if (token.type === "negate") {
          let extglobStar = star;
          if (token.inner && token.inner.length > 1 && token.inner.includes("/")) {
            extglobStar = globstar(opts2);
          }
          if (extglobStar !== star || eos() || /^\)+$/.test(remaining())) {
            output = token.close = `)$))${extglobStar}`;
          }
          if (token.inner.includes("*") && (rest = remaining()) && /^\.[^\\/.]+$/.test(rest)) {
            const expression = parse2(rest, { ...options2, fastpaths: false }).output;
            output = token.close = `)${expression})${extglobStar})`;
          }
          if (token.prev.type === "bos") {
            state.negatedExtglob = true;
          }
        }
        push({ type: "paren", extglob: true, value, output });
        decrement("parens");
      }, "extglobClose");
      if (opts2.fastpaths !== false && !/(^[*!]|[/()[\]{}"])/.test(input)) {
        let backslashes = false;
        let output = input.replace(REGEX_SPECIAL_CHARS_BACKREF, (m4, esc, chars2, first, rest, index2) => {
          if (first === "\\") {
            backslashes = true;
            return m4;
          }
          if (first === "?") {
            if (esc) {
              return esc + first + (rest ? QMARK.repeat(rest.length) : "");
            }
            if (index2 === 0) {
              return qmarkNoDot + (rest ? QMARK.repeat(rest.length) : "");
            }
            return QMARK.repeat(chars2.length);
          }
          if (first === ".") {
            return DOT_LITERAL.repeat(chars2.length);
          }
          if (first === "*") {
            if (esc) {
              return esc + first + (rest ? star : "");
            }
            return star;
          }
          return esc ? m4 : `\\${m4}`;
        });
        if (backslashes === true) {
          if (opts2.unescape === true) {
            output = output.replace(/\\/g, "");
          } else {
            output = output.replace(/\\+/g, (m4) => {
              return m4.length % 2 === 0 ? "\\\\" : m4 ? "\\" : "";
            });
          }
        }
        if (output === input && opts2.contains === true) {
          state.output = input;
          return state;
        }
        state.output = utils.wrapOutput(output, state, options2);
        return state;
      }
      while (!eos()) {
        value = advance();
        if (value === "\0") {
          continue;
        }
        if (value === "\\") {
          const next = peek();
          if (next === "/" && opts2.bash !== true) {
            continue;
          }
          if (next === "." || next === ";") {
            continue;
          }
          if (!next) {
            value += "\\";
            push({ type: "text", value });
            continue;
          }
          const match4 = /^\\+/.exec(remaining());
          let slashes = 0;
          if (match4 && match4[0].length > 2) {
            slashes = match4[0].length;
            state.index += slashes;
            if (slashes % 2 !== 0) {
              value += "\\";
            }
          }
          if (opts2.unescape === true) {
            value = advance();
          } else {
            value += advance();
          }
          if (state.brackets === 0) {
            push({ type: "text", value });
            continue;
          }
        }
        if (state.brackets > 0 && (value !== "]" || prev.value === "[" || prev.value === "[^")) {
          if (opts2.posix !== false && value === ":") {
            const inner = prev.value.slice(1);
            if (inner.includes("[")) {
              prev.posix = true;
              if (inner.includes(":")) {
                const idx = prev.value.lastIndexOf("[");
                const pre = prev.value.slice(0, idx);
                const rest2 = prev.value.slice(idx + 2);
                const posix = POSIX_REGEX_SOURCE[rest2];
                if (posix) {
                  prev.value = pre + posix;
                  state.backtrack = true;
                  advance();
                  if (!bos.output && tokens.indexOf(prev) === 1) {
                    bos.output = ONE_CHAR;
                  }
                  continue;
                }
              }
            }
          }
          if (value === "[" && peek() !== ":" || value === "-" && peek() === "]") {
            value = `\\${value}`;
          }
          if (value === "]" && (prev.value === "[" || prev.value === "[^")) {
            value = `\\${value}`;
          }
          if (opts2.posix === true && value === "!" && prev.value === "[") {
            value = "^";
          }
          prev.value += value;
          append({ value });
          continue;
        }
        if (state.quotes === 1 && value !== '"') {
          value = utils.escapeRegex(value);
          prev.value += value;
          append({ value });
          continue;
        }
        if (value === '"') {
          state.quotes = state.quotes === 1 ? 0 : 1;
          if (opts2.keepQuotes === true) {
            push({ type: "text", value });
          }
          continue;
        }
        if (value === "(") {
          increment("parens");
          push({ type: "paren", value });
          continue;
        }
        if (value === ")") {
          if (state.parens === 0 && opts2.strictBrackets === true) {
            throw new SyntaxError(syntaxError("opening", "("));
          }
          const extglob = extglobs[extglobs.length - 1];
          if (extglob && state.parens === extglob.parens + 1) {
            extglobClose(extglobs.pop());
            continue;
          }
          push({ type: "paren", value, output: state.parens ? ")" : "\\)" });
          decrement("parens");
          continue;
        }
        if (value === "[") {
          if (opts2.nobracket === true || !remaining().includes("]")) {
            if (opts2.nobracket !== true && opts2.strictBrackets === true) {
              throw new SyntaxError(syntaxError("closing", "]"));
            }
            value = `\\${value}`;
          } else {
            increment("brackets");
          }
          push({ type: "bracket", value });
          continue;
        }
        if (value === "]") {
          if (opts2.nobracket === true || prev && prev.type === "bracket" && prev.value.length === 1) {
            push({ type: "text", value, output: `\\${value}` });
            continue;
          }
          if (state.brackets === 0) {
            if (opts2.strictBrackets === true) {
              throw new SyntaxError(syntaxError("opening", "["));
            }
            push({ type: "text", value, output: `\\${value}` });
            continue;
          }
          decrement("brackets");
          const prevValue = prev.value.slice(1);
          if (prev.posix !== true && prevValue[0] === "^" && !prevValue.includes("/")) {
            value = `/${value}`;
          }
          prev.value += value;
          append({ value });
          if (opts2.literalBrackets === false || utils.hasRegexChars(prevValue)) {
            continue;
          }
          const escaped = utils.escapeRegex(prev.value);
          state.output = state.output.slice(0, -prev.value.length);
          if (opts2.literalBrackets === true) {
            state.output += escaped;
            prev.value = escaped;
            continue;
          }
          prev.value = `(${capture}${escaped}|${prev.value})`;
          state.output += prev.value;
          continue;
        }
        if (value === "{" && opts2.nobrace !== true) {
          increment("braces");
          const open4 = {
            type: "brace",
            value,
            output: "(",
            outputIndex: state.output.length,
            tokensIndex: state.tokens.length
          };
          braces.push(open4);
          push(open4);
          continue;
        }
        if (value === "}") {
          const brace = braces[braces.length - 1];
          if (opts2.nobrace === true || !brace) {
            push({ type: "text", value, output: value });
            continue;
          }
          let output = ")";
          if (brace.dots === true) {
            const arr = tokens.slice();
            const range2 = [];
            for (let i3 = arr.length - 1; i3 >= 0; i3--) {
              tokens.pop();
              if (arr[i3].type === "brace") {
                break;
              }
              if (arr[i3].type !== "dots") {
                range2.unshift(arr[i3].value);
              }
            }
            output = expandRange(range2, opts2);
            state.backtrack = true;
          }
          if (brace.comma !== true && brace.dots !== true) {
            const out = state.output.slice(0, brace.outputIndex);
            const toks = state.tokens.slice(brace.tokensIndex);
            brace.value = brace.output = "\\{";
            value = output = "\\}";
            state.output = out;
            for (const t5 of toks) {
              state.output += t5.output || t5.value;
            }
          }
          push({ type: "brace", value, output });
          decrement("braces");
          braces.pop();
          continue;
        }
        if (value === "|") {
          if (extglobs.length > 0) {
            extglobs[extglobs.length - 1].conditions++;
          }
          push({ type: "text", value });
          continue;
        }
        if (value === ",") {
          let output = value;
          const brace = braces[braces.length - 1];
          if (brace && stack2[stack2.length - 1] === "braces") {
            brace.comma = true;
            output = "|";
          }
          push({ type: "comma", value, output });
          continue;
        }
        if (value === "/") {
          if (prev.type === "dot" && state.index === state.start + 1) {
            state.start = state.index + 1;
            state.consumed = "";
            state.output = "";
            tokens.pop();
            prev = bos;
            continue;
          }
          push({ type: "slash", value, output: SLASH_LITERAL });
          continue;
        }
        if (value === ".") {
          if (state.braces > 0 && prev.type === "dot") {
            if (prev.value === ".")
              prev.output = DOT_LITERAL;
            const brace = braces[braces.length - 1];
            prev.type = "dots";
            prev.output += value;
            prev.value += value;
            brace.dots = true;
            continue;
          }
          if (state.braces + state.parens === 0 && prev.type !== "bos" && prev.type !== "slash") {
            push({ type: "text", value, output: DOT_LITERAL });
            continue;
          }
          push({ type: "dot", value, output: DOT_LITERAL });
          continue;
        }
        if (value === "?") {
          const isGroup = prev && prev.value === "(";
          if (!isGroup && opts2.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("qmark", value);
            continue;
          }
          if (prev && prev.type === "paren") {
            const next = peek();
            let output = value;
            if (next === "<" && !utils.supportsLookbehinds()) {
              throw new Error("Node.js v10 or higher is required for regex lookbehinds");
            }
            if (prev.value === "(" && !/[!=<:]/.test(next) || next === "<" && !/<([!=]|\w+>)/.test(remaining())) {
              output = `\\${value}`;
            }
            push({ type: "text", value, output });
            continue;
          }
          if (opts2.dot !== true && (prev.type === "slash" || prev.type === "bos")) {
            push({ type: "qmark", value, output: QMARK_NO_DOT });
            continue;
          }
          push({ type: "qmark", value, output: QMARK });
          continue;
        }
        if (value === "!") {
          if (opts2.noextglob !== true && peek() === "(") {
            if (peek(2) !== "?" || !/[!=<:]/.test(peek(3))) {
              extglobOpen("negate", value);
              continue;
            }
          }
          if (opts2.nonegate !== true && state.index === 0) {
            negate();
            continue;
          }
        }
        if (value === "+") {
          if (opts2.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("plus", value);
            continue;
          }
          if (prev && prev.value === "(" || opts2.regex === false) {
            push({ type: "plus", value, output: PLUS_LITERAL });
            continue;
          }
          if (prev && (prev.type === "bracket" || prev.type === "paren" || prev.type === "brace") || state.parens > 0) {
            push({ type: "plus", value });
            continue;
          }
          push({ type: "plus", value: PLUS_LITERAL });
          continue;
        }
        if (value === "@") {
          if (opts2.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            push({ type: "at", extglob: true, value, output: "" });
            continue;
          }
          push({ type: "text", value });
          continue;
        }
        if (value !== "*") {
          if (value === "$" || value === "^") {
            value = `\\${value}`;
          }
          const match4 = REGEX_NON_SPECIAL_CHARS.exec(remaining());
          if (match4) {
            value += match4[0];
            state.index += match4[0].length;
          }
          push({ type: "text", value });
          continue;
        }
        if (prev && (prev.type === "globstar" || prev.star === true)) {
          prev.type = "star";
          prev.star = true;
          prev.value += value;
          prev.output = star;
          state.backtrack = true;
          state.globstar = true;
          consume(value);
          continue;
        }
        let rest = remaining();
        if (opts2.noextglob !== true && /^\([^?]/.test(rest)) {
          extglobOpen("star", value);
          continue;
        }
        if (prev.type === "star") {
          if (opts2.noglobstar === true) {
            consume(value);
            continue;
          }
          const prior = prev.prev;
          const before = prior.prev;
          const isStart = prior.type === "slash" || prior.type === "bos";
          const afterStar = before && (before.type === "star" || before.type === "globstar");
          if (opts2.bash === true && (!isStart || rest[0] && rest[0] !== "/")) {
            push({ type: "star", value, output: "" });
            continue;
          }
          const isBrace = state.braces > 0 && (prior.type === "comma" || prior.type === "brace");
          const isExtglob = extglobs.length && (prior.type === "pipe" || prior.type === "paren");
          if (!isStart && prior.type !== "paren" && !isBrace && !isExtglob) {
            push({ type: "star", value, output: "" });
            continue;
          }
          while (rest.slice(0, 3) === "/**") {
            const after = input[state.index + 4];
            if (after && after !== "/") {
              break;
            }
            rest = rest.slice(3);
            consume("/**", 3);
          }
          if (prior.type === "bos" && eos()) {
            prev.type = "globstar";
            prev.value += value;
            prev.output = globstar(opts2);
            state.output = prev.output;
            state.globstar = true;
            consume(value);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && !afterStar && eos()) {
            state.output = state.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = globstar(opts2) + (opts2.strictSlashes ? ")" : "|$)");
            prev.value += value;
            state.globstar = true;
            state.output += prior.output + prev.output;
            consume(value);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && rest[0] === "/") {
            const end = rest[1] !== void 0 ? "|$" : "";
            state.output = state.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = `${globstar(opts2)}${SLASH_LITERAL}|${SLASH_LITERAL}${end})`;
            prev.value += value;
            state.output += prior.output + prev.output;
            state.globstar = true;
            consume(value + advance());
            push({ type: "slash", value: "/", output: "" });
            continue;
          }
          if (prior.type === "bos" && rest[0] === "/") {
            prev.type = "globstar";
            prev.value += value;
            prev.output = `(?:^|${SLASH_LITERAL}|${globstar(opts2)}${SLASH_LITERAL})`;
            state.output = prev.output;
            state.globstar = true;
            consume(value + advance());
            push({ type: "slash", value: "/", output: "" });
            continue;
          }
          state.output = state.output.slice(0, -prev.output.length);
          prev.type = "globstar";
          prev.output = globstar(opts2);
          prev.value += value;
          state.output += prev.output;
          state.globstar = true;
          consume(value);
          continue;
        }
        const token = { type: "star", value, output: star };
        if (opts2.bash === true) {
          token.output = ".*?";
          if (prev.type === "bos" || prev.type === "slash") {
            token.output = nodot + token.output;
          }
          push(token);
          continue;
        }
        if (prev && (prev.type === "bracket" || prev.type === "paren") && opts2.regex === true) {
          token.output = value;
          push(token);
          continue;
        }
        if (state.index === state.start || prev.type === "slash" || prev.type === "dot") {
          if (prev.type === "dot") {
            state.output += NO_DOT_SLASH;
            prev.output += NO_DOT_SLASH;
          } else if (opts2.dot === true) {
            state.output += NO_DOTS_SLASH;
            prev.output += NO_DOTS_SLASH;
          } else {
            state.output += nodot;
            prev.output += nodot;
          }
          if (peek() !== "*") {
            state.output += ONE_CHAR;
            prev.output += ONE_CHAR;
          }
        }
        push(token);
      }
      while (state.brackets > 0) {
        if (opts2.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", "]"));
        state.output = utils.escapeLast(state.output, "[");
        decrement("brackets");
      }
      while (state.parens > 0) {
        if (opts2.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", ")"));
        state.output = utils.escapeLast(state.output, "(");
        decrement("parens");
      }
      while (state.braces > 0) {
        if (opts2.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", "}"));
        state.output = utils.escapeLast(state.output, "{");
        decrement("braces");
      }
      if (opts2.strictSlashes !== true && (prev.type === "star" || prev.type === "bracket")) {
        push({ type: "maybe_slash", value: "", output: `${SLASH_LITERAL}?` });
      }
      if (state.backtrack === true) {
        state.output = "";
        for (const token of state.tokens) {
          state.output += token.output != null ? token.output : token.value;
          if (token.suffix) {
            state.output += token.suffix;
          }
        }
      }
      return state;
    }, "parse");
    parse2.fastpaths = (input, options2) => {
      const opts2 = { ...options2 };
      const max = typeof opts2.maxLength === "number" ? Math.min(MAX_LENGTH, opts2.maxLength) : MAX_LENGTH;
      const len = input.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      input = REPLACEMENTS[input] || input;
      const win32 = utils.isWindows(options2);
      const {
        DOT_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOTS,
        NO_DOTS_SLASH,
        STAR,
        START_ANCHOR
      } = constants.globChars(win32);
      const nodot = opts2.dot ? NO_DOTS : NO_DOT;
      const slashDot = opts2.dot ? NO_DOTS_SLASH : NO_DOT;
      const capture = opts2.capture ? "" : "?:";
      const state = { negated: false, prefix: "" };
      let star = opts2.bash === true ? ".*?" : STAR;
      if (opts2.capture) {
        star = `(${star})`;
      }
      const globstar = /* @__PURE__ */ __name((opts3) => {
        if (opts3.noglobstar === true)
          return star;
        return `(${capture}(?:(?!${START_ANCHOR}${opts3.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      }, "globstar");
      const create = /* @__PURE__ */ __name((str) => {
        switch (str) {
          case "*":
            return `${nodot}${ONE_CHAR}${star}`;
          case ".*":
            return `${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "*.*":
            return `${nodot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "*/*":
            return `${nodot}${star}${SLASH_LITERAL}${ONE_CHAR}${slashDot}${star}`;
          case "**":
            return nodot + globstar(opts2);
          case "**/*":
            return `(?:${nodot}${globstar(opts2)}${SLASH_LITERAL})?${slashDot}${ONE_CHAR}${star}`;
          case "**/*.*":
            return `(?:${nodot}${globstar(opts2)}${SLASH_LITERAL})?${slashDot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "**/.*":
            return `(?:${nodot}${globstar(opts2)}${SLASH_LITERAL})?${DOT_LITERAL}${ONE_CHAR}${star}`;
          default: {
            const match4 = /^(.*?)\.(\w+)$/.exec(str);
            if (!match4)
              return;
            const source2 = create(match4[1]);
            if (!source2)
              return;
            return source2 + DOT_LITERAL + match4[2];
          }
        }
      }, "create");
      const output = utils.removePrefix(input, state);
      let source = create(output);
      if (source && opts2.strictSlashes !== true) {
        source += `${SLASH_LITERAL}?`;
      }
      return source;
    };
    module2.exports = parse2;
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/picomatch.js
var require_picomatch = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/lib/picomatch.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var scan = require_scan2();
    var parse2 = require_parse4();
    var utils = require_utils2();
    var constants = require_constants2();
    var isObject = /* @__PURE__ */ __name((val) => val && typeof val === "object" && !Array.isArray(val), "isObject");
    var picomatch = /* @__PURE__ */ __name((glob, options2, returnState = false) => {
      if (Array.isArray(glob)) {
        const fns = glob.map((input) => picomatch(input, options2, returnState));
        const arrayMatcher = /* @__PURE__ */ __name((str) => {
          for (const isMatch of fns) {
            const state2 = isMatch(str);
            if (state2)
              return state2;
          }
          return false;
        }, "arrayMatcher");
        return arrayMatcher;
      }
      const isState = isObject(glob) && glob.tokens && glob.input;
      if (glob === "" || typeof glob !== "string" && !isState) {
        throw new TypeError("Expected pattern to be a non-empty string");
      }
      const opts2 = options2 || {};
      const posix = utils.isWindows(options2);
      const regex = isState ? picomatch.compileRe(glob, options2) : picomatch.makeRe(glob, options2, false, true);
      const state = regex.state;
      delete regex.state;
      let isIgnored = /* @__PURE__ */ __name(() => false, "isIgnored");
      if (opts2.ignore) {
        const ignoreOpts = { ...options2, ignore: null, onMatch: null, onResult: null };
        isIgnored = picomatch(opts2.ignore, ignoreOpts, returnState);
      }
      const matcher = /* @__PURE__ */ __name((input, returnObject = false) => {
        const { isMatch, match: match4, output } = picomatch.test(input, regex, options2, { glob, posix });
        const result = { glob, state, regex, posix, input, output, match: match4, isMatch };
        if (typeof opts2.onResult === "function") {
          opts2.onResult(result);
        }
        if (isMatch === false) {
          result.isMatch = false;
          return returnObject ? result : false;
        }
        if (isIgnored(input)) {
          if (typeof opts2.onIgnore === "function") {
            opts2.onIgnore(result);
          }
          result.isMatch = false;
          return returnObject ? result : false;
        }
        if (typeof opts2.onMatch === "function") {
          opts2.onMatch(result);
        }
        return returnObject ? result : true;
      }, "matcher");
      if (returnState) {
        matcher.state = state;
      }
      return matcher;
    }, "picomatch");
    picomatch.test = (input, regex, options2, { glob, posix } = {}) => {
      if (typeof input !== "string") {
        throw new TypeError("Expected input to be a string");
      }
      if (input === "") {
        return { isMatch: false, output: "" };
      }
      const opts2 = options2 || {};
      const format2 = opts2.format || (posix ? utils.toPosixSlashes : null);
      let match4 = input === glob;
      let output = match4 && format2 ? format2(input) : input;
      if (match4 === false) {
        output = format2 ? format2(input) : input;
        match4 = output === glob;
      }
      if (match4 === false || opts2.capture === true) {
        if (opts2.matchBase === true || opts2.basename === true) {
          match4 = picomatch.matchBase(input, regex, options2, posix);
        } else {
          match4 = regex.exec(output);
        }
      }
      return { isMatch: Boolean(match4), match: match4, output };
    };
    picomatch.matchBase = (input, glob, options2, posix = utils.isWindows(options2)) => {
      const regex = glob instanceof RegExp ? glob : picomatch.makeRe(glob, options2);
      return regex.test(path32.basename(input));
    };
    picomatch.isMatch = (str, patterns, options2) => picomatch(patterns, options2)(str);
    picomatch.parse = (pattern, options2) => {
      if (Array.isArray(pattern))
        return pattern.map((p3) => picomatch.parse(p3, options2));
      return parse2(pattern, { ...options2, fastpaths: false });
    };
    picomatch.scan = (input, options2) => scan(input, options2);
    picomatch.compileRe = (state, options2, returnOutput = false, returnState = false) => {
      if (returnOutput === true) {
        return state.output;
      }
      const opts2 = options2 || {};
      const prepend = opts2.contains ? "" : "^";
      const append = opts2.contains ? "" : "$";
      let source = `${prepend}(?:${state.output})${append}`;
      if (state && state.negated === true) {
        source = `^(?!${source}).*$`;
      }
      const regex = picomatch.toRegex(source, options2);
      if (returnState === true) {
        regex.state = state;
      }
      return regex;
    };
    picomatch.makeRe = (input, options2 = {}, returnOutput = false, returnState = false) => {
      if (!input || typeof input !== "string") {
        throw new TypeError("Expected a non-empty string");
      }
      let parsed = { negated: false, fastpaths: true };
      if (options2.fastpaths !== false && (input[0] === "." || input[0] === "*")) {
        parsed.output = parse2.fastpaths(input, options2);
      }
      if (!parsed.output) {
        parsed = parse2(input, options2);
      }
      return picomatch.compileRe(parsed, options2, returnOutput, returnState);
    };
    picomatch.toRegex = (source, options2) => {
      try {
        const opts2 = options2 || {};
        return new RegExp(source, opts2.flags || (opts2.nocase ? "i" : ""));
      } catch (err) {
        if (options2 && options2.debug === true)
          throw err;
        return /$^/;
      }
    };
    picomatch.constants = constants;
    module2.exports = picomatch;
  }
});

// ../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/index.js
var require_picomatch2 = __commonJS({
  "../../node_modules/.pnpm/picomatch@2.3.1/node_modules/picomatch/index.js"(exports2, module2) {
    "use strict";
    module2.exports = require_picomatch();
  }
});

// ../../node_modules/.pnpm/micromatch@4.0.5/node_modules/micromatch/index.js
var require_micromatch = __commonJS({
  "../../node_modules/.pnpm/micromatch@4.0.5/node_modules/micromatch/index.js"(exports2, module2) {
    "use strict";
    var util4 = require("util");
    var braces = require_braces();
    var picomatch = require_picomatch2();
    var utils = require_utils2();
    var isEmptyString = /* @__PURE__ */ __name((val) => val === "" || val === "./", "isEmptyString");
    var micromatch = /* @__PURE__ */ __name((list, patterns, options2) => {
      patterns = [].concat(patterns);
      list = [].concat(list);
      let omit = /* @__PURE__ */ new Set();
      let keep = /* @__PURE__ */ new Set();
      let items = /* @__PURE__ */ new Set();
      let negatives = 0;
      let onResult = /* @__PURE__ */ __name((state) => {
        items.add(state.output);
        if (options2 && options2.onResult) {
          options2.onResult(state);
        }
      }, "onResult");
      for (let i3 = 0; i3 < patterns.length; i3++) {
        let isMatch = picomatch(String(patterns[i3]), { ...options2, onResult }, true);
        let negated = isMatch.state.negated || isMatch.state.negatedExtglob;
        if (negated)
          negatives++;
        for (let item of list) {
          let matched = isMatch(item, true);
          let match4 = negated ? !matched.isMatch : matched.isMatch;
          if (!match4)
            continue;
          if (negated) {
            omit.add(matched.output);
          } else {
            omit.delete(matched.output);
            keep.add(matched.output);
          }
        }
      }
      let result = negatives === patterns.length ? [...items] : [...keep];
      let matches = result.filter((item) => !omit.has(item));
      if (options2 && matches.length === 0) {
        if (options2.failglob === true) {
          throw new Error(`No matches found for "${patterns.join(", ")}"`);
        }
        if (options2.nonull === true || options2.nullglob === true) {
          return options2.unescape ? patterns.map((p3) => p3.replace(/\\/g, "")) : patterns;
        }
      }
      return matches;
    }, "micromatch");
    micromatch.match = micromatch;
    micromatch.matcher = (pattern, options2) => picomatch(pattern, options2);
    micromatch.isMatch = (str, patterns, options2) => picomatch(patterns, options2)(str);
    micromatch.any = micromatch.isMatch;
    micromatch.not = (list, patterns, options2 = {}) => {
      patterns = [].concat(patterns).map(String);
      let result = /* @__PURE__ */ new Set();
      let items = [];
      let onResult = /* @__PURE__ */ __name((state) => {
        if (options2.onResult)
          options2.onResult(state);
        items.push(state.output);
      }, "onResult");
      let matches = new Set(micromatch(list, patterns, { ...options2, onResult }));
      for (let item of items) {
        if (!matches.has(item)) {
          result.add(item);
        }
      }
      return [...result];
    };
    micromatch.contains = (str, pattern, options2) => {
      if (typeof str !== "string") {
        throw new TypeError(`Expected a string: "${util4.inspect(str)}"`);
      }
      if (Array.isArray(pattern)) {
        return pattern.some((p3) => micromatch.contains(str, p3, options2));
      }
      if (typeof pattern === "string") {
        if (isEmptyString(str) || isEmptyString(pattern)) {
          return false;
        }
        if (str.includes(pattern) || str.startsWith("./") && str.slice(2).includes(pattern)) {
          return true;
        }
      }
      return micromatch.isMatch(str, pattern, { ...options2, contains: true });
    };
    micromatch.matchKeys = (obj, patterns, options2) => {
      if (!utils.isObject(obj)) {
        throw new TypeError("Expected the first argument to be an object");
      }
      let keys = micromatch(Object.keys(obj), patterns, options2);
      let res = {};
      for (let key of keys)
        res[key] = obj[key];
      return res;
    };
    micromatch.some = (list, patterns, options2) => {
      let items = [].concat(list);
      for (let pattern of [].concat(patterns)) {
        let isMatch = picomatch(String(pattern), options2);
        if (items.some((item) => isMatch(item))) {
          return true;
        }
      }
      return false;
    };
    micromatch.every = (list, patterns, options2) => {
      let items = [].concat(list);
      for (let pattern of [].concat(patterns)) {
        let isMatch = picomatch(String(pattern), options2);
        if (!items.every((item) => isMatch(item))) {
          return false;
        }
      }
      return true;
    };
    micromatch.all = (str, patterns, options2) => {
      if (typeof str !== "string") {
        throw new TypeError(`Expected a string: "${util4.inspect(str)}"`);
      }
      return [].concat(patterns).every((p3) => picomatch(p3, options2)(str));
    };
    micromatch.capture = (glob, input, options2) => {
      let posix = utils.isWindows(options2);
      let regex = picomatch.makeRe(String(glob), { ...options2, capture: true });
      let match4 = regex.exec(posix ? utils.toPosixSlashes(input) : input);
      if (match4) {
        return match4.slice(1).map((v3) => v3 === void 0 ? "" : v3);
      }
    };
    micromatch.makeRe = (...args3) => picomatch.makeRe(...args3);
    micromatch.scan = (...args3) => picomatch.scan(...args3);
    micromatch.parse = (patterns, options2) => {
      let res = [];
      for (let pattern of [].concat(patterns || [])) {
        for (let str of braces(String(pattern), options2)) {
          res.push(picomatch.parse(str, options2));
        }
      }
      return res;
    };
    micromatch.braces = (pattern, options2) => {
      if (typeof pattern !== "string")
        throw new TypeError("Expected a string");
      if (options2 && options2.nobrace === true || !/\{.*\}/.test(pattern)) {
        return [pattern];
      }
      return braces(pattern, options2);
    };
    micromatch.braceExpand = (pattern, options2) => {
      if (typeof pattern !== "string")
        throw new TypeError("Expected a string");
      return micromatch.braces(pattern, { ...options2, expand: true });
    };
    module2.exports = micromatch;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/pattern.js
var require_pattern = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.matchAny = exports2.convertPatternsToRe = exports2.makeRe = exports2.getPatternParts = exports2.expandBraceExpansion = exports2.expandPatternsWithBraceExpansion = exports2.isAffectDepthOfReadingPattern = exports2.endsWithSlashGlobStar = exports2.hasGlobStar = exports2.getBaseDirectory = exports2.isPatternRelatedToParentDirectory = exports2.getPatternsOutsideCurrentDirectory = exports2.getPatternsInsideCurrentDirectory = exports2.getPositivePatterns = exports2.getNegativePatterns = exports2.isPositivePattern = exports2.isNegativePattern = exports2.convertToNegativePattern = exports2.convertToPositivePattern = exports2.isDynamicPattern = exports2.isStaticPattern = void 0;
    var path32 = require("path");
    var globParent = require_glob_parent();
    var micromatch = require_micromatch();
    var GLOBSTAR = "**";
    var ESCAPE_SYMBOL = "\\";
    var COMMON_GLOB_SYMBOLS_RE = /[*?]|^!/;
    var REGEX_CHARACTER_CLASS_SYMBOLS_RE = /\[[^[]*]/;
    var REGEX_GROUP_SYMBOLS_RE = /(?:^|[^!*+?@])\([^(]*\|[^|]*\)/;
    var GLOB_EXTENSION_SYMBOLS_RE = /[!*+?@]\([^(]*\)/;
    var BRACE_EXPANSION_SEPARATORS_RE = /,|\.\./;
    function isStaticPattern(pattern, options2 = {}) {
      return !isDynamicPattern(pattern, options2);
    }
    __name(isStaticPattern, "isStaticPattern");
    exports2.isStaticPattern = isStaticPattern;
    function isDynamicPattern(pattern, options2 = {}) {
      if (pattern === "") {
        return false;
      }
      if (options2.caseSensitiveMatch === false || pattern.includes(ESCAPE_SYMBOL)) {
        return true;
      }
      if (COMMON_GLOB_SYMBOLS_RE.test(pattern) || REGEX_CHARACTER_CLASS_SYMBOLS_RE.test(pattern) || REGEX_GROUP_SYMBOLS_RE.test(pattern)) {
        return true;
      }
      if (options2.extglob !== false && GLOB_EXTENSION_SYMBOLS_RE.test(pattern)) {
        return true;
      }
      if (options2.braceExpansion !== false && hasBraceExpansion(pattern)) {
        return true;
      }
      return false;
    }
    __name(isDynamicPattern, "isDynamicPattern");
    exports2.isDynamicPattern = isDynamicPattern;
    function hasBraceExpansion(pattern) {
      const openingBraceIndex = pattern.indexOf("{");
      if (openingBraceIndex === -1) {
        return false;
      }
      const closingBraceIndex = pattern.indexOf("}", openingBraceIndex + 1);
      if (closingBraceIndex === -1) {
        return false;
      }
      const braceContent = pattern.slice(openingBraceIndex, closingBraceIndex);
      return BRACE_EXPANSION_SEPARATORS_RE.test(braceContent);
    }
    __name(hasBraceExpansion, "hasBraceExpansion");
    function convertToPositivePattern(pattern) {
      return isNegativePattern(pattern) ? pattern.slice(1) : pattern;
    }
    __name(convertToPositivePattern, "convertToPositivePattern");
    exports2.convertToPositivePattern = convertToPositivePattern;
    function convertToNegativePattern(pattern) {
      return "!" + pattern;
    }
    __name(convertToNegativePattern, "convertToNegativePattern");
    exports2.convertToNegativePattern = convertToNegativePattern;
    function isNegativePattern(pattern) {
      return pattern.startsWith("!") && pattern[1] !== "(";
    }
    __name(isNegativePattern, "isNegativePattern");
    exports2.isNegativePattern = isNegativePattern;
    function isPositivePattern(pattern) {
      return !isNegativePattern(pattern);
    }
    __name(isPositivePattern, "isPositivePattern");
    exports2.isPositivePattern = isPositivePattern;
    function getNegativePatterns(patterns) {
      return patterns.filter(isNegativePattern);
    }
    __name(getNegativePatterns, "getNegativePatterns");
    exports2.getNegativePatterns = getNegativePatterns;
    function getPositivePatterns(patterns) {
      return patterns.filter(isPositivePattern);
    }
    __name(getPositivePatterns, "getPositivePatterns");
    exports2.getPositivePatterns = getPositivePatterns;
    function getPatternsInsideCurrentDirectory(patterns) {
      return patterns.filter((pattern) => !isPatternRelatedToParentDirectory(pattern));
    }
    __name(getPatternsInsideCurrentDirectory, "getPatternsInsideCurrentDirectory");
    exports2.getPatternsInsideCurrentDirectory = getPatternsInsideCurrentDirectory;
    function getPatternsOutsideCurrentDirectory(patterns) {
      return patterns.filter(isPatternRelatedToParentDirectory);
    }
    __name(getPatternsOutsideCurrentDirectory, "getPatternsOutsideCurrentDirectory");
    exports2.getPatternsOutsideCurrentDirectory = getPatternsOutsideCurrentDirectory;
    function isPatternRelatedToParentDirectory(pattern) {
      return pattern.startsWith("..") || pattern.startsWith("./..");
    }
    __name(isPatternRelatedToParentDirectory, "isPatternRelatedToParentDirectory");
    exports2.isPatternRelatedToParentDirectory = isPatternRelatedToParentDirectory;
    function getBaseDirectory(pattern) {
      return globParent(pattern, { flipBackslashes: false });
    }
    __name(getBaseDirectory, "getBaseDirectory");
    exports2.getBaseDirectory = getBaseDirectory;
    function hasGlobStar(pattern) {
      return pattern.includes(GLOBSTAR);
    }
    __name(hasGlobStar, "hasGlobStar");
    exports2.hasGlobStar = hasGlobStar;
    function endsWithSlashGlobStar(pattern) {
      return pattern.endsWith("/" + GLOBSTAR);
    }
    __name(endsWithSlashGlobStar, "endsWithSlashGlobStar");
    exports2.endsWithSlashGlobStar = endsWithSlashGlobStar;
    function isAffectDepthOfReadingPattern(pattern) {
      const basename = path32.basename(pattern);
      return endsWithSlashGlobStar(pattern) || isStaticPattern(basename);
    }
    __name(isAffectDepthOfReadingPattern, "isAffectDepthOfReadingPattern");
    exports2.isAffectDepthOfReadingPattern = isAffectDepthOfReadingPattern;
    function expandPatternsWithBraceExpansion(patterns) {
      return patterns.reduce((collection, pattern) => {
        return collection.concat(expandBraceExpansion(pattern));
      }, []);
    }
    __name(expandPatternsWithBraceExpansion, "expandPatternsWithBraceExpansion");
    exports2.expandPatternsWithBraceExpansion = expandPatternsWithBraceExpansion;
    function expandBraceExpansion(pattern) {
      return micromatch.braces(pattern, {
        expand: true,
        nodupes: true
      });
    }
    __name(expandBraceExpansion, "expandBraceExpansion");
    exports2.expandBraceExpansion = expandBraceExpansion;
    function getPatternParts(pattern, options2) {
      let { parts } = micromatch.scan(pattern, Object.assign(Object.assign({}, options2), { parts: true }));
      if (parts.length === 0) {
        parts = [pattern];
      }
      if (parts[0].startsWith("/")) {
        parts[0] = parts[0].slice(1);
        parts.unshift("");
      }
      return parts;
    }
    __name(getPatternParts, "getPatternParts");
    exports2.getPatternParts = getPatternParts;
    function makeRe(pattern, options2) {
      return micromatch.makeRe(pattern, options2);
    }
    __name(makeRe, "makeRe");
    exports2.makeRe = makeRe;
    function convertPatternsToRe(patterns, options2) {
      return patterns.map((pattern) => makeRe(pattern, options2));
    }
    __name(convertPatternsToRe, "convertPatternsToRe");
    exports2.convertPatternsToRe = convertPatternsToRe;
    function matchAny(entry, patternsRe) {
      return patternsRe.some((patternRe) => patternRe.test(entry));
    }
    __name(matchAny, "matchAny");
    exports2.matchAny = matchAny;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/stream.js
var require_stream2 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/stream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.merge = void 0;
    var merge2 = require_merge2();
    function merge(streams) {
      const mergedStream = merge2(streams);
      streams.forEach((stream3) => {
        stream3.once("error", (error2) => mergedStream.emit("error", error2));
      });
      mergedStream.once("close", () => propagateCloseEventToSources(streams));
      mergedStream.once("end", () => propagateCloseEventToSources(streams));
      return mergedStream;
    }
    __name(merge, "merge");
    exports2.merge = merge;
    function propagateCloseEventToSources(streams) {
      streams.forEach((stream3) => stream3.emit("close"));
    }
    __name(propagateCloseEventToSources, "propagateCloseEventToSources");
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/string.js
var require_string = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/string.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isEmpty = exports2.isString = void 0;
    function isString(input) {
      return typeof input === "string";
    }
    __name(isString, "isString");
    exports2.isString = isString;
    function isEmpty(input) {
      return input === "";
    }
    __name(isEmpty, "isEmpty");
    exports2.isEmpty = isEmpty;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/index.js
var require_utils3 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/utils/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.string = exports2.stream = exports2.pattern = exports2.path = exports2.fs = exports2.errno = exports2.array = void 0;
    var array = require_array();
    exports2.array = array;
    var errno = require_errno();
    exports2.errno = errno;
    var fs37 = require_fs();
    exports2.fs = fs37;
    var path32 = require_path();
    exports2.path = path32;
    var pattern = require_pattern();
    exports2.pattern = pattern;
    var stream3 = require_stream2();
    exports2.stream = stream3;
    var string = require_string();
    exports2.string = string;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/managers/tasks.js
var require_tasks = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/managers/tasks.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.convertPatternGroupToTask = exports2.convertPatternGroupsToTasks = exports2.groupPatternsByBaseDirectory = exports2.getNegativePatternsAsPositive = exports2.getPositivePatterns = exports2.convertPatternsToTasks = exports2.generate = void 0;
    var utils = require_utils3();
    function generate(patterns, settings) {
      const positivePatterns = getPositivePatterns(patterns);
      const negativePatterns = getNegativePatternsAsPositive(patterns, settings.ignore);
      const staticPatterns = positivePatterns.filter((pattern) => utils.pattern.isStaticPattern(pattern, settings));
      const dynamicPatterns = positivePatterns.filter((pattern) => utils.pattern.isDynamicPattern(pattern, settings));
      const staticTasks = convertPatternsToTasks(staticPatterns, negativePatterns, false);
      const dynamicTasks = convertPatternsToTasks(dynamicPatterns, negativePatterns, true);
      return staticTasks.concat(dynamicTasks);
    }
    __name(generate, "generate");
    exports2.generate = generate;
    function convertPatternsToTasks(positive, negative, dynamic) {
      const tasks = [];
      const patternsOutsideCurrentDirectory = utils.pattern.getPatternsOutsideCurrentDirectory(positive);
      const patternsInsideCurrentDirectory = utils.pattern.getPatternsInsideCurrentDirectory(positive);
      const outsideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsOutsideCurrentDirectory);
      const insideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsInsideCurrentDirectory);
      tasks.push(...convertPatternGroupsToTasks(outsideCurrentDirectoryGroup, negative, dynamic));
      if ("." in insideCurrentDirectoryGroup) {
        tasks.push(convertPatternGroupToTask(".", patternsInsideCurrentDirectory, negative, dynamic));
      } else {
        tasks.push(...convertPatternGroupsToTasks(insideCurrentDirectoryGroup, negative, dynamic));
      }
      return tasks;
    }
    __name(convertPatternsToTasks, "convertPatternsToTasks");
    exports2.convertPatternsToTasks = convertPatternsToTasks;
    function getPositivePatterns(patterns) {
      return utils.pattern.getPositivePatterns(patterns);
    }
    __name(getPositivePatterns, "getPositivePatterns");
    exports2.getPositivePatterns = getPositivePatterns;
    function getNegativePatternsAsPositive(patterns, ignore) {
      const negative = utils.pattern.getNegativePatterns(patterns).concat(ignore);
      const positive = negative.map(utils.pattern.convertToPositivePattern);
      return positive;
    }
    __name(getNegativePatternsAsPositive, "getNegativePatternsAsPositive");
    exports2.getNegativePatternsAsPositive = getNegativePatternsAsPositive;
    function groupPatternsByBaseDirectory(patterns) {
      const group = {};
      return patterns.reduce((collection, pattern) => {
        const base = utils.pattern.getBaseDirectory(pattern);
        if (base in collection) {
          collection[base].push(pattern);
        } else {
          collection[base] = [pattern];
        }
        return collection;
      }, group);
    }
    __name(groupPatternsByBaseDirectory, "groupPatternsByBaseDirectory");
    exports2.groupPatternsByBaseDirectory = groupPatternsByBaseDirectory;
    function convertPatternGroupsToTasks(positive, negative, dynamic) {
      return Object.keys(positive).map((base) => {
        return convertPatternGroupToTask(base, positive[base], negative, dynamic);
      });
    }
    __name(convertPatternGroupsToTasks, "convertPatternGroupsToTasks");
    exports2.convertPatternGroupsToTasks = convertPatternGroupsToTasks;
    function convertPatternGroupToTask(base, positive, negative, dynamic) {
      return {
        dynamic,
        positive,
        negative,
        base,
        patterns: [].concat(positive, negative.map(utils.pattern.convertToNegativePattern))
      };
    }
    __name(convertPatternGroupToTask, "convertPatternGroupToTask");
    exports2.convertPatternGroupToTask = convertPatternGroupToTask;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/managers/patterns.js
var require_patterns = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/managers/patterns.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.removeDuplicateSlashes = exports2.transform = void 0;
    var DOUBLE_SLASH_RE = /(?!^)\/{2,}/g;
    function transform2(patterns) {
      return patterns.map((pattern) => removeDuplicateSlashes(pattern));
    }
    __name(transform2, "transform");
    exports2.transform = transform2;
    function removeDuplicateSlashes(pattern) {
      return pattern.replace(DOUBLE_SLASH_RE, "/");
    }
    __name(removeDuplicateSlashes, "removeDuplicateSlashes");
    exports2.removeDuplicateSlashes = removeDuplicateSlashes;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/providers/async.js
var require_async2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/providers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.read = void 0;
    function read(path32, settings, callback) {
      settings.fs.lstat(path32, (lstatError, lstat) => {
        if (lstatError !== null) {
          callFailureCallback(callback, lstatError);
          return;
        }
        if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
          callSuccessCallback(callback, lstat);
          return;
        }
        settings.fs.stat(path32, (statError, stat2) => {
          if (statError !== null) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              callFailureCallback(callback, statError);
              return;
            }
            callSuccessCallback(callback, lstat);
            return;
          }
          if (settings.markSymbolicLink) {
            stat2.isSymbolicLink = () => true;
          }
          callSuccessCallback(callback, stat2);
        });
      });
    }
    __name(read, "read");
    exports2.read = read;
    function callFailureCallback(callback, error2) {
      callback(error2);
    }
    __name(callFailureCallback, "callFailureCallback");
    function callSuccessCallback(callback, result) {
      callback(null, result);
    }
    __name(callSuccessCallback, "callSuccessCallback");
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/providers/sync.js
var require_sync2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/providers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.read = void 0;
    function read(path32, settings) {
      const lstat = settings.fs.lstatSync(path32);
      if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
        return lstat;
      }
      try {
        const stat2 = settings.fs.statSync(path32);
        if (settings.markSymbolicLink) {
          stat2.isSymbolicLink = () => true;
        }
        return stat2;
      } catch (error2) {
        if (!settings.throwErrorOnBrokenSymbolicLink) {
          return lstat;
        }
        throw error2;
      }
    }
    __name(read, "read");
    exports2.read = read;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/adapters/fs.js
var require_fs2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/adapters/fs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createFileSystemAdapter = exports2.FILE_SYSTEM_ADAPTER = void 0;
    var fs37 = require("fs");
    exports2.FILE_SYSTEM_ADAPTER = {
      lstat: fs37.lstat,
      stat: fs37.stat,
      lstatSync: fs37.lstatSync,
      statSync: fs37.statSync
    };
    function createFileSystemAdapter(fsMethods) {
      if (fsMethods === void 0) {
        return exports2.FILE_SYSTEM_ADAPTER;
      }
      return Object.assign(Object.assign({}, exports2.FILE_SYSTEM_ADAPTER), fsMethods);
    }
    __name(createFileSystemAdapter, "createFileSystemAdapter");
    exports2.createFileSystemAdapter = createFileSystemAdapter;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/settings.js
var require_settings = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/settings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fs37 = require_fs2();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLink = this._getValue(this._options.followSymbolicLink, true);
        this.fs = fs37.createFileSystemAdapter(this._options.fs);
        this.markSymbolicLink = this._getValue(this._options.markSymbolicLink, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
      }
      _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
      }
    };
    __name(Settings, "Settings");
    exports2.default = Settings;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/index.js
var require_out = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.stat@2.0.5/node_modules/@nodelib/fs.stat/out/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.statSync = exports2.stat = exports2.Settings = void 0;
    var async = require_async2();
    var sync = require_sync2();
    var settings_1 = require_settings();
    exports2.Settings = settings_1.default;
    function stat2(path32, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        async.read(path32, getSettings(), optionsOrSettingsOrCallback);
        return;
      }
      async.read(path32, getSettings(optionsOrSettingsOrCallback), callback);
    }
    __name(stat2, "stat");
    exports2.stat = stat2;
    function statSync2(path32, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      return sync.read(path32, settings);
    }
    __name(statSync2, "statSync");
    exports2.statSync = statSync2;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
    __name(getSettings, "getSettings");
  }
});

// ../../node_modules/.pnpm/queue-microtask@1.2.3/node_modules/queue-microtask/index.js
var require_queue_microtask = __commonJS({
  "../../node_modules/.pnpm/queue-microtask@1.2.3/node_modules/queue-microtask/index.js"(exports2, module2) {
    var promise;
    module2.exports = typeof queueMicrotask === "function" ? queueMicrotask.bind(typeof window !== "undefined" ? window : global) : (cb) => (promise || (promise = Promise.resolve())).then(cb).catch((err) => setTimeout(() => {
      throw err;
    }, 0));
  }
});

// ../../node_modules/.pnpm/run-parallel@1.2.0/node_modules/run-parallel/index.js
var require_run_parallel = __commonJS({
  "../../node_modules/.pnpm/run-parallel@1.2.0/node_modules/run-parallel/index.js"(exports2, module2) {
    module2.exports = runParallel;
    var queueMicrotask2 = require_queue_microtask();
    function runParallel(tasks, cb) {
      let results, pending, keys;
      let isSync = true;
      if (Array.isArray(tasks)) {
        results = [];
        pending = tasks.length;
      } else {
        keys = Object.keys(tasks);
        results = {};
        pending = keys.length;
      }
      function done(err) {
        function end() {
          if (cb)
            cb(err, results);
          cb = null;
        }
        __name(end, "end");
        if (isSync)
          queueMicrotask2(end);
        else
          end();
      }
      __name(done, "done");
      function each2(i3, err, result) {
        results[i3] = result;
        if (--pending === 0 || err) {
          done(err);
        }
      }
      __name(each2, "each");
      if (!pending) {
        done(null);
      } else if (keys) {
        keys.forEach(function(key) {
          tasks[key](function(err, result) {
            each2(key, err, result);
          });
        });
      } else {
        tasks.forEach(function(task, i3) {
          task(function(err, result) {
            each2(i3, err, result);
          });
        });
      }
      isSync = false;
    }
    __name(runParallel, "runParallel");
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/constants.js
var require_constants3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/constants.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.IS_SUPPORT_READDIR_WITH_FILE_TYPES = void 0;
    var NODE_PROCESS_VERSION_PARTS = process.versions.node.split(".");
    if (NODE_PROCESS_VERSION_PARTS[0] === void 0 || NODE_PROCESS_VERSION_PARTS[1] === void 0) {
      throw new Error(`Unexpected behavior. The 'process.versions.node' variable has invalid value: ${process.versions.node}`);
    }
    var MAJOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[0], 10);
    var MINOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[1], 10);
    var SUPPORTED_MAJOR_VERSION = 10;
    var SUPPORTED_MINOR_VERSION = 10;
    var IS_MATCHED_BY_MAJOR = MAJOR_VERSION > SUPPORTED_MAJOR_VERSION;
    var IS_MATCHED_BY_MAJOR_AND_MINOR = MAJOR_VERSION === SUPPORTED_MAJOR_VERSION && MINOR_VERSION >= SUPPORTED_MINOR_VERSION;
    exports2.IS_SUPPORT_READDIR_WITH_FILE_TYPES = IS_MATCHED_BY_MAJOR || IS_MATCHED_BY_MAJOR_AND_MINOR;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/utils/fs.js
var require_fs3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/utils/fs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createDirentFromStats = void 0;
    var DirentFromStats = class {
      constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
      }
    };
    __name(DirentFromStats, "DirentFromStats");
    function createDirentFromStats(name, stats) {
      return new DirentFromStats(name, stats);
    }
    __name(createDirentFromStats, "createDirentFromStats");
    exports2.createDirentFromStats = createDirentFromStats;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/utils/index.js
var require_utils4 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/utils/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.fs = void 0;
    var fs37 = require_fs3();
    exports2.fs = fs37;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/common.js
var require_common2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/common.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.joinPathSegments = void 0;
    function joinPathSegments(a3, b3, separator) {
      if (a3.endsWith(separator)) {
        return a3 + b3;
      }
      return a3 + separator + b3;
    }
    __name(joinPathSegments, "joinPathSegments");
    exports2.joinPathSegments = joinPathSegments;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/async.js
var require_async3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.readdir = exports2.readdirWithFileTypes = exports2.read = void 0;
    var fsStat = require_out();
    var rpl = require_run_parallel();
    var constants_1 = require_constants3();
    var utils = require_utils4();
    var common = require_common2();
    function read(directory, settings, callback) {
      if (!settings.stats && constants_1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        readdirWithFileTypes(directory, settings, callback);
        return;
      }
      readdir3(directory, settings, callback);
    }
    __name(read, "read");
    exports2.read = read;
    function readdirWithFileTypes(directory, settings, callback) {
      settings.fs.readdir(directory, { withFileTypes: true }, (readdirError, dirents) => {
        if (readdirError !== null) {
          callFailureCallback(callback, readdirError);
          return;
        }
        const entries = dirents.map((dirent) => ({
          dirent,
          name: dirent.name,
          path: common.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        }));
        if (!settings.followSymbolicLinks) {
          callSuccessCallback(callback, entries);
          return;
        }
        const tasks = entries.map((entry) => makeRplTaskEntry(entry, settings));
        rpl(tasks, (rplError, rplEntries) => {
          if (rplError !== null) {
            callFailureCallback(callback, rplError);
            return;
          }
          callSuccessCallback(callback, rplEntries);
        });
      });
    }
    __name(readdirWithFileTypes, "readdirWithFileTypes");
    exports2.readdirWithFileTypes = readdirWithFileTypes;
    function makeRplTaskEntry(entry, settings) {
      return (done) => {
        if (!entry.dirent.isSymbolicLink()) {
          done(null, entry);
          return;
        }
        settings.fs.stat(entry.path, (statError, stats) => {
          if (statError !== null) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              done(statError);
              return;
            }
            done(null, entry);
            return;
          }
          entry.dirent = utils.fs.createDirentFromStats(entry.name, stats);
          done(null, entry);
        });
      };
    }
    __name(makeRplTaskEntry, "makeRplTaskEntry");
    function readdir3(directory, settings, callback) {
      settings.fs.readdir(directory, (readdirError, names) => {
        if (readdirError !== null) {
          callFailureCallback(callback, readdirError);
          return;
        }
        const tasks = names.map((name) => {
          const path32 = common.joinPathSegments(directory, name, settings.pathSegmentSeparator);
          return (done) => {
            fsStat.stat(path32, settings.fsStatSettings, (error2, stats) => {
              if (error2 !== null) {
                done(error2);
                return;
              }
              const entry = {
                name,
                path: path32,
                dirent: utils.fs.createDirentFromStats(name, stats)
              };
              if (settings.stats) {
                entry.stats = stats;
              }
              done(null, entry);
            });
          };
        });
        rpl(tasks, (rplError, entries) => {
          if (rplError !== null) {
            callFailureCallback(callback, rplError);
            return;
          }
          callSuccessCallback(callback, entries);
        });
      });
    }
    __name(readdir3, "readdir");
    exports2.readdir = readdir3;
    function callFailureCallback(callback, error2) {
      callback(error2);
    }
    __name(callFailureCallback, "callFailureCallback");
    function callSuccessCallback(callback, result) {
      callback(null, result);
    }
    __name(callSuccessCallback, "callSuccessCallback");
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/sync.js
var require_sync3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/providers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.readdir = exports2.readdirWithFileTypes = exports2.read = void 0;
    var fsStat = require_out();
    var constants_1 = require_constants3();
    var utils = require_utils4();
    var common = require_common2();
    function read(directory, settings) {
      if (!settings.stats && constants_1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        return readdirWithFileTypes(directory, settings);
      }
      return readdir3(directory, settings);
    }
    __name(read, "read");
    exports2.read = read;
    function readdirWithFileTypes(directory, settings) {
      const dirents = settings.fs.readdirSync(directory, { withFileTypes: true });
      return dirents.map((dirent) => {
        const entry = {
          dirent,
          name: dirent.name,
          path: common.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        };
        if (entry.dirent.isSymbolicLink() && settings.followSymbolicLinks) {
          try {
            const stats = settings.fs.statSync(entry.path);
            entry.dirent = utils.fs.createDirentFromStats(entry.name, stats);
          } catch (error2) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              throw error2;
            }
          }
        }
        return entry;
      });
    }
    __name(readdirWithFileTypes, "readdirWithFileTypes");
    exports2.readdirWithFileTypes = readdirWithFileTypes;
    function readdir3(directory, settings) {
      const names = settings.fs.readdirSync(directory);
      return names.map((name) => {
        const entryPath = common.joinPathSegments(directory, name, settings.pathSegmentSeparator);
        const stats = fsStat.statSync(entryPath, settings.fsStatSettings);
        const entry = {
          name,
          path: entryPath,
          dirent: utils.fs.createDirentFromStats(name, stats)
        };
        if (settings.stats) {
          entry.stats = stats;
        }
        return entry;
      });
    }
    __name(readdir3, "readdir");
    exports2.readdir = readdir3;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/adapters/fs.js
var require_fs4 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/adapters/fs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createFileSystemAdapter = exports2.FILE_SYSTEM_ADAPTER = void 0;
    var fs37 = require("fs");
    exports2.FILE_SYSTEM_ADAPTER = {
      lstat: fs37.lstat,
      stat: fs37.stat,
      lstatSync: fs37.lstatSync,
      statSync: fs37.statSync,
      readdir: fs37.readdir,
      readdirSync: fs37.readdirSync
    };
    function createFileSystemAdapter(fsMethods) {
      if (fsMethods === void 0) {
        return exports2.FILE_SYSTEM_ADAPTER;
      }
      return Object.assign(Object.assign({}, exports2.FILE_SYSTEM_ADAPTER), fsMethods);
    }
    __name(createFileSystemAdapter, "createFileSystemAdapter");
    exports2.createFileSystemAdapter = createFileSystemAdapter;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/settings.js
var require_settings2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/settings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var path32 = require("path");
    var fsStat = require_out();
    var fs37 = require_fs4();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, false);
        this.fs = fs37.createFileSystemAdapter(this._options.fs);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path32.sep);
        this.stats = this._getValue(this._options.stats, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
        this.fsStatSettings = new fsStat.Settings({
          followSymbolicLink: this.followSymbolicLinks,
          fs: this.fs,
          throwErrorOnBrokenSymbolicLink: this.throwErrorOnBrokenSymbolicLink
        });
      }
      _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
      }
    };
    __name(Settings, "Settings");
    exports2.default = Settings;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/index.js
var require_out2 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.scandir@2.1.5/node_modules/@nodelib/fs.scandir/out/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Settings = exports2.scandirSync = exports2.scandir = void 0;
    var async = require_async3();
    var sync = require_sync3();
    var settings_1 = require_settings2();
    exports2.Settings = settings_1.default;
    function scandir(path32, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        async.read(path32, getSettings(), optionsOrSettingsOrCallback);
        return;
      }
      async.read(path32, getSettings(optionsOrSettingsOrCallback), callback);
    }
    __name(scandir, "scandir");
    exports2.scandir = scandir;
    function scandirSync(path32, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      return sync.read(path32, settings);
    }
    __name(scandirSync, "scandirSync");
    exports2.scandirSync = scandirSync;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
    __name(getSettings, "getSettings");
  }
});

// ../../node_modules/.pnpm/reusify@1.0.4/node_modules/reusify/reusify.js
var require_reusify = __commonJS({
  "../../node_modules/.pnpm/reusify@1.0.4/node_modules/reusify/reusify.js"(exports2, module2) {
    "use strict";
    function reusify(Constructor) {
      var head2 = new Constructor();
      var tail2 = head2;
      function get() {
        var current = head2;
        if (current.next) {
          head2 = current.next;
        } else {
          head2 = new Constructor();
          tail2 = head2;
        }
        current.next = null;
        return current;
      }
      __name(get, "get");
      function release(obj) {
        tail2.next = obj;
        tail2 = obj;
      }
      __name(release, "release");
      return {
        get,
        release
      };
    }
    __name(reusify, "reusify");
    module2.exports = reusify;
  }
});

// ../../node_modules/.pnpm/fastq@1.15.0/node_modules/fastq/queue.js
var require_queue = __commonJS({
  "../../node_modules/.pnpm/fastq@1.15.0/node_modules/fastq/queue.js"(exports2, module2) {
    "use strict";
    var reusify = require_reusify();
    function fastqueue(context, worker, concurrency) {
      if (typeof context === "function") {
        concurrency = worker;
        worker = context;
        context = null;
      }
      if (concurrency < 1) {
        throw new Error("fastqueue concurrency must be greater than 1");
      }
      var cache = reusify(Task);
      var queueHead = null;
      var queueTail = null;
      var _running = 0;
      var errorHandler = null;
      var self2 = {
        push,
        drain: noop,
        saturated: noop,
        pause,
        paused: false,
        concurrency,
        running,
        resume,
        idle,
        length,
        getQueue,
        unshift,
        empty: noop,
        kill,
        killAndDrain,
        error: error2
      };
      return self2;
      function running() {
        return _running;
      }
      __name(running, "running");
      function pause() {
        self2.paused = true;
      }
      __name(pause, "pause");
      function length() {
        var current = queueHead;
        var counter2 = 0;
        while (current) {
          current = current.next;
          counter2++;
        }
        return counter2;
      }
      __name(length, "length");
      function getQueue() {
        var current = queueHead;
        var tasks = [];
        while (current) {
          tasks.push(current.value);
          current = current.next;
        }
        return tasks;
      }
      __name(getQueue, "getQueue");
      function resume() {
        if (!self2.paused)
          return;
        self2.paused = false;
        for (var i3 = 0; i3 < self2.concurrency; i3++) {
          _running++;
          release();
        }
      }
      __name(resume, "resume");
      function idle() {
        return _running === 0 && self2.length() === 0;
      }
      __name(idle, "idle");
      function push(value, done) {
        var current = cache.get();
        current.context = context;
        current.release = release;
        current.value = value;
        current.callback = done || noop;
        current.errorHandler = errorHandler;
        if (_running === self2.concurrency || self2.paused) {
          if (queueTail) {
            queueTail.next = current;
            queueTail = current;
          } else {
            queueHead = current;
            queueTail = current;
            self2.saturated();
          }
        } else {
          _running++;
          worker.call(context, current.value, current.worked);
        }
      }
      __name(push, "push");
      function unshift(value, done) {
        var current = cache.get();
        current.context = context;
        current.release = release;
        current.value = value;
        current.callback = done || noop;
        if (_running === self2.concurrency || self2.paused) {
          if (queueHead) {
            current.next = queueHead;
            queueHead = current;
          } else {
            queueHead = current;
            queueTail = current;
            self2.saturated();
          }
        } else {
          _running++;
          worker.call(context, current.value, current.worked);
        }
      }
      __name(unshift, "unshift");
      function release(holder) {
        if (holder) {
          cache.release(holder);
        }
        var next = queueHead;
        if (next) {
          if (!self2.paused) {
            if (queueTail === queueHead) {
              queueTail = null;
            }
            queueHead = next.next;
            next.next = null;
            worker.call(context, next.value, next.worked);
            if (queueTail === null) {
              self2.empty();
            }
          } else {
            _running--;
          }
        } else if (--_running === 0) {
          self2.drain();
        }
      }
      __name(release, "release");
      function kill() {
        queueHead = null;
        queueTail = null;
        self2.drain = noop;
      }
      __name(kill, "kill");
      function killAndDrain() {
        queueHead = null;
        queueTail = null;
        self2.drain();
        self2.drain = noop;
      }
      __name(killAndDrain, "killAndDrain");
      function error2(handler) {
        errorHandler = handler;
      }
      __name(error2, "error");
    }
    __name(fastqueue, "fastqueue");
    function noop() {
    }
    __name(noop, "noop");
    function Task() {
      this.value = null;
      this.callback = noop;
      this.next = null;
      this.release = noop;
      this.context = null;
      this.errorHandler = null;
      var self2 = this;
      this.worked = /* @__PURE__ */ __name(function worked(err, result) {
        var callback = self2.callback;
        var errorHandler = self2.errorHandler;
        var val = self2.value;
        self2.value = null;
        self2.callback = noop;
        if (self2.errorHandler) {
          errorHandler(err, val);
        }
        callback.call(self2.context, err, result);
        self2.release(self2);
      }, "worked");
    }
    __name(Task, "Task");
    function queueAsPromised(context, worker, concurrency) {
      if (typeof context === "function") {
        concurrency = worker;
        worker = context;
        context = null;
      }
      function asyncWrapper(arg2, cb) {
        worker.call(this, arg2).then(function(res) {
          cb(null, res);
        }, cb);
      }
      __name(asyncWrapper, "asyncWrapper");
      var queue2 = fastqueue(context, asyncWrapper, concurrency);
      var pushCb = queue2.push;
      var unshiftCb = queue2.unshift;
      queue2.push = push;
      queue2.unshift = unshift;
      queue2.drained = drained;
      return queue2;
      function push(value) {
        var p3 = new Promise(function(resolve2, reject2) {
          pushCb(value, function(err, result) {
            if (err) {
              reject2(err);
              return;
            }
            resolve2(result);
          });
        });
        p3.catch(noop);
        return p3;
      }
      __name(push, "push");
      function unshift(value) {
        var p3 = new Promise(function(resolve2, reject2) {
          unshiftCb(value, function(err, result) {
            if (err) {
              reject2(err);
              return;
            }
            resolve2(result);
          });
        });
        p3.catch(noop);
        return p3;
      }
      __name(unshift, "unshift");
      function drained() {
        if (queue2.idle()) {
          return new Promise(function(resolve2) {
            resolve2();
          });
        }
        var previousDrain = queue2.drain;
        var p3 = new Promise(function(resolve2) {
          queue2.drain = function() {
            previousDrain();
            resolve2();
          };
        });
        return p3;
      }
      __name(drained, "drained");
    }
    __name(queueAsPromised, "queueAsPromised");
    module2.exports = fastqueue;
    module2.exports.promise = queueAsPromised;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/common.js
var require_common3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/common.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.joinPathSegments = exports2.replacePathSegmentSeparator = exports2.isAppliedFilter = exports2.isFatalError = void 0;
    function isFatalError(settings, error2) {
      if (settings.errorFilter === null) {
        return true;
      }
      return !settings.errorFilter(error2);
    }
    __name(isFatalError, "isFatalError");
    exports2.isFatalError = isFatalError;
    function isAppliedFilter(filter2, value) {
      return filter2 === null || filter2(value);
    }
    __name(isAppliedFilter, "isAppliedFilter");
    exports2.isAppliedFilter = isAppliedFilter;
    function replacePathSegmentSeparator(filepath, separator) {
      return filepath.split(/[/\\]/).join(separator);
    }
    __name(replacePathSegmentSeparator, "replacePathSegmentSeparator");
    exports2.replacePathSegmentSeparator = replacePathSegmentSeparator;
    function joinPathSegments(a3, b3, separator) {
      if (a3 === "") {
        return b3;
      }
      if (a3.endsWith(separator)) {
        return a3 + b3;
      }
      return a3 + separator + b3;
    }
    __name(joinPathSegments, "joinPathSegments");
    exports2.joinPathSegments = joinPathSegments;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/reader.js
var require_reader = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/reader.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var common = require_common3();
    var Reader = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._root = common.replacePathSegmentSeparator(_root, _settings.pathSegmentSeparator);
      }
    };
    __name(Reader, "Reader");
    exports2.default = Reader;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/async.js
var require_async4 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var events_1 = require("events");
    var fsScandir = require_out2();
    var fastq = require_queue();
    var common = require_common3();
    var reader_1 = require_reader();
    var AsyncReader = class extends reader_1.default {
      constructor(_root, _settings) {
        super(_root, _settings);
        this._settings = _settings;
        this._scandir = fsScandir.scandir;
        this._emitter = new events_1.EventEmitter();
        this._queue = fastq(this._worker.bind(this), this._settings.concurrency);
        this._isFatalError = false;
        this._isDestroyed = false;
        this._queue.drain = () => {
          if (!this._isFatalError) {
            this._emitter.emit("end");
          }
        };
      }
      read() {
        this._isFatalError = false;
        this._isDestroyed = false;
        setImmediate(() => {
          this._pushToQueue(this._root, this._settings.basePath);
        });
        return this._emitter;
      }
      get isDestroyed() {
        return this._isDestroyed;
      }
      destroy() {
        if (this._isDestroyed) {
          throw new Error("The reader is already destroyed");
        }
        this._isDestroyed = true;
        this._queue.killAndDrain();
      }
      onEntry(callback) {
        this._emitter.on("entry", callback);
      }
      onError(callback) {
        this._emitter.once("error", callback);
      }
      onEnd(callback) {
        this._emitter.once("end", callback);
      }
      _pushToQueue(directory, base) {
        const queueItem = { directory, base };
        this._queue.push(queueItem, (error2) => {
          if (error2 !== null) {
            this._handleError(error2);
          }
        });
      }
      _worker(item, done) {
        this._scandir(item.directory, this._settings.fsScandirSettings, (error2, entries) => {
          if (error2 !== null) {
            done(error2, void 0);
            return;
          }
          for (const entry of entries) {
            this._handleEntry(entry, item.base);
          }
          done(null, void 0);
        });
      }
      _handleError(error2) {
        if (this._isDestroyed || !common.isFatalError(this._settings, error2)) {
          return;
        }
        this._isFatalError = true;
        this._isDestroyed = true;
        this._emitter.emit("error", error2);
      }
      _handleEntry(entry, base) {
        if (this._isDestroyed || this._isFatalError) {
          return;
        }
        const fullpath = entry.path;
        if (base !== void 0) {
          entry.path = common.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common.isAppliedFilter(this._settings.entryFilter, entry)) {
          this._emitEntry(entry);
        }
        if (entry.dirent.isDirectory() && common.isAppliedFilter(this._settings.deepFilter, entry)) {
          this._pushToQueue(fullpath, base === void 0 ? void 0 : entry.path);
        }
      }
      _emitEntry(entry) {
        this._emitter.emit("entry", entry);
      }
    };
    __name(AsyncReader, "AsyncReader");
    exports2.default = AsyncReader;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/async.js
var require_async5 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var async_1 = require_async4();
    var AsyncProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1.default(this._root, this._settings);
        this._storage = [];
      }
      read(callback) {
        this._reader.onError((error2) => {
          callFailureCallback(callback, error2);
        });
        this._reader.onEntry((entry) => {
          this._storage.push(entry);
        });
        this._reader.onEnd(() => {
          callSuccessCallback(callback, this._storage);
        });
        this._reader.read();
      }
    };
    __name(AsyncProvider, "AsyncProvider");
    exports2.default = AsyncProvider;
    function callFailureCallback(callback, error2) {
      callback(error2);
    }
    __name(callFailureCallback, "callFailureCallback");
    function callSuccessCallback(callback, entries) {
      callback(null, entries);
    }
    __name(callSuccessCallback, "callSuccessCallback");
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/stream.js
var require_stream3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/stream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var stream_1 = require("stream");
    var async_1 = require_async4();
    var StreamProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1.default(this._root, this._settings);
        this._stream = new stream_1.Readable({
          objectMode: true,
          read: () => {
          },
          destroy: () => {
            if (!this._reader.isDestroyed) {
              this._reader.destroy();
            }
          }
        });
      }
      read() {
        this._reader.onError((error2) => {
          this._stream.emit("error", error2);
        });
        this._reader.onEntry((entry) => {
          this._stream.push(entry);
        });
        this._reader.onEnd(() => {
          this._stream.push(null);
        });
        this._reader.read();
        return this._stream;
      }
    };
    __name(StreamProvider, "StreamProvider");
    exports2.default = StreamProvider;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/sync.js
var require_sync4 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/readers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fsScandir = require_out2();
    var common = require_common3();
    var reader_1 = require_reader();
    var SyncReader = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._scandir = fsScandir.scandirSync;
        this._storage = [];
        this._queue = /* @__PURE__ */ new Set();
      }
      read() {
        this._pushToQueue(this._root, this._settings.basePath);
        this._handleQueue();
        return this._storage;
      }
      _pushToQueue(directory, base) {
        this._queue.add({ directory, base });
      }
      _handleQueue() {
        for (const item of this._queue.values()) {
          this._handleDirectory(item.directory, item.base);
        }
      }
      _handleDirectory(directory, base) {
        try {
          const entries = this._scandir(directory, this._settings.fsScandirSettings);
          for (const entry of entries) {
            this._handleEntry(entry, base);
          }
        } catch (error2) {
          this._handleError(error2);
        }
      }
      _handleError(error2) {
        if (!common.isFatalError(this._settings, error2)) {
          return;
        }
        throw error2;
      }
      _handleEntry(entry, base) {
        const fullpath = entry.path;
        if (base !== void 0) {
          entry.path = common.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common.isAppliedFilter(this._settings.entryFilter, entry)) {
          this._pushToStorage(entry);
        }
        if (entry.dirent.isDirectory() && common.isAppliedFilter(this._settings.deepFilter, entry)) {
          this._pushToQueue(fullpath, base === void 0 ? void 0 : entry.path);
        }
      }
      _pushToStorage(entry) {
        this._storage.push(entry);
      }
    };
    __name(SyncReader, "SyncReader");
    exports2.default = SyncReader;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/sync.js
var require_sync5 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/providers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var sync_1 = require_sync4();
    var SyncProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new sync_1.default(this._root, this._settings);
      }
      read() {
        return this._reader.read();
      }
    };
    __name(SyncProvider, "SyncProvider");
    exports2.default = SyncProvider;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/settings.js
var require_settings3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/settings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var path32 = require("path");
    var fsScandir = require_out2();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.basePath = this._getValue(this._options.basePath, void 0);
        this.concurrency = this._getValue(this._options.concurrency, Number.POSITIVE_INFINITY);
        this.deepFilter = this._getValue(this._options.deepFilter, null);
        this.entryFilter = this._getValue(this._options.entryFilter, null);
        this.errorFilter = this._getValue(this._options.errorFilter, null);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path32.sep);
        this.fsScandirSettings = new fsScandir.Settings({
          followSymbolicLinks: this._options.followSymbolicLinks,
          fs: this._options.fs,
          pathSegmentSeparator: this._options.pathSegmentSeparator,
          stats: this._options.stats,
          throwErrorOnBrokenSymbolicLink: this._options.throwErrorOnBrokenSymbolicLink
        });
      }
      _getValue(option, value) {
        return option !== null && option !== void 0 ? option : value;
      }
    };
    __name(Settings, "Settings");
    exports2.default = Settings;
  }
});

// ../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/index.js
var require_out3 = __commonJS({
  "../../node_modules/.pnpm/@nodelib+fs.walk@1.2.8/node_modules/@nodelib/fs.walk/out/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Settings = exports2.walkStream = exports2.walkSync = exports2.walk = void 0;
    var async_1 = require_async5();
    var stream_1 = require_stream3();
    var sync_1 = require_sync5();
    var settings_1 = require_settings3();
    exports2.Settings = settings_1.default;
    function walk(directory, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        new async_1.default(directory, getSettings()).read(optionsOrSettingsOrCallback);
        return;
      }
      new async_1.default(directory, getSettings(optionsOrSettingsOrCallback)).read(callback);
    }
    __name(walk, "walk");
    exports2.walk = walk;
    function walkSync(directory, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      const provider = new sync_1.default(directory, settings);
      return provider.read();
    }
    __name(walkSync, "walkSync");
    exports2.walkSync = walkSync;
    function walkStream(directory, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      const provider = new stream_1.default(directory, settings);
      return provider.read();
    }
    __name(walkStream, "walkStream");
    exports2.walkStream = walkStream;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
    __name(getSettings, "getSettings");
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/reader.js
var require_reader2 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/reader.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var path32 = require("path");
    var fsStat = require_out();
    var utils = require_utils3();
    var Reader = class {
      constructor(_settings) {
        this._settings = _settings;
        this._fsStatSettings = new fsStat.Settings({
          followSymbolicLink: this._settings.followSymbolicLinks,
          fs: this._settings.fs,
          throwErrorOnBrokenSymbolicLink: this._settings.followSymbolicLinks
        });
      }
      _getFullEntryPath(filepath) {
        return path32.resolve(this._settings.cwd, filepath);
      }
      _makeEntry(stats, pattern) {
        const entry = {
          name: pattern,
          path: pattern,
          dirent: utils.fs.createDirentFromStats(pattern, stats)
        };
        if (this._settings.stats) {
          entry.stats = stats;
        }
        return entry;
      }
      _isFatalError(error2) {
        return !utils.errno.isEnoentCodeError(error2) && !this._settings.suppressErrors;
      }
    };
    __name(Reader, "Reader");
    exports2.default = Reader;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/stream.js
var require_stream4 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/stream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var stream_1 = require("stream");
    var fsStat = require_out();
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var ReaderStream = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkStream = fsWalk.walkStream;
        this._stat = fsStat.stat;
      }
      dynamic(root, options2) {
        return this._walkStream(root, options2);
      }
      static(patterns, options2) {
        const filepaths = patterns.map(this._getFullEntryPath, this);
        const stream3 = new stream_1.PassThrough({ objectMode: true });
        stream3._write = (index2, _enc, done) => {
          return this._getEntry(filepaths[index2], patterns[index2], options2).then((entry) => {
            if (entry !== null && options2.entryFilter(entry)) {
              stream3.push(entry);
            }
            if (index2 === filepaths.length - 1) {
              stream3.end();
            }
            done();
          }).catch(done);
        };
        for (let i3 = 0; i3 < filepaths.length; i3++) {
          stream3.write(i3);
        }
        return stream3;
      }
      _getEntry(filepath, pattern, options2) {
        return this._getStat(filepath).then((stats) => this._makeEntry(stats, pattern)).catch((error2) => {
          if (options2.errorFilter(error2)) {
            return null;
          }
          throw error2;
        });
      }
      _getStat(filepath) {
        return new Promise((resolve2, reject2) => {
          this._stat(filepath, this._fsStatSettings, (error2, stats) => {
            return error2 === null ? resolve2(stats) : reject2(error2);
          });
        });
      }
    };
    __name(ReaderStream, "ReaderStream");
    exports2.default = ReaderStream;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/async.js
var require_async6 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var stream_1 = require_stream4();
    var ReaderAsync = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkAsync = fsWalk.walk;
        this._readerStream = new stream_1.default(this._settings);
      }
      dynamic(root, options2) {
        return new Promise((resolve2, reject2) => {
          this._walkAsync(root, options2, (error2, entries) => {
            if (error2 === null) {
              resolve2(entries);
            } else {
              reject2(error2);
            }
          });
        });
      }
      async static(patterns, options2) {
        const entries = [];
        const stream3 = this._readerStream.static(patterns, options2);
        return new Promise((resolve2, reject2) => {
          stream3.once("error", reject2);
          stream3.on("data", (entry) => entries.push(entry));
          stream3.once("end", () => resolve2(entries));
        });
      }
    };
    __name(ReaderAsync, "ReaderAsync");
    exports2.default = ReaderAsync;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/matchers/matcher.js
var require_matcher = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/matchers/matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var utils = require_utils3();
    var Matcher = class {
      constructor(_patterns, _settings, _micromatchOptions) {
        this._patterns = _patterns;
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this._storage = [];
        this._fillStorage();
      }
      _fillStorage() {
        const patterns = utils.pattern.expandPatternsWithBraceExpansion(this._patterns);
        for (const pattern of patterns) {
          const segments = this._getPatternSegments(pattern);
          const sections = this._splitSegmentsIntoSections(segments);
          this._storage.push({
            complete: sections.length <= 1,
            pattern,
            segments,
            sections
          });
        }
      }
      _getPatternSegments(pattern) {
        const parts = utils.pattern.getPatternParts(pattern, this._micromatchOptions);
        return parts.map((part) => {
          const dynamic = utils.pattern.isDynamicPattern(part, this._settings);
          if (!dynamic) {
            return {
              dynamic: false,
              pattern: part
            };
          }
          return {
            dynamic: true,
            pattern: part,
            patternRe: utils.pattern.makeRe(part, this._micromatchOptions)
          };
        });
      }
      _splitSegmentsIntoSections(segments) {
        return utils.array.splitWhen(segments, (segment) => segment.dynamic && utils.pattern.hasGlobStar(segment.pattern));
      }
    };
    __name(Matcher, "Matcher");
    exports2.default = Matcher;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/matchers/partial.js
var require_partial = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/matchers/partial.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var matcher_1 = require_matcher();
    var PartialMatcher = class extends matcher_1.default {
      match(filepath) {
        const parts = filepath.split("/");
        const levels = parts.length;
        const patterns = this._storage.filter((info2) => !info2.complete || info2.segments.length > levels);
        for (const pattern of patterns) {
          const section = pattern.sections[0];
          if (!pattern.complete && levels > section.length) {
            return true;
          }
          const match4 = parts.every((part, index2) => {
            const segment = pattern.segments[index2];
            if (segment.dynamic && segment.patternRe.test(part)) {
              return true;
            }
            if (!segment.dynamic && segment.pattern === part) {
              return true;
            }
            return false;
          });
          if (match4) {
            return true;
          }
        }
        return false;
      }
    };
    __name(PartialMatcher, "PartialMatcher");
    exports2.default = PartialMatcher;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/deep.js
var require_deep = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/deep.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var utils = require_utils3();
    var partial_1 = require_partial();
    var DeepFilter = class {
      constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
      }
      getFilter(basePath2, positive, negative) {
        const matcher = this._getMatcher(positive);
        const negativeRe = this._getNegativePatternsRe(negative);
        return (entry) => this._filter(basePath2, entry, matcher, negativeRe);
      }
      _getMatcher(patterns) {
        return new partial_1.default(patterns, this._settings, this._micromatchOptions);
      }
      _getNegativePatternsRe(patterns) {
        const affectDepthOfReadingPatterns = patterns.filter(utils.pattern.isAffectDepthOfReadingPattern);
        return utils.pattern.convertPatternsToRe(affectDepthOfReadingPatterns, this._micromatchOptions);
      }
      _filter(basePath2, entry, matcher, negativeRe) {
        if (this._isSkippedByDeep(basePath2, entry.path)) {
          return false;
        }
        if (this._isSkippedSymbolicLink(entry)) {
          return false;
        }
        const filepath = utils.path.removeLeadingDotSegment(entry.path);
        if (this._isSkippedByPositivePatterns(filepath, matcher)) {
          return false;
        }
        return this._isSkippedByNegativePatterns(filepath, negativeRe);
      }
      _isSkippedByDeep(basePath2, entryPath) {
        if (this._settings.deep === Infinity) {
          return false;
        }
        return this._getEntryLevel(basePath2, entryPath) >= this._settings.deep;
      }
      _getEntryLevel(basePath2, entryPath) {
        const entryPathDepth = entryPath.split("/").length;
        if (basePath2 === "") {
          return entryPathDepth;
        }
        const basePathDepth = basePath2.split("/").length;
        return entryPathDepth - basePathDepth;
      }
      _isSkippedSymbolicLink(entry) {
        return !this._settings.followSymbolicLinks && entry.dirent.isSymbolicLink();
      }
      _isSkippedByPositivePatterns(entryPath, matcher) {
        return !this._settings.baseNameMatch && !matcher.match(entryPath);
      }
      _isSkippedByNegativePatterns(entryPath, patternsRe) {
        return !utils.pattern.matchAny(entryPath, patternsRe);
      }
    };
    __name(DeepFilter, "DeepFilter");
    exports2.default = DeepFilter;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/entry.js
var require_entry = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/entry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var utils = require_utils3();
    var EntryFilter = class {
      constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this.index = /* @__PURE__ */ new Map();
      }
      getFilter(positive, negative) {
        const positiveRe = utils.pattern.convertPatternsToRe(positive, this._micromatchOptions);
        const negativeRe = utils.pattern.convertPatternsToRe(negative, this._micromatchOptions);
        return (entry) => this._filter(entry, positiveRe, negativeRe);
      }
      _filter(entry, positiveRe, negativeRe) {
        if (this._settings.unique && this._isDuplicateEntry(entry)) {
          return false;
        }
        if (this._onlyFileFilter(entry) || this._onlyDirectoryFilter(entry)) {
          return false;
        }
        if (this._isSkippedByAbsoluteNegativePatterns(entry.path, negativeRe)) {
          return false;
        }
        const filepath = this._settings.baseNameMatch ? entry.name : entry.path;
        const isDirectory = entry.dirent.isDirectory();
        const isMatched = this._isMatchToPatterns(filepath, positiveRe, isDirectory) && !this._isMatchToPatterns(entry.path, negativeRe, isDirectory);
        if (this._settings.unique && isMatched) {
          this._createIndexRecord(entry);
        }
        return isMatched;
      }
      _isDuplicateEntry(entry) {
        return this.index.has(entry.path);
      }
      _createIndexRecord(entry) {
        this.index.set(entry.path, void 0);
      }
      _onlyFileFilter(entry) {
        return this._settings.onlyFiles && !entry.dirent.isFile();
      }
      _onlyDirectoryFilter(entry) {
        return this._settings.onlyDirectories && !entry.dirent.isDirectory();
      }
      _isSkippedByAbsoluteNegativePatterns(entryPath, patternsRe) {
        if (!this._settings.absolute) {
          return false;
        }
        const fullpath = utils.path.makeAbsolute(this._settings.cwd, entryPath);
        return utils.pattern.matchAny(fullpath, patternsRe);
      }
      _isMatchToPatterns(entryPath, patternsRe, isDirectory) {
        const filepath = utils.path.removeLeadingDotSegment(entryPath);
        const isMatched = utils.pattern.matchAny(filepath, patternsRe);
        if (!isMatched && isDirectory) {
          return utils.pattern.matchAny(filepath + "/", patternsRe);
        }
        return isMatched;
      }
    };
    __name(EntryFilter, "EntryFilter");
    exports2.default = EntryFilter;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/error.js
var require_error2 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/filters/error.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var utils = require_utils3();
    var ErrorFilter = class {
      constructor(_settings) {
        this._settings = _settings;
      }
      getFilter() {
        return (error2) => this._isNonFatalError(error2);
      }
      _isNonFatalError(error2) {
        return utils.errno.isEnoentCodeError(error2) || this._settings.suppressErrors;
      }
    };
    __name(ErrorFilter, "ErrorFilter");
    exports2.default = ErrorFilter;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/transformers/entry.js
var require_entry2 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/transformers/entry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var utils = require_utils3();
    var EntryTransformer = class {
      constructor(_settings) {
        this._settings = _settings;
      }
      getTransformer() {
        return (entry) => this._transform(entry);
      }
      _transform(entry) {
        let filepath = entry.path;
        if (this._settings.absolute) {
          filepath = utils.path.makeAbsolute(this._settings.cwd, filepath);
          filepath = utils.path.unixify(filepath);
        }
        if (this._settings.markDirectories && entry.dirent.isDirectory()) {
          filepath += "/";
        }
        if (!this._settings.objectMode) {
          return filepath;
        }
        return Object.assign(Object.assign({}, entry), { path: filepath });
      }
    };
    __name(EntryTransformer, "EntryTransformer");
    exports2.default = EntryTransformer;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/provider.js
var require_provider = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/provider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var path32 = require("path");
    var deep_1 = require_deep();
    var entry_1 = require_entry();
    var error_1 = require_error2();
    var entry_2 = require_entry2();
    var Provider = class {
      constructor(_settings) {
        this._settings = _settings;
        this.errorFilter = new error_1.default(this._settings);
        this.entryFilter = new entry_1.default(this._settings, this._getMicromatchOptions());
        this.deepFilter = new deep_1.default(this._settings, this._getMicromatchOptions());
        this.entryTransformer = new entry_2.default(this._settings);
      }
      _getRootDirectory(task) {
        return path32.resolve(this._settings.cwd, task.base);
      }
      _getReaderOptions(task) {
        const basePath2 = task.base === "." ? "" : task.base;
        return {
          basePath: basePath2,
          pathSegmentSeparator: "/",
          concurrency: this._settings.concurrency,
          deepFilter: this.deepFilter.getFilter(basePath2, task.positive, task.negative),
          entryFilter: this.entryFilter.getFilter(task.positive, task.negative),
          errorFilter: this.errorFilter.getFilter(),
          followSymbolicLinks: this._settings.followSymbolicLinks,
          fs: this._settings.fs,
          stats: this._settings.stats,
          throwErrorOnBrokenSymbolicLink: this._settings.throwErrorOnBrokenSymbolicLink,
          transform: this.entryTransformer.getTransformer()
        };
      }
      _getMicromatchOptions() {
        return {
          dot: this._settings.dot,
          matchBase: this._settings.baseNameMatch,
          nobrace: !this._settings.braceExpansion,
          nocase: !this._settings.caseSensitiveMatch,
          noext: !this._settings.extglob,
          noglobstar: !this._settings.globstar,
          posix: true,
          strictSlashes: false
        };
      }
    };
    __name(Provider, "Provider");
    exports2.default = Provider;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/async.js
var require_async7 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/async.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var async_1 = require_async6();
    var provider_1 = require_provider();
    var ProviderAsync = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new async_1.default(this._settings);
      }
      async read(task) {
        const root = this._getRootDirectory(task);
        const options2 = this._getReaderOptions(task);
        const entries = await this.api(root, task, options2);
        return entries.map((entry) => options2.transform(entry));
      }
      api(root, task, options2) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options2);
        }
        return this._reader.static(task.patterns, options2);
      }
    };
    __name(ProviderAsync, "ProviderAsync");
    exports2.default = ProviderAsync;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/stream.js
var require_stream5 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/stream.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var stream_1 = require("stream");
    var stream_2 = require_stream4();
    var provider_1 = require_provider();
    var ProviderStream = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new stream_2.default(this._settings);
      }
      read(task) {
        const root = this._getRootDirectory(task);
        const options2 = this._getReaderOptions(task);
        const source = this.api(root, task, options2);
        const destination = new stream_1.Readable({ objectMode: true, read: () => {
        } });
        source.once("error", (error2) => destination.emit("error", error2)).on("data", (entry) => destination.emit("data", options2.transform(entry))).once("end", () => destination.emit("end"));
        destination.once("close", () => source.destroy());
        return destination;
      }
      api(root, task, options2) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options2);
        }
        return this._reader.static(task.patterns, options2);
      }
    };
    __name(ProviderStream, "ProviderStream");
    exports2.default = ProviderStream;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/sync.js
var require_sync6 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/readers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fsStat = require_out();
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var ReaderSync = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkSync = fsWalk.walkSync;
        this._statSync = fsStat.statSync;
      }
      dynamic(root, options2) {
        return this._walkSync(root, options2);
      }
      static(patterns, options2) {
        const entries = [];
        for (const pattern of patterns) {
          const filepath = this._getFullEntryPath(pattern);
          const entry = this._getEntry(filepath, pattern, options2);
          if (entry === null || !options2.entryFilter(entry)) {
            continue;
          }
          entries.push(entry);
        }
        return entries;
      }
      _getEntry(filepath, pattern, options2) {
        try {
          const stats = this._getStat(filepath);
          return this._makeEntry(stats, pattern);
        } catch (error2) {
          if (options2.errorFilter(error2)) {
            return null;
          }
          throw error2;
        }
      }
      _getStat(filepath) {
        return this._statSync(filepath, this._fsStatSettings);
      }
    };
    __name(ReaderSync, "ReaderSync");
    exports2.default = ReaderSync;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/sync.js
var require_sync7 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/providers/sync.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var sync_1 = require_sync6();
    var provider_1 = require_provider();
    var ProviderSync = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new sync_1.default(this._settings);
      }
      read(task) {
        const root = this._getRootDirectory(task);
        const options2 = this._getReaderOptions(task);
        const entries = this.api(root, task, options2);
        return entries.map(options2.transform);
      }
      api(root, task, options2) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options2);
        }
        return this._reader.static(task.patterns, options2);
      }
    };
    __name(ProviderSync, "ProviderSync");
    exports2.default = ProviderSync;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/settings.js
var require_settings4 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/settings.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DEFAULT_FILE_SYSTEM_ADAPTER = void 0;
    var fs37 = require("fs");
    var os6 = require("os");
    var CPU_COUNT = Math.max(os6.cpus().length, 1);
    exports2.DEFAULT_FILE_SYSTEM_ADAPTER = {
      lstat: fs37.lstat,
      lstatSync: fs37.lstatSync,
      stat: fs37.stat,
      statSync: fs37.statSync,
      readdir: fs37.readdir,
      readdirSync: fs37.readdirSync
    };
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.absolute = this._getValue(this._options.absolute, false);
        this.baseNameMatch = this._getValue(this._options.baseNameMatch, false);
        this.braceExpansion = this._getValue(this._options.braceExpansion, true);
        this.caseSensitiveMatch = this._getValue(this._options.caseSensitiveMatch, true);
        this.concurrency = this._getValue(this._options.concurrency, CPU_COUNT);
        this.cwd = this._getValue(this._options.cwd, process.cwd());
        this.deep = this._getValue(this._options.deep, Infinity);
        this.dot = this._getValue(this._options.dot, false);
        this.extglob = this._getValue(this._options.extglob, true);
        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, true);
        this.fs = this._getFileSystemMethods(this._options.fs);
        this.globstar = this._getValue(this._options.globstar, true);
        this.ignore = this._getValue(this._options.ignore, []);
        this.markDirectories = this._getValue(this._options.markDirectories, false);
        this.objectMode = this._getValue(this._options.objectMode, false);
        this.onlyDirectories = this._getValue(this._options.onlyDirectories, false);
        this.onlyFiles = this._getValue(this._options.onlyFiles, true);
        this.stats = this._getValue(this._options.stats, false);
        this.suppressErrors = this._getValue(this._options.suppressErrors, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, false);
        this.unique = this._getValue(this._options.unique, true);
        if (this.onlyDirectories) {
          this.onlyFiles = false;
        }
        if (this.stats) {
          this.objectMode = true;
        }
      }
      _getValue(option, value) {
        return option === void 0 ? value : option;
      }
      _getFileSystemMethods(methods = {}) {
        return Object.assign(Object.assign({}, exports2.DEFAULT_FILE_SYSTEM_ADAPTER), methods);
      }
    };
    __name(Settings, "Settings");
    exports2.default = Settings;
  }
});

// ../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/index.js
var require_out4 = __commonJS({
  "../../node_modules/.pnpm/fast-glob@3.2.12/node_modules/fast-glob/out/index.js"(exports2, module2) {
    "use strict";
    var taskManager = require_tasks();
    var patternManager = require_patterns();
    var async_1 = require_async7();
    var stream_1 = require_stream5();
    var sync_1 = require_sync7();
    var settings_1 = require_settings4();
    var utils = require_utils3();
    async function FastGlob(source, options2) {
      assertPatternsInput(source);
      const works = getWorks(source, async_1.default, options2);
      const result = await Promise.all(works);
      return utils.array.flatten(result);
    }
    __name(FastGlob, "FastGlob");
    (function(FastGlob2) {
      function sync(source, options2) {
        assertPatternsInput(source);
        const works = getWorks(source, sync_1.default, options2);
        return utils.array.flatten(works);
      }
      __name(sync, "sync");
      FastGlob2.sync = sync;
      function stream3(source, options2) {
        assertPatternsInput(source);
        const works = getWorks(source, stream_1.default, options2);
        return utils.stream.merge(works);
      }
      __name(stream3, "stream");
      FastGlob2.stream = stream3;
      function generateTasks(source, options2) {
        assertPatternsInput(source);
        const patterns = patternManager.transform([].concat(source));
        const settings = new settings_1.default(options2);
        return taskManager.generate(patterns, settings);
      }
      __name(generateTasks, "generateTasks");
      FastGlob2.generateTasks = generateTasks;
      function isDynamicPattern(source, options2) {
        assertPatternsInput(source);
        const settings = new settings_1.default(options2);
        return utils.pattern.isDynamicPattern(source, settings);
      }
      __name(isDynamicPattern, "isDynamicPattern");
      FastGlob2.isDynamicPattern = isDynamicPattern;
      function escapePath(source) {
        assertPatternsInput(source);
        return utils.path.escape(source);
      }
      __name(escapePath, "escapePath");
      FastGlob2.escapePath = escapePath;
    })(FastGlob || (FastGlob = {}));
    function getWorks(source, _Provider, options2) {
      const patterns = patternManager.transform([].concat(source));
      const settings = new settings_1.default(options2);
      const tasks = taskManager.generate(patterns, settings);
      const provider = new _Provider(settings);
      return tasks.map(provider.read, provider);
    }
    __name(getWorks, "getWorks");
    function assertPatternsInput(input) {
      const source = [].concat(input);
      const isValidSource = source.every((item) => utils.string.isString(item) && !utils.string.isEmpty(item));
      if (!isValidSource) {
        throw new TypeError("Patterns must be a string (non empty) or an array of strings");
      }
    }
    __name(assertPatternsInput, "assertPatternsInput");
    module2.exports = FastGlob;
  }
});

// ../../node_modules/.pnpm/path-type@4.0.0/node_modules/path-type/index.js
var require_path_type = __commonJS({
  "../../node_modules/.pnpm/path-type@4.0.0/node_modules/path-type/index.js"(exports2) {
    "use strict";
    var { promisify: promisify12 } = require("util");
    var fs37 = require("fs");
    async function isType(fsStatType, statsMethodName, filePath) {
      if (typeof filePath !== "string") {
        throw new TypeError(`Expected a string, got ${typeof filePath}`);
      }
      try {
        const stats = await promisify12(fs37[fsStatType])(filePath);
        return stats[statsMethodName]();
      } catch (error2) {
        if (error2.code === "ENOENT") {
          return false;
        }
        throw error2;
      }
    }
    __name(isType, "isType");
    function isTypeSync(fsStatType, statsMethodName, filePath) {
      if (typeof filePath !== "string") {
        throw new TypeError(`Expected a string, got ${typeof filePath}`);
      }
      try {
        return fs37[fsStatType](filePath)[statsMethodName]();
      } catch (error2) {
        if (error2.code === "ENOENT") {
          return false;
        }
        throw error2;
      }
    }
    __name(isTypeSync, "isTypeSync");
    exports2.isFile = isType.bind(null, "stat", "isFile");
    exports2.isDirectory = isType.bind(null, "stat", "isDirectory");
    exports2.isSymlink = isType.bind(null, "lstat", "isSymbolicLink");
    exports2.isFileSync = isTypeSync.bind(null, "statSync", "isFile");
    exports2.isDirectorySync = isTypeSync.bind(null, "statSync", "isDirectory");
    exports2.isSymlinkSync = isTypeSync.bind(null, "lstatSync", "isSymbolicLink");
  }
});

// ../../node_modules/.pnpm/dir-glob@3.0.1/node_modules/dir-glob/index.js
var require_dir_glob = __commonJS({
  "../../node_modules/.pnpm/dir-glob@3.0.1/node_modules/dir-glob/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var pathType = require_path_type();
    var getExtensions = /* @__PURE__ */ __name((extensions) => extensions.length > 1 ? `{${extensions.join(",")}}` : extensions[0], "getExtensions");
    var getPath = /* @__PURE__ */ __name((filepath, cwd) => {
      const pth = filepath[0] === "!" ? filepath.slice(1) : filepath;
      return path32.isAbsolute(pth) ? pth : path32.join(cwd, pth);
    }, "getPath");
    var addExtensions = /* @__PURE__ */ __name((file2, extensions) => {
      if (path32.extname(file2)) {
        return `**/${file2}`;
      }
      return `**/${file2}.${getExtensions(extensions)}`;
    }, "addExtensions");
    var getGlob = /* @__PURE__ */ __name((directory, options2) => {
      if (options2.files && !Array.isArray(options2.files)) {
        throw new TypeError(`Expected \`files\` to be of type \`Array\` but received type \`${typeof options2.files}\``);
      }
      if (options2.extensions && !Array.isArray(options2.extensions)) {
        throw new TypeError(`Expected \`extensions\` to be of type \`Array\` but received type \`${typeof options2.extensions}\``);
      }
      if (options2.files && options2.extensions) {
        return options2.files.map((x) => path32.posix.join(directory, addExtensions(x, options2.extensions)));
      }
      if (options2.files) {
        return options2.files.map((x) => path32.posix.join(directory, `**/${x}`));
      }
      if (options2.extensions) {
        return [path32.posix.join(directory, `**/*.${getExtensions(options2.extensions)}`)];
      }
      return [path32.posix.join(directory, "**")];
    }, "getGlob");
    module2.exports = async (input, options2) => {
      options2 = {
        cwd: process.cwd(),
        ...options2
      };
      if (typeof options2.cwd !== "string") {
        throw new TypeError(`Expected \`cwd\` to be of type \`string\` but received type \`${typeof options2.cwd}\``);
      }
      const globs = await Promise.all([].concat(input).map(async (x) => {
        const isDirectory = await pathType.isDirectory(getPath(x, options2.cwd));
        return isDirectory ? getGlob(x, options2) : x;
      }));
      return [].concat.apply([], globs);
    };
    module2.exports.sync = (input, options2) => {
      options2 = {
        cwd: process.cwd(),
        ...options2
      };
      if (typeof options2.cwd !== "string") {
        throw new TypeError(`Expected \`cwd\` to be of type \`string\` but received type \`${typeof options2.cwd}\``);
      }
      const globs = [].concat(input).map((x) => pathType.isDirectorySync(getPath(x, options2.cwd)) ? getGlob(x, options2) : x);
      return [].concat.apply([], globs);
    };
  }
});

// ../../node_modules/.pnpm/ignore@5.2.4/node_modules/ignore/index.js
var require_ignore = __commonJS({
  "../../node_modules/.pnpm/ignore@5.2.4/node_modules/ignore/index.js"(exports2, module2) {
    function makeArray(subject) {
      return Array.isArray(subject) ? subject : [subject];
    }
    __name(makeArray, "makeArray");
    var EMPTY = "";
    var SPACE = " ";
    var ESCAPE = "\\";
    var REGEX_TEST_BLANK_LINE = /^\s+$/;
    var REGEX_INVALID_TRAILING_BACKSLASH = /(?:[^\\]|^)\\$/;
    var REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION = /^\\!/;
    var REGEX_REPLACE_LEADING_EXCAPED_HASH = /^\\#/;
    var REGEX_SPLITALL_CRLF = /\r?\n/g;
    var REGEX_TEST_INVALID_PATH = /^\.*\/|^\.+$/;
    var SLASH = "/";
    var TMP_KEY_IGNORE = "node-ignore";
    if (typeof Symbol !== "undefined") {
      TMP_KEY_IGNORE = Symbol.for("node-ignore");
    }
    var KEY_IGNORE = TMP_KEY_IGNORE;
    var define2 = /* @__PURE__ */ __name((object, key, value) => Object.defineProperty(object, key, { value }), "define");
    var REGEX_REGEXP_RANGE = /([0-z])-([0-z])/g;
    var RETURN_FALSE = /* @__PURE__ */ __name(() => false, "RETURN_FALSE");
    var sanitizeRange = /* @__PURE__ */ __name((range2) => range2.replace(
      REGEX_REGEXP_RANGE,
      (match4, from, to) => from.charCodeAt(0) <= to.charCodeAt(0) ? match4 : EMPTY
    ), "sanitizeRange");
    var cleanRangeBackSlash = /* @__PURE__ */ __name((slashes) => {
      const { length } = slashes;
      return slashes.slice(0, length - length % 2);
    }, "cleanRangeBackSlash");
    var REPLACERS = [
      [
        /\\?\s+$/,
        (match4) => match4.indexOf("\\") === 0 ? SPACE : EMPTY
      ],
      [
        /\\\s/g,
        () => SPACE
      ],
      [
        /[\\$.|*+(){^]/g,
        (match4) => `\\${match4}`
      ],
      [
        /(?!\\)\?/g,
        () => "[^/]"
      ],
      [
        /^\//,
        () => "^"
      ],
      [
        /\//g,
        () => "\\/"
      ],
      [
        /^\^*\\\*\\\*\\\//,
        () => "^(?:.*\\/)?"
      ],
      [
        /^(?=[^^])/,
        /* @__PURE__ */ __name(function startingReplacer() {
          return !/\/(?!$)/.test(this) ? "(?:^|\\/)" : "^";
        }, "startingReplacer")
      ],
      [
        /\\\/\\\*\\\*(?=\\\/|$)/g,
        (_2, index2, str) => index2 + 6 < str.length ? "(?:\\/[^\\/]+)*" : "\\/.+"
      ],
      [
        /(^|[^\\]+)(\\\*)+(?=.+)/g,
        (_2, p1, p22) => {
          const unescaped = p22.replace(/\\\*/g, "[^\\/]*");
          return p1 + unescaped;
        }
      ],
      [
        /\\\\\\(?=[$.|*+(){^])/g,
        () => ESCAPE
      ],
      [
        /\\\\/g,
        () => ESCAPE
      ],
      [
        /(\\)?\[([^\]/]*?)(\\*)($|\])/g,
        (match4, leadEscape, range2, endEscape, close2) => leadEscape === ESCAPE ? `\\[${range2}${cleanRangeBackSlash(endEscape)}${close2}` : close2 === "]" ? endEscape.length % 2 === 0 ? `[${sanitizeRange(range2)}${endEscape}]` : "[]" : "[]"
      ],
      [
        /(?:[^*])$/,
        (match4) => /\/$/.test(match4) ? `${match4}$` : `${match4}(?=$|\\/$)`
      ],
      [
        /(\^|\\\/)?\\\*$/,
        (_2, p1) => {
          const prefix = p1 ? `${p1}[^/]+` : "[^/]*";
          return `${prefix}(?=$|\\/$)`;
        }
      ]
    ];
    var regexCache = /* @__PURE__ */ Object.create(null);
    var makeRegex = /* @__PURE__ */ __name((pattern, ignoreCase) => {
      let source = regexCache[pattern];
      if (!source) {
        source = REPLACERS.reduce(
          (prev, current) => prev.replace(current[0], current[1].bind(pattern)),
          pattern
        );
        regexCache[pattern] = source;
      }
      return ignoreCase ? new RegExp(source, "i") : new RegExp(source);
    }, "makeRegex");
    var isString = /* @__PURE__ */ __name((subject) => typeof subject === "string", "isString");
    var checkPattern = /* @__PURE__ */ __name((pattern) => pattern && isString(pattern) && !REGEX_TEST_BLANK_LINE.test(pattern) && !REGEX_INVALID_TRAILING_BACKSLASH.test(pattern) && pattern.indexOf("#") !== 0, "checkPattern");
    var splitPattern = /* @__PURE__ */ __name((pattern) => pattern.split(REGEX_SPLITALL_CRLF), "splitPattern");
    var IgnoreRule = class {
      constructor(origin, pattern, negative, regex) {
        this.origin = origin;
        this.pattern = pattern;
        this.negative = negative;
        this.regex = regex;
      }
    };
    __name(IgnoreRule, "IgnoreRule");
    var createRule = /* @__PURE__ */ __name((pattern, ignoreCase) => {
      const origin = pattern;
      let negative = false;
      if (pattern.indexOf("!") === 0) {
        negative = true;
        pattern = pattern.substr(1);
      }
      pattern = pattern.replace(REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION, "!").replace(REGEX_REPLACE_LEADING_EXCAPED_HASH, "#");
      const regex = makeRegex(pattern, ignoreCase);
      return new IgnoreRule(
        origin,
        pattern,
        negative,
        regex
      );
    }, "createRule");
    var throwError = /* @__PURE__ */ __name((message2, Ctor) => {
      throw new Ctor(message2);
    }, "throwError");
    var checkPath2 = /* @__PURE__ */ __name((path32, originalPath, doThrow) => {
      if (!isString(path32)) {
        return doThrow(
          `path must be a string, but got \`${originalPath}\``,
          TypeError
        );
      }
      if (!path32) {
        return doThrow(`path must not be empty`, TypeError);
      }
      if (checkPath2.isNotRelative(path32)) {
        const r3 = "`path.relative()`d";
        return doThrow(
          `path should be a ${r3} string, but got "${originalPath}"`,
          RangeError
        );
      }
      return true;
    }, "checkPath");
    var isNotRelative = /* @__PURE__ */ __name((path32) => REGEX_TEST_INVALID_PATH.test(path32), "isNotRelative");
    checkPath2.isNotRelative = isNotRelative;
    checkPath2.convert = (p3) => p3;
    var Ignore = class {
      constructor({
        ignorecase = true,
        ignoreCase = ignorecase,
        allowRelativePaths = false
      } = {}) {
        define2(this, KEY_IGNORE, true);
        this._rules = [];
        this._ignoreCase = ignoreCase;
        this._allowRelativePaths = allowRelativePaths;
        this._initCache();
      }
      _initCache() {
        this._ignoreCache = /* @__PURE__ */ Object.create(null);
        this._testCache = /* @__PURE__ */ Object.create(null);
      }
      _addPattern(pattern) {
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }
        if (checkPattern(pattern)) {
          const rule = createRule(pattern, this._ignoreCase);
          this._added = true;
          this._rules.push(rule);
        }
      }
      add(pattern) {
        this._added = false;
        makeArray(
          isString(pattern) ? splitPattern(pattern) : pattern
        ).forEach(this._addPattern, this);
        if (this._added) {
          this._initCache();
        }
        return this;
      }
      addPattern(pattern) {
        return this.add(pattern);
      }
      _testOne(path32, checkUnignored) {
        let ignored = false;
        let unignored = false;
        this._rules.forEach((rule) => {
          const { negative } = rule;
          if (unignored === negative && ignored !== unignored || negative && !ignored && !unignored && !checkUnignored) {
            return;
          }
          const matched = rule.regex.test(path32);
          if (matched) {
            ignored = !negative;
            unignored = negative;
          }
        });
        return {
          ignored,
          unignored
        };
      }
      _test(originalPath, cache, checkUnignored, slices) {
        const path32 = originalPath && checkPath2.convert(originalPath);
        checkPath2(
          path32,
          originalPath,
          this._allowRelativePaths ? RETURN_FALSE : throwError
        );
        return this._t(path32, cache, checkUnignored, slices);
      }
      _t(path32, cache, checkUnignored, slices) {
        if (path32 in cache) {
          return cache[path32];
        }
        if (!slices) {
          slices = path32.split(SLASH);
        }
        slices.pop();
        if (!slices.length) {
          return cache[path32] = this._testOne(path32, checkUnignored);
        }
        const parent2 = this._t(
          slices.join(SLASH) + SLASH,
          cache,
          checkUnignored,
          slices
        );
        return cache[path32] = parent2.ignored ? parent2 : this._testOne(path32, checkUnignored);
      }
      ignores(path32) {
        return this._test(path32, this._ignoreCache, false).ignored;
      }
      createFilter() {
        return (path32) => !this.ignores(path32);
      }
      filter(paths2) {
        return makeArray(paths2).filter(this.createFilter());
      }
      test(path32) {
        return this._test(path32, this._testCache, true);
      }
    };
    __name(Ignore, "Ignore");
    var factory = /* @__PURE__ */ __name((options2) => new Ignore(options2), "factory");
    var isPathValid = /* @__PURE__ */ __name((path32) => checkPath2(path32 && checkPath2.convert(path32), path32, RETURN_FALSE), "isPathValid");
    factory.isPathValid = isPathValid;
    factory.default = factory;
    module2.exports = factory;
    if (typeof process !== "undefined" && (process.env && process.env.IGNORE_TEST_WIN32 || process.platform === "win32")) {
      const makePosix = /* @__PURE__ */ __name((str) => /^\\\\\?\\/.test(str) || /["<>|\u0000-\u001F]+/u.test(str) ? str : str.replace(/\\/g, "/"), "makePosix");
      checkPath2.convert = makePosix;
      const REGIX_IS_WINDOWS_PATH_ABSOLUTE = /^[a-z]:\//i;
      checkPath2.isNotRelative = (path32) => REGIX_IS_WINDOWS_PATH_ABSOLUTE.test(path32) || isNotRelative(path32);
    }
  }
});

// ../../node_modules/.pnpm/slash@3.0.0/node_modules/slash/index.js
var require_slash = __commonJS({
  "../../node_modules/.pnpm/slash@3.0.0/node_modules/slash/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (path32) => {
      const isExtendedLengthPath = /^\\\\\?\\/.test(path32);
      const hasNonAscii = /[^\u0000-\u0080]+/.test(path32);
      if (isExtendedLengthPath || hasNonAscii) {
        return path32;
      }
      return path32.replace(/\\/g, "/");
    };
  }
});

// ../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/gitignore.js
var require_gitignore = __commonJS({
  "../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/gitignore.js"(exports2, module2) {
    "use strict";
    var { promisify: promisify12 } = require("util");
    var fs37 = require("fs");
    var path32 = require("path");
    var fastGlob = require_out4();
    var gitIgnore = require_ignore();
    var slash = require_slash();
    var DEFAULT_IGNORE = [
      "**/node_modules/**",
      "**/flow-typed/**",
      "**/coverage/**",
      "**/.git"
    ];
    var readFileP = promisify12(fs37.readFile);
    var mapGitIgnorePatternTo = /* @__PURE__ */ __name((base) => (ignore) => {
      if (ignore.startsWith("!")) {
        return "!" + path32.posix.join(base, ignore.slice(1));
      }
      return path32.posix.join(base, ignore);
    }, "mapGitIgnorePatternTo");
    var parseGitIgnore = /* @__PURE__ */ __name((content, options2) => {
      const base = slash(path32.relative(options2.cwd, path32.dirname(options2.fileName)));
      return content.split(/\r?\n/).filter(Boolean).filter((line) => !line.startsWith("#")).map(mapGitIgnorePatternTo(base));
    }, "parseGitIgnore");
    var reduceIgnore = /* @__PURE__ */ __name((files) => {
      const ignores = gitIgnore();
      for (const file2 of files) {
        ignores.add(parseGitIgnore(file2.content, {
          cwd: file2.cwd,
          fileName: file2.filePath
        }));
      }
      return ignores;
    }, "reduceIgnore");
    var ensureAbsolutePathForCwd = /* @__PURE__ */ __name((cwd, p3) => {
      cwd = slash(cwd);
      if (path32.isAbsolute(p3)) {
        if (slash(p3).startsWith(cwd)) {
          return p3;
        }
        throw new Error(`Path ${p3} is not in cwd ${cwd}`);
      }
      return path32.join(cwd, p3);
    }, "ensureAbsolutePathForCwd");
    var getIsIgnoredPredecate = /* @__PURE__ */ __name((ignores, cwd) => {
      return (p3) => ignores.ignores(slash(path32.relative(cwd, ensureAbsolutePathForCwd(cwd, p3.path || p3))));
    }, "getIsIgnoredPredecate");
    var getFile = /* @__PURE__ */ __name(async (file2, cwd) => {
      const filePath = path32.join(cwd, file2);
      const content = await readFileP(filePath, "utf8");
      return {
        cwd,
        filePath,
        content
      };
    }, "getFile");
    var getFileSync = /* @__PURE__ */ __name((file2, cwd) => {
      const filePath = path32.join(cwd, file2);
      const content = fs37.readFileSync(filePath, "utf8");
      return {
        cwd,
        filePath,
        content
      };
    }, "getFileSync");
    var normalizeOptions = /* @__PURE__ */ __name(({
      ignore = [],
      cwd = slash(process.cwd())
    } = {}) => {
      return { ignore, cwd };
    }, "normalizeOptions");
    module2.exports = async (options2) => {
      options2 = normalizeOptions(options2);
      const paths2 = await fastGlob("**/.gitignore", {
        ignore: DEFAULT_IGNORE.concat(options2.ignore),
        cwd: options2.cwd
      });
      const files = await Promise.all(paths2.map((file2) => getFile(file2, options2.cwd)));
      const ignores = reduceIgnore(files);
      return getIsIgnoredPredecate(ignores, options2.cwd);
    };
    module2.exports.sync = (options2) => {
      options2 = normalizeOptions(options2);
      const paths2 = fastGlob.sync("**/.gitignore", {
        ignore: DEFAULT_IGNORE.concat(options2.ignore),
        cwd: options2.cwd
      });
      const files = paths2.map((file2) => getFileSync(file2, options2.cwd));
      const ignores = reduceIgnore(files);
      return getIsIgnoredPredecate(ignores, options2.cwd);
    };
  }
});

// ../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/stream-utils.js
var require_stream_utils = __commonJS({
  "../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/stream-utils.js"(exports2, module2) {
    "use strict";
    var { Transform } = require("stream");
    var ObjectTransform = class extends Transform {
      constructor() {
        super({
          objectMode: true
        });
      }
    };
    __name(ObjectTransform, "ObjectTransform");
    var FilterStream = class extends ObjectTransform {
      constructor(filter2) {
        super();
        this._filter = filter2;
      }
      _transform(data, encoding, callback) {
        if (this._filter(data)) {
          this.push(data);
        }
        callback();
      }
    };
    __name(FilterStream, "FilterStream");
    var UniqueStream = class extends ObjectTransform {
      constructor() {
        super();
        this._pushed = /* @__PURE__ */ new Set();
      }
      _transform(data, encoding, callback) {
        if (!this._pushed.has(data)) {
          this.push(data);
          this._pushed.add(data);
        }
        callback();
      }
    };
    __name(UniqueStream, "UniqueStream");
    module2.exports = {
      FilterStream,
      UniqueStream
    };
  }
});

// ../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/index.js
var require_globby = __commonJS({
  "../../node_modules/.pnpm/globby@11.1.0/node_modules/globby/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var arrayUnion = require_array_union();
    var merge2 = require_merge2();
    var fastGlob = require_out4();
    var dirGlob = require_dir_glob();
    var gitignore = require_gitignore();
    var { FilterStream, UniqueStream } = require_stream_utils();
    var DEFAULT_FILTER = /* @__PURE__ */ __name(() => false, "DEFAULT_FILTER");
    var isNegative = /* @__PURE__ */ __name((pattern) => pattern[0] === "!", "isNegative");
    var assertPatternsInput = /* @__PURE__ */ __name((patterns) => {
      if (!patterns.every((pattern) => typeof pattern === "string")) {
        throw new TypeError("Patterns must be a string or an array of strings");
      }
    }, "assertPatternsInput");
    var checkCwdOption = /* @__PURE__ */ __name((options2 = {}) => {
      if (!options2.cwd) {
        return;
      }
      let stat2;
      try {
        stat2 = fs37.statSync(options2.cwd);
      } catch {
        return;
      }
      if (!stat2.isDirectory()) {
        throw new Error("The `cwd` option must be a path to a directory");
      }
    }, "checkCwdOption");
    var getPathString = /* @__PURE__ */ __name((p3) => p3.stats instanceof fs37.Stats ? p3.path : p3, "getPathString");
    var generateGlobTasks = /* @__PURE__ */ __name((patterns, taskOptions) => {
      patterns = arrayUnion([].concat(patterns));
      assertPatternsInput(patterns);
      checkCwdOption(taskOptions);
      const globTasks = [];
      taskOptions = {
        ignore: [],
        expandDirectories: true,
        ...taskOptions
      };
      for (const [index2, pattern] of patterns.entries()) {
        if (isNegative(pattern)) {
          continue;
        }
        const ignore = patterns.slice(index2).filter((pattern2) => isNegative(pattern2)).map((pattern2) => pattern2.slice(1));
        const options2 = {
          ...taskOptions,
          ignore: taskOptions.ignore.concat(ignore)
        };
        globTasks.push({ pattern, options: options2 });
      }
      return globTasks;
    }, "generateGlobTasks");
    var globDirs = /* @__PURE__ */ __name((task, fn2) => {
      let options2 = {};
      if (task.options.cwd) {
        options2.cwd = task.options.cwd;
      }
      if (Array.isArray(task.options.expandDirectories)) {
        options2 = {
          ...options2,
          files: task.options.expandDirectories
        };
      } else if (typeof task.options.expandDirectories === "object") {
        options2 = {
          ...options2,
          ...task.options.expandDirectories
        };
      }
      return fn2(task.pattern, options2);
    }, "globDirs");
    var getPattern = /* @__PURE__ */ __name((task, fn2) => task.options.expandDirectories ? globDirs(task, fn2) : [task.pattern], "getPattern");
    var getFilterSync = /* @__PURE__ */ __name((options2) => {
      return options2 && options2.gitignore ? gitignore.sync({ cwd: options2.cwd, ignore: options2.ignore }) : DEFAULT_FILTER;
    }, "getFilterSync");
    var globToTask = /* @__PURE__ */ __name((task) => (glob) => {
      const { options: options2 } = task;
      if (options2.ignore && Array.isArray(options2.ignore) && options2.expandDirectories) {
        options2.ignore = dirGlob.sync(options2.ignore);
      }
      return {
        pattern: glob,
        options: options2
      };
    }, "globToTask");
    module2.exports = async (patterns, options2) => {
      const globTasks = generateGlobTasks(patterns, options2);
      const getFilter = /* @__PURE__ */ __name(async () => {
        return options2 && options2.gitignore ? gitignore({ cwd: options2.cwd, ignore: options2.ignore }) : DEFAULT_FILTER;
      }, "getFilter");
      const getTasks = /* @__PURE__ */ __name(async () => {
        const tasks2 = await Promise.all(globTasks.map(async (task) => {
          const globs = await getPattern(task, dirGlob);
          return Promise.all(globs.map(globToTask(task)));
        }));
        return arrayUnion(...tasks2);
      }, "getTasks");
      const [filter2, tasks] = await Promise.all([getFilter(), getTasks()]);
      const paths2 = await Promise.all(tasks.map((task) => fastGlob(task.pattern, task.options)));
      return arrayUnion(...paths2).filter((path_) => !filter2(getPathString(path_)));
    };
    module2.exports.sync = (patterns, options2) => {
      const globTasks = generateGlobTasks(patterns, options2);
      const tasks = [];
      for (const task of globTasks) {
        const newTask = getPattern(task, dirGlob.sync).map(globToTask(task));
        tasks.push(...newTask);
      }
      const filter2 = getFilterSync(options2);
      let matches = [];
      for (const task of tasks) {
        matches = arrayUnion(matches, fastGlob.sync(task.pattern, task.options));
      }
      return matches.filter((path_) => !filter2(path_));
    };
    module2.exports.stream = (patterns, options2) => {
      const globTasks = generateGlobTasks(patterns, options2);
      const tasks = [];
      for (const task of globTasks) {
        const newTask = getPattern(task, dirGlob.sync).map(globToTask(task));
        tasks.push(...newTask);
      }
      const filter2 = getFilterSync(options2);
      const filterStream = new FilterStream((p3) => !filter2(p3));
      const uniqueStream = new UniqueStream();
      return merge2(tasks.map((task) => fastGlob.stream(task.pattern, task.options))).pipe(filterStream).pipe(uniqueStream);
    };
    module2.exports.generateGlobTasks = generateGlobTasks;
    module2.exports.hasMagic = (patterns, options2) => [].concat(patterns).some((pattern) => fastGlob.isDynamicPattern(pattern, options2));
    module2.exports.gitignore = gitignore;
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/polyfills.js"(exports2, module2) {
    var constants = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform2 = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d4) {
        cwd = null;
        chdir.call(process, d4);
      };
      if (Object.setPrototypeOf)
        Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs37) {
      if (constants.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs37);
      }
      if (!fs37.lutimes) {
        patchLutimes(fs37);
      }
      fs37.chown = chownFix(fs37.chown);
      fs37.fchown = chownFix(fs37.fchown);
      fs37.lchown = chownFix(fs37.lchown);
      fs37.chmod = chmodFix(fs37.chmod);
      fs37.fchmod = chmodFix(fs37.fchmod);
      fs37.lchmod = chmodFix(fs37.lchmod);
      fs37.chownSync = chownFixSync(fs37.chownSync);
      fs37.fchownSync = chownFixSync(fs37.fchownSync);
      fs37.lchownSync = chownFixSync(fs37.lchownSync);
      fs37.chmodSync = chmodFixSync(fs37.chmodSync);
      fs37.fchmodSync = chmodFixSync(fs37.fchmodSync);
      fs37.lchmodSync = chmodFixSync(fs37.lchmodSync);
      fs37.stat = statFix(fs37.stat);
      fs37.fstat = statFix(fs37.fstat);
      fs37.lstat = statFix(fs37.lstat);
      fs37.statSync = statFixSync(fs37.statSync);
      fs37.fstatSync = statFixSync(fs37.fstatSync);
      fs37.lstatSync = statFixSync(fs37.lstatSync);
      if (fs37.chmod && !fs37.lchmod) {
        fs37.lchmod = function(path32, mode, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs37.lchmodSync = function() {
        };
      }
      if (fs37.chown && !fs37.lchown) {
        fs37.lchown = function(path32, uid, gid, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs37.lchownSync = function() {
        };
      }
      if (platform2 === "win32") {
        fs37.rename = typeof fs37.rename !== "function" ? fs37.rename : function(fs$rename) {
          function rename2(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, /* @__PURE__ */ __name(function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs37.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb)
                cb(er);
            }, "CB"));
          }
          __name(rename2, "rename");
          if (Object.setPrototypeOf)
            Object.setPrototypeOf(rename2, fs$rename);
          return rename2;
        }(fs37.rename);
      }
      fs37.read = typeof fs37.read !== "function" ? fs37.read : function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = /* @__PURE__ */ __name(function(er, _2, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs37, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            }, "callback");
          }
          return fs$read.call(fs37, fd, buffer, offset, length, position, callback);
        }
        __name(read, "read");
        if (Object.setPrototypeOf)
          Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs37.read);
      fs37.readSync = typeof fs37.readSync !== "function" ? fs37.readSync : function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs37, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs37.readSync);
      function patchLchmod(fs38) {
        fs38.lchmod = function(path32, mode, callback) {
          fs38.open(
            path32,
            constants.O_WRONLY | constants.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback)
                  callback(err);
                return;
              }
              fs38.fchmod(fd, mode, function(err2) {
                fs38.close(fd, function(err22) {
                  if (callback)
                    callback(err2 || err22);
                });
              });
            }
          );
        };
        fs38.lchmodSync = function(path32, mode) {
          var fd = fs38.openSync(path32, constants.O_WRONLY | constants.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs38.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs38.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs38.closeSync(fd);
            }
          }
          return ret;
        };
      }
      __name(patchLchmod, "patchLchmod");
      function patchLutimes(fs38) {
        if (constants.hasOwnProperty("O_SYMLINK") && fs38.futimes) {
          fs38.lutimes = function(path32, at, mt, cb) {
            fs38.open(path32, constants.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb)
                  cb(er);
                return;
              }
              fs38.futimes(fd, at, mt, function(er2) {
                fs38.close(fd, function(er22) {
                  if (cb)
                    cb(er2 || er22);
                });
              });
            });
          };
          fs38.lutimesSync = function(path32, at, mt) {
            var fd = fs38.openSync(path32, constants.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs38.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs38.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs38.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs38.futimes) {
          fs38.lutimes = function(_a, _b, _c, cb) {
            if (cb)
              process.nextTick(cb);
          };
          fs38.lutimesSync = function() {
          };
        }
      }
      __name(patchLutimes, "patchLutimes");
      function chmodFix(orig) {
        if (!orig)
          return orig;
        return function(target, mode, cb) {
          return orig.call(fs37, target, mode, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      __name(chmodFix, "chmodFix");
      function chmodFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, mode) {
          try {
            return orig.call(fs37, target, mode);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      __name(chmodFixSync, "chmodFixSync");
      function chownFix(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs37, target, uid, gid, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      __name(chownFix, "chownFix");
      function chownFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs37, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      __name(chownFixSync, "chownFixSync");
      function statFix(orig) {
        if (!orig)
          return orig;
        return function(target, options2, cb) {
          if (typeof options2 === "function") {
            cb = options2;
            options2 = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0)
                stats.uid += 4294967296;
              if (stats.gid < 0)
                stats.gid += 4294967296;
            }
            if (cb)
              cb.apply(this, arguments);
          }
          __name(callback, "callback");
          return options2 ? orig.call(fs37, target, options2, callback) : orig.call(fs37, target, callback);
        };
      }
      __name(statFix, "statFix");
      function statFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, options2) {
          var stats = options2 ? orig.call(fs37, target, options2) : orig.call(fs37, target);
          if (stats) {
            if (stats.uid < 0)
              stats.uid += 4294967296;
            if (stats.gid < 0)
              stats.gid += 4294967296;
          }
          return stats;
        };
      }
      __name(statFixSync, "statFixSync");
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
      __name(chownErOk, "chownErOk");
    }
    __name(patch, "patch");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/legacy-streams.js"(exports2, module2) {
    var Stream2 = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs37) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path32, options2) {
        if (!(this instanceof ReadStream))
          return new ReadStream(path32, options2);
        Stream2.call(this);
        var self2 = this;
        this.path = path32;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options2 = options2 || {};
        var keys = Object.keys(options2);
        for (var index2 = 0, length = keys.length; index2 < length; index2++) {
          var key = keys[index2];
          this[key] = options2[key];
        }
        if (this.encoding)
          this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self2._read();
          });
          return;
        }
        fs37.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self2.emit("error", err);
            self2.readable = false;
            return;
          }
          self2.fd = fd;
          self2.emit("open", fd);
          self2._read();
        });
      }
      __name(ReadStream, "ReadStream");
      function WriteStream(path32, options2) {
        if (!(this instanceof WriteStream))
          return new WriteStream(path32, options2);
        Stream2.call(this);
        this.path = path32;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options2 = options2 || {};
        var keys = Object.keys(options2);
        for (var index2 = 0, length = keys.length; index2 < length; index2++) {
          var key = keys[index2];
          this[key] = options2[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs37.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
      __name(WriteStream, "WriteStream");
    }
    __name(legacy, "legacy");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/clone.js"(exports2, module2) {
    "use strict";
    module2.exports = clone2;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone2(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
    __name(clone2, "clone");
  }
});

// ../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "../../node_modules/.pnpm/graceful-fs@4.2.10/node_modules/graceful-fs/graceful-fs.js"(exports2, module2) {
    var fs37 = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone2 = require_clone();
    var util4 = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    __name(noop, "noop");
    function publishQueue(context, queue3) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue3;
        }
      });
    }
    __name(publishQueue, "publishQueue");
    var debug27 = noop;
    if (util4.debuglog)
      debug27 = util4.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug27 = /* @__PURE__ */ __name(function() {
        var m4 = util4.format.apply(util4, arguments);
        m4 = "GFS4: " + m4.split(/\n/).join("\nGFS4: ");
        console.error(m4);
      }, "debug");
    if (!fs37[gracefulQueue]) {
      queue2 = global[gracefulQueue] || [];
      publishQueue(fs37, queue2);
      fs37.close = function(fs$close) {
        function close2(fd, cb) {
          return fs$close.call(fs37, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        __name(close2, "close");
        Object.defineProperty(close2, previousSymbol, {
          value: fs$close
        });
        return close2;
      }(fs37.close);
      fs37.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs37, arguments);
          resetQueue();
        }
        __name(closeSync, "closeSync");
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs37.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug27(fs37[gracefulQueue]);
          require("assert").equal(fs37[gracefulQueue].length, 0);
        });
      }
    }
    var queue2;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs37[gracefulQueue]);
    }
    module2.exports = patch(clone2(fs37));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs37.__patched) {
      module2.exports = patch(fs37);
      fs37.__patched = true;
    }
    function patch(fs38) {
      polyfills(fs38);
      fs38.gracefulify = patch;
      fs38.createReadStream = createReadStream;
      fs38.createWriteStream = createWriteStream;
      var fs$readFile = fs38.readFile;
      fs38.readFile = readFile7;
      function readFile7(path32, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$readFile(path32, options2, cb);
        function go$readFile(path33, options3, cb2, startTime) {
          return fs$readFile(path33, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path33, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$readFile, "go$readFile");
      }
      __name(readFile7, "readFile");
      var fs$writeFile = fs38.writeFile;
      fs38.writeFile = writeFile4;
      function writeFile4(path32, data, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$writeFile(path32, data, options2, cb);
        function go$writeFile(path33, data2, options3, cb2, startTime) {
          return fs$writeFile(path33, data2, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path33, data2, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$writeFile, "go$writeFile");
      }
      __name(writeFile4, "writeFile");
      var fs$appendFile = fs38.appendFile;
      if (fs$appendFile)
        fs38.appendFile = appendFile;
      function appendFile(path32, data, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        return go$appendFile(path32, data, options2, cb);
        function go$appendFile(path33, data2, options3, cb2, startTime) {
          return fs$appendFile(path33, data2, options3, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path33, data2, options3, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$appendFile, "go$appendFile");
      }
      __name(appendFile, "appendFile");
      var fs$copyFile = fs38.copyFile;
      if (fs$copyFile)
        fs38.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$copyFile, "go$copyFile");
      }
      __name(copyFile, "copyFile");
      var fs$readdir = fs38.readdir;
      fs38.readdir = readdir3;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir3(path32, options2, cb) {
        if (typeof options2 === "function")
          cb = options2, options2 = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? /* @__PURE__ */ __name(function go$readdir2(path33, options3, cb2, startTime) {
          return fs$readdir(path33, fs$readdirCallback(
            path33,
            options3,
            cb2,
            startTime
          ));
        }, "go$readdir") : /* @__PURE__ */ __name(function go$readdir2(path33, options3, cb2, startTime) {
          return fs$readdir(path33, options3, fs$readdirCallback(
            path33,
            options3,
            cb2,
            startTime
          ));
        }, "go$readdir");
        return go$readdir(path32, options2, cb);
        function fs$readdirCallback(path33, options3, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path33, options3, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
        __name(fs$readdirCallback, "fs$readdirCallback");
      }
      __name(readdir3, "readdir");
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs38);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs38.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs38.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs38, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val) {
          ReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs38, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val) {
          WriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs38, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val) {
          FileReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs38, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val) {
          FileWriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path32, options2) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      __name(ReadStream, "ReadStream");
      function ReadStream$open() {
        var that = this;
        open4(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      __name(ReadStream$open, "ReadStream$open");
      function WriteStream(path32, options2) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      __name(WriteStream, "WriteStream");
      function WriteStream$open() {
        var that = this;
        open4(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      __name(WriteStream$open, "WriteStream$open");
      function createReadStream(path32, options2) {
        return new fs38.ReadStream(path32, options2);
      }
      __name(createReadStream, "createReadStream");
      function createWriteStream(path32, options2) {
        return new fs38.WriteStream(path32, options2);
      }
      __name(createWriteStream, "createWriteStream");
      var fs$open = fs38.open;
      fs38.open = open4;
      function open4(path32, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path32, flags, mode, cb);
        function go$open(path33, flags2, mode2, cb2, startTime) {
          return fs$open(path33, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path33, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
        __name(go$open, "go$open");
      }
      __name(open4, "open");
      return fs38;
    }
    __name(patch, "patch");
    function enqueue(elem) {
      debug27("ENQUEUE", elem[0].name, elem[1]);
      fs37[gracefulQueue].push(elem);
      retry3();
    }
    __name(enqueue, "enqueue");
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i3 = 0; i3 < fs37[gracefulQueue].length; ++i3) {
        if (fs37[gracefulQueue][i3].length > 2) {
          fs37[gracefulQueue][i3][3] = now;
          fs37[gracefulQueue][i3][4] = now;
        }
      }
      retry3();
    }
    __name(resetQueue, "resetQueue");
    function retry3() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs37[gracefulQueue].length === 0)
        return;
      var elem = fs37[gracefulQueue].shift();
      var fn2 = elem[0];
      var args3 = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug27("RETRY", fn2.name, args3);
        fn2.apply(null, args3);
      } else if (Date.now() - startTime >= 6e4) {
        debug27("TIMEOUT", fn2.name, args3);
        var cb = args3.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug27("RETRY", fn2.name, args3);
          fn2.apply(null, args3.concat([startTime]));
        } else {
          fs37[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry3, 0);
      }
    }
    __name(retry3, "retry");
  }
});

// ../../node_modules/.pnpm/is-path-cwd@2.2.0/node_modules/is-path-cwd/index.js
var require_is_path_cwd = __commonJS({
  "../../node_modules/.pnpm/is-path-cwd@2.2.0/node_modules/is-path-cwd/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    module2.exports = (path_) => {
      let cwd = process.cwd();
      path_ = path32.resolve(path_);
      if (process.platform === "win32") {
        cwd = cwd.toLowerCase();
        path_ = path_.toLowerCase();
      }
      return path_ === cwd;
    };
  }
});

// ../../node_modules/.pnpm/is-path-inside@3.0.3/node_modules/is-path-inside/index.js
var require_is_path_inside = __commonJS({
  "../../node_modules/.pnpm/is-path-inside@3.0.3/node_modules/is-path-inside/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    module2.exports = (childPath2, parentPath) => {
      const relation = path32.relative(parentPath, childPath2);
      return Boolean(
        relation && relation !== ".." && !relation.startsWith(`..${path32.sep}`) && relation !== path32.resolve(childPath2)
      );
    };
  }
});

// ../../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/old.js
var require_old = __commonJS({
  "../../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/old.js"(exports2) {
    var pathModule = require("path");
    var isWindows2 = process.platform === "win32";
    var fs37 = require("fs");
    var DEBUG = process.env.NODE_DEBUG && /fs/.test(process.env.NODE_DEBUG);
    function rethrow() {
      var callback;
      if (DEBUG) {
        var backtrace = new Error();
        callback = debugCallback;
      } else
        callback = missingCallback;
      return callback;
      function debugCallback(err) {
        if (err) {
          backtrace.message = err.message;
          err = backtrace;
          missingCallback(err);
        }
      }
      __name(debugCallback, "debugCallback");
      function missingCallback(err) {
        if (err) {
          if (process.throwDeprecation)
            throw err;
          else if (!process.noDeprecation) {
            var msg = "fs: missing callback " + (err.stack || err.message);
            if (process.traceDeprecation)
              console.trace(msg);
            else
              console.error(msg);
          }
        }
      }
      __name(missingCallback, "missingCallback");
    }
    __name(rethrow, "rethrow");
    function maybeCallback(cb) {
      return typeof cb === "function" ? cb : rethrow();
    }
    __name(maybeCallback, "maybeCallback");
    var normalize = pathModule.normalize;
    if (isWindows2) {
      nextPartRe = /(.*?)(?:[\/\\]+|$)/g;
    } else {
      nextPartRe = /(.*?)(?:[\/]+|$)/g;
    }
    var nextPartRe;
    if (isWindows2) {
      splitRootRe = /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/;
    } else {
      splitRootRe = /^[\/]*/;
    }
    var splitRootRe;
    exports2.realpathSync = /* @__PURE__ */ __name(function realpathSync(p3, cache) {
      p3 = pathModule.resolve(p3);
      if (cache && Object.prototype.hasOwnProperty.call(cache, p3)) {
        return cache[p3];
      }
      var original = p3, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start();
      function start() {
        var m4 = splitRootRe.exec(p3);
        pos = m4[0].length;
        current = m4[0];
        base = m4[0];
        previous = "";
        if (isWindows2 && !knownHard[base]) {
          fs37.lstatSync(base);
          knownHard[base] = true;
        }
      }
      __name(start, "start");
      while (pos < p3.length) {
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p3);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache && cache[base] === base) {
          continue;
        }
        var resolvedLink;
        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          resolvedLink = cache[base];
        } else {
          var stat2 = fs37.lstatSync(base);
          if (!stat2.isSymbolicLink()) {
            knownHard[base] = true;
            if (cache)
              cache[base] = base;
            continue;
          }
          var linkTarget = null;
          if (!isWindows2) {
            var id = stat2.dev.toString(32) + ":" + stat2.ino.toString(32);
            if (seenLinks.hasOwnProperty(id)) {
              linkTarget = seenLinks[id];
            }
          }
          if (linkTarget === null) {
            fs37.statSync(base);
            linkTarget = fs37.readlinkSync(base);
          }
          resolvedLink = pathModule.resolve(previous, linkTarget);
          if (cache)
            cache[base] = resolvedLink;
          if (!isWindows2)
            seenLinks[id] = linkTarget;
        }
        p3 = pathModule.resolve(resolvedLink, p3.slice(pos));
        start();
      }
      if (cache)
        cache[original] = p3;
      return p3;
    }, "realpathSync");
    exports2.realpath = /* @__PURE__ */ __name(function realpath(p3, cache, cb) {
      if (typeof cb !== "function") {
        cb = maybeCallback(cache);
        cache = null;
      }
      p3 = pathModule.resolve(p3);
      if (cache && Object.prototype.hasOwnProperty.call(cache, p3)) {
        return process.nextTick(cb.bind(null, null, cache[p3]));
      }
      var original = p3, seenLinks = {}, knownHard = {};
      var pos;
      var current;
      var base;
      var previous;
      start();
      function start() {
        var m4 = splitRootRe.exec(p3);
        pos = m4[0].length;
        current = m4[0];
        base = m4[0];
        previous = "";
        if (isWindows2 && !knownHard[base]) {
          fs37.lstat(base, function(err) {
            if (err)
              return cb(err);
            knownHard[base] = true;
            LOOP();
          });
        } else {
          process.nextTick(LOOP);
        }
      }
      __name(start, "start");
      function LOOP() {
        if (pos >= p3.length) {
          if (cache)
            cache[original] = p3;
          return cb(null, p3);
        }
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p3);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;
        if (knownHard[base] || cache && cache[base] === base) {
          return process.nextTick(LOOP);
        }
        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          return gotResolvedLink(cache[base]);
        }
        return fs37.lstat(base, gotStat);
      }
      __name(LOOP, "LOOP");
      function gotStat(err, stat2) {
        if (err)
          return cb(err);
        if (!stat2.isSymbolicLink()) {
          knownHard[base] = true;
          if (cache)
            cache[base] = base;
          return process.nextTick(LOOP);
        }
        if (!isWindows2) {
          var id = stat2.dev.toString(32) + ":" + stat2.ino.toString(32);
          if (seenLinks.hasOwnProperty(id)) {
            return gotTarget(null, seenLinks[id], base);
          }
        }
        fs37.stat(base, function(err2) {
          if (err2)
            return cb(err2);
          fs37.readlink(base, function(err3, target) {
            if (!isWindows2)
              seenLinks[id] = target;
            gotTarget(err3, target);
          });
        });
      }
      __name(gotStat, "gotStat");
      function gotTarget(err, target, base2) {
        if (err)
          return cb(err);
        var resolvedLink = pathModule.resolve(previous, target);
        if (cache)
          cache[base2] = resolvedLink;
        gotResolvedLink(resolvedLink);
      }
      __name(gotTarget, "gotTarget");
      function gotResolvedLink(resolvedLink) {
        p3 = pathModule.resolve(resolvedLink, p3.slice(pos));
        start();
      }
      __name(gotResolvedLink, "gotResolvedLink");
    }, "realpath");
  }
});

// ../../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/index.js
var require_fs5 = __commonJS({
  "../../node_modules/.pnpm/fs.realpath@1.0.0/node_modules/fs.realpath/index.js"(exports2, module2) {
    module2.exports = realpath;
    realpath.realpath = realpath;
    realpath.sync = realpathSync;
    realpath.realpathSync = realpathSync;
    realpath.monkeypatch = monkeypatch;
    realpath.unmonkeypatch = unmonkeypatch;
    var fs37 = require("fs");
    var origRealpath = fs37.realpath;
    var origRealpathSync = fs37.realpathSync;
    var version3 = process.version;
    var ok = /^v[0-5]\./.test(version3);
    var old = require_old();
    function newError(er) {
      return er && er.syscall === "realpath" && (er.code === "ELOOP" || er.code === "ENOMEM" || er.code === "ENAMETOOLONG");
    }
    __name(newError, "newError");
    function realpath(p3, cache, cb) {
      if (ok) {
        return origRealpath(p3, cache, cb);
      }
      if (typeof cache === "function") {
        cb = cache;
        cache = null;
      }
      origRealpath(p3, cache, function(er, result) {
        if (newError(er)) {
          old.realpath(p3, cache, cb);
        } else {
          cb(er, result);
        }
      });
    }
    __name(realpath, "realpath");
    function realpathSync(p3, cache) {
      if (ok) {
        return origRealpathSync(p3, cache);
      }
      try {
        return origRealpathSync(p3, cache);
      } catch (er) {
        if (newError(er)) {
          return old.realpathSync(p3, cache);
        } else {
          throw er;
        }
      }
    }
    __name(realpathSync, "realpathSync");
    function monkeypatch() {
      fs37.realpath = realpath;
      fs37.realpathSync = realpathSync;
    }
    __name(monkeypatch, "monkeypatch");
    function unmonkeypatch() {
      fs37.realpath = origRealpath;
      fs37.realpathSync = origRealpathSync;
    }
    __name(unmonkeypatch, "unmonkeypatch");
  }
});

// ../../node_modules/.pnpm/concat-map@0.0.1/node_modules/concat-map/index.js
var require_concat_map = __commonJS({
  "../../node_modules/.pnpm/concat-map@0.0.1/node_modules/concat-map/index.js"(exports2, module2) {
    module2.exports = function(xs, fn2) {
      var res = [];
      for (var i3 = 0; i3 < xs.length; i3++) {
        var x = fn2(xs[i3], i3);
        if (isArray(x))
          res.push.apply(res, x);
        else
          res.push(x);
      }
      return res;
    };
    var isArray = Array.isArray || function(xs) {
      return Object.prototype.toString.call(xs) === "[object Array]";
    };
  }
});

// ../../node_modules/.pnpm/balanced-match@1.0.2/node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "../../node_modules/.pnpm/balanced-match@1.0.2/node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a3, b3, str) {
      if (a3 instanceof RegExp)
        a3 = maybeMatch(a3, str);
      if (b3 instanceof RegExp)
        b3 = maybeMatch(b3, str);
      var r3 = range2(a3, b3, str);
      return r3 && {
        start: r3[0],
        end: r3[1],
        pre: str.slice(0, r3[0]),
        body: str.slice(r3[0] + a3.length, r3[1]),
        post: str.slice(r3[1] + b3.length)
      };
    }
    __name(balanced, "balanced");
    function maybeMatch(reg, str) {
      var m4 = str.match(reg);
      return m4 ? m4[0] : null;
    }
    __name(maybeMatch, "maybeMatch");
    balanced.range = range2;
    function range2(a3, b3, str) {
      var begs, beg, left4, right5, result;
      var ai = str.indexOf(a3);
      var bi = str.indexOf(b3, ai + 1);
      var i3 = ai;
      if (ai >= 0 && bi > 0) {
        if (a3 === b3) {
          return [ai, bi];
        }
        begs = [];
        left4 = str.length;
        while (i3 >= 0 && !result) {
          if (i3 == ai) {
            begs.push(i3);
            ai = str.indexOf(a3, i3 + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left4) {
              left4 = beg;
              right5 = bi;
            }
            bi = str.indexOf(b3, i3 + 1);
          }
          i3 = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left4, right5];
        }
      }
      return result;
    }
    __name(range2, "range");
  }
});

// ../../node_modules/.pnpm/brace-expansion@1.1.11/node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "../../node_modules/.pnpm/brace-expansion@1.1.11/node_modules/brace-expansion/index.js"(exports2, module2) {
    var concatMap = require_concat_map();
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    __name(numeric, "numeric");
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    __name(escapeBraces, "escapeBraces");
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    __name(unescapeBraces, "unescapeBraces");
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m4 = balanced("{", "}", str);
      if (!m4)
        return str.split(",");
      var pre = m4.pre;
      var body = m4.body;
      var post = m4.post;
      var p3 = pre.split(",");
      p3[p3.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p3[p3.length - 1] += postParts.shift();
        p3.push.apply(p3, postParts);
      }
      parts.push.apply(parts, p3);
      return parts;
    }
    __name(parseCommaParts, "parseCommaParts");
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand(escapeBraces(str), true).map(unescapeBraces);
    }
    __name(expandTop, "expandTop");
    function embrace(str) {
      return "{" + str + "}";
    }
    __name(embrace, "embrace");
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    __name(isPadded, "isPadded");
    function lte(i3, y4) {
      return i3 <= y4;
    }
    __name(lte, "lte");
    function gte(i3, y4) {
      return i3 >= y4;
    }
    __name(gte, "gte");
    function expand(str, isTop) {
      var expansions = [];
      var m4 = balanced("{", "}", str);
      if (!m4 || /\$$/.test(m4.pre))
        return [str];
      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m4.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m4.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m4.body.indexOf(",") >= 0;
      if (!isSequence && !isOptions) {
        if (m4.post.match(/,.*\}/)) {
          str = m4.pre + "{" + m4.body + escClose + m4.post;
          return expand(str);
        }
        return [str];
      }
      var n3;
      if (isSequence) {
        n3 = m4.body.split(/\.\./);
      } else {
        n3 = parseCommaParts(m4.body);
        if (n3.length === 1) {
          n3 = expand(n3[0], false).map(embrace);
          if (n3.length === 1) {
            var post = m4.post.length ? expand(m4.post, false) : [""];
            return post.map(function(p3) {
              return m4.pre + n3[0] + p3;
            });
          }
        }
      }
      var pre = m4.pre;
      var post = m4.post.length ? expand(m4.post, false) : [""];
      var N;
      if (isSequence) {
        var x = numeric(n3[0]);
        var y4 = numeric(n3[1]);
        var width = Math.max(n3[0].length, n3[1].length);
        var incr = n3.length == 3 ? Math.abs(numeric(n3[2])) : 1;
        var test = lte;
        var reverse = y4 < x;
        if (reverse) {
          incr *= -1;
          test = gte;
        }
        var pad = n3.some(isPadded);
        N = [];
        for (var i3 = x; test(i3, y4); i3 += incr) {
          var c3;
          if (isAlphaSequence) {
            c3 = String.fromCharCode(i3);
            if (c3 === "\\")
              c3 = "";
          } else {
            c3 = String(i3);
            if (pad) {
              var need = width - c3.length;
              if (need > 0) {
                var z = new Array(need + 1).join("0");
                if (i3 < 0)
                  c3 = "-" + z + c3.slice(1);
                else
                  c3 = z + c3;
              }
            }
          }
          N.push(c3);
        }
      } else {
        N = concatMap(n3, function(el) {
          return expand(el, false);
        });
      }
      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }
      return expansions;
    }
    __name(expand, "expand");
  }
});

// ../../node_modules/.pnpm/minimatch@3.1.2/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "../../node_modules/.pnpm/minimatch@3.1.2/node_modules/minimatch/minimatch.js"(exports2, module2) {
    module2.exports = minimatch;
    minimatch.Minimatch = Minimatch;
    var path32 = function() {
      try {
        return require("path");
      } catch (e3) {
      }
    }() || {
      sep: "/"
    };
    minimatch.sep = path32.sep;
    var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};
    var expand = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var reSpecials = charSet("().*{}+?[]^$\\!");
    function charSet(s4) {
      return s4.split("").reduce(function(set, c3) {
        set[c3] = true;
        return set;
      }, {});
    }
    __name(charSet, "charSet");
    var slashSplit = /\/+/;
    minimatch.filter = filter2;
    function filter2(pattern, options2) {
      options2 = options2 || {};
      return function(p3, i3, list) {
        return minimatch(p3, pattern, options2);
      };
    }
    __name(filter2, "filter");
    function ext(a3, b3) {
      b3 = b3 || {};
      var t5 = {};
      Object.keys(a3).forEach(function(k) {
        t5[k] = a3[k];
      });
      Object.keys(b3).forEach(function(k) {
        t5[k] = b3[k];
      });
      return t5;
    }
    __name(ext, "ext");
    minimatch.defaults = function(def) {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch;
      }
      var orig = minimatch;
      var m4 = /* @__PURE__ */ __name(function minimatch2(p3, pattern, options2) {
        return orig(p3, pattern, ext(def, options2));
      }, "minimatch");
      m4.Minimatch = /* @__PURE__ */ __name(function Minimatch2(pattern, options2) {
        return new orig.Minimatch(pattern, ext(def, options2));
      }, "Minimatch");
      m4.Minimatch.defaults = /* @__PURE__ */ __name(function defaults(options2) {
        return orig.defaults(ext(def, options2)).Minimatch;
      }, "defaults");
      m4.filter = /* @__PURE__ */ __name(function filter3(pattern, options2) {
        return orig.filter(pattern, ext(def, options2));
      }, "filter");
      m4.defaults = /* @__PURE__ */ __name(function defaults(options2) {
        return orig.defaults(ext(def, options2));
      }, "defaults");
      m4.makeRe = /* @__PURE__ */ __name(function makeRe2(pattern, options2) {
        return orig.makeRe(pattern, ext(def, options2));
      }, "makeRe");
      m4.braceExpand = /* @__PURE__ */ __name(function braceExpand2(pattern, options2) {
        return orig.braceExpand(pattern, ext(def, options2));
      }, "braceExpand");
      m4.match = function(list, pattern, options2) {
        return orig.match(list, pattern, ext(def, options2));
      };
      return m4;
    };
    Minimatch.defaults = function(def) {
      return minimatch.defaults(def).Minimatch;
    };
    function minimatch(p3, pattern, options2) {
      assertValidPattern(pattern);
      if (!options2)
        options2 = {};
      if (!options2.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options2).match(p3);
    }
    __name(minimatch, "minimatch");
    function Minimatch(pattern, options2) {
      if (!(this instanceof Minimatch)) {
        return new Minimatch(pattern, options2);
      }
      assertValidPattern(pattern);
      if (!options2)
        options2 = {};
      pattern = pattern.trim();
      if (!options2.allowWindowsEscape && path32.sep !== "/") {
        pattern = pattern.split(path32.sep).join("/");
      }
      this.options = options2;
      this.set = [];
      this.pattern = pattern;
      this.regexp = null;
      this.negate = false;
      this.comment = false;
      this.empty = false;
      this.partial = !!options2.partial;
      this.make();
    }
    __name(Minimatch, "Minimatch");
    Minimatch.prototype.debug = function() {
    };
    Minimatch.prototype.make = make;
    function make() {
      var pattern = this.pattern;
      var options2 = this.options;
      if (!options2.nocomment && pattern.charAt(0) === "#") {
        this.comment = true;
        return;
      }
      if (!pattern) {
        this.empty = true;
        return;
      }
      this.parseNegate();
      var set = this.globSet = this.braceExpand();
      if (options2.debug)
        this.debug = /* @__PURE__ */ __name(function debug27() {
          console.error.apply(console, arguments);
        }, "debug");
      this.debug(this.pattern, set);
      set = this.globParts = set.map(function(s4) {
        return s4.split(slashSplit);
      });
      this.debug(this.pattern, set);
      set = set.map(function(s4, si, set2) {
        return s4.map(this.parse, this);
      }, this);
      this.debug(this.pattern, set);
      set = set.filter(function(s4) {
        return s4.indexOf(false) === -1;
      });
      this.debug(this.pattern, set);
      this.set = set;
    }
    __name(make, "make");
    Minimatch.prototype.parseNegate = parseNegate;
    function parseNegate() {
      var pattern = this.pattern;
      var negate = false;
      var options2 = this.options;
      var negateOffset = 0;
      if (options2.nonegate)
        return;
      for (var i3 = 0, l3 = pattern.length; i3 < l3 && pattern.charAt(i3) === "!"; i3++) {
        negate = !negate;
        negateOffset++;
      }
      if (negateOffset)
        this.pattern = pattern.substr(negateOffset);
      this.negate = negate;
    }
    __name(parseNegate, "parseNegate");
    minimatch.braceExpand = function(pattern, options2) {
      return braceExpand(pattern, options2);
    };
    Minimatch.prototype.braceExpand = braceExpand;
    function braceExpand(pattern, options2) {
      if (!options2) {
        if (this instanceof Minimatch) {
          options2 = this.options;
        } else {
          options2 = {};
        }
      }
      pattern = typeof pattern === "undefined" ? this.pattern : pattern;
      assertValidPattern(pattern);
      if (options2.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand(pattern);
    }
    __name(braceExpand, "braceExpand");
    var MAX_PATTERN_LENGTH = 1024 * 64;
    var assertValidPattern = /* @__PURE__ */ __name(function(pattern) {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    }, "assertValidPattern");
    Minimatch.prototype.parse = parse2;
    var SUBPARSE = {};
    function parse2(pattern, isSub) {
      assertValidPattern(pattern);
      var options2 = this.options;
      if (pattern === "**") {
        if (!options2.noglobstar)
          return GLOBSTAR;
        else
          pattern = "*";
      }
      if (pattern === "")
        return "";
      var re = "";
      var hasMagic = !!options2.nocase;
      var escaping = false;
      var patternListStack = [];
      var negativeLists = [];
      var stateChar;
      var inClass = false;
      var reClassStart = -1;
      var classStart = -1;
      var patternStart = pattern.charAt(0) === "." ? "" : options2.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
      var self2 = this;
      function clearStateChar() {
        if (stateChar) {
          switch (stateChar) {
            case "*":
              re += star;
              hasMagic = true;
              break;
            case "?":
              re += qmark;
              hasMagic = true;
              break;
            default:
              re += "\\" + stateChar;
              break;
          }
          self2.debug("clearStateChar %j %j", stateChar, re);
          stateChar = false;
        }
      }
      __name(clearStateChar, "clearStateChar");
      for (var i3 = 0, len = pattern.length, c3; i3 < len && (c3 = pattern.charAt(i3)); i3++) {
        this.debug("%s	%s %s %j", pattern, i3, re, c3);
        if (escaping && reSpecials[c3]) {
          re += "\\" + c3;
          escaping = false;
          continue;
        }
        switch (c3) {
          case "/": {
            return false;
          }
          case "\\":
            clearStateChar();
            escaping = true;
            continue;
          case "?":
          case "*":
          case "+":
          case "@":
          case "!":
            this.debug("%s	%s %s %j <-- stateChar", pattern, i3, re, c3);
            if (inClass) {
              this.debug("  in class");
              if (c3 === "!" && i3 === classStart + 1)
                c3 = "^";
              re += c3;
              continue;
            }
            self2.debug("call clearStateChar %j", stateChar);
            clearStateChar();
            stateChar = c3;
            if (options2.noext)
              clearStateChar();
            continue;
          case "(":
            if (inClass) {
              re += "(";
              continue;
            }
            if (!stateChar) {
              re += "\\(";
              continue;
            }
            patternListStack.push({
              type: stateChar,
              start: i3 - 1,
              reStart: re.length,
              open: plTypes[stateChar].open,
              close: plTypes[stateChar].close
            });
            re += stateChar === "!" ? "(?:(?!(?:" : "(?:";
            this.debug("plType %j %j", stateChar, re);
            stateChar = false;
            continue;
          case ")":
            if (inClass || !patternListStack.length) {
              re += "\\)";
              continue;
            }
            clearStateChar();
            hasMagic = true;
            var pl = patternListStack.pop();
            re += pl.close;
            if (pl.type === "!") {
              negativeLists.push(pl);
            }
            pl.reEnd = re.length;
            continue;
          case "|":
            if (inClass || !patternListStack.length || escaping) {
              re += "\\|";
              escaping = false;
              continue;
            }
            clearStateChar();
            re += "|";
            continue;
          case "[":
            clearStateChar();
            if (inClass) {
              re += "\\" + c3;
              continue;
            }
            inClass = true;
            classStart = i3;
            reClassStart = re.length;
            re += c3;
            continue;
          case "]":
            if (i3 === classStart + 1 || !inClass) {
              re += "\\" + c3;
              escaping = false;
              continue;
            }
            var cs = pattern.substring(classStart + 1, i3);
            try {
              RegExp("[" + cs + "]");
            } catch (er) {
              var sp = this.parse(cs, SUBPARSE);
              re = re.substr(0, reClassStart) + "\\[" + sp[0] + "\\]";
              hasMagic = hasMagic || sp[1];
              inClass = false;
              continue;
            }
            hasMagic = true;
            inClass = false;
            re += c3;
            continue;
          default:
            clearStateChar();
            if (escaping) {
              escaping = false;
            } else if (reSpecials[c3] && !(c3 === "^" && inClass)) {
              re += "\\";
            }
            re += c3;
        }
      }
      if (inClass) {
        cs = pattern.substr(classStart + 1);
        sp = this.parse(cs, SUBPARSE);
        re = re.substr(0, reClassStart) + "\\[" + sp[0];
        hasMagic = hasMagic || sp[1];
      }
      for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
        var tail2 = re.slice(pl.reStart + pl.open.length);
        this.debug("setting tail", re, pl);
        tail2 = tail2.replace(/((?:\\{2}){0,64})(\\?)\|/g, function(_2, $1, $2) {
          if (!$2) {
            $2 = "\\";
          }
          return $1 + $1 + $2 + "|";
        });
        this.debug("tail=%j\n   %s", tail2, tail2, pl, re);
        var t5 = pl.type === "*" ? star : pl.type === "?" ? qmark : "\\" + pl.type;
        hasMagic = true;
        re = re.slice(0, pl.reStart) + t5 + "\\(" + tail2;
      }
      clearStateChar();
      if (escaping) {
        re += "\\\\";
      }
      var addPatternStart = false;
      switch (re.charAt(0)) {
        case "[":
        case ".":
        case "(":
          addPatternStart = true;
      }
      for (var n3 = negativeLists.length - 1; n3 > -1; n3--) {
        var nl = negativeLists[n3];
        var nlBefore = re.slice(0, nl.reStart);
        var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
        var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
        var nlAfter = re.slice(nl.reEnd);
        nlLast += nlAfter;
        var openParensBefore = nlBefore.split("(").length - 1;
        var cleanAfter = nlAfter;
        for (i3 = 0; i3 < openParensBefore; i3++) {
          cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
        }
        nlAfter = cleanAfter;
        var dollar = "";
        if (nlAfter === "" && isSub !== SUBPARSE) {
          dollar = "$";
        }
        var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        re = newRe;
      }
      if (re !== "" && hasMagic) {
        re = "(?=.)" + re;
      }
      if (addPatternStart) {
        re = patternStart + re;
      }
      if (isSub === SUBPARSE) {
        return [re, hasMagic];
      }
      if (!hasMagic) {
        return globUnescape(pattern);
      }
      var flags = options2.nocase ? "i" : "";
      try {
        var regExp = new RegExp("^" + re + "$", flags);
      } catch (er) {
        return new RegExp("$.");
      }
      regExp._glob = pattern;
      regExp._src = re;
      return regExp;
    }
    __name(parse2, "parse");
    minimatch.makeRe = function(pattern, options2) {
      return new Minimatch(pattern, options2 || {}).makeRe();
    };
    Minimatch.prototype.makeRe = makeRe;
    function makeRe() {
      if (this.regexp || this.regexp === false)
        return this.regexp;
      var set = this.set;
      if (!set.length) {
        this.regexp = false;
        return this.regexp;
      }
      var options2 = this.options;
      var twoStar = options2.noglobstar ? star : options2.dot ? twoStarDot : twoStarNoDot;
      var flags = options2.nocase ? "i" : "";
      var re = set.map(function(pattern) {
        return pattern.map(function(p3) {
          return p3 === GLOBSTAR ? twoStar : typeof p3 === "string" ? regExpEscape(p3) : p3._src;
        }).join("\\/");
      }).join("|");
      re = "^(?:" + re + ")$";
      if (this.negate)
        re = "^(?!" + re + ").*$";
      try {
        this.regexp = new RegExp(re, flags);
      } catch (ex) {
        this.regexp = false;
      }
      return this.regexp;
    }
    __name(makeRe, "makeRe");
    minimatch.match = function(list, pattern, options2) {
      options2 = options2 || {};
      var mm = new Minimatch(pattern, options2);
      list = list.filter(function(f3) {
        return mm.match(f3);
      });
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    Minimatch.prototype.match = /* @__PURE__ */ __name(function match4(f3, partial) {
      if (typeof partial === "undefined")
        partial = this.partial;
      this.debug("match", f3, this.pattern);
      if (this.comment)
        return false;
      if (this.empty)
        return f3 === "";
      if (f3 === "/" && partial)
        return true;
      var options2 = this.options;
      if (path32.sep !== "/") {
        f3 = f3.split(path32.sep).join("/");
      }
      f3 = f3.split(slashSplit);
      this.debug(this.pattern, "split", f3);
      var set = this.set;
      this.debug(this.pattern, "set", set);
      var filename;
      var i3;
      for (i3 = f3.length - 1; i3 >= 0; i3--) {
        filename = f3[i3];
        if (filename)
          break;
      }
      for (i3 = 0; i3 < set.length; i3++) {
        var pattern = set[i3];
        var file2 = f3;
        if (options2.matchBase && pattern.length === 1) {
          file2 = [filename];
        }
        var hit = this.matchOne(file2, pattern, partial);
        if (hit) {
          if (options2.flipNegate)
            return true;
          return !this.negate;
        }
      }
      if (options2.flipNegate)
        return false;
      return this.negate;
    }, "match");
    Minimatch.prototype.matchOne = function(file2, pattern, partial) {
      var options2 = this.options;
      this.debug(
        "matchOne",
        { "this": this, file: file2, pattern }
      );
      this.debug("matchOne", file2.length, pattern.length);
      for (var fi = 0, pi = 0, fl = file2.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
        this.debug("matchOne loop");
        var p3 = pattern[pi];
        var f3 = file2[fi];
        this.debug(pattern, p3, f3);
        if (p3 === false)
          return false;
        if (p3 === GLOBSTAR) {
          this.debug("GLOBSTAR", [pattern, p3, f3]);
          var fr = fi;
          var pr = pi + 1;
          if (pr === pl) {
            this.debug("** at the end");
            for (; fi < fl; fi++) {
              if (file2[fi] === "." || file2[fi] === ".." || !options2.dot && file2[fi].charAt(0) === ".")
                return false;
            }
            return true;
          }
          while (fr < fl) {
            var swallowee = file2[fr];
            this.debug("\nglobstar while", file2, fr, pattern, pr, swallowee);
            if (this.matchOne(file2.slice(fr), pattern.slice(pr), partial)) {
              this.debug("globstar found match!", fr, fl, swallowee);
              return true;
            } else {
              if (swallowee === "." || swallowee === ".." || !options2.dot && swallowee.charAt(0) === ".") {
                this.debug("dot detected!", file2, fr, pattern, pr);
                break;
              }
              this.debug("globstar swallow a segment, and continue");
              fr++;
            }
          }
          if (partial) {
            this.debug("\n>>> no match, partial?", file2, fr, pattern, pr);
            if (fr === fl)
              return true;
          }
          return false;
        }
        var hit;
        if (typeof p3 === "string") {
          hit = f3 === p3;
          this.debug("string match", p3, f3, hit);
        } else {
          hit = f3.match(p3);
          this.debug("pattern match", p3, f3, hit);
        }
        if (!hit)
          return false;
      }
      if (fi === fl && pi === pl) {
        return true;
      } else if (fi === fl) {
        return partial;
      } else if (pi === pl) {
        return fi === fl - 1 && file2[fi] === "";
      }
      throw new Error("wtf?");
    };
    function globUnescape(s4) {
      return s4.replace(/\\(.)/g, "$1");
    }
    __name(globUnescape, "globUnescape");
    function regExpEscape(s4) {
      return s4.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    }
    __name(regExpEscape, "regExpEscape");
  }
});

// ../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js
var require_inherits_browser = __commonJS({
  "../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits_browser.js"(exports2, module2) {
    if (typeof Object.create === "function") {
      module2.exports = /* @__PURE__ */ __name(function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      }, "inherits");
    } else {
      module2.exports = /* @__PURE__ */ __name(function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = /* @__PURE__ */ __name(function() {
          }, "TempCtor");
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      }, "inherits");
    }
  }
});

// ../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits.js
var require_inherits = __commonJS({
  "../../node_modules/.pnpm/inherits@2.0.4/node_modules/inherits/inherits.js"(exports2, module2) {
    try {
      util4 = require("util");
      if (typeof util4.inherits !== "function")
        throw "";
      module2.exports = util4.inherits;
    } catch (e3) {
      module2.exports = require_inherits_browser();
    }
    var util4;
  }
});

// ../../node_modules/.pnpm/path-is-absolute@1.0.1/node_modules/path-is-absolute/index.js
var require_path_is_absolute = __commonJS({
  "../../node_modules/.pnpm/path-is-absolute@1.0.1/node_modules/path-is-absolute/index.js"(exports2, module2) {
    "use strict";
    function posix(path32) {
      return path32.charAt(0) === "/";
    }
    __name(posix, "posix");
    function win32(path32) {
      var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/;
      var result = splitDeviceRe.exec(path32);
      var device = result[1] || "";
      var isUnc = Boolean(device && device.charAt(1) !== ":");
      return Boolean(result[2] || isUnc);
    }
    __name(win32, "win32");
    module2.exports = process.platform === "win32" ? win32 : posix;
    module2.exports.posix = posix;
    module2.exports.win32 = win32;
  }
});

// ../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/common.js
var require_common4 = __commonJS({
  "../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/common.js"(exports2) {
    exports2.setopts = setopts;
    exports2.ownProp = ownProp;
    exports2.makeAbs = makeAbs;
    exports2.finish = finish;
    exports2.mark = mark;
    exports2.isIgnored = isIgnored;
    exports2.childrenIgnored = childrenIgnored;
    function ownProp(obj, field) {
      return Object.prototype.hasOwnProperty.call(obj, field);
    }
    __name(ownProp, "ownProp");
    var fs37 = require("fs");
    var path32 = require("path");
    var minimatch = require_minimatch();
    var isAbsolute = require_path_is_absolute();
    var Minimatch = minimatch.Minimatch;
    function alphasort(a3, b3) {
      return a3.localeCompare(b3, "en");
    }
    __name(alphasort, "alphasort");
    function setupIgnores(self2, options2) {
      self2.ignore = options2.ignore || [];
      if (!Array.isArray(self2.ignore))
        self2.ignore = [self2.ignore];
      if (self2.ignore.length) {
        self2.ignore = self2.ignore.map(ignoreMap);
      }
    }
    __name(setupIgnores, "setupIgnores");
    function ignoreMap(pattern) {
      var gmatcher = null;
      if (pattern.slice(-3) === "/**") {
        var gpattern = pattern.replace(/(\/\*\*)+$/, "");
        gmatcher = new Minimatch(gpattern, { dot: true });
      }
      return {
        matcher: new Minimatch(pattern, { dot: true }),
        gmatcher
      };
    }
    __name(ignoreMap, "ignoreMap");
    function setopts(self2, pattern, options2) {
      if (!options2)
        options2 = {};
      if (options2.matchBase && -1 === pattern.indexOf("/")) {
        if (options2.noglobstar) {
          throw new Error("base matching requires globstar");
        }
        pattern = "**/" + pattern;
      }
      self2.silent = !!options2.silent;
      self2.pattern = pattern;
      self2.strict = options2.strict !== false;
      self2.realpath = !!options2.realpath;
      self2.realpathCache = options2.realpathCache || /* @__PURE__ */ Object.create(null);
      self2.follow = !!options2.follow;
      self2.dot = !!options2.dot;
      self2.mark = !!options2.mark;
      self2.nodir = !!options2.nodir;
      if (self2.nodir)
        self2.mark = true;
      self2.sync = !!options2.sync;
      self2.nounique = !!options2.nounique;
      self2.nonull = !!options2.nonull;
      self2.nosort = !!options2.nosort;
      self2.nocase = !!options2.nocase;
      self2.stat = !!options2.stat;
      self2.noprocess = !!options2.noprocess;
      self2.absolute = !!options2.absolute;
      self2.fs = options2.fs || fs37;
      self2.maxLength = options2.maxLength || Infinity;
      self2.cache = options2.cache || /* @__PURE__ */ Object.create(null);
      self2.statCache = options2.statCache || /* @__PURE__ */ Object.create(null);
      self2.symlinks = options2.symlinks || /* @__PURE__ */ Object.create(null);
      setupIgnores(self2, options2);
      self2.changedCwd = false;
      var cwd = process.cwd();
      if (!ownProp(options2, "cwd"))
        self2.cwd = cwd;
      else {
        self2.cwd = path32.resolve(options2.cwd);
        self2.changedCwd = self2.cwd !== cwd;
      }
      self2.root = options2.root || path32.resolve(self2.cwd, "/");
      self2.root = path32.resolve(self2.root);
      if (process.platform === "win32")
        self2.root = self2.root.replace(/\\/g, "/");
      self2.cwdAbs = isAbsolute(self2.cwd) ? self2.cwd : makeAbs(self2, self2.cwd);
      if (process.platform === "win32")
        self2.cwdAbs = self2.cwdAbs.replace(/\\/g, "/");
      self2.nomount = !!options2.nomount;
      options2.nonegate = true;
      options2.nocomment = true;
      options2.allowWindowsEscape = false;
      self2.minimatch = new Minimatch(pattern, options2);
      self2.options = self2.minimatch.options;
    }
    __name(setopts, "setopts");
    function finish(self2) {
      var nou = self2.nounique;
      var all = nou ? [] : /* @__PURE__ */ Object.create(null);
      for (var i3 = 0, l3 = self2.matches.length; i3 < l3; i3++) {
        var matches = self2.matches[i3];
        if (!matches || Object.keys(matches).length === 0) {
          if (self2.nonull) {
            var literal = self2.minimatch.globSet[i3];
            if (nou)
              all.push(literal);
            else
              all[literal] = true;
          }
        } else {
          var m4 = Object.keys(matches);
          if (nou)
            all.push.apply(all, m4);
          else
            m4.forEach(function(m5) {
              all[m5] = true;
            });
        }
      }
      if (!nou)
        all = Object.keys(all);
      if (!self2.nosort)
        all = all.sort(alphasort);
      if (self2.mark) {
        for (var i3 = 0; i3 < all.length; i3++) {
          all[i3] = self2._mark(all[i3]);
        }
        if (self2.nodir) {
          all = all.filter(function(e3) {
            var notDir = !/\/$/.test(e3);
            var c3 = self2.cache[e3] || self2.cache[makeAbs(self2, e3)];
            if (notDir && c3)
              notDir = c3 !== "DIR" && !Array.isArray(c3);
            return notDir;
          });
        }
      }
      if (self2.ignore.length)
        all = all.filter(function(m5) {
          return !isIgnored(self2, m5);
        });
      self2.found = all;
    }
    __name(finish, "finish");
    function mark(self2, p3) {
      var abs = makeAbs(self2, p3);
      var c3 = self2.cache[abs];
      var m4 = p3;
      if (c3) {
        var isDir = c3 === "DIR" || Array.isArray(c3);
        var slash = p3.slice(-1) === "/";
        if (isDir && !slash)
          m4 += "/";
        else if (!isDir && slash)
          m4 = m4.slice(0, -1);
        if (m4 !== p3) {
          var mabs = makeAbs(self2, m4);
          self2.statCache[mabs] = self2.statCache[abs];
          self2.cache[mabs] = self2.cache[abs];
        }
      }
      return m4;
    }
    __name(mark, "mark");
    function makeAbs(self2, f3) {
      var abs = f3;
      if (f3.charAt(0) === "/") {
        abs = path32.join(self2.root, f3);
      } else if (isAbsolute(f3) || f3 === "") {
        abs = f3;
      } else if (self2.changedCwd) {
        abs = path32.resolve(self2.cwd, f3);
      } else {
        abs = path32.resolve(f3);
      }
      if (process.platform === "win32")
        abs = abs.replace(/\\/g, "/");
      return abs;
    }
    __name(makeAbs, "makeAbs");
    function isIgnored(self2, path33) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return item.matcher.match(path33) || !!(item.gmatcher && item.gmatcher.match(path33));
      });
    }
    __name(isIgnored, "isIgnored");
    function childrenIgnored(self2, path33) {
      if (!self2.ignore.length)
        return false;
      return self2.ignore.some(function(item) {
        return !!(item.gmatcher && item.gmatcher.match(path33));
      });
    }
    __name(childrenIgnored, "childrenIgnored");
  }
});

// ../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/sync.js
var require_sync8 = __commonJS({
  "../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/sync.js"(exports2, module2) {
    module2.exports = globSync;
    globSync.GlobSync = GlobSync;
    var rp = require_fs5();
    var minimatch = require_minimatch();
    var Minimatch = minimatch.Minimatch;
    var Glob = require_glob().Glob;
    var util4 = require("util");
    var path32 = require("path");
    var assert = require("assert");
    var isAbsolute = require_path_is_absolute();
    var common = require_common4();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    function globSync(pattern, options2) {
      if (typeof options2 === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      return new GlobSync(pattern, options2).found;
    }
    __name(globSync, "globSync");
    function GlobSync(pattern, options2) {
      if (!pattern)
        throw new Error("must provide pattern");
      if (typeof options2 === "function" || arguments.length === 3)
        throw new TypeError("callback provided to sync glob\nSee: https://github.com/isaacs/node-glob/issues/167");
      if (!(this instanceof GlobSync))
        return new GlobSync(pattern, options2);
      setopts(this, pattern, options2);
      if (this.noprocess)
        return this;
      var n3 = this.minimatch.set.length;
      this.matches = new Array(n3);
      for (var i3 = 0; i3 < n3; i3++) {
        this._process(this.minimatch.set[i3], i3, false);
      }
      this._finish();
    }
    __name(GlobSync, "GlobSync");
    GlobSync.prototype._finish = function() {
      assert.ok(this instanceof GlobSync);
      if (this.realpath) {
        var self2 = this;
        this.matches.forEach(function(matchset, index2) {
          var set = self2.matches[index2] = /* @__PURE__ */ Object.create(null);
          for (var p3 in matchset) {
            try {
              p3 = self2._makeAbs(p3);
              var real = rp.realpathSync(p3, self2.realpathCache);
              set[real] = true;
            } catch (er) {
              if (er.syscall === "stat")
                set[self2._makeAbs(p3)] = true;
              else
                throw er;
            }
          }
        });
      }
      common.finish(this);
    };
    GlobSync.prototype._process = function(pattern, index2, inGlobStar) {
      assert.ok(this instanceof GlobSync);
      var n3 = 0;
      while (typeof pattern[n3] === "string") {
        n3++;
      }
      var prefix;
      switch (n3) {
        case pattern.length:
          this._processSimple(pattern.join("/"), index2);
          return;
        case 0:
          prefix = null;
          break;
        default:
          prefix = pattern.slice(0, n3).join("/");
          break;
      }
      var remain = pattern.slice(n3);
      var read;
      if (prefix === null)
        read = ".";
      else if (isAbsolute(prefix) || isAbsolute(pattern.map(function(p3) {
        return typeof p3 === "string" ? p3 : "[*]";
      }).join("/"))) {
        if (!prefix || !isAbsolute(prefix))
          prefix = "/" + prefix;
        read = prefix;
      } else
        read = prefix;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return;
      var isGlobStar = remain[0] === minimatch.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix, read, abs, remain, index2, inGlobStar);
      else
        this._processReaddir(prefix, read, abs, remain, index2, inGlobStar);
    };
    GlobSync.prototype._processReaddir = function(prefix, read, abs, remain, index2, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var pn = remain[0];
      var negate = !!this.minimatch.negate;
      var rawGlob = pn._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i3 = 0; i3 < entries.length; i3++) {
        var e3 = entries[i3];
        if (e3.charAt(0) !== "." || dotOk) {
          var m4;
          if (negate && !prefix) {
            m4 = !e3.match(pn);
          } else {
            m4 = e3.match(pn);
          }
          if (m4)
            matchedEntries.push(e3);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return;
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index2])
          this.matches[index2] = /* @__PURE__ */ Object.create(null);
        for (var i3 = 0; i3 < len; i3++) {
          var e3 = matchedEntries[i3];
          if (prefix) {
            if (prefix.slice(-1) !== "/")
              e3 = prefix + "/" + e3;
            else
              e3 = prefix + e3;
          }
          if (e3.charAt(0) === "/" && !this.nomount) {
            e3 = path32.join(this.root, e3);
          }
          this._emitMatch(index2, e3);
        }
        return;
      }
      remain.shift();
      for (var i3 = 0; i3 < len; i3++) {
        var e3 = matchedEntries[i3];
        var newPattern;
        if (prefix)
          newPattern = [prefix, e3];
        else
          newPattern = [e3];
        this._process(newPattern.concat(remain), index2, inGlobStar);
      }
    };
    GlobSync.prototype._emitMatch = function(index2, e3) {
      if (isIgnored(this, e3))
        return;
      var abs = this._makeAbs(e3);
      if (this.mark)
        e3 = this._mark(e3);
      if (this.absolute) {
        e3 = abs;
      }
      if (this.matches[index2][e3])
        return;
      if (this.nodir) {
        var c3 = this.cache[abs];
        if (c3 === "DIR" || Array.isArray(c3))
          return;
      }
      this.matches[index2][e3] = true;
      if (this.stat)
        this._stat(e3);
    };
    GlobSync.prototype._readdirInGlobStar = function(abs) {
      if (this.follow)
        return this._readdir(abs, false);
      var entries;
      var lstat;
      var stat2;
      try {
        lstat = this.fs.lstatSync(abs);
      } catch (er) {
        if (er.code === "ENOENT") {
          return null;
        }
      }
      var isSym = lstat && lstat.isSymbolicLink();
      this.symlinks[abs] = isSym;
      if (!isSym && lstat && !lstat.isDirectory())
        this.cache[abs] = "FILE";
      else
        entries = this._readdir(abs, false);
      return entries;
    };
    GlobSync.prototype._readdir = function(abs, inGlobStar) {
      var entries;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs);
      if (ownProp(this.cache, abs)) {
        var c3 = this.cache[abs];
        if (!c3 || c3 === "FILE")
          return null;
        if (Array.isArray(c3))
          return c3;
      }
      try {
        return this._readdirEntries(abs, this.fs.readdirSync(abs));
      } catch (er) {
        this._readdirError(abs, er);
        return null;
      }
    };
    GlobSync.prototype._readdirEntries = function(abs, entries) {
      if (!this.mark && !this.stat) {
        for (var i3 = 0; i3 < entries.length; i3++) {
          var e3 = entries[i3];
          if (abs === "/")
            e3 = abs + e3;
          else
            e3 = abs + "/" + e3;
          this.cache[e3] = true;
        }
      }
      this.cache[abs] = entries;
      return entries;
    };
    GlobSync.prototype._readdirError = function(f3, er) {
      switch (er.code) {
        case "ENOTSUP":
        case "ENOTDIR":
          var abs = this._makeAbs(f3);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error2 = new Error(er.code + " invalid cwd " + this.cwd);
            error2.path = this.cwd;
            error2.code = er.code;
            throw error2;
          }
          break;
        case "ENOENT":
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f3)] = false;
          break;
        default:
          this.cache[this._makeAbs(f3)] = false;
          if (this.strict)
            throw er;
          if (!this.silent)
            console.error("glob error", er);
          break;
      }
    };
    GlobSync.prototype._processGlobStar = function(prefix, read, abs, remain, index2, inGlobStar) {
      var entries = this._readdir(abs, inGlobStar);
      if (!entries)
        return;
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix ? [prefix] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index2, false);
      var len = entries.length;
      var isSym = this.symlinks[abs];
      if (isSym && inGlobStar)
        return;
      for (var i3 = 0; i3 < len; i3++) {
        var e3 = entries[i3];
        if (e3.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i3], remainWithoutGlobStar);
        this._process(instead, index2, true);
        var below = gspref.concat(entries[i3], remain);
        this._process(below, index2, true);
      }
    };
    GlobSync.prototype._processSimple = function(prefix, index2) {
      var exists6 = this._stat(prefix);
      if (!this.matches[index2])
        this.matches[index2] = /* @__PURE__ */ Object.create(null);
      if (!exists6)
        return;
      if (prefix && isAbsolute(prefix) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix);
        if (prefix.charAt(0) === "/") {
          prefix = path32.join(this.root, prefix);
        } else {
          prefix = path32.resolve(this.root, prefix);
          if (trail)
            prefix += "/";
        }
      }
      if (process.platform === "win32")
        prefix = prefix.replace(/\\/g, "/");
      this._emitMatch(index2, prefix);
    };
    GlobSync.prototype._stat = function(f3) {
      var abs = this._makeAbs(f3);
      var needDir = f3.slice(-1) === "/";
      if (f3.length > this.maxLength)
        return false;
      if (!this.stat && ownProp(this.cache, abs)) {
        var c3 = this.cache[abs];
        if (Array.isArray(c3))
          c3 = "DIR";
        if (!needDir || c3 === "DIR")
          return c3;
        if (needDir && c3 === "FILE")
          return false;
      }
      var exists6;
      var stat2 = this.statCache[abs];
      if (!stat2) {
        var lstat;
        try {
          lstat = this.fs.lstatSync(abs);
        } catch (er) {
          if (er && (er.code === "ENOENT" || er.code === "ENOTDIR")) {
            this.statCache[abs] = false;
            return false;
          }
        }
        if (lstat && lstat.isSymbolicLink()) {
          try {
            stat2 = this.fs.statSync(abs);
          } catch (er) {
            stat2 = lstat;
          }
        } else {
          stat2 = lstat;
        }
      }
      this.statCache[abs] = stat2;
      var c3 = true;
      if (stat2)
        c3 = stat2.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c3;
      if (needDir && c3 === "FILE")
        return false;
      return c3;
    };
    GlobSync.prototype._mark = function(p3) {
      return common.mark(this, p3);
    };
    GlobSync.prototype._makeAbs = function(f3) {
      return common.makeAbs(this, f3);
    };
  }
});

// ../../node_modules/.pnpm/wrappy@1.0.2/node_modules/wrappy/wrappy.js
var require_wrappy = __commonJS({
  "../../node_modules/.pnpm/wrappy@1.0.2/node_modules/wrappy/wrappy.js"(exports2, module2) {
    module2.exports = wrappy;
    function wrappy(fn2, cb) {
      if (fn2 && cb)
        return wrappy(fn2)(cb);
      if (typeof fn2 !== "function")
        throw new TypeError("need wrapper function");
      Object.keys(fn2).forEach(function(k) {
        wrapper[k] = fn2[k];
      });
      return wrapper;
      function wrapper() {
        var args3 = new Array(arguments.length);
        for (var i3 = 0; i3 < args3.length; i3++) {
          args3[i3] = arguments[i3];
        }
        var ret = fn2.apply(this, args3);
        var cb2 = args3[args3.length - 1];
        if (typeof ret === "function" && ret !== cb2) {
          Object.keys(cb2).forEach(function(k) {
            ret[k] = cb2[k];
          });
        }
        return ret;
      }
      __name(wrapper, "wrapper");
    }
    __name(wrappy, "wrappy");
  }
});

// ../../node_modules/.pnpm/once@1.4.0/node_modules/once/once.js
var require_once = __commonJS({
  "../../node_modules/.pnpm/once@1.4.0/node_modules/once/once.js"(exports2, module2) {
    var wrappy = require_wrappy();
    module2.exports = wrappy(once2);
    module2.exports.strict = wrappy(onceStrict);
    once2.proto = once2(function() {
      Object.defineProperty(Function.prototype, "once", {
        value: function() {
          return once2(this);
        },
        configurable: true
      });
      Object.defineProperty(Function.prototype, "onceStrict", {
        value: function() {
          return onceStrict(this);
        },
        configurable: true
      });
    });
    function once2(fn2) {
      var f3 = /* @__PURE__ */ __name(function() {
        if (f3.called)
          return f3.value;
        f3.called = true;
        return f3.value = fn2.apply(this, arguments);
      }, "f");
      f3.called = false;
      return f3;
    }
    __name(once2, "once");
    function onceStrict(fn2) {
      var f3 = /* @__PURE__ */ __name(function() {
        if (f3.called)
          throw new Error(f3.onceError);
        f3.called = true;
        return f3.value = fn2.apply(this, arguments);
      }, "f");
      var name = fn2.name || "Function wrapped with `once`";
      f3.onceError = name + " shouldn't be called more than once";
      f3.called = false;
      return f3;
    }
    __name(onceStrict, "onceStrict");
  }
});

// ../../node_modules/.pnpm/inflight@1.0.6/node_modules/inflight/inflight.js
var require_inflight = __commonJS({
  "../../node_modules/.pnpm/inflight@1.0.6/node_modules/inflight/inflight.js"(exports2, module2) {
    var wrappy = require_wrappy();
    var reqs = /* @__PURE__ */ Object.create(null);
    var once2 = require_once();
    module2.exports = wrappy(inflight);
    function inflight(key, cb) {
      if (reqs[key]) {
        reqs[key].push(cb);
        return null;
      } else {
        reqs[key] = [cb];
        return makeres(key);
      }
    }
    __name(inflight, "inflight");
    function makeres(key) {
      return once2(/* @__PURE__ */ __name(function RES() {
        var cbs = reqs[key];
        var len = cbs.length;
        var args3 = slice(arguments);
        try {
          for (var i3 = 0; i3 < len; i3++) {
            cbs[i3].apply(null, args3);
          }
        } finally {
          if (cbs.length > len) {
            cbs.splice(0, len);
            process.nextTick(function() {
              RES.apply(null, args3);
            });
          } else {
            delete reqs[key];
          }
        }
      }, "RES"));
    }
    __name(makeres, "makeres");
    function slice(args3) {
      var length = args3.length;
      var array = [];
      for (var i3 = 0; i3 < length; i3++)
        array[i3] = args3[i3];
      return array;
    }
    __name(slice, "slice");
  }
});

// ../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/glob.js
var require_glob = __commonJS({
  "../../node_modules/.pnpm/glob@7.2.3/node_modules/glob/glob.js"(exports2, module2) {
    module2.exports = glob;
    var rp = require_fs5();
    var minimatch = require_minimatch();
    var Minimatch = minimatch.Minimatch;
    var inherits = require_inherits();
    var EE = require("events").EventEmitter;
    var path32 = require("path");
    var assert = require("assert");
    var isAbsolute = require_path_is_absolute();
    var globSync = require_sync8();
    var common = require_common4();
    var setopts = common.setopts;
    var ownProp = common.ownProp;
    var inflight = require_inflight();
    var util4 = require("util");
    var childrenIgnored = common.childrenIgnored;
    var isIgnored = common.isIgnored;
    var once2 = require_once();
    function glob(pattern, options2, cb) {
      if (typeof options2 === "function")
        cb = options2, options2 = {};
      if (!options2)
        options2 = {};
      if (options2.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return globSync(pattern, options2);
      }
      return new Glob(pattern, options2, cb);
    }
    __name(glob, "glob");
    glob.sync = globSync;
    var GlobSync = glob.GlobSync = globSync.GlobSync;
    glob.glob = glob;
    function extend(origin, add) {
      if (add === null || typeof add !== "object") {
        return origin;
      }
      var keys = Object.keys(add);
      var i3 = keys.length;
      while (i3--) {
        origin[keys[i3]] = add[keys[i3]];
      }
      return origin;
    }
    __name(extend, "extend");
    glob.hasMagic = function(pattern, options_) {
      var options2 = extend({}, options_);
      options2.noprocess = true;
      var g3 = new Glob(pattern, options2);
      var set = g3.minimatch.set;
      if (!pattern)
        return false;
      if (set.length > 1)
        return true;
      for (var j = 0; j < set[0].length; j++) {
        if (typeof set[0][j] !== "string")
          return true;
      }
      return false;
    };
    glob.Glob = Glob;
    inherits(Glob, EE);
    function Glob(pattern, options2, cb) {
      if (typeof options2 === "function") {
        cb = options2;
        options2 = null;
      }
      if (options2 && options2.sync) {
        if (cb)
          throw new TypeError("callback provided to sync glob");
        return new GlobSync(pattern, options2);
      }
      if (!(this instanceof Glob))
        return new Glob(pattern, options2, cb);
      setopts(this, pattern, options2);
      this._didRealPath = false;
      var n3 = this.minimatch.set.length;
      this.matches = new Array(n3);
      if (typeof cb === "function") {
        cb = once2(cb);
        this.on("error", cb);
        this.on("end", function(matches) {
          cb(null, matches);
        });
      }
      var self2 = this;
      this._processing = 0;
      this._emitQueue = [];
      this._processQueue = [];
      this.paused = false;
      if (this.noprocess)
        return this;
      if (n3 === 0)
        return done();
      var sync = true;
      for (var i3 = 0; i3 < n3; i3++) {
        this._process(this.minimatch.set[i3], i3, false, done);
      }
      sync = false;
      function done() {
        --self2._processing;
        if (self2._processing <= 0) {
          if (sync) {
            process.nextTick(function() {
              self2._finish();
            });
          } else {
            self2._finish();
          }
        }
      }
      __name(done, "done");
    }
    __name(Glob, "Glob");
    Glob.prototype._finish = function() {
      assert(this instanceof Glob);
      if (this.aborted)
        return;
      if (this.realpath && !this._didRealpath)
        return this._realpath();
      common.finish(this);
      this.emit("end", this.found);
    };
    Glob.prototype._realpath = function() {
      if (this._didRealpath)
        return;
      this._didRealpath = true;
      var n3 = this.matches.length;
      if (n3 === 0)
        return this._finish();
      var self2 = this;
      for (var i3 = 0; i3 < this.matches.length; i3++)
        this._realpathSet(i3, next);
      function next() {
        if (--n3 === 0)
          self2._finish();
      }
      __name(next, "next");
    };
    Glob.prototype._realpathSet = function(index2, cb) {
      var matchset = this.matches[index2];
      if (!matchset)
        return cb();
      var found = Object.keys(matchset);
      var self2 = this;
      var n3 = found.length;
      if (n3 === 0)
        return cb();
      var set = this.matches[index2] = /* @__PURE__ */ Object.create(null);
      found.forEach(function(p3, i3) {
        p3 = self2._makeAbs(p3);
        rp.realpath(p3, self2.realpathCache, function(er, real) {
          if (!er)
            set[real] = true;
          else if (er.syscall === "stat")
            set[p3] = true;
          else
            self2.emit("error", er);
          if (--n3 === 0) {
            self2.matches[index2] = set;
            cb();
          }
        });
      });
    };
    Glob.prototype._mark = function(p3) {
      return common.mark(this, p3);
    };
    Glob.prototype._makeAbs = function(f3) {
      return common.makeAbs(this, f3);
    };
    Glob.prototype.abort = function() {
      this.aborted = true;
      this.emit("abort");
    };
    Glob.prototype.pause = function() {
      if (!this.paused) {
        this.paused = true;
        this.emit("pause");
      }
    };
    Glob.prototype.resume = function() {
      if (this.paused) {
        this.emit("resume");
        this.paused = false;
        if (this._emitQueue.length) {
          var eq = this._emitQueue.slice(0);
          this._emitQueue.length = 0;
          for (var i3 = 0; i3 < eq.length; i3++) {
            var e3 = eq[i3];
            this._emitMatch(e3[0], e3[1]);
          }
        }
        if (this._processQueue.length) {
          var pq = this._processQueue.slice(0);
          this._processQueue.length = 0;
          for (var i3 = 0; i3 < pq.length; i3++) {
            var p3 = pq[i3];
            this._processing--;
            this._process(p3[0], p3[1], p3[2], p3[3]);
          }
        }
      }
    };
    Glob.prototype._process = function(pattern, index2, inGlobStar, cb) {
      assert(this instanceof Glob);
      assert(typeof cb === "function");
      if (this.aborted)
        return;
      this._processing++;
      if (this.paused) {
        this._processQueue.push([pattern, index2, inGlobStar, cb]);
        return;
      }
      var n3 = 0;
      while (typeof pattern[n3] === "string") {
        n3++;
      }
      var prefix;
      switch (n3) {
        case pattern.length:
          this._processSimple(pattern.join("/"), index2, cb);
          return;
        case 0:
          prefix = null;
          break;
        default:
          prefix = pattern.slice(0, n3).join("/");
          break;
      }
      var remain = pattern.slice(n3);
      var read;
      if (prefix === null)
        read = ".";
      else if (isAbsolute(prefix) || isAbsolute(pattern.map(function(p3) {
        return typeof p3 === "string" ? p3 : "[*]";
      }).join("/"))) {
        if (!prefix || !isAbsolute(prefix))
          prefix = "/" + prefix;
        read = prefix;
      } else
        read = prefix;
      var abs = this._makeAbs(read);
      if (childrenIgnored(this, read))
        return cb();
      var isGlobStar = remain[0] === minimatch.GLOBSTAR;
      if (isGlobStar)
        this._processGlobStar(prefix, read, abs, remain, index2, inGlobStar, cb);
      else
        this._processReaddir(prefix, read, abs, remain, index2, inGlobStar, cb);
    };
    Glob.prototype._processReaddir = function(prefix, read, abs, remain, index2, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er, entries) {
        return self2._processReaddir2(prefix, read, abs, remain, index2, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processReaddir2 = function(prefix, read, abs, remain, index2, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var pn = remain[0];
      var negate = !!this.minimatch.negate;
      var rawGlob = pn._glob;
      var dotOk = this.dot || rawGlob.charAt(0) === ".";
      var matchedEntries = [];
      for (var i3 = 0; i3 < entries.length; i3++) {
        var e3 = entries[i3];
        if (e3.charAt(0) !== "." || dotOk) {
          var m4;
          if (negate && !prefix) {
            m4 = !e3.match(pn);
          } else {
            m4 = e3.match(pn);
          }
          if (m4)
            matchedEntries.push(e3);
        }
      }
      var len = matchedEntries.length;
      if (len === 0)
        return cb();
      if (remain.length === 1 && !this.mark && !this.stat) {
        if (!this.matches[index2])
          this.matches[index2] = /* @__PURE__ */ Object.create(null);
        for (var i3 = 0; i3 < len; i3++) {
          var e3 = matchedEntries[i3];
          if (prefix) {
            if (prefix !== "/")
              e3 = prefix + "/" + e3;
            else
              e3 = prefix + e3;
          }
          if (e3.charAt(0) === "/" && !this.nomount) {
            e3 = path32.join(this.root, e3);
          }
          this._emitMatch(index2, e3);
        }
        return cb();
      }
      remain.shift();
      for (var i3 = 0; i3 < len; i3++) {
        var e3 = matchedEntries[i3];
        var newPattern;
        if (prefix) {
          if (prefix !== "/")
            e3 = prefix + "/" + e3;
          else
            e3 = prefix + e3;
        }
        this._process([e3].concat(remain), index2, inGlobStar, cb);
      }
      cb();
    };
    Glob.prototype._emitMatch = function(index2, e3) {
      if (this.aborted)
        return;
      if (isIgnored(this, e3))
        return;
      if (this.paused) {
        this._emitQueue.push([index2, e3]);
        return;
      }
      var abs = isAbsolute(e3) ? e3 : this._makeAbs(e3);
      if (this.mark)
        e3 = this._mark(e3);
      if (this.absolute)
        e3 = abs;
      if (this.matches[index2][e3])
        return;
      if (this.nodir) {
        var c3 = this.cache[abs];
        if (c3 === "DIR" || Array.isArray(c3))
          return;
      }
      this.matches[index2][e3] = true;
      var st = this.statCache[abs];
      if (st)
        this.emit("stat", e3, st);
      this.emit("match", e3);
    };
    Glob.prototype._readdirInGlobStar = function(abs, cb) {
      if (this.aborted)
        return;
      if (this.follow)
        return this._readdir(abs, false, cb);
      var lstatkey = "lstat\0" + abs;
      var self2 = this;
      var lstatcb = inflight(lstatkey, lstatcb_);
      if (lstatcb)
        self2.fs.lstat(abs, lstatcb);
      function lstatcb_(er, lstat) {
        if (er && er.code === "ENOENT")
          return cb();
        var isSym = lstat && lstat.isSymbolicLink();
        self2.symlinks[abs] = isSym;
        if (!isSym && lstat && !lstat.isDirectory()) {
          self2.cache[abs] = "FILE";
          cb();
        } else
          self2._readdir(abs, false, cb);
      }
      __name(lstatcb_, "lstatcb_");
    };
    Glob.prototype._readdir = function(abs, inGlobStar, cb) {
      if (this.aborted)
        return;
      cb = inflight("readdir\0" + abs + "\0" + inGlobStar, cb);
      if (!cb)
        return;
      if (inGlobStar && !ownProp(this.symlinks, abs))
        return this._readdirInGlobStar(abs, cb);
      if (ownProp(this.cache, abs)) {
        var c3 = this.cache[abs];
        if (!c3 || c3 === "FILE")
          return cb();
        if (Array.isArray(c3))
          return cb(null, c3);
      }
      var self2 = this;
      self2.fs.readdir(abs, readdirCb(this, abs, cb));
    };
    function readdirCb(self2, abs, cb) {
      return function(er, entries) {
        if (er)
          self2._readdirError(abs, er, cb);
        else
          self2._readdirEntries(abs, entries, cb);
      };
    }
    __name(readdirCb, "readdirCb");
    Glob.prototype._readdirEntries = function(abs, entries, cb) {
      if (this.aborted)
        return;
      if (!this.mark && !this.stat) {
        for (var i3 = 0; i3 < entries.length; i3++) {
          var e3 = entries[i3];
          if (abs === "/")
            e3 = abs + e3;
          else
            e3 = abs + "/" + e3;
          this.cache[e3] = true;
        }
      }
      this.cache[abs] = entries;
      return cb(null, entries);
    };
    Glob.prototype._readdirError = function(f3, er, cb) {
      if (this.aborted)
        return;
      switch (er.code) {
        case "ENOTSUP":
        case "ENOTDIR":
          var abs = this._makeAbs(f3);
          this.cache[abs] = "FILE";
          if (abs === this.cwdAbs) {
            var error2 = new Error(er.code + " invalid cwd " + this.cwd);
            error2.path = this.cwd;
            error2.code = er.code;
            this.emit("error", error2);
            this.abort();
          }
          break;
        case "ENOENT":
        case "ELOOP":
        case "ENAMETOOLONG":
        case "UNKNOWN":
          this.cache[this._makeAbs(f3)] = false;
          break;
        default:
          this.cache[this._makeAbs(f3)] = false;
          if (this.strict) {
            this.emit("error", er);
            this.abort();
          }
          if (!this.silent)
            console.error("glob error", er);
          break;
      }
      return cb();
    };
    Glob.prototype._processGlobStar = function(prefix, read, abs, remain, index2, inGlobStar, cb) {
      var self2 = this;
      this._readdir(abs, inGlobStar, function(er, entries) {
        self2._processGlobStar2(prefix, read, abs, remain, index2, inGlobStar, entries, cb);
      });
    };
    Glob.prototype._processGlobStar2 = function(prefix, read, abs, remain, index2, inGlobStar, entries, cb) {
      if (!entries)
        return cb();
      var remainWithoutGlobStar = remain.slice(1);
      var gspref = prefix ? [prefix] : [];
      var noGlobStar = gspref.concat(remainWithoutGlobStar);
      this._process(noGlobStar, index2, false, cb);
      var isSym = this.symlinks[abs];
      var len = entries.length;
      if (isSym && inGlobStar)
        return cb();
      for (var i3 = 0; i3 < len; i3++) {
        var e3 = entries[i3];
        if (e3.charAt(0) === "." && !this.dot)
          continue;
        var instead = gspref.concat(entries[i3], remainWithoutGlobStar);
        this._process(instead, index2, true, cb);
        var below = gspref.concat(entries[i3], remain);
        this._process(below, index2, true, cb);
      }
      cb();
    };
    Glob.prototype._processSimple = function(prefix, index2, cb) {
      var self2 = this;
      this._stat(prefix, function(er, exists6) {
        self2._processSimple2(prefix, index2, er, exists6, cb);
      });
    };
    Glob.prototype._processSimple2 = function(prefix, index2, er, exists6, cb) {
      if (!this.matches[index2])
        this.matches[index2] = /* @__PURE__ */ Object.create(null);
      if (!exists6)
        return cb();
      if (prefix && isAbsolute(prefix) && !this.nomount) {
        var trail = /[\/\\]$/.test(prefix);
        if (prefix.charAt(0) === "/") {
          prefix = path32.join(this.root, prefix);
        } else {
          prefix = path32.resolve(this.root, prefix);
          if (trail)
            prefix += "/";
        }
      }
      if (process.platform === "win32")
        prefix = prefix.replace(/\\/g, "/");
      this._emitMatch(index2, prefix);
      cb();
    };
    Glob.prototype._stat = function(f3, cb) {
      var abs = this._makeAbs(f3);
      var needDir = f3.slice(-1) === "/";
      if (f3.length > this.maxLength)
        return cb();
      if (!this.stat && ownProp(this.cache, abs)) {
        var c3 = this.cache[abs];
        if (Array.isArray(c3))
          c3 = "DIR";
        if (!needDir || c3 === "DIR")
          return cb(null, c3);
        if (needDir && c3 === "FILE")
          return cb();
      }
      var exists6;
      var stat2 = this.statCache[abs];
      if (stat2 !== void 0) {
        if (stat2 === false)
          return cb(null, stat2);
        else {
          var type = stat2.isDirectory() ? "DIR" : "FILE";
          if (needDir && type === "FILE")
            return cb();
          else
            return cb(null, type, stat2);
        }
      }
      var self2 = this;
      var statcb = inflight("stat\0" + abs, lstatcb_);
      if (statcb)
        self2.fs.lstat(abs, statcb);
      function lstatcb_(er, lstat) {
        if (lstat && lstat.isSymbolicLink()) {
          return self2.fs.stat(abs, function(er2, stat3) {
            if (er2)
              self2._stat2(f3, abs, null, lstat, cb);
            else
              self2._stat2(f3, abs, er2, stat3, cb);
          });
        } else {
          self2._stat2(f3, abs, er, lstat, cb);
        }
      }
      __name(lstatcb_, "lstatcb_");
    };
    Glob.prototype._stat2 = function(f3, abs, er, stat2, cb) {
      if (er && (er.code === "ENOENT" || er.code === "ENOTDIR")) {
        this.statCache[abs] = false;
        return cb();
      }
      var needDir = f3.slice(-1) === "/";
      this.statCache[abs] = stat2;
      if (abs.slice(-1) === "/" && stat2 && !stat2.isDirectory())
        return cb(null, false, stat2);
      var c3 = true;
      if (stat2)
        c3 = stat2.isDirectory() ? "DIR" : "FILE";
      this.cache[abs] = this.cache[abs] || c3;
      if (needDir && c3 === "FILE")
        return cb();
      return cb(null, c3, stat2);
    };
  }
});

// ../../node_modules/.pnpm/rimraf@3.0.2/node_modules/rimraf/rimraf.js
var require_rimraf = __commonJS({
  "../../node_modules/.pnpm/rimraf@3.0.2/node_modules/rimraf/rimraf.js"(exports2, module2) {
    var assert = require("assert");
    var path32 = require("path");
    var fs37 = require("fs");
    var glob = void 0;
    try {
      glob = require_glob();
    } catch (_err) {
    }
    var defaultGlobOpts = {
      nosort: true,
      silent: true
    };
    var timeout2 = 0;
    var isWindows2 = process.platform === "win32";
    var defaults = /* @__PURE__ */ __name((options2) => {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m4) => {
        options2[m4] = options2[m4] || fs37[m4];
        m4 = m4 + "Sync";
        options2[m4] = options2[m4] || fs37[m4];
      });
      options2.maxBusyTries = options2.maxBusyTries || 3;
      options2.emfileWait = options2.emfileWait || 1e3;
      if (options2.glob === false) {
        options2.disableGlob = true;
      }
      if (options2.disableGlob !== true && glob === void 0) {
        throw Error("glob dependency not found, set `options.disableGlob = true` if intentional");
      }
      options2.disableGlob = options2.disableGlob || false;
      options2.glob = options2.glob || defaultGlobOpts;
    }, "defaults");
    var rimraf3 = /* @__PURE__ */ __name((p3, options2, cb) => {
      if (typeof options2 === "function") {
        cb = options2;
        options2 = {};
      }
      assert(p3, "rimraf: missing path");
      assert.equal(typeof p3, "string", "rimraf: path should be a string");
      assert.equal(typeof cb, "function", "rimraf: callback function required");
      assert(options2, "rimraf: invalid options argument provided");
      assert.equal(typeof options2, "object", "rimraf: options should be object");
      defaults(options2);
      let busyTries = 0;
      let errState = null;
      let n3 = 0;
      const next = /* @__PURE__ */ __name((er) => {
        errState = errState || er;
        if (--n3 === 0)
          cb(errState);
      }, "next");
      const afterGlob = /* @__PURE__ */ __name((er, results) => {
        if (er)
          return cb(er);
        n3 = results.length;
        if (n3 === 0)
          return cb();
        results.forEach((p4) => {
          const CB = /* @__PURE__ */ __name((er2) => {
            if (er2) {
              if ((er2.code === "EBUSY" || er2.code === "ENOTEMPTY" || er2.code === "EPERM") && busyTries < options2.maxBusyTries) {
                busyTries++;
                return setTimeout(() => rimraf_(p4, options2, CB), busyTries * 100);
              }
              if (er2.code === "EMFILE" && timeout2 < options2.emfileWait) {
                return setTimeout(() => rimraf_(p4, options2, CB), timeout2++);
              }
              if (er2.code === "ENOENT")
                er2 = null;
            }
            timeout2 = 0;
            next(er2);
          }, "CB");
          rimraf_(p4, options2, CB);
        });
      }, "afterGlob");
      if (options2.disableGlob || !glob.hasMagic(p3))
        return afterGlob(null, [p3]);
      options2.lstat(p3, (er, stat2) => {
        if (!er)
          return afterGlob(null, [p3]);
        glob(p3, options2.glob, afterGlob);
      });
    }, "rimraf");
    var rimraf_ = /* @__PURE__ */ __name((p3, options2, cb) => {
      assert(p3);
      assert(options2);
      assert(typeof cb === "function");
      options2.lstat(p3, (er, st) => {
        if (er && er.code === "ENOENT")
          return cb(null);
        if (er && er.code === "EPERM" && isWindows2)
          fixWinEPERM(p3, options2, er, cb);
        if (st && st.isDirectory())
          return rmdir(p3, options2, er, cb);
        options2.unlink(p3, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT")
              return cb(null);
            if (er2.code === "EPERM")
              return isWindows2 ? fixWinEPERM(p3, options2, er2, cb) : rmdir(p3, options2, er2, cb);
            if (er2.code === "EISDIR")
              return rmdir(p3, options2, er2, cb);
          }
          return cb(er2);
        });
      });
    }, "rimraf_");
    var fixWinEPERM = /* @__PURE__ */ __name((p3, options2, er, cb) => {
      assert(p3);
      assert(options2);
      assert(typeof cb === "function");
      options2.chmod(p3, 438, (er2) => {
        if (er2)
          cb(er2.code === "ENOENT" ? null : er);
        else
          options2.stat(p3, (er3, stats) => {
            if (er3)
              cb(er3.code === "ENOENT" ? null : er);
            else if (stats.isDirectory())
              rmdir(p3, options2, er, cb);
            else
              options2.unlink(p3, cb);
          });
      });
    }, "fixWinEPERM");
    var fixWinEPERMSync = /* @__PURE__ */ __name((p3, options2, er) => {
      assert(p3);
      assert(options2);
      try {
        options2.chmodSync(p3, 438);
      } catch (er2) {
        if (er2.code === "ENOENT")
          return;
        else
          throw er;
      }
      let stats;
      try {
        stats = options2.statSync(p3);
      } catch (er3) {
        if (er3.code === "ENOENT")
          return;
        else
          throw er;
      }
      if (stats.isDirectory())
        rmdirSync(p3, options2, er);
      else
        options2.unlinkSync(p3);
    }, "fixWinEPERMSync");
    var rmdir = /* @__PURE__ */ __name((p3, options2, originalEr, cb) => {
      assert(p3);
      assert(options2);
      assert(typeof cb === "function");
      options2.rmdir(p3, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM"))
          rmkids(p3, options2, cb);
        else if (er && er.code === "ENOTDIR")
          cb(originalEr);
        else
          cb(er);
      });
    }, "rmdir");
    var rmkids = /* @__PURE__ */ __name((p3, options2, cb) => {
      assert(p3);
      assert(options2);
      assert(typeof cb === "function");
      options2.readdir(p3, (er, files) => {
        if (er)
          return cb(er);
        let n3 = files.length;
        if (n3 === 0)
          return options2.rmdir(p3, cb);
        let errState;
        files.forEach((f3) => {
          rimraf3(path32.join(p3, f3), options2, (er2) => {
            if (errState)
              return;
            if (er2)
              return cb(errState = er2);
            if (--n3 === 0)
              options2.rmdir(p3, cb);
          });
        });
      });
    }, "rmkids");
    var rimrafSync = /* @__PURE__ */ __name((p3, options2) => {
      options2 = options2 || {};
      defaults(options2);
      assert(p3, "rimraf: missing path");
      assert.equal(typeof p3, "string", "rimraf: path should be a string");
      assert(options2, "rimraf: missing options");
      assert.equal(typeof options2, "object", "rimraf: options should be object");
      let results;
      if (options2.disableGlob || !glob.hasMagic(p3)) {
        results = [p3];
      } else {
        try {
          options2.lstatSync(p3);
          results = [p3];
        } catch (er) {
          results = glob.sync(p3, options2.glob);
        }
      }
      if (!results.length)
        return;
      for (let i3 = 0; i3 < results.length; i3++) {
        const p4 = results[i3];
        let st;
        try {
          st = options2.lstatSync(p4);
        } catch (er) {
          if (er.code === "ENOENT")
            return;
          if (er.code === "EPERM" && isWindows2)
            fixWinEPERMSync(p4, options2, er);
        }
        try {
          if (st && st.isDirectory())
            rmdirSync(p4, options2, null);
          else
            options2.unlinkSync(p4);
        } catch (er) {
          if (er.code === "ENOENT")
            return;
          if (er.code === "EPERM")
            return isWindows2 ? fixWinEPERMSync(p4, options2, er) : rmdirSync(p4, options2, er);
          if (er.code !== "EISDIR")
            throw er;
          rmdirSync(p4, options2, er);
        }
      }
    }, "rimrafSync");
    var rmdirSync = /* @__PURE__ */ __name((p3, options2, originalEr) => {
      assert(p3);
      assert(options2);
      try {
        options2.rmdirSync(p3);
      } catch (er) {
        if (er.code === "ENOENT")
          return;
        if (er.code === "ENOTDIR")
          throw originalEr;
        if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")
          rmkidsSync(p3, options2);
      }
    }, "rmdirSync");
    var rmkidsSync = /* @__PURE__ */ __name((p3, options2) => {
      assert(p3);
      assert(options2);
      options2.readdirSync(p3).forEach((f3) => rimrafSync(path32.join(p3, f3), options2));
      const retries = isWindows2 ? 100 : 1;
      let i3 = 0;
      do {
        let threw = true;
        try {
          const ret = options2.rmdirSync(p3, options2);
          threw = false;
          return ret;
        } finally {
          if (++i3 < retries && threw)
            continue;
        }
      } while (true);
    }, "rmkidsSync");
    module2.exports = rimraf3;
    rimraf3.sync = rimrafSync;
  }
});

// ../../node_modules/.pnpm/indent-string@4.0.0/node_modules/indent-string/index.js
var require_indent_string = __commonJS({
  "../../node_modules/.pnpm/indent-string@4.0.0/node_modules/indent-string/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (string, count = 1, options2) => {
      options2 = {
        indent: " ",
        includeEmptyLines: false,
        ...options2
      };
      if (typeof string !== "string") {
        throw new TypeError(
          `Expected \`input\` to be a \`string\`, got \`${typeof string}\``
        );
      }
      if (typeof count !== "number") {
        throw new TypeError(
          `Expected \`count\` to be a \`number\`, got \`${typeof count}\``
        );
      }
      if (typeof options2.indent !== "string") {
        throw new TypeError(
          `Expected \`options.indent\` to be a \`string\`, got \`${typeof options2.indent}\``
        );
      }
      if (count === 0) {
        return string;
      }
      const regex = options2.includeEmptyLines ? /^/gm : /^(?!\s*$)/gm;
      return string.replace(regex, options2.indent.repeat(count));
    };
  }
});

// ../../node_modules/.pnpm/clean-stack@2.2.0/node_modules/clean-stack/index.js
var require_clean_stack = __commonJS({
  "../../node_modules/.pnpm/clean-stack@2.2.0/node_modules/clean-stack/index.js"(exports2, module2) {
    "use strict";
    var os6 = require("os");
    var extractPathRegex = /\s+at.*(?:\(|\s)(.*)\)?/;
    var pathRegex = /^(?:(?:(?:node|(?:internal\/[\w/]*|.*node_modules\/(?:babel-polyfill|pirates)\/.*)?\w+)\.js:\d+:\d+)|native)/;
    var homeDir = typeof os6.homedir === "undefined" ? "" : os6.homedir();
    module2.exports = (stack2, options2) => {
      options2 = Object.assign({ pretty: false }, options2);
      return stack2.replace(/\\/g, "/").split("\n").filter((line) => {
        const pathMatches = line.match(extractPathRegex);
        if (pathMatches === null || !pathMatches[1]) {
          return true;
        }
        const match4 = pathMatches[1];
        if (match4.includes(".app/Contents/Resources/electron.asar") || match4.includes(".app/Contents/Resources/default_app.asar")) {
          return false;
        }
        return !pathRegex.test(match4);
      }).filter((line) => line.trim() !== "").map((line) => {
        if (options2.pretty) {
          return line.replace(extractPathRegex, (m4, p1) => m4.replace(p1, p1.replace(homeDir, "~")));
        }
        return line;
      }).join("\n");
    };
  }
});

// ../../node_modules/.pnpm/aggregate-error@3.1.0/node_modules/aggregate-error/index.js
var require_aggregate_error = __commonJS({
  "../../node_modules/.pnpm/aggregate-error@3.1.0/node_modules/aggregate-error/index.js"(exports2, module2) {
    "use strict";
    var indentString = require_indent_string();
    var cleanStack = require_clean_stack();
    var cleanInternalStack = /* @__PURE__ */ __name((stack2) => stack2.replace(/\s+at .*aggregate-error\/index.js:\d+:\d+\)?/g, ""), "cleanInternalStack");
    var AggregateError = class extends Error {
      constructor(errors) {
        if (!Array.isArray(errors)) {
          throw new TypeError(`Expected input to be an Array, got ${typeof errors}`);
        }
        errors = [...errors].map((error2) => {
          if (error2 instanceof Error) {
            return error2;
          }
          if (error2 !== null && typeof error2 === "object") {
            return Object.assign(new Error(error2.message), error2);
          }
          return new Error(error2);
        });
        let message2 = errors.map((error2) => {
          return typeof error2.stack === "string" ? cleanInternalStack(cleanStack(error2.stack)) : String(error2);
        }).join("\n");
        message2 = "\n" + indentString(message2, 4);
        super(message2);
        this.name = "AggregateError";
        Object.defineProperty(this, "_errors", { value: errors });
      }
      *[Symbol.iterator]() {
        for (const error2 of this._errors) {
          yield error2;
        }
      }
    };
    __name(AggregateError, "AggregateError");
    module2.exports = AggregateError;
  }
});

// ../../node_modules/.pnpm/p-map@4.0.0/node_modules/p-map/index.js
var require_p_map = __commonJS({
  "../../node_modules/.pnpm/p-map@4.0.0/node_modules/p-map/index.js"(exports2, module2) {
    "use strict";
    var AggregateError = require_aggregate_error();
    module2.exports = async (iterable, mapper, {
      concurrency = Infinity,
      stopOnError = true
    } = {}) => {
      return new Promise((resolve2, reject2) => {
        if (typeof mapper !== "function") {
          throw new TypeError("Mapper function is required");
        }
        if (!((Number.isSafeInteger(concurrency) || concurrency === Infinity) && concurrency >= 1)) {
          throw new TypeError(`Expected \`concurrency\` to be an integer from 1 and up or \`Infinity\`, got \`${concurrency}\` (${typeof concurrency})`);
        }
        const result = [];
        const errors = [];
        const iterator = iterable[Symbol.iterator]();
        let isRejected = false;
        let isIterableDone = false;
        let resolvingCount = 0;
        let currentIndex = 0;
        const next = /* @__PURE__ */ __name(() => {
          if (isRejected) {
            return;
          }
          const nextItem = iterator.next();
          const index2 = currentIndex;
          currentIndex++;
          if (nextItem.done) {
            isIterableDone = true;
            if (resolvingCount === 0) {
              if (!stopOnError && errors.length !== 0) {
                reject2(new AggregateError(errors));
              } else {
                resolve2(result);
              }
            }
            return;
          }
          resolvingCount++;
          (async () => {
            try {
              const element = await nextItem.value;
              result[index2] = await mapper(element, index2);
              resolvingCount--;
              next();
            } catch (error2) {
              if (stopOnError) {
                isRejected = true;
                reject2(error2);
              } else {
                errors.push(error2);
                resolvingCount--;
                next();
              }
            }
          })();
        }, "next");
        for (let i3 = 0; i3 < concurrency; i3++) {
          next();
          if (isIterableDone) {
            break;
          }
        }
      });
    };
  }
});

// ../../node_modules/.pnpm/del@6.1.1/node_modules/del/index.js
var require_del = __commonJS({
  "../../node_modules/.pnpm/del@6.1.1/node_modules/del/index.js"(exports2, module2) {
    "use strict";
    var { promisify: promisify12 } = require("util");
    var path32 = require("path");
    var globby2 = require_globby();
    var isGlob = require_is_glob();
    var slash = require_slash();
    var gracefulFs = require_graceful_fs();
    var isPathCwd = require_is_path_cwd();
    var isPathInside = require_is_path_inside();
    var rimraf3 = require_rimraf();
    var pMap3 = require_p_map();
    var rimrafP = promisify12(rimraf3);
    var rimrafOptions = {
      glob: false,
      unlink: gracefulFs.unlink,
      unlinkSync: gracefulFs.unlinkSync,
      chmod: gracefulFs.chmod,
      chmodSync: gracefulFs.chmodSync,
      stat: gracefulFs.stat,
      statSync: gracefulFs.statSync,
      lstat: gracefulFs.lstat,
      lstatSync: gracefulFs.lstatSync,
      rmdir: gracefulFs.rmdir,
      rmdirSync: gracefulFs.rmdirSync,
      readdir: gracefulFs.readdir,
      readdirSync: gracefulFs.readdirSync
    };
    function safeCheck(file2, cwd) {
      if (isPathCwd(file2)) {
        throw new Error("Cannot delete the current working directory. Can be overridden with the `force` option.");
      }
      if (!isPathInside(file2, cwd)) {
        throw new Error("Cannot delete files/directories outside the current working directory. Can be overridden with the `force` option.");
      }
    }
    __name(safeCheck, "safeCheck");
    function normalizePatterns(patterns) {
      patterns = Array.isArray(patterns) ? patterns : [patterns];
      patterns = patterns.map((pattern) => {
        if (process.platform === "win32" && isGlob(pattern) === false) {
          return slash(pattern);
        }
        return pattern;
      });
      return patterns;
    }
    __name(normalizePatterns, "normalizePatterns");
    module2.exports = async (patterns, { force, dryRun, cwd = process.cwd(), onProgress = /* @__PURE__ */ __name(() => {
    }, "onProgress"), ...options2 } = {}) => {
      options2 = {
        expandDirectories: false,
        onlyFiles: false,
        followSymbolicLinks: false,
        cwd,
        ...options2
      };
      patterns = normalizePatterns(patterns);
      const files = (await globby2(patterns, options2)).sort((a3, b3) => b3.localeCompare(a3));
      if (files.length === 0) {
        onProgress({
          totalCount: 0,
          deletedCount: 0,
          percent: 1
        });
      }
      let deletedCount = 0;
      const mapper = /* @__PURE__ */ __name(async (file2) => {
        file2 = path32.resolve(cwd, file2);
        if (!force) {
          safeCheck(file2, cwd);
        }
        if (!dryRun) {
          await rimrafP(file2, rimrafOptions);
        }
        deletedCount += 1;
        onProgress({
          totalCount: files.length,
          deletedCount,
          percent: deletedCount / files.length
        });
        return file2;
      }, "mapper");
      const removedFiles = await pMap3(files, mapper, options2);
      removedFiles.sort((a3, b3) => a3.localeCompare(b3));
      return removedFiles;
    };
    module2.exports.sync = (patterns, { force, dryRun, cwd = process.cwd(), ...options2 } = {}) => {
      options2 = {
        expandDirectories: false,
        onlyFiles: false,
        followSymbolicLinks: false,
        cwd,
        ...options2
      };
      patterns = normalizePatterns(patterns);
      const files = globby2.sync(patterns, options2).sort((a3, b3) => b3.localeCompare(a3));
      const removedFiles = files.map((file2) => {
        file2 = path32.resolve(cwd, file2);
        if (!force) {
          safeCheck(file2, cwd);
        }
        if (!dryRun) {
          rimraf3.sync(file2, rimrafOptions);
        }
        return file2;
      });
      removedFiles.sort((a3, b3) => a3.localeCompare(b3));
      return removedFiles;
    };
  }
});

// ../../node_modules/.pnpm/tempy@1.0.1/node_modules/tempy/index.js
var require_tempy = __commonJS({
  "../../node_modules/.pnpm/tempy@1.0.1/node_modules/tempy/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var path32 = require("path");
    var uniqueString = require_unique_string();
    var tempDir3 = require_temp_dir();
    var isStream = require_is_stream();
    var del3 = require_del();
    var stream3 = require("stream");
    var { promisify: promisify12 } = require("util");
    var pipeline = promisify12(stream3.pipeline);
    var { writeFile: writeFile4 } = fs37.promises;
    var getPath = /* @__PURE__ */ __name((prefix = "") => path32.join(tempDir3, prefix + uniqueString()), "getPath");
    var writeStream = /* @__PURE__ */ __name(async (filePath, data) => pipeline(data, fs37.createWriteStream(filePath)), "writeStream");
    var createTask = /* @__PURE__ */ __name((tempyFunction, { extraArguments = 0 } = {}) => async (...arguments_) => {
      const [callback, options2] = arguments_.slice(extraArguments);
      const result = await tempyFunction(...arguments_.slice(0, extraArguments), options2);
      try {
        return await callback(result);
      } finally {
        await del3(result, { force: true });
      }
    }, "createTask");
    module2.exports.file = (options2) => {
      options2 = {
        ...options2
      };
      if (options2.name) {
        if (options2.extension !== void 0 && options2.extension !== null) {
          throw new Error("The `name` and `extension` options are mutually exclusive");
        }
        return path32.join(module2.exports.directory(), options2.name);
      }
      return getPath() + (options2.extension === void 0 || options2.extension === null ? "" : "." + options2.extension.replace(/^\./, ""));
    };
    module2.exports.file.task = createTask(module2.exports.file);
    module2.exports.directory = ({ prefix = "" } = {}) => {
      const directory = getPath(prefix);
      fs37.mkdirSync(directory);
      return directory;
    };
    module2.exports.directory.task = createTask(module2.exports.directory);
    module2.exports.write = async (data, options2) => {
      const filename = module2.exports.file(options2);
      const write2 = isStream(data) ? writeStream : writeFile4;
      await write2(filename, data);
      return filename;
    };
    module2.exports.write.task = createTask(module2.exports.write, { extraArguments: 1 });
    module2.exports.writeSync = (data, options2) => {
      const filename = module2.exports.file(options2);
      fs37.writeFileSync(filename, data);
      return filename;
    };
    Object.defineProperty(module2.exports, "root", {
      get() {
        return tempDir3;
      }
    });
  }
});

// ../../node_modules/.pnpm/universalify@2.0.0/node_modules/universalify/index.js
var require_universalify = __commonJS({
  "../../node_modules/.pnpm/universalify@2.0.0/node_modules/universalify/index.js"(exports2) {
    "use strict";
    exports2.fromCallback = function(fn2) {
      return Object.defineProperty(function(...args3) {
        if (typeof args3[args3.length - 1] === "function")
          fn2.apply(this, args3);
        else {
          return new Promise((resolve2, reject2) => {
            fn2.call(
              this,
              ...args3,
              (err, res) => err != null ? reject2(err) : resolve2(res)
            );
          });
        }
      }, "name", { value: fn2.name });
    };
    exports2.fromPromise = function(fn2) {
      return Object.defineProperty(function(...args3) {
        const cb = args3[args3.length - 1];
        if (typeof cb !== "function")
          return fn2.apply(this, args3);
        else
          fn2.apply(this, args3.slice(0, -1)).then((r3) => cb(null, r3), cb);
      }, "name", { value: fn2.name });
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/fs/index.js
var require_fs6 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/fs/index.js"(exports2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var fs37 = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs37[key] === "function";
    });
    Object.assign(exports2, fs37);
    api.forEach((method) => {
      exports2[method] = u3(fs37[method]);
    });
    exports2.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs37.exists(filename, callback);
      }
      return new Promise((resolve2) => {
        return fs37.exists(filename, resolve2);
      });
    };
    exports2.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs37.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve2, reject2) => {
        fs37.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject2(err);
          resolve2({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports2.write = function(fd, buffer, ...args3) {
      if (typeof args3[args3.length - 1] === "function") {
        return fs37.write(fd, buffer, ...args3);
      }
      return new Promise((resolve2, reject2) => {
        fs37.write(fd, buffer, ...args3, (err, bytesWritten, buffer2) => {
          if (err)
            return reject2(err);
          resolve2({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    exports2.readv = function(fd, buffers, ...args3) {
      if (typeof args3[args3.length - 1] === "function") {
        return fs37.readv(fd, buffers, ...args3);
      }
      return new Promise((resolve2, reject2) => {
        fs37.readv(fd, buffers, ...args3, (err, bytesRead, buffers2) => {
          if (err)
            return reject2(err);
          resolve2({ bytesRead, buffers: buffers2 });
        });
      });
    };
    exports2.writev = function(fd, buffers, ...args3) {
      if (typeof args3[args3.length - 1] === "function") {
        return fs37.writev(fd, buffers, ...args3);
      }
      return new Promise((resolve2, reject2) => {
        fs37.writev(fd, buffers, ...args3, (err, bytesWritten, buffers2) => {
          if (err)
            return reject2(err);
          resolve2({ bytesWritten, buffers: buffers2 });
        });
      });
    };
    if (typeof fs37.realpath.native === "function") {
      exports2.realpath.native = u3(fs37.realpath.native);
    } else {
      process.emitWarning(
        "fs.realpath.native is not a function. Is fs being monkey-patched?",
        "Warning",
        "fs-extra-WARN0003"
      );
    }
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/utils.js
var require_utils5 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/utils.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    module2.exports.checkPath = /* @__PURE__ */ __name(function checkPath2(pth) {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path32.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error2 = new Error(`Path contains invalid characters: ${pth}`);
          error2.code = "EINVAL";
          throw error2;
        }
      }
    }, "checkPath");
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports2, module2) {
    "use strict";
    var fs37 = require_fs6();
    var { checkPath: checkPath2 } = require_utils5();
    var getMode = /* @__PURE__ */ __name((options2) => {
      const defaults = { mode: 511 };
      if (typeof options2 === "number")
        return options2;
      return { ...defaults, ...options2 }.mode;
    }, "getMode");
    module2.exports.makeDir = async (dir3, options2) => {
      checkPath2(dir3);
      return fs37.mkdir(dir3, {
        mode: getMode(options2),
        recursive: true
      });
    };
    module2.exports.makeDirSync = (dir3, options2) => {
      checkPath2(dir3);
      return fs37.mkdirSync(dir3, {
        mode: getMode(options2),
        recursive: true
      });
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/mkdirs/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir2 = u3(_makeDir);
    module2.exports = {
      mkdirs: makeDir2,
      mkdirsSync: makeDirSync,
      mkdirp: makeDir2,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir2,
      ensureDirSync: makeDirSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/path-exists/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var fs37 = require_fs6();
    function pathExists(path32) {
      return fs37.access(path32).then(() => true).catch(() => false);
    }
    __name(pathExists, "pathExists");
    module2.exports = {
      pathExists: u3(pathExists),
      pathExistsSync: fs37.existsSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/utimes.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    function utimesMillis(path32, atime, mtime, callback) {
      fs37.open(path32, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs37.futimes(fd, atime, mtime, (futimesErr) => {
          fs37.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    __name(utimesMillis, "utimesMillis");
    function utimesMillisSync(path32, atime, mtime) {
      const fd = fs37.openSync(path32, "r+");
      fs37.futimesSync(fd, atime, mtime);
      return fs37.closeSync(fd);
    }
    __name(utimesMillisSync, "utimesMillisSync");
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/util/stat.js"(exports2, module2) {
    "use strict";
    var fs37 = require_fs6();
    var path32 = require("path");
    var util4 = require("util");
    function getStats(src, dest, opts2) {
      const statFunc = opts2.dereference ? (file2) => fs37.stat(file2, { bigint: true }) : (file2) => fs37.lstat(file2, { bigint: true });
      return Promise.all([
        statFunc(src),
        statFunc(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    __name(getStats, "getStats");
    function getStatsSync(src, dest, opts2) {
      let destStat;
      const statFunc = opts2.dereference ? (file2) => fs37.statSync(file2, { bigint: true }) : (file2) => fs37.lstatSync(file2, { bigint: true });
      const srcStat = statFunc(src);
      try {
        destStat = statFunc(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    __name(getStatsSync, "getStatsSync");
    function checkPaths(src, dest, funcName, opts2, cb) {
      util4.callbackify(getStats)(src, dest, opts2, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat) {
          if (areIdentical(srcStat, destStat)) {
            const srcBaseName = path32.basename(src);
            const destBaseName = path32.basename(dest);
            if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
              return cb(null, { srcStat, destStat, isChangingCase: true });
            }
            return cb(new Error("Source and destination must not be the same."));
          }
          if (srcStat.isDirectory() && !destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
          }
          if (!srcStat.isDirectory() && destStat.isDirectory()) {
            return cb(new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`));
          }
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    __name(checkPaths, "checkPaths");
    function checkPathsSync(src, dest, funcName, opts2) {
      const { srcStat, destStat } = getStatsSync(src, dest, opts2);
      if (destStat) {
        if (areIdentical(srcStat, destStat)) {
          const srcBaseName = path32.basename(src);
          const destBaseName = path32.basename(dest);
          if (funcName === "move" && srcBaseName !== destBaseName && srcBaseName.toLowerCase() === destBaseName.toLowerCase()) {
            return { srcStat, destStat, isChangingCase: true };
          }
          throw new Error("Source and destination must not be the same.");
        }
        if (srcStat.isDirectory() && !destStat.isDirectory()) {
          throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
        }
        if (!srcStat.isDirectory() && destStat.isDirectory()) {
          throw new Error(`Cannot overwrite directory '${dest}' with non-directory '${src}'.`);
        }
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    __name(checkPathsSync, "checkPathsSync");
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path32.resolve(path32.dirname(src));
      const destParent = path32.resolve(path32.dirname(dest));
      if (destParent === srcParent || destParent === path32.parse(destParent).root)
        return cb();
      fs37.stat(destParent, { bigint: true }, (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      });
    }
    __name(checkParentPaths, "checkParentPaths");
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path32.resolve(path32.dirname(src));
      const destParent = path32.resolve(path32.dirname(dest));
      if (destParent === srcParent || destParent === path32.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = fs37.statSync(destParent, { bigint: true });
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    __name(checkParentPathsSync, "checkParentPathsSync");
    function areIdentical(srcStat, destStat) {
      return destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev;
    }
    __name(areIdentical, "areIdentical");
    function isSrcSubdir(src, dest) {
      const srcArr = path32.resolve(src).split(path32.sep).filter((i3) => i3);
      const destArr = path32.resolve(dest).split(path32.sep).filter((i3) => i3);
      return srcArr.reduce((acc, cur, i3) => acc && destArr[i3] === cur, true);
    }
    __name(isSrcSubdir, "isSrcSubdir");
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    __name(errMsg, "errMsg");
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir,
      areIdentical
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    var path32 = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists = require_path_exists2().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat2 = require_stat();
    function copy(src, dest, opts2, cb) {
      if (typeof opts2 === "function" && !cb) {
        cb = opts2;
        opts2 = {};
      } else if (typeof opts2 === "function") {
        opts2 = { filter: opts2 };
      }
      cb = cb || function() {
      };
      opts2 = opts2 || {};
      opts2.clobber = "clobber" in opts2 ? !!opts2.clobber : true;
      opts2.overwrite = "overwrite" in opts2 ? !!opts2.overwrite : opts2.clobber;
      if (opts2.preserveTimestamps && process.arch === "ia32") {
        process.emitWarning(
          "Using the preserveTimestamps option in 32-bit node is not recommended;\n\n	see https://github.com/jprichardson/node-fs-extra/issues/269",
          "Warning",
          "fs-extra-WARN0001"
        );
      }
      stat2.checkPaths(src, dest, "copy", opts2, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat2.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          runFilter(src, dest, opts2, (err3, include) => {
            if (err3)
              return cb(err3);
            if (!include)
              return cb();
            checkParentDir(destStat, src, dest, opts2, cb);
          });
        });
      });
    }
    __name(copy, "copy");
    function checkParentDir(destStat, src, dest, opts2, cb) {
      const destParent = path32.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return getStats(destStat, src, dest, opts2, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return getStats(destStat, src, dest, opts2, cb);
        });
      });
    }
    __name(checkParentDir, "checkParentDir");
    function runFilter(src, dest, opts2, cb) {
      if (!opts2.filter)
        return cb(null, true);
      Promise.resolve(opts2.filter(src, dest)).then((include) => cb(null, include), (error2) => cb(error2));
    }
    __name(runFilter, "runFilter");
    function getStats(destStat, src, dest, opts2, cb) {
      const stat3 = opts2.dereference ? fs37.stat : fs37.lstat;
      stat3(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts2, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts2, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts2, cb);
        else if (srcStat.isSocket())
          return cb(new Error(`Cannot copy a socket file: ${src}`));
        else if (srcStat.isFIFO())
          return cb(new Error(`Cannot copy a FIFO pipe: ${src}`));
        return cb(new Error(`Unknown file: ${src}`));
      });
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts2, cb) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts2, cb);
      return mayCopyFile(srcStat, src, dest, opts2, cb);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts2, cb) {
      if (opts2.overwrite) {
        fs37.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile(srcStat, src, dest, opts2, cb);
        });
      } else if (opts2.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile(srcStat, src, dest, opts2, cb) {
      fs37.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts2.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    __name(copyFile, "copyFile");
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    __name(handleTimestampsAndMode, "handleTimestampsAndMode");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    __name(setDestTimestampsAndMode, "setDestTimestampsAndMode");
    function setDestMode(dest, srcMode, cb) {
      return fs37.chmod(dest, srcMode, cb);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest, cb) {
      fs37.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts2, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts2, cb);
      return copyDir(src, dest, opts2, cb);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts2, cb) {
      fs37.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts2, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts2, cb) {
      fs37.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts2, cb);
      });
    }
    __name(copyDir, "copyDir");
    function copyDirItems(items, src, dest, opts2, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts2, cb);
    }
    __name(copyDirItems, "copyDirItems");
    function copyDirItem(items, item, src, dest, opts2, cb) {
      const srcItem = path32.join(src, item);
      const destItem = path32.join(dest, item);
      runFilter(srcItem, destItem, opts2, (err, include) => {
        if (err)
          return cb(err);
        if (!include)
          return copyDirItems(items, src, dest, opts2, cb);
        stat2.checkPaths(srcItem, destItem, "copy", opts2, (err2, stats) => {
          if (err2)
            return cb(err2);
          const { destStat } = stats;
          getStats(destStat, srcItem, destItem, opts2, (err3) => {
            if (err3)
              return cb(err3);
            return copyDirItems(items, src, dest, opts2, cb);
          });
        });
      });
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts2, cb) {
      fs37.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts2.dereference) {
          resolvedSrc = path32.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs37.symlink(resolvedSrc, dest, cb);
        } else {
          fs37.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs37.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts2.dereference) {
              resolvedDest = path32.resolve(process.cwd(), resolvedDest);
            }
            if (stat2.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (stat2.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest, cb) {
      fs37.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs37.symlink(resolvedSrc, dest, cb);
      });
    }
    __name(copyLink, "copyLink");
    module2.exports = copy;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy-sync.js
var require_copy_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/copy-sync.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    var path32 = require("path");
    var mkdirsSync = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat2 = require_stat();
    function copySync(src, dest, opts2) {
      if (typeof opts2 === "function") {
        opts2 = { filter: opts2 };
      }
      opts2 = opts2 || {};
      opts2.clobber = "clobber" in opts2 ? !!opts2.clobber : true;
      opts2.overwrite = "overwrite" in opts2 ? !!opts2.overwrite : opts2.clobber;
      if (opts2.preserveTimestamps && process.arch === "ia32") {
        process.emitWarning(
          "Using the preserveTimestamps option in 32-bit node is not recommended;\n\n	see https://github.com/jprichardson/node-fs-extra/issues/269",
          "Warning",
          "fs-extra-WARN0002"
        );
      }
      const { srcStat, destStat } = stat2.checkPathsSync(src, dest, "copy", opts2);
      stat2.checkParentPathsSync(src, srcStat, dest, "copy");
      if (opts2.filter && !opts2.filter(src, dest))
        return;
      const destParent = path32.dirname(dest);
      if (!fs37.existsSync(destParent))
        mkdirsSync(destParent);
      return getStats(destStat, src, dest, opts2);
    }
    __name(copySync, "copySync");
    function getStats(destStat, src, dest, opts2) {
      const statSync2 = opts2.dereference ? fs37.statSync : fs37.lstatSync;
      const srcStat = statSync2(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts2);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts2);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts2);
      else if (srcStat.isSocket())
        throw new Error(`Cannot copy a socket file: ${src}`);
      else if (srcStat.isFIFO())
        throw new Error(`Cannot copy a FIFO pipe: ${src}`);
      throw new Error(`Unknown file: ${src}`);
    }
    __name(getStats, "getStats");
    function onFile(srcStat, destStat, src, dest, opts2) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts2);
      return mayCopyFile(srcStat, src, dest, opts2);
    }
    __name(onFile, "onFile");
    function mayCopyFile(srcStat, src, dest, opts2) {
      if (opts2.overwrite) {
        fs37.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts2);
      } else if (opts2.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    __name(mayCopyFile, "mayCopyFile");
    function copyFile(srcStat, src, dest, opts2) {
      fs37.copyFileSync(src, dest);
      if (opts2.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    __name(copyFile, "copyFile");
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    __name(handleTimestamps, "handleTimestamps");
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    __name(fileIsNotWritable, "fileIsNotWritable");
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    __name(makeFileWritable, "makeFileWritable");
    function setDestMode(dest, srcMode) {
      return fs37.chmodSync(dest, srcMode);
    }
    __name(setDestMode, "setDestMode");
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs37.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    __name(setDestTimestamps, "setDestTimestamps");
    function onDir(srcStat, destStat, src, dest, opts2) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts2);
      return copyDir(src, dest, opts2);
    }
    __name(onDir, "onDir");
    function mkDirAndCopy(srcMode, src, dest, opts2) {
      fs37.mkdirSync(dest);
      copyDir(src, dest, opts2);
      return setDestMode(dest, srcMode);
    }
    __name(mkDirAndCopy, "mkDirAndCopy");
    function copyDir(src, dest, opts2) {
      fs37.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts2));
    }
    __name(copyDir, "copyDir");
    function copyDirItem(item, src, dest, opts2) {
      const srcItem = path32.join(src, item);
      const destItem = path32.join(dest, item);
      if (opts2.filter && !opts2.filter(srcItem, destItem))
        return;
      const { destStat } = stat2.checkPathsSync(srcItem, destItem, "copy", opts2);
      return getStats(destStat, srcItem, destItem, opts2);
    }
    __name(copyDirItem, "copyDirItem");
    function onLink(destStat, src, dest, opts2) {
      let resolvedSrc = fs37.readlinkSync(src);
      if (opts2.dereference) {
        resolvedSrc = path32.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs37.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs37.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs37.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts2.dereference) {
          resolvedDest = path32.resolve(process.cwd(), resolvedDest);
        }
        if (stat2.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (stat2.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    __name(onLink, "onLink");
    function copyLink(resolvedSrc, dest) {
      fs37.unlinkSync(dest);
      return fs37.symlinkSync(resolvedSrc, dest);
    }
    __name(copyLink, "copyLink");
    module2.exports = copySync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/copy/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    module2.exports = {
      copy: u3(require_copy()),
      copySync: require_copy_sync()
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/remove/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    var u3 = require_universalify().fromCallback;
    function remove(path32, callback) {
      fs37.rm(path32, { recursive: true, force: true }, callback);
    }
    __name(remove, "remove");
    function removeSync(path32) {
      fs37.rmSync(path32, { recursive: true, force: true });
    }
    __name(removeSync, "removeSync");
    module2.exports = {
      remove: u3(remove),
      removeSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/empty/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var fs37 = require_fs6();
    var path32 = require("path");
    var mkdir2 = require_mkdirs();
    var remove = require_remove();
    var emptyDir = u3(/* @__PURE__ */ __name(async function emptyDir2(dir3) {
      let items;
      try {
        items = await fs37.readdir(dir3);
      } catch {
        return mkdir2.mkdirs(dir3);
      }
      return Promise.all(items.map((item) => remove.remove(path32.join(dir3, item))));
    }, "emptyDir"));
    function emptyDirSync(dir3) {
      let items;
      try {
        items = fs37.readdirSync(dir3);
      } catch {
        return mkdir2.mkdirsSync(dir3);
      }
      items.forEach((item) => {
        item = path32.join(dir3, item);
        remove.removeSync(item);
      });
    }
    __name(emptyDirSync, "emptyDirSync");
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/file.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path32 = require("path");
    var fs37 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    function createFile(file2, callback) {
      function makeFile() {
        fs37.writeFile(file2, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      __name(makeFile, "makeFile");
      fs37.stat(file2, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir3 = path32.dirname(file2);
        fs37.stat(dir3, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir2.mkdirs(dir3, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs37.readdir(dir3, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    __name(createFile, "createFile");
    function createFileSync(file2) {
      let stats;
      try {
        stats = fs37.statSync(file2);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir3 = path32.dirname(file2);
      try {
        if (!fs37.statSync(dir3).isDirectory()) {
          fs37.readdirSync(dir3);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir2.mkdirsSync(dir3);
        else
          throw err;
      }
      fs37.writeFileSync(file2, "");
    }
    __name(createFileSync, "createFileSync");
    module2.exports = {
      createFile: u3(createFile),
      createFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/link.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path32 = require("path");
    var fs37 = require_graceful_fs();
    var mkdir2 = require_mkdirs();
    var pathExists = require_path_exists2().pathExists;
    var { areIdentical } = require_stat();
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs37.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      __name(makeLink, "makeLink");
      fs37.lstat(dstpath, (_2, dstStat) => {
        fs37.lstat(srcpath, (err, srcStat) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureLink");
            return callback(err);
          }
          if (dstStat && areIdentical(srcStat, dstStat))
            return callback(null);
          const dir3 = path32.dirname(dstpath);
          pathExists(dir3, (err2, dirExists) => {
            if (err2)
              return callback(err2);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir2.mkdirs(dir3, (err3) => {
              if (err3)
                return callback(err3);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    __name(createLink, "createLink");
    function createLinkSync(srcpath, dstpath) {
      let dstStat;
      try {
        dstStat = fs37.lstatSync(dstpath);
      } catch {
      }
      try {
        const srcStat = fs37.lstatSync(srcpath);
        if (dstStat && areIdentical(srcStat, dstStat))
          return;
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir3 = path32.dirname(dstpath);
      const dirExists = fs37.existsSync(dir3);
      if (dirExists)
        return fs37.linkSync(srcpath, dstpath);
      mkdir2.mkdirsSync(dir3);
      return fs37.linkSync(srcpath, dstpath);
    }
    __name(createLinkSync, "createLinkSync");
    module2.exports = {
      createLink: u3(createLink),
      createLinkSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var fs37 = require_graceful_fs();
    var pathExists = require_path_exists2().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path32.isAbsolute(srcpath)) {
        return fs37.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path32.dirname(dstpath);
        const relativeToDst = path32.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists6) => {
          if (err)
            return callback(err);
          if (exists6) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs37.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path32.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    __name(symlinkPaths, "symlinkPaths");
    function symlinkPathsSync(srcpath, dstpath) {
      let exists6;
      if (path32.isAbsolute(srcpath)) {
        exists6 = fs37.existsSync(srcpath);
        if (!exists6)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path32.dirname(dstpath);
        const relativeToDst = path32.join(dstdir, srcpath);
        exists6 = fs37.existsSync(relativeToDst);
        if (exists6) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists6 = fs37.existsSync(srcpath);
          if (!exists6)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path32.relative(dstdir, srcpath)
          };
        }
      }
    }
    __name(symlinkPathsSync, "symlinkPathsSync");
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs37.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    __name(symlinkType, "symlinkType");
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs37.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    __name(symlinkTypeSync, "symlinkTypeSync");
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/symlink.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var path32 = require("path");
    var fs37 = require_fs6();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists2().pathExists;
    var { areIdentical } = require_stat();
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      fs37.lstat(dstpath, (err, stats) => {
        if (!err && stats.isSymbolicLink()) {
          Promise.all([
            fs37.stat(srcpath),
            fs37.stat(dstpath)
          ]).then(([srcStat, dstStat]) => {
            if (areIdentical(srcStat, dstStat))
              return callback(null);
            _createSymlink(srcpath, dstpath, type, callback);
          });
        } else
          _createSymlink(srcpath, dstpath, type, callback);
      });
    }
    __name(createSymlink, "createSymlink");
    function _createSymlink(srcpath, dstpath, type, callback) {
      symlinkPaths(srcpath, dstpath, (err, relative2) => {
        if (err)
          return callback(err);
        srcpath = relative2.toDst;
        symlinkType(relative2.toCwd, type, (err2, type2) => {
          if (err2)
            return callback(err2);
          const dir3 = path32.dirname(dstpath);
          pathExists(dir3, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return fs37.symlink(srcpath, dstpath, type2, callback);
            mkdirs(dir3, (err4) => {
              if (err4)
                return callback(err4);
              fs37.symlink(srcpath, dstpath, type2, callback);
            });
          });
        });
      });
    }
    __name(_createSymlink, "_createSymlink");
    function createSymlinkSync(srcpath, dstpath, type) {
      let stats;
      try {
        stats = fs37.lstatSync(dstpath);
      } catch {
      }
      if (stats && stats.isSymbolicLink()) {
        const srcStat = fs37.statSync(srcpath);
        const dstStat = fs37.statSync(dstpath);
        if (areIdentical(srcStat, dstStat))
          return;
      }
      const relative2 = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative2.toDst;
      type = symlinkTypeSync(relative2.toCwd, type);
      const dir3 = path32.dirname(dstpath);
      const exists6 = fs37.existsSync(dir3);
      if (exists6)
        return fs37.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir3);
      return fs37.symlinkSync(srcpath, dstpath, type);
    }
    __name(createSymlinkSync, "createSymlinkSync");
    module2.exports = {
      createSymlink: u3(createSymlink),
      createSymlinkSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/ensure/index.js"(exports2, module2) {
    "use strict";
    var { createFile, createFileSync } = require_file();
    var { createLink, createLinkSync } = require_link();
    var { createSymlink, createSymlinkSync } = require_symlink();
    module2.exports = {
      createFile,
      createFileSync,
      ensureFile: createFile,
      ensureFileSync: createFileSync,
      createLink,
      createLinkSync,
      ensureLink: createLink,
      ensureLinkSync: createLinkSync,
      createSymlink,
      createSymlinkSync,
      ensureSymlink: createSymlink,
      ensureSymlinkSync: createSymlinkSync
    };
  }
});

// ../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/utils.js
var require_utils6 = __commonJS({
  "../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/utils.js"(exports2, module2) {
    function stringify2(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    __name(stringify2, "stringify");
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    __name(stripBom, "stripBom");
    module2.exports = { stringify: stringify2, stripBom };
  }
});

// ../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "../../node_modules/.pnpm/jsonfile@6.1.0/node_modules/jsonfile/index.js"(exports2, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_2) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify: stringify2, stripBom } = require_utils6();
    async function _readFile(file2, options2 = {}) {
      if (typeof options2 === "string") {
        options2 = { encoding: options2 };
      }
      const fs37 = options2.fs || _fs;
      const shouldThrow = "throws" in options2 ? options2.throws : true;
      let data = await universalify.fromCallback(fs37.readFile)(file2, options2);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options2 ? options2.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file2}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    __name(_readFile, "_readFile");
    var readFile7 = universalify.fromPromise(_readFile);
    function readFileSync(file2, options2 = {}) {
      if (typeof options2 === "string") {
        options2 = { encoding: options2 };
      }
      const fs37 = options2.fs || _fs;
      const shouldThrow = "throws" in options2 ? options2.throws : true;
      try {
        let content = fs37.readFileSync(file2, options2);
        content = stripBom(content);
        return JSON.parse(content, options2.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file2}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    __name(readFileSync, "readFileSync");
    async function _writeFile(file2, obj, options2 = {}) {
      const fs37 = options2.fs || _fs;
      const str = stringify2(obj, options2);
      await universalify.fromCallback(fs37.writeFile)(file2, str, options2);
    }
    __name(_writeFile, "_writeFile");
    var writeFile4 = universalify.fromPromise(_writeFile);
    function writeFileSync(file2, obj, options2 = {}) {
      const fs37 = options2.fs || _fs;
      const str = stringify2(obj, options2);
      return fs37.writeFileSync(file2, str, options2);
    }
    __name(writeFileSync, "writeFileSync");
    var jsonfile = {
      readFile: readFile7,
      readFileSync,
      writeFile: writeFile4,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/jsonfile.js"(exports2, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/output-file/index.js
var require_output_file = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/output-file/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    var fs37 = require_graceful_fs();
    var path32 = require("path");
    var mkdir2 = require_mkdirs();
    var pathExists = require_path_exists2().pathExists;
    function outputFile(file2, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir3 = path32.dirname(file2);
      pathExists(dir3, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs37.writeFile(file2, data, encoding, callback);
        mkdir2.mkdirs(dir3, (err2) => {
          if (err2)
            return callback(err2);
          fs37.writeFile(file2, data, encoding, callback);
        });
      });
    }
    __name(outputFile, "outputFile");
    function outputFileSync(file2, ...args3) {
      const dir3 = path32.dirname(file2);
      if (fs37.existsSync(dir3)) {
        return fs37.writeFileSync(file2, ...args3);
      }
      mkdir2.mkdirsSync(dir3);
      fs37.writeFileSync(file2, ...args3);
    }
    __name(outputFileSync, "outputFileSync");
    module2.exports = {
      outputFile: u3(outputFile),
      outputFileSync
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils6();
    var { outputFile } = require_output_file();
    async function outputJson(file2, data, options2 = {}) {
      const str = stringify2(data, options2);
      await outputFile(file2, str, options2);
    }
    __name(outputJson, "outputJson");
    module2.exports = outputJson;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/output-json-sync.js"(exports2, module2) {
    "use strict";
    var { stringify: stringify2 } = require_utils6();
    var { outputFileSync } = require_output_file();
    function outputJsonSync(file2, data, options2) {
      const str = stringify2(data, options2);
      outputFileSync(file2, str, options2);
    }
    __name(outputJsonSync, "outputJsonSync");
    module2.exports = outputJsonSync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/json/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u3(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    var path32 = require("path");
    var copy = require_copy2().copy;
    var remove = require_remove().remove;
    var mkdirp = require_mkdirs().mkdirp;
    var pathExists = require_path_exists2().pathExists;
    var stat2 = require_stat();
    function move(src, dest, opts2, cb) {
      if (typeof opts2 === "function") {
        cb = opts2;
        opts2 = {};
      }
      opts2 = opts2 || {};
      const overwrite = opts2.overwrite || opts2.clobber || false;
      stat2.checkPaths(src, dest, "move", opts2, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, isChangingCase = false } = stats;
        stat2.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          if (isParentRoot(dest))
            return doRename(src, dest, overwrite, isChangingCase, cb);
          mkdirp(path32.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, isChangingCase, cb);
          });
        });
      });
    }
    __name(move, "move");
    function isParentRoot(dest) {
      const parent2 = path32.dirname(dest);
      const parsedPath = path32.parse(parent2);
      return parsedPath.root === parent2;
    }
    __name(isParentRoot, "isParentRoot");
    function doRename(src, dest, overwrite, isChangingCase, cb) {
      if (isChangingCase)
        return rename2(src, dest, overwrite, cb);
      if (overwrite) {
        return remove(dest, (err) => {
          if (err)
            return cb(err);
          return rename2(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename2(src, dest, overwrite, cb);
      });
    }
    __name(doRename, "doRename");
    function rename2(src, dest, overwrite, cb) {
      fs37.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    __name(rename2, "rename");
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts2 = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts2, (err) => {
        if (err)
          return cb(err);
        return remove(src, cb);
      });
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = move;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move-sync.js
var require_move_sync = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/move-sync.js"(exports2, module2) {
    "use strict";
    var fs37 = require_graceful_fs();
    var path32 = require("path");
    var copySync = require_copy2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync = require_mkdirs().mkdirpSync;
    var stat2 = require_stat();
    function moveSync(src, dest, opts2) {
      opts2 = opts2 || {};
      const overwrite = opts2.overwrite || opts2.clobber || false;
      const { srcStat, isChangingCase = false } = stat2.checkPathsSync(src, dest, "move", opts2);
      stat2.checkParentPathsSync(src, srcStat, dest, "move");
      if (!isParentRoot(dest))
        mkdirpSync(path32.dirname(dest));
      return doRename(src, dest, overwrite, isChangingCase);
    }
    __name(moveSync, "moveSync");
    function isParentRoot(dest) {
      const parent2 = path32.dirname(dest);
      const parsedPath = path32.parse(parent2);
      return parsedPath.root === parent2;
    }
    __name(isParentRoot, "isParentRoot");
    function doRename(src, dest, overwrite, isChangingCase) {
      if (isChangingCase)
        return rename2(src, dest, overwrite);
      if (overwrite) {
        removeSync(dest);
        return rename2(src, dest, overwrite);
      }
      if (fs37.existsSync(dest))
        throw new Error("dest already exists.");
      return rename2(src, dest, overwrite);
    }
    __name(doRename, "doRename");
    function rename2(src, dest, overwrite) {
      try {
        fs37.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    __name(rename2, "rename");
    function moveAcrossDevice(src, dest, overwrite) {
      const opts2 = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts2);
      return removeSync(src);
    }
    __name(moveAcrossDevice, "moveAcrossDevice");
    module2.exports = moveSync;
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/move/index.js"(exports2, module2) {
    "use strict";
    var u3 = require_universalify().fromCallback;
    module2.exports = {
      move: u3(require_move()),
      moveSync: require_move_sync()
    };
  }
});

// ../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/index.js
var require_lib4 = __commonJS({
  "../../node_modules/.pnpm/fs-extra@11.1.0/node_modules/fs-extra/lib/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      ...require_fs6(),
      ...require_copy2(),
      ...require_empty(),
      ...require_ensure(),
      ...require_json(),
      ...require_mkdirs(),
      ...require_move2(),
      ...require_output_file(),
      ...require_path_exists2(),
      ...require_remove()
    };
  }
});

// ../../node_modules/.pnpm/p-map@2.1.0/node_modules/p-map/index.js
var require_p_map2 = __commonJS({
  "../../node_modules/.pnpm/p-map@2.1.0/node_modules/p-map/index.js"(exports2, module2) {
    "use strict";
    var pMap3 = /* @__PURE__ */ __name((iterable, mapper, options2) => new Promise((resolve2, reject2) => {
      options2 = Object.assign({
        concurrency: Infinity
      }, options2);
      if (typeof mapper !== "function") {
        throw new TypeError("Mapper function is required");
      }
      const { concurrency } = options2;
      if (!(typeof concurrency === "number" && concurrency >= 1)) {
        throw new TypeError(`Expected \`concurrency\` to be a number from 1 and up, got \`${concurrency}\` (${typeof concurrency})`);
      }
      const ret = [];
      const iterator = iterable[Symbol.iterator]();
      let isRejected = false;
      let isIterableDone = false;
      let resolvingCount = 0;
      let currentIndex = 0;
      const next = /* @__PURE__ */ __name(() => {
        if (isRejected) {
          return;
        }
        const nextItem = iterator.next();
        const i3 = currentIndex;
        currentIndex++;
        if (nextItem.done) {
          isIterableDone = true;
          if (resolvingCount === 0) {
            resolve2(ret);
          }
          return;
        }
        resolvingCount++;
        Promise.resolve(nextItem.value).then((element) => mapper(element, i3)).then(
          (value) => {
            ret[i3] = value;
            resolvingCount--;
            next();
          },
          (error2) => {
            isRejected = true;
            reject2(error2);
          }
        );
      }, "next");
      for (let i3 = 0; i3 < concurrency; i3++) {
        next();
        if (isIterableDone) {
          break;
        }
      }
    }), "pMap");
    module2.exports = pMap3;
    module2.exports.default = pMap3;
  }
});

// ../../node_modules/.pnpm/p-filter@2.1.0/node_modules/p-filter/index.js
var require_p_filter = __commonJS({
  "../../node_modules/.pnpm/p-filter@2.1.0/node_modules/p-filter/index.js"(exports2, module2) {
    "use strict";
    var pMap3 = require_p_map2();
    var pFilter2 = /* @__PURE__ */ __name(async (iterable, filterer, options2) => {
      const values = await pMap3(
        iterable,
        (element, index2) => Promise.all([filterer(element, index2), element]),
        options2
      );
      return values.filter((value) => Boolean(value[0])).map((value) => value[1]);
    }, "pFilter");
    module2.exports = pFilter2;
    module2.exports.default = pFilter2;
  }
});

// ../../node_modules/.pnpm/commondir@1.0.1/node_modules/commondir/index.js
var require_commondir = __commonJS({
  "../../node_modules/.pnpm/commondir@1.0.1/node_modules/commondir/index.js"(exports2, module2) {
    var path32 = require("path");
    module2.exports = function(basedir, relfiles) {
      if (relfiles) {
        var files = relfiles.map(function(r3) {
          return path32.resolve(basedir, r3);
        });
      } else {
        var files = basedir;
      }
      var res = files.slice(1).reduce(function(ps, file2) {
        if (!file2.match(/^([A-Za-z]:)?\/|\\/)) {
          throw new Error("relative path without a basedir");
        }
        var xs = file2.split(/\/+|\\+/);
        for (var i3 = 0; ps[i3] === xs[i3] && i3 < Math.min(ps.length, xs.length); i3++)
          ;
        return ps.slice(0, i3);
      }, files[0].split(/\/+|\\+/));
      return res.length > 1 ? res.join("/") : "/";
    };
  }
});

// ../../node_modules/.pnpm/pkg-dir@4.2.0/node_modules/pkg-dir/index.js
var require_pkg_dir = __commonJS({
  "../../node_modules/.pnpm/pkg-dir@4.2.0/node_modules/pkg-dir/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var findUp2 = require_find_up2();
    var pkgDir = /* @__PURE__ */ __name(async (cwd) => {
      const filePath = await findUp2("package.json", { cwd });
      return filePath && path32.dirname(filePath);
    }, "pkgDir");
    module2.exports = pkgDir;
    module2.exports.default = pkgDir;
    module2.exports.sync = (cwd) => {
      const filePath = findUp2.sync("package.json", { cwd });
      return filePath && path32.dirname(filePath);
    };
  }
});

// ../../node_modules/.pnpm/semver@6.3.0/node_modules/semver/semver.js
var require_semver2 = __commonJS({
  "../../node_modules/.pnpm/semver@6.3.0/node_modules/semver/semver.js"(exports2, module2) {
    exports2 = module2.exports = SemVer;
    var debug27;
    if (typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG)) {
      debug27 = /* @__PURE__ */ __name(function() {
        var args3 = Array.prototype.slice.call(arguments, 0);
        args3.unshift("SEMVER");
        console.log.apply(console, args3);
      }, "debug");
    } else {
      debug27 = /* @__PURE__ */ __name(function() {
      }, "debug");
    }
    exports2.SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var re = exports2.re = [];
    var src = exports2.src = [];
    var t5 = exports2.tokens = {};
    var R = 0;
    function tok(n3) {
      t5[n3] = R++;
    }
    __name(tok, "tok");
    tok("NUMERICIDENTIFIER");
    src[t5.NUMERICIDENTIFIER] = "0|[1-9]\\d*";
    tok("NUMERICIDENTIFIERLOOSE");
    src[t5.NUMERICIDENTIFIERLOOSE] = "[0-9]+";
    tok("NONNUMERICIDENTIFIER");
    src[t5.NONNUMERICIDENTIFIER] = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
    tok("MAINVERSION");
    src[t5.MAINVERSION] = "(" + src[t5.NUMERICIDENTIFIER] + ")\\.(" + src[t5.NUMERICIDENTIFIER] + ")\\.(" + src[t5.NUMERICIDENTIFIER] + ")";
    tok("MAINVERSIONLOOSE");
    src[t5.MAINVERSIONLOOSE] = "(" + src[t5.NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[t5.NUMERICIDENTIFIERLOOSE] + ")\\.(" + src[t5.NUMERICIDENTIFIERLOOSE] + ")";
    tok("PRERELEASEIDENTIFIER");
    src[t5.PRERELEASEIDENTIFIER] = "(?:" + src[t5.NUMERICIDENTIFIER] + "|" + src[t5.NONNUMERICIDENTIFIER] + ")";
    tok("PRERELEASEIDENTIFIERLOOSE");
    src[t5.PRERELEASEIDENTIFIERLOOSE] = "(?:" + src[t5.NUMERICIDENTIFIERLOOSE] + "|" + src[t5.NONNUMERICIDENTIFIER] + ")";
    tok("PRERELEASE");
    src[t5.PRERELEASE] = "(?:-(" + src[t5.PRERELEASEIDENTIFIER] + "(?:\\." + src[t5.PRERELEASEIDENTIFIER] + ")*))";
    tok("PRERELEASELOOSE");
    src[t5.PRERELEASELOOSE] = "(?:-?(" + src[t5.PRERELEASEIDENTIFIERLOOSE] + "(?:\\." + src[t5.PRERELEASEIDENTIFIERLOOSE] + ")*))";
    tok("BUILDIDENTIFIER");
    src[t5.BUILDIDENTIFIER] = "[0-9A-Za-z-]+";
    tok("BUILD");
    src[t5.BUILD] = "(?:\\+(" + src[t5.BUILDIDENTIFIER] + "(?:\\." + src[t5.BUILDIDENTIFIER] + ")*))";
    tok("FULL");
    tok("FULLPLAIN");
    src[t5.FULLPLAIN] = "v?" + src[t5.MAINVERSION] + src[t5.PRERELEASE] + "?" + src[t5.BUILD] + "?";
    src[t5.FULL] = "^" + src[t5.FULLPLAIN] + "$";
    tok("LOOSEPLAIN");
    src[t5.LOOSEPLAIN] = "[v=\\s]*" + src[t5.MAINVERSIONLOOSE] + src[t5.PRERELEASELOOSE] + "?" + src[t5.BUILD] + "?";
    tok("LOOSE");
    src[t5.LOOSE] = "^" + src[t5.LOOSEPLAIN] + "$";
    tok("GTLT");
    src[t5.GTLT] = "((?:<|>)?=?)";
    tok("XRANGEIDENTIFIERLOOSE");
    src[t5.XRANGEIDENTIFIERLOOSE] = src[t5.NUMERICIDENTIFIERLOOSE] + "|x|X|\\*";
    tok("XRANGEIDENTIFIER");
    src[t5.XRANGEIDENTIFIER] = src[t5.NUMERICIDENTIFIER] + "|x|X|\\*";
    tok("XRANGEPLAIN");
    src[t5.XRANGEPLAIN] = "[v=\\s]*(" + src[t5.XRANGEIDENTIFIER] + ")(?:\\.(" + src[t5.XRANGEIDENTIFIER] + ")(?:\\.(" + src[t5.XRANGEIDENTIFIER] + ")(?:" + src[t5.PRERELEASE] + ")?" + src[t5.BUILD] + "?)?)?";
    tok("XRANGEPLAINLOOSE");
    src[t5.XRANGEPLAINLOOSE] = "[v=\\s]*(" + src[t5.XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[t5.XRANGEIDENTIFIERLOOSE] + ")(?:\\.(" + src[t5.XRANGEIDENTIFIERLOOSE] + ")(?:" + src[t5.PRERELEASELOOSE] + ")?" + src[t5.BUILD] + "?)?)?";
    tok("XRANGE");
    src[t5.XRANGE] = "^" + src[t5.GTLT] + "\\s*" + src[t5.XRANGEPLAIN] + "$";
    tok("XRANGELOOSE");
    src[t5.XRANGELOOSE] = "^" + src[t5.GTLT] + "\\s*" + src[t5.XRANGEPLAINLOOSE] + "$";
    tok("COERCE");
    src[t5.COERCE] = "(^|[^\\d])(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "})(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:\\.(\\d{1," + MAX_SAFE_COMPONENT_LENGTH + "}))?(?:$|[^\\d])";
    tok("COERCERTL");
    re[t5.COERCERTL] = new RegExp(src[t5.COERCE], "g");
    tok("LONETILDE");
    src[t5.LONETILDE] = "(?:~>?)";
    tok("TILDETRIM");
    src[t5.TILDETRIM] = "(\\s*)" + src[t5.LONETILDE] + "\\s+";
    re[t5.TILDETRIM] = new RegExp(src[t5.TILDETRIM], "g");
    var tildeTrimReplace = "$1~";
    tok("TILDE");
    src[t5.TILDE] = "^" + src[t5.LONETILDE] + src[t5.XRANGEPLAIN] + "$";
    tok("TILDELOOSE");
    src[t5.TILDELOOSE] = "^" + src[t5.LONETILDE] + src[t5.XRANGEPLAINLOOSE] + "$";
    tok("LONECARET");
    src[t5.LONECARET] = "(?:\\^)";
    tok("CARETTRIM");
    src[t5.CARETTRIM] = "(\\s*)" + src[t5.LONECARET] + "\\s+";
    re[t5.CARETTRIM] = new RegExp(src[t5.CARETTRIM], "g");
    var caretTrimReplace = "$1^";
    tok("CARET");
    src[t5.CARET] = "^" + src[t5.LONECARET] + src[t5.XRANGEPLAIN] + "$";
    tok("CARETLOOSE");
    src[t5.CARETLOOSE] = "^" + src[t5.LONECARET] + src[t5.XRANGEPLAINLOOSE] + "$";
    tok("COMPARATORLOOSE");
    src[t5.COMPARATORLOOSE] = "^" + src[t5.GTLT] + "\\s*(" + src[t5.LOOSEPLAIN] + ")$|^$";
    tok("COMPARATOR");
    src[t5.COMPARATOR] = "^" + src[t5.GTLT] + "\\s*(" + src[t5.FULLPLAIN] + ")$|^$";
    tok("COMPARATORTRIM");
    src[t5.COMPARATORTRIM] = "(\\s*)" + src[t5.GTLT] + "\\s*(" + src[t5.LOOSEPLAIN] + "|" + src[t5.XRANGEPLAIN] + ")";
    re[t5.COMPARATORTRIM] = new RegExp(src[t5.COMPARATORTRIM], "g");
    var comparatorTrimReplace = "$1$2$3";
    tok("HYPHENRANGE");
    src[t5.HYPHENRANGE] = "^\\s*(" + src[t5.XRANGEPLAIN] + ")\\s+-\\s+(" + src[t5.XRANGEPLAIN] + ")\\s*$";
    tok("HYPHENRANGELOOSE");
    src[t5.HYPHENRANGELOOSE] = "^\\s*(" + src[t5.XRANGEPLAINLOOSE] + ")\\s+-\\s+(" + src[t5.XRANGEPLAINLOOSE] + ")\\s*$";
    tok("STAR");
    src[t5.STAR] = "(<|>)?=?\\s*\\*";
    for (i3 = 0; i3 < R; i3++) {
      debug27(i3, src[i3]);
      if (!re[i3]) {
        re[i3] = new RegExp(src[i3]);
      }
    }
    var i3;
    exports2.parse = parse2;
    function parse2(version3, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version3 instanceof SemVer) {
        return version3;
      }
      if (typeof version3 !== "string") {
        return null;
      }
      if (version3.length > MAX_LENGTH) {
        return null;
      }
      var r3 = options2.loose ? re[t5.LOOSE] : re[t5.FULL];
      if (!r3.test(version3)) {
        return null;
      }
      try {
        return new SemVer(version3, options2);
      } catch (er) {
        return null;
      }
    }
    __name(parse2, "parse");
    exports2.valid = valid;
    function valid(version3, options2) {
      var v3 = parse2(version3, options2);
      return v3 ? v3.version : null;
    }
    __name(valid, "valid");
    exports2.clean = clean;
    function clean(version3, options2) {
      var s4 = parse2(version3.trim().replace(/^[=v]+/, ""), options2);
      return s4 ? s4.version : null;
    }
    __name(clean, "clean");
    exports2.SemVer = SemVer;
    function SemVer(version3, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (version3 instanceof SemVer) {
        if (version3.loose === options2.loose) {
          return version3;
        } else {
          version3 = version3.version;
        }
      } else if (typeof version3 !== "string") {
        throw new TypeError("Invalid Version: " + version3);
      }
      if (version3.length > MAX_LENGTH) {
        throw new TypeError("version is longer than " + MAX_LENGTH + " characters");
      }
      if (!(this instanceof SemVer)) {
        return new SemVer(version3, options2);
      }
      debug27("SemVer", version3, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      var m4 = version3.trim().match(options2.loose ? re[t5.LOOSE] : re[t5.FULL]);
      if (!m4) {
        throw new TypeError("Invalid Version: " + version3);
      }
      this.raw = version3;
      this.major = +m4[1];
      this.minor = +m4[2];
      this.patch = +m4[3];
      if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
        throw new TypeError("Invalid major version");
      }
      if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
        throw new TypeError("Invalid minor version");
      }
      if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
        throw new TypeError("Invalid patch version");
      }
      if (!m4[4]) {
        this.prerelease = [];
      } else {
        this.prerelease = m4[4].split(".").map(function(id) {
          if (/^[0-9]+$/.test(id)) {
            var num = +id;
            if (num >= 0 && num < MAX_SAFE_INTEGER) {
              return num;
            }
          }
          return id;
        });
      }
      this.build = m4[5] ? m4[5].split(".") : [];
      this.format();
    }
    __name(SemVer, "SemVer");
    SemVer.prototype.format = function() {
      this.version = this.major + "." + this.minor + "." + this.patch;
      if (this.prerelease.length) {
        this.version += "-" + this.prerelease.join(".");
      }
      return this.version;
    };
    SemVer.prototype.toString = function() {
      return this.version;
    };
    SemVer.prototype.compare = function(other) {
      debug27("SemVer.compare", this.version, this.options, other);
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return this.compareMain(other) || this.comparePre(other);
    };
    SemVer.prototype.compareMain = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    };
    SemVer.prototype.comparePre = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      if (this.prerelease.length && !other.prerelease.length) {
        return -1;
      } else if (!this.prerelease.length && other.prerelease.length) {
        return 1;
      } else if (!this.prerelease.length && !other.prerelease.length) {
        return 0;
      }
      var i4 = 0;
      do {
        var a3 = this.prerelease[i4];
        var b3 = other.prerelease[i4];
        debug27("prerelease compare", i4, a3, b3);
        if (a3 === void 0 && b3 === void 0) {
          return 0;
        } else if (b3 === void 0) {
          return 1;
        } else if (a3 === void 0) {
          return -1;
        } else if (a3 === b3) {
          continue;
        } else {
          return compareIdentifiers(a3, b3);
        }
      } while (++i4);
    };
    SemVer.prototype.compareBuild = function(other) {
      if (!(other instanceof SemVer)) {
        other = new SemVer(other, this.options);
      }
      var i4 = 0;
      do {
        var a3 = this.build[i4];
        var b3 = other.build[i4];
        debug27("prerelease compare", i4, a3, b3);
        if (a3 === void 0 && b3 === void 0) {
          return 0;
        } else if (b3 === void 0) {
          return 1;
        } else if (a3 === void 0) {
          return -1;
        } else if (a3 === b3) {
          continue;
        } else {
          return compareIdentifiers(a3, b3);
        }
      } while (++i4);
    };
    SemVer.prototype.inc = function(release, identifier) {
      switch (release) {
        case "premajor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor = 0;
          this.major++;
          this.inc("pre", identifier);
          break;
        case "preminor":
          this.prerelease.length = 0;
          this.patch = 0;
          this.minor++;
          this.inc("pre", identifier);
          break;
        case "prepatch":
          this.prerelease.length = 0;
          this.inc("patch", identifier);
          this.inc("pre", identifier);
          break;
        case "prerelease":
          if (this.prerelease.length === 0) {
            this.inc("patch", identifier);
          }
          this.inc("pre", identifier);
          break;
        case "major":
          if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
            this.major++;
          }
          this.minor = 0;
          this.patch = 0;
          this.prerelease = [];
          break;
        case "minor":
          if (this.patch !== 0 || this.prerelease.length === 0) {
            this.minor++;
          }
          this.patch = 0;
          this.prerelease = [];
          break;
        case "patch":
          if (this.prerelease.length === 0) {
            this.patch++;
          }
          this.prerelease = [];
          break;
        case "pre":
          if (this.prerelease.length === 0) {
            this.prerelease = [0];
          } else {
            var i4 = this.prerelease.length;
            while (--i4 >= 0) {
              if (typeof this.prerelease[i4] === "number") {
                this.prerelease[i4]++;
                i4 = -2;
              }
            }
            if (i4 === -1) {
              this.prerelease.push(0);
            }
          }
          if (identifier) {
            if (this.prerelease[0] === identifier) {
              if (isNaN(this.prerelease[1])) {
                this.prerelease = [identifier, 0];
              }
            } else {
              this.prerelease = [identifier, 0];
            }
          }
          break;
        default:
          throw new Error("invalid increment argument: " + release);
      }
      this.format();
      this.raw = this.version;
      return this;
    };
    exports2.inc = inc;
    function inc(version3, release, loose, identifier) {
      if (typeof loose === "string") {
        identifier = loose;
        loose = void 0;
      }
      try {
        return new SemVer(version3, loose).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    }
    __name(inc, "inc");
    exports2.diff = diff;
    function diff(version1, version22) {
      if (eq(version1, version22)) {
        return null;
      } else {
        var v1 = parse2(version1);
        var v22 = parse2(version22);
        var prefix = "";
        if (v1.prerelease.length || v22.prerelease.length) {
          prefix = "pre";
          var defaultResult = "prerelease";
        }
        for (var key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v22[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    }
    __name(diff, "diff");
    exports2.compareIdentifiers = compareIdentifiers;
    var numeric = /^[0-9]+$/;
    function compareIdentifiers(a3, b3) {
      var anum = numeric.test(a3);
      var bnum = numeric.test(b3);
      if (anum && bnum) {
        a3 = +a3;
        b3 = +b3;
      }
      return a3 === b3 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a3 < b3 ? -1 : 1;
    }
    __name(compareIdentifiers, "compareIdentifiers");
    exports2.rcompareIdentifiers = rcompareIdentifiers;
    function rcompareIdentifiers(a3, b3) {
      return compareIdentifiers(b3, a3);
    }
    __name(rcompareIdentifiers, "rcompareIdentifiers");
    exports2.major = major;
    function major(a3, loose) {
      return new SemVer(a3, loose).major;
    }
    __name(major, "major");
    exports2.minor = minor;
    function minor(a3, loose) {
      return new SemVer(a3, loose).minor;
    }
    __name(minor, "minor");
    exports2.patch = patch;
    function patch(a3, loose) {
      return new SemVer(a3, loose).patch;
    }
    __name(patch, "patch");
    exports2.compare = compare;
    function compare(a3, b3, loose) {
      return new SemVer(a3, loose).compare(new SemVer(b3, loose));
    }
    __name(compare, "compare");
    exports2.compareLoose = compareLoose;
    function compareLoose(a3, b3) {
      return compare(a3, b3, true);
    }
    __name(compareLoose, "compareLoose");
    exports2.compareBuild = compareBuild;
    function compareBuild(a3, b3, loose) {
      var versionA = new SemVer(a3, loose);
      var versionB = new SemVer(b3, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    }
    __name(compareBuild, "compareBuild");
    exports2.rcompare = rcompare;
    function rcompare(a3, b3, loose) {
      return compare(b3, a3, loose);
    }
    __name(rcompare, "rcompare");
    exports2.sort = sort;
    function sort(list, loose) {
      return list.sort(function(a3, b3) {
        return exports2.compareBuild(a3, b3, loose);
      });
    }
    __name(sort, "sort");
    exports2.rsort = rsort;
    function rsort(list, loose) {
      return list.sort(function(a3, b3) {
        return exports2.compareBuild(b3, a3, loose);
      });
    }
    __name(rsort, "rsort");
    exports2.gt = gt;
    function gt(a3, b3, loose) {
      return compare(a3, b3, loose) > 0;
    }
    __name(gt, "gt");
    exports2.lt = lt;
    function lt(a3, b3, loose) {
      return compare(a3, b3, loose) < 0;
    }
    __name(lt, "lt");
    exports2.eq = eq;
    function eq(a3, b3, loose) {
      return compare(a3, b3, loose) === 0;
    }
    __name(eq, "eq");
    exports2.neq = neq;
    function neq(a3, b3, loose) {
      return compare(a3, b3, loose) !== 0;
    }
    __name(neq, "neq");
    exports2.gte = gte;
    function gte(a3, b3, loose) {
      return compare(a3, b3, loose) >= 0;
    }
    __name(gte, "gte");
    exports2.lte = lte;
    function lte(a3, b3, loose) {
      return compare(a3, b3, loose) <= 0;
    }
    __name(lte, "lte");
    exports2.cmp = cmp;
    function cmp(a3, op, b3, loose) {
      switch (op) {
        case "===":
          if (typeof a3 === "object")
            a3 = a3.version;
          if (typeof b3 === "object")
            b3 = b3.version;
          return a3 === b3;
        case "!==":
          if (typeof a3 === "object")
            a3 = a3.version;
          if (typeof b3 === "object")
            b3 = b3.version;
          return a3 !== b3;
        case "":
        case "=":
        case "==":
          return eq(a3, b3, loose);
        case "!=":
          return neq(a3, b3, loose);
        case ">":
          return gt(a3, b3, loose);
        case ">=":
          return gte(a3, b3, loose);
        case "<":
          return lt(a3, b3, loose);
        case "<=":
          return lte(a3, b3, loose);
        default:
          throw new TypeError("Invalid operator: " + op);
      }
    }
    __name(cmp, "cmp");
    exports2.Comparator = Comparator;
    function Comparator(comp, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (comp instanceof Comparator) {
        if (comp.loose === !!options2.loose) {
          return comp;
        } else {
          comp = comp.value;
        }
      }
      if (!(this instanceof Comparator)) {
        return new Comparator(comp, options2);
      }
      debug27("comparator", comp, options2);
      this.options = options2;
      this.loose = !!options2.loose;
      this.parse(comp);
      if (this.semver === ANY) {
        this.value = "";
      } else {
        this.value = this.operator + this.semver.version;
      }
      debug27("comp", this);
    }
    __name(Comparator, "Comparator");
    var ANY = {};
    Comparator.prototype.parse = function(comp) {
      var r3 = this.options.loose ? re[t5.COMPARATORLOOSE] : re[t5.COMPARATOR];
      var m4 = comp.match(r3);
      if (!m4) {
        throw new TypeError("Invalid comparator: " + comp);
      }
      this.operator = m4[1] !== void 0 ? m4[1] : "";
      if (this.operator === "=") {
        this.operator = "";
      }
      if (!m4[2]) {
        this.semver = ANY;
      } else {
        this.semver = new SemVer(m4[2], this.options.loose);
      }
    };
    Comparator.prototype.toString = function() {
      return this.value;
    };
    Comparator.prototype.test = function(version3) {
      debug27("Comparator.test", version3, this.options.loose);
      if (this.semver === ANY || version3 === ANY) {
        return true;
      }
      if (typeof version3 === "string") {
        try {
          version3 = new SemVer(version3, this.options);
        } catch (er) {
          return false;
        }
      }
      return cmp(version3, this.operator, this.semver, this.options);
    };
    Comparator.prototype.intersects = function(comp, options2) {
      if (!(comp instanceof Comparator)) {
        throw new TypeError("a Comparator is required");
      }
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      var rangeTmp;
      if (this.operator === "") {
        if (this.value === "") {
          return true;
        }
        rangeTmp = new Range(comp.value, options2);
        return satisfies(this.value, rangeTmp, options2);
      } else if (comp.operator === "") {
        if (comp.value === "") {
          return true;
        }
        rangeTmp = new Range(this.value, options2);
        return satisfies(comp.semver, rangeTmp, options2);
      }
      var sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
      var sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
      var sameSemVer = this.semver.version === comp.semver.version;
      var differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
      var oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options2) && ((this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<"));
      var oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options2) && ((this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">"));
      return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
    };
    exports2.Range = Range;
    function Range(range2, options2) {
      if (!options2 || typeof options2 !== "object") {
        options2 = {
          loose: !!options2,
          includePrerelease: false
        };
      }
      if (range2 instanceof Range) {
        if (range2.loose === !!options2.loose && range2.includePrerelease === !!options2.includePrerelease) {
          return range2;
        } else {
          return new Range(range2.raw, options2);
        }
      }
      if (range2 instanceof Comparator) {
        return new Range(range2.value, options2);
      }
      if (!(this instanceof Range)) {
        return new Range(range2, options2);
      }
      this.options = options2;
      this.loose = !!options2.loose;
      this.includePrerelease = !!options2.includePrerelease;
      this.raw = range2;
      this.set = range2.split(/\s*\|\|\s*/).map(function(range3) {
        return this.parseRange(range3.trim());
      }, this).filter(function(c3) {
        return c3.length;
      });
      if (!this.set.length) {
        throw new TypeError("Invalid SemVer Range: " + range2);
      }
      this.format();
    }
    __name(Range, "Range");
    Range.prototype.format = function() {
      this.range = this.set.map(function(comps) {
        return comps.join(" ").trim();
      }).join("||").trim();
      return this.range;
    };
    Range.prototype.toString = function() {
      return this.range;
    };
    Range.prototype.parseRange = function(range2) {
      var loose = this.options.loose;
      range2 = range2.trim();
      var hr = loose ? re[t5.HYPHENRANGELOOSE] : re[t5.HYPHENRANGE];
      range2 = range2.replace(hr, hyphenReplace);
      debug27("hyphen replace", range2);
      range2 = range2.replace(re[t5.COMPARATORTRIM], comparatorTrimReplace);
      debug27("comparator trim", range2, re[t5.COMPARATORTRIM]);
      range2 = range2.replace(re[t5.TILDETRIM], tildeTrimReplace);
      range2 = range2.replace(re[t5.CARETTRIM], caretTrimReplace);
      range2 = range2.split(/\s+/).join(" ");
      var compRe = loose ? re[t5.COMPARATORLOOSE] : re[t5.COMPARATOR];
      var set = range2.split(" ").map(function(comp) {
        return parseComparator(comp, this.options);
      }, this).join(" ").split(/\s+/);
      if (this.options.loose) {
        set = set.filter(function(comp) {
          return !!comp.match(compRe);
        });
      }
      set = set.map(function(comp) {
        return new Comparator(comp, this.options);
      }, this);
      return set;
    };
    Range.prototype.intersects = function(range2, options2) {
      if (!(range2 instanceof Range)) {
        throw new TypeError("a Range is required");
      }
      return this.set.some(function(thisComparators) {
        return isSatisfiable(thisComparators, options2) && range2.set.some(function(rangeComparators) {
          return isSatisfiable(rangeComparators, options2) && thisComparators.every(function(thisComparator) {
            return rangeComparators.every(function(rangeComparator) {
              return thisComparator.intersects(rangeComparator, options2);
            });
          });
        });
      });
    };
    function isSatisfiable(comparators, options2) {
      var result = true;
      var remainingComparators = comparators.slice();
      var testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every(function(otherComparator) {
          return testComparator.intersects(otherComparator, options2);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    }
    __name(isSatisfiable, "isSatisfiable");
    exports2.toComparators = toComparators;
    function toComparators(range2, options2) {
      return new Range(range2, options2).set.map(function(comp) {
        return comp.map(function(c3) {
          return c3.value;
        }).join(" ").trim().split(" ");
      });
    }
    __name(toComparators, "toComparators");
    function parseComparator(comp, options2) {
      debug27("comp", comp, options2);
      comp = replaceCarets(comp, options2);
      debug27("caret", comp);
      comp = replaceTildes(comp, options2);
      debug27("tildes", comp);
      comp = replaceXRanges(comp, options2);
      debug27("xrange", comp);
      comp = replaceStars(comp, options2);
      debug27("stars", comp);
      return comp;
    }
    __name(parseComparator, "parseComparator");
    function isX(id) {
      return !id || id.toLowerCase() === "x" || id === "*";
    }
    __name(isX, "isX");
    function replaceTildes(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceTilde(comp2, options2);
      }).join(" ");
    }
    __name(replaceTildes, "replaceTildes");
    function replaceTilde(comp, options2) {
      var r3 = options2.loose ? re[t5.TILDELOOSE] : re[t5.TILDE];
      return comp.replace(r3, function(_2, M, m4, p3, pr) {
        debug27("tilde", comp, _2, M, m4, p3, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m4)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p3)) {
          ret = ">=" + M + "." + m4 + ".0 <" + M + "." + (+m4 + 1) + ".0";
        } else if (pr) {
          debug27("replaceTilde pr", pr);
          ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + (+m4 + 1) + ".0";
        } else {
          ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + (+m4 + 1) + ".0";
        }
        debug27("tilde return", ret);
        return ret;
      });
    }
    __name(replaceTilde, "replaceTilde");
    function replaceCarets(comp, options2) {
      return comp.trim().split(/\s+/).map(function(comp2) {
        return replaceCaret(comp2, options2);
      }).join(" ");
    }
    __name(replaceCarets, "replaceCarets");
    function replaceCaret(comp, options2) {
      debug27("caret", comp, options2);
      var r3 = options2.loose ? re[t5.CARETLOOSE] : re[t5.CARET];
      return comp.replace(r3, function(_2, M, m4, p3, pr) {
        debug27("caret", comp, _2, M, m4, p3, pr);
        var ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m4)) {
          ret = ">=" + M + ".0.0 <" + (+M + 1) + ".0.0";
        } else if (isX(p3)) {
          if (M === "0") {
            ret = ">=" + M + "." + m4 + ".0 <" + M + "." + (+m4 + 1) + ".0";
          } else {
            ret = ">=" + M + "." + m4 + ".0 <" + (+M + 1) + ".0.0";
          }
        } else if (pr) {
          debug27("replaceCaret pr", pr);
          if (M === "0") {
            if (m4 === "0") {
              ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + m4 + "." + (+p3 + 1);
            } else {
              ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + M + "." + (+m4 + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m4 + "." + p3 + "-" + pr + " <" + (+M + 1) + ".0.0";
          }
        } else {
          debug27("no pr");
          if (M === "0") {
            if (m4 === "0") {
              ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + m4 + "." + (+p3 + 1);
            } else {
              ret = ">=" + M + "." + m4 + "." + p3 + " <" + M + "." + (+m4 + 1) + ".0";
            }
          } else {
            ret = ">=" + M + "." + m4 + "." + p3 + " <" + (+M + 1) + ".0.0";
          }
        }
        debug27("caret return", ret);
        return ret;
      });
    }
    __name(replaceCaret, "replaceCaret");
    function replaceXRanges(comp, options2) {
      debug27("replaceXRanges", comp, options2);
      return comp.split(/\s+/).map(function(comp2) {
        return replaceXRange(comp2, options2);
      }).join(" ");
    }
    __name(replaceXRanges, "replaceXRanges");
    function replaceXRange(comp, options2) {
      comp = comp.trim();
      var r3 = options2.loose ? re[t5.XRANGELOOSE] : re[t5.XRANGE];
      return comp.replace(r3, function(ret, gtlt, M, m4, p3, pr) {
        debug27("xRange", comp, ret, gtlt, M, m4, p3, pr);
        var xM = isX(M);
        var xm = xM || isX(m4);
        var xp = xm || isX(p3);
        var anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options2.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m4 = 0;
          }
          p3 = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m4 = 0;
              p3 = 0;
            } else {
              m4 = +m4 + 1;
              p3 = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m4 = +m4 + 1;
            }
          }
          ret = gtlt + M + "." + m4 + "." + p3 + pr;
        } else if (xm) {
          ret = ">=" + M + ".0.0" + pr + " <" + (+M + 1) + ".0.0" + pr;
        } else if (xp) {
          ret = ">=" + M + "." + m4 + ".0" + pr + " <" + M + "." + (+m4 + 1) + ".0" + pr;
        }
        debug27("xRange return", ret);
        return ret;
      });
    }
    __name(replaceXRange, "replaceXRange");
    function replaceStars(comp, options2) {
      debug27("replaceStars", comp, options2);
      return comp.trim().replace(re[t5.STAR], "");
    }
    __name(replaceStars, "replaceStars");
    function hyphenReplace($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = ">=" + fM + ".0.0";
      } else if (isX(fp)) {
        from = ">=" + fM + "." + fm + ".0";
      } else {
        from = ">=" + from;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = "<" + (+tM + 1) + ".0.0";
      } else if (isX(tp)) {
        to = "<" + tM + "." + (+tm + 1) + ".0";
      } else if (tpr) {
        to = "<=" + tM + "." + tm + "." + tp + "-" + tpr;
      } else {
        to = "<=" + to;
      }
      return (from + " " + to).trim();
    }
    __name(hyphenReplace, "hyphenReplace");
    Range.prototype.test = function(version3) {
      if (!version3) {
        return false;
      }
      if (typeof version3 === "string") {
        try {
          version3 = new SemVer(version3, this.options);
        } catch (er) {
          return false;
        }
      }
      for (var i4 = 0; i4 < this.set.length; i4++) {
        if (testSet(this.set[i4], version3, this.options)) {
          return true;
        }
      }
      return false;
    };
    function testSet(set, version3, options2) {
      for (var i4 = 0; i4 < set.length; i4++) {
        if (!set[i4].test(version3)) {
          return false;
        }
      }
      if (version3.prerelease.length && !options2.includePrerelease) {
        for (i4 = 0; i4 < set.length; i4++) {
          debug27(set[i4].semver);
          if (set[i4].semver === ANY) {
            continue;
          }
          if (set[i4].semver.prerelease.length > 0) {
            var allowed = set[i4].semver;
            if (allowed.major === version3.major && allowed.minor === version3.minor && allowed.patch === version3.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    }
    __name(testSet, "testSet");
    exports2.satisfies = satisfies;
    function satisfies(version3, range2, options2) {
      try {
        range2 = new Range(range2, options2);
      } catch (er) {
        return false;
      }
      return range2.test(version3);
    }
    __name(satisfies, "satisfies");
    exports2.maxSatisfying = maxSatisfying;
    function maxSatisfying(versions, range2, options2) {
      var max = null;
      var maxSV = null;
      try {
        var rangeObj = new Range(range2, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v3) {
        if (rangeObj.test(v3)) {
          if (!max || maxSV.compare(v3) === -1) {
            max = v3;
            maxSV = new SemVer(max, options2);
          }
        }
      });
      return max;
    }
    __name(maxSatisfying, "maxSatisfying");
    exports2.minSatisfying = minSatisfying;
    function minSatisfying(versions, range2, options2) {
      var min = null;
      var minSV = null;
      try {
        var rangeObj = new Range(range2, options2);
      } catch (er) {
        return null;
      }
      versions.forEach(function(v3) {
        if (rangeObj.test(v3)) {
          if (!min || minSV.compare(v3) === 1) {
            min = v3;
            minSV = new SemVer(min, options2);
          }
        }
      });
      return min;
    }
    __name(minSatisfying, "minSatisfying");
    exports2.minVersion = minVersion;
    function minVersion(range2, loose) {
      range2 = new Range(range2, loose);
      var minver = new SemVer("0.0.0");
      if (range2.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range2.test(minver)) {
        return minver;
      }
      minver = null;
      for (var i4 = 0; i4 < range2.set.length; ++i4) {
        var comparators = range2.set[i4];
        comparators.forEach(function(comparator) {
          var compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!minver || gt(minver, compver)) {
                minver = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error("Unexpected operation: " + comparator.operator);
          }
        });
      }
      if (minver && range2.test(minver)) {
        return minver;
      }
      return null;
    }
    __name(minVersion, "minVersion");
    exports2.validRange = validRange;
    function validRange(range2, options2) {
      try {
        return new Range(range2, options2).range || "*";
      } catch (er) {
        return null;
      }
    }
    __name(validRange, "validRange");
    exports2.ltr = ltr;
    function ltr(version3, range2, options2) {
      return outside(version3, range2, "<", options2);
    }
    __name(ltr, "ltr");
    exports2.gtr = gtr;
    function gtr(version3, range2, options2) {
      return outside(version3, range2, ">", options2);
    }
    __name(gtr, "gtr");
    exports2.outside = outside;
    function outside(version3, range2, hilo, options2) {
      version3 = new SemVer(version3, options2);
      range2 = new Range(range2, options2);
      var gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version3, range2, options2)) {
        return false;
      }
      for (var i4 = 0; i4 < range2.set.length; ++i4) {
        var comparators = range2.set[i4];
        var high = null;
        var low = null;
        comparators.forEach(function(comparator) {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options2)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options2)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version3, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version3, low.semver)) {
          return false;
        }
      }
      return true;
    }
    __name(outside, "outside");
    exports2.prerelease = prerelease;
    function prerelease(version3, options2) {
      var parsed = parse2(version3, options2);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    }
    __name(prerelease, "prerelease");
    exports2.intersects = intersects;
    function intersects(r1, r22, options2) {
      r1 = new Range(r1, options2);
      r22 = new Range(r22, options2);
      return r1.intersects(r22);
    }
    __name(intersects, "intersects");
    exports2.coerce = coerce;
    function coerce(version3, options2) {
      if (version3 instanceof SemVer) {
        return version3;
      }
      if (typeof version3 === "number") {
        version3 = String(version3);
      }
      if (typeof version3 !== "string") {
        return null;
      }
      options2 = options2 || {};
      var match4 = null;
      if (!options2.rtl) {
        match4 = version3.match(re[t5.COERCE]);
      } else {
        var next;
        while ((next = re[t5.COERCERTL].exec(version3)) && (!match4 || match4.index + match4[0].length !== version3.length)) {
          if (!match4 || next.index + next[0].length !== match4.index + match4[0].length) {
            match4 = next;
          }
          re[t5.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
        }
        re[t5.COERCERTL].lastIndex = -1;
      }
      if (match4 === null) {
        return null;
      }
      return parse2(match4[2] + "." + (match4[3] || "0") + "." + (match4[4] || "0"), options2);
    }
    __name(coerce, "coerce");
  }
});

// ../../node_modules/.pnpm/make-dir@3.1.0/node_modules/make-dir/index.js
var require_make_dir2 = __commonJS({
  "../../node_modules/.pnpm/make-dir@3.1.0/node_modules/make-dir/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var path32 = require("path");
    var { promisify: promisify12 } = require("util");
    var semver2 = require_semver2();
    var useNativeRecursiveOption2 = semver2.satisfies(process.version, ">=10.12.0");
    var checkPath2 = /* @__PURE__ */ __name((pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path32.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error2 = new Error(`Path contains invalid characters: ${pth}`);
          error2.code = "EINVAL";
          throw error2;
        }
      }
    }, "checkPath");
    var processOptions2 = /* @__PURE__ */ __name((options2) => {
      const defaults = {
        mode: 511,
        fs: fs37
      };
      return {
        ...defaults,
        ...options2
      };
    }, "processOptions");
    var permissionError2 = /* @__PURE__ */ __name((pth) => {
      const error2 = new Error(`operation not permitted, mkdir '${pth}'`);
      error2.code = "EPERM";
      error2.errno = -4048;
      error2.path = pth;
      error2.syscall = "mkdir";
      return error2;
    }, "permissionError");
    var makeDir2 = /* @__PURE__ */ __name(async (input, options2) => {
      checkPath2(input);
      options2 = processOptions2(options2);
      const mkdir2 = promisify12(options2.fs.mkdir);
      const stat2 = promisify12(options2.fs.stat);
      if (useNativeRecursiveOption2 && options2.fs.mkdir === fs37.mkdir) {
        const pth = path32.resolve(input);
        await mkdir2(pth, {
          mode: options2.mode,
          recursive: true
        });
        return pth;
      }
      const make = /* @__PURE__ */ __name(async (pth) => {
        try {
          await mkdir2(pth, options2.mode);
          return pth;
        } catch (error2) {
          if (error2.code === "EPERM") {
            throw error2;
          }
          if (error2.code === "ENOENT") {
            if (path32.dirname(pth) === pth) {
              throw permissionError2(pth);
            }
            if (error2.message.includes("null bytes")) {
              throw error2;
            }
            await make(path32.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await stat2(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch (_2) {
            throw error2;
          }
          return pth;
        }
      }, "make");
      return make(path32.resolve(input));
    }, "makeDir");
    module2.exports = makeDir2;
    module2.exports.sync = (input, options2) => {
      checkPath2(input);
      options2 = processOptions2(options2);
      if (useNativeRecursiveOption2 && options2.fs.mkdirSync === fs37.mkdirSync) {
        const pth = path32.resolve(input);
        fs37.mkdirSync(pth, {
          mode: options2.mode,
          recursive: true
        });
        return pth;
      }
      const make = /* @__PURE__ */ __name((pth) => {
        try {
          options2.fs.mkdirSync(pth, options2.mode);
        } catch (error2) {
          if (error2.code === "EPERM") {
            throw error2;
          }
          if (error2.code === "ENOENT") {
            if (path32.dirname(pth) === pth) {
              throw permissionError2(pth);
            }
            if (error2.message.includes("null bytes")) {
              throw error2;
            }
            make(path32.dirname(pth));
            return make(pth);
          }
          try {
            if (!options2.fs.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch (_2) {
            throw error2;
          }
        }
        return pth;
      }, "make");
      return make(path32.resolve(input));
    };
  }
});

// ../../node_modules/.pnpm/find-cache-dir@3.3.2/node_modules/find-cache-dir/index.js
var require_find_cache_dir = __commonJS({
  "../../node_modules/.pnpm/find-cache-dir@3.3.2/node_modules/find-cache-dir/index.js"(exports2, module2) {
    "use strict";
    var path32 = require("path");
    var fs37 = require("fs");
    var commonDir = require_commondir();
    var pkgDir = require_pkg_dir();
    var makeDir2 = require_make_dir2();
    var { env: env2, cwd } = process;
    var isWritable = /* @__PURE__ */ __name((path33) => {
      try {
        fs37.accessSync(path33, fs37.constants.W_OK);
        return true;
      } catch (_2) {
        return false;
      }
    }, "isWritable");
    function useDirectory(directory, options2) {
      if (options2.create) {
        makeDir2.sync(directory);
      }
      if (options2.thunk) {
        return (...arguments_) => path32.join(directory, ...arguments_);
      }
      return directory;
    }
    __name(useDirectory, "useDirectory");
    function getNodeModuleDirectory(directory) {
      const nodeModules = path32.join(directory, "node_modules");
      if (!isWritable(nodeModules) && (fs37.existsSync(nodeModules) || !isWritable(path32.join(directory)))) {
        return;
      }
      return nodeModules;
    }
    __name(getNodeModuleDirectory, "getNodeModuleDirectory");
    module2.exports = (options2 = {}) => {
      if (env2.CACHE_DIR && !["true", "false", "1", "0"].includes(env2.CACHE_DIR)) {
        return useDirectory(path32.join(env2.CACHE_DIR, options2.name), options2);
      }
      let { cwd: directory = cwd() } = options2;
      if (options2.files) {
        directory = commonDir(directory, options2.files);
      }
      directory = pkgDir.sync(directory);
      if (!directory) {
        return;
      }
      const nodeModules = getNodeModuleDirectory(directory);
      if (!nodeModules) {
        return void 0;
      }
      return useDirectory(path32.join(directory, "node_modules", ".cache", options2.name), options2);
    };
  }
});

// ../../node_modules/.pnpm/hasha@5.2.2/node_modules/hasha/index.js
var require_hasha = __commonJS({
  "../../node_modules/.pnpm/hasha@5.2.2/node_modules/hasha/index.js"(exports2, module2) {
    "use strict";
    var fs37 = require("fs");
    var path32 = require("path");
    var crypto4 = require("crypto");
    var isStream = require_is_stream();
    var { Worker } = (() => {
      try {
        return require("worker_threads");
      } catch (_2) {
        return {};
      }
    })();
    var worker;
    var taskIdCounter = 0;
    var tasks = /* @__PURE__ */ new Map();
    var recreateWorkerError = /* @__PURE__ */ __name((sourceError) => {
      const error2 = new Error(sourceError.message);
      for (const [key, value] of Object.entries(sourceError)) {
        if (key !== "message") {
          error2[key] = value;
        }
      }
      return error2;
    }, "recreateWorkerError");
    var createWorker = /* @__PURE__ */ __name(() => {
      worker = new Worker(path32.join(__dirname, "thread.js"));
      worker.on("message", (message2) => {
        const task = tasks.get(message2.id);
        tasks.delete(message2.id);
        if (tasks.size === 0) {
          worker.unref();
        }
        if (message2.error === void 0) {
          task.resolve(message2.value);
        } else {
          task.reject(recreateWorkerError(message2.error));
        }
      });
      worker.on("error", (error2) => {
        throw error2;
      });
    }, "createWorker");
    var taskWorker = /* @__PURE__ */ __name((method, args3, transferList) => new Promise((resolve2, reject2) => {
      const id = taskIdCounter++;
      tasks.set(id, { resolve: resolve2, reject: reject2 });
      if (worker === void 0) {
        createWorker();
      }
      worker.ref();
      worker.postMessage({ id, method, args: args3 }, transferList);
    }), "taskWorker");
    var hasha2 = /* @__PURE__ */ __name((input, options2 = {}) => {
      let outputEncoding = options2.encoding || "hex";
      if (outputEncoding === "buffer") {
        outputEncoding = void 0;
      }
      const hash = crypto4.createHash(options2.algorithm || "sha512");
      const update = /* @__PURE__ */ __name((buffer) => {
        const inputEncoding = typeof buffer === "string" ? "utf8" : void 0;
        hash.update(buffer, inputEncoding);
      }, "update");
      if (Array.isArray(input)) {
        input.forEach(update);
      } else {
        update(input);
      }
      return hash.digest(outputEncoding);
    }, "hasha");
    hasha2.stream = (options2 = {}) => {
      let outputEncoding = options2.encoding || "hex";
      if (outputEncoding === "buffer") {
        outputEncoding = void 0;
      }
      const stream3 = crypto4.createHash(options2.algorithm || "sha512");
      stream3.setEncoding(outputEncoding);
      return stream3;
    };
    hasha2.fromStream = async (stream3, options2 = {}) => {
      if (!isStream(stream3)) {
        throw new TypeError("Expected a stream");
      }
      return new Promise((resolve2, reject2) => {
        stream3.on("error", reject2).pipe(hasha2.stream(options2)).on("error", reject2).on("finish", function() {
          resolve2(this.read());
        });
      });
    };
    if (Worker === void 0) {
      hasha2.fromFile = async (filePath, options2) => hasha2.fromStream(fs37.createReadStream(filePath), options2);
      hasha2.async = async (input, options2) => hasha2(input, options2);
    } else {
      hasha2.fromFile = async (filePath, { algorithm = "sha512", encoding = "hex" } = {}) => {
        const hash = await taskWorker("hashFile", [algorithm, filePath]);
        if (encoding === "buffer") {
          return Buffer.from(hash);
        }
        return Buffer.from(hash).toString(encoding);
      };
      hasha2.async = async (input, { algorithm = "sha512", encoding = "hex" } = {}) => {
        if (encoding === "buffer") {
          encoding = void 0;
        }
        const hash = await taskWorker("hash", [algorithm, input]);
        if (encoding === void 0) {
          return Buffer.from(hash);
        }
        return Buffer.from(hash).toString(encoding);
      };
    }
    hasha2.fromFileSync = (filePath, options2) => hasha2(fs37.readFileSync(filePath), options2);
    module2.exports = hasha2;
  }
});

// ../../node_modules/.pnpm/webidl-conversions@3.0.1/node_modules/webidl-conversions/lib/index.js
var require_lib5 = __commonJS({
  "../../node_modules/.pnpm/webidl-conversions@3.0.1/node_modules/webidl-conversions/lib/index.js"(exports2, module2) {
    "use strict";
    var conversions = {};
    module2.exports = conversions;
    function sign(x) {
      return x < 0 ? -1 : 1;
    }
    __name(sign, "sign");
    function evenRound(x) {
      if (x % 1 === 0.5 && (x & 1) === 0) {
        return Math.floor(x);
      } else {
        return Math.round(x);
      }
    }
    __name(evenRound, "evenRound");
    function createNumberConversion(bitLength, typeOpts) {
      if (!typeOpts.unsigned) {
        --bitLength;
      }
      const lowerBound = typeOpts.unsigned ? 0 : -Math.pow(2, bitLength);
      const upperBound = Math.pow(2, bitLength) - 1;
      const moduloVal = typeOpts.moduloBitLength ? Math.pow(2, typeOpts.moduloBitLength) : Math.pow(2, bitLength);
      const moduloBound = typeOpts.moduloBitLength ? Math.pow(2, typeOpts.moduloBitLength - 1) : Math.pow(2, bitLength - 1);
      return function(V, opts2) {
        if (!opts2)
          opts2 = {};
        let x = +V;
        if (opts2.enforceRange) {
          if (!Number.isFinite(x)) {
            throw new TypeError("Argument is not a finite number");
          }
          x = sign(x) * Math.floor(Math.abs(x));
          if (x < lowerBound || x > upperBound) {
            throw new TypeError("Argument is not in byte range");
          }
          return x;
        }
        if (!isNaN(x) && opts2.clamp) {
          x = evenRound(x);
          if (x < lowerBound)
            x = lowerBound;
          if (x > upperBound)
            x = upperBound;
          return x;
        }
        if (!Number.isFinite(x) || x === 0) {
          return 0;
        }
        x = sign(x) * Math.floor(Math.abs(x));
        x = x % moduloVal;
        if (!typeOpts.unsigned && x >= moduloBound) {
          return x - moduloVal;
        } else if (typeOpts.unsigned) {
          if (x < 0) {
            x += moduloVal;
          } else if (x === -0) {
            return 0;
          }
        }
        return x;
      };
    }
    __name(createNumberConversion, "createNumberConversion");
    conversions["void"] = function() {
      return void 0;
    };
    conversions["boolean"] = function(val) {
      return !!val;
    };
    conversions["byte"] = createNumberConversion(8, { unsigned: false });
    conversions["octet"] = createNumberConversion(8, { unsigned: true });
    conversions["short"] = createNumberConversion(16, { unsigned: false });
    conversions["unsigned short"] = createNumberConversion(16, { unsigned: true });
    conversions["long"] = createNumberConversion(32, { unsigned: false });
    conversions["unsigned long"] = createNumberConversion(32, { unsigned: true });
    conversions["long long"] = createNumberConversion(32, { unsigned: false, moduloBitLength: 64 });
    conversions["unsigned long long"] = createNumberConversion(32, { unsigned: true, moduloBitLength: 64 });
    conversions["double"] = function(V) {
      const x = +V;
      if (!Number.isFinite(x)) {
        throw new TypeError("Argument is not a finite floating-point value");
      }
      return x;
    };
    conversions["unrestricted double"] = function(V) {
      const x = +V;
      if (isNaN(x)) {
        throw new TypeError("Argument is NaN");
      }
      return x;
    };
    conversions["float"] = conversions["double"];
    conversions["unrestricted float"] = conversions["unrestricted double"];
    conversions["DOMString"] = function(V, opts2) {
      if (!opts2)
        opts2 = {};
      if (opts2.treatNullAsEmptyString && V === null) {
        return "";
      }
      return String(V);
    };
    conversions["ByteString"] = function(V, opts2) {
      const x = String(V);
      let c3 = void 0;
      for (let i3 = 0; (c3 = x.codePointAt(i3)) !== void 0; ++i3) {
        if (c3 > 255) {
          throw new TypeError("Argument is not a valid bytestring");
        }
      }
      return x;
    };
    conversions["USVString"] = function(V) {
      const S3 = String(V);
      const n3 = S3.length;
      const U = [];
      for (let i3 = 0; i3 < n3; ++i3) {
        const c3 = S3.charCodeAt(i3);
        if (c3 < 55296 || c3 > 57343) {
          U.push(String.fromCodePoint(c3));
        } else if (56320 <= c3 && c3 <= 57343) {
          U.push(String.fromCodePoint(65533));
        } else {
          if (i3 === n3 - 1) {
            U.push(String.fromCodePoint(65533));
          } else {
            const d4 = S3.charCodeAt(i3 + 1);
            if (56320 <= d4 && d4 <= 57343) {
              const a3 = c3 & 1023;
              const b3 = d4 & 1023;
              U.push(String.fromCodePoint((2 << 15) + (2 << 9) * a3 + b3));
              ++i3;
            } else {
              U.push(String.fromCodePoint(65533));
            }
          }
        }
      }
      return U.join("");
    };
    conversions["Date"] = function(V, opts2) {
      if (!(V instanceof Date)) {
        throw new TypeError("Argument is not a Date object");
      }
      if (isNaN(V)) {
        return void 0;
      }
      return V;
    };
    conversions["RegExp"] = function(V, opts2) {
      if (!(V instanceof RegExp)) {
        V = new RegExp(V);
      }
      return V;
    };
  }
});

// ../../node_modules/.pnpm/whatwg-url@5.0.0/node_modules/whatwg-url/lib/utils.js
var require_utils7 = __commonJS({
  "../../node_modules/.pnpm/whatwg-url@5.0.0/node_modules/whatwg-url/lib/utils.js"(exports2, module2) {
    "use strict";
    module2.exports.mixin = /* @__PURE__ */ __name(function mixin(target, source) {
      const keys = Object.getOwnPropertyNames(source);
      for (let i3 = 0; i3 < keys.length; ++i3) {
        Object.defineProperty(target, keys[i3], Object.getOwnPropertyDescriptor(source, keys[i3]));
      }
    }, "mixin");
    module2.exports.wrapperSymbol = Symbol("wrapper");
    module2.exports.implSymbol = Symbol("impl");
    module2.exports.wrapperForImpl = function(impl) {
      return impl[module2.exports.wrapperSymbol];
    };
    module2.exports.implForWrapper = function(wrapper) {
      return wrapper[module2.exports.implSymbol];
    };
  }
});

// ../../node_modules/.pnpm/tr46@0.0.3/node_modules/tr46/lib/mappingTable.json
var require_mappingTable = __commonJS({
  "../../node_modules/.pnpm/tr46@0.0.3/node_modules/tr46/lib/mappingTable.json"(exports2, module2) {
    module2.exports = [[[0, 44], "disallowed_STD3_valid"], [[45, 46], "valid"], [[47, 47], "disallowed_STD3_valid"], [[48, 57], "valid"], [[58, 64], "disallowed_STD3_valid"], [[65, 65], "mapped", [97]], [[66, 66], "mapped", [98]], [[67, 67], "mapped", [99]], [[68, 68], "mapped", [100]], [[69, 69], "mapped", [101]], [[70, 70], "mapped", [102]], [[71, 71], "mapped", [103]], [[72, 72], "mapped", [104]], [[73, 73], "mapped", [105]], [[74, 74], "mapped", [106]], [[75, 75], "mapped", [107]], [[76, 76], "mapped", [108]], [[77, 77], "mapped", [109]], [[78, 78], "mapped", [110]], [[79, 79], "mapped", [111]], [[80, 80], "mapped", [112]], [[81, 81], "mapped", [113]], [[82, 82], "mapped", [114]], [[83, 83], "mapped", [115]], [[84, 84], "mapped", [116]], [[85, 85], "mapped", [117]], [[86, 86], "mapped", [118]], [[87, 87], "mapped", [119]], [[88, 88], "mapped", [120]], [[89, 89], "mapped", [121]], [[90, 90], "mapped", [122]], [[91, 96], "disallowed_STD3_valid"], [[97, 122], "valid"], [[123, 127], "disallowed_STD3_valid"], [[128, 159], "disallowed"], [[160, 160], "disallowed_STD3_mapped", [32]], [[161, 167], "valid", [], "NV8"], [[168, 168], "disallowed_STD3_mapped", [32, 776]], [[169, 169], "valid", [], "NV8"], [[170, 170], "mapped", [97]], [[171, 172], "valid", [], "NV8"], [[173, 173], "ignored"], [[174, 174], "valid", [], "NV8"], [[175, 175], "disallowed_STD3_mapped", [32, 772]], [[176, 177], "valid", [], "NV8"], [[178, 178], "mapped", [50]], [[179, 179], "mapped", [51]], [[180, 180], "disallowed_STD3_mapped", [32, 769]], [[181, 181], "mapped", [956]], [[182, 182], "valid", [], "NV8"], [[183, 183], "valid"], [[184, 184], "disallowed_STD3_mapped", [32, 807]], [[185, 185], "mapped", [49]], [[186, 186], "mapped", [111]], [[187, 187], "valid", [], "NV8"], [[188, 188], "mapped", [49, 8260, 52]], [[189, 189], "mapped", [49, 8260, 50]], [[190, 190], "mapped", [51, 8260, 52]], [[191, 191], "valid", [], "NV8"], [[192, 192], "mapped", [224]], [[193, 193], "mapped", [225]], [[194, 194], "mapped", [226]], [[195, 195], "mapped", [227]], [[196, 196], "mapped", [228]], [[197, 197], "mapped", [229]], [[198, 198], "mapped", [230]], [[199, 199], "mapped", [231]], [[200, 200], "mapped", [232]], [[201, 201], "mapped", [233]], [[202, 202], "mapped", [234]], [[203, 203], "mapped", [235]], [[204, 204], "mapped", [236]], [[205, 205], "mapped", [237]], [[206, 206], "mapped", [238]], [[207, 207], "mapped", [239]], [[208, 208], "mapped", [240]], [[209, 209], "mapped", [241]], [[210, 210], "mapped", [242]], [[211, 211], "mapped", [243]], [[212, 212], "mapped", [244]], [[213, 213], "mapped", [245]], [[214, 214], "mapped", [246]], [[215, 215], "valid", [], "NV8"], [[216, 216], "mapped", [248]], [[217, 217], "mapped", [249]], [[218, 218], "mapped", [250]], [[219, 219], "mapped", [251]], [[220, 220], "mapped", [252]], [[221, 221], "mapped", [253]], [[222, 222], "mapped", [254]], [[223, 223], "deviation", [115, 115]], [[224, 246], "valid"], [[247, 247], "valid", [], "NV8"], [[248, 255], "valid"], [[256, 256], "mapped", [257]], [[257, 257], "valid"], [[258, 258], "mapped", [259]], [[259, 259], "valid"], [[260, 260], "mapped", [261]], [[261, 261], "valid"], [[262, 262], "mapped", [263]], [[263, 263], "valid"], [[264, 264], "mapped", [265]], [[265, 265], "valid"], [[266, 266], "mapped", [267]], [[267, 267], "valid"], [[268, 268], "mapped", [269]], [[269, 269], "valid"], [[270, 270], "mapped", [271]], [[271, 271], "valid"], [[272, 272], "mapped", [273]], [[273, 273], "valid"], [[274, 274], "mapped", [275]], [[275, 275], "valid"], [[276, 276], "mapped", [277]], [[277, 277], "valid"], [[278, 278], "mapped", [279]], [[279, 279], "valid"], [[280, 280], "mapped", [281]], [[281, 281], "valid"], [[282, 282], "mapped", [283]], [[283, 283], "valid"], [[284, 284], "mapped", [285]], [[285, 285], "valid"], [[286, 286], "mapped", [287]], [[287, 287], "valid"], [[288, 288], "mapped", [289]], [[289, 289], "valid"], [[290, 290], "mapped", [291]], [[291, 291], "valid"], [[292, 292], "mapped", [293]], [[293, 293], "valid"], [[294, 294], "mapped", [295]], [[295, 295], "valid"], [[296, 296], "mapped", [297]], [[297, 297], "valid"], [[298, 298], "mapped", [299]], [[299, 299], "valid"], [[300, 300], "mapped", [301]], [[301, 301], "valid"], [[302, 302], "mapped", [303]], [[303, 303], "valid"], [[304, 304], "mapped", [105, 775]], [[305, 305], "valid"], [[306, 307], "mapped", [105, 106]], [[308, 308], "mapped", [309]], [[309, 309], "valid"], [[310, 310], "mapped", [311]], [[311, 312], "valid"], [[313, 313], "mapped", [314]], [[314, 314], "valid"], [[315, 315], "mapped", [316]], [[316, 316], "valid"], [[317, 317], "mapped", [318]], [[318, 318], "valid"], [[319, 320], "mapped", [108, 183]], [[321, 321], "mapped", [322]], [[322, 322], "valid"], [[323, 323], "mapped", [324]], [[324, 324], "valid"], [[325, 325], "mapped", [326]], [[326, 326], "valid"], [[327, 327], "mapped", [328]], [[328, 328], "valid"], [[329, 329], "mapped", [700, 110]], [[330, 330], "mapped", [331]], [[331, 331], "valid"], [[332, 332], "mapped", [333]], [[333, 333], "valid"], [[334, 334], "mapped", [335]], [[335, 335], "valid"], [[336, 336], "mapped", [337]], [[337, 337], "valid"], [[338, 338], "mapped", [339]], [[339, 339], "valid"], [[340, 340], "mapped", [341]], [[341, 341], "valid"], [[342, 342], "mapped", [343]], [[343, 343], "valid"], [[344, 344], "mapped", [345]], [[345, 345], "valid"], [[346, 346], "mapped", [347]], [[347, 347], "valid"], [[348, 348], "mapped", [349]], [[349, 349], "valid"], [[350, 350], "mapped", [351]], [[351, 351], "valid"], [[352, 352], "mapped", [353]], [[353, 353], "valid"], [[354, 354], "mapped", [355]], [[355, 355], "valid"], [[356, 356], "mapped", [357]], [[357, 357], "valid"], [[358, 358], "mapped", [359]], [[359, 359], "valid"], [[360, 360], "mapped", [361]], [[361, 361], "valid"], [[362, 362], "mapped", [363]], [[363, 363], "valid"], [[364, 364], "mapped", [365]], [[365, 365], "valid"], [[366, 366], "mapped", [367]], [[367, 367], "valid"], [[368, 368], "mapped", [369]], [[369, 369], "valid"], [[370, 370], "mapped", [371]], [[371, 371], "valid"], [[372, 372], "mapped", [373]], [[373, 373], "valid"], [[374, 374], "mapped", [375]], [[375, 375], "valid"], [[376, 376], "mapped", [255]], [[377, 377], "mapped", [378]], [[378, 378], "valid"], [[379, 379], "mapped", [380]], [[380, 380], "valid"], [[381, 381], "mapped", [382]], [[382, 382], "valid"], [[383, 383], "mapped", [115]], [[384, 384], "valid"], [[385, 385], "mapped", [595]], [[386, 386], "mapped", [387]], [[387, 387], "valid"], [[388, 388], "mapped", [389]], [[389, 389], "valid"], [[390, 390], "mapped", [596]], [[391, 391], "mapped", [392]], [[392, 392], "valid"], [[393, 393], "mapped", [598]], [[394, 394], "mapped", [599]], [[395, 395], "mapped", [396]], [[396, 397], "valid"], [[398, 398], "mapped", [477]], [[399, 399], "mapped", [601]], [[400, 400], "mapped", [603]], [[401, 401], "mapped", [402]], [[402, 402], "valid"], [[403, 403], "mapped", [608]], [[404, 404], "mapped", [611]], [[405, 405], "valid"], [[406, 406], "mapped", [617]], [[407, 407], "mapped", [616]], [[408, 408], "mapped", [409]], [[409, 411], "valid"], [[412, 412], "mapped", [623]], [[413, 413], "mapped", [626]], [[414, 414], "valid"], [[415, 415], "mapped", [629]], [[416, 416], "mapped", [417]], [[417, 417], "valid"], [[418, 418], "mapped", [419]], [[419, 419], "valid"], [[420, 420], "mapped", [421]], [[421, 421], "valid"], [[422, 422], "mapped", [640]], [[423, 423], "mapped", [424]], [[424, 424], "valid"], [[425, 425], "mapped", [643]], [[426, 427], "valid"], [[428, 428], "mapped", [429]], [[429, 429], "valid"], [[430, 430], "mapped", [648]], [[431, 431], "mapped", [432]], [[432, 432], "valid"], [[433, 433], "mapped", [650]], [[434, 434], "mapped", [651]], [[435, 435], "mapped", [436]], [[436, 436], "valid"], [[437, 437], "mapped", [438]], [[438, 438], "valid"], [[439, 439], "mapped", [658]], [[440, 440], "mapped", [441]], [[441, 443], "valid"], [[444, 444], "mapped", [445]], [[445, 451], "valid"], [[452, 454], "mapped", [100, 382]], [[455, 457], "mapped", [108, 106]], [[458, 460], "mapped", [110, 106]], [[461, 461], "mapped", [462]], [[462, 462], "valid"], [[463, 463], "mapped", [464]], [[464, 464], "valid"], [[465, 465], "mapped", [466]], [[466, 466], "valid"], [[467, 467], "mapped", [468]], [[468, 468], "valid"], [[469, 469], "mapped", [470]], [[470, 470], "valid"], [[471, 471], "mapped", [472]], [[472, 472], "valid"], [[473, 473], "mapped", [474]], [[474, 474], "valid"], [[475, 475], "mapped", [476]], [[476, 477], "valid"], [[478, 478], "mapped", [479]], [[479, 479], "valid"], [[480, 480], "mapped", [481]], [[481, 481], "valid"], [[482, 482], "mapped", [483]], [[483, 483], "valid"], [[484, 484], "mapped", [485]], [[485, 485], "valid"], [[486, 486], "mapped", [487]], [[487, 487], "valid"], [[488, 488], "mapped", [489]], [[489, 489], "valid"], [[490, 490], "mapped", [491]], [[491, 491], "valid"], [[492, 492], "mapped", [493]], [[493, 493], "valid"], [[494, 494], "mapped", [495]], [[495, 496], "valid"], [[497, 499], "mapped", [100, 122]], [[500, 500], "mapped", [501]], [[501, 501], "valid"], [[502, 502], "mapped", [405]], [[503, 503], "mapped", [447]], [[504, 504], "mapped", [505]], [[505, 505], "valid"], [[506, 506], "mapped", [507]], [[507, 507], "valid"], [[508, 508], "mapped", [509]], [[509, 509], "valid"], [[510, 510], "mapped", [511]], [[511, 511], "valid"], [[512, 512], "mapped", [513]], [[513, 513], "valid"], [[514, 514], "mapped", [515]], [[515, 515], "valid"], [[516, 516], "mapped", [517]], [[517, 517], "valid"], [[518, 518], "mapped", [519]], [[519, 519], "valid"], [[520, 520], "mapped", [521]], [[521, 521], "valid"], [[522, 522], "mapped", [523]], [[523, 523], "valid"], [[524, 524], "mapped", [525]], [[525, 525], "valid"], [[526, 526], "mapped", [527]], [[527, 527], "valid"], [[528, 528], "mapped", [529]], [[529, 529], "valid"], [[530, 530], "mapped", [531]], [[531, 531], "valid"], [[532, 532], "mapped", [533]], [[533, 533], "valid"], [[534, 534], "mapped", [535]], [[535, 535], "valid"], [[536, 536], "mapped", [537]], [[537, 537], "valid"], [[538, 538], "mapped", [539]], [[539, 539], "valid"], [[540, 540], "mapped", [541]], [[541, 541], "valid"], [[542, 542], "mapped", [543]], [[543, 543], "valid"], [[544, 544], "mapped", [414]], [[545, 545], "valid"], [[546, 546], "mapped", [547]], [[547, 547], "valid"], [[548, 548], "mapped", [549]], [[549, 549], "valid"], [[550, 550], "mapped", [551]], [[551, 551], "valid"], [[552, 552], "mapped", [553]], [[553, 553], "valid"], [[554, 554], "mapped", [555]], [[555, 555], "valid"], [[556, 556], "mapped", [557]], [[557, 557], "valid"], [[558, 558], "mapped", [559]], [[559, 559], "valid"], [[560, 560], "mapped", [561]], [[561, 561], "valid"], [[562, 562], "mapped", [563]], [[563, 563], "valid"], [[564, 566], "valid"], [[567, 569], "valid"], [[570, 570], "mapped", [11365]], [[571, 571], "mapped", [572]], [[572, 572], "valid"], [[573, 573], "mapped", [410]], [[574, 574], "mapped", [11366]], [[575, 576], "valid"], [[577, 577], "mapped", [578]], [[578, 578], "valid"], [[579, 579], "mapped", [384]], [[580, 580], "mapped", [649]], [[581, 581], "mapped", [652]], [[582, 582], "mapped", [583]], [[583, 583], "valid"], [[584, 584], "mapped", [585]], [[585, 585], "valid"], [[586, 586], "mapped", [587]], [[587, 587], "valid"], [[588, 588], "mapped", [589]], [[589, 589], "valid"], [[590, 590], "mapped", [591]], [[591, 591], "valid"], [[592, 680], "valid"], [[681, 685], "valid"], [[686, 687], "valid"], [[688, 688], "mapped", [104]], [[689, 689], "mapped", [614]], [[690, 690], "mapped", [106]], [[691, 691], "mapped", [114]], [[692, 692], "mapped", [633]], [[693, 693], "mapped", [635]], [[694, 694], "mapped", [641]], [[695, 695], "mapped", [119]], [[696, 696], "mapped", [121]], [[697, 705], "valid"], [[706, 709], "valid", [], "NV8"], [[710, 721], "valid"], [[722, 727], "valid", [], "NV8"], [[728, 728], "disallowed_STD3_mapped", [32, 774]], [[729, 729], "disallowed_STD3_mapped", [32, 775]], [[730, 730], "disallowed_STD3_mapped", [32, 778]], [[731, 731], "disallowed_STD3_mapped", [32, 808]], [[732, 732], "disallowed_STD3_mapped", [32, 771]], [[733, 733], "disallowed_STD3_mapped", [32, 779]], [[734, 734], "valid", [], "NV8"], [[735, 735], "valid", [], "NV8"], [[736, 736], "mapped", [611]], [[737, 737], "mapped", [108]], [[738, 738], "mapped", [115]], [[739, 739], "mapped", [120]], [[740, 740], "mapped", [661]], [[741, 745], "valid", [], "NV8"], [[746, 747], "valid", [], "NV8"], [[748, 748], "valid"], [[749, 749], "valid", [], "NV8"], [[750, 750], "valid"], [[751, 767], "valid", [], "NV8"], [[768, 831], "valid"], [[832, 832], "mapped", [768]], [[833, 833], "mapped", [769]], [[834, 834], "valid"], [[835, 835], "mapped", [787]], [[836, 836], "mapped", [776, 769]], [[837, 837], "mapped", [953]], [[838, 846], "valid"], [[847, 847], "ignored"], [[848, 855], "valid"], [[856, 860], "valid"], [[861, 863], "valid"], [[864, 865], "valid"], [[866, 866], "valid"], [[867, 879], "valid"], [[880, 880], "mapped", [881]], [[881, 881], "valid"], [[882, 882], "mapped", [883]], [[883, 883], "valid"], [[884, 884], "mapped", [697]], [[885, 885], "valid"], [[886, 886], "mapped", [887]], [[887, 887], "valid"], [[888, 889], "disallowed"], [[890, 890], "disallowed_STD3_mapped", [32, 953]], [[891, 893], "valid"], [[894, 894], "disallowed_STD3_mapped", [59]], [[895, 895], "mapped", [1011]], [[896, 899], "disallowed"], [[900, 900], "disallowed_STD3_mapped", [32, 769]], [[901, 901], "disallowed_STD3_mapped", [32, 776, 769]], [[902, 902], "mapped", [940]], [[903, 903], "mapped", [183]], [[904, 904], "mapped", [941]], [[905, 905], "mapped", [942]], [[906, 906], "mapped", [943]], [[907, 907], "disallowed"], [[908, 908], "mapped", [972]], [[909, 909], "disallowed"], [[910, 910], "mapped", [973]], [[911, 911], "mapped", [974]], [[912, 912], "valid"], [[913, 913], "mapped", [945]], [[914, 914], "mapped", [946]], [[915, 915], "mapped", [947]], [[916, 916], "mapped", [948]], [[917, 917], "mapped", [949]], [[918, 918], "mapped", [950]], [[919, 919], "mapped", [951]], [[920, 920], "mapped", [952]], [[921, 921], "mapped", [953]], [[922, 922], "mapped", [954]], [[923, 923], "mapped", [955]], [[924, 924], "mapped", [956]], [[925, 925], "mapped", [957]], [[926, 926], "mapped", [958]], [[927, 927], "mapped", [959]], [[928, 928], "mapped", [960]], [[929, 929], "mapped", [961]], [[930, 930], "disallowed"], [[931, 931], "mapped", [963]], [[932, 932], "mapped", [964]], [[933, 933], "mapped", [965]], [[934, 934], "mapped", [966]], [[935, 935], "mapped", [967]], [[936, 936], "mapped", [968]], [[937, 937], "mapped", [969]], [[938, 938], "mapped", [970]], [[939, 939], "mapped", [971]], [[940, 961], "valid"], [[962, 962], "deviation", [963]], [[963, 974], "valid"], [[975, 975], "mapped", [983]], [[976, 976], "mapped", [946]], [[977, 977], "mapped", [952]], [[978, 978], "mapped", [965]], [[979, 979], "mapped", [973]], [[980, 980], "mapped", [971]], [[981, 981], "mapped", [966]], [[982, 982], "mapped", [960]], [[983, 983], "valid"], [[984, 984], "mapped", [985]], [[985, 985], "valid"], [[986, 986], "mapped", [987]], [[987, 987], "valid"], [[988, 988], "mapped", [989]], [[989, 989], "valid"], [[990, 990], "mapped", [991]], [[991, 991], "valid"], [[992, 992], "mapped", [993]], [[993, 993], "valid"], [[994, 994], "mapped", [995]], [[995, 995], "valid"], [[996, 996], "mapped", [997]], [[997, 997], "valid"], [[998, 998], "mapped", [999]], [[999, 999], "valid"], [[1e3, 1e3], "mapped", [1001]], [[1001, 1001], "valid"], [[1002, 1002], "mapped", [1003]], [[1003, 1003], "valid"], [[1004, 1004], "mapped", [1005]], [[1005, 1005], "valid"], [[1006, 1006], "mapped", [1007]], [[1007, 1007], "valid"], [[1008, 1008], "mapped", [954]], [[1009, 1009], "mapped", [961]], [[1010, 1010], "mapped", [963]], [[1011, 1011], "valid"], [[1012, 1012], "mapped", [952]], [[1013, 1013], "mapped", [949]], [[1014, 1014], "valid", [], "NV8"], [[1015, 1015], "mapped", [1016]], [[1016, 1016], "valid"], [[1017, 1017], "mapped", [963]], [[1018, 1018], "mapped", [1019]], [[1019, 1019], "valid"], [[1020, 1020], "valid"], [[1021, 1021], "mapped", [891]], [[1022, 1022], "mapped", [892]], [[1023, 1023], "mapped", [893]], [[1024, 1024], "mapped", [1104]], [[1025, 1025], "mapped", [1105]], [[1026, 1026], "mapped", [1106]], [[1027, 1027], "mapped", [1107]], [[1028, 1028], "mapped", [1108]], [[1029, 1029], "mapped", [1109]], [[1030, 1030], "mapped", [1110]], [[1031, 1031], "mapped", [1111]], [[1032, 1032], "mapped", [1112]], [[1033, 1033], "mapped", [1113]], [[1034, 1034], "mapped", [1114]], [[1035, 1035], "mapped", [1115]], [[1036, 1036], "mapped", [1116]], [[1037, 1037], "mapped", [1117]], [[1038, 1038], "mapped", [1118]], [[1039, 1039], "mapped", [1119]], [[1040, 1040], "mapped", [1072]], [[1041, 1041], "mapped", [1073]], [[1042, 1042], "mapped", [1074]], [[1043, 1043], "mapped", [1075]], [[1044, 1044], "mapped", [1076]], [[1045, 1045], "mapped", [1077]], [[1046, 1046], "mapped", [1078]], [[1047, 1047], "mapped", [1079]], [[1048, 1048], "mapped", [1080]], [[1049, 1049], "mapped", [1081]], [[1050, 1050], "mapped", [1082]], [[1051, 1051], "mapped", [1083]], [[1052, 1052], "mapped", [1084]], [[1053, 1053], "mapped", [1085]], [[1054, 1054], "mapped", [1086]], [[1055, 1055], "mapped", [1087]], [[1056, 1056], "mapped", [1088]], [[1057, 1057], "mapped", [1089]], [[1058, 1058], "mapped", [1090]], [[1059, 1059], "mapped", [1091]], [[1060, 1060], "mapped", [1092]], [[1061, 1061], "mapped", [1093]], [[1062, 1062], "mapped", [1094]], [[1063, 1063], "mapped", [1095]], [[1064, 1064], "mapped", [1096]], [[1065, 1065], "mapped", [1097]], [[1066, 1066], "mapped", [1098]], [[1067, 1067], "mapped", [1099]], [[1068, 1068], "mapped", [1100]], [[1069, 1069], "mapped", [1101]], [[1070, 1070], "mapped", [1102]], [[1071, 1071], "mapped", [1103]], [[1072, 1103], "valid"], [[1104, 1104], "valid"], [[1105, 1116], "valid"], [[1117, 1117], "valid"], [[1118, 1119], "valid"], [[1120, 1120], "mapped", [1121]], [[1121, 1121], "valid"], [[1122, 1122], "mapped", [1123]], [[1123, 1123], "valid"], [[1124, 1124], "mapped", [1125]], [[1125, 1125], "valid"], [[1126, 1126], "mapped", [1127]], [[1127, 1127], "valid"], [[1128, 1128], "mapped", [1129]], [[1129, 1129], "valid"], [[1130, 1130], "mapped", [1131]], [[1131, 1131], "valid"], [[1132, 1132], "mapped", [1133]], [[1133, 1133], "valid"], [[1134, 1134], "mapped", [1135]], [[1135, 1135], "valid"], [[1136, 1136], "mapped", [1137]], [[1137, 1137], "valid"], [[1138, 1138], "mapped", [1139]], [[1139, 1139], "valid"], [[1140, 1140], "mapped", [1141]], [[1141, 1141], "valid"], [[1142, 1142], "mapped", [1143]], [[1143, 1143], "valid"], [[1144, 1144], "mapped", [1145]], [[1145, 1145], "valid"], [[1146, 1146], "mapped", [1147]], [[1147, 1147], "valid"], [[1148, 1148], "mapped", [1149]], [[1149, 1149], "valid"], [[1150, 1150], "mapped", [1151]], [[1151, 1151], "valid"], [[1152, 1152], "mapped", [1153]], [[1153, 1153], "valid"], [[1154, 1154], "valid", [], "NV8"], [[1155, 1158], "valid"], [[1159, 1159], "valid"], [[1160, 1161], "valid", [], "NV8"], [[1162, 1162], "mapped", [1163]], [[1163, 1163], "valid"], [[1164, 1164], "mapped", [1165]], [[1165, 1165], "valid"], [[1166, 1166], "mapped", [1167]], [[1167, 1167], "valid"], [[1168, 1168], "mapped", [1169]], [[1169, 1169], "valid"], [[1170, 1170], "mapped", [1171]], [[1171, 1171], "valid"], [[1172, 1172], "mapped", [1173]], [[1173, 1173], "valid"], [[1174, 1174], "mapped", [1175]], [[1175, 1175], "valid"], [[1176, 1176], "mapped", [1177]], [[1177, 1177], "valid"], [[1178, 1178], "mapped", [1179]], [[1179, 1179], "valid"], [[1180, 1180], "mapped", [1181]], [[1181, 1181], "valid"], [[1182, 1182], "mapped", [1183]], [[1183, 1183], "valid"], [[1184, 1184], "mapped", [1185]], [[1185, 1185], "valid"], [[1186, 1186], "mapped", [1187]], [[1187, 1187], "valid"], [[1188, 1188], "mapped", [1189]], [[1189, 1189], "valid"], [[1190, 1190], "mapped", [1191]], [[1191, 1191], "valid"], [[1192, 1192], "mapped", [1193]], [[1193, 1193], "valid"], [[1194, 1194], "mapped", [1195]], [[1195, 1195], "valid"], [[1196, 1196], "mapped", [1197]], [[1197, 1197], "valid"], [[1198, 1198], "mapped", [1199]], [[1199, 1199], "valid"], [[1200, 1200], "mapped", [1201]], [[1201, 1201], "valid"], [[1202, 1202], "mapped", [1203]], [[1203, 1203], "valid"], [[1204, 1204], "mapped", [1205]], [[1205, 1205], "valid"], [[1206, 1206], "mapped", [1207]], [[1207, 1207], "valid"], [[1208, 1208], "mapped", [1209]], [[1209, 1209], "valid"], [[1210, 1210], "mapped", [1211]], [[1211, 1211], "valid"], [[1212, 1212], "mapped", [1213]], [[1213, 1213], "valid"], [[1214, 1214], "mapped", [1215]], [[1215, 1215], "valid"], [[1216, 1216], "disallowed"], [[1217, 1217], "mapped", [1218]], [[1218, 1218], "valid"], [[1219, 1219], "mapped", [1220]], [[1220, 1220], "valid"], [[1221, 1221], "mapped", [1222]], [[1222, 1222], "valid"], [[1223, 1223], "mapped", [1224]], [[1224, 1224], "valid"], [[1225, 1225], "mapped", [1226]], [[1226, 1226], "valid"], [[1227, 1227], "mapped", [1228]], [[1228, 1228], "valid"], [[1229, 1229], "mapped", [1230]], [[1230, 1230], "valid"], [[1231, 1231], "valid"], [[1232, 1232], "mapped", [1233]], [[1233, 1233], "valid"], [[1234, 1234], "mapped", [1235]], [[1235, 1235], "valid"], [[1236, 1236], "mapped", [1237]], [[1237, 1237], "valid"], [[1238, 1238], "mapped", [1239]], [[1239, 1239], "valid"], [[1240, 1240], "mapped", [1241]], [[1241, 1241], "valid"], [[1242, 1242], "mapped", [1243]], [[1243, 1243], "valid"], [[1244, 1244], "mapped", [1245]], [[1245, 1245], "valid"], [[1246, 1246], "mapped", [1247]], [[1247, 1247], "valid"], [[1248, 1248], "mapped", [1249]], [[1249, 1249], "valid"], [[1250, 1250], "mapped", [1251]], [[1251, 1251], "valid"], [[1252, 1252], "mapped", [1253]], [[1253, 1253], "valid"], [[1254, 1254], "mapped", [1255]], [[1255, 1255], "valid"], [[1256, 1256], "mapped", [1257]], [[1257, 1257], "valid"], [[1258, 1258], "mapped", [1259]], [[1259, 1259], "valid"], [[1260, 1260], "mapped", [1261]], [[1261, 1261], "valid"], [[1262, 1262], "mapped", [1263]], [[1263, 1263], "valid"], [[1264, 1264], "mapped", [1265]], [[1265, 1265], "valid"], [[1266, 1266], "mapped", [1267]], [[1267, 1267], "valid"], [[1268, 1268], "mapped", [1269]], [[1269, 1269], "valid"], [[1270, 1270], "mapped", [1271]], [[1271, 1271], "valid"], [[1272, 1272], "mapped", [1273]], [[1273, 1273], "valid"], [[1274, 1274], "mapped", [1275]], [[1275, 1275], "valid"], [[1276, 1276], "mapped", [1277]], [[1277, 1277], "valid"], [[1278, 1278], "mapped", [1279]], [[1279, 1279], "valid"], [[1280, 1280], "mapped", [1281]], [[1281, 1281], "valid"], [[1282, 1282], "mapped", [1283]], [[1283, 1283], "valid"], [[1284, 1284], "mapped", [1285]], [[1285, 1285], "valid"], [[1286, 1286], "mapped", [1287]], [[1287, 1287], "valid"], [[1288, 1288], "mapped", [1289]], [[1289, 1289], "valid"], [[1290, 1290], "mapped", [1291]], [[1291, 1291], "valid"], [[1292, 1292], "mapped", [1293]], [[1293, 1293], "valid"], [[1294, 1294], "mapped", [1295]], [[1295, 1295], "valid"], [[1296, 1296], "mapped", [1297]], [[1297, 1297], "valid"], [[1298, 1298], "mapped", [1299]], [[1299, 1299], "valid"], [[1300, 1300], "mapped", [1301]], [[1301, 1301], "valid"], [[1302, 1302], "mapped", [1303]], [[1303, 1303], "valid"], [[1304, 1304], "mapped", [1305]], [[1305, 1305], "valid"], [[1306, 1306], "mapped", [1307]], [[1307, 1307], "valid"], [[1308, 1308], "mapped", [1309]], [[1309, 1309], "valid"], [[1310, 1310], "mapped", [1311]], [[1311, 1311], "valid"], [[1312, 1312], "mapped", [1313]], [[1313, 1313], "valid"], [[1314, 1314], "mapped", [1315]], [[1315, 1315], "valid"], [[1316, 1316], "mapped", [1317]], [[1317, 1317], "valid"], [[1318, 1318], "mapped", [1319]], [[1319, 1319], "valid"], [[1320, 1320], "mapped", [1321]], [[1321, 1321], "valid"], [[1322, 1322], "mapped", [1323]], [[1323, 1323], "valid"], [[1324, 1324], "mapped", [1325]], [[1325, 1325], "valid"], [[1326, 1326], "mapped", [1327]], [[1327, 1327], "valid"], [[1328, 1328], "disallowed"], [[1329, 1329], "mapped", [1377]], [[1330, 1330], "mapped", [1378]], [[1331, 1331], "mapped", [1379]], [[1332, 1332], "mapped", [1380]], [[1333, 1333], "mapped", [1381]], [[1334, 1334], "mapped", [1382]], [[1335, 1335], "mapped", [1383]], [[1336, 1336], "mapped", [1384]], [[1337, 1337], "mapped", [1385]], [[1338, 1338], "mapped", [1386]], [[1339, 1339], "mapped", [1387]], [[1340, 1340], "mapped", [1388]], [[1341, 1341], "mapped", [1389]], [[1342, 1342], "mapped", [1390]], [[1343, 1343], "mapped", [1391]], [[1344, 1344], "mapped", [1392]], [[1345, 1345], "mapped", [1393]], [[1346, 1346], "mapped", [1394]], [[1347, 1347], "mapped", [1395]], [[1348, 1348], "mapped", [1396]], [[1349, 1349], "mapped", [1397]], [[1350, 1350], "mapped", [1398]], [[1351, 1351], "mapped", [1399]], [[1352, 1352], "mapped", [1400]], [[1353, 1353], "mapped", [1401]], [[1354, 1354], "mapped", [1402]], [[1355, 1355], "mapped", [1403]], [[1356, 1356], "mapped", [1404]], [[1357, 1357], "mapped", [1405]], [[1358, 1358], "mapped", [1406]], [[1359, 1359], "mapped", [1407]], [[1360, 1360], "mapped", [1408]], [[1361, 1361], "mapped", [1409]], [[1362, 1362], "mapped", [1410]], [[1363, 1363], "mapped", [1411]], [[1364, 1364], "mapped", [1412]], [[1365, 1365], "mapped", [1413]], [[1366, 1366], "mapped", [1414]], [[1367, 1368], "disallowed"], [[1369, 1369], "valid"], [[1370, 1375], "valid", [], "NV8"], [[1376, 1376], "disallowed"], [[1377, 1414], "valid"], [[1415, 1415], "mapped", [1381, 1410]], [[1416, 1416], "disallowed"], [[1417, 1417], "valid", [], "NV8"], [[1418, 1418], "valid", [], "NV8"], [[1419, 1420], "disallowed"], [[1421, 1422], "valid", [], "NV8"], [[1423, 1423], "valid", [], "NV8"], [[1424, 1424], "disallowed"], [[1425, 1441], "valid"], [[1442, 1442], "valid"], [[1443, 1455], "valid"], [[1456, 1465], "valid"], [[1466, 1466], "valid"], [[1467, 1469], "valid"], [[1470, 1470], "valid", [], "NV8"], [[1471, 1471], "valid"], [[1472, 1472], "valid", [], "NV8"], [[1473, 1474], "valid"], [[1475, 1475], "valid", [], "NV8"], [[1476, 1476], "valid"], [[1477, 1477], "valid"], [[1478, 1478], "valid", [], "NV8"], [[1479, 1479], "valid"], [[1480, 1487], "disallowed"], [[1488, 1514], "valid"], [[1515, 1519], "disallowed"], [[1520, 1524], "valid"], [[1525, 1535], "disallowed"], [[1536, 1539], "disallowed"], [[1540, 1540], "disallowed"], [[1541, 1541], "disallowed"], [[1542, 1546], "valid", [], "NV8"], [[1547, 1547], "valid", [], "NV8"], [[1548, 1548], "valid", [], "NV8"], [[1549, 1551], "valid", [], "NV8"], [[1552, 1557], "valid"], [[1558, 1562], "valid"], [[1563, 1563], "valid", [], "NV8"], [[1564, 1564], "disallowed"], [[1565, 1565], "disallowed"], [[1566, 1566], "valid", [], "NV8"], [[1567, 1567], "valid", [], "NV8"], [[1568, 1568], "valid"], [[1569, 1594], "valid"], [[1595, 1599], "valid"], [[1600, 1600], "valid", [], "NV8"], [[1601, 1618], "valid"], [[1619, 1621], "valid"], [[1622, 1624], "valid"], [[1625, 1630], "valid"], [[1631, 1631], "valid"], [[1632, 1641], "valid"], [[1642, 1645], "valid", [], "NV8"], [[1646, 1647], "valid"], [[1648, 1652], "valid"], [[1653, 1653], "mapped", [1575, 1652]], [[1654, 1654], "mapped", [1608, 1652]], [[1655, 1655], "mapped", [1735, 1652]], [[1656, 1656], "mapped", [1610, 1652]], [[1657, 1719], "valid"], [[1720, 1721], "valid"], [[1722, 1726], "valid"], [[1727, 1727], "valid"], [[1728, 1742], "valid"], [[1743, 1743], "valid"], [[1744, 1747], "valid"], [[1748, 1748], "valid", [], "NV8"], [[1749, 1756], "valid"], [[1757, 1757], "disallowed"], [[1758, 1758], "valid", [], "NV8"], [[1759, 1768], "valid"], [[1769, 1769], "valid", [], "NV8"], [[1770, 1773], "valid"], [[1774, 1775], "valid"], [[1776, 1785], "valid"], [[1786, 1790], "valid"], [[1791, 1791], "valid"], [[1792, 1805], "valid", [], "NV8"], [[1806, 1806], "disallowed"], [[1807, 1807], "disallowed"], [[1808, 1836], "valid"], [[1837, 1839], "valid"], [[1840, 1866], "valid"], [[1867, 1868], "disallowed"], [[1869, 1871], "valid"], [[1872, 1901], "valid"], [[1902, 1919], "valid"], [[1920, 1968], "valid"], [[1969, 1969], "valid"], [[1970, 1983], "disallowed"], [[1984, 2037], "valid"], [[2038, 2042], "valid", [], "NV8"], [[2043, 2047], "disallowed"], [[2048, 2093], "valid"], [[2094, 2095], "disallowed"], [[2096, 2110], "valid", [], "NV8"], [[2111, 2111], "disallowed"], [[2112, 2139], "valid"], [[2140, 2141], "disallowed"], [[2142, 2142], "valid", [], "NV8"], [[2143, 2207], "disallowed"], [[2208, 2208], "valid"], [[2209, 2209], "valid"], [[2210, 2220], "valid"], [[2221, 2226], "valid"], [[2227, 2228], "valid"], [[2229, 2274], "disallowed"], [[2275, 2275], "valid"], [[2276, 2302], "valid"], [[2303, 2303], "valid"], [[2304, 2304], "valid"], [[2305, 2307], "valid"], [[2308, 2308], "valid"], [[2309, 2361], "valid"], [[2362, 2363], "valid"], [[2364, 2381], "valid"], [[2382, 2382], "valid"], [[2383, 2383], "valid"], [[2384, 2388], "valid"], [[2389, 2389], "valid"], [[2390, 2391], "valid"], [[2392, 2392], "mapped", [2325, 2364]], [[2393, 2393], "mapped", [2326, 2364]], [[2394, 2394], "mapped", [2327, 2364]], [[2395, 2395], "mapped", [2332, 2364]], [[2396, 2396], "mapped", [2337, 2364]], [[2397, 2397], "mapped", [2338, 2364]], [[2398, 2398], "mapped", [2347, 2364]], [[2399, 2399], "mapped", [2351, 2364]], [[2400, 2403], "valid"], [[2404, 2405], "valid", [], "NV8"], [[2406, 2415], "valid"], [[2416, 2416], "valid", [], "NV8"], [[2417, 2418], "valid"], [[2419, 2423], "valid"], [[2424, 2424], "valid"], [[2425, 2426], "valid"], [[2427, 2428], "valid"], [[2429, 2429], "valid"], [[2430, 2431], "valid"], [[2432, 2432], "valid"], [[2433, 2435], "valid"], [[2436, 2436], "disallowed"], [[2437, 2444], "valid"], [[2445, 2446], "disallowed"], [[2447, 2448], "valid"], [[2449, 2450], "disallowed"], [[2451, 2472], "valid"], [[2473, 2473], "disallowed"], [[2474, 2480], "valid"], [[2481, 2481], "disallowed"], [[2482, 2482], "valid"], [[2483, 2485], "disallowed"], [[2486, 2489], "valid"], [[2490, 2491], "disallowed"], [[2492, 2492], "valid"], [[2493, 2493], "valid"], [[2494, 2500], "valid"], [[2501, 2502], "disallowed"], [[2503, 2504], "valid"], [[2505, 2506], "disallowed"], [[2507, 2509], "valid"], [[2510, 2510], "valid"], [[2511, 2518], "disallowed"], [[2519, 2519], "valid"], [[2520, 2523], "disallowed"], [[2524, 2524], "mapped", [2465, 2492]], [[2525, 2525], "mapped", [2466, 2492]], [[2526, 2526], "disallowed"], [[2527, 2527], "mapped", [2479, 2492]], [[2528, 2531], "valid"], [[2532, 2533], "disallowed"], [[2534, 2545], "valid"], [[2546, 2554], "valid", [], "NV8"], [[2555, 2555], "valid", [], "NV8"], [[2556, 2560], "disallowed"], [[2561, 2561], "valid"], [[2562, 2562], "valid"], [[2563, 2563], "valid"], [[2564, 2564], "disallowed"], [[2565, 2570], "valid"], [[2571, 2574], "disallowed"], [[2575, 2576], "valid"], [[2577, 2578], "disallowed"], [[2579, 2600], "valid"], [[2601, 2601], "disallowed"], [[2602, 2608], "valid"], [[2609, 2609], "disallowed"], [[2610, 2610], "valid"], [[2611, 2611], "mapped", [2610, 2620]], [[2612, 2612], "disallowed"], [[2613, 2613], "valid"], [[2614, 2614], "mapped", [2616, 2620]], [[2615, 2615], "disallowed"], [[2616, 2617], "valid"], [[2618, 2619], "disallowed"], [[2620, 2620], "valid"], [[2621, 2621], "disallowed"], [[2622, 2626], "valid"], [[2627, 2630], "disallowed"], [[2631, 2632], "valid"], [[2633, 2634], "disallowed"], [[2635, 2637], "valid"], [[2638, 2640], "disallowed"], [[2641, 2641], "valid"], [[2642, 2648], "disallowed"], [[2649, 2649], "mapped", [2582, 2620]], [[2650, 2650], "mapped", [2583, 2620]], [[2651, 2651], "mapped", [2588, 2620]], [[2652, 2652], "valid"], [[2653, 2653], "disallowed"], [[2654, 2654], "mapped", [2603, 2620]], [[2655, 2661], "disallowed"], [[2662, 2676], "valid"], [[2677, 2677], "valid"], [[2678, 2688], "disallowed"], [[2689, 2691], "valid"], [[2692, 2692], "disallowed"], [[2693, 2699], "valid"], [[2700, 2700], "valid"], [[2701, 2701], "valid"], [[2702, 2702], "disallowed"], [[2703, 2705], "valid"], [[2706, 2706], "disallowed"], [[2707, 2728], "valid"], [[2729, 2729], "disallowed"], [[2730, 2736], "valid"], [[2737, 2737], "disallowed"], [[2738, 2739], "valid"], [[2740, 2740], "disallowed"], [[2741, 2745], "valid"], [[2746, 2747], "disallowed"], [[2748, 2757], "valid"], [[2758, 2758], "disallowed"], [[2759, 2761], "valid"], [[2762, 2762], "disallowed"], [[2763, 2765], "valid"], [[2766, 2767], "disallowed"], [[2768, 2768], "valid"], [[2769, 2783], "disallowed"], [[2784, 2784], "valid"], [[2785, 2787], "valid"], [[2788, 2789], "disallowed"], [[2790, 2799], "valid"], [[2800, 2800], "valid", [], "NV8"], [[2801, 2801], "valid", [], "NV8"], [[2802, 2808], "disallowed"], [[2809, 2809], "valid"], [[2810, 2816], "disallowed"], [[2817, 2819], "valid"], [[2820, 2820], "disallowed"], [[2821, 2828], "valid"], [[2829, 2830], "disallowed"], [[2831, 2832], "valid"], [[2833, 2834], "disallowed"], [[2835, 2856], "valid"], [[2857, 2857], "disallowed"], [[2858, 2864], "valid"], [[2865, 2865], "disallowed"], [[2866, 2867], "valid"], [[2868, 2868], "disallowed"], [[2869, 2869], "valid"], [[2870, 2873], "valid"], [[2874, 2875], "disallowed"], [[2876, 2883], "valid"], [[2884, 2884], "valid"], [[2885, 2886], "disallowed"], [[2887, 2888], "valid"], [[2889, 2890], "disallowed"], [[2891, 2893], "valid"], [[2894, 2901], "disallowed"], [[2902, 2903], "valid"], [[2904, 2907], "disallowed"], [[2908, 2908], "mapped", [2849, 2876]], [[2909, 2909], "mapped", [2850, 2876]], [[2910, 2910], "disallowed"], [[2911, 2913], "valid"], [[2914, 2915], "valid"], [[2916, 2917], "disallowed"], [[2918, 2927], "valid"], [[2928, 2928], "valid", [], "NV8"], [[2929, 2929], "valid"], [[2930, 2935], "valid", [], "NV8"], [[2936, 2945], "disallowed"], [[2946, 2947], "valid"], [[2948, 2948], "disallowed"], [[2949, 2954], "valid"], [[2955, 2957], "disallowed"], [[2958, 2960], "valid"], [[2961, 2961], "disallowed"], [[2962, 2965], "valid"], [[2966, 2968], "disallowed"], [[2969, 2970], "valid"], [[2971, 2971], "disallowed"], [[2972, 2972], "valid"], [[2973, 2973], "disallowed"], [[2974, 2975], "valid"], [[2976, 2978], "disallowed"], [[2979, 2980], "valid"], [[2981, 2983], "disallowed"], [[2984, 2986], "valid"], [[2987, 2989], "disallowed"], [[2990, 2997], "valid"], [[2998, 2998], "valid"], [[2999, 3001], "valid"], [[3002, 3005], "disallowed"], [[3006, 3010], "valid"], [[3011, 3013], "disallowed"], [[3014, 3016], "valid"], [[3017, 3017], "disallowed"], [[3018, 3021], "valid"], [[3022, 3023], "disallowed"], [[3024, 3024], "valid"], [[3025, 3030], "disallowed"], [[3031, 3031], "valid"], [[3032, 3045], "disallowed"], [[3046, 3046], "valid"], [[3047, 3055], "valid"], [[3056, 3058], "valid", [], "NV8"], [[3059, 3066], "valid", [], "NV8"], [[3067, 3071], "disallowed"], [[3072, 3072], "valid"], [[3073, 3075], "valid"], [[3076, 3076], "disallowed"], [[3077, 3084], "valid"], [[3085, 3085], "disallowed"], [[3086, 3088], "valid"], [[3089, 3089], "disallowed"], [[3090, 3112], "valid"], [[3113, 3113], "disallowed"], [[3114, 3123], "valid"], [[3124, 3124], "valid"], [[3125, 3129], "valid"], [[3130, 3132], "disallowed"], [[3133, 3133], "valid"], [[3134, 3140], "valid"], [[3141, 3141], "disallowed"], [[3142, 3144], "valid"], [[3145, 3145], "disallowed"], [[3146, 3149], "valid"], [[3150, 3156], "disallowed"], [[3157, 3158], "valid"], [[3159, 3159], "disallowed"], [[3160, 3161], "valid"], [[3162, 3162], "valid"], [[3163, 3167], "disallowed"], [[3168, 3169], "valid"], [[3170, 3171], "valid"], [[3172, 3173], "disallowed"], [[3174, 3183], "valid"], [[3184, 3191], "disallowed"], [[3192, 3199], "valid", [], "NV8"], [[3200, 3200], "disallowed"], [[3201, 3201], "valid"], [[3202, 3203], "valid"], [[3204, 3204], "disallowed"], [[3205, 3212], "valid"], [[3213, 3213], "disallowed"], [[3214, 3216], "valid"], [[3217, 3217], "disallowed"], [[3218, 3240], "valid"], [[3241, 3241], "disallowed"], [[3242, 3251], "valid"], [[3252, 3252], "disallowed"], [[3253, 3257], "valid"], [[3258, 3259], "disallowed"], [[3260, 3261], "valid"], [[3262, 3268], "valid"], [[3269, 3269], "disallowed"], [[3270, 3272], "valid"], [[3273, 3273], "disallowed"], [[3274, 3277], "valid"], [[3278, 3284], "disallowed"], [[3285, 3286], "valid"], [[3287, 3293], "disallowed"], [[3294, 3294], "valid"], [[3295, 3295], "disallowed"], [[3296, 3297], "valid"], [[3298, 3299], "valid"], [[3300, 3301], "disallowed"], [[3302, 3311], "valid"], [[3312, 3312], "disallowed"], [[3313, 3314], "valid"], [[3315, 3328], "disallowed"], [[3329, 3329], "valid"], [[3330, 3331], "valid"], [[3332, 3332], "disallowed"], [[3333, 3340], "valid"], [[3341, 3341], "disallowed"], [[3342, 3344], "valid"], [[3345, 3345], "disallowed"], [[3346, 3368], "valid"], [[3369, 3369], "valid"], [[3370, 3385], "valid"], [[3386, 3386], "valid"], [[3387, 3388], "disallowed"], [[3389, 3389], "valid"], [[3390, 3395], "valid"], [[3396, 3396], "valid"], [[3397, 3397], "disallowed"], [[3398, 3400], "valid"], [[3401, 3401], "disallowed"], [[3402, 3405], "valid"], [[3406, 3406], "valid"], [[3407, 3414], "disallowed"], [[3415, 3415], "valid"], [[3416, 3422], "disallowed"], [[3423, 3423], "valid"], [[3424, 3425], "valid"], [[3426, 3427], "valid"], [[3428, 3429], "disallowed"], [[3430, 3439], "valid"], [[3440, 3445], "valid", [], "NV8"], [[3446, 3448], "disallowed"], [[3449, 3449], "valid", [], "NV8"], [[3450, 3455], "valid"], [[3456, 3457], "disallowed"], [[3458, 3459], "valid"], [[3460, 3460], "disallowed"], [[3461, 3478], "valid"], [[3479, 3481], "disallowed"], [[3482, 3505], "valid"], [[3506, 3506], "disallowed"], [[3507, 3515], "valid"], [[3516, 3516], "disallowed"], [[3517, 3517], "valid"], [[3518, 3519], "disallowed"], [[3520, 3526], "valid"], [[3527, 3529], "disallowed"], [[3530, 3530], "valid"], [[3531, 3534], "disallowed"], [[3535, 3540], "valid"], [[3541, 3541], "disallowed"], [[3542, 3542], "valid"], [[3543, 3543], "disallowed"], [[3544, 3551], "valid"], [[3552, 3557], "disallowed"], [[3558, 3567], "valid"], [[3568, 3569], "disallowed"], [[3570, 3571], "valid"], [[3572, 3572], "valid", [], "NV8"], [[3573, 3584], "disallowed"], [[3585, 3634], "valid"], [[3635, 3635], "mapped", [3661, 3634]], [[3636, 3642], "valid"], [[3643, 3646], "disallowed"], [[3647, 3647], "valid", [], "NV8"], [[3648, 3662], "valid"], [[3663, 3663], "valid", [], "NV8"], [[3664, 3673], "valid"], [[3674, 3675], "valid", [], "NV8"], [[3676, 3712], "disallowed"], [[3713, 3714], "valid"], [[3715, 3715], "disallowed"], [[3716, 3716], "valid"], [[3717, 3718], "disallowed"], [[3719, 3720], "valid"], [[3721, 3721], "disallowed"], [[3722, 3722], "valid"], [[3723, 3724], "disallowed"], [[3725, 3725], "valid"], [[3726, 3731], "disallowed"], [[3732, 3735], "valid"], [[3736, 3736], "disallowed"], [[3737, 3743], "valid"], [[3744, 3744], "disallowed"], [[3745, 3747], "valid"], [[3748, 3748], "disallowed"], [[3749, 3749], "valid"], [[3750, 3750], "disallowed"], [[3751, 3751], "valid"], [[3752, 3753], "disallowed"], [[3754, 3755], "valid"], [[3756, 3756], "disallowed"], [[3757, 3762], "valid"], [[3763, 3763], "mapped", [3789, 3762]], [[3764, 3769], "valid"], [[3770, 3770], "disallowed"], [[3771, 3773], "valid"], [[3774, 3775], "disallowed"], [[3776, 3780], "valid"], [[3781, 3781], "disallowed"], [[3782, 3782], "valid"], [[3783, 3783], "disallowed"], [[3784, 3789], "valid"], [[3790, 3791], "disallowed"], [[3792, 3801], "valid"], [[3802, 3803], "disallowed"], [[3804, 3804], "mapped", [3755, 3737]], [[3805, 3805], "mapped", [3755, 3745]], [[3806, 3807], "valid"], [[3808, 3839], "disallowed"], [[3840, 3840], "valid"], [[3841, 3850], "valid", [], "NV8"], [[3851, 3851], "valid"], [[3852, 3852], "mapped", [3851]], [[3853, 3863], "valid", [], "NV8"], [[3864, 3865], "valid"], [[3866, 3871], "valid", [], "NV8"], [[3872, 3881], "valid"], [[3882, 3892], "valid", [], "NV8"], [[3893, 3893], "valid"], [[3894, 3894], "valid", [], "NV8"], [[3895, 3895], "valid"], [[3896, 3896], "valid", [], "NV8"], [[3897, 3897], "valid"], [[3898, 3901], "valid", [], "NV8"], [[3902, 3906], "valid"], [[3907, 3907], "mapped", [3906, 4023]], [[3908, 3911], "valid"], [[3912, 3912], "disallowed"], [[3913, 3916], "valid"], [[3917, 3917], "mapped", [3916, 4023]], [[3918, 3921], "valid"], [[3922, 3922], "mapped", [3921, 4023]], [[3923, 3926], "valid"], [[3927, 3927], "mapped", [3926, 4023]], [[3928, 3931], "valid"], [[3932, 3932], "mapped", [3931, 4023]], [[3933, 3944], "valid"], [[3945, 3945], "mapped", [3904, 4021]], [[3946, 3946], "valid"], [[3947, 3948], "valid"], [[3949, 3952], "disallowed"], [[3953, 3954], "valid"], [[3955, 3955], "mapped", [3953, 3954]], [[3956, 3956], "valid"], [[3957, 3957], "mapped", [3953, 3956]], [[3958, 3958], "mapped", [4018, 3968]], [[3959, 3959], "mapped", [4018, 3953, 3968]], [[3960, 3960], "mapped", [4019, 3968]], [[3961, 3961], "mapped", [4019, 3953, 3968]], [[3962, 3968], "valid"], [[3969, 3969], "mapped", [3953, 3968]], [[3970, 3972], "valid"], [[3973, 3973], "valid", [], "NV8"], [[3974, 3979], "valid"], [[3980, 3983], "valid"], [[3984, 3986], "valid"], [[3987, 3987], "mapped", [3986, 4023]], [[3988, 3989], "valid"], [[3990, 3990], "valid"], [[3991, 3991], "valid"], [[3992, 3992], "disallowed"], [[3993, 3996], "valid"], [[3997, 3997], "mapped", [3996, 4023]], [[3998, 4001], "valid"], [[4002, 4002], "mapped", [4001, 4023]], [[4003, 4006], "valid"], [[4007, 4007], "mapped", [4006, 4023]], [[4008, 4011], "valid"], [[4012, 4012], "mapped", [4011, 4023]], [[4013, 4013], "valid"], [[4014, 4016], "valid"], [[4017, 4023], "valid"], [[4024, 4024], "valid"], [[4025, 4025], "mapped", [3984, 4021]], [[4026, 4028], "valid"], [[4029, 4029], "disallowed"], [[4030, 4037], "valid", [], "NV8"], [[4038, 4038], "valid"], [[4039, 4044], "valid", [], "NV8"], [[4045, 4045], "disallowed"], [[4046, 4046], "valid", [], "NV8"], [[4047, 4047], "valid", [], "NV8"], [[4048, 4049], "valid", [], "NV8"], [[4050, 4052], "valid", [], "NV8"], [[4053, 4056], "valid", [], "NV8"], [[4057, 4058], "valid", [], "NV8"], [[4059, 4095], "disallowed"], [[4096, 4129], "valid"], [[4130, 4130], "valid"], [[4131, 4135], "valid"], [[4136, 4136], "valid"], [[4137, 4138], "valid"], [[4139, 4139], "valid"], [[4140, 4146], "valid"], [[4147, 4149], "valid"], [[4150, 4153], "valid"], [[4154, 4159], "valid"], [[4160, 4169], "valid"], [[4170, 4175], "valid", [], "NV8"], [[4176, 4185], "valid"], [[4186, 4249], "valid"], [[4250, 4253], "valid"], [[4254, 4255], "valid", [], "NV8"], [[4256, 4293], "disallowed"], [[4294, 4294], "disallowed"], [[4295, 4295], "mapped", [11559]], [[4296, 4300], "disallowed"], [[4301, 4301], "mapped", [11565]], [[4302, 4303], "disallowed"], [[4304, 4342], "valid"], [[4343, 4344], "valid"], [[4345, 4346], "valid"], [[4347, 4347], "valid", [], "NV8"], [[4348, 4348], "mapped", [4316]], [[4349, 4351], "valid"], [[4352, 4441], "valid", [], "NV8"], [[4442, 4446], "valid", [], "NV8"], [[4447, 4448], "disallowed"], [[4449, 4514], "valid", [], "NV8"], [[4515, 4519], "valid", [], "NV8"], [[4520, 4601], "valid", [], "NV8"], [[4602, 4607], "valid", [], "NV8"], [[4608, 4614], "valid"], [[4615, 4615], "valid"], [[4616, 4678], "valid"], [[4679, 4679], "valid"], [[4680, 4680], "valid"], [[4681, 4681], "disallowed"], [[4682, 4685], "valid"], [[4686, 4687], "disallowed"], [[4688, 4694], "valid"], [[4695, 4695], "disallowed"], [[4696, 4696], "valid"], [[4697, 4697], "disallowed"], [[4698, 4701], "valid"], [[4702, 4703], "disallowed"], [[4704, 4742], "valid"], [[4743, 4743], "valid"], [[4744, 4744], "valid"], [[4745, 4745], "disallowed"], [[4746, 4749], "valid"], [[4750, 4751], "disallowed"], [[4752, 4782], "valid"], [[4783, 4783], "valid"], [[4784, 4784], "valid"], [[4785, 4785], "disallowed"], [[4786, 4789], "valid"], [[4790, 4791], "disallowed"], [[4792, 4798], "valid"], [[4799, 4799], "disallowed"], [[4800, 4800], "valid"], [[4801, 4801], "disallowed"], [[4802, 4805], "valid"], [[4806, 4807], "disallowed"], [[4808, 4814], "valid"], [[4815, 4815], "valid"], [[4816, 4822], "valid"], [[4823, 4823], "disallowed"], [[4824, 4846], "valid"], [[4847, 4847], "valid"], [[4848, 4878], "valid"], [[4879, 4879], "valid"], [[4880, 4880], "valid"], [[4881, 4881], "disallowed"], [[4882, 4885], "valid"], [[4886, 4887], "disallowed"], [[4888, 4894], "valid"], [[4895, 4895], "valid"], [[4896, 4934], "valid"], [[4935, 4935], "valid"], [[4936, 4954], "valid"], [[4955, 4956], "disallowed"], [[4957, 4958], "valid"], [[4959, 4959], "valid"], [[4960, 4960], "valid", [], "NV8"], [[4961, 4988], "valid", [], "NV8"], [[4989, 4991], "disallowed"], [[4992, 5007], "valid"], [[5008, 5017], "valid", [], "NV8"], [[5018, 5023], "disallowed"], [[5024, 5108], "valid"], [[5109, 5109], "valid"], [[5110, 5111], "disallowed"], [[5112, 5112], "mapped", [5104]], [[5113, 5113], "mapped", [5105]], [[5114, 5114], "mapped", [5106]], [[5115, 5115], "mapped", [5107]], [[5116, 5116], "mapped", [5108]], [[5117, 5117], "mapped", [5109]], [[5118, 5119], "disallowed"], [[5120, 5120], "valid", [], "NV8"], [[5121, 5740], "valid"], [[5741, 5742], "valid", [], "NV8"], [[5743, 5750], "valid"], [[5751, 5759], "valid"], [[5760, 5760], "disallowed"], [[5761, 5786], "valid"], [[5787, 5788], "valid", [], "NV8"], [[5789, 5791], "disallowed"], [[5792, 5866], "valid"], [[5867, 5872], "valid", [], "NV8"], [[5873, 5880], "valid"], [[5881, 5887], "disallowed"], [[5888, 5900], "valid"], [[5901, 5901], "disallowed"], [[5902, 5908], "valid"], [[5909, 5919], "disallowed"], [[5920, 5940], "valid"], [[5941, 5942], "valid", [], "NV8"], [[5943, 5951], "disallowed"], [[5952, 5971], "valid"], [[5972, 5983], "disallowed"], [[5984, 5996], "valid"], [[5997, 5997], "disallowed"], [[5998, 6e3], "valid"], [[6001, 6001], "disallowed"], [[6002, 6003], "valid"], [[6004, 6015], "disallowed"], [[6016, 6067], "valid"], [[6068, 6069], "disallowed"], [[6070, 6099], "valid"], [[6100, 6102], "valid", [], "NV8"], [[6103, 6103], "valid"], [[6104, 6107], "valid", [], "NV8"], [[6108, 6108], "valid"], [[6109, 6109], "valid"], [[6110, 6111], "disallowed"], [[6112, 6121], "valid"], [[6122, 6127], "disallowed"], [[6128, 6137], "valid", [], "NV8"], [[6138, 6143], "disallowed"], [[6144, 6149], "valid", [], "NV8"], [[6150, 6150], "disallowed"], [[6151, 6154], "valid", [], "NV8"], [[6155, 6157], "ignored"], [[6158, 6158], "disallowed"], [[6159, 6159], "disallowed"], [[6160, 6169], "valid"], [[6170, 6175], "disallowed"], [[6176, 6263], "valid"], [[6264, 6271], "disallowed"], [[6272, 6313], "valid"], [[6314, 6314], "valid"], [[6315, 6319], "disallowed"], [[6320, 6389], "valid"], [[6390, 6399], "disallowed"], [[6400, 6428], "valid"], [[6429, 6430], "valid"], [[6431, 6431], "disallowed"], [[6432, 6443], "valid"], [[6444, 6447], "disallowed"], [[6448, 6459], "valid"], [[6460, 6463], "disallowed"], [[6464, 6464], "valid", [], "NV8"], [[6465, 6467], "disallowed"], [[6468, 6469], "valid", [], "NV8"], [[6470, 6509], "valid"], [[6510, 6511], "disallowed"], [[6512, 6516], "valid"], [[6517, 6527], "disallowed"], [[6528, 6569], "valid"], [[6570, 6571], "valid"], [[6572, 6575], "disallowed"], [[6576, 6601], "valid"], [[6602, 6607], "disallowed"], [[6608, 6617], "valid"], [[6618, 6618], "valid", [], "XV8"], [[6619, 6621], "disallowed"], [[6622, 6623], "valid", [], "NV8"], [[6624, 6655], "valid", [], "NV8"], [[6656, 6683], "valid"], [[6684, 6685], "disallowed"], [[6686, 6687], "valid", [], "NV8"], [[6688, 6750], "valid"], [[6751, 6751], "disallowed"], [[6752, 6780], "valid"], [[6781, 6782], "disallowed"], [[6783, 6793], "valid"], [[6794, 6799], "disallowed"], [[6800, 6809], "valid"], [[6810, 6815], "disallowed"], [[6816, 6822], "valid", [], "NV8"], [[6823, 6823], "valid"], [[6824, 6829], "valid", [], "NV8"], [[6830, 6831], "disallowed"], [[6832, 6845], "valid"], [[6846, 6846], "valid", [], "NV8"], [[6847, 6911], "disallowed"], [[6912, 6987], "valid"], [[6988, 6991], "disallowed"], [[6992, 7001], "valid"], [[7002, 7018], "valid", [], "NV8"], [[7019, 7027], "valid"], [[7028, 7036], "valid", [], "NV8"], [[7037, 7039], "disallowed"], [[7040, 7082], "valid"], [[7083, 7085], "valid"], [[7086, 7097], "valid"], [[7098, 7103], "valid"], [[7104, 7155], "valid"], [[7156, 7163], "disallowed"], [[7164, 7167], "valid", [], "NV8"], [[7168, 7223], "valid"], [[7224, 7226], "disallowed"], [[7227, 7231], "valid", [], "NV8"], [[7232, 7241], "valid"], [[7242, 7244], "disallowed"], [[7245, 7293], "valid"], [[7294, 7295], "valid", [], "NV8"], [[7296, 7359], "disallowed"], [[7360, 7367], "valid", [], "NV8"], [[7368, 7375], "disallowed"], [[7376, 7378], "valid"], [[7379, 7379], "valid", [], "NV8"], [[7380, 7410], "valid"], [[7411, 7414], "valid"], [[7415, 7415], "disallowed"], [[7416, 7417], "valid"], [[7418, 7423], "disallowed"], [[7424, 7467], "valid"], [[7468, 7468], "mapped", [97]], [[7469, 7469], "mapped", [230]], [[7470, 7470], "mapped", [98]], [[7471, 7471], "valid"], [[7472, 7472], "mapped", [100]], [[7473, 7473], "mapped", [101]], [[7474, 7474], "mapped", [477]], [[7475, 7475], "mapped", [103]], [[7476, 7476], "mapped", [104]], [[7477, 7477], "mapped", [105]], [[7478, 7478], "mapped", [106]], [[7479, 7479], "mapped", [107]], [[7480, 7480], "mapped", [108]], [[7481, 7481], "mapped", [109]], [[7482, 7482], "mapped", [110]], [[7483, 7483], "valid"], [[7484, 7484], "mapped", [111]], [[7485, 7485], "mapped", [547]], [[7486, 7486], "mapped", [112]], [[7487, 7487], "mapped", [114]], [[7488, 7488], "mapped", [116]], [[7489, 7489], "mapped", [117]], [[7490, 7490], "mapped", [119]], [[7491, 7491], "mapped", [97]], [[7492, 7492], "mapped", [592]], [[7493, 7493], "mapped", [593]], [[7494, 7494], "mapped", [7426]], [[7495, 7495], "mapped", [98]], [[7496, 7496], "mapped", [100]], [[7497, 7497], "mapped", [101]], [[7498, 7498], "mapped", [601]], [[7499, 7499], "mapped", [603]], [[7500, 7500], "mapped", [604]], [[7501, 7501], "mapped", [103]], [[7502, 7502], "valid"], [[7503, 7503], "mapped", [107]], [[7504, 7504], "mapped", [109]], [[7505, 7505], "mapped", [331]], [[7506, 7506], "mapped", [111]], [[7507, 7507], "mapped", [596]], [[7508, 7508], "mapped", [7446]], [[7509, 7509], "mapped", [7447]], [[7510, 7510], "mapped", [112]], [[7511, 7511], "mapped", [116]], [[7512, 7512], "mapped", [117]], [[7513, 7513], "mapped", [7453]], [[7514, 7514], "mapped", [623]], [[7515, 7515], "mapped", [118]], [[7516, 7516], "mapped", [7461]], [[7517, 7517], "mapped", [946]], [[7518, 7518], "mapped", [947]], [[7519, 7519], "mapped", [948]], [[7520, 7520], "mapped", [966]], [[7521, 7521], "mapped", [967]], [[7522, 7522], "mapped", [105]], [[7523, 7523], "mapped", [114]], [[7524, 7524], "mapped", [117]], [[7525, 7525], "mapped", [118]], [[7526, 7526], "mapped", [946]], [[7527, 7527], "mapped", [947]], [[7528, 7528], "mapped", [961]], [[7529, 7529], "mapped", [966]], [[7530, 7530], "mapped", [967]], [[7531, 7531], "valid"], [[7532, 7543], "valid"], [[7544, 7544], "mapped", [1085]], [[7545, 7578], "valid"], [[7579, 7579], "mapped", [594]], [[7580, 7580], "mapped", [99]], [[7581, 7581], "mapped", [597]], [[7582, 7582], "mapped", [240]], [[7583, 7583], "mapped", [604]], [[7584, 7584], "mapped", [102]], [[7585, 7585], "mapped", [607]], [[7586, 7586], "mapped", [609]], [[7587, 7587], "mapped", [613]], [[7588, 7588], "mapped", [616]], [[7589, 7589], "mapped", [617]], [[7590, 7590], "mapped", [618]], [[7591, 7591], "mapped", [7547]], [[7592, 7592], "mapped", [669]], [[7593, 7593], "mapped", [621]], [[7594, 7594], "mapped", [7557]], [[7595, 7595], "mapped", [671]], [[7596, 7596], "mapped", [625]], [[7597, 7597], "mapped", [624]], [[7598, 7598], "mapped", [626]], [[7599, 7599], "mapped", [627]], [[7600, 7600], "mapped", [628]], [[7601, 7601], "mapped", [629]], [[7602, 7602], "mapped", [632]], [[7603, 7603], "mapped", [642]], [[7604, 7604], "mapped", [643]], [[7605, 7605], "mapped", [427]], [[7606, 7606], "mapped", [649]], [[7607, 7607], "mapped", [650]], [[7608, 7608], "mapped", [7452]], [[7609, 7609], "mapped", [651]], [[7610, 7610], "mapped", [652]], [[7611, 7611], "mapped", [122]], [[7612, 7612], "mapped", [656]], [[7613, 7613], "mapped", [657]], [[7614, 7614], "mapped", [658]], [[7615, 7615], "mapped", [952]], [[7616, 7619], "valid"], [[7620, 7626], "valid"], [[7627, 7654], "valid"], [[7655, 7669], "valid"], [[7670, 7675], "disallowed"], [[7676, 7676], "valid"], [[7677, 7677], "valid"], [[7678, 7679], "valid"], [[7680, 7680], "mapped", [7681]], [[7681, 7681], "valid"], [[7682, 7682], "mapped", [7683]], [[7683, 7683], "valid"], [[7684, 7684], "mapped", [7685]], [[7685, 7685], "valid"], [[7686, 7686], "mapped", [7687]], [[7687, 7687], "valid"], [[7688, 7688], "mapped", [7689]], [[7689, 7689], "valid"], [[7690, 7690], "mapped", [7691]], [[7691, 7691], "valid"], [[7692, 7692], "mapped", [7693]], [[7693, 7693], "valid"], [[7694, 7694], "mapped", [7695]], [[7695, 7695], "valid"], [[7696, 7696], "mapped", [7697]], [[7697, 7697], "valid"], [[7698, 7698], "mapped", [7699]], [[7699, 7699], "valid"], [[7700, 7700], "mapped", [7701]], [[7701, 7701], "valid"], [[7702, 7702], "mapped", [7703]], [[7703, 7703], "valid"], [[7704, 7704], "mapped", [7705]], [[7705, 7705], "valid"], [[7706, 7706], "mapped", [7707]], [[7707, 7707], "valid"], [[7708, 7708], "mapped", [7709]], [[7709, 7709], "valid"], [[7710, 7710], "mapped", [7711]], [[7711, 7711], "valid"], [[7712, 7712], "mapped", [7713]], [[7713, 7713], "valid"], [[7714, 7714], "mapped", [7715]], [[7715, 7715], "valid"], [[7716, 7716], "mapped", [7717]], [[7717, 7717], "valid"], [[7718, 7718], "mapped", [7719]], [[7719, 7719], "valid"], [[7720, 7720], "mapped", [7721]], [[7721, 7721], "valid"], [[7722, 7722], "mapped", [7723]], [[7723, 7723], "valid"], [[7724, 7724], "mapped", [7725]], [[7725, 7725], "valid"], [[7726, 7726], "mapped", [7727]], [[7727, 7727], "valid"], [[7728, 7728], "mapped", [7729]], [[7729, 7729], "valid"], [[7730, 7730], "mapped", [7731]], [[7731, 7731], "valid"], [[7732, 7732], "mapped", [7733]], [[7733, 7733], "valid"], [[7734, 7734], "mapped", [7735]], [[7735, 7735], "valid"], [[7736, 7736], "mapped", [7737]], [[7737, 7737], "valid"], [[7738, 7738], "mapped", [7739]], [[7739, 7739], "valid"], [[7740, 7740], "mapped", [7741]], [[7741, 7741], "valid"], [[7742, 7742], "mapped", [7743]], [[7743, 7743], "valid"], [[7744, 7744], "mapped", [7745]], [[7745, 7745], "valid"], [[7746, 7746], "mapped", [7747]], [[7747, 7747], "valid"], [[7748, 7748], "mapped", [7749]], [[7749, 7749], "valid"], [[7750, 7750], "mapped", [7751]], [[7751, 7751], "valid"], [[7752, 7752], "mapped", [7753]], [[7753, 7753], "valid"], [[7754, 7754], "mapped", [7755]], [[7755, 7755], "valid"], [[7756, 7756], "mapped", [7757]], [[7757, 7757], "valid"], [[7758, 7758], "mapped", [7759]], [[7759, 7759], "valid"], [[7760, 7760], "mapped", [7761]], [[7761, 7761], "valid"], [[7762, 7762], "mapped", [7763]], [[7763, 7763], "valid"], [[7764, 7764], "mapped", [7765]], [[7765, 7765], "valid"], [[7766, 7766], "mapped", [7767]], [[7767, 7767], "valid"], [[7768, 7768], "mapped", [7769]], [[7769, 7769], "valid"], [[7770, 7770], "mapped", [7771]], [[7771, 7771], "valid"], [[7772, 7772], "mapped", [7773]], [[7773, 7773], "valid"], [[7774, 7774], "mapped", [7775]], [[7775, 7775], "valid"], [[7776, 7776], "mapped", [7777]], [[7777, 7777], "valid"], [[7778, 7778], "mapped", [7779]], [[7779, 7779], "valid"], [[7780, 7780], "mapped", [7781]], [[7781, 7781], "valid"], [[7782, 7782], "mapped", [7783]], [[7783, 7783], "valid"], [[7784, 7784], "mapped", [7785]], [[7785, 7785], "valid"], [[7786, 7786], "mapped", [7787]], [[7787, 7787], "valid"], [[7788, 7788], "mapped", [7789]], [[7789, 7789], "valid"], [[7790, 7790], "mapped", [7791]], [[7791, 7791], "valid"], [[7792, 7792], "mapped", [7793]], [[7793, 7793], "valid"], [[7794, 7794], "mapped", [7795]], [[7795, 7795], "valid"], [[7796, 7796], "mapped", [7797]], [[7797, 7797], "valid"], [[7798, 7798], "mapped", [7799]], [[7799, 7799], "valid"], [[7800, 7800], "mapped", [7801]], [[7801, 7801], "valid"], [[7802, 7802], "mapped", [7803]], [[7803, 7803], "valid"], [[7804, 7804], "mapped", [7805]], [[7805, 7805], "valid"], [[7806, 7806], "mapped", [7807]], [[7807, 7807], "valid"], [[7808, 7808], "mapped", [7809]], [[7809, 7809], "valid"], [[7810, 7810], "mapped", [7811]], [[7811, 7811], "valid"], [[7812, 7812], "mapped", [7813]], [[7813, 7813], "valid"], [[7814, 7814], "mapped", [7815]], [[7815, 7815], "valid"], [[7816, 7816], "mapped", [7817]], [[7817, 7817], "valid"], [[7818, 7818], "mapped", [7819]], [[7819, 7819], "valid"], [[7820, 7820], "mapped", [7821]], [[7821, 7821], "valid"], [[7822, 7822], "mapped", [7823]], [[7823, 7823], "valid"], [[7824, 7824], "mapped", [7825]], [[7825, 7825], "valid"], [[7826, 7826], "mapped", [7827]], [[7827, 7827], "valid"], [[7828, 7828], "mapped", [7829]], [[7829, 7833], "valid"], [[7834, 7834], "mapped", [97, 702]], [[7835, 7835], "mapped", [7777]], [[7836, 7837], "valid"], [[7838, 7838], "mapped", [115, 115]], [[7839, 7839], "valid"], [[7840, 7840], "mapped", [7841]], [[7841, 7841], "valid"], [[7842, 7842], "mapped", [7843]], [[7843, 7843], "valid"], [[7844, 7844], "mapped", [7845]], [[7845, 7845], "valid"], [[7846, 7846], "mapped", [7847]], [[7847, 7847], "valid"], [[7848, 7848], "mapped", [7849]], [[7849, 7849], "valid"], [[7850, 7850], "mapped", [7851]], [[7851, 7851], "valid"], [[7852, 7852], "mapped", [7853]], [[7853, 7853], "valid"], [[7854, 7854], "mapped", [7855]], [[7855, 7855], "valid"], [[7856, 7856], "mapped", [7857]], [[7857, 7857], "valid"], [[7858, 7858], "mapped", [7859]], [[7859, 7859], "valid"], [[7860, 7860], "mapped", [7861]], [[7861, 7861], "valid"], [[7862, 7862], "mapped", [7863]], [[7863, 7863], "valid"], [[7864, 7864], "mapped", [7865]], [[7865, 7865], "valid"], [[7866, 7866], "mapped", [7867]], [[7867, 7867], "valid"], [[7868, 7868], "mapped", [7869]], [[7869, 7869], "valid"], [[7870, 7870], "mapped", [7871]], [[7871, 7871], "valid"], [[7872, 7872], "mapped", [7873]], [[7873, 7873], "valid"], [[7874, 7874], "mapped", [7875]], [[7875, 7875], "valid"], [[7876, 7876], "mapped", [7877]], [[7877, 7877], "valid"], [[7878, 7878], "mapped", [7879]], [[7879, 7879], "valid"], [[7880, 7880], "mapped", [7881]], [[7881, 7881], "valid"], [[7882, 7882], "mapped", [7883]], [[7883, 7883], "valid"], [[7884, 7884], "mapped", [7885]], [[7885, 7885], "valid"], [[7886, 7886], "mapped", [7887]], [[7887, 7887], "valid"], [[7888, 7888], "mapped", [7889]], [[7889, 7889], "valid"], [[7890, 7890], "mapped", [7891]], [[7891, 7891], "valid"], [[7892, 7892], "mapped", [7893]], [[7893, 7893], "valid"], [[7894, 7894], "mapped", [7895]], [[7895, 7895], "valid"], [[7896, 7896], "mapped", [7897]], [[7897, 7897], "valid"], [[7898, 7898], "mapped", [7899]], [[7899, 7899], "valid"], [[7900, 7900], "mapped", [7901]], [[7901, 7901], "valid"], [[7902, 7902], "mapped", [7903]], [[7903, 7903], "valid"], [[7904, 7904], "mapped", [7905]], [[7905, 7905], "valid"], [[7906, 7906], "mapped", [7907]], [[7907, 7907], "valid"], [[7908, 7908], "mapped", [7909]], [[7909, 7909], "valid"], [[7910, 7910], "mapped", [7911]], [[7911, 7911], "valid"], [[7912, 7912], "mapped", [7913]], [[7913, 7913], "valid"], [[7914, 7914], "mapped", [7915]], [[7915, 7915], "valid"], [[7916, 7916], "mapped", [7917]], [[7917, 7917], "valid"], [[7918, 7918], "mapped", [7919]], [[7919, 7919], "valid"], [[7920, 7920], "mapped", [7921]], [[7921, 7921], "valid"], [[7922, 7922], "mapped", [7923]], [[7923, 7923], "valid"], [[7924, 7924], "mapped", [7925]], [[7925, 7925], "valid"], [[7926, 7926], "mapped", [7927]], [[7927, 7927], "valid"], [[7928, 7928], "mapped", [7929]], [[7929, 7929], "valid"], [[7930, 7930], "mapped", [7931]], [[7931, 7931], "valid"], [[7932, 7932], "mapped", [7933]], [[7933, 7933], "valid"], [[7934, 7934], "mapped", [7935]], [[7935, 7935], "valid"], [[7936, 7943], "valid"], [[7944, 7944], "mapped", [7936]], [[7945, 7945], "mapped", [7937]], [[7946, 7946], "mapped", [7938]], [[7947, 7947], "mapped", [7939]], [[7948, 7948], "mapped", [7940]], [[7949, 7949], "mapped", [7941]], [[7950, 7950], "mapped", [7942]], [[7951, 7951], "mapped", [7943]], [[7952, 7957], "valid"], [[7958, 7959], "disallowed"], [[7960, 7960], "mapped", [7952]], [[7961, 7961], "mapped", [7953]], [[7962, 7962], "mapped", [7954]], [[7963, 7963], "mapped", [7955]], [[7964, 7964], "mapped", [7956]], [[7965, 7965], "mapped", [7957]], [[7966, 7967], "disallowed"], [[7968, 7975], "valid"], [[7976, 7976], "mapped", [7968]], [[7977, 7977], "mapped", [7969]], [[7978, 7978], "mapped", [7970]], [[7979, 7979], "mapped", [7971]], [[7980, 7980], "mapped", [7972]], [[7981, 7981], "mapped", [7973]], [[7982, 7982], "mapped", [7974]], [[7983, 7983], "mapped", [7975]], [[7984, 7991], "valid"], [[7992, 7992], "mapped", [7984]], [[7993, 7993], "mapped", [7985]], [[7994, 7994], "mapped", [7986]], [[7995, 7995], "mapped", [7987]], [[7996, 7996], "mapped", [7988]], [[7997, 7997], "mapped", [7989]], [[7998, 7998], "mapped", [7990]], [[7999, 7999], "mapped", [7991]], [[8e3, 8005], "valid"], [[8006, 8007], "disallowed"], [[8008, 8008], "mapped", [8e3]], [[8009, 8009], "mapped", [8001]], [[8010, 8010], "mapped", [8002]], [[8011, 8011], "mapped", [8003]], [[8012, 8012], "mapped", [8004]], [[8013, 8013], "mapped", [8005]], [[8014, 8015], "disallowed"], [[8016, 8023], "valid"], [[8024, 8024], "disallowed"], [[8025, 8025], "mapped", [8017]], [[8026, 8026], "disallowed"], [[8027, 8027], "mapped", [8019]], [[8028, 8028], "disallowed"], [[8029, 8029], "mapped", [8021]], [[8030, 8030], "disallowed"], [[8031, 8031], "mapped", [8023]], [[8032, 8039], "valid"], [[8040, 8040], "mapped", [8032]], [[8041, 8041], "mapped", [8033]], [[8042, 8042], "mapped", [8034]], [[8043, 8043], "mapped", [8035]], [[8044, 8044], "mapped", [8036]], [[8045, 8045], "mapped", [8037]], [[8046, 8046], "mapped", [8038]], [[8047, 8047], "mapped", [8039]], [[8048, 8048], "valid"], [[8049, 8049], "mapped", [940]], [[8050, 8050], "valid"], [[8051, 8051], "mapped", [941]], [[8052, 8052], "valid"], [[8053, 8053], "mapped", [942]], [[8054, 8054], "valid"], [[8055, 8055], "mapped", [943]], [[8056, 8056], "valid"], [[8057, 8057], "mapped", [972]], [[8058, 8058], "valid"], [[8059, 8059], "mapped", [973]], [[8060, 8060], "valid"], [[8061, 8061], "mapped", [974]], [[8062, 8063], "disallowed"], [[8064, 8064], "mapped", [7936, 953]], [[8065, 8065], "mapped", [7937, 953]], [[8066, 8066], "mapped", [7938, 953]], [[8067, 8067], "mapped", [7939, 953]], [[8068, 8068], "mapped", [7940, 953]], [[8069, 8069], "mapped", [7941, 953]], [[8070, 8070], "mapped", [7942, 953]], [[8071, 8071], "mapped", [7943, 953]], [[8072, 8072], "mapped", [7936, 953]], [[8073, 8073], "mapped", [7937, 953]], [[8074, 8074], "mapped", [7938, 953]], [[8075, 8075], "mapped", [7939, 953]], [[8076, 8076], "mapped", [7940, 953]], [[8077, 8077], "mapped", [7941, 953]], [[8078, 8078], "mapped", [7942, 953]], [[8079, 8079], "mapped", [7943, 953]], [[8080, 8080], "mapped", [7968, 953]], [[8081, 8081], "mapped", [7969, 953]], [[8082, 8082], "mapped", [7970, 953]], [[8083, 8083], "mapped", [7971, 953]], [[8084, 8084], "mapped", [7972, 953]], [[8085, 8085], "mapped", [7973, 953]], [[8086, 8086], "mapped", [7974, 953]], [[8087, 8087], "mapped", [7975, 953]], [[8088, 8088], "mapped", [7968, 953]], [[8089, 8089], "mapped", [7969, 953]], [[8090, 8090], "mapped", [7970, 953]], [[8091, 8091], "mapped", [7971, 953]], [[8092, 8092], "mapped", [7972, 953]], [[8093, 8093], "mapped", [7973, 953]], [[8094, 8094], "mapped", [7974, 953]], [[8095, 8095], "mapped", [7975, 953]], [[8096, 8096], "mapped", [8032, 953]], [[8097, 8097], "mapped", [8033, 953]], [[8098, 8098], "mapped", [8034, 953]], [[8099, 8099], "mapped", [8035, 953]], [[8100, 8100], "mapped", [8036, 953]], [[8101, 8101], "mapped", [8037, 953]], [[8102, 8102], "mapped", [8038, 953]], [[8103, 8103], "mapped", [8039, 953]], [[8104, 8104], "mapped", [8032, 953]], [[8105, 8105], "mapped", [8033, 953]], [[8106, 8106], "mapped", [8034, 953]], [[8107, 8107], "mapped", [8035, 953]], [[8108, 8108], "mapped", [8036, 953]], [[8109, 8109], "mapped", [8037, 953]], [[8110, 8110], "mapped", [8038, 953]], [[8111, 8111], "mapped", [8039, 953]], [[8112, 8113], "valid"], [[8114, 8114], "mapped", [8048, 953]], [[8115, 8115], "mapped", [945, 953]], [[8116, 8116], "mapped", [940, 953]], [[8117, 8117], "disallowed"], [[8118, 8118], "valid"], [[8119, 8119], "mapped", [8118, 953]], [[8120, 8120], "mapped", [8112]], [[8121, 8121], "mapped", [8113]], [[8122, 8122], "mapped", [8048]], [[8123, 8123], "mapped", [940]], [[8124, 8124], "mapped", [945, 953]], [[8125, 8125], "disallowed_STD3_mapped", [32, 787]], [[8126, 8126], "mapped", [953]], [[8127, 8127], "disallowed_STD3_mapped", [32, 787]], [[8128, 8128], "disallowed_STD3_mapped", [32, 834]], [[8129, 8129], "disallowed_STD3_mapped", [32, 776, 834]], [[8130, 8130], "mapped", [8052, 953]], [[8131, 8131], "mapped", [951, 953]], [[8132, 8132], "mapped", [942, 953]], [[8133, 8133], "disallowed"], [[8134, 8134], "valid"], [[8135, 8135], "mapped", [8134, 953]], [[8136, 8136], "mapped", [8050]], [[8137, 8137], "mapped", [941]], [[8138, 8138], "mapped", [8052]], [[8139, 8139], "mapped", [942]], [[8140, 8140], "mapped", [951, 953]], [[8141, 8141], "disallowed_STD3_mapped", [32, 787, 768]], [[8142, 8142], "disallowed_STD3_mapped", [32, 787, 769]], [[8143, 8143], "disallowed_STD3_mapped", [32, 787, 834]], [[8144, 8146], "valid"], [[8147, 8147], "mapped", [912]], [[8148, 8149], "disallowed"], [[8150, 8151], "valid"], [[8152, 8152], "mapped", [8144]], [[8153, 8153], "mapped", [8145]], [[8154, 8154], "mapped", [8054]], [[8155, 8155], "mapped", [943]], [[8156, 8156], "disallowed"], [[8157, 8157], "disallowed_STD3_mapped", [32, 788, 768]], [[8158, 8158], "disallowed_STD3_mapped", [32, 788, 769]], [[8159, 8159], "disallowed_STD3_mapped", [32, 788, 834]], [[8160, 8162], "valid"], [[8163, 8163], "mapped", [944]], [[8164, 8167], "valid"], [[8168, 8168], "mapped", [8160]], [[8169, 8169], "mapped", [8161]], [[8170, 8170], "mapped", [8058]], [[8171, 8171], "mapped", [973]], [[8172, 8172], "mapped", [8165]], [[8173, 8173], "disallowed_STD3_mapped", [32, 776, 768]], [[8174, 8174], "disallowed_STD3_mapped", [32, 776, 769]], [[8175, 8175], "disallowed_STD3_mapped", [96]], [[8176, 8177], "disallowed"], [[8178, 8178], "mapped", [8060, 953]], [[8179, 8179], "mapped", [969, 953]], [[8180, 8180], "mapped", [974, 953]], [[8181, 8181], "disallowed"], [[8182, 8182], "valid"], [[8183, 8183], "mapped", [8182, 953]], [[8184, 8184], "mapped", [8056]], [[8185, 8185], "mapped", [972]], [[8186, 8186], "mapped", [8060]], [[8187, 8187], "mapped", [974]], [[8188, 8188], "mapped", [969, 953]], [[8189, 8189], "disallowed_STD3_mapped", [32, 769]], [[8190, 8190], "disallowed_STD3_mapped", [32, 788]], [[8191, 8191], "disallowed"], [[8192, 8202], "disallowed_STD3_mapped", [32]], [[8203, 8203], "ignored"], [[8204, 8205], "deviation", []], [[8206, 8207], "disallowed"], [[8208, 8208], "valid", [], "NV8"], [[8209, 8209], "mapped", [8208]], [[8210, 8214], "valid", [], "NV8"], [[8215, 8215], "disallowed_STD3_mapped", [32, 819]], [[8216, 8227], "valid", [], "NV8"], [[8228, 8230], "disallowed"], [[8231, 8231], "valid", [], "NV8"], [[8232, 8238], "disallowed"], [[8239, 8239], "disallowed_STD3_mapped", [32]], [[8240, 8242], "valid", [], "NV8"], [[8243, 8243], "mapped", [8242, 8242]], [[8244, 8244], "mapped", [8242, 8242, 8242]], [[8245, 8245], "valid", [], "NV8"], [[8246, 8246], "mapped", [8245, 8245]], [[8247, 8247], "mapped", [8245, 8245, 8245]], [[8248, 8251], "valid", [], "NV8"], [[8252, 8252], "disallowed_STD3_mapped", [33, 33]], [[8253, 8253], "valid", [], "NV8"], [[8254, 8254], "disallowed_STD3_mapped", [32, 773]], [[8255, 8262], "valid", [], "NV8"], [[8263, 8263], "disallowed_STD3_mapped", [63, 63]], [[8264, 8264], "disallowed_STD3_mapped", [63, 33]], [[8265, 8265], "disallowed_STD3_mapped", [33, 63]], [[8266, 8269], "valid", [], "NV8"], [[8270, 8274], "valid", [], "NV8"], [[8275, 8276], "valid", [], "NV8"], [[8277, 8278], "valid", [], "NV8"], [[8279, 8279], "mapped", [8242, 8242, 8242, 8242]], [[8280, 8286], "valid", [], "NV8"], [[8287, 8287], "disallowed_STD3_mapped", [32]], [[8288, 8288], "ignored"], [[8289, 8291], "disallowed"], [[8292, 8292], "ignored"], [[8293, 8293], "disallowed"], [[8294, 8297], "disallowed"], [[8298, 8303], "disallowed"], [[8304, 8304], "mapped", [48]], [[8305, 8305], "mapped", [105]], [[8306, 8307], "disallowed"], [[8308, 8308], "mapped", [52]], [[8309, 8309], "mapped", [53]], [[8310, 8310], "mapped", [54]], [[8311, 8311], "mapped", [55]], [[8312, 8312], "mapped", [56]], [[8313, 8313], "mapped", [57]], [[8314, 8314], "disallowed_STD3_mapped", [43]], [[8315, 8315], "mapped", [8722]], [[8316, 8316], "disallowed_STD3_mapped", [61]], [[8317, 8317], "disallowed_STD3_mapped", [40]], [[8318, 8318], "disallowed_STD3_mapped", [41]], [[8319, 8319], "mapped", [110]], [[8320, 8320], "mapped", [48]], [[8321, 8321], "mapped", [49]], [[8322, 8322], "mapped", [50]], [[8323, 8323], "mapped", [51]], [[8324, 8324], "mapped", [52]], [[8325, 8325], "mapped", [53]], [[8326, 8326], "mapped", [54]], [[8327, 8327], "mapped", [55]], [[8328, 8328], "mapped", [56]], [[8329, 8329], "mapped", [57]], [[8330, 8330], "disallowed_STD3_mapped", [43]], [[8331, 8331], "mapped", [8722]], [[8332, 8332], "disallowed_STD3_mapped", [61]], [[8333, 8333], "disallowed_STD3_mapped", [40]], [[8334, 8334], "disallowed_STD3_mapped", [41]], [[8335, 8335], "disallowed"], [[8336, 8336], "mapped", [97]], [[8337, 8337], "mapped", [101]], [[8338, 8338], "mapped", [111]], [[8339, 8339], "mapped", [120]], [[8340, 8340], "mapped", [601]], [[8341, 8341], "mapped", [104]], [[8342, 8342], "mapped", [107]], [[8343, 8343], "mapped", [108]], [[8344, 8344], "mapped", [109]], [[8345, 8345], "mapped", [110]], [[8346, 8346], "mapped", [112]], [[8347, 8347], "mapped", [115]], [[8348, 8348], "mapped", [116]], [[8349, 8351], "disallowed"], [[8352, 8359], "valid", [], "NV8"], [[8360, 8360], "mapped", [114, 115]], [[8361, 8362], "valid", [], "NV8"], [[8363, 8363], "valid", [], "NV8"], [[8364, 8364], "valid", [], "NV8"], [[8365, 8367], "valid", [], "NV8"], [[8368, 8369], "valid", [], "NV8"], [[8370, 8373], "valid", [], "NV8"], [[8374, 8376], "valid", [], "NV8"], [[8377, 8377], "valid", [], "NV8"], [[8378, 8378], "valid", [], "NV8"], [[8379, 8381], "valid", [], "NV8"], [[8382, 8382], "valid", [], "NV8"], [[8383, 8399], "disallowed"], [[8400, 8417], "valid", [], "NV8"], [[8418, 8419], "valid", [], "NV8"], [[8420, 8426], "valid", [], "NV8"], [[8427, 8427], "valid", [], "NV8"], [[8428, 8431], "valid", [], "NV8"], [[8432, 8432], "valid", [], "NV8"], [[8433, 8447], "disallowed"], [[8448, 8448], "disallowed_STD3_mapped", [97, 47, 99]], [[8449, 8449], "disallowed_STD3_mapped", [97, 47, 115]], [[8450, 8450], "mapped", [99]], [[8451, 8451], "mapped", [176, 99]], [[8452, 8452], "valid", [], "NV8"], [[8453, 8453], "disallowed_STD3_mapped", [99, 47, 111]], [[8454, 8454], "disallowed_STD3_mapped", [99, 47, 117]], [[8455, 8455], "mapped", [603]], [[8456, 8456], "valid", [], "NV8"], [[8457, 8457], "mapped", [176, 102]], [[8458, 8458], "mapped", [103]], [[8459, 8462], "mapped", [104]], [[8463, 8463], "mapped", [295]], [[8464, 8465], "mapped", [105]], [[8466, 8467], "mapped", [108]], [[8468, 8468], "valid", [], "NV8"], [[8469, 8469], "mapped", [110]], [[8470, 8470], "mapped", [110, 111]], [[8471, 8472], "valid", [], "NV8"], [[8473, 8473], "mapped", [112]], [[8474, 8474], "mapped", [113]], [[8475, 8477], "mapped", [114]], [[8478, 8479], "valid", [], "NV8"], [[8480, 8480], "mapped", [115, 109]], [[8481, 8481], "mapped", [116, 101, 108]], [[8482, 8482], "mapped", [116, 109]], [[8483, 8483], "valid", [], "NV8"], [[8484, 8484], "mapped", [122]], [[8485, 8485], "valid", [], "NV8"], [[8486, 8486], "mapped", [969]], [[8487, 8487], "valid", [], "NV8"], [[8488, 8488], "mapped", [122]], [[8489, 8489], "valid", [], "NV8"], [[8490, 8490], "mapped", [107]], [[8491, 8491], "mapped", [229]], [[8492, 8492], "mapped", [98]], [[8493, 8493], "mapped", [99]], [[8494, 8494], "valid", [], "NV8"], [[8495, 8496], "mapped", [101]], [[8497, 8497], "mapped", [102]], [[8498, 8498], "disallowed"], [[8499, 8499], "mapped", [109]], [[8500, 8500], "mapped", [111]], [[8501, 8501], "mapped", [1488]], [[8502, 8502], "mapped", [1489]], [[8503, 8503], "mapped", [1490]], [[8504, 8504], "mapped", [1491]], [[8505, 8505], "mapped", [105]], [[8506, 8506], "valid", [], "NV8"], [[8507, 8507], "mapped", [102, 97, 120]], [[8508, 8508], "mapped", [960]], [[8509, 8510], "mapped", [947]], [[8511, 8511], "mapped", [960]], [[8512, 8512], "mapped", [8721]], [[8513, 8516], "valid", [], "NV8"], [[8517, 8518], "mapped", [100]], [[8519, 8519], "mapped", [101]], [[8520, 8520], "mapped", [105]], [[8521, 8521], "mapped", [106]], [[8522, 8523], "valid", [], "NV8"], [[8524, 8524], "valid", [], "NV8"], [[8525, 8525], "valid", [], "NV8"], [[8526, 8526], "valid"], [[8527, 8527], "valid", [], "NV8"], [[8528, 8528], "mapped", [49, 8260, 55]], [[8529, 8529], "mapped", [49, 8260, 57]], [[8530, 8530], "mapped", [49, 8260, 49, 48]], [[8531, 8531], "mapped", [49, 8260, 51]], [[8532, 8532], "mapped", [50, 8260, 51]], [[8533, 8533], "mapped", [49, 8260, 53]], [[8534, 8534], "mapped", [50, 8260, 53]], [[8535, 8535], "mapped", [51, 8260, 53]], [[8536, 8536], "mapped", [52, 8260, 53]], [[8537, 8537], "mapped", [49, 8260, 54]], [[8538, 8538], "mapped", [53, 8260, 54]], [[8539, 8539], "mapped", [49, 8260, 56]], [[8540, 8540], "mapped", [51, 8260, 56]], [[8541, 8541], "mapped", [53, 8260, 56]], [[8542, 8542], "mapped", [55, 8260, 56]], [[8543, 8543], "mapped", [49, 8260]], [[8544, 8544], "mapped", [105]], [[8545, 8545], "mapped", [105, 105]], [[8546, 8546], "mapped", [105, 105, 105]], [[8547, 8547], "mapped", [105, 118]], [[8548, 8548], "mapped", [118]], [[8549, 8549], "mapped", [118, 105]], [[8550, 8550], "mapped", [118, 105, 105]], [[8551, 8551], "mapped", [118, 105, 105, 105]], [[8552, 8552], "mapped", [105, 120]], [[8553, 8553], "mapped", [120]], [[8554, 8554], "mapped", [120, 105]], [[8555, 8555], "mapped", [120, 105, 105]], [[8556, 8556], "mapped", [108]], [[8557, 8557], "mapped", [99]], [[8558, 8558], "mapped", [100]], [[8559, 8559], "mapped", [109]], [[8560, 8560], "mapped", [105]], [[8561, 8561], "mapped", [105, 105]], [[8562, 8562], "mapped", [105, 105, 105]], [[8563, 8563], "mapped", [105, 118]], [[8564, 8564], "mapped", [118]], [[8565, 8565], "mapped", [118, 105]], [[8566, 8566], "mapped", 