import { isBrowser } from '@probe.gl/env';
export var COLOR;
(function (COLOR) {
    COLOR[COLOR["BLACK"] = 30] = "BLACK";
    COLOR[COLOR["RED"] = 31] = "RED";
    COLOR[COLOR["GREEN"] = 32] = "GREEN";
    COLOR[COLOR["YELLOW"] = 33] = "YELLOW";
    COLOR[COLOR["BLUE"] = 34] = "BLUE";
    COLOR[COLOR["MAGENTA"] = 35] = "MAGENTA";
    COLOR[COLOR["CYAN"] = 36] = "CYAN";
    COLOR[COLOR["WHITE"] = 37] = "WHITE";
    COLOR[COLOR["BRIGHT_BLACK"] = 90] = "BRIGHT_BLACK";
    COLOR[COLOR["BRIGHT_RED"] = 91] = "BRIGHT_RED";
    COLOR[COLOR["BRIGHT_GREEN"] = 92] = "BRIGHT_GREEN";
    COLOR[COLOR["BRIGHT_YELLOW"] = 93] = "BRIGHT_YELLOW";
    COLOR[COLOR["BRIGHT_BLUE"] = 94] = "BRIGHT_BLUE";
    COLOR[COLOR["BRIGHT_MAGENTA"] = 95] = "BRIGHT_MAGENTA";
    COLOR[COLOR["BRIGHT_CYAN"] = 96] = "BRIGHT_CYAN";
    COLOR[COLOR["BRIGHT_WHITE"] = 97] = "BRIGHT_WHITE";
})(COLOR || (COLOR = {}));
const BACKGROUND_INCREMENT = 10;
function getColor(color) {
    if (typeof color !== 'string') {
        return color;
    }
    color = color.toUpperCase();
    return COLOR[color] || COLOR.WHITE;
}
export function addColor(string, color, background) {
    if (!isBrowser && typeof string === 'string') {
        if (color) {
            const colorCode = getColor(color);
            string = `\u001b[${colorCode}m${string}\u001b[39m`;
        }
        if (background) {
            // background colors values are +10
            const colorCode = getColor(background);
            string = `\u001b[${colorCode + BACKGROUND_INCREMENT}m${string}\u001b[49m`;
        }
    }
    return string;
}
//# sourceMappingURL=color.js.map