import Stat from "./stat.js";
type TableEntry = {
    time: number;
    count: number;
    average: number;
    hz: number;
};
/** A "bag" of `Stat` objects, can be visualized using `StatsWidget` */
export default class Stats {
    readonly id: string;
    readonly stats: Record<string, Stat>;
    constructor(options: {
        id: string;
        stats?: Stats | Stat[] | {
            name: string;
            type?: string;
        }[];
    });
    /** Acquire a stat. Create if it doesn't exist. */
    get(name: string, type?: string): Stat;
    get size(): number;
    /** Reset all stats */
    reset(): this;
    forEach(fn: (stat: Stat) => void): void;
    getTable(): Record<string, TableEntry>;
    _initializeStats(stats?: Stats | Stat[] | {
        name: string;
        type?: string;
    }[]): void;
    _getOrCreate(stat: Stat | {
        name: string;
        type?: string;
    }): Stat;
}
export {};
//# sourceMappingURL=stats.d.ts.map