var projs = [
  require('./tmerc'),
  require('./utm'),
  require('./sterea'),
  require('./stere'),
  require('./somerc'),
  require('./omerc'),
  require('./lcc'),
  require('./krovak'),
  require('./cass'),
  require('./laea'),
  require('./merc'),
  require('./aea'),
  require('./gnom'),
  require('./cea'),
  require('./eqc'),
  require('./poly'),
  require('./nzmg'),
  require('./mill'),
  require('./sinu'),
  require('./moll'),
  require('./eqdc'),
  require('./vandg'),
  require('./aeqd'),
  require('./longlat')
];
var names = {};
var projStore = [];

function add(proj, i) {
  var len = projStore.length;
  if (!proj.names) {
    console.log(i);
    return true;
  }
  projStore[len] = proj;
  proj.names.forEach(function(n) {
    names[n.toLowerCase()] = len;
  });
  return this;
}

exports.add = add;

exports.get = function(name) {
  if (!name) {
    return false;
  }
  var n = name.toLowerCase();
  if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
    return projStore[names[n]];
  }
};
exports.start = function() {
  projs.forEach(add);
};
