/**
 * Ajax(jquery) promise(rsvp) REST functions
 *
 * GET example:
 *     var api = require('./path-to-this-file')('your-api-host');
 *     api.get('products', {id: id}).then(successCallback, errorCallback);
 *     api.get('products').then(successCallback, errorCallback);
 *
 * POST
 *     var api = require('./path-to-this-file')('your-api-host');
 *     api.post('products', {}).then(successCallback, errorCallback);
 */
'use strict';

var promise = require('./lib/promise');
var API_URL;

var url = function(resource, data) {
    if (data.id) {
        resource += '/' + data.id;
    }
    return API_URL + resource;
};

var get = function(resource, data, beforeSend) {
    data = data || {};
    return promise(url(resource, data), data, 'get', beforeSend);
};

var post = function(resource, data, beforeSend) {
    data = data || {};
    return promise(url(resource, data), data, 'post', beforeSend);
};

var put = function(resource, data, beforeSend) {
    data = data || {};
    return promise(url(resource, data), data, 'put', beforeSend);
};

var destroy = function(resource, data, beforeSend) {
    data = data || {};
    return promise(url(resource, data), data, 'delete', beforeSend);
};

module.exports = function(url) {
    API_URL = url;
    return {
        get: get,
        post: post,
        put: put,
        destroy: destroy
    };
};
