/**
 * Promise implementation for ajax calls.
 * Using RSVP for promises and jQuery for ajax
 * jQuery promise is not handling Promises as RSVP.
 */
'use strict';

var jquery = require('jquery');
var RSVP = require('rsvp');

var promise = function(resource, data, method, beforeSend) {
    return new RSVP.Promise(function(resolve, reject) {
        jquery.ajax({
            type: method || 'get',
            beforeSend: beforeSend || void(0),
            url: resource,
            data: data,
            success: resolve,
            error: reject
        });
    });
};

module.exports = promise;
