/**
 * Disclamer:
 *     This is not a real implementation of test, since it just test interface
 *     Real tests are comming... soon.
 *     Do you have a good tests for it? PR!
 */
'use strict';

var Chai = require('chai');

var expect = Chai.expect;

describe('API Interface', function() {

    describe('Should return promise', function() {
        before(function() {
            this.promise = require('../lib/promise');
        });
        it('should return a promise object', function() {
            var get = this.promise('resource', {}, 'get');
            expect(get.then).to.be.a('function');
        });
    });

    describe('Default Interface Implementation', function() {
        before(function() {
            this.api = require('../index')('http://localhost:3000/');
        });

        it('should implement GET method', function() {
            expect(this.api.get).to.be.a('function');
        });

        it('should implement POST method', function() {
            expect(this.api.post).to.be.a('function');
        });

        it('should implement PUT method', function() {
            expect(this.api.put).to.be.a('function');
        });

        it('should implement DESTROY method', function() {
            expect(this.api.destroy).to.be.a('function');
        });
    });

    describe('Implementation', function() {
        before(function() {
            this.api = require('../index')('http://localhost:3000/');
        });

        it('get method should return a promise', function() {
            var get = this.api.get('resource');
            expect(get.then).to.be.a('function');
        });

        it('post method should return a promise', function() {
            var post = this.api.post('resource');
            expect(post.then).to.be.a('function');
        });

        it('put method should return a promise', function() {
            var put = this.api.put('resource');
            expect(put.then).to.be.a('function');
        });

        it('destroy method should return a promise', function() {
            var destroy = this.api.destroy('resource');
            expect(destroy.then).to.be.a('function');
        });
    });
});
