'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});

var _ws = require('ws');

var _ws2 = _interopRequireDefault(_ws);

var _pify = require('pify');

var _pify2 = _interopRequireDefault(_pify);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function extendWS(ws) {
	if (ws._promised) return ws;

	function promisify(method) {
		const callbackMethod = `${ method }Callback`;
		ws[callbackMethod] = ws[method];
		ws[method] = (0, _pify2.default)(ws[callbackMethod]);
	}

	ws._promised = true;
	promisify('send');
	promisify('ping');
	promisify('pong');
	return ws;
}

class PromiseWebSocketServer extends _ws2.default.Server {
	static create(options) {
		return _asyncToGenerator(function* () {
			return new Promise(function (resolve, reject) {
				const wss = new PromiseWebSocketServer(options);
				const server = options.server,
				      noServer = options.noServer;

				const done = function () {
					return resolve(wss);
				};
				if (noServer || server && server.listening) process.nextTick(done);else wss.once('listening', done);
				wss.once('error', reject);
			});
		})();
	}

	on(event, listener) {
		if (event === 'connection') {
			return super.on(event, ws => listener(extendWS(ws)));
		}
		return super.on(event, listener);
	}

	close() {
		return (0, _pify2.default)(super.close.bind(this))();
	}
}

class PromiseWebSocket extends _ws2.default {

	static create() {
		for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
			args[_key] = arguments[_key];
		}

		return new Promise((resolve, reject) => {
			const ws = new (Function.prototype.bind.apply(PromiseWebSocket, [null].concat(args)))();
			ws.once('open', () => resolve(ws));
			ws.once('error', reject);
		});
	}

	constructor() {
		super(...arguments);
		extendWS(this);
	}
}
exports.default = PromiseWebSocket;
PromiseWebSocket.Server = PromiseWebSocketServer;
PromiseWebSocket.WebSocket = _ws2.default;