# ProseMirror post-crowdfunding development plan

Last updated 2015-12-08

This document outlines the development plans and gives a rough
estimate of the order and timeframe in which they will be realized.


## Work

### Update the documentation

To try and keep the documentation useful, or at least non-misleading,
as the system is worked on, I want to move to a JSDoc-like system. But
the documentatation structure generated by such tools, especially for
multi-file projects, tends to be very unhelpful.

Will experiment with documentation.js, and see if that, maybe with
some custom wrapper scripts, can produce the documentation I need.

### Implement locked nodes

For many scenarios, such as document elements with a fixed structure
(figure + caption, title + body) and tables, it would be helpful to be
able to specify that normal commands may not change a node's
structure, and allow only custom commands to create or change such
nodes.

The complexity in this mostly stems from dealing with partially
selected/copied/pasted nodes of this type. I have to experiment with
some approaches and see what works.

### Actual document schemas

To find out whether the document schema API works, we'll need to write
a lot of schemas. Here are some of the things that people have asked
for:

 - Tables. This is probably one of the more demanding use cases, both
   in working around contentEditable magic and in schema
   expressiveness. Will need a number of menu items, and to express
   constraints like actually being rectangular. There are a lot of
   different aspects about tables (column widths, rowspan/colspan,
   header cells), so this will probably be split into multiple
   elements with composable functionality.

 - Different image flavors. Block-level images, resizeable images,
   being able to plug in an image source (for upload/selection).

 - A number of commonly expected inline styles like font
   family/size/color, strikethrough, underline. I want to focus on
   semantic information as much as possible, but some users insist on
   being able to select fonts etc.

 - Section nodes (as opposed to implicit sections starting at
   headings).

 - Indentation for blocks.

 - The metadata needed to serialize a Markdown document down to
   something close to the original text (the specific syntax and
   indentation used for each construct).

### In-line marker widgets

There is already the markRange method to add style or metadata to a
range of text (outside of the document). I want to add a feature to
show a non-editable widget at a given position. This is useful for
displaying other users' cursors in collaborative editors, or to show
deleted text when tracking changes.

### More efficient marker tracking

Currently, many operations' complexity is linear to the amount of
markers you have in a document. The constant factors are small, so
this'll only cause issues when you have a seriously large amount of
them, but there are use cases that require a lot of markers, so I am
not happy with this.

The plan is to define a hierarchical data structure, so that changing
and rendering the document can mostly ignore markers that are in
unaffected nodes. This is somewhat tricky, since markers can cover
arbitrary ranges and thus the tree structure can't just partition the
space straightforwardly, but not too hard. The position mapping will
have to be extended to work with such a data structure.


## Roadmap

Here's the order in which I plan to tackle these, along with a rough
timeframe:

 - Get the documentation in a passable form again (mid-December)

 - Work on and experiment with locked nodes (late December, early
   January)

 - Tackle tables and their UI requirements (mid-late January)

 - Build proofs of concept for the various document-schema use
   cases on top of the schema API

Please remember that this schedule is a plan, not a promise.
