import {namespace} from "./def"
import {doc, blockquote, pre, p, li, ul, img, br, hr} from "../build"
import {cmp, cmpStr, cmpNode, is, P} from "../cmp"

const test = namespace("nodeselection")

test("parent_block", pm => {
  pm.setTextSelection(P(0, 0, 1, 1))
  pm.execCommand("selectParentNode")
  cmpStr(pm.selection.from, P(0, 0, 1), "to paragraph")
  pm.execCommand("selectParentNode")
  cmpStr(pm.selection.from, P(0, 0), "to list item")
  pm.execCommand("selectParentNode")
  cmpStr(pm.selection.from, P(0), "to list")
  pm.execCommand("selectParentNode")
  cmpStr(pm.selection.from, P(0), "stop at toplevel")
}, {doc: doc(ul(li(p("foo"), p("bar")), li(p("baz"))))})

test("through_inline_node", pm => {
  pm.setTextSelection(P(0, 3))
  pm.execCommand("selectNodeRight")
  cmpStr(pm.selection.from, P(0, 3), "moved right onto image")
  pm.execCommand("selectNodeRight")
  cmpStr(pm.selection.head, P(0, 4), "moved right past")
  cmpStr(pm.selection.anchor, P(0, 4), "moved right past'")
  pm.execCommand("selectNodeLeft")
  cmpStr(pm.selection.from, P(0, 3), "moved left onto image")
  pm.execCommand("selectNodeLeft")
  cmpStr(pm.selection.head, P(0, 3), "moved left past")
  cmpStr(pm.selection.anchor, P(0, 3), "moved left past'")
}, {doc: doc(p("foo", img, "bar"))})

test("onto_block", pm => {
  pm.setTextSelection(P(0, 5))
  pm.execCommand("selectNodeDown")
  cmpStr(pm.selection.from, P(1), "moved down onto hr")
  pm.setTextSelection(P(2, 0, 0, 0))
  pm.execCommand("selectNodeUp")
  cmpStr(pm.selection.from, P(1), "moved up onto hr")
}, {doc: doc(p("hello"), hr, ul(li(p("there"))))})

test("through_double_block", pm => {
  pm.setTextSelection(P(0, 0, 5))
  pm.execCommand("selectNodeDown")
  cmpStr(pm.selection.from, P(1), "moved down onto hr")
  pm.execCommand("selectNodeDown")
  cmpStr(pm.selection.from, P(2), "moved down onto second hr")
  pm.setTextSelection(P(3, 0))
  pm.execCommand("selectNodeUp")
  cmpStr(pm.selection.from, P(2), "moved up onto second hr")
  pm.execCommand("selectNodeUp")
  cmpStr(pm.selection.from, P(1), "moved up onto hr")
}, {doc: doc(blockquote(p("hello")), hr, hr, p("there"))})

test("horizontally_through_block", pm => {
  pm.setTextSelection(P(0, 3))
  pm.execCommand("selectNodeRight")
  cmpStr(pm.selection.from, P(1), "right into first hr")
  pm.execCommand("selectNodeRight")
  cmpStr(pm.selection.from, P(2), "right into second hr")
  pm.execCommand("selectNodeRight")
  cmpStr(pm.selection.head, P(3, 0), "right out of hr")
  pm.execCommand("selectNodeLeft")
  cmpStr(pm.selection.from, P(2), "left into second hr")
  pm.execCommand("selectNodeLeft")
  cmpStr(pm.selection.from, P(1), "left into first hr")
  pm.execCommand("selectNodeLeft")
  cmpStr(pm.selection.head, P(0, 3), "left out of hr")
}, {doc: doc(p("foo"), hr, hr, p("bar"))})

test("block_out_of_image", pm => {
  pm.setNodeSelection(P(0, 3))
  pm.execCommand("selectNodeDown")
  cmpStr(pm.selection.from, P(1), "down into hr")
  pm.setNodeSelection(P(2, 0))
  pm.execCommand("selectNodeUp")
  cmpStr(pm.selection.from, P(1), "up into hr")
}, {doc: doc(p("foo", img), hr, p(img, "bar"))})

test("lift_preserves", pm => {
  pm.setNodeSelection(P(0, 0, 0, 0))
  pm.execCommand("lift")
  cmpNode(pm.doc, doc(ul(li(p("hi")))), "lifted")
  cmpStr(pm.selection.from, P(0, 0, 0), "preserved selection")
  pm.execCommand("lift")
  cmpNode(pm.doc, doc(p("hi")), "lifted again")
  cmpStr(pm.selection.from, P(0), "preserved selection again")
}, {doc: doc(ul(li(blockquote(p("hi")))))})

test("lift_at_selection_level", pm => {
  pm.setNodeSelection(P(0, 0))
  pm.execCommand("lift")
  cmpNode(pm.doc, doc(ul(li(p("a")), li(p("b")))), "lifted list")
  cmpStr(pm.selection.from, P(0), "preserved selection")
}, {doc: doc(blockquote(ul(li(p("a")), li(p("b")))))})

test("join_precisely_down", pm => {
  pm.setNodeSelection(P(0, 0))
  cmp(pm.execCommand("joinDown"), false, "don't join parent")
  pm.setNodeSelection(P(0))
  pm.execCommand("joinDown")
  cmpNode(pm.doc, doc(blockquote(p("foo"), p("bar"))), "joined")
  cmpStr(pm.selection.from, P(0), "selected joined node")
}, {doc: doc(blockquote(p("foo")), blockquote(p("bar")))})

test("join_precisely_up", pm => {
  pm.setNodeSelection(P(1, 0))
  cmp(pm.execCommand("joinUp"), false, "don't join parent")
  pm.setNodeSelection(P(1))
  pm.execCommand("joinUp")
  cmpNode(pm.doc, doc(blockquote(p("foo"), p("bar"))), "joined")
  cmpStr(pm.selection.from, P(0), "selected joined node")
}, {doc: doc(blockquote(p("foo")), blockquote(p("bar")))})

test("delete_block", pm => {
  pm.setNodeSelection(P(0))
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(ul(li(p("bar")), li(p("baz")), li(p("quux")))), "paragraph vanished")
  cmpStr(pm.selection.head, P(0, 0, 0, 0), "moved to list")
  pm.setNodeSelection(P(0, 0, 0))
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(ul(li(p("baz")), li(p("quux")))), "delete whole item")
  cmpStr(pm.selection.head, P(0, 0, 0, 0), "to next item")
  pm.setNodeSelection(P(0, 1))
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(ul(li(p("baz")))), "delete last item")
  cmpStr(pm.selection.head, P(0, 0, 0, 3), "back to paragraph above")
  pm.setNodeSelection(P(0))
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(p()), "delete list")
}, {doc: doc(p("foo"), ul(li(p("bar")), li(p("baz")), li(p("quux"))))})

test("delete_hr", pm => {
  pm.setNodeSelection(P(1))
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(p("a"), hr, p("b")), "deleted first hr")
  cmpStr(pm.selection.from, P(1), "moved to second hr")
  pm.execCommand("deleteSelection")
  cmpNode(pm.doc, doc(p("a"), p("b")), "deleted second hr")
  cmpStr(pm.selection.head, P(1, 0), "moved to paragraph")
}, {doc: doc(p("a"), hr, hr, p("b"))})

test("delete_selection", pm => {
  pm.setNodeSelection(P(0, 3))
  pm.tr.replaceSelection(null).apply()
  cmpNode(pm.doc, doc(p("foobar"), blockquote(p("hi")), p("ay")), "deleted img")
  cmpStr(pm.selection.head, P(0, 3), "cursor at img")
  pm.setNodeSelection(P(1, 0))
  pm.tr.deleteSelection().apply()
  cmpNode(pm.doc, doc(p("foobar"), p("ay")), "deleted blockquote")
  cmpStr(pm.selection.from, P(1, 0), "cursor moved past")
  pm.setNodeSelection(P(1))
  pm.tr.deleteSelection().apply()
  cmpNode(pm.doc, doc(p("foobar")), "deleted paragraph")
  cmpStr(pm.selection.from, P(0, 6), "cursor moved back")
}, {doc: doc(p("foo", img, "bar"), blockquote(p("hi")), p("ay"))})

test("replace_selection_inline", pm => {
  pm.setNodeSelection(P(0, 3))
  pm.tr.replaceSelection(pm.schema.node("hard_break")).apply()
  cmpNode(pm.doc, doc(p("foo", br, "bar", img, "baz")), "replaced with br")
  cmpStr(pm.selection.head, P(0, 4), "after inserted node")
  is(pm.selection.empty, "empty selection")
  pm.setNodeSelection(P(0, 7))
  pm.tr.replaceSelection(pm.schema.text("abc")).apply()
  cmpNode(pm.doc, doc(p("foo", br, "barabcbaz")), "replaced with text")
  cmpStr(pm.selection.head, P(0, 10), "after text")
  is(pm.selection.empty, "again empty selection")
  pm.setNodeSelection(P(0))
  pm.tr.replaceSelection(pm.schema.text("xyz")).apply()
  cmpNode(pm.doc, doc(p("xyz")), "replaced all of paragraph")
}, {doc: doc(p("foo", img, "bar", img, "baz"))})

test("replace_selection_block", pm => {
  pm.setNodeSelection(P(1))
  pm.tr.replaceSelection(pm.schema.node("code_block")).apply()
  cmpNode(pm.doc, doc(p("abc"), pre(), hr, blockquote(p("ow"))), "replace with code block")
  cmpStr(pm.selection.from, P(2), "moved to hr")
  cmp(pm.tr.replaceSelection(pm.schema.node("list_item")).apply(), false, "can't replace with non-fitting")
  pm.setNodeSelection(P(3))
  pm.tr.replaceSelection(pm.schema.node("paragraph")).apply()
  cmpNode(pm.doc, doc(p("abc"), pre(), hr, p()), "replace with paragraph")
  cmpStr(pm.selection.head, P(3, 0))
}, {doc: doc(p("abc"), hr, hr, blockquote(p("ow")))})
