"use strict";

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require("../util/error");

var ProseMirrorError = _require.ProseMirrorError;

var _require2 = require("./map");

var mapThrough = _require2.mapThrough;
var mapThroughResult = _require2.mapThroughResult;

var TransformError = function (_ProseMirrorError) {
  _inherits(TransformError, _ProseMirrorError);

  function TransformError() {
    _classCallCheck(this, TransformError);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(TransformError).apply(this, arguments));
  }

  return TransformError;
}(ProseMirrorError);

exports.TransformError = TransformError;

// ;; A change to a document often consists of a series of
// [steps](#Step). This class provides a convenience abstraction to
// build up and track such an array of steps. A `Transform` object
// implements `Mappable`.
//
// The high-level transforming methods return the `Transform` object
// itself, so that they can be chained.

var Transform = function () {
  // :: (Node)
  // Create a transformation that starts with the given document.

  function Transform(doc) {
    _classCallCheck(this, Transform);

    // :: Node
    // The current document (the result of applying the steps in the
    // transform).
    this.doc = doc;
    // :: [Step]
    // The steps in this transform.
    this.steps = [];
    // :: [Node]
    // The documents before each of the steps.
    this.docs = [];
    // :: [PosMap]
    // The position maps for each of the steps in this transform.
    this.maps = [];
  }

  // :: Node The document at the start of the transformation.


  _createClass(Transform, [{
    key: "step",


    // :: (Step) → Transform
    // Apply a new step in this transformation, saving the result.
    // Throws an error when the step fails.
    value: function step(_step) {
      var result = this.maybeStep(_step);
      if (result.failed) throw new TransformError(result.failed);
      return this;
    }

    // :: (Step) → StepResult
    // Try to apply a step in this transformation, ignoring it if it
    // fails. Returns the step result.

  }, {
    key: "maybeStep",
    value: function maybeStep(step) {
      var result = step.apply(this.doc);
      if (!result.failed) {
        this.docs.push(this.doc);
        this.steps.push(step);
        this.maps.push(step.posMap());
        this.doc = result.doc;
      }
      return result;
    }

    // :: (number, ?number) → MapResult
    // Map a position through the whole transformation (all the position
    // maps in [`maps`](#Transform.maps)), and return the result.

  }, {
    key: "mapResult",
    value: function mapResult(pos, bias, start) {
      return mapThroughResult(this.maps, pos, bias, start);
    }

    // :: (number, ?number) → number
    // Map a position through the whole transformation, and return the
    // mapped position.

  }, {
    key: "map",
    value: function map(pos, bias, start) {
      return mapThrough(this.maps, pos, bias, start);
    }
  }, {
    key: "before",
    get: function get() {
      return this.docs.length ? this.docs[0] : this.doc;
    }
  }]);

  return Transform;
}();

exports.Transform = Transform;