const {Remapping, Transform} = require("../transform")

function rebaseSteps(doc, forward, steps, maps) {
  let remap = new Remapping([], forward.slice())
  let transform = new Transform(doc)
  let positions = []

  for (let i = 0; i < steps.length; i++) {
    let step = steps[i].map(remap)
    let result = step && transform.maybeStep(step)
    let id = remap.addToFront(maps[i].invert())
    if (result && result.doc) {
      remap.addToBack(step.posMap(), id)
      positions.push(transform.steps.length - 1)
    } else {
      positions.push(-1)
    }
  }
  return {doc: transform.doc, transform, mapping: remap, positions}
}
exports.rebaseSteps = rebaseSteps
