export declare enum PromiseType {
    Q = 0,
    WEBDRIVER = 1,
}
export interface PluginConfig {
    path?: string;
    package?: string;
    inline?: ProtractorPlugin;
    name?: string;
    [key: string]: any;
}
export declare class ProtractorPlugin {
    skipAngularStability: boolean;
    name: string;
    config: PluginConfig;
    addFailure: (message?: string, info?: {
        specName?: string;
        stackTrace?: string;
    }) => void;
    addSuccess: (info?: {
        specName?: string;
    }) => void;
    addWarning: (message?: string, info?: {
        specName?: string;
    }) => void;
}
/**
 * The plugin API for Protractor.  Note that this API is unstable. See
 * plugins/README.md for more information.
 *
 * @constructor
 * @param {Object} config parsed from the config file
 */
export declare class Plugins {
    pluginObjs: ProtractorPlugin[];
    assertions: {
        [key: string]: any[];
    };
    resultsReported: boolean;
    constructor(config: any);
    /**
     * Adds properties to a plugin's object
     *
     * @see docs/plugins.md#provided-properties-and-functions
     */
    private annotatePluginObj(obj, conf, i);
    private printPluginResults(specResults);
    /**
     * Gets the tests results generated by any plugins
     *
     * @see lib/frameworks/README.md#requirements for a complete description of what
     *     the results object must look like
     *
     * @return {Object} The results object
     */
    getResults(): {
        failedCount: number;
        specResults: any[];
    };
    /**
     * Returns true if any loaded plugin has skipAngularStability enabled.
     *
     * @return {boolean}
     */
    skipAngularStability(): boolean;
    /**
     * @see docs/plugins.md#writing-plugins for information on these functions
     */
    setup: Function;
    teardown: Function;
    postResults: Function;
    postTest: Function;
    onPageLoad: Function;
    onPageStable: Function;
    waitForPromise: Function;
    waitForCondition: Function;
    /**
     * Calls a function from a plugin safely.  If the plugin's function throws an
     * exception or returns a rejected promise, that failure will be logged as a
     * failed test result instead of crashing protractor.  If the tests results have
     * already been reported, the failure will be logged to the console.
     *
     * @param {Object} pluginObj The plugin object containing the function to be run
     * @param {string} funName The name of the function we want to run
     * @param {*[]} args The arguments we want to invoke the function with
     * @param {PromiseType} promiseType The type of promise (WebDriver or Q) that
     *    should be used
     * @param {boolean} resultsReported If the results have already been reported
     * @param {*} failReturnVal The value to return if the function fails
     *
     * @return {webdriver.promise.Promise|q.Promise} A promise which resolves to the
     *     function's return value
     */
    safeCallPluginFun(pluginObj: ProtractorPlugin, funName: string, args: IArguments, promiseType: PromiseType, failReturnVal: any): any;
}
