# Sources

A source is a stream that is not writable.
You *must* have a source at the start of a pipeline
for data to move through.

in general:

``` js
source()
  .pipe(through()) //optional
  .pipe(sink())
```

## values (array | object)

create a SourceStream that reads the values from an array or object and then stops.

## keys (array | object)

stream the key names from an object (or array)

## count (max)

create a stream that outputs `0 ... max`.
by default, `max = Infinity`, see
[take](https://github.com/dominictarr/pull-stream/blob/master/docs/throughs.md#take_test)

## infinite (generator)

create an unending stream by repeatedly calling a generator
function (by default, `Math.random`)
see
[take](https://github.com/dominictarr/pull-stream/blob/master/docs/throughs.md#take_test)

## defer

create a false source-stream that will be attached to a 
real source-stream later. Use when you must do an async
operation before you can create the stream.


``` js
function ls (dir) {
  var ds = pull.defer()
  fs.readdir(dir, function (err, ls) {
    if(err) return ds.abort(err)
    return ds.resolve(readArray(ls)
      .pipe(pull.map(function (file) {
        return path.resolve(dir, file)
      })
  })
  return ds
}
```

## empty

A stream with no contents (it just ends immediately)

``` js
pull.empty().pipe(pull.collect(function (err, ary) {
  console.log(arg)
  // ==> []
})
```

## pushable

[pushable](https://github.com/dominictarr/pull-pushable)

## depthFirst, widthFirst, leafFirst (start, createStream)

Traverse a tree structure. `start` is a value that represents
a node. `createStream` is a function that returns
a pull-stream of the children of a node.
`start` must be the same type output by `createStream`.

``` js
//passing in the `ls` function from the `defer` example.
pull.widthFirst(process.cwd(), ls)
  .pipe(pull.log())
```

