# Contributing to QCObjects

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to QCObjects, which is hosted in the [Quickcorp Organization](https://github.com/quickcorp) on GitHub. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

Any contribution code, comment, issue and or request must be written in English.

## Table Of Contents

<!-- TOC depthFrom:1 depthTo:6 withLinks:1 updateOnSave:1 orderedList:0 -->

- [Contributing to QCObjects](#contributing-to-qcobjects)
	- [Table Of Contents](#table-of-contents)
	- [Code of Conduct](#code-of-conduct)
	- [Contributing Issues Guidelines](#contributing-issues-guidelines)
		- [Related Issues](#related-issues)
		- [Creating Issues](#creating-issues)
			- [Feature Request](#feature-request)
			- [Bug Report](#bug-report)
			- [Non related issue](#non-related-issue)
- [Fork](#fork)
- [Make Your Own QCObjects based tool or framework](#make-your-own-qcobjects-based-tool-or-framework)
- [Become a Sponsor](#become-a-sponsor)
- [Donate](#donate)
- [Become a Patreon](#become-a-patreon)

<!-- /TOC -->

## Code of Conduct

This project and everyone participating in it is governed by the [QCObjects Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code. Please report unacceptable behavior to [info@quickcorp.cl](mailto:info@quickcorp.cl).


## Contributing Issues Guidelines

### Related Issues

Please, before to create a new issue, read all the old issues [here](https://github.com/QuickCorp/QCObjects/issues)

### Creating Issues



#### Feature Request

Please follow the next link and create a [Feature Request Issue](https://github.com/QuickCorp/QCObjects/issues/new?assignees=&labels=&template=feature_request.md&title=)


#### Bug Report

If you've found a bug, please report it following the template for a [Bug Report Issue](https://github.com/QuickCorp/QCObjects/issues/new?assignees=&labels=&template=bug_report.md&title=)

#### Non related issue

If you want to contribute with an non-listed issue you can do it [here](https://github.com/QuickCorp/QCObjects/issues/new?assignees=&labels=&template=custom.md&title=)

# Fork
--------------

Please fork this project and make a link to this project into your README.md file. Read the LICENSE.txt file before you use this code.

# Make Your Own QCObjects based tool or framework
--------------

You can make YOUR OWN TOOL based on QCObjects. For that you only need to follow the next guidelines:

1. To make your tool recognized and listed in the file toolslist.md just send an email to info@quickcorp.cl indicating the link of the GitHub project and a short description of the purpose of your tool.
2. If you are making a QCObjects App Template and you want to be listed in apptemplatelist.md, please send an email to info@quickcorp.cl indicating the link of the package in npmjs.com. Your App Template will be accepted only if it is using QCObjects as the main framework to render the app and the license of your project is under LGPL-3.




# Become a Sponsor
------------------
If you want to become a sponsor for this wonderful project you can do it [here](https://sponsorsignup.qcobjects.dev/)


# Donate
--------------

If you like this code please [DONATE](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=UUTDBUQHCS4PU&source=url)!

 [![paypal](https://www.paypalobjects.com/webstatic/mktg/logo/AM_mc_vs_dc_ae.jpg)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=UUTDBUQHCS4PU&source=url)

# Become a Patreon
--------------

[![Become a Patreon ](https://c5.patreon.com/external/logo/become_a_patron_button.png)](https://www.patreon.com/join/qcobjects?)
