export function encode(obj, pfx) {
	var k, i, tmp, str='';

	for (k in obj) {
		if ((tmp = obj[k]) !== void 0) {
			if (Array.isArray(tmp)) {
				for (i=0; i < tmp.length; i++) {
					str && (str += '&');
					str += encodeURIComponent(k) + '=' + encodeURIComponent(tmp[i]);
				}
			} else {
				str && (str += '&');
				str += encodeURIComponent(k) + '=' + encodeURIComponent(tmp);
			}
		}
	}

	return (pfx || '') + str;
}

function toValue(mix) {
	var str = decodeURIComponent(mix);
	if (str === 'true') return true;
	if (str === 'false') return false;
	return (+str * 0 === 0) ? (+str) : str;
}

export function decode(str) {
	var tmp, k, out={}, arr=str.split('&');

	while (tmp = arr.shift()) {
		tmp = tmp.split('=');
		k = tmp.shift();
		if (out[k] !== void 0) {
			out[k] = [].concat(out[k], toValue(tmp.shift()));
		} else {
			out[k] = toValue(tmp.shift());
		}
	}

	return out;
}
