(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else if(typeof define === 'function' && define.amd)
		define(["get-pixels", "ndarray", "ndarray-linear-interpolate"], factory);
	else if(typeof exports === 'object')
		exports["Quagga"] = factory(require("get-pixels"), require("ndarray"), require("ndarray-linear-interpolate"));
	else
		root["Quagga"] = factory(root["get-pixels"], root["ndarray"], root["ndarray-linear-interpolate"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_155__, __WEBPACK_EXTERNAL_MODULE_156__, __WEBPACK_EXTERNAL_MODULE_157__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].e;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			e: {},
/******/ 			i: moduleId,
/******/ 			l: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.e, module, module.e, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.e;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 158);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logDisabled_ = false;
	
	// Utility methods.
	var utils = {
	  disableLog: function(bool) {
	    if (typeof bool !== 'boolean') {
	      return new Error('Argument type: ' + typeof bool +
	          '. Please use a boolean.');
	    }
	    logDisabled_ = bool;
	    return (bool) ? 'adapter.js logging disabled' :
	        'adapter.js logging enabled';
	  },
	
	  log: function() {
	    if (typeof window === 'object') {
	      if (logDisabled_) {
	        return;
	      }
	      console.log.apply(console, arguments);
	    }
	  },
	
	   /**
	   * Extract browser version out of the provided user agent string.
	   * @param {!string} uastring userAgent string.
	   * @param {!string} expr Regular expression used as match criteria.
	   * @param {!number} pos position in the version string to be returned.
	   * @return {!number} browser version.
	   */
	  extractVersion: function(uastring, expr, pos) {
	    var match = uastring.match(expr);
	    return match && match.length >= pos && parseInt(match[pos], 10);
	  },
	
	  /**
	   * Browser detector.
	   * @return {object} result containing browser, version and minVersion
	   *     properties.
	   */
	  detectBrowser: function() {
	    // Returned result object.
	    var result = {};
	    result.browser = null;
	    result.version = null;
	    result.minVersion = null;
	
	    if (typeof window === 'undefined' || !window.navigator) {
	      result.browser = 'Not a browser.';
	      return result;
	    } else if (navigator.mozGetUserMedia) {
	      // Firefox.
	      result.browser = 'firefox';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Firefox\/([0-9]+)\./, 1);
	      result.minVersion = 31;
	    } else if (navigator.webkitGetUserMedia && window.webkitRTCPeerConnection) {
	      // Chrome, Chromium, WebView, Opera and other WebKit browsers.
	      result.browser = 'chrome';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Chrom(e|ium)\/([0-9]+)\./, 2);
	      result.minVersion = 38;
	    } else if(navigator.mediaDevices &&
	        navigator.userAgent.match(/Edge\/(\d+).(\d+)$/)) {
	      // Edge.
	      result.browser = 'edge';
	      result.version = this.extractVersion(navigator.userAgent,
	          /Edge\/(\d+).(\d+)$/, 2);
	      result.minVersion = 10547;
	    } else {
	      result.browser = 'Not a supported browser.';
	      return result;
	    }
	
	    // Warn if version is less than minVersion.
	    if (result.version < result.minVersion) {
	      utils.log('Browser: ' + result.browser + ' Version: ' + result.version +
	          ' < minimum supported version: ' + result.minVersion +
	          '\n some things might not work!');
	    }
	
	    return result;
	  }
	};
	
	// Export.
	module.e = {
	  log: utils.log,
	  disableLog: utils.disableLog,
	  browserDetails: utils.detectBrowser(),
	  extractVersion: utils.extractVersion
	};


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module, global) {var checkGlobal = __webpack_require__(105);
	
	/** Used to determine if values are of the language type `Object`. */
	var objectTypes = {
	  'function': true,
	  'object': true
	};
	
	/** Detect free variable `exports`. */
	var freeExports = (objectTypes[typeof exports] && exports && !exports.nodeType)
	  ? exports
	  : undefined;
	
	/** Detect free variable `module`. */
	var freeModule = (objectTypes[typeof module] && module && !module.nodeType)
	  ? module
	  : undefined;
	
	/** Detect free variable `global` from Node.js. */
	var freeGlobal = checkGlobal(freeExports && freeModule && typeof global == 'object' && global);
	
	/** Detect free variable `self`. */
	var freeSelf = checkGlobal(objectTypes[typeof self] && self);
	
	/** Detect free variable `window`. */
	var freeWindow = checkGlobal(objectTypes[typeof window] && window);
	
	/** Detect `this` as the global object. */
	var thisGlobal = checkGlobal(objectTypes[typeof this] && this);
	
	/**
	 * Used as a reference to the global object.
	 *
	 * The `this` value is used if it's the global object to avoid Greasemonkey's
	 * restricted `window` object, otherwise the `window` object is used.
	 */
	var root = freeGlobal ||
	  ((freeWindow !== (thisGlobal && thisGlobal.window)) && freeWindow) ||
	    freeSelf || thisGlobal || Function('return this')();
	
	module.e = root;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48)(module), (function() { return this; }())))

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is the [language type](https://es5.github.io/#x8) of `Object`.
	 * (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}
	
	module.e = isObject;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _merge2 = __webpack_require__(17);
	
	var _merge3 = _interopRequireDefault(_merge2);
	
	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
	
	var _barcode_reader = __webpack_require__(6);
	
	var _barcode_reader2 = _interopRequireDefault(_barcode_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function EANReader(opts, supplements) {
	    opts = (0, _merge3.default)(getDefaulConfig(), opts);
	    _barcode_reader2.default.call(this, opts, supplements);
	}
	
	function getDefaulConfig() {
	    var config = {};
	
	    Object.keys(EANReader.CONFIG_KEYS).forEach(function (key) {
	        config[key] = EANReader.CONFIG_KEYS[key].default;
	    });
	    return config;
	}
	
	var properties = {
	    CODE_L_START: { value: 0 },
	    CODE_G_START: { value: 10 },
	    START_PATTERN: { value: [1, 1, 1] },
	    STOP_PATTERN: { value: [1, 1, 1] },
	    MIDDLE_PATTERN: { value: [1, 1, 1, 1, 1] },
	    EXTENSION_START_PATTERN: { value: [1, 1, 2] },
	    CODE_PATTERN: { value: [[3, 2, 1, 1], [2, 2, 2, 1], [2, 1, 2, 2], [1, 4, 1, 1], [1, 1, 3, 2], [1, 2, 3, 1], [1, 1, 1, 4], [1, 3, 1, 2], [1, 2, 1, 3], [3, 1, 1, 2], [1, 1, 2, 3], [1, 2, 2, 2], [2, 2, 1, 2], [1, 1, 4, 1], [2, 3, 1, 1], [1, 3, 2, 1], [4, 1, 1, 1], [2, 1, 3, 1], [3, 1, 2, 1], [2, 1, 1, 3]] },
	    CODE_FREQUENCY: { value: [0, 11, 13, 14, 19, 25, 28, 21, 22, 26] },
	    SINGLE_CODE_ERROR: { value: 0.70 },
	    AVG_CODE_ERROR: { value: 0.48 },
	    FORMAT: { value: "ean_13", writeable: false }
	};
	
	EANReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
	EANReader.prototype.constructor = EANReader;
	
	EANReader.prototype._decodeCode = function (start, coderange) {
	    var counter = [0, 0, 0, 0],
	        i,
	        self = this,
	        offset = start,
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: start,
	        end: start
	    },
	        code,
	        error;
	
	    if (!coderange) {
	        coderange = self.CODE_PATTERN.length;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                for (code = 0; code < coderange; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                bestMatch.end = i;
	                if (bestMatch.error > self.AVG_CODE_ERROR) {
	                    return null;
	                }
	                return bestMatch;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder, epsilon) {
	    var counter = [],
	        self = this,
	        i,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    },
	        error,
	        j,
	        sum;
	
	    if (!offset) {
	        offset = self._nextSet(self._row);
	    }
	
	    if (isWhite === undefined) {
	        isWhite = false;
	    }
	
	    if (tryHarder === undefined) {
	        tryHarder = true;
	    }
	
	    if (epsilon === undefined) {
	        epsilon = self.AVG_CODE_ERROR;
	    }
	
	    for (i = 0; i < pattern.length; i++) {
	        counter[i] = 0;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                error = self._matchPattern(counter, pattern);
	
	                if (error < epsilon) {
	                    bestMatch.error = error;
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    return bestMatch;
	                }
	                if (tryHarder) {
	                    for (j = 0; j < counter.length - 2; j++) {
	                        counter[j] = counter[j + 2];
	                    }
	                    counter[counter.length - 2] = 0;
	                    counter[counter.length - 1] = 0;
	                    counterPos--;
	                } else {
	                    return null;
	                }
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findStart = function () {
	    var self = this,
	        leadingWhitespaceStart,
	        offset = self._nextSet(self._row),
	        startInfo;
	
	    while (!startInfo) {
	        startInfo = self._findPattern(self.START_PATTERN, offset);
	        if (!startInfo) {
	            return null;
	        }
	        leadingWhitespaceStart = startInfo.start - (startInfo.end - startInfo.start);
	        if (leadingWhitespaceStart >= 0) {
	            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
	                return startInfo;
	            }
	        }
	        offset = startInfo.end;
	        startInfo = null;
	    }
	};
	
	EANReader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start);
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._findEnd = function (offset, isWhite) {
	    var self = this,
	        endInfo = self._findPattern(self.STOP_PATTERN, offset, isWhite, false);
	
	    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
	};
	
	EANReader.prototype._calculateFirstDigit = function (codeFrequency) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CODE_FREQUENCY.length; i++) {
	        if (codeFrequency === self.CODE_FREQUENCY[i]) {
	            return i;
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this,
	        codeFrequency = 0x0,
	        firstDigit;
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end);
	        if (!code) {
	            return null;
	        }
	        if (code.code >= self.CODE_G_START) {
	            code.code = code.code - self.CODE_G_START;
	            codeFrequency |= 1 << 5 - i;
	        } else {
	            codeFrequency |= 0 << 5 - i;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	
	    firstDigit = self._calculateFirstDigit(codeFrequency);
	    if (firstDigit === null) {
	        return null;
	    }
	    result.unshift(firstDigit);
	
	    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
	    if (code === null) {
	        return null;
	    }
	    decodedCodes.push(code);
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code);
	    }
	
	    return code;
	};
	
	EANReader.prototype._decode = function () {
	    var startInfo,
	        self = this,
	        code,
	        result = [],
	        decodedCodes = [],
	        resultInfo = {};
	
	    startInfo = self._findStart();
	    if (!startInfo) {
	        return null;
	    }
	    code = {
	        code: startInfo.code,
	        start: startInfo.start,
	        end: startInfo.end
	    };
	    decodedCodes.push(code);
	    code = self._decodePayload(code, result, decodedCodes);
	    if (!code) {
	        return null;
	    }
	    code = self._findEnd(code.end, false);
	    if (!code) {
	        return null;
	    }
	
	    decodedCodes.push(code);
	
	    // Checksum
	    if (!self._checksum(result)) {
	        return null;
	    }
	
	    if (this.supplements.length > 0) {
	        var ext = this._decodeExtensions(code.end);
	        if (!ext) {
	            return null;
	        }
	        var lastCode = ext.decodedCodes[ext.decodedCodes.length - 1],
	            endInfo = {
	            start: lastCode.start + ((lastCode.end - lastCode.start) / 2 | 0),
	            end: lastCode.end
	        };
	        if (!self._verifyTrailingWhitespace(endInfo)) {
	            return null;
	        }
	        resultInfo = {
	            supplement: ext,
	            code: result.join("") + ext.code
	        };
	    }
	
	    return _extends({
	        code: result.join(""),
	        start: startInfo.start,
	        end: code.end,
	        codeset: "",
	        startInfo: startInfo,
	        decodedCodes: decodedCodes
	    }, resultInfo);
	};
	
	EANReader.prototype._decodeExtensions = function (offset) {
	    var i,
	        start = this._nextSet(this._row, offset),
	        startInfo = this._findPattern(this.EXTENSION_START_PATTERN, start, false, false),
	        result;
	
	    if (startInfo === null) {
	        return null;
	    }
	
	    for (i = 0; i < this.supplements.length; i++) {
	        result = this.supplements[i].decode(this._row, startInfo.end);
	        if (result !== null) {
	            return {
	                code: result.code,
	                start: start,
	                startInfo: startInfo,
	                end: result.end,
	                codeset: "",
	                decodedCodes: result.decodedCodes
	            };
	        }
	    }
	    return null;
	};
	
	EANReader.prototype._checksum = function (result) {
	    var sum = 0,
	        i;
	
	    for (i = result.length - 2; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    for (i = result.length - 1; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    return sum % 10 === 0;
	};
	
	EANReader.CONFIG_KEYS = {
	    supplements: {
	        'type': 'arrayOf(string)',
	        'default': [],
	        'description': 'Allowed extensions to be decoded (2 and/or 5)'
	    }
	};
	
	exports.default = EANReader;

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var Map = getNative(root, 'Map');
	
	module.e = Map;


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @type {Function}
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;
	
	module.e = isArray;


/***/ },
/* 6 */
/***/ function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	function BarcodeReader(config, supplements) {
	    this._row = [];
	    this.config = config || {};
	    this.supplements = supplements;
	    return this;
	}
	
	BarcodeReader.prototype._nextUnset = function (line, start) {
	    var i;
	
	    if (start === undefined) {
	        start = 0;
	    }
	    for (i = start; i < line.length; i++) {
	        if (!line[i]) {
	            return i;
	        }
	    }
	    return line.length;
	};
	
	BarcodeReader.prototype._matchPattern = function (counter, code, maxSingleError) {
	    var i,
	        error = 0,
	        singleError = 0,
	        sum = 0,
	        modulo = 0,
	        barWidth,
	        count,
	        scaled;
	
	    maxSingleError = maxSingleError || this.SINGLE_CODE_ERROR || 1;
	
	    for (i = 0; i < counter.length; i++) {
	        sum += counter[i];
	        modulo += code[i];
	    }
	    if (sum < modulo) {
	        return Number.MAX_VALUE;
	    }
	    barWidth = sum / modulo;
	    maxSingleError *= barWidth;
	
	    for (i = 0; i < counter.length; i++) {
	        count = counter[i];
	        scaled = code[i] * barWidth;
	        singleError = Math.abs(count - scaled) / scaled;
	        if (singleError > maxSingleError) {
	            return Number.MAX_VALUE;
	        }
	        error += singleError;
	    }
	    return error / modulo;
	};
	
	BarcodeReader.prototype._nextSet = function (line, offset) {
	    var i;
	
	    offset = offset || 0;
	    for (i = offset; i < line.length; i++) {
	        if (line[i]) {
	            return i;
	        }
	    }
	    return line.length;
	};
	
	BarcodeReader.prototype._correctBars = function (counter, correction, indices) {
	    var length = indices.length,
	        tmp = 0;
	    while (length--) {
	        tmp = counter[indices[length]] * (1 - (1 - correction) / 2);
	        if (tmp > 1) {
	            counter[indices[length]] = tmp;
	        }
	    }
	};
	
	BarcodeReader.prototype._matchTrace = function (cmpCounter, epsilon) {
	    var counter = [],
	        i,
	        self = this,
	        offset = self._nextSet(self._row),
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0
	    },
	        error;
	
	    if (cmpCounter) {
	        for (i = 0; i < cmpCounter.length; i++) {
	            counter.push(0);
	        }
	        for (i = offset; i < self._row.length; i++) {
	            if (self._row[i] ^ isWhite) {
	                counter[counterPos]++;
	            } else {
	                if (counterPos === counter.length - 1) {
	                    error = self._matchPattern(counter, cmpCounter);
	
	                    if (error < epsilon) {
	                        bestMatch.start = i - offset;
	                        bestMatch.end = i;
	                        bestMatch.counter = counter;
	                        return bestMatch;
	                    } else {
	                        return null;
	                    }
	                } else {
	                    counterPos++;
	                }
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    } else {
	        counter.push(0);
	        for (i = offset; i < self._row.length; i++) {
	            if (self._row[i] ^ isWhite) {
	                counter[counterPos]++;
	            } else {
	                counterPos++;
	                counter.push(0);
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    }
	
	    // if cmpCounter was not given
	    bestMatch.start = offset;
	    bestMatch.end = self._row.length - 1;
	    bestMatch.counter = counter;
	    return bestMatch;
	};
	
	BarcodeReader.prototype.decodePattern = function (pattern) {
	    var self = this,
	        result;
	
	    self._row = pattern;
	    result = self._decode();
	    if (result === null) {
	        self._row.reverse();
	        result = self._decode();
	        if (result) {
	            result.direction = BarcodeReader.DIRECTION.REVERSE;
	            result.start = self._row.length - result.start;
	            result.end = self._row.length - result.end;
	        }
	    } else {
	        result.direction = BarcodeReader.DIRECTION.FORWARD;
	    }
	    if (result) {
	        result.format = self.FORMAT;
	    }
	    return result;
	};
	
	BarcodeReader.prototype._matchRange = function (start, end, value) {
	    var i;
	
	    start = start < 0 ? 0 : start;
	    for (i = start; i < end; i++) {
	        if (this._row[i] !== value) {
	            return false;
	        }
	    }
	    return true;
	};
	
	BarcodeReader.prototype._fillCounters = function (offset, end, isWhite) {
	    var self = this,
	        counterPos = 0,
	        i,
	        counters = [];
	
	    isWhite = typeof isWhite !== 'undefined' ? isWhite : true;
	    offset = typeof offset !== 'undefined' ? offset : self._nextUnset(self._row);
	    end = end || self._row.length;
	
	    counters[counterPos] = 0;
	    for (i = offset; i < end; i++) {
	        if (self._row[i] ^ isWhite) {
	            counters[counterPos]++;
	        } else {
	            counterPos++;
	            counters[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return counters;
	};
	
	Object.defineProperty(BarcodeReader.prototype, "FORMAT", {
	    value: 'unknown',
	    writeable: false
	});
	
	BarcodeReader.DIRECTION = {
	    FORWARD: 1,
	    REVERSE: -1
	};
	
	BarcodeReader.Exception = {
	    StartNotFoundException: "Start-Info was not found!",
	    CodeNotFoundException: "Code could not be found!",
	    PatternNotFoundException: "Pattern could not be found!"
	};
	
	BarcodeReader.CONFIG_KEYS = {};
	
	exports.default = BarcodeReader;

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	module.e = clone
	
	/**
	 * Creates a new vec2 initialized with values from an existing vector
	 *
	 * @param {vec2} a vector to clone
	 * @returns {vec2} a new 2D vector
	 */
	function clone(a) {
	    var out = new Float32Array(2)
	    out[0] = a[0]
	    out[1] = a[1]
	    return out
	}

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}
	
	module.e = isObjectLike;


/***/ },
/* 9 */
/***/ function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	exports.default = {
	    init: function init(arr, val) {
	        var l = arr.length;
	        while (l--) {
	            arr[l] = val;
	        }
	    },
	
	    /**
	     * Shuffles the content of an array
	     * @return {Array} the array itself shuffled
	     */
	    shuffle: function shuffle(arr) {
	        var i = arr.length - 1,
	            j,
	            x;
	        for (i; i >= 0; i--) {
	            j = Math.floor(Math.random() * i);
	            x = arr[i];
	            arr[i] = arr[j];
	            arr[j] = x;
	        }
	        return arr;
	    },
	
	    toPointList: function toPointList(arr) {
	        var i,
	            j,
	            row = [],
	            rows = [];
	        for (i = 0; i < arr.length; i++) {
	            row = [];
	            for (j = 0; j < arr[i].length; j++) {
	                row[j] = arr[i][j];
	            }
	            rows[i] = "[" + row.join(",") + "]";
	        }
	        return "[" + rows.join(",\r\n") + "]";
	    },
	
	    /**
	     * returns the elements which's score is bigger than the threshold
	     * @return {Array} the reduced array
	     */
	    threshold: function threshold(arr, _threshold, scoreFunc) {
	        var i,
	            queue = [];
	        for (i = 0; i < arr.length; i++) {
	            if (scoreFunc.apply(arr, [arr[i]]) >= _threshold) {
	                queue.push(arr[i]);
	            }
	        }
	        return queue;
	    },
	
	    maxIndex: function maxIndex(arr) {
	        var i,
	            max = 0;
	        for (i = 0; i < arr.length; i++) {
	            if (arr[i] > arr[max]) {
	                max = i;
	            }
	        }
	        return max;
	    },
	
	    max: function max(arr) {
	        var i,
	            max = 0;
	        for (i = 0; i < arr.length; i++) {
	            if (arr[i] > max) {
	                max = arr[i];
	            }
	        }
	        return max;
	    },
	
	    sum: function sum(arr) {
	        var length = arr.length,
	            sum = 0;
	
	        while (length--) {
	            sum += arr[length];
	        }
	        return sum;
	    }
	};

/***/ },
/* 10 */
/***/ function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	exports.default = {
	    drawRect: function drawRect(pos, size, ctx, style) {
	        ctx.strokeStyle = style.color;
	        ctx.fillStyle = style.color;
	        ctx.lineWidth = 1;
	        ctx.beginPath();
	        ctx.strokeRect(pos.x, pos.y, size.x, size.y);
	    },
	    drawPath: function drawPath(path, def, ctx, style) {
	        ctx.strokeStyle = style.color;
	        ctx.fillStyle = style.color;
	        ctx.lineWidth = style.lineWidth;
	        ctx.beginPath();
	        ctx.moveTo(path[0][def.x], path[0][def.y]);
	        for (var j = 1; j < path.length; j++) {
	            ctx.lineTo(path[j][def.x], path[j][def.y]);
	        }
	        ctx.closePath();
	        ctx.stroke();
	    },
	    drawImage: function drawImage(imageData, size, ctx) {
	        var canvasData = ctx.getImageData(0, 0, size.x, size.y),
	            data = canvasData.data,
	            imageDataPos = imageData.length,
	            canvasDataPos = data.length,
	            value;
	
	        if (canvasDataPos / imageDataPos !== 4) {
	            return false;
	        }
	        while (imageDataPos--) {
	            value = imageData[imageDataPos];
	            data[--canvasDataPos] = 255;
	            data[--canvasDataPos] = value;
	            data[--canvasDataPos] = value;
	            data[--canvasDataPos] = value;
	        }
	        ctx.putImageData(canvasData, 0, 0);
	        return true;
	    }
	};

/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/**
	 * Gets the index at which the first occurrence of `key` is found in `array`
	 * of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to search.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}
	
	module.e = assocIndexOf;


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	var isNative = __webpack_require__(141);
	
	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = object[key];
	  return isNative(value) ? value : undefined;
	}
	
	module.e = getNative;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return type == 'number' || type == 'boolean' ||
	    (type == 'string' && value != '__proto__') || value == null;
	}
	
	module.e = isKeyable;


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12);
	
	/* Built-in method references that are verified to be native. */
	var nativeCreate = getNative(Object, 'create');
	
	module.e = nativeCreate;


/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Performs a [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var other = { 'user': 'fred' };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}
	
	module.e = eq;


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(2);
	
	/** `Object#toString` result references. */
	var funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 8 which returns 'object' for typed array and weak map constructors,
	  // and PhantomJS 1.9 which returns 'function' for `NodeList` instances.
	  var tag = isObject(value) ? objectToString.call(value) : '';
	  return tag == funcTag || tag == genTag;
	}
	
	module.e = isFunction;


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	var baseMerge = __webpack_require__(100),
	    createAssigner = __webpack_require__(114);
	
	/**
	 * This method is like `_.assign` except that it recursively merges own and
	 * inherited enumerable properties of source objects into the destination
	 * object. Source properties that resolve to `undefined` are skipped if a
	 * destination value exists. Array and plain object properties are merged
	 * recursively.Other objects and value types are overridden by assignment.
	 * Source objects are applied from left to right. Subsequent sources
	 * overwrite property assignments of previous sources.
	 *
	 * **Note:** This method mutates `object`.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The destination object.
	 * @param {...Object} [sources] The source objects.
	 * @returns {Object} Returns `object`.
	 * @example
	 *
	 * var users = {
	 *   'data': [{ 'user': 'barney' }, { 'user': 'fred' }]
	 * };
	 *
	 * var ages = {
	 *   'data': [{ 'age': 36 }, { 'age': 40 }]
	 * };
	 *
	 * _.merge(users, ages);
	 * // => { 'data': [{ 'user': 'barney', 'age': 36 }, { 'user': 'fred', 'age': 40 }] }
	 */
	var merge = createAssigner(function(object, source, srcIndex) {
	  baseMerge(object, source, srcIndex);
	});
	
	module.e = merge;


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	exports._dimensionsConverters = exports.ERODE = exports.DILATE = exports.Tracer = undefined;
	exports.imageRef = imageRef;
	exports.computeIntegralImage2 = computeIntegralImage2;
	exports.computeIntegralImage = computeIntegralImage;
	exports.thresholdImage = thresholdImage;
	exports.computeHistogram = computeHistogram;
	exports.sharpenLine = sharpenLine;
	exports.determineOtsuThreshold = determineOtsuThreshold;
	exports.otsuThreshold = otsuThreshold;
	exports.computeBinaryImage = computeBinaryImage;
	exports.cluster = cluster;
	exports.dilate = dilate;
	exports.erode = erode;
	exports.subtract = subtract;
	exports.bitwiseOr = bitwiseOr;
	exports.countNonZero = countNonZero;
	exports.topGeneric = topGeneric;
	exports.grayArrayFromImage = grayArrayFromImage;
	exports.grayArrayFromContext = grayArrayFromContext;
	exports.grayAndHalfSampleFromCanvasData = grayAndHalfSampleFromCanvasData;
	exports.computeGray = computeGray;
	exports.loadImageArray = loadImageArray;
	exports.halfSample = halfSample;
	exports.hsv2rgb = hsv2rgb;
	exports._computeDivisors = _computeDivisors;
	exports.calculatePatchSize = calculatePatchSize;
	exports._parseCSSDimensionValues = _parseCSSDimensionValues;
	exports.computeImageArea = computeImageArea;
	
	var _cluster = __webpack_require__(53);
	
	var _cluster2 = _interopRequireDefault(_cluster);
	
	var _array_helper = __webpack_require__(9);
	
	var _array_helper2 = _interopRequireDefault(_array_helper);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	var vec3 = {
	    clone: __webpack_require__(79)
	};
	
	/**
	 * @param x x-coordinate
	 * @param y y-coordinate
	 * @return ImageReference {x,y} Coordinate
	 */
	function imageRef(x, y) {
	    var that = {
	        x: x,
	        y: y,
	        toVec2: function toVec2() {
	            return vec2.clone([this.x, this.y]);
	        },
	        toVec3: function toVec3() {
	            return vec3.clone([this.x, this.y, 1]);
	        },
	        round: function round() {
	            this.x = this.x > 0.0 ? Math.floor(this.x + 0.5) : Math.floor(this.x - 0.5);
	            this.y = this.y > 0.0 ? Math.floor(this.y + 0.5) : Math.floor(this.y - 0.5);
	            return this;
	        }
	    };
	    return that;
	};
	
	/**
	 * Computes an integral image of a given grayscale image.
	 * @param imageDataContainer {ImageDataContainer} the image to be integrated
	 */
	function computeIntegralImage2(imageWrapper, integralWrapper) {
	    var imageData = imageWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0,
	        posA = 0,
	        posB = 0,
	        posC = 0,
	        posD = 0,
	        x,
	        y;
	
	    // sum up first column
	    posB = width;
	    sum = 0;
	    for (y = 1; y < height; y++) {
	        sum += imageData[posA];
	        integralImageData[posB] += sum;
	        posA += width;
	        posB += width;
	    }
	
	    posA = 0;
	    posB = 1;
	    sum = 0;
	    for (x = 1; x < width; x++) {
	        sum += imageData[posA];
	        integralImageData[posB] += sum;
	        posA++;
	        posB++;
	    }
	
	    for (y = 1; y < height; y++) {
	        posA = y * width + 1;
	        posB = (y - 1) * width + 1;
	        posC = y * width;
	        posD = (y - 1) * width;
	        for (x = 1; x < width; x++) {
	            integralImageData[posA] += imageData[posA] + integralImageData[posB] + integralImageData[posC] - integralImageData[posD];
	            posA++;
	            posB++;
	            posC++;
	            posD++;
	        }
	    }
	};
	
	function computeIntegralImage(imageWrapper, integralWrapper) {
	    var imageData = imageWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0;
	
	    // sum up first row
	    for (var i = 0; i < width; i++) {
	        sum += imageData[i];
	        integralImageData[i] = sum;
	    }
	
	    for (var v = 1; v < height; v++) {
	        sum = 0;
	        for (var u = 0; u < width; u++) {
	            sum += imageData[v * width + u];
	            integralImageData[v * width + u] = sum + integralImageData[(v - 1) * width + u];
	        }
	    }
	};
	
	function thresholdImage(imageWrapper, threshold, targetWrapper) {
	    if (!targetWrapper) {
	        targetWrapper = imageWrapper;
	    }
	    var imageData = imageWrapper.data,
	        length = imageData.length,
	        targetData = targetWrapper.data;
	
	    while (length--) {
	        targetData[length] = imageData[length] < threshold ? 1 : 0;
	    }
	};
	
	function computeHistogram(imageWrapper, bitsPerPixel) {
	    if (!bitsPerPixel) {
	        bitsPerPixel = 8;
	    }
	    var imageData = imageWrapper.data,
	        length = imageData.length,
	        bitShift = 8 - bitsPerPixel,
	        bucketCnt = 1 << bitsPerPixel,
	        hist = new Int32Array(bucketCnt);
	
	    while (length--) {
	        hist[imageData[length] >> bitShift]++;
	    }
	    return hist;
	};
	
	function sharpenLine(line) {
	    var i,
	        length = line.length,
	        left = line[0],
	        center = line[1],
	        right;
	
	    for (i = 1; i < length - 1; i++) {
	        right = line[i + 1];
	        //  -1 4 -1 kernel
	        line[i - 1] = center * 2 - left - right & 255;
	        left = center;
	        center = right;
	    }
	    return line;
	};
	
	function determineOtsuThreshold(imageWrapper, bitsPerPixel) {
	    if (!bitsPerPixel) {
	        bitsPerPixel = 8;
	    }
	    var hist,
	        threshold,
	        bitShift = 8 - bitsPerPixel;
	
	    function px(init, end) {
	        var sum = 0,
	            i;
	        for (i = init; i <= end; i++) {
	            sum += hist[i];
	        }
	        return sum;
	    }
	
	    function mx(init, end) {
	        var i,
	            sum = 0;
	
	        for (i = init; i <= end; i++) {
	            sum += i * hist[i];
	        }
	
	        return sum;
	    }
	
	    function determineThreshold() {
	        var vet = [0],
	            p1,
	            p2,
	            p12,
	            k,
	            m1,
	            m2,
	            m12,
	            max = (1 << bitsPerPixel) - 1;
	
	        hist = computeHistogram(imageWrapper, bitsPerPixel);
	        for (k = 1; k < max; k++) {
	            p1 = px(0, k);
	            p2 = px(k + 1, max);
	            p12 = p1 * p2;
	            if (p12 === 0) {
	                p12 = 1;
	            }
	            m1 = mx(0, k) * p2;
	            m2 = mx(k + 1, max) * p1;
	            m12 = m1 - m2;
	            vet[k] = m12 * m12 / p12;
	        }
	        return _array_helper2.default.maxIndex(vet);
	    }
	
	    threshold = determineThreshold();
	    return threshold << bitShift;
	};
	
	function otsuThreshold(imageWrapper, targetWrapper) {
	    var threshold = determineOtsuThreshold(imageWrapper);
	
	    thresholdImage(imageWrapper, threshold, targetWrapper);
	    return threshold;
	};
	
	// local thresholding
	function computeBinaryImage(imageWrapper, integralWrapper, targetWrapper) {
	    computeIntegralImage(imageWrapper, integralWrapper);
	
	    if (!targetWrapper) {
	        targetWrapper = imageWrapper;
	    }
	    var imageData = imageWrapper.data;
	    var targetData = targetWrapper.data;
	    var width = imageWrapper.size.x;
	    var height = imageWrapper.size.y;
	    var integralImageData = integralWrapper.data;
	    var sum = 0,
	        v,
	        u,
	        kernel = 3,
	        A,
	        B,
	        C,
	        D,
	        avg,
	        size = (kernel * 2 + 1) * (kernel * 2 + 1);
	
	    // clear out top & bottom-border
	    for (v = 0; v <= kernel; v++) {
	        for (u = 0; u < width; u++) {
	            targetData[v * width + u] = 0;
	            targetData[(height - 1 - v) * width + u] = 0;
	        }
	    }
	
	    // clear out left & right border
	    for (v = kernel; v < height - kernel; v++) {
	        for (u = 0; u <= kernel; u++) {
	            targetData[v * width + u] = 0;
	            targetData[v * width + (width - 1 - u)] = 0;
	        }
	    }
	
	    for (v = kernel + 1; v < height - kernel - 1; v++) {
	        for (u = kernel + 1; u < width - kernel; u++) {
	            A = integralImageData[(v - kernel - 1) * width + (u - kernel - 1)];
	            B = integralImageData[(v - kernel - 1) * width + (u + kernel)];
	            C = integralImageData[(v + kernel) * width + (u - kernel - 1)];
	            D = integralImageData[(v + kernel) * width + (u + kernel)];
	            sum = D - C - B + A;
	            avg = sum / size;
	            targetData[v * width + u] = imageData[v * width + u] > avg + 5 ? 0 : 1;
	        }
	    }
	};
	
	function cluster(points, threshold, property) {
	    var i,
	        k,
	        cluster,
	        point,
	        clusters = [];
	
	    if (!property) {
	        property = "rad";
	    }
	
	    function addToCluster(newPoint) {
	        var found = false;
	        for (k = 0; k < clusters.length; k++) {
	            cluster = clusters[k];
	            if (cluster.fits(newPoint)) {
	                cluster.add(newPoint);
	                found = true;
	            }
	        }
	        return found;
	    }
	
	    // iterate over each cloud
	    for (i = 0; i < points.length; i++) {
	        point = _cluster2.default.createPoint(points[i], i, property);
	        if (!addToCluster(point)) {
	            clusters.push(_cluster2.default.create(point, threshold));
	        }
	    }
	    return clusters;
	};
	
	var Tracer = exports.Tracer = {
	    trace: function trace(points, vec) {
	        var iteration,
	            maxIterations = 10,
	            top = [],
	            result = [],
	            centerPos = 0,
	            currentPos = 0;
	
	        function trace(idx, forward) {
	            var from,
	                to,
	                toIdx,
	                predictedPos,
	                thresholdX = 1,
	                thresholdY = Math.abs(vec[1] / 10),
	                found = false;
	
	            function match(pos, predicted) {
	                if (pos.x > predicted.x - thresholdX && pos.x < predicted.x + thresholdX && pos.y > predicted.y - thresholdY && pos.y < predicted.y + thresholdY) {
	                    return true;
	                } else {
	                    return false;
	                }
	            }
	
	            // check if the next index is within the vec specifications
	            // if not, check as long as the threshold is met
	
	            from = points[idx];
	            if (forward) {
	                predictedPos = {
	                    x: from.x + vec[0],
	                    y: from.y + vec[1]
	                };
	            } else {
	                predictedPos = {
	                    x: from.x - vec[0],
	                    y: from.y - vec[1]
	                };
	            }
	
	            toIdx = forward ? idx + 1 : idx - 1;
	            to = points[toIdx];
	            while (to && (found = match(to, predictedPos)) !== true && Math.abs(to.y - from.y) < vec[1]) {
	                toIdx = forward ? toIdx + 1 : toIdx - 1;
	                to = points[toIdx];
	            }
	
	            return found ? toIdx : null;
	        }
	
	        for (iteration = 0; iteration < maxIterations; iteration++) {
	            // randomly select point to start with
	            centerPos = Math.floor(Math.random() * points.length);
	
	            // trace forward
	            top = [];
	            currentPos = centerPos;
	            top.push(points[currentPos]);
	            while ((currentPos = trace(currentPos, true)) !== null) {
	                top.push(points[currentPos]);
	            }
	            if (centerPos > 0) {
	                currentPos = centerPos;
	                while ((currentPos = trace(currentPos, false)) !== null) {
	                    top.push(points[currentPos]);
	                }
	            }
	
	            if (top.length > result.length) {
	                result = top;
	            }
	        }
	        return result;
	    }
	};
	
	var DILATE = exports.DILATE = 1;
	var ERODE = exports.ERODE = 2;
	
	function dilate(inImageWrapper, outImageWrapper) {
	    var v,
	        u,
	        inImageData = inImageWrapper.data,
	        outImageData = outImageWrapper.data,
	        height = inImageWrapper.size.y,
	        width = inImageWrapper.size.x,
	        sum,
	        yStart1,
	        yStart2,
	        xStart1,
	        xStart2;
	
	    for (v = 1; v < height - 1; v++) {
	        for (u = 1; u < width - 1; u++) {
	            yStart1 = v - 1;
	            yStart2 = v + 1;
	            xStart1 = u - 1;
	            xStart2 = u + 1;
	            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
	            outImageData[v * width + u] = sum > 0 ? 1 : 0;
	        }
	    }
	};
	
	function erode(inImageWrapper, outImageWrapper) {
	    var v,
	        u,
	        inImageData = inImageWrapper.data,
	        outImageData = outImageWrapper.data,
	        height = inImageWrapper.size.y,
	        width = inImageWrapper.size.x,
	        sum,
	        yStart1,
	        yStart2,
	        xStart1,
	        xStart2;
	
	    for (v = 1; v < height - 1; v++) {
	        for (u = 1; u < width - 1; u++) {
	            yStart1 = v - 1;
	            yStart2 = v + 1;
	            xStart1 = u - 1;
	            xStart2 = u + 1;
	            sum = inImageData[yStart1 * width + xStart1] + inImageData[yStart1 * width + xStart2] + inImageData[v * width + u] + inImageData[yStart2 * width + xStart1] + inImageData[yStart2 * width + xStart2];
	            outImageData[v * width + u] = sum === 5 ? 1 : 0;
	        }
	    }
	};
	
	function subtract(aImageWrapper, bImageWrapper, resultImageWrapper) {
	    if (!resultImageWrapper) {
	        resultImageWrapper = aImageWrapper;
	    }
	    var length = aImageWrapper.data.length,
	        aImageData = aImageWrapper.data,
	        bImageData = bImageWrapper.data,
	        cImageData = resultImageWrapper.data;
	
	    while (length--) {
	        cImageData[length] = aImageData[length] - bImageData[length];
	    }
	};
	
	function bitwiseOr(aImageWrapper, bImageWrapper, resultImageWrapper) {
	    if (!resultImageWrapper) {
	        resultImageWrapper = aImageWrapper;
	    }
	    var length = aImageWrapper.data.length,
	        aImageData = aImageWrapper.data,
	        bImageData = bImageWrapper.data,
	        cImageData = resultImageWrapper.data;
	
	    while (length--) {
	        cImageData[length] = aImageData[length] || bImageData[length];
	    }
	};
	
	function countNonZero(imageWrapper) {
	    var length = imageWrapper.data.length,
	        data = imageWrapper.data,
	        sum = 0;
	
	    while (length--) {
	        sum += data[length];
	    }
	    return sum;
	};
	
	function topGeneric(list, top, scoreFunc) {
	    var i,
	        minIdx = 0,
	        min = 0,
	        queue = [],
	        score,
	        hit,
	        pos;
	
	    for (i = 0; i < top; i++) {
	        queue[i] = {
	            score: 0,
	            item: null
	        };
	    }
	
	    for (i = 0; i < list.length; i++) {
	        score = scoreFunc.apply(this, [list[i]]);
	        if (score > min) {
	            hit = queue[minIdx];
	            hit.score = score;
	            hit.item = list[i];
	            min = Number.MAX_VALUE;
	            for (pos = 0; pos < top; pos++) {
	                if (queue[pos].score < min) {
	                    min = queue[pos].score;
	                    minIdx = pos;
	                }
	            }
	        }
	    }
	
	    return queue;
	};
	
	function grayArrayFromImage(htmlImage, offsetX, ctx, array) {
	    ctx.drawImage(htmlImage, offsetX, 0, htmlImage.width, htmlImage.height);
	    var ctxData = ctx.getImageData(offsetX, 0, htmlImage.width, htmlImage.height).data;
	    computeGray(ctxData, array);
	};
	
	function grayArrayFromContext(ctx, size, offset, array) {
	    var ctxData = ctx.getImageData(offset.x, offset.y, size.x, size.y).data;
	    computeGray(ctxData, array);
	};
	
	function grayAndHalfSampleFromCanvasData(canvasData, size, outArray) {
	    var topRowIdx = 0;
	    var bottomRowIdx = size.x;
	    var endIdx = Math.floor(canvasData.length / 4);
	    var outWidth = size.x / 2;
	    var outImgIdx = 0;
	    var inWidth = size.x;
	    var i;
	
	    while (bottomRowIdx < endIdx) {
	        for (i = 0; i < outWidth; i++) {
	            outArray[outImgIdx] = Math.floor((0.299 * canvasData[topRowIdx * 4 + 0] + 0.587 * canvasData[topRowIdx * 4 + 1] + 0.114 * canvasData[topRowIdx * 4 + 2] + (0.299 * canvasData[(topRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(topRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(topRowIdx + 1) * 4 + 2]) + (0.299 * canvasData[bottomRowIdx * 4 + 0] + 0.587 * canvasData[bottomRowIdx * 4 + 1] + 0.114 * canvasData[bottomRowIdx * 4 + 2]) + (0.299 * canvasData[(bottomRowIdx + 1) * 4 + 0] + 0.587 * canvasData[(bottomRowIdx + 1) * 4 + 1] + 0.114 * canvasData[(bottomRowIdx + 1) * 4 + 2])) / 4);
	            outImgIdx++;
	            topRowIdx = topRowIdx + 2;
	            bottomRowIdx = bottomRowIdx + 2;
	        }
	        topRowIdx = topRowIdx + inWidth;
	        bottomRowIdx = bottomRowIdx + inWidth;
	    }
	};
	
	function computeGray(imageData, outArray, config) {
	    var l = imageData.length / 4 | 0,
	        i,
	        singleChannel = config && config.singleChannel === true;
	
	    if (singleChannel) {
	        for (i = 0; i < l; i++) {
	            outArray[i] = imageData[i * 4 + 0];
	        }
	    } else {
	        for (i = 0; i < l; i++) {
	            outArray[i] = Math.floor(0.299 * imageData[i * 4 + 0] + 0.587 * imageData[i * 4 + 1] + 0.114 * imageData[i * 4 + 2]);
	        }
	    }
	};
	
	function loadImageArray(src, callback, canvas) {
	    if (!canvas) {
	        canvas = document.createElement('canvas');
	    }
	    var img = new Image();
	    img.callback = callback;
	    img.onload = function () {
	        canvas.width = this.width;
	        canvas.height = this.height;
	        var ctx = canvas.getContext('2d');
	        ctx.drawImage(this, 0, 0);
	        var array = new Uint8Array(this.width * this.height);
	        ctx.drawImage(this, 0, 0);
	        var data = ctx.getImageData(0, 0, this.width, this.height).data;
	        computeGray(data, array);
	        this.callback(array, {
	            x: this.width,
	            y: this.height
	        }, this);
	    };
	    img.src = src;
	};
	
	/**
	 * @param inImg {ImageWrapper} input image to be sampled
	 * @param outImg {ImageWrapper} to be stored in
	 */
	function halfSample(inImgWrapper, outImgWrapper) {
	    var inImg = inImgWrapper.data;
	    var inWidth = inImgWrapper.size.x;
	    var outImg = outImgWrapper.data;
	    var topRowIdx = 0;
	    var bottomRowIdx = inWidth;
	    var endIdx = inImg.length;
	    var outWidth = inWidth / 2;
	    var outImgIdx = 0;
	    while (bottomRowIdx < endIdx) {
	        for (var i = 0; i < outWidth; i++) {
	            outImg[outImgIdx] = Math.floor((inImg[topRowIdx] + inImg[topRowIdx + 1] + inImg[bottomRowIdx] + inImg[bottomRowIdx + 1]) / 4);
	            outImgIdx++;
	            topRowIdx = topRowIdx + 2;
	            bottomRowIdx = bottomRowIdx + 2;
	        }
	        topRowIdx = topRowIdx + inWidth;
	        bottomRowIdx = bottomRowIdx + inWidth;
	    }
	};
	
	function hsv2rgb(hsv, rgb) {
	    var h = hsv[0],
	        s = hsv[1],
	        v = hsv[2],
	        c = v * s,
	        x = c * (1 - Math.abs(h / 60 % 2 - 1)),
	        m = v - c,
	        r = 0,
	        g = 0,
	        b = 0;
	
	    rgb = rgb || [0, 0, 0];
	
	    if (h < 60) {
	        r = c;
	        g = x;
	    } else if (h < 120) {
	        r = x;
	        g = c;
	    } else if (h < 180) {
	        g = c;
	        b = x;
	    } else if (h < 240) {
	        g = x;
	        b = c;
	    } else if (h < 300) {
	        r = x;
	        b = c;
	    } else if (h < 360) {
	        r = c;
	        b = x;
	    }
	    rgb[0] = (r + m) * 255 | 0;
	    rgb[1] = (g + m) * 255 | 0;
	    rgb[2] = (b + m) * 255 | 0;
	    return rgb;
	};
	
	function _computeDivisors(n) {
	    var largeDivisors = [],
	        divisors = [],
	        i;
	
	    for (i = 1; i < Math.sqrt(n) + 1; i++) {
	        if (n % i === 0) {
	            divisors.push(i);
	            if (i !== n / i) {
	                largeDivisors.unshift(Math.floor(n / i));
	            }
	        }
	    }
	    return divisors.concat(largeDivisors);
	};
	
	function _computeIntersection(arr1, arr2) {
	    var i = 0,
	        j = 0,
	        result = [];
	
	    while (i < arr1.length && j < arr2.length) {
	        if (arr1[i] === arr2[j]) {
	            result.push(arr1[i]);
	            i++;
	            j++;
	        } else if (arr1[i] > arr2[j]) {
	            j++;
	        } else {
	            i++;
	        }
	    }
	    return result;
	};
	
	function calculatePatchSize(patchSize, imgSize) {
	    var divisorsX = _computeDivisors(imgSize.x),
	        divisorsY = _computeDivisors(imgSize.y),
	        wideSide = Math.max(imgSize.x, imgSize.y),
	        common = _computeIntersection(divisorsX, divisorsY),
	        nrOfPatchesList = [8, 10, 15, 20, 32, 60, 80],
	        nrOfPatchesMap = {
	        "x-small": 5,
	        "small": 4,
	        "medium": 3,
	        "large": 2,
	        "x-large": 1
	    },
	        nrOfPatchesIdx = nrOfPatchesMap[patchSize] || nrOfPatchesMap.medium,
	        nrOfPatches = nrOfPatchesList[nrOfPatchesIdx],
	        desiredPatchSize = Math.floor(wideSide / nrOfPatches),
	        optimalPatchSize;
	
	    function findPatchSizeForDivisors(divisors) {
	        var i = 0,
	            found = divisors[Math.floor(divisors.length / 2)];
	
	        while (i < divisors.length - 1 && divisors[i] < desiredPatchSize) {
	            i++;
	        }
	        if (i > 0) {
	            if (Math.abs(divisors[i] - desiredPatchSize) > Math.abs(divisors[i - 1] - desiredPatchSize)) {
	                found = divisors[i - 1];
	            } else {
	                found = divisors[i];
	            }
	        }
	        if (desiredPatchSize / found < nrOfPatchesList[nrOfPatchesIdx + 1] / nrOfPatchesList[nrOfPatchesIdx] && desiredPatchSize / found > nrOfPatchesList[nrOfPatchesIdx - 1] / nrOfPatchesList[nrOfPatchesIdx]) {
	            return { x: found, y: found };
	        }
	        return null;
	    }
	
	    optimalPatchSize = findPatchSizeForDivisors(common);
	    if (!optimalPatchSize) {
	        optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(wideSide));
	        if (!optimalPatchSize) {
	            optimalPatchSize = findPatchSizeForDivisors(_computeDivisors(desiredPatchSize * nrOfPatches));
	        }
	    }
	    return optimalPatchSize;
	};
	
	function _parseCSSDimensionValues(value) {
	    var dimension = {
	        value: parseFloat(value),
	        unit: value.indexOf("%") === value.length - 1 ? "%" : "%"
	    };
	
	    return dimension;
	};
	
	var _dimensionsConverters = exports._dimensionsConverters = {
	    top: function top(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.height * (dimension.value / 100));
	        }
	    },
	    right: function right(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.width - context.width * (dimension.value / 100));
	        }
	    },
	    bottom: function bottom(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.height - context.height * (dimension.value / 100));
	        }
	    },
	    left: function left(dimension, context) {
	        if (dimension.unit === "%") {
	            return Math.floor(context.width * (dimension.value / 100));
	        }
	    }
	};
	
	function computeImageArea(inputWidth, inputHeight, area) {
	    var context = { width: inputWidth, height: inputHeight };
	
	    var parsedArea = Object.keys(area).reduce(function (result, key) {
	        var value = area[key],
	            parsed = _parseCSSDimensionValues(value),
	            calculated = _dimensionsConverters[key](parsed, context);
	
	        result[key] = calculated;
	        return result;
	    }, {});
	
	    return {
	        sx: parsedArea.left,
	        sy: parsedArea.top,
	        sw: parsedArea.right - parsedArea.left,
	        sh: parsedArea.bottom - parsedArea.top
	    };
	};

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _subImage = __webpack_require__(55);
	
	var _subImage2 = _interopRequireDefault(_subImage);
	
	var _cv_utils = __webpack_require__(18);
	
	var _array_helper = __webpack_require__(9);
	
	var _array_helper2 = _interopRequireDefault(_array_helper);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	
	/**
	 * Represents a basic image combining the data and size.
	 * In addition, some methods for manipulation are contained.
	 * @param size {x,y} The size of the image in pixel
	 * @param data {Array} If given, a flat array containing the pixel data
	 * @param ArrayType {Type} If given, the desired DataType of the Array (may be typed/non-typed)
	 * @param initialize {Boolean} Indicating if the array should be initialized on creation.
	 * @returns {ImageWrapper}
	 */
	function ImageWrapper(size, data, ArrayType, initialize) {
	    if (!data) {
	        if (ArrayType) {
	            this.data = new ArrayType(size.x * size.y);
	            if (ArrayType === Array && initialize) {
	                _array_helper2.default.init(this.data, 0);
	            }
	        } else {
	            this.data = new Uint8Array(size.x * size.y);
	            if (Uint8Array === Array && initialize) {
	                _array_helper2.default.init(this.data, 0);
	            }
	        }
	    } else {
	        this.data = data;
	    }
	    this.size = size;
	}
	
	/**
	 * tests if a position is within the image with a given offset
	 * @param imgRef {x, y} The location to test
	 * @param border Number the padding value in pixel
	 * @returns {Boolean} true if location inside the image's border, false otherwise
	 * @see cvd/image.h
	 */
	ImageWrapper.prototype.inImageWithBorder = function (imgRef, border) {
	    return imgRef.x >= border && imgRef.y >= border && imgRef.x < this.size.x - border && imgRef.y < this.size.y - border;
	};
	
	/**
	 * Performs bilinear sampling
	 * @param inImg Image to extract sample from
	 * @param x the x-coordinate
	 * @param y the y-coordinate
	 * @returns the sampled value
	 * @see cvd/vision.h
	 */
	ImageWrapper.sample = function (inImg, x, y) {
	    var lx = Math.floor(x);
	    var ly = Math.floor(y);
	    var w = inImg.size.x;
	    var base = ly * inImg.size.x + lx;
	    var a = inImg.data[base + 0];
	    var b = inImg.data[base + 1];
	    var c = inImg.data[base + w];
	    var d = inImg.data[base + w + 1];
	    var e = a - b;
	    x -= lx;
	    y -= ly;
	
	    var result = Math.floor(x * (y * (e - c + d) - e) + y * (c - a) + a);
	    return result;
	};
	
	/**
	 * Initializes a given array. Sets each element to zero.
	 * @param array {Array} The array to initialize
	 */
	ImageWrapper.clearArray = function (array) {
	    var l = array.length;
	    while (l--) {
	        array[l] = 0;
	    }
	};
	
	/**
	 * Creates a {SubImage} from the current image ({this}).
	 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
	 * @param size {ImageRef} The size of the resulting image
	 * @returns {SubImage} A shared part of the original image
	 */
	ImageWrapper.prototype.subImage = function (from, size) {
	    return new _subImage2.default(from, size, this);
	};
	
	/**
	 * Creates an {ImageWrapper) and copies the needed underlying image-data area
	 * @param imageWrapper {ImageWrapper} The target {ImageWrapper} where the data should be copied
	 * @param from {ImageRef} The location where to copy from (top-left location)
	 */
	ImageWrapper.prototype.subImageAsCopy = function (imageWrapper, from) {
	    var sizeY = imageWrapper.size.y,
	        sizeX = imageWrapper.size.x;
	    var x, y;
	    for (x = 0; x < sizeX; x++) {
	        for (y = 0; y < sizeY; y++) {
	            imageWrapper.data[y * sizeX + x] = this.data[(from.y + y) * this.size.x + from.x + x];
	        }
	    }
	};
	
	ImageWrapper.prototype.copyTo = function (imageWrapper) {
	    var length = this.data.length,
	        srcData = this.data,
	        dstData = imageWrapper.data;
	
	    while (length--) {
	        dstData[length] = srcData[length];
	    }
	};
	
	/**
	 * Retrieves a given pixel position from the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	ImageWrapper.prototype.get = function (x, y) {
	    return this.data[y * this.size.x + x];
	};
	
	/**
	 * Retrieves a given pixel position from the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	ImageWrapper.prototype.getSafe = function (x, y) {
	    var i;
	
	    if (!this.indexMapping) {
	        this.indexMapping = {
	            x: [],
	            y: []
	        };
	        for (i = 0; i < this.size.x; i++) {
	            this.indexMapping.x[i] = i;
	            this.indexMapping.x[i + this.size.x] = i;
	        }
	        for (i = 0; i < this.size.y; i++) {
	            this.indexMapping.y[i] = i;
	            this.indexMapping.y[i + this.size.y] = i;
	        }
	    }
	    return this.data[this.indexMapping.y[y + this.size.y] * this.size.x + this.indexMapping.x[x + this.size.x]];
	};
	
	/**
	 * Sets a given pixel position in the image
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @param value {Number} The grayscale value to set
	 * @returns {ImageWrapper} The Image itself (for possible chaining)
	 */
	ImageWrapper.prototype.set = function (x, y, value) {
	    this.data[y * this.size.x + x] = value;
	    return this;
	};
	
	/**
	 * Sets the border of the image (1 pixel) to zero
	 */
	ImageWrapper.prototype.zeroBorder = function () {
	    var i,
	        width = this.size.x,
	        height = this.size.y,
	        data = this.data;
	    for (i = 0; i < width; i++) {
	        data[i] = data[(height - 1) * width + i] = 0;
	    }
	    for (i = 1; i < height - 1; i++) {
	        data[i * width] = data[i * width + (width - 1)] = 0;
	    }
	};
	
	/**
	 * Inverts a binary image in place
	 */
	ImageWrapper.prototype.invert = function () {
	    var data = this.data,
	        length = data.length;
	
	    while (length--) {
	        data[length] = data[length] ? 0 : 1;
	    }
	};
	
	ImageWrapper.prototype.convolve = function (kernel) {
	    var x,
	        y,
	        kx,
	        ky,
	        kSize = kernel.length / 2 | 0,
	        accu = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            accu = 0;
	            for (ky = -kSize; ky <= kSize; ky++) {
	                for (kx = -kSize; kx <= kSize; kx++) {
	                    accu += kernel[ky + kSize][kx + kSize] * this.getSafe(x + kx, y + ky);
	                }
	            }
	            this.data[y * this.size.x + x] = accu;
	        }
	    }
	};
	
	ImageWrapper.prototype.moments = function (labelcount) {
	    var data = this.data,
	        x,
	        y,
	        height = this.size.y,
	        width = this.size.x,
	        val,
	        ysq,
	        labelsum = [],
	        i,
	        label,
	        mu11,
	        mu02,
	        mu20,
	        x_,
	        y_,
	        tmp,
	        result = [],
	        PI = Math.PI,
	        PI_4 = PI / 4;
	
	    if (labelcount <= 0) {
	        return result;
	    }
	
	    for (i = 0; i < labelcount; i++) {
	        labelsum[i] = {
	            m00: 0,
	            m01: 0,
	            m10: 0,
	            m11: 0,
	            m02: 0,
	            m20: 0,
	            theta: 0,
	            rad: 0
	        };
	    }
	
	    for (y = 0; y < height; y++) {
	        ysq = y * y;
	        for (x = 0; x < width; x++) {
	            val = data[y * width + x];
	            if (val > 0) {
	                label = labelsum[val - 1];
	                label.m00 += 1;
	                label.m01 += y;
	                label.m10 += x;
	                label.m11 += x * y;
	                label.m02 += ysq;
	                label.m20 += x * x;
	            }
	        }
	    }
	
	    for (i = 0; i < labelcount; i++) {
	        label = labelsum[i];
	        if (!isNaN(label.m00) && label.m00 !== 0) {
	            x_ = label.m10 / label.m00;
	            y_ = label.m01 / label.m00;
	            mu11 = label.m11 / label.m00 - x_ * y_;
	            mu02 = label.m02 / label.m00 - y_ * y_;
	            mu20 = label.m20 / label.m00 - x_ * x_;
	            tmp = (mu02 - mu20) / (2 * mu11);
	            tmp = 0.5 * Math.atan(tmp) + (mu11 >= 0 ? PI_4 : -PI_4) + PI;
	            label.theta = (tmp * 180 / PI + 90) % 180 - 90;
	            if (label.theta < 0) {
	                label.theta += 180;
	            }
	            label.rad = tmp > PI ? tmp - PI : tmp;
	            label.vec = vec2.clone([Math.cos(tmp), Math.sin(tmp)]);
	            result.push(label);
	        }
	    }
	
	    return result;
	};
	
	/**
	 * Displays the {ImageWrapper} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	ImageWrapper.prototype.show = function (canvas, scale) {
	    var ctx, frame, data, current, pixel, x, y;
	
	    if (!scale) {
	        scale = 1.0;
	    }
	    ctx = canvas.getContext('2d');
	    canvas.width = this.size.x;
	    canvas.height = this.size.y;
	    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
	    data = frame.data;
	    current = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            pixel = y * this.size.x + x;
	            current = this.get(x, y) * scale;
	            data[pixel * 4 + 0] = current;
	            data[pixel * 4 + 1] = current;
	            data[pixel * 4 + 2] = current;
	            data[pixel * 4 + 3] = 255;
	        }
	    }
	    //frame.data = data;
	    ctx.putImageData(frame, 0, 0);
	};
	
	/**
	 * Displays the {SubImage} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	ImageWrapper.prototype.overlay = function (canvas, scale, from) {
	    if (!scale || scale < 0 || scale > 360) {
	        scale = 360;
	    }
	    var hsv = [0, 1, 1];
	    var rgb = [0, 0, 0];
	    var whiteRgb = [255, 255, 255];
	    var blackRgb = [0, 0, 0];
	    var result = [];
	    var ctx = canvas.getContext('2d');
	    var frame = ctx.getImageData(from.x, from.y, this.size.x, this.size.y);
	    var data = frame.data;
	    var length = this.data.length;
	    while (length--) {
	        hsv[0] = this.data[length] * scale;
	        result = hsv[0] <= 0 ? whiteRgb : hsv[0] >= 360 ? blackRgb : (0, _cv_utils.hsv2rgb)(hsv, rgb);
	        data[length * 4 + 0] = result[0];
	        data[length * 4 + 1] = result[1];
	        data[length * 4 + 2] = result[2];
	        data[length * 4 + 3] = 255;
	    }
	    ctx.putImageData(frame, from.x, from.y);
	};
	
	exports.default = ImageWrapper;

/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A specialized version of `_.reduce` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @param {*} [accumulator] The initial value.
	 * @param {boolean} [initAccum] Specify using the first element of `array` as the initial value.
	 * @returns {*} Returns the accumulated value.
	 */
	function arrayReduce(array, iteratee, accumulator, initAccum) {
	  var index = -1,
	      length = array.length;
	
	  if (initAccum && length) {
	    accumulator = array[++index];
	  }
	  while (++index < length) {
	    accumulator = iteratee(accumulator, array[index], index, array);
	  }
	  return accumulator;
	}
	
	module.e = arrayReduce;


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var copyObjectWith = __webpack_require__(112);
	
	/**
	 * Copies properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property names to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @returns {Object} Returns `object`.
	 */
	function copyObject(source, props, object) {
	  return copyObjectWith(source, props, object);
	}
	
	module.e = copyObject;


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}
	
	module.e = isHostObject;


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;
	
	/** Used to detect unsigned integer values. */
	var reIsUint = /^(?:0|[1-9]\d*)$/;
	
	/**
	 * Checks if `value` is a valid array-like index.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	 */
	function isIndex(value, length) {
	  value = (typeof value == 'number' || reIsUint.test(value)) ? +value : -1;
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return value > -1 && value % 1 == 0 && value < length;
	}
	
	module.e = isIndex;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Checks if `value` is likely a prototype object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	 */
	function isPrototype(value) {
	  var Ctor = value && value.constructor,
	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;
	
	  return value === proto;
	}
	
	module.e = isPrototype;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	var isArrayLikeObject = __webpack_require__(27);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Built-in value references. */
	var propertyIsEnumerable = objectProto.propertyIsEnumerable;
	
	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	function isArguments(value) {
	  // Safari 8.1 incorrectly makes `arguments.callee` enumerable in strict mode.
	  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
	    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
	}
	
	module.e = isArguments;


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var getLength = __webpack_require__(116),
	    isFunction = __webpack_require__(16),
	    isLength = __webpack_require__(28);
	
	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength(getLength(value)) && !isFunction(value);
	}
	
	module.e = isArrayLike;


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	var isArrayLike = __webpack_require__(26),
	    isObjectLike = __webpack_require__(8);
	
	/**
	 * This method is like `_.isArrayLike` except that it also checks if `value`
	 * is an object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array-like object, else `false`.
	 * @example
	 *
	 * _.isArrayLikeObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLikeObject(document.body.children);
	 * // => true
	 *
	 * _.isArrayLikeObject('abc');
	 * // => false
	 *
	 * _.isArrayLikeObject(_.noop);
	 * // => false
	 */
	function isArrayLikeObject(value) {
	  return isObjectLike(value) && isArrayLike(value);
	}
	
	module.e = isArrayLikeObject;


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;
	
	/**
	 * Checks if `value` is a valid array-like length.
	 *
	 * **Note:** This function is loosely based on [`ToLength`](http://ecma-international.org/ecma-262/6.0/#sec-tolength).
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
	 * @example
	 *
	 * _.isLength(3);
	 * // => true
	 *
	 * _.isLength(Number.MIN_VALUE);
	 * // => false
	 *
	 * _.isLength(Infinity);
	 * // => false
	 *
	 * _.isLength('3');
	 * // => false
	 */
	function isLength(value) {
	  return typeof value == 'number' &&
	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	}
	
	module.e = isLength;


/***/ },
/* 29 */
/***/ function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	/**
	 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
	 */
	var Tracer = {
	    searchDirections: [[0, 1], [1, 1], [1, 0], [1, -1], [0, -1], [-1, -1], [-1, 0], [-1, 1]],
	    create: function create(imageWrapper, labelWrapper) {
	        var imageData = imageWrapper.data,
	            labelData = labelWrapper.data,
	            searchDirections = this.searchDirections,
	            width = imageWrapper.size.x,
	            pos;
	
	        function _trace(current, color, label, edgelabel) {
	            var i, y, x;
	
	            for (i = 0; i < 7; i++) {
	                y = current.cy + searchDirections[current.dir][0];
	                x = current.cx + searchDirections[current.dir][1];
	                pos = y * width + x;
	                if (imageData[pos] === color && (labelData[pos] === 0 || labelData[pos] === label)) {
	                    labelData[pos] = label;
	                    current.cy = y;
	                    current.cx = x;
	                    return true;
	                } else {
	                    if (labelData[pos] === 0) {
	                        labelData[pos] = edgelabel;
	                    }
	                    current.dir = (current.dir + 1) % 8;
	                }
	            }
	            return false;
	        }
	
	        function vertex2D(x, y, dir) {
	            return {
	                dir: dir,
	                x: x,
	                y: y,
	                next: null,
	                prev: null
	            };
	        }
	
	        function _contourTracing(sy, sx, label, color, edgelabel) {
	            var Fv = null,
	                Cv,
	                P,
	                ldir,
	                current = {
	                cx: sx,
	                cy: sy,
	                dir: 0
	            };
	
	            if (_trace(current, color, label, edgelabel)) {
	                Fv = vertex2D(sx, sy, current.dir);
	                Cv = Fv;
	                ldir = current.dir;
	                P = vertex2D(current.cx, current.cy, 0);
	                P.prev = Cv;
	                Cv.next = P;
	                P.next = null;
	                Cv = P;
	                do {
	                    current.dir = (current.dir + 6) % 8;
	                    _trace(current, color, label, edgelabel);
	                    if (ldir !== current.dir) {
	                        Cv.dir = current.dir;
	                        P = vertex2D(current.cx, current.cy, 0);
	                        P.prev = Cv;
	                        Cv.next = P;
	                        P.next = null;
	                        Cv = P;
	                    } else {
	                        Cv.dir = ldir;
	                        Cv.x = current.cx;
	                        Cv.y = current.cy;
	                    }
	                    ldir = current.dir;
	                } while (current.cx !== sx || current.cy !== sy);
	                Fv.prev = Cv.prev;
	                Cv.prev.next = Fv;
	            }
	            return Fv;
	        }
	
	        return {
	            trace: function trace(current, color, label, edgelabel) {
	                return _trace(current, color, label, edgelabel);
	            },
	            contourTracing: function contourTracing(sy, sx, label, color, edgelabel) {
	                return _contourTracing(sy, sx, label, color, edgelabel);
	            }
	        };
	    }
	};
	
	exports.default = Tracer;

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _barcode_reader = __webpack_require__(6);
	
	var _barcode_reader2 = _interopRequireDefault(_barcode_reader);
	
	var _array_helper = __webpack_require__(9);
	
	var _array_helper2 = _interopRequireDefault(_array_helper);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function Code39Reader() {
	    _barcode_reader2.default.call(this);
	}
	
	var properties = {
	    ALPHABETH_STRING: { value: "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%" },
	    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 45, 46, 32, 42, 36, 47, 43, 37] },
	    CHARACTER_ENCODINGS: { value: [0x034, 0x121, 0x061, 0x160, 0x031, 0x130, 0x070, 0x025, 0x124, 0x064, 0x109, 0x049, 0x148, 0x019, 0x118, 0x058, 0x00D, 0x10C, 0x04C, 0x01C, 0x103, 0x043, 0x142, 0x013, 0x112, 0x052, 0x007, 0x106, 0x046, 0x016, 0x181, 0x0C1, 0x1C0, 0x091, 0x190, 0x0D0, 0x085, 0x184, 0x0C4, 0x094, 0x0A8, 0x0A2, 0x08A, 0x02A] },
	    ASTERISK: { value: 0x094 },
	    FORMAT: { value: "code_39", writeable: false }
	};
	
	Code39Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
	Code39Reader.prototype.constructor = Code39Reader;
	
	Code39Reader.prototype._toCounters = function (start, counter) {
	    var self = this,
	        numCounters = counter.length,
	        end = self._row.length,
	        isWhite = !self._row[start],
	        i,
	        counterPos = 0;
	
	    _array_helper2.default.init(counter, 0);
	
	    for (i = start; i < end; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            counterPos++;
	            if (counterPos === numCounters) {
	                break;
	            } else {
	                counter[counterPos] = 1;
	                isWhite = !isWhite;
	            }
	        }
	    }
	
	    return counter;
	};
	
	Code39Reader.prototype._decode = function () {
	    var self = this,
	        counters = [0, 0, 0, 0, 0, 0, 0, 0, 0],
	        result = [],
	        start = self._findStart(),
	        decodedChar,
	        lastStart,
	        pattern,
	        nextStart;
	
	    if (!start) {
	        return null;
	    }
	    nextStart = self._nextSet(self._row, start.end);
	
	    do {
	        counters = self._toCounters(nextStart, counters);
	        pattern = self._toPattern(counters);
	        if (pattern < 0) {
	            return null;
	        }
	        decodedChar = self._patternToChar(pattern);
	        if (decodedChar < 0) {
	            return null;
	        }
	        result.push(decodedChar);
	        lastStart = nextStart;
	        nextStart += _array_helper2.default.sum(counters);
	        nextStart = self._nextSet(self._row, nextStart);
	    } while (decodedChar !== '*');
	    result.pop();
	
	    if (!result.length) {
	        return null;
	    }
	
	    if (!self._verifyTrailingWhitespace(lastStart, nextStart, counters)) {
	        return null;
	    }
	
	    return {
	        code: result.join(""),
	        start: start.start,
	        end: nextStart,
	        startInfo: start,
	        decodedCodes: result
	    };
	};
	
	Code39Reader.prototype._verifyTrailingWhitespace = function (lastStart, nextStart, counters) {
	    var trailingWhitespaceEnd,
	        patternSize = _array_helper2.default.sum(counters);
	
	    trailingWhitespaceEnd = nextStart - lastStart - patternSize;
	    if (trailingWhitespaceEnd * 3 >= patternSize) {
	        return true;
	    }
	    return false;
	};
	
	Code39Reader.prototype._patternToChar = function (pattern) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
	        if (self.CHARACTER_ENCODINGS[i] === pattern) {
	            return String.fromCharCode(self.ALPHABET[i]);
	        }
	    }
	    return -1;
	};
	
	Code39Reader.prototype._findNextWidth = function (counters, current) {
	    var i,
	        minWidth = Number.MAX_VALUE;
	
	    for (i = 0; i < counters.length; i++) {
	        if (counters[i] < minWidth && counters[i] > current) {
	            minWidth = counters[i];
	        }
	    }
	
	    return minWidth;
	};
	
	Code39Reader.prototype._toPattern = function (counters) {
	    var numCounters = counters.length,
	        maxNarrowWidth = 0,
	        numWideBars = numCounters,
	        wideBarWidth = 0,
	        self = this,
	        pattern,
	        i;
	
	    while (numWideBars > 3) {
	        maxNarrowWidth = self._findNextWidth(counters, maxNarrowWidth);
	        numWideBars = 0;
	        pattern = 0;
	        for (i = 0; i < numCounters; i++) {
	            if (counters[i] > maxNarrowWidth) {
	                pattern |= 1 << numCounters - 1 - i;
	                numWideBars++;
	                wideBarWidth += counters[i];
	            }
	        }
	
	        if (numWideBars === 3) {
	            for (i = 0; i < numCounters && numWideBars > 0; i++) {
	                if (counters[i] > maxNarrowWidth) {
	                    numWideBars--;
	                    if (counters[i] * 2 >= wideBarWidth) {
	                        return -1;
	                    }
	                }
	            }
	            return pattern;
	        }
	    }
	    return -1;
	};
	
	Code39Reader.prototype._findStart = function () {
	    var self = this,
	        offset = self._nextSet(self._row),
	        patternStart = offset,
	        counter = [0, 0, 0, 0, 0, 0, 0, 0, 0],
	        counterPos = 0,
	        isWhite = false,
	        i,
	        j,
	        whiteSpaceMustStart;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                // find start pattern
	                if (self._toPattern(counter) === self.ASTERISK) {
	                    whiteSpaceMustStart = Math.floor(Math.max(0, patternStart - (i - patternStart) / 4));
	                    if (self._matchRange(whiteSpaceMustStart, patternStart, 0)) {
	                        return {
	                            start: patternStart,
	                            end: i
	                        };
	                    }
	                }
	
	                patternStart += counter[0] + counter[1];
	                for (j = 0; j < 7; j++) {
	                    counter[j] = counter[j + 2];
	                }
	                counter[7] = 0;
	                counter[8] = 0;
	                counterPos--;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	exports.default = Code39Reader;

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	module.e = dot
	
	/**
	 * Calculates the dot product of two vec2's
	 *
	 * @param {vec2} a the first operand
	 * @param {vec2} b the second operand
	 * @returns {Number} dot product of a and b
	 */
	function dot(a, b) {
	    return a[0] * b[0] + a[1] * b[1]
	}

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	var stackClear = __webpack_require__(134),
	    stackDelete = __webpack_require__(135),
	    stackGet = __webpack_require__(136),
	    stackHas = __webpack_require__(137),
	    stackSet = __webpack_require__(138);
	
	/**
	 * Creates a stack cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [values] The values to cache.
	 */
	function Stack(values) {
	  var index = -1,
	      length = values ? values.length : 0;
	
	  this.clear();
	  while (++index < length) {
	    var entry = values[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	
	// Add functions to the `Stack` cache.
	Stack.prototype.clear = stackClear;
	Stack.prototype['delete'] = stackDelete;
	Stack.prototype.get = stackGet;
	Stack.prototype.has = stackHas;
	Stack.prototype.set = stackSet;
	
	module.e = Stack;


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A specialized version of `_.forEach` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns `array`.
	 */
	function arrayEach(array, iteratee) {
	  var index = -1,
	      length = array.length;
	
	  while (++index < length) {
	    if (iteratee(array[index], index, array) === false) {
	      break;
	    }
	  }
	  return array;
	}
	
	module.e = arrayEach;


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/**
	 * This function is like `assignValue` except that it doesn't assign
	 * `undefined` values.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignMergeValue(object, key, value) {
	  if ((value !== undefined && !eq(object[key], value)) ||
	      (typeof key == 'number' && value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}
	
	module.e = assignMergeValue;


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Assigns `value` to `key` of `object` if the existing value is not equivalent
	 * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * for equality comparisons.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	      (value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}
	
	module.e = assignValue;


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/** Used for built-in method references. */
	var arrayProto = Array.prototype;
	
	/** Built-in value references. */
	var splice = arrayProto.splice;
	
	/**
	 * Removes `key` and its value from the associative array.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function assocDelete(array, key) {
	  var index = assocIndexOf(array, key);
	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = array.length - 1;
	  if (index == lastIndex) {
	    array.pop();
	  } else {
	    splice.call(array, index, 1);
	  }
	  return true;
	}
	
	module.e = assocDelete;


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Gets the associative array value for `key`.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function assocGet(array, key) {
	  var index = assocIndexOf(array, key);
	  return index < 0 ? undefined : array[index][1];
	}
	
	module.e = assocGet;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Checks if an associative array value for `key` exists.
	 *
	 * @private
	 * @param {Array} array The array to query.
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function assocHas(array, key) {
	  return assocIndexOf(array, key) > -1;
	}
	
	module.e = assocHas;


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var assocIndexOf = __webpack_require__(11);
	
	/**
	 * Sets the associative array `key` to `value`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 */
	function assocSet(array, key, value) {
	  var index = assocIndexOf(array, key);
	  if (index < 0) {
	    array.push([key, value]);
	  } else {
	    array[index][1] = value;
	  }
	}
	
	module.e = assocSet;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	var Uint8Array = __webpack_require__(85);
	
	/**
	 * Creates a clone of `arrayBuffer`.
	 *
	 * @private
	 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
	 * @returns {ArrayBuffer} Returns the cloned array buffer.
	 */
	function cloneArrayBuffer(arrayBuffer) {
	  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
	  return result;
	}
	
	module.e = cloneArrayBuffer;


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copies the values of `source` to `array`.
	 *
	 * @private
	 * @param {Array} source The array to copy values from.
	 * @param {Array} [array=[]] The array to copy values to.
	 * @returns {Array} Returns `array`.
	 */
	function copyArray(source, array) {
	  var index = -1,
	      length = source.length;
	
	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}
	
	module.e = copyArray;


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @param {Object} hash The hash to query.
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(hash, key) {
	  return nativeCreate ? hash[key] !== undefined : hasOwnProperty.call(hash, key);
	}
	
	module.e = hashHas;


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	var baseTimes = __webpack_require__(104),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isLength = __webpack_require__(28),
	    isString = __webpack_require__(143);
	
	/**
	 * Creates an array of index keys for `object` values of arrays,
	 * `arguments` objects, and strings, otherwise `null` is returned.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array|null} Returns index keys, else `null`.
	 */
	function indexKeys(object) {
	  var length = object ? object.length : undefined;
	  if (isLength(length) &&
	      (isArray(object) || isString(object) || isArguments(object))) {
	    return baseTimes(length, String);
	  }
	  return null;
	}
	
	module.e = indexKeys;


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var isLength = __webpack_require__(28),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    weakMapTag = '[object WeakMap]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/** Used to identify `toStringTag` values of typed arrays. */
	var typedArrayTags = {};
	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	typedArrayTags[uint32Tag] = true;
	typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
	typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	typedArrayTags[dateTag] = typedArrayTags[errorTag] =
	typedArrayTags[funcTag] = typedArrayTags[mapTag] =
	typedArrayTags[numberTag] = typedArrayTags[objectTag] =
	typedArrayTags[regexpTag] = typedArrayTags[setTag] =
	typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a typed array.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isTypedArray(new Uint8Array);
	 * // => true
	 *
	 * _.isTypedArray([]);
	 * // => false
	 */
	function isTypedArray(value) {
	  return isObjectLike(value) &&
	    isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
	}
	
	module.e = isTypedArray;


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	var baseHas = __webpack_require__(97),
	    baseKeys = __webpack_require__(98),
	    indexKeys = __webpack_require__(43),
	    isArrayLike = __webpack_require__(26),
	    isIndex = __webpack_require__(23),
	    isPrototype = __webpack_require__(24);
	
	/**
	 * Creates an array of the own enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects. See the
	 * [ES spec](http://ecma-international.org/ecma-262/6.0/#sec-object.keys)
	 * for more details.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keys(new Foo);
	 * // => ['a', 'b'] (iteration order is not guaranteed)
	 *
	 * _.keys('hi');
	 * // => ['0', '1']
	 */
	function keys(object) {
	  var isProto = isPrototype(object);
	  if (!(isProto || isArrayLike(object))) {
	    return baseKeys(object);
	  }
	  var indexes = indexKeys(object),
	      skipIndexes = !!indexes,
	      result = indexes || [],
	      length = result.length;
	
	  for (var key in object) {
	    if (baseHas(object, key) &&
	        !(skipIndexes && (key == 'length' || isIndex(key, length))) &&
	        !(isProto && key == 'constructor')) {
	      result.push(key);
	    }
	  }
	  return result;
	}
	
	module.e = keys;


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var baseKeysIn = __webpack_require__(99),
	    indexKeys = __webpack_require__(43),
	    isIndex = __webpack_require__(23),
	    isPrototype = __webpack_require__(24);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Creates an array of the own and inherited enumerable property names of `object`.
	 *
	 * **Note:** Non-object values are coerced to objects.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.keysIn(new Foo);
	 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
	 */
	function keysIn(object) {
	  var index = -1,
	      isProto = isPrototype(object),
	      props = baseKeysIn(object),
	      propsLength = props.length,
	      indexes = indexKeys(object),
	      skipIndexes = !!indexes,
	      result = indexes || [],
	      length = result.length;
	
	  while (++index < propsLength) {
	    var key = props[index];
	    if (!(skipIndexes && (key == 'length' || isIndex(key, length))) &&
	        !(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
	      result.push(key);
	    }
	  }
	  return result;
	}
	
	module.e = keysIn;


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var apply = __webpack_require__(89),
	    toInteger = __webpack_require__(145);
	
	/** Used as the `TypeError` message for "Functions" methods. */
	var FUNC_ERROR_TEXT = 'Expected a function';
	
	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeMax = Math.max;
	
	/**
	 * Creates a function that invokes `func` with the `this` binding of the
	 * created function and arguments from `start` and beyond provided as an array.
	 *
	 * **Note:** This method is based on the [rest parameter](https://mdn.io/rest_parameters).
	 *
	 * @static
	 * @memberOf _
	 * @category Function
	 * @param {Function} func The function to apply a rest parameter to.
	 * @param {number} [start=func.length-1] The start position of the rest parameter.
	 * @returns {Function} Returns the new function.
	 * @example
	 *
	 * var say = _.rest(function(what, names) {
	 *   return what + ' ' + _.initial(names).join(', ') +
	 *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
	 * });
	 *
	 * say('hello', 'fred', 'barney', 'pebbles');
	 * // => 'hello fred, barney, & pebbles'
	 */
	function rest(func, start) {
	  if (typeof func != 'function') {
	    throw new TypeError(FUNC_ERROR_TEXT);
	  }
	  start = nativeMax(start === undefined ? (func.length - 1) : toInteger(start), 0);
	  return function() {
	    var args = arguments,
	        index = -1,
	        length = nativeMax(args.length - start, 0),
	        array = Array(length);
	
	    while (++index < length) {
	      array[index] = args[start + index];
	    }
	    switch (start) {
	      case 0: return func.call(this, array);
	      case 1: return func.call(this, args[0], array);
	      case 2: return func.call(this, args[0], args[1], array);
	    }
	    var otherArgs = Array(start + 1);
	    index = -1;
	    while (++index < start) {
	      otherArgs[index] = args[index];
	    }
	    otherArgs[start] = array;
	    return apply(func, this, otherArgs);
	  };
	}
	
	module.e = rest;


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	module.e = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			Object.defineProperty(module, "exports", {
				enumerable: true,
				configurable: false,
				get: function() { return module.e; },
				set: function(v) { return module.e = v; }
			});
			Object.defineProperty(module, "loaded", {
				enumerable: true,
				configurable: false,
				get: function() { return module.l; }
			});
			Object.defineProperty(module, "id", {
				enumerable: true,
				configurable: false,
				get: function() { return module.i; }
			});
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _merge2 = __webpack_require__(17);
	
	var _merge3 = _interopRequireDefault(_merge2);
	
	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // eslint-disable-line no-unused-vars
	// eslint-disable-line no-unused-vars
	
	
	var _typedefs = __webpack_require__(56);
	
	var _typedefs2 = _interopRequireDefault(_typedefs);
	
	var _webrtcAdapter = __webpack_require__(148);
	
	var _webrtcAdapter2 = _interopRequireDefault(_webrtcAdapter);
	
	var _image_wrapper = __webpack_require__(19);
	
	var _image_wrapper2 = _interopRequireDefault(_image_wrapper);
	
	var _barcode_locator = __webpack_require__(62);
	
	var _barcode_locator2 = _interopRequireDefault(_barcode_locator);
	
	var _barcode_decoder = __webpack_require__(59);
	
	var _barcode_decoder2 = _interopRequireDefault(_barcode_decoder);
	
	var _events = __webpack_require__(54);
	
	var _events2 = _interopRequireDefault(_events);
	
	var _camera_access = __webpack_require__(61);
	
	var _camera_access2 = _interopRequireDefault(_camera_access);
	
	var _image_debug = __webpack_require__(10);
	
	var _image_debug2 = _interopRequireDefault(_image_debug);
	
	var _result_collector = __webpack_require__(52);
	
	var _result_collector2 = _interopRequireDefault(_result_collector);
	
	var _config2 = __webpack_require__(57);
	
	var _config3 = _interopRequireDefault(_config2);
	
	var _input_stream = __webpack_require__(51);
	
	var _input_stream2 = _interopRequireDefault(_input_stream);
	
	var _frame_grabber = __webpack_require__(50);
	
	var _frame_grabber2 = _interopRequireDefault(_frame_grabber);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var vec2 = {
	    clone: __webpack_require__(7)
	};
	
	var _inputStream,
	    _framegrabber,
	    _stopped,
	    _canvasContainer = {
	    ctx: {
	        image: null,
	        overlay: null
	    },
	    dom: {
	        image: null,
	        overlay: null
	    }
	},
	    _inputImageWrapper,
	    _boxSize,
	    _decoder,
	    _workerPool = [],
	    _onUIThread = true,
	    _resultCollector,
	    _config = {};
	
	function initializeData(imageWrapper) {
	    initBuffers(imageWrapper);
	    _decoder = _barcode_decoder2.default.create(_config.decoder, _inputImageWrapper);
	}
	
	function initInputStream(cb) {
	    var video;
	    if (_config.inputStream.type === "VideoStream") {
	        video = document.createElement("video");
	        _inputStream = _input_stream2.default.createVideoStream(video);
	    } else if (_config.inputStream.type === "ImageStream") {
	        _inputStream = _input_stream2.default.createImageStream();
	    } else if (_config.inputStream.type === "LiveStream") {
	        var $viewport = getViewPort();
	        if ($viewport) {
	            video = $viewport.querySelector("video");
	            if (!video) {
	                video = document.createElement("video");
	                $viewport.appendChild(video);
	            }
	        }
	        _inputStream = _input_stream2.default.createLiveStream(video);
	        _camera_access2.default.request(video, _config.inputStream.constraints).then(function () {
	            _inputStream.trigger("canrecord");
	        }).catch(function (err) {
	            return cb(err);
	        });
	    }
	
	    _inputStream.setAttribute("preload", "auto");
	    _inputStream.setAttribute("autoplay", true);
	    _inputStream.setInputStream(_config.inputStream);
	    _inputStream.addEventListener("canrecord", canRecord.bind(undefined, cb));
	}
	
	function getViewPort() {
	    var target = _config.inputStream.target;
	    // Check if target is already a DOM element
	    if (target && target.nodeName && target.nodeType === 1) {
	        return target;
	    } else {
	        // Use '#interactive.viewport' as a fallback selector (backwards compatibility)
	        var selector = typeof target === 'string' ? target : '#interactive.viewport';
	        return document.querySelector(selector);
	    }
	}
	
	function canRecord(cb) {
	    _barcode_locator2.default.checkImageConstraints(_inputStream, _config.locator);
	    initCanvas(_config);
	    _framegrabber = _frame_grabber2.default.create(_inputStream, _canvasContainer.dom.image);
	
	    adjustWorkerPool(_config.numOfWorkers, function () {
	        if (_config.numOfWorkers === 0) {
	            initializeData();
	        }
	        ready(cb);
	    });
	}
	
	function ready(cb) {
	    _inputStream.play();
	    cb();
	}
	
	function initCanvas() {
	    if (typeof document !== "undefined") {
	        var $viewport = getViewPort();
	        _canvasContainer.dom.image = document.querySelector("canvas.imgBuffer");
	        if (!_canvasContainer.dom.image) {
	            _canvasContainer.dom.image = document.createElement("canvas");
	            _canvasContainer.dom.image.className = "imgBuffer";
	            if ($viewport && _config.inputStream.type === "ImageStream") {
	                $viewport.appendChild(_canvasContainer.dom.image);
	            }
	        }
	        _canvasContainer.ctx.image = _canvasContainer.dom.image.getContext("2d");
	        _canvasContainer.dom.image.width = _inputStream.getCanvasSize().x;
	        _canvasContainer.dom.image.height = _inputStream.getCanvasSize().y;
	
	        _canvasContainer.dom.overlay = document.querySelector("canvas.drawingBuffer");
	        if (!_canvasContainer.dom.overlay) {
	            _canvasContainer.dom.overlay = document.createElement("canvas");
	            _canvasContainer.dom.overlay.className = "drawingBuffer";
	            if ($viewport) {
	                $viewport.appendChild(_canvasContainer.dom.overlay);
	            }
	            var clearFix = document.createElement("br");
	            clearFix.setAttribute("clear", "all");
	            if ($viewport) {
	                $viewport.appendChild(clearFix);
	            }
	        }
	        _canvasContainer.ctx.overlay = _canvasContainer.dom.overlay.getContext("2d");
	        _canvasContainer.dom.overlay.width = _inputStream.getCanvasSize().x;
	        _canvasContainer.dom.overlay.height = _inputStream.getCanvasSize().y;
	    }
	}
	
	function initBuffers(imageWrapper) {
	    if (imageWrapper) {
	        _inputImageWrapper = imageWrapper;
	    } else {
	        _inputImageWrapper = new _image_wrapper2.default({
	            x: _inputStream.getWidth(),
	            y: _inputStream.getHeight()
	        });
	    }
	
	    if (false) {
	        console.log(_inputImageWrapper.size);
	    }
	    _boxSize = [vec2.clone([0, 0]), vec2.clone([0, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, _inputImageWrapper.size.y]), vec2.clone([_inputImageWrapper.size.x, 0])];
	    _barcode_locator2.default.init(_inputImageWrapper, _config.locator);
	}
	
	function getBoundingBoxes() {
	    if (_config.locate) {
	        return _barcode_locator2.default.locate();
	    } else {
	        return [[vec2.clone(_boxSize[0]), vec2.clone(_boxSize[1]), vec2.clone(_boxSize[2]), vec2.clone(_boxSize[3])]];
	    }
	}
	
	function transformResult(result) {
	    var topRight = _inputStream.getTopRight(),
	        xOffset = topRight.x,
	        yOffset = topRight.y,
	        i;
	
	    if (xOffset === 0 && yOffset === 0) {
	        return;
	    }
	
	    if (result.barcodes) {
	        for (i = 0; i < result.barcodes.length; i++) {
	            transformResult(result.barcodes[i]);
	        }
	    }
	
	    if (result.line && result.line.length === 2) {
	        moveLine(result.line);
	    }
	
	    if (result.box) {
	        moveBox(result.box);
	    }
	
	    if (result.boxes && result.boxes.length > 0) {
	        for (i = 0; i < result.boxes.length; i++) {
	            moveBox(result.boxes[i]);
	        }
	    }
	
	    function moveBox(box) {
	        var corner = box.length;
	
	        while (corner--) {
	            box[corner][0] += xOffset;
	            box[corner][1] += yOffset;
	        }
	    }
	
	    function moveLine(line) {
	        line[0].x += xOffset;
	        line[0].y += yOffset;
	        line[1].x += xOffset;
	        line[1].y += yOffset;
	    }
	}
	
	function addResult(result, imageData) {
	    if (!imageData || !_resultCollector) {
	        return;
	    }
	
	    if (result.barcodes) {
	        result.barcodes.filter(function (barcode) {
	            return barcode.codeResult;
	        }).forEach(function (barcode) {
	            return addResult(barcode, imageData);
	        });
	    } else if (result.codeResult) {
	        _resultCollector.addResult(imageData, _inputStream.getCanvasSize(), result.codeResult);
	    }
	}
	
	function hasCodeResult(result) {
	    return result && (result.barcodes ? result.barcodes.some(function (barcode) {
	        return barcode.codeResult;
	    }) : result.codeResult);
	}
	
	function publishResult(result, imageData) {
	    var resultToPublish = result;
	
	    if (result && _onUIThread) {
	        transformResult(result);
	        addResult(result, imageData);
	        resultToPublish = result.barcodes || result;
	    }
	
	    _events2.default.publish("processed", resultToPublish);
	    if (hasCodeResult(result)) {
	        _events2.default.publish("detected", resultToPublish);
	    }
	}
	
	function locateAndDecode() {
	    var result, boxes;
	
	    boxes = getBoundingBoxes();
	    if (boxes) {
	        result = _decoder.decodeFromBoundingBoxes(boxes);
	        result = result || {};
	        result.boxes = boxes;
	        publishResult(result, _inputImageWrapper.data);
	    } else {
	        publishResult();
	    }
	}
	
	function update() {
	    var availableWorker;
	
	    if (_onUIThread) {
	        if (_workerPool.length > 0) {
	            availableWorker = _workerPool.filter(function (workerThread) {
	                return !workerThread.busy;
	            })[0];
	            if (availableWorker) {
	                _framegrabber.attachData(availableWorker.imageData);
	            } else {
	                return; // all workers are busy
	            }
	        } else {
	                _framegrabber.attachData(_inputImageWrapper.data);
	            }
	        if (_framegrabber.grab()) {
	            if (availableWorker) {
	                availableWorker.busy = true;
	                availableWorker.worker.postMessage({
	                    cmd: 'process',
	                    imageData: availableWorker.imageData
	                }, [availableWorker.imageData.buffer]);
	            } else {
	                locateAndDecode();
	            }
	        }
	    } else {
	        locateAndDecode();
	    }
	}
	
	function startContinuousUpdate() {
	    var next = null,
	        delay = 1000 / (_config.frequency || 60);
	
	    _stopped = false;
	    (function frame(timestamp) {
	        next = next || timestamp;
	        if (!_stopped) {
	            if (timestamp >= next) {
	                next += delay;
	                update();
	            }
	            window.requestAnimFrame(frame);
	        }
	    })(performance.now());
	}
	
	function _start() {
	    if (_onUIThread && _config.inputStream.type === "LiveStream") {
	        startContinuousUpdate();
	    } else {
	        update();
	    }
	}
	
	function initWorker(cb) {
	    var blobURL,
	        workerThread = {
	        worker: undefined,
	        imageData: new Uint8Array(_inputStream.getWidth() * _inputStream.getHeight()),
	        busy: true
	    };
	
	    blobURL = generateWorkerBlob();
	    workerThread.worker = new Worker(blobURL);
	
	    workerThread.worker.onmessage = function (e) {
	        if (e.data.event === 'initialized') {
	            URL.revokeObjectURL(blobURL);
	            workerThread.busy = false;
	            workerThread.imageData = new Uint8Array(e.data.imageData);
	            if (false) {
	                console.log("Worker initialized");
	            }
	            return cb(workerThread);
	        } else if (e.data.event === 'processed') {
	            workerThread.imageData = new Uint8Array(e.data.imageData);
	            workerThread.busy = false;
	            publishResult(e.data.result, workerThread.imageData);
	        } else if (e.data.event === 'error') {
	            if (false) {
	                console.log("Worker error: " + e.data.message);
	            }
	        }
	    };
	
	    workerThread.worker.postMessage({
	        cmd: 'init',
	        size: { x: _inputStream.getWidth(), y: _inputStream.getHeight() },
	        imageData: workerThread.imageData,
	        config: configForWorker(_config)
	    }, [workerThread.imageData.buffer]);
	}
	
	function configForWorker(config) {
	    return _extends({}, config, {
	        inputStream: _extends({}, config.inputStream, {
	            target: null
	        })
	    });
	}
	
	function workerInterface(factory) {
	    /* eslint-disable no-undef*/
	    if (factory) {
	        var Quagga = factory().default;
	        if (!Quagga) {
	            self.postMessage({ 'event': 'error', message: 'Quagga could not be created' });
	            return;
	        }
	    }
	    var imageWrapper;
	
	    self.onmessage = function (e) {
	        if (e.data.cmd === 'init') {
	            var config = e.data.config;
	            config.numOfWorkers = 0;
	            imageWrapper = new Quagga.ImageWrapper({
	                x: e.data.size.x,
	                y: e.data.size.y
	            }, new Uint8Array(e.data.imageData));
	            Quagga.init(config, ready, imageWrapper);
	            Quagga.onProcessed(onProcessed);
	        } else if (e.data.cmd === 'process') {
	            imageWrapper.data = new Uint8Array(e.data.imageData);
	            Quagga.start();
	        } else if (e.data.cmd === 'setReaders') {
	            Quagga.setReaders(e.data.readers);
	        }
	    };
	
	    function onProcessed(result) {
	        self.postMessage({
	            'event': 'processed',
	            imageData: imageWrapper.data,
	            result: result
	        }, [imageWrapper.data.buffer]);
	    }
	
	    function ready() {
	        // eslint-disable-line
	        self.postMessage({ 'event': 'initialized', imageData: imageWrapper.data }, [imageWrapper.data.buffer]);
	    }
	
	    /* eslint-enable */
	}
	
	function generateWorkerBlob() {
	    var blob, factorySource;
	
	    /* jshint ignore:start */
	    if (typeof __factorySource__ !== 'undefined') {
	        factorySource = __factorySource__; // eslint-disable-line no-undef
	    }
	    /* jshint ignore:end */
	
	    blob = new Blob(['(' + workerInterface.toString() + ')(' + factorySource + ');'], { type: 'text/javascript' });
	
	    return window.URL.createObjectURL(blob);
	}
	
	function _setReaders(readers) {
	    if (_decoder) {
	        _decoder.setReaders(readers);
	    } else if (_onUIThread && _workerPool.length > 0) {
	        _workerPool.forEach(function (workerThread) {
	            workerThread.worker.postMessage({ cmd: 'setReaders', readers: readers });
	        });
	    }
	}
	
	function adjustWorkerPool(capacity, cb) {
	    var increaseBy = capacity - _workerPool.length;
	    if (increaseBy === 0) {
	        return cb && cb();
	    }
	    if (increaseBy < 0) {
	        var workersToTerminate = _workerPool.slice(increaseBy);
	        workersToTerminate.forEach(function (workerThread) {
	            workerThread.worker.terminate();
	            if (false) {
	                console.log("Worker terminated!");
	            }
	        });
	        _workerPool = _workerPool.slice(0, increaseBy);
	        return cb && cb();
	    } else {
	        var workerInitialized = function workerInitialized(workerThread) {
	            _workerPool.push(workerThread);
	            if (_workerPool.length >= capacity) {
	                cb && cb();
	            }
	        };
	
	        for (var i = 0; i < increaseBy; i++) {
	            initWorker(workerInitialized);
	        }
	    }
	}
	
	exports.default = {
	    init: function init(config, cb, imageWrapper) {
	        _config = (0, _merge3.default)({}, _config3.default, config);
	        if (imageWrapper) {
	            _onUIThread = false;
	            initializeData(imageWrapper);
	            return cb();
	        } else {
	            initInputStream(cb);
	        }
	    },
	    start: function start() {
	        _start();
	    },
	    stop: function stop() {
	        _stopped = true;
	        adjustWorkerPool(0);
	        if (_config.inputStream.type === "LiveStream") {
	            _camera_access2.default.release();
	            _inputStream.clearEventHandlers();
	        }
	    },
	    pause: function pause() {
	        _stopped = true;
	    },
	    onDetected: function onDetected(callback) {
	        _events2.default.subscribe("detected", callback);
	    },
	    offDetected: function offDetected(callback) {
	        _events2.default.unsubscribe("detected", callback);
	    },
	    onProcessed: function onProcessed(callback) {
	        _events2.default.subscribe("processed", callback);
	    },
	    offProcessed: function offProcessed(callback) {
	        _events2.default.unsubscribe("processed", callback);
	    },
	    setReaders: function setReaders(readers) {
	        _setReaders(readers);
	    },
	    registerResultCollector: function registerResultCollector(resultCollector) {
	        if (resultCollector && typeof resultCollector.addResult === 'function') {
	            _resultCollector = resultCollector;
	        }
	    },
	    canvas: _canvasContainer,
	    decodeSingle: function decodeSingle(config, resultCallback) {
	        var _this = this;
	
	        config = (0, _merge3.default)({
	            inputStream: {
	                type: "ImageStream",
	                sequence: false,
	                size: 800,
	                src: config.src
	            },
	            numOfWorkers:  false ? 0 : 1,
	            locator: {
	                halfSample: false
	            }
	        }, config);
	        this.init(config, function () {
	            _events2.default.once("processed", function (result) {
	                _this.stop();
	                resultCallback.call(null, result);
	            }, true);
	            _start();
	        });
	    },
	    ImageWrapper: _image_wrapper2.default,
	    ImageDebug: _image_debug2.default,
	    ResultCollector: _result_collector2.default
	};

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var CVUtils = __webpack_require__(18),
	    Ndarray = __webpack_require__(156),
	    Interp2D = __webpack_require__(157).d2;
	
	var FrameGrabber = {};
	
	FrameGrabber.create = function (inputStream) {
	    var _that = {},
	        _streamConfig = inputStream.getConfig(),
	        _video_size = CVUtils.imageRef(inputStream.getRealWidth(), inputStream.getRealHeight()),
	        _canvasSize = inputStream.getCanvasSize(),
	        _size = CVUtils.imageRef(inputStream.getWidth(), inputStream.getHeight()),
	        _topRight = inputStream.getTopRight(),
	        _data = new Uint8Array(_size.x * _size.y),
	        _grayData = new Uint8Array(_video_size.x * _video_size.y),
	        _canvasData = new Uint8Array(_canvasSize.x * _canvasSize.y),
	        _grayImageArray = Ndarray(_grayData, [_video_size.y, _video_size.x]).transpose(1, 0),
	        _canvasImageArray = Ndarray(_canvasData, [_canvasSize.y, _canvasSize.x]).transpose(1, 0),
	        _targetImageArray = _canvasImageArray.hi(_topRight.x + _size.x, _topRight.y + _size.y).lo(_topRight.x, _topRight.y),
	        _stepSizeX = _video_size.x / _canvasSize.x,
	        _stepSizeY = _video_size.y / _canvasSize.y;
	
	    console.log("FrameGrabber", JSON.stringify({
	        videoSize: _grayImageArray.shape,
	        canvasSize: _canvasImageArray.shape,
	        stepSize: [_stepSizeX, _stepSizeY],
	        size: _targetImageArray.shape,
	        topRight: _topRight
	    }));
	
	    /**
	     * Uses the given array as frame-buffer
	     */
	    _that.attachData = function (data) {
	        _data = data;
	    };
	
	    /**
	     * Returns the used frame-buffer
	     */
	    _that.getData = function () {
	        return _data;
	    };
	
	    /**
	     * Fetches a frame from the input-stream and puts into the frame-buffer.
	     * The image-data is converted to gray-scale and then half-sampled if configured.
	     */
	    _that.grab = function () {
	        var frame = inputStream.getFrame();
	
	        if (frame) {
	            this.scaleAndCrop(frame);
	            return true;
	        } else {
	            return false;
	        }
	    };
	
	    _that.scaleAndCrop = function (frame) {
	        var x, y;
	
	        // 1. compute full-sized gray image
	        CVUtils.computeGray(frame.data, _grayData);
	
	        // 2. interpolate
	        for (y = 0; y < _canvasSize.y; y++) {
	            for (x = 0; x < _canvasSize.x; x++) {
	                _canvasImageArray.set(x, y, Interp2D(_grayImageArray, x * _stepSizeX, y * _stepSizeY) | 0);
	            }
	        }
	
	        // targetImageArray must be equal to targetSize
	        if (_targetImageArray.shape[0] !== _size.x || _targetImageArray.shape[1] !== _size.y) {
	            throw new Error("Shapes do not match!");
	        }
	
	        // 3. crop
	        for (y = 0; y < _size.y; y++) {
	            for (x = 0; x < _size.x; x++) {
	                _data[y * _size.x + x] = _targetImageArray.get(x, y);
	            }
	        }
	    }, _that.getSize = function () {
	        return _size;
	    };
	
	    return _that;
	};
	
	module.e = FrameGrabber;

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	var GetPixels = __webpack_require__(155);
	
	var InputStream = {};
	
	InputStream.createImageStream = function () {
	    var that = {};
	    var _config = null;
	
	    var width = 0,
	        height = 0,
	        frameIdx = 0,
	        paused = true,
	        loaded = false,
	        frame = null,
	        baseUrl,
	        ended = false,
	        size,
	        calculatedWidth,
	        calculatedHeight,
	        _eventNames = ['canrecord', 'ended'],
	        _eventHandlers = {},
	        _topRight = { x: 0, y: 0 },
	        _canvasSize = { x: 0, y: 0 };
	
	    function loadImages() {
	        loaded = false;
	        GetPixels(baseUrl, function (err, pixels) {
	            if (err) {
	                console.log(err);
	                exit(1);
	            }
	            loaded = true;
	            console.log(pixels.shape);
	            frame = pixels;
	            width = pixels.shape[0];
	            height = pixels.shape[1];
	            calculatedWidth = _config.size ? width / height > 1 ? _config.size : Math.floor(width / height * _config.size) : width;
	            calculatedHeight = _config.size ? width / height > 1 ? Math.floor(height / width * _config.size) : _config.size : height;
	
	            _canvasSize.x = calculatedWidth;
	            _canvasSize.y = calculatedHeight;
	
	            setTimeout(function () {
	                publishEvent("canrecord", []);
	            }, 0);
	        });
	    }
	
	    function publishEvent(eventName, args) {
	        var j,
	            handlers = _eventHandlers[eventName];
	
	        if (handlers && handlers.length > 0) {
	            for (j = 0; j < handlers.length; j++) {
	                handlers[j].apply(that, args);
	            }
	        }
	    }
	
	    that.trigger = publishEvent;
	
	    that.getWidth = function () {
	        return calculatedWidth;
	    };
	
	    that.getHeight = function () {
	        return calculatedHeight;
	    };
	
	    that.setWidth = function (width) {
	        calculatedWidth = width;
	    };
	
	    that.setHeight = function (height) {
	        calculatedHeight = height;
	    };
	
	    that.getRealWidth = function () {
	        return width;
	    };
	
	    that.getRealHeight = function () {
	        return height;
	    };
	
	    that.setInputStream = function (stream) {
	        _config = stream;
	        baseUrl = _config.src;
	        size = 1;
	        loadImages();
	    };
	
	    that.ended = function () {
	        return ended;
	    };
	
	    that.setAttribute = function () {};
	
	    that.getConfig = function () {
	        return _config;
	    };
	
	    that.pause = function () {
	        paused = true;
	    };
	
	    that.play = function () {
	        paused = false;
	    };
	
	    that.setCurrentTime = function (time) {
	        frameIdx = time;
	    };
	
	    that.addEventListener = function (event, f) {
	        if (_eventNames.indexOf(event) !== -1) {
	            if (!_eventHandlers[event]) {
	                _eventHandlers[event] = [];
	            }
	            _eventHandlers[event].push(f);
	        }
	    };
	
	    that.setTopRight = function (topRight) {
	        _topRight.x = topRight.x;
	        _topRight.y = topRight.y;
	    };
	
	    that.getTopRight = function () {
	        return _topRight;
	    };
	
	    that.setCanvasSize = function (size) {
	        _canvasSize.x = size.x;
	        _canvasSize.y = size.y;
	    };
	
	    that.getCanvasSize = function () {
	        return _canvasSize;
	    };
	
	    that.getFrame = function () {
	        if (!loaded) {
	            return null;
	        }
	        return frame;
	    };
	
	    return that;
	};
	
	module.e = InputStream;

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _image_debug = __webpack_require__(10);
	
	var _image_debug2 = _interopRequireDefault(_image_debug);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function contains(codeResult, list) {
	    if (list) {
	        return list.some(function (item) {
	            return Object.keys(item).every(function (key) {
	                return item[key] === codeResult[key];
	            });
	        });
	    }
	    return false;
	}
	
	function passesFilter(codeResult, filter) {
	    if (typeof filter === 'function') {
	        return filter(codeResult);
	    }
	    return true;
	}
	
	exports.default = {
	    create: function create(config) {
	        var canvas = document.createElement("canvas"),
	            ctx = canvas.getContext("2d"),
	            results = [],
	            capacity = config.capacity || 20,
	            capture = config.capture === true;
	
	        function matchesConstraints(codeResult) {
	            return capacity && codeResult && !contains(codeResult, config.blacklist) && passesFilter(codeResult, config.filter);
	        }
	
	        return {
	            addResult: function addResult(data, imageSize, codeResult) {
	                var result = {};
	
	                if (matchesConstraints(codeResult)) {
	                    capacity--;
	                    result.codeResult = codeResult;
	                    if (capture) {
	                        canvas.width = imageSize.x;
	                        canvas.height = imageSize.y;
	                        _image_debug2.default.drawImage(data, imageSize, ctx);
	                        result.frame = canvas.toDataURL();
	                    }
	                    results.push(result);
	                }
	            },
	            getResults: function getResults() {
	                return results;
	            }
	        };
	    }
	};

/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	var vec2 = {
	    clone: __webpack_require__(7),
	    dot: __webpack_require__(31)
	};
	/**
	 * Creates a cluster for grouping similar orientations of datapoints
	 */
	exports.default = {
	    create: function create(point, threshold) {
	        var points = [],
	            center = {
	            rad: 0,
	            vec: vec2.clone([0, 0])
	        },
	            pointMap = {};
	
	        function init() {
	            _add(point);
	            updateCenter();
	        }
	
	        function _add(pointToAdd) {
	            pointMap[pointToAdd.id] = pointToAdd;
	            points.push(pointToAdd);
	        }
	
	        function updateCenter() {
	            var i,
	                sum = 0;
	            for (i = 0; i < points.length; i++) {
	                sum += points[i].rad;
	            }
	            center.rad = sum / points.length;
	            center.vec = vec2.clone([Math.cos(center.rad), Math.sin(center.rad)]);
	        }
	
	        init();
	
	        return {
	            add: function add(pointToAdd) {
	                if (!pointMap[pointToAdd.id]) {
	                    _add(pointToAdd);
	                    updateCenter();
	                }
	            },
	            fits: function fits(otherPoint) {
	                // check cosine similarity to center-angle
	                var similarity = Math.abs(vec2.dot(otherPoint.point.vec, center.vec));
	                if (similarity > threshold) {
	                    return true;
	                }
	                return false;
	            },
	            getPoints: function getPoints() {
	                return points;
	            },
	            getCenter: function getCenter() {
	                return center;
	            }
	        };
	    },
	    createPoint: function createPoint(newPoint, id, property) {
	        return {
	            rad: newPoint[property],
	            point: newPoint,
	            id: id
	        };
	    }
	};

/***/ },
/* 54 */
/***/ function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	
	exports.default = function () {
	    var events = {};
	
	    function getEvent(eventName) {
	        if (!events[eventName]) {
	            events[eventName] = {
	                subscribers: []
	            };
	        }
	        return events[eventName];
	    }
	
	    function clearEvents() {
	        events = {};
	    }
	
	    function publishSubscription(subscription, data) {
	        if (subscription.async) {
	            setTimeout(function () {
	                subscription.callback(data);
	            }, 4);
	        } else {
	            subscription.callback(data);
	        }
	    }
	
	    function _subscribe(event, callback, async) {
	        var subscription;
	
	        if (typeof callback === "function") {
	            subscription = {
	                callback: callback,
	                async: async
	            };
	        } else {
	            subscription = callback;
	            if (!subscription.callback) {
	                throw "Callback was not specified on options";
	            }
	        }
	
	        getEvent(event).subscribers.push(subscription);
	    }
	
	    return {
	        subscribe: function subscribe(event, callback, async) {
	            return _subscribe(event, callback, async);
	        },
	        publish: function publish(eventName, data) {
	            var event = getEvent(eventName),
	                subscribers = event.subscribers;
	
	            event.subscribers = subscribers.filter(function (subscriber) {
	                publishSubscription(subscriber, data);
	                return !subscriber.once;
	            });
	        },
	        once: function once(event, callback, async) {
	            _subscribe(event, {
	                callback: callback,
	                async: async,
	                once: true
	            });
	        },
	        unsubscribe: function unsubscribe(eventName, callback) {
	            var event;
	
	            if (eventName) {
	                event = getEvent(eventName);
	                if (event && callback) {
	                    event.subscribers = event.subscribers.filter(function (subscriber) {
	                        return subscriber.callback !== callback;
	                    });
	                } else {
	                    event.subscribers = [];
	                }
	            } else {
	                clearEvents();
	            }
	        }
	    };
	}();

/***/ },
/* 55 */
/***/ function(module, exports) {

	'use strict';
	
	exports.__esModule = true;
	/**
	 * Construct representing a part of another {ImageWrapper}. Shares data
	 * between the parent and the child.
	 * @param from {ImageRef} The position where to start the {SubImage} from. (top-left corner)
	 * @param size {ImageRef} The size of the resulting image
	 * @param I {ImageWrapper} The {ImageWrapper} to share from
	 * @returns {SubImage} A shared part of the original image
	 */
	function SubImage(from, size, I) {
	    if (!I) {
	        I = {
	            data: null,
	            size: size
	        };
	    }
	    this.data = I.data;
	    this.originalSize = I.size;
	    this.I = I;
	
	    this.from = from;
	    this.size = size;
	}
	
	/**
	 * Displays the {SubImage} in a given canvas
	 * @param canvas {Canvas} The canvas element to write to
	 * @param scale {Number} Scale which is applied to each pixel-value
	 */
	SubImage.prototype.show = function (canvas, scale) {
	    var ctx, frame, data, current, y, x, pixel;
	
	    if (!scale) {
	        scale = 1.0;
	    }
	    ctx = canvas.getContext('2d');
	    canvas.width = this.size.x;
	    canvas.height = this.size.y;
	    frame = ctx.getImageData(0, 0, canvas.width, canvas.height);
	    data = frame.data;
	    current = 0;
	    for (y = 0; y < this.size.y; y++) {
	        for (x = 0; x < this.size.x; x++) {
	            pixel = y * this.size.x + x;
	            current = this.get(x, y) * scale;
	            data[pixel * 4 + 0] = current;
	            data[pixel * 4 + 1] = current;
	            data[pixel * 4 + 2] = current;
	            data[pixel * 4 + 3] = 255;
	        }
	    }
	    frame.data = data;
	    ctx.putImageData(frame, 0, 0);
	};
	
	/**
	 * Retrieves a given pixel position from the {SubImage}
	 * @param x {Number} The x-position
	 * @param y {Number} The y-position
	 * @returns {Number} The grayscale value at the pixel-position
	 */
	SubImage.prototype.get = function (x, y) {
	    return this.data[(this.from.y + y) * this.originalSize.x + this.from.x + x];
	};
	
	/**
	 * Updates the underlying data from a given {ImageWrapper}
	 * @param image {ImageWrapper} The updated image
	 */
	SubImage.prototype.updateData = function (image) {
	    this.originalSize = image.size;
	    this.data = image.data;
	};
	
	/**
	 * Updates the position of the shared area
	 * @param from {x,y} The new location
	 * @returns {SubImage} returns {this} for possible chaining
	 */
	SubImage.prototype.updateFrom = function (from) {
	    this.from = from;
	    return this;
	};
	
	exports.default = SubImage;

/***/ },
/* 56 */
/***/ function(module, exports) {

	'use strict';
	
	/*
	 * typedefs.js
	 * Normalizes browser-specific prefixes
	 */
	
	if (typeof window !== 'undefined') {
	    window.requestAnimFrame = function () {
	        return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function ( /* function FrameRequestCallback */callback) {
	            window.setTimeout(callback, 1000 / 60);
	        };
	    }();
	}
	Math.imul = Math.imul || function (a, b) {
	    var ah = a >>> 16 & 0xffff,
	        al = a & 0xffff,
	        bh = b >>> 16 & 0xffff,
	        bl = b & 0xffff;
	    // the shift by 0 fixes the sign on the high part
	    // the final |0 converts the unsigned value into a signed value
	    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
	};

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	var config = void 0;
	
	if (false) {
	    config = require('./config.dev.js');
	} else if (true) {
	    config = __webpack_require__(58);
	} else {
	    config = require('./config.prod.js');
	}
	
	exports.default = config;

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	module.e = {
	    inputStream: {
	        type: "ImageStream",
	        sequence: false,
	        size: 800,
	        area: {
	            top: "0%",
	            right: "0%",
	            left: "0%",
	            bottom: "0%"
	        },
	        singleChannel: false // true: only the red color-channel is read
	    },
	    locate: true,
	    numOfWorkers: 0,
	    decoder: {
	        readers: ['code_128_reader']
	    },
	    locator: {
	        halfSample: true,
	        patchSize: "medium" // x-small, small, medium, large, x-large
	    }
	};

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };
	
	var _bresenham = __webpack_require__(60);
	
	var _bresenham2 = _interopRequireDefault(_bresenham);
	
	var _image_debug = __webpack_require__(10);
	
	var _image_debug2 = _interopRequireDefault(_image_debug);
	
	var _code_128_reader = __webpack_require__(66);
	
	var _code_128_reader2 = _interopRequireDefault(_code_128_reader);
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	var _code_39_reader = __webpack_require__(30);
	
	var _code_39_reader2 = _interopRequireDefault(_code_39_reader);
	
	var _code_39_vin_reader = __webpack_require__(67);
	
	var _code_39_vin_reader2 = _interopRequireDefault(_code_39_vin_reader);
	
	var _codabar_reader = __webpack_require__(65);
	
	var _codabar_reader2 = _interopRequireDefault(_codabar_reader);
	
	var _upc_reader = __webpack_require__(73);
	
	var _upc_reader2 = _interopRequireDefault(_upc_reader);
	
	var _ean_8_reader = __webpack_require__(70);
	
	var _ean_8_reader2 = _interopRequireDefault(_ean_8_reader);
	
	var _ean_2_reader = __webpack_require__(68);
	
	var _ean_2_reader2 = _interopRequireDefault(_ean_2_reader);
	
	var _ean_5_reader = __webpack_require__(69);
	
	var _ean_5_reader2 = _interopRequireDefault(_ean_5_reader);
	
	var _upc_e_reader = __webpack_require__(72);
	
	var _upc_e_reader2 = _interopRequireDefault(_upc_e_reader);
	
	var _i2of5_reader = __webpack_require__(71);
	
	var _i2of5_reader2 = _interopRequireDefault(_i2of5_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var READERS = {
	    code_128_reader: _code_128_reader2.default,
	    ean_reader: _ean_reader2.default,
	    ean_5_reader: _ean_5_reader2.default,
	    ean_2_reader: _ean_2_reader2.default,
	    ean_8_reader: _ean_8_reader2.default,
	    code_39_reader: _code_39_reader2.default,
	    code_39_vin_reader: _code_39_vin_reader2.default,
	    codabar_reader: _codabar_reader2.default,
	    upc_reader: _upc_reader2.default,
	    upc_e_reader: _upc_e_reader2.default,
	    i2of5_reader: _i2of5_reader2.default
	};
	exports.default = {
	    create: function create(config, inputImageWrapper) {
	        var _canvas = {
	            ctx: {
	                frequency: null,
	                pattern: null,
	                overlay: null
	            },
	            dom: {
	                frequency: null,
	                pattern: null,
	                overlay: null
	            }
	        },
	            _barcodeReaders = [];
	
	        initCanvas();
	        initReaders();
	        initConfig();
	
	        function initCanvas() {
	            if (false) {
	                var $debug = document.querySelector("#debug.detection");
	                _canvas.dom.frequency = document.querySelector("canvas.frequency");
	                if (!_canvas.dom.frequency) {
	                    _canvas.dom.frequency = document.createElement("canvas");
	                    _canvas.dom.frequency.className = "frequency";
	                    if ($debug) {
	                        $debug.appendChild(_canvas.dom.frequency);
	                    }
	                }
	                _canvas.ctx.frequency = _canvas.dom.frequency.getContext("2d");
	
	                _canvas.dom.pattern = document.querySelector("canvas.patternBuffer");
	                if (!_canvas.dom.pattern) {
	                    _canvas.dom.pattern = document.createElement("canvas");
	                    _canvas.dom.pattern.className = "patternBuffer";
	                    if ($debug) {
	                        $debug.appendChild(_canvas.dom.pattern);
	                    }
	                }
	                _canvas.ctx.pattern = _canvas.dom.pattern.getContext("2d");
	
	                _canvas.dom.overlay = document.querySelector("canvas.drawingBuffer");
	                if (_canvas.dom.overlay) {
	                    _canvas.ctx.overlay = _canvas.dom.overlay.getContext("2d");
	                }
	            }
	        }
	
	        function initReaders() {
	            config.readers.forEach(function (readerConfig) {
	                var reader,
	                    configuration = {},
	                    supplements = [];
	
	                if ((typeof readerConfig === 'undefined' ? 'undefined' : _typeof(readerConfig)) === 'object') {
	                    reader = readerConfig.format;
	                    configuration = readerConfig.config;
	                } else if (typeof readerConfig === 'string') {
	                    reader = readerConfig;
	                }
	                if (false) {
	                    console.log("Before registering reader: ", reader);
	                }
	                if (configuration.supplements) {
	                    supplements = configuration.supplements.map(function (supplement) {
	                        return new READERS[supplement]();
	                    });
	                }
	                _barcodeReaders.push(new READERS[reader](configuration, supplements));
	            });
	            if (false) {
	                console.log("Registered Readers: " + _barcodeReaders.map(function (reader) {
	                    return JSON.stringify({ format: reader.FORMAT, config: reader.config });
	                }).join(', '));
	            }
	        }
	
	        function initConfig() {
	            if (false) {
	                var i,
	                    vis = [{
	                    node: _canvas.dom.frequency,
	                    prop: config.debug.showFrequency
	                }, {
	                    node: _canvas.dom.pattern,
	                    prop: config.debug.showPattern
	                }];
	
	                for (i = 0; i < vis.length; i++) {
	                    if (vis[i].prop === true) {
	                        vis[i].node.style.display = "block";
	                    } else {
	                        vis[i].node.style.display = "none";
	                    }
	                }
	            }
	        }
	
	        /**
	         * extend the line on both ends
	         * @param {Array} line
	         * @param {Number} angle
	         */
	        function getExtendedLine(line, angle, ext) {
	            function extendLine(amount) {
	                var extension = {
	                    y: amount * Math.sin(angle),
	                    x: amount * Math.cos(angle)
	                };
	
	                line[0].y -= extension.y;
	                line[0].x -= extension.x;
	                line[1].y += extension.y;
	                line[1].x += extension.x;
	            }
	
	            // check if inside image
	            extendLine(ext);
	            while (ext > 1 && (!inputImageWrapper.inImageWithBorder(line[0], 0) || !inputImageWrapper.inImageWithBorder(line[1], 0))) {
	                ext -= Math.ceil(ext / 2);
	                extendLine(-ext);
	            }
	            return line;
	        }
	
	        function getLine(box) {
	            return [{
	                x: (box[1][0] - box[0][0]) / 2 + box[0][0],
	                y: (box[1][1] - box[0][1]) / 2 + box[0][1]
	            }, {
	                x: (box[3][0] - box[2][0]) / 2 + box[2][0],
	                y: (box[3][1] - box[2][1]) / 2 + box[2][1]
	            }];
	        }
	
	        function tryDecode(line) {
	            var result = null,
	                i,
	                barcodeLine = _bresenham2.default.getBarcodeLine(inputImageWrapper, line[0], line[1]);
	
	            if (false) {
	                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, _canvas.ctx.overlay, { color: 'red', lineWidth: 3 });
	                _bresenham2.default.debug.printFrequency(barcodeLine.line, _canvas.dom.frequency);
	            }
	
	            _bresenham2.default.toBinaryLine(barcodeLine);
	
	            if (false) {
	                _bresenham2.default.debug.printPattern(barcodeLine.line, _canvas.dom.pattern);
	            }
	
	            for (i = 0; i < _barcodeReaders.length && result === null; i++) {
	                result = _barcodeReaders[i].decodePattern(barcodeLine.line);
	            }
	            if (result === null) {
	                return null;
	            }
	            return {
	                codeResult: result,
	                barcodeLine: barcodeLine
	            };
	        }
	
	        /**
	         * This method slices the given area apart and tries to detect a barcode-pattern
	         * for each slice. It returns the decoded barcode, or null if nothing was found
	         * @param {Array} box
	         * @param {Array} line
	         * @param {Number} lineAngle
	         */
	        function tryDecodeBruteForce(box, line, lineAngle) {
	            var sideLength = Math.sqrt(Math.pow(box[1][0] - box[0][0], 2) + Math.pow(box[1][1] - box[0][1], 2)),
	                i,
	                slices = 16,
	                result = null,
	                dir,
	                extension,
	                xdir = Math.sin(lineAngle),
	                ydir = Math.cos(lineAngle);
	
	            for (i = 1; i < slices && result === null; i++) {
	                // move line perpendicular to angle
	                dir = sideLength / slices * i * (i % 2 === 0 ? -1 : 1);
	                extension = {
	                    y: dir * xdir,
	                    x: dir * ydir
	                };
	                line[0].y += extension.x;
	                line[0].x -= extension.y;
	                line[1].y += extension.x;
	                line[1].x -= extension.y;
	
	                result = tryDecode(line);
	            }
	            return result;
	        }
	
	        function getLineLength(line) {
	            return Math.sqrt(Math.pow(Math.abs(line[1].y - line[0].y), 2) + Math.pow(Math.abs(line[1].x - line[0].x), 2));
	        }
	
	        /**
	         * With the help of the configured readers (Code128 or EAN) this function tries to detect a
	         * valid barcode pattern within the given area.
	         * @param {Object} box The area to search in
	         * @returns {Object} the result {codeResult, line, angle, pattern, threshold}
	         */
	        function _decodeFromBoundingBox(box) {
	            var line,
	                lineAngle,
	                ctx = _canvas.ctx.overlay,
	                result,
	                lineLength;
	
	            if (false) {
	                if (config.debug.drawBoundingBox && ctx) {
	                    _image_debug2.default.drawPath(box, { x: 0, y: 1 }, ctx, { color: "blue", lineWidth: 2 });
	                }
	            }
	
	            line = getLine(box);
	            lineLength = getLineLength(line);
	            lineAngle = Math.atan2(line[1].y - line[0].y, line[1].x - line[0].x);
	            line = getExtendedLine(line, lineAngle, Math.floor(lineLength * 0.1));
	            if (line === null) {
	                return null;
	            }
	
	            result = tryDecode(line);
	            if (result === null) {
	                result = tryDecodeBruteForce(box, line, lineAngle);
	            }
	
	            if (result === null) {
	                return null;
	            }
	
	            if (false) {
	                _image_debug2.default.drawPath(line, { x: 'x', y: 'y' }, ctx, { color: 'red', lineWidth: 3 });
	            }
	
	            return {
	                codeResult: result.codeResult,
	                line: line,
	                angle: lineAngle,
	                pattern: result.barcodeLine.line,
	                threshold: result.barcodeLine.threshold
	            };
	        }
	
	        return {
	            decodeFromBoundingBox: function decodeFromBoundingBox(box) {
	                return _decodeFromBoundingBox(box);
	            },
	            decodeFromBoundingBoxes: function decodeFromBoundingBoxes(boxes) {
	                var i,
	                    result,
	                    barcodes = [],
	                    multiple = config.multiple;
	
	                for (i = 0; i < boxes.length; i++) {
	                    var box = boxes[i];
	                    result = _decodeFromBoundingBox(box) || {};
	                    result.box = box;
	
	                    if (multiple) {
	                        barcodes.push(result);
	                    } else if (result.codeResult) {
	                        return result;
	                    }
	                }
	
	                if (multiple) {
	                    return {
	                        barcodes: barcodes
	                    };
	                }
	            },
	            setReaders: function setReaders(readers) {
	                config.readers = readers;
	                _barcodeReaders.length = 0;
	                initReaders();
	            }
	        };
	    }
	};

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _image_wrapper = __webpack_require__(19);
	
	var _image_wrapper2 = _interopRequireDefault(_image_wrapper);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var Bresenham = {};
	
	var Slope = {
	    DIR: {
	        UP: 1,
	        DOWN: -1
	    }
	};
	/**
	 * Scans a line of the given image from point p1 to p2 and returns a result object containing
	 * gray-scale values (0-255) of the underlying pixels in addition to the min
	 * and max values.
	 * @param {Object} imageWrapper
	 * @param {Object} p1 The start point {x,y}
	 * @param {Object} p2 The end point {x,y}
	 * @returns {line, min, max}
	 */
	Bresenham.getBarcodeLine = function (imageWrapper, p1, p2) {
	    var x0 = p1.x | 0,
	        y0 = p1.y | 0,
	        x1 = p2.x | 0,
	        y1 = p2.y | 0,
	        steep = Math.abs(y1 - y0) > Math.abs(x1 - x0),
	        deltax,
	        deltay,
	        error,
	        ystep,
	        y,
	        tmp,
	        x,
	        line = [],
	        imageData = imageWrapper.data,
	        width = imageWrapper.size.x,
	        sum = 0,
	        val,
	        min = 255,
	        max = 0;
	
	    function read(a, b) {
	        val = imageData[b * width + a];
	        sum += val;
	        min = val < min ? val : min;
	        max = val > max ? val : max;
	        line.push(val);
	    }
	
	    if (steep) {
	        tmp = x0;
	        x0 = y0;
	        y0 = tmp;
	
	        tmp = x1;
	        x1 = y1;
	        y1 = tmp;
	    }
	    if (x0 > x1) {
	        tmp = x0;
	        x0 = x1;
	        x1 = tmp;
	
	        tmp = y0;
	        y0 = y1;
	        y1 = tmp;
	    }
	    deltax = x1 - x0;
	    deltay = Math.abs(y1 - y0);
	    error = deltax / 2 | 0;
	    y = y0;
	    ystep = y0 < y1 ? 1 : -1;
	    for (x = x0; x < x1; x++) {
	        if (steep) {
	            read(y, x);
	        } else {
	            read(x, y);
	        }
	        error = error - deltay;
	        if (error < 0) {
	            y = y + ystep;
	            error = error + deltax;
	        }
	    }
	
	    return {
	        line: line,
	        min: min,
	        max: max
	    };
	};
	
	/**
	 * Converts the result from getBarcodeLine into a binary representation
	 * also considering the frequency and slope of the signal for more robust results
	 * @param {Object} result {line, min, max}
	 */
	Bresenham.toBinaryLine = function (result) {
	    var min = result.min,
	        max = result.max,
	        line = result.line,
	        slope,
	        slope2,
	        center = min + (max - min) / 2,
	        extrema = [],
	        currentDir,
	        dir,
	        threshold = (max - min) / 12,
	        rThreshold = -threshold,
	        i,
	        j;
	
	    // 1. find extrema
	    currentDir = line[0] > center ? Slope.DIR.UP : Slope.DIR.DOWN;
	    extrema.push({
	        pos: 0,
	        val: line[0]
	    });
	    for (i = 0; i < line.length - 2; i++) {
	        slope = line[i + 1] - line[i];
	        slope2 = line[i + 2] - line[i + 1];
	        if (slope + slope2 < rThreshold && line[i + 1] < center * 1.5) {
	            dir = Slope.DIR.DOWN;
	        } else if (slope + slope2 > threshold && line[i + 1] > center * 0.5) {
	            dir = Slope.DIR.UP;
	        } else {
	            dir = currentDir;
	        }
	
	        if (currentDir !== dir) {
	            extrema.push({
	                pos: i,
	                val: line[i]
	            });
	            currentDir = dir;
	        }
	    }
	    extrema.push({
	        pos: line.length,
	        val: line[line.length - 1]
	    });
	
	    for (j = extrema[0].pos; j < extrema[1].pos; j++) {
	        line[j] = line[j] > center ? 0 : 1;
	    }
	
	    // iterate over extrema and convert to binary based on avg between minmax
	    for (i = 1; i < extrema.length - 1; i++) {
	        if (extrema[i + 1].val > extrema[i].val) {
	            threshold = extrema[i].val + (extrema[i + 1].val - extrema[i].val) / 3 * 2 | 0;
	        } else {
	            threshold = extrema[i + 1].val + (extrema[i].val - extrema[i + 1].val) / 3 | 0;
	        }
	
	        for (j = extrema[i].pos; j < extrema[i + 1].pos; j++) {
	            line[j] = line[j] > threshold ? 0 : 1;
	        }
	    }
	
	    return {
	        line: line,
	        threshold: threshold
	    };
	};
	
	/**
	 * Used for development only
	 */
	Bresenham.debug = {
	    printFrequency: function printFrequency(line, canvas) {
	        var i,
	            ctx = canvas.getContext("2d");
	        canvas.width = line.length;
	        canvas.height = 256;
	
	        ctx.beginPath();
	        ctx.strokeStyle = "blue";
	        for (i = 0; i < line.length; i++) {
	            ctx.moveTo(i, 255);
	            ctx.lineTo(i, 255 - line[i]);
	        }
	        ctx.stroke();
	        ctx.closePath();
	    },
	
	    printPattern: function printPattern(line, canvas) {
	        var ctx = canvas.getContext("2d"),
	            i;
	
	        canvas.width = line.length;
	        ctx.fillColor = "black";
	        for (i = 0; i < line.length; i++) {
	            if (line[i] === 1) {
	                ctx.fillRect(i, 0, 1, 100);
	            }
	        }
	    }
	};
	
	exports.default = Bresenham;

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _pick2 = __webpack_require__(144);
	
	var _pick3 = _interopRequireDefault(_pick2);
	
	var _merge2 = __webpack_require__(17);
	
	var _merge3 = _interopRequireDefault(_merge2);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var streamRef, loadedDataHandler;
	
	function waitForVideo(video) {
	    return new Promise(function (resolve, reject) {
	        var attempts = 10;
	
	        function checkVideo() {
	            if (attempts > 0) {
	                if (video.videoWidth > 0 && video.videoHeight > 0) {
	                    if (false) {
	                        console.log(video.videoWidth + "px x " + video.videoHeight + "px");
	                    }
	                    resolve();
	                } else {
	                    window.setTimeout(checkVideo, 500);
	                }
	            } else {
	                reject('Unable to play video stream. Is webcam working?');
	            }
	            attempts--;
	        }
	        checkVideo();
	    });
	}
	
	/**
	 * Tries to attach the camera-stream to a given video-element
	 * and calls the callback function when the content is ready
	 * @param {Object} constraints
	 * @param {Object} video
	 */
	function initCamera(video, constraints) {
	    return navigator.mediaDevices.getUserMedia(constraints).then(function (stream) {
	        return new Promise(function (resolve, reject) {
	            streamRef = stream;
	            video.src = window.URL.createObjectURL(stream);
	            video.onloadedmetadata = function (e) {
	                video.play();
	                resolve();
	            };
	        });
	    }).then(waitForVideo.bind(null, video));
	}
	
	function deprecatedConstraints(videoConstraints) {
	    var normalized = (0, _pick3.default)(videoConstraints, ["width", "height", "facingMode", "aspectRatio", "deviceId"]);
	
	    if (typeof videoConstraints["minAspectRatio"] !== 'undefined' && videoConstraints["minAspectRatio"] > 0) {
	        normalized["aspectRatio"] = videoConstraints["minAspectRatio"];
	        console.log("WARNING: Constraint 'minAspectRatio' is deprecated; Use 'aspectRatio' instead");
	    }
	    if (typeof videoConstraints["facing"] !== 'undefined') {
	        normalized["facingMode"] = videoConstraints["facing"];
	        console.log("WARNING: Constraint 'facing' is deprecated. Use 'facingMode' instead'");
	    }
	    return normalized;
	}
	
	function applyCameraFacing(facing, constraints) {
	    if (typeof constraints.video.deviceId !== 'undefined' || !facing) {
	        return Promise.resolve(constraints);
	    }
	    if (typeof MediaStreamTrack !== 'undefined' && typeof MediaStreamTrack.getSources !== 'undefined') {
	        return new Promise(function (resolve, reject) {
	            MediaStreamTrack.getSources(function (sourceInfos) {
	                var videoSource = sourceInfos.filter(function (sourceInfo) {
	                    return sourceInfo.kind === "video" && sourceInfo.facing === facing;
	                })[0];
	                if (videoSource) {
	                    return resolve((0, _merge3.default)({}, constraints, { video: { deviceId: videoSource.id } }));
	                }
	                return resolve(constraints);
	            });
	        });
	    }
	    return Promise.resolve((0, _merge3.default)({}, constraints, { video: { facingMode: facing } }));
	}
	
	function pickConstraints(videoConstraints) {
	    var constraints = {
	        audio: false,
	        video: deprecatedConstraints(videoConstraints)
	    };
	    return applyCameraFacing(constraints.video.facingMode, constraints);
	}
	
	exports.default = {
	    request: function request(video, videoConstraints) {
	        return pickConstraints(videoConstraints).then(initCamera.bind(null, video));
	    },
	    release: function release() {
	        var tracks = streamRef && streamRef.getVideoTracks();
	        if (tracks && tracks.length) {
	            tracks[0].stop();
	        }
	        streamRef = null;
	    }
	};

/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global) {'use strict';
	
	exports.__esModule = true;
	
	var _image_wrapper = __webpack_require__(19);
	
	var _image_wrapper2 = _interopRequireDefault(_image_wrapper);
	
	var _cv_utils = __webpack_require__(18);
	
	var _array_helper = __webpack_require__(9);
	
	var _array_helper2 = _interopRequireDefault(_array_helper);
	
	var _image_debug = __webpack_require__(10);
	
	var _image_debug2 = _interopRequireDefault(_image_debug);
	
	var _rasterizer = __webpack_require__(63);
	
	var _rasterizer2 = _interopRequireDefault(_rasterizer);
	
	var _tracer = __webpack_require__(29);
	
	var _tracer2 = _interopRequireDefault(_tracer);
	
	var _skeletonizer2 = __webpack_require__(64);
	
	var _skeletonizer3 = _interopRequireDefault(_skeletonizer2);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	var vec2 = {
	    clone: __webpack_require__(7),
	    dot: __webpack_require__(31),
	    scale: __webpack_require__(77),
	    transformMat2: __webpack_require__(78)
	};
	var mat2 = {
	    copy: __webpack_require__(74),
	    create: __webpack_require__(75),
	    invert: __webpack_require__(76)
	};
	
	var _config,
	    _currentImageWrapper,
	    _skelImageWrapper,
	    _subImageWrapper,
	    _labelImageWrapper,
	    _patchGrid,
	    _patchLabelGrid,
	    _imageToPatchGrid,
	    _binaryImageWrapper,
	    _patchSize,
	    _canvasContainer = {
	    ctx: {
	        binary: null
	    },
	    dom: {
	        binary: null
	    }
	},
	    _numPatches = { x: 0, y: 0 },
	    _inputImageWrapper,
	    _skeletonizer;
	
	function initBuffers() {
	    var skeletonImageData;
	
	    if (_config.halfSample) {
	        _currentImageWrapper = new _image_wrapper2.default({
	            x: _inputImageWrapper.size.x / 2 | 0,
	            y: _inputImageWrapper.size.y / 2 | 0
	        });
	    } else {
	        _currentImageWrapper = _inputImageWrapper;
	    }
	
	    _patchSize = (0, _cv_utils.calculatePatchSize)(_config.patchSize, _currentImageWrapper.size);
	
	    _numPatches.x = _currentImageWrapper.size.x / _patchSize.x | 0;
	    _numPatches.y = _currentImageWrapper.size.y / _patchSize.y | 0;
	
	    _binaryImageWrapper = new _image_wrapper2.default(_currentImageWrapper.size, undefined, Uint8Array, false);
	
	    _labelImageWrapper = new _image_wrapper2.default(_patchSize, undefined, Array, true);
	
	    skeletonImageData = new ArrayBuffer(64 * 1024);
	    _subImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, 0, _patchSize.x * _patchSize.y));
	    _skelImageWrapper = new _image_wrapper2.default(_patchSize, new Uint8Array(skeletonImageData, _patchSize.x * _patchSize.y * 3, _patchSize.x * _patchSize.y), undefined, true);
	    _skeletonizer = (0, _skeletonizer3.default)(typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : global, {
	        size: _patchSize.x
	    }, skeletonImageData);
	
	    _imageToPatchGrid = new _image_wrapper2.default({
	        x: _currentImageWrapper.size.x / _subImageWrapper.size.x | 0,
	        y: _currentImageWrapper.size.y / _subImageWrapper.size.y | 0
	    }, undefined, Array, true);
	    _patchGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, undefined, true);
	    _patchLabelGrid = new _image_wrapper2.default(_imageToPatchGrid.size, undefined, Int32Array, true);
	}
	
	function initCanvas() {
	    if (_config.useWorker || typeof document === 'undefined') {
	        return;
	    }
	    _canvasContainer.dom.binary = document.createElement("canvas");
	    _canvasContainer.dom.binary.className = "binaryBuffer";
	    if (false) {
	        document.querySelector("#debug").appendChild(_canvasContainer.dom.binary);
	    }
	    _canvasContainer.ctx.binary = _canvasContainer.dom.binary.getContext("2d");
	    _canvasContainer.dom.binary.width = _binaryImageWrapper.size.x;
	    _canvasContainer.dom.binary.height = _binaryImageWrapper.size.y;
	}
	
	/**
	 * Creates a bounding box which encloses all the given patches
	 * @returns {Array} The minimal bounding box
	 */
	function boxFromPatches(patches) {
	    var overAvg,
	        i,
	        j,
	        patch,
	        transMat,
	        minx = _binaryImageWrapper.size.x,
	        miny = _binaryImageWrapper.size.y,
	        maxx = -_binaryImageWrapper.size.x,
	        maxy = -_binaryImageWrapper.size.y,
	        box,
	        scale;
	
	    // draw all patches which are to be taken into consideration
	    overAvg = 0;
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        overAvg += patch.rad;
	        if (false) {
	            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "red" });
	        }
	    }
	
	    overAvg /= patches.length;
	    overAvg = (overAvg * 180 / Math.PI + 90) % 180 - 90;
	    if (overAvg < 0) {
	        overAvg += 180;
	    }
	
	    overAvg = (180 - overAvg) * Math.PI / 180;
	    transMat = mat2.copy(mat2.create(), [Math.cos(overAvg), Math.sin(overAvg), -Math.sin(overAvg), Math.cos(overAvg)]);
	
	    // iterate over patches and rotate by angle
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        for (j = 0; j < 4; j++) {
	            vec2.transformMat2(patch.box[j], patch.box[j], transMat);
	        }
	
	        if (false) {
	            _image_debug2.default.drawPath(patch.box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#99ff00', lineWidth: 2 });
	        }
	    }
	
	    // find bounding box
	    for (i = 0; i < patches.length; i++) {
	        patch = patches[i];
	        for (j = 0; j < 4; j++) {
	            if (patch.box[j][0] < minx) {
	                minx = patch.box[j][0];
	            }
	            if (patch.box[j][0] > maxx) {
	                maxx = patch.box[j][0];
	            }
	            if (patch.box[j][1] < miny) {
	                miny = patch.box[j][1];
	            }
	            if (patch.box[j][1] > maxy) {
	                maxy = patch.box[j][1];
	            }
	        }
	    }
	
	    box = [[minx, miny], [maxx, miny], [maxx, maxy], [minx, maxy]];
	
	    if (false) {
	        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
	    }
	
	    scale = _config.halfSample ? 2 : 1;
	    // reverse rotation;
	    transMat = mat2.invert(transMat, transMat);
	    for (j = 0; j < 4; j++) {
	        vec2.transformMat2(box[j], box[j], transMat);
	    }
	
	    if (false) {
	        _image_debug2.default.drawPath(box, { x: 0, y: 1 }, _canvasContainer.ctx.binary, { color: '#ff0000', lineWidth: 2 });
	    }
	
	    for (j = 0; j < 4; j++) {
	        vec2.scale(box[j], box[j], scale);
	    }
	
	    return box;
	}
	
	/**
	 * Creates a binary image of the current image
	 */
	function binarizeImage() {
	    (0, _cv_utils.otsuThreshold)(_currentImageWrapper, _binaryImageWrapper);
	    _binaryImageWrapper.zeroBorder();
	    if (false) {
	        _binaryImageWrapper.show(_canvasContainer.dom.binary, 255);
	    }
	}
	
	/**
	 * Iterate over the entire image
	 * extract patches
	 */
	function findPatches() {
	    var i,
	        j,
	        x,
	        y,
	        moments,
	        patchesFound = [],
	        rasterizer,
	        rasterResult,
	        patch;
	    for (i = 0; i < _numPatches.x; i++) {
	        for (j = 0; j < _numPatches.y; j++) {
	            x = _subImageWrapper.size.x * i;
	            y = _subImageWrapper.size.y * j;
	
	            // seperate parts
	            skeletonize(x, y);
	
	            // Rasterize, find individual bars
	            _skelImageWrapper.zeroBorder();
	            _array_helper2.default.init(_labelImageWrapper.data, 0);
	            rasterizer = _rasterizer2.default.create(_skelImageWrapper, _labelImageWrapper);
	            rasterResult = rasterizer.rasterize(0);
	
	            if (false) {
	                _labelImageWrapper.overlay(_canvasContainer.dom.binary, Math.floor(360 / rasterResult.count), { x: x, y: y });
	            }
	
	            // calculate moments from the skeletonized patch
	            moments = _labelImageWrapper.moments(rasterResult.count);
	
	            // extract eligible patches
	            patchesFound = patchesFound.concat(describePatch(moments, [i, j], x, y));
	        }
	    }
	
	    if (false) {
	        for (i = 0; i < patchesFound.length; i++) {
	            patch = patchesFound[i];
	            _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "#99ff00", lineWidth: 2 });
	        }
	    }
	
	    return patchesFound;
	}
	
	/**
	 * Finds those connected areas which contain at least 6 patches
	 * and returns them ordered DESC by the number of contained patches
	 * @param {Number} maxLabel
	 */
	function findBiggestConnectedAreas(maxLabel) {
	    var i,
	        sum,
	        labelHist = [],
	        topLabels = [];
	
	    for (i = 0; i < maxLabel; i++) {
	        labelHist.push(0);
	    }
	    sum = _patchLabelGrid.data.length;
	    while (sum--) {
	        if (_patchLabelGrid.data[sum] > 0) {
	            labelHist[_patchLabelGrid.data[sum] - 1]++;
	        }
	    }
	
	    labelHist = labelHist.map(function (val, idx) {
	        return {
	            val: val,
	            label: idx + 1
	        };
	    });
	
	    labelHist.sort(function (a, b) {
	        return b.val - a.val;
	    });
	
	    // extract top areas with at least 6 patches present
	    topLabels = labelHist.filter(function (el) {
	        return el.val >= 5;
	    });
	
	    return topLabels;
	}
	
	/**
	 *
	 */
	function findBoxes(topLabels, maxLabel) {
	    var i,
	        j,
	        sum,
	        patches = [],
	        patch,
	        box,
	        boxes = [],
	        hsv = [0, 1, 1],
	        rgb = [0, 0, 0];
	
	    for (i = 0; i < topLabels.length; i++) {
	        sum = _patchLabelGrid.data.length;
	        patches.length = 0;
	        while (sum--) {
	            if (_patchLabelGrid.data[sum] === topLabels[i].label) {
	                patch = _imageToPatchGrid.data[sum];
	                patches.push(patch);
	            }
	        }
	        box = boxFromPatches(patches);
	        if (box) {
	            boxes.push(box);
	
	            // draw patch-labels if requested
	            if (false) {
	                for (j = 0; j < patches.length; j++) {
	                    patch = patches[j];
	                    hsv[0] = topLabels[i].label / (maxLabel + 1) * 360;
	                    (0, _cv_utils.hsv2rgb)(hsv, rgb);
	                    _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
	                }
	            }
	        }
	    }
	    return boxes;
	}
	
	/**
	 * Find similar moments (via cluster)
	 * @param {Object} moments
	 */
	function similarMoments(moments) {
	    var clusters = (0, _cv_utils.cluster)(moments, 0.90);
	    var topCluster = (0, _cv_utils.topGeneric)(clusters, 1, function (e) {
	        return e.getPoints().length;
	    });
	    var points = [],
	        result = [];
	    if (topCluster.length === 1) {
	        points = topCluster[0].item.getPoints();
	        for (var i = 0; i < points.length; i++) {
	            result.push(points[i].point);
	        }
	    }
	    return result;
	}
	
	function skeletonize(x, y) {
	    _binaryImageWrapper.subImageAsCopy(_subImageWrapper, (0, _cv_utils.imageRef)(x, y));
	    _skeletonizer.skeletonize();
	
	    // Show skeleton if requested
	    if (false) {
	        _skelImageWrapper.overlay(_canvasContainer.dom.binary, 360, (0, _cv_utils.imageRef)(x, y));
	    }
	}
	
	/**
	 * Extracts and describes those patches which seem to contain a barcode pattern
	 * @param {Array} moments
	 * @param {Object} patchPos,
	 * @param {Number} x
	 * @param {Number} y
	 * @returns {Array} list of patches
	 */
	function describePatch(moments, patchPos, x, y) {
	    var k,
	        avg,
	        eligibleMoments = [],
	        matchingMoments,
	        patch,
	        patchesFound = [],
	        minComponentWeight = Math.ceil(_patchSize.x / 3);
	
	    if (moments.length >= 2) {
	        // only collect moments which's area covers at least minComponentWeight pixels.
	        for (k = 0; k < moments.length; k++) {
	            if (moments[k].m00 > minComponentWeight) {
	                eligibleMoments.push(moments[k]);
	            }
	        }
	
	        // if at least 2 moments are found which have at least minComponentWeights covered
	        if (eligibleMoments.length >= 2) {
	            matchingMoments = similarMoments(eligibleMoments);
	            avg = 0;
	            // determine the similarity of the moments
	            for (k = 0; k < matchingMoments.length; k++) {
	                avg += matchingMoments[k].rad;
	            }
	
	            // Only two of the moments are allowed not to fit into the equation
	            // add the patch to the set
	            if (matchingMoments.length > 1 && matchingMoments.length >= eligibleMoments.length / 4 * 3 && matchingMoments.length > moments.length / 4) {
	                avg /= matchingMoments.length;
	                patch = {
	                    index: patchPos[1] * _numPatches.x + patchPos[0],
	                    pos: {
	                        x: x,
	                        y: y
	                    },
	                    box: [vec2.clone([x, y]), vec2.clone([x + _subImageWrapper.size.x, y]), vec2.clone([x + _subImageWrapper.size.x, y + _subImageWrapper.size.y]), vec2.clone([x, y + _subImageWrapper.size.y])],
	                    moments: matchingMoments,
	                    rad: avg,
	                    vec: vec2.clone([Math.cos(avg), Math.sin(avg)])
	                };
	                patchesFound.push(patch);
	            }
	        }
	    }
	    return patchesFound;
	}
	
	/**
	 * finds patches which are connected and share the same orientation
	 * @param {Object} patchesFound
	 */
	function rasterizeAngularSimilarity(patchesFound) {
	    var label = 0,
	        threshold = 0.95,
	        currIdx = 0,
	        j,
	        patch,
	        hsv = [0, 1, 1],
	        rgb = [0, 0, 0];
	
	    function notYetProcessed() {
	        var i;
	        for (i = 0; i < _patchLabelGrid.data.length; i++) {
	            if (_patchLabelGrid.data[i] === 0 && _patchGrid.data[i] === 1) {
	                return i;
	            }
	        }
	        return _patchLabelGrid.length;
	    }
	
	    function trace(currentIdx) {
	        var x,
	            y,
	            currentPatch,
	            idx,
	            dir,
	            current = {
	            x: currentIdx % _patchLabelGrid.size.x,
	            y: currentIdx / _patchLabelGrid.size.x | 0
	        },
	            similarity;
	
	        if (currentIdx < _patchLabelGrid.data.length) {
	            currentPatch = _imageToPatchGrid.data[currentIdx];
	            // assign label
	            _patchLabelGrid.data[currentIdx] = label;
	            for (dir = 0; dir < _tracer2.default.searchDirections.length; dir++) {
	                y = current.y + _tracer2.default.searchDirections[dir][0];
	                x = current.x + _tracer2.default.searchDirections[dir][1];
	                idx = y * _patchLabelGrid.size.x + x;
	
	                // continue if patch empty
	                if (_patchGrid.data[idx] === 0) {
	                    _patchLabelGrid.data[idx] = Number.MAX_VALUE;
	                    continue;
	                }
	
	                if (_patchLabelGrid.data[idx] === 0) {
	                    similarity = Math.abs(vec2.dot(_imageToPatchGrid.data[idx].vec, currentPatch.vec));
	                    if (similarity > threshold) {
	                        trace(idx);
	                    }
	                }
	            }
	        }
	    }
	
	    // prepare for finding the right patches
	    _array_helper2.default.init(_patchGrid.data, 0);
	    _array_helper2.default.init(_patchLabelGrid.data, 0);
	    _array_helper2.default.init(_imageToPatchGrid.data, null);
	
	    for (j = 0; j < patchesFound.length; j++) {
	        patch = patchesFound[j];
	        _imageToPatchGrid.data[patch.index] = patch;
	        _patchGrid.data[patch.index] = 1;
	    }
	
	    // rasterize the patches found to determine area
	    _patchGrid.zeroBorder();
	
	    while ((currIdx = notYetProcessed()) < _patchLabelGrid.data.length) {
	        label++;
	        trace(currIdx);
	    }
	
	    // draw patch-labels if requested
	    if (false) {
	        for (j = 0; j < _patchLabelGrid.data.length; j++) {
	            if (_patchLabelGrid.data[j] > 0 && _patchLabelGrid.data[j] <= label) {
	                patch = _imageToPatchGrid.data[j];
	                hsv[0] = _patchLabelGrid.data[j] / (label + 1) * 360;
	                (0, _cv_utils.hsv2rgb)(hsv, rgb);
	                _image_debug2.default.drawRect(patch.pos, _subImageWrapper.size, _canvasContainer.ctx.binary, { color: "rgb(" + rgb.join(",") + ")", lineWidth: 2 });
	            }
	        }
	    }
	
	    return label;
	}
	
	exports.default = {
	    init: function init(inputImageWrapper, config) {
	        _config = config;
	        _inputImageWrapper = inputImageWrapper;
	
	        initBuffers();
	        initCanvas();
	    },
	
	    locate: function locate() {
	        var patchesFound, topLabels, boxes;
	
	        if (_config.halfSample) {
	            (0, _cv_utils.halfSample)(_inputImageWrapper, _currentImageWrapper);
	        }
	
	        binarizeImage();
	        patchesFound = findPatches();
	        // return unless 5% or more patches are found
	        if (patchesFound.length < _numPatches.x * _numPatches.y * 0.05) {
	            return null;
	        }
	
	        // rasterrize area by comparing angular similarity;
	        var maxLabel = rasterizeAngularSimilarity(patchesFound);
	        if (maxLabel < 1) {
	            return null;
	        }
	
	        // search for area with the most patches (biggest connected area)
	        topLabels = findBiggestConnectedAreas(maxLabel);
	        if (topLabels.length === 0) {
	            return null;
	        }
	
	        boxes = findBoxes(topLabels, maxLabel);
	        return boxes;
	    },
	
	    checkImageConstraints: function checkImageConstraints(inputStream, config) {
	        var patchSize,
	            width = inputStream.getWidth(),
	            height = inputStream.getHeight(),
	            halfSample = config.halfSample ? 0.5 : 1,
	            size,
	            area;
	
	        // calculate width and height based on area
	        if (inputStream.getConfig().area) {
	            area = (0, _cv_utils.computeImageArea)(width, height, inputStream.getConfig().area);
	            inputStream.setTopRight({ x: area.sx, y: area.sy });
	            inputStream.setCanvasSize({ x: width, y: height });
	            width = area.sw;
	            height = area.sh;
	        }
	
	        size = {
	            x: Math.floor(width * halfSample),
	            y: Math.floor(height * halfSample)
	        };
	
	        patchSize = (0, _cv_utils.calculatePatchSize)(config.patchSize, size);
	        if (false) {
	            console.log("Patch-Size: " + JSON.stringify(patchSize));
	        }
	
	        inputStream.setWidth(Math.floor(Math.floor(size.x / patchSize.x) * (1 / halfSample) * patchSize.x));
	        inputStream.setHeight(Math.floor(Math.floor(size.y / patchSize.y) * (1 / halfSample) * patchSize.y));
	
	        if (inputStream.getWidth() % patchSize.x === 0 && inputStream.getHeight() % patchSize.y === 0) {
	            return true;
	        }
	
	        throw new Error("Image dimensions do not comply with the current settings: Width (" + width + " )and height (" + height + ") must a multiple of " + patchSize.x);
	    }
	};
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _tracer = __webpack_require__(29);
	
	var _tracer2 = _interopRequireDefault(_tracer);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	/**
	 * http://www.codeproject.com/Tips/407172/Connected-Component-Labeling-and-Vectorization
	 */
	var Rasterizer = {
	    createContour2D: function createContour2D() {
	        return {
	            dir: null,
	            index: null,
	            firstVertex: null,
	            insideContours: null,
	            nextpeer: null,
	            prevpeer: null
	        };
	    },
	    CONTOUR_DIR: {
	        CW_DIR: 0,
	        CCW_DIR: 1,
	        UNKNOWN_DIR: 2
	    },
	    DIR: {
	        OUTSIDE_EDGE: -32767,
	        INSIDE_EDGE: -32766
	    },
	    create: function create(imageWrapper, labelWrapper) {
	        var imageData = imageWrapper.data,
	            labelData = labelWrapper.data,
	            width = imageWrapper.size.x,
	            height = imageWrapper.size.y,
	            tracer = _tracer2.default.create(imageWrapper, labelWrapper);
	
	        return {
	            rasterize: function rasterize(depthlabel) {
	                var color,
	                    bc,
	                    lc,
	                    labelindex,
	                    cx,
	                    cy,
	                    colorMap = [],
	                    vertex,
	                    p,
	                    cc,
	                    sc,
	                    pos,
	                    connectedCount = 0,
	                    i;
	
	                for (i = 0; i < 400; i++) {
	                    colorMap[i] = 0;
	                }
	
	                colorMap[0] = imageData[0];
	                cc = null;
	                for (cy = 1; cy < height - 1; cy++) {
	                    labelindex = 0;
	                    bc = colorMap[0];
	                    for (cx = 1; cx < width - 1; cx++) {
	                        pos = cy * width + cx;
	                        if (labelData[pos] === 0) {
	                            color = imageData[pos];
	                            if (color !== bc) {
	                                if (labelindex === 0) {
	                                    lc = connectedCount + 1;
	                                    colorMap[lc] = color;
	                                    bc = color;
	                                    vertex = tracer.contourTracing(cy, cx, lc, color, Rasterizer.DIR.OUTSIDE_EDGE);
	                                    if (vertex !== null) {
	                                        connectedCount++;
	                                        labelindex = lc;
	                                        p = Rasterizer.createContour2D();
	                                        p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
	                                        p.index = labelindex;
	                                        p.firstVertex = vertex;
	                                        p.nextpeer = cc;
	                                        p.insideContours = null;
	                                        if (cc !== null) {
	                                            cc.prevpeer = p;
	                                        }
	                                        cc = p;
	                                    }
	                                } else {
	                                    vertex = tracer.contourTracing(cy, cx, Rasterizer.DIR.INSIDE_EDGE, color, labelindex);
	                                    if (vertex !== null) {
	                                        p = Rasterizer.createContour2D();
	                                        p.firstVertex = vertex;
	                                        p.insideContours = null;
	                                        if (depthlabel === 0) {
	                                            p.dir = Rasterizer.CONTOUR_DIR.CCW_DIR;
	                                        } else {
	                                            p.dir = Rasterizer.CONTOUR_DIR.CW_DIR;
	                                        }
	                                        p.index = depthlabel;
	                                        sc = cc;
	                                        while (sc !== null && sc.index !== labelindex) {
	                                            sc = sc.nextpeer;
	                                        }
	                                        if (sc !== null) {
	                                            p.nextpeer = sc.insideContours;
	                                            if (sc.insideContours !== null) {
	                                                sc.insideContours.prevpeer = p;
	                                            }
	                                            sc.insideContours = p;
	                                        }
	                                    }
	                                }
	                            } else {
	                                labelData[pos] = labelindex;
	                            }
	                        } else if (labelData[pos] === Rasterizer.DIR.OUTSIDE_EDGE || labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
	                            labelindex = 0;
	                            if (labelData[pos] === Rasterizer.DIR.INSIDE_EDGE) {
	                                bc = imageData[pos];
	                            } else {
	                                bc = colorMap[0];
	                            }
	                        } else {
	                            labelindex = labelData[pos];
	                            bc = colorMap[labelindex];
	                        }
	                    }
	                }
	                sc = cc;
	                while (sc !== null) {
	                    sc.index = depthlabel;
	                    sc = sc.nextpeer;
	                }
	                return {
	                    cc: cc,
	                    count: connectedCount
	                };
	            },
	            debug: {
	                drawContour: function drawContour(canvas, firstContour) {
	                    var ctx = canvas.getContext("2d"),
	                        pq = firstContour,
	                        iq,
	                        q,
	                        p;
	
	                    ctx.strokeStyle = "red";
	                    ctx.fillStyle = "red";
	                    ctx.lineWidth = 1;
	
	                    if (pq !== null) {
	                        iq = pq.insideContours;
	                    } else {
	                        iq = null;
	                    }
	
	                    while (pq !== null) {
	                        if (iq !== null) {
	                            q = iq;
	                            iq = iq.nextpeer;
	                        } else {
	                            q = pq;
	                            pq = pq.nextpeer;
	                            if (pq !== null) {
	                                iq = pq.insideContours;
	                            } else {
	                                iq = null;
	                            }
	                        }
	
	                        switch (q.dir) {
	                            case Rasterizer.CONTOUR_DIR.CW_DIR:
	                                ctx.strokeStyle = "red";
	                                break;
	                            case Rasterizer.CONTOUR_DIR.CCW_DIR:
	                                ctx.strokeStyle = "blue";
	                                break;
	                            case Rasterizer.CONTOUR_DIR.UNKNOWN_DIR:
	                                ctx.strokeStyle = "green";
	                                break;
	                        }
	
	                        p = q.firstVertex;
	                        ctx.beginPath();
	                        ctx.moveTo(p.x, p.y);
	                        do {
	                            p = p.next;
	                            ctx.lineTo(p.x, p.y);
	                        } while (p !== q.firstVertex);
	                        ctx.stroke();
	                    }
	                }
	            }
	        };
	    }
	};
	
	exports.default = Rasterizer;

/***/ },
/* 64 */
/***/ function(module, exports) {

	"use strict";
	
	exports.__esModule = true;
	/* @preserve ASM BEGIN */
	/* eslint-disable eqeqeq*/
	function Skeletonizer(stdlib, foreign, buffer) {
	    "use asm";
	
	    var images = new stdlib.Uint8Array(buffer),
	        size = foreign.size | 0,
	        imul = stdlib.Math.imul;
	
	    function erode(inImagePtr, outImagePtr) {
	        inImagePtr = inImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var v = 0,
	            u = 0,
	            sum = 0,
	            yStart1 = 0,
	            yStart2 = 0,
	            xStart1 = 0,
	            xStart2 = 0,
	            offset = 0;
	
	        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
	            offset = offset + size | 0;
	            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
	                yStart1 = offset - size | 0;
	                yStart2 = offset + size | 0;
	                xStart1 = u - 1 | 0;
	                xStart2 = u + 1 | 0;
	                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
	                if ((sum | 0) == (5 | 0)) {
	                    images[outImagePtr + offset + u | 0] = 1;
	                } else {
	                    images[outImagePtr + offset + u | 0] = 0;
	                }
	            }
	        }
	        return;
	    }
	
	    function subtract(aImagePtr, bImagePtr, outImagePtr) {
	        aImagePtr = aImagePtr | 0;
	        bImagePtr = bImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[outImagePtr + length | 0] = (images[aImagePtr + length | 0] | 0) - (images[bImagePtr + length | 0] | 0) | 0;
	        }
	    }
	
	    function bitwiseOr(aImagePtr, bImagePtr, outImagePtr) {
	        aImagePtr = aImagePtr | 0;
	        bImagePtr = bImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[outImagePtr + length | 0] = images[aImagePtr + length | 0] | 0 | (images[bImagePtr + length | 0] | 0) | 0;
	        }
	    }
	
	    function countNonZero(imagePtr) {
	        imagePtr = imagePtr | 0;
	
	        var sum = 0,
	            length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            sum = (sum | 0) + (images[imagePtr + length | 0] | 0) | 0;
	        }
	
	        return sum | 0;
	    }
	
	    function init(imagePtr, value) {
	        imagePtr = imagePtr | 0;
	        value = value | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[imagePtr + length | 0] = value;
	        }
	    }
	
	    function dilate(inImagePtr, outImagePtr) {
	        inImagePtr = inImagePtr | 0;
	        outImagePtr = outImagePtr | 0;
	
	        var v = 0,
	            u = 0,
	            sum = 0,
	            yStart1 = 0,
	            yStart2 = 0,
	            xStart1 = 0,
	            xStart2 = 0,
	            offset = 0;
	
	        for (v = 1; (v | 0) < (size - 1 | 0); v = v + 1 | 0) {
	            offset = offset + size | 0;
	            for (u = 1; (u | 0) < (size - 1 | 0); u = u + 1 | 0) {
	                yStart1 = offset - size | 0;
	                yStart2 = offset + size | 0;
	                xStart1 = u - 1 | 0;
	                xStart2 = u + 1 | 0;
	                sum = (images[inImagePtr + yStart1 + xStart1 | 0] | 0) + (images[inImagePtr + yStart1 + xStart2 | 0] | 0) + (images[inImagePtr + offset + u | 0] | 0) + (images[inImagePtr + yStart2 + xStart1 | 0] | 0) + (images[inImagePtr + yStart2 + xStart2 | 0] | 0) | 0;
	                if ((sum | 0) > (0 | 0)) {
	                    images[outImagePtr + offset + u | 0] = 1;
	                } else {
	                    images[outImagePtr + offset + u | 0] = 0;
	                }
	            }
	        }
	        return;
	    }
	
	    function memcpy(srcImagePtr, dstImagePtr) {
	        srcImagePtr = srcImagePtr | 0;
	        dstImagePtr = dstImagePtr | 0;
	
	        var length = 0;
	
	        length = imul(size, size) | 0;
	
	        while ((length | 0) > 0) {
	            length = length - 1 | 0;
	            images[dstImagePtr + length | 0] = images[srcImagePtr + length | 0] | 0;
	        }
	    }
	
	    function zeroBorder(imagePtr) {
	        imagePtr = imagePtr | 0;
	
	        var x = 0,
	            y = 0;
	
	        for (x = 0; (x | 0) < (size - 1 | 0); x = x + 1 | 0) {
	            images[imagePtr + x | 0] = 0;
	            images[imagePtr + y | 0] = 0;
	            y = y + size - 1 | 0;
	            images[imagePtr + y | 0] = 0;
	            y = y + 1 | 0;
	        }
	        for (x = 0; (x | 0) < (size | 0); x = x + 1 | 0) {
	            images[imagePtr + y | 0] = 0;
	            y = y + 1 | 0;
	        }
	    }
	
	    function skeletonize() {
	        var subImagePtr = 0,
	            erodedImagePtr = 0,
	            tempImagePtr = 0,
	            skelImagePtr = 0,
	            sum = 0,
	            done = 0;
	
	        erodedImagePtr = imul(size, size) | 0;
	        tempImagePtr = erodedImagePtr + erodedImagePtr | 0;
	        skelImagePtr = tempImagePtr + erodedImagePtr | 0;
	
	        // init skel-image
	        init(skelImagePtr, 0);
	        zeroBorder(subImagePtr);
	
	        do {
	            erode(subImagePtr, erodedImagePtr);
	            dilate(erodedImagePtr, tempImagePtr);
	            subtract(subImagePtr, tempImagePtr, tempImagePtr);
	            bitwiseOr(skelImagePtr, tempImagePtr, skelImagePtr);
	            memcpy(erodedImagePtr, subImagePtr);
	            sum = countNonZero(subImagePtr) | 0;
	            done = (sum | 0) == 0 | 0;
	        } while (!done);
	    }
	    return {
	        skeletonize: skeletonize
	    };
	}
	/* @preserve ASM END */
	exports.default = Skeletonizer;
	/* eslint-enable eqeqeq*/

/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _barcode_reader = __webpack_require__(6);
	
	var _barcode_reader2 = _interopRequireDefault(_barcode_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function CodabarReader() {
	    _barcode_reader2.default.call(this);
	    this._counters = [];
	}
	
	var properties = {
	    ALPHABETH_STRING: { value: "0123456789-$:/.+ABCD" },
	    ALPHABET: { value: [48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 36, 58, 47, 46, 43, 65, 66, 67, 68] },
	    CHARACTER_ENCODINGS: { value: [0x003, 0x006, 0x009, 0x060, 0x012, 0x042, 0x021, 0x024, 0x030, 0x048, 0x00c, 0x018, 0x045, 0x051, 0x054, 0x015, 0x01A, 0x029, 0x00B, 0x00E] },
	    START_END: { value: [0x01A, 0x029, 0x00B, 0x00E] },
	    MIN_ENCODED_CHARS: { value: 4 },
	    MAX_ACCEPTABLE: { value: 2.0 },
	    PADDING: { value: 1.5 },
	    FORMAT: { value: "codabar", writeable: false }
	};
	
	CodabarReader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
	CodabarReader.prototype.constructor = CodabarReader;
	
	CodabarReader.prototype._decode = function () {
	    var self = this,
	        result = [],
	        start,
	        decodedChar,
	        pattern,
	        nextStart,
	        end;
	
	    this._counters = self._fillCounters();
	    start = self._findStart();
	    if (!start) {
	        return null;
	    }
	    nextStart = start.startCounter;
	
	    do {
	        pattern = self._toPattern(nextStart);
	        if (pattern < 0) {
	            return null;
	        }
	        decodedChar = self._patternToChar(pattern);
	        if (decodedChar < 0) {
	            return null;
	        }
	        result.push(decodedChar);
	        nextStart += 8;
	        if (result.length > 1 && self._isStartEnd(pattern)) {
	            break;
	        }
	    } while (nextStart < self._counters.length);
	
	    // verify end
	    if (result.length - 2 < self.MIN_ENCODED_CHARS || !self._isStartEnd(pattern)) {
	        return null;
	    }
	
	    // verify end white space
	    if (!self._verifyWhitespace(start.startCounter, nextStart - 8)) {
	        return null;
	    }
	
	    if (!self._validateResult(result, start.startCounter)) {
	        return null;
	    }
	
	    nextStart = nextStart > self._counters.length ? self._counters.length : nextStart;
	    end = start.start + self._sumCounters(start.startCounter, nextStart - 8);
	
	    return {
	        code: result.join(""),
	        start: start.start,
	        end: end,
	        startInfo: start,
	        decodedCodes: result
	    };
	};
	
	CodabarReader.prototype._verifyWhitespace = function (startCounter, endCounter) {
	    if (startCounter - 1 <= 0 || this._counters[startCounter - 1] >= this._calculatePatternLength(startCounter) / 2.0) {
	        if (endCounter + 8 >= this._counters.length || this._counters[endCounter + 7] >= this._calculatePatternLength(endCounter) / 2.0) {
	            return true;
	        }
	    }
	    return false;
	};
	
	CodabarReader.prototype._calculatePatternLength = function (offset) {
	    var i,
	        sum = 0;
	
	    for (i = offset; i < offset + 7; i++) {
	        sum += this._counters[i];
	    }
	
	    return sum;
	};
	
	CodabarReader.prototype._thresholdResultPattern = function (result, startCounter) {
	    var self = this,
	        categorization = {
	        space: {
	            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
	            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
	        },
	        bar: {
	            narrow: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE },
	            wide: { size: 0, counts: 0, min: 0, max: Number.MAX_VALUE }
	        }
	    },
	        kind,
	        cat,
	        i,
	        j,
	        pos = startCounter,
	        pattern;
	
	    for (i = 0; i < result.length; i++) {
	        pattern = self._charToPattern(result[i]);
	        for (j = 6; j >= 0; j--) {
	            kind = (j & 1) === 2 ? categorization.bar : categorization.space;
	            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
	            cat.size += self._counters[pos + j];
	            cat.counts++;
	            pattern >>= 1;
	        }
	        pos += 8;
	    }
	
	    ["space", "bar"].forEach(function (key) {
	        var newkind = categorization[key];
	        newkind.wide.min = Math.floor((newkind.narrow.size / newkind.narrow.counts + newkind.wide.size / newkind.wide.counts) / 2);
	        newkind.narrow.max = Math.ceil(newkind.wide.min);
	        newkind.wide.max = Math.ceil((newkind.wide.size * self.MAX_ACCEPTABLE + self.PADDING) / newkind.wide.counts);
	    });
	
	    return categorization;
	};
	
	CodabarReader.prototype._charToPattern = function (char) {
	    var self = this,
	        charCode = char.charCodeAt(0),
	        i;
	
	    for (i = 0; i < self.ALPHABET.length; i++) {
	        if (self.ALPHABET[i] === charCode) {
	            return self.CHARACTER_ENCODINGS[i];
	        }
	    }
	    return 0x0;
	};
	
	CodabarReader.prototype._validateResult = function (result, startCounter) {
	    var self = this,
	        thresholds = self._thresholdResultPattern(result, startCounter),
	        i,
	        j,
	        kind,
	        cat,
	        size,
	        pos = startCounter,
	        pattern;
	
	    for (i = 0; i < result.length; i++) {
	        pattern = self._charToPattern(result[i]);
	        for (j = 6; j >= 0; j--) {
	            kind = (j & 1) === 0 ? thresholds.bar : thresholds.space;
	            cat = (pattern & 1) === 1 ? kind.wide : kind.narrow;
	            size = self._counters[pos + j];
	            if (size < cat.min || size > cat.max) {
	                return false;
	            }
	            pattern >>= 1;
	        }
	        pos += 8;
	    }
	    return true;
	};
	
	CodabarReader.prototype._patternToChar = function (pattern) {
	    var i,
	        self = this;
	
	    for (i = 0; i < self.CHARACTER_ENCODINGS.length; i++) {
	        if (self.CHARACTER_ENCODINGS[i] === pattern) {
	            return String.fromCharCode(self.ALPHABET[i]);
	        }
	    }
	    return -1;
	};
	
	CodabarReader.prototype._computeAlternatingThreshold = function (offset, end) {
	    var i,
	        min = Number.MAX_VALUE,
	        max = 0,
	        counter;
	
	    for (i = offset; i < end; i += 2) {
	        counter = this._counters[i];
	        if (counter > max) {
	            max = counter;
	        }
	        if (counter < min) {
	            min = counter;
	        }
	    }
	
	    return (min + max) / 2.0 | 0;
	};
	
	CodabarReader.prototype._toPattern = function (offset) {
	    var numCounters = 7,
	        end = offset + numCounters,
	        barThreshold,
	        spaceThreshold,
	        bitmask = 1 << numCounters - 1,
	        pattern = 0,
	        i,
	        threshold;
	
	    if (end > this._counters.length) {
	        return -1;
	    }
	
	    barThreshold = this._computeAlternatingThreshold(offset, end);
	    spaceThreshold = this._computeAlternatingThreshold(offset + 1, end);
	
	    for (i = 0; i < numCounters; i++) {
	        threshold = (i & 1) === 0 ? barThreshold : spaceThreshold;
	        if (this._counters[offset + i] > threshold) {
	            pattern |= bitmask;
	        }
	        bitmask >>= 1;
	    }
	
	    return pattern;
	};
	
	CodabarReader.prototype._isStartEnd = function (pattern) {
	    var i;
	
	    for (i = 0; i < this.START_END.length; i++) {
	        if (this.START_END[i] === pattern) {
	            return true;
	        }
	    }
	    return false;
	};
	
	CodabarReader.prototype._sumCounters = function (start, end) {
	    var i,
	        sum = 0;
	
	    for (i = start; i < end; i++) {
	        sum += this._counters[i];
	    }
	    return sum;
	};
	
	CodabarReader.prototype._findStart = function () {
	    var self = this,
	        i,
	        pattern,
	        start = self._nextUnset(self._row),
	        end;
	
	    for (i = 1; i < this._counters.length; i++) {
	        pattern = self._toPattern(i);
	        if (pattern !== -1 && self._isStartEnd(pattern)) {
	            // TODO: Look for whitespace ahead
	            start += self._sumCounters(0, i);
	            end = start + self._sumCounters(i, i + 8);
	            return {
	                start: start,
	                end: end,
	                startCounter: i,
	                endCounter: i + 8
	            };
	        }
	    }
	};
	
	exports.default = CodabarReader;

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _barcode_reader = __webpack_require__(6);
	
	var _barcode_reader2 = _interopRequireDefault(_barcode_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function Code128Reader() {
	    _barcode_reader2.default.call(this);
	}
	
	var properties = {
	    CODE_SHIFT: { value: 98 },
	    CODE_C: { value: 99 },
	    CODE_B: { value: 100 },
	    CODE_A: { value: 101 },
	    START_CODE_A: { value: 103 },
	    START_CODE_B: { value: 104 },
	    START_CODE_C: { value: 105 },
	    STOP_CODE: { value: 106 },
	    CODE_PATTERN: { value: [[2, 1, 2, 2, 2, 2], [2, 2, 2, 1, 2, 2], [2, 2, 2, 2, 2, 1], [1, 2, 1, 2, 2, 3], [1, 2, 1, 3, 2, 2], [1, 3, 1, 2, 2, 2], [1, 2, 2, 2, 1, 3], [1, 2, 2, 3, 1, 2], [1, 3, 2, 2, 1, 2], [2, 2, 1, 2, 1, 3], [2, 2, 1, 3, 1, 2], [2, 3, 1, 2, 1, 2], [1, 1, 2, 2, 3, 2], [1, 2, 2, 1, 3, 2], [1, 2, 2, 2, 3, 1], [1, 1, 3, 2, 2, 2], [1, 2, 3, 1, 2, 2], [1, 2, 3, 2, 2, 1], [2, 2, 3, 2, 1, 1], [2, 2, 1, 1, 3, 2], [2, 2, 1, 2, 3, 1], [2, 1, 3, 2, 1, 2], [2, 2, 3, 1, 1, 2], [3, 1, 2, 1, 3, 1], [3, 1, 1, 2, 2, 2], [3, 2, 1, 1, 2, 2], [3, 2, 1, 2, 2, 1], [3, 1, 2, 2, 1, 2], [3, 2, 2, 1, 1, 2], [3, 2, 2, 2, 1, 1], [2, 1, 2, 1, 2, 3], [2, 1, 2, 3, 2, 1], [2, 3, 2, 1, 2, 1], [1, 1, 1, 3, 2, 3], [1, 3, 1, 1, 2, 3], [1, 3, 1, 3, 2, 1], [1, 1, 2, 3, 1, 3], [1, 3, 2, 1, 1, 3], [1, 3, 2, 3, 1, 1], [2, 1, 1, 3, 1, 3], [2, 3, 1, 1, 1, 3], [2, 3, 1, 3, 1, 1], [1, 1, 2, 1, 3, 3], [1, 1, 2, 3, 3, 1], [1, 3, 2, 1, 3, 1], [1, 1, 3, 1, 2, 3], [1, 1, 3, 3, 2, 1], [1, 3, 3, 1, 2, 1], [3, 1, 3, 1, 2, 1], [2, 1, 1, 3, 3, 1], [2, 3, 1, 1, 3, 1], [2, 1, 3, 1, 1, 3], [2, 1, 3, 3, 1, 1], [2, 1, 3, 1, 3, 1], [3, 1, 1, 1, 2, 3], [3, 1, 1, 3, 2, 1], [3, 3, 1, 1, 2, 1], [3, 1, 2, 1, 1, 3], [3, 1, 2, 3, 1, 1], [3, 3, 2, 1, 1, 1], [3, 1, 4, 1, 1, 1], [2, 2, 1, 4, 1, 1], [4, 3, 1, 1, 1, 1], [1, 1, 1, 2, 2, 4], [1, 1, 1, 4, 2, 2], [1, 2, 1, 1, 2, 4], [1, 2, 1, 4, 2, 1], [1, 4, 1, 1, 2, 2], [1, 4, 1, 2, 2, 1], [1, 1, 2, 2, 1, 4], [1, 1, 2, 4, 1, 2], [1, 2, 2, 1, 1, 4], [1, 2, 2, 4, 1, 1], [1, 4, 2, 1, 1, 2], [1, 4, 2, 2, 1, 1], [2, 4, 1, 2, 1, 1], [2, 2, 1, 1, 1, 4], [4, 1, 3, 1, 1, 1], [2, 4, 1, 1, 1, 2], [1, 3, 4, 1, 1, 1], [1, 1, 1, 2, 4, 2], [1, 2, 1, 1, 4, 2], [1, 2, 1, 2, 4, 1], [1, 1, 4, 2, 1, 2], [1, 2, 4, 1, 1, 2], [1, 2, 4, 2, 1, 1], [4, 1, 1, 2, 1, 2], [4, 2, 1, 1, 1, 2], [4, 2, 1, 2, 1, 1], [2, 1, 2, 1, 4, 1], [2, 1, 4, 1, 2, 1], [4, 1, 2, 1, 2, 1], [1, 1, 1, 1, 4, 3], [1, 1, 1, 3, 4, 1], [1, 3, 1, 1, 4, 1], [1, 1, 4, 1, 1, 3], [1, 1, 4, 3, 1, 1], [4, 1, 1, 1, 1, 3], [4, 1, 1, 3, 1, 1], [1, 1, 3, 1, 4, 1], [1, 1, 4, 1, 3, 1], [3, 1, 1, 1, 4, 1], [4, 1, 1, 1, 3, 1], [2, 1, 1, 4, 1, 2], [2, 1, 1, 2, 1, 4], [2, 1, 1, 2, 3, 2], [2, 3, 3, 1, 1, 1, 2]] },
	    SINGLE_CODE_ERROR: { value: 0.64 },
	    AVG_CODE_ERROR: { value: 0.30 },
	    FORMAT: { value: "code_128", writeable: false },
	    MODULE_INDICES: { value: { bar: [0, 2, 4], space: [1, 3, 5] } }
	};
	
	Code128Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
	Code128Reader.prototype.constructor = Code128Reader;
	
	Code128Reader.prototype._decodeCode = function (start, correction) {
	    var counter = [0, 0, 0, 0, 0, 0],
	        i,
	        self = this,
	        offset = start,
	        isWhite = !self._row[offset],
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: start,
	        end: start,
	        correction: {
	            bar: 1,
	            space: 1
	        }
	    },
	        code,
	        error;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                if (correction) {
	                    self._correct(counter, correction);
	                }
	                for (code = 0; code < self.CODE_PATTERN.length; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                bestMatch.end = i;
	                if (bestMatch.code === -1 || bestMatch.error > self.AVG_CODE_ERROR) {
	                    return null;
	                }
	                if (self.CODE_PATTERN[bestMatch.code]) {
	                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
	                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
	                }
	                return bestMatch;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	Code128Reader.prototype._correct = function (counter, correction) {
	    this._correctBars(counter, correction.bar, this.MODULE_INDICES.bar);
	    this._correctBars(counter, correction.space, this.MODULE_INDICES.space);
	};
	
	Code128Reader.prototype._findStart = function () {
	    var counter = [0, 0, 0, 0, 0, 0],
	        i,
	        self = this,
	        offset = self._nextSet(self._row),
	        isWhite = false,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0,
	        correction: {
	            bar: 1,
	            space: 1
	        }
	    },
	        code,
	        error,
	        j,
	        sum;
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                for (code = self.START_CODE_A; code <= self.START_CODE_C; code++) {
	                    error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	                    if (error < bestMatch.error) {
	                        bestMatch.code = code;
	                        bestMatch.error = error;
	                    }
	                }
	                if (bestMatch.error < self.AVG_CODE_ERROR) {
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    bestMatch.correction.bar = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.bar);
	                    bestMatch.correction.space = calculateCorrection(self.CODE_PATTERN[bestMatch.code], counter, this.MODULE_INDICES.space);
	                    return bestMatch;
	                }
	
	                for (j = 0; j < 4; j++) {
	                    counter[j] = counter[j + 2];
	                }
	                counter[4] = 0;
	                counter[5] = 0;
	                counterPos--;
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	Code128Reader.prototype._decode = function () {
	    var self = this,
	        startInfo = self._findStart(),
	        code = null,
	        done = false,
	        result = [],
	        multiplier = 0,
	        checksum = 0,
	        codeset,
	        rawResult = [],
	        decodedCodes = [],
	        shiftNext = false,
	        unshift,
	        removeLastCharacter = true;
	
	    if (startInfo === null) {
	        return null;
	    }
	    code = {
	        code: startInfo.code,
	        start: startInfo.start,
	        end: startInfo.end,
	        correction: {
	            bar: startInfo.correction.bar,
	            space: startInfo.correction.space
	        }
	    };
	    decodedCodes.push(code);
	    checksum = code.code;
	    switch (code.code) {
	        case self.START_CODE_A:
	            codeset = self.CODE_A;
	            break;
	        case self.START_CODE_B:
	            codeset = self.CODE_B;
	            break;
	        case self.START_CODE_C:
	            codeset = self.CODE_C;
	            break;
	        default:
	            return null;
	    }
	
	    while (!done) {
	        unshift = shiftNext;
	        shiftNext = false;
	        code = self._decodeCode(code.end, code.correction);
	        if (code !== null) {
	            if (code.code !== self.STOP_CODE) {
	                removeLastCharacter = true;
	            }
	
	            if (code.code !== self.STOP_CODE) {
	                rawResult.push(code.code);
	                multiplier++;
	                checksum += multiplier * code.code;
	            }
	            decodedCodes.push(code);
	
	            switch (codeset) {
	                case self.CODE_A:
	                    if (code.code < 64) {
	                        result.push(String.fromCharCode(32 + code.code));
	                    } else if (code.code < 96) {
	                        result.push(String.fromCharCode(code.code - 64));
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_SHIFT:
	                                shiftNext = true;
	                                codeset = self.CODE_B;
	                                break;
	                            case self.CODE_B:
	                                codeset = self.CODE_B;
	                                break;
	                            case self.CODE_C:
	                                codeset = self.CODE_C;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	                case self.CODE_B:
	                    if (code.code < 96) {
	                        result.push(String.fromCharCode(32 + code.code));
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_SHIFT:
	                                shiftNext = true;
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_A:
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_C:
	                                codeset = self.CODE_C;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	                case self.CODE_C:
	                    if (code.code < 100) {
	                        result.push(code.code < 10 ? "0" + code.code : code.code);
	                    } else {
	                        if (code.code !== self.STOP_CODE) {
	                            removeLastCharacter = false;
	                        }
	                        switch (code.code) {
	                            case self.CODE_A:
	                                codeset = self.CODE_A;
	                                break;
	                            case self.CODE_B:
	                                codeset = self.CODE_B;
	                                break;
	                            case self.STOP_CODE:
	                                done = true;
	                                break;
	                        }
	                    }
	                    break;
	            }
	        } else {
	            done = true;
	        }
	        if (unshift) {
	            codeset = codeset === self.CODE_A ? self.CODE_B : self.CODE_A;
	        }
	    }
	
	    if (code === null) {
	        return null;
	    }
	
	    code.end = self._nextUnset(self._row, code.end);
	    if (!self._verifyTrailingWhitespace(code)) {
	        return null;
	    }
	
	    checksum -= multiplier * rawResult[rawResult.length - 1];
	    if (checksum % 103 !== rawResult[rawResult.length - 1]) {
	        return null;
	    }
	
	    if (!result.length) {
	        return null;
	    }
	
	    // remove last code from result (checksum)
	    if (removeLastCharacter) {
	        result.splice(result.length - 1, 1);
	    }
	
	    return {
	        code: result.join(""),
	        start: startInfo.start,
	        end: code.end,
	        codeset: codeset,
	        startInfo: startInfo,
	        decodedCodes: decodedCodes,
	        endInfo: code
	    };
	};
	
	_barcode_reader2.default.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	function calculateCorrection(expected, normalized, indices) {
	    var length = indices.length,
	        sumNormalized = 0,
	        sumExpected = 0;
	
	    while (length--) {
	        sumExpected += expected[indices[length]];
	        sumNormalized += normalized[indices[length]];
	    }
	    return sumExpected / sumNormalized;
	}
	
	exports.default = Code128Reader;

/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _code_39_reader = __webpack_require__(30);
	
	var _code_39_reader2 = _interopRequireDefault(_code_39_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function Code39VINReader() {
	    _code_39_reader2.default.call(this);
	}
	
	var patterns = {
	    IOQ: /[IOQ]/g,
	    AZ09: /[A-Z0-9]{17}/
	};
	
	Code39VINReader.prototype = Object.create(_code_39_reader2.default.prototype);
	Code39VINReader.prototype.constructor = Code39VINReader;
	
	// Cribbed from:
	// https://github.com/zxing/zxing/blob/master/core/src/main/java/com/google/zxing/client/result/VINResultParser.java
	Code39VINReader.prototype._decode = function () {
	    var result = _code_39_reader2.default.prototype._decode.apply(this);
	    if (!result) {
	        return null;
	    }
	
	    var code = result.code;
	
	    if (!code) {
	        return null;
	    }
	
	    code = code.replace(patterns.IOQ, '');
	
	    if (!code.match(patterns.AZ09)) {
	        if (false) {
	            console.log('Failed AZ09 pattern code:', code);
	        }
	        return null;
	    }
	
	    if (!this._checkChecksum(code)) {
	        return null;
	    }
	
	    result.code = code;
	    return result;
	};
	
	Code39VINReader.prototype._checkChecksum = function (code) {
	    // TODO
	    return !!code;
	};
	
	exports.default = Code39VINReader;

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function EAN2Reader() {
	    _ean_reader2.default.call(this);
	}
	
	var properties = {
	    FORMAT: { value: "ean_2", writeable: false }
	};
	
	EAN2Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
	EAN2Reader.prototype.constructor = EAN2Reader;
	
	EAN2Reader.prototype.decode = function (row, start) {
	    this._row = row;
	    var counters = [0, 0, 0, 0],
	        codeFrequency = 0,
	        i = 0,
	        offset = start,
	        end = this._row.length,
	        code,
	        result = [],
	        decodedCodes = [];
	
	    for (i = 0; i < 2 && offset < end; i++) {
	        code = this._decodeCode(offset);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code % 10);
	        if (code.code >= this.CODE_G_START) {
	            codeFrequency |= 1 << 1 - i;
	        }
	        if (i != 1) {
	            offset = this._nextSet(this._row, code.end);
	            offset = this._nextUnset(this._row, offset);
	        }
	    }
	
	    if (result.length != 2 || parseInt(result.join("")) % 4 !== codeFrequency) {
	        return null;
	    }
	    return {
	        code: result.join(""),
	        decodedCodes: decodedCodes,
	        end: code.end
	    };
	};
	
	exports.default = EAN2Reader;

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function EAN5Reader() {
	    _ean_reader2.default.call(this);
	}
	
	var properties = {
	    FORMAT: { value: "ean_5", writeable: false }
	};
	
	var CHECK_DIGIT_ENCODINGS = [24, 20, 18, 17, 12, 6, 3, 10, 9, 5];
	
	EAN5Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
	EAN5Reader.prototype.constructor = EAN5Reader;
	
	EAN5Reader.prototype.decode = function (row, start) {
	    this._row = row;
	    var counters = [0, 0, 0, 0],
	        codeFrequency = 0,
	        i = 0,
	        offset = start,
	        end = this._row.length,
	        code,
	        result = [],
	        decodedCodes = [];
	
	    for (i = 0; i < 5 && offset < end; i++) {
	        code = this._decodeCode(offset);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code % 10);
	        if (code.code >= this.CODE_G_START) {
	            codeFrequency |= 1 << 4 - i;
	        }
	        if (i != 4) {
	            offset = this._nextSet(this._row, code.end);
	            offset = this._nextUnset(this._row, offset);
	        }
	    }
	
	    if (result.length != 5) {
	        return null;
	    }
	
	    if (extensionChecksum(result) !== determineCheckDigit(codeFrequency)) {
	        return null;
	    }
	    return {
	        code: result.join(""),
	        decodedCodes: decodedCodes,
	        end: code.end
	    };
	};
	
	function determineCheckDigit(codeFrequency) {
	    var i;
	    for (i = 0; i < 10; i++) {
	        if (codeFrequency === CHECK_DIGIT_ENCODINGS[i]) {
	            return i;
	        }
	    }
	    return null;
	}
	
	function extensionChecksum(result) {
	    var length = result.length,
	        sum = 0,
	        i;
	
	    for (i = length - 2; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    for (i = length - 1; i >= 0; i -= 2) {
	        sum += result[i];
	    }
	    sum *= 3;
	    return sum % 10;
	}
	
	exports.default = EAN5Reader;

/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function EAN8Reader(opts, supplements) {
	    _ean_reader2.default.call(this, opts, supplements);
	}
	
	var properties = {
	    FORMAT: { value: "ean_8", writeable: false }
	};
	
	EAN8Reader.prototype = Object.create(_ean_reader2.default.prototype, properties);
	EAN8Reader.prototype.constructor = EAN8Reader;
	
	EAN8Reader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this;
	
	    for (i = 0; i < 4; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	
	    code = self._findPattern(self.MIDDLE_PATTERN, code.end, true, false);
	    if (code === null) {
	        return null;
	    }
	    decodedCodes.push(code);
	
	    for (i = 0; i < 4; i++) {
	        code = self._decodeCode(code.end, self.CODE_G_START);
	        if (!code) {
	            return null;
	        }
	        decodedCodes.push(code);
	        result.push(code.code);
	    }
	
	    return code;
	};
	
	exports.default = EAN8Reader;

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.__esModule = true;
	
	var _merge2 = __webpack_require__(17);
	
	var _merge3 = _interopRequireDefault(_merge2);
	
	var _barcode_reader = __webpack_require__(6);
	
	var _barcode_reader2 = _interopRequireDefault(_barcode_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function I2of5Reader(opts) {
	    opts = (0, _merge3.default)(getDefaulConfig(), opts);
	    _barcode_reader2.default.call(this, opts);
	    this.barSpaceRatio = [1, 1];
	    if (opts.normalizeBarSpaceWidth) {
	        this.SINGLE_CODE_ERROR = 0.38;
	        this.AVG_CODE_ERROR = 0.09;
	    }
	}
	
	function getDefaulConfig() {
	    var config = {};
	
	    Object.keys(I2of5Reader.CONFIG_KEYS).forEach(function (key) {
	        config[key] = I2of5Reader.CONFIG_KEYS[key].default;
	    });
	    return config;
	}
	
	var N = 1,
	    W = 3,
	    properties = {
	    START_PATTERN: { value: [N, N, N, N] },
	    STOP_PATTERN: { value: [N, N, W] },
	    CODE_PATTERN: { value: [[N, N, W, W, N], [W, N, N, N, W], [N, W, N, N, W], [W, W, N, N, N], [N, N, W, N, W], [W, N, W, N, N], [N, W, W, N, N], [N, N, N, W, W], [W, N, N, W, N], [N, W, N, W, N]] },
	    SINGLE_CODE_ERROR: { value: 0.78, writable: true },
	    AVG_CODE_ERROR: { value: 0.38, writable: true },
	    MAX_CORRECTION_FACTOR: { value: 5 },
	    FORMAT: { value: "i2of5" }
	};
	
	I2of5Reader.prototype = Object.create(_barcode_reader2.default.prototype, properties);
	I2of5Reader.prototype.constructor = I2of5Reader;
	
	I2of5Reader.prototype._matchPattern = function (counter, code) {
	    if (this.config.normalizeBarSpaceWidth) {
	        var i,
	            counterSum = [0, 0],
	            codeSum = [0, 0],
	            correction = [0, 0],
	            correctionRatio = this.MAX_CORRECTION_FACTOR,
	            correctionRatioInverse = 1 / correctionRatio;
	
	        for (i = 0; i < counter.length; i++) {
	            counterSum[i % 2] += counter[i];
	            codeSum[i % 2] += code[i];
	        }
	        correction[0] = codeSum[0] / counterSum[0];
	        correction[1] = codeSum[1] / counterSum[1];
	
	        correction[0] = Math.max(Math.min(correction[0], correctionRatio), correctionRatioInverse);
	        correction[1] = Math.max(Math.min(correction[1], correctionRatio), correctionRatioInverse);
	        this.barSpaceRatio = correction;
	        for (i = 0; i < counter.length; i++) {
	            counter[i] *= this.barSpaceRatio[i % 2];
	        }
	    }
	    return _barcode_reader2.default.prototype._matchPattern.call(this, counter, code);
	};
	
	I2of5Reader.prototype._findPattern = function (pattern, offset, isWhite, tryHarder) {
	    var counter = [],
	        self = this,
	        i,
	        counterPos = 0,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    },
	        error,
	        j,
	        sum,
	        normalized,
	        epsilon = self.AVG_CODE_ERROR;
	
	    isWhite = isWhite || false;
	    tryHarder = tryHarder || false;
	
	    if (!offset) {
	        offset = self._nextSet(self._row);
	    }
	
	    for (i = 0; i < pattern.length; i++) {
	        counter[i] = 0;
	    }
	
	    for (i = offset; i < self._row.length; i++) {
	        if (self._row[i] ^ isWhite) {
	            counter[counterPos]++;
	        } else {
	            if (counterPos === counter.length - 1) {
	                sum = 0;
	                for (j = 0; j < counter.length; j++) {
	                    sum += counter[j];
	                }
	                error = self._matchPattern(counter, pattern);
	                if (error < epsilon) {
	                    bestMatch.error = error;
	                    bestMatch.start = i - sum;
	                    bestMatch.end = i;
	                    return bestMatch;
	                }
	                if (tryHarder) {
	                    for (j = 0; j < counter.length - 2; j++) {
	                        counter[j] = counter[j + 2];
	                    }
	                    counter[counter.length - 2] = 0;
	                    counter[counter.length - 1] = 0;
	                    counterPos--;
	                } else {
	                    return null;
	                }
	            } else {
	                counterPos++;
	            }
	            counter[counterPos] = 1;
	            isWhite = !isWhite;
	        }
	    }
	    return null;
	};
	
	I2of5Reader.prototype._findStart = function () {
	    var self = this,
	        leadingWhitespaceStart,
	        offset = self._nextSet(self._row),
	        startInfo,
	        narrowBarWidth = 1;
	
	    while (!startInfo) {
	        startInfo = self._findPattern(self.START_PATTERN, offset, false, true);
	        if (!startInfo) {
	            return null;
	        }
	        narrowBarWidth = Math.floor((startInfo.end - startInfo.start) / 4);
	        leadingWhitespaceStart = startInfo.start - narrowBarWidth * 10;
	        if (leadingWhitespaceStart >= 0) {
	            if (self._matchRange(leadingWhitespaceStart, startInfo.start, 0)) {
	                return startInfo;
	            }
	        }
	        offset = startInfo.end;
	        startInfo = null;
	    }
	};
	
	I2of5Reader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	    return null;
	};
	
	I2of5Reader.prototype._findEnd = function () {
	    var self = this,
	        endInfo,
	        tmp;
	
	    self._row.reverse();
	    endInfo = self._findPattern(self.STOP_PATTERN);
	    self._row.reverse();
	
	    if (endInfo === null) {
	        return null;
	    }
	
	    // reverse numbers
	    tmp = endInfo.start;
	    endInfo.start = self._row.length - endInfo.end;
	    endInfo.end = self._row.length - tmp;
	
	    return endInfo !== null ? self._verifyTrailingWhitespace(endInfo) : null;
	};
	
	I2of5Reader.prototype._decodePair = function (counterPair) {
	    var i,
	        code,
	        codes = [],
	        self = this;
	
	    for (i = 0; i < counterPair.length; i++) {
	        code = self._decodeCode(counterPair[i]);
	        if (!code) {
	            return null;
	        }
	        codes.push(code);
	    }
	    return codes;
	};
	
	I2of5Reader.prototype._decodeCode = function (counter) {
	    var j,
	        self = this,
	        sum = 0,
	        normalized,
	        error,
	        epsilon = self.AVG_CODE_ERROR,
	        code,
	        bestMatch = {
	        error: Number.MAX_VALUE,
	        code: -1,
	        start: 0,
	        end: 0
	    };
	
	    for (j = 0; j < counter.length; j++) {
	        sum += counter[j];
	    }
	    for (code = 0; code < self.CODE_PATTERN.length; code++) {
	        error = self._matchPattern(counter, self.CODE_PATTERN[code]);
	        if (error < bestMatch.error) {
	            bestMatch.code = code;
	            bestMatch.error = error;
	        }
	    }
	    if (bestMatch.error < epsilon) {
	        return bestMatch;
	    }
	};
	
	I2of5Reader.prototype._decodePayload = function (counters, result, decodedCodes) {
	    var i,
	        self = this,
	        pos = 0,
	        counterLength = counters.length,
	        counterPair = [[0, 0, 0, 0, 0], [0, 0, 0, 0, 0]],
	        codes;
	
	    while (pos < counterLength) {
	        for (i = 0; i < 5; i++) {
	            counterPair[0][i] = counters[pos] * this.barSpaceRatio[0];
	            counterPair[1][i] = counters[pos + 1] * this.barSpaceRatio[1];
	            pos += 2;
	        }
	        codes = self._decodePair(counterPair);
	        if (!codes) {
	            return null;
	        }
	        for (i = 0; i < codes.length; i++) {
	            result.push(codes[i].code + "");
	            decodedCodes.push(codes[i]);
	        }
	    }
	    return codes;
	};
	
	I2of5Reader.prototype._verifyCounterLength = function (counters) {
	    return counters.length % 10 === 0;
	};
	
	I2of5Reader.prototype._decode = function () {
	    var startInfo,
	        endInfo,
	        self = this,
	        code,
	        result = [],
	        decodedCodes = [],
	        counters;
	
	    startInfo = self._findStart();
	    if (!startInfo) {
	        return null;
	    }
	    decodedCodes.push(startInfo);
	
	    endInfo = self._findEnd();
	    if (!endInfo) {
	        return null;
	    }
	
	    counters = self._fillCounters(startInfo.end, endInfo.start, false);
	    if (!self._verifyCounterLength(counters)) {
	        return null;
	    }
	    code = self._decodePayload(counters, result, decodedCodes);
	    if (!code) {
	        return null;
	    }
	    if (result.length % 2 !== 0 || result.length < 6) {
	        return null;
	    }
	
	    decodedCodes.push(endInfo);
	    return {
	        code: result.join(""),
	        start: startInfo.start,
	        end: endInfo.end,
	        startInfo: startInfo,
	        decodedCodes: decodedCodes
	    };
	};
	
	I2of5Reader.CONFIG_KEYS = {
	    normalizeBarSpaceWidth: {
	        'type': 'boolean',
	        'default': false,
	        'description': 'If true, the reader tries to normalize the' + 'width-difference between bars and spaces'
	    }
	};
	
	exports.default = I2of5Reader;

/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function UPCEReader(opts, supplements) {
	    _ean_reader2.default.call(this, opts, supplements);
	}
	
	var properties = {
	    CODE_FREQUENCY: { value: [[56, 52, 50, 49, 44, 38, 35, 42, 41, 37], [7, 11, 13, 14, 19, 25, 28, 21, 22, 26]] },
	    STOP_PATTERN: { value: [1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7, 1 / 6 * 7] },
	    FORMAT: { value: "upc_e", writeable: false }
	};
	
	UPCEReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
	UPCEReader.prototype.constructor = UPCEReader;
	
	UPCEReader.prototype._decodePayload = function (code, result, decodedCodes) {
	    var i,
	        self = this,
	        codeFrequency = 0x0;
	
	    for (i = 0; i < 6; i++) {
	        code = self._decodeCode(code.end);
	        if (!code) {
	            return null;
	        }
	        if (code.code >= self.CODE_G_START) {
	            code.code = code.code - self.CODE_G_START;
	            codeFrequency |= 1 << 5 - i;
	        }
	        result.push(code.code);
	        decodedCodes.push(code);
	    }
	    if (!self._determineParity(codeFrequency, result)) {
	        return null;
	    }
	
	    return code;
	};
	
	UPCEReader.prototype._determineParity = function (codeFrequency, result) {
	    var i, nrSystem;
	
	    for (nrSystem = 0; nrSystem < this.CODE_FREQUENCY.length; nrSystem++) {
	        for (i = 0; i < this.CODE_FREQUENCY[nrSystem].length; i++) {
	            if (codeFrequency === this.CODE_FREQUENCY[nrSystem][i]) {
	                result.unshift(nrSystem);
	                result.push(i);
	                return true;
	            }
	        }
	    }
	    return false;
	};
	
	UPCEReader.prototype._convertToUPCA = function (result) {
	    var upca = [result[0]],
	        lastDigit = result[result.length - 2];
	
	    if (lastDigit <= 2) {
	        upca = upca.concat(result.slice(1, 3)).concat([lastDigit, 0, 0, 0, 0]).concat(result.slice(3, 6));
	    } else if (lastDigit === 3) {
	        upca = upca.concat(result.slice(1, 4)).concat([0, 0, 0, 0, 0]).concat(result.slice(4, 6));
	    } else if (lastDigit === 4) {
	        upca = upca.concat(result.slice(1, 5)).concat([0, 0, 0, 0, 0, result[5]]);
	    } else {
	        upca = upca.concat(result.slice(1, 6)).concat([0, 0, 0, 0, lastDigit]);
	    }
	
	    upca.push(result[result.length - 1]);
	    return upca;
	};
	
	UPCEReader.prototype._checksum = function (result) {
	    return _ean_reader2.default.prototype._checksum.call(this, this._convertToUPCA(result));
	};
	
	UPCEReader.prototype._findEnd = function (offset, isWhite) {
	    isWhite = true;
	    return _ean_reader2.default.prototype._findEnd.call(this, offset, isWhite);
	};
	
	UPCEReader.prototype._verifyTrailingWhitespace = function (endInfo) {
	    var self = this,
	        trailingWhitespaceEnd;
	
	    trailingWhitespaceEnd = endInfo.end + (endInfo.end - endInfo.start) / 2;
	    if (trailingWhitespaceEnd < self._row.length) {
	        if (self._matchRange(endInfo.end, trailingWhitespaceEnd, 0)) {
	            return endInfo;
	        }
	    }
	};
	
	exports.default = UPCEReader;

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	exports.__esModule = true;
	
	var _ean_reader = __webpack_require__(3);
	
	var _ean_reader2 = _interopRequireDefault(_ean_reader);
	
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
	
	function UPCReader(opts, supplements) {
	    _ean_reader2.default.call(this, opts, supplements);
	}
	
	var properties = {
	    FORMAT: { value: "upc_a", writeable: false }
	};
	
	UPCReader.prototype = Object.create(_ean_reader2.default.prototype, properties);
	UPCReader.prototype.constructor = UPCReader;
	
	UPCReader.prototype._decode = function () {
	    var result = _ean_reader2.default.prototype._decode.call(this);
	
	    if (result && result.code && result.code.length === 13 && result.code.charAt(0) === "0") {
	        result.code = result.code.substring(1);
	        return result;
	    }
	    return null;
	};
	
	exports.default = UPCReader;

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	module.e = copy
	
	/**
	 * Copy the values from one mat2 to another
	 *
	 * @alias mat2.copy
	 * @param {mat2} out the receiving matrix
	 * @param {mat2} a the source matrix
	 * @returns {mat2} out
	 */
	function copy(out, a) {
	  out[0] = a[0]
	  out[1] = a[1]
	  out[2] = a[2]
	  out[3] = a[3]
	  return out
	}


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	module.e = create
	
	/**
	 * Creates a new identity mat2
	 *
	 * @alias mat2.create
	 * @returns {mat2} a new 2x2 matrix
	 */
	function create() {
	  var out = new Float32Array(4)
	  out[0] = 1
	  out[1] = 0
	  out[2] = 0
	  out[3] = 1
	  return out
	}


/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	module.e = invert
	
	/**
	 * Inverts a mat2
	 *
	 * @alias mat2.invert
	 * @param {mat2} out the receiving matrix
	 * @param {mat2} a the source matrix
	 * @returns {mat2} out
	 */
	function invert(out, a) {
	  var a0 = a[0]
	  var a1 = a[1]
	  var a2 = a[2]
	  var a3 = a[3]
	  var det = a0 * a3 - a2 * a1
	
	  if (!det) return null
	  det = 1.0 / det
	
	  out[0] =  a3 * det
	  out[1] = -a1 * det
	  out[2] = -a2 * det
	  out[3] =  a0 * det
	
	  return out
	}


/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	module.e = scale
	
	/**
	 * Scales a vec2 by a scalar number
	 *
	 * @param {vec2} out the receiving vector
	 * @param {vec2} a the vector to scale
	 * @param {Number} b amount to scale the vector by
	 * @returns {vec2} out
	 */
	function scale(out, a, b) {
	    out[0] = a[0] * b
	    out[1] = a[1] * b
	    return out
	}

/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	module.e = transformMat2
	
	/**
	 * Transforms the vec2 with a mat2
	 *
	 * @param {vec2} out the receiving vector
	 * @param {vec2} a the vector to transform
	 * @param {mat2} m matrix to transform with
	 * @returns {vec2} out
	 */
	function transformMat2(out, a, m) {
	    var x = a[0],
	        y = a[1]
	    out[0] = m[0] * x + m[2] * y
	    out[1] = m[1] * x + m[3] * y
	    return out
	}

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	module.e = clone;
	
	/**
	 * Creates a new vec3 initialized with values from an existing vector
	 *
	 * @param {vec3} a vector to clone
	 * @returns {vec3} a new 3D vector
	 */
	function clone(a) {
	    var out = new Float32Array(3)
	    out[0] = a[0]
	    out[1] = a[1]
	    out[2] = a[2]
	    return out
	}

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Creates an hash object.
	 *
	 * @private
	 * @constructor
	 * @returns {Object} Returns the new hash object.
	 */
	function Hash() {}
	
	// Avoid inheriting from `Object.prototype` when possible.
	Hash.prototype = nativeCreate ? nativeCreate(null) : objectProto;
	
	module.e = Hash;


/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	var mapClear = __webpack_require__(127),
	    mapDelete = __webpack_require__(128),
	    mapGet = __webpack_require__(129),
	    mapHas = __webpack_require__(130),
	    mapSet = __webpack_require__(131);
	
	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [values] The values to cache.
	 */
	function MapCache(values) {
	  var index = -1,
	      length = values ? values.length : 0;
	
	  this.clear();
	  while (++index < length) {
	    var entry = values[index];
	    this.set(entry[0], entry[1]);
	  }
	}
	
	// Add functions to the `MapCache`.
	MapCache.prototype.clear = mapClear;
	MapCache.prototype['delete'] = mapDelete;
	MapCache.prototype.get = mapGet;
	MapCache.prototype.has = mapHas;
	MapCache.prototype.set = mapSet;
	
	module.e = MapCache;


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Reflect = root.Reflect;
	
	module.e = Reflect;


/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var Set = getNative(root, 'Set');
	
	module.e = Set;


/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Symbol = root.Symbol;
	
	module.e = Symbol;


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	var root = __webpack_require__(1);
	
	/** Built-in value references. */
	var Uint8Array = root.Uint8Array;
	
	module.e = Uint8Array;


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	var getNative = __webpack_require__(12),
	    root = __webpack_require__(1);
	
	/* Built-in method references that are verified to be native. */
	var WeakMap = getNative(root, 'WeakMap');
	
	module.e = WeakMap;


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Adds the key-value `pair` to `map`.
	 *
	 * @private
	 * @param {Object} map The map to modify.
	 * @param {Array} pair The key-value pair to add.
	 * @returns {Object} Returns `map`.
	 */
	function addMapEntry(map, pair) {
	  // Don't return `Map#set` because it doesn't return the map instance in IE 11.
	  map.set(pair[0], pair[1]);
	  return map;
	}
	
	module.e = addMapEntry;


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Adds `value` to `set`.
	 *
	 * @private
	 * @param {Object} set The set to modify.
	 * @param {*} value The value to add.
	 * @returns {Object} Returns `set`.
	 */
	function addSetEntry(set, value) {
	  set.add(value);
	  return set;
	}
	
	module.e = addSetEntry;


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * A faster alternative to `Function#apply`, this function invokes `func`
	 * with the `this` binding of `thisArg` and the arguments of `args`.
	 *
	 * @private
	 * @param {Function} func The function to invoke.
	 * @param {*} thisArg The `this` binding of `func`.
	 * @param {...*} args The arguments to invoke `func` with.
	 * @returns {*} Returns the result of `func`.
	 */
	function apply(func, thisArg, args) {
	  var length = args.length;
	  switch (length) {
	    case 0: return func.call(thisArg);
	    case 1: return func.call(thisArg, args[0]);
	    case 2: return func.call(thisArg, args[0], args[1]);
	    case 3: return func.call(thisArg, args[0], args[1], args[2]);
	  }
	  return func.apply(thisArg, args);
	}
	
	module.e = apply;


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Appends the elements of `values` to `array`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {Array} values The values to append.
	 * @returns {Array} Returns `array`.
	 */
	function arrayPush(array, values) {
	  var index = -1,
	      length = values.length,
	      offset = array.length;
	
	  while (++index < length) {
	    array[offset + index] = values[index];
	  }
	  return array;
	}
	
	module.e = arrayPush;


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    keys = __webpack_require__(45);
	
	/**
	 * The base implementation of `_.assign` without support for multiple sources
	 * or `customizer` functions.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @returns {Object} Returns `object`.
	 */
	function baseAssign(object, source) {
	  return object && copyObject(source, keys(source), object);
	}
	
	module.e = baseAssign;


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	var Stack = __webpack_require__(32),
	    arrayEach = __webpack_require__(33),
	    assignValue = __webpack_require__(35),
	    baseAssign = __webpack_require__(91),
	    baseForOwn = __webpack_require__(96),
	    cloneBuffer = __webpack_require__(106),
	    copyArray = __webpack_require__(41),
	    copySymbols = __webpack_require__(113),
	    getTag = __webpack_require__(118),
	    initCloneArray = __webpack_require__(122),
	    initCloneByTag = __webpack_require__(123),
	    initCloneObject = __webpack_require__(124),
	    isArray = __webpack_require__(5),
	    isBuffer = __webpack_require__(140),
	    isHostObject = __webpack_require__(22),
	    isObject = __webpack_require__(2);
	
	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    symbolTag = '[object Symbol]',
	    weakMapTag = '[object WeakMap]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/** Used to identify `toStringTag` values supported by `_.clone`. */
	var cloneableTags = {};
	cloneableTags[argsTag] = cloneableTags[arrayTag] =
	cloneableTags[arrayBufferTag] = cloneableTags[boolTag] =
	cloneableTags[dateTag] = cloneableTags[float32Tag] =
	cloneableTags[float64Tag] = cloneableTags[int8Tag] =
	cloneableTags[int16Tag] = cloneableTags[int32Tag] =
	cloneableTags[mapTag] = cloneableTags[numberTag] =
	cloneableTags[objectTag] = cloneableTags[regexpTag] =
	cloneableTags[setTag] = cloneableTags[stringTag] =
	cloneableTags[symbolTag] = cloneableTags[uint8Tag] =
	cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] =
	cloneableTags[uint32Tag] = true;
	cloneableTags[errorTag] = cloneableTags[funcTag] =
	cloneableTags[weakMapTag] = false;
	
	/**
	 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
	 * traversed objects.
	 *
	 * @private
	 * @param {*} value The value to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @param {boolean} [isFull] Specify a clone including symbols.
	 * @param {Function} [customizer] The function to customize cloning.
	 * @param {string} [key] The key of `value`.
	 * @param {Object} [object] The parent object of `value`.
	 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
	 * @returns {*} Returns the cloned value.
	 */
	function baseClone(value, isDeep, isFull, customizer, key, object, stack) {
	  var result;
	  if (customizer) {
	    result = object ? customizer(value, key, object, stack) : customizer(value);
	  }
	  if (result !== undefined) {
	    return result;
	  }
	  if (!isObject(value)) {
	    return value;
	  }
	  var isArr = isArray(value);
	  if (isArr) {
	    result = initCloneArray(value);
	    if (!isDeep) {
	      return copyArray(value, result);
	    }
	  } else {
	    var tag = getTag(value),
	        isFunc = tag == funcTag || tag == genTag;
	
	    if (isBuffer(value)) {
	      return cloneBuffer(value, isDeep);
	    }
	    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
	      if (isHostObject(value)) {
	        return object ? value : {};
	      }
	      result = initCloneObject(isFunc ? {} : value);
	      if (!isDeep) {
	        result = baseAssign(result, value);
	        return isFull ? copySymbols(value, result) : result;
	      }
	    } else {
	      if (!cloneableTags[tag]) {
	        return object ? value : {};
	      }
	      result = initCloneByTag(value, tag, isDeep);
	    }
	  }
	  // Check for circular references and return its corresponding clone.
	  stack || (stack = new Stack);
	  var stacked = stack.get(value);
	  if (stacked) {
	    return stacked;
	  }
	  stack.set(value, result);
	
	  // Recursively populate clone (susceptible to call stack limits).
	  (isArr ? arrayEach : baseForOwn)(value, function(subValue, key) {
	    assignValue(result, key, baseClone(subValue, isDeep, isFull, customizer, key, value, stack));
	  });
	  return (isFull && !isArr) ? copySymbols(value, result) : result;
	}
	
	module.e = baseClone;


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(2);
	
	/** Built-in value references. */
	var objectCreate = Object.create;
	
	/**
	 * The base implementation of `_.create` without support for assigning
	 * properties to the created object.
	 *
	 * @private
	 * @param {Object} prototype The object to inherit from.
	 * @returns {Object} Returns the new object.
	 */
	function baseCreate(proto) {
	  return isObject(proto) ? objectCreate(proto) : {};
	}
	
	module.e = baseCreate;


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	var arrayPush = __webpack_require__(90),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isArrayLikeObject = __webpack_require__(27);
	
	/**
	 * The base implementation of `_.flatten` with support for restricting flattening.
	 *
	 * @private
	 * @param {Array} array The array to flatten.
	 * @param {number} depth The maximum recursion depth.
	 * @param {boolean} [isStrict] Restrict flattening to arrays-like objects.
	 * @param {Array} [result=[]] The initial result value.
	 * @returns {Array} Returns the new flattened array.
	 */
	function baseFlatten(array, depth, isStrict, result) {
	  result || (result = []);
	
	  var index = -1,
	      length = array.length;
	
	  while (++index < length) {
	    var value = array[index];
	    if (depth > 0 && isArrayLikeObject(value) &&
	        (isStrict || isArray(value) || isArguments(value))) {
	      if (depth > 1) {
	        // Recursively flatten arrays (susceptible to call stack limits).
	        baseFlatten(value, depth - 1, isStrict, result);
	      } else {
	        arrayPush(result, value);
	      }
	    } else if (!isStrict) {
	      result[result.length] = value;
	    }
	  }
	  return result;
	}
	
	module.e = baseFlatten;


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	var createBaseFor = __webpack_require__(115);
	
	/**
	 * The base implementation of `baseForIn` and `baseForOwn` which iterates
	 * over `object` properties returned by `keysFunc` invoking `iteratee` for
	 * each property. Iteratee functions may exit iteration early by explicitly
	 * returning `false`.
	 *
	 * @private
	 * @param {Object} object The object to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @param {Function} keysFunc The function to get the keys of `object`.
	 * @returns {Object} Returns `object`.
	 */
	var baseFor = createBaseFor();
	
	module.e = baseFor;


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	var baseFor = __webpack_require__(95),
	    keys = __webpack_require__(45);
	
	/**
	 * The base implementation of `_.forOwn` without support for iteratee shorthands.
	 *
	 * @private
	 * @param {Object} object The object to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Object} Returns `object`.
	 */
	function baseForOwn(object, iteratee) {
	  return object && baseFor(object, iteratee, keys);
	}
	
	module.e = baseForOwn;


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * The base implementation of `_.has` without support for deep paths.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Array|string} key The key to check.
	 * @returns {boolean} Returns `true` if `key` exists, else `false`.
	 */
	function baseHas(object, key) {
	  // Avoid a bug in IE 10-11 where objects with a [[Prototype]] of `null`,
	  // that are composed entirely of index properties, return `false` for
	  // `hasOwnProperty` checks of them.
	  return hasOwnProperty.call(object, key) ||
	    (typeof object == 'object' && key in object && getPrototypeOf(object) === null);
	}
	
	module.e = baseHas;


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeKeys = Object.keys;
	
	/**
	 * The base implementation of `_.keys` which doesn't skip the constructor
	 * property of prototypes or treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeys(object) {
	  return nativeKeys(Object(object));
	}
	
	module.e = baseKeys;


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	var Reflect = __webpack_require__(82),
	    iteratorToArray = __webpack_require__(126);
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Built-in value references. */
	var enumerate = Reflect ? Reflect.enumerate : undefined,
	    propertyIsEnumerable = objectProto.propertyIsEnumerable;
	
	/**
	 * The base implementation of `_.keysIn` which doesn't skip the constructor
	 * property of prototypes or treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeysIn(object) {
	  object = object == null ? object : Object(object);
	
	  var result = [];
	  for (var key in object) {
	    result.push(key);
	  }
	  return result;
	}
	
	// Fallback for IE < 9 with es6-shim.
	if (enumerate && !propertyIsEnumerable.call({ 'valueOf': 1 }, 'valueOf')) {
	  baseKeysIn = function(object) {
	    return iteratorToArray(enumerate(object));
	  };
	}
	
	module.e = baseKeysIn;


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	var Stack = __webpack_require__(32),
	    arrayEach = __webpack_require__(33),
	    assignMergeValue = __webpack_require__(34),
	    baseMergeDeep = __webpack_require__(101),
	    isArray = __webpack_require__(5),
	    isObject = __webpack_require__(2),
	    isTypedArray = __webpack_require__(44),
	    keysIn = __webpack_require__(46);
	
	/**
	 * The base implementation of `_.merge` without support for multiple sources.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} [customizer] The function to customize merged values.
	 * @param {Object} [stack] Tracks traversed source values and their merged counterparts.
	 */
	function baseMerge(object, source, srcIndex, customizer, stack) {
	  if (object === source) {
	    return;
	  }
	  var props = (isArray(source) || isTypedArray(source))
	    ? undefined
	    : keysIn(source);
	
	  arrayEach(props || source, function(srcValue, key) {
	    if (props) {
	      key = srcValue;
	      srcValue = source[key];
	    }
	    if (isObject(srcValue)) {
	      stack || (stack = new Stack);
	      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
	    }
	    else {
	      var newValue = customizer
	        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
	        : undefined;
	
	      if (newValue === undefined) {
	        newValue = srcValue;
	      }
	      assignMergeValue(object, key, newValue);
	    }
	  });
	}
	
	module.e = baseMerge;


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	var assignMergeValue = __webpack_require__(34),
	    baseClone = __webpack_require__(92),
	    copyArray = __webpack_require__(41),
	    isArguments = __webpack_require__(25),
	    isArray = __webpack_require__(5),
	    isArrayLikeObject = __webpack_require__(27),
	    isFunction = __webpack_require__(16),
	    isObject = __webpack_require__(2),
	    isPlainObject = __webpack_require__(142),
	    isTypedArray = __webpack_require__(44),
	    toPlainObject = __webpack_require__(147);
	
	/**
	 * A specialized version of `baseMerge` for arrays and objects which performs
	 * deep merges and tracks traversed objects enabling objects with circular
	 * references to be merged.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {string} key The key of the value to merge.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} mergeFunc The function to merge values.
	 * @param {Function} [customizer] The function to customize assigned values.
	 * @param {Object} [stack] Tracks traversed source values and their merged counterparts.
	 */
	function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
	  var objValue = object[key],
	      srcValue = source[key],
	      stacked = stack.get(srcValue);
	
	  if (stacked) {
	    assignMergeValue(object, key, stacked);
	    return;
	  }
	  var newValue = customizer
	    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
	    : undefined;
	
	  var isCommon = newValue === undefined;
	
	  if (isCommon) {
	    newValue = srcValue;
	    if (isArray(srcValue) || isTypedArray(srcValue)) {
	      if (isArray(objValue)) {
	        newValue = objValue;
	      }
	      else if (isArrayLikeObject(objValue)) {
	        newValue = copyArray(objValue);
	      }
	      else {
	        isCommon = false;
	        newValue = baseClone(srcValue, !customizer);
	      }
	    }
	    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
	      if (isArguments(objValue)) {
	        newValue = toPlainObject(objValue);
	      }
	      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
	        isCommon = false;
	        newValue = baseClone(srcValue, !customizer);
	      }
	      else {
	        newValue = objValue;
	      }
	    }
	    else {
	      isCommon = false;
	    }
	  }
	  stack.set(srcValue, newValue);
	
	  if (isCommon) {
	    // Recursively merge objects and arrays (susceptible to call stack limits).
	    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
	  }
	  stack['delete'](srcValue);
	  assignMergeValue(object, key, newValue);
	}
	
	module.e = baseMergeDeep;


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	var arrayReduce = __webpack_require__(20);
	
	/**
	 * The base implementation of `_.pick` without support for individual
	 * property names.
	 *
	 * @private
	 * @param {Object} object The source object.
	 * @param {string[]} props The property names to pick.
	 * @returns {Object} Returns the new object.
	 */
	function basePick(object, props) {
	  object = Object(object);
	  return arrayReduce(props, function(result, key) {
	    if (key in object) {
	      result[key] = object[key];
	    }
	    return result;
	  }, {});
	}
	
	module.e = basePick;


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * The base implementation of `_.property` without support for deep paths.
	 *
	 * @private
	 * @param {string} key The key of the property to get.
	 * @returns {Function} Returns the new function.
	 */
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? undefined : object[key];
	  };
	}
	
	module.e = baseProperty;


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * The base implementation of `_.times` without support for iteratee shorthands
	 * or max array length checks.
	 *
	 * @private
	 * @param {number} n The number of times to invoke `iteratee`.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns the array of results.
	 */
	function baseTimes(n, iteratee) {
	  var index = -1,
	      result = Array(n);
	
	  while (++index < n) {
	    result[index] = iteratee(index);
	  }
	  return result;
	}
	
	module.e = baseTimes;


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Checks if `value` is a global object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {null|Object} Returns `value` if it's a global object, else `null`.
	 */
	function checkGlobal(value) {
	  return (value && value.Object === Object) ? value : null;
	}
	
	module.e = checkGlobal;


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a clone of  `buffer`.
	 *
	 * @private
	 * @param {Buffer} buffer The buffer to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Buffer} Returns the cloned buffer.
	 */
	function cloneBuffer(buffer, isDeep) {
	  if (isDeep) {
	    return buffer.slice();
	  }
	  var result = new buffer.constructor(buffer.length);
	  buffer.copy(result);
	  return result;
	}
	
	module.e = cloneBuffer;


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	var addMapEntry = __webpack_require__(87),
	    arrayReduce = __webpack_require__(20),
	    mapToArray = __webpack_require__(132);
	
	/**
	 * Creates a clone of `map`.
	 *
	 * @private
	 * @param {Object} map The map to clone.
	 * @returns {Object} Returns the cloned map.
	 */
	function cloneMap(map) {
	  return arrayReduce(mapToArray(map), addMapEntry, new map.constructor);
	}
	
	module.e = cloneMap;


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	/** Used to match `RegExp` flags from their coerced string values. */
	var reFlags = /\w*$/;
	
	/**
	 * Creates a clone of `regexp`.
	 *
	 * @private
	 * @param {Object} regexp The regexp to clone.
	 * @returns {Object} Returns the cloned regexp.
	 */
	function cloneRegExp(regexp) {
	  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	  result.lastIndex = regexp.lastIndex;
	  return result;
	}
	
	module.e = cloneRegExp;


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	var addSetEntry = __webpack_require__(88),
	    arrayReduce = __webpack_require__(20),
	    setToArray = __webpack_require__(133);
	
	/**
	 * Creates a clone of `set`.
	 *
	 * @private
	 * @param {Object} set The set to clone.
	 * @returns {Object} Returns the cloned set.
	 */
	function cloneSet(set) {
	  return arrayReduce(setToArray(set), addSetEntry, new set.constructor);
	}
	
	module.e = cloneSet;


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	var Symbol = __webpack_require__(84);
	
	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol ? Symbol.prototype : undefined,
	    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;
	
	/**
	 * Creates a clone of the `symbol` object.
	 *
	 * @private
	 * @param {Object} symbol The symbol object to clone.
	 * @returns {Object} Returns the cloned symbol object.
	 */
	function cloneSymbol(symbol) {
	  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	}
	
	module.e = cloneSymbol;


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	var cloneArrayBuffer = __webpack_require__(40);
	
	/**
	 * Creates a clone of `typedArray`.
	 *
	 * @private
	 * @param {Object} typedArray The typed array to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned typed array.
	 */
	function cloneTypedArray(typedArray, isDeep) {
	  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	}
	
	module.e = cloneTypedArray;


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	var assignValue = __webpack_require__(35);
	
	/**
	 * This function is like `copyObject` except that it accepts a function to
	 * customize copied values.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property names to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @param {Function} [customizer] The function to customize copied values.
	 * @returns {Object} Returns `object`.
	 */
	function copyObjectWith(source, props, object, customizer) {
	  object || (object = {});
	
	  var index = -1,
	      length = props.length;
	
	  while (++index < length) {
	    var key = props[index];
	
	    var newValue = customizer
	      ? customizer(object[key], source[key], key, object, source)
	      : source[key];
	
	    assignValue(object, key, newValue);
	  }
	  return object;
	}
	
	module.e = copyObjectWith;


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    getSymbols = __webpack_require__(117);
	
	/**
	 * Copies own symbol properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy symbols from.
	 * @param {Object} [object={}] The object to copy symbols to.
	 * @returns {Object} Returns `object`.
	 */
	function copySymbols(source, object) {
	  return copyObject(source, getSymbols(source), object);
	}
	
	module.e = copySymbols;


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	var isIterateeCall = __webpack_require__(125),
	    rest = __webpack_require__(47);
	
	/**
	 * Creates a function like `_.assign`.
	 *
	 * @private
	 * @param {Function} assigner The function to assign values.
	 * @returns {Function} Returns the new assigner function.
	 */
	function createAssigner(assigner) {
	  return rest(function(object, sources) {
	    var index = -1,
	        length = sources.length,
	        customizer = length > 1 ? sources[length - 1] : undefined,
	        guard = length > 2 ? sources[2] : undefined;
	
	    customizer = typeof customizer == 'function'
	      ? (length--, customizer)
	      : undefined;
	
	    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	      customizer = length < 3 ? undefined : customizer;
	      length = 1;
	    }
	    object = Object(object);
	    while (++index < length) {
	      var source = sources[index];
	      if (source) {
	        assigner(object, source, index, customizer);
	      }
	    }
	    return object;
	  });
	}
	
	module.e = createAssigner;


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a base function for methods like `_.forIn`.
	 *
	 * @private
	 * @param {boolean} [fromRight] Specify iterating from right to left.
	 * @returns {Function} Returns the new base function.
	 */
	function createBaseFor(fromRight) {
	  return function(object, iteratee, keysFunc) {
	    var index = -1,
	        iterable = Object(object),
	        props = keysFunc(object),
	        length = props.length;
	
	    while (length--) {
	      var key = props[fromRight ? length : ++index];
	      if (iteratee(iterable[key], key, iterable) === false) {
	        break;
	      }
	    }
	    return object;
	  };
	}
	
	module.e = createBaseFor;


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	var baseProperty = __webpack_require__(103);
	
	/**
	 * Gets the "length" property value of `object`.
	 *
	 * **Note:** This function is used to avoid a [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792)
	 * that affects Safari on at least iOS 8.1-8.3 ARM64.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {*} Returns the "length" value.
	 */
	var getLength = baseProperty('length');
	
	module.e = getLength;


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	/** Built-in value references. */
	var getOwnPropertySymbols = Object.getOwnPropertySymbols;
	
	/**
	 * Creates an array of the own symbol properties of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of symbols.
	 */
	var getSymbols = getOwnPropertySymbols || function() {
	  return [];
	};
	
	module.e = getSymbols;


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    Set = __webpack_require__(83),
	    WeakMap = __webpack_require__(86);
	
	/** `Object#toString` result references. */
	var mapTag = '[object Map]',
	    objectTag = '[object Object]',
	    setTag = '[object Set]',
	    weakMapTag = '[object WeakMap]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Used to detect maps, sets, and weakmaps. */
	var mapCtorString = Map ? funcToString.call(Map) : '',
	    setCtorString = Set ? funcToString.call(Set) : '',
	    weakMapCtorString = WeakMap ? funcToString.call(WeakMap) : '';
	
	/**
	 * Gets the `toStringTag` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function getTag(value) {
	  return objectToString.call(value);
	}
	
	// Fallback for IE 11 providing `toStringTag` values for maps, sets, and weakmaps.
	if ((Map && getTag(new Map) != mapTag) ||
	    (Set && getTag(new Set) != setTag) ||
	    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	  getTag = function(value) {
	    var result = objectToString.call(value),
	        Ctor = result == objectTag ? value.constructor : null,
	        ctorString = typeof Ctor == 'function' ? funcToString.call(Ctor) : '';
	
	    if (ctorString) {
	      switch (ctorString) {
	        case mapCtorString: return mapTag;
	        case setCtorString: return setTag;
	        case weakMapCtorString: return weakMapTag;
	      }
	    }
	    return result;
	  };
	}
	
	module.e = getTag;


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	var hashHas = __webpack_require__(42);
	
	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(hash, key) {
	  return hashHas(hash, key) && delete hash[key];
	}
	
	module.e = hashDelete;


/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @param {Object} hash The hash to query.
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(hash, key) {
	  if (nativeCreate) {
	    var result = hash[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty.call(hash, key) ? hash[key] : undefined;
	}
	
	module.e = hashGet;


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	var nativeCreate = __webpack_require__(14);
	
	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';
	
	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 */
	function hashSet(hash, key, value) {
	  hash[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	}
	
	module.e = hashSet;


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/**
	 * Initializes an array clone.
	 *
	 * @private
	 * @param {Array} array The array to clone.
	 * @returns {Array} Returns the initialized clone.
	 */
	function initCloneArray(array) {
	  var length = array.length,
	      result = array.constructor(length);
	
	  // Add properties assigned by `RegExp#exec`.
	  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
	    result.index = array.index;
	    result.input = array.input;
	  }
	  return result;
	}
	
	module.e = initCloneArray;


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	var cloneArrayBuffer = __webpack_require__(40),
	    cloneMap = __webpack_require__(107),
	    cloneRegExp = __webpack_require__(108),
	    cloneSet = __webpack_require__(109),
	    cloneSymbol = __webpack_require__(110),
	    cloneTypedArray = __webpack_require__(111);
	
	/** `Object#toString` result references. */
	var boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    symbolTag = '[object Symbol]';
	
	var arrayBufferTag = '[object ArrayBuffer]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';
	
	/**
	 * Initializes an object clone based on its `toStringTag`.
	 *
	 * **Note:** This function only supports cloning values with tags of
	 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @param {string} tag The `toStringTag` of the object to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneByTag(object, tag, isDeep) {
	  var Ctor = object.constructor;
	  switch (tag) {
	    case arrayBufferTag:
	      return cloneArrayBuffer(object);
	
	    case boolTag:
	    case dateTag:
	      return new Ctor(+object);
	
	    case float32Tag: case float64Tag:
	    case int8Tag: case int16Tag: case int32Tag:
	    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
	      return cloneTypedArray(object, isDeep);
	
	    case mapTag:
	      return cloneMap(object);
	
	    case numberTag:
	    case stringTag:
	      return new Ctor(object);
	
	    case regexpTag:
	      return cloneRegExp(object);
	
	    case setTag:
	      return cloneSet(object);
	
	    case symbolTag:
	      return cloneSymbol(object);
	  }
	}
	
	module.e = initCloneByTag;


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	var baseCreate = __webpack_require__(93),
	    isPrototype = __webpack_require__(24);
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * Initializes an object clone.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneObject(object) {
	  return (typeof object.constructor == 'function' && !isPrototype(object))
	    ? baseCreate(getPrototypeOf(object))
	    : {};
	}
	
	module.e = initCloneObject;


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	var eq = __webpack_require__(15),
	    isArrayLike = __webpack_require__(26),
	    isIndex = __webpack_require__(23),
	    isObject = __webpack_require__(2);
	
	/**
	 * Checks if the given arguments are from an iteratee call.
	 *
	 * @private
	 * @param {*} value The potential iteratee value argument.
	 * @param {*} index The potential iteratee index or key argument.
	 * @param {*} object The potential iteratee object argument.
	 * @returns {boolean} Returns `true` if the arguments are from an iteratee call, else `false`.
	 */
	function isIterateeCall(value, index, object) {
	  if (!isObject(object)) {
	    return false;
	  }
	  var type = typeof index;
	  if (type == 'number'
	      ? (isArrayLike(object) && isIndex(index, object.length))
	      : (type == 'string' && index in object)) {
	    return eq(object[index], value);
	  }
	  return false;
	}
	
	module.e = isIterateeCall;


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `iterator` to an array.
	 *
	 * @private
	 * @param {Object} iterator The iterator to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function iteratorToArray(iterator) {
	  var data,
	      result = [];
	
	  while (!(data = iterator.next()).done) {
	    result.push(data.value);
	  }
	  return result;
	}
	
	module.e = iteratorToArray;


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	var Hash = __webpack_require__(80),
	    Map = __webpack_require__(4);
	
	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapClear() {
	  this.__data__ = {
	    'hash': new Hash,
	    'map': Map ? new Map : [],
	    'string': new Hash
	  };
	}
	
	module.e = mapClear;


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocDelete = __webpack_require__(36),
	    hashDelete = __webpack_require__(119),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapDelete(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashDelete(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map['delete'](key) : assocDelete(data.map, key);
	}
	
	module.e = mapDelete;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocGet = __webpack_require__(37),
	    hashGet = __webpack_require__(120),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapGet(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashGet(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map.get(key) : assocGet(data.map, key);
	}
	
	module.e = mapGet;


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocHas = __webpack_require__(38),
	    hashHas = __webpack_require__(42),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapHas(key) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    return hashHas(typeof key == 'string' ? data.string : data.hash, key);
	  }
	  return Map ? data.map.has(key) : assocHas(data.map, key);
	}
	
	module.e = mapHas;


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	var Map = __webpack_require__(4),
	    assocSet = __webpack_require__(39),
	    hashSet = __webpack_require__(121),
	    isKeyable = __webpack_require__(13);
	
	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache object.
	 */
	function mapSet(key, value) {
	  var data = this.__data__;
	  if (isKeyable(key)) {
	    hashSet(typeof key == 'string' ? data.string : data.hash, key, value);
	  } else if (Map) {
	    data.map.set(key, value);
	  } else {
	    assocSet(data.map, key, value);
	  }
	  return this;
	}
	
	module.e = mapSet;


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `map` to an array.
	 *
	 * @private
	 * @param {Object} map The map to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function mapToArray(map) {
	  var index = -1,
	      result = Array(map.size);
	
	  map.forEach(function(value, key) {
	    result[++index] = [key, value];
	  });
	  return result;
	}
	
	module.e = mapToArray;


/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Converts `set` to an array.
	 *
	 * @private
	 * @param {Object} set The set to convert.
	 * @returns {Array} Returns the converted array.
	 */
	function setToArray(set) {
	  var index = -1,
	      result = Array(set.size);
	
	  set.forEach(function(value) {
	    result[++index] = value;
	  });
	  return result;
	}
	
	module.e = setToArray;


/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Removes all key-value entries from the stack.
	 *
	 * @private
	 * @name clear
	 * @memberOf Stack
	 */
	function stackClear() {
	  this.__data__ = { 'array': [], 'map': null };
	}
	
	module.e = stackClear;


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	var assocDelete = __webpack_require__(36);
	
	/**
	 * Removes `key` and its value from the stack.
	 *
	 * @private
	 * @name delete
	 * @memberOf Stack
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function stackDelete(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocDelete(array, key) : data.map['delete'](key);
	}
	
	module.e = stackDelete;


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	var assocGet = __webpack_require__(37);
	
	/**
	 * Gets the stack value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Stack
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function stackGet(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocGet(array, key) : data.map.get(key);
	}
	
	module.e = stackGet;


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

	var assocHas = __webpack_require__(38);
	
	/**
	 * Checks if a stack value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Stack
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function stackHas(key) {
	  var data = this.__data__,
	      array = data.array;
	
	  return array ? assocHas(array, key) : data.map.has(key);
	}
	
	module.e = stackHas;


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	var MapCache = __webpack_require__(81),
	    assocSet = __webpack_require__(39);
	
	/** Used as the size to enable large array optimizations. */
	var LARGE_ARRAY_SIZE = 200;
	
	/**
	 * Sets the stack `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Stack
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the stack cache object.
	 */
	function stackSet(key, value) {
	  var data = this.__data__,
	      array = data.array;
	
	  if (array) {
	    if (array.length < (LARGE_ARRAY_SIZE - 1)) {
	      assocSet(array, key, value);
	    } else {
	      data.array = null;
	      data.map = new MapCache(array);
	    }
	  }
	  var map = data.map;
	  if (map) {
	    map.set(key, value);
	  }
	  return this;
	}
	
	module.e = stackSet;


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Creates a function that returns `value`.
	 *
	 * @static
	 * @memberOf _
	 * @category Util
	 * @param {*} value The value to return from the new function.
	 * @returns {Function} Returns the new function.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var getter = _.constant(object);
	 *
	 * getter() === object;
	 * // => true
	 */
	function constant(value) {
	  return function() {
	    return value;
	  };
	}
	
	module.e = constant;


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var constant = __webpack_require__(139),
	    root = __webpack_require__(1);
	
	/** Used to determine if values are of the language type `Object`. */
	var objectTypes = {
	  'function': true,
	  'object': true
	};
	
	/** Detect free variable `exports`. */
	var freeExports = (objectTypes[typeof exports] && exports && !exports.nodeType)
	  ? exports
	  : undefined;
	
	/** Detect free variable `module`. */
	var freeModule = (objectTypes[typeof module] && module && !module.nodeType)
	  ? module
	  : undefined;
	
	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = (freeModule && freeModule.exports === freeExports)
	  ? freeExports
	  : undefined;
	
	/** Built-in value references. */
	var Buffer = moduleExports ? root.Buffer : undefined;
	
	/**
	 * Checks if `value` is a buffer.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	 * @example
	 *
	 * _.isBuffer(new Buffer(2));
	 * // => true
	 *
	 * _.isBuffer(new Uint8Array(2));
	 * // => false
	 */
	var isBuffer = !Buffer ? constant(false) : function(value) {
	  return value instanceof Buffer;
	};
	
	module.e = isBuffer;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(48)(module)))

/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

	var isFunction = __webpack_require__(16),
	    isHostObject = __webpack_require__(22),
	    isObjectLike = __webpack_require__(8);
	
	/** Used to match `RegExp` [syntax characters](http://ecma-international.org/ecma-262/6.0/#sec-patterns). */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
	
	/** Used to detect host constructors (Safari > 5). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;
	
	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);
	
	/**
	 * Checks if `value` is a native function.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function, else `false`.
	 * @example
	 *
	 * _.isNative(Array.prototype.push);
	 * // => true
	 *
	 * _.isNative(_);
	 * // => false
	 */
	function isNative(value) {
	  if (value == null) {
	    return false;
	  }
	  if (isFunction(value)) {
	    return reIsNative.test(funcToString.call(value));
	  }
	  return isObjectLike(value) &&
	    (isHostObject(value) ? reIsNative : reIsHostCtor).test(value);
	}
	
	module.e = isNative;


/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

	var isHostObject = __webpack_require__(22),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var objectTag = '[object Object]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;
	
	/** Used to infer the `Object` constructor. */
	var objectCtorString = funcToString.call(Object);
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/** Built-in value references. */
	var getPrototypeOf = Object.getPrototypeOf;
	
	/**
	 * Checks if `value` is a plain object, that is, an object created by the
	 * `Object` constructor or one with a `[[Prototype]]` of `null`.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
	 * @example
	 *
	 * function Foo() {
	 *   this.a = 1;
	 * }
	 *
	 * _.isPlainObject(new Foo);
	 * // => false
	 *
	 * _.isPlainObject([1, 2, 3]);
	 * // => false
	 *
	 * _.isPlainObject({ 'x': 0, 'y': 0 });
	 * // => true
	 *
	 * _.isPlainObject(Object.create(null));
	 * // => true
	 */
	function isPlainObject(value) {
	  if (!isObjectLike(value) ||
	      objectToString.call(value) != objectTag || isHostObject(value)) {
	    return false;
	  }
	  var proto = getPrototypeOf(value);
	  if (proto === null) {
	    return true;
	  }
	  var Ctor = proto.constructor;
	  return (typeof Ctor == 'function' &&
	    Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString);
	}
	
	module.e = isPlainObject;


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	var isArray = __webpack_require__(5),
	    isObjectLike = __webpack_require__(8);
	
	/** `Object#toString` result references. */
	var stringTag = '[object String]';
	
	/** Used for built-in method references. */
	var objectProto = Object.prototype;
	
	/**
	 * Used to resolve the [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;
	
	/**
	 * Checks if `value` is classified as a `String` primitive or object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified, else `false`.
	 * @example
	 *
	 * _.isString('abc');
	 * // => true
	 *
	 * _.isString(1);
	 * // => false
	 */
	function isString(value) {
	  return typeof value == 'string' ||
	    (!isArray(value) && isObjectLike(value) && objectToString.call(value) == stringTag);
	}
	
	module.e = isString;


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

	var baseFlatten = __webpack_require__(94),
	    basePick = __webpack_require__(102),
	    rest = __webpack_require__(47);
	
	/**
	 * Creates an object composed of the picked `object` properties.
	 *
	 * @static
	 * @memberOf _
	 * @category Object
	 * @param {Object} object The source object.
	 * @param {...(string|string[])} [props] The property names to pick, specified
	 *  individually or in arrays.
	 * @returns {Object} Returns the new object.
	 * @example
	 *
	 * var object = { 'a': 1, 'b': '2', 'c': 3 };
	 *
	 * _.pick(object, ['a', 'c']);
	 * // => { 'a': 1, 'c': 3 }
	 */
	var pick = rest(function(object, props) {
	  return object == null ? {} : basePick(object, baseFlatten(props, 1));
	});
	
	module.e = pick;


/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

	var toNumber = __webpack_require__(146);
	
	/** Used as references for various `Number` constants. */
	var INFINITY = 1 / 0,
	    MAX_INTEGER = 1.7976931348623157e+308;
	
	/**
	 * Converts `value` to an integer.
	 *
	 * **Note:** This function is loosely based on [`ToInteger`](http://www.ecma-international.org/ecma-262/6.0/#sec-tointeger).
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {number} Returns the converted integer.
	 * @example
	 *
	 * _.toInteger(3);
	 * // => 3
	 *
	 * _.toInteger(Number.MIN_VALUE);
	 * // => 0
	 *
	 * _.toInteger(Infinity);
	 * // => 1.7976931348623157e+308
	 *
	 * _.toInteger('3');
	 * // => 3
	 */
	function toInteger(value) {
	  if (!value) {
	    return value === 0 ? value : 0;
	  }
	  value = toNumber(value);
	  if (value === INFINITY || value === -INFINITY) {
	    var sign = (value < 0 ? -1 : 1);
	    return sign * MAX_INTEGER;
	  }
	  var remainder = value % 1;
	  return value === value ? (remainder ? value - remainder : value) : 0;
	}
	
	module.e = toInteger;


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

	var isFunction = __webpack_require__(16),
	    isObject = __webpack_require__(2);
	
	/** Used as references for various `Number` constants. */
	var NAN = 0 / 0;
	
	/** Used to match leading and trailing whitespace. */
	var reTrim = /^\s+|\s+$/g;
	
	/** Used to detect bad signed hexadecimal string values. */
	var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
	
	/** Used to detect binary string values. */
	var reIsBinary = /^0b[01]+$/i;
	
	/** Used to detect octal string values. */
	var reIsOctal = /^0o[0-7]+$/i;
	
	/** Built-in method references without a dependency on `root`. */
	var freeParseInt = parseInt;
	
	/**
	 * Converts `value` to a number.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to process.
	 * @returns {number} Returns the number.
	 * @example
	 *
	 * _.toNumber(3);
	 * // => 3
	 *
	 * _.toNumber(Number.MIN_VALUE);
	 * // => 5e-324
	 *
	 * _.toNumber(Infinity);
	 * // => Infinity
	 *
	 * _.toNumber('3');
	 * // => 3
	 */
	function toNumber(value) {
	  if (isObject(value)) {
	    var other = isFunction(value.valueOf) ? value.valueOf() : value;
	    value = isObject(other) ? (other + '') : other;
	  }
	  if (typeof value != 'string') {
	    return value === 0 ? value : +value;
	  }
	  value = value.replace(reTrim, '');
	  var isBinary = reIsBinary.test(value);
	  return (isBinary || reIsOctal.test(value))
	    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
	    : (reIsBadHex.test(value) ? NAN : +value);
	}
	
	module.e = toNumber;


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

	var copyObject = __webpack_require__(21),
	    keysIn = __webpack_require__(46);
	
	/**
	 * Converts `value` to a plain object flattening inherited enumerable
	 * properties of `value` to own properties of the plain object.
	 *
	 * @static
	 * @memberOf _
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {Object} Returns the converted plain object.
	 * @example
	 *
	 * function Foo() {
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.assign({ 'a': 1 }, new Foo);
	 * // => { 'a': 1, 'b': 2 }
	 *
	 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
	 * // => { 'a': 1, 'b': 2, 'c': 3 }
	 */
	function toPlainObject(value) {
	  return copyObject(value, keysIn(value));
	}
	
	module.e = toPlainObject;


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	// Shimming starts here.
	(function() {
	  // Utils.
	  var logging = __webpack_require__(0).log;
	  var browserDetails = __webpack_require__(0).browserDetails;
	  // Export to the adapter global object visible in the browser.
	  module.e.browserDetails = browserDetails;
	  module.e.extractVersion = __webpack_require__(0).extractVersion;
	  module.e.disableLog = __webpack_require__(0).disableLog;
	
	  // Uncomment if you do not want any logging at all including the switch
	  // statement below. Can also be turned off in the browser via
	  // adapter.disableLog(true) but then logging from the switch statement below
	  // will still appear.
	  //require('./utils').disableLog(true);
	
	  // Browser shims.
	  var chromeShim = __webpack_require__(149) || null;
	  var edgeShim = __webpack_require__(152) || null;
	  var firefoxShim = __webpack_require__(153) || null;
	
	  // Shim browser if found.
	  switch (browserDetails.browser) {
	    case 'chrome':
	      if (!chromeShim || !chromeShim.shimPeerConnection) {
	        logging('Chrome shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming chrome!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = chromeShim;
	
	      chromeShim.shimGetUserMedia();
	      chromeShim.shimSourceObject();
	      chromeShim.shimPeerConnection();
	      chromeShim.shimOnTrack();
	      break;
	    case 'edge':
	      if (!edgeShim || !edgeShim.shimPeerConnection) {
	        logging('MS edge shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming edge!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = edgeShim;
	
	      edgeShim.shimPeerConnection();
	      break;
	    case 'firefox':
	      if (!firefoxShim || !firefoxShim.shimPeerConnection) {
	        logging('Firefox shim is not included in this adapter release.');
	        return;
	      }
	      logging('adapter.js shimming firefox!');
	      // Export to the adapter global object visible in the browser.
	      module.e.browserShim = firefoxShim;
	
	      firefoxShim.shimGetUserMedia();
	      firefoxShim.shimSourceObject();
	      firefoxShim.shimPeerConnection();
	      firefoxShim.shimOnTrack();
	      break;
	    default:
	      logging('Unsupported browser!');
	  }
	})();


/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var chromeShim = {
	  shimOnTrack: function() {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() { return this._ontrack; },
	        set: function(f) {
	          var self = this;
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	            this.removeEventListener('addstream', this._ontrackpoly);
	          }
	          this.addEventListener('track', this._ontrack = f);
	          this.addEventListener('addstream', this._ontrackpoly = function(e) {
	            // onaddstream does not fire when a track is added to an existing stream.
	            // but stream.onaddtrack is implemented so we use that
	            e.stream.addEventListener('addtrack', function(te) {
	              var event = new Event('track');
	              event.track = te.track;
	              event.receiver = {track: te.track};
	              event.streams = [e.stream];
	              self.dispatchEvent(event);
	            });
	            e.stream.getTracks().forEach(function(track) {
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = {track: track};
	              event.streams = [e.stream];
	              this.dispatchEvent(event);
	            }.bind(this));
	          }.bind(this));
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function() {
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this._srcObject;
	          },
	          set: function(stream) {
	            var self = this;
	            // Use _srcObject as a private property for this shim
	            this._srcObject = stream;
	            if (this.src) {
	              URL.revokeObjectURL(this.src);
	            }
	
	            if (!stream) {
	              this.src = '';
	              return;
	            }
	            this.src = URL.createObjectURL(stream);
	            // We need to recreate the blob url when a track is added or removed.
	            // Doing it manually since we want to avoid a recursion.
	            stream.addEventListener('addtrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	            stream.addEventListener('removetrack', function() {
	              if (self.src) {
	                URL.revokeObjectURL(self.src);
	              }
	              self.src = URL.createObjectURL(stream);
	            });
	          }
	        });
	      }
	    }
	  },
	
	  shimPeerConnection: function() {
	    // The RTCPeerConnection object.
	    window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	      // Translate iceTransportPolicy to iceTransports,
	      // see https://code.google.com/p/webrtc/issues/detail?id=4869
	      logging('PeerConnection');
	      if (pcConfig && pcConfig.iceTransportPolicy) {
	        pcConfig.iceTransports = pcConfig.iceTransportPolicy;
	      }
	
	      var pc = new webkitRTCPeerConnection(pcConfig, pcConstraints); // jscs:ignore requireCapitalizedConstructors
	      var origGetStats = pc.getStats.bind(pc);
	      pc.getStats = function(selector, successCallback, errorCallback) { // jshint ignore: line
	        var self = this;
	        var args = arguments;
	
	        // If selector is a function then we are in the old style stats so just
	        // pass back the original getStats format to avoid breaking old users.
	        if (arguments.length > 0 && typeof selector === 'function') {
	          return origGetStats(selector, successCallback);
	        }
	
	        var fixChromeStats_ = function(response) {
	          var standardReport = {};
	          var reports = response.result();
	          reports.forEach(function(report) {
	            var standardStats = {
	              id: report.id,
	              timestamp: report.timestamp,
	              type: report.type
	            };
	            report.names().forEach(function(name) {
	              standardStats[name] = report.stat(name);
	            });
	            standardReport[standardStats.id] = standardStats;
	          });
	
	          return standardReport;
	        };
	
	        if (arguments.length >= 2) {
	          var successCallbackWrapper_ = function(response) {
	            args[1](fixChromeStats_(response));
	          };
	
	          return origGetStats.apply(this, [successCallbackWrapper_, arguments[0]]);
	        }
	
	        // promise-support
	        return new Promise(function(resolve, reject) {
	          if (args.length === 1 && selector === null) {
	            origGetStats.apply(self, [
	                function(response) {
	                  resolve.apply(null, [fixChromeStats_(response)]);
	                }, reject]);
	          } else {
	            origGetStats.apply(self, [resolve, reject]);
	          }
	        });
	      };
	
	      return pc;
	    };
	    window.RTCPeerConnection.prototype = webkitRTCPeerConnection.prototype;
	
	    // wrap static methods. Currently just generateCertificate.
	    if (webkitRTCPeerConnection.generateCertificate) {
	      Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	        get: function() {
	          if (arguments.length) {
	            return webkitRTCPeerConnection.generateCertificate.apply(null,
	                arguments);
	          } else {
	            return webkitRTCPeerConnection.generateCertificate;
	          }
	        }
	      });
	    }
	
	    // add promise support
	    ['createOffer', 'createAnswer'].forEach(function(method) {
	      var nativeMethod = webkitRTCPeerConnection.prototype[method];
	      webkitRTCPeerConnection.prototype[method] = function() {
	        var self = this;
	        if (arguments.length < 1 || (arguments.length === 1 &&
	            typeof(arguments[0]) === 'object')) {
	          var opts = arguments.length === 1 ? arguments[0] : undefined;
	          return new Promise(function(resolve, reject) {
	            nativeMethod.apply(self, [resolve, reject, opts]);
	          });
	        } else {
	          return nativeMethod.apply(this, arguments);
	        }
	      };
	    });
	
	    ['setLocalDescription', 'setRemoteDescription',
	        'addIceCandidate'].forEach(function(method) {
	      var nativeMethod = webkitRTCPeerConnection.prototype[method];
	      webkitRTCPeerConnection.prototype[method] = function() {
	        var args = arguments;
	        var self = this;
	        return new Promise(function(resolve, reject) {
	          nativeMethod.apply(self, [args[0],
	              function() {
	                resolve();
	                if (args.length >= 2) {
	                  args[1].apply(null, []);
	                }
	              },
	              function(err) {
	                reject(err);
	                if (args.length >= 3) {
	                  args[2].apply(null, [err]);
	                }
	              }]
	            );
	        });
	      };
	    });
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    if (browserDetails.version >= 43) {
	      element.srcObject = stream;
	    } else if (typeof element.src !== 'undefined') {
	      element.src = URL.createObjectURL(stream);
	    } else {
	      logging('Error attaching stream to element.');
	    }
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    if (browserDetails.version >= 43) {
	      to.srcObject = from.srcObject;
	    } else {
	      to.src = from.src;
	    }
	  }
	}
	
	
	// Expose public methods.
	module.e = {
	  shimOnTrack: chromeShim.shimOnTrack,
	  shimSourceObject: chromeShim.shimSourceObject,
	  shimPeerConnection: chromeShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(150),
	  attachMediaStream: chromeShim.attachMediaStream,
	  reattachMediaStream: chromeShim.reattachMediaStream
	};


/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	var logging = __webpack_require__(0).log;
	
	// Expose public methods.
	module.e = function() {
	  var constraintsToChrome_ = function(c) {
	    if (typeof c !== 'object' || c.mandatory || c.optional) {
	      return c;
	    }
	    var cc = {};
	    Object.keys(c).forEach(function(key) {
	      if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	        return;
	      }
	      var r = (typeof c[key] === 'object') ? c[key] : {ideal: c[key]};
	      if (r.exact !== undefined && typeof r.exact === 'number') {
	        r.min = r.max = r.exact;
	      }
	      var oldname_ = function(prefix, name) {
	        if (prefix) {
	          return prefix + name.charAt(0).toUpperCase() + name.slice(1);
	        }
	        return (name === 'deviceId') ? 'sourceId' : name;
	      };
	      if (r.ideal !== undefined) {
	        cc.optional = cc.optional || [];
	        var oc = {};
	        if (typeof r.ideal === 'number') {
	          oc[oldname_('min', key)] = r.ideal;
	          cc.optional.push(oc);
	          oc = {};
	          oc[oldname_('max', key)] = r.ideal;
	          cc.optional.push(oc);
	        } else {
	          oc[oldname_('', key)] = r.ideal;
	          cc.optional.push(oc);
	        }
	      }
	      if (r.exact !== undefined && typeof r.exact !== 'number') {
	        cc.mandatory = cc.mandatory || {};
	        cc.mandatory[oldname_('', key)] = r.exact;
	      } else {
	        ['min', 'max'].forEach(function(mix) {
	          if (r[mix] !== undefined) {
	            cc.mandatory = cc.mandatory || {};
	            cc.mandatory[oldname_(mix, key)] = r[mix];
	          }
	        });
	      }
	    });
	    if (c.advanced) {
	      cc.optional = (cc.optional || []).concat(c.advanced);
	    }
	    return cc;
	  };
	
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    if (constraints.audio) {
	      constraints.audio = constraintsToChrome_(constraints.audio);
	    }
	    if (constraints.video) {
	      constraints.video = constraintsToChrome_(constraints.video);
	    }
	    logging('chrome: ' + JSON.stringify(constraints));
	    return navigator.webkitGetUserMedia(constraints, onSuccess, onError);
	  };
	  navigator.getUserMedia = getUserMedia_;
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      navigator.getUserMedia(constraints, resolve, reject);
	    });
	  }
	
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	                             enumerateDevices: function() {
	      return new Promise(function(resolve) {
	        var kinds = {audio: 'audioinput', video: 'videoinput'};
	        return MediaStreamTrack.getSources(function(devices) {
	          resolve(devices.map(function(device) {
	            return {label: device.label,
	                    kind: kinds[device.kind],
	                    deviceId: device.id,
	                    groupId: ''};
	          }));
	        });
	      });
	    }};
	  }
	
	  // A shim for getUserMedia method on the mediaDevices object.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (!navigator.mediaDevices.getUserMedia) {
	    navigator.mediaDevices.getUserMedia = function(constraints) {
	      return getUserMediaPromise_(constraints);
	    };
	  } else {
	    // Even though Chrome 45 has navigator.mediaDevices and a getUserMedia
	    // function which returns a Promise, it does not accept spec-style
	    // constraints.
	    var origGetUserMedia = navigator.mediaDevices.getUserMedia.
	        bind(navigator.mediaDevices);
	    navigator.mediaDevices.getUserMedia = function(c) {
	      if (c) {
	        logging('spec:   ' + JSON.stringify(c)); // whitespace for alignment
	        c.audio = constraintsToChrome_(c.audio);
	        c.video = constraintsToChrome_(c.video);
	        logging('chrome: ' + JSON.stringify(c));
	      }
	      return origGetUserMedia(c);
	    }.bind(this);
	  }
	
	  // Dummy devicechange event methods.
	  // TODO(KaptenJansson) remove once implemented in Chrome stable.
	  if (typeof navigator.mediaDevices.addEventListener === 'undefined') {
	    navigator.mediaDevices.addEventListener = function() {
	      logging('Dummy mediaDevices.addEventListener called.');
	    };
	  }
	  if (typeof navigator.mediaDevices.removeEventListener === 'undefined') {
	    navigator.mediaDevices.removeEventListener = function() {
	      logging('Dummy mediaDevices.removeEventListener called.');
	    };
	  }
	};


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	// SDP helpers.
	var SDPUtils = {};
	
	// Generate an alphanumeric identifier for cname or mids.
	// TODO: use UUIDs instead? https://gist.github.com/jed/982883
	SDPUtils.generateIdentifier = function() {
	  return Math.random().toString(36).substr(2, 10);
	};
	
	// The RTCP CNAME used by all peerconnections from the same JS.
	SDPUtils.localCName = SDPUtils.generateIdentifier();
	
	
	// Splits SDP into lines, dealing with both CRLF and LF.
	SDPUtils.splitLines = function(blob) {
	  return blob.trim().split('\n').map(function(line) {
	    return line.trim();
	  });
	};
	// Splits SDP into sessionpart and mediasections. Ensures CRLF.
	SDPUtils.splitSections = function(blob) {
	  var parts = blob.split('\r\nm=');
	  return parts.map(function(part, index) {
	    return (index > 0 ? 'm=' + part : part).trim() + '\r\n';
	  });
	};
	
	// Returns lines that start with a certain prefix.
	SDPUtils.matchPrefix = function(blob, prefix) {
	  return SDPUtils.splitLines(blob).filter(function(line) {
	    return line.indexOf(prefix) === 0;
	  });
	};
	
	// Parses an ICE candidate line. Sample input:
	// candidate:702786350 2 udp 41819902 8.8.8.8 60769 typ relay raddr 8.8.8.8 rport 55996"
	SDPUtils.parseCandidate = function(line) {
	  var parts;
	  // Parse both variants.
	  if (line.indexOf('a=candidate:') === 0) {
	    parts = line.substring(12).split(' ');
	  } else {
	    parts = line.substring(10).split(' ');
	  }
	
	  var candidate = {
	    foundation: parts[0],
	    component: parts[1],
	    protocol: parts[2].toLowerCase(),
	    priority: parseInt(parts[3], 10),
	    ip: parts[4],
	    port: parseInt(parts[5], 10),
	    // skip parts[6] == 'typ'
	    type: parts[7]
	  };
	
	  for (var i = 8; i < parts.length; i += 2) {
	    switch (parts[i]) {
	      case 'raddr':
	        candidate.relatedAddress = parts[i + 1];
	        break;
	      case 'rport':
	        candidate.relatedPort = parseInt(parts[i + 1], 10);
	        break;
	      case 'tcptype':
	        candidate.tcpType = parts[i + 1];
	        break;
	      default: // Unknown extensions are silently ignored.
	        break;
	    }
	  }
	  return candidate;
	};
	
	// Translates a candidate object into SDP candidate attribute.
	SDPUtils.writeCandidate = function(candidate) {
	  var sdp = [];
	  sdp.push(candidate.foundation);
	  sdp.push(candidate.component);
	  sdp.push(candidate.protocol.toUpperCase());
	  sdp.push(candidate.priority);
	  sdp.push(candidate.ip);
	  sdp.push(candidate.port);
	
	  var type = candidate.type;
	  sdp.push('typ');
	  sdp.push(type);
	  if (type !== 'host' && candidate.relatedAddress &&
	      candidate.relatedPort) {
	    sdp.push('raddr');
	    sdp.push(candidate.relatedAddress); // was: relAddr
	    sdp.push('rport');
	    sdp.push(candidate.relatedPort); // was: relPort
	  }
	  if (candidate.tcpType && candidate.protocol.toLowerCase() === 'tcp') {
	    sdp.push('tcptype');
	    sdp.push(candidate.tcpType);
	  }
	  return 'candidate:' + sdp.join(' ');
	};
	
	// Parses an rtpmap line, returns RTCRtpCoddecParameters. Sample input:
	// a=rtpmap:111 opus/48000/2
	SDPUtils.parseRtpMap = function(line) {
	  var parts = line.substr(9).split(' ');
	  var parsed = {
	    payloadType: parseInt(parts.shift(), 10) // was: id
	  };
	
	  parts = parts[0].split('/');
	
	  parsed.name = parts[0];
	  parsed.clockRate = parseInt(parts[1], 10); // was: clockrate
	  parsed.numChannels = parts.length === 3 ? parseInt(parts[2], 10) : 1; // was: channels
	  return parsed;
	};
	
	// Generate an a=rtpmap line from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeRtpMap = function(codec) {
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  return 'a=rtpmap:' + pt + ' ' + codec.name + '/' + codec.clockRate +
	      (codec.numChannels !== 1 ? '/' + codec.numChannels : '') + '\r\n';
	};
	
	// Parses an ftmp line, returns dictionary. Sample input:
	// a=fmtp:96 vbr=on;cng=on
	// Also deals with vbr=on; cng=on
	SDPUtils.parseFmtp = function(line) {
	  var parsed = {};
	  var kv;
	  var parts = line.substr(line.indexOf(' ') + 1).split(';');
	  for (var j = 0; j < parts.length; j++) {
	    kv = parts[j].trim().split('=');
	    parsed[kv[0].trim()] = kv[1];
	  }
	  return parsed;
	};
	
	// Generates an a=ftmp line from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeFtmp = function(codec) {
	  var line = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.parameters && codec.parameters.length) {
	    var params = [];
	    Object.keys(codec.parameters).forEach(function(param) {
	      params.push(param + '=' + codec.parameters[param]);
	    });
	    line += 'a=fmtp:' + pt + ' ' + params.join(';') + '\r\n';
	  }
	  return line;
	};
	
	// Parses an rtcp-fb line, returns RTCPRtcpFeedback object. Sample input:
	// a=rtcp-fb:98 nack rpsi
	SDPUtils.parseRtcpFb = function(line) {
	  var parts = line.substr(line.indexOf(' ') + 1).split(' ');
	  return {
	    type: parts.shift(),
	    parameter: parts.join(' ')
	  };
	};
	// Generate a=rtcp-fb lines from RTCRtpCodecCapability or RTCRtpCodecParameters.
	SDPUtils.writeRtcpFb = function(codec) {
	  var lines = '';
	  var pt = codec.payloadType;
	  if (codec.preferredPayloadType !== undefined) {
	    pt = codec.preferredPayloadType;
	  }
	  if (codec.rtcpFeedback && codec.rtcpFeedback.length) {
	    // FIXME: special handling for trr-int?
	    codec.rtcpFeedback.forEach(function(fb) {
	      lines += 'a=rtcp-fb:' + pt + ' ' + fb.type + ' ' + fb.parameter +
	          '\r\n';
	    });
	  }
	  return lines;
	};
	
	// Parses an RFC 5576 ssrc media attribute. Sample input:
	// a=ssrc:3735928559 cname:something
	SDPUtils.parseSsrcMedia = function(line) {
	  var sp = line.indexOf(' ');
	  var parts = {
	    ssrc: line.substr(7, sp - 7),
	  };
	  var colon = line.indexOf(':', sp);
	  if (colon > -1) {
	    parts.attribute = line.substr(sp + 1, colon - sp - 1);
	    parts.value = line.substr(colon + 1);
	  } else {
	    parts.attribute = line.substr(sp + 1);
	  }
	  return parts;
	};
	
	// Extracts DTLS parameters from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the fingerprint line as input. See also getIceParameters.
	SDPUtils.getDtlsParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  lines = lines.concat(SDPUtils.splitLines(sessionpart)); // Search in session part, too.
	  var fpLine = lines.filter(function(line) {
	    return line.indexOf('a=fingerprint:') === 0;
	  })[0].substr(14);
	  // Note: a=setup line is ignored since we use the 'auto' role.
	  var dtlsParameters = {
	    role: 'auto',
	    fingerprints: [{
	      algorithm: fpLine.split(' ')[0],
	      value: fpLine.split(' ')[1]
	    }]
	  };
	  return dtlsParameters;
	};
	
	// Serializes DTLS parameters to SDP.
	SDPUtils.writeDtlsParameters = function(params, setupType) {
	  var sdp = 'a=setup:' + setupType + '\r\n';
	  params.fingerprints.forEach(function(fp) {
	    sdp += 'a=fingerprint:' + fp.algorithm + ' ' + fp.value + '\r\n';
	  });
	  return sdp;
	};
	// Parses ICE information from SDP media section or sessionpart.
	// FIXME: for consistency with other functions this should only
	//   get the ice-ufrag and ice-pwd lines as input.
	SDPUtils.getIceParameters = function(mediaSection, sessionpart) {
	  var lines = SDPUtils.splitLines(mediaSection);
	  lines = lines.concat(SDPUtils.splitLines(sessionpart)); // Search in session part, too.
	  var iceParameters = {
	    usernameFragment: lines.filter(function(line) {
	      return line.indexOf('a=ice-ufrag:') === 0;
	    })[0].substr(12),
	    password: lines.filter(function(line) {
	      return line.indexOf('a=ice-pwd:') === 0;
	    })[0].substr(10)
	  };
	  return iceParameters;
	};
	
	// Serializes ICE parameters to SDP.
	SDPUtils.writeIceParameters = function(params) {
	  return 'a=ice-ufrag:' + params.usernameFragment + '\r\n' +
	      'a=ice-pwd:' + params.password + '\r\n';
	};
	
	// Parses the SDP media section and returns RTCRtpParameters.
	SDPUtils.parseRtpParameters = function(mediaSection) {
	  var description = {
	    codecs: [],
	    headerExtensions: [],
	    fecMechanisms: [],
	    rtcp: []
	  };
	  var lines = SDPUtils.splitLines(mediaSection);
	  var mline = lines[0].split(' ');
	  for (var i = 3; i < mline.length; i++) { // find all codecs from mline[3..]
	    var pt = mline[i];
	    var rtpmapline = SDPUtils.matchPrefix(
	        mediaSection, 'a=rtpmap:' + pt + ' ')[0];
	    if (rtpmapline) {
	      var codec = SDPUtils.parseRtpMap(rtpmapline);
	      var fmtps = SDPUtils.matchPrefix(
	          mediaSection, 'a=fmtp:' + pt + ' ');
	      // Only the first a=fmtp:<pt> is considered.
	      codec.parameters = fmtps.length ? SDPUtils.parseFmtp(fmtps[0]) : {};
	      codec.rtcpFeedback = SDPUtils.matchPrefix(
	          mediaSection, 'a=rtcp-fb:' + pt + ' ')
	        .map(SDPUtils.parseRtcpFb);
	      description.codecs.push(codec);
	    }
	  }
	  // FIXME: parse headerExtensions, fecMechanisms and rtcp.
	  return description;
	};
	
	// Generates parts of the SDP media section describing the capabilities / parameters.
	SDPUtils.writeRtpDescription = function(kind, caps) {
	  var sdp = '';
	
	  // Build the mline.
	  sdp += 'm=' + kind + ' ';
	  sdp += caps.codecs.length > 0 ? '9' : '0'; // reject if no codecs.
	  sdp += ' UDP/TLS/RTP/SAVPF ';
	  sdp += caps.codecs.map(function(codec) {
	    if (codec.preferredPayloadType !== undefined) {
	      return codec.preferredPayloadType;
	    }
	    return codec.payloadType;
	  }).join(' ') + '\r\n';
	
	  sdp += 'c=IN IP4 0.0.0.0\r\n';
	  sdp += 'a=rtcp:9 IN IP4 0.0.0.0\r\n';
	
	  // Add a=rtpmap lines for each codec. Also fmtp and rtcp-fb.
	  caps.codecs.forEach(function(codec) {
	    sdp += SDPUtils.writeRtpMap(codec);
	    sdp += SDPUtils.writeFtmp(codec);
	    sdp += SDPUtils.writeRtcpFb(codec);
	  });
	  // FIXME: add headerExtensions, fecMechanismş and rtcp.
	  sdp += 'a=rtcp-mux\r\n';
	  return sdp;
	};
	
	SDPUtils.writeSessionBoilerplate = function() {
	  // FIXME: sess-id should be an NTP timestamp.
	  return 'v=0\r\n' +
	      'o=thisisadapterortc 8169639915646943137 2 IN IP4 127.0.0.1\r\n' +
	      's=-\r\n' +
	      't=0 0\r\n';
	};
	
	SDPUtils.writeMediaSection = function(transceiver, caps, type, stream) {
	  var sdp = SDPUtils.writeRtpDescription(transceiver.kind, caps);
	
	  // Map ICE parameters (ufrag, pwd) to SDP.
	  sdp += SDPUtils.writeIceParameters(
	      transceiver.iceGatherer.getLocalParameters());
	
	  // Map DTLS parameters to SDP.
	  sdp += SDPUtils.writeDtlsParameters(
	      transceiver.dtlsTransport.getLocalParameters(),
	      type === 'offer' ? 'actpass' : 'active');
	
	  sdp += 'a=mid:' + transceiver.mid + '\r\n';
	
	  if (transceiver.rtpSender && transceiver.rtpReceiver) {
	    sdp += 'a=sendrecv\r\n';
	  } else if (transceiver.rtpSender) {
	    sdp += 'a=sendonly\r\n';
	  } else if (transceiver.rtpReceiver) {
	    sdp += 'a=recvonly\r\n';
	  } else {
	    sdp += 'a=inactive\r\n';
	  }
	
	  // FIXME: for RTX there might be multiple SSRCs. Not implemented in Edge yet.
	  if (transceiver.rtpSender) {
	    var msid = 'msid:' + stream.id + ' ' +
	        transceiver.rtpSender.track.id + '\r\n';
	    sdp += 'a=' + msid;
	    sdp += 'a=ssrc:' + transceiver.sendSsrc + ' ' + msid;
	  }
	  // FIXME: this should be written by writeRtpDescription.
	  sdp += 'a=ssrc:' + transceiver.sendSsrc + ' cname:' +
	      SDPUtils.localCName + '\r\n';
	  return sdp;
	};
	
	// Gets the direction from the mediaSection or the sessionpart.
	SDPUtils.getDirection = function(mediaSection, sessionpart) {
	  // Look for sendrecv, sendonly, recvonly, inactive, default to sendrecv.
	  var lines = SDPUtils.splitLines(mediaSection);
	  for (var i = 0; i < lines.length; i++) {
	    switch (lines[i]) {
	      case 'a=sendrecv':
	      case 'a=sendonly':
	      case 'a=recvonly':
	      case 'a=inactive':
	        return lines[i].substr(2);
	    }
	  }
	  if (sessionpart) {
	    return SDPUtils.getDirection(sessionpart);
	  }
	  return 'sendrecv';
	};
	
	// Expose public methods.
	module.e = SDPUtils;


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var SDPUtils = __webpack_require__(151);
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var edgeShim = {
	  shimPeerConnection: function() {
	    if (window.RTCIceGatherer) {
	      // ORTC defines an RTCIceCandidate object but no constructor.
	      // Not implemented in Edge.
	      if (!window.RTCIceCandidate) {
	        window.RTCIceCandidate = function(args) {
	          return args;
	        };
	      }
	      // ORTC does not have a session description object but
	      // other browsers (i.e. Chrome) that will support both PC and ORTC
	      // in the future might have this defined already.
	      if (!window.RTCSessionDescription) {
	        window.RTCSessionDescription = function(args) {
	          return args;
	        };
	      }
	    }
	
	    window.RTCPeerConnection = function(config) {
	      var self = this;
	
	      var _eventTarget = document.createDocumentFragment();
	      ['addEventListener', 'removeEventListener', 'dispatchEvent'].forEach(
	          function(method) {
	        self[method] = _eventTarget[method].bind(_eventTarget);
	      });
	
	      this.onicecandidate = null;
	      this.onaddstream = null;
	      this.ontrack = null;
	      this.onremovestream = null;
	      this.onsignalingstatechange = null;
	      this.oniceconnectionstatechange = null;
	      this.onnegotiationneeded = null;
	      this.ondatachannel = null;
	
	      this.localStreams = [];
	      this.remoteStreams = [];
	      this.getLocalStreams = function() { return self.localStreams; };
	      this.getRemoteStreams = function() { return self.remoteStreams; };
	
	      this.localDescription = new RTCSessionDescription({
	        type: '',
	        sdp: ''
	      });
	      this.remoteDescription = new RTCSessionDescription({
	        type: '',
	        sdp: ''
	      });
	      this.signalingState = 'stable';
	      this.iceConnectionState = 'new';
	      this.iceGatheringState = 'new';
	
	      this.iceOptions = {
	        gatherPolicy: 'all',
	        iceServers: []
	      };
	      if (config && config.iceTransportPolicy) {
	        switch (config.iceTransportPolicy) {
	          case 'all':
	          case 'relay':
	            this.iceOptions.gatherPolicy = config.iceTransportPolicy;
	            break;
	          case 'none':
	            // FIXME: remove once implementation and spec have added this.
	            throw new TypeError('iceTransportPolicy "none" not supported');
	        }
	      }
	      if (config && config.iceServers) {
	        // Edge does not like
	        // 1) stun:
	        // 2) turn: that does not have all of turn:host:port?transport=udp
	        this.iceOptions.iceServers = config.iceServers.filter(function(server) {
	          if (server && server.urls) {
	            server.urls = server.urls.filter(function(url) {
	              return url.indexOf('transport=udp') !== -1;
	            })[0];
	            return true;
	          }
	          return false;
	        });
	      }
	
	      // per-track iceGathers, iceTransports, dtlsTransports, rtpSenders, ...
	      // everything that is needed to describe a SDP m-line.
	      this.transceivers = [];
	
	      // since the iceGatherer is currently created in createOffer but we
	      // must not emit candidates until after setLocalDescription we buffer
	      // them in this array.
	      this._localIceCandidatesBuffer = [];
	    };
	
	    window.RTCPeerConnection.prototype._emitBufferedCandidates = function() {
	      var self = this;
	      var sections = SDPUtils.splitSections(self.localDescription.sdp);
	      // FIXME: need to apply ice candidates in a way which is async but in-order
	      this._localIceCandidatesBuffer.forEach(function(event) {
	        var end = !event.candidate || Object.keys(event.candidate).length == 0;
	        if (end) {
	          for (var j = 1; j < sections.length; j++) {
	            sections[j] += 'a=end-of-candidates\r\n';
	          }
	        } else {
	          sections[event.candidate.sdpMLineIndex + 1] +=
	              'a=' + event.candidate.candidate + '\r\n';
	        }
	        self.dispatchEvent(event);
	        if (self.onicecandidate !== null) {
	          self.onicecandidate(event);
	        }
	        if (!event.candidate) {
	          self.iceGatheringState = 'complete';
	        }
	      });
	      this._localIceCandidatesBuffer = [];
	      this.localDescription.sdp = sections.join('');
	    };
	
	    window.RTCPeerConnection.prototype.addStream = function(stream) {
	      // Clone is necessary for local demos mostly, attaching directly
	      // to two different senders does not work (build 10547).
	      this.localStreams.push(stream.clone());
	      this._maybeFireNegotiationNeeded();
	    };
	
	    window.RTCPeerConnection.prototype.removeStream = function(stream) {
	      var idx = this.localStreams.indexOf(stream);
	      if (idx > -1) {
	        this.localStreams.splice(idx, 1);
	        this._maybeFireNegotiationNeeded();
	      }
	    };
	
	    // Determines the intersection of local and remote capabilities.
	    window.RTCPeerConnection.prototype._getCommonCapabilities =
	        function(localCapabilities, remoteCapabilities) {
	      var commonCapabilities = {
	        codecs: [],
	        headerExtensions: [],
	        fecMechanisms: []
	      };
	      localCapabilities.codecs.forEach(function(lCodec) {
	        for (var i = 0; i < remoteCapabilities.codecs.length; i++) {
	          var rCodec = remoteCapabilities.codecs[i];
	          if (lCodec.name.toLowerCase() === rCodec.name.toLowerCase() &&
	              lCodec.clockRate === rCodec.clockRate &&
	              lCodec.numChannels === rCodec.numChannels) {
	            // push rCodec so we reply with offerer payload type
	            commonCapabilities.codecs.push(rCodec);
	
	            // FIXME: also need to determine intersection between
	            // .rtcpFeedback and .parameters
	            break;
	          }
	        }
	      });
	
	      localCapabilities.headerExtensions.forEach(function(lHeaderExtension) {
	        for (var i = 0; i < remoteCapabilities.headerExtensions.length; i++) {
	          var rHeaderExtension = remoteCapabilities.headerExtensions[i];
	          if (lHeaderExtension.uri === rHeaderExtension.uri) {
	            commonCapabilities.headerExtensions.push(rHeaderExtension);
	            break;
	          }
	        }
	      });
	
	      // FIXME: fecMechanisms
	      return commonCapabilities;
	    };
	
	    // Create ICE gatherer, ICE transport and DTLS transport.
	    window.RTCPeerConnection.prototype._createIceAndDtlsTransports =
	        function(mid, sdpMLineIndex) {
	      var self = this;
	      var iceGatherer = new RTCIceGatherer(self.iceOptions);
	      var iceTransport = new RTCIceTransport(iceGatherer);
	      iceGatherer.onlocalcandidate = function(evt) {
	        var event = new Event('icecandidate');
	        event.candidate = {sdpMid: mid, sdpMLineIndex: sdpMLineIndex};
	
	        var cand = evt.candidate;
	        var end = !cand || Object.keys(cand).length === 0;
	        // Edge emits an empty object for RTCIceCandidateComplete‥
	        if (end) {
	          // polyfill since RTCIceGatherer.state is not implemented in Edge 10547 yet.
	          if (iceGatherer.state === undefined) {
	            iceGatherer.state = 'completed';
	          }
	
	          // Emit a candidate with type endOfCandidates to make the samples work.
	          // Edge requires addIceCandidate with this empty candidate to start checking.
	          // The real solution is to signal end-of-candidates to the other side when
	          // getting the null candidate but some apps (like the samples) don't do that.
	          event.candidate.candidate =
	              'candidate:1 1 udp 1 0.0.0.0 9 typ endOfCandidates';
	        } else {
	          // RTCIceCandidate doesn't have a component, needs to be added
	          cand.component = iceTransport.component === 'RTCP' ? 2 : 1;
	          event.candidate.candidate = SDPUtils.writeCandidate(cand);
	        }
	
	        var complete = self.transceivers.every(function(transceiver) {
	          return transceiver.iceGatherer &&
	              transceiver.iceGatherer.state === 'completed';
	        });
	        // update .localDescription with candidate and (potentially) end-of-candidates.
	        //     To make this harder, the gatherer might emit candidates before localdescription
	        //     is set. To make things worse, gather.getLocalCandidates still errors in
	        //     Edge 10547 when no candidates have been gathered yet.
	        if (self.localDescription && self.localDescription.type !== '') {
	          var sections = SDPUtils.splitSections(self.localDescription.sdp);
	          sections[sdpMLineIndex + 1] += (!end ? 'a=' + event.candidate.candidate :
	              'a=end-of-candidates') + '\r\n';
	          self.localDescription.sdp = sections.join('');
	        }
	
	        // Emit candidate if localDescription is set.
	        // Also emits null candidate when all gatherers are complete.
	        switch(self.iceGatheringState) {
	        case 'new':
	          self._localIceCandidatesBuffer.push(event);
	          if (complete) {
	            self._localIceCandidatesBuffer.push(new Event('icecandidate'));
	          }
	          break;
	        case 'gathering':
	          self._emitBufferedCandidates();
	          self.dispatchEvent(event);
	          if (self.onicecandidate !== null) {
	            self.onicecandidate(event);
	          }
	          if (complete) {
	            self.dispatchEvent(new Event('icecandidate'));
	            if (self.onicecandidate !== null) {
	              self.onicecandidate(new Event('icecandidate'));
	            }
	            self.iceGatheringState = 'complete';
	          }
	          break;
	        case 'complete':
	          // should not happen... currently!
	          break;
	        }
	      };
	      iceTransport.onicestatechange = function() {
	        self._updateConnectionState();
	      };
	
	      var dtlsTransport = new RTCDtlsTransport(iceTransport);
	      dtlsTransport.ondtlsstatechange = function() {
	        self._updateConnectionState();
	      };
	      dtlsTransport.onerror = function() {
	        // onerror does not set state to failed by itself.
	        dtlsTransport.state = 'failed';
	        self._updateConnectionState();
	      };
	
	      return {
	        iceGatherer: iceGatherer,
	        iceTransport: iceTransport,
	        dtlsTransport: dtlsTransport
	      };
	    };
	
	    // Start the RTP Sender and Receiver for a transceiver.
	    window.RTCPeerConnection.prototype._transceive = function(transceiver,
	        send, recv) {
	      var params = this._getCommonCapabilities(transceiver.localCapabilities,
	          transceiver.remoteCapabilities);
	      if (send && transceiver.rtpSender) {
	        params.encodings = [{
	          ssrc: transceiver.sendSsrc
	        }];
	        params.rtcp = {
	          cname: SDPUtils.localCName,
	          ssrc: transceiver.recvSsrc
	        };
	        transceiver.rtpSender.send(params);
	      }
	      if (recv && transceiver.rtpReceiver) {
	        params.encodings = [{
	          ssrc: transceiver.recvSsrc
	        }];
	        params.rtcp = {
	          cname: transceiver.cname,
	          ssrc: transceiver.sendSsrc
	        };
	        transceiver.rtpReceiver.receive(params);
	      }
	    };
	
	    window.RTCPeerConnection.prototype.setLocalDescription =
	        function(description) {
	      var self = this;
	      if (description.type === 'offer') {
	        if (!this._pendingOffer) {
	        } else {
	          this.transceivers = this._pendingOffer;
	          delete this._pendingOffer;
	        }
	      } else if (description.type === 'answer') {
	        var sections = SDPUtils.splitSections(self.remoteDescription.sdp);
	        var sessionpart = sections.shift();
	        sections.forEach(function(mediaSection, sdpMLineIndex) {
	          var transceiver = self.transceivers[sdpMLineIndex];
	          var iceGatherer = transceiver.iceGatherer;
	          var iceTransport = transceiver.iceTransport;
	          var dtlsTransport = transceiver.dtlsTransport;
	          var localCapabilities = transceiver.localCapabilities;
	          var remoteCapabilities = transceiver.remoteCapabilities;
	          var rejected = mediaSection.split('\n', 1)[0]
	              .split(' ', 2)[1] === '0';
	
	          if (!rejected) {
	            var remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
	                sessionpart);
	            iceTransport.start(iceGatherer, remoteIceParameters, 'controlled');
	
	            var remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
	              sessionpart);
	            dtlsTransport.start(remoteDtlsParameters);
	
	            // Calculate intersection of capabilities.
	            var params = self._getCommonCapabilities(localCapabilities,
	                remoteCapabilities);
	
	            // Start the RTCRtpSender. The RTCRtpReceiver for this transceiver
	            // has already been started in setRemoteDescription.
	            self._transceive(transceiver,
	                params.codecs.length > 0,
	                false);
	          }
	        });
	      }
	
	      this.localDescription = {
	        type: description.type,
	        sdp: description.sdp
	      };
	      switch (description.type) {
	        case 'offer':
	          this._updateSignalingState('have-local-offer');
	          break;
	        case 'answer':
	          this._updateSignalingState('stable');
	          break;
	        default:
	          throw new TypeError('unsupported type "' + description.type + '"');
	      }
	
	      // If a success callback was provided, emit ICE candidates after it has been
	      // executed. Otherwise, emit callback after the Promise is resolved.
	      var hasCallback = arguments.length > 1 &&
	        typeof arguments[1] === 'function';
	      if (hasCallback) {
	        var cb = arguments[1];
	        window.setTimeout(function() {
	          cb();
	          if (self.iceGatheringState === 'new') {
	            self.iceGatheringState = 'gathering';
	          }
	          self._emitBufferedCandidates();
	        }, 0);
	      }
	      var p = Promise.resolve();
	      p.then(function() {
	        if (!hasCallback) {
	          if (self.iceGatheringState === 'new') {
	            self.iceGatheringState = 'gathering';
	          }
	          // Usually candidates will be emitted earlier.
	          window.setTimeout(self._emitBufferedCandidates.bind(self), 500);
	        }
	      });
	      return p;
	    };
	
	    window.RTCPeerConnection.prototype.setRemoteDescription =
	        function(description) {
	      var self = this;
	      var stream = new MediaStream();
	      var receiverList = [];
	      var sections = SDPUtils.splitSections(description.sdp);
	      var sessionpart = sections.shift();
	      sections.forEach(function(mediaSection, sdpMLineIndex) {
	        var lines = SDPUtils.splitLines(mediaSection);
	        var mline = lines[0].substr(2).split(' ');
	        var kind = mline[0];
	        var rejected = mline[1] === '0';
	        var direction = SDPUtils.getDirection(mediaSection, sessionpart);
	
	        var transceiver;
	        var iceGatherer;
	        var iceTransport;
	        var dtlsTransport;
	        var rtpSender;
	        var rtpReceiver;
	        var sendSsrc;
	        var recvSsrc;
	        var localCapabilities;
	
	        var track;
	        // FIXME: ensure the mediaSection has rtcp-mux set.
	        var remoteCapabilities = SDPUtils.parseRtpParameters(mediaSection);
	        var remoteIceParameters;
	        var remoteDtlsParameters;
	        if (!rejected) {
	          remoteIceParameters = SDPUtils.getIceParameters(mediaSection,
	              sessionpart);
	          remoteDtlsParameters = SDPUtils.getDtlsParameters(mediaSection,
	              sessionpart);
	        }
	        var mid = SDPUtils.matchPrefix(mediaSection, 'a=mid:')[0].substr(6);
	
	        var cname;
	        // Gets the first SSRC. Note that with RTX there might be multiple SSRCs.
	        var remoteSsrc = SDPUtils.matchPrefix(mediaSection, 'a=ssrc:')
	            .map(function(line) {
	              return SDPUtils.parseSsrcMedia(line);
	            })
	            .filter(function(obj) {
	              return obj.attribute === 'cname';
	            })[0];
	        if (remoteSsrc) {
	          recvSsrc = parseInt(remoteSsrc.ssrc, 10);
	          cname = remoteSsrc.value;
	        }
	
	        if (description.type === 'offer') {
	          var transports = self._createIceAndDtlsTransports(mid, sdpMLineIndex);
	
	          localCapabilities = RTCRtpReceiver.getCapabilities(kind);
	          sendSsrc = (2 * sdpMLineIndex + 2) * 1001;
	
	          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
	
	          track = rtpReceiver.track;
	          receiverList.push([track, rtpReceiver]);
	          // FIXME: not correct when there are multiple streams but that is
	          // not currently supported in this shim.
	          stream.addTrack(track);
	
	          // FIXME: look at direction.
	          if (self.localStreams.length > 0 &&
	              self.localStreams[0].getTracks().length >= sdpMLineIndex) {
	            // FIXME: actually more complicated, needs to match types etc
	            var localtrack = self.localStreams[0].getTracks()[sdpMLineIndex];
	            rtpSender = new RTCRtpSender(localtrack, transports.dtlsTransport);
	          }
	
	          self.transceivers[sdpMLineIndex] = {
	            iceGatherer: transports.iceGatherer,
	            iceTransport: transports.iceTransport,
	            dtlsTransport: transports.dtlsTransport,
	            localCapabilities: localCapabilities,
	            remoteCapabilities: remoteCapabilities,
	            rtpSender: rtpSender,
	            rtpReceiver: rtpReceiver,
	            kind: kind,
	            mid: mid,
	            cname: cname,
	            sendSsrc: sendSsrc,
	            recvSsrc: recvSsrc
	          };
	          // Start the RTCRtpReceiver now. The RTPSender is started in setLocalDescription.
	          self._transceive(self.transceivers[sdpMLineIndex],
	              false,
	              direction === 'sendrecv' || direction === 'sendonly');
	        } else if (description.type === 'answer' && !rejected) {
	          transceiver = self.transceivers[sdpMLineIndex];
	          iceGatherer = transceiver.iceGatherer;
	          iceTransport = transceiver.iceTransport;
	          dtlsTransport = transceiver.dtlsTransport;
	          rtpSender = transceiver.rtpSender;
	          rtpReceiver = transceiver.rtpReceiver;
	          sendSsrc = transceiver.sendSsrc;
	          //recvSsrc = transceiver.recvSsrc;
	          localCapabilities = transceiver.localCapabilities;
	
	          self.transceivers[sdpMLineIndex].recvSsrc = recvSsrc;
	          self.transceivers[sdpMLineIndex].remoteCapabilities =
	              remoteCapabilities;
	          self.transceivers[sdpMLineIndex].cname = cname;
	
	          iceTransport.start(iceGatherer, remoteIceParameters, 'controlling');
	          dtlsTransport.start(remoteDtlsParameters);
	
	          self._transceive(transceiver,
	              direction === 'sendrecv' || direction === 'recvonly',
	              direction === 'sendrecv' || direction === 'sendonly');
	
	          if (rtpReceiver &&
	              (direction === 'sendrecv' || direction === 'sendonly')) {
	            track = rtpReceiver.track;
	            receiverList.push([track, rtpReceiver]);
	            stream.addTrack(track);
	          } else {
	            // FIXME: actually the receiver should be created later.
	            delete transceiver.rtpReceiver;
	          }
	        }
	      });
	
	      this.remoteDescription = {
	          type: description.type,
	          sdp: description.sdp
	      };
	      switch (description.type) {
	        case 'offer':
	          this._updateSignalingState('have-remote-offer');
	          break;
	        case 'answer':
	          this._updateSignalingState('stable');
	          break;
	        default:
	          throw new TypeError('unsupported type "' + description.type + '"');
	      }
	      if (stream.getTracks().length) {
	        self.remoteStreams.push(stream);
	        window.setTimeout(function() {
	          var event = new Event('addstream');
	          event.stream = stream;
	          self.dispatchEvent(event);
	          if (self.onaddstream !== null) {
	            window.setTimeout(function() {
	              self.onaddstream(event);
	            }, 0);
	          }
	
	          receiverList.forEach(function(item) {
	            var track = item[0];
	            var receiver = item[1];
	            var event = new Event('track');
	            event.track = track;
	            event.receiver = receiver;
	            event.streams = [stream];
	            self.dispatchEvent(event);
	            if (self.ontrack !== null) {
	                window.setTimeout(function() {
	                  self.ontrack(event);
	                }, 0);
	            }
	          });
	        }, 0);
	      }
	      if (arguments.length > 1 && typeof arguments[1] === 'function') {
	        window.setTimeout(arguments[1], 0);
	      }
	      return Promise.resolve();
	    };
	
	    window.RTCPeerConnection.prototype.close = function() {
	      this.transceivers.forEach(function(transceiver) {
	        /* not yet
	        if (transceiver.iceGatherer) {
	          transceiver.iceGatherer.close();
	        }
	        */
	        if (transceiver.iceTransport) {
	          transceiver.iceTransport.stop();
	        }
	        if (transceiver.dtlsTransport) {
	          transceiver.dtlsTransport.stop();
	        }
	        if (transceiver.rtpSender) {
	          transceiver.rtpSender.stop();
	        }
	        if (transceiver.rtpReceiver) {
	          transceiver.rtpReceiver.stop();
	        }
	      });
	      // FIXME: clean up tracks, local streams, remote streams, etc
	      this._updateSignalingState('closed');
	    };
	
	    // Update the signaling state.
	    window.RTCPeerConnection.prototype._updateSignalingState =
	        function(newState) {
	      this.signalingState = newState;
	      var event = new Event('signalingstatechange');
	      this.dispatchEvent(event);
	      if (this.onsignalingstatechange !== null) {
	        this.onsignalingstatechange(event);
	      }
	    };
	
	    // Determine whether to fire the negotiationneeded event.
	    window.RTCPeerConnection.prototype._maybeFireNegotiationNeeded =
	        function() {
	      // Fire away (for now).
	      var event = new Event('negotiationneeded');
	      this.dispatchEvent(event);
	      if (this.onnegotiationneeded !== null) {
	        this.onnegotiationneeded(event);
	      }
	    };
	
	    // Update the connection state.
	    window.RTCPeerConnection.prototype._updateConnectionState =
	        function() {
	      var self = this;
	      var newState;
	      var states = {
	        'new': 0,
	        closed: 0,
	        connecting: 0,
	        checking: 0,
	        connected: 0,
	        completed: 0,
	        failed: 0
	      };
	      this.transceivers.forEach(function(transceiver) {
	        states[transceiver.iceTransport.state]++;
	        states[transceiver.dtlsTransport.state]++;
	      });
	      // ICETransport.completed and connected are the same for this purpose.
	      states['connected'] += states['completed'];
	
	      newState = 'new';
	      if (states['failed'] > 0) {
	        newState = 'failed';
	      } else if (states['connecting'] > 0 || states['checking'] > 0) {
	        newState = 'connecting';
	      } else if (states['disconnected'] > 0) {
	        newState = 'disconnected';
	      } else if (states['new'] > 0) {
	        newState = 'new';
	      } else if (states['connecting'] > 0 || states['completed'] > 0) {
	        newState = 'connected';
	      }
	
	      if (newState !== self.iceConnectionState) {
	        self.iceConnectionState = newState;
	        var event = new Event('iceconnectionstatechange');
	        this.dispatchEvent(event);
	        if (this.oniceconnectionstatechange !== null) {
	          this.oniceconnectionstatechange(event);
	        }
	      }
	    };
	
	    window.RTCPeerConnection.prototype.createOffer = function() {
	      var self = this;
	      if (this._pendingOffer) {
	        throw new Error('createOffer called while there is a pending offer.');
	      }
	      var offerOptions;
	      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
	        offerOptions = arguments[0];
	      } else if (arguments.length === 3) {
	        offerOptions = arguments[2];
	      }
	
	      var tracks = [];
	      var numAudioTracks = 0;
	      var numVideoTracks = 0;
	      // Default to sendrecv.
	      if (this.localStreams.length) {
	        numAudioTracks = this.localStreams[0].getAudioTracks().length;
	        numVideoTracks = this.localStreams[0].getVideoTracks().length;
	      }
	      // Determine number of audio and video tracks we need to send/recv.
	      if (offerOptions) {
	        // Reject Chrome legacy constraints.
	        if (offerOptions.mandatory || offerOptions.optional) {
	          throw new TypeError(
	              'Legacy mandatory/optional constraints not supported.');
	        }
	        if (offerOptions.offerToReceiveAudio !== undefined) {
	          numAudioTracks = offerOptions.offerToReceiveAudio;
	        }
	        if (offerOptions.offerToReceiveVideo !== undefined) {
	          numVideoTracks = offerOptions.offerToReceiveVideo;
	        }
	      }
	      if (this.localStreams.length) {
	        // Push local streams.
	        this.localStreams[0].getTracks().forEach(function(track) {
	          tracks.push({
	            kind: track.kind,
	            track: track,
	            wantReceive: track.kind === 'audio' ?
	                numAudioTracks > 0 : numVideoTracks > 0
	          });
	          if (track.kind === 'audio') {
	            numAudioTracks--;
	          } else if (track.kind === 'video') {
	            numVideoTracks--;
	          }
	        });
	      }
	      // Create M-lines for recvonly streams.
	      while (numAudioTracks > 0 || numVideoTracks > 0) {
	        if (numAudioTracks > 0) {
	          tracks.push({
	            kind: 'audio',
	            wantReceive: true
	          });
	          numAudioTracks--;
	        }
	        if (numVideoTracks > 0) {
	          tracks.push({
	            kind: 'video',
	            wantReceive: true
	          });
	          numVideoTracks--;
	        }
	      }
	
	      var sdp = SDPUtils.writeSessionBoilerplate();
	      var transceivers = [];
	      tracks.forEach(function(mline, sdpMLineIndex) {
	        // For each track, create an ice gatherer, ice transport, dtls transport,
	        // potentially rtpsender and rtpreceiver.
	        var track = mline.track;
	        var kind = mline.kind;
	        var mid = SDPUtils.generateIdentifier();
	
	        var transports = self._createIceAndDtlsTransports(mid, sdpMLineIndex);
	
	        var localCapabilities = RTCRtpSender.getCapabilities(kind);
	        var rtpSender;
	        var rtpReceiver;
	
	        // generate an ssrc now, to be used later in rtpSender.send
	        var sendSsrc = (2 * sdpMLineIndex + 1) * 1001;
	        if (track) {
	          rtpSender = new RTCRtpSender(track, transports.dtlsTransport);
	        }
	
	        if (mline.wantReceive) {
	          rtpReceiver = new RTCRtpReceiver(transports.dtlsTransport, kind);
	        }
	
	        transceivers[sdpMLineIndex] = {
	          iceGatherer: transports.iceGatherer,
	          iceTransport: transports.iceTransport,
	          dtlsTransport: transports.dtlsTransport,
	          localCapabilities: localCapabilities,
	          remoteCapabilities: null,
	          rtpSender: rtpSender,
	          rtpReceiver: rtpReceiver,
	          kind: kind,
	          mid: mid,
	          sendSsrc: sendSsrc,
	          recvSsrc: null
	        };
	        var transceiver = transceivers[sdpMLineIndex];
	        sdp += SDPUtils.writeMediaSection(transceiver,
	            transceiver.localCapabilities, 'offer', self.localStreams[0]);
	      });
	
	      this._pendingOffer = transceivers;
	      var desc = new RTCSessionDescription({
	        type: 'offer',
	        sdp: sdp
	      });
	      if (arguments.length && typeof arguments[0] === 'function') {
	        window.setTimeout(arguments[0], 0, desc);
	      }
	      return Promise.resolve(desc);
	    };
	
	    window.RTCPeerConnection.prototype.createAnswer = function() {
	      var self = this;
	      var answerOptions;
	      if (arguments.length === 1 && typeof arguments[0] !== 'function') {
	        answerOptions = arguments[0];
	      } else if (arguments.length === 3) {
	        answerOptions = arguments[2];
	      }
	
	      var sdp = SDPUtils.writeSessionBoilerplate();
	      this.transceivers.forEach(function(transceiver) {
	        // Calculate intersection of capabilities.
	        var commonCapabilities = self._getCommonCapabilities(
	            transceiver.localCapabilities,
	            transceiver.remoteCapabilities);
	
	        sdp += SDPUtils.writeMediaSection(transceiver, commonCapabilities,
	            'answer', self.localStreams[0]);
	      });
	
	      var desc = new RTCSessionDescription({
	        type: 'answer',
	        sdp: sdp
	      });
	      if (arguments.length && typeof arguments[0] === 'function') {
	        window.setTimeout(arguments[0], 0, desc);
	      }
	      return Promise.resolve(desc);
	    };
	
	    window.RTCPeerConnection.prototype.addIceCandidate = function(candidate) {
	      var mLineIndex = candidate.sdpMLineIndex;
	      if (candidate.sdpMid) {
	        for (var i = 0; i < this.transceivers.length; i++) {
	          if (this.transceivers[i].mid === candidate.sdpMid) {
	            mLineIndex = i;
	            break;
	          }
	        }
	      }
	      var transceiver = this.transceivers[mLineIndex];
	      if (transceiver) {
	        var cand = Object.keys(candidate.candidate).length > 0 ?
	            SDPUtils.parseCandidate(candidate.candidate) : {};
	        // Ignore Chrome's invalid candidates since Edge does not like them.
	        if (cand.protocol === 'tcp' && cand.port === 0) {
	          return;
	        }
	        // Ignore RTCP candidates, we assume RTCP-MUX.
	        if (cand.component !== '1') {
	          return;
	        }
	        // A dirty hack to make samples work.
	        if (cand.type === 'endOfCandidates') {
	          cand = {};
	        }
	        transceiver.iceTransport.addRemoteCandidate(cand);
	
	        // update the remoteDescription.
	        var sections = SDPUtils.splitSections(this.remoteDescription.sdp);
	        sections[mLineIndex + 1] += (cand.type ? candidate.candidate.trim()
	            : 'a=end-of-candidates') + '\r\n';
	        this.remoteDescription.sdp = sections.join('');
	      }
	      if (arguments.length > 1 && typeof arguments[1] === 'function') {
	        window.setTimeout(arguments[1], 0);
	      }
	      return Promise.resolve();
	    };
	
	    window.RTCPeerConnection.prototype.getStats = function() {
	      var promises = [];
	      this.transceivers.forEach(function(transceiver) {
	        ['rtpSender', 'rtpReceiver', 'iceGatherer', 'iceTransport',
	            'dtlsTransport'].forEach(function(method) {
	          if (transceiver[method]) {
	            promises.push(transceiver[method].getStats());
	          }
	        });
	      });
	      var cb = arguments.length > 1 && typeof arguments[1] === 'function' &&
	          arguments[1];
	      return new Promise(function(resolve) {
	        var results = {};
	        Promise.all(promises).then(function(res) {
	          res.forEach(function(result) {
	            Object.keys(result).forEach(function(id) {
	              results[id] = result[id];
	            });
	          });
	          if (cb) {
	            window.setTimeout(cb, 0, results);
	          }
	          resolve(results);
	        });
	      });
	    };
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    element.srcObject = stream;
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    to.srcObject = from.srcObject;
	  }
	}
	
	// Expose public methods.
	module.e = {
	  shimPeerConnection: edgeShim.shimPeerConnection,
	  attachMediaStream: edgeShim.attachMediaStream,
	  reattachMediaStream: edgeShim.reattachMediaStream
	}
	


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	var firefoxShim = {
	  shimOnTrack: function() {
	    if (typeof window === 'object' && window.RTCPeerConnection && !('ontrack' in
	        window.RTCPeerConnection.prototype)) {
	      Object.defineProperty(window.RTCPeerConnection.prototype, 'ontrack', {
	        get: function() { return this._ontrack; },
	        set: function(f) {
	          var self = this;
	          if (this._ontrack) {
	            this.removeEventListener('track', this._ontrack);
	            this.removeEventListener('addstream', this._ontrackpoly);
	          }
	          this.addEventListener('track', this._ontrack = f);
	          this.addEventListener('addstream', this._ontrackpoly = function(e) {
	            e.stream.getTracks().forEach(function(track) {
	              var event = new Event('track');
	              event.track = track;
	              event.receiver = {track: track};
	              event.streams = [e.stream];
	              this.dispatchEvent(event);
	            }.bind(this));
	          }.bind(this));
	        }
	      });
	    }
	  },
	
	  shimSourceObject: function() {
	    // Firefox has supported mozSrcObject since FF22, unprefixed in 42.
	    if (typeof window === 'object') {
	      if (window.HTMLMediaElement &&
	        !('srcObject' in window.HTMLMediaElement.prototype)) {
	        // Shim the srcObject property, once, when HTMLMediaElement is found.
	        Object.defineProperty(window.HTMLMediaElement.prototype, 'srcObject', {
	          get: function() {
	            return this.mozSrcObject;
	          },
	          set: function(stream) {
	            this.mozSrcObject = stream;
	          }
	        });
	      }
	    }
	  },
	
	  shimPeerConnection: function() {
	    // The RTCPeerConnection object.
	    if (!window.RTCPeerConnection) {
	      window.RTCPeerConnection = function(pcConfig, pcConstraints) {
	        if (browserDetails.version < 38) {
	          // .urls is not supported in FF < 38.
	          // create RTCIceServers with a single url.
	          if (pcConfig && pcConfig.iceServers) {
	            var newIceServers = [];
	            for (var i = 0; i < pcConfig.iceServers.length; i++) {
	              var server = pcConfig.iceServers[i];
	              if (server.hasOwnProperty('urls')) {
	                for (var j = 0; j < server.urls.length; j++) {
	                  var newServer = {
	                    url: server.urls[j]
	                  };
	                  if (server.urls[j].indexOf('turn') === 0) {
	                    newServer.username = server.username;
	                    newServer.credential = server.credential;
	                  }
	                  newIceServers.push(newServer);
	                }
	              } else {
	                newIceServers.push(pcConfig.iceServers[i]);
	              }
	            }
	            pcConfig.iceServers = newIceServers;
	          }
	        }
	        return new mozRTCPeerConnection(pcConfig, pcConstraints); // jscs:ignore requireCapitalizedConstructors
	      };
	      window.RTCPeerConnection.prototype = mozRTCPeerConnection.prototype;
	
	      // wrap static methods. Currently just generateCertificate.
	      if (mozRTCPeerConnection.generateCertificate) {
	        Object.defineProperty(window.RTCPeerConnection, 'generateCertificate', {
	          get: function() {
	            if (arguments.length) {
	              return mozRTCPeerConnection.generateCertificate.apply(null,
	                  arguments);
	            } else {
	              return mozRTCPeerConnection.generateCertificate;
	            }
	          }
	        });
	      }
	
	      window.RTCSessionDescription = mozRTCSessionDescription;
	      window.RTCIceCandidate = mozRTCIceCandidate;
	    }
	  },
	
	  shimGetUserMedia: function() {
	    // getUserMedia constraints shim.
	    var getUserMedia_ = function(constraints, onSuccess, onError) {
	      var constraintsToFF37_ = function(c) {
	        if (typeof c !== 'object' || c.require) {
	          return c;
	        }
	        var require = [];
	        Object.keys(c).forEach(function(key) {
	          if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	            return;
	          }
	          var r = c[key] = (typeof c[key] === 'object') ?
	              c[key] : {ideal: c[key]};
	          if (r.min !== undefined ||
	              r.max !== undefined || r.exact !== undefined) {
	            require.push(key);
	          }
	          if (r.exact !== undefined) {
	            if (typeof r.exact === 'number') {
	              r. min = r.max = r.exact;
	            } else {
	              c[key] = r.exact;
	            }
	            delete r.exact;
	          }
	          if (r.ideal !== undefined) {
	            c.advanced = c.advanced || [];
	            var oc = {};
	            if (typeof r.ideal === 'number') {
	              oc[key] = {min: r.ideal, max: r.ideal};
	            } else {
	              oc[key] = r.ideal;
	            }
	            c.advanced.push(oc);
	            delete r.ideal;
	            if (!Object.keys(r).length) {
	              delete c[key];
	            }
	          }
	        });
	        if (require.length) {
	          c.require = require;
	        }
	        return c;
	      };
	      if (browserDetails.version < 38) {
	        logging('spec: ' + JSON.stringify(constraints));
	        if (constraints.audio) {
	          constraints.audio = constraintsToFF37_(constraints.audio);
	        }
	        if (constraints.video) {
	          constraints.video = constraintsToFF37_(constraints.video);
	        }
	        logging('ff37: ' + JSON.stringify(constraints));
	      }
	      return navigator.mozGetUserMedia(constraints, onSuccess, onError);
	    };
	
	    navigator.getUserMedia = getUserMedia_;
	
	    // Returns the result of getUserMedia as a Promise.
	    var getUserMediaPromise_ = function(constraints) {
	      return new Promise(function(resolve, reject) {
	        navigator.getUserMedia(constraints, resolve, reject);
	      });
	    }
	
	    // Shim for mediaDevices on older versions.
	    if (!navigator.mediaDevices) {
	      navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	        addEventListener: function() { },
	        removeEventListener: function() { }
	      };
	    }
	    navigator.mediaDevices.enumerateDevices =
	        navigator.mediaDevices.enumerateDevices || function() {
	      return new Promise(function(resolve) {
	        var infos = [
	          {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
	          {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
	        ];
	        resolve(infos);
	      });
	    };
	
	    if (browserDetails.version < 41) {
	      // Work around http://bugzil.la/1169665
	      var orgEnumerateDevices =
	          navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
	      navigator.mediaDevices.enumerateDevices = function() {
	        return orgEnumerateDevices().then(undefined, function(e) {
	          if (e.name === 'NotFoundError') {
	            return [];
	          }
	          throw e;
	        });
	      };
	    }
	  },
	
	  // Attach a media stream to an element.
	  attachMediaStream: function(element, stream) {
	    logging('DEPRECATED, attachMediaStream will soon be removed.');
	    element.srcObject = stream;
	  },
	
	  reattachMediaStream: function(to, from) {
	    logging('DEPRECATED, reattachMediaStream will soon be removed.');
	    to.srcObject = from.srcObject;
	  }
	}
	
	// Expose public methods.
	module.e = {
	  shimOnTrack: firefoxShim.shimOnTrack,
	  shimSourceObject: firefoxShim.shimSourceObject,
	  shimPeerConnection: firefoxShim.shimPeerConnection,
	  shimGetUserMedia: __webpack_require__(154),
	  attachMediaStream: firefoxShim.attachMediaStream,
	  reattachMediaStream: firefoxShim.reattachMediaStream
	}


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 *  Copyright (c) 2016 The WebRTC project authors. All Rights Reserved.
	 *
	 *  Use of this source code is governed by a BSD-style license
	 *  that can be found in the LICENSE file in the root of the source
	 *  tree.
	 */
	'use strict';
	
	var logging = __webpack_require__(0).log;
	var browserDetails = __webpack_require__(0).browserDetails;
	
	// Expose public methods.
	module.e = function() {
	  // getUserMedia constraints shim.
	  var getUserMedia_ = function(constraints, onSuccess, onError) {
	    var constraintsToFF37_ = function(c) {
	      if (typeof c !== 'object' || c.require) {
	        return c;
	      }
	      var require = [];
	      Object.keys(c).forEach(function(key) {
	        if (key === 'require' || key === 'advanced' || key === 'mediaSource') {
	          return;
	        }
	        var r = c[key] = (typeof c[key] === 'object') ?
	            c[key] : {ideal: c[key]};
	        if (r.min !== undefined ||
	            r.max !== undefined || r.exact !== undefined) {
	          require.push(key);
	        }
	        if (r.exact !== undefined) {
	          if (typeof r.exact === 'number') {
	            r. min = r.max = r.exact;
	          } else {
	            c[key] = r.exact;
	          }
	          delete r.exact;
	        }
	        if (r.ideal !== undefined) {
	          c.advanced = c.advanced || [];
	          var oc = {};
	          if (typeof r.ideal === 'number') {
	            oc[key] = {min: r.ideal, max: r.ideal};
	          } else {
	            oc[key] = r.ideal;
	          }
	          c.advanced.push(oc);
	          delete r.ideal;
	          if (!Object.keys(r).length) {
	            delete c[key];
	          }
	        }
	      });
	      if (require.length) {
	        c.require = require;
	      }
	      return c;
	    };
	    if (browserDetails.version < 38) {
	      logging('spec: ' + JSON.stringify(constraints));
	      if (constraints.audio) {
	        constraints.audio = constraintsToFF37_(constraints.audio);
	      }
	      if (constraints.video) {
	        constraints.video = constraintsToFF37_(constraints.video);
	      }
	      logging('ff37: ' + JSON.stringify(constraints));
	    }
	    return navigator.mozGetUserMedia(constraints, onSuccess, onError);
	  };
	
	  navigator.getUserMedia = getUserMedia_;
	
	  // Returns the result of getUserMedia as a Promise.
	  var getUserMediaPromise_ = function(constraints) {
	    return new Promise(function(resolve, reject) {
	      navigator.getUserMedia(constraints, resolve, reject);
	    });
	  }
	
	  // Shim for mediaDevices on older versions.
	  if (!navigator.mediaDevices) {
	    navigator.mediaDevices = {getUserMedia: getUserMediaPromise_,
	      addEventListener: function() { },
	      removeEventListener: function() { }
	    };
	  }
	  navigator.mediaDevices.enumerateDevices =
	      navigator.mediaDevices.enumerateDevices || function() {
	    return new Promise(function(resolve) {
	      var infos = [
	        {kind: 'audioinput', deviceId: 'default', label: '', groupId: ''},
	        {kind: 'videoinput', deviceId: 'default', label: '', groupId: ''}
	      ];
	      resolve(infos);
	    });
	  };
	
	  if (browserDetails.version < 41) {
	    // Work around http://bugzil.la/1169665
	    var orgEnumerateDevices =
	        navigator.mediaDevices.enumerateDevices.bind(navigator.mediaDevices);
	    navigator.mediaDevices.enumerateDevices = function() {
	      return orgEnumerateDevices().then(undefined, function(e) {
	        if (e.name === 'NotFoundError') {
	          return [];
	        }
	        throw e;
	      });
	    };
	  }
	}


/***/ },
/* 155 */
/***/ function(module, exports) {

	module.e = __WEBPACK_EXTERNAL_MODULE_155__;

/***/ },
/* 156 */
/***/ function(module, exports) {

	module.e = __WEBPACK_EXTERNAL_MODULE_156__;

/***/ },
/* 157 */
/***/ function(module, exports) {

	module.e = __WEBPACK_EXTERNAL_MODULE_157__;

/***/ },
/* 158 */
/***/ function(module, exports, __webpack_require__) {

	module.e = __webpack_require__(49);


/***/ }
/******/ ])
});
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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