![Quasar Framework logo](https://cdn.rawgit.com/quasarframework/quasar-art/863c14bd/dist/svg/quasar-logo-full-inline.svg)

## Quasar Framework

> Build responsive Single Page Apps, **SSR Apps**, PWAs, Hybrid Mobile Apps and Electron Apps, all using the same codebase!, powered with Vue.

# Quasar Framework Extras

<a href="https://badge.fury.io/js/quasar-extras" target="_blank"><img src="https://badge.fury.io/js/quasar-extras.svg"></a>
[![Join the chat at https://discord.gg/5TDhbDg](https://img.shields.io/badge/chat-on%20discord-7289da.svg)](https://discord.gg/5TDhbDg)
<a href="http://forum.quasar-framework.org" target="_blank"><img src="https://img.shields.io/badge/community-forum-brightgreen.svg"></a>

| Package | quasar.conf.js extras name | Version | Description |
| --- | --- | --- | --- |
| Roboto Font | `roboto-font` | CDN v18 | Recommended font along Material theme |
| Roboto Font Latin Extended | `roboto-font-latin-ext` | CDN v18 | Recommended font along Material theme |
| [Material Icons](https://material.io/icons/) | `material-icons` | CDN v41 | Material icons font |
| [MDI](https://materialdesignicons.com/) (Material Design Icons) | `mdi` | 3.0.39 | Extended Material Design icons font |
| [Font Awesome](https://fontawesome.com/icons?d=gallery) | `fontawesome` | 5.5.0 | Fontawesome icons font |
| [Ionicons](http://ionicons.com/) | `ionicons` | 4.4.5 | Ionicons font |
| [Animate.css](https://daneden.github.io/animate.css/) | Use `animations` prop | 3.5.2 | Bundle of animations you can use in your website/app |

Why this package? Because it strips down unnecessary package files (so faster download times), all in one place, tested and ready to use with Quasar. One other reason is that the material icons npm package sometimes fails to be downloaded by NPM.

## Supporting Quasar
Quasar Framework is an MIT-licensed open source project. Its ongoing development is made possible thanks to the support by these awesome [backers](https://github.com/rstoenescu/quasar-framework/blob/dev/backers.md). If you'd like to join them, check out [Quasar Framework's Patreon campaign](https://www.patreon.com/quasarframework).

## Documentation

Head on to the Quasar Framework official website: [https://quasar-framework.org](http://quasar-framework.org)

## Stay in Touch

For latest releases and announcements, follow on Twitter: [@quasarframework](https://twitter.com/quasarframework)

## Community Forum

Head on to the official community forum: [http://forum.quasar-framework.org](https://forum.quasar-framework.org)

## Semver
Using [semver 2.0](http://semver.org/) notation for 'quasar-extras' package.

## License

All assets included in this repository are exclusive property of their respective owners. Quasar does not take any credit in packages included here.
