const map = {
  "Quasar": "src/vue-plugin.js",
  "QActionSheet": "src/components/action-sheet/QActionSheet.js",
  "QAjaxBar": "src/components/ajax-bar/QAjaxBar.js",
  "QAlert": "src/components/alert/QAlert.js",
  "QAutocomplete": "src/components/autocomplete/QAutocomplete.js",
  "QBreadcrumbs": "src/components/breadcrumbs/QBreadcrumbs.js",
  "QBreadcrumbsEl": "src/components/breadcrumbs/QBreadcrumbsEl.js",
  "QBtn": "src/components/btn/QBtn.js",
  "QBtnDropdown": "src/components/btn/QBtnDropdown.js",
  "QBtnGroup": "src/components/btn/QBtnGroup.js",
  "QBtnToggle": "src/components/btn/QBtnToggle.js",
  "QCard": "src/components/card/QCard.js",
  "QCardActions": "src/components/card/QCardActions.js",
  "QCardMain": "src/components/card/QCardMain.js",
  "QCardMedia": "src/components/card/QCardMedia.js",
  "QCardSeparator": "src/components/card/QCardSeparator.js",
  "QCardTitle": "src/components/card/QCardTitle.js",
  "QCarousel": "src/components/carousel/QCarousel.js",
  "QCarouselControl": "src/components/carousel/QCarouselControl.js",
  "QCarouselSlide": "src/components/carousel/QCarouselSlide.js",
  "QChatMessage": "src/components/chat/QChatMessage.js",
  "QCheckbox": "src/components/checkbox/QCheckbox.js",
  "QChip": "src/components/chip/QChip.js",
  "QChipsInput": "src/components/chips-input/QChipsInput.js",
  "QCollapsible": "src/components/collapsible/QCollapsible.js",
  "QColor": "src/components/color/QColor.js",
  "QColorPicker": "src/components/color/QColorPicker.js",
  "QContextMenu": "src/components/context-menu/QContextMenu.js",
  "QDatetime": "src/components/datetime/QDatetime.js",
  "QDatetimePicker": "src/components/datetime/QDatetimePicker.ios.js",
  "QDialog": "src/components/dialog/QDialog.js",
  "QEditor": "src/components/editor/QEditor.js",
  "QFab": "src/components/fab/QFab.js",
  "QFabAction": "src/components/fab/QFabAction.js",
  "QField": "src/components/field/QField.js",
  "QIcon": "src/components/icon/QIcon.js",
  "QInfiniteScroll": "src/components/infinite-scroll/QInfiniteScroll.js",
  "QInnerLoading": "src/components/inner-loading/QInnerLoading.js",
  "QInputFrame": "src/components/input-frame/QInputFrame.js",
  "QInput": "src/components/input/QInput.js",
  "QJumbotron": "src/components/jumbotron/QJumbotron.js",
  "QKnob": "src/components/knob/QKnob.js",
  "QLayout": "src/components/layout/QLayout.js",
  "QLayoutDrawer": "src/components/layout/QLayoutDrawer.js",
  "QLayoutFooter": "src/components/layout/QLayoutFooter.js",
  "QLayoutHeader": "src/components/layout/QLayoutHeader.js",
  "QPage": "src/components/layout/QPage.js",
  "QPageContainer": "src/components/layout/QPageContainer.js",
  "QPageSticky": "src/components/layout/QPageSticky.js",
  "QItem": "src/components/list/QItem.js",
  "QItemMain": "src/components/list/QItemMain.js",
  "QItemSeparator": "src/components/list/QItemSeparator.js",
  "QItemSide": "src/components/list/QItemSide.js",
  "QItemTile": "src/components/list/QItemTile.js",
  "QItemWrapper": "src/components/list/QItemWrapper.js",
  "QList": "src/components/list/QList.js",
  "QListHeader": "src/components/list/QListHeader.js",
  "QModal": "src/components/modal/QModal.js",
  "QModalLayout": "src/components/modal/QModalLayout.js",
  "QNoSsr": "src/components/no-ssr/QNoSsr.js",
  "QResizeObservable": "src/components/observables/QResizeObservable.js",
  "QScrollObservable": "src/components/observables/QScrollObservable.js",
  "QWindowResizeObservable": "src/components/observables/QWindowResizeObservable.js",
  "QOptionGroup": "src/components/option-group/QOptionGroup.js",
  "QPagination": "src/components/pagination/QPagination.js",
  "QParallax": "src/components/parallax/QParallax.js",
  "QPopover": "src/components/popover/QPopover.js",
  "QPopupEdit": "src/components/popup-edit/QPopupEdit.js",
  "QProgress": "src/components/progress/QProgress.js",
  "QPullToRefresh": "src/components/pull-to-refresh/QPullToRefresh.js",
  "QRadio": "src/components/radio/QRadio.js",
  "QRange": "src/components/range/QRange.js",
  "QRating": "src/components/rating/QRating.js",
  "QScrollArea": "src/components/scroll-area/QScrollArea.js",
  "QSearch": "src/components/search/QSearch.js",
  "QSelect": "src/components/select/QSelect.js",
  "QSlideTransition": "src/components/slide-transition/QSlideTransition.js",
  "QSlider": "src/components/slider/QSlider.js",
  "QSpinner": "src/components/spinner/QSpinner.js",
  "QSpinnerAudio": "src/components/spinner/QSpinnerAudio.js",
  "QSpinnerBall": "src/components/spinner/QSpinnerBall.js",
  "QSpinnerBars": "src/components/spinner/QSpinnerBars.js",
  "QSpinnerCircles": "src/components/spinner/QSpinnerCircles.js",
  "QSpinnerComment": "src/components/spinner/QSpinnerComment.js",
  "QSpinnerCube": "src/components/spinner/QSpinnerCube.js",
  "QSpinnerDots": "src/components/spinner/QSpinnerDots.js",
  "QSpinnerFacebook": "src/components/spinner/QSpinnerFacebook.js",
  "QSpinnerGears": "src/components/spinner/QSpinnerGears.js",
  "QSpinnerGrid": "src/components/spinner/QSpinnerGrid.js",
  "QSpinnerHearts": "src/components/spinner/QSpinnerHearts.js",
  "QSpinnerHourglass": "src/components/spinner/QSpinnerHourglass.js",
  "QSpinnerInfinity": "src/components/spinner/QSpinnerInfinity.js",
  "QSpinnerOval": "src/components/spinner/QSpinnerOval.js",
  "QSpinnerPie": "src/components/spinner/QSpinnerPie.js",
  "QSpinnerPuff": "src/components/spinner/QSpinnerPuff.js",
  "QSpinnerRadio": "src/components/spinner/QSpinnerRadio.js",
  "QSpinnerRings": "src/components/spinner/QSpinnerRings.js",
  "QSpinnerTail": "src/components/spinner/QSpinnerTail.js",
  "QStep": "src/components/stepper/QStep.js",
  "QStepper": "src/components/stepper/QStepper.js",
  "QStepperNavigation": "src/components/stepper/QStepperNavigation.js",
  "QRouteTab": "src/components/tab/QRouteTab.js",
  "QTab": "src/components/tab/QTab.js",
  "QTabPane": "src/components/tab/QTabPane.js",
  "QTabs": "src/components/tab/QTabs.js",
  "QTable": "src/components/table/QTable.js",
  "QTableColumns": "src/components/table/QTableColumns.js",
  "QTd": "src/components/table/QTd.js",
  "QTh": "src/components/table/QTh.js",
  "QTr": "src/components/table/QTr.js",
  "QTimeline": "src/components/timeline/QTimeline.js",
  "QTimelineEntry": "src/components/timeline/QTimelineEntry.js",
  "QToggle": "src/components/toggle/QToggle.js",
  "QToolbar": "src/components/toolbar/QToolbar.js",
  "QToolbarTitle": "src/components/toolbar/QToolbarTitle.js",
  "QTooltip": "src/components/tooltip/QTooltip.js",
  "QTree": "src/components/tree/QTree.js",
  "QUploader": "src/components/uploader/QUploader.js",
  "QVideo": "src/components/video/QVideo.js",
  "QSpinnerMat": "src/components/spinner/QSpinner.mat.js",
  "QSpinnerIos": "src/components/spinner/QSpinner.ios.js",
  "BackToTop": "src/directives/back-to-top.js",
  "CloseOverlay": "src/directives/close-overlay.js",
  "GoBack": "src/directives/go-back.js",
  "Ripple": "src/directives/ripple.js",
  "ScrollFire": "src/directives/scroll-fire.js",
  "Scroll": "src/directives/scroll.js",
  "TouchHold": "src/directives/touch-hold.js",
  "TouchPan": "src/directives/touch-pan.js",
  "TouchSwipe": "src/directives/touch-swipe.js",
  "ActionSheet": "src/plugins/action-sheet.js",
  "AddressbarColor": "src/plugins/addressbar-color.js",
  "AppFullscreen": "src/plugins/app-fullscreen.js",
  "AppVisibility": "src/plugins/app-visibility.js",
  "Cookies": "src/plugins/cookies.js",
  "Dialog": "src/plugins/dialog.js",
  "LoadingBar": "src/plugins/loading-bar.js",
  "Loading": "src/plugins/loading.js",
  "LocalStorage": "src/plugins/local-storage.js",
  "Meta": "src/plugins/meta.js",
  "Notify": "src/plugins/notify.js",
  "Platform": "src/plugins/platform.js",
  "Screen": "src/plugins/screen.js",
  "SessionStorage": "src/plugins/session-storage.js",
  "animate": "src/utils/animate.js",
  "clone": "src/utils/clone.js",
  "colors": "src/utils/colors.js",
  "date": "src/utils/date.js",
  "debounce": "src/utils/debounce.js",
  "dom": "src/utils/dom.js",
  "easing": "src/utils/easing.js",
  "event": "src/utils/event.js",
  "extend": "src/utils/extend.js",
  "filter": "src/utils/filter.js",
  "format": "src/utils/format.js",
  "frameDebounce": "src/utils/frame-debounce.js",
  "openURL": "src/utils/open-url.js",
  "preventScroll": "src/utils/prevent-scroll.js",
  "scroll": "src/utils/scroll.js",
  "throttle": "src/utils/throttle.js",
  "uid": "src/utils/uid.js"
}

module.exports = function (importName) {
  if (typeof map[importName] === 'undefined') {
    throw new Error('Unknown import from Quasar: ' + importName)
  }
  return 'quasar-framework/' + map[importName]
}
