/*!
 * Quasar Framework v1.12.13
 * (c) 2015-present Razvan Stoenescu
 * Released under the MIT License.
 */
"use strict";function _interopDefault(t){return t&&"object"==typeof t&&"default"in t?t.default:t}var Vue=_interopDefault(require("vue")),version="1.12.13";const isSSR="undefined"==typeof window;let iosCorrection,fromSSR=!1,onSSR=isSSR,iosEmulated=!1;function getMatch(t,e){const i=/(edge|edga|edgios)\/([\w.]+)/.exec(t)||/(opr)[\/]([\w.]+)/.exec(t)||/(vivaldi)[\/]([\w.]+)/.exec(t)||/(chrome|crios)[\/]([\w.]+)/.exec(t)||/(iemobile)[\/]([\w.]+)/.exec(t)||/(version)(applewebkit)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(t)||/(webkit)[\/]([\w.]+).*(version)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(t)||/(firefox|fxios)[\/]([\w.]+)/.exec(t)||/(webkit)[\/]([\w.]+)/.exec(t)||/(opera)(?:.*version|)[\/]([\w.]+)/.exec(t)||/(msie) ([\w.]+)/.exec(t)||t.indexOf("trident")>=0&&/(rv)(?::| )([\w.]+)/.exec(t)||t.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(t)||[];return{browser:i[5]||i[3]||i[1]||"",version:i[2]||i[4]||"0",versionNumber:i[4]||i[2]||"0",platform:e[0]||""}}function getPlatformMatch(t){return/(ipad)/.exec(t)||/(ipod)/.exec(t)||/(windows phone)/.exec(t)||/(iphone)/.exec(t)||/(kindle)/.exec(t)||/(silk)/.exec(t)||/(android)/.exec(t)||/(win)/.exec(t)||/(mac)/.exec(t)||/(linux)/.exec(t)||/(cros)/.exec(t)||/(playbook)/.exec(t)||/(bb)/.exec(t)||/(blackberry)/.exec(t)||[]}const hasTouch=!1===isSSR&&("ontouchstart"in window||window.navigator.maxTouchPoints>0);function applyIosCorrection(t){iosCorrection={is:{...t}},delete t.mac,delete t.desktop;const e=Math.min(window.innerHeight,window.innerWidth)>414?"ipad":"iphone";Object.assign(t,{mobile:!0,ios:!0,platform:e,[e]:!0})}function getPlatform(t){const e=t.toLowerCase(),i=getMatch(e,getPlatformMatch(e)),s={};i.browser&&(s[i.browser]=!0,s.version=i.version,s.versionNumber=parseInt(i.versionNumber,10)),i.platform&&(s[i.platform]=!0);const o=s.android||s.ios||s.bb||s.blackberry||s.ipad||s.iphone||s.ipod||s.kindle||s.playbook||s.silk||s["windows phone"];return!0===o||e.indexOf("mobile")>-1?(s.mobile=!0,s.edga||s.edgios?(s.edge=!0,i.browser="edge"):s.crios?(s.chrome=!0,i.browser="chrome"):s.fxios&&(s.firefox=!0,i.browser="firefox")):s.desktop=!0,(s.ipod||s.ipad||s.iphone)&&(s.ios=!0),s["windows phone"]&&(s.winphone=!0,delete s["windows phone"]),(s.chrome||s.opr||s.safari||s.vivaldi||!0===s.mobile&&!0!==s.ios&&!0!==o)&&(s.webkit=!0),(s.rv||s.iemobile)&&(i.browser="ie",s.ie=!0),(s.safari&&s.blackberry||s.bb)&&(i.browser="blackberry",s.blackberry=!0),s.safari&&s.playbook&&(i.browser="playbook",s.playbook=!0),s.opr&&(i.browser="opera",s.opera=!0),s.safari&&s.android&&(i.browser="android",s.android=!0),s.safari&&s.kindle&&(i.browser="kindle",s.kindle=!0),s.safari&&s.silk&&(i.browser="silk",s.silk=!0),s.vivaldi&&(i.browser="vivaldi",s.vivaldi=!0),s.name=i.browser,s.platform=i.platform,!1===isSSR&&(e.indexOf("electron")>-1?s.electron=!0:document.location.href.indexOf("-extension://")>-1?s.bex=!0:(void 0!==window.Capacitor?(s.capacitor=!0,s.nativeMobile=!0,s.nativeMobileWrapper="capacitor"):void 0===window._cordovaNative&&void 0===window.cordova||(s.cordova=!0,s.nativeMobile=!0,s.nativeMobileWrapper="cordova"),!0===hasTouch&&!0===s.mac&&(!0===s.desktop&&!0===s.safari||!0===s.nativeMobile&&!0!==s.android&&!0!==s.ios&&!0!==s.ipad)&&applyIosCorrection(s)),!0===(fromSSR=void 0===s.nativeMobile&&void 0===s.electron&&null!==document.querySelector("[data-server-rendered]"))&&(onSSR=!0)),s}const userAgent=!0!==isSSR?navigator.userAgent||navigator.vendor||window.opera:"",ssrClient={has:{touch:!1,webStorage:!1},within:{iframe:!1}},client=!1===isSSR?{userAgent:userAgent,is:getPlatform(userAgent),has:{touch:hasTouch,webStorage:(()=>{try{if(window.localStorage)return!0}catch(t){}return!1})()},within:{iframe:window.self!==window.top}}:ssrClient,Platform={install(t,e){!0===isSSR?e.server.push((t,e)=>{t.platform=this.parseSSR(e.ssr)}):!0===fromSSR?(Object.assign(this,client,iosCorrection,ssrClient),e.takeover.push(t=>{onSSR=fromSSR=!1,Object.assign(t.platform,client),iosCorrection=void 0}),Vue.util.defineReactive(t,"platform",this)):(Object.assign(this,client),t.platform=this)}};!0===isSSR?Platform.parseSSR=(t=>{const e=t.req.headers["user-agent"]||t.req.headers["User-Agent"]||"";return{...client,userAgent:e,is:getPlatform(e)}}):iosEmulated=!0===client.is.ios&&-1===window.navigator.vendor.toLowerCase().indexOf("apple");const listenOpts={hasPassive:!1,passiveCapture:!0,notPassiveCapture:!0};try{var opts=Object.defineProperty({},"passive",{get(){Object.assign(listenOpts,{hasPassive:!0,passive:{passive:!0},notPassive:{passive:!1},passiveCapture:{passive:!0,capture:!0},notPassiveCapture:{passive:!1,capture:!0}})}});window.addEventListener("qtest",null,opts),window.removeEventListener("qtest",null,opts)}catch(t){}function noop(){}function leftClick(t){return 0===t.button}function middleClick(t){return 1===t.button}function rightClick(t){return 2===t.button}function position(t){return t.touches&&t.touches[0]?t=t.touches[0]:t.changedTouches&&t.changedTouches[0]?t=t.changedTouches[0]:t.targetTouches&&t.targetTouches[0]&&(t=t.targetTouches[0]),{top:t.clientY,left:t.clientX}}function getEventPath(t){if(t.path)return t.path;if(t.composedPath)return t.composedPath();const e=[];let i=t.target;for(;i;){if(e.push(i),"HTML"===i.tagName)return e.push(document),e.push(window),e;i=i.parentElement}}const LINE_HEIGHT=40,PAGE_HEIGHT=800;function getMouseWheelDistance(t){let e=t.deltaX,i=t.deltaY;if((e||i)&&t.deltaMode){const s=1===t.deltaMode?LINE_HEIGHT:PAGE_HEIGHT;e*=s,i*=s}return t.shiftKey&&!e&&([i,e]=[e,i]),{x:e,y:i}}function stop(t){t.stopPropagation()}function prevent(t){!1!==t.cancelable&&t.preventDefault()}function stopAndPrevent(t){!1!==t.cancelable&&t.preventDefault(),t.stopPropagation()}function preventDraggable(t,e){if(void 0===t||!0===e&&!0===t.__dragPrevented)return;const i=!0===e?t=>{t.__dragPrevented=!0,t.addEventListener("dragstart",prevent,listenOpts.notPassiveCapture)}:t=>{delete t.__dragPrevented,t.removeEventListener("dragstart",prevent,listenOpts.notPassiveCapture)};t.querySelectorAll("a, img").forEach(i)}function create(t,{bubbles:e=!1,cancelable:i=!1}={}){try{return new Event(t,{bubbles:e,cancelable:i})}catch(s){const o=document.createEvent("Event");return o.initEvent(t,e,i),o}}function addEvt(t,e,i){const s=`__q_${e}_evt`;t[s]=void 0!==t[s]?t[s].concat(i):i,i.forEach(e=>{e[0].addEventListener(e[1],t[e[2]],listenOpts[e[3]])})}function cleanEvt(t,e){const i=`__q_${e}_evt`;void 0!==t[i]&&(t[i].forEach(e=>{e[0].removeEventListener(e[1],t[e[2]],listenOpts[e[3]])}),t[i]=void 0)}var event={listenOpts:listenOpts,leftClick:leftClick,middleClick:middleClick,rightClick:rightClick,position:position,getEventPath:getEventPath,getMouseWheelDistance:getMouseWheelDistance,stop:stop,prevent:prevent,stopAndPrevent:stopAndPrevent,preventDraggable:preventDraggable,create:create};function debounce(t,e=250,i){let s;function o(){const o=arguments;clearTimeout(s),!0===i&&void 0===s&&t.apply(this,o),s=setTimeout(()=>{s=void 0,!0!==i&&t.apply(this,o)},e)}return o.cancel=(()=>{clearTimeout(s)}),o}const SIZE_LIST=["sm","md","lg","xl"],{passive:passive}=listenOpts;var Screen={width:0,height:0,name:"xs",sizes:{sm:600,md:1024,lg:1440,xl:1920},lt:{sm:!0,md:!0,lg:!0,xl:!0},gt:{xs:!1,sm:!1,md:!1,lg:!1},xs:!0,sm:!1,md:!1,lg:!1,xl:!1,setSizes:noop,setDebounce:noop,install(t,e,i){if(!0===isSSR)return void(t.screen=this);const s=void 0!==i.screen&&!0===i.screen.bodyClasses,o=t=>{const e=window.innerWidth,i=window.innerHeight;if(i!==this.height&&(this.height=i),e!==this.width)this.width=e;else if(!0!==t)return;let o=this.sizes;this.gt.xs=e>=o.sm,this.gt.sm=e>=o.md,this.gt.md=e>=o.lg,this.gt.lg=e>=o.xl,this.lt.sm=e<o.sm,this.lt.md=e<o.md,this.lt.lg=e<o.lg,this.lt.xl=e<o.xl,this.xs=this.lt.sm,this.sm=!0===this.gt.xs&&!0===this.lt.md,this.md=!0===this.gt.sm&&!0===this.lt.lg,this.lg=!0===this.gt.md&&!0===this.lt.xl,this.xl=this.gt.lg,(o=(!0===this.xs?"xs":!0===this.sm&&"sm")||!0===this.md&&"md"||!0===this.lg&&"lg"||"xl")!==this.name&&(!0===s&&(document.body.classList.remove(`screen--${this.name}`),document.body.classList.add(`screen--${o}`)),this.name=o)};let n,r={},a=16;this.setSizes=(t=>{SIZE_LIST.forEach(e=>{void 0!==t[e]&&(r[e]=t[e])})}),this.setDebounce=(t=>{a=t});const l=()=>{const t=getComputedStyle(document.body),e=void 0!==window.visualViewport?window.visualViewport:window;t.getPropertyValue("--q-size-sm")&&SIZE_LIST.forEach(e=>{this.sizes[e]=parseInt(t.getPropertyValue(`--q-size-${e}`),10)}),this.setSizes=(t=>{SIZE_LIST.forEach(e=>{t[e]&&(this.sizes[e]=t[e])}),o(!0)}),this.setDebounce=(t=>{void 0!==n&&e.removeEventListener("resize",n,passive),n=t>0?debounce(o,t):o,e.addEventListener("resize",n,passive)}),this.setDebounce(a),Object.keys(r).length>0?(this.setSizes(r),r=void 0):o(),!0===s&&"xs"===this.name&&document.body.classList.add("screen--xs")};!0===fromSSR?e.takeover.push(l):l(),Vue.util.defineReactive(t,"screen",this)}};const Dark={isActive:!1,mode:!1,install(t,e,{dark:i}){if(this.isActive=!0===i,!0===isSSR)return e.server.push((t,e)=>{t.dark={isActive:!1,mode:!1,set:i=>{e.ssr.Q_BODY_CLASSES=e.ssr.Q_BODY_CLASSES.replace(" body--light","").replace(" body--dark","")+` body--${!0===i?"dark":"light"}`,t.dark.isActive=!0===i,t.dark.mode=i},toggle:()=>{t.dark.set(!1===t.dark.isActive)}},t.dark.set(i)}),void(this.set=noop);const s=void 0!==i&&i;if(!0===fromSSR){const t=t=>{this.__fromSSR=t},i=this.set;this.set=t,t(s),e.takeover.push(()=>{this.set=i,this.set(this.__fromSSR)})}else this.set(s);Vue.util.defineReactive(this,"isActive",this.isActive),Vue.util.defineReactive(t,"dark",this)},set(t){this.mode=t,"auto"===t?(void 0===this.__media&&(this.__media=window.matchMedia("(prefers-color-scheme: dark)"),this.__updateMedia=(()=>{this.set("auto")}),this.__media.addListener(this.__updateMedia)),t=this.__media.matches):void 0!==this.__media&&(this.__media.removeListener(this.__updateMedia),this.__media=void 0),this.isActive=!0===t,document.body.classList.remove(`body--${!0===t?"light":"dark"}`),document.body.classList.add(`body--${!0===t?"dark":"light"}`)},toggle(){Dark.set(!1===Dark.isActive)},__media:void 0},getTrue=()=>!0;function filterInvalidPath(t){return"string"==typeof t&&""!==t&&"/"!==t&&"#/"!==t}function normalizeExitPath(t){return!0===t.startsWith("#")&&(t=t.substr(1)),!1===t.startsWith("/")&&(t="/"+t),!0===t.endsWith("/")&&(t=t.substr(0,t.length-1)),"#"+t}function getShouldExitFn(t){if(!1===t.backButtonExit)return()=>!1;if("*"===t.backButtonExit)return getTrue;const e=["#/"];return!0===Array.isArray(t.backButtonExit)&&e.push(...t.backButtonExit.filter(filterInvalidPath).map(normalizeExitPath)),()=>e.includes(window.location.hash)}var History={__history:[],add:noop,remove:noop,install(t){if(!0===isSSR)return;const{cordova:e,capacitor:i}=client.is;if(!0!==e&&!0!==i)return;this.add=(t=>{void 0===t.condition&&(t.condition=getTrue),this.__history.push(t)}),this.remove=(t=>{const e=this.__history.indexOf(t);e>=0&&this.__history.splice(e,1)});const s=getShouldExitFn(Object.assign({backButtonExit:!0},t[!0===e?"cordova":"capacitor"])),o=()=>{if(this.__history.length){const t=this.__history[this.__history.length-1];!0===t.condition()&&(this.__history.pop(),t.handler())}else!0===s()?navigator.app.exitApp():window.history.back()};!0===e?document.addEventListener("deviceready",()=>{document.addEventListener("backbutton",o,!1)}):window.Capacitor.Plugins.App.addListener("backButton",o)}},langEn={isoName:"en-us",nativeName:"English (US)",label:{clear:"Clear",ok:"OK",cancel:"Cancel",close:"Close",set:"Set",select:"Select",reset:"Reset",remove:"Remove",update:"Update",create:"Create",search:"Search",filter:"Filter",refresh:"Refresh"},date:{days:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),daysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),firstDayOfWeek:0,format24h:!1},table:{noData:"No data available",noResults:"No matching records found",loading:"Loading...",selectedRecords:function(t){return 1===t?"1 record selected.":(0===t?"No":t)+" records selected."},recordsPerPage:"Records per page:",allRows:"All",pagination:function(t,e,i){return t+"-"+e+" of "+i},columns:"Columns"},editor:{url:"URL",bold:"Bold",italic:"Italic",strikethrough:"Strikethrough",underline:"Underline",unorderedList:"Unordered List",orderedList:"Ordered List",subscript:"Subscript",superscript:"Superscript",hyperlink:"Hyperlink",toggleFullscreen:"Toggle Fullscreen",quote:"Quote",left:"Left align",center:"Center align",right:"Right align",justify:"Justify align",print:"Print",outdent:"Decrease indentation",indent:"Increase indentation",removeFormat:"Remove formatting",formatting:"Formatting",fontSize:"Font Size",align:"Align",hr:"Insert Horizontal Rule",undo:"Undo",redo:"Redo",heading1:"Heading 1",heading2:"Heading 2",heading3:"Heading 3",heading4:"Heading 4",heading5:"Heading 5",heading6:"Heading 6",paragraph:"Paragraph",code:"Code",size1:"Very small",size2:"A bit small",size3:"Normal",size4:"Medium-large",size5:"Big",size6:"Very big",size7:"Maximum",defaultFont:"Default Font",viewSource:"View Source"},tree:{noNodes:"No nodes available",noResults:"No matching nodes found"}};function getLocale(){if(!0===isSSR)return;const t=navigator.language||navigator.languages[0]||navigator.browserLanguage||navigator.userLanguage||navigator.systemLanguage;return t?t.toLowerCase():void 0}var lang={getLocale:getLocale,install(t,e,i){const s=i||langEn;this.set=((e=langEn,i)=>{const s={...e,rtl:!0===e.rtl,getLocale:getLocale};if(!0===isSSR){if(void 0===i)return void console.error("SSR ERROR: second param required: Quasar.lang.set(lang, ssrContext)");const t=!0===s.rtl?"rtl":"ltr",e=`lang=${s.isoName} dir=${t}`;s.set=i.$q.lang.set,i.Q_HTML_ATTRS=void 0!==i.Q_PREV_LANG?i.Q_HTML_ATTRS.replace(i.Q_PREV_LANG,e):e,i.Q_PREV_LANG=e,i.$q.lang=s}else{if(!1===fromSSR){const t=document.documentElement;t.setAttribute("dir",!0===s.rtl?"rtl":"ltr"),t.setAttribute("lang",s.isoName)}s.set=this.set,t.lang=this.props=s,this.isoName=s.isoName,this.nativeName=s.nativeName}}),!0===isSSR?(e.server.push((t,e)=>{t.lang={},t.lang.set=(t=>{this.set(t,e.ssr)}),t.lang.set(s)}),this.isoName=s.isoName,this.nativeName=s.nativeName,this.props=s):(Vue.util.defineReactive(t,"lang",{}),this.set(s))}};const reRGBA=/^rgb(a)?\((\d{1,3}),(\d{1,3}),(\d{1,3}),?([01]?\.?\d*?)?\)$/;function rgbToHex({r:t,g:e,b:i,a:s}){const o=void 0!==s;if(t=Math.round(t),e=Math.round(e),i=Math.round(i),t>255||e>255||i>255||o&&s>100)throw new TypeError("Expected 3 numbers below 256 (and optionally one below 100)");return s=o?(256|Math.round(255*s/100)).toString(16).slice(1):"","#"+(i|e<<8|t<<16|1<<24).toString(16).slice(1)+s}function rgbToString({r:t,g:e,b:i,a:s}){return`rgb${void 0!==s?"a":""}(${t},${e},${i}${void 0!==s?","+s/100:""})`}function hexToRgb(t){if("string"!=typeof t)throw new TypeError("Expected a string");3===(t=t.replace(/^#/,"")).length?t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]:4===t.length&&(t=t[0]+t[0]+t[1]+t[1]+t[2]+t[2]+t[3]+t[3]);const e=parseInt(t,16);return t.length>6?{r:e>>24&255,g:e>>16&255,b:e>>8&255,a:Math.round((255&e)/2.55)}:{r:e>>16,g:e>>8&255,b:255&e}}function hsvToRgb({h:t,s:e,v:i,a:s}){let o,n,r;e/=100,i/=100,t/=360;const a=Math.floor(6*t),l=6*t-a,h=i*(1-e),d=i*(1-l*e),c=i*(1-(1-l)*e);switch(a%6){case 0:o=i,n=c,r=h;break;case 1:o=d,n=i,r=h;break;case 2:o=h,n=i,r=c;break;case 3:o=h,n=d,r=i;break;case 4:o=c,n=h,r=i;break;case 5:o=i,n=h,r=d}return{r:Math.round(255*o),g:Math.round(255*n),b:Math.round(255*r),a:s}}function rgbToHsv({r:t,g:e,b:i,a:s}){const o=Math.max(t,e,i),n=Math.min(t,e,i),r=o-n,a=0===o?0:r/o,l=o/255;let h;switch(o){case n:h=0;break;case t:h=e-i+r*(e<i?6:0),h/=6*r;break;case e:h=i-t+2*r,h/=6*r;break;case i:h=t-e+4*r,h/=6*r}return{h:Math.round(360*h),s:Math.round(100*a),v:Math.round(100*l),a:s}}function textToRgb(t){if("string"!=typeof t)throw new TypeError("Expected a string");const e=t.replace(/ /g,""),i=reRGBA.exec(e);if(null===i)return hexToRgb(e);const s={r:Math.min(255,parseInt(i[2],10)),g:Math.min(255,parseInt(i[3],10)),b:Math.min(255,parseInt(i[4],10))};if(i[1]){const t=parseFloat(i[5]);s.a=100*Math.min(1,!0===isNaN(t)?1:t)}return s}function lighten(t,e){if("string"!=typeof t)throw new TypeError("Expected a string as color");if("number"!=typeof e)throw new TypeError("Expected a numeric percent");const i=textToRgb(t),s=e<0?0:255,o=Math.abs(e)/100,n=i.r,r=i.g,a=i.b;return"#"+(16777216+65536*(Math.round((s-n)*o)+n)+256*(Math.round((s-r)*o)+r)+(Math.round((s-a)*o)+a)).toString(16).slice(1)}function luminosity(t){if("string"!=typeof t&&(!t||void 0===t.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const e="string"==typeof t?textToRgb(t):t,i=e.r/255,s=e.g/255,o=e.b/255;return.2126*(i<=.03928?i/12.92:Math.pow((i+.055)/1.055,2.4))+.7152*(s<=.03928?s/12.92:Math.pow((s+.055)/1.055,2.4))+.0722*(o<=.03928?o/12.92:Math.pow((o+.055)/1.055,2.4))}function brightness(t){if("string"!=typeof t&&(!t||void 0===t.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const e="string"==typeof t?textToRgb(t):t;return(299*e.r+587*e.g+114*e.b)/1e3}function blend(t,e){if("string"!=typeof t&&(!t||void 0===t.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as fgColor");if("string"!=typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as bgColor");const i="string"==typeof t?textToRgb(t):t,s=i.r/255,o=i.g/255,n=i.b/255,r=void 0!==i.a?i.a/100:1,a="string"==typeof e?textToRgb(e):e,l=a.r/255,h=a.g/255,d=a.b/255,c=void 0!==a.a?a.a/100:1,u=r+c*(1-r),p={r:Math.round((s*r+l*c*(1-r))/u*255),g:Math.round((o*r+h*c*(1-r))/u*255),b:Math.round((n*r+d*c*(1-r))/u*255),a:Math.round(100*u)};return"string"==typeof t?rgbToHex(p):p}function changeAlpha(t,e){if("string"!=typeof t)throw new TypeError("Expected a string as color");if(void 0===e||e<-1||e>1)throw new TypeError("Expected offset to be between -1 and 1");const{r:i,g:s,b:o,a:n}=textToRgb(t),r=void 0!==n?n/100:0;return rgbToHex({r:i,g:s,b:o,a:Math.round(100*Math.min(1,Math.max(0,r+e)))})}function setBrand(t,e,i=document.body){if("string"!=typeof t)throw new TypeError("Expected a string as color");if("string"!=typeof e)throw new TypeError("Expected a string as value");if(!(i instanceof Element))throw new TypeError("Expected a DOM element");i.style.setProperty(`--q-color-${t}`,e)}function getBrand(t,e=document.body){if("string"!=typeof t)throw new TypeError("Expected a string as color");if(!(e instanceof Element))throw new TypeError("Expected a DOM element");return getComputedStyle(e).getPropertyValue(`--q-color-${t}`).trim()||null}function getPaletteColor(t){if("string"!=typeof t)throw new TypeError("Expected a string as color");const e=document.createElement("div");e.className=`text-${t} invisible fixed no-pointer-events`,document.body.appendChild(e);const i=getComputedStyle(e).getPropertyValue("color");return e.remove(),rgbToHex(textToRgb(i))}var colors={rgbToHex:rgbToHex,hexToRgb:hexToRgb,hsvToRgb:hsvToRgb,rgbToHsv:rgbToHsv,textToRgb:textToRgb,lighten:lighten,luminosity:luminosity,brightness:brightness,blend:blend,changeAlpha:changeAlpha,setBrand:setBrand,getBrand:getBrand,getPaletteColor:getPaletteColor};let lastKeyCompositionStatus=!1;function onKeyDownComposition(t){lastKeyCompositionStatus=!0===t.isComposing}function shouldIgnoreKey(t){return!0===lastKeyCompositionStatus||t!==Object(t)||!0===t.isComposing||!0===t.qKeyEvent}function isKeyCode(t,e){return!0!==shouldIgnoreKey(t)&&[].concat(e).includes(t.keyCode)}function getMobilePlatform(t){return!0===t.ios?"ios":!0===t.android?"android":void 0}function getBodyClasses({is:t,has:e,within:i},s){const o=[!0===t.desktop?"desktop":"mobile",`${!1===e.touch?"no-":""}touch`];if(!0===t.mobile){const e=getMobilePlatform(t);void 0!==e&&o.push("platform-"+e)}if(!0===t.nativeMobile){const e=t.nativeMobileWrapper;o.push(e),o.push("native-mobile"),!0!==t.ios||void 0!==s[e]&&!1===s[e].iosStatusBarPadding||o.push("q-ios-padding")}else!0===t.electron?o.push("electron"):!0===t.bex&&o.push("bex");return!0===i.iframe&&o.push("within-iframe"),o}function clientUpdate(){const t=document.body.className;let e=t;void 0!==iosCorrection&&(e=e.replace("desktop","platform-ios mobile")),!0===client.has.touch&&(e=e.replace("no-touch","touch")),!0===client.within.iframe&&(e+=" within-iframe"),t!==e&&(document.body.className=e)}function setColors(t){for(const e in t)setBrand(e,t[e])}var Body={install(t,e){if(!0!==isSSR){if(!0===fromSSR)clientUpdate();else{const t=getBodyClasses(client,e);!0===client.is.ie&&11===client.is.versionNumber?t.forEach(t=>document.body.classList.add(t)):document.body.classList.add.apply(document.body.classList,t)}void 0!==e.brand&&setColors(e.brand),!0===client.is.ios&&document.body.addEventListener("touchstart",noop),window.addEventListener("keydown",onKeyDownComposition,!0)}else t.server.push((t,i)=>{const s=getBodyClasses(t.platform,e),o=i.ssr.setBodyClasses;void 0!==e.screen&&!0===e.screen.bodyClass&&s.push("screen--xs"),"function"==typeof o?o(s):i.ssr.Q_BODY_CLASSES=s.join(" ")})}},materialIcons={name:"material-icons",type:{positive:"check_circle",negative:"warning",info:"info",warning:"priority_high"},arrow:{up:"arrow_upward",right:"arrow_forward",down:"arrow_downward",left:"arrow_back",dropdown:"arrow_drop_down"},chevron:{left:"chevron_left",right:"chevron_right"},colorPicker:{spectrum:"gradient",tune:"tune",palette:"style"},pullToRefresh:{icon:"refresh"},carousel:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down",navigationIcon:"lens"},chip:{remove:"cancel",selected:"check"},datetime:{arrowLeft:"chevron_left",arrowRight:"chevron_right",now:"access_time",today:"today"},editor:{bold:"format_bold",italic:"format_italic",strikethrough:"strikethrough_s",underline:"format_underlined",unorderedList:"format_list_bulleted",orderedList:"format_list_numbered",subscript:"vertical_align_bottom",superscript:"vertical_align_top",hyperlink:"link",toggleFullscreen:"fullscreen",quote:"format_quote",left:"format_align_left",center:"format_align_center",right:"format_align_right",justify:"format_align_justify",print:"print",outdent:"format_indent_decrease",indent:"format_indent_increase",removeFormat:"format_clear",formatting:"text_format",fontSize:"format_size",align:"format_align_left",hr:"remove",undo:"undo",redo:"redo",heading:"format_size",code:"code",size:"format_size",font:"font_download",viewSource:"code"},expansionItem:{icon:"keyboard_arrow_down",denseIcon:"arrow_drop_down"},fab:{icon:"add",activeIcon:"close"},field:{clear:"cancel",error:"error"},pagination:{first:"first_page",prev:"keyboard_arrow_left",next:"keyboard_arrow_right",last:"last_page"},rating:{icon:"grade"},stepper:{done:"check",active:"edit",error:"warning"},tabs:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down"},table:{arrowUp:"arrow_upward",warning:"warning",firstPage:"first_page",prevPage:"chevron_left",nextPage:"chevron_right",lastPage:"last_page"},tree:{icon:"play_arrow"},uploader:{done:"done",clear:"clear",add:"add_box",upload:"cloud_upload",removeQueue:"clear_all",removeUploaded:"done_all"}},iconSet={install(t,e,i){const s=i||materialIcons;this.set=((e,i)=>{const s={...e};if(!0===isSSR){if(void 0===i)return void console.error("SSR ERROR: second param required: Quasar.iconSet.set(iconSet, ssrContext)");s.set=i.$q.iconSet.set,i.$q.iconSet=s}else s.set=this.set,t.iconSet=s}),!0===isSSR?e.server.push((t,e)=>{t.iconSet={},t.iconSet.set=(t=>{this.set(t,e.ssr)}),t.iconSet.set(s)}):(Vue.util.defineReactive(t,"iconMapFn",void 0),Vue.util.defineReactive(t,"iconSet",{}),this.set(s))}};const autoInstalled=[Platform,Screen,Dark],queues={server:[],takeover:[]},$q={version:version,config:{}};function install(t,e={}){if(!0===this.__qInstalled)return;this.__qInstalled=!0;const i=$q.config=Object.freeze(e.config||{});if(Platform.install($q,queues),Body.install(queues,i),Dark.install($q,queues,i),Screen.install($q,queues,i),History.install(i),lang.install($q,queues,e.lang),iconSet.install($q,queues,e.iconSet),!0===isSSR?t.mixin({beforeCreate(){this.$q=this.$root.$options.$q}}):t.prototype.$q=$q,e.components&&Object.keys(e.components).forEach(i=>{const s=e.components[i];"function"==typeof s&&t.component(s.options.name,s)}),e.directives&&Object.keys(e.directives).forEach(i=>{const s=e.directives[i];void 0!==s.name&&void 0!==s.unbind&&t.directive(s.name,s)}),e.plugins){const t={$q:$q,queues:queues,cfg:i};Object.keys(e.plugins).forEach(i=>{const s=e.plugins[i];"function"==typeof s.install&&!1===autoInstalled.includes(s)&&s.install(t)})}}const mixin={mounted(){queues.takeover.forEach(t=>{t(this.$q)})}};function ssrUpdate(t){if(t.ssr){const e={...$q,ssrContext:t.ssr};Object.assign(t.ssr,{Q_HEAD_TAGS:"",Q_BODY_ATTRS:"",Q_BODY_TAGS:""}),t.app.$q=t.ssr.$q=e,queues.server.forEach(i=>{i(e,t)})}else{const e=t.app.mixins||[];!1===e.includes(mixin)&&(t.app.mixins=e.concat(mixin))}}var VuePlugin={version:version,install:install,lang:lang,iconSet:iconSet,ssrUpdate:ssrUpdate};const units=["B","KB","MB","GB","TB","PB"];function humanStorageSize(t){let e=0;for(;parseInt(t,10)>=1024&&e<units.length-1;)t/=1024,++e;return`${t.toFixed(1)}${units[e]}`}function capitalize(t){return t.charAt(0).toUpperCase()+t.slice(1)}function between(t,e,i){return i<=e?e:Math.min(i,Math.max(e,t))}function normalizeToInterval(t,e,i){if(i<=e)return e;const s=i-e+1;let o=e+(t-e)%s;return o<e&&(o=s+o),0===o?0:o}function pad(t,e=2,i="0"){if(void 0===t||null===t)return t;const s=""+t;return s.length>=e?s:new Array(e-s.length+1).join(i)+s}var format={humanStorageSize:humanStorageSize,capitalize:capitalize,between:between,normalizeToInterval:normalizeToInterval,pad:pad};function cache(t,e,i){if(!0===isSSR)return i;const s=`__qcache_${e}`;return void 0===t[s]?t[s]=i:t[s]}function getPropCacheMixin(t,e){return{data:()=>({[e]:{}}),watch:{[t]:{immediate:!0,handler(t,i){const s=this[e];if(void 0!==i)for(const e in i)void 0===t[e]&&this.$delete(s,e);for(const e in t)s[e]!==t[e]&&this.$set(s,e,t[e])}}}}}const ariaHidden={"aria-hidden":"true"};var AttrsMixin=getPropCacheMixin("$attrs","qAttrs");const xhr=isSSR?null:XMLHttpRequest,send=isSSR?null:xhr.prototype.send,stackStart=[],stackStop=[];let highjackCount=0;function translate({p:t,pos:e,active:i,horiz:s,reverse:o,dir:n}){let r=1,a=1;return s?(o&&(r=-1),"bottom"===e&&(a=-1),{transform:`translate3d(${r*(t-100)}%,${i?0:-200*a}%,0)`}):(o&&(a=-1),"right"===e&&(r=-1),{transform:`translate3d(${i?0:n*r*-200}%,${a*(t-100)}%,0)`})}function inc(t,e){return"number"!=typeof e&&(e=t<25?3*Math.random()+3:t<65?3*Math.random():t<85?2*Math.random():t<99?.6:0),between(t+e,0,100)}function highjackAjax(t,e){function i(){stackStop.forEach(t=>{t()})}stackStart.push(t),stackStop.push(e),++highjackCount>1||(xhr.prototype.send=function(){stackStart.forEach(t=>{t()}),this.addEventListener("loadend",i,!1),send.apply(this,arguments)})}function restoreAjax(t,e){stackStart.splice(stackStart.indexOf(t),1),stackStop.splice(stackStop.indexOf(e),1),(highjackCount=Math.max(0,highjackCount-1))||(xhr.prototype.send=send)}var QAjaxBar=Vue.extend({name:"QAjaxBar",props:{position:{type:String,default:"top",validator:t=>["top","right","bottom","left"].includes(t)},size:{type:String,default:"2px"},color:String,skipHijack:Boolean,reverse:Boolean},data:()=>({calls:0,progress:0,onScreen:!1,animate:!0}),computed:{classes(){return`q-loading-bar q-loading-bar--${this.position}`+(void 0!==this.color?` bg-${this.color}`:"")+(!0===this.animate?"":" no-transition")},style(){const t=this.onScreen,e=translate({p:this.progress,pos:this.position,active:t,horiz:this.horizontal,reverse:!0===this.$q.lang.rtl&&["top","bottom"].includes(this.position)?!this.reverse:this.reverse,dir:!0===this.$q.lang.rtl?-1:1});return e[this.sizeProp]=this.size,e.opacity=t?1:0,e},horizontal(){return"top"===this.position||"bottom"===this.position},sizeProp(){return this.horizontal?"height":"width"},attrs(){return!0===this.onScreen?{role:"progressbar","aria-valuemin":0,"aria-valuemax":100,"aria-valuenow":this.progress}:ariaHidden}},methods:{start(t=300){const e=this.speed;this.speed=Math.max(0,t)||0,this.calls++,this.calls>1?0===e&&t>0?this.__work():e>0&&t<=0&&clearTimeout(this.timer):(clearTimeout(this.timer),this.$emit("start"),this.progress=0,!0!==this.onScreen&&(this.onScreen=!0,this.animate=!1,this.timer=setTimeout(()=>{this.animate=!0,t>0&&this.__work()},100)))},increment(t){this.calls>0&&(this.progress=inc(this.progress,t))},stop(){if(this.calls=Math.max(0,this.calls-1),this.calls>0)return;clearTimeout(this.timer),this.$emit("stop");const t=()=>{this.animate=!0,this.progress=100,this.timer=setTimeout(()=>{this.onScreen=!1},1e3)};0===this.progress?this.timer=setTimeout(t,1):t()},__work(){this.progress<100&&(this.timer=setTimeout(()=>{this.increment(),this.__work()},this.speed))}},mounted(){!0!==this.skipHijack&&(this.hijacked=!0,highjackAjax(this.start,this.stop))},beforeDestroy(){clearTimeout(this.timer),!0===this.hijacked&&restoreAjax(this.start,this.stop)},render(t){return t("div",{class:this.classes,style:this.style,attrs:this.attrs})}});const sizes={xs:18,sm:24,md:32,lg:38,xl:46};function getSizeMixin(t){return{props:{size:String},computed:{sizeStyle(){if(void 0!==this.size)return{fontSize:this.size in t?`${t[this.size]}px`:this.size}}}}}var SizeMixin=getSizeMixin(sizes),TagMixin={props:{tag:{type:String,default:"div"}}},ListenersMixin=getPropCacheMixin("$listeners","qListeners");function slot(t,e,i){return void 0!==t.$scopedSlots[e]?t.$scopedSlots[e]():i}function uniqueSlot(t,e,i){return void 0!==t.$scopedSlots[e]?t.$scopedSlots[e]().slice():i}function mergeSlot(t,e,i){return void 0!==e.$scopedSlots[i]?t.concat(e.$scopedSlots[i]()):t}function mergeSlotSafely(t,e,i){if(void 0===e.$scopedSlots[i])return t;const s=e.$scopedSlots[i]();return void 0!==t?t.concat(s):s}var QIcon=Vue.extend({name:"QIcon",mixins:[ListenersMixin,SizeMixin,TagMixin],props:{tag:{default:"i"},name:String,color:String,left:Boolean,right:Boolean},computed:{classes(){return"q-icon notranslate"+(!0===this.left?" on-left":"")+(!0===this.right?" on-right":"")+(void 0!==this.color?` text-${this.color}`:"")},type(){let t,e=this.name;if(!e)return{none:!0,cls:this.classes};if(void 0!==this.$q.iconMapFn){const t=this.$q.iconMapFn(e);if(void 0!==t){if(void 0===t.icon)return{cls:t.cls+" "+this.classes,content:void 0!==t.content?t.content:" "};e=t.icon}}if(!0===e.startsWith("M")){const[t,i]=e.split("|");return{svg:!0,cls:this.classes,nodes:t.split("&&").map(t=>{const[e,i,s]=t.split("@@");return this.$createElement("path",{attrs:{d:e,transform:s},style:i})}),viewBox:void 0!==i?i:"0 0 24 24"}}if(!0===e.startsWith("img:"))return{img:!0,cls:this.classes,src:e.substring(4)};if(!0===e.startsWith("svguse:"))return{svguse:!0,cls:this.classes,src:e.substring(7)};let i=" ";return/^[l|f]a[s|r|l|b|d]{0,1} /.test(e)||!0===e.startsWith("icon-")?t=e:!0===e.startsWith("bt-")?t=`bt ${e}`:!0===e.startsWith("eva-")?t=`eva ${e}`:!0===/^ion-(md|ios|logo)/.test(e)?t=`ionicons ${e}`:!0===e.startsWith("ion-")?t=`ionicons ion-${!0===this.$q.platform.is.ios?"ios":"md"}${e.substr(3)}`:!0===e.startsWith("mdi-")?t=`mdi ${e}`:!0===e.startsWith("iconfont ")?t=`${e}`:!0===e.startsWith("ti-")?t=`themify-icon ${e}`:(t="material-icons",!0===e.startsWith("o_")?(e=e.substring(2),t+="-outlined"):!0===e.startsWith("r_")?(e=e.substring(2),t+="-round"):!0===e.startsWith("s_")&&(e=e.substring(2),t+="-sharp"),i=e),{cls:t+" "+this.classes,content:i}}},render(t){const e={class:this.type.cls,style:this.sizeStyle,on:{...this.qListeners},attrs:{"aria-hidden":"true",role:"presentation"}};return!0===this.type.none?t(this.tag,e,slot(this,"default")):!0===this.type.img?(e.attrs.src=this.type.src,t("img",e)):!0===this.type.svg?(e.attrs.focusable="false",e.attrs.viewBox=this.type.viewBox,t("svg",e,mergeSlot(this.type.nodes,this,"default"))):!0===this.type.svguse?(e.attrs.focusable="false",e.attrs.viewBox=this.type.viewBox,t("svg",e,[t("use",{attrs:{"xlink:href":this.type.src}}),mergeSlot(this.type.nodes,this,"default")])):t(this.tag,e,mergeSlot([this.type.content],this,"default"))}}),QAvatar=Vue.extend({name:"QAvatar",mixins:[ListenersMixin,SizeMixin],props:{fontSize:String,color:String,textColor:String,icon:String,square:Boolean,rounded:Boolean},computed:{contentClass(){return{[`bg-${this.color}`]:this.color,[`text-${this.textColor} q-chip--colored`]:this.textColor,"q-avatar__content--square":this.square,"rounded-borders":this.rounded}},contentStyle(){if(this.fontSize)return{fontSize:this.fontSize}}},render(t){const e=void 0!==this.icon?[t(QIcon,{props:{name:this.icon}})]:void 0;return t("div",{staticClass:"q-avatar",style:this.sizeStyle,on:{...this.qListeners}},[t("div",{staticClass:"q-avatar__content row flex-center overflow-hidden",class:this.contentClass,style:this.contentStyle},mergeSlotSafely(e,this,"default"))])}}),QBadge=Vue.extend({name:"QBadge",mixins:[ListenersMixin],props:{color:String,textColor:String,floating:Boolean,transparent:Boolean,multiLine:Boolean,outline:Boolean,label:[Number,String],align:{type:String,validator:t=>["top","middle","bottom"].includes(t)}},computed:{style(){if(void 0!==this.align)return{verticalAlign:this.align}},classes(){const t=!0===this.outline&&this.color||this.textColor;return"q-badge flex inline items-center no-wrap"+` q-badge--${!0===this.multiLine?"multi":"single"}-line`+(!0===this.outline?" q-badge--outline":void 0!==this.color?` bg-${this.color}`:"")+(void 0!==t?` text-${t}`:"")+(!0===this.floating?" q-badge--floating":"")+(!0===this.transparent?" q-badge--transparent":"")},attrs(){return{role:"alert","aria-label":this.label}}},render(t){return t("div",{style:this.style,class:this.classes,attrs:this.attrs,on:{...this.qListeners}},void 0!==this.label?[this.label]:slot(this,"default"))}}),DarkMixin={props:{dark:{type:Boolean,default:null}},computed:{isDark(){return null===this.dark?this.$q.dark.isActive:this.dark}}};const attrs={role:"alert"};var QBanner=Vue.extend({name:"QBanner",mixins:[ListenersMixin,DarkMixin],props:{inlineActions:Boolean,dense:Boolean,rounded:Boolean},render(t){const e=slot(this,"action"),i=[t("div",{staticClass:"q-banner__avatar col-auto row items-center self-start"},slot(this,"avatar")),t("div",{staticClass:"q-banner__content col text-body2"},slot(this,"default"))];return void 0!==e&&i.push(t("div",{staticClass:"q-banner__actions row items-center justify-end",class:`col-${!0===this.inlineActions?"auto":"all"}`},e)),t("div",{staticClass:"q-banner row items-center",class:{"q-banner--top-padding":void 0!==e&&!this.inlineActions,"q-banner--dense":this.dense,"q-banner--dark q-dark":this.isDark,"rounded-borders":this.rounded},attrs:attrs,on:{...this.qListeners}},i)}});const attrs$1={role:"toolbar"};var QBar=Vue.extend({name:"QBar",mixins:[ListenersMixin,DarkMixin],props:{dense:Boolean},computed:{classes(){return`q-bar--${!0===this.dense?"dense":"standard"} `+`q-bar--${!0===this.isDark?"dark":"light"}`}},render(t){return t("div",{staticClass:"q-bar row no-wrap items-center",class:this.classes,attrs:attrs$1,on:{...this.qListeners}},slot(this,"default"))}});const alignMap={left:"start",center:"center",right:"end",between:"between",around:"around",evenly:"evenly",stretch:"stretch"},alignValues=Object.keys(alignMap);var AlignMixin={props:{align:{type:String,validator:t=>alignValues.includes(t)}},computed:{alignClass(){const t=void 0===this.align?!0===this.vertical?"stretch":"left":this.align;return`${!0===this.vertical?"items":"justify"}-${alignMap[t]}`}}},QBreadcrumbs=Vue.extend({name:"QBreadcrumbs",mixins:[ListenersMixin,AlignMixin],props:{separator:{type:String,default:"/"},separatorColor:String,activeColor:{type:String,default:"primary"},gutter:{type:String,validator:t=>["none","xs","sm","md","lg","xl"].includes(t),default:"sm"}},computed:{classes(){return`${this.alignClass}${"none"===this.gutter?"":` q-gutter-${this.gutter}`}`},sepClass(){if(this.separatorColor)return`text-${this.separatorColor}`},activeClass(){return`text-${this.activeColor}`}},render(t){const e=slot(this,"default");if(void 0===e)return;let i=1;const s=[],o=e.filter(t=>void 0!==t.tag&&t.tag.endsWith("-QBreadcrumbsEl")).length,n=void 0!==this.$scopedSlots.separator?this.$scopedSlots.separator:()=>this.separator;return e.forEach(e=>{if(void 0!==e.tag&&e.tag.endsWith("-QBreadcrumbsEl")){const r=i<o;i++,s.push(t("div",{staticClass:"flex items-center",class:r?this.activeClass:"q-breadcrumbs--last"},[e])),r&&s.push(t("div",{staticClass:"q-breadcrumbs__separator",class:this.sepClass},n()))}else s.push(e)}),t("div",{staticClass:"q-breadcrumbs",on:{...this.qListeners}},[t("div",{staticClass:"flex items-center",class:this.classes},s)])}});const routerLinkProps={to:[String,Object],exact:Boolean,append:Boolean,replace:Boolean,activeClass:String,exactActiveClass:String,disable:Boolean},RouterLinkMixin={props:routerLinkProps,computed:{hasRouterLink(){return!0!==this.disable&&void 0!==this.to&&null!==this.to&&""!==this.to},routerLinkProps(){return{to:this.to,exact:this.exact,append:this.append,replace:this.replace,activeClass:this.activeClass||"q-router-link--active",exactActiveClass:this.exactActiveClass||"q-router-link--exact-active",event:!0===this.disable?"":void 0}}}};var QBreadcrumbsEl=Vue.extend({name:"QBreadcrumbsEl",mixins:[ListenersMixin,RouterLinkMixin],props:{label:String,icon:String},render(t){const e=[];return void 0!==this.icon&&e.push(t(QIcon,{staticClass:"q-breadcrumbs__el-icon",class:void 0!==this.label?"q-breadcrumbs__el-icon--with-label":null,props:{name:this.icon}})),this.label&&e.push(this.label),t(!0===this.hasRouterLink?"router-link":"span",{staticClass:"q-breadcrumbs__el q-link flex inline items-center relative-position",props:!0===this.hasRouterLink?this.routerLinkProps:null,[!0===this.hasRouterLink?"nativeOn":"on"]:{...this.qListeners}},mergeSlot(e,this,"default"))}}),mixin$1={mixins:[ListenersMixin],props:{color:String,size:{type:[Number,String],default:"1em"}},computed:{cSize(){return this.size in sizes?`${sizes[this.size]}px`:this.size},classes(){if(this.color)return`text-${this.color}`}}},QSpinner=Vue.extend({name:"QSpinner",mixins:[mixin$1],props:{thickness:{type:Number,default:5}},render(t){return t("svg",{staticClass:"q-spinner q-spinner-mat",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"25 25 50 50"}},[t("circle",{staticClass:"path",attrs:{cx:"50",cy:"50",r:"20",fill:"none",stroke:"currentColor","stroke-width":this.thickness,"stroke-miterlimit":"10"}})])}});function offset(t){if(t===window)return{top:0,left:0};const{top:e,left:i}=t.getBoundingClientRect();return{top:e,left:i}}function style(t,e){return window.getComputedStyle(t).getPropertyValue(e)}function height(t){return t===window?window.innerHeight:t.getBoundingClientRect().height}function width(t){return t===window?window.innerWidth:t.getBoundingClientRect().width}function css(t,e){const i=t.style;Object.keys(e).forEach(t=>{i[t]=e[t]})}function cssBatch(t,e){t.forEach(t=>css(t,e))}function ready(t){if("function"==typeof t)return"loading"!==document.readyState?t():void document.addEventListener("DOMContentLoaded",t,!1)}function childHasFocus(t,e){if(void 0===t||!0===t.contains(e))return!0;for(let i=t.nextElementSibling;null!==i;i=i.nextElementSibling)if(i.contains(e))return!0;return!1}function getBodyFullscreenElement(t,e){return!0===t?e===document.documentElement?document.body:e:document.body}var dom={offset:offset,style:style,height:height,width:width,css:css,cssBatch:cssBatch,ready:ready};function throttle(t,e=250){let i,s=!1;return function(){return!1===s&&(s=!0,setTimeout(()=>{s=!1},e),i=t.apply(this,arguments)),i}}function showRipple(t,e,i,s){!0===i.modifiers.stop&&stop(t);const o=i.modifiers.color;let n=i.modifiers.center;n=!0===n||!0===s;const r=document.createElement("span"),a=document.createElement("span"),l=position(t),{left:h,top:d,width:c,height:u}=e.getBoundingClientRect(),p=Math.sqrt(c*c+u*u),m=p/2,g=`${(c-p)/2}px`,f=n?g:`${l.left-h-m}px`,_=`${(u-p)/2}px`,v=n?_:`${l.top-d-m}px`;a.className="q-ripple__inner",css(a,{height:`${p}px`,width:`${p}px`,transform:`translate3d(${f},${v},0) scale3d(.2,.2,1)`,opacity:0}),r.className=`q-ripple${o?" text-"+o:""}`,r.setAttribute("dir","ltr"),r.appendChild(a),e.appendChild(r);const b=()=>{r.remove(),clearTimeout(y)};i.abort.push(b);let y=setTimeout(()=>{a.classList.add("q-ripple__inner--enter"),a.style.transform=`translate3d(${g},${_},0) scale3d(1,1,1)`,a.style.opacity=.2,y=setTimeout(()=>{a.classList.remove("q-ripple__inner--enter"),a.classList.add("q-ripple__inner--leave"),a.style.opacity=0,y=setTimeout(()=>{r.remove(),i.abort.splice(i.abort.indexOf(b),1)},275)},250)},50)}function updateCtx(t,{value:e,modifiers:i,arg:s}){if(t.enabled=!1!==e,!0===t.enabled){const o=Object.assign({},$q.config.ripple,i,e);t.modifiers={early:!0===o.early,stop:!0===o.stop,center:!0===o.center,color:o.color||s,keyCodes:[].concat(o.keyCodes||13)}}}var Ripple={name:"ripple",inserted(t,e){const i={modifiers:{},abort:[],start(e){!0===i.enabled&&!0!==e.qSkipRipple&&(!0!==client.is.ie||e.clientX>=0)&&(!0===i.modifiers.early?!0===["mousedown","touchstart"].includes(e.type):"click"===e.type)&&showRipple(e,t,i,!0===e.qKeyEvent)},keystart:throttle(e=>{!0===i.enabled&&!0!==e.qSkipRipple&&!0===isKeyCode(e,i.modifiers.keyCodes)&&e.type===`key${!0===i.modifiers.early?"down":"up"}`&&showRipple(e,t,i,!0)},300)};updateCtx(i,e),t.__qripple&&(t.__qripple_old=t.__qripple),t.__qripple=i,addEvt(i,"main",[[t,"mousedown","start","passive"],[t,"touchstart","start","passive"],[t,"click","start","passive"],[t,"keydown","keystart","passive"],[t,"keyup","keystart","passive"]])},update(t,e){void 0!==t.__qripple&&updateCtx(t.__qripple,e)},unbind(t){const e=t.__qripple_old||t.__qripple;void 0!==e&&(e.abort.forEach(t=>{t()}),cleanEvt(e,"main"),delete t[t.__qripple_old?"__qripple_old":"__qripple"])}},RippleMixin={directives:{Ripple:Ripple},props:{ripple:{type:[Boolean,Object],default:!0}}};const padding={none:0,xs:4,sm:8,md:16,lg:24,xl:32};var BtnMixin={mixins:[ListenersMixin,RippleMixin,AlignMixin,getSizeMixin({xs:8,sm:10,md:14,lg:20,xl:24})],props:{type:String,to:[Object,String],replace:Boolean,label:[Number,String],icon:String,iconRight:String,round:Boolean,outline:Boolean,flat:Boolean,unelevated:Boolean,rounded:Boolean,push:Boolean,glossy:Boolean,size:String,fab:Boolean,fabMini:Boolean,padding:String,color:String,textColor:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,tabindex:[Number,String],align:{default:"center"},stack:Boolean,stretch:Boolean,loading:{type:Boolean,default:null},disable:Boolean},computed:{style(){if(!1===this.fab&&!1===this.fabMini)return this.sizeStyle},isRounded(){return!0===this.rounded||!0===this.fab||!0===this.fabMini},isActionable(){return!0!==this.disable&&!0!==this.loading},computedTabIndex(){return!0===this.isActionable?this.tabindex||0:-1},hasRouterLink(){return!0!==this.disable&&void 0!==this.to&&null!==this.to&&""!==this.to},isLink(){return"a"===this.type||!0===this.hasRouterLink},design(){return!0===this.flat?"flat":!0===this.outline?"outline":!0===this.push?"push":!0===this.unelevated?"unelevated":"standard"},attrs(){const t={tabindex:this.computedTabIndex};return"a"!==this.type&&(t.type=this.type||"button"),!0===this.hasRouterLink?(t.href=this.$router.resolve(this.to).href,t.role="link"):t.role="a"===this.type?"link":"button",!0===this.loading&&void 0!==this.percentage&&(t.role="progressbar",t["aria-valuemin"]=0,t["aria-valuemax"]=100,t["aria-valuenow"]=this.percentage),!0===this.disable&&(t.disabled="",t["aria-disabled"]=""),t},classes(){let t;return void 0!==this.color?t=!0===this.flat||!0===this.outline?`text-${this.textColor||this.color}`:`bg-${this.color} text-${this.textColor||"white"}`:this.textColor&&(t=`text-${this.textColor}`),`q-btn--${this.design} `+`q-btn--${!0===this.round?"round":`rectangle${!0===this.isRounded?" q-btn--rounded":""}`}`+(void 0!==t?" "+t:"")+(!0===this.isActionable?" q-btn--actionable q-focusable q-hoverable":!0===this.disable?" disabled":"")+(!0===this.fab?" q-btn--fab":!0===this.fabMini?" q-btn--fab-mini":"")+(!0===this.noCaps?" q-btn--no-uppercase":"")+(!0===this.noWrap?"":" q-btn--wrap")+(!0===this.dense?" q-btn--dense":"")+(!0===this.stretch?" no-border-radius self-stretch":"")+(!0===this.glossy?" glossy":"")},innerClasses(){return this.alignClass+(!0===this.stack?" column":" row")+(!0===this.noWrap?" no-wrap text-no-wrap":"")+(!0===this.loading?" q-btn__content--hidden":"")},wrapperStyle(){if(void 0!==this.padding)return{padding:this.padding.split(/\s+/).map(t=>t in padding?padding[t]+"px":t).join(" "),minWidth:"0",minHeight:"0"}}}};const directions=["left","right","up","down","horizontal","vertical"],modifiersAll={left:!0,right:!0,up:!0,down:!0,horizontal:!0,vertical:!0,all:!0};function getModifierDirections(t){const e={};return directions.forEach(i=>{t[i]&&(e[i]=!0)}),0===Object.keys(e).length?modifiersAll:(!0===e.horizontal&&(e.left=e.right=!0),!0===e.vertical&&(e.up=e.down=!0),!0===e.left&&!0===e.right&&(e.horizontal=!0),!0===e.up&&!0===e.down&&(e.vertical=!0),!0===e.horizontal&&!0===e.vertical&&(e.all=!0),e)}function updateModifiers(t,{oldValue:e,value:i,modifiers:s}){e!==i&&("function"!=typeof i&&t.end(),t.handler=i),(t.modifiers.mouseAllDir!==s.mouseAllDir||directions.some(e=>s[e]!==t.modifiers[e]))&&(t.modifiers=s,t.direction=getModifierDirections(s))}const getTouchTarget=!1===isSSR&&!0!==iosEmulated&&(!0===client.is.ios||window.navigator.vendor.toLowerCase().indexOf("apple")>-1)?()=>document:t=>t;function shouldStart(t,e){return void 0===e.event&&void 0!==t.target&&!0!==t.target.draggable&&"function"==typeof e.handler&&"INPUT"!==t.target.nodeName.toUpperCase()&&(void 0===t.qClonedBy||-1===t.qClonedBy.indexOf(e.uid))}const{passiveCapture:passiveCapture}=listenOpts;let touchTarget=void 0,keyboardTarget=void 0,mouseTarget=void 0;const iconAttrs={role:"img","aria-hidden":"true"};var QBtn=Vue.extend({name:"QBtn",mixins:[BtnMixin],props:{percentage:Number,darkPercentage:Boolean},computed:{hasLabel(){return void 0!==this.label&&null!==this.label&&""!==this.label},computedRipple(){return!1!==this.ripple&&{keyCodes:!0===this.isLink?[13,32]:[13],...!0===this.ripple?{}:this.ripple}},percentageStyle(){const t=Math.max(0,Math.min(100,this.percentage));if(t>0)return{transition:"transform 0.6s",transform:`translateX(${t-100}%)`}},onEvents(){if(!0===this.loading)return{mousedown:this.__onLoadingEvt,touchstart:this.__onLoadingEvt,click:this.__onLoadingEvt,keydown:this.__onLoadingEvt,keyup:this.__onLoadingEvt};if(!0===this.isActionable){const t={...this.qListeners,click:this.click,keydown:this.__onKeydown,mousedown:this.__onMousedown};return!0===this.$q.platform.has.touch&&(t.touchstart=this.__onTouchstart),t}return{}},directives(){if(!0!==this.disable&&!1!==this.ripple)return[{name:"ripple",value:this.computedRipple,modifiers:{center:this.round}}]}},methods:{click(t){if(void 0!==t){if(!0===t.defaultPrevented)return;const e=document.activeElement;if("submit"===this.type&&(!0===this.$q.platform.is.ie&&(t.clientX<0||t.clientY<0)||e!==document.body&&!1===this.$el.contains(e)&&!1===e.contains(this.$el))){this.$el.focus();const t=()=>{document.removeEventListener("keydown",stopAndPrevent,!0),document.removeEventListener("keyup",t,passiveCapture),void 0!==this.$el&&this.$el.removeEventListener("blur",t,passiveCapture)};document.addEventListener("keydown",stopAndPrevent,!0),document.addEventListener("keyup",t,passiveCapture),this.$el.addEventListener("blur",t,passiveCapture)}if(!0===this.hasRouterLink){if(!0===t.ctrlKey||!0===t.shiftKey||!0===t.altKey||!0===t.metaKey)return;stopAndPrevent(t)}}const e=()=>{const t=this.$router[!0===this.replace?"replace":"push"](this.to);void 0!==t&&"function"==typeof t.catch&&t.catch(noop)};this.$emit("click",t,e),!0===this.hasRouterLink&&!1!==t.navigate&&e()},__onKeydown(t){!0===isKeyCode(t,[13,32])&&(stopAndPrevent(t),keyboardTarget!==this.$el&&(void 0!==keyboardTarget&&this.__cleanup(),this.$el.focus(),keyboardTarget=this.$el,this.$el.classList.add("q-btn--active"),document.addEventListener("keyup",this.__onPressEnd,!0),this.$el.addEventListener("blur",this.__onPressEnd,passiveCapture))),this.$emit("keydown",t)},__onTouchstart(t){if(touchTarget!==this.$el){void 0!==touchTarget&&this.__cleanup(),touchTarget=this.$el;const e=this.touchTargetEl=getTouchTarget(t.target);e.addEventListener("touchcancel",this.__onPressEnd,passiveCapture),e.addEventListener("touchend",this.__onPressEnd,passiveCapture)}this.avoidMouseRipple=!0,clearTimeout(this.mouseTimer),this.mouseTimer=setTimeout(()=>{this.avoidMouseRipple=!1},200),this.$emit("touchstart",t)},__onMousedown(t){mouseTarget!==this.$el&&(void 0!==mouseTarget&&this.__cleanup(),mouseTarget=this.$el,this.$el.classList.add("q-btn--active"),document.addEventListener("mouseup",this.__onPressEnd,passiveCapture)),t.qSkipRipple=!0===this.avoidMouseRipple,this.$emit("mousedown",t)},__onPressEnd(t){if(void 0===t||"blur"!==t.type||document.activeElement!==this.$el){if(void 0!==t&&"keyup"===t.type){if(keyboardTarget===this.$el&&!0===isKeyCode(t,[13,32])){const e=new MouseEvent("click",t);e.qKeyEvent=!0,!0===t.defaultPrevented&&prevent(e),!0===t.cancelBubble&&stop(e),this.$el.dispatchEvent(e),stopAndPrevent(t),t.qKeyEvent=!0}this.$emit("keyup",t)}this.__cleanup()}},__cleanup(t){const e=this.$refs.blurTarget;if(!0===t||touchTarget!==this.$el&&mouseTarget!==this.$el||void 0===e||e===document.activeElement||(e.setAttribute("tabindex",-1),e.focus()),touchTarget===this.$el){const t=this.touchTargetEl;t.removeEventListener("touchcancel",this.__onPressEnd,passiveCapture),t.removeEventListener("touchend",this.__onPressEnd,passiveCapture),touchTarget=this.touchTargetEl=void 0}mouseTarget===this.$el&&(document.removeEventListener("mouseup",this.__onPressEnd,passiveCapture),mouseTarget=void 0),keyboardTarget===this.$el&&(document.removeEventListener("keyup",this.__onPressEnd,!0),void 0!==this.$el&&this.$el.removeEventListener("blur",this.__onPressEnd,passiveCapture),keyboardTarget=void 0),void 0!==this.$el&&this.$el.classList.remove("q-btn--active")},__onLoadingEvt(t){stopAndPrevent(t),t.qSkipRipple=!0}},beforeDestroy(){this.__cleanup(!0)},render(t){let e=[];void 0!==this.icon&&e.push(t(QIcon,{attrs:iconAttrs,props:{name:this.icon,left:!1===this.stack&&!0===this.hasLabel}})),!0===this.hasLabel&&e.push(t("span",{staticClass:"block"},[this.label])),e=mergeSlot(e,this,"default"),void 0!==this.iconRight&&!1===this.round&&e.push(t(QIcon,{attrs:iconAttrs,props:{name:this.iconRight,right:!1===this.stack&&!0===this.hasLabel}}));const i=[t("span",{staticClass:"q-focus-helper",ref:"blurTarget"})];return!0===this.loading&&void 0!==this.percentage&&i.push(t("span",{staticClass:"q-btn__progress absolute-full overflow-hidden"},[t("span",{staticClass:"q-btn__progress-indicator fit block",class:!0===this.darkPercentage?"q-btn__progress--dark":"",style:this.percentageStyle})])),i.push(t("span",{staticClass:"q-btn__wrapper col row q-anchor--skip",style:this.wrapperStyle},[t("span",{staticClass:"q-btn__content text-center col items-center q-anchor--skip",class:this.innerClasses},e)])),null!==this.loading&&i.push(t("transition",{props:{name:"q-transition--fade"}},!0===this.loading?[t("span",{key:"loading",staticClass:"absolute-full flex flex-center"},void 0!==this.$scopedSlots.loading?this.$scopedSlots.loading():[t(QSpinner)])]:void 0)),t(!0===this.isLink?"a":"button",{staticClass:"q-btn q-btn-item non-selectable no-outline",class:this.classes,style:this.style,attrs:this.attrs,on:this.onEvents,directives:this.directives},i)}}),QBtnGroup=Vue.extend({name:"QBtnGroup",mixin:[ListenersMixin],props:{unelevated:Boolean,outline:Boolean,flat:Boolean,rounded:Boolean,push:Boolean,stretch:Boolean,glossy:Boolean,spread:Boolean},computed:{classes(){return["unelevated","outline","flat","rounded","push","stretch","glossy"].filter(t=>!0===this[t]).map(t=>`q-btn-group--${t}`).join(" ")}},render(t){return t("div",{staticClass:"q-btn-group row no-wrap "+(!0===this.spread?"q-btn-group--spread":"inline"),class:this.classes,on:{...this.qListeners}},slot(this,"default"))}});function clearSelection(){if(void 0!==window.getSelection){const t=window.getSelection();void 0!==t.empty?t.empty():void 0!==t.removeAllRanges&&(t.removeAllRanges(),!0!==Platform.is.mobile&&t.addRange(document.createRange()))}else void 0!==document.selection&&document.selection.empty()}var AnchorMixin={props:{target:{default:!0},noParentEvent:Boolean,contextMenu:Boolean},watch:{contextMenu(t){void 0!==this.anchorEl&&(this.__unconfigureAnchorEl(),this.__configureAnchorEl(t))},target(){void 0!==this.anchorEl&&this.__unconfigureAnchorEl(),this.__pickAnchorEl()},noParentEvent(t){void 0!==this.anchorEl&&(!0===t?this.__unconfigureAnchorEl():this.__configureAnchorEl())}},methods:{__showCondition(t){return void 0!==this.anchorEl&&(void 0===t||(void 0===t.touches||t.touches.length<=1))},__contextClick(t){this.hide(t),this.$nextTick(()=>{this.show(t)}),prevent(t)},__toggleKey(t){!0===isKeyCode(t,13)&&this.toggle(t)},__mobileCleanup(t){this.anchorEl.classList.remove("non-selectable"),clearTimeout(this.touchTimer),!0===this.showing&&void 0!==t&&clearSelection()},__mobilePrevent:prevent,__mobileTouch(t){if(this.__mobileCleanup(t),!0!==this.__showCondition(t))return;this.hide(t),this.anchorEl.classList.add("non-selectable");const e=getTouchTarget(t.target);addEvt(this,"anchor",[[e,"touchmove","__mobileCleanup","passive"],[e,"touchend","__mobileCleanup","passive"],[e,"touchcancel","__mobileCleanup","passive"],[this.anchorEl,"contextmenu","__mobilePrevent","notPassive"]]),this.touchTimer=setTimeout(()=>{this.show(t)},300)},__unconfigureAnchorEl(){cleanEvt(this,"anchor")},__configureAnchorEl(t=this.contextMenu){if(!0===this.noParentEvent||void 0===this.anchorEl)return;let e;addEvt(this,"anchor",e=!0===t?!0===this.$q.platform.is.mobile?[[this.anchorEl,"touchstart","__mobileTouch","passive"]]:[[this.anchorEl,"click","hide","passive"],[this.anchorEl,"contextmenu","__contextClick","notPassive"]]:[[this.anchorEl,"click","toggle","passive"],[this.anchorEl,"keyup","__toggleKey","passive"]])},__setAnchorEl(t){for(this.anchorEl=t;this.anchorEl.classList.contains("q-anchor--skip");)this.anchorEl=this.anchorEl.parentNode;this.__configureAnchorEl()},__pickAnchorEl(){if(!1===this.target||""===this.target)this.anchorEl=void 0;else if(!0===this.target)this.__setAnchorEl(this.parentEl);else{let t=this.target;if("string"==typeof this.target)try{t=document.querySelector(this.target)}catch(e){t=void 0}void 0!==t&&null!==t?(this.anchorEl=!0===t._isVue&&void 0!==t.$el?t.$el:t,this.__configureAnchorEl()):(this.anchorEl=void 0,console.error(`Anchor: target "${this.target}" not found`,this))}},__changeScrollEvent(t,e){const i=`${void 0!==e?"add":"remove"}EventListener`,s=void 0!==e?e:this.__scrollFn;t!==window&&t[i]("scroll",s,listenOpts.passive),window[i]("scroll",s,listenOpts.passive),this.__scrollFn=e}},created(){"function"==typeof this.__configureScrollTarget&&"function"==typeof this.__unconfigureScrollTarget&&(this.noParentEventWatcher=this.$watch("noParentEvent",()=>{void 0!==this.__scrollTarget&&(this.__unconfigureScrollTarget(),this.__configureScrollTarget())}))},mounted(){this.parentEl=this.$el.parentNode,this.__pickAnchorEl(),!0===this.value&&void 0===this.anchorEl&&this.$emit("input",!1)},beforeDestroy(){clearTimeout(this.touchTimer),void 0!==this.noParentEventWatcher&&this.noParentEventWatcher(),void 0!==this.__anchorCleanup&&this.__anchorCleanup(),this.__unconfigureAnchorEl()}},TimeoutMixin={methods:{__nextTick(t){this.__tickFn=t},__prepareTick(){if(void 0!==this.__tickFn){const t=this.__tickFn;this.$nextTick(()=>{this.__tickFn===t&&(this.__tickFn(),this.__tickFn=void 0)})}},__clearTick(){this.__tickFn=void 0},__setTimeout(t,e){clearTimeout(this.__timer),this.__timer=setTimeout(t,e)},__clearTimeout(){clearTimeout(this.__timer)}},beforeDestroy(){this.__tickFn=void 0,clearTimeout(this.__timer)}},ModelToggleMixin={mixins:[TimeoutMixin,ListenersMixin],props:{value:{type:Boolean,default:void 0}},data:()=>({showing:!1}),watch:{value(t){this.__processModelChange(t)},$route(){!0===this.hideOnRouteChange&&!0===this.showing&&this.hide()}},methods:{toggle(t){this[!0===this.showing?"hide":"show"](t)},show(t){!0===this.disable||void 0!==this.__showCondition&&!0!==this.__showCondition(t)||(void 0!==this.qListeners.input&&!1===isSSR&&(this.$emit("input",!0),this.payload=t,this.$nextTick(()=>{this.payload===t&&(this.payload=void 0)})),void 0!==this.value&&void 0!==this.qListeners.input&&!0!==isSSR||this.__processShow(t))},__processShow(t){!0!==this.showing&&(void 0!==this.__preparePortal&&this.__preparePortal(),this.showing=!0,this.$emit("before-show",t),void 0!==this.__show?(this.__clearTick(),this.__show(t),this.__prepareTick()):this.$emit("show",t))},hide(t){!0!==this.disable&&(void 0!==this.qListeners.input&&!1===isSSR&&(this.$emit("input",!1),this.payload=t,this.$nextTick(()=>{this.payload===t&&(this.payload=void 0)})),void 0!==this.value&&void 0!==this.qListeners.input&&!0!==isSSR||this.__processHide(t))},__processHide(t){!1!==this.showing&&(this.showing=!1,this.$emit("before-hide",t),void 0!==this.__hide?(this.__clearTick(),this.__hide(t),this.__prepareTick()):this.$emit("hide",t))},__processModelChange(t){!0===this.disable&&!0===t?void 0!==this.qListeners.input&&this.$emit("input",!1):!0===t!==this.showing&&this[`__process${!0===t?"Show":"Hide"}`](this.payload)}}};function closePortalMenus(t,e){do{if("QMenu"===t.$options.name){if(t.hide(e),!0===t.separateClosePopup)return t.$parent}else if(void 0!==t.__renderPortal)return void 0!==t.$parent&&"QPopupProxy"===t.$parent.$options.name?(t.hide(e),t.$parent):t;t=t.$parent}while(void 0!==t)}function closePortals(t,e,i){for(;0!==i&&void 0!==t;){if(void 0!==t.__renderPortal){if(i--,"QMenu"===t.$options.name){t=closePortalMenus(t,e);continue}t.hide(e)}t=t.$parent}}function isOnGlobalDialog(t){for(;void 0!==t;){if("QGlobalDialog"===t.$options.name)return!0;if("QDialog"===t.$options.name)return!1;t=t.$parent}return!1}const Portal={inheritAttrs:!1,props:{contentClass:[Array,String,Object],contentStyle:[Array,String,Object]},methods:{__showPortal(){if(void 0!==this.$q.fullscreen&&!0===this.$q.fullscreen.isCapable){const t=t=>{if(void 0===this.__portal)return;const e=getBodyFullscreenElement(t,this.$q.fullscreen.activeEl);this.__portal.$el.parentElement!==e&&e.contains(this.$el)===(!1===this.__onGlobalDialog)&&e.appendChild(this.__portal.$el)};this.unwatchFullscreen=this.$watch("$q.fullscreen.isActive",t);const e=this.$q.fullscreen.isActive;!1!==this.__onGlobalDialog&&!0!==e||t(e)}else void 0!==this.__portal&&!1===this.__onGlobalDialog&&document.body.appendChild(this.__portal.$el)},__hidePortal(){void 0!==this.__portal&&(void 0!==this.unwatchFullscreen&&(this.unwatchFullscreen(),this.unwatchFullscreen=void 0),!1===this.__onGlobalDialog&&(this.__portal.$destroy(),this.__portal.$el.remove()),this.__portal=void 0)},__preparePortal(){void 0===this.__portal&&(this.__portal=!0===this.__onGlobalDialog?{$el:this.$el,$refs:this.$refs}:new Vue({name:"QPortal",parent:this,inheritAttrs:!1,render:t=>this.__renderPortal(t),components:this.$options.components,directives:this.$options.directives}).$mount())}},render(t){if(!0===this.__onGlobalDialog)return this.__renderPortal(t);void 0!==this.__portal&&this.__portal.$forceUpdate()},beforeDestroy(){this.__hidePortal()}};!1===isSSR&&(Portal.created=function(){this.__onGlobalDialog=isOnGlobalDialog(this.$parent)});var TransitionMixin={props:{transitionShow:{type:String,default:"fade"},transitionHide:{type:String,default:"fade"}},data(){return{transitionState:this.showing}},watch:{showing(t){this.transitionShow!==this.transitionHide&&this.$nextTick(()=>{this.transitionState=t})}},computed:{transition(){return"q-transition--"+(!0===this.transitionState?this.transitionHide:this.transitionShow)}}};function getVmOfNode(t){for(let e=t;null!==e;e=e.parentNode){if(null===e.__vue__)return;if(void 0!==e.__vue__)return e.__vue__}}function isVmChildOf(t,e){for(let i=t;void 0!==i;i=i.$parent)if(i===e)return!0;return!1}let timer;const{notPassiveCapture:notPassiveCapture,passiveCapture:passiveCapture$1}=listenOpts,handlers={click:[],focus:[]};function execHandlers(t,e){for(let i=t.length-1;i>=0;i--)if(void 0===t[i](e))return}function globalHandler(t){clearTimeout(timer),"focusin"===t.type&&!0===t.target.hasAttribute("tabindex")?timer=setTimeout(()=>{execHandlers(handlers.focus,t)},200):execHandlers(handlers.click,t)}var ClickOutside={name:"click-outside",bind(t,{value:e,arg:i},s){const o=s.componentInstance||s.context,n={trigger:e,toggleEl:i,handler(t){const e=t.target;if(!(void 0===e||8===e.nodeType||e===document.documentElement||!1!==e.classList.contains("no-pointer-events")||void 0!==n.toggleEl&&!1!==n.toggleEl.contains(e)||e!==document.body&&!1!==isVmChildOf(getVmOfNode(e),o)))return t.qClickOutside=!0,n.trigger(t)}};t.__qclickoutside&&(t.__qclickoutside_old=t.__qclickoutside),t.__qclickoutside=n,0===handlers.click.length&&(document.addEventListener("mousedown",globalHandler,notPassiveCapture),document.addEventListener("touchstart",globalHandler,notPassiveCapture),document.addEventListener("focusin",globalHandler,passiveCapture$1)),handlers.click.push(n.handler),n.timerFocusin=setTimeout(()=>{handlers.focus.push(n.handler)},500)},update(t,{value:e,oldValue:i,arg:s}){const o=t.__qclickoutside;e!==i&&(o.trigger=e),s!==o.arg&&(o.toggleEl=s)},unbind(t){const e=t.__qclickoutside_old||t.__qclickoutside;if(void 0!==e){clearTimeout(e.timerFocusin);const i=handlers.click.findIndex(t=>t===e.handler),s=handlers.focus.findIndex(t=>t===e.handler);i>-1&&handlers.click.splice(i,1),s>-1&&handlers.focus.splice(s,1),0===handlers.click.length&&(clearTimeout(timer),document.removeEventListener("mousedown",globalHandler,notPassiveCapture),document.removeEventListener("touchstart",globalHandler,notPassiveCapture),document.removeEventListener("focusin",globalHandler,passiveCapture$1)),delete t[t.__qclickoutside_old?"__qclickoutside_old":"__qclickoutside"]}}};const scrollTargets=!1===isSSR?[null,document,document.body,document.scrollingElement,document.documentElement]:[];function getScrollTarget(t,e){if("string"==typeof e)try{e=document.querySelector(e)}catch(t){e=void 0}return void 0===e||null===e?e=t.closest(".scroll,.scroll-y,.overflow-auto"):!0===e._isVue&&void 0!==e.$el&&(e=e.$el),scrollTargets.includes(e)?window:e}function getScrollHeight(t){return(t===window?document.body:t).scrollHeight}function getScrollWidth(t){return(t===window?document.body:t).scrollWidth}function getScrollPosition(t){return t===window?window.pageYOffset||window.scrollY||document.body.scrollTop||0:t.scrollTop}function getHorizontalScrollPosition(t){return t===window?window.pageXOffset||window.scrollX||document.body.scrollLeft||0:t.scrollLeft}function animScrollTo(t,e,i=0){const s=getScrollPosition(t);i<=0?s!==e&&setScroll(t,e):requestAnimationFrame(()=>{const o=s+(e-s)/Math.max(16,i)*16;setScroll(t,o),o!==e&&animScrollTo(t,e,i-16)})}function animHorizontalScrollTo(t,e,i=0){const s=getHorizontalScrollPosition(t);i<=0?s!==e&&setHorizontalScroll(t,e):requestAnimationFrame(()=>{const o=s+(e-s)/Math.max(16,i)*16;setHorizontalScroll(t,o),o!==e&&animHorizontalScrollTo(t,e,i-16)})}function setScroll(t,e){t!==window?t.scrollTop=e:window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,e)}function setHorizontalScroll(t,e){t!==window?t.scrollLeft=e:window.scrollTo(e,window.pageYOffset||window.scrollY||document.body.scrollTop||0)}function setScrollPosition(t,e,i){i?animScrollTo(t,e,i):setScroll(t,e)}function setHorizontalScrollPosition(t,e,i){i?animHorizontalScrollTo(t,e,i):setHorizontalScroll(t,e)}let size;function getScrollbarWidth(){if(void 0!==size)return size;const t=document.createElement("p"),e=document.createElement("div");css(t,{width:"100%",height:"200px"}),css(e,{position:"absolute",top:"0px",left:"0px",visibility:"hidden",width:"200px",height:"150px",overflow:"hidden"}),e.appendChild(t),document.body.appendChild(e);const i=t.offsetWidth;e.style.overflow="scroll";let s=t.offsetWidth;return i===s&&(s=e.clientWidth),e.remove(),size=i-s}function hasScrollbar(t,e=!0){return!(!t||t.nodeType!==Node.ELEMENT_NODE)&&(e?t.scrollHeight>t.clientHeight&&(t.classList.contains("scroll")||t.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(t)["overflow-y"])):t.scrollWidth>t.clientWidth&&(t.classList.contains("scroll")||t.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(t)["overflow-x"])))}var scroll={getScrollTarget:getScrollTarget,getScrollHeight:getScrollHeight,getScrollWidth:getScrollWidth,getScrollPosition:getScrollPosition,getHorizontalScrollPosition:getHorizontalScrollPosition,animScrollTo:animScrollTo,animHorizontalScrollTo:animHorizontalScrollTo,setScrollPosition:setScrollPosition,setHorizontalScrollPosition:setHorizontalScrollPosition,getScrollbarWidth:getScrollbarWidth,hasScrollbar:hasScrollbar};const handlers$1=[];let escDown=!1;var EscapeKey={__install(){this.__installed=!0,window.addEventListener("keydown",t=>{escDown=27===t.keyCode}),window.addEventListener("blur",()=>{!0===escDown&&(escDown=!1)}),window.addEventListener("keyup",t=>{!0===escDown&&(escDown=!1,0!==handlers$1.length&&!0===isKeyCode(t,27)&&handlers$1[handlers$1.length-1].fn(t))})},register(t,e){!0===t.$q.platform.is.desktop&&(!0!==this.__installed&&this.__install(),handlers$1.push({comp:t,fn:e}))},pop(t){if(!0===t.$q.platform.is.desktop){const e=handlers$1.findIndex(e=>e.comp===t);e>-1&&handlers$1.splice(e,1)}}};let vpLeft,vpTop;function validatePosition(t){const e=t.split(" ");return 2===e.length&&(["top","center","bottom"].includes(e[0])?!!["left","middle","right"].includes(e[1])||(console.error("Anchor/Self position must end with one of left/middle/right"),!1):(console.error("Anchor/Self position must start with one of top/center/bottom"),!1))}function validateOffset(t){return!t||2===t.length&&("number"==typeof t[0]&&"number"==typeof t[1])}function parsePosition(t){const e=t.split(" ");return{vertical:e[0],horizontal:e[1]}}function getAnchorProps(t,e){let{top:i,left:s,right:o,bottom:n,width:r,height:a}=t.getBoundingClientRect();return void 0!==e&&(i-=e[1],s-=e[0],n+=e[1],o+=e[0],r+=e[0],a+=e[1]),{top:i,left:s,right:o,bottom:n,width:r,height:a,middle:s+(o-s)/2,center:i+(n-i)/2}}function getTargetProps(t){return{top:0,center:t.offsetHeight/2,bottom:t.offsetHeight,left:0,middle:t.offsetWidth/2,right:t.offsetWidth}}function setPosition(t){if(!0===client.is.ios&&void 0!==window.visualViewport){const t=document.body.style,{offsetLeft:e,offsetTop:i}=window.visualViewport;e!==vpLeft&&(t.setProperty("--q-pe-left",e+"px"),vpLeft=e),i!==vpTop&&(t.setProperty("--q-pe-top",i+"px"),vpTop=i)}let e;const{scrollLeft:i,scrollTop:s}=t.el;if(void 0===t.absoluteOffset)e=getAnchorProps(t.anchorEl,!0===t.cover?[0,0]:t.offset);else{const{top:i,left:s}=t.anchorEl.getBoundingClientRect(),o=i+t.absoluteOffset.top,n=s+t.absoluteOffset.left;e={top:o,left:n,width:1,height:1,right:n+1,center:o,middle:n,bottom:o+1}}let o={maxHeight:t.maxHeight,maxWidth:t.maxWidth,visibility:"visible"};!0!==t.fit&&!0!==t.cover||(o.minWidth=e.width+"px",!0===t.cover&&(o.minHeight=e.height+"px")),Object.assign(t.el.style,o);const n=getTargetProps(t.el),r={top:e[t.anchorOrigin.vertical]-n[t.selfOrigin.vertical],left:e[t.anchorOrigin.horizontal]-n[t.selfOrigin.horizontal]};applyBoundaries(r,e,n,t.anchorOrigin,t.selfOrigin),o={top:r.top+"px",left:r.left+"px"},void 0!==r.maxHeight&&(o.maxHeight=r.maxHeight+"px",e.height>r.maxHeight&&(o.minHeight=o.maxHeight)),void 0!==r.maxWidth&&(o.maxWidth=r.maxWidth+"px",e.width>r.maxWidth&&(o.minWidth=o.maxWidth)),Object.assign(t.el.style,o),t.el.scrollTop!==s&&(t.el.scrollTop=s),t.el.scrollLeft!==i&&(t.el.scrollLeft=i)}function applyBoundaries(t,e,i,s,o){const n=i.bottom,r=i.right,a=getScrollbarWidth(),l=window.innerHeight-a,h=document.body.clientWidth;if(t.top<0||t.top+n>l)if("center"===o.vertical)t.top=e[s.vertical]>l/2?Math.max(0,l-n):0,t.maxHeight=Math.min(n,l);else if(e[s.vertical]>l/2){const i=Math.min(l,"center"===s.vertical?e.center:s.vertical===o.vertical?e.bottom:e.top);t.maxHeight=Math.min(n,i),t.top=Math.max(0,i-n)}else t.top=Math.max(0,"center"===s.vertical?e.center:s.vertical===o.vertical?e.top:e.bottom),t.maxHeight=Math.min(n,l-t.top);if(t.left<0||t.left+r>h)if(t.maxWidth=Math.min(r,h),"middle"===o.horizontal)t.left=e[s.horizontal]>h/2?Math.max(0,h-r):0;else if(e[s.horizontal]>h/2){const i=Math.min(h,"middle"===s.horizontal?e.middle:s.horizontal===o.horizontal?e.right:e.left);t.maxWidth=Math.min(r,i),t.left=Math.max(0,i-t.maxWidth)}else t.left=Math.max(0,"middle"===s.horizontal?e.middle:s.horizontal===o.horizontal?e.left:e.right),t.maxWidth=Math.min(r,h-t.left)}var QMenu=Vue.extend({name:"QMenu",mixins:[AttrsMixin,DarkMixin,AnchorMixin,ModelToggleMixin,Portal,TransitionMixin],directives:{ClickOutside:ClickOutside},props:{persistent:Boolean,autoClose:Boolean,separateClosePopup:Boolean,noRefocus:Boolean,noFocus:Boolean,fit:Boolean,cover:Boolean,square:Boolean,anchor:{type:String,validator:validatePosition},self:{type:String,validator:validatePosition},offset:{type:Array,validator:validateOffset},scrollTarget:{default:void 0},touchPosition:Boolean,maxHeight:{type:String,default:null},maxWidth:{type:String,default:null}},computed:{horizSide(){return!0===this.$q.lang.rtl?"right":"left"},anchorOrigin(){return parsePosition(this.anchor||(!0===this.cover?"center middle":`bottom ${this.horizSide}`))},selfOrigin(){return!0===this.cover?this.anchorOrigin:parsePosition(this.self||`top ${this.horizSide}`)},menuClass(){return(!0===this.square?" q-menu--square":"")+(!0===this.isDark?" q-menu--dark q-dark":"")},hideOnRouteChange(){return!0!==this.persistent},onEvents(){const t={...this.qListeners,input:stop,"popup-show":stop,"popup-hide":stop};return!0===this.autoClose&&(t.click=this.__onAutoClose),t},attrs(){return{tabindex:-1,...this.qAttrs}}},methods:{focus(){let t=void 0!==this.__portal&&void 0!==this.__portal.$refs?this.__portal.$refs.inner:void 0;void 0!==t&&!0!==t.contains(document.activeElement)&&(t=t.querySelector("[autofocus], [data-autofocus]")||t).focus()},__show(t){if(this.__refocusTarget=!1===this.noRefocus&&null!==document.activeElement?document.activeElement:void 0,EscapeKey.register(this,()=>{!0!==this.persistent&&(this.$emit("escape-key"),this.hide())}),this.__showPortal(),this.__configureScrollTarget(),this.absoluteOffset=void 0,void 0!==t&&(this.touchPosition||this.contextMenu)){const e=position(t);if(void 0!==e.left){const{top:t,left:i}=this.anchorEl.getBoundingClientRect();this.absoluteOffset={left:e.left-i,top:e.top-t}}}void 0===this.unwatch&&(this.unwatch=this.$watch(()=>this.$q.screen.width+"|"+this.$q.screen.height+"|"+this.self+"|"+this.anchor,this.updatePosition)),this.$el.dispatchEvent(create("popup-show",{bubbles:!0})),!0!==this.noFocus&&null!==document.activeElement&&document.activeElement.blur(),this.__nextTick(()=>{this.updatePosition(),!0!==this.noFocus&&this.focus()}),this.__setTimeout(()=>{!0===this.$q.platform.is.ios&&(this.__avoidAutoClose=this.autoClose,this.__portal.$el.click()),this.updatePosition(),this.$emit("show",t)},300)},__hide(t){this.__anchorCleanup(!0),void 0===this.__refocusTarget||null===this.__refocusTarget||void 0!==t&&!0===t.qClickOutside||this.__refocusTarget.focus(),this.$el.dispatchEvent(create("popup-hide",{bubbles:!0})),this.__setTimeout(()=>{this.__hidePortal(),this.$emit("hide",t)},300)},__anchorCleanup(t){this.absoluteOffset=void 0,void 0!==this.unwatch&&(this.unwatch(),this.unwatch=void 0),!0!==t&&!0!==this.showing||(EscapeKey.pop(this),this.__unconfigureScrollTarget())},__unconfigureScrollTarget(){void 0!==this.__scrollTarget&&(this.__changeScrollEvent(this.__scrollTarget),this.__scrollTarget=void 0)},__configureScrollTarget(){void 0===this.anchorEl&&void 0===this.scrollTarget||(this.__scrollTarget=getScrollTarget(this.anchorEl,this.scrollTarget),this.__changeScrollEvent(this.__scrollTarget,this.updatePosition))},__onAutoClose(t){!0!==this.__avoidAutoClose?(closePortalMenus(this,t),void 0!==this.qListeners.click&&this.$emit("click",t)):this.__avoidAutoClose=!1},updatePosition(){if(void 0===this.anchorEl||void 0===this.__portal)return;const t=this.__portal.$el;8!==t.nodeType?setPosition({el:t,offset:this.offset,anchorEl:this.anchorEl,anchorOrigin:this.anchorOrigin,selfOrigin:this.selfOrigin,absoluteOffset:this.absoluteOffset,fit:this.fit,cover:this.cover,maxHeight:this.maxHeight,maxWidth:this.maxWidth}):setTimeout(this.updatePosition,25)},__onClickOutside(t){if(!0!==this.persistent&&!0===this.showing){const e=t.target.classList;return this.hide(t),("touchstart"===t.type||e.contains("q-dialog__backdrop"))&&stopAndPrevent(t),!0}},__renderPortal(t){return t("transition",{props:{name:this.transition}},[!0===this.showing?t("div",{ref:"inner",staticClass:"q-menu q-position-engine scroll"+this.menuClass,class:this.contentClass,style:this.contentStyle,attrs:this.attrs,on:this.onEvents,directives:[{name:"click-outside",value:this.__onClickOutside,arg:this.anchorEl}]},slot(this,"default")):null])}},mounted(){this.__processModelChange(this.value)},beforeDestroy(){!0===this.showing&&void 0!==this.anchorEl&&this.anchorEl.dispatchEvent(create("popup-hide",{bubbles:!0}))}}),QBtnDropdown=Vue.extend({name:"QBtnDropdown",mixins:[BtnMixin],props:{value:Boolean,split:Boolean,dropdownIcon:String,contentClass:[Array,String,Object],contentStyle:[Array,String,Object],cover:Boolean,persistent:Boolean,autoClose:Boolean,menuAnchor:{type:String,default:"bottom right"},menuSelf:{type:String,default:"top right"},menuOffset:Array,disableMainBtn:Boolean,disableDropdown:Boolean,noIconAnimation:Boolean},data(){return{showing:this.value}},watch:{value(t){void 0!==this.$refs.menu&&this.$refs.menu[t?"show":"hide"]()}},render(t){const e=slot(this,"label",[]),i={"aria-expanded":!0===this.showing?"true":"false","aria-haspopup":!0};(!0===this.disable||!1===this.split&&!0===this.disableMainBtn||!0===this.disableDropdown)&&(i["aria-disabled"]="");const s=[t(QIcon,{props:{name:this.dropdownIcon||this.$q.iconSet.arrow.dropdown},class:"q-btn-dropdown__arrow"+(!0===this.showing&&!1===this.noIconAnimation?" rotate-180":"")+(!1===this.split?" q-btn-dropdown__arrow-container":"")})];if(!0!==this.disableDropdown&&s.push(t(QMenu,{ref:"menu",props:{cover:this.cover,fit:!0,persistent:this.persistent,autoClose:this.autoClose,anchor:this.menuAnchor,self:this.menuSelf,offset:this.menuOffset,contentClass:this.contentClass,contentStyle:this.contentStyle,separateClosePopup:!0},on:cache(this,"menu",{"before-show":t=>{this.showing=!0,this.$emit("before-show",t)},show:t=>{this.$emit("show",t),this.$emit("input",!0)},"before-hide":t=>{this.showing=!1,this.$emit("before-hide",t)},hide:t=>{this.$emit("hide",t),this.$emit("input",!1)}})},slot(this,"default"))),!1===this.split)return t(QBtn,{class:"q-btn-dropdown q-btn-dropdown--simple",props:{...this.$props,disable:!0===this.disable||!0===this.disableMainBtn,noWrap:!0,round:!1},attrs:i,on:cache(this,"nonSpl",{click:t=>{this.$emit("click",t)}})},e.concat(s));const o=t(QBtn,{class:"q-btn-dropdown--current",props:{...this.$props,disable:!0===this.disable||!0===this.disableMainBtn,noWrap:!0,iconRight:this.iconRight,round:!1},on:cache(this,"spl",{click:t=>{this.hide(),this.$emit("click",t)}})},e);return t(QBtnGroup,{props:{outline:this.outline,flat:this.flat,rounded:this.rounded,push:this.push,unelevated:this.unelevated,glossy:this.glossy,stretch:this.stretch},staticClass:"q-btn-dropdown q-btn-dropdown--split no-wrap q-btn-item"},[o,t(QBtn,{staticClass:"q-btn-dropdown__arrow-container",attrs:i,props:{disable:!0===this.disable||!0===this.disableDropdown,outline:this.outline,flat:this.flat,rounded:this.rounded,push:this.push,size:this.size,color:this.color,textColor:this.textColor,dense:this.dense,ripple:this.ripple}},s)])},methods:{toggle(t){this.$refs.menu&&this.$refs.menu.toggle(t)},show(t){this.$refs.menu&&this.$refs.menu.show(t)},hide(t){this.$refs.menu&&this.$refs.menu.hide(t)}},mounted(){!0===this.value&&this.show()}}),FormMixin={props:{name:String},computed:{formAttrs(){return{type:"hidden",name:this.name,value:this.value}}},methods:{__injectFormInput(t,e,i){t[e](this.$createElement("input",{staticClass:"hidden",class:i,attrs:this.formAttrs,domProps:this.formDomProps}))}}};const FormFieldMixin={props:{name:String},computed:{nameProp(){return this.name||this.for}}};var QBtnToggle=Vue.extend({name:"QBtnToggle",mixins:[ListenersMixin,RippleMixin,FormMixin],props:{value:{required:!0},options:{type:Array,required:!0,validator:t=>t.every(t=>("label"in t||"icon"in t||"slot"in t)&&"value"in t)},color:String,textColor:String,toggleColor:{type:String,default:"primary"},toggleTextColor:String,outline:Boolean,flat:Boolean,unelevated:Boolean,rounded:Boolean,push:Boolean,glossy:Boolean,size:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,readonly:Boolean,disable:Boolean,stack:Boolean,stretch:Boolean,spread:Boolean,clearable:Boolean},computed:{hasActiveValue(){return void 0!==this.options.find(t=>t.value===this.value)},formAttrs(){return{type:"hidden",name:this.name,value:this.value}}},methods:{__set(t,e,i){!0!==this.readonly&&(this.value===t?!0===this.clearable&&(this.$emit("input",null,null),this.$emit("clear")):this.$emit("input",t,e),this.$emit("click",i))}},render(t){const e=this.options.map((e,i)=>t(QBtn,{key:i,class:e.class,style:e.style,on:{...this.qListeners,click:t=>this.__set(e.value,e,t)},props:{disable:this.disable||e.disable,label:e.label,color:e.value===this.value?e.toggleColor||this.toggleColor:e.color||this.color,textColor:e.value===this.value?e.toggleTextColor||this.toggleTextColor:e.textColor||this.textColor,icon:e.icon,iconRight:e.iconRight,noCaps:void 0===e.noCaps?this.noCaps:!0===e.noCaps,noWrap:void 0===e.noWrap?this.noWrap:!0===e.noWrap,outline:this.outline,flat:this.flat,rounded:this.rounded,push:this.push,unelevated:this.unelevated,size:this.size,dense:this.dense,ripple:void 0===e.ripple?this.ripple:e.ripple,stack:void 0===e.stack?this.stack:!0===e.stack,tabindex:e.tabindex,stretch:void 0===e.stretch?this.stretch:!0===e.stretch}},void 0!==e.slot?slot(this,e.slot):void 0));return void 0!==this.name&&!0!==this.disable&&!0===this.hasActiveValue&&this.__injectFormInput(e,"push"),t(QBtnGroup,{staticClass:"q-btn-toggle",props:{outline:this.outline,flat:this.flat,rounded:this.rounded,push:this.push,stretch:this.stretch,unelevated:this.unelevated,glossy:this.glossy,spread:this.spread}},e)}}),QCard=Vue.extend({name:"QCard",mixins:[ListenersMixin,DarkMixin,TagMixin],props:{square:Boolean,flat:Boolean,bordered:Boolean},computed:{classes(){return"q-card"+(!0===this.isDark?" q-card--dark q-dark":"")+(!0===this.bordered?" q-card--bordered":"")+(!0===this.square?" q-card--square no-border-radius":"")+(!0===this.flat?" q-card--flat no-shadow":"")}},render(t){return t(this.tag,{class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QCardSection=Vue.extend({name:"QCardSection",mixins:[ListenersMixin,TagMixin],props:{horizontal:Boolean},computed:{classes(){return"q-card__section "+`q-card__section--${!0===this.horizontal?"horiz row no-wrap":"vert"}`}},render(t){return t(this.tag,{class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QCardActions=Vue.extend({name:"QCardActions",mixins:[ListenersMixin,AlignMixin],props:{vertical:Boolean},computed:{classes(){return`q-card__actions--${!0===this.vertical?"vert column":"horiz row"} ${this.alignClass}`}},render(t){return t("div",{staticClass:"q-card__actions",class:this.classes,on:{...this.qListeners}},slot(this,"default"))}});function parseArg(t){const e=[.06,6,50];return"string"==typeof t&&t.length&&t.split(":").forEach((t,i)=>{const s=parseFloat(t);s&&(e[i]=s)}),e}var TouchSwipe={name:"touch-swipe",bind(t,{value:e,arg:i,modifiers:s}){if(!0!==s.mouse&&!0!==client.has.touch)return;const o=!0===s.mouseCapture?"Capture":"",n={handler:e,sensitivity:parseArg(i),modifiers:s,direction:getModifierDirections(s),noop:noop,mouseStart(t){shouldStart(t,n)&&leftClick(t)&&(addEvt(n,"temp",[[document,"mousemove","move",`notPassive${o}`],[document,"mouseup","end","notPassiveCapture"]]),n.start(t,!0))},touchStart(t){if(shouldStart(t,n)){const e=getTouchTarget(t.target);addEvt(n,"temp",[[e,"touchmove","move","notPassiveCapture"],[e,"touchcancel","end","notPassiveCapture"],[e,"touchend","end","notPassiveCapture"]]),n.start(t)}},start(e,i){!0===client.is.firefox&&preventDraggable(t,!0);const s=position(e);n.event={x:s.left,y:s.top,time:Date.now(),mouse:!0===i,dir:!1}},move(t){if(void 0===n.event)return;if(!1!==n.event.dir)return void stopAndPrevent(t);const e=Date.now()-n.event.time;if(0===e)return;const i=position(t),s=i.left-n.event.x,o=Math.abs(s),r=i.top-n.event.y,a=Math.abs(r);if(!0!==n.event.mouse){if(o<n.sensitivity[1]&&a<n.sensitivity[1])return void n.end(t)}else if(o<n.sensitivity[2]&&a<n.sensitivity[2])return;const l=o/e,h=a/e;!0===n.direction.vertical&&o<a&&o<100&&h>n.sensitivity[0]&&(n.event.dir=r<0?"up":"down"),!0===n.direction.horizontal&&o>a&&a<100&&l>n.sensitivity[0]&&(n.event.dir=s<0?"left":"right"),!0===n.direction.up&&o<a&&r<0&&o<100&&h>n.sensitivity[0]&&(n.event.dir="up"),!0===n.direction.down&&o<a&&r>0&&o<100&&h>n.sensitivity[0]&&(n.event.dir="down"),!0===n.direction.left&&o>a&&s<0&&a<100&&l>n.sensitivity[0]&&(n.event.dir="left"),!0===n.direction.right&&o>a&&s>0&&a<100&&l>n.sensitivity[0]&&(n.event.dir="right"),!1!==n.event.dir?(stopAndPrevent(t),!0===n.event.mouse&&(document.body.classList.add("no-pointer-events--children"),document.body.classList.add("non-selectable"),clearSelection(),n.styleCleanup=(t=>{n.styleCleanup=void 0,document.body.classList.remove("non-selectable");const e=()=>{document.body.classList.remove("no-pointer-events--children")};!0===t?setTimeout(e,50):e()})),n.handler({evt:t,touch:!0!==n.event.mouse,mouse:n.event.mouse,direction:n.event.dir,duration:e,distance:{x:o,y:a}})):n.end(t)},end(e){void 0!==n.event&&(cleanEvt(n,"temp"),!0===client.is.firefox&&preventDraggable(t,!1),void 0!==n.styleCleanup&&n.styleCleanup(!0),void 0!==e&&!1!==n.event.dir&&stopAndPrevent(e),n.event=void 0)}};t.__qtouchswipe&&(t.__qtouchswipe_old=t.__qtouchswipe),t.__qtouchswipe=n,!0===s.mouse&&addEvt(n,"main",[[t,"mousedown","mouseStart",`passive${o}`]]),!0===client.has.touch&&addEvt(n,"main",[[t,"touchstart","touchStart",`passive${!0===s.capture?"Capture":""}`],[t,"touchmove","noop","notPassiveCapture"]])},update(t,e){void 0!==t.__qtouchswipe&&updateModifiers(t.__qtouchswipe,e)},unbind(t){const e=t.__qtouchswipe_old||t.__qtouchswipe;void 0!==e&&(cleanEvt(e,"main"),cleanEvt(e,"temp"),!0===client.is.firefox&&preventDraggable(t,!1),void 0!==e.styleCleanup&&e.styleCleanup(),delete t[t.__qtouchswipe_old?"__qtouchswipe_old":"__qtouchswipe"])}};const PanelWrapper=Vue.extend({name:"QTabPanelWrapper",render(t){return t("div",{staticClass:"q-panel scroll",attrs:{role:"tabpanel"},on:cache(this,"stop",{input:stop})},slot(this,"default"))}}),PanelParentMixin={mixins:[ListenersMixin],directives:{TouchSwipe:TouchSwipe},props:{value:{required:!0},animated:Boolean,infinite:Boolean,swipeable:Boolean,vertical:Boolean,transitionPrev:String,transitionNext:String,keepAlive:Boolean},data:()=>({panelIndex:null,panelTransition:null}),computed:{panelDirectives(){if(!0===this.swipeable)return[{name:"touch-swipe",value:this.__swipe,modifiers:{horizontal:!0!==this.vertical,vertical:this.vertical,mouse:!0}}]},contentKey(){return"string"==typeof this.value||"number"==typeof this.value?this.value:String(this.value)},transitionPrevComputed(){return this.transitionPrev||`slide-${!0===this.vertical?"down":"right"}`},transitionNextComputed(){return this.transitionNext||`slide-${!0===this.vertical?"up":"left"}`}},watch:{value(t,e){const i=!0===this.__isValidPanelName(t)?this.__getPanelIndex(t):-1;!0!==this.__forcedPanelTransition&&this.__updatePanelTransition(-1===i?0:i<this.__getPanelIndex(e)?-1:1),this.panelIndex!==i&&(this.panelIndex=i,this.$emit("before-transition",t,e),this.$nextTick(()=>{this.$emit("transition",t,e)}))}},methods:{next(){this.__go(1)},previous(){this.__go(-1)},goTo(t){this.$emit("input",t)},__isValidPanelName:t=>void 0!==t&&null!==t&&""!==t,__getPanelIndex(t){return this.panels.findIndex(e=>{const i=e.componentOptions;return i&&i.propsData.name===t&&""!==i.propsData.disable&&!0!==i.propsData.disable})},__getAllPanels(){return this.panels.filter(t=>void 0!==t.componentOptions&&this.__isValidPanelName(t.componentOptions.propsData.name))},__getAvailablePanels(){return this.panels.filter(t=>{const e=t.componentOptions;return e&&void 0!==e.propsData.name&&""!==e.propsData.disable&&!0!==e.propsData.disable})},__updatePanelTransition(t){const e=0!==t&&!0===this.animated&&-1!==this.panelIndex?"q-transition--"+(-1===t?this.transitionPrevComputed:this.transitionNextComputed):null;this.panelTransition!==e&&(this.panelTransition=e)},__go(t,e=this.panelIndex){let i=e+t;const s=this.panels;for(;i>-1&&i<s.length;){const e=s[i].componentOptions;if(void 0!==e&&""!==e.propsData.disable&&!0!==e.propsData.disable)return this.__updatePanelTransition(t),this.__forcedPanelTransition=!0,this.$emit("input",s[i].componentOptions.propsData.name),void setTimeout(()=>{this.__forcedPanelTransition=!1});i+=t}!0===this.infinite&&s.length>0&&-1!==e&&e!==s.length&&this.__go(t,-1===t?s.length:-1)},__swipe(t){const e=!0===this.vertical?"up":"left";this.__go((!0===this.$q.lang.rtl?-1:1)*(t.direction===e?1:-1))},__updatePanelIndex(){const t=this.__getPanelIndex(this.value);return this.panelIndex!==t&&(this.panelIndex=t),!0},__getPanelContent(t){if(0===this.panels.length)return;const e=this.__isValidPanelName(this.value)&&this.__updatePanelIndex()&&this.panels[this.panelIndex],i=!0===this.keepAlive?[t("keep-alive",[t(PanelWrapper,{key:this.contentKey},[e])])]:[t("div",{staticClass:"q-panel scroll",key:this.contentKey,attrs:{role:"tabpanel"},on:cache(this,"stop",{input:stop})},[e])];return!0===this.animated?[t("transition",{props:{name:this.panelTransition}},i)]:i}},render(t){return this.panels=slot(this,"default",[]),this.__renderPanels(t)}},PanelChildMixin={mixins:[ListenersMixin],props:{name:{required:!0},disable:Boolean}};var FullscreenMixin={props:{fullscreen:Boolean,noRouteFullscreenExit:Boolean},data:()=>({inFullscreen:!1}),watch:{$route(){!0!==this.noRouteFullscreenExit&&this.exitFullscreen()},fullscreen(t){this.inFullscreen!==t&&this.toggleFullscreen()},inFullscreen(t){this.$emit("update:fullscreen",t),this.$emit("fullscreen",t)}},methods:{toggleFullscreen(){!0===this.inFullscreen?this.exitFullscreen():this.setFullscreen()},setFullscreen(){!0!==this.inFullscreen&&(this.inFullscreen=!0,this.container=this.$el.parentNode,this.container.replaceChild(this.fullscreenFillerNode,this.$el),document.body.appendChild(this.$el),document.body.classList.add("q-body--fullscreen-mixin"),this.__historyFullscreen={handler:this.exitFullscreen},History.add(this.__historyFullscreen))},exitFullscreen(){!0===this.inFullscreen&&(void 0!==this.__historyFullscreen&&(History.remove(this.__historyFullscreen),this.__historyFullscreen=void 0),this.container.replaceChild(this.$el,this.fullscreenFillerNode),document.body.classList.remove("q-body--fullscreen-mixin"),this.inFullscreen=!1,void 0!==this.$el.scrollIntoView&&setTimeout(()=>{this.$el.scrollIntoView()}))}},beforeMount(){this.fullscreenFillerNode=document.createElement("span")},mounted(){!0===this.fullscreen&&this.setFullscreen()},beforeDestroy(){this.exitFullscreen()}};const hasMap="function"==typeof Map,hasSet="function"==typeof Set,hasArrayBuffer="function"==typeof ArrayBuffer;function isDeepEqual(t,e){if(t===e)return!0;if(null!==t&&null!==e&&"object"==typeof t&&"object"==typeof e){if(t.constructor!==e.constructor)return!1;let i,s;if(t.constructor===Array){if((i=t.length)!==e.length)return!1;for(s=i;0!=s--;)if(!0!==isDeepEqual(t[s],e[s]))return!1;return!0}if(!0===hasMap&&t.constructor===Map){if(t.size!==e.size)return!1;for(s=t.entries().next();!0!==s.done;){if(!0!==e.has(s.value[0]))return!1;s=s.next()}for(s=t.entries().next();!0!==s.done;){if(!0!==isDeepEqual(s.value[1],e.get(s.value[0])))return!1;s=s.next()}return!0}if(!0===hasSet&&t.constructor===Set){if(t.size!==e.size)return!1;for(s=t.entries().next();!0!==s.done;){if(!0!==e.has(s.value[0]))return!1;s=s.next()}return!0}if(!0===hasArrayBuffer&&null!=t.buffer&&t.buffer.constructor===ArrayBuffer){if((i=t.length)!==e.length)return!1;for(s=i;0!=s--;)if(t[s]!==e[s])return!1;return!0}if(t.constructor===RegExp)return t.source===e.source&&t.flags===e.flags;if(t.valueOf!==Object.prototype.valueOf)return t.valueOf()===e.valueOf();if(t.toString!==Object.prototype.toString)return t.toString()===e.toString();const o=Object.keys(t);if((i=o.length)!==Object.keys(e).length)return!1;for(s=i;0!=s--;){const i=o[s];if(!0!==isDeepEqual(t[i],e[i]))return!1}return!0}return t!=t&&e!=e}function isDate(t){return"[object Date]"===Object.prototype.toString.call(t)}function isNumber(t){return"number"==typeof t&&isFinite(t)}var QCarousel=Vue.extend({name:"QCarousel",mixins:[DarkMixin,PanelParentMixin,FullscreenMixin],props:{height:String,padding:Boolean,controlType:{type:String,validator:t=>["regular","flat","outline","push","unelevated"].includes(t),default:"flat"},controlColor:String,controlTextColor:String,autoplay:[Number,Boolean],arrows:Boolean,prevIcon:String,nextIcon:String,navigation:Boolean,navigationPosition:{type:String,validator:t=>["top","right","bottom","left"].includes(t)},navigationIcon:String,thumbnails:Boolean},computed:{style(){if(!0!==this.inFullscreen&&void 0!==this.height)return{height:this.height}},direction(){return!0===this.vertical?"vertical":"horizontal"},classes(){return`q-carousel q-panel-parent q-carousel--with${!0===this.padding?"":"out"}-padding`+(!0===this.inFullscreen?" fullscreen":"")+(!0===this.isDark?" q-carousel--dark q-dark":"")+(!0===this.arrows?` q-carousel--arrows-${this.direction}`:"")+(!0===this.navigation?` q-carousel--navigation-${this.navigationPositionComputed}`:"")},arrowIcons(){const t=[this.prevIcon||this.$q.iconSet.carousel[!0===this.vertical?"up":"left"],this.nextIcon||this.$q.iconSet.carousel[!0===this.vertical?"down":"right"]];return!1===this.vertical&&!0===this.$q.lang.rtl?t.reverse():t},navIcon(){return this.navigationIcon||this.$q.iconSet.carousel.navigationIcon},navigationPositionComputed(){return this.navigationPosition||(!0===this.vertical?"right":"bottom")},controlProps(){return{color:this.controlColor,textColor:this.controlTextColor,round:!0,[this.controlType]:!0,dense:!0}},transitionPrevComputed(){return this.transitionPrev||"fade"},transitionNextComputed(){return this.transitionNext||"fade"}},watch:{value(){this.autoplay&&(clearInterval(this.timer),this.__startTimer())},autoplay(t){t?this.__startTimer():clearInterval(this.timer)}},methods:{__startTimer(){this.timer=setTimeout(this.next,isNumber(this.autoplay)?this.autoplay:5e3)},__getNavigationContainer(t,e,i){return t("div",{class:"q-carousel__control q-carousel__navigation no-wrap absolute flex"+` q-carousel__navigation--${e} q-carousel__navigation--${this.navigationPositionComputed}`+(void 0!==this.controlColor?` text-${this.controlColor}`:"")},[t("div",{staticClass:"q-carousel__navigation-inner flex no-wrap justify-center"},this.__getAvailablePanels().map(i))])},__getContent(t){const e=[];if(!0===this.navigation)e.push(this.__getNavigationContainer(t,"buttons",e=>{const i=e.componentOptions.propsData.name;return t(QBtn,{key:i,class:`q-carousel__navigation-icon q-carousel__navigation-icon--${i===this.value?"":"in"}active`,props:{icon:this.navIcon,size:"sm",...this.controlProps},on:cache(this,"nav#"+i,{click:()=>{this.goTo(i)}})})}));else if(!0===this.thumbnails){const i=void 0!==this.controlColor?` text-${this.controlColor}`:"";e.push(this.__getNavigationContainer(t,"thumbnails",e=>{const s=e.componentOptions.propsData;return t("img",{class:`q-carousel__thumbnail q-carousel__thumbnail--${s.name===this.value?"":"in"}active`+i,attrs:{src:s.imgSrc},key:"tmb#"+s.name,on:cache(this,"tmb#"+s.name,{click:()=>{this.goTo(s.name)}})})}))}return!0===this.arrows&&e.push(t("div",{staticClass:`q-carousel__control q-carousel__arrow q-carousel__prev-arrow q-carousel__prev-arrow--${this.direction} absolute flex flex-center`},[t(QBtn,{props:{icon:this.arrowIcons[0],...this.controlProps},on:cache(this,"prev",{click:this.previous})})]),t("div",{staticClass:`q-carousel__control q-carousel__arrow q-carousel__next-arrow q-carousel__next-arrow--${this.direction} absolute flex flex-center`},[t(QBtn,{props:{icon:this.arrowIcons[1],...this.controlProps},on:cache(this,"next",{click:this.next})})])),mergeSlot(e,this,"control")},__renderPanels(t){return t("div",{style:this.style,class:this.classes,on:{...this.qListeners}},[t("div",{staticClass:"q-carousel__slides-container",directives:this.panelDirectives},this.__getPanelContent(t))].concat(this.__getContent(t)))}},mounted(){this.autoplay&&this.__startTimer()},beforeDestroy(){clearInterval(this.timer)}}),QCarouselSlide=Vue.extend({name:"QCarouselSlide",mixins:[PanelChildMixin],props:{imgSrc:String},computed:{style(){if(this.imgSrc)return{backgroundImage:`url("${this.imgSrc}")`}}},render(t){return t("div",{staticClass:"q-carousel__slide",style:this.style,on:{...this.qListeners}},slot(this,"default"))}}),QCarouselControl=Vue.extend({name:"QCarouselControl",mixins:[ListenersMixin],props:{position:{type:String,default:"bottom-right",validator:t=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(t)},offset:{type:Array,default:()=>[18,18],validator:t=>2===t.length}},computed:{classes(){return`absolute-${this.position}`},style(){return{margin:`${this.offset[1]}px ${this.offset[0]}px`}}},render(t){return t("div",{staticClass:"q-carousel__control absolute",style:this.style,class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QChatMessage=Vue.extend({name:"QChatMessage",mixins:[ListenersMixin],props:{sent:Boolean,label:String,bgColor:String,textColor:String,name:String,avatar:String,text:Array,stamp:String,size:String,labelSanitize:Boolean,nameSanitize:Boolean,textSanitize:Boolean,stampSanitize:Boolean},computed:{textClass(){return`q-message-text-content q-message-text-content--${this.op}`+(void 0!==this.textColor?` text-${this.textColor}`:"")},messageClass(){return`q-message-text q-message-text--${this.op}`+(void 0!==this.bgColor?` text-${this.bgColor}`:"")},containerClass(){return"q-message-container row items-end no-wrap"+(!0===this.sent?" reverse":"")},sizeClass(){if(void 0!==this.size)return`col-${this.size}`},op(){return!0===this.sent?"sent":"received"}},methods:{__getText(t){const e=!0===this.textSanitize?"textContent":"innerHTML",i=!0===this.stampSanitize?"textContent":"innerHTML";return this.text.map((s,o)=>t("div",{key:o,class:this.messageClass},[t("div",{class:this.textClass},[t("div",{domProps:{[e]:s}}),this.stamp?t("div",{staticClass:"q-message-stamp",domProps:{[i]:this.stamp}}):null])]))},__getMessage(t){const e=uniqueSlot(this,"default",[]);return void 0!==this.stamp&&e.push(t("div",{staticClass:"q-message-stamp",domProps:{[!0===this.stampSanitize?"textContent":"innerHTML"]:this.stamp}})),t("div",{class:this.messageClass},[t("div",{staticClass:"q-message-text-content",class:this.textClass},e)])}},render(t){const e=[];void 0!==this.$scopedSlots.avatar?e.push(this.$scopedSlots.avatar()):void 0!==this.avatar&&e.push(t("img",{class:`q-message-avatar q-message-avatar--${this.op}`,attrs:{src:this.avatar,"aria-hidden":"true"}}));const i=[];void 0!==this.name&&i.push(t("div",{class:`q-message-name q-message-name--${this.op}`,domProps:{[!0===this.nameSanitize?"textContent":"innerHTML"]:this.name}})),void 0!==this.text&&i.push(this.__getText(t)),void 0!==this.$scopedSlots.default&&i.push(this.__getMessage(t)),e.push(t("div",{class:this.sizeClass},i));const s=[];return this.label&&s.push(t("div",{staticClass:"q-message-label text-center",domProps:{[!0===this.labelSanitize?"textContent":"innerHTML"]:this.label}})),s.push(t("div",{class:this.containerClass},e)),t("div",{class:`q-message q-message-${this.op}`,on:{...this.qListeners}},s)}}),OptionSizeMixin=getSizeMixin({xs:30,sm:35,md:40,lg:50,xl:60}),RefocusTargetMixin={computed:{__refocusTargetEl(){if(!0!==this.disable)return this.$createElement("span",{ref:"refocusTarget",staticClass:"no-outline",attrs:{tabindex:-1}})}},methods:{__refocusTarget(t){void 0!==t&&0===t.type.indexOf("key")?document.activeElement!==this.$el&&!0===this.$el.contains(document.activeElement)&&this.$el.focus():void 0!==t&&!0!==this.$el.contains(t.target)||void 0===this.$refs.refocusTarget||this.$refs.refocusTarget.focus()}}},CheckboxMixin={mixins:[DarkMixin,OptionSizeMixin,FormMixin,RefocusTargetMixin],props:{value:{required:!0,default:null},val:{},trueValue:{default:!0},falseValue:{default:!1},indeterminateValue:{default:null},toggleOrder:{type:String,validator:t=>"tf"===t||"ft"===t},toggleIndeterminate:Boolean,label:String,leftLabel:Boolean,fontSize:String,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},computed:{isTrue(){return!0===this.modelIsArray?this.index>-1:this.value===this.trueValue},isFalse(){return!0===this.modelIsArray?-1===this.index:this.value===this.falseValue},isIndeterminate(){return!1===this.isTrue&&!1===this.isFalse},index(){if(!0===this.modelIsArray)return this.value.indexOf(this.val)},modelIsArray(){return void 0!==this.val&&Array.isArray(this.value)},computedTabindex(){return!0===this.disable?-1:this.tabindex||0},labelStyle(){if(void 0!==this.fontSize)return{fontSize:this.fontSize}},classes(){return`q-${this.type} cursor-pointer no-outline row inline no-wrap items-center`+(!0===this.disable?" disabled":"")+(!0===this.isDark?` q-${this.type}--dark`:"")+(!0===this.dense?` q-${this.type}--dense`:"")+(!0===this.leftLabel?" reverse":"")},innerClass(){const t=!0===this.isTrue?"truthy":!0===this.isFalse?"falsy":"indet",e=void 0===this.color||!0!==this.keepColor&&("toggle"===this.type?!0!==this.isTrue:!0===this.isFalse)?"":` text-${this.color}`;return`q-${this.type}__inner--${t}${e}`},formAttrs(){const t={type:"checkbox"};return void 0!==this.name&&Object.assign(t,{checked:this.isTrue,name:this.name,value:!0===this.modelIsArray?this.val:this.trueValue}),t},attrs(){const t={tabindex:this.computedTabindex,role:"checkbox","aria-label":this.label,"aria-checked":!0===this.isIndeterminate?"mixed":!0===this.isTrue?"true":"false"};return!0===this.disable&&(t["aria-disabled"]=""),t}},methods:{toggle(t){void 0!==t&&(stopAndPrevent(t),this.__refocusTarget(t)),!0!==this.disable&&this.$emit("input",this.__getNextValue(),t)},__getNextValue(){if(!0===this.modelIsArray){if(!0===this.isTrue){const t=this.value.slice();return t.splice(this.index,1),t}return this.value.concat([this.val])}if(!0===this.isTrue){if("ft"!==this.toggleOrder||!1===this.toggleIndeterminate)return this.falseValue}else{if(!0!==this.isFalse)return"ft"!==this.toggleOrder?this.trueValue:this.falseValue;if("ft"===this.toggleOrder||!1===this.toggleIndeterminate)return this.trueValue}return this.indeterminateValue},__onKeydown(t){13!==t.keyCode&&32!==t.keyCode||stopAndPrevent(t)},__onKeyup(t){13!==t.keyCode&&32!==t.keyCode||this.toggle(t)}},render(t){const e=this.__getInner(t);!0!==this.disable&&this.__injectFormInput(e,"unshift",`q-${this.type}__native absolute q-ma-none q-pa-none invisible`);const i=[t("div",{staticClass:`q-${this.type}__inner relative-position no-pointer-events`,class:this.innerClass,style:this.sizeStyle},e)];void 0!==this.__refocusTargetEl&&i.push(this.__refocusTargetEl);const s=void 0!==this.label?mergeSlot([this.label],this,"default"):slot(this,"default");return void 0!==s&&i.push(t("div",{staticClass:`q-${this.type}__label q-anchor--skip`},s)),t("div",{class:this.classes,attrs:this.attrs,on:cache(this,"inpExt",{click:this.toggle,keydown:this.__onKeydown,keyup:this.__onKeyup})},i)}},QCheckbox=Vue.extend({name:"QCheckbox",mixins:[CheckboxMixin],methods:{__getInner:t=>[t("div",{staticClass:"q-checkbox__bg absolute"},[t("svg",{staticClass:"q-checkbox__svg fit absolute-full",attrs:{focusable:"false",viewBox:"0 0 24 24"}},[t("path",{staticClass:"q-checkbox__truthy",attrs:{fill:"none",d:"M1.73,12.91 8.1,19.28 22.79,4.59"}}),t("path",{staticClass:"q-checkbox__indet",attrs:{d:"M4,14H20V10H4"}})])])]},created(){this.type="checkbox"}}),QChip=Vue.extend({name:"QChip",mixins:[RippleMixin,DarkMixin,getSizeMixin({xs:8,sm:10,md:14,lg:20,xl:24})],model:{event:"remove"},props:{dense:Boolean,icon:String,iconRight:String,iconRemove:String,label:[String,Number],color:String,textColor:String,value:{type:Boolean,default:!0},selected:{type:Boolean,default:null},square:Boolean,outline:Boolean,clickable:Boolean,removable:Boolean,tabindex:[String,Number],disable:Boolean},computed:{classes(){const t=!0===this.outline&&this.color||this.textColor;return{[`bg-${this.color}`]:!1===this.outline&&void 0!==this.color,[`text-${t} q-chip--colored`]:t,disabled:this.disable,"q-chip--dense":this.dense,"q-chip--outline":this.outline,"q-chip--selected":this.selected,"q-chip--clickable cursor-pointer non-selectable q-hoverable":this.isClickable,"q-chip--square":this.square,"q-chip--dark q-dark":this.isDark}},hasLeftIcon(){return!0===this.selected||void 0!==this.icon},isClickable(){return!1===this.disable&&(!0===this.clickable||null!==this.selected)},attrs(){return!0===this.disable?{tabindex:-1,"aria-disabled":""}:{tabindex:this.tabindex||0}}},methods:{__onKeyup(t){13===t.keyCode&&this.__onClick(t)},__onClick(t){this.disable||(this.$emit("update:selected",!this.selected),this.$emit("click",t))},__onRemove(t){void 0!==t.keyCode&&13!==t.keyCode||(stopAndPrevent(t),!this.disable&&this.$emit("remove",!1))},__getContent(t){const e=[];!0===this.isClickable&&e.push(t("div",{staticClass:"q-focus-helper"})),!0===this.hasLeftIcon&&e.push(t(QIcon,{staticClass:"q-chip__icon q-chip__icon--left",props:{name:!0===this.selected?this.$q.iconSet.chip.selected:this.icon}}));const i=void 0!==this.label?[t("div",{staticClass:"ellipsis"},[this.label])]:void 0;return e.push(t("div",{staticClass:"q-chip__content col row no-wrap items-center q-anchor--skip"},mergeSlotSafely(i,this,"default"))),this.iconRight&&e.push(t(QIcon,{staticClass:"q-chip__icon q-chip__icon--right",props:{name:this.iconRight}})),!0===this.removable&&e.push(t(QIcon,{staticClass:"q-chip__icon q-chip__icon--remove cursor-pointer",props:{name:this.iconRemove||this.$q.iconSet.chip.remove},attrs:this.attrs,on:cache(this,"non",{click:this.__onRemove,keyup:this.__onRemove})})),e}},render(t){if(!1===this.value)return;const e={staticClass:"q-chip row inline no-wrap items-center",class:this.classes,style:this.sizeStyle};return!0===this.isClickable&&Object.assign(e,{attrs:this.attrs,on:cache(this,"click",{click:this.__onClick,keyup:this.__onKeyup}),directives:cache(this,"dir#"+this.ripple,[{name:"ripple",value:this.ripple}])}),t("div",e,this.__getContent(t))}});const radius=50,diameter=100,circumference=100*Math.PI,strokeDashArray=Math.round(1e3*circumference)/1e3;var QCircularProgress=Vue.extend({name:"QCircularProgress",mixins:[ListenersMixin,SizeMixin],props:{value:{type:Number,default:0},min:{type:Number,default:0},max:{type:Number,default:100},color:String,centerColor:String,trackColor:String,fontSize:String,thickness:{type:Number,default:.2,validator:t=>t>=0&&t<=1},angle:{type:Number,default:0},indeterminate:Boolean,showValue:Boolean,reverse:Boolean,instantFeedback:Boolean},computed:{normalizedValue(){return between(this.value,this.min,this.max)},svgStyle(){return{transform:`rotate3d(0, 0, 1, ${this.angle-90}deg)`}},circleStyle(){if(!0!==this.instantFeedback&&!0!==this.indeterminate)return{transition:"stroke-dashoffset 0.6s ease 0s, stroke 0.6s ease"}},dir(){return(!0===this.$q.lang.rtl?-1:1)*(this.reverse?-1:1)},viewBox(){return 100/(1-this.thickness/2)},viewBoxAttr(){return`${this.viewBox/2} ${this.viewBox/2} ${this.viewBox} ${this.viewBox}`},strokeDashOffset(){const t=1-(this.normalizedValue-this.min)/(this.max-this.min);return this.dir*t*circumference},strokeWidth(){return this.thickness/2*this.viewBox},attrs(){return{role:"progressbar","aria-valuemin":this.min,"aria-valuemax":this.max,"aria-valuenow":!0===this.indeterminate?void 0:this.normalizedValue}}},methods:{__getCircle(t,{thickness:e,offset:i,color:s,cls:o}){return t("circle",{staticClass:"q-circular-progress__"+o,class:void 0!==s?`text-${s}`:null,style:this.circleStyle,attrs:{fill:"transparent",stroke:"currentColor","stroke-width":e,"stroke-dasharray":strokeDashArray,"stroke-dashoffset":i,cx:this.viewBox,cy:this.viewBox,r:50}})}},render(t){const e=[];void 0!==this.centerColor&&"transparent"!==this.centerColor&&e.push(t("circle",{staticClass:"q-circular-progress__center",class:`text-${this.centerColor}`,attrs:{fill:"currentColor",r:50-this.strokeWidth/2,cx:this.viewBox,cy:this.viewBox}})),void 0!==this.trackColor&&"transparent"!==this.trackColor&&e.push(this.__getCircle(t,{cls:"track",thickness:this.strokeWidth,offset:0,color:this.trackColor})),e.push(this.__getCircle(t,{cls:"circle",thickness:this.strokeWidth,offset:this.strokeDashOffset,color:this.color}));const i=[t("svg",{staticClass:"q-circular-progress__svg",style:this.svgStyle,attrs:{focusable:"false",viewBox:this.viewBoxAttr}},e)];return!0===this.showValue&&i.push(t("div",{staticClass:"q-circular-progress__text absolute-full row flex-center content-center",style:{fontSize:this.fontSize}},void 0!==this.$scopedSlots.default?this.$scopedSlots.default():[t("div",[this.normalizedValue])])),t("div",{staticClass:"q-circular-progress",class:`q-circular-progress--${!0===this.indeterminate?"in":""}determinate`,style:this.sizeStyle,on:{...this.qListeners},attrs:this.attrs},mergeSlotSafely(i,this,"internal"))}});const hex=/^#[0-9a-fA-F]{3}([0-9a-fA-F]{3})?$/,hexa=/^#[0-9a-fA-F]{4}([0-9a-fA-F]{4})?$/,hexOrHexa=/^#([0-9a-fA-F]{3}|[0-9a-fA-F]{4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/,rgb=/^rgb\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5])\)$/,rgba=/^rgba\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/,testPattern={date:t=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(t),time:t=>/^([0-1]?\d|2[0-3]):[0-5]\d$/.test(t),fulltime:t=>/^([0-1]?\d|2[0-3]):[0-5]\d:[0-5]\d$/.test(t),timeOrFulltime:t=>/^([0-1]?\d|2[0-3]):[0-5]\d(:[0-5]\d)?$/.test(t),hexColor:t=>hex.test(t),hexaColor:t=>hexa.test(t),hexOrHexaColor:t=>hexOrHexa.test(t),rgbColor:t=>rgb.test(t),rgbaColor:t=>rgba.test(t),rgbOrRgbaColor:t=>rgb.test(t)||rgba.test(t),hexOrRgbColor:t=>hex.test(t)||rgb.test(t),hexaOrRgbaColor:t=>hexa.test(t)||rgba.test(t),anyColor:t=>hexOrHexa.test(t)||rgb.test(t)||rgba.test(t)};var patterns={testPattern:testPattern};function getChanges(t,e,i){const s=position(t);let o,n=s.left-e.event.x,r=s.top-e.event.y,a=Math.abs(n),l=Math.abs(r);const h=e.direction;!0===h.horizontal&&!0!==h.vertical?o=n<0?"left":"right":!0!==h.horizontal&&!0===h.vertical?o=r<0?"up":"down":!0===h.up&&r<0?(o="up",a>l&&(!0===h.left&&n<0?o="left":!0===h.right&&n>0&&(o="right"))):!0===h.down&&r>0?(o="down",a>l&&(!0===h.left&&n<0?o="left":!0===h.right&&n>0&&(o="right"))):!0===h.left&&n<0?(o="left",a<l&&(!0===h.up&&r<0?o="up":!0===h.down&&r>0&&(o="down"))):!0===h.right&&n>0&&(o="right",a<l&&(!0===h.up&&r<0?o="up":!0===h.down&&r>0&&(o="down")));let d=!1;if(void 0===o&&!1===i){if(!0===e.event.isFirst||void 0===e.event.lastDir)return{};d=!0,"left"===(o=e.event.lastDir)||"right"===o?(s.left-=n,a=0,n=0):(s.top-=r,l=0,r=0)}return{synthetic:d,payload:{evt:t,touch:!0!==e.event.mouse,mouse:!0===e.event.mouse,position:s,direction:o,isFirst:e.event.isFirst,isFinal:!0===i,duration:Date.now()-e.event.time,distance:{x:a,y:l},offset:{x:n,y:r},delta:{x:s.left-e.event.lastX,y:s.top-e.event.lastY}}}}let uid=0;var TouchPan={name:"touch-pan",bind(t,{value:e,modifiers:i}){if(!0!==i.mouse&&!0!==client.has.touch)return;function s(t,e){!0===i.mouse&&!0===e?stopAndPrevent(t):(!0===i.stop&&stop(t),!0===i.prevent&&prevent(t))}const o={uid:"qvtp_"+uid++,handler:e,modifiers:i,direction:getModifierDirections(i),noop:noop,mouseStart(t){shouldStart(t,o)&&leftClick(t)&&(addEvt(o,"temp",[[document,"mousemove","move","notPassiveCapture"],[document,"mouseup","end","passiveCapture"]]),o.start(t,!0))},touchStart(t){if(shouldStart(t,o)){const e=getTouchTarget(t.target);addEvt(o,"temp",[[e,"touchmove","move","notPassiveCapture"],[e,"touchcancel","end","passiveCapture"],[e,"touchend","end","passiveCapture"]]),o.start(t)}},start(e,s){!0===client.is.firefox&&preventDraggable(t,!0),o.lastEvt=e;const n=position(e);if(!0===s||!0===i.stop){if(!0!==o.direction.all&&(!0!==s||!0!==o.direction.mouseAllDir)){const t=e.type.indexOf("mouse")>-1?new MouseEvent(e.type,e):new TouchEvent(e.type,e);!0===e.defaultPrevented&&prevent(t),!0===e.cancelBubble&&stop(t),t.qClonedBy=void 0===e.qClonedBy?[o.uid]:e.qClonedBy.concat(o.uid),t.qKeyEvent=e.qKeyEvent,t.qClickOutside=e.qClickOutside,o.initialEvent={target:e.target,event:t}}stop(e)}o.event={x:n.left,y:n.top,time:Date.now(),mouse:!0===s,detected:!1,isFirst:!0,isFinal:!1,lastX:n.left,lastY:n.top}},move(t){if(void 0===o.event)return;o.lastEvt=t;const e=!0===o.event.mouse,i=()=>{s(t,e),document.documentElement.style.cursor="grabbing",!0===e&&document.body.classList.add("no-pointer-events--children"),document.body.classList.add("non-selectable"),clearSelection(),o.styleCleanup=(t=>{if(o.styleCleanup=void 0,document.documentElement.style.cursor="",document.body.classList.remove("non-selectable"),!0===e){const e=()=>{document.body.classList.remove("no-pointer-events--children")};void 0!==t?setTimeout(()=>{e(),t()},50):e()}else void 0!==t&&t()})};if(!0===o.event.detected){!0!==o.event.isFirst&&s(t,o.event.mouse);const{payload:e,synthetic:n}=getChanges(t,o,!1);return void(void 0!==e&&(!1===o.handler(e)?o.end(t):(void 0===o.styleCleanup&&!0===o.event.isFirst&&i(),o.event.lastX=e.position.left,o.event.lastY=e.position.top,o.event.lastDir=!0===n?void 0:e.direction,o.event.isFirst=!1)))}if(!0===o.direction.all||!0===e&&!0===o.modifiers.mouseAllDir)return i(),o.event.detected=!0,void o.move(t);const n=position(t),r=n.left-o.event.x,a=n.top-o.event.y,l=Math.abs(r),h=Math.abs(a);l!==h&&(!0===o.direction.horizontal&&l>h||!0===o.direction.vertical&&l<h||!0===o.direction.up&&l<h&&a<0||!0===o.direction.down&&l<h&&a>0||!0===o.direction.left&&l>h&&r<0||!0===o.direction.right&&l>h&&r>0?(o.event.detected=!0,o.move(t)):o.end(t,!0))},end(e,i){if(void 0!==o.event){if(cleanEvt(o,"temp"),!0===client.is.firefox&&preventDraggable(t,!1),!0===i)void 0!==o.styleCleanup&&o.styleCleanup(),!0!==o.event.detected&&void 0!==o.initialEvent&&o.initialEvent.target.dispatchEvent(o.initialEvent.event);else if(!0===o.event.detected){!0===o.event.isFirst&&o.handler(getChanges(void 0===e?o.lastEvt:e,o).payload);const{payload:t}=getChanges(void 0===e?o.lastEvt:e,o,!0),i=()=>{o.handler(t)};void 0!==o.styleCleanup?o.styleCleanup(i):i()}o.event=void 0,o.initialEvent=void 0,o.lastEvt=void 0}}};t.__qtouchpan&&(t.__qtouchpan_old=t.__qtouchpan),t.__qtouchpan=o,!0===i.mouse&&addEvt(o,"main",[[t,"mousedown","mouseStart",`passive${!0===i.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(o,"main",[[t,"touchstart","touchStart",`passive${!0===i.capture?"Capture":""}`],[t,"touchmove","noop","notPassiveCapture"]])},update(t,e){void 0!==t.__qtouchpan&&updateModifiers(t.__qtouchpan,e)},unbind(t){const e=t.__qtouchpan_old||t.__qtouchpan;void 0!==e&&(void 0!==e.event&&e.end(),cleanEvt(e,"main"),cleanEvt(e,"temp"),!0===client.is.firefox&&preventDraggable(t,!1),void 0!==e.styleCleanup&&e.styleCleanup(),delete t[t.__qtouchpan_old?"__qtouchpan_old":"__qtouchpan"])}};const keyCodes=[34,37,40,33,39,38];function getRatio(t,e,i,s){const o=position(t),n=between(!0===s?(o.top-e.top)/e.height:(o.left-e.left)/e.width,0,1);return!0===i?1-n:n}function getModel(t,e,i,s,o){let n=e+t*(i-e);if(s>0){const t=(n-e)%s;n+=(Math.abs(t)>=s/2?(t<0?-1:1)*s:0)-t}return o>0&&(n=parseFloat(n.toFixed(o))),between(n,e,i)}const SliderMixin={mixins:[DarkMixin,FormMixin],directives:{TouchPan:TouchPan},props:{min:{type:Number,default:0},max:{type:Number,default:100},step:{type:Number,default:1,validator:t=>t>=0},color:String,labelColor:String,labelTextColor:String,dense:Boolean,label:Boolean,labelAlways:Boolean,markers:Boolean,snap:Boolean,vertical:Boolean,reverse:Boolean,disable:Boolean,readonly:Boolean,tabindex:[String,Number],thumbPath:{type:String,default:"M 4, 10 a 6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0"}},data:()=>({active:!1,preventFocus:!1,focus:!1}),computed:{axis(){return!0===this.vertical?"--v":"--h"},classes(){return`q-slider q-slider${this.axis} q-slider--${!0===this.active?"":"in"}active`+(!0===this.isReversed?" q-slider--reversed":"")+(void 0!==this.color?` text-${this.color}`:"")+(!0===this.disable?" disabled":"")+(!0===this.editable?" q-slider--editable":"")+("both"===this.focus?" q-slider--focus":"")+(this.label||!0===this.labelAlways?" q-slider--label":"")+(!0===this.labelAlways?" q-slider--label-always":"")+(!0===this.isDark?" q-slider--dark":"")+(!0===this.dense?" q-slider--dense q-slider--dense"+this.axis:"")},editable(){return!0!==this.disable&&!0!==this.readonly},decimals(){return(String(this.step).trim("0").split(".")[1]||"").length},computedStep(){return 0===this.step?1:this.step},markerStyle(){return{backgroundSize:!0===this.vertical?"2px "+100*this.computedStep/(this.max-this.min)+"%":100*this.computedStep/(this.max-this.min)+"% 2px"}},computedTabindex(){return!0===this.editable?this.tabindex||0:-1},isReversed(){return!0===this.vertical?!0===this.reverse:this.reverse!==(!0===this.$q.lang.rtl)},positionProp(){return!0===this.vertical?!0===this.isReversed?"bottom":"top":!0===this.isReversed?"right":"left"},sizeProp(){return!0===this.vertical?"height":"width"},orientation(){return!0===this.vertical?"vertical":"horizontal"},attrs(){const t={role:"slider","aria-valuemin":this.min,"aria-valuemax":this.max,"aria-orientation":this.orientation,"data-step":this.step};return!0===this.disable?t["aria-disabled"]="":!0===this.readonly&&(t["aria-readonly"]=""),t},panDirectives(){return!0===this.editable?[{name:"touch-pan",value:this.__pan,modifiers:{[this.orientation]:!0,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}}]:null}},methods:{__getThumbSvg(t){return t("svg",{staticClass:"q-slider__thumb absolute",attrs:{focusable:"false",viewBox:"0 0 20 20",width:"20",height:"20"}},[t("path",{attrs:{d:this.thumbPath}})])},__getPinStyle(t,e){if(!0===this.vertical)return{};const i=`${Math.ceil(20*Math.abs(.5-e))}px`;return{pin:{transformOrigin:`${!0===this.$q.lang.rtl?i:!0===this.$q.platform.is.ie?"100%":`calc(100% - ${i})`} 50%`},pinTextContainer:{[!0===this.$q.lang.rtl?"left":"right"]:`${100*t}%`,transform:`translateX(${Math.ceil(20*(!0===this.$q.lang.rtl?-1:1)*t)}px)`}}},__pan(t){t.isFinal?(void 0!==this.dragging&&(this.__updatePosition(t.evt),!0===t.touch&&this.__updateValue(!0),this.dragging=void 0),this.active=!1):t.isFirst?(this.dragging=this.__getDragging(t.evt),this.__updatePosition(t.evt),this.__updateValue(),this.active=!0):(this.__updatePosition(t.evt),this.__updateValue())},__blur(){this.focus=!1},__activate(t){this.__updatePosition(t,this.__getDragging(t)),this.__updateValue(),this.preventFocus=!0,this.active=!0,document.addEventListener("mouseup",this.__deactivate,!0)},__deactivate(){this.preventFocus=!1,void 0===this.dragging&&(this.active=!1),this.__updateValue(!0),this.__blur(),document.removeEventListener("mouseup",this.__deactivate,!0)},__mobileClick(t){this.__updatePosition(t,this.__getDragging(t)),this.__updateValue(!0)},__keyup(t){keyCodes.includes(t.keyCode)&&this.__updateValue(!0)}},beforeDestroy(){document.removeEventListener("mouseup",this.__deactivate,!0)}};var QSlider=Vue.extend({name:"QSlider",mixins:[SliderMixin],props:{value:{required:!0,default:null,validator:t=>"number"==typeof t||null===t},labelValue:[String,Number]},data(){return{model:null===this.value?this.min:this.value,curRatio:0}},watch:{value(t){this.model=null===t?0:between(t,this.min,this.max)},min(t){this.model=between(this.model,t,this.max)},max(t){this.model=between(this.model,this.min,t)}},computed:{ratio(){return!0===this.active?this.curRatio:this.modelRatio},modelRatio(){return(this.model-this.min)/(this.max-this.min)},trackStyle(){return{[this.positionProp]:0,[this.sizeProp]:`${100*this.ratio}%`}},thumbStyle(){return{[this.positionProp]:`${100*this.ratio}%`}},thumbClass(){if(!1===this.preventFocus&&!0===this.focus)return"q-slider--focus"},pinClass(){if(void 0!==this.labelColor)return`text-${this.labelColor}`},pinTextClass(){return"q-slider__pin-value-marker-text"+(void 0!==this.labelTextColor?` text-${this.labelTextColor}`:"")},events(){if(!0===this.editable)return!0===this.$q.platform.is.mobile?{click:this.__mobileClick}:{mousedown:this.__activate,focus:this.__focus,blur:this.__blur,keydown:this.__keydown,keyup:this.__keyup}},computedLabel(){return void 0!==this.labelValue?this.labelValue:this.model},pinStyle(){const t=!0===this.reverse?-this.ratio:this.ratio-1;return this.__getPinStyle(t,this.ratio)}},methods:{__updateValue(t){this.model!==this.value&&this.$emit("input",this.model),!0===t&&this.$emit("change",this.model)},__getDragging(){return this.$el.getBoundingClientRect()},__updatePosition(t,e=this.dragging){const i=getRatio(t,e,this.isReversed,this.vertical);this.model=getModel(i,this.min,this.max,this.step,this.decimals),this.curRatio=!0!==this.snap||0===this.step?i:(this.model-this.min)/(this.max-this.min)},__focus(){this.focus=!0},__keydown(t){if(!keyCodes.includes(t.keyCode))return;stopAndPrevent(t);const e=([34,33].includes(t.keyCode)?10:1)*this.computedStep,i=[34,37,40].includes(t.keyCode)?-e:e;this.model=between(parseFloat((this.model+i).toFixed(this.decimals)),this.min,this.max),this.__updateValue()}},render(t){const e=[this.__getThumbSvg(t),t("div",{staticClass:"q-slider__focus-ring"})];!0!==this.label&&!0!==this.labelAlways||e.push(t("div",{staticClass:`q-slider__pin q-slider__pin${this.axis} absolute`,style:this.pinStyle.pin,class:this.pinClass},[t("div",{staticClass:`q-slider__pin-text-container q-slider__pin-text-container${this.axis}`,style:this.pinStyle.pinTextContainer},[t("span",{staticClass:"q-slider__pin-text",class:this.pinTextClass},[this.computedLabel])])]),t("div",{staticClass:`q-slider__arrow q-slider__arrow${this.axis}`,class:this.pinClass})),void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(e,"push");const i=[t("div",{staticClass:`q-slider__track q-slider__track${this.axis} absolute`,style:this.trackStyle})];return!0===this.markers&&i.push(t("div",{staticClass:`q-slider__track-markers q-slider__track-markers${this.axis} absolute-full fit`,style:this.markerStyle})),t("div",{staticClass:null===this.value?" q-slider--no-value":"",attrs:{...this.attrs,"aria-valuenow":this.value,tabindex:this.computedTabindex},class:this.classes,on:this.events,directives:this.panDirectives},[t("div",{staticClass:`q-slider__track-container q-slider__track-container${this.axis} absolute`},i),t("div",{staticClass:`q-slider__thumb-container q-slider__thumb-container${this.axis} absolute non-selectable`,class:this.thumbClass,style:this.thumbStyle},e)])}}),CanRenderMixin={data:()=>({canRender:!onSSR}),mounted(){!1===this.canRender&&(this.canRender=!0)}},QResizeObserver=Vue.extend({name:"QResizeObserver",mixins:[CanRenderMixin],props:{debounce:{type:[String,Number],default:100}},data(){return!0===this.hasObserver?{}:{url:!0===this.$q.platform.is.ie?null:"about:blank"}},methods:{trigger(t){!0===t||0===this.debounce||"0"===this.debounce?this.__onResize():this.timer||(this.timer=setTimeout(this.__onResize,this.debounce))},__onResize(){if(this.timer=null,!this.$el||!this.$el.parentNode)return;const t=this.$el.parentNode,e={width:t.offsetWidth,height:t.offsetHeight};e.width===this.size.width&&e.height===this.size.height||(this.size=e,this.$emit("resize",this.size))},__cleanup(){void 0!==this.curDocView&&(void 0!==this.curDocView.removeEventListener&&this.curDocView.removeEventListener("resize",this.trigger,listenOpts.passive),this.curDocView=void 0)},__onObjLoad(){this.__cleanup(),this.$el.contentDocument&&(this.curDocView=this.$el.contentDocument.defaultView,this.curDocView.addEventListener("resize",this.trigger,listenOpts.passive)),this.__onResize()}},render(t){if(!1!==this.canRender&&!0!==this.hasObserver)return t("object",{style:this.style,attrs:{tabindex:-1,type:"text/html",data:this.url,"aria-hidden":"true"},on:cache(this,"load",{load:this.__onObjLoad})})},beforeCreate(){this.size={width:-1,height:-1},!0!==isSSR&&(this.hasObserver="undefined"!=typeof ResizeObserver,!0!==this.hasObserver&&(this.style=`${this.$q.platform.is.ie?"visibility:hidden;":""}display:block;position:absolute;top:0;left:0;right:0;bottom:0;height:100%;width:100%;overflow:hidden;pointer-events:none;z-index:-1;`))},mounted(){if(!0===this.hasObserver)return this.observer=new ResizeObserver(this.trigger),this.observer.observe(this.$el.parentNode),void this.__onResize();!0===this.$q.platform.is.ie?(this.url="about:blank",this.__onResize()):this.__onObjLoad()},beforeDestroy(){clearTimeout(this.timer),!0!==this.hasObserver?this.__cleanup():void 0!==this.observer&&this.$el.parentNode&&this.observer.unobserve(this.$el.parentNode)}});function getIndicatorClass(t,e,i){const s=!0===i?["left","right"]:["top","bottom"];return`absolute-${!0===e?s[0]:s[1]}${t?` text-${t}`:""}`}function bufferPrioritySort(t,e){return t.priorityMatched===e.priorityMatched?e.priorityHref-t.priorityHref:e.priorityMatched-t.priorityMatched}function bufferCleanSelected(t){return t.selected=!1,t}const bufferFilters=[t=>!0===t.selected&&!0===t.exact&&!0!==t.redirected,t=>!0===t.selected&&!0===t.exact,t=>!0===t.selected&&!0!==t.redirected,t=>!0===t.selected,t=>!0===t.exact&&!0!==t.redirected,t=>!0!==t.redirected,t=>!0===t.exact,t=>!0],bufferFiltersLen=bufferFilters.length;var QTabs=Vue.extend({name:"QTabs",mixins:[TimeoutMixin,ListenersMixin],provide(){return{tabs:this.tabs,__recalculateScroll:this.__recalculateScroll,__activateTab:this.__activateTab,__activateRoute:this.__activateRoute}},props:{value:[Number,String],align:{type:String,default:"center",validator:t=>["left","center","right","justify"].includes(t)},breakpoint:{type:[String,Number],default:600},vertical:Boolean,shrink:Boolean,stretch:Boolean,activeColor:String,activeBgColor:String,indicatorColor:String,leftIcon:String,rightIcon:String,outsideArrows:Boolean,mobileArrows:Boolean,switchIndicator:Boolean,narrowIndicator:Boolean,inlineLabel:Boolean,noCaps:Boolean,dense:Boolean,contentClass:String},data(){return{tabs:{current:this.value,activeColor:this.activeColor,activeBgColor:this.activeBgColor,indicatorClass:getIndicatorClass(this.indicatorColor,this.switchIndicator,this.vertical),narrowIndicator:this.narrowIndicator,inlineLabel:this.inlineLabel,noCaps:this.noCaps},scrollable:!1,leftArrow:!0,rightArrow:!1,justify:!1}},watch:{value(t){this.__activateTab(t,!0,!0)},activeColor(t){this.tabs.activeColor=t},activeBgColor(t){this.tabs.activeBgColor=t},vertical(t){this.tabs.indicatorClass=getIndicatorClass(this.indicatorColor,this.switchIndicator,t)},indicatorColor(t){this.tabs.indicatorClass=getIndicatorClass(t,this.switchIndicator,this.vertical)},switchIndicator(t){this.tabs.indicatorClass=getIndicatorClass(this.indicatorColor,t,this.vertical)},narrowIndicator(t){this.tabs.narrowIndicator=t},inlineLabel(t){this.tabs.inlineLabel=t},noCaps(t){this.tabs.noCaps=t},outsideArrows(){this.$nextTick(this.__recalculateScroll())},arrowsEnabled(t){this.__updateArrows=!0===t?this.__updateArrowsFn:noop,this.$nextTick(this.__recalculateScroll())}},computed:{arrowsEnabled(){return!0===this.mobileArrows||!0===this.$q.platform.is.desktop},alignClass(){return`q-tabs__content--align-${!0===this.scrollable?"left":!0===this.justify?"justify":this.align}`},classes(){return`q-tabs--${!0===this.scrollable?"":"not-"}scrollable`+` q-tabs--${!0===this.vertical?"vertical":"horizontal"}`+` q-tabs__arrows--${!0===this.arrowsEnabled&&!0===this.outsideArrows?"outside":"inside"}`+(!0===this.dense?" q-tabs--dense":"")+(!0===this.shrink?" col-shrink":"")+(!0===this.stretch?" self-stretch":"")},innerClass(){return this.alignClass+(void 0!==this.contentClass?` ${this.contentClass}`:"")},domProps(){return!0===this.vertical?{container:"height",content:"scrollHeight",posLeft:"top",posRight:"bottom"}:{container:"width",content:"scrollWidth",posLeft:"left",posRight:"right"}},onEvents(){return{input:stop,...this.qListeners}}},methods:{__activateTab(t,e,i){this.tabs.current!==t&&(!0!==i&&this.$emit("input",t),!0!==e&&void 0!==this.qListeners.input||(this.__animate(this.tabs.current,t),this.tabs.current=t))},__activateRoute(t){this.bufferRoute!==this.$route&&this.buffer.length>0&&(clearTimeout(this.bufferTimer),this.bufferTimer=void 0,this.buffer.length=0),this.bufferRoute=this.$route,void 0!==t&&(!0===t.remove?this.buffer=this.buffer.filter(e=>e.name!==t.name):this.buffer.push(t)),void 0===this.bufferTimer&&(this.bufferTimer=setTimeout(()=>{let t=[];for(let e=0;e<bufferFiltersLen&&0===t.length;e++)t=this.buffer.filter(bufferFilters[e]);t.sort(bufferPrioritySort),this.__activateTab(0===t.length?null:t[0].name,!0),this.buffer=this.buffer.map(bufferCleanSelected),this.bufferTimer=void 0},1))},__recalculateScroll(){this.__nextTick(()=>{!0!==this._isDestroyed&&this.__updateContainer({width:this.$el.offsetWidth,height:this.$el.offsetHeight})}),this.__prepareTick()},__updateContainer(t){const e=t[this.domProps.container],i=this.$refs.content[this.domProps.content],s=e>0&&i>e;this.scrollable!==s&&(this.scrollable=s),!0===s&&this.$nextTick(()=>this.__updateArrows());const o=e<parseInt(this.breakpoint,10);this.justify!==o&&(this.justify=o)},__animate(t,e){const i=void 0!==t&&null!==t&&""!==t?this.$children.find(e=>e.name===t):null,s=void 0!==e&&null!==e&&""!==e?this.$children.find(t=>t.name===e):null;if(i&&s){const t=i.$el.getElementsByClassName("q-tab__indicator")[0],e=s.$el.getElementsByClassName("q-tab__indicator")[0];clearTimeout(this.animateTimer),t.style.transition="none",t.style.transform="none",e.style.transition="none",e.style.transform="none";const o=t.getBoundingClientRect(),n=e.getBoundingClientRect();e.style.transform=!0===this.vertical?`translate3d(0,${o.top-n.top}px,0) scale3d(1,${n.height?o.height/n.height:1},1)`:`translate3d(${o.left-n.left}px,0,0) scale3d(${n.width?o.width/n.width:1},1,1)`,this.$nextTick(()=>{this.animateTimer=setTimeout(()=>{e.style.transition="transform .25s cubic-bezier(.4, 0, .2, 1)",e.style.transform="none"},30)})}if(s&&!0===this.scrollable){const{left:t,width:e,top:i,height:o}=this.$refs.content.getBoundingClientRect(),n=s.$el.getBoundingClientRect();let r=!0===this.vertical?n.top-i:n.left-t;if(r<0)return this.$refs.content[!0===this.vertical?"scrollTop":"scrollLeft"]+=Math.floor(r),void this.__updateArrows();(r+=!0===this.vertical?n.height-o:n.width-e)>0&&(this.$refs.content[!0===this.vertical?"scrollTop":"scrollLeft"]+=Math.ceil(r),this.__updateArrows())}},__updateArrowsFn(){const t=this.$refs.content,e=t.getBoundingClientRect(),i=!0===this.vertical?t.scrollTop:t.scrollLeft;this.leftArrow=i>0,this.rightArrow=!0===this.vertical?Math.ceil(i+e.height)<t.scrollHeight:Math.ceil(i+e.width)<t.scrollWidth},__animScrollTo(t){this.__stopAnimScroll(),this.__scrollTowards(t),this.scrollTimer=setInterval(()=>{this.__scrollTowards(t)&&this.__stopAnimScroll()},5)},__scrollToStart(){this.__animScrollTo(0)},__scrollToEnd(){this.__animScrollTo(9999)},__stopAnimScroll(){clearInterval(this.scrollTimer)},__scrollTowards(t){const e=this.$refs.content;let i=!0===this.vertical?e.scrollTop:e.scrollLeft,s=!1;const o=t<i?-1:1;return(i+=5*o)<0?(s=!0,i=0):(-1===o&&i<=t||1===o&&i>=t)&&(s=!0,i=t),e[!0===this.vertical?"scrollTop":"scrollLeft"]=i,this.__updateArrows(),s}},created(){this.buffer=[],this.__updateArrows=!0===this.arrowsEnabled?this.__updateArrowsFn:noop},beforeDestroy(){clearTimeout(this.bufferTimer),clearTimeout(this.animateTimer)},render(t){const e=[t(QResizeObserver,{on:cache(this,"resize",{resize:this.__updateContainer})}),t("div",{ref:"content",staticClass:"q-tabs__content row no-wrap items-center self-stretch hide-scrollbar",class:this.innerClass},slot(this,"default"))];return!0===this.arrowsEnabled&&e.push(t(QIcon,{staticClass:"q-tabs__arrow q-tabs__arrow--left absolute q-tab__icon",class:!0===this.leftArrow?"":"q-tabs__arrow--faded",props:{name:this.leftIcon||(!0===this.vertical?this.$q.iconSet.tabs.up:this.$q.iconSet.tabs.left)},on:cache(this,"onL",{mousedown:this.__scrollToStart,touchstart:this.__scrollToStart,mouseup:this.__stopAnimScroll,mouseleave:this.__stopAnimScroll,touchend:this.__stopAnimScroll})}),t(QIcon,{staticClass:"q-tabs__arrow q-tabs__arrow--right absolute q-tab__icon",class:!0===this.rightArrow?"":"q-tabs__arrow--faded",props:{name:this.rightIcon||(!0===this.vertical?this.$q.iconSet.tabs.down:this.$q.iconSet.tabs.right)},on:cache(this,"onR",{mousedown:this.__scrollToEnd,touchstart:this.__scrollToEnd,mouseup:this.__stopAnimScroll,mouseleave:this.__stopAnimScroll,touchend:this.__stopAnimScroll})})),t("div",{staticClass:"q-tabs row no-wrap items-center",class:this.classes,on:this.onEvents,attrs:{role:"tablist"}},e)}});let uid$1=0;var QTab=Vue.extend({name:"QTab",mixins:[RippleMixin,ListenersMixin],inject:{tabs:{default(){console.error("QTab/QRouteTab components need to be child of QTabs")}},__activateTab:{},__recalculateScroll:{}},props:{icon:String,label:[Number,String],alert:[Boolean,String],alertIcon:String,name:{type:[Number,String],default:()=>`t_${uid$1++}`},noCaps:Boolean,tabindex:[String,Number],disable:Boolean,contentClass:String},computed:{isActive(){return this.tabs.current===this.name},classes(){return{[`q-tab--${this.isActive?"":"in"}active`]:!0,[`text-${this.tabs.activeColor}`]:this.isActive&&this.tabs.activeColor,[`bg-${this.tabs.activeBgColor}`]:this.isActive&&this.tabs.activeBgColor,"q-tab--full":this.icon&&this.label&&!this.tabs.inlineLabel,"q-tab--no-caps":!0===this.noCaps||!0===this.tabs.noCaps,"q-focusable q-hoverable cursor-pointer":!this.disable,disabled:this.disable}},innerClass(){return(!0===this.tabs.inlineLabel?"row no-wrap q-tab__content--inline":"column")+(void 0!==this.contentClass?` ${this.contentClass}`:"")},computedTabIndex(){return!0===this.disable||!0===this.isActive?-1:this.tabindex||0},onEvents(){return{input:stop,...this.qListeners,click:this.__activate,keyup:this.__onKeyup}},attrs(){const t={tabindex:this.computedTabIndex,role:"tab","aria-selected":this.isActive};return!0===this.disable&&(t["aria-disabled"]=""),t}},methods:{__activate(t,e){!0!==e&&void 0!==this.$refs.blurTarget&&this.$refs.blurTarget.focus(),!0!==this.disable&&(void 0!==this.qListeners.click&&this.$emit("click",t),this.__activateTab(this.name))},__onKeyup(t){!0===isKeyCode(t,13)&&this.__activate(t,!0)},__getContent(t){const e=this.tabs.narrowIndicator,i=[],s=t("div",{staticClass:"q-tab__indicator",class:this.tabs.indicatorClass});void 0!==this.icon&&i.push(t(QIcon,{staticClass:"q-tab__icon",props:{name:this.icon}})),void 0!==this.label&&i.push(t("div",{staticClass:"q-tab__label"},[this.label])),!1!==this.alert&&i.push(void 0!==this.alertIcon?t(QIcon,{staticClass:"q-tab__alert-icon",props:{color:!0!==this.alert?this.alert:void 0,name:this.alertIcon}}):t("div",{staticClass:"q-tab__alert",class:!0!==this.alert?`text-${this.alert}`:null})),!0===e&&i.push(s);const o=[t("div",{staticClass:"q-focus-helper",attrs:{tabindex:-1},ref:"blurTarget"}),t("div",{staticClass:"q-tab__content self-stretch flex-center relative-position q-anchor--skip non-selectable",class:this.innerClass},mergeSlot(i,this,"default"))];return!1===e&&o.push(s),o},__renderTab(t,e,i){const s={staticClass:"q-tab relative-position self-stretch flex flex-center text-center",class:this.classes,attrs:this.attrs,directives:!1!==this.ripple&&!0===this.disable?null:[{name:"ripple",value:this.ripple}],["div"===e?"on":"nativeOn"]:this.onEvents};return void 0!==i&&(s.props=i),t(e,s,this.__getContent(t))}},mounted(){this.__recalculateScroll()},beforeDestroy(){this.__recalculateScroll()},render(t){return this.__renderTab(t,"div")}}),QTabPanels=Vue.extend({name:"QTabPanels",mixins:[DarkMixin,PanelParentMixin],computed:{classes(){return"q-tab-panels q-panel-parent"+(!0===this.isDark?" q-tab-panels--dark q-dark":"")}},methods:{__renderPanels(t){return t("div",{class:this.classes,directives:this.panelDirectives,on:{...this.qListeners}},this.__getPanelContent(t))}}}),QTabPanel=Vue.extend({name:"QTabPanel",mixins:[PanelChildMixin],render(t){return t("div",{staticClass:"q-tab-panel",on:{...this.qListeners}},slot(this,"default"))}});const palette=["rgb(255,204,204)","rgb(255,230,204)","rgb(255,255,204)","rgb(204,255,204)","rgb(204,255,230)","rgb(204,255,255)","rgb(204,230,255)","rgb(204,204,255)","rgb(230,204,255)","rgb(255,204,255)","rgb(255,153,153)","rgb(255,204,153)","rgb(255,255,153)","rgb(153,255,153)","rgb(153,255,204)","rgb(153,255,255)","rgb(153,204,255)","rgb(153,153,255)","rgb(204,153,255)","rgb(255,153,255)","rgb(255,102,102)","rgb(255,179,102)","rgb(255,255,102)","rgb(102,255,102)","rgb(102,255,179)","rgb(102,255,255)","rgb(102,179,255)","rgb(102,102,255)","rgb(179,102,255)","rgb(255,102,255)","rgb(255,51,51)","rgb(255,153,51)","rgb(255,255,51)","rgb(51,255,51)","rgb(51,255,153)","rgb(51,255,255)","rgb(51,153,255)","rgb(51,51,255)","rgb(153,51,255)","rgb(255,51,255)","rgb(255,0,0)","rgb(255,128,0)","rgb(255,255,0)","rgb(0,255,0)","rgb(0,255,128)","rgb(0,255,255)","rgb(0,128,255)","rgb(0,0,255)","rgb(128,0,255)","rgb(255,0,255)","rgb(245,0,0)","rgb(245,123,0)","rgb(245,245,0)","rgb(0,245,0)","rgb(0,245,123)","rgb(0,245,245)","rgb(0,123,245)","rgb(0,0,245)","rgb(123,0,245)","rgb(245,0,245)","rgb(214,0,0)","rgb(214,108,0)","rgb(214,214,0)","rgb(0,214,0)","rgb(0,214,108)","rgb(0,214,214)","rgb(0,108,214)","rgb(0,0,214)","rgb(108,0,214)","rgb(214,0,214)","rgb(163,0,0)","rgb(163,82,0)","rgb(163,163,0)","rgb(0,163,0)","rgb(0,163,82)","rgb(0,163,163)","rgb(0,82,163)","rgb(0,0,163)","rgb(82,0,163)","rgb(163,0,163)","rgb(92,0,0)","rgb(92,46,0)","rgb(92,92,0)","rgb(0,92,0)","rgb(0,92,46)","rgb(0,92,92)","rgb(0,46,92)","rgb(0,0,92)","rgb(46,0,92)","rgb(92,0,92)","rgb(255,255,255)","rgb(205,205,205)","rgb(178,178,178)","rgb(153,153,153)","rgb(127,127,127)","rgb(102,102,102)","rgb(76,76,76)","rgb(51,51,51)","rgb(25,25,25)","rgb(0,0,0)"];var QColor=Vue.extend({name:"QColor",mixins:[ListenersMixin,DarkMixin,FormMixin],directives:{TouchPan:TouchPan},props:{value:String,defaultValue:String,defaultView:{type:String,default:"spectrum",validator:t=>["spectrum","tune","palette"].includes(t)},formatModel:{type:String,default:"auto",validator:t=>["auto","hex","rgb","hexa","rgba"].includes(t)},palette:Array,noHeader:Boolean,noFooter:Boolean,square:Boolean,flat:Boolean,bordered:Boolean,disable:Boolean,readonly:Boolean},data(){return{topView:"auto"===this.formatModel?void 0===this.value||null===this.value||""===this.value||this.value.startsWith("#")?"hex":"rgb":this.formatModel.startsWith("hex")?"hex":"rgb",view:this.defaultView,model:this.__parseModel(this.value||this.defaultValue)}},watch:{value(t){const e=this.__parseModel(t||this.defaultValue);e.hex!==this.model.hex&&(this.model=e)},defaultValue(t){if(!this.value&&t){const e=this.__parseModel(t);e.hex!==this.model.hex&&(this.model=e)}}},computed:{editable(){return!0!==this.disable&&!0!==this.readonly},forceHex(){return"auto"===this.formatModel?null:this.formatModel.indexOf("hex")>-1},forceAlpha(){return"auto"===this.formatModel?null:this.formatModel.indexOf("a")>-1},isHex(){return void 0===this.value||null===this.value||""===this.value||this.value.startsWith("#")},isOutputHex(){return null!==this.forceHex?this.forceHex:this.isHex},formAttrs(){return{type:"hidden",name:this.name,value:this.model[!0===this.isOutputHex?"hex":"rgb"]}},hasAlpha(){return null!==this.forceAlpha?this.forceAlpha:void 0!==this.model.a},currentBgColor(){return{backgroundColor:this.model.rgb||"#000"}},headerClass(){return`q-color-picker__header-content--${void 0!==this.model.a&&this.model.a<65||luminosity(this.model)>.4?"light":"dark"}`},spectrumStyle(){return{background:`hsl(${this.model.h},100%,50%)`}},spectrumPointerStyle(){return{top:`${100-this.model.v}%`,[!0===this.$q.lang.rtl?"right":"left"]:`${this.model.s}%`}},inputsArray(){const t=["r","g","b"];return!0===this.hasAlpha&&t.push("a"),t},computedPalette(){return void 0!==this.palette&&this.palette.length>0?this.palette:palette},classes(){return"q-color-picker"+(!0===this.bordered?" q-color-picker--bordered":"")+(!0===this.square?" q-color-picker--square no-border-radius":"")+(!0===this.flat?" q-color-picker--flat no-shadow":"")+(!0===this.disable?" disabled":"")+(!0===this.isDark?" q-color-picker--dark q-dark":"")},attrs(){return!0===this.disable?{"aria-disabled":""}:!0===this.readonly?{"aria-readonly":""}:void 0}},created(){this.__spectrumChange=throttle(this.__spectrumChange,20)},render(t){const e=[this.__getContent(t)];return void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(e,"push"),!0!==this.noHeader&&e.unshift(this.__getHeader(t)),!0!==this.noFooter&&e.push(this.__getFooter(t)),t("div",{class:this.classes,attrs:this.attrs,on:{...this.qListeners}},e)},methods:{__getHeader(t){return t("div",{staticClass:"q-color-picker__header relative-position overflow-hidden"},[t("div",{staticClass:"q-color-picker__header-bg absolute-full"}),t("div",{staticClass:"q-color-picker__header-content absolute-full",class:this.headerClass,style:this.currentBgColor},[t(QTabs,{props:{value:this.topView,dense:!0,align:"justify"},on:cache(this,"topVTab",{input:t=>{this.topView=t}})},[t(QTab,{props:{label:"HEX"+(!0===this.hasAlpha?"A":""),name:"hex",ripple:!1}}),t(QTab,{props:{label:"RGB"+(!0===this.hasAlpha?"A":""),name:"rgb",ripple:!1}})]),t("div",{staticClass:"q-color-picker__header-banner row flex-center no-wrap"},[t("input",{staticClass:"fit",domProps:{value:this.model[this.topView]},attrs:!0!==this.editable?{readonly:!0}:null,on:cache(this,"topIn",{input:t=>{this.__updateErrorIcon(!0===this.__onEditorChange(t))},change:stop,blur:t=>{!0===this.__onEditorChange(t,!0)&&this.$forceUpdate(),this.__updateErrorIcon(!1)}})}),t(QIcon,{ref:"errorIcon",staticClass:"q-color-picker__error-icon absolute no-pointer-events",props:{name:this.$q.iconSet.type.negative}})])])])},__getContent(t){return t(QTabPanels,{props:{value:this.view,animated:!0}},[t(QTabPanel,{staticClass:"q-color-picker__spectrum-tab overflow-hidden",props:{name:"spectrum"}},this.__getSpectrumTab(t)),t(QTabPanel,{staticClass:"q-pa-md q-color-picker__tune-tab",props:{name:"tune"}},this.__getTuneTab(t)),t(QTabPanel,{staticClass:"q-color-picker__palette-tab",props:{name:"palette"}},this.__getPaletteTab(t))])},__getFooter(t){return t("div",{staticClass:"q-color-picker__footer relative-position overflow-hidden"},[t(QTabs,{staticClass:"absolute-full",props:{value:this.view,dense:!0,align:"justify"},on:cache(this,"ftIn",{input:t=>{this.view=t}})},[t(QTab,{props:{icon:this.$q.iconSet.colorPicker.spectrum,name:"spectrum",ripple:!1}}),t(QTab,{props:{icon:this.$q.iconSet.colorPicker.tune,name:"tune",ripple:!1}}),t(QTab,{props:{icon:this.$q.iconSet.colorPicker.palette,name:"palette",ripple:!1}})])])},__getSpectrumTab(t){return[t("div",{ref:"spectrum",staticClass:"q-color-picker__spectrum non-selectable relative-position cursor-pointer",style:this.spectrumStyle,class:{readonly:!0!==this.editable},on:!0===this.editable?cache(this,"spectrT",{click:this.__spectrumClick,mousedown:this.__activate}):null,directives:!0===this.editable?cache(this,"spectrDir",[{name:"touch-pan",modifiers:{prevent:!0,stop:!0,mouse:!0},value:this.__spectrumPan}]):null},[t("div",{style:{paddingBottom:"100%"}}),t("div",{staticClass:"q-color-picker__spectrum-white absolute-full"}),t("div",{staticClass:"q-color-picker__spectrum-black absolute-full"}),t("div",{staticClass:"absolute",style:this.spectrumPointerStyle},[void 0!==this.model.hex?t("div",{staticClass:"q-color-picker__spectrum-circle"}):null])]),t("div",{staticClass:"q-color-picker__sliders"},[t("div",{staticClass:"q-color-picker__hue non-selectable"},[t(QSlider,{props:{value:this.model.h,min:0,max:360,fillHandleAlways:!0,readonly:!0!==this.editable,thumbPath:"M5 5 h10 v10 h-10 v-10 z"},on:cache(this,"hueSlide",{input:this.__onHueChange,change:t=>this.__onHueChange(t,!0)})})]),!0===this.hasAlpha?t("div",{staticClass:"q-color-picker__alpha non-selectable"},[t(QSlider,{props:{value:this.model.a,min:0,max:100,fillHandleAlways:!0,readonly:!0!==this.editable,thumbPath:"M5 5 h10 v10 h-10 v-10 z"},on:cache(this,"alphaSlide",{input:t=>this.__onNumericChange(t,"a",100),change:t=>this.__onNumericChange(t,"a",100,void 0,!0)})})]):null])]},__getTuneTab(t){return[t("div",{staticClass:"row items-center no-wrap"},[t("div",["R"]),t(QSlider,{props:{value:this.model.r,min:0,max:255,color:"red",dark:this.isDark,readonly:!0!==this.editable},on:cache(this,"rSlide",{input:t=>this.__onNumericChange(t,"r",255),change:t=>this.__onNumericChange(t,"r",255,void 0,!0)})}),t("input",{domProps:{value:this.model.r},attrs:{maxlength:3,readonly:!0!==this.editable},on:cache(this,"rIn",{input:t=>this.__onNumericChange(t.target.value,"r",255,t),change:stop,blur:t=>this.__onNumericChange(t.target.value,"r",255,t,!0)})})]),t("div",{staticClass:"row items-center no-wrap"},[t("div",["G"]),t(QSlider,{props:{value:this.model.g,min:0,max:255,color:"green",dark:this.isDark,readonly:!0!==this.editable},on:cache(this,"gSlide",{input:t=>this.__onNumericChange(t,"g",255),change:t=>this.__onNumericChange(t,"g",255,void 0,!0)})}),t("input",{domProps:{value:this.model.g},attrs:{maxlength:3,readonly:!0!==this.editable},on:cache(this,"gIn",{input:t=>this.__onNumericChange(t.target.value,"g",255,t),change:stop,blur:t=>this.__onNumericChange(t.target.value,"g",255,t,!0)})})]),t("div",{staticClass:"row items-center no-wrap"},[t("div",["B"]),t(QSlider,{props:{value:this.model.b,min:0,max:255,color:"blue",readonly:!0!==this.editable,dark:this.isDark},on:cache(this,"bSlide",{input:t=>this.__onNumericChange(t,"b",255),change:t=>this.__onNumericChange(t,"b",255,void 0,!0)})}),t("input",{domProps:{value:this.model.b},attrs:{maxlength:3,readonly:!0!==this.editable},on:cache(this,"bIn",{input:t=>this.__onNumericChange(t.target.value,"b",255,t),change:stop,blur:t=>this.__onNumericChange(t.target.value,"b",255,t,!0)})})]),!0===this.hasAlpha?t("div",{staticClass:"row items-center no-wrap"},[t("div",["A"]),t(QSlider,{props:{value:this.model.a,color:"grey",readonly:!0!==this.editable,dark:this.isDark},on:cache(this,"aSlide",{input:t=>this.__onNumericChange(t,"a",100),change:t=>this.__onNumericChange(t,"a",100,void 0,!0)})}),t("input",{domProps:{value:this.model.a},attrs:{maxlength:3,readonly:!0!==this.editable},on:cache(this,"aIn",{input:t=>this.__onNumericChange(t.target.value,"a",100,t),change:stop,blur:t=>this.__onNumericChange(t.target.value,"a",100,t,!0)})})]):null]},__getPaletteTab(t){return[t("div",{staticClass:"row items-center q-color-picker__palette-rows",class:!0===this.editable?"q-color-picker__palette-rows--editable":""},this.computedPalette.map(e=>t("div",{staticClass:"q-color-picker__cube col-auto",style:{backgroundColor:e},on:!0===this.editable?cache(this,"palette#"+e,{click:()=>{this.__onPalettePick(e)}}):null})))]},__onSpectrumChange(t,e,i){const s=this.$refs.spectrum;if(void 0===s)return;const o=s.clientWidth,n=s.clientHeight,r=s.getBoundingClientRect();let a=Math.min(o,Math.max(0,t-r.left));!0===this.$q.lang.rtl&&(a=o-a);const l=Math.min(n,Math.max(0,e-r.top)),h=Math.round(100*a/o),d=Math.round(100*Math.max(0,Math.min(1,-l/n+1))),c=hsvToRgb({h:this.model.h,s:h,v:d,a:!0===this.hasAlpha?this.model.a:void 0});this.model.s=h,this.model.v=d,this.__update(c,i)},__onHueChange(t,e){const i=hsvToRgb({h:t=Math.round(t),s:this.model.s,v:this.model.v,a:!0===this.hasAlpha?this.model.a:void 0});this.model.h=t,this.__update(i,e)},__onNumericChange(t,e,i,s,o){if(void 0!==s&&stop(s),!/^[0-9]+$/.test(t))return void(o&&this.$forceUpdate());const n=Math.floor(Number(t));if(n<0||n>i)return void(!0===o&&this.$forceUpdate());const r={r:"r"===e?n:this.model.r,g:"g"===e?n:this.model.g,b:"b"===e?n:this.model.b,a:!0===this.hasAlpha?"a"===e?n:this.model.a:void 0};if("a"!==e){const t=rgbToHsv(r);this.model.h=t.h,this.model.s=t.s,this.model.v=t.v}if(this.__update(r,o),void 0!==s&&!0!==o&&void 0!==s.target.selectionEnd){const t=s.target.selectionEnd;this.$nextTick(()=>{s.target.setSelectionRange(t,t)})}},__onEditorChange(t,e){let i;const s=t.target.value;if(stop(t),"hex"===this.topView){if(s.length!==(!0===this.hasAlpha?9:7)||!/^#[0-9A-Fa-f]+$/.test(s))return!0;i=hexToRgb(s)}else{let t;if(!s.endsWith(")"))return!0;if(!0!==this.hasAlpha&&s.startsWith("rgb(")){if(3!==(t=s.substring(4,s.length-1).split(",").map(t=>parseInt(t,10))).length||!/^rgb\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3}\)$/.test(s))return!0}else{if(!0!==this.hasAlpha||!s.startsWith("rgba("))return!0;{if(4!==(t=s.substring(5,s.length-1).split(",")).length||!/^rgba\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3},(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/.test(s))return!0;for(let e=0;e<3;e++){const i=parseInt(t[e],10);if(i<0||i>255)return!0;t[e]=i}const e=parseFloat(t[3]);if(e<0||e>1)return!0;t[3]=e}}if(t[0]<0||t[0]>255||t[1]<0||t[1]>255||t[2]<0||t[2]>255||!0===this.hasAlpha&&(t[3]<0||t[3]>1))return!0;i={r:t[0],g:t[1],b:t[2],a:!0===this.hasAlpha?100*t[3]:void 0}}const o=rgbToHsv(i);if(this.model.h=o.h,this.model.s=o.s,this.model.v=o.v,this.__update(i,e),!0!==e){const e=t.target.selectionEnd;this.$nextTick(()=>{t.target.setSelectionRange(e,e)})}},__onPalettePick(t){const e=this.__parseModel(t),i={r:e.r,g:e.g,b:e.b,a:e.a};void 0===i.a&&(i.a=this.model.a),this.model.h=e.h,this.model.s=e.s,this.model.v=e.v,this.__update(i,!0)},__update(t,e){this.model.hex=rgbToHex(t),this.model.rgb=rgbToString(t),this.model.r=t.r,this.model.g=t.g,this.model.b=t.b,this.model.a=t.a;const i=this.model[!0===this.isOutputHex?"hex":"rgb"];this.$emit("input",i),!0===e&&this.$emit("change",i)},__updateErrorIcon(t){void 0!==this.$refs.errorIcon&&(this.$refs.errorIcon.$el.style.opacity=t?1:0)},__parseModel(t){const e=void 0!==this.forceAlpha?this.forceAlpha:"auto"===this.formatModel?null:this.formatModel.indexOf("a")>-1;if("string"!=typeof t||0===t.length||!0!==testPattern.anyColor(t.replace(/ /g,"")))return{h:0,s:0,v:0,r:0,g:0,b:0,a:!0===e?100:void 0,hex:void 0,rgb:void 0};const i=textToRgb(t);return!0===e&&void 0===i.a&&(i.a=100),i.hex=rgbToHex(i),i.rgb=rgbToString(i),Object.assign(i,rgbToHsv(i))},__spectrumPan(t){t.isFinal?this.__onSpectrumChange(t.position.left,t.position.top,!0):this.__spectrumChange(t)},__spectrumChange(t){this.__onSpectrumChange(t.position.left,t.position.top)},__spectrumClick(t){this.__onSpectrumChange(t.pageX-window.pageXOffset,t.pageY-window.pageYOffset,!0)},__activate(t){this.__onSpectrumChange(t.pageX-window.pageXOffset,t.pageY-window.pageYOffset)}}});const breaks=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178];function toJalaali(t,e,i){return"[object Date]"===Object.prototype.toString.call(t)&&(i=t.getDate(),e=t.getMonth()+1,t=t.getFullYear()),d2j(g2d(t,e,i))}function toGregorian(t,e,i){return d2g(j2d(t,e,i))}function isLeapJalaaliYear(t){return 0===jalCalLeap(t)}function jalaaliMonthLength(t,e){return e<=6?31:e<=11?30:isLeapJalaaliYear(t)?30:29}function jalCalLeap(t){const e=breaks.length;let i,s,o,n,r,a=breaks[0];if(t<a||t>=breaks[e-1])throw new Error("Invalid Jalaali year "+t);for(r=1;r<e&&(s=(i=breaks[r])-a,!(t<i));r+=1)a=i;return s-(n=t-a)<6&&(n=n-s+33*div(s+4,33)),-1===(o=mod(mod(n+1,33)-1,4))&&(o=4),o}function jalCal(t,e){const i=breaks.length,s=t+621;let o,n,r,a,l,h=-14,d=breaks[0];if(t<d||t>=breaks[i-1])throw new Error("Invalid Jalaali year "+t);for(l=1;l<i&&(n=(o=breaks[l])-d,!(t<o));l+=1)h=h+8*div(n,33)+div(mod(n,33),4),d=o;h=h+8*div(a=t-d,33)+div(mod(a,33)+3,4),4===mod(n,33)&&n-a==4&&(h+=1);const c=20+h-(div(s,4)-div(3*(div(s,100)+1),4)-150);return e||(n-a<6&&(a=a-n+33*div(n+4,33)),-1===(r=mod(mod(a+1,33)-1,4))&&(r=4)),{leap:r,gy:s,march:c}}function j2d(t,e,i){const s=jalCal(t,!0);return g2d(s.gy,3,s.march)+31*(e-1)-div(e,7)*(e-7)+i-1}function d2j(t){const e=d2g(t).gy;let i,s,o,n=e-621;const r=jalCal(n,!1);if((o=t-g2d(e,3,r.march))>=0){if(o<=185)return{jy:n,jm:s=1+div(o,31),jd:i=mod(o,31)+1};o-=186}else n-=1,o+=179,1===r.leap&&(o+=1);return{jy:n,jm:s=7+div(o,30),jd:i=mod(o,30)+1}}function g2d(t,e,i){let s=div(1461*(t+div(e-8,6)+100100),4)+div(153*mod(e+9,12)+2,5)+i-34840408;return s=s-div(3*div(t+100100+div(e-8,6),100),4)+752}function d2g(t){let e=4*t+139361631;const i=5*div(mod(e=e+4*div(3*div(4*t+183187720,146097),4)-3908,1461),4)+308,s=div(mod(i,153),5)+1,o=mod(div(i,153),12)+1;return{gy:div(e,1461)-100100+div(8-o,6),gm:o,gd:s}}function div(t,e){return~~(t/e)}function mod(t,e){return t-~~(t/e)*e}var DateTimeMixin={mixins:[DarkMixin,FormMixin,ListenersMixin],props:{value:{required:!0},mask:{type:String},locale:Object,calendar:{type:String,validator:t=>["gregorian","persian"].includes(t),default:"gregorian"},landscape:Boolean,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,readonly:Boolean,disable:Boolean},watch:{mask(){this.$nextTick(()=>{this.__updateValue({},"mask")})},computedLocale(){this.$nextTick(()=>{this.__updateValue({},"locale")})}},computed:{editable(){return!0!==this.disable&&!0!==this.readonly},computedColor(){return this.color||"primary"},computedTextColor(){return this.textColor||"white"},computedTabindex(){return!0===this.editable?0:-1},headerClass(){const t=[];return void 0!==this.color&&t.push(`bg-${this.color}`),void 0!==this.textColor&&t.push(`text-${this.textColor}`),t.join(" ")},computedLocale(){return this.__getComputedLocale()}},methods:{__getComputedLocale(){return this.locale||this.$q.lang.date},__getCurrentDate(){const t=new Date;if("persian"===this.calendar){const e=toJalaali(t);return{year:e.jy,month:e.jm,day:e.jd}}return{year:t.getFullYear(),month:t.getMonth()+1,day:t.getDate()}},__getCurrentTime(){const t=new Date;return{hour:t.getHours(),minute:t.getMinutes(),second:t.getSeconds(),millisecond:t.getMilliseconds()}}}};const MILLISECONDS_IN_DAY=864e5,MILLISECONDS_IN_HOUR=36e5,MILLISECONDS_IN_MINUTE=6e4,defaultMask="YYYY-MM-DDTHH:mm:ss.SSSZ",token=/\[((?:[^\]\\]|\\]|\\)*)\]|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]/g,reverseToken=/(\[[^\]]*\])|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]|([.*+:?^,\s${}()|\\]+)/g,regexStore={};function getRegexData(t,e){const i="("+e.days.join("|")+")",s=t+i;if(void 0!==regexStore[s])return regexStore[s];const o="("+e.daysShort.join("|")+")",n="("+e.months.join("|")+")",r="("+e.monthsShort.join("|")+")",a={};let l=0;const h=t.replace(reverseToken,t=>{switch(l++,t){case"YY":return a.YY=l,"(-?\\d{1,2})";case"YYYY":return a.YYYY=l,"(-?\\d{1,4})";case"M":return a.M=l,"(\\d{1,2})";case"MM":return a.M=l,"(\\d{2})";case"MMM":return a.MMM=l,r;case"MMMM":return a.MMMM=l,n;case"D":return a.D=l,"(\\d{1,2})";case"Do":return a.D=l++,"(\\d{1,2}(st|nd|rd|th))";case"DD":return a.D=l,"(\\d{2})";case"H":return a.H=l,"(\\d{1,2})";case"HH":return a.H=l,"(\\d{2})";case"h":return a.h=l,"(\\d{1,2})";case"hh":return a.h=l,"(\\d{2})";case"m":return a.m=l,"(\\d{1,2})";case"mm":return a.m=l,"(\\d{2})";case"s":return a.s=l,"(\\d{1,2})";case"ss":return a.s=l,"(\\d{2})";case"S":return a.S=l,"(\\d{1})";case"SS":return a.S=l,"(\\d{2})";case"SSS":return a.S=l,"(\\d{3})";case"A":return a.A=l,"(AM|PM)";case"a":return a.a=l,"(am|pm)";case"aa":return a.aa=l,"(a\\.m\\.|p\\.m\\.)";case"ddd":return o;case"dddd":return i;case"Q":case"d":case"E":return"(\\d{1})";case"Qo":return"(1st|2nd|3rd|4th)";case"DDD":case"DDDD":return"(\\d{1,3})";case"w":return"(\\d{1,2})";case"ww":return"(\\d{2})";case"Z":return a.Z=l,"(Z|[+-]\\d{2}:\\d{2})";case"ZZ":return a.ZZ=l,"(Z|[+-]\\d{2}\\d{2})";case"X":return a.X=l,"(-?\\d+)";case"x":return a.x=l,"(-?\\d{4,})";default:return l--,"["===t[0]&&(t=t.substring(1,t.length-1)),t.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}}),d={map:a,regex:new RegExp("^"+h)};return regexStore[s]=d,d}function extractDate(t,e,i){const s=__splitDate(t,e,i),o=new Date(s.year,null===s.month?null:s.month-1,s.day,s.hour,s.minute,s.second,s.millisecond),n=o.getTimezoneOffset();return null===s.timezoneOffset||s.timezoneOffset===n?o:getChange(o,{minutes:s.timezoneOffset-n},!0)}function __splitDate(t,e,i,s,o){const n=Object.assign({year:null,month:null,day:null,hour:null,minute:null,second:null,millisecond:null,timezoneOffset:null,dateHash:null,timeHash:null},o);if(void 0===t||null===t||""===t||"string"!=typeof t)return n;void 0===e&&(e=defaultMask);const r=void 0!==i?i:lang.props.date,a=r.months,l=r.monthsShort,{regex:h,map:d}=getRegexData(e,r),c=t.match(h);if(null===c)return n;let u="";if(void 0!==d.X||void 0!==d.x){const t=parseInt(c[void 0!==d.X?d.X:d.x],10);if(!0===isNaN(t)||t<0)return n;const e=new Date(t*(void 0!==d.X?1e3:1));n.year=e.getFullYear(),n.month=e.getMonth()+1,n.day=e.getDate(),n.hour=e.getHours(),n.minute=e.getMinutes(),n.second=e.getSeconds(),n.millisecond=e.getMilliseconds()}else{if(void 0!==d.YYYY)n.year=parseInt(c[d.YYYY],10);else if(void 0!==d.YY){const t=parseInt(c[d.YY],10);n.year=t<0?t:2e3+t}if(void 0!==d.M){if(n.month=parseInt(c[d.M],10),n.month<1||n.month>12)return n}else void 0!==d.MMM?n.month=l.indexOf(c[d.MMM])+1:void 0!==d.MMMM&&(n.month=a.indexOf(c[d.MMMM])+1);if(void 0!==d.D){if(n.day=parseInt(c[d.D],10),null===n.year||null===n.month||n.day<1)return n;const t="persian"!==s?new Date(n.year,n.month,0).getDate():jalaaliMonthLength(n.year,n.month);if(n.day>t)return n}void 0!==d.H?n.hour=parseInt(c[d.H],10)%24:void 0!==d.h&&(n.hour=parseInt(c[d.h],10)%12,(d.A&&"PM"===c[d.A]||d.a&&"pm"===c[d.a]||d.aa&&"p.m."===c[d.aa])&&(n.hour+=12),n.hour=n.hour%24),void 0!==d.m&&(n.minute=parseInt(c[d.m],10)%60),void 0!==d.s&&(n.second=parseInt(c[d.s],10)%60),void 0!==d.S&&(n.millisecond=parseInt(c[d.S],10)*10**(3-c[d.S].length)),void 0===d.Z&&void 0===d.ZZ||(u=void 0!==d.Z?c[d.Z].replace(":",""):c[d.ZZ],n.timezoneOffset=("+"===u[0]?-1:1)*(60*u.slice(1,3)+1*u.slice(3,5)))}return n.dateHash=n.year+"/"+pad(n.month)+"/"+pad(n.day),n.timeHash=pad(n.hour)+":"+pad(n.minute)+":"+pad(n.second)+u,n}function formatTimezone(t,e=""){const i=t>0?"-":"+",s=Math.abs(t),o=s%60;return i+pad(Math.floor(s/60))+e+pad(o)}function setMonth(t,e){const i=new Date(t.getFullYear(),e,0,0,0,0,0).getDate();t.setMonth(e-1,Math.min(i,t.getDate()))}function getChange(t,e,i){const s=new Date(t),o=i?1:-1;return Object.keys(e).forEach(t=>{if("month"===t)return void setMonth(s,s.getMonth()+1+o*e.month);const i="year"===t?"FullYear":capitalize("days"===t?"date":t);s[`set${i}`](s[`get${i}`]()+o*e[t])}),s}function isValid(t){return"number"==typeof t||!1===isNaN(Date.parse(t))}function buildDate(t,e){return adjustDate(new Date,t,e)}function getDayOfWeek(t){const e=new Date(t).getDay();return 0===e?7:e}function getWeekOfYear(t){const e=new Date(t.getFullYear(),t.getMonth(),t.getDate());e.setDate(e.getDate()-(e.getDay()+6)%7+3);const i=new Date(e.getFullYear(),0,4);i.setDate(i.getDate()-(i.getDay()+6)%7+3);const s=e.getTimezoneOffset()-i.getTimezoneOffset();e.setHours(e.getHours()-s);const o=(e-i)/(7*MILLISECONDS_IN_DAY);return 1+Math.floor(o)}function getDayIdentifier(t){return 1e4*t.getFullYear()+100*t.getMonth()+t.getDate()}function getDateIdentifier(t,e){const i=new Date(t);return!0===e?getDayIdentifier(i):i.getTime()}function isBetweenDates(t,e,i,s={}){const o=getDateIdentifier(e,s.onlyDate),n=getDateIdentifier(i,s.onlyDate),r=getDateIdentifier(t,s.onlyDate);return(r>o||!0===s.inclusiveFrom&&r===o)&&(r<n||!0===s.inclusiveTo&&r===n)}function addToDate(t,e){return getChange(t,e,!0)}function subtractFromDate(t,e){return getChange(t,e,!1)}function adjustDate(t,e,i){const s=new Date(t),o=`set${i?"UTC":""}`;return Object.keys(e).forEach(t=>{if("month"===t)return void setMonth(s,e.month);const i="year"===t?"FullYear":t.charAt(0).toUpperCase()+t.slice(1);s[`${o}${i}`](e[t])}),s}function startOfDate(t,e){const i=new Date(t);switch(e){case"year":i.setMonth(0);case"month":i.setDate(1);case"day":i.setHours(0);case"hour":i.setMinutes(0);case"minute":i.setSeconds(0);case"second":i.setMilliseconds(0)}return i}function endOfDate(t,e){const i=new Date(t);switch(e){case"year":i.setMonth(11);case"month":i.setDate(daysInMonth(i));case"day":i.setHours(23);case"hour":i.setMinutes(59);case"minute":i.setSeconds(59);case"second":i.setMilliseconds(59)}return i}function getMaxDate(t){let e=new Date(t);return Array.prototype.slice.call(arguments,1).forEach(t=>{e=Math.max(e,new Date(t))}),e}function getMinDate(t){let e=new Date(t);return Array.prototype.slice.call(arguments,1).forEach(t=>{e=Math.min(e,new Date(t))}),e}function getDiff(t,e,i){return(t.getTime()-t.getTimezoneOffset()*MILLISECONDS_IN_MINUTE-(e.getTime()-e.getTimezoneOffset()*MILLISECONDS_IN_MINUTE))/i}function getDateDiff(t,e,i="days"){const s=new Date(t),o=new Date(e);switch(i){case"years":return s.getFullYear()-o.getFullYear();case"months":return 12*(s.getFullYear()-o.getFullYear())+s.getMonth()-o.getMonth();case"days":return getDiff(startOfDate(s,"day"),startOfDate(o,"day"),MILLISECONDS_IN_DAY);case"hours":return getDiff(startOfDate(s,"hour"),startOfDate(o,"hour"),MILLISECONDS_IN_HOUR);case"minutes":return getDiff(startOfDate(s,"minute"),startOfDate(o,"minute"),MILLISECONDS_IN_MINUTE);case"seconds":return getDiff(startOfDate(s,"second"),startOfDate(o,"second"),1e3)}}function getDayOfYear(t){return getDateDiff(t,startOfDate(t,"year"),"days")+1}function inferDateFormat(t){return!0===isDate(t)?"date":"number"==typeof t?"number":"string"}function getDateBetween(t,e,i){const s=new Date(t);if(e){const t=new Date(e);if(s<t)return t}if(i){const t=new Date(i);if(s>t)return t}return s}function isSameDate(t,e,i){const s=new Date(t),o=new Date(e);if(void 0===i)return s.getTime()===o.getTime();switch(i){case"second":if(s.getSeconds()!==o.getSeconds())return!1;case"minute":if(s.getMinutes()!==o.getMinutes())return!1;case"hour":if(s.getHours()!==o.getHours())return!1;case"day":if(s.getDate()!==o.getDate())return!1;case"month":if(s.getMonth()!==o.getMonth())return!1;case"year":if(s.getFullYear()!==o.getFullYear())return!1;break;default:throw new Error(`date isSameDate unknown unit ${i}`)}return!0}function daysInMonth(t){return new Date(t.getFullYear(),t.getMonth()+1,0).getDate()}function getOrdinal(t){if(t>=11&&t<=13)return`${t}th`;switch(t%10){case 1:return`${t}st`;case 2:return`${t}nd`;case 3:return`${t}rd`}return`${t}th`}const formatter={YY(t,e,i){const s=this.YYYY(t,e,i)%100;return s>0?pad(s):"-"+pad(Math.abs(s))},YYYY:(t,e,i)=>void 0!==i&&null!==i?i:t.getFullYear(),M:t=>t.getMonth()+1,MM:t=>pad(t.getMonth()+1),MMM:(t,e)=>e.monthsShort[t.getMonth()],MMMM:(t,e)=>e.months[t.getMonth()],Q:t=>Math.ceil((t.getMonth()+1)/3),Qo(t){return getOrdinal(this.Q(t))},D:t=>t.getDate(),Do:t=>getOrdinal(t.getDate()),DD:t=>pad(t.getDate()),DDD:t=>getDayOfYear(t),DDDD:t=>pad(getDayOfYear(t),3),d:t=>t.getDay(),dd(t,e){return this.dddd(t,e).slice(0,2)},ddd:(t,e)=>e.daysShort[t.getDay()],dddd:(t,e)=>e.days[t.getDay()],E:t=>t.getDay()||7,w:t=>getWeekOfYear(t),ww:t=>pad(getWeekOfYear(t)),H:t=>t.getHours(),HH:t=>pad(t.getHours()),h(t){const e=t.getHours();return 0===e?12:e>12?e%12:e},hh(t){return pad(this.h(t))},m:t=>t.getMinutes(),mm:t=>pad(t.getMinutes()),s:t=>t.getSeconds(),ss:t=>pad(t.getSeconds()),S:t=>Math.floor(t.getMilliseconds()/100),SS:t=>pad(Math.floor(t.getMilliseconds()/10)),SSS:t=>pad(t.getMilliseconds(),3),A(t){return this.H(t)<12?"AM":"PM"},a(t){return this.H(t)<12?"am":"pm"},aa(t){return this.H(t)<12?"a.m.":"p.m."},Z:(t,e,i,s)=>formatTimezone(void 0===s||null===s?t.getTimezoneOffset():s,":"),ZZ:(t,e,i,s)=>formatTimezone(void 0===s||null===s?t.getTimezoneOffset():s),X:t=>Math.floor(t.getTime()/1e3),x:t=>t.getTime()};function formatDate(t,e,i,s,o){if(0!==t&&!t||t===1/0||t===-1/0)return;const n=new Date(t);if(isNaN(n))return;void 0===e&&(e=defaultMask);const r=void 0!==i?i:lang.props.date;return e.replace(token,(t,e)=>t in formatter?formatter[t](n,r,s,o):void 0===e?t:e.split("\\]").join("]"))}function clone(t){return!0===isDate(t)?new Date(t.getTime()):t}var date={isValid:isValid,extractDate:extractDate,buildDate:buildDate,getDayOfWeek:getDayOfWeek,getWeekOfYear:getWeekOfYear,isBetweenDates:isBetweenDates,addToDate:addToDate,subtractFromDate:subtractFromDate,adjustDate:adjustDate,startOfDate:startOfDate,endOfDate:endOfDate,getMaxDate:getMaxDate,getMinDate:getMinDate,getDateDiff:getDateDiff,getDayOfYear:getDayOfYear,inferDateFormat:inferDateFormat,getDateBetween:getDateBetween,isSameDate:isSameDate,daysInMonth:daysInMonth,formatDate:formatDate,clone:clone};const yearsInterval=20,viewIsValid=t=>["Calendar","Years","Months"].includes(t);var QDate=Vue.extend({name:"QDate",mixins:[DateTimeMixin],props:{title:String,subtitle:String,emitImmediately:Boolean,mask:{default:"YYYY/MM/DD"},defaultYearMonth:{type:String,validator:t=>/^-?[\d]+\/[0-1]\d$/.test(t)},yearsInMonthView:Boolean,events:[Array,Function],eventColor:[String,Function],options:[Array,Function],firstDayOfWeek:[String,Number],todayBtn:Boolean,minimal:Boolean,defaultView:{type:String,default:"Calendar",validator:viewIsValid}},data(){const{inner:t,external:e}=this.__getModels(this.value,this.mask,this.__getComputedLocale()),i=!0===this.$q.lang.rtl?"right":"left";return{view:this.defaultView,monthDirection:i,yearDirection:i,startYear:t.year-t.year%20-(t.year<0?20:0),innerModel:t,extModel:e}},watch:{value(t){const{inner:e,external:i}=this.__getModels(t,this.mask,this.__getComputedLocale());this.extModel.dateHash===i.dateHash&&this.extModel.timeHash===i.timeHash||(this.extModel=i),e.dateHash!==this.innerModel.dateHash&&(this.monthDirection=this.innerModel.dateHash<e.dateHash==(!0!==this.$q.lang.rtl)?"left":"right",e.year!==this.innerModel.year&&(this.yearDirection=this.monthDirection),this.$nextTick(()=>{this.startYear=e.year-e.year%20-(e.year<0?20:0),this.innerModel=e}))},view(){void 0!==this.$refs.blurTarget&&this.$refs.blurTarget.focus()}},computed:{classes(){const t=!0===this.landscape?"landscape":"portrait";return`q-date q-date--${t} q-date--${t}-${!0===this.minimal?"minimal":"standard"}`+(!0===this.isDark?" q-date--dark q-dark":"")+(!0===this.bordered?" q-date--bordered":"")+(!0===this.square?" q-date--square no-border-radius":"")+(!0===this.flat?" q-date--flat no-shadow":"")+(!0===this.disable?" disabled":!0===this.readonly?" q-date--readonly":"")},headerTitle(){if(void 0!==this.title&&null!==this.title&&this.title.length>0)return this.title;const t=this.extModel;if(null===t.dateHash)return" --- ";let e;if("persian"!==this.calendar)e=new Date(t.year,t.month-1,t.day);else{const i=toGregorian(t.year,t.month,t.day);e=new Date(i.gy,i.gm-1,i.gd)}return!0===isNaN(e.valueOf())?" --- ":void 0!==this.computedLocale.headerTitle?this.computedLocale.headerTitle(e,t):this.computedLocale.daysShort[e.getDay()]+", "+this.computedLocale.monthsShort[t.month-1]+" "+t.day},headerSubtitle(){return void 0!==this.subtitle&&null!==this.subtitle&&this.subtitle.length>0?this.subtitle:null!==this.extModel.year?this.extModel.year:" --- "},dateArrow(){const t=[this.$q.iconSet.datetime.arrowLeft,this.$q.iconSet.datetime.arrowRight];return!0===this.$q.lang.rtl?t.reverse():t},computedFirstDayOfWeek(){return void 0!==this.firstDayOfWeek?Number(this.firstDayOfWeek):this.computedLocale.firstDayOfWeek},daysOfWeek(){const t=this.computedLocale.daysShort,e=this.computedFirstDayOfWeek;return e>0?t.slice(e,7).concat(t.slice(0,e)):t},daysInMonth(){return this.__getDaysInMonth(this.innerModel)},today(){return this.__getCurrentDate()},evtFn(){return"function"==typeof this.events?this.events:t=>this.events.includes(t)},evtColor(){return"function"==typeof this.eventColor?this.eventColor:t=>this.eventColor},isInSelection(){return"function"==typeof this.options?this.options:t=>this.options.includes(t)},days(){let t,e;const i=[];if("persian"!==this.calendar)t=new Date(this.innerModel.year,this.innerModel.month-1,1),e=new Date(this.innerModel.year,this.innerModel.month-1,0).getDate();else{const i=toGregorian(this.innerModel.year,this.innerModel.month,1);t=new Date(i.gy,i.gm-1,i.gd);let s=this.innerModel.month-1,o=this.innerModel.year;0===s&&(s=12,o--),e=jalaaliMonthLength(o,s)}const s=t.getDay()-this.computedFirstDayOfWeek-1,o=s<0?s+7:s;if(o<6)for(let t=e-o;t<=e;t++)i.push({i:t,fill:!0});const n=i.length,r=this.innerModel.year+"/"+pad(this.innerModel.month)+"/";for(let t=1;t<=this.daysInMonth;t++){const e=r+pad(t);if(void 0!==this.options&&!0!==this.isInSelection(e))i.push({i:t});else{const s=void 0!==this.events&&!0===this.evtFn(e)&&this.evtColor(e);i.push({i:t,in:!0,flat:!0,event:s})}}if(this.innerModel.year===this.extModel.year&&this.innerModel.month===this.extModel.month){const t=n+this.innerModel.day-1;void 0!==i[t]&&Object.assign(i[t],{unelevated:!0,flat:!1,color:this.computedColor,textColor:this.computedTextColor})}this.innerModel.year===this.today.year&&this.innerModel.month===this.today.month&&(i[n+this.today.day-1].today=!0);const a=i.length%7;if(a>0){const t=7-a;for(let e=1;e<=t;e++)i.push({i:e,fill:!0})}return i},attrs(){return!0===this.disable?{"aria-disabled":""}:!0===this.readonly?{"aria-readonly":""}:void 0}},methods:{setToday(){this.__updateValue({...this.today},"today"),this.view="Calendar"},setView(t){!0===viewIsValid(t)&&(this.view=t)},offsetCalendar(t,e){["month","year"].includes(t)&&this[`__goTo${"month"===t?"Month":"Year"}`](!0===e?-1:1)},__getModels(t,e,i){const s=__splitDate(t,"persian"===this.calendar?"YYYY/MM/DD":e,i,this.calendar);return{external:s,inner:null===s.dateHash?this.__getDefaultModel():{...s}}},__getDefaultModel(){let t,e;if(void 0!==this.defaultYearMonth){const i=this.defaultYearMonth.split("/");t=parseInt(i[0],10),e=parseInt(i[1],10)}else{const i=void 0!==this.today?this.today:this.__getCurrentDate();t=i.year,e=i.month}return{year:t,month:e,day:1,hour:0,minute:0,second:0,millisecond:0,dateHash:t+"/"+pad(e)+"/01"}},__getHeader(t){if(!0!==this.minimal)return t("div",{staticClass:"q-date__header",class:this.headerClass},[t("div",{staticClass:"relative-position"},[t("transition",{props:{name:"q-transition--fade"}},[t("div",{key:"h-yr-"+this.headerSubtitle,staticClass:"q-date__header-subtitle q-date__header-link",class:"Years"===this.view?"q-date__header-link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"vY",{click:()=>{this.view="Years"},keyup:t=>{13===t.keyCode&&(this.view="Years")}})},[this.headerSubtitle])])]),t("div",{staticClass:"q-date__header-title relative-position flex no-wrap"},[t("div",{staticClass:"relative-position col"},[t("transition",{props:{name:"q-transition--fade"}},[t("div",{key:"h-sub"+this.headerTitle,staticClass:"q-date__header-title-label q-date__header-link",class:"Calendar"===this.view?"q-date__header-link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"vC",{click:()=>{this.view="Calendar"},keyup:t=>{13===t.keyCode&&(this.view="Calendar")}})},[this.headerTitle])])]),!0===this.todayBtn?t(QBtn,{staticClass:"q-date__header-today",props:{icon:this.$q.iconSet.datetime.today,flat:!0,size:"sm",round:!0,tabindex:this.computedTabindex},on:cache(this,"today",{click:this.setToday})}):null])])},__getNavigation(t,{label:e,view:i,key:s,dir:o,goTo:n,cls:r}){return[t("div",{staticClass:"row items-center q-date__arrow"},[t(QBtn,{props:{round:!0,dense:!0,size:"sm",flat:!0,icon:this.dateArrow[0],tabindex:this.computedTabindex},on:cache(this,"go-#"+i,{click(){n(-1)}})})]),t("div",{staticClass:"relative-position overflow-hidden flex flex-center"+r},[t("transition",{props:{name:"q-transition--jump-"+o}},[t("div",{key:s},[t(QBtn,{props:{flat:!0,dense:!0,noCaps:!0,label:e,tabindex:this.computedTabindex},on:cache(this,"view#"+i,{click:()=>{this.view=i}})})])])]),t("div",{staticClass:"row items-center q-date__arrow"},[t(QBtn,{props:{round:!0,dense:!0,size:"sm",flat:!0,icon:this.dateArrow[1],tabindex:this.computedTabindex},on:cache(this,"go+#"+i,{click(){n(1)}})})])]},__getCalendarView(t){return[t("div",{key:"calendar-view",staticClass:"q-date__view q-date__calendar"},[t("div",{staticClass:"q-date__navigation row items-center no-wrap"},this.__getNavigation(t,{label:this.computedLocale.months[this.innerModel.month-1],view:"Months",key:this.innerModel.month,dir:this.monthDirection,goTo:this.__goToMonth,cls:" col"}).concat(this.__getNavigation(t,{label:this.innerModel.year,view:"Years",key:this.innerModel.year,dir:this.yearDirection,goTo:this.__goToYear,cls:""}))),t("div",{staticClass:"q-date__calendar-weekdays row items-center no-wrap"},this.daysOfWeek.map(e=>t("div",{staticClass:"q-date__calendar-item"},[t("div",[e])]))),t("div",{staticClass:"q-date__calendar-days-container relative-position overflow-hidden"},[t("transition",{props:{name:"q-transition--slide-"+this.monthDirection}},[t("div",{key:this.innerModel.year+"/"+this.innerModel.month,staticClass:"q-date__calendar-days fit"},this.days.map(e=>t("div",{staticClass:`q-date__calendar-item q-date__calendar-item--${!0===e.fill?"fill":!0===e.in?"in":"out"}`},[!0===e.in?t(QBtn,{staticClass:!0===e.today?"q-date__today":null,props:{dense:!0,flat:e.flat,unelevated:e.unelevated,color:e.color,textColor:e.textColor,label:e.i,tabindex:this.computedTabindex},on:cache(this,"day#"+e.i,{click:()=>{this.__setDay(e.i)}})},!1!==e.event?[t("div",{staticClass:"q-date__event bg-"+e.event})]:null):t("div",[e.i])])))])])])]},__getMonthsView(t){const e=this.innerModel.year===this.today.year,i=this.computedLocale.monthsShort.map((i,s)=>{const o=this.innerModel.month===s+1;return t("div",{staticClass:"q-date__months-item flex flex-center"},[t(QBtn,{staticClass:!0===e&&this.today.month===s+1?"q-date__today":null,props:{flat:!0!==o,label:i,unelevated:o,color:!0===o?this.computedColor:null,textColor:!0===o?this.computedTextColor:null,tabindex:this.computedTabindex},on:cache(this,"month#"+s,{click:()=>{this.__setMonth(s+1)}})})])});return!0===this.yearsInMonthView&&i.unshift(t("div",{staticClass:"row no-wrap full-width"},[this.__getNavigation(t,{label:this.innerModel.year,view:"Years",key:this.innerModel.year,dir:this.yearDirection,goTo:this.__goToYear,cls:" col"})])),t("div",{key:"months-view",staticClass:"q-date__view q-date__months flex flex-center"},i)},__getYearsView(t){const e=this.startYear,i=e+20,s=[];for(let o=e;o<=i;o++){const e=this.innerModel.year===o;s.push(t("div",{staticClass:"q-date__years-item flex flex-center"},[t(QBtn,{key:"yr"+o,staticClass:this.today.year===o?"q-date__today":null,props:{flat:!e,label:o,dense:!0,unelevated:e,color:e?this.computedColor:null,textColor:e?this.computedTextColor:null,tabindex:this.computedTabindex},on:cache(this,"yr#"+o,{click:()=>{this.__setYear(o)}})})]))}return t("div",{staticClass:"q-date__view q-date__years flex flex-center"},[t("div",{staticClass:"col-auto"},[t(QBtn,{props:{round:!0,dense:!0,flat:!0,icon:this.dateArrow[0],tabindex:this.computedTabindex},on:cache(this,"y-",{click:()=>{this.startYear-=20}})})]),t("div",{staticClass:"q-date__years-content col self-stretch row items-center"},s),t("div",{staticClass:"col-auto"},[t(QBtn,{props:{round:!0,dense:!0,flat:!0,icon:this.dateArrow[1],tabindex:this.computedTabindex},on:cache(this,"y+",{click:()=>{this.startYear+=20}})})])])},__getDaysInMonth(t){return"persian"!==this.calendar?new Date(t.year,t.month,0).getDate():jalaaliMonthLength(t.year,t.month)},__goToMonth(t){let e=Number(this.innerModel.month)+t,i=this.yearDirection;13===e?(e=1,this.innerModel.year++,i=!0!==this.$q.lang.rtl?"left":"right"):0===e&&(e=12,this.innerModel.year--,i=!0!==this.$q.lang.rtl?"right":"left"),this.monthDirection=t>0==(!0!==this.$q.lang.rtl)?"left":"right",this.yearDirection=i,this.innerModel.month=e,!0===this.emitImmediately&&this.__updateValue({},"month")},__goToYear(t){this.monthDirection=this.yearDirection=t>0==(!0!==this.$q.lang.rtl)?"left":"right",this.innerModel.year=Number(this.innerModel.year)+t,!0===this.emitImmediately&&this.__updateValue({},"year")},__setYear(t){this.innerModel.year=t,!0===this.emitImmediately&&this.__updateValue({year:t},"year"),this.view=null===this.extModel.month||"Years"===this.defaultView?"Months":"Calendar"},__setMonth(t){this.innerModel.month=t,!0===this.emitImmediately&&this.__updateValue({month:t},"month"),this.view="Calendar"},__setDay(t){this.__updateValue({day:t},"day")},__updateValue(t,e){if(void 0===t.year&&(t.year=this.innerModel.year),void 0===t.month&&(t.month=this.innerModel.month),void 0===t.day||!0===this.emitImmediately&&("year"===e||"month"===e)){t.day=this.innerModel.day;const e=!0===this.emitImmediately?this.__getDaysInMonth(t):this.daysInMonth;t.day=Math.min(Math.max(1,t.day),e)}const i="persian"===this.calendar?t.year+"/"+pad(t.month)+"/"+pad(t.day):formatDate(new Date(t.year,t.month-1,t.day,this.extModel.hour,this.extModel.minute,this.extModel.second,this.extModel.millisecond),this.mask,this.computedLocale,t.year,this.extModel.timezoneOffset);if(t.changed=i!==this.value,this.$emit("input",i,e,t),i===this.value&&"today"===e){const e=t.year+"/"+pad(t.month)+"/"+pad(t.day),i=this.innerModel.year+"/"+pad(this.innerModel.month)+"/"+pad(this.innerModel.day);e!==i&&(this.monthDirection=i<e==(!0!==this.$q.lang.rtl)?"left":"right",t.year!==this.innerModel.year&&(this.yearDirection=this.monthDirection),this.$nextTick(()=>{this.startYear=t.year-t.year%20-(t.year<0?20:0),Object.assign(this.innerModel,{year:t.year,month:t.month,day:t.day,dateHash:e})}))}}},render(t){const e=[t("div",{staticClass:"q-date__content col relative-position"},[t("transition",{props:{name:"q-transition--fade"}},[this[`__get${this.view}View`](t)])])],i=slot(this,"default");return void 0!==i&&e.push(t("div",{staticClass:"q-date__actions"},i)),void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(e,"push"),t("div",{class:this.classes,attrs:this.attrs,on:{...this.qListeners}},[this.__getHeader(t),t("div",{staticClass:"q-date__main col column",attrs:{tabindex:-1},ref:"blurTarget"},e)])}}),HistoryMixin={methods:{__addHistory(){this.__historyEntry={condition:()=>!0===this.hideOnRouteChange,handler:this.hide},History.add(this.__historyEntry)},__removeHistory(){void 0!==this.__historyEntry&&(History.remove(this.__historyEntry),this.__historyEntry=void 0)}},beforeDestroy(){!0===this.showing&&this.__removeHistory()}};let scrollPositionX,scrollPositionY,maxScrollTop,bodyLeft,bodyTop,closeTimer,registered=0,vpPendingUpdate=!1;function onWheel(t){shouldPreventScroll(t)&&stopAndPrevent(t)}function shouldPreventScroll(t){if(t.target===document.body||t.target.classList.contains("q-layout__backdrop"))return!0;const e=getEventPath(t),i=t.shiftKey&&!t.deltaX,s=!i&&Math.abs(t.deltaX)<=Math.abs(t.deltaY),o=i||s?t.deltaY:t.deltaX;for(let t=0;t<e.length;t++){const i=e[t];if(hasScrollbar(i,s))return s?o<0&&0===i.scrollTop||o>0&&i.scrollTop+i.clientHeight===i.scrollHeight:o<0&&0===i.scrollLeft||o>0&&i.scrollLeft+i.clientWidth===i.scrollWidth}return!0}function onAppleScroll(t){t.target===document&&(document.scrollingElement.scrollTop=document.scrollingElement.scrollTop)}function onAppleResize(t){!0!==vpPendingUpdate&&(vpPendingUpdate=!0,requestAnimationFrame(()=>{vpPendingUpdate=!1;const{height:e}=t.target,{clientHeight:i,scrollTop:s}=document.scrollingElement;void 0!==maxScrollTop&&e===window.innerHeight||(maxScrollTop=i-e,document.scrollingElement.scrollTop=s),s>maxScrollTop&&(document.scrollingElement.scrollTop-=Math.ceil((s-maxScrollTop)/8))}))}function apply(t){const e=document.body,i=void 0!==window.visualViewport;if("add"===t){const t=window.getComputedStyle(e).overflowY;scrollPositionX=getHorizontalScrollPosition(window),scrollPositionY=getScrollPosition(window),bodyLeft=e.style.left,bodyTop=e.style.top,e.style.left=`-${scrollPositionX}px`,e.style.top=`-${scrollPositionY}px`,"hidden"!==t&&("scroll"===t||e.scrollHeight>window.innerHeight)&&e.classList.add("q-body--force-scrollbar"),e.classList.add("q-body--prevent-scroll"),document.qScrollPrevented=!0,!0===client.is.ios&&(!0===i?(window.scrollTo(0,0),window.visualViewport.addEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.addEventListener("scroll",onAppleResize,listenOpts.passiveCapture),window.scrollTo(0,0)):window.addEventListener("scroll",onAppleScroll,listenOpts.passiveCapture))}!0===client.is.desktop&&!0===client.is.mac&&window[`${t}EventListener`]("wheel",onWheel,listenOpts.notPassive),"remove"===t&&(!0===client.is.ios&&(!0===i?(window.visualViewport.removeEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.removeEventListener("scroll",onAppleResize,listenOpts.passiveCapture)):window.removeEventListener("scroll",onAppleScroll,listenOpts.passiveCapture)),e.classList.remove("q-body--prevent-scroll"),e.classList.remove("q-body--force-scrollbar"),document.qScrollPrevented=!1,e.style.left=bodyLeft,e.style.top=bodyTop,window.scrollTo(scrollPositionX,scrollPositionY),maxScrollTop=void 0)}function preventScroll(t){let e="add";if(!0===t){if(registered++,void 0!==closeTimer)return clearTimeout(closeTimer),void(closeTimer=void 0);if(registered>1)return}else{if(0===registered)return;if(--registered>0)return;if(e="remove",!0===client.is.ios&&!0===client.is.nativeMobile)return clearTimeout(closeTimer),void(closeTimer=setTimeout(()=>{apply(e),closeTimer=void 0},100))}apply(e)}var PreventScrollMixin={methods:{__preventScroll(t){t===this.preventedScroll||void 0===this.preventedScroll&&!0!==t||(this.preventedScroll=t,preventScroll(t))}}};let maximizedModals=0;const positionClass={standard:"fixed-full flex-center",top:"fixed-top justify-center",bottom:"fixed-bottom justify-center",right:"fixed-right items-center",left:"fixed-left items-center"},transitions={standard:["scale","scale"],top:["slide-down","slide-up"],bottom:["slide-up","slide-down"],right:["slide-left","slide-right"],left:["slide-right","slide-left"]};var QDialog=Vue.extend({name:"QDialog",mixins:[AttrsMixin,HistoryMixin,ModelToggleMixin,Portal,PreventScrollMixin],props:{persistent:Boolean,autoClose:Boolean,noEscDismiss:Boolean,noBackdropDismiss:Boolean,noRouteDismiss:Boolean,noRefocus:Boolean,noFocus:Boolean,seamless:Boolean,maximized:Boolean,fullWidth:Boolean,fullHeight:Boolean,square:Boolean,position:{type:String,default:"standard",validator:t=>"standard"===t||["top","bottom","left","right"].includes(t)},transitionShow:String,transitionHide:String},data(){return{transitionState:this.showing}},watch:{showing(t){this.transitionShowComputed!==this.transitionHideComputed&&this.$nextTick(()=>{this.transitionState=t})},maximized(t){!0===this.showing&&this.__updateMaximized(t)},useBackdrop(t){this.__preventScroll(t),this.__preventFocusout(t)}},computed:{classes(){return`q-dialog__inner--${!0===this.maximized?"maximized":"minimized"} `+`q-dialog__inner--${this.position} ${positionClass[this.position]}`+(!0===this.fullWidth?" q-dialog__inner--fullwidth":"")+(!0===this.fullHeight?" q-dialog__inner--fullheight":"")+(!0===this.square?" q-dialog__inner--square":"")},transitionShowComputed(){return"q-transition--"+(void 0===this.transitionShow?transitions[this.position][0]:this.transitionShow)},transitionHideComputed(){return"q-transition--"+(void 0===this.transitionHide?transitions[this.position][1]:this.transitionHide)},transition(){return!0===this.transitionState?this.transitionHideComputed:this.transitionShowComputed},useBackdrop(){return!0===this.showing&&!0!==this.seamless},hideOnRouteChange(){return!0!==this.persistent&&!0!==this.noRouteDismiss&&!0!==this.seamless},onEvents(){const t={...this.qListeners,input:stop,"popup-show":stop,"popup-hide":stop};return!0===this.autoClose&&(t.click=this.__onAutoClose),t}},methods:{focus(){let t=this.__getInnerNode();void 0!==t&&!0!==t.contains(document.activeElement)&&(t=t.querySelector("[autofocus], [data-autofocus]")||t).focus()},shake(){this.focus(),this.$emit("shake");const t=this.__getInnerNode();void 0!==t&&(t.classList.remove("q-animate--scale"),t.classList.add("q-animate--scale"),clearTimeout(this.shakeTimeout),this.shakeTimeout=setTimeout(()=>{t.classList.remove("q-animate--scale")},170))},__getInnerNode(){return void 0!==this.__portal&&void 0!==this.__portal.$refs?this.__portal.$refs.inner:void 0},__show(t){this.__addHistory(),this.__refocusTarget=!1===this.noRefocus&&null!==document.activeElement?document.activeElement:void 0,this.$el.dispatchEvent(create("popup-show",{bubbles:!0})),this.__updateMaximized(this.maximized),EscapeKey.register(this,()=>{!0!==this.seamless&&(!0===this.persistent||!0===this.noEscDismiss?!0!==this.maximized&&this.shake():(this.$emit("escape-key"),this.hide()))}),this.__showPortal(),!0!==this.noFocus&&(null!==document.activeElement&&document.activeElement.blur(),this.__nextTick(this.focus)),this.__setTimeout(()=>{if(!0===this.$q.platform.is.ios){if(!0!==this.seamless&&document.activeElement){const{top:t,bottom:e}=document.activeElement.getBoundingClientRect(),{innerHeight:i}=window,s=void 0!==window.visualViewport?window.visualViewport.height:i;if(t>0&&e>s/2){const t=Math.min(document.scrollingElement.scrollHeight-s,e>=i?1/0:Math.ceil(document.scrollingElement.scrollTop+e-s/2)),o=()=>{requestAnimationFrame(()=>{document.scrollingElement.scrollTop+=Math.ceil((t-document.scrollingElement.scrollTop)/8),document.scrollingElement.scrollTop!==t&&o()})};o()}document.activeElement.scrollIntoView()}this.__portal.$el.click()}this.$emit("show",t)},300)},__hide(t){this.__removeHistory(),this.__cleanup(!0),void 0!==this.__refocusTarget&&null!==this.__refocusTarget&&this.__refocusTarget.focus(),this.$el.dispatchEvent(create("popup-hide",{bubbles:!0})),this.__setTimeout(()=>{this.__hidePortal(),this.$emit("hide",t)},300)},__cleanup(t){clearTimeout(this.shakeTimeout),!0!==t&&!0!==this.showing||(EscapeKey.pop(this),this.__updateMaximized(!1),!0!==this.seamless&&(this.__preventScroll(!1),this.__preventFocusout(!1)))},__updateMaximized(t){!0===t?!0!==this.isMaximized&&(maximizedModals<1&&document.body.classList.add("q-body--dialog"),maximizedModals++,this.isMaximized=!0):!0===this.isMaximized&&(maximizedModals<2&&document.body.classList.remove("q-body--dialog"),maximizedModals--,this.isMaximized=!1)},__preventFocusout(t){if(!0===this.$q.platform.is.desktop){const e=`${!0===t?"add":"remove"}EventListener`;document.body[e]("focusin",this.__onFocusChange)}},__onAutoClose(t){this.hide(t),void 0!==this.qListeners.click&&this.$emit("click",t)},__onBackdropClick(t){!0!==this.persistent&&!0!==this.noBackdropDismiss?this.hide(t):this.shake()},__onFocusChange(t){!0===this.showing&&void 0!==this.__portal&&!0!==childHasFocus(this.__portal.$el,t.target)&&this.focus()},__renderPortal(t){return t("div",{staticClass:"q-dialog fullscreen no-pointer-events",class:this.contentClass,style:this.contentStyle,attrs:this.qAttrs},[t("transition",{props:{name:"q-transition--fade"}},!0===this.useBackdrop?[t("div",{staticClass:"q-dialog__backdrop fixed-full",attrs:ariaHidden,on:cache(this,"bkdrop",{click:this.__onBackdropClick})})]:null),t("transition",{props:{name:this.transition}},[!0===this.showing?t("div",{ref:"inner",staticClass:"q-dialog__inner flex no-pointer-events",class:this.classes,attrs:{tabindex:-1},on:this.onEvents},slot(this,"default")):null])])}},mounted(){this.__processModelChange(this.value)},beforeDestroy(){this.__cleanup()}});const duration=150,mouseEvents=["mouseover","mouseout","mouseenter","mouseleave"];var QDrawer=Vue.extend({name:"QDrawer",inject:{layout:{default(){console.error("QDrawer needs to be child of QLayout")}}},mixins:[DarkMixin,HistoryMixin,ModelToggleMixin,PreventScrollMixin],directives:{TouchPan:TouchPan},props:{side:{type:String,default:"left",validator:t=>["left","right"].includes(t)},width:{type:Number,default:300},mini:Boolean,miniToOverlay:Boolean,miniWidth:{type:Number,default:57},breakpoint:{type:Number,default:1023},showIfAbove:Boolean,behavior:{type:String,validator:t=>["default","desktop","mobile"].includes(t),default:"default"},bordered:Boolean,elevated:Boolean,contentStyle:[String,Object,Array],contentClass:[String,Object,Array],overlay:Boolean,persistent:Boolean,noSwipeOpen:Boolean,noSwipeClose:Boolean,noSwipeBackdrop:Boolean},data(){const t="mobile"===this.behavior||"desktop"!==this.behavior&&this.layout.totalWidth<=this.breakpoint;return{belowBreakpoint:t,showing:!0===this.showIfAbove&&!1===t||!0===this.value}},watch:{belowBreakpoint(t){!0===t?(this.lastDesktopState=this.showing,!0===this.showing&&this.hide(!1)):!1===this.overlay&&"mobile"!==this.behavior&&!1!==this.lastDesktopState&&(!0===this.showing?(this.__applyPosition(0),this.__applyBackdrop(0),this.__cleanup()):this.show(!1))},"layout.totalWidth"(t){this.__updateLocal("belowBreakpoint","mobile"===this.behavior||"desktop"!==this.behavior&&t<=this.breakpoint)},side(t,e){this.layout.instances[e]===this&&(this.layout.instances[e]=void 0,this.layout[e].space=!1,this.layout[e].offset=0),this.layout.instances[t]=this,this.layout[t].size=this.size,this.layout[t].space=this.onLayout,this.layout[t].offset=this.offset},behavior(t){this.__updateLocal("belowBreakpoint","mobile"===t||"desktop"!==t&&this.layout.totalWidth<=this.breakpoint)},breakpoint(t){this.__updateLocal("belowBreakpoint","mobile"===this.behavior||"desktop"!==this.behavior&&this.layout.totalWidth<=t)},"layout.container"(t){!0===this.showing&&this.__preventScroll(!0!==t)},"layout.scrollbarWidth"(){this.__applyPosition(!0===this.showing?0:void 0)},offset(t){this.__update("offset",t)},onLayout(t){this.$emit("on-layout",t),this.__update("space",t)},rightSide(){this.__applyPosition()},size(t){this.__applyPosition(),this.__updateSizeOnLayout(this.miniToOverlay,t)},miniToOverlay(t){this.__updateSizeOnLayout(t,this.size)},"$q.lang.rtl"(){this.__applyPosition()},mini(){!0===this.value&&(this.__animateMini(),this.layout.__animate())},isMini(t){this.$emit("mini-state",t)}},computed:{rightSide(){return"right"===this.side},otherSide(){return!0===this.rightSide?"left":"right"},offset(){return!0===this.showing&&!1===this.belowBreakpoint&&!1===this.overlay?!0===this.miniToOverlay?this.miniWidth:this.size:0},size(){return!0===this.isMini?this.miniWidth:this.width},fixed(){return!0===this.overlay||!0===this.miniToOverlay||this.layout.view.indexOf(this.rightSide?"R":"L")>-1||this.$q.platform.is.ios&&!0===this.layout.container},onLayout(){return!0===this.showing&&!1===this.belowBreakpoint&&!1===this.overlay},onScreenOverlay(){return!0===this.showing&&!1===this.belowBreakpoint&&!0===this.overlay},backdropClass(){return!1===this.showing?"hidden":null},headerSlot(){return!0===this.rightSide?"r"===this.layout.rows.top[2]:"l"===this.layout.rows.top[0]},footerSlot(){return!0===this.rightSide?"r"===this.layout.rows.bottom[2]:"l"===this.layout.rows.bottom[0]},aboveStyle(){const t={};return!0===this.layout.header.space&&!1===this.headerSlot&&(!0===this.fixed?t.top=`${this.layout.header.offset}px`:!0===this.layout.header.space&&(t.top=`${this.layout.header.size}px`)),!0===this.layout.footer.space&&!1===this.footerSlot&&(!0===this.fixed?t.bottom=`${this.layout.footer.offset}px`:!0===this.layout.footer.space&&(t.bottom=`${this.layout.footer.size}px`)),t},style(){const t={width:`${this.size}px`};return!0===this.belowBreakpoint?t:Object.assign(t,this.aboveStyle)},classes(){return`q-drawer--${this.side}`+(!0===this.bordered?" q-drawer--bordered":"")+(!0===this.isDark?" q-drawer--dark q-dark":"")+(!0!==this.showing?" q-layout--prevent-focus":"")+(!0===this.belowBreakpoint?" fixed q-drawer--on-top q-drawer--mobile q-drawer--top-padding":` q-drawer--${!0===this.isMini?"mini":"standard"}`+(!0===this.fixed||!0!==this.onLayout?" fixed":"")+(!0===this.overlay||!0===this.miniToOverlay?" q-drawer--on-top":"")+(!0===this.headerSlot?" q-drawer--top-padding":""))},stateDirection(){return(!0===this.$q.lang.rtl?-1:1)*(!0===this.rightSide?1:-1)},isMini(){return!0===this.mini&&!0!==this.belowBreakpoint},onNativeEvents(){if(!0!==this.belowBreakpoint){const t={"!click":t=>{this.$emit("click",t)}};return mouseEvents.forEach(e=>{t[e]=(t=>{void 0!==this.qListeners[e]&&this.$emit(e,t)})}),t}},hideOnRouteChange(){return!0!==this.persistent&&(!0===this.belowBreakpoint||!0===this.onScreenOverlay)},openDirective(){const t=!0===this.$q.lang.rtl?this.side:this.otherSide;return[{name:"touch-pan",value:this.__openByTouch,modifiers:{[t]:!0,mouse:!0}}]},contentCloseDirective(){if(!0!==this.noSwipeClose){const t=!0===this.$q.lang.rtl?this.otherSide:this.side;return[{name:"touch-pan",value:this.__closeByTouch,modifiers:{[t]:!0,mouse:!0}}]}},backdropCloseDirective(){if(!0!==this.noSwipeBackdrop){const t=!0===this.$q.lang.rtl?this.otherSide:this.side;return[{name:"touch-pan",value:this.__closeByTouch,modifiers:{[t]:!0,mouse:!0,mouseAllDir:!0}}]}}},methods:{__applyPosition(t){void 0===t?this.$nextTick(()=>{t=!0===this.showing?0:this.size,this.__applyPosition(this.stateDirection*t)}):void 0!==this.$refs.content&&(!0!==this.layout.container||!0!==this.rightSide||!0!==this.belowBreakpoint&&Math.abs(t)!==this.size||(t+=this.stateDirection*this.layout.scrollbarWidth),this.__lastPosition!==t&&(this.$refs.content.style.transform=`translateX(${t}px)`,this.__lastPosition=t))},__applyBackdrop(t,e){void 0!==this.$refs.backdrop?this.$refs.backdrop.style.backgroundColor=this.lastBackdropBg=`rgba(0,0,0,${.4*t})`:!0!==e&&this.$nextTick(()=>{this.__applyBackdrop(t,!0)})},__setBackdropVisible(t){void 0!==this.$refs.backdrop&&this.$refs.backdrop.classList[!0===t?"remove":"add"]("hidden")},__setScrollable(t){const e=!0===t?"remove":!0!==this.layout.container?"add":"";""!==e&&document.body.classList[e]("q-body--drawer-toggle")},__animateMini(){void 0!==this.timerMini?clearTimeout(this.timerMini):void 0!==this.$el&&this.$el.classList.add("q-drawer--mini-animate"),this.timerMini=setTimeout(()=>{void 0!==this.$el&&this.$el.classList.remove("q-drawer--mini-animate"),this.timerMini=void 0},150)},__openByTouch(t){if(!1!==this.showing)return;const e=this.size,i=between(t.distance.x,0,e);if(!0===t.isFinal){const t=this.$refs.content,s=i>=Math.min(75,e);return t.classList.remove("no-transition"),void(!0===s?this.show():(this.layout.__animate(),this.__applyBackdrop(0),this.__applyPosition(this.stateDirection*e),t.classList.remove("q-drawer--delimiter"),t.classList.add("q-layout--prevent-focus"),this.__setBackdropVisible(!1)))}if(this.__applyPosition((!0===this.$q.lang.rtl?!0!==this.rightSide:this.rightSide)?Math.max(e-i,0):Math.min(0,i-e)),this.__applyBackdrop(between(i/e,0,1)),!0===t.isFirst){const t=this.$refs.content;t.classList.add("no-transition"),t.classList.add("q-drawer--delimiter"),t.classList.remove("q-layout--prevent-focus"),this.__setBackdropVisible(!0)}},__closeByTouch(t){if(!0!==this.showing)return;const e=this.size,i=t.direction===this.side,s=(!0===this.$q.lang.rtl?!0!==i:i)?between(t.distance.x,0,e):0;if(!0===t.isFinal){const t=Math.abs(s)<Math.min(75,e);return this.$refs.content.classList.remove("no-transition"),void(!0===t?(this.layout.__animate(),this.__applyBackdrop(1),this.__applyPosition(0)):this.hide())}this.__applyPosition(this.stateDirection*s),this.__applyBackdrop(between(1-s/e,0,1)),!0===t.isFirst&&this.$refs.content.classList.add("no-transition")},__show(t,e){if(this.__addHistory(),this.__setBackdropVisible(!0),!1!==t&&this.layout.__animate(),this.__applyPosition(0),!0===this.belowBreakpoint){const t=this.layout.instances[this.otherSide];void 0!==t&&!0===t.belowBreakpoint&&t.hide(!1),this.__applyBackdrop(1),!0!==this.layout.container&&this.__preventScroll(!0)}else this.__applyBackdrop(0),!1!==t&&this.__setScrollable(!1);this.__setTimeout(()=>{!1!==t&&this.__setScrollable(!0),!0!==e&&this.$emit("show",t)},150)},__hide(t,e){this.__removeHistory(),!1!==t&&this.layout.__animate(),this.__applyBackdrop(0),this.__applyPosition(this.stateDirection*this.size),this.__setBackdropVisible(!1),this.__cleanup(),!0!==e&&this.__setTimeout(()=>{this.$emit("hide",t)},150)},__cleanup(){this.__preventScroll(!1),this.__setScrollable(!0)},__update(t,e){this.layout[this.side][t]!==e&&(this.layout[this.side][t]=e)},__updateLocal(t,e){this[t]!==e&&(this[t]=e)},__updateSizeOnLayout(t,e){this.__update("size",!0===t?this.miniWidth:e)}},created(){this.layout.instances[this.side]=this,this.__updateSizeOnLayout(this.miniToOverlay,this.size),this.__update("space",this.onLayout),this.__update("offset",this.offset),!0===this.showIfAbove&&!0!==this.value&&!0===this.showing&&void 0!==this.qListeners.input&&this.$emit("input",!0)},mounted(){this.$emit("on-layout",this.onLayout),this.$emit("mini-state",this.isMini),this.lastDesktopState=!0===this.showIfAbove;const t=()=>{this[`__${!0===this.showing?"show":"hide"}`](!1,!0)};0===this.layout.totalWidth?this.watcher=this.$watch("layout.totalWidth",()=>{this.watcher(),this.watcher=void 0,!1===this.showing&&!0===this.showIfAbove&&!1===this.belowBreakpoint?this.show(!1):t()}):this.$nextTick(t)},beforeDestroy(){void 0!==this.watcher&&this.watcher(),clearTimeout(this.timerMini),!0===this.showing&&this.__cleanup(),this.layout.instances[this.side]===this&&(this.layout.instances[this.side]=void 0,this.__update("size",0),this.__update("offset",0),this.__update("space",!1))},render(t){const e=[];!0===this.belowBreakpoint&&(!0!==this.noSwipeOpen&&e.push(t("div",{staticClass:`q-drawer__opener fixed-${this.side}`,attrs:ariaHidden,directives:this.openDirective})),e.push(t("div",{ref:"backdrop",staticClass:"fullscreen q-drawer__backdrop",class:this.backdropClass,attrs:ariaHidden,style:void 0!==this.lastBackdropBg?{backgroundColor:this.lastBackdropBg}:null,on:cache(this,"bkdrop",{click:this.hide}),directives:!1===this.showing?void 0:this.backdropCloseDirective})));const i=[t("div",{staticClass:"q-drawer__content fit "+(!0===this.layout.container?"overflow-auto":"scroll"),class:this.contentClass,style:this.contentStyle},!0===this.isMini&&void 0!==this.$scopedSlots.mini?this.$scopedSlots.mini():slot(this,"default"))];return!0===this.elevated&&!0===this.showing&&i.push(t("div",{staticClass:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),e.push(t("aside",{ref:"content",staticClass:"q-drawer",class:this.classes,style:this.style,on:this.onNativeEvents,directives:!0===this.belowBreakpoint?this.contentCloseDirective:void 0},i)),t("div",{staticClass:"q-drawer-container"},e)}});const lazyRulesValues=[!0,!1,"ondemand"];var ValidateMixin={props:{value:{},error:{type:Boolean,default:null},errorMessage:String,noErrorIcon:Boolean,rules:Array,reactiveRules:Boolean,lazyRules:{type:[Boolean,String],validator:t=>lazyRulesValues.includes(t)}},data:()=>({isDirty:null,innerError:!1,innerErrorMessage:void 0}),watch:{value(){this.__validateIfNeeded()},reactiveRules:{handler(t){!0===t?void 0===this.unwatchRules&&(this.unwatchRules=this.$watch("rules",()=>{this.__validateIfNeeded(!0)})):void 0!==this.unwatchRules&&(this.unwatchRules(),this.unwatchRules=void 0)},immediate:!0},focused(t){"ondemand"!==this.lazyRules&&(!0===t?null===this.isDirty&&(this.isDirty=!1):!1===this.isDirty&&!0===this.hasRules&&(this.isDirty=!0,this.validate()))}},computed:{hasRules(){return void 0!==this.rules&&null!==this.rules&&this.rules.length>0},hasError(){return!0===this.error||!0===this.innerError},computedErrorMessage(){return"string"==typeof this.errorMessage&&this.errorMessage.length>0?this.errorMessage:this.innerErrorMessage}},mounted(){this.validateIndex=0},beforeDestroy(){void 0!==this.unwatchRules&&this.unwatchRules()},methods:{resetValidation(){this.validateIndex++,this.innerLoading=!1,this.isDirty=null,this.innerError=!1,this.innerErrorMessage=void 0},validate(t=this.value){if(!0!==this.hasRules)return!0;this.validateIndex++,!0!==this.innerLoading&&!0!==this.lazyRules&&(this.isDirty=!0);const e=(t,e)=>{this.innerError!==t&&(this.innerError=t);const i=e||void 0;this.innerErrorMessage!==i&&(this.innerErrorMessage=i),!1!==this.innerLoading&&(this.innerLoading=!1)},i=[];for(let s=0;s<this.rules.length;s++){const o=this.rules[s];let n;if("function"==typeof o?n=o(t):"string"==typeof o&&void 0!==testPattern[o]&&(n=testPattern[o](t)),!1===n||"string"==typeof n)return e(!0,n),!1;!0!==n&&void 0!==n&&i.push(n)}if(0===i.length)return e(!1),!0;!0!==this.innerLoading&&(this.innerLoading=!0);const s=this.validateIndex;return Promise.all(i).then(t=>{if(s!==this.validateIndex)return!0;if(void 0===t||!1===Array.isArray(t)||0===t.length)return e(!1),!0;const i=t.find(t=>!1===t||"string"==typeof t);return e(void 0!==i,i),void 0===i},t=>s!==this.validateIndex||(console.error(t),e(!0),!1))},__validateIfNeeded(t){!0===this.hasRules&&"ondemand"!==this.lazyRules&&(!0===this.isDirty||!0!==this.lazyRules&&!0!==t)&&this.validate()}}};let buf,bufIdx=0;const hexBytes=new Array(256);for(let t=0;t<256;t++)hexBytes[t]=(t+256).toString(16).substr(1);const randomBytes=(()=>{const t="undefined"!=typeof crypto?crypto:"undefined"!=typeof window?window.msCrypto:void 0;if(void 0!==t){if(void 0!==t.randomBytes)return t.randomBytes;if(void 0!==t.getRandomValues)return e=>{var i=new Uint8Array(e);return t.getRandomValues(i),i}}return t=>{const e=[];for(let i=t;i>0;i--)e.push(Math.floor(256*Math.random()));return e}})(),BUFFER_SIZE=4096;function uid$2(){(void 0===buf||bufIdx+16>BUFFER_SIZE)&&(bufIdx=0,buf=randomBytes(BUFFER_SIZE));const t=Array.prototype.slice.call(buf,bufIdx,bufIdx+=16);return t[6]=15&t[6]|64,t[8]=63&t[8]|128,hexBytes[t[0]]+hexBytes[t[1]]+hexBytes[t[2]]+hexBytes[t[3]]+"-"+hexBytes[t[4]]+hexBytes[t[5]]+"-"+hexBytes[t[6]]+hexBytes[t[7]]+"-"+hexBytes[t[8]]+hexBytes[t[9]]+"-"+hexBytes[t[10]]+hexBytes[t[11]]+hexBytes[t[12]]+hexBytes[t[13]]+hexBytes[t[14]]+hexBytes[t[15]]}function getTargetUid(t){return void 0===t?`f_${uid$2()}`:t}var QField=Vue.extend({name:"QField",mixins:[DarkMixin,ValidateMixin,AttrsMixin],inheritAttrs:!1,props:{label:String,stackLabel:Boolean,hint:String,hideHint:Boolean,prefix:String,suffix:String,labelColor:String,color:String,bgColor:String,filled:Boolean,outlined:Boolean,borderless:Boolean,standout:[Boolean,String],square:Boolean,loading:Boolean,labelSlot:Boolean,bottomSlots:Boolean,hideBottomSpace:Boolean,rounded:Boolean,dense:Boolean,itemAligned:Boolean,counter:Boolean,clearable:Boolean,clearIcon:String,disable:Boolean,readonly:Boolean,autofocus:Boolean,for:String,maxlength:[Number,String],maxValues:[Number,String]},data(){return{focused:!1,targetUid:getTargetUid(this.for),innerLoading:!1}},watch:{for(t){this.targetUid=getTargetUid(t)}},computed:{editable(){return!0!==this.disable&&!0!==this.readonly},hasValue(){const t=void 0===this.__getControl?this.value:this.innerValue;return void 0!==t&&null!==t&&(""+t).length>0},computedCounter(){if(!1!==this.counter){const t="string"==typeof this.value||"number"==typeof this.value?(""+this.value).length:!0===Array.isArray(this.value)?this.value.length:0,e=void 0!==this.maxlength?this.maxlength:this.maxValues;return t+(void 0!==e?" / "+e:"")}},floatingLabel(){return!0===this.stackLabel||!0===this.focused||(void 0!==this.inputValue&&!0===this.hideSelected?this.inputValue.length>0:!0===this.hasValue)||void 0!==this.displayValue&&null!==this.displayValue&&(""+this.displayValue).length>0},shouldRenderBottom(){return!0===this.bottomSlots||void 0!==this.hint||!0===this.hasRules||!0===this.counter||null!==this.error},classes(){return{[this.fieldClass]:void 0!==this.fieldClass,[`q-field--${this.styleType}`]:!0,"q-field--rounded":this.rounded,"q-field--square":this.square,"q-field--focused":!0===this.focused||!0===this.hasError,"q-field--float":this.floatingLabel,"q-field--labeled":this.hasLabel,"q-field--dense":this.dense,"q-field--item-aligned q-item-type":this.itemAligned,"q-field--dark":this.isDark,"q-field--auto-height":void 0===this.__getControl,"q-field--with-bottom":!0!==this.hideBottomSpace&&!0===this.shouldRenderBottom,"q-field--error":this.hasError,"q-field--readonly":!0===this.readonly&&!0!==this.disable,"q-field--disabled":this.disable}},styleType(){return!0===this.filled?"filled":!0===this.outlined?"outlined":!0===this.borderless?"borderless":this.standout?"standout":"standard"},contentClass(){const t=[];if(!0===this.hasError)t.push("text-negative");else{if("string"==typeof this.standout&&this.standout.length>0&&!0===this.focused)return this.standout;void 0!==this.color&&t.push("text-"+this.color)}return void 0!==this.bgColor&&t.push(`bg-${this.bgColor}`),t},hasLabel(){return!0===this.labelSlot||void 0!==this.label},labelClass(){if(void 0!==this.labelColor&&!0!==this.hasError)return"text-"+this.labelColor},controlSlotScope(){return{id:this.targetUid,field:this.$el,editable:this.editable,focused:this.focused,floatingLabel:this.floatingLabel,value:this.value,emitValue:this.__emitValue}},attrs(){const t={for:this.targetUid};return!0===this.disable?t["aria-disabled"]="":!0===this.readonly&&(t["aria-readonly"]=""),t}},methods:{focus(){void 0===this.showPopup||!0!==this.hasDialog?this.__focus():this.showPopup()},blur(){const t=document.activeElement;null!==t&&this.$el.contains(t)&&t.blur()},__focus(){const t=document.activeElement;let e=this.$refs.target;void 0===e||null!==t&&t.id===this.targetUid||(!0===e.hasAttribute("tabindex")||(e=e.querySelector("[tabindex]")),null!==e&&e!==t&&e.focus())},__getContent(t){const e=[];return void 0!==this.$scopedSlots.prepend&&e.push(t("div",{staticClass:"q-field__prepend q-field__marginal row no-wrap items-center",key:"prepend",on:this.slotsEvents},this.$scopedSlots.prepend())),e.push(t("div",{staticClass:"q-field__control-container col relative-position row no-wrap q-anchor--skip"},this.__getControlContainer(t))),void 0!==this.$scopedSlots.append&&e.push(t("div",{staticClass:"q-field__append q-field__marginal row no-wrap items-center",key:"append",on:this.slotsEvents},this.$scopedSlots.append())),!0===this.hasError&&!1===this.noErrorIcon&&e.push(this.__getInnerAppendNode(t,"error",[t(QIcon,{props:{name:this.$q.iconSet.field.error,color:"negative"}})])),!0===this.loading||!0===this.innerLoading?e.push(this.__getInnerAppendNode(t,"inner-loading-append",void 0!==this.$scopedSlots.loading?this.$scopedSlots.loading():[t(QSpinner,{props:{color:this.color}})])):!0===this.clearable&&!0===this.hasValue&&!0===this.editable&&e.push(this.__getInnerAppendNode(t,"inner-clearable-append",[t(QIcon,{staticClass:"q-field__focusable-action",props:{tag:"button",name:this.clearIcon||this.$q.iconSet.field.clear},attrs:{tabindex:0,type:"button"},on:this.clearableEvents})])),void 0!==this.__getInnerAppend&&e.push(this.__getInnerAppendNode(t,"inner-append",this.__getInnerAppend(t))),void 0!==this.__getControlChild&&e.push(this.__getControlChild(t)),e},__getControlContainer(t){const e=[];return void 0!==this.prefix&&null!==this.prefix&&e.push(t("div",{staticClass:"q-field__prefix no-pointer-events row items-center"},[this.prefix])),!0===this.hasShadow&&void 0!==this.__getShadowControl&&e.push(this.__getShadowControl(t)),void 0!==this.__getControl?e.push(this.__getControl(t)):void 0!==this.$scopedSlots.rawControl?e.push(this.$scopedSlots.rawControl()):void 0!==this.$scopedSlots.control&&e.push(t("div",{ref:"target",staticClass:"q-field__native row",attrs:{...this.qAttrs,"data-autofocus":this.autofocus}},this.$scopedSlots.control(this.controlSlotScope))),this.hasLabel&&e.push(t("div",{staticClass:"q-field__label no-pointer-events absolute ellipsis",class:this.labelClass},[slot(this,"label",this.label)])),void 0!==this.suffix&&null!==this.suffix&&e.push(t("div",{staticClass:"q-field__suffix no-pointer-events row items-center"},[this.suffix])),e.concat(void 0!==this.__getDefaultSlot?this.__getDefaultSlot(t):slot(this,"default"))},__getBottom(t){let e,i;!0===this.hasError?void 0!==this.computedErrorMessage?(e=[t("div",[this.computedErrorMessage])],i=this.computedErrorMessage):(e=slot(this,"error"),i="q--slot-error"):!0===this.hideHint&&!0!==this.focused||(void 0!==this.hint?(e=[t("div",[this.hint])],i=this.hint):(e=slot(this,"hint"),i="q--slot-hint"));const s=!0===this.counter||void 0!==this.$scopedSlots.counter;if(!0===this.hideBottomSpace&&!1===s&&void 0===e)return;const o=t("div",{key:i,staticClass:"q-field__messages col"},e);return t("div",{staticClass:"q-field__bottom row items-start q-field__bottom--"+(!0!==this.hideBottomSpace?"animated":"stale")},[!0===this.hideBottomSpace?o:t("transition",{props:{name:"q-transition--field-message"}},[o]),!0===s?t("div",{staticClass:"q-field__counter"},void 0!==this.$scopedSlots.counter?this.$scopedSlots.counter():[this.computedCounter]):null])},__getInnerAppendNode:(t,e,i)=>null===i?null:t("div",{staticClass:"q-field__append q-field__marginal row no-wrap items-center q-anchor--skip",key:e},i),__onControlPopupShow(t){void 0!==t&&stop(t),this.$emit("popup-show",t),this.hasPopupOpen=!0,this.__onControlFocusin(t)},__onControlPopupHide(t){void 0!==t&&stop(t),this.$emit("popup-hide",t),this.hasPopupOpen=!1,this.__onControlFocusout(t)},__onControlFocusin(t){!0===this.editable&&!1===this.focused&&(this.focused=!0,this.$emit("focus",t))},__onControlFocusout(t,e){clearTimeout(this.focusoutTimer),this.focusoutTimer=setTimeout(()=>{(!0!==document.hasFocus()||!0!==this.hasPopupOpen&&void 0!==this.$refs&&void 0!==this.$refs.control&&!1===this.$refs.control.contains(document.activeElement))&&(!0===this.focused&&(this.focused=!1,this.$emit("blur",t)),void 0!==e&&e())})},__clearValue(t){stopAndPrevent(t),(this.$refs.target||this.$el).focus(),"file"===this.type&&(this.$refs.input.value=null),this.$emit("input",null),this.$emit("clear",this.value)},__emitValue(t){this.$emit("input",t)}},render(t){return void 0!==this.__onPreRender&&this.__onPreRender(),void 0!==this.__onPostRender&&this.$nextTick(this.__onPostRender),t("label",{staticClass:"q-field q-validation-component row no-wrap items-start",class:this.classes,attrs:this.attrs},[void 0!==this.$scopedSlots.before?t("div",{staticClass:"q-field__before q-field__marginal row no-wrap items-center",on:this.slotsEvents},this.$scopedSlots.before()):null,t("div",{staticClass:"q-field__inner relative-position col self-stretch column justify-center"},[t("div",{ref:"control",staticClass:"q-field__control relative-position row no-wrap",class:this.contentClass,attrs:{tabindex:-1},on:this.controlEvents},this.__getContent(t)),!0===this.shouldRenderBottom?this.__getBottom(t):null]),void 0!==this.$scopedSlots.after?t("div",{staticClass:"q-field__after q-field__marginal row no-wrap items-center",on:this.slotsEvents},this.$scopedSlots.after()):null])},created(){void 0!==this.__onPreRender&&this.__onPreRender(),this.slotsEvents={click:prevent},this.clearableEvents={click:this.__clearValue},this.controlEvents=void 0!==this.__getControlEvents?this.__getControlEvents():{focusin:this.__onControlFocusin,focusout:this.__onControlFocusout,"popup-show":this.__onControlPopupShow,"popup-hide":this.__onControlPopupHide}},mounted(){!0===fromSSR&&void 0===this.for&&(this.targetUid=getTargetUid()),!0===this.autofocus&&this.focus()},beforeDestroy(){clearTimeout(this.focusoutTimer)}});function filterFiles(t,e,i,s){const o=[];return t.forEach(t=>{!0===s(t)?o.push(t):e.push({failedPropValidation:i,file:t})}),o}var FileMixin={props:{multiple:Boolean,accept:String,capture:String,maxFileSize:[Number,String],maxTotalSize:[Number,String],maxFiles:[Number,String],filter:Function},computed:{extensions(){if(void 0!==this.accept)return this.accept.split(",").map(t=>"*"===(t=t.trim())?"*/":(t.endsWith("/*")&&(t=t.slice(0,t.length-1)),t.toUpperCase()))},maxFilesNumber(){return parseInt(this.maxFiles,10)},maxTotalSizeNumber(){return parseInt(this.maxTotalSize,10)}},methods:{pickFiles(t){if(this.editable){const e=this.__getFileInput();e&&e.click(t)}},addFiles(t){this.editable&&t&&this.__addFiles(null,t)},__processFiles(t,e,i,s){let o=Array.from(e||t.target.files);const n=[],r=()=>{n.length>0&&this.$emit("rejected",n)};if(void 0!==this.accept&&-1===this.extensions.indexOf("*/")&&0===(o=filterFiles(o,n,"accept",t=>this.extensions.some(e=>t.type.toUpperCase().startsWith(e)||t.name.toUpperCase().endsWith(e)))).length)return r();if(void 0!==this.maxFileSize){const t=parseInt(this.maxFileSize,10);if(0===(o=filterFiles(o,n,"max-file-size",e=>e.size<=t)).length)return r()}if(!0!==this.multiple&&(o=[o[0]]),void 0!==this.maxTotalSize){let t=!0===s?i.reduce((t,e)=>t+e.size,0):0;if(0===(o=filterFiles(o,n,"max-total-size",e=>(t+=e.size)<=this.maxTotalSizeNumber)).length)return r()}if("function"==typeof this.filter){const t=this.filter(o);o=filterFiles(o,n,"filter",e=>t.includes(e))}if(void 0!==this.maxFiles){let t=!0===s?i.length:0;if(0===(o=filterFiles(o,n,"max-files",()=>++t<=this.maxFilesNumber)).length)return r()}return r(),o.length>0?o:void 0},__onDragOver(t){stopAndPrevent(t),this.dnd=!0},__onDragLeave(t){stopAndPrevent(t),this.dnd=!1},__onDrop(t){stopAndPrevent(t);const e=t.dataTransfer.files;e.length>0&&this.__addFiles(null,e),this.dnd=!1},__getDnd(t,e){if(!0===this.dnd)return t("div",{staticClass:`q-${e}__dnd absolute-full`,on:cache(this,"dnd",{dragenter:stopAndPrevent,dragover:stopAndPrevent,dragleave:this.__onDragLeave,drop:this.__onDrop})})}}};const FileValueMixin={computed:{formDomProps(){if("file"===this.type)try{const t="DataTransfer"in window?new DataTransfer:"ClipboardEvent"in window?new ClipboardEvent("").clipboardData:void 0;return Object(this.value)===this.value&&("length"in this.value?Array.from(this.value):[this.value]).forEach(e=>{t.items.add(e)}),{files:t.files}}catch(t){return{files:void 0}}}}},NAMED_MASKS={date:"####/##/##",datetime:"####/##/## ##:##",time:"##:##",fulltime:"##:##:##",phone:"(###) ### - ####",card:"#### #### #### ####"},TOKENS={"#":{pattern:"[\\d]",negate:"[^\\d]"},S:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]"},N:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]"},A:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:t=>t.toLocaleUpperCase()},a:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:t=>t.toLocaleLowerCase()},X:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:t=>t.toLocaleUpperCase()},x:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:t=>t.toLocaleLowerCase()}},KEYS=Object.keys(TOKENS);KEYS.forEach(t=>{TOKENS[t].regex=new RegExp(TOKENS[t].pattern)});const tokenRegexMask=new RegExp("\\\\([^.*+?^${}()|([\\]])|([.*+?^${}()|[\\]])|(["+KEYS.join("")+"])|(.)","g"),escRegex=/[.*+?^${}()|[\]\\]/g,MARKER=String.fromCharCode(1);var MaskMixin={props:{mask:String,reverseFillMask:Boolean,fillMask:[Boolean,String],unmaskedValue:Boolean},watch:{type(){this.__updateMaskInternals()},mask(t){if(void 0!==t)this.__updateMaskValue(this.innerValue,!0);else{const t=this.__unmask(this.innerValue);this.__updateMaskInternals(),this.value!==t&&this.$emit("input",t)}},fillMask(){!0===this.hasMask&&this.__updateMaskValue(this.innerValue,!0)},reverseFillMask(){!0===this.hasMask&&this.__updateMaskValue(this.innerValue,!0)},unmaskedValue(){!0===this.hasMask&&this.__updateMaskValue(this.innerValue)}},methods:{__getInitialMaskedValue(){if(this.__updateMaskInternals(),!0===this.hasMask){const t=this.__mask(this.__unmask(this.value));return!1!==this.fillMask?this.__fillWithMask(t):t}return this.value},__getPaddedMaskMarked(t){if(t<this.maskMarked.length)return this.maskMarked.slice(-t);let e=this.maskMarked,i="";const s=e.indexOf(MARKER);if(s>-1){for(let s=t-e.length;s>0;s--)i+=MARKER;e=e.slice(0,s)+i+e.slice(s)}return e},__updateMaskInternals(){if(this.hasMask=void 0!==this.mask&&this.mask.length>0&&["text","search","url","tel","password"].includes(this.type),!1===this.hasMask)return this.computedUnmask=void 0,this.maskMarked="",void(this.maskReplaced="");const t=void 0===NAMED_MASKS[this.mask]?this.mask:NAMED_MASKS[this.mask],e="string"==typeof this.fillMask&&this.fillMask.length>0?this.fillMask.slice(0,1):"_",i=e.replace(escRegex,"\\$&"),s=[],o=[],n=[];let r=!0===this.reverseFillMask,a="",l="";t.replace(tokenRegexMask,(t,e,i,h,d)=>{if(void 0!==h){const t=TOKENS[h];n.push(t),l=t.negate,!0===r&&(o.push("(?:"+l+"+)?("+t.pattern+"+)?(?:"+l+"+)?("+t.pattern+"+)?"),r=!1),o.push("(?:"+l+"+)?("+t.pattern+")?")}else if(void 0!==i)a="\\"+("\\"===i?"":i),n.push(i),s.push("([^"+a+"]+)?"+a+"?");else{const t=void 0!==e?e:d;a="\\"===t?"\\\\\\\\":t.replace(escRegex,"\\\\$&"),n.push(t),s.push("([^"+a+"]+)?"+a+"?")}});const h=new RegExp("^"+s.join("")+"("+(""===a?".":"[^"+a+"]")+"+)?$"),d=o.length-1,c=o.map((t,e)=>0===e&&!0===this.reverseFillMask?new RegExp("^"+i+"*"+t):e===d?new RegExp("^"+t+"("+(""===l?".":l)+"+)?"+(!0===this.reverseFillMask?"$":i+"*")):new RegExp("^"+t));this.computedMask=n,this.computedUnmask=(t=>{const e=h.exec(t);null!==e&&(t=e.slice(1).join(""));const i=[],s=c.length;for(let e=0,o=t;e<s;e++){const t=c[e].exec(o);if(null===t)break;o=o.slice(t.shift().length),i.push(...t)}return i.length>0?i.join(""):t}),this.maskMarked=n.map(t=>"string"==typeof t?t:MARKER).join(""),this.maskReplaced=this.maskMarked.split(MARKER).join(e)},__updateMaskValue(t,e,i){const s=this.$refs.input,o=s.selectionEnd,n=s.value.length-o,r=this.__unmask(t);!0===e&&this.__updateMaskInternals();const a=this.__mask(r),l=!1!==this.fillMask?this.__fillWithMask(a):a,h=this.innerValue!==l;s.value!==l&&(s.value=l),!0===h&&(this.innerValue=l),document.activeElement===s&&this.$nextTick(()=>{if(l!==this.maskReplaced)if("insertFromPaste"!==i||!0===this.reverseFillMask)if(["deleteContentBackward","deleteContentForward"].indexOf(i)>-1){const t=!0===this.reverseFillMask?Math.max(0,l.length-(l===this.maskReplaced?0:Math.min(a.length,n)+1))+1:o;s.setSelectionRange(t,t,"forward")}else if(!0===this.reverseFillMask)if(!0===h){const t=Math.max(0,l.length-(l===this.maskReplaced?0:Math.min(a.length,n+1)));this.__moveCursorRightReverse(s,t,t)}else{const t=l.length-n;s.setSelectionRange(t,t,"backward")}else if(!0===h){const t=Math.max(0,this.maskMarked.indexOf(MARKER),Math.min(a.length,o)-1);this.__moveCursorRight(s,t,t)}else{const t=o-1;this.__moveCursorRight(s,t,t)}else{const t=o-1;this.__moveCursorRight(s,t,t)}else{const t=!0===this.reverseFillMask?this.maskReplaced.length:0;s.setSelectionRange(t,t,"forward")}});const d=!0===this.unmaskedValue?this.__unmask(l):l;this.value!==d&&this.__emitValue(d,!0)},__moveCursorForPaste(t,e,i){const s=this.__mask(this.__unmask(t.value));e=Math.max(0,this.maskMarked.indexOf(MARKER),Math.min(s.length,e)),t.setSelectionRange(e,i,"forward")},__moveCursorLeft(t,e,i,s){const o=-1===this.maskMarked.slice(e-1).indexOf(MARKER);let n=Math.max(0,e-1);for(;n>=0;n--)if(this.maskMarked[n]===MARKER){e=n,!0===o&&e++;break}if(n<0&&void 0!==this.maskMarked[e]&&this.maskMarked[e]!==MARKER)return this.__moveCursorRight(t,0,0);e>=0&&t.setSelectionRange(e,!0===s?i:e,"backward")},__moveCursorRight(t,e,i,s){const o=t.value.length;let n=Math.min(o,i+1);for(;n<=o;n++){if(this.maskMarked[n]===MARKER){i=n;break}this.maskMarked[n-1]===MARKER&&(i=n)}if(n>o&&void 0!==this.maskMarked[i-1]&&this.maskMarked[i-1]!==MARKER)return this.__moveCursorLeft(t,o,o);t.setSelectionRange(s?e:i,i,"forward")},__moveCursorLeftReverse(t,e,i,s){const o=this.__getPaddedMaskMarked(t.value.length);let n=Math.max(0,e-1);for(;n>=0;n--){if(o[n-1]===MARKER){e=n;break}if(o[n]===MARKER&&(e=n,0===n))break}if(n<0&&void 0!==o[e]&&o[e]!==MARKER)return this.__moveCursorRightReverse(t,0,0);e>=0&&t.setSelectionRange(e,!0===s?i:e,"backward")},__moveCursorRightReverse(t,e,i,s){const o=t.value.length,n=this.__getPaddedMaskMarked(o),r=-1===n.slice(0,i+1).indexOf(MARKER);let a=Math.min(o,i+1);for(;a<=o;a++)if(n[a-1]===MARKER){(i=a)>0&&!0===r&&i--;break}if(a>o&&void 0!==n[i-1]&&n[i-1]!==MARKER)return this.__moveCursorLeftReverse(t,o,o);t.setSelectionRange(!0===s?e:i,i,"forward")},__onMaskedKeydown(t){if(!0===shouldIgnoreKey(t))return;const e=this.$refs.input,i=e.selectionStart,s=e.selectionEnd;if(37===t.keyCode||39===t.keyCode){const o=this["__moveCursor"+(39===t.keyCode?"Right":"Left")+(!0===this.reverseFillMask?"Reverse":"")];t.preventDefault(),o(e,i,s,t.shiftKey)}else 8===t.keyCode&&!0!==this.reverseFillMask&&i===s?this.__moveCursorLeft(e,i,s,!0):46===t.keyCode&&!0===this.reverseFillMask&&i===s&&this.__moveCursorRightReverse(e,i,s,!0);this.$emit("keydown",t)},__mask(t){if(void 0===t||null===t||""===t)return"";if(!0===this.reverseFillMask)return this.__maskReverse(t);const e=this.computedMask;let i=0,s="";for(let o=0;o<e.length;o++){const n=t[i],r=e[o];if("string"==typeof r)s+=r,n===r&&i++;else{if(void 0===n||!r.regex.test(n))return s;s+=void 0!==r.transform?r.transform(n):n,i++}}return s},__maskReverse(t){const e=this.computedMask,i=this.maskMarked.indexOf(MARKER);let s=t.length-1,o="";for(let n=e.length-1;n>=0;n--){const r=e[n];let a=t[s];if("string"==typeof r)o=r+o,a===r&&s--;else{if(void 0===a||!r.regex.test(a))return o;do{o=(void 0!==r.transform?r.transform(a):a)+o,a=t[--s]}while(i===n&&void 0!==a&&r.regex.test(a))}}return o},__unmask(t){return"string"!=typeof t||void 0===this.computedUnmask?"number"==typeof t?this.computedUnmask(""+t):t:this.computedUnmask(t)},__fillWithMask(t){return this.maskReplaced.length-t.length<=0?t:!0===this.reverseFillMask&&t.length>0?this.maskReplaced.slice(0,-t.length)+t:t+this.maskReplaced.slice(t.length)}}};const isJapanese=/[\u3000-\u303f\u3040-\u309f\u30a0-\u30ff\uff00-\uff9f\u4e00-\u9faf\u3400-\u4dbf]/,isChinese=/[\u4e00-\u9fff\u3400-\u4dbf\u{20000}-\u{2a6df}\u{2a700}-\u{2b73f}\u{2b740}-\u{2b81f}\u{2b820}-\u{2ceaf}\uf900-\ufaff\u3300-\u33ff\ufe30-\ufe4f\uf900-\ufaff\u{2f800}-\u{2fa1f}]/u,isKorean=/[\u3131-\u314e\u314f-\u3163\uac00-\ud7a3]/;var CompositionMixin={methods:{__onComposition(t){if("compositionend"===t.type||"change"===t.type){if(!0!==t.target.composing)return;t.target.composing=!1,this.__onInput(t)}else"compositionupdate"===t.type?"string"==typeof t.data&&!1===isJapanese.test(t.data)&&!1===isChinese.test(t.data)&&!1===isKorean.test(t.data)&&(t.target.composing=!1):t.target.composing=!0}}},QInput=Vue.extend({name:"QInput",mixins:[QField,MaskMixin,CompositionMixin,FormFieldMixin,FileValueMixin,ListenersMixin],props:{value:{required:!1},shadowText:String,type:{type:String,default:"text"},debounce:[String,Number],autogrow:Boolean,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},watch:{value(t){if(!0===this.hasMask){if(!0===this.stopValueWatcher)return void(this.stopValueWatcher=!1);this.__updateMaskValue(t)}else this.innerValue!==t&&(this.innerValue=t,"number"===this.type&&!0===this.hasOwnProperty("tempValue")&&(!0===this.typedNumber?this.typedNumber=!1:delete this.tempValue));!0===this.autogrow&&this.$nextTick(this.__adjustHeight)},autogrow(t){if(!0===t)this.$nextTick(this.__adjustHeight);else if(this.qAttrs.rows>0&&void 0!==this.$refs.input){this.$refs.input.style.height="auto"}},dense(){!0===this.autogrow&&this.$nextTick(this.__adjustHeight)}},data(){return{innerValue:this.__getInitialMaskedValue()}},computed:{isTextarea(){return"textarea"===this.type||!0===this.autogrow},fieldClass(){return`q-${!0===this.isTextarea?"textarea":"input"}`+(!0===this.autogrow?" q-textarea--autogrow":"")},hasShadow(){return"file"!==this.type&&"string"==typeof this.shadowText&&this.shadowText.length>0},onEvents(){const t={...this.qListeners,input:this.__onInput,paste:this.__onPaste,change:this.__onChange,blur:this.__onFinishEditing,focus:stop};return t.compositionstart=t.compositionupdate=t.compositionend=this.__onComposition,!0===this.hasMask&&(t.keydown=this.__onMaskedKeydown),!0===this.autogrow&&(t.animationend=this.__adjustHeight),t},inputAttrs(){const t={tabindex:0,"data-autofocus":this.autofocus,rows:"textarea"===this.type?6:void 0,"aria-label":this.label,name:this.nameProp,...this.qAttrs,id:this.targetUid,type:this.type,maxlength:this.maxlength,disabled:!0===this.disable,readonly:!0===this.readonly};return!0===this.autogrow&&(t.rows=1),t}},methods:{focus(){const t=document.activeElement;void 0===this.$refs.input||this.$refs.input===t||null!==t&&t.id===this.targetUid||this.$refs.input.focus()},select(){void 0!==this.$refs.input&&this.$refs.input.select()},__onPaste(t){if(!0===this.hasMask&&!0!==this.reverseFillMask){const e=t.target;this.__moveCursorForPaste(e,e.selectionStart,e.selectionEnd)}this.$emit("paste",t)},__onInput(t){if(t&&t.target&&!0===t.target.composing)return;if("file"===this.type)return void this.$emit("input",t.target.files);const e=t.target.value;!0===this.hasMask?this.__updateMaskValue(e,!1,t.inputType):this.__emitValue(e),!0===this.autogrow&&this.__adjustHeight()},__emitValue(t,e){this.emitValueFn=(()=>{"number"!==this.type&&!0===this.hasOwnProperty("tempValue")&&delete this.tempValue,this.value!==t&&(!0===e&&(this.stopValueWatcher=!0),this.$emit("input",t)),this.emitValueFn=void 0}),"number"===this.type&&(this.typedNumber=!0,this.tempValue=t),void 0!==this.debounce?(clearTimeout(this.emitTimer),this.tempValue=t,this.emitTimer=setTimeout(this.emitValueFn,this.debounce)):this.emitValueFn()},__adjustHeight(){const t=this.$refs.input;if(void 0!==t){const e=t.parentNode.style;e.marginBottom=t.scrollHeight-1+"px",t.style.height="1px",t.style.height=t.scrollHeight+"px",e.marginBottom=""}},__onChange(t){this.__onComposition(t),clearTimeout(this.emitTimer),void 0!==this.emitValueFn&&this.emitValueFn(),this.$emit("change",t)},__onFinishEditing(t){void 0!==t&&stop(t),clearTimeout(this.emitTimer),void 0!==this.emitValueFn&&this.emitValueFn(),this.typedNumber=!1,this.stopValueWatcher=!1,delete this.tempValue,"file"!==this.type&&this.$nextTick(()=>{void 0!==this.$refs.input&&(this.$refs.input.value=void 0!==this.innerValue?this.innerValue:"")})},__getCurValue(){return!0===this.hasOwnProperty("tempValue")?this.tempValue:void 0!==this.innerValue?this.innerValue:""},__getShadowControl(t){return t("div",{staticClass:"q-field__native q-field__shadow absolute-full no-pointer-events"},[t("span",{staticClass:"invisible"},this.__getCurValue()),t("span",this.shadowText)])},__getControl(t){return t(!0===this.isTextarea?"textarea":"input",{ref:"input",staticClass:"q-field__native q-placeholder",style:this.inputStyle,class:this.inputClass,attrs:this.inputAttrs,on:this.onEvents,domProps:"file"!==this.type?{value:this.__getCurValue()}:this.formDomProps})}},mounted(){!0===this.autogrow&&this.__adjustHeight()},beforeDestroy(){this.__onFinishEditing()}}),QTooltip=Vue.extend({name:"QTooltip",mixins:[AnchorMixin,ModelToggleMixin,Portal,TransitionMixin],props:{maxHeight:{type:String,default:null},maxWidth:{type:String,default:null},transitionShow:{default:"jump-down"},transitionHide:{default:"jump-up"},anchor:{type:String,default:"bottom middle",validator:validatePosition},self:{type:String,default:"top middle",validator:validatePosition},offset:{type:Array,default:()=>[14,14],validator:validateOffset},scrollTarget:{default:void 0},delay:{type:Number,default:0},hideDelay:{type:Number,default:0}},computed:{anchorOrigin(){return parsePosition(this.anchor)},selfOrigin(){return parsePosition(this.self)},hideOnRouteChange(){return!0!==this.persistent}},methods:{__show(t){this.__showPortal(),this.__nextTick(()=>{this.observer=new MutationObserver(()=>this.updatePosition()),this.observer.observe(this.__portal.$el,{attributes:!1,childList:!0,characterData:!0,subtree:!0}),this.updatePosition(),this.__configureScrollTarget()}),this.__setTimeout(()=>{this.$emit("show",t)},300)},__hide(t){this.__anchorCleanup(),this.__setTimeout(()=>{this.__hidePortal(),this.$emit("hide",t)},300)},__anchorCleanup(){void 0!==this.observer&&(this.observer.disconnect(),this.observer=void 0),this.__unconfigureScrollTarget(),cleanEvt(this,"tooltipTemp")},updatePosition(){if(void 0===this.anchorEl||void 0===this.__portal)return;const t=this.__portal.$el;8!==t.nodeType?setPosition({el:t,offset:this.offset,anchorEl:this.anchorEl,anchorOrigin:this.anchorOrigin,selfOrigin:this.selfOrigin,maxHeight:this.maxHeight,maxWidth:this.maxWidth}):setTimeout(this.updatePosition,25)},__delayShow(t){if(!0===this.$q.platform.is.mobile){clearSelection(),document.body.classList.add("non-selectable");const t=getTouchTarget(this.anchorEl);addEvt(this,"tooltipTemp",["touchmove","touchcancel","touchend","click"].map(e=>[t,e,"__delayHide","passiveCapture"]))}this.__setTimeout(()=>{this.show(t)},this.delay)},__delayHide(t){this.__clearTimeout(),!0===this.$q.platform.is.mobile&&(cleanEvt(this,"tooltipTemp"),clearSelection(),setTimeout(()=>{document.body.classList.remove("non-selectable")},10)),this.__setTimeout(()=>{this.hide(t)},this.hideDelay)},__configureAnchorEl(){if(!0===this.noParentEvent||void 0===this.anchorEl)return;addEvt(this,"anchor",!0===this.$q.platform.is.mobile?[[this.anchorEl,"touchstart","__delayShow","passive"]]:[[this.anchorEl,"mouseenter","__delayShow","passive"],[this.anchorEl,"mouseleave","__delayHide","passive"]])},__unconfigureScrollTarget(){void 0!==this.__scrollTarget&&(this.__changeScrollEvent(this.__scrollTarget),this.__scrollTarget=void 0)},__configureScrollTarget(){if(void 0!==this.anchorEl||void 0!==this.scrollTarget){this.__scrollTarget=getScrollTarget(this.anchorEl,this.scrollTarget);const t=!0===this.noParentEvent?this.updatePosition:this.hide;this.__changeScrollEvent(this.__scrollTarget,t)}},__renderPortal(t){return t("transition",{props:{name:this.transition}},[!0===this.showing?t("div",{staticClass:"q-tooltip q-tooltip--style q-position-engine no-pointer-events",class:this.contentClass,style:this.contentStyle,attrs:{role:"complementary"}},slot(this,"default")):null])}},mounted(){this.__processModelChange(this.value)}}),QList=Vue.extend({name:"QList",mixins:[ListenersMixin,DarkMixin],props:{bordered:Boolean,dense:Boolean,separator:Boolean,padding:Boolean},computed:{classes(){return"q-list"+(!0===this.bordered?" q-list--bordered":"")+(!0===this.dense?" q-list--dense":"")+(!0===this.separator?" q-list--separator":"")+(!0===this.isDark?" q-list--dark":"")+(!0===this.padding?" q-list--padding":"")}},render(t){return t("div",{class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QItem=Vue.extend({name:"QItem",mixins:[DarkMixin,RouterLinkMixin,TagMixin,ListenersMixin],props:{active:Boolean,clickable:Boolean,dense:Boolean,insetLevel:Number,tabindex:[String,Number],focused:Boolean,manualFocus:Boolean},computed:{isActionable(){return!0===this.clickable||!0===this.hasRouterLink||"a"===this.tag||"label"===this.tag},isClickable(){return!0!==this.disable&&!0===this.isActionable},classes(){return{"q-item--clickable q-link cursor-pointer":this.isClickable,"q-focusable q-hoverable":!0===this.isClickable&&!1===this.manualFocus,"q-manual-focusable":!0===this.isClickable&&!0===this.manualFocus,"q-manual-focusable--focused":!0===this.isClickable&&!0===this.focused,"q-item--dense":this.dense,"q-item--dark":this.isDark,"q-item--active":this.active,[this.activeClass]:!0===this.active&&!0!==this.hasRouterLink&&void 0!==this.activeClass,disabled:this.disable}},style(){if(void 0!==this.insetLevel){return{["padding"+(!0===this.$q.lang.rtl?"Right":"Left")]:16+56*this.insetLevel+"px"}}},onEvents(){return{...this.qListeners,click:this.__onClick,keyup:this.__onKeyup}}},methods:{__getContent(t){const e=uniqueSlot(this,"default",[]);return!0===this.isClickable&&e.unshift(t("div",{staticClass:"q-focus-helper",attrs:{tabindex:-1},ref:"blurTarget"})),e},__onClick(t){!0===this.isClickable&&(void 0!==this.$refs.blurTarget&&(!0!==t.qKeyEvent&&document.activeElement===this.$el?this.$refs.blurTarget.focus():document.activeElement===this.$refs.blurTarget&&this.$el.focus()),this.$emit("click",t))},__onKeyup(t){if(!0===this.isClickable&&!0===isKeyCode(t,13)){stopAndPrevent(t),t.qKeyEvent=!0;const e=new MouseEvent("click",t);e.qKeyEvent=!0,this.$el.dispatchEvent(e)}this.$emit("keyup",t)}},render(t){const e={staticClass:"q-item q-item-type row no-wrap",class:this.classes,style:this.style,[!0===this.hasRouterLink?"nativeOn":"on"]:this.onEvents};return!0===this.isClickable?e.attrs={tabindex:this.tabindex||"0"}:!0===this.isActionable&&(e.attrs={"aria-disabled":""}),!0===this.hasRouterLink?(e.tag="a",e.props=this.routerLinkProps,t("router-link",e,this.__getContent(t))):t(this.tag,e,this.__getContent(t))}}),QItemSection=Vue.extend({name:"QItemSection",mixins:[ListenersMixin],props:{avatar:Boolean,thumbnail:Boolean,side:Boolean,top:Boolean,noWrap:Boolean},computed:{classes(){const t=this.avatar||this.side||this.thumbnail;return{"q-item__section--top":this.top,"q-item__section--avatar":this.avatar,"q-item__section--thumbnail":this.thumbnail,"q-item__section--side":t,"q-item__section--nowrap":this.noWrap,"q-item__section--main":!t,[`justify-${this.top?"start":"center"}`]:!0}}},render(t){return t("div",{staticClass:"q-item__section column",class:this.classes,on:{...this.qListeners}},slot(this,"default"))}});function run(t,e,i){e.handler?e.handler(t,i,i.caret):i.runCmd(e.cmd,e.param)}function __getGroup(t,e){return t("div",{staticClass:"q-editor__toolbar-group"},e)}function getBtn(t,e,i,s,o=!1){const n=o||"toggle"===i.type&&(i.toggled?i.toggled(e):i.cmd&&e.caret.is(i.cmd,i.param)),r=[],a={click(t){s&&s(),run(t,i,e)}};if(i.tip&&e.$q.platform.is.desktop){const e=i.key?t("div",[t("small",`(CTRL + ${String.fromCharCode(i.key)})`)]):null;r.push(t(QTooltip,{props:{delay:1e3}},[t("div",{domProps:{innerHTML:i.tip}}),e]))}return t(QBtn,{props:{...e.buttonProps,icon:i.icon,color:n?i.toggleColor||e.toolbarToggleColor:i.color||e.toolbarColor,textColor:n&&!e.toolbarPush?null:i.textColor||e.toolbarTextColor,label:i.label,disable:!!i.disable&&("function"!=typeof i.disable||i.disable(e)),size:"sm"},on:a},r)}function getDropdown(t,e,i){const s="only-icons"===i.list;let o,n,r=i.label,a=i.icon;function l(){d.componentInstance.hide()}if(s)n=i.options.map(i=>{const s=void 0===i.type&&e.caret.is(i.cmd,i.param);return s&&(r=i.tip,a=i.icon),getBtn(t,e,i,l,s)}),o=e.toolbarBackgroundClass,n=[__getGroup(t,n)];else{const s=void 0!==e.toolbarToggleColor?`text-${e.toolbarToggleColor}`:null,h=void 0!==e.toolbarTextColor?`text-${e.toolbarTextColor}`:null;n=i.options.map(i=>{const o=!!i.disable&&i.disable(e),n=void 0===i.type&&e.caret.is(i.cmd,i.param);n&&(r=i.tip,a=i.icon);const d=i.htmlTip;return t(QItem,{props:{active:n,activeClass:s,clickable:!0,disable:o,dense:!0},on:{click(t){l(),e.$refs.content&&e.$refs.content.focus(),e.caret.restore(),run(t,i,e)}}},["no-icons"===i.list?null:t(QItemSection,{class:n?s:h,props:{side:!0}},[t(QIcon,{props:{name:i.icon}})]),t(QItemSection,[d?t("div",{domProps:{innerHTML:i.htmlTip}}):i.tip?t("div",[i.tip]):null])])}),o=[e.toolbarBackgroundClass,h],n=[t(QList,[n])]}const h=i.highlight&&r!==i.label,d=t(QBtnDropdown,{props:{...e.buttonProps,noCaps:!0,noWrap:!0,color:h?e.toolbarToggleColor:e.toolbarColor,textColor:h&&!e.toolbarPush?null:e.toolbarTextColor,label:i.fixedLabel?i.label:r,icon:i.fixedIcon?i.icon:a,contentClass:o}},n);return d}function getToolbar(t,e){if(e.caret)return e.buttons.filter(t=>!e.isViewingSource||t.find(t=>"viewsource"===t.cmd)).map(i=>__getGroup(t,i.map(i=>(!e.isViewingSource||"viewsource"===i.cmd)&&("slot"===i.type?slot(e,i.slot):"dropdown"===i.type?getDropdown(t,e,i):getBtn(t,e,i)))))}function getFonts(t,e,i,s={}){const o=Object.keys(s);if(0===o.length)return{};const n={default_font:{cmd:"fontName",param:t,icon:i,tip:e}};return o.forEach(t=>{const e=s[t];n[t]={cmd:"fontName",param:e,icon:i,tip:e,htmlTip:`<font face="${e}">${e}</font>`}}),n}function getLinkEditor(t,e,i){if(e.caret){const s=e.toolbarColor||e.toolbarTextColor;let o=e.editLinkUrl;const n=()=>{e.caret.restore(),o!==e.editLinkUrl&&document.execCommand("createLink",!1,""===o?" ":o),e.editLinkUrl=null,!0===i&&e.$nextTick(e.__onInput)};return[t("div",{staticClass:"q-mx-xs",class:`text-${s}`},[`${e.$q.lang.editor.url}: `]),t(QInput,{key:"qedt_btm_input",staticClass:"q-ma-none q-pa-none col q-editor-input",props:{value:o,color:s,autofocus:!0,borderless:!0,dense:!0},on:{input:t=>{o=t},keydown:t=>{if(!0!==shouldIgnoreKey(t))switch(t.keyCode){case 13:return prevent(t),n();case 27:prevent(t),e.caret.restore(),e.editLinkUrl&&"https://"!==e.editLinkUrl||document.execCommand("unlink"),e.editLinkUrl=null}}}}),__getGroup(t,[t(QBtn,{key:"qedt_btm_rem",attrs:{tabindex:-1},props:{...e.buttonProps,label:e.$q.lang.label.remove,noCaps:!0},on:{click:()=>{e.caret.restore(),document.execCommand("unlink"),e.editLinkUrl=null,!0===i&&e.$nextTick(e.__onInput)}}}),t(QBtn,{key:"qedt_btm_upd",props:{...e.buttonProps,label:e.$q.lang.label.update,noCaps:!0},on:{click:n}})])]}}function getBlockElement(t,e){if(e&&t===e)return null;const i=t.nodeName.toLowerCase();if(!0===["div","li","ul","ol","blockquote"].includes(i))return t;const s=(window.getComputedStyle?window.getComputedStyle(t):t.currentStyle).display;return"block"===s||"table"===s?t:getBlockElement(t.parentNode)}function isChildOf(t,e){return!(!t||t===document.body)&&(e===document?document.body:e).contains(t.parentNode)}const urlRegex=/^https?:\/\//;class Caret{constructor(t,e){this.el=t,this.vm=e,this._range=null}get selection(){if(this.el){const t=document.getSelection();if(isChildOf(t.anchorNode,this.el)&&isChildOf(t.focusNode,this.el))return t}return null}get hasSelection(){return null!==this.selection&&this.selection.toString().length>0}get range(){const t=this.selection;return null!==t&&t.rangeCount?t.getRangeAt(0):this._range}get parent(){const t=this.range;if(null!==t){const e=t.startContainer;return e.nodeType===document.ELEMENT_NODE?e:e.parentNode}return null}get blockParent(){const t=this.parent;return null!==t?getBlockElement(t,this.el):null}save(t=this.range){null!==t&&(this._range=t)}restore(t=this._range){const e=document.createRange(),i=document.getSelection();null!==t?(e.setStart(t.startContainer,t.startOffset),e.setEnd(t.endContainer,t.endOffset),i.removeAllRanges(),i.addRange(e)):(i.selectAllChildren(this.el),i.collapseToEnd())}hasParent(t,e){const i=e?this.parent:this.blockParent;return null!==i&&i.nodeName.toLowerCase()===t.toLowerCase()}hasParents(t,e,i=this.parent){return null!==i&&(null!==i&&!0===t.includes(i.nodeName.toLowerCase())||!0===e&&this.hasParents(t,e,i.parentNode))}is(t,e){switch(t){case"formatBlock":return"DIV"===e&&this.parent===this.el||this.hasParent(e,"PRE"===e);case"link":return this.hasParent("A",!0);case"fontSize":return document.queryCommandValue(t)===e;case"fontName":const i=document.queryCommandValue(t);return i===`"${e}"`||i===e;case"fullscreen":return this.vm.inFullscreen;case"viewsource":return this.vm.isViewingSource;case void 0:return!1;default:const s=document.queryCommandState(t);return void 0!==e?s===e:s}}getParentAttribute(t){return null!==this.parent?this.parent.getAttribute(t):null}can(t){return"outdent"===t?this.hasParents(["blockquote","li"],!0):"indent"===t?this.hasParents(["li"],!0):"link"===t?null!==this.selection||this.is("link"):void 0}apply(t,e,i=noop){if("formatBlock"===t)["BLOCKQUOTE","H1","H2","H3","H4","H5","H6"].includes(e)&&this.is(t,e)&&(t="outdent",e=null),"PRE"===e&&this.is(t,"PRE")&&(e="P");else{if("print"===t){i();const t=window.open();return t.document.write(`\n        <!doctype html>\n        <html>\n          <head>\n            <title>Print - ${document.title}</title>\n          </head>\n          <body>\n            <div>${this.el.innerHTML}</div>\n          </body>\n        </html>\n      `),t.print(),void t.close()}if("link"===t){const t=this.getParentAttribute("href");if(null===t){const t=this.selectWord(this.selection),e=t?t.toString():"";if(!e.length)return;this.vm.editLinkUrl=urlRegex.test(e)?e:"https://",document.execCommand("createLink",!1,this.vm.editLinkUrl),this.save(t.getRangeAt(0))}else this.vm.editLinkUrl=t,this.range.selectNodeContents(this.parent),this.save();return}if("fullscreen"===t)return this.vm.toggleFullscreen(),void i();if("viewsource"===t)return this.vm.isViewingSource=!1===this.vm.isViewingSource,this.vm.__setContent(this.vm.value),void i()}document.execCommand(t,!1,e),i()}selectWord(t){if(null===t||!0!==t.isCollapsed||void 0===t.modify)return t;const e=document.createRange();e.setStart(t.anchorNode,t.anchorOffset),e.setEnd(t.focusNode,t.focusOffset);const i=e.collapsed?["backward","forward"]:["forward","backward"];e.detach();const s=t.focusNode,o=t.focusOffset;return t.collapse(t.anchorNode,t.anchorOffset),t.modify("move",i[0],"character"),t.modify("move",i[1],"word"),t.extend(s,o),t.modify("extend",i[1],"character"),t.modify("extend",i[0],"word"),t}}const toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,class2type={};function type(t){return null===t?String(t):class2type[toString.call(t)]||"object"}function isPlainObject(t){if(!t||"object"!==type(t))return!1;if(t.constructor&&!hasOwn.call(t,"constructor")&&!hasOwn.call(t.constructor.prototype,"isPrototypeOf"))return!1;let e;for(e in t);return void 0===e||hasOwn.call(t,e)}function extend(){let t,e,i,s,o,n,r=arguments[0]||{},a=1,l=!1;const h=arguments.length;for("boolean"==typeof r&&(l=r,r=arguments[1]||{},a=2),Object(r)!==r&&"function"!==type(r)&&(r={}),h===a&&(r=this,a--);a<h;a++)if(null!==(t=arguments[a]))for(e in t)i=r[e],r!==(s=t[e])&&(l&&s&&(isPlainObject(s)||(o="array"===type(s)))?(o?(o=!1,n=i&&"array"===type(i)?i:[]):n=i&&isPlainObject(i)?i:{},r[e]=extend(l,n,s)):void 0!==s&&(r[e]=s));return r}"Boolean Number String Function Array Date RegExp Object".split(" ").forEach(t=>{class2type["[object "+t+"]"]=t.toLowerCase()});var QEditor=Vue.extend({name:"QEditor",mixins:[ListenersMixin,FullscreenMixin,DarkMixin],props:{value:{type:String,required:!0},readonly:Boolean,disable:Boolean,minHeight:{type:String,default:"10rem"},maxHeight:String,height:String,definitions:Object,fonts:Object,placeholder:String,toolbar:{type:Array,validator:t=>0===t.length||t.every(t=>t.length),default:()=>[["left","center","right","justify"],["bold","italic","underline","strike"],["undo","redo"]]},toolbarColor:String,toolbarBg:String,toolbarTextColor:String,toolbarToggleColor:{type:String,default:"primary"},toolbarOutline:Boolean,toolbarPush:Boolean,toolbarRounded:Boolean,contentStyle:Object,contentClass:[Object,Array,String],square:Boolean,flat:Boolean,dense:Boolean},computed:{editable(){return!this.readonly&&!this.disable},hasToolbar(){return this.toolbar&&this.toolbar.length>0},toolbarBackgroundClass(){if(this.toolbarBg)return`bg-${this.toolbarBg}`},buttonProps(){return{type:"a",flat:!0!==this.toolbarOutline&&!0!==this.toolbarPush,noWrap:!0,outline:this.toolbarOutline,push:this.toolbarPush,rounded:this.toolbarRounded,dense:!0,color:this.toolbarColor,disable:!this.editable,size:"sm"}},buttonDef(){const t=this.$q.lang.editor,e=this.$q.iconSet.editor;return{bold:{cmd:"bold",icon:e.bold,tip:t.bold,key:66},italic:{cmd:"italic",icon:e.italic,tip:t.italic,key:73},strike:{cmd:"strikeThrough",icon:e.strikethrough,tip:t.strikethrough,key:83},underline:{cmd:"underline",icon:e.underline,tip:t.underline,key:85},unordered:{cmd:"insertUnorderedList",icon:e.unorderedList,tip:t.unorderedList},ordered:{cmd:"insertOrderedList",icon:e.orderedList,tip:t.orderedList},subscript:{cmd:"subscript",icon:e.subscript,tip:t.subscript,htmlTip:"x<subscript>2</subscript>"},superscript:{cmd:"superscript",icon:e.superscript,tip:t.superscript,htmlTip:"x<superscript>2</superscript>"},link:{cmd:"link",disable:t=>t.caret&&!t.caret.can("link"),icon:e.hyperlink,tip:t.hyperlink,key:76},fullscreen:{cmd:"fullscreen",icon:e.toggleFullscreen,tip:t.toggleFullscreen,key:70},viewsource:{cmd:"viewsource",icon:e.viewSource,tip:t.viewSource},quote:{cmd:"formatBlock",param:"BLOCKQUOTE",icon:e.quote,tip:t.quote,key:81},left:{cmd:"justifyLeft",icon:e.left,tip:t.left},center:{cmd:"justifyCenter",icon:e.center,tip:t.center},right:{cmd:"justifyRight",icon:e.right,tip:t.right},justify:{cmd:"justifyFull",icon:e.justify,tip:t.justify},print:{type:"no-state",cmd:"print",icon:e.print,tip:t.print,key:80},outdent:{type:"no-state",disable:t=>t.caret&&!t.caret.can("outdent"),cmd:"outdent",icon:e.outdent,tip:t.outdent},indent:{type:"no-state",disable:t=>t.caret&&!t.caret.can("indent"),cmd:"indent",icon:e.indent,tip:t.indent},removeFormat:{type:"no-state",cmd:"removeFormat",icon:e.removeFormat,tip:t.removeFormat},hr:{type:"no-state",cmd:"insertHorizontalRule",icon:e.hr,tip:t.hr},undo:{type:"no-state",cmd:"undo",icon:e.undo,tip:t.undo,key:90},redo:{type:"no-state",cmd:"redo",icon:e.redo,tip:t.redo,key:89},h1:{cmd:"formatBlock",param:"H1",icon:e.heading1||e.heading,tip:t.heading1,htmlTip:`<h1 class="q-ma-none">${t.heading1}</h1>`},h2:{cmd:"formatBlock",param:"H2",icon:e.heading2||e.heading,tip:t.heading2,htmlTip:`<h2 class="q-ma-none">${t.heading2}</h2>`},h3:{cmd:"formatBlock",param:"H3",icon:e.heading3||e.heading,tip:t.heading3,htmlTip:`<h3 class="q-ma-none">${t.heading3}</h3>`},h4:{cmd:"formatBlock",param:"H4",icon:e.heading4||e.heading,tip:t.heading4,htmlTip:`<h4 class="q-ma-none">${t.heading4}</h4>`},h5:{cmd:"formatBlock",param:"H5",icon:e.heading5||e.heading,tip:t.heading5,htmlTip:`<h5 class="q-ma-none">${t.heading5}</h5>`},h6:{cmd:"formatBlock",param:"H6",icon:e.heading6||e.heading,tip:t.heading6,htmlTip:`<h6 class="q-ma-none">${t.heading6}</h6>`},p:{cmd:"formatBlock",param:"DIV",icon:e.heading,tip:t.paragraph},code:{cmd:"formatBlock",param:"PRE",icon:e.code,htmlTip:`<code>${t.code}</code>`},"size-1":{cmd:"fontSize",param:"1",icon:e.size1||e.size,tip:t.size1,htmlTip:`<font size="1">${t.size1}</font>`},"size-2":{cmd:"fontSize",param:"2",icon:e.size2||e.size,tip:t.size2,htmlTip:`<font size="2">${t.size2}</font>`},"size-3":{cmd:"fontSize",param:"3",icon:e.size3||e.size,tip:t.size3,htmlTip:`<font size="3">${t.size3}</font>`},"size-4":{cmd:"fontSize",param:"4",icon:e.size4||e.size,tip:t.size4,htmlTip:`<font size="4">${t.size4}</font>`},"size-5":{cmd:"fontSize",param:"5",icon:e.size5||e.size,tip:t.size5,htmlTip:`<font size="5">${t.size5}</font>`},"size-6":{cmd:"fontSize",param:"6",icon:e.size6||e.size,tip:t.size6,htmlTip:`<font size="6">${t.size6}</font>`},"size-7":{cmd:"fontSize",param:"7",icon:e.size7||e.size,tip:t.size7,htmlTip:`<font size="7">${t.size7}</font>`}}},buttons(){const t=this.definitions||{},e=this.definitions||this.fonts?extend(!0,{},this.buttonDef,t,getFonts(this.defaultFont,this.$q.lang.editor.defaultFont,this.$q.iconSet.editor.font,this.fonts)):this.buttonDef;return this.toolbar.map(i=>i.map(i=>{if(i.options)return{type:"dropdown",icon:i.icon,label:i.label,size:"sm",dense:!0,fixedLabel:i.fixedLabel,fixedIcon:i.fixedIcon,highlight:i.highlight,list:i.list,options:i.options.map(t=>e[t])};const s=e[i];return s?"no-state"===s.type||t[i]&&(void 0===s.cmd||this.buttonDef[s.cmd]&&"no-state"===this.buttonDef[s.cmd].type)?s:Object.assign({type:"toggle"},s):{type:"slot",slot:i}}))},keys(){const t={},e=e=>{e.key&&(t[e.key]={cmd:e.cmd,param:e.param})};return this.buttons.forEach(t=>{t.forEach(t=>{t.options?t.options.forEach(e):e(t)})}),t},innerStyle(){return this.inFullscreen?this.contentStyle:[{minHeight:this.minHeight,height:this.height,maxHeight:this.maxHeight},this.contentStyle]},classes(){return`q-editor q-editor--${!0===this.isViewingSource?"source":"default"}`+(!0===this.disable?" disabled":"")+(!0===this.inFullscreen?" fullscreen column":"")+(!0===this.square?" q-editor--square no-border-radius":"")+(!0===this.flat?" q-editor--flat":"")+(!0===this.dense?" q-editor--dense":"")+(!0===this.isDark?" q-editor--dark q-dark":"")},innerClass(){return[this.contentClass,{col:this.inFullscreen,"overflow-auto":this.inFullscreen||this.maxHeight}]},attrs(){return!0===this.disable?{"aria-disabled":""}:!0===this.readonly?{"aria-readonly":""}:void 0}},data:()=>({editWatcher:!0,editLinkUrl:null,isViewingSource:!1}),watch:{value(t){!0===this.editWatcher?this.__setContent(t):this.editWatcher=!0}},methods:{__onInput(){if(!0===this.editWatcher&&void 0!==this.$refs.content){const t=this.isViewingSource?this.$refs.content.innerText:this.$refs.content.innerHTML;t!==this.value&&(this.editWatcher=!1,this.$emit("input",t))}},__onKeydown(t){if(this.$emit("keydown",t),!0!==t.ctrlKey||!0===shouldIgnoreKey(t))return this.refreshToolbar(),void(this.$q.platform.is.ie&&this.$nextTick(this.__onInput));const e=t.keyCode,i=this.keys[e];if(void 0!==i){const{cmd:e,param:s}=i;stopAndPrevent(t),this.runCmd(e,s,!1)}},__onClick(t){this.refreshToolbar(),this.$emit("click",t)},__onBlur(){if(void 0!==this.$refs.content){const{scrollTop:t,scrollHeight:e}=this.$refs.content;this.__offsetBottom=e-t}!0!==this.$q.platform.is.ie&&this.caret.save(),this.$emit("blur")},__onFocus(){this.$nextTick(()=>{void 0!==this.$refs.content&&void 0!==this.__offsetBottom&&(this.$refs.content.scrollTop=this.$refs.content.scrollHeight-this.__offsetBottom)})},__onMouseup(t){this.caret.save(),void 0!==this.qListeners.mouseup&&this.$emit("mouseup",t)},__onKeyup(t){this.caret.save(),void 0!==this.qListeners.keyup&&this.$emit("keyup",t)},__onTouchend(t){this.caret.save(),void 0!==this.qListeners.touchend&&this.$emit("touchend",t)},runCmd(t,e,i=!0){this.focus(),this.caret.restore(),this.caret.apply(t,e,()=>{this.focus(),this.caret.save(),!0!==this.$q.platform.is.ie&&!0!==this.$q.platform.is.edge||this.$nextTick(this.__onInput),i&&this.refreshToolbar()})},refreshToolbar(){setTimeout(()=>{this.editLinkUrl=null,this.$forceUpdate()},1)},focus(){void 0!==this.$refs.content&&this.$refs.content.focus()},getContentEl(){return this.$refs.content},__setContent(t){void 0!==this.$refs.content&&(this.isViewingSource?this.$refs.content.innerText=t:this.$refs.content.innerHTML=t)}},created(){!1===isSSR&&(document.execCommand("defaultParagraphSeparator",!1,"div"),this.defaultFont=window.getComputedStyle(document.body).fontFamily)},mounted(){this.caret=new Caret(this.$refs.content,this),this.__setContent(this.value),this.refreshToolbar()},render(t){let e;if(this.hasToolbar){const i=[];i.push(t("div",{key:"qedt_top",staticClass:"q-editor__toolbar row no-wrap scroll-x",class:this.toolbarBackgroundClass},getToolbar(t,this))),null!==this.editLinkUrl&&i.push(t("div",{key:"qedt_btm",staticClass:"q-editor__toolbar row no-wrap items-center scroll-x",class:this.toolbarBackgroundClass},getLinkEditor(t,this,this.$q.platform.is.ie))),e=t("div",{key:"toolbar_ctainer",staticClass:"q-editor__toolbars-container"},i)}const i={...this.qListeners,input:this.__onInput,keydown:this.__onKeydown,click:this.__onClick,blur:this.__onBlur,focus:this.__onFocus,mouseup:this.__onMouseup,keyup:this.__onKeyup,touchend:this.__onTouchend};return t("div",{style:{height:!0===this.inFullscreen?"100vh":null},class:this.classes,attrs:this.attrs},[e,t("div",{ref:"content",staticClass:"q-editor__content",style:this.innerStyle,class:this.innerClass,attrs:{contenteditable:this.editable,placeholder:this.placeholder},domProps:isSSR?{innerHTML:this.value}:void 0,on:i})])}}),QItemLabel=Vue.extend({name:"QItemLabel",mixins:[ListenersMixin],props:{overline:Boolean,caption:Boolean,header:Boolean,lines:[Number,String]},computed:{classes(){return{"q-item__label--overline text-overline":this.overline,"q-item__label--caption text-caption":this.caption,"q-item__label--header":this.header,ellipsis:1===parseInt(this.lines,10)}},style(){if(void 0!==this.lines&&parseInt(this.lines,10)>1)return{overflow:"hidden",display:"-webkit-box","-webkit-box-orient":"vertical","-webkit-line-clamp":this.lines}}},render(t){return t("div",{staticClass:"q-item__label",style:this.style,class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QSlideTransition=Vue.extend({name:"QSlideTransition",props:{appear:Boolean,duration:{type:Number,default:300}},methods:{__begin(t,e,i){t.style.overflowY="hidden",void 0!==e&&(t.style.height=`${e}px`),t.style.transition=`height ${this.duration}ms cubic-bezier(.25, .8, .50, 1)`,this.animating=!0,this.done=i},__end(t,e){t.style.overflowY=null,t.style.height=null,t.style.transition=null,this.__cleanup(),e!==this.lastEvent&&this.$emit(e)},__cleanup(){this.done&&this.done(),this.done=null,this.animating=!1,clearTimeout(this.timer),clearTimeout(this.timerFallback),void 0!==this.el&&this.el.removeEventListener("transitionend",this.animListener),this.animListener=null}},beforeDestroy(){this.animating&&this.__cleanup()},render(t){return t("transition",{props:{css:!1,appear:this.appear},on:cache(this,"tr",{enter:(t,e)=>{let i=0;this.el=t,!0===this.animating?(this.__cleanup(),i=t.offsetHeight===t.scrollHeight?0:void 0):this.lastEvent="hide",this.__begin(t,i,e),this.timer=setTimeout(()=>{t.style.height=`${t.scrollHeight}px`,this.animListener=(e=>{Object(e)===e&&e.target!==t||this.__end(t,"show")}),t.addEventListener("transitionend",this.animListener),this.timerFallback=setTimeout(this.animListener,1.1*this.duration)},100)},leave:(t,e)=>{let i;this.el=t,!0===this.animating?this.__cleanup():(this.lastEvent="show",i=t.scrollHeight),this.__begin(t,i,e),this.timer=setTimeout(()=>{t.style.height=0,this.animListener=(e=>{Object(e)===e&&e.target!==t||this.__end(t,"hide")}),t.addEventListener("transitionend",this.animListener),this.timerFallback=setTimeout(this.animListener,1.1*this.duration)},100)}})},slot(this,"default"))}});const insetMap={true:"inset",item:"item-inset","item-thumbnail":"item-thumbnail-inset"},margins={xs:2,sm:4,md:8,lg:16,xl:24};var QSeparator=Vue.extend({name:"QSeparator",mixins:[DarkMixin,ListenersMixin],props:{spaced:[Boolean,String],inset:[Boolean,String],vertical:Boolean,color:String,size:String},computed:{orientation(){return!0===this.vertical?"vertical":"horizontal"},classPrefix(){return` q-separator--${this.orientation}`},insetClass(){return!1!==this.inset?`${this.classPrefix}-${insetMap[this.inset]}`:""},classes(){return`q-separator${this.classPrefix}${this.insetClass}`+(void 0!==this.color?` bg-${this.color}`:"")+(!0===this.isDark?" q-separator--dark":"")},style(){const t={};if(void 0!==this.size&&(t[!0===this.vertical?"width":"height"]=this.size),!1!==this.spaced){const e=!0===this.spaced?`${margins.md}px`:this.spaced in margins?`${margins[this.spaced]}px`:this.spaced,i=!0===this.vertical?["Left","Right"]:["Top","Bottom"];t[`margin${i[0]}`]=t[`margin${i[1]}`]=e}return t},attrs(){return{role:"separator","aria-orientation":this.orientation}}},render(t){return t("hr",{staticClass:"q-separator",class:this.classes,style:this.style,attrs:this.attrs,on:{...this.qListeners}})}});const eventName="q:expansion-item:close";var QExpansionItem=Vue.extend({name:"QExpansionItem",mixins:[DarkMixin,RouterLinkMixin,ModelToggleMixin],props:{icon:String,label:String,labelLines:[Number,String],caption:String,captionLines:[Number,String],dense:Boolean,expandIcon:String,expandedIcon:String,expandIconClass:[Array,String,Object],duration:Number,headerInsetLevel:Number,contentInsetLevel:Number,expandSeparator:Boolean,defaultOpened:Boolean,expandIconToggle:Boolean,switchToggleSide:Boolean,denseToggle:Boolean,group:String,popup:Boolean,headerStyle:[Array,String,Object],headerClass:[Array,String,Object]},data(){return{showing:void 0!==this.value?this.value:this.defaultOpened}},watch:{showing(t){!0===t&&void 0!==this.group&&this.$root.$emit(eventName,this)},group(t,e){void 0!==t&&void 0===e?this.$root.$on(eventName,this.__eventHandler):void 0===t&&void 0!==e&&this.$root.$off(eventName,this.__eventHandler)}},computed:{classes(){return`q-expansion-item--${!0===this.showing?"expanded":"collapsed"}`+` q-expansion-item--${!0===this.popup?"popup":"standard"}`},contentStyle(){if(void 0!==this.contentInsetLevel){return{["padding"+(!0===this.$q.lang.rtl?"Right":"Left")]:56*this.contentInsetLevel+"px"}}},isClickable(){return!0===this.hasRouterLink||!0!==this.expandIconToggle},expansionIcon(){return void 0!==this.expandedIcon&&!0===this.showing?this.expandedIcon:this.expandIcon||this.$q.iconSet.expansionItem[!0===this.denseToggle?"denseIcon":"icon"]},activeToggleIcon(){return!0!==this.disable&&(!0===this.hasRouterLink||!0===this.expandIconToggle)}},methods:{__onHeaderClick(t){!0!==this.hasRouterLink&&this.toggle(t),this.$emit("click",t)},__toggleIconKeyboard(t){13===t.keyCode&&this.__toggleIcon(t,!0)},__toggleIcon(t,e){!0!==e&&void 0!==this.$refs.blurTarget&&this.$refs.blurTarget.focus(),this.toggle(t),stopAndPrevent(t)},__eventHandler(t){this!==t&&this.group===t.group&&this.hide()},__getToggleIcon(t){const e={staticClass:`q-focusable relative-position cursor-pointer${!0===this.denseToggle&&!0===this.switchToggleSide?" items-end":""}`,class:this.expandIconClass,props:{side:!0!==this.switchToggleSide,avatar:this.switchToggleSide}},i=[t(QIcon,{staticClass:"q-expansion-item__toggle-icon",class:void 0===this.expandedIcon&&!0===this.showing?"q-expansion-item__toggle-icon--rotated":void 0,props:{name:this.expansionIcon}})];return!0===this.activeToggleIcon&&(Object.assign(e,{attrs:{tabindex:0},on:cache(this,"inpExt",{click:this.__toggleIcon,keyup:this.__toggleIconKeyboard})}),i.unshift(t("div",{ref:"blurTarget",staticClass:"q-expansion-item__toggle-focus q-icon q-focus-helper q-focus-helper--rounded",attrs:{tabindex:-1}}))),t(QItemSection,e,i)},__getHeader(t){let e;void 0!==this.$scopedSlots.header?e=this.$scopedSlots.header().slice():(e=[t(QItemSection,[t(QItemLabel,{props:{lines:this.labelLines}},[this.label||""]),this.caption?t(QItemLabel,{props:{lines:this.captionLines,caption:!0}},[this.caption]):null])],this.icon&&e[!0===this.switchToggleSide?"push":"unshift"](t(QItemSection,{props:{side:!0===this.switchToggleSide,avatar:!0!==this.switchToggleSide}},[t(QIcon,{props:{name:this.icon}})]))),!0!==this.disable&&e[!0===this.switchToggleSide?"unshift":"push"](this.__getToggleIcon(t));const i={ref:"item",style:this.headerStyle,class:this.headerClass,props:{dark:this.isDark,disable:this.disable,dense:this.dense,insetLevel:this.headerInsetLevel}};if(!0===this.isClickable){const t=!0===this.hasRouterLink?"nativeOn":"on";i.props.clickable=!0,i[t]={...this.qListeners,click:this.__onHeaderClick},!0===this.hasRouterLink&&Object.assign(i.props,this.routerLinkProps)}return t(QItem,i,e)},__getContent(t){const e=[this.__getHeader(t),t(QSlideTransition,{props:{duration:this.duration},on:cache(this,"slide",{show:()=>{this.$emit("after-show")},hide:()=>{this.$emit("after-hide")}})},[t("div",{staticClass:"q-expansion-item__content relative-position",style:this.contentStyle,directives:[{name:"show",value:this.showing}]},slot(this,"default"))])];return this.expandSeparator&&e.push(t(QSeparator,{staticClass:"q-expansion-item__border q-expansion-item__border--top absolute-top",props:{dark:this.isDark}}),t(QSeparator,{staticClass:"q-expansion-item__border q-expansion-item__border--bottom absolute-bottom",props:{dark:this.isDark}})),e}},render(t){return t("div",{staticClass:"q-expansion-item q-item-type",class:this.classes},[t("div",{staticClass:"q-expansion-item__container relative-position"},this.__getContent(t))])},created(){void 0!==this.group&&this.$root.$on(eventName,this.__eventHandler)},beforeDestroy(){void 0!==this.group&&this.$root.$off(eventName,this.__eventHandler)}});const labelPositions=["top","right","bottom","left"];var FabMixin={props:{type:{type:String,default:"a"},outline:Boolean,push:Boolean,flat:Boolean,unelevated:Boolean,color:String,textColor:String,glossy:Boolean,square:Boolean,padding:String,label:{type:[String,Number],default:""},labelPosition:{type:String,default:"right",validator:t=>labelPositions.includes(t)},externalLabel:Boolean,hideLabel:{type:Boolean},labelClass:[Array,String,Object],labelStyle:[Array,String,Object],disable:Boolean},computed:{formClass(){return`q-fab--form-${!0===this.square?"square":"rounded"}`},stacked(){return!1===this.externalLabel&&["top","bottom"].includes(this.labelPosition)},labelProps(){if(!0===this.externalLabel){const t=null===this.hideLabel?!1===this.showing:this.hideLabel;return{action:"push",data:{staticClass:"q-fab__label q-tooltip--style q-fab__label--external"+` q-fab__label--external-${this.labelPosition}`+(!0===t?" q-fab__label--external-hidden":""),style:this.labelStyle,class:this.labelClass}}}return{action:["left","top"].includes(this.labelPosition)?"unshift":"push",data:{staticClass:`q-fab__label q-fab__label--internal q-fab__label--internal-${this.labelPosition}`+(!0===this.hideLabel?" q-fab__label--internal-hidden":""),style:this.labelStyle,class:this.labelClass}}}}};const directions$1=["up","right","down","left"],alignValues$1=["left","center","right"];var QFab=Vue.extend({name:"QFab",mixins:[FabMixin,ModelToggleMixin],provide(){return{__qFabClose:t=>{this.hide(t),this.$refs.trigger&&this.$refs.trigger.$el&&this.$refs.trigger.$el.focus()}}},props:{icon:String,activeIcon:String,hideIcon:Boolean,hideLabel:{default:null},direction:{type:String,default:"right",validator:t=>directions$1.includes(t)},persistent:Boolean,verticalActionsAlign:{type:String,default:"center",validator:t=>alignValues$1.includes(t)}},data(){return{showing:!0===this.value}},computed:{hideOnRouteChange(){return!0!==this.persistent},classes(){return`q-fab--align-${this.verticalActionsAlign} ${this.formClass}`+(!0===this.showing?" q-fab--opened":"")}},render(t){const e=[];return!0!==this.hideIcon&&e.push(t("div",{staticClass:"q-fab__icon-holder"},[t(QIcon,{staticClass:"q-fab__icon absolute-full",props:{name:this.icon||this.$q.iconSet.fab.icon}}),t(QIcon,{staticClass:"q-fab__active-icon absolute-full",props:{name:this.activeIcon||this.$q.iconSet.fab.activeIcon}})])),""!==this.label&&e[this.labelProps.action](t("div",this.labelProps.data,[this.label])),t("div",{staticClass:"q-fab z-fab row inline justify-center",class:this.classes,on:{...this.qListeners}},[t("div",{staticClass:"q-fab__actions flex no-wrap inline",class:`q-fab__actions--${this.direction}`},slot(this,"default")),t(QBtn,{ref:"trigger",class:this.formClass,props:{...this.$props,noWrap:!0,stack:this.stacked,align:void 0,icon:void 0,label:void 0,noCaps:!0,fab:!0},on:cache(this,"tog",{click:this.toggle})},mergeSlot(e,this,"tooltip"))])}});const anchorMap={start:"self-end",center:"self-center",end:"self-start"},anchorValues=Object.keys(anchorMap);var QFabAction=Vue.extend({name:"QFabAction",mixins:[ListenersMixin,FabMixin],props:{icon:{type:String,default:""},anchor:{type:String,validator:t=>anchorValues.includes(t)},to:[String,Object],replace:Boolean},inject:{__qFabClose:{default(){console.error("QFabAction needs to be child of QFab")}}},computed:{classes(){const t=anchorMap[this.anchor];return this.formClass+(void 0!==t?` ${t}`:"")},onEvents(){return{...this.qListeners,click:this.click}}},methods:{click(t){this.__qFabClose(),this.$emit("click",t)}},render(t){const e=[];return""!==this.icon&&e.push(t(QIcon,{props:{name:this.icon}})),""!==this.label&&e[this.labelProps.action](t("div",this.labelProps.data,[this.label])),t(QBtn,{class:this.classes,props:{...this.$props,noWrap:!0,stack:this.stacked,icon:void 0,label:void 0,noCaps:!0,fabMini:!0},on:this.onEvents},mergeSlot(e,this,"default"))}}),QFile=Vue.extend({name:"QFile",mixins:[QField,FileMixin,FormFieldMixin,FileValueMixin],props:{value:!0===isSSR?{}:[File,FileList,Array],append:Boolean,useChips:Boolean,displayValue:[String,Number],tabindex:{type:[String,Number],default:0},counterLabel:Function,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},data:()=>({dnd:!1}),computed:{innerValue(){return Object(this.value)===this.value?"length"in this.value?Array.from(this.value):[this.value]:[]},selectedString(){return this.innerValue.map(t=>t.name).join(", ")},totalSize(){return humanStorageSize(this.innerValue.reduce((t,e)=>t+e.size,0))},counterProps(){return{totalSize:this.totalSize,filesNumber:this.innerValue.length,maxFiles:this.maxFiles}},computedCounter(){if(void 0!==this.counterLabel)return this.counterLabel(this.counterProps);const t=this.maxFiles;return`${this.innerValue.length}${void 0!==t?" / "+t:""} (${this.totalSize})`},inputAttrs(){return{tabindex:-1,type:"file",title:"",accept:this.accept,capture:this.capture,name:this.nameProp,...this.qAttrs,id:this.targetUid,disabled:!0!==this.editable}},isAppending(){return!0===this.multiple&&!0===this.append}},methods:{removeAtIndex(t){const e=this.innerValue.slice();e.splice(t,1),this.__emitValue(e)},removeFile(t){const e=this.innerValue.findIndex(t);e>-1&&this.removeAtIndex(e)},__emitValue(t){this.$emit("input",!0===this.multiple?t:t[0])},__onKeyup(t){13===t.keyCode&&this.pickFiles(t)},__getFileInput(){return this.$refs.input},__addFiles(t,e){const i=this.__processFiles(t,e,this.innerValue,this.isAppending);void 0!==i&&this.__emitValue(!0===this.isAppending?this.innerValue.concat(i):i)},__getControl(t){const e={ref:"target",staticClass:"q-field__native row items-center cursor-pointer",attrs:{tabindex:this.tabindex}};return!0===this.editable&&(e.on=cache(this,"native",{dragover:this.__onDragOver,keyup:this.__onKeyup})),t("div",e,[this.__getInput(t)].concat(this.__getSelection(t)))},__getControlChild(t){return this.__getDnd(t,"file")},__getSelection(t){return void 0!==this.$scopedSlots.file?this.innerValue.map((t,e)=>this.$scopedSlots.file({index:e,file:t,ref:this})):void 0!==this.$scopedSlots.selected?this.$scopedSlots.selected({files:this.innerValue,ref:this}):!0===this.useChips?this.innerValue.map((e,i)=>t(QChip,{key:"file-"+i,props:{removable:this.editable,dense:!0,textColor:this.color,tabindex:this.tabindex},on:cache(this,"rem#"+i,{remove:()=>{this.removeAtIndex(i)}})},[t("span",{staticClass:"ellipsis",domProps:{textContent:e.name}})])):[t("div",{style:this.inputStyle,class:this.inputClass,domProps:{textContent:void 0!==this.displayValue?this.displayValue:this.selectedString}})]},__getInput(t){const e={ref:"input",staticClass:"q-field__input fit absolute-full cursor-pointer",attrs:this.inputAttrs,domProps:this.formDomProps,on:cache(this,"input",{change:this.__addFiles})};return!0===this.multiple&&(e.attrs.multiple=!0),t("input",e)}},created(){this.fieldClass="q-file q-field--auto-height",this.type="file"}}),QFooter=Vue.extend({name:"QFooter",mixins:[ListenersMixin],inject:{layout:{default(){console.error("QFooter needs to be child of QLayout")}}},props:{value:{type:Boolean,default:!0},reveal:Boolean,bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},data(){return{size:parseInt(this.heightHint,10),revealed:!0,windowHeight:onSSR||this.layout.container?0:window.innerHeight}},watch:{value(t){this.__update("space",t),this.__updateLocal("revealed",!0),this.layout.__animate()},offset(t){this.__update("offset",t)},reveal(t){!1===t&&this.__updateLocal("revealed",this.value)},revealed(t){this.layout.__animate(),this.$emit("reveal",t)},"layout.scroll"(){this.__updateRevealed()},"layout.height"(){this.__updateRevealed()},size(){this.__updateRevealed()},"$q.screen.height"(t){!0!==this.layout.container&&this.__updateLocal("windowHeight",t)}},computed:{fixed(){return!0===this.reveal||this.layout.view.indexOf("F")>-1||!0===this.layout.container},containerHeight(){return!0===this.layout.container?this.layout.containerHeight:this.windowHeight},offset(){if(!0!==this.value)return 0;if(!0===this.fixed)return!0===this.revealed?this.size:0;const t=this.layout.scroll.position+this.containerHeight+this.size-this.layout.height;return t>0?t:0},hidden(){return!0!==this.value||!0===this.fixed&&!0!==this.revealed},revealOnFocus(){return!0===this.value&&!0===this.hidden&&!0===this.reveal},classes(){return(!0===this.fixed?"fixed":"absolute")+"-bottom"+(!0===this.bordered?" q-footer--bordered":"")+(!0===this.hidden?" q-footer--hidden":"")+(!0!==this.value?" q-layout--prevent-focus":"")+(!0!==this.value&&!0!==this.fixed?" hidden":"")},style(){const t=this.layout.rows.bottom,e={};return"l"===t[0]&&!0===this.layout.left.space&&(e[!0===this.$q.lang.rtl?"right":"left"]=`${this.layout.left.size}px`),"r"===t[2]&&!0===this.layout.right.space&&(e[!0===this.$q.lang.rtl?"left":"right"]=`${this.layout.right.size}px`),e},onEvents(){return{...this.qListeners,focusin:this.__onFocusin,input:stop}}},render(t){const e=mergeSlot([t(QResizeObserver,{props:{debounce:0},on:cache(this,"resize",{resize:this.__onResize})})],this,"default");return!0===this.elevated&&e.push(t("div",{staticClass:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),t("footer",{staticClass:"q-footer q-layout__section--marginal",class:this.classes,style:this.style,on:this.onEvents},e)},created(){this.layout.instances.footer=this,!0===this.value&&this.__update("size",this.size),this.__update("space",this.value),this.__update("offset",this.offset)},beforeDestroy(){this.layout.instances.footer===this&&(this.layout.instances.footer=void 0,this.__update("size",0),this.__update("offset",0),this.__update("space",!1))},methods:{__onResize({height:t}){this.__updateLocal("size",t),this.__update("size",t)},__update(t,e){this.layout.footer[t]!==e&&(this.layout.footer[t]=e)},__updateLocal(t,e){this[t]!==e&&(this[t]=e)},__updateRevealed(){if(!0!==this.reveal)return;const{direction:t,position:e,inflexionPosition:i}=this.layout.scroll;this.__updateLocal("revealed","up"===t||e-i<100||this.layout.height-this.containerHeight-e-this.size<300)},__onFocusin(t){!0===this.revealOnFocus&&this.__updateLocal("revealed",!0),this.$emit("focusin",t)}}}),QForm=Vue.extend({name:"QForm",mixins:[ListenersMixin],props:{autofocus:Boolean,noErrorFocus:Boolean,noResetFocus:Boolean,greedy:Boolean},computed:{onEvents(){return{...this.qListeners,submit:this.submit,reset:this.reset}}},mounted(){this.validateIndex=0,!0===this.autofocus&&this.focus()},methods:{validate(t){const e=[],i="boolean"==typeof t?t:!0!==this.noErrorFocus;this.validateIndex++;const s=this.getValidationComponents(),o=(t,e)=>{this.$emit("validation-"+(!0===t?"success":"error"),e)};for(let t=0;t<s.length;t++){const n=s[t],r=n.validate();if("function"==typeof r.then)e.push(r.then(t=>({valid:t,comp:n}),t=>({valid:!1,comp:n,error:t})));else if(!0!==r){if(!1===this.greedy)return o(!1,n),!0===i&&"function"==typeof n.focus&&n.focus(),Promise.resolve(!1);e.push({valid:!1,comp:n})}}if(0===e.length)return o(!0),Promise.resolve(!0);const n=this.validateIndex;return Promise.all(e).then(t=>{if(n===this.validateIndex){const e=t.filter(t=>!0!==t.valid);if(0===e.length)return o(!0),!0;const{valid:s,comp:n}=e[0];return o(!1,n),!0===i&&!0!==s&&"function"==typeof n.focus&&n.focus(),!1}})},resetValidation(){this.validateIndex++,this.getValidationComponents().forEach(t=>{t.resetValidation()})},submit(t){void 0!==t&&stopAndPrevent(t),this.validate().then(e=>{!0===e&&(void 0!==this.qListeners.submit?this.$emit("submit",t):void 0!==t&&void 0!==t.target&&"function"==typeof t.target.submit&&t.target.submit())})},reset(t){void 0!==t&&stopAndPrevent(t),this.$emit("reset"),this.$nextTick(()=>{this.resetValidation(),!0===this.autofocus&&!0!==this.noResetFocus&&this.focus()})},focus(){const t=this.$el.querySelector("[autofocus], [data-autofocus]")||Array.prototype.find.call(this.$el.querySelectorAll("[tabindex]"),t=>t.tabIndex>-1);null!==t&&void 0!==t&&t.focus()},getValidationComponents(){return Array.prototype.map.call(this.$el.getElementsByClassName("q-validation-component"),t=>t.__vue__).filter(t=>void 0!==t&&"function"==typeof t.validate)}},render(t){return t("form",{staticClass:"q-form",on:this.onEvents},slot(this,"default"))}}),QHeader=Vue.extend({name:"QHeader",mixins:[ListenersMixin],inject:{layout:{default(){console.error("QHeader needs to be child of QLayout")}}},props:{value:{type:Boolean,default:!0},reveal:Boolean,revealOffset:{type:Number,default:250},bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},data(){return{size:parseInt(this.heightHint,10),revealed:!0}},watch:{value(t){this.__update("space",t),this.__updateLocal("revealed",!0),this.layout.__animate()},offset(t){this.__update("offset",t)},reveal(t){!1===t&&this.__updateLocal("revealed",this.value)},revealed(t){this.layout.__animate(),this.$emit("reveal",t)},"layout.scroll"(t){!0===this.reveal&&this.__updateLocal("revealed","up"===t.direction||t.position<=this.revealOffset||t.position-t.inflexionPosition<100)}},computed:{fixed(){return!0===this.reveal||this.layout.view.indexOf("H")>-1||!0===this.layout.container},offset(){if(!0!==this.value)return 0;if(!0===this.fixed)return!0===this.revealed?this.size:0;const t=this.size-this.layout.scroll.position;return t>0?t:0},hidden(){return!0!==this.value||!0===this.fixed&&!0!==this.revealed},revealOnFocus(){return!0===this.value&&!0===this.hidden&&!0===this.reveal},classes(){return(!0===this.fixed?"fixed":"absolute")+"-top"+(!0===this.bordered?" q-header--bordered":"")+(!0===this.hidden?" q-header--hidden":"")+(!0!==this.value?" q-layout--prevent-focus":"")},style(){const t=this.layout.rows.top,e={};return"l"===t[0]&&!0===this.layout.left.space&&(e[!0===this.$q.lang.rtl?"right":"left"]=`${this.layout.left.size}px`),"r"===t[2]&&!0===this.layout.right.space&&(e[!0===this.$q.lang.rtl?"left":"right"]=`${this.layout.right.size}px`),e},onEvents(){return{...this.qListeners,focusin:this.__onFocusin,input:stop}}},render(t){const e=uniqueSlot(this,"default",[]);return!0===this.elevated&&e.push(t("div",{staticClass:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),e.push(t(QResizeObserver,{props:{debounce:0},on:cache(this,"resize",{resize:this.__onResize})})),t("header",{staticClass:"q-header q-layout__section--marginal",class:this.classes,style:this.style,on:this.onEvents},e)},created(){this.layout.instances.header=this,!0===this.value&&this.__update("size",this.size),this.__update("space",this.value),this.__update("offset",this.offset)},beforeDestroy(){this.layout.instances.header===this&&(this.layout.instances.header=void 0,this.__update("size",0),this.__update("offset",0),this.__update("space",!1))},methods:{__onResize({height:t}){this.__updateLocal("size",t),this.__update("size",t)},__update(t,e){this.layout.header[t]!==e&&(this.layout.header[t]=e)},__updateLocal(t,e){this[t]!==e&&(this[t]=e)},__onFocusin(t){!0===this.revealOnFocus&&this.__updateLocal("revealed",!0),this.$emit("focusin",t)}}}),RatioMixin={props:{ratio:[String,Number]},computed:{ratioStyle(){const t=this.ratio||this.naturalRatio;if(void 0!==t)return{paddingBottom:`${100/t}%`}}}},QImg=Vue.extend({name:"QImg",mixins:[ListenersMixin,RatioMixin],props:{src:String,srcset:String,sizes:String,alt:String,width:String,height:String,placeholderSrc:String,basic:Boolean,contain:Boolean,position:{type:String,default:"50% 50%"},transition:{type:String,default:"fade"},imgClass:[Array,String,Object],imgStyle:Object,nativeContextMenu:Boolean,noDefaultSpinner:Boolean,spinnerColor:String,spinnerSize:String},data(){return{currentSrc:"",image:null,isLoading:!!this.src,hasError:!1,naturalRatio:void 0}},watch:{src(){this.__load()},srcset(t){this.__updateWatcher(t)}},computed:{url(){return this.currentSrc||this.placeholderSrc||void 0},attrs(){const t={role:"img"};return void 0!==this.alt&&(t["aria-label"]=this.alt),t},imgContainerStyle(){return Object.assign({backgroundSize:!0===this.contain?"contain":"cover",backgroundPosition:this.position},this.imgStyle,{backgroundImage:`url("${this.url}")`})},style(){return{width:this.width,height:this.height}},classes(){return"q-img overflow-hidden"+(!0===this.nativeContextMenu?" q-img--menu":"")}},methods:{__onLoad(t){this.isLoading=!1,this.hasError=!1,this.__computeRatio(t),this.__updateSrc(),this.__updateWatcher(this.srcset),this.$emit("load",this.currentSrc)},__onError(t){clearTimeout(this.ratioTimer),this.isLoading=!1,this.hasError=!0,this.currentSrc="",this.$emit("error",t)},__updateSrc(){if(void 0!==this.image&&!1===this.isLoading){const t=this.image.currentSrc||this.image.src;this.currentSrc!==t&&(this.currentSrc=t)}},__updateWatcher(t){t?void 0===this.unwatch&&(this.unwatch=this.$watch("$q.screen.width",this.__updateSrc)):void 0!==this.unwatch&&(this.unwatch(),this.unwatch=void 0)},__load(){if(clearTimeout(this.ratioTimer),this.hasError=!1,!this.src)return this.isLoading=!1,this.image=void 0,void(this.currentSrc="");this.isLoading=!0;const t=new Image;this.image=t,t.onerror=(e=>{this.image===t&&!0!==this.destroyed&&this.__onError(e)}),t.onload=(()=>{!0!==this.destroyed&&this.image===t&&(void 0!==t.decode?t.decode().catch(e=>{this.image===t&&!0!==this.destroyed&&this.__onError(e)}).then(()=>{this.image===t&&!0!==this.destroyed&&this.__onLoad(t)}):this.__onLoad(t))}),t.src=this.src,this.srcset&&(t.srcset=this.srcset),void 0!==this.sizes?t.sizes=this.sizes:Object.assign(t,{height:this.height,width:this.width})},__computeRatio(t){const{naturalHeight:e,naturalWidth:i}=t;e||i?this.naturalRatio=0===e?1:i/e:this.ratioTimer=setTimeout(()=>{this.image===t&&!0!==this.destroyed&&this.__computeRatio(t)},100)},__getImage(t){const e=!0===this.nativeContextMenu?[t("img",{staticClass:"absolute-full fit",attrs:{src:this.url,"aria-hidden":"true"}})]:void 0,i=void 0!==this.url?t("div",{key:this.url,staticClass:"q-img__image absolute-full",class:this.imgClass,style:this.imgContainerStyle},e):null;return!0===this.basic?i:t("transition",{props:{name:"q-transition--"+this.transition}},[i])},__getContent(t){const e=slot(this,!0===this.hasError?"error":"default");return!0===this.basic?t("div",{key:"content",staticClass:"q-img__content absolute-full"},e):t("transition",{props:{name:"q-transition--fade"}},[!0===this.isLoading?t("div",{key:"placeholder",staticClass:"q-img__loading absolute-full flex flex-center"},void 0!==this.$scopedSlots.loading?this.$scopedSlots.loading():!1===this.noDefaultSpinner?[t(QSpinner,{props:{color:this.spinnerColor,size:this.spinnerSize}})]:void 0):t("div",{key:"content",staticClass:"q-img__content absolute-full"},e)])}},render(t){return t("div",{class:this.classes,style:this.style,attrs:this.attrs,on:{...this.qListeners}},[t("div",{style:this.ratioStyle}),this.__getImage(t),this.__getContent(t)])},beforeMount(){if(void 0!==this.placeholderSrc&&void 0===this.ratio){const t=new Image;t.src=this.placeholderSrc,this.__computeRatio(t)}!0===this.isLoading&&this.__load()},beforeDestroy(){this.destroyed=!0,clearTimeout(this.ratioTimer),void 0!==this.unwatch&&this.unwatch()}}),QInfiniteScroll=Vue.extend({name:"QInfiniteScroll",mixins:[ListenersMixin],props:{offset:{type:Number,default:500},debounce:{type:[String,Number],default:100},scrollTarget:{default:void 0},disable:Boolean,reverse:Boolean},data:()=>({index:0,fetching:!1,working:!0}),watch:{disable(t){!0===t?this.stop():this.resume()},scrollTarget(){this.updateScrollTarget()},debounce(t){this.__setDebounce(t)}},methods:{poll(){if(!0===this.disable||!0===this.fetching||!1===this.working)return;const t=getScrollHeight(this.__scrollTarget),e=getScrollPosition(this.__scrollTarget),i=height(this.__scrollTarget);!1===this.reverse?e+i+this.offset>=t&&this.trigger():e<this.offset&&this.trigger()},trigger(){if(!0===this.disable||!0===this.fetching||!1===this.working)return;this.index++,this.fetching=!0;const t=getScrollHeight(this.__scrollTarget);this.$emit("load",this.index,e=>{!0===this.working&&(this.fetching=!1,this.$nextTick(()=>{if(!0===this.reverse){const e=getScrollHeight(this.__scrollTarget),i=getScrollPosition(this.__scrollTarget),s=e-t;setScrollPosition(this.__scrollTarget,i+s)}!0===e?this.stop():this.$el.closest("body")&&this.poll()}))})},reset(){this.index=0},resume(){!1===this.working&&(this.working=!0,this.__scrollTarget.addEventListener("scroll",this.poll,listenOpts.passive)),this.immediatePoll()},stop(){!0===this.working&&(this.working=!1,this.fetching=!1,this.__scrollTarget.removeEventListener("scroll",this.poll,listenOpts.passive))},updateScrollTarget(){this.__scrollTarget&&!0===this.working&&this.__scrollTarget.removeEventListener("scroll",this.poll,listenOpts.passive),this.__scrollTarget=getScrollTarget(this.$el,this.scrollTarget),!0===this.working&&this.__scrollTarget.addEventListener("scroll",this.poll,listenOpts.passive)},__setDebounce(t){t=parseInt(t,10),this.poll=t<=0?this.immediatePoll:debounce(this.immediatePoll,!0===isNaN(t)?100:t)}},mounted(){if(this.immediatePoll=this.poll,this.__setDebounce(this.debounce),this.updateScrollTarget(),this.immediatePoll(),!0===this.reverse){const t=getScrollHeight(this.__scrollTarget),e=height(this.__scrollTarget);setScrollPosition(this.__scrollTarget,t-e)}},beforeDestroy(){!0===this.working&&this.__scrollTarget.removeEventListener("scroll",this.poll,listenOpts.passive)},render(t){const e=uniqueSlot(this,"default",[]);return!0!==this.disable&&!0===this.working&&e[!1===this.reverse?"push":"unshift"](t("div",{staticClass:"q-infinite-scroll__loading",class:!0===this.fetching?"":"invisible"},slot(this,"loading"))),t("div",{staticClass:"q-infinite-scroll",on:{...this.qListeners}},e)}}),QInnerLoading=Vue.extend({name:"QInnerLoading",mixins:[ListenersMixin,DarkMixin,TransitionMixin],props:{showing:Boolean,color:String,size:{type:[String,Number],default:42}},render(t){const e=!0===this.showing?[t("div",{staticClass:"q-inner-loading absolute-full column flex-center",class:!0===this.isDark?"q-inner-loading--dark":null,on:{...this.qListeners}},void 0!==this.$scopedSlots.default?this.$scopedSlots.default():[t(QSpinner,{props:{size:this.size,color:this.color}})])]:void 0;return t("transition",{props:{name:this.transition,appear:!0}},e)}});const defaultCfg={threshold:0,root:null,rootMargin:"0px"};function update(t,e,{modifiers:i,value:s}){let o,n,r;e.once=i.once,"function"==typeof s?(o=s,n=defaultCfg,r=void 0===e.cfg):(o=s.handler,n=Object.assign({},defaultCfg,s.cfg),r=void 0===e.cfg||!1===isDeepEqual(e.cfg,n)),e.handler!==o&&(e.handler=o),!0===r&&(e.cfg=n,void 0!==e.observer&&e.observer.unobserve(t),e.observer=new IntersectionObserver(([i])=>{if("function"==typeof e.handler){if(null===i.rootBounds&&(void 0!==t.__vue__?!0!==t.__vue__._inactive:!0===document.body.contains(t)))return e.observer.unobserve(t),void e.observer.observe(t);(!1===e.handler(i,e.observer)||!0===e.once&&!0===i.isIntersecting)&&destroy(t)}},n),e.observer.observe(t))}function destroy(t){const e=t.__qvisible;void 0!==e&&(void 0!==e.observer&&e.observer.unobserve(t),delete t.__qvisible)}var Intersection={name:"intersection",inserted(t,e){const i={};update(t,i,e),t.__qvisible=i},update(t,e){const i=t.__qvisible;void 0!==i&&update(t,i,e)},unbind:destroy},QIntersection=Vue.extend({name:"QIntersection",mixins:[TagMixin,ListenersMixin],directives:{Intersection:Intersection},props:{once:Boolean,transition:String,ssrPrerender:Boolean,margin:String,threshold:[Number,Array],disable:Boolean},data(){return{showing:!0===onSSR&&this.ssrPrerender}},computed:{value(){return void 0!==this.margin||void 0!==this.threshold?{handler:this.__trigger,cfg:{rootMargin:this.margin,threshold:this.threshold}}:this.__trigger},directives(){if(!0!==this.disable&&(!0!==onSSR||!0!==this.once||!0!==this.ssrPrerender))return[{name:"intersection",value:this.value,modifiers:{once:this.once}}]}},methods:{__trigger(t){this.showing!==t.isIntersecting&&(this.showing=t.isIntersecting,void 0!==this.qListeners.visibility&&this.$emit("visibility",this.showing))}},render(t){const e=!0===this.showing?[t("div",{key:"content"},slot(this,"default"))]:void 0;return t(this.tag,{staticClass:"q-intersection",on:{...this.qListeners},directives:this.directives},this.transition?[t("transition",{props:{name:"q-transition--"+this.transition}},e)]:e)}});const keyCodes$1=[34,37,40,33,39,38];var QKnob=Vue.extend({name:"QKnob",mixins:[{props:QCircularProgress.options.props},FormMixin],directives:{TouchPan:TouchPan},props:{step:{type:Number,default:1,validator:t=>t>=0},tabindex:{type:[Number,String],default:0},disable:Boolean,readonly:Boolean},data(){return{model:this.value,dragging:!1}},watch:{value(t){if(t<this.min)this.model=this.min;else{if(!(t>this.max))return void(t!==this.model&&(this.model=t));this.model=this.max}this.model!==this.value&&(this.$emit("input",this.model),this.$emit("change",this.model))}},computed:{classes(){return"q-knob non-selectable"+(!0===this.editable?" q-knob--editable":!0===this.disable?" disabled":"")},editable(){return!1===this.disable&&!1===this.readonly},decimals(){return(String(this.step).trim("0").split(".")[1]||"").length},computedStep(){return 0===this.step?1:this.step},computedInstantFeedback(){return!0===this.instantFeedback||!0===this.dragging},onEvents(){return!0===this.$q.platform.is.mobile?{click:this.__click}:{mousedown:this.__activate,click:this.__click,keydown:this.__keydown,keyup:this.__keyup}},attrs(){const t={role:"slider","aria-valuemin":this.min,"aria-valuemax":this.max,"aria-valuenow":this.value};return!0===this.editable?t.tabindex=this.tabindex:t[`aria-${!0===this.disable?"disabled":"readonly"}`]="",t}},methods:{__updateCenterPosition(){const{top:t,left:e,width:i,height:s}=this.$el.getBoundingClientRect();this.centerPosition={top:t+s/2,left:e+i/2}},__pan(t){t.isFinal?(this.__updatePosition(t.evt,!0),this.dragging=!1):t.isFirst?(this.__updateCenterPosition(),this.dragging=!0,this.__updatePosition(t.evt)):this.__updatePosition(t.evt)},__click(t){this.__updateCenterPosition(),this.__updatePosition(t,!0)},__keydown(t){if(!keyCodes$1.includes(t.keyCode))return;stopAndPrevent(t);const e=([34,33].includes(t.keyCode)?10:1)*this.computedStep,i=[34,37,40].includes(t.keyCode)?-e:e;this.model=between(parseFloat((this.model+i).toFixed(this.decimals)),this.min,this.max),this.__updateValue()},__keyup(t){keyCodes$1.includes(t.keyCode)&&this.__updateValue(!0)},__activate(t){this.__updateCenterPosition(),this.__updatePosition(t)},__updatePosition(t,e){const i=this.centerPosition,s=position(t),o=Math.abs(s.top-i.top),n=Math.sqrt(o**2+Math.abs(s.left-i.left)**2);let r=Math.asin(o/n)*(180/Math.PI);r=s.top<i.top?i.left<s.left?90-r:270+r:i.left<s.left?r+90:270-r,this.angle&&(r=normalizeToInterval(r-this.angle,0,360)),!0===this.$q.lang.rtl&&(r=360-r);let a=this.min+r/360*(this.max-this.min);if(0!==this.step){const t=this.computedStep,e=a%t;a=a-e+(Math.abs(e)>=t/2?(e<0?-1:1)*t:0),a=parseFloat(a.toFixed(this.decimals))}a=between(a,this.min,this.max),this.$emit("drag-value",a),this.model!==a&&(this.model=a),this.__updateValue(e)},__updateValue(t){this.value!==this.model&&this.$emit("input",this.model),!0===t&&this.$emit("change",this.model)},__getNameInput(){return this.$createElement("input",{attrs:this.formAttrs})}},render(t){const e={class:this.classes,attrs:this.attrs,props:{...this.$props,value:this.model,instantFeedback:this.computedInstantFeedback}};return!0===this.editable&&(e.on=this.onEvents,e.directives=cache(this,"dir",[{name:"touch-pan",value:this.__pan,modifiers:{prevent:!0,stop:!0,mouse:!0}}]),void 0!==this.name&&(e.scopedSlots={internal:this.__getNameInput})),t(QCircularProgress,e,slot(this,"default"))}});const{passive:passive$1}=listenOpts;var QScrollObserver=Vue.extend({name:"QScrollObserver",props:{debounce:[String,Number],horizontal:Boolean,scrollTarget:{default:void 0}},render:noop,data(){return{pos:0,dir:!0===this.horizontal?"right":"down",dirChanged:!1,dirChangePos:0}},watch:{scrollTarget(){this.__unconfigureScrollTarget(),this.__configureScrollTarget()}},methods:{getPosition(){return{position:this.pos,direction:this.dir,directionChanged:this.dirChanged,inflexionPosition:this.dirChangePos}},trigger(t){!0===t||0===this.debounce||"0"===this.debounce?this.__emit():this.timer||(this.timer=this.debounce?setTimeout(this.__emit,this.debounce):requestAnimationFrame(this.__emit))},__emit(){const t=!0===this.horizontal?getHorizontalScrollPosition:getScrollPosition,e=Math.max(0,t(this.__scrollTarget)),i=e-this.pos,s=!0===this.horizontal?i<0?"left":"right":i<0?"up":"down";this.dirChanged=this.dir!==s,this.dirChanged&&(this.dir=s,this.dirChangePos=this.pos),this.timer=null,this.pos=e,this.$emit("scroll",this.getPosition())},__configureScrollTarget(){this.__scrollTarget=getScrollTarget(this.$el.parentNode,this.scrollTarget),this.__scrollTarget.addEventListener("scroll",this.trigger,passive$1),this.trigger(!0)},__unconfigureScrollTarget(){void 0!==this.__scrollTarget&&(this.__scrollTarget.removeEventListener("scroll",this.trigger,passive$1),this.__scrollTarget=void 0)}},mounted(){this.__configureScrollTarget()},beforeDestroy(){clearTimeout(this.timer),cancelAnimationFrame(this.timer),this.__unconfigureScrollTarget()}}),QLayout=Vue.extend({name:"QLayout",mixins:[ListenersMixin],provide(){return{layout:this}},props:{container:Boolean,view:{type:String,default:"hhh lpr fff",validator:t=>/^(h|l)h(h|r) lpr (f|l)f(f|r)$/.test(t.toLowerCase())}},data(){return{height:this.$q.screen.height,width:!0===this.container?0:this.$q.screen.width,containerHeight:0,scrollbarWidth:!0===onSSR?0:getScrollbarWidth(),header:{size:0,offset:0,space:!1},right:{size:300,offset:0,space:!1},footer:{size:0,offset:0,space:!1},left:{size:300,offset:0,space:!1},scroll:{position:0,direction:"down"}}},computed:{rows(){const t=this.view.toLowerCase().split(" ");return{top:t[0].split(""),middle:t[1].split(""),bottom:t[2].split("")}},style(){return!0===this.container?null:{minHeight:this.$q.screen.height+"px"}},targetStyle(){if(0!==this.scrollbarWidth)return{[!0===this.$q.lang.rtl?"left":"right"]:`${this.scrollbarWidth}px`}},targetChildStyle(){if(0!==this.scrollbarWidth)return{[!0===this.$q.lang.rtl?"right":"left"]:0,[!0===this.$q.lang.rtl?"left":"right"]:`-${this.scrollbarWidth}px`,width:`calc(100% + ${this.scrollbarWidth}px)`}},totalWidth(){return this.width+this.scrollbarWidth},classes(){return"q-layout q-layout--"+(!0===this.container?"containerized":"standard")}},created(){this.instances={}},render(t){const e=t("div",{class:this.classes,style:this.style,on:{...this.qListeners}},mergeSlot([t(QScrollObserver,{on:cache(this,"scroll",{scroll:this.__onPageScroll})}),t(QResizeObserver,{on:cache(this,"resizeOut",{resize:this.__onPageResize})})],this,"default"));return!0===this.container?t("div",{staticClass:"q-layout-container overflow-hidden"},[t(QResizeObserver,{on:cache(this,"resizeIn",{resize:this.__onContainerResize})}),t("div",{staticClass:"absolute-full",style:this.targetStyle},[t("div",{staticClass:"scroll",style:this.targetChildStyle},[e])])]):e},methods:{__animate(){void 0!==this.timer?clearTimeout(this.timer):document.body.classList.add("q-body--layout-animate"),this.timer=setTimeout(()=>{document.body.classList.remove("q-body--layout-animate"),this.timer=void 0},150)},__onPageScroll(t){!0!==this.container&&!0===document.qScrollPrevented||(this.scroll=t),void 0!==this.qListeners.scroll&&this.$emit("scroll",t)},__onPageResize({height:t,width:e}){let i=!1;this.height!==t&&(i=!0,this.height=t,void 0!==this.qListeners["scroll-height"]&&this.$emit("scroll-height",t),this.__updateScrollbarWidth()),this.width!==e&&(i=!0,this.width=e),!0===i&&void 0!==this.qListeners.resize&&this.$emit("resize",{height:t,width:e})},__onContainerResize({height:t}){this.containerHeight!==t&&(this.containerHeight=t,this.__updateScrollbarWidth())},__updateScrollbarWidth(){if(!0===this.container){const t=this.height>this.containerHeight?getScrollbarWidth():0;this.scrollbarWidth!==t&&(this.scrollbarWidth=t)}}}}),QMarkupTable=Vue.extend({name:"QMarkupTable",mixins:[DarkMixin,ListenersMixin],props:{dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,separator:{type:String,default:"horizontal",validator:t=>["horizontal","vertical","cell","none"].includes(t)},wrapCells:Boolean},computed:{classes(){return`q-table--${this.separator}-separator`+(!0===this.isDark?" q-table--dark q-table__card--dark q-dark":"")+(!0===this.dense?" q-table--dense":"")+(!0===this.flat?" q-table--flat":"")+(!0===this.bordered?" q-table--bordered":"")+(!0===this.square?" q-table--square":"")+(!1===this.wrapCells?" q-table--no-wrap":"")}},render(t){return t("div",{staticClass:"q-markup-table q-table__container q-table__card",class:this.classes,on:{...this.qListeners}},[t("table",{staticClass:"q-table"},slot(this,"default"))])}}),QNoSsr=Vue.extend({name:"QNoSsr",mixins:[CanRenderMixin,TagMixin,ListenersMixin],props:{placeholder:String},render(t){const e={on:{...this.qListeners}};if(!0===this.canRender){const i=slot(this,"default");return void 0===i?i:i.length>1?t(this.tag,e,i):i[0]}e.staticClass="q-no-ssr-placeholder";const i=slot(this,"placeholder");return void 0!==i?i.length>1?t(this.tag,e,i):i[0]:void 0!==this.placeholder?t(this.tag,e,[this.placeholder]):void 0}}),QRadio=Vue.extend({name:"QRadio",mixins:[DarkMixin,OptionSizeMixin,FormMixin,RefocusTargetMixin],props:{value:{required:!0},val:{required:!0},label:String,leftLabel:Boolean,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},computed:{isTrue(){return this.value===this.val},classes(){return"q-radio cursor-pointer no-outline row inline no-wrap items-center"+(!0===this.disable?" disabled":"")+(!0===this.isDark?" q-radio--dark":"")+(!0===this.dense?" q-radio--dense":"")+(!0===this.leftLabel?" reverse":"")},innerClass(){const t=void 0===this.color||!0!==this.keepColor&&!0!==this.isTrue?"":` text-${this.color}`;return`q-radio__inner--${!0===this.isTrue?"truthy":"falsy"}${t}`},computedTabindex(){return!0===this.disable?-1:this.tabindex||0},formAttrs(){const t={type:"radio"};return void 0!==this.name&&Object.assign(t,{name:this.name,value:this.val}),t},formDomProps(){if(void 0!==this.name&&!0===this.isTrue)return{checked:!0}},attrs(){const t={tabindex:this.computedTabindex,role:"radio","aria-label":this.label,"aria-checked":!0===this.isTrue?"true":"false"};return!0===this.disable&&(t["aria-disabled"]=""),t}},methods:{set(t){void 0!==t&&(stopAndPrevent(t),this.__refocusTarget(t)),!0!==this.disable&&!0!==this.isTrue&&this.$emit("input",this.val,t)}},render(t){const e=[t("svg",{staticClass:"q-radio__bg absolute",attrs:{focusable:"false",viewBox:"0 0 24 24"}},[t("path",{attrs:{d:"M12,22a10,10 0 0 1 -10,-10a10,10 0 0 1 10,-10a10,10 0 0 1 10,10a10,10 0 0 1 -10,10m0,-22a12,12 0 0 0 -12,12a12,12 0 0 0 12,12a12,12 0 0 0 12,-12a12,12 0 0 0 -12,-12"}}),t("path",{staticClass:"q-radio__check",attrs:{d:"M12,6a6,6 0 0 0 -6,6a6,6 0 0 0 6,6a6,6 0 0 0 6,-6a6,6 0 0 0 -6,-6"}})])];!0!==this.disable&&this.__injectFormInput(e,"unshift","q-radio__native q-ma-none q-pa-none invisible");const i=[t("div",{staticClass:"q-radio__inner relative-position no-pointer-events",class:this.innerClass,style:this.sizeStyle},e)];void 0!==this.__refocusTargetEl&&i.push(this.__refocusTargetEl);const s=void 0!==this.label?mergeSlot([this.label],this,"default"):slot(this,"default");return void 0!==s&&i.push(t("div",{staticClass:"q-radio__label q-anchor--skip"},s)),t("div",{class:this.classes,attrs:this.attrs,on:cache(this,"inpExt",{click:this.set,keydown:t=>{13!==t.keyCode&&32!==t.keyCode||stopAndPrevent(t)},keyup:t=>{13!==t.keyCode&&32!==t.keyCode||this.set(t)}})},i)}}),QToggle=Vue.extend({name:"QToggle",mixins:[CheckboxMixin],props:{icon:String,checkedIcon:String,uncheckedIcon:String,indeterminateIcon:String,iconColor:String},computed:{computedIcon(){return(!0===this.isTrue?this.checkedIcon:!0===this.isIndeterminate?this.indeterminateIcon:this.uncheckedIcon)||this.icon},computedIconColor(){if(!0===this.isTrue)return this.iconColor}},methods:{__getInner(t){return[t("div",{staticClass:"q-toggle__track"}),t("div",{staticClass:"q-toggle__thumb absolute flex flex-center no-wrap"},void 0!==this.computedIcon?[t(QIcon,{props:{name:this.computedIcon,color:this.computedIconColor}})]:void 0)]}},created(){this.type="toggle"}});const components={radio:QRadio,checkbox:QCheckbox,toggle:QToggle},typeValues=Object.keys(components);var QOptionGroup=Vue.extend({name:"QOptionGroup",mixins:[DarkMixin,ListenersMixin],props:{value:{required:!0},options:{type:Array,validator:t=>t.every(t=>"value"in t&&"label"in t)},name:String,type:{default:"radio",validator:t=>typeValues.includes(t)},color:String,keepColor:Boolean,dense:Boolean,size:String,leftLabel:Boolean,inline:Boolean,disable:Boolean},computed:{component(){return components[this.type]},model(){return Array.isArray(this.value)?this.value.slice():this.value},classes(){return"q-option-group q-gutter-x-sm"+(!0===this.inline?" q-option-group--inline":"")},attrs(){if("radio"===this.type){const t={role:"radiogroup"};return!0===this.disable&&(t["aria-disabled"]=""),t}}},methods:{__update(t){this.$emit("input",t)}},created(){const t=Array.isArray(this.value);"radio"===this.type?t&&console.error("q-option-group: model should not be array"):!1===t&&console.error("q-option-group: model should be array in your case")},render(t){return t("div",{class:this.classes,attrs:this.attrs,on:{...this.qListeners}},this.options.map(e=>t("div",[t(this.component,{props:{value:this.value,val:e.value,name:this.name||e.name,disable:this.disable||e.disable,label:e.label,leftLabel:this.leftLabel||e.leftLabel,color:e.color||this.color,checkedIcon:e.checkedIcon,uncheckedIcon:e.uncheckedIcon,dark:e.dark||this.isDark,size:e.size||this.size,dense:this.dense,keepColor:e.keepColor||this.keepColor},on:cache(this,"inp",{input:this.__update})})])))}}),QPage=Vue.extend({name:"QPage",mixins:[ListenersMixin],inject:{pageContainer:{default(){console.error("QPage needs to be child of QPageContainer")}},layout:{}},props:{padding:Boolean,styleFn:Function},computed:{style(){const t=(!0===this.layout.header.space?this.layout.header.size:0)+(!0===this.layout.footer.space?this.layout.footer.size:0);if("function"==typeof this.styleFn){const e=!0===this.layout.container?this.layout.containerHeight:this.$q.screen.height;return this.styleFn(t,e)}return{minHeight:!0===this.layout.container?this.layout.containerHeight-t+"px":0===this.$q.screen.height?`calc(100vh - ${t}px)`:this.$q.screen.height-t+"px"}},classes(){if(!0===this.padding)return"q-layout-padding"}},render(t){return t("main",{staticClass:"q-page",style:this.style,class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QPageContainer=Vue.extend({name:"QPageContainer",mixins:[ListenersMixin],inject:{layout:{default(){console.error("QPageContainer needs to be child of QLayout")}}},provide:{pageContainer:!0},computed:{style(){const t={};return!0===this.layout.header.space&&(t.paddingTop=`${this.layout.header.size}px`),!0===this.layout.right.space&&(t[`padding${!0===this.$q.lang.rtl?"Left":"Right"}`]=`${this.layout.right.size}px`),!0===this.layout.footer.space&&(t.paddingBottom=`${this.layout.footer.size}px`),!0===this.layout.left.space&&(t[`padding${!0===this.$q.lang.rtl?"Right":"Left"}`]=`${this.layout.left.size}px`),t}},render(t){return t("div",{staticClass:"q-page-container",style:this.style,on:{...this.qListeners}},slot(this,"default"))}}),QPageSticky=Vue.extend({name:"QPageSticky",mixins:[ListenersMixin],inject:{layout:{default(){console.error("QPageSticky needs to be child of QLayout")}}},props:{position:{type:String,default:"bottom-right",validator:t=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(t)},offset:{type:Array,validator:t=>2===t.length},expand:Boolean},computed:{attach(){const t=this.position;return{top:t.indexOf("top")>-1,right:t.indexOf("right")>-1,bottom:t.indexOf("bottom")>-1,left:t.indexOf("left")>-1,vertical:"top"===t||"bottom"===t,horizontal:"left"===t||"right"===t}},top(){return this.layout.header.offset},right(){return this.layout.right.offset},bottom(){return this.layout.footer.offset},left(){return this.layout.left.offset},style(){let t=0,e=0;const i=this.attach,s=!0===this.$q.lang.rtl?-1:1;!0===i.top&&0!==this.top?e=`${this.top}px`:!0===i.bottom&&0!==this.bottom&&(e=`${-this.bottom}px`),!0===i.left&&0!==this.left?t=`${s*this.left}px`:!0===i.right&&0!==this.right&&(t=`${-s*this.right}px`);const o={transform:`translate(${t}, ${e})`};return this.offset&&(o.margin=`${this.offset[1]}px ${this.offset[0]}px`),!0===i.vertical?(0!==this.left&&(o[!0===this.$q.lang.rtl?"right":"left"]=`${this.left}px`),0!==this.right&&(o[!0===this.$q.lang.rtl?"left":"right"]=`${this.right}px`)):!0===i.horizontal&&(0!==this.top&&(o.top=`${this.top}px`),0!==this.bottom&&(o.bottom=`${this.bottom}px`)),o},classes(){return`fixed-${this.position} q-page-sticky--${!0===this.expand?"expand":"shrink"}`}},render(t){const e=slot(this,"default");return t("div",{staticClass:"q-page-sticky row flex-center",class:this.classes,style:this.style,on:{...this.qListeners}},!0===this.expand?e:[t("div",e)])}}),QPageScroller=Vue.extend({name:"QPageScroller",mixins:[QPageSticky],props:{scrollOffset:{type:Number,default:1e3},reverse:Boolean,duration:{type:Number,default:300},offset:{default:()=>[18,18]}},inject:{layout:{default(){console.error("QPageScroller needs to be used within a QLayout")}}},data(){return{showing:this.__isVisible()}},computed:{height(){return!0===this.layout.container?this.layout.containerHeight:this.layout.height},onEvents(){return{...this.qListeners,click:this.__onClick}}},watch:{"layout.scroll.position"(){this.__updateVisibility()},reverse:{handler(t){!0===t?void 0===this.heightWatcher&&(this.heightWatcher=this.$watch("height",this.__updateVisibility)):void 0!==this.heightWatcher&&this.__cleanup()},immediate:!0}},methods:{__isVisible(){return!0===this.reverse?this.height-this.layout.scroll.position>this.scrollOffset:this.layout.scroll.position>this.scrollOffset},__onClick(t){setScrollPosition(!0===this.layout.container?getScrollTarget(this.$el):getScrollTarget(this.layout.$el),!0===this.reverse?this.layout.height:0,this.duration),this.$emit("click",t)},__updateVisibility(){const t=this.__isVisible();this.showing!==t&&(this.showing=t)},__cleanup(){this.heightWatcher(),this.heightWatcher=void 0}},render(t){return t("transition",{props:{name:"q-transition--fade"}},!0===this.showing?[t("div",{staticClass:"q-page-scroller",on:this.onEvents},[QPageSticky.options.render.call(this,t)])]:null)},beforeDestroy(){void 0!==this.heightWatcher&&this.__cleanup()}}),QPagination=Vue.extend({name:"QPagination",mixins:[DarkMixin,ListenersMixin],props:{value:{type:Number,required:!0},min:{type:Number,default:1},max:{type:Number,required:!0},color:{type:String,default:"primary"},textColor:String,inputStyle:[Array,String,Object],inputClass:[Array,String,Object],size:String,disable:Boolean,input:Boolean,iconPrev:String,iconNext:String,iconFirst:String,iconLast:String,toFn:Function,boundaryLinks:{type:Boolean,default:null},boundaryNumbers:{type:Boolean,default:null},directionLinks:{type:Boolean,default:null},ellipses:{type:Boolean,default:null},maxPages:{type:Number,default:0,validator:t=>t>=0},ripple:{type:[Boolean,Object],default:null}},data:()=>({newPage:null}),watch:{min(){this.model=this.value},max(){this.model=this.value}},computed:{model:{get(){return this.value},set(t){if(t=parseInt(t,10),this.disable||isNaN(t)||0===t)return;const e=between(t,this.min,this.max);this.$emit("input",e)}},inputPlaceholder(){return this.model+" / "+this.max},__boundaryLinks(){return this.__getBool(this.boundaryLinks,this.input)},__boundaryNumbers(){return this.__getBool(this.boundaryNumbers,!this.input)},__directionLinks(){return this.__getBool(this.directionLinks,this.input)},__ellipses(){return this.__getBool(this.ellipses,!this.input)},icons(){const t=[this.iconFirst||this.$q.iconSet.pagination.first,this.iconPrev||this.$q.iconSet.pagination.prev,this.iconNext||this.$q.iconSet.pagination.next,this.iconLast||this.$q.iconSet.pagination.last];return!0===this.$q.lang.rtl?t.reverse():t},attrs(){if(!0===this.disable)return{"aria-disabled":""}},btnProps(){return{color:this.color,flat:!0,size:this.size,ripple:null===this.ripple||this.ripple}}},methods:{set(t){this.model=t},setByOffset(t){this.model=this.model+t},__update(){this.model=this.newPage,this.newPage=null},__getBool:(t,e)=>[!0,!1].includes(t)?t:e,__getBtn(t,e,i,s){return e.props={...this.btnProps,...i},void 0!==s&&(void 0!==this.toFn?e.props.to=this.toFn(s):e.on={click:()=>this.set(s)}),t(QBtn,e)}},render(t){const e=[],i=[],s=[];if(this.__boundaryLinks&&(e.push(this.__getBtn(t,{key:"bls"},{disable:this.disable||this.value<=this.min,icon:this.icons[0]},this.min)),i.unshift(this.__getBtn(t,{key:"ble"},{disable:this.disable||this.value>=this.max,icon:this.icons[3]},this.max))),this.__directionLinks&&(e.push(this.__getBtn(t,{key:"bdp"},{disable:this.disable||this.value<=this.min,icon:this.icons[1]},this.value-1)),i.unshift(this.__getBtn(t,{key:"bdn"},{disable:this.disable||this.value>=this.max,icon:this.icons[2]},this.value+1))),!0===this.input)s.push(t(QInput,{staticClass:"inline",style:{width:`${this.inputPlaceholder.length/1.5}em`},props:{type:"number",dense:!0,value:this.newPage,disable:this.disable,dark:this.isDark,borderless:!0,inputClass:this.inputClass,inputStyle:this.inputStyle},attrs:{placeholder:this.inputPlaceholder,min:this.min,max:this.max},on:cache(this,"inp",{input:t=>{this.newPage=t},keyup:t=>{!0===isKeyCode(t,13)&&this.__update()},blur:this.__update})}));else{let o=Math.max(this.maxPages,1+(this.__ellipses?2:0)+(this.__boundaryNumbers?2:0)),n=this.min,r=this.max,a=!1,l=!1,h=!1,d=!1;this.maxPages&&o<this.max-this.min+1&&(o=1+2*Math.floor(o/2),n=Math.max(this.min,Math.min(this.max-o+1,this.value-Math.floor(o/2))),r=Math.min(this.max,n+o-1),this.__boundaryNumbers&&(h=!0,n+=1),this.__ellipses&&n>this.min+(this.__boundaryNumbers?1:0)&&(a=!0,n+=1),this.__boundaryNumbers&&(d=!0,r-=1),this.__ellipses&&r<this.max-(this.__boundaryNumbers?1:0)&&(l=!0,r-=1));const c={minWidth:`${Math.max(2,String(this.max).length)}em`};if(h){const i=this.min===this.value;e.push(this.__getBtn(t,{key:"bns",style:c},{disable:this.disable,flat:!i,textColor:i?this.textColor:null,label:this.min},this.min))}if(d){const e=this.max===this.value;i.unshift(this.__getBtn(t,{key:"bne",style:c},{disable:this.disable,flat:!e,textColor:e?this.textColor:null,label:this.max},this.max))}a&&e.push(this.__getBtn(t,{key:"bes",style:c},{disable:this.disable,label:"…",ripple:!1},n-1)),l&&i.unshift(this.__getBtn(t,{key:"bee",style:c},{disable:this.disable,label:"…",ripple:!1},r+1));for(let e=n;e<=r;e++){const i=e===this.value;s.push(this.__getBtn(t,{key:`bpg${e}`,style:c},{disable:this.disable,flat:!i,textColor:i?this.textColor:null,label:e},e))}}return t("div",{staticClass:"q-pagination row no-wrap items-center",class:{disabled:this.disable},attrs:this.attrs,on:{...this.qListeners}},[e,t("div",{staticClass:"row justify-center",on:!0===this.input?cache(this,"stop",{input:stop}):null},[s]),i])}});function frameDebounce(t){let e,i,s=!1;function o(){i=arguments,!0!==s&&(s=!0,e=requestAnimationFrame(()=>{t.apply(this,i),i=void 0,s=!1}))}return o.cancel=(()=>{window.cancelAnimationFrame(e),s=!1}),o}const{passive:passive$2}=listenOpts;var QParallax=Vue.extend({name:"QParallax",mixins:[ListenersMixin],props:{src:String,height:{type:Number,default:500},speed:{type:Number,default:1,validator:t=>t>=0&&t<=1},scrollTarget:{default:void 0}},data:()=>({scrolling:!1,percentScrolled:0}),watch:{height(){!0===this.working&&this.__updatePos()},scrollTarget(){!0===this.working&&(this.__stop(),this.__start())}},methods:{__update(t){this.percentScrolled=t,void 0!==this.qListeners.scroll&&this.$emit("scroll",t)},__updatePos(){let t,e,i;this.__scrollTarget===window?(t=0,i=e=window.innerHeight):i=(t=offset(this.__scrollTarget).top)+(e=height(this.__scrollTarget));const s=offset(this.$el).top,o=s+this.height;if(void 0!==this.observer||o>t&&s<i){const t=(i-s)/(this.height+e);this.__setPos((this.mediaHeight-this.height)*t*this.speed),this.__update(t)}},__setPos(t){this.media.style.transform=`translate3D(-50%,${Math.round(t)}px, 0)`},__onResize(){this.mediaHeight=this.media.naturalHeight||this.media.videoHeight||height(this.media),!0===this.working&&this.__updatePos()},__start(){this.working=!0,this.__scrollTarget=getScrollTarget(this.$el,this.scrollTarget),this.__scrollTarget.addEventListener("scroll",this.__updatePos,passive$2),window.addEventListener("resize",this.__resizeHandler,passive$2),this.__updatePos()},__stop(){!0===this.working&&(this.working=!1,this.__scrollTarget.removeEventListener("scroll",this.__updatePos,passive$2),window.removeEventListener("resize",this.__resizeHandler,passive$2),this.__scrollTarget=void 0)}},render(t){return t("div",{staticClass:"q-parallax",style:{height:`${this.height}px`},on:{...this.qListeners}},[t("div",{ref:"mediaParent",staticClass:"q-parallax__media absolute-full"},void 0!==this.$scopedSlots.media?this.$scopedSlots.media():[t("img",{ref:"media",attrs:{src:this.src}})]),t("div",{staticClass:"q-parallax__content absolute-full column flex-center"},void 0!==this.$scopedSlots.content?this.$scopedSlots.content({percentScrolled:this.percentScrolled}):slot(this,"default"))])},mounted(){this.__setPos=frameDebounce(this.__setPos),this.__update=frameDebounce(this.__update),this.__resizeHandler=frameDebounce(this.__onResize),this.media=void 0!==this.$scopedSlots.media?this.$refs.mediaParent.children[0]:this.$refs.media,this.media.onload=this.media.onloadstart=this.media.loadedmetadata=this.__onResize,this.__onResize(),this.media.style.display="initial",void 0!==window.IntersectionObserver?(this.observer=new IntersectionObserver(t=>{this[!0===t[0].isIntersecting?"__start":"__stop"]()}),this.observer.observe(this.$el)):this.__start()},beforeDestroy(){this.__stop(),void 0!==this.observer&&this.observer.disconnect(),this.media.onload=this.media.onloadstart=this.media.loadedmetadata=null}});function clone$1(t){const e=JSON.stringify(t);if(e)return JSON.parse(e)}var QPopupEdit=Vue.extend({name:"QPopupEdit",mixins:[AttrsMixin],props:{value:{required:!0},title:String,buttons:Boolean,labelSet:String,labelCancel:String,color:{type:String,default:"primary"},validate:{type:Function,default:()=>!0},autoSave:Boolean,cover:{type:Boolean,default:!0},contentClass:String,disable:Boolean},data:()=>({initialValue:""}),computed:{classes(){return"q-popup-edit"+(void 0!==this.contentClass?` ${this.contentClass}`:"")},defaultSlotScope(){return{initialValue:this.initialValue,value:this.value,emitValue:this.__emitValue,validate:this.validate,set:this.set,cancel:this.cancel}},menuProps(){return{...this.qAttrs,cover:this.cover,contentClass:this.classes}}},methods:{set(){if(!0===this.__hasChanged()){if(!1===this.validate(this.value))return;this.$emit("save",this.value,this.initialValue)}this.__close()},cancel(){!0===this.__hasChanged()&&(this.$emit("input",this.initialValue),this.$emit("cancel",this.value,this.initialValue)),this.__close()},show(t){void 0!==this.$refs.menu&&this.$refs.menu.show(t)},hide(t){void 0!==this.$refs.menu&&this.$refs.menu.hide(t)},__hasChanged(){return!1===isDeepEqual(this.value,this.initialValue)},__emitValue(t){!0!==this.disable&&this.$emit("input",t)},__close(){this.validated=!0,!0===this.$refs.menu.showing&&this.$refs.menu.hide()},__reposition(){this.$nextTick(()=>{this.$refs.menu.updatePosition()})},__getContent(t){const e=slot(this,"title",this.title),i=void 0===this.$scopedSlots.default?[]:this.$scopedSlots.default(this.defaultSlotScope).slice();return e&&i.unshift(t("div",{staticClass:"q-dialog__title q-mt-sm q-mb-sm"},[e])),!0===this.buttons&&i.push(t("div",{staticClass:"q-popup-edit__buttons row justify-center no-wrap"},[t(QBtn,{props:{flat:!0,color:this.color,label:this.labelCancel||this.$q.lang.label.cancel},on:cache(this,"cancel",{click:this.cancel})}),t(QBtn,{props:{flat:!0,color:this.color,label:this.labelSet||this.$q.lang.label.set},on:cache(this,"ok",{click:this.set})})])),i}},render(t){if(!0!==this.disable)return t(QMenu,{ref:"menu",props:this.menuProps,on:cache(this,"menu",{"before-show":()=>{this.validated=!1,this.initialValue=clone$1(this.value),this.watcher=this.$watch("value",this.__reposition),this.$emit("before-show")},show:()=>{this.$emit("show")},"escape-key":this.cancel,"before-hide":()=>{this.watcher(),!1===this.validated&&!0===this.__hasChanged()&&(!0===this.autoSave&&!0===this.validate(this.value)?this.$emit("save",this.value,this.initialValue):(this.$emit("cancel",this.value,this.initialValue),this.$emit("input",this.initialValue))),this.$emit("before-hide")},hide:()=>{this.$emit("hide")},keyup:t=>{!0===isKeyCode(t,13)&&this.set()}})},this.__getContent(t))}}),QPopupProxy=Vue.extend({name:"QPopupProxy",mixins:[AttrsMixin,ListenersMixin,AnchorMixin],props:{breakpoint:{type:[String,Number],default:450}},data(){const t=parseInt(this.breakpoint,10);return{type:this.$q.screen.width<t||this.$q.screen.height<t?"dialog":"menu"}},computed:{parsedBreakpoint(){return parseInt(this.breakpoint,10)},onEvents(){return{...this.qListeners,hide:this.__onHide}}},watch:{"$q.screen.width"(t){!0!==this.$refs.popup.showing&&this.__updateType(t,this.$q.screen.height,this.parsedBreakpoint)},"$q.screen.height"(t){!0!==this.$refs.popup.showing&&this.__updateType(this.$q.screen.width,t,this.parsedBreakpoint)},breakpoint(t){!0!==this.$refs.popup.showing&&this.__updateType(this.$q.screen.width,this.$q.screen.height,parseInt(t,10))}},methods:{toggle(t){this.$refs.popup.toggle(t)},show(t){this.$refs.popup.show(t)},hide(t){this.$refs.popup.hide(t)},__onHide(t){this.__updateType(this.$q.screen.width,this.$q.screen.height,this.parsedBreakpoint),this.$emit("hide",t)},__updateType(t,e,i){const s=t<i||e<i?"dialog":"menu";this.type!==s&&(this.type=s)}},render(t){const e=slot(this,"default"),i={ref:"popup",props:{..."menu"===this.type&&void 0!==e&&void 0!==e[0]&&void 0!==e[0].componentOptions&&void 0!==e[0].componentOptions.Ctor&&void 0!==e[0].componentOptions.Ctor.sealedOptions&&["QDate","QTime","QCarousel","QColor"].includes(e[0].componentOptions.Ctor.sealedOptions.name)?{cover:!0,maxHeight:"99vh"}:{},...this.qAttrs},on:this.onEvents};let s;return"dialog"===this.type?s=QDialog:(s=QMenu,i.props.target=this.target,i.props.contextMenu=this.contextMenu,i.props.noParentEvent=!0,i.props.separateClosePopup=!0),t(s,i,e)}});function width$1(t,e){return!0===e?{transform:`translateX(100%) scale3d(${-t},1,1)`}:{transform:`scale3d(${t},1,1)`}}var QLinearProgress=Vue.extend({name:"QLinearProgress",mixins:[ListenersMixin,DarkMixin,getSizeMixin({xs:2,sm:4,md:6,lg:10,xl:14})],props:{value:{type:Number,default:0},buffer:Number,color:String,trackColor:String,reverse:Boolean,stripe:Boolean,indeterminate:Boolean,query:Boolean,rounded:Boolean,instantFeedback:Boolean},computed:{motion(){return!0===this.indeterminate||!0===this.query},classes(){return"q-linear-progress"+(void 0!==this.color?` text-${this.color}`:"")+(!0===this.reverse||!0===this.query?" q-linear-progress--reverse":"")+(!0===this.rounded?" rounded-borders":"")},trackStyle(){return width$1(void 0!==this.buffer?this.buffer:1,this.reverse)},trackClass(){return`q-linear-progress__track--with${!0===this.instantFeedback?"out":""}-transition`+` q-linear-progress__track--${!0===this.isDark?"dark":"light"}`+(void 0!==this.trackColor?` bg-${this.trackColor}`:"")},modelStyle(){return width$1(!0===this.motion?1:this.value,this.reverse)},modelClasses(){return`q-linear-progress__model--with${!0===this.instantFeedback?"out":""}-transition`+` q-linear-progress__model--${!0===this.motion?"in":""}determinate`},stripeStyle(){return{width:100*this.value+"%"}},attrs(){return{role:"progressbar","aria-valuemin":0,"aria-valuemax":1,"aria-valuenow":!0===this.indeterminate?void 0:this.value}}},render(t){const e=[t("div",{staticClass:"q-linear-progress__track absolute-full",style:this.trackStyle,class:this.trackClass}),t("div",{staticClass:"q-linear-progress__model absolute-full",style:this.modelStyle,class:this.modelClasses})];return!0===this.stripe&&!1===this.motion&&e.push(t("div",{staticClass:"q-linear-progress__stripe absolute-full",style:this.stripeStyle})),t("div",{style:this.sizeStyle,class:this.classes,attrs:this.attrs,on:{...this.qListeners}},mergeSlot(e,this,"default"))}});const PULLER_HEIGHT=40,OFFSET_TOP=20;var QPullToRefresh=Vue.extend({name:"QPullToRefresh",mixins:[ListenersMixin],directives:{TouchPan:TouchPan},props:{color:String,bgColor:String,icon:String,noMouse:Boolean,disable:Boolean,scrollTarget:{default:void 0}},data:()=>({state:"pull",pullRatio:0,pulling:!1,pullPosition:-40,animating:!1,positionCSS:{}}),computed:{style(){return{opacity:this.pullRatio,transform:`translateY(${this.pullPosition}px) rotate(${360*this.pullRatio}deg)`}},classes(){return"q-pull-to-refresh__puller row flex-center"+(!0===this.animating?" q-pull-to-refresh__puller--animating":"")+(void 0!==this.bgColor?` bg-${this.bgColor}`:"")},directives(){if(!0!==this.disable)return[{name:"touch-pan",modifiers:{down:!0,mightPrevent:!0,mouse:!0!==this.noMouse},value:this.__pull}]},contentClass(){return`q-pull-to-refresh__content${!0===this.pulling?" no-pointer-events":""}`}},watch:{scrollTarget(){this.updateScrollTarget()}},methods:{trigger(){this.$emit("refresh",()=>{this.__animateTo({pos:-40,ratio:0},()=>{this.state="pull"})})},updateScrollTarget(){this.__scrollTarget=getScrollTarget(this.$el,this.scrollTarget)},__pull(t){if(!0===t.isFinal)return void(!0===this.pulling&&(this.pulling=!1,"pulled"===this.state?(this.state="refreshing",this.__animateTo({pos:20}),this.trigger()):"pull"===this.state&&this.__animateTo({pos:-40,ratio:0})));if(!0===this.animating||"refreshing"===this.state)return!1;if(!0===t.isFirst){if(0!==getScrollPosition(this.__scrollTarget))return!0===this.pulling&&(this.pulling=!1,this.state="pull",this.__animateTo({pos:-40,ratio:0})),!1;this.pulling=!0;const{top:t,left:e}=this.$el.getBoundingClientRect();this.positionCSS={top:t+"px",left:e+"px",width:window.getComputedStyle(this.$el).getPropertyValue("width")}}prevent(t.evt);const e=Math.min(140,Math.max(0,t.distance.y));this.pullPosition=e-40,this.pullRatio=between(e/60,0,1);const i=this.pullPosition>20?"pulled":"pull";this.state!==i&&(this.state=i)},__animateTo({pos:t,ratio:e},i){this.animating=!0,this.pullPosition=t,void 0!==e&&(this.pullRatio=e),clearTimeout(this.timer),this.timer=setTimeout(()=>{this.animating=!1,i&&i()},300)}},mounted(){this.updateScrollTarget()},beforeDestroy(){clearTimeout(this.timer)},render(t){return t("div",{staticClass:"q-pull-to-refresh",on:{...this.qListeners},directives:this.directives},[t("div",{class:this.contentClass},slot(this,"default")),t("div",{staticClass:"q-pull-to-refresh__puller-container fixed row flex-center no-pointer-events z-top",style:this.positionCSS},[t("div",{style:this.style,class:this.classes},["refreshing"!==this.state?t(QIcon,{props:{name:this.icon||this.$q.iconSet.pullToRefresh.icon,color:this.color,size:"32px"}}):t(QSpinner,{props:{size:"24px",color:this.color}})])])])}});const dragType={MIN:0,RANGE:1,MAX:2};var QRange=Vue.extend({name:"QRange",mixins:[SliderMixin],props:{value:{type:Object,default:()=>({min:null,max:null}),validator:t=>"min"in t&&"max"in t},name:String,dragRange:Boolean,dragOnlyRange:Boolean,leftLabelColor:String,leftLabelTextColor:String,rightLabelColor:String,rightLabelTextColor:String,leftLabelValue:[String,Number],rightLabelValue:[String,Number]},data(){return{model:{min:null===this.value.min?this.min:this.value.min,max:null===this.value.max?this.max:this.value.max},curMinRatio:0,curMaxRatio:0}},watch:{"value.min"(t){this.model.min=null===t?this.min:t},"value.max"(t){this.model.max=null===t?this.max:t},min(t){this.model.min<t&&(this.model.min=t),this.model.max<t&&(this.model.max=t)},max(t){this.model.min>t&&(this.model.min=t),this.model.max>t&&(this.model.max=t)}},computed:{ratioMin(){return!0===this.active?this.curMinRatio:this.modelMinRatio},ratioMax(){return!0===this.active?this.curMaxRatio:this.modelMaxRatio},modelMinRatio(){return(this.model.min-this.min)/(this.max-this.min)},modelMaxRatio(){return(this.model.max-this.min)/(this.max-this.min)},trackStyle(){return{[this.positionProp]:`${100*this.ratioMin}%`,[this.sizeProp]:`${100*(this.ratioMax-this.ratioMin)}%`}},minThumbStyle(){return{[this.positionProp]:`${100*this.ratioMin}%`,"z-index":"min"===this.__nextFocus?2:void 0}},maxThumbStyle(){return{[this.positionProp]:`${100*this.ratioMax}%`}},minThumbClass(){if(!1===this.preventFocus&&"min"===this.focus)return"q-slider--focus"},maxThumbClass(){if(!1===this.preventFocus&&"max"===this.focus)return"q-slider--focus"},events(){if(!0===this.editable){if(!0===this.$q.platform.is.mobile)return{click:this.__mobileClick};const t={mousedown:this.__activate};return!0===this.dragOnlyRange&&Object.assign(t,{focus:()=>{this.__focus("both")},blur:this.__blur,keydown:this.__keydown,keyup:this.__keyup}),t}},minEvents(){if(!0===this.editable&&!0!==this.$q.platform.is.mobile&&!0!==this.dragOnlyRange)return{focus:()=>{this.__focus("min")},blur:this.__blur,keydown:this.__keydown,keyup:this.__keyup}},maxEvents(){if(!0===this.editable&&!0!==this.$q.platform.is.mobile&&!0!==this.dragOnlyRange)return{focus:()=>{this.__focus("max")},blur:this.__blur,keydown:this.__keydown,keyup:this.__keyup}},minPinClass(){const t=this.leftLabelColor||this.labelColor;if(t)return`text-${t}`},minPinTextClass(){const t=this.leftLabelTextColor||this.labelTextColor;if(t)return`text-${t}`},maxPinClass(){const t=this.rightLabelColor||this.labelColor;if(t)return`text-${t}`},maxPinTextClass(){const t=this.rightLabelTextColor||this.labelTextColor;if(t)return`text-${t}`},minLabel(){return void 0!==this.leftLabelValue?this.leftLabelValue:this.model.min},maxLabel(){return void 0!==this.rightLabelValue?this.rightLabelValue:this.model.max},minPinStyle(){const t=!0===this.reverse?-this.ratioMin:this.ratioMin-1;return this.__getPinStyle(t,this.ratioMin)},maxPinStyle(){const t=!0===this.reverse?-this.ratioMax:this.ratioMax-1;return this.__getPinStyle(t,this.ratioMax)},formAttrs(){return{type:"hidden",name:this.name,value:`${this.value.min}|${this.value.max}`}}},methods:{__updateValue(t){this.model.min===this.value.min&&this.model.max===this.value.max||this.$emit("input",this.model),!0===t&&this.$emit("change",this.model)},__getDragging(t){const{left:e,top:i,width:s,height:o}=this.$el.getBoundingClientRect(),n=!0===this.dragOnlyRange?0:!0===this.vertical?this.$refs.minThumb.offsetHeight/(2*o):this.$refs.minThumb.offsetWidth/(2*s),r=this.max-this.min,a={left:e,top:i,width:s,height:o,valueMin:this.model.min,valueMax:this.model.max,ratioMin:(this.model.min-this.min)/r,ratioMax:(this.model.max-this.min)/r},l=getRatio(t,a,this.isReversed,this.vertical);let h;return!0!==this.dragOnlyRange&&l<a.ratioMin+n?h=dragType.MIN:!0===this.dragOnlyRange||l<a.ratioMax-n?!0===this.dragRange||!0===this.dragOnlyRange?(h=dragType.RANGE,Object.assign(a,{offsetRatio:l,offsetModel:getModel(l,this.min,this.max,this.step,this.decimals),rangeValue:a.valueMax-a.valueMin,rangeRatio:a.ratioMax-a.ratioMin})):h=a.ratioMax-l<l-a.ratioMin?dragType.MAX:dragType.MIN:h=dragType.MAX,a.type=h,this.__nextFocus=void 0,a},__updatePosition(t,e=this.dragging){const i=getRatio(t,e,this.isReversed,this.vertical),s=getModel(i,this.min,this.max,this.step,this.decimals);let o;switch(e.type){case dragType.MIN:i<=e.ratioMax?(o={minR:i,maxR:e.ratioMax,min:s,max:e.valueMax},this.__nextFocus="min"):(o={minR:e.ratioMax,maxR:i,min:e.valueMax,max:s},this.__nextFocus="max");break;case dragType.MAX:i>=e.ratioMin?(o={minR:e.ratioMin,maxR:i,min:e.valueMin,max:s},this.__nextFocus="max"):(o={minR:i,maxR:e.ratioMin,min:s,max:e.valueMin},this.__nextFocus="min");break;case dragType.RANGE:const t=i-e.offsetRatio,n=between(e.ratioMin+t,0,1-e.rangeRatio),r=s-e.offsetModel,a=between(e.valueMin+r,this.min,this.max-e.rangeValue);o={minR:n,maxR:n+e.rangeRatio,min:parseFloat(a.toFixed(this.decimals)),max:parseFloat((a+e.rangeValue).toFixed(this.decimals))}}if(this.model={min:o.min,max:o.max},null!==this.model.min&&null!==this.model.max||(this.model.min=o.min||this.min,this.model.max=o.max||this.max),!0!==this.snap||0===this.step)this.curMinRatio=o.minR,this.curMaxRatio=o.maxR;else{const t=this.max-this.min;this.curMinRatio=(this.model.min-this.min)/t,this.curMaxRatio=(this.model.max-this.min)/t}},__focus(t){this.focus=t},__keydown(t){if(!keyCodes.includes(t.keyCode))return;stopAndPrevent(t);const e=([34,33].includes(t.keyCode)?10:1)*this.computedStep,i=[34,37,40].includes(t.keyCode)?-e:e;if(this.dragOnlyRange){const t=this.dragOnlyRange?this.model.max-this.model.min:0,e=between(parseFloat((this.model.min+i).toFixed(this.decimals)),this.min,this.max-t);this.model={min:e,max:parseFloat((e+t).toFixed(this.decimals))}}else{if(!1===this.focus)return;{const t=this.focus;this.model={...this.model,[t]:between(parseFloat((this.model[t]+i).toFixed(this.decimals)),"min"===t?this.min:this.model.min,"max"===t?this.max:this.model.max)}}}this.__updateValue()},__getThumb(t,e){const i=[this.__getThumbSvg(t),t("div",{staticClass:"q-slider__focus-ring"})];return!0!==this.label&&!0!==this.labelAlways||i.push(t("div",{staticClass:`q-slider__pin q-slider__pin${this.axis} absolute`,style:this[e+"PinStyle"].pin,class:this[e+"PinClass"]},[t("div",{staticClass:`q-slider__pin-text-container q-slider__pin-text-container${this.axis}`,style:this[e+"PinStyle"].pinTextContainer},[t("span",{staticClass:"q-slider__pin-text",class:this[e+"PinTextClass"]},[this[e+"Label"]])])]),t("div",{staticClass:`q-slider__arrow q-slider__arrow${this.axis}`,class:this[e+"PinClass"]})),t("div",{ref:e+"Thumb",staticClass:`q-slider__thumb-container q-slider__thumb-container${this.axis} absolute non-selectable`,style:this[e+"ThumbStyle"],class:this[e+"ThumbClass"],on:this[e+"Events"],attrs:{tabindex:!0!==this.dragOnlyRange?this.computedTabindex:null}},i)}},render(t){const e=[t("div",{staticClass:`q-slider__track q-slider__track${this.axis} absolute`,style:this.trackStyle})];!0===this.markers&&e.push(t("div",{staticClass:`q-slider__track-markers q-slider__track-markers${this.axis} absolute-full fit`,style:this.markerStyle}));const i=[t("div",{staticClass:`q-slider__track-container q-slider__track-container${this.axis} absolute`},e),this.__getThumb(t,"min"),this.__getThumb(t,"max")];return void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(i,"push"),t("div",{staticClass:null===this.value.min||null===this.value.max?"q-slider--no-value":void 0,attrs:{...this.attrs,"aria-valuenow":this.value.min+"|"+this.value.max,tabindex:!0===this.dragOnlyRange&&!0!==this.$q.platform.is.mobile?this.computedTabindex:null},class:this.classes,on:this.events,directives:this.panDirectives},i)}}),QRating=Vue.extend({name:"QRating",mixins:[SizeMixin,FormMixin,ListenersMixin],props:{value:{type:Number,required:!0},max:{type:[String,Number],default:5},icon:[String,Array],iconHalf:[String,Array],iconSelected:[String,Array],color:[String,Array],colorHalf:[String,Array],colorSelected:[String,Array],noReset:Boolean,noDimming:Boolean,readonly:Boolean,disable:Boolean},data:()=>({mouseModel:0}),computed:{editable(){return!0!==this.readonly&&!0!==this.disable},classes(){return`q-rating--${!0===this.editable?"":"non-"}editable`+(!0===this.noDimming?" q-rating--no-dimming":"")+(!0===this.disable?" disabled":"")+(void 0!==this.color&&!1===Array.isArray(this.color)?` text-${this.color}`:"")},iconData(){const t=!0===Array.isArray(this.icon)?this.icon.length:0,e=!0===Array.isArray(this.iconSelected)?this.iconSelected.length:0,i=!0===Array.isArray(this.iconHalf)?this.iconHalf.length:0,s=!0===Array.isArray(this.color)?this.color.length:0,o=!0===Array.isArray(this.colorSelected)?this.colorSelected.length:0,n=!0===Array.isArray(this.colorHalf)?this.colorHalf.length:0;return{iconLen:t,icon:t>0?this.icon[t-1]:this.icon,selIconLen:e,selIcon:e>0?this.iconSelected[e-1]:this.iconSelected,halfIconLen:i,halfIcon:i>0?this.iconHalf[e-1]:this.iconHalf,colorLen:s,color:s>0?this.color[s-1]:this.color,selColorLen:o,selColor:o>0?this.colorSelected[o-1]:this.colorSelected,halfColorLen:n,halfColor:n>0?this.colorHalf[n-1]:this.colorHalf}},attrs(){return!0===this.disable?{"aria-disabled":""}:!0===this.readonly?{"aria-readonly":""}:void 0}},methods:{__set(t){if(!0===this.editable){const e=between(parseInt(t,10),1,parseInt(this.max,10)),i=!0!==this.noReset&&this.value===e?0:e;i!==this.value&&this.$emit("input",i),this.mouseModel=0}},__setHoverValue(t){!0===this.editable&&(this.mouseModel=t)},__keyup(t,e){switch(t.keyCode){case 13:case 32:return this.__set(e),stopAndPrevent(t);case 37:case 40:return this.$refs[`rt${e-1}`]&&this.$refs[`rt${e-1}`].focus(),stopAndPrevent(t);case 39:case 38:return this.$refs[`rt${e+1}`]&&this.$refs[`rt${e+1}`].focus(),stopAndPrevent(t)}}},render(t){const e=[],i=!0===this.editable?0:null,s=this.iconData,o=Math.ceil(this.value),n=void 0===this.iconHalf||o===this.value?-1:o;for(let r=1;r<=this.max;r++){const a=0===this.mouseModel&&this.value>=r||this.mouseModel>0&&this.mouseModel>=r,l=n===r&&this.mouseModel<r,h=this.mouseModel>0&&(!0===l?o:this.value)>=r&&this.mouseModel<r,d=!0===l?r<=s.halfIconLen?this.iconHalf[r-1]:s.halfIcon:void 0===s.selIcon||!0!==a&&!0!==h?r<=s.iconLen?this.icon[r-1]:s.icon:r<=s.selIconLen?this.iconSelected[r-1]:s.selIcon,c=!0===l?r<=s.halfColorLen?this.colorHalf[r-1]:s.halfColor:void 0!==s.selColor&&!0===a?r<=s.selColorLen?this.colorSelected[r-1]:s.selColor:r<=s.colorLen?this.color[r-1]:s.color;e.push(t(QIcon,{key:r,ref:`rt${r}`,staticClass:"q-rating__icon",class:{"q-rating__icon--active":!0===a||!0===l,"q-rating__icon--exselected":h,"q-rating__icon--hovered":this.mouseModel===r,[`text-${c}`]:void 0!==c},props:{name:d||this.$q.iconSet.rating.icon},attrs:{tabindex:i},on:cache(this,"i#"+r,{click:()=>{this.__set(r)},mouseover:()=>{this.__setHoverValue(r)},mouseout:()=>{this.mouseModel=0},focus:()=>{this.__setHoverValue(r)},blur:()=>{this.mouseModel=0},keyup:t=>{this.__keyup(t,r)}})},slot(this,`tip-${r}`)))}return void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(e,"push"),t("div",{staticClass:"q-rating row inline items-center",class:this.classes,style:this.sizeStyle,attrs:this.attrs,on:{...this.qListeners}},e)}}),QResponsive=Vue.extend({name:"QResponsive",mixins:[RatioMixin,ListenersMixin],render(t){return t("div",{staticClass:"q-responsive",on:{...this.qListeners}},[t("div",{staticClass:"q-responsive__filler overflow-hidden"},[t("div",{style:this.ratioStyle})]),t("div",{staticClass:"q-responsive__content absolute-full fit"},slot(this,"default"))])}}),QScrollArea=Vue.extend({name:"QScrollArea",mixins:[DarkMixin],directives:{TouchPan:TouchPan},props:{barStyle:[Array,String,Object],thumbStyle:Object,contentStyle:[Array,String,Object],contentActiveStyle:[Array,String,Object],delay:{type:[String,Number],default:1e3},visible:{type:Boolean,default:null},horizontal:Boolean},data:()=>({tempShowing:!1,panning:!1,hover:!1,containerWidth:0,containerHeight:0,scrollPosition:0,scrollSize:0}),computed:{classes(){return"q-scrollarea"+(!0===this.isDark?" q-scrollarea--dark":"")},thumbHidden(){return!0!==(null===this.visible?this.hover:this.visible)&&!1===this.tempShowing&&!1===this.panning||this.scrollSize<=this.containerSize},thumbSize(){return Math.round(between(this.containerSize*this.containerSize/this.scrollSize,50,this.containerSize))},style(){const t=this.scrollPercentage*(this.containerSize-this.thumbSize);return Object.assign({},this.thumbStyle,!0===this.horizontal?{left:`${t}px`,width:`${this.thumbSize}px`}:{top:`${t}px`,height:`${this.thumbSize}px`})},mainStyle(){return!0===this.thumbHidden?this.contentStyle:this.contentActiveStyle},scrollPercentage(){const t=between(this.scrollPosition/(this.scrollSize-this.containerSize),0,1);return Math.round(1e4*t)/1e4},containerSize(){return this[`container${this.dirProps.suffix}`]},dirProps(){return!0===this.horizontal?{prefix:"horizontal",suffix:"Width",scroll:"scrollLeft",classSuffix:"h absolute-bottom",dir:"right",dist:"x"}:{prefix:"vertical",suffix:"Height",scroll:"scrollTop",classSuffix:"v absolute-right",dir:"down",dist:"y"}},thumbClass(){return`q-scrollarea__thumb--${this.dirProps.classSuffix}`+(!0===this.thumbHidden?" q-scrollarea__thumb--invisible":"")},barClass(){return`q-scrollarea__bar--${this.dirProps.classSuffix}`+(!0===this.thumbHidden?" q-scrollarea__bar--invisible":"")}},methods:{getScrollTarget(){return this.$refs.target},getScrollPosition(){return this.scrollPosition},setScrollPosition(t,e){(!0===this.horizontal?setHorizontalScrollPosition:setScrollPosition)(this.$refs.target,t,e)},__updateContainer({height:t,width:e}){let i=!1;this.containerWidth!==e&&(this.containerWidth=e,i=!0),this.containerHeight!==t&&(this.containerHeight=t,i=!0),!0===i&&this.__startTimer()},__updateScroll(t){this.scrollPosition!==t.position&&(this.scrollPosition=t.position,this.__startTimer())},__updateScrollSize({height:t,width:e}){!0===this.horizontal?this.scrollSize!==e&&(this.scrollSize=e,this.__startTimer()):this.scrollSize!==t&&(this.scrollSize=t,this.__startTimer())},__panThumb(t){if(!0===t.isFirst){if(!0===this.thumbHidden)return;this.refPos=this.scrollPosition,this.panning=!0}else if(!0!==this.panning)return;!0===t.isFinal&&(this.panning=!1);const e=(this.scrollSize-this.containerSize)/(this.containerSize-this.thumbSize),i=t.distance[this.dirProps.dist],s=this.refPos+(t.direction===this.dirProps.dir?1:-1)*i*e;this.__setScroll(s)},__mouseDown(t){if(!0!==this.thumbHidden){const e=t[`offset${!0===this.horizontal?"X":"Y"}`]-this.thumbSize/2;this.__setScroll(e/this.containerSize*this.scrollSize),void 0!==this.$refs.thumb&&this.$refs.thumb.dispatchEvent(new MouseEvent(t.type,t))}},__startTimer(){!0===this.tempShowing?clearTimeout(this.timer):this.tempShowing=!0,this.timer=setTimeout(()=>{this.tempShowing=!1},this.delay),this.__emitScroll()},__setScroll(t){this.$refs.target[this.dirProps.scroll]=t}},render(t){return t("div",{class:this.classes,on:cache(this,"desk",{mouseenter:()=>{this.hover=!0},mouseleave:()=>{this.hover=!1}})},[t("div",{ref:"target",staticClass:"scroll relative-position fit hide-scrollbar"},[t("div",{staticClass:"absolute",style:this.mainStyle,class:`full-${!0===this.horizontal?"height":"width"}`},mergeSlot([t(QResizeObserver,{on:cache(this,"resizeIn",{resize:this.__updateScrollSize})})],this,"default")),t(QScrollObserver,{props:{horizontal:this.horizontal},on:cache(this,"scroll",{scroll:this.__updateScroll})})]),t(QResizeObserver,{on:cache(this,"resizeOut",{resize:this.__updateContainer})}),t("div",{staticClass:"q-scrollarea__bar",style:this.barStyle,class:this.barClass,attrs:ariaHidden,on:cache(this,"bar",{mousedown:this.__mouseDown})}),t("div",{ref:"thumb",staticClass:"q-scrollarea__thumb",style:this.style,class:this.thumbClass,attrs:ariaHidden,directives:cache(this,"thumb#"+this.horizontal,[{name:"touch-pan",modifiers:{vertical:!0!==this.horizontal,horizontal:this.horizontal,prevent:!0,mouse:!0,mouseAllDir:!0},value:this.__panThumb}])})])},created(){this.__emitScroll=debounce(()=>{if(void 0!==this.$listeners.scroll){const t={ref:this},e=this.dirProps.prefix;t[e+"Position"]=this.scrollPosition,t[e+"Percentage"]=this.scrollPercentage,t[e+"Size"]=this.scrollSize,t[e+"ContainerSize"]=this.containerSize,this.$emit("scroll",t)}},0)}});const aggBucketSize=1e3,slice=Array.prototype.slice;function sumFn(t,e){return t+e}function getScrollDetails(t,e,i,s,o,n,r){const a=t===window?document.scrollingElement||document.documentElement:t,l=!0===o?"offsetWidth":"offsetHeight",h={scrollStart:0,scrollViewSize:-n-r,scrollMaxSize:0,offsetStart:-n,offsetEnd:-r};if(!0===o?(t===window?(h.scrollStart=window.pageXOffset||window.scrollX||document.body.scrollLeft||0,h.scrollViewSize+=window.innerWidth):(h.scrollStart=a.scrollLeft,h.scrollViewSize+=a.clientWidth),h.scrollMaxSize=a.scrollWidth):(t===window?(h.scrollStart=window.pageYOffset||window.scrollY||document.body.scrollTop||0,h.scrollViewSize+=window.innerHeight):(h.scrollStart=a.scrollTop,h.scrollViewSize+=a.clientHeight),h.scrollMaxSize=a.scrollHeight),void 0!==i)for(let t=i.previousElementSibling;null!==t;t=t.previousElementSibling)!1===t.classList.contains("q-virtual-scroll--skip")&&(h.offsetStart+=t[l]);if(void 0!==s)for(let t=s.nextElementSibling;null!==t;t=t.nextElementSibling)!1===t.classList.contains("q-virtual-scroll--skip")&&(h.offsetEnd+=t[l]);if(e!==t){const i=a.getBoundingClientRect(),s=e.getBoundingClientRect();!0===o?(h.offsetStart+=s.left-i.left,h.offsetEnd-=s.width):(h.offsetStart+=s.top-i.top,h.offsetEnd-=s.height),t!==window&&(h.offsetStart+=h.scrollStart),h.offsetEnd+=h.scrollMaxSize-h.offsetStart}return h}function setScroll$1(t,e,i){t===window?!0===i?window.scrollTo(e,window.pageYOffset||window.scrollY||document.body.scrollTop||0):window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,e):t[!0===i?"scrollLeft":"scrollTop"]=e}function sumSize(t,e,i,s){if(i>=s)return 0;const o=e.length,n=Math.floor(i/aggBucketSize),r=Math.floor((s-1)/aggBucketSize)+1;let a=t.slice(n,r).reduce(sumFn,0);return i%aggBucketSize!=0&&(a-=e.slice(n*aggBucketSize,i).reduce(sumFn,0)),s%aggBucketSize!=0&&s!==o&&(a-=e.slice(s,r*aggBucketSize).reduce(sumFn,0)),a}const commonVirtScrollProps={virtualScrollSliceSize:{type:Number,default:30},virtualScrollItemSize:{type:Number,default:24},virtualScrollStickySizeStart:{type:Number,default:0},virtualScrollStickySizeEnd:{type:Number,default:0}},commonVirtPropsList=Object.keys(commonVirtScrollProps);var VirtualScroll={props:{virtualScrollHorizontal:Boolean,...commonVirtScrollProps},data:()=>({virtualScrollSliceRange:{from:0,to:0}}),watch:{virtualScrollHorizontal(){this.__setVirtualScrollSize()},needsReset(){this.reset()}},computed:{needsReset(){return["virtualScrollItemSize","virtualScrollHorizontal"].map(t=>this[t]).join(";")}},methods:{reset(){this.__resetVirtualScroll(this.prevToIndex,!0)},refresh(t){this.__resetVirtualScroll(void 0===t?this.prevToIndex:t)},scrollTo(t){const e=this.__getVirtualScrollTarget();void 0!==e&&null!==e&&8!==e.nodeType&&this.__setVirtualScrollSliceRange(e,getScrollDetails(e,this.__getVirtualScrollEl(),this.$refs.before,this.$refs.after,this.virtualScrollHorizontal,this.virtualScrollStickySizeStart,this.virtualScrollStickySizeEnd),Math.min(this.virtualScrollLength-1,Math.max(0,parseInt(t,10)||0)),0,this.prevToIndex>-1&&t>this.prevToIndex?"end":"start")},__onVirtualScrollEvt(){const t=this.__getVirtualScrollTarget();if(void 0===t||null===t||8===t.nodeType)return;const e=getScrollDetails(t,this.__getVirtualScrollEl(),this.$refs.before,this.$refs.after,this.virtualScrollHorizontal,this.virtualScrollStickySizeStart,this.virtualScrollStickySizeEnd),i=e.scrollMaxSize-Math.max(e.scrollViewSize,e.offsetEnd)-this.virtualScrollSizes[this.virtualScrollLength-1],s=this.virtualScrollLength-1;if(this.prevScrollStart===e.scrollStart)return;if(this.prevScrollStart=void 0,this.__updateVirtualScrollSizes(this.virtualScrollSliceRange.from),i>0&&e.scrollStart>=i)return void this.__setVirtualScrollSliceRange(t,e,this.virtualScrollLength-1,e.scrollMaxSize-e.offsetEnd-this.virtualScrollSizesAgg.reduce(sumFn,0));let o=0,n=e.scrollStart-e.offsetStart,r=n;for(let t=0;n>=this.virtualScrollSizesAgg[t]&&o<s;t++)n-=this.virtualScrollSizesAgg[t],o+=aggBucketSize;for(;n>0&&o<s;)(n-=this.virtualScrollSizes[o])>-e.scrollViewSize?(o++,r=n):r=this.virtualScrollSizes[o]+n;this.__setVirtualScrollSliceRange(t,e,o,r)},__setVirtualScrollSliceRange(t,e,i,s,o){let n=Math.max(0,Math.ceil(i-(void 0===o?3:2)*this.virtualScrollSliceSizeComputed/6)),r=n+this.virtualScrollSliceSizeComputed;r>this.virtualScrollLength&&(r=this.virtualScrollLength,n=Math.max(0,r-this.virtualScrollSliceSizeComputed));const a=n!==this.virtualScrollSliceRange.from||r!==this.virtualScrollSliceRange.to;!1!==a||void 0!==o?(!0===a&&(this.virtualScrollSliceRange={from:n,to:r},this.virtualScrollPaddingBefore=sumSize(this.virtualScrollSizesAgg,this.virtualScrollSizes,0,n),this.virtualScrollPaddingAfter=sumSize(this.virtualScrollSizesAgg,this.virtualScrollSizes,r,this.virtualScrollLength)),this.$nextTick(()=>{!0===a&&this.__updateVirtualScrollSizes(n);const r=this.virtualScrollSizes.slice(n,i).reduce(sumFn,e.offsetStart+this.virtualScrollPaddingBefore),l=r+this.virtualScrollSizes[i];let h=r+s;void 0!==o&&(h=e.scrollStart<r&&l<e.scrollStart+e.scrollViewSize?e.scrollStart:"end"===o?l-e.scrollViewSize:r),this.prevScrollStart=h,this.__setScroll(t,h,this.virtualScrollHorizontal),this.__emitScroll(i)})):this.__emitScroll(i)},__updateVirtualScrollSizes(t){const e=this.$refs.content;if(void 0!==e){const i=slice.call(e.children).filter(t=>!1===t.classList.contains("q-virtual-scroll--skip")),s=i.length,o=!0===this.virtualScrollHorizontal?"offsetWidth":"offsetHeight";let n,r,a=t;for(let t=0;t<s;){for(n=i[t][o],t++;t<s&&!0===i[t].classList.contains("q-virtual-scroll--with-prev");)n+=i[t][o],t++;0!==(r=n-this.virtualScrollSizes[a])&&(this.virtualScrollSizes[a]+=r,this.virtualScrollSizesAgg[Math.floor(a/aggBucketSize)]+=r),a++}}},__resetVirtualScroll(t,e){const i=this.virtualScrollItemSize;!0!==e&&!1!==Array.isArray(this.virtualScrollSizes)||(this.virtualScrollSizes=[]);const s=this.virtualScrollSizes.length;this.virtualScrollSizes.length=this.virtualScrollLength;for(let t=this.virtualScrollLength-1;t>=s;t--)this.virtualScrollSizes[t]=i;const o=Math.floor((this.virtualScrollLength-1)/aggBucketSize);this.virtualScrollSizesAgg=[];for(let t=0;t<=o;t++){let e=0;const i=Math.min((t+1)*aggBucketSize,this.virtualScrollLength);for(let s=t*aggBucketSize;s<i;s++)e+=this.virtualScrollSizes[s];this.virtualScrollSizesAgg.push(e)}this.prevToIndex=-1,this.prevScrollStart=void 0,t>=0?(this.__updateVirtualScrollSizes(this.virtualScrollSliceRange.from),this.$nextTick(()=>{this.scrollTo(t)})):(this.virtualScrollPaddingBefore=sumSize(this.virtualScrollSizesAgg,this.virtualScrollSizes,0,this.virtualScrollSliceRange.from),this.virtualScrollPaddingAfter=sumSize(this.virtualScrollSizesAgg,this.virtualScrollSizes,this.virtualScrollSliceRange.to,this.virtualScrollLength),this.__onVirtualScrollEvt())},__setVirtualScrollSize(){!0===this.virtualScrollHorizontal?this.virtualScrollSliceSizeComputed="undefined"==typeof window?this.virtualScrollSliceSize:Math.max(this.virtualScrollSliceSize,Math.ceil(window.innerWidth/this.virtualScrollItemSize*2)):this.virtualScrollSliceSizeComputed="undefined"==typeof window?this.virtualScrollSliceSize:Math.max(this.virtualScrollSliceSize,Math.ceil(window.innerHeight/this.virtualScrollItemSize*2))},__padVirtualScroll(t,e,i){const s=!0===this.virtualScrollHorizontal?"width":"height";return["tbody"===e?t(e,{staticClass:"q-virtual-scroll__padding",key:"before",ref:"before"},[t("tr",[t("td",{style:{[s]:`${this.virtualScrollPaddingBefore}px`},attrs:{colspan:"100%"}})])]):t(e,{staticClass:"q-virtual-scroll__padding",key:"before",ref:"before",style:{[s]:`${this.virtualScrollPaddingBefore}px`}}),t(e,{staticClass:"q-virtual-scroll__content",key:"content",ref:"content"},i),"tbody"===e?t(e,{staticClass:"q-virtual-scroll__padding",key:"after",ref:"after"},[t("tr",[t("td",{style:{[s]:`${this.virtualScrollPaddingAfter}px`},attrs:{colspan:"100%"}})])]):t(e,{staticClass:"q-virtual-scroll__padding",key:"after",ref:"after",style:{[s]:`${this.virtualScrollPaddingAfter}px`}})]},__emitScroll(t){this.prevToIndex!==t&&(void 0!==this.qListeners["virtual-scroll"]&&this.$emit("virtual-scroll",{index:t,from:this.virtualScrollSliceRange.from,to:this.virtualScrollSliceRange.to-1,direction:t<this.prevToIndex?"decrease":"increase",ref:this}),this.prevToIndex=t)}},created(){this.__setVirtualScrollSize()},beforeMount(){this.__onVirtualScrollEvt=debounce(this.__onVirtualScrollEvt,70),this.__setScroll=frameDebounce(setScroll$1),this.__setVirtualScrollSize()}};const validateNewValueMode=t=>["add","add-unique","toggle"].includes(t),reEscapeList=".*+?^${}()|[]\\";var QSelect=Vue.extend({name:"QSelect",mixins:[QField,VirtualScroll,CompositionMixin,FormFieldMixin,ListenersMixin],props:{value:{required:!0},multiple:Boolean,displayValue:[String,Number],displayValueSanitize:Boolean,dropdownIcon:String,options:{type:Array,default:()=>[]},optionValue:[Function,String],optionLabel:[Function,String],optionDisable:[Function,String],hideSelected:Boolean,hideDropdownIcon:Boolean,fillInput:Boolean,maxValues:[Number,String],optionsDense:Boolean,optionsDark:{type:Boolean,default:null},optionsSelectedClass:String,optionsSanitize:Boolean,optionsCover:Boolean,menuShrink:Boolean,menuAnchor:String,menuSelf:String,menuOffset:Array,popupContentClass:String,popupContentStyle:[String,Array,Object],useInput:Boolean,useChips:Boolean,newValueMode:{type:String,validator:validateNewValueMode},mapOptions:Boolean,emitValue:Boolean,inputDebounce:{type:[Number,String],default:500},inputClass:[Array,String,Object],inputStyle:[Array,String,Object],tabindex:{type:[String,Number],default:0},transitionShow:String,transitionHide:String,behavior:{type:String,validator:t=>["default","menu","dialog"].includes(t),default:"default"}},data:()=>({menu:!1,dialog:!1,optionIndex:-1,inputValue:"",dialogFieldFocused:!1}),watch:{innerValue:{handler(t){this.innerValueCache=t,!0===this.useInput&&!0===this.fillInput&&!0!==this.multiple&&!0!==this.innerLoading&&(!0!==this.dialog&&!0!==this.menu||!0!==this.hasValue)&&(!0!==this.userInputValue&&this.__resetInputValue(),!0!==this.dialog&&!0!==this.menu||this.filter(""))},immediate:!0},fillInput(){this.__resetInputValue()},menu(t){this.__updateMenu(t)}},computed:{isOptionsDark(){return null===this.optionsDark?this.isDark:this.optionsDark},virtualScrollLength(){return Array.isArray(this.options)?this.options.length:0},fieldClass(){return`q-select q-field--auto-height q-select--with${!0!==this.useInput?"out":""}-input q-select--with${!0!==this.useChips?"out":""}-chips`},computedInputClass(){return!0===this.hideSelected||0===this.innerValue.length?this.inputClass:void 0===this.inputClass?"q-field__input--padding":[this.inputClass,"q-field__input--padding"]},menuContentClass(){return(!0===this.virtualScrollHorizontal?"q-virtual-scroll--horizontal":"")+(this.popupContentClass?" "+this.popupContentClass:"")},innerValue(){const t=!0===this.mapOptions&&!0!==this.multiple,e=void 0===this.value||null===this.value&&!0!==t?[]:!0===this.multiple&&Array.isArray(this.value)?this.value:[this.value];if(!0===this.mapOptions&&!0===Array.isArray(this.options)){const i=!0===this.mapOptions&&void 0!==this.innerValueCache?this.innerValueCache:[],s=e.map(t=>this.__getOption(t,i));return null===this.value&&!0===t?s.filter(t=>null!==t):s}return e},noOptions(){return 0===this.virtualScrollLength},selectedString(){return this.innerValue.map(t=>this.getOptionLabel(t)).join(", ")},sanitizeFn(){return!0===this.optionsSanitize?()=>!0:t=>void 0!==t&&null!==t&&!0===t.sanitize},displayAsText(){return!0===this.displayValueSanitize||void 0===this.displayValue&&(!0===this.optionsSanitize||this.innerValue.some(this.sanitizeFn))},computedTabindex(){return!0===this.focused?this.tabindex:-1},selectedScope(){return this.innerValue.map((t,e)=>({index:e,opt:t,sanitize:this.sanitizeFn(t),selected:!0,removeAtIndex:this.__removeAtIndexAndFocus,toggleOption:this.toggleOption,tabindex:this.computedTabindex}))},optionScope(){if(0===this.virtualScrollLength)return[];const{from:t,to:e}=this.virtualScrollSliceRange;return this.options.slice(t,e).map((e,i)=>{const s=!0===this.isOptionDisabled(e),o=t+i,n={clickable:!0,active:!1,activeClass:this.computedOptionsSelectedClass,manualFocus:!0,focused:!1,disable:s,tabindex:-1,dense:this.optionsDense,dark:this.isOptionsDark};!0!==s&&(!0===this.isOptionSelected(e)&&(n.active=!0),this.optionIndex===o&&(n.focused=!0));const r={click:()=>{this.toggleOption(e)}};return!0===this.$q.platform.is.desktop&&(r.mousemove=(()=>{this.setOptionIndex(o)})),{index:o,opt:e,sanitize:this.sanitizeFn(e),selected:n.active,focused:n.focused,toggleOption:this.toggleOption,setOptionIndex:this.setOptionIndex,itemProps:n,itemEvents:r}})},dropdownArrowIcon(){return void 0!==this.dropdownIcon?this.dropdownIcon:this.$q.iconSet.arrow.dropdown},squaredMenu(){return!1===this.optionsCover&&!0!==this.outlined&&!0!==this.standout&&!0!==this.borderless&&!0!==this.rounded},computedOptionsSelectedClass(){return void 0!==this.optionsSelectedClass?this.optionsSelectedClass:void 0!==this.color?`text-${this.color}`:""},innerOptionsValue(){return this.innerValue.map(t=>this.getOptionValue(t))},getOptionValue(){return this.__getPropValueFn("optionValue","value")},getOptionLabel(){return this.__getPropValueFn("optionLabel","label")},isOptionDisabled(){return this.__getPropValueFn("optionDisable","disable")},inputControlEvents(){const t={input:this.__onInput,change:this.__onChange,keydown:this.__onTargetKeydown,keyup:this.__onTargetKeyup,keypress:this.__onTargetKeypress,focus:this.__selectInputText,click:t=>{!0===this.hasDialog&&stop(t)}};return t.compositionstart=t.compositionupdate=t.compositionend=this.__onComposition,t}},methods:{getEmittingOptionValue(t){return!0===this.emitValue?this.getOptionValue(t):t},removeAtIndex(t){if(t>-1&&t<this.innerValue.length)if(!0===this.multiple){const e=this.value.slice();this.$emit("remove",{index:t,value:e.splice(t,1)[0]}),this.$emit("input",e)}else this.$emit("input",null)},__removeAtIndexAndFocus(t){this.removeAtIndex(t),this.__focus()},add(t,e){const i=this.getEmittingOptionValue(t);if(!0!==this.multiple)return!0===this.fillInput&&this.updateInputValue(this.getOptionLabel(t),!0,!0),void this.$emit("input",i);if(0===this.innerValue.length)return this.$emit("add",{index:0,value:i}),void this.$emit("input",!0===this.multiple?[i]:i);if(!0===e&&!0===this.isOptionSelected(t))return;if(void 0!==this.maxValues&&this.value.length>=this.maxValues)return;const s=this.value.slice();this.$emit("add",{index:s.length,value:i}),s.push(i),this.$emit("input",s)},toggleOption(t,e){if(!0!==this.editable||void 0===t||!0===this.isOptionDisabled(t))return;const i=this.getOptionValue(t);if(!0!==this.multiple)return!0!==e&&(this.updateInputValue(!0===this.fillInput?this.getOptionLabel(t):"",!0,!0),this.hidePopup()),void 0!==this.$refs.target&&this.$refs.target.focus(),void(!0!==isDeepEqual(this.getOptionValue(this.innerValue[0]),i)&&this.$emit("input",!0===this.emitValue?i:t));if((!0!==this.hasDialog||!0===this.dialogFieldFocused)&&this.__focus(),this.__selectInputText(),0===this.innerValue.length){const e=!0===this.emitValue?i:t;return this.$emit("add",{index:0,value:e}),void this.$emit("input",!0===this.multiple?[e]:e)}const s=this.value.slice(),o=this.innerOptionsValue.findIndex(t=>isDeepEqual(t,i));if(o>-1)this.$emit("remove",{index:o,value:s.splice(o,1)[0]});else{if(void 0!==this.maxValues&&s.length>=this.maxValues)return;const e=!0===this.emitValue?i:t;this.$emit("add",{index:s.length,value:e}),s.push(e)}this.$emit("input",s)},setOptionIndex(t){if(!0!==this.$q.platform.is.desktop)return;const e=t>-1&&t<this.virtualScrollLength?t:-1;this.optionIndex!==e&&(this.optionIndex=e)},moveOptionSelection(t=1,e){if(!0===this.menu){let i=this.optionIndex;do{i=normalizeToInterval(i+t,-1,this.virtualScrollLength-1)}while(-1!==i&&i!==this.optionIndex&&!0===this.isOptionDisabled(this.options[i]));this.optionIndex!==i&&(this.setOptionIndex(i),this.scrollTo(i),!0!==e&&!0===this.useInput&&!0===this.fillInput&&this.__setInputValue(i>=0?this.getOptionLabel(this.options[i]):this.defaultInputValue))}},__getOption(t,e){const i=e=>isDeepEqual(this.getOptionValue(e),t);return this.options.find(i)||e.find(i)||t},__getPropValueFn(t,e){const i=void 0!==this[t]?this[t]:e;return"function"==typeof i?i:t=>Object(t)===t&&i in t?t[i]:t},isOptionSelected(t){const e=this.getOptionValue(t);return void 0!==this.innerOptionsValue.find(t=>isDeepEqual(t,e))},__selectInputText(){!0===this.useInput&&void 0!==this.$refs.target&&this.$refs.target.select()},__onTargetKeyup(t){!0===isKeyCode(t,27)&&!0===this.menu&&(stop(t),this.hidePopup(),this.__resetInputValue()),this.$emit("keyup",t)},__onTargetAutocomplete(t){const{value:e}=t.target;if(t.target.value="",void 0===t.keyCode){if("string"==typeof e&&e.length>0){const t=e.toLocaleLowerCase();let i=e=>this.getOptionValue(e).toLocaleLowerCase()===t,s=this.options.find(i);null!==s?-1===this.innerValue.indexOf(s)&&this.toggleOption(s):(i=(e=>this.getOptionLabel(e).toLocaleLowerCase()===t),null!==(s=this.options.find(i))&&-1===this.innerValue.indexOf(s)&&this.toggleOption(s))}}else this.__onTargetKeyup(t)},__onTargetKeypress(t){this.$emit("keypress",t)},__onTargetKeydown(t){if(this.$emit("keydown",t),!0===shouldIgnoreKey(t))return;const e=this.inputValue.length>0&&(void 0!==this.newValueMode||void 0!==this.qListeners["new-value"]),i=!0!==t.shiftKey&&!0!==this.multiple&&(this.optionIndex>-1||!0===e);if(27===t.keyCode)return void prevent(t);if(9===t.keyCode&&!1===i)return void this.__closeMenu();if(void 0===t.target||t.target.id!==this.targetUid)return;if(40===t.keyCode&&!0!==this.innerLoading&&!1===this.menu)return stopAndPrevent(t),void this.showPopup();if(8===t.keyCode&&!0===this.multiple&&!0!==this.hideSelected&&0===this.inputValue.length&&Array.isArray(this.value))return void this.removeAtIndex(this.value.length-1);38!==t.keyCode&&40!==t.keyCode||(stopAndPrevent(t),this.moveOptionSelection(38===t.keyCode?-1:1,this.multiple));const s=this.virtualScrollLength;if((void 0===this.searchBuffer||this.searchBufferExp<Date.now())&&(this.searchBuffer=""),s>0&&!0!==this.useInput&&1===t.key.length&&t.altKey===t.ctrlKey&&(32!==t.keyCode||this.searchBuffer.length>0)){!0!==this.menu&&this.showPopup(t);const e=t.key.toLocaleLowerCase(),i=1===this.searchBuffer.length&&this.searchBuffer[0]===e;this.searchBufferExp=Date.now()+1500,!1===i&&(stopAndPrevent(t),this.searchBuffer+=e);const o=new RegExp("^"+this.searchBuffer.split("").map(t=>reEscapeList.indexOf(t)>-1?"\\"+t:t).join(".*"),"i");let n=this.optionIndex;if(!0===i||n<0||!0!==o.test(this.getOptionLabel(this.options[n])))do{n=normalizeToInterval(n+1,-1,s-1)}while(n!==this.optionIndex&&(!0===this.isOptionDisabled(this.options[n])||!0!==o.test(this.getOptionLabel(this.options[n]))));this.optionIndex!==n&&this.$nextTick(()=>{this.setOptionIndex(n),this.scrollTo(n),n>=0&&!0===this.useInput&&!0===this.fillInput&&this.__setInputValue(this.getOptionLabel(this.options[n]))})}else if(13===t.keyCode||32===t.keyCode&&!0!==this.useInput&&""===this.searchBuffer||9===t.keyCode&&!1!==i)if(9!==t.keyCode&&stopAndPrevent(t),this.optionIndex>-1&&this.optionIndex<s)this.toggleOption(this.options[this.optionIndex]);else{if(!0===e){const t=(t,e)=>{if(e){if(!0!==validateNewValueMode(e))return}else e=this.newValueMode;void 0!==t&&null!==t&&(this.updateInputValue("",!0!==this.multiple,!0),this["toggle"===e?"toggleOption":"add"](t,"add-unique"===e),!0!==this.multiple&&(void 0!==this.$refs.target&&this.$refs.target.focus(),this.hidePopup()))};if(void 0!==this.qListeners["new-value"]?this.$emit("new-value",this.inputValue,t):t(this.inputValue),!0!==this.multiple)return}!0===this.menu?this.__closeMenu():!0!==this.innerLoading&&this.showPopup()}},__getVirtualScrollEl(){return!0===this.hasDialog?this.$refs.menuContent:void 0!==this.$refs.menu&&void 0!==this.$refs.menu.__portal?this.$refs.menu.__portal.$el:void 0},__getVirtualScrollTarget(){return this.__getVirtualScrollEl()},__getSelection(t,e){return!0===this.hideSelected?!0===e||!0!==this.dialog||!0!==this.hasDialog?[]:[t("span",{domProps:{textContent:this.inputValue}})]:void 0!==this.$scopedSlots["selected-item"]?this.selectedScope.map(t=>this.$scopedSlots["selected-item"](t)).slice():void 0!==this.$scopedSlots.selected?this.$scopedSlots.selected().slice():!0===this.useChips?this.selectedScope.map((e,i)=>t(QChip,{key:"option-"+i,props:{removable:!0===this.editable&&!0!==this.isOptionDisabled(e.opt),dense:!0,textColor:this.color,tabindex:this.computedTabindex},on:cache(this,"rem#"+i,{remove(){e.removeAtIndex(i)}})},[t("span",{staticClass:"ellipsis",domProps:{[!0===e.sanitize?"textContent":"innerHTML"]:this.getOptionLabel(e.opt)}})])):[t("span",{domProps:{[this.displayAsText?"textContent":"innerHTML"]:void 0!==this.displayValue?this.displayValue:this.selectedString}})]},__getControl(t,e){const i=this.__getSelection(t,e),s=!0===e||!0!==this.dialog||!0!==this.hasDialog;if(!0===s&&!0===this.useInput?i.push(this.__getInput(t,e)):!0===this.editable&&(!0===s&&i.push(t("div",{ref:"target",key:"d_t",staticClass:"no-outline",attrs:{id:this.targetUid,tabindex:this.tabindex},on:cache(this,"f-tget",{keydown:this.__onTargetKeydown,keyup:this.__onTargetKeyup,keypress:this.__onTargetKeypress})})),void 0!==this.qAttrs.autocomplete&&i.push(t("input",{staticClass:"q-select__autocomplete-input no-outline",attrs:{autocomplete:this.qAttrs.autocomplete},on:cache(this,"autoinp",{keyup:this.__onTargetAutocomplete})}))),void 0!==this.nameProp&&!0!==this.disable&&this.innerOptionsValue.length>0){const e=this.innerOptionsValue.map(e=>t("option",{attrs:{value:e,selected:!0}}));i.push(t("select",{staticClass:"hidden",attrs:{name:this.nameProp,multiple:this.multiple}},e))}return t("div",{staticClass:"q-field__native row items-center",attrs:this.qAttrs},i)},__getOptions(t){if(!0!==this.menu)return;const e=void 0!==this.$scopedSlots.option?this.$scopedSlots.option:e=>t(QItem,{key:e.index,props:e.itemProps,on:e.itemEvents},[t(QItemSection,[t(QItemLabel,{domProps:{[!0===e.sanitize?"textContent":"innerHTML"]:this.getOptionLabel(e.opt)}})])]);let i=this.__padVirtualScroll(t,"div",this.optionScope.map(e));return void 0!==this.$scopedSlots["before-options"]&&(i=this.$scopedSlots["before-options"]().concat(i)),mergeSlot(i,this,"after-options")},__getInnerAppend(t){return!0!==this.loading&&!0!==this.innerLoading&&!0!==this.hideDropdownIcon?[t(QIcon,{staticClass:"q-select__dropdown-icon",props:{name:this.dropdownArrowIcon}})]:null},__getInput(t,e){const i={ref:"target",key:"i_t",staticClass:"q-field__input q-placeholder col",style:this.inputStyle,class:this.computedInputClass,domProps:{value:void 0!==this.inputValue?this.inputValue:""},attrs:{type:"search",...this.qAttrs,id:this.targetUid,maxlength:this.maxlength,tabindex:this.tabindex,"data-autofocus":!0!==e&&this.autofocus,disabled:!0===this.disable,readonly:!0===this.readonly},on:this.inputControlEvents};return!0!==e&&!0===this.hasDialog&&(i.staticClass+=" no-pointer-events",i.attrs.readonly=!0),t("input",i)},__onChange(t){this.__onComposition(t)},__onInput(t){clearTimeout(this.inputTimer),t&&t.target&&!0===t.target.composing||(this.__setInputValue(t.target.value||""),this.userInputValue=!0,this.defaultInputValue=this.inputValue,!0===this.focused||!0===this.hasDialog&&!0!==this.dialogFieldFocused||this.__focus(),void 0!==this.qListeners.filter&&(this.inputTimer=setTimeout(()=>{this.filter(this.inputValue)},this.inputDebounce)))},__setInputValue(t){this.inputValue!==t&&(this.inputValue=t,this.$emit("input-value",t))},updateInputValue(t,e,i){this.userInputValue=!0!==i,!0===this.useInput&&(this.__setInputValue(t),!0!==e&&!0===i||(this.defaultInputValue=t),!0!==e&&this.filter(t))},filter(t){if(void 0===this.qListeners.filter||!0!==this.focused)return;!0===this.innerLoading?this.$emit("filter-abort"):this.innerLoading=!0,""!==t&&!0!==this.multiple&&this.innerValue.length>0&&!0!==this.userInputValue&&t===this.getOptionLabel(this.innerValue[0])&&(t="");const e=setTimeout(()=>{!0===this.menu&&(this.menu=!1)},10);clearTimeout(this.filterId),this.filterId=e,this.$emit("filter",t,(t,i)=>{!0===this.focused&&this.filterId===e&&(clearTimeout(this.filterId),"function"==typeof t&&t(),this.$nextTick(()=>{this.innerLoading=!1,!0===this.editable&&(!0===this.menu?this.__updateMenu(!0):this.menu=!0),"function"==typeof i&&this.$nextTick(()=>{i(this)})}))},()=>{!0===this.focused&&this.filterId===e&&(clearTimeout(this.filterId),this.innerLoading=!1),!0===this.menu&&(this.menu=!1)})},__getControlEvents(){const t=t=>{this.__onControlFocusout(t,()=>{this.__resetInputValue(),this.__closeMenu()})};return{focusin:this.__onControlFocusin,focusout:t,"popup-show":this.__onControlPopupShow,"popup-hide":e=>{void 0!==e&&stop(e),this.$emit("popup-hide",e),this.hasPopupOpen=!1,t(e)},click:t=>{if(!0!==this.hasDialog){if(!0===this.useInput&&!0!==t.target.classList.contains("q-field__input")||!0!==this.useInput&&!0===t.target.classList.contains("no-outline"))return;if(!0===this.menu)return this.__closeMenu(),void(void 0!==this.$refs.target&&this.$refs.target.focus())}this.showPopup(t)}}},__getControlChild(t){if(!1!==this.editable&&(!0===this.dialog||!0!==this.noOptions||void 0!==this.$scopedSlots["no-option"]))return this[`__get${!0===this.hasDialog?"Dialog":"Menu"}`](t)},__getMenu(t){const e=!0===this.noOptions?void 0!==this.$scopedSlots["no-option"]?this.$scopedSlots["no-option"]({inputValue:this.inputValue}):null:this.__getOptions(t);return t(QMenu,{ref:"menu",props:{value:this.menu,fit:!0!==this.menuShrink,cover:!0===this.optionsCover&&!0!==this.noOptions&&!0!==this.useInput,anchor:this.menuAnchor,self:this.menuSelf,offset:this.menuOffset,contentClass:this.menuContentClass,contentStyle:this.popupContentStyle,dark:this.isOptionsDark,noParentEvent:!0,noRefocus:!0,noFocus:!0,square:this.squaredMenu,transitionShow:this.transitionShow,transitionHide:this.transitionHide,separateClosePopup:!0},on:cache(this,"menu",{"&scroll":this.__onVirtualScrollEvt,"before-hide":this.__closeMenu})},e)},__onDialogFieldFocus(t){stop(t),void 0!==this.$refs.target&&this.$refs.target.focus(),this.dialogFieldFocused=!0,window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,0)},__onDialogFieldBlur(t){stop(t),this.$nextTick(()=>{this.dialogFieldFocused=!1})},__getDialog(t){const e=[t(QField,{staticClass:`col-auto ${this.fieldClass}`,props:{...this.$props,for:this.targetUid,dark:this.isOptionsDark,square:!0,loading:this.innerLoading,filled:!0,stackLabel:this.inputValue.length>0},on:{...this.qListeners,focus:this.__onDialogFieldFocus,blur:this.__onDialogFieldBlur},scopedSlots:{...this.$scopedSlots,rawControl:()=>this.__getControl(t,!0),before:void 0,after:void 0}})];return!0===this.menu&&e.push(t("div",{ref:"menuContent",staticClass:"scroll",class:this.menuContentClass,style:this.popupContentStyle,on:cache(this,"virtMenu",{click:prevent,"&scroll":this.__onVirtualScrollEvt})},!0===this.noOptions?void 0!==this.$scopedSlots["no-option"]?this.$scopedSlots["no-option"]({inputValue:this.inputValue}):null:this.__getOptions(t))),t(QDialog,{ref:"dialog",props:{value:this.dialog,dark:this.isOptionsDark,position:!0===this.useInput?"top":void 0,transitionShow:this.transitionShowComputed,transitionHide:this.transitionHide},on:cache(this,"dialog",{"before-hide":this.__onDialogBeforeHide,hide:this.__onDialogHide,show:this.__onDialogShow})},[t("div",{staticClass:"q-select__dialog"+(!0===this.isOptionsDark?" q-select__dialog--dark q-dark":"")+(!0===this.dialogFieldFocused?" q-select__dialog--focused":"")},e)])},__onDialogBeforeHide(){this.$refs.dialog.__refocusTarget=this.$el.querySelector(".q-field__native > [tabindex]:last-child"),this.focused=!1},__onDialogHide(t){this.hidePopup(),!1===this.focused&&this.$emit("blur",t),this.__resetInputValue()},__onDialogShow(){const t=document.activeElement;null!==t&&t.id===this.targetUid||this.$refs.target===t||void 0===this.$refs.target||this.$refs.target.focus()},__closeMenu(){!0!==this.dialog&&(this.optionIndex=-1,!0===this.menu&&(this.menu=!1),!1===this.focused&&(clearTimeout(this.filterId),this.filterId=void 0,!0===this.innerLoading&&(this.$emit("filter-abort"),this.innerLoading=!1)))},showPopup(t){!0===this.editable&&(!0===this.hasDialog?(this.__onControlFocusin(t),this.dialog=!0,this.$nextTick(()=>{this.__focus()})):this.__focus(),void 0!==this.qListeners.filter?this.filter(this.inputValue):!0===this.noOptions&&void 0===this.$scopedSlots["no-option"]||(this.menu=!0))},hidePopup(){this.dialog=!1,this.__closeMenu()},__resetInputValue(){!0===this.useInput&&this.updateInputValue(!0!==this.multiple&&!0===this.fillInput&&this.innerValue.length>0&&this.getOptionLabel(this.innerValue[0])||"",!0,!0)},__updateMenu(t){let e=-1;if(!0===t){if(this.innerValue.length>0){const t=this.getOptionValue(this.innerValue[0]);e=this.options.findIndex(e=>isDeepEqual(this.getOptionValue(e),t))}this.__resetVirtualScroll(e)}this.setOptionIndex(e)},__onPreRender(){this.hasDialog=(!0===this.$q.platform.is.mobile||"dialog"===this.behavior)&&("menu"!==this.behavior&&(!0!==this.useInput||(void 0!==this.$scopedSlots["no-option"]||void 0!==this.qListeners.filter||!1===this.noOptions))),this.transitionShowComputed=!0===this.hasDialog&&!0===this.useInput&&!0===this.$q.platform.is.ios?"fade":this.transitionShow},__onPostRender(){!1===this.dialog&&void 0!==this.$refs.menu&&this.$refs.menu.updatePosition()},updateMenuPosition(){this.__onPostRender()}},beforeDestroy(){clearTimeout(this.inputTimer)}});const skeletonTypes=["text","rect","circle","QBtn","QBadge","QChip","QToolbar","QCheckbox","QRadio","QToggle","QSlider","QRange","QInput","QAvatar"],skeletonAnimations=["wave","pulse","pulse-x","pulse-y","fade","blink","none"];var QSkeleton=Vue.extend({name:"QSkeleton",mixins:[DarkMixin,TagMixin,ListenersMixin],props:{type:{type:String,validator:t=>skeletonTypes.includes(t),default:"rect"},animation:{type:String,validator:t=>skeletonAnimations.includes(t),default:"wave"},square:Boolean,bordered:Boolean,size:String,width:String,height:String},computed:{style(){return void 0!==this.size?{width:this.size,height:this.size}:{width:this.width,height:this.height}},classes(){return`q-skeleton--${!0===this.isDark?"dark":"light"} q-skeleton--type-${this.type}`+("none"!==this.animation?` q-skeleton--anim q-skeleton--anim-${this.animation}`:"")+(!0===this.square?" q-skeleton--square":"")+(!0===this.bordered?" q-skeleton--bordered":"")}},render(t){return t(this.tag,{staticClass:"q-skeleton",class:this.classes,style:this.style,on:{...this.qListeners}},slot(this,"default"))}});const slotsDef=[["left","center","start","width"],["right","center","end","width"],["top","start","center","height"],["bottom","end","center","height"]];var QSlideItem=Vue.extend({name:"QSlideItem",mixins:[DarkMixin,ListenersMixin],props:{leftColor:String,rightColor:String,topColor:String,bottomColor:String},directives:{TouchPan:TouchPan},computed:{langDir(){return!0===this.$q.lang.rtl?{left:"right",right:"left"}:{left:"left",right:"right"}}},methods:{reset(){this.$refs.content.style.transform="translate(0,0)"},__pan(t){const e=this.$refs.content;if(t.isFirst)this.__dir=null,this.__size={left:0,right:0,top:0,bottom:0},this.__scale=0,e.classList.add("no-transition"),slotsDef.forEach(t=>{if(void 0!==this.$scopedSlots[t[0]]){const e=this.$refs[t[0]+"Content"];e.style.transform="scale(1)",this.__size[t[0]]=e.getBoundingClientRect()[t[3]]}}),this.__axis="up"===t.direction||"down"===t.direction?"Y":"X";else{if(t.isFinal)return e.classList.remove("no-transition"),void(1===this.__scale?(e.style.transform=`translate${this.__axis}(${100*this.__dir}%)`,this.timer=setTimeout(()=>{this.$emit(this.__showing,{reset:this.reset}),this.$emit("action",{side:this.__showing,reset:this.reset})},230)):e.style.transform="translate(0,0)");t.direction="X"===this.__axis?t.offset.x<0?"left":"right":t.offset.y<0?"up":"down"}if(void 0===this.$scopedSlots.left&&t.direction===this.langDir.right||void 0===this.$scopedSlots.right&&t.direction===this.langDir.left||void 0===this.$scopedSlots.top&&"down"===t.direction||void 0===this.$scopedSlots.bottom&&"up"===t.direction)return void(e.style.transform="translate(0,0)");let i,s,o;"X"===this.__axis?(s="left"===t.direction?-1:1,i=1===s?this.langDir.left:this.langDir.right,o=t.distance.x):(s="up"===t.direction?-2:2,i=2===s?"top":"bottom",o=t.distance.y),null!==this.__dir&&Math.abs(s)!==Math.abs(this.__dir)||(this.__dir!==s&&(["left","right","top","bottom"].forEach(t=>{void 0!==this.$refs[t]&&(this.$refs[t].style.visibility=i===t?"visible":"hidden")}),this.__showing=i,this.__dir=s),this.__scale=Math.max(0,Math.min(1,(o-40)/this.__size[i])),e.style.transform=`translate${this.__axis}(${o*s/Math.abs(s)}px)`,this.$refs[`${i}Content`].style.transform=`scale(${this.__scale})`)}},render(t){const e=[],i=void 0!==this.$scopedSlots[this.langDir.right],s=void 0!==this.$scopedSlots[this.langDir.left],o=void 0!==this.$scopedSlots.bottom,n=void 0!==this.$scopedSlots.top;return slotsDef.forEach(i=>{const s=i[0];void 0!==this.$scopedSlots[s]&&e.push(t("div",{ref:s,class:`q-slide-item__${s} absolute-full row no-wrap items-${i[1]} justify-${i[2]}`+(void 0!==this[s+"Color"]?` bg-${this[s+"Color"]}`:"")},[t("div",{ref:s+"Content"},this.$scopedSlots[s]())]))}),e.push(t("div",{ref:"content",key:"content",staticClass:"q-slide-item__content",directives:!0===i||!0===s||!0===o||!0===n?[{name:"touch-pan",value:this.__pan,modifiers:{left:i,right:s,up:o,down:n,prevent:!0,stop:!0,mouse:!0}}]:null},slot(this,"default"))),t("div",{staticClass:"q-slide-item q-item-type overflow-hidden",class:!0===this.isDark?"q-slide-item--dark q-dark":"",on:{...this.qListeners}},e)},beforeDestroy(){clearTimeout(this.timer)}}),QSpace=Vue.extend({name:"QSpace",mixins:[ListenersMixin],render(t){return t("div",{staticClass:"q-space",on:{...this.qListeners}})}}),QSpinnerAudio=Vue.extend({name:"QSpinnerAudio",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",fill:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 55 80",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{transform:"matrix(1 0 0 -1 0 80)"}},[t("rect",{attrs:{width:"10",height:"20",rx:"3"}},[t("animate",{attrs:{attributeName:"height",begin:"0s",dur:"4.3s",values:"20;45;57;80;64;32;66;45;64;23;66;13;64;56;34;34;2;23;76;79;20",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"15",width:"10",height:"80",rx:"3"}},[t("animate",{attrs:{attributeName:"height",begin:"0s",dur:"2s",values:"80;55;33;5;75;23;73;33;12;14;60;80",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"30",width:"10",height:"50",rx:"3"}},[t("animate",{attrs:{attributeName:"height",begin:"0s",dur:"1.4s",values:"50;34;78;23;56;23;34;76;80;54;21;50",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"45",width:"10",height:"30",rx:"3"}},[t("animate",{attrs:{attributeName:"height",begin:"0s",dur:"2s",values:"30;45;13;80;56;72;45;76;34;23;67;30",calcMode:"linear",repeatCount:"indefinite"}})])])])}}),QSpinnerBall=Vue.extend({name:"QSpinnerBall",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",stroke:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 57 57",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"}},[t("circle",{attrs:{cx:"5",cy:"50",r:"5"}},[t("animate",{attrs:{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;5;50;50",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"cx",begin:"0s",dur:"2.2s",values:"5;27;49;5",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"27",cy:"5",r:"5"}},[t("animate",{attrs:{attributeName:"cy",begin:"0s",dur:"2.2s",from:"5",to:"5",values:"5;50;50;5",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"cx",begin:"0s",dur:"2.2s",from:"27",to:"27",values:"27;49;5;27",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"49",cy:"50",r:"5"}},[t("animate",{attrs:{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;50;5;50",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"cx",from:"49",to:"49",begin:"0s",dur:"2.2s",values:"49;5;27;49",calcMode:"linear",repeatCount:"indefinite"}})])])])}}),QSpinnerBars=Vue.extend({name:"QSpinnerBars",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",fill:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 135 140",xmlns:"http://www.w3.org/2000/svg"}},[t("rect",{attrs:{y:"10",width:"15",height:"120",rx:"6"}},[t("animate",{attrs:{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"30",y:"10",width:"15",height:"120",rx:"6"}},[t("animate",{attrs:{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"60",width:"15",height:"140",rx:"6"}},[t("animate",{attrs:{attributeName:"height",begin:"0s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"y",begin:"0s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"90",y:"10",width:"15",height:"120",rx:"6"}},[t("animate",{attrs:{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"}})]),t("rect",{attrs:{x:"120",y:"10",width:"15",height:"120",rx:"6"}},[t("animate",{attrs:{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"}})])])}}),QSpinnerComment=Vue.extend({name:"QSpinnerComment",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"}},[t("rect",{attrs:{x:"0",y:"0",width:"100",height:"100",fill:"none"}}),t("path",{attrs:{d:"M78,19H22c-6.6,0-12,5.4-12,12v31c0,6.6,5.4,12,12,12h37.2c0.4,3,1.8,5.6,3.7,7.6c2.4,2.5,5.1,4.1,9.1,4 c-1.4-2.1-2-7.2-2-10.3c0-0.4,0-0.8,0-1.3h8c6.6,0,12-5.4,12-12V31C90,24.4,84.6,19,78,19z",fill:"currentColor"}}),t("circle",{attrs:{cx:"30",cy:"47",r:"5",fill:"#fff"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",values:"0;1;1",keyTimes:"0;0.2;1",dur:"1s",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"50",cy:"47",r:"5",fill:"#fff"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.2;0.4;1",dur:"1s",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"70",cy:"47",r:"5",fill:"#fff"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.4;0.6;1",dur:"1s",repeatCount:"indefinite"}})])])}}),QSpinnerCube=Vue.extend({name:"QSpinnerCube",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"}},[t("rect",{attrs:{x:"0",y:"0",width:"100",height:"100",fill:"none"}}),t("g",{attrs:{transform:"translate(25 25)"}},[t("rect",{attrs:{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.9"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"}})])]),t("g",{attrs:{transform:"translate(75 25)"}},[t("rect",{attrs:{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.8"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.1s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"}})])]),t("g",{attrs:{transform:"translate(25 75)"}},[t("rect",{staticClass:"cube",attrs:{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.7"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.3s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"}})])]),t("g",{attrs:{transform:"translate(75 75)"}},[t("rect",{staticClass:"cube",attrs:{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.6"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.2s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"}})])])])}}),QSpinnerDots=Vue.extend({name:"QSpinnerDots",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",fill:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 120 30",xmlns:"http://www.w3.org/2000/svg"}},[t("circle",{attrs:{cx:"15",cy:"15",r:"15"}},[t("animate",{attrs:{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"60",cy:"15",r:"9","fill-opacity":".3"}},[t("animate",{attrs:{attributeName:"r",from:"9",to:"9",begin:"0s",dur:"0.8s",values:"9;15;9",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"fill-opacity",from:".5",to:".5",begin:"0s",dur:"0.8s",values:".5;1;.5",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"105",cy:"15",r:"15"}},[t("animate",{attrs:{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"}})])])}}),QSpinnerFacebook=Vue.extend({name:"QSpinnerFacebook",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",xmlns:"http://www.w3.org/2000/svg",preserveAspectRatio:"xMidYMid"}},[t("g",{attrs:{transform:"translate(20 50)"}},[t("rect",{attrs:{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.6"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"}})])]),t("g",{attrs:{transform:"translate(50 50)"}},[t("rect",{attrs:{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.8"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.1s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"}})])]),t("g",{attrs:{transform:"translate(80 50)"}},[t("rect",{attrs:{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.9"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.2s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"}})])])])}}),QSpinnerGears=Vue.extend({name:"QSpinnerGears",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{transform:"translate(-20,-20)"}},[t("path",{attrs:{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"90 50 50",to:"0 50 50",dur:"1s",repeatCount:"indefinite"}})])]),t("g",{attrs:{transform:"translate(20,20) rotate(15 50 50)"}},[t("path",{attrs:{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"90 50 50",dur:"1s",repeatCount:"indefinite"}})])])])}}),QSpinnerGrid=Vue.extend({name:"QSpinnerGrid",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",fill:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 105 105",xmlns:"http://www.w3.org/2000/svg"}},[t("circle",{attrs:{cx:"12.5",cy:"12.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"0s",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"12.5",cy:"52.5",r:"12.5","fill-opacity":".5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"100ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"52.5",cy:"12.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"300ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"52.5",cy:"52.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"600ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"92.5",cy:"12.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"800ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"92.5",cy:"52.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"400ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"12.5",cy:"92.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"700ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"52.5",cy:"92.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"500ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"92.5",cy:"92.5",r:"12.5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"200ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"}})])])}}),QSpinnerHearts=Vue.extend({name:"QSpinnerHearts",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",fill:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 140 64",xmlns:"http://www.w3.org/2000/svg"}},[t("path",{attrs:{d:"M30.262 57.02L7.195 40.723c-5.84-3.976-7.56-12.06-3.842-18.063 3.715-6 11.467-7.65 17.306-3.68l4.52 3.76 2.6-5.274c3.716-6.002 11.47-7.65 17.304-3.68 5.84 3.97 7.56 12.054 3.842 18.062L34.49 56.118c-.897 1.512-2.793 1.915-4.228.9z","fill-opacity":".5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"0s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"}})]),t("path",{attrs:{d:"M105.512 56.12l-14.44-24.272c-3.716-6.008-1.996-14.093 3.843-18.062 5.835-3.97 13.588-2.322 17.306 3.68l2.6 5.274 4.52-3.76c5.84-3.97 13.593-2.32 17.308 3.68 3.718 6.003 1.998 14.088-3.842 18.064L109.74 57.02c-1.434 1.014-3.33.61-4.228-.9z","fill-opacity":".5"}},[t("animate",{attrs:{attributeName:"fill-opacity",begin:"0.7s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"}})]),t("path",{attrs:{d:"M67.408 57.834l-23.01-24.98c-5.864-6.15-5.864-16.108 0-22.248 5.86-6.14 15.37-6.14 21.234 0L70 16.168l4.368-5.562c5.863-6.14 15.375-6.14 21.235 0 5.863 6.14 5.863 16.098 0 22.247l-23.007 24.98c-1.43 1.556-3.757 1.556-5.188 0z"}})])}}),QSpinnerHourglass=Vue.extend({name:"QSpinnerHourglass",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"}},[t("g",[t("path",{staticClass:"glass",attrs:{fill:"none",stroke:"currentColor","stroke-width":"5","stroke-miterlimit":"10",d:"M58.4,51.7c-0.9-0.9-1.4-2-1.4-2.3s0.5-0.4,1.4-1.4 C70.8,43.8,79.8,30.5,80,15.5H70H30H20c0.2,15,9.2,28.1,21.6,32.3c0.9,0.9,1.4,1.2,1.4,1.5s-0.5,1.6-1.4,2.5 C29.2,56.1,20.2,69.5,20,85.5h10h40h10C79.8,69.5,70.8,55.9,58.4,51.7z"}}),t("clipPath",{attrs:{id:"uil-hourglass-clip1"}},[t("rect",{staticClass:"clip",attrs:{x:"15",y:"20",width:"70",height:"25"}},[t("animate",{attrs:{attributeName:"height",from:"25",to:"0",dur:"1s",repeatCount:"indefinite",values:"25;0;0",keyTimes:"0;0.5;1"}}),t("animate",{attrs:{attributeName:"y",from:"20",to:"45",dur:"1s",repeatCount:"indefinite",values:"20;45;45",keyTimes:"0;0.5;1"}})])]),t("clipPath",{attrs:{id:"uil-hourglass-clip2"}},[t("rect",{staticClass:"clip",attrs:{x:"15",y:"55",width:"70",height:"25"}},[t("animate",{attrs:{attributeName:"height",from:"0",to:"25",dur:"1s",repeatCount:"indefinite",values:"0;25;25",keyTimes:"0;0.5;1"}}),t("animate",{attrs:{attributeName:"y",from:"80",to:"55",dur:"1s",repeatCount:"indefinite",values:"80;55;55",keyTimes:"0;0.5;1"}})])]),t("path",{staticClass:"sand",attrs:{d:"M29,23c3.1,11.4,11.3,19.5,21,19.5S67.9,34.4,71,23H29z","clip-path":"url(#uil-hourglass-clip1)",fill:"currentColor"}}),t("path",{staticClass:"sand",attrs:{d:"M71.6,78c-3-11.6-11.5-20-21.5-20s-18.5,8.4-21.5,20H71.6z","clip-path":"url(#uil-hourglass-clip2)",fill:"currentColor"}}),t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"180 50 50",repeatCount:"indefinite",dur:"1s",values:"0 50 50;0 50 50;180 50 50",keyTimes:"0;0.7;1"}})])])}}),QSpinnerInfinity=Vue.extend({name:"QSpinnerInfinity",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"}},[t("path",{attrs:{d:"M24.3,30C11.4,30,5,43.3,5,50s6.4,20,19.3,20c19.3,0,32.1-40,51.4-40C88.6,30,95,43.3,95,50s-6.4,20-19.3,20C56.4,70,43.6,30,24.3,30z",fill:"none",stroke:"currentColor","stroke-width":"8","stroke-dasharray":"10.691205342610678 10.691205342610678","stroke-dashoffset":"0"}},[t("animate",{attrs:{attributeName:"stroke-dashoffset",from:"0",to:"21.382410685221355",begin:"0",dur:"2s",repeatCount:"indefinite",fill:"freeze"}})])])}}),QSpinnerIos=Vue.extend({name:"QSpinnerIos",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,stroke:"currentColor",fill:"currentColor",viewBox:"0 0 64 64"}},[t("g",{attrs:{"stroke-width":"4","stroke-linecap":"round"}},[t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(180)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(210)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:"0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(240)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".1;0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(270)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".15;.1;0;1;.85;.7;.65;.55;.45;.35;.25;.15",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(300)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".25;.15;.1;0;1;.85;.7;.65;.55;.45;.35;.25",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(330)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".35;.25;.15;.1;0;1;.85;.7;.65;.55;.45;.35",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(0)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".45;.35;.25;.15;.1;0;1;.85;.7;.65;.55;.45",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(30)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".55;.45;.35;.25;.15;.1;0;1;.85;.7;.65;.55",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(60)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".65;.55;.45;.35;.25;.15;.1;0;1;.85;.7;.65",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(90)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".7;.65;.55;.45;.35;.25;.15;.1;0;1;.85;.7",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(120)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:".85;.7;.65;.55;.45;.35;.25;.15;.1;0;1;.85",repeatCount:"indefinite"}})]),t("line",{attrs:{y1:"17",y2:"29",transform:"translate(32,32) rotate(150)"}},[t("animate",{attrs:{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"}})])])])}}),QSpinnerOval=Vue.extend({name:"QSpinnerOval",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",stroke:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"}},[t("circle",{attrs:{"stroke-opacity":".5",cx:"18",cy:"18",r:"18"}}),t("path",{attrs:{d:"M36 18c0-9.94-8.06-18-18-18"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"1s",repeatCount:"indefinite"}})])])])}}),QSpinnerPie=Vue.extend({name:"QSpinnerPie",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"}},[t("path",{attrs:{d:"M0 50A50 50 0 0 1 50 0L50 50L0 50",fill:"currentColor",opacity:"0.5"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"0.8s",repeatCount:"indefinite"}})]),t("path",{attrs:{d:"M50 0A50 50 0 0 1 100 50L50 50L50 0",fill:"currentColor",opacity:"0.5"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"1.6s",repeatCount:"indefinite"}})]),t("path",{attrs:{d:"M100 50A50 50 0 0 1 50 100L50 50L100 50",fill:"currentColor",opacity:"0.5"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"2.4s",repeatCount:"indefinite"}})]),t("path",{attrs:{d:"M50 100A50 50 0 0 1 0 50L50 50L50 100",fill:"currentColor",opacity:"0.5"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"3.2s",repeatCount:"indefinite"}})])])}}),QSpinnerPuff=Vue.extend({name:"QSpinnerPuff",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",stroke:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 44 44",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{fill:"none","fill-rule":"evenodd","stroke-width":"2"}},[t("circle",{attrs:{cx:"22",cy:"22",r:"1"}},[t("animate",{attrs:{attributeName:"r",begin:"0s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-opacity",begin:"0s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"22",cy:"22",r:"1"}},[t("animate",{attrs:{attributeName:"r",begin:"-0.9s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-opacity",begin:"-0.9s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"}})])])])}}),QSpinnerRadio=Vue.extend({name:"QSpinnerRadio",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{transform:"scale(0.55)"}},[t("circle",{attrs:{cx:"30",cy:"150",r:"30",fill:"currentColor"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"}})]),t("path",{attrs:{d:"M90,150h30c0-49.7-40.3-90-90-90v30C63.1,90,90,116.9,90,150z",fill:"currentColor"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.1",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"}})]),t("path",{attrs:{d:"M150,150h30C180,67.2,112.8,0,30,0v30C96.3,30,150,83.7,150,150z",fill:"currentColor"}},[t("animate",{attrs:{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.2",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"}})])])])}}),QSpinnerRings=Vue.extend({name:"QSpinnerRings",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",stroke:"currentColor",width:this.cSize,height:this.cSize,viewBox:"0 0 45 45",xmlns:"http://www.w3.org/2000/svg"}},[t("g",{attrs:{fill:"none","fill-rule":"evenodd",transform:"translate(1 1)","stroke-width":"2"}},[t("circle",{attrs:{cx:"22",cy:"22",r:"6"}},[t("animate",{attrs:{attributeName:"r",begin:"1.5s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-opacity",begin:"1.5s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-width",begin:"1.5s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"22",cy:"22",r:"6"}},[t("animate",{attrs:{attributeName:"r",begin:"3s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-opacity",begin:"3s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}}),t("animate",{attrs:{attributeName:"stroke-width",begin:"3s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"}})]),t("circle",{attrs:{cx:"22",cy:"22",r:"8"}},[t("animate",{attrs:{attributeName:"r",begin:"0s",dur:"1.5s",values:"6;1;2;3;4;5;6",calcMode:"linear",repeatCount:"indefinite"}})])])])}}),QSpinnerTail=Vue.extend({name:"QSpinnerTail",mixins:[mixin$1],render(t){return t("svg",{staticClass:"q-spinner",class:this.classes,on:{...this.qListeners},attrs:{focusable:"false",width:this.cSize,height:this.cSize,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"}},[t("defs",[t("linearGradient",{attrs:{x1:"8.042%",y1:"0%",x2:"65.682%",y2:"23.865%",id:"a"}},[t("stop",{attrs:{"stop-color":"currentColor","stop-opacity":"0",offset:"0%"}}),t("stop",{attrs:{"stop-color":"currentColor","stop-opacity":".631",offset:"63.146%"}}),t("stop",{attrs:{"stop-color":"currentColor",offset:"100%"}})])]),t("g",{attrs:{transform:"translate(1 1)",fill:"none","fill-rule":"evenodd"}},[t("path",{attrs:{d:"M36 18c0-9.94-8.06-18-18-18",stroke:"url(#a)","stroke-width":"2"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"}})]),t("circle",{attrs:{fill:"currentColor",cx:"36",cy:"18",r:"1"}},[t("animateTransform",{attrs:{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"}})])])])}}),QSplitter=Vue.extend({name:"QSplitter",mixins:[DarkMixin,ListenersMixin],directives:{TouchPan:TouchPan},props:{value:{type:Number,required:!0},reverse:Boolean,unit:{type:String,default:"%",validator:t=>["%","px"].includes(t)},limits:{type:Array,validator:t=>2===t.length&&("number"==typeof t[0]&&"number"==typeof t[1]&&(t[0]>=0&&t[0]<=t[1]))},emitImmediately:Boolean,horizontal:Boolean,disable:Boolean,beforeClass:[Array,String,Object],afterClass:[Array,String,Object],separatorClass:[Array,String,Object],separatorStyle:[Array,String,Object]},watch:{value:{immediate:!0,handler(t){this.__normalize(t,this.computedLimits)}},limits:{deep:!0,handler(){this.$nextTick(()=>{this.__normalize(this.value,this.computedLimits)})}}},computed:{classes(){return(!0===this.horizontal?"column":"row")+` q-splitter--${!0===this.horizontal?"horizontal":"vertical"}`+` q-splitter--${!0===this.disable?"disabled":"workable"}`+(!0===this.isDark?" q-splitter--dark":"")},prop(){return!0===this.horizontal?"height":"width"},side(){return!0!==this.reverse?"before":"after"},computedLimits(){return void 0!==this.limits?this.limits:"%"===this.unit?[10,90]:[50,1/0]},styles(){return{[this.side]:{[this.prop]:this.__getCSSValue(this.value)}}}},methods:{__pan(t){if(!0===t.isFirst){const t=this.$el.getBoundingClientRect()[this.prop];return this.__dir=!0===this.horizontal?"up":"left",this.__maxValue="%"===this.unit?100:t,this.__value=Math.min(this.__maxValue,this.computedLimits[1],Math.max(this.computedLimits[0],this.value)),this.__multiplier=(!0!==this.reverse?1:-1)*(!0===this.horizontal?1:!0===this.$q.lang.rtl?-1:1)*("%"===this.unit?0===t?0:100/t:1),void this.$el.classList.add("q-splitter--active")}if(!0===t.isFinal)return this.__normalized!==this.value&&this.$emit("input",this.__normalized),void this.$el.classList.remove("q-splitter--active");const e=this.__value+this.__multiplier*(t.direction===this.__dir?-1:1)*t.distance[!0===this.horizontal?"y":"x"];this.__normalized=Math.min(this.__maxValue,this.computedLimits[1],Math.max(this.computedLimits[0],e)),this.$refs[this.side].style[this.prop]=this.__getCSSValue(this.__normalized),!0===this.emitImmediately&&this.value!==this.__normalized&&this.$emit("input",this.__normalized)},__normalize(t,e){t<e[0]?this.$emit("input",e[0]):t>e[1]&&this.$emit("input",e[1])},__getCSSValue(t){return("%"===this.unit?t:Math.round(t))+this.unit}},render(t){const e=!0===this.disable?{"aria-disabled":""}:void 0,i=[t("div",{ref:"before",staticClass:"q-splitter__panel q-splitter__before"+(!0===this.reverse?" col":""),style:this.styles.before,class:this.beforeClass,on:cache(this,"stop",{input:stop})},slot(this,"before")),t("div",{staticClass:"q-splitter__separator",style:this.separatorStyle,class:this.separatorClass,attrs:e},[t("div",{staticClass:"absolute-full q-splitter__separator-area",directives:!0===this.disable?void 0:cache(this,"dir#"+this.horizontal,[{name:"touch-pan",value:this.__pan,modifiers:{horizontal:!0!==this.horizontal,vertical:this.horizontal,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}}])},slot(this,"separator"))]),t("div",{ref:"after",staticClass:"q-splitter__panel q-splitter__after"+(!0===this.reverse?"":" col"),style:this.styles.after,class:this.afterClass,on:cache(this,"stop",{input:stop})},slot(this,"after"))];return t("div",{staticClass:"q-splitter no-wrap",class:this.classes,on:{...this.qListeners}},mergeSlot(i,this,"default"))}}),StepHeader=Vue.extend({name:"StepHeader",mixins:[AttrsMixin],directives:{Ripple:Ripple},props:{stepper:{},step:{}},computed:{isActive(){return this.stepper.value===this.step.name},isDisable(){const t=this.step.disable;return!0===t||""===t},isError(){const t=this.step.error;return!0===t||""===t},isDone(){const t=this.step.done;return!1===this.isDisable&&(!0===t||""===t)},headerNav(){const t=this.step.headerNav,e=!0===t||""===t||void 0===t;return!1===this.isDisable&&this.stepper.headerNav&&e},hasPrefix(){return this.step.prefix&&!1===this.isActive&&!1===this.isError&&!1===this.isDone},icon(){return!0===this.isActive?this.step.activeIcon||this.stepper.activeIcon||this.$q.iconSet.stepper.active:!0===this.isError?this.step.errorIcon||this.stepper.errorIcon||this.$q.iconSet.stepper.error:!1===this.isDisable&&!0===this.isDone?this.step.doneIcon||this.stepper.doneIcon||this.$q.iconSet.stepper.done:this.step.icon||this.stepper.inactiveIcon},color(){const t=!0===this.isError?this.step.errorColor||this.stepper.errorColor:void 0;if(!0===this.isActive){const e=this.step.activeColor||this.stepper.activeColor||this.step.color;return void 0!==e?e:t}return void 0!==t?t:!1===this.isDisable&&!0===this.isDone?this.step.doneColor||this.stepper.doneColor||this.step.color||this.stepper.inactiveColor:this.step.color||this.stepper.inactiveColor},classes(){return"q-stepper__tab col-grow flex items-center no-wrap relative-position"+(void 0!==this.color?` text-${this.color}`:"")+(!0===this.isError?" q-stepper__tab--error":"")+(!0===this.isActive?" q-stepper__tab--active":"")+(!0===this.isDone?" q-stepper__tab--done":"")+(!0===this.headerNav?" q-stepper__tab--navigation q-focusable q-hoverable":"")+(!0===this.isDisable?" q-stepper__tab--disabled":"")}},methods:{activate(){void 0!==this.$refs.blurTarget&&this.$refs.blurTarget.focus(),!1===this.isActive&&this.stepper.goTo(this.step.name)},keyup(t){13===t.keyCode&&!1===this.isActive&&this.stepper.goTo(this.step.name)}},render(t){const e={class:this.classes};!0===this.stepper.headerNav&&(e.directives=[{name:"ripple",value:this.headerNav}]),!0===this.headerNav&&Object.assign(e,{on:cache(this,"headnavon",{click:this.activate,keyup:this.keyup}),attrs:!0===this.isDisable?{tabindex:-1,"aria-disabled":""}:{tabindex:this.qAttrs.tabindex||0}});const i=[t("div",{staticClass:"q-focus-helper",attrs:{tabindex:-1},ref:"blurTarget"}),t("div",{staticClass:"q-stepper__dot row flex-center q-stepper__line relative-position"},[t("span",{staticClass:"row flex-center"},[!0===this.hasPrefix?this.step.prefix:t(QIcon,{props:{name:this.icon}})])])];if(void 0!==this.step.title&&null!==this.step.title){const e=[t("div",{staticClass:"q-stepper__title"},[this.step.title])];void 0!==this.step.caption&&null!==this.step.caption&&e.push(t("div",{staticClass:"q-stepper__caption"},[this.step.caption])),i.push(t("div",{staticClass:"q-stepper__label q-stepper__line relative-position"},e))}return t("div",e,i)}});const StepWrapper=Vue.extend({name:"QStepWrapper",render(t){return t("div",{staticClass:"q-stepper__step-content"},[t("div",{staticClass:"q-stepper__step-inner"},slot(this,"default"))])}});var QStep=Vue.extend({name:"QStep",inject:{stepper:{default(){console.error("QStep needs to be child of QStepper")}}},mixins:[PanelChildMixin],props:{icon:String,color:String,title:{type:String,required:!0},caption:String,prefix:[String,Number],doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String,headerNav:{type:Boolean,default:!0},done:Boolean,error:Boolean},computed:{isActive(){return this.stepper.value===this.name}},watch:{isActive(t){!0===t&&!0===this.stepper.vertical&&this.$nextTick(()=>{void 0!==this.$el&&(this.$el.scrollTop=0)})}},render(t){const e=this.stepper.vertical,i=!0===e&&!0===this.stepper.keepAlive?t("keep-alive",!0===this.isActive?[t(StepWrapper,{key:this.name},slot(this,"default"))]:void 0):!0!==e||!0===this.isActive?StepWrapper.options.render.call(this,t):void 0;return t("div",{staticClass:"q-stepper__step",on:{...this.qListeners}},!0===e?[t(StepHeader,{props:{stepper:this.stepper,step:this}}),!0===this.stepper.animated?t(QSlideTransition,[i]):i]:[i])}}),QStepper=Vue.extend({name:"QStepper",provide(){return{stepper:this}},mixins:[DarkMixin,PanelParentMixin],props:{flat:Boolean,bordered:Boolean,alternativeLabels:Boolean,headerNav:Boolean,contracted:Boolean,headerClass:String,inactiveColor:String,inactiveIcon:String,doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String},computed:{classes(){return`q-stepper q-stepper--${!0===this.vertical?"vertical":"horizontal"}`+(!0===this.flat||!0===this.isDark?" q-stepper--flat no-shadow":"")+(!0===this.bordered||!0===this.isDark&&!1===this.flat?" q-stepper--bordered":"")+(!0===this.contracted?" q-stepper--contracted":"")+(!0===this.isDark?" q-stepper--dark q-dark":"")},headerClasses(){return"q-stepper__header row items-stretch justify-between"+` q-stepper__header--${!0===this.alternativeLabels?"alternative":"standard"}-labels`+(!1===this.flat||!0===this.bordered?" q-stepper__header--border":"")+(void 0!==this.headerClass?` ${this.headerClass}`:"")}},methods:{__getContent(t){const e=slot(this,"message",[]);return!0===this.vertical?(this.__isValidPanelName(this.value)&&this.__updatePanelIndex(),(void 0===e?[]:e).concat(t("div",{staticClass:"q-stepper__content",on:cache(this,"stop",{input:stop})},slot(this,"default")))):[t("div",{class:this.headerClasses},this.__getAllPanels().map(e=>{const i=e.componentOptions.propsData;return t(StepHeader,{key:i.name,props:{stepper:this,step:i}})}))].concat(e,t("div",{staticClass:"q-stepper__content q-panel-parent",directives:this.panelDirectives},this.__getPanelContent(t)))},__renderPanels(t){return t("div",{class:this.classes,on:{...this.qListeners}},mergeSlot(this.__getContent(t),this,"navigation"))}}}),QStepperNavigation=Vue.extend({name:"QStepperNavigation",mixins:[ListenersMixin],render(t){return t("div",{staticClass:"q-stepper__nav",on:{...this.qListeners}},slot(this,"default"))}}),Top={computed:{marginalsProps(){return{pagination:this.computedPagination,pagesNumber:this.pagesNumber,isFirstPage:this.isFirstPage,isLastPage:this.isLastPage,firstPage:this.firstPage,prevPage:this.prevPage,nextPage:this.nextPage,lastPage:this.lastPage,inFullscreen:this.inFullscreen,toggleFullscreen:this.toggleFullscreen}}},methods:{getTop(t){const e=this.$scopedSlots.top,i=this.$scopedSlots["top-left"],s=this.$scopedSlots["top-right"],o=this.$scopedSlots["top-selection"],n=!0===this.hasSelectionMode&&void 0!==o&&this.rowsSelectedNumber>0,r="q-table__top relative-position row items-center";if(void 0!==e)return t("div",{staticClass:r},[e(this.marginalsProps)]);let a;return!0===n?a=o(this.marginalsProps).slice():(a=[],void 0!==i?a.push(t("div",{staticClass:"q-table-control"},[i(this.marginalsProps)])):this.title&&a.push(t("div",{staticClass:"q-table__control"},[t("div",{staticClass:"q-table__title"},this.title)]))),void 0!==s&&(a.push(t("div",{staticClass:"q-table__separator col"})),a.push(t("div",{staticClass:"q-table__control"},[s(this.marginalsProps)]))),0!==a.length?t("div",{staticClass:r},a):void 0}}},QTh=Vue.extend({name:"QTh",mixins:[ListenersMixin],props:{props:Object,autoWidth:Boolean},render(t){const e={...this.qListeners};if(void 0===this.props)return t("th",{on:e,class:!0===this.autoWidth?"q-table--col-auto-width":null},slot(this,"default"));let i,s;const o=this.$vnode.key;if(o){if(void 0===(i=this.props.colsMap[o]))return}else i=this.props.col;if(!0===i.sortable){const e="right"===i.align?"unshift":"push";(s=uniqueSlot(this,"default",[]))[e](t(QIcon,{props:{name:this.$q.iconSet.table.arrowUp},staticClass:i.__iconClass}))}else s=slot(this,"default");const n=!0===i.sortable?{click:t=>{this.props.sort(i),this.$emit("click",t)}}:{};return t("th",{on:{...e,...n},style:i.headerStyle,class:i.__thClass+(!0===this.autoWidth?" q-table--col-auto-width":"")},s)}}),TableHeader={methods:{getTableHeader(t){const e=this.getTableHeaderRow(t);return!0===this.loading&&void 0===this.$scopedSlots.loading&&e.push(t("tr",{staticClass:"q-table__progress"},[t("th",{staticClass:"relative-position",attrs:{colspan:"100%"}},this.__getProgress(t))])),t("thead",e)},getTableHeaderRow(t){const e=this.$scopedSlots.header,i=this.$scopedSlots["header-cell"];if(void 0!==e)return e(this.addTableHeaderRowMeta({header:!0,cols:this.computedCols,sort:this.sort,colsMap:this.computedColsMap})).slice();const s=this.computedCols.map(e=>{const s=this.$scopedSlots[`header-cell-${e.name}`],o=void 0!==s?s:i,n={col:e,cols:this.computedCols,sort:this.sort,colsMap:this.computedColsMap};return void 0!==o?o(n):t(QTh,{key:e.name,props:{props:n},style:e.headerStyle,class:e.headerClasses},e.label)});return!0===this.singleSelection&&!0!==this.grid?s.unshift(t("th",{staticClass:"q-table--col-auto-width"},[" "])):!0===this.multipleSelection&&s.unshift(t("th",{staticClass:"q-table--col-auto-width"},[t(QCheckbox,{props:{color:this.color,value:!0===this.someRowsSelected?null:this.allRowsSelected,dark:this.isDark,dense:this.dense},on:cache(this,"inp",{input:t=>{!0===this.someRowsSelected&&(t=!1),this.__updateSelection(this.computedRows.map(this.getRowKey),this.computedRows,t)}})})])),[t("tr",{style:this.tableHeaderStyle,class:this.tableHeaderClass},s)]},addTableHeaderRowMeta(t){return!0===this.multipleSelection&&(Object.defineProperty(t,"selected",{get:()=>!0===this.someRowsSelected?"some":this.allRowsSelected,set:t=>{!0===this.someRowsSelected&&(t=!1),this.__updateSelection(this.computedRows.map(this.getRowKey),this.computedRows,t)},configurable:!0,enumerable:!0}),t.partialSelected=this.someRowsSelected,t.multipleSelect=!0),t}}},TableBody={methods:{getTableRowBody(t,e,i){const s=this.getRowKey(t),o=this.isRowSelected(s);return e(this.addBodyRowMeta({key:s,row:t,pageIndex:i,cols:this.computedCols,colsMap:this.computedColsMap,__trClass:o?"selected":""}))},getTableRow(t,e,i){const s=this.$scopedSlots["body-cell"],o=this.getRowKey(e),n=this.isRowSelected(o),r=this.computedCols.map(o=>{const n=this.$scopedSlots[`body-cell-${o.name}`],r=void 0!==n?n:s;return void 0!==r?r(this.addBodyCellMetaData({row:e,pageIndex:i,col:o})):t("td",{class:o.__tdClass,style:o.style},this.getCellValue(o,e))});!0===this.hasSelectionMode&&r.unshift(t("td",{staticClass:"q-table--col-auto-width"},[t(QCheckbox,{props:{value:n,color:this.color,dark:this.isDark,dense:this.dense},on:{input:(t,i)=>{this.__updateSelection([o],[e],t,i)}}})]));const a={key:o,class:{selected:n},on:{}};return void 0!==this.qListeners["row-click"]&&(a.class["cursor-pointer"]=!0,a.on.click=(t=>{this.$emit("row-click",t,e)})),void 0!==this.qListeners["row-dblclick"]&&(a.class["cursor-pointer"]=!0,a.on.dblclick=(t=>{this.$emit("row-dblclick",t,e)})),t("tr",a,r)},getTableBody(t){const e=this.$scopedSlots.body,i=this.$scopedSlots["top-row"],s=this.$scopedSlots["bottom-row"],o=void 0!==e?(t,i)=>this.getTableRowBody(t,e,i):(e,i)=>this.getTableRow(t,e,i);let n=this.computedRows.map(o);return void 0!==i&&(n=i({cols:this.computedCols}).concat(n)),void 0!==s&&(n=n.concat(s({cols:this.computedCols}))),t("tbody",n)},getTableRowVirtual(t){const e=this.$scopedSlots.body;return void 0!==e?(t,i)=>this.getTableRowBody(t.item,e,i):(e,i)=>this.getTableRow(t,e.item,i)},addBodyRowMeta(t){return t.rowIndex=this.firstRowIndex+t.pageIndex,!0===this.hasSelectionMode&&Object.defineProperty(t,"selected",{get:()=>this.isRowSelected(t.key),set:e=>{this.__updateSelection([t.key],[t.row],e)},configurable:!0,enumerable:!0}),Object.defineProperty(t,"expand",{get:()=>this.isRowExpanded(t.key),set:e=>{this.__updateExpanded(t.key,e)},configurable:!0,enumerable:!0}),t.cols=t.cols.map(e=>{const i={...e};return Object.defineProperty(i,"value",{get:()=>this.getCellValue(e,t.row),configurable:!0,enumerable:!0}),i}),t},addBodyCellMetaData(t){return t.rowIndex=this.firstRowIndex+t.pageIndex,Object.defineProperty(t,"value",{get:()=>this.getCellValue(t.col,t.row),configurable:!0,enumerable:!0}),t},getCellValue(t,e){const i="function"==typeof t.field?t.field(e):e[t.field];return void 0!==t.format?t.format(i,e):i}}};const staticClass="q-table__bottom row items-center";var Bottom={props:{hideBottom:Boolean,hideSelectedBanner:Boolean,hideNoData:Boolean,hidePagination:Boolean},computed:{navIcon(){const t=[this.iconFirstPage||this.$q.iconSet.table.firstPage,this.iconPrevPage||this.$q.iconSet.table.prevPage,this.iconNextPage||this.$q.iconSet.table.nextPage,this.iconLastPage||this.$q.iconSet.table.lastPage];return!0===this.$q.lang.rtl?t.reverse():t}},methods:{getBottom(t){if(!0===this.hideBottom)return;if(!0===this.nothingToDisplay){if(!0===this.hideNoData)return;const e=!0===this.loading?this.loadingLabel||this.$q.lang.table.loading:this.filter?this.noResultsLabel||this.$q.lang.table.noResults:this.noDataLabel||this.$q.lang.table.noData,i=this.$scopedSlots["no-data"],s=void 0!==i?[i({message:e,icon:this.$q.iconSet.table.warning,filter:this.filter})]:[t(QIcon,{staticClass:"q-table__bottom-nodata-icon",props:{name:this.$q.iconSet.table.warning}}),e];return t("div",{staticClass:staticClass+" q-table__bottom--nodata"},s)}const e=this.$scopedSlots.bottom;if(void 0!==e)return t("div",{staticClass:staticClass},[e(this.marginalsProps)]);const i=!0!==this.hideSelectedBanner&&!0===this.hasSelectionMode&&this.rowsSelectedNumber>0?[t("div",{staticClass:"q-table__control"},[t("div",[(this.selectedRowsLabel||this.$q.lang.table.selectedRecords)(this.rowsSelectedNumber)])])]:[];return!0!==this.hidePagination?t("div",{staticClass:staticClass+" justify-end"},this.getPaginationRow(t,i)):i.length>0?t("div",{staticClass:staticClass},i):void 0},getPaginationRow(t,e){let i;const{rowsPerPage:s}=this.computedPagination,o=this.paginationLabel||this.$q.lang.table.pagination,n=this.$scopedSlots.pagination,r=this.rowsPerPageOptions.length>1;if(e.push(t("div",{staticClass:"q-table__separator col"})),!0===r&&e.push(t("div",{staticClass:"q-table__control"},[t("span",{staticClass:"q-table__bottom-item"},[this.rowsPerPageLabel||this.$q.lang.table.recordsPerPage]),t(QSelect,{staticClass:"q-table__select inline q-table__bottom-item",props:{color:this.color,value:s,options:this.computedRowsPerPageOptions,displayValue:0===s?this.$q.lang.table.allRows:s,dark:this.isDark,borderless:!0,dense:!0,optionsDense:!0,optionsCover:!0},on:cache(this,"pgSize",{input:t=>{this.setPagination({page:1,rowsPerPage:t.value})}})})])),void 0!==n)i=n(this.marginalsProps);else if(i=[t("span",0!==s?{staticClass:"q-table__bottom-item"}:{},[s?o(this.firstRowIndex+1,Math.min(this.lastRowIndex,this.computedRowsNumber),this.computedRowsNumber):o(1,this.filteredSortedRowsNumber,this.computedRowsNumber)])],0!==s&&this.pagesNumber>1){const e={color:this.color,round:!0,dense:!0,flat:!0};!0===this.dense&&(e.size="sm"),this.pagesNumber>2&&i.push(t(QBtn,{key:"pgFirst",props:{...e,icon:this.navIcon[0],disable:this.isFirstPage},on:cache(this,"pgFirst",{click:this.firstPage})})),i.push(t(QBtn,{key:"pgPrev",props:{...e,icon:this.navIcon[1],disable:this.isFirstPage},on:cache(this,"pgPrev",{click:this.prevPage})}),t(QBtn,{key:"pgNext",props:{...e,icon:this.navIcon[2],disable:this.isLastPage},on:cache(this,"pgNext",{click:this.nextPage})})),this.pagesNumber>2&&i.push(t(QBtn,{key:"pgLast",props:{...e,icon:this.navIcon[3],disable:this.isLastPage},on:cache(this,"pgLast",{click:this.lastPage})}))}return e.push(t("div",{staticClass:"q-table__control"},i)),e}}},TableGrid={methods:{getGridBody(t){const e=void 0!==this.$scopedSlots.item?this.$scopedSlots.item:e=>{const i=e.cols.map(e=>t("div",{staticClass:"q-table__grid-item-row"},[t("div",{staticClass:"q-table__grid-item-title"},[e.label]),t("div",{staticClass:"q-table__grid-item-value"},[e.value])]));!0===this.hasSelectionMode&&i.unshift(t("div",{staticClass:"q-table__grid-item-row"},[t(QCheckbox,{props:{value:e.selected,color:this.color,dark:this.isDark,dense:!0},on:{input:(t,i)=>{this.__updateSelection([e.key],[e.row],t,i)}}})]),t(QSeparator,{props:{dark:this.isDark}}));const s={staticClass:"q-table__grid-item-card"+this.cardDefaultClass,class:this.cardClass,style:this.cardStyle,on:{}};return void 0===this.qListeners["row-click"]&&void 0===this.qListeners["row-dblclick"]||(s.staticClass+=" cursor-pointer"),void 0!==this.qListeners["row-click"]&&(s.on.click=(t=>{this.$emit("row-click",t,e.row)})),void 0!==this.qListeners["row-dblclick"]&&(s.on.dblclick=(t=>{this.$emit("row-dblclick",t,e.row)})),t("div",{staticClass:"q-table__grid-item col-xs-12 col-sm-6 col-md-4 col-lg-3",class:!0===e.selected?"q-table__grid-item--selected":""},[t("div",s,i)])};return t("div",{staticClass:"q-table__grid-content row",class:this.cardContainerClass,style:this.cardContainerStyle},this.computedRows.map((t,i)=>{const s=this.getRowKey(t),o=this.isRowSelected(s);return e(this.addBodyRowMeta({key:s,row:t,pageIndex:i,cols:this.computedCols,colsMap:this.computedColsMap,__trClass:o?"selected":""}))}))},getGridHeader(t){return t("div",{staticClass:"q-table__middle"},!0===this.gridHeader?[t("table",{staticClass:"q-table"},[this.getTableHeader(t)])]:!0===this.loading&&void 0===this.$scopedSlots.loading?this.__getProgress(t):void 0)}}};function getTableMiddle(t,e,i){return t("div",{...e,staticClass:"q-table__middle"+(void 0!==e.staticClass?" "+e.staticClass:"")},[t("table",{staticClass:"q-table"},i)])}const comps={list:QList,table:QMarkupTable};var QVirtualScroll=Vue.extend({name:"QVirtualScroll",mixins:[AttrsMixin,ListenersMixin,VirtualScroll],props:{type:{type:String,default:"list",validator:t=>["list","table","__qtable"].includes(t)},items:{type:Array,default:()=>[]},itemsFn:Function,itemsSize:Number,scrollTarget:{default:void 0}},computed:{virtualScrollLength(){return this.itemsSize>=0&&void 0!==this.itemsFn?parseInt(this.itemsSize,10):Array.isArray(this.items)?this.items.length:0},virtualScrollScope(){if(0===this.virtualScrollLength)return[];const t=(t,e)=>({index:this.virtualScrollSliceRange.from+e,item:t});return void 0===this.itemsFn?this.items.slice(this.virtualScrollSliceRange.from,this.virtualScrollSliceRange.to).map(t):this.itemsFn(this.virtualScrollSliceRange.from,this.virtualScrollSliceRange.to-this.virtualScrollSliceRange.from).map(t)},classes(){return"q-virtual-scroll q-virtual-scroll"+(!0===this.virtualScrollHorizontal?"--horizontal":"--vertical")+(void 0!==this.scrollTarget?"":" scroll")},attrs(){return void 0!==this.scrollTarget?void 0:{tabindex:0}}},watch:{virtualScrollLength(){this.__resetVirtualScroll()},scrollTarget(){this.__unconfigureScrollTarget(),this.__configureScrollTarget()}},methods:{__getVirtualScrollEl(){return this.$el},__getVirtualScrollTarget(){return this.__scrollTarget},__configureScrollTarget(){this.__scrollTarget=getScrollTarget(this.$el,this.scrollTarget),this.__scrollTarget.addEventListener("scroll",this.__onVirtualScrollEvt,listenOpts.passive)},__unconfigureScrollTarget(){void 0!==this.__scrollTarget&&(this.__scrollTarget.removeEventListener("scroll",this.__onVirtualScrollEvt,listenOpts.passive),this.__scrollTarget=void 0)}},beforeMount(){this.__resetVirtualScroll()},mounted(){this.__configureScrollTarget()},beforeDestroy(){this.__unconfigureScrollTarget()},render(t){if(void 0===this.$scopedSlots.default)return void console.error("QVirtualScroll: default scoped slot is required for rendering",this);let e=this.__padVirtualScroll(t,"list"===this.type?"div":"tbody",this.virtualScrollScope.map(this.$scopedSlots.default));return void 0!==this.$scopedSlots.before&&(e=this.$scopedSlots.before().concat(e)),e=mergeSlot(e,this,"after"),"__qtable"===this.type?getTableMiddle(t,{staticClass:this.classes},e):t(comps[this.type],{class:this.classes,attrs:this.attrs,props:this.qAttrs,on:{...this.qListeners}},e)}});function sortDate(t,e){return new Date(t)-new Date(e)}var Sort={props:{sortMethod:{type:Function,default(t,e,i){const s=this.colList.find(t=>t.name===e);if(void 0===s||void 0===s.field)return t;const o=!0===i?-1:1,n="function"==typeof s.field?t=>s.field(t):t=>t[s.field];return t.sort((t,e)=>{let i=n(t),r=n(e);return null===i||void 0===i?-1*o:null===r||void 0===r?1*o:void 0!==s.sort?s.sort(i,r,t,e)*o:!0===isNumber(i)&&!0===isNumber(r)?(i-r)*o:!0===isDate(i)&&!0===isDate(r)?sortDate(i,r)*o:"boolean"==typeof i&&"boolean"==typeof r?(i-r)*o:([i,r]=[i,r].map(t=>(t+"").toLocaleString().toLowerCase()),i<r?-1*o:i===r?0:o)})}}},computed:{columnToSort(){const{sortBy:t}=this.computedPagination;if(t)return this.colList.find(e=>e.name===t)||null}},methods:{sort(t){t===Object(t)&&(t=t.name);let{sortBy:e,descending:i}=this.computedPagination;e!==t?(e=t,i=!1):!0===this.binaryStateSort?i=!i:!0===i?e=null:i=!0,this.setPagination({sortBy:e,descending:i,page:1})}}},Filter={props:{filter:[String,Object],filterMethod:{type:Function,default(t,e,i=this.computedCols,s=this.getCellValue){const o=e?e.toLowerCase():"";return t.filter(t=>i.some(e=>-1!==(s(e,t)+"").toLowerCase().indexOf(o)))}}},watch:{filter:{handler(){this.$nextTick(()=>{this.setPagination({page:1},!0)})},deep:!0}}};function samePagination(t,e){for(const i in e)if(e[i]!==t[i])return!1;return!0}function fixPagination(t){return t.page<1&&(t.page=1),void 0!==t.rowsPerPage&&t.rowsPerPage<1&&(t.rowsPerPage=0),t}var Pagination={props:{pagination:Object,rowsPerPageOptions:{type:Array,default:()=>[5,7,10,15,20,25,50,0]}},computed:{computedPagination(){return fixPagination(void 0!==this.qListeners["update:pagination"]?{...this.innerPagination,...this.pagination}:this.innerPagination)},firstRowIndex(){const{page:t,rowsPerPage:e}=this.computedPagination;return(t-1)*e},lastRowIndex(){const{page:t,rowsPerPage:e}=this.computedPagination;return t*e},isFirstPage(){return 1===this.computedPagination.page},pagesNumber(){return 0===this.computedPagination.rowsPerPage?1:Math.max(1,Math.ceil(this.computedRowsNumber/this.computedPagination.rowsPerPage))},isLastPage(){return 0===this.lastRowIndex||this.computedPagination.page>=this.pagesNumber},computedRowsPerPageOptions(){return(this.rowsPerPageOptions.includes(this.innerPagination.rowsPerPage)?this.rowsPerPageOptions:[this.innerPagination.rowsPerPage].concat(this.rowsPerPageOptions)).map(t=>({label:0===t?this.$q.lang.table.allRows:""+t,value:t}))}},watch:{pagesNumber(t,e){if(t===e)return;const i=this.computedPagination.page;t&&!i?this.setPagination({page:1}):t<i&&this.setPagination({page:t})}},methods:{__sendServerRequest(t){this.requestServerInteraction({pagination:t,filter:this.filter})},setPagination(t,e){const i=fixPagination({...this.computedPagination,...t});samePagination(this.computedPagination,i)?!0===this.isServerSide&&!0===e&&this.__sendServerRequest(i):!0!==this.isServerSide?void 0!==this.pagination&&void 0!==this.qListeners["update:pagination"]?this.$emit("update:pagination",i):this.innerPagination=i:this.__sendServerRequest(i)},firstPage(){this.setPagination({page:1})},prevPage(){const{page:t}=this.computedPagination;t>1&&this.setPagination({page:t-1})},nextPage(){const{page:t,rowsPerPage:e}=this.computedPagination;this.lastRowIndex>0&&t*e<this.computedRowsNumber&&this.setPagination({page:t+1})},lastPage(){this.setPagination({page:this.pagesNumber})}},created(){void 0!==this.qListeners["update:pagination"]&&this.$emit("update:pagination",{...this.computedPagination})}},RowSelection={props:{selection:{type:String,default:"none",validator:t=>["single","multiple","none"].includes(t)},selected:{type:Array,default:()=>[]}},computed:{selectedKeys(){const t={};return this.selected.map(this.getRowKey).forEach(e=>{t[e]=!0}),t},hasSelectionMode(){return"none"!==this.selection},singleSelection(){return"single"===this.selection},multipleSelection(){return"multiple"===this.selection},allRowsSelected(){return this.computedRows.length>0&&this.computedRows.every(t=>!0===this.selectedKeys[this.getRowKey(t)])},someRowsSelected(){return!0!==this.allRowsSelected&&this.computedRows.some(t=>!0===this.selectedKeys[this.getRowKey(t)])},rowsSelectedNumber(){return this.selected.length}},methods:{isRowSelected(t){return!0===this.selectedKeys[t]},clearSelection(){this.$emit("update:selected",[])},__updateSelection(t,e,i,s){this.$emit("selection",{rows:e,added:i,keys:t,evt:s});const o=!0===this.singleSelection?!0===i?e:[]:!0===i?this.selected.concat(e):this.selected.filter(e=>!1===t.includes(this.getRowKey(e)));this.$emit("update:selected",o)}}};function getVal(t){return Array.isArray(t)?t.slice():[]}var RowExpand={props:{expanded:Array},data(){return{innerExpanded:getVal(this.expanded)}},watch:{expanded(t){this.innerExpanded=getVal(t)}},methods:{isRowExpanded(t){return this.innerExpanded.includes(t)},setExpanded(t){void 0!==this.expanded?this.$emit("update:expanded",t):this.innerExpanded=t},__updateExpanded(t,e){const i=this.innerExpanded.slice(),s=i.indexOf(t);!0===e?-1===s&&(i.push(t),this.setExpanded(i)):-1!==s&&(i.splice(s,1),this.setExpanded(i))}}},ColumnSelection={props:{visibleColumns:Array},computed:{colList(){if(void 0!==this.columns)return this.columns;const t=this.data[0];return void 0!==t?Object.keys(t).map(e=>({name:e,label:e.toUpperCase(),field:e,align:isNumber(t[e])?"right":"left",sortable:!0})):[]},computedCols(){const{sortBy:t,descending:e}=this.computedPagination;return(void 0!==this.visibleColumns?this.colList.filter(t=>!0===t.required||!0===this.visibleColumns.includes(t.name)):this.colList).map(i=>{const s=i.align||"right";return{...i,align:s,__iconClass:`q-table__sort-icon q-table__sort-icon--${s}`,__thClass:`text-${s}`+(void 0!==i.headerClasses?" "+i.headerClasses:"")+(!0===i.sortable?" sortable":"")+(i.name===t?` sorted ${!0===e?"sort-desc":""}`:""),__tdClass:`text-${s}${void 0!==i.classes?" "+i.classes:""}`}})},computedColsMap(){const t={};return this.computedCols.forEach(e=>{t[e.name]=e}),t}}};const commonVirtPropsObj={};commonVirtPropsList.forEach(t=>{commonVirtPropsObj[t]={}});var QTable=Vue.extend({name:"QTable",mixins:[DarkMixin,ListenersMixin,FullscreenMixin,Top,TableHeader,TableBody,Bottom,TableGrid,Sort,Filter,Pagination,RowSelection,RowExpand,ColumnSelection],props:{data:{type:Array,default:()=>[]},rowKey:{type:[String,Function],default:"id"},columns:Array,loading:Boolean,binaryStateSort:Boolean,iconFirstPage:String,iconPrevPage:String,iconNextPage:String,iconLastPage:String,title:String,hideHeader:Boolean,grid:Boolean,gridHeader:Boolean,dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,separator:{type:String,default:"horizontal",validator:t=>["horizontal","vertical","cell","none"].includes(t)},wrapCells:Boolean,virtualScroll:Boolean,...commonVirtPropsObj,noDataLabel:String,noResultsLabel:String,loadingLabel:String,selectedRowsLabel:Function,rowsPerPageLabel:String,paginationLabel:Function,color:{type:String,default:"grey-8"},tableStyle:[String,Array,Object],tableClass:[String,Array,Object],tableHeaderStyle:[String,Array,Object],tableHeaderClass:[String,Array,Object],cardContainerClass:[String,Array,Object],cardContainerStyle:[String,Array,Object],cardStyle:[String,Array,Object],cardClass:[String,Array,Object]},data(){return{innerPagination:Object.assign({sortBy:null,descending:!1,page:1,rowsPerPage:this.rowsPerPageOptions.length>0?this.rowsPerPageOptions[0]:5},this.pagination)}},watch:{needsReset(){!0===this.hasVirtScroll&&void 0!==this.$refs.virtScroll&&this.$refs.virtScroll.reset()}},computed:{getRowKey(){return"function"==typeof this.rowKey?this.rowKey:t=>t[this.rowKey]},hasVirtScroll(){return!0!==this.grid&&!0===this.virtualScroll},needsReset(){return["tableStyle","tableClass","tableHeaderStyle","tableHeaderClass","containerClass"].map(t=>this[t]).join(";")},filteredSortedRows(){let t=this.data;if(!0===this.isServerSide||0===t.length)return t;const{sortBy:e,descending:i}=this.computedPagination;return this.filter&&(t=this.filterMethod(t,this.filter,this.computedCols,this.getCellValue)),void 0!==this.columnToSort&&(t=this.sortMethod(this.data===t?t.slice():t,e,i)),t},filteredSortedRowsNumber(){return this.filteredSortedRows.length},computedRows(){let t=this.filteredSortedRows;if(!0===this.isServerSide)return t;const{rowsPerPage:e}=this.computedPagination;return 0!==e&&(0===this.firstRowIndex&&this.data!==t?t.length>this.lastRowIndex&&(t.length=this.lastRowIndex):t=t.slice(this.firstRowIndex,this.lastRowIndex)),t},computedRowsNumber(){return!0===this.isServerSide?this.computedPagination.rowsNumber||0:this.filteredSortedRowsNumber},nothingToDisplay(){return 0===this.computedRows.length},isServerSide(){return void 0!==this.computedPagination.rowsNumber},cardDefaultClass(){return" q-table__card"+(!0===this.isDark?" q-table__card--dark q-dark":"")+(!0===this.square?" q-table--square":"")+(!0===this.flat?" q-table--flat":"")+(!0===this.bordered?" q-table--bordered":"")},containerClass(){return`q-table__container q-table--${this.separator}-separator column no-wrap`+(!0===this.loading?" q-table--loading":"")+(!0===this.grid?" q-table--grid":this.cardDefaultClass)+(!0===this.isDark?" q-table--dark":"")+(!0===this.dense?" q-table--dense":"")+(!1===this.wrapCells?" q-table--no-wrap":"")+(!0===this.inFullscreen?" fullscreen scroll":"")},virtProps(){const t={};return commonVirtPropsList.forEach(e=>{t[e]=this[e]}),void 0===t.virtualScrollItemSize&&(t.virtualScrollItemSize=!0===this.dense?28:48),t}},render(t){const e=[this.getTop(t)],i={staticClass:this.containerClass};return!0===this.grid?e.push(this.getGridHeader(t)):Object.assign(i,{class:this.cardClass,style:this.cardStyle}),e.push(this.getBody(t),this.getBottom(t)),!0===this.loading&&void 0!==this.$scopedSlots.loading&&e.push(this.$scopedSlots.loading()),t("div",i,e)},methods:{requestServerInteraction(t={}){this.$nextTick(()=>{this.$emit("request",{pagination:t.pagination||this.computedPagination,filter:t.filter||this.filter,getCellValue:this.getCellValue})})},resetVirtualScroll(){!0===this.hasVirtScroll&&this.$refs.virtScroll.reset()},getBody(t){if(!0===this.grid)return this.getGridBody(t);const e=!0!==this.hideHeader?this.getTableHeader(t):null;return!0===this.hasVirtScroll?t(QVirtualScroll,{ref:"virtScroll",props:{...this.virtProps,items:this.computedRows,type:"__qtable"},on:cache(this,"vs",{"virtual-scroll":this.__onVScroll}),class:this.tableClass,style:this.tableStyle,scopedSlots:{before:null===e?void 0:()=>e,default:this.getTableRowVirtual(t)}}):getTableMiddle(t,{staticClass:"scroll",class:this.tableClass,style:this.tableStyle},[e,this.getTableBody(t)])},scrollTo(t){if(void 0!==this.$refs.virtScroll)return void this.$refs.virtScroll.scrollTo(t);t=parseInt(t,10);const e=this.$el.querySelector(`tbody tr:nth-of-type(${t+1})`);if(null!==e){const i=this.$el.querySelector(".q-table__middle.scroll"),{offsetTop:s}=e,o=s<i.scrollTop?"decrease":"increase";i.scrollTop=s,this.$emit("virtual-scroll",{index:t,from:0,to:this.pagination.rowsPerPage-1,direction:o})}},__onVScroll(t){this.$emit("virtual-scroll",t)},__getProgress(t){return[t(QLinearProgress,{staticClass:"q-table__linear-progress",props:{color:this.color,dark:this.isDark,indeterminate:!0,trackColor:"transparent"}})]}}}),QTr=Vue.extend({name:"QTr",mixins:[ListenersMixin],props:{props:Object,noHover:Boolean},computed:{classes(){return"q-tr"+(void 0===this.props||!0===this.props.header?"":" "+this.props.__trClass)+(!0===this.noHover?" q-tr--no-hover":"")}},render(t){return t("tr",{on:{...this.qListeners},class:this.classes},slot(this,"default"))}}),QTd=Vue.extend({name:"QTd",mixins:[ListenersMixin],props:{props:Object,autoWidth:Boolean,noHover:Boolean},computed:{classes(){return"q-td"+(!0===this.autoWidth?" q-table--col-auto-width":"")+(!0===this.noHover?" q-td--no-hover":"")}},render(t){const e=this.qListeners;if(void 0===this.props)return t("td",{on:e,class:this.classes},slot(this,"default"));const i=this.$vnode.key,s=void 0!==this.props.colsMap&&i?this.props.colsMap[i]:this.props.col;return void 0!==s?t("td",{on:e,style:s.style,class:this.classes+" "+s.__tdClass},slot(this,"default")):void 0}});const trailingSlashRE=/\/?$/;function queryIncludes(t,e){for(const i in e)if(!(i in t))return!1;return!0}function isSameRoute(t,e){return!!e&&(t.path&&e.path?t.path.replace(trailingSlashRE,"")===e.path.replace(trailingSlashRE,"")&&t.hash===e.hash&&isDeepEqual(t.query,e.query):!(!t.name||!e.name)&&(t.name===e.name&&t.hash===e.hash&&isDeepEqual(t.query,e.query)&&isDeepEqual(t.params,e.params)))}function isIncludedRoute(t,e){return 0===t.path.replace(trailingSlashRE,"/").indexOf(e.path.replace(trailingSlashRE,"/"))&&(!e.hash||t.hash===e.hash)&&queryIncludes(t.query,e.query)}var QRouteTab=Vue.extend({name:"QRouteTab",mixins:[QTab,RouterLinkMixin],props:{to:{required:!0}},inject:{__activateRoute:{},__recalculateScroll:{}},watch:{$route(){this.__checkActivation()}},methods:{__activate(t,e){!0!==this.disable&&this.__checkActivation(!0),!0===e?this.$el.focus(t):void 0!==this.$refs.blurTarget&&this.$refs.blurTarget.focus(t)},__checkActivation(t=!1){const e=this.$route,{href:i,location:s,route:o}=this.$router.resolve(this.to,e,this.append),n=void 0!==o.redirectedFrom,r=!0===this.exact?isSameRoute:isIncludedRoute,a={name:this.name,selected:t,exact:this.exact,priorityMatched:o.matched.length,priorityHref:i.length};r(e,o)&&this.__activateRoute({...a,redirected:n}),!0===n&&r(e,{path:o.redirectedFrom,...s})&&this.__activateRoute(a),this.isActive&&this.__activateRoute()}},mounted(){this.__recalculateScroll(),void 0!==this.$router&&this.__checkActivation()},beforeDestroy(){this.__recalculateScroll(),this.__activateRoute({remove:!0,name:this.name})},render(t){return this.__renderTab(t,"router-link",this.routerLinkProps)}}),QTime=Vue.extend({name:"QTime",mixins:[DateTimeMixin],directives:{TouchPan:TouchPan},props:{mask:{default:null},format24h:{type:Boolean,default:null},defaultDate:{type:String,validator:t=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(t)},options:Function,hourOptions:Array,minuteOptions:Array,secondOptions:Array,withSeconds:Boolean,nowBtn:Boolean},data(){const t=__splitDate(this.value,this.__getComputedMask(),this.__getComputedLocale(),this.calendar,this.__getDefaultDateModel());let e="Hour";return null!==t.hour&&(null===t.minute?e="Minute":!0===this.withSeconds&&null===t.second&&(e="Second")),{view:e,isAM:null===t.hour||t.hour<12,innerModel:t}},watch:{value(t){const e=__splitDate(t,this.computedMask,this.computedLocale,this.calendar,this.defaultDateModel);e.dateHash===this.innerModel.dateHash&&e.timeHash===this.innerModel.timeHash||(this.innerModel=e,null===e.hour?this.view="Hour":this.isAM=e.hour<12)}},computed:{classes(){return`q-time q-time--${!0===this.landscape?"landscape":"portrait"}`+(!0===this.isDark?" q-time--dark q-dark":"")+(!0===this.disable?" disabled":!0===this.readonly?" q-time--readonly":"")+(!0===this.bordered?" q-time--bordered":"")+(!0===this.square?" q-time--square no-border-radius":"")+(!0===this.flat?" q-time--flat no-shadow":"")},computedMask(){return this.__getComputedMask()},stringModel(){const t=this.innerModel;return{hour:null===t.hour?"--":!0===this.computedFormat24h?pad(t.hour):String(!0===this.isAM?0===t.hour?12:t.hour:t.hour>12?t.hour-12:t.hour),minute:null===t.minute?"--":pad(t.minute),second:null===t.second?"--":pad(t.second)}},defaultDateModel(){return this.__getDefaultDateModel()},computedFormat24h(){return null!==this.format24h?this.format24h:this.$q.lang.date.format24h},pointerStyle(){const t="Hour"===this.view,e=!0===t?12:60,i=this.innerModel[this.view.toLowerCase()];let s=`rotate(${Math.round(i*(360/e))-180}deg) translateX(-50%)`;return!0===t&&!0===this.computedFormat24h&&this.innerModel.hour>=12&&(s+=" scale(.7)"),{transform:s}},minLink(){return null!==this.innerModel.hour},secLink(){return!0===this.minLink&&null!==this.innerModel.minute},hourInSelection(){return void 0!==this.hourOptions?t=>this.hourOptions.includes(t):void 0!==this.options?t=>this.options(t,null,null):void 0},minuteInSelection(){return void 0!==this.minuteOptions?t=>this.minuteOptions.includes(t):void 0!==this.options?t=>this.options(this.innerModel.hour,t,null):void 0},secondInSelection(){return void 0!==this.secondOptions?t=>this.secondOptions.includes(t):void 0!==this.options?t=>this.options(this.innerModel.hour,this.innerModel.minute,t):void 0},positions(){let t,e,i,s=0,o=1;"Hour"===this.view?(i=this.hourInSelection,!0===this.computedFormat24h?(t=0,e=23):(t=0,e=11,!1===this.isAM&&(s=12))):(t=0,e=55,o=5,i="Minute"===this.view?this.minuteInSelection:this.secondInSelection);const n=[];for(let r=t,a=t;r<=e;r+=o,a++){const t=r+s,e=void 0!==i&&!1===i(t),o="Hour"===this.view&&0===r?!0===this.format24h?"00":"12":r;n.push({val:t,index:a,disable:e,label:o})}return n}},methods:{setNow(){this.__updateValue({...this.__getCurrentDate(),...this.__getCurrentTime()}),this.view="Hour"},__getDefaultDateModel(){if("string"!=typeof this.defaultDate){const t=this.__getCurrentDate();return t.dateHash=t.year+"/"+pad(t.month)+"/"+pad(t.day),t}return __splitDate(this.defaultDate,"YYYY/MM/DD",void 0,this.calendar)},__click(t){!0!==this._isBeingDestroyed&&!0!==this._isDestroyed&&(!0!==this.$q.platform.is.desktop&&this.__updateClock(t,this.__getClockRect()),this.__goToNextView())},__activate(t){!0!==this._isBeingDestroyed&&!0!==this._isDestroyed&&this.__updateClock(t,this.__getClockRect())},__getClockRect(){const t=this.$refs.clock,{top:e,left:i,width:s}=t.getBoundingClientRect(),o=s/2;return{top:e+o,left:i+o,dist:.7*o}},__goToNextView(){"Hour"===this.view?this.view="Minute":this.withSeconds&&"Minute"===this.view&&(this.view="Second")},__drag(t){if(!0!==this._isBeingDestroyed&&!0!==this._isDestroyed){if(!0===t.isFirst)return this.draggingClockRect=this.__getClockRect(),void(this.dragCache=this.__updateClock(t.evt,this.draggingClockRect));this.dragCache=this.__updateClock(t.evt,this.draggingClockRect,this.dragCache),!0===t.isFinal&&(this.draggingClockRect=!1,this.dragCache=null,this.__goToNextView())}},__updateClock(t,e,i){const s=position(t),o=Math.abs(s.top-e.top),n=Math.sqrt(Math.pow(Math.abs(s.top-e.top),2)+Math.pow(Math.abs(s.left-e.left),2));let r,a=Math.asin(o/n)*(180/Math.PI);if(a=s.top<e.top?e.left<s.left?90-a:270+a:e.left<s.left?a+90:270-a,"Hour"===this.view?(r=Math.round(a/30),!0===this.computedFormat24h?(n<e.dist?r<12&&(r+=12):12===r&&(r=0),this.isAM=r<12):!0===this.isAM&&12===r?r=0:!1===this.isAM&&12!==r&&(r+=12)):60===(r=Math.round(a/6))&&(r=0),i===r)return r;const l=this[`${this.view.toLowerCase()}InSelection`];return void 0===l||!0===l(r)?(this[`__set${this.view}`](r),r):void 0},__onKeyupHour(t){if(13===t.keyCode)this.view="Hour";else{const e=!0===this.computedFormat24h?24:12,i=!0!==this.computedFormat24h&&!1===this.isAM?12:0;37===t.keyCode?this.__setHour(i+(24+this.innerModel.hour-1)%e):39===t.keyCode&&this.__setHour(i+(24+this.innerModel.hour+1)%e)}},__onKeyupMinute(t){13===t.keyCode?this.view="Minute":37===t.keyCode?this.__setMinute((60+this.innerModel.minute-1)%60):39===t.keyCode&&this.__setMinute((60+this.innerModel.minute+1)%60)},__onKeyupSecond(t){13===t.keyCode?this.view="Second":37===t.keyCode?this.__setSecond((60+this.innerModel.second-1)%60):39===t.keyCode&&this.__setSecond((60+this.innerModel.second+1)%60)},__getHeader(t){const e=[t("div",{staticClass:"q-time__link",class:"Hour"===this.view?"q-time__link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"vH",{click:()=>{this.view="Hour"},keyup:this.__onKeyupHour})},[this.stringModel.hour]),t("div",[":"]),t("div",!0===this.minLink?{staticClass:"q-time__link",class:"Minute"===this.view?"q-time__link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"vM",{click:()=>{this.view="Minute"},keyup:this.__onKeyupMinute})}:{staticClass:"q-time__link"},[this.stringModel.minute])];return!0===this.withSeconds&&e.push(t("div",[":"]),t("div",!0===this.secLink?{staticClass:"q-time__link",class:"Second"===this.view?"q-time__link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"vS",{click:()=>{this.view="Second"},keyup:this.__onKeyupSecond})}:{staticClass:"q-time__link"},[this.stringModel.second])),t("div",{staticClass:"q-time__header flex flex-center no-wrap",class:this.headerClass},[t("div",{staticClass:"q-time__header-label row items-center no-wrap",attrs:{dir:"ltr"}},e),!1===this.computedFormat24h?t("div",{staticClass:"q-time__header-ampm column items-between no-wrap"},[t("div",{staticClass:"q-time__link",class:!0===this.isAM?"q-time__link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"AM",{click:this.__setAm,keyup:t=>{13===t.keyCode&&this.__setAm()}})},["AM"]),t("div",{staticClass:"q-time__link",class:!0!==this.isAM?"q-time__link--active":"cursor-pointer",attrs:{tabindex:this.computedTabindex},on:cache(this,"PM",{click:this.__setPm,keyup:t=>{13===t.keyCode&&this.__setPm()}})},["PM"])]):null])},__getClock(t){const e=this.view.toLowerCase(),i=this.innerModel[e];return t("div",{staticClass:"q-time__content col relative-position"},[t("transition",{props:{name:"q-transition--scale"}},[t("div",{key:"clock"+this.view,staticClass:"q-time__container-parent absolute-full"},[t("div",{ref:"clock",staticClass:"q-time__container-child fit overflow-hidden"},[t("div",{staticClass:"q-time__clock cursor-pointer non-selectable",on:cache(this,"click",{click:this.__click,mousedown:this.__activate}),directives:cache(this,"touch",[{name:"touch-pan",value:this.__drag,modifiers:{stop:!0,prevent:!0,mouse:!0}}])},[t("div",{staticClass:"q-time__clock-circle fit"},[t("div",{staticClass:"q-time__clock-pointer",style:this.pointerStyle,class:null===this.innerModel[e]?"hidden":void 0!==this.color?`text-${this.color}`:""}),this.positions.map(e=>t("div",{staticClass:`q-time__clock-position row flex-center q-time__clock-pos-${e.index}`,class:e.val===i?this.headerClass.concat(" q-time__clock-position--active"):!0===e.disable?"q-time__clock-position--disable":null},[t("span",[e.label])]))])])])])]),!0===this.nowBtn?t(QBtn,{staticClass:"q-time__now-button absolute",props:{icon:this.$q.iconSet.datetime.now,unelevated:!0,size:"sm",round:!0,color:this.color,textColor:this.textColor,tabindex:this.computedTabindex},on:cache(this,"now",{click:this.setNow})}):null])},__setHour(t){this.innerModel.hour!==t&&(this.innerModel.hour=t,this.innerModel.minute=null,this.innerModel.second=null)},__setMinute(t){this.innerModel.minute!==t&&(this.innerModel.minute=t,this.innerModel.second=null,!0!==this.withSeconds&&this.__updateValue({minute:t}))},__setSecond(t){this.innerModel.second!==t&&this.__updateValue({second:t})},__setAm(){this.isAM||(this.isAM=!0,null!==this.innerModel.hour&&(this.innerModel.hour-=12,this.__verifyAndUpdate()))},__setPm(){this.isAM&&(this.isAM=!1,null!==this.innerModel.hour&&(this.innerModel.hour+=12,this.__verifyAndUpdate()))},__verifyAndUpdate(){return void 0!==this.hourInSelection&&!0!==this.hourInSelection(this.innerModel.hour)?(this.innerModel=__splitDate(),this.isAM=!0,void(this.view="Hour")):void 0!==this.minuteInSelection&&!0!==this.minuteInSelection(this.innerModel.minute)?(this.innerModel.minute=null,this.innerModel.second=null,void(this.view="Minute")):!0===this.withSeconds&&void 0!==this.secondInSelection&&!0!==this.secondInSelection(this.innerModel.second)?(this.innerModel.second=null,void(this.view="Second")):void(null===this.innerModel.hour||null===this.innerModel.minute||!0===this.withSeconds&&null===this.innerModel.second||this.__updateValue({}))},__getComputedMask(){return"persian"!==this.calendar&&null!==this.mask?this.mask:`HH:mm${!0===this.withSeconds?":ss":""}`},__updateValue(t){const e={...this.innerModel,...t},i="persian"===this.calendar?pad(e.hour)+":"+pad(e.minute)+(!0===this.withSeconds?":"+pad(e.second):""):formatDate(new Date(e.year,null===e.month?null:e.month-1,e.day,e.hour,e.minute,e.second,e.millisecond),this.computedMask,this.computedLocale,e.year,e.timezoneOffset);e.changed=i!==this.value,this.$emit("input",i,e)}},render(t){const e=[this.__getClock(t)],i=slot(this,"default");return void 0!==i&&e.push(t("div",{staticClass:"q-time__actions"},i)),void 0!==this.name&&!0!==this.disable&&this.__injectFormInput(e,"push"),t("div",{class:this.classes,on:{...this.qListeners},attrs:{tabindex:-1}},[this.__getHeader(t),t("div",{staticClass:"q-time__main col overflow-auto"},e)])}}),QTimeline=Vue.extend({name:"QTimeline",mixins:[DarkMixin,ListenersMixin],provide(){return{__timeline:this}},props:{color:{type:String,default:"primary"},side:{type:String,default:"right",validator:t=>["left","right"].includes(t)},layout:{type:String,default:"dense",validator:t=>["dense","comfortable","loose"].includes(t)}},computed:{classes(){return`q-timeline--${this.layout} q-timeline--${this.layout}--${this.side}`+(!0===this.isDark?" q-timeline--dark":"")}},render(t){return t("ul",{staticClass:"q-timeline",class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QTimelineEntry=Vue.extend({name:"QTimelineEntry",inject:{__timeline:{default(){console.error("QTimelineEntry needs to be child of QTimeline")}}},mixins:[ListenersMixin],props:{heading:Boolean,tag:{type:String,default:"h3"},side:{type:String,default:"right",validator:t=>["left","right"].includes(t)},icon:String,avatar:String,color:String,title:String,subtitle:String,body:String},computed:{colorClass(){return`text-${this.color||this.__timeline.color}`},classes(){return`q-timeline__entry--${this.side}`+(void 0!==this.icon||void 0!==this.avatar?" q-timeline__entry--icon":"")},reverse(){return"comfortable"===this.__timeline.layout&&"left"===this.__timeline.side}},render(t){const e=uniqueSlot(this,"default",[]);if(void 0!==this.body&&e.unshift(this.body),!0===this.heading){const i=[t("div"),t("div"),t(this.tag,{staticClass:"q-timeline__heading-title"},e)];return t("div",{staticClass:"q-timeline__heading",on:{...this.qListeners}},!0===this.reverse?i.reverse():i)}let i;void 0!==this.icon?i=[t(QIcon,{staticClass:"row items-center justify-center",props:{name:this.icon}})]:void 0!==this.avatar&&(i=[t("img",{staticClass:"q-timeline__dot-img",domProps:{src:this.avatar}})]);const s=[t("div",{staticClass:"q-timeline__subtitle"},[t("span",slot(this,"subtitle",[this.subtitle]))]),t("div",{staticClass:"q-timeline__dot",class:this.colorClass},i),t("div",{staticClass:"q-timeline__content"},[t("h6",{staticClass:"q-timeline__title"},slot(this,"title",[this.title]))].concat(e))];return t("li",{staticClass:"q-timeline__entry",class:this.classes,on:{...this.qListeners}},!0===this.reverse?s.reverse():s)}}),QToolbar=Vue.extend({name:"QToolbar",mixins:[ListenersMixin],props:{inset:Boolean},render(t){return t("div",{staticClass:"q-toolbar row no-wrap items-center",class:this.inset?"q-toolbar--inset":null,on:{...this.qListeners}},slot(this,"default"))}}),QToolbarTitle=Vue.extend({name:"QToolbarTitle",mixins:[ListenersMixin],props:{shrink:Boolean},computed:{classes(){return"q-toolbar__title ellipsis"+(!0===this.shrink?" col-shrink":"")}},render(t){return t("div",{class:this.classes,on:{...this.qListeners}},slot(this,"default"))}}),QTree=Vue.extend({name:"QTree",mixins:[DarkMixin],props:{nodes:{type:Array,required:!0},nodeKey:{type:String,required:!0},labelKey:{type:String,default:"label"},childrenKey:{type:String,default:"children"},color:String,controlColor:String,textColor:String,selectedColor:String,icon:String,tickStrategy:{type:String,default:"none",validator:t=>["none","strict","leaf","leaf-filtered"].includes(t)},ticked:Array,expanded:Array,selected:{},defaultExpandAll:Boolean,accordion:Boolean,filter:String,filterMethod:{type:Function,default(t,e){const i=e.toLowerCase();return t[this.labelKey]&&t[this.labelKey].toLowerCase().indexOf(i)>-1}},duration:Number,noConnectors:Boolean,noNodesLabel:String,noResultsLabel:String},computed:{classes(){return"q-tree"+(!0===this.noConnectors?" q-tree--no-connectors":"")+(!0===this.isDark?" q-tree--dark":"")+(void 0!==this.color?` text-${this.color}`:"")},hasSelection(){return void 0!==this.selected},computedIcon(){return this.icon||this.$q.iconSet.tree.icon},computedControlColor(){return this.controlColor||this.color},textColorClass(){if(void 0!==this.textColor)return`text-${this.textColor}`},selectedColorClass(){const t=this.selectedColor||this.color;if(t)return`text-${t}`},meta(){const t={},e=(i,s)=>{const o=i.tickStrategy||(s?s.tickStrategy:this.tickStrategy),n=i[this.nodeKey],r=i[this.childrenKey]&&i[this.childrenKey].length>0,a=!0!==r,l=!0!==i.disabled&&!0===this.hasSelection&&!1!==i.selectable,h=!0!==i.disabled&&!1!==i.expandable,d="none"!==o,c="strict"===o,u="leaf-filtered"===o,p="leaf"===o||"leaf-filtered"===o;let m=!0!==i.disabled&&!1!==i.tickable;!0===p&&!0===m&&s&&!0!==s.tickable&&(m=!1);let g=i.lazy;g&&this.lazy[n]&&(g=this.lazy[n]);const f={key:n,parent:s,isParent:r,isLeaf:a,lazy:g,disabled:i.disabled,link:!0!==i.disabled&&(!0===l||!0===h&&(!0===r||!0===g)),children:[],matchesFilter:!this.filter||this.filterMethod(i,this.filter),selected:n===this.selected&&!0===l,selectable:l,expanded:!0===r&&this.innerExpanded.includes(n),expandable:h,noTick:!0===i.noTick||!0!==c&&g&&"loaded"!==g,tickable:m,tickStrategy:o,hasTicking:d,strictTicking:c,leafFilteredTicking:u,leafTicking:p,ticked:!0===c?this.innerTicked.includes(n):!0===a&&this.innerTicked.includes(n)};if(t[n]=f,!0===r&&(f.children=i[this.childrenKey].map(t=>e(t,f)),this.filter&&(!0!==f.matchesFilter?f.matchesFilter=f.children.some(t=>t.matchesFilter):!0!==f.noTick&&!0!==f.disabled&&!0===f.tickable&&!0===u&&!0===f.children.every(t=>!0!==t.matchesFilter||!0===t.noTick||!0!==t.tickable)&&(f.tickable=!1)),!0===f.matchesFilter&&(!0!==f.noTick&&!0!==c&&!0===f.children.every(t=>t.noTick)&&(f.noTick=!0),p))){if(f.ticked=!1,f.indeterminate=f.children.some(t=>!0===t.indeterminate),f.tickable=!0===f.tickable&&f.children.some(t=>t.tickable),!0!==f.indeterminate){const t=f.children.reduce((t,e)=>!0===e.ticked?t+1:t,0);t===f.children.length?f.ticked=!0:t>0&&(f.indeterminate=!0)}!0===f.indeterminate&&(f.indeterminateNextState=f.children.every(t=>!0!==t.tickable||!0!==t.ticked))}return f};return this.nodes.forEach(t=>e(t,null)),t}},data(){return{lazy:{},innerTicked:this.ticked||[],innerExpanded:this.expanded||[]}},watch:{ticked(t){this.innerTicked=t},expanded(t){this.innerExpanded=t}},methods:{getNodeByKey(t){const e=[].reduce,i=(s,o)=>s||!o?s:!0===Array.isArray(o)?e.call(Object(o),i,s):o[this.nodeKey]===t?o:o[this.childrenKey]?i(null,o[this.childrenKey]):void 0;return i(null,this.nodes)},getTickedNodes(){return this.innerTicked.map(t=>this.getNodeByKey(t))},getExpandedNodes(){return this.innerExpanded.map(t=>this.getNodeByKey(t))},isExpanded(t){return!(!t||!this.meta[t])&&this.meta[t].expanded},collapseAll(){void 0!==this.expanded?this.$emit("update:expanded",[]):this.innerExpanded=[]},expandAll(){const t=this.innerExpanded,e=i=>{i[this.childrenKey]&&i[this.childrenKey].length>0&&!1!==i.expandable&&!0!==i.disabled&&(t.push(i[this.nodeKey]),i[this.childrenKey].forEach(e))};this.nodes.forEach(e),void 0!==this.expanded?this.$emit("update:expanded",t):this.innerExpanded=t},setExpanded(t,e,i=this.getNodeByKey(t),s=this.meta[t]){if(s.lazy&&"loaded"!==s.lazy){if("loading"===s.lazy)return;this.$set(this.lazy,t,"loading"),this.$emit("lazy-load",{node:i,key:t,done:e=>{this.lazy[t]="loaded",e&&this.$set(i,this.childrenKey,e),this.$nextTick(()=>{const e=this.meta[t];e&&!0===e.isParent&&this.__setExpanded(t,!0)})},fail:()=>{this.$delete(this.lazy,t)}})}else!0===s.isParent&&!0===s.expandable&&this.__setExpanded(t,e)},__setExpanded(t,e){let i=this.innerExpanded;const s=void 0!==this.expanded;if(!0===s&&(i=i.slice()),e){if(this.accordion&&this.meta[t]){const e=[];this.meta[t].parent?this.meta[t].parent.children.forEach(i=>{i.key!==t&&!0===i.expandable&&e.push(i.key)}):this.nodes.forEach(i=>{const s=i[this.nodeKey];s!==t&&e.push(s)}),e.length>0&&(i=i.filter(t=>!1===e.includes(t)))}i=i.concat([t]).filter((t,e,i)=>i.indexOf(t)===e)}else i=i.filter(e=>e!==t);!0===s?this.$emit("update:expanded",i):this.innerExpanded=i},isTicked(t){return!(!t||!this.meta[t])&&this.meta[t].ticked},setTicked(t,e){let i=this.innerTicked;const s=void 0!==this.ticked;!0===s&&(i=i.slice()),i=e?i.concat(t).filter((t,e,i)=>i.indexOf(t)===e):i.filter(e=>!1===t.includes(e)),!0===s&&this.$emit("update:ticked",i)},__getSlotScope(t,e,i){const s={tree:this,node:t,key:i,color:this.color,dark:this.isDark};return Object.defineProperty(s,"expanded",{get:()=>e.expanded,set:t=>{t!==e.expanded&&this.setExpanded(i,t)},configurable:!0,enumerable:!0}),Object.defineProperty(s,"ticked",{get:()=>e.ticked,set:t=>{t!==e.ticked&&this.setTicked([i],t)},configurable:!0,enumerable:!0}),s},__getChildren(t,e){return(this.filter?e.filter(t=>this.meta[t[this.nodeKey]].matchesFilter):e).map(e=>this.__getNode(t,e))},__getNodeMedia(t,e){if(void 0!==e.icon)return t(QIcon,{staticClass:"q-tree__icon q-mr-sm",props:{name:e.icon,color:e.iconColor}});const i=e.img||e.avatar;return i?t("img",{staticClass:`q-tree__${e.img?"img":"avatar"} q-mr-sm`,attrs:{src:i}}):void 0},__getNode(t,e){const i=e[this.nodeKey],s=this.meta[i],o=e.header&&this.$scopedSlots[`header-${e.header}`]||this.$scopedSlots["default-header"],n=!0===s.isParent?this.__getChildren(t,e[this.childrenKey]):[],r=n.length>0||s.lazy&&"loaded"!==s.lazy;let a=e.body&&this.$scopedSlots[`body-${e.body}`]||this.$scopedSlots["default-body"];const l=void 0!==o||void 0!==a?this.__getSlotScope(e,s,i):null;return void 0!==a&&(a=t("div",{staticClass:"q-tree__node-body relative-position"},[t("div",{class:this.textColorClass},[a(l)])])),t("div",{key:i,staticClass:"q-tree__node relative-position",class:{"q-tree__node--parent":r,"q-tree__node--child":!r}},[t("div",{staticClass:"q-tree__node-header relative-position row no-wrap items-center",class:{"q-tree__node--link q-hoverable q-focusable":s.link,"q-tree__node--selected":s.selected,"q-tree__node--disabled":s.disabled},attrs:{tabindex:s.link?0:-1},on:{click:t=>{this.__onClick(e,s,t)},keypress:t=>{!0!==shouldIgnoreKey(t)&&(13===t.keyCode?this.__onClick(e,s,t,!0):32===t.keyCode&&this.__onExpandClick(e,s,t,!0))}}},[t("div",{staticClass:"q-focus-helper",attrs:{tabindex:-1},ref:`blurTarget_${s.key}`}),"loading"===s.lazy?t(QSpinner,{staticClass:"q-tree__spinner q-mr-xs",props:{color:this.computedControlColor}}):!0===r?t(QIcon,{staticClass:"q-tree__arrow q-mr-xs",class:{"q-tree__arrow--rotate":s.expanded},props:{name:this.computedIcon},on:{click:t=>{this.__onExpandClick(e,s,t)}}}):null,!0===s.hasTicking&&!0!==s.noTick?t(QCheckbox,{staticClass:"q-mr-xs",props:{value:!0===s.indeterminate?null:s.ticked,color:this.computedControlColor,dark:this.isDark,dense:!0,keepColor:!0,disable:!0!==s.tickable},on:{keydown:stopAndPrevent,input:t=>{this.__onTickedClick(s,t)}}}):null,t("div",{staticClass:"q-tree__node-header-content col row no-wrap items-center",class:s.selected?this.selectedColorClass:this.textColorClass},[o?o(l):[this.__getNodeMedia(t,e),t("div",e[this.labelKey])]])]),!0===r?t(QSlideTransition,{props:{duration:this.duration},on:cache(this,"slide",{show:()=>{this.$emit("after-show")},hide:()=>{this.$emit("after-hide")}})},[t("div",{staticClass:"q-tree__node-collapsible",class:this.textColorClass,directives:[{name:"show",value:s.expanded}]},[a,t("div",{staticClass:"q-tree__children",class:{"q-tree__node--disabled":s.disabled}},n)])]):a])},__blur(t){const e=this.$refs[`blurTarget_${t}`];void 0!==e&&e.focus()},__onClick(t,e,i,s){!0!==s&&this.__blur(e.key),this.hasSelection?e.selectable&&this.$emit("update:selected",e.key!==this.selected?e.key:null):this.__onExpandClick(t,e,i,s),"function"==typeof t.handler&&t.handler(t)},__onExpandClick(t,e,i,s){void 0!==i&&stopAndPrevent(i),!0!==s&&this.__blur(e.key),this.setExpanded(e.key,!e.expanded,t,e)},__onTickedClick(t,e){if(!0===t.indeterminate&&(e=t.indeterminateNextState),t.strictTicking)this.setTicked([t.key],e);else if(t.leafTicking){const i=[],s=t=>{t.isParent?(!0!==e&&!0!==t.noTick&&!0===t.tickable&&i.push(t.key),!0===t.leafTicking&&t.children.forEach(s)):!0===t.noTick||!0!==t.tickable||!0===t.leafFilteredTicking&&!0!==t.matchesFilter||i.push(t.key)};s(t),this.setTicked(i,e)}}},render(t){const e=this.__getChildren(t,this.nodes);return t("div",{class:this.classes},0===e.length?this.filter?this.noResultsLabel||this.$q.lang.tree.noResults:this.noNodesLabel||this.$q.lang.tree.noNodes:e)},created(){!0===this.defaultExpandAll&&this.expandAll()}}),QUploaderBase=Vue.extend({name:"QUploaderBase",mixins:[DarkMixin,FileMixin],props:{label:String,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,noThumbnails:Boolean,autoUpload:Boolean,hideUploadBtn:Boolean,disable:Boolean,readonly:Boolean},provide(){return{__qUploaderGetInput:this.__getInputControl}},data:()=>({files:[],queuedFiles:[],uploadedFiles:[],dnd:!1,expanded:!1,uploadSize:0,uploadedSize:0}),watch:{isUploading(t,e){!1===e&&!0===t?this.$emit("start"):!0===e&&!1===t&&this.$emit("finish")}},computed:{canUpload(){return!0===this.editable&&!0!==this.isBusy&&!0!==this.isUploading&&this.queuedFiles.length>0},canAddFiles(){return!0===this.editable&&!0!==this.isUploading&&(!0===this.multiple||0===this.queuedFiles.length)&&(void 0===this.maxFiles||this.files.length<this.maxFilesNumber)&&(void 0===this.maxTotalSize||this.uploadSize<this.maxTotalSizeNumber)},uploadProgress(){return 0===this.uploadSize?0:this.uploadedSize/this.uploadSize},uploadProgressLabel(){return this.__getProgressLabel(this.uploadProgress)},uploadedSizeLabel(){return humanStorageSize(this.uploadedSize)},uploadSizeLabel(){return humanStorageSize(this.uploadSize)},colorClass(){const t=[];return void 0!==this.color&&t.push(`bg-${this.color}`),void 0!==this.textColor&&t.push(`text-${this.textColor}`),t.join(" ")},editable(){return!0!==this.disable&&!0!==this.readonly}},methods:{reset(){this.disable||(this.abort(),this.uploadedSize=0,this.uploadSize=0,this.__revokeImgURLs(),this.files=[],this.queuedFiles=[],this.uploadedFiles=[])},removeUploadedFiles(){this.disable||(this.files=this.files.filter(t=>"uploaded"!==t.__status||(void 0!==t._img&&window.URL.revokeObjectURL(t._img.src),!1)),this.uploadedFiles=[])},removeQueuedFiles(){if(!this.disable){const t=[],e=this.files.filter(e=>"idle"!==e.__status&&"failed"!==e.__status||(this.uploadSize-=e.size,t.push(e),void 0!==e._img&&window.URL.revokeObjectURL(e._img.src),!1));t.length>0&&(this.files=e,this.queuedFiles=[],this.$emit("removed",t))}},removeFile(t){this.disable||("uploaded"===t.__status?this.uploadedFiles=this.uploadedFiles.filter(e=>e.name!==t.name):"uploading"===t.__status?t.__abort():this.uploadSize-=t.size,this.files=this.files.filter(e=>e.name!==t.name||(void 0!==e._img&&window.URL.revokeObjectURL(e._img.src),!1)),this.queuedFiles=this.queuedFiles.filter(e=>e.name!==t.name),this.$emit("removed",[t]))},__revokeImgURLs(){this.files.forEach(t=>{void 0!==t._img&&window.URL.revokeObjectURL(t._img.src)})},__getFileInput(){return this.$refs.input||this.$el.getElementsByClassName("q-uploader__input")[0]},__getProgressLabel:t=>(100*t).toFixed(2)+"%",__updateFile(t,e,i){if(t.__status=e,"idle"===e)return t.__uploaded=0,t.__progress=0,t.__sizeLabel=humanStorageSize(t.size),void(t.__progressLabel="0.00%");"failed"!==e?(t.__uploaded="uploaded"===e?t.size:i,t.__progress="uploaded"===e?1:Math.min(.9999,t.__uploaded/t.size),t.__progressLabel=this.__getProgressLabel(t.__progress),this.$forceUpdate()):this.$forceUpdate()},__addFiles(t,e){const i=this.__processFiles(t,e,this.files,!0);if(void 0===i)return;const s=i.filter(t=>-1===this.files.findIndex(e=>t.name===e.name));this.__getFileInput().value="",void 0!==s&&(s.forEach(t=>{if(this.__updateFile(t,"idle"),this.uploadSize+=t.size,!0!==this.noThumbnails&&t.type.toUpperCase().startsWith("IMAGE")){const e=new Image;e.src=window.URL.createObjectURL(t),t.__img=e}}),this.files=this.files.concat(s),this.queuedFiles=this.queuedFiles.concat(s),this.$emit("added",s),!0===this.autoUpload&&this.upload())},__getBtn(t,e,i,s){if(!0===e)return t(QBtn,{props:{type:"a",icon:this.$q.iconSet.uploader[i],flat:!0,dense:!0},on:"add"===i?null:{click:s}},"add"===i?this.__getInputControl(t):null)},__getInputControl(t){return[t("input",{ref:"input",staticClass:"q-uploader__input overflow-hidden absolute-full",attrs:{tabindex:-1,type:"file",title:"",accept:this.accept,capture:this.capture,...!0===this.multiple?{multiple:!0}:{}},on:cache(this,"input",{mousedown:stop,change:this.__addFiles})})]},__getHeader(t){return void 0!==this.$scopedSlots.header?this.$scopedSlots.header(this):[t("div",{staticClass:"q-uploader__header-content flex flex-center no-wrap q-gutter-xs"},[this.__getBtn(t,this.queuedFiles.length>0,"removeQueue",this.removeQueuedFiles),this.__getBtn(t,this.uploadedFiles.length>0,"removeUploaded",this.removeUploadedFiles),!0===this.isUploading?t(QSpinner,{staticClass:"q-uploader__spinner"}):null,t("div",{staticClass:"col column justify-center"},[void 0!==this.label?t("div",{staticClass:"q-uploader__title"},[this.label]):null,t("div",{staticClass:"q-uploader__subtitle"},[this.uploadSizeLabel+" / "+this.uploadProgressLabel])]),this.__getBtn(t,this.canAddFiles,"add",this.pickFiles),this.__getBtn(t,!1===this.hideUploadBtn&&!0===this.canUpload,"upload",this.upload),this.__getBtn(t,this.isUploading,"clear",this.abort)])]},__getList(t){return void 0!==this.$scopedSlots.list?this.$scopedSlots.list(this):this.files.map(e=>t("div",{key:e.name,staticClass:"q-uploader__file relative-position",class:{"q-uploader__file--img":!0!==this.noThumbnails&&void 0!==e.__img,"q-uploader__file--failed":"failed"===e.__status,"q-uploader__file--uploaded":"uploaded"===e.__status},style:!0!==this.noThumbnails&&void 0!==e.__img?{backgroundImage:'url("'+e.__img.src+'")'}:null},[t("div",{staticClass:"q-uploader__file-header row flex-center no-wrap"},["failed"===e.__status?t(QIcon,{staticClass:"q-uploader__file-status",props:{name:this.$q.iconSet.type.negative,color:"negative"}}):null,t("div",{staticClass:"q-uploader__file-header-content col"},[t("div",{staticClass:"q-uploader__title"},[e.name]),t("div",{staticClass:"q-uploader__subtitle row items-center no-wrap"},[e.__sizeLabel+" / "+e.__progressLabel])]),"uploading"===e.__status?t(QCircularProgress,{props:{value:e.__progress,min:0,max:1,indeterminate:0===e.__progress}}):t(QBtn,{props:{round:!0,dense:!0,flat:!0,icon:this.$q.iconSet.uploader["uploaded"===e.__status?"done":"clear"]},on:{click:()=>{this.removeFile(e)}}})])]))}},beforeDestroy(){!0===this.isUploading&&this.abort(),this.files.length>0&&this.__revokeImgURLs()},render(t){const e=[t("div",{staticClass:"q-uploader__header",class:this.colorClass},this.__getHeader(t)),t("div",{staticClass:"q-uploader__list scroll"},this.__getList(t)),this.__getDnd(t,"uploader")];return!0===this.isBusy&&e.push(t("div",{staticClass:"q-uploader__overlay absolute-full flex flex-center"},[t(QSpinner)])),t("div",{staticClass:"q-uploader column no-wrap",class:{"q-uploader--dark q-dark":this.isDark,"q-uploader--bordered":this.bordered,"q-uploader--square no-border-radius":this.square,"q-uploader--flat no-shadow":this.flat,"disabled q-uploader--disable":this.disable},on:!0===this.canAddFiles?cache(this,"drag",{dragover:this.__onDragOver}):null},e)}});function getFn(t){return"function"==typeof t?t:()=>t}var UploaderXHRMixin={props:{url:[Function,String],method:{type:[Function,String],default:"POST"},fieldName:{type:[Function,String],default:t=>t.name},headers:[Function,Array],formFields:[Function,Array],withCredentials:[Function,Boolean],sendRaw:[Function,Boolean],batch:[Function,Boolean],factory:Function},data:()=>({xhrs:[],promises:[],workingThreads:0}),computed:{xhrProps(){return{url:getFn(this.url),method:getFn(this.method),headers:getFn(this.headers),formFields:getFn(this.formFields),fieldName:getFn(this.fieldName),withCredentials:getFn(this.withCredentials),sendRaw:getFn(this.sendRaw),batch:getFn(this.batch)}},isUploading(){return this.workingThreads>0},isBusy(){return this.promises.length>0}},methods:{abort(){this.xhrs.forEach(t=>{t.abort()}),this.promises.length>0&&(this.abortPromises=!0)},upload(){if(!1===this.canUpload)return;const t=this.queuedFiles.slice(0);this.queuedFiles=[],this.xhrProps.batch(t)?this.__runFactory(t):t.forEach(t=>{this.__runFactory([t])})},__runFactory(t){if(this.workingThreads++,"function"!=typeof this.factory)return void this.__uploadFiles(t,{});const e=this.factory(t);if(e)if("function"==typeof e.catch&&"function"==typeof e.then){this.promises.push(e);const i=i=>{!0!==this._isBeingDestroyed&&!0!==this._isDestroyed&&(this.promises=this.promises.filter(t=>t!==e),0===this.promises.length&&(this.abortPromises=!1),this.queuedFiles=this.queuedFiles.concat(t),t.forEach(t=>{this.__updateFile(t,"failed")}),this.$emit("factory-failed",i,t),this.workingThreads--)};e.then(s=>{!0===this.abortPromises?i(new Error("Aborted")):!0!==this._isBeingDestroyed&&!0!==this._isDestroyed&&(this.promises=this.promises.filter(t=>t!==e),this.__uploadFiles(t,s))}).catch(i)}else this.__uploadFiles(t,e||{});else this.$emit("factory-failed",new Error("QUploader: factory() does not return properly"),t),this.workingThreads--},__uploadFiles(t,e){const i=new FormData,s=new XMLHttpRequest,o=(t,i)=>void 0!==e[t]?getFn(e[t])(i):this.xhrProps[t](i),n=o("url",t);if(!n)return console.error("q-uploader: invalid or no URL specified"),void this.workingThreads--;const r=o("formFields",t);void 0!==r&&r.forEach(t=>{i.append(t.name,t.value)});let a,l=0,h=0,d=0,c=0;s.upload.addEventListener("progress",e=>{if(!0===a)return;const i=Math.min(c,e.loaded);this.uploadedSize+=i-d;let s=(d=i)-h;for(let e=l;s>0&&e<t.length;e++){const i=t[e];if(!(s>i.size))return void this.__updateFile(i,"uploading",s);s-=i.size,l++,h+=i.size,this.__updateFile(i,"uploading",i.size)}},!1),s.onreadystatechange=(()=>{s.readyState<4||(s.status&&s.status<400?(this.uploadedFiles=this.uploadedFiles.concat(t),t.forEach(t=>{this.__updateFile(t,"uploaded")}),this.$emit("uploaded",{files:t,xhr:s})):(a=!0,this.uploadedSize-=d,this.queuedFiles=this.queuedFiles.concat(t),t.forEach(t=>{this.__updateFile(t,"failed")}),this.$emit("failed",{files:t,xhr:s})),this.workingThreads--,this.xhrs=this.xhrs.filter(t=>t!==s))}),s.open(o("method",t),n),!0===o("withCredentials",t)&&(s.withCredentials=!0);const u=o("headers",t);void 0!==u&&u.forEach(t=>{s.setRequestHeader(t.name,t.value)});const p=o("sendRaw",t);t.forEach(t=>{this.__updateFile(t,"uploading",0),!0!==p&&i.append(o("fieldName",t),t,t.name),t.xhr=s,t.__abort=(()=>{s.abort()}),c+=t.size}),this.$emit("uploading",{files:t,xhr:s}),this.xhrs.push(s),!0===p?s.send(new Blob(t)):s.send(i)}}},QUploader=Vue.extend({name:"QUploader",mixins:[QUploaderBase,UploaderXHRMixin]}),QUploaderAddTrigger=Vue.extend({name:"QUploaderAddTrigger",inject:{__qUploaderGetInput:{default(){console.error("QUploaderAddTrigger needs to be child of QUploader")}}},render(t){return this.__qUploaderGetInput(t)}}),QVideo=Vue.extend({name:"QVideo",mixins:[RatioMixin,ListenersMixin],props:{src:{type:String,required:!0}},computed:{iframeData(){return{attrs:{src:this.src,frameborder:"0",allowfullscreen:!0}}},classes(){return"q-video"+(void 0!==this.ratio?" q-video--responsive":"")}},render(t){return t("div",{class:this.classes,style:this.ratioStyle,on:{...this.qListeners}},[t("iframe",this.iframeData)])}}),components$1=Object.freeze({__proto__:null,QAjaxBar:QAjaxBar,QAvatar:QAvatar,QBadge:QBadge,QBanner:QBanner,QBar:QBar,QBreadcrumbs:QBreadcrumbs,QBreadcrumbsEl:QBreadcrumbsEl,QBtn:QBtn,QBtnDropdown:QBtnDropdown,QBtnGroup:QBtnGroup,QBtnToggle:QBtnToggle,QCard:QCard,QCardSection:QCardSection,QCardActions:QCardActions,QCarousel:QCarousel,QCarouselSlide:QCarouselSlide,QCarouselControl:QCarouselControl,QChatMessage:QChatMessage,QCheckbox:QCheckbox,QChip:QChip,QCircularProgress:QCircularProgress,QColor:QColor,QDate:QDate,QDialog:QDialog,QDrawer:QDrawer,QEditor:QEditor,QExpansionItem:QExpansionItem,QFab:QFab,QFabAction:QFabAction,QField:QField,QFile:QFile,QFooter:QFooter,QForm:QForm,QHeader:QHeader,QIcon:QIcon,QImg:QImg,QInfiniteScroll:QInfiniteScroll,QInnerLoading:QInnerLoading,QInput:QInput,QIntersection:QIntersection,QList:QList,QItem:QItem,QItemSection:QItemSection,QItemLabel:QItemLabel,QKnob:QKnob,QLayout:QLayout,QMarkupTable:QMarkupTable,QMenu:QMenu,QNoSsr:QNoSsr,QOptionGroup:QOptionGroup,QPage:QPage,QPageContainer:QPageContainer,QPageScroller:QPageScroller,QPageSticky:QPageSticky,QPagination:QPagination,QParallax:QParallax,QPopupEdit:QPopupEdit,QPopupProxy:QPopupProxy,QLinearProgress:QLinearProgress,QPullToRefresh:QPullToRefresh,QRadio:QRadio,QRange:QRange,QRating:QRating,QResizeObserver:QResizeObserver,QResponsive:QResponsive,QScrollArea:QScrollArea,QScrollObserver:QScrollObserver,QSelect:QSelect,QSeparator:QSeparator,QSkeleton:QSkeleton,QSlideItem:QSlideItem,QSlideTransition:QSlideTransition,QSlider:QSlider,QSpace:QSpace,QSpinner:QSpinner,QSpinnerAudio:QSpinnerAudio,QSpinnerBall:QSpinnerBall,QSpinnerBars:QSpinnerBars,QSpinnerComment:QSpinnerComment,QSpinnerCube:QSpinnerCube,QSpinnerDots:QSpinnerDots,QSpinnerFacebook:QSpinnerFacebook,QSpinnerGears:QSpinnerGears,QSpinnerGrid:QSpinnerGrid,QSpinnerHearts:QSpinnerHearts,QSpinnerHourglass:QSpinnerHourglass,QSpinnerInfinity:QSpinnerInfinity,QSpinnerIos:QSpinnerIos,QSpinnerOval:QSpinnerOval,QSpinnerPie:QSpinnerPie,QSpinnerPuff:QSpinnerPuff,QSpinnerRadio:QSpinnerRadio,QSpinnerRings:QSpinnerRings,QSpinnerTail:QSpinnerTail,QSplitter:QSplitter,QStep:QStep,QStepper:QStepper,QStepperNavigation:QStepperNavigation,QTabPanels:QTabPanels,QTabPanel:QTabPanel,QTable:QTable,QTh:QTh,QTr:QTr,QTd:QTd,QTabs:QTabs,QTab:QTab,QRouteTab:QRouteTab,QTime:QTime,QTimeline:QTimeline,QTimelineEntry:QTimelineEntry,QToggle:QToggle,QToolbar:QToolbar,QToolbarTitle:QToolbarTitle,QTooltip:QTooltip,QTree:QTree,QUploader:QUploader,QUploaderBase:QUploaderBase,QUploaderAddTrigger:QUploaderAddTrigger,QVideo:QVideo,QVirtualScroll:QVirtualScroll});function getDepth(t){if(!1===t)return 0;if(!0===t||void 0===t)return 1;const e=parseInt(t,10);return isNaN(e)?0:e}var ClosePopup={name:"close-popup",bind(t,{value:e},i){const s={depth:getDepth(e),handler(t){0!==s.depth&&setTimeout(()=>{closePortals(i.componentInstance||i.context,t,s.depth)})},handlerKey(t){!0===isKeyCode(t,13)&&s.handler(t)}};void 0!==t.__qclosepopup&&(t.__qclosepopup_old=t.__qclosepopup),t.__qclosepopup=s,t.addEventListener("click",s.handler),t.addEventListener("keyup",s.handlerKey)},update(t,{value:e,oldValue:i}){void 0!==t.__qclosepopup&&e!==i&&(t.__qclosepopup.depth=getDepth(e))},unbind(t){const e=t.__qclosepopup_old||t.__qclosepopup;void 0!==e&&(t.removeEventListener("click",e.handler),t.removeEventListener("keyup",e.handlerKey),delete t[t.__qclosepopup_old?"__qclosepopup_old":"__qclosepopup"])}},GoBack={name:"go-back",bind(t,{value:e,modifiers:i},s){const o={value:e,position:window.history.length-1,single:i.single,goBack(){const t=s.context.$router;!0===o.single?t.go(-1):!0===client.is.nativeMobile?t.go(o.position-window.history.length):t.replace(o.value)},goBackKey(t){!0===isKeyCode(t,13)&&o.goBack()}};t.__qgoback&&(t.__qgoback_old=t.__qgoback),t.__qgoback=o,t.addEventListener("click",o.goBack),t.addEventListener("keyup",o.goBackKey)},update(t,{value:e,oldValue:i,modifiers:s}){const o=t.__qgoback;void 0!==o&&(e!==i&&(o.value=e),o.single!==s.single&&(o.single=s.single))},unbind(t){const e=t.__qgoback_old||t.__qgoback;void 0!==e&&(t.removeEventListener("click",e.goBack),t.removeEventListener("keyup",e.goBackKey),delete t[t.__qgoback_old?"__qgoback_old":"__qgoback"])}};const defaultCfg$1={childList:!0,subtree:!0,attributes:!0,characterData:!0,attributeOldValue:!0,characterDataOldValue:!0};function update$1(t,e,{modifiers:{once:i,...s},value:o}){let n;e.once=i,e.handler!==o&&(n=!0,e.handler=o),void 0!==e.opts&&!1!==isDeepEqual(s,e.mod)||(n=!0,e.mod=s,e.opts=0===Object.keys(s).length?defaultCfg$1:s),!0===n&&(void 0!==e.observer&&e.observer.disconnect(),e.observer=new MutationObserver(i=>{if("function"==typeof e.handler){!1!==e.handler(i)&&!0!==e.once||destroy$1(t)}}),e.observer.observe(t,e.opts))}function destroy$1(t){const e=t.__qmutation;void 0!==e&&(void 0!==e.observer&&e.observer.disconnect(),delete t.__qmutation)}var Mutation={name:"mutation",inserted(t,e){const i={};update$1(t,i,e),t.__qmutation=i},update(t,e){const i=t.__qmutation;void 0!==i&&update$1(t,i,e)},unbind:destroy$1};function updateBinding(t,{value:e,oldValue:i}){"function"==typeof e?(t.handler=e,"function"!=typeof i&&(t.scrollTarget.addEventListener("scroll",t.scroll,listenOpts.passive),t.scroll())):t.scrollTarget.removeEventListener("scroll",t.scroll)}var ScrollFire={name:"scroll-fire",bind(t){const e={scroll:debounce(()=>{let i,s;e.scrollTarget===window?(s=t.getBoundingClientRect().bottom,i=window.innerHeight):(s=offset(t).top+height(t),i=offset(e.scrollTarget).top+height(e.scrollTarget)),s>0&&s<i&&(e.scrollTarget.removeEventListener("scroll",e.scroll,listenOpts.passive),e.handler(t))},25)};t.__qscrollfire&&(t.__qscrollfire_old=t.__qscrollfire),t.__qscrollfire=e},inserted(t,e){const i=t.__qscrollfire;i.scrollTarget=getScrollTarget(t),updateBinding(i,e)},update(t,e){void 0!==t.__qscrollfire&&e.value!==e.oldValue&&updateBinding(t.__qscrollfire,e)},unbind(t){const e=t.__qscrollfire_old||t.__qscrollfire;void 0!==e&&(e.scrollTarget.removeEventListener("scroll",e.scroll,listenOpts.passive),delete t[t.__qscrollfire_old?"__qscrollfire_old":"__qscrollfire"])}};function updateBinding$1(t,{value:e,oldValue:i}){"function"==typeof e?(t.handler=e,"function"!=typeof i&&t.scrollTarget.addEventListener("scroll",t.scroll,listenOpts.passive)):t.scrollTarget.removeEventListener("scroll",t.scroll,listenOpts.passive)}var Scroll={name:"scroll",bind(t){const e={scroll(){e.handler(getScrollPosition(e.scrollTarget),getHorizontalScrollPosition(e.scrollTarget))}};t.__qscroll&&(t.__qscroll_old=t.__qscroll),t.__qscroll=e},inserted(t,e){const i=t.__qscroll;i.scrollTarget=getScrollTarget(t),updateBinding$1(i,e)},update(t,e){void 0!==t.__qscroll&&e.oldValue!==e.value&&updateBinding$1(t.__qscroll,e)},unbind(t){const e=t.__qscroll_old||t.__qscroll;void 0!==e&&(e.scrollTarget.removeEventListener("scroll",e.scroll,listenOpts.passive),delete t[t.__qscroll_old?"__qscroll_old":"__qscroll"])}};function update$2(t,e){const i=t.__qtouchhold;if(void 0!==i){e.oldValue!==e.value&&("function"!=typeof e.value&&i.end(),i.handler=e.value);const t=[600,5,7];"string"==typeof e.arg&&e.arg.length&&e.arg.split(":").forEach((e,i)=>{const s=parseInt(e,10);s&&(t[i]=s)}),[i.duration,i.touchSensitivity,i.mouseSensitivity]=t}}var TouchHold={name:"touch-hold",bind(t,e){const{modifiers:i}=e;if(!0!==i.mouse&&!0!==client.has.touch)return;const s={noop:noop,mouseStart(t){"function"==typeof s.handler&&!0===leftClick(t)&&(addEvt(s,"temp",[[document,"mousemove","move","passiveCapture"],[document,"click","end","notPassiveCapture"]]),s.start(t,!0))},touchStart(t){if(void 0!==t.target&&"function"==typeof s.handler){const e=getTouchTarget(t.target);addEvt(s,"temp",[[e,"touchmove","move","passiveCapture"],[e,"touchcancel","end","notPassiveCapture"],[e,"touchend","end","notPassiveCapture"]]),s.start(t)}},start(t,e){s.origin=position(t);const i=Date.now();!0===client.is.mobile&&(document.body.classList.add("non-selectable"),clearSelection(),s.styleCleanup=(t=>{s.styleCleanup=void 0;const e=()=>{document.body.classList.remove("non-selectable")};!0===t?(clearSelection(),setTimeout(e,10)):e()})),s.triggered=!1,s.sensitivity=!0===e?s.mouseSensitivity:s.touchSensitivity,s.timer=setTimeout(()=>{clearSelection(),s.triggered=!0,s.handler({evt:t,touch:!0!==e,mouse:!0===e,position:s.origin,duration:Date.now()-i})},s.duration)},move(t){const{top:e,left:i}=position(t);(Math.abs(i-s.origin.left)>=s.sensitivity||Math.abs(e-s.origin.top)>=s.sensitivity)&&clearTimeout(s.timer)},end(t){cleanEvt(s,"temp"),void 0!==s.styleCleanup&&s.styleCleanup(s.triggered),!0===s.triggered?void 0!==t&&stopAndPrevent(t):clearTimeout(s.timer)}};t.__qtouchhold&&(t.__qtouchhold_old=t.__qtouchhold),t.__qtouchhold=s,update$2(t,e),!0===i.mouse&&addEvt(s,"main",[[t,"mousedown","mouseStart",`passive${!0===i.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(s,"main",[[t,"touchstart","touchStart",`passive${!0===i.capture?"Capture":""}`],[t,"touchend","noop","notPassiveCapture"]])},update:update$2,unbind(t){const e=t.__qtouchhold_old||t.__qtouchhold;void 0!==e&&(cleanEvt(e,"main"),cleanEvt(e,"temp"),clearTimeout(e.timer),void 0!==e.styleCleanup&&e.styleCleanup(),delete t[t.__qtouchhold_old?"__qtouchhold_old":"__qtouchhold"])}};const keyCodes$2={esc:27,tab:9,enter:13,space:32,up:38,left:37,right:39,down:40,delete:[8,46]},keyRegex=new RegExp(`^([\\d+]+|${Object.keys(keyCodes$2).join("|")})$`,"i");function shouldEnd(t,e){const{top:i,left:s}=position(t);return Math.abs(s-e.left)>=7||Math.abs(i-e.top)>=7}var TouchRepeat={name:"touch-repeat",bind(t,{modifiers:e,value:i,arg:s}){const o=Object.keys(e).reduce((t,e)=>{if(!0===keyRegex.test(e)){const i=isNaN(parseInt(e,10))?keyCodes$2[e.toLowerCase()]:parseInt(e,10);i>=0&&t.push(i)}return t},[]);if(!0!==e.mouse&&!0!==client.has.touch&&0===o.length)return;const n="string"==typeof s&&s.length>0?s.split(":").map(t=>parseInt(t,10)):[0,600,300],r=n.length-1,a={keyboard:o,handler:i,noop:noop,mouseStart(t){void 0===a.event&&"function"==typeof a.handler&&!0===leftClick(t)&&(addEvt(a,"temp",[[document,"mousemove","move","passiveCapture"],[document,"click","end","notPassiveCapture"]]),a.start(t,!0))},keyboardStart(e){if("function"==typeof a.handler&&!0===isKeyCode(e,o)){if((0===n[0]||void 0!==a.event)&&(stopAndPrevent(e),t.focus(),void 0!==a.event))return;addEvt(a,"temp",[[document,"keyup","end","notPassiveCapture"],[document,"click","end","notPassiveCapture"]]),a.start(e,!1,!0)}},touchStart(t){if(void 0!==t.target&&"function"==typeof a.handler){const e=getTouchTarget(t.target);addEvt(a,"temp",[[e,"touchmove","move","passiveCapture"],[e,"touchcancel","end","notPassiveCapture"],[e,"touchend","end","notPassiveCapture"]]),a.start(t)}},start(t,e,i){function s(t){a.styleCleanup=void 0,document.documentElement.style.cursor="";const e=()=>{document.body.classList.remove("non-selectable")};!0===t?(clearSelection(),setTimeout(e,10)):e()}!0!==i&&(a.origin=position(t)),!0===client.is.mobile&&(document.body.classList.add("non-selectable"),clearSelection(),a.styleCleanup=s),a.event={touch:!0!==e&&!0!==i,mouse:!0===e,keyboard:!0===i,startTime:Date.now(),repeatCount:0};const o=()=>{if(void 0===a.event)return;0===a.event.repeatCount&&(a.event.evt=t,!0===i?a.event.keyCode=t.keyCode:a.event.position=position(t),!0!==client.is.mobile&&(document.documentElement.style.cursor="pointer",document.body.classList.add("non-selectable"),clearSelection(),a.styleCleanup=s)),a.event.duration=Date.now()-a.event.startTime,a.event.repeatCount+=1,a.handler(a.event);const e=r<a.event.repeatCount?r:a.event.repeatCount;a.timer=setTimeout(o,n[e])};0===n[0]?o():a.timer=setTimeout(o,n[0])},move(t){void 0!==a.event&&!0===shouldEnd(t,a.origin)&&clearTimeout(a.timer)},end(t){void 0!==a.event&&(void 0!==a.styleCleanup&&a.styleCleanup(!0),void 0!==t&&a.event.repeatCount>0&&stopAndPrevent(t),cleanEvt(a,"temp"),clearTimeout(a.timer),a.event=void 0)}};void 0!==t.__qtouchrepeat&&(t.__qtouchrepeat_old=t.__qtouchrepeat),t.__qtouchrepeat=a,!0===e.mouse&&addEvt(a,"main",[[t,"mousedown","mouseStart",`passive${!0===e.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(a,"main",[[t,"touchstart","touchStart",`passive${!0===e.capture?"Capture":""}`],[t,"touchend","noop","notPassiveCapture"]]),o.length>0&&addEvt(a,"main",[[t,"keydown","keyboardStart",`notPassive${!0===e.keyCapture?"Capture":""}`]])},update(t,e){const i=t.__qtouchrepeat;void 0!==i&&e.oldValue!==e.value&&("function"!=typeof e.value&&i.end(),i.handler=e.value)},unbind(t){const e=t.__qtouchrepeat_old||t.__qtouchrepeat;void 0!==e&&(clearTimeout(e.timer),cleanEvt(e,"main"),cleanEvt(e,"temp"),void 0!==e.styleCleanup&&e.styleCleanup(),delete t[t.__qtouchrepeat_old?"__qtouchrepeat_old":"__qtouchrepeat"])}},directives=Object.freeze({__proto__:null,ClosePopup:ClosePopup,GoBack:GoBack,Intersection:Intersection,Mutation:Mutation,Ripple:Ripple,ScrollFire:ScrollFire,Scroll:Scroll,TouchHold:TouchHold,TouchPan:TouchPan,TouchRepeat:TouchRepeat,TouchSwipe:TouchSwipe});let metaValue;function getProp(){return Platform.is.winphone?"msapplication-navbutton-color":Platform.is.safari?"apple-mobile-web-app-status-bar-style":"theme-color"}function getMetaTag(t){const e=document.getElementsByTagName("META");for(const i in e)if(e[i].name===t)return e[i]}function setColor(t){void 0===metaValue&&(metaValue=getProp());let e=getMetaTag(metaValue);const i=void 0===e;i&&(e=document.createElement("meta")).setAttribute("name",metaValue),e.setAttribute("content",t),i&&document.head.appendChild(e)}var AddressbarColor={install({$q:t,cfg:e}){this.set=!1!==isSSR||!0!==Platform.is.mobile||!0!==Platform.is.nativeMobile&&!0!==Platform.is.winphone&&!0!==Platform.is.safari&&!0!==Platform.is.webkit&&!0!==Platform.is.vivaldi?noop:t=>{const e=t||getBrand("primary");!0===Platform.is.nativeMobile&&window.StatusBar?window.StatusBar.backgroundColorByHexString(e):setColor(e)},t.addressbarColor=this,e.addressbarColor&&this.set(e.addressbarColor)}};const prefixes={};function promisify(t,e){try{const i=t[e]();return void 0===i?Promise.resolve():i}catch(t){return Promise.reject(t)}}var AppFullscreen={isCapable:!1,isActive:!1,activeEl:null,request(t){if(!0===this.isCapable&&!1===this.isActive){const e=t||document.documentElement;return promisify(e,prefixes.request).then(()=>{this.activeEl=e})}return this.__getErr()},exit(){return!0===this.isCapable&&!0===this.isActive?promisify(document,prefixes.exit).then(()=>{this.activeEl=null}):this.__getErr()},toggle(t){return!0===this.isActive?this.exit():this.request(t)},install({$q:t}){t.fullscreen=this,!0!==isSSR&&(prefixes.request=["requestFullscreen","msRequestFullscreen","mozRequestFullScreen","webkitRequestFullscreen"].find(t=>void 0!==document.documentElement[t]),this.isCapable=void 0!==prefixes.request,!1!==this.isCapable?(this.__getErr=(()=>Promise.resolve()),prefixes.exit=["exitFullscreen","msExitFullscreen","mozCancelFullScreen","webkitExitFullscreen"].find(t=>document[t]),this.isActive=!!(document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement),["onfullscreenchange","onmsfullscreenchange","onwebkitfullscreenchange"].forEach(t=>{document[t]=(()=>{this.isActive=!1===this.isActive})}),Vue.util.defineReactive(this,"isActive",this.isActive),Vue.util.defineReactive(this,"activeEl",this.activeEl)):this.__getErr=(()=>Promise.reject("Not capable")))}},AppVisibility={appVisible:!1,install({$q:t}){if(!0===isSSR)return void(this.appVisible=t.appVisible=!0);let e,i;void 0!==document.hidden?(e="hidden",i="visibilitychange"):void 0!==document.msHidden?(e="msHidden",i="msvisibilitychange"):void 0!==document.webkitHidden&&(e="webkitHidden",i="webkitvisibilitychange");const s=()=>{this.appVisible=t.appVisible=!document[e]};s(),i&&void 0!==document[e]&&(Vue.util.defineReactive(t,"appVisible",this.appVisible),document.addEventListener(i,s,!1))}},BottomSheet=Vue.extend({name:"BottomSheetPlugin",mixins:[DarkMixin,AttrsMixin],inheritAttrs:!1,props:{title:String,message:String,actions:Array,grid:Boolean,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},computed:{dialogProps(){return{...this.qAttrs,position:"bottom"}}},methods:{show(){this.$refs.dialog.show()},hide(){this.$refs.dialog.hide()},onOk(t){this.$emit("ok",t),this.hide()},__getGrid(t){return this.actions.map(e=>{const i=e.avatar||e.img;return void 0===e.label?t(QSeparator,{staticClass:"col-all",props:{dark:this.isDark}}):t("div",{staticClass:"q-bottom-sheet__item q-hoverable q-focusable cursor-pointer relative-position",class:e.classes,attrs:{tabindex:0},on:{click:()=>this.onOk(e),keyup:t=>{13===t.keyCode&&this.onOk(e)}}},[t("div",{staticClass:"q-focus-helper"}),e.icon?t(QIcon,{props:{name:e.icon,color:e.color}}):i?t("img",{attrs:{src:i},staticClass:e.avatar?"q-bottom-sheet__avatar":null}):t("div",{staticClass:"q-bottom-sheet__empty-icon"}),t("div",[e.label])])})},__getList(t){return this.actions.map(e=>{const i=e.avatar||e.img;return void 0===e.label?t(QSeparator,{props:{spaced:!0,dark:this.isDark}}):t(QItem,{staticClass:"q-bottom-sheet__item",class:e.classes,props:{tabindex:0,clickable:!0,dark:this.isDark},on:{click:()=>this.onOk(e),keyup:t=>{13===t.keyCode&&this.onOk(e)}}},[t(QItemSection,{props:{avatar:!0}},[e.icon?t(QIcon,{props:{name:e.icon,color:e.color}}):i?t("img",{attrs:{src:i},staticClass:e.avatar?"q-bottom-sheet__avatar":null}):null]),t(QItemSection,[e.label])])})}},render(t){const e=[];return this.title&&e.push(t(QCardSection,{staticClass:"q-dialog__title"},[this.title])),this.message&&e.push(t(QCardSection,{staticClass:"q-dialog__message"},[this.message])),e.push(!0===this.grid?t("div",{staticClass:"row items-stretch justify-start"},this.__getGrid(t)):t("div",this.__getList(t))),t(QDialog,{ref:"dialog",props:this.dialogProps,on:cache(this,"hide",{hide:()=>{this.$emit("hide")}})},[t(QCard,{staticClass:`q-bottom-sheet q-bottom-sheet--${!0===this.grid?"grid":"list"}`+(!0===this.isDark?" q-bottom-sheet--dark q-dark":""),style:this.cardStyle,class:this.cardClass},e)])}});const ssrAPI={onOk:()=>ssrAPI,okCancel:()=>ssrAPI,hide:()=>ssrAPI};function globalDialog(t){return({className:e,class:i,style:s,component:o,root:n,parent:r,...a})=>{if(!0===isSSR)return ssrAPI;void 0!==i&&(a.cardClass=i),void 0!==s&&(a.cardStyle=s);const l=[],h=[],d={onOk:t=>(l.push(t),d),onCancel:t=>(h.push(t),d),onDismiss:t=>(l.push(t),h.push(t),d),hide:()=>(f.$refs.dialog.hide(),d)},c=document.createElement("div");document.body.appendChild(c);let u=!1;const p={ok:t=>{u=!0,l.forEach(e=>{e(t)})},hide:()=>{f.$destroy(),f.$el.remove(),f=null,!0!==u&&h.forEach(t=>{t()})}};Vue.observable(a);const m=void 0!==o?o:t,g=void 0===o?a:void 0;let f=new Vue({name:"QGlobalDialog",el:c,parent:void 0===r?n:r,render:t=>t(m,{ref:"dialog",props:a,attrs:g,on:p}),mounted(){this.$refs.dialog.show()}});return d}}var BottomSheet$1={install({$q:t}){this.create=t.bottomSheet=globalDialog(BottomSheet)}};function encode(t){return encodeURIComponent(t)}function decode(t){return decodeURIComponent(t)}function stringifyCookieValue(t){return encode(t===Object(t)?JSON.stringify(t):""+t)}function read(t){if(""===t)return t;0===t.indexOf('"')&&(t=t.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\")),t=decode(t.replace(/\+/g," "));try{t=JSON.parse(t)}catch(t){}return t}function getString(t){const e=new Date;return e.setMilliseconds(e.getMilliseconds()+t),e.toUTCString()}function parseExpireString(t){let e=0;const i=t.match(/(\d+)d/),s=t.match(/(\d+)h/),o=t.match(/(\d+)m/),n=t.match(/(\d+)s/);return i&&(e+=864e5*i[1]),s&&(e+=36e5*s[1]),o&&(e+=6e4*o[1]),n&&(e+=1e3*n[1]),0===e?t:getString(e)}function set(t,e,i={},s){let o,n;void 0!==i.expires&&("[object Date]"===Object.prototype.toString.call(i.expires)?o=i.expires.toUTCString():"string"==typeof i.expires?o=parseExpireString(i.expires):(n=parseFloat(i.expires),o=!1===isNaN(n)?getString(864e5*n):i.expires));const r=`${encode(t)}=${stringifyCookieValue(e)}`,a=[r,void 0!==o?"; Expires="+o:"",i.path?"; Path="+i.path:"",i.domain?"; Domain="+i.domain:"",i.sameSite?"; SameSite="+i.sameSite:"",i.httpOnly?"; HttpOnly":"",i.secure?"; Secure":"",i.other?"; "+i.other:""].join("");if(s){s.req.qCookies?s.req.qCookies.push(a):s.req.qCookies=[a],s.res.setHeader("Set-Cookie",s.req.qCookies);let e=s.req.headers.cookie||"";if(void 0!==o&&n<0){const i=get(t,s);void 0!==i&&(e=e.replace(`${t}=${i}; `,"").replace(`; ${t}=${i}`,"").replace(`${t}=${i}`,""))}else e=e?`${r}; ${e}`:a;s.req.headers.cookie=e}else document.cookie=a}function get(t,e){const i=e?e.req.headers:document,s=i.cookie?i.cookie.split("; "):[],o=s.length;let n,r,a,l=t?null:{},h=0;for(;h<o;h++)if(r=decode((n=s[h].split("=")).shift()),a=n.join("="),t){if(t===r){l=read(a);break}}else l[r]=a;return l}function remove(t,e,i){set(t,"",{expires:-1,...e},i)}function has(t,e){return null!==get(t,e)}function getObject(t){return{get:e=>get(e,t),set:(e,i,s)=>set(e,i,s,t),has:e=>has(e,t),remove:(e,i)=>remove(e,i,t),getAll:()=>get(null,t)}}var Cookies={parseSSR(t){return void 0!==t?getObject(t):this},install({$q:t,queues:e}){!0===isSSR?e.server.push((t,e)=>{t.cookies=getObject(e.ssr)}):(Object.assign(this,getObject()),t.cookies=this)}},DialogPlugin=Vue.extend({name:"DialogPlugin",mixins:[DarkMixin,AttrsMixin],inheritAttrs:!1,props:{title:String,message:String,prompt:Object,options:Object,html:Boolean,ok:{type:[String,Object,Boolean],default:!0},cancel:[String,Object,Boolean],focus:{type:String,default:"ok",validator:t=>["ok","cancel","none"].includes(t)},stackButtons:Boolean,color:String,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},computed:{hasForm(){return void 0!==this.prompt||void 0!==this.options},okLabel(){return Object(this.ok)===this.ok?this.$q.lang.label.ok:!0===this.ok?this.$q.lang.label.ok:this.ok},cancelLabel(){return Object(this.cancel)===this.cancel?this.$q.lang.label.cancel:!0===this.cancel?this.$q.lang.label.cancel:this.cancel},vmColor(){return this.color||(!0===this.isDark?"amber":"primary")},okDisabled(){return void 0!==this.prompt?void 0!==this.prompt.isValid&&!0!==this.prompt.isValid(this.prompt.model):void 0!==this.options?void 0!==this.options.isValid&&!0!==this.options.isValid(this.options.model):void 0},okProps(){return{color:this.vmColor,label:this.okLabel,ripple:!1,...Object(this.ok)===this.ok?this.ok:{flat:!0},disable:this.okDisabled}},cancelProps(){return{color:this.vmColor,label:this.cancelLabel,ripple:!1,...Object(this.cancel)===this.cancel?this.cancel:{flat:!0}}}},methods:{show(){this.$refs.dialog.show()},hide(){this.$refs.dialog.hide()},getPrompt(t){return[t(QInput,{props:{value:this.prompt.model,type:this.prompt.type,label:this.prompt.label,stackLabel:this.prompt.stackLabel,outlined:this.prompt.outlined,filled:this.prompt.filled,standout:this.prompt.standout,rounded:this.prompt.rounded,square:this.prompt.square,counter:this.prompt.counter,maxlength:this.prompt.maxlength,prefix:this.prompt.prefix,suffix:this.prompt.suffix,color:this.vmColor,dense:!0,autofocus:!0,dark:this.isDark},attrs:this.prompt.attrs,on:cache(this,"prompt",{input:t=>{this.prompt.model=t},keyup:t=>{!0!==this.okDisabled&&"textarea"!==this.prompt.type&&!0===isKeyCode(t,13)&&this.onOk()}})})]},getOptions(t){return[t(QOptionGroup,{props:{value:this.options.model,type:this.options.type,color:this.vmColor,inline:this.options.inline,options:this.options.items,dark:this.isDark},on:cache(this,"opts",{input:t=>{this.options.model=t}})})]},getButtons(t){const e=[];if(this.cancel&&e.push(t(QBtn,{props:this.cancelProps,attrs:{"data-autofocus":"cancel"===this.focus&&!0!==this.hasForm},on:cache(this,"cancel",{click:this.onCancel})})),this.ok&&e.push(t(QBtn,{props:this.okProps,attrs:{"data-autofocus":"ok"===this.focus&&!0!==this.hasForm},on:cache(this,"ok",{click:this.onOk})})),e.length>0)return t(QCardActions,{staticClass:!0===this.stackButtons?"items-end":null,props:{vertical:this.stackButtons,align:"right"}},e)},onOk(){this.$emit("ok",clone$1(this.getData())),this.hide()},onCancel(){this.hide()},getData(){return void 0!==this.prompt?this.prompt.model:void 0!==this.options?this.options.model:void 0},getSection(t,e,i){return!0===this.html?t(QCardSection,{staticClass:e,domProps:{innerHTML:i}}):t(QCardSection,{staticClass:e},[i])}},render(t){const e=[];return this.title&&e.push(this.getSection(t,"q-dialog__title",this.title)),this.message&&e.push(this.getSection(t,"q-dialog__message",this.message)),void 0!==this.prompt?e.push(t(QCardSection,{staticClass:"scroll q-dialog-plugin__form"},this.getPrompt(t))):void 0!==this.options&&e.push(t(QSeparator,{props:{dark:this.isDark}}),t(QCardSection,{staticClass:"scroll q-dialog-plugin__form"},this.getOptions(t)),t(QSeparator,{props:{dark:this.isDark}})),(this.ok||this.cancel)&&e.push(this.getButtons(t)),t(QDialog,{ref:"dialog",props:{...this.qAttrs,value:this.value},on:cache(this,"hide",{hide:()=>{this.$emit("hide")}})},[t(QCard,{staticClass:"q-dialog-plugin"+(!0===this.isDark?" q-dialog-plugin--dark q-dark":""),style:this.cardStyle,class:this.cardClass,props:{dark:this.isDark}},e)])}}),Dialog={install({$q:t}){this.create=t.dialog=globalDialog(DialogPlugin)}},LoadingBar={isActive:!1,start:noop,stop:noop,increment:noop,setDefaults:noop,install({$q:t,cfg:e}){if(!0===isSSR)return void(t.loadingBar=this);const i=void 0!==e.loadingBar?{...e.loadingBar}:{},s=t.loadingBar=new Vue({name:"LoadingBar",render:t=>t(QAjaxBar,{ref:"bar",props:i})}).$mount().$refs.bar;Object.assign(this,{start:t=>{s.start(t),this.isActive=s.isActive=s.calls>0},stop:()=>{s.stop(),this.isActive=s.isActive=s.calls>0},increment:s.increment,setDefaults:t=>{t===Object(t)&&Object.assign(i,t),s.$parent.$forceUpdate()}}),Vue.util.defineReactive(this,"isActive",this.isActive),Vue.util.defineReactive(s,"isActive",this.isActive),s.setDefaults=this.setDefaults,document.body.appendChild(s.$parent.$el)}};let vm,timeout,uid$3=0,props={};const originalDefaults={delay:0,message:!1,spinnerSize:80,spinnerColor:"white",messageColor:"white",backgroundColor:"black",spinner:QSpinner,customClass:""},defaults={...originalDefaults},Loading={isActive:!1,show(t){!0!==isSSR&&((props=t===Object(t)&&!0===t.ignoreDefaults?{...originalDefaults,...t}:{...defaults,...t}).customClass+=` text-${props.backgroundColor}`,props.uid=`l_${uid$3++}`,this.isActive=!0,void 0===vm?(clearTimeout(timeout),timeout=setTimeout(()=>{timeout=void 0;const t=document.createElement("div");document.body.appendChild(t),vm=new Vue({name:"QLoading",el:t,mounted(){preventScroll(!0)},render:t=>t("transition",{props:{name:"q-transition--fade",appear:!0},on:cache(this,"tr",{"after-leave":()=>{!0!==this.isActive&&void 0!==vm&&(preventScroll(!1),vm.$destroy(),vm.$el.remove(),vm=void 0)}})},[!0===this.isActive?t("div",{staticClass:"q-loading fullscreen column flex-center z-max",key:props.uid,class:props.customClass.trim()},[t(props.spinner,{props:{color:props.spinnerColor,size:props.spinnerSize}}),props.message&&t("div",{class:`text-${props.messageColor}`,domProps:{[!0===props.sanitize?"textContent":"innerHTML"]:props.message}})||void 0]):null])})},props.delay)):vm.$forceUpdate())},hide(){!0===this.isActive&&(void 0!==timeout&&(clearTimeout(timeout),timeout=void 0),this.isActive=!1)},setDefaults(t){t===Object(t)&&Object.assign(defaults,t)},install({$q:t,cfg:{loading:e}}){this.setDefaults(e),t.loading=this}};let updateId,ssrTakeover;function normalize(t){t.title&&(t.title=t.titleTemplate?t.titleTemplate(t.title):t.title,delete t.titleTemplate),[["meta","content"],["link","href"]].forEach(e=>{const i=t[e[0]],s=e[1];for(const t in i){const e=i[t];e.template&&(1===Object.keys(e).length?delete i[t]:(e[s]=e.template(e[s]||""),delete e.template))}})}function changed(t,e){if(Object.keys(t).length!==Object.keys(e).length)return!0;for(const i in t)if(t[i]!==e[i])return!0}function bodyFilter(t){return!1===["class","style"].includes(t)}function htmlFilter(t){return!1===["lang","dir"].includes(t)}function diff(t,e){const i={},s={};return void 0===t?{add:e,remove:s}:(t.title!==e.title&&(i.title=e.title),["meta","link","script","htmlAttr","bodyAttr"].forEach(o=>{const n=t[o],r=e[o];if(s[o]=[],void 0!==n&&null!==n){i[o]={};for(const t in n)!1===r.hasOwnProperty(t)&&s[o].push(t);for(const t in r)!1===n.hasOwnProperty(t)?i[o][t]=r[t]:!0===changed(n[t],r[t])&&(s[o].push(t),i[o][t]=r[t])}else i[o]=r}),{add:i,remove:s})}function apply$1({add:t,remove:e}){t.title&&(document.title=t.title),Object.keys(e).length>0&&(["meta","link","script"].forEach(t=>{e[t].forEach(e=>{document.head.querySelector(`${t}[data-qmeta="${e}"]`).remove()})}),e.htmlAttr.filter(htmlFilter).forEach(t=>{document.documentElement.removeAttribute(t)}),e.bodyAttr.filter(bodyFilter).forEach(t=>{document.body.removeAttribute(t)})),["meta","link","script"].forEach(e=>{const i=t[e];for(const t in i){const s=document.createElement(e);for(const e in i[t])"innerHTML"!==e&&s.setAttribute(e,i[t][e]);s.setAttribute("data-qmeta",t),"script"===e&&(s.innerHTML=i[t].innerHTML||""),document.head.appendChild(s)}}),Object.keys(t.htmlAttr).filter(htmlFilter).forEach(e=>{document.documentElement.setAttribute(e,t.htmlAttr[e]||"")}),Object.keys(t.bodyAttr).filter(bodyFilter).forEach(e=>{document.body.setAttribute(e,t.bodyAttr[e]||"")})}function parseMeta(t,e){!0!==t._inactive&&(!0===hasMeta(t)&&(extend(!0,e,t.__qMeta),!0===t.$options.meta.stopPropagation)||t.$children.forEach(t=>{parseMeta(t,e)}))}function updateClient(){!0===ssrTakeover&&(ssrTakeover=!1,this.$root.__currentMeta=window.__Q_META__);const t={title:"",titleTemplate:null,meta:{},link:{},script:{},htmlAttr:{},bodyAttr:{}};parseMeta(this.$root,t),normalize(t),apply$1(diff(this.$root.__currentMeta,t)),this.$root.__currentMeta=t}function getAttr(t){return e=>{const i=t[e];return e+(void 0!==i?`="${i}"`:"")}}function getHead(t){let e="";return t.title&&(e+=`<title>${t.title}</title>`),["meta","link","script"].forEach(i=>{const s=t[i];for(const t in s){const o=Object.keys(s[t]).filter(t=>"innerHTML"!==t).map(getAttr(s[t]));e+=`<${i} ${o.join(" ")} data-qmeta="${t}">`,"script"===i&&(e+=(s[t].innerHTML||"")+"<\/script>")}}),e}function getServerMeta(t,e,i){const s={title:"",titleTemplate:null,meta:{},link:{},htmlAttr:{},bodyAttr:{},noscript:{}};parseMeta(t,s),normalize(s);const o=void 0!==i&&void 0!==i.nonce?` nonce="${i.nonce}"`:"",n={"%%Q_HTML_ATTRS%%":Object.keys(s.htmlAttr).filter(htmlFilter).map(getAttr(s.htmlAttr)).join(" "),"%%Q_HEAD_TAGS%%":getHead(s),"%%Q_BODY_ATTRS%%":Object.keys(s.bodyAttr).filter(bodyFilter).map(getAttr(s.bodyAttr)).join(" "),"%%Q_BODY_TAGS%%":Object.keys(s.noscript).map(t=>`<noscript data-qmeta="${t}">${s.noscript[t]}</noscript>`).join("")+`<script${o}>window.__Q_META__=${delete s.noscript&&JSON.stringify(s)}<\/script>`};return Object.keys(n).forEach(t=>{e=e.replace(t,n[t])}),e}function beforeCreate(){"function"==typeof this.$options.meta?(void 0===this.$options.computed&&(this.$options.computed={}),this.$options.computed.__qMeta=this.$options.meta):!0===hasMeta(this)&&(this.__qMeta=this.$options.meta)}function hasMeta(t){return void 0!==t.$options.meta&&null!==t.$options.meta}function triggerMeta(){!0===hasMeta(this)&&this.__qMetaUpdate()}!1===isSSR&&Vue.util.defineReactive(Loading,"isActive",Loading.isActive);var Meta={install({queues:t}){!0===isSSR?(Vue.prototype.$getMetaHTML=(t=>(e,i)=>getServerMeta(t,e,i)),Vue.mixin({beforeCreate:beforeCreate}),t.server.push((t,e)=>{e.ssr.Q_HTML_ATTRS+=" %%Q_HTML_ATTRS%%",Object.assign(e.ssr,{Q_HEAD_TAGS:"%%Q_HEAD_TAGS%%",Q_BODY_ATTRS:"%%Q_BODY_ATTRS%%",Q_BODY_TAGS:"%%Q_BODY_TAGS%%"})})):(ssrTakeover=fromSSR,Vue.mixin({beforeCreate:beforeCreate,created(){!0===hasMeta(this)&&(this.__qMetaUnwatch=this.$watch("__qMeta",this.__qMetaUpdate))},activated:triggerMeta,deactivated:triggerMeta,beforeMount:triggerMeta,destroyed(){!0===hasMeta(this)&&(this.__qMetaUnwatch(),this.__qMetaUpdate())},methods:{__qMetaUpdate(){clearTimeout(updateId),updateId=setTimeout(updateClient.bind(this),50)}}}))}};let uid$4=0;const defaults$1={},attrs$2={role:"alert"},positionList=["top-left","top-right","bottom-left","bottom-right","top","bottom","left","right","center"],badgePositions=["top-left","top-right","bottom-left","bottom-right"],notifTypes={positive:{icon(){return this.$q.iconSet.type.positive},color:"positive"},negative:{icon(){return this.$q.iconSet.type.negative},color:"negative"},warning:{icon(){return this.$q.iconSet.type.warning},color:"warning",textColor:"dark"},info:{icon(){return this.$q.iconSet.type.info},color:"info"}},groups={},positionClass$1={},Notifications={name:"QNotifications",created(){this.notifs={},positionList.forEach(t=>{this.notifs[t]=[];const e=["left","center","right"].includes(t)?"center":t.indexOf("top")>-1?"top":"bottom",i=t.indexOf("left")>-1?"start":t.indexOf("right")>-1?"end":"center",s=["left","right"].includes(t)?`items-${"left"===t?"start":"end"} justify-center`:"center"===t?"flex-center":`items-${i}`;positionClass$1[t]=`q-notifications__list q-notifications__list--${e} fixed column no-wrap ${s}`})},methods:{add(t){if(!t)return console.error("Notify: parameter required"),!1;const e={textColor:"white"};if("string"!=typeof t&&!0===t.ignoreDefaults||Object.assign(e,defaults$1),Object(t)===t?(Object.assign(e,notifTypes[t.type],t),"function"==typeof e.icon&&(e.icon=e.icon.call(this))):e.message=t,e.meta={hasMedia:Boolean(e.icon||e.avatar)},e.position){if(!1===positionList.includes(e.position))return console.error(`Notify: wrong position: ${e.position}`),!1}else e.position="bottom";if(void 0===e.timeout)e.timeout=5e3;else{const t=parseInt(e.timeout,10);if(isNaN(t)||t<0)return console.error(`Notify: wrong timeout: ${e.timeout}`),!1;e.timeout=t}0===e.timeout?e.progress=!1:!0===e.progress&&(e.meta.progressStyle={animationDuration:`${e.timeout+1e3}ms`});const i=(!0===Array.isArray(t.actions)?t.actions:[]).concat(!0!==t.ignoreDefaults&&!0===Array.isArray(defaults$1.actions)?defaults$1.actions:[]).concat(void 0!==notifTypes[t.type]&&!0===Array.isArray(notifTypes[t.type].actions)?notifTypes[t.type].actions:[]);e.closeBtn&&i.push({label:"string"==typeof e.closeBtn?e.closeBtn:this.$q.lang.label.close}),e.actions=i.map(({handler:t,noDismiss:i,...s})=>({props:{flat:!0,...s},on:{click:"function"==typeof t?()=>{t(),!0!==i&&e.meta.close()}:()=>{e.meta.close()}}})),void 0===e.multiLine&&(e.multiLine=e.actions.length>1),Object.assign(e.meta,{staticClass:"q-notification row items-stretch"+` q-notification--${!0===e.multiLine?"multi-line":"standard"}`+(void 0!==e.color?` bg-${e.color}`:"")+(void 0!==e.textColor?` text-${e.textColor}`:"")+(void 0!==e.classes?` ${e.classes}`:""),wrapperClass:"q-notification__wrapper col relative-position border-radius-inherit "+(!0===e.multiLine?"column no-wrap justify-center":"row items-center"),contentClass:"q-notification__content row items-center"+(!0===e.multiLine?"":" col")}),!1===e.group?e.group=void 0:(void 0!==e.group&&!0!==e.group||(e.group=[e.message,e.caption,e.multiline].concat(e.actions.map(t=>`${t.props.label}*${t.props.icon}`)).join("|")),e.group+="|"+e.position),0===e.actions.length?e.actions=void 0:e.meta.actionsClass="q-notification__actions row items-center "+(!0===e.multiLine?"justify-end":"col-auto")+(!0===e.meta.hasMedia?" q-notification__actions--with-media":"");const s=groups[e.group];if(void 0===s){if(e.meta.uid=uid$4++,e.meta.badge=1,-1!==["left","right","center"].indexOf(e.position))this.notifs[e.position].splice(Math.floor(this.notifs[e.position].length/2),0,e);else{const t=e.position.indexOf("top")>-1?"unshift":"push";this.notifs[e.position][t](e)}void 0!==e.group&&(groups[e.group]=e)}else{void 0!==s.meta.timer&&clearTimeout(s.meta.timer);const t=groups[e.group];if(void 0!==e.badgePosition){if(!1===badgePositions.includes(e.badgePosition))return console.error(`Notify - wrong badgePosition specified: ${e.badgePosition}`),!1}else e.badgePosition=`top-${e.position.indexOf("left")>-1?"right":"left"}`;e.meta.uid=t.meta.uid,e.meta.badge=t.meta.badge+1,e.meta.badgeStaticClass=`q-notification__badge q-notification__badge--${e.badgePosition}`+(void 0!==e.badgeColor?` bg-${e.badgeColor}`:"")+(void 0!==e.badgeTextColor?` text-${e.badgeTextColor}`:"");const i=this.notifs[e.position].indexOf(t);this.notifs[e.position][i]=groups[e.group]=e}return e.meta.close=(()=>{this.remove(e)}),this.$forceUpdate(),e.timeout>0&&(e.meta.timer=setTimeout(()=>{e.meta.close()},e.timeout+1e3)),e.meta.close},remove(t){clearTimeout(t.meta.timer);const e=this.notifs[t.position].indexOf(t);if(-1!==e){void 0!==t.group&&delete groups[t.group];const i=this.$refs[`notif_${t.meta.uid}`];if(i){const{width:t,height:e}=getComputedStyle(i);i.style.left=`${i.offsetLeft}px`,i.style.width=t,i.style.height=e}this.notifs[t.position].splice(e,1),this.$forceUpdate(),"function"==typeof t.onDismiss&&t.onDismiss()}}},render(t){return t("div",{staticClass:"q-notifications"},positionList.map(e=>t("transition-group",{key:e,staticClass:positionClass$1[e],tag:"div",props:{name:`q-notification--${e}`,mode:"out-in"}},this.notifs[e].map(e=>{let i;const s=e.meta,o={staticClass:"q-notification__message col"};if(!0===e.html)o.domProps={innerHTML:e.caption?`<div>${e.message}</div><div class="q-notification__caption">${e.caption}</div>`:e.message};else{const s=[e.message];i=e.caption?[t("div",s),t("div",{staticClass:"q-notification__caption"},[e.caption])]:s}const n=[];!0===s.hasMedia&&(e.icon?n.push(t(QIcon,{staticClass:"q-notification__icon",attrs:{role:"img"},props:{name:e.icon}})):e.avatar&&n.push(t(QAvatar,{staticClass:"q-notification__avatar col-auto"},[t("img",{attrs:{src:e.avatar,"aria-hidden":"true"}})]))),n.push(t("div",o,i));const r=[t("div",{staticClass:s.contentClass},n)];return!0===e.progress&&r.push(t("div",{key:`${s.uid}|p|${s.badge}`,staticClass:"q-notification__progress",style:s.progressStyle,class:e.progressClass})),void 0!==e.actions&&r.push(t("div",{staticClass:s.actionsClass},e.actions.map(e=>t(QBtn,{props:e.props,on:e.on})))),s.badge>1&&r.push(t("div",{key:`${s.uid}|${s.badge}`,staticClass:s.badgeStaticClass,style:e.badgeStyle,class:e.badgeClass},[s.badge])),t("div",{ref:`notif_${s.uid}`,key:s.uid,staticClass:s.staticClass,attrs:attrs$2},[t("div",{staticClass:s.wrapperClass},r)])}))))},mounted(){if(void 0!==this.$q.fullscreen&&!0===this.$q.fullscreen.isCapable){const t=t=>{const e=getBodyFullscreenElement(t,this.$q.fullscreen.activeEl);this.$el.parentElement!==e&&e.appendChild(this.$el)};this.unwatchFullscreen=this.$watch("$q.fullscreen.isActive",t),!0===this.$q.fullscreen.isActive&&t(!0)}},beforeDestroy(){void 0!==this.unwatchFullscreen&&this.unwatchFullscreen()}};var Notify={create(t){return!0===isSSR?noop:this.__vm.add(t)},setDefaults(t){t===Object(t)&&Object.assign(defaults$1,t)},registerType(t,e){!0!==isSSR&&e===Object(e)&&(notifTypes[t]=e)},install({cfg:t,$q:e}){if(!0===isSSR)return e.notify=noop,void(e.notify.setDefaults=noop);this.setDefaults(t.notify),e.notify=this.create.bind(this),e.notify.setDefaults=this.setDefaults,e.notify.registerType=this.registerType;const i=document.createElement("div");document.body.appendChild(i),this.__vm=new Vue(Notifications),this.__vm.$mount(i)}};function encode$1(t){return"[object Date]"===Object.prototype.toString.call(t)?"__q_date|"+t.toUTCString():"[object RegExp]"===Object.prototype.toString.call(t)?"__q_expr|"+t.source:"number"==typeof t?"__q_numb|"+t:"boolean"==typeof t?"__q_bool|"+(t?"1":"0"):"string"==typeof t?"__q_strn|"+t:"function"==typeof t?"__q_strn|"+t.toString():t===Object(t)?"__q_objt|"+JSON.stringify(t):t}function decode$1(t){if(t.length<9)return t;const e=t.substr(0,8),i=t.substring(9);switch(e){case"__q_date":return new Date(i);case"__q_expr":return new RegExp(i);case"__q_numb":return Number(i);case"__q_bool":return Boolean("1"===i);case"__q_strn":return""+i;case"__q_objt":return JSON.parse(i);default:return t}}function getEmptyStorage(){return{has:noop,getLength:noop,getItem:noop,getIndex:noop,getAll:noop,set:noop,remove:noop,clear:noop,isEmpty:noop}}function getStorage(t){const e=window[t+"Storage"],i=t=>{const i=e.getItem(t);return i?decode$1(i):null};return{has:t=>null!==e.getItem(t),getLength:()=>e.length,getItem:i,getIndex:t=>t<e.length?i(e.key(t)):null,getKey:t=>t<e.length?e.key(t):null,getAll:()=>{let t;const s={},o=e.length;for(let n=0;n<o;n++)s[t=e.key(n)]=i(t);return s},getAllKeys:()=>{const t=[],i=e.length;for(let s=0;s<i;s++)t.push(e.key(s));return t},set:(t,i)=>{e.setItem(t,encode$1(i))},remove:t=>{e.removeItem(t)},clear:()=>{e.clear()},isEmpty:()=>0===e.length}}var LocalStorage={install({$q:t}){const e=!0===isSSR||!1===client.has.webStorage?getEmptyStorage():getStorage("local");t.localStorage=e,Object.assign(this,e)}},SessionStorage={install({$q:t}){const e=!0===isSSR||!1===client.has.webStorage?getEmptyStorage():getStorage("session");t.sessionStorage=e,Object.assign(this,e)}},plugins=Object.freeze({__proto__:null,AddressbarColor:AddressbarColor,AppFullscreen:AppFullscreen,AppVisibility:AppVisibility,BottomSheet:BottomSheet$1,Cookies:Cookies,Dark:Dark,Dialog:Dialog,LoadingBar:LoadingBar,Loading:Loading,Meta:Meta,Notify:Notify,Platform:Platform,Screen:Screen,LocalStorage:LocalStorage,SessionStorage:SessionStorage});function fallback(t){const e=document.createElement("textarea");e.value=t,e.contentEditable=!0,e.style.position="fixed",document.body.appendChild(e),e.focus(),e.select();const i=document.execCommand("copy");return e.remove(),i}function copyToClipboard(t){return void 0!==navigator.clipboard?navigator.clipboard.writeText(t):new Promise((e,i)=>{const s=fallback(t);s?e(!0):i(s)})}function clean(t){setTimeout(()=>{window.URL.revokeObjectURL(t.href)},1e4),t.remove()}function exportFile(t,e,i){const s=new Blob([e],{type:i||"text/plain"});if(window.navigator.msSaveOrOpenBlob)return window.navigator.msSaveOrOpenBlob(s,t);const o=document.createElement("a");o.download=t,o.href=window.URL.createObjectURL(s),o.classList.add("hidden"),o.style.position="fixed",document.body.appendChild(o);try{return o.click(),clean(o),!0}catch(t){return clean(o),t}}function openWindow(t,e){let i=window.open;if(!0===Platform.is.cordova){if(void 0!==cordova&&void 0!==cordova.InAppBrowser&&void 0!==cordova.InAppBrowser.open)i=cordova.InAppBrowser.open;else if(void 0!==navigator&&void 0!==navigator.app)return navigator.app.loadUrl(t,{openExternal:!0})}else if(void 0!==Vue.prototype.$q.electron)return Vue.prototype.$q.electron.shell.openExternal(t);const s=i(t,"_blank");if(s)return Platform.is.desktop&&s.focus(),s;e&&e()}var openUrl=(t,e)=>{if(!0!==Platform.is.ios||void 0===window.SafariViewController)return openWindow(t,e);window.SafariViewController.isAvailable(i=>{i?window.SafariViewController.show({url:t},noop,e):openWindow(t,e)})},utils=Object.freeze({__proto__:null,clone:clone$1,colors:colors,copyToClipboard:copyToClipboard,date:date,debounce:debounce,dom:dom,event:event,exportFile:exportFile,extend:extend,format:format,frameDebounce:frameDebounce,noop:noop,openURL:openUrl,patterns:patterns,scroll:scroll,throttle:throttle,uid:uid$2}),index_common={...VuePlugin,install(t,e){VuePlugin.install(t,{components:components$1,directives:directives,plugins:plugins,...e})},Quasar:VuePlugin,...components$1,...directives,...plugins,...utils};module.exports=index_common;