const trailingSlashRE = /\/?$/

function equals (current, target) {
  if (Object.keys(current).length !== Object.keys(target).length) {
    return false
  }

  // route query and params are strings when read from URL
  for (const key in target) {
    if (!(key in current) || String(current[key]) !== String(target[key])) {
      return false
    }
  }
  return true
}

function includes (current, target) {
  for (const key in target) {
    if (!(key in current)) {
      return false
    }
  }
  return true
}

export function isSameRoute (current, target) {
  if (!target) {
    return false
  }
  if (current.path && target.path) {
    return (
      current.path.replace(trailingSlashRE, '') === target.path.replace(trailingSlashRE, '') &&
      current.hash === target.hash &&
      equals(current.query, target.query)
    )
  }
  if (current.name && target.name) {
    return (
      current.name === target.name &&
      current.hash === target.hash &&
      equals(current.query, target.query) &&
      equals(current.params, target.params)
    )
  }
  return false
}

export function isIncludedRoute (current, target) {
  return current.path.indexOf(target.path.replace(trailingSlashRE, '/')) === 0 &&
    (!target.hash || current.hash === target.hash) &&
    includes(current.query, target.query)
}
