const map = {
  "Quasar": "src/vue-plugin.js",
  "QAjaxBar": "src/components/ajax-bar/QAjaxBar.js",
  "QAvatar": "src/components/avatar/QAvatar.js",
  "QBadge": "src/components/badge/QBadge.js",
  "QBanner": "src/components/banner/QBanner.js",
  "QBar": "src/components/bar/QBar.js",
  "QBreadcrumbs": "src/components/breadcrumbs/QBreadcrumbs.js",
  "QBreadcrumbsEl": "src/components/breadcrumbs/QBreadcrumbsEl.js",
  "QBtn": "src/components/btn/QBtn.js",
  "QBtnDropdown": "src/components/btn/QBtnDropdown.js",
  "QBtnGroup": "src/components/btn/QBtnGroup.js",
  "QBtnToggle": "src/components/btn/QBtnToggle.js",
  "QCard": "src/components/card/QCard.js",
  "QCardActions": "src/components/card/QCardActions.js",
  "QCardSection": "src/components/card/QCardSection.js",
  "QCarousel": "src/components/carousel/QCarousel.js",
  "QCarouselControl": "src/components/carousel/QCarouselControl.js",
  "QCarouselSlide": "src/components/carousel/QCarouselSlide.js",
  "QChatMessage": "src/components/chat/QChatMessage.js",
  "QCheckbox": "src/components/checkbox/QCheckbox.js",
  "QChip": "src/components/chip/QChip.js",
  "QCircularProgress": "src/components/circular-progress/QCircularProgress.js",
  "QColor": "src/components/color/QColor.js",
  "QDate": "src/components/datetime/QDate.js",
  "QTime": "src/components/datetime/QTime.js",
  "QDialog": "src/components/dialog/QDialog.js",
  "QEditor": "src/components/editor/QEditor.js",
  "QFab": "src/components/fab/QFab.js",
  "QFabAction": "src/components/fab/QFabAction.js",
  "QField": "src/components/field/QField.js",
  "QForm": "src/components/form/QForm.js",
  "QIcon": "src/components/icon/QIcon.js",
  "QImg": "src/components/img/QImg.js",
  "QInfiniteScroll": "src/components/infinite-scroll/QInfiniteScroll.js",
  "QInnerLoading": "src/components/inner-loading/QInnerLoading.js",
  "QInput": "src/components/input/QInput.js",
  "QKnob": "src/components/knob/QKnob.js",
  "QDrawer": "src/components/layout/QDrawer.js",
  "QFooter": "src/components/layout/QFooter.js",
  "QHeader": "src/components/layout/QHeader.js",
  "QLayout": "src/components/layout/QLayout.js",
  "QPage": "src/components/layout/QPage.js",
  "QPageContainer": "src/components/layout/QPageContainer.js",
  "QPageSticky": "src/components/layout/QPageSticky.js",
  "QLinearProgress": "src/components/linear-progress/QLinearProgress.js",
  "QExpansionItem": "src/components/list/QExpansionItem.js",
  "QItem": "src/components/list/QItem.js",
  "QItemLabel": "src/components/list/QItemLabel.js",
  "QItemSection": "src/components/list/QItemSection.js",
  "QList": "src/components/list/QList.js",
  "QSlideItem": "src/components/list/QSlideItem.js",
  "QMenu": "src/components/menu/QMenu.js",
  "QNoSsr": "src/components/no-ssr/QNoSsr.js",
  "QResizeObserver": "src/components/observer/QResizeObserver.js",
  "QScrollObserver": "src/components/observer/QScrollObserver.js",
  "QOptionGroup": "src/components/option-group/QOptionGroup.js",
  "QPageScroller": "src/components/page-scroller/QPageScroller.js",
  "QPagination": "src/components/pagination/QPagination.js",
  "QParallax": "src/components/parallax/QParallax.js",
  "QPopupEdit": "src/components/popup-edit/QPopupEdit.js",
  "QPopupProxy": "src/components/popup-proxy/QPopupProxy.js",
  "QPullToRefresh": "src/components/pull-to-refresh/QPullToRefresh.js",
  "QRadio": "src/components/radio/QRadio.js",
  "QRange": "src/components/range/QRange.js",
  "QRating": "src/components/rating/QRating.js",
  "QScrollArea": "src/components/scroll-area/QScrollArea.js",
  "QSelect": "src/components/select/QSelect.js",
  "QSeparator": "src/components/separator/QSeparator.js",
  "QSlideTransition": "src/components/slide-transition/QSlideTransition.js",
  "QSlider": "src/components/slider/QSlider.js",
  "QSpace": "src/components/space/QSpace.js",
  "QSpinner": "src/components/spinner/QSpinner.js",
  "QSpinnerAudio": "src/components/spinner/QSpinnerAudio.js",
  "QSpinnerBall": "src/components/spinner/QSpinnerBall.js",
  "QSpinnerBars": "src/components/spinner/QSpinnerBars.js",
  "QSpinnerComment": "src/components/spinner/QSpinnerComment.js",
  "QSpinnerCube": "src/components/spinner/QSpinnerCube.js",
  "QSpinnerDots": "src/components/spinner/QSpinnerDots.js",
  "QSpinnerFacebook": "src/components/spinner/QSpinnerFacebook.js",
  "QSpinnerGears": "src/components/spinner/QSpinnerGears.js",
  "QSpinnerGrid": "src/components/spinner/QSpinnerGrid.js",
  "QSpinnerHearts": "src/components/spinner/QSpinnerHearts.js",
  "QSpinnerHourglass": "src/components/spinner/QSpinnerHourglass.js",
  "QSpinnerInfinity": "src/components/spinner/QSpinnerInfinity.js",
  "QSpinnerIos": "src/components/spinner/QSpinnerIos.js",
  "QSpinnerOval": "src/components/spinner/QSpinnerOval.js",
  "QSpinnerPie": "src/components/spinner/QSpinnerPie.js",
  "QSpinnerPuff": "src/components/spinner/QSpinnerPuff.js",
  "QSpinnerRadio": "src/components/spinner/QSpinnerRadio.js",
  "QSpinnerRings": "src/components/spinner/QSpinnerRings.js",
  "QSpinnerTail": "src/components/spinner/QSpinnerTail.js",
  "QSplitter": "src/components/splitter/QSplitter.js",
  "QStep": "src/components/stepper/QStep.js",
  "QStepper": "src/components/stepper/QStepper.js",
  "QStepperNavigation": "src/components/stepper/QStepperNavigation.js",
  "QTabPanel": "src/components/tab-panels/QTabPanel.js",
  "QTabPanels": "src/components/tab-panels/QTabPanels.js",
  "QMarkupTable": "src/components/table/QMarkupTable.js",
  "QTable": "src/components/table/QTable.js",
  "QTd": "src/components/table/QTd.js",
  "QTh": "src/components/table/QTh.js",
  "QTr": "src/components/table/QTr.js",
  "QRouteTab": "src/components/tabs/QRouteTab.js",
  "QTab": "src/components/tabs/QTab.js",
  "QTabs": "src/components/tabs/QTabs.js",
  "QTimeline": "src/components/timeline/QTimeline.js",
  "QTimelineEntry": "src/components/timeline/QTimelineEntry.js",
  "QToggle": "src/components/toggle/QToggle.js",
  "QToolbar": "src/components/toolbar/QToolbar.js",
  "QToolbarTitle": "src/components/toolbar/QToolbarTitle.js",
  "QTooltip": "src/components/tooltip/QTooltip.js",
  "QTree": "src/components/tree/QTree.js",
  "QUploader": "src/components/uploader/QUploader.js",
  "QUploaderAddTrigger": "src/components/uploader/QUploaderAddTrigger.js",
  "QUploaderBase": "src/components/uploader/QUploaderBase.js",
  "QVideo": "src/components/video/QVideo.js",
  "QVirtualScroll": "src/components/virtual-scroll/QVirtualScroll.js",
  "ClosePopup": "src/directives/ClosePopup.js",
  "GoBack": "src/directives/GoBack.js",
  "Intersection": "src/directives/Intersection.js",
  "Mutation": "src/directives/Mutation.js",
  "Ripple": "src/directives/Ripple.js",
  "Scroll": "src/directives/Scroll.js",
  "ScrollFire": "src/directives/ScrollFire.js",
  "TouchHold": "src/directives/TouchHold.js",
  "TouchPan": "src/directives/TouchPan.js",
  "TouchRepeat": "src/directives/TouchRepeat.js",
  "TouchSwipe": "src/directives/TouchSwipe.js",
  "AddressbarColor": "src/plugins/AddressbarColor.js",
  "AppFullscreen": "src/plugins/AppFullscreen.js",
  "AppVisibility": "src/plugins/AppVisibility.js",
  "BottomSheet": "src/plugins/BottomSheet.js",
  "Cookies": "src/plugins/Cookies.js",
  "Dark": "src/plugins/Dark.js",
  "Dialog": "src/plugins/Dialog.js",
  "Loading": "src/plugins/Loading.js",
  "LoadingBar": "src/plugins/LoadingBar.js",
  "LocalStorage": "src/plugins/LocalStorage.js",
  "Meta": "src/plugins/Meta.js",
  "Notify": "src/plugins/Notify.js",
  "Platform": "src/plugins/Platform.js",
  "Screen": "src/plugins/Screen.js",
  "SessionStorage": "src/plugins/SessionStorage.js",
  "clone": "src/utils/clone.js",
  "colors": "src/utils/colors.js",
  "datePersian": "src/utils/date-persian.js",
  "date": "src/utils/date.js",
  "debounce": "src/utils/debounce.js",
  "dom": "src/utils/dom.js",
  "event": "src/utils/event.js",
  "extend": "src/utils/extend.js",
  "format": "src/utils/format.js",
  "frameDebounce": "src/utils/frame-debounce.js",
  "globalDialog": "src/utils/global-dialog.js",
  "openURL": "src/utils/open-url.js",
  "patterns": "src/utils/patterns.js",
  "positionEngine": "src/utils/position-engine.js",
  "router": "src/utils/router.js",
  "scroll": "src/utils/scroll.js",
  "selection": "src/utils/selection.js",
  "slot": "src/utils/slot.js",
  "throttle": "src/utils/throttle.js",
  "touch": "src/utils/touch.js",
  "uid": "src/utils/uid.js",
  "vm": "src/utils/vm.js"
}

module.exports = function (importName) {
  if (typeof map[importName] === 'undefined') {
    throw new Error('Unknown import from Quasar: ' + importName)
  }
  return 'quasar/' + map[importName]
}
