/*!
 * Quasar Framework v2.14.0
 * (c) 2015-present Razvan Stoenescu
 * Released under the MIT License.
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var vue=require("vue");function injectProp(e,t,o,n){return Object.defineProperty(e,t,{get:o,set:n,enumerable:!0}),e}function injectMultipleProps(e,t){for(const o in t)injectProp(e,o,t[o]);return e}const isRuntimeSsrPreHydration={value:!0};function getMatch(e,t){const o=/(edg|edge|edga|edgios)\/([\w.]+)/.exec(e)||/(opr)[\/]([\w.]+)/.exec(e)||/(vivaldi)[\/]([\w.]+)/.exec(e)||/(chrome|crios)[\/]([\w.]+)/.exec(e)||/(version)(applewebkit)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(e)||/(webkit)[\/]([\w.]+).*(version)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(e)||/(firefox|fxios)[\/]([\w.]+)/.exec(e)||/(webkit)[\/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[\/]([\w.]+)/.exec(e)||[];return{browser:o[5]||o[3]||o[1]||"",version:o[2]||o[4]||"0",versionNumber:o[4]||o[2]||"0",platform:t[0]||""}}function getPlatformMatch(e){return/(ipad)/.exec(e)||/(ipod)/.exec(e)||/(windows phone)/.exec(e)||/(iphone)/.exec(e)||/(kindle)/.exec(e)||/(silk)/.exec(e)||/(android)/.exec(e)||/(win)/.exec(e)||/(mac)/.exec(e)||/(linux)/.exec(e)||/(cros)/.exec(e)||/(playbook)/.exec(e)||/(bb)/.exec(e)||/(blackberry)/.exec(e)||[]}function getPlatform(e){const t=e.toLowerCase(),o=getPlatformMatch(t),n=getMatch(t,o),a={};n.browser&&(a[n.browser]=!0,a.version=n.version,a.versionNumber=parseInt(n.versionNumber,10)),n.platform&&(a[n.platform]=!0);const l=a.android||a.ios||a.bb||a.blackberry||a.ipad||a.iphone||a.ipod||a.kindle||a.playbook||a.silk||a["windows phone"];return!0===l||t.indexOf("mobile")>-1?(a.mobile=!0,a.edga||a.edgios?(a.edge=!0,n.browser="edge"):a.crios?(a.chrome=!0,n.browser="chrome"):a.fxios&&(a.firefox=!0,n.browser="firefox")):a.desktop=!0,(a.ipod||a.ipad||a.iphone)&&(a.ios=!0),a["windows phone"]&&(a.winphone=!0,delete a["windows phone"]),(a.chrome||a.opr||a.safari||a.vivaldi||!0===a.mobile&&!0!==a.ios&&!0!==l)&&(a.webkit=!0),a.edg&&(n.browser="edgechromium",a.edgeChromium=!0),(a.safari&&a.blackberry||a.bb)&&(n.browser="blackberry",a.blackberry=!0),a.safari&&a.playbook&&(n.browser="playbook",a.playbook=!0),a.opr&&(n.browser="opera",a.opera=!0),a.safari&&a.android&&(n.browser="android",a.android=!0),a.safari&&a.kindle&&(n.browser="kindle",a.kindle=!0),a.safari&&a.silk&&(n.browser="silk",a.silk=!0),a.vivaldi&&(n.browser="vivaldi",a.vivaldi=!0),a.name=n.browser,a.platform=n.platform,a}const ssrClient={has:{touch:!1,webStorage:!1},within:{iframe:!1}},client=ssrClient,Platform={install(e){const{$q:t}=e;t.platform=this.parseSSR(e.ssrContext)},parseSSR:e=>{const t=e.req.headers["user-agent"]||e.req.headers["User-Agent"]||"";return{...client,userAgent:t,is:getPlatform(t)}}};var defineReactivePlugin=(e,t)=>{return Object.assign(t,e),t};const listenOpts={hasPassive:!1,passiveCapture:!0,notPassiveCapture:!0};try{const e=Object.defineProperty({},"passive",{get(){Object.assign(listenOpts,{hasPassive:!0,passive:{passive:!0},notPassive:{passive:!1},passiveCapture:{passive:!0,capture:!0},notPassiveCapture:{passive:!1,capture:!0}})}});window.addEventListener("qtest",null,e),window.removeEventListener("qtest",null,e)}catch(e){}function noop(){}function leftClick(e){return 0===e.button}function middleClick(e){return 1===e.button}function rightClick(e){return 2===e.button}function position(e){return e.touches&&e.touches[0]?e=e.touches[0]:e.changedTouches&&e.changedTouches[0]?e=e.changedTouches[0]:e.targetTouches&&e.targetTouches[0]&&(e=e.targetTouches[0]),{top:e.clientY,left:e.clientX}}function getEventPath(e){if(e.path)return e.path;if(e.composedPath)return e.composedPath();const t=[];let o=e.target;while(o){if(t.push(o),"HTML"===o.tagName)return t.push(document),t.push(window),t;o=o.parentElement}}const LINE_HEIGHT=40,PAGE_HEIGHT=800;function getMouseWheelDistance(e){let t=e.deltaX,o=e.deltaY;if((t||o)&&e.deltaMode){const n=1===e.deltaMode?LINE_HEIGHT:PAGE_HEIGHT;t*=n,o*=n}return e.shiftKey&&!t&&([o,t]=[t,o]),{x:t,y:o}}function stop(e){e.stopPropagation()}function prevent(e){!1!==e.cancelable&&e.preventDefault()}function stopAndPrevent(e){!1!==e.cancelable&&e.preventDefault(),e.stopPropagation()}function preventDraggable(e,t){if(void 0===e||!0===t&&!0===e.__dragPrevented)return;const o=!0===t?e=>{e.__dragPrevented=!0,e.addEventListener("dragstart",prevent,listenOpts.notPassiveCapture)}:e=>{delete e.__dragPrevented,e.removeEventListener("dragstart",prevent,listenOpts.notPassiveCapture)};e.querySelectorAll("a, img").forEach(o)}function addEvt(e,t,o){const n=`__q_${t}_evt`;e[n]=void 0!==e[n]?e[n].concat(o):o,o.forEach(t=>{t[0].addEventListener(t[1],e[t[2]],listenOpts[t[3]])})}function cleanEvt(e,t){const o=`__q_${t}_evt`;void 0!==e[o]&&(e[o].forEach(t=>{t[0].removeEventListener(t[1],e[t[2]],listenOpts[t[3]])}),e[o]=void 0)}var event={listenOpts:listenOpts,leftClick:leftClick,middleClick:middleClick,rightClick:rightClick,position:position,getEventPath:getEventPath,getMouseWheelDistance:getMouseWheelDistance,stop:stop,prevent:prevent,stopAndPrevent:stopAndPrevent,preventDraggable:preventDraggable};function debounce(e,t=250,o){let n=null;function a(){const a=arguments,l=()=>{n=null,!0!==o&&e.apply(this,a)};null!==n?clearTimeout(n):!0===o&&e.apply(this,a),n=setTimeout(l,t)}return a.cancel=(()=>{null!==n&&clearTimeout(n)}),a}var Screen=defineReactivePlugin({width:0,height:0,name:"xs",sizes:{sm:600,md:1024,lg:1440,xl:1920},lt:{sm:!0,md:!0,lg:!0,xl:!0},gt:{xs:!1,sm:!1,md:!1,lg:!1},xs:!0,sm:!1,md:!1,lg:!1,xl:!1},{setSizes:noop,setDebounce:noop,install({$q:e,onSSRHydrated:t}){e.screen=this}});const Plugin$9=defineReactivePlugin({isActive:!1,mode:!1},{__media:void 0,set(e){},toggle(){},install({$q:e,onSSRHydrated:t,ssrContext:o}){const{dark:n}=e.config;return this.isActive=!0===n,e.dark={isActive:!1,mode:!1,set:t=>{o._meta.bodyClasses=o._meta.bodyClasses.replace(" body--light","").replace(" body--dark","")+` body--${!0===t?"dark":"light"}`,e.dark.isActive=!0===t,e.dark.mode=t},toggle:()=>{e.dark.set(!1===e.dark.isActive)}},void e.dark.set(n)}});var History={__history:[],add:noop,remove:noop,install({$q:e}){}},defaultLang={isoName:"en-US",nativeName:"English (US)",label:{clear:"Clear",ok:"OK",cancel:"Cancel",close:"Close",set:"Set",select:"Select",reset:"Reset",remove:"Remove",update:"Update",create:"Create",search:"Search",filter:"Filter",refresh:"Refresh",expand:e=>e?`Expand "${e}"`:"Expand",collapse:e=>e?`Collapse "${e}"`:"Collapse"},date:{days:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),daysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),firstDayOfWeek:0,format24h:!1,pluralDay:"days"},table:{noData:"No data available",noResults:"No matching records found",loading:"Loading...",selectedRecords:e=>1===e?"1 record selected.":(0===e?"No":e)+" records selected.",recordsPerPage:"Records per page:",allRows:"All",pagination:(e,t,o)=>e+"-"+t+" of "+o,columns:"Columns"},editor:{url:"URL",bold:"Bold",italic:"Italic",strikethrough:"Strikethrough",underline:"Underline",unorderedList:"Unordered List",orderedList:"Ordered List",subscript:"Subscript",superscript:"Superscript",hyperlink:"Hyperlink",toggleFullscreen:"Toggle Fullscreen",quote:"Quote",left:"Left align",center:"Center align",right:"Right align",justify:"Justify align",print:"Print",outdent:"Decrease indentation",indent:"Increase indentation",removeFormat:"Remove formatting",formatting:"Formatting",fontSize:"Font Size",align:"Align",hr:"Insert Horizontal Rule",undo:"Undo",redo:"Redo",heading1:"Heading 1",heading2:"Heading 2",heading3:"Heading 3",heading4:"Heading 4",heading5:"Heading 5",heading6:"Heading 6",paragraph:"Paragraph",code:"Code",size1:"Very small",size2:"A bit small",size3:"Normal",size4:"Medium-large",size5:"Big",size6:"Very big",size7:"Maximum",defaultFont:"Default Font",viewSource:"View Source"},tree:{noNodes:"No nodes available",noResults:"No matching nodes found"}};function getLocale(){}const Plugin$8=defineReactivePlugin({__langPack:{}},{getLocale:getLocale,set(e=defaultLang,t){const o={...e,rtl:!0===e.rtl,getLocale:getLocale};if(void 0!==t){if(o.set=t.$q.lang.set,void 0===t.$q.config.lang||!0!==t.$q.config.lang.noHtmlAttrs){const e=!0===o.rtl?"rtl":"ltr",n=`lang=${o.isoName} dir=${e}`;t._meta.htmlAttrs=void 0!==t.__qPrevLang?t._meta.htmlAttrs.replace(t.__qPrevLang,n):n,t.__qPrevLang=n}t.$q.lang=o}else console.error("SSR ERROR: second param required: Quasar.lang.set(lang, ssrContext)")},install({$q:e,lang:t,ssrContext:o}){{const n=t||defaultLang;e.lang={},e.lang.set=(e=>{this.set(e,o)}),e.lang.set(n),this.isoName!==n.isoName&&(this.isoName=n.isoName,this.nativeName=n.nativeName,this.props=n)}}});function setCssVar(e,t,o=document.body){if("string"!==typeof e)throw new TypeError("Expected a string as propName");if("string"!==typeof t)throw new TypeError("Expected a string as value");if(!(o instanceof Element))throw new TypeError("Expected a DOM element");o.style.setProperty(`--q-${e}`,t)}function shouldIgnoreKey(e){return e!==Object(e)||!0===e.isComposing||!0===e.qKeyEvent}function isKeyCode(e,t){return!0!==shouldIgnoreKey(e)&&[].concat(t).includes(e.keyCode)}function getMobilePlatform(e){return!0===e.ios?"ios":!0===e.android?"android":void 0}function getBodyClasses({is:e,has:t,within:o},n){const a=[!0===e.desktop?"desktop":"mobile",`${!1===t.touch?"no-":""}touch`];if(!0===e.mobile){const t=getMobilePlatform(e);void 0!==t&&a.push("platform-"+t)}if(!0===e.nativeMobile){const t=e.nativeMobileWrapper;a.push(t),a.push("native-mobile"),!0!==e.ios||void 0!==n[t]&&!1===n[t].iosStatusBarPadding||a.push("q-ios-padding")}else!0===e.electron?a.push("electron"):!0===e.bex&&a.push("bex");return!0===o.iframe&&a.push("within-iframe"),a}var Body={install(e){{const{$q:t,ssrContext:o}=e,n=getBodyClasses(t.platform,t.config);void 0!==t.config.screen&&!0===t.config.screen.bodyClass&&n.push("screen--xs"),o._meta.bodyClasses+=n.join(" ");const a=t.config.brand;if(void 0!==a){const e=Object.keys(a).map(e=>`--q-${e}:${a[e]};`).join("");o._meta.endingHeadTags+=`<style>:root{${e}}</style>`}return}}},materialIcons={name:"material-icons",type:{positive:"check_circle",negative:"warning",info:"info",warning:"priority_high"},arrow:{up:"arrow_upward",right:"arrow_forward",down:"arrow_downward",left:"arrow_back",dropdown:"arrow_drop_down"},chevron:{left:"chevron_left",right:"chevron_right"},colorPicker:{spectrum:"gradient",tune:"tune",palette:"style"},pullToRefresh:{icon:"refresh"},carousel:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down",navigationIcon:"lens"},chip:{remove:"cancel",selected:"check"},datetime:{arrowLeft:"chevron_left",arrowRight:"chevron_right",now:"access_time",today:"today"},editor:{bold:"format_bold",italic:"format_italic",strikethrough:"strikethrough_s",underline:"format_underlined",unorderedList:"format_list_bulleted",orderedList:"format_list_numbered",subscript:"vertical_align_bottom",superscript:"vertical_align_top",hyperlink:"link",toggleFullscreen:"fullscreen",quote:"format_quote",left:"format_align_left",center:"format_align_center",right:"format_align_right",justify:"format_align_justify",print:"print",outdent:"format_indent_decrease",indent:"format_indent_increase",removeFormat:"format_clear",formatting:"text_format",fontSize:"format_size",align:"format_align_left",hr:"remove",undo:"undo",redo:"redo",heading:"format_size",code:"code",size:"format_size",font:"font_download",viewSource:"code"},expansionItem:{icon:"keyboard_arrow_down",denseIcon:"arrow_drop_down"},fab:{icon:"add",activeIcon:"close"},field:{clear:"cancel",error:"error"},pagination:{first:"first_page",prev:"keyboard_arrow_left",next:"keyboard_arrow_right",last:"last_page"},rating:{icon:"grade"},stepper:{done:"check",active:"edit",error:"warning"},tabs:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down"},table:{arrowUp:"arrow_upward",warning:"warning",firstPage:"first_page",prevPage:"chevron_left",nextPage:"chevron_right",lastPage:"last_page"},tree:{icon:"play_arrow"},uploader:{done:"done",clear:"clear",add:"add_box",upload:"cloud_upload",removeQueue:"clear_all",removeUploaded:"done_all"}};const Plugin$7=defineReactivePlugin({iconMapFn:null,__icons:{}},{set(e,t){const o={...e,rtl:!0===e.rtl};void 0!==t?(o.set=t.$q.iconSet.set,Object.assign(t.$q.iconSet,o)):console.error("SSR ERROR: second param required: Quasar.iconSet.set(iconSet, ssrContext)")},install({$q:e,iconSet:t,ssrContext:o}){{const n=t||materialIcons;e.iconMapFn=o.$q.config.iconMapFn||this.iconMapFn||null,e.iconSet={},e.iconSet.set=(e=>{this.set(e,o)}),e.iconSet.set(n)}}}),quasarKey="_q_",timelineKey="_q_t_",stepperKey="_q_s_",layoutKey="_q_l_",pageContainerKey="_q_pc_",fabKey="_q_f_",formKey="_q_fo_",tabsKey="_q_tabs_",uploaderKey="_q_u_",emptyRenderFn=()=>{};function isDeepEqual(e,t){if(e===t)return!0;if(null!==e&&null!==t&&"object"===typeof e&&"object"===typeof t){if(e.constructor!==t.constructor)return!1;let o,n;if(e.constructor===Array){if(o=e.length,o!==t.length)return!1;for(n=o;0!==n--;)if(!0!==isDeepEqual(e[n],t[n]))return!1;return!0}if(e.constructor===Map){if(e.size!==t.size)return!1;let o=e.entries();n=o.next();while(!0!==n.done){if(!0!==t.has(n.value[0]))return!1;n=o.next()}o=e.entries(),n=o.next();while(!0!==n.done){if(!0!==isDeepEqual(n.value[1],t.get(n.value[0])))return!1;n=o.next()}return!0}if(e.constructor===Set){if(e.size!==t.size)return!1;const o=e.entries();n=o.next();while(!0!==n.done){if(!0!==t.has(n.value[0]))return!1;n=o.next()}return!0}if(null!=e.buffer&&e.buffer.constructor===ArrayBuffer){if(o=e.length,o!==t.length)return!1;for(n=o;0!==n--;)if(e[n]!==t[n])return!1;return!0}if(e.constructor===RegExp)return e.source===t.source&&e.flags===t.flags;if(e.valueOf!==Object.prototype.valueOf)return e.valueOf()===t.valueOf();if(e.toString!==Object.prototype.toString)return e.toString()===t.toString();const a=Object.keys(e).filter(t=>void 0!==e[t]);if(o=a.length,o!==Object.keys(t).filter(e=>void 0!==t[e]).length)return!1;for(n=o;0!==n--;){const o=a[n];if(!0!==isDeepEqual(e[o],t[o]))return!1}return!0}return e!==e&&t!==t}function isObject(e){return null!==e&&"object"===typeof e&&!0!==Array.isArray(e)}function isDate(e){return"[object Date]"===Object.prototype.toString.call(e)}function isRegexp(e){return"[object RegExp]"===Object.prototype.toString.call(e)}function isNumber(e){return"number"===typeof e&&isFinite(e)}var is={deepEqual:isDeepEqual,object:isObject,date:isDate,regexp:isRegexp,number:isNumber};const autoInstalledPlugins=[Platform,Body,Plugin$9,Screen,History,Plugin$8,Plugin$7];function installPlugins(e,t){t.forEach(t=>{t.install(e),t.__installed=!0})}function prepareApp(e,t,o){e.config.globalProperties.$q=o.$q,e.provide(quasarKey,o.$q),installPlugins(o,autoInstalledPlugins),void 0!==t.components&&Object.values(t.components).forEach(t=>{!0===isObject(t)&&void 0!==t.name&&e.component(t.name,t)}),void 0!==t.directives&&Object.values(t.directives).forEach(t=>{!0===isObject(t)&&void 0!==t.name&&e.directive(t.name,t)}),void 0!==t.plugins&&installPlugins(o,Object.values(t.plugins).filter(e=>"function"===typeof e.install&&!1===autoInstalledPlugins.includes(e))),!0===isRuntimeSsrPreHydration.value&&(o.$q.onSSRHydrated=(()=>{o.onSSRHydrated.forEach(e=>{e()}),o.$q.onSSRHydrated=(()=>{})}))}var installQuasar=function(e,t={},o){const n={version:"2.14.0",config:t.config||{}};Object.assign(o,{$q:n,_meta:{htmlAttrs:"",headTags:"",endingHeadTags:"",bodyClasses:"",bodyAttrs:"data-server-rendered",bodyTags:""}}),void 0===o._modules&&(o._modules=[]),void 0===o.onRendered&&(o.onRendered=(()=>{})),e.config.globalProperties.ssrContext=o,prepareApp(e,t,{parentApp:e,$q:n,lang:t.lang,iconSet:t.iconSet,ssrContext:o})};const createComponent=e=>vue.markRaw(vue.defineComponent(e)),createDirective=e=>vue.markRaw(e),units=["B","KB","MB","GB","TB","PB"];function humanStorageSize(e){let t=0;while(parseInt(e,10)>=1024&&t<units.length-1)e/=1024,++t;return`${e.toFixed(1)}${units[t]}`}function capitalize(e){return e.charAt(0).toUpperCase()+e.slice(1)}function between(e,t,o){return o<=t?t:Math.min(o,Math.max(t,e))}function normalizeToInterval(e,t,o){if(o<=t)return t;const n=o-t+1;let a=t+(e-t)%n;return a<t&&(a=n+a),0===a?0:a}function pad(e,t=2,o="0"){if(void 0===e||null===e)return e;const n=""+e;return n.length>=t?n:new Array(t-n.length+1).join(o)+n}var format={humanStorageSize:humanStorageSize,capitalize:capitalize,between:between,normalizeToInterval:normalizeToInterval,pad:pad};const xhr=null,open=null,positionValues=["top","right","bottom","left"];let stack=[],highjackCount=0;function translate({p:e,pos:t,active:o,horiz:n,reverse:a,dir:l}){let r=1,i=1;return!0===n?(!0===a&&(r=-1),"bottom"===t&&(i=-1),{transform:`translate3d(${r*(e-100)}%,${o?0:-200*i}%,0)`}):(!0===a&&(i=-1),"right"===t&&(r=-1),{transform:`translate3d(${o?0:l*r*-200}%,${i*(e-100)}%,0)`})}function inc(e,t){return"number"!==typeof t&&(t=e<25?3*Math.random()+3:e<65?3*Math.random():e<85?2*Math.random():e<99?.6:0),between(e+t,0,100)}function highjackAjax(e){highjackCount++,stack.push(e),highjackCount>1||(xhr.prototype.open=function(e,t){const o=[],n=()=>{stack.forEach(e=>{null!==e.hijackFilter.value&&!0!==e.hijackFilter.value(t)||(e.start(),o.push(e.stop))})},a=()=>{o.forEach(e=>{e()})};this.addEventListener("loadstart",n,{once:!0}),this.addEventListener("loadend",a,{once:!0}),open.apply(this,arguments)})}function restoreAjax(e){stack=stack.filter(t=>t.start!==e),highjackCount=Math.max(0,highjackCount-1),0===highjackCount&&(xhr.prototype.open=open)}var QAjaxBar=createComponent({name:"QAjaxBar",props:{position:{type:String,default:"top",validator:e=>positionValues.includes(e)},size:{type:String,default:"2px"},color:String,skipHijack:Boolean,reverse:Boolean,hijackFilter:Function},emits:["start","stop"],setup(e,{emit:t}){const{proxy:o}=vue.getCurrentInstance(),n=vue.ref(0),a=vue.ref(!1),l=vue.ref(!0);let r,i=0,u=null;const s=vue.computed(()=>`q-loading-bar q-loading-bar--${e.position}`+(void 0!==e.color?` bg-${e.color}`:"")+(!0===l.value?"":" no-transition")),c=vue.computed(()=>"top"===e.position||"bottom"===e.position),d=vue.computed(()=>!0===c.value?"height":"width"),v=vue.computed(()=>{const t=a.value,l=translate({p:n.value,pos:e.position,active:t,horiz:c.value,reverse:!0===o.$q.lang.rtl&&["top","bottom"].includes(e.position)?!1===e.reverse:e.reverse,dir:!0===o.$q.lang.rtl?-1:1});return l[d.value]=e.size,l.opacity=t?1:0,l}),p=vue.computed(()=>!0===a.value?{role:"progressbar","aria-valuemin":0,"aria-valuemax":100,"aria-valuenow":n.value}:{"aria-hidden":"true"});function m(e=300){const o=r;return r=Math.max(0,e)||0,i++,i>1?(0===o&&e>0?g():null!==u&&o>0&&e<=0&&(clearTimeout(u),u=null),i):(null!==u&&clearTimeout(u),t("start"),n.value=0,u=setTimeout(()=>{u=null,l.value=!0,e>0&&g()},!0===a.value?500:1),!0!==a.value&&(a.value=!0,l.value=!1),i)}function f(e){return i>0&&(n.value=inc(n.value,e)),i}function h(){if(i=Math.max(0,i-1),i>0)return i;null!==u&&(clearTimeout(u),u=null),t("stop");const e=()=>{l.value=!0,n.value=100,u=setTimeout(()=>{u=null,a.value=!1},1e3)};return 0===n.value?u=setTimeout(e,1):e(),i}function g(){n.value<100&&(u=setTimeout(()=>{u=null,f(),g()},r))}let b;return vue.onMounted(()=>{!0!==e.skipHijack&&(b=!0,highjackAjax({start:m,stop:h,hijackFilter:vue.computed(()=>e.hijackFilter||null)}))}),vue.onBeforeUnmount(()=>{null!==u&&clearTimeout(u),!0===b&&restoreAjax(m)}),Object.assign(o,{start:m,stop:h,increment:f}),()=>vue.h("div",{class:s.value,style:v.value,...p.value})}});const useSizeDefaults={xs:18,sm:24,md:32,lg:38,xl:46},useSizeProps={size:String};function useSize(e,t=useSizeDefaults){return vue.computed(()=>void 0!==e.size?{fontSize:e.size in t?`${t[e.size]}px`:e.size}:null)}function hSlot(e,t){return void 0!==e&&e()||t}function hUniqueSlot(e,t){if(void 0!==e){const t=e();if(void 0!==t&&null!==t)return t.slice()}return t}function hMergeSlot(e,t){return void 0!==e?t.concat(e()):t}function hMergeSlotSafely(e,t){return void 0===e?t:void 0!==t?t.concat(e()):e()}function hDir(e,t,o,n,a,l){t.key=n+a;const r=vue.h(e,t,o);return!0===a?vue.withDirectives(r,l()):r}const defaultViewBox="0 0 24 24",sameFn=e=>e,ionFn=e=>`ionicons ${e}`,libMap={"mdi-":e=>`mdi ${e}`,"icon-":sameFn,"bt-":e=>`bt ${e}`,"eva-":e=>`eva ${e}`,"ion-md":ionFn,"ion-ios":ionFn,"ion-logo":ionFn,"iconfont ":sameFn,"ti-":e=>`themify-icon ${e}`,"bi-":e=>`bootstrap-icons ${e}`},matMap={o_:"-outlined",r_:"-round",s_:"-sharp"},symMap={sym_o_:"-outlined",sym_r_:"-rounded",sym_s_:"-sharp"},libRE=new RegExp("^("+Object.keys(libMap).join("|")+")"),matRE=new RegExp("^("+Object.keys(matMap).join("|")+")"),symRE=new RegExp("^("+Object.keys(symMap).join("|")+")"),mRE=/^[Mm]\s?[-+]?\.?\d/,imgRE=/^img:/,svgUseRE=/^svguse:/,ionRE=/^ion-/,faRE=/^(fa-(sharp|solid|regular|light|brands|duotone|thin)|[lf]a[srlbdk]?) /;var QIcon=createComponent({name:"QIcon",props:{...useSizeProps,tag:{type:String,default:"i"},name:String,color:String,left:Boolean,right:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useSize(e),a=vue.computed(()=>"q-icon"+(!0===e.left?" on-left":"")+(!0===e.right?" on-right":"")+(void 0!==e.color?` text-${e.color}`:"")),l=vue.computed(()=>{let t,n=e.name;if("none"===n||!n)return{none:!0};if(null!==o.iconMapFn){const e=o.iconMapFn(n);if(void 0!==e){if(void 0===e.icon)return{cls:e.cls,content:void 0!==e.content?e.content:" "};if(n=e.icon,"none"===n||!n)return{none:!0}}}if(!0===mRE.test(n)){const[e,t=defaultViewBox]=n.split("|");return{svg:!0,viewBox:t,nodes:e.split("&&").map(e=>{const[t,o,n]=e.split("@@");return vue.h("path",{style:o,d:t,transform:n})})}}if(!0===imgRE.test(n))return{img:!0,src:n.substring(4)};if(!0===svgUseRE.test(n)){const[e,t=defaultViewBox]=n.split("|");return{svguse:!0,src:e.substring(7),viewBox:t}}let a=" ";const l=n.match(libRE);if(null!==l)t=libMap[l[1]](n);else if(!0===faRE.test(n))t=n;else if(!0===ionRE.test(n))t=`ionicons ion-${!0===o.platform.is.ios?"ios":"md"}${n.substring(3)}`;else if(!0===symRE.test(n)){t="notranslate material-symbols";const e=n.match(symRE);null!==e&&(n=n.substring(6),t+=symMap[e[1]]),a=n}else{t="notranslate material-icons";const e=n.match(matRE);null!==e&&(n=n.substring(2),t+=matMap[e[1]]),a=n}return{cls:t,content:a}});return()=>{const o={class:a.value,style:n.value,"aria-hidden":"true",role:"presentation"};return!0===l.value.none?vue.h(e.tag,o,hSlot(t.default)):!0===l.value.img?vue.h("span",o,hMergeSlot(t.default,[vue.h("img",{src:l.value.src})])):!0===l.value.svg?vue.h("span",o,hMergeSlot(t.default,[vue.h("svg",{viewBox:l.value.viewBox||"0 0 24 24"},l.value.nodes)])):!0===l.value.svguse?vue.h("span",o,hMergeSlot(t.default,[vue.h("svg",{viewBox:l.value.viewBox},[vue.h("use",{"xlink:href":l.value.src})])])):(void 0!==l.value.cls&&(o.class+=" "+l.value.cls),vue.h(e.tag,o,hMergeSlot(t.default,[l.value.content])))}}}),QAvatar=createComponent({name:"QAvatar",props:{...useSizeProps,fontSize:String,color:String,textColor:String,icon:String,square:Boolean,rounded:Boolean},setup(e,{slots:t}){const o=useSize(e),n=vue.computed(()=>"q-avatar"+(e.color?` bg-${e.color}`:"")+(e.textColor?` text-${e.textColor} q-chip--colored`:"")+(!0===e.square?" q-avatar--square":!0===e.rounded?" rounded-borders":"")),a=vue.computed(()=>e.fontSize?{fontSize:e.fontSize}:null);return()=>{const l=void 0!==e.icon?[vue.h(QIcon,{name:e.icon})]:void 0;return vue.h("div",{class:n.value,style:o.value},[vue.h("div",{class:"q-avatar__content row flex-center overflow-hidden",style:a.value},hMergeSlotSafely(t.default,l))])}}});const alignValues$3=["top","middle","bottom"];var QBadge=createComponent({name:"QBadge",props:{color:String,textColor:String,floating:Boolean,transparent:Boolean,multiLine:Boolean,outline:Boolean,rounded:Boolean,label:[Number,String],align:{type:String,validator:e=>alignValues$3.includes(e)}},setup(e,{slots:t}){const o=vue.computed(()=>{return void 0!==e.align?{verticalAlign:e.align}:null}),n=vue.computed(()=>{const t=!0===e.outline&&e.color||e.textColor;return"q-badge flex inline items-center no-wrap"+` q-badge--${!0===e.multiLine?"multi":"single"}-line`+(!0===e.outline?" q-badge--outline":void 0!==e.color?` bg-${e.color}`:"")+(void 0!==t?` text-${t}`:"")+(!0===e.floating?" q-badge--floating":"")+(!0===e.rounded?" q-badge--rounded":"")+(!0===e.transparent?" q-badge--transparent":"")});return()=>vue.h("div",{class:n.value,style:o.value,role:"status","aria-label":e.label},hMergeSlot(t.default,void 0!==e.label?[e.label]:[]))}});const useDarkProps={dark:{type:Boolean,default:null}};function useDark(e,t){return vue.computed(()=>null===e.dark?t.dark.isActive:e.dark)}var QBanner=createComponent({name:"QBanner",props:{...useDarkProps,inlineActions:Boolean,dense:Boolean,rounded:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useDark(e,o),a=vue.computed(()=>"q-banner row items-center"+(!0===e.dense?" q-banner--dense":"")+(!0===n.value?" q-banner--dark q-dark":"")+(!0===e.rounded?" rounded-borders":"")),l=vue.computed(()=>"q-banner__actions row items-center justify-end"+` col-${!0===e.inlineActions?"auto":"all"}`);return()=>{const o=[vue.h("div",{class:"q-banner__avatar col-auto row items-center self-start"},hSlot(t.avatar)),vue.h("div",{class:"q-banner__content col text-body2"},hSlot(t.default))],n=hSlot(t.action);return void 0!==n&&o.push(vue.h("div",{class:l.value},n)),vue.h("div",{class:a.value+(!1===e.inlineActions&&void 0!==n?" q-banner--top-padding":""),role:"alert"},o)}}}),QBar=createComponent({name:"QBar",props:{...useDarkProps,dense:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useDark(e,o),a=vue.computed(()=>"q-bar row no-wrap items-center"+` q-bar--${!0===e.dense?"dense":"standard"} `+` q-bar--${!0===n.value?"dark":"light"}`);return()=>vue.h("div",{class:a.value,role:"toolbar"},hSlot(t.default))}});const alignMap={left:"start",center:"center",right:"end",between:"between",around:"around",evenly:"evenly",stretch:"stretch"},alignValues$2=Object.keys(alignMap),useAlignProps={align:{type:String,validator:e=>alignValues$2.includes(e)}};function useAlign(e){return vue.computed(()=>{const t=void 0===e.align?!0===e.vertical?"stretch":"left":e.align;return`${!0===e.vertical?"items":"justify"}-${alignMap[t]}`})}function getParentProxy(e){if(Object(e.$parent)===e.$parent)return e.$parent;let{parent:t}=e.$;while(Object(t)===t){if(Object(t.proxy)===t.proxy)return t.proxy;t=t.parent}}function fillNormalizedVNodes(e,t){"symbol"===typeof t.type?!0===Array.isArray(t.children)&&t.children.forEach(t=>{fillNormalizedVNodes(e,t)}):e.add(t)}function getNormalizedVNodes(e){const t=new Set;return e.forEach(e=>{fillNormalizedVNodes(t,e)}),Array.from(t)}function vmHasRouter(e){return void 0!==e.appContext.config.globalProperties.$router}function vmIsDestroyed(e){return!0===e.isUnmounted||!0===e.isDeactivated}const disabledValues=["",!0];var QBreadcrumbs=createComponent({name:"QBreadcrumbs",props:{...useAlignProps,separator:{type:String,default:"/"},separatorColor:String,activeColor:{type:String,default:"primary"},gutter:{type:String,validator:e=>["none","xs","sm","md","lg","xl"].includes(e),default:"sm"}},setup(e,{slots:t}){const o=useAlign(e),n=vue.computed(()=>`flex items-center ${o.value}${"none"===e.gutter?"":` q-gutter-${e.gutter}`}`),a=vue.computed(()=>e.separatorColor?` text-${e.separatorColor}`:""),l=vue.computed(()=>` text-${e.activeColor}`);return()=>{const o=getNormalizedVNodes(hSlot(t.default));if(0===o.length)return;let r=1;const i=[],u=o.filter(e=>void 0!==e.type&&"QBreadcrumbsEl"===e.type.name).length,s=void 0!==t.separator?t.separator:()=>e.separator;return o.forEach(e=>{if(void 0!==e.type&&"QBreadcrumbsEl"===e.type.name){const t=r<u,o=null!==e.props&&disabledValues.includes(e.props.disable),n=(!0===t?"":" q-breadcrumbs--last")+(!0!==o&&!0===t?l.value:"");r++,i.push(vue.h("div",{class:`flex items-center${n}`},[e])),!0===t&&i.push(vue.h("div",{class:"q-breadcrumbs__separator"+a.value},s()))}else i.push(e)}),vue.h("div",{class:"q-breadcrumbs"},[vue.h("div",{class:n.value},i)])}}});function getOriginalPath(e){return e?e.aliasOf?e.aliasOf.path:e.path:""}function isSameRouteRecord(e,t){return(e.aliasOf||e)===(t.aliasOf||t)}function includesParams(e,t){for(const o in t){const n=t[o],a=e[o];if("string"===typeof n){if(n!==a)return!1}else if(!1===Array.isArray(a)||a.length!==n.length||n.some((e,t)=>e!==a[t]))return!1}return!0}function isEquivalentArray(e,t){return!0===Array.isArray(t)?e.length===t.length&&e.every((e,o)=>e===t[o]):1===e.length&&e[0]===t}function isSameRouteLocationParamsValue(e,t){return!0===Array.isArray(e)?isEquivalentArray(e,t):!0===Array.isArray(t)?isEquivalentArray(t,e):e===t}function isSameRouteLocationParams(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const o in e)if(!1===isSameRouteLocationParamsValue(e[o],t[o]))return!1;return!0}const useRouterLinkProps={to:[String,Object],replace:Boolean,exact:Boolean,activeClass:{type:String,default:"q-router-link--active"},exactActiveClass:{type:String,default:"q-router-link--exact-active"},href:String,target:String,disable:Boolean};function useRouterLink({fallbackTag:e,useDisableForRouterLinkProps:t=!0}={}){const o=vue.getCurrentInstance(),{props:n,proxy:a,emit:l}=o,r=vmHasRouter(o),i=vue.computed(()=>!0!==n.disable&&void 0!==n.href),u=!0===t?vue.computed(()=>!0===r&&!0!==n.disable&&!0!==i.value&&void 0!==n.to&&null!==n.to&&""!==n.to):vue.computed(()=>!0===r&&!0!==i.value&&void 0!==n.to&&null!==n.to&&""!==n.to),s=vue.computed(()=>!0===u.value?b(n.to):null),c=vue.computed(()=>null!==s.value),d=vue.computed(()=>!0===i.value||!0===c.value),v=vue.computed(()=>"a"===n.type||!0===d.value?"a":n.tag||e||"div"),p=vue.computed(()=>!0===i.value?{href:n.href,target:n.target}:!0===c.value?{href:s.value.href,target:n.target}:{}),m=vue.computed(()=>{if(!1===c.value)return-1;const{matched:e}=s.value,{length:t}=e,o=e[t-1];if(void 0===o)return-1;const n=a.$route.matched;if(0===n.length)return-1;const l=n.findIndex(isSameRouteRecord.bind(null,o));if(l>-1)return l;const r=getOriginalPath(e[t-2]);return t>1&&getOriginalPath(o)===r&&n[n.length-1].path!==r?n.findIndex(isSameRouteRecord.bind(null,e[t-2])):l}),f=vue.computed(()=>!0===c.value&&-1!==m.value&&includesParams(a.$route.params,s.value.params)),h=vue.computed(()=>!0===f.value&&m.value===a.$route.matched.length-1&&isSameRouteLocationParams(a.$route.params,s.value.params)),g=vue.computed(()=>!0===c.value?!0===h.value?` ${n.exactActiveClass} ${n.activeClass}`:!0===n.exact?"":!0===f.value?` ${n.activeClass}`:"":"");function b(e){try{return a.$router.resolve(e)}catch(e){}return null}function y(e,{returnRouterError:t,to:o=n.to,replace:l=n.replace}={}){if(!0===n.disable)return e.preventDefault(),Promise.resolve(!1);if(e.metaKey||e.altKey||e.ctrlKey||e.shiftKey||void 0!==e.button&&0!==e.button||"_blank"===n.target)return Promise.resolve(!1);e.preventDefault();const r=a.$router[!0===l?"replace":"push"](o);return!0===t?r:r.then(()=>{}).catch(()=>{})}function S(e){if(!0===c.value){const t=t=>y(e,t);l("click",e,t),!0!==e.defaultPrevented&&t()}else l("click",e)}return{hasRouterLink:c,hasHrefLink:i,hasLink:d,linkTag:v,resolvedLink:s,linkIsActive:f,linkIsExactActive:h,linkClass:g,linkAttrs:p,getLink:b,navigateToRouterLink:y,navigateOnClick:S}}var QBreadcrumbsEl=createComponent({name:"QBreadcrumbsEl",props:{...useRouterLinkProps,label:String,icon:String,tag:{type:String,default:"span"}},emits:["click"],setup(e,{slots:t}){const{linkTag:o,linkAttrs:n,linkClass:a,navigateOnClick:l}=useRouterLink(),r=vue.computed(()=>{return{class:"q-breadcrumbs__el q-link flex inline items-center relative-position "+(!0!==e.disable?"q-link--focusable"+a.value:"q-breadcrumbs__el--disable"),...n.value,onClick:l}}),i=vue.computed(()=>"q-breadcrumbs__el-icon"+(void 0!==e.label?" q-breadcrumbs__el-icon--with-label":""));return()=>{const n=[];return void 0!==e.icon&&n.push(vue.h(QIcon,{class:i.value,name:e.icon})),void 0!==e.label&&n.push(e.label),vue.h(o.value,{...r.value},hMergeSlot(t.default,n))}}});const useSpinnerProps={size:{type:[Number,String],default:"1em"},color:String};function useSpinner(e){return{cSize:vue.computed(()=>e.size in useSizeDefaults?`${useSizeDefaults[e.size]}px`:e.size),classes:vue.computed(()=>"q-spinner"+(e.color?` text-${e.color}`:""))}}var QSpinner=createComponent({name:"QSpinner",props:{...useSpinnerProps,thickness:{type:Number,default:5}},setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value+" q-spinner-mat",width:t.value,height:t.value,viewBox:"25 25 50 50"},[vue.h("circle",{class:"path",cx:"50",cy:"50",r:"20",fill:"none",stroke:"currentColor","stroke-width":e.thickness,"stroke-miterlimit":"10"})])}});function offset(e){if(e===window)return{top:0,left:0};const{top:t,left:o}=e.getBoundingClientRect();return{top:t,left:o}}function style(e,t){return window.getComputedStyle(e).getPropertyValue(t)}function height(e){return e===window?window.innerHeight:e.getBoundingClientRect().height}function width$1(e){return e===window?window.innerWidth:e.getBoundingClientRect().width}function css(e,t){const o=e.style;for(const n in t)o[n]=t[n]}function cssBatch(e,t){e.forEach(e=>css(e,t))}function ready(e){if("function"===typeof e)return"loading"!==document.readyState?e():void document.addEventListener("DOMContentLoaded",e,!1)}function getElement$1(e){if(void 0===e||null===e)return;if("string"===typeof e)try{return document.querySelector(e)||void 0}catch(e){return}const t=vue.unref(e);return t?t.$el||t:void 0}function childHasFocus(e,t){if(void 0===e||null===e||!0===e.contains(t))return!0;for(let o=e.nextElementSibling;null!==o;o=o.nextElementSibling)if(o.contains(t))return!0;return!1}var dom={offset:offset,style:style,height:height,width:width$1,css:css,cssBatch:cssBatch,ready:ready};function throttle(e,t=250){let o,n=!1;return function(){return!1===n&&(n=!0,setTimeout(()=>{n=!1},t),o=e.apply(this,arguments)),o}}var getSSRProps=()=>({}),Ripple=createDirective({name:"ripple",getSSRProps:getSSRProps});const btnPadding={none:0,xs:4,sm:8,md:16,lg:24,xl:32},defaultSizes$2={xs:8,sm:10,md:14,lg:20,xl:24},formTypes=["button","submit","reset"],mediaTypeRE=/[^\s]\/[^\s]/,btnDesignOptions=["flat","outline","push","unelevated"],getBtnDesign=(e,t)=>{return!0===e.flat?"flat":!0===e.outline?"outline":!0===e.push?"push":!0===e.unelevated?"unelevated":t},getBtnDesignAttr=e=>{const t=getBtnDesign(e);return void 0!==t?{[t]:!0}:{}},useBtnProps={...useSizeProps,...useRouterLinkProps,type:{type:String,default:"button"},label:[Number,String],icon:String,iconRight:String,...btnDesignOptions.reduce((e,t)=>(e[t]=Boolean)&&e,{}),square:Boolean,round:Boolean,rounded:Boolean,glossy:Boolean,size:String,fab:Boolean,fabMini:Boolean,padding:String,color:String,textColor:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,tabindex:[Number,String],ripple:{type:[Boolean,Object],default:!0},align:{...useAlignProps.align,default:"center"},stack:Boolean,stretch:Boolean,loading:{type:Boolean,default:null},disable:Boolean};function useBtn(e){const t=useSize(e,defaultSizes$2),o=useAlign(e),{hasRouterLink:n,hasLink:a,linkTag:l,linkAttrs:r,navigateOnClick:i}=useRouterLink({fallbackTag:"button"}),u=vue.computed(()=>{const o=!1===e.fab&&!1===e.fabMini?t.value:{};return void 0!==e.padding?Object.assign({},o,{padding:e.padding.split(/\s+/).map(e=>e in btnPadding?btnPadding[e]+"px":e).join(" "),minWidth:"0",minHeight:"0"}):o}),s=vue.computed(()=>!0===e.rounded||!0===e.fab||!0===e.fabMini),c=vue.computed(()=>!0!==e.disable&&!0!==e.loading),d=vue.computed(()=>!0===c.value?e.tabindex||0:-1),v=vue.computed(()=>getBtnDesign(e,"standard")),p=vue.computed(()=>{const t={tabindex:d.value};return!0===a.value?Object.assign(t,r.value):!0===formTypes.includes(e.type)&&(t.type=e.type),"a"===l.value?(!0===e.disable?t["aria-disabled"]="true":void 0===t.href&&(t.role="button"),!0!==n.value&&!0===mediaTypeRE.test(e.type)&&(t.type=e.type)):!0===e.disable&&(t.disabled="",t["aria-disabled"]="true"),!0===e.loading&&void 0!==e.percentage&&Object.assign(t,{role:"progressbar","aria-valuemin":0,"aria-valuemax":100,"aria-valuenow":e.percentage}),t}),m=vue.computed(()=>{let t;void 0!==e.color?t=!0===e.flat||!0===e.outline?`text-${e.textColor||e.color}`:`bg-${e.color} text-${e.textColor||"white"}`:e.textColor&&(t=`text-${e.textColor}`);const o=!0===e.round?"round":`rectangle${!0===s.value?" q-btn--rounded":!0===e.square?" q-btn--square":""}`;return`q-btn--${v.value} q-btn--${o}`+(void 0!==t?" "+t:"")+(!0===c.value?" q-btn--actionable q-focusable q-hoverable":!0===e.disable?" disabled":"")+(!0===e.fab?" q-btn--fab":!0===e.fabMini?" q-btn--fab-mini":"")+(!0===e.noCaps?" q-btn--no-uppercase":"")+(!0===e.dense?" q-btn--dense":"")+(!0===e.stretch?" no-border-radius self-stretch":"")+(!0===e.glossy?" glossy":"")+(e.square?" q-btn--square":"")}),f=vue.computed(()=>o.value+(!0===e.stack?" column":" row")+(!0===e.noWrap?" no-wrap text-no-wrap":"")+(!0===e.loading?" q-btn__content--hidden":""));return{classes:m,style:u,innerClasses:f,attributes:p,hasLink:a,linkTag:l,navigateOnClick:i,isActionable:c}}const{passiveCapture:passiveCapture}=listenOpts;let touchTarget=null,keyboardTarget=null,mouseTarget=null;var QBtn=createComponent({name:"QBtn",props:{...useBtnProps,percentage:Number,darkPercentage:Boolean,onTouchstart:[Function,Array]},emits:["click","keydown","mousedown","keyup"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{classes:a,style:l,innerClasses:r,attributes:i,hasLink:u,linkTag:s,navigateOnClick:c,isActionable:d}=useBtn(e),v=vue.ref(null),p=vue.ref(null);let m,f=null,h=null;const g=vue.computed(()=>void 0!==e.label&&null!==e.label&&""!==e.label),b=vue.computed(()=>!0!==e.disable&&!1!==e.ripple&&{keyCodes:!0===u.value?[13,32]:[13],...!0===e.ripple?{}:e.ripple}),y=vue.computed(()=>({center:e.round})),S=vue.computed(()=>{const t=Math.max(0,Math.min(100,e.percentage));return t>0?{transition:"transform 0.6s",transform:`translateX(${t-100}%)`}:{}}),x=vue.computed(()=>{if(!0===e.loading)return{onMousedown:M,onTouchstart:M,onClick:M,onKeydown:M,onKeyup:M};if(!0===d.value){const t={onClick:C,onKeydown:k,onMousedown:q};if(!0===n.$q.platform.has.touch){const o=void 0!==e.onTouchstart?"":"Passive";t[`onTouchstart${o}`]=_}return t}return{onClick:stopAndPrevent}}),w=vue.computed(()=>({ref:v,class:"q-btn q-btn-item non-selectable no-outline "+a.value,style:l.value,...i.value,...x.value}));function C(t){if(null!==v.value){if(void 0!==t){if(!0===t.defaultPrevented)return;const o=document.activeElement;if("submit"===e.type&&o!==document.body&&!1===v.value.contains(o)&&!1===o.contains(v.value)){v.value.focus();const e=()=>{document.removeEventListener("keydown",stopAndPrevent,!0),document.removeEventListener("keyup",e,passiveCapture),null!==v.value&&v.value.removeEventListener("blur",e,passiveCapture)};document.addEventListener("keydown",stopAndPrevent,!0),document.addEventListener("keyup",e,passiveCapture),v.value.addEventListener("blur",e,passiveCapture)}}c(t)}}function k(e){null!==v.value&&(o("keydown",e),!0===isKeyCode(e,[13,32])&&keyboardTarget!==v.value&&(null!==keyboardTarget&&P(),!0!==e.defaultPrevented&&(v.value.focus(),keyboardTarget=v.value,v.value.classList.add("q-btn--active"),document.addEventListener("keyup",T,!0),v.value.addEventListener("blur",T,passiveCapture)),stopAndPrevent(e)))}function _(e){null!==v.value&&(o("touchstart",e),!0!==e.defaultPrevented&&(touchTarget!==v.value&&(null!==touchTarget&&P(),touchTarget=v.value,f=e.target,f.addEventListener("touchcancel",T,passiveCapture),f.addEventListener("touchend",T,passiveCapture)),m=!0,null!==h&&clearTimeout(h),h=setTimeout(()=>{h=null,m=!1},200)))}function q(e){null!==v.value&&(e.qSkipRipple=!0===m,o("mousedown",e),!0!==e.defaultPrevented&&mouseTarget!==v.value&&(null!==mouseTarget&&P(),mouseTarget=v.value,v.value.classList.add("q-btn--active"),document.addEventListener("mouseup",T,passiveCapture)))}function T(e){if(null!==v.value&&(void 0===e||"blur"!==e.type||document.activeElement!==v.value)){if(void 0!==e&&"keyup"===e.type){if(keyboardTarget===v.value&&!0===isKeyCode(e,[13,32])){const t=new MouseEvent("click",e);t.qKeyEvent=!0,!0===e.defaultPrevented&&prevent(t),!0===e.cancelBubble&&stop(t),v.value.dispatchEvent(t),stopAndPrevent(e),e.qKeyEvent=!0}o("keyup",e)}P()}}function P(e){const t=p.value;!0===e||touchTarget!==v.value&&mouseTarget!==v.value||null===t||t===document.activeElement||(t.setAttribute("tabindex",-1),t.focus()),touchTarget===v.value&&(null!==f&&(f.removeEventListener("touchcancel",T,passiveCapture),f.removeEventListener("touchend",T,passiveCapture)),touchTarget=f=null),mouseTarget===v.value&&(document.removeEventListener("mouseup",T,passiveCapture),mouseTarget=null),keyboardTarget===v.value&&(document.removeEventListener("keyup",T,!0),null!==v.value&&v.value.removeEventListener("blur",T,passiveCapture),keyboardTarget=null),null!==v.value&&v.value.classList.remove("q-btn--active")}function M(e){stopAndPrevent(e),e.qSkipRipple=!0}return vue.onBeforeUnmount(()=>{P(!0)}),Object.assign(n,{click:C}),()=>{let o=[];void 0!==e.icon&&o.push(vue.h(QIcon,{name:e.icon,left:!1===e.stack&&!0===g.value,role:"img","aria-hidden":"true"})),!0===g.value&&o.push(vue.h("span",{class:"block"},[e.label])),o=hMergeSlot(t.default,o),void 0!==e.iconRight&&!1===e.round&&o.push(vue.h(QIcon,{name:e.iconRight,right:!1===e.stack&&!0===g.value,role:"img","aria-hidden":"true"}));const n=[vue.h("span",{class:"q-focus-helper",ref:p})];return!0===e.loading&&void 0!==e.percentage&&n.push(vue.h("span",{class:"q-btn__progress absolute-full overflow-hidden"+(!0===e.darkPercentage?" q-btn__progress--dark":"")},[vue.h("span",{class:"q-btn__progress-indicator fit block",style:S.value})])),n.push(vue.h("span",{class:"q-btn__content text-center col items-center q-anchor--skip "+r.value},o)),null!==e.loading&&n.push(vue.h(vue.Transition,{name:"q-transition--fade"},()=>!0===e.loading?[vue.h("span",{key:"loading",class:"absolute-full flex flex-center"},void 0!==t.loading?t.loading():[vue.h(QSpinner)])]:null)),vue.withDirectives(vue.h(s.value,w.value,n),[[Ripple,b.value,void 0,y.value]])}}}),QBtnGroup=createComponent({name:"QBtnGroup",props:{unelevated:Boolean,outline:Boolean,flat:Boolean,rounded:Boolean,square:Boolean,push:Boolean,stretch:Boolean,glossy:Boolean,spread:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>{const t=["unelevated","outline","flat","rounded","square","push","stretch","glossy"].filter(t=>!0===e[t]).map(e=>`q-btn-group--${e}`).join(" ");return`q-btn-group row no-wrap${0!==t.length?" "+t:""}`+(!0===e.spread?" q-btn-group--spread":" inline")});return()=>vue.h("div",{class:o.value},hSlot(t.default))}});function clearSelection(){if(void 0!==window.getSelection){const e=window.getSelection();void 0!==e.empty?e.empty():void 0!==e.removeAllRanges&&(e.removeAllRanges(),!0!==Platform.is.mobile&&e.addRange(document.createRange()))}else void 0!==document.selection&&document.selection.empty()}const useAnchorProps={target:{default:!0},noParentEvent:Boolean,contextMenu:Boolean};function useAnchor({showing:e,avoidEmit:t,configureAnchorEl:o}){const{props:n,proxy:a,emit:l}=vue.getCurrentInstance(),r=vue.ref(null);let i=null;function u(e){return null!==r.value&&(void 0===e||void 0===e.touches||e.touches.length<=1)}const s={};function c(){cleanEvt(s,"anchor")}function d(e){r.value=e;while(r.value.classList.contains("q-anchor--skip"))r.value=r.value.parentNode;o()}function v(){if(!1===n.target||""===n.target||null===a.$el.parentNode)r.value=null;else if(!0===n.target)d(a.$el.parentNode);else{let e=n.target;if("string"===typeof n.target)try{e=document.querySelector(n.target)}catch(t){e=void 0}void 0!==e&&null!==e?(r.value=e.$el||e,o()):(r.value=null,console.error(`Anchor: target "${n.target}" not found`))}}return void 0===o&&(Object.assign(s,{hide(e){a.hide(e)},toggle(e){a.toggle(e),e.qAnchorHandled=!0},toggleKey(e){!0===isKeyCode(e,13)&&s.toggle(e)},contextClick(e){a.hide(e),prevent(e),vue.nextTick(()=>{a.show(e),e.qAnchorHandled=!0})},prevent:prevent,mobileTouch(e){if(s.mobileCleanup(e),!0!==u(e))return;a.hide(e),r.value.classList.add("non-selectable");const t=e.target;addEvt(s,"anchor",[[t,"touchmove","mobileCleanup","passive"],[t,"touchend","mobileCleanup","passive"],[t,"touchcancel","mobileCleanup","passive"],[r.value,"contextmenu","prevent","notPassive"]]),i=setTimeout(()=>{i=null,a.show(e),e.qAnchorHandled=!0},300)},mobileCleanup(t){r.value.classList.remove("non-selectable"),null!==i&&(clearTimeout(i),i=null),!0===e.value&&void 0!==t&&clearSelection()}}),o=function(e=n.contextMenu){if(!0===n.noParentEvent||null===r.value)return;let t;t=!0===e?!0===a.$q.platform.is.mobile?[[r.value,"touchstart","mobileTouch","passive"]]:[[r.value,"mousedown","hide","passive"],[r.value,"contextmenu","contextClick","notPassive"]]:[[r.value,"click","toggle","passive"],[r.value,"keyup","toggleKey","passive"]],addEvt(s,"anchor",t)}),vue.watch(()=>n.contextMenu,e=>{null!==r.value&&(c(),o(e))}),vue.watch(()=>n.target,()=>{null!==r.value&&c(),v()}),vue.watch(()=>n.noParentEvent,e=>{null!==r.value&&(!0===e?c():o())}),vue.onMounted(()=>{v(),!0!==t&&!0===n.modelValue&&null===r.value&&l("update:modelValue",!1)}),vue.onBeforeUnmount(()=>{null!==i&&clearTimeout(i),c()}),{anchorEl:r,canShow:u,anchorEvents:s}}function useScrollTarget(e,t){const o=vue.ref(null);let n;function a(e,t){const o=`${void 0!==t?"add":"remove"}EventListener`,a=void 0!==t?t:n;e!==window&&e[o]("scroll",a,listenOpts.passive),window[o]("scroll",a,listenOpts.passive),n=t}function l(){null!==o.value&&(a(o.value),o.value=null)}const r=vue.watch(()=>e.noParentEvent,()=>{null!==o.value&&(l(),t())});return vue.onBeforeUnmount(r),{localScrollTarget:o,unconfigureScrollTarget:l,changeScrollEvent:a}}const useModelToggleProps={modelValue:{type:Boolean,default:null},"onUpdate:modelValue":[Function,Array]},useModelToggleEmits=["beforeShow","show","beforeHide","hide"];function useModelToggle({showing:e,canShow:t,hideOnRouteChange:o,handleShow:n,handleHide:a,processOnMount:l}){const r=vue.getCurrentInstance(),{props:i,emit:u,proxy:s}=r;let c;function d(t){!0===e.value||v(t)}function v(e){if(!0===i.disable||void 0!==e&&!0===e.qAnchorHandled||void 0!==t&&!0!==t(e))return;i["onUpdate:modelValue"];i.modelValue,p(e)}function p(t){!0!==e.value&&(e.value=!0,u("beforeShow",t),void 0!==n?n(t):u("show",t))}function m(e){}function f(t){!1!==e.value&&(e.value=!1,u("beforeHide",t),void 0!==a?a(t):u("hide",t))}function h(t){if(!0===i.disable&&!0===t)void 0!==i["onUpdate:modelValue"]&&u("update:modelValue",!1);else if(!0===t!==e.value){const e=!0===t?p:f;e(c)}}vue.watch(()=>i.modelValue,h),void 0!==o&&!0===vmHasRouter(r)&&vue.watch(()=>s.$route.fullPath,()=>{!0===o.value&&e.value}),!0===l&&vue.onMounted(()=>{h(i.modelValue)});const g={show:v,hide:m,toggle:d};return Object.assign(s,g),g}let queue=[],waitFlags=[];function addFocusFn(e){0===waitFlags.length?e():queue.push(e)}function removeFocusFn(e){queue=queue.filter(t=>t!==e)}const portalProxyList=[];function closePortalMenus(e,t){do{if("QMenu"===e.$options.name){if(e.hide(t),!0===e.$props.separateClosePopup)return getParentProxy(e)}else if(!0===e.__qPortal){const o=getParentProxy(e);return void 0!==o&&"QPopupProxy"===o.$options.name?(e.hide(t),o):e}e=getParentProxy(e)}while(void 0!==e&&null!==e)}function usePortal(e,t,o,n){const a=vue.ref(!1),l=vue.ref(!1);return{portalIsActive:a,portalIsAccessible:l,showPortal:noop,hidePortal:noop,renderPortal:noop}}const useTransitionProps={transitionShow:{type:String,default:"fade"},transitionHide:{type:String,default:"fade"},transitionDuration:{type:[String,Number],default:300}};function useTransition(e,t=(()=>{}),o=(()=>{})){return{transitionProps:vue.computed(()=>{const n=`q-transition--${e.transitionShow||t()}`,a=`q-transition--${e.transitionHide||o()}`;return{appear:!0,enterFromClass:`${n}-enter-from`,enterActiveClass:`${n}-enter-active`,enterToClass:`${n}-enter-to`,leaveFromClass:`${a}-leave-from`,leaveActiveClass:`${a}-leave-active`,leaveToClass:`${a}-leave-to`}}),transitionStyle:vue.computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`)}}function useTick(){let e;const t=vue.getCurrentInstance();function o(){e=void 0}return vue.onDeactivated(o),vue.onBeforeUnmount(o),{removeTick:o,registerTick(o){e=o,vue.nextTick(()=>{e===o&&(!1===vmIsDestroyed(t)&&e(),e=void 0)})}}}function useTimeout(){let e=null;const t=vue.getCurrentInstance();function o(){null!==e&&(clearTimeout(e),e=null)}return vue.onDeactivated(o),vue.onBeforeUnmount(o),{removeTimeout:o,registerTimeout(n,a){o(),!1===vmIsDestroyed(t)&&(e=setTimeout(n,a))}}}const scrollTargets=[];function getScrollTarget(e,t){let o=getElement$1(t);if(void 0===o){if(void 0===e||null===e)return window;o=e.closest(".scroll,.scroll-y,.overflow-auto")}return scrollTargets.includes(o)?window:o}function getScrollHeight(e){return(e===window?document.body:e).scrollHeight}function getScrollWidth(e){return(e===window?document.body:e).scrollWidth}function getVerticalScrollPosition(e){return e===window?window.pageYOffset||window.scrollY||document.body.scrollTop||0:e.scrollTop}function getHorizontalScrollPosition(e){return e===window?window.pageXOffset||window.scrollX||document.body.scrollLeft||0:e.scrollLeft}function animVerticalScrollTo(e,t,o=0){const n=void 0===arguments[3]?performance.now():arguments[3],a=getVerticalScrollPosition(e);o<=0?a!==t&&setScroll$1(e,t):requestAnimationFrame(l=>{const r=l-n,i=a+(t-a)/Math.max(r,o)*r;setScroll$1(e,i),i!==t&&animVerticalScrollTo(e,t,o-r,l)})}function animHorizontalScrollTo(e,t,o=0){const n=void 0===arguments[3]?performance.now():arguments[3],a=getHorizontalScrollPosition(e);o<=0?a!==t&&setHorizontalScroll(e,t):requestAnimationFrame(l=>{const r=l-n,i=a+(t-a)/Math.max(r,o)*r;setHorizontalScroll(e,i),i!==t&&animHorizontalScrollTo(e,t,o-r,l)})}function setScroll$1(e,t){e!==window?e.scrollTop=t:window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,t)}function setHorizontalScroll(e,t){e!==window?e.scrollLeft=t:window.scrollTo(t,window.pageYOffset||window.scrollY||document.body.scrollTop||0)}function setVerticalScrollPosition(e,t,o){o?animVerticalScrollTo(e,t,o):setScroll$1(e,t)}function setHorizontalScrollPosition(e,t,o){o?animHorizontalScrollTo(e,t,o):setHorizontalScroll(e,t)}let size;function getScrollbarWidth(){if(void 0!==size)return size;const e=document.createElement("p"),t=document.createElement("div");css(e,{width:"100%",height:"200px"}),css(t,{position:"absolute",top:"0px",left:"0px",visibility:"hidden",width:"200px",height:"150px",overflow:"hidden"}),t.appendChild(e),document.body.appendChild(t);const o=e.offsetWidth;t.style.overflow="scroll";let n=e.offsetWidth;return o===n&&(n=t.clientWidth),t.remove(),size=o-n,size}function hasScrollbar(e,t=!0){return!(!e||e.nodeType!==Node.ELEMENT_NODE)&&(t?e.scrollHeight>e.clientHeight&&(e.classList.contains("scroll")||e.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(e)["overflow-y"])):e.scrollWidth>e.clientWidth&&(e.classList.contains("scroll")||e.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(e)["overflow-x"])))}var scroll={getScrollTarget:getScrollTarget,getScrollHeight:getScrollHeight,getScrollWidth:getScrollWidth,getVerticalScrollPosition:getVerticalScrollPosition,getHorizontalScrollPosition:getHorizontalScrollPosition,animVerticalScrollTo:animVerticalScrollTo,animHorizontalScrollTo:animHorizontalScrollTo,setVerticalScrollPosition:setVerticalScrollPosition,setHorizontalScrollPosition:setHorizontalScrollPosition,getScrollbarWidth:getScrollbarWidth,hasScrollbar:hasScrollbar};const handlers$1=[];let escDown;function onKeydown(e){escDown=27===e.keyCode}function onBlur(){!0===escDown&&(escDown=!1)}function onKeyup(e){!0===escDown&&(escDown=!1,!0===isKeyCode(e,27)&&handlers$1[handlers$1.length-1](e))}function update(e){window[e]("keydown",onKeydown),window[e]("blur",onBlur),window[e]("keyup",onKeyup),escDown=!1}function addEscapeKey(e){!0===client.is.desktop&&(handlers$1.push(e),1===handlers$1.length&&update("addEventListener"))}function removeEscapeKey(e){const t=handlers$1.indexOf(e);t>-1&&(handlers$1.splice(t,1),0===handlers$1.length&&update("removeEventListener"))}const handlers=[];function trigger(e){handlers[handlers.length-1](e)}function addFocusout(e){!0===client.is.desktop&&(handlers.push(e),1===handlers.length&&document.body.addEventListener("focusin",trigger))}function removeFocusout(e){const t=handlers.indexOf(e);t>-1&&(handlers.splice(t,1),0===handlers.length&&document.body.removeEventListener("focusin",trigger))}const{notPassiveCapture:notPassiveCapture}=listenOpts,registeredList=[];function globalHandler(e){const t=e.target;if(void 0===t||8===t.nodeType||!0===t.classList.contains("no-pointer-events"))return;let o=portalProxyList.length-1;while(o>=0){const e=portalProxyList[o].$;if("QTooltip"!==e.type.name){if("QDialog"!==e.type.name)break;if(!0!==e.props.seamless)return;o--}else o--}for(let n=registeredList.length-1;n>=0;n--){const o=registeredList[n];if(null!==o.anchorEl.value&&!1!==o.anchorEl.value.contains(t)||t!==document.body&&(null===o.innerRef.value||!1!==o.innerRef.value.contains(t)))return;e.qClickOutside=!0,o.onClickOutside(e)}}function addClickOutside(e){registeredList.push(e),1===registeredList.length&&(document.addEventListener("mousedown",globalHandler,notPassiveCapture),document.addEventListener("touchstart",globalHandler,notPassiveCapture))}function removeClickOutside(e){const t=registeredList.findIndex(t=>t===e);t>-1&&(registeredList.splice(t,1),0===registeredList.length&&(document.removeEventListener("mousedown",globalHandler,notPassiveCapture),document.removeEventListener("touchstart",globalHandler,notPassiveCapture)))}let vpLeft,vpTop;function validatePosition(e){const t=e.split(" ");return 2===t.length&&(!0!==["top","center","bottom"].includes(t[0])?(console.error("Anchor/Self position must start with one of top/center/bottom"),!1):!0===["left","middle","right","start","end"].includes(t[1])||(console.error("Anchor/Self position must end with one of left/middle/right/start/end"),!1))}function validateOffset(e){return!e||2===e.length&&("number"===typeof e[0]&&"number"===typeof e[1])}const horizontalPos={"start#ltr":"left","start#rtl":"right","end#ltr":"right","end#rtl":"left"};function parsePosition(e,t){const o=e.split(" ");return{vertical:o[0],horizontal:horizontalPos[`${o[1]}#${!0===t?"rtl":"ltr"}`]}}function getAnchorProps(e,t){let{top:o,left:n,right:a,bottom:l,width:r,height:i}=e.getBoundingClientRect();return void 0!==t&&(o-=t[1],n-=t[0],l+=t[1],a+=t[0],r+=t[0],i+=t[1]),{top:o,bottom:l,height:i,left:n,right:a,width:r,middle:n+(a-n)/2,center:o+(l-o)/2}}function getAbsoluteAnchorProps(e,t,o){let{top:n,left:a}=e.getBoundingClientRect();return n+=t.top,a+=t.left,void 0!==o&&(n+=o[1],a+=o[0]),{top:n,bottom:n+1,height:1,left:a,right:a+1,width:1,middle:a,center:n}}function getTargetProps(e,t){return{top:0,center:t/2,bottom:t,left:0,middle:e/2,right:e}}function getTopLeftProps(e,t,o,n){return{top:e[o.vertical]-t[n.vertical],left:e[o.horizontal]-t[n.horizontal]}}function setPosition(e,t=0){if(null===e.targetEl||null===e.anchorEl||t>5)return;if(0===e.targetEl.offsetHeight||0===e.targetEl.offsetWidth)return void setTimeout(()=>{setPosition(e,t+1)},10);const{targetEl:o,offset:n,anchorEl:a,anchorOrigin:l,selfOrigin:r,absoluteOffset:i,fit:u,cover:s,maxHeight:c,maxWidth:d}=e;if(!0===client.is.ios&&void 0!==window.visualViewport){const e=document.body.style,{offsetLeft:t,offsetTop:o}=window.visualViewport;t!==vpLeft&&(e.setProperty("--q-pe-left",t+"px"),vpLeft=t),o!==vpTop&&(e.setProperty("--q-pe-top",o+"px"),vpTop=o)}const{scrollLeft:v,scrollTop:p}=o,m=void 0===i?getAnchorProps(a,!0===s?[0,0]:n):getAbsoluteAnchorProps(a,i,n);Object.assign(o.style,{top:0,left:0,minWidth:null,minHeight:null,maxWidth:d||"100vw",maxHeight:c||"100vh",visibility:"visible"});const{offsetWidth:f,offsetHeight:h}=o,{elWidth:g,elHeight:b}=!0===u||!0===s?{elWidth:Math.max(m.width,f),elHeight:!0===s?Math.max(m.height,h):h}:{elWidth:f,elHeight:h};let y={maxWidth:d,maxHeight:c};!0!==u&&!0!==s||(y.minWidth=m.width+"px",!0===s&&(y.minHeight=m.height+"px")),Object.assign(o.style,y);const S=getTargetProps(g,b);let x=getTopLeftProps(m,S,l,r);if(void 0===i||void 0===n)applyBoundaries(x,m,S,l,r);else{const{top:e,left:t}=x;applyBoundaries(x,m,S,l,r);let o=!1;if(x.top!==e){o=!0;const e=2*n[1];m.center=m.top-=e,m.bottom-=e+2}if(x.left!==t){o=!0;const e=2*n[0];m.middle=m.left-=e,m.right-=e+2}!0===o&&(x=getTopLeftProps(m,S,l,r),applyBoundaries(x,m,S,l,r))}y={top:x.top+"px",left:x.left+"px"},void 0!==x.maxHeight&&(y.maxHeight=x.maxHeight+"px",m.height>x.maxHeight&&(y.minHeight=y.maxHeight)),void 0!==x.maxWidth&&(y.maxWidth=x.maxWidth+"px",m.width>x.maxWidth&&(y.minWidth=y.maxWidth)),Object.assign(o.style,y),o.scrollTop!==p&&(o.scrollTop=p),o.scrollLeft!==v&&(o.scrollLeft=v)}function applyBoundaries(e,t,o,n,a){const l=o.bottom,r=o.right,i=getScrollbarWidth(),u=window.innerHeight-i,s=document.body.clientWidth;if(e.top<0||e.top+l>u)if("center"===a.vertical)e.top=t[n.vertical]>u/2?Math.max(0,u-l):0,e.maxHeight=Math.min(l,u);else if(t[n.vertical]>u/2){const o=Math.min(u,"center"===n.vertical?t.center:n.vertical===a.vertical?t.bottom:t.top);e.maxHeight=Math.min(l,o),e.top=Math.max(0,o-l)}else e.top=Math.max(0,"center"===n.vertical?t.center:n.vertical===a.vertical?t.top:t.bottom),e.maxHeight=Math.min(l,u-e.top);if(e.left<0||e.left+r>s)if(e.maxWidth=Math.min(r,s),"middle"===a.horizontal)e.left=t[n.horizontal]>s/2?Math.max(0,s-r):0;else if(t[n.horizontal]>s/2){const o=Math.min(s,"middle"===n.horizontal?t.middle:n.horizontal===a.horizontal?t.right:t.left);e.maxWidth=Math.min(r,o),e.left=Math.max(0,o-e.maxWidth)}else e.left=Math.max(0,"middle"===n.horizontal?t.middle:n.horizontal===a.horizontal?t.left:t.right),e.maxWidth=Math.min(r,s-e.left)}["left","middle","right"].forEach(e=>{horizontalPos[`${e}#ltr`]=e,horizontalPos[`${e}#rtl`]=e});var QMenu=createComponent({name:"QMenu",inheritAttrs:!1,props:{...useAnchorProps,...useModelToggleProps,...useDarkProps,...useTransitionProps,persistent:Boolean,autoClose:Boolean,separateClosePopup:Boolean,noRouteDismiss:Boolean,noRefocus:Boolean,noFocus:Boolean,fit:Boolean,cover:Boolean,square:Boolean,anchor:{type:String,validator:validatePosition},self:{type:String,validator:validatePosition},offset:{type:Array,validator:validateOffset},scrollTarget:{default:void 0},touchPosition:Boolean,maxHeight:{type:String,default:null},maxWidth:{type:String,default:null}},emits:[...useModelToggleEmits,"click","escapeKey"],setup(e,{slots:t,emit:o,attrs:n}){let a,l,r,i=null;const u=vue.getCurrentInstance(),{proxy:s}=u,{$q:c}=s,d=vue.ref(null),v=vue.ref(!1),p=vue.computed(()=>!0!==e.persistent&&!0!==e.noRouteDismiss),m=useDark(e,c),{registerTick:f,removeTick:h}=useTick(),{registerTimeout:g}=useTimeout();useTransition(e);const{localScrollTarget:b,changeScrollEvent:y,unconfigureScrollTarget:S}=useScrollTarget(e,F),{anchorEl:x,canShow:w}=useAnchor({showing:v}),{hide:C}=useModelToggle({showing:v,canShow:w,handleShow:B,handleHide:R,hideOnRouteChange:p,processOnMount:!0}),{showPortal:k,hidePortal:_,renderPortal:q}=usePortal(),T={anchorEl:x,innerRef:d,onClickOutside(t){if(!0!==e.persistent&&!0===v.value)return C(t),("touchstart"===t.type||t.target.classList.contains("q-dialog__backdrop"))&&stopAndPrevent(t),!0}},P=vue.computed(()=>parsePosition(e.anchor||(!0===e.cover?"center middle":"bottom start"),c.lang.rtl)),M=vue.computed(()=>!0===e.cover?P.value:parsePosition(e.self||"top start",c.lang.rtl));vue.computed(()=>(!0===e.square?" q-menu--square":"")+(!0===m.value?" q-menu--dark q-dark":"")),vue.computed(()=>!0===e.autoClose?{onClick:E}:{});const $=vue.computed(()=>!0===v.value&&!0!==e.persistent);function Q(){addFocusFn(()=>{let e=d.value;e&&!0!==e.contains(document.activeElement)&&(e=e.querySelector("[autofocus][tabindex], [data-autofocus][tabindex]")||e.querySelector("[autofocus] [tabindex], [data-autofocus] [tabindex]")||e.querySelector("[autofocus], [data-autofocus]")||e,e.focus({preventScroll:!0}))})}function B(t){if(i=!1===e.noRefocus?document.activeElement:null,addFocusout(D),k(),F(),a=void 0,void 0!==t&&(e.touchPosition||e.contextMenu)){const e=position(t);if(void 0!==e.left){const{top:t,left:o}=x.value.getBoundingClientRect();a={left:e.left-o,top:e.top-t}}}void 0===l&&(l=vue.watch(()=>c.screen.width+"|"+c.screen.height+"|"+e.self+"|"+e.anchor+"|"+c.lang.rtl,O)),!0!==e.noFocus&&document.activeElement.blur(),f(()=>{O(),!0!==e.noFocus&&Q()}),g(()=>{!0===c.platform.is.ios&&(r=e.autoClose,d.value.click()),O(),k(!0),o("show",t)},e.transitionDuration)}function R(t){h(),_(),A(!0),null===i||void 0!==t&&!0===t.qClickOutside||(((t&&0===t.type.indexOf("key")?i.closest('[tabindex]:not([tabindex^="-"])'):void 0)||i).focus(),i=null),g(()=>{_(!0),o("hide",t)},e.transitionDuration)}function A(e){a=void 0,void 0!==l&&(l(),l=void 0),!0!==e&&!0!==v.value||(removeFocusout(D),S(),removeClickOutside(T),removeEscapeKey(I)),!0!==e&&(i=null)}function F(){null===x.value&&void 0===e.scrollTarget||(b.value=getScrollTarget(x.value,e.scrollTarget),y(b.value,O))}function E(e){!0!==r?(closePortalMenus(s,e),o("click",e)):r=!1}function D(t){!0===$.value&&!0!==e.noFocus&&!0!==childHasFocus(d.value,t.target)&&Q()}function I(e){o("escapeKey"),C(e)}function O(){setPosition({targetEl:d.value,offset:e.offset,anchorEl:x.value,anchorOrigin:P.value,selfOrigin:M.value,absoluteOffset:a,fit:e.fit,cover:e.cover,maxHeight:e.maxHeight,maxWidth:e.maxWidth})}return vue.watch($,e=>{!0===e?(addEscapeKey(I),addClickOutside(T)):(removeEscapeKey(I),removeClickOutside(T))}),vue.onBeforeUnmount(A),Object.assign(s,{focus:Q,updatePosition:O}),q}});let buf,bufIdx=0;const hexBytes=new Array(256);for(let e=0;e<256;e++)hexBytes[e]=(e+256).toString(16).substring(1);const randomBytes=(()=>{const e="undefined"!==typeof crypto?crypto:"undefined"!==typeof window?window.crypto||window.msCrypto:void 0;if(void 0!==e){if(void 0!==e.randomBytes)return e.randomBytes;if(void 0!==e.getRandomValues)return t=>{const o=new Uint8Array(t);return e.getRandomValues(o),o}}return e=>{const t=[];for(let o=e;o>0;o--)t.push(Math.floor(256*Math.random()));return t}})(),BUFFER_SIZE=4096;function uid(){(void 0===buf||bufIdx+16>BUFFER_SIZE)&&(bufIdx=0,buf=randomBytes(BUFFER_SIZE));const e=Array.prototype.slice.call(buf,bufIdx,bufIdx+=16);return e[6]=15&e[6]|64,e[8]=63&e[8]|128,hexBytes[e[0]]+hexBytes[e[1]]+hexBytes[e[2]]+hexBytes[e[3]]+"-"+hexBytes[e[4]]+hexBytes[e[5]]+"-"+hexBytes[e[6]]+hexBytes[e[7]]+"-"+hexBytes[e[8]]+hexBytes[e[9]]+"-"+hexBytes[e[10]]+hexBytes[e[11]]+hexBytes[e[12]]+hexBytes[e[13]]+hexBytes[e[14]]+hexBytes[e[15]]}const btnPropsList=Object.keys(useBtnProps),passBtnProps=e=>btnPropsList.reduce((t,o)=>{const n=e[o];return void 0!==n&&(t[o]=n),t},{});var QBtnDropdown=createComponent({name:"QBtnDropdown",props:{...useBtnProps,...useTransitionProps,modelValue:Boolean,split:Boolean,dropdownIcon:String,contentClass:[Array,String,Object],contentStyle:[Array,String,Object],cover:Boolean,persistent:Boolean,noRouteDismiss:Boolean,autoClose:Boolean,menuAnchor:{type:String,default:"bottom end"},menuSelf:{type:String,default:"top end"},menuOffset:Array,disableMainBtn:Boolean,disableDropdown:Boolean,noIconAnimation:Boolean,toggleAriaLabel:String},emits:["update:modelValue","click","beforeShow","show","beforeHide","hide"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),a=vue.ref(e.modelValue),l=vue.ref(null),r=uid(),i=vue.computed(()=>{const t={"aria-expanded":!0===a.value?"true":"false","aria-haspopup":"true","aria-controls":r,"aria-label":e.toggleAriaLabel||n.$q.lang.label[!0===a.value?"collapse":"expand"](e.label)};return(!0===e.disable||!1===e.split&&!0===e.disableMainBtn||!0===e.disableDropdown)&&(t["aria-disabled"]="true"),t}),u=vue.computed(()=>"q-btn-dropdown__arrow"+(!0===a.value&&!1===e.noIconAnimation?" rotate-180":"")+(!1===e.split?" q-btn-dropdown__arrow-container":"")),s=vue.computed(()=>getBtnDesignAttr(e)),c=vue.computed(()=>passBtnProps(e));function d(e){a.value=!0,o("beforeShow",e)}function v(e){o("show",e),o("update:modelValue",!0)}function p(e){a.value=!1,o("beforeHide",e)}function m(e){o("hide",e),o("update:modelValue",!1)}function f(e){o("click",e)}function h(e){stop(e),y(),o("click",e)}function g(e){null!==l.value&&l.value.toggle(e)}function b(e){null!==l.value&&l.value.show(e)}function y(e){null!==l.value&&l.value.hide(e)}return vue.watch(()=>e.modelValue,e=>{null!==l.value&&l.value[e?"show":"hide"]()}),vue.watch(()=>e.split,y),Object.assign(n,{show:b,hide:y,toggle:g}),vue.onMounted(()=>{!0===e.modelValue&&b()}),()=>{const o=[vue.h(QIcon,{class:u.value,name:e.dropdownIcon||n.$q.iconSet.arrow.dropdown})];return!0!==e.disableDropdown&&o.push(vue.h(QMenu,{ref:l,id:r,class:e.contentClass,style:e.contentStyle,cover:e.cover,fit:!0,persistent:e.persistent,noRouteDismiss:e.noRouteDismiss,autoClose:e.autoClose,anchor:e.menuAnchor,self:e.menuSelf,offset:e.menuOffset,separateClosePopup:!0,transitionShow:e.transitionShow,transitionHide:e.transitionHide,transitionDuration:e.transitionDuration,onBeforeShow:d,onShow:v,onBeforeHide:p,onHide:m},t.default)),!1===e.split?vue.h(QBtn,{class:"q-btn-dropdown q-btn-dropdown--simple",...c.value,...i.value,disable:!0===e.disable||!0===e.disableMainBtn,noWrap:!0,round:!1,onClick:f},{default:()=>hSlot(t.label,[]).concat(o),loading:t.loading}):vue.h(QBtnGroup,{class:"q-btn-dropdown q-btn-dropdown--split no-wrap q-btn-item",rounded:e.rounded,square:e.square,...s.value,glossy:e.glossy,stretch:e.stretch},()=>[vue.h(QBtn,{class:"q-btn-dropdown--current",...c.value,disable:!0===e.disable||!0===e.disableMainBtn,noWrap:!0,round:!1,onClick:h},{default:t.label,loading:t.loading}),vue.h(QBtn,{class:"q-btn-dropdown__arrow-container q-anchor--skip",...i.value,...s.value,disable:!0===e.disable||!0===e.disableDropdown,rounded:e.rounded,color:e.color,textColor:e.textColor,dense:e.dense,size:e.size,padding:e.padding,ripple:e.ripple},()=>o)])}}});const useFormProps={name:String};function useFormAttrs(e){return vue.computed(()=>({type:"hidden",name:e.name,value:e.modelValue}))}function useFormInject(e={}){return(t,o,n)=>{t[o](vue.h("input",{class:"hidden"+(n||""),...e.value}))}}function useFormInputNameAttr(e){return vue.computed(()=>e.name||e.for)}var QBtnToggle=createComponent({name:"QBtnToggle",props:{...useFormProps,modelValue:{required:!0},options:{type:Array,required:!0,validator:e=>e.every(e=>("label"in e||"icon"in e||"slot"in e)&&"value"in e)},color:String,textColor:String,toggleColor:{type:String,default:"primary"},toggleTextColor:String,outline:Boolean,flat:Boolean,unelevated:Boolean,rounded:Boolean,push:Boolean,glossy:Boolean,size:String,padding:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,readonly:Boolean,disable:Boolean,stack:Boolean,stretch:Boolean,spread:Boolean,clearable:Boolean,ripple:{type:[Boolean,Object],default:!0}},emits:["update:modelValue","clear","click"],setup(e,{slots:t,emit:o}){const n=vue.computed(()=>void 0!==e.options.find(t=>t.value===e.modelValue)),a=vue.computed(()=>({type:"hidden",name:e.name,value:e.modelValue})),l=useFormInject(a),r=vue.computed(()=>getBtnDesignAttr(e)),i=vue.computed(()=>({rounded:e.rounded,dense:e.dense,...r.value})),u=vue.computed(()=>e.options.map((t,o)=>{const{attrs:n,value:a,slot:l,...r}=t;return{slot:l,props:{key:o,"aria-pressed":a===e.modelValue?"true":"false",...n,...r,...i.value,disable:!0===e.disable||!0===r.disable,color:a===e.modelValue?c(r,"toggleColor"):c(r,"color"),textColor:a===e.modelValue?c(r,"toggleTextColor"):c(r,"textColor"),noCaps:!0===c(r,"noCaps"),noWrap:!0===c(r,"noWrap"),size:c(r,"size"),padding:c(r,"padding"),ripple:c(r,"ripple"),stack:!0===c(r,"stack"),stretch:!0===c(r,"stretch"),onClick(e){s(a,t,e)}}}}));function s(t,n,a){!0!==e.readonly&&(e.modelValue===t?!0===e.clearable&&(o("update:modelValue",null,null),o("clear")):o("update:modelValue",t,n),o("click",a))}function c(t,o){return void 0===t[o]?e[o]:t[o]}function d(){const o=u.value.map(e=>{return vue.h(QBtn,e.props,void 0!==e.slot?t[e.slot]:void 0)});return void 0!==e.name&&!0!==e.disable&&!0===n.value&&l(o,"push"),hMergeSlot(t.default,o)}return()=>vue.h(QBtnGroup,{class:"q-btn-toggle",...r.value,rounded:e.rounded,stretch:e.stretch,glossy:e.glossy,spread:e.spread},d)}}),QCard=createComponent({name:"QCard",props:{...useDarkProps,tag:{type:String,default:"div"},square:Boolean,flat:Boolean,bordered:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useDark(e,o),a=vue.computed(()=>"q-card"+(!0===n.value?" q-card--dark q-dark":"")+(!0===e.bordered?" q-card--bordered":"")+(!0===e.square?" q-card--square no-border-radius":"")+(!0===e.flat?" q-card--flat no-shadow":""));return()=>vue.h(e.tag,{class:a.value},hSlot(t.default))}}),QCardSection=createComponent({name:"QCardSection",props:{tag:{type:String,default:"div"},horizontal:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>"q-card__section"+` q-card__section--${!0===e.horizontal?"horiz row no-wrap":"vert"}`);return()=>vue.h(e.tag,{class:o.value},hSlot(t.default))}}),QCardActions=createComponent({name:"QCardActions",props:{...useAlignProps,vertical:Boolean},setup(e,{slots:t}){const o=useAlign(e),n=vue.computed(()=>`q-card__actions ${o.value}`+` q-card__actions--${!0===e.vertical?"vert column":"horiz row"}`);return()=>vue.h("div",{class:n.value},hSlot(t.default))}});const modifiersAll={left:!0,right:!0,up:!0,down:!0,horizontal:!0,vertical:!0,all:!0};var TouchSwipe=createDirective({name:"touch-swipe",getSSRProps:getSSRProps});function useCache(){return{getCache:function(e,t){return t},getCacheWithFn:function(e,t){return t()}}}const usePanelChildProps={name:{required:!0},disable:Boolean},PanelWrapper$1={setup(e,{slots:t}){return()=>vue.h("div",{class:"q-panel scroll",role:"tabpanel"},hSlot(t.default))}},usePanelProps={modelValue:{required:!0},animated:Boolean,infinite:Boolean,swipeable:Boolean,vertical:Boolean,transitionPrev:String,transitionNext:String,transitionDuration:{type:[String,Number],default:300},keepAlive:Boolean,keepAliveInclude:[String,Array,RegExp],keepAliveExclude:[String,Array,RegExp],keepAliveMax:Number},usePanelEmits=["update:modelValue","beforeTransition","transition"];function usePanel(){const{props:e,emit:t,proxy:o}=vue.getCurrentInstance(),{getCacheWithFn:n}=useCache();let a,l;const r=vue.ref(null),i=vue.ref(null);function u(t){const n=!0===e.vertical?"up":"left";C((!0===o.$q.lang.rtl?-1:1)*(t.direction===n?1:-1))}const s=vue.computed(()=>{return[[TouchSwipe,u,void 0,{horizontal:!0!==e.vertical,vertical:e.vertical,mouse:!0}]]}),c=vue.computed(()=>e.transitionPrev||`slide-${!0===e.vertical?"down":"right"}`),d=vue.computed(()=>e.transitionNext||`slide-${!0===e.vertical?"up":"left"}`),v=vue.computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`),p=vue.computed(()=>"string"===typeof e.modelValue||"number"===typeof e.modelValue?e.modelValue:String(e.modelValue)),m=vue.computed(()=>({include:e.keepAliveInclude,exclude:e.keepAliveExclude,max:e.keepAliveMax})),f=vue.computed(()=>void 0!==e.keepAliveInclude||void 0!==e.keepAliveExclude);function h(){C(1)}function g(){C(-1)}function b(e){t("update:modelValue",e)}function y(e){return void 0!==e&&null!==e&&""!==e}function S(e){return a.findIndex(t=>{return t.props.name===e&&""!==t.props.disable&&!0!==t.props.disable})}function x(){return a.filter(e=>{return""!==e.props.disable&&!0!==e.props.disable})}function w(t){const o=0!==t&&!0===e.animated&&-1!==r.value?"q-transition--"+(-1===t?c.value:d.value):null;i.value!==o&&(i.value=o)}function C(o,n=r.value){let i=n+o;while(i>-1&&i<a.length){const e=a[i];if(void 0!==e&&""!==e.props.disable&&!0!==e.props.disable)return w(o),l=!0,t("update:modelValue",e.props.name),void setTimeout(()=>{l=!1});i+=o}!0===e.infinite&&0!==a.length&&-1!==n&&n!==a.length&&C(o,-1===o?a.length:-1)}function k(){const t=S(e.modelValue);return r.value!==t&&(r.value=t),!0}function _(){const t=!0===y(e.modelValue)&&k()&&a[r.value];return!0===e.keepAlive?[vue.h(vue.KeepAlive,m.value,[vue.h(!0===f.value?n(p.value,()=>({...PanelWrapper$1,name:p.value})):PanelWrapper$1,{key:p.value,style:v.value},()=>t)])]:[vue.h("div",{class:"q-panel scroll",style:v.value,key:p.value,role:"tabpanel"},[t])]}function q(){if(0!==a.length)return!0===e.animated?[vue.h(vue.Transition,{name:i.value},_)]:_()}function T(e){return a=getNormalizedVNodes(hSlot(e.default,[])).filter(e=>null!==e.props&&void 0===e.props.slot&&!0===y(e.props.name)),a.length}function P(){return a}return vue.watch(()=>e.modelValue,(e,o)=>{const n=!0===y(e)?S(e):-1;!0!==l&&w(-1===n?0:n<S(o)?-1:1),r.value!==n&&(r.value=n,t("beforeTransition",e,o),vue.nextTick(()=>{t("transition",e,o)}))}),Object.assign(o,{next:h,previous:g,goTo:b}),{panelIndex:r,panelDirectives:s,updatePanelsList:T,updatePanelIndex:k,getPanelContent:q,getEnabledPanels:x,getPanels:P,isValidPanelName:y,keepAliveProps:m,needsUniqueKeepAliveWrapper:f,goToPanelByOffset:C,goToPanel:b,nextPanel:h,previousPanel:g}}let counter=0;const useFullscreenProps={fullscreen:Boolean,noRouteFullscreenExit:Boolean},useFullscreenEmits=["update:fullscreen","fullscreen"];function useFullscreen(){const e=vue.getCurrentInstance(),{props:t,emit:o,proxy:n}=e;let a,l,r;const i=vue.ref(!1);function u(){!0===i.value?c():s()}function s(){!0!==i.value&&(i.value=!0,r=n.$el.parentNode,r.replaceChild(l,n.$el),document.body.appendChild(n.$el),counter++,1===counter&&document.body.classList.add("q-body--fullscreen-mixin"),a={handler:c},History.add(a))}function c(){!0===i.value&&(void 0!==a&&(History.remove(a),a=void 0),r.replaceChild(n.$el,l),i.value=!1,counter=Math.max(0,counter-1),0===counter&&(document.body.classList.remove("q-body--fullscreen-mixin"),void 0!==n.$el.scrollIntoView&&setTimeout(()=>{n.$el.scrollIntoView()})))}return!0===vmHasRouter(e)&&vue.watch(()=>n.$route.fullPath,()=>{!0!==t.noRouteFullscreenExit&&c()}),vue.watch(()=>t.fullscreen,e=>{i.value!==e&&u()}),vue.watch(i,e=>{o("update:fullscreen",e),o("fullscreen",e)}),vue.onBeforeMount(()=>{l=document.createElement("span")}),vue.onMounted(()=>{!0===t.fullscreen&&s()}),vue.onBeforeUnmount(c),Object.assign(n,{toggleFullscreen:u,setFullscreen:s,exitFullscreen:c}),{inFullscreen:i,toggleFullscreen:u}}const navigationPositionOptions=["top","right","bottom","left"],controlTypeOptions=["regular","flat","outline","push","unelevated"];var QCarousel=createComponent({name:"QCarousel",props:{...useDarkProps,...usePanelProps,...useFullscreenProps,transitionPrev:{type:String,default:"fade"},transitionNext:{type:String,default:"fade"},height:String,padding:Boolean,controlColor:String,controlTextColor:String,controlType:{type:String,validator:e=>controlTypeOptions.includes(e),default:"flat"},autoplay:[Number,Boolean],arrows:Boolean,prevIcon:String,nextIcon:String,navigation:Boolean,navigationPosition:{type:String,validator:e=>navigationPositionOptions.includes(e)},navigationIcon:String,navigationActiveIcon:String,thumbnails:Boolean},emits:[...useFullscreenEmits,...usePanelEmits],setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useDark(e,o);let a,l=null;const{updatePanelsList:r,getPanelContent:i,panelDirectives:u,goToPanel:s,previousPanel:c,nextPanel:d,getEnabledPanels:v,panelIndex:p}=usePanel(),{inFullscreen:m}=useFullscreen(),f=vue.computed(()=>!0!==m.value&&void 0!==e.height?{height:e.height}:{}),h=vue.computed(()=>!0===e.vertical?"vertical":"horizontal"),g=vue.computed(()=>`q-carousel q-panel-parent q-carousel--with${!0===e.padding?"":"out"}-padding`+(!0===m.value?" fullscreen":"")+(!0===n.value?" q-carousel--dark q-dark":"")+(!0===e.arrows?` q-carousel--arrows-${h.value}`:"")+(!0===e.navigation?` q-carousel--navigation-${x.value}`:"")),b=vue.computed(()=>{const t=[e.prevIcon||o.iconSet.carousel[!0===e.vertical?"up":"left"],e.nextIcon||o.iconSet.carousel[!0===e.vertical?"down":"right"]];return!1===e.vertical&&!0===o.lang.rtl?t.reverse():t}),y=vue.computed(()=>e.navigationIcon||o.iconSet.carousel.navigationIcon),S=vue.computed(()=>e.navigationActiveIcon||y.value),x=vue.computed(()=>e.navigationPosition||(!0===e.vertical?"right":"bottom")),w=vue.computed(()=>({color:e.controlColor,textColor:e.controlTextColor,round:!0,[e.controlType]:!0,dense:!0}));function C(){const t=!0===isNumber(e.autoplay)?Math.abs(e.autoplay):5e3;null!==l&&clearTimeout(l),l=setTimeout(()=>{l=null,t>=0?d():c()},t)}function k(t,o){return vue.h("div",{class:"q-carousel__control q-carousel__navigation no-wrap absolute flex"+` q-carousel__navigation--${t} q-carousel__navigation--${x.value}`+(void 0!==e.controlColor?` text-${e.controlColor}`:"")},[vue.h("div",{class:"q-carousel__navigation-inner flex flex-center no-wrap"},v().map(o))])}function _(){const o=[];if(!0===e.navigation){const e=void 0!==t["navigation-icon"]?t["navigation-icon"]:e=>vue.h(QBtn,{key:"nav"+e.name,class:`q-carousel__navigation-icon q-carousel__navigation-icon--${!0===e.active?"":"in"}active`,...e.btnProps,onClick:e.onClick}),n=a-1;o.push(k("buttons",(t,o)=>{const a=t.props.name,l=p.value===o;return e({index:o,maxIndex:n,name:a,active:l,btnProps:{icon:!0===l?S.value:y.value,size:"sm",...w.value},onClick:()=>{s(a)}})}))}else if(!0===e.thumbnails){const t=void 0!==e.controlColor?` text-${e.controlColor}`:"";o.push(k("thumbnails",o=>{const n=o.props;return vue.h("img",{key:"tmb#"+n.name,class:`q-carousel__thumbnail q-carousel__thumbnail--${n.name===e.modelValue?"":"in"}active`+t,src:n.imgSrc||n["img-src"],onClick:()=>{s(n.name)}})}))}return!0===e.arrows&&p.value>=0&&((!0===e.infinite||p.value>0)&&o.push(vue.h("div",{key:"prev",class:`q-carousel__control q-carousel__arrow q-carousel__prev-arrow q-carousel__prev-arrow--${h.value} absolute flex flex-center`},[vue.h(QBtn,{icon:b.value[0],...w.value,onClick:c})])),(!0===e.infinite||p.value<a-1)&&o.push(vue.h("div",{key:"next",class:"q-carousel__control q-carousel__arrow q-carousel__next-arrow"+` q-carousel__next-arrow--${h.value} absolute flex flex-center`},[vue.h(QBtn,{icon:b.value[1],...w.value,onClick:d})]))),hMergeSlot(t.control,o)}return vue.watch(()=>e.modelValue,()=>{e.autoplay&&C()}),vue.watch(()=>e.autoplay,e=>{e?C():null!==l&&(clearTimeout(l),l=null)}),vue.onMounted(()=>{e.autoplay&&C()}),vue.onBeforeUnmount(()=>{null!==l&&clearTimeout(l)}),()=>{return a=r(t),vue.h("div",{class:g.value,style:f.value},[hDir("div",{class:"q-carousel__slides-container"},i(),"sl-cont",e.swipeable,()=>u.value)].concat(_()))}}}),QCarouselSlide=createComponent({name:"QCarouselSlide",props:{...usePanelChildProps,imgSrc:String},setup(e,{slots:t}){const o=vue.computed(()=>e.imgSrc?{backgroundImage:`url("${e.imgSrc}")`}:{});return()=>vue.h("div",{class:"q-carousel__slide",style:o.value},hSlot(t.default))}}),QCarouselControl=createComponent({name:"QCarouselControl",props:{position:{type:String,default:"bottom-right",validator:e=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(e)},offset:{type:Array,default:()=>[18,18],validator:e=>2===e.length}},setup(e,{slots:t}){const o=vue.computed(()=>`q-carousel__control absolute absolute-${e.position}`),n=vue.computed(()=>({margin:`${e.offset[1]}px ${e.offset[0]}px`}));return()=>vue.h("div",{class:o.value,style:n.value},hSlot(t.default))}}),QChatMessage=createComponent({name:"QChatMessage",props:{sent:Boolean,label:String,bgColor:String,textColor:String,name:String,avatar:String,text:Array,stamp:String,size:String,labelHtml:Boolean,nameHtml:Boolean,textHtml:Boolean,stampHtml:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>!0===e.sent?"sent":"received"),n=vue.computed(()=>`q-message-text-content q-message-text-content--${o.value}`+(void 0!==e.textColor?` text-${e.textColor}`:"")),a=vue.computed(()=>`q-message-text q-message-text--${o.value}`+(void 0!==e.bgColor?` text-${e.bgColor}`:"")),l=vue.computed(()=>"q-message-container row items-end no-wrap"+(!0===e.sent?" reverse":"")),r=vue.computed(()=>void 0!==e.size?`col-${e.size}`:""),i=vue.computed(()=>({msg:!0===e.textHtml?"innerHTML":"textContent",stamp:!0===e.stampHtml?"innerHTML":"textContent",name:!0===e.nameHtml?"innerHTML":"textContent",label:!0===e.labelHtml?"innerHTML":"textContent"}));function u(o){return void 0!==t.stamp?[o,vue.h("div",{class:"q-message-stamp"},t.stamp())]:e.stamp?[o,vue.h("div",{class:"q-message-stamp",[i.value.stamp]:e.stamp})]:[o]}function s(e,t){const o=!0===t?e.length>1?e=>e:e=>vue.h("div",[e]):e=>vue.h("div",{[i.value.msg]:e});return e.map((e,t)=>vue.h("div",{key:t,class:a.value},[vue.h("div",{class:n.value},u(o(e)))]))}return()=>{const n=[];void 0!==t.avatar?n.push(t.avatar()):void 0!==e.avatar&&n.push(vue.h("img",{class:`q-message-avatar q-message-avatar--${o.value}`,src:e.avatar,"aria-hidden":"true"}));const a=[];void 0!==t.name?a.push(vue.h("div",{class:`q-message-name q-message-name--${o.value}`},t.name())):void 0!==e.name&&a.push(vue.h("div",{class:`q-message-name q-message-name--${o.value}`,[i.value.name]:e.name})),void 0!==t.default?a.push(s(getNormalizedVNodes(t.default()),!0)):void 0!==e.text&&a.push(s(e.text)),n.push(vue.h("div",{class:r.value},a));const u=[];return void 0!==t.label?u.push(vue.h("div",{class:"q-message-label"},t.label())):void 0!==e.label&&u.push(vue.h("div",{class:"q-message-label",[i.value.label]:e.label})),u.push(vue.h("div",{class:l.value},n)),vue.h("div",{class:`q-message q-message-${o.value}`},u)}}});function useRefocusTarget(e,t){const o=vue.ref(null),n=vue.computed(()=>{return!0===e.disable?null:vue.h("span",{ref:o,class:"no-outline",tabindex:-1})});function a(e){const n=t.value;void 0!==e&&0===e.type.indexOf("key")?null!==n&&document.activeElement!==n&&!0===n.contains(document.activeElement)&&n.focus():null!==o.value&&(void 0===e||null!==n&&!0===n.contains(e.target))&&o.value.focus()}return{refocusTargetEl:n,refocusTarget:a}}var optionSizes={xs:30,sm:35,md:40,lg:50,xl:60};const useCheckboxProps={...useDarkProps,...useSizeProps,...useFormProps,modelValue:{required:!0,default:null},val:{},trueValue:{default:!0},falseValue:{default:!1},indeterminateValue:{default:null},checkedIcon:String,uncheckedIcon:String,indeterminateIcon:String,toggleOrder:{type:String,validator:e=>"tf"===e||"ft"===e},toggleIndeterminate:Boolean,label:String,leftLabel:Boolean,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},useCheckboxEmits=["update:modelValue"];function useCheckbox(e,t){const{props:o,slots:n,emit:a,proxy:l}=vue.getCurrentInstance(),{$q:r}=l,i=useDark(o,r),u=vue.ref(null),{refocusTargetEl:s,refocusTarget:c}=useRefocusTarget(o,u),d=useSize(o,optionSizes),v=vue.computed(()=>void 0!==o.val&&Array.isArray(o.modelValue)),p=vue.computed(()=>{const e=vue.toRaw(o.val);return!0===v.value?o.modelValue.findIndex(t=>vue.toRaw(t)===e):-1}),m=vue.computed(()=>!0===v.value?p.value>-1:vue.toRaw(o.modelValue)===vue.toRaw(o.trueValue)),f=vue.computed(()=>!0===v.value?-1===p.value:vue.toRaw(o.modelValue)===vue.toRaw(o.falseValue)),h=vue.computed(()=>!1===m.value&&!1===f.value),g=vue.computed(()=>!0===o.disable?-1:o.tabindex||0),b=vue.computed(()=>`q-${e} cursor-pointer no-outline row inline no-wrap items-center`+(!0===o.disable?" disabled":"")+(!0===i.value?` q-${e}--dark`:"")+(!0===o.dense?` q-${e}--dense`:"")+(!0===o.leftLabel?" reverse":"")),y=vue.computed(()=>{const t=!0===m.value?"truthy":!0===f.value?"falsy":"indet",n=void 0===o.color||!0!==o.keepColor&&("toggle"===e?!0!==m.value:!0===f.value)?"":` text-${o.color}`;return`q-${e}__inner relative-position non-selectable q-${e}__inner--${t}${n}`}),S=vue.computed(()=>{const e={type:"checkbox"};return void 0!==o.name&&Object.assign(e,{".checked":m.value,"^checked":!0===m.value?"checked":void 0,name:o.name,value:!0===v.value?o.val:o.trueValue}),e}),x=useFormInject(S),w=vue.computed(()=>{const t={tabindex:g.value,role:"toggle"===e?"switch":"checkbox","aria-label":o.label,"aria-checked":!0===h.value?"mixed":!0===m.value?"true":"false"};return!0===o.disable&&(t["aria-disabled"]="true"),t});function C(e){void 0!==e&&(stopAndPrevent(e),c(e)),!0!==o.disable&&a("update:modelValue",k(),e)}function k(){if(!0===v.value){if(!0===m.value){const e=o.modelValue.slice();return e.splice(p.value,1),e}return o.modelValue.concat([o.val])}if(!0===m.value){if("ft"!==o.toggleOrder||!1===o.toggleIndeterminate)return o.falseValue}else{if(!0!==f.value)return"ft"!==o.toggleOrder?o.trueValue:o.falseValue;if("ft"===o.toggleOrder||!1===o.toggleIndeterminate)return o.trueValue}return o.indeterminateValue}function _(e){13!==e.keyCode&&32!==e.keyCode||stopAndPrevent(e)}function q(e){13!==e.keyCode&&32!==e.keyCode||C(e)}const T=t(m,h);return Object.assign(l,{toggle:C}),()=>{const t=T();!0!==o.disable&&x(t,"unshift",` q-${e}__native absolute q-ma-none q-pa-none`);const a=[vue.h("div",{class:y.value,style:d.value,"aria-hidden":"true"},t)];null!==s.value&&a.push(s.value);const l=void 0!==o.label?hMergeSlot(n.default,[o.label]):hSlot(n.default);return void 0!==l&&a.push(vue.h("div",{class:`q-${e}__label q-anchor--skip`},l)),vue.h("div",{ref:u,class:b.value,...w.value,onClick:C,onKeydown:_,onKeyup:q},a)}}const bgNode=vue.h("div",{key:"svg",class:"q-checkbox__bg absolute"},[vue.h("svg",{class:"q-checkbox__svg fit absolute-full",viewBox:"0 0 24 24"},[vue.h("path",{class:"q-checkbox__truthy",fill:"none",d:"M1.73,12.91 8.1,19.28 22.79,4.59"}),vue.h("path",{class:"q-checkbox__indet",d:"M4,14H20V10H4"})])]);var QCheckbox=createComponent({name:"QCheckbox",props:useCheckboxProps,emits:useCheckboxEmits,setup(e){function t(t,o){const n=vue.computed(()=>(!0===t.value?e.checkedIcon:!0===o.value?e.indeterminateIcon:e.uncheckedIcon)||null);return()=>null!==n.value?[vue.h("div",{key:"icon",class:"q-checkbox__icon-container absolute-full flex flex-center no-wrap"},[vue.h(QIcon,{class:"q-checkbox__icon",name:n.value})])]:[bgNode]}return useCheckbox("checkbox",t)}});const defaultSizes$1={xs:8,sm:10,md:14,lg:20,xl:24};var QChip=createComponent({name:"QChip",props:{...useDarkProps,...useSizeProps,dense:Boolean,icon:String,iconRight:String,iconRemove:String,iconSelected:String,label:[String,Number],color:String,textColor:String,modelValue:{type:Boolean,default:!0},selected:{type:Boolean,default:null},square:Boolean,outline:Boolean,clickable:Boolean,removable:Boolean,removeAriaLabel:String,tabindex:[String,Number],disable:Boolean,ripple:{type:[Boolean,Object],default:!0}},emits:["update:modelValue","update:selected","remove","click"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=useDark(e,n),l=useSize(e,defaultSizes$1),r=vue.computed(()=>!0===e.selected||void 0!==e.icon),i=vue.computed(()=>!0===e.selected?e.iconSelected||n.iconSet.chip.selected:e.icon),u=vue.computed(()=>e.iconRemove||n.iconSet.chip.remove),s=vue.computed(()=>!1===e.disable&&(!0===e.clickable||null!==e.selected)),c=vue.computed(()=>{const t=!0===e.outline&&e.color||e.textColor;return"q-chip row inline no-wrap items-center"+(!1===e.outline&&void 0!==e.color?` bg-${e.color}`:"")+(t?` text-${t} q-chip--colored`:"")+(!0===e.disable?" disabled":"")+(!0===e.dense?" q-chip--dense":"")+(!0===e.outline?" q-chip--outline":"")+(!0===e.selected?" q-chip--selected":"")+(!0===s.value?" q-chip--clickable cursor-pointer non-selectable q-hoverable":"")+(!0===e.square?" q-chip--square":"")+(!0===a.value?" q-chip--dark q-dark":"")}),d=vue.computed(()=>{const t=!0===e.disable?{tabindex:-1,"aria-disabled":"true"}:{tabindex:e.tabindex||0},o={...t,role:"button","aria-hidden":"false","aria-label":e.removeAriaLabel||n.lang.label.remove};return{chip:t,remove:o}});function v(e){13===e.keyCode&&p(e)}function p(t){e.disable||(o("update:selected",!e.selected),o("click",t))}function m(t){void 0!==t.keyCode&&13!==t.keyCode||(stopAndPrevent(t),!1===e.disable&&(o("update:modelValue",!1),o("remove")))}function f(){const o=[];!0===s.value&&o.push(vue.h("div",{class:"q-focus-helper"})),!0===r.value&&o.push(vue.h(QIcon,{class:"q-chip__icon q-chip__icon--left",name:i.value}));const n=void 0!==e.label?[vue.h("div",{class:"ellipsis"},[e.label])]:void 0;return o.push(vue.h("div",{class:"q-chip__content col row no-wrap items-center q-anchor--skip"},hMergeSlotSafely(t.default,n))),e.iconRight&&o.push(vue.h(QIcon,{class:"q-chip__icon q-chip__icon--right",name:e.iconRight})),!0===e.removable&&o.push(vue.h(QIcon,{class:"q-chip__icon q-chip__icon--remove cursor-pointer",name:u.value,...d.value.remove,onClick:m,onKeyup:m})),o}return()=>{if(!1===e.modelValue)return;const t={class:c.value,style:l.value};return!0===s.value&&Object.assign(t,d.value.chip,{onClick:p,onKeyup:v}),hDir("div",t,f(),"ripple",!1!==e.ripple&&!0!==e.disable,()=>[[Ripple,e.ripple]])}}});const useCircularCommonProps={...useSizeProps,min:{type:Number,default:0},max:{type:Number,default:100},color:String,centerColor:String,trackColor:String,fontSize:String,rounded:Boolean,thickness:{type:Number,default:.2,validator:e=>e>=0&&e<=1},angle:{type:Number,default:0},showValue:Boolean,reverse:Boolean,instantFeedback:Boolean},radius=50,diameter=2*radius,circumference=diameter*Math.PI,strokeDashArray=Math.round(1e3*circumference)/1e3;var QCircularProgress=createComponent({name:"QCircularProgress",props:{...useCircularCommonProps,value:{type:Number,default:0},animationSpeed:{type:[String,Number],default:600},indeterminate:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=useSize(e),a=vue.computed(()=>{const t=(!0===o.lang.rtl?-1:1)*e.angle;return{transform:e.reverse!==(!0===o.lang.rtl)?`scale3d(-1, 1, 1) rotate3d(0, 0, 1, ${-90-t}deg)`:`rotate3d(0, 0, 1, ${t-90}deg)`}}),l=vue.computed(()=>!0!==e.instantFeedback&&!0!==e.indeterminate?{transition:`stroke-dashoffset ${e.animationSpeed}ms ease 0s, stroke ${e.animationSpeed}ms ease`}:""),r=vue.computed(()=>diameter/(1-e.thickness/2)),i=vue.computed(()=>`${r.value/2} ${r.value/2} ${r.value} ${r.value}`),u=vue.computed(()=>between(e.value,e.min,e.max)),s=vue.computed(()=>circumference*(1-(u.value-e.min)/(e.max-e.min))),c=vue.computed(()=>e.thickness/2*r.value);function d({thickness:e,offset:t,color:o,cls:n,rounded:a}){return vue.h("circle",{class:"q-circular-progress__"+n+(void 0!==o?` text-${o}`:""),style:l.value,fill:"transparent",stroke:"currentColor","stroke-width":e,"stroke-dasharray":strokeDashArray,"stroke-dashoffset":t,"stroke-linecap":a,cx:r.value,cy:r.value,r:radius})}return()=>{const o=[];void 0!==e.centerColor&&"transparent"!==e.centerColor&&o.push(vue.h("circle",{class:`q-circular-progress__center text-${e.centerColor}`,fill:"currentColor",r:radius-c.value/2,cx:r.value,cy:r.value})),void 0!==e.trackColor&&"transparent"!==e.trackColor&&o.push(d({cls:"track",thickness:c.value,offset:0,color:e.trackColor})),o.push(d({cls:"circle",thickness:c.value,offset:s.value,color:e.color,rounded:!0===e.rounded?"round":void 0}));const l=[vue.h("svg",{class:"q-circular-progress__svg",style:a.value,viewBox:i.value,"aria-hidden":"true"},o)];return!0===e.showValue&&l.push(vue.h("div",{class:"q-circular-progress__text absolute-full row flex-center content-center",style:{fontSize:e.fontSize}},void 0!==t.default?t.default():[vue.h("div",u.value)])),vue.h("div",{class:`q-circular-progress q-circular-progress--${!0===e.indeterminate?"in":""}determinate`,style:n.value,role:"progressbar","aria-valuemin":e.min,"aria-valuemax":e.max,"aria-valuenow":!0===e.indeterminate?void 0:u.value},hMergeSlotSafely(t.internal,l))}}}),TouchPan=createDirective({name:"touch-pan",getSSRProps:getSSRProps});const markerPrefixClass="q-slider__marker-labels",defaultMarkerConvertFn=e=>({value:e}),defaultMarkerLabelRenderFn=({marker:e})=>vue.h("div",{key:e.value,style:e.style,class:e.classes},e.label),keyCodes$2=[34,37,40,33,39,38],useSliderProps={...useDarkProps,...useFormProps,min:{type:Number,default:0},max:{type:Number,default:100},innerMin:Number,innerMax:Number,step:{type:Number,default:1,validator:e=>e>=0},snap:Boolean,vertical:Boolean,reverse:Boolean,hideSelection:Boolean,color:String,markerLabelsClass:String,label:Boolean,labelColor:String,labelTextColor:String,labelAlways:Boolean,switchLabelSide:Boolean,markers:[Boolean,Number],markerLabels:[Boolean,Array,Object,Function],switchMarkerLabelsSide:Boolean,trackImg:String,trackColor:String,innerTrackImg:String,innerTrackColor:String,selectionColor:String,selectionImg:String,thumbSize:{type:String,default:"20px"},trackSize:{type:String,default:"4px"},disable:Boolean,readonly:Boolean,dense:Boolean,tabindex:[String,Number],thumbColor:String,thumbPath:{type:String,default:"M 4, 10 a 6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0"}},useSliderEmits=["pan","update:modelValue","change"];function useSlider({updateValue:e,updatePosition:t,getDragging:o,formAttrs:n}){const{props:a,emit:l,slots:r,proxy:{$q:i}}=vue.getCurrentInstance(),u=useDark(a,i),s=useFormInject(n),c=vue.ref(!1),d=vue.ref(!1),v=vue.ref(!1),p=vue.ref(!1),m=vue.computed(()=>!0===a.vertical?"--v":"--h"),f=vue.computed(()=>"-"+(!0===a.switchLabelSide?"switched":"standard")),h=vue.computed(()=>!0===a.vertical?!0===a.reverse:a.reverse!==(!0===i.lang.rtl)),g=vue.computed(()=>!0===isNaN(a.innerMin)||a.innerMin<a.min?a.min:a.innerMin),b=vue.computed(()=>!0===isNaN(a.innerMax)||a.innerMax>a.max?a.max:a.innerMax),y=vue.computed(()=>!0!==a.disable&&!0!==a.readonly&&g.value<b.value),S=vue.computed(()=>(String(a.step).trim().split(".")[1]||"").length),x=vue.computed(()=>0===a.step?1:a.step),w=vue.computed(()=>!0===y.value?a.tabindex||0:-1),C=vue.computed(()=>a.max-a.min),k=vue.computed(()=>b.value-g.value),_=vue.computed(()=>U(g.value)),q=vue.computed(()=>U(b.value)),T=vue.computed(()=>!0===a.vertical?!0===h.value?"bottom":"top":!0===h.value?"right":"left"),P=vue.computed(()=>!0===a.vertical?"height":"width"),M=vue.computed(()=>!0===a.vertical?"width":"height"),$=vue.computed(()=>!0===a.vertical?"vertical":"horizontal"),Q=vue.computed(()=>{const e={role:"slider","aria-valuemin":g.value,"aria-valuemax":b.value,"aria-orientation":$.value,"data-step":a.step};return!0===a.disable?e["aria-disabled"]="true":!0===a.readonly&&(e["aria-readonly"]="true"),e}),B=vue.computed(()=>`q-slider q-slider${m.value} q-slider--${!0===c.value?"":"in"}active inline no-wrap `+(!0===a.vertical?"row":"column")+(!0===a.disable?" disabled":" q-slider--enabled"+(!0===y.value?" q-slider--editable":""))+("both"===v.value?" q-slider--focus":"")+(a.label||!0===a.labelAlways?" q-slider--label":"")+(!0===a.labelAlways?" q-slider--label-always":"")+(!0===u.value?" q-slider--dark":"")+(!0===a.dense?" q-slider--dense q-slider--dense"+m.value:""));function R(e){const t="q-slider__"+e;return`${t} ${t}${m.value} ${t}${m.value}${f.value}`}function A(e){const t="q-slider__"+e;return`${t} ${t}${m.value}`}const F=vue.computed(()=>{const e=a.selectionColor||a.color;return"q-slider__selection absolute"+(void 0!==e?` text-${e}`:"")}),E=vue.computed(()=>A("markers")+" absolute overflow-hidden"),D=vue.computed(()=>A("track-container")),I=vue.computed(()=>R("pin")),O=vue.computed(()=>R("label")),z=vue.computed(()=>R("text-container")),V=vue.computed(()=>R("marker-labels-container")+(void 0!==a.markerLabelsClass?` ${a.markerLabelsClass}`:"")),L=vue.computed(()=>"q-slider__track relative-position no-outline"+(void 0!==a.trackColor?` bg-${a.trackColor}`:"")),H=vue.computed(()=>{const e={[M.value]:a.trackSize};return void 0!==a.trackImg&&(e.backgroundImage=`url(${a.trackImg}) !important`),e}),N=vue.computed(()=>"q-slider__inner absolute"+(void 0!==a.innerTrackColor?` bg-${a.innerTrackColor}`:"")),j=vue.computed(()=>{const e=q.value-_.value,t={[T.value]:`${100*_.value}%`,[P.value]:0===e?"2px":`${100*e}%`};return void 0!==a.innerTrackImg&&(t.backgroundImage=`url(${a.innerTrackImg}) !important`),t});function K(e){const{min:t,max:o,step:n}=a;let l=t+e*(o-t);if(n>0){const e=(l-t)%n;l+=(Math.abs(e)>=n/2?(e<0?-1:1)*n:0)-e}return S.value>0&&(l=parseFloat(l.toFixed(S.value))),between(l,g.value,b.value)}function U(e){return 0===C.value?0:(e-a.min)/C.value}function W(e,t){const o=position(e),n=!0===a.vertical?between((o.top-t.top)/t.height,0,1):between((o.left-t.left)/t.width,0,1);return between(!0===h.value?1-n:n,_.value,q.value)}const Y=vue.computed(()=>!0===isNumber(a.markers)?a.markers:x.value),G=vue.computed(()=>{const e=[],t=Y.value,o=a.max;let n=a.min;do{e.push(n),n+=t}while(n<o);return e.push(o),e}),X=vue.computed(()=>{const e=` ${markerPrefixClass}${m.value}-`;return markerPrefixClass+`${e}${!0===a.switchMarkerLabelsSide?"switched":"standard"}`+`${e}${!0===h.value?"rtl":"ltr"}`}),Z=vue.computed(()=>{return!1===a.markerLabels?null:te(a.markerLabels).map((e,t)=>({index:t,value:e.value,label:e.label||e.value,classes:X.value+(void 0!==e.classes?" "+e.classes:""),style:{...oe(e.value),...e.style||{}}}))}),J=vue.computed(()=>({markerList:Z.value,markerMap:ne.value,classes:X.value,getStyle:oe})),ee=vue.computed(()=>{const e=0===k.value?"2px":100*Y.value/k.value;return{...j.value,backgroundSize:!0===a.vertical?`2px ${e}%`:`${e}% 2px`}});function te(e){if(!1===e)return null;if(!0===e)return G.value.map(defaultMarkerConvertFn);if("function"===typeof e)return G.value.map(t=>{const o=e(t);return!0===isObject(o)?{...o,value:t}:{value:t,label:o}});const t=({value:e})=>e>=a.min&&e<=a.max;return!0===Array.isArray(e)?e.map(e=>!0===isObject(e)?e:{value:e}).filter(t):Object.keys(e).map(t=>{const o=e[t],n=Number(t);return!0===isObject(o)?{...o,value:n}:{value:n,label:o}}).filter(t)}function oe(e){return{[T.value]:`${100*(e-a.min)/C.value}%`}}const ne=vue.computed(()=>{if(!1===a.markerLabels)return null;const e={};return Z.value.forEach(t=>{e[t.value]=t}),e});function ae(){if(void 0!==r["marker-label-group"])return r["marker-label-group"](J.value);const e=r["marker-label"]||defaultMarkerLabelRenderFn;return Z.value.map(t=>e({marker:t,...J.value}))}const le=vue.computed(()=>{return[[TouchPan,re,void 0,{[$.value]:!0,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}]]});function re(n){!0===n.isFinal?(void 0!==p.value&&(t(n.evt),!0===n.touch&&e(!0),p.value=void 0,l("pan","end")),c.value=!1,v.value=!1):!0===n.isFirst?(p.value=o(n.evt),t(n.evt),e(),c.value=!0,l("pan","start")):(t(n.evt),e())}function ie(){v.value=!1}function ue(n){t(n,o(n)),e(),d.value=!0,c.value=!0,document.addEventListener("mouseup",se,!0)}function se(){d.value=!1,c.value=!1,e(!0),ie(),document.removeEventListener("mouseup",se,!0)}function ce(n){t(n,o(n)),e(!0)}function de(t){keyCodes$2.includes(t.keyCode)&&e(!0)}function ve(e){if(!0===a.vertical)return null;const t=i.lang.rtl!==a.reverse?1-e:e;return{transform:`translateX(calc(${2*t-1} * ${a.thumbSize} / 2 + ${50-100*t}%))`}}function pe(e){const t=vue.computed(()=>!1!==d.value||v.value!==e.focusValue&&"both"!==v.value?"":" q-slider--focus"),o=vue.computed(()=>`q-slider__thumb q-slider__thumb${m.value} q-slider__thumb${m.value}-${!0===h.value?"rtl":"ltr"} absolute non-selectable`+t.value+(void 0!==e.thumbColor.value?` text-${e.thumbColor.value}`:"")),n=vue.computed(()=>({width:a.thumbSize,height:a.thumbSize,[T.value]:`${100*e.ratio.value}%`,zIndex:v.value===e.focusValue?2:void 0})),l=vue.computed(()=>void 0!==e.labelColor.value?` text-${e.labelColor.value}`:""),r=vue.computed(()=>ve(e.ratio.value)),i=vue.computed(()=>"q-slider__text"+(void 0!==e.labelTextColor.value?` text-${e.labelTextColor.value}`:""));return()=>{const t=[vue.h("svg",{class:"q-slider__thumb-shape absolute-full",viewBox:"0 0 20 20","aria-hidden":"true"},[vue.h("path",{d:a.thumbPath})]),vue.h("div",{class:"q-slider__focus-ring fit"})];return!0!==a.label&&!0!==a.labelAlways||(t.push(vue.h("div",{class:I.value+" absolute fit no-pointer-events"+l.value},[vue.h("div",{class:O.value,style:{minWidth:a.thumbSize}},[vue.h("div",{class:z.value,style:r.value},[vue.h("span",{class:i.value},e.label.value)])])])),void 0!==a.name&&!0!==a.disable&&s(t,"push")),vue.h("div",{class:o.value,style:n.value,...e.getNodeData()},t)}}function me(e,t,o,n){const l=[];"transparent"!==a.innerTrackColor&&l.push(vue.h("div",{key:"inner",class:N.value,style:j.value})),"transparent"!==a.selectionColor&&l.push(vue.h("div",{key:"selection",class:F.value,style:e.value})),!1!==a.markers&&l.push(vue.h("div",{key:"marker",class:E.value,style:ee.value})),n(l);const r=[hDir("div",{key:"trackC",class:D.value,tabindex:t.value,...o.value},[vue.h("div",{class:L.value,style:H.value},l)],"slide",y.value,()=>le.value)];if(!1!==a.markerLabels){const e=!0===a.switchMarkerLabelsSide?"unshift":"push";r[e](vue.h("div",{key:"markerL",class:V.value},ae()))}return r}return vue.onBeforeUnmount(()=>{document.removeEventListener("mouseup",se,!0)}),{state:{active:c,focus:v,preventFocus:d,dragging:p,editable:y,classes:B,tabindex:w,attributes:Q,step:x,decimals:S,trackLen:C,innerMin:g,innerMinRatio:_,innerMax:b,innerMaxRatio:q,positionProp:T,sizeProp:P,isReversed:h},methods:{onActivate:ue,onMobileClick:ce,onBlur:ie,onKeyup:de,getContent:me,getThumbRenderFn:pe,convertRatioToModel:K,convertModelToRatio:U,getDraggingRatio:W}}}const getNodeData=()=>({});var QSlider=createComponent({name:"QSlider",props:{...useSliderProps,modelValue:{required:!0,default:null,validator:e=>"number"===typeof e||null===e},labelValue:[String,Number]},emits:useSliderEmits,setup(e,{emit:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),{state:n,methods:a}=useSlider({updateValue:m,updatePosition:h,getDragging:f,formAttrs:useFormAttrs(e)}),l=vue.ref(null),r=vue.ref(0),i=vue.ref(0);function u(){i.value=null===e.modelValue?n.innerMin.value:between(e.modelValue,n.innerMin.value,n.innerMax.value)}vue.watch(()=>`${e.modelValue}|${n.innerMin.value}|${n.innerMax.value}`,u),u();const s=vue.computed(()=>a.convertModelToRatio(i.value)),c=vue.computed(()=>!0===n.active.value?r.value:s.value),d=vue.computed(()=>{const t={[n.positionProp.value]:`${100*n.innerMinRatio.value}%`,[n.sizeProp.value]:`${100*(c.value-n.innerMinRatio.value)}%`};return void 0!==e.selectionImg&&(t.backgroundImage=`url(${e.selectionImg}) !important`),t}),v=a.getThumbRenderFn({focusValue:!0,getNodeData:getNodeData,ratio:c,label:vue.computed(()=>void 0!==e.labelValue?e.labelValue:i.value),thumbColor:vue.computed(()=>e.thumbColor||e.color),labelColor:vue.computed(()=>e.labelColor),labelTextColor:vue.computed(()=>e.labelTextColor)}),p=vue.computed(()=>{return!0!==n.editable.value?{}:!0===o.platform.is.mobile?{onClick:a.onMobileClick}:{onMousedown:a.onActivate,onFocus:g,onBlur:a.onBlur,onKeydown:b,onKeyup:a.onKeyup}});function m(o){i.value!==e.modelValue&&t("update:modelValue",i.value),!0===o&&t("change",i.value)}function f(){return l.value.getBoundingClientRect()}function h(t,o=n.dragging.value){const l=a.getDraggingRatio(t,o);i.value=a.convertRatioToModel(l),r.value=!0!==e.snap||0===e.step?l:a.convertModelToRatio(i.value)}function g(){n.focus.value=!0}function b(t){if(!keyCodes$2.includes(t.keyCode))return;stopAndPrevent(t);const o=([34,33].includes(t.keyCode)?10:1)*n.step.value,a=([34,37,40].includes(t.keyCode)?-1:1)*(!0===n.isReversed.value?-1:1)*(!0===e.vertical?-1:1)*o;i.value=between(parseFloat((i.value+a).toFixed(n.decimals.value)),n.innerMin.value,n.innerMax.value),m()}return()=>{const t=a.getContent(d,n.tabindex,p,e=>{e.push(v())});return vue.h("div",{ref:l,class:n.classes.value+(null===e.modelValue?" q-slider--no-value":""),...n.attributes.value,"aria-valuenow":e.modelValue},t)}}});function useCanRender(){const e=vue.ref(!isRuntimeSsrPreHydration.value);return!1===e.value&&vue.onMounted(()=>{e.value=!0}),e}var QResizeObserver=createComponent({name:"QResizeObserver",props:{debounce:{type:[String,Number],default:100}},emits:["resize"],setup(e,{emit:t}){return noop}});function getIndicatorClass(e,t,o){const n=!0===o?["left","right"]:["top","bottom"];return`absolute-${!0===t?n[0]:n[1]}${e?` text-${e}`:""}`}const alignValues$1=["left","center","right","justify"];var QTabs=createComponent({name:"QTabs",props:{modelValue:[Number,String],align:{type:String,default:"center",validator:e=>alignValues$1.includes(e)},breakpoint:{type:[String,Number],default:600},vertical:Boolean,shrink:Boolean,stretch:Boolean,activeClass:String,activeColor:String,activeBgColor:String,indicatorColor:String,leftIcon:String,rightIcon:String,outsideArrows:Boolean,mobileArrows:Boolean,switchIndicator:Boolean,narrowIndicator:Boolean,inlineLabel:Boolean,noCaps:Boolean,dense:Boolean,contentClass:String,"onUpdate:modelValue":[Function,Array]},setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,{registerTick:l}=useTick(),{registerTick:r}=useTick(),{registerTick:i}=useTick(),{registerTimeout:u,removeTimeout:s}=useTimeout(),{registerTimeout:c,removeTimeout:d}=useTimeout(),v=vue.ref(null),p=vue.ref(null),m=vue.ref(e.modelValue),f=vue.ref(!1),h=vue.ref(!0),g=vue.ref(!1),b=vue.ref(!1),y=[],S=vue.ref(0),x=vue.ref(!1);let w,C=null,k=null;const _=vue.computed(()=>({activeClass:e.activeClass,activeColor:e.activeColor,activeBgColor:e.activeBgColor,indicatorClass:getIndicatorClass(e.indicatorColor,e.switchIndicator,e.vertical),narrowIndicator:e.narrowIndicator,inlineLabel:e.inlineLabel,noCaps:e.noCaps})),q=vue.computed(()=>{const e=S.value,t=m.value;for(let o=0;o<e;o++)if(y[o].name.value===t)return!0;return!1}),T=vue.computed(()=>{const t=!0===f.value?"left":!0===b.value?"justify":e.align;return`q-tabs__content--align-${t}`}),P=vue.computed(()=>"q-tabs row no-wrap items-center"+` q-tabs--${!0===f.value?"":"not-"}scrollable`+` q-tabs--${!0===e.vertical?"vertical":"horizontal"}`+` q-tabs__arrows--${!0===e.outsideArrows?"outside":"inside"}`+` q-tabs--mobile-with${!0===e.mobileArrows?"":"out"}-arrows`+(!0===e.dense?" q-tabs--dense":"")+(!0===e.shrink?" col-shrink":"")+(!0===e.stretch?" self-stretch":"")),M=vue.computed(()=>"q-tabs__content scroll--mobile row no-wrap items-center self-stretch hide-scrollbar relative-position "+T.value+(void 0!==e.contentClass?` ${e.contentClass}`:"")),$=vue.computed(()=>!0===e.vertical?{container:"height",content:"offsetHeight",scroll:"scrollHeight"}:{container:"width",content:"offsetWidth",scroll:"scrollWidth"}),Q=vue.computed(()=>!0!==e.vertical&&!0===a.lang.rtl),B=vue.computed(()=>!0===Q.value);function R({name:t,setCurrent:n,skipEmit:a}){m.value!==t&&(!0!==a&&void 0!==e["onUpdate:modelValue"]&&o("update:modelValue",t),!0!==n&&void 0!==e["onUpdate:modelValue"]||(E(m.value,t),m.value=t))}function A(){l(()=>{F({width:v.value.offsetWidth,height:v.value.offsetHeight})})}function F(t){if(void 0===$.value||null===p.value)return;const o=t[$.value.container],n=Math.min(p.value[$.value.scroll],Array.prototype.reduce.call(p.value.children,(e,t)=>e+(t[$.value.content]||0),0)),a=o>0&&n>o;f.value=a,!0===a&&r(I),b.value=o<parseInt(e.breakpoint,10)}function E(t,o){const n=void 0!==t&&null!==t&&""!==t?y.find(e=>e.name.value===t):null,a=void 0!==o&&null!==o&&""!==o?y.find(e=>e.name.value===o):null;if(n&&a){const t=n.tabIndicatorRef.value,o=a.tabIndicatorRef.value;null!==C&&(clearTimeout(C),C=null),t.style.transition="none",t.style.transform="none",o.style.transition="none",o.style.transform="none";const l=t.getBoundingClientRect(),r=o.getBoundingClientRect();o.style.transform=!0===e.vertical?`translate3d(0,${l.top-r.top}px,0) scale3d(1,${r.height?l.height/r.height:1},1)`:`translate3d(${l.left-r.left}px,0,0) scale3d(${r.width?l.width/r.width:1},1,1)`,i(()=>{C=setTimeout(()=>{C=null,o.style.transition="transform .25s cubic-bezier(.4, 0, .2, 1)",o.style.transform="none"},70)})}a&&!0===f.value&&D(a.rootRef.value)}function D(t){const{left:o,width:n,top:a,height:l}=p.value.getBoundingClientRect(),r=t.getBoundingClientRect();let i=!0===e.vertical?r.top-a:r.left-o;if(i<0)return p.value[!0===e.vertical?"scrollTop":"scrollLeft"]+=Math.floor(i),void I();i+=!0===e.vertical?r.height-l:r.width-n,i>0&&(p.value[!0===e.vertical?"scrollTop":"scrollLeft"]+=Math.ceil(i),I())}function I(){const t=p.value;if(null===t)return;const o=t.getBoundingClientRect(),n=!0===e.vertical?t.scrollTop:Math.abs(t.scrollLeft);!0===Q.value?(h.value=Math.ceil(n+o.width)<t.scrollWidth-1,g.value=n>0):(h.value=n>0,g.value=!0===e.vertical?Math.ceil(n+o.height)<t.scrollHeight:Math.ceil(n+o.width)<t.scrollWidth)}function O(e){null!==k&&clearInterval(k),k=setInterval(()=>{!0===j(e)&&L()},5)}function z(){O(!0===B.value?Number.MAX_SAFE_INTEGER:0)}function V(){O(!0===B.value?0:Number.MAX_SAFE_INTEGER)}function L(){null!==k&&(clearInterval(k),k=null)}function H(t,o){const n=Array.prototype.filter.call(p.value.children,e=>e===o||e.matches&&!0===e.matches(".q-tab.q-focusable")),a=n.length;if(0===a)return;if(36===t)return D(n[0]),n[0].focus(),!0;if(35===t)return D(n[a-1]),n[a-1].focus(),!0;const l=t===(!0===e.vertical?38:37),r=t===(!0===e.vertical?40:39),i=!0===l?-1:!0===r?1:void 0;if(void 0!==i){const e=!0===Q.value?-1:1,t=n.indexOf(o)+i*e;return t>=0&&t<a&&(D(n[t]),n[t].focus({preventScroll:!0})),!0}}vue.watch(Q,I),vue.watch(()=>e.modelValue,e=>{R({name:e,setCurrent:!0,skipEmit:!0})}),vue.watch(()=>e.outsideArrows,A);const N=vue.computed(()=>!0===B.value?{get:e=>Math.abs(e.scrollLeft),set:(e,t)=>{e.scrollLeft=-t}}:!0===e.vertical?{get:e=>e.scrollTop,set:(e,t)=>{e.scrollTop=t}}:{get:e=>e.scrollLeft,set:(e,t)=>{e.scrollLeft=t}});function j(e){const t=p.value,{get:o,set:n}=N.value;let a=!1,l=o(t);const r=e<l?-1:1;return l+=5*r,l<0?(a=!0,l=0):(-1===r&&l<=e||1===r&&l>=e)&&(a=!0,l=e),n(t,l),I(),a}function K(e,t){for(const o in e)if(e[o]!==t[o])return!1;return!0}function U(){let e=null,t={matchedLen:0,queryDiff:9999,hrefLen:0};const o=y.filter(e=>void 0!==e.routeData&&!0===e.routeData.hasRouterLink.value),{hash:a,query:l}=n.$route,r=Object.keys(l).length;for(const n of o){const o=!0===n.routeData.exact.value;if(!0!==n.routeData[!0===o?"linkIsExactActive":"linkIsActive"].value)continue;const{hash:i,query:u,matched:s,href:c}=n.routeData.resolvedLink.value,d=Object.keys(u).length;if(!0===o){if(i!==a)continue;if(d!==r||!1===K(l,u))continue;e=n.name.value;break}if(""!==i&&i!==a)continue;if(0!==d&&!1===K(u,l))continue;const v={matchedLen:s.length,queryDiff:r-d,hrefLen:c.length-i.length};if(v.matchedLen>t.matchedLen)e=n.name.value,t=v;else if(v.matchedLen===t.matchedLen){if(v.queryDiff<t.queryDiff)e=n.name.value,t=v;else if(v.queryDiff!==t.queryDiff)continue;v.hrefLen>t.hrefLen&&(e=n.name.value,t=v)}}null===e&&!0===y.some(e=>void 0===e.routeData&&e.name.value===m.value)||R({name:e,setCurrent:!0})}function W(e){if(s(),!0!==x.value&&null!==v.value&&e.target&&"function"===typeof e.target.closest){const t=e.target.closest(".q-tab");t&&!0===v.value.contains(t)&&(x.value=!0,!0===f.value&&D(t))}}function Y(){u(()=>{x.value=!1},30)}function G(){!1===ee.avoidRouteWatcher?c(U):d()}function X(){if(void 0===w){const e=vue.watch(()=>n.$route.fullPath,G);w=(()=>{e(),w=void 0})}}function Z(e){y.push(e),S.value++,A(),void 0===e.routeData||void 0===n.$route?c(()=>{if(!0===f.value){const e=m.value,t=void 0!==e&&null!==e&&""!==e?y.find(t=>t.name.value===e):null;t&&D(t.rootRef.value)}}):(X(),!0===e.routeData.hasRouterLink.value&&G())}function J(e){y.splice(y.indexOf(e),1),S.value--,A(),void 0!==w&&void 0!==e.routeData&&(!0===y.every(e=>void 0===e.routeData)&&w(),G())}const ee={currentModel:m,tabProps:_,hasFocus:x,hasActiveTab:q,registerTab:Z,unregisterTab:J,verifyRouteModel:G,updateModel:R,onKbdNavigate:H,avoidRouteWatcher:!1};function te(){null!==C&&clearTimeout(C),L(),void 0!==w&&w()}let oe;return vue.provide(tabsKey,ee),vue.onBeforeUnmount(te),vue.onDeactivated(()=>{oe=void 0!==w,te()}),vue.onActivated(()=>{!0===oe&&X(),A()}),()=>{return vue.h("div",{ref:v,class:P.value,role:"tablist",onFocusin:W,onFocusout:Y},[vue.h(QResizeObserver,{onResize:F}),vue.h("div",{ref:p,class:M.value,onScroll:I},hSlot(t.default)),vue.h(QIcon,{class:"q-tabs__arrow q-tabs__arrow--left absolute q-tab__icon"+(!0===h.value?"":" q-tabs__arrow--faded"),name:e.leftIcon||a.iconSet.tabs[!0===e.vertical?"up":"left"],onMousedownPassive:z,onTouchstartPassive:z,onMouseupPassive:L,onMouseleavePassive:L,onTouchendPassive:L}),vue.h(QIcon,{class:"q-tabs__arrow q-tabs__arrow--right absolute q-tab__icon"+(!0===g.value?"":" q-tabs__arrow--faded"),name:e.rightIcon||a.iconSet.tabs[!0===e.vertical?"down":"right"],onMousedownPassive:V,onTouchstartPassive:V,onMouseupPassive:L,onMouseleavePassive:L,onTouchendPassive:L})])}}});let id$1=0;const useTabEmits=["click","keydown"],useTabProps={icon:String,label:[Number,String],alert:[Boolean,String],alertIcon:String,name:{type:[Number,String],default:()=>`t_${id$1++}`},noCaps:Boolean,tabindex:[String,Number],disable:Boolean,contentClass:String,ripple:{type:[Boolean,Object],default:!0}};function useTab(e,t,o,n){const a=vue.inject(tabsKey,emptyRenderFn);if(a===emptyRenderFn)return console.error("QTab/QRouteTab component needs to be child of QTabs"),emptyRenderFn;const{proxy:l}=vue.getCurrentInstance(),r=vue.ref(null),i=vue.ref(null),u=vue.ref(null),s=vue.computed(()=>!0!==e.disable&&!1!==e.ripple&&Object.assign({keyCodes:[13,32],early:!0},!0===e.ripple?{}:e.ripple)),c=vue.computed(()=>a.currentModel.value===e.name),d=vue.computed(()=>"q-tab relative-position self-stretch flex flex-center text-center"+(!0===c.value?" q-tab--active"+(a.tabProps.value.activeClass?" "+a.tabProps.value.activeClass:"")+(a.tabProps.value.activeColor?` text-${a.tabProps.value.activeColor}`:"")+(a.tabProps.value.activeBgColor?` bg-${a.tabProps.value.activeBgColor}`:""):" q-tab--inactive")+(e.icon&&e.label&&!1===a.tabProps.value.inlineLabel?" q-tab--full":"")+(!0===e.noCaps||!0===a.tabProps.value.noCaps?" q-tab--no-caps":"")+(!0===e.disable?" disabled":" q-focusable q-hoverable cursor-pointer")+(void 0!==n?n.linkClass.value:"")),v=vue.computed(()=>"q-tab__content self-stretch flex-center relative-position q-anchor--skip non-selectable "+(!0===a.tabProps.value.inlineLabel?"row no-wrap q-tab__content--inline":"column")+(void 0!==e.contentClass?` ${e.contentClass}`:"")),p=vue.computed(()=>!0===e.disable||!0===a.hasFocus.value||!1===c.value&&!0===a.hasActiveTab.value?-1:e.tabindex||0);function m(t,l){if(!0!==l&&null!==r.value&&r.value.focus(),!0!==e.disable){if(void 0===n)return a.updateModel({name:e.name}),void o("click",t);if(!0===n.hasRouterLink.value){const l=(o={})=>{let l;const r=void 0===o.to||!0===isDeepEqual(o.to,e.to)?a.avoidRouteWatcher=uid():null;return n.navigateToRouterLink(t,{...o,returnRouterError:!0}).catch(e=>{l=e}).then(t=>{if(r===a.avoidRouteWatcher&&(a.avoidRouteWatcher=!1,void 0!==l||void 0!==t&&!0!==t.message.startsWith("Avoided redundant navigation")||a.updateModel({name:e.name})),!0===o.returnRouterError)return void 0!==l?Promise.reject(l):t})};return o("click",t,l),void(!0!==t.defaultPrevented&&l())}o("click",t)}else void 0!==n&&!0===n.hasRouterLink.value&&stopAndPrevent(t)}function f(e){isKeyCode(e,[13,32])?m(e,!0):!0!==shouldIgnoreKey(e)&&e.keyCode>=35&&e.keyCode<=40&&!0!==e.altKey&&!0!==e.metaKey&&!0===a.onKbdNavigate(e.keyCode,l.$el)&&stopAndPrevent(e),o("keydown",e)}function h(){const o=a.tabProps.value.narrowIndicator,n=[],l=vue.h("div",{ref:u,class:["q-tab__indicator",a.tabProps.value.indicatorClass]});void 0!==e.icon&&n.push(vue.h(QIcon,{class:"q-tab__icon",name:e.icon})),void 0!==e.label&&n.push(vue.h("div",{class:"q-tab__label"},e.label)),!1!==e.alert&&n.push(void 0!==e.alertIcon?vue.h(QIcon,{class:"q-tab__alert-icon",color:!0!==e.alert?e.alert:void 0,name:e.alertIcon}):vue.h("div",{class:"q-tab__alert"+(!0!==e.alert?` text-${e.alert}`:"")})),!0===o&&n.push(l);const i=[vue.h("div",{class:"q-focus-helper",tabindex:-1,ref:r}),vue.h("div",{class:v.value},hMergeSlot(t.default,n))];return!1===o&&i.push(l),i}const g={name:vue.computed(()=>e.name),rootRef:i,tabIndicatorRef:u,routeData:n};function b(t,o){const n={ref:i,class:d.value,tabindex:p.value,role:"tab","aria-selected":!0===c.value?"true":"false","aria-disabled":!0===e.disable?"true":void 0,onClick:m,onKeydown:f,...o};return vue.withDirectives(vue.h(t,n,h()),[[Ripple,s.value]])}return vue.onBeforeUnmount(()=>{a.unregisterTab(g)}),vue.onMounted(()=>{a.registerTab(g)}),{renderTab:b,$tabs:a}}var QTab=createComponent({name:"QTab",props:useTabProps,emits:useTabEmits,setup(e,{slots:t,emit:o}){const{renderTab:n}=useTab(e,t,o);return()=>n("div")}}),QTabPanels=createComponent({name:"QTabPanels",props:{...usePanelProps,...useDarkProps},emits:usePanelEmits,setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),{updatePanelsList:a,getPanelContent:l,panelDirectives:r}=usePanel(),i=vue.computed(()=>"q-tab-panels q-panel-parent"+(!0===n.value?" q-tab-panels--dark q-dark":""));return()=>{return a(t),hDir("div",{class:i.value},l(),"pan",e.swipeable,()=>r.value)}}}),QTabPanel=createComponent({name:"QTabPanel",props:usePanelChildProps,setup(e,{slots:t}){return()=>vue.h("div",{class:"q-tab-panel",role:"tabpanel"},hSlot(t.default))}});const hex=/^#[0-9a-fA-F]{3}([0-9a-fA-F]{3})?$/,hexa=/^#[0-9a-fA-F]{4}([0-9a-fA-F]{4})?$/,hexOrHexa=/^#([0-9a-fA-F]{3}|[0-9a-fA-F]{4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/,rgb=/^rgb\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5])\)$/,rgba=/^rgba\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/,testPattern={date:e=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(e),time:e=>/^([0-1]?\d|2[0-3]):[0-5]\d$/.test(e),fulltime:e=>/^([0-1]?\d|2[0-3]):[0-5]\d:[0-5]\d$/.test(e),timeOrFulltime:e=>/^([0-1]?\d|2[0-3]):[0-5]\d(:[0-5]\d)?$/.test(e),email:e=>/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(e),hexColor:e=>hex.test(e),hexaColor:e=>hexa.test(e),hexOrHexaColor:e=>hexOrHexa.test(e),rgbColor:e=>rgb.test(e),rgbaColor:e=>rgba.test(e),rgbOrRgbaColor:e=>rgb.test(e)||rgba.test(e),hexOrRgbColor:e=>hex.test(e)||rgb.test(e),hexaOrRgbaColor:e=>hexa.test(e)||rgba.test(e),anyColor:e=>hexOrHexa.test(e)||rgb.test(e)||rgba.test(e)};var patterns={testPattern:testPattern};const reRGBA=/^rgb(a)?\((\d{1,3}),(\d{1,3}),(\d{1,3}),?([01]?\.?\d*?)?\)$/;function rgbToHex({r:e,g:t,b:o,a:n}){const a=void 0!==n;if(e=Math.round(e),t=Math.round(t),o=Math.round(o),e>255||t>255||o>255||a&&n>100)throw new TypeError("Expected 3 numbers below 256 (and optionally one below 100)");return n=a?(256|Math.round(255*n/100)).toString(16).slice(1):"","#"+(o|t<<8|e<<16|1<<24).toString(16).slice(1)+n}function rgbToString({r:e,g:t,b:o,a:n}){return`rgb${void 0!==n?"a":""}(${e},${t},${o}${void 0!==n?","+n/100:""})`}function hexToRgb(e){if("string"!==typeof e)throw new TypeError("Expected a string");e=e.replace(/^#/,""),3===e.length?e=e[0]+e[0]+e[1]+e[1]+e[2]+e[2]:4===e.length&&(e=e[0]+e[0]+e[1]+e[1]+e[2]+e[2]+e[3]+e[3]);const t=parseInt(e,16);return e.length>6?{r:t>>24&255,g:t>>16&255,b:t>>8&255,a:Math.round((255&t)/2.55)}:{r:t>>16,g:t>>8&255,b:255&t}}function hsvToRgb({h:e,s:t,v:o,a:n}){let a,l,r;t/=100,o/=100,e/=360;const i=Math.floor(6*e),u=6*e-i,s=o*(1-t),c=o*(1-u*t),d=o*(1-(1-u)*t);switch(i%6){case 0:a=o,l=d,r=s;break;case 1:a=c,l=o,r=s;break;case 2:a=s,l=o,r=d;break;case 3:a=s,l=c,r=o;break;case 4:a=d,l=s,r=o;break;case 5:a=o,l=s,r=c;break}return{r:Math.round(255*a),g:Math.round(255*l),b:Math.round(255*r),a:n}}function rgbToHsv({r:e,g:t,b:o,a:n}){const a=Math.max(e,t,o),l=Math.min(e,t,o),r=a-l,i=0===a?0:r/a,u=a/255;let s;switch(a){case l:s=0;break;case e:s=t-o+r*(t<o?6:0),s/=6*r;break;case t:s=o-e+2*r,s/=6*r;break;case o:s=e-t+4*r,s/=6*r;break}return{h:Math.round(360*s),s:Math.round(100*i),v:Math.round(100*u),a:n}}function textToRgb(e){if("string"!==typeof e)throw new TypeError("Expected a string");const t=e.replace(/ /g,""),o=reRGBA.exec(t);if(null===o)return hexToRgb(t);const n={r:Math.min(255,parseInt(o[2],10)),g:Math.min(255,parseInt(o[3],10)),b:Math.min(255,parseInt(o[4],10))};if(o[1]){const e=parseFloat(o[5]);n.a=100*Math.min(1,!0===isNaN(e)?1:e)}return n}function lighten(e,t){if("string"!==typeof e)throw new TypeError("Expected a string as color");if("number"!==typeof t)throw new TypeError("Expected a numeric percent");const o=textToRgb(e),n=t<0?0:255,a=Math.abs(t)/100,l=o.r,r=o.g,i=o.b;return"#"+(16777216+65536*(Math.round((n-l)*a)+l)+256*(Math.round((n-r)*a)+r)+(Math.round((n-i)*a)+i)).toString(16).slice(1)}function luminosity(e){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const t="string"===typeof e?textToRgb(e):e,o=t.r/255,n=t.g/255,a=t.b/255,l=o<=.03928?o/12.92:Math.pow((o+.055)/1.055,2.4),r=n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4),i=a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4);return.2126*l+.7152*r+.0722*i}function brightness(e){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const t="string"===typeof e?textToRgb(e):e;return(299*t.r+587*t.g+114*t.b)/1e3}function blend(e,t){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as fgColor");if("string"!==typeof t&&(!t||void 0===t.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as bgColor");const o="string"===typeof e?textToRgb(e):e,n=o.r/255,a=o.g/255,l=o.b/255,r=void 0!==o.a?o.a/100:1,i="string"===typeof t?textToRgb(t):t,u=i.r/255,s=i.g/255,c=i.b/255,d=void 0!==i.a?i.a/100:1,v=r+d*(1-r),p=Math.round((n*r+u*d*(1-r))/v*255),m=Math.round((a*r+s*d*(1-r))/v*255),f=Math.round((l*r+c*d*(1-r))/v*255),h={r:p,g:m,b:f,a:Math.round(100*v)};return"string"===typeof e?rgbToHex(h):h}function changeAlpha(e,t){if("string"!==typeof e)throw new TypeError("Expected a string as color");if(void 0===t||t<-1||t>1)throw new TypeError("Expected offset to be between -1 and 1");const{r:o,g:n,b:a,a:l}=textToRgb(e),r=void 0!==l?l/100:0;return rgbToHex({r:o,g:n,b:a,a:Math.round(100*Math.min(1,Math.max(0,r+t)))})}function getPaletteColor(e){if("string"!==typeof e)throw new TypeError("Expected a string as color");const t=document.createElement("div");t.className=`text-${e} invisible fixed no-pointer-events`,document.body.appendChild(t);const o=getComputedStyle(t).getPropertyValue("color");return t.remove(),rgbToHex(textToRgb(o))}var colors={rgbToHex:rgbToHex,hexToRgb:hexToRgb,hsvToRgb:hsvToRgb,rgbToHsv:rgbToHsv,textToRgb:textToRgb,lighten:lighten,luminosity:luminosity,brightness:brightness,blend:blend,changeAlpha:changeAlpha,getPaletteColor:getPaletteColor};const palette=["rgb(255,204,204)","rgb(255,230,204)","rgb(255,255,204)","rgb(204,255,204)","rgb(204,255,230)","rgb(204,255,255)","rgb(204,230,255)","rgb(204,204,255)","rgb(230,204,255)","rgb(255,204,255)","rgb(255,153,153)","rgb(255,204,153)","rgb(255,255,153)","rgb(153,255,153)","rgb(153,255,204)","rgb(153,255,255)","rgb(153,204,255)","rgb(153,153,255)","rgb(204,153,255)","rgb(255,153,255)","rgb(255,102,102)","rgb(255,179,102)","rgb(255,255,102)","rgb(102,255,102)","rgb(102,255,179)","rgb(102,255,255)","rgb(102,179,255)","rgb(102,102,255)","rgb(179,102,255)","rgb(255,102,255)","rgb(255,51,51)","rgb(255,153,51)","rgb(255,255,51)","rgb(51,255,51)","rgb(51,255,153)","rgb(51,255,255)","rgb(51,153,255)","rgb(51,51,255)","rgb(153,51,255)","rgb(255,51,255)","rgb(255,0,0)","rgb(255,128,0)","rgb(255,255,0)","rgb(0,255,0)","rgb(0,255,128)","rgb(0,255,255)","rgb(0,128,255)","rgb(0,0,255)","rgb(128,0,255)","rgb(255,0,255)","rgb(245,0,0)","rgb(245,123,0)","rgb(245,245,0)","rgb(0,245,0)","rgb(0,245,123)","rgb(0,245,245)","rgb(0,123,245)","rgb(0,0,245)","rgb(123,0,245)","rgb(245,0,245)","rgb(214,0,0)","rgb(214,108,0)","rgb(214,214,0)","rgb(0,214,0)","rgb(0,214,108)","rgb(0,214,214)","rgb(0,108,214)","rgb(0,0,214)","rgb(108,0,214)","rgb(214,0,214)","rgb(163,0,0)","rgb(163,82,0)","rgb(163,163,0)","rgb(0,163,0)","rgb(0,163,82)","rgb(0,163,163)","rgb(0,82,163)","rgb(0,0,163)","rgb(82,0,163)","rgb(163,0,163)","rgb(92,0,0)","rgb(92,46,0)","rgb(92,92,0)","rgb(0,92,0)","rgb(0,92,46)","rgb(0,92,92)","rgb(0,46,92)","rgb(0,0,92)","rgb(46,0,92)","rgb(92,0,92)","rgb(255,255,255)","rgb(205,205,205)","rgb(178,178,178)","rgb(153,153,153)","rgb(127,127,127)","rgb(102,102,102)","rgb(76,76,76)","rgb(51,51,51)","rgb(25,25,25)","rgb(0,0,0)"],thumbPath="M5 5 h10 v10 h-10 v-10 z",alphaTrackImg="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAH0lEQVQoU2NkYGAwZkAFZ5G5jPRRgOYEVDeB3EBjBQBOZwTVugIGyAAAAABJRU5ErkJggg==";var QColor=createComponent({name:"QColor",props:{...useDarkProps,...useFormProps,modelValue:String,defaultValue:String,defaultView:{type:String,default:"spectrum",validator:e=>["spectrum","tune","palette"].includes(e)},formatModel:{type:String,default:"auto",validator:e=>["auto","hex","rgb","hexa","rgba"].includes(e)},palette:Array,noHeader:Boolean,noHeaderTabs:Boolean,noFooter:Boolean,square:Boolean,flat:Boolean,bordered:Boolean,disable:Boolean,readonly:Boolean},emits:["update:modelValue","change"],setup(e,{emit:t}){const{proxy:o}=vue.getCurrentInstance(),{$q:n}=o,a=useDark(e,n),{getCache:l}=useCache(),r=vue.ref(null),i=vue.ref(null),u=vue.computed(()=>"auto"===e.formatModel?null:e.formatModel.indexOf("hex")>-1),s=vue.computed(()=>"auto"===e.formatModel?null:e.formatModel.indexOf("a")>-1),c=vue.ref("auto"===e.formatModel?void 0===e.modelValue||null===e.modelValue||""===e.modelValue||e.modelValue.startsWith("#")?"hex":"rgb":e.formatModel.startsWith("hex")?"hex":"rgb"),d=vue.ref(e.defaultView),v=vue.ref(P(e.modelValue||e.defaultValue)),p=vue.computed(()=>!0!==e.disable&&!0!==e.readonly),m=vue.computed(()=>void 0===e.modelValue||null===e.modelValue||""===e.modelValue||e.modelValue.startsWith("#")),f=vue.computed(()=>null!==u.value?u.value:m.value),h=vue.computed(()=>({type:"hidden",name:e.name,value:v.value[!0===f.value?"hex":"rgb"]})),g=useFormInject(h),b=vue.computed(()=>null!==s.value?s.value:void 0!==v.value.a),y=vue.computed(()=>({backgroundColor:v.value.rgb||"#000"})),S=vue.computed(()=>{const e=void 0!==v.value.a&&v.value.a<65||luminosity(v.value)>.4;return"q-color-picker__header-content"+` q-color-picker__header-content--${e?"light":"dark"}`}),x=vue.computed(()=>({background:`hsl(${v.value.h},100%,50%)`})),w=vue.computed(()=>({top:`${100-v.value.v}%`,[!0===n.lang.rtl?"right":"left"]:`${v.value.s}%`})),C=vue.computed(()=>void 0!==e.palette&&0!==e.palette.length?e.palette:palette),k=vue.computed(()=>"q-color-picker"+(!0===e.bordered?" q-color-picker--bordered":"")+(!0===e.square?" q-color-picker--square no-border-radius":"")+(!0===e.flat?" q-color-picker--flat no-shadow":"")+(!0===e.disable?" disabled":"")+(!0===a.value?" q-color-picker--dark q-dark":"")),_=vue.computed(()=>{return!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{}}),q=vue.computed(()=>{return[[TouchPan,A,void 0,{prevent:!0,stop:!0,mouse:!0}]]});function T(e,o){v.value.hex=rgbToHex(e),v.value.rgb=rgbToString(e),v.value.r=e.r,v.value.g=e.g,v.value.b=e.b,v.value.a=e.a;const n=v.value[!0===f.value?"hex":"rgb"];t("update:modelValue",n),!0===o&&t("change",n)}function P(t){const o=void 0!==s.value?s.value:"auto"===e.formatModel?null:e.formatModel.indexOf("a")>-1;if("string"!==typeof t||0===t.length||!0!==testPattern.anyColor(t.replace(/ /g,"")))return{h:0,s:0,v:0,r:0,g:0,b:0,a:!0===o?100:void 0,hex:void 0,rgb:void 0};const n=textToRgb(t);return!0===o&&void 0===n.a&&(n.a=100),n.hex=rgbToHex(n),n.rgb=rgbToString(n),Object.assign(n,rgbToHsv(n))}function M(e,t,o){const a=r.value;if(null===a)return;const l=a.clientWidth,i=a.clientHeight,u=a.getBoundingClientRect();let s=Math.min(l,Math.max(0,e-u.left));!0===n.lang.rtl&&(s=l-s);const c=Math.min(i,Math.max(0,t-u.top)),d=Math.round(100*s/l),p=Math.round(100*Math.max(0,Math.min(1,-c/i+1))),m=hsvToRgb({h:v.value.h,s:d,v:p,a:!0===b.value?v.value.a:void 0});v.value.s=d,v.value.v=p,T(m,o)}function $(e,t){const o=Math.round(e),n=hsvToRgb({h:o,s:v.value.s,v:v.value.v,a:!0===b.value?v.value.a:void 0});v.value.h=o,T(n,t)}function Q(e,t,n,a,l){if(void 0!==a&&stop(a),!/^[0-9]+$/.test(e))return void(!0===l&&o.$forceUpdate());const r=Math.floor(Number(e));if(r<0||r>n)return void(!0===l&&o.$forceUpdate());const i={r:"r"===t?r:v.value.r,g:"g"===t?r:v.value.g,b:"b"===t?r:v.value.b,a:!0===b.value?"a"===t?r:v.value.a:void 0};if("a"!==t){const e=rgbToHsv(i);v.value.h=e.h,v.value.s=e.s,v.value.v=e.v}if(T(i,l),void 0!==a&&!0!==l&&void 0!==a.target.selectionEnd){const e=a.target.selectionEnd;vue.nextTick(()=>{a.target.setSelectionRange(e,e)})}}function B(e,t){let o;const n=e.target.value;if(stop(e),"hex"===c.value){if(n.length!==(!0===b.value?9:7)||!/^#[0-9A-Fa-f]+$/.test(n))return!0;o=hexToRgb(n)}else{let e;if(!n.endsWith(")"))return!0;if(!0!==b.value&&n.startsWith("rgb(")){if(e=n.substring(4,n.length-1).split(",").map(e=>parseInt(e,10)),3!==e.length||!/^rgb\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3}\)$/.test(n))return!0}else{if(!0!==b.value||!n.startsWith("rgba("))return!0;{if(e=n.substring(5,n.length-1).split(","),4!==e.length||!/^rgba\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3},(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/.test(n))return!0;for(let o=0;o<3;o++){const t=parseInt(e[o],10);if(t<0||t>255)return!0;e[o]=t}const t=parseFloat(e[3]);if(t<0||t>1)return!0;e[3]=t}}if(e[0]<0||e[0]>255||e[1]<0||e[1]>255||e[2]<0||e[2]>255||!0===b.value&&(e[3]<0||e[3]>1))return!0;o={r:e[0],g:e[1],b:e[2],a:!0===b.value?100*e[3]:void 0}}const a=rgbToHsv(o);if(v.value.h=a.h,v.value.s=a.s,v.value.v=a.v,T(o,t),!0!==t){const t=e.target.selectionEnd;vue.nextTick(()=>{e.target.setSelectionRange(t,t)})}}function R(e){const t=P(e),o={r:t.r,g:t.g,b:t.b,a:t.a};void 0===o.a&&(o.a=v.value.a),v.value.h=t.h,v.value.s=t.s,v.value.v=t.v,T(o,!0)}function A(e){e.isFinal?M(e.position.left,e.position.top,!0):F(e)}vue.watch(()=>e.modelValue,t=>{const o=P(t||e.defaultValue);o.hex!==v.value.hex&&(v.value=o)}),vue.watch(()=>e.defaultValue,t=>{if(!e.modelValue&&t){const e=P(t);e.hex!==v.value.hex&&(v.value=e)}});const F=throttle(e=>{M(e.position.left,e.position.top)},20);function E(e){M(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset,!0)}function D(e){M(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset)}function I(e){null!==i.value&&(i.value.$el.style.opacity=e?1:0)}function O(){const t=[];return!0!==e.noHeaderTabs&&t.push(vue.h(QTabs,{class:"q-color-picker__header-tabs",modelValue:c.value,dense:!0,align:"justify",...l("topVTab",{"onUpdate:modelValue":e=>{c.value=e}})},()=>[vue.h(QTab,{label:"HEX"+(!0===b.value?"A":""),name:"hex",ripple:!1}),vue.h(QTab,{label:"RGB"+(!0===b.value?"A":""),name:"rgb",ripple:!1})])),t.push(vue.h("div",{class:"q-color-picker__header-banner row flex-center no-wrap"},[vue.h("input",{class:"fit",value:v.value[c.value],...!0!==p.value?{readonly:!0}:{},...l("topIn",{onInput:e=>{I(!0===B(e))},onChange:stop,onBlur:e=>{!0===B(e,!0)&&o.$forceUpdate(),I(!1)}})}),vue.h(QIcon,{ref:i,class:"q-color-picker__error-icon absolute no-pointer-events",name:n.iconSet.type.negative})])),vue.h("div",{class:"q-color-picker__header relative-position overflow-hidden"},[vue.h("div",{class:"q-color-picker__header-bg absolute-full"}),vue.h("div",{class:S.value,style:y.value},t)])}function z(){return vue.h(QTabPanels,{modelValue:d.value,animated:!0},()=>[vue.h(QTabPanel,{class:"q-color-picker__spectrum-tab overflow-hidden",name:"spectrum"},L),vue.h(QTabPanel,{class:"q-pa-md q-color-picker__tune-tab",name:"tune"},H),vue.h(QTabPanel,{class:"q-color-picker__palette-tab",name:"palette"},N)])}function V(){return vue.h("div",{class:"q-color-picker__footer relative-position overflow-hidden"},[vue.h(QTabs,{class:"absolute-full",modelValue:d.value,dense:!0,align:"justify",...l("ftIn",{"onUpdate:modelValue":e=>{d.value=e}})},()=>[vue.h(QTab,{icon:n.iconSet.colorPicker.spectrum,name:"spectrum",ripple:!1}),vue.h(QTab,{icon:n.iconSet.colorPicker.tune,name:"tune",ripple:!1}),vue.h(QTab,{icon:n.iconSet.colorPicker.palette,name:"palette",ripple:!1})])])}function L(){const e={ref:r,class:"q-color-picker__spectrum non-selectable relative-position cursor-pointer"+(!0!==p.value?" readonly":""),style:x.value,...!0===p.value?{onClick:E,onMousedown:D}:{}},t=[vue.h("div",{style:{paddingBottom:"100%"}}),vue.h("div",{class:"q-color-picker__spectrum-white absolute-full"}),vue.h("div",{class:"q-color-picker__spectrum-black absolute-full"}),vue.h("div",{class:"absolute",style:w.value},[void 0!==v.value.hex?vue.h("div",{class:"q-color-picker__spectrum-circle"}):null])],o=[vue.h(QSlider,{class:"q-color-picker__hue non-selectable",modelValue:v.value.h,min:0,max:360,trackSize:"8px",innerTrackColor:"transparent",selectionColor:"transparent",readonly:!0!==p.value,thumbPath:thumbPath,"onUpdate:modelValue":$,...l("lazyhue",{onChange:e=>$(e,!0)})})];return!0===b.value&&o.push(vue.h(QSlider,{class:"q-color-picker__alpha non-selectable",modelValue:v.value.a,min:0,max:100,trackSize:"8px",trackColor:"white",innerTrackColor:"transparent",selectionColor:"transparent",trackImg:alphaTrackImg,readonly:!0!==p.value,hideSelection:!0,thumbPath:thumbPath,...l("alphaSlide",{"onUpdate:modelValue":e=>Q(e,"a",100),onChange:e=>Q(e,"a",100,void 0,!0)})})),[hDir("div",e,t,"spec",p.value,()=>q.value),vue.h("div",{class:"q-color-picker__sliders"},o)]}function H(){return[vue.h("div",{class:"row items-center no-wrap"},[vue.h("div","R"),vue.h(QSlider,{modelValue:v.value.r,min:0,max:255,color:"red",dark:a.value,readonly:!0!==p.value,...l("rSlide",{"onUpdate:modelValue":e=>Q(e,"r",255),onChange:e=>Q(e,"r",255,void 0,!0)})}),vue.h("input",{value:v.value.r,maxlength:3,readonly:!0!==p.value,onChange:stop,...l("rIn",{onInput:e=>Q(e.target.value,"r",255,e),onBlur:e=>Q(e.target.value,"r",255,e,!0)})})]),vue.h("div",{class:"row items-center no-wrap"},[vue.h("div","G"),vue.h(QSlider,{modelValue:v.value.g,min:0,max:255,color:"green",dark:a.value,readonly:!0!==p.value,...l("gSlide",{"onUpdate:modelValue":e=>Q(e,"g",255),onChange:e=>Q(e,"g",255,void 0,!0)})}),vue.h("input",{value:v.value.g,maxlength:3,readonly:!0!==p.value,onChange:stop,...l("gIn",{onInput:e=>Q(e.target.value,"g",255,e),onBlur:e=>Q(e.target.value,"g",255,e,!0)})})]),vue.h("div",{class:"row items-center no-wrap"},[vue.h("div","B"),vue.h(QSlider,{modelValue:v.value.b,min:0,max:255,color:"blue",readonly:!0!==p.value,dark:a.value,...l("bSlide",{"onUpdate:modelValue":e=>Q(e,"b",255),onChange:e=>Q(e,"b",255,void 0,!0)})}),vue.h("input",{value:v.value.b,maxlength:3,readonly:!0!==p.value,onChange:stop,...l("bIn",{onInput:e=>Q(e.target.value,"b",255,e),onBlur:e=>Q(e.target.value,"b",255,e,!0)})})]),!0===b.value?vue.h("div",{class:"row items-center no-wrap"},[vue.h("div","A"),vue.h(QSlider,{modelValue:v.value.a,color:"grey",readonly:!0!==p.value,dark:a.value,...l("aSlide",{"onUpdate:modelValue":e=>Q(e,"a",100),onChange:e=>Q(e,"a",100,void 0,!0)})}),vue.h("input",{value:v.value.a,maxlength:3,readonly:!0!==p.value,onChange:stop,...l("aIn",{onInput:e=>Q(e.target.value,"a",100,e),onBlur:e=>Q(e.target.value,"a",100,e,!0)})})]):null]}function N(){const e=e=>vue.h("div",{class:"q-color-picker__cube col-auto",style:{backgroundColor:e},...!0===p.value?l("palette#"+e,{onClick:()=>{R(e)}}):{}});return[vue.h("div",{class:"row items-center q-color-picker__palette-rows"+(!0===p.value?" q-color-picker__palette-rows--editable":"")},C.value.map(e))]}return()=>{const t=[z()];return void 0!==e.name&&!0!==e.disable&&g(t,"push"),!0!==e.noHeader&&t.unshift(O()),!0!==e.noFooter&&t.push(V()),vue.h("div",{class:k.value,..._.value},t)}}});const breaks=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178];function toJalaali(e,t,o){return"[object Date]"===Object.prototype.toString.call(e)&&(o=e.getDate(),t=e.getMonth()+1,e=e.getFullYear()),d2j(g2d(e,t,o))}function toGregorian(e,t,o){return d2g(j2d(e,t,o))}function isLeapJalaaliYear(e){return 0===jalCalLeap(e)}function jalaaliMonthLength(e,t){return t<=6?31:t<=11?30:isLeapJalaaliYear(e)?30:29}function jalCalLeap(e){const t=breaks.length;let o,n,a,l,r,i=breaks[0];if(e<i||e>=breaks[t-1])throw new Error("Invalid Jalaali year "+e);for(r=1;r<t;r+=1){if(o=breaks[r],n=o-i,e<o)break;i=o}return l=e-i,n-l<6&&(l=l-n+33*div(n+4,33)),a=mod(mod(l+1,33)-1,4),-1===a&&(a=4),a}function jalCal(e,t){const o=breaks.length,n=e+621;let a,l,r,i,u,s=-14,c=breaks[0];if(e<c||e>=breaks[o-1])throw new Error("Invalid Jalaali year "+e);for(u=1;u<o;u+=1){if(a=breaks[u],l=a-c,e<a)break;s=s+8*div(l,33)+div(mod(l,33),4),c=a}i=e-c,s=s+8*div(i,33)+div(mod(i,33)+3,4),4===mod(l,33)&&l-i===4&&(s+=1);const d=div(n,4)-div(3*(div(n,100)+1),4)-150,v=20+s-d;return t||(l-i<6&&(i=i-l+33*div(l+4,33)),r=mod(mod(i+1,33)-1,4),-1===r&&(r=4)),{leap:r,gy:n,march:v}}function j2d(e,t,o){const n=jalCal(e,!0);return g2d(n.gy,3,n.march)+31*(t-1)-div(t,7)*(t-7)+o-1}function d2j(e){const t=d2g(e).gy;let o,n,a,l=t-621;const r=jalCal(l,!1),i=g2d(t,3,r.march);if(a=e-i,a>=0){if(a<=185)return n=1+div(a,31),o=mod(a,31)+1,{jy:l,jm:n,jd:o};a-=186}else l-=1,a+=179,1===r.leap&&(a+=1);return n=7+div(a,30),o=mod(a,30)+1,{jy:l,jm:n,jd:o}}function g2d(e,t,o){let n=div(1461*(e+div(t-8,6)+100100),4)+div(153*mod(t+9,12)+2,5)+o-34840408;return n=n-div(3*div(e+100100+div(t-8,6),100),4)+752,n}function d2g(e){let t=4*e+139361631;t=t+4*div(3*div(4*e+183187720,146097),4)-3908;const o=5*div(mod(t,1461),4)+308,n=div(mod(o,153),5)+1,a=mod(div(o,153),12)+1,l=div(t,1461)-100100+div(8-a,6);return{gy:l,gm:a,gd:n}}function div(e,t){return~~(e/t)}function mod(e,t){return e-~~(e/t)*t}const calendars=["gregorian","persian"],useDatetimeProps={modelValue:{required:!0},mask:{type:String},locale:Object,calendar:{type:String,validator:e=>calendars.includes(e),default:"gregorian"},landscape:Boolean,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,readonly:Boolean,disable:Boolean},useDatetimeEmits=["update:modelValue"];function getDayHash(e){return e.year+"/"+pad(e.month)+"/"+pad(e.day)}function useDatetime(e,t){const o=vue.computed(()=>{return!0!==e.disable&&!0!==e.readonly}),n=vue.computed(()=>{return!0===o.value?0:-1}),a=vue.computed(()=>{const t=[];return void 0!==e.color&&t.push(`bg-${e.color}`),void 0!==e.textColor&&t.push(`text-${e.textColor}`),t.join(" ")});function l(){return void 0!==e.locale?{...t.lang.date,...e.locale}:t.lang.date}function r(t){const o=new Date,n=!0===t?null:0;if("persian"===e.calendar){const e=toJalaali(o);return{year:e.jy,month:e.jm,day:e.jd}}return{year:o.getFullYear(),month:o.getMonth()+1,day:o.getDate(),hour:n,minute:n,second:n,millisecond:n}}return{editable:o,tabindex:n,headerClass:a,getLocale:l,getCurrentDate:r}}const MILLISECONDS_IN_DAY=864e5,MILLISECONDS_IN_HOUR=36e5,MILLISECONDS_IN_MINUTE=6e4,defaultMask="YYYY-MM-DDTHH:mm:ss.SSSZ",token=/\[((?:[^\]\\]|\\]|\\)*)\]|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]/g,reverseToken=/(\[[^\]]*\])|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]|([.*+:?^,\s${}()|\\]+)/g,regexStore={};function getRegexData(e,t){const o="("+t.days.join("|")+")",n=e+o;if(void 0!==regexStore[n])return regexStore[n];const a="("+t.daysShort.join("|")+")",l="("+t.months.join("|")+")",r="("+t.monthsShort.join("|")+")",i={};let u=0;const s=e.replace(reverseToken,e=>{switch(u++,e){case"YY":return i.YY=u,"(-?\\d{1,2})";case"YYYY":return i.YYYY=u,"(-?\\d{1,4})";case"M":return i.M=u,"(\\d{1,2})";case"MM":return i.M=u,"(\\d{2})";case"MMM":return i.MMM=u,r;case"MMMM":return i.MMMM=u,l;case"D":return i.D=u,"(\\d{1,2})";case"Do":return i.D=u++,"(\\d{1,2}(st|nd|rd|th))";case"DD":return i.D=u,"(\\d{2})";case"H":return i.H=u,"(\\d{1,2})";case"HH":return i.H=u,"(\\d{2})";case"h":return i.h=u,"(\\d{1,2})";case"hh":return i.h=u,"(\\d{2})";case"m":return i.m=u,"(\\d{1,2})";case"mm":return i.m=u,"(\\d{2})";case"s":return i.s=u,"(\\d{1,2})";case"ss":return i.s=u,"(\\d{2})";case"S":return i.S=u,"(\\d{1})";case"SS":return i.S=u,"(\\d{2})";case"SSS":return i.S=u,"(\\d{3})";case"A":return i.A=u,"(AM|PM)";case"a":return i.a=u,"(am|pm)";case"aa":return i.aa=u,"(a\\.m\\.|p\\.m\\.)";case"ddd":return a;case"dddd":return o;case"Q":case"d":case"E":return"(\\d{1})";case"Qo":return"(1st|2nd|3rd|4th)";case"DDD":case"DDDD":return"(\\d{1,3})";case"w":return"(\\d{1,2})";case"ww":return"(\\d{2})";case"Z":return i.Z=u,"(Z|[+-]\\d{2}:\\d{2})";case"ZZ":return i.ZZ=u,"(Z|[+-]\\d{2}\\d{2})";case"X":return i.X=u,"(-?\\d+)";case"x":return i.x=u,"(-?\\d{4,})";default:return u--,"["===e[0]&&(e=e.substring(1,e.length-1)),e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}}),c={map:i,regex:new RegExp("^"+s)};return regexStore[n]=c,c}function getDateLocale(e,t){return void 0!==e?e:void 0!==t?t.date:defaultLang.date}function formatTimezone(e,t=""){const o=e>0?"-":"+",n=Math.abs(e),a=Math.floor(n/60),l=n%60;return o+pad(a)+t+pad(l)}function applyYearMonthDayChange(e,t,o){let n=e.getFullYear(),a=e.getMonth();const l=e.getDate();return void 0!==t.year&&(n+=o*t.year,delete t.year),void 0!==t.month&&(a+=o*t.month,delete t.month),e.setDate(1),e.setMonth(2),e.setFullYear(n),e.setMonth(a),e.setDate(Math.min(l,daysInMonth(e))),void 0!==t.date&&(e.setDate(e.getDate()+o*t.date),delete t.date),e}function applyYearMonthDay(e,t,o){const n=void 0!==t.year?t.year:e[`get${o}FullYear`](),a=void 0!==t.month?t.month-1:e[`get${o}Month`](),l=new Date(n,a+1,0).getDate(),r=Math.min(l,void 0!==t.date?t.date:e[`get${o}Date`]());return e[`set${o}Date`](1),e[`set${o}Month`](2),e[`set${o}FullYear`](n),e[`set${o}Month`](a),e[`set${o}Date`](r),delete t.year,delete t.month,delete t.date,e}function getChange(e,t,o){const n=normalizeMod(t),a=new Date(e),l=void 0!==n.year||void 0!==n.month||void 0!==n.date?applyYearMonthDayChange(a,n,o):a;for(const r in n){const e=capitalize(r);l[`set${e}`](l[`get${e}`]()+o*n[r])}return l}function normalizeMod(e){const t={...e};return void 0!==e.years&&(t.year=e.years,delete t.years),void 0!==e.months&&(t.month=e.months,delete t.months),void 0!==e.days&&(t.date=e.days,delete t.days),void 0!==e.day&&(t.date=e.day,delete t.day),void 0!==e.hour&&(t.hours=e.hour,delete t.hour),void 0!==e.minute&&(t.minutes=e.minute,delete t.minute),void 0!==e.second&&(t.seconds=e.second,delete t.second),void 0!==e.millisecond&&(t.milliseconds=e.millisecond,delete t.millisecond),t}function adjustDate(e,t,o){const n=normalizeMod(t),a=!0===o?"UTC":"",l=new Date(e),r=void 0!==n.year||void 0!==n.month||void 0!==n.date?applyYearMonthDay(l,n,a):l;for(const i in n){const e=i.charAt(0).toUpperCase()+i.slice(1);r[`set${a}${e}`](n[i])}return r}function extractDate(e,t,o){const n=__splitDate(e,t,o),a=new Date(n.year,null===n.month?null:n.month-1,null===n.day?1:n.day,n.hour,n.minute,n.second,n.millisecond),l=a.getTimezoneOffset();return null===n.timezoneOffset||n.timezoneOffset===l?a:getChange(a,{minutes:n.timezoneOffset-l},1)}function __splitDate(e,t,o,n,a){const l={year:null,month:null,day:null,hour:null,minute:null,second:null,millisecond:null,timezoneOffset:null,dateHash:null,timeHash:null};if(void 0!==a&&Object.assign(l,a),void 0===e||null===e||""===e||"string"!==typeof e)return l;void 0===t&&(t=defaultMask);const r=getDateLocale(o,Plugin$8.props),i=r.months,u=r.monthsShort,{regex:s,map:c}=getRegexData(t,r),d=e.match(s);if(null===d)return l;let v="";if(void 0!==c.X||void 0!==c.x){const e=parseInt(d[void 0!==c.X?c.X:c.x],10);if(!0===isNaN(e)||e<0)return l;const t=new Date(e*(void 0!==c.X?1e3:1));l.year=t.getFullYear(),l.month=t.getMonth()+1,l.day=t.getDate(),l.hour=t.getHours(),l.minute=t.getMinutes(),l.second=t.getSeconds(),l.millisecond=t.getMilliseconds()}else{if(void 0!==c.YYYY)l.year=parseInt(d[c.YYYY],10);else if(void 0!==c.YY){const e=parseInt(d[c.YY],10);l.year=e<0?e:2e3+e}if(void 0!==c.M){if(l.month=parseInt(d[c.M],10),l.month<1||l.month>12)return l}else void 0!==c.MMM?l.month=u.indexOf(d[c.MMM])+1:void 0!==c.MMMM&&(l.month=i.indexOf(d[c.MMMM])+1);if(void 0!==c.D){if(l.day=parseInt(d[c.D],10),null===l.year||null===l.month||l.day<1)return l;const e="persian"!==n?new Date(l.year,l.month,0).getDate():jalaaliMonthLength(l.year,l.month);if(l.day>e)return l}void 0!==c.H?l.hour=parseInt(d[c.H],10)%24:void 0!==c.h&&(l.hour=parseInt(d[c.h],10)%12,(c.A&&"PM"===d[c.A]||c.a&&"pm"===d[c.a]||c.aa&&"p.m."===d[c.aa])&&(l.hour+=12),l.hour=l.hour%24),void 0!==c.m&&(l.minute=parseInt(d[c.m],10)%60),void 0!==c.s&&(l.second=parseInt(d[c.s],10)%60),void 0!==c.S&&(l.millisecond=parseInt(d[c.S],10)*10**(3-d[c.S].length)),void 0===c.Z&&void 0===c.ZZ||(v=void 0!==c.Z?d[c.Z].replace(":",""):d[c.ZZ],l.timezoneOffset=("+"===v[0]?-1:1)*(60*v.slice(1,3)+1*v.slice(3,5)))}return l.dateHash=pad(l.year,6)+"/"+pad(l.month)+"/"+pad(l.day),l.timeHash=pad(l.hour)+":"+pad(l.minute)+":"+pad(l.second)+v,l}function isValid(e){return"number"===typeof e||!1===isNaN(Date.parse(e))}function buildDate(e,t){return adjustDate(new Date,e,t)}function getDayOfWeek(e){const t=new Date(e).getDay();return 0===t?7:t}function getWeekOfYear(e){const t=new Date(e.getFullYear(),e.getMonth(),e.getDate());t.setDate(t.getDate()-(t.getDay()+6)%7+3);const o=new Date(t.getFullYear(),0,4);o.setDate(o.getDate()-(o.getDay()+6)%7+3);const n=t.getTimezoneOffset()-o.getTimezoneOffset();t.setHours(t.getHours()-n);const a=(t-o)/(7*MILLISECONDS_IN_DAY);return 1+Math.floor(a)}function getDayIdentifier(e){return 1e4*e.getFullYear()+100*e.getMonth()+e.getDate()}function getDateIdentifier(e,t){const o=new Date(e);return!0===t?getDayIdentifier(o):o.getTime()}function isBetweenDates(e,t,o,n={}){const a=getDateIdentifier(t,n.onlyDate),l=getDateIdentifier(o,n.onlyDate),r=getDateIdentifier(e,n.onlyDate);return(r>a||!0===n.inclusiveFrom&&r===a)&&(r<l||!0===n.inclusiveTo&&r===l)}function addToDate(e,t){return getChange(e,t,1)}function subtractFromDate(e,t){return getChange(e,t,-1)}function startOfDate(e,t,o){const n=new Date(e),a=`set${!0===o?"UTC":""}`;switch(t){case"year":case"years":n[`${a}Month`](0);case"month":case"months":n[`${a}Date`](1);case"day":case"days":case"date":n[`${a}Hours`](0);case"hour":case"hours":n[`${a}Minutes`](0);case"minute":case"minutes":n[`${a}Seconds`](0);case"second":case"seconds":n[`${a}Milliseconds`](0)}return n}function endOfDate(e,t,o){const n=new Date(e),a=`set${!0===o?"UTC":""}`;switch(t){case"year":case"years":n[`${a}Month`](11);case"month":case"months":n[`${a}Date`](daysInMonth(n));case"day":case"days":case"date":n[`${a}Hours`](23);case"hour":case"hours":n[`${a}Minutes`](59);case"minute":case"minutes":n[`${a}Seconds`](59);case"second":case"seconds":n[`${a}Milliseconds`](999)}return n}function getMaxDate(e){let t=new Date(e);return Array.prototype.slice.call(arguments,1).forEach(e=>{t=Math.max(t,new Date(e))}),t}function getMinDate(e){let t=new Date(e);return Array.prototype.slice.call(arguments,1).forEach(e=>{t=Math.min(t,new Date(e))}),t}function getDiff(e,t,o){return(e.getTime()-e.getTimezoneOffset()*MILLISECONDS_IN_MINUTE-(t.getTime()-t.getTimezoneOffset()*MILLISECONDS_IN_MINUTE))/o}function getDateDiff(e,t,o="days"){const n=new Date(e),a=new Date(t);switch(o){case"years":case"year":return n.getFullYear()-a.getFullYear();case"months":case"month":return 12*(n.getFullYear()-a.getFullYear())+n.getMonth()-a.getMonth();case"days":case"day":case"date":return getDiff(startOfDate(n,"day"),startOfDate(a,"day"),MILLISECONDS_IN_DAY);case"hours":case"hour":return getDiff(startOfDate(n,"hour"),startOfDate(a,"hour"),MILLISECONDS_IN_HOUR);case"minutes":case"minute":return getDiff(startOfDate(n,"minute"),startOfDate(a,"minute"),MILLISECONDS_IN_MINUTE);case"seconds":case"second":return getDiff(startOfDate(n,"second"),startOfDate(a,"second"),1e3)}}function getDayOfYear(e){return getDateDiff(e,startOfDate(e,"year"),"days")+1}function inferDateFormat(e){return!0===isDate(e)?"date":"number"===typeof e?"number":"string"}function getDateBetween(e,t,o){const n=new Date(e);if(t){const e=new Date(t);if(n<e)return e}if(o){const e=new Date(o);if(n>e)return e}return n}function isSameDate(e,t,o){const n=new Date(e),a=new Date(t);if(void 0===o)return n.getTime()===a.getTime();switch(o){case"second":case"seconds":if(n.getSeconds()!==a.getSeconds())return!1;case"minute":case"minutes":if(n.getMinutes()!==a.getMinutes())return!1;case"hour":case"hours":if(n.getHours()!==a.getHours())return!1;case"day":case"days":case"date":if(n.getDate()!==a.getDate())return!1;case"month":case"months":if(n.getMonth()!==a.getMonth())return!1;case"year":case"years":if(n.getFullYear()!==a.getFullYear())return!1;break;default:throw new Error(`date isSameDate unknown unit ${o}`)}return!0}function daysInMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0).getDate()}function getOrdinal(e){if(e>=11&&e<=13)return`${e}th`;switch(e%10){case 1:return`${e}st`;case 2:return`${e}nd`;case 3:return`${e}rd`}return`${e}th`}const formatter={YY(e,t,o){const n=this.YYYY(e,t,o)%100;return n>=0?pad(n):"-"+pad(Math.abs(n))},YYYY(e,t,o){return void 0!==o&&null!==o?o:e.getFullYear()},M(e){return e.getMonth()+1},MM(e){return pad(e.getMonth()+1)},MMM(e,t){return t.monthsShort[e.getMonth()]},MMMM(e,t){return t.months[e.getMonth()]},Q(e){return Math.ceil((e.getMonth()+1)/3)},Qo(e){return getOrdinal(this.Q(e))},D(e){return e.getDate()},Do(e){return getOrdinal(e.getDate())},DD(e){return pad(e.getDate())},DDD(e){return getDayOfYear(e)},DDDD(e){return pad(getDayOfYear(e),3)},d(e){return e.getDay()},dd(e,t){return this.dddd(e,t).slice(0,2)},ddd(e,t){return t.daysShort[e.getDay()]},dddd(e,t){return t.days[e.getDay()]},E(e){return e.getDay()||7},w(e){return getWeekOfYear(e)},ww(e){return pad(getWeekOfYear(e))},H(e){return e.getHours()},HH(e){return pad(e.getHours())},h(e){const t=e.getHours();return 0===t?12:t>12?t%12:t},hh(e){return pad(this.h(e))},m(e){return e.getMinutes()},mm(e){return pad(e.getMinutes())},s(e){return e.getSeconds()},ss(e){return pad(e.getSeconds())},S(e){return Math.floor(e.getMilliseconds()/100)},SS(e){return pad(Math.floor(e.getMilliseconds()/10))},SSS(e){return pad(e.getMilliseconds(),3)},A(e){return this.H(e)<12?"AM":"PM"},a(e){return this.H(e)<12?"am":"pm"},aa(e){return this.H(e)<12?"a.m.":"p.m."},Z(e,t,o,n){const a=void 0===n||null===n?e.getTimezoneOffset():n;return formatTimezone(a,":")},ZZ(e,t,o,n){const a=void 0===n||null===n?e.getTimezoneOffset():n;return formatTimezone(a)},X(e){return Math.floor(e.getTime()/1e3)},x(e){return e.getTime()}};function formatDate(e,t,o,n,a){if(0!==e&&!e||e===1/0||e===-1/0)return;const l=new Date(e);if(isNaN(l))return;void 0===t&&(t=defaultMask);const r=getDateLocale(o,Plugin$8.props);return t.replace(token,(e,t)=>e in formatter?formatter[e](l,r,n,a):void 0===t?e:t.split("\\]").join("]"))}function clone(e){return!0===isDate(e)?new Date(e.getTime()):e}var date={isValid:isValid,extractDate:extractDate,buildDate:buildDate,getDayOfWeek:getDayOfWeek,getWeekOfYear:getWeekOfYear,isBetweenDates:isBetweenDates,addToDate:addToDate,subtractFromDate:subtractFromDate,adjustDate:adjustDate,startOfDate:startOfDate,endOfDate:endOfDate,getMaxDate:getMaxDate,getMinDate:getMinDate,getDateDiff:getDateDiff,getDayOfYear:getDayOfYear,inferDateFormat:inferDateFormat,getDateBetween:getDateBetween,isSameDate:isSameDate,daysInMonth:daysInMonth,formatDate:formatDate,clone:clone};const yearsInterval=20,views=["Calendar","Years","Months"],viewIsValid=e=>views.includes(e),yearMonthValidator=e=>/^-?[\d]+\/[0-1]\d$/.test(e),lineStr=" — ";function getMonthHash(e){return e.year+"/"+pad(e.month)}var QDate=createComponent({name:"QDate",props:{...useDatetimeProps,...useFormProps,...useDarkProps,multiple:Boolean,range:Boolean,title:String,subtitle:String,mask:{default:"YYYY/MM/DD"},defaultYearMonth:{type:String,validator:yearMonthValidator},yearsInMonthView:Boolean,events:[Array,Function],eventColor:[String,Function],emitImmediately:Boolean,options:[Array,Function],navigationMinYearMonth:{type:String,validator:yearMonthValidator},navigationMaxYearMonth:{type:String,validator:yearMonthValidator},noUnset:Boolean,firstDayOfWeek:[String,Number],todayBtn:Boolean,minimal:Boolean,defaultView:{type:String,default:"Calendar",validator:viewIsValid}},emits:[...useDatetimeEmits,"rangeStart","rangeEnd","navigation"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=useDark(e,a),{getCache:r}=useCache(),{tabindex:i,headerClass:u,getLocale:s,getCurrentDate:c}=useDatetime(e,a);let d;const v=useFormAttrs(e),p=useFormInject(v),m=vue.ref(null),f=vue.ref(ce()),h=vue.ref(s()),g=vue.computed(()=>ce()),b=vue.computed(()=>s()),y=vue.computed(()=>c()),S=vue.ref(ve(f.value,h.value)),x=vue.ref(e.defaultView),w=!0===a.lang.rtl?"right":"left",C=vue.ref(w.value),k=vue.ref(w.value),_=S.value.year,q=vue.ref(_-_%yearsInterval-(_<0?yearsInterval:0)),T=vue.ref(null),P=vue.computed(()=>{const t=!0===e.landscape?"landscape":"portrait";return`q-date q-date--${t} q-date--${t}-${!0===e.minimal?"minimal":"standard"}`+(!0===l.value?" q-date--dark q-dark":"")+(!0===e.bordered?" q-date--bordered":"")+(!0===e.square?" q-date--square no-border-radius":"")+(!0===e.flat?" q-date--flat no-shadow":"")+(!0===e.disable?" disabled":!0===e.readonly?" q-date--readonly":"")}),M=vue.computed(()=>{return e.color||"primary"}),$=vue.computed(()=>{return e.textColor||"white"}),Q=vue.computed(()=>!0===e.emitImmediately&&!0!==e.multiple&&!0!==e.range),B=vue.computed(()=>!0===Array.isArray(e.modelValue)?e.modelValue:null!==e.modelValue&&void 0!==e.modelValue?[e.modelValue]:[]),R=vue.computed(()=>B.value.filter(e=>"string"===typeof e).map(e=>de(e,f.value,h.value)).filter(e=>null!==e.dateHash&&null!==e.day&&null!==e.month&&null!==e.year)),A=vue.computed(()=>{const e=e=>de(e,f.value,h.value);return B.value.filter(e=>!0===isObject(e)&&void 0!==e.from&&void 0!==e.to).map(t=>({from:e(t.from),to:e(t.to)})).filter(e=>null!==e.from.dateHash&&null!==e.to.dateHash&&e.from.dateHash<e.to.dateHash)}),F=vue.computed(()=>"persian"!==e.calendar?e=>new Date(e.year,e.month-1,e.day):e=>{const t=toGregorian(e.year,e.month,e.day);return new Date(t.gy,t.gm-1,t.gd)}),E=vue.computed(()=>"persian"===e.calendar?getDayHash:(e,t,o)=>formatDate(new Date(e.year,e.month-1,e.day,e.hour,e.minute,e.second,e.millisecond),void 0===t?f.value:t,void 0===o?h.value:o,e.year,e.timezoneOffset)),D=vue.computed(()=>R.value.length+A.value.reduce((e,t)=>e+1+getDateDiff(F.value(t.to),F.value(t.from)),0)),I=vue.computed(()=>{if(void 0!==e.title&&null!==e.title&&0!==e.title.length)return e.title;if(null!==T.value){const e=T.value.init,t=F.value(e);return h.value.daysShort[t.getDay()]+", "+h.value.monthsShort[e.month-1]+" "+e.day+lineStr+"?"}if(0===D.value)return lineStr;if(D.value>1)return`${D.value} ${h.value.pluralDay}`;const t=R.value[0],o=F.value(t);return!0===isNaN(o.valueOf())?lineStr:void 0!==h.value.headerTitle?h.value.headerTitle(o,t):h.value.daysShort[o.getDay()]+", "+h.value.monthsShort[t.month-1]+" "+t.day}),O=vue.computed(()=>{const e=R.value.concat(A.value.map(e=>e.from)).sort((e,t)=>e.year-t.year||e.month-t.month);return e[0]}),z=vue.computed(()=>{const e=R.value.concat(A.value.map(e=>e.to)).sort((e,t)=>t.year-e.year||t.month-e.month);return e[0]}),V=vue.computed(()=>{if(void 0!==e.subtitle&&null!==e.subtitle&&0!==e.subtitle.length)return e.subtitle;if(0===D.value)return lineStr;if(D.value>1){const e=O.value,t=z.value,o=h.value.monthsShort;return o[e.month-1]+(e.year!==t.year?" "+e.year+lineStr+o[t.month-1]+" ":e.month!==t.month?lineStr+o[t.month-1]:"")+" "+t.year}return R.value[0].year}),L=vue.computed(()=>{const e=[a.iconSet.datetime.arrowLeft,a.iconSet.datetime.arrowRight];return!0===a.lang.rtl?e.reverse():e}),H=vue.computed(()=>void 0!==e.firstDayOfWeek?Number(e.firstDayOfWeek):h.value.firstDayOfWeek),N=vue.computed(()=>{const e=h.value.daysShort,t=H.value;return t>0?e.slice(t,7).concat(e.slice(0,t)):e}),j=vue.computed(()=>{const t=S.value;return"persian"!==e.calendar?new Date(t.year,t.month,0).getDate():jalaaliMonthLength(t.year,t.month)}),K=vue.computed(()=>"function"===typeof e.eventColor?e.eventColor:()=>e.eventColor),U=vue.computed(()=>{if(void 0===e.navigationMinYearMonth)return null;const t=e.navigationMinYearMonth.split("/");return{year:parseInt(t[0],10),month:parseInt(t[1],10)}}),W=vue.computed(()=>{if(void 0===e.navigationMaxYearMonth)return null;const t=e.navigationMaxYearMonth.split("/");return{year:parseInt(t[0],10),month:parseInt(t[1],10)}}),Y=vue.computed(()=>{const e={month:{prev:!0,next:!0},year:{prev:!0,next:!0}};return null!==U.value&&U.value.year>=S.value.year&&(e.year.prev=!1,U.value.year===S.value.year&&U.value.month>=S.value.month&&(e.month.prev=!1)),null!==W.value&&W.value.year<=S.value.year&&(e.year.next=!1,W.value.year===S.value.year&&W.value.month<=S.value.month&&(e.month.next=!1)),e}),G=vue.computed(()=>{const e={};return R.value.forEach(t=>{const o=getMonthHash(t);void 0===e[o]&&(e[o]=[]),e[o].push(t.day)}),e}),X=vue.computed(()=>{const e={};return A.value.forEach(t=>{const o=getMonthHash(t.from),n=getMonthHash(t.to);if(void 0===e[o]&&(e[o]=[]),e[o].push({from:t.from.day,to:o===n?t.to.day:void 0,range:t}),o<n){let o;const{year:a,month:l}=t.from,r=l<12?{year:a,month:l+1}:{year:a+1,month:1};while((o=getMonthHash(r))<=n)void 0===e[o]&&(e[o]=[]),e[o].push({from:void 0,to:o===n?t.to.day:void 0,range:t}),r.month++,r.month>12&&(r.year++,r.month=1)}}),e}),Z=vue.computed(()=>{if(null===T.value)return;const{init:e,initHash:t,final:o,finalHash:n}=T.value,[a,l]=t<=n?[e,o]:[o,e],r=getMonthHash(a),i=getMonthHash(l);if(r!==J.value&&i!==J.value)return;const u={};return r===J.value?(u.from=a.day,u.includeFrom=!0):u.from=1,i===J.value?(u.to=l.day,u.includeTo=!0):u.to=j.value,u}),J=vue.computed(()=>getMonthHash(S.value)),ee=vue.computed(()=>{const t={};if(void 0===e.options){for(let e=1;e<=j.value;e++)t[e]=!0;return t}const o="function"===typeof e.options?e.options:t=>e.options.includes(t);for(let e=1;e<=j.value;e++){const n=J.value+"/"+pad(e);t[e]=o(n)}return t}),te=vue.computed(()=>{const t={};if(void 0===e.events)for(let e=1;e<=j.value;e++)t[e]=!1;else{const o="function"===typeof e.events?e.events:t=>e.events.includes(t);for(let e=1;e<=j.value;e++){const n=J.value+"/"+pad(e);t[e]=!0===o(n)&&K.value(n)}}return t}),oe=vue.computed(()=>{let t,o;const{year:n,month:a}=S.value;if("persian"!==e.calendar)t=new Date(n,a-1,1),o=new Date(n,a-1,0).getDate();else{const e=toGregorian(n,a,1);t=new Date(e.gy,e.gm-1,e.gd);let l=a-1,r=n;0===l&&(l=12,r--),o=jalaaliMonthLength(r,l)}return{days:t.getDay()-H.value-1,endDay:o}}),ne=vue.computed(()=>{const e=[],{days:t,endDay:o}=oe.value,n=t<0?t+7:t;if(n<6)for(let r=o-n;r<=o;r++)e.push({i:r,fill:!0});const a=e.length;for(let r=1;r<=j.value;r++){const t={i:r,event:te.value[r],classes:[]};!0===ee.value[r]&&(t.in=!0,t.flat=!0),e.push(t)}if(void 0!==G.value[J.value]&&G.value[J.value].forEach(t=>{const o=a+t-1;Object.assign(e[o],{selected:!0,unelevated:!0,flat:!1,color:M.value,textColor:$.value})}),void 0!==X.value[J.value]&&X.value[J.value].forEach(t=>{if(void 0!==t.from){const o=a+t.from-1,n=a+(t.to||j.value)-1;for(let a=o;a<=n;a++)Object.assign(e[a],{range:t.range,unelevated:!0,color:M.value,textColor:$.value});Object.assign(e[o],{rangeFrom:!0,flat:!1}),void 0!==t.to&&Object.assign(e[n],{rangeTo:!0,flat:!1})}else if(void 0!==t.to){const o=a+t.to-1;for(let n=a;n<=o;n++)Object.assign(e[n],{range:t.range,unelevated:!0,color:M.value,textColor:$.value});Object.assign(e[o],{flat:!1,rangeTo:!0})}else{const o=a+j.value-1;for(let n=a;n<=o;n++)Object.assign(e[n],{range:t.range,unelevated:!0,color:M.value,textColor:$.value})}}),void 0!==Z.value){const t=a+Z.value.from-1,o=a+Z.value.to-1;for(let n=t;n<=o;n++)e[n].color=M.value,e[n].editRange=!0;!0===Z.value.includeFrom&&(e[t].editRangeFrom=!0),!0===Z.value.includeTo&&(e[o].editRangeTo=!0)}S.value.year===y.value.year&&S.value.month===y.value.month&&(e[a+y.value.day-1].today=!0);const l=e.length%7;if(l>0){const t=7-l;for(let o=1;o<=t;o++)e.push({i:o,fill:!0})}return e.forEach(e=>{let t="q-date__calendar-item ";!0===e.fill?t+="q-date__calendar-item--fill":(t+=`q-date__calendar-item--${!0===e.in?"in":"out"}`,void 0!==e.range&&(t+=` q-date__range${!0===e.rangeTo?"-to":!0===e.rangeFrom?"-from":""}`),!0===e.editRange&&(t+=` q-date__edit-range${!0===e.editRangeFrom?"-from":""}${!0===e.editRangeTo?"-to":""}`),void 0===e.range&&!0!==e.editRange||(t+=` text-${e.color}`)),e.classes=t}),e}),ae=vue.computed(()=>!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{});function le(){const e=y.value,t=G.value[getMonthHash(e)];void 0!==t&&!1!==t.includes(e.day)||_e(e),ue(e.year,e.month)}function re(e){!0===viewIsValid(e)&&(x.value=e)}function ie(e,t){if(["month","year"].includes(e)){const o="month"===e?me:fe;o(!0===t?-1:1)}}function ue(e,t){x.value="Calendar",Se(e,t)}function se(t,o){if(!1===e.range||!t)return void(T.value=null);const n=Object.assign({...S.value},t),a=void 0!==o?Object.assign({...S.value},o):n;T.value={init:n,initHash:getDayHash(n),final:a,finalHash:getDayHash(a)},ue(n.year,n.month)}function ce(){return"persian"===e.calendar?"YYYY/MM/DD":e.mask}function de(t,o,n){return __splitDate(t,o,n,e.calendar,{hour:0,minute:0,second:0,millisecond:0})}function ve(t,o){const n=!0===Array.isArray(e.modelValue)?e.modelValue:e.modelValue?[e.modelValue]:[];if(0===n.length)return pe();const a=n[n.length-1],l=de(void 0!==a.from?a.from:a,t,o);return null===l.dateHash?pe():l}function pe(){let t,o;if(void 0!==e.defaultYearMonth){const n=e.defaultYearMonth.split("/");t=parseInt(n[0],10),o=parseInt(n[1],10)}else{const e=void 0!==y.value?y.value:c();t=e.year,o=e.month}return{year:t,month:o,day:1,hour:0,minute:0,second:0,millisecond:0,dateHash:t+"/"+pad(o)+"/01"}}function me(e){let t=S.value.year,o=Number(S.value.month)+e;13===o?(o=1,t++):0===o&&(o=12,t--),Se(t,o),!0===Q.value&&we("month")}function fe(e){const t=Number(S.value.year)+e;Se(t,S.value.month),!0===Q.value&&we("year")}function he(t){Se(t,S.value.month),x.value="Years"===e.defaultView?"Months":"Calendar",!0===Q.value&&we("year")}function ge(e){Se(S.value.year,e),x.value="Calendar",!0===Q.value&&we("month")}function be(e,t){const o=G.value[t],n=void 0!==o&&!0===o.includes(e.day)?qe:_e;n(e)}function ye(e){return{year:e.year,month:e.month,day:e.day}}function Se(e,t,o){if(null!==U.value&&e<=U.value.year&&((t<U.value.month||e<U.value.year)&&(t=U.value.month),e=U.value.year),null!==W.value&&e>=W.value.year&&((t>W.value.month||e>W.value.year)&&(t=W.value.month),e=W.value.year),void 0!==o){const{hour:e,minute:t,second:n,millisecond:a,timezoneOffset:l,timeHash:r}=o;Object.assign(S.value,{hour:e,minute:t,second:n,millisecond:a,timezoneOffset:l,timeHash:r})}const n=e+"/"+pad(t)+"/01";n!==S.value.dateHash&&(C.value=S.value.dateHash<n===(!0!==a.lang.rtl)?"left":"right",e!==S.value.year&&(k.value=C.value),vue.nextTick(()=>{q.value=e-e%yearsInterval-(e<0?yearsInterval:0),Object.assign(S.value,{year:e,month:t,day:1,dateHash:n})}))}function xe(t,n,a){const l=null!==t&&1===t.length&&!1===e.multiple?t[0]:t;d=l;const{reason:r,details:i}=Ce(n,a);o("update:modelValue",l,r,i)}function we(t){const n=void 0!==R.value[0]&&null!==R.value[0].dateHash?{...R.value[0]}:{...S.value};vue.nextTick(()=>{n.year=S.value.year,n.month=S.value.month;const a="persian"!==e.calendar?new Date(n.year,n.month,0).getDate():jalaaliMonthLength(n.year,n.month);n.day=Math.min(Math.max(1,n.day),a);const l=ke(n);d=l;const{details:r}=Ce("",n);o("update:modelValue",l,t,r)})}function Ce(e,t){return void 0!==t.from?{reason:`${e}-range`,details:{...ye(t.target),from:ye(t.from),to:ye(t.to)}}:{reason:`${e}-day`,details:ye(t)}}function ke(e,t,o){return void 0!==e.from?{from:E.value(e.from,t,o),to:E.value(e.to,t,o)}:E.value(e,t,o)}function _e(t){let o;if(!0===e.multiple)if(void 0!==t.from){const e=getDayHash(t.from),n=getDayHash(t.to),a=R.value.filter(t=>t.dateHash<e||t.dateHash>n),l=A.value.filter(({from:t,to:o})=>o.dateHash<e||t.dateHash>n);o=a.concat(l).concat(t).map(e=>ke(e))}else{const e=B.value.slice();e.push(ke(t)),o=e}else o=ke(t);xe(o,"add",t)}function qe(t){if(!0===e.noUnset)return;let o=null;if(!0===e.multiple&&!0===Array.isArray(e.modelValue)){const n=ke(t);o=void 0!==t.from?e.modelValue.filter(e=>void 0===e.from||e.from!==n.from&&e.to!==n.to):e.modelValue.filter(e=>e!==n),0===o.length&&(o=null)}xe(o,"remove",t)}function Te(t,n,a){const l=R.value.concat(A.value).map(e=>ke(e,t,n)).filter(e=>{return void 0!==e.from?null!==e.from.dateHash&&null!==e.to.dateHash:null!==e.dateHash});o("update:modelValue",(!0===e.multiple?l:l[0])||null,a)}function Pe(){if(!0!==e.minimal)return vue.h("div",{class:"q-date__header "+u.value},[vue.h("div",{class:"relative-position"},[vue.h(vue.Transition,{name:"q-transition--fade"},()=>vue.h("div",{key:"h-yr-"+V.value,class:"q-date__header-subtitle q-date__header-link "+("Years"===x.value?"q-date__header-link--active":"cursor-pointer"),tabindex:i.value,...r("vY",{onClick(){x.value="Years"},onKeyup(e){13===e.keyCode&&(x.value="Years")}})},[V.value]))]),vue.h("div",{class:"q-date__header-title relative-position flex no-wrap"},[vue.h("div",{class:"relative-position col"},[vue.h(vue.Transition,{name:"q-transition--fade"},()=>vue.h("div",{key:"h-sub"+I.value,class:"q-date__header-title-label q-date__header-link "+("Calendar"===x.value?"q-date__header-link--active":"cursor-pointer"),tabindex:i.value,...r("vC",{onClick(){x.value="Calendar"},onKeyup(e){13===e.keyCode&&(x.value="Calendar")}})},[I.value]))]),!0===e.todayBtn?vue.h(QBtn,{class:"q-date__header-today self-start",icon:a.iconSet.datetime.today,flat:!0,size:"sm",round:!0,tabindex:i.value,onClick:le}):null])])}function Me({label:e,type:t,key:o,dir:n,goTo:a,boundaries:l,cls:u}){return[vue.h("div",{class:"row items-center q-date__arrow"},[vue.h(QBtn,{round:!0,dense:!0,size:"sm",flat:!0,icon:L.value[0],tabindex:i.value,disable:!1===l.prev,...r("go-#"+t,{onClick(){a(-1)}})})]),vue.h("div",{class:"relative-position overflow-hidden flex flex-center"+u},[vue.h(vue.Transition,{name:"q-transition--jump-"+n},()=>vue.h("div",{key:o},[vue.h(QBtn,{flat:!0,dense:!0,noCaps:!0,label:e,tabindex:i.value,...r("view#"+t,{onClick:()=>{x.value=t}})})]))]),vue.h("div",{class:"row items-center q-date__arrow"},[vue.h(QBtn,{round:!0,dense:!0,size:"sm",flat:!0,icon:L.value[1],tabindex:i.value,disable:!1===l.next,...r("go+#"+t,{onClick(){a(1)}})})])]}vue.watch(()=>e.modelValue,e=>{if(d===e)d=0;else{const e=ve(f.value,h.value);Se(e.year,e.month,e)}}),vue.watch(x,()=>{null!==m.value&&!0===n.$el.contains(document.activeElement)&&m.value.focus()}),vue.watch(()=>S.value.year+"|"+S.value.month,()=>{o("navigation",{year:S.value.year,month:S.value.month})}),vue.watch(g,e=>{Te(e,h.value,"mask"),f.value=e}),vue.watch(b,e=>{Te(f.value,e,"locale"),h.value=e});const $e={Calendar:()=>[vue.h("div",{key:"calendar-view",class:"q-date__view q-date__calendar"},[vue.h("div",{class:"q-date__navigation row items-center no-wrap"},Me({label:h.value.months[S.value.month-1],type:"Months",key:S.value.month,dir:C.value,goTo:me,boundaries:Y.value.month,cls:" col"}).concat(Me({label:S.value.year,type:"Years",key:S.value.year,dir:k.value,goTo:fe,boundaries:Y.value.year,cls:""}))),vue.h("div",{class:"q-date__calendar-weekdays row items-center no-wrap"},N.value.map(e=>vue.h("div",{class:"q-date__calendar-item"},[vue.h("div",e)]))),vue.h("div",{class:"q-date__calendar-days-container relative-position overflow-hidden"},[vue.h(vue.Transition,{name:"q-transition--slide-"+C.value},()=>vue.h("div",{key:J.value,class:"q-date__calendar-days fit"},ne.value.map(e=>vue.h("div",{class:e.classes},[!0===e.in?vue.h(QBtn,{class:!0===e.today?"q-date__today":"",dense:!0,flat:e.flat,unelevated:e.unelevated,color:e.color,textColor:e.textColor,label:e.i,tabindex:i.value,...r("day#"+e.i,{onClick:()=>{Qe(e.i)},onMouseover:()=>{Be(e.i)}})},!1!==e.event?()=>vue.h("div",{class:"q-date__event bg-"+e.event}):null):vue.h("div",""+e.i)]))))])])],Months(){const t=S.value.year===y.value.year,o=e=>{return null!==U.value&&S.value.year===U.value.year&&U.value.month>e||null!==W.value&&S.value.year===W.value.year&&W.value.month<e},n=h.value.monthsShort.map((e,n)=>{const a=S.value.month===n+1;return vue.h("div",{class:"q-date__months-item flex flex-center"},[vue.h(QBtn,{class:!0===t&&y.value.month===n+1?"q-date__today":null,flat:!0!==a,label:e,unelevated:a,color:!0===a?M.value:null,textColor:!0===a?$.value:null,tabindex:i.value,disable:o(n+1),...r("month#"+n,{onClick:()=>{ge(n+1)}})})])});return!0===e.yearsInMonthView&&n.unshift(vue.h("div",{class:"row no-wrap full-width"},[Me({label:S.value.year,type:"Years",key:S.value.year,dir:k.value,goTo:fe,boundaries:Y.value.year,cls:" col"})])),vue.h("div",{key:"months-view",class:"q-date__view q-date__months flex flex-center"},n)},Years(){const e=q.value,t=e+yearsInterval,o=[],n=e=>{return null!==U.value&&U.value.year>e||null!==W.value&&W.value.year<e};for(let a=e;a<=t;a++){const e=S.value.year===a;o.push(vue.h("div",{class:"q-date__years-item flex flex-center"},[vue.h(QBtn,{key:"yr"+a,class:y.value.year===a?"q-date__today":null,flat:!e,label:a,dense:!0,unelevated:e,color:!0===e?M.value:null,textColor:!0===e?$.value:null,tabindex:i.value,disable:n(a),...r("yr#"+a,{onClick:()=>{he(a)}})})]))}return vue.h("div",{class:"q-date__view q-date__years flex flex-center"},[vue.h("div",{class:"col-auto"},[vue.h(QBtn,{round:!0,dense:!0,flat:!0,icon:L.value[0],tabindex:i.value,disable:n(e),...r("y-",{onClick:()=>{q.value-=yearsInterval}})})]),vue.h("div",{class:"q-date__years-content col self-stretch row items-center"},o),vue.h("div",{class:"col-auto"},[vue.h(QBtn,{round:!0,dense:!0,flat:!0,icon:L.value[1],tabindex:i.value,disable:n(t),...r("y+",{onClick:()=>{q.value+=yearsInterval}})})])])}};function Qe(t){const n={...S.value,day:t};if(!1!==e.range)if(null===T.value){const a=ne.value.find(e=>!0!==e.fill&&e.i===t);if(!0!==e.noUnset&&void 0!==a.range)return void qe({target:n,from:a.range.from,to:a.range.to});if(!0===a.selected)return void qe(n);const l=getDayHash(n);T.value={init:n,initHash:l,final:n,finalHash:l},o("rangeStart",ye(n))}else{const e=T.value.initHash,t=getDayHash(n),a=e<=t?{from:T.value.init,to:n}:{from:n,to:T.value.init};T.value=null,_e(e===t?n:{target:n,...a}),o("rangeEnd",{from:ye(a.from),to:ye(a.to)})}else be(n,J.value)}function Be(e){if(null!==T.value){const t={...S.value,day:e};Object.assign(T.value,{final:t,finalHash:getDayHash(t)})}}return Object.assign(n,{setToday:le,setView:re,offsetCalendar:ie,setCalendarTo:ue,setEditingRange:se}),()=>{const o=[vue.h("div",{class:"q-date__content col relative-position"},[vue.h(vue.Transition,{name:"q-transition--fade"},$e[x.value])])],n=hSlot(t.default);return void 0!==n&&o.push(vue.h("div",{class:"q-date__actions"},n)),void 0!==e.name&&!0!==e.disable&&p(o,"push"),vue.h("div",{class:P.value,...ae.value},[Pe(),vue.h("div",{ref:m,class:"q-date__main col column",tabindex:-1},o)])}}});function useHistory(e,t,o){let n;function a(){void 0!==n&&(History.remove(n),n=void 0)}return vue.onBeforeUnmount(()=>{!0===e.value&&a()}),{removeFromHistory:a,addToHistory(){n={condition:()=>!0===o.value,handler:t},History.add(n)}}}let scrollPositionX,scrollPositionY,maxScrollTop,bodyLeft,bodyTop,href,registered=0,vpPendingUpdate=!1,closeTimer=null;function onWheel(e){shouldPreventScroll(e)&&stopAndPrevent(e)}function shouldPreventScroll(e){if(e.target===document.body||e.target.classList.contains("q-layout__backdrop"))return!0;const t=getEventPath(e),o=e.shiftKey&&!e.deltaX,n=!o&&Math.abs(e.deltaX)<=Math.abs(e.deltaY),a=o||n?e.deltaY:e.deltaX;for(let l=0;l<t.length;l++){const e=t[l];if(hasScrollbar(e,n))return n?a<0&&0===e.scrollTop||a>0&&e.scrollTop+e.clientHeight===e.scrollHeight:a<0&&0===e.scrollLeft||a>0&&e.scrollLeft+e.clientWidth===e.scrollWidth}return!0}function onAppleScroll(e){e.target===document&&(document.scrollingElement.scrollTop=document.scrollingElement.scrollTop)}function onAppleResize(e){!0!==vpPendingUpdate&&(vpPendingUpdate=!0,requestAnimationFrame(()=>{vpPendingUpdate=!1;const{height:t}=e.target,{clientHeight:o,scrollTop:n}=document.scrollingElement;void 0!==maxScrollTop&&t===window.innerHeight||(maxScrollTop=o-t,document.scrollingElement.scrollTop=n),n>maxScrollTop&&(document.scrollingElement.scrollTop-=Math.ceil((n-maxScrollTop)/8))}))}function apply(e){const t=document.body,o=void 0!==window.visualViewport;if("add"===e){const{overflowY:e,overflowX:n}=window.getComputedStyle(t);scrollPositionX=getHorizontalScrollPosition(window),scrollPositionY=getVerticalScrollPosition(window),bodyLeft=t.style.left,bodyTop=t.style.top,href=window.location.href,t.style.left=`-${scrollPositionX}px`,t.style.top=`-${scrollPositionY}px`,"hidden"!==n&&("scroll"===n||t.scrollWidth>window.innerWidth)&&t.classList.add("q-body--force-scrollbar-x"),"hidden"!==e&&("scroll"===e||t.scrollHeight>window.innerHeight)&&t.classList.add("q-body--force-scrollbar-y"),t.classList.add("q-body--prevent-scroll"),document.qScrollPrevented=!0,!0===client.is.ios&&(!0===o?(window.scrollTo(0,0),window.visualViewport.addEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.addEventListener("scroll",onAppleResize,listenOpts.passiveCapture),window.scrollTo(0,0)):window.addEventListener("scroll",onAppleScroll,listenOpts.passiveCapture))}!0===client.is.desktop&&!0===client.is.mac&&window[`${e}EventListener`]("wheel",onWheel,listenOpts.notPassive),"remove"===e&&(!0===client.is.ios&&(!0===o?(window.visualViewport.removeEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.removeEventListener("scroll",onAppleResize,listenOpts.passiveCapture)):window.removeEventListener("scroll",onAppleScroll,listenOpts.passiveCapture)),t.classList.remove("q-body--prevent-scroll"),t.classList.remove("q-body--force-scrollbar-x"),t.classList.remove("q-body--force-scrollbar-y"),document.qScrollPrevented=!1,t.style.left=bodyLeft,t.style.top=bodyTop,window.location.href===href&&window.scrollTo(scrollPositionX,scrollPositionY),maxScrollTop=void 0)}function preventScroll(e){let t="add";if(!0===e){if(registered++,null!==closeTimer)return clearTimeout(closeTimer),void(closeTimer=null);if(registered>1)return}else{if(0===registered)return;if(registered--,registered>0)return;if(t="remove",!0===client.is.ios&&!0===client.is.nativeMobile)return null!==closeTimer&&clearTimeout(closeTimer),void(closeTimer=setTimeout(()=>{apply(t),closeTimer=null},100))}apply(t)}function usePreventScroll(){let e;return{preventBodyScroll(t){t===e||void 0===e&&!0!==t||(e=t,preventScroll(t))}}}let maximizedModals=0;const positionClass={standard:"fixed-full flex-center",top:"fixed-top justify-center",bottom:"fixed-bottom justify-center",right:"fixed-right items-center",left:"fixed-left items-center"},defaultTransitions={standard:["scale","scale"],top:["slide-down","slide-up"],bottom:["slide-up","slide-down"],right:["slide-left","slide-right"],left:["slide-right","slide-left"]};var QDialog=createComponent({name:"QDialog",inheritAttrs:!1,props:{...useModelToggleProps,...useTransitionProps,transitionShow:String,transitionHide:String,persistent:Boolean,autoClose:Boolean,allowFocusOutside:Boolean,noEscDismiss:Boolean,noBackdropDismiss:Boolean,noRouteDismiss:Boolean,noRefocus:Boolean,noFocus:Boolean,noShake:Boolean,seamless:Boolean,maximized:Boolean,fullWidth:Boolean,fullHeight:Boolean,square:Boolean,position:{type:String,default:"standard",validator:e=>"standard"===e||["top","bottom","left","right"].includes(e)}},emits:[...useModelToggleEmits,"shake","click","escapeKey"],setup(e,{slots:t,emit:o,attrs:n}){const a=vue.getCurrentInstance(),l=vue.ref(null),r=vue.ref(!1),i=vue.ref(!1);let u,s,c=null,d=null;const v=vue.computed(()=>!0!==e.persistent&&!0!==e.noRouteDismiss&&!0!==e.seamless),{preventBodyScroll:p}=usePreventScroll(),{registerTimeout:m}=useTimeout(),{registerTick:f,removeTick:h}=useTick();useTransition(e,()=>defaultTransitions[e.position][0],()=>defaultTransitions[e.position][1]);const{showPortal:g,hidePortal:b,portalIsAccessible:y,renderPortal:S}=usePortal(),{hide:x}=useModelToggle({showing:r,hideOnRouteChange:v,handleShow:_,handleHide:q,processOnMount:!0}),{addToHistory:w,removeFromHistory:C}=useHistory(r,x,v);vue.computed(()=>"q-dialog__inner flex no-pointer-events"+` q-dialog__inner--${!0===e.maximized?"maximized":"minimized"}`+` q-dialog__inner--${e.position} ${positionClass[e.position]}`+(!0===i.value?" q-dialog__inner--animating":"")+(!0===e.fullWidth?" q-dialog__inner--fullwidth":"")+(!0===e.fullHeight?" q-dialog__inner--fullheight":"")+(!0===e.square?" q-dialog__inner--square":""));const k=vue.computed(()=>!0===r.value&&!0!==e.seamless);function _(t){w(),d=!1===e.noRefocus&&null!==document.activeElement?document.activeElement:null,Q(e.maximized),g(),i.value=!0,!0!==e.noFocus?(null!==document.activeElement&&document.activeElement.blur(),f(T)):h(),m(()=>{if(!0===a.proxy.$q.platform.is.ios){if(!0!==e.seamless&&document.activeElement){const{top:e,bottom:t}=document.activeElement.getBoundingClientRect(),{innerHeight:o}=window,n=void 0!==window.visualViewport?window.visualViewport.height:o;e>0&&t>n/2&&(document.scrollingElement.scrollTop=Math.min(document.scrollingElement.scrollHeight-n,t>=o?1/0:Math.ceil(document.scrollingElement.scrollTop+t-n/2))),document.activeElement.scrollIntoView()}s=!0,l.value.click(),s=!1}g(!0),i.value=!1,o("show",t)},e.transitionDuration)}function q(t){h(),C(),$(!0),i.value=!0,b(),null!==d&&(((t&&0===t.type.indexOf("key")?d.closest('[tabindex]:not([tabindex^="-"])'):void 0)||d).focus(),d=null),m(()=>{b(!0),i.value=!1,o("hide",t)},e.transitionDuration)}function T(e){addFocusFn(()=>{let t=l.value;null!==t&&!0!==t.contains(document.activeElement)&&(t=(""!==e?t.querySelector(e):null)||t.querySelector("[autofocus][tabindex], [data-autofocus][tabindex]")||t.querySelector("[autofocus] [tabindex], [data-autofocus] [tabindex]")||t.querySelector("[autofocus], [data-autofocus]")||t,t.focus({preventScroll:!0}))})}function P(e){e&&"function"===typeof e.focus?e.focus({preventScroll:!0}):T(),o("shake");const t=l.value;null!==t&&(t.classList.remove("q-animate--scale"),t.classList.add("q-animate--scale"),null!==c&&clearTimeout(c),c=setTimeout(()=>{c=null,null!==l.value&&(t.classList.remove("q-animate--scale"),T())},170))}function M(){!0!==e.seamless&&(!0===e.persistent||!0===e.noEscDismiss?!0!==e.maximized&&!0!==e.noShake&&P():(o("escapeKey"),x()))}function $(t){null!==c&&(clearTimeout(c),c=null),!0!==t&&!0!==r.value||(Q(!1),!0!==e.seamless&&(p(!1),removeFocusout(R),removeEscapeKey(M))),!0!==t&&(d=null)}function Q(e){!0===e?!0!==u&&(maximizedModals<1&&document.body.classList.add("q-body--dialog"),maximizedModals++,u=!0):!0===u&&(maximizedModals<2&&document.body.classList.remove("q-body--dialog"),maximizedModals--,u=!1)}function B(e){!0!==s&&(x(e),o("click",e))}function R(t){!0!==e.allowFocusOutside&&!0===y.value&&!0!==childHasFocus(l.value,t.target)&&T('[tabindex]:not([tabindex="-1"])')}return vue.computed(()=>!0===e.autoClose?{onClick:B}:{}),vue.computed(()=>["q-dialog fullscreen no-pointer-events "+`q-dialog--${!0===k.value?"modal":"seamless"}`,n.class]),vue.watch(()=>e.maximized,e=>{!0===r.value&&Q(e)}),vue.watch(k,e=>{p(e),!0===e?(addFocusout(R),addEscapeKey(M)):(removeFocusout(R),removeEscapeKey(M))}),Object.assign(a.proxy,{focus:T,shake:P,__updateRefocusTarget(e){d=e||null}}),vue.onBeforeUnmount($),S}});const duration=150;var QDrawer=createComponent({name:"QDrawer",inheritAttrs:!1,props:{...useModelToggleProps,...useDarkProps,side:{type:String,default:"left",validator:e=>["left","right"].includes(e)},width:{type:Number,default:300},mini:Boolean,miniToOverlay:Boolean,miniWidth:{type:Number,default:57},noMiniAnimation:Boolean,breakpoint:{type:Number,default:1023},showIfAbove:Boolean,behavior:{type:String,validator:e=>["default","desktop","mobile"].includes(e),default:"default"},bordered:Boolean,elevated:Boolean,overlay:Boolean,persistent:Boolean,noSwipeOpen:Boolean,noSwipeClose:Boolean,noSwipeBackdrop:Boolean},emits:[...useModelToggleEmits,"onLayout","miniState"],setup(e,{slots:t,emit:o,attrs:n}){const a=vue.getCurrentInstance(),{proxy:{$q:l}}=a,r=useDark(e,l),{preventBodyScroll:i}=usePreventScroll(),{registerTimeout:u,removeTimeout:s}=useTimeout(),c=vue.inject(layoutKey,emptyRenderFn);if(c===emptyRenderFn)return console.error("QDrawer needs to be child of QLayout"),emptyRenderFn;let d,v,p=null;const m=vue.ref("mobile"===e.behavior||"desktop"!==e.behavior&&c.totalWidth.value<=e.breakpoint),f=vue.computed(()=>!0===e.mini&&!0!==m.value),h=vue.computed(()=>!0===f.value?e.miniWidth:e.width),g=vue.ref(!0===e.showIfAbove&&!1===m.value||!0===e.modelValue),b=vue.computed(()=>!0!==e.persistent&&(!0===m.value||!0===E.value));function y(e,t){if(C(),!1!==e&&c.animate(),Y(0),!0===m.value){const e=c.instances[B.value];void 0!==e&&!0===e.belowBreakpoint&&e.hide(!1),G(1),!0!==c.isContainer.value&&i(!0)}else G(0),!1!==e&&X(!1);u(()=>{!1!==e&&X(!0),!0!==t&&o("show",e)},duration)}function S(e,t){k(),!1!==e&&c.animate(),G(0),Y(T.value*h.value),te(),!0!==t?u(()=>{o("hide",e)},duration):s()}const{show:x,hide:w}=useModelToggle({showing:g,hideOnRouteChange:b,handleShow:y,handleHide:S}),{addToHistory:C,removeFromHistory:k}=useHistory(g,w,b),_={belowBreakpoint:m,hide:w},q=vue.computed(()=>"right"===e.side),T=vue.computed(()=>(!0===l.lang.rtl?-1:1)*(!0===q.value?1:-1)),P=vue.ref(0),M=vue.ref(!1),$=vue.ref(!1),Q=vue.ref(h.value*T.value),B=vue.computed(()=>!0===q.value?"left":"right"),R=vue.computed(()=>!0===g.value&&!1===m.value&&!1===e.overlay?!0===e.miniToOverlay?e.miniWidth:h.value:0),A=vue.computed(()=>!0===e.overlay||!0===e.miniToOverlay||c.view.value.indexOf(q.value?"R":"L")>-1||!0===l.platform.is.ios&&!0===c.isContainer.value),F=vue.computed(()=>!1===e.overlay&&!0===g.value&&!1===m.value),E=vue.computed(()=>!0===e.overlay&&!0===g.value&&!1===m.value),D=vue.computed(()=>"fullscreen q-drawer__backdrop"+(!1===g.value&&!1===M.value?" hidden":"")),I=vue.computed(()=>({backgroundColor:`rgba(0,0,0,${.4*P.value})`})),O=vue.computed(()=>!0===q.value?"r"===c.rows.value.top[2]:"l"===c.rows.value.top[0]),z=vue.computed(()=>!0===q.value?"r"===c.rows.value.bottom[2]:"l"===c.rows.value.bottom[0]),V=vue.computed(()=>{const e={};return!0===c.header.space&&!1===O.value&&(!0===A.value?e.top=`${c.header.offset}px`:!0===c.header.space&&(e.top=`${c.header.size}px`)),!0===c.footer.space&&!1===z.value&&(!0===A.value?e.bottom=`${c.footer.offset}px`:!0===c.footer.space&&(e.bottom=`${c.footer.size}px`)),e}),L=vue.computed(()=>{const e={width:`${h.value}px`,transform:`translateX(${Q.value}px)`};return!0===m.value?e:Object.assign(e,V.value)}),H=vue.computed(()=>"q-drawer__content fit "+(!0!==c.isContainer.value?"scroll":"overflow-auto")),N=vue.computed(()=>`q-drawer q-drawer--${e.side}`+(!0===$.value?" q-drawer--mini-animate":"")+(!0===e.bordered?" q-drawer--bordered":"")+(!0===r.value?" q-drawer--dark q-dark":"")+(!0===M.value?" no-transition":!0===g.value?"":" q-layout--prevent-focus")+(!0===m.value?" fixed q-drawer--on-top q-drawer--mobile q-drawer--top-padding":` q-drawer--${!0===f.value?"mini":"standard"}`+(!0===A.value||!0!==F.value?" fixed":"")+(!0===e.overlay||!0===e.miniToOverlay?" q-drawer--on-top":"")+(!0===O.value?" q-drawer--top-padding":""))),j=vue.computed(()=>{const t=!0===l.lang.rtl?e.side:B.value;return[[TouchPan,J,void 0,{[t]:!0,mouse:!0}]]}),K=vue.computed(()=>{const t=!0===l.lang.rtl?B.value:e.side;return[[TouchPan,ee,void 0,{[t]:!0,mouse:!0}]]}),U=vue.computed(()=>{const t=!0===l.lang.rtl?B.value:e.side;return[[TouchPan,ee,void 0,{[t]:!0,mouse:!0,mouseAllDir:!0}]]});function W(){ne(m,"mobile"===e.behavior||"desktop"!==e.behavior&&c.totalWidth.value<=e.breakpoint)}function Y(e){void 0===e?vue.nextTick(()=>{e=!0===g.value?0:h.value,Y(T.value*e)}):(!0!==c.isContainer.value||!0!==q.value||!0!==m.value&&Math.abs(e)!==h.value||(e+=T.value*c.scrollbarWidth.value),Q.value=e)}function G(e){P.value=e}function X(e){const t=!0===e?"remove":!0!==c.isContainer.value?"add":"";""!==t&&document.body.classList[t]("q-body--drawer-toggle")}function Z(){null!==p&&clearTimeout(p),a.proxy&&a.proxy.$el&&a.proxy.$el.classList.add("q-drawer--mini-animate"),$.value=!0,p=setTimeout(()=>{p=null,$.value=!1,a&&a.proxy&&a.proxy.$el&&a.proxy.$el.classList.remove("q-drawer--mini-animate")},150)}function J(e){if(!1!==g.value)return;const t=h.value,o=between(e.distance.x,0,t);if(!0===e.isFinal){const e=o>=Math.min(75,t);return!0===e?x():(c.animate(),G(0),Y(T.value*t)),void(M.value=!1)}Y((!0===l.lang.rtl?!0!==q.value:q.value)?Math.max(t-o,0):Math.min(0,o-t)),G(between(o/t,0,1)),!0===e.isFirst&&(M.value=!0)}function ee(t){if(!0!==g.value)return;const o=h.value,n=t.direction===e.side,a=(!0===l.lang.rtl?!0!==n:n)?between(t.distance.x,0,o):0;if(!0===t.isFinal){const e=Math.abs(a)<Math.min(75,o);return!0===e?(c.animate(),G(1),Y(0)):w(),void(M.value=!1)}Y(T.value*a),G(between(1-a/o,0,1)),!0===t.isFirst&&(M.value=!0)}function te(){i(!1),X(!0)}function oe(t,o){c.update(e.side,t,o)}function ne(e,t){e.value!==t&&(e.value=t)}function ae(t,o){oe("size",!0===t?e.miniWidth:o)}return vue.watch(m,t=>{!0===t?(d=g.value,!0===g.value&&w(!1)):!1===e.overlay&&"mobile"!==e.behavior&&!1!==d&&(!0===g.value?(Y(0),G(0),te()):x(!1))}),vue.watch(()=>e.side,(e,t)=>{c.instances[t]===_&&(c.instances[t]=void 0,c[t].space=!1,c[t].offset=0),c.instances[e]=_,c[e].size=h.value,c[e].space=F.value,c[e].offset=R.value}),vue.watch(c.totalWidth,()=>{!0!==c.isContainer.value&&!0===document.qScrollPrevented||W()}),vue.watch(()=>e.behavior+e.breakpoint,W),vue.watch(c.isContainer,e=>{!0===g.value&&i(!0!==e),!0===e&&W()}),vue.watch(c.scrollbarWidth,()=>{Y(!0===g.value?0:void 0)}),vue.watch(R,e=>{oe("offset",e)}),vue.watch(F,e=>{o("onLayout",e),oe("space",e)}),vue.watch(q,()=>{Y()}),vue.watch(h,t=>{Y(),ae(e.miniToOverlay,t)}),vue.watch(()=>e.miniToOverlay,e=>{ae(e,h.value)}),vue.watch(()=>l.lang.rtl,()=>{Y()}),vue.watch(()=>e.mini,()=>{e.noMiniAnimation||!0===e.modelValue&&(Z(),c.animate())}),vue.watch(f,e=>{o("miniState",e)}),c.instances[e.side]=_,ae(e.miniToOverlay,h.value),oe("space",F.value),oe("offset",R.value),!0===e.showIfAbove&&!0!==e.modelValue&&!0===g.value&&void 0!==e["onUpdate:modelValue"]&&o("update:modelValue",!0),vue.onMounted(()=>{o("onLayout",F.value),o("miniState",f.value),d=!0===e.showIfAbove;const t=()=>{const e=!0===g.value?y:S;e(!1,!0)};0===c.totalWidth.value?v=vue.watch(c.totalWidth,()=>{v(),v=void 0,!1===g.value&&!0===e.showIfAbove&&!1===m.value?x(!1):t()}):vue.nextTick(t)}),vue.onBeforeUnmount(()=>{void 0!==v&&v(),null!==p&&(clearTimeout(p),p=null),!0===g.value&&te(),c.instances[e.side]===_&&(c.instances[e.side]=void 0,oe("size",0),oe("offset",0),oe("space",!1))}),()=>{const o=[];!0===m.value&&(!1===e.noSwipeOpen&&o.push(vue.withDirectives(vue.h("div",{key:"open",class:`q-drawer__opener fixed-${e.side}`,"aria-hidden":"true"}),j.value)),o.push(hDir("div",{ref:"backdrop",class:D.value,style:I.value,"aria-hidden":"true",onClick:w},void 0,"backdrop",!0!==e.noSwipeBackdrop&&!0===g.value,()=>U.value)));const a=!0===f.value&&void 0!==t.mini,l=[vue.h("div",{...n,key:""+a,class:[H.value,n.class]},!0===a?t.mini():hSlot(t.default))];return!0===e.elevated&&!0===g.value&&l.push(vue.h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),o.push(hDir("aside",{ref:"content",class:N.value,style:L.value},l,"contentclose",!0!==e.noSwipeClose&&!0===m.value,()=>K.value)),vue.h("div",{class:"q-drawer-container"},o)}}});function getBlockElement(e,t){if(t&&e===t)return null;const o=e.nodeName.toLowerCase();if(!0===["div","li","ul","ol","blockquote"].includes(o))return e;const n=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle,a=n.display;return"block"===a||"table"===a?e:getBlockElement(e.parentNode)}function isChildOf(e,t,o){return!(!e||e===document.body)&&(!0===o&&e===t||(t===document?document.body:t).contains(e.parentNode))}function createRange(e,t,o){if(o||(o=document.createRange(),o.selectNode(e),o.setStart(e,0)),0===t.count)o.setEnd(e,t.count);else if(t.count>0)if(e.nodeType===Node.TEXT_NODE)e.textContent.length<t.count?t.count-=e.textContent.length:(o.setEnd(e,t.count),t.count=0);else for(let n=0;0!==t.count&&n<e.childNodes.length;n++)o=createRange(e.childNodes[n],t,o);return o}const urlRegex=/^https?:\/\//;class Caret{constructor(e,t){this.el=e,this.eVm=t,this._range=null}get selection(){if(this.el){const e=document.getSelection();if(isChildOf(e.anchorNode,this.el,!0)&&isChildOf(e.focusNode,this.el,!0))return e}return null}get hasSelection(){return null!==this.selection&&0!==this.selection.toString().length}get range(){const e=this.selection;return null!==e&&e.rangeCount?e.getRangeAt(0):this._range}get parent(){const e=this.range;if(null!==e){const t=e.startContainer;return t.nodeType===document.ELEMENT_NODE?t:t.parentNode}return null}get blockParent(){const e=this.parent;return null!==e?getBlockElement(e,this.el):null}save(e=this.range){null!==e&&(this._range=e)}restore(e=this._range){const t=document.createRange(),o=document.getSelection();null!==e?(t.setStart(e.startContainer,e.startOffset),t.setEnd(e.endContainer,e.endOffset),o.removeAllRanges(),o.addRange(t)):(o.selectAllChildren(this.el),o.collapseToEnd())}savePosition(){let e,t=-1;const o=document.getSelection(),n=this.el.parentNode;if(o.focusNode&&isChildOf(o.focusNode,n)){e=o.focusNode,t=o.focusOffset;while(e&&e!==n)e!==this.el&&e.previousSibling?(e=e.previousSibling,t+=e.textContent.length):e=e.parentNode}this.savedPos=t}restorePosition(e=0){if(this.savedPos>0&&this.savedPos<e){const e=window.getSelection(),t=createRange(this.el,{count:this.savedPos});t&&(t.collapse(!1),e.removeAllRanges(),e.addRange(t))}}hasParent(e,t){const o=t?this.parent:this.blockParent;return null!==o&&o.nodeName.toLowerCase()===e.toLowerCase()}hasParents(e,t,o=this.parent){return null!==o&&(!0===e.includes(o.nodeName.toLowerCase())||!0===t&&this.hasParents(e,t,o.parentNode))}is(e,t){if(null===this.selection)return!1;switch(e){case"formatBlock":return"DIV"===t&&this.parent===this.el||this.hasParent(t,"PRE"===t);case"link":return this.hasParent("A",!0);case"fontSize":return document.queryCommandValue(e)===t;case"fontName":const o=document.queryCommandValue(e);return o===`"${t}"`||o===t;case"fullscreen":return this.eVm.inFullscreen.value;case"viewsource":return this.eVm.isViewingSource.value;case void 0:return!1;default:const n=document.queryCommandState(e);return void 0!==t?n===t:n}}getParentAttribute(e){return null!==this.parent?this.parent.getAttribute(e):null}can(e){return"outdent"===e?this.hasParents(["blockquote","li"],!0):"indent"===e?this.hasParents(["li"],!0):"link"===e?null!==this.selection||this.is("link"):void 0}apply(e,t,o=noop){if("formatBlock"===e)["BLOCKQUOTE","H1","H2","H3","H4","H5","H6"].includes(t)&&this.is(e,t)&&(e="outdent",t=null),"PRE"===t&&this.is(e,"PRE")&&(t="P");else{if("print"===e){o();const e=window.open();return e.document.write(`\n        <!doctype html>\n        <html>\n          <head>\n            <title>Print - ${document.title}</title>\n          </head>\n          <body>\n            <div>${this.el.innerHTML}</div>\n          </body>\n        </html>\n      `),e.print(),void e.close()}if("link"===e){const e=this.getParentAttribute("href");if(null===e){const e=this.selectWord(this.selection),t=e?e.toString():"";if(!t.length&&(!this.range||!this.range.cloneContents().querySelector("img")))return;this.eVm.editLinkUrl.value=urlRegex.test(t)?t:"https://",document.execCommand("createLink",!1,this.eVm.editLinkUrl.value),this.save(e.getRangeAt(0))}else this.eVm.editLinkUrl.value=e,this.range.selectNodeContents(this.parent),this.save();return}if("fullscreen"===e)return this.eVm.toggleFullscreen(),void o();if("viewsource"===e)return this.eVm.isViewingSource.value=!1===this.eVm.isViewingSource.value,this.eVm.setContent(this.eVm.props.modelValue),void o()}document.execCommand(e,!1,t),o()}selectWord(e){if(null===e||!0!==e.isCollapsed||void 0===e.modify)return e;const t=document.createRange();t.setStart(e.anchorNode,e.anchorOffset),t.setEnd(e.focusNode,e.focusOffset);const o=t.collapsed?["backward","forward"]:["forward","backward"];t.detach();const n=e.focusNode,a=e.focusOffset;return e.collapse(e.anchorNode,e.anchorOffset),e.modify("move",o[0],"character"),e.modify("move",o[1],"word"),e.extend(n,a),e.modify("extend",o[1],"character"),e.modify("extend",o[0],"word"),e}}var QTooltip=createComponent({name:"QTooltip",inheritAttrs:!1,props:{...useAnchorProps,...useModelToggleProps,...useTransitionProps,maxHeight:{type:String,default:null},maxWidth:{type:String,default:null},transitionShow:{default:"jump-down"},transitionHide:{default:"jump-up"},anchor:{type:String,default:"bottom middle",validator:validatePosition},self:{type:String,default:"top middle",validator:validatePosition},offset:{type:Array,default:()=>[14,14],validator:validateOffset},scrollTarget:{default:void 0},delay:{type:Number,default:0},hideDelay:{type:Number,default:0}},emits:[...useModelToggleEmits],setup(e,{slots:t,emit:o,attrs:n}){let a,l;const r=vue.getCurrentInstance(),{proxy:{$q:i}}=r,u=vue.ref(null),s=vue.ref(!1),c=vue.computed(()=>parsePosition(e.anchor,i.lang.rtl)),d=vue.computed(()=>parsePosition(e.self,i.lang.rtl)),v=vue.computed(()=>!0!==e.persistent),{registerTick:p,removeTick:m}=useTick(),{registerTimeout:f}=useTimeout();useTransition(e);const{localScrollTarget:h,changeScrollEvent:g,unconfigureScrollTarget:b}=useScrollTarget(e,A),{anchorEl:y,canShow:S,anchorEvents:x}=useAnchor({showing:s,configureAnchorEl:R}),{show:w,hide:C}=useModelToggle({showing:s,canShow:S,handleShow:T,handleHide:P,hideOnRouteChange:v,processOnMount:!0});Object.assign(x,{delayShow:Q,delayHide:B});const{showPortal:k,hidePortal:_,renderPortal:q}=usePortal();if(!0===i.platform.is.mobile){const t={anchorEl:y,innerRef:u,onClickOutside(e){return C(e),e.target.classList.contains("q-dialog__backdrop")&&stopAndPrevent(e),!0}},o=vue.computed(()=>null===e.modelValue&&!0!==e.persistent&&!0===s.value);vue.watch(o,e=>{const o=!0===e?addClickOutside:removeClickOutside;o(t)}),vue.onBeforeUnmount(()=>{removeClickOutside(t)})}function T(t){k(),p(()=>{l=new MutationObserver(()=>$()),l.observe(u.value,{attributes:!1,childList:!0,characterData:!0,subtree:!0}),$(),A()}),void 0===a&&(a=vue.watch(()=>i.screen.width+"|"+i.screen.height+"|"+e.self+"|"+e.anchor+"|"+i.lang.rtl,$)),f(()=>{k(!0),o("show",t)},e.transitionDuration)}function P(t){m(),_(),M(),f(()=>{_(!0),o("hide",t)},e.transitionDuration)}function M(){void 0!==l&&(l.disconnect(),l=void 0),void 0!==a&&(a(),a=void 0),b(),cleanEvt(x,"tooltipTemp")}function $(){setPosition({targetEl:u.value,offset:e.offset,anchorEl:y.value,anchorOrigin:c.value,selfOrigin:d.value,maxHeight:e.maxHeight,maxWidth:e.maxWidth})}function Q(t){if(!0===i.platform.is.mobile){clearSelection(),document.body.classList.add("non-selectable");const e=y.value,t=["touchmove","touchcancel","touchend","click"].map(t=>[e,t,"delayHide","passiveCapture"]);addEvt(x,"tooltipTemp",t)}f(()=>{w(t)},e.delay)}function B(t){!0===i.platform.is.mobile&&(cleanEvt(x,"tooltipTemp"),clearSelection(),setTimeout(()=>{document.body.classList.remove("non-selectable")},10)),f(()=>{C(t)},e.hideDelay)}function R(){if(!0===e.noParentEvent||null===y.value)return;const t=!0===i.platform.is.mobile?[[y.value,"touchstart","delayShow","passive"]]:[[y.value,"mouseenter","delayShow","passive"],[y.value,"mouseleave","delayHide","passive"]];addEvt(x,"anchor",t)}function A(){if(null!==y.value||void 0!==e.scrollTarget){h.value=getScrollTarget(y.value,e.scrollTarget);const t=!0===e.noParentEvent?$:C;g(h.value,t)}}return vue.onBeforeUnmount(M),Object.assign(r.proxy,{updatePosition:$}),q}}),QItem=createComponent({name:"QItem",props:{...useDarkProps,...useRouterLinkProps,tag:{type:String,default:"div"},active:{type:Boolean,default:null},clickable:Boolean,dense:Boolean,insetLevel:Number,tabindex:[String,Number],focused:Boolean,manualFocus:Boolean},emits:["click","keyup"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=useDark(e,n),{hasLink:l,linkAttrs:r,linkClass:i,linkTag:u,navigateOnClick:s}=useRouterLink(),c=vue.ref(null),d=vue.ref(null),v=vue.computed(()=>!0===e.clickable||!0===l.value||"label"===e.tag),p=vue.computed(()=>!0!==e.disable&&!0===v.value),m=vue.computed(()=>"q-item q-item-type row no-wrap"+(!0===e.dense?" q-item--dense":"")+(!0===a.value?" q-item--dark":"")+(!0===l.value&&null===e.active?i.value:!0===e.active?` q-item--active${void 0!==e.activeClass?` ${e.activeClass}`:""}`:"")+(!0===e.disable?" disabled":"")+(!0===p.value?" q-item--clickable q-link cursor-pointer "+(!0===e.manualFocus?"q-manual-focusable":"q-focusable q-hoverable")+(!0===e.focused?" q-manual-focusable--focused":""):"")),f=vue.computed(()=>{if(void 0===e.insetLevel)return null;const t=!0===n.lang.rtl?"Right":"Left";return{["padding"+t]:16+56*e.insetLevel+"px"}});function h(e){!0===p.value&&(null!==d.value&&(!0!==e.qKeyEvent&&document.activeElement===c.value?d.value.focus():document.activeElement===d.value&&c.value.focus()),s(e))}function g(e){if(!0===p.value&&!0===isKeyCode(e,[13,32])){stopAndPrevent(e),e.qKeyEvent=!0;const t=new MouseEvent("click",e);t.qKeyEvent=!0,c.value.dispatchEvent(t)}o("keyup",e)}function b(){const e=hUniqueSlot(t.default,[]);return!0===p.value&&e.unshift(vue.h("div",{class:"q-focus-helper",tabindex:-1,ref:d})),e}return()=>{const t={ref:c,class:m.value,style:f.value,role:"listitem",onClick:h,onKeyup:g};return!0===p.value?(t.tabindex=e.tabindex||"0",Object.assign(t,r.value)):!0===v.value&&(t["aria-disabled"]="true"),vue.h(u.value,t,b())}}}),QItemSection=createComponent({name:"QItemSection",props:{avatar:Boolean,thumbnail:Boolean,side:Boolean,top:Boolean,noWrap:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>"q-item__section column"+` q-item__section--${!0===e.avatar||!0===e.side||!0===e.thumbnail?"side":"main"}`+(!0===e.top?" q-item__section--top justify-start":" justify-center")+(!0===e.avatar?" q-item__section--avatar":"")+(!0===e.thumbnail?" q-item__section--thumbnail":"")+(!0===e.noWrap?" q-item__section--nowrap":""));return()=>vue.h("div",{class:o.value},hSlot(t.default))}});function run(e,t,o){t.handler?t.handler(e,o,o.caret):o.runCmd(t.cmd,t.param)}function getGroup(e){return vue.h("div",{class:"q-editor__toolbar-group"},e)}function getBtn(e,t,o,n=!1){const a=n||"toggle"===t.type&&(t.toggled?t.toggled(e):t.cmd&&e.caret.is(t.cmd,t.param)),l=[];if(t.tip&&e.$q.platform.is.desktop){const e=t.key?vue.h("div",[vue.h("small",`(CTRL + ${String.fromCharCode(t.key)})`)]):null;l.push(vue.h(QTooltip,{delay:1e3},()=>[vue.h("div",{innerHTML:t.tip}),e]))}return vue.h(QBtn,{...e.buttonProps.value,icon:null!==t.icon?t.icon:void 0,color:a?t.toggleColor||e.props.toolbarToggleColor:t.color||e.props.toolbarColor,textColor:a&&!e.props.toolbarPush?null:t.textColor||e.props.toolbarTextColor,label:t.label,disable:!!t.disable&&("function"!==typeof t.disable||t.disable(e)),size:"sm",onClick(n){o&&o(),run(n,t,e)}},()=>l)}function getDropdown(e,t){const o="only-icons"===t.list;let n,a,l=t.label,r=null!==t.icon?t.icon:void 0;function i(){s.component.proxy.hide()}if(o)a=t.options.map(t=>{const o=void 0===t.type&&e.caret.is(t.cmd,t.param);return o&&(l=t.tip,r=null!==t.icon?t.icon:void 0),getBtn(e,t,i,o)}),n=e.toolbarBackgroundClass.value,a=[getGroup(a)];else{const o=void 0!==e.props.toolbarToggleColor?`text-${e.props.toolbarToggleColor}`:null,u=void 0!==e.props.toolbarTextColor?`text-${e.props.toolbarTextColor}`:null,s="no-icons"===t.list;a=t.options.map(t=>{const n=!!t.disable&&t.disable(e),a=void 0===t.type&&e.caret.is(t.cmd,t.param);a&&(l=t.tip,r=null!==t.icon?t.icon:void 0);const c=t.htmlTip;return vue.h(QItem,{active:a,activeClass:o,clickable:!0,disable:n,dense:!0,onClick(o){i(),null!==e.contentRef.value&&e.contentRef.value.focus(),e.caret.restore(),run(o,t,e)}},()=>[!0===s?null:vue.h(QItemSection,{class:a?o:u,side:!0},()=>vue.h(QIcon,{name:null!==t.icon?t.icon:void 0})),vue.h(QItemSection,c?()=>vue.h("div",{class:"text-no-wrap",innerHTML:t.htmlTip}):t.tip?()=>vue.h("div",{class:"text-no-wrap"},t.tip):void 0)])}),n=[e.toolbarBackgroundClass.value,u]}const u=t.highlight&&l!==t.label,s=vue.h(QBtnDropdown,{...e.buttonProps.value,noCaps:!0,noWrap:!0,color:u?e.props.toolbarToggleColor:e.props.toolbarColor,textColor:u&&!e.props.toolbarPush?null:e.props.toolbarTextColor,label:t.fixedLabel?t.label:l,icon:t.fixedIcon?null!==t.icon?t.icon:void 0:r,contentClass:n,onShow:t=>e.emit("dropdownShow",t),onHide:t=>e.emit("dropdownHide",t),onBeforeShow:t=>e.emit("dropdownBeforeShow",t),onBeforeHide:t=>e.emit("dropdownBeforeHide",t)},()=>a);return s}function getToolbar(e){if(e.caret)return e.buttons.value.filter(t=>{return!e.isViewingSource.value||t.find(e=>"viewsource"===e.cmd)}).map(t=>getGroup(t.map(t=>{return(!e.isViewingSource.value||"viewsource"===t.cmd)&&("slot"===t.type?hSlot(e.slots[t.slot]):"dropdown"===t.type?getDropdown(e,t):getBtn(e,t))})))}function getFonts(e,t,o,n={}){const a=Object.keys(n);if(0===a.length)return{};const l={default_font:{cmd:"fontName",param:e,icon:o,tip:t}};return a.forEach(e=>{const t=n[e];l[e]={cmd:"fontName",param:t,icon:o,tip:t,htmlTip:`<font face="${t}">${t}</font>`}}),l}function getLinkEditor(e){if(e.caret){const t=e.props.toolbarColor||e.props.toolbarTextColor;let o=e.editLinkUrl.value;const n=()=>{e.caret.restore(),o!==e.editLinkUrl.value&&document.execCommand("createLink",!1,""===o?" ":o),e.editLinkUrl.value=null};return[vue.h("div",{class:`q-mx-xs text-${t}`},`${e.$q.lang.editor.url}: `),vue.h("input",{key:"qedt_btm_input",class:"col q-editor__link-input",value:o,onInput:e=>{stop(e),o=e.target.value},onKeydown:t=>{if(!0!==shouldIgnoreKey(t))switch(t.keyCode){case 13:return prevent(t),n();case 27:prevent(t),e.caret.restore(),e.editLinkUrl.value&&"https://"!==e.editLinkUrl.value||document.execCommand("unlink"),e.editLinkUrl.value=null;break}}}),getGroup([vue.h(QBtn,{key:"qedt_btm_rem",tabindex:-1,...e.buttonProps.value,label:e.$q.lang.label.remove,noCaps:!0,onClick:()=>{e.caret.restore(),document.execCommand("unlink"),e.editLinkUrl.value=null}}),vue.h(QBtn,{key:"qedt_btm_upd",...e.buttonProps.value,label:e.$q.lang.label.update,noCaps:!0,onClick:n})])]}}const listenerRE=/^on[A-Z]/;function useSplitAttrs(e,t){const o={listeners:vue.ref({}),attributes:vue.ref({})};function n(){const n={},a={};for(const t in e)"class"!==t&&"style"!==t&&!1===listenerRE.test(t)&&(n[t]=e[t]);for(const e in t.props)!0===listenerRE.test(e)&&(a[e]=t.props[e]);o.attributes.value=n,o.listeners.value=a}return vue.onBeforeUpdate(n),n(),o}const toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,notPlainObject=new Set(["Boolean","Number","String","Function","Array","Date","RegExp"].map(e=>"[object "+e+"]"));function isPlainObject(e){if(e!==Object(e)||!0===notPlainObject.has(toString.call(e)))return!1;if(e.constructor&&!1===hasOwn.call(e,"constructor")&&!1===hasOwn.call(e.constructor.prototype,"isPrototypeOf"))return!1;let t;for(t in e);return void 0===t||hasOwn.call(e,t)}function extend(){let e,t,o,n,a,l,r=arguments[0]||{},i=1,u=!1;const s=arguments.length;for("boolean"===typeof r&&(u=r,r=arguments[1]||{},i=2),Object(r)!==r&&"function"!==typeof r&&(r={}),s===i&&(r=this,i--);i<s;i++)if(null!==(e=arguments[i]))for(t in e)o=r[t],n=e[t],r!==n&&(!0===u&&n&&((a=Array.isArray(n))||!0===isPlainObject(n))?(l=!0===a?!0===Array.isArray(o)?o:[]:!0===isPlainObject(o)?o:{},r[t]=extend(u,l,n)):void 0!==n&&(r[t]=n));return r}var QEditor=createComponent({name:"QEditor",props:{...useDarkProps,...useFullscreenProps,modelValue:{type:String,required:!0},readonly:Boolean,disable:Boolean,minHeight:{type:String,default:"10rem"},maxHeight:String,height:String,definitions:Object,fonts:Object,placeholder:String,toolbar:{type:Array,validator:e=>0===e.length||e.every(e=>e.length),default(){return[["left","center","right","justify"],["bold","italic","underline","strike"],["undo","redo"]]}},toolbarColor:String,toolbarBg:String,toolbarTextColor:String,toolbarToggleColor:{type:String,default:"primary"},toolbarOutline:Boolean,toolbarPush:Boolean,toolbarRounded:Boolean,paragraphTag:{type:String,validator:e=>["div","p"].includes(e),default:"div"},contentStyle:Object,contentClass:[Object,Array,String],square:Boolean,flat:Boolean,dense:Boolean},emits:[...useFullscreenEmits,"update:modelValue","keydown","click","mouseup","keyup","touchend","focus","blur","dropdownShow","dropdownHide","dropdownBeforeShow","dropdownBeforeHide","linkShow","linkHide"],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a,vnode:l}=vue.getCurrentInstance(),{$q:r}=a,i=useDark(e,r),{inFullscreen:u,toggleFullscreen:s}=useFullscreen(),c=useSplitAttrs(n,l),d=vue.ref(null),v=vue.ref(null),p=vue.ref(null),m=vue.ref(!1),f=vue.computed(()=>!e.readonly&&!e.disable);let h,g,b=e.modelValue;const y=vue.computed(()=>e.toolbarBg?` bg-${e.toolbarBg}`:""),S=vue.computed(()=>{const t=!0!==e.toolbarOutline&&!0!==e.toolbarPush;return{type:"a",flat:t,noWrap:!0,outline:e.toolbarOutline,push:e.toolbarPush,rounded:e.toolbarRounded,dense:!0,color:e.toolbarColor,disable:!f.value,size:"sm"}}),x=vue.computed(()=>{const t=r.lang.editor,o=r.iconSet.editor;return{bold:{cmd:"bold",icon:o.bold,tip:t.bold,key:66},italic:{cmd:"italic",icon:o.italic,tip:t.italic,key:73},strike:{cmd:"strikeThrough",icon:o.strikethrough,tip:t.strikethrough,key:83},underline:{cmd:"underline",icon:o.underline,tip:t.underline,key:85},unordered:{cmd:"insertUnorderedList",icon:o.unorderedList,tip:t.unorderedList},ordered:{cmd:"insertOrderedList",icon:o.orderedList,tip:t.orderedList},subscript:{cmd:"subscript",icon:o.subscript,tip:t.subscript,htmlTip:"x<subscript>2</subscript>"},superscript:{cmd:"superscript",icon:o.superscript,tip:t.superscript,htmlTip:"x<superscript>2</superscript>"},link:{cmd:"link",disable:e=>e.caret&&!e.caret.can("link"),icon:o.hyperlink,tip:t.hyperlink,key:76},fullscreen:{cmd:"fullscreen",icon:o.toggleFullscreen,tip:t.toggleFullscreen,key:70},viewsource:{cmd:"viewsource",icon:o.viewSource,tip:t.viewSource},quote:{cmd:"formatBlock",param:"BLOCKQUOTE",icon:o.quote,tip:t.quote,key:81},left:{cmd:"justifyLeft",icon:o.left,tip:t.left},center:{cmd:"justifyCenter",icon:o.center,tip:t.center},right:{cmd:"justifyRight",icon:o.right,tip:t.right},justify:{cmd:"justifyFull",icon:o.justify,tip:t.justify},print:{type:"no-state",cmd:"print",icon:o.print,tip:t.print,key:80},outdent:{type:"no-state",disable:e=>e.caret&&!e.caret.can("outdent"),cmd:"outdent",icon:o.outdent,tip:t.outdent},indent:{type:"no-state",disable:e=>e.caret&&!e.caret.can("indent"),cmd:"indent",icon:o.indent,tip:t.indent},removeFormat:{type:"no-state",cmd:"removeFormat",icon:o.removeFormat,tip:t.removeFormat},hr:{type:"no-state",cmd:"insertHorizontalRule",icon:o.hr,tip:t.hr},undo:{type:"no-state",cmd:"undo",icon:o.undo,tip:t.undo,key:90},redo:{type:"no-state",cmd:"redo",icon:o.redo,tip:t.redo,key:89},h1:{cmd:"formatBlock",param:"H1",icon:o.heading1||o.heading,tip:t.heading1,htmlTip:`<h1 class="q-ma-none">${t.heading1}</h1>`},h2:{cmd:"formatBlock",param:"H2",icon:o.heading2||o.heading,tip:t.heading2,htmlTip:`<h2 class="q-ma-none">${t.heading2}</h2>`},h3:{cmd:"formatBlock",param:"H3",icon:o.heading3||o.heading,tip:t.heading3,htmlTip:`<h3 class="q-ma-none">${t.heading3}</h3>`},h4:{cmd:"formatBlock",param:"H4",icon:o.heading4||o.heading,tip:t.heading4,htmlTip:`<h4 class="q-ma-none">${t.heading4}</h4>`},h5:{cmd:"formatBlock",param:"H5",icon:o.heading5||o.heading,tip:t.heading5,htmlTip:`<h5 class="q-ma-none">${t.heading5}</h5>`},h6:{cmd:"formatBlock",param:"H6",icon:o.heading6||o.heading,tip:t.heading6,htmlTip:`<h6 class="q-ma-none">${t.heading6}</h6>`},p:{cmd:"formatBlock",param:e.paragraphTag,icon:o.heading,tip:t.paragraph},code:{cmd:"formatBlock",param:"PRE",icon:o.code,htmlTip:`<code>${t.code}</code>`},"size-1":{cmd:"fontSize",param:"1",icon:o.size1||o.size,tip:t.size1,htmlTip:`<font size="1">${t.size1}</font>`},"size-2":{cmd:"fontSize",param:"2",icon:o.size2||o.size,tip:t.size2,htmlTip:`<font size="2">${t.size2}</font>`},"size-3":{cmd:"fontSize",param:"3",icon:o.size3||o.size,tip:t.size3,htmlTip:`<font size="3">${t.size3}</font>`},"size-4":{cmd:"fontSize",param:"4",icon:o.size4||o.size,tip:t.size4,htmlTip:`<font size="4">${t.size4}</font>`},"size-5":{cmd:"fontSize",param:"5",icon:o.size5||o.size,tip:t.size5,htmlTip:`<font size="5">${t.size5}</font>`},"size-6":{cmd:"fontSize",param:"6",icon:o.size6||o.size,tip:t.size6,htmlTip:`<font size="6">${t.size6}</font>`},"size-7":{cmd:"fontSize",param:"7",icon:o.size7||o.size,tip:t.size7,htmlTip:`<font size="7">${t.size7}</font>`}}}),w=vue.computed(()=>{const t=e.definitions||{},o=e.definitions||e.fonts?extend(!0,{},x.value,t,getFonts(h,r.lang.editor.defaultFont,r.iconSet.editor.font,e.fonts)):x.value;return e.toolbar.map(e=>e.map(e=>{if(e.options)return{type:"dropdown",icon:e.icon,label:e.label,size:"sm",dense:!0,fixedLabel:e.fixedLabel,fixedIcon:e.fixedIcon,highlight:e.highlight,list:e.list,options:e.options.map(e=>o[e])};const n=o[e];return n?"no-state"===n.type||t[e]&&(void 0===n.cmd||x.value[n.cmd]&&"no-state"===x.value[n.cmd].type)?n:Object.assign({type:"toggle"},n):{type:"slot",slot:e}}))}),C={$q:r,props:e,slots:t,emit:o,inFullscreen:u,toggleFullscreen:s,runCmd:z,isViewingSource:m,editLinkUrl:p,toolbarBackgroundClass:y,buttonProps:S,contentRef:v,buttons:w,setContent:O};vue.watch(()=>e.modelValue,e=>{b!==e&&(b=e,O(e,!0))}),vue.watch(p,e=>{o(`link${e?"Show":"Hide"}`)});const k=vue.computed(()=>e.toolbar&&0!==e.toolbar.length),_=vue.computed(()=>{const e={},t=t=>{t.key&&(e[t.key]={cmd:t.cmd,param:t.param})};return w.value.forEach(e=>{e.forEach(e=>{e.options?e.options.forEach(t):t(e)})}),e}),q=vue.computed(()=>u.value?e.contentStyle:[{minHeight:e.minHeight,height:e.height,maxHeight:e.maxHeight},e.contentStyle]),T=vue.computed(()=>`q-editor q-editor--${!0===m.value?"source":"default"}`+(!0===e.disable?" disabled":"")+(!0===u.value?" fullscreen column":"")+(!0===e.square?" q-editor--square no-border-radius":"")+(!0===e.flat?" q-editor--flat":"")+(!0===e.dense?" q-editor--dense":"")+(!0===i.value?" q-editor--dark q-dark":"")),P=vue.computed(()=>[e.contentClass,"q-editor__content",{col:u.value,"overflow-auto":u.value||e.maxHeight}]),M=vue.computed(()=>!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{});function $(){if(null!==v.value){const t=`inner${!0===m.value?"Text":"HTML"}`,n=v.value[t];n!==e.modelValue&&(b=n,o("update:modelValue",n))}}function Q(e){if(o("keydown",e),!0!==e.ctrlKey||!0===shouldIgnoreKey(e))return void V();const t=e.keyCode,n=_.value[t];if(void 0!==n){const{cmd:t,param:o}=n;stopAndPrevent(e),z(t,o,!1)}}function B(e){V(),o("click",e)}function R(e){if(null!==v.value){const{scrollTop:e,scrollHeight:t}=v.value;g=t-e}C.caret.save(),o("blur",e)}function A(e){vue.nextTick(()=>{null!==v.value&&void 0!==g&&(v.value.scrollTop=v.value.scrollHeight-g)}),o("focus",e)}function F(e){const t=d.value;if(null!==t&&!0===t.contains(e.target)&&(null===e.relatedTarget||!0!==t.contains(e.relatedTarget))){const e=`inner${!0===m.value?"Text":"HTML"}`;C.caret.restorePosition(v.value[e].length),V()}}function E(e){const t=d.value;null===t||!0!==t.contains(e.target)||null!==e.relatedTarget&&!0===t.contains(e.relatedTarget)||(C.caret.savePosition(),V())}function D(){g=void 0}function I(e){C.caret.save()}function O(e,t){if(null!==v.value){!0===t&&C.caret.savePosition();const o=`inner${!0===m.value?"Text":"HTML"}`;v.value[o]=e,!0===t&&(C.caret.restorePosition(v.value[o].length),V())}}function z(e,t,o=!0){L(),C.caret.restore(),C.caret.apply(e,t,()=>{L(),C.caret.save(),o&&V()})}function V(){setTimeout(()=>{p.value=null,a.$forceUpdate()},1)}function L(){addFocusFn(()=>{null!==v.value&&v.value.focus({preventScroll:!0})})}function H(){return v.value}return vue.onMounted(()=>{C.caret=a.caret=new Caret(v.value,C),O(e.modelValue),V(),document.addEventListener("selectionchange",I)}),vue.onBeforeUnmount(()=>{document.removeEventListener("selectionchange",I)}),Object.assign(a,{runCmd:z,refreshToolbar:V,focus:L,getContentEl:H}),()=>{let t;if(k.value){const e=[vue.h("div",{key:"qedt_top",class:"q-editor__toolbar row no-wrap scroll-x"+y.value},getToolbar(C))];null!==p.value&&e.push(vue.h("div",{key:"qedt_btm",class:"q-editor__toolbar row no-wrap items-center scroll-x"+y.value},getLinkEditor(C))),t=vue.h("div",{key:"toolbar_ctainer",class:"q-editor__toolbars-container"},e)}return vue.h("div",{ref:d,class:T.value,style:{height:!0===u.value?"100%":null},...M.value,onFocusin:F,onFocusout:E},[t,vue.h("div",{ref:v,style:q.value,class:P.value,contenteditable:f.value,placeholder:e.placeholder,...{innerHTML:e.modelValue},...c.listeners.value,onInput:$,onKeydown:Q,onClick:B,onBlur:R,onFocus:A,onMousedown:D,onTouchstartPassive:D})])}}}),QItemLabel=createComponent({name:"QItemLabel",props:{overline:Boolean,caption:Boolean,header:Boolean,lines:[Number,String]},setup(e,{slots:t}){const o=vue.computed(()=>parseInt(e.lines,10)),n=vue.computed(()=>"q-item__label"+(!0===e.overline?" q-item__label--overline text-overline":"")+(!0===e.caption?" q-item__label--caption text-caption":"")+(!0===e.header?" q-item__label--header":"")+(1===o.value?" ellipsis":"")),a=vue.computed(()=>{return void 0!==e.lines&&o.value>1?{overflow:"hidden",display:"-webkit-box","-webkit-box-orient":"vertical","-webkit-line-clamp":o.value}:null});return()=>vue.h("div",{style:a.value,class:n.value},hSlot(t.default))}}),QSlideTransition=createComponent({name:"QSlideTransition",props:{appear:Boolean,duration:{type:Number,default:300}},emits:["show","hide"],setup(e,{slots:t,emit:o}){let n,a,l,r,i=!1,u=null,s=null;function c(){n&&n(),n=null,i=!1,null!==u&&(clearTimeout(u),u=null),null!==s&&(clearTimeout(s),s=null),void 0!==a&&a.removeEventListener("transitionend",l),l=null}function d(t,o,a){void 0!==o&&(t.style.height=`${o}px`),t.style.transition=`height ${e.duration}ms cubic-bezier(.25, .8, .50, 1)`,i=!0,n=a}function v(e,t){e.style.overflowY=null,e.style.height=null,e.style.transition=null,c(),t!==r&&o(t)}function p(t,o){let n=0;a=t,!0===i?(c(),n=t.offsetHeight===t.scrollHeight?0:void 0):(r="hide",t.style.overflowY="hidden"),d(t,n,o),u=setTimeout(()=>{u=null,t.style.height=`${t.scrollHeight}px`,l=(e=>{s=null,Object(e)===e&&e.target!==t||v(t,"show")}),t.addEventListener("transitionend",l),s=setTimeout(l,1.1*e.duration)},100)}function m(t,o){let n;a=t,!0===i?c():(r="show",t.style.overflowY="hidden",n=t.scrollHeight),d(t,n,o),u=setTimeout(()=>{u=null,t.style.height=0,l=(e=>{s=null,Object(e)===e&&e.target!==t||v(t,"hide")}),t.addEventListener("transitionend",l),s=setTimeout(l,1.1*e.duration)},100)}return vue.onBeforeUnmount(()=>{!0===i&&c()}),()=>vue.h(vue.Transition,{css:!1,appear:e.appear,onEnter:p,onLeave:m},t.default)}});const insetMap={true:"inset",item:"item-inset","item-thumbnail":"item-thumbnail-inset"},margins={xs:2,sm:4,md:8,lg:16,xl:24};var QSeparator=createComponent({name:"QSeparator",props:{...useDarkProps,spaced:[Boolean,String],inset:[Boolean,String],vertical:Boolean,color:String,size:String},setup(e){const t=vue.getCurrentInstance(),o=useDark(e,t.proxy.$q),n=vue.computed(()=>!0===e.vertical?"vertical":"horizontal"),a=vue.computed(()=>` q-separator--${n.value}`),l=vue.computed(()=>!1!==e.inset?`${a.value}-${insetMap[e.inset]}`:""),r=vue.computed(()=>`q-separator${a.value}${l.value}`+(void 0!==e.color?` bg-${e.color}`:"")+(!0===o.value?" q-separator--dark":"")),i=vue.computed(()=>{const t={};if(void 0!==e.size&&(t[!0===e.vertical?"width":"height"]=e.size),!1!==e.spaced){const o=!0===e.spaced?`${margins.md}px`:e.spaced in margins?`${margins[e.spaced]}px`:e.spaced,n=!0===e.vertical?["Left","Right"]:["Top","Bottom"];t[`margin${n[0]}`]=t[`margin${n[1]}`]=o}return t});return()=>vue.h("hr",{class:r.value,style:i.value,"aria-orientation":n.value})}});const itemGroups=vue.shallowReactive({}),LINK_PROPS=Object.keys(useRouterLinkProps);var QExpansionItem=createComponent({name:"QExpansionItem",props:{...useRouterLinkProps,...useModelToggleProps,...useDarkProps,icon:String,label:String,labelLines:[Number,String],caption:String,captionLines:[Number,String],dense:Boolean,toggleAriaLabel:String,expandIcon:String,expandedIcon:String,expandIconClass:[Array,String,Object],duration:Number,headerInsetLevel:Number,contentInsetLevel:Number,expandSeparator:Boolean,defaultOpened:Boolean,hideExpandIcon:Boolean,expandIconToggle:Boolean,switchToggleSide:Boolean,denseToggle:Boolean,group:String,popup:Boolean,headerStyle:[Array,String,Object],headerClass:[Array,String,Object]},emits:[...useModelToggleEmits,"click","afterShow","afterHide"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=useDark(e,n),l=vue.ref(null!==e.modelValue?e.modelValue:e.defaultOpened),r=vue.ref(null),i=uid(),{show:u,hide:s,toggle:c}=useModelToggle({showing:l});let d,v;const p=vue.computed(()=>"q-expansion-item q-item-type"+` q-expansion-item--${!0===l.value?"expanded":"collapsed"}`+` q-expansion-item--${!0===e.popup?"popup":"standard"}`),m=vue.computed(()=>{if(void 0===e.contentInsetLevel)return null;const t=!0===n.lang.rtl?"Right":"Left";return{["padding"+t]:56*e.contentInsetLevel+"px"}}),f=vue.computed(()=>!0!==e.disable&&(void 0!==e.href||void 0!==e.to&&null!==e.to&&""!==e.to)),h=vue.computed(()=>{const t={};return LINK_PROPS.forEach(o=>{t[o]=e[o]}),t}),g=vue.computed(()=>!0===f.value||!0!==e.expandIconToggle),b=vue.computed(()=>void 0!==e.expandedIcon&&!0===l.value?e.expandedIcon:e.expandIcon||n.iconSet.expansionItem[!0===e.denseToggle?"denseIcon":"icon"]),y=vue.computed(()=>!0!==e.disable&&(!0===f.value||!0===e.expandIconToggle)),S=vue.computed(()=>({expanded:!0===l.value,detailsId:e.targetUid,toggle:c,show:u,hide:s})),x=vue.computed(()=>{const t=void 0!==e.toggleAriaLabel?e.toggleAriaLabel:n.lang.label[!0===l.value?"collapse":"expand"](e.label);return{role:"button","aria-expanded":!0===l.value?"true":"false","aria-controls":i,"aria-label":t}});function w(e){!0!==f.value&&c(e),o("click",e)}function C(e){13===e.keyCode&&k(e,!0)}function k(e,t){!0!==t&&null!==r.value&&r.value.focus(),c(e),stopAndPrevent(e)}function _(){o("afterShow")}function q(){o("afterHide")}function T(){void 0===d&&(d=uid()),!0===l.value&&(itemGroups[e.group]=d);const t=vue.watch(l,t=>{!0===t?itemGroups[e.group]=d:itemGroups[e.group]===d&&delete itemGroups[e.group]}),o=vue.watch(()=>itemGroups[e.group],(e,t)=>{t===d&&void 0!==e&&e!==d&&s()});v=(()=>{t(),o(),itemGroups[e.group]===d&&delete itemGroups[e.group],v=void 0})}function P(){const t={class:["q-focusable relative-position cursor-pointer"+`${!0===e.denseToggle&&!0===e.switchToggleSide?" items-end":""}`,e.expandIconClass],side:!0!==e.switchToggleSide,avatar:e.switchToggleSide},o=[vue.h(QIcon,{class:"q-expansion-item__toggle-icon"+(void 0===e.expandedIcon&&!0===l.value?" q-expansion-item__toggle-icon--rotated":""),name:b.value})];return!0===y.value&&(Object.assign(t,{tabindex:0,...x.value,onClick:k,onKeyup:C}),o.unshift(vue.h("div",{ref:r,class:"q-expansion-item__toggle-focus q-icon q-focus-helper q-focus-helper--rounded",tabindex:-1}))),vue.h(QItemSection,t,()=>o)}function M(){let o;return void 0!==t.header?o=[].concat(t.header(S.value)):(o=[vue.h(QItemSection,()=>[vue.h(QItemLabel,{lines:e.labelLines},()=>e.label||""),e.caption?vue.h(QItemLabel,{lines:e.captionLines,caption:!0},()=>e.caption):null])],e.icon&&o[!0===e.switchToggleSide?"push":"unshift"](vue.h(QItemSection,{side:!0===e.switchToggleSide,avatar:!0!==e.switchToggleSide},()=>vue.h(QIcon,{name:e.icon})))),!0!==e.disable&&!0!==e.hideExpandIcon&&o[!0===e.switchToggleSide?"unshift":"push"](P()),o}function $(){const t={ref:"item",style:e.headerStyle,class:e.headerClass,dark:a.value,disable:e.disable,dense:e.dense,insetLevel:e.headerInsetLevel};return!0===g.value&&(t.clickable=!0,t.onClick=w,Object.assign(t,!0===f.value?h.value:x.value)),vue.h(QItem,t,M)}function Q(){return vue.withDirectives(vue.h("div",{key:"e-content",class:"q-expansion-item__content relative-position",style:m.value,id:i},hSlot(t.default)),[[vue.vShow,l.value]])}function B(){const t=[$(),vue.h(QSlideTransition,{duration:e.duration,onShow:_,onHide:q},Q)];return!0===e.expandSeparator&&t.push(vue.h(QSeparator,{class:"q-expansion-item__border q-expansion-item__border--top absolute-top",dark:a.value}),vue.h(QSeparator,{class:"q-expansion-item__border q-expansion-item__border--bottom absolute-bottom",dark:a.value})),t}return vue.watch(()=>e.group,e=>{void 0!==v&&v(),void 0!==e&&T()}),void 0!==e.group&&T(),vue.onBeforeUnmount(()=>{void 0!==v&&v()}),()=>vue.h("div",{class:p.value},[vue.h("div",{class:"q-expansion-item__container relative-position"},B())])}});const labelPositions=["top","right","bottom","left"],useFabProps={type:{type:String,default:"a"},outline:Boolean,push:Boolean,flat:Boolean,unelevated:Boolean,color:String,textColor:String,glossy:Boolean,square:Boolean,padding:String,label:{type:[String,Number],default:""},labelPosition:{type:String,default:"right",validator:e=>labelPositions.includes(e)},externalLabel:Boolean,hideLabel:{type:Boolean},labelClass:[Array,String,Object],labelStyle:[Array,String,Object],disable:Boolean,tabindex:[Number,String]};function useFab(e,t){return{formClass:vue.computed(()=>`q-fab--form-${!0===e.square?"square":"rounded"}`),stacked:vue.computed(()=>!1===e.externalLabel&&["top","bottom"].includes(e.labelPosition)),labelProps:vue.computed(()=>{if(!0===e.externalLabel){const o=null===e.hideLabel?!1===t.value:e.hideLabel;return{action:"push",data:{class:[e.labelClass,"q-fab__label q-tooltip--style q-fab__label--external"+` q-fab__label--external-${e.labelPosition}`+(!0===o?" q-fab__label--external-hidden":"")],style:e.labelStyle}}}return{action:["left","top"].includes(e.labelPosition)?"unshift":"push",data:{class:[e.labelClass,`q-fab__label q-fab__label--internal q-fab__label--internal-${e.labelPosition}`+(!0===e.hideLabel?" q-fab__label--internal-hidden":"")],style:e.labelStyle}}})}}const directions=["up","right","down","left"],alignValues=["left","center","right"];var QFab=createComponent({name:"QFab",props:{...useFabProps,...useModelToggleProps,icon:String,activeIcon:String,hideIcon:Boolean,hideLabel:{default:null},direction:{type:String,default:"right",validator:e=>directions.includes(e)},persistent:Boolean,verticalActionsAlign:{type:String,default:"center",validator:e=>alignValues.includes(e)}},emits:useModelToggleEmits,setup(e,{slots:t}){const o=vue.ref(null),n=vue.ref(!0===e.modelValue),a=uid(),{proxy:{$q:l}}=vue.getCurrentInstance(),{formClass:r,labelProps:i}=useFab(e,n),u=vue.computed(()=>!0!==e.persistent),{hide:s,toggle:c}=useModelToggle({showing:n,hideOnRouteChange:u}),d=vue.computed(()=>({opened:n.value})),v=vue.computed(()=>"q-fab z-fab row inline justify-center"+` q-fab--align-${e.verticalActionsAlign} ${r.value}`+(!0===n.value?" q-fab--opened":" q-fab--closed")),p=vue.computed(()=>"q-fab__actions flex no-wrap inline"+` q-fab__actions--${e.direction}`+` q-fab__actions--${!0===n.value?"opened":"closed"}`),m=vue.computed(()=>{const e={id:a,role:"menu"};return!0!==n.value&&(e["aria-hidden"]="true"),e}),f=vue.computed(()=>"q-fab__icon-holder "+` q-fab__icon-holder--${!0===n.value?"opened":"closed"}`);function h(o,n){const a=t[o],r=`q-fab__${o} absolute-full`;return void 0===a?vue.h(QIcon,{class:r,name:e[n]||l.iconSet.fab[n]}):vue.h("div",{class:r},a(d.value))}function g(){const o=[];return!0!==e.hideIcon&&o.push(vue.h("div",{class:f.value},[h("icon","icon"),h("active-icon","activeIcon")])),""===e.label&&void 0===t.label||o[i.value.action](vue.h("div",i.value.data,void 0!==t.label?t.label(d.value):[e.label])),hMergeSlot(t.tooltip,o)}return vue.provide(fabKey,{showing:n,onChildClick(e){s(e),null!==o.value&&o.value.$el.focus()}}),()=>vue.h("div",{class:v.value},[vue.h(QBtn,{ref:o,class:r.value,...e,noWrap:!0,stack:e.stacked,align:void 0,icon:void 0,label:void 0,noCaps:!0,fab:!0,"aria-expanded":!0===n.value?"true":"false","aria-haspopup":"true","aria-controls":a,onClick:c},g),vue.h("div",{class:p.value,...m.value},hSlot(t.default))])}});const anchorMap={start:"self-end",center:"self-center",end:"self-start"},anchorValues=Object.keys(anchorMap);var QFabAction=createComponent({name:"QFabAction",props:{...useFabProps,icon:{type:String,default:""},anchor:{type:String,validator:e=>anchorValues.includes(e)},to:[String,Object],replace:Boolean},emits:["click"],setup(e,{slots:t,emit:o}){const n=vue.inject(fabKey,()=>({showing:{value:!0},onChildClick:noop})),{formClass:a,labelProps:l}=useFab(e,n.showing),r=vue.computed(()=>{const t=anchorMap[e.anchor];return a.value+(void 0!==t?` ${t}`:"")}),i=vue.computed(()=>!0===e.disable||!0!==n.showing.value);function u(e){n.onChildClick(e),o("click",e)}function s(){const o=[];return void 0!==t.icon?o.push(t.icon()):""!==e.icon&&o.push(vue.h(QIcon,{name:e.icon})),""===e.label&&void 0===t.label||o[l.value.action](vue.h("div",l.value.data,void 0!==t.label?t.label():[e.label])),hMergeSlot(t.default,o)}const c=vue.getCurrentInstance();return Object.assign(c.proxy,{click:u}),()=>vue.h(QBtn,{class:r.value,...e,noWrap:!0,stack:e.stacked,icon:void 0,label:void 0,noCaps:!0,fabMini:!0,disable:i.value,onClick:u},s)}});function useFormChild({validate:e,resetValidation:t,requiresQForm:o}){const n=vue.inject(formKey,!1);if(!1!==n){const{props:o,proxy:a}=vue.getCurrentInstance();Object.assign(a,{validate:e,resetValidation:t}),vue.watch(()=>o.disable,e=>{!0===e?("function"===typeof t&&t(),n.unbindComponent(a)):n.bindComponent(a)}),vue.onMounted(()=>{!0!==o.disable&&n.bindComponent(a)}),vue.onBeforeUnmount(()=>{!0!==o.disable&&n.unbindComponent(a)})}else!0===o&&console.error("Parent QForm not found on useFormChild()!")}const lazyRulesValues=[!0,!1,"ondemand"],useValidateProps={modelValue:{},error:{type:Boolean,default:null},errorMessage:String,noErrorIcon:Boolean,rules:Array,reactiveRules:Boolean,lazyRules:{type:[Boolean,String],validator:e=>lazyRulesValues.includes(e)}};function useValidate(e,t){const{props:o,proxy:n}=vue.getCurrentInstance(),a=vue.ref(!1),l=vue.ref(null),r=vue.ref(null);useFormChild({validate:m,resetValidation:p});let i,u=0;const s=vue.computed(()=>void 0!==o.rules&&null!==o.rules&&0!==o.rules.length),c=vue.computed(()=>!0!==o.disable&&!0===s.value),d=vue.computed(()=>!0===o.error||!0===a.value),v=vue.computed(()=>"string"===typeof o.errorMessage&&0!==o.errorMessage.length?o.errorMessage:l.value);function p(){u++,t.value=!1,r.value=null,a.value=!1,l.value=null,h.cancel()}function m(e=o.modelValue){if(!0!==c.value)return!0;const n=++u,i=!0!==t.value?()=>{r.value=!0}:()=>{},s=(e,o)=>{!0===e&&i(),a.value=e,l.value=o||null,t.value=!1},d=[];for(let t=0;t<o.rules.length;t++){const n=o.rules[t];let a;if("function"===typeof n?a=n(e,testPattern):"string"===typeof n&&void 0!==testPattern[n]&&(a=testPattern[n](e)),!1===a||"string"===typeof a)return s(!0,a),!1;!0!==a&&void 0!==a&&d.push(a)}return 0===d.length?(s(!1),!0):(t.value=!0,Promise.all(d).then(e=>{if(void 0===e||!1===Array.isArray(e)||0===e.length)return n===u&&s(!1),!0;const t=e.find(e=>!1===e||"string"===typeof e);return n===u&&s(void 0!==t,t),void 0===t},e=>{return n===u&&(console.error(e),s(!0)),!1}))}function f(e){!0===c.value&&"ondemand"!==o.lazyRules&&(!0===r.value||!0!==o.lazyRules&&!0!==e)&&h()}vue.watch(()=>o.modelValue,()=>{f()}),vue.watch(()=>o.reactiveRules,e=>{!0===e?void 0===i&&(i=vue.watch(()=>o.rules,()=>{f(!0)})):void 0!==i&&(i(),i=void 0)},{immediate:!0}),vue.watch(e,e=>{!0===e?null===r.value&&(r.value=!1):!1===r.value&&(r.value=!0,!0===c.value&&"ondemand"!==o.lazyRules&&!1===t.value&&h())});const h=debounce(m,0);return vue.onBeforeUnmount(()=>{void 0!==i&&i(),h.cancel()}),Object.assign(n,{resetValidation:p,validate:m}),injectProp(n,"hasError",()=>d.value),{isDirtyModel:r,hasRules:s,hasError:d,errorMessage:v,validate:m,resetValidation:p}}function getTargetUid(e,t){return void 0===e?!0===t?`f_${uid()}`:void 0:e}function fieldValueIsFilled(e){return void 0!==e&&null!==e&&0!==(""+e).length}const useFieldProps={...useDarkProps,...useValidateProps,label:String,stackLabel:Boolean,hint:String,hideHint:Boolean,prefix:String,suffix:String,labelColor:String,color:String,bgColor:String,filled:Boolean,outlined:Boolean,borderless:Boolean,standout:[Boolean,String],square:Boolean,loading:Boolean,labelSlot:Boolean,bottomSlots:Boolean,hideBottomSpace:Boolean,rounded:Boolean,dense:Boolean,itemAligned:Boolean,counter:Boolean,clearable:Boolean,clearIcon:String,disable:Boolean,readonly:Boolean,autofocus:Boolean,for:String,maxlength:[Number,String]},useFieldEmits=["update:modelValue","clear","focus","blur","popupShow","popupHide"];function useFieldState({requiredForAttr:e=!0,tagProp:t}={}){const{props:o,attrs:n,proxy:a,vnode:l}=vue.getCurrentInstance(),r=useDark(o,a.$q);return{requiredForAttr:e,tag:!0===t?vue.computed(()=>o.tag):{value:"label"},isDark:r,editable:vue.computed(()=>!0!==o.disable&&!0!==o.readonly),innerLoading:vue.ref(!1),focused:vue.ref(!1),hasPopupOpen:!1,splitAttrs:useSplitAttrs(n,l),targetUid:vue.ref(getTargetUid(o.for,e)),rootRef:vue.ref(null),targetRef:vue.ref(null),controlRef:vue.ref(null)}}function useField(e){const{props:t,emit:o,slots:n,attrs:a,proxy:l}=vue.getCurrentInstance(),{$q:r}=l;let i=null;void 0===e.hasValue&&(e.hasValue=vue.computed(()=>fieldValueIsFilled(t.modelValue))),void 0===e.emitValue&&(e.emitValue=(e=>{o("update:modelValue",e)})),void 0===e.controlEvents&&(e.controlEvents={onFocusin:_,onFocusout:q}),Object.assign(e,{clearValue:T,onControlFocusin:_,onControlFocusout:q,focus:C}),void 0===e.computedCounter&&(e.computedCounter=vue.computed(()=>{if(!1!==t.counter){const e="string"===typeof t.modelValue||"number"===typeof t.modelValue?(""+t.modelValue).length:!0===Array.isArray(t.modelValue)?t.modelValue.length:0,o=void 0!==t.maxlength?t.maxlength:t.maxValues;return e+(void 0!==o?" / "+o:"")}}));const{isDirtyModel:u,hasRules:s,hasError:c,errorMessage:d,resetValidation:v}=useValidate(e.focused,e.innerLoading),p=void 0!==e.floatingLabel?vue.computed(()=>!0===t.stackLabel||!0===e.focused.value||!0===e.floatingLabel.value):vue.computed(()=>!0===t.stackLabel||!0===e.focused.value||!0===e.hasValue.value),m=vue.computed(()=>!0===t.bottomSlots||void 0!==t.hint||!0===s.value||!0===t.counter||null!==t.error),f=vue.computed(()=>{return!0===t.filled?"filled":!0===t.outlined?"outlined":!0===t.borderless?"borderless":t.standout?"standout":"standard"}),h=vue.computed(()=>`q-field row no-wrap items-start q-field--${f.value}`+(void 0!==e.fieldClass?` ${e.fieldClass.value}`:"")+(!0===t.rounded?" q-field--rounded":"")+(!0===t.square?" q-field--square":"")+(!0===p.value?" q-field--float":"")+(!0===b.value?" q-field--labeled":"")+(!0===t.dense?" q-field--dense":"")+(!0===t.itemAligned?" q-field--item-aligned q-item-type":"")+(!0===e.isDark.value?" q-field--dark":"")+(void 0===e.getControl?" q-field--auto-height":"")+(!0===e.focused.value?" q-field--focused":"")+(!0===c.value?" q-field--error":"")+(!0===c.value||!0===e.focused.value?" q-field--highlighted":"")+(!0!==t.hideBottomSpace&&!0===m.value?" q-field--with-bottom":"")+(!0===t.disable?" q-field--disabled":!0===t.readonly?" q-field--readonly":"")),g=vue.computed(()=>"q-field__control relative-position row no-wrap"+(void 0!==t.bgColor?` bg-${t.bgColor}`:"")+(!0===c.value?" text-negative":"string"===typeof t.standout&&0!==t.standout.length&&!0===e.focused.value?` ${t.standout}`:void 0!==t.color?` text-${t.color}`:"")),b=vue.computed(()=>!0===t.labelSlot||void 0!==t.label),y=vue.computed(()=>"q-field__label no-pointer-events absolute ellipsis"+(void 0!==t.labelColor&&!0!==c.value?` text-${t.labelColor}`:"")),S=vue.computed(()=>({id:e.targetUid.value,editable:e.editable.value,focused:e.focused.value,floatingLabel:p.value,modelValue:t.modelValue,emitValue:e.emitValue})),x=vue.computed(()=>{const o={for:e.targetUid.value};return!0===t.disable?o["aria-disabled"]="true":!0===t.readonly&&(o["aria-readonly"]="true"),o});function w(){const t=document.activeElement;let o=void 0!==e.targetRef&&e.targetRef.value;!o||null!==t&&t.id===e.targetUid.value||(!0===o.hasAttribute("tabindex")||(o=o.querySelector("[tabindex]")),o&&o!==t&&o.focus({preventScroll:!0}))}function C(){addFocusFn(w)}function k(){removeFocusFn(w);const t=document.activeElement;null!==t&&e.rootRef.value.contains(t)&&t.blur()}function _(t){null!==i&&(clearTimeout(i),i=null),!0===e.editable.value&&!1===e.focused.value&&(e.focused.value=!0,o("focus",t))}function q(t,n){null!==i&&clearTimeout(i),i=setTimeout(()=>{i=null,(!0!==document.hasFocus()||!0!==e.hasPopupOpen&&void 0!==e.controlRef&&null!==e.controlRef.value&&!1===e.controlRef.value.contains(document.activeElement))&&(!0===e.focused.value&&(e.focused.value=!1,o("blur",t)),void 0!==n&&n())})}function T(n){if(stopAndPrevent(n),!0!==r.platform.is.mobile){const t=void 0!==e.targetRef&&e.targetRef.value||e.rootRef.value;t.focus()}else!0===e.rootRef.value.contains(document.activeElement)&&document.activeElement.blur();"file"===t.type&&(e.inputRef.value.value=null),o("update:modelValue",null),o("clear",t.modelValue),vue.nextTick(()=>{v(),!0!==r.platform.is.mobile&&(u.value=!1)})}function P(){const o=[];return void 0!==n.prepend&&o.push(vue.h("div",{class:"q-field__prepend q-field__marginal row no-wrap items-center",key:"prepend",onClick:prevent},n.prepend())),o.push(vue.h("div",{class:"q-field__control-container col relative-position row no-wrap q-anchor--skip"},M())),!0===c.value&&!1===t.noErrorIcon&&o.push(Q("error",[vue.h(QIcon,{name:r.iconSet.field.error,color:"negative"})])),!0===t.loading||!0===e.innerLoading.value?o.push(Q("inner-loading-append",void 0!==n.loading?n.loading():[vue.h(QSpinner,{color:t.color})])):!0===t.clearable&&!0===e.hasValue.value&&!0===e.editable.value&&o.push(Q("inner-clearable-append",[vue.h(QIcon,{class:"q-field__focusable-action",tag:"button",name:t.clearIcon||r.iconSet.field.clear,tabindex:0,type:"button","aria-hidden":null,role:null,onClick:T})])),void 0!==n.append&&o.push(vue.h("div",{class:"q-field__append q-field__marginal row no-wrap items-center",key:"append",onClick:prevent},n.append())),void 0!==e.getInnerAppend&&o.push(Q("inner-append",e.getInnerAppend())),void 0!==e.getControlChild&&o.push(e.getControlChild()),o}function M(){const o=[];return void 0!==t.prefix&&null!==t.prefix&&o.push(vue.h("div",{class:"q-field__prefix no-pointer-events row items-center"},t.prefix)),void 0!==e.getShadowControl&&!0===e.hasShadow.value&&o.push(e.getShadowControl()),void 0!==e.getControl?o.push(e.getControl()):void 0!==n.rawControl?o.push(n.rawControl()):void 0!==n.control&&o.push(vue.h("div",{ref:e.targetRef,class:"q-field__native row",tabindex:-1,...e.splitAttrs.attributes.value,"data-autofocus":!0===t.autofocus||void 0},n.control(S.value))),!0===b.value&&o.push(vue.h("div",{class:y.value},hSlot(n.label,t.label))),void 0!==t.suffix&&null!==t.suffix&&o.push(vue.h("div",{class:"q-field__suffix no-pointer-events row items-center"},t.suffix)),o.concat(hSlot(n.default))}function $(){let o,a;!0===c.value?null!==d.value?(o=[vue.h("div",{role:"alert"},d.value)],a=`q--slot-error-${d.value}`):(o=hSlot(n.error),a="q--slot-error"):!0===t.hideHint&&!0!==e.focused.value||(void 0!==t.hint?(o=[vue.h("div",t.hint)],a=`q--slot-hint-${t.hint}`):(o=hSlot(n.hint),a="q--slot-hint"));const l=!0===t.counter||void 0!==n.counter;if(!0===t.hideBottomSpace&&!1===l&&void 0===o)return;const r=vue.h("div",{key:a,class:"q-field__messages col"},o);return vue.h("div",{class:"q-field__bottom row items-start q-field__bottom--"+(!0!==t.hideBottomSpace?"animated":"stale"),onClick:prevent},[!0===t.hideBottomSpace?r:vue.h(vue.Transition,{name:"q-transition--field-message"},()=>r),!0===l?vue.h("div",{class:"q-field__counter"},void 0!==n.counter?n.counter():e.computedCounter.value):null])}function Q(e,t){return null===t?null:vue.h("div",{key:e,class:"q-field__append q-field__marginal row no-wrap items-center q-anchor--skip"},t)}vue.watch(()=>t.for,t=>{e.targetUid.value=getTargetUid(t,e.requiredForAttr)});let B=!1;return vue.onDeactivated(()=>{B=!0}),vue.onActivated(()=>{!0===B&&!0===t.autofocus&&l.focus()}),vue.onMounted(()=>{!0===isRuntimeSsrPreHydration.value&&!0===e.requiredForAttr&&void 0===t.for&&(e.targetUid.value=`f_${uid()}`),!0===t.autofocus&&l.focus()}),vue.onBeforeUnmount(()=>{null!==i&&clearTimeout(i)}),Object.assign(l,{focus:C,blur:k}),function(){const o=void 0===e.getControl&&void 0===n.control?{...e.splitAttrs.attributes.value,"data-autofocus":!0===t.autofocus||void 0,...x.value}:x.value;return vue.h(e.tag.value,{ref:e.rootRef,class:[h.value,a.class],style:a.style,...o},[void 0!==n.before?vue.h("div",{class:"q-field__before q-field__marginal row no-wrap items-center",onClick:prevent},n.before()):null,vue.h("div",{class:"q-field__inner relative-position col self-stretch"},[vue.h("div",{ref:e.controlRef,class:g.value,tabindex:-1,...e.controlEvents},P()),!0===m.value?$():null]),void 0!==n.after?vue.h("div",{class:"q-field__after q-field__marginal row no-wrap items-center",onClick:prevent},n.after()):null])}}var QField=createComponent({name:"QField",inheritAttrs:!1,props:{...useFieldProps,tag:{type:String,default:"label"}},emits:useFieldEmits,setup(){return useField(useFieldState({requiredForAttr:!1,tagProp:!0}))}});function filterFiles(e,t,o,n){const a=[];return e.forEach(e=>{!0===n(e)?a.push(e):t.push({failedPropValidation:o,file:e})}),a}function stopAndPreventDrag(e){e&&e.dataTransfer&&(e.dataTransfer.dropEffect="copy"),stopAndPrevent(e)}const useFileProps={multiple:Boolean,accept:String,capture:String,maxFileSize:[Number,String],maxTotalSize:[Number,String],maxFiles:[Number,String],filter:Function},useFileEmits=["rejected"];function useFile({editable:e,dnd:t,getFileInput:o,addFilesToQueue:n}){const{props:a,emit:l,proxy:r}=vue.getCurrentInstance(),i=vue.ref(null),u=vue.computed(()=>void 0!==a.accept?a.accept.split(",").map(e=>{return e=e.trim(),"*"===e?"*/":(e.endsWith("/*")&&(e=e.slice(0,e.length-1)),e.toUpperCase())}):null),s=vue.computed(()=>parseInt(a.maxFiles,10)),c=vue.computed(()=>parseInt(a.maxTotalSize,10));function d(t){if(e.value)if(t!==Object(t)&&(t={target:null}),null!==t.target&&!0===t.target.matches('input[type="file"]'))0===t.clientX&&0===t.clientY&&stop(t);else{const e=o();e&&e!==t.target&&e.click(t)}}function v(t){e.value&&t&&n(null,t)}function p(e,t,o,n){let r=Array.from(t||e.target.files);const i=[],d=()=>{0!==i.length&&l("rejected",i)};if(void 0!==a.accept&&-1===u.value.indexOf("*/")&&(r=filterFiles(r,i,"accept",e=>{return u.value.some(t=>e.type.toUpperCase().startsWith(t)||e.name.toUpperCase().endsWith(t))}),0===r.length))return d();if(void 0!==a.maxFileSize){const e=parseInt(a.maxFileSize,10);if(r=filterFiles(r,i,"max-file-size",t=>{return t.size<=e}),0===r.length)return d()}if(!0!==a.multiple&&0!==r.length&&(r=[r[0]]),r.forEach(e=>{e.__key=e.webkitRelativePath+e.lastModified+e.name+e.size}),!0===n){const e=o.map(e=>e.__key);r=filterFiles(r,i,"duplicate",t=>{return!1===e.includes(t.__key)})}if(0===r.length)return d();if(void 0!==a.maxTotalSize){let e=!0===n?o.reduce((e,t)=>e+t.size,0):0;if(r=filterFiles(r,i,"max-total-size",t=>{return e+=t.size,e<=c.value}),0===r.length)return d()}if("function"===typeof a.filter){const e=a.filter(r);r=filterFiles(r,i,"filter",t=>{return e.includes(t)})}if(void 0!==a.maxFiles){let e=!0===n?o.length:0;if(r=filterFiles(r,i,"max-files",()=>{return e++,e<=s.value}),0===r.length)return d()}return d(),0!==r.length?r:void 0}function m(e){stopAndPreventDrag(e),!0!==t.value&&(t.value=!0)}function f(e){stopAndPrevent(e);const o=null!==e.relatedTarget||!0!==client.is.safari?e.relatedTarget!==i.value:!1===document.elementsFromPoint(e.clientX,e.clientY).includes(i.value);!0===o&&(t.value=!1)}function h(e){stopAndPreventDrag(e);const o=e.dataTransfer.files;0!==o.length&&n(null,o),t.value=!1}function g(e){if(!0===t.value)return vue.h("div",{ref:i,class:`q-${e}__dnd absolute-full`,onDragenter:stopAndPreventDrag,onDragover:stopAndPreventDrag,onDragleave:f,onDrop:h})}return Object.assign(r,{pickFiles:d,addFiles:v}),{pickFiles:d,addFiles:v,onDragover:m,onDragleave:f,processFiles:p,getDndNode:g,maxFilesNumber:s,maxTotalSizeNumber:c}}function useFileFormDomProps(e,t){function o(){const t=e.modelValue;try{const e="DataTransfer"in window?new DataTransfer:"ClipboardEvent"in window?new ClipboardEvent("").clipboardData:void 0;return Object(t)===t&&("length"in t?Array.from(t):[t]).forEach(t=>{e.items.add(t)}),{files:e.files}}catch(e){return{files:void 0}}}return!0===t?vue.computed(()=>{if("file"===e.type)return o()}):vue.computed(o)}var QFile=createComponent({name:"QFile",inheritAttrs:!1,props:{...useFieldProps,...useFormProps,...useFileProps,modelValue:{},append:Boolean,useChips:Boolean,displayValue:[String,Number],tabindex:{type:[String,Number],default:0},counterLabel:Function,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},emits:[...useFieldEmits,...useFileEmits],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a}=vue.getCurrentInstance(),l=useFieldState(),r=vue.ref(null),i=vue.ref(!1),u=useFormInputNameAttr(e),{pickFiles:s,onDragover:c,onDragleave:d,processFiles:v,getDndNode:p}=useFile({editable:l.editable,dnd:i,getFileInput:P,addFilesToQueue:M}),m=useFileFormDomProps(e),f=vue.computed(()=>Object(e.modelValue)===e.modelValue?"length"in e.modelValue?Array.from(e.modelValue):[e.modelValue]:[]),h=vue.computed(()=>fieldValueIsFilled(f.value)),g=vue.computed(()=>f.value.map(e=>e.name).join(", ")),b=vue.computed(()=>humanStorageSize(f.value.reduce((e,t)=>e+t.size,0))),y=vue.computed(()=>({totalSize:b.value,filesNumber:f.value.length,maxFiles:e.maxFiles})),S=vue.computed(()=>({tabindex:-1,type:"file",title:"",accept:e.accept,capture:e.capture,name:u.value,...n,id:l.targetUid.value,disabled:!0!==l.editable.value})),x=vue.computed(()=>"q-file q-field--auto-height"+(!0===i.value?" q-file--dnd":"")),w=vue.computed(()=>!0===e.multiple&&!0===e.append);function C(e){const t=f.value.slice();t.splice(e,1),_(t)}function k(e){const t=f.value.indexOf(e);t>-1&&C(t)}function _(t){o("update:modelValue",!0===e.multiple?t:t[0])}function q(e){13===e.keyCode&&prevent(e)}function T(e){13!==e.keyCode&&32!==e.keyCode||s(e)}function P(){return r.value}function M(t,o){const n=v(t,o,f.value,w.value),a=P();void 0!==a&&null!==a&&(a.value=""),void 0!==n&&((!0===e.multiple?e.modelValue&&n.every(e=>f.value.includes(e)):e.modelValue===n[0])||_(!0===w.value?f.value.concat(n):n))}function $(){return[vue.h("input",{class:[e.inputClass,"q-file__filler"],style:e.inputStyle})]}function Q(){if(void 0!==t.file)return 0===f.value.length?$():f.value.map((e,o)=>t.file({index:o,file:e,ref:this}));if(void 0!==t.selected)return 0===f.value.length?$():t.selected({files:f.value,ref:this});if(!0===e.useChips)return 0===f.value.length?$():f.value.map((t,o)=>vue.h(QChip,{key:"file-"+o,removable:l.editable.value,dense:!0,textColor:e.color,tabindex:e.tabindex,onRemove:()=>{C(o)}},()=>vue.h("span",{class:"ellipsis",textContent:t.name})));const o=void 0!==e.displayValue?e.displayValue:g.value;return 0!==o.length?[vue.h("div",{class:e.inputClass,style:e.inputStyle,textContent:o})]:$()}function B(){const t={ref:r,...S.value,...m.value,class:"q-field__input fit absolute-full cursor-pointer",onChange:M};return!0===e.multiple&&(t.multiple=!0),vue.h("input",t)}return Object.assign(l,{fieldClass:x,emitValue:_,hasValue:h,inputRef:r,innerValue:f,floatingLabel:vue.computed(()=>!0===h.value||fieldValueIsFilled(e.displayValue)),computedCounter:vue.computed(()=>{if(void 0!==e.counterLabel)return e.counterLabel(y.value);const t=e.maxFiles;return`${f.value.length}${void 0!==t?" / "+t:""} (${b.value})`}),getControlChild:()=>p("file"),getControl:()=>{const t={ref:l.targetRef,class:"q-field__native row items-center cursor-pointer",tabindex:e.tabindex};return!0===l.editable.value&&Object.assign(t,{onDragover:c,onDragleave:d,onKeydown:q,onKeyup:T}),vue.h("div",t,[B()].concat(Q()))}}),Object.assign(a,{removeAtIndex:C,removeFile:k,getNativeElement:()=>r.value}),injectProp(a,"nativeEl",()=>r.value),useField(l)}}),QFooter=createComponent({name:"QFooter",props:{modelValue:{type:Boolean,default:!0},reveal:Boolean,bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},emits:["reveal","focusin"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=vue.inject(layoutKey,emptyRenderFn);if(a===emptyRenderFn)return console.error("QFooter needs to be child of QLayout"),emptyRenderFn;const l=vue.ref(parseInt(e.heightHint,10)),r=vue.ref(!0),i=vue.ref(!0===isRuntimeSsrPreHydration.value||!0===a.isContainer.value?0:window.innerHeight),u=vue.computed(()=>!0===e.reveal||a.view.value.indexOf("F")>-1||n.platform.is.ios&&!0===a.isContainer.value),s=vue.computed(()=>!0===a.isContainer.value?a.containerHeight.value:i.value),c=vue.computed(()=>{if(!0!==e.modelValue)return 0;if(!0===u.value)return!0===r.value?l.value:0;const t=a.scroll.value.position+s.value+l.value-a.height.value;return t>0?t:0}),d=vue.computed(()=>!0!==e.modelValue||!0===u.value&&!0!==r.value),v=vue.computed(()=>!0===e.modelValue&&!0===d.value&&!0===e.reveal),p=vue.computed(()=>"q-footer q-layout__section--marginal "+(!0===u.value?"fixed":"absolute")+"-bottom"+(!0===e.bordered?" q-footer--bordered":"")+(!0===d.value?" q-footer--hidden":"")+(!0!==e.modelValue?" q-layout--prevent-focus"+(!0!==u.value?" hidden":""):"")),m=vue.computed(()=>{const e=a.rows.value.bottom,t={};return"l"===e[0]&&!0===a.left.space&&(t[!0===n.lang.rtl?"right":"left"]=`${a.left.size}px`),"r"===e[2]&&!0===a.right.space&&(t[!0===n.lang.rtl?"left":"right"]=`${a.right.size}px`),t});function f(e,t){a.update("footer",e,t)}function h(e,t){e.value!==t&&(e.value=t)}function g({height:e}){h(l,e),f("size",e)}function b(){if(!0!==e.reveal)return;const{direction:t,position:o,inflectionPoint:n}=a.scroll.value;h(r,"up"===t||o-n<100||a.height.value-s.value-o-l.value<300)}function y(e){!0===v.value&&h(r,!0),o("focusin",e)}vue.watch(()=>e.modelValue,e=>{f("space",e),h(r,!0),a.animate()}),vue.watch(c,e=>{f("offset",e)}),vue.watch(()=>e.reveal,t=>{!1===t&&h(r,e.modelValue)}),vue.watch(r,e=>{a.animate(),o("reveal",e)}),vue.watch([l,a.scroll,a.height],b),vue.watch(()=>n.screen.height,e=>{!0!==a.isContainer.value&&h(i,e)});const S={};return a.instances.footer=S,!0===e.modelValue&&f("size",l.value),f("space",e.modelValue),f("offset",c.value),vue.onBeforeUnmount(()=>{a.instances.footer===S&&(a.instances.footer=void 0,f("size",0),f("offset",0),f("space",!1))}),()=>{const o=hMergeSlot(t.default,[vue.h(QResizeObserver,{debounce:0,onResize:g})]);return!0===e.elevated&&o.push(vue.h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),vue.h("footer",{class:p.value,style:m.value,onFocusin:y},o)}}}),QForm=createComponent({name:"QForm",props:{autofocus:Boolean,noErrorFocus:Boolean,noResetFocus:Boolean,greedy:Boolean,onSubmit:Function},emits:["reset","validationSuccess","validationError"],setup(e,{slots:t,emit:o}){const n=vue.getCurrentInstance(),a=vue.ref(null);let l=0;const r=[];function i(t){const n="boolean"===typeof t?t:!0!==e.noErrorFocus,a=++l,i=(e,t)=>{o("validation"+(!0===e?"Success":"Error"),t)},u=e=>{const t=e.validate();return"function"===typeof t.then?t.then(t=>({valid:t,comp:e}),t=>({valid:!1,comp:e,err:t})):Promise.resolve({valid:t,comp:e})},s=!0===e.greedy?Promise.all(r.map(u)).then(e=>e.filter(e=>!0!==e.valid)):r.reduce((e,t)=>e.then(()=>{return u(t).then(e=>{if(!1===e.valid)return Promise.reject(e)})}),Promise.resolve()).catch(e=>[e]);return s.then(e=>{if(void 0===e||0===e.length)return a===l&&i(!0),!0;if(a===l){const{comp:t,err:o}=e[0];if(void 0!==o&&console.error(o),i(!1,t),!0===n){const t=e.find(({comp:e})=>"function"===typeof e.focus&&!1===vmIsDestroyed(e.$));void 0!==t&&t.comp.focus()}}return!1})}function u(){l++,r.forEach(e=>{"function"===typeof e.resetValidation&&e.resetValidation()})}function s(t){void 0!==t&&stopAndPrevent(t);const n=l+1;i().then(a=>{n===l&&!0===a&&(void 0!==e.onSubmit?o("submit",t):void 0!==t&&void 0!==t.target&&"function"===typeof t.target.submit&&t.target.submit())})}function c(t){void 0!==t&&stopAndPrevent(t),o("reset"),vue.nextTick(()=>{u(),!0===e.autofocus&&!0!==e.noResetFocus&&d()})}function d(){addFocusFn(()=>{if(null===a.value)return;const e=a.value.querySelector("[autofocus][tabindex], [data-autofocus][tabindex]")||a.value.querySelector("[autofocus] [tabindex], [data-autofocus] [tabindex]")||a.value.querySelector("[autofocus], [data-autofocus]")||Array.prototype.find.call(a.value.querySelectorAll("[tabindex]"),e=>e.tabIndex>-1);null!==e&&void 0!==e&&e.focus({preventScroll:!0})})}vue.provide(formKey,{bindComponent(e){r.push(e)},unbindComponent(e){const t=r.indexOf(e);t>-1&&r.splice(t,1)}});let v=!1;return vue.onDeactivated(()=>{v=!0}),vue.onActivated(()=>{!0===v&&!0===e.autofocus&&d()}),vue.onMounted(()=>{!0===e.autofocus&&d()}),Object.assign(n.proxy,{validate:i,resetValidation:u,submit:s,reset:c,focus:d,getValidationComponents:()=>r}),()=>vue.h("form",{class:"q-form",ref:a,onSubmit:s,onReset:c},hSlot(t.default))}}),QFormChildMixin={inject:{[formKey]:{default:noop}},watch:{disable(e){const t=this.$.provides[formKey];void 0!==t&&(!0===e?(this.resetValidation(),t.unbindComponent(this)):t.bindComponent(this))}},methods:{validate(){},resetValidation(){}},mounted(){const e=this.$.provides[formKey];void 0!==e&&!0!==this.disable&&e.bindComponent(this)},beforeUnmount(){const e=this.$.provides[formKey];void 0!==e&&!0!==this.disable&&e.unbindComponent(this)}},QHeader=createComponent({name:"QHeader",props:{modelValue:{type:Boolean,default:!0},reveal:Boolean,revealOffset:{type:Number,default:250},bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},emits:["reveal","focusin"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=vue.inject(layoutKey,emptyRenderFn);if(a===emptyRenderFn)return console.error("QHeader needs to be child of QLayout"),emptyRenderFn;const l=vue.ref(parseInt(e.heightHint,10)),r=vue.ref(!0),i=vue.computed(()=>!0===e.reveal||a.view.value.indexOf("H")>-1||n.platform.is.ios&&!0===a.isContainer.value),u=vue.computed(()=>{if(!0!==e.modelValue)return 0;if(!0===i.value)return!0===r.value?l.value:0;const t=l.value-a.scroll.value.position;return t>0?t:0}),s=vue.computed(()=>!0!==e.modelValue||!0===i.value&&!0!==r.value),c=vue.computed(()=>!0===e.modelValue&&!0===s.value&&!0===e.reveal),d=vue.computed(()=>"q-header q-layout__section--marginal "+(!0===i.value?"fixed":"absolute")+"-top"+(!0===e.bordered?" q-header--bordered":"")+(!0===s.value?" q-header--hidden":"")+(!0!==e.modelValue?" q-layout--prevent-focus":"")),v=vue.computed(()=>{const e=a.rows.value.top,t={};return"l"===e[0]&&!0===a.left.space&&(t[!0===n.lang.rtl?"right":"left"]=`${a.left.size}px`),"r"===e[2]&&!0===a.right.space&&(t[!0===n.lang.rtl?"left":"right"]=`${a.right.size}px`),t});function p(e,t){a.update("header",e,t)}function m(e,t){e.value!==t&&(e.value=t)}function f({height:e}){m(l,e),p("size",e)}function h(e){!0===c.value&&m(r,!0),o("focusin",e)}vue.watch(()=>e.modelValue,e=>{p("space",e),m(r,!0),a.animate()}),vue.watch(u,e=>{p("offset",e)}),vue.watch(()=>e.reveal,t=>{!1===t&&m(r,e.modelValue)}),vue.watch(r,e=>{a.animate(),o("reveal",e)}),vue.watch(a.scroll,t=>{!0===e.reveal&&m(r,"up"===t.direction||t.position<=e.revealOffset||t.position-t.inflectionPoint<100)});const g={};return a.instances.header=g,!0===e.modelValue&&p("size",l.value),p("space",e.modelValue),p("offset",u.value),vue.onBeforeUnmount(()=>{a.instances.header===g&&(a.instances.header=void 0,p("size",0),p("offset",0),p("space",!1))}),()=>{const o=hUniqueSlot(t.default,[]);return!0===e.elevated&&o.push(vue.h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),o.push(vue.h(QResizeObserver,{debounce:0,onResize:f})),vue.h("header",{class:d.value,style:v.value,onFocusin:h},o)}}});const useRatioProps={ratio:[String,Number]};function useRatio(e,t){return vue.computed(()=>{const o=Number(e.ratio||(void 0!==t?t.value:void 0));return!0!==isNaN(o)&&o>0?{paddingBottom:`${100/o}%`}:null})}const defaultRatio=16/9;var QImg=createComponent({name:"QImg",props:{...useRatioProps,src:String,srcset:String,sizes:String,alt:String,crossorigin:String,decoding:String,referrerpolicy:String,draggable:Boolean,loading:{type:String,default:"lazy"},fetchpriority:{type:String,default:"auto"},width:String,height:String,initialRatio:{type:[Number,String],default:defaultRatio},placeholderSrc:String,fit:{type:String,default:"cover"},position:{type:String,default:"50% 50%"},imgClass:String,imgStyle:Object,noSpinner:Boolean,noNativeMenu:Boolean,noTransition:Boolean,spinnerColor:String,spinnerSize:String},emits:["load","error"],setup(e,{slots:t,emit:o}){const n=vue.ref(e.initialRatio),a=useRatio(e,n);let l=null;const r=[vue.ref(null),vue.ref(f())],i=vue.ref(0),u=vue.ref(!1),s=vue.ref(!1),c=vue.computed(()=>`q-img q-img--${!0===e.noNativeMenu?"no-":""}menu`),d=vue.computed(()=>({width:e.width,height:e.height})),v=vue.computed(()=>`q-img__image ${void 0!==e.imgClass?e.imgClass+" ":""}`+`q-img__image--with${!0===e.noTransition?"out":""}-transition`),p=vue.computed(()=>({...e.imgStyle,objectFit:e.fit,objectPosition:e.position}));function m(){return e.src||e.srcset||e.sizes?{src:e.src,srcset:e.srcset,sizes:e.sizes}:null}function f(){return void 0!==e.placeholderSrc?{src:e.placeholderSrc}:null}function h(e){null!==l&&(clearTimeout(l),l=null),s.value=!1,null===e?(u.value=!1,r[1^i.value].value=f()):u.value=!0,r[i.value].value=e}function g({target:e}){null!==l&&(clearTimeout(l),l=null),n.value=0===e.naturalHeight?.5:e.naturalWidth/e.naturalHeight,b(e,1)}function b(e,t){1e3!==t&&(!0===e.complete?y(e):l=setTimeout(()=>{l=null,b(e,t+1)},50))}function y(e){i.value=1^i.value,r[i.value].value=null,u.value=!1,s.value=!1,o("load",e.currentSrc||e.src)}function S(e){null!==l&&(clearTimeout(l),l=null),u.value=!1,s.value=!0,r[i.value].value=null,r[1^i.value].value=f(),o("error",e)}function x(t){const o=r[t].value,n={key:"img_"+t,class:v.value,style:p.value,crossorigin:e.crossorigin,decoding:e.decoding,referrerpolicy:e.referrerpolicy,height:e.height,width:e.width,loading:e.loading,fetchpriority:e.fetchpriority,"aria-hidden":"true",draggable:e.draggable,...o};return i.value===t?(n.class+=" q-img__image--waiting",Object.assign(n,{onLoad:g,onError:S})):n.class+=" q-img__image--loaded",vue.h("div",{class:"q-img__container absolute-full",key:"img"+t},vue.h("img",n))}function w(){return!0!==u.value?vue.h("div",{key:"content",class:"q-img__content absolute-full q-anchor--skip"},hSlot(t[!0===s.value?"error":"default"])):vue.h("div",{key:"loading",class:"q-img__loading absolute-full flex flex-center"},void 0!==t.loading?t.loading():!0===e.noSpinner?void 0:[vue.h(QSpinner,{color:e.spinnerColor,size:e.spinnerSize})])}return vue.watch(()=>m(),h),()=>{const t=[];return null!==a.value&&t.push(vue.h("div",{key:"filler",style:a.value})),!0!==s.value&&(null!==r[0].value&&t.push(x(0)),null!==r[1].value&&t.push(x(1))),t.push(vue.h(vue.Transition,{name:"q-transition--fade"},w)),vue.h("div",{class:c.value,style:d.value,role:"img","aria-label":e.alt},t)}}});const{passive:passive$2}=listenOpts;var QInfiniteScroll=createComponent({name:"QInfiniteScroll",props:{offset:{type:Number,default:500},debounce:{type:[String,Number],default:100},scrollTarget:{default:void 0},initialIndex:Number,disable:Boolean,reverse:Boolean},emits:["load"],setup(e,{slots:t,emit:o}){const n=vue.ref(!1),a=vue.ref(!0),l=vue.ref(null),r=vue.ref(null);let i,u,s=e.initialIndex||0;const c=vue.computed(()=>"q-infinite-scroll__loading"+(!0===n.value?"":" invisible"));function d(){if(!0===e.disable||!0===n.value||!1===a.value)return;const t=getScrollHeight(i),o=getVerticalScrollPosition(i),l=height(i);!1===e.reverse?Math.round(o+l+e.offset)>=Math.round(t)&&v():Math.round(o)<=e.offset&&v()}function v(){if(!0===e.disable||!0===n.value||!1===a.value)return;s++,n.value=!0;const t=getScrollHeight(i);o("load",s,o=>{!0===a.value&&(n.value=!1,vue.nextTick(()=>{if(!0===e.reverse){const e=getScrollHeight(i),o=getVerticalScrollPosition(i),n=e-t;setVerticalScrollPosition(i,o+n)}!0===o?f():l.value&&l.value.closest("body")&&u()}))})}function p(){s=0}function m(){!1===a.value&&(a.value=!0,i.addEventListener("scroll",u,passive$2)),d()}function f(){!0===a.value&&(a.value=!1,n.value=!1,i.removeEventListener("scroll",u,passive$2),void 0!==u&&void 0!==u.cancel&&u.cancel())}function h(){if(i&&!0===a.value&&i.removeEventListener("scroll",u,passive$2),i=getScrollTarget(l.value,e.scrollTarget),!0===a.value){if(i.addEventListener("scroll",u,passive$2),!0===e.reverse){const e=getScrollHeight(i),t=height(i);setVerticalScrollPosition(i,e-t)}d()}}function g(e){s=e}function b(e){e=parseInt(e,10);const t=u;u=e<=0?d:debounce(d,!0===isNaN(e)?100:e),i&&!0===a.value&&(void 0!==t&&i.removeEventListener("scroll",t,passive$2),i.addEventListener("scroll",u,passive$2))}function y(e){if(!0===S.value){if(null===r.value)return void(!0!==e&&vue.nextTick(()=>{y(!0)}));const t=`${!0===n.value?"un":""}pauseAnimations`;Array.from(r.value.getElementsByTagName("svg")).forEach(e=>{e[t]()})}}const S=vue.computed(()=>!0!==e.disable&&!0===a.value);vue.watch([n,S],()=>{y()}),vue.watch(()=>e.disable,e=>{!0===e?f():m()}),vue.watch(()=>e.reverse,()=>{!1===n.value&&!0===a.value&&d()}),vue.watch(()=>e.scrollTarget,h),vue.watch(()=>e.debounce,b);let x=!1;vue.onActivated(()=>{!1!==x&&i&&setVerticalScrollPosition(i,x)}),vue.onDeactivated(()=>{x=!!i&&getVerticalScrollPosition(i)}),vue.onBeforeUnmount(()=>{!0===a.value&&i.removeEventListener("scroll",u,passive$2)}),vue.onMounted(()=>{b(e.debounce),h(),!1===n.value&&y()});const w=vue.getCurrentInstance();return Object.assign(w.proxy,{poll:()=>{void 0!==u&&u()},trigger:v,stop:f,reset:p,resume:m,setIndex:g}),()=>{const o=hUniqueSlot(t.default,[]);return!0===S.value&&o[!1===e.reverse?"push":"unshift"](vue.h("div",{ref:r,class:c.value},hSlot(t.loading))),vue.h("div",{class:"q-infinite-scroll",ref:l},o)}}}),QInnerLoading=createComponent({name:"QInnerLoading",props:{...useDarkProps,...useTransitionProps,showing:Boolean,color:String,size:{type:[String,Number],default:42},label:String,labelClass:String,labelStyle:[String,Array,Object]},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),{transitionProps:a,transitionStyle:l}=useTransition(e),r=vue.computed(()=>"q-inner-loading absolute-full column flex-center"+(!0===n.value?" q-inner-loading--dark":"")),i=vue.computed(()=>"q-inner-loading__label"+(void 0!==e.labelClass?` ${e.labelClass}`:""));function u(){const t=[vue.h(QSpinner,{size:e.size,color:e.color})];return void 0!==e.label&&t.push(vue.h("div",{class:i.value,style:e.labelStyle},[e.label])),t}function s(){return!0===e.showing?vue.h("div",{class:r.value,style:l.value},void 0!==t.default?t.default():u()):null}return()=>vue.h(vue.Transition,a.value,s)}});const NAMED_MASKS={date:"####/##/##",datetime:"####/##/## ##:##",time:"##:##",fulltime:"##:##:##",phone:"(###) ### - ####",card:"#### #### #### ####"},TOKENS={"#":{pattern:"[\\d]",negate:"[^\\d]"},S:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]"},N:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]"},A:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:e=>e.toLocaleUpperCase()},a:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:e=>e.toLocaleLowerCase()},X:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:e=>e.toLocaleUpperCase()},x:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:e=>e.toLocaleLowerCase()}},KEYS=Object.keys(TOKENS);KEYS.forEach(e=>{TOKENS[e].regex=new RegExp(TOKENS[e].pattern)});const tokenRegexMask=new RegExp("\\\\([^.*+?^${}()|([\\]])|([.*+?^${}()|[\\]])|(["+KEYS.join("")+"])|(.)","g"),escRegex=/[.*+?^${}()|[\]\\]/g,MARKER=String.fromCharCode(1),useMaskProps={mask:String,reverseFillMask:Boolean,fillMask:[Boolean,String],unmaskedValue:Boolean};function useMask(e,t,o,n){let a,l,r,i,u,s;const c=vue.ref(null),d=vue.ref(p());function v(){return!0===e.autogrow||["textarea","text","search","url","tel","password"].includes(e.type)}function p(){if(f(),!0===c.value){const t=x(C(e.modelValue));return!1!==e.fillMask?k(t):t}return e.modelValue}function m(e){if(e<a.length)return a.slice(-e);let t="",o=a;const n=o.indexOf(MARKER);if(n>-1){for(let n=e-o.length;n>0;n--)t+=MARKER;o=o.slice(0,n)+t+o.slice(n)}return o}function f(){if(c.value=void 0!==e.mask&&0!==e.mask.length&&v(),!1===c.value)return i=void 0,a="",void(l="");const t=void 0===NAMED_MASKS[e.mask]?e.mask:NAMED_MASKS[e.mask],o="string"===typeof e.fillMask&&0!==e.fillMask.length?e.fillMask.slice(0,1):"_",n=o.replace(escRegex,"\\$&"),u=[],s=[],d=[];let p=!0===e.reverseFillMask,m="",f="";t.replace(tokenRegexMask,(e,t,o,n,a)=>{if(void 0!==n){const e=TOKENS[n];d.push(e),f=e.negate,!0===p&&(s.push("(?:"+f+"+)?("+e.pattern+"+)?(?:"+f+"+)?("+e.pattern+"+)?"),p=!1),s.push("(?:"+f+"+)?("+e.pattern+")?")}else if(void 0!==o)m="\\"+("\\"===o?"":o),d.push(o),u.push("([^"+m+"]+)?"+m+"?");else{const e=void 0!==t?t:a;m="\\"===e?"\\\\\\\\":e.replace(escRegex,"\\\\$&"),d.push(e),u.push("([^"+m+"]+)?"+m+"?")}});const h=new RegExp("^"+u.join("")+"("+(""===m?".":"[^"+m+"]")+"+)?"+(""===m?"":"["+m+"]*")+"$"),g=s.length-1,b=s.map((t,o)=>{return 0===o&&!0===e.reverseFillMask?new RegExp("^"+n+"*"+t):o===g?new RegExp("^"+t+"("+(""===f?".":f)+"+)?"+(!0===e.reverseFillMask?"$":n+"*")):new RegExp("^"+t)});r=d,i=(t=>{const o=h.exec(!0===e.reverseFillMask?t:t.slice(0,d.length+1));null!==o&&(t=o.slice(1).join(""));const n=[],a=b.length;for(let e=0,l=t;e<a;e++){const t=b[e].exec(l);if(null===t)break;l=l.slice(t.shift().length),n.push(...t)}return 0!==n.length?n.join(""):t}),a=d.map(e=>"string"===typeof e?e:MARKER).join(""),l=a.split(MARKER).join(o)}function h(t,r,i){const s=n.value,c=s.selectionEnd,v=s.value.length-c,p=C(t);!0===r&&f();const m=x(p),h=!1!==e.fillMask?k(m):m,g=d.value!==h;s.value!==h&&(s.value=h),!0===g&&(d.value=h),document.activeElement===s&&vue.nextTick(()=>{if(h!==l)if("insertFromPaste"!==i||!0===e.reverseFillMask)if(["deleteContentBackward","deleteContentForward"].indexOf(i)>-1){const t=!0===e.reverseFillMask?0===c?h.length>m.length?1:0:Math.max(0,h.length-(h===l?0:Math.min(m.length,v)+1))+1:c;s.setSelectionRange(t,t,"forward")}else if(!0===e.reverseFillMask)if(!0===g){const e=Math.max(0,h.length-(h===l?0:Math.min(m.length,v+1)));1===e&&1===c?s.setSelectionRange(e,e,"forward"):b.rightReverse(s,e)}else{const e=h.length-v;s.setSelectionRange(e,e,"backward")}else if(!0===g){const e=Math.max(0,a.indexOf(MARKER),Math.min(m.length,c)-1);b.right(s,e)}else{const e=c-1;b.right(s,e)}else{const e=s.selectionEnd;let t=c-1;for(let o=u;o<=t&&o<e;o++)a[o]!==MARKER&&t++;b.right(s,t)}else{const t=!0===e.reverseFillMask?l.length:0;s.setSelectionRange(t,t,"forward")}});const y=!0===e.unmaskedValue?C(h):h;String(e.modelValue)===y||null===e.modelValue&&""===y||o(y,!0)}function g(e,t,o){const n=x(C(e.value));t=Math.max(0,a.indexOf(MARKER),Math.min(n.length,t)),u=t,e.setSelectionRange(t,o,"forward")}vue.watch(()=>e.type+e.autogrow,f),vue.watch(()=>e.mask,o=>{if(void 0!==o)h(d.value,!0);else{const o=C(d.value);f(),e.modelValue!==o&&t("update:modelValue",o)}}),vue.watch(()=>e.fillMask+e.reverseFillMask,()=>{!0===c.value&&h(d.value,!0)}),vue.watch(()=>e.unmaskedValue,()=>{!0===c.value&&h(d.value)});const b={left(e,t){const o=-1===a.slice(t-1).indexOf(MARKER);let n=Math.max(0,t-1);for(;n>=0;n--)if(a[n]===MARKER){t=n,!0===o&&t++;break}if(n<0&&void 0!==a[t]&&a[t]!==MARKER)return b.right(e,0);t>=0&&e.setSelectionRange(t,t,"backward")},right(e,t){const o=e.value.length;let n=Math.min(o,t+1);for(;n<=o;n++){if(a[n]===MARKER){t=n;break}a[n-1]===MARKER&&(t=n)}if(n>o&&void 0!==a[t-1]&&a[t-1]!==MARKER)return b.left(e,o);e.setSelectionRange(t,t,"forward")},leftReverse(e,t){const o=m(e.value.length);let n=Math.max(0,t-1);for(;n>=0;n--){if(o[n-1]===MARKER){t=n;break}if(o[n]===MARKER&&(t=n,0===n))break}if(n<0&&void 0!==o[t]&&o[t]!==MARKER)return b.rightReverse(e,0);t>=0&&e.setSelectionRange(t,t,"backward")},rightReverse(e,t){const o=e.value.length,n=m(o),a=-1===n.slice(0,t+1).indexOf(MARKER);let l=Math.min(o,t+1);for(;l<=o;l++)if(n[l-1]===MARKER){t=l,t>0&&!0===a&&t--;break}if(l>o&&void 0!==n[t-1]&&n[t-1]!==MARKER)return b.leftReverse(e,o);e.setSelectionRange(t,t,"forward")}};function y(e){t("click",e),s=void 0}function S(o){if(t("keydown",o),!0===shouldIgnoreKey(o)||!0===o.altKey)return;const a=n.value,l=a.selectionStart,r=a.selectionEnd;if(o.shiftKey||(s=void 0),37===o.keyCode||39===o.keyCode){o.shiftKey&&void 0===s&&(s="forward"===a.selectionDirection?l:r);const t=b[(39===o.keyCode?"right":"left")+(!0===e.reverseFillMask?"Reverse":"")];if(o.preventDefault(),t(a,s===l?r:l),o.shiftKey){const e=a.selectionStart;a.setSelectionRange(Math.min(s,e),Math.max(s,e),"forward")}}else 8===o.keyCode&&!0!==e.reverseFillMask&&l===r?(b.left(a,l),a.setSelectionRange(a.selectionStart,r,"backward")):46===o.keyCode&&!0===e.reverseFillMask&&l===r&&(b.rightReverse(a,r),a.setSelectionRange(l,a.selectionEnd,"forward"))}function x(t){if(void 0===t||null===t||""===t)return"";if(!0===e.reverseFillMask)return w(t);const o=r;let n=0,a="";for(let e=0;e<o.length;e++){const l=t[n],r=o[e];if("string"===typeof r)a+=r,l===r&&n++;else{if(void 0===l||!r.regex.test(l))return a;a+=void 0!==r.transform?r.transform(l):l,n++}}return a}function w(e){const t=r,o=a.indexOf(MARKER);let n=e.length-1,l="";for(let a=t.length-1;a>=0&&n>-1;a--){const r=t[a];let i=e[n];if("string"===typeof r)l=r+l,i===r&&n--;else{if(void 0===i||!r.regex.test(i))return l;do{l=(void 0!==r.transform?r.transform(i):i)+l,n--,i=e[n]}while(o===a&&void 0!==i&&r.regex.test(i))}}return l}function C(e){return"string"!==typeof e||void 0===i?"number"===typeof e?i(""+e):e:i(e)}function k(t){return l.length-t.length<=0?t:!0===e.reverseFillMask&&0!==t.length?l.slice(0,-t.length)+t:t+l.slice(t.length)}return{innerValue:d,hasMask:c,moveCursorForPaste:g,updateMaskValue:h,onMaskedKeydown:S,onMaskedClick:y}}const isJapanese=/[\u3000-\u303f\u3040-\u309f\u30a0-\u30ff\uff00-\uff9f\u4e00-\u9faf\u3400-\u4dbf]/,isChinese=/[\u4e00-\u9fff\u3400-\u4dbf\u{20000}-\u{2a6df}\u{2a700}-\u{2b73f}\u{2b740}-\u{2b81f}\u{2b820}-\u{2ceaf}\uf900-\ufaff\u3300-\u33ff\ufe30-\ufe4f\uf900-\ufaff\u{2f800}-\u{2fa1f}]/u,isKorean=/[\u3131-\u314e\u314f-\u3163\uac00-\ud7a3]/,isPlainText=/[a-z0-9_ -]$/i;function useKeyComposition(e){return function(t){if("compositionend"===t.type||"change"===t.type){if(!0!==t.target.qComposing)return;t.target.qComposing=!1,e(t)}else if("compositionupdate"===t.type&&!0!==t.target.qComposing&&"string"===typeof t.data){const e=!0===client.is.firefox?!1===isPlainText.test(t.data):!0===isJapanese.test(t.data)||!0===isChinese.test(t.data)||!0===isKorean.test(t.data);!0===e&&(t.target.qComposing=!0)}}}var QInput=createComponent({name:"QInput",inheritAttrs:!1,props:{...useFieldProps,...useMaskProps,...useFormProps,modelValue:{required:!1},shadowText:String,type:{type:String,default:"text"},debounce:[String,Number],autogrow:Boolean,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},emits:[...useFieldEmits,"paste","change","keydown","click","animationend"],setup(e,{emit:t,attrs:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l={};let r,i,u,s=NaN,c=null;const d=vue.ref(null),v=useFormInputNameAttr(e),{innerValue:p,hasMask:m,moveCursorForPaste:f,updateMaskValue:h,onMaskedKeydown:g,onMaskedClick:b}=useMask(e,t,B,d),y=useFileFormDomProps(e,!0),S=vue.computed(()=>fieldValueIsFilled(p.value)),x=useKeyComposition($),w=useFieldState(),C=vue.computed(()=>"textarea"===e.type||!0===e.autogrow),k=vue.computed(()=>!0===C.value||["text","search","url","tel","password"].includes(e.type)),_=vue.computed(()=>{const t={...w.splitAttrs.listeners.value,onInput:$,onPaste:M,onChange:A,onBlur:F,onFocus:stop};return t.onCompositionstart=t.onCompositionupdate=t.onCompositionend=x,!0===m.value&&(t.onKeydown=g,t.onClick=b),!0===e.autogrow&&(t.onAnimationend=Q),t}),q=vue.computed(()=>{const t={tabindex:0,"data-autofocus":!0===e.autofocus||void 0,rows:"textarea"===e.type?6:void 0,"aria-label":e.label,name:v.value,...w.splitAttrs.attributes.value,id:w.targetUid.value,maxlength:e.maxlength,disabled:!0===e.disable,readonly:!0===e.readonly};return!1===C.value&&(t.type=e.type),!0===e.autogrow&&(t.rows=1),t});function T(){addFocusFn(()=>{const e=document.activeElement;null===d.value||d.value===e||null!==e&&e.id===w.targetUid.value||d.value.focus({preventScroll:!0})})}function P(){null!==d.value&&d.value.select()}function M(o){if(!0===m.value&&!0!==e.reverseFillMask){const e=o.target;f(e,e.selectionStart,e.selectionEnd)}t("paste",o)}function $(o){if(!o||!o.target)return;if("file"===e.type)return void t("update:modelValue",o.target.files);const n=o.target.value;if(!0!==o.target.qComposing){if(!0===m.value)h(n,!1,o.inputType);else if(B(n),!0===k.value&&o.target===document.activeElement){const{selectionStart:e,selectionEnd:t}=o.target;void 0!==e&&void 0!==t&&vue.nextTick(()=>{o.target===document.activeElement&&0===n.indexOf(o.target.value)&&o.target.setSelectionRange(e,t)})}!0===e.autogrow&&R()}else l.value=n}function Q(e){t("animationend",e),R()}function B(o,n){u=(()=>{c=null,"number"!==e.type&&!0===l.hasOwnProperty("value")&&delete l.value,e.modelValue!==o&&s!==o&&(s=o,!0===n&&(i=!0),t("update:modelValue",o),vue.nextTick(()=>{s===o&&(s=NaN)})),u=void 0}),"number"===e.type&&(r=!0,l.value=o),void 0!==e.debounce?(null!==c&&clearTimeout(c),l.value=o,c=setTimeout(u,e.debounce)):u()}function R(){requestAnimationFrame(()=>{const e=d.value;if(null!==e){const t=e.parentNode.style,{scrollTop:o}=e,{overflowY:n,maxHeight:l}=!0===a.platform.is.firefox?{}:window.getComputedStyle(e),r=void 0!==n&&"scroll"!==n;!0===r&&(e.style.overflowY="hidden"),t.marginBottom=e.scrollHeight-1+"px",e.style.height="1px",e.style.height=e.scrollHeight+"px",!0===r&&(e.style.overflowY=parseInt(l,10)<e.scrollHeight?"auto":"hidden"),t.marginBottom="",e.scrollTop=o}})}function A(e){x(e),null!==c&&(clearTimeout(c),c=null),void 0!==u&&u(),t("change",e.target.value)}function F(t){void 0!==t&&stop(t),null!==c&&(clearTimeout(c),c=null),void 0!==u&&u(),r=!1,i=!1,delete l.value,"file"!==e.type&&setTimeout(()=>{null!==d.value&&(d.value.value=void 0!==p.value?p.value:"")})}function E(){return!0===l.hasOwnProperty("value")?l.value:void 0!==p.value?p.value:""}vue.watch(()=>e.type,()=>{d.value&&(d.value.value=e.modelValue)}),vue.watch(()=>e.modelValue,t=>{if(!0===m.value){if(!0===i&&(i=!1,String(t)===s))return;h(t)}else p.value!==t&&(p.value=t,"number"===e.type&&!0===l.hasOwnProperty("value")&&(!0===r?r=!1:delete l.value));!0===e.autogrow&&vue.nextTick(R)}),vue.watch(()=>e.autogrow,e=>{!0===e?vue.nextTick(R):null!==d.value&&o.rows>0&&(d.value.style.height="auto")}),vue.watch(()=>e.dense,()=>{!0===e.autogrow&&vue.nextTick(R)}),vue.onBeforeUnmount(()=>{F()}),vue.onMounted(()=>{!0===e.autogrow&&R()}),Object.assign(w,{innerValue:p,fieldClass:vue.computed(()=>`q-${!0===C.value?"textarea":"input"}`+(!0===e.autogrow?" q-textarea--autogrow":"")),hasShadow:vue.computed(()=>"file"!==e.type&&"string"===typeof e.shadowText&&0!==e.shadowText.length),inputRef:d,emitValue:B,hasValue:S,floatingLabel:vue.computed(()=>!0===S.value&&("number"!==e.type||!1===isNaN(p.value))||fieldValueIsFilled(e.displayValue)),getControl:()=>{return vue.h(!0===C.value?"textarea":"input",{ref:d,class:["q-field__native q-placeholder",e.inputClass],style:e.inputStyle,...q.value,..._.value,..."file"!==e.type?{value:E()}:y.value})},getShadowControl:()=>{return vue.h("div",{class:"q-field__native q-field__shadow absolute-bottom no-pointer-events"+(!0===C.value?"":" text-no-wrap")},[vue.h("span",{class:"invisible"},E()),vue.h("span",e.shadowText)])}});const D=useField(w);return Object.assign(n,{focus:T,select:P,getNativeElement:()=>d.value}),injectProp(n,"nativeEl",()=>d.value),D}}),Intersection=createDirective({name:"intersection",getSSRProps:getSSRProps}),QIntersection=createComponent({name:"QIntersection",props:{tag:{type:String,default:"div"},once:Boolean,transition:String,transitionDuration:{type:[String,Number],default:300},ssrPrerender:Boolean,margin:String,threshold:[Number,Array],root:{default:null},disable:Boolean,onVisibility:Function},setup(e,{slots:t,emit:o}){const n=vue.ref(!0===isRuntimeSsrPreHydration.value&&e.ssrPrerender),a=vue.computed(()=>void 0!==e.root||void 0!==e.margin||void 0!==e.threshold?{handler:u,cfg:{root:e.root,rootMargin:e.margin,threshold:e.threshold}}:u),l=vue.computed(()=>!0!==e.disable&&(!0!==isRuntimeSsrPreHydration.value||!0!==e.once||!0!==e.ssrPrerender)),r=vue.computed(()=>{return[[Intersection,a.value,void 0,{once:e.once}]]}),i=vue.computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`);function u(t){n.value!==t.isIntersecting&&(n.value=t.isIntersecting,void 0!==e.onVisibility&&o("visibility",n.value))}function s(){return!0===n.value?[vue.h("div",{key:"content",style:i.value},hSlot(t.default))]:void 0!==t.hidden?[vue.h("div",{key:"hidden",style:i.value},t.hidden())]:void 0}return()=>{const t=e.transition?[vue.h(vue.Transition,{name:"q-transition--"+e.transition},s)]:s();return hDir(e.tag,{class:"q-intersection"},t,"main",l.value,()=>r.value)}}}),QList=createComponent({name:"QList",props:{...useDarkProps,bordered:Boolean,dense:Boolean,separator:Boolean,padding:Boolean,tag:{type:String,default:"div"}},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),a=vue.computed(()=>"q-list"+(!0===e.bordered?" q-list--bordered":"")+(!0===e.dense?" q-list--dense":"")+(!0===e.separator?" q-list--separator":"")+(!0===n.value?" q-list--dark":"")+(!0===e.padding?" q-list--padding":""));return()=>vue.h(e.tag,{class:a.value},hSlot(t.default))}});const keyCodes$1=[34,37,40,33,39,38],commonPropsName=Object.keys(useCircularCommonProps);var QKnob=createComponent({name:"QKnob",props:{...useFormProps,...useCircularCommonProps,modelValue:{type:Number,required:!0},innerMin:Number,innerMax:Number,step:{type:Number,default:1,validator:e=>e>=0},tabindex:{type:[Number,String],default:0},disable:Boolean,readonly:Boolean},emits:["update:modelValue","change","dragValue"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=vue.ref(e.modelValue),r=vue.ref(!1),i=vue.computed(()=>!0===isNaN(e.innerMin)||e.innerMin<e.min?e.min:e.innerMin),u=vue.computed(()=>!0===isNaN(e.innerMax)||e.innerMax>e.max?e.max:e.innerMax);let s;function c(){l.value=null===e.modelValue?i.value:between(e.modelValue,i.value,u.value),T(!0)}vue.watch(()=>`${e.modelValue}|${i.value}|${u.value}`,c),c();const d=vue.computed(()=>!1===e.disable&&!1===e.readonly),v=vue.computed(()=>"q-knob non-selectable"+(!0===d.value?" q-knob--editable":!0===e.disable?" disabled":"")),p=vue.computed(()=>(String(e.step).trim().split(".")[1]||"").length),m=vue.computed(()=>0===e.step?1:e.step),f=vue.computed(()=>!0===e.instantFeedback||!0===r.value),h=!0===a.platform.is.mobile?vue.computed(()=>!0===d.value?{onClick:C}:{}):vue.computed(()=>!0===d.value?{onMousedown:w,onClick:C,onKeydown:k,onKeyup:q}:{}),g=vue.computed(()=>!0===d.value?{tabindex:e.tabindex}:{[`aria-${!0===e.disable?"disabled":"readonly"}`]:"true"}),b=vue.computed(()=>{const t={};return commonPropsName.forEach(o=>{t[o]=e[o]}),t});function y(e){e.isFinal?(_(e.evt,!0),r.value=!1):e.isFirst?(x(),r.value=!0,_(e.evt)):_(e.evt)}const S=vue.computed(()=>{return[[TouchPan,y,void 0,{prevent:!0,stop:!0,mouse:!0}]]});function x(){const{top:e,left:t,width:o,height:a}=n.$el.getBoundingClientRect();s={top:e+a/2,left:t+o/2}}function w(e){x(),_(e)}function C(e){x(),_(e,!0)}function k(e){if(!keyCodes$1.includes(e.keyCode))return;stopAndPrevent(e);const t=([34,33].includes(e.keyCode)?10:1)*m.value,o=[34,37,40].includes(e.keyCode)?-t:t;l.value=between(parseFloat((l.value+o).toFixed(p.value)),i.value,u.value),T()}function _(t,n){const r=position(t),c=Math.abs(r.top-s.top),d=Math.sqrt(c**2+Math.abs(r.left-s.left)**2);let v=Math.asin(c/d)*(180/Math.PI);v=r.top<s.top?s.left<r.left?90-v:270+v:s.left<r.left?v+90:270-v,!0===a.lang.rtl?v=normalizeToInterval(-v-e.angle,0,360):e.angle&&(v=normalizeToInterval(v-e.angle,0,360)),!0===e.reverse&&(v=360-v);let f=e.min+v/360*(e.max-e.min);if(0!==m.value){const e=f%m.value;f=f-e+(Math.abs(e)>=m.value/2?(e<0?-1:1)*m.value:0),f=parseFloat(f.toFixed(p.value))}f=between(f,i.value,u.value),o("dragValue",f),l.value!==f&&(l.value=f),T(n)}function q(e){keyCodes$1.includes(e.keyCode)&&T(!0)}function T(t){e.modelValue!==l.value&&o("update:modelValue",l.value),!0===t&&o("change",l.value)}const P=useFormAttrs(e);function M(){return vue.h("input",P.value)}return()=>{const o={class:v.value,role:"slider","aria-valuemin":i.value,"aria-valuemax":u.value,"aria-valuenow":e.modelValue,...g.value,...b.value,value:l.value,instantFeedback:f.value,...h.value},n={default:t.default};return!0===d.value&&void 0!==e.name&&(n.internal=M),hDir(QCircularProgress,o,n,"knob",d.value,()=>S.value)}}});const{passive:passive$1}=listenOpts,axisValues=["both","horizontal","vertical"];var QScrollObserver=createComponent({name:"QScrollObserver",props:{axis:{type:String,validator:e=>axisValues.includes(e),default:"vertical"},debounce:[String,Number],scrollTarget:{default:void 0}},emits:["scroll"],setup(e,{emit:t}){const o={position:{top:0,left:0},direction:"down",directionChanged:!1,delta:{top:0,left:0},inflectionPoint:{top:0,left:0}};let n,a,l=null;function r(){null!==l&&l();const a=Math.max(0,getVerticalScrollPosition(n)),r=getHorizontalScrollPosition(n),i={top:a-o.position.top,left:r-o.position.left};if("vertical"===e.axis&&0===i.top||"horizontal"===e.axis&&0===i.left)return;const u=Math.abs(i.top)>=Math.abs(i.left)?i.top<0?"up":"down":i.left<0?"left":"right";o.position={top:a,left:r},o.directionChanged=o.direction!==u,o.delta=i,!0===o.directionChanged&&(o.direction=u,o.inflectionPoint=o.position),t("scroll",{...o})}function i(){n=getScrollTarget(a,e.scrollTarget),n.addEventListener("scroll",s,passive$1),s(!0)}function u(){void 0!==n&&(n.removeEventListener("scroll",s,passive$1),n=void 0)}function s(t){if(!0===t||0===e.debounce||"0"===e.debounce)r();else if(null===l){const[t,o]=e.debounce?[setTimeout(r,e.debounce),clearTimeout]:[requestAnimationFrame(r),cancelAnimationFrame];l=(()=>{o(t),l=null})}}vue.watch(()=>e.scrollTarget,()=>{u(),i()});const{proxy:c}=vue.getCurrentInstance();return vue.watch(()=>c.$q.lang.rtl,r),vue.onMounted(()=>{a=c.$el.parentNode,i()}),vue.onBeforeUnmount(()=>{null!==l&&l(),u()}),Object.assign(c,{trigger:s,getPosition:()=>o}),noop}}),QLayout=createComponent({name:"QLayout",props:{container:Boolean,view:{type:String,default:"hhh lpr fff",validator:e=>/^(h|l)h(h|r) lpr (f|l)f(f|r)$/.test(e.toLowerCase())},onScroll:Function,onScrollHeight:Function,onResize:Function},setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=vue.ref(null),l=vue.ref(n.screen.height),r=vue.ref(!0===e.container?0:n.screen.width),i=vue.ref({position:0,direction:"down",inflectionPoint:0}),u=vue.ref(0),s=vue.ref(!0===isRuntimeSsrPreHydration.value?0:getScrollbarWidth()),c=vue.computed(()=>"q-layout q-layout--"+(!0===e.container?"containerized":"standard")),d=vue.computed(()=>!1===e.container?{minHeight:n.screen.height+"px"}:null),v=vue.computed(()=>0!==s.value?{[!0===n.lang.rtl?"left":"right"]:`${s.value}px`}:null),p=vue.computed(()=>0!==s.value?{[!0===n.lang.rtl?"right":"left"]:0,[!0===n.lang.rtl?"left":"right"]:`-${s.value}px`,width:`calc(100% + ${s.value}px)`}:null);function m(t){if(!0===e.container||!0!==document.qScrollPrevented){const n={position:t.position.top,direction:t.direction,directionChanged:t.directionChanged,inflectionPoint:t.inflectionPoint.top,delta:t.delta.top};i.value=n,void 0!==e.onScroll&&o("scroll",n)}}function f(t){const{height:n,width:a}=t;let i=!1;l.value!==n&&(i=!0,l.value=n,void 0!==e.onScrollHeight&&o("scrollHeight",n),g()),r.value!==a&&(i=!0,r.value=a),!0===i&&void 0!==e.onResize&&o("resize",t)}function h({height:e}){u.value!==e&&(u.value=e,g())}function g(){if(!0===e.container){const e=l.value>u.value?getScrollbarWidth():0;s.value!==e&&(s.value=e)}}let b=null;const y={instances:{},view:vue.computed(()=>e.view),isContainer:vue.computed(()=>e.container),rootRef:a,height:l,containerHeight:u,scrollbarWidth:s,totalWidth:vue.computed(()=>r.value+s.value),rows:vue.computed(()=>{const t=e.view.toLowerCase().split(" ");return{top:t[0].split(""),middle:t[1].split(""),bottom:t[2].split("")}}),header:vue.reactive({size:0,offset:0,space:!1}),right:vue.reactive({size:300,offset:0,space:!1}),footer:vue.reactive({size:0,offset:0,space:!1}),left:vue.reactive({size:300,offset:0,space:!1}),scroll:i,animate(){null!==b?clearTimeout(b):document.body.classList.add("q-body--layout-animate"),b=setTimeout(()=>{b=null,document.body.classList.remove("q-body--layout-animate")},155)},update(e,t,o){y[e][t]=o}};return vue.provide(layoutKey,y),()=>{const o=hMergeSlot(t.default,[vue.h(QScrollObserver,{onScroll:m}),vue.h(QResizeObserver,{onResize:f})]),n=vue.h("div",{class:c.value,style:d.value,ref:!0===e.container?void 0:a,tabindex:-1},o);return!0===e.container?vue.h("div",{class:"q-layout-container overflow-hidden",ref:a},[vue.h(QResizeObserver,{onResize:h}),vue.h("div",{class:"absolute-full",style:v.value},[vue.h("div",{class:"scroll",style:p.value},[n])])]):n}}});const separatorValues=["horizontal","vertical","cell","none"];var QMarkupTable=createComponent({name:"QMarkupTable",props:{...useDarkProps,dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,wrapCells:Boolean,separator:{type:String,default:"horizontal",validator:e=>separatorValues.includes(e)}},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),a=vue.computed(()=>"q-markup-table q-table__container q-table__card"+` q-table--${e.separator}-separator`+(!0===n.value?" q-table--dark q-table__card--dark q-dark":"")+(!0===e.dense?" q-table--dense":"")+(!0===e.flat?" q-table--flat":"")+(!0===e.bordered?" q-table--bordered":"")+(!0===e.square?" q-table--square":"")+(!1===e.wrapCells?" q-table--no-wrap":""));return()=>vue.h("div",{class:a.value},[vue.h("table",{class:"q-table"},hSlot(t.default))])}}),QNoSsr=createComponent({name:"QNoSsr",props:{tag:{type:String,default:"div"},placeholder:String},setup(e,{slots:t}){const o=useCanRender();return()=>{const n={};if(!0===o.value){const o=hSlot(t.default);return void 0===o?o:o.length>1?vue.h(e.tag,n,o):o[0]}n.class="q-no-ssr-placeholder";const a=hSlot(t.placeholder);return void 0!==a?a.length>1?vue.h(e.tag,n,a):a[0]:void 0!==e.placeholder?vue.h(e.tag,n,e.placeholder):void 0}}});const svg$m=vue.h("svg",{key:"svg",class:"q-radio__bg absolute non-selectable",viewBox:"0 0 24 24"},[vue.h("path",{d:"M12,22a10,10 0 0 1 -10,-10a10,10 0 0 1 10,-10a10,10 0 0 1 10,10a10,10 0 0 1 -10,10m0,-22a12,12 0 0 0 -12,12a12,12 0 0 0 12,12a12,12 0 0 0 12,-12a12,12 0 0 0 -12,-12"}),vue.h("path",{class:"q-radio__check",d:"M12,6a6,6 0 0 0 -6,6a6,6 0 0 0 6,6a6,6 0 0 0 6,-6a6,6 0 0 0 -6,-6"})]);var QRadio=createComponent({name:"QRadio",props:{...useDarkProps,...useSizeProps,...useFormProps,modelValue:{required:!0},val:{required:!0},label:String,leftLabel:Boolean,checkedIcon:String,uncheckedIcon:String,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),a=useDark(e,n.$q),l=useSize(e,optionSizes),r=vue.ref(null),{refocusTargetEl:i,refocusTarget:u}=useRefocusTarget(e,r),s=vue.computed(()=>vue.toRaw(e.modelValue)===vue.toRaw(e.val)),c=vue.computed(()=>"q-radio cursor-pointer no-outline row inline no-wrap items-center"+(!0===e.disable?" disabled":"")+(!0===a.value?" q-radio--dark":"")+(!0===e.dense?" q-radio--dense":"")+(!0===e.leftLabel?" reverse":"")),d=vue.computed(()=>{const t=void 0===e.color||!0!==e.keepColor&&!0!==s.value?"":` text-${e.color}`;return"q-radio__inner relative-position "+`q-radio__inner--${!0===s.value?"truthy":"falsy"}${t}`}),v=vue.computed(()=>(!0===s.value?e.checkedIcon:e.uncheckedIcon)||null),p=vue.computed(()=>!0===e.disable?-1:e.tabindex||0),m=vue.computed(()=>{const t={type:"radio"};return void 0!==e.name&&Object.assign(t,{".checked":!0===s.value,"^checked":!0===s.value?"checked":void 0,name:e.name,value:e.val}),t}),f=useFormInject(m);function h(t){void 0!==t&&(stopAndPrevent(t),u(t)),!0!==e.disable&&!0!==s.value&&o("update:modelValue",e.val,t)}function g(e){13!==e.keyCode&&32!==e.keyCode||stopAndPrevent(e)}function b(e){13!==e.keyCode&&32!==e.keyCode||h(e)}return Object.assign(n,{set:h}),()=>{const o=null!==v.value?[vue.h("div",{key:"icon",class:"q-radio__icon-container absolute-full flex flex-center no-wrap"},[vue.h(QIcon,{class:"q-radio__icon",name:v.value})])]:[svg$m];!0!==e.disable&&f(o,"unshift"," q-radio__native q-ma-none q-pa-none");const n=[vue.h("div",{class:d.value,style:l.value,"aria-hidden":"true"},o)];null!==i.value&&n.push(i.value);const a=void 0!==e.label?hMergeSlot(t.default,[e.label]):hSlot(t.default);return void 0!==a&&n.push(vue.h("div",{class:"q-radio__label q-anchor--skip"},a)),vue.h("div",{ref:r,class:c.value,tabindex:p.value,role:"radio","aria-label":e.label,"aria-checked":!0===s.value?"true":"false","aria-disabled":!0===e.disable?"true":void 0,onClick:h,onKeydown:g,onKeyup:b},n)}}}),QToggle=createComponent({name:"QToggle",props:{...useCheckboxProps,icon:String,iconColor:String},emits:useCheckboxEmits,setup(e){function t(t,o){const n=vue.computed(()=>(!0===t.value?e.checkedIcon:!0===o.value?e.indeterminateIcon:e.uncheckedIcon)||e.icon),a=vue.computed(()=>!0===t.value?e.iconColor:null);return()=>[vue.h("div",{class:"q-toggle__track"}),vue.h("div",{class:"q-toggle__thumb absolute flex flex-center no-wrap"},void 0!==n.value?[vue.h(QIcon,{name:n.value,color:a.value})]:void 0)]}return useCheckbox("toggle",t)}});const components$1={radio:QRadio,checkbox:QCheckbox,toggle:QToggle},typeValues=Object.keys(components$1);var QOptionGroup=createComponent({name:"QOptionGroup",props:{...useDarkProps,modelValue:{required:!0},options:{type:Array,validator:e=>e.every(e=>"value"in e&&"label"in e)},name:String,type:{default:"radio",validator:e=>typeValues.includes(e)},color:String,keepColor:Boolean,dense:Boolean,size:String,leftLabel:Boolean,inline:Boolean,disable:Boolean},emits:["update:modelValue"],setup(e,{emit:t,slots:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=Array.isArray(e.modelValue);"radio"===e.type?!0===a&&console.error("q-option-group: model should not be array"):!1===a&&console.error("q-option-group: model should be array in your case");const l=useDark(e,n),r=vue.computed(()=>components$1[e.type]),i=vue.computed(()=>"q-option-group q-gutter-x-sm"+(!0===e.inline?" q-option-group--inline":"")),u=vue.computed(()=>{const t={role:"group"};return"radio"===e.type&&(t.role="radiogroup",!0===e.disable&&(t["aria-disabled"]="true")),t});function s(e){t("update:modelValue",e)}return()=>vue.h("div",{class:i.value,...u.value},e.options.map((t,n)=>{const a=void 0!==o["label-"+n]?()=>o["label-"+n](t):void 0!==o.label?()=>o.label(t):void 0;return vue.h("div",[vue.h(r.value,{modelValue:e.modelValue,val:t.value,name:void 0===t.name?e.name:t.name,disable:e.disable||t.disable,label:void 0===a?t.label:null,leftLabel:void 0===t.leftLabel?e.leftLabel:t.leftLabel,color:void 0===t.color?e.color:t.color,checkedIcon:t.checkedIcon,uncheckedIcon:t.uncheckedIcon,dark:t.dark||l.value,size:void 0===t.size?e.size:t.size,dense:e.dense,keepColor:void 0===t.keepColor?e.keepColor:t.keepColor,"onUpdate:modelValue":s},a)])}))}}),QPage=createComponent({name:"QPage",props:{padding:Boolean,styleFn:Function},setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=vue.inject(layoutKey,emptyRenderFn);if(n===emptyRenderFn)return console.error("QPage needs to be a deep child of QLayout"),emptyRenderFn;const a=vue.inject(pageContainerKey,emptyRenderFn);if(a===emptyRenderFn)return console.error("QPage needs to be child of QPageContainer"),emptyRenderFn;const l=vue.computed(()=>{const t=(!0===n.header.space?n.header.size:0)+(!0===n.footer.space?n.footer.size:0);if("function"===typeof e.styleFn){const a=!0===n.isContainer.value?n.containerHeight.value:o.screen.height;return e.styleFn(t,a)}return{minHeight:!0===n.isContainer.value?n.containerHeight.value-t+"px":0===o.screen.height?0!==t?`calc(100vh - ${t}px)`:"100vh":o.screen.height-t+"px"}}),r=vue.computed(()=>`q-page${!0===e.padding?" q-layout-padding":""}`);return()=>vue.h("main",{class:r.value,style:l.value},hSlot(t.default))}}),QPageContainer=createComponent({name:"QPageContainer",setup(e,{slots:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=vue.inject(layoutKey,emptyRenderFn);if(n===emptyRenderFn)return console.error("QPageContainer needs to be child of QLayout"),emptyRenderFn;vue.provide(pageContainerKey,!0);const a=vue.computed(()=>{const e={};return!0===n.header.space&&(e.paddingTop=`${n.header.size}px`),!0===n.right.space&&(e[`padding${!0===o.lang.rtl?"Left":"Right"}`]=`${n.right.size}px`),!0===n.footer.space&&(e.paddingBottom=`${n.footer.size}px`),!0===n.left.space&&(e[`padding${!0===o.lang.rtl?"Right":"Left"}`]=`${n.left.size}px`),e});return()=>vue.h("div",{class:"q-page-container",style:a.value},hSlot(t.default))}});const usePageStickyProps={position:{type:String,default:"bottom-right",validator:e=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(e)},offset:{type:Array,validator:e=>2===e.length},expand:Boolean};function usePageSticky(){const{props:e,proxy:{$q:t}}=vue.getCurrentInstance(),o=vue.inject(layoutKey,emptyRenderFn);if(o===emptyRenderFn)return console.error("QPageSticky needs to be child of QLayout"),emptyRenderFn;const n=vue.computed(()=>{const t=e.position;return{top:t.indexOf("top")>-1,right:t.indexOf("right")>-1,bottom:t.indexOf("bottom")>-1,left:t.indexOf("left")>-1,vertical:"top"===t||"bottom"===t,horizontal:"left"===t||"right"===t}}),a=vue.computed(()=>o.header.offset),l=vue.computed(()=>o.right.offset),r=vue.computed(()=>o.footer.offset),i=vue.computed(()=>o.left.offset),u=vue.computed(()=>{let o=0,u=0;const s=n.value,c=!0===t.lang.rtl?-1:1;!0===s.top&&0!==a.value?u=`${a.value}px`:!0===s.bottom&&0!==r.value&&(u=`${-r.value}px`),!0===s.left&&0!==i.value?o=`${c*i.value}px`:!0===s.right&&0!==l.value&&(o=`${-c*l.value}px`);const d={transform:`translate(${o}, ${u})`};return e.offset&&(d.margin=`${e.offset[1]}px ${e.offset[0]}px`),!0===s.vertical?(0!==i.value&&(d[!0===t.lang.rtl?"right":"left"]=`${i.value}px`),0!==l.value&&(d[!0===t.lang.rtl?"left":"right"]=`${l.value}px`)):!0===s.horizontal&&(0!==a.value&&(d.top=`${a.value}px`),0!==r.value&&(d.bottom=`${r.value}px`)),d}),s=vue.computed(()=>`q-page-sticky row flex-center fixed-${e.position}`+` q-page-sticky--${!0===e.expand?"expand":"shrink"}`);function c(t){const o=hSlot(t.default);return vue.h("div",{class:s.value,style:u.value},!0===e.expand?o:[vue.h("div",o)])}return{$layout:o,getStickyContent:c}}var QPageScroller=createComponent({name:"QPageScroller",props:{...usePageStickyProps,scrollOffset:{type:Number,default:1e3},reverse:Boolean,duration:{type:Number,default:300},offset:{default:()=>[18,18]}},emits:["click"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),{$layout:a,getStickyContent:l}=usePageSticky(),r=vue.ref(null);let i;const u=vue.computed(()=>a.height.value-(!0===a.isContainer.value?a.containerHeight.value:n.screen.height));function s(){return!0===e.reverse?u.value-a.scroll.value.position>e.scrollOffset:a.scroll.value.position>e.scrollOffset}const c=vue.ref(s());function d(){const e=s();c.value!==e&&(c.value=e)}function v(){!0===e.reverse?void 0===i&&(i=vue.watch(u,d)):p()}function p(){void 0!==i&&(i(),i=void 0)}function m(t){const n=getScrollTarget(!0===a.isContainer.value?r.value:a.rootRef.value);setVerticalScrollPosition(n,!0===e.reverse?a.height.value:0,e.duration),o("click",t)}function f(){return!0===c.value?vue.h("div",{ref:r,class:"q-page-scroller",onClick:m},l(t)):null}return vue.watch(a.scroll,d),vue.watch(()=>e.reverse,v),v(),vue.onBeforeUnmount(p),()=>vue.h(vue.Transition,{name:"q-transition--fade"},f)}}),QPageSticky=createComponent({name:"QPageSticky",props:usePageStickyProps,setup(e,{slots:t}){const{getStickyContent:o}=usePageSticky();return()=>o(t)}});function getBool(e,t){return[!0,!1].includes(e)?e:t}var QPagination=createComponent({name:"QPagination",props:{...useDarkProps,modelValue:{type:Number,required:!0},min:{type:[Number,String],default:1},max:{type:[Number,String],required:!0},maxPages:{type:[Number,String],default:0,validator:e=>("string"===typeof e?parseInt(e,10):e)>=0},inputStyle:[Array,String,Object],inputClass:[Array,String,Object],size:String,disable:Boolean,input:Boolean,iconPrev:String,iconNext:String,iconFirst:String,iconLast:String,toFn:Function,boundaryLinks:{type:Boolean,default:null},boundaryNumbers:{type:Boolean,default:null},directionLinks:{type:Boolean,default:null},ellipses:{type:Boolean,default:null},ripple:{type:[Boolean,Object],default:null},round:Boolean,rounded:Boolean,flat:Boolean,outline:Boolean,unelevated:Boolean,push:Boolean,glossy:Boolean,color:{type:String,default:"primary"},textColor:String,activeDesign:{type:String,default:"",values:e=>""===e||btnDesignOptions.includes(e)},activeColor:String,activeTextColor:String,gutter:String,padding:{type:String,default:"3px 2px"}},emits:["update:modelValue"],setup(e,{emit:t}){const{proxy:o}=vue.getCurrentInstance(),{$q:n}=o,a=useDark(e,n),l=vue.computed(()=>parseInt(e.min,10)),r=vue.computed(()=>parseInt(e.max,10)),i=vue.computed(()=>parseInt(e.maxPages,10)),u=vue.computed(()=>m.value+" / "+r.value),s=vue.computed(()=>getBool(e.boundaryLinks,e.input)),c=vue.computed(()=>getBool(e.boundaryNumbers,!e.input)),d=vue.computed(()=>getBool(e.directionLinks,e.input)),v=vue.computed(()=>getBool(e.ellipses,!e.input)),p=vue.ref(null),m=vue.computed({get:()=>e.modelValue,set:o=>{if(o=parseInt(o,10),e.disable||isNaN(o))return;const n=between(o,l.value,r.value);e.modelValue!==n&&t("update:modelValue",n)}});vue.watch(()=>`${l.value}|${r.value}`,()=>{m.value=e.modelValue});const f=vue.computed(()=>"q-pagination row no-wrap items-center"+(!0===e.disable?" disabled":"")),h=vue.computed(()=>e.gutter in btnPadding?`${btnPadding[e.gutter]}px`:e.gutter||null),g=vue.computed(()=>null!==h.value?`--q-pagination-gutter-parent:-${h.value};--q-pagination-gutter-child:${h.value}`:null),b=vue.computed(()=>{const t=[e.iconFirst||n.iconSet.pagination.first,e.iconPrev||n.iconSet.pagination.prev,e.iconNext||n.iconSet.pagination.next,e.iconLast||n.iconSet.pagination.last];return!0===n.lang.rtl?t.reverse():t}),y=vue.computed(()=>({"aria-disabled":!0===e.disable?"true":"false",role:"navigation"})),S=vue.computed(()=>getBtnDesign(e,"flat")),x=vue.computed(()=>({[S.value]:!0,round:e.round,rounded:e.rounded,padding:e.padding,color:e.color,textColor:e.textColor,size:e.size,ripple:null===e.ripple||e.ripple})),w=vue.computed(()=>{const t={[S.value]:!1};return""!==e.activeDesign&&(t[e.activeDesign]=!0),t}),C=vue.computed(()=>({...w.value,color:e.activeColor||e.color,textColor:e.activeTextColor||e.textColor})),k=vue.computed(()=>{let t=Math.max(i.value,1+(v.value?2:0)+(c.value?2:0));const o={pgFrom:l.value,pgTo:r.value,ellipsesStart:!1,ellipsesEnd:!1,boundaryStart:!1,boundaryEnd:!1,marginalStyle:{minWidth:`${Math.max(2,String(r.value).length)}em`}};return i.value&&t<r.value-l.value+1&&(t=1+2*Math.floor(t/2),o.pgFrom=Math.max(l.value,Math.min(r.value-t+1,e.modelValue-Math.floor(t/2))),o.pgTo=Math.min(r.value,o.pgFrom+t-1),c.value&&(o.boundaryStart=!0,o.pgFrom++),v.value&&o.pgFrom>l.value+(c.value?1:0)&&(o.ellipsesStart=!0,o.pgFrom++),c.value&&(o.boundaryEnd=!0,o.pgTo--),v.value&&o.pgTo<r.value-(c.value?1:0)&&(o.ellipsesEnd=!0,o.pgTo--)),o});function _(e){m.value=e}function q(e){m.value=m.value+e}const T=vue.computed(()=>{function e(){m.value=p.value,p.value=null}return{"onUpdate:modelValue":e=>{p.value=e},onKeyup:t=>{!0===isKeyCode(t,13)&&e()},onBlur:e}});function P(t,o,n){const a={"aria-label":o,"aria-current":"false",...x.value,...t};return!0===n&&Object.assign(a,{"aria-current":"true",...C.value}),void 0!==o&&(void 0!==e.toFn?a.to=e.toFn(o):a.onClick=(()=>{_(o)})),vue.h(QBtn,a)}return Object.assign(o,{set:_,setByOffset:q}),()=>{const t=[],o=[];let n;if(!0===s.value&&(t.push(P({key:"bls",disable:e.disable||e.modelValue<=l.value,icon:b.value[0]},l.value)),o.unshift(P({key:"ble",disable:e.disable||e.modelValue>=r.value,icon:b.value[3]},r.value))),!0===d.value&&(t.push(P({key:"bdp",disable:e.disable||e.modelValue<=l.value,icon:b.value[1]},e.modelValue-1)),o.unshift(P({key:"bdn",disable:e.disable||e.modelValue>=r.value,icon:b.value[2]},e.modelValue+1))),!0!==e.input){n=[];const{pgFrom:a,pgTo:i,marginalStyle:u}=k.value;if(!0===k.value.boundaryStart){const o=l.value===e.modelValue;t.push(P({key:"bns",style:u,disable:e.disable,label:l.value},l.value,o))}if(!0===k.value.boundaryEnd){const t=r.value===e.modelValue;o.unshift(P({key:"bne",style:u,disable:e.disable,label:r.value},r.value,t))}!0===k.value.ellipsesStart&&t.push(P({key:"bes",style:u,disable:e.disable,label:"…",ripple:!1},a-1)),!0===k.value.ellipsesEnd&&o.unshift(P({key:"bee",style:u,disable:e.disable,label:"…",ripple:!1},i+1));for(let t=a;t<=i;t++)n.push(P({key:`bpg${t}`,style:u,disable:e.disable,label:t},t,t===e.modelValue))}return vue.h("div",{class:f.value,...y.value},[vue.h("div",{class:"q-pagination__content row no-wrap items-center",style:g.value},[...t,!0===e.input?vue.h(QInput,{class:"inline",style:{width:`${u.value.length/1.5}em`},type:"number",dense:!0,value:p.value,disable:e.disable,dark:a.value,borderless:!0,inputClass:e.inputClass,inputStyle:e.inputStyle,placeholder:u.value,min:l.value,max:r.value,...T.value}):vue.h("div",{class:"q-pagination__middle row justify-center"},n),...o])])}}});function frameDebounce(e){let t,o,n=!1;function a(){o=arguments,!0!==n&&(n=!0,t=requestAnimationFrame(()=>{e.apply(this,o),o=void 0,n=!1}))}return a.cancel=(()=>{window.cancelAnimationFrame(t),n=!1}),a}const{passive:passive}=listenOpts;var QParallax=createComponent({name:"QParallax",props:{src:String,height:{type:Number,default:500},speed:{type:Number,default:1,validator:e=>e>=0&&e<=1},scrollTarget:{default:void 0},onScroll:Function},setup(e,{slots:t,emit:o}){const n=vue.ref(0),a=vue.ref(null),l=vue.ref(null),r=vue.ref(null);let i,u,s,c,d,v;vue.watch(()=>e.height,()=>{!0===i&&m()}),vue.watch(()=>e.scrollTarget,()=>{!0===i&&(b(),g())});let p=t=>{n.value=t,void 0!==e.onScroll&&o("scroll",t)};function m(){let t,o,n;v===window?(t=0,n=o=window.innerHeight):(t=offset(v).top,o=height(v),n=t+o);const l=offset(a.value).top,r=l+e.height;if(void 0!==d||r>t&&l<n){const t=(n-l)/(e.height+o);f((s-e.height)*t*e.speed),p(t)}}let f=e=>{u.style.transform=`translate3d(-50%,${Math.round(e)}px,0)`};function h(){s=u.naturalHeight||u.videoHeight||height(u),!0===i&&m()}function g(){i=!0,v=getScrollTarget(a.value,e.scrollTarget),v.addEventListener("scroll",m,passive),window.addEventListener("resize",c,passive),m()}function b(){!0===i&&(i=!1,v.removeEventListener("scroll",m,passive),window.removeEventListener("resize",c,passive),v=void 0,f.cancel(),p.cancel(),c.cancel())}return vue.onMounted(()=>{f=frameDebounce(f),p=frameDebounce(p),c=frameDebounce(h),u=void 0!==t.media?l.value.children[0]:r.value,u.onload=u.onloadstart=u.loadedmetadata=h,h(),u.style.display="initial",void 0!==window.IntersectionObserver?(d=new IntersectionObserver(e=>{const t=!0===e[0].isIntersecting?g:b;t()}),d.observe(a.value)):g()}),vue.onBeforeUnmount(()=>{b(),void 0!==d&&d.disconnect(),u.onload=u.onloadstart=u.loadedmetadata=null}),()=>{return vue.h("div",{ref:a,class:"q-parallax",style:{height:`${e.height}px`}},[vue.h("div",{ref:l,class:"q-parallax__media absolute-full"},void 0!==t.media?t.media():[vue.h("img",{ref:r,src:e.src})]),vue.h("div",{class:"q-parallax__content absolute-full column flex-center"},void 0!==t.content?t.content({percentScrolled:n.value}):hSlot(t.default))])}}});function cloneDeep(e,t=new WeakMap){if(Object(e)!==e)return e;if(t.has(e))return t.get(e);const o=e instanceof Date?new Date(e):e instanceof RegExp?new RegExp(e.source,e.flags):e instanceof Set?new Set:e instanceof Map?new Map:"function"!==typeof e.constructor?Object.create(null):void 0!==e.prototype&&"function"===typeof e.prototype.constructor?e:new e.constructor;if("function"===typeof e.constructor&&"function"===typeof e.valueOf){const o=e.valueOf();if(Object(o)!==o){const n=new e.constructor(o);return t.set(e,n),n}}return t.set(e,o),e instanceof Set?e.forEach(e=>{o.add(cloneDeep(e,t))}):e instanceof Map&&e.forEach((e,n)=>{o.set(n,cloneDeep(e,t))}),Object.assign(o,...Object.keys(e).map(o=>({[o]:cloneDeep(e[o],t)})))}var QPopupEdit=createComponent({name:"QPopupEdit",props:{modelValue:{required:!0},title:String,buttons:Boolean,labelSet:String,labelCancel:String,color:{type:String,default:"primary"},validate:{type:Function,default:()=>!0},autoSave:Boolean,cover:{type:Boolean,default:!0},disable:Boolean},emits:["update:modelValue","save","cancel","beforeShow","show","beforeHide","hide"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=vue.ref(null),r=vue.ref(""),i=vue.ref("");let u=!1;const s=vue.computed(()=>{return injectProp({initialValue:r.value,validate:e.validate,set:c,cancel:d,updatePosition:v},"value",()=>i.value,e=>{i.value=e})});function c(){!1!==e.validate(i.value)&&(!0===p()&&(o("save",i.value,r.value),o("update:modelValue",i.value)),m())}function d(){!0===p()&&o("cancel",i.value,r.value),m()}function v(){vue.nextTick(()=>{l.value.updatePosition()})}function p(){return!1===isDeepEqual(i.value,r.value)}function m(){u=!0,l.value.hide()}function f(){u=!1,r.value=cloneDeep(e.modelValue),i.value=cloneDeep(e.modelValue),o("beforeShow")}function h(){o("show")}function g(){!1===u&&!0===p()&&(!0===e.autoSave&&!0===e.validate(i.value)?(o("save",i.value,r.value),o("update:modelValue",i.value)):o("cancel",i.value,r.value)),o("beforeHide")}function b(){o("hide")}function y(){const o=void 0!==t.default?[].concat(t.default(s.value)):[];return e.title&&o.unshift(vue.h("div",{class:"q-dialog__title q-mt-sm q-mb-sm"},e.title)),!0===e.buttons&&o.push(vue.h("div",{class:"q-popup-edit__buttons row justify-center no-wrap"},[vue.h(QBtn,{flat:!0,color:e.color,label:e.labelCancel||a.lang.label.cancel,onClick:d}),vue.h(QBtn,{flat:!0,color:e.color,label:e.labelSet||a.lang.label.set,onClick:c})])),o}return Object.assign(n,{set:c,cancel:d,show(e){null!==l.value&&l.value.show(e)},hide(e){null!==l.value&&l.value.hide(e)},updatePosition:v}),()=>{if(!0!==e.disable)return vue.h(QMenu,{ref:l,class:"q-popup-edit",cover:e.cover,onBeforeShow:f,onShow:h,onBeforeHide:g,onHide:b,onEscapeKey:d},y)}}}),QPopupProxy=createComponent({name:"QPopupProxy",props:{...useAnchorProps,breakpoint:{type:[String,Number],default:450}},emits:["show","hide"],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a}=vue.getCurrentInstance(),{$q:l}=a,r=vue.ref(!1),i=vue.ref(null),u=vue.computed(()=>parseInt(e.breakpoint,10)),{canShow:s}=useAnchor({showing:r});function c(){return l.screen.width<u.value||l.screen.height<u.value?"dialog":"menu"}const d=vue.ref(c()),v=vue.computed(()=>"menu"===d.value?{maxHeight:"99vh"}:{});function p(e){r.value=!0,o("show",e)}function m(e){r.value=!1,d.value=c(),o("hide",e)}return vue.watch(()=>c(),e=>{!0!==r.value&&(d.value=e)}),Object.assign(a,{show(e){!0===s(e)&&i.value.show(e)},hide(e){i.value.hide(e)},toggle(e){i.value.toggle(e)}}),injectProp(a,"currentComponent",()=>({type:d.value,ref:i.value})),()=>{const o={ref:i,...v.value,...n,onShow:p,onHide:m};let a;return"dialog"===d.value?a=QDialog:(a=QMenu,Object.assign(o,{target:e.target,contextMenu:e.contextMenu,noParentEvent:!0,separateClosePopup:!0})),vue.h(a,o,t.default)}}});const defaultSizes={xs:2,sm:4,md:6,lg:10,xl:14};function width(e,t,o){return{transform:!0===t?`translateX(${!0===o.lang.rtl?"-":""}100%) scale3d(${-e},1,1)`:`scale3d(${e},1,1)`}}var QLinearProgress=createComponent({name:"QLinearProgress",props:{...useDarkProps,...useSizeProps,value:{type:Number,default:0},buffer:Number,color:String,trackColor:String,reverse:Boolean,stripe:Boolean,indeterminate:Boolean,query:Boolean,rounded:Boolean,animationSpeed:{type:[String,Number],default:2100},instantFeedback:Boolean},setup(e,{slots:t}){const{proxy:o}=vue.getCurrentInstance(),n=useDark(e,o.$q),a=useSize(e,defaultSizes),l=vue.computed(()=>!0===e.indeterminate||!0===e.query),r=vue.computed(()=>e.reverse!==e.query),i=vue.computed(()=>({...null!==a.value?a.value:{},"--q-linear-progress-speed":`${e.animationSpeed}ms`})),u=vue.computed(()=>"q-linear-progress"+(void 0!==e.color?` text-${e.color}`:"")+(!0===e.reverse||!0===e.query?" q-linear-progress--reverse":"")+(!0===e.rounded?" rounded-borders":"")),s=vue.computed(()=>width(void 0!==e.buffer?e.buffer:1,r.value,o.$q)),c=vue.computed(()=>`with${!0===e.instantFeedback?"out":""}-transition`),d=vue.computed(()=>"q-linear-progress__track absolute-full"+` q-linear-progress__track--${c.value}`+` q-linear-progress__track--${!0===n.value?"dark":"light"}`+(void 0!==e.trackColor?` bg-${e.trackColor}`:"")),v=vue.computed(()=>width(!0===l.value?1:e.value,r.value,o.$q)),p=vue.computed(()=>"q-linear-progress__model absolute-full"+` q-linear-progress__model--${c.value}`+` q-linear-progress__model--${!0===l.value?"in":""}determinate`),m=vue.computed(()=>({width:`${100*e.value}%`})),f=vue.computed(()=>`q-linear-progress__stripe absolute-${!0===e.reverse?"right":"left"}`+` q-linear-progress__stripe--${c.value}`);return()=>{const o=[vue.h("div",{class:d.value,style:s.value}),vue.h("div",{class:p.value,style:v.value})];return!0===e.stripe&&!1===l.value&&o.push(vue.h("div",{class:f.value,style:m.value})),vue.h("div",{class:u.value,style:i.value,role:"progressbar","aria-valuemin":0,"aria-valuemax":1,"aria-valuenow":!0===e.indeterminate?void 0:e.value},hMergeSlot(t.default,o))}}});const PULLER_HEIGHT=40,OFFSET_TOP=20;var QPullToRefresh=createComponent({name:"QPullToRefresh",props:{color:String,bgColor:String,icon:String,noMouse:Boolean,disable:Boolean,scrollTarget:{default:void 0}},emits:["refresh"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=vue.ref("pull"),r=vue.ref(0),i=vue.ref(!1),u=vue.ref(-PULLER_HEIGHT),s=vue.ref(!1),c=vue.ref({}),d=vue.computed(()=>({opacity:r.value,transform:`translateY(${u.value}px) rotate(${360*r.value}deg)`})),v=vue.computed(()=>"q-pull-to-refresh__puller row flex-center"+(!0===s.value?" q-pull-to-refresh__puller--animating":"")+(void 0!==e.bgColor?` bg-${e.bgColor}`:""));function p(e){if(!0===e.isFinal)return void(!0===i.value&&(i.value=!1,"pulled"===l.value?(l.value="refreshing",S({pos:OFFSET_TOP}),h()):"pull"===l.value&&S({pos:-PULLER_HEIGHT,ratio:0})));if(!0===s.value||"refreshing"===l.value)return!1;if(!0===e.isFirst){if(0!==getVerticalScrollPosition(b)||"down"!==e.direction)return!0===i.value&&(i.value=!1,l.value="pull",S({pos:-PULLER_HEIGHT,ratio:0})),!1;i.value=!0;const{top:t,left:o}=g.getBoundingClientRect();c.value={top:t+"px",left:o+"px",width:window.getComputedStyle(g).getPropertyValue("width")}}prevent(e.evt);const t=Math.min(140,Math.max(0,e.distance.y));u.value=t-PULLER_HEIGHT,r.value=between(t/(OFFSET_TOP+PULLER_HEIGHT),0,1);const o=u.value>OFFSET_TOP?"pulled":"pull";l.value!==o&&(l.value=o)}const m=vue.computed(()=>{const t={down:!0};return!0!==e.noMouse&&(t.mouse=!0),[[TouchPan,p,void 0,t]]}),f=vue.computed(()=>`q-pull-to-refresh__content${!0===i.value?" no-pointer-events":""}`);function h(){o("refresh",()=>{S({pos:-PULLER_HEIGHT,ratio:0},()=>{l.value="pull"})})}let g,b,y=null;function S({pos:e,ratio:t},o){s.value=!0,u.value=e,void 0!==t&&(r.value=t),null!==y&&clearTimeout(y),y=setTimeout(()=>{y=null,s.value=!1,o&&o()},300)}function x(){b=getScrollTarget(g,e.scrollTarget)}return vue.watch(()=>e.scrollTarget,x),vue.onMounted(()=>{g=n.$el,x()}),vue.onBeforeUnmount(()=>{null!==y&&clearTimeout(y)}),Object.assign(n,{trigger:h,updateScrollTarget:x}),()=>{const o=[vue.h("div",{class:f.value},hSlot(t.default)),vue.h("div",{class:"q-pull-to-refresh__puller-container fixed row flex-center no-pointer-events z-top",style:c.value},[vue.h("div",{class:v.value,style:d.value},["refreshing"!==l.value?vue.h(QIcon,{name:e.icon||a.iconSet.pullToRefresh.icon,color:e.color,size:"32px"}):vue.h(QSpinner,{size:"24px",color:e.color})])])];return hDir("div",{class:"q-pull-to-refresh"},o,"main",!1===e.disable,()=>m.value)}}});const dragType={MIN:0,RANGE:1,MAX:2};var QRange=createComponent({name:"QRange",props:{...useSliderProps,modelValue:{type:Object,default:()=>({min:null,max:null}),validator:e=>"min"in e&&"max"in e},dragRange:Boolean,dragOnlyRange:Boolean,leftLabelColor:String,leftLabelTextColor:String,rightLabelColor:String,rightLabelTextColor:String,leftLabelValue:[String,Number],rightLabelValue:[String,Number],leftThumbColor:String,rightThumbColor:String},emits:useSliderEmits,setup(e,{emit:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),{state:n,methods:a}=useSlider({updateValue:k,updatePosition:q,getDragging:_,formAttrs:vue.computed(()=>({type:"hidden",name:e.name,value:`${e.modelValue.min}|${e.modelValue.max}`}))}),l=vue.ref(null),r=vue.ref(0),i=vue.ref(0),u=vue.ref({min:0,max:0});function s(){u.value.min=null===e.modelValue.min?n.innerMin.value:between(e.modelValue.min,n.innerMin.value,n.innerMax.value),u.value.max=null===e.modelValue.max?n.innerMax.value:between(e.modelValue.max,n.innerMin.value,n.innerMax.value)}vue.watch(()=>`${e.modelValue.min}|${e.modelValue.max}|${n.innerMin.value}|${n.innerMax.value}`,s),s();const c=vue.computed(()=>a.convertModelToRatio(u.value.min)),d=vue.computed(()=>a.convertModelToRatio(u.value.max)),v=vue.computed(()=>!0===n.active.value?r.value:c.value),p=vue.computed(()=>!0===n.active.value?i.value:d.value),m=vue.computed(()=>{const t={[n.positionProp.value]:`${100*v.value}%`,[n.sizeProp.value]:`${100*(p.value-v.value)}%`};return void 0!==e.selectionImg&&(t.backgroundImage=`url(${e.selectionImg}) !important`),t}),f=vue.computed(()=>{if(!0!==n.editable.value)return{};if(!0===o.platform.is.mobile)return{onClick:a.onMobileClick};const t={onMousedown:a.onActivate};return!0!==e.dragRange&&!0!==e.dragOnlyRange||Object.assign(t,{onFocus:()=>{n.focus.value="both"},onBlur:a.onBlur,onKeydown:T,onKeyup:a.onKeyup}),t});function h(t){return!0!==o.platform.is.mobile&&!0===n.editable.value&&!0!==e.dragOnlyRange?{onFocus:()=>{n.focus.value=t},onBlur:a.onBlur,onKeydown:T,onKeyup:a.onKeyup}:{}}const g=vue.computed(()=>!0!==e.dragOnlyRange?n.tabindex.value:null),b=vue.computed(()=>!0===o.platform.is.mobile||!e.dragRange&&!0!==e.dragOnlyRange?null:n.tabindex.value),y=vue.ref(null),S=vue.computed(()=>h("min")),x=a.getThumbRenderFn({focusValue:"min",getNodeData:()=>({ref:y,key:"tmin",...S.value,tabindex:g.value}),ratio:v,label:vue.computed(()=>void 0!==e.leftLabelValue?e.leftLabelValue:u.value.min),thumbColor:vue.computed(()=>e.leftThumbColor||e.thumbColor||e.color),labelColor:vue.computed(()=>e.leftLabelColor||e.labelColor),labelTextColor:vue.computed(()=>e.leftLabelTextColor||e.labelTextColor)}),w=vue.computed(()=>h("max")),C=a.getThumbRenderFn({focusValue:"max",getNodeData:()=>({...w.value,key:"tmax",tabindex:g.value}),ratio:p,label:vue.computed(()=>void 0!==e.rightLabelValue?e.rightLabelValue:u.value.max),thumbColor:vue.computed(()=>e.rightThumbColor||e.thumbColor||e.color),labelColor:vue.computed(()=>e.rightLabelColor||e.labelColor),labelTextColor:vue.computed(()=>e.rightLabelTextColor||e.labelTextColor)});function k(o){u.value.min===e.modelValue.min&&u.value.max===e.modelValue.max||t("update:modelValue",{...u.value}),!0===o&&t("change",{...u.value})}function _(t){const{left:o,top:n,width:r,height:i}=l.value.getBoundingClientRect(),s=!0===e.dragOnlyRange?0:!0===e.vertical?y.value.offsetHeight/(2*i):y.value.offsetWidth/(2*r),v={left:o,top:n,width:r,height:i,valueMin:u.value.min,valueMax:u.value.max,ratioMin:c.value,ratioMax:d.value},p=a.getDraggingRatio(t,v);return!0!==e.dragOnlyRange&&p<v.ratioMin+s?v.type=dragType.MIN:!0===e.dragOnlyRange||p<v.ratioMax-s?!0===e.dragRange||!0===e.dragOnlyRange?(v.type=dragType.RANGE,Object.assign(v,{offsetRatio:p,offsetModel:a.convertRatioToModel(p),rangeValue:v.valueMax-v.valueMin,rangeRatio:v.ratioMax-v.ratioMin})):v.type=v.ratioMax-p<p-v.ratioMin?dragType.MAX:dragType.MIN:v.type=dragType.MAX,v}function q(t,o=n.dragging.value){let l;const s=a.getDraggingRatio(t,o),c=a.convertRatioToModel(s);switch(o.type){case dragType.MIN:s<=o.ratioMax?(l={minR:s,maxR:o.ratioMax,min:c,max:o.valueMax},n.focus.value="min"):(l={minR:o.ratioMax,maxR:s,min:o.valueMax,max:c},n.focus.value="max");break;case dragType.MAX:s>=o.ratioMin?(l={minR:o.ratioMin,maxR:s,min:o.valueMin,max:c},n.focus.value="max"):(l={minR:s,maxR:o.ratioMin,min:c,max:o.valueMin},n.focus.value="min");break;case dragType.RANGE:const t=s-o.offsetRatio,a=between(o.ratioMin+t,0,1-o.rangeRatio),r=c-o.offsetModel,i=between(o.valueMin+r,e.min,e.max-o.rangeValue);l={minR:a,maxR:a+o.rangeRatio,min:parseFloat(i.toFixed(n.decimals.value)),max:parseFloat((i+o.rangeValue).toFixed(n.decimals.value))},n.focus.value="both";break}u.value=null===u.value.min||null===u.value.max?{min:l.min||e.min,max:l.max||e.max}:{min:l.min,max:l.max},!0!==e.snap||0===e.step?(r.value=l.minR,i.value=l.maxR):(r.value=a.convertModelToRatio(u.value.min),i.value=a.convertModelToRatio(u.value.max))}function T(t){if(!keyCodes$2.includes(t.keyCode))return;stopAndPrevent(t);const o=([34,33].includes(t.keyCode)?10:1)*n.step.value,a=([34,37,40].includes(t.keyCode)?-1:1)*(!0===n.isReversed.value?-1:1)*(!0===e.vertical?-1:1)*o;if("both"===n.focus.value){const e=u.value.max-u.value.min,t=between(parseFloat((u.value.min+a).toFixed(n.decimals.value)),n.innerMin.value,n.innerMax.value-e);u.value={min:t,max:parseFloat((t+e).toFixed(n.decimals.value))}}else{if(!1===n.focus.value)return;{const e=n.focus.value;u.value={...u.value,[e]:between(parseFloat((u.value[e]+a).toFixed(n.decimals.value)),"min"===e?n.innerMin.value:u.value.min,"max"===e?n.innerMax.value:u.value.max)}}}k()}return()=>{const t=a.getContent(m,b,f,e=>{e.push(x(),C())});return vue.h("div",{ref:l,class:"q-range "+n.classes.value+(null===e.modelValue.min||null===e.modelValue.max?" q-slider--no-value":""),...n.attributes.value,"aria-valuenow":e.modelValue.min+"|"+e.modelValue.max},t)}}}),QRating=createComponent({name:"QRating",props:{...useSizeProps,...useFormProps,modelValue:{type:Number,required:!0},max:{type:[String,Number],default:5},icon:[String,Array],iconHalf:[String,Array],iconSelected:[String,Array],iconAriaLabel:[String,Array],color:[String,Array],colorHalf:[String,Array],colorSelected:[String,Array],noReset:Boolean,noDimming:Boolean,readonly:Boolean,disable:Boolean},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=useSize(e),l=useFormAttrs(e),r=useFormInject(l),i=vue.ref(0);let u={};const s=vue.computed(()=>!0!==e.readonly&&!0!==e.disable),c=vue.computed(()=>"q-rating row inline items-center"+` q-rating--${!0===s.value?"":"non-"}editable`+(!0===e.noDimming?" q-rating--no-dimming":"")+(!0===e.disable?" disabled":"")+(void 0!==e.color&&!1===Array.isArray(e.color)?` text-${e.color}`:"")),d=vue.computed(()=>{const t=!0===Array.isArray(e.icon)?e.icon.length:0,o=!0===Array.isArray(e.iconSelected)?e.iconSelected.length:0,n=!0===Array.isArray(e.iconHalf)?e.iconHalf.length:0,a=!0===Array.isArray(e.color)?e.color.length:0,l=!0===Array.isArray(e.colorSelected)?e.colorSelected.length:0,r=!0===Array.isArray(e.colorHalf)?e.colorHalf.length:0;return{iconLen:t,icon:t>0?e.icon[t-1]:e.icon,selIconLen:o,selIcon:o>0?e.iconSelected[o-1]:e.iconSelected,halfIconLen:n,halfIcon:n>0?e.iconHalf[o-1]:e.iconHalf,colorLen:a,color:a>0?e.color[a-1]:e.color,selColorLen:l,selColor:l>0?e.colorSelected[l-1]:e.colorSelected,halfColorLen:r,halfColor:r>0?e.colorHalf[r-1]:e.colorHalf}}),v=vue.computed(()=>{if("string"===typeof e.iconAriaLabel){const t=0!==e.iconAriaLabel.length?`${e.iconAriaLabel} `:"";return e=>`${t}${e}`}if(!0===Array.isArray(e.iconAriaLabel)){const t=e.iconAriaLabel.length;if(t>0)return o=>e.iconAriaLabel[Math.min(o,t)-1]}return(e,t)=>`${t} ${e}`}),p=vue.computed(()=>{const t=[],o=d.value,a=Math.ceil(e.modelValue),l=!0===s.value?0:null,r=void 0===e.iconHalf||a===e.modelValue?-1:a;for(let u=1;u<=e.max;u++){const s=0===i.value&&e.modelValue>=u||i.value>0&&i.value>=u,c=r===u&&i.value<u,d=i.value>0&&(!0===c?a:e.modelValue)>=u&&i.value<u,p=!0===c?u<=o.halfColorLen?e.colorHalf[u-1]:o.halfColor:void 0!==o.selColor&&!0===s?u<=o.selColorLen?e.colorSelected[u-1]:o.selColor:u<=o.colorLen?e.color[u-1]:o.color,m=(!0===c?u<=o.halfIconLen?e.iconHalf[u-1]:o.halfIcon:void 0===o.selIcon||!0!==s&&!0!==d?u<=o.iconLen?e.icon[u-1]:o.icon:u<=o.selIconLen?e.iconSelected[u-1]:o.selIcon)||n.iconSet.rating.icon;t.push({name:(!0===c?u<=o.halfIconLen?e.iconHalf[u-1]:o.halfIcon:void 0===o.selIcon||!0!==s&&!0!==d?u<=o.iconLen?e.icon[u-1]:o.icon:u<=o.selIconLen?e.iconSelected[u-1]:o.selIcon)||n.iconSet.rating.icon,attrs:{tabindex:l,role:"radio","aria-checked":e.modelValue===u?"true":"false","aria-label":v.value(u,m)},iconClass:"q-rating__icon"+(!0===s||!0===c?" q-rating__icon--active":"")+(!0===d?" q-rating__icon--exselected":"")+(i.value===u?" q-rating__icon--hovered":"")+(void 0!==p?` text-${p}`:"")})}return t}),m=vue.computed(()=>{const t={role:"radiogroup"};return!0===e.disable&&(t["aria-disabled"]="true"),!0===e.readonly&&(t["aria-readonly"]="true"),t});function f(t){if(!0===s.value){const n=between(parseInt(t,10),1,parseInt(e.max,10)),a=!0!==e.noReset&&e.modelValue===n?0:n;a!==e.modelValue&&o("update:modelValue",a),i.value=0}}function h(e){!0===s.value&&(i.value=e)}function g(e,t){switch(e.keyCode){case 13:case 32:return f(t),stopAndPrevent(e);case 37:case 40:return u[`rt${t-1}`]&&u[`rt${t-1}`].focus(),stopAndPrevent(e);case 39:case 38:return u[`rt${t+1}`]&&u[`rt${t+1}`].focus(),stopAndPrevent(e)}}function b(){i.value=0}return vue.onBeforeUpdate(()=>{u={}}),()=>{const o=[];return p.value.forEach(({iconClass:e,name:n,attrs:a},l)=>{const r=l+1;o.push(vue.h("div",{key:r,ref:e=>{u[`rt${r}`]=e},class:"q-rating__icon-container flex flex-center",...a,onClick(){f(r)},onMouseover(){h(r)},onMouseout:b,onFocus(){h(r)},onBlur:b,onKeyup(e){g(e,r)}},hMergeSlot(t[`tip-${r}`],[vue.h(QIcon,{class:e,name:n})])))}),void 0!==e.name&&!0!==e.disable&&r(o,"push"),vue.h("div",{class:c.value,style:a.value,...m.value},o)}}}),QResponsive=createComponent({name:"QResponsive",props:useRatioProps,setup(e,{slots:t}){const o=useRatio(e);return()=>vue.h("div",{class:"q-responsive"},[vue.h("div",{class:"q-responsive__filler overflow-hidden"},[vue.h("div",{style:o.value})]),vue.h("div",{class:"q-responsive__content absolute-full fit"},hSlot(t.default))])}});const axisList=["vertical","horizontal"],dirProps={vertical:{offset:"offsetY",scroll:"scrollTop",dir:"down",dist:"y"},horizontal:{offset:"offsetX",scroll:"scrollLeft",dir:"right",dist:"x"}},panOpts={prevent:!0,mouse:!0,mouseAllDir:!0},getMinThumbSize=e=>e>=250?50:Math.ceil(e/5);var QScrollArea=createComponent({name:"QScrollArea",props:{...useDarkProps,thumbStyle:Object,verticalThumbStyle:Object,horizontalThumbStyle:Object,barStyle:[Array,String,Object],verticalBarStyle:[Array,String,Object],horizontalBarStyle:[Array,String,Object],contentStyle:[Array,String,Object],contentActiveStyle:[Array,String,Object],delay:{type:[String,Number],default:1e3},visible:{type:Boolean,default:null},tabindex:[String,Number],onScroll:Function},setup(e,{slots:t,emit:o}){const n=vue.ref(!1),a=vue.ref(!1),l=vue.ref(!1),r={vertical:vue.ref(0),horizontal:vue.ref(0)},i={vertical:{ref:vue.ref(null),position:vue.ref(0),size:vue.ref(0)},horizontal:{ref:vue.ref(null),position:vue.ref(0),size:vue.ref(0)}},{proxy:u}=vue.getCurrentInstance(),s=useDark(e,u.$q);let c,d=null;const v=vue.ref(null),p=vue.computed(()=>"q-scrollarea"+(!0===s.value?" q-scrollarea--dark":""));i.vertical.percentage=vue.computed(()=>{const e=i.vertical.size.value-r.vertical.value;if(e<=0)return 0;const t=between(i.vertical.position.value/e,0,1);return Math.round(1e4*t)/1e4}),i.vertical.thumbHidden=vue.computed(()=>!0!==(null===e.visible?l.value:e.visible)&&!1===n.value&&!1===a.value||i.vertical.size.value<=r.vertical.value+1),i.vertical.thumbStart=vue.computed(()=>i.vertical.percentage.value*(r.vertical.value-i.vertical.thumbSize.value)),i.vertical.thumbSize=vue.computed(()=>Math.round(between(r.vertical.value*r.vertical.value/i.vertical.size.value,getMinThumbSize(r.vertical.value),r.vertical.value))),i.vertical.style=vue.computed(()=>{return{...e.thumbStyle,...e.verticalThumbStyle,top:`${i.vertical.thumbStart.value}px`,height:`${i.vertical.thumbSize.value}px`}}),i.vertical.thumbClass=vue.computed(()=>"q-scrollarea__thumb q-scrollarea__thumb--v absolute-right"+(!0===i.vertical.thumbHidden.value?" q-scrollarea__thumb--invisible":"")),i.vertical.barClass=vue.computed(()=>"q-scrollarea__bar q-scrollarea__bar--v absolute-right"+(!0===i.vertical.thumbHidden.value?" q-scrollarea__bar--invisible":"")),i.horizontal.percentage=vue.computed(()=>{const e=i.horizontal.size.value-r.horizontal.value;if(e<=0)return 0;const t=between(Math.abs(i.horizontal.position.value)/e,0,1);return Math.round(1e4*t)/1e4}),i.horizontal.thumbHidden=vue.computed(()=>!0!==(null===e.visible?l.value:e.visible)&&!1===n.value&&!1===a.value||i.horizontal.size.value<=r.horizontal.value+1),i.horizontal.thumbStart=vue.computed(()=>i.horizontal.percentage.value*(r.horizontal.value-i.horizontal.thumbSize.value)),i.horizontal.thumbSize=vue.computed(()=>Math.round(between(r.horizontal.value*r.horizontal.value/i.horizontal.size.value,getMinThumbSize(r.horizontal.value),r.horizontal.value))),i.horizontal.style=vue.computed(()=>{return{...e.thumbStyle,...e.horizontalThumbStyle,[!0===u.$q.lang.rtl?"right":"left"]:`${i.horizontal.thumbStart.value}px`,width:`${i.horizontal.thumbSize.value}px`}}),i.horizontal.thumbClass=vue.computed(()=>"q-scrollarea__thumb q-scrollarea__thumb--h absolute-bottom"+(!0===i.horizontal.thumbHidden.value?" q-scrollarea__thumb--invisible":"")),i.horizontal.barClass=vue.computed(()=>"q-scrollarea__bar q-scrollarea__bar--h absolute-bottom"+(!0===i.horizontal.thumbHidden.value?" q-scrollarea__bar--invisible":""));const m=vue.computed(()=>!0===i.vertical.thumbHidden.value&&!0===i.horizontal.thumbHidden.value?e.contentStyle:e.contentActiveStyle),f=[[TouchPan,e=>{C(e,"vertical")},void 0,{vertical:!0,...panOpts}]],h=[[TouchPan,e=>{C(e,"horizontal")},void 0,{horizontal:!0,...panOpts}]];function g(){const e={};return axisList.forEach(t=>{const o=i[t];e[t+"Position"]=o.position.value,e[t+"Percentage"]=o.percentage.value,e[t+"Size"]=o.size.value,e[t+"ContainerSize"]=r[t].value}),e}const b=debounce(()=>{const e=g();e.ref=u,o("scroll",e)},0);function y(e,t,o){if(!1===axisList.includes(e))return void console.error("[QScrollArea]: wrong first param of setScrollPosition (vertical/horizontal)");const n="vertical"===e?setVerticalScrollPosition:setHorizontalScrollPosition;n(v.value,t,o)}function S({height:e,width:t}){let o=!1;r.vertical.value!==e&&(r.vertical.value=e,o=!0),r.horizontal.value!==t&&(r.horizontal.value=t,o=!0),!0===o&&T()}function x({position:e}){let t=!1;i.vertical.position.value!==e.top&&(i.vertical.position.value=e.top,t=!0),i.horizontal.position.value!==e.left&&(i.horizontal.position.value=e.left,t=!0),!0===t&&T()}function w({height:e,width:t}){i.horizontal.size.value!==t&&(i.horizontal.size.value=t,T()),i.vertical.size.value!==e&&(i.vertical.size.value=e,T())}function C(e,t){const o=i[t];if(!0===e.isFirst){if(!0===o.thumbHidden.value)return;c=o.position.value,a.value=!0}else if(!0!==a.value)return;!0===e.isFinal&&(a.value=!1);const n=dirProps[t],l=r[t].value,u=(o.size.value-l)/(l-o.thumbSize.value),s=e.distance[n.dist],d=c+(e.direction===n.dir?1:-1)*s*u;P(d,t)}function k(e,t){const o=i[t];if(!0!==o.thumbHidden.value){const n=e[dirProps[t].offset];if(n<o.thumbStart.value||n>o.thumbStart.value+o.thumbSize.value){const e=n-o.thumbSize.value/2;P(e/r[t].value*o.size.value,t)}null!==o.ref.value&&o.ref.value.dispatchEvent(new MouseEvent(e.type,e))}}function _(e){k(e,"vertical")}function q(e){k(e,"horizontal")}function T(){n.value=!0,null!==d&&clearTimeout(d),d=setTimeout(()=>{d=null,n.value=!1},e.delay),void 0!==e.onScroll&&b()}function P(e,t){v.value[dirProps[t].scroll]=e}let M=null;function $(){null!==M&&clearTimeout(M),M=setTimeout(()=>{M=null,l.value=!0},u.$q.platform.is.ios?50:0)}function Q(){null!==M&&(clearTimeout(M),M=null),l.value=!1}let B=null;return vue.watch(()=>u.$q.lang.rtl,e=>{null!==v.value&&setHorizontalScrollPosition(v.value,Math.abs(i.horizontal.position.value)*(!0===e?-1:1))}),vue.onDeactivated(()=>{B={top:i.vertical.position.value,left:i.horizontal.position.value}}),vue.onActivated(()=>{if(null===B)return;const e=v.value;null!==e&&(setHorizontalScrollPosition(e,B.left),setVerticalScrollPosition(e,B.top))}),vue.onBeforeUnmount(b.cancel),Object.assign(u,{getScrollTarget:()=>v.value,getScroll:g,getScrollPosition:()=>({top:i.vertical.position.value,left:i.horizontal.position.value}),getScrollPercentage:()=>({top:i.vertical.percentage.value,left:i.horizontal.percentage.value}),setScrollPosition:y,setScrollPercentage(e,t,o){y(e,t*(i[e].size.value-r[e].value)*("horizontal"===e&&!0===u.$q.lang.rtl?-1:1),o)}}),()=>{return vue.h("div",{class:p.value,onMouseenter:$,onMouseleave:Q},[vue.h("div",{ref:v,class:"q-scrollarea__container scroll relative-position fit hide-scrollbar",tabindex:void 0!==e.tabindex?e.tabindex:void 0},[vue.h("div",{class:"q-scrollarea__content absolute",style:m.value},hMergeSlot(t.default,[vue.h(QResizeObserver,{debounce:0,onResize:w})])),vue.h(QScrollObserver,{axis:"both",onScroll:x})]),vue.h(QResizeObserver,{debounce:0,onResize:S}),vue.h("div",{class:i.vertical.barClass.value,style:[e.barStyle,e.verticalBarStyle],"aria-hidden":"true",onMousedown:_}),vue.h("div",{class:i.horizontal.barClass.value,style:[e.barStyle,e.horizontalBarStyle],"aria-hidden":"true",onMousedown:q}),vue.withDirectives(vue.h("div",{ref:i.vertical.ref,class:i.vertical.thumbClass.value,style:i.vertical.style.value,"aria-hidden":"true"}),f),vue.withDirectives(vue.h("div",{ref:i.horizontal.ref,class:i.horizontal.thumbClass.value,style:i.horizontal.style.value,"aria-hidden":"true"}),h)])}}});const aggBucketSize=1e3,scrollToEdges=["start","center","end","start-force","center-force","end-force"],filterProto=Array.prototype.filter;function sumFn(e,t){return e+t}function getScrollDetails(e,t,o,n,a,l,r,i){const u=e===window?document.scrollingElement||document.documentElement:e,s=!0===a?"offsetWidth":"offsetHeight",c={scrollStart:0,scrollViewSize:-r-i,scrollMaxSize:0,offsetStart:-r,offsetEnd:-i};if(!0===a?(e===window?(c.scrollStart=window.pageXOffset||window.scrollX||document.body.scrollLeft||0,c.scrollViewSize+=document.documentElement.clientWidth):(c.scrollStart=u.scrollLeft,c.scrollViewSize+=u.clientWidth),c.scrollMaxSize=u.scrollWidth,!0===l&&(c.scrollStart=0-c.scrollStart)):(e===window?(c.scrollStart=window.pageYOffset||window.scrollY||document.body.scrollTop||0,c.scrollViewSize+=document.documentElement.clientHeight):(c.scrollStart=u.scrollTop,c.scrollViewSize+=u.clientHeight),c.scrollMaxSize=u.scrollHeight),null!==o)for(let d=o.previousElementSibling;null!==d;d=d.previousElementSibling)!1===d.classList.contains("q-virtual-scroll--skip")&&(c.offsetStart+=d[s]);if(null!==n)for(let d=n.nextElementSibling;null!==d;d=d.nextElementSibling)!1===d.classList.contains("q-virtual-scroll--skip")&&(c.offsetEnd+=d[s]);if(t!==e){const o=u.getBoundingClientRect(),n=t.getBoundingClientRect();!0===a?(c.offsetStart+=n.left-o.left,c.offsetEnd-=n.width):(c.offsetStart+=n.top-o.top,c.offsetEnd-=n.height),e!==window&&(c.offsetStart+=c.scrollStart),c.offsetEnd+=c.scrollMaxSize-c.offsetStart}return c}function setScroll(e,t,o,n){"end"===t&&(t=(e===window?document.body:e)[!0===o?"scrollWidth":"scrollHeight"]),e===window?!0===o?(!0===n&&(t=0-t),window.scrollTo(t,window.pageYOffset||window.scrollY||document.body.scrollTop||0)):window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,t):!0===o?(!0===n&&(t=0-t),e.scrollLeft=t):e.scrollTop=t}function sumSize(e,t,o,n){if(o>=n)return 0;const a=t.length,l=Math.floor(o/aggBucketSize),r=Math.floor((n-1)/aggBucketSize)+1;let i=e.slice(l,r).reduce(sumFn,0);return o%aggBucketSize!==0&&(i-=t.slice(l*aggBucketSize,o).reduce(sumFn,0)),n%aggBucketSize!==0&&n!==a&&(i-=t.slice(n,r*aggBucketSize).reduce(sumFn,0)),i}const commonVirtScrollProps={virtualScrollSliceSize:{type:[Number,String],default:null},virtualScrollSliceRatioBefore:{type:[Number,String],default:1},virtualScrollSliceRatioAfter:{type:[Number,String],default:1},virtualScrollItemSize:{type:[Number,String],default:24},virtualScrollStickySizeStart:{type:[Number,String],default:0},virtualScrollStickySizeEnd:{type:[Number,String],default:0},tableColspan:[Number,String]},commonVirtPropsList=Object.keys(commonVirtScrollProps),useVirtualScrollProps={virtualScrollHorizontal:Boolean,onVirtualScroll:Function,...commonVirtScrollProps};function useVirtualScroll({virtualScrollLength:e,getVirtualScrollTarget:t,getVirtualScrollEl:o,virtualScrollItemSizeComputed:n}){const a=vue.getCurrentInstance(),{props:l,emit:r,proxy:i}=a,{$q:u}=i;let s,c,d,v,p=[];const m=vue.ref(0),f=vue.ref(0),h=vue.ref({}),g=vue.ref(null),b=vue.ref(null),y=vue.ref(null),S=vue.ref({from:0,to:0}),x=vue.computed(()=>void 0!==l.tableColspan?l.tableColspan:100);void 0===n&&(n=vue.computed(()=>l.virtualScrollItemSize));const w=vue.computed(()=>n.value+";"+l.virtualScrollHorizontal),C=vue.computed(()=>w.value+";"+l.virtualScrollSliceRatioBefore+";"+l.virtualScrollSliceRatioAfter);function k(){Q(c,!0)}function _(e){Q(void 0===e?c:e)}function q(n,a){const r=t();if(void 0===r||null===r||8===r.nodeType)return;const i=getScrollDetails(r,o(),g.value,b.value,l.virtualScrollHorizontal,u.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd);d!==i.scrollViewSize&&B(i.scrollViewSize),P(r,i,Math.min(e.value-1,Math.max(0,parseInt(n,10)||0)),0,scrollToEdges.indexOf(a)>-1?a:c>-1&&n>c?"end":"start")}function T(){const n=t();if(void 0===n||null===n||8===n.nodeType)return;const a=getScrollDetails(n,o(),g.value,b.value,l.virtualScrollHorizontal,u.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd),r=e.value-1,i=a.scrollMaxSize-a.offsetStart-a.offsetEnd-f.value;if(s===a.scrollStart)return;if(a.scrollMaxSize<=0)return void P(n,a,0,0);d!==a.scrollViewSize&&B(a.scrollViewSize),M(S.value.from);const c=Math.floor(a.scrollMaxSize-Math.max(a.scrollViewSize,a.offsetEnd)-Math.min(v[r],a.scrollViewSize/2));if(c>0&&Math.ceil(a.scrollStart)>=c)return void P(n,a,r,a.scrollMaxSize-a.offsetEnd-p.reduce(sumFn,0));let h=0,y=a.scrollStart-a.offsetStart,x=y;if(y<=i&&y+a.scrollViewSize>=m.value)y-=m.value,h=S.value.from,x=y;else for(let e=0;y>=p[e]&&h<r;e++)y-=p[e],h+=aggBucketSize;while(y>0&&h<r)y-=v[h],y>-a.scrollViewSize?(h++,x=y):x=v[h]+y;P(n,a,h,x)}function P(t,o,n,a,r){const i="string"===typeof r&&r.indexOf("-force")>-1,c=!0===i?r.replace("-force",""):r,d=void 0!==c?c:"start";let g=Math.max(0,n-h.value[d]),b=g+h.value.total;b>e.value&&(b=e.value,g=Math.max(0,b-h.value.total)),s=o.scrollStart;const x=g!==S.value.from||b!==S.value.to;if(!1===x&&void 0===c)return void A(n);const{activeElement:w}=document,C=y.value;!0===x&&null!==C&&C!==w&&!0===C.contains(w)&&(C.addEventListener("focusout",$),setTimeout(()=>{null!==C&&C.removeEventListener("focusout",$)}));const k=void 0!==c?v.slice(g,n).reduce(sumFn,0):0;if(!0===x){const t=b>=S.value.from&&g<=S.value.to?S.value.to:b;S.value={from:g,to:t},m.value=sumSize(p,v,0,g),f.value=sumSize(p,v,b,e.value),requestAnimationFrame(()=>{S.value.to!==b&&s===o.scrollStart&&(S.value={from:S.value.from,to:b},f.value=sumSize(p,v,b,e.value))})}requestAnimationFrame(()=>{if(s!==o.scrollStart)return;!0===x&&M(g);const e=v.slice(g,n).reduce(sumFn,0),r=e+o.offsetStart+m.value,d=r+v[n];let p=r+a;if(void 0!==c){const t=e-k,a=o.scrollStart+t;p=!0!==i&&a<r&&d<a+o.scrollViewSize?a:"end"===c?d-o.scrollViewSize:r-("start"===c?0:Math.round((o.scrollViewSize-v[n])/2))}s=p,setScroll(t,p,l.virtualScrollHorizontal,u.lang.rtl),A(n)})}function M(e){const t=y.value;if(t){const o=filterProto.call(t.children,e=>e.classList&&!1===e.classList.contains("q-virtual-scroll--skip")),n=o.length,a=!0===l.virtualScrollHorizontal?e=>e.getBoundingClientRect().width:e=>e.offsetHeight;let r,i,u=e;for(let e=0;e<n;){r=a(o[e]),e++;while(e<n&&!0===o[e].classList.contains("q-virtual-scroll--with-prev"))r+=a(o[e]),e++;i=r-v[u],0!==i&&(v[u]+=i,p[Math.floor(u/aggBucketSize)]+=i),u++}}}function $(){null!==y.value&&void 0!==y.value&&y.value.focus()}function Q(t,o){const a=1*n.value;!0!==o&&!1!==Array.isArray(v)||(v=[]);const l=v.length;v.length=e.value;for(let n=e.value-1;n>=l;n--)v[n]=a;const r=Math.floor((e.value-1)/aggBucketSize);p=[];for(let n=0;n<=r;n++){let t=0;const o=Math.min((n+1)*aggBucketSize,e.value);for(let e=n*aggBucketSize;e<o;e++)t+=v[e];p.push(t)}c=-1,s=void 0,m.value=sumSize(p,v,0,S.value.from),f.value=sumSize(p,v,S.value.to,e.value),t>=0?(M(S.value.from),vue.nextTick(()=>{q(t)})):F()}function B(e){if(void 0===e&&"undefined"!==typeof window){const n=t();void 0!==n&&null!==n&&8!==n.nodeType&&(e=getScrollDetails(n,o(),g.value,b.value,l.virtualScrollHorizontal,u.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd).scrollViewSize)}d=e;const a=parseFloat(l.virtualScrollSliceRatioBefore)||0,r=parseFloat(l.virtualScrollSliceRatioAfter)||0,i=1+a+r,s=void 0===e||e<=0?1:Math.ceil(e/n.value),c=Math.max(1,s,Math.ceil((l.virtualScrollSliceSize>0?l.virtualScrollSliceSize:10)/i));h.value={total:Math.ceil(c*i),start:Math.ceil(c*a),center:Math.ceil(c*(.5+a)),end:Math.ceil(c*(1+a)),view:s}}function R(e,t){const o=!0===l.virtualScrollHorizontal?"width":"height",a={["--q-virtual-scroll-item-"+o]:n.value+"px"};return["tbody"===e?vue.h(e,{class:"q-virtual-scroll__padding",key:"before",ref:g},[vue.h("tr",[vue.h("td",{style:{[o]:`${m.value}px`,...a},colspan:x.value})])]):vue.h(e,{class:"q-virtual-scroll__padding",key:"before",ref:g,style:{[o]:`${m.value}px`,...a}}),vue.h(e,{class:"q-virtual-scroll__content",key:"content",ref:y,tabindex:-1},t.flat()),"tbody"===e?vue.h(e,{class:"q-virtual-scroll__padding",key:"after",ref:b},[vue.h("tr",[vue.h("td",{style:{[o]:`${f.value}px`,...a},colspan:x.value})])]):vue.h(e,{class:"q-virtual-scroll__padding",key:"after",ref:b,style:{[o]:`${f.value}px`,...a}})]}function A(e){c!==e&&(void 0!==l.onVirtualScroll&&r("virtualScroll",{index:e,from:S.value.from,to:S.value.to-1,direction:e<c?"decrease":"increase",ref:i}),c=e)}vue.watch(C,()=>{B()}),vue.watch(w,k),B();const F=debounce(T,!0===u.platform.is.ios?120:35);vue.onBeforeMount(()=>{B()});let E=!1;return vue.onDeactivated(()=>{E=!0}),vue.onActivated(()=>{if(!0!==E)return;const e=t();void 0!==s&&void 0!==e&&null!==e&&8!==e.nodeType?setScroll(e,s,l.virtualScrollHorizontal,u.lang.rtl):q(c)}),Object.assign(i,{scrollTo:q,reset:k,refresh:_}),{virtualScrollSliceRange:S,virtualScrollSliceSizeComputed:h,setVirtualScrollSize:B,onVirtualScrollEvt:F,localResetVirtualScroll:Q,padVirtualScroll:R,scrollTo:q,reset:k,refresh:_}}const validateNewValueMode=e=>["add","add-unique","toggle"].includes(e),reEscapeList=".*+?^${}()|[]\\",fieldPropsList=Object.keys(useFieldProps);var QSelect=createComponent({name:"QSelect",inheritAttrs:!1,props:{...useVirtualScrollProps,...useFormProps,...useFieldProps,modelValue:{required:!0},multiple:Boolean,displayValue:[String,Number],displayValueHtml:Boolean,dropdownIcon:String,options:{type:Array,default:()=>[]},optionValue:[Function,String],optionLabel:[Function,String],optionDisable:[Function,String],hideSelected:Boolean,hideDropdownIcon:Boolean,fillInput:Boolean,maxValues:[Number,String],optionsDense:Boolean,optionsDark:{type:Boolean,default:null},optionsSelectedClass:String,optionsHtml:Boolean,optionsCover:Boolean,menuShrink:Boolean,menuAnchor:String,menuSelf:String,menuOffset:Array,popupContentClass:String,popupContentStyle:[String,Array,Object],useInput:Boolean,useChips:Boolean,newValueMode:{type:String,validator:validateNewValueMode},mapOptions:Boolean,emitValue:Boolean,inputDebounce:{type:[Number,String],default:500},inputClass:[Array,String,Object],inputStyle:[Array,String,Object],tabindex:{type:[String,Number],default:0},autocomplete:String,transitionShow:String,transitionHide:String,transitionDuration:[String,Number],behavior:{type:String,validator:e=>["default","menu","dialog"].includes(e),default:"default"},virtualScrollItemSize:{type:[Number,String],default:void 0},onNewValue:Function,onFilter:Function},emits:[...useFieldEmits,"add","remove","inputValue","newValue","keyup","keypress","keydown","filterAbort"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=vue.ref(!1),r=vue.ref(!1),i=vue.ref(-1),u=vue.ref(""),s=vue.ref(!1),c=vue.ref(!1);let d,v,p,m,f,h,g,b=null,y=null,S=null;const x=vue.ref(null),w=vue.ref(null),C=vue.ref(null),k=vue.ref(null),_=vue.ref(null),q=useFormInputNameAttr(e),T=useKeyComposition(Pe),P=vue.computed(()=>Array.isArray(e.options)?e.options.length:0),M=vue.computed(()=>void 0===e.virtualScrollItemSize?!0===e.optionsDense?24:48:e.virtualScrollItemSize),{virtualScrollSliceRange:$,virtualScrollSliceSizeComputed:Q,localResetVirtualScroll:B,padVirtualScroll:R,onVirtualScrollEvt:A,scrollTo:F,setVirtualScrollSize:E}=useVirtualScroll({virtualScrollLength:P,getVirtualScrollTarget:ke,getVirtualScrollEl:Ce,virtualScrollItemSizeComputed:M}),D=useFieldState(),I=vue.computed(()=>{const t=!0===e.mapOptions&&!0!==e.multiple,o=void 0===e.modelValue||null===e.modelValue&&!0!==t?[]:!0===e.multiple&&Array.isArray(e.modelValue)?e.modelValue:[e.modelValue];if(!0===e.mapOptions&&!0===Array.isArray(e.options)){const n=!0===e.mapOptions&&void 0!==d?d:[],a=o.map(e=>fe(e,n));return null===e.modelValue&&!0===t?a.filter(e=>null!==e):a}return o}),O=vue.computed(()=>{const t={};return fieldPropsList.forEach(o=>{const n=e[o];void 0!==n&&(t[o]=n)}),t}),z=vue.computed(()=>null===e.optionsDark?D.isDark.value:e.optionsDark),V=vue.computed(()=>fieldValueIsFilled(I.value)),L=vue.computed(()=>{let t="q-field__input q-placeholder col";return!0===e.hideSelected||0===I.value.length?[t,e.inputClass]:(t+=" q-field__input--padding",void 0===e.inputClass?t:[t,e.inputClass])}),H=vue.computed(()=>(!0===e.virtualScrollHorizontal?"q-virtual-scroll--horizontal":"")+(e.popupContentClass?" "+e.popupContentClass:"")),N=vue.computed(()=>0===P.value),j=vue.computed(()=>I.value.map(e=>ae.value(e)).join(", ")),K=vue.computed(()=>void 0!==e.displayValue?e.displayValue:j.value),U=vue.computed(()=>!0===e.optionsHtml?()=>!0:e=>void 0!==e&&null!==e&&!0===e.html),W=vue.computed(()=>!0===e.displayValueHtml||void 0===e.displayValue&&(!0===e.optionsHtml||I.value.some(U.value))),Y=vue.computed(()=>!0===D.focused.value?e.tabindex:-1),G=vue.computed(()=>{const t={tabindex:e.tabindex,role:"combobox","aria-label":e.label,"aria-readonly":!0===e.readonly?"true":"false","aria-autocomplete":!0===e.useInput?"list":"none","aria-expanded":!0===l.value?"true":"false","aria-controls":`${D.targetUid.value}_lb`};return i.value>=0&&(t["aria-activedescendant"]=`${D.targetUid.value}_${i.value}`),t}),X=vue.computed(()=>({id:`${D.targetUid.value}_lb`,role:"listbox","aria-multiselectable":!0===e.multiple?"true":"false"})),Z=vue.computed(()=>{return I.value.map((e,t)=>({index:t,opt:e,html:U.value(e),selected:!0,removeAtIndex:ce,toggleOption:ve,tabindex:Y.value}))}),J=vue.computed(()=>{if(0===P.value)return[];const{from:t,to:o}=$.value;return e.options.slice(t,o).map((o,n)=>{const r=!0===le.value(o),u=t+n,s={clickable:!0,active:!1,activeClass:oe.value,manualFocus:!0,focused:!1,disable:r,tabindex:-1,dense:e.optionsDense,dark:z.value,role:"option",id:`${D.targetUid.value}_${u}`,onClick:()=>{ve(o)}};return!0!==r&&(!0===ge(o)&&(s.active=!0),i.value===u&&(s.focused=!0),s["aria-selected"]=!0===s.active?"true":"false",!0===a.platform.is.desktop&&(s.onMousemove=(()=>{!0===l.value&&pe(u)}))),{index:u,opt:o,html:U.value(o),label:ae.value(o),selected:s.active,focused:s.focused,toggleOption:ve,setOptionIndex:pe,itemProps:s}})}),ee=vue.computed(()=>void 0!==e.dropdownIcon?e.dropdownIcon:a.iconSet.arrow.dropdown),te=vue.computed(()=>!1===e.optionsCover&&!0!==e.outlined&&!0!==e.standout&&!0!==e.borderless&&!0!==e.rounded),oe=vue.computed(()=>void 0!==e.optionsSelectedClass?e.optionsSelectedClass:void 0!==e.color?`text-${e.color}`:""),ne=vue.computed(()=>he(e.optionValue,"value")),ae=vue.computed(()=>he(e.optionLabel,"label")),le=vue.computed(()=>he(e.optionDisable,"disable")),re=vue.computed(()=>I.value.map(e=>ne.value(e))),ie=vue.computed(()=>{const e={onInput:Pe,onChange:T,onKeydown:we,onKeyup:Se,onKeypress:xe,onFocus:be,onClick(e){!0===v&&stop(e)}};return e.onCompositionstart=e.onCompositionupdate=e.onCompositionend=T,e});function ue(t){return!0===e.emitValue?ne.value(t):t}function se(t){if(t>-1&&t<I.value.length)if(!0===e.multiple){const n=e.modelValue.slice();o("remove",{index:t,value:n.splice(t,1)[0]}),o("update:modelValue",n)}else o("update:modelValue",null)}function ce(e){se(e),D.focus()}function de(t,n){const a=ue(t);if(!0!==e.multiple)return!0===e.fillInput&&$e(ae.value(t),!0,!0),void o("update:modelValue",a);if(0===I.value.length)return o("add",{index:0,value:a}),void o("update:modelValue",!0===e.multiple?[a]:a);if(!0===n&&!0===ge(t))return;if(void 0!==e.maxValues&&e.modelValue.length>=e.maxValues)return;const l=e.modelValue.slice();o("add",{index:l.length,value:a}),l.push(a),o("update:modelValue",l)}function ve(t,n){if(!0!==D.editable.value||void 0===t||!0===le.value(t))return;const a=ne.value(t);if(!0!==e.multiple)return!0!==n&&($e(!0===e.fillInput?ae.value(t):"",!0,!0),He()),null!==w.value&&w.value.focus(),void(0!==I.value.length&&!0===isDeepEqual(ne.value(I.value[0]),a)||o("update:modelValue",!0===e.emitValue?a:t));if((!0!==v||!0===s.value)&&D.focus(),be(),0===I.value.length){const n=!0===e.emitValue?a:t;return o("add",{index:0,value:n}),void o("update:modelValue",!0===e.multiple?[n]:n)}const l=e.modelValue.slice(),r=re.value.findIndex(e=>isDeepEqual(e,a));if(r>-1)o("remove",{index:r,value:l.splice(r,1)[0]});else{if(void 0!==e.maxValues&&l.length>=e.maxValues)return;const n=!0===e.emitValue?a:t;o("add",{index:l.length,value:n}),l.push(n)}o("update:modelValue",l)}function pe(e){if(!0!==a.platform.is.desktop)return;const t=e>-1&&e<P.value?e:-1;i.value!==t&&(i.value=t)}function me(t=1,o){if(!0===l.value){let n=i.value;do{n=normalizeToInterval(n+t,-1,P.value-1)}while(-1!==n&&n!==i.value&&!0===le.value(e.options[n]));i.value!==n&&(pe(n),F(n),!0!==o&&!0===e.useInput&&!0===e.fillInput&&Me(n>=0?ae.value(e.options[n]):m,!0))}}function fe(t,o){const n=e=>isDeepEqual(ne.value(e),t);return e.options.find(n)||o.find(n)||t}function he(e,t){const o=void 0!==e?e:t;return"function"===typeof o?o:e=>null!==e&&"object"===typeof e&&o in e?e[o]:e}function ge(e){const t=ne.value(e);return void 0!==re.value.find(e=>isDeepEqual(e,t))}function be(t){!0===e.useInput&&null!==w.value&&(void 0===t||w.value===t.target&&t.target.value===j.value)&&w.value.select()}function ye(e){!0===isKeyCode(e,27)&&!0===l.value&&(stop(e),He(),Ne()),o("keyup",e)}function Se(t){const{value:o}=t.target;if(void 0===t.keyCode)if(t.target.value="",null!==b&&(clearTimeout(b),b=null),null!==y&&(clearTimeout(y),y=null),Ne(),"string"===typeof o&&0!==o.length){const t=o.toLocaleLowerCase(),n=o=>{const n=e.options.find(e=>o.value(e).toLocaleLowerCase()===t);return void 0!==n&&(-1===I.value.indexOf(n)?ve(n):He(),!0)},a=e=>{!0!==n(ne)&&!0!==n(ae)&&!0!==e&&Qe(o,!0,()=>a(!0))};a()}else D.clearValue(t);else ye(t)}function xe(e){o("keypress",e)}function we(t){if(o("keydown",t),!0===shouldIgnoreKey(t))return;const n=0!==u.value.length&&(void 0!==e.newValueMode||void 0!==e.onNewValue),a=!0!==t.shiftKey&&!0!==e.multiple&&(i.value>-1||!0===n);if(27===t.keyCode)return void prevent(t);if(9===t.keyCode&&!1===a)return void Ve();if(void 0===t.target||t.target.id!==D.targetUid.value||!0!==D.editable.value)return;if(40===t.keyCode&&!0!==D.innerLoading.value&&!1===l.value)return stopAndPrevent(t),void Le();if(8===t.keyCode&&(!0===e.useChips||!0===e.clearable)&&!0!==e.hideSelected&&0===u.value.length)return void(!0===e.multiple&&!0===Array.isArray(e.modelValue)?se(e.modelValue.length-1):!0!==e.multiple&&null!==e.modelValue&&o("update:modelValue",null));35!==t.keyCode&&36!==t.keyCode||"string"===typeof u.value&&0!==u.value.length||(stopAndPrevent(t),i.value=-1,me(36===t.keyCode?1:-1,e.multiple)),33!==t.keyCode&&34!==t.keyCode||void 0===Q.value||(stopAndPrevent(t),i.value=Math.max(-1,Math.min(P.value,i.value+(33===t.keyCode?-1:1)*Q.value.view)),me(33===t.keyCode?1:-1,e.multiple)),38!==t.keyCode&&40!==t.keyCode||(stopAndPrevent(t),me(38===t.keyCode?-1:1,e.multiple));const r=P.value;if((void 0===h||g<Date.now())&&(h=""),r>0&&!0!==e.useInput&&void 0!==t.key&&1===t.key.length&&!1===t.altKey&&!1===t.ctrlKey&&!1===t.metaKey&&(32!==t.keyCode||0!==h.length)){!0!==l.value&&Le(t);const o=t.key.toLocaleLowerCase(),n=1===h.length&&h[0]===o;g=Date.now()+1500,!1===n&&(stopAndPrevent(t),h+=o);const a=new RegExp("^"+h.split("").map(e=>reEscapeList.indexOf(e)>-1?"\\"+e:e).join(".*"),"i");let u=i.value;if(!0===n||u<0||!0!==a.test(ae.value(e.options[u])))do{u=normalizeToInterval(u+1,-1,r-1)}while(u!==i.value&&(!0===le.value(e.options[u])||!0!==a.test(ae.value(e.options[u]))));i.value!==u&&vue.nextTick(()=>{pe(u),F(u),u>=0&&!0===e.useInput&&!0===e.fillInput&&Me(ae.value(e.options[u]),!0)})}else if(13===t.keyCode||32===t.keyCode&&!0!==e.useInput&&""===h||9===t.keyCode&&!1!==a)if(9!==t.keyCode&&stopAndPrevent(t),i.value>-1&&i.value<r)ve(e.options[i.value]);else{if(!0===n){const t=(t,o)=>{if(o){if(!0!==validateNewValueMode(o))return}else o=e.newValueMode;if($e("",!0!==e.multiple,!0),void 0===t||null===t)return;const n="toggle"===o?ve:de;n(t,"add-unique"===o),!0!==e.multiple&&(null!==w.value&&w.value.focus(),He())};if(void 0!==e.onNewValue?o("newValue",u.value,t):t(u.value),!0!==e.multiple)return}!0===l.value?Ve():!0!==D.innerLoading.value&&Le()}}function Ce(){return!0===v?_.value:null!==C.value&&null!==C.value.contentEl?C.value.contentEl:void 0}function ke(){return Ce()}function _e(){return!0===e.hideSelected?[]:void 0!==t["selected-item"]?Z.value.map(e=>t["selected-item"](e)).slice():void 0!==t.selected?[].concat(t.selected()):!0===e.useChips?Z.value.map((t,o)=>vue.h(QChip,{key:"option-"+o,removable:!0===D.editable.value&&!0!==le.value(t.opt),dense:!0,textColor:e.color,tabindex:Y.value,onRemove(){t.removeAtIndex(o)}},()=>vue.h("span",{class:"ellipsis",[!0===t.html?"innerHTML":"textContent"]:ae.value(t.opt)}))):[vue.h("span",{[!0===W.value?"innerHTML":"textContent"]:K.value})]}function qe(){if(!0===N.value)return void 0!==t["no-option"]?t["no-option"]({inputValue:u.value}):void 0;const e=void 0!==t.option?t.option:e=>{return vue.h(QItem,{key:e.index,...e.itemProps},()=>{return vue.h(QItemSection,()=>vue.h(QItemLabel,()=>vue.h("span",{[!0===e.html?"innerHTML":"textContent"]:e.label})))})};let o=R("div",J.value.map(e));return void 0!==t["before-options"]&&(o=t["before-options"]().concat(o)),hMergeSlot(t["after-options"],o)}function Te(t,o){const n=!0===o?{...G.value,...D.splitAttrs.attributes.value}:void 0,a={ref:!0===o?w:void 0,key:"i_t",class:L.value,style:e.inputStyle,value:void 0!==u.value?u.value:"",type:"search",...n,id:!0===o?D.targetUid.value:void 0,maxlength:e.maxlength,autocomplete:e.autocomplete,"data-autofocus":!0===t||!0===e.autofocus||void 0,disabled:!0===e.disable,readonly:!0===e.readonly,...ie.value};return!0!==t&&!0===v&&(!0===Array.isArray(a.class)?a.class=[...a.class,"no-pointer-events"]:a.class+=" no-pointer-events"),vue.h("input",a)}function Pe(t){null!==b&&(clearTimeout(b),b=null),null!==y&&(clearTimeout(y),y=null),t&&t.target&&!0===t.target.qComposing||(Me(t.target.value||""),p=!0,m=u.value,!0===D.focused.value||!0===v&&!0!==s.value||D.focus(),void 0!==e.onFilter&&(b=setTimeout(()=>{b=null,Qe(u.value)},e.inputDebounce)))}function Me(t,n){u.value!==t&&(u.value=t,!0===n||0===e.inputDebounce||"0"===e.inputDebounce?o("inputValue",t):y=setTimeout(()=>{y=null,o("inputValue",t)},e.inputDebounce))}function $e(t,o,n){p=!0!==n,!0===e.useInput&&(Me(t,!0),!0!==o&&!0===n||(m=t),!0!==o&&Qe(t))}function Qe(t,a,r){if(void 0===e.onFilter||!0!==a&&!0!==D.focused.value)return;!0===D.innerLoading.value?o("filterAbort"):(D.innerLoading.value=!0,c.value=!0),""!==t&&!0!==e.multiple&&0!==I.value.length&&!0!==p&&t===ae.value(I.value[0])&&(t="");const i=setTimeout(()=>{!0===l.value&&(l.value=!1)},10);null!==S&&clearTimeout(S),S=i,o("filter",t,(e,t)=>{!0!==a&&!0!==D.focused.value||S!==i||(clearTimeout(S),"function"===typeof e&&e(),c.value=!1,vue.nextTick(()=>{D.innerLoading.value=!1,!0===D.editable.value&&(!0===a?!0===l.value&&He():!0===l.value?je(!0):l.value=!0),"function"===typeof t&&vue.nextTick(()=>{t(n)}),"function"===typeof r&&vue.nextTick(()=>{r(n)})}))},()=>{!0===D.focused.value&&S===i&&(clearTimeout(S),D.innerLoading.value=!1,c.value=!1),!0===l.value&&(l.value=!1)})}function Be(){return vue.h(QMenu,{ref:C,class:H.value,style:e.popupContentStyle,modelValue:l.value,fit:!0!==e.menuShrink,cover:!0===e.optionsCover&&!0!==N.value&&!0!==e.useInput,anchor:e.menuAnchor,self:e.menuSelf,offset:e.menuOffset,dark:z.value,noParentEvent:!0,noRefocus:!0,noFocus:!0,square:te.value,transitionShow:e.transitionShow,transitionHide:e.transitionHide,transitionDuration:e.transitionDuration,separateClosePopup:!0,...X.value,onScrollPassive:A,onBeforeShow:We,onBeforeHide:Re,onShow:Ae},qe)}function Re(e){Ye(e),Ve()}function Ae(){E()}function Fe(e){stop(e),null!==w.value&&w.value.focus(),s.value=!0,window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,0)}function Ee(e){stop(e),vue.nextTick(()=>{s.value=!1})}function De(){const o=[vue.h(QField,{class:`col-auto ${D.fieldClass.value}`,...O.value,for:D.targetUid.value,dark:z.value,square:!0,loading:c.value,itemAligned:!1,filled:!0,stackLabel:0!==u.value.length,...D.splitAttrs.listeners.value,onFocus:Fe,onBlur:Ee},{...t,rawControl:()=>D.getControl(!0),before:void 0,after:void 0})];return!0===l.value&&o.push(vue.h("div",{ref:_,class:H.value+" scroll",style:e.popupContentStyle,...X.value,onClick:prevent,onScrollPassive:A},qe())),vue.h(QDialog,{ref:k,modelValue:r.value,position:!0===e.useInput?"top":void 0,transitionShow:f,transitionHide:e.transitionHide,transitionDuration:e.transitionDuration,onBeforeShow:We,onBeforeHide:Ie,onHide:Oe,onShow:ze},()=>vue.h("div",{class:"q-select__dialog"+(!0===z.value?" q-select__dialog--dark q-dark":"")+(!0===s.value?" q-select__dialog--focused":"")},o))}function Ie(e){Ye(e),null!==k.value&&k.value.__updateRefocusTarget(D.rootRef.value.querySelector(".q-field__native > [tabindex]:last-child")),D.focused.value=!1}function Oe(e){He(),!1===D.focused.value&&o("blur",e),Ne()}function ze(){const e=document.activeElement;null!==e&&e.id===D.targetUid.value||null===w.value||w.value===e||w.value.focus(),E()}function Ve(){!0!==r.value&&(i.value=-1,!0===l.value&&(l.value=!1),!1===D.focused.value&&(null!==S&&(clearTimeout(S),S=null),!0===D.innerLoading.value&&(o("filterAbort"),D.innerLoading.value=!1,c.value=!1)))}function Le(o){!0===D.editable.value&&(!0===v?(D.onControlFocusin(o),r.value=!0,vue.nextTick(()=>{D.focus()})):D.focus(),void 0!==e.onFilter?Qe(u.value):!0===N.value&&void 0===t["no-option"]||(l.value=!0))}function He(){r.value=!1,Ve()}function Ne(){!0===e.useInput&&$e(!0!==e.multiple&&!0===e.fillInput&&0!==I.value.length&&ae.value(I.value[0])||"",!0,!0)}function je(t){let o=-1;if(!0===t){if(0!==I.value.length){const t=ne.value(I.value[0]);o=e.options.findIndex(e=>isDeepEqual(ne.value(e),t))}B(o)}pe(o)}function Ke(e,t){!0===l.value&&!1===D.innerLoading.value&&(B(-1,!0),vue.nextTick(()=>{!0===l.value&&!1===D.innerLoading.value&&(e>t?B():je(!0))}))}function Ue(){!1===r.value&&null!==C.value&&C.value.updatePosition()}function We(e){void 0!==e&&stop(e),o("popupShow",e),D.hasPopupOpen=!0,D.onControlFocusin(e)}function Ye(e){void 0!==e&&stop(e),o("popupHide",e),D.hasPopupOpen=!1,D.onControlFocusout(e)}function Ge(){v=(!0===a.platform.is.mobile||"dialog"===e.behavior)&&("menu"!==e.behavior&&(!0!==e.useInput||(void 0!==t["no-option"]||void 0!==e.onFilter||!1===N.value))),f=!0===a.platform.is.ios&&!0===v&&!0===e.useInput?"fade":e.transitionShow}return vue.watch(I,t=>{d=t,!0===e.useInput&&!0===e.fillInput&&!0!==e.multiple&&!0!==D.innerLoading.value&&(!0!==r.value&&!0!==l.value||!0!==V.value)&&(!0!==p&&Ne(),!0!==r.value&&!0!==l.value||Qe(""))},{immediate:!0}),vue.watch(()=>e.fillInput,Ne),vue.watch(l,je),vue.watch(P,Ke),vue.onBeforeUpdate(Ge),vue.onUpdated(Ue),Ge(),vue.onBeforeUnmount(()=>{null!==b&&clearTimeout(b),null!==y&&clearTimeout(y)}),Object.assign(n,{showPopup:Le,hidePopup:He,removeAtIndex:se,add:de,toggleOption:ve,getOptionIndex:()=>i.value,setOptionIndex:pe,moveOptionSelection:me,filter:Qe,updateMenuPosition:Ue,updateInputValue:$e,isOptionSelected:ge,getEmittingOptionValue:ue,isOptionDisabled:(...e)=>!0===le.value.apply(null,e),getOptionValue:(...e)=>ne.value.apply(null,e),getOptionLabel:(...e)=>ae.value.apply(null,e)}),Object.assign(D,{innerValue:I,fieldClass:vue.computed(()=>`q-select q-field--auto-height q-select--with${!0!==e.useInput?"out":""}-input`+` q-select--with${!0!==e.useChips?"out":""}-chips`+` q-select--${!0===e.multiple?"multiple":"single"}`),inputRef:x,targetRef:w,hasValue:V,showPopup:Le,floatingLabel:vue.computed(()=>!0!==e.hideSelected&&!0===V.value||"number"===typeof u.value||0!==u.value.length||fieldValueIsFilled(e.displayValue)),getControlChild:()=>{if(!1!==D.editable.value&&(!0===r.value||!0!==N.value||void 0!==t["no-option"]))return!0===v?De():Be();!0===D.hasPopupOpen&&(D.hasPopupOpen=!1)},controlEvents:{onFocusin(e){D.onControlFocusin(e)},onFocusout(e){D.onControlFocusout(e,()=>{Ne(),Ve()})},onClick(e){if(prevent(e),!0!==v&&!0===l.value)return Ve(),void(null!==w.value&&w.value.focus());Le(e)}},getControl:t=>{const o=_e(),n=!0===t||!0!==r.value||!0!==v;if(!0===e.useInput)o.push(Te(t,n));else if(!0===D.editable.value){const a=!0===n?G.value:void 0;o.push(vue.h("input",{ref:!0===n?w:void 0,key:"d_t",class:"q-select__focus-target",id:!0===n?D.targetUid.value:void 0,value:K.value,readonly:!0,"data-autofocus":!0===t||!0===e.autofocus||void 0,...a,onKeydown:we,onKeyup:ye,onKeypress:xe})),!0===n&&"string"===typeof e.autocomplete&&0!==e.autocomplete.length&&o.push(vue.h("input",{class:"q-select__autocomplete-input",autocomplete:e.autocomplete,tabindex:-1,onKeyup:Se}))}if(void 0!==q.value&&!0!==e.disable&&0!==re.value.length){const t=re.value.map(e=>vue.h("option",{value:e,selected:!0}));o.push(vue.h("select",{class:"hidden",name:q.value,multiple:e.multiple},t))}const a=!0===e.useInput||!0!==n?void 0:D.splitAttrs.attributes.value;return vue.h("div",{class:"q-field__native row items-center",...a,...D.splitAttrs.listeners.value},o)},getInnerAppend:()=>!0!==e.loading&&!0!==c.value&&!0!==e.hideDropdownIcon?[vue.h(QIcon,{class:"q-select__dropdown-icon"+(!0===l.value?" rotate-180":""),name:ee.value})]:null}),useField(D)}});const skeletonTypes=["text","rect","circle","QBtn","QBadge","QChip","QToolbar","QCheckbox","QRadio","QToggle","QSlider","QRange","QInput","QAvatar"],skeletonAnimations=["wave","pulse","pulse-x","pulse-y","fade","blink","none"];var QSkeleton=createComponent({name:"QSkeleton",props:{...useDarkProps,tag:{type:String,default:"div"},type:{type:String,validator:e=>skeletonTypes.includes(e),default:"rect"},animation:{type:String,validator:e=>skeletonAnimations.includes(e),default:"wave"},animationSpeed:{type:[String,Number],default:1500},square:Boolean,bordered:Boolean,size:String,width:String,height:String},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),a=vue.computed(()=>{const t=void 0!==e.size?[e.size,e.size]:[e.width,e.height];return{"--q-skeleton-speed":`${e.animationSpeed}ms`,width:t[0],height:t[1]}}),l=vue.computed(()=>`q-skeleton q-skeleton--${!0===n.value?"dark":"light"} q-skeleton--type-${e.type}`+("none"!==e.animation?` q-skeleton--anim q-skeleton--anim-${e.animation}`:"")+(!0===e.square?" q-skeleton--square":"")+(!0===e.bordered?" q-skeleton--bordered":""));return()=>vue.h(e.tag,{class:l.value,style:a.value},hSlot(t.default))}});const slotsDef=[["left","center","start","width"],["right","center","end","width"],["top","start","center","height"],["bottom","end","center","height"]];var QSlideItem=createComponent({name:"QSlideItem",props:{...useDarkProps,leftColor:String,rightColor:String,topColor:String,bottomColor:String,onSlide:Function},emits:["action","top","right","bottom","left"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=useDark(e,a),{getCacheWithFn:r}=useCache(),i=vue.ref(null);let u=null,s={},c={},d={};const v=vue.computed(()=>!0===a.lang.rtl?{left:"right",right:"left"}:{left:"left",right:"right"}),p=vue.computed(()=>"q-slide-item q-item-type overflow-hidden"+(!0===l.value?" q-slide-item--dark q-dark":""));function m(){i.value.style.transform="translate(0,0)"}function f(t,n,a){void 0!==e.onSlide&&o("slide",{side:t,ratio:n,isReset:a})}function h(e){const n=i.value;if(e.isFirst)s={dir:null,size:{left:0,right:0,top:0,bottom:0},scale:0},n.classList.add("no-transition"),slotsDef.forEach(e=>{if(void 0!==t[e[0]]){const t=d[e[0]];t.style.transform="scale(1)",s.size[e[0]]=t.getBoundingClientRect()[e[3]]}}),s.axis="up"===e.direction||"down"===e.direction?"Y":"X";else{if(e.isFinal)return n.classList.remove("no-transition"),void(1===s.scale?(n.style.transform=`translate${s.axis}(${100*s.dir}%)`,null!==u&&clearTimeout(u),u=setTimeout(()=>{u=null,o(s.showing,{reset:m}),o("action",{side:s.showing,reset:m})},230)):(n.style.transform="translate(0,0)",f(s.showing,0,!0)));e.direction="X"===s.axis?e.offset.x<0?"left":"right":e.offset.y<0?"up":"down"}if(void 0===t.left&&e.direction===v.value.right||void 0===t.right&&e.direction===v.value.left||void 0===t.top&&"down"===e.direction||void 0===t.bottom&&"up"===e.direction)return void(n.style.transform="translate(0,0)");let a,l,r;"X"===s.axis?(l="left"===e.direction?-1:1,a=1===l?v.value.left:v.value.right,r=e.distance.x):(l="up"===e.direction?-2:2,a=2===l?"top":"bottom",r=e.distance.y),null!==s.dir&&Math.abs(l)!==Math.abs(s.dir)||(s.dir!==l&&(["left","right","top","bottom"].forEach(e=>{c[e]&&(c[e].style.visibility=a===e?"visible":"hidden")}),s.showing=a,s.dir=l),s.scale=Math.max(0,Math.min(1,(r-40)/s.size[a])),n.style.transform=`translate${s.axis}(${r*l/Math.abs(l)}px)`,d[a].style.transform=`scale(${s.scale})`,f(a,s.scale,!1))}return vue.onBeforeUpdate(()=>{c={},d={}}),vue.onBeforeUnmount(()=>{null!==u&&clearTimeout(u)}),Object.assign(n,{reset:m}),()=>{const o=[],n={left:void 0!==t[v.value.right],right:void 0!==t[v.value.left],up:void 0!==t.bottom,down:void 0!==t.top},a=Object.keys(n).filter(e=>!0===n[e]);slotsDef.forEach(n=>{const a=n[0];void 0!==t[a]&&o.push(vue.h("div",{ref:e=>{c[a]=e},class:`q-slide-item__${a} absolute-full row no-wrap items-${n[1]} justify-${n[2]}`+(void 0!==e[a+"Color"]?` bg-${e[a+"Color"]}`:"")},[vue.h("div",{ref:e=>{d[a]=e}},t[a]())]))});const l=vue.h("div",{key:`${0===a.length?"only-":""} content`,ref:i,class:"q-slide-item__content"},hSlot(t.default));return 0===a.length?o.push(l):o.push(vue.withDirectives(l,r("dir#"+a.join(""),()=>{const e={prevent:!0,stop:!0,mouse:!0};return a.forEach(t=>{e[t]=!0}),[[TouchPan,h,void 0,e]]}))),vue.h("div",{class:p.value},o)}}});const space=vue.h("div",{class:"q-space"});var QSpace=createComponent({name:"QSpace",setup(){return()=>space}});const svg$l=[vue.h("g",{transform:"matrix(1 0 0 -1 0 80)"},[vue.h("rect",{width:"10",height:"20",rx:"3"},[vue.h("animate",{attributeName:"height",begin:"0s",dur:"4.3s",values:"20;45;57;80;64;32;66;45;64;23;66;13;64;56;34;34;2;23;76;79;20",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"15",width:"10",height:"80",rx:"3"},[vue.h("animate",{attributeName:"height",begin:"0s",dur:"2s",values:"80;55;33;5;75;23;73;33;12;14;60;80",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"30",width:"10",height:"50",rx:"3"},[vue.h("animate",{attributeName:"height",begin:"0s",dur:"1.4s",values:"50;34;78;23;56;23;34;76;80;54;21;50",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"45",width:"10",height:"30",rx:"3"},[vue.h("animate",{attributeName:"height",begin:"0s",dur:"2s",values:"30;45;13;80;56;72;45;76;34;23;67;30",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerAudio=createComponent({name:"QSpinnerAudio",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 55 80",xmlns:"http://www.w3.org/2000/svg"},svg$l)}});const svg$k=[vue.h("g",{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"},[vue.h("circle",{cx:"5",cy:"50",r:"5"},[vue.h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;5;50;50",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"cx",begin:"0s",dur:"2.2s",values:"5;27;49;5",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"27",cy:"5",r:"5"},[vue.h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",from:"5",to:"5",values:"5;50;50;5",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"cx",begin:"0s",dur:"2.2s",from:"27",to:"27",values:"27;49;5;27",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"49",cy:"50",r:"5"},[vue.h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;50;5;50",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"cx",from:"49",to:"49",begin:"0s",dur:"2.2s",values:"49;5;27;49",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerBall=createComponent({name:"QSpinnerBall",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 57 57",xmlns:"http://www.w3.org/2000/svg"},svg$k)}});const svg$j=[vue.h("rect",{y:"10",width:"15",height:"120",rx:"6"},[vue.h("animate",{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"30",y:"10",width:"15",height:"120",rx:"6"},[vue.h("animate",{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"60",width:"15",height:"140",rx:"6"},[vue.h("animate",{attributeName:"height",begin:"0s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"y",begin:"0s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"90",y:"10",width:"15",height:"120",rx:"6"},[vue.h("animate",{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("rect",{x:"120",y:"10",width:"15",height:"120",rx:"6"},[vue.h("animate",{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerBars=createComponent({name:"QSpinnerBars",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 135 140",xmlns:"http://www.w3.org/2000/svg"},svg$j)}});const svg$i=[vue.h("rect",{x:"25",y:"25",width:"50",height:"50",fill:"none","stroke-width":"4",stroke:"currentColor"},[vue.h("animateTransform",{id:"spinnerBox",attributeName:"transform",type:"rotate",from:"0 50 50",to:"180 50 50",dur:"0.5s",begin:"rectBox.end"})]),vue.h("rect",{x:"27",y:"27",width:"46",height:"50",fill:"currentColor"},[vue.h("animate",{id:"rectBox",attributeName:"height",begin:"0s;spinnerBox.end",dur:"1.3s",from:"50",to:"0",fill:"freeze"})])];var QSpinnerBox=createComponent({name:"QSpinnerBox",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$i)}});const svg$h=[vue.h("circle",{cx:"50",cy:"50",r:"48",fill:"none","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor"}),vue.h("line",{"stroke-linecap":"round","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor",x1:"50",y1:"50",x2:"85",y2:"50.5"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"2s",repeatCount:"indefinite"})]),vue.h("line",{"stroke-linecap":"round","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor",x1:"50",y1:"50",x2:"49.5",y2:"74"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"15s",repeatCount:"indefinite"})])];var QSpinnerClock=createComponent({name:"QSpinnerClock",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$h)}});const svg$g=[vue.h("rect",{x:"0",y:"0",width:"100",height:"100",fill:"none"}),vue.h("path",{d:"M78,19H22c-6.6,0-12,5.4-12,12v31c0,6.6,5.4,12,12,12h37.2c0.4,3,1.8,5.6,3.7,7.6c2.4,2.5,5.1,4.1,9.1,4 c-1.4-2.1-2-7.2-2-10.3c0-0.4,0-0.8,0-1.3h8c6.6,0,12-5.4,12-12V31C90,24.4,84.6,19,78,19z",fill:"currentColor"}),vue.h("circle",{cx:"30",cy:"47",r:"5",fill:"#fff"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;1;1",keyTimes:"0;0.2;1",dur:"1s",repeatCount:"indefinite"})]),vue.h("circle",{cx:"50",cy:"47",r:"5",fill:"#fff"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.2;0.4;1",dur:"1s",repeatCount:"indefinite"})]),vue.h("circle",{cx:"70",cy:"47",r:"5",fill:"#fff"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.4;0.6;1",dur:"1s",repeatCount:"indefinite"})])];var QSpinnerComment=createComponent({name:"QSpinnerComment",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$g)}});const svg$f=[vue.h("rect",{x:"0",y:"0",width:"100",height:"100",fill:"none"}),vue.h("g",{transform:"translate(25 25)"},[vue.h("rect",{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.9"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),vue.h("g",{transform:"translate(75 25)"},[vue.h("rect",{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.8"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.1s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),vue.h("g",{transform:"translate(25 75)"},[vue.h("rect",{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.7"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.3s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),vue.h("g",{transform:"translate(75 75)"},[vue.h("rect",{x:"-20",y:"-20",width:"40",height:"40",fill:"currentColor",opacity:"0.6"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.2s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])])];var QSpinnerCube=createComponent({name:"QSpinnerCube",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$f)}});const svg$e=[vue.h("circle",{cx:"15",cy:"15",r:"15"},[vue.h("animate",{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"60",cy:"15",r:"9","fill-opacity":".3"},[vue.h("animate",{attributeName:"r",from:"9",to:"9",begin:"0s",dur:"0.8s",values:"9;15;9",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"fill-opacity",from:".5",to:".5",begin:"0s",dur:"0.8s",values:".5;1;.5",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"105",cy:"15",r:"15"},[vue.h("animate",{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerDots=createComponent({name:"QSpinnerDots",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 120 30",xmlns:"http://www.w3.org/2000/svg"},svg$e)}});const svg$d=[vue.h("g",{transform:"translate(20 50)"},[vue.h("rect",{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.6"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])]),vue.h("g",{transform:"translate(50 50)"},[vue.h("rect",{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.8"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.1s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])]),vue.h("g",{transform:"translate(80 50)"},[vue.h("rect",{x:"-10",y:"-30",width:"20",height:"60",fill:"currentColor",opacity:"0.9"},[vue.h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.2s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])])];var QSpinnerFacebook=createComponent({name:"QSpinnerFacebook",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",xmlns:"http://www.w3.org/2000/svg",preserveAspectRatio:"xMidYMid"},svg$d)}});const svg$c=[vue.h("g",{transform:"translate(-20,-20)"},[vue.h("path",{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"90 50 50",to:"0 50 50",dur:"1s",repeatCount:"indefinite"})])]),vue.h("g",{transform:"translate(20,20) rotate(15 50 50)"},[vue.h("path",{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"90 50 50",dur:"1s",repeatCount:"indefinite"})])])];var QSpinnerGears=createComponent({name:"QSpinnerGears",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$c)}});const svg$b=[vue.h("circle",{cx:"12.5",cy:"12.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"0s",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"12.5",cy:"52.5",r:"12.5","fill-opacity":".5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"100ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"52.5",cy:"12.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"300ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"52.5",cy:"52.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"600ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"92.5",cy:"12.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"800ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"92.5",cy:"52.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"400ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"12.5",cy:"92.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"700ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"52.5",cy:"92.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"500ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"92.5",cy:"92.5",r:"12.5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"200ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerGrid=createComponent({name:"QSpinnerGrid",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 105 105",xmlns:"http://www.w3.org/2000/svg"},svg$b)}});const svg$a=[vue.h("path",{d:"M30.262 57.02L7.195 40.723c-5.84-3.976-7.56-12.06-3.842-18.063 3.715-6 11.467-7.65 17.306-3.68l4.52 3.76 2.6-5.274c3.716-6.002 11.47-7.65 17.304-3.68 5.84 3.97 7.56 12.054 3.842 18.062L34.49 56.118c-.897 1.512-2.793 1.915-4.228.9z","fill-opacity":".5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"0s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("path",{d:"M105.512 56.12l-14.44-24.272c-3.716-6.008-1.996-14.093 3.843-18.062 5.835-3.97 13.588-2.322 17.306 3.68l2.6 5.274 4.52-3.76c5.84-3.97 13.593-2.32 17.308 3.68 3.718 6.003 1.998 14.088-3.842 18.064L109.74 57.02c-1.434 1.014-3.33.61-4.228-.9z","fill-opacity":".5"},[vue.h("animate",{attributeName:"fill-opacity",begin:"0.7s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("path",{d:"M67.408 57.834l-23.01-24.98c-5.864-6.15-5.864-16.108 0-22.248 5.86-6.14 15.37-6.14 21.234 0L70 16.168l4.368-5.562c5.863-6.14 15.375-6.14 21.235 0 5.863 6.14 5.863 16.098 0 22.247l-23.007 24.98c-1.43 1.556-3.757 1.556-5.188 0z"})];var QSpinnerHearts=createComponent({name:"QSpinnerHearts",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 140 64",xmlns:"http://www.w3.org/2000/svg"},svg$a)}});const svg$9=[vue.h("g",[vue.h("path",{fill:"none",stroke:"currentColor","stroke-width":"5","stroke-miterlimit":"10",d:"M58.4,51.7c-0.9-0.9-1.4-2-1.4-2.3s0.5-0.4,1.4-1.4 C70.8,43.8,79.8,30.5,80,15.5H70H30H20c0.2,15,9.2,28.1,21.6,32.3c0.9,0.9,1.4,1.2,1.4,1.5s-0.5,1.6-1.4,2.5 C29.2,56.1,20.2,69.5,20,85.5h10h40h10C79.8,69.5,70.8,55.9,58.4,51.7z"}),vue.h("clipPath",{id:"uil-hourglass-clip1"},[vue.h("rect",{x:"15",y:"20",width:"70",height:"25"},[vue.h("animate",{attributeName:"height",from:"25",to:"0",dur:"1s",repeatCount:"indefinite",values:"25;0;0",keyTimes:"0;0.5;1"}),vue.h("animate",{attributeName:"y",from:"20",to:"45",dur:"1s",repeatCount:"indefinite",values:"20;45;45",keyTimes:"0;0.5;1"})])]),vue.h("clipPath",{id:"uil-hourglass-clip2"},[vue.h("rect",{x:"15",y:"55",width:"70",height:"25"},[vue.h("animate",{attributeName:"height",from:"0",to:"25",dur:"1s",repeatCount:"indefinite",values:"0;25;25",keyTimes:"0;0.5;1"}),vue.h("animate",{attributeName:"y",from:"80",to:"55",dur:"1s",repeatCount:"indefinite",values:"80;55;55",keyTimes:"0;0.5;1"})])]),vue.h("path",{d:"M29,23c3.1,11.4,11.3,19.5,21,19.5S67.9,34.4,71,23H29z","clip-path":"url(#uil-hourglass-clip1)",fill:"currentColor"}),vue.h("path",{d:"M71.6,78c-3-11.6-11.5-20-21.5-20s-18.5,8.4-21.5,20H71.6z","clip-path":"url(#uil-hourglass-clip2)",fill:"currentColor"}),vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"180 50 50",repeatCount:"indefinite",dur:"1s",values:"0 50 50;0 50 50;180 50 50",keyTimes:"0;0.7;1"})])];var QSpinnerHourglass=createComponent({name:"QSpinnerHourglass",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$9)}});const svg$8=[vue.h("path",{d:"M24.3,30C11.4,30,5,43.3,5,50s6.4,20,19.3,20c19.3,0,32.1-40,51.4-40C88.6,30,95,43.3,95,50s-6.4,20-19.3,20C56.4,70,43.6,30,24.3,30z",fill:"none",stroke:"currentColor","stroke-width":"8","stroke-dasharray":"10.691205342610678 10.691205342610678","stroke-dashoffset":"0"},[vue.h("animate",{attributeName:"stroke-dashoffset",from:"0",to:"21.382410685221355",begin:"0",dur:"2s",repeatCount:"indefinite",fill:"freeze"})])];var QSpinnerInfinity=createComponent({name:"QSpinnerInfinity",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$8)}});const svg$7=[vue.h("g",{"stroke-width":"4","stroke-linecap":"round"},[vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(180)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(210)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(240)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".1;0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(270)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".15;.1;0;1;.85;.7;.65;.55;.45;.35;.25;.15",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(300)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".25;.15;.1;0;1;.85;.7;.65;.55;.45;.35;.25",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(330)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".35;.25;.15;.1;0;1;.85;.7;.65;.55;.45;.35",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(0)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".45;.35;.25;.15;.1;0;1;.85;.7;.65;.55;.45",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(30)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".55;.45;.35;.25;.15;.1;0;1;.85;.7;.65;.55",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(60)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".65;.55;.45;.35;.25;.15;.1;0;1;.85;.7;.65",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(90)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".7;.65;.55;.45;.35;.25;.15;.1;0;1;.85;.7",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(120)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".85;.7;.65;.55;.45;.35;.25;.15;.1;0;1;.85",repeatCount:"indefinite"})]),vue.h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(150)"},[vue.h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"})])])];var QSpinnerIos=createComponent({name:"QSpinnerIos",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,stroke:"currentColor",fill:"currentColor",viewBox:"0 0 64 64"},svg$7)}});const svg$6=[vue.h("circle",{cx:"50",cy:"50",r:"44",fill:"none","stroke-width":"4","stroke-opacity":".5",stroke:"currentColor"}),vue.h("circle",{cx:"8",cy:"54",r:"6",fill:"currentColor","stroke-width":"3",stroke:"currentColor"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 48",to:"360 50 52",dur:"2s",repeatCount:"indefinite"})])];var QSpinnerOrbit=createComponent({name:"QSpinnerOrbit",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$6)}});const svg$5=[vue.h("g",{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"},[vue.h("circle",{"stroke-opacity":".5",cx:"18",cy:"18",r:"18"}),vue.h("path",{d:"M36 18c0-9.94-8.06-18-18-18"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"1s",repeatCount:"indefinite"})])])];var QSpinnerOval=createComponent({name:"QSpinnerOval",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"},svg$5)}});const svg$4=[vue.h("path",{d:"M0 50A50 50 0 0 1 50 0L50 50L0 50",fill:"currentColor",opacity:"0.5"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"0.8s",repeatCount:"indefinite"})]),vue.h("path",{d:"M50 0A50 50 0 0 1 100 50L50 50L50 0",fill:"currentColor",opacity:"0.5"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"1.6s",repeatCount:"indefinite"})]),vue.h("path",{d:"M100 50A50 50 0 0 1 50 100L50 50L100 50",fill:"currentColor",opacity:"0.5"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"2.4s",repeatCount:"indefinite"})]),vue.h("path",{d:"M50 100A50 50 0 0 1 0 50L50 50L50 100",fill:"currentColor",opacity:"0.5"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"3.2s",repeatCount:"indefinite"})])];var QSpinnerPie=createComponent({name:"QSpinnerPie",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$4)}});const svg$3=[vue.h("g",{fill:"none","fill-rule":"evenodd","stroke-width":"2"},[vue.h("circle",{cx:"22",cy:"22",r:"1"},[vue.h("animate",{attributeName:"r",begin:"0s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-opacity",begin:"0s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"})]),vue.h("circle",{cx:"22",cy:"22",r:"1"},[vue.h("animate",{attributeName:"r",begin:"-0.9s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-opacity",begin:"-0.9s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"})])])];var QSpinnerPuff=createComponent({name:"QSpinnerPuff",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 44 44",xmlns:"http://www.w3.org/2000/svg"},svg$3)}});const svg$2=[vue.h("g",{transform:"scale(0.55)"},[vue.h("circle",{cx:"30",cy:"150",r:"30",fill:"currentColor"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})]),vue.h("path",{d:"M90,150h30c0-49.7-40.3-90-90-90v30C63.1,90,90,116.9,90,150z",fill:"currentColor"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.1",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})]),vue.h("path",{d:"M150,150h30C180,67.2,112.8,0,30,0v30C96.3,30,150,83.7,150,150z",fill:"currentColor"},[vue.h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.2",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})])])];var QSpinnerRadio=createComponent({name:"QSpinnerRadio",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$2)}});const svg$1=[vue.h("g",{fill:"none","fill-rule":"evenodd",transform:"translate(1 1)","stroke-width":"2"},[vue.h("circle",{cx:"22",cy:"22",r:"6"},[vue.h("animate",{attributeName:"r",begin:"1.5s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-opacity",begin:"1.5s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-width",begin:"1.5s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"22",cy:"22",r:"6"},[vue.h("animate",{attributeName:"r",begin:"3s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-opacity",begin:"3s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}),vue.h("animate",{attributeName:"stroke-width",begin:"3s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"})]),vue.h("circle",{cx:"22",cy:"22",r:"8"},[vue.h("animate",{attributeName:"r",begin:"0s",dur:"1.5s",values:"6;1;2;3;4;5;6",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerRings=createComponent({name:"QSpinnerRings",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 45 45",xmlns:"http://www.w3.org/2000/svg"},svg$1)}});const svg=[vue.h("defs",[vue.h("linearGradient",{x1:"8.042%",y1:"0%",x2:"65.682%",y2:"23.865%",id:"a"},[vue.h("stop",{"stop-color":"currentColor","stop-opacity":"0",offset:"0%"}),vue.h("stop",{"stop-color":"currentColor","stop-opacity":".631",offset:"63.146%"}),vue.h("stop",{"stop-color":"currentColor",offset:"100%"})])]),vue.h("g",{transform:"translate(1 1)",fill:"none","fill-rule":"evenodd"},[vue.h("path",{d:"M36 18c0-9.94-8.06-18-18-18",stroke:"url(#a)","stroke-width":"2"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"})]),vue.h("circle",{fill:"currentColor",cx:"36",cy:"18",r:"1"},[vue.h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"})])])];var QSpinnerTail=createComponent({name:"QSpinnerTail",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>vue.h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"},svg)}}),QSplitter=createComponent({name:"QSplitter",props:{...useDarkProps,modelValue:{type:Number,required:!0},reverse:Boolean,unit:{type:String,default:"%",validator:e=>["%","px"].includes(e)},limits:{type:Array,validator:e=>{return 2===e.length&&("number"===typeof e[0]&&"number"===typeof e[1]&&(e[0]>=0&&e[0]<=e[1]))}},emitImmediately:Boolean,horizontal:Boolean,disable:Boolean,beforeClass:[Array,String,Object],afterClass:[Array,String,Object],separatorClass:[Array,String,Object],separatorStyle:[Array,String,Object]},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=useDark(e,n),l=vue.ref(null),r={before:vue.ref(null),after:vue.ref(null)},i=vue.computed(()=>"q-splitter no-wrap "+`${!0===e.horizontal?"q-splitter--horizontal column":"q-splitter--vertical row"}`+` q-splitter--${!0===e.disable?"disabled":"workable"}`+(!0===a.value?" q-splitter--dark":"")),u=vue.computed(()=>!0===e.horizontal?"height":"width"),s=vue.computed(()=>!0!==e.reverse?"before":"after"),c=vue.computed(()=>void 0!==e.limits?e.limits:"%"===e.unit?[10,90]:[50,1/0]);function d(t){return("%"===e.unit?t:Math.round(t))+e.unit}const v=vue.computed(()=>({[s.value]:{[u.value]:d(e.modelValue)}}));let p,m,f,h,g;function b(t){if(!0===t.isFirst){const t=l.value.getBoundingClientRect()[u.value];return p=!0===e.horizontal?"up":"left",m="%"===e.unit?100:t,f=Math.min(m,c.value[1],Math.max(c.value[0],e.modelValue)),h=(!0!==e.reverse?1:-1)*(!0===e.horizontal?1:!0===n.lang.rtl?-1:1)*("%"===e.unit?0===t?0:100/t:1),void l.value.classList.add("q-splitter--active")}if(!0===t.isFinal)return g!==e.modelValue&&o("update:modelValue",g),void l.value.classList.remove("q-splitter--active");const a=f+h*(t.direction===p?-1:1)*t.distance[!0===e.horizontal?"y":"x"];g=Math.min(m,c.value[1],Math.max(c.value[0],a)),r[s.value].value.style[u.value]=d(g),!0===e.emitImmediately&&e.modelValue!==g&&o("update:modelValue",g)}const y=vue.computed(()=>{return[[TouchPan,b,void 0,{[!0===e.horizontal?"vertical":"horizontal"]:!0,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}]]});function S(e,t){e<t[0]?o("update:modelValue",t[0]):e>t[1]&&o("update:modelValue",t[1])}return vue.watch(()=>e.modelValue,e=>{S(e,c.value)}),vue.watch(()=>e.limits,()=>{vue.nextTick(()=>{S(e.modelValue,c.value)})}),()=>{const o=[vue.h("div",{ref:r.before,class:["q-splitter__panel q-splitter__before"+(!0===e.reverse?" col":""),e.beforeClass],style:v.value.before},hSlot(t.before)),vue.h("div",{class:["q-splitter__separator",e.separatorClass],style:e.separatorStyle,"aria-disabled":!0===e.disable?"true":void 0},[hDir("div",{class:"q-splitter__separator-area absolute-full"},hSlot(t.separator),"sep",!0!==e.disable,()=>y.value)]),vue.h("div",{ref:r.after,class:["q-splitter__panel q-splitter__after"+(!0===e.reverse?"":" col"),e.afterClass],style:v.value.after},hSlot(t.after))];return vue.h("div",{class:i.value,ref:l},hMergeSlot(t.default,o))}}}),StepHeader=createComponent({name:"StepHeader",props:{stepper:{},step:{},goToPanel:Function},setup(e,{attrs:t}){const{proxy:{$q:o}}=vue.getCurrentInstance(),n=vue.ref(null),a=vue.computed(()=>e.stepper.modelValue===e.step.name),l=vue.computed(()=>{const t=e.step.disable;return!0===t||""===t}),r=vue.computed(()=>{const t=e.step.error;return!0===t||""===t}),i=vue.computed(()=>{const t=e.step.done;return!1===l.value&&(!0===t||""===t)}),u=vue.computed(()=>{const t=e.step.headerNav,o=!0===t||""===t||void 0===t;return!1===l.value&&e.stepper.headerNav&&o}),s=vue.computed(()=>{return e.step.prefix&&(!1===a.value||"none"===e.stepper.activeIcon)&&(!1===r.value||"none"===e.stepper.errorIcon)&&(!1===i.value||"none"===e.stepper.doneIcon)}),c=vue.computed(()=>{const t=e.step.icon||e.stepper.inactiveIcon;if(!0===a.value){const n=e.step.activeIcon||e.stepper.activeIcon;return"none"===n?t:n||o.iconSet.stepper.active}if(!0===r.value){const n=e.step.errorIcon||e.stepper.errorIcon;return"none"===n?t:n||o.iconSet.stepper.error}if(!1===l.value&&!0===i.value){const n=e.step.doneIcon||e.stepper.doneIcon;return"none"===n?t:n||o.iconSet.stepper.done}return t}),d=vue.computed(()=>{const t=!0===r.value?e.step.errorColor||e.stepper.errorColor:void 0;if(!0===a.value){const o=e.step.activeColor||e.stepper.activeColor||e.step.color;return void 0!==o?o:t}return void 0!==t?t:!1===l.value&&!0===i.value?e.step.doneColor||e.stepper.doneColor||e.step.color||e.stepper.inactiveColor:e.step.color||e.stepper.inactiveColor}),v=vue.computed(()=>{return"q-stepper__tab col-grow flex items-center no-wrap relative-position"+(void 0!==d.value?` text-${d.value}`:"")+(!0===r.value?" q-stepper__tab--error q-stepper__tab--error-with-"+(!0===s.value?"prefix":"icon"):"")+(!0===a.value?" q-stepper__tab--active":"")+(!0===i.value?" q-stepper__tab--done":"")+(!0===u.value?" q-stepper__tab--navigation q-focusable q-hoverable":"")+(!0===l.value?" q-stepper__tab--disabled":"")}),p=vue.computed(()=>!0===e.stepper.headerNav&&u.value);function m(){null!==n.value&&n.value.focus(),!1===a.value&&e.goToPanel(e.step.name)}function f(t){13===t.keyCode&&!1===a.value&&e.goToPanel(e.step.name)}return()=>{const o={class:v.value};!0===u.value&&(o.onClick=m,o.onKeyup=f,Object.assign(o,!0===l.value?{tabindex:-1,"aria-disabled":"true"}:{tabindex:t.tabindex||0}));const a=[vue.h("div",{class:"q-focus-helper",tabindex:-1,ref:n}),vue.h("div",{class:"q-stepper__dot row flex-center q-stepper__line relative-position"},[vue.h("span",{class:"row flex-center"},[!0===s.value?e.step.prefix:vue.h(QIcon,{name:c.value})])])];if(void 0!==e.step.title&&null!==e.step.title){const t=[vue.h("div",{class:"q-stepper__title"},e.step.title)];void 0!==e.step.caption&&null!==e.step.caption&&t.push(vue.h("div",{class:"q-stepper__caption"},e.step.caption)),a.push(vue.h("div",{class:"q-stepper__label q-stepper__line relative-position"},t))}return vue.withDirectives(vue.h("div",o,a),[[Ripple,p.value]])}}});function getStepWrapper(e){return vue.h("div",{class:"q-stepper__step-content"},[vue.h("div",{class:"q-stepper__step-inner"},hSlot(e.default))])}const PanelWrapper={setup(e,{slots:t}){return()=>getStepWrapper(t)}};var QStep=createComponent({name:"QStep",props:{...usePanelChildProps,icon:String,color:String,title:{type:String,required:!0},caption:String,prefix:[String,Number],doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String,headerNav:{type:Boolean,default:!0},done:Boolean,error:Boolean,onScroll:[Function,Array]},setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=vue.getCurrentInstance(),a=vue.inject(stepperKey,emptyRenderFn);if(a===emptyRenderFn)return console.error("QStep needs to be a child of QStepper"),emptyRenderFn;const{getCacheWithFn:l}=useCache(),r=vue.ref(null),i=vue.computed(()=>a.value.modelValue===e.name),u=vue.computed(()=>!0!==n.platform.is.ios&&!0===n.platform.is.chrome||!0!==i.value||!0!==a.value.vertical?{}:{onScroll(t){const{target:n}=t;n.scrollTop>0&&(n.scrollTop=0),void 0!==e.onScroll&&o("scroll",t)}}),s=vue.computed(()=>"string"===typeof e.name||"number"===typeof e.name?e.name:String(e.name));function c(){const e=a.value.vertical;return!0===e&&!0===a.value.keepAlive?vue.h(vue.KeepAlive,a.value.keepAliveProps.value,!0===i.value?[vue.h(!0===a.value.needsUniqueKeepAliveWrapper.value?l(s.value,()=>({...PanelWrapper,name:s.value})):PanelWrapper,{key:s.value},t.default)]:void 0):!0!==e||!0===i.value?getStepWrapper(t):void 0}return()=>vue.h("div",{ref:r,class:"q-stepper__step",role:"tabpanel",...u.value},!0===a.value.vertical?[vue.h(StepHeader,{stepper:a.value,step:e,goToPanel:a.value.goToPanel}),!0===a.value.animated?vue.h(QSlideTransition,c):c()]:[c()])}});const camelRE=/(-\w)/g;function camelizeProps(e){const t={};for(const o in e){const n=o.replace(camelRE,e=>e[1].toUpperCase());t[n]=e[o]}return t}var QStepper=createComponent({name:"QStepper",props:{...useDarkProps,...usePanelProps,flat:Boolean,bordered:Boolean,alternativeLabels:Boolean,headerNav:Boolean,contracted:Boolean,headerClass:String,inactiveColor:String,inactiveIcon:String,doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String},emits:usePanelEmits,setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q),{updatePanelsList:a,isValidPanelName:l,updatePanelIndex:r,getPanelContent:i,getPanels:u,panelDirectives:s,goToPanel:c,keepAliveProps:d,needsUniqueKeepAliveWrapper:v}=usePanel();vue.provide(stepperKey,vue.computed(()=>({goToPanel:c,keepAliveProps:d,needsUniqueKeepAliveWrapper:v,...e})));const p=vue.computed(()=>`q-stepper q-stepper--${!0===e.vertical?"vertical":"horizontal"}`+(!0===e.flat?" q-stepper--flat":"")+(!0===e.bordered?" q-stepper--bordered":"")+(!0===n.value?" q-stepper--dark q-dark":"")),m=vue.computed(()=>"q-stepper__header row items-stretch justify-between"+` q-stepper__header--${!0===e.alternativeLabels?"alternative":"standard"}-labels`+(!1===e.flat||!0===e.bordered?" q-stepper__header--border":"")+(!0===e.contracted?" q-stepper__header--contracted":"")+(void 0!==e.headerClass?` ${e.headerClass}`:""));function f(){const o=hSlot(t.message,[]);if(!0===e.vertical){l(e.modelValue)&&r();const n=vue.h("div",{class:"q-stepper__content"},hSlot(t.default));return void 0===o?[n]:o.concat(n)}return[vue.h("div",{class:m.value},u().map(t=>{const o=camelizeProps(t.props);return vue.h(StepHeader,{key:o.name,stepper:e,step:o,goToPanel:c})})),o,hDir("div",{class:"q-stepper__content q-panel-parent"},i(),"cont",e.swipeable,()=>s.value)]}return()=>{return a(t),vue.h("div",{class:p.value},hMergeSlot(t.navigation,f()))}}}),QStepperNavigation=createComponent({name:"QStepperNavigation",setup(e,{slots:t}){return()=>vue.h("div",{class:"q-stepper__nav"},hSlot(t.default))}}),QTh=createComponent({name:"QTh",props:{props:Object,autoWidth:Boolean},emits:["click"],setup(e,{slots:t,emit:o}){const n=vue.getCurrentInstance(),{proxy:{$q:a}}=n,l=e=>{o("click",e)};return()=>{if(void 0===e.props)return vue.h("th",{class:!0===e.autoWidth?"q-table--col-auto-width":"",onClick:l},hSlot(t.default));let o,r;const i=n.vnode.key;if(i){if(o=e.props.colsMap[i],void 0===o)return}else o=e.props.col;if(!0===o.sortable){const e="right"===o.align?"unshift":"push";r=hUniqueSlot(t.default,[]),r[e](vue.h(QIcon,{class:o.__iconClass,name:a.iconSet.table.arrowUp}))}else r=hSlot(t.default);const u={class:o.__thClass+(!0===e.autoWidth?" q-table--col-auto-width":""),style:o.headerStyle,onClick:t=>{!0===o.sortable&&e.props.sort(o),l(t)}};return vue.h("th",u,r)}}});function getTableMiddle(e,t){return vue.h("div",e,[vue.h("table",{class:"q-table"},t)])}const comps={list:QList,table:QMarkupTable},typeOptions=["list","table","__qtable"];var QVirtualScroll=createComponent({name:"QVirtualScroll",props:{...useVirtualScrollProps,type:{type:String,default:"list",validator:e=>typeOptions.includes(e)},items:{type:Array,default:()=>[]},itemsFn:Function,itemsSize:Number,scrollTarget:{default:void 0}},setup(e,{slots:t,attrs:o}){let n;const a=vue.ref(null),l=vue.computed(()=>e.itemsSize>=0&&void 0!==e.itemsFn?parseInt(e.itemsSize,10):Array.isArray(e.items)?e.items.length:0),{virtualScrollSliceRange:r,localResetVirtualScroll:i,padVirtualScroll:u,onVirtualScrollEvt:s}=useVirtualScroll({virtualScrollLength:l,getVirtualScrollTarget:m,getVirtualScrollEl:p}),c=vue.computed(()=>{if(0===l.value)return[];const t=(e,t)=>({index:r.value.from+t,item:e});return void 0===e.itemsFn?e.items.slice(r.value.from,r.value.to).map(t):e.itemsFn(r.value.from,r.value.to-r.value.from).map(t)}),d=vue.computed(()=>"q-virtual-scroll q-virtual-scroll"+(!0===e.virtualScrollHorizontal?"--horizontal":"--vertical")+(void 0!==e.scrollTarget?"":" scroll")),v=vue.computed(()=>void 0!==e.scrollTarget?{}:{tabindex:0});function p(){return a.value.$el||a.value}function m(){return n}function f(){n=getScrollTarget(p(),e.scrollTarget),n.addEventListener("scroll",s,listenOpts.passive)}function h(){void 0!==n&&(n.removeEventListener("scroll",s,listenOpts.passive),n=void 0)}function g(){let o=u("list"===e.type?"div":"tbody",c.value.map(t.default));return void 0!==t.before&&(o=t.before().concat(o)),hMergeSlot(t.after,o)}return vue.watch(l,()=>{i()}),vue.watch(()=>e.scrollTarget,()=>{h(),f()}),vue.onBeforeMount(()=>{i()}),vue.onMounted(()=>{f()}),vue.onActivated(()=>{f()}),vue.onDeactivated(()=>{h()}),vue.onBeforeUnmount(()=>{h()}),()=>{if(void 0!==t.default)return"__qtable"===e.type?getTableMiddle({ref:a,class:"q-table__middle "+d.value},g()):vue.h(comps[e.type],{...o,ref:a,class:[o.class,d.value],...v.value},g);console.error("QVirtualScroll: default scoped slot is required for rendering")}}});function sortDate(e,t){return new Date(e)-new Date(t)}const useTableSortProps={sortMethod:Function,binaryStateSort:Boolean,columnSortOrder:{type:String,validator:e=>"ad"===e||"da"===e,default:"ad"}};function useTableSort(e,t,o,n){const a=vue.computed(()=>{const{sortBy:e}=t.value;return e&&o.value.find(t=>t.name===e)||null}),l=vue.computed(()=>void 0!==e.sortMethod?e.sortMethod:(e,t,n)=>{const a=o.value.find(e=>e.name===t);if(void 0===a||void 0===a.field)return e;const l=!0===n?-1:1,r="function"===typeof a.field?e=>a.field(e):e=>e[a.field];return e.sort((e,t)=>{let o=r(e),n=r(t);return void 0!==a.rawSort?a.rawSort(o,n,e,t)*l:null===o||void 0===o?-1*l:null===n||void 0===n?1*l:void 0!==a.sort?a.sort(o,n,e,t)*l:!0===isNumber(o)&&!0===isNumber(n)?(o-n)*l:!0===isDate(o)&&!0===isDate(n)?sortDate(o,n)*l:"boolean"===typeof o&&"boolean"===typeof n?(o-n)*l:([o,n]=[o,n].map(e=>(e+"").toLocaleString().toLowerCase()),o<n?-1*l:o===n?0:l)})});function r(a){let l=e.columnSortOrder;if(!0===isObject(a))a.sortOrder&&(l=a.sortOrder),a=a.name;else{const e=o.value.find(e=>e.name===a);void 0!==e&&e.sortOrder&&(l=e.sortOrder)}let{sortBy:r,descending:i}=t.value;r!==a?(r=a,i="da"===l):!0===e.binaryStateSort?i=!i:!0===i?"ad"===l?r=null:i=!1:"ad"===l?i=!0:r=null,n({sortBy:r,descending:i,page:1})}return{columnToSort:a,computedSortMethod:l,sort:r}}const useTableFilterProps={filter:[String,Object],filterMethod:Function};function useTableFilter(e,t){const o=vue.computed(()=>void 0!==e.filterMethod?e.filterMethod:(e,t,o,n)=>{const a=t?t.toLowerCase():"";return e.filter(e=>o.some(t=>{const o=n(t,e)+"",l="undefined"===o||"null"===o?"":o.toLowerCase();return-1!==l.indexOf(a)}))});return vue.watch(()=>e.filter,()=>{vue.nextTick(()=>{t({page:1},!0)})},{deep:!0}),{computedFilterMethod:o}}function samePagination(e,t){for(const o in t)if(t[o]!==e[o])return!1;return!0}function fixPagination(e){return e.page<1&&(e.page=1),void 0!==e.rowsPerPage&&e.rowsPerPage<1&&(e.rowsPerPage=0),e}const useTablePaginationProps={pagination:Object,rowsPerPageOptions:{type:Array,default:()=>[5,7,10,15,20,25,50,0]},"onUpdate:pagination":[Function,Array]};function useTablePaginationState(e,t){const{props:o,emit:n}=e,a=vue.ref(Object.assign({sortBy:null,descending:!1,page:1,rowsPerPage:0!==o.rowsPerPageOptions.length?o.rowsPerPageOptions[0]:5},o.pagination)),l=vue.computed(()=>{const e=void 0!==o["onUpdate:pagination"]?{...a.value,...o.pagination}:a.value;return fixPagination(e)}),r=vue.computed(()=>void 0!==l.value.rowsNumber);function i(e){u({pagination:e,filter:o.filter})}function u(e={}){vue.nextTick(()=>{n("request",{pagination:e.pagination||l.value,filter:e.filter||o.filter,getCellValue:t})})}function s(e,t){const u=fixPagination({...l.value,...e});!0!==samePagination(l.value,u)?!0!==r.value?void 0!==o.pagination&&void 0!==o["onUpdate:pagination"]?n("update:pagination",u):a.value=u:i(u):!0===r.value&&!0===t&&i(u)}return{innerPagination:a,computedPagination:l,isServerSide:r,requestServerInteraction:u,setPagination:s}}function useTablePagination(e,t,o,n,a,l){const{props:r,emit:i,proxy:{$q:u}}=e,s=vue.computed(()=>!0===n.value?o.value.rowsNumber||0:l.value),c=vue.computed(()=>{const{page:e,rowsPerPage:t}=o.value;return(e-1)*t}),d=vue.computed(()=>{const{page:e,rowsPerPage:t}=o.value;return e*t}),v=vue.computed(()=>1===o.value.page),p=vue.computed(()=>0===o.value.rowsPerPage?1:Math.max(1,Math.ceil(s.value/o.value.rowsPerPage))),m=vue.computed(()=>0===d.value||o.value.page>=p.value),f=vue.computed(()=>{const e=r.rowsPerPageOptions.includes(t.value.rowsPerPage)?r.rowsPerPageOptions:[t.value.rowsPerPage].concat(r.rowsPerPageOptions);return e.map(e=>({label:0===e?u.lang.table.allRows:""+e,value:e}))});function h(){a({page:1})}function g(){const{page:e}=o.value;e>1&&a({page:e-1})}function b(){const{page:e,rowsPerPage:t}=o.value;d.value>0&&e*t<s.value&&a({page:e+1})}function y(){a({page:p.value})}return vue.watch(p,(e,t)=>{if(e===t)return;const n=o.value.page;e&&!n?a({page:1}):e<n&&a({page:e})}),void 0!==r["onUpdate:pagination"]&&i("update:pagination",{...o.value}),{firstRowIndex:c,lastRowIndex:d,isFirstPage:v,isLastPage:m,pagesNumber:p,computedRowsPerPageOptions:f,computedRowsNumber:s,firstPage:h,prevPage:g,nextPage:b,lastPage:y}}const useTableRowSelectionProps={selection:{type:String,default:"none",validator:e=>["single","multiple","none"].includes(e)},selected:{type:Array,default:()=>[]}},useTableRowSelectionEmits=["update:selected","selection"];function useTableRowSelection(e,t,o,n){const a=vue.computed(()=>{const t={};return e.selected.map(n.value).forEach(e=>{t[e]=!0}),t}),l=vue.computed(()=>{return"none"!==e.selection}),r=vue.computed(()=>{return"single"===e.selection}),i=vue.computed(()=>{return"multiple"===e.selection}),u=vue.computed(()=>0!==o.value.length&&o.value.every(e=>!0===a.value[n.value(e)])),s=vue.computed(()=>!0!==u.value&&o.value.some(e=>!0===a.value[n.value(e)])),c=vue.computed(()=>e.selected.length);function d(e){return!0===a.value[e]}function v(){t("update:selected",[])}function p(o,a,l,i){t("selection",{rows:a,added:l,keys:o,evt:i});const u=!0===r.value?!0===l?a:[]:!0===l?e.selected.concat(a):e.selected.filter(e=>!1===o.includes(n.value(e)));t("update:selected",u)}return{hasSelectionMode:l,singleSelection:r,multipleSelection:i,allRowsSelected:u,someRowsSelected:s,rowsSelectedNumber:c,isRowSelected:d,clearSelection:v,updateSelection:p}}function getVal(e){return Array.isArray(e)?e.slice():[]}const useTableRowExpandProps={expanded:Array},useTableRowExpandEmits=["update:expanded"];function useTableRowExpand(e,t){const o=vue.ref(getVal(e.expanded));function n(e){return o.value.includes(e)}function a(n){void 0!==e.expanded?t("update:expanded",n):o.value=n}function l(e,t){const n=o.value.slice(),l=n.indexOf(e);!0===t?-1===l&&(n.push(e),a(n)):-1!==l&&(n.splice(l,1),a(n))}return vue.watch(()=>e.expanded,e=>{o.value=getVal(e)}),{isRowExpanded:n,setExpanded:a,updateExpanded:l}}const useTableColumnSelectionProps={visibleColumns:Array};function useTableColumnSelection(e,t,o){const n=vue.computed(()=>{if(void 0!==e.columns)return e.columns;const t=e.rows[0];return void 0!==t?Object.keys(t).map(e=>({name:e,label:e.toUpperCase(),field:e,align:isNumber(t[e])?"right":"left",sortable:!0})):[]}),a=vue.computed(()=>{const{sortBy:o,descending:a}=t.value,l=void 0!==e.visibleColumns?n.value.filter(t=>!0===t.required||!0===e.visibleColumns.includes(t.name)):n.value;return l.map(e=>{const t=e.align||"right",n=`text-${t}`;return{...e,align:t,__iconClass:`q-table__sort-icon q-table__sort-icon--${t}`,__thClass:n+(void 0!==e.headerClasses?" "+e.headerClasses:"")+(!0===e.sortable?" sortable":"")+(e.name===o?` sorted ${!0===a?"sort-desc":""}`:""),__tdStyle:void 0!==e.style?"function"!==typeof e.style?()=>e.style:e.style:()=>null,__tdClass:void 0!==e.classes?"function"!==typeof e.classes?()=>n+" "+e.classes:t=>n+" "+e.classes(t):()=>n}})}),l=vue.computed(()=>{const e={};return a.value.forEach(t=>{e[t.name]=t}),e}),r=vue.computed(()=>{return void 0!==e.tableColspan?e.tableColspan:a.value.length+(!0===o.value?1:0)});return{colList:n,computedCols:a,computedColsMap:l,computedColspan:r}}const bottomClass="q-table__bottom row items-center",commonVirtPropsObj={};commonVirtPropsList.forEach(e=>{commonVirtPropsObj[e]={}});var QTable=createComponent({name:"QTable",props:{rows:{type:Array,default:()=>[]},rowKey:{type:[String,Function],default:"id"},columns:Array,loading:Boolean,iconFirstPage:String,iconPrevPage:String,iconNextPage:String,iconLastPage:String,title:String,hideHeader:Boolean,grid:Boolean,gridHeader:Boolean,dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,separator:{type:String,default:"horizontal",validator:e=>["horizontal","vertical","cell","none"].includes(e)},wrapCells:Boolean,virtualScroll:Boolean,virtualScrollTarget:{default:void 0},...commonVirtPropsObj,noDataLabel:String,noResultsLabel:String,loadingLabel:String,selectedRowsLabel:Function,rowsPerPageLabel:String,paginationLabel:Function,color:{type:String,default:"grey-8"},titleClass:[String,Array,Object],tableStyle:[String,Array,Object],tableClass:[String,Array,Object],tableHeaderStyle:[String,Array,Object],tableHeaderClass:[String,Array,Object],cardContainerClass:[String,Array,Object],cardContainerStyle:[String,Array,Object],cardStyle:[String,Array,Object],cardClass:[String,Array,Object],hideBottom:Boolean,hideSelectedBanner:Boolean,hideNoData:Boolean,hidePagination:Boolean,onRowClick:Function,onRowDblclick:Function,onRowContextmenu:Function,...useDarkProps,...useFullscreenProps,...useTableColumnSelectionProps,...useTableFilterProps,...useTablePaginationProps,...useTableRowExpandProps,...useTableRowSelectionProps,...useTableSortProps},emits:["request","virtualScroll",...useFullscreenEmits,...useTableRowExpandEmits,...useTableRowSelectionEmits],setup(e,{slots:t,emit:o}){const n=vue.getCurrentInstance(),{proxy:{$q:a}}=n,l=useDark(e,a),{inFullscreen:r,toggleFullscreen:i}=useFullscreen(),u=vue.computed(()=>"function"===typeof e.rowKey?e.rowKey:t=>t[e.rowKey]),s=vue.ref(null),c=vue.ref(null),d=vue.computed(()=>!0!==e.grid&&!0===e.virtualScroll),v=vue.computed(()=>" q-table__card"+(!0===l.value?" q-table__card--dark q-dark":"")+(!0===e.square?" q-table--square":"")+(!0===e.flat?" q-table--flat":"")+(!0===e.bordered?" q-table--bordered":"")),p=vue.computed(()=>`q-table__container q-table--${e.separator}-separator column no-wrap`+(!0===e.grid?" q-table--grid":v.value)+(!0===l.value?" q-table--dark":"")+(!0===e.dense?" q-table--dense":"")+(!1===e.wrapCells?" q-table--no-wrap":"")+(!0===r.value?" fullscreen scroll":"")),m=vue.computed(()=>p.value+(!0===e.loading?" q-table--loading":""));vue.watch(()=>e.tableStyle+e.tableClass+e.tableHeaderStyle+e.tableHeaderClass+p.value,()=>{!0===d.value&&null!==c.value&&c.value.reset()});const{innerPagination:f,computedPagination:h,isServerSide:g,requestServerInteraction:b,setPagination:y}=useTablePaginationState(n,pe),{computedFilterMethod:S}=useTableFilter(e,y),{isRowExpanded:x,setExpanded:w,updateExpanded:C}=useTableRowExpand(e,o),k=vue.computed(()=>{let t=e.rows;if(!0===g.value||0===t.length)return t;const{sortBy:o,descending:n}=h.value;return e.filter&&(t=S.value(t,e.filter,D.value,pe)),null!==z.value&&(t=V.value(e.rows===t?t.slice():t,o,n)),t}),_=vue.computed(()=>k.value.length),q=vue.computed(()=>{let t=k.value;if(!0===g.value)return t;const{rowsPerPage:o}=h.value;return 0!==o&&(0===H.value&&e.rows!==t?t.length>N.value&&(t=t.slice(0,N.value)):t=t.slice(H.value,N.value)),t}),{hasSelectionMode:T,singleSelection:P,multipleSelection:M,allRowsSelected:$,someRowsSelected:Q,rowsSelectedNumber:B,isRowSelected:R,clearSelection:A,updateSelection:F}=useTableRowSelection(e,o,q,u),{colList:E,computedCols:D,computedColsMap:I,computedColspan:O}=useTableColumnSelection(e,h,T),{columnToSort:z,computedSortMethod:V,sort:L}=useTableSort(e,h,E,y),{firstRowIndex:H,lastRowIndex:N,isFirstPage:j,isLastPage:K,pagesNumber:U,computedRowsPerPageOptions:W,computedRowsNumber:Y,firstPage:G,prevPage:X,nextPage:Z,lastPage:J}=useTablePagination(n,f,h,g,y,_),ee=vue.computed(()=>0===q.value.length),te=vue.computed(()=>{const t={};return commonVirtPropsList.forEach(o=>{t[o]=e[o]}),void 0===t.virtualScrollItemSize&&(t.virtualScrollItemSize=!0===e.dense?28:48),t});function oe(){!0===d.value&&c.value.reset()}function ne(){if(!0===e.grid)return qe();const o=!0!==e.hideHeader?ge:null;if(!0===d.value){const n=t["top-row"],a=t["bottom-row"],l={default:e=>ie(e.item,t.body,e.index)};if(void 0!==n){const e=vue.h("tbody",n({cols:D.value}));l.before=null===o?()=>e:()=>[o()].concat(e)}else null!==o&&(l.before=o);return void 0!==a&&(l.after=(()=>vue.h("tbody",a({cols:D.value})))),vue.h(QVirtualScroll,{ref:c,class:e.tableClass,style:e.tableStyle,...te.value,scrollTarget:e.virtualScrollTarget,items:q.value,type:"__qtable",tableColspan:O.value,onVirtualScroll:le},l)}const n=[ue()];return null!==o&&n.unshift(o()),getTableMiddle({class:["q-table__middle scroll",e.tableClass],style:e.tableStyle},n)}function ae(t,n){if(null!==c.value)return void c.value.scrollTo(t,n);t=parseInt(t,10);const a=s.value.querySelector(`tbody tr:nth-of-type(${t+1})`);if(null!==a){const n=s.value.querySelector(".q-table__middle.scroll"),l=a.offsetTop-e.virtualScrollStickySizeStart,r=l<n.scrollTop?"decrease":"increase";n.scrollTop=l,o("virtualScroll",{index:t,from:0,to:f.value.rowsPerPage-1,direction:r})}}function le(e){o("virtualScroll",e)}function re(){return[vue.h(QLinearProgress,{class:"q-table__linear-progress",color:e.color,dark:l.value,indeterminate:!0,trackColor:"transparent"})]}function ie(n,a,r){const i=u.value(n),s=R(i);if(void 0!==a)return a(se({key:i,row:n,pageIndex:r,__trClass:s?"selected":""}));const c=t["body-cell"],d=D.value.map(e=>{const o=t[`body-cell-${e.name}`],a=void 0!==o?o:c;return void 0!==a?a(ce({key:i,row:n,pageIndex:r,col:e})):vue.h("td",{class:e.__tdClass(n),style:e.__tdStyle(n)},pe(e,n))});if(!0===T.value){const o=t["body-selection"],a=void 0!==o?o(de({key:i,row:n,pageIndex:r})):[vue.h(QCheckbox,{modelValue:s,color:e.color,dark:l.value,dense:e.dense,"onUpdate:modelValue":(e,t)=>{F([i],[n],e,t)}})];d.unshift(vue.h("td",{class:"q-table--col-auto-width"},a))}const v={key:i,class:{selected:s}};return void 0!==e.onRowClick&&(v.class["cursor-pointer"]=!0,v.onClick=(e=>{o("RowClick",e,n,r)})),void 0!==e.onRowDblclick&&(v.class["cursor-pointer"]=!0,v.onDblclick=(e=>{o("RowDblclick",e,n,r)})),void 0!==e.onRowContextmenu&&(v.class["cursor-pointer"]=!0,v.onContextmenu=(e=>{o("RowContextmenu",e,n,r)})),vue.h("tr",v,d)}function ue(){const e=t.body,o=t["top-row"],n=t["bottom-row"];let a=q.value.map((t,o)=>ie(t,e,o));return void 0!==o&&(a=o({cols:D.value}).concat(a)),void 0!==n&&(a=a.concat(n({cols:D.value}))),vue.h("tbody",a)}function se(e){return ve(e),e.cols=e.cols.map(t=>injectProp({...t},"value",()=>pe(t,e.row))),e}function ce(e){return ve(e),injectProp(e,"value",()=>pe(e.col,e.row)),e}function de(e){return ve(e),e}function ve(t){Object.assign(t,{cols:D.value,colsMap:I.value,sort:L,rowIndex:H.value+t.pageIndex,color:e.color,dark:l.value,dense:e.dense}),!0===T.value&&injectProp(t,"selected",()=>R(t.key),(e,o)=>{F([t.key],[t.row],e,o)}),injectProp(t,"expand",()=>x(t.key),e=>{C(t.key,e)})}function pe(e,t){const o="function"===typeof e.field?e.field(t):t[e.field];return void 0!==e.format?e.format(o,t):o}const me=vue.computed(()=>({pagination:h.value,pagesNumber:U.value,isFirstPage:j.value,isLastPage:K.value,firstPage:G,prevPage:X,nextPage:Z,lastPage:J,inFullscreen:r.value,toggleFullscreen:i}));function fe(){const o=t.top,n=t["top-left"],a=t["top-right"],l=t["top-selection"],r=!0===T.value&&void 0!==l&&B.value>0,i="q-table__top relative-position row items-center";if(void 0!==o)return vue.h("div",{class:i},[o(me.value)]);let u;return!0===r?u=l(me.value).slice():(u=[],void 0!==n?u.push(vue.h("div",{class:"q-table__control"},[n(me.value)])):e.title&&u.push(vue.h("div",{class:"q-table__control"},[vue.h("div",{class:["q-table__title",e.titleClass]},e.title)]))),void 0!==a&&(u.push(vue.h("div",{class:"q-table__separator col"})),u.push(vue.h("div",{class:"q-table__control"},[a(me.value)]))),0!==u.length?vue.h("div",{class:i},u):void 0}const he=vue.computed(()=>!0===Q.value?null:$.value);function ge(){const o=be();return!0===e.loading&&void 0===t.loading&&o.push(vue.h("tr",{class:"q-table__progress"},[vue.h("th",{class:"relative-position",colspan:O.value},re())])),vue.h("thead",o)}function be(){const o=t.header,n=t["header-cell"];if(void 0!==o)return o(ye({header:!0})).slice();const a=D.value.map(e=>{const o=t[`header-cell-${e.name}`],a=void 0!==o?o:n,l=ye({col:e});return void 0!==a?a(l):vue.h(QTh,{key:e.name,props:l},()=>e.label)});if(!0===P.value&&!0!==e.grid)a.unshift(vue.h("th",{class:"q-table--col-auto-width"}," "));else if(!0===M.value){const o=t["header-selection"],n=void 0!==o?o(ye({})):[vue.h(QCheckbox,{color:e.color,modelValue:he.value,dark:l.value,dense:e.dense,"onUpdate:modelValue":Se})];a.unshift(vue.h("th",{class:"q-table--col-auto-width"},n))}return[vue.h("tr",{class:e.tableHeaderClass,style:e.tableHeaderStyle},a)]}function ye(t){return Object.assign(t,{cols:D.value,sort:L,colsMap:I.value,color:e.color,dark:l.value,dense:e.dense}),!0===M.value&&injectProp(t,"selected",()=>he.value,Se),t}function Se(e){!0===Q.value&&(e=!1),F(q.value.map(u.value),q.value,e)}const xe=vue.computed(()=>{const t=[e.iconFirstPage||a.iconSet.table.firstPage,e.iconPrevPage||a.iconSet.table.prevPage,e.iconNextPage||a.iconSet.table.nextPage,e.iconLastPage||a.iconSet.table.lastPage];return!0===a.lang.rtl?t.reverse():t});function we(){if(!0===e.hideBottom)return;if(!0===ee.value){if(!0===e.hideNoData)return;const o=!0===e.loading?e.loadingLabel||a.lang.table.loading:e.filter?e.noResultsLabel||a.lang.table.noResults:e.noDataLabel||a.lang.table.noData,n=t["no-data"],l=void 0!==n?[n({message:o,icon:a.iconSet.table.warning,filter:e.filter})]:[vue.h(QIcon,{class:"q-table__bottom-nodata-icon",name:a.iconSet.table.warning}),o];return vue.h("div",{class:bottomClass+" q-table__bottom--nodata"},l)}const o=t.bottom;if(void 0!==o)return vue.h("div",{class:bottomClass},[o(me.value)]);const n=!0!==e.hideSelectedBanner&&!0===T.value&&B.value>0?[vue.h("div",{class:"q-table__control"},[vue.h("div",[(e.selectedRowsLabel||a.lang.table.selectedRecords)(B.value)])])]:[];return!0!==e.hidePagination?vue.h("div",{class:bottomClass+" justify-end"},ke(n)):0!==n.length?vue.h("div",{class:bottomClass},n):void 0}function Ce(e){y({page:1,rowsPerPage:e.value})}function ke(o){let n;const{rowsPerPage:r}=h.value,i=e.paginationLabel||a.lang.table.pagination,u=t.pagination,s=e.rowsPerPageOptions.length>1;if(o.push(vue.h("div",{class:"q-table__separator col"})),!0===s&&o.push(vue.h("div",{class:"q-table__control"},[vue.h("span",{class:"q-table__bottom-item"},[e.rowsPerPageLabel||a.lang.table.recordsPerPage]),vue.h(QSelect,{class:"q-table__select inline q-table__bottom-item",color:e.color,modelValue:r,options:W.value,displayValue:0===r?a.lang.table.allRows:r,dark:l.value,borderless:!0,dense:!0,optionsDense:!0,optionsCover:!0,"onUpdate:modelValue":Ce})])),void 0!==u)n=u(me.value);else if(n=[vue.h("span",0!==r?{class:"q-table__bottom-item"}:{},[r?i(H.value+1,Math.min(N.value,Y.value),Y.value):i(1,_.value,Y.value)])],0!==r&&U.value>1){const t={color:e.color,round:!0,dense:!0,flat:!0};!0===e.dense&&(t.size="sm"),U.value>2&&n.push(vue.h(QBtn,{key:"pgFirst",...t,icon:xe.value[0],disable:j.value,onClick:G})),n.push(vue.h(QBtn,{key:"pgPrev",...t,icon:xe.value[1],disable:j.value,onClick:X}),vue.h(QBtn,{key:"pgNext",...t,icon:xe.value[2],disable:K.value,onClick:Z})),U.value>2&&n.push(vue.h(QBtn,{key:"pgLast",...t,icon:xe.value[3],disable:K.value,onClick:J}))}return o.push(vue.h("div",{class:"q-table__control"},n)),o}function _e(){const o=!0===e.gridHeader?[vue.h("table",{class:"q-table"},[ge()])]:!0===e.loading&&void 0===t.loading?re():void 0;return vue.h("div",{class:"q-table__middle"},o)}function qe(){const n=void 0!==t.item?t.item:n=>{const a=n.cols.map(e=>vue.h("div",{class:"q-table__grid-item-row"},[vue.h("div",{class:"q-table__grid-item-title"},[e.label]),vue.h("div",{class:"q-table__grid-item-value"},[e.value])]));if(!0===T.value){const o=t["body-selection"],r=void 0!==o?o(n):[vue.h(QCheckbox,{modelValue:n.selected,color:e.color,dark:l.value,dense:e.dense,"onUpdate:modelValue":(e,t)=>{F([n.key],[n.row],e,t)}})];a.unshift(vue.h("div",{class:"q-table__grid-item-row"},r),vue.h(QSeparator,{dark:l.value}))}const r={class:["q-table__grid-item-card"+v.value,e.cardClass],style:e.cardStyle};return void 0===e.onRowClick&&void 0===e.onRowDblclick||(r.class[0]+=" cursor-pointer",void 0!==e.onRowClick&&(r.onClick=(e=>{o("RowClick",e,n.row,n.pageIndex)})),void 0!==e.onRowDblclick&&(r.onDblclick=(e=>{o("RowDblclick",e,n.row,n.pageIndex)}))),vue.h("div",{class:"q-table__grid-item col-xs-12 col-sm-6 col-md-4 col-lg-3"+(!0===n.selected?" q-table__grid-item--selected":"")},[vue.h("div",r,a)])};return vue.h("div",{class:["q-table__grid-content row",e.cardContainerClass],style:e.cardContainerStyle},q.value.map((e,t)=>{return n(se({key:u.value(e),row:e,pageIndex:t}))}))}return Object.assign(n.proxy,{requestServerInteraction:b,setPagination:y,firstPage:G,prevPage:X,nextPage:Z,lastPage:J,isRowSelected:R,clearSelection:A,isRowExpanded:x,setExpanded:w,sort:L,resetVirtualScroll:oe,scrollTo:ae,getCellValue:pe}),injectMultipleProps(n.proxy,{filteredSortedRows:()=>k.value,computedRows:()=>q.value,computedRowsNumber:()=>Y.value}),()=>{const o=[fe()],n={ref:s,class:m.value};return!0===e.grid?o.push(_e()):Object.assign(n,{class:[n.class,e.cardClass],style:e.cardStyle}),o.push(ne(),we()),!0===e.loading&&void 0!==t.loading&&o.push(t.loading()),vue.h("div",n,o)}}}),QTr=createComponent({name:"QTr",props:{props:Object,noHover:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>"q-tr"+(void 0===e.props||!0===e.props.header?"":" "+e.props.__trClass)+(!0===e.noHover?" q-tr--no-hover":""));return()=>vue.h("tr",{class:o.value},hSlot(t.default))}}),QTd=createComponent({name:"QTd",props:{props:Object,autoWidth:Boolean,noHover:Boolean},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=vue.computed(()=>"q-td"+(!0===e.autoWidth?" q-table--col-auto-width":"")+(!0===e.noHover?" q-td--no-hover":"")+" ");return()=>{if(void 0===e.props)return vue.h("td",{class:n.value},hSlot(t.default));const a=o.vnode.key,l=(void 0!==e.props.colsMap?e.props.colsMap[a]:null)||e.props.col;if(void 0===l)return;const{row:r}=e.props;return vue.h("td",{class:n.value+l.__tdClass(r),style:l.__tdStyle(r)},hSlot(t.default))}}}),QRouteTab=createComponent({name:"QRouteTab",props:{...useRouterLinkProps,...useTabProps},emits:useTabEmits,setup(e,{slots:t,emit:o}){const n=useRouterLink({useDisableForRouterLinkProps:!1}),{renderTab:a,$tabs:l}=useTab(e,t,o,{exact:vue.computed(()=>e.exact),...n});return vue.watch(()=>`${e.name} | ${e.exact} | ${(n.resolvedLink.value||{}).href}`,()=>{l.verifyRouteModel()}),()=>a(n.linkTag.value,n.linkAttrs.value)}});function getViewByModel(e,t){if(null!==e.hour){if(null===e.minute)return"minute";if(!0===t&&null===e.second)return"second"}return"hour"}function getCurrentTime(){const e=new Date;return{hour:e.getHours(),minute:e.getMinutes(),second:e.getSeconds(),millisecond:e.getMilliseconds()}}var QTime=createComponent({name:"QTime",props:{...useDarkProps,...useFormProps,...useDatetimeProps,mask:{default:null},format24h:{type:Boolean,default:null},defaultDate:{type:String,validator:e=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(e)},options:Function,hourOptions:Array,minuteOptions:Array,secondOptions:Array,withSeconds:Boolean,nowBtn:Boolean},emits:useDatetimeEmits,setup(e,{slots:t,emit:o}){const n=vue.getCurrentInstance(),{$q:a}=n.proxy,l=useDark(e,a),{tabindex:r,headerClass:i,getLocale:u,getCurrentDate:s}=useDatetime(e,a),c=useFormAttrs(e),d=useFormInject(c);let v,p;const m=vue.ref(null),f=vue.computed(()=>V()),h=vue.computed(()=>u()),g=vue.computed(()=>L()),b=__splitDate(e.modelValue,f.value,h.value,e.calendar,g.value),y=vue.ref(getViewByModel(b)),S=vue.ref(b),x=vue.ref(null===b.hour||b.hour<12),w=vue.computed(()=>`q-time q-time--${!0===e.landscape?"landscape":"portrait"}`+(!0===l.value?" q-time--dark q-dark":"")+(!0===e.disable?" disabled":!0===e.readonly?" q-time--readonly":"")+(!0===e.bordered?" q-time--bordered":"")+(!0===e.square?" q-time--square no-border-radius":"")+(!0===e.flat?" q-time--flat no-shadow":"")),C=vue.computed(()=>{const e=S.value;return{hour:null===e.hour?"--":!0===k.value?pad(e.hour):String(!0===x.value?0===e.hour?12:e.hour:e.hour>12?e.hour-12:e.hour),minute:null===e.minute?"--":pad(e.minute),second:null===e.second?"--":pad(e.second)}}),k=vue.computed(()=>null!==e.format24h?e.format24h:a.lang.date.format24h),_=vue.computed(()=>{const e="hour"===y.value,t=!0===e?12:60,o=S.value[y.value],n=Math.round(o*(360/t))-180;let a=`rotate(${n}deg) translateX(-50%)`;return!0===e&&!0===k.value&&S.value.hour>=12&&(a+=" scale(.7)"),{transform:a}}),q=vue.computed(()=>null!==S.value.hour),T=vue.computed(()=>!0===q.value&&null!==S.value.minute),P=vue.computed(()=>void 0!==e.hourOptions?t=>e.hourOptions.includes(t):void 0!==e.options?t=>e.options(t,null,null):null),M=vue.computed(()=>void 0!==e.minuteOptions?t=>e.minuteOptions.includes(t):void 0!==e.options?t=>e.options(S.value.hour,t,null):null),$=vue.computed(()=>void 0!==e.secondOptions?t=>e.secondOptions.includes(t):void 0!==e.options?t=>e.options(S.value.hour,S.value.minute,t):null),Q=vue.computed(()=>{if(null===P.value)return null;const e=I(0,11,P.value),t=I(12,11,P.value);return{am:e,pm:t,values:e.values.concat(t.values)}}),B=vue.computed(()=>null!==M.value?I(0,59,M.value):null),R=vue.computed(()=>null!==$.value?I(0,59,$.value):null),A=vue.computed(()=>{switch(y.value){case"hour":return Q.value;case"minute":return B.value;case"second":return R.value}}),F=vue.computed(()=>{let e,t,o=0,n=1;const a=null!==A.value?A.value.values:void 0;"hour"===y.value?!0===k.value?(e=0,t=23):(e=0,t=11,!1===x.value&&(o=12)):(e=0,t=55,n=5);const l=[];for(let r=e,i=e;r<=t;r+=n,i++){const e=r+o,t=void 0!==a&&!1===a.includes(e),n="hour"===y.value&&0===r?!0===k.value?"00":"12":r;l.push({val:e,index:i,disable:t,label:n})}return l}),E=vue.computed(()=>{return[[TouchPan,j,void 0,{stop:!0,prevent:!0,mouse:!0}]]});function D(){const e={...s(),...getCurrentTime()};ce(e),Object.assign(S.value,e),y.value="hour"}function I(e,t,o){const n=Array.apply(null,{length:t+1}).map((t,n)=>{const a=n+e;return{index:a,val:!0===o(a)}}).filter(e=>!0===e.val).map(e=>e.index);return{min:n[0],max:n[n.length-1],values:n,threshold:t+1}}function O(e,t,o){const n=Math.abs(e-t);return Math.min(n,o-n)}function z(e,{min:t,max:o,values:n,threshold:a}){if(e===t)return t;if(e<t||e>o)return O(e,t,a)<=O(e,o,a)?t:o;const l=n.findIndex(t=>e<=t),r=n[l-1],i=n[l];return e-r<=i-e?r:i}function V(){return"persian"!==e.calendar&&null!==e.mask?e.mask:`HH:mm${!0===e.withSeconds?":ss":""}`}function L(){if("string"!==typeof e.defaultDate){const e=s(!0);return e.dateHash=getDayHash(e),e}return __splitDate(e.defaultDate,"YYYY/MM/DD",void 0,e.calendar)}function H(){return!0===vmIsDestroyed(n)||null!==A.value&&(0===A.value.values.length||"hour"===y.value&&!0!==k.value&&0===Q.value[!0===x.value?"am":"pm"].values.length)}function N(){const e=m.value,{top:t,left:o,width:n}=e.getBoundingClientRect(),a=n/2;return{top:t+a,left:o+a,dist:.7*a}}function j(e){if(!0!==H()){if(!0===e.isFirst)return v=N(),void(p=U(e.evt,v));p=U(e.evt,v,p),!0===e.isFinal&&(v=!1,p=null,K())}}function K(){"hour"===y.value?y.value="minute":e.withSeconds&&"minute"===y.value&&(y.value="second")}function U(e,t,o){const n=position(e),a=Math.abs(n.top-t.top),l=Math.sqrt(Math.pow(Math.abs(n.top-t.top),2)+Math.pow(Math.abs(n.left-t.left),2));let r,i=Math.asin(a/l)*(180/Math.PI);if(i=n.top<t.top?t.left<n.left?90-i:270+i:t.left<n.left?i+90:270-i,"hour"===y.value){if(r=i/30,null!==Q.value){const e=!0!==k.value?!0===x.value:0!==Q.value.am.values.length&&0!==Q.value.pm.values.length?l>=t.dist:0!==Q.value.am.values.length;r=z(r+(!0===e?0:12),Q.value[!0===e?"am":"pm"])}else r=Math.round(r),!0===k.value?l<t.dist?r<12&&(r+=12):12===r&&(r=0):!0===x.value&&12===r?r=0:!1===x.value&&12!==r&&(r+=12);!0===k.value&&(x.value=r<12)}else r=Math.round(i/6)%60,"minute"===y.value&&null!==B.value?r=z(r,B.value):"second"===y.value&&null!==R.value&&(r=z(r,R.value));return o!==r&&le[y.value](r),r}vue.watch(()=>e.modelValue,t=>{const o=__splitDate(t,f.value,h.value,e.calendar,g.value);o.dateHash===S.value.dateHash&&o.timeHash===S.value.timeHash||(S.value=o,null===o.hour?y.value="hour":x.value=o.hour<12)}),vue.watch([f,h],()=>{vue.nextTick(()=>{ce()})});const W={hour(){y.value="hour"},minute(){y.value="minute"},second(){y.value="second"}};function Y(e){13===e.keyCode&&re()}function G(e){13===e.keyCode&&ie()}function X(e){!0!==H()&&(!0!==a.platform.is.desktop&&U(e,N()),K())}function Z(e){!0!==H()&&U(e,N())}function J(e){if(13===e.keyCode)y.value="hour";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==Q.value){const e=!0===k.value?Q.value.values:Q.value[!0===x.value?"am":"pm"].values;if(0===e.length)return;if(null===S.value.hour)oe(e[0]);else{const o=(e.length+e.indexOf(S.value.hour)+t)%e.length;oe(e[o])}}else{const e=!0===k.value?24:12,o=!0!==k.value&&!1===x.value?12:0,n=null===S.value.hour?-t:S.value.hour;oe(o+(24+n+t)%e)}}}function ee(e){if(13===e.keyCode)y.value="minute";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==B.value){const e=B.value.values;if(0===e.length)return;if(null===S.value.minute)ne(e[0]);else{const o=(e.length+e.indexOf(S.value.minute)+t)%e.length;ne(e[o])}}else{const e=null===S.value.minute?-t:S.value.minute;ne((60+e+t)%60)}}}function te(e){if(13===e.keyCode)y.value="second";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==R.value){const e=R.value.values;if(0===e.length)return;if(null===S.value.seconds)ae(e[0]);else{const o=(e.length+e.indexOf(S.value.second)+t)%e.length;ae(e[o])}}else{const e=null===S.value.second?-t:S.value.second;ae((60+e+t)%60)}}}function oe(e){S.value.hour!==e&&(S.value.hour=e,se())}function ne(e){S.value.minute!==e&&(S.value.minute=e,se())}function ae(e){S.value.second!==e&&(S.value.second=e,se())}const le={hour:oe,minute:ne,second:ae};function re(){!1===x.value&&(x.value=!0,null!==S.value.hour&&(S.value.hour-=12,se()))}function ie(){!0===x.value&&(x.value=!1,null!==S.value.hour&&(S.value.hour+=12,se()))}function ue(t){const o=e.modelValue;y.value!==t&&void 0!==o&&null!==o&&""!==o&&"string"!==typeof o&&(y.value=t)}function se(){return null!==P.value&&!0!==P.value(S.value.hour)?(S.value=__splitDate(),void ue("hour")):null!==M.value&&!0!==M.value(S.value.minute)?(S.value.minute=null,S.value.second=null,void ue("minute")):!0===e.withSeconds&&null!==$.value&&!0!==$.value(S.value.second)?(S.value.second=null,void ue("second")):void(null===S.value.hour||null===S.value.minute||!0===e.withSeconds&&null===S.value.second||ce())}function ce(t){const n=Object.assign({...S.value},t),a="persian"===e.calendar?pad(n.hour)+":"+pad(n.minute)+(!0===e.withSeconds?":"+pad(n.second):""):formatDate(new Date(n.year,null===n.month?null:n.month-1,n.day,n.hour,n.minute,n.second,n.millisecond),f.value,h.value,n.year,n.timezoneOffset);n.changed=a!==e.modelValue,o("update:modelValue",a,n)}function de(){const t=[vue.h("div",{class:"q-time__link "+("hour"===y.value?"q-time__link--active":"cursor-pointer"),tabindex:r.value,onClick:W.hour,onKeyup:J},C.value.hour),vue.h("div",":"),vue.h("div",!0===q.value?{class:"q-time__link "+("minute"===y.value?"q-time__link--active":"cursor-pointer"),tabindex:r.value,onKeyup:ee,onClick:W.minute}:{class:"q-time__link"},C.value.minute)];!0===e.withSeconds&&t.push(vue.h("div",":"),vue.h("div",!0===T.value?{class:"q-time__link "+("second"===y.value?"q-time__link--active":"cursor-pointer"),tabindex:r.value,onKeyup:te,onClick:W.second}:{class:"q-time__link"},C.value.second));const o=[vue.h("div",{class:"q-time__header-label row items-center no-wrap",dir:"ltr"},t)];return!1===k.value&&o.push(vue.h("div",{class:"q-time__header-ampm column items-between no-wrap"},[vue.h("div",{class:"q-time__link "+(!0===x.value?"q-time__link--active":"cursor-pointer"),tabindex:r.value,onClick:re,onKeyup:Y},"AM"),vue.h("div",{class:"q-time__link "+(!0!==x.value?"q-time__link--active":"cursor-pointer"),tabindex:r.value,onClick:ie,onKeyup:G},"PM")])),vue.h("div",{class:"q-time__header flex flex-center no-wrap "+i.value},o)}function ve(){const t=S.value[y.value];return vue.h("div",{class:"q-time__content col relative-position"},[vue.h(vue.Transition,{name:"q-transition--scale"},()=>vue.h("div",{key:"clock"+y.value,class:"q-time__container-parent absolute-full"},[vue.h("div",{ref:m,class:"q-time__container-child fit overflow-hidden"},[vue.withDirectives(vue.h("div",{class:"q-time__clock cursor-pointer non-selectable",onClick:X,onMousedown:Z},[vue.h("div",{class:"q-time__clock-circle fit"},[vue.h("div",{class:"q-time__clock-pointer"+(null===S.value[y.value]?" hidden":void 0!==e.color?` text-${e.color}`:""),style:_.value}),F.value.map(e=>vue.h("div",{class:`q-time__clock-position row flex-center q-time__clock-pos-${e.index}`+(e.val===t?" q-time__clock-position--active "+i.value:!0===e.disable?" q-time__clock-position--disable":"")},[vue.h("span",e.label)]))])]),E.value)])])),!0===e.nowBtn?vue.h(QBtn,{class:"q-time__now-button absolute",icon:a.iconSet.datetime.now,unelevated:!0,size:"sm",round:!0,color:e.color,textColor:e.textColor,tabindex:r.value,onClick:D}):null])}return n.proxy.setNow=D,()=>{const o=[ve()],n=hSlot(t.default);return void 0!==n&&o.push(vue.h("div",{class:"q-time__actions"},n)),void 0!==e.name&&!0!==e.disable&&d(o,"push"),vue.h("div",{class:w.value,tabindex:-1},[de(),vue.h("div",{class:"q-time__main col overflow-auto"},o)])}}}),QTimeline=createComponent({name:"QTimeline",props:{...useDarkProps,color:{type:String,default:"primary"},side:{type:String,default:"right",validator:e=>["left","right"].includes(e)},layout:{type:String,default:"dense",validator:e=>["dense","comfortable","loose"].includes(e)}},setup(e,{slots:t}){const o=vue.getCurrentInstance(),n=useDark(e,o.proxy.$q);vue.provide(timelineKey,e);const a=vue.computed(()=>`q-timeline q-timeline--${e.layout} q-timeline--${e.layout}--${e.side}`+(!0===n.value?" q-timeline--dark":""));return()=>vue.h("ul",{class:a.value},hSlot(t.default))}}),QTimelineEntry=createComponent({name:"QTimelineEntry",props:{heading:Boolean,tag:{type:String,default:"h3"},side:{type:String,default:"right",validator:e=>["left","right"].includes(e)},icon:String,avatar:String,color:String,title:String,subtitle:String,body:String},setup(e,{slots:t}){const o=vue.inject(timelineKey,emptyRenderFn);if(o===emptyRenderFn)return console.error("QTimelineEntry needs to be child of QTimeline"),emptyRenderFn;const n=vue.computed(()=>`q-timeline__entry q-timeline__entry--${e.side}`+(void 0!==e.icon||void 0!==e.avatar?" q-timeline__entry--icon":"")),a=vue.computed(()=>`q-timeline__dot text-${e.color||o.color}`),l=vue.computed(()=>"comfortable"===o.layout&&"left"===o.side);return()=>{const o=hUniqueSlot(t.default,[]);if(void 0!==e.body&&o.unshift(e.body),!0===e.heading){const t=[vue.h("div"),vue.h("div"),vue.h(e.tag,{class:"q-timeline__heading-title"},o)];return vue.h("div",{class:"q-timeline__heading"},!0===l.value?t.reverse():t)}let r;void 0!==e.icon?r=[vue.h(QIcon,{class:"row items-center justify-center",name:e.icon})]:void 0!==e.avatar&&(r=[vue.h("img",{class:"q-timeline__dot-img",src:e.avatar})]);const i=[vue.h("div",{class:"q-timeline__subtitle"},[vue.h("span",{},hSlot(t.subtitle,[e.subtitle]))]),vue.h("div",{class:a.value},r),vue.h("div",{class:"q-timeline__content"},[vue.h("h6",{class:"q-timeline__title"},hSlot(t.title,[e.title]))].concat(o))];return vue.h("li",{class:n.value},!0===l.value?i.reverse():i)}}}),QToolbar=createComponent({name:"QToolbar",props:{inset:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>"q-toolbar row no-wrap items-center"+(!0===e.inset?" q-toolbar--inset":""));return()=>vue.h("div",{class:o.value,role:"toolbar"},hSlot(t.default))}}),QToolbarTitle=createComponent({name:"QToolbarTitle",props:{shrink:Boolean},setup(e,{slots:t}){const o=vue.computed(()=>"q-toolbar__title ellipsis"+(!0===e.shrink?" col-shrink":""));return()=>vue.h("div",{class:o.value},hSlot(t.default))}});const tickStrategyOptions=["none","strict","leaf","leaf-filtered"];var QTree=createComponent({name:"QTree",props:{...useDarkProps,nodes:{type:Array,required:!0},nodeKey:{type:String,required:!0},labelKey:{type:String,default:"label"},childrenKey:{type:String,default:"children"},dense:Boolean,color:String,controlColor:String,textColor:String,selectedColor:String,icon:String,tickStrategy:{type:String,default:"none",validator:e=>tickStrategyOptions.includes(e)},ticked:Array,expanded:Array,selected:{},noSelectionUnset:Boolean,defaultExpandAll:Boolean,accordion:Boolean,filter:String,filterMethod:Function,duration:Number,noConnectors:Boolean,noTransition:Boolean,noNodesLabel:String,noResultsLabel:String},emits:["update:expanded","update:ticked","update:selected","lazyLoad","afterShow","afterHide"],setup(e,{slots:t,emit:o}){const{proxy:n}=vue.getCurrentInstance(),{$q:a}=n,l=useDark(e,a),r=vue.ref({}),i=vue.ref(e.ticked||[]),u=vue.ref(e.expanded||[]);let s={};vue.onBeforeUpdate(()=>{s={}});const c=vue.computed(()=>`q-tree q-tree--${!0===e.dense?"dense":"standard"}`+(!0===e.noConnectors?" q-tree--no-connectors":"")+(!0===l.value?" q-tree--dark":"")+(void 0!==e.color?` text-${e.color}`:"")),d=vue.computed(()=>void 0!==e.selected),v=vue.computed(()=>e.icon||a.iconSet.tree.icon),p=vue.computed(()=>e.controlColor||e.color),m=vue.computed(()=>void 0!==e.textColor?` text-${e.textColor}`:""),f=vue.computed(()=>{const t=e.selectedColor||e.color;return t?` text-${t}`:""}),h=vue.computed(()=>void 0!==e.filterMethod?e.filterMethod:(t,o)=>{const n=o.toLowerCase();return t[e.labelKey]&&t[e.labelKey].toLowerCase().indexOf(n)>-1}),g=vue.computed(()=>{const t={},o=(n,a)=>{const l=n.tickStrategy||(a?a.tickStrategy:e.tickStrategy),s=n[e.nodeKey],c=n[e.childrenKey]&&Array.isArray(n[e.childrenKey])&&0!==n[e.childrenKey].length,v=!0!==n.disabled&&!0===d.value&&!1!==n.selectable,p=!0!==n.disabled&&!1!==n.expandable,m="none"!==l,f="strict"===l,g="leaf-filtered"===l,b="leaf"===l||"leaf-filtered"===l;let y=!0!==n.disabled&&!1!==n.tickable;!0===b&&!0===y&&a&&!0!==a.tickable&&(y=!1);let S=n.lazy;!0===S&&void 0!==r.value[s]&&!0===Array.isArray(n[e.childrenKey])&&(S=r.value[s]);const x={key:s,parent:a,isParent:c,lazy:S,disabled:n.disabled,link:!0!==n.disabled&&(!0===v||!0===p&&(!0===c||!0===S)),children:[],matchesFilter:!e.filter||h.value(n,e.filter),selected:s===e.selected&&!0===v,selectable:v,expanded:!0===c&&u.value.includes(s),expandable:p,noTick:!0===n.noTick||!0!==f&&S&&"loaded"!==S,tickable:y,tickStrategy:l,hasTicking:m,strictTicking:f,leafFilteredTicking:g,leafTicking:b,ticked:!0===f?i.value.includes(s):!0!==c&&i.value.includes(s)};if(t[s]=x,!0===c&&(x.children=n[e.childrenKey].map(e=>o(e,x)),e.filter&&(!0!==x.matchesFilter?x.matchesFilter=x.children.some(e=>e.matchesFilter):!0!==x.noTick&&!0!==x.disabled&&!0===x.tickable&&!0===g&&!0===x.children.every(e=>!0!==e.matchesFilter||!0===e.noTick||!0!==e.tickable)&&(x.tickable=!1)),!0===x.matchesFilter&&(!0!==x.noTick&&!0!==f&&!0===x.children.every(e=>e.noTick)&&(x.noTick=!0),b))){if(x.ticked=!1,x.indeterminate=x.children.some(e=>!0===e.indeterminate),x.tickable=!0===x.tickable&&x.children.some(e=>e.tickable),!0!==x.indeterminate){const e=x.children.reduce((e,t)=>!0===t.ticked?e+1:e,0);e===x.children.length?x.ticked=!0:e>0&&(x.indeterminate=!0)}!0===x.indeterminate&&(x.indeterminateNextState=x.children.every(e=>!0!==e.tickable||!0!==e.ticked))}return x};return e.nodes.forEach(e=>o(e,null)),t});function b(t){const o=[].reduce,n=(a,l)=>{return a||!l?a:!0===Array.isArray(l)?o.call(Object(l),n,a):l[e.nodeKey]===t?l:l[e.childrenKey]?n(null,l[e.childrenKey]):void 0};return n(null,e.nodes)}function y(){return i.value.map(e=>b(e))}function S(){return u.value.map(e=>b(e))}function x(e){return!(!e||!g.value[e])&&g.value[e].expanded}function w(){void 0!==e.expanded?o("update:expanded",[]):u.value=[]}function C(){const t=[],n=o=>{o[e.childrenKey]&&0!==o[e.childrenKey].length&&!1!==o.expandable&&!0!==o.disabled&&(t.push(o[e.nodeKey]),o[e.childrenKey].forEach(n))};e.nodes.forEach(n),void 0!==e.expanded?o("update:expanded",t):u.value=t}function k(t,n,a=b(t),l=g.value[t]){if(l.lazy&&"loaded"!==l.lazy){if("loading"===l.lazy)return;r.value[t]="loading",!0!==Array.isArray(a[e.childrenKey])&&(a[e.childrenKey]=[]),o("lazyLoad",{node:a,key:t,done:o=>{r.value[t]="loaded",a[e.childrenKey]=!0===Array.isArray(o)?o:[],vue.nextTick(()=>{const e=g.value[t];e&&!0===e.isParent&&_(t,!0)})},fail:()=>{delete r.value[t],0===a[e.childrenKey].length&&delete a[e.childrenKey]}})}else!0===l.isParent&&!0===l.expandable&&_(t,n)}function _(t,n){let a=u.value;const l=void 0!==e.expanded;if(!0===l&&(a=a.slice()),n){if(e.accordion&&g.value[t]){const o=[];g.value[t].parent?g.value[t].parent.children.forEach(e=>{e.key!==t&&!0===e.expandable&&o.push(e.key)}):e.nodes.forEach(n=>{const a=n[e.nodeKey];a!==t&&o.push(a)}),0!==o.length&&(a=a.filter(e=>!1===o.includes(e)))}a=a.concat([t]).filter((e,t,o)=>o.indexOf(e)===t)}else a=a.filter(e=>e!==t);!0===l?o("update:expanded",a):u.value=a}function q(e){return!(!e||!g.value[e])&&g.value[e].ticked}function T(t,n){let a=i.value;const l=void 0!==e.ticked;!0===l&&(a=a.slice()),a=n?a.concat(t).filter((e,t,o)=>o.indexOf(e)===t):a.filter(e=>!1===t.includes(e)),!0===l&&o("update:ticked",a)}function P(t,o,a){const r={tree:n,node:t,key:a,color:e.color,dark:l.value};return injectProp(r,"expanded",()=>{return o.expanded},e=>{e!==o.expanded&&k(a,e)}),injectProp(r,"ticked",()=>{return o.ticked},e=>{e!==o.ticked&&T([a],e)}),r}function M(t){return(e.filter?t.filter(t=>g.value[t[e.nodeKey]].matchesFilter):t).map(e=>R(e))}function $(e){if(void 0!==e.icon)return vue.h(QIcon,{class:"q-tree__icon q-mr-sm",name:e.icon,color:e.iconColor});const t=e.img||e.avatar;return t?vue.h("img",{class:`q-tree__${e.img?"img":"avatar"} q-mr-sm`,src:t}):void 0}function Q(){o("afterShow")}function B(){o("afterHide")}function R(o){const n=o[e.nodeKey],a=g.value[n],r=o.header&&t[`header-${o.header}`]||t["default-header"],i=!0===a.isParent?M(o[e.childrenKey]):[],u=0!==i.length||a.lazy&&"loaded"!==a.lazy;let c=o.body&&t[`body-${o.body}`]||t["default-body"];const d=void 0!==r||void 0!==c?P(o,a,n):null;return void 0!==c&&(c=vue.h("div",{class:"q-tree__node-body relative-position"},[vue.h("div",{class:m.value},[c(d)])])),vue.h("div",{key:n,class:"q-tree__node relative-position"+` q-tree__node--${!0===u?"parent":"child"}`},[vue.h("div",{class:"q-tree__node-header relative-position row no-wrap items-center"+(!0===a.link?" q-tree__node--link q-hoverable q-focusable":"")+(!0===a.selected?" q-tree__node--selected":"")+(!0===a.disabled?" q-tree__node--disabled":""),tabindex:!0===a.link?0:-1,ariaExpanded:i.length>0?a.expanded:null,role:"treeitem",onClick:e=>{F(o,a,e)},onKeypress(e){!0!==shouldIgnoreKey(e)&&(13===e.keyCode?F(o,a,e,!0):32===e.keyCode&&E(o,a,e,!0))}},[vue.h("div",{class:"q-focus-helper",tabindex:-1,ref:e=>{s[a.key]=e}}),"loading"===a.lazy?vue.h(QSpinner,{class:"q-tree__spinner",color:p.value}):!0===u?vue.h(QIcon,{class:"q-tree__arrow"+(!0===a.expanded?" q-tree__arrow--rotate":""),name:v.value,onClick(e){E(o,a,e)}}):null,!0===a.hasTicking&&!0!==a.noTick?vue.h(QCheckbox,{class:"q-tree__tickbox",modelValue:!0===a.indeterminate?null:a.ticked,color:p.value,dark:l.value,dense:!0,keepColor:!0,disable:!0!==a.tickable,onKeydown:stopAndPrevent,"onUpdate:modelValue":e=>{D(a,e)}}):null,vue.h("div",{class:"q-tree__node-header-content col row no-wrap items-center"+(!0===a.selected?f.value:m.value)},[r?r(d):[$(o),vue.h("div",o[e.labelKey])]])]),!0===u?!0===e.noTransition?!0===a.expanded?vue.h("div",{class:"q-tree__node-collapsible"+m.value,key:`${n}__q`},[c,vue.h("div",{class:"q-tree__children"+(!0===a.disabled?" q-tree__node--disabled":""),role:"group"},i)]):null:vue.h(QSlideTransition,{duration:e.duration,onShow:Q,onHide:B},()=>vue.withDirectives(vue.h("div",{class:"q-tree__node-collapsible"+m.value,key:`${n}__q`},[c,vue.h("div",{class:"q-tree__children"+(!0===a.disabled?" q-tree__node--disabled":""),role:"group"},i)]),[[vue.vShow,a.expanded]])):c])}function A(e){const t=s[e];t&&t.focus()}function F(t,n,a,l){!0!==l&&!1!==n.selectable&&A(n.key),d.value&&n.selectable?!1===e.noSelectionUnset?o("update:selected",n.key!==e.selected?n.key:null):n.key!==e.selected&&o("update:selected",void 0===n.key?null:n.key):E(t,n,a,l),"function"===typeof t.handler&&t.handler(t)}function E(e,t,o,n){void 0!==o&&stopAndPrevent(o),!0!==n&&!1!==t.selectable&&A(t.key),k(t.key,!t.expanded,e,t)}function D(e,t){if(!0===e.indeterminate&&(t=e.indeterminateNextState),e.strictTicking)T([e.key],t);else if(e.leafTicking){const o=[],n=e=>{e.isParent?(!0!==t&&!0!==e.noTick&&!0===e.tickable&&o.push(e.key),!0===e.leafTicking&&e.children.forEach(n)):!0===e.noTick||!0!==e.tickable||!0===e.leafFilteredTicking&&!0!==e.matchesFilter||o.push(e.key)};n(e),T(o,t)}}return vue.watch(()=>e.ticked,e=>{i.value=e}),vue.watch(()=>e.expanded,e=>{u.value=e}),!0===e.defaultExpandAll&&C(),Object.assign(n,{getNodeByKey:b,getTickedNodes:y,getExpandedNodes:S,isExpanded:x,collapseAll:w,expandAll:C,setExpanded:k,isTicked:q,setTicked:T}),()=>{const t=M(e.nodes);return vue.h("div",{class:c.value,role:"tree"},0===t.length?e.filter?e.noResultsLabel||a.lang.tree.noResults:e.noNodesLabel||a.lang.tree.noNodes:t)}}});function getProgressLabel(e){return(100*e).toFixed(2)+"%"}const coreProps={...useDarkProps,...useFileProps,label:String,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,noThumbnails:Boolean,autoUpload:Boolean,hideUploadBtn:Boolean,disable:Boolean,readonly:Boolean},coreEmits=[...useFileEmits,"start","finish","added","removed"];function getRenderer(e,t){const o=vue.getCurrentInstance(),{props:n,slots:a,emit:l,proxy:r}=o,{$q:i}=r,u=useDark(n,i);function s(e,t,o){if(e.__status=t,"idle"===t)return e.__uploaded=0,e.__progress=0,e.__sizeLabel=humanStorageSize(e.size),void(e.__progressLabel="0.00%");"failed"!==t?(e.__uploaded="uploaded"===t?e.size:o,e.__progress="uploaded"===t?1:Math.min(.9999,e.__uploaded/e.size),e.__progressLabel=getProgressLabel(e.__progress),r.$forceUpdate()):r.$forceUpdate()}const c=vue.computed(()=>!0!==n.disable&&!0!==n.readonly),d=vue.ref(!1),v=vue.ref(null),p=vue.ref(null),m={files:vue.ref([]),queuedFiles:vue.ref([]),uploadedFiles:vue.ref([]),uploadedSize:vue.ref(0),updateFileStatus:s,isAlive:()=>!1===vmIsDestroyed(o)},{pickFiles:f,addFiles:h,onDragover:g,onDragleave:b,processFiles:y,getDndNode:S,maxFilesNumber:x,maxTotalSizeNumber:w}=useFile({editable:c,dnd:d,getFileInput:D,addFilesToQueue:I});Object.assign(m,e({props:n,slots:a,emit:l,helpers:m,exposeApi:e=>{Object.assign(m,e)}})),void 0===m.isBusy&&(m.isBusy=vue.ref(!1));const C=vue.ref(0),k=vue.computed(()=>0===C.value?0:m.uploadedSize.value/C.value),_=vue.computed(()=>getProgressLabel(k.value)),q=vue.computed(()=>humanStorageSize(C.value)),T=vue.computed(()=>!0===c.value&&!0!==m.isUploading.value&&(!0===n.multiple||0===m.queuedFiles.value.length)&&(void 0===n.maxFiles||m.files.value.length<x.value)&&(void 0===n.maxTotalSize||C.value<w.value)),P=vue.computed(()=>!0===c.value&&!0!==m.isBusy.value&&!0!==m.isUploading.value&&0!==m.queuedFiles.value.length);vue.provide(uploaderKey,V);const M=vue.computed(()=>"q-uploader column no-wrap"+(!0===u.value?" q-uploader--dark q-dark":"")+(!0===n.bordered?" q-uploader--bordered":"")+(!0===n.square?" q-uploader--square no-border-radius":"")+(!0===n.flat?" q-uploader--flat no-shadow":"")+(!0===n.disable?" disabled q-uploader--disable":"")+(!0===d.value?" q-uploader--dnd":"")),$=vue.computed(()=>"q-uploader__header"+(void 0!==n.color?` bg-${n.color}`:"")+(void 0!==n.textColor?` text-${n.textColor}`:""));function Q(){!1===n.disable&&(m.abort(),m.uploadedSize.value=0,C.value=0,E(),m.files.value=[],m.queuedFiles.value=[],m.uploadedFiles.value=[])}function B(){!1===n.disable&&A(["uploaded"],()=>{m.uploadedFiles.value=[]})}function R(){A(["idle","failed"],({size:e})=>{C.value-=e,m.queuedFiles.value=[]})}function A(e,t){if(!0===n.disable)return;const o={files:[],size:0},a=m.files.value.filter(t=>{return-1===e.indexOf(t.__status)||(o.size+=t.size,o.files.push(t),void 0!==t.__img&&window.URL.revokeObjectURL(t.__img.src),!1)});0!==o.files.length&&(m.files.value=a,t(o),l("removed",o.files))}function F(e){n.disable||("uploaded"===e.__status?m.uploadedFiles.value=m.uploadedFiles.value.filter(t=>t.__key!==e.__key):"uploading"===e.__status?e.__abort():C.value-=e.size,m.files.value=m.files.value.filter(t=>{return t.__key!==e.__key||(void 0!==t.__img&&window.URL.revokeObjectURL(t.__img.src),!1)}),m.queuedFiles.value=m.queuedFiles.value.filter(t=>t.__key!==e.__key),l("removed",[e]))}function E(){m.files.value.forEach(e=>{void 0!==e.__img&&window.URL.revokeObjectURL(e.__img.src)})}function D(){return p.value||v.value.getElementsByClassName("q-uploader__input")[0]}function I(e,t){const o=y(e,t,m.files.value,!0),a=D();void 0!==a&&null!==a&&(a.value=""),void 0!==o&&(o.forEach(e=>{if(m.updateFileStatus(e,"idle"),C.value+=e.size,!0!==n.noThumbnails&&e.type.toUpperCase().startsWith("IMAGE")){const t=new Image;t.src=window.URL.createObjectURL(e),e.__img=t}}),m.files.value=m.files.value.concat(o),m.queuedFiles.value=m.queuedFiles.value.concat(o),l("added",o),!0===n.autoUpload&&m.upload())}function O(){!0===P.value&&m.upload()}function z(e,t,o){if(!0===e){const e={type:"a",key:t,icon:i.iconSet.uploader[t],flat:!0,dense:!0};let n=void 0;return"add"===t?(e.onClick=f,n=V):e.onClick=o,vue.h(QBtn,e,n)}}function V(){return vue.h("input",{ref:p,class:"q-uploader__input overflow-hidden absolute-full",tabindex:-1,type:"file",title:"",accept:n.accept,multiple:!0===n.multiple?"multiple":void 0,capture:n.capture,onMousedown:stop,onClick:f,onChange:I})}function L(){return void 0!==a.header?a.header(N):[vue.h("div",{class:"q-uploader__header-content column"},[vue.h("div",{class:"flex flex-center no-wrap q-gutter-xs"},[z(0!==m.queuedFiles.value.length,"removeQueue",R),z(0!==m.uploadedFiles.value.length,"removeUploaded",B),!0===m.isUploading.value?vue.h(QSpinner,{class:"q-uploader__spinner"}):null,vue.h("div",{class:"col column justify-center"},[void 0!==n.label?vue.h("div",{class:"q-uploader__title"},[n.label]):null,vue.h("div",{class:"q-uploader__subtitle"},[q.value+" / "+_.value])]),z(T.value,"add"),z(!1===n.hideUploadBtn&&!0===P.value,"upload",m.upload),z(m.isUploading.value,"clear",m.abort)])])]}function H(){return void 0!==a.list?a.list(N):m.files.value.map(e=>vue.h("div",{key:e.__key,class:"q-uploader__file relative-position"+(!0!==n.noThumbnails&&void 0!==e.__img?" q-uploader__file--img":"")+("failed"===e.__status?" q-uploader__file--failed":"uploaded"===e.__status?" q-uploader__file--uploaded":""),style:!0!==n.noThumbnails&&void 0!==e.__img?{backgroundImage:'url("'+e.__img.src+'")'}:null},[vue.h("div",{class:"q-uploader__file-header row flex-center no-wrap"},["failed"===e.__status?vue.h(QIcon,{class:"q-uploader__file-status",name:i.iconSet.type.negative,color:"negative"}):null,vue.h("div",{class:"q-uploader__file-header-content col"},[vue.h("div",{class:"q-uploader__title"},[e.name]),vue.h("div",{class:"q-uploader__subtitle row items-center no-wrap"},[e.__sizeLabel+" / "+e.__progressLabel])]),"uploading"===e.__status?vue.h(QCircularProgress,{value:e.__progress,min:0,max:1,indeterminate:0===e.__progress}):vue.h(QBtn,{round:!0,dense:!0,flat:!0,icon:i.iconSet.uploader["uploaded"===e.__status?"done":"clear"],onClick:()=>{F(e)}})])]))}vue.watch(m.isUploading,(e,t)=>{!1===t&&!0===e?l("start"):!0===t&&!1===e&&l("finish")}),vue.onBeforeUnmount(()=>{!0===m.isUploading.value&&m.abort(),0!==m.files.value.length&&E()});const N={};for(const j in m)!0===vue.isRef(m[j])?injectProp(N,j,()=>m[j].value):N[j]=m[j];return Object.assign(N,{upload:O,reset:Q,removeUploadedFiles:B,removeQueuedFiles:R,removeFile:F,pickFiles:f,addFiles:h}),injectMultipleProps(N,{canAddFiles:()=>T.value,canUpload:()=>P.value,uploadSizeLabel:()=>q.value,uploadProgressLabel:()=>_.value}),t({...m,upload:O,reset:Q,removeUploadedFiles:B,removeQueuedFiles:R,removeFile:F,pickFiles:f,addFiles:h,canAddFiles:T,canUpload:P,uploadSizeLabel:q,uploadProgressLabel:_}),()=>{const e=[vue.h("div",{class:$.value},L()),vue.h("div",{class:"q-uploader__list scroll"},H()),S("uploader")];!0===m.isBusy.value&&e.push(vue.h("div",{class:"q-uploader__overlay absolute-full flex flex-center"},[vue.h(QSpinner)]));const t={ref:v,class:M.value};return!0===T.value&&Object.assign(t,{onDragover:g,onDragleave:b}),vue.h("div",t,e)}}const trueFn=()=>!0;function getEmitsObject(e){const t={};return e.forEach(e=>{t[e]=trueFn}),t}const coreEmitsObject=getEmitsObject(coreEmits);var createUploaderComponent=({name:e,props:t,emits:o,injectPlugin:n})=>createComponent({name:e,props:{...coreProps,...t},emits:!0===isObject(o)?{...coreEmitsObject,...o}:[...coreEmits,...o],setup(e,{expose:t}){return getRenderer(n,t)}});function getFn(e){return"function"===typeof e?e:()=>e}const props={url:[Function,String],method:{type:[Function,String],default:"POST"},fieldName:{type:[Function,String],default:()=>{return e=>e.name}},headers:[Function,Array],formFields:[Function,Array],withCredentials:[Function,Boolean],sendRaw:[Function,Boolean],batch:[Function,Boolean],factory:Function},emits$1=["factoryFailed","uploaded","failed","uploading"];function injectPlugin({props:e,emit:t,helpers:o}){const n=vue.ref([]),a=vue.ref([]),l=vue.ref(0),r=vue.computed(()=>({url:getFn(e.url),method:getFn(e.method),headers:getFn(e.headers),formFields:getFn(e.formFields),fieldName:getFn(e.fieldName),withCredentials:getFn(e.withCredentials),sendRaw:getFn(e.sendRaw),batch:getFn(e.batch)})),i=vue.computed(()=>l.value>0),u=vue.computed(()=>0!==a.value.length);let s;function c(){n.value.forEach(e=>{e.abort()}),0!==a.value.length&&(s=!0)}function d(){const e=o.queuedFiles.value.slice(0);o.queuedFiles.value=[],r.value.batch(e)?v(e):e.forEach(e=>{v([e])})}function v(n){if(l.value++,"function"!==typeof e.factory)return void p(n,{});const r=e.factory(n);if(r)if("function"===typeof r.catch&&"function"===typeof r.then){a.value.push(r);const e=e=>{!0===o.isAlive()&&(a.value=a.value.filter(e=>e!==r),0===a.value.length&&(s=!1),o.queuedFiles.value=o.queuedFiles.value.concat(n),n.forEach(e=>{o.updateFileStatus(e,"failed")}),t("factoryFailed",e,n),l.value--)};r.then(t=>{!0===s?e(new Error("Aborted")):!0===o.isAlive()&&(a.value=a.value.filter(e=>e!==r),p(n,t))}).catch(e)}else p(n,r||{});else t("factoryFailed",new Error("QUploader: factory() does not return properly"),n),l.value--}function p(e,a){const i=new FormData,u=new XMLHttpRequest,s=(e,t)=>{return void 0!==a[e]?getFn(a[e])(t):r.value[e](t)},c=s("url",e);if(!c)return console.error("q-uploader: invalid or no URL specified"),void l.value--;const d=s("formFields",e);void 0!==d&&d.forEach(e=>{i.append(e.name,e.value)});let v,p=0,m=0,f=0,h=0;u.upload.addEventListener("progress",t=>{if(!0===v)return;const n=Math.min(h,t.loaded);o.uploadedSize.value+=n-f,f=n;let a=f-m;for(let l=p;a>0&&l<e.length;l++){const t=e[l],n=a>t.size;if(!n)return void o.updateFileStatus(t,"uploading",a);a-=t.size,p++,m+=t.size,o.updateFileStatus(t,"uploading",t.size)}},!1),u.onreadystatechange=(()=>{u.readyState<4||(u.status&&u.status<400?(o.uploadedFiles.value=o.uploadedFiles.value.concat(e),e.forEach(e=>{o.updateFileStatus(e,"uploaded")}),t("uploaded",{files:e,xhr:u})):(v=!0,o.uploadedSize.value-=f,o.queuedFiles.value=o.queuedFiles.value.concat(e),e.forEach(e=>{o.updateFileStatus(e,"failed")}),t("failed",{files:e,xhr:u})),l.value--,n.value=n.value.filter(e=>e!==u))}),u.open(s("method",e),c),!0===s("withCredentials",e)&&(u.withCredentials=!0);const g=s("headers",e);void 0!==g&&g.forEach(e=>{u.setRequestHeader(e.name,e.value)});const b=s("sendRaw",e);e.forEach(e=>{o.updateFileStatus(e,"uploading",0),!0!==b&&i.append(s("fieldName",e),e,e.name),e.xhr=u,e.__abort=(()=>{u.abort()}),h+=e.size}),t("uploading",{files:e,xhr:u}),n.value.push(u),!0===b?u.send(new Blob(e)):u.send(i)}return{isUploading:i,isBusy:u,abort:c,upload:d}}var xhrUploaderPlugin={name:"QUploader",props:props,emits:emits$1,injectPlugin:injectPlugin},QUploader=createUploaderComponent(xhrUploaderPlugin),QUploaderAddTrigger=createComponent({name:"QUploaderAddTrigger",setup(){const e=vue.inject(uploaderKey,emptyRenderFn);return e===emptyRenderFn&&console.error("QUploaderAddTrigger needs to be child of QUploader"),e}}),QVideo=createComponent({name:"QVideo",props:{...useRatioProps,src:{type:String,required:!0},title:String,fetchpriority:{type:String,default:"auto"},loading:{type:String,default:"eager"},referrerpolicy:{type:String,default:"strict-origin-when-cross-origin"}},setup(e){const t=useRatio(e),o=vue.computed(()=>"q-video"+(void 0!==e.ratio?" q-video--responsive":""));return()=>vue.h("div",{class:o.value,style:t.value},[vue.h("iframe",{src:e.src,title:e.title,fetchpriority:e.fetchpriority,loading:e.loading,referrerpolicy:e.referrerpolicy,frameborder:"0",allowfullscreen:!0})])}}),components=Object.freeze({__proto__:null,QAjaxBar:QAjaxBar,QAvatar:QAvatar,QBadge:QBadge,QBanner:QBanner,QBar:QBar,QBreadcrumbs:QBreadcrumbs,QBreadcrumbsEl:QBreadcrumbsEl,QBtn:QBtn,QBtnDropdown:QBtnDropdown,QBtnGroup:QBtnGroup,QBtnToggle:QBtnToggle,QCard:QCard,QCardSection:QCardSection,QCardActions:QCardActions,QCarousel:QCarousel,QCarouselSlide:QCarouselSlide,QCarouselControl:QCarouselControl,QChatMessage:QChatMessage,QCheckbox:QCheckbox,QChip:QChip,QCircularProgress:QCircularProgress,QColor:QColor,QDate:QDate,QDialog:QDialog,QDrawer:QDrawer,QEditor:QEditor,QExpansionItem:QExpansionItem,QFab:QFab,QFabAction:QFabAction,QField:QField,QFile:QFile,QFooter:QFooter,QForm:QForm,QFormChildMixin:QFormChildMixin,QHeader:QHeader,QIcon:QIcon,QImg:QImg,QInfiniteScroll:QInfiniteScroll,QInnerLoading:QInnerLoading,QInput:QInput,QIntersection:QIntersection,QList:QList,QItem:QItem,QItemSection:QItemSection,QItemLabel:QItemLabel,QKnob:QKnob,QLayout:QLayout,QMarkupTable:QMarkupTable,QMenu:QMenu,QNoSsr:QNoSsr,QOptionGroup:QOptionGroup,QPage:QPage,QPageContainer:QPageContainer,QPageScroller:QPageScroller,QPageSticky:QPageSticky,QPagination:QPagination,QParallax:QParallax,QPopupEdit:QPopupEdit,QPopupProxy:QPopupProxy,QLinearProgress:QLinearProgress,QPullToRefresh:QPullToRefresh,QRadio:QRadio,QRange:QRange,QRating:QRating,QResizeObserver:QResizeObserver,QResponsive:QResponsive,QScrollArea:QScrollArea,QScrollObserver:QScrollObserver,QSelect:QSelect,QSeparator:QSeparator,QSkeleton:QSkeleton,QSlideItem:QSlideItem,QSlideTransition:QSlideTransition,QSlider:QSlider,QSpace:QSpace,QSpinner:QSpinner,QSpinnerAudio:QSpinnerAudio,QSpinnerBall:QSpinnerBall,QSpinnerBars:QSpinnerBars,QSpinnerBox:QSpinnerBox,QSpinnerClock:QSpinnerClock,QSpinnerComment:QSpinnerComment,QSpinnerCube:QSpinnerCube,QSpinnerDots:QSpinnerDots,QSpinnerFacebook:QSpinnerFacebook,QSpinnerGears:QSpinnerGears,QSpinnerGrid:QSpinnerGrid,QSpinnerHearts:QSpinnerHearts,QSpinnerHourglass:QSpinnerHourglass,QSpinnerInfinity:QSpinnerInfinity,QSpinnerIos:QSpinnerIos,QSpinnerOrbit:QSpinnerOrbit,QSpinnerOval:QSpinnerOval,QSpinnerPie:QSpinnerPie,QSpinnerPuff:QSpinnerPuff,QSpinnerRadio:QSpinnerRadio,QSpinnerRings:QSpinnerRings,QSpinnerTail:QSpinnerTail,QSplitter:QSplitter,QStep:QStep,QStepper:QStepper,QStepperNavigation:QStepperNavigation,QTabPanels:QTabPanels,QTabPanel:QTabPanel,QTable:QTable,QTh:QTh,QTr:QTr,QTd:QTd,QTabs:QTabs,QTab:QTab,QRouteTab:QRouteTab,QTime:QTime,QTimeline:QTimeline,QTimelineEntry:QTimelineEntry,QToggle:QToggle,QToolbar:QToolbar,QToolbarTitle:QToolbarTitle,QTooltip:QTooltip,QTree:QTree,QUploader:QUploader,QUploaderAddTrigger:QUploaderAddTrigger,QVideo:QVideo,QVirtualScroll:QVirtualScroll}),ClosePopup=createDirective({name:"close-popup",getSSRProps:getSSRProps});let id=0,offsetBase=void 0;function getAbsolutePosition(e,t){void 0===offsetBase&&(offsetBase=document.createElement("div"),offsetBase.style.cssText="position: absolute; left: 0; top: 0",document.body.appendChild(offsetBase));const o=e.getBoundingClientRect(),n=offsetBase.getBoundingClientRect(),{marginLeft:a,marginRight:l,marginTop:r,marginBottom:i}=window.getComputedStyle(e),u=parseInt(a,10)+parseInt(l,10),s=parseInt(r,10)+parseInt(i,10);return{left:o.left-n.left,top:o.top-n.top,width:o.right-o.left,height:o.bottom-o.top,widthM:o.right-o.left+(!0===t?0:u),heightM:o.bottom-o.top+(!0===t?0:s),marginH:!0===t?u:0,marginV:!0===t?s:0}}function getAbsoluteSize(e){return{width:e.scrollWidth,height:e.scrollHeight}}const styleEdges=["Top","Right","Bottom","Left"],styleBorderRadiuses=["borderTopLeftRadius","borderTopRightRadius","borderBottomRightRadius","borderBottomLeftRadius"],reStyleSkipKey=/-block|-inline|block-|inline-/,reStyleSkipRule=/(-block|-inline|block-|inline-).*:/;function getComputedStyle$1(e,t){const o=window.getComputedStyle(e),n={};for(let a=0;a<t.length;a++){const e=t[a];if(""===o[e])if("cssText"===e){const t=o.length;let a="";for(let e=0;e<t;e++)!0!==reStyleSkipKey.test(o[e])&&(a+=o[e]+": "+o[o[e]]+"; ");n[e]=a}else if(["borderWidth","borderStyle","borderColor"].indexOf(e)>-1){const t=e.replace("border","");let a="";for(let e=0;e<styleEdges.length;e++){const n="border"+styleEdges[e]+t;a+=o[n]+" "}n[e]=a}else if("borderRadius"===e){let t="",a="";for(let e=0;e<styleBorderRadiuses.length;e++){const n=o[styleBorderRadiuses[e]].split(" ");t+=n[0]+" ",a+=(void 0===n[1]?n[0]:n[1])+" "}n[e]=t+"/ "+a}else n[e]=o[e];else n[e]="cssText"===e?o[e].split(";").filter(e=>!0!==reStyleSkipRule.test(e)).join(";"):o[e]}return n}const zIndexPositions=["absolute","fixed","relative","sticky"];function getMaxZIndex(e){let t=e,o=0;while(null!==t&&t!==document){const{position:n,zIndex:a}=window.getComputedStyle(t),l=Number(a);l>o&&(t===e||!0===zIndexPositions.includes(n))&&(o=l),t=t.parentNode}return o}function normalizeElements(e){return{from:e.from,to:void 0!==e.to?e.to:e.from}}function normalizeOptions(e){return"number"===typeof e?e={duration:e}:"function"===typeof e&&(e={onEnd:e}),{...e,waitFor:void 0===e.waitFor?0:e.waitFor,duration:!0===isNaN(e.duration)?300:parseInt(e.duration,10),easing:"string"===typeof e.easing&&0!==e.easing.length?e.easing:"ease-in-out",delay:!0===isNaN(e.delay)?0:parseInt(e.delay,10),fill:"string"===typeof e.fill&&0!==e.fill.length?e.fill:"none",resize:!0===e.resize,useCSS:!0===e.useCSS||!0===e.usecss,hideFromClone:!0===e.hideFromClone||!0===e.hidefromclone,keepToClone:!0===e.keepToClone||!0===e.keeptoclone,tween:!0===e.tween,tweenFromOpacity:!0===isNaN(e.tweenFromOpacity)?.6:parseFloat(e.tweenFromOpacity),tweenToOpacity:!0===isNaN(e.tweenToOpacity)?.5:parseFloat(e.tweenToOpacity)}}function getElement(e){const t=typeof e;return"function"===t?e():"string"===t?document.querySelector(e):e}function isValidElement(e){return e&&e.ownerDocument===document&&null!==e.parentNode}function morph(e){let t=()=>!1,o=!1,n=!0;const a=normalizeElements(e),l=normalizeOptions(e),r=getElement(a.from);if(!0!==isValidElement(r))return t;"function"===typeof r.qMorphCancel&&r.qMorphCancel();let i=void 0,u=void 0,s=void 0,c=void 0;const d=r.parentNode,v=r.nextElementSibling,p=getAbsolutePosition(r,l.resize),{width:m,height:f}=getAbsoluteSize(d),{borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,backgroundColor:S,transform:x,position:w,cssText:C}=getComputedStyle$1(r,["borderWidth","borderStyle","borderColor","borderRadius","backgroundColor","transform","position","cssText"]),k=r.classList.toString(),_=r.style.cssText,q=r.cloneNode(!0),T=!0===l.tween?r.cloneNode(!0):void 0;void 0!==T&&(T.className=T.classList.toString().split(" ").filter(e=>!1===/^bg-/.test(e)).join(" ")),!0===l.hideFromClone&&q.classList.add("q-morph--internal"),q.setAttribute("aria-hidden","true"),q.style.transition="none",q.style.animation="none",q.style.pointerEvents="none",d.insertBefore(q,v),r.qMorphCancel=(()=>{o=!0,q.remove(),void 0!==T&&T.remove(),!0===l.hideFromClone&&q.classList.remove("q-morph--internal"),r.qMorphCancel=void 0});const P=()=>{const e=getElement(a.to);if(!0===o||!0!==isValidElement(e))return void("function"===typeof r.qMorphCancel&&r.qMorphCancel());r!==e&&"function"===typeof e.qMorphCancel&&e.qMorphCancel(),!0!==l.keepToClone&&e.classList.add("q-morph--internal"),q.classList.add("q-morph--internal");const{width:v,height:P}=getAbsoluteSize(d),{width:M,height:$}=getAbsoluteSize(e.parentNode);!0!==l.hideFromClone&&q.classList.remove("q-morph--internal"),e.qMorphCancel=(()=>{o=!0,q.remove(),void 0!==T&&T.remove(),!0===l.hideFromClone&&q.classList.remove("q-morph--internal"),!0!==l.keepToClone&&e.classList.remove("q-morph--internal"),r.qMorphCancel=void 0,e.qMorphCancel=void 0});const Q=()=>{if(!0===o)return void("function"===typeof e.qMorphCancel&&e.qMorphCancel());!0!==l.hideFromClone&&(q.classList.add("q-morph--internal"),q.innerHTML="",q.style.left=0,q.style.right="unset",q.style.top=0,q.style.bottom="unset",q.style.transform="none"),!0!==l.keepToClone&&e.classList.remove("q-morph--internal");const a=e.parentNode,{width:Q,height:B}=getAbsoluteSize(a),R=e.cloneNode(l.keepToClone);R.setAttribute("aria-hidden","true"),!0!==l.keepToClone&&(R.style.left=0,R.style.right="unset",R.style.top=0,R.style.bottom="unset",R.style.transform="none",R.style.pointerEvents="none"),R.classList.add("q-morph--internal");const A=e===r&&d===a?q:e.nextElementSibling;a.insertBefore(R,A);const{borderWidth:F,borderStyle:E,borderColor:D,borderRadius:I,backgroundColor:O,transform:z,position:V,cssText:L}=getComputedStyle$1(e,["borderWidth","borderStyle","borderColor","borderRadius","backgroundColor","transform","position","cssText"]),H=e.classList.toString(),N=e.style.cssText;e.style.cssText=L,e.style.transform="none",e.style.animation="none",e.style.transition="none",e.className=H.split(" ").filter(e=>!1===/^bg-/.test(e)).join(" ");const j=getAbsolutePosition(e,l.resize),K=p.left-j.left,U=p.top-j.top,W=p.width/(j.width>0?j.width:10),Y=p.height/(j.height>0?j.height:100),G=m-v,X=f-P,Z=Q-M,J=B-$,ee=Math.max(p.widthM,G),te=Math.max(p.heightM,X),oe=Math.max(j.widthM,Z),ne=Math.max(j.heightM,J),ae=r===e&&!1===["absolute","fixed"].includes(V)&&!1===["absolute","fixed"].includes(w);let le="fixed"===V,re=a;while(!0!==le&&re!==document)le="fixed"===window.getComputedStyle(re).position,re=re.parentNode;if(!0!==l.hideFromClone&&(q.style.display="block",q.style.flex="0 0 auto",q.style.opacity=0,q.style.minWidth="unset",q.style.maxWidth="unset",q.style.minHeight="unset",q.style.maxHeight="unset",q.classList.remove("q-morph--internal")),!0!==l.keepToClone&&(R.style.display="block",R.style.flex="0 0 auto",R.style.opacity=0,R.style.minWidth="unset",R.style.maxWidth="unset",R.style.minHeight="unset",R.style.maxHeight="unset"),R.classList.remove("q-morph--internal"),"string"===typeof l.classes&&(e.className+=" "+l.classes),"string"===typeof l.style)e.style.cssText+=" "+l.style;else if(!0===isObject(l.style))for(const t in l.style)e.style[t]=l.style[t];const ie=getMaxZIndex(q),ue=getMaxZIndex(e),se=!0===le?document.documentElement:{scrollLeft:0,scrollTop:0};e.style.position=!0===le?"fixed":"absolute",e.style.left=`${j.left-se.scrollLeft}px`,e.style.right="unset",e.style.top=`${j.top-se.scrollTop}px`,e.style.margin=0,!0===l.resize&&(e.style.minWidth="unset",e.style.maxWidth="unset",e.style.minHeight="unset",e.style.maxHeight="unset",e.style.overflow="hidden",e.style.overflowX="hidden",e.style.overflowY="hidden"),document.body.appendChild(e),void 0!==T&&(T.style.cssText=C,T.style.transform="none",T.style.animation="none",T.style.transition="none",T.style.position=e.style.position,T.style.left=`${p.left-se.scrollLeft}px`,T.style.right="unset",T.style.top=`${p.top-se.scrollTop}px`,T.style.margin=0,T.style.pointerEvents="none",!0===l.resize&&(T.style.minWidth="unset",T.style.maxWidth="unset",T.style.minHeight="unset",T.style.maxHeight="unset",T.style.overflow="hidden",T.style.overflowX="hidden",T.style.overflowY="hidden"),document.body.appendChild(T));const ce=o=>{r===e&&!0!==n?(e.style.cssText=_,e.className=k):(e.style.cssText=N,e.className=H),R.parentNode===a&&a.insertBefore(e,R),q.remove(),R.remove(),void 0!==T&&T.remove(),t=(()=>!1),r.qMorphCancel=void 0,e.qMorphCancel=void 0,"function"===typeof l.onEnd&&l.onEnd(!0===n?"to":"from",!0===o)};if(!0!==l.useCSS&&"function"===typeof e.animate){const a=!0===l.resize?{transform:`translate(${K}px, ${U}px)`,width:`${ee}px`,height:`${te}px`}:{transform:`translate(${K}px, ${U}px) scale(${W}, ${Y})`},d=!0===l.resize?{width:`${oe}px`,height:`${ne}px`}:{},v=!0===l.resize?{width:`${ee}px`,height:`${te}px`}:{},m=!0===l.resize?{transform:`translate(${-1*K}px, ${-1*U}px)`,width:`${oe}px`,height:`${ne}px`}:{transform:`translate(${-1*K}px, ${-1*U}px) scale(${1/W}, ${1/Y})`},f=void 0!==T?{opacity:l.tweenToOpacity}:{backgroundColor:S},w=void 0!==T?{opacity:1}:{backgroundColor:O};c=e.animate([{margin:0,borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,zIndex:ie,transformOrigin:"0 0",...a,...f},{margin:0,borderWidth:F,borderStyle:E,borderColor:D,borderRadius:I,zIndex:ue,transformOrigin:"0 0",transform:z,...d,...w}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),u=void 0===T?void 0:T.animate([{opacity:l.tweenFromOpacity,margin:0,borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,zIndex:ie,transformOrigin:"0 0",transform:x,...v},{opacity:0,margin:0,borderWidth:F,borderStyle:E,borderColor:D,borderRadius:I,zIndex:ue,transformOrigin:"0 0",...m}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),i=!0===l.hideFromClone||!0===ae?void 0:q.animate([{margin:`${X<0?X/2:0}px ${G<0?G/2:0}px`,width:`${ee+p.marginH}px`,height:`${te+p.marginV}px`},{margin:0,width:0,height:0}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),s=!0===l.keepToClone?void 0:R.animate([!0===ae?{margin:`${X<0?X/2:0}px ${G<0?G/2:0}px`,width:`${ee+p.marginH}px`,height:`${te+p.marginV}px`}:{margin:0,width:0,height:0},{margin:`${J<0?J/2:0}px ${Z<0?Z/2:0}px`,width:`${oe+j.marginH}px`,height:`${ne+j.marginV}px`}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay});const C=e=>{void 0!==i&&i.cancel(),void 0!==u&&u.cancel(),void 0!==s&&s.cancel(),c.cancel(),c.removeEventListener("finish",C),c.removeEventListener("cancel",C),ce(e),i=void 0,u=void 0,s=void 0,c=void 0};r.qMorphCancel=(()=>{r.qMorphCancel=void 0,o=!0,C()}),e.qMorphCancel=(()=>{e.qMorphCancel=void 0,o=!0,C()}),c.addEventListener("finish",C),c.addEventListener("cancel",C),t=(e=>{return!0!==o&&void 0!==c&&(!0===e?(C(!0),!0):(n=!0!==n,void 0!==i&&i.reverse(),void 0!==u&&u.reverse(),void 0!==s&&s.reverse(),c.reverse(),!0))})}else{const a=`q-morph-anim-${++id}`,i=document.createElement("style"),u=!0===l.resize?`\n            transform: translate(${K}px, ${U}px);\n            width: ${ee}px;\n            height: ${te}px;\n          `:`transform: translate(${K}px, ${U}px) scale(${W}, ${Y});`,s=!0===l.resize?`\n            width: ${oe}px;\n            height: ${ne}px;\n          `:"",c=!0===l.resize?`\n            width: ${ee}px;\n            height: ${te}px;\n          `:"",d=!0===l.resize?`\n            transform: translate(${-1*K}px, ${-1*U}px);\n            width: ${oe}px;\n            height: ${ne}px;\n          `:`transform: translate(${-1*K}px, ${-1*U}px) scale(${1/W}, ${1/Y});`,v=void 0!==T?`opacity: ${l.tweenToOpacity};`:`background-color: ${S};`,m=void 0!==T?"opacity: 1;":`background-color: ${O};`,f=void 0===T?"":`\n            @keyframes ${a}-from-tween {\n              0% {\n                opacity: ${l.tweenFromOpacity};\n                margin: 0;\n                border-width: ${h};\n                border-style: ${g};\n                border-color: ${b};\n                border-radius: ${y};\n                z-index: ${ie};\n                transform-origin: 0 0;\n                transform: ${x};\n                ${c}\n              }\n\n              100% {\n                opacity: 0;\n                margin: 0;\n                border-width: ${F};\n                border-style: ${E};\n                border-color: ${D};\n                border-radius: ${I};\n                z-index: ${ue};\n                transform-origin: 0 0;\n                ${d}\n              }\n            }\n          `,w=!0===l.hideFromClone||!0===ae?"":`\n            @keyframes ${a}-from {\n              0% {\n                margin: ${X<0?X/2:0}px ${G<0?G/2:0}px;\n                width: ${ee+p.marginH}px;\n                height: ${te+p.marginV}px;\n              }\n\n              100% {\n                margin: 0;\n                width: 0;\n                height: 0;\n              }\n            }\n          `,C=!0===ae?`\n            margin: ${X<0?X/2:0}px ${G<0?G/2:0}px;\n            width: ${ee+p.marginH}px;\n            height: ${te+p.marginV}px;\n          `:"\n            margin: 0;\n            width: 0;\n            height: 0;\n          ",k=!0===l.keepToClone?"":`\n            @keyframes ${a}-to {\n              0% {\n                ${C}\n              }\n\n              100% {\n                margin: ${J<0?J/2:0}px ${Z<0?Z/2:0}px;\n                width: ${oe+j.marginH}px;\n                height: ${ne+j.marginV}px;\n              }\n            }\n          `;i.innerHTML=`\n          @keyframes ${a} {\n            0% {\n              margin: 0;\n              border-width: ${h};\n              border-style: ${g};\n              border-color: ${b};\n              border-radius: ${y};\n              background-color: ${S};\n              z-index: ${ie};\n              transform-origin: 0 0;\n              ${u}\n              ${v}\n            }\n\n            100% {\n              margin: 0;\n              border-width: ${F};\n              border-style: ${E};\n              border-color: ${D};\n              border-radius: ${I};\n              background-color: ${O};\n              z-index: ${ue};\n              transform-origin: 0 0;\n              transform: ${z};\n              ${s}\n              ${m}\n            }\n          }\n\n          ${w}\n\n          ${f}\n\n          ${k}\n        `,document.head.appendChild(i);let _="normal";q.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-from`,void 0!==T&&(T.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-from-tween`),R.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-to`,e.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}`;const P=t=>{t===Object(t)&&t.animationName!==a||(e.removeEventListener("animationend",P),e.removeEventListener("animationcancel",P),ce(),i.remove())};r.qMorphCancel=(()=>{r.qMorphCancel=void 0,o=!0,P()}),e.qMorphCancel=(()=>{e.qMorphCancel=void 0,o=!0,P()}),e.addEventListener("animationend",P),e.addEventListener("animationcancel",P),t=(t=>{return!!(!0!==o&&e&&q&&R)&&(!0===t?(P(),!0):(n=!0!==n,_="normal"===_?"reverse":"normal",q.style.animationDirection=_,T.style.animationDirection=_,R.style.animationDirection=_,e.style.animationDirection=_,!0))})}};if(l.waitFor>0||"transitionend"===l.waitFor||l.waitFor===Object(l.waitFor)&&"function"===typeof l.waitFor.then){const t=l.waitFor>0?new Promise(e=>setTimeout(e,l.waitFor)):"transitionend"===l.waitFor?new Promise(t=>{const o=()=>{null!==n&&(clearTimeout(n),n=null),e&&(e.removeEventListener("transitionend",o),e.removeEventListener("transitioncancel",o)),t()};let n=setTimeout(o,400);e.addEventListener("transitionend",o),e.addEventListener("transitioncancel",o)}):l.waitFor;t.then(Q).catch(()=>{"function"===typeof e.qMorphCancel&&e.qMorphCancel()})}else Q()};return"function"===typeof e.onToggle&&e.onToggle(),requestAnimationFrame(P),e=>t(e)}var Morph=createDirective({name:"morph",getSSRProps:e=>{const t=!!e.arg&&e.arg.split(":")[0];return{class:t===e.value?"":"q-morph--invisible"}}}),Mutation=createDirective({name:"mutation",getSSRProps:getSSRProps}),ScrollFire=createDirective({name:"scroll-fire",getSSRProps:getSSRProps}),Scroll=createDirective({name:"scroll",getSSRProps:getSSRProps}),TouchHold=createDirective({name:"touch-hold",getSSRProps:getSSRProps});const keyCodes={esc:27,tab:9,enter:13,space:32,up:38,left:37,right:39,down:40,delete:[8,46]};new RegExp(`^([\\d+]+|${Object.keys(keyCodes).join("|")})$`,"i");var TouchRepeat=createDirective({name:"touch-repeat",getSSRProps:getSSRProps}),directives=Object.freeze({__proto__:null,ClosePopup:ClosePopup,Intersection:Intersection,Morph:Morph,Mutation:Mutation,Ripple:Ripple,ScrollFire:ScrollFire,Scroll:Scroll,TouchHold:TouchHold,TouchPan:TouchPan,TouchRepeat:TouchRepeat,TouchSwipe:TouchSwipe});function getCssVar(e,t=document.body){if("string"!==typeof e)throw new TypeError("Expected a string as propName");if(!(t instanceof Element))throw new TypeError("Expected a DOM element");return getComputedStyle(t).getPropertyValue(`--q-${e}`).trim()||null}var AddressbarColor={set:noop,install({$q:e}){e.addressbarColor=this,e.config.addressbarColor&&this.set(e.config.addressbarColor)}};function assignFn(e){Object.assign(Plugin$6,{request:e,exit:e,toggle:e})}const Plugin$6=defineReactivePlugin({isActive:!1,activeEl:null},{isCapable:!1,install({$q:e}){e.fullscreen=this}});assignFn(()=>Promise.resolve());const Plugin$5=defineReactivePlugin({appVisible:!0},{install({$q:e}){this.appVisible=e.appVisible=!0}});createComponent({name:"BottomSheetPlugin",props:{...useDarkProps,title:String,message:String,actions:Array,grid:Boolean,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},emits:["ok","hide"],setup(e,{emit:t}){const{proxy:o}=vue.getCurrentInstance(),n=useDark(e,o.$q),a=vue.ref(null);function l(){a.value.show()}function r(){a.value.hide()}function i(e){t("ok",e),r()}function u(){t("hide")}function s(){return e.actions.map(e=>{const t=e.avatar||e.img;return void 0===e.label?vue.h(QSeparator,{class:"col-all",dark:n.value}):vue.h("div",{class:["q-bottom-sheet__item q-hoverable q-focusable cursor-pointer relative-position",e.class],style:e.style,tabindex:0,role:"listitem",onClick(){i(e)},onKeyup(t){13===t.keyCode&&i(e)}},[vue.h("div",{class:"q-focus-helper"}),e.icon?vue.h(QIcon,{name:e.icon,color:e.color}):t?vue.h("img",{class:e.avatar?"q-bottom-sheet__avatar":"",src:t}):vue.h("div",{class:"q-bottom-sheet__empty-icon"}),vue.h("div",e.label)])})}function c(){return e.actions.map(e=>{const t=e.avatar||e.img;return void 0===e.label?vue.h(QSeparator,{spaced:!0,dark:n.value}):vue.h(QItem,{class:["q-bottom-sheet__item",e.classes],style:e.style,tabindex:0,clickable:!0,dark:n.value,onClick(){i(e)}},()=>[vue.h(QItemSection,{avatar:!0},()=>e.icon?vue.h(QIcon,{name:e.icon,color:e.color}):t?vue.h("img",{class:e.avatar?"q-bottom-sheet__avatar":"",src:t}):null),vue.h(QItemSection,()=>e.label)])})}function d(){const t=[];return e.title&&t.push(vue.h(QCardSection,{class:"q-dialog__title"},()=>e.title)),e.message&&t.push(vue.h(QCardSection,{class:"q-dialog__message"},()=>e.message)),t.push(!0===e.grid?vue.h("div",{class:"row items-stretch justify-start",role:"list"},s()):vue.h("div",{role:"list"},c())),t}function v(){return[vue.h(QCard,{class:[`q-bottom-sheet q-bottom-sheet--${!0===e.grid?"grid":"list"}`+(!0===n.value?" q-bottom-sheet--dark q-dark":""),e.cardClass],style:e.cardStyle},d)]}return Object.assign(o,{show:l,hide:r}),()=>vue.h(QDialog,{ref:a,position:"bottom",onHide:u},v)}});const ssrAPI={onOk:()=>ssrAPI,onCancel:()=>ssrAPI,onDismiss:()=>ssrAPI,hide:()=>ssrAPI,update:()=>ssrAPI};function globalDialog(e,t,o){return e=>{return ssrAPI}}var BottomSheet={install({$q:e,parentApp:t}){e.bottomSheet=globalDialog(),!0!==this.__installed&&(this.create=e.bottomSheet)}};function encode(e){return encodeURIComponent(e)}function decode(e){return decodeURIComponent(e)}function stringifyCookieValue(e){return encode(e===Object(e)?JSON.stringify(e):""+e)}function read(e){if(""===e)return e;0===e.indexOf('"')&&(e=e.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\")),e=decode(e.replace(/\+/g," "));try{const t=JSON.parse(e);t!==Object(t)&&!0!==Array.isArray(t)||(e=t)}catch(e){}return e}function getString(e){const t=new Date;return t.setMilliseconds(t.getMilliseconds()+e),t.toUTCString()}function parseExpireString(e){let t=0;const o=e.match(/(\d+)d/),n=e.match(/(\d+)h/),a=e.match(/(\d+)m/),l=e.match(/(\d+)s/);return o&&(t+=864e5*o[1]),n&&(t+=36e5*n[1]),a&&(t+=6e4*a[1]),l&&(t+=1e3*l[1]),0===t?e:getString(t)}function set(e,t,o={},n){let a,l;void 0!==o.expires&&("[object Date]"===Object.prototype.toString.call(o.expires)?a=o.expires.toUTCString():"string"===typeof o.expires?a=parseExpireString(o.expires):(l=parseFloat(o.expires),a=!1===isNaN(l)?getString(864e5*l):o.expires));const r=`${encode(e)}=${stringifyCookieValue(t)}`,i=[r,void 0!==a?"; Expires="+a:"",o.path?"; Path="+o.path:"",o.domain?"; Domain="+o.domain:"",o.sameSite?"; SameSite="+o.sameSite:"",o.httpOnly?"; HttpOnly":"",o.secure?"; Secure":"",o.other?"; "+o.other:""].join("");if(n){n.req.qCookies?n.req.qCookies.push(i):n.req.qCookies=[i],n.res.setHeader("Set-Cookie",n.req.qCookies);let t=n.req.headers.cookie||"";if(void 0!==a&&l<0){const o=get(e,n);void 0!==o&&(t=t.replace(`${e}=${o}; `,"").replace(`; ${e}=${o}`,"").replace(`${e}=${o}`,""))}else t=t?`${r}; ${t}`:i;n.req.headers.cookie=t}else document.cookie=i}function get(e,t){const o=t?t.req.headers:document,n=o.cookie?o.cookie.split("; "):[],a=n.length;let l,r,i,u=e?null:{},s=0;for(;s<a;s++)if(l=n[s].split("="),r=decode(l.shift()),i=l.join("="),e){if(e===r){u=read(i);break}}else u[r]=i;return u}function remove(e,t,o){set(e,"",{expires:-1,...t},o)}function has(e,t){return null!==get(e,t)}function getObject(e){return{get:t=>get(t,e),set:(t,o,n)=>set(t,o,n,e),has:t=>has(t,e),remove:(t,o)=>remove(t,o,e),getAll:()=>get(null,e)}}const Plugin$4={install({$q:e,ssrContext:t}){e.cookies=getObject(t)},parseSSR:e=>{if(void 0!==e)return getObject(e)}};createComponent({name:"DialogPlugin",props:{...useDarkProps,title:String,message:String,prompt:Object,options:Object,progress:[Boolean,Object],html:Boolean,ok:{type:[String,Object,Boolean],default:!0},cancel:[String,Object,Boolean],focus:{type:String,default:"ok",validator:e=>["ok","cancel","none"].includes(e)},stackButtons:Boolean,color:String,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},emits:["ok","hide"],setup(e,{emit:t}){const{proxy:o}=vue.getCurrentInstance(),{$q:n}=o,a=useDark(e,n),l=vue.ref(null),r=vue.ref(void 0!==e.prompt?e.prompt.model:void 0!==e.options?e.options.model:void 0),i=vue.computed(()=>"q-dialog-plugin"+(!0===a.value?" q-dialog-plugin--dark q-dark":"")+(!1!==e.progress?" q-dialog-plugin--progress":"")),u=vue.computed(()=>e.color||(!0===a.value?"amber":"primary")),s=vue.computed(()=>!1===e.progress?null:!0===isObject(e.progress)?{component:e.progress.spinner||QSpinner,props:{color:e.progress.color||u.value}}:{component:QSpinner,props:{color:u.value}}),c=vue.computed(()=>void 0!==e.prompt||void 0!==e.options),d=vue.computed(()=>{if(!0!==c.value)return{};const{model:t,isValid:o,items:n,...a}=void 0!==e.prompt?e.prompt:e.options;return a}),v=vue.computed(()=>!0===isObject(e.ok)?n.lang.label.ok:!0===e.ok?n.lang.label.ok:e.ok),p=vue.computed(()=>!0===isObject(e.cancel)?n.lang.label.cancel:!0===e.cancel?n.lang.label.cancel:e.cancel),m=vue.computed(()=>{return void 0!==e.prompt?void 0!==e.prompt.isValid&&!0!==e.prompt.isValid(r.value):void 0!==e.options&&(void 0!==e.options.isValid&&!0!==e.options.isValid(r.value))}),f=vue.computed(()=>({color:u.value,label:v.value,ripple:!1,disable:m.value,...!0===isObject(e.ok)?e.ok:{flat:!0},"data-autofocus":"ok"===e.focus&&!0!==c.value||void 0,onClick:y})),h=vue.computed(()=>({color:u.value,label:p.value,ripple:!1,...!0===isObject(e.cancel)?e.cancel:{flat:!0},"data-autofocus":"cancel"===e.focus&&!0!==c.value||void 0,onClick:S}));function g(){l.value.show()}function b(){l.value.hide()}function y(){t("ok",vue.toRaw(r.value)),b()}function S(){b()}function x(){t("hide")}function w(e){r.value=e}function C(t){!0!==m.value&&"textarea"!==e.prompt.type&&!0===isKeyCode(t,13)&&y()}function k(t,o){return!0===e.html?vue.h(QCardSection,{class:t,innerHTML:o}):vue.h(QCardSection,{class:t},()=>o)}function _(){return[vue.h(QInput,{color:u.value,dense:!0,autofocus:!0,dark:a.value,...d.value,modelValue:r.value,"onUpdate:modelValue":w,onKeyup:C})]}function q(){return[vue.h(QOptionGroup,{color:u.value,options:e.options.items,dark:a.value,...d.value,modelValue:r.value,"onUpdate:modelValue":w})]}function T(){const t=[];return e.cancel&&t.push(vue.h(QBtn,h.value)),e.ok&&t.push(vue.h(QBtn,f.value)),vue.h(QCardActions,{class:!0===e.stackButtons?"items-end":"",vertical:e.stackButtons,align:"right"},()=>t)}function P(){const t=[];return e.title&&t.push(k("q-dialog__title",e.title)),!1!==e.progress&&t.push(vue.h(QCardSection,{class:"q-dialog__progress"},()=>vue.h(s.value.component,s.value.props))),e.message&&t.push(k("q-dialog__message",e.message)),void 0!==e.prompt?t.push(vue.h(QCardSection,{class:"scroll q-dialog-plugin__form"},_)):void 0!==e.options&&t.push(vue.h(QSeparator,{dark:a.value}),vue.h(QCardSection,{class:"scroll q-dialog-plugin__form"},q),vue.h(QSeparator,{dark:a.value})),(e.ok||e.cancel)&&t.push(T()),t}function M(){return[vue.h(QCard,{class:[i.value,e.cardClass],style:e.cardStyle,dark:a.value},P)]}return vue.watch(()=>e.prompt&&e.prompt.model,w),vue.watch(()=>e.options&&e.options.model,w),Object.assign(o,{show:g,hide:b}),()=>vue.h(QDialog,{ref:l,onHide:x},M)}});var Dialog={install({$q:e,parentApp:t}){e.dialog=globalDialog(),!0!==this.__installed&&(this.create=e.dialog)}};vue.ref(null);const Plugin$3=defineReactivePlugin({isActive:!1},{start:noop,stop:noop,increment:noop,setDefaults:noop,install({$q:e,parentApp:t}){e.loadingBar=this}}),Plugin$2=defineReactivePlugin({isActive:!1},{show(e){},hide(e){},setDefaults(e){},install({$q:e,parentApp:t}){e.loading=this}});function normalize(e){e.title&&(e.title=e.titleTemplate?e.titleTemplate(e.title):e.title,delete e.titleTemplate),[["meta","content"],["link","href"]].forEach(t=>{const o=e[t[0]],n=t[1];for(const e in o){const t=o[e];t.template&&(1===Object.keys(t).length?delete o[e]:(t[n]=t.template(t[n]||""),delete t.template))}})}function bodyFilter(e){return!1===["class","style"].includes(e)}function htmlFilter(e){return!1===["lang","dir"].includes(e)}function getAttr(e){return t=>{const o=e[t];return t+(!0!==o&&void 0!==o?`="${o}"`:"")}}function getHead(e){let t="";return e.title&&(t+=`<title>${e.title}</title>`),["meta","link","script"].forEach(o=>{const n=e[o];for(const e in n){const a=Object.keys(n[e]).filter(e=>"innerHTML"!==e).map(getAttr(n[e]));t+=`<${o} ${a.join(" ")} data-qmeta="${e}">`,"script"===o&&(t+=(n[e].innerHTML||"")+"<\/script>")}}),t}function injectServerMeta(e){const t={title:"",titleTemplate:null,meta:{},link:{},htmlAttr:{},bodyAttr:{},noscript:{}},o=e.__qMetaList;for(let i=0;i<o.length;i++)extend(!0,t,o[i]);normalize(t);const n=void 0!==e.nonce?` nonce="${e.nonce}"`:"",a=e._meta,l=Object.keys(t.htmlAttr).filter(htmlFilter);0!==l.length&&(a.htmlAttrs+=(0!==a.htmlAttrs.length?" ":"")+l.map(getAttr(t.htmlAttr)).join(" ")),a.headTags+=getHead(t);const r=Object.keys(t.bodyAttr).filter(bodyFilter);0!==r.length&&(a.bodyAttrs+=(0!==a.bodyAttrs.length?" ":"")+r.map(getAttr(t.bodyAttr)).join(" ")),a.bodyTags+=Object.keys(t.noscript).map(e=>`<noscript data-qmeta="${e}">${t.noscript[e]}</noscript>`).join("")+`<script${n} id="qmeta-init">window.__Q_META__=${delete t.noscript&&JSON.stringify(t)}<\/script>`}var Meta={install(e){{const{ssrContext:t}=e;t.__qMetaList=[],t.onRendered(()=>{injectServerMeta(t)})}}},Notify={setDefaults(e){},registerType(e,t){},install({$q:e,parentApp:t}){e.notify=this.create=noop,e.notify.setDefaults=this.setDefaults,e.notify.registerType=this.registerType,void 0!==e.config.notify&&this.setDefaults(e.config.notify)}};function getEmptyStorage(){const e=()=>null;return{has:()=>!1,getLength:()=>0,getItem:e,getIndex:e,getKey:e,getAll:()=>{},getAllKeys:()=>[],set:noop,remove:noop,clear:noop,isEmpty:()=>!0}}const storage$1=getEmptyStorage(),Plugin$1={install({$q:e}){e.localStorage=storage$1}};Object.assign(Plugin$1,storage$1);const storage=getEmptyStorage(),Plugin={install({$q:e}){e.sessionStorage=storage}};function useDialogPluginComponent(){const{emit:e,proxy:t}=vue.getCurrentInstance(),o=vue.ref(null);function n(){o.value.show()}function a(){o.value.hide()}function l(t){e("ok",t),a()}function r(){e("hide")}return Object.assign(t,{show:n,hide:a}),{dialogRef:o,onDialogHide:r,onDialogOK:l,onDialogCancel:a}}Object.assign(Plugin,storage);const emits=["ok","hide"];function useMeta(e){{const t=vue.useSSRContext();t.__qMetaList.push("function"===typeof e?e():e)}}function useQuasar(){return vue.inject(quasarKey)}function fallback(e){const t=document.createElement("textarea");t.value=e,t.contentEditable="true",t.style.position="fixed";const o=()=>{};addFocusout(o),document.body.appendChild(t),t.focus(),t.select();const n=document.execCommand("copy");return t.remove(),removeFocusout(o),n}function copyToClipboard(e){return void 0!==navigator.clipboard?navigator.clipboard.writeText(e):new Promise((t,o)=>{const n=fallback(e);n?t(!0):o(n)})}useDialogPluginComponent.emits=emits,useDialogPluginComponent.emitsObject=getEmitsObject(emits);var createMetaMixin=e=>{return{created:"function"===typeof e?function(){this.ssrContext.__qMetaList.push(e.call(this)||{})}:function(){this.ssrContext.__qMetaList.push(e)}}};class EventBus{constructor(){this.__stack={}}on(e,t,o){return(this.__stack[e]||(this.__stack[e]=[])).push({fn:t,ctx:o}),this}once(e,t,o){const n=(...a)=>{this.off(e,n),t.apply(o,a)};return n.__callback=t,this.on(e,n,o)}emit(e){const t=this.__stack[e];if(void 0!==t){const e=[].slice.call(arguments,1);t.forEach(t=>{t.fn.apply(t.ctx,e)})}return this}off(e,t){const o=this.__stack[e];if(void 0===o)return this;if(void 0===t)return delete this.__stack[e],this;const n=o.filter(e=>e.fn!==t&&e.fn.__callback!==t);return 0!==n.length?this.__stack[e]=n:delete this.__stack[e],this}}function clean(e){setTimeout(()=>{window.URL.revokeObjectURL(e.href)},1e4),e.remove()}function exportFile(e,t,o={}){const{mimeType:n,byteOrderMark:a,encoding:l}="string"===typeof o?{mimeType:o}:o,r=void 0!==l?new TextEncoder(l).encode([t]):t,i=void 0!==a?[a,r]:[r],u=new Blob(i,{type:n||"application/octet-stream"}),s=document.createElement("a");s.href=window.URL.createObjectURL(u),s.setAttribute("download",e),"undefined"===typeof s.download&&s.setAttribute("target","_blank"),s.classList.add("hidden"),s.style.position="fixed",document.body.appendChild(s);try{return s.click(),clean(s),!0}catch(e){return clean(s),e}}function parseFeatures(e){const t=Object.assign({noopener:!0},e),o=[];for(const n in t){const e=t[n];!0===e?o.push(n):(isNumber(e)||"string"===typeof e&&""!==e)&&o.push(n+"="+e)}return o.join(",")}function openWindow(e,t,o){let n=window.open;if(!0===Platform.is.cordova)if(void 0!==cordova&&void 0!==cordova.InAppBrowser&&void 0!==cordova.InAppBrowser.open)n=cordova.InAppBrowser.open;else if(void 0!==navigator&&void 0!==navigator.app)return navigator.app.loadUrl(e,{openExternal:!0});const a=n(e,"_blank",parseFeatures(o));if(a)return Platform.is.desktop&&a.focus(),a;t&&t()}var openUrl=(e,t,o)=>{if(!0!==Platform.is.ios||void 0===window.SafariViewController)return openWindow(e,t,o);window.SafariViewController.isAvailable(n=>{n?window.SafariViewController.show({url:e},noop,t):openWindow(e,t,o)})};function parsePromises(e){const t=Array.isArray(e);if(!0===t){const o=e.length;return{isList:t,totalJobs:o,resultAggregator:Array(o).fill(null)}}const o=Object.keys(e),n={};return o.forEach(e=>{n[e]=null}),{isList:t,totalJobs:o.length,resultAggregator:n,resultKeys:o}}function runSequentialPromises(e,{threadsNumber:t=1,abortOnFail:o=!0}={}){let n=-1,a=!1;const{isList:l,totalJobs:r,resultAggregator:i,resultKeys:u}=parsePromises(e),s=()=>new Promise((t,s)=>{function c(){const d=++n;if(!0===a||d>=r)return void t();const v=!0===l?d:u[d];e[v](i).then(e=>{!0!==a?(i[v]={key:v,status:"fulfilled",value:e},setTimeout(c)):t()}).catch(e=>{if(!0===a)return void t();const n={key:v,status:"rejected",reason:e};if(i[v]=n,!0===o)return a=!0,void s({...n,resultAggregator:i});setTimeout(c)})}c()}),c=Array(t).fill(s());return Promise.all(c).then(()=>i)}const Quasar={version:"2.14.0",install(e,t,o){installQuasar(e,{components:components,directives:directives,...t},o)},lang:Plugin$8,iconSet:Plugin$7};exports.AddressbarColor=AddressbarColor,exports.AppFullscreen=Plugin$6,exports.AppVisibility=Plugin$5,exports.BottomSheet=BottomSheet,exports.ClosePopup=ClosePopup,exports.Cookies=Plugin$4,exports.Dark=Plugin$9,exports.Dialog=Dialog,exports.EventBus=EventBus,exports.Intersection=Intersection,exports.Loading=Plugin$2,exports.LoadingBar=Plugin$3,exports.LocalStorage=Plugin$1,exports.Meta=Meta,exports.Morph=Morph,exports.Mutation=Mutation,exports.Notify=Notify,exports.Platform=Platform,exports.QAjaxBar=QAjaxBar,exports.QAvatar=QAvatar,exports.QBadge=QBadge,exports.QBanner=QBanner,exports.QBar=QBar,exports.QBreadcrumbs=QBreadcrumbs,exports.QBreadcrumbsEl=QBreadcrumbsEl,exports.QBtn=QBtn,exports.QBtnDropdown=QBtnDropdown,exports.QBtnGroup=QBtnGroup,exports.QBtnToggle=QBtnToggle,exports.QCard=QCard,exports.QCardActions=QCardActions,exports.QCardSection=QCardSection,exports.QCarousel=QCarousel,exports.QCarouselControl=QCarouselControl,exports.QCarouselSlide=QCarouselSlide,exports.QChatMessage=QChatMessage,exports.QCheckbox=QCheckbox,exports.QChip=QChip,exports.QCircularProgress=QCircularProgress,exports.QColor=QColor,exports.QDate=QDate,exports.QDialog=QDialog,exports.QDrawer=QDrawer,exports.QEditor=QEditor,exports.QExpansionItem=QExpansionItem,exports.QFab=QFab,exports.QFabAction=QFabAction,exports.QField=QField,exports.QFile=QFile,exports.QFooter=QFooter,exports.QForm=QForm,exports.QFormChildMixin=QFormChildMixin,exports.QHeader=QHeader,exports.QIcon=QIcon,exports.QImg=QImg,exports.QInfiniteScroll=QInfiniteScroll,exports.QInnerLoading=QInnerLoading,exports.QInput=QInput,exports.QIntersection=QIntersection,exports.QItem=QItem,exports.QItemLabel=QItemLabel,exports.QItemSection=QItemSection,exports.QKnob=QKnob,exports.QLayout=QLayout,exports.QLinearProgress=QLinearProgress,exports.QList=QList,exports.QMarkupTable=QMarkupTable,exports.QMenu=QMenu,exports.QNoSsr=QNoSsr,exports.QOptionGroup=QOptionGroup,exports.QPage=QPage,exports.QPageContainer=QPageContainer,exports.QPageScroller=QPageScroller,exports.QPageSticky=QPageSticky,exports.QPagination=QPagination,exports.QParallax=QParallax,exports.QPopupEdit=QPopupEdit,exports.QPopupProxy=QPopupProxy,exports.QPullToRefresh=QPullToRefresh,exports.QRadio=QRadio,exports.QRange=QRange,exports.QRating=QRating,exports.QResizeObserver=QResizeObserver,exports.QResponsive=QResponsive,exports.QRouteTab=QRouteTab,exports.QScrollArea=QScrollArea,exports.QScrollObserver=QScrollObserver,exports.QSelect=QSelect,exports.QSeparator=QSeparator,exports.QSkeleton=QSkeleton,exports.QSlideItem=QSlideItem,exports.QSlideTransition=QSlideTransition,exports.QSlider=QSlider,exports.QSpace=QSpace,exports.QSpinner=QSpinner,exports.QSpinnerAudio=QSpinnerAudio,exports.QSpinnerBall=QSpinnerBall,exports.QSpinnerBars=QSpinnerBars,exports.QSpinnerBox=QSpinnerBox,exports.QSpinnerClock=QSpinnerClock,exports.QSpinnerComment=QSpinnerComment,exports.QSpinnerCube=QSpinnerCube,exports.QSpinnerDots=QSpinnerDots,exports.QSpinnerFacebook=QSpinnerFacebook,exports.QSpinnerGears=QSpinnerGears,exports.QSpinnerGrid=QSpinnerGrid,exports.QSpinnerHearts=QSpinnerHearts,exports.QSpinnerHourglass=QSpinnerHourglass,exports.QSpinnerInfinity=QSpinnerInfinity,exports.QSpinnerIos=QSpinnerIos,exports.QSpinnerOrbit=QSpinnerOrbit,exports.QSpinnerOval=QSpinnerOval,exports.QSpinnerPie=QSpinnerPie,exports.QSpinnerPuff=QSpinnerPuff,exports.QSpinnerRadio=QSpinnerRadio,exports.QSpinnerRings=QSpinnerRings,exports.QSpinnerTail=QSpinnerTail,exports.QSplitter=QSplitter,exports.QStep=QStep,exports.QStepper=QStepper,exports.QStepperNavigation=QStepperNavigation,exports.QTab=QTab,exports.QTabPanel=QTabPanel,exports.QTabPanels=QTabPanels,exports.QTable=QTable,exports.QTabs=QTabs,exports.QTd=QTd,exports.QTh=QTh,exports.QTime=QTime,exports.QTimeline=QTimeline,exports.QTimelineEntry=QTimelineEntry,exports.QToggle=QToggle,exports.QToolbar=QToolbar,exports.QToolbarTitle=QToolbarTitle,exports.QTooltip=QTooltip,exports.QTr=QTr,exports.QTree=QTree,exports.QUploader=QUploader,exports.QUploaderAddTrigger=QUploaderAddTrigger,exports.QVideo=QVideo,exports.QVirtualScroll=QVirtualScroll,exports.Quasar=Quasar,exports.Ripple=Ripple,exports.Screen=Screen,exports.Scroll=Scroll,exports.ScrollFire=ScrollFire,exports.SessionStorage=Plugin,exports.TouchHold=TouchHold,exports.TouchPan=TouchPan,exports.TouchRepeat=TouchRepeat,exports.TouchSwipe=TouchSwipe,exports.clone=cloneDeep,exports.colors=colors,exports.copyToClipboard=copyToClipboard,exports.createMetaMixin=createMetaMixin,exports.createUploaderComponent=createUploaderComponent,exports.date=date,exports.debounce=debounce,exports.dom=dom,exports.event=event,exports.exportFile=exportFile,exports.extend=extend,exports.format=format,exports.frameDebounce=frameDebounce,exports.getCssVar=getCssVar,exports.is=is,exports.morph=morph,exports.noop=noop,exports.openURL=openUrl,exports.patterns=patterns,exports.runSequentialPromises=runSequentialPromises,exports.scroll=scroll,exports.setCssVar=setCssVar,exports.throttle=throttle,exports.uid=uid,exports.useDialogPluginComponent=useDialogPluginComponent,exports.useFormChild=useFormChild,exports.useMeta=useMeta,exports.useQuasar=useQuasar;