export default {
  isoName: 'sq',
  nativeName: 'Shqip',
  label: {
    clear: 'Pastro',
    ok: 'OK',
    cancel: 'Anulo',
    close: 'Mbyll',
    set: 'Vendos',
    select: 'Zgjidh',
    reset: 'Rivendos',
    remove: 'Hiq',
    update: 'Përditëso',
    create: 'Krijo',
    search: 'Kërko',
    filter: 'Filtro',
    refresh: 'Rifresko',
    expand: label => (label ? `Zgjero "${ label }"` : 'Zgjero'),
    collapse: label => (label ? `Tkur "${ label }"` : 'Tkur')
  },
  date: {
    days: 'E diel_E hënë_E martë_E mërkurë_E enjte_E premte_E shtunë'.split('_'),
    daysShort: 'Die_Hën_Mar_Mër_Enj_Pre_Sht'.split('_'),
    months: 'Janar_Shkurt_Mars_Pril_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor'.split('_'),
    monthsShort: 'Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj'.split('_'),
    firstDayOfWeek: 1,
    format24h: true,
    pluralDay: 'ditë',
    prevMonth: 'Muaji i kaluar',
    nextMonth: 'Muaji i ardhshëm',
    prevYear: 'Viti i kaluar',
    nextYear: 'Viti i ardhshëm',
    today: 'Sot',
    prevRangeYears: range => `Vitet e mëparshme ${ range }`,
    nextRangeYears: range => `Vitet e ardhshme ${ range }`
  },
  table: {
    noData: 'Nuk ka të dhëna',
    noResults: 'Nuk u gjetën rezultate',
    loading: 'Duke ngarkuar...',
    selectedRecords: rows => (
      rows === 1
        ? '1 regjistrim i përzgjedhur.'
        : (rows === 0 ? 'Asnjë' : rows) + ' regjistrime të përzgjedhura.'
    ),
    recordsPerPage: 'Regjistrime për faqe:',
    allRows: 'Të gjitha',
    pagination: (start, end, total) => `${start}-${end} nga ${total}`,
    columns: 'Kolonat'
  },
  pagination: {
    first: 'Faqja e parë',
    prev: 'Faqja e mëparshme',
    next: 'Faqja tjetër',
    last: 'Faqja e fundit'
  },
  editor: {
    url: 'URL',
    bold: 'Trash',
    italic: 'Pjerrët',
    strikethrough: 'Vijë në mes',
    underline: 'Nënvizuar',
    unorderedList: 'Listë pa rend',
    orderedList: 'Listë e renditur',
    subscript: 'Nënshkrim',
    superscript: 'Supershkrim',
    hyperlink: 'Lidhje',
    toggleFullscreen: 'Ndrysho ekranin e plotë',
    quote: 'Citim',
    left: 'Rreshto majtas',
    center: 'Rreshto në qendër',
    right: 'Rreshto djathtas',
    justify: 'Justifiko',
    print: 'Printo',
    outdent: 'Zvogëlo indentimin',
    indent: 'Rrit indentimin',
    removeFormat: 'Hiq formatimin',
    formatting: 'Formatimi',
    fontSize: 'Madhësia e shkronjave',
    align: 'Rreshtimi',
    hr: 'Shto vijë horizontale',
    undo: 'Zhbëj',
    redo: 'Ribëj',
    heading1: 'Titulli 1',
    heading2: 'Titulli 2',
    heading3: 'Titulli 3',
    heading4: 'Titulli 4',
    heading5: 'Titulli 5',
    heading6: 'Titulli 6',
    paragraph: 'Paragraf',
    code: 'Kod',
    size1: 'Shumë i vogël',
    size2: 'Pak i vogël',
    size3: 'Normal',
    size4: 'Mesatar',
    size5: 'I madh',
    size6: 'Shumë i madh',
    size7: 'Maksimal',
    defaultFont: 'Shkronja e parazgjedhur',
    viewSource: 'Shiko burimin'
  },
  tree: {
    noNodes: 'Nuk ka nyje të disponueshme',
    noResults: 'Nuk u gjetën nyje përputhëse'
  }
}
