/*!
 * Quasar Framework v2.5.3
 * (c) 2015-present Razvan Stoenescu
 * Released under the MIT License.
 */
import{ref,reactive,createApp,markRaw,defineComponent,getCurrentInstance,computed,onMounted,onBeforeUnmount,h,withDirectives,isRef,Transition,nextTick,watch,onUnmounted,Teleport,KeepAlive,onBeforeMount,provide,onDeactivated,onActivated,inject,onBeforeUpdate,shallowReactive,vShow,onUpdated,toRaw,TransitionGroup}from"vue";function injectProp(e,t,o,n){Object.defineProperty(e,t,{get:o,set:n,enumerable:!0})}function injectMultipleProps(e,t){for(const o in t)injectProp(e,o,t[o])}const isRuntimeSsrPreHydration=ref(!1);let iosCorrection;function getMatch(e,t){const o=/(edg|edge|edga|edgios)\/([\w.]+)/.exec(e)||/(opr)[\/]([\w.]+)/.exec(e)||/(vivaldi)[\/]([\w.]+)/.exec(e)||/(chrome|crios)[\/]([\w.]+)/.exec(e)||/(version)(applewebkit)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(e)||/(webkit)[\/]([\w.]+).*(version)[\/]([\w.]+).*(safari)[\/]([\w.]+)/.exec(e)||/(firefox|fxios)[\/]([\w.]+)/.exec(e)||/(webkit)[\/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[\/]([\w.]+)/.exec(e)||[];return{browser:o[5]||o[3]||o[1]||"",version:o[2]||o[4]||"0",versionNumber:o[4]||o[2]||"0",platform:t[0]||""}}function getPlatformMatch(e){return/(ipad)/.exec(e)||/(ipod)/.exec(e)||/(windows phone)/.exec(e)||/(iphone)/.exec(e)||/(kindle)/.exec(e)||/(silk)/.exec(e)||/(android)/.exec(e)||/(win)/.exec(e)||/(mac)/.exec(e)||/(linux)/.exec(e)||/(cros)/.exec(e)||/(playbook)/.exec(e)||/(bb)/.exec(e)||/(blackberry)/.exec(e)||[]}const hasTouch="ontouchstart"in window||window.navigator.maxTouchPoints>0;function applyIosCorrection(e){iosCorrection={is:{...e}},delete e.mac,delete e.desktop;const t=Math.min(window.innerHeight,window.innerWidth)>414?"ipad":"iphone";Object.assign(e,{mobile:!0,ios:!0,platform:t,[t]:!0})}function getPlatform(e){const t=e.toLowerCase(),o=getPlatformMatch(t),n=getMatch(t,o),a={};n.browser&&(a[n.browser]=!0,a.version=n.version,a.versionNumber=parseInt(n.versionNumber,10)),n.platform&&(a[n.platform]=!0);const l=a.android||a.ios||a.bb||a.blackberry||a.ipad||a.iphone||a.ipod||a.kindle||a.playbook||a.silk||a["windows phone"];return!0===l||t.indexOf("mobile")>-1?(a.mobile=!0,a.edga||a.edgios?(a.edge=!0,n.browser="edge"):a.crios?(a.chrome=!0,n.browser="chrome"):a.fxios&&(a.firefox=!0,n.browser="firefox")):a.desktop=!0,(a.ipod||a.ipad||a.iphone)&&(a.ios=!0),a["windows phone"]&&(a.winphone=!0,delete a["windows phone"]),(a.chrome||a.opr||a.safari||a.vivaldi||!0===a.mobile&&!0!==a.ios&&!0!==l)&&(a.webkit=!0),a.edg&&(n.browser="edgechromium",a.edgeChromium=!0),(a.safari&&a.blackberry||a.bb)&&(n.browser="blackberry",a.blackberry=!0),a.safari&&a.playbook&&(n.browser="playbook",a.playbook=!0),a.opr&&(n.browser="opera",a.opera=!0),a.safari&&a.android&&(n.browser="android",a.android=!0),a.safari&&a.kindle&&(n.browser="kindle",a.kindle=!0),a.safari&&a.silk&&(n.browser="silk",a.silk=!0),a.vivaldi&&(n.browser="vivaldi",a.vivaldi=!0),a.name=n.browser,a.platform=n.platform,t.indexOf("electron")>-1?a.electron=!0:document.location.href.indexOf("-extension://")>-1?a.bex=!0:(void 0!==window.Capacitor?(a.capacitor=!0,a.nativeMobile=!0,a.nativeMobileWrapper="capacitor"):void 0===window._cordovaNative&&void 0===window.cordova||(a.cordova=!0,a.nativeMobile=!0,a.nativeMobileWrapper="cordova"),!0===hasTouch&&!0===a.mac&&(!0===a.desktop&&!0===a.safari||!0===a.nativeMobile&&!0!==a.android&&!0!==a.ios&&!0!==a.ipad)&&applyIosCorrection(a)),a}const userAgent=navigator.userAgent||navigator.vendor||window.opera,ssrClient={has:{touch:!1,webStorage:!1},within:{iframe:!1}},client={userAgent:userAgent,is:getPlatform(userAgent),has:{touch:hasTouch},within:{iframe:window.self!==window.top}},Platform={install(e){const{$q:t}=e;!0===isRuntimeSsrPreHydration.value?(e.onSSRHydrated.push(()=>{isRuntimeSsrPreHydration.value=!1,Object.assign(t.platform,client),iosCorrection=void 0}),t.platform=reactive(this)):t.platform=this}};{let e;injectProp(client.has,"webStorage",()=>{if(void 0!==e)return e;try{if(window.localStorage)return e=!0,!0}catch(e){}return e=!1,!1}),!0===client.is.ios&&window.navigator.vendor.toLowerCase().indexOf("apple"),!0===isRuntimeSsrPreHydration.value?Object.assign(Platform,client,iosCorrection,ssrClient):Object.assign(Platform,client)}var defineReactivePlugin=(e,t)=>{const o=reactive(e);for(const n in e)injectProp(t,n,()=>o[n],e=>{o[n]=e});return t};const listenOpts={hasPassive:!1,passiveCapture:!0,notPassiveCapture:!0};try{const e=Object.defineProperty({},"passive",{get(){Object.assign(listenOpts,{hasPassive:!0,passive:{passive:!0},notPassive:{passive:!1},passiveCapture:{passive:!0,capture:!0},notPassiveCapture:{passive:!1,capture:!0}})}});window.addEventListener("qtest",null,e),window.removeEventListener("qtest",null,e)}catch(e){}function noop(){}function leftClick(e){return 0===e.button}function middleClick(e){return 1===e.button}function rightClick(e){return 2===e.button}function position(e){return e.touches&&e.touches[0]?e=e.touches[0]:e.changedTouches&&e.changedTouches[0]?e=e.changedTouches[0]:e.targetTouches&&e.targetTouches[0]&&(e=e.targetTouches[0]),{top:e.clientY,left:e.clientX}}function getEventPath(e){if(e.path)return e.path;if(e.composedPath)return e.composedPath();const t=[];let o=e.target;while(o){if(t.push(o),"HTML"===o.tagName)return t.push(document),t.push(window),t;o=o.parentElement}}const LINE_HEIGHT=40,PAGE_HEIGHT=800;function getMouseWheelDistance(e){let t=e.deltaX,o=e.deltaY;if((t||o)&&e.deltaMode){const n=1===e.deltaMode?LINE_HEIGHT:PAGE_HEIGHT;t*=n,o*=n}return e.shiftKey&&!t&&([o,t]=[t,o]),{x:t,y:o}}function stop(e){e.stopPropagation()}function prevent(e){!1!==e.cancelable&&e.preventDefault()}function stopAndPrevent(e){!1!==e.cancelable&&e.preventDefault(),e.stopPropagation()}function preventDraggable(e,t){if(void 0===e||!0===t&&!0===e.__dragPrevented)return;const o=!0===t?e=>{e.__dragPrevented=!0,e.addEventListener("dragstart",prevent,listenOpts.notPassiveCapture)}:e=>{delete e.__dragPrevented,e.removeEventListener("dragstart",prevent,listenOpts.notPassiveCapture)};e.querySelectorAll("a, img").forEach(o)}function addEvt(e,t,o){const n=`__q_${t}_evt`;e[n]=void 0!==e[n]?e[n].concat(o):o,o.forEach(t=>{t[0].addEventListener(t[1],e[t[2]],listenOpts[t[3]])})}function cleanEvt(e,t){const o=`__q_${t}_evt`;void 0!==e[o]&&(e[o].forEach(t=>{t[0].removeEventListener(t[1],e[t[2]],listenOpts[t[3]])}),e[o]=void 0)}var event={listenOpts:listenOpts,leftClick:leftClick,middleClick:middleClick,rightClick:rightClick,position:position,getEventPath:getEventPath,getMouseWheelDistance:getMouseWheelDistance,stop:stop,prevent:prevent,stopAndPrevent:stopAndPrevent,preventDraggable:preventDraggable};function debounce(e,t=250,o){let n;function a(){const a=arguments,l=()=>{n=void 0,!0!==o&&e.apply(this,a)};clearTimeout(n),!0===o&&void 0===n&&e.apply(this,a),n=setTimeout(l,t)}return a.cancel=(()=>{clearTimeout(n)}),a}const SIZE_LIST=["sm","md","lg","xl"],{passive:passive$4}=listenOpts;var Screen=defineReactivePlugin({width:0,height:0,name:"xs",sizes:{sm:600,md:1024,lg:1440,xl:1920},lt:{sm:!0,md:!0,lg:!0,xl:!0},gt:{xs:!1,sm:!1,md:!1,lg:!1},xs:!0,sm:!1,md:!1,lg:!1,xl:!1},{setSizes:noop,setDebounce:noop,install({$q:e,onSSRHydrated:t}){if(e.screen=this,!0===this.__installed)return void(void 0!==e.config.screen&&(!1===e.config.screen.bodyClasses?document.body.classList.remove(`screen--${this.name}`):this.__update(!0)));const{visualViewport:o}=window,n=o||window,a=document.scrollingElement||document.documentElement,l=void 0===o||!0===client.is.mobile?()=>[Math.max(window.innerWidth,a.clientWidth),Math.max(window.innerHeight,a.clientHeight)]:()=>[o.width*o.scale+window.innerWidth-a.clientWidth,o.height*o.scale+window.innerHeight-a.clientHeight],i=void 0!==e.config.screen&&!0===e.config.screen.bodyClasses;this.__update=(e=>{const[t,o]=l();if(o!==this.height&&(this.height=o),t!==this.width)this.width=t;else if(!0!==e)return;let n=this.sizes;this.gt.xs=t>=n.sm,this.gt.sm=t>=n.md,this.gt.md=t>=n.lg,this.gt.lg=t>=n.xl,this.lt.sm=t<n.sm,this.lt.md=t<n.md,this.lt.lg=t<n.lg,this.lt.xl=t<n.xl,this.xs=this.lt.sm,this.sm=!0===this.gt.xs&&!0===this.lt.md,this.md=!0===this.gt.sm&&!0===this.lt.lg,this.lg=!0===this.gt.md&&!0===this.lt.xl,this.xl=this.gt.lg,n=(!0===this.xs?"xs":!0===this.sm&&"sm")||!0===this.md&&"md"||!0===this.lg&&"lg"||"xl",n!==this.name&&(!0===i&&(document.body.classList.remove(`screen--${this.name}`),document.body.classList.add(`screen--${n}`)),this.name=n)});let r,s={},u=16;this.setSizes=(e=>{SIZE_LIST.forEach(t=>{void 0!==e[t]&&(s[t]=e[t])})}),this.setDebounce=(e=>{u=e});const c=()=>{const e=getComputedStyle(document.body);e.getPropertyValue("--q-size-sm")&&SIZE_LIST.forEach(t=>{this.sizes[t]=parseInt(e.getPropertyValue(`--q-size-${t}`),10)}),this.setSizes=(e=>{SIZE_LIST.forEach(t=>{e[t]&&(this.sizes[t]=e[t])}),this.__update(!0)}),this.setDebounce=(e=>{void 0!==r&&n.removeEventListener("resize",r,passive$4),r=e>0?debounce(this.__update,e):this.__update,n.addEventListener("resize",r,passive$4)}),this.setDebounce(u),Object.keys(s).length>0?(this.setSizes(s),s=void 0):this.__update(),!0===i&&"xs"===this.name&&document.body.classList.add("screen--xs")};!0===isRuntimeSsrPreHydration.value?t.push(c):c()}});const Plugin$9=defineReactivePlugin({isActive:!1,mode:!1},{__media:void 0,set(e){Plugin$9.mode=e,"auto"===e?(void 0===Plugin$9.__media&&(Plugin$9.__media=window.matchMedia("(prefers-color-scheme: dark)"),Plugin$9.__updateMedia=(()=>{Plugin$9.set("auto")}),Plugin$9.__media.addListener(Plugin$9.__updateMedia)),e=Plugin$9.__media.matches):void 0!==Plugin$9.__media&&(Plugin$9.__media.removeListener(Plugin$9.__updateMedia),Plugin$9.__media=void 0),Plugin$9.isActive=!0===e,document.body.classList.remove(`body--${!0===e?"light":"dark"}`),document.body.classList.add(`body--${!0===e?"dark":"light"}`)},toggle(){Plugin$9.set(!1===Plugin$9.isActive)},install({$q:e,onSSRHydrated:t,ssrContext:o}){const{dark:n}=e.config;if(e.dark=this,!0===this.__installed&&void 0===n)return;this.isActive=!0===n;const a=void 0!==n&&n;if(!0===isRuntimeSsrPreHydration.value){const e=e=>{this.__fromSSR=e},o=this.set;this.set=e,e(a),t.push(()=>{this.set=o,this.set(this.__fromSSR)})}else this.set(a)}}),getTrue=()=>!0;function filterInvalidPath(e){return"string"===typeof e&&""!==e&&"/"!==e&&"#/"!==e}function normalizeExitPath(e){return!0===e.startsWith("#")&&(e=e.substr(1)),!1===e.startsWith("/")&&(e="/"+e),!0===e.endsWith("/")&&(e=e.substr(0,e.length-1)),"#"+e}function getShouldExitFn(e){if(!1===e.backButtonExit)return()=>!1;if("*"===e.backButtonExit)return getTrue;const t=["#/"];return!0===Array.isArray(e.backButtonExit)&&t.push(...e.backButtonExit.filter(filterInvalidPath).map(normalizeExitPath)),()=>t.includes(window.location.hash)}var History={__history:[],add:noop,remove:noop,install({$q:e}){if(!0===this.__installed)return;const{cordova:t,capacitor:o}=client.is;if(!0!==t&&!0!==o)return;const n=e.config[!0===t?"cordova":"capacitor"];if(void 0!==n&&!1===n.backButton)return;if(!0===o&&(void 0===window.Capacitor||void 0===window.Capacitor.Plugins.App))return;this.add=(e=>{void 0===e.condition&&(e.condition=getTrue),this.__history.push(e)}),this.remove=(e=>{const t=this.__history.indexOf(e);t>=0&&this.__history.splice(t,1)});const a=getShouldExitFn(Object.assign({backButtonExit:!0},n)),l=()=>{if(this.__history.length){const e=this.__history[this.__history.length-1];!0===e.condition()&&(this.__history.pop(),e.handler())}else!0===a()?navigator.app.exitApp():window.history.back()};!0===t?document.addEventListener("deviceready",()=>{document.addEventListener("backbutton",l,!1)}):window.Capacitor.Plugins.App.addListener("backButton",l)}},defaultLang={isoName:"en-US",nativeName:"English (US)",label:{clear:"Clear",ok:"OK",cancel:"Cancel",close:"Close",set:"Set",select:"Select",reset:"Reset",remove:"Remove",update:"Update",create:"Create",search:"Search",filter:"Filter",refresh:"Refresh"},date:{days:"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),daysShort:"Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),months:"January_February_March_April_May_June_July_August_September_October_November_December".split("_"),monthsShort:"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),firstDayOfWeek:0,format24h:!1,pluralDay:"days"},table:{noData:"No data available",noResults:"No matching records found",loading:"Loading...",selectedRecords:e=>1===e?"1 record selected.":(0===e?"No":e)+" records selected.",recordsPerPage:"Records per page:",allRows:"All",pagination:(e,t,o)=>e+"-"+t+" of "+o,columns:"Columns"},editor:{url:"URL",bold:"Bold",italic:"Italic",strikethrough:"Strikethrough",underline:"Underline",unorderedList:"Unordered List",orderedList:"Ordered List",subscript:"Subscript",superscript:"Superscript",hyperlink:"Hyperlink",toggleFullscreen:"Toggle Fullscreen",quote:"Quote",left:"Left align",center:"Center align",right:"Right align",justify:"Justify align",print:"Print",outdent:"Decrease indentation",indent:"Increase indentation",removeFormat:"Remove formatting",formatting:"Formatting",fontSize:"Font Size",align:"Align",hr:"Insert Horizontal Rule",undo:"Undo",redo:"Redo",heading1:"Heading 1",heading2:"Heading 2",heading3:"Heading 3",heading4:"Heading 4",heading5:"Heading 5",heading6:"Heading 6",paragraph:"Paragraph",code:"Code",size1:"Very small",size2:"A bit small",size3:"Normal",size4:"Medium-large",size5:"Big",size6:"Very big",size7:"Maximum",defaultFont:"Default Font",viewSource:"View Source"},tree:{noNodes:"No nodes available",noResults:"No matching nodes found"}};function getLocale(){const e=!0===Array.isArray(navigator.languages)&&navigator.languages.length>0?navigator.languages[0]:navigator.language;if("string"===typeof e)return e.split(/[-_]/).map((e,t)=>0===t?e.toLowerCase():t>1||e.length<4?e.toUpperCase():e[0].toUpperCase()+e.slice(1).toLowerCase()).join("-")}const Plugin$8=defineReactivePlugin({__langPack:{}},{getLocale:getLocale,set(e=defaultLang,t){const o={...e,rtl:!0===e.rtl,getLocale:getLocale};{const e=document.documentElement;e.setAttribute("dir",!0===o.rtl?"rtl":"ltr"),e.setAttribute("lang",o.isoName),o.set=Plugin$8.set,Object.assign(Plugin$8.__langPack,o),Plugin$8.props=o,Plugin$8.isoName=o.isoName,Plugin$8.nativeName=o.nativeName}},install({$q:e,lang:t,ssrContext:o}){e.lang=Plugin$8.__langPack,!0===this.__installed?void 0!==t&&this.set(t):this.set(t||defaultLang)}});function setCssVar(e,t,o=document.body){if("string"!==typeof e)throw new TypeError("Expected a string as propName");if("string"!==typeof t)throw new TypeError("Expected a string as value");if(!(o instanceof Element))throw new TypeError("Expected a DOM element");o.style.setProperty(`--q-${e}`,t)}let lastKeyCompositionStatus=!1;function onKeyDownComposition(e){lastKeyCompositionStatus=!0===e.isComposing}function shouldIgnoreKey(e){return!0===lastKeyCompositionStatus||e!==Object(e)||!0===e.isComposing||!0===e.qKeyEvent}function isKeyCode(e,t){return!0!==shouldIgnoreKey(e)&&[].concat(t).includes(e.keyCode)}function getMobilePlatform(e){return!0===e.ios?"ios":!0===e.android?"android":void 0}function getBodyClasses({is:e,has:t,within:o},n){const a=[!0===e.desktop?"desktop":"mobile",`${!1===t.touch?"no-":""}touch`];if(!0===e.mobile){const t=getMobilePlatform(e);void 0!==t&&a.push("platform-"+t)}if(!0===e.nativeMobile){const t=e.nativeMobileWrapper;a.push(t),a.push("native-mobile"),!0!==e.ios||void 0!==n[t]&&!1===n[t].iosStatusBarPadding||a.push("q-ios-padding")}else!0===e.electron?a.push("electron"):!0===e.bex&&a.push("bex");return!0===o.iframe&&a.push("within-iframe"),a}function applyClientSsrCorrections(){const e=document.body.className;let t=e;void 0!==iosCorrection&&(t=t.replace("desktop","platform-ios mobile")),!0===client.has.touch&&(t=t.replace("no-touch","touch")),!0===client.within.iframe&&(t+=" within-iframe"),e!==t&&(document.body.className=t)}function setColors(e){for(const t in e)setCssVar(t,e[t])}var Body={install(e){if(!0!==this.__installed){if(!0===isRuntimeSsrPreHydration.value)applyClientSsrCorrections();else{const{$q:t}=e;void 0!==t.config.brand&&setColors(t.config.brand);const o=getBodyClasses(client,t.config);document.body.classList.add.apply(document.body.classList,o)}!0===client.is.ios&&document.body.addEventListener("touchstart",noop),window.addEventListener("keydown",onKeyDownComposition,!0)}}},materialIcons={name:"material-icons",type:{positive:"check_circle",negative:"warning",info:"info",warning:"priority_high"},arrow:{up:"arrow_upward",right:"arrow_forward",down:"arrow_downward",left:"arrow_back",dropdown:"arrow_drop_down"},chevron:{left:"chevron_left",right:"chevron_right"},colorPicker:{spectrum:"gradient",tune:"tune",palette:"style"},pullToRefresh:{icon:"refresh"},carousel:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down",navigationIcon:"lens"},chip:{remove:"cancel",selected:"check"},datetime:{arrowLeft:"chevron_left",arrowRight:"chevron_right",now:"access_time",today:"today"},editor:{bold:"format_bold",italic:"format_italic",strikethrough:"strikethrough_s",underline:"format_underlined",unorderedList:"format_list_bulleted",orderedList:"format_list_numbered",subscript:"vertical_align_bottom",superscript:"vertical_align_top",hyperlink:"link",toggleFullscreen:"fullscreen",quote:"format_quote",left:"format_align_left",center:"format_align_center",right:"format_align_right",justify:"format_align_justify",print:"print",outdent:"format_indent_decrease",indent:"format_indent_increase",removeFormat:"format_clear",formatting:"text_format",fontSize:"format_size",align:"format_align_left",hr:"remove",undo:"undo",redo:"redo",heading:"format_size",code:"code",size:"format_size",font:"font_download",viewSource:"code"},expansionItem:{icon:"keyboard_arrow_down",denseIcon:"arrow_drop_down"},fab:{icon:"add",activeIcon:"close"},field:{clear:"cancel",error:"error"},pagination:{first:"first_page",prev:"keyboard_arrow_left",next:"keyboard_arrow_right",last:"last_page"},rating:{icon:"grade"},stepper:{done:"check",active:"edit",error:"warning"},tabs:{left:"chevron_left",right:"chevron_right",up:"keyboard_arrow_up",down:"keyboard_arrow_down"},table:{arrowUp:"arrow_upward",warning:"warning",firstPage:"first_page",prevPage:"chevron_left",nextPage:"chevron_right",lastPage:"last_page"},tree:{icon:"play_arrow"},uploader:{done:"done",clear:"clear",add:"add_box",upload:"cloud_upload",removeQueue:"clear_all",removeUploaded:"done_all"}};const Plugin$7=defineReactivePlugin({iconMapFn:null,__icons:{}},{set(e,t){const o={...e,rtl:!0===e.rtl};o.set=Plugin$7.set,Object.assign(Plugin$7.__icons,o)},install({$q:e,iconSet:t,ssrContext:o}){void 0!==e.config.iconMapFn&&(this.iconMapFn=e.config.iconMapFn),e.iconSet=this.__icons,injectProp(e,"iconMapFn",()=>this.iconMapFn,e=>{this.iconMapFn=e}),!0===this.__installed?void 0!==t&&this.set(t):this.set(t||materialIcons)}}),quasarKey="_q_",timelineKey="_q_t_",stepperKey="_q_s_",layoutKey="_q_l_",pageContainerKey="_q_pc_",fabKey="_q_f_",formKey="_q_fo_",tabsKey="_q_tabs_",uploaderKey="_q_u_",globalConfig={};let globalConfigIsFrozen=!1;function freezeGlobalConfig(){globalConfigIsFrozen=!0}const autoInstalledPlugins=[Platform,Body,Plugin$9,Screen,History,Plugin$8,Plugin$7];function createChildApp(e,t){const o=createApp(e);o.config.globalProperties=t.config.globalProperties;const{reload:n,...a}=t._context;return Object.assign(o._context,a),o}function installPlugins(e,t){t.forEach(t=>{t.install(e),t.__installed=!0})}function prepareApp(e,t,o){e.config.globalProperties.$q=o.$q,e.provide(quasarKey,o.$q),installPlugins(o,autoInstalledPlugins),void 0!==t.components&&Object.values(t.components).forEach(t=>{Object(t)===t&&void 0!==t.name&&e.component(t.name,t)}),void 0!==t.directives&&Object.values(t.directives).forEach(t=>{Object(t)===t&&void 0!==t.name&&e.directive(t.name,t)}),void 0!==t.plugins&&installPlugins(o,Object.values(t.plugins).filter(e=>"function"===typeof e.install&&!1===autoInstalledPlugins.includes(e))),!0===isRuntimeSsrPreHydration.value&&(o.$q.onSSRHydrated=(()=>{o.onSSRHydrated.forEach(e=>{e()}),o.$q.onSSRHydrated=(()=>{})}))}var installQuasar=function(e,t={}){const o={version:"2.5.3"};!1===globalConfigIsFrozen?(void 0!==t.config&&Object.assign(globalConfig,t.config),o.config={...globalConfig},freezeGlobalConfig()):o.config=t.config||{},prepareApp(e,t,{parentApp:e,$q:o,lang:t.lang,iconSet:t.iconSet,onSSRHydrated:[]})};const createComponent=e=>markRaw(defineComponent(e)),createDirective=e=>markRaw(e),units=["B","KB","MB","GB","TB","PB"];function humanStorageSize(e){let t=0;while(parseInt(e,10)>=1024&&t<units.length-1)e/=1024,++t;return`${e.toFixed(1)}${units[t]}`}function capitalize(e){return e.charAt(0).toUpperCase()+e.slice(1)}function between(e,t,o){return o<=t?t:Math.min(o,Math.max(t,e))}function normalizeToInterval(e,t,o){if(o<=t)return t;const n=o-t+1;let a=t+(e-t)%n;return a<t&&(a=n+a),0===a?0:a}function pad(e,t=2,o="0"){if(void 0===e||null===e)return e;const n=""+e;return n.length>=t?n:new Array(t-n.length+1).join(o)+n}var format={humanStorageSize:humanStorageSize,capitalize:capitalize,between:between,normalizeToInterval:normalizeToInterval,pad:pad};const xhr=XMLHttpRequest,open=xhr.prototype.open,positionValues=["top","right","bottom","left"];let stack=[],highjackCount=0;function translate({p:e,pos:t,active:o,horiz:n,reverse:a,dir:l}){let i=1,r=1;return!0===n?(!0===a&&(i=-1),"bottom"===t&&(r=-1),{transform:`translate3d(${i*(e-100)}%,${o?0:-200*r}%,0)`}):(!0===a&&(r=-1),"right"===t&&(i=-1),{transform:`translate3d(${o?0:l*i*-200}%,${r*(e-100)}%,0)`})}function inc(e,t){return"number"!==typeof t&&(t=e<25?3*Math.random()+3:e<65?3*Math.random():e<85?2*Math.random():e<99?.6:0),between(e+t,0,100)}function highjackAjax(e){highjackCount++,stack.push(e),highjackCount>1||(xhr.prototype.open=function(e,t){const o=[],n=()=>{stack.forEach(e=>{null!==e.hijackFilter.value&&!0!==e.hijackFilter.value(t)||(e.start(),o.push(e.stop))})},a=()=>{o.forEach(e=>{e()})};this.addEventListener("loadstart",n,{once:!0}),this.addEventListener("loadend",a,{once:!0}),open.apply(this,arguments)})}function restoreAjax(e){stack=stack.filter(t=>t.start!==e),highjackCount=Math.max(0,highjackCount-1),0===highjackCount&&(xhr.prototype.open=open)}var QAjaxBar=createComponent({name:"QAjaxBar",props:{position:{type:String,default:"top",validator:e=>positionValues.includes(e)},size:{type:String,default:"2px"},color:String,skipHijack:Boolean,reverse:Boolean,hijackFilter:Function},emits:["start","stop"],setup(e,{emit:t}){const{proxy:o}=getCurrentInstance(),n=ref(0),a=ref(!1),l=ref(!0);let i,r,s=0;const u=computed(()=>`q-loading-bar q-loading-bar--${e.position}`+(void 0!==e.color?` bg-${e.color}`:"")+(!0===l.value?"":" no-transition")),c=computed(()=>"top"===e.position||"bottom"===e.position),d=computed(()=>!0===c.value?"height":"width"),p=computed(()=>{const t=a.value,l=translate({p:n.value,pos:e.position,active:t,horiz:c.value,reverse:!0===o.$q.lang.rtl&&["top","bottom"].includes(e.position)?!1===e.reverse:e.reverse,dir:!0===o.$q.lang.rtl?-1:1});return l[d.value]=e.size,l.opacity=t?1:0,l}),v=computed(()=>!0===a.value?{role:"progressbar","aria-valuemin":0,"aria-valuemax":100,"aria-valuenow":n.value}:{"aria-hidden":"true"});function m(e=300){const o=r;return r=Math.max(0,e)||0,s++,s>1?(0===o&&e>0?b():o>0&&e<=0&&clearTimeout(i),s):(clearTimeout(i),t("start"),n.value=0,i=setTimeout(()=>{l.value=!0,e>0&&b()},!0===a.value?500:1),!0!==a.value&&(a.value=!0,l.value=!1),s)}function f(e){return s>0&&(n.value=inc(n.value,e)),s}function g(){if(s=Math.max(0,s-1),s>0)return s;clearTimeout(i),t("stop");const e=()=>{l.value=!0,n.value=100,i=setTimeout(()=>{a.value=!1},1e3)};return 0===n.value?i=setTimeout(e,1):e(),s}function b(){n.value<100&&(i=setTimeout(()=>{f(),b()},r))}let y;return onMounted(()=>{!0!==e.skipHijack&&(y=!0,highjackAjax({start:m,stop:g,hijackFilter:computed(()=>e.hijackFilter||null)}))}),onBeforeUnmount(()=>{clearTimeout(i),!0===y&&restoreAjax(m)}),Object.assign(o,{start:m,stop:g,increment:f}),()=>h("div",{class:u.value,style:p.value,...v.value})}});const useSizeDefaults={xs:18,sm:24,md:32,lg:38,xl:46},useSizeProps={size:String};function useSize(e,t=useSizeDefaults){return computed(()=>void 0!==e.size?{fontSize:e.size in t?`${t[e.size]}px`:e.size}:null)}function hSlot(e,t){return void 0!==e&&e()||t}function hUniqueSlot(e,t){if(void 0!==e){const t=e();if(void 0!==t&&null!==t)return t.slice()}return t}function hMergeSlot(e,t){return void 0!==e?t.concat(e()):t}function hMergeSlotSafely(e,t){return void 0===e?t:void 0!==t?t.concat(e()):e()}function hDir(e,t,o,n,a,l){t.key=n+a;const i=h(e,t,o);return!0===a?withDirectives(i,l()):i}const defaultViewBox="0 0 24 24",sameFn=e=>e,ionFn=e=>`ionicons ${e}`,libMap={"icon-":sameFn,"bt-":e=>`bt ${e}`,"eva-":e=>`eva ${e}`,"ion-md":ionFn,"ion-ios":ionFn,"ion-logo":ionFn,"mdi-":e=>`mdi ${e}`,"iconfont ":sameFn,"ti-":e=>`themify-icon ${e}`,"bi-":e=>`bootstrap-icons ${e}`},matMap={o_:"-outlined",r_:"-round",s_:"-sharp"},libRE=new RegExp("^("+Object.keys(libMap).join("|")+")"),matRE=new RegExp("^("+Object.keys(matMap).join("|")+")"),mRE=/^[Mm]\s?[-+]?\.?\d/,imgRE=/^img:/,svgUseRE=/^svguse:/,ionRE=/^ion-/,faLaRE=/^[lf]a[srlbdk]? /;var QIcon=createComponent({name:"QIcon",props:{...useSizeProps,tag:{type:String,default:"i"},name:String,color:String,left:Boolean,right:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=useSize(e),a=computed(()=>"q-icon"+(!0===e.left?" on-left":"")+(!0===e.right?" on-right":"")+(void 0!==e.color?` text-${e.color}`:"")),l=computed(()=>{let t,n=e.name;if(!n)return{none:!0};if(null!==o.iconMapFn){const e=o.iconMapFn(n);if(void 0!==e){if(void 0===e.icon)return{cls:e.cls,content:void 0!==e.content?e.content:" "};n=e.icon}}if(!0===mRE.test(n)){const[e,t=defaultViewBox]=n.split("|");return{svg:!0,viewBox:t,nodes:e.split("&&").map(e=>{const[t,o,n]=e.split("@@");return h("path",{style:o,d:t,transform:n})})}}if(!0===imgRE.test(n))return{img:!0,src:n.substring(4)};if(!0===svgUseRE.test(n)){const[e,t=defaultViewBox]=n.split("|");return{svguse:!0,src:e.substring(7),viewBox:t}}let a=" ";const l=n.match(libRE);if(null!==l)t=libMap[l[1]](n);else if(!0===faLaRE.test(n))t=n;else if(!0===ionRE.test(n))t=`ionicons ion-${!0===o.platform.is.ios?"ios":"md"}${n.substr(3)}`;else{t="notranslate material-icons";const e=n.match(matRE);null!==e&&(n=n.substring(2),t+=matMap[e[1]]),a=n}return{cls:t,content:a}});return()=>{const o={class:a.value,style:n.value,"aria-hidden":"true",role:"presentation"};return!0===l.value.none?h(e.tag,o,hSlot(t.default)):!0===l.value.img?h("span",o,hMergeSlot(t.default,[h("img",{src:l.value.src})])):!0===l.value.svg?h("span",o,hMergeSlot(t.default,[h("svg",{viewBox:l.value.viewBox},l.value.nodes)])):!0===l.value.svguse?h("span",o,hMergeSlot(t.default,[h("svg",{viewBox:l.value.viewBox},[h("use",{"xlink:href":l.value.src})])])):(void 0!==l.value.cls&&(o.class+=" "+l.value.cls),h(e.tag,o,hMergeSlot(t.default,[l.value.content])))}}}),QAvatar=createComponent({name:"QAvatar",props:{...useSizeProps,fontSize:String,color:String,textColor:String,icon:String,square:Boolean,rounded:Boolean},setup(e,{slots:t}){const o=useSize(e),n=computed(()=>"q-avatar"+(e.color?` bg-${e.color}`:"")+(e.textColor?` text-${e.textColor} q-chip--colored`:"")+(!0===e.square?" q-avatar--square":!0===e.rounded?" rounded-borders":"")),a=computed(()=>e.fontSize?{fontSize:e.fontSize}:null);return()=>{const l=void 0!==e.icon?[h(QIcon,{name:e.icon})]:void 0;return h("div",{class:n.value,style:o.value},[h("div",{class:"q-avatar__content row flex-center overflow-hidden",style:a.value},hMergeSlotSafely(t.default,l))])}}});const alignValues$3=["top","middle","bottom"];var QBadge=createComponent({name:"QBadge",props:{color:String,textColor:String,floating:Boolean,transparent:Boolean,multiLine:Boolean,outline:Boolean,rounded:Boolean,label:[Number,String],align:{type:String,validator:e=>alignValues$3.includes(e)}},setup(e,{slots:t}){const o=computed(()=>{return void 0!==e.align?{verticalAlign:e.align}:null}),n=computed(()=>{const t=!0===e.outline&&e.color||e.textColor;return"q-badge flex inline items-center no-wrap"+` q-badge--${!0===e.multiLine?"multi":"single"}-line`+(!0===e.outline?" q-badge--outline":void 0!==e.color?` bg-${e.color}`:"")+(void 0!==t?` text-${t}`:"")+(!0===e.floating?" q-badge--floating":"")+(!0===e.rounded?" q-badge--rounded":"")+(!0===e.transparent?" q-badge--transparent":"")});return()=>h("div",{class:n.value,style:o.value,role:"alert","aria-label":e.label},void 0!==e.label?e.label:hSlot(t.default))}});const useDarkProps={dark:{type:Boolean,default:null}};function useDark(e,t){return computed(()=>null===e.dark?t.dark.isActive:e.dark)}var QBanner=createComponent({name:"QBanner",props:{...useDarkProps,inlineActions:Boolean,dense:Boolean,rounded:Boolean},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>"q-banner row items-center"+(!0===e.dense?" q-banner--dense":"")+(!0===n.value?" q-banner--dark q-dark":"")+(!0===e.rounded?" rounded-borders":"")),l=computed(()=>"q-banner__actions row items-center justify-end"+` col-${!0===e.inlineActions?"auto":"all"}`);return()=>{const o=[h("div",{class:"q-banner__avatar col-auto row items-center self-start"},hSlot(t.avatar)),h("div",{class:"q-banner__content col text-body2"},hSlot(t.default))],n=hSlot(t.action);return void 0!==n&&o.push(h("div",{class:l.value},n)),h("div",{class:a.value+(!1===e.inlineActions&&void 0!==n?" q-banner--top-padding":""),role:"alert"},o)}}}),QBar=createComponent({name:"QBar",props:{...useDarkProps,dense:Boolean},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>"q-bar row no-wrap items-center"+` q-bar--${!0===e.dense?"dense":"standard"} `+` q-bar--${!0===n.value?"dark":"light"}`);return()=>h("div",{class:a.value,role:"toolbar"},hSlot(t.default))}});const alignMap={left:"start",center:"center",right:"end",between:"between",around:"around",evenly:"evenly",stretch:"stretch"},alignValues$2=Object.keys(alignMap),useAlignProps={align:{type:String,validator:e=>alignValues$2.includes(e)}};function useAlign(e){return computed(()=>{const t=void 0===e.align?!0===e.vertical?"stretch":"left":e.align;return`${!0===e.vertical?"items":"justify"}-${alignMap[t]}`})}function getParentVm(e){if(Object(e.$parent)===e.$parent)return e.$parent;e=e.$.parent;while(Object(e)===e){if(Object(e.proxy)===e.proxy)return e.proxy;e=e.parent}}function fillNormalizedVNodes(e,t){"symbol"===typeof t.type?!0===Array.isArray(t.children)&&t.children.forEach(t=>{fillNormalizedVNodes(e,t)}):e.add(t)}function getNormalizedVNodes(e){const t=new Set;return e.forEach(e=>{fillNormalizedVNodes(t,e)}),Array.from(t)}function vmHasRouter(e){return void 0!==e.appContext.config.globalProperties.$router}const disabledValues=[void 0,!0];var QBreadcrumbs=createComponent({name:"QBreadcrumbs",props:{...useAlignProps,separator:{type:String,default:"/"},separatorColor:String,activeColor:{type:String,default:"primary"},gutter:{type:String,validator:e=>["none","xs","sm","md","lg","xl"].includes(e),default:"sm"}},setup(e,{slots:t}){const o=useAlign(e),n=computed(()=>`flex items-center ${o.value}${"none"===e.gutter?"":` q-gutter-${e.gutter}`}`),a=computed(()=>e.separatorColor?` text-${e.separatorColor}`:""),l=computed(()=>` text-${e.activeColor}`);return()=>{const o=getNormalizedVNodes(hSlot(t.default));if(0===o.length)return;let i=1;const r=[],s=o.filter(e=>void 0!==e.type&&"QBreadcrumbsEl"===e.type.name).length,u=void 0!==t.separator?t.separator:()=>e.separator;return o.forEach(e=>{if(void 0!==e.type&&"QBreadcrumbsEl"===e.type.name){const t=i<s,o=null!==e.props&&disabledValues.includes(e.props.disable),n=(!0===t?"":" q-breadcrumbs--last")+(!0!==o&&!0===t?l.value:"");i++,r.push(h("div",{class:`flex items-center${n}`},[e])),!0===t&&r.push(h("div",{class:"q-breadcrumbs__separator"+a.value},u()))}else r.push(e)}),h("div",{class:"q-breadcrumbs"},[h("div",{class:n.value},r)])}}});function getOriginalPath(e){return e?e.aliasOf?e.aliasOf.path:e.path:""}function isSameRouteRecord(e,t){return(e.aliasOf||e)===(t.aliasOf||t)}function includesParams(e,t){for(const o in t){const n=t[o],a=e[o];if("string"===typeof n){if(n!==a)return!1}else if(!1===Array.isArray(a)||a.length!==n.length||n.some((e,t)=>e!==a[t]))return!1}return!0}function isEquivalentArray(e,t){return!0===Array.isArray(t)?e.length===t.length&&e.every((e,o)=>e===t[o]):1===e.length&&e[0]===t}function isSameRouteLocationParamsValue(e,t){return!0===Array.isArray(e)?isEquivalentArray(e,t):!0===Array.isArray(t)?isEquivalentArray(t,e):e===t}function isSameRouteLocationParams(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const o in e)if(!1===isSameRouteLocationParamsValue(e[o],t[o]))return!1;return!0}const useRouterLinkProps={to:[String,Object],replace:Boolean,exact:Boolean,activeClass:{type:String,default:"q-router-link--active"},exactActiveClass:{type:String,default:"q-router-link--exact-active"},href:String,target:String,disable:Boolean};function useRouterLink(e){const t=getCurrentInstance(),{props:o,proxy:n}=t,a=vmHasRouter(t),l=computed(()=>!0!==o.disable&&void 0!==o.href),i=computed(()=>!0===a&&!0!==o.disable&&!0!==l.value&&void 0!==o.to&&null!==o.to&&""!==o.to),r=computed(()=>{if(!0===i.value)try{return n.$router.resolve(o.to)}catch(e){}return null}),s=computed(()=>null!==r.value),u=computed(()=>!0===l.value||!0===s.value),c=computed(()=>"a"===o.type||!0===u.value?"a":o.tag||e||"div"),d=computed(()=>!0===l.value?{href:o.href,target:o.target}:!0===s.value?{href:r.value.href,target:o.target}:{}),p=computed(()=>{if(!1===s.value)return null;const{matched:e}=r.value,{length:t}=e,o=e[t-1];if(void 0===o)return-1;const a=n.$route.matched;if(0===a.length)return-1;const l=a.findIndex(isSameRouteRecord.bind(null,o));if(l>-1)return l;const i=getOriginalPath(e[t-2]);return t>1&&getOriginalPath(o)===i&&a[a.length-1].path!==i?a.findIndex(isSameRouteRecord.bind(null,e[t-2])):l}),v=computed(()=>!0===s.value&&p.value>-1&&includesParams(n.$route.params,r.value.params)),m=computed(()=>!0===v.value&&p.value===n.$route.matched.length-1&&isSameRouteLocationParams(n.$route.params,r.value.params)),f=computed(()=>!0===s.value?!0===m.value?` ${o.exactActiveClass} ${o.activeClass}`:!0===o.exact?"":!0===v.value?` ${o.activeClass}`:"":"");function h(e){return!(!0===o.disable||e.metaKey||e.altKey||e.ctrlKey||e.shiftKey||!0!==e.__qNavigate&&!0===e.defaultPrevented||void 0!==e.button&&0!==e.button||"_blank"===o.target)&&(prevent(e),n.$router[!0===o.replace?"replace":"push"](o.to).catch(()=>{}))}return{hasRouterLink:s,hasHrefLink:l,hasLink:u,linkTag:c,linkRoute:r,linkIsActive:v,linkIsExactActive:m,linkClass:f,linkProps:d,navigateToRouterLink:h}}var QBreadcrumbsEl=createComponent({name:"QBreadcrumbsEl",props:{...useRouterLinkProps,label:String,icon:String,tag:{type:String,default:"span"}},setup(e,{slots:t}){const{linkTag:o,linkProps:n,linkClass:a,hasRouterLink:l,navigateToRouterLink:i}=useRouterLink(),r=computed(()=>{const t={class:"q-breadcrumbs__el q-link flex inline items-center relative-position "+(!0!==e.disable?"q-link--focusable"+a.value:"q-breadcrumbs__el--disable"),...n.value};return!0===l.value&&(t.onClick=i),t}),s=computed(()=>"q-breadcrumbs__el-icon"+(void 0!==e.label?" q-breadcrumbs__el-icon--with-label":""));return()=>{const n=[];return void 0!==e.icon&&n.push(h(QIcon,{class:s.value,name:e.icon})),void 0!==e.label&&n.push(e.label),h(o.value,{...r.value},hMergeSlot(t.default,n))}}});const useSpinnerProps={size:{type:[Number,String],default:"1em"},color:String};function useSpinner(e){return{cSize:computed(()=>e.size in useSizeDefaults?`${useSizeDefaults[e.size]}px`:e.size),classes:computed(()=>"q-spinner"+(e.color?` text-${e.color}`:""))}}var QSpinner=createComponent({name:"QSpinner",props:{...useSpinnerProps,thickness:{type:Number,default:5}},setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value+" q-spinner-mat",width:t.value,height:t.value,viewBox:"25 25 50 50"},[h("circle",{class:"path",cx:"50",cy:"50",r:"20",fill:"none",stroke:"currentColor","stroke-width":e.thickness,"stroke-miterlimit":"10"})])}});function offset(e){if(e===window)return{top:0,left:0};const{top:t,left:o}=e.getBoundingClientRect();return{top:t,left:o}}function style(e,t){return window.getComputedStyle(e).getPropertyValue(t)}function height(e){return e===window?window.innerHeight:e.getBoundingClientRect().height}function width$1(e){return e===window?window.innerWidth:e.getBoundingClientRect().width}function css(e,t){const o=e.style;for(const n in t)o[n]=t[n]}function cssBatch(e,t){e.forEach(e=>css(e,t))}function ready(e){if("function"===typeof e)return"loading"!==document.readyState?e():void document.addEventListener("DOMContentLoaded",e,!1)}function getElement$1(e){if(void 0===e||null===e)return;if("string"===typeof e)try{return document.querySelector(e)||void 0}catch(e){return}const t=!0===isRef(e)?e.value:e;return t?t.$el||t:void 0}function childHasFocus(e,t){if(void 0===e||null===e||!0===e.contains(t))return!0;for(let o=e.nextElementSibling;null!==o;o=o.nextElementSibling)if(o.contains(t))return!0;return!1}var dom={offset:offset,style:style,height:height,width:width$1,css:css,cssBatch:cssBatch,ready:ready};function throttle(e,t=250){let o,n=!1;return function(){return!1===n&&(n=!0,setTimeout(()=>{n=!1},t),o=e.apply(this,arguments)),o}}function showRipple(e,t,o,n){!0===o.modifiers.stop&&stop(e);const a=o.modifiers.color;let l=o.modifiers.center;l=!0===l||!0===n;const i=document.createElement("span"),r=document.createElement("span"),s=position(e),{left:u,top:c,width:d,height:p}=t.getBoundingClientRect(),v=Math.sqrt(d*d+p*p),m=v/2,f=`${(d-v)/2}px`,h=l?f:`${s.left-u-m}px`,g=`${(p-v)/2}px`,b=l?g:`${s.top-c-m}px`;r.className="q-ripple__inner",css(r,{height:`${v}px`,width:`${v}px`,transform:`translate3d(${h},${b},0) scale3d(.2,.2,1)`,opacity:0}),i.className=`q-ripple${a?" text-"+a:""}`,i.setAttribute("dir","ltr"),i.appendChild(r),t.appendChild(i);const y=()=>{i.remove(),clearTimeout(S)};o.abort.push(y);let S=setTimeout(()=>{r.classList.add("q-ripple__inner--enter"),r.style.transform=`translate3d(${f},${g},0) scale3d(1,1,1)`,r.style.opacity=.2,S=setTimeout(()=>{r.classList.remove("q-ripple__inner--enter"),r.classList.add("q-ripple__inner--leave"),r.style.opacity=0,S=setTimeout(()=>{i.remove(),o.abort.splice(o.abort.indexOf(y),1)},275)},250)},50)}function updateModifiers$1(e,{modifiers:t,value:o,arg:n,instance:a}){const l=Object.assign({},a.$q.config.ripple,t,o);e.modifiers={early:!0===l.early,stop:!0===l.stop,center:!0===l.center,color:l.color||n,keyCodes:[].concat(l.keyCodes||13)}}var Ripple=createDirective({name:"ripple",beforeMount(e,t){const o={enabled:!1!==t.value,modifiers:{},abort:[],start(t){!0===o.enabled&&!0!==t.qSkipRipple&&(!0===o.modifiers.early?!0===["mousedown","touchstart"].includes(t.type):"click"===t.type)&&showRipple(t,e,o,!0===t.qKeyEvent)},keystart:throttle(t=>{!0===o.enabled&&!0!==t.qSkipRipple&&!0===isKeyCode(t,o.modifiers.keyCodes)&&t.type===`key${!0===o.modifiers.early?"down":"up"}`&&showRipple(t,e,o,!0)},300)};updateModifiers$1(o,t),e.__qripple=o,addEvt(o,"main",[[e,"mousedown","start","passive"],[e,"touchstart","start","passive"],[e,"click","start","passive"],[e,"keydown","keystart","passive"],[e,"keyup","keystart","passive"]])},updated(e,t){if(t.oldValue!==t.value){const o=e.__qripple;o.enabled=!1!==t.value,!0===o.enabled&&Object(t.value)===t.value&&updateModifiers$1(o,t)}},beforeUnmount(e){const t=e.__qripple;t.abort.forEach(e=>{e()}),cleanEvt(t,"main"),delete e._qripple}});const padding={none:0,xs:4,sm:8,md:16,lg:24,xl:32},defaultSizes$2={xs:8,sm:10,md:14,lg:20,xl:24},formTypes=["button","submit","reset"],mediaTypeRE=/[^\s]\/[^\s]/,useBtnProps={...useSizeProps,...useRouterLinkProps,type:{type:String,default:"button"},label:[Number,String],icon:String,iconRight:String,round:Boolean,outline:Boolean,flat:Boolean,unelevated:Boolean,rounded:Boolean,push:Boolean,glossy:Boolean,size:String,fab:Boolean,fabMini:Boolean,padding:String,color:String,textColor:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,tabindex:[Number,String],ripple:{type:[Boolean,Object],default:!0},align:{...useAlignProps.align,default:"center"},stack:Boolean,stretch:Boolean,loading:{type:Boolean,default:null},disable:Boolean};function useBtn(e){const t=useSize(e,defaultSizes$2),o=useAlign(e),{hasRouterLink:n,hasLink:a,linkTag:l,linkProps:i,navigateToRouterLink:r}=useRouterLink("button"),s=computed(()=>{const o=!1===e.fab&&!1===e.fabMini?t.value:{};return void 0!==e.padding?Object.assign({},o,{padding:e.padding.split(/\s+/).map(e=>e in padding?padding[e]+"px":e).join(" "),minWidth:"0",minHeight:"0"}):o}),u=computed(()=>!0===e.rounded||!0===e.fab||!0===e.fabMini),c=computed(()=>!0!==e.disable&&!0!==e.loading),d=computed(()=>!0===c.value?e.tabindex||0:-1),p=computed(()=>{return!0===e.flat?"flat":!0===e.outline?"outline":!0===e.push?"push":!0===e.unelevated?"unelevated":"standard"}),v=computed(()=>{const t={tabindex:d.value};return!0===a.value?Object.assign(t,i.value):!0===formTypes.includes(e.type)&&(t.type=e.type),"a"===l.value?(!0===e.disable?t["aria-disabled"]="true":void 0===t.href&&(t.role="button"),!0!==n.value&&!0===mediaTypeRE.test(e.type)&&(t.type=e.type)):!0===e.disable&&(t.disabled="",t["aria-disabled"]="true"),!0===e.loading&&void 0!==e.percentage&&Object.assign(t,{role:"progressbar","aria-valuemin":0,"aria-valuemax":100,"aria-valuenow":e.percentage}),t}),m=computed(()=>{let t;return void 0!==e.color?t=!0===e.flat||!0===e.outline?`text-${e.textColor||e.color}`:`bg-${e.color} text-${e.textColor||"white"}`:e.textColor&&(t=`text-${e.textColor}`),`q-btn--${p.value} `+`q-btn--${!0===e.round?"round":`rectangle${!0===u.value?" q-btn--rounded":""}`}`+(void 0!==t?" "+t:"")+(!0===c.value?" q-btn--actionable q-focusable q-hoverable":!0===e.disable?" disabled":"")+(!0===e.fab?" q-btn--fab":!0===e.fabMini?" q-btn--fab-mini":"")+(!0===e.noCaps?" q-btn--no-uppercase":"")+(!0===e.dense?" q-btn--dense":"")+(!0===e.stretch?" no-border-radius self-stretch":"")+(!0===e.glossy?" glossy":"")}),f=computed(()=>o.value+(!0===e.stack?" column":" row")+(!0===e.noWrap?" no-wrap text-no-wrap":"")+(!0===e.loading?" q-btn__content--hidden":""));return{classes:m,style:s,innerClasses:f,attributes:v,hasRouterLink:n,hasLink:a,linkTag:l,navigateToRouterLink:r,isActionable:c}}const{passiveCapture:passiveCapture}=listenOpts;let touchTarget=null,keyboardTarget=null,mouseTarget=null;var QBtn=createComponent({name:"QBtn",props:{...useBtnProps,percentage:Number,darkPercentage:Boolean},emits:["click","keydown","touchstart","mousedown","keyup"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{classes:a,style:l,innerClasses:i,attributes:r,hasRouterLink:s,hasLink:u,linkTag:c,navigateToRouterLink:d,isActionable:p}=useBtn(e),v=ref(null),m=ref(null);let f,g,b=null;const y=computed(()=>void 0!==e.label&&null!==e.label&&""!==e.label),S=computed(()=>!0!==e.disable&&!1!==e.ripple&&{keyCodes:!0===u.value?[13,32]:[13],...!0===e.ripple?{}:e.ripple}),w=computed(()=>({center:e.round})),C=computed(()=>{const t=Math.max(0,Math.min(100,e.percentage));return t>0?{transition:"transform 0.6s",transform:`translateX(${t-100}%)`}:{}}),x=computed(()=>{return!0===e.loading?{onMousedown:B,onTouchstartPassive:B,onClick:B,onKeydown:B,onKeyup:B}:!0===p.value?{onClick:_,onKeydown:q,onMousedown:P,onTouchstartPassive:T}:{onClick:stopAndPrevent}}),k=computed(()=>({ref:v,class:"q-btn q-btn-item non-selectable no-outline "+a.value,style:l.value,...r.value,...x.value}));function _(t){if(null!==v.value){if(void 0!==t){if(!0===t.defaultPrevented)return;const o=document.activeElement;if("submit"===e.type&&o!==document.body&&!1===v.value.contains(o)&&!1===o.contains(v.value)){v.value.focus();const e=()=>{document.removeEventListener("keydown",stopAndPrevent,!0),document.removeEventListener("keyup",e,passiveCapture),null!==v.value&&v.value.removeEventListener("blur",e,passiveCapture)};document.addEventListener("keydown",stopAndPrevent,!0),document.addEventListener("keyup",e,passiveCapture),v.value.addEventListener("blur",e,passiveCapture)}}if(!0===s.value){const e=()=>{t.__qNavigate=!0,d(t)};o("click",t,e),!0!==t.defaultPrevented&&e()}else o("click",t)}}function q(e){null!==v.value&&(!0===isKeyCode(e,[13,32])&&(stopAndPrevent(e),keyboardTarget!==v.value&&(null!==keyboardTarget&&M(),v.value.focus(),keyboardTarget=v.value,v.value.classList.add("q-btn--active"),document.addEventListener("keyup",$,!0),v.value.addEventListener("blur",$,passiveCapture))),o("keydown",e))}function T(e){null!==v.value&&(touchTarget!==v.value&&(null!==touchTarget&&M(),touchTarget=v.value,b=e.target,b.addEventListener("touchcancel",$,passiveCapture),b.addEventListener("touchend",$,passiveCapture)),f=!0,clearTimeout(g),g=setTimeout(()=>{f=!1},200),o("touchstart",e))}function P(e){null!==v.value&&(mouseTarget!==v.value&&(null!==mouseTarget&&M(),mouseTarget=v.value,v.value.classList.add("q-btn--active"),document.addEventListener("mouseup",$,passiveCapture)),e.qSkipRipple=!0===f,o("mousedown",e))}function $(e){if(null!==v.value&&(void 0===e||"blur"!==e.type||document.activeElement!==v.value)){if(void 0!==e&&"keyup"===e.type){if(keyboardTarget===v.value&&!0===isKeyCode(e,[13,32])){const t=new MouseEvent("click",e);t.qKeyEvent=!0,!0===e.defaultPrevented&&prevent(t),!0===e.cancelBubble&&stop(t),v.value.dispatchEvent(t),stopAndPrevent(e),e.qKeyEvent=!0}o("keyup",e)}M()}}function M(e){const t=m.value;!0===e||touchTarget!==v.value&&mouseTarget!==v.value||null===t||t===document.activeElement||(t.setAttribute("tabindex",-1),t.focus()),touchTarget===v.value&&(null!==b&&(b.removeEventListener("touchcancel",$,passiveCapture),b.removeEventListener("touchend",$,passiveCapture)),touchTarget=b=null),mouseTarget===v.value&&(document.removeEventListener("mouseup",$,passiveCapture),mouseTarget=null),keyboardTarget===v.value&&(document.removeEventListener("keyup",$,!0),null!==v.value&&v.value.removeEventListener("blur",$,passiveCapture),keyboardTarget=null),null!==v.value&&v.value.classList.remove("q-btn--active")}function B(e){stopAndPrevent(e),e.qSkipRipple=!0}return onBeforeUnmount(()=>{M(!0)}),Object.assign(n,{click:_}),()=>{let o=[];void 0!==e.icon&&o.push(h(QIcon,{name:e.icon,left:!1===e.stack&&!0===y.value,role:"img","aria-hidden":"true"})),!0===y.value&&o.push(h("span",{class:"block"},[e.label])),o=hMergeSlot(t.default,o),void 0!==e.iconRight&&!1===e.round&&o.push(h(QIcon,{name:e.iconRight,right:!1===e.stack&&!0===y.value,role:"img","aria-hidden":"true"}));const n=[h("span",{class:"q-focus-helper",ref:m})];return!0===e.loading&&void 0!==e.percentage&&n.push(h("span",{class:"q-btn__progress absolute-full overflow-hidden"},[h("span",{class:"q-btn__progress-indicator fit block"+(!0===e.darkPercentage?" q-btn__progress--dark":""),style:C.value})])),n.push(h("span",{class:"q-btn__content text-center col items-center q-anchor--skip "+i.value},o)),null!==e.loading&&n.push(h(Transition,{name:"q-transition--fade"},()=>!0===e.loading?[h("span",{key:"loading",class:"absolute-full flex flex-center"},void 0!==t.loading?t.loading():[h(QSpinner)])]:null)),withDirectives(h(c.value,k.value,n),[[Ripple,S.value,void 0,w.value]])}}}),QBtnGroup=createComponent({name:"QBtnGroup",props:{unelevated:Boolean,outline:Boolean,flat:Boolean,rounded:Boolean,push:Boolean,stretch:Boolean,glossy:Boolean,spread:Boolean},setup(e,{slots:t}){const o=computed(()=>{const t=["unelevated","outline","flat","rounded","push","stretch","glossy"].filter(t=>!0===e[t]).map(e=>`q-btn-group--${e}`).join(" ");return`q-btn-group row no-wrap${t.length>0?" "+t:""}`+(!0===e.spread?" q-btn-group--spread":" inline")});return()=>h("div",{class:o.value},hSlot(t.default))}});function clearSelection(){if(void 0!==window.getSelection){const e=window.getSelection();void 0!==e.empty?e.empty():void 0!==e.removeAllRanges&&(e.removeAllRanges(),!0!==Platform.is.mobile&&e.addRange(document.createRange()))}else void 0!==document.selection&&document.selection.empty()}const useAnchorProps={target:{default:!0},noParentEvent:Boolean,contextMenu:Boolean};function useAnchor({showing:e,avoidEmit:t,configureAnchorEl:o}){const{props:n,proxy:a,emit:l}=getCurrentInstance(),i=ref(null);let r;function s(e){return null!==i.value&&(void 0===e||void 0===e.touches||e.touches.length<=1)}const u={};function c(){cleanEvt(u,"anchor")}function d(e){i.value=e;while(i.value.classList.contains("q-anchor--skip"))i.value=i.value.parentNode;o()}function p(){if(!1===n.target||""===n.target)i.value=null;else if(!0===n.target)d(a.$el.parentNode);else{let e=n.target;if("string"===typeof n.target)try{e=document.querySelector(n.target)}catch(t){e=void 0}void 0!==e&&null!==e?(i.value=e.$el||e,o()):(i.value=null,console.error(`Anchor: target "${n.target}" not found`))}}return void 0===o&&(Object.assign(u,{hide(e){a.hide(e)},toggle(e){a.toggle(e),e.qAnchorHandled=!0},toggleKey(e){!0===isKeyCode(e,13)&&u.toggle(e)},contextClick(e){a.hide(e),prevent(e),nextTick(()=>{a.show(e),e.qAnchorHandled=!0})},prevent:prevent,mobileTouch(e){if(u.mobileCleanup(e),!0!==s(e))return;a.hide(e),i.value.classList.add("non-selectable");const t=e.target;addEvt(u,"anchor",[[t,"touchmove","mobileCleanup","passive"],[t,"touchend","mobileCleanup","passive"],[t,"touchcancel","mobileCleanup","passive"],[i.value,"contextmenu","prevent","notPassive"]]),r=setTimeout(()=>{a.show(e),e.qAnchorHandled=!0},300)},mobileCleanup(t){i.value.classList.remove("non-selectable"),clearTimeout(r),!0===e.value&&void 0!==t&&clearSelection()}}),o=function(e=n.contextMenu){if(!0===n.noParentEvent||null===i.value)return;let t;t=!0===e?!0===a.$q.platform.is.mobile?[[i.value,"touchstart","mobileTouch","passive"]]:[[i.value,"mousedown","hide","passive"],[i.value,"contextmenu","contextClick","notPassive"]]:[[i.value,"click","toggle","passive"],[i.value,"keyup","toggleKey","passive"]],addEvt(u,"anchor",t)}),watch(()=>n.contextMenu,e=>{null!==i.value&&(c(),o(e))}),watch(()=>n.target,()=>{null!==i.value&&c(),p()}),watch(()=>n.noParentEvent,e=>{null!==i.value&&(!0===e?c():o())}),onMounted(()=>{p(),!0!==t&&!0===n.modelValue&&null===i.value&&l("update:modelValue",!1)}),onBeforeUnmount(()=>{clearTimeout(r),c()}),{anchorEl:i,canShow:s,anchorEvents:u}}function useScrollTarget(e,t){const o=ref(null);let n;function a(e,t){const o=`${void 0!==t?"add":"remove"}EventListener`,a=void 0!==t?t:n;e!==window&&e[o]("scroll",a,listenOpts.passive),window[o]("scroll",a,listenOpts.passive),n=t}function l(){null!==o.value&&(a(o.value),o.value=null)}const i=watch(()=>e.noParentEvent,()=>{null!==o.value&&(l(),t())});return onBeforeUnmount(i),{localScrollTarget:o,unconfigureScrollTarget:l,changeScrollEvent:a}}const useModelToggleProps={modelValue:{type:Boolean,default:null},"onUpdate:modelValue":[Function,Array]},useModelToggleEmits=["before-show","show","before-hide","hide"];function useModelToggle({showing:e,canShow:t,hideOnRouteChange:o,handleShow:n,handleHide:a,processOnMount:l}){const i=getCurrentInstance(),{props:r,emit:s,proxy:u}=i;let c;function d(t){!0===e.value?m(t):p(t)}function p(e){if(!0===r.disable||void 0!==e&&!0===e.qAnchorHandled||void 0!==t&&!0!==t(e))return;const o=void 0!==r["onUpdate:modelValue"];!0===o&&(s("update:modelValue",!0),c=e,nextTick(()=>{c===e&&(c=void 0)})),null!==r.modelValue&&!1!==o||v(e)}function v(t){!0!==e.value&&(e.value=!0,s("before-show",t),void 0!==n?n(t):s("show",t))}function m(e){if(!0===r.disable)return;const t=void 0!==r["onUpdate:modelValue"];!0===t&&(s("update:modelValue",!1),c=e,nextTick(()=>{c===e&&(c=void 0)})),null!==r.modelValue&&!1!==t||f(e)}function f(t){!1!==e.value&&(e.value=!1,s("before-hide",t),void 0!==a?a(t):s("hide",t))}function h(t){if(!0===r.disable&&!0===t)void 0!==r["onUpdate:modelValue"]&&s("update:modelValue",!1);else if(!0===t!==e.value){const e=!0===t?v:f;e(c)}}watch(()=>r.modelValue,h),void 0!==o&&!0===vmHasRouter(i)&&watch(()=>u.$route.fullPath,()=>{!0===o.value&&!0===e.value&&m()}),!0===l&&onMounted(()=>{h(r.modelValue)});const g={show:p,hide:m,toggle:d};return Object.assign(u,g),g}let queue=[],waitFlags=[];function clearFlag(e){waitFlags=waitFlags.filter(t=>t!==e)}function addFocusWaitFlag(e){clearFlag(e),waitFlags.push(e)}function removeFocusWaitFlag(e){clearFlag(e),0===waitFlags.length&&queue.length>0&&(queue[queue.length-1](),queue=[])}function addFocusFn(e){0===waitFlags.length?e():queue.push(e)}function removeFocusFn(e){queue=queue.filter(t=>t!==e)}const globalNodes=[];let target=document.body;function createGlobalNode(e){const t=document.createElement("div");if(void 0!==e&&(t.id=e),void 0!==globalConfig.globalNodes){const e=globalConfig.globalNodes.class;void 0!==e&&(t.className=e)}return target.appendChild(t),globalNodes.push(t),t}function removeGlobalNode(e){globalNodes.splice(globalNodes.indexOf(e),1),e.remove()}function changeGlobalNodesTarget(e){e!==target&&(target=e,globalNodes.forEach(e=>{!1===e.contains(target)&&target.appendChild(e)}))}const portalList=[];function getPortalVm(e){return portalList.find(t=>null!==t.__qPortalInnerRef.value&&t.__qPortalInnerRef.value.contains(e))}function closePortalMenus(e,t){do{if("QMenu"===e.$options.name){if(e.hide(t),!0===e.$props.separateClosePopup)return getParentVm(e)}else if(void 0!==e.__qPortalInnerRef){const o=getParentVm(e);return void 0!==o&&"QPopupProxy"===o.$options.name?(e.hide(t),o):e}e=getParentVm(e)}while(void 0!==e&&null!==e)}function closePortals(e,t,o){while(0!==o&&void 0!==e&&null!==e){if(void 0!==e.__qPortalInnerRef){if(o--,"QMenu"===e.$options.name){e=closePortalMenus(e,t);continue}e.hide(t)}e=getParentVm(e)}}function isOnGlobalDialog(e){e=e.parent;while(void 0!==e&&null!==e){if("QGlobalDialog"===e.type.name)return!0;if("QDialog"===e.type.name||"QMenu"===e.type.name)return!1;e=e.parent}return!1}function usePortal(e,t,o,n){const a=ref(!1);let l=null;const i={},r=!0===n&&isOnGlobalDialog(e);function s(t){!0!==t?!1===a.value&&(!1===r&&null===l&&(l=createGlobalNode()),a.value=!0,portalList.push(e.proxy),addFocusWaitFlag(i)):removeFocusWaitFlag(i)}function u(){removeFocusWaitFlag(i),a.value=!1;const t=portalList.indexOf(e.proxy);t>-1&&portalList.splice(t,1),null!==l&&(removeGlobalNode(l),l=null)}return onUnmounted(u),Object.assign(e.proxy,{__qPortalInnerRef:t}),{showPortal:s,hidePortal:u,portalIsActive:a,renderPortal:()=>!0===r?o():!0===a.value?[h(Teleport,{to:l},o())]:void 0}}const useTransitionProps={transitionShow:{type:String,default:"fade"},transitionHide:{type:String,default:"fade"},transitionDuration:{type:[String,Number],default:300}};function useTransition(e,t){const o=ref(t.value);return watch(t,e=>{nextTick(()=>{o.value=e})}),{transition:computed(()=>"q-transition--"+(!0===o.value?e.transitionHide:e.transitionShow)),transitionStyle:computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`)}}function useTick(){let e;return onBeforeUnmount(()=>{e=void 0}),{registerTick(t){e=t,nextTick(()=>{e===t&&(e(),e=void 0)})},removeTick(){e=void 0}}}function useTimeout(){let e;return onBeforeUnmount(()=>{clearTimeout(e)}),{registerTimeout(t,o){clearTimeout(e),e=setTimeout(t,o)},removeTimeout(){clearTimeout(e)}}}const scrollTargets=[null,document,document.body,document.scrollingElement,document.documentElement];function getScrollTarget(e,t){let o=getElement$1(t);if(void 0===o){if(void 0===e||null===e)return window;o=e.closest(".scroll,.scroll-y,.overflow-auto")}return scrollTargets.includes(o)?window:o}function getScrollHeight(e){return(e===window?document.body:e).scrollHeight}function getScrollWidth(e){return(e===window?document.body:e).scrollWidth}function getVerticalScrollPosition(e){return e===window?window.pageYOffset||window.scrollY||document.body.scrollTop||0:e.scrollTop}function getHorizontalScrollPosition(e){return e===window?window.pageXOffset||window.scrollX||document.body.scrollLeft||0:e.scrollLeft}function animVerticalScrollTo(e,t,o=0){const n=void 0===arguments[3]?performance.now():arguments[3],a=getVerticalScrollPosition(e);o<=0?a!==t&&setScroll$1(e,t):requestAnimationFrame(l=>{const i=l-n,r=a+(t-a)/Math.max(i,o)*i;setScroll$1(e,r),r!==t&&animVerticalScrollTo(e,t,o-i,l)})}function animHorizontalScrollTo(e,t,o=0){const n=void 0===arguments[3]?performance.now():arguments[3],a=getHorizontalScrollPosition(e);o<=0?a!==t&&setHorizontalScroll(e,t):requestAnimationFrame(l=>{const i=l-n,r=a+(t-a)/Math.max(i,o)*i;setHorizontalScroll(e,r),r!==t&&animHorizontalScrollTo(e,t,o-i,l)})}function setScroll$1(e,t){e!==window?e.scrollTop=t:window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,t)}function setHorizontalScroll(e,t){e!==window?e.scrollLeft=t:window.scrollTo(t,window.pageYOffset||window.scrollY||document.body.scrollTop||0)}function setVerticalScrollPosition(e,t,o){o?animVerticalScrollTo(e,t,o):setScroll$1(e,t)}function setHorizontalScrollPosition(e,t,o){o?animHorizontalScrollTo(e,t,o):setHorizontalScroll(e,t)}let size;function getScrollbarWidth(){if(void 0!==size)return size;const e=document.createElement("p"),t=document.createElement("div");css(e,{width:"100%",height:"200px"}),css(t,{position:"absolute",top:"0px",left:"0px",visibility:"hidden",width:"200px",height:"150px",overflow:"hidden"}),t.appendChild(e),document.body.appendChild(t);const o=e.offsetWidth;t.style.overflow="scroll";let n=e.offsetWidth;return o===n&&(n=t.clientWidth),t.remove(),size=o-n,size}function hasScrollbar(e,t=!0){return!(!e||e.nodeType!==Node.ELEMENT_NODE)&&(t?e.scrollHeight>e.clientHeight&&(e.classList.contains("scroll")||e.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(e)["overflow-y"])):e.scrollWidth>e.clientWidth&&(e.classList.contains("scroll")||e.classList.contains("overflow-auto")||["auto","scroll"].includes(window.getComputedStyle(e)["overflow-x"])))}var scroll={getScrollTarget:getScrollTarget,getScrollHeight:getScrollHeight,getScrollWidth:getScrollWidth,getVerticalScrollPosition:getVerticalScrollPosition,getHorizontalScrollPosition:getHorizontalScrollPosition,animVerticalScrollTo:animVerticalScrollTo,animHorizontalScrollTo:animHorizontalScrollTo,setVerticalScrollPosition:setVerticalScrollPosition,setHorizontalScrollPosition:setHorizontalScrollPosition,getScrollbarWidth:getScrollbarWidth,hasScrollbar:hasScrollbar};const handlers$1=[];let escDown;function onKeydown(e){escDown=27===e.keyCode}function onBlur(){!0===escDown&&(escDown=!1)}function onKeyup(e){!0===escDown&&(escDown=!1,!0===isKeyCode(e,27)&&handlers$1[handlers$1.length-1](e))}function update$4(e){window[e]("keydown",onKeydown),window[e]("blur",onBlur),window[e]("keyup",onKeyup),escDown=!1}function addEscapeKey(e){!0===client.is.desktop&&(handlers$1.push(e),1===handlers$1.length&&update$4("addEventListener"))}function removeEscapeKey(e){const t=handlers$1.indexOf(e);t>-1&&(handlers$1.splice(t,1),0===handlers$1.length&&update$4("removeEventListener"))}const handlers=[];function trigger$1(e){handlers[handlers.length-1](e)}function addFocusout(e){!0===client.is.desktop&&(handlers.push(e),1===handlers.length&&document.body.addEventListener("focusin",trigger$1))}function removeFocusout(e){const t=handlers.indexOf(e);t>-1&&(handlers.splice(t,1),0===handlers.length&&document.body.removeEventListener("focusin",trigger$1))}let timer;const{notPassiveCapture:notPassiveCapture}=listenOpts,registeredList=[];function globalHandler(e){clearTimeout(timer);const t=e.target;if(void 0===t||8===t.nodeType||!0===t.classList.contains("no-pointer-events"))return;let o=portalList.length-1;while(o>=0){const e=portalList[o].$;if("QDialog"!==e.type.name)break;if(!0!==e.props.seamless)return;o--}for(let n=registeredList.length-1;n>=0;n--){const o=registeredList[n];if(null!==o.anchorEl.value&&!1!==o.anchorEl.value.contains(t)||t!==document.body&&(null===o.innerRef.value||!1!==o.innerRef.value.contains(t)))return;e.qClickOutside=!0,o.onClickOutside(e)}}function addClickOutside(e){registeredList.push(e),1===registeredList.length&&(document.addEventListener("mousedown",globalHandler,notPassiveCapture),document.addEventListener("touchstart",globalHandler,notPassiveCapture))}function removeClickOutside(e){const t=registeredList.findIndex(t=>t===e);t>-1&&(registeredList.splice(t,1),0===registeredList.length&&(clearTimeout(timer),document.removeEventListener("mousedown",globalHandler,notPassiveCapture),document.removeEventListener("touchstart",globalHandler,notPassiveCapture)))}let vpLeft,vpTop;function validatePosition(e){const t=e.split(" ");return 2===t.length&&(!0!==["top","center","bottom"].includes(t[0])?(console.error("Anchor/Self position must start with one of top/center/bottom"),!1):!0===["left","middle","right","start","end"].includes(t[1])||(console.error("Anchor/Self position must end with one of left/middle/right/start/end"),!1))}function validateOffset(e){return!e||2===e.length&&("number"===typeof e[0]&&"number"===typeof e[1])}const horizontalPos={"start#ltr":"left","start#rtl":"right","end#ltr":"right","end#rtl":"left"};function parsePosition(e,t){const o=e.split(" ");return{vertical:o[0],horizontal:horizontalPos[`${o[1]}#${!0===t?"rtl":"ltr"}`]}}function getAnchorProps(e,t){let{top:o,left:n,right:a,bottom:l,width:i,height:r}=e.getBoundingClientRect();return void 0!==t&&(o-=t[1],n-=t[0],l+=t[1],a+=t[0],i+=t[0],r+=t[1]),{top:o,left:n,right:a,bottom:l,width:i,height:r,middle:n+(a-n)/2,center:o+(l-o)/2}}function getTargetProps(e){return{top:0,center:e.offsetHeight/2,bottom:e.offsetHeight,left:0,middle:e.offsetWidth/2,right:e.offsetWidth}}function setPosition(e){if(!0===client.is.ios&&void 0!==window.visualViewport){const e=document.body.style,{offsetLeft:t,offsetTop:o}=window.visualViewport;t!==vpLeft&&(e.setProperty("--q-pe-left",t+"px"),vpLeft=t),o!==vpTop&&(e.setProperty("--q-pe-top",o+"px"),vpTop=o)}let t;const{scrollLeft:o,scrollTop:n}=e.el;if(void 0===e.absoluteOffset)t=getAnchorProps(e.anchorEl,!0===e.cover?[0,0]:e.offset);else{const{top:o,left:n}=e.anchorEl.getBoundingClientRect(),a=o+e.absoluteOffset.top,l=n+e.absoluteOffset.left;t={top:a,left:l,width:1,height:1,right:l+1,center:a,middle:l,bottom:a+1}}let a={maxHeight:e.maxHeight,maxWidth:e.maxWidth,visibility:"visible"};!0!==e.fit&&!0!==e.cover||(a.minWidth=t.width+"px",!0===e.cover&&(a.minHeight=t.height+"px")),Object.assign(e.el.style,a);const l=getTargetProps(e.el),i={top:t[e.anchorOrigin.vertical]-l[e.selfOrigin.vertical],left:t[e.anchorOrigin.horizontal]-l[e.selfOrigin.horizontal]};applyBoundaries(i,t,l,e.anchorOrigin,e.selfOrigin),a={top:i.top+"px",left:i.left+"px"},void 0!==i.maxHeight&&(a.maxHeight=i.maxHeight+"px",t.height>i.maxHeight&&(a.minHeight=a.maxHeight)),void 0!==i.maxWidth&&(a.maxWidth=i.maxWidth+"px",t.width>i.maxWidth&&(a.minWidth=a.maxWidth)),Object.assign(e.el.style,a),e.el.scrollTop!==n&&(e.el.scrollTop=n),e.el.scrollLeft!==o&&(e.el.scrollLeft=o)}function applyBoundaries(e,t,o,n,a){const l=o.bottom,i=o.right,r=getScrollbarWidth(),s=window.innerHeight-r,u=document.body.clientWidth;if(e.top<0||e.top+l>s)if("center"===a.vertical)e.top=t[n.vertical]>s/2?Math.max(0,s-l):0,e.maxHeight=Math.min(l,s);else if(t[n.vertical]>s/2){const o=Math.min(s,"center"===n.vertical?t.center:n.vertical===a.vertical?t.bottom:t.top);e.maxHeight=Math.min(l,o),e.top=Math.max(0,o-l)}else e.top=Math.max(0,"center"===n.vertical?t.center:n.vertical===a.vertical?t.top:t.bottom),e.maxHeight=Math.min(l,s-e.top);if(e.left<0||e.left+i>u)if(e.maxWidth=Math.min(i,u),"middle"===a.horizontal)e.left=t[n.horizontal]>u/2?Math.max(0,u-i):0;else if(t[n.horizontal]>u/2){const o=Math.min(u,"middle"===n.horizontal?t.middle:n.horizontal===a.horizontal?t.right:t.left);e.maxWidth=Math.min(i,o),e.left=Math.max(0,o-e.maxWidth)}else e.left=Math.max(0,"middle"===n.horizontal?t.middle:n.horizontal===a.horizontal?t.left:t.right),e.maxWidth=Math.min(i,u-e.left)}["left","middle","right"].forEach(e=>{horizontalPos[`${e}#ltr`]=e,horizontalPos[`${e}#rtl`]=e});var QMenu=createComponent({name:"QMenu",inheritAttrs:!1,props:{...useAnchorProps,...useModelToggleProps,...useDarkProps,...useTransitionProps,persistent:Boolean,autoClose:Boolean,separateClosePopup:Boolean,noRouteDismiss:Boolean,noRefocus:Boolean,noFocus:Boolean,fit:Boolean,cover:Boolean,square:Boolean,anchor:{type:String,validator:validatePosition},self:{type:String,validator:validatePosition},offset:{type:Array,validator:validateOffset},scrollTarget:{default:void 0},touchPosition:Boolean,maxHeight:{type:String,default:null},maxWidth:{type:String,default:null}},emits:[...useModelToggleEmits,"click","escape-key"],setup(e,{slots:t,emit:o,attrs:n}){let a,l,i,r=null;const s=getCurrentInstance(),{proxy:u}=s,{$q:c}=u,d=ref(null),p=ref(!1),v=computed(()=>!0!==e.persistent&&!0!==e.noRouteDismiss),m=useDark(e,c),{registerTick:f,removeTick:g}=useTick(),{registerTimeout:b,removeTimeout:y}=useTimeout(),{transition:S,transitionStyle:w}=useTransition(e,p),{localScrollTarget:C,changeScrollEvent:x,unconfigureScrollTarget:k}=useScrollTarget(e,I),{anchorEl:_,canShow:q}=useAnchor({showing:p}),{hide:T}=useModelToggle({showing:p,canShow:q,handleShow:A,handleHide:F,hideOnRouteChange:v,processOnMount:!0}),{showPortal:P,hidePortal:$,renderPortal:M}=usePortal(s,d,U),B={anchorEl:_,innerRef:d,onClickOutside(t){if(!0!==e.persistent&&!0===p.value)return T(t),("touchstart"===t.type||t.target.classList.contains("q-dialog__backdrop"))&&stopAndPrevent(t),!0}},Q=computed(()=>parsePosition(e.anchor||(!0===e.cover?"center middle":"bottom start"),c.lang.rtl)),E=computed(()=>!0===e.cover?Q.value:parsePosition(e.self||"top start",c.lang.rtl)),O=computed(()=>(!0===e.square?" q-menu--square":"")+(!0===m.value?" q-menu--dark q-dark":"")),R=computed(()=>!0===e.autoClose?{onClick:V}:{}),L=computed(()=>!0===p.value&&!0!==e.persistent);function z(){addFocusFn(()=>{let e=d.value;e&&!0!==e.contains(document.activeElement)&&(e=e.querySelector("[autofocus], [data-autofocus]")||e,e.focus({preventScroll:!0}))})}function A(t){if(g(),y(),r=!1===e.noRefocus?document.activeElement:null,addFocusout(N),P(),I(),a=void 0,void 0!==t&&(e.touchPosition||e.contextMenu)){const e=position(t);if(void 0!==e.left){const{top:t,left:o}=_.value.getBoundingClientRect();a={left:e.left-o,top:e.top-t}}}void 0===l&&(l=watch(()=>c.screen.width+"|"+c.screen.height+"|"+e.self+"|"+e.anchor+"|"+c.lang.rtl,j)),!0!==e.noFocus&&document.activeElement.blur(),f(()=>{j(),!0!==e.noFocus&&z()}),b(()=>{!0===c.platform.is.ios&&(i=e.autoClose,d.value.click()),j(),P(!0),o("show",t)},e.transitionDuration)}function F(t){g(),y(),D(!0),null===r||void 0!==t&&!0===t.qClickOutside||(r.focus(),r=null),b(()=>{$(),o("hide",t)},e.transitionDuration)}function D(e){a=void 0,void 0!==l&&(l(),l=void 0),!0!==e&&!0!==p.value||(removeFocusout(N),k(),removeClickOutside(B),removeEscapeKey(H)),!0!==e&&(r=null)}function I(){null===_.value&&void 0===e.scrollTarget||(C.value=getScrollTarget(_.value,e.scrollTarget),x(C.value,j))}function V(e){!0!==i?(closePortalMenus(u,e),o("click",e)):i=!1}function N(t){!0===L.value&&!0!==e.noFocus&&!0!==childHasFocus(d.value,t.target)&&z()}function H(e){o("escape-key"),T(e)}function j(){const t=d.value;null!==t&&null!==_.value&&setPosition({el:t,offset:e.offset,anchorEl:_.value,anchorOrigin:Q.value,selfOrigin:E.value,absoluteOffset:a,fit:e.fit,cover:e.cover,maxHeight:e.maxHeight,maxWidth:e.maxWidth})}function U(){return h(Transition,{name:S.value,appear:!0},()=>!0===p.value?h("div",{...n,ref:d,tabindex:-1,class:["q-menu q-position-engine scroll"+O.value,n.class],style:[n.style,w.value],...R.value},hSlot(t.default)):null)}return watch(L,e=>{!0===e?(addEscapeKey(H),addClickOutside(B)):(removeEscapeKey(H),removeClickOutside(B))}),onBeforeUnmount(D),Object.assign(u,{focus:z,updatePosition:j}),M}}),QBtnDropdown=createComponent({name:"QBtnDropdown",props:{...useBtnProps,modelValue:Boolean,split:Boolean,dropdownIcon:String,contentClass:[Array,String,Object],contentStyle:[Array,String,Object],cover:Boolean,persistent:Boolean,noRouteDismiss:Boolean,autoClose:Boolean,menuAnchor:{type:String,default:"bottom end"},menuSelf:{type:String,default:"top end"},menuOffset:Array,disableMainBtn:Boolean,disableDropdown:Boolean,noIconAnimation:Boolean},emits:["update:modelValue","click","before-show","show","before-hide","hide"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),a=ref(e.modelValue),l=ref(null),i=computed(()=>{const t={"aria-expanded":!0===a.value?"true":"false","aria-haspopup":"true"};return(!0===e.disable||!1===e.split&&!0===e.disableMainBtn||!0===e.disableDropdown)&&(t["aria-disabled"]="true"),t}),r=computed(()=>"q-btn-dropdown__arrow"+(!0===a.value&&!1===e.noIconAnimation?" rotate-180":"")+(!1===e.split?" q-btn-dropdown__arrow-container":""));function s(e){a.value=!0,o("before-show",e)}function u(e){o("show",e),o("update:modelValue",!0)}function c(e){a.value=!1,o("before-hide",e)}function d(e){o("hide",e),o("update:modelValue",!1)}function p(e){o("click",e)}function v(e){stop(e),g(),o("click",e)}function m(e){null!==l.value&&l.value.toggle(e)}function f(e){null!==l.value&&l.value.show(e)}function g(e){null!==l.value&&l.value.hide(e)}return watch(()=>e.modelValue,e=>{null!==l.value&&l.value[e?"show":"hide"]()}),watch(()=>e.split,g),Object.assign(n,{show:f,hide:g,toggle:m}),onMounted(()=>{!0===e.modelValue&&f()}),()=>{const o=[h(QIcon,{class:r.value,name:e.dropdownIcon||n.$q.iconSet.arrow.dropdown})];return!0!==e.disableDropdown&&o.push(h(QMenu,{ref:l,class:e.contentClass,style:e.contentStyle,cover:e.cover,fit:!0,persistent:e.persistent,noRouteDismiss:e.noRouteDismiss,autoClose:e.autoClose,anchor:e.menuAnchor,self:e.menuSelf,offset:e.menuOffset,separateClosePopup:!0,onBeforeShow:s,onShow:u,onBeforeHide:c,onHide:d},t.default)),!1===e.split?h(QBtn,{class:"q-btn-dropdown q-btn-dropdown--simple",...e,disable:!0===e.disable||!0===e.disableMainBtn,noWrap:!0,round:!1,...i.value,onClick:p},()=>hSlot(t.label,[]).concat(o)):h(QBtnGroup,{class:"q-btn-dropdown q-btn-dropdown--split no-wrap q-btn-item",outline:e.outline,flat:e.flat,rounded:e.rounded,push:e.push,unelevated:e.unelevated,glossy:e.glossy,stretch:e.stretch},()=>[h(QBtn,{class:"q-btn-dropdown--current",...e,disable:!0===e.disable||!0===e.disableMainBtn,noWrap:!0,iconRight:e.iconRight,round:!1,onClick:v},t.label),h(QBtn,{class:"q-btn-dropdown__arrow-container q-anchor--skip",...i.value,disable:!0===e.disable||!0===e.disableDropdown,outline:e.outline,flat:e.flat,rounded:e.rounded,push:e.push,size:e.size,color:e.color,textColor:e.textColor,dense:e.dense,ripple:e.ripple},()=>o)])}}});const useFormProps={name:String};function useFormAttrs(e){return computed(()=>({type:"hidden",name:e.name,value:e.modelValue}))}function useFormInject(e={}){return(t,o,n)=>{t[o](h("input",{class:"hidden"+(n||""),...e.value}))}}function useFormInputNameAttr(e){return computed(()=>e.name||e.for)}var QBtnToggle=createComponent({name:"QBtnToggle",props:{...useFormProps,modelValue:{required:!0},options:{type:Array,required:!0,validator:e=>e.every(e=>("label"in e||"icon"in e||"slot"in e)&&"value"in e)},color:String,textColor:String,toggleColor:{type:String,default:"primary"},toggleTextColor:String,outline:Boolean,flat:Boolean,unelevated:Boolean,rounded:Boolean,push:Boolean,glossy:Boolean,size:String,padding:String,noCaps:Boolean,noWrap:Boolean,dense:Boolean,readonly:Boolean,disable:Boolean,stack:Boolean,stretch:Boolean,spread:Boolean,clearable:Boolean,ripple:{type:[Boolean,Object],default:!0}},emits:["update:modelValue","clear","click"],setup(e,{slots:t,emit:o}){const n=computed(()=>void 0!==e.options.find(t=>t.value===e.modelValue)),a=computed(()=>({type:"hidden",name:e.name,value:e.modelValue})),l=useFormInject(a),i=computed(()=>e.options.map((t,o)=>{const{attrs:n,value:a,slot:l,...i}=t;return{slot:l,props:{key:o,onClick(e){r(a,t,e)},"aria-pressed":a===e.modelValue?"true":"false",...n,...i,outline:e.outline,flat:e.flat,rounded:e.rounded,push:e.push,unelevated:e.unelevated,dense:e.dense,disable:!0===e.disable||!0===i.disable,color:a===e.modelValue?s(i,"toggleColor"):s(i,"color"),textColor:a===e.modelValue?s(i,"toggleTextColor"):s(i,"textColor"),noCaps:!0===s(i,"noCaps"),noWrap:!0===s(i,"noWrap"),size:s(i,"size"),padding:s(i,"padding"),ripple:s(i,"ripple"),stack:!0===s(i,"stack"),stretch:!0===s(i,"stretch")}}}));function r(t,n,a){!0!==e.readonly&&(e.modelValue===t?!0===e.clearable&&(o("update:modelValue",null,null),o("clear")):o("update:modelValue",t,n),o("click",a))}function s(t,o){return void 0===t[o]?e[o]:t[o]}function u(){const o=i.value.map(e=>{return h(QBtn,e.props,void 0!==e.slot?t[e.slot]:void 0)});return void 0!==e.name&&!0!==e.disable&&!0===n.value&&l(o,"push"),hMergeSlot(t.default,o)}return()=>h(QBtnGroup,{class:"q-btn-toggle",outline:e.outline,flat:e.flat,rounded:e.rounded,push:e.push,stretch:e.stretch,unelevated:e.unelevated,glossy:e.glossy,spread:e.spread},u)}}),QCard=createComponent({name:"QCard",props:{...useDarkProps,tag:{type:String,default:"div"},square:Boolean,flat:Boolean,bordered:Boolean},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>"q-card"+(!0===n.value?" q-card--dark q-dark":"")+(!0===e.bordered?" q-card--bordered":"")+(!0===e.square?" q-card--square no-border-radius":"")+(!0===e.flat?" q-card--flat no-shadow":""));return()=>h(e.tag,{class:a.value},hSlot(t.default))}}),QCardSection=createComponent({name:"QCardSection",props:{tag:{type:String,default:"div"},horizontal:Boolean},setup(e,{slots:t}){const o=computed(()=>"q-card__section"+` q-card__section--${!0===e.horizontal?"horiz row no-wrap":"vert"}`);return()=>h(e.tag,{class:o.value},hSlot(t.default))}}),QCardActions=createComponent({name:"QCardActions",props:{...useAlignProps,vertical:Boolean},setup(e,{slots:t}){const o=useAlign(e),n=computed(()=>`q-card__actions ${o.value}`+` q-card__actions--${!0===e.vertical?"vert column":"horiz row"}`);return()=>h("div",{class:n.value},hSlot(t.default))}});const modifiersAll={left:!0,right:!0,up:!0,down:!0,horizontal:!0,vertical:!0},directionList=Object.keys(modifiersAll);function getModifierDirections(e){const t={};for(const o of directionList)!0===e[o]&&(t[o]=!0);return 0===Object.keys(t).length?modifiersAll:(!0===t.horizontal?t.left=t.right=!0:!0===t.left&&!0===t.right&&(t.horizontal=!0),!0===t.vertical?t.up=t.down=!0:!0===t.up&&!0===t.down&&(t.vertical=!0),!0===t.horizontal&&!0===t.vertical&&(t.all=!0),t)}function shouldStart(e,t){return void 0===t.event&&void 0!==e.target&&!0!==e.target.draggable&&"function"===typeof t.handler&&"INPUT"!==e.target.nodeName.toUpperCase()&&(void 0===e.qClonedBy||-1===e.qClonedBy.indexOf(t.uid))}function parseArg(e){const t=[.06,6,50];return"string"===typeof e&&e.length&&e.split(":").forEach((e,o)=>{const n=parseFloat(e);n&&(t[o]=n)}),t}modifiersAll.all=!0;var TouchSwipe=createDirective({name:"touch-swipe",beforeMount(e,{value:t,arg:o,modifiers:n}){if(!0!==n.mouse&&!0!==client.has.touch)return;const a=!0===n.mouseCapture?"Capture":"",l={handler:t,sensitivity:parseArg(o),direction:getModifierDirections(n),noop:noop,mouseStart(e){shouldStart(e,l)&&leftClick(e)&&(addEvt(l,"temp",[[document,"mousemove","move",`notPassive${a}`],[document,"mouseup","end","notPassiveCapture"]]),l.start(e,!0))},touchStart(e){if(shouldStart(e,l)){const t=e.target;addEvt(l,"temp",[[t,"touchmove","move","notPassiveCapture"],[t,"touchcancel","end","notPassiveCapture"],[t,"touchend","end","notPassiveCapture"]]),l.start(e)}},start(t,o){!0===client.is.firefox&&preventDraggable(e,!0);const n=position(t);l.event={x:n.left,y:n.top,time:Date.now(),mouse:!0===o,dir:!1}},move(e){if(void 0===l.event)return;if(!1!==l.event.dir)return void stopAndPrevent(e);const t=Date.now()-l.event.time;if(0===t)return;const o=position(e),n=o.left-l.event.x,a=Math.abs(n),i=o.top-l.event.y,r=Math.abs(i);if(!0!==l.event.mouse){if(a<l.sensitivity[1]&&r<l.sensitivity[1])return void l.end(e)}else if(a<l.sensitivity[2]&&r<l.sensitivity[2])return;const s=a/t,u=r/t;!0===l.direction.vertical&&a<r&&a<100&&u>l.sensitivity[0]&&(l.event.dir=i<0?"up":"down"),!0===l.direction.horizontal&&a>r&&r<100&&s>l.sensitivity[0]&&(l.event.dir=n<0?"left":"right"),!0===l.direction.up&&a<r&&i<0&&a<100&&u>l.sensitivity[0]&&(l.event.dir="up"),!0===l.direction.down&&a<r&&i>0&&a<100&&u>l.sensitivity[0]&&(l.event.dir="down"),!0===l.direction.left&&a>r&&n<0&&r<100&&s>l.sensitivity[0]&&(l.event.dir="left"),!0===l.direction.right&&a>r&&n>0&&r<100&&s>l.sensitivity[0]&&(l.event.dir="right"),!1!==l.event.dir?(stopAndPrevent(e),!0===l.event.mouse&&(document.body.classList.add("no-pointer-events--children"),document.body.classList.add("non-selectable"),clearSelection(),l.styleCleanup=(e=>{l.styleCleanup=void 0,document.body.classList.remove("non-selectable");const t=()=>{document.body.classList.remove("no-pointer-events--children")};!0===e?setTimeout(t,50):t()})),l.handler({evt:e,touch:!0!==l.event.mouse,mouse:l.event.mouse,direction:l.event.dir,duration:t,distance:{x:a,y:r}})):l.end(e)},end(t){void 0!==l.event&&(cleanEvt(l,"temp"),!0===client.is.firefox&&preventDraggable(e,!1),void 0!==l.styleCleanup&&l.styleCleanup(!0),void 0!==t&&!1!==l.event.dir&&stopAndPrevent(t),l.event=void 0)}};e.__qtouchswipe=l,!0===n.mouse&&addEvt(l,"main",[[e,"mousedown","mouseStart",`passive${a}`]]),!0===client.has.touch&&addEvt(l,"main",[[e,"touchstart","touchStart",`passive${!0===n.capture?"Capture":""}`],[e,"touchmove","noop","notPassiveCapture"]])},updated(e,t){const o=e.__qtouchswipe;void 0!==o&&(t.oldValue!==t.value&&("function"!==typeof t.value&&o.end(),o.handler=t.value),o.direction=getModifierDirections(t.modifiers))},beforeUnmount(e){const t=e.__qtouchswipe;void 0!==t&&(cleanEvt(t,"main"),cleanEvt(t,"temp"),!0===client.is.firefox&&preventDraggable(e,!1),void 0!==t.styleCleanup&&t.styleCleanup(),delete e.__qtouchswipe)}});function useCache(){const e=new Map;return{getCache:function(t,o){return void 0===e[t]?e[t]=o:e[t]},getCacheWithFn:function(t,o){return void 0===e[t]?e[t]=o():e[t]}}}const usePanelChildProps={name:{required:!0},disable:Boolean},PanelWrapper$1={setup(e,{slots:t}){return()=>h("div",{class:"q-panel scroll",role:"tabpanel"},hSlot(t.default))}},usePanelProps={modelValue:{required:!0},animated:Boolean,infinite:Boolean,swipeable:Boolean,vertical:Boolean,transitionPrev:String,transitionNext:String,transitionDuration:{type:[String,Number],default:300},keepAlive:Boolean,keepAliveInclude:[String,Array,RegExp],keepAliveExclude:[String,Array,RegExp],keepAliveMax:Number},usePanelEmits=["update:modelValue","before-transition","transition"];function usePanel(){const{props:e,emit:t,proxy:o}=getCurrentInstance(),{getCacheWithFn:n}=useCache();let a,l;const i=ref(null),r=ref(null);function s(t){const n=!0===e.vertical?"up":"left";k((!0===o.$q.lang.rtl?-1:1)*(t.direction===n?1:-1))}const u=computed(()=>{return[[TouchSwipe,s,void 0,{horizontal:!0!==e.vertical,vertical:e.vertical,mouse:!0}]]}),c=computed(()=>e.transitionPrev||`slide-${!0===e.vertical?"down":"right"}`),d=computed(()=>e.transitionNext||`slide-${!0===e.vertical?"up":"left"}`),p=computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`),v=computed(()=>"string"===typeof e.modelValue||"number"===typeof e.modelValue?e.modelValue:String(e.modelValue)),m=computed(()=>({include:e.keepAliveInclude,exclude:e.keepAliveExclude,max:e.keepAliveMax})),f=computed(()=>void 0!==e.keepAliveInclude||void 0!==e.keepAliveExclude);function g(){k(1)}function b(){k(-1)}function y(e){t("update:modelValue",e)}function S(e){return void 0!==e&&null!==e&&""!==e}function w(e){return a.findIndex(t=>{return t.props.name===e&&""!==t.props.disable&&!0!==t.props.disable})}function C(){return a.filter(e=>{return""!==e.props.disable&&!0!==e.props.disable})}function x(t){const o=0!==t&&!0===e.animated&&-1!==i.value?"q-transition--"+(-1===t?c.value:d.value):null;r.value!==o&&(r.value=o)}function k(o,n=i.value){let r=n+o;while(r>-1&&r<a.length){const e=a[r];if(void 0!==e&&""!==e.props.disable&&!0!==e.props.disable)return x(o),l=!0,t("update:modelValue",e.props.name),void setTimeout(()=>{l=!1});r+=o}!0===e.infinite&&a.length>0&&-1!==n&&n!==a.length&&k(o,-1===o?a.length:-1)}function _(){const t=w(e.modelValue);return i.value!==t&&(i.value=t),!0}function q(){const t=!0===S(e.modelValue)&&_()&&a[i.value];return!0===e.keepAlive?[h(KeepAlive,m.value,[h(!0===f.value?n(v.value,()=>({...PanelWrapper$1,name:v.value})):PanelWrapper$1,{key:v.value,style:p.value},()=>t)])]:[h("div",{class:"q-panel scroll",style:p.value,key:v.value,role:"tabpanel"},[t])]}function T(){if(0!==a.length)return!0===e.animated?[h(Transition,{name:r.value},q)]:q()}function P(e){return a=getNormalizedVNodes(hSlot(e.default,[])).filter(e=>null!==e.props&&void 0===e.props.slot&&!0===S(e.props.name)),a.length}function $(){return a}return watch(()=>e.modelValue,(e,o)=>{const n=!0===S(e)?w(e):-1;!0!==l&&x(-1===n?0:n<w(o)?-1:1),i.value!==n&&(i.value=n,t("before-transition",e,o),nextTick(()=>{t("transition",e,o)}))}),Object.assign(o,{next:g,previous:b,goTo:y}),{panelIndex:i,panelDirectives:u,updatePanelsList:P,updatePanelIndex:_,getPanelContent:T,getEnabledPanels:C,getPanels:$,isValidPanelName:S,keepAliveProps:m,needsUniqueKeepAliveWrapper:f,goToPanelByOffset:k,goToPanel:y,nextPanel:g,previousPanel:b}}let counter=0;const useFullscreenProps={fullscreen:Boolean,noRouteFullscreenExit:Boolean},useFullscreenEmits=["update:fullscreen","fullscreen"];function useFullscreen(){const e=getCurrentInstance(),{props:t,emit:o,proxy:n}=e;let a,l,i;const r=ref(!1);function s(){!0===r.value?c():u()}function u(){!0!==r.value&&(r.value=!0,i=n.$el.parentNode,i.replaceChild(l,n.$el),document.body.appendChild(n.$el),counter++,1===counter&&document.body.classList.add("q-body--fullscreen-mixin"),a={handler:c},History.add(a))}function c(){!0===r.value&&(void 0!==a&&(History.remove(a),a=void 0),i.replaceChild(n.$el,l),r.value=!1,counter=Math.max(0,counter-1),0===counter&&(document.body.classList.remove("q-body--fullscreen-mixin"),void 0!==n.$el.scrollIntoView&&setTimeout(()=>{n.$el.scrollIntoView()})))}return!0===vmHasRouter(e)&&watch(()=>n.$route.fullPath,()=>{!0!==t.noRouteFullscreenExit&&c()}),watch(()=>t.fullscreen,e=>{r.value!==e&&s()}),watch(r,e=>{o("update:fullscreen",e),o("fullscreen",e)}),onBeforeMount(()=>{l=document.createElement("span")}),onMounted(()=>{!0===t.fullscreen&&u()}),onBeforeUnmount(c),Object.assign(n,{toggleFullscreen:s,setFullscreen:u,exitFullscreen:c}),{inFullscreen:r,toggleFullscreen:s}}const hasMap="function"===typeof Map,hasSet="function"===typeof Set,hasArrayBuffer="function"===typeof ArrayBuffer;function isDeepEqual(e,t){if(e===t)return!0;if(null!==e&&null!==t&&"object"===typeof e&&"object"===typeof t){if(e.constructor!==t.constructor)return!1;let o,n;if(e.constructor===Array){if(o=e.length,o!==t.length)return!1;for(n=o;0!==n--;)if(!0!==isDeepEqual(e[n],t[n]))return!1;return!0}if(!0===hasMap&&e.constructor===Map){if(e.size!==t.size)return!1;n=e.entries().next();while(!0!==n.done){if(!0!==t.has(n.value[0]))return!1;n=n.next()}n=e.entries().next();while(!0!==n.done){if(!0!==isDeepEqual(n.value[1],t.get(n.value[0])))return!1;n=n.next()}return!0}if(!0===hasSet&&e.constructor===Set){if(e.size!==t.size)return!1;n=e.entries().next();while(!0!==n.done){if(!0!==t.has(n.value[0]))return!1;n=n.next()}return!0}if(!0===hasArrayBuffer&&null!=e.buffer&&e.buffer.constructor===ArrayBuffer){if(o=e.length,o!==t.length)return!1;for(n=o;0!==n--;)if(e[n]!==t[n])return!1;return!0}if(e.constructor===RegExp)return e.source===t.source&&e.flags===t.flags;if(e.valueOf!==Object.prototype.valueOf)return e.valueOf()===t.valueOf();if(e.toString!==Object.prototype.toString)return e.toString()===t.toString();const a=Object.keys(e).filter(t=>void 0!==e[t]);if(o=a.length,o!==Object.keys(t).filter(e=>void 0!==t[e]).length)return!1;for(n=o;0!==n--;){const o=a[n];if(!0!==isDeepEqual(e[o],t[o]))return!1}return!0}return e!==e&&t!==t}function isDate(e){return"[object Date]"===Object.prototype.toString.call(e)}function isNumber(e){return"number"===typeof e&&isFinite(e)}const navigationPositionOptions=["top","right","bottom","left"],controlTypeOptions=["regular","flat","outline","push","unelevated"];var QCarousel=createComponent({name:"QCarousel",props:{...useDarkProps,...usePanelProps,...useFullscreenProps,transitionPrev:{type:String,default:"fade"},transitionNext:{type:String,default:"fade"},height:String,padding:Boolean,controlColor:String,controlTextColor:String,controlType:{type:String,validator:e=>controlTypeOptions.includes(e),default:"flat"},autoplay:[Number,Boolean],arrows:Boolean,prevIcon:String,nextIcon:String,navigation:Boolean,navigationPosition:{type:String,validator:e=>navigationPositionOptions.includes(e)},navigationIcon:String,navigationActiveIcon:String,thumbnails:Boolean},emits:[...useFullscreenEmits,...usePanelEmits],setup(e,{slots:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=useDark(e,o);let a,l;const{updatePanelsList:i,getPanelContent:r,panelDirectives:s,goToPanel:u,previousPanel:c,nextPanel:d,getEnabledPanels:p,panelIndex:v}=usePanel(),{inFullscreen:m}=useFullscreen(),f=computed(()=>!0!==m.value&&void 0!==e.height?{height:e.height}:{}),g=computed(()=>!0===e.vertical?"vertical":"horizontal"),b=computed(()=>`q-carousel q-panel-parent q-carousel--with${!0===e.padding?"":"out"}-padding`+(!0===m.value?" fullscreen":"")+(!0===n.value?" q-carousel--dark q-dark":"")+(!0===e.arrows?` q-carousel--arrows-${g.value}`:"")+(!0===e.navigation?` q-carousel--navigation-${C.value}`:"")),y=computed(()=>{const t=[e.prevIcon||o.iconSet.carousel[!0===e.vertical?"up":"left"],e.nextIcon||o.iconSet.carousel[!0===e.vertical?"down":"right"]];return!1===e.vertical&&!0===o.lang.rtl?t.reverse():t}),S=computed(()=>e.navigationIcon||o.iconSet.carousel.navigationIcon),w=computed(()=>e.navigationActiveIcon||S.value),C=computed(()=>e.navigationPosition||(!0===e.vertical?"right":"bottom")),x=computed(()=>({color:e.controlColor,textColor:e.controlTextColor,round:!0,[e.controlType]:!0,dense:!0}));function k(){const t=!0===isNumber(e.autoplay)?e.autoplay:5e3;a=setTimeout(t>=0?d:c,Math.abs(t))}function _(t,o){return h("div",{class:"q-carousel__control q-carousel__navigation no-wrap absolute flex"+` q-carousel__navigation--${t} q-carousel__navigation--${C.value}`+(void 0!==e.controlColor?` text-${e.controlColor}`:"")},[h("div",{class:"q-carousel__navigation-inner flex flex-center no-wrap"},p().map(o))])}function q(){const o=[];if(!0===e.navigation){const e=void 0!==t["navigation-icon"]?t["navigation-icon"]:e=>h(QBtn,{key:"nav"+e.name,class:`q-carousel__navigation-icon q-carousel__navigation-icon--${!0===e.active?"":"in"}active`,...e.btnProps,onClick:e.onClick}),n=l-1;o.push(_("buttons",(t,o)=>{const a=t.props.name,l=v.value===o;return e({index:o,maxIndex:n,name:a,active:l,btnProps:{icon:!0===l?w.value:S.value,size:"sm",...x.value},onClick:()=>{u(a)}})}))}else if(!0===e.thumbnails){const t=void 0!==e.controlColor?` text-${e.controlColor}`:"";o.push(_("thumbnails",o=>{const n=o.props;return h("img",{key:"tmb#"+n.name,class:`q-carousel__thumbnail q-carousel__thumbnail--${n.name===e.modelValue?"":"in"}active`+t,src:n.imgSrc||n["img-src"],onClick:()=>{u(n.name)}})}))}return!0===e.arrows&&v.value>=0&&((!0===e.infinite||v.value>0)&&o.push(h("div",{key:"prev",class:`q-carousel__control q-carousel__arrow q-carousel__prev-arrow q-carousel__prev-arrow--${g.value} absolute flex flex-center`},[h(QBtn,{icon:y.value[0],...x.value,onClick:c})])),(!0===e.infinite||v.value<l-1)&&o.push(h("div",{key:"next",class:"q-carousel__control q-carousel__arrow q-carousel__next-arrow"+` q-carousel__next-arrow--${g.value} absolute flex flex-center`},[h(QBtn,{icon:y.value[1],...x.value,onClick:d})]))),hMergeSlot(t.control,o)}return watch(()=>e.modelValue,()=>{e.autoplay&&(clearInterval(a),k())}),watch(()=>e.autoplay,e=>{e?k():clearInterval(a)}),onMounted(()=>{e.autoplay&&k()}),onBeforeUnmount(()=>{clearInterval(a)}),()=>{return l=i(t),h("div",{class:b.value,style:f.value},[hDir("div",{class:"q-carousel__slides-container"},r(),"sl-cont",e.swipeable,()=>s.value)].concat(q()))}}}),QCarouselSlide=createComponent({name:"QCarouselSlide",props:{...usePanelChildProps,imgSrc:String},setup(e,{slots:t}){const o=computed(()=>e.imgSrc?{backgroundImage:`url("${e.imgSrc}")`}:{});return()=>h("div",{class:"q-carousel__slide",style:o.value},hSlot(t.default))}}),QCarouselControl=createComponent({name:"QCarouselControl",props:{position:{type:String,default:"bottom-right",validator:e=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(e)},offset:{type:Array,default:()=>[18,18],validator:e=>2===e.length}},setup(e,{slots:t}){const o=computed(()=>`q-carousel__control absolute absolute-${e.position}`),n=computed(()=>({margin:`${e.offset[1]}px ${e.offset[0]}px`}));return()=>h("div",{class:o.value,style:n.value},hSlot(t.default))}}),QChatMessage=createComponent({name:"QChatMessage",props:{sent:Boolean,label:String,bgColor:String,textColor:String,name:String,avatar:String,text:Array,stamp:String,size:String,labelHtml:Boolean,nameHtml:Boolean,textHtml:Boolean,stampHtml:Boolean},setup(e,{slots:t}){const o=computed(()=>!0===e.sent?"sent":"received"),n=computed(()=>`q-message-text-content q-message-text-content--${o.value}`+(void 0!==e.textColor?` text-${e.textColor}`:"")),a=computed(()=>`q-message-text q-message-text--${o.value}`+(void 0!==e.bgColor?` text-${e.bgColor}`:"")),l=computed(()=>"q-message-container row items-end no-wrap"+(!0===e.sent?" reverse":"")),i=computed(()=>void 0!==e.size?`col-${e.size}`:""),r=computed(()=>({msg:!0===e.textHtml?"innerHTML":"textContent",stamp:!0===e.stampHtml?"innerHTML":"textContent",name:!0===e.nameHtml?"innerHTML":"textContent",label:!0===e.labelHtml?"innerHTML":"textContent"}));function s(o){return void 0!==t.stamp?[o,h("div",{class:"q-message-stamp"},t.stamp())]:e.stamp?[o,h("div",{class:"q-message-stamp",[r.value.stamp]:e.stamp})]:[o]}function u(e,t){const o=!0===t?e.length>1?e=>e:e=>h("div",[e]):e=>h("div",{[r.value.msg]:e});return e.map((e,t)=>h("div",{key:t,class:a.value},[h("div",{class:n.value},s(o(e)))]))}return()=>{const n=[];void 0!==t.avatar?n.push(t.avatar()):void 0!==e.avatar&&n.push(h("img",{class:`q-message-avatar q-message-avatar--${o.value}`,src:e.avatar,"aria-hidden":"true"}));const a=[];void 0!==t.name?a.push(h("div",{class:`q-message-name q-message-name--${o.value}`},t.name())):void 0!==e.name&&a.push(h("div",{class:`q-message-name q-message-name--${o.value}`,[r.value.name]:e.name})),void 0!==t.default?a.push(u(getNormalizedVNodes(t.default()),!0)):void 0!==e.text&&a.push(u(e.text)),n.push(h("div",{class:i.value},a));const s=[];return void 0!==t.label?s.push(h("div",{class:"q-message-label"},t.label())):void 0!==e.label&&s.push(h("div",{class:"q-message-label",[r.value.label]:e.label})),s.push(h("div",{class:l.value},n)),h("div",{class:`q-message q-message-${o.value}`},s)}}});function useRefocusTarget(e,t){const o=ref(null),n=computed(()=>{return!0!==e.disable?null:h("span",{ref:o,class:"no-outline",tabindex:-1})});function a(e){const n=t.value;void 0!==e&&0===e.type.indexOf("key")?null!==n&&document.activeElement!==n&&!0===n.contains(document.activeElement)&&n.focus():null!==o.value&&(void 0===e||null!==n&&!0===n.contains(e.target))&&o.value.focus()}return{refocusTargetEl:n,refocusTarget:a}}var optionSizes={xs:30,sm:35,md:40,lg:50,xl:60};const useCheckboxProps={...useDarkProps,...useSizeProps,...useFormProps,modelValue:{required:!0,default:null},val:{},trueValue:{default:!0},falseValue:{default:!1},indeterminateValue:{default:null},checkedIcon:String,uncheckedIcon:String,indeterminateIcon:String,toggleOrder:{type:String,validator:e=>"tf"===e||"ft"===e},toggleIndeterminate:Boolean,label:String,leftLabel:Boolean,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},useCheckboxEmits=["update:modelValue"];function useCheckbox(e,t){const{props:o,slots:n,emit:a,proxy:l}=getCurrentInstance(),{$q:i}=l,r=useDark(o,i),s=ref(null),{refocusTargetEl:u,refocusTarget:c}=useRefocusTarget(o,s),d=useSize(o,optionSizes),p=computed(()=>void 0!==o.val&&Array.isArray(o.modelValue)),v=computed(()=>!0===p.value?o.modelValue.indexOf(o.val):-1),m=computed(()=>!0===p.value?v.value>-1:o.modelValue===o.trueValue),f=computed(()=>!0===p.value?-1===v.value:o.modelValue===o.falseValue),g=computed(()=>!1===m.value&&!1===f.value),b=computed(()=>!0===o.disable?-1:o.tabindex||0),y=computed(()=>`q-${e} cursor-pointer no-outline row inline no-wrap items-center`+(!0===o.disable?" disabled":"")+(!0===r.value?` q-${e}--dark`:"")+(!0===o.dense?` q-${e}--dense`:"")+(!0===o.leftLabel?" reverse":"")),S=computed(()=>{const t=!0===m.value?"truthy":!0===f.value?"falsy":"indet",n=void 0===o.color||!0!==o.keepColor&&("toggle"===e?!0!==m.value:!0===f.value)?"":` text-${o.color}`;return`q-${e}__inner relative-position non-selectable q-${e}__inner--${t}${n}`}),w=computed(()=>{const e={type:"checkbox"};return void 0!==o.name&&Object.assign(e,{"^checked":!0===m.value?"checked":void 0,name:o.name,value:!0===p.value?o.val:o.trueValue}),e}),C=useFormInject(w),x=computed(()=>{const e={tabindex:b.value,role:"checkbox","aria-label":o.label,"aria-checked":!0===g.value?"mixed":!0===m.value?"true":"false"};return!0===o.disable&&(e["aria-disabled"]="true"),e});function k(e){void 0!==e&&(stopAndPrevent(e),c(e)),!0!==o.disable&&a("update:modelValue",_(),e)}function _(){if(!0===p.value){if(!0===m.value){const e=o.modelValue.slice();return e.splice(v.value,1),e}return o.modelValue.concat([o.val])}if(!0===m.value){if("ft"!==o.toggleOrder||!1===o.toggleIndeterminate)return o.falseValue}else{if(!0!==f.value)return"ft"!==o.toggleOrder?o.trueValue:o.falseValue;if("ft"===o.toggleOrder||!1===o.toggleIndeterminate)return o.trueValue}return o.indeterminateValue}function q(e){13!==e.keyCode&&32!==e.keyCode||stopAndPrevent(e)}function T(e){13!==e.keyCode&&32!==e.keyCode||k(e)}const P=t(m,g);return Object.assign(l,{toggle:k}),()=>{const t=P();!0!==o.disable&&C(t,"unshift",` q-${e}__native absolute q-ma-none q-pa-none`);const a=[h("div",{class:S.value,style:d.value},t)];null!==u.value&&a.push(u.value);const l=void 0!==o.label?hMergeSlot(n.default,[o.label]):hSlot(n.default);return void 0!==l&&a.push(h("div",{class:`q-${e}__label q-anchor--skip`},l)),h("div",{ref:s,class:y.value,...x.value,onClick:k,onKeydown:q,onKeyup:T},a)}}const bgNode=h("div",{key:"svg",class:"q-checkbox__bg absolute"},[h("svg",{class:"q-checkbox__svg fit absolute-full",viewBox:"0 0 24 24","aria-hidden":"true"},[h("path",{class:"q-checkbox__truthy",fill:"none",d:"M1.73,12.91 8.1,19.28 22.79,4.59"}),h("path",{class:"q-checkbox__indet",d:"M4,14H20V10H4"})])]);var QCheckbox=createComponent({name:"QCheckbox",props:useCheckboxProps,emits:useCheckboxEmits,setup(e){function t(t,o){const n=computed(()=>(!0===t.value?e.checkedIcon:!0===o.value?e.indeterminateIcon:e.uncheckedIcon)||null);return()=>null!==n.value?[h("div",{key:"icon",class:"q-checkbox__icon-container absolute flex flex-center no-wrap"},[h(QIcon,{class:"q-checkbox__icon",name:n.value})])]:[bgNode]}return useCheckbox("checkbox",t)}});const defaultSizes$1={xs:8,sm:10,md:14,lg:20,xl:24};var QChip=createComponent({name:"QChip",props:{...useDarkProps,...useSizeProps,dense:Boolean,icon:String,iconRight:String,iconRemove:String,iconSelected:String,label:[String,Number],color:String,textColor:String,modelValue:{type:Boolean,default:!0},selected:{type:Boolean,default:null},square:Boolean,outline:Boolean,clickable:Boolean,removable:Boolean,tabindex:[String,Number],disable:Boolean,ripple:{type:[Boolean,Object],default:!0}},emits:["update:modelValue","update:selected","remove","click"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useDark(e,n),l=useSize(e,defaultSizes$1),i=computed(()=>!0===e.selected||void 0!==e.icon),r=computed(()=>!0===e.selected?e.iconSelected||n.iconSet.chip.selected:e.icon),s=computed(()=>e.iconRemove||n.iconSet.chip.remove),u=computed(()=>!1===e.disable&&(!0===e.clickable||null!==e.selected)),c=computed(()=>{const t=!0===e.outline&&e.color||e.textColor;return"q-chip row inline no-wrap items-center"+(!1===e.outline&&void 0!==e.color?` bg-${e.color}`:"")+(t?` text-${t} q-chip--colored`:"")+(!0===e.disable?" disabled":"")+(!0===e.dense?" q-chip--dense":"")+(!0===e.outline?" q-chip--outline":"")+(!0===e.selected?" q-chip--selected":"")+(!0===u.value?" q-chip--clickable cursor-pointer non-selectable q-hoverable":"")+(!0===e.square?" q-chip--square":"")+(!0===a.value?" q-chip--dark q-dark":"")}),d=computed(()=>!0===e.disable?{tabindex:-1,"aria-disabled":"true"}:{tabindex:e.tabindex||0});function p(e){13===e.keyCode&&v(e)}function v(t){e.disable||(o("update:selected",!e.selected),o("click",t))}function m(t){void 0!==t.keyCode&&13!==t.keyCode||(stopAndPrevent(t),!1===e.disable&&(o("update:modelValue",!1),o("remove")))}function f(){const o=[];!0===u.value&&o.push(h("div",{class:"q-focus-helper"})),!0===i.value&&o.push(h(QIcon,{class:"q-chip__icon q-chip__icon--left",name:r.value}));const n=void 0!==e.label?[h("div",{class:"ellipsis"},[e.label])]:void 0;return o.push(h("div",{class:"q-chip__content col row no-wrap items-center q-anchor--skip"},hMergeSlotSafely(t.default,n))),e.iconRight&&o.push(h(QIcon,{class:"q-chip__icon q-chip__icon--right",name:e.iconRight})),!0===e.removable&&o.push(h(QIcon,{class:"q-chip__icon q-chip__icon--remove cursor-pointer",name:s.value,...d.value,onClick:m,onKeyup:m})),o}return()=>{if(!1===e.modelValue)return;const t={class:c.value,style:l.value};return!0===u.value&&Object.assign(t,d.value,{onClick:v,onKeyup:p}),hDir("div",t,f(),"ripple",!1!==e.ripple&&!0!==e.disable,()=>[[Ripple,e.ripple]])}}});const useCircularCommonProps={...useSizeProps,min:{type:Number,default:0},max:{type:Number,default:100},color:String,centerColor:String,trackColor:String,fontSize:String,thickness:{type:Number,default:.2,validator:e=>e>=0&&e<=1},angle:{type:Number,default:0},showValue:Boolean,reverse:Boolean,instantFeedback:Boolean},radius=50,diameter=2*radius,circumference=diameter*Math.PI,strokeDashArray=Math.round(1e3*circumference)/1e3;var QCircularProgress=createComponent({name:"QCircularProgress",props:{...useCircularCommonProps,value:{type:Number,default:0},animationSpeed:{type:[String,Number],default:600},indeterminate:Boolean},setup(e,{slots:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=useSize(e),a=computed(()=>{const t=(!0===o.lang.rtl?-1:1)*e.angle;return{transform:e.reverse!==(!0===o.lang.rtl)?`scale3d(-1, 1, 1) rotate3d(0, 0, 1, ${-90-t}deg)`:`rotate3d(0, 0, 1, ${t-90}deg)`}}),l=computed(()=>!0!==e.instantFeedback&&!0!==e.indeterminate?{transition:`stroke-dashoffset ${e.animationSpeed}ms ease 0s, stroke ${e.animationSpeed}ms ease`}:""),i=computed(()=>diameter/(1-e.thickness/2)),r=computed(()=>`${i.value/2} ${i.value/2} ${i.value} ${i.value}`),s=computed(()=>between(e.value,e.min,e.max)),u=computed(()=>circumference*(1-(s.value-e.min)/(e.max-e.min))),c=computed(()=>e.thickness/2*i.value);function d({thickness:e,offset:t,color:o,cls:n}){return h("circle",{class:"q-circular-progress__"+n+(void 0!==o?` text-${o}`:""),style:l.value,fill:"transparent",stroke:"currentColor","stroke-width":e,"stroke-dasharray":strokeDashArray,"stroke-dashoffset":t,cx:i.value,cy:i.value,r:radius})}return()=>{const o=[];void 0!==e.centerColor&&"transparent"!==e.centerColor&&o.push(h("circle",{class:`q-circular-progress__center text-${e.centerColor}`,fill:"currentColor",r:radius-c.value/2,cx:i.value,cy:i.value})),void 0!==e.trackColor&&"transparent"!==e.trackColor&&o.push(d({cls:"track",thickness:c.value,offset:0,color:e.trackColor})),o.push(d({cls:"circle",thickness:c.value,offset:u.value,color:e.color}));const l=[h("svg",{class:"q-circular-progress__svg",style:a.value,viewBox:r.value,"aria-hidden":"true"},o)];return!0===e.showValue&&l.push(h("div",{class:"q-circular-progress__text absolute-full row flex-center content-center",style:{fontSize:e.fontSize}},void 0!==t.default?t.default():[h("div",s.value)])),h("div",{class:`q-circular-progress q-circular-progress--${!0===e.indeterminate?"in":""}determinate`,style:n.value,role:"progressbar","aria-valuemin":e.min,"aria-valuemax":e.max,"aria-valuenow":!0===e.indeterminate?void 0:s.value},hMergeSlotSafely(t.internal,l))}}});function getChanges(e,t,o){const n=position(e);let a,l=n.left-t.event.x,i=n.top-t.event.y,r=Math.abs(l),s=Math.abs(i);const u=t.direction;!0===u.horizontal&&!0!==u.vertical?a=l<0?"left":"right":!0!==u.horizontal&&!0===u.vertical?a=i<0?"up":"down":!0===u.up&&i<0?(a="up",r>s&&(!0===u.left&&l<0?a="left":!0===u.right&&l>0&&(a="right"))):!0===u.down&&i>0?(a="down",r>s&&(!0===u.left&&l<0?a="left":!0===u.right&&l>0&&(a="right"))):!0===u.left&&l<0?(a="left",r<s&&(!0===u.up&&i<0?a="up":!0===u.down&&i>0&&(a="down"))):!0===u.right&&l>0&&(a="right",r<s&&(!0===u.up&&i<0?a="up":!0===u.down&&i>0&&(a="down")));let c=!1;if(void 0===a&&!1===o){if(!0===t.event.isFirst||void 0===t.event.lastDir)return{};a=t.event.lastDir,c=!0,"left"===a||"right"===a?(n.left-=l,r=0,l=0):(n.top-=i,s=0,i=0)}return{synthetic:c,payload:{evt:e,touch:!0!==t.event.mouse,mouse:!0===t.event.mouse,position:n,direction:a,isFirst:t.event.isFirst,isFinal:!0===o,duration:Date.now()-t.event.time,distance:{x:r,y:s},offset:{x:l,y:i},delta:{x:n.left-t.event.lastX,y:n.top-t.event.lastY}}}}let uid$4=0;var TouchPan=createDirective({name:"touch-pan",beforeMount(e,{value:t,modifiers:o}){if(!0!==o.mouse&&!0!==client.has.touch)return;function n(e,t){!0===o.mouse&&!0===t?stopAndPrevent(e):(!0===o.stop&&stop(e),!0===o.prevent&&prevent(e))}const a={uid:"qvtp_"+uid$4++,handler:t,modifiers:o,direction:getModifierDirections(o),noop:noop,mouseStart(e){shouldStart(e,a)&&leftClick(e)&&(addEvt(a,"temp",[[document,"mousemove","move","notPassiveCapture"],[document,"mouseup","end","passiveCapture"]]),a.start(e,!0))},touchStart(e){if(shouldStart(e,a)){const t=e.target;addEvt(a,"temp",[[t,"touchmove","move","notPassiveCapture"],[t,"touchcancel","end","passiveCapture"],[t,"touchend","end","passiveCapture"]]),a.start(e)}},start(t,n){if(!0===client.is.firefox&&preventDraggable(e,!0),a.lastEvt=t,!0===n||!0===o.stop){if(!0!==a.direction.all&&(!0!==n||!0!==a.modifiers.mouseAllDir)){const e=t.type.indexOf("mouse")>-1?new MouseEvent(t.type,t):new TouchEvent(t.type,t);!0===t.defaultPrevented&&prevent(e),!0===t.cancelBubble&&stop(e),Object.assign(e,{qKeyEvent:t.qKeyEvent,qClickOutside:t.qClickOutside,qAnchorHandled:t.qAnchorHandled,qClonedBy:void 0===t.qClonedBy?[a.uid]:t.qClonedBy.concat(a.uid)}),a.initialEvent={target:t.target,event:e}}stop(t)}const{left:l,top:i}=position(t);a.event={x:l,y:i,time:Date.now(),mouse:!0===n,detected:!1,isFirst:!0,isFinal:!1,lastX:l,lastY:i}},move(e){if(void 0===a.event)return;const t=position(e),l=t.left-a.event.x,i=t.top-a.event.y;if(0===l&&0===i)return;a.lastEvt=e;const r=!0===a.event.mouse,s=()=>{n(e,r),!0!==o.preserveCursor&&(document.documentElement.style.cursor="grabbing"),!0===r&&document.body.classList.add("no-pointer-events--children"),document.body.classList.add("non-selectable"),clearSelection(),a.styleCleanup=(e=>{if(a.styleCleanup=void 0,!0!==o.preserveCursor&&(document.documentElement.style.cursor=""),document.body.classList.remove("non-selectable"),!0===r){const t=()=>{document.body.classList.remove("no-pointer-events--children")};void 0!==e?setTimeout(()=>{t(),e()},50):t()}else void 0!==e&&e()})};if(!0===a.event.detected){!0!==a.event.isFirst&&n(e,a.event.mouse);const{payload:t,synthetic:o}=getChanges(e,a,!1);return void(void 0!==t&&(!1===a.handler(t)?a.end(e):(void 0===a.styleCleanup&&!0===a.event.isFirst&&s(),a.event.lastX=t.position.left,a.event.lastY=t.position.top,a.event.lastDir=!0===o?void 0:t.direction,a.event.isFirst=!1)))}if(!0===a.direction.all||!0===r&&!0===a.modifiers.mouseAllDir)return s(),a.event.detected=!0,void a.move(e);const u=Math.abs(l),c=Math.abs(i);u!==c&&(!0===a.direction.horizontal&&u>c||!0===a.direction.vertical&&u<c||!0===a.direction.up&&u<c&&i<0||!0===a.direction.down&&u<c&&i>0||!0===a.direction.left&&u>c&&l<0||!0===a.direction.right&&u>c&&l>0?(a.event.detected=!0,a.move(e)):a.end(e,!0))},end(t,o){if(void 0!==a.event){if(cleanEvt(a,"temp"),!0===client.is.firefox&&preventDraggable(e,!1),!0===o)void 0!==a.styleCleanup&&a.styleCleanup(),!0!==a.event.detected&&void 0!==a.initialEvent&&a.initialEvent.target.dispatchEvent(a.initialEvent.event);else if(!0===a.event.detected){!0===a.event.isFirst&&a.handler(getChanges(void 0===t?a.lastEvt:t,a).payload);const{payload:e}=getChanges(void 0===t?a.lastEvt:t,a,!0),o=()=>{a.handler(e)};void 0!==a.styleCleanup?a.styleCleanup(o):o()}a.event=void 0,a.initialEvent=void 0,a.lastEvt=void 0}}};e.__qtouchpan=a,!0===o.mouse&&addEvt(a,"main",[[e,"mousedown","mouseStart",`passive${!0===o.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(a,"main",[[e,"touchstart","touchStart",`passive${!0===o.capture?"Capture":""}`],[e,"touchmove","noop","notPassiveCapture"]])},updated(e,t){const o=e.__qtouchpan;void 0!==o&&(t.oldValue!==t.value&&("function"!==typeof value&&o.end(),o.handler=t.value),o.direction=getModifierDirections(t.modifiers))},beforeUnmount(e){const t=e.__qtouchpan;void 0!==t&&(void 0!==t.event&&t.end(),cleanEvt(t,"main"),cleanEvt(t,"temp"),!0===client.is.firefox&&preventDraggable(e,!1),void 0!==t.styleCleanup&&t.styleCleanup(),delete e.__qtouchpan)}});const markerPrefixClass="q-slider__marker-labels",defaultMarkerConvertFn=e=>({value:e}),defaultMarkerLabelRenderFn=({marker:e})=>h("div",{key:e.value,style:e.style,class:e.classes},e.label),keyCodes$2=[34,37,40,33,39,38],useSliderProps={...useDarkProps,...useFormProps,min:{type:Number,default:0},max:{type:Number,default:100},innerMin:Number,innerMax:Number,step:{type:Number,default:1,validator:e=>e>=0},snap:Boolean,vertical:Boolean,reverse:Boolean,hideSelection:Boolean,color:String,markerLabelsClass:String,label:Boolean,labelColor:String,labelTextColor:String,labelAlways:Boolean,switchLabelSide:Boolean,markers:[Boolean,Number],markerLabels:[Boolean,Array,Object,Function],switchMarkerLabelsSide:Boolean,trackImg:String,trackColor:String,innerTrackImg:String,innerTrackColor:String,selectionColor:String,selectionImg:String,thumbSize:{type:String,default:"20px"},trackSize:{type:String,default:"4px"},disable:Boolean,readonly:Boolean,dense:Boolean,tabindex:[String,Number],thumbColor:String,thumbPath:{type:String,default:"M 4, 10 a 6,6 0 1,0 12,0 a 6,6 0 1,0 -12,0"}},useSliderEmits=["pan","update:modelValue","change"];function useSlider({updateValue:e,updatePosition:t,getDragging:o,formAttrs:n}){const{props:a,emit:l,slots:i,proxy:{$q:r}}=getCurrentInstance(),s=useDark(a,r),u=useFormInject(n),c=ref(!1),d=ref(!1),p=ref(!1),v=ref(!1),m=computed(()=>!0===a.vertical?"--v":"--h"),f=computed(()=>"-"+(!0===a.switchLabelSide?"switched":"standard")),g=computed(()=>!0===a.vertical?!0===a.reverse:a.reverse!==(!0===r.lang.rtl)),b=computed(()=>!0===isNaN(a.innerMin)||a.innerMin<a.min?a.min:a.innerMin),y=computed(()=>!0===isNaN(a.innerMax)||a.innerMax>a.max?a.max:a.innerMax),S=computed(()=>!0!==a.disable&&!0!==a.readonly&&b.value<y.value),w=computed(()=>(String(a.step).trim("0").split(".")[1]||"").length),C=computed(()=>0===a.step?1:a.step),x=computed(()=>!0===S.value?a.tabindex||0:-1),k=computed(()=>a.max-a.min),_=computed(()=>y.value-b.value),q=computed(()=>W(b.value)),T=computed(()=>W(y.value)),P=computed(()=>!0===a.vertical?!0===g.value?"bottom":"top":!0===g.value?"right":"left"),$=computed(()=>!0===a.vertical?"height":"width"),M=computed(()=>!0===a.vertical?"width":"height"),B=computed(()=>!0===a.vertical?"vertical":"horizontal"),Q=computed(()=>{const e={role:"slider","aria-valuemin":b.value,"aria-valuemax":y.value,"aria-orientation":B.value,"data-step":a.step};return!0===a.disable?e["aria-disabled"]="true":!0===a.readonly&&(e["aria-readonly"]="true"),e}),E=computed(()=>`q-slider q-slider${m.value} q-slider--${!0===c.value?"":"in"}active inline no-wrap `+(!0===a.vertical?"row":"column")+(!0===a.disable?" disabled":" q-slider--enabled"+(!0===S.value?" q-slider--editable":""))+("both"===p.value?" q-slider--focus":"")+(a.label||!0===a.labelAlways?" q-slider--label":"")+(!0===a.labelAlways?" q-slider--label-always":"")+(!0===s.value?" q-slider--dark":"")+(!0===a.dense?" q-slider--dense q-slider--dense"+m.value:""));function O(e){const t="q-slider__"+e;return`${t} ${t}${m.value} ${t}${m.value}${f.value}`}function R(e){const t="q-slider__"+e;return`${t} ${t}${m.value}`}const L=computed(()=>{const e=a.selectionColor||a.color;return"q-slider__selection absolute"+(void 0!==e?` text-${e}`:"")}),z=computed(()=>R("markers")+" absolute overflow-hidden"),A=computed(()=>R("track-container")),F=computed(()=>O("pin")),D=computed(()=>O("label")),I=computed(()=>O("text-container")),V=computed(()=>O("marker-labels-container")+(void 0!==a.markerLabelsClass?` ${a.markerLabelsClass}`:"")),N=computed(()=>"q-slider__track relative-position no-outline"+(void 0!==a.trackColor?` bg-${a.trackColor}`:"")),H=computed(()=>{const e={[M.value]:a.trackSize};return void 0!==a.trackImg&&(e.backgroundImage=`url(${a.trackImg}) !important`),e}),j=computed(()=>"q-slider__inner absolute"+(void 0!==a.innerTrackColor?` bg-${a.innerTrackColor}`:"")),U=computed(()=>{const e={[P.value]:`${100*q.value}%`,[$.value]:`${100*(T.value-q.value)}%`};return void 0!==a.innerTrackImg&&(e.backgroundImage=`url(${a.innerTrackImg}) !important`),e});function K(e){const{min:t,max:o,step:n}=a;let l=t+e*(o-t);if(n>0){const e=(l-t)%n;l+=(Math.abs(e)>=n/2?(e<0?-1:1)*n:0)-e}return w.value>0&&(l=parseFloat(l.toFixed(w.value))),between(l,b.value,y.value)}function W(e){return 0===k.value?0:(e-a.min)/k.value}function Y(e,t){const o=position(e),n=!0===a.vertical?between((o.top-t.top)/t.height,0,1):between((o.left-t.left)/t.width,0,1);return between(!0===g.value?1-n:n,q.value,T.value)}const G=computed(()=>!0===isNumber(a.markers)?a.markers:C.value),X=computed(()=>{const e=[],t=G.value,o=a.max;let n=a.min;do{e.push(n),n+=t}while(n<o);return e.push(o),e}),Z=computed(()=>{const e=` ${markerPrefixClass}${m.value}-`;return markerPrefixClass+`${e}${!0===a.switchMarkerLabelsSide?"switched":"standard"}`+`${e}${!0===g.value?"rtl":"ltr"}`}),J=computed(()=>{return!1===a.markerLabels?null:oe(a.markerLabels).map((e,t)=>({index:t,value:e.value,label:e.label||e.value,classes:Z.value+(void 0!==e.classes?" "+e.classes:""),style:{...ne(e.value),...e.style||{}}}))}),ee=computed(()=>({markerList:J.value,markerMap:ae.value,classes:Z.value,getStyle:ne})),te=computed(()=>{if(0!==_.value){const e=100*G.value/_.value;return{...U.value,backgroundSize:!0===a.vertical?`2px ${e}%`:`${e}% 2px`}}return null});function oe(e){if(!1===e)return null;if(!0===e)return X.value.map(defaultMarkerConvertFn);if("function"===typeof e)return X.value.map(t=>{const o=e(t);return Object(o)===o?{...o,value:t}:{value:t,label:o}});const t=({value:e})=>e>=a.min&&e<=a.max;return!0===Array.isArray(e)?e.map(e=>Object(e)===e?e:{value:e}).filter(t):Object.keys(e).map(t=>{const o=e[t],n=Number(t);return Object(o)===o?{...o,value:n}:{value:n,label:o}}).filter(t)}function ne(e){return{[P.value]:`${100*(e-a.min)/k.value}%`}}const ae=computed(()=>{if(!1===a.markerLabels)return null;const e={};return J.value.forEach(t=>{e[t.value]=t}),e});function le(){if(void 0!==i["marker-label-group"])return i["marker-label-group"](ee.value);const e=i["marker-label"]||defaultMarkerLabelRenderFn;return J.value.map(t=>e({marker:t,...ee.value}))}const ie=computed(()=>{return[[TouchPan,re,void 0,{[B.value]:!0,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}]]});function re(n){!0===n.isFinal?(void 0!==v.value&&(t(n.evt),!0===n.touch&&e(!0),v.value=void 0,l("pan","end")),c.value=!1,p.value=!1):!0===n.isFirst?(v.value=o(n.evt),t(n.evt),e(),c.value=!0,l("pan","start")):(t(n.evt),e())}function se(){p.value=!1}function ue(n){t(n,o(n)),e(),d.value=!0,c.value=!0,document.addEventListener("mouseup",ce,!0)}function ce(){d.value=!1,c.value=!1,e(!0),se(),document.removeEventListener("mouseup",ce,!0)}function de(n){t(n,o(n)),e(!0)}function pe(t){keyCodes$2.includes(t.keyCode)&&e(!0)}function ve(e){if(!0===a.vertical)return null;const t=r.lang.rtl!==a.reverse?1-e:e;return{transform:`translateX(calc(${2*t-1} * ${a.thumbSize} / 2 + ${50-100*t}%))`}}function me(e){const t=computed(()=>!1!==d.value||p.value!==e.focusValue&&"both"!==p.value?"":" q-slider--focus"),o=computed(()=>`q-slider__thumb q-slider__thumb${m.value} q-slider__thumb${m.value}-${!0===g.value?"rtl":"ltr"} absolute non-selectable`+t.value+(void 0!==e.thumbColor.value?` text-${e.thumbColor.value}`:"")),n=computed(()=>({width:a.thumbSize,height:a.thumbSize,[P.value]:`${100*e.ratio.value}%`,zIndex:p.value===e.focusValue?2:void 0})),l=computed(()=>void 0!==e.labelColor.value?` text-${e.labelColor.value}`:""),i=computed(()=>ve(e.ratio.value)),r=computed(()=>"q-slider__text"+(void 0!==e.labelTextColor.value?` text-${e.labelTextColor.value}`:""));return()=>{const t=[h("svg",{class:"q-slider__thumb-shape absolute-full",viewBox:"0 0 20 20","aria-hidden":"true"},[h("path",{d:a.thumbPath})]),h("div",{class:"q-slider__focus-ring fit"})];return!0!==a.label&&!0!==a.labelAlways||(t.push(h("div",{class:F.value+" absolute fit no-pointer-events"+l.value},[h("div",{class:D.value,style:{minWidth:a.thumbSize}},[h("div",{class:I.value,style:i.value},[h("span",{class:r.value},e.label.value)])])])),void 0!==a.name&&!0!==a.disable&&u(t,"push")),h("div",{class:o.value,style:n.value,...e.getNodeData()},t)}}function fe(e,t,o,n){const l=[];"transparent"!==a.innerTrackColor&&l.push(h("div",{key:"inner",class:j.value,style:U.value})),"transparent"!==a.selectionColor&&l.push(h("div",{key:"selection",class:L.value,style:e.value})),!1!==a.markers&&l.push(h("div",{key:"marker",class:z.value,style:te.value})),n(l);const i=[hDir("div",{key:"trackC",class:A.value,tabindex:t.value,...o.value},[h("div",{class:N.value,style:H.value},l)],"slide",S.value,()=>ie.value)];if(!1!==a.markerLabels){const e=!0===a.switchMarkerLabelsSide?"unshift":"push";i[e](h("div",{key:"markerL",class:V.value},le()))}return i}return onBeforeUnmount(()=>{document.removeEventListener("mouseup",ce,!0)}),{state:{active:c,focus:p,preventFocus:d,dragging:v,editable:S,classes:E,tabindex:x,attributes:Q,step:C,decimals:w,trackLen:k,innerMin:b,innerMinRatio:q,innerMax:y,innerMaxRatio:T,positionProp:P,sizeProp:$,isReversed:g},methods:{onActivate:ue,onMobileClick:de,onBlur:se,onKeyup:pe,getContent:fe,getThumbRenderFn:me,convertRatioToModel:K,convertModelToRatio:W,getDraggingRatio:Y}}}const getNodeData=()=>({});var QSlider=createComponent({name:"QSlider",props:{...useSliderProps,modelValue:{required:!0,default:null,validator:e=>"number"===typeof e||null===e},labelValue:[String,Number]},emits:useSliderEmits,setup(e,{emit:t}){const{proxy:{$q:o}}=getCurrentInstance(),{state:n,methods:a}=useSlider({updateValue:m,updatePosition:g,getDragging:f,formAttrs:useFormAttrs(e)}),l=ref(null),i=ref(0),r=ref(0);function s(){r.value=null===e.modelValue?n.innerMin.value:between(e.modelValue,n.innerMin.value,n.innerMax.value)}watch(()=>`${e.modelValue}|${n.innerMin.value}|${n.innerMax.value}`,s),s();const u=computed(()=>a.convertModelToRatio(r.value)),c=computed(()=>!0===n.active.value?i.value:u.value),d=computed(()=>{const t={[n.positionProp.value]:`${100*n.innerMinRatio.value}%`,[n.sizeProp.value]:`${100*(c.value-n.innerMinRatio.value)}%`};return void 0!==e.selectionImg&&(t.backgroundImage=`url(${e.selectionImg}) !important`),t}),p=a.getThumbRenderFn({focusValue:!0,getNodeData:getNodeData,ratio:c,label:computed(()=>void 0!==e.labelValue?e.labelValue:r.value),thumbColor:computed(()=>e.thumbColor||e.color),labelColor:computed(()=>e.labelColor),labelTextColor:computed(()=>e.labelTextColor)}),v=computed(()=>{return!0!==n.editable.value?{}:!0===o.platform.is.mobile?{onClick:a.onMobileClick}:{onMousedown:a.onActivate,onFocus:b,onBlur:a.onBlur,onKeydown:y,onKeyup:a.onKeyup}});function m(o){r.value!==e.modelValue&&t("update:modelValue",r.value),!0===o&&t("change",r.value)}function f(){return l.value.getBoundingClientRect()}function g(t,o=n.dragging.value){const l=a.getDraggingRatio(t,o);r.value=a.convertRatioToModel(l),i.value=!0!==e.snap||0===e.step?l:a.convertModelToRatio(r.value)}function b(){n.focus.value=!0}function y(e){if(!keyCodes$2.includes(e.keyCode))return;stopAndPrevent(e);const t=([34,33].includes(e.keyCode)?10:1)*n.step.value,o=([34,37,40].includes(e.keyCode)?-1:1)*(!0===n.isReversed.value?-1:1)*t;r.value=between(parseFloat((r.value+o).toFixed(n.decimals.value)),n.innerMin.value,n.innerMax.value),m()}return()=>{const t=a.getContent(d,n.tabindex,v,e=>{e.push(p())});return h("div",{ref:l,class:n.classes.value+(null===e.modelValue?" q-slider--no-value":""),...n.attributes.value,"aria-valuenow":e.modelValue},t)}}});function useCanRender(){const e=ref(!isRuntimeSsrPreHydration.value);return!1===e.value&&onMounted(()=>{e.value=!0}),e}const hasObserver="undefined"!==typeof ResizeObserver,resizeProps=!0===hasObserver?{}:{style:"display:block;position:absolute;top:0;left:0;right:0;bottom:0;height:100%;width:100%;overflow:hidden;pointer-events:none;z-index:-1;",url:"about:blank"};var QResizeObserver=createComponent({name:"QResizeObserver",props:{debounce:{type:[String,Number],default:100}},emits:["resize"],setup(e,{emit:t}){let o,n=null,a={width:-1,height:-1};function l(t){!0===t||0===e.debounce||"0"===e.debounce?i():null===n&&(n=setTimeout(i,e.debounce))}function i(){if(clearTimeout(n),n=null,o){const{offsetWidth:e,offsetHeight:n}=o;e===a.width&&n===a.height||(a={width:e,height:n},t("resize",a))}}const r=getCurrentInstance();if(Object.assign(r.proxy,{trigger:l}),!0===hasObserver){let e;return onMounted(()=>{nextTick(()=>{o=r.proxy.$el.parentNode,o&&(e=new ResizeObserver(l),e.observe(o),i())})}),onBeforeUnmount(()=>{clearTimeout(n),void 0!==e&&(void 0!==e.disconnect?e.disconnect():o&&e.unobserve(o))}),noop}{const e=useCanRender();let t;function s(){clearTimeout(n),void 0!==t&&(void 0!==t.removeEventListener&&t.removeEventListener("resize",l,listenOpts.passive),t=void 0)}function u(){s(),o&&o.contentDocument&&(t=o.contentDocument.defaultView,t.addEventListener("resize",l,listenOpts.passive),i())}return onMounted(()=>{nextTick(()=>{o=r.proxy.$el,o&&u()})}),onBeforeUnmount(s),()=>{if(!0===e.value)return h("object",{style:resizeProps.style,tabindex:-1,type:"text/html",data:resizeProps.url,"aria-hidden":"true",onLoad:u})}}}});let rtlHasScrollBug=!1;{const e=document.createElement("div"),t=document.createElement("div");e.setAttribute("dir","rtl"),e.style.width="1px",e.style.height="1px",e.style.overflow="auto",t.style.width="1000px",t.style.height="1px",document.body.appendChild(e),e.appendChild(t),e.scrollLeft=-1e3,rtlHasScrollBug=e.scrollLeft>=0,e.remove()}function getIndicatorClass(e,t,o){const n=!0===o?["left","right"]:["top","bottom"];return`absolute-${!0===t?n[0]:n[1]}${e?` text-${e}`:""}`}const alignValues$1=["left","center","right","justify"],emptyFn=()=>{};var QTabs=createComponent({name:"QTabs",props:{modelValue:[Number,String],align:{type:String,default:"center",validator:e=>alignValues$1.includes(e)},breakpoint:{type:[String,Number],default:600},vertical:Boolean,shrink:Boolean,stretch:Boolean,activeClass:String,activeColor:String,activeBgColor:String,indicatorColor:String,leftIcon:String,rightIcon:String,outsideArrows:Boolean,mobileArrows:Boolean,switchIndicator:Boolean,narrowIndicator:Boolean,inlineLabel:Boolean,noCaps:Boolean,dense:Boolean,contentClass:String,"onUpdate:modelValue":[Function,Array]},setup(e,{slots:t,emit:o}){const n=getCurrentInstance(),{proxy:{$q:a}}=n,{registerTick:l}=useTick(),{registerTimeout:i,removeTimeout:r}=useTimeout(),{registerTimeout:s}=useTimeout(),u=ref(null),c=ref(null),d=ref(e.modelValue),p=ref(!1),v=ref(!0),m=ref(!1),f=ref(!1),g=computed(()=>!0===a.platform.is.desktop||!0===e.mobileArrows),b=[],y=ref(!1);let S,w,C,x=!1,k=!0===g.value?z:noop;const _=computed(()=>({activeClass:e.activeClass,activeColor:e.activeColor,activeBgColor:e.activeBgColor,indicatorClass:getIndicatorClass(e.indicatorColor,e.switchIndicator,e.vertical),narrowIndicator:e.narrowIndicator,inlineLabel:e.inlineLabel,noCaps:e.noCaps})),q=computed(()=>{const t=!0===p.value?"left":!0===f.value?"justify":e.align;return`q-tabs__content--align-${t}`}),T=computed(()=>"q-tabs row no-wrap items-center"+` q-tabs--${!0===p.value?"":"not-"}scrollable`+` q-tabs--${!0===e.vertical?"vertical":"horizontal"}`+` q-tabs__arrows--${!0===g.value&&!0===e.outsideArrows?"outside":"inside"}`+(!0===e.dense?" q-tabs--dense":"")+(!0===e.shrink?" col-shrink":"")+(!0===e.stretch?" self-stretch":"")),P=computed(()=>"q-tabs__content row no-wrap items-center self-stretch hide-scrollbar relative-position "+q.value+(void 0!==e.contentClass?` ${e.contentClass}`:"")+(!0===a.platform.is.mobile?" scroll":"")),$=computed(()=>!0===e.vertical?{container:"height",content:"offsetHeight",scroll:"scrollHeight"}:{container:"width",content:"offsetWidth",scroll:"scrollWidth"}),M=computed(()=>!0!==e.vertical&&!0===a.lang.rtl),B=computed(()=>!1===rtlHasScrollBug&&!0===M.value);function Q({name:t,setCurrent:n,skipEmit:a,fromRoute:l}){d.value!==t&&(!0!==a&&o("update:modelValue",t),!0!==n&&void 0!==e["onUpdate:modelValue"]||(R(d.value,t),d.value=t)),void 0!==l&&(x=l)}function E(){l(()=>{!0!==n.isDeactivated&&!0!==n.isUnmounted&&O({width:u.value.offsetWidth,height:u.value.offsetHeight})})}function O(t){if(void 0===$.value||null===c.value)return;const o=t[$.value.container],n=Math.min(c.value[$.value.scroll],Array.prototype.reduce.call(c.value.children,(e,t)=>e+(t[$.value.content]||0),0)),a=o>0&&n>o;p.value!==a&&(p.value=a),!0===a&&nextTick(k);const l=o<parseInt(e.breakpoint,10);f.value!==l&&(f.value=l)}function R(t,o){const n=void 0!==t&&null!==t&&""!==t?b.find(e=>e.name.value===t):null,a=void 0!==o&&null!==o&&""!==o?b.find(e=>e.name.value===o):null;if(n&&a){const t=n.tabIndicatorRef.value,o=a.tabIndicatorRef.value;clearTimeout(S),t.style.transition="none",t.style.transform="none",o.style.transition="none",o.style.transform="none";const l=t.getBoundingClientRect(),i=o.getBoundingClientRect();o.style.transform=!0===e.vertical?`translate3d(0,${l.top-i.top}px,0) scale3d(1,${i.height?l.height/i.height:1},1)`:`translate3d(${l.left-i.left}px,0,0) scale3d(${i.width?l.width/i.width:1},1,1)`,nextTick(()=>{S=setTimeout(()=>{o.style.transition="transform .25s cubic-bezier(.4, 0, .2, 1)",o.style.transform="none"},70)})}a&&!0===p.value&&L(a.rootRef.value)}function L(t){const{left:o,width:n,top:a,height:l}=c.value.getBoundingClientRect(),i=t.getBoundingClientRect();let r=!0===e.vertical?i.top-a:i.left-o;if(r<0)return c.value[!0===e.vertical?"scrollTop":"scrollLeft"]+=Math.floor(r),void k();r+=!0===e.vertical?i.height-l:i.width-n,r>0&&(c.value[!0===e.vertical?"scrollTop":"scrollLeft"]+=Math.ceil(r),k())}function z(){const t=c.value;if(null!==t){const o=t.getBoundingClientRect(),n=!0===e.vertical?t.scrollTop:Math.abs(t.scrollLeft);!0===M.value?(v.value=Math.ceil(n+o.width)<t.scrollWidth-1,m.value=n>0):(v.value=n>0,m.value=!0===e.vertical?Math.ceil(n+o.height)<t.scrollHeight:Math.ceil(n+o.width)<t.scrollWidth)}}function A(e){I(),H(e),w=setInterval(()=>{!0===H(e)&&I()},5)}function F(){A(!0===B.value?Number.MAX_SAFE_INTEGER:0)}function D(){A(!0===B.value?0:Number.MAX_SAFE_INTEGER)}function I(){clearInterval(w)}function V(t,o){const n=Array.prototype.filter.call(c.value.children,e=>e===o||e.matches&&!0===e.matches(".q-tab.q-focusable")),a=n.length;if(0===a)return;if(36===t)return L(n[0]),!0;if(35===t)return L(n[a-1]),!0;const l=t===(!0===e.vertical?38:37),i=t===(!0===e.vertical?40:39),r=!0===l?-1:!0===i?1:void 0;if(void 0!==r){const e=!0===M.value?-1:1,t=n.indexOf(o)+r*e;return t>=0&&t<a&&(L(n[t]),n[t].focus({preventScroll:!0})),!0}}watch(M,k),watch(()=>e.modelValue,e=>{Q({name:e,setCurrent:!0,skipEmit:!0})}),watch(()=>e.outsideArrows,()=>{nextTick(E())}),watch(g,e=>{k=!0===e?z:noop,nextTick(E())});const N=computed(()=>!0===B.value?{get:e=>Math.abs(e.scrollLeft),set:(e,t)=>{e.scrollLeft=-t}}:!0===e.vertical?{get:e=>e.scrollTop,set:(e,t)=>{e.scrollTop=t}}:{get:e=>e.scrollLeft,set:(e,t)=>{e.scrollLeft=t}});function H(e){const t=c.value,{get:o,set:n}=N.value;let a=!1,l=o(t);const i=e<l?-1:1;return l+=5*i,l<0?(a=!0,l=0):(-1===i&&l<=e||1===i&&l>=e)&&(a=!0,l=e),n(t,l),k(),a}function j(){return b.filter(e=>void 0!==e.routerProps&&!0===e.routerProps.hasRouterLink.value)}function U(){let e=null,t=x;const o={matchedLen:0,hrefLen:0,exact:!1,found:!1},{hash:a}=n.proxy.$route,l=d.value;let i=!0===t?emptyFn:e=>{l===e.name.value&&(t=!0,i=emptyFn)};const r=j();for(const n of r){const t=!0===n.routerProps.exact.value;if(!0!==n.routerProps[!0===t?"linkIsExactActive":"linkIsActive"].value||!0===o.exact&&!0!==t){i(n);continue}const l=n.routerProps.linkRoute.value,r=l.hash;if(!0===t){if(a===r){e=n.name.value;break}if(""!==a&&""!==r){i(n);continue}}const s=l.matched.length,u=l.href.length-r.length;(s===o.matchedLen?u>o.hrefLen:s>o.matchedLen)?(e=n.name.value,Object.assign(o,{matchedLen:s,hrefLen:u,exact:t})):i(n)}!0!==t&&null===e||Q({name:e,setCurrent:!0,fromRoute:!0})}function K(e){if(r(),!0!==y.value&&null!==u.value&&e.target&&"function"===typeof e.target.closest){const t=e.target.closest(".q-tab");t&&!0===u.value.contains(t)&&(y.value=!0)}}function W(){i(()=>{y.value=!1},30)}function Y(){!0!==Z.avoidRouteWatcher&&s(U)}function G(e){b.push(e);const t=j();t.length>0&&(void 0===C&&(C=watch(()=>n.proxy.$route,Y)),Y())}function X(e){if(b.splice(b.indexOf(e),1),void 0!==C){const e=j();0===e.length&&(C(),C=void 0),Y()}}const Z={currentModel:d,tabProps:_,hasFocus:y,registerTab:G,unregisterTab:X,verifyRouteModel:Y,updateModel:Q,recalculateScroll:E,onKbdNavigate:V,avoidRouteWatcher:!1};provide(tabsKey,Z),onBeforeUnmount(()=>{clearTimeout(S),void 0!==C&&C()});let J=!1;return onDeactivated(()=>{J=!0}),onActivated(()=>{!0===J&&E()}),()=>{const o=[h(QResizeObserver,{onResize:O}),h("div",{ref:c,class:P.value,onScroll:k},hSlot(t.default))];return!0===g.value&&o.push(h(QIcon,{class:"q-tabs__arrow q-tabs__arrow--left absolute q-tab__icon"+(!0===v.value?"":" q-tabs__arrow--faded"),name:e.leftIcon||a.iconSet.tabs[!0===e.vertical?"up":"left"],onMousedown:F,onTouchstartPassive:F,onMouseup:I,onMouseleave:I,onTouchend:I}),h(QIcon,{class:"q-tabs__arrow q-tabs__arrow--right absolute q-tab__icon"+(!0===m.value?"":" q-tabs__arrow--faded"),name:e.rightIcon||a.iconSet.tabs[!0===e.vertical?"down":"right"],onMousedown:D,onTouchstartPassive:D,onMouseup:I,onMouseleave:I,onTouchend:I})),h("div",{ref:u,class:T.value,role:"tablist",onFocusin:K,onFocusout:W},o)}}});let uid$3=0;const useTabEmits=["click","keydown"],useTabProps={icon:String,label:[Number,String],alert:[Boolean,String],alertIcon:String,name:{type:[Number,String],default:()=>`t_${uid$3++}`},noCaps:Boolean,tabindex:[String,Number],disable:Boolean,contentClass:String,ripple:{type:[Boolean,Object],default:!0}};function useTab(e,t,o,n){const a=inject(tabsKey,()=>{console.error("QTab/QRouteTab component needs to be child of QTabs")}),{proxy:l}=getCurrentInstance(),i=ref(null),r=ref(null),s=ref(null),u=computed(()=>!0!==e.disable&&!1!==e.ripple&&Object.assign({keyCodes:[13,32],early:!0},!0===e.ripple?{}:e.ripple)),c=computed(()=>a.currentModel.value===e.name),d=computed(()=>"q-tab relative-position self-stretch flex flex-center text-center"+(!0===c.value?" q-tab--active"+(a.tabProps.value.activeClass?" "+a.tabProps.value.activeClass:"")+(a.tabProps.value.activeColor?` text-${a.tabProps.value.activeColor}`:"")+(a.tabProps.value.activeBgColor?` bg-${a.tabProps.value.activeBgColor}`:""):" q-tab--inactive")+(e.icon&&e.label&&!1===a.tabProps.value.inlineLabel?" q-tab--full":"")+(!0===e.noCaps||!0===a.tabProps.value.noCaps?" q-tab--no-caps":"")+(!0===e.disable?" disabled":" q-focusable q-hoverable cursor-pointer")+(void 0!==n&&""!==n.linkClass.value?` ${n.linkClass.value}`:"")),p=computed(()=>"q-tab__content self-stretch flex-center relative-position q-anchor--skip non-selectable "+(!0===a.tabProps.value.inlineLabel?"row no-wrap q-tab__content--inline":"column")+(void 0!==e.contentClass?` ${e.contentClass}`:"")),v=computed(()=>!0===e.disable||!0===a.hasFocus.value?-1:e.tabindex||0);function m(t,l){if(!0!==l&&null!==i.value&&i.value.focus(),!0!==e.disable){let l;if(void 0!==n){if(!0!==n.hasRouterLink.value)return void o("click",t);l=(()=>{t.__qNavigate=!0,a.avoidRouteWatcher=!0;const o=n.navigateToRouterLink(t);!1===o?a.avoidRouteWatcher=!1:o.then(()=>{a.avoidRouteWatcher=!1,a.updateModel({name:e.name,fromRoute:!0})})})}else l=(()=>{a.updateModel({name:e.name,fromRoute:!1})});o("click",t,l),!0!==t.defaultPrevented&&l()}}function f(e){isKeyCode(e,[13,32])?m(e,!0):!0!==shouldIgnoreKey(e)&&e.keyCode>=35&&e.keyCode<=40&&!0===a.onKbdNavigate(e.keyCode,l.$el)&&stopAndPrevent(e),o("keydown",e)}function g(){const o=a.tabProps.value.narrowIndicator,n=[],l=h("div",{ref:s,class:["q-tab__indicator",a.tabProps.value.indicatorClass]});void 0!==e.icon&&n.push(h(QIcon,{class:"q-tab__icon",name:e.icon})),void 0!==e.label&&n.push(h("div",{class:"q-tab__label"},e.label)),!1!==e.alert&&n.push(void 0!==e.alertIcon?h(QIcon,{class:"q-tab__alert-icon",color:!0!==e.alert?e.alert:void 0,name:e.alertIcon}):h("div",{class:"q-tab__alert"+(!0!==e.alert?` text-${e.alert}`:"")})),!0===o&&n.push(l);const r=[h("div",{class:"q-focus-helper",tabindex:-1,ref:i}),h("div",{class:p.value},hMergeSlot(t.default,n))];return!1===o&&r.push(l),r}const b={name:computed(()=>e.name),rootRef:r,tabIndicatorRef:s,routerProps:n};function y(t,o){const n={ref:r,class:d.value,tabindex:v.value,role:"tab","aria-selected":!0===c.value?"true":"false","aria-disabled":!0===e.disable?"true":void 0,onClick:m,onKeydown:f,...o};return withDirectives(h(t,n,g()),[[Ripple,u.value]])}return onBeforeUnmount(()=>{a.unregisterTab(b),a.recalculateScroll()}),onMounted(()=>{a.registerTab(b),a.recalculateScroll()}),{renderTab:y,$tabs:a}}var QTab=createComponent({name:"QTab",props:useTabProps,emits:useTabEmits,setup(e,{slots:t,emit:o}){const{renderTab:n}=useTab(e,t,o);return()=>n("div")}}),QTabPanels=createComponent({name:"QTabPanels",props:{...usePanelProps,...useDarkProps},emits:usePanelEmits,setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),{updatePanelsList:a,getPanelContent:l,panelDirectives:i}=usePanel(),r=computed(()=>"q-tab-panels q-panel-parent"+(!0===n.value?" q-tab-panels--dark q-dark":""));return()=>{return a(t),hDir("div",{class:r.value},l(),"pan",e.swipeable,()=>i.value)}}}),QTabPanel=createComponent({name:"QTabPanel",props:usePanelChildProps,setup(e,{slots:t}){return()=>h("div",{class:"q-tab-panel"},hSlot(t.default))}});const hex=/^#[0-9a-fA-F]{3}([0-9a-fA-F]{3})?$/,hexa=/^#[0-9a-fA-F]{4}([0-9a-fA-F]{4})?$/,hexOrHexa=/^#([0-9a-fA-F]{3}|[0-9a-fA-F]{4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/,rgb=/^rgb\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5])\)$/,rgba=/^rgba\(((0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),){2}(0|[1-9][\d]?|1[\d]{0,2}|2[\d]?|2[0-4][\d]|25[0-5]),(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/,testPattern={date:e=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(e),time:e=>/^([0-1]?\d|2[0-3]):[0-5]\d$/.test(e),fulltime:e=>/^([0-1]?\d|2[0-3]):[0-5]\d:[0-5]\d$/.test(e),timeOrFulltime:e=>/^([0-1]?\d|2[0-3]):[0-5]\d(:[0-5]\d)?$/.test(e),hexColor:e=>hex.test(e),hexaColor:e=>hexa.test(e),hexOrHexaColor:e=>hexOrHexa.test(e),rgbColor:e=>rgb.test(e),rgbaColor:e=>rgba.test(e),rgbOrRgbaColor:e=>rgb.test(e)||rgba.test(e),hexOrRgbColor:e=>hex.test(e)||rgb.test(e),hexaOrRgbaColor:e=>hexa.test(e)||rgba.test(e),anyColor:e=>hexOrHexa.test(e)||rgb.test(e)||rgba.test(e)};var patterns={testPattern:testPattern};const reRGBA=/^rgb(a)?\((\d{1,3}),(\d{1,3}),(\d{1,3}),?([01]?\.?\d*?)?\)$/;function rgbToHex({r:e,g:t,b:o,a:n}){const a=void 0!==n;if(e=Math.round(e),t=Math.round(t),o=Math.round(o),e>255||t>255||o>255||a&&n>100)throw new TypeError("Expected 3 numbers below 256 (and optionally one below 100)");return n=a?(256|Math.round(255*n/100)).toString(16).slice(1):"","#"+(o|t<<8|e<<16|1<<24).toString(16).slice(1)+n}function rgbToString({r:e,g:t,b:o,a:n}){return`rgb${void 0!==n?"a":""}(${e},${t},${o}${void 0!==n?","+n/100:""})`}function hexToRgb(e){if("string"!==typeof e)throw new TypeError("Expected a string");e=e.replace(/^#/,""),3===e.length?e=e[0]+e[0]+e[1]+e[1]+e[2]+e[2]:4===e.length&&(e=e[0]+e[0]+e[1]+e[1]+e[2]+e[2]+e[3]+e[3]);const t=parseInt(e,16);return e.length>6?{r:t>>24&255,g:t>>16&255,b:t>>8&255,a:Math.round((255&t)/2.55)}:{r:t>>16,g:t>>8&255,b:255&t}}function hsvToRgb({h:e,s:t,v:o,a:n}){let a,l,i;t/=100,o/=100,e/=360;const r=Math.floor(6*e),s=6*e-r,u=o*(1-t),c=o*(1-s*t),d=o*(1-(1-s)*t);switch(r%6){case 0:a=o,l=d,i=u;break;case 1:a=c,l=o,i=u;break;case 2:a=u,l=o,i=d;break;case 3:a=u,l=c,i=o;break;case 4:a=d,l=u,i=o;break;case 5:a=o,l=u,i=c;break}return{r:Math.round(255*a),g:Math.round(255*l),b:Math.round(255*i),a:n}}function rgbToHsv({r:e,g:t,b:o,a:n}){const a=Math.max(e,t,o),l=Math.min(e,t,o),i=a-l,r=0===a?0:i/a,s=a/255;let u;switch(a){case l:u=0;break;case e:u=t-o+i*(t<o?6:0),u/=6*i;break;case t:u=o-e+2*i,u/=6*i;break;case o:u=e-t+4*i,u/=6*i;break}return{h:Math.round(360*u),s:Math.round(100*r),v:Math.round(100*s),a:n}}function textToRgb(e){if("string"!==typeof e)throw new TypeError("Expected a string");const t=e.replace(/ /g,""),o=reRGBA.exec(t);if(null===o)return hexToRgb(t);const n={r:Math.min(255,parseInt(o[2],10)),g:Math.min(255,parseInt(o[3],10)),b:Math.min(255,parseInt(o[4],10))};if(o[1]){const e=parseFloat(o[5]);n.a=100*Math.min(1,!0===isNaN(e)?1:e)}return n}function lighten(e,t){if("string"!==typeof e)throw new TypeError("Expected a string as color");if("number"!==typeof t)throw new TypeError("Expected a numeric percent");const o=textToRgb(e),n=t<0?0:255,a=Math.abs(t)/100,l=o.r,i=o.g,r=o.b;return"#"+(16777216+65536*(Math.round((n-l)*a)+l)+256*(Math.round((n-i)*a)+i)+(Math.round((n-r)*a)+r)).toString(16).slice(1)}function luminosity(e){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const t="string"===typeof e?textToRgb(e):e,o=t.r/255,n=t.g/255,a=t.b/255,l=o<=.03928?o/12.92:Math.pow((o+.055)/1.055,2.4),i=n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4),r=a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4);return.2126*l+.7152*i+.0722*r}function brightness(e){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b} object as color");const t="string"===typeof e?textToRgb(e):e;return(299*t.r+587*t.g+114*t.b)/1e3}function blend(e,t){if("string"!==typeof e&&(!e||void 0===e.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as fgColor");if("string"!==typeof t&&(!t||void 0===t.r))throw new TypeError("Expected a string or a {r, g, b[, a]} object as bgColor");const o="string"===typeof e?textToRgb(e):e,n=o.r/255,a=o.g/255,l=o.b/255,i=void 0!==o.a?o.a/100:1,r="string"===typeof t?textToRgb(t):t,s=r.r/255,u=r.g/255,c=r.b/255,d=void 0!==r.a?r.a/100:1,p=i+d*(1-i),v=Math.round((n*i+s*d*(1-i))/p*255),m=Math.round((a*i+u*d*(1-i))/p*255),f=Math.round((l*i+c*d*(1-i))/p*255),h={r:v,g:m,b:f,a:Math.round(100*p)};return"string"===typeof e?rgbToHex(h):h}function changeAlpha(e,t){if("string"!==typeof e)throw new TypeError("Expected a string as color");if(void 0===t||t<-1||t>1)throw new TypeError("Expected offset to be between -1 and 1");const{r:o,g:n,b:a,a:l}=textToRgb(e),i=void 0!==l?l/100:0;return rgbToHex({r:o,g:n,b:a,a:Math.round(100*Math.min(1,Math.max(0,i+t)))})}function getPaletteColor(e){if("string"!==typeof e)throw new TypeError("Expected a string as color");const t=document.createElement("div");t.className=`text-${e} invisible fixed no-pointer-events`,document.body.appendChild(t);const o=getComputedStyle(t).getPropertyValue("color");return t.remove(),rgbToHex(textToRgb(o))}var colors={rgbToHex:rgbToHex,hexToRgb:hexToRgb,hsvToRgb:hsvToRgb,rgbToHsv:rgbToHsv,textToRgb:textToRgb,lighten:lighten,luminosity:luminosity,brightness:brightness,blend:blend,changeAlpha:changeAlpha,getPaletteColor:getPaletteColor};const palette=["rgb(255,204,204)","rgb(255,230,204)","rgb(255,255,204)","rgb(204,255,204)","rgb(204,255,230)","rgb(204,255,255)","rgb(204,230,255)","rgb(204,204,255)","rgb(230,204,255)","rgb(255,204,255)","rgb(255,153,153)","rgb(255,204,153)","rgb(255,255,153)","rgb(153,255,153)","rgb(153,255,204)","rgb(153,255,255)","rgb(153,204,255)","rgb(153,153,255)","rgb(204,153,255)","rgb(255,153,255)","rgb(255,102,102)","rgb(255,179,102)","rgb(255,255,102)","rgb(102,255,102)","rgb(102,255,179)","rgb(102,255,255)","rgb(102,179,255)","rgb(102,102,255)","rgb(179,102,255)","rgb(255,102,255)","rgb(255,51,51)","rgb(255,153,51)","rgb(255,255,51)","rgb(51,255,51)","rgb(51,255,153)","rgb(51,255,255)","rgb(51,153,255)","rgb(51,51,255)","rgb(153,51,255)","rgb(255,51,255)","rgb(255,0,0)","rgb(255,128,0)","rgb(255,255,0)","rgb(0,255,0)","rgb(0,255,128)","rgb(0,255,255)","rgb(0,128,255)","rgb(0,0,255)","rgb(128,0,255)","rgb(255,0,255)","rgb(245,0,0)","rgb(245,123,0)","rgb(245,245,0)","rgb(0,245,0)","rgb(0,245,123)","rgb(0,245,245)","rgb(0,123,245)","rgb(0,0,245)","rgb(123,0,245)","rgb(245,0,245)","rgb(214,0,0)","rgb(214,108,0)","rgb(214,214,0)","rgb(0,214,0)","rgb(0,214,108)","rgb(0,214,214)","rgb(0,108,214)","rgb(0,0,214)","rgb(108,0,214)","rgb(214,0,214)","rgb(163,0,0)","rgb(163,82,0)","rgb(163,163,0)","rgb(0,163,0)","rgb(0,163,82)","rgb(0,163,163)","rgb(0,82,163)","rgb(0,0,163)","rgb(82,0,163)","rgb(163,0,163)","rgb(92,0,0)","rgb(92,46,0)","rgb(92,92,0)","rgb(0,92,0)","rgb(0,92,46)","rgb(0,92,92)","rgb(0,46,92)","rgb(0,0,92)","rgb(46,0,92)","rgb(92,0,92)","rgb(255,255,255)","rgb(205,205,205)","rgb(178,178,178)","rgb(153,153,153)","rgb(127,127,127)","rgb(102,102,102)","rgb(76,76,76)","rgb(51,51,51)","rgb(25,25,25)","rgb(0,0,0)"],thumbPath="M5 5 h10 v10 h-10 v-10 z",alphaTrackImg="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAH0lEQVQoU2NkYGAwZkAFZ5G5jPRRgOYEVDeB3EBjBQBOZwTVugIGyAAAAABJRU5ErkJggg==";var QColor=createComponent({name:"QColor",props:{...useDarkProps,...useFormProps,modelValue:String,defaultValue:String,defaultView:{type:String,default:"spectrum",validator:e=>["spectrum","tune","palette"].includes(e)},formatModel:{type:String,default:"auto",validator:e=>["auto","hex","rgb","hexa","rgba"].includes(e)},palette:Array,noHeader:Boolean,noHeaderTabs:Boolean,noFooter:Boolean,square:Boolean,flat:Boolean,bordered:Boolean,disable:Boolean,readonly:Boolean},emits:["update:modelValue","change"],setup(e,{emit:t}){const{proxy:o}=getCurrentInstance(),{$q:n}=o,a=useDark(e,n),{getCache:l}=useCache(),i=ref(null),r=ref(null),s=computed(()=>"auto"===e.formatModel?null:e.formatModel.indexOf("hex")>-1),u=computed(()=>"auto"===e.formatModel?null:e.formatModel.indexOf("a")>-1),c=ref("auto"===e.formatModel?void 0===e.modelValue||null===e.modelValue||""===e.modelValue||e.modelValue.startsWith("#")?"hex":"rgb":e.formatModel.startsWith("hex")?"hex":"rgb"),d=ref(e.defaultView),p=ref($(e.modelValue||e.defaultValue)),v=computed(()=>!0!==e.disable&&!0!==e.readonly),m=computed(()=>void 0===e.modelValue||null===e.modelValue||""===e.modelValue||e.modelValue.startsWith("#")),f=computed(()=>null!==s.value?s.value:m.value),g=computed(()=>({type:"hidden",name:e.name,value:p.value[!0===f.value?"hex":"rgb"]})),b=useFormInject(g),y=computed(()=>null!==u.value?u.value:void 0!==p.value.a),S=computed(()=>({backgroundColor:p.value.rgb||"#000"})),w=computed(()=>{const e=void 0!==p.value.a&&p.value.a<65||luminosity(p.value)>.4;return"q-color-picker__header-content"+` q-color-picker__header-content--${e?"light":"dark"}`}),C=computed(()=>({background:`hsl(${p.value.h},100%,50%)`})),x=computed(()=>({top:`${100-p.value.v}%`,[!0===n.lang.rtl?"right":"left"]:`${p.value.s}%`})),k=computed(()=>void 0!==e.palette&&e.palette.length>0?e.palette:palette),_=computed(()=>"q-color-picker"+(!0===e.bordered?" q-color-picker--bordered":"")+(!0===e.square?" q-color-picker--square no-border-radius":"")+(!0===e.flat?" q-color-picker--flat no-shadow":"")+(!0===e.disable?" disabled":"")+(!0===a.value?" q-color-picker--dark q-dark":"")),q=computed(()=>{return!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{}}),T=computed(()=>{return[[TouchPan,R,void 0,{prevent:!0,stop:!0,mouse:!0}]]});function P(e,o){p.value.hex=rgbToHex(e),p.value.rgb=rgbToString(e),p.value.r=e.r,p.value.g=e.g,p.value.b=e.b,p.value.a=e.a;const n=p.value[!0===f.value?"hex":"rgb"];t("update:modelValue",n),!0===o&&t("change",n)}function $(t){const o=void 0!==u.value?u.value:"auto"===e.formatModel?null:e.formatModel.indexOf("a")>-1;if("string"!==typeof t||0===t.length||!0!==testPattern.anyColor(t.replace(/ /g,"")))return{h:0,s:0,v:0,r:0,g:0,b:0,a:!0===o?100:void 0,hex:void 0,rgb:void 0};const n=textToRgb(t);return!0===o&&void 0===n.a&&(n.a=100),n.hex=rgbToHex(n),n.rgb=rgbToString(n),Object.assign(n,rgbToHsv(n))}function M(e,t,o){const a=i.value;if(null===a)return;const l=a.clientWidth,r=a.clientHeight,s=a.getBoundingClientRect();let u=Math.min(l,Math.max(0,e-s.left));!0===n.lang.rtl&&(u=l-u);const c=Math.min(r,Math.max(0,t-s.top)),d=Math.round(100*u/l),v=Math.round(100*Math.max(0,Math.min(1,-c/r+1))),m=hsvToRgb({h:p.value.h,s:d,v:v,a:!0===y.value?p.value.a:void 0});p.value.s=d,p.value.v=v,P(m,o)}function B(e,t){const o=Math.round(e),n=hsvToRgb({h:o,s:p.value.s,v:p.value.v,a:!0===y.value?p.value.a:void 0});p.value.h=o,P(n,t)}function Q(e,t,n,a,l){if(void 0!==a&&stop(a),!/^[0-9]+$/.test(e))return void(!0===l&&o.$forceUpdate());const i=Math.floor(Number(e));if(i<0||i>n)return void(!0===l&&o.$forceUpdate());const r={r:"r"===t?i:p.value.r,g:"g"===t?i:p.value.g,b:"b"===t?i:p.value.b,a:!0===y.value?"a"===t?i:p.value.a:void 0};if("a"!==t){const e=rgbToHsv(r);p.value.h=e.h,p.value.s=e.s,p.value.v=e.v}if(P(r,l),void 0!==a&&!0!==l&&void 0!==a.target.selectionEnd){const e=a.target.selectionEnd;nextTick(()=>{a.target.setSelectionRange(e,e)})}}function E(e,t){let o;const n=e.target.value;if(stop(e),"hex"===c.value){if(n.length!==(!0===y.value?9:7)||!/^#[0-9A-Fa-f]+$/.test(n))return!0;o=hexToRgb(n)}else{let e;if(!n.endsWith(")"))return!0;if(!0!==y.value&&n.startsWith("rgb(")){if(e=n.substring(4,n.length-1).split(",").map(e=>parseInt(e,10)),3!==e.length||!/^rgb\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3}\)$/.test(n))return!0}else{if(!0!==y.value||!n.startsWith("rgba("))return!0;{if(e=n.substring(5,n.length-1).split(","),4!==e.length||!/^rgba\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3},(0|0\.[0-9]+[1-9]|0\.[1-9]+|1)\)$/.test(n))return!0;for(let o=0;o<3;o++){const t=parseInt(e[o],10);if(t<0||t>255)return!0;e[o]=t}const t=parseFloat(e[3]);if(t<0||t>1)return!0;e[3]=t}}if(e[0]<0||e[0]>255||e[1]<0||e[1]>255||e[2]<0||e[2]>255||!0===y.value&&(e[3]<0||e[3]>1))return!0;o={r:e[0],g:e[1],b:e[2],a:!0===y.value?100*e[3]:void 0}}const a=rgbToHsv(o);if(p.value.h=a.h,p.value.s=a.s,p.value.v=a.v,P(o,t),!0!==t){const t=e.target.selectionEnd;nextTick(()=>{e.target.setSelectionRange(t,t)})}}function O(e){const t=$(e),o={r:t.r,g:t.g,b:t.b,a:t.a};void 0===o.a&&(o.a=p.value.a),p.value.h=t.h,p.value.s=t.s,p.value.v=t.v,P(o,!0)}function R(e){e.isFinal?M(e.position.left,e.position.top,!0):L(e)}watch(()=>e.modelValue,t=>{const o=$(t||e.defaultValue);o.hex!==p.value.hex&&(p.value=o)}),watch(()=>e.defaultValue,t=>{if(!e.modelValue&&t){const e=$(t);e.hex!==p.value.hex&&(p.value=e)}});const L=throttle(e=>{M(e.position.left,e.position.top)},20);function z(e){M(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset,!0)}function A(e){M(e.pageX-window.pageXOffset,e.pageY-window.pageYOffset)}function F(e){null!==r.value&&(r.value.$el.style.opacity=e?1:0)}function D(){const t=[];return!0!==e.noHeaderTabs&&t.push(h(QTabs,{class:"q-color-picker__header-tabs",modelValue:c.value,dense:!0,align:"justify",...l("topVTab",{"onUpdate:modelValue":e=>{c.value=e}})},()=>[h(QTab,{label:"HEX"+(!0===y.value?"A":""),name:"hex",ripple:!1}),h(QTab,{label:"RGB"+(!0===y.value?"A":""),name:"rgb",ripple:!1})])),t.push(h("div",{class:"q-color-picker__header-banner row flex-center no-wrap"},[h("input",{class:"fit",value:p.value[c.value],...!0!==v.value?{readonly:!0}:{},...l("topIn",{onInput:e=>{F(!0===E(e))},onChange:stop,onBlur:e=>{!0===E(e,!0)&&o.$forceUpdate(),F(!1)}})}),h(QIcon,{ref:r,class:"q-color-picker__error-icon absolute no-pointer-events",name:n.iconSet.type.negative})])),h("div",{class:"q-color-picker__header relative-position overflow-hidden"},[h("div",{class:"q-color-picker__header-bg absolute-full"}),h("div",{class:w.value,style:S.value},t)])}function I(){return h(QTabPanels,{modelValue:d.value,animated:!0},()=>[h(QTabPanel,{class:"q-color-picker__spectrum-tab overflow-hidden",name:"spectrum"},N),h(QTabPanel,{class:"q-pa-md q-color-picker__tune-tab",name:"tune"},H),h(QTabPanel,{class:"q-color-picker__palette-tab",name:"palette"},j)])}function V(){return h("div",{class:"q-color-picker__footer relative-position overflow-hidden"},[h(QTabs,{class:"absolute-full",modelValue:d.value,dense:!0,align:"justify",...l("ftIn",{"onUpdate:modelValue":e=>{d.value=e}})},()=>[h(QTab,{icon:n.iconSet.colorPicker.spectrum,name:"spectrum",ripple:!1}),h(QTab,{icon:n.iconSet.colorPicker.tune,name:"tune",ripple:!1}),h(QTab,{icon:n.iconSet.colorPicker.palette,name:"palette",ripple:!1})])])}function N(){const e={ref:i,class:"q-color-picker__spectrum non-selectable relative-position cursor-pointer"+(!0!==v.value?" readonly":""),style:C.value,...!0===v.value?{onClick:z,onMousedown:A}:{}},t=[h("div",{style:{paddingBottom:"100%"}}),h("div",{class:"q-color-picker__spectrum-white absolute-full"}),h("div",{class:"q-color-picker__spectrum-black absolute-full"}),h("div",{class:"absolute",style:x.value},[void 0!==p.value.hex?h("div",{class:"q-color-picker__spectrum-circle"}):null])],o=[h(QSlider,{class:"q-color-picker__hue non-selectable",modelValue:p.value.h,min:0,max:360,trackSize:"8px",innerTrackColor:"transparent",selectionColor:"transparent",readonly:!0!==v.value,thumbPath:thumbPath,"onUpdate:modelValue":B,...l("lazyhue",{onChange:e=>B(e,!0)})})];return!0===y.value&&o.push(h(QSlider,{class:"q-color-picker__alpha non-selectable",modelValue:p.value.a,min:0,max:100,trackSize:"8px",trackColor:"white",innerTrackColor:"transparent",selectionColor:"transparent",trackImg:alphaTrackImg,readonly:!0!==v.value,hideSelection:!0,thumbPath:thumbPath,...l("alphaSlide",{"onUpdate:modelValue":e=>Q(e,"a",100),onChange:e=>Q(e,"a",100,void 0,!0)})})),[hDir("div",e,t,"spec",v.value,()=>T.value),h("div",{class:"q-color-picker__sliders"},o)]}function H(){return[h("div",{class:"row items-center no-wrap"},[h("div","R"),h(QSlider,{modelValue:p.value.r,min:0,max:255,color:"red",dark:a.value,readonly:!0!==v.value,...l("rSlide",{"onUpdate:modelValue":e=>Q(e,"r",255),onChange:e=>Q(e,"r",255,void 0,!0)})}),h("input",{value:p.value.r,maxlength:3,readonly:!0!==v.value,onChange:stop,...l("rIn",{onInput:e=>Q(e.target.value,"r",255,e),onBlur:e=>Q(e.target.value,"r",255,e,!0)})})]),h("div",{class:"row items-center no-wrap"},[h("div","G"),h(QSlider,{modelValue:p.value.g,min:0,max:255,color:"green",dark:a.value,readonly:!0!==v.value,...l("gSlide",{"onUpdate:modelValue":e=>Q(e,"g",255),onChange:e=>Q(e,"g",255,void 0,!0)})}),h("input",{value:p.value.g,maxlength:3,readonly:!0!==v.value,onChange:stop,...l("gIn",{onInput:e=>Q(e.target.value,"g",255,e),onBlur:e=>Q(e.target.value,"g",255,e,!0)})})]),h("div",{class:"row items-center no-wrap"},[h("div","B"),h(QSlider,{modelValue:p.value.b,min:0,max:255,color:"blue",readonly:!0!==v.value,dark:a.value,...l("bSlide",{"onUpdate:modelValue":e=>Q(e,"b",255),onChange:e=>Q(e,"b",255,void 0,!0)})}),h("input",{value:p.value.b,maxlength:3,readonly:!0!==v.value,onChange:stop,...l("bIn",{onInput:e=>Q(e.target.value,"b",255,e),onBlur:e=>Q(e.target.value,"b",255,e,!0)})})]),!0===y.value?h("div",{class:"row items-center no-wrap"},[h("div","A"),h(QSlider,{modelValue:p.value.a,color:"grey",readonly:!0!==v.value,dark:a.value,...l("aSlide",{"onUpdate:modelValue":e=>Q(e,"a",100),onChange:e=>Q(e,"a",100,void 0,!0)})}),h("input",{value:p.value.a,maxlength:3,readonly:!0!==v.value,onChange:stop,...l("aIn",{onInput:e=>Q(e.target.value,"a",100,e),onBlur:e=>Q(e.target.value,"a",100,e,!0)})})]):null]}function j(){const e=e=>h("div",{class:"q-color-picker__cube col-auto",style:{backgroundColor:e},...!0===v.value?l("palette#"+e,{onClick:()=>{O(e)}}):{}});return[h("div",{class:"row items-center q-color-picker__palette-rows"+(!0===v.value?" q-color-picker__palette-rows--editable":"")},k.value.map(e))]}return()=>{const t=[I()];return void 0!==e.name&&!0!==e.disable&&b(t,"push"),!0!==e.noHeader&&t.unshift(D()),!0!==e.noFooter&&t.push(V()),h("div",{class:_.value,...q.value},t)}}});const breaks=[-61,9,38,199,426,686,756,818,1111,1181,1210,1635,2060,2097,2192,2262,2324,2394,2456,3178];function toJalaali(e,t,o){return"[object Date]"===Object.prototype.toString.call(e)&&(o=e.getDate(),t=e.getMonth()+1,e=e.getFullYear()),d2j(g2d(e,t,o))}function toGregorian(e,t,o){return d2g(j2d(e,t,o))}function isLeapJalaaliYear(e){return 0===jalCalLeap(e)}function jalaaliMonthLength(e,t){return t<=6?31:t<=11?30:isLeapJalaaliYear(e)?30:29}function jalCalLeap(e){const t=breaks.length;let o,n,a,l,i,r=breaks[0];if(e<r||e>=breaks[t-1])throw new Error("Invalid Jalaali year "+e);for(i=1;i<t;i+=1){if(o=breaks[i],n=o-r,e<o)break;r=o}return l=e-r,n-l<6&&(l=l-n+33*div(n+4,33)),a=mod(mod(l+1,33)-1,4),-1===a&&(a=4),a}function jalCal(e,t){const o=breaks.length,n=e+621;let a,l,i,r,s,u=-14,c=breaks[0];if(e<c||e>=breaks[o-1])throw new Error("Invalid Jalaali year "+e);for(s=1;s<o;s+=1){if(a=breaks[s],l=a-c,e<a)break;u=u+8*div(l,33)+div(mod(l,33),4),c=a}r=e-c,u=u+8*div(r,33)+div(mod(r,33)+3,4),4===mod(l,33)&&l-r===4&&(u+=1);const d=div(n,4)-div(3*(div(n,100)+1),4)-150,p=20+u-d;return t||(l-r<6&&(r=r-l+33*div(l+4,33)),i=mod(mod(r+1,33)-1,4),-1===i&&(i=4)),{leap:i,gy:n,march:p}}function j2d(e,t,o){const n=jalCal(e,!0);return g2d(n.gy,3,n.march)+31*(t-1)-div(t,7)*(t-7)+o-1}function d2j(e){const t=d2g(e).gy;let o,n,a,l=t-621;const i=jalCal(l,!1),r=g2d(t,3,i.march);if(a=e-r,a>=0){if(a<=185)return n=1+div(a,31),o=mod(a,31)+1,{jy:l,jm:n,jd:o};a-=186}else l-=1,a+=179,1===i.leap&&(a+=1);return n=7+div(a,30),o=mod(a,30)+1,{jy:l,jm:n,jd:o}}function g2d(e,t,o){let n=div(1461*(e+div(t-8,6)+100100),4)+div(153*mod(t+9,12)+2,5)+o-34840408;return n=n-div(3*div(e+100100+div(t-8,6),100),4)+752,n}function d2g(e){let t=4*e+139361631;t=t+4*div(3*div(4*e+183187720,146097),4)-3908;const o=5*div(mod(t,1461),4)+308,n=div(mod(o,153),5)+1,a=mod(div(o,153),12)+1,l=div(t,1461)-100100+div(8-a,6);return{gy:l,gm:a,gd:n}}function div(e,t){return~~(e/t)}function mod(e,t){return e-~~(e/t)*t}const calendars=["gregorian","persian"],useDatetimeProps={modelValue:{required:!0},mask:{type:String},locale:Object,calendar:{type:String,validator:e=>calendars.includes(e),default:"gregorian"},landscape:Boolean,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,readonly:Boolean,disable:Boolean},useDatetimeEmits=["update:modelValue"];function getDayHash(e){return e.year+"/"+pad(e.month)+"/"+pad(e.day)}function useDatetime(e,t){const o=computed(()=>{return!0!==e.disable&&!0!==e.readonly}),n=computed(()=>{return!0===e.editable?0:-1}),a=computed(()=>{const t=[];return void 0!==e.color&&t.push(`bg-${e.color}`),void 0!==e.textColor&&t.push(`text-${e.textColor}`),t.join(" ")});function l(){return e.locale||t.lang.date}function i(t){const o=new Date,n=!0===t?null:0;if("persian"===e.calendar){const e=toJalaali(o);return{year:e.jy,month:e.jm,day:e.jd}}return{year:o.getFullYear(),month:o.getMonth()+1,day:o.getDate(),hour:n,minute:n,second:n,millisecond:n}}return{editable:o,tabindex:n,headerClass:a,getLocale:l,getCurrentDate:i}}const MILLISECONDS_IN_DAY=864e5,MILLISECONDS_IN_HOUR=36e5,MILLISECONDS_IN_MINUTE=6e4,defaultMask="YYYY-MM-DDTHH:mm:ss.SSSZ",token=/\[((?:[^\]\\]|\\]|\\)*)\]|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]/g,reverseToken=/(\[[^\]]*\])|d{1,4}|M{1,4}|m{1,2}|w{1,2}|Qo|Do|D{1,4}|YY(?:YY)?|H{1,2}|h{1,2}|s{1,2}|S{1,3}|Z{1,2}|a{1,2}|[AQExX]|([.*+:?^,\s${}()|\\]+)/g,regexStore={};function getRegexData(e,t){const o="("+t.days.join("|")+")",n=e+o;if(void 0!==regexStore[n])return regexStore[n];const a="("+t.daysShort.join("|")+")",l="("+t.months.join("|")+")",i="("+t.monthsShort.join("|")+")",r={};let s=0;const u=e.replace(reverseToken,e=>{switch(s++,e){case"YY":return r.YY=s,"(-?\\d{1,2})";case"YYYY":return r.YYYY=s,"(-?\\d{1,4})";case"M":return r.M=s,"(\\d{1,2})";case"MM":return r.M=s,"(\\d{2})";case"MMM":return r.MMM=s,i;case"MMMM":return r.MMMM=s,l;case"D":return r.D=s,"(\\d{1,2})";case"Do":return r.D=s++,"(\\d{1,2}(st|nd|rd|th))";case"DD":return r.D=s,"(\\d{2})";case"H":return r.H=s,"(\\d{1,2})";case"HH":return r.H=s,"(\\d{2})";case"h":return r.h=s,"(\\d{1,2})";case"hh":return r.h=s,"(\\d{2})";case"m":return r.m=s,"(\\d{1,2})";case"mm":return r.m=s,"(\\d{2})";case"s":return r.s=s,"(\\d{1,2})";case"ss":return r.s=s,"(\\d{2})";case"S":return r.S=s,"(\\d{1})";case"SS":return r.S=s,"(\\d{2})";case"SSS":return r.S=s,"(\\d{3})";case"A":return r.A=s,"(AM|PM)";case"a":return r.a=s,"(am|pm)";case"aa":return r.aa=s,"(a\\.m\\.|p\\.m\\.)";case"ddd":return a;case"dddd":return o;case"Q":case"d":case"E":return"(\\d{1})";case"Qo":return"(1st|2nd|3rd|4th)";case"DDD":case"DDDD":return"(\\d{1,3})";case"w":return"(\\d{1,2})";case"ww":return"(\\d{2})";case"Z":return r.Z=s,"(Z|[+-]\\d{2}:\\d{2})";case"ZZ":return r.ZZ=s,"(Z|[+-]\\d{2}\\d{2})";case"X":return r.X=s,"(-?\\d+)";case"x":return r.x=s,"(-?\\d{4,})";default:return s--,"["===e[0]&&(e=e.substring(1,e.length-1)),e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}}),c={map:r,regex:new RegExp("^"+u)};return regexStore[n]=c,c}function getDateLocale(e,t){return void 0!==e?e:void 0!==t?t.date:defaultLang.date}function formatTimezone(e,t=""){const o=e>0?"-":"+",n=Math.abs(e),a=Math.floor(n/60),l=n%60;return o+pad(a)+t+pad(l)}function applyYearMonthDayChange(e,t,o){let n=e.getFullYear(),a=e.getMonth();const l=e.getDate();return void 0!==t.year&&(n+=o*t.year,delete t.year),void 0!==t.month&&(a+=o*t.month,delete t.month),e.setDate(1),e.setMonth(2),e.setFullYear(n),e.setMonth(a),e.setDate(Math.min(l,daysInMonth(e))),void 0!==t.date&&(e.setDate(e.getDate()+o*t.date),delete t.date),e}function applyYearMonthDay(e,t,o){const n=void 0!==t.year?t.year:e[`get${o}FullYear`](),a=void 0!==t.month?t.month-1:e[`get${o}Month`](),l=new Date(n,a+1,0).getDate(),i=Math.min(l,void 0!==t.date?t.date:e[`get${o}Date`]());return e[`set${o}Date`](1),e[`set${o}Month`](2),e[`set${o}FullYear`](n),e[`set${o}Month`](a),e[`set${o}Date`](i),delete t.year,delete t.month,delete t.date,e}function getChange(e,t,o){const n=normalizeMod(t),a=new Date(e),l=void 0!==n.year||void 0!==n.month||void 0!==n.date?applyYearMonthDayChange(a,n,o):a;for(const i in n){const e=capitalize(i);l[`set${e}`](l[`get${e}`]()+o*n[i])}return l}function normalizeMod(e){const t={...e};return void 0!==e.years&&(t.year=e.years,delete t.years),void 0!==e.months&&(t.month=e.months,delete t.months),void 0!==e.days&&(t.date=e.days,delete t.days),void 0!==e.day&&(t.date=e.day,delete t.day),void 0!==e.hour&&(t.hours=e.hour,delete t.hour),void 0!==e.minute&&(t.minutes=e.minute,delete t.minute),void 0!==e.second&&(t.seconds=e.second,delete t.second),void 0!==e.millisecond&&(t.milliseconds=e.millisecond,delete t.millisecond),t}function adjustDate(e,t,o){const n=normalizeMod(t),a=!0===o?"UTC":"",l=new Date(e),i=void 0!==n.year||void 0!==n.month||void 0!==n.date?applyYearMonthDay(l,n,a):l;for(const r in n){const e=r.charAt(0).toUpperCase()+r.slice(1);i[`set${a}${e}`](n[r])}return i}function extractDate(e,t,o){const n=__splitDate(e,t,o),a=new Date(n.year,null===n.month?null:n.month-1,n.day,n.hour,n.minute,n.second,n.millisecond),l=a.getTimezoneOffset();return null===n.timezoneOffset||n.timezoneOffset===l?a:getChange(a,{minutes:n.timezoneOffset-l},1)}function __splitDate(e,t,o,n,a){const l={year:null,month:null,day:null,hour:null,minute:null,second:null,millisecond:null,timezoneOffset:null,dateHash:null,timeHash:null};if(void 0!==a&&Object.assign(l,a),void 0===e||null===e||""===e||"string"!==typeof e)return l;void 0===t&&(t=defaultMask);const i=getDateLocale(o,Plugin$8.props),r=i.months,s=i.monthsShort,{regex:u,map:c}=getRegexData(t,i),d=e.match(u);if(null===d)return l;let p="";if(void 0!==c.X||void 0!==c.x){const e=parseInt(d[void 0!==c.X?c.X:c.x],10);if(!0===isNaN(e)||e<0)return l;const t=new Date(e*(void 0!==c.X?1e3:1));l.year=t.getFullYear(),l.month=t.getMonth()+1,l.day=t.getDate(),l.hour=t.getHours(),l.minute=t.getMinutes(),l.second=t.getSeconds(),l.millisecond=t.getMilliseconds()}else{if(void 0!==c.YYYY)l.year=parseInt(d[c.YYYY],10);else if(void 0!==c.YY){const e=parseInt(d[c.YY],10);l.year=e<0?e:2e3+e}if(void 0!==c.M){if(l.month=parseInt(d[c.M],10),l.month<1||l.month>12)return l}else void 0!==c.MMM?l.month=s.indexOf(d[c.MMM])+1:void 0!==c.MMMM&&(l.month=r.indexOf(d[c.MMMM])+1);if(void 0!==c.D){if(l.day=parseInt(d[c.D],10),null===l.year||null===l.month||l.day<1)return l;const e="persian"!==n?new Date(l.year,l.month,0).getDate():jalaaliMonthLength(l.year,l.month);if(l.day>e)return l}void 0!==c.H?l.hour=parseInt(d[c.H],10)%24:void 0!==c.h&&(l.hour=parseInt(d[c.h],10)%12,(c.A&&"PM"===d[c.A]||c.a&&"pm"===d[c.a]||c.aa&&"p.m."===d[c.aa])&&(l.hour+=12),l.hour=l.hour%24),void 0!==c.m&&(l.minute=parseInt(d[c.m],10)%60),void 0!==c.s&&(l.second=parseInt(d[c.s],10)%60),void 0!==c.S&&(l.millisecond=parseInt(d[c.S],10)*10**(3-d[c.S].length)),void 0===c.Z&&void 0===c.ZZ||(p=void 0!==c.Z?d[c.Z].replace(":",""):d[c.ZZ],l.timezoneOffset=("+"===p[0]?-1:1)*(60*p.slice(1,3)+1*p.slice(3,5)))}return l.dateHash=pad(l.year,6)+"/"+pad(l.month)+"/"+pad(l.day),l.timeHash=pad(l.hour)+":"+pad(l.minute)+":"+pad(l.second)+p,l}function isValid(e){return"number"===typeof e||!1===isNaN(Date.parse(e))}function buildDate(e,t){return adjustDate(new Date,e,t)}function getDayOfWeek(e){const t=new Date(e).getDay();return 0===t?7:t}function getWeekOfYear(e){const t=new Date(e.getFullYear(),e.getMonth(),e.getDate());t.setDate(t.getDate()-(t.getDay()+6)%7+3);const o=new Date(t.getFullYear(),0,4);o.setDate(o.getDate()-(o.getDay()+6)%7+3);const n=t.getTimezoneOffset()-o.getTimezoneOffset();t.setHours(t.getHours()-n);const a=(t-o)/(7*MILLISECONDS_IN_DAY);return 1+Math.floor(a)}function getDayIdentifier(e){return 1e4*e.getFullYear()+100*e.getMonth()+e.getDate()}function getDateIdentifier(e,t){const o=new Date(e);return!0===t?getDayIdentifier(o):o.getTime()}function isBetweenDates(e,t,o,n={}){const a=getDateIdentifier(t,n.onlyDate),l=getDateIdentifier(o,n.onlyDate),i=getDateIdentifier(e,n.onlyDate);return(i>a||!0===n.inclusiveFrom&&i===a)&&(i<l||!0===n.inclusiveTo&&i===l)}function addToDate(e,t){return getChange(e,t,1)}function subtractFromDate(e,t){return getChange(e,t,-1)}function startOfDate(e,t,o){const n=new Date(e),a=`set${!0===o?"UTC":""}`;switch(t){case"year":case"years":n[`${a}Month`](0);case"month":case"months":n[`${a}Date`](1);case"day":case"days":case"date":n[`${a}Hours`](0);case"hour":case"hours":n[`${a}Minutes`](0);case"minute":case"minutes":n[`${a}Seconds`](0);case"second":case"seconds":n[`${a}Milliseconds`](0)}return n}function endOfDate(e,t,o){const n=new Date(e),a=`set${!0===o?"UTC":""}`;switch(t){case"year":case"years":n[`${a}Month`](11);case"month":case"months":n[`${a}Date`](daysInMonth(n));case"day":case"days":case"date":n[`${a}Hours`](23);case"hour":case"hours":n[`${a}Minutes`](59);case"minute":case"minutes":n[`${a}Seconds`](59);case"second":case"seconds":n[`${a}Milliseconds`](999)}return n}function getMaxDate(e){let t=new Date(e);return Array.prototype.slice.call(arguments,1).forEach(e=>{t=Math.max(t,new Date(e))}),t}function getMinDate(e){let t=new Date(e);return Array.prototype.slice.call(arguments,1).forEach(e=>{t=Math.min(t,new Date(e))}),t}function getDiff(e,t,o){return(e.getTime()-e.getTimezoneOffset()*MILLISECONDS_IN_MINUTE-(t.getTime()-t.getTimezoneOffset()*MILLISECONDS_IN_MINUTE))/o}function getDateDiff(e,t,o="days"){const n=new Date(e),a=new Date(t);switch(o){case"years":case"year":return n.getFullYear()-a.getFullYear();case"months":case"month":return 12*(n.getFullYear()-a.getFullYear())+n.getMonth()-a.getMonth();case"days":case"day":case"date":return getDiff(startOfDate(n,"day"),startOfDate(a,"day"),MILLISECONDS_IN_DAY);case"hours":case"hour":return getDiff(startOfDate(n,"hour"),startOfDate(a,"hour"),MILLISECONDS_IN_HOUR);case"minutes":case"minute":return getDiff(startOfDate(n,"minute"),startOfDate(a,"minute"),MILLISECONDS_IN_MINUTE);case"seconds":case"second":return getDiff(startOfDate(n,"second"),startOfDate(a,"second"),1e3)}}function getDayOfYear(e){return getDateDiff(e,startOfDate(e,"year"),"days")+1}function inferDateFormat(e){return!0===isDate(e)?"date":"number"===typeof e?"number":"string"}function getDateBetween(e,t,o){const n=new Date(e);if(t){const e=new Date(t);if(n<e)return e}if(o){const e=new Date(o);if(n>e)return e}return n}function isSameDate(e,t,o){const n=new Date(e),a=new Date(t);if(void 0===o)return n.getTime()===a.getTime();switch(o){case"second":case"seconds":if(n.getSeconds()!==a.getSeconds())return!1;case"minute":case"minutes":if(n.getMinutes()!==a.getMinutes())return!1;case"hour":case"hours":if(n.getHours()!==a.getHours())return!1;case"day":case"days":case"date":if(n.getDate()!==a.getDate())return!1;case"month":case"months":if(n.getMonth()!==a.getMonth())return!1;case"year":case"years":if(n.getFullYear()!==a.getFullYear())return!1;break;default:throw new Error(`date isSameDate unknown unit ${o}`)}return!0}function daysInMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0).getDate()}function getOrdinal(e){if(e>=11&&e<=13)return`${e}th`;switch(e%10){case 1:return`${e}st`;case 2:return`${e}nd`;case 3:return`${e}rd`}return`${e}th`}const formatter={YY(e,t,o){const n=this.YYYY(e,t,o)%100;return n>0?pad(n):"-"+pad(Math.abs(n))},YYYY(e,t,o){return void 0!==o&&null!==o?o:e.getFullYear()},M(e){return e.getMonth()+1},MM(e){return pad(e.getMonth()+1)},MMM(e,t){return t.monthsShort[e.getMonth()]},MMMM(e,t){return t.months[e.getMonth()]},Q(e){return Math.ceil((e.getMonth()+1)/3)},Qo(e){return getOrdinal(this.Q(e))},D(e){return e.getDate()},Do(e){return getOrdinal(e.getDate())},DD(e){return pad(e.getDate())},DDD(e){return getDayOfYear(e)},DDDD(e){return pad(getDayOfYear(e),3)},d(e){return e.getDay()},dd(e,t){return this.dddd(e,t).slice(0,2)},ddd(e,t){return t.daysShort[e.getDay()]},dddd(e,t){return t.days[e.getDay()]},E(e){return e.getDay()||7},w(e){return getWeekOfYear(e)},ww(e){return pad(getWeekOfYear(e))},H(e){return e.getHours()},HH(e){return pad(e.getHours())},h(e){const t=e.getHours();return 0===t?12:t>12?t%12:t},hh(e){return pad(this.h(e))},m(e){return e.getMinutes()},mm(e){return pad(e.getMinutes())},s(e){return e.getSeconds()},ss(e){return pad(e.getSeconds())},S(e){return Math.floor(e.getMilliseconds()/100)},SS(e){return pad(Math.floor(e.getMilliseconds()/10))},SSS(e){return pad(e.getMilliseconds(),3)},A(e){return this.H(e)<12?"AM":"PM"},a(e){return this.H(e)<12?"am":"pm"},aa(e){return this.H(e)<12?"a.m.":"p.m."},Z(e,t,o,n){const a=void 0===n||null===n?e.getTimezoneOffset():n;return formatTimezone(a,":")},ZZ(e,t,o,n){const a=void 0===n||null===n?e.getTimezoneOffset():n;return formatTimezone(a)},X(e){return Math.floor(e.getTime()/1e3)},x(e){return e.getTime()}};function formatDate(e,t,o,n,a){if(0!==e&&!e||e===1/0||e===-1/0)return;const l=new Date(e);if(isNaN(l))return;void 0===t&&(t=defaultMask);const i=getDateLocale(o,Plugin$8.props);return t.replace(token,(e,t)=>e in formatter?formatter[e](l,i,n,a):void 0===t?e:t.split("\\]").join("]"))}function clone(e){return!0===isDate(e)?new Date(e.getTime()):e}var date={isValid:isValid,extractDate:extractDate,buildDate:buildDate,getDayOfWeek:getDayOfWeek,getWeekOfYear:getWeekOfYear,isBetweenDates:isBetweenDates,addToDate:addToDate,subtractFromDate:subtractFromDate,adjustDate:adjustDate,startOfDate:startOfDate,endOfDate:endOfDate,getMaxDate:getMaxDate,getMinDate:getMinDate,getDateDiff:getDateDiff,getDayOfYear:getDayOfYear,inferDateFormat:inferDateFormat,getDateBetween:getDateBetween,isSameDate:isSameDate,daysInMonth:daysInMonth,formatDate:formatDate,clone:clone};const yearsInterval=20,views=["Calendar","Years","Months"],viewIsValid=e=>views.includes(e),yearMonthValidator=e=>/^-?[\d]+\/[0-1]\d$/.test(e),lineStr=" — ";function getMonthHash(e){return e.year+"/"+pad(e.month)}var QDate=createComponent({name:"QDate",props:{...useDatetimeProps,...useFormProps,...useDarkProps,multiple:Boolean,range:Boolean,title:String,subtitle:String,mask:{default:"YYYY/MM/DD"},defaultYearMonth:{type:String,validator:yearMonthValidator},yearsInMonthView:Boolean,events:[Array,Function],eventColor:[String,Function],emitImmediately:Boolean,options:[Array,Function],navigationMinYearMonth:{type:String,validator:yearMonthValidator},navigationMaxYearMonth:{type:String,validator:yearMonthValidator},noUnset:Boolean,firstDayOfWeek:[String,Number],todayBtn:Boolean,minimal:Boolean,defaultView:{type:String,default:"Calendar",validator:viewIsValid}},emits:[...useDatetimeEmits,"range-start","range-end","navigation"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=useDark(e,a),{getCache:i}=useCache(),{tabindex:r,headerClass:s,getLocale:u,getCurrentDate:c}=useDatetime(e,a);let d;const p=useFormAttrs(e),v=useFormInject(p),m=ref(null),f=ref(de()),g=ref(u()),b=computed(()=>de()),y=computed(()=>u()),S=computed(()=>c()),w=ref(ve(f.value,g.value)),C=ref(e.defaultView),x=!0===a.lang.rtl?"right":"left",k=ref(x.value),_=ref(x.value),q=w.value.year,T=ref(q-q%yearsInterval-(q<0?yearsInterval:0)),P=ref(null),$=computed(()=>{const t=!0===e.landscape?"landscape":"portrait";return`q-date q-date--${t} q-date--${t}-${!0===e.minimal?"minimal":"standard"}`+(!0===l.value?" q-date--dark q-dark":"")+(!0===e.bordered?" q-date--bordered":"")+(!0===e.square?" q-date--square no-border-radius":"")+(!0===e.flat?" q-date--flat no-shadow":"")+(!0===e.disable?" disabled":!0===e.readonly?" q-date--readonly":"")}),M=computed(()=>{return e.color||"primary"}),B=computed(()=>{return e.textColor||"white"}),Q=computed(()=>!0===e.emitImmediately&&!0!==e.multiple&&!0!==e.range),E=computed(()=>!0===Array.isArray(e.modelValue)?e.modelValue:null!==e.modelValue&&void 0!==e.modelValue?[e.modelValue]:[]),O=computed(()=>E.value.filter(e=>"string"===typeof e).map(e=>pe(e,f.value,g.value)).filter(e=>null!==e.dateHash&&null!==e.day&&null!==e.month&&null!==e.year)),R=computed(()=>{const e=e=>pe(e,f.value,g.value);return E.value.filter(e=>Object(e)===e&&void 0!==e.from&&void 0!==e.to).map(t=>({from:e(t.from),to:e(t.to)})).filter(e=>null!==e.from.dateHash&&null!==e.to.dateHash&&e.from.dateHash<e.to.dateHash)}),L=computed(()=>"persian"!==e.calendar?e=>new Date(e.year,e.month-1,e.day):e=>{const t=toGregorian(e.year,e.month,e.day);return new Date(t.gy,t.gm-1,t.gd)}),z=computed(()=>"persian"===e.calendar?getDayHash:(e,t,o)=>formatDate(new Date(e.year,e.month-1,e.day,e.hour,e.minute,e.second,e.millisecond),void 0===t?f.value:t,void 0===o?g.value:o,e.year,e.timezoneOffset)),A=computed(()=>O.value.length+R.value.reduce((e,t)=>e+1+getDateDiff(L.value(t.to),L.value(t.from)),0)),F=computed(()=>{if(void 0!==e.title&&null!==e.title&&e.title.length>0)return e.title;if(null!==P.value){const e=P.value.init,t=L.value(e);return g.value.daysShort[t.getDay()]+", "+g.value.monthsShort[e.month-1]+" "+e.day+lineStr+"?"}if(0===A.value)return lineStr;if(A.value>1)return`${A.value} ${g.value.pluralDay}`;const t=O.value[0],o=L.value(t);return!0===isNaN(o.valueOf())?lineStr:void 0!==g.value.headerTitle?g.value.headerTitle(o,t):g.value.daysShort[o.getDay()]+", "+g.value.monthsShort[t.month-1]+" "+t.day}),D=computed(()=>{const e=O.value.concat(R.value.map(e=>e.from)).sort((e,t)=>e.year-t.year||e.month-t.month);return e[0]}),I=computed(()=>{const e=O.value.concat(R.value.map(e=>e.to)).sort((e,t)=>t.year-e.year||t.month-e.month);return e[0]}),V=computed(()=>{if(void 0!==e.subtitle&&null!==e.subtitle&&e.subtitle.length>0)return e.subtitle;if(0===A.value)return lineStr;if(A.value>1){const e=D.value,t=I.value,o=g.value.monthsShort;return o[e.month-1]+(e.year!==t.year?" "+e.year+lineStr+o[t.month-1]+" ":e.month!==t.month?lineStr+o[t.month-1]:"")+" "+t.year}return O.value[0].year}),N=computed(()=>{const e=[a.iconSet.datetime.arrowLeft,a.iconSet.datetime.arrowRight];return!0===a.lang.rtl?e.reverse():e}),H=computed(()=>void 0!==e.firstDayOfWeek?Number(e.firstDayOfWeek):g.value.firstDayOfWeek),j=computed(()=>{const e=g.value.daysShort,t=H.value;return t>0?e.slice(t,7).concat(e.slice(0,t)):e}),U=computed(()=>{const t=w.value;return"persian"!==e.calendar?new Date(t.year,t.month,0).getDate():jalaaliMonthLength(t.year,t.month)}),K=computed(()=>"function"===typeof e.eventColor?e.eventColor:()=>e.eventColor),W=computed(()=>{if(void 0===e.navigationMinYearMonth)return null;const t=e.navigationMinYearMonth.split("/");return{year:parseInt(t[0],10),month:parseInt(t[1],10)}}),Y=computed(()=>{if(void 0===e.navigationMaxYearMonth)return null;const t=e.navigationMaxYearMonth.split("/");return{year:parseInt(t[0],10),month:parseInt(t[1],10)}}),G=computed(()=>{const e={month:{prev:!0,next:!0},year:{prev:!0,next:!0}};return null!==W.value&&W.value.year>=w.value.year&&(e.year.prev=!1,W.value.year===w.value.year&&W.value.month>=w.value.month&&(e.month.prev=!1)),null!==Y.value&&Y.value.year<=w.value.year&&(e.year.next=!1,Y.value.year===w.value.year&&Y.value.month<=w.value.month&&(e.month.next=!1)),e}),X=computed(()=>{const e={};return O.value.forEach(t=>{const o=getMonthHash(t);void 0===e[o]&&(e[o]=[]),e[o].push(t.day)}),e}),Z=computed(()=>{const e={};return R.value.forEach(t=>{const o=getMonthHash(t.from),n=getMonthHash(t.to);if(void 0===e[o]&&(e[o]=[]),e[o].push({from:t.from.day,to:o===n?t.to.day:void 0,range:t}),o<n){let o;const{year:a,month:l}=t.from,i=l<12?{year:a,month:l+1}:{year:a+1,month:1};while((o=getMonthHash(i))<=n)void 0===e[o]&&(e[o]=[]),e[o].push({from:void 0,to:o===n?t.to.day:void 0,range:t}),i.month++,i.month>12&&(i.year++,i.month=1)}}),e}),J=computed(()=>{if(null===P.value)return;const{init:e,initHash:t,final:o,finalHash:n}=P.value,[a,l]=t<=n?[e,o]:[o,e],i=getMonthHash(a),r=getMonthHash(l);if(i!==ee.value&&r!==ee.value)return;const s={};return i===ee.value?(s.from=a.day,s.includeFrom=!0):s.from=1,r===ee.value?(s.to=l.day,s.includeTo=!0):s.to=U.value,s}),ee=computed(()=>getMonthHash(w.value)),te=computed(()=>{const t={};if(void 0===e.options){for(let e=1;e<=U.value;e++)t[e]=!0;return t}const o="function"===typeof e.options?e.options:t=>e.options.includes(t);for(let e=1;e<=U.value;e++){const n=ee.value+"/"+pad(e);t[e]=o(n)}return t}),oe=computed(()=>{const t={};if(void 0===e.events)for(let e=1;e<=U.value;e++)t[e]=!1;else{const o="function"===typeof e.events?e.events:t=>e.events.includes(t);for(let e=1;e<=U.value;e++){const n=ee.value+"/"+pad(e);t[e]=!0===o(n)&&K.value(n)}}return t}),ne=computed(()=>{let t,o;const{year:n,month:a}=w.value;if("persian"!==e.calendar)t=new Date(n,a-1,1),o=new Date(n,a-1,0).getDate();else{const e=toGregorian(n,a,1);t=new Date(e.gy,e.gm-1,e.gd);let l=a-1,i=n;0===l&&(l=12,i--),o=jalaaliMonthLength(i,l)}return{days:t.getDay()-H.value-1,endDay:o}}),ae=computed(()=>{const e=[],{days:t,endDay:o}=ne.value,n=t<0?t+7:t;if(n<6)for(let i=o-n;i<=o;i++)e.push({i:i,fill:!0});const a=e.length;for(let i=1;i<=U.value;i++){const t={i:i,event:oe.value[i],classes:[]};!0===te.value[i]&&(t.in=!0,t.flat=!0),e.push(t)}if(void 0!==X.value[ee.value]&&X.value[ee.value].forEach(t=>{const o=a+t-1;Object.assign(e[o],{selected:!0,unelevated:!0,flat:!1,color:M.value,textColor:B.value})}),void 0!==Z.value[ee.value]&&Z.value[ee.value].forEach(t=>{if(void 0!==t.from){const o=a+t.from-1,n=a+(t.to||U.value)-1;for(let a=o;a<=n;a++)Object.assign(e[a],{range:t.range,unelevated:!0,color:M.value,textColor:B.value});Object.assign(e[o],{rangeFrom:!0,flat:!1}),void 0!==t.to&&Object.assign(e[n],{rangeTo:!0,flat:!1})}else if(void 0!==t.to){const o=a+t.to-1;for(let n=a;n<=o;n++)Object.assign(e[n],{range:t.range,unelevated:!0,color:M.value,textColor:B.value});Object.assign(e[o],{flat:!1,rangeTo:!0})}else{const o=a+U.value-1;for(let n=a;n<=o;n++)Object.assign(e[n],{range:t.range,unelevated:!0,color:M.value,textColor:B.value})}}),void 0!==J.value){const t=a+J.value.from-1,o=a+J.value.to-1;for(let n=t;n<=o;n++)e[n].color=M.value,e[n].editRange=!0;!0===J.value.includeFrom&&(e[t].editRangeFrom=!0),!0===J.value.includeTo&&(e[o].editRangeTo=!0)}w.value.year===S.value.year&&w.value.month===S.value.month&&(e[a+S.value.day-1].today=!0);const l=e.length%7;if(l>0){const t=7-l;for(let o=1;o<=t;o++)e.push({i:o,fill:!0})}return e.forEach(e=>{let t="q-date__calendar-item ";!0===e.fill?t+="q-date__calendar-item--fill":(t+=`q-date__calendar-item--${!0===e.in?"in":"out"}`,void 0!==e.range&&(t+=` q-date__range${!0===e.rangeTo?"-to":!0===e.rangeFrom?"-from":""}`),!0===e.editRange&&(t+=` q-date__edit-range${!0===e.editRangeFrom?"-from":""}${!0===e.editRangeTo?"-to":""}`),void 0===e.range&&!0!==e.editRange||(t+=` text-${e.color}`)),e.classes=t}),e}),le=computed(()=>!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{});function ie(){const e=S.value,t=X.value[getMonthHash(e)];void 0!==t&&!1!==t.includes(e.day)||qe(e),ue(e.year,e.month)}function re(e){!0===viewIsValid(e)&&(C.value=e)}function se(e,t){if(["month","year"].includes(e)){const o="month"===e?fe:he;o(!0===t?-1:1)}}function ue(e,t){C.value="Calendar",we(e,t)}function ce(t,o){if(!1===e.range||!t)return void(P.value=null);const n=Object.assign({...w.value},t),a=void 0!==o?Object.assign({...w.value},o):n;P.value={init:n,initHash:getDayHash(n),final:a,finalHash:getDayHash(a)},ue(n.year,n.month)}function de(){return"persian"===e.calendar?"YYYY/MM/DD":e.mask}function pe(t,o,n){return __splitDate(t,o,n,e.calendar,{hour:0,minute:0,second:0,millisecond:0})}function ve(t,o){const n=!0===Array.isArray(e.modelValue)?e.modelValue:e.modelValue?[e.modelValue]:[];if(0===n.length)return me();const a=n[n.length-1],l=pe(void 0!==a.from?a.from:a,t,o);return null===l.dateHash?me():l}function me(){let t,o;if(void 0!==e.defaultYearMonth){const n=e.defaultYearMonth.split("/");t=parseInt(n[0],10),o=parseInt(n[1],10)}else{const e=void 0!==S.value?S.value:c();t=e.year,o=e.month}return{year:t,month:o,day:1,hour:0,minute:0,second:0,millisecond:0,dateHash:t+"/"+pad(o)+"/01"}}function fe(e){let t=w.value.year,o=Number(w.value.month)+e;13===o?(o=1,t++):0===o&&(o=12,t--),we(t,o),!0===Q.value&&xe("month")}function he(e){const t=Number(w.value.year)+e;we(t,w.value.month),!0===Q.value&&xe("year")}function ge(t){we(t,w.value.month),C.value="Years"===e.defaultView?"Months":"Calendar",!0===Q.value&&xe("year")}function be(e){we(w.value.year,e),C.value="Calendar",!0===Q.value&&xe("month")}function ye(e,t){const o=X.value[t],n=void 0!==o&&!0===o.includes(e.day)?Te:qe;n(e)}function Se(e){return{year:e.year,month:e.month,day:e.day}}function we(e,t){null!==W.value&&e<=W.value.year&&(e=W.value.year,t<W.value.month&&(t=W.value.month)),null!==Y.value&&e>=Y.value.year&&(e=Y.value.year,t>Y.value.month&&(t=Y.value.month));const o=e+"/"+pad(t)+"/01";o!==w.value.dateHash&&(k.value=w.value.dateHash<o===(!0!==a.lang.rtl)?"left":"right",e!==w.value.year&&(_.value=k.value),nextTick(()=>{T.value=e-e%yearsInterval-(e<0?yearsInterval:0),Object.assign(w.value,{year:e,month:t,day:1,dateHash:o})}))}function Ce(t,n,a){const l=null!==t&&1===t.length&&!1===e.multiple?t[0]:t;d=l;const{reason:i,details:r}=ke(n,a);o("update:modelValue",l,i,r)}function xe(t){const n=void 0!==O.value[0]&&null!==O.value[0].dateHash?{...O.value[0]}:{...w.value};nextTick(()=>{n.year=w.value.year,n.month=w.value.month;const a="persian"!==e.calendar?new Date(n.year,n.month,0).getDate():jalaaliMonthLength(n.year,n.month);n.day=Math.min(Math.max(1,n.day),a);const l=_e(n);d=l;const{details:i}=ke("",n);o("update:modelValue",l,t,i)})}function ke(e,t){return void 0!==t.from?{reason:`${e}-range`,details:{...Se(t.target),from:Se(t.from),to:Se(t.to)}}:{reason:`${e}-day`,details:Se(t)}}function _e(e,t,o){return void 0!==e.from?{from:z.value(e.from,t,o),to:z.value(e.to,t,o)}:z.value(e,t,o)}function qe(t){let o;if(!0===e.multiple)if(void 0!==t.from){const e=getDayHash(t.from),n=getDayHash(t.to),a=O.value.filter(t=>t.dateHash<e||t.dateHash>n),l=R.value.filter(({from:t,to:o})=>o.dateHash<e||t.dateHash>n);o=a.concat(l).concat(t).map(e=>_e(e))}else{const e=E.value.slice();e.push(_e(t)),o=e}else o=_e(t);Ce(o,"add",t)}function Te(t){if(!0===e.noUnset)return;let o=null;if(!0===e.multiple&&!0===Array.isArray(e.modelValue)){const n=_e(t);o=void 0!==t.from?e.modelValue.filter(e=>void 0===e.from||e.from!==n.from&&e.to!==n.to):e.modelValue.filter(e=>e!==n),0===o.length&&(o=null)}Ce(o,"remove",t)}function Pe(t,n,a){const l=O.value.concat(R.value).map(e=>_e(e,t,n)).filter(e=>{return void 0!==e.from?null!==e.from.dateHash&&null!==e.to.dateHash:null!==e.dateHash});o("update:modelValue",(!0===e.multiple?l:l[0])||null,a)}function $e(){if(!0!==e.minimal)return h("div",{class:"q-date__header "+s.value},[h("div",{class:"relative-position"},[h(Transition,{name:"q-transition--fade"},()=>h("div",{key:"h-yr-"+V.value,class:"q-date__header-subtitle q-date__header-link "+("Years"===C.value?"q-date__header-link--active":"cursor-pointer"),tabindex:r.value,...i("vY",{onClick(){C.value="Years"},onKeyup(e){13===e.keyCode&&(C.value="Years")}})},[V.value]))]),h("div",{class:"q-date__header-title relative-position flex no-wrap"},[h("div",{class:"relative-position col"},[h(Transition,{name:"q-transition--fade"},()=>h("div",{key:"h-sub"+F.value,class:"q-date__header-title-label q-date__header-link "+("Calendar"===C.value?"q-date__header-link--active":"cursor-pointer"),tabindex:r.value,...i("vC",{onClick(){C.value="Calendar"},onKeyup(e){13===e.keyCode&&(C.value="Calendar")}})},[F.value]))]),!0===e.todayBtn?h(QBtn,{class:"q-date__header-today self-start",icon:a.iconSet.datetime.today,flat:!0,size:"sm",round:!0,tabindex:r.value,onClick:ie}):null])])}function Me({label:e,type:t,key:o,dir:n,goTo:a,boundaries:l,cls:s}){return[h("div",{class:"row items-center q-date__arrow"},[h(QBtn,{round:!0,dense:!0,size:"sm",flat:!0,icon:N.value[0],tabindex:r.value,disable:!1===l.prev,...i("go-#"+t,{onClick(){a(-1)}})})]),h("div",{class:"relative-position overflow-hidden flex flex-center"+s},[h(Transition,{name:"q-transition--jump-"+n},()=>h("div",{key:o},[h(QBtn,{flat:!0,dense:!0,noCaps:!0,label:e,tabindex:r.value,...i("view#"+t,{onClick:()=>{C.value=t}})})]))]),h("div",{class:"row items-center q-date__arrow"},[h(QBtn,{round:!0,dense:!0,size:"sm",flat:!0,icon:N.value[1],tabindex:r.value,disable:!1===l.next,...i("go+#"+t,{onClick(){a(1)}})})])]}watch(()=>e.modelValue,e=>{if(d===e)d=0;else{const{year:e,month:t}=ve(f.value,g.value);we(e,t)}}),watch(C,()=>{null!==m.value&&m.value.focus()}),watch(()=>w.value.year,e=>{o("navigation",{year:e,month:w.value.month})}),watch(()=>w.value.month,e=>{o("navigation",{year:w.value.year,month:e})}),watch(b,e=>{Pe(e,g.value,"mask"),f.value=e}),watch(y,e=>{Pe(f.value,e,"locale"),g.value=e}),Object.assign(n,{setToday:ie,setView:re,offsetCalendar:se,setCalendarTo:ue,setEditingRange:ce});const Be={Calendar:()=>[h("div",{key:"calendar-view",class:"q-date__view q-date__calendar"},[h("div",{class:"q-date__navigation row items-center no-wrap"},Me({label:g.value.months[w.value.month-1],type:"Months",key:w.value.month,dir:k.value,goTo:fe,boundaries:G.value.month,cls:" col"}).concat(Me({label:w.value.year,type:"Years",key:w.value.year,dir:_.value,goTo:he,boundaries:G.value.year,cls:""}))),h("div",{class:"q-date__calendar-weekdays row items-center no-wrap"},j.value.map(e=>h("div",{class:"q-date__calendar-item"},[h("div",e)]))),h("div",{class:"q-date__calendar-days-container relative-position overflow-hidden"},[h(Transition,{name:"q-transition--slide-"+k.value},()=>h("div",{key:ee.value,class:"q-date__calendar-days fit"},ae.value.map(e=>h("div",{class:e.classes},[!0===e.in?h(QBtn,{class:!0===e.today?"q-date__today":"",dense:!0,flat:e.flat,unelevated:e.unelevated,color:e.color,textColor:e.textColor,label:e.i,tabindex:r.value,...i("day#"+e.i,{onClick:()=>{Qe(e.i)},onMouseover:()=>{Ee(e.i)}})},!1!==e.event?()=>h("div",{class:"q-date__event bg-"+e.event}):null):h("div",""+e.i)]))))])])],Months(){const t=w.value.year===S.value.year,o=e=>{return null!==W.value&&w.value.year===W.value.year&&W.value.month>e||null!==Y.value&&w.value.year===Y.value.year&&Y.value.month<e},n=g.value.monthsShort.map((e,n)=>{const a=w.value.month===n+1;return h("div",{class:"q-date__months-item flex flex-center"},[h(QBtn,{class:!0===t&&S.value.month===n+1?"q-date__today":null,flat:!0!==a,label:e,unelevated:a,color:!0===a?M.value:null,textColor:!0===a?B.value:null,tabindex:r.value,disable:o(n+1),...i("month#"+n,{onClick:()=>{be(n+1)}})})])});return!0===e.yearsInMonthView&&n.unshift(h("div",{class:"row no-wrap full-width"},[Me({label:w.value.year,type:"Years",key:w.value.year,dir:_.value,goTo:he,boundaries:G.value.year,cls:" col"})])),h("div",{key:"months-view",class:"q-date__view q-date__months flex flex-center"},n)},Years(){const e=T.value,t=e+yearsInterval,o=[],n=e=>{return null!==W.value&&W.value.year>e||null!==Y.value&&Y.value.year<e};for(let a=e;a<=t;a++){const e=w.value.year===a;o.push(h("div",{class:"q-date__years-item flex flex-center"},[h(QBtn,{key:"yr"+a,class:S.value.year===a?"q-date__today":null,flat:!e,label:a,dense:!0,unelevated:e,color:!0===e?M.value:null,textColor:!0===e?B.value:null,tabindex:r.value,disable:n(a),...i("yr#"+a,{onClick:()=>{ge(a)}})})]))}return h("div",{class:"q-date__view q-date__years flex flex-center"},[h("div",{class:"col-auto"},[h(QBtn,{round:!0,dense:!0,flat:!0,icon:N.value[0],tabindex:r.value,disable:n(e),...i("y-",{onClick:()=>{T.value-=yearsInterval}})})]),h("div",{class:"q-date__years-content col self-stretch row items-center"},o),h("div",{class:"col-auto"},[h(QBtn,{round:!0,dense:!0,flat:!0,icon:N.value[1],tabindex:r.value,disable:n(t),...i("y+",{onClick:()=>{T.value+=yearsInterval}})})])])}};function Qe(t){const n={...w.value,day:t};if(!1!==e.range)if(null===P.value){const a=ae.value.find(e=>!0!==e.fill&&e.i===t);if(!0!==e.noUnset&&void 0!==a.range)return void Te({target:n,from:a.range.from,to:a.range.to});if(!0===a.selected)return void Te(n);const l=getDayHash(n);P.value={init:n,initHash:l,final:n,finalHash:l},o("range-start",Se(n))}else{const e=P.value.initHash,t=getDayHash(n),a=e<=t?{from:P.value.init,to:n}:{from:n,to:P.value.init};P.value=null,qe(e===t?n:{target:n,...a}),o("range-end",{from:Se(a.from),to:Se(a.to)})}else ye(n,ee.value)}function Ee(e){if(null!==P.value){const t={...w.value,day:e};Object.assign(P.value,{final:t,finalHash:getDayHash(t)})}}return()=>{const o=[h("div",{class:"q-date__content col relative-position"},[h(Transition,{name:"q-transition--fade"},Be[C.value])])],n=hSlot(t.default);return void 0!==n&&o.push(h("div",{class:"q-date__actions"},n)),void 0!==e.name&&!0!==e.disable&&v(o,"push"),h("div",{class:$.value,...le.value},[$e(),h("div",{ref:m,class:"q-date__main col column",tabindex:-1},o)])}}});function useHistory(e,t,o){let n;function a(){void 0!==n&&(History.remove(n),n=void 0)}return onBeforeUnmount(()=>{!0===e.value&&a()}),{removeFromHistory:a,addToHistory(){n={condition:()=>!0===o.value,handler:t},History.add(n)}}}let scrollPositionX,scrollPositionY,maxScrollTop,bodyLeft,bodyTop,closeTimer,registered=0,vpPendingUpdate=!1;function onWheel(e){shouldPreventScroll(e)&&stopAndPrevent(e)}function shouldPreventScroll(e){if(e.target===document.body||e.target.classList.contains("q-layout__backdrop"))return!0;const t=getEventPath(e),o=e.shiftKey&&!e.deltaX,n=!o&&Math.abs(e.deltaX)<=Math.abs(e.deltaY),a=o||n?e.deltaY:e.deltaX;for(let l=0;l<t.length;l++){const e=t[l];if(hasScrollbar(e,n))return n?a<0&&0===e.scrollTop||a>0&&e.scrollTop+e.clientHeight===e.scrollHeight:a<0&&0===e.scrollLeft||a>0&&e.scrollLeft+e.clientWidth===e.scrollWidth}return!0}function onAppleScroll(e){e.target===document&&(document.scrollingElement.scrollTop=document.scrollingElement.scrollTop)}function onAppleResize(e){!0!==vpPendingUpdate&&(vpPendingUpdate=!0,requestAnimationFrame(()=>{vpPendingUpdate=!1;const{height:t}=e.target,{clientHeight:o,scrollTop:n}=document.scrollingElement;void 0!==maxScrollTop&&t===window.innerHeight||(maxScrollTop=o-t,document.scrollingElement.scrollTop=n),n>maxScrollTop&&(document.scrollingElement.scrollTop-=Math.ceil((n-maxScrollTop)/8))}))}function apply$1(e){const t=document.body,o=void 0!==window.visualViewport;if("add"===e){const{overflowY:e,overflowX:n}=window.getComputedStyle(t);scrollPositionX=getHorizontalScrollPosition(window),scrollPositionY=getVerticalScrollPosition(window),bodyLeft=t.style.left,bodyTop=t.style.top,t.style.left=`-${scrollPositionX}px`,t.style.top=`-${scrollPositionY}px`,"hidden"!==n&&("scroll"===n||t.scrollWidth>window.innerWidth)&&t.classList.add("q-body--force-scrollbar-x"),"hidden"!==e&&("scroll"===e||t.scrollHeight>window.innerHeight)&&t.classList.add("q-body--force-scrollbar-y"),t.classList.add("q-body--prevent-scroll"),document.qScrollPrevented=!0,!0===client.is.ios&&(!0===o?(window.scrollTo(0,0),window.visualViewport.addEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.addEventListener("scroll",onAppleResize,listenOpts.passiveCapture),window.scrollTo(0,0)):window.addEventListener("scroll",onAppleScroll,listenOpts.passiveCapture))}!0===client.is.desktop&&!0===client.is.mac&&window[`${e}EventListener`]("wheel",onWheel,listenOpts.notPassive),"remove"===e&&(!0===client.is.ios&&(!0===o?(window.visualViewport.removeEventListener("resize",onAppleResize,listenOpts.passiveCapture),window.visualViewport.removeEventListener("scroll",onAppleResize,listenOpts.passiveCapture)):window.removeEventListener("scroll",onAppleScroll,listenOpts.passiveCapture)),t.classList.remove("q-body--prevent-scroll"),t.classList.remove("q-body--force-scrollbar-x"),t.classList.remove("q-body--force-scrollbar-y"),document.qScrollPrevented=!1,t.style.left=bodyLeft,t.style.top=bodyTop,window.scrollTo(scrollPositionX,scrollPositionY),maxScrollTop=void 0)}function preventScroll(e){let t="add";if(!0===e){if(registered++,void 0!==closeTimer)return clearTimeout(closeTimer),void(closeTimer=void 0);if(registered>1)return}else{if(0===registered)return;if(registered--,registered>0)return;if(t="remove",!0===client.is.ios&&!0===client.is.nativeMobile)return clearTimeout(closeTimer),void(closeTimer=setTimeout(()=>{apply$1(t),closeTimer=void 0},100))}apply$1(t)}function usePreventScroll(){let e;return{preventBodyScroll(t){t===e||void 0===e&&!0!==t||(e=t,preventScroll(t))}}}let maximizedModals=0;const positionClass$1={standard:"fixed-full flex-center",top:"fixed-top justify-center",bottom:"fixed-bottom justify-center",right:"fixed-right items-center",left:"fixed-left items-center"},transitions={standard:["scale","scale"],top:["slide-down","slide-up"],bottom:["slide-up","slide-down"],right:["slide-left","slide-right"],left:["slide-right","slide-left"]};var QDialog=createComponent({name:"QDialog",inheritAttrs:!1,props:{...useModelToggleProps,...useTransitionProps,transitionShow:String,transitionHide:String,persistent:Boolean,autoClose:Boolean,noEscDismiss:Boolean,noBackdropDismiss:Boolean,noRouteDismiss:Boolean,noRefocus:Boolean,noFocus:Boolean,noShake:Boolean,seamless:Boolean,maximized:Boolean,fullWidth:Boolean,fullHeight:Boolean,square:Boolean,position:{type:String,default:"standard",validator:e=>"standard"===e||["top","bottom","left","right"].includes(e)}},emits:[...useModelToggleEmits,"shake","click","escape-key"],setup(e,{slots:t,emit:o,attrs:n}){const a=getCurrentInstance(),l=ref(null),i=ref(!1),r=ref(!1),s=ref(!1);let u,c,d,p=null;const v=computed(()=>!0!==e.persistent&&!0!==e.noRouteDismiss&&!0!==e.seamless),{preventBodyScroll:m}=usePreventScroll(),{registerTimeout:f,removeTimeout:g}=useTimeout(),{registerTick:b,removeTick:y}=useTick(),{showPortal:S,hidePortal:w,portalIsActive:C,renderPortal:x}=usePortal(a,l,j,!0),{hide:k}=useModelToggle({showing:i,hideOnRouteChange:v,handleShow:R,handleHide:L,processOnMount:!0}),{addToHistory:_,removeFromHistory:q}=useHistory(i,k,v),T=computed(()=>"q-dialog__inner flex no-pointer-events"+` q-dialog__inner--${!0===e.maximized?"maximized":"minimized"}`+` q-dialog__inner--${e.position} ${positionClass$1[e.position]}`+(!0===s.value?" q-dialog__inner--animating":"")+(!0===e.fullWidth?" q-dialog__inner--fullwidth":"")+(!0===e.fullHeight?" q-dialog__inner--fullheight":"")+(!0===e.square?" q-dialog__inner--square":"")),P=computed(()=>"q-transition--"+(void 0===e.transitionShow?transitions[e.position][0]:e.transitionShow)),$=computed(()=>"q-transition--"+(void 0===e.transitionHide?transitions[e.position][1]:e.transitionHide)),M=computed(()=>!0===r.value?$.value:P.value),B=computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`),Q=computed(()=>!0===i.value&&!0!==e.seamless),E=computed(()=>!0===e.autoClose?{onClick:V}:{}),O=computed(()=>["q-dialog fullscreen no-pointer-events "+`q-dialog--${!0===Q.value?"modal":"seamless"}`,n.class]);function R(t){g(),y(),_(),p=!1===e.noRefocus&&null!==document.activeElement?document.activeElement:null,I(e.maximized),S(),s.value=!0,!0!==e.noFocus&&(null!==document.activeElement&&document.activeElement.blur(),b(z)),f(()=>{if(!0===a.proxy.$q.platform.is.ios){if(!0!==e.seamless&&document.activeElement){const{top:e,bottom:t}=document.activeElement.getBoundingClientRect(),{innerHeight:o}=window,n=void 0!==window.visualViewport?window.visualViewport.height:o;e>0&&t>n/2&&(document.scrollingElement.scrollTop=Math.min(document.scrollingElement.scrollHeight-n,t>=o?1/0:Math.ceil(document.scrollingElement.scrollTop+t-n/2))),document.activeElement.scrollIntoView()}d=!0,l.value.click(),d=!1}S(!0),s.value=!1,o("show",t)},e.transitionDuration)}function L(t){g(),y(),q(),D(!0),s.value=!0,null!==p&&(p.focus(),p=null),f(()=>{w(),s.value=!1,o("hide",t)},e.transitionDuration)}function z(){addFocusFn(()=>{let e=l.value;null!==e&&!0!==e.contains(document.activeElement)&&(e=e.querySelector("[autofocus], [data-autofocus]")||e,e.focus({preventScroll:!0}))})}function A(){z(),o("shake");const e=l.value;null!==e&&(e.classList.remove("q-animate--scale"),e.classList.add("q-animate--scale"),clearTimeout(u),u=setTimeout(()=>{null!==l.value&&(e.classList.remove("q-animate--scale"),z())},170))}function F(){!0!==e.seamless&&(!0===e.persistent||!0===e.noEscDismiss?!0!==e.maximized&&!0!==e.noShake&&A():(o("escape-key"),k()))}function D(t){clearTimeout(u),!0!==t&&!0!==i.value||(I(!1),!0!==e.seamless&&(m(!1),removeFocusout(H),removeEscapeKey(F))),!0!==t&&(p=null)}function I(e){!0===e?!0!==c&&(maximizedModals<1&&document.body.classList.add("q-body--dialog"),maximizedModals++,c=!0):!0===c&&(maximizedModals<2&&document.body.classList.remove("q-body--dialog"),maximizedModals--,c=!1)}function V(e){!0!==d&&(k(e),o("click",e))}function N(t){!0!==e.persistent&&!0!==e.noBackdropDismiss?k(t):!0!==e.noShake&&A()}function H(e){!0===i.value&&!0===C.value&&!0!==childHasFocus(l.value,e.target)&&z()}function j(){return h("div",{...n,class:O.value},[h(Transition,{name:"q-transition--fade",appear:!0},()=>!0===Q.value?h("div",{class:"q-dialog__backdrop fixed-full",style:B.value,"aria-hidden":"true",onMousedown:N}):null),h(Transition,{name:M.value,appear:!0},()=>!0===i.value?h("div",{ref:l,class:T.value,style:B.value,tabindex:-1,...E.value},hSlot(t.default)):null)])}return watch(i,e=>{nextTick(()=>{r.value=e})}),watch(()=>e.maximized,e=>{!0===i.value&&I(e)}),watch(Q,e=>{m(e),!0===e?(addFocusout(H),addEscapeKey(F)):(removeFocusout(H),removeEscapeKey(F))}),Object.assign(a.proxy,{focus:z,shake:A,__updateRefocusTarget(e){p=e||null}}),onBeforeUnmount(D),x}});const duration=150;var QDrawer=createComponent({name:"QDrawer",inheritAttrs:!1,props:{...useModelToggleProps,...useDarkProps,side:{type:String,default:"left",validator:e=>["left","right"].includes(e)},width:{type:Number,default:300},mini:Boolean,miniToOverlay:Boolean,miniWidth:{type:Number,default:57},breakpoint:{type:Number,default:1023},showIfAbove:Boolean,behavior:{type:String,validator:e=>["default","desktop","mobile"].includes(e),default:"default"},bordered:Boolean,elevated:Boolean,overlay:Boolean,persistent:Boolean,noSwipeOpen:Boolean,noSwipeClose:Boolean,noSwipeBackdrop:Boolean},emits:[...useModelToggleEmits,"on-layout","mini-state"],setup(e,{slots:t,emit:o,attrs:n}){const a=getCurrentInstance(),{proxy:{$q:l}}=a,i=useDark(e,l),{preventBodyScroll:r}=usePreventScroll(),{registerTimeout:s}=useTimeout(),u=inject(layoutKey,()=>{console.error("QDrawer needs to be child of QLayout")});let c,d,p;const v=ref("mobile"===e.behavior||"desktop"!==e.behavior&&u.totalWidth.value<=e.breakpoint),m=computed(()=>!0===e.mini&&!0!==v.value),f=computed(()=>!0===m.value?e.miniWidth:e.width),g=ref(!0===e.showIfAbove&&!1===v.value||!0===e.modelValue),b=computed(()=>!0!==e.persistent&&(!0===v.value||!0===L.value));function y(e,t){if(x(),!1!==e&&u.animate(),Y(0),!0===v.value){const e=u.instances[Q.value];void 0!==e&&!0===e.belowBreakpoint&&e.hide(!1),G(1),!0!==u.isContainer.value&&r(!0)}else G(0),!1!==e&&X(!1);s(()=>{!1!==e&&X(!0),!0!==t&&o("show",e)},duration)}function S(e,t){k(),!1!==e&&u.animate(),G(0),Y(T.value*f.value),te(),!0!==t&&s(()=>{o("hide",e)},duration)}const{show:w,hide:C}=useModelToggle({showing:g,hideOnRouteChange:b,handleShow:y,handleHide:S}),{addToHistory:x,removeFromHistory:k}=useHistory(g,C,b),_={belowBreakpoint:v,hide:C},q=computed(()=>"right"===e.side),T=computed(()=>(!0===l.lang.rtl?-1:1)*(!0===q.value?1:-1)),P=ref(0),$=ref(!1),M=ref(!1),B=ref(f.value*T.value),Q=computed(()=>!0===q.value?"left":"right"),E=computed(()=>!0===g.value&&!1===v.value&&!1===e.overlay?!0===e.miniToOverlay?e.miniWidth:f.value:0),O=computed(()=>!0===e.overlay||!0===e.miniToOverlay||u.view.value.indexOf(q.value?"R":"L")>-1||!0===l.platform.is.ios&&!0===u.isContainer.value),R=computed(()=>!1===e.overlay&&!0===g.value&&!1===v.value),L=computed(()=>!0===e.overlay&&!0===g.value&&!1===v.value),z=computed(()=>"fullscreen q-drawer__backdrop"+(!1===g.value&&!1===$.value?" hidden":"")),A=computed(()=>({backgroundColor:`rgba(0,0,0,${.4*P.value})`})),F=computed(()=>!0===q.value?"r"===u.rows.value.top[2]:"l"===u.rows.value.top[0]),D=computed(()=>!0===q.value?"r"===u.rows.value.bottom[2]:"l"===u.rows.value.bottom[0]),I=computed(()=>{const e={};return!0===u.header.space&&!1===F.value&&(!0===O.value?e.top=`${u.header.offset}px`:!0===u.header.space&&(e.top=`${u.header.size}px`)),!0===u.footer.space&&!1===D.value&&(!0===O.value?e.bottom=`${u.footer.offset}px`:!0===u.footer.space&&(e.bottom=`${u.footer.size}px`)),e}),V=computed(()=>{const e={width:`${f.value}px`,transform:`translateX(${B.value}px)`};return!0===v.value?e:Object.assign(e,I.value)}),N=computed(()=>"q-drawer__content fit "+(!0!==u.isContainer.value?"scroll":"overflow-auto")),H=computed(()=>`q-drawer q-drawer--${e.side}`+(!0===M.value?" q-drawer--mini-animate":"")+(!0===e.bordered?" q-drawer--bordered":"")+(!0===i.value?" q-drawer--dark q-dark":"")+(!0===$.value?" no-transition":!0===g.value?"":" q-layout--prevent-focus")+(!0===v.value?" fixed q-drawer--on-top q-drawer--mobile q-drawer--top-padding":` q-drawer--${!0===m.value?"mini":"standard"}`+(!0===O.value||!0!==R.value?" fixed":"")+(!0===e.overlay||!0===e.miniToOverlay?" q-drawer--on-top":"")+(!0===F.value?" q-drawer--top-padding":""))),j=computed(()=>{const t=!0===l.lang.rtl?e.side:Q.value;return[[TouchPan,J,void 0,{[t]:!0,mouse:!0}]]}),U=computed(()=>{const t=!0===l.lang.rtl?Q.value:e.side;return[[TouchPan,ee,void 0,{[t]:!0,mouse:!0}]]}),K=computed(()=>{const t=!0===l.lang.rtl?Q.value:e.side;return[[TouchPan,ee,void 0,{[t]:!0,mouse:!0,mouseAllDir:!0}]]});function W(){ne(v,"mobile"===e.behavior||"desktop"!==e.behavior&&u.totalWidth.value<=e.breakpoint)}function Y(e){void 0===e?nextTick(()=>{e=!0===g.value?0:f.value,Y(T.value*e)}):(!0!==u.isContainer.value||!0!==q.value||!0!==v.value&&Math.abs(e)!==f.value||(e+=T.value*u.scrollbarWidth.value),B.value=e)}function G(e){P.value=e}function X(e){const t=!0===e?"remove":!0!==u.isContainer.value?"add":"";""!==t&&document.body.classList[t]("q-body--drawer-toggle")}function Z(){clearTimeout(d),a.proxy&&a.proxy.$el&&a.proxy.$el.classList.add("q-drawer--mini-animate"),M.value=!0,d=setTimeout(()=>{M.value=!1,a&&a.proxy&&a.proxy.$el&&a.proxy.$el.classList.remove("q-drawer--mini-animate")},150)}function J(e){if(!1!==g.value)return;const t=f.value,o=between(e.distance.x,0,t);if(!0===e.isFinal){const e=o>=Math.min(75,t);return!0===e?w():(u.animate(),G(0),Y(T.value*t)),void($.value=!1)}Y((!0===l.lang.rtl?!0!==q.value:q.value)?Math.max(t-o,0):Math.min(0,o-t)),G(between(o/t,0,1)),!0===e.isFirst&&($.value=!0)}function ee(t){if(!0!==g.value)return;const o=f.value,n=t.direction===e.side,a=(!0===l.lang.rtl?!0!==n:n)?between(t.distance.x,0,o):0;if(!0===t.isFinal){const e=Math.abs(a)<Math.min(75,o);return!0===e?(u.animate(),G(1),Y(0)):C(),void($.value=!1)}Y(T.value*a),G(between(1-a/o,0,1)),!0===t.isFirst&&($.value=!0)}function te(){r(!1),X(!0)}function oe(t,o){u.update(e.side,t,o)}function ne(e,t){e.value!==t&&(e.value=t)}function ae(t,o){oe("size",!0===t?e.miniWidth:o)}return watch(v,t=>{!0===t?(c=g.value,!0===g.value&&C(!1)):!1===e.overlay&&"mobile"!==e.behavior&&!1!==c&&(!0===g.value?(Y(0),G(0),te()):w(!1))}),watch(()=>e.side,(e,t)=>{u.instances[t]===_&&(u.instances[t]=void 0,u[t].space=!1,u[t].offset=0),u.instances[e]=_,u[e].size=f.value,u[e].space=R.value,u[e].offset=E.value}),watch(u.totalWidth,()=>{!0!==u.isContainer.value&&!0===document.qScrollPrevented||W()}),watch(()=>e.behavior+e.breakpoint,W),watch(u.isContainer,e=>{!0===g.value&&r(!0!==e),!0===e&&W()}),watch(u.scrollbarWidth,()=>{Y(!0===g.value?0:void 0)}),watch(E,e=>{oe("offset",e)}),watch(R,e=>{o("on-layout",e),oe("space",e)}),watch(q,()=>{Y()}),watch(f,t=>{Y(),ae(e.miniToOverlay,t)}),watch(()=>e.miniToOverlay,e=>{ae(e,f.value)}),watch(()=>l.lang.rtl,()=>{Y()}),watch(()=>e.mini,()=>{!0===e.modelValue&&(Z(),u.animate())}),watch(m,e=>{o("mini-state",e)}),u.instances[e.side]=_,ae(e.miniToOverlay,f.value),oe("space",R.value),oe("offset",E.value),!0===e.showIfAbove&&!0!==e.modelValue&&!0===g.value&&void 0!==e["onUpdate:modelValue"]&&o("update:modelValue",!0),onMounted(()=>{o("on-layout",R.value),o("mini-state",m.value),c=!0===e.showIfAbove;const t=()=>{const e=!0===g.value?y:S;e(!1,!0)};0===u.totalWidth.value?p=watch(u.totalWidth,()=>{p(),p=void 0,!1===g.value&&!0===e.showIfAbove&&!1===v.value?w(!1):t()}):nextTick(t)}),onBeforeUnmount(()=>{void 0!==p&&p(),clearTimeout(d),!0===g.value&&te(),u.instances[e.side]===_&&(u.instances[e.side]=void 0,oe("size",0),oe("offset",0),oe("space",!1))}),()=>{const o=[];!0===v.value&&(!1===e.noSwipeOpen&&o.push(withDirectives(h("div",{key:"open",class:`q-drawer__opener fixed-${e.side}`,"aria-hidden":"true"}),j.value)),o.push(hDir("div",{ref:"backdrop",class:z.value,style:A.value,"aria-hidden":"true",onClick:C},void 0,"backdrop",!0!==e.noSwipeBackdrop&&!0===g.value,()=>K.value)));const a=!0===m.value&&void 0!==t.mini,l=[h("div",{...n,key:""+a,class:[N.value,n.class]},!0===a?t.mini():hSlot(t.default))];return!0===e.elevated&&!0===g.value&&l.push(h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),o.push(hDir("aside",{ref:"content",class:H.value,style:V.value},l,"contentclose",!0!==e.noSwipeClose&&!0===v.value,()=>U.value)),h("div",{class:"q-drawer-container"},o)}}});function getBlockElement(e,t){if(t&&e===t)return null;const o=e.nodeName.toLowerCase();if(!0===["div","li","ul","ol","blockquote"].includes(o))return e;const n=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle,a=n.display;return"block"===a||"table"===a?e:getBlockElement(e.parentNode)}function isChildOf(e,t,o){return!(!e||e===document.body)&&(!0===o&&e===t||(t===document?document.body:t).contains(e.parentNode))}function createRange(e,t,o){if(o||(o=document.createRange(),o.selectNode(e),o.setStart(e,0)),0===t.count)o.setEnd(e,t.count);else if(t.count>0)if(e.nodeType===Node.TEXT_NODE)e.textContent.length<t.count?t.count-=e.textContent.length:(o.setEnd(e,t.count),t.count=0);else for(let n=0;0!==t.count&&n<e.childNodes.length;n++)o=createRange(e.childNodes[n],t,o);return o}const urlRegex=/^https?:\/\//;class Caret{constructor(e,t){this.el=e,this.eVm=t,this._range=null}get selection(){if(this.el){const e=document.getSelection();if(isChildOf(e.anchorNode,this.el,!0)&&isChildOf(e.focusNode,this.el,!0))return e}return null}get hasSelection(){return null!==this.selection&&this.selection.toString().length>0}get range(){const e=this.selection;return null!==e&&e.rangeCount?e.getRangeAt(0):this._range}get parent(){const e=this.range;if(null!==e){const t=e.startContainer;return t.nodeType===document.ELEMENT_NODE?t:t.parentNode}return null}get blockParent(){const e=this.parent;return null!==e?getBlockElement(e,this.el):null}save(e=this.range){null!==e&&(this._range=e)}restore(e=this._range){const t=document.createRange(),o=document.getSelection();null!==e?(t.setStart(e.startContainer,e.startOffset),t.setEnd(e.endContainer,e.endOffset),o.removeAllRanges(),o.addRange(t)):(o.selectAllChildren(this.el),o.collapseToEnd())}savePosition(){let e,t=-1;const o=document.getSelection(),n=this.el.parentNode;if(o.focusNode&&isChildOf(o.focusNode,n)){e=o.focusNode,t=o.focusOffset;while(e&&e!==n)e!==this.el&&e.previousSibling?(e=e.previousSibling,t+=e.textContent.length):e=e.parentNode}this.savedPos=t}restorePosition(e=0){if(this.savedPos>0&&this.savedPos<e){const e=window.getSelection(),t=createRange(this.el,{count:this.savedPos});t&&(t.collapse(!1),e.removeAllRanges(),e.addRange(t))}}hasParent(e,t){const o=t?this.parent:this.blockParent;return null!==o&&o.nodeName.toLowerCase()===e.toLowerCase()}hasParents(e,t,o=this.parent){return null!==o&&(null!==o&&!0===e.includes(o.nodeName.toLowerCase())||!0===t&&this.hasParents(e,t,o.parentNode))}is(e,t){if(null===this.selection)return!1;switch(e){case"formatBlock":return"DIV"===t&&this.parent===this.el||this.hasParent(t,"PRE"===t);case"link":return this.hasParent("A",!0);case"fontSize":return document.queryCommandValue(e)===t;case"fontName":const o=document.queryCommandValue(e);return o===`"${t}"`||o===t;case"fullscreen":return this.eVm.inFullscreen.value;case"viewsource":return this.eVm.isViewingSource.value;case void 0:return!1;default:const n=document.queryCommandState(e);return void 0!==t?n===t:n}}getParentAttribute(e){return null!==this.parent?this.parent.getAttribute(e):null}can(e){return"outdent"===e?this.hasParents(["blockquote","li"],!0):"indent"===e?this.hasParents(["li"],!0):"link"===e?null!==this.selection||this.is("link"):void 0}apply(e,t,o=noop){if("formatBlock"===e)["BLOCKQUOTE","H1","H2","H3","H4","H5","H6"].includes(t)&&this.is(e,t)&&(e="outdent",t=null),"PRE"===t&&this.is(e,"PRE")&&(t="P");else{if("print"===e){o();const e=window.open();return e.document.write(`\n        <!doctype html>\n        <html>\n          <head>\n            <title>Print - ${document.title}</title>\n          </head>\n          <body>\n            <div>${this.el.innerHTML}</div>\n          </body>\n        </html>\n      `),e.print(),void e.close()}if("link"===e){const e=this.getParentAttribute("href");if(null===e){const e=this.selectWord(this.selection),t=e?e.toString():"";if(!t.length&&(!this.range||!this.range.cloneContents().querySelector("img")))return;this.eVm.editLinkUrl.value=urlRegex.test(t)?t:"https://",document.execCommand("createLink",!1,this.eVm.editLinkUrl.value),this.save(e.getRangeAt(0))}else this.eVm.editLinkUrl.value=e,this.range.selectNodeContents(this.parent),this.save();return}if("fullscreen"===e)return this.eVm.toggleFullscreen(),void o();if("viewsource"===e)return this.eVm.isViewingSource.value=!1===this.eVm.isViewingSource.value,this.eVm.setContent(this.eVm.props.modelValue),void o()}document.execCommand(e,!1,t),o()}selectWord(e){if(null===e||!0!==e.isCollapsed||void 0===e.modify)return e;const t=document.createRange();t.setStart(e.anchorNode,e.anchorOffset),t.setEnd(e.focusNode,e.focusOffset);const o=t.collapsed?["backward","forward"]:["forward","backward"];t.detach();const n=e.focusNode,a=e.focusOffset;return e.collapse(e.anchorNode,e.anchorOffset),e.modify("move",o[0],"character"),e.modify("move",o[1],"word"),e.extend(n,a),e.modify("extend",o[1],"character"),e.modify("extend",o[0],"word"),e}}var QTooltip=createComponent({name:"QTooltip",inheritAttrs:!1,props:{...useAnchorProps,...useModelToggleProps,...useTransitionProps,maxHeight:{type:String,default:null},maxWidth:{type:String,default:null},transitionShow:{default:"jump-down"},transitionHide:{default:"jump-up"},anchor:{type:String,default:"bottom middle",validator:validatePosition},self:{type:String,default:"top middle",validator:validatePosition},offset:{type:Array,default:()=>[14,14],validator:validateOffset},scrollTarget:{default:void 0},delay:{type:Number,default:0},hideDelay:{type:Number,default:0}},emits:[...useModelToggleEmits],setup(e,{slots:t,emit:o,attrs:n}){let a,l;const i=getCurrentInstance(),{proxy:{$q:r}}=i,s=ref(null),u=ref(!1),c=computed(()=>parsePosition(e.anchor,r.lang.rtl)),d=computed(()=>parsePosition(e.self,r.lang.rtl)),p=computed(()=>!0!==e.persistent),{registerTick:v,removeTick:m}=useTick(),{registerTimeout:f,removeTimeout:g}=useTimeout(),{transition:b,transitionStyle:y}=useTransition(e,u),{localScrollTarget:S,changeScrollEvent:w,unconfigureScrollTarget:C}=useScrollTarget(e,A),{anchorEl:x,canShow:k,anchorEvents:_}=useAnchor({showing:u,configureAnchorEl:z}),{show:q,hide:T}=useModelToggle({showing:u,canShow:k,handleShow:B,handleHide:Q,hideOnRouteChange:p,processOnMount:!0});Object.assign(_,{delayShow:R,delayHide:L});const{showPortal:P,hidePortal:$,renderPortal:M}=usePortal(i,s,D);if(!0===r.platform.is.mobile){const t={anchorEl:x,innerRef:s,onClickOutside(e){return T(e),e.target.classList.contains("q-dialog__backdrop")&&stopAndPrevent(e),!0}},o=computed(()=>null===e.modelValue&&!0!==e.persistent&&!0===u.value);watch(o,e=>{const o=!0===e?addClickOutside:removeClickOutside;o(t)}),onBeforeUnmount(()=>{removeClickOutside(t)})}function B(t){m(),g(),P(),v(()=>{l=new MutationObserver(()=>O()),l.observe(s.value,{attributes:!1,childList:!0,characterData:!0,subtree:!0}),O(),A()}),void 0===a&&(a=watch(()=>r.screen.width+"|"+r.screen.height+"|"+e.self+"|"+e.anchor+"|"+r.lang.rtl,O)),f(()=>{P(!0),o("show",t)},e.transitionDuration)}function Q(t){m(),g(),E(),f(()=>{$(),o("hide",t)},e.transitionDuration)}function E(){void 0!==l&&(l.disconnect(),l=void 0),void 0!==a&&(a(),a=void 0),C(),cleanEvt(_,"tooltipTemp")}function O(){const t=s.value;null!==x.value&&t&&setPosition({el:t,offset:e.offset,anchorEl:x.value,anchorOrigin:c.value,selfOrigin:d.value,maxHeight:e.maxHeight,maxWidth:e.maxWidth})}function R(t){if(!0===r.platform.is.mobile){clearSelection(),document.body.classList.add("non-selectable");const e=x.value,t=["touchmove","touchcancel","touchend","click"].map(t=>[e,t,"delayHide","passiveCapture"]);addEvt(_,"tooltipTemp",t)}f(()=>{q(t)},e.delay)}function L(t){g(),!0===r.platform.is.mobile&&(cleanEvt(_,"tooltipTemp"),clearSelection(),setTimeout(()=>{document.body.classList.remove("non-selectable")},10)),f(()=>{T(t)},e.hideDelay)}function z(){if(!0===e.noParentEvent||null===x.value)return;const t=!0===r.platform.is.mobile?[[x.value,"touchstart","delayShow","passive"]]:[[x.value,"mouseenter","delayShow","passive"],[x.value,"mouseleave","delayHide","passive"]];addEvt(_,"anchor",t)}function A(){if(null!==x.value||void 0!==e.scrollTarget){S.value=getScrollTarget(x.value,e.scrollTarget);const t=!0===e.noParentEvent?O:T;w(S.value,t)}}function F(){return!0===u.value?h("div",{...n,ref:s,class:["q-tooltip q-tooltip--style q-position-engine no-pointer-events",n.class],style:[n.style,y.value],role:"complementary"},hSlot(t.default)):null}function D(){return h(Transition,{name:b.value,appear:!0},F)}return onBeforeUnmount(E),Object.assign(i.proxy,{updatePosition:O}),M}}),QItem=createComponent({name:"QItem",props:{...useDarkProps,...useRouterLinkProps,tag:{type:String,default:"div"},active:Boolean,clickable:Boolean,dense:Boolean,insetLevel:Number,tabindex:[String,Number],focused:Boolean,manualFocus:Boolean},emits:["click","keyup"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useDark(e,n),{hasRouterLink:l,hasLink:i,linkProps:r,linkClass:s,linkTag:u,navigateToRouterLink:c}=useRouterLink(),d=ref(null),p=ref(null),v=computed(()=>!0===e.clickable||!0===i.value||"label"===e.tag),m=computed(()=>!0!==e.disable&&!0===v.value),f=computed(()=>"q-item q-item-type row no-wrap"+(!0===e.dense?" q-item--dense":"")+(!0===a.value?" q-item--dark":"")+(!0===i.value?s.value:!0===e.active?`${void 0!==e.activeClass?` ${e.activeClass}`:""} q-item--active`:"")+(!0===e.disable?" disabled":"")+(!0===m.value?" q-item--clickable q-link cursor-pointer "+(!0===e.manualFocus?"q-manual-focusable":"q-focusable q-hoverable")+(!0===e.focused?" q-manual-focusable--focused":""):"")),g=computed(()=>{if(void 0===e.insetLevel)return null;const t=!0===n.lang.rtl?"Right":"Left";return{["padding"+t]:16+56*e.insetLevel+"px"}});function b(e){!0===m.value&&(null!==p.value&&(!0!==e.qKeyEvent&&document.activeElement===d.value?p.value.focus():document.activeElement===p.value&&d.value.focus()),!0===l.value&&c(e),o("click",e))}function y(e){if(!0===m.value&&!0===isKeyCode(e,13)){stopAndPrevent(e),e.qKeyEvent=!0;const t=new MouseEvent("click",e);t.qKeyEvent=!0,d.value.dispatchEvent(t)}o("keyup",e)}function S(){const e=hUniqueSlot(t.default,[]);return!0===m.value&&e.unshift(h("div",{class:"q-focus-helper",tabindex:-1,ref:p})),e}return()=>{const t={ref:d,class:f.value,style:g.value,onClick:b,onKeyup:y};return!0===m.value?(t.tabindex=e.tabindex||"0",Object.assign(t,r.value)):!0===v.value&&(t["aria-disabled"]="true"),h(u.value,t,S())}}}),QItemSection=createComponent({name:"QItemSection",props:{avatar:Boolean,thumbnail:Boolean,side:Boolean,top:Boolean,noWrap:Boolean},setup(e,{slots:t}){const o=computed(()=>"q-item__section column"+` q-item__section--${!0===e.avatar||!0===e.side||!0===e.thumbnail?"side":"main"}`+(!0===e.top?" q-item__section--top justify-start":" justify-center")+(!0===e.avatar?" q-item__section--avatar":"")+(!0===e.thumbnail?" q-item__section--thumbnail":"")+(!0===e.noWrap?" q-item__section--nowrap":""));return()=>h("div",{class:o.value},hSlot(t.default))}});function run(e,t,o){t.handler?t.handler(e,o,o.caret):o.runCmd(t.cmd,t.param)}function getGroup(e){return h("div",{class:"q-editor__toolbar-group"},e)}function getBtn(e,t,o,n=!1){const a=n||"toggle"===t.type&&(t.toggled?t.toggled(e):t.cmd&&e.caret.is(t.cmd,t.param)),l=[];if(t.tip&&e.$q.platform.is.desktop){const e=t.key?h("div",[h("small",`(CTRL + ${String.fromCharCode(t.key)})`)]):null;l.push(h(QTooltip,{delay:1e3},()=>[h("div",{innerHTML:t.tip}),e]))}return h(QBtn,{...e.buttonProps.value,icon:null!==t.icon?t.icon:void 0,color:a?t.toggleColor||e.props.toolbarToggleColor:t.color||e.props.toolbarColor,textColor:a&&!e.props.toolbarPush?null:t.textColor||e.props.toolbarTextColor,label:t.label,disable:!!t.disable&&("function"!==typeof t.disable||t.disable(e)),size:"sm",onClick(n){o&&o(),run(n,t,e)}},()=>l)}function getDropdown(e,t){const o="only-icons"===t.list;let n,a,l=t.label,i=null!==t.icon?t.icon:void 0;function r(){u.component.proxy.hide()}if(o)a=t.options.map(t=>{const o=void 0===t.type&&e.caret.is(t.cmd,t.param);return o&&(l=t.tip,i=null!==t.icon?t.icon:void 0),getBtn(e,t,r,o)}),n=e.toolbarBackgroundClass.value,a=[getGroup(a)];else{const o=void 0!==e.props.toolbarToggleColor?`text-${e.props.toolbarToggleColor}`:null,s=void 0!==e.props.toolbarTextColor?`text-${e.props.toolbarTextColor}`:null,u="no-icons"===t.list;a=t.options.map(t=>{const n=!!t.disable&&t.disable(e),a=void 0===t.type&&e.caret.is(t.cmd,t.param);a&&(l=t.tip,i=null!==t.icon?t.icon:void 0);const c=t.htmlTip;return h(QItem,{active:a,activeClass:o,clickable:!0,disable:n,dense:!0,onClick(o){r(),null!==e.contentRef.value&&e.contentRef.value.focus(),e.caret.restore(),run(o,t,e)}},()=>[!0===u?null:h(QItemSection,{class:a?o:s,side:!0},()=>h(QIcon,{name:null!==t.icon?t.icon:void 0})),h(QItemSection,c?()=>h("div",{class:"text-no-wrap",innerHTML:t.htmlTip}):t.tip?()=>h("div",{class:"text-no-wrap"},t.tip):void 0)])}),n=[e.toolbarBackgroundClass.value,s]}const s=t.highlight&&l!==t.label,u=h(QBtnDropdown,{...e.buttonProps.value,noCaps:!0,noWrap:!0,color:s?e.props.toolbarToggleColor:e.props.toolbarColor,textColor:s&&!e.props.toolbarPush?null:e.props.toolbarTextColor,label:t.fixedLabel?t.label:l,icon:t.fixedIcon?null!==t.icon?t.icon:void 0:i,contentClass:n},()=>a);return u}function getToolbar(e){if(e.caret)return e.buttons.value.filter(t=>{return!e.isViewingSource.value||t.find(e=>"viewsource"===e.cmd)}).map(t=>getGroup(t.map(t=>{return(!e.isViewingSource.value||"viewsource"===t.cmd)&&("slot"===t.type?hSlot(e.slots[t.slot]):"dropdown"===t.type?getDropdown(e,t):getBtn(e,t))})))}function getFonts(e,t,o,n={}){const a=Object.keys(n);if(0===a.length)return{};const l={default_font:{cmd:"fontName",param:e,icon:o,tip:t}};return a.forEach(e=>{const t=n[e];l[e]={cmd:"fontName",param:t,icon:o,tip:t,htmlTip:`<font face="${t}">${t}</font>`}}),l}function getLinkEditor(e){if(e.caret){const t=e.props.toolbarColor||e.props.toolbarTextColor;let o=e.editLinkUrl.value;const n=()=>{e.caret.restore(),o!==e.editLinkUrl.value&&document.execCommand("createLink",!1,""===o?" ":o),e.editLinkUrl.value=null};return[h("div",{class:`q-mx-xs text-${t}`},`${e.$q.lang.editor.url}: `),h("input",{key:"qedt_btm_input",class:"col q-editor__link-input",value:o,onInput:e=>{stop(e),o=e.target.value},onKeydown:t=>{if(!0!==shouldIgnoreKey(t))switch(t.keyCode){case 13:return prevent(t),n();case 27:prevent(t),e.caret.restore(),e.editLinkUrl.value&&"https://"!==e.editLinkUrl.value||document.execCommand("unlink"),e.editLinkUrl.value=null;break}}}),getGroup([h(QBtn,{key:"qedt_btm_rem",tabindex:-1,...e.buttonProps.value,label:e.$q.lang.label.remove,noCaps:!0,onClick:()=>{e.caret.restore(),document.execCommand("unlink"),e.editLinkUrl.value=null}}),h(QBtn,{key:"qedt_btm_upd",...e.buttonProps.value,label:e.$q.lang.label.update,noCaps:!0,onClick:n})])]}}const listenerRE=/^on[A-Z]/;function useSplitAttrs(e,t){const o={listeners:ref({}),attributes:ref({})};function n(){const n={},a={};for(const t in e)"class"!==t&&"style"!==t&&!1===listenerRE.test(t)&&(n[t]=e[t]);for(const e in t.props)!0===listenerRE.test(e)&&(a[e]=t.props[e]);o.attributes.value=n,o.listeners.value=a}return onBeforeUpdate(n),n(),o}const toString=Object.prototype.toString,hasOwn=Object.prototype.hasOwnProperty,class2type={};function type(e){return null===e?String(e):class2type[toString.call(e)]||"object"}function isPlainObject(e){if(!e||"object"!==type(e))return!1;if(e.constructor&&!hasOwn.call(e,"constructor")&&!hasOwn.call(e.constructor.prototype,"isPrototypeOf"))return!1;let t;for(t in e);return void 0===t||hasOwn.call(e,t)}function extend(){let e,t,o,n,a,l,i=arguments[0]||{},r=1,s=!1;const u=arguments.length;for("boolean"===typeof i&&(s=i,i=arguments[1]||{},r=2),Object(i)!==i&&"function"!==type(i)&&(i={}),u===r&&(i=this,r--);r<u;r++)if(null!==(e=arguments[r]))for(t in e)o=i[t],n=e[t],i!==n&&(s&&n&&(isPlainObject(n)||(a="array"===type(n)))?(a?(a=!1,l=o&&"array"===type(o)?o:[]):l=o&&isPlainObject(o)?o:{},i[t]=extend(s,l,n)):void 0!==n&&(i[t]=n));return i}"Boolean Number String Function Array Date RegExp Object".split(" ").forEach(e=>{class2type["[object "+e+"]"]=e.toLowerCase()});var QEditor=createComponent({name:"QEditor",props:{...useDarkProps,...useFullscreenProps,modelValue:{type:String,required:!0},readonly:Boolean,disable:Boolean,minHeight:{type:String,default:"10rem"},maxHeight:String,height:String,definitions:Object,fonts:Object,placeholder:String,toolbar:{type:Array,validator:e=>0===e.length||e.every(e=>e.length),default(){return[["left","center","right","justify"],["bold","italic","underline","strike"],["undo","redo"]]}},toolbarColor:String,toolbarBg:String,toolbarTextColor:String,toolbarToggleColor:{type:String,default:"primary"},toolbarOutline:Boolean,toolbarPush:Boolean,toolbarRounded:Boolean,paragraphTag:{type:String,validator:e=>["div","p"].includes(e),default:"div"},contentStyle:Object,contentClass:[Object,Array,String],square:Boolean,flat:Boolean,dense:Boolean},emits:[...useFullscreenEmits,"update:modelValue","keydown","click","mouseup","keyup","touchend","focus","blur"],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a,vnode:l}=getCurrentInstance(),{$q:i}=a,r=useDark(e,i),{inFullscreen:s,toggleFullscreen:u}=useFullscreen(),c=useSplitAttrs(n,l),d=ref(null),p=ref(null),v=ref(null),m=ref(!1),f=computed(()=>!e.readonly&&!e.disable);let g,b,y=e.modelValue;document.execCommand("defaultParagraphSeparator",!1,e.paragraphTag),g=window.getComputedStyle(document.body).fontFamily;const S=computed(()=>e.toolbarBg?` bg-${e.toolbarBg}`:""),w=computed(()=>{const t=!0!==e.toolbarOutline&&!0!==e.toolbarPush;return{type:"a",flat:t,noWrap:!0,outline:e.toolbarOutline,push:e.toolbarPush,rounded:e.toolbarRounded,dense:!0,color:e.toolbarColor,disable:!f.value,size:"sm"}}),C=computed(()=>{const t=i.lang.editor,o=i.iconSet.editor;return{bold:{cmd:"bold",icon:o.bold,tip:t.bold,key:66},italic:{cmd:"italic",icon:o.italic,tip:t.italic,key:73},strike:{cmd:"strikeThrough",icon:o.strikethrough,tip:t.strikethrough,key:83},underline:{cmd:"underline",icon:o.underline,tip:t.underline,key:85},unordered:{cmd:"insertUnorderedList",icon:o.unorderedList,tip:t.unorderedList},ordered:{cmd:"insertOrderedList",icon:o.orderedList,tip:t.orderedList},subscript:{cmd:"subscript",icon:o.subscript,tip:t.subscript,htmlTip:"x<subscript>2</subscript>"},superscript:{cmd:"superscript",icon:o.superscript,tip:t.superscript,htmlTip:"x<superscript>2</superscript>"},link:{cmd:"link",disable:e=>e.caret&&!e.caret.can("link"),icon:o.hyperlink,tip:t.hyperlink,key:76},fullscreen:{cmd:"fullscreen",icon:o.toggleFullscreen,tip:t.toggleFullscreen,key:70},viewsource:{cmd:"viewsource",icon:o.viewSource,tip:t.viewSource},quote:{cmd:"formatBlock",param:"BLOCKQUOTE",icon:o.quote,tip:t.quote,key:81},left:{cmd:"justifyLeft",icon:o.left,tip:t.left},center:{cmd:"justifyCenter",icon:o.center,tip:t.center},right:{cmd:"justifyRight",icon:o.right,tip:t.right},justify:{cmd:"justifyFull",icon:o.justify,tip:t.justify},print:{type:"no-state",cmd:"print",icon:o.print,tip:t.print,key:80},outdent:{type:"no-state",disable:e=>e.caret&&!e.caret.can("outdent"),cmd:"outdent",icon:o.outdent,tip:t.outdent},indent:{type:"no-state",disable:e=>e.caret&&!e.caret.can("indent"),cmd:"indent",icon:o.indent,tip:t.indent},removeFormat:{type:"no-state",cmd:"removeFormat",icon:o.removeFormat,tip:t.removeFormat},hr:{type:"no-state",cmd:"insertHorizontalRule",icon:o.hr,tip:t.hr},undo:{type:"no-state",cmd:"undo",icon:o.undo,tip:t.undo,key:90},redo:{type:"no-state",cmd:"redo",icon:o.redo,tip:t.redo,key:89},h1:{cmd:"formatBlock",param:"H1",icon:o.heading1||o.heading,tip:t.heading1,htmlTip:`<h1 class="q-ma-none">${t.heading1}</h1>`},h2:{cmd:"formatBlock",param:"H2",icon:o.heading2||o.heading,tip:t.heading2,htmlTip:`<h2 class="q-ma-none">${t.heading2}</h2>`},h3:{cmd:"formatBlock",param:"H3",icon:o.heading3||o.heading,tip:t.heading3,htmlTip:`<h3 class="q-ma-none">${t.heading3}</h3>`},h4:{cmd:"formatBlock",param:"H4",icon:o.heading4||o.heading,tip:t.heading4,htmlTip:`<h4 class="q-ma-none">${t.heading4}</h4>`},h5:{cmd:"formatBlock",param:"H5",icon:o.heading5||o.heading,tip:t.heading5,htmlTip:`<h5 class="q-ma-none">${t.heading5}</h5>`},h6:{cmd:"formatBlock",param:"H6",icon:o.heading6||o.heading,tip:t.heading6,htmlTip:`<h6 class="q-ma-none">${t.heading6}</h6>`},p:{cmd:"formatBlock",param:e.paragraphTag,icon:o.heading,tip:t.paragraph},code:{cmd:"formatBlock",param:"PRE",icon:o.code,htmlTip:`<code>${t.code}</code>`},"size-1":{cmd:"fontSize",param:"1",icon:o.size1||o.size,tip:t.size1,htmlTip:`<font size="1">${t.size1}</font>`},"size-2":{cmd:"fontSize",param:"2",icon:o.size2||o.size,tip:t.size2,htmlTip:`<font size="2">${t.size2}</font>`},"size-3":{cmd:"fontSize",param:"3",icon:o.size3||o.size,tip:t.size3,htmlTip:`<font size="3">${t.size3}</font>`},"size-4":{cmd:"fontSize",param:"4",icon:o.size4||o.size,tip:t.size4,htmlTip:`<font size="4">${t.size4}</font>`},"size-5":{cmd:"fontSize",param:"5",icon:o.size5||o.size,tip:t.size5,htmlTip:`<font size="5">${t.size5}</font>`},"size-6":{cmd:"fontSize",param:"6",icon:o.size6||o.size,tip:t.size6,htmlTip:`<font size="6">${t.size6}</font>`},"size-7":{cmd:"fontSize",param:"7",icon:o.size7||o.size,tip:t.size7,htmlTip:`<font size="7">${t.size7}</font>`}}}),x=computed(()=>{const t=e.definitions||{},o=e.definitions||e.fonts?extend(!0,{},C.value,t,getFonts(g,i.lang.editor.defaultFont,i.iconSet.editor.font,e.fonts)):C.value;return e.toolbar.map(e=>e.map(e=>{if(e.options)return{type:"dropdown",icon:e.icon,label:e.label,size:"sm",dense:!0,fixedLabel:e.fixedLabel,fixedIcon:e.fixedIcon,highlight:e.highlight,list:e.list,options:e.options.map(e=>o[e])};const n=o[e];return n?"no-state"===n.type||t[e]&&(void 0===n.cmd||C.value[n.cmd]&&"no-state"===C.value[n.cmd].type)?n:Object.assign({type:"toggle"},n):{type:"slot",slot:e}}))}),k={$q:i,props:e,slots:t,inFullscreen:s,toggleFullscreen:u,runCmd:H,isViewingSource:m,editLinkUrl:v,toolbarBackgroundClass:S,buttonProps:w,contentRef:p,buttons:x,setContent:N};watch(()=>e.modelValue,e=>{y!==e&&(y=e,N(e,!0))});const _=computed(()=>e.toolbar&&e.toolbar.length>0),q=computed(()=>{const e={},t=t=>{t.key&&(e[t.key]={cmd:t.cmd,param:t.param})};return x.value.forEach(e=>{e.forEach(e=>{e.options?e.options.forEach(t):t(e)})}),e}),T=computed(()=>s.value?e.contentStyle:[{minHeight:e.minHeight,height:e.height,maxHeight:e.maxHeight},e.contentStyle]),P=computed(()=>`q-editor q-editor--${!0===m.value?"source":"default"}`+(!0===e.disable?" disabled":"")+(!0===s.value?" fullscreen column":"")+(!0===e.square?" q-editor--square no-border-radius":"")+(!0===e.flat?" q-editor--flat":"")+(!0===e.dense?" q-editor--dense":"")+(!0===r.value?" q-editor--dark q-dark":"")),$=computed(()=>[e.contentClass,"q-editor__content",{col:s.value,"overflow-auto":s.value||e.maxHeight}]),M=computed(()=>!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:{});function B(){if(null!==p.value){const t=`inner${!0===m.value?"Text":"HTML"}`,n=p.value[t];n!==e.modelValue&&(y=n,o("update:modelValue",n))}}function Q(e){if(o("keydown",e),!0!==e.ctrlKey||!0===shouldIgnoreKey(e))return void j();const t=e.keyCode,n=q.value[t];if(void 0!==n){const{cmd:t,param:o}=n;stopAndPrevent(e),H(t,o,!1)}}function E(e){j(),o("click",e)}function O(e){if(null!==p.value){const{scrollTop:e,scrollHeight:t}=p.value;b=t-e}k.caret.save(),o("blur",e)}function R(e){nextTick(()=>{null!==p.value&&void 0!==b&&(p.value.scrollTop=p.value.scrollHeight-b)}),o("focus",e)}function L(e){if(!0===d.value.contains(e.target)&&(null===e.relatedTarget||!0!==d.value.contains(e.relatedTarget))){const e=`inner${!0===m.value?"Text":"HTML"}`;k.caret.restorePosition(p.value[e].length),j()}}function z(e){!0!==d.value.contains(e.target)||null!==e.relatedTarget&&!0===d.value.contains(e.relatedTarget)||(k.caret.savePosition(),j())}function A(){b=void 0}function F(e){k.caret.save(),o("mouseup",e)}function D(){b=void 0}function I(e){k.caret.save(),o("keyup",e)}function V(e){k.caret.save(),o("touchend",e)}function N(e,t){if(null!==p.value){!0===t&&k.caret.savePosition();const o=`inner${!0===m.value?"Text":"HTML"}`;p.value[o]=e,!0===t&&(k.caret.restorePosition(p.value[o].length),j())}}function H(e,t,o=!0){U(),k.caret.restore(),k.caret.apply(e,t,()=>{U(),k.caret.save(),o&&j()})}function j(){setTimeout(()=>{v.value=null,a.$forceUpdate()},1)}function U(){addFocusFn(()=>{null!==p.value&&p.value.focus({preventScroll:!0})})}function K(){return p.value}return Object.assign(a,{runCmd:H,refreshToolbar:j,focus:U,getContentEl:K}),onMounted(()=>{k.caret=a.caret=new Caret(p.value,k),N(e.modelValue),j()}),()=>{let t;if(_.value){const e=[h("div",{key:"qedt_top",class:"q-editor__toolbar row no-wrap scroll-x"+S.value},getToolbar(k))];null!==v.value&&e.push(h("div",{key:"qedt_btm",class:"q-editor__toolbar row no-wrap items-center scroll-x"+S.value},getLinkEditor(k))),t=h("div",{key:"toolbar_ctainer",class:"q-editor__toolbars-container"},e)}return h("div",{ref:d,class:P.value,style:{height:!0===s.value?"100%":null},...M.value,onFocusin:L,onFocusout:z},[t,h("div",{ref:p,style:T.value,class:$.value,contenteditable:f.value,placeholder:e.placeholder,...{},...c.listeners.value,onInput:B,onKeydown:Q,onClick:E,onBlur:O,onFocus:R,onMousedown:A,onTouchstartPassive:D,onMouseup:F,onKeyup:I,onTouchend:V})])}}}),QItemLabel=createComponent({name:"QItemLabel",props:{overline:Boolean,caption:Boolean,header:Boolean,lines:[Number,String]},setup(e,{slots:t}){const o=computed(()=>parseInt(e.lines,10)),n=computed(()=>"q-item__label"+(!0===e.overline?" q-item__label--overline text-overline":"")+(!0===e.caption?" q-item__label--caption text-caption":"")+(!0===e.header?" q-item__label--header":"")+(1===o.value?" ellipsis":"")),a=computed(()=>{return void 0!==e.lines&&o.value>1?{overflow:"hidden",display:"-webkit-box","-webkit-box-orient":"vertical","-webkit-line-clamp":o.value}:null});return()=>h("div",{style:a.value,class:n.value},hSlot(t.default))}}),QSlideTransition=createComponent({name:"QSlideTransition",props:{appear:Boolean,duration:{type:Number,default:300}},emits:["show","hide"],setup(e,{slots:t,emit:o}){let n,a,l,i,r,s,u=!1;function c(){n&&n(),n=null,u=!1,clearTimeout(l),clearTimeout(i),void 0!==a&&a.removeEventListener("transitionend",r),r=null}function d(t,o,a){t.style.overflowY="hidden",void 0!==o&&(t.style.height=`${o}px`),t.style.transition=`height ${e.duration}ms cubic-bezier(.25, .8, .50, 1)`,u=!0,n=a}function p(e,t){e.style.overflowY=null,e.style.height=null,e.style.transition=null,c(),t!==s&&o(t)}function v(t,o){let n=0;a=t,!0===u?(c(),n=t.offsetHeight===t.scrollHeight?0:void 0):s="hide",d(t,n,o),l=setTimeout(()=>{t.style.height=`${t.scrollHeight}px`,r=(e=>{Object(e)===e&&e.target!==t||p(t,"show")}),t.addEventListener("transitionend",r),i=setTimeout(r,1.1*e.duration)},100)}function m(t,o){let n;a=t,!0===u?c():(s="show",n=t.scrollHeight),d(t,n,o),l=setTimeout(()=>{t.style.height=0,r=(e=>{Object(e)===e&&e.target!==t||p(t,"hide")}),t.addEventListener("transitionend",r),i=setTimeout(r,1.1*e.duration)},100)}return onBeforeUnmount(()=>{!0===u&&c()}),()=>h(Transition,{css:!1,appear:e.appear,onEnter:v,onLeave:m},t.default)}});const insetMap={true:"inset",item:"item-inset","item-thumbnail":"item-thumbnail-inset"},margins={xs:2,sm:4,md:8,lg:16,xl:24};var QSeparator=createComponent({name:"QSeparator",props:{...useDarkProps,spaced:[Boolean,String],inset:[Boolean,String],vertical:Boolean,color:String,size:String},setup(e){const t=getCurrentInstance(),o=useDark(e,t.proxy.$q),n=computed(()=>!0===e.vertical?"vertical":"horizontal"),a=computed(()=>` q-separator--${n.value}`),l=computed(()=>!1!==e.inset?`${a.value}-${insetMap[e.inset]}`:""),i=computed(()=>`q-separator${a.value}${l.value}`+(void 0!==e.color?` bg-${e.color}`:"")+(!0===o.value?" q-separator--dark":"")),r=computed(()=>{const t={};if(void 0!==e.size&&(t[!0===e.vertical?"width":"height"]=e.size),!1!==e.spaced){const o=!0===e.spaced?`${margins.md}px`:e.spaced in margins?`${margins[e.spaced]}px`:e.spaced,n=!0===e.vertical?["Left","Right"]:["Top","Bottom"];t[`margin${n[0]}`]=t[`margin${n[1]}`]=o}return t});return()=>h("hr",{class:i.value,style:r.value,"aria-orientation":n.value})}});let buf,bufIdx=0;const hexBytes=new Array(256);for(let e=0;e<256;e++)hexBytes[e]=(e+256).toString(16).substr(1);const randomBytes=(()=>{const e="undefined"!==typeof crypto?crypto:"undefined"!==typeof window?window.crypto||window.msCrypto:void 0;if(void 0!==e){if(void 0!==e.randomBytes)return e.randomBytes;if(void 0!==e.getRandomValues)return t=>{const o=new Uint8Array(t);return e.getRandomValues(o),o}}return e=>{const t=[];for(let o=e;o>0;o--)t.push(Math.floor(256*Math.random()));return t}})(),BUFFER_SIZE=4096;function uid$2(){(void 0===buf||bufIdx+16>BUFFER_SIZE)&&(bufIdx=0,buf=randomBytes(BUFFER_SIZE));const e=Array.prototype.slice.call(buf,bufIdx,bufIdx+=16);return e[6]=15&e[6]|64,e[8]=63&e[8]|128,hexBytes[e[0]]+hexBytes[e[1]]+hexBytes[e[2]]+hexBytes[e[3]]+"-"+hexBytes[e[4]]+hexBytes[e[5]]+"-"+hexBytes[e[6]]+hexBytes[e[7]]+"-"+hexBytes[e[8]]+hexBytes[e[9]]+"-"+hexBytes[e[10]]+hexBytes[e[11]]+hexBytes[e[12]]+hexBytes[e[13]]+hexBytes[e[14]]+hexBytes[e[15]]}const itemGroups=shallowReactive({}),LINK_PROPS=Object.keys(useRouterLinkProps);var QExpansionItem=createComponent({name:"QExpansionItem",props:{...useRouterLinkProps,...useModelToggleProps,...useDarkProps,icon:String,label:String,labelLines:[Number,String],caption:String,captionLines:[Number,String],dense:Boolean,expandIcon:String,expandedIcon:String,expandIconClass:[Array,String,Object],duration:Number,headerInsetLevel:Number,contentInsetLevel:Number,expandSeparator:Boolean,defaultOpened:Boolean,expandIconToggle:Boolean,switchToggleSide:Boolean,denseToggle:Boolean,group:String,popup:Boolean,headerStyle:[Array,String,Object],headerClass:[Array,String,Object]},emits:[...useModelToggleEmits,"click","after-show","after-hide"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useDark(e,n),l=ref(null!==e.modelValue?e.modelValue:e.defaultOpened),i=ref(null),{hide:r,toggle:s}=useModelToggle({showing:l});let u,c;const d=computed(()=>"q-expansion-item q-item-type"+` q-expansion-item--${!0===l.value?"expanded":"collapsed"}`+` q-expansion-item--${!0===e.popup?"popup":"standard"}`),p=computed(()=>{if(void 0===e.contentInsetLevel)return null;const t=!0===n.lang.rtl?"Right":"Left";return{["padding"+t]:56*e.contentInsetLevel+"px"}}),v=computed(()=>!0!==e.disable&&(void 0!==e.href||void 0!==e.to&&null!==e.to&&""!==e.to)),m=computed(()=>{const t={};return LINK_PROPS.forEach(o=>{t[o]=e[o]}),t}),f=computed(()=>!0===v.value||!0!==e.expandIconToggle),g=computed(()=>void 0!==e.expandedIcon&&!0===l.value?e.expandedIcon:e.expandIcon||n.iconSet.expansionItem[!0===e.denseToggle?"denseIcon":"icon"]),b=computed(()=>!0!==e.disable&&(!0===v.value||!0===e.expandIconToggle));function y(e){!0!==v.value&&s(e),o("click",e)}function S(e){13===e.keyCode&&w(e,!0)}function w(e,t){!0!==t&&null!==i.value&&i.value.focus(),s(e),stopAndPrevent(e)}function C(){o("after-show")}function x(){o("after-hide")}function k(){void 0===u&&(u=uid$2()),!0===l.value&&(itemGroups[e.group]=u);const t=watch(l,t=>{!0===t?itemGroups[e.group]=u:itemGroups[e.group]===u&&delete itemGroups[e.group]}),o=watch(()=>itemGroups[e.group],(e,t)=>{t===u&&void 0!==e&&e!==u&&r()});c=(()=>{t(),o(),itemGroups[e.group]===u&&delete itemGroups[e.group],c=void 0})}function _(){const t={class:["q-focusable relative-position cursor-pointer"+`${!0===e.denseToggle&&!0===e.switchToggleSide?" items-end":""}`,e.expandIconClass],side:!0!==e.switchToggleSide,avatar:e.switchToggleSide},o=[h(QIcon,{class:"q-expansion-item__toggle-icon"+(void 0===e.expandedIcon&&!0===l.value?" q-expansion-item__toggle-icon--rotated":""),name:g.value})];return!0===b.value&&(Object.assign(t,{tabindex:0,onClick:w,onKeyup:S}),o.unshift(h("div",{ref:i,class:"q-expansion-item__toggle-focus q-icon q-focus-helper q-focus-helper--rounded",tabindex:-1}))),h(QItemSection,t,()=>o)}function q(){let o;return void 0!==t.header?o=[].concat(t.header()):(o=[h(QItemSection,()=>[h(QItemLabel,{lines:e.labelLines},()=>e.label||""),e.caption?h(QItemLabel,{lines:e.captionLines,caption:!0},()=>e.caption):null])],e.icon&&o[!0===e.switchToggleSide?"push":"unshift"](h(QItemSection,{side:!0===e.switchToggleSide,avatar:!0!==e.switchToggleSide},()=>h(QIcon,{name:e.icon})))),!0!==e.disable&&o[!0===e.switchToggleSide?"unshift":"push"](_()),o}function T(){const t={ref:"item",style:e.headerStyle,class:e.headerClass,dark:a.value,disable:e.disable,dense:e.dense,insetLevel:e.headerInsetLevel};return!0===f.value&&(t.clickable=!0,t.onClick=y,!0===v.value&&Object.assign(t,m.value)),h(QItem,t,q)}function P(){return withDirectives(h("div",{key:"e-content",class:"q-expansion-item__content relative-position",style:p.value},hSlot(t.default)),[[vShow,l.value]])}function $(){const t=[T(),h(QSlideTransition,{duration:e.duration,onShow:C,onHide:x},P)];return!0===e.expandSeparator&&t.push(h(QSeparator,{class:"q-expansion-item__border q-expansion-item__border--top absolute-top",dark:a.value}),h(QSeparator,{class:"q-expansion-item__border q-expansion-item__border--bottom absolute-bottom",dark:a.value})),t}return watch(()=>e.group,e=>{void 0!==c&&c(),void 0!==e&&k()}),void 0!==e.group&&k(),onBeforeUnmount(()=>{void 0!==c&&c()}),()=>h("div",{class:d.value},[h("div",{class:"q-expansion-item__container relative-position"},$())])}});const labelPositions=["top","right","bottom","left"],useFabProps={type:{type:String,default:"a"},outline:Boolean,push:Boolean,flat:Boolean,unelevated:Boolean,color:String,textColor:String,glossy:Boolean,square:Boolean,padding:String,label:{type:[String,Number],default:""},labelPosition:{type:String,default:"right",validator:e=>labelPositions.includes(e)},externalLabel:Boolean,hideLabel:{type:Boolean},labelClass:[Array,String,Object],labelStyle:[Array,String,Object],disable:Boolean,tabindex:[Number,String]};function useFab(e,t){return{formClass:computed(()=>`q-fab--form-${!0===e.square?"square":"rounded"}`),stacked:computed(()=>!1===e.externalLabel&&["top","bottom"].includes(e.labelPosition)),labelProps:computed(()=>{if(!0===e.externalLabel){const o=null===e.hideLabel?!1===t.value:e.hideLabel;return{action:"push",data:{class:[e.labelClass,"q-fab__label q-tooltip--style q-fab__label--external"+` q-fab__label--external-${e.labelPosition}`+(!0===o?" q-fab__label--external-hidden":"")],style:e.labelStyle}}}return{action:["left","top"].includes(e.labelPosition)?"unshift":"push",data:{class:[e.labelClass,`q-fab__label q-fab__label--internal q-fab__label--internal-${e.labelPosition}`+(!0===e.hideLabel?" q-fab__label--internal-hidden":"")],style:e.labelStyle}}})}}const directions=["up","right","down","left"],alignValues=["left","center","right"];var QFab=createComponent({name:"QFab",props:{...useFabProps,...useModelToggleProps,icon:String,activeIcon:String,hideIcon:Boolean,hideLabel:{default:null},direction:{type:String,default:"right",validator:e=>directions.includes(e)},persistent:Boolean,verticalActionsAlign:{type:String,default:"center",validator:e=>alignValues.includes(e)}},emits:useModelToggleEmits,setup(e,{slots:t}){const o=ref(null),n=ref(!0===e.modelValue),{proxy:{$q:a}}=getCurrentInstance(),{formClass:l,labelProps:i}=useFab(e,n),r=computed(()=>!0!==e.persistent),{hide:s,toggle:u}=useModelToggle({showing:n,hideOnRouteChange:r}),c=computed(()=>({opened:n.value})),d=computed(()=>"q-fab z-fab row inline justify-center"+` q-fab--align-${e.verticalActionsAlign} ${l.value}`+(!0===n.value?" q-fab--opened":" q-fab--closed")),p=computed(()=>"q-fab__actions flex no-wrap inline"+` q-fab__actions--${e.direction}`+` q-fab__actions--${!0===n.value?"opened":"closed"}`),v=computed(()=>"q-fab__icon-holder "+` q-fab__icon-holder--${!0===n.value?"opened":"closed"}`);function m(o,n){const l=t[o],i=`q-fab__${o} absolute-full`;return void 0===l?h(QIcon,{class:i,name:e[o]||a.iconSet.fab[n]}):h("div",{class:i},l(c.value))}function f(){const o=[];return!0!==e.hideIcon&&o.push(h("div",{class:v.value},[m("icon","icon"),m("active-icon","activeIcon")])),""===e.label&&void 0===t.label||o[i.value.action](h("div",i.value.data,void 0!==t.label?t.label(c.value):[e.label])),hMergeSlot(t.tooltip,o)}return provide(fabKey,{showing:n,onChildClick(e){s(e),null!==o.value&&o.value.$el.focus()}}),()=>h("div",{class:d.value},[h(QBtn,{ref:o,class:l.value,...e,noWrap:!0,stack:e.stacked,align:void 0,icon:void 0,label:void 0,noCaps:!0,fab:!0,"aria-expanded":!0===n.value?"true":"false","aria-haspopup":"true",onClick:u},f),h("div",{class:p.value},hSlot(t.default))])}});const anchorMap={start:"self-end",center:"self-center",end:"self-start"},anchorValues=Object.keys(anchorMap);var QFabAction=createComponent({name:"QFabAction",props:{...useFabProps,icon:{type:String,default:""},anchor:{type:String,validator:e=>anchorValues.includes(e)},to:[String,Object],replace:Boolean},emits:["click"],setup(e,{slots:t,emit:o}){const n=inject(fabKey,()=>({showing:{value:!0},onChildClick:noop})),{formClass:a,labelProps:l}=useFab(e,n.showing),i=computed(()=>{const t=anchorMap[e.anchor];return a.value+(void 0!==t?` ${t}`:"")}),r=computed(()=>!0===e.disable||!0!==n.showing.value);function s(e){n.onChildClick(e),o("click",e)}function u(){const o=[];return void 0!==t.icon?o.push(t.icon()):""!==e.icon&&o.push(h(QIcon,{name:e.icon})),""===e.label&&void 0===t.label||o[l.value.action](h("div",l.value.data,void 0!==t.label?t.label():[e.label])),hMergeSlot(t.default,o)}const c=getCurrentInstance();return Object.assign(c.proxy,{click:s}),()=>h(QBtn,{class:i.value,...e,noWrap:!0,stack:e.stacked,icon:void 0,label:void 0,noCaps:!0,fabMini:!0,disable:r.value,onClick:s},u)}});function useFormChild({validate:e,resetValidation:t,requiresQForm:o}){const n=inject(formKey,!1);if(!1!==n){const{props:o,proxy:a}=getCurrentInstance();Object.assign(a,{validate:e,resetValidation:t}),watch(()=>o.disable,e=>{!0===e?("function"===typeof t&&t(),n.unbindComponent(a)):n.bindComponent(a)}),!0!==o.disable&&n.bindComponent(a),onBeforeUnmount(()=>{!0!==o.disable&&n.unbindComponent(a)})}else!0===o&&console.error("Parent QForm not found on useFormChild()!")}function cloneDeep(e,t=new WeakMap){if(Object(e)!==e)return e;if(t.has(e))return t.get(e);const o=e instanceof Date?new Date(e):e instanceof RegExp?new RegExp(e.source,e.flags):e instanceof Set?new Set:e instanceof Map?new Map:"function"!==typeof e.constructor?Object.create(null):void 0!==e.prototype&&"function"===typeof e.prototype.constructor?e:new e.constructor;if("function"===typeof e.constructor&&"function"===typeof e.valueOf){const o=e.valueOf();if(Object(o)!==o){const n=new e.constructor(o);return t.set(e,n),n}}return t.set(e,o),e instanceof Set?e.forEach(e=>{o.add(cloneDeep(e,t))}):e instanceof Map&&e.forEach((e,n)=>{o.set(n,cloneDeep(e,t))}),Object.assign(o,...Object.keys(e).map(o=>({[o]:cloneDeep(e[o],t)})))}function fallback(e){const t=document.createElement("textarea");t.value=e,t.contentEditable=!0,t.style.position="fixed",document.body.appendChild(t),t.focus(),t.select();const o=document.execCommand("copy");return t.remove(),o}function copyToClipboard(e){return void 0!==navigator.clipboard?navigator.clipboard.writeText(e):new Promise((t,o)=>{const n=fallback(e);n?t(!0):o(n)})}let updateId,currentClientMeta;const clientList=[];function normalize(e){e.title&&(e.title=e.titleTemplate?e.titleTemplate(e.title):e.title,delete e.titleTemplate),[["meta","content"],["link","href"]].forEach(t=>{const o=e[t[0]],n=t[1];for(const e in o){const t=o[e];t.template&&(1===Object.keys(t).length?delete o[e]:(t[n]=t.template(t[n]||""),delete t.template))}})}function changed(e,t){if(Object.keys(e).length!==Object.keys(t).length)return!0;for(const o in e)if(e[o]!==t[o])return!0}function bodyFilter(e){return!1===["class","style"].includes(e)}function htmlFilter(e){return!1===["lang","dir"].includes(e)}function diff(e,t){const o={},n={};return void 0===e?{add:t,remove:n}:(e.title!==t.title&&(o.title=t.title),["meta","link","script","htmlAttr","bodyAttr"].forEach(a=>{const l=e[a],i=t[a];if(n[a]=[],void 0!==l&&null!==l){o[a]={};for(const e in l)!1===i.hasOwnProperty(e)&&n[a].push(e);for(const e in i)!1===l.hasOwnProperty(e)?o[a][e]=i[e]:!0===changed(l[e],i[e])&&(n[a].push(e),o[a][e]=i[e])}else o[a]=i}),{add:o,remove:n})}function apply({add:e,remove:t}){e.title&&(document.title=e.title),Object.keys(t).length>0&&(["meta","link","script"].forEach(e=>{t[e].forEach(t=>{document.head.querySelector(`${e}[data-qmeta="${t}"]`).remove()})}),t.htmlAttr.filter(htmlFilter).forEach(e=>{document.documentElement.removeAttribute(e)}),t.bodyAttr.filter(bodyFilter).forEach(e=>{document.body.removeAttribute(e)})),["meta","link","script"].forEach(t=>{const o=e[t];for(const e in o){const n=document.createElement(t);for(const t in o[e])"innerHTML"!==t&&n.setAttribute(t,o[e][t]);n.setAttribute("data-qmeta",e),"script"===t&&(n.innerHTML=o[e].innerHTML||""),document.head.appendChild(n)}}),Object.keys(e.htmlAttr).filter(htmlFilter).forEach(t=>{document.documentElement.setAttribute(t,e.htmlAttr[t]||"")}),Object.keys(e.bodyAttr).filter(bodyFilter).forEach(t=>{document.body.setAttribute(t,e.bodyAttr[t]||"")})}function updateClientMeta(){const e={title:"",titleTemplate:null,meta:{},link:{},script:{},htmlAttr:{},bodyAttr:{}};for(let t=0;t<clientList.length;t++){const{active:o,val:n}=clientList[t];!0===o&&extend(!0,e,n)}normalize(e),apply(diff(currentClientMeta,e)),currentClientMeta=e}function planClientUpdate(){clearTimeout(updateId),updateId=setTimeout(updateClientMeta,50)}var Meta={install(e){!0!==this.__installed&&!0===isRuntimeSsrPreHydration.value&&(currentClientMeta=window.__Q_META__,document.getElementById("qmeta-init").remove())}},createMetaMixin=e=>{const t={activated(){this.__qMeta.active=!0,planClientUpdate()},deactivated(){this.__qMeta.active=!1,planClientUpdate()},unmounted(){clientList.splice(clientList.indexOf(this.__qMeta),1),planClientUpdate(),this.__qMeta=void 0}};return"function"===typeof e?Object.assign(t,{computed:{__qMetaOptions(){return e.call(this)||{}}},watch:{__qMetaOptions(e){this.__qMeta.val=e,!0===this.__qMeta.active&&planClientUpdate()}},created(){this.__qMeta={active:!0,val:this.__qMetaOptions},clientList.push(this.__qMeta),planClientUpdate()}}):t.created=function(){this.__qMeta={active:!0,val:e},clientList.push(this.__qMeta),planClientUpdate()},t};function filterFiles(e,t,o,n){const a=[];return e.forEach(e=>{!0===n(e)?a.push(e):t.push({failedPropValidation:o,file:e})}),a}function stopAndPreventDrag(e){e&&e.dataTransfer&&(e.dataTransfer.dropEffect="copy"),stopAndPrevent(e)}const useFileProps={multiple:Boolean,accept:String,capture:String,maxFileSize:[Number,String],maxTotalSize:[Number,String],maxFiles:[Number,String],filter:Function},useFileEmits=["rejected"];function useFile({editable:e,dnd:t,getFileInput:o,addFilesToQueue:n}){const{props:a,emit:l,proxy:i}=getCurrentInstance(),r=computed(()=>void 0!==a.accept?a.accept.split(",").map(e=>{return e=e.trim(),"*"===e?"*/":(e.endsWith("/*")&&(e=e.slice(0,e.length-1)),e.toUpperCase())}):null),s=computed(()=>parseInt(a.maxFiles,10)),u=computed(()=>parseInt(a.maxTotalSize,10));function c(t){if(e.value)if(t!==Object(t)&&(t={target:null}),null!==t.target&&!0===t.target.matches('input[type="file"]'))0===t.clientX&&0===t.clientY&&stop(t);else{const e=o();e&&e!==t.target&&e.click(t)}}function d(t){e.value&&t&&n(null,t)}function p(e,t,o,n){let i=Array.from(t||e.target.files);const c=[],d=()=>{c.length>0&&l("rejected",c)};if(void 0!==a.accept&&-1===r.value.indexOf("*/")&&(i=filterFiles(i,c,"accept",e=>{return r.value.some(t=>e.type.toUpperCase().startsWith(t)||e.name.toUpperCase().endsWith(t))}),0===i.length))return d();if(void 0!==a.maxFileSize){const e=parseInt(a.maxFileSize,10);if(i=filterFiles(i,c,"max-file-size",t=>{return t.size<=e}),0===i.length)return d()}!0!==a.multiple&&(i=[i[0]]),i.forEach(e=>{e.__key=e.webkitRelativePath+e.lastModified+e.name+e.size});const p=o.map(e=>e.__key);if(i=filterFiles(i,c,"duplicate",e=>{return!1===p.includes(e.__key)}),0===i.length)return d();if(void 0!==a.maxTotalSize){let e=!0===n?o.reduce((e,t)=>e+t.size,0):0;if(i=filterFiles(i,c,"max-total-size",t=>{return e+=t.size,e<=u.value}),0===i.length)return d()}if("function"===typeof a.filter){const e=a.filter(i);i=filterFiles(i,c,"filter",t=>{return e.includes(t)})}if(void 0!==a.maxFiles){let e=!0===n?o.length:0;if(i=filterFiles(i,c,"max-files",()=>{return e++,e<=s.value}),0===i.length)return d()}return d(),i.length>0?i:void 0}function v(e){stopAndPreventDrag(e),!0!==t.value&&(t.value=!0)}function m(e){stopAndPrevent(e),t.value=!1}function f(e){stopAndPreventDrag(e);const o=e.dataTransfer.files;o.length>0&&n(null,o),t.value=!1}function g(e){if(!0===t.value)return h("div",{class:`q-${e}__dnd absolute-full`,onDragenter:stopAndPreventDrag,onDragover:stopAndPreventDrag,onDragleave:m,onDrop:f})}return Object.assign(i,{pickFiles:c,addFiles:d}),{pickFiles:c,addFiles:d,onDragover:v,processFiles:p,getDndNode:g,maxFilesNumber:s,maxTotalSizeNumber:u}}function getProgressLabel(e){return(100*e).toFixed(2)+"%"}const coreProps={...useDarkProps,...useFileProps,label:String,color:String,textColor:String,square:Boolean,flat:Boolean,bordered:Boolean,noThumbnails:Boolean,autoUpload:Boolean,hideUploadBtn:Boolean,disable:Boolean,readonly:Boolean},coreEmits=[...useFileEmits,"start","finish","added","removed"];function getRenderer(e){const t=getCurrentInstance(),{props:o,slots:n,emit:a,proxy:l}=t,{$q:i}=l,r=useDark(o,i);function s(e,t,o){if(e.__status=t,"idle"===t)return e.__uploaded=0,e.__progress=0,e.__sizeLabel=humanStorageSize(e.size),void(e.__progressLabel="0.00%");"failed"!==t?(e.__uploaded="uploaded"===t?e.size:o,e.__progress="uploaded"===t?1:Math.min(.9999,e.__uploaded/e.size),e.__progressLabel=getProgressLabel(e.__progress),l.$forceUpdate()):l.$forceUpdate()}const u={files:ref([]),queuedFiles:ref([]),uploadedFiles:ref([]),uploadedSize:ref(0),updateFileStatus:s,isAlive(){return!0!==t.isDeactivated&&!0!==t.isUnmounted}};Object.assign(u,e({props:o,slots:n,emit:a,helpers:u}));const c=ref(0),d=computed(()=>!0!==o.disable&&!0!==o.readonly);void 0===u.isBusy&&(u.isBusy=ref(!1));const p=ref(!1),v=ref(null),m=ref(null);provide(uploaderKey,D);const{pickFiles:f,addFiles:g,onDragover:b,processFiles:y,getDndNode:S,maxFilesNumber:w,maxTotalSizeNumber:C}=useFile({editable:d,dnd:p,getFileInput:L,addFilesToQueue:z}),x=computed(()=>!0===d.value&&!0!==u.isUploading.value&&(!0===o.multiple||0===u.queuedFiles.value.length)&&(void 0===o.maxFiles||u.files.value.length<w.value)&&(void 0===o.maxTotalSize||c.value<C.value)),k=computed(()=>!0===d.value&&!0!==u.isBusy.value&&!0!==u.isUploading.value&&u.queuedFiles.value.length>0),_=computed(()=>0===c.value?0:u.uploadedSize.value/c.value),q=computed(()=>getProgressLabel(_.value)),T=computed(()=>humanStorageSize(c.value)),P=computed(()=>"q-uploader column no-wrap"+(!0===r.value?" q-uploader--dark q-dark":"")+(!0===o.bordered?" q-uploader--bordered":"")+(!0===o.square?" q-uploader--square no-border-radius":"")+(!0===o.flat?" q-uploader--flat no-shadow":"")+(!0===o.disable?" disabled q-uploader--disable":"")),$=computed(()=>"q-uploader__header"+(void 0!==o.color?` bg-${o.color}`:"")+(void 0!==o.textColor?` text-${o.textColor}`:""));function M(){!1===o.disable&&(u.abort(),u.uploadedSize.value=0,c.value=0,R(),u.files.value=[],u.queuedFiles.value=[],u.uploadedFiles.value=[])}function B(){!1===o.disable&&E(["uploaded"],()=>{u.uploadedFiles.value=[]})}function Q(){E(["idle","failed"],({size:e})=>{c.value-=e,u.queuedFiles.value=[]})}function E(e,t){if(!0===o.disable)return;const n={files:[],size:0},l=u.files.value.filter(t=>{return-1===e.indexOf(t.__status)||(n.size+=t.size,n.files.push(t),void 0!==t.__img&&window.URL.revokeObjectURL(t.__img.src),!1)});n.files.length>0&&(u.files.value=l,t(n),a("removed",n.files))}function O(e){o.disable||("uploaded"===e.__status?u.uploadedFiles.value=u.uploadedFiles.value.filter(t=>t.__key!==e.__key):"uploading"===e.__status?e.__abort():c.value-=e.size,u.files.value=u.files.value.filter(t=>{return t.__key!==e.__key||(void 0!==t.__img&&window.URL.revokeObjectURL(t.__img.src),!1)}),u.queuedFiles.value=u.queuedFiles.value.filter(t=>t.__key!==e.__key),a("removed",[e]))}function R(){u.files.value.forEach(e=>{void 0!==e.__img&&window.URL.revokeObjectURL(e.__img.src)})}function L(){return m.value||v.value.getElementsByClassName("q-uploader__input")[0]}function z(e,t){const n=y(e,t,u.files.value,!0);if(void 0===n)return;const l=L();void 0!==l&&null!==l&&(l.value=""),n.forEach(e=>{if(u.updateFileStatus(e,"idle"),c.value+=e.size,!0!==o.noThumbnails&&e.type.toUpperCase().startsWith("IMAGE")){const t=new Image;t.src=window.URL.createObjectURL(e),e.__img=t}}),u.files.value=u.files.value.concat(n),u.queuedFiles.value=u.queuedFiles.value.concat(n),a("added",n),!0===o.autoUpload&&u.upload()}function A(){!0===k.value&&u.upload()}function F(e,t,o){if(!0===e){const e={type:"a",key:t,icon:i.iconSet.uploader[t],flat:!0,dense:!0};let n=void 0;return"add"===t?(e.onClick=f,n=D):e.onClick=o,h(QBtn,e,n)}}function D(){return h("input",{ref:m,class:"q-uploader__input overflow-hidden absolute-full",tabindex:-1,type:"file",title:"",accept:o.accept,multiple:!0===o.multiple?"multiple":void 0,capture:o.capture,onMousedown:stop,onClick:f,onChange:z})}function I(){return void 0!==n.header?n.header(H.value):[h("div",{class:"q-uploader__header-content flex flex-center no-wrap q-gutter-xs"},[F(u.queuedFiles.value.length>0,"removeQueue",Q),F(u.uploadedFiles.value.length>0,"removeUploaded",B),!0===u.isUploading.value?h(QSpinner,{class:"q-uploader__spinner"}):null,h("div",{class:"col column justify-center"},[void 0!==o.label?h("div",{class:"q-uploader__title"},[o.label]):null,h("div",{class:"q-uploader__subtitle"},[T.value+" / "+q.value])]),F(x.value,"add"),F(!1===o.hideUploadBtn&&!0===k.value,"upload",u.upload),F(u.isUploading.value,"clear",u.abort)])]}function V(){return void 0!==n.list?n.list(H.value):u.files.value.map(e=>h("div",{key:e.__key,class:"q-uploader__file relative-position"+(!0!==o.noThumbnails&&void 0!==e.__img?" q-uploader__file--img":"")+("failed"===e.__status?" q-uploader__file--failed":"uploaded"===e.__status?" q-uploader__file--uploaded":""),style:!0!==o.noThumbnails&&void 0!==e.__img?{backgroundImage:'url("'+e.__img.src+'")'}:null},[h("div",{class:"q-uploader__file-header row flex-center no-wrap"},["failed"===e.__status?h(QIcon,{class:"q-uploader__file-status",name:i.iconSet.type.negative,color:"negative"}):null,h("div",{class:"q-uploader__file-header-content col"},[h("div",{class:"q-uploader__title"},[e.name]),h("div",{class:"q-uploader__subtitle row items-center no-wrap"},[e.__sizeLabel+" / "+e.__progressLabel])]),"uploading"===e.__status?h(QCircularProgress,{value:e.__progress,min:0,max:1,indeterminate:0===e.__progress}):h(QBtn,{round:!0,dense:!0,flat:!0,icon:i.iconSet.uploader["uploaded"===e.__status?"done":"clear"],onClick:()=>{O(e)}})])]))}watch(u.isUploading,(e,t)=>{!1===t&&!0===e?a("start"):!0===t&&!1===e&&a("finish")}),onBeforeUnmount(()=>{!0===u.isUploading.value&&u.abort(),u.files.value.length>0&&R()});const N={pickFiles:f,addFiles:g,reset:M,removeUploadedFiles:B,removeQueuedFiles:Q,removeFile:O,upload:A,abort:u.abort},H=computed(()=>{const e={canAddFiles:x.value,canUpload:k.value,uploadSizeLabel:T.value,uploadProgressLabel:q.value};for(const t in u)e[t]=!0===isRef(u[t])?u[t].value:u[t];return{...e,...N}});return Object.assign(l,N),()=>{const e=[h("div",{class:$.value},I()),h("div",{class:"q-uploader__list scroll"},V()),S("uploader")];!0===u.isBusy.value&&e.push(h("div",{class:"q-uploader__overlay absolute-full flex flex-center"},[h(QSpinner)]));const t={ref:v,class:P.value};return!0===x.value&&(t.onDragover=b),h("div",t,e)}}const trueFn=()=>!0;function getEmitsObject(e){const t={};return e.forEach(e=>{t[e]=trueFn}),t}const coreEmitsObject=getEmitsObject(coreEmits);var createUploaderComponent=({name:e,props:t,emits:o,injectPlugin:n})=>createComponent({name:e,props:{...coreProps,...t},emits:Object(o)===o?{...coreEmitsObject,...o}:[...coreEmits,...o],setup(){return getRenderer(n)}});function clean(e){setTimeout(()=>{window.URL.revokeObjectURL(e.href)},1e4),e.remove()}function exportFile(e,t,o={}){const{mimeType:n,byteOrderMark:a,encoding:l}="string"===typeof o?{mimeType:o}:o,i=void 0!==l?new TextEncoder(l).encode([t]):t,r=void 0!==a?[a,i]:[i],s=new Blob(r,{type:n||"application/octet-stream"}),u=document.createElement("a");u.href=window.URL.createObjectURL(s),u.setAttribute("download",e),"undefined"===typeof u.download&&u.setAttribute("target","_blank"),u.classList.add("hidden"),u.style.position="fixed",document.body.appendChild(u);try{return u.click(),clean(u),!0}catch(e){return clean(u),e}}function frameDebounce(e){let t,o,n=!1;function a(){o=arguments,!0!==n&&(n=!0,t=requestAnimationFrame(()=>{e.apply(this,o),o=void 0,n=!1}))}return a.cancel=(()=>{window.cancelAnimationFrame(t),n=!1}),a}function getCssVar(e,t=document.body){if("string"!==typeof e)throw new TypeError("Expected a string as propName");if(!(t instanceof Element))throw new TypeError("Expected a DOM element");return getComputedStyle(t).getPropertyValue(`--q-${e}`).trim()||null}let id$1=0,offsetBase=void 0;function getAbsolutePosition(e,t){void 0===offsetBase&&(offsetBase=document.createElement("div"),offsetBase.style.cssText="position: absolute; left: 0; top: 0",document.body.appendChild(offsetBase));const o=e.getBoundingClientRect(),n=offsetBase.getBoundingClientRect(),{marginLeft:a,marginRight:l,marginTop:i,marginBottom:r}=window.getComputedStyle(e),s=parseInt(a,10)+parseInt(l,10),u=parseInt(i,10)+parseInt(r,10);return{left:o.left-n.left,top:o.top-n.top,width:o.right-o.left,height:o.bottom-o.top,widthM:o.right-o.left+(!0===t?0:s),heightM:o.bottom-o.top+(!0===t?0:u),marginH:!0===t?s:0,marginV:!0===t?u:0}}function getAbsoluteSize(e){return{width:e.scrollWidth,height:e.scrollHeight}}const styleEdges=["Top","Right","Bottom","Left"],styleBorderRadiuses=["borderTopLeftRadius","borderTopRightRadius","borderBottomRightRadius","borderBottomLeftRadius"],reStyleSkipKey=/-block|-inline|block-|inline-/,reStyleSkipRule=/(-block|-inline|block-|inline-).*:/;function getComputedStyle$1(e,t){const o=window.getComputedStyle(e),n={};for(let a=0;a<t.length;a++){const e=t[a];if(""===o[e])if("cssText"===e){const t=o.length;let a="";for(let e=0;e<t;e++)!0!==reStyleSkipKey.test(o[e])&&(a+=o[e]+": "+o[o[e]]+"; ");n[e]=a}else if(["borderWidth","borderStyle","borderColor"].indexOf(e)>-1){const t=e.replace("border","");let a="";for(let e=0;e<styleEdges.length;e++){const n="border"+styleEdges[e]+t;a+=o[n]+" "}n[e]=a}else if("borderRadius"===e){let t="",a="";for(let e=0;e<styleBorderRadiuses.length;e++){const n=o[styleBorderRadiuses[e]].split(" ");t+=n[0]+" ",a+=(void 0===n[1]?n[0]:n[1])+" "}n[e]=t+"/ "+a}else n[e]=o[e];else n[e]="cssText"===e?o[e].split(";").filter(e=>!0!==reStyleSkipRule.test(e)).join(";"):o[e]}return n}const zIndexPositions=["absolute","fixed","relative","sticky"];function getMaxZIndex(e){let t=e,o=0;while(null!==t&&t!==document){const{position:n,zIndex:a}=window.getComputedStyle(t),l=Number(a);l>o&&(t===e||!0===zIndexPositions.includes(n))&&(o=l),t=t.parentNode}return o}function normalizeElements(e){return{from:e.from,to:void 0!==e.to?e.to:e.from}}function normalizeOptions(e){return"number"===typeof e?e={duration:e}:"function"===typeof e&&(e={onEnd:e}),{...e,waitFor:void 0===e.waitFor?0:e.waitFor,duration:!0===isNaN(e.duration)?300:parseInt(e.duration,10),easing:"string"===typeof e.easing&&e.easing.length>0?e.easing:"ease-in-out",delay:!0===isNaN(e.delay)?0:parseInt(e.delay,10),fill:"string"===typeof e.fill&&e.fill.length>0?e.fill:"none",resize:!0===e.resize,useCSS:!0===e.useCSS,hideFromClone:!0===e.hideFromClone,keepToClone:!0===e.keepToClone,tween:!0===e.tween,tweenFromOpacity:!0===isNaN(e.tweenFromOpacity)?.6:parseFloat(e.tweenFromOpacity),tweenToOpacity:!0===isNaN(e.tweenToOpacity)?.5:parseFloat(e.tweenToOpacity)}}function getElement(e){const t=typeof e;return"function"===t?e():"string"===t?document.querySelector(e):e}function isValidElement(e){return e&&e.ownerDocument===document&&null!==e.parentNode}function morph(e){let t=()=>!1,o=!1,n=!0;const a=normalizeElements(e),l=normalizeOptions(e),i=getElement(a.from);if(!0!==isValidElement(i))return t;"function"===typeof i.qMorphCancel&&i.qMorphCancel();let r=void 0,s=void 0,u=void 0,c=void 0;const d=i.parentNode,p=i.nextElementSibling,v=getAbsolutePosition(i,l.resize),{width:m,height:f}=getAbsoluteSize(d),{borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,backgroundColor:S,transform:w,position:C,cssText:x}=getComputedStyle$1(i,["borderWidth","borderStyle","borderColor","borderRadius","backgroundColor","transform","position","cssText"]),k=i.classList.toString(),_=i.style.cssText,q=i.cloneNode(!0),T=!0===l.tween?i.cloneNode(!0):void 0;void 0!==T&&(T.className=T.classList.toString().split(" ").filter(e=>!1===/^bg-/.test(e)).join(" ")),!0===l.hideFromClone&&q.classList.add("q-morph--internal"),q.setAttribute("aria-hidden","true"),q.style.transition="none",q.style.animation="none",q.style.pointerEvents="none",d.insertBefore(q,p),i.qMorphCancel=(()=>{o=!0,q.remove(),void 0!==T&&T.remove(),!0===l.hideFromClone&&q.classList.remove("q-morph--internal"),i.qMorphCancel=void 0});const P=()=>{const e=getElement(a.to);if(!0===o||!0!==isValidElement(e))return void("function"===typeof i.qMorphCancel&&i.qMorphCancel());i!==e&&"function"===typeof e.qMorphCancel&&e.qMorphCancel(),!0!==l.keepToClone&&e.classList.add("q-morph--internal"),q.classList.add("q-morph--internal");const{width:p,height:P}=getAbsoluteSize(d),{width:$,height:M}=getAbsoluteSize(e.parentNode);!0!==l.hideFromClone&&q.classList.remove("q-morph--internal"),e.qMorphCancel=(()=>{o=!0,q.remove(),void 0!==T&&T.remove(),!0===l.hideFromClone&&q.classList.remove("q-morph--internal"),!0!==l.keepToClone&&e.classList.remove("q-morph--internal"),i.qMorphCancel=void 0,e.qMorphCancel=void 0});const B=()=>{if(!0===o)return void("function"===typeof e.qMorphCancel&&e.qMorphCancel());!0!==l.hideFromClone&&(q.classList.add("q-morph--internal"),q.innerHTML="",q.style.left=0,q.style.right="unset",q.style.top=0,q.style.bottom="unset",q.style.transform="none"),!0!==l.keepToClone&&e.classList.remove("q-morph--internal");const a=e.parentNode,{width:B,height:Q}=getAbsoluteSize(a),E=e.cloneNode(l.keepToClone);E.setAttribute("aria-hidden","true"),!0!==l.keepToClone&&(E.style.left=0,E.style.right="unset",E.style.top=0,E.style.bottom="unset",E.style.transform="none",E.style.pointerEvents="none"),E.classList.add("q-morph--internal");const O=e===i&&d===a?q:e.nextElementSibling;a.insertBefore(E,O);const{borderWidth:R,borderStyle:L,borderColor:z,borderRadius:A,backgroundColor:F,transform:D,position:I,cssText:V}=getComputedStyle$1(e,["borderWidth","borderStyle","borderColor","borderRadius","backgroundColor","transform","position","cssText"]),N=e.classList.toString(),H=e.style.cssText;e.style.cssText=V,e.style.transform="none",e.style.animation="none",e.style.transition="none",e.className=N.split(" ").filter(e=>!1===/^bg-/.test(e)).join(" ");const j=getAbsolutePosition(e,l.resize),U=v.left-j.left,K=v.top-j.top,W=v.width/(j.width>0?j.width:10),Y=v.height/(j.height>0?j.height:100),G=m-p,X=f-P,Z=B-$,J=Q-M,ee=Math.max(v.widthM,G),te=Math.max(v.heightM,X),oe=Math.max(j.widthM,Z),ne=Math.max(j.heightM,J),ae=i===e&&!1===["absolute","fixed"].includes(I)&&!1===["absolute","fixed"].includes(C);let le="fixed"===I,ie=a;while(!0!==le&&ie!==document)le="fixed"===window.getComputedStyle(ie).position,ie=ie.parentNode;if(!0!==l.hideFromClone&&(q.style.display="block",q.style.flex="0 0 auto",q.style.opacity=0,q.style.minWidth="unset",q.style.maxWidth="unset",q.style.minHeight="unset",q.style.maxHeight="unset",q.classList.remove("q-morph--internal")),!0!==l.keepToClone&&(E.style.display="block",E.style.flex="0 0 auto",E.style.opacity=0,E.style.minWidth="unset",E.style.maxWidth="unset",E.style.minHeight="unset",E.style.maxHeight="unset"),E.classList.remove("q-morph--internal"),"string"===typeof l.classes&&(e.className+=" "+l.classes),"string"===typeof l.style)e.style.cssText+=" "+l.style;else if(l.style===Object(l.style))for(const t in l.style)e.style[t]=l.style[t];const re=getMaxZIndex(q),se=getMaxZIndex(e),ue=!0===le?document.documentElement:{scrollLeft:0,scrollTop:0};e.style.position=!0===le?"fixed":"absolute",e.style.left=`${j.left-ue.scrollLeft}px`,e.style.right="unset",e.style.top=`${j.top-ue.scrollTop}px`,e.style.margin=0,!0===l.resize&&(e.style.minWidth="unset",e.style.maxWidth="unset",e.style.minHeight="unset",e.style.maxHeight="unset",e.style.overflow="hidden",e.style.overflowX="hidden",e.style.overflowY="hidden"),document.body.appendChild(e),void 0!==T&&(T.style.cssText=x,T.style.transform="none",T.style.animation="none",T.style.transition="none",T.style.position=e.style.position,T.style.left=`${v.left-ue.scrollLeft}px`,T.style.right="unset",T.style.top=`${v.top-ue.scrollTop}px`,T.style.margin=0,T.style.pointerEvents="none",!0===l.resize&&(T.style.minWidth="unset",T.style.maxWidth="unset",T.style.minHeight="unset",T.style.maxHeight="unset",T.style.overflow="hidden",T.style.overflowX="hidden",T.style.overflowY="hidden"),document.body.appendChild(T));const ce=o=>{i===e&&!0!==n?(e.style.cssText=_,e.className=k):(e.style.cssText=H,e.className=N),E.parentNode===a&&a.insertBefore(e,E),q.remove(),E.remove(),void 0!==T&&T.remove(),t=(()=>!1),i.qMorphCancel=void 0,e.qMorphCancel=void 0,"function"===typeof l.onEnd&&l.onEnd(!0===n?"to":"from",!0===o)};if(!0!==l.useCSS&&"function"===typeof e.animate){const a=!0===l.resize?{transform:`translate(${U}px, ${K}px)`,width:`${ee}px`,height:`${te}px`}:{transform:`translate(${U}px, ${K}px) scale(${W}, ${Y})`},d=!0===l.resize?{width:`${oe}px`,height:`${ne}px`}:{},p=!0===l.resize?{width:`${ee}px`,height:`${te}px`}:{},m=!0===l.resize?{transform:`translate(${-1*U}px, ${-1*K}px)`,width:`${oe}px`,height:`${ne}px`}:{transform:`translate(${-1*U}px, ${-1*K}px) scale(${1/W}, ${1/Y})`},f=void 0!==T?{opacity:l.tweenToOpacity}:{backgroundColor:S},C=void 0!==T?{opacity:1}:{backgroundColor:F};c=e.animate([{margin:0,borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,zIndex:re,transformOrigin:"0 0",...a,...f},{margin:0,borderWidth:R,borderStyle:L,borderColor:z,borderRadius:A,zIndex:se,transformOrigin:"0 0",transform:D,...d,...C}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),s=void 0===T?void 0:T.animate([{opacity:l.tweenFromOpacity,margin:0,borderWidth:h,borderStyle:g,borderColor:b,borderRadius:y,zIndex:re,transformOrigin:"0 0",transform:w,...p},{opacity:0,margin:0,borderWidth:R,borderStyle:L,borderColor:z,borderRadius:A,zIndex:se,transformOrigin:"0 0",...m}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),r=!0===l.hideFromClone||!0===ae?void 0:q.animate([{margin:`${X<0?X/2:0}px ${G<0?G/2:0}px`,width:`${ee+v.marginH}px`,height:`${te+v.marginV}px`},{margin:0,width:0,height:0}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay}),u=!0===l.keepToClone?void 0:E.animate([!0===ae?{margin:`${X<0?X/2:0}px ${G<0?G/2:0}px`,width:`${ee+v.marginH}px`,height:`${te+v.marginV}px`}:{margin:0,width:0,height:0},{margin:`${J<0?J/2:0}px ${Z<0?Z/2:0}px`,width:`${oe+j.marginH}px`,height:`${ne+j.marginV}px`}],{duration:l.duration,easing:l.easing,fill:l.fill,delay:l.delay});const x=e=>{void 0!==r&&r.cancel(),void 0!==s&&s.cancel(),void 0!==u&&u.cancel(),c.cancel(),c.removeEventListener("finish",x),c.removeEventListener("cancel",x),ce(e),r=void 0,s=void 0,u=void 0,c=void 0};i.qMorphCancel=(()=>{i.qMorphCancel=void 0,o=!0,x()}),e.qMorphCancel=(()=>{e.qMorphCancel=void 0,o=!0,x()}),c.addEventListener("finish",x),c.addEventListener("cancel",x),t=(e=>{return!0!==o&&void 0!==c&&(!0===e?(x(!0),!0):(n=!0!==n,void 0!==r&&r.reverse(),void 0!==s&&s.reverse(),void 0!==u&&u.reverse(),c.reverse(),!0))})}else{const a=`q-morph-anim-${++id$1}`,r=document.createElement("style"),s=!0===l.resize?`\n            transform: translate(${U}px, ${K}px);\n            width: ${ee}px;\n            height: ${te}px;\n          `:`transform: translate(${U}px, ${K}px) scale(${W}, ${Y});`,u=!0===l.resize?`\n            width: ${oe}px;\n            height: ${ne}px;\n          `:"",c=!0===l.resize?`\n            width: ${ee}px;\n            height: ${te}px;\n          `:"",d=!0===l.resize?`\n            transform: translate(${-1*U}px, ${-1*K}px);\n            width: ${oe}px;\n            height: ${ne}px;\n          `:`transform: translate(${-1*U}px, ${-1*K}px) scale(${1/W}, ${1/Y});`,p=void 0!==T?`opacity: ${l.tweenToOpacity};`:`background-color: ${S};`,m=void 0!==T?"opacity: 1;":`background-color: ${F};`,f=void 0===T?"":`\n            @keyframes ${a}-from-tween {\n              0% {\n                opacity: ${l.tweenFromOpacity};\n                margin: 0;\n                border-width: ${h};\n                border-style: ${g};\n                border-color: ${b};\n                border-radius: ${y};\n                z-index: ${re};\n                transform-origin: 0 0;\n                transform: ${w};\n                ${c}\n              }\n\n              100% {\n                opacity: 0;\n                margin: 0;\n                border-width: ${R};\n                border-style: ${L};\n                border-color: ${z};\n                border-radius: ${A};\n                z-index: ${se};\n                transform-origin: 0 0;\n                ${d}\n              }\n            }\n          `,C=!0===l.hideFromClone||!0===ae?"":`\n            @keyframes ${a}-from {\n              0% {\n                margin: ${X<0?X/2:0}px ${G<0?G/2:0}px;\n                width: ${ee+v.marginH}px;\n                height: ${te+v.marginV}px;\n              }\n\n              100% {\n                margin: 0;\n                width: 0;\n                height: 0;\n              }\n            }\n          `,x=!0===ae?`\n            margin: ${X<0?X/2:0}px ${G<0?G/2:0}px;\n            width: ${ee+v.marginH}px;\n            height: ${te+v.marginV}px;\n          `:"\n            margin: 0;\n            width: 0;\n            height: 0;\n          ",k=!0===l.keepToClone?"":`\n            @keyframes ${a}-to {\n              0% {\n                ${x}\n              }\n\n              100% {\n                margin: ${J<0?J/2:0}px ${Z<0?Z/2:0}px;\n                width: ${oe+j.marginH}px;\n                height: ${ne+j.marginV}px;\n              }\n            }\n          `;r.innerHTML=`\n          @keyframes ${a} {\n            0% {\n              margin: 0;\n              border-width: ${h};\n              border-style: ${g};\n              border-color: ${b};\n              border-radius: ${y};\n              background-color: ${S};\n              z-index: ${re};\n              transform-origin: 0 0;\n              ${s}\n              ${p}\n            }\n\n            100% {\n              margin: 0;\n              border-width: ${R};\n              border-style: ${L};\n              border-color: ${z};\n              border-radius: ${A};\n              background-color: ${F};\n              z-index: ${se};\n              transform-origin: 0 0;\n              transform: ${D};\n              ${u}\n              ${m}\n            }\n          }\n\n          ${C}\n\n          ${f}\n\n          ${k}\n        `,document.head.appendChild(r);let _="normal";q.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-from`,void 0!==T&&(T.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-from-tween`),E.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}-to`,e.style.animation=`${l.duration}ms ${l.easing} ${l.delay}ms ${_} ${l.fill} ${a}`;const P=t=>{t===Object(t)&&t.animationName!==a||(e.removeEventListener("animationend",P),e.removeEventListener("animationcancel",P),ce(),r.remove())};i.qMorphCancel=(()=>{i.qMorphCancel=void 0,o=!0,P()}),e.qMorphCancel=(()=>{e.qMorphCancel=void 0,o=!0,P()}),e.addEventListener("animationend",P),e.addEventListener("animationcancel",P),t=(t=>{return!!(!0!==o&&e&&q&&E)&&(!0===t?(P(),!0):(n=!0!==n,_="normal"===_?"reverse":"normal",q.style.animationDirection=_,T.style.animationDirection=_,E.style.animationDirection=_,e.style.animationDirection=_,!0))})}};if(l.waitFor>0||"transitionend"===l.waitFor||l.waitFor===Object(l.waitFor)&&"function"===typeof l.waitFor.then){const t=l.waitFor>0?new Promise(e=>setTimeout(e,l.waitFor)):"transitionend"===l.waitFor?new Promise(t=>{const o=setTimeout(()=>{n()},400),n=a=>{clearTimeout(o),e&&(e.removeEventListener("transitionend",n),e.removeEventListener("transitioncancel",n)),t()};e.addEventListener("transitionend",n),e.addEventListener("transitioncancel",n)}):l.waitFor;t.then(B).catch(()=>{"function"===typeof e.qMorphCancel&&e.qMorphCancel()})}else B()};return"function"===typeof e.onToggle&&e.onToggle(),requestAnimationFrame(P),e=>t(e)}function parseFeatures(e){const t=Object.assign({noopener:!0},e),o=[];for(const n in t)!0===t[n]&&o.push(n);return o.join(",")}function openWindow(e,t,o){let n=window.open;if(!0===Platform.is.cordova)if(void 0!==cordova&&void 0!==cordova.InAppBrowser&&void 0!==cordova.InAppBrowser.open)n=cordova.InAppBrowser.open;else if(void 0!==navigator&&void 0!==navigator.app)return navigator.app.loadUrl(e,{openExternal:!0});const a=n(e,"_blank",parseFeatures(o));if(a)return Platform.is.desktop&&a.focus(),a;t&&t()}var openUrl=(e,t,o)=>{if(!0!==Platform.is.ios||void 0===window.SafariViewController)return openWindow(e,t,o);window.SafariViewController.isAvailable(n=>{n?window.SafariViewController.show({url:e},noop,t):openWindow(e,t,o)})};const lazyRulesValues=[!0,!1,"ondemand"],useValidateProps={modelValue:{},error:{type:Boolean,default:null},errorMessage:String,noErrorIcon:Boolean,rules:Array,reactiveRules:Boolean,lazyRules:{type:[Boolean,String],validator:e=>lazyRulesValues.includes(e)}};function useValidate(e,t){const{props:o,proxy:n}=getCurrentInstance(),a=ref(!1),l=ref(null),i=ref(null);useFormChild({validate:m,resetValidation:v});let r,s=0;const u=computed(()=>void 0!==o.rules&&null!==o.rules&&o.rules.length>0),c=computed(()=>!0!==o.disable&&!0===u.value),d=computed(()=>!0===o.error||!0===a.value),p=computed(()=>"string"===typeof o.errorMessage&&o.errorMessage.length>0?o.errorMessage:l.value);function v(){s++,t.value=!1,i.value=null,a.value=!1,l.value=null,h.cancel()}function m(e=o.modelValue){if(!0!==c.value)return!0;const n=++s;!0!==t.value&&!0!==o.lazyRules&&(i.value=!0);const r=(e,o)=>{a.value!==e&&(a.value=e);const n=o||void 0;l.value!==n&&(l.value=n),t.value=!1},u=[];for(let t=0;t<o.rules.length;t++){const n=o.rules[t];let a;if("function"===typeof n?a=n(e):"string"===typeof n&&void 0!==testPattern[n]&&(a=testPattern[n](e)),!1===a||"string"===typeof a)return r(!0,a),!1;!0!==a&&void 0!==a&&u.push(a)}return 0===u.length?(r(!1),!0):(t.value=!0,Promise.all(u).then(e=>{if(void 0===e||!1===Array.isArray(e)||0===e.length)return n===s&&r(!1),!0;const t=e.find(e=>!1===e||"string"===typeof e);return n===s&&r(void 0!==t,t),void 0===t},e=>{return n===s&&(console.error(e),r(!0)),!1}))}function f(e){!0===c.value&&"ondemand"!==o.lazyRules&&(!0===i.value||!0!==o.lazyRules&&!0!==e)&&h()}watch(()=>o.modelValue,()=>{f()}),watch(()=>o.reactiveRules,e=>{!0===e?void 0===r&&(r=watch(()=>o.rules,()=>{f(!0)})):void 0!==r&&(r(),r=void 0)},{immediate:!0}),watch(e,e=>{!0===e?null===i.value&&(i.value=!1):!1===i.value&&(i.value=!0,!0===c.value&&"ondemand"!==o.lazyRules&&!1===t.value&&h())});const h=debounce(m,0);return onBeforeUnmount(()=>{void 0!==r&&r(),h.cancel()}),Object.assign(n,{resetValidation:v,validate:m}),injectProp(n,"hasError",()=>d.value),{isDirtyModel:i,hasRules:u,hasError:d,errorMessage:p,validate:m,resetValidation:v}}function getTargetUid(e){return void 0===e?`f_${uid$2()}`:e}function fieldValueIsFilled(e){return void 0!==e&&null!==e&&(""+e).length>0}const useFieldProps={...useDarkProps,...useValidateProps,label:String,stackLabel:Boolean,hint:String,hideHint:Boolean,prefix:String,suffix:String,labelColor:String,color:String,bgColor:String,filled:Boolean,outlined:Boolean,borderless:Boolean,standout:[Boolean,String],square:Boolean,loading:Boolean,labelSlot:Boolean,bottomSlots:Boolean,hideBottomSpace:Boolean,rounded:Boolean,dense:Boolean,itemAligned:Boolean,counter:Boolean,clearable:Boolean,clearIcon:String,disable:Boolean,readonly:Boolean,autofocus:Boolean,for:String,maxlength:[Number,String]},useFieldEmits=["update:modelValue","clear","focus","blur","popup-show","popup-hide"];function useFieldState(){const{props:e,attrs:t,proxy:o,vnode:n}=getCurrentInstance(),a=useDark(e,o.$q);return{isDark:a,editable:computed(()=>!0!==e.disable&&!0!==e.readonly),innerLoading:ref(!1),focused:ref(!1),hasPopupOpen:!1,splitAttrs:useSplitAttrs(t,n),targetUid:ref(getTargetUid(e.for)),rootRef:ref(null),targetRef:ref(null),controlRef:ref(null)}}function useField(e){const{props:t,emit:o,slots:n,attrs:a,proxy:l}=getCurrentInstance(),{$q:i}=l;let r;void 0===e.hasValue&&(e.hasValue=computed(()=>fieldValueIsFilled(t.modelValue))),void 0===e.emitValue&&(e.emitValue=(e=>{o("update:modelValue",e)})),void 0===e.controlEvents&&(e.controlEvents={onFocusin:q,onFocusout:T}),Object.assign(e,{clearValue:P,onControlFocusin:q,onControlFocusout:T,focus:k}),void 0===e.computedCounter&&(e.computedCounter=computed(()=>{if(!1!==t.counter){const e="string"===typeof t.modelValue||"number"===typeof t.modelValue?(""+t.modelValue).length:!0===Array.isArray(t.modelValue)?t.modelValue.length:0,o=void 0!==t.maxlength?t.maxlength:t.maxValues;return e+(void 0!==o?" / "+o:"")}}));const{isDirtyModel:s,hasRules:u,hasError:c,errorMessage:d,resetValidation:p}=useValidate(e.focused,e.innerLoading),v=void 0!==e.floatingLabel?computed(()=>!0===t.stackLabel||!0===e.focused.value||!0===e.floatingLabel.value):computed(()=>!0===t.stackLabel||!0===e.focused.value||!0===e.hasValue.value),m=computed(()=>!0===t.bottomSlots||void 0!==t.hint||!0===u.value||!0===t.counter||null!==t.error),f=computed(()=>{return!0===t.filled?"filled":!0===t.outlined?"outlined":!0===t.borderless?"borderless":t.standout?"standout":"standard"}),g=computed(()=>`q-field row no-wrap items-start q-field--${f.value}`+(void 0!==e.fieldClass?` ${e.fieldClass.value}`:"")+(!0===t.rounded?" q-field--rounded":"")+(!0===t.square?" q-field--square":"")+(!0===v.value?" q-field--float":"")+(!0===y.value?" q-field--labeled":"")+(!0===t.dense?" q-field--dense":"")+(!0===t.itemAligned?" q-field--item-aligned q-item-type":"")+(!0===e.isDark.value?" q-field--dark":"")+(void 0===e.getControl?" q-field--auto-height":"")+(!0===e.focused.value?" q-field--focused":"")+(!0===c.value?" q-field--error":"")+(!0===c.value||!0===e.focused.value?" q-field--highlighted":"")+(!0!==t.hideBottomSpace&&!0===m.value?" q-field--with-bottom":"")+(!0===t.disable?" q-field--disabled":!0===t.readonly?" q-field--readonly":"")),b=computed(()=>"q-field__control relative-position row no-wrap"+(void 0!==t.bgColor?` bg-${t.bgColor}`:"")+(!0===c.value?" text-negative":"string"===typeof t.standout&&t.standout.length>0&&!0===e.focused.value?` ${t.standout}`:void 0!==t.color?` text-${t.color}`:"")),y=computed(()=>!0===t.labelSlot||void 0!==t.label),S=computed(()=>"q-field__label no-pointer-events absolute ellipsis"+(void 0!==t.labelColor&&!0!==c.value?` text-${t.labelColor}`:"")),w=computed(()=>({id:e.targetUid.value,editable:e.editable.value,focused:e.focused.value,floatingLabel:v.value,modelValue:t.modelValue,emitValue:e.emitValue})),C=computed(()=>{const o={for:e.targetUid.value};return!0===t.disable?o["aria-disabled"]="true":!0===t.readonly&&(o["aria-readonly"]="true"),o});function x(){const t=document.activeElement;let o=void 0!==e.targetRef&&e.targetRef.value;!o||null!==t&&t.id===e.targetUid.value||(!0===o.hasAttribute("tabindex")||(o=o.querySelector("[tabindex]")),o&&o!==t&&o.focus({preventScroll:!0}))}function k(){addFocusFn(x)}function _(){removeFocusFn(x);const t=document.activeElement;null!==t&&e.rootRef.value.contains(t)&&t.blur()}function q(t){clearTimeout(r),!0===e.editable.value&&!1===e.focused.value&&(e.focused.value=!0,o("focus",t))}function T(t,n){clearTimeout(r),r=setTimeout(()=>{(!0!==document.hasFocus()||!0!==e.hasPopupOpen&&void 0!==e.controlRef&&null!==e.controlRef.value&&!1===e.controlRef.value.contains(document.activeElement))&&(!0===e.focused.value&&(e.focused.value=!1,o("blur",t)),void 0!==n&&n())})}function P(n){if(stopAndPrevent(n),!0!==i.platform.is.mobile){const t=void 0!==e.targetRef&&e.targetRef.value||e.rootRef.value;t.focus()}else!0===e.rootRef.value.contains(document.activeElement)&&document.activeElement.blur();"file"===t.type&&(e.inputRef.value.value=null),o("update:modelValue",null),o("clear",t.modelValue),nextTick(()=>{p(),!0!==i.platform.is.mobile&&(s.value=!1)})}function $(){const o=[];return void 0!==n.prepend&&o.push(h("div",{class:"q-field__prepend q-field__marginal row no-wrap items-center",key:"prepend",onClick:prevent},n.prepend())),o.push(h("div",{class:"q-field__control-container col relative-position row no-wrap q-anchor--skip"},M())),void 0!==n.append&&o.push(h("div",{class:"q-field__append q-field__marginal row no-wrap items-center",key:"append",onClick:prevent},n.append())),!0===c.value&&!1===t.noErrorIcon&&o.push(Q("error",[h(QIcon,{name:i.iconSet.field.error,color:"negative"})])),!0===t.loading||!0===e.innerLoading.value?o.push(Q("inner-loading-append",void 0!==n.loading?n.loading():[h(QSpinner,{color:t.color})])):!0===t.clearable&&!0===e.hasValue.value&&!0===e.editable.value&&o.push(Q("inner-clearable-append",[h(QIcon,{class:"q-field__focusable-action",tag:"button",name:t.clearIcon||i.iconSet.field.clear,tabindex:0,type:"button","aria-hidden":null,role:null,onClick:P})])),void 0!==e.getInnerAppend&&o.push(Q("inner-append",e.getInnerAppend())),void 0!==e.getControlChild&&o.push(e.getControlChild()),o}function M(){const o=[];return void 0!==t.prefix&&null!==t.prefix&&o.push(h("div",{class:"q-field__prefix no-pointer-events row items-center"},t.prefix)),void 0!==e.getShadowControl&&!0===e.hasShadow.value&&o.push(e.getShadowControl()),void 0!==e.getControl?o.push(e.getControl()):void 0!==n.rawControl?o.push(n.rawControl()):void 0!==n.control&&o.push(h("div",{ref:e.targetRef,class:"q-field__native row",...e.splitAttrs.attributes.value,"data-autofocus":!0===t.autofocus||void 0},n.control(w.value))),!0===y.value&&o.push(h("div",{class:S.value},hSlot(n.label,t.label))),void 0!==t.suffix&&null!==t.suffix&&o.push(h("div",{class:"q-field__suffix no-pointer-events row items-center"},t.suffix)),o.concat(hSlot(n.default))}function B(){let o,a;!0===c.value?null!==d.value?(o=[h("div",{role:"alert"},d.value)],a=`q--slot-error-${d.value}`):(o=hSlot(n.error),a="q--slot-error"):!0===t.hideHint&&!0!==e.focused.value||(void 0!==t.hint?(o=[h("div",t.hint)],a=`q--slot-hint-${t.hint}`):(o=hSlot(n.hint),a="q--slot-hint"));const l=!0===t.counter||void 0!==n.counter;if(!0===t.hideBottomSpace&&!1===l&&void 0===o)return;const i=h("div",{key:a,class:"q-field__messages col"},o);return h("div",{class:"q-field__bottom row items-start q-field__bottom--"+(!0!==t.hideBottomSpace?"animated":"stale")},[!0===t.hideBottomSpace?i:h(Transition,{name:"q-transition--field-message"},()=>i),!0===l?h("div",{class:"q-field__counter"},void 0!==n.counter?n.counter():e.computedCounter.value):null])}function Q(e,t){return null===t?null:h("div",{key:e,class:"q-field__append q-field__marginal row no-wrap items-center q-anchor--skip"},t)}watch(()=>t.for,t=>{e.targetUid.value=getTargetUid(t)}),Object.assign(l,{focus:k,blur:_});let E=!1;return onDeactivated(()=>{E=!0}),onActivated(()=>{!0===E&&!0===t.autofocus&&l.focus()}),onMounted(()=>{!0===isRuntimeSsrPreHydration.value&&void 0===t.for&&(e.targetUid.value=getTargetUid()),!0===t.autofocus&&l.focus()}),onBeforeUnmount(()=>{clearTimeout(r)}),function(){return h("label",{ref:e.rootRef,class:[g.value,a.class],style:a.style,...C.value},[void 0!==n.before?h("div",{class:"q-field__before q-field__marginal row no-wrap items-center",onClick:prevent},n.before()):null,h("div",{class:"q-field__inner relative-position col self-stretch"},[h("div",{ref:e.controlRef,class:b.value,tabindex:-1,...e.controlEvents},$()),!0===m.value?B():null]),void 0!==n.after?h("div",{class:"q-field__after q-field__marginal row no-wrap items-center",onClick:prevent},n.after()):null])}}var QField=createComponent({name:"QField",inheritAttrs:!1,props:useFieldProps,emits:useFieldEmits,setup(){return useField(useFieldState())}});function useFileFormDomProps(e,t){function o(){const t=e.modelValue;try{const e="DataTransfer"in window?new DataTransfer:"ClipboardEvent"in window?new ClipboardEvent("").clipboardData:void 0;return Object(t)===t&&("length"in t?Array.from(t):[t]).forEach(t=>{e.items.add(t)}),{files:e.files}}catch(e){return{files:void 0}}}return computed(!0===t?()=>{if("file"===e.type)return o()}:o)}var QFile=createComponent({name:"QFile",inheritAttrs:!1,props:{...useFieldProps,...useFormProps,...useFileProps,modelValue:[File,FileList,Array],append:Boolean,useChips:Boolean,displayValue:[String,Number],tabindex:{type:[String,Number],default:0},counterLabel:Function,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},emits:[...useFieldEmits,...useFileEmits],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a}=getCurrentInstance(),l=useFieldState(),i=ref(null),r=ref(!1),s=useFormInputNameAttr(e),{pickFiles:u,onDragover:c,processFiles:d,getDndNode:p}=useFile({editable:l.editable,dnd:r,getFileInput:T,addFilesToQueue:P}),v=useFileFormDomProps(e),m=computed(()=>Object(e.modelValue)===e.modelValue?"length"in e.modelValue?Array.from(e.modelValue):[e.modelValue]:[]),f=computed(()=>fieldValueIsFilled(m.value)),g=computed(()=>m.value.map(e=>e.name).join(", ")),b=computed(()=>humanStorageSize(m.value.reduce((e,t)=>e+t.size,0))),y=computed(()=>({totalSize:b.value,filesNumber:m.value.length,maxFiles:e.maxFiles})),S=computed(()=>({tabindex:-1,type:"file",title:"",accept:e.accept,capture:e.capture,name:s.value,...n,id:l.targetUid.value,disabled:!0!==l.editable.value})),w=computed(()=>!0===e.multiple&&!0===e.append);function C(e){const t=m.value.slice();t.splice(e,1),k(t)}function x(e){const t=m.value.findIndex(e);t>-1&&C(t)}function k(t){o("update:modelValue",!0===e.multiple?t:t[0])}function _(e){13===e.keyCode&&prevent(e)}function q(e){13!==e.keyCode&&32!==e.keyCode||u(e)}function T(){return i.value}function P(t,o){const n=d(t,o,m.value,w.value);void 0!==n&&((!0===e.multiple?e.modelValue&&n.every(e=>m.value.includes(e)):e.modelValue===n[0])||k(!0===w.value?m.value.concat(n):n))}function $(){return[h("input",{class:[e.inputClass,"q-file__filler"],style:e.inputStyle})]}function M(){if(void 0!==t.file)return 0===m.value.length?$():m.value.map((e,o)=>t.file({index:o,file:e,ref:this}));if(void 0!==t.selected)return 0===m.value.length?$():t.selected({files:m.value,ref:this});if(!0===e.useChips)return 0===m.value.length?$():m.value.map((t,o)=>h(QChip,{key:"file-"+o,removable:l.editable.value,dense:!0,textColor:e.color,tabindex:e.tabindex,onRemove:()=>{C(o)}},()=>h("span",{class:"ellipsis",textContent:t.name})));const o=void 0!==e.displayValue?e.displayValue:g.value;return o.length>0?[h("div",{class:e.inputClass,style:e.inputStyle,textContent:o})]:$()}function B(){const t={ref:i,...S.value,...v.value,class:"q-field__input fit absolute-full cursor-pointer",onChange:P};return!0===e.multiple&&(t.multiple=!0),h("input",t)}return Object.assign(l,{fieldClass:{value:"q-file q-field--auto-height"},emitValue:k,hasValue:f,inputRef:i,innerValue:m,floatingLabel:computed(()=>!0===f.value||fieldValueIsFilled(e.displayValue)),computedCounter:computed(()=>{if(void 0!==e.counterLabel)return e.counterLabel(y.value);const t=e.maxFiles;return`${m.value.length}${void 0!==t?" / "+t:""} (${b.value})`}),getControlChild:()=>p("file"),getControl:()=>{const t={ref:l.targetRef,class:"q-field__native row items-center cursor-pointer",tabindex:e.tabindex};return!0===l.editable.value&&Object.assign(t,{onDragover:c,onKeydown:_,onKeyup:q}),h("div",t,[B()].concat(M()))}}),Object.assign(a,{removeAtIndex:C,removeFile:x,getNativeElement:()=>i.value}),useField(l)}}),QFooter=createComponent({name:"QFooter",props:{modelValue:{type:Boolean,default:!0},reveal:Boolean,bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},emits:["reveal","focusin"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=inject(layoutKey,()=>{console.error("QFooter needs to be child of QLayout")}),l=ref(parseInt(e.heightHint,10)),i=ref(!0),r=ref(!0===isRuntimeSsrPreHydration.value||!0===a.isContainer.value?0:window.innerHeight),s=computed(()=>!0===e.reveal||a.view.value.indexOf("F")>-1||n.platform.is.ios&&!0===a.isContainer.value),u=computed(()=>!0===a.isContainer.value?a.containerHeight.value:r.value),c=computed(()=>{if(!0!==e.modelValue)return 0;if(!0===s.value)return!0===i.value?l.value:0;const t=a.scroll.value.position+u.value+l.value-a.height.value;return t>0?t:0}),d=computed(()=>!0!==e.modelValue||!0===s.value&&!0!==i.value),p=computed(()=>!0===e.modelValue&&!0===d.value&&!0===e.reveal),v=computed(()=>"q-footer q-layout__section--marginal "+(!0===s.value?"fixed":"absolute")+"-bottom"+(!0===e.bordered?" q-footer--bordered":"")+(!0===d.value?" q-footer--hidden":"")+(!0!==e.modelValue?" q-layout--prevent-focus"+(!0!==s.value?" hidden":""):"")),m=computed(()=>{const e=a.rows.value.bottom,t={};return"l"===e[0]&&!0===a.left.space&&(t[!0===n.lang.rtl?"right":"left"]=`${a.left.size}px`),"r"===e[2]&&!0===a.right.space&&(t[!0===n.lang.rtl?"left":"right"]=`${a.right.size}px`),t});function f(e,t){a.update("footer",e,t)}function g(e,t){e.value!==t&&(e.value=t)}function b({height:e}){g(l,e),f("size",e)}function y(){if(!0!==e.reveal)return;const{direction:t,position:o,inflectionPoint:n}=a.scroll.value;g(i,"up"===t||o-n<100||a.height.value-u.value-o-l.value<300)}function S(e){!0===p.value&&g(i,!0),o("focusin",e)}watch(()=>e.modelValue,e=>{f("space",e),g(i,!0),a.animate()}),watch(c,e=>{f("offset",e)}),watch(()=>e.reveal,t=>{!1===t&&g(i,e.modelValue)}),watch(i,e=>{a.animate(),o("reveal",e)}),watch([l,a.scroll,a.height],y),watch(()=>n.screen.height,e=>{!0!==a.isContainer.value&&g(r,e)});const w={};return a.instances.footer=w,!0===e.modelValue&&f("size",l.value),f("space",e.modelValue),f("offset",c.value),onBeforeUnmount(()=>{a.instances.footer===w&&(a.instances.footer=void 0,f("size",0),f("offset",0),f("space",!1))}),()=>{const o=hMergeSlot(t.default,[h(QResizeObserver,{debounce:0,onResize:b})]);return!0===e.elevated&&o.push(h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),h("footer",{class:v.value,style:m.value,onFocusin:S},o)}}}),QForm=createComponent({name:"QForm",props:{autofocus:Boolean,noErrorFocus:Boolean,noResetFocus:Boolean,greedy:Boolean,onSubmit:Function},emits:["reset","validation-success","validation-error"],setup(e,{slots:t,emit:o}){const n=getCurrentInstance(),a=ref(null);let l=0;const i=[];function r(t){const n=[],a="boolean"===typeof t?t:!0!==e.noErrorFocus,r=++l,s=(e,t)=>{o("validation-"+(!0===e?"success":"error"),t)};for(let o=0;o<i.length;o++){const t=i[o],l=t.validate();if("function"===typeof l.then)n.push(l.then(e=>({valid:e,comp:t}),e=>({valid:!1,comp:t,err:e})));else if(!0!==l){if(!1===e.greedy)return s(!1,t),!0===a&&"function"===typeof t.focus&&t.focus(),Promise.resolve(!1);n.push({valid:!1,comp:t})}}return 0===n.length?(s(!0),Promise.resolve(!0)):Promise.all(n).then(e=>{const t=e.filter(e=>!0!==e.valid);if(0===t.length)return r===l&&s(!0),!0;const{valid:o,comp:n,err:i}=t[0];return r===l&&(void 0!==i&&console.error(i),s(!1,n),!0===a&&!0!==o&&"function"===typeof n.focus&&n.focus()),!1})}function s(){l++,i.forEach(e=>{"function"===typeof e.resetValidation&&e.resetValidation()})}function u(t){void 0!==t&&stopAndPrevent(t);const n=l+1;r().then(a=>{n===l&&!0===a&&(void 0!==e.onSubmit?o("submit",t):void 0!==t&&void 0!==t.target&&"function"===typeof t.target.submit&&t.target.submit())})}function c(t){void 0!==t&&stopAndPrevent(t),o("reset"),nextTick(()=>{s(),!0===e.autofocus&&!0!==e.noResetFocus&&d()})}function d(){addFocusFn(()=>{if(null===a.value)return;const e=a.value.querySelector("[autofocus], [data-autofocus]")||Array.prototype.find.call(a.value.querySelectorAll("[tabindex]"),e=>e.tabIndex>-1);null!==e&&void 0!==e&&e.focus({preventScroll:!0})})}provide(formKey,{bindComponent(e){i.push(e)},unbindComponent(e){const t=i.indexOf(e);t>-1&&i.splice(t,1)}});let p=!1;return onDeactivated(()=>{p=!0}),onActivated(()=>{!0===p&&!0===e.autofocus&&d()}),onMounted(()=>{!0===e.autofocus&&d()}),Object.assign(n.proxy,{validate:r,resetValidation:s,submit:u,reset:c,focus:d,getValidationComponents:()=>i}),()=>h("form",{class:"q-form",ref:a,onSubmit:u,onReset:c},hSlot(t.default))}}),QFormChildMixin={inject:{[formKey]:{default:noop}},watch:{disable(e){const t=this.$.provides[formKey];void 0!==t&&(!0===e?(this.resetValidation(),t.unbindComponent(this)):t.bindComponent(this))}},methods:{validate(){},resetValidation(){}},created(){const e=this.$.provides[formKey];void 0!==e&&!0!==this.disable&&e.bindComponent(this)},beforeUnmount(){const e=this.$.provides[formKey];void 0!==e&&!0!==this.disable&&e.unbindComponent(this)}},QHeader=createComponent({name:"QHeader",props:{modelValue:{type:Boolean,default:!0},reveal:Boolean,revealOffset:{type:Number,default:250},bordered:Boolean,elevated:Boolean,heightHint:{type:[String,Number],default:50}},emits:["reveal","focusin"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=inject(layoutKey,()=>{console.error("QHeader needs to be child of QLayout")}),l=ref(parseInt(e.heightHint,10)),i=ref(!0),r=computed(()=>!0===e.reveal||a.view.value.indexOf("H")>-1||n.platform.is.ios&&!0===a.isContainer.value),s=computed(()=>{if(!0!==e.modelValue)return 0;if(!0===r.value)return!0===i.value?l.value:0;const t=l.value-a.scroll.value.position;return t>0?t:0}),u=computed(()=>!0!==e.modelValue||!0===r.value&&!0!==i.value),c=computed(()=>!0===e.modelValue&&!0===u.value&&!0===e.reveal),d=computed(()=>"q-header q-layout__section--marginal "+(!0===r.value?"fixed":"absolute")+"-top"+(!0===e.bordered?" q-header--bordered":"")+(!0===u.value?" q-header--hidden":"")+(!0!==e.modelValue?" q-layout--prevent-focus":"")),p=computed(()=>{const e=a.rows.value.top,t={};return"l"===e[0]&&!0===a.left.space&&(t[!0===n.lang.rtl?"right":"left"]=`${a.left.size}px`),"r"===e[2]&&!0===a.right.space&&(t[!0===n.lang.rtl?"left":"right"]=`${a.right.size}px`),t});function v(e,t){a.update("header",e,t)}function m(e,t){e.value!==t&&(e.value=t)}function f({height:e}){m(l,e),v("size",e)}function g(e){!0===c.value&&m(i,!0),o("focusin",e)}watch(()=>e.modelValue,e=>{v("space",e),m(i,!0),a.animate()}),watch(s,e=>{v("offset",e)}),watch(()=>e.reveal,t=>{!1===t&&m(i,e.modelValue)}),watch(i,e=>{a.animate(),o("reveal",e)}),watch(a.scroll,t=>{!0===e.reveal&&m(i,"up"===t.direction||t.position<=e.revealOffset||t.position-t.inflectionPoint<100)});const b={};return a.instances.header=b,!0===e.modelValue&&v("size",l.value),v("space",e.modelValue),v("offset",s.value),onBeforeUnmount(()=>{a.instances.header===b&&(a.instances.header=void 0,v("size",0),v("offset",0),v("space",!1))}),()=>{const o=hUniqueSlot(t.default,[]);return!0===e.elevated&&o.push(h("div",{class:"q-layout__shadow absolute-full overflow-hidden no-pointer-events"})),o.push(h(QResizeObserver,{debounce:0,onResize:f})),h("header",{class:d.value,style:p.value,onFocusin:g},o)}}});const useRatioProps={ratio:[String,Number]};function useRatio(e,t){return computed(()=>{const o=Number(e.ratio||(void 0!==t?t.value:void 0));return!0!==isNaN(o)&&o>0?{paddingBottom:`${100/o}%`}:null})}const defaultRatio=16/9;var QImg=createComponent({name:"QImg",props:{...useRatioProps,src:String,srcset:String,sizes:String,alt:String,crossorigin:String,decoding:String,referrerpolicy:String,draggable:Boolean,loading:{type:String,default:"lazy"},width:String,height:String,initialRatio:{type:[Number,String],default:defaultRatio},placeholderSrc:String,fit:{type:String,default:"cover"},position:{type:String,default:"50% 50%"},imgClass:String,imgStyle:Object,noSpinner:Boolean,noNativeMenu:Boolean,noTransition:Boolean,spinnerColor:String,spinnerSize:String},emits:["load","error"],setup(e,{slots:t,emit:o}){const n=ref(e.initialRatio),a=useRatio(e,n);let l;const i=[ref(null),ref(void 0!==e.placeholderSrc?{src:e.placeholderSrc}:null)],r=ref(0),s=ref(!1),u=ref(!1),c=computed(()=>`q-img q-img--${!0===e.noNativeMenu?"no-":""}menu`),d=computed(()=>({width:e.width,height:e.height})),p=computed(()=>`q-img__image ${void 0!==e.imgClass?e.imgClass+" ":""}`+`q-img__image--with${!0===e.noTransition?"out":""}-transition`),v=computed(()=>({...e.imgStyle,objectFit:e.fit,objectPosition:e.position}));function m(){return e.src||e.srcset||e.sizes?{src:e.src,srcset:e.srcset,sizes:e.sizes}:null}function f(e){if(clearTimeout(l),u.value=!1,null===e)return s.value=!1,i[0].value=null,void(i[1].value=null);s.value=!0,i[r.value].value=e}function g({target:e}){null!==l&&(clearTimeout(l),n.value=0===e.naturalHeight?.5:e.naturalWidth/e.naturalHeight,b(e,1))}function b(e,t){null!==l&&1e3!==t&&(!0===e.complete?y(e):l=setTimeout(()=>{b(e,t+1)},50))}function y(e){null!==l&&(r.value=1===r.value?0:1,i[r.value].value=null,s.value=!1,u.value=!1,o("load",e.currentSrc||e.src))}function S(e){clearTimeout(l),s.value=!1,u.value=!0,i[0].value=null,i[1].value=null,o("error",e)}function w(e,t){return h("div",{class:"q-img__container absolute-full",key:e},t)}function C(t){const o=i[t].value,n={key:"img_"+t,class:p.value,style:v.value,crossorigin:e.crossorigin,decoding:e.decoding,referrerpolicy:e.referrerpolicy,height:e.height,width:e.width,loading:e.loading,"aria-hidden":"true",draggable:e.draggable,...o};return r.value===t?(n.class+=" q-img__image--waiting",Object.assign(n,{onLoad:g,onError:S})):n.class+=" q-img__image--loaded",w("img"+t,h("img",n))}function x(){return!0!==s.value?h("div",{key:"content",class:"q-img__content absolute-full q-anchor--skip"},hSlot(t[!0===u.value?"error":"default"])):h("div",{key:"loading",class:"q-img__loading absolute-full flex flex-center"},void 0!==t.loading?t.loading():!0===e.noSpinner?void 0:[h(QSpinner,{color:e.spinnerColor,size:e.spinnerSize})])}return watch(()=>m(),f),f(m()),onBeforeUnmount(()=>{clearTimeout(l),l=null}),()=>{const t=[];return null!==a.value&&t.push(h("div",{key:"filler",style:a.value})),!0!==u.value&&(null!==i[0].value&&t.push(C(0)),null!==i[1].value&&t.push(C(1))),t.push(h(Transition,{name:"q-transition--fade"},x)),h("div",{class:c.value,style:d.value,role:"img","aria-label":e.alt},t)}}});const{passive:passive$3}=listenOpts;var QInfiniteScroll=createComponent({name:"QInfiniteScroll",props:{offset:{type:Number,default:500},debounce:{type:[String,Number],default:100},scrollTarget:{default:void 0},initialIndex:Number,disable:Boolean,reverse:Boolean},emits:["load"],setup(e,{slots:t,emit:o}){const n=ref(!1),a=ref(!0),l=ref(null);let i,r,s=e.initialIndex||0;const u=computed(()=>"q-infinite-scroll__loading"+(!0===n.value?"":" invisible"));function c(){if(!0===e.disable||!0===n.value||!1===a.value)return;const t=getScrollHeight(i),o=getVerticalScrollPosition(i),l=height(i);!1===e.reverse?Math.round(o+l+e.offset)>=Math.round(t)&&d():Math.round(o)<=e.offset&&d()}function d(){if(!0===e.disable||!0===n.value||!1===a.value)return;s++,n.value=!0;const t=getScrollHeight(i);o("load",s,o=>{!0===a.value&&(n.value=!1,nextTick(()=>{if(!0===e.reverse){const e=getScrollHeight(i),o=getVerticalScrollPosition(i),n=e-t;setVerticalScrollPosition(i,o+n)}!0===o?m():l.value&&l.value.closest("body")&&r()}))})}function p(){s=0}function v(){!1===a.value&&(a.value=!0,i.addEventListener("scroll",r,passive$3)),c()}function m(){!0===a.value&&(a.value=!1,n.value=!1,i.removeEventListener("scroll",r,passive$3),void 0!==r&&r.cancel())}function f(){i&&!0===a.value&&i.removeEventListener("scroll",r,passive$3),i=getScrollTarget(l.value,e.scrollTarget),!0===a.value&&i.addEventListener("scroll",r,passive$3)}function g(e){s=e}const b=getCurrentInstance();function y(e){e=parseInt(e,10);const t=r;r=e<=0?c:debounce(c,!0===isNaN(e)?100:e),i&&!0===a.value&&(void 0!==t&&i.removeEventListener("scroll",t,passive$3),i.addEventListener("scroll",r,passive$3))}Object.assign(b.proxy,{poll:()=>{void 0!==r&&r()},trigger:d,stop:m,reset:p,resume:v,setIndex:g}),watch(()=>e.disable,e=>{!0===e?m():v()}),watch(()=>e.reverse,e=>{!1===n.value&&!0===a.value&&c()}),watch(()=>e.scrollTarget,f),watch(()=>e.debounce,y);let S=!1;return onActivated(()=>{!1!==S&&i&&setVerticalScrollPosition(i,S)}),onDeactivated(()=>{S=!!i&&getVerticalScrollPosition(i)}),onBeforeUnmount(()=>{!0===a.value&&i.removeEventListener("scroll",r,passive$3)}),onMounted(()=>{if(y(e.debounce),f(),!0===e.reverse){const e=getScrollHeight(i),t=height(i);setVerticalScrollPosition(i,e-t)}c()}),()=>{const o=hUniqueSlot(t.default,[]);return!0!==e.disable&&!0===a.value&&o[!1===e.reverse?"push":"unshift"](h("div",{class:u.value},hSlot(t.loading))),h("div",{class:"q-infinite-scroll",ref:l},o)}}}),QInnerLoading=createComponent({name:"QInnerLoading",props:{...useDarkProps,...useTransitionProps,showing:Boolean,color:String,size:{type:[String,Number],default:42},label:String,labelClass:String,labelStyle:[String,Array,Object]},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),{transition:a,transitionStyle:l}=useTransition(e,computed(()=>e.showing)),i=computed(()=>"q-inner-loading absolute-full column flex-center"+(!0===n.value?" q-inner-loading--dark":"")),r=computed(()=>"q-inner-loading__label"+(void 0!==e.labelClass?` ${e.labelClass}`:""));function s(){const t=[h(QSpinner,{size:e.size,color:e.color})];return void 0!==e.label&&t.push(h("div",{class:r.value,style:e.labelStyle},[e.label])),t}function u(){return!0===e.showing?h("div",{class:i.value,style:l.value},void 0!==t.default?t.default():s()):null}return()=>h(Transition,{name:a.value,appear:!0},u)}});const NAMED_MASKS={date:"####/##/##",datetime:"####/##/## ##:##",time:"##:##",fulltime:"##:##:##",phone:"(###) ### - ####",card:"#### #### #### ####"},TOKENS={"#":{pattern:"[\\d]",negate:"[^\\d]"},S:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]"},N:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]"},A:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:e=>e.toLocaleUpperCase()},a:{pattern:"[a-zA-Z]",negate:"[^a-zA-Z]",transform:e=>e.toLocaleLowerCase()},X:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:e=>e.toLocaleUpperCase()},x:{pattern:"[0-9a-zA-Z]",negate:"[^0-9a-zA-Z]",transform:e=>e.toLocaleLowerCase()}},KEYS=Object.keys(TOKENS);KEYS.forEach(e=>{TOKENS[e].regex=new RegExp(TOKENS[e].pattern)});const tokenRegexMask=new RegExp("\\\\([^.*+?^${}()|([\\]])|([.*+?^${}()|[\\]])|(["+KEYS.join("")+"])|(.)","g"),escRegex=/[.*+?^${}()|[\]\\]/g,MARKER=String.fromCharCode(1),useMaskProps={mask:String,reverseFillMask:Boolean,fillMask:[Boolean,String],unmaskedValue:Boolean};function useMask(e,t,o,n){let a,l,i,r;const s=ref(null),u=ref(d());function c(){return!0===e.autogrow||["textarea","text","search","url","tel","password"].includes(e.type)}function d(){if(v(),!0===s.value){const t=b(S(e.modelValue));return!1!==e.fillMask?w(t):t}return e.modelValue}function p(e){if(e<a.length)return a.slice(-e);let t="",o=a;const n=o.indexOf(MARKER);if(n>-1){for(let n=e-o.length;n>0;n--)t+=MARKER;o=o.slice(0,n)+t+o.slice(n)}return o}function v(){if(s.value=void 0!==e.mask&&e.mask.length>0&&c(),!1===s.value)return r=void 0,a="",void(l="");const t=void 0===NAMED_MASKS[e.mask]?e.mask:NAMED_MASKS[e.mask],o="string"===typeof e.fillMask&&e.fillMask.length>0?e.fillMask.slice(0,1):"_",n=o.replace(escRegex,"\\$&"),u=[],d=[],p=[];let v=!0===e.reverseFillMask,m="",f="";t.replace(tokenRegexMask,(e,t,o,n,a)=>{if(void 0!==n){const e=TOKENS[n];p.push(e),f=e.negate,!0===v&&(d.push("(?:"+f+"+)?("+e.pattern+"+)?(?:"+f+"+)?("+e.pattern+"+)?"),v=!1),d.push("(?:"+f+"+)?("+e.pattern+")?")}else if(void 0!==o)m="\\"+("\\"===o?"":o),p.push(o),u.push("([^"+m+"]+)?"+m+"?");else{const e=void 0!==t?t:a;m="\\"===e?"\\\\\\\\":e.replace(escRegex,"\\\\$&"),p.push(e),u.push("([^"+m+"]+)?"+m+"?")}});const h=new RegExp("^"+u.join("")+"("+(""===m?".":"[^"+m+"]")+"+)?$"),g=d.length-1,b=d.map((t,o)=>{return 0===o&&!0===e.reverseFillMask?new RegExp("^"+n+"*"+t):o===g?new RegExp("^"+t+"("+(""===f?".":f)+"+)?"+(!0===e.reverseFillMask?"$":n+"*")):new RegExp("^"+t)});i=p,r=(e=>{const t=h.exec(e);null!==t&&(e=t.slice(1).join(""));const o=[],n=b.length;for(let a=0,l=e;a<n;a++){const e=b[a].exec(l);if(null===e)break;l=l.slice(e.shift().length),o.push(...e)}return o.length>0?o.join(""):e}),a=p.map(e=>"string"===typeof e?e:MARKER).join(""),l=a.split(MARKER).join(o)}function m(t,i,r){const s=n.value,c=s.selectionEnd,d=s.value.length-c,p=S(t);!0===i&&v();const m=b(p),f=!1!==e.fillMask?w(m):m,g=u.value!==f;s.value!==f&&(s.value=f),!0===g&&(u.value=f),document.activeElement===s&&nextTick(()=>{if(f!==l)if("insertFromPaste"!==r||!0===e.reverseFillMask)if(["deleteContentBackward","deleteContentForward"].indexOf(r)>-1){const t=!0===e.reverseFillMask?0===c?f.length>m.length?1:0:Math.max(0,f.length-(f===l?0:Math.min(m.length,d)+1))+1:c;s.setSelectionRange(t,t,"forward")}else if(!0===e.reverseFillMask)if(!0===g){const e=Math.max(0,f.length-(f===l?0:Math.min(m.length,d+1)));1===e&&1===c?s.setSelectionRange(e,e,"forward"):h.rightReverse(s,e,e)}else{const e=f.length-d;s.setSelectionRange(e,e,"backward")}else if(!0===g){const e=Math.max(0,a.indexOf(MARKER),Math.min(m.length,c)-1);h.right(s,e,e)}else{const e=c-1;h.right(s,e,e)}else{const e=c-1;h.right(s,e,e)}else{const t=!0===e.reverseFillMask?l.length:0;s.setSelectionRange(t,t,"forward")}});const y=!0===e.unmaskedValue?S(f):f;e.modelValue!==y&&o(y,!0)}function f(e,t,o){const n=b(S(e.value));t=Math.max(0,a.indexOf(MARKER),Math.min(n.length,t)),e.setSelectionRange(t,o,"forward")}watch(()=>e.type+e.autogrow,v),watch(()=>e.mask,o=>{if(void 0!==o)m(u.value,!0);else{const o=S(u.value);v(),e.modelValue!==o&&t("update:modelValue",o)}}),watch(()=>e.fillMask+e.reverseFillMask,()=>{!0===s.value&&m(u.value,!0)}),watch(()=>e.unmaskedValue,()=>{!0===s.value&&m(u.value)});const h={left(e,t,o,n){const l=-1===a.slice(t-1).indexOf(MARKER);let i=Math.max(0,t-1);for(;i>=0;i--)if(a[i]===MARKER){t=i,!0===l&&t++;break}if(i<0&&void 0!==a[t]&&a[t]!==MARKER)return h.right(e,0,0);t>=0&&e.setSelectionRange(t,!0===n?o:t,"backward")},right(e,t,o,n){const l=e.value.length;let i=Math.min(l,o+1);for(;i<=l;i++){if(a[i]===MARKER){o=i;break}a[i-1]===MARKER&&(o=i)}if(i>l&&void 0!==a[o-1]&&a[o-1]!==MARKER)return h.left(e,l,l);e.setSelectionRange(n?t:o,o,"forward")},leftReverse(e,t,o,n){const a=p(e.value.length);let l=Math.max(0,t-1);for(;l>=0;l--){if(a[l-1]===MARKER){t=l;break}if(a[l]===MARKER&&(t=l,0===l))break}if(l<0&&void 0!==a[t]&&a[t]!==MARKER)return h.rightReverse(e,0,0);t>=0&&e.setSelectionRange(t,!0===n?o:t,"backward")},rightReverse(e,t,o,n){const a=e.value.length,l=p(a),i=-1===l.slice(0,o+1).indexOf(MARKER);let r=Math.min(a,o+1);for(;r<=a;r++)if(l[r-1]===MARKER){o=r,o>0&&!0===i&&o--;break}if(r>a&&void 0!==l[o-1]&&l[o-1]!==MARKER)return h.leftReverse(e,a,a);e.setSelectionRange(!0===n?t:o,o,"forward")}};function g(t){if(!0===shouldIgnoreKey(t))return;const o=n.value,a=o.selectionStart,l=o.selectionEnd;if(37===t.keyCode||39===t.keyCode){const n=h[(39===t.keyCode?"right":"left")+(!0===e.reverseFillMask?"Reverse":"")];t.preventDefault(),n(o,a,l,t.shiftKey)}else 8===t.keyCode&&!0!==e.reverseFillMask&&a===l?h.left(o,a,l,!0):46===t.keyCode&&!0===e.reverseFillMask&&a===l&&h.rightReverse(o,a,l,!0)}function b(t){if(void 0===t||null===t||""===t)return"";if(!0===e.reverseFillMask)return y(t);const o=i;let n=0,a="";for(let e=0;e<o.length;e++){const l=t[n],i=o[e];if("string"===typeof i)a+=i,l===i&&n++;else{if(void 0===l||!i.regex.test(l))return a;a+=void 0!==i.transform?i.transform(l):l,n++}}return a}function y(e){const t=i,o=a.indexOf(MARKER);let n=e.length-1,l="";for(let a=t.length-1;a>=0&&n>-1;a--){const i=t[a];let r=e[n];if("string"===typeof i)l=i+l,r===i&&n--;else{if(void 0===r||!i.regex.test(r))return l;do{l=(void 0!==i.transform?i.transform(r):r)+l,n--,r=e[n]}while(o===a&&void 0!==r&&i.regex.test(r))}}return l}function S(e){return"string"!==typeof e||void 0===r?"number"===typeof e?r(""+e):e:r(e)}function w(t){return l.length-t.length<=0?t:!0===e.reverseFillMask&&t.length>0?l.slice(0,-t.length)+t:t+l.slice(t.length)}return{innerValue:u,hasMask:s,moveCursorForPaste:f,updateMaskValue:m,onMaskedKeydown:g}}const isJapanese=/[\u3000-\u303f\u3040-\u309f\u30a0-\u30ff\uff00-\uff9f\u4e00-\u9faf\u3400-\u4dbf]/,isChinese=/[\u4e00-\u9fff\u3400-\u4dbf\u{20000}-\u{2a6df}\u{2a700}-\u{2b73f}\u{2b740}-\u{2b81f}\u{2b820}-\u{2ceaf}\uf900-\ufaff\u3300-\u33ff\ufe30-\ufe4f\uf900-\ufaff\u{2f800}-\u{2fa1f}]/u,isKorean=/[\u3131-\u314e\u314f-\u3163\uac00-\ud7a3]/;function useKeyComposition(e){return function(t){if("compositionend"===t.type||"change"===t.type){if(!0!==t.target.composing)return;t.target.composing=!1,e(t)}else"compositionupdate"===t.type?"string"===typeof t.data&&!1===isJapanese.test(t.data)&&!1===isChinese.test(t.data)&&!1===isKorean.test(t.data)&&(t.target.composing=!1):t.target.composing=!0}}var QInput=createComponent({name:"QInput",inheritAttrs:!1,props:{...useFieldProps,...useMaskProps,...useFormProps,modelValue:{required:!1},shadowText:String,type:{type:String,default:"text"},debounce:[String,Number],autogrow:Boolean,inputClass:[Array,String,Object],inputStyle:[Array,String,Object]},emits:[...useFieldEmits,"paste","change"],setup(e,{emit:t,attrs:o}){const n={};let a,l,i,r,s=NaN;const u=ref(null),c=useFormInputNameAttr(e),{innerValue:d,hasMask:p,moveCursorForPaste:v,updateMaskValue:m,onMaskedKeydown:f}=useMask(e,t,$,u),g=useFileFormDomProps(e,!0),b=computed(()=>fieldValueIsFilled(d.value)),y=useKeyComposition(P),S=useFieldState(),w=computed(()=>"textarea"===e.type||!0===e.autogrow),C=computed(()=>!0===w.value||["text","search","url","tel","password"].includes(e.type)),x=computed(()=>{const t={...S.splitAttrs.listeners.value,onInput:P,onPaste:T,onChange:B,onBlur:Q,onFocus:stop};return t.onCompositionstart=t.onCompositionupdate=t.onCompositionend=y,!0===p.value&&(t.onKeydown=f),!0===e.autogrow&&(t.onAnimationend=M),t}),k=computed(()=>{const t={tabindex:0,"data-autofocus":!0===e.autofocus||void 0,rows:"textarea"===e.type?6:void 0,"aria-label":e.label,name:c.value,...S.splitAttrs.attributes.value,id:S.targetUid.value,maxlength:e.maxlength,disabled:!0===e.disable,readonly:!0===e.readonly};return!1===w.value&&(t.type=e.type),!0===e.autogrow&&(t.rows=1),t});function _(){addFocusFn(()=>{const e=document.activeElement;null===u.value||u.value===e||null!==e&&e.id===S.targetUid.value||u.value.focus({preventScroll:!0})})}function q(){null!==u.value&&u.value.select()}function T(o){if(!0===p.value&&!0!==e.reverseFillMask){const e=o.target;v(e,e.selectionStart,e.selectionEnd)}t("paste",o)}function P(o){if(!o||!o.target||!0===o.target.composing)return;if("file"===e.type)return void t("update:modelValue",o.target.files);const n=o.target.value;if(!0===p.value)m(n,!1,o.inputType);else if($(n),!0===C.value&&o.target===document.activeElement){const{selectionStart:e,selectionEnd:t}=o.target;void 0!==e&&void 0!==t&&nextTick(()=>{o.target===document.activeElement&&0===n.indexOf(o.target.value)&&o.target.setSelectionRange(e,t)})}!0===e.autogrow&&M()}function $(o,u){r=(()=>{"number"!==e.type&&!0===n.hasOwnProperty("value")&&delete n.value,e.modelValue!==o&&s!==o&&(!0===u&&(l=!0),t("update:modelValue",o),nextTick(()=>{s===o&&(s=NaN)})),r=void 0}),"number"===e.type&&(a=!0,n.value=o),void 0!==e.debounce?(clearTimeout(i),n.value=o,i=setTimeout(r,e.debounce)):r()}function M(){const e=u.value;if(null!==e){const t=e.parentNode.style;t.marginBottom=e.scrollHeight-1+"px",e.style.height="1px",e.style.height=e.scrollHeight+"px",t.marginBottom=""}}function B(e){y(e),clearTimeout(i),void 0!==r&&r(),t("change",e.target.value)}function Q(t){void 0!==t&&stop(t),clearTimeout(i),void 0!==r&&r(),a=!1,l=!1,delete n.value,"file"!==e.type&&setTimeout(()=>{null!==u.value&&(u.value.value=void 0!==d.value?d.value:"")})}function E(){return!0===n.hasOwnProperty("value")?n.value:void 0!==d.value?d.value:""}watch(()=>e.type,()=>{u.value&&(u.value.value=e.modelValue)}),watch(()=>e.modelValue,t=>{if(!0===p.value){if(!0===l)return void(l=!1);m(t)}else d.value!==t&&(d.value=t,"number"===e.type&&!0===n.hasOwnProperty("value")&&(!0===a?a=!1:delete n.value));!0===e.autogrow&&nextTick(M)}),watch(()=>e.autogrow,e=>{!0===e?nextTick(M):null!==u.value&&o.rows>0&&(u.value.style.height="auto")}),watch(()=>e.dense,()=>{!0===e.autogrow&&nextTick(M)}),onBeforeUnmount(()=>{Q()}),onMounted(()=>{!0===e.autogrow&&M()}),Object.assign(S,{innerValue:d,fieldClass:computed(()=>`q-${!0===w.value?"textarea":"input"}`+(!0===e.autogrow?" q-textarea--autogrow":"")),hasShadow:computed(()=>"file"!==e.type&&"string"===typeof e.shadowText&&e.shadowText.length>0),inputRef:u,emitValue:$,hasValue:b,floatingLabel:computed(()=>!0===b.value||fieldValueIsFilled(e.displayValue)),getControl:()=>{return h(!0===w.value?"textarea":"input",{ref:u,class:["q-field__native q-placeholder",e.inputClass],style:e.inputStyle,...k.value,...x.value,..."file"!==e.type?{value:E()}:g.value})},getShadowControl:()=>{return h("div",{class:"q-field__native q-field__shadow absolute-bottom no-pointer-events"+(!0===w.value?"":" text-no-wrap")},[h("span",{class:"invisible"},E()),h("span",e.shadowText)])}});const O=useField(S),R=getCurrentInstance();return Object.assign(R.proxy,{focus:_,select:q,getNativeElement:()=>u.value}),O}});const defaultCfg$1={threshold:0,root:null,rootMargin:"0px"};function update$3(e,t,o){let n,a,l;"function"===typeof o?(n=o,a=defaultCfg$1,l=void 0===t.cfg):(n=o.handler,a=Object.assign({},defaultCfg$1,o.cfg),l=void 0===t.cfg||!1===isDeepEqual(t.cfg,a)),t.handler!==n&&(t.handler=n),!0===l&&(t.cfg=a,void 0!==t.observer&&t.observer.unobserve(e),t.observer=new IntersectionObserver(([o])=>{if("function"===typeof t.handler){if(null===o.rootBounds&&!0===document.body.contains(e))return t.observer.unobserve(e),void t.observer.observe(e);const n=t.handler(o,t.observer);(!1===n||!0===t.once&&!0===o.isIntersecting)&&destroy$1(e)}},a),t.observer.observe(e))}function destroy$1(e){const t=e.__qvisible;void 0!==t&&(void 0!==t.observer&&t.observer.unobserve(e),delete e.__qvisible)}var Intersection=createDirective({name:"intersection",mounted(e,{modifiers:t,value:o}){const n={once:!0===t.once};update$3(e,n,o),e.__qvisible=n},updated(e,t){const o=e.__qvisible;void 0!==o&&update$3(e,o,t.value)},beforeUnmount:destroy$1}),QIntersection=createComponent({name:"QIntersection",props:{tag:{type:String,default:"div"},once:Boolean,transition:String,transitionDuration:{type:[String,Number],default:300},ssrPrerender:Boolean,margin:String,threshold:[Number,Array],root:{default:null},disable:Boolean,onVisibility:Function},setup(e,{slots:t,emit:o}){const n=ref(!0===isRuntimeSsrPreHydration.value&&e.ssrPrerender),a=computed(()=>void 0!==e.root||void 0!==e.margin||void 0!==e.threshold?{handler:s,cfg:{root:e.root,rootMargin:e.margin,threshold:e.threshold}}:s),l=computed(()=>!0!==e.disable&&(!0!==isRuntimeSsrPreHydration.value||!0!==e.once||!0!==e.ssrPrerender)),i=computed(()=>{return[[Intersection,a.value,void 0,{once:e.once}]]}),r=computed(()=>`--q-transition-duration: ${e.transitionDuration}ms`);function s(t){n.value!==t.isIntersecting&&(n.value=t.isIntersecting,void 0!==e.onVisibility&&o("visibility",n.value))}function u(){return!0===n.value?[h("div",{key:"content",style:r.value},hSlot(t.default))]:void 0}return()=>{const t=e.transition?[h(Transition,{name:"q-transition--"+e.transition},u)]:u();return hDir(e.tag,{class:"q-intersection"},t,"main",l.value,()=>i.value)}}}),QList=createComponent({name:"QList",props:{...useDarkProps,bordered:Boolean,dense:Boolean,separator:Boolean,padding:Boolean},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>"q-list"+(!0===e.bordered?" q-list--bordered":"")+(!0===e.dense?" q-list--dense":"")+(!0===e.separator?" q-list--separator":"")+(!0===n.value?" q-list--dark":"")+(!0===e.padding?" q-list--padding":""));return()=>h("div",{class:a.value},hSlot(t.default))}});const keyCodes$1=[34,37,40,33,39,38],commonPropsName=Object.keys(useCircularCommonProps);var QKnob=createComponent({name:"QKnob",props:{...useFormProps,...useCircularCommonProps,modelValue:{type:Number,required:!0},step:{type:Number,default:1,validator:e=>e>=0},tabindex:{type:[Number,String],default:0},disable:Boolean,readonly:Boolean},emits:["update:modelValue","change","drag-value"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=ref(e.modelValue),i=ref(!1);let r,s;watch(()=>e.modelValue,t=>{if(t<e.min)l.value=e.min;else{if(!(t>e.max))return void(t!==l.value&&(l.value=t));l.value=e.max}l.value!==e.modelValue&&(o("update:modelValue",l.value),o("change",l.value))});const u=computed(()=>!1===e.disable&&!1===e.readonly),c=computed(()=>"q-knob non-selectable"+(!0===u.value?" q-knob--editable":!0===e.disable?" disabled":"")),d=computed(()=>(String(e.step).trim("0").split(".")[1]||"").length),p=computed(()=>0===e.step?1:e.step),v=computed(()=>!0===e.instantFeedback||!0===i.value),m=!0===a.platform.is.mobile?computed(()=>!0===u.value?{onClick:C}:{}):computed(()=>!0===u.value?{onMousedown:w,onClick:C,onKeydown:x,onKeyup:_}:{}),f=computed(()=>!0===u.value?{tabindex:e.tabindex}:{[`aria-${!0===e.disable?"disabled":"readonly"}`]:"true"}),g=computed(()=>{const t={};return commonPropsName.forEach(o=>{t[o]=e[o]}),t});function b(e){e.isFinal?(k(e.evt,!0),i.value=!1):e.isFirst?(S(),i.value=!0,k(e.evt)):k(e.evt)}const y=computed(()=>{return[[TouchPan,b,void 0,{prevent:!0,stop:!0,mouse:!0}]]});function S(){const{top:e,left:t,width:o,height:n}=s.getBoundingClientRect();r={top:e+n/2,left:t+o/2}}function w(e){S(),k(e)}function C(e){S(),k(e,!0)}function x(t){if(!keyCodes$1.includes(t.keyCode))return;stopAndPrevent(t);const o=([34,33].includes(t.keyCode)?10:1)*p.value,n=[34,37,40].includes(t.keyCode)?-o:o;l.value=between(parseFloat((l.value+n).toFixed(d.value)),e.min,e.max),q()}function k(t,n){const i=position(t),s=Math.abs(i.top-r.top),u=Math.sqrt(s**2+Math.abs(i.left-r.left)**2);let c=Math.asin(s/u)*(180/Math.PI);c=i.top<r.top?r.left<i.left?90-c:270+c:r.left<i.left?c+90:270-c,e.angle&&(c=normalizeToInterval(c-e.angle,0,360)),!0===a.lang.rtl&&(c=360-c);let v=e.min+c/360*(e.max-e.min);if(0!==p.value){const e=v%p.value;v=v-e+(Math.abs(e)>=p.value/2?(e<0?-1:1)*p.value:0),v=parseFloat(v.toFixed(d.value))}v=between(v,e.min,e.max),o("drag-value",v),l.value!==v&&(l.value=v),q(n)}function _(e){keyCodes$1.includes(e.keyCode)&&q(!0)}function q(t){e.modelValue!==l.value&&o("update:modelValue",l.value),!0===t&&o("change",l.value)}const T=useFormAttrs(e);function P(){return h("input",T.value)}return onMounted(()=>{s=n.$el}),()=>{const o={class:c.value,role:"slider","aria-valuemin":e.min,"aria-valuemax":e.max,"aria-valuenow":e.modelValue,...f.value,...g.value,value:l.value,instantFeedback:v.value,...m.value},n={default:t.default};return!0===u.value?(void 0!==e.name&&(n.internal=P),withDirectives(h(QCircularProgress,o,n),y.value)):h(QCircularProgress,o,n)}}});const{passive:passive$2}=listenOpts,axisValues=["both","horizontal","vertical"];var QScrollObserver=createComponent({name:"QScrollObserver",props:{axis:{type:String,validator:e=>axisValues.includes(e),default:"vertical"},debounce:[String,Number],scrollTarget:{default:void 0}},emits:["scroll"],setup(e,{emit:t}){const o={position:{top:0,left:0},direction:"down",directionChanged:!1,delta:{top:0,left:0},inflectionPoint:{top:0,left:0}};let n,a,l=null;function i(){null!==l&&l();const a=Math.max(0,getVerticalScrollPosition(n)),i=getHorizontalScrollPosition(n),r={top:a-o.position.top,left:i-o.position.left};if("vertical"===e.axis&&0===r.top||"horizontal"===e.axis&&0===r.left)return;const s=Math.abs(r.top)>=Math.abs(r.left)?r.top<0?"up":"down":r.left<0?"left":"right";o.position={top:a,left:i},o.directionChanged=o.direction!==s,o.delta=r,!0===o.directionChanged&&(o.direction=s,o.inflectionPoint=o.position),t("scroll",{...o})}function r(){n=getScrollTarget(a,e.scrollTarget),n.addEventListener("scroll",u,passive$2),u(!0)}function s(){void 0!==n&&(n.removeEventListener("scroll",u,passive$2),n=void 0)}function u(t){if(!0===t||0===e.debounce||"0"===e.debounce)i();else if(null===l){const[t,o]=e.debounce?[setTimeout(i,e.debounce),clearTimeout]:[requestAnimationFrame(i),cancelAnimationFrame];l=(()=>{o(t),l=null})}}watch(()=>e.scrollTarget,()=>{s(),r()});const c=getCurrentInstance();return onMounted(()=>{a=c.proxy.$el.parentNode,r()}),onBeforeUnmount(()=>{null!==l&&l(),s()}),Object.assign(c.proxy,{trigger:u,getPosition:()=>o}),noop}}),QLayout=createComponent({name:"QLayout",props:{container:Boolean,view:{type:String,default:"hhh lpr fff",validator:e=>/^(h|l)h(h|r) lpr (f|l)f(f|r)$/.test(e.toLowerCase())},onScroll:Function,onScrollHeight:Function,onResize:Function},setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=ref(null),l=ref(n.screen.height),i=ref(!0===e.container?0:n.screen.width),r=ref({position:0,direction:"down",inflectionPoint:0}),s=ref(0),u=ref(!0===isRuntimeSsrPreHydration.value?0:getScrollbarWidth()),c=computed(()=>"q-layout q-layout--"+(!0===e.container?"containerized":"standard")),d=computed(()=>!1===e.container?{minHeight:n.screen.height+"px"}:null),p=computed(()=>0!==u.value?{[!0===n.lang.rtl?"left":"right"]:`${u.value}px`}:null),v=computed(()=>0!==u.value?{[!0===n.lang.rtl?"right":"left"]:0,[!0===n.lang.rtl?"left":"right"]:`-${u.value}px`,width:`calc(100% + ${u.value}px)`}:null);function m(t){if(!0===e.container||!0!==document.qScrollPrevented){const n={position:t.position.top,direction:t.direction,directionChanged:t.directionChanged,inflectionPoint:t.inflectionPoint.top,delta:t.delta.top};r.value=n,void 0!==e.onScroll&&o("scroll",n)}}function f(t){const{height:n,width:a}=t;let r=!1;l.value!==n&&(r=!0,l.value=n,void 0!==e.onScrollHeight&&o("scroll-height",n),b()),i.value!==a&&(r=!0,i.value=a),!0===r&&void 0!==e.onResize&&o("resize",t)}function g({height:e}){s.value!==e&&(s.value=e,b())}function b(){if(!0===e.container){const e=l.value>s.value?getScrollbarWidth():0;u.value!==e&&(u.value=e)}}let y;const S={instances:{},view:computed(()=>e.view),isContainer:computed(()=>e.container),rootRef:a,height:l,containerHeight:s,scrollbarWidth:u,totalWidth:computed(()=>i.value+u.value),rows:computed(()=>{const t=e.view.toLowerCase().split(" ");return{top:t[0].split(""),middle:t[1].split(""),bottom:t[2].split("")}}),header:reactive({size:0,offset:0,space:!1}),right:reactive({size:300,offset:0,space:!1}),footer:reactive({size:0,offset:0,space:!1}),left:reactive({size:300,offset:0,space:!1}),scroll:r,animate(){void 0!==y?clearTimeout(y):document.body.classList.add("q-body--layout-animate"),y=setTimeout(()=>{document.body.classList.remove("q-body--layout-animate"),y=void 0},155)},update(e,t,o){S[e][t]=o}};if(provide(layoutKey,S),getScrollbarWidth()>0){let t=null;const o=document.body;function w(){t=null,o.classList.remove("hide-scrollbar")}function C(){if(null===t){if(o.scrollHeight>n.screen.height)return;o.classList.add("hide-scrollbar")}else clearTimeout(t);t=setTimeout(w,300)}function x(e){null!==t&&"remove"===e&&(clearTimeout(t),w()),window[`${e}EventListener`]("resize",C)}watch(()=>!0!==e.container?"add":"remove",x),!0!==e.container&&x("add"),onUnmounted(()=>{x("remove")})}return()=>{const o=hMergeSlot(t.default,[h(QScrollObserver,{onScroll:m}),h(QResizeObserver,{onResize:f})]),n=h("div",{class:c.value,style:d.value,ref:!0===e.container?void 0:a},o);return!0===e.container?h("div",{class:"q-layout-container overflow-hidden",ref:a},[h(QResizeObserver,{onResize:g}),h("div",{class:"absolute-full",style:p.value},[h("div",{class:"scroll",style:v.value},[n])])]):n}}});const separatorValues=["horizontal","vertical","cell","none"];var QMarkupTable=createComponent({name:"QMarkupTable",props:{...useDarkProps,dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,wrapCells:Boolean,separator:{type:String,default:"horizontal",validator:e=>separatorValues.includes(e)}},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>"q-markup-table q-table__container q-table__card"+` q-table--${e.separator}-separator`+(!0===n.value?" q-table--dark q-table__card--dark q-dark":"")+(!0===e.dense?" q-table--dense":"")+(!0===e.flat?" q-table--flat":"")+(!0===e.bordered?" q-table--bordered":"")+(!0===e.square?" q-table--square":"")+(!1===e.wrapCells?" q-table--no-wrap":""));return()=>h("div",{class:a.value},[h("table",{class:"q-table"},hSlot(t.default))])}}),QNoSsr=createComponent({name:"QNoSsr",props:{tag:{type:String,default:"div"},placeholder:String},setup(e,{slots:t}){const o=useCanRender();return()=>{const n={};if(!0===o.value){const o=hSlot(t.default);return void 0===o?o:o.length>1?h(e.tag,n,o):o[0]}n.class="q-no-ssr-placeholder";const a=hSlot(t.placeholder);return void 0!==a?a.length>1?h(e.tag,n,a):a[0]:void 0!==e.placeholder?h(e.tag,n,e.placeholder):void 0}}});const svg$m=h("svg",{key:"svg",class:"q-radio__bg absolute non-selectable",viewBox:"0 0 24 24","aria-hidden":"true"},[h("path",{d:"M12,22a10,10 0 0 1 -10,-10a10,10 0 0 1 10,-10a10,10 0 0 1 10,10a10,10 0 0 1 -10,10m0,-22a12,12 0 0 0 -12,12a12,12 0 0 0 12,12a12,12 0 0 0 12,-12a12,12 0 0 0 -12,-12"}),h("path",{class:"q-radio__check",d:"M12,6a6,6 0 0 0 -6,6a6,6 0 0 0 6,6a6,6 0 0 0 6,-6a6,6 0 0 0 -6,-6"})]);var QRadio=createComponent({name:"QRadio",props:{...useDarkProps,...useSizeProps,...useFormProps,modelValue:{required:!0},val:{required:!0},label:String,leftLabel:Boolean,checkedIcon:String,uncheckedIcon:String,color:String,keepColor:Boolean,dense:Boolean,disable:Boolean,tabindex:[String,Number]},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),a=useDark(e,n.$q),l=useSize(e,optionSizes),i=ref(null),{refocusTargetEl:r,refocusTarget:s}=useRefocusTarget(e,i),u=computed(()=>e.modelValue===e.val),c=computed(()=>"q-radio cursor-pointer no-outline row inline no-wrap items-center"+(!0===e.disable?" disabled":"")+(!0===a.value?" q-radio--dark":"")+(!0===e.dense?" q-radio--dense":"")+(!0===e.leftLabel?" reverse":"")),d=computed(()=>{const t=void 0===e.color||!0!==e.keepColor&&!0!==u.value?"":` text-${e.color}`;return"q-radio__inner relative-position "+`q-radio__inner--${!0===u.value?"truthy":"falsy"}${t}`}),p=computed(()=>(!0===u.value?e.checkedIcon:e.uncheckedIcon)||null),v=computed(()=>!0===e.disable?-1:e.tabindex||0),m=computed(()=>{const t={type:"radio"};return void 0!==e.name&&Object.assign(t,{"^checked":!0===u.value?"checked":void 0,name:e.name,value:e.val}),t}),f=useFormInject(m);function g(t){void 0!==t&&(stopAndPrevent(t),s(t)),!0!==e.disable&&!0!==u.value&&o("update:modelValue",e.val,t)}function b(e){13!==e.keyCode&&32!==e.keyCode||stopAndPrevent(e)}function y(e){13!==e.keyCode&&32!==e.keyCode||g(e)}return Object.assign(n,{set:g}),()=>{const o=null!==p.value?[h("div",{key:"icon",class:"q-radio__icon-container absolute flex flex-center no-wrap"},[h(QIcon,{class:"q-radio__icon",name:p.value})])]:[svg$m];!0!==e.disable&&f(o,"unshift"," q-radio__native q-ma-none q-pa-none");const n=[h("div",{class:d.value,style:l.value},o)];null!==r.value&&n.push(r.value);const a=void 0!==e.label?hMergeSlot(t.default,[e.label]):hSlot(t.default);return void 0!==a&&n.push(h("div",{class:"q-radio__label q-anchor--skip"},a)),h("div",{ref:i,class:c.value,tabindex:v.value,role:"radio","aria-label":e.label,"aria-checked":!0===u.value?"true":"false","aria-disabled":!0===e.disable?"true":void 0,onClick:g,onKeydown:b,onKeyup:y},n)}}}),QToggle=createComponent({name:"QToggle",props:{...useCheckboxProps,icon:String,iconColor:String},emits:useCheckboxEmits,setup(e){function t(t,o){const n=computed(()=>(!0===t.value?e.checkedIcon:!0===o.value?e.indeterminateIcon:e.uncheckedIcon)||e.icon),a=computed(()=>!0===t.value?e.iconColor:null);return()=>[h("div",{class:"q-toggle__track"}),h("div",{class:"q-toggle__thumb absolute flex flex-center no-wrap"},void 0!==n.value?[h(QIcon,{name:n.value,color:a.value})]:void 0)]}return useCheckbox("toggle",t)}});const components$1={radio:QRadio,checkbox:QCheckbox,toggle:QToggle},typeValues=Object.keys(components$1);var QOptionGroup=createComponent({name:"QOptionGroup",props:{...useDarkProps,modelValue:{required:!0},options:{type:Array,validator:e=>e.every(e=>"value"in e&&"label"in e)},name:String,type:{default:"radio",validator:e=>typeValues.includes(e)},color:String,keepColor:Boolean,dense:Boolean,size:String,leftLabel:Boolean,inline:Boolean,disable:Boolean},emits:["update:modelValue"],setup(e,{emit:t,slots:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=Array.isArray(e.modelValue);"radio"===e.type?!0===a&&console.error("q-option-group: model should not be array"):!1===a&&console.error("q-option-group: model should be array in your case");const l=useDark(e,n),i=computed(()=>components$1[e.type]),r=computed(()=>"q-option-group q-gutter-x-sm"+(!0===e.inline?" q-option-group--inline":"")),s=computed(()=>{const t={};return"radio"===e.type&&(t.role="radiogroup",!0===e.disable&&(t["aria-disabled"]="true")),t});function u(e){t("update:modelValue",e)}return()=>h("div",{class:r.value,...s.value},e.options.map((t,n)=>{const a=void 0!==o["label-"+n]?()=>o["label-"+n](t):void 0!==o.label?()=>o.label(t):void 0;return h("div",[h(i.value,{modelValue:e.modelValue,val:t.value,name:void 0===t.name?e.name:t.name,disable:e.disable||t.disable,label:void 0===a?t.label:null,leftLabel:void 0===t.leftLabel?e.leftLabel:t.leftLabel,color:void 0===t.color?e.color:t.color,checkedIcon:t.checkedIcon,uncheckedIcon:t.uncheckedIcon,dark:t.dark||l.value,size:void 0===t.size?e.size:t.size,dense:e.dense,keepColor:void 0===t.keepColor?e.keepColor:t.keepColor,"onUpdate:modelValue":u},a)])}))}}),QPage=createComponent({name:"QPage",props:{padding:Boolean,styleFn:Function},setup(e,{slots:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=inject(layoutKey);inject(pageContainerKey,()=>{console.error("QPage needs to be child of QPageContainer")});const a=computed(()=>{const t=(!0===n.header.space?n.header.size:0)+(!0===n.footer.space?n.footer.size:0);if("function"===typeof e.styleFn){const a=!0===n.isContainer.value?n.containerHeight.value:o.screen.height;return e.styleFn(t,a)}return{minHeight:!0===n.isContainer.value?n.containerHeight.value-t+"px":0===o.screen.height?0!==t?`calc(100vh - ${t}px)`:"100vh":o.screen.height-t+"px"}}),l=computed(()=>`q-page ${!0===e.padding?" q-layout-padding":""}`);return()=>h("main",{class:l.value,style:a.value},hSlot(t.default))}}),QPageContainer=createComponent({name:"QPageContainer",setup(e,{slots:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=inject(layoutKey,()=>{console.error("QPageContainer needs to be child of QLayout")});provide(pageContainerKey,!0);const a=computed(()=>{const e={};return!0===n.header.space&&(e.paddingTop=`${n.header.size}px`),!0===n.right.space&&(e[`padding${!0===o.lang.rtl?"Left":"Right"}`]=`${n.right.size}px`),!0===n.footer.space&&(e.paddingBottom=`${n.footer.size}px`),!0===n.left.space&&(e[`padding${!0===o.lang.rtl?"Right":"Left"}`]=`${n.left.size}px`),e});return()=>h("div",{class:"q-page-container",style:a.value},hSlot(t.default))}});const usePageStickyProps={position:{type:String,default:"bottom-right",validator:e=>["top-right","top-left","bottom-right","bottom-left","top","right","bottom","left"].includes(e)},offset:{type:Array,validator:e=>2===e.length},expand:Boolean};function usePageSticky(){const{props:e,proxy:t}=getCurrentInstance(),{$q:o}=t,n=inject(layoutKey,()=>{console.error("QPageSticky needs to be child of QLayout")}),a=computed(()=>{const t=e.position;return{top:t.indexOf("top")>-1,right:t.indexOf("right")>-1,bottom:t.indexOf("bottom")>-1,left:t.indexOf("left")>-1,vertical:"top"===t||"bottom"===t,horizontal:"left"===t||"right"===t}}),l=computed(()=>n.header.offset),i=computed(()=>n.right.offset),r=computed(()=>n.footer.offset),s=computed(()=>n.left.offset),u=computed(()=>{let t=0,n=0;const u=a.value,c=!0===o.lang.rtl?-1:1;!0===u.top&&0!==l.value?n=`${l.value}px`:!0===u.bottom&&0!==r.value&&(n=`${-r.value}px`),!0===u.left&&0!==s.value?t=`${c*s.value}px`:!0===u.right&&0!==i.value&&(t=`${-c*i.value}px`);const d={transform:`translate(${t}, ${n})`};return e.offset&&(d.margin=`${e.offset[1]}px ${e.offset[0]}px`),!0===u.vertical?(0!==s.value&&(d[!0===o.lang.rtl?"right":"left"]=`${s.value}px`),0!==i.value&&(d[!0===o.lang.rtl?"left":"right"]=`${i.value}px`)):!0===u.horizontal&&(0!==l.value&&(d.top=`${l.value}px`),0!==r.value&&(d.bottom=`${r.value}px`)),d}),c=computed(()=>`q-page-sticky row flex-center fixed-${e.position}`+` q-page-sticky--${!0===e.expand?"expand":"shrink"}`);function d(t){const o=hSlot(t.default);return h("div",{class:c.value,style:u.value},!0===e.expand?o:[h("div",o)])}return{$layout:n,getStickyContent:d}}var QPageScroller=createComponent({name:"QPageScroller",props:{...usePageStickyProps,scrollOffset:{type:Number,default:1e3},reverse:Boolean,duration:{type:Number,default:300},offset:{default:()=>[18,18]}},emits:["click"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),{$layout:a,getStickyContent:l}=usePageSticky(),i=ref(null);let r;const s=computed(()=>a.height.value-(!0===a.isContainer.value?a.containerHeight.value:n.screen.height));function u(){return!0===e.reverse?s.value-a.scroll.value.position>e.scrollOffset:a.scroll.value.position>e.scrollOffset}const c=ref(u());function d(){const e=u();c.value!==e&&(c.value=e)}function p(){!0===e.reverse?void 0===r&&(r=watch(s,d)):v()}function v(){void 0!==r&&(r(),r=void 0)}function m(t){const n=getScrollTarget(!0===a.isContainer.value?i.value:a.rootRef.value);setVerticalScrollPosition(n,!0===e.reverse?a.height.value:0,e.duration),o("click",t)}function f(){return!0===c.value?h("div",{ref:i,class:"q-page-scroller",onClick:m},l(t)):null}return watch(a.scroll,d),watch(()=>e.reverse,p),p(),onBeforeUnmount(v),()=>h(Transition,{name:"q-transition--fade"},f)}}),QPageSticky=createComponent({name:"QPageSticky",props:usePageStickyProps,setup(e,{slots:t}){const{getStickyContent:o}=usePageSticky();return()=>o(t)}}),QPagination=createComponent({name:"QPagination",props:{...useDarkProps,modelValue:{type:Number,required:!0},min:{type:Number,default:1},max:{type:Number,required:!0},color:{type:String,default:"primary"},textColor:String,activeColor:String,activeTextColor:String,inputStyle:[Array,String,Object],inputClass:[Array,String,Object],size:String,disable:Boolean,input:Boolean,iconPrev:String,iconNext:String,iconFirst:String,iconLast:String,toFn:Function,boundaryLinks:{type:Boolean,default:null},boundaryNumbers:{type:Boolean,default:null},directionLinks:{type:Boolean,default:null},ellipses:{type:Boolean,default:null},maxPages:{type:Number,default:0,validator:e=>e>=0},ripple:{type:[Boolean,Object],default:null},round:Boolean,rounded:Boolean,flat:Boolean,outline:Boolean,unelevated:Boolean,push:Boolean,glossy:Boolean,dense:Boolean,padding:{type:String,default:"3px 2px"}},emits:["update:modelValue"],setup(e,{emit:t}){const{proxy:o}=getCurrentInstance(),{$q:n}=o,a=useDark(e,n),l=ref(null),i=computed({get:()=>e.modelValue,set:o=>{if(o=parseInt(o,10),e.disable||isNaN(o))return;const n=between(o,e.min,e.max);e.modelValue!==n&&t("update:modelValue",n)}});function r(e,t){return[!0,!1].includes(e)?e:t}watch(()=>e.min+e.max,()=>{i.value=e.modelValue});const s=computed(()=>"q-pagination row no-wrap items-center"+(!0===e.disable?" disabled":"")),u=computed(()=>i.value+" / "+e.max),c=computed(()=>r(e.boundaryLinks,e.input)),d=computed(()=>r(e.boundaryNumbers,!e.input)),p=computed(()=>r(e.directionLinks,e.input)),v=computed(()=>r(e.ellipses,!e.input)),m=computed(()=>{const t=[e.iconFirst||n.iconSet.pagination.first,e.iconPrev||n.iconSet.pagination.prev,e.iconNext||n.iconSet.pagination.next,e.iconLast||n.iconSet.pagination.last];return!0===n.lang.rtl?t.reverse():t}),f=computed(()=>!0===e.disable?{"aria-disabled":"true"}:{}),g=computed(()=>({round:e.round,rounded:e.rounded,outline:e.outline,unelevated:e.unelevated,push:e.push,glossy:e.glossy,dense:e.dense,padding:e.padding,color:e.color,flat:!0,size:e.size,ripple:null===e.ripple||e.ripple})),b=computed(()=>({flat:e.flat,color:e.activeColor||e.color,textColor:e.activeTextColor||e.textColor}));function y(e){i.value=e}function S(e){i.value=i.value+e}function w(){i.value=l.value,l.value=null}function C(t,o){const n={...g.value,...t};return void 0!==o&&(void 0!==e.toFn?n.to=e.toFn(o):n.onClick=(()=>y(o))),h(QBtn,n)}return Object.assign(o,{set:y,setByOffset:S}),()=>{const t=[],o=[],n=[];if(c.value&&(t.push(C({key:"bls",disable:e.disable||e.modelValue<=e.min,icon:m.value[0]},e.min)),o.unshift(C({key:"ble",disable:e.disable||e.modelValue>=e.max,icon:m.value[3]},e.max))),p.value&&(t.push(C({key:"bdp",disable:e.disable||e.modelValue<=e.min,icon:m.value[1]},e.modelValue-1)),o.unshift(C({key:"bdn",disable:e.disable||e.modelValue>=e.max,icon:m.value[2]},e.modelValue+1))),!0===e.input)n.push(h(QInput,{class:"inline",style:{width:`${u.value.length/1.5}em`},type:"number",dense:!0,value:l.value,disable:e.disable,dark:a.value,borderless:!0,inputClass:e.inputClass,inputStyle:e.inputStyle,placeholder:u.value,min:e.min,max:e.max,"onUpdate:modelValue"(e){l.value=e},onKeyup(e){!0===isKeyCode(e,13)&&w()},onBlur:w}));else{let a=Math.max(e.maxPages,1+(v.value?2:0)+(d.value?2:0)),l=e.min,i=e.max,r=!1,s=!1,u=!1,c=!1;e.maxPages&&a<e.max-e.min+1&&(a=1+2*Math.floor(a/2),l=Math.max(e.min,Math.min(e.max-a+1,e.modelValue-Math.floor(a/2))),i=Math.min(e.max,l+a-1),d.value&&(u=!0,l+=1),v.value&&l>e.min+(d.value?1:0)&&(r=!0,l+=1),d.value&&(c=!0,i-=1),v.value&&i<e.max-(d.value?1:0)&&(s=!0,i-=1));const p={minWidth:`${Math.max(2,String(e.max).length)}em`};if(u){const o=e.min===e.modelValue;t.push(C({key:"bns",style:p,disable:e.disable,flat:!o,label:e.min,...o?b.value:{}},e.min))}if(c){const t=e.max===e.modelValue;o.unshift(C({key:"bne",style:p,disable:e.disable,flat:!t,label:e.max,...t?b.value:{}},e.max))}r&&t.push(C({key:"bes",style:p,disable:e.disable,label:"…",ripple:!1},l-1)),s&&o.unshift(C({key:"bee",style:p,disable:e.disable,label:"…",ripple:!1},i+1));for(let t=l;t<=i;t++){const o={key:`bpg${t}`,style:p,disable:e.disable,label:t};t===e.modelValue&&Object.assign(o,b.value),n.push(C(o,t))}}return h("div",{class:s.value,...f.value},[t,h("div",{class:"row justify-center"},[n]),o])}}});const{passive:passive$1}=listenOpts;var QParallax=createComponent({name:"QParallax",props:{src:String,height:{type:Number,default:500},speed:{type:Number,default:1,validator:e=>e>=0&&e<=1},scrollTarget:{default:void 0},onScroll:Function},setup(e,{slots:t,emit:o}){const n=ref(0),a=ref(null),l=ref(null),i=ref(null);let r,s,u,c,d,p;watch(()=>e.height,()=>{!0===r&&m()}),watch(()=>e.scrollTarget,()=>{!0===r&&(y(),b())});let v=t=>{n.value=t,void 0!==e.onScroll&&o("scroll",t)};function m(){let t,o,n;p===window?(t=0,n=o=window.innerHeight):(t=offset(p).top,o=height(p),n=t+o);const l=offset(a.value).top,i=l+e.height;if(void 0!==d||i>t&&l<n){const t=(n-l)/(e.height+o);f((u-e.height)*t*e.speed),v(t)}}let f=e=>{s.style.transform=`translate3d(-50%,${Math.round(e)}px,0)`};function g(){u=s.naturalHeight||s.videoHeight||height(s),!0===r&&m()}function b(){r=!0,p=getScrollTarget(a.value,e.scrollTarget),p.addEventListener("scroll",m,passive$1),window.addEventListener("resize",c,passive$1),m()}function y(){!0===r&&(r=!1,p.removeEventListener("scroll",m,passive$1),window.removeEventListener("resize",c,passive$1),p=void 0,f.cancel(),v.cancel(),c.cancel())}return onMounted(()=>{f=frameDebounce(f),v=frameDebounce(v),c=frameDebounce(g),s=void 0!==t.media?l.value.children[0]:i.value,s.onload=s.onloadstart=s.loadedmetadata=g,g(),s.style.display="initial",void 0!==window.IntersectionObserver?(d=new IntersectionObserver(e=>{const t=!0===e[0].isIntersecting?b:y;t()}),d.observe(a.value)):b()}),onBeforeUnmount(()=>{y(),void 0!==d&&d.disconnect(),s.onload=s.onloadstart=s.loadedmetadata=null}),()=>{return h("div",{ref:a,class:"q-parallax",style:{height:`${e.height}px`}},[h("div",{ref:l,class:"q-parallax__media absolute-full"},void 0!==t.media?t.media():[h("img",{ref:i,src:e.src})]),h("div",{class:"q-parallax__content absolute-full column flex-center"},void 0!==t.content?t.content({percentScrolled:n.value}):hSlot(t.default))])}}}),QPopupEdit=createComponent({name:"QPopupEdit",props:{modelValue:{required:!0},title:String,buttons:Boolean,labelSet:String,labelCancel:String,color:{type:String,default:"primary"},validate:{type:Function,default:()=>!0},autoSave:Boolean,cover:{type:Boolean,default:!0},disable:Boolean},emits:["update:modelValue","save","cancel","before-show","show","before-hide","hide"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=ref(null),i=ref(""),r=ref("");let s=!1;const u=computed(()=>{const t={initialValue:i.value,validate:e.validate,set:c,cancel:d,updatePosition:p};return injectProp(t,"value",()=>r.value,e=>{r.value=e}),t});function c(){!1!==e.validate(r.value)&&(!0===v()&&(o("save",r.value,i.value),o("update:modelValue",r.value)),m())}function d(){!0===v()&&o("cancel",r.value,i.value),m()}function p(){nextTick(()=>{l.value.updatePosition()})}function v(){return!1===isDeepEqual(r.value,i.value)}function m(){s=!0,l.value.hide()}function f(){s=!1,i.value=cloneDeep(e.modelValue),r.value=cloneDeep(e.modelValue),o("before-show")}function g(){o("show")}function b(){!1===s&&!0===v()&&(!0===e.autoSave&&!0===e.validate(r.value)?(o("save",r.value,i.value),o("update:modelValue",r.value)):o("cancel",r.value,i.value)),o("before-hide")}function y(){o("hide")}function S(){const o=void 0!==t.default?[].concat(t.default(u.value)):[];return e.title&&o.unshift(h("div",{class:"q-dialog__title q-mt-sm q-mb-sm"},e.title)),!0===e.buttons&&o.push(h("div",{class:"q-popup-edit__buttons row justify-center no-wrap"},[h(QBtn,{flat:!0,color:e.color,label:e.labelCancel||a.lang.label.cancel,onClick:d}),h(QBtn,{flat:!0,color:e.color,label:e.labelSet||a.lang.label.set,onClick:c})])),o}return Object.assign(n,{set:c,cancel:d,show(e){null!==l.value&&l.value.show(e)},hide(e){null!==l.value&&l.value.hide(e)},updatePosition:p}),()=>{if(!0!==e.disable)return h(QMenu,{ref:l,class:"q-popup-edit",cover:e.cover,onBeforeShow:f,onShow:g,onBeforeHide:b,onHide:y,onEscapeKey:d},S)}}}),QPopupProxy=createComponent({name:"QPopupProxy",props:{...useAnchorProps,breakpoint:{type:[String,Number],default:450}},emits:["show","hide"],setup(e,{slots:t,emit:o,attrs:n}){const{proxy:a}=getCurrentInstance(),{$q:l}=a,i=ref(!1),r=ref(null),s=computed(()=>parseInt(e.breakpoint,10)),{canShow:u}=useAnchor({showing:i});function c(){return l.screen.width<s.value||l.screen.height<s.value?"dialog":"menu"}const d=ref(c()),p=computed(()=>"menu"===d.value?{maxHeight:"99vh"}:{});function v(e){i.value=!0,o("show",e)}function m(e){i.value=!1,d.value=c(),o("hide",e)}return watch(()=>c(),e=>{!0!==i.value&&(d.value=e)}),Object.assign(a,{show(e){!0===u(e)&&r.value.show(e)},hide(e){r.value.hide(e)},toggle(e){r.value.toggle(e)}}),()=>{const o={ref:r,...p.value,...n,onShow:v,onHide:m};let a;return"dialog"===d.value?a=QDialog:(a=QMenu,Object.assign(o,{target:e.target,contextMenu:e.contextMenu,noParentEvent:!0,separateClosePopup:!0})),h(a,o,t.default)}}});const defaultSizes={xs:2,sm:4,md:6,lg:10,xl:14};function width(e,t,o){return{transform:!0===t?`translateX(${!0===o.lang.rtl?"-":""}100%) scale3d(${-e},1,1)`:`scale3d(${e},1,1)`}}var QLinearProgress=createComponent({name:"QLinearProgress",props:{...useDarkProps,...useSizeProps,value:{type:Number,default:0},buffer:Number,color:String,trackColor:String,reverse:Boolean,stripe:Boolean,indeterminate:Boolean,query:Boolean,rounded:Boolean,animationSpeed:{type:[String,Number],default:2100},instantFeedback:Boolean},setup(e,{slots:t}){const{proxy:o}=getCurrentInstance(),n=useDark(e,o.$q),a=useSize(e,defaultSizes),l=computed(()=>!0===e.indeterminate||!0===e.query),i=computed(()=>e.reverse!==e.query),r=computed(()=>({...null!==a.value?a.value:{},"--q-linear-progress-speed":`${e.animationSpeed}ms`})),s=computed(()=>"q-linear-progress"+(void 0!==e.color?` text-${e.color}`:"")+(!0===e.reverse||!0===e.query?" q-linear-progress--reverse":"")+(!0===e.rounded?" rounded-borders":"")),u=computed(()=>width(void 0!==e.buffer?e.buffer:1,i.value,o.$q)),c=computed(()=>"q-linear-progress__track absolute-full"+` q-linear-progress__track--with${!0===e.instantFeedback?"out":""}-transition`+` q-linear-progress__track--${!0===n.value?"dark":"light"}`+(void 0!==e.trackColor?` bg-${e.trackColor}`:"")),d=computed(()=>width(!0===l.value?1:e.value,i.value,o.$q)),p=computed(()=>"q-linear-progress__model absolute-full"+` q-linear-progress__model--with${!0===e.instantFeedback?"out":""}-transition`+` q-linear-progress__model--${!0===l.value?"in":""}determinate`),v=computed(()=>({width:`${100*e.value}%`})),m=computed(()=>`q-linear-progress__stripe absolute-${!0===e.reverse?"right":"left"}`);return()=>{const o=[h("div",{class:c.value,style:u.value}),h("div",{class:p.value,style:d.value})];return!0===e.stripe&&!1===l.value&&o.push(h("div",{class:m.value,style:v.value})),h("div",{class:s.value,style:r.value,role:"progressbar","aria-valuemin":0,"aria-valuemax":1,"aria-valuenow":!0===e.indeterminate?void 0:e.value},hMergeSlot(t.default,o))}}});const PULLER_HEIGHT=40,OFFSET_TOP=20;var QPullToRefresh=createComponent({name:"QPullToRefresh",props:{color:String,bgColor:String,icon:String,noMouse:Boolean,disable:Boolean,scrollTarget:{default:void 0}},emits:["refresh"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=ref("pull"),i=ref(0),r=ref(!1),s=ref(-PULLER_HEIGHT),u=ref(!1),c=ref({}),d=computed(()=>({opacity:i.value,transform:`translateY(${s.value}px) rotate(${360*i.value}deg)`})),p=computed(()=>"q-pull-to-refresh__puller row flex-center"+(!0===u.value?" q-pull-to-refresh__puller--animating":"")+(void 0!==e.bgColor?` bg-${e.bgColor}`:""));function v(e){if(!0===e.isFinal)return void(!0===r.value&&(r.value=!1,"pulled"===l.value?(l.value="refreshing",b({pos:OFFSET_TOP}),g()):"pull"===l.value&&b({pos:-PULLER_HEIGHT,ratio:0})));if(!0===u.value||"refreshing"===l.value)return!1;if(!0===e.isFirst){if(0!==getVerticalScrollPosition(S)||"down"!==e.direction)return!0===r.value&&(r.value=!1,l.value="pull",b({pos:-PULLER_HEIGHT,ratio:0})),!1;r.value=!0;const{top:t,left:o}=y.getBoundingClientRect();c.value={top:t+"px",left:o+"px",width:window.getComputedStyle(y).getPropertyValue("width")}}prevent(e.evt);const t=Math.min(140,Math.max(0,e.distance.y));s.value=t-PULLER_HEIGHT,i.value=between(t/(OFFSET_TOP+PULLER_HEIGHT),0,1);const o=s.value>OFFSET_TOP?"pulled":"pull";l.value!==o&&(l.value=o)}const m=computed(()=>{const t={down:!0,mightPrevent:!0};return!0!==e.noMouse&&(t.mouse=!0),[[TouchPan,v,void 0,t]]}),f=computed(()=>`q-pull-to-refresh__content${!0===r.value?" no-pointer-events":""}`);function g(){o("refresh",()=>{b({pos:-PULLER_HEIGHT,ratio:0},()=>{l.value="pull"})})}function b({pos:e,ratio:t},o){u.value=!0,s.value=e,void 0!==t&&(i.value=t),clearTimeout(w),w=setTimeout(()=>{u.value=!1,o&&o()},300)}let y,S,w;function C(){S=getScrollTarget(y,e.scrollTarget)}return Object.assign(n,{trigger:g,updateScrollTarget:C}),watch(()=>e.scrollTarget,C),onMounted(()=>{y=n.$el,C()}),onBeforeUnmount(()=>{clearTimeout(w)}),()=>{const o=[h("div",{class:f.value},hSlot(t.default)),h("div",{class:"q-pull-to-refresh__puller-container fixed row flex-center no-pointer-events z-top",style:c.value},[h("div",{class:p.value,style:d.value},["refreshing"!==l.value?h(QIcon,{name:e.icon||a.iconSet.pullToRefresh.icon,color:e.color,size:"32px"}):h(QSpinner,{size:"24px",color:e.color})])])];return hDir("div",{class:"q-pull-to-refresh"},o,"main",!1===e.disable,()=>m.value)}}});const dragType={MIN:0,RANGE:1,MAX:2};var QRange=createComponent({name:"QRange",props:{...useSliderProps,modelValue:{type:Object,default:()=>({min:null,max:null}),validator:e=>"min"in e&&"max"in e},dragRange:Boolean,dragOnlyRange:Boolean,leftLabelColor:String,leftLabelTextColor:String,rightLabelColor:String,rightLabelTextColor:String,leftLabelValue:[String,Number],rightLabelValue:[String,Number],leftThumbColor:String,rightThumbColor:String},emits:useSliderEmits,setup(e,{emit:t}){const{proxy:{$q:o}}=getCurrentInstance(),{state:n,methods:a}=useSlider({updateValue:_,updatePosition:T,getDragging:q,formAttrs:computed(()=>({type:"hidden",name:e.name,value:`${e.modelValue.min}|${e.modelValue.max}`}))}),l=ref(null),i=ref(0),r=ref(0),s=ref({min:0,max:0});function u(){s.value.min=null===e.modelValue.min?n.innerMin.value:between(e.modelValue.min,n.innerMin.value,n.innerMax.value),s.value.max=null===e.modelValue.max?n.innerMax.value:between(e.modelValue.max,n.innerMin.value,n.innerMax.value)}watch(()=>`${e.modelValue.min}|${e.modelValue.max}|${n.innerMin.value}|${n.innerMax.value}`,u),u();const c=computed(()=>a.convertModelToRatio(s.value.min)),d=computed(()=>a.convertModelToRatio(s.value.max)),p=computed(()=>!0===n.active.value?i.value:c.value),v=computed(()=>!0===n.active.value?r.value:d.value),m=computed(()=>{const t={[n.positionProp.value]:`${100*p.value}%`,[n.sizeProp.value]:`${100*(v.value-p.value)}%`};return void 0!==e.selectionImg&&(t.backgroundImage=`url(${e.selectionImg}) !important`),t}),f=computed(()=>{if(!0!==n.editable.value)return{};if(!0===o.platform.is.mobile)return{onClick:a.onMobileClick};const t={onMousedown:a.onActivate};return!0!==e.dragRange&&!0!==e.dragOnlyRange||Object.assign(t,{onFocus:()=>{n.focus.value="both"},onBlur:a.onBlur,onKeydown:P,onKeyup:a.onKeyup}),t});function g(t){return!0!==o.platform.is.mobile&&!0===n.editable.value&&!0!==e.dragOnlyRange?{onFocus:()=>{n.focus.value=t},onBlur:a.onBlur,onKeydown:P,onKeyup:a.onKeyup}:{}}const b=computed(()=>!0!==e.dragOnlyRange?n.tabindex.value:null),y=computed(()=>!0===o.platform.is.mobile||!e.dragRange&&!0!==e.dragOnlyRange?null:n.tabindex.value),S=ref(null),w=computed(()=>g("min")),C=a.getThumbRenderFn({focusValue:"min",getNodeData:()=>({ref:S,key:"tmin",...w.value,tabindex:b.value}),ratio:p,label:computed(()=>void 0!==e.leftLabelValue?e.leftLabelValue:s.value.min),thumbColor:computed(()=>e.leftThumbColor||e.thumbColor||e.color),labelColor:computed(()=>e.leftLabelColor||e.labelColor),labelTextColor:computed(()=>e.leftLabelTextColor||e.labelTextColor)}),x=computed(()=>g("max")),k=a.getThumbRenderFn({focusValue:"max",getNodeData:()=>({...x.value,key:"tmax",tabindex:b.value}),ratio:v,label:computed(()=>void 0!==e.rightLabelValue?e.rightLabelValue:s.value.max),thumbColor:computed(()=>e.rightThumbColor||e.thumbColor||e.color),labelColor:computed(()=>e.rightLabelColor||e.labelColor),labelTextColor:computed(()=>e.rightLabelTextColor||e.labelTextColor)});function _(o){s.value.min===e.modelValue.min&&s.value.max===e.modelValue.max||t("update:modelValue",{...s.value}),!0===o&&t("change",{...s.value})}function q(t){const{left:o,top:n,width:i,height:r}=l.value.getBoundingClientRect(),u=!0===e.dragOnlyRange?0:!0===e.vertical?S.value.offsetHeight/(2*r):S.value.offsetWidth/(2*i),p={left:o,top:n,width:i,height:r,valueMin:s.value.min,valueMax:s.value.max,ratioMin:c.value,ratioMax:d.value},v=a.getDraggingRatio(t,p);return!0!==e.dragOnlyRange&&v<p.ratioMin+u?p.type=dragType.MIN:!0===e.dragOnlyRange||v<p.ratioMax-u?!0===e.dragRange||!0===e.dragOnlyRange?(p.type=dragType.RANGE,Object.assign(p,{offsetRatio:v,offsetModel:a.convertRatioToModel(v),rangeValue:p.valueMax-p.valueMin,rangeRatio:p.ratioMax-p.ratioMin})):p.type=p.ratioMax-v<v-p.ratioMin?dragType.MAX:dragType.MIN:p.type=dragType.MAX,p}function T(t,o=n.dragging.value){let l;const u=a.getDraggingRatio(t,o),c=a.convertRatioToModel(u);switch(o.type){case dragType.MIN:u<=o.ratioMax?(l={minR:u,maxR:o.ratioMax,min:c,max:o.valueMax},n.focus.value="min"):(l={minR:o.ratioMax,maxR:u,min:o.valueMax,max:c},n.focus.value="max");break;case dragType.MAX:u>=o.ratioMin?(l={minR:o.ratioMin,maxR:u,min:o.valueMin,max:c},n.focus.value="max"):(l={minR:u,maxR:o.ratioMin,min:c,max:o.valueMin},n.focus.value="min");break;case dragType.RANGE:const t=u-o.offsetRatio,a=between(o.ratioMin+t,0,1-o.rangeRatio),i=c-o.offsetModel,r=between(o.valueMin+i,e.min,e.max-o.rangeValue);l={minR:a,maxR:a+o.rangeRatio,min:parseFloat(r.toFixed(n.decimals.value)),max:parseFloat((r+o.rangeValue).toFixed(n.decimals.value))},n.focus.value="both";break}s.value=null===s.value.min||null===s.value.max?{min:l.min||e.min,max:l.max||e.max}:{min:l.min,max:l.max},!0!==e.snap||0===e.step?(i.value=l.minR,r.value=l.maxR):(i.value=a.convertModelToRatio(s.value.min),r.value=a.convertModelToRatio(s.value.max))}function P(e){if(!keyCodes$2.includes(e.keyCode))return;stopAndPrevent(e);const t=([34,33].includes(e.keyCode)?10:1)*n.step.value,o=([34,37,40].includes(e.keyCode)?-1:1)*(!0===n.isReversed.value?-1:1)*t;if("both"===n.focus.value){const e=s.value.max-s.value.min,t=between(parseFloat((s.value.min+o).toFixed(n.decimals.value)),n.innerMin.value,n.innerMax.value-e);s.value={min:t,max:parseFloat((t+e).toFixed(n.decimals.value))}}else{if(!1===n.focus.value)return;{const e=n.focus.value;s.value={...s.value,[e]:between(parseFloat((s.value[e]+o).toFixed(n.decimals.value)),"min"===e?n.innerMin.value:s.value.min,"max"===e?n.innerMax.value:s.value.max)}}}_()}return()=>{const t=a.getContent(m,y,f,e=>{e.push(C(),k())});return h("div",{ref:l,class:"q-range "+n.classes.value+(null===e.modelValue.min||null===e.modelValue.max?" q-slider--no-value":""),...n.attributes.value,"aria-valuenow":e.modelValue.min+"|"+e.modelValue.max},t)}}}),QRating=createComponent({name:"QRating",props:{...useSizeProps,...useFormProps,modelValue:{type:Number,required:!0},max:{type:[String,Number],default:5},icon:[String,Array],iconHalf:[String,Array],iconSelected:[String,Array],color:[String,Array],colorHalf:[String,Array],colorSelected:[String,Array],noReset:Boolean,noDimming:Boolean,readonly:Boolean,disable:Boolean},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useSize(e),l=useFormAttrs(e),i=useFormInject(l),r=ref(0);let s={};const u=computed(()=>!0!==e.readonly&&!0!==e.disable),c=computed(()=>"q-rating row inline items-center"+` q-rating--${!0===u.value?"":"non-"}editable`+(!0===e.noDimming?" q-rating--no-dimming":"")+(!0===e.disable?" disabled":"")+(void 0!==e.color&&!1===Array.isArray(e.color)?` text-${e.color}`:"")),d=computed(()=>{const t=!0===Array.isArray(e.icon)?e.icon.length:0,o=!0===Array.isArray(e.iconSelected)?e.iconSelected.length:0,n=!0===Array.isArray(e.iconHalf)?e.iconHalf.length:0,a=!0===Array.isArray(e.color)?e.color.length:0,l=!0===Array.isArray(e.colorSelected)?e.colorSelected.length:0,i=!0===Array.isArray(e.colorHalf)?e.colorHalf.length:0;return{iconLen:t,icon:t>0?e.icon[t-1]:e.icon,selIconLen:o,selIcon:o>0?e.iconSelected[o-1]:e.iconSelected,halfIconLen:n,halfIcon:n>0?e.iconHalf[o-1]:e.iconHalf,colorLen:a,color:a>0?e.color[a-1]:e.color,selColorLen:l,selColor:l>0?e.colorSelected[l-1]:e.colorSelected,halfColorLen:i,halfColor:i>0?e.colorHalf[i-1]:e.colorHalf}}),p=computed(()=>{const t=[],o=d.value,a=Math.ceil(e.modelValue),l=void 0===e.iconHalf||a===e.modelValue?-1:a;for(let i=1;i<=e.max;i++){const s=0===r.value&&e.modelValue>=i||r.value>0&&r.value>=i,u=l===i&&r.value<i,c=r.value>0&&(!0===u?a:e.modelValue)>=i&&r.value<i,d=!0===u?i<=o.halfColorLen?e.colorHalf[i-1]:o.halfColor:void 0!==o.selColor&&!0===s?i<=o.selColorLen?e.colorSelected[i-1]:o.selColor:i<=o.colorLen?e.color[i-1]:o.color;t.push({name:(!0===u?i<=o.halfIconLen?e.iconHalf[i-1]:o.halfIcon:void 0===o.selIcon||!0!==s&&!0!==c?i<=o.iconLen?e.icon[i-1]:o.icon:i<=o.selIconLen?e.iconSelected[i-1]:o.selIcon)||n.iconSet.rating.icon,classes:"q-rating__icon"+(!0===s||!0===u?" q-rating__icon--active":"")+(!0===c?" q-rating__icon--exselected":"")+(r.value===i?" q-rating__icon--hovered":"")+(void 0!==d?` text-${d}`:"")})}return t}),v=computed(()=>{return!0===e.disable?{"aria-disabled":"true"}:!0===e.readonly?{"aria-readonly":"true"}:void 0}),m=computed(()=>!0===u.value?0:null);function f(t){if(!0===u.value){const n=between(parseInt(t,10),1,parseInt(e.max,10)),a=!0!==e.noReset&&e.modelValue===n?0:n;a!==e.modelValue&&o("update:modelValue",a),r.value=0}}function g(e){!0===u.value&&(r.value=e)}function b(e,t){switch(e.keyCode){case 13:case 32:return f(t),stopAndPrevent(e);case 37:case 40:return s[`rt${t-1}`]&&s[`rt${t-1}`].$el.focus(),stopAndPrevent(e);case 39:case 38:return s[`rt${t+1}`]&&s[`rt${t+1}`].$el.focus(),stopAndPrevent(e)}}function y(){r.value=0}return onBeforeUpdate(()=>{s={}}),()=>{const o=[];return p.value.forEach(({classes:e,name:n},a)=>{const l=a+1;o.push(h("div",{key:l,ref:e=>{s[`rt${l}`]=e},class:"q-rating__icon-container flex flex-center",tabindex:m.value,onClick(){f(l)},onMouseover(){g(l)},onMouseout:y,onFocus(){g(l)},onBlur:y,onKeyup(e){b(e,l)}},hMergeSlot(t[`tip-${l}`],[h(QIcon,{class:e,name:n})])))}),void 0!==e.name&&!0!==e.disable&&i(o,"push"),h("div",{class:c.value,style:a.value,...v.value},o)}}}),QResponsive=createComponent({name:"QResponsive",props:useRatioProps,setup(e,{slots:t}){const o=useRatio(e);return()=>h("div",{class:"q-responsive"},[h("div",{class:"q-responsive__filler overflow-hidden"},[h("div",{style:o.value})]),h("div",{class:"q-responsive__content absolute-full fit"},hSlot(t.default))])}});const axisList=["vertical","horizontal"],dirProps={vertical:{offset:"offsetY",scroll:"scrollTop",dir:"down",dist:"y"},horizontal:{offset:"offsetX",scroll:"scrollLeft",dir:"right",dist:"x"}},panOpts={prevent:!0,mouse:!0,mouseAllDir:!0};var QScrollArea=createComponent({name:"QScrollArea",props:{...useDarkProps,thumbStyle:Object,verticalThumbStyle:Object,horizontalThumbStyle:Object,barStyle:[Array,String,Object],verticalBarStyle:[Array,String,Object],horizontalBarStyle:[Array,String,Object],contentStyle:[Array,String,Object],contentActiveStyle:[Array,String,Object],delay:{type:[String,Number],default:1e3},visible:{type:Boolean,default:null},tabindex:[String,Number],onScroll:Function},setup(e,{slots:t,emit:o}){const n=ref(!1),a=ref(!1),l=ref(!1),i={vertical:ref(0),horizontal:ref(0)},r={vertical:{ref:ref(null),position:ref(0),size:ref(0)},horizontal:{ref:ref(null),position:ref(0),size:ref(0)}},s=getCurrentInstance(),u=useDark(e,s.proxy.$q);let c,d;const p=ref(null),v=computed(()=>"q-scrollarea"+(!0===u.value?" q-scrollarea--dark":""));r.vertical.percentage=computed(()=>{const e=r.vertical.size.value-i.vertical.value;if(e<=0)return 0;const t=between(r.vertical.position.value/e,0,1);return Math.round(1e4*t)/1e4}),r.vertical.thumbHidden=computed(()=>!0!==(null===e.visible?l.value:e.visible)&&!1===n.value&&!1===a.value||r.vertical.size.value<=i.vertical.value+1),r.vertical.thumbStart=computed(()=>r.vertical.percentage.value*(i.vertical.value-r.vertical.thumbSize.value)),r.vertical.thumbSize=computed(()=>Math.round(between(i.vertical.value*i.vertical.value/r.vertical.size.value,50,i.vertical.value))),r.vertical.style=computed(()=>{return{...e.thumbStyle,...e.verticalThumbStyle,top:`${r.vertical.thumbStart.value}px`,height:`${r.vertical.thumbSize.value}px`}}),r.vertical.thumbClass=computed(()=>"q-scrollarea__thumb q-scrollarea__thumb--v absolute-right"+(!0===r.vertical.thumbHidden.value?" q-scrollarea__thumb--invisible":"")),r.vertical.barClass=computed(()=>"q-scrollarea__bar q-scrollarea__bar--v absolute-right"+(!0===r.vertical.thumbHidden.value?" q-scrollarea__bar--invisible":"")),r.horizontal.percentage=computed(()=>{const e=r.horizontal.size.value-i.horizontal.value;if(e<=0)return 0;const t=between(r.horizontal.position.value/e,0,1);return Math.round(1e4*t)/1e4}),r.horizontal.thumbHidden=computed(()=>!0!==(null===e.visible?l.value:e.visible)&&!1===n.value&&!1===a.value||r.horizontal.size.value<=i.horizontal.value+1),r.horizontal.thumbStart=computed(()=>r.horizontal.percentage.value*(i.horizontal.value-r.horizontal.thumbSize.value)),r.horizontal.thumbSize=computed(()=>Math.round(between(i.horizontal.value*i.horizontal.value/r.horizontal.size.value,50,i.horizontal.value))),r.horizontal.style=computed(()=>{return{...e.thumbStyle,...e.horizontalThumbStyle,left:`${r.horizontal.thumbStart.value}px`,width:`${r.horizontal.thumbSize.value}px`}}),r.horizontal.thumbClass=computed(()=>"q-scrollarea__thumb q-scrollarea__thumb--h absolute-bottom"+(!0===r.horizontal.thumbHidden.value?" q-scrollarea__thumb--invisible":"")),r.horizontal.barClass=computed(()=>"q-scrollarea__bar q-scrollarea__bar--h absolute-bottom"+(!0===r.horizontal.thumbHidden.value?" q-scrollarea__bar--invisible":""));const m=computed(()=>!0===r.vertical.thumbHidden.value&&!0===r.horizontal.thumbHidden.value?e.contentStyle:e.contentActiveStyle),f=[[TouchPan,e=>{k(e,"vertical")},void 0,{vertical:!0,...panOpts}]],g=[[TouchPan,e=>{k(e,"horizontal")},void 0,{horizontal:!0,...panOpts}]];function b(){const e={};return axisList.forEach(t=>{const o=r[t];e[t+"Position"]=o.position.value,e[t+"Percentage"]=o.percentage.value,e[t+"Size"]=o.size.value,e[t+"ContainerSize"]=i[t].value}),e}const y=debounce(()=>{const e=b();e.ref=s.proxy,o("scroll",e)},0);function S(e,t,o){if(!1===axisList.includes(e))return void console.error("[QScrollArea]: wrong first param of setScrollPosition (vertical/horizontal)");const n="vertical"===e?setVerticalScrollPosition:setHorizontalScrollPosition;n(p.value,t,o)}function w({height:e,width:t}){let o=!1;i.vertical.value!==e&&(i.vertical.value=e,o=!0),i.horizontal.value!==t&&(i.horizontal.value=t,o=!0),!0===o&&P()}function C({position:e}){let t=!1;r.vertical.position.value!==e.top&&(r.vertical.position.value=e.top,t=!0),r.horizontal.position.value!==e.left&&(r.horizontal.position.value=e.left,t=!0),!0===t&&P()}function x({height:e,width:t}){r.horizontal.size.value!==t&&(r.horizontal.size.value=t,P()),r.vertical.size.value!==e&&(r.vertical.size.value=e,P())}function k(e,t){const o=r[t];if(!0===e.isFirst){if(!0===o.thumbHidden.value)return;d=o.position.value,a.value=!0}else if(!0!==a.value)return;!0===e.isFinal&&(a.value=!1);const n=dirProps[t],l=i[t].value,s=(o.size.value-l)/(l-o.thumbSize.value),u=e.distance[n.dist],c=d+(e.direction===n.dir?1:-1)*u*s;$(c,t)}function _(e,t){const o=r[t];if(!0!==o.thumbHidden.value){const n=e[dirProps[t].offset];if(n<o.thumbStart.value||n>o.thumbStart.value+o.thumbSize.value){const e=n-o.thumbSize.value/2;$(e/i[t].value*o.size.value,t)}null!==o.ref.value&&o.ref.value.dispatchEvent(new MouseEvent(e.type,e))}}function q(e){_(e,"vertical")}function T(e){_(e,"horizontal")}function P(){!0===n.value?clearTimeout(c):n.value=!0,c=setTimeout(()=>{n.value=!1},e.delay),void 0!==e.onScroll&&y()}function $(e,t){p.value[dirProps[t].scroll]=e}function M(){l.value=!0}function B(){l.value=!1}Object.assign(s.proxy,{getScrollTarget:()=>p.value,getScroll:b,getScrollPosition:()=>({top:r.vertical.position.value,left:r.horizontal.position.value}),getScrollPercentage:()=>({top:r.vertical.percentage.value,left:r.horizontal.percentage.value}),setScrollPosition:S,setScrollPercentage(e,t,o){S(e,t*(r[e].size.value-i[e].value),o)}});let Q=null;return onDeactivated(()=>{Q={top:r.vertical.position.value,left:r.horizontal.position.value}}),onActivated(()=>{if(null===Q)return;const e=p.value;null!==e&&(setHorizontalScrollPosition(e,Q.left),setVerticalScrollPosition(e,Q.top))}),onBeforeUnmount(y.cancel),()=>{return h("div",{class:v.value,onMouseenter:M,onMouseleave:B},[h("div",{ref:p,class:"q-scrollarea__container scroll relative-position fit hide-scrollbar",tabindex:void 0!==e.tabindex?e.tabindex:void 0},[h("div",{class:"q-scrollarea__content absolute",style:m.value},hMergeSlot(t.default,[h(QResizeObserver,{debounce:0,onResize:x})])),h(QScrollObserver,{axis:"both",onScroll:C})]),h(QResizeObserver,{debounce:0,onResize:w}),h("div",{class:r.vertical.barClass.value,style:[e.barStyle,e.verticalBarStyle],"aria-hidden":"true",onMousedown:q}),h("div",{class:r.horizontal.barClass.value,style:[e.barStyle,e.horizontalBarStyle],"aria-hidden":"true",onMousedown:T}),withDirectives(h("div",{ref:r.vertical.ref,class:r.vertical.thumbClass.value,style:r.vertical.style.value,"aria-hidden":"true"}),f),withDirectives(h("div",{ref:r.horizontal.ref,class:r.horizontal.thumbClass.value,style:r.horizontal.style.value,"aria-hidden":"true"}),g)])}}});const aggBucketSize=1e3,scrollToEdges=["start","center","end","start-force","center-force","end-force"];let id=1;const filterProto=Array.prototype.filter,setOverflowAnchor=void 0===window.getComputedStyle(document.body).overflowAnchor?noop:function(e,t){const o=e+"_ss";let n=document.getElementById(o);null===n&&(n=document.createElement("style"),n.type="text/css",n.id=o,document.head.appendChild(n)),n.qChildIndex!==t&&(n.qChildIndex=t,n.innerHTML=`#${e} > *:nth-child(${t}) { overflow-anchor: auto }`)};function sumFn(e,t){return e+t}function getScrollDetails(e,t,o,n,a,l,i,r){const s=e===window?document.scrollingElement||document.documentElement:e,u=!0===a?"offsetWidth":"offsetHeight",c={scrollStart:0,scrollViewSize:-i-r,scrollMaxSize:0,offsetStart:-i,offsetEnd:-r};if(!0===a?(e===window?(c.scrollStart=window.pageXOffset||window.scrollX||document.body.scrollLeft||0,c.scrollViewSize+=document.documentElement.clientWidth):(c.scrollStart=s.scrollLeft,c.scrollViewSize+=s.clientWidth),c.scrollMaxSize=s.scrollWidth,!0===l&&(c.scrollStart=(!0===rtlHasScrollBug?c.scrollMaxSize-c.scrollViewSize:0)-c.scrollStart)):(e===window?(c.scrollStart=window.pageYOffset||window.scrollY||document.body.scrollTop||0,c.scrollViewSize+=document.documentElement.clientHeight):(c.scrollStart=s.scrollTop,c.scrollViewSize+=s.clientHeight),c.scrollMaxSize=s.scrollHeight),null!==o)for(let d=o.previousElementSibling;null!==d;d=d.previousElementSibling)!1===d.classList.contains("q-virtual-scroll--skip")&&(c.offsetStart+=d[u]);if(null!==n)for(let d=n.nextElementSibling;null!==d;d=d.nextElementSibling)!1===d.classList.contains("q-virtual-scroll--skip")&&(c.offsetEnd+=d[u]);if(t!==e){const o=s.getBoundingClientRect(),n=t.getBoundingClientRect();!0===a?(c.offsetStart+=n.left-o.left,c.offsetEnd-=n.width):(c.offsetStart+=n.top-o.top,c.offsetEnd-=n.height),e!==window&&(c.offsetStart+=c.scrollStart),c.offsetEnd+=c.scrollMaxSize-c.offsetStart}return c}function setScroll(e,t,o,n){"end"===t&&(t=(e===window?document.body:e)[!0===o?"scrollWidth":"scrollHeight"]),e===window?!0===o?(!0===n&&(t=(!0===rtlHasScrollBug?document.body.scrollWidth-document.documentElement.clientWidth:0)-t),window.scrollTo(t,window.pageYOffset||window.scrollY||document.body.scrollTop||0)):window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,t):!0===o?(!0===n&&(t=(!0===rtlHasScrollBug?e.scrollWidth-e.offsetWidth:0)-t),e.scrollLeft=t):e.scrollTop=t}function sumSize(e,t,o,n){if(o>=n)return 0;const a=t.length,l=Math.floor(o/aggBucketSize),i=Math.floor((n-1)/aggBucketSize)+1;let r=e.slice(l,i).reduce(sumFn,0);return o%aggBucketSize!==0&&(r-=t.slice(l*aggBucketSize,o).reduce(sumFn,0)),n%aggBucketSize!==0&&n!==a&&(r-=t.slice(n,i*aggBucketSize).reduce(sumFn,0)),r}const commonVirtScrollProps={virtualScrollSliceSize:{type:[Number,String],default:null},virtualScrollSliceRatioBefore:{type:[Number,String],default:1},virtualScrollSliceRatioAfter:{type:[Number,String],default:1},virtualScrollItemSize:{type:[Number,String],default:24},virtualScrollStickySizeStart:{type:[Number,String],default:0},virtualScrollStickySizeEnd:{type:[Number,String],default:0},tableColspan:[Number,String]},commonVirtPropsList=Object.keys(commonVirtScrollProps),useVirtualScrollProps={virtualScrollHorizontal:Boolean,onVirtualScroll:Function,...commonVirtScrollProps};function useVirtualScroll({virtualScrollLength:e,getVirtualScrollTarget:t,getVirtualScrollEl:o,virtualScrollItemSizeComputed:n}){const a=getCurrentInstance(),{props:l,emit:i,proxy:r}=a,{$q:s}=r;let u,c,d,p,v=[];const m="qvs_"+id++,f=ref(0),g=ref(0),b=ref({}),y=ref(null),S=ref(null),w=ref(null),C=ref({from:0,to:0}),x=computed(()=>void 0!==l.tableColspan?l.tableColspan:100);void 0===n&&(n=computed(()=>l.virtualScrollItemSize));const k=computed(()=>n.value+";"+l.virtualScrollHorizontal),_=computed(()=>k.value+";"+l.virtualScrollSliceRatioBefore+";"+l.virtualScrollSliceRatioAfter);function q(){E(c,!0)}function T(e){E(void 0===e?c:e)}function P(n,a){const i=t();if(void 0===i||null===i||8===i.nodeType)return;const r=getScrollDetails(i,o(),y.value,S.value,l.virtualScrollHorizontal,s.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd);d!==r.scrollViewSize&&O(r.scrollViewSize),M(i,r,Math.min(e.value-1,Math.max(0,parseInt(n,10)||0)),0,scrollToEdges.indexOf(a)>-1?a:c>-1&&n>c?"end":"start")}function $(){const n=t();if(void 0===n||null===n||8===n.nodeType)return;const a=getScrollDetails(n,o(),y.value,S.value,l.virtualScrollHorizontal,s.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd),i=e.value-1,r=a.scrollMaxSize-a.offsetStart-a.offsetEnd-g.value;if(u===a.scrollStart)return;if(a.scrollMaxSize<=0)return void M(n,a,0,0);d!==a.scrollViewSize&&O(a.scrollViewSize),B(C.value.from);const c=Math.floor(a.scrollMaxSize-Math.max(a.scrollViewSize,a.offsetEnd)-Math.min(p[i],a.scrollViewSize/2));if(c>0&&Math.ceil(a.scrollStart)>=c)return void M(n,a,i,a.scrollMaxSize-a.offsetEnd-v.reduce(sumFn,0));let m=0,h=a.scrollStart-a.offsetStart,b=h;if(h<=r&&h+a.scrollViewSize>=f.value)h-=f.value,m=C.value.from,b=h;else for(let e=0;h>=v[e]&&m<i;e++)h-=v[e],m+=aggBucketSize;while(h>0&&m<i)h-=p[m],h>-a.scrollViewSize?(m++,b=h):b=p[m]+h;M(n,a,m,b)}function M(t,o,n,a,i){const r="string"===typeof i&&i.indexOf("-force")>-1,c=!0===r?i.replace("-force",""):i,d=void 0!==c?c:"start";let h=Math.max(0,n-b.value[d]),y=h+b.value.total;y>e.value&&(y=e.value,h=Math.max(0,y-b.value.total)),u=o.scrollStart;const S=h!==C.value.from||y!==C.value.to;if(!1===S&&void 0===c)return void L(n);const{activeElement:x}=document,k=w.value;!0===S&&null!==k&&k!==x&&!0===k.contains(x)&&(k.addEventListener("focusout",Q),setTimeout(()=>{void 0!==k&&k.removeEventListener("focusout",Q)})),setOverflowAnchor(m,n-h+1);const _=void 0!==c?p.slice(h,n).reduce(sumFn,0):0;if(!0===S){const t=y>=C.value.from&&h<=C.value.to?C.value.to:y;C.value={from:h,to:t},f.value=sumSize(v,p,0,h),g.value=sumSize(v,p,y,e.value),requestAnimationFrame(()=>{C.value.to!==y&&u===o.scrollStart&&(C.value={from:C.value.from,to:y},g.value=sumSize(v,p,y,e.value))})}requestAnimationFrame(()=>{if(u!==o.scrollStart)return;!0===S&&B(h);const e=p.slice(h,n).reduce(sumFn,0),i=e+o.offsetStart+f.value,d=i+p[n];let v=i+a;if(void 0!==c){const t=e-_,a=o.scrollStart+t;v=!0!==r&&a<i&&d<a+o.scrollViewSize?a:"end"===c?d-o.scrollViewSize:i-("start"===c?0:Math.round((o.scrollViewSize-p[n])/2))}u=v,setScroll(t,v,l.virtualScrollHorizontal,s.lang.rtl),L(n)})}function B(e){const t=w.value;if(t){const o=filterProto.call(t.children,e=>e.classList&&!1===e.classList.contains("q-virtual-scroll--skip")),n=o.length,a=!0===l.virtualScrollHorizontal?e=>e.getBoundingClientRect().width:e=>e.offsetHeight;let i,r,s=e;for(let e=0;e<n;){i=a(o[e]),e++;while(e<n&&!0===o[e].classList.contains("q-virtual-scroll--with-prev"))i+=a(o[e]),e++;r=i-p[s],0!==r&&(p[s]+=r,v[Math.floor(s/aggBucketSize)]+=r),s++}}}function Q(){void 0!==w.value&&w.value.focus()}function E(t,o){const a=1*n.value;!0!==o&&!1!==Array.isArray(p)||(p=[]);const l=p.length;p.length=e.value;for(let n=e.value-1;n>=l;n--)p[n]=a;const i=Math.floor((e.value-1)/aggBucketSize);v=[];for(let n=0;n<=i;n++){let t=0;const o=Math.min((n+1)*aggBucketSize,e.value);for(let e=n*aggBucketSize;e<o;e++)t+=p[e];v.push(t)}c=-1,u=void 0,f.value=sumSize(v,p,0,C.value.from),g.value=sumSize(v,p,C.value.to,e.value),t>=0?(B(C.value.from),nextTick(()=>{P(t)})):z()}function O(e){if(void 0===e&&"undefined"!==typeof window){const n=t();void 0!==n&&null!==n&&8!==n.nodeType&&(e=getScrollDetails(n,o(),y.value,S.value,l.virtualScrollHorizontal,s.lang.rtl,l.virtualScrollStickySizeStart,l.virtualScrollStickySizeEnd).scrollViewSize)}d=e;const a=parseFloat(l.virtualScrollSliceRatioBefore)||0,i=parseFloat(l.virtualScrollSliceRatioAfter)||0,r=1+a+i,u=void 0===e||e<=0?1:Math.ceil(e/n.value),c=Math.max(1,u,Math.ceil((l.virtualScrollSliceSize>0?l.virtualScrollSliceSize:10)/r));b.value={total:Math.ceil(c*r),start:Math.ceil(c*a),center:Math.ceil(c*(.5+a)),end:Math.ceil(c*(1+a)),view:u}}function R(e,t){const o=!0===l.virtualScrollHorizontal?"width":"height",a={["--q-virtual-scroll-item-"+o]:n.value+"px"};return["tbody"===e?h(e,{class:"q-virtual-scroll__padding",key:"before",ref:y},[h("tr",[h("td",{style:{[o]:`${f.value}px`,...a},colspan:x.value})])]):h(e,{class:"q-virtual-scroll__padding",key:"before",ref:y,style:{[o]:`${f.value}px`,...a}}),h(e,{class:"q-virtual-scroll__content",key:"content",ref:w,id:m,tabindex:-1},t.flat()),"tbody"===e?h(e,{class:"q-virtual-scroll__padding",key:"after",ref:S},[h("tr",[h("td",{style:{[o]:`${g.value}px`,...a},colspan:x.value})])]):h(e,{class:"q-virtual-scroll__padding",key:"after",ref:S,style:{[o]:`${g.value}px`,...a}})]}function L(e){c!==e&&(void 0!==l.onVirtualScroll&&i("virtual-scroll",{index:e,from:C.value.from,to:C.value.to-1,direction:e<c?"decrease":"increase",ref:r}),c=e)}watch(_,()=>{O()}),watch(k,q),O();const z=debounce($,!0===s.platform.is.ios?120:35);onBeforeMount(()=>{O()});let A=!1;return onDeactivated(()=>{A=!0}),onActivated(()=>{if(!0!==A)return;const e=t();void 0!==u&&void 0!==e&&null!==e&&8!==e.nodeType?setScroll(e,u,l.virtualScrollHorizontal,s.lang.rtl):P(c)}),setOverflowAnchor!==noop&&onBeforeUnmount(()=>{const e=document.getElementById(m+"_ss");null!==e&&e.remove(),z.cancel()}),Object.assign(r,{scrollTo:P,reset:q,refresh:T}),{virtualScrollSliceRange:C,virtualScrollSliceSizeComputed:b,setVirtualScrollSize:O,onVirtualScrollEvt:z,localResetVirtualScroll:E,padVirtualScroll:R,scrollTo:P,reset:q,refresh:T}}const validateNewValueMode=e=>["add","add-unique","toggle"].includes(e),reEscapeList=".*+?^${}()|[]\\",fieldPropsList=Object.keys(useFieldProps);var QSelect=createComponent({name:"QSelect",inheritAttrs:!1,props:{...useVirtualScrollProps,...useFormProps,...useFieldProps,modelValue:{required:!0},multiple:Boolean,displayValue:[String,Number],displayValueHtml:Boolean,dropdownIcon:String,options:{type:Array,default:()=>[]},optionValue:[Function,String],optionLabel:[Function,String],optionDisable:[Function,String],hideSelected:Boolean,hideDropdownIcon:Boolean,fillInput:Boolean,maxValues:[Number,String],optionsDense:Boolean,optionsDark:{type:Boolean,default:null},optionsSelectedClass:String,optionsHtml:Boolean,optionsCover:Boolean,menuShrink:Boolean,menuAnchor:String,menuSelf:String,menuOffset:Array,popupContentClass:String,popupContentStyle:[String,Array,Object],useInput:Boolean,useChips:Boolean,newValueMode:{type:String,validator:validateNewValueMode},mapOptions:Boolean,emitValue:Boolean,inputDebounce:{type:[Number,String],default:500},inputClass:[Array,String,Object],inputStyle:[Array,String,Object],tabindex:{type:[String,Number],default:0},autocomplete:String,transitionShow:String,transitionHide:String,transitionDuration:[String,Number],behavior:{type:String,validator:e=>["default","menu","dialog"].includes(e),default:"default"},virtualScrollItemSize:{type:[Number,String],default:void 0},onNewValue:Function,onFilter:Function},emits:[...useFieldEmits,"add","remove","input-value","keyup","keypress","keydown","filter-abort"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=ref(!1),i=ref(!1),r=ref(-1),s=ref(""),u=ref(!1),c=ref(!1);let d,p,v,m,f,g,b,y,S;const w=ref(null),C=ref(null),x=ref(null),k=ref(null),_=ref(null),q=useFormInputNameAttr(e),T=useKeyComposition(Te),P=computed(()=>Array.isArray(e.options)?e.options.length:0),$=computed(()=>void 0===e.virtualScrollItemSize?!0===e.dense?24:48:e.virtualScrollItemSize),{virtualScrollSliceRange:M,virtualScrollSliceSizeComputed:B,localResetVirtualScroll:Q,padVirtualScroll:E,onVirtualScrollEvt:O,scrollTo:R,setVirtualScrollSize:L}=useVirtualScroll({virtualScrollLength:P,getVirtualScrollTarget:xe,getVirtualScrollEl:Ce,virtualScrollItemSizeComputed:$}),z=useFieldState(),A=computed(()=>{const t=!0===e.mapOptions&&!0!==e.multiple,o=void 0===e.modelValue||null===e.modelValue&&!0!==t?[]:!0===e.multiple&&Array.isArray(e.modelValue)?e.modelValue:[e.modelValue];if(!0===e.mapOptions&&!0===Array.isArray(e.options)){const n=!0===e.mapOptions&&void 0!==p?p:[],a=o.map(e=>me(e,n));return null===e.modelValue&&!0===t?a.filter(e=>null!==e):a}return o}),F=computed(()=>{const t={};return fieldPropsList.forEach(o=>{const n=e[o];void 0!==n&&(t[o]=n)}),t}),D=computed(()=>null===e.optionsDark?z.isDark.value:e.optionsDark),I=computed(()=>fieldValueIsFilled(A.value)),V=computed(()=>{let t="q-field__input q-placeholder col";return!0===e.hideSelected||0===A.value.length?[t,e.inputClass]:(t+=" q-field__input--padding",void 0===e.inputClass?t:[t,e.inputClass])}),N=computed(()=>(!0===e.virtualScrollHorizontal?"q-virtual-scroll--horizontal":"")+(e.popupContentClass?" "+e.popupContentClass:"")),H=computed(()=>0===P.value),j=computed(()=>A.value.map(e=>ne.value(e)).join(", ")),U=computed(()=>!0===e.optionsHtml?()=>!0:e=>void 0!==e&&null!==e&&!0===e.html),K=computed(()=>!0===e.displayValueHtml||void 0===e.displayValue&&(!0===e.optionsHtml||A.value.some(U.value))),W=computed(()=>!0===z.focused.value?e.tabindex:-1),Y=computed(()=>({tabindex:e.tabindex,role:"combobox","aria-label":e.label,"aria-autocomplete":!0===e.useInput?"list":"none","aria-expanded":!0===l.value?"true":"false","aria-owns":`${z.targetUid.value}_lb`,"aria-controls":`${z.targetUid.value}_lb`})),G=computed(()=>{const t={id:`${z.targetUid.value}_lb`,role:"listbox","aria-multiselectable":!0===e.multiple?"true":"false"};return r.value>=0&&(t["aria-activedescendant"]=`${z.targetUid.value}_${r.value}`),t}),X=computed(()=>{return A.value.map((e,t)=>({index:t,opt:e,html:U.value(e),selected:!0,removeAtIndex:ue,toggleOption:de,tabindex:W.value}))}),Z=computed(()=>{if(0===P.value)return[];const{from:t,to:o}=M.value;return e.options.slice(t,o).map((o,n)=>{const l=!0===ae.value(o),i=t+n,s={clickable:!0,active:!1,activeClass:te.value,manualFocus:!0,focused:!1,disable:l,tabindex:-1,dense:e.optionsDense,dark:D.value,role:"option",id:`${z.targetUid.value}_${i}`,onClick:()=>{de(o)}};return!0!==l&&(!0===he(o)&&(s.active=!0),r.value===i&&(s.focused=!0),s["aria-selected"]=!0===s.active?"true":"false",!0===a.platform.is.desktop&&(s.onMousemove=(()=>{pe(i)}))),{index:i,opt:o,html:U.value(o),label:ne.value(o),selected:s.active,focused:s.focused,toggleOption:de,setOptionIndex:pe,itemProps:s}})}),J=computed(()=>void 0!==e.dropdownIcon?e.dropdownIcon:a.iconSet.arrow.dropdown),ee=computed(()=>!1===e.optionsCover&&!0!==e.outlined&&!0!==e.standout&&!0!==e.borderless&&!0!==e.rounded),te=computed(()=>void 0!==e.optionsSelectedClass?e.optionsSelectedClass:void 0!==e.color?`text-${e.color}`:""),oe=computed(()=>fe(e.optionValue,"value")),ne=computed(()=>fe(e.optionLabel,"label")),ae=computed(()=>fe(e.optionDisable,"disable")),le=computed(()=>A.value.map(e=>oe.value(e))),ie=computed(()=>{const e={onInput:Te,onChange:T,onKeydown:we,onKeyup:ye,onKeypress:Se,onFocus:ge,onClick(e){!0===v&&stop(e)}};return e.onCompositionstart=e.onCompositionupdate=e.onCompositionend=T,e});function re(t){return!0===e.emitValue?oe.value(t):t}function se(t){if(t>-1&&t<A.value.length)if(!0===e.multiple){const n=e.modelValue.slice();o("remove",{index:t,value:n.splice(t,1)[0]}),o("update:modelValue",n)}else o("update:modelValue",null)}function ue(e){se(e),z.focus()}function ce(t,n){const a=re(t);if(!0!==e.multiple)return!0===e.fillInput&&$e(ne.value(t),!0,!0),void o("update:modelValue",a);if(0===A.value.length)return o("add",{index:0,value:a}),void o("update:modelValue",!0===e.multiple?[a]:a);if(!0===n&&!0===he(t))return;if(void 0!==e.maxValues&&e.modelValue.length>=e.maxValues)return;const l=e.modelValue.slice();o("add",{index:l.length,value:a}),l.push(a),o("update:modelValue",l)}function de(t,n){if(!0!==z.editable.value||void 0===t||!0===ae.value(t))return;const a=oe.value(t);if(!0!==e.multiple)return!0!==n&&($e(!0===e.fillInput?ne.value(t):"",!0,!0),Ve()),null!==C.value&&C.value.focus(),void(0!==A.value.length&&!0===isDeepEqual(oe.value(A.value[0]),a)||o("update:modelValue",!0===e.emitValue?a:t));if((!0!==v||!0===u.value)&&z.focus(),ge(),0===A.value.length){const n=!0===e.emitValue?a:t;return o("add",{index:0,value:n}),void o("update:modelValue",!0===e.multiple?[n]:n)}const l=e.modelValue.slice(),i=le.value.findIndex(e=>isDeepEqual(e,a));if(i>-1)o("remove",{index:i,value:l.splice(i,1)[0]});else{if(void 0!==e.maxValues&&l.length>=e.maxValues)return;const n=!0===e.emitValue?a:t;o("add",{index:l.length,value:n}),l.push(n)}o("update:modelValue",l)}function pe(e){if(!0!==a.platform.is.desktop)return;const t=e>-1&&e<P.value?e:-1;r.value!==t&&(r.value=t)}function ve(t=1,o){if(!0===l.value){let n=r.value;do{n=normalizeToInterval(n+t,-1,P.value-1)}while(-1!==n&&n!==r.value&&!0===ae.value(e.options[n]));r.value!==n&&(pe(n),R(n),!0!==o&&!0===e.useInput&&!0===e.fillInput&&Pe(n>=0?ne.value(e.options[n]):g))}}function me(t,o){const n=e=>isDeepEqual(oe.value(e),t);return e.options.find(n)||o.find(n)||t}function fe(e,t){const o=void 0!==e?e:t;return"function"===typeof o?o:e=>Object(e)===e&&o in e?e[o]:e}function he(e){const t=oe.value(e);return void 0!==le.value.find(e=>isDeepEqual(e,t))}function ge(t){!0===e.useInput&&null!==C.value&&(void 0===t||C.value===t.target&&t.target.value===j.value)&&C.value.select()}function be(e){!0===isKeyCode(e,27)&&!0===l.value&&(stop(e),Ve(),Ne()),o("keyup",e)}function ye(t){const{value:o}=t.target;if(void 0===t.keyCode)if(t.target.value="",clearTimeout(d),Ne(),"string"===typeof o&&o.length>0){const t=o.toLocaleLowerCase(),n=o=>{const n=e.options.find(e=>o.value(e).toLocaleLowerCase()===t);return void 0!==n&&(-1===A.value.indexOf(n)?de(n):Ve(),!0)},a=e=>{!0!==n(oe)&&!0!==n(ne)&&!0!==e&&Me(o,!0,()=>a(!0))};a()}else z.clearValue(t);else be(t)}function Se(e){o("keypress",e)}function we(t){if(o("keydown",t),!0===shouldIgnoreKey(t))return;const n=s.value.length>0&&(void 0!==e.newValueMode||void 0!==e.onNewValue),a=!0!==t.shiftKey&&!0!==e.multiple&&(r.value>-1||!0===n);if(27===t.keyCode)return void prevent(t);if(9===t.keyCode&&!1===a)return void De();if(void 0===t.target||t.target.id!==z.targetUid.value)return;if(40===t.keyCode&&!0!==z.innerLoading.value&&!1===l.value)return stopAndPrevent(t),void Ie();if(8===t.keyCode&&!0!==e.hideSelected&&0===s.value.length)return void(!0===e.multiple&&!0===Array.isArray(e.modelValue)?se(e.modelValue.length-1):!0!==e.multiple&&null!==e.modelValue&&o("update:modelValue",null));35!==t.keyCode&&36!==t.keyCode||"string"===typeof s.value&&0!==s.value.length||(stopAndPrevent(t),r.value=-1,ve(36===t.keyCode?1:-1,e.multiple)),33!==t.keyCode&&34!==t.keyCode||void 0===B.value||(stopAndPrevent(t),r.value=Math.max(-1,Math.min(P.value,r.value+(33===t.keyCode?-1:1)*B.value.view)),ve(33===t.keyCode?1:-1,e.multiple)),38!==t.keyCode&&40!==t.keyCode||(stopAndPrevent(t),ve(38===t.keyCode?-1:1,e.multiple));const i=P.value;if((void 0===y||S<Date.now())&&(y=""),i>0&&!0!==e.useInput&&void 0!==t.key&&1===t.key.length&&t.altKey===t.ctrlKey&&(32!==t.keyCode||y.length>0)){!0!==l.value&&Ie(t);const o=t.key.toLocaleLowerCase(),n=1===y.length&&y[0]===o;S=Date.now()+1500,!1===n&&(stopAndPrevent(t),y+=o);const a=new RegExp("^"+y.split("").map(e=>reEscapeList.indexOf(e)>-1?"\\"+e:e).join(".*"),"i");let s=r.value;if(!0===n||s<0||!0!==a.test(ne.value(e.options[s])))do{s=normalizeToInterval(s+1,-1,i-1)}while(s!==r.value&&(!0===ae.value(e.options[s])||!0!==a.test(ne.value(e.options[s]))));r.value!==s&&nextTick(()=>{pe(s),R(s),s>=0&&!0===e.useInput&&!0===e.fillInput&&Pe(ne.value(e.options[s]))})}else if(13===t.keyCode||32===t.keyCode&&!0!==e.useInput&&""===y||9===t.keyCode&&!1!==a)if(9!==t.keyCode&&stopAndPrevent(t),r.value>-1&&r.value<i)de(e.options[r.value]);else{if(!0===n){const t=(t,o)=>{if(o){if(!0!==validateNewValueMode(o))return}else o=e.newValueMode;if(void 0===t||null===t)return;$e("",!0!==e.multiple,!0);const n="toggle"===o?de:ce;n(t,"add-unique"===o),!0!==e.multiple&&(null!==C.value&&C.value.focus(),Ve())};if(void 0!==e.onNewValue?o("new-value",s.value,t):t(s.value),!0!==e.multiple)return}!0===l.value?De():!0!==z.innerLoading.value&&Ie()}}function Ce(){return!0===v?_.value:null!==x.value&&null!==x.value.__qPortalInnerRef.value?x.value.__qPortalInnerRef.value:void 0}function xe(){return Ce()}function ke(){return!0===e.hideSelected?[]:void 0!==t["selected-item"]?X.value.map(e=>t["selected-item"](e)).slice():void 0!==t.selected?[].concat(t.selected()):!0===e.useChips?X.value.map((t,o)=>h(QChip,{key:"option-"+o,removable:!0===z.editable.value&&!0!==ae.value(t.opt),dense:!0,textColor:e.color,tabindex:W.value,onRemove(){t.removeAtIndex(o)}},()=>h("span",{class:"ellipsis",[!0===t.html?"innerHTML":"textContent"]:ne.value(t.opt)}))):[h("span",{[!0===K.value?"innerHTML":"textContent"]:void 0!==e.displayValue?e.displayValue:j.value})]}function _e(){if(!0===H.value)return void 0!==t["no-option"]?t["no-option"]({inputValue:s.value}):void 0;const e=void 0!==t.option?t.option:e=>{return h(QItem,{key:e.index,...e.itemProps},()=>{return h(QItemSection,()=>h(QItemLabel,()=>h("span",{[!0===e.html?"innerHTML":"textContent"]:e.label})))})};let o=E("div",Z.value.map(e));return void 0!==t["before-options"]&&(o=t["before-options"]().concat(o)),hMergeSlot(t["after-options"],o)}function qe(t,o){const n={ref:!0===o?C:void 0,key:"i_t",class:V.value,style:e.inputStyle,value:void 0!==s.value?s.value:"",type:"search",...Y.value,...z.splitAttrs.attributes.value,id:!0===o?z.targetUid.value:void 0,maxlength:e.maxlength,autocomplete:e.autocomplete,"data-autofocus":!0!==t&&!0===e.autofocus||void 0,disabled:!0===e.disable,readonly:!0===e.readonly,...ie.value};return!0!==t&&!0===v&&(!0===Array.isArray(n.class)?n.class=[...n.class,"no-pointer-events"]:n.class+=" no-pointer-events"),h("input",n)}function Te(t){clearTimeout(d),t&&t.target&&!0===t.target.composing||(Pe(t.target.value||""),m=!0,g=s.value,!0===z.focused.value||!0===v&&!0!==u.value||z.focus(),void 0!==e.onFilter&&(d=setTimeout(()=>{Me(s.value)},e.inputDebounce)))}function Pe(e){s.value!==e&&(s.value=e,o("input-value",e))}function $e(t,o,n){m=!0!==n,!0===e.useInput&&(Pe(t),!0!==o&&!0===n||(g=t),!0!==o&&Me(t))}function Me(t,a,i){if(void 0===e.onFilter||!0!==a&&!0!==z.focused.value)return;!0===z.innerLoading.value?o("filter-abort"):(z.innerLoading.value=!0,c.value=!0),""!==t&&!0!==e.multiple&&A.value.length>0&&!0!==m&&t===ne.value(A.value[0])&&(t="");const r=setTimeout(()=>{!0===l.value&&(l.value=!1)},10);clearTimeout(f),f=r,o("filter",t,(e,t)=>{!0!==a&&!0!==z.focused.value||f!==r||(clearTimeout(f),"function"===typeof e&&e(),c.value=!1,nextTick(()=>{z.innerLoading.value=!1,!0===z.editable.value&&(!0===a?!0===l.value&&Ve():!0===l.value?He(!0):l.value=!0),"function"===typeof t&&nextTick(()=>{t(n)}),"function"===typeof i&&nextTick(()=>{i(n)})}))},()=>{!0===z.focused.value&&f===r&&(clearTimeout(f),z.innerLoading.value=!1,c.value=!1),!0===l.value&&(l.value=!1)})}function Be(){return h(QMenu,{ref:x,class:N.value,style:e.popupContentStyle,modelValue:l.value,fit:!0!==e.menuShrink,cover:!0===e.optionsCover&&!0!==H.value&&!0!==e.useInput,anchor:e.menuAnchor,self:e.menuSelf,offset:e.menuOffset,dark:D.value,noParentEvent:!0,noRefocus:!0,noFocus:!0,square:ee.value,transitionShow:e.transitionShow,transitionHide:e.transitionHide,transitionDuration:e.transitionDuration,separateClosePopup:!0,...G.value,onScrollPassive:O,onBeforeShow:Ue,onBeforeHide:Qe,onShow:Ee},_e)}function Qe(e){Ke(e),De()}function Ee(){L()}function Oe(e){stop(e),null!==C.value&&C.value.focus(),u.value=!0,window.scrollTo(window.pageXOffset||window.scrollX||document.body.scrollLeft||0,0)}function Re(e){stop(e),nextTick(()=>{u.value=!1})}function Le(){const o=[h(QField,{class:`col-auto ${z.fieldClass.value}`,...F.value,for:z.targetUid.value,dark:D.value,square:!0,loading:c.value,itemAligned:!1,filled:!0,stackLabel:s.value.length>0,...z.splitAttrs.listeners.value,onFocus:Oe,onBlur:Re},{...t,rawControl:()=>z.getControl(!0),before:void 0,after:void 0})];return!0===l.value&&o.push(h("div",{ref:_,class:N.value+" scroll",style:e.popupContentStyle,...G.value,onClick:prevent,onScrollPassive:O},_e())),h(QDialog,{ref:k,modelValue:i.value,position:!0===e.useInput?"top":void 0,transitionShow:b,transitionHide:e.transitionHide,transitionDuration:e.transitionDuration,onBeforeShow:Ue,onBeforeHide:ze,onHide:Ae,onShow:Fe},()=>h("div",{class:"q-select__dialog"+(!0===D.value?" q-select__dialog--dark q-dark":"")+(!0===u.value?" q-select__dialog--focused":"")},o))}function ze(e){Ke(e),null!==k.value&&k.value.__updateRefocusTarget(z.rootRef.value.querySelector(".q-field__native > [tabindex]:last-child")),z.focused.value=!1}function Ae(e){Ve(),!1===z.focused.value&&o("blur",e),Ne()}function Fe(){const e=document.activeElement;null!==e&&e.id===z.targetUid.value||null===C.value||C.value===e||C.value.focus(),L()}function De(){!0!==i.value&&(r.value=-1,!0===l.value&&(l.value=!1),!1===z.focused.value&&(clearTimeout(f),f=void 0,!0===z.innerLoading.value&&(o("filter-abort"),z.innerLoading.value=!1,c.value=!1)))}function Ie(o){!0===z.editable.value&&(!0===v?(z.onControlFocusin(o),i.value=!0,nextTick(()=>{z.focus()})):z.focus(),void 0!==e.onFilter?Me(s.value):!0===H.value&&void 0===t["no-option"]||(l.value=!0))}function Ve(){i.value=!1,De()}function Ne(){!0===e.useInput&&$e(!0!==e.multiple&&!0===e.fillInput&&A.value.length>0&&ne.value(A.value[0])||"",!0,!0)}function He(t){let o=-1;if(!0===t){if(A.value.length>0){const t=oe.value(A.value[0]);o=e.options.findIndex(e=>isDeepEqual(oe.value(e),t))}Q(o)}pe(o)}function je(){!1===i.value&&null!==x.value&&x.value.updatePosition()}function Ue(e){void 0!==e&&stop(e),o("popup-show",e),z.hasPopupOpen=!0,z.onControlFocusin(e)}function Ke(e){void 0!==e&&stop(e),o("popup-hide",e),z.hasPopupOpen=!1,z.onControlFocusout(e)}function We(){v=(!0===a.platform.is.mobile||"dialog"===e.behavior)&&("menu"!==e.behavior&&(!0!==e.useInput||(void 0!==t["no-option"]||void 0!==e.onFilter||!1===H.value))),b=!0===a.platform.is.ios&&!0===v&&!0===e.useInput?"fade":e.transitionShow}return watch(A,t=>{p=t,!0===e.useInput&&!0===e.fillInput&&!0!==e.multiple&&!0!==z.innerLoading.value&&(!0!==i.value&&!0!==l.value||!0!==I.value)&&(!0!==m&&Ne(),!0!==i.value&&!0!==l.value||Me(""))},{immediate:!0}),watch(()=>e.fillInput,Ne),watch(l,He),onBeforeUpdate(We),onUpdated(je),We(),onBeforeUnmount(()=>{clearTimeout(d)}),Object.assign(n,{showPopup:Ie,hidePopup:Ve,removeAtIndex:se,add:ce,toggleOption:de,setOptionIndex:pe,moveOptionSelection:ve,filter:Me,updateMenuPosition:je,updateInputValue:$e,isOptionSelected:he,getEmittingOptionValue:re,isOptionDisabled:(...e)=>!0===ae.value.apply(null,e),getOptionValue:(...e)=>oe.value.apply(null,e),getOptionLabel:(...e)=>ne.value.apply(null,e)}),Object.assign(z,{innerValue:A,fieldClass:computed(()=>`q-select q-field--auto-height q-select--with${!0!==e.useInput?"out":""}-input`+` q-select--with${!0!==e.useChips?"out":""}-chips`+` q-select--${!0===e.multiple?"multiple":"single"}`),inputRef:w,targetRef:C,hasValue:I,showPopup:Ie,floatingLabel:computed(()=>(!0===e.hideSelected?s.value.length>0:!0===I.value)||fieldValueIsFilled(e.displayValue)),getControlChild:()=>{if(!1!==z.editable.value&&(!0===i.value||!0!==H.value||void 0!==t["no-option"]))return!0===v?Le():Be();!0===z.hasPopupOpen&&(z.hasPopupOpen=!1)},controlEvents:{onFocusin(e){z.onControlFocusin(e)},onFocusout(e){z.onControlFocusout(e,()=>{Ne(),De()})},onClick(e){if(prevent(e),!0!==v&&!0===l.value)return De(),void(null!==C.value&&C.value.focus());Ie(e)}},getControl:t=>{const o=ke(),n=!0===t||!0!==i.value||!0!==v;if(!0===e.useInput?o.push(qe(t,n)):!0===z.editable.value&&(o.push(h("div",{ref:!0===n?C:void 0,key:"d_t",class:"q-select__focus-target",id:!0===n?z.targetUid.value:void 0,...Y.value,onKeydown:we,onKeyup:be,onKeypress:Se})),!0===n&&"string"===typeof e.autocomplete&&e.autocomplete.length>0&&o.push(h("input",{class:"q-select__autocomplete-input",autocomplete:e.autocomplete,onKeyup:ye}))),void 0!==q.value&&!0!==e.disable&&le.value.length>0){const t=le.value.map(e=>h("option",{value:e,selected:!0}));o.push(h("select",{class:"hidden",name:q.value,multiple:e.multiple},t))}return h("div",{class:"q-field__native row items-center",...z.splitAttrs.attributes.value},o)},getInnerAppend:()=>!0!==e.loading&&!0!==c.value&&!0!==e.hideDropdownIcon?[h(QIcon,{class:"q-select__dropdown-icon"+(!0===l.value?" rotate-180":""),name:J.value})]:null}),useField(z)}});const skeletonTypes=["text","rect","circle","QBtn","QBadge","QChip","QToolbar","QCheckbox","QRadio","QToggle","QSlider","QRange","QInput","QAvatar"],skeletonAnimations=["wave","pulse","pulse-x","pulse-y","fade","blink","none"];var QSkeleton=createComponent({name:"QSkeleton",props:{...useDarkProps,tag:{type:String,default:"div"},type:{type:String,validator:e=>skeletonTypes.includes(e),default:"rect"},animation:{type:String,validator:e=>skeletonAnimations.includes(e),default:"wave"},animationSpeed:{type:[String,Number],default:1500},square:Boolean,bordered:Boolean,size:String,width:String,height:String},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),a=computed(()=>{const t=void 0!==e.size?[e.size,e.size]:[e.width,e.height];return{"--q-skeleton-speed":`${e.animationSpeed}ms`,width:t[0],height:t[1]}}),l=computed(()=>`q-skeleton q-skeleton--${!0===n.value?"dark":"light"} q-skeleton--type-${e.type}`+("none"!==e.animation?` q-skeleton--anim q-skeleton--anim-${e.animation}`:"")+(!0===e.square?" q-skeleton--square":"")+(!0===e.bordered?" q-skeleton--bordered":""));return()=>h(e.tag,{class:l.value,style:a.value},hSlot(t.default))}});const slotsDef=[["left","center","start","width"],["right","center","end","width"],["top","start","center","height"],["bottom","end","center","height"]];var QSlideItem=createComponent({name:"QSlideItem",props:{...useDarkProps,leftColor:String,rightColor:String,topColor:String,bottomColor:String,onSlide:Function},emits:["action","top","right","bottom","left"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=useDark(e,a),{getCacheWithFn:i}=useCache(),r=ref(null);let s,u={},c={},d={};const p=computed(()=>!0===a.lang.rtl?{left:"right",right:"left"}:{left:"left",right:"right"}),v=computed(()=>"q-slide-item q-item-type overflow-hidden"+(!0===l.value?" q-slide-item--dark q-dark":""));function m(){r.value.style.transform="translate(0,0)"}function f(t,n,a){void 0!==e.onSlide&&o("slide",{side:t,ratio:n,isReset:a})}function g(e){const n=r.value;if(e.isFirst)u={dir:null,size:{left:0,right:0,top:0,bottom:0},scale:0},n.classList.add("no-transition"),slotsDef.forEach(e=>{if(void 0!==t[e[0]]){const t=d[e[0]];t.style.transform="scale(1)",u.size[e[0]]=t.getBoundingClientRect()[e[3]]}}),u.axis="up"===e.direction||"down"===e.direction?"Y":"X";else{if(e.isFinal)return n.classList.remove("no-transition"),void(1===u.scale?(n.style.transform=`translate${u.axis}(${100*u.dir}%)`,s=setTimeout(()=>{o(u.showing,{reset:m}),o("action",{side:u.showing,reset:m})},230)):(n.style.transform="translate(0,0)",f(u.showing,0,!0)));e.direction="X"===u.axis?e.offset.x<0?"left":"right":e.offset.y<0?"up":"down"}if(void 0===t.left&&e.direction===p.value.right||void 0===t.right&&e.direction===p.value.left||void 0===t.top&&"down"===e.direction||void 0===t.bottom&&"up"===e.direction)return void(n.style.transform="translate(0,0)");let a,l,i;"X"===u.axis?(l="left"===e.direction?-1:1,a=1===l?p.value.left:p.value.right,i=e.distance.x):(l="up"===e.direction?-2:2,a=2===l?"top":"bottom",i=e.distance.y),null!==u.dir&&Math.abs(l)!==Math.abs(u.dir)||(u.dir!==l&&(["left","right","top","bottom"].forEach(e=>{c[e]&&(c[e].style.visibility=a===e?"visible":"hidden")}),u.showing=a,u.dir=l),u.scale=Math.max(0,Math.min(1,(i-40)/u.size[a])),n.style.transform=`translate${u.axis}(${i*l/Math.abs(l)}px)`,d[a].style.transform=`scale(${u.scale})`,f(a,u.scale,!1))}return onBeforeUpdate(()=>{c={},d={}}),onBeforeUnmount(()=>{clearTimeout(s)}),Object.assign(n,{reset:m}),()=>{const o=[],n={left:void 0!==t[p.value.right],right:void 0!==t[p.value.left],up:void 0!==t.bottom,down:void 0!==t.top},a=Object.keys(n).filter(e=>!0===n[e]);slotsDef.forEach(n=>{const a=n[0];void 0!==t[a]&&o.push(h("div",{ref:e=>{c[a]=e},class:`q-slide-item__${a} absolute-full row no-wrap items-${n[1]} justify-${n[2]}`+(void 0!==e[a+"Color"]?` bg-${e[a+"Color"]}`:"")},[h("div",{ref:e=>{d[a]=e}},t[a]())]))});const l=h("div",{key:`${0===a.length?"only-":""} content`,ref:r,class:"q-slide-item__content"},hSlot(t.default));return 0===a.length?o.push(l):o.push(withDirectives(l,i("dir#"+a.join(""),()=>{const e={prevent:!0,stop:!0,mouse:!0};return a.forEach(t=>{e[t]=!0}),[[TouchPan,g,void 0,e]]}))),h("div",{class:v.value},o)}}});const space=h("div",{class:"q-space"});var QSpace=createComponent({name:"QSpace",setup(){return()=>space}});const svg$l=[h("g",{transform:"matrix(1 0 0 -1 0 80)"},[h("rect",{width:"10",height:"20",rx:"3"},[h("animate",{attributeName:"height",begin:"0s",dur:"4.3s",values:"20;45;57;80;64;32;66;45;64;23;66;13;64;56;34;34;2;23;76;79;20",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"15",width:"10",height:"80",rx:"3"},[h("animate",{attributeName:"height",begin:"0s",dur:"2s",values:"80;55;33;5;75;23;73;33;12;14;60;80",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"30",width:"10",height:"50",rx:"3"},[h("animate",{attributeName:"height",begin:"0s",dur:"1.4s",values:"50;34;78;23;56;23;34;76;80;54;21;50",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"45",width:"10",height:"30",rx:"3"},[h("animate",{attributeName:"height",begin:"0s",dur:"2s",values:"30;45;13;80;56;72;45;76;34;23;67;30",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerAudio=createComponent({name:"QSpinnerAudio",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 55 80",xmlns:"http://www.w3.org/2000/svg"},svg$l)}});const svg$k=[h("g",{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"},[h("circle",{cx:"5",cy:"50",r:"5"},[h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;5;50;50",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"cx",begin:"0s",dur:"2.2s",values:"5;27;49;5",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"27",cy:"5",r:"5"},[h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",from:"5",to:"5",values:"5;50;50;5",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"cx",begin:"0s",dur:"2.2s",from:"27",to:"27",values:"27;49;5;27",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"49",cy:"50",r:"5"},[h("animate",{attributeName:"cy",begin:"0s",dur:"2.2s",values:"50;50;5;50",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"cx",from:"49",to:"49",begin:"0s",dur:"2.2s",values:"49;5;27;49",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerBall=createComponent({name:"QSpinnerBall",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 57 57",xmlns:"http://www.w3.org/2000/svg"},svg$k)}});const svg$j=[h("rect",{y:"10",width:"15",height:"120",rx:"6"},[h("animate",{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"30",y:"10",width:"15",height:"120",rx:"6"},[h("animate",{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"60",width:"15",height:"140",rx:"6"},[h("animate",{attributeName:"height",begin:"0s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"y",begin:"0s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"90",y:"10",width:"15",height:"120",rx:"6"},[h("animate",{attributeName:"height",begin:"0.25s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"y",begin:"0.25s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})]),h("rect",{x:"120",y:"10",width:"15",height:"120",rx:"6"},[h("animate",{attributeName:"height",begin:"0.5s",dur:"1s",values:"120;110;100;90;80;70;60;50;40;140;120",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"y",begin:"0.5s",dur:"1s",values:"10;15;20;25;30;35;40;45;50;0;10",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerBars=createComponent({name:"QSpinnerBars",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 135 140",xmlns:"http://www.w3.org/2000/svg"},svg$j)}});const svg$i=[h("rect",{x:"25",y:"25",width:"50",height:"50",fill:"none","stroke-width":"4",stroke:"currentColor"},[h("animateTransform",{id:"spinnerBox",attributeName:"transform",type:"rotate",from:"0 50 50",to:"180 50 50",dur:"0.5s",begin:"rectBox.end"})]),h("rect",{x:"27",y:"27",width:"46",height:"50",fill:"currentColor"},[h("animate",{id:"rectBox",attributeName:"height",begin:"0s;spinnerBox.end",dur:"1.3s",from:"50",to:"0",fill:"freeze"})])];var QSpinnerBox=createComponent({name:"QSpinnerBox",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$i)}});const svg$h=[h("circle",{cx:"50",cy:"50",r:"48",fill:"none","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor"}),h("line",{"stroke-linecap":"round","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor",x1:"50",y1:"50",x2:"85",y2:"50.5"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"2s",repeatCount:"indefinite"})]),h("line",{"stroke-linecap":"round","stroke-width":"4","stroke-miterlimit":"10",stroke:"currentColor",x1:"50",y1:"50",x2:"49.5",y2:"74"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"15s",repeatCount:"indefinite"})])];var QSpinnerClock=createComponent({name:"QSpinnerClock",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$h)}});const svg$g=[h("rect",{x:"0",y:"0",width:" 100",height:"100",fill:"none"}),h("path",{d:"M78,19H22c-6.6,0-12,5.4-12,12v31c0,6.6,5.4,12,12,12h37.2c0.4,3,1.8,5.6,3.7,7.6c2.4,2.5,5.1,4.1,9.1,4 c-1.4-2.1-2-7.2-2-10.3c0-0.4,0-0.8,0-1.3h8c6.6,0,12-5.4,12-12V31C90,24.4,84.6,19,78,19z",fill:"currentColor"}),h("circle",{cx:"30",cy:"47",r:"5",fill:"#fff"},[h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;1;1",keyTimes:"0;0.2;1",dur:"1s",repeatCount:"indefinite"})]),h("circle",{cx:"50",cy:"47",r:"5",fill:"#fff"},[h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.2;0.4;1",dur:"1s",repeatCount:"indefinite"})]),h("circle",{cx:"70",cy:"47",r:"5",fill:"#fff"},[h("animate",{attributeName:"opacity",from:"0",to:"1",values:"0;0;1;1",keyTimes:"0;0.4;0.6;1",dur:"1s",repeatCount:"indefinite"})])];var QSpinnerComment=createComponent({name:"QSpinnerComment",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$g)}});const svg$f=[h("rect",{x:"0",y:"0",width:" 100",height:"100",fill:"none"}),h("g",{transform:"translate(25 25)"},[h("rect",{x:"-20",y:"-20",width:" 40",height:"40",fill:"currentColor",opacity:"0.9"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),h("g",{transform:"translate(75 25)"},[h("rect",{x:"-20",y:"-20",width:" 40",height:"40",fill:"currentColor",opacity:"0.8"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.1s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),h("g",{transform:"translate(25 75)"},[h("rect",{x:"-20",y:"-20",width:" 40",height:"40",fill:"currentColor",opacity:"0.7"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.3s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])]),h("g",{transform:"translate(75 75)"},[h("rect",{x:"-20",y:"-20",width:" 40",height:"40",fill:"currentColor",opacity:"0.6"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"1.5",to:"1",repeatCount:"indefinite",begin:"0.2s",dur:"1s",calcMode:"spline",keySplines:"0.2 0.8 0.2 0.8",keyTimes:"0;1"})])])];var QSpinnerCube=createComponent({name:"QSpinnerCube",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$f)}});const svg$e=[h("circle",{cx:"15",cy:"15",r:"15"},[h("animate",{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"60",cy:"15",r:"9","fill-opacity":".3"},[h("animate",{attributeName:"r",from:"9",to:"9",begin:"0s",dur:"0.8s",values:"9;15;9",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"fill-opacity",from:".5",to:".5",begin:"0s",dur:"0.8s",values:".5;1;.5",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"105",cy:"15",r:"15"},[h("animate",{attributeName:"r",from:"15",to:"15",begin:"0s",dur:"0.8s",values:"15;9;15",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"fill-opacity",from:"1",to:"1",begin:"0s",dur:"0.8s",values:"1;.5;1",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerDots=createComponent({name:"QSpinnerDots",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 120 30",xmlns:"http://www.w3.org/2000/svg"},svg$e)}});const svg$d=[h("g",{transform:"translate(20 50)"},[h("rect",{x:"-10",y:"-30",width:" 20",height:"60",fill:"currentColor",opacity:"0.6"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])]),h("g",{transform:"translate(50 50)"},[h("rect",{x:"-10",y:"-30",width:" 20",height:"60",fill:"currentColor",opacity:"0.8"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.1s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])]),h("g",{transform:"translate(80 50)"},[h("rect",{x:"-10",y:"-30",width:" 20",height:"60",fill:"currentColor",opacity:"0.9"},[h("animateTransform",{attributeName:"transform",type:"scale",from:"2",to:"1",begin:"0.2s",repeatCount:"indefinite",dur:"1s",calcMode:"spline",keySplines:"0.1 0.9 0.4 1",keyTimes:"0;1",values:"2;1"})])])];var QSpinnerFacebook=createComponent({name:"QSpinnerFacebook",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",xmlns:"http://www.w3.org/2000/svg",preserveAspectRatio:"xMidYMid"},svg$d)}});const svg$c=[h("g",{transform:"translate(-20,-20)"},[h("path",{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"90 50 50",to:"0 50 50",dur:"1s",repeatCount:"indefinite"})])]),h("g",{transform:"translate(20,20) rotate(15 50 50)"},[h("path",{d:"M79.9,52.6C80,51.8,80,50.9,80,50s0-1.8-0.1-2.6l-5.1-0.4c-0.3-2.4-0.9-4.6-1.8-6.7l4.2-2.9c-0.7-1.6-1.6-3.1-2.6-4.5 L70,35c-1.4-1.9-3.1-3.5-4.9-4.9l2.2-4.6c-1.4-1-2.9-1.9-4.5-2.6L59.8,27c-2.1-0.9-4.4-1.5-6.7-1.8l-0.4-5.1C51.8,20,50.9,20,50,20 s-1.8,0-2.6,0.1l-0.4,5.1c-2.4,0.3-4.6,0.9-6.7,1.8l-2.9-4.1c-1.6,0.7-3.1,1.6-4.5,2.6l2.1,4.6c-1.9,1.4-3.5,3.1-5,4.9l-4.5-2.1 c-1,1.4-1.9,2.9-2.6,4.5l4.1,2.9c-0.9,2.1-1.5,4.4-1.8,6.8l-5,0.4C20,48.2,20,49.1,20,50s0,1.8,0.1,2.6l5,0.4 c0.3,2.4,0.9,4.7,1.8,6.8l-4.1,2.9c0.7,1.6,1.6,3.1,2.6,4.5l4.5-2.1c1.4,1.9,3.1,3.5,5,4.9l-2.1,4.6c1.4,1,2.9,1.9,4.5,2.6l2.9-4.1 c2.1,0.9,4.4,1.5,6.7,1.8l0.4,5.1C48.2,80,49.1,80,50,80s1.8,0,2.6-0.1l0.4-5.1c2.3-0.3,4.6-0.9,6.7-1.8l2.9,4.2 c1.6-0.7,3.1-1.6,4.5-2.6L65,69.9c1.9-1.4,3.5-3,4.9-4.9l4.6,2.2c1-1.4,1.9-2.9,2.6-4.5L73,59.8c0.9-2.1,1.5-4.4,1.8-6.7L79.9,52.6 z M50,65c-8.3,0-15-6.7-15-15c0-8.3,6.7-15,15-15s15,6.7,15,15C65,58.3,58.3,65,50,65z",fill:"currentColor"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"90 50 50",dur:"1s",repeatCount:"indefinite"})])])];var QSpinnerGears=createComponent({name:"QSpinnerGears",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$c)}});const svg$b=[h("circle",{cx:"12.5",cy:"12.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"0s",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"12.5",cy:"52.5",r:"12.5","fill-opacity":".5"},[h("animate",{attributeName:"fill-opacity",begin:"100ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"52.5",cy:"12.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"300ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"52.5",cy:"52.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"600ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"92.5",cy:"12.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"800ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"92.5",cy:"52.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"400ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"12.5",cy:"92.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"700ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"52.5",cy:"92.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"500ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"92.5",cy:"92.5",r:"12.5"},[h("animate",{attributeName:"fill-opacity",begin:"200ms",dur:"1s",values:"1;.2;1",calcMode:"linear",repeatCount:"indefinite"})])];var QSpinnerGrid=createComponent({name:"QSpinnerGrid",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 105 105",xmlns:"http://www.w3.org/2000/svg"},svg$b)}});const svg$a=[h("path",{d:"M30.262 57.02L7.195 40.723c-5.84-3.976-7.56-12.06-3.842-18.063 3.715-6 11.467-7.65 17.306-3.68l4.52 3.76 2.6-5.274c3.716-6.002 11.47-7.65 17.304-3.68 5.84 3.97 7.56 12.054 3.842 18.062L34.49 56.118c-.897 1.512-2.793 1.915-4.228.9z","fill-opacity":".5"},[h("animate",{attributeName:"fill-opacity",begin:"0s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"})]),h("path",{d:"M105.512 56.12l-14.44-24.272c-3.716-6.008-1.996-14.093 3.843-18.062 5.835-3.97 13.588-2.322 17.306 3.68l2.6 5.274 4.52-3.76c5.84-3.97 13.593-2.32 17.308 3.68 3.718 6.003 1.998 14.088-3.842 18.064L109.74 57.02c-1.434 1.014-3.33.61-4.228-.9z","fill-opacity":".5"},[h("animate",{attributeName:"fill-opacity",begin:"0.7s",dur:"1.4s",values:"0.5;1;0.5",calcMode:"linear",repeatCount:"indefinite"})]),h("path",{d:"M67.408 57.834l-23.01-24.98c-5.864-6.15-5.864-16.108 0-22.248 5.86-6.14 15.37-6.14 21.234 0L70 16.168l4.368-5.562c5.863-6.14 15.375-6.14 21.235 0 5.863 6.14 5.863 16.098 0 22.247l-23.007 24.98c-1.43 1.556-3.757 1.556-5.188 0z"})];var QSpinnerHearts=createComponent({name:"QSpinnerHearts",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,fill:"currentColor",width:t.value,height:t.value,viewBox:"0 0 140 64",xmlns:"http://www.w3.org/2000/svg"},svg$a)}});const svg$9=[h("g",[h("path",{fill:"none",stroke:"currentColor","stroke-width":"5","stroke-miterlimit":"10",d:"M58.4,51.7c-0.9-0.9-1.4-2-1.4-2.3s0.5-0.4,1.4-1.4 C70.8,43.8,79.8,30.5,80,15.5H70H30H20c0.2,15,9.2,28.1,21.6,32.3c0.9,0.9,1.4,1.2,1.4,1.5s-0.5,1.6-1.4,2.5 C29.2,56.1,20.2,69.5,20,85.5h10h40h10C79.8,69.5,70.8,55.9,58.4,51.7z"}),h("clipPath",{id:"uil-hourglass-clip1"},[h("rect",{x:"15",y:"20",width:" 70",height:"25"},[h("animate",{attributeName:"height",from:"25",to:"0",dur:"1s",repeatCount:"indefinite",values:"25;0;0",keyTimes:"0;0.5;1"}),h("animate",{attributeName:"y",from:"20",to:"45",dur:"1s",repeatCount:"indefinite",values:"20;45;45",keyTimes:"0;0.5;1"})])]),h("clipPath",{id:"uil-hourglass-clip2"},[h("rect",{x:"15",y:"55",width:" 70",height:"25"},[h("animate",{attributeName:"height",from:"0",to:"25",dur:"1s",repeatCount:"indefinite",values:"0;25;25",keyTimes:"0;0.5;1"}),h("animate",{attributeName:"y",from:"80",to:"55",dur:"1s",repeatCount:"indefinite",values:"80;55;55",keyTimes:"0;0.5;1"})])]),h("path",{d:"M29,23c3.1,11.4,11.3,19.5,21,19.5S67.9,34.4,71,23H29z","clip-path":"url(#uil-hourglass-clip1)",fill:"currentColor"}),h("path",{d:"M71.6,78c-3-11.6-11.5-20-21.5-20s-18.5,8.4-21.5,20H71.6z","clip-path":"url(#uil-hourglass-clip2)",fill:"currentColor"}),h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"180 50 50",repeatCount:"indefinite",dur:"1s",values:"0 50 50;0 50 50;180 50 50",keyTimes:"0;0.7;1"})])];var QSpinnerHourglass=createComponent({name:"QSpinnerHourglass",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$9)}});const svg$8=[h("path",{d:"M24.3,30C11.4,30,5,43.3,5,50s6.4,20,19.3,20c19.3,0,32.1-40,51.4-40C88.6,30,95,43.3,95,50s-6.4,20-19.3,20C56.4,70,43.6,30,24.3,30z",fill:"none",stroke:"currentColor","stroke-width":"8","stroke-dasharray":"10.691205342610678 10.691205342610678","stroke-dashoffset":"0"},[h("animate",{attributeName:"stroke-dashoffset",from:"0",to:"21.382410685221355",begin:"0",dur:"2s",repeatCount:"indefinite",fill:"freeze"})])];var QSpinnerInfinity=createComponent({name:"QSpinnerInfinity",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid"},svg$8)}});const svg$7=[h("g",{"stroke-width":"4","stroke-linecap":"round"},[h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(180)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(210)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(240)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".1;0;1;.85;.7;.65;.55;.45;.35;.25;.15;.1",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(270)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".15;.1;0;1;.85;.7;.65;.55;.45;.35;.25;.15",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(300)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".25;.15;.1;0;1;.85;.7;.65;.55;.45;.35;.25",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(330)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".35;.25;.15;.1;0;1;.85;.7;.65;.55;.45;.35",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(0)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".45;.35;.25;.15;.1;0;1;.85;.7;.65;.55;.45",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(30)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".55;.45;.35;.25;.15;.1;0;1;.85;.7;.65;.55",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(60)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".65;.55;.45;.35;.25;.15;.1;0;1;.85;.7;.65",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(90)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".7;.65;.55;.45;.35;.25;.15;.1;0;1;.85;.7",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(120)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:".85;.7;.65;.55;.45;.35;.25;.15;.1;0;1;.85",repeatCount:"indefinite"})]),h("line",{y1:"17",y2:"29",transform:"translate(32,32) rotate(150)"},[h("animate",{attributeName:"stroke-opacity",dur:"750ms",values:"1;.85;.7;.65;.55;.45;.35;.25;.15;.1;0;1",repeatCount:"indefinite"})])])];var QSpinnerIos=createComponent({name:"QSpinnerIos",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,stroke:"currentColor",fill:"currentColor",viewBox:"0 0 64 64"},svg$7)}});const svg$6=[h("circle",{cx:"50",cy:"50",r:"44",fill:"none","stroke-width":"4","stroke-opacity":".5",stroke:"currentColor"}),h("circle",{cx:"8",cy:"54",r:"6",fill:"currentColor","stroke-width":"3",stroke:"currentColor"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 48",to:"360 50 52",dur:"2s",repeatCount:"indefinite"})])];var QSpinnerOrbit=createComponent({name:"QSpinnerOrbit",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$6)}});const svg$5=[h("g",{transform:"translate(1 1)","stroke-width":"2",fill:"none","fill-rule":"evenodd"},[h("circle",{"stroke-opacity":".5",cx:"18",cy:"18",r:"18"}),h("path",{d:"M36 18c0-9.94-8.06-18-18-18"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"1s",repeatCount:"indefinite"})])])];var QSpinnerOval=createComponent({name:"QSpinnerOval",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"},svg$5)}});const svg$4=[h("path",{d:"M0 50A50 50 0 0 1 50 0L50 50L0 50",fill:"currentColor",opacity:"0.5"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"0.8s",repeatCount:"indefinite"})]),h("path",{d:"M50 0A50 50 0 0 1 100 50L50 50L50 0",fill:"currentColor",opacity:"0.5"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"1.6s",repeatCount:"indefinite"})]),h("path",{d:"M100 50A50 50 0 0 1 50 100L50 50L100 50",fill:"currentColor",opacity:"0.5"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"2.4s",repeatCount:"indefinite"})]),h("path",{d:"M50 100A50 50 0 0 1 0 50L50 50L50 100",fill:"currentColor",opacity:"0.5"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 50 50",to:"360 50 50",dur:"3.2s",repeatCount:"indefinite"})])];var QSpinnerPie=createComponent({name:"QSpinnerPie",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$4)}});const svg$3=[h("g",{fill:"none","fill-rule":"evenodd","stroke-width":"2"},[h("circle",{cx:"22",cy:"22",r:"1"},[h("animate",{attributeName:"r",begin:"0s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-opacity",begin:"0s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"})]),h("circle",{cx:"22",cy:"22",r:"1"},[h("animate",{attributeName:"r",begin:"-0.9s",dur:"1.8s",values:"1; 20",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.165, 0.84, 0.44, 1",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-opacity",begin:"-0.9s",dur:"1.8s",values:"1; 0",calcMode:"spline",keyTimes:"0; 1",keySplines:"0.3, 0.61, 0.355, 1",repeatCount:"indefinite"})])])];var QSpinnerPuff=createComponent({name:"QSpinnerPuff",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 44 44",xmlns:"http://www.w3.org/2000/svg"},svg$3)}});const svg$2=[h("g",{transform:"scale(0.55)"},[h("circle",{cx:"30",cy:"150",r:"30",fill:"currentColor"},[h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})]),h("path",{d:"M90,150h30c0-49.7-40.3-90-90-90v30C63.1,90,90,116.9,90,150z",fill:"currentColor"},[h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.1",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})]),h("path",{d:"M150,150h30C180,67.2,112.8,0,30,0v30C96.3,30,150,83.7,150,150z",fill:"currentColor"},[h("animate",{attributeName:"opacity",from:"0",to:"1",dur:"1s",begin:"0.2",repeatCount:"indefinite",keyTimes:"0;0.5;1",values:"0;1;1"})])])];var QSpinnerRadio=createComponent({name:"QSpinnerRadio",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 100 100",preserveAspectRatio:"xMidYMid",xmlns:"http://www.w3.org/2000/svg"},svg$2)}});const svg$1=[h("g",{fill:"none","fill-rule":"evenodd",transform:"translate(1 1)","stroke-width":"2"},[h("circle",{cx:"22",cy:"22",r:"6"},[h("animate",{attributeName:"r",begin:"1.5s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-opacity",begin:"1.5s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-width",begin:"1.5s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"22",cy:"22",r:"6"},[h("animate",{attributeName:"r",begin:"3s",dur:"3s",values:"6;22",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-opacity",begin:"3s",dur:"3s",values:"1;0",calcMode:"linear",repeatCount:"indefinite"}),h("animate",{attributeName:"stroke-width",begin:"3s",dur:"3s",values:"2;0",calcMode:"linear",repeatCount:"indefinite"})]),h("circle",{cx:"22",cy:"22",r:"8"},[h("animate",{attributeName:"r",begin:"0s",dur:"1.5s",values:"6;1;2;3;4;5;6",calcMode:"linear",repeatCount:"indefinite"})])])];var QSpinnerRings=createComponent({name:"QSpinnerRings",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,stroke:"currentColor",width:t.value,height:t.value,viewBox:"0 0 45 45",xmlns:"http://www.w3.org/2000/svg"},svg$1)}});const svg=[h("defs",[h("linearGradient",{x1:"8.042%",y1:"0%",x2:"65.682%",y2:"23.865%",id:"a"},[h("stop",{"stop-color":"currentColor","stop-opacity":"0",offset:"0%"}),h("stop",{"stop-color":"currentColor","stop-opacity":".631",offset:"63.146%"}),h("stop",{"stop-color":"currentColor",offset:"100%"})])]),h("g",{transform:"translate(1 1)",fill:"none","fill-rule":"evenodd"},[h("path",{d:"M36 18c0-9.94-8.06-18-18-18",stroke:"url(#a)","stroke-width":"2"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"})]),h("circle",{fill:"currentColor",cx:"36",cy:"18",r:"1"},[h("animateTransform",{attributeName:"transform",type:"rotate",from:"0 18 18",to:"360 18 18",dur:"0.9s",repeatCount:"indefinite"})])])];var QSpinnerTail=createComponent({name:"QSpinnerTail",props:useSpinnerProps,setup(e){const{cSize:t,classes:o}=useSpinner(e);return()=>h("svg",{class:o.value,width:t.value,height:t.value,viewBox:"0 0 38 38",xmlns:"http://www.w3.org/2000/svg"},svg)}}),QSplitter=createComponent({name:"QSplitter",props:{...useDarkProps,modelValue:{type:Number,required:!0},reverse:Boolean,unit:{type:String,default:"%",validator:e=>["%","px"].includes(e)},limits:{type:Array,validator:e=>{return 2===e.length&&("number"===typeof e[0]&&"number"===typeof e[1]&&(e[0]>=0&&e[0]<=e[1]))}},emitImmediately:Boolean,horizontal:Boolean,disable:Boolean,beforeClass:[Array,String,Object],afterClass:[Array,String,Object],separatorClass:[Array,String,Object],separatorStyle:[Array,String,Object]},emits:["update:modelValue"],setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useDark(e,n),l=ref(null),i={before:ref(null),after:ref(null)},r=computed(()=>"q-splitter no-wrap "+`${!0===e.horizontal?"q-splitter--horizontal column":"q-splitter--vertical row"}`+` q-splitter--${!0===e.disable?"disabled":"workable"}`+(!0===a.value?" q-splitter--dark":"")),s=computed(()=>!0===e.horizontal?"height":"width"),u=computed(()=>!0!==e.reverse?"before":"after"),c=computed(()=>void 0!==e.limits?e.limits:"%"===e.unit?[10,90]:[50,1/0]);function d(t){return("%"===e.unit?t:Math.round(t))+e.unit}const p=computed(()=>({[u.value]:{[s.value]:d(e.modelValue)}}));let v,m,f,g,b;function y(t){if(!0===t.isFirst){const t=l.value.getBoundingClientRect()[s.value];return v=!0===e.horizontal?"up":"left",m="%"===e.unit?100:t,f=Math.min(m,c.value[1],Math.max(c.value[0],e.modelValue)),g=(!0!==e.reverse?1:-1)*(!0===e.horizontal?1:!0===n.lang.rtl?-1:1)*("%"===e.unit?0===t?0:100/t:1),void l.value.classList.add("q-splitter--active")}if(!0===t.isFinal)return b!==e.modelValue&&o("update:modelValue",b),void l.value.classList.remove("q-splitter--active");const a=f+g*(t.direction===v?-1:1)*t.distance[!0===e.horizontal?"y":"x"];b=Math.min(m,c.value[1],Math.max(c.value[0],a)),i[u.value].value.style[s.value]=d(b),!0===e.emitImmediately&&e.modelValue!==b&&o("update:modelValue",b)}const S=computed(()=>{return[[TouchPan,y,void 0,{[!0===e.horizontal?"vertical":"horizontal"]:!0,prevent:!0,stop:!0,mouse:!0,mouseAllDir:!0}]]});function w(e,t){e<t[0]?o("update:modelValue",t[0]):e>t[1]&&o("update:modelValue",t[1])}return watch(()=>e.modelValue,e=>{w(e,c.value)}),watch(()=>e.limits,()=>{nextTick(()=>{w(e.modelValue,c.value)})}),()=>{const o=[h("div",{ref:i.before,class:["q-splitter__panel q-splitter__before"+(!0===e.reverse?" col":""),e.beforeClass],style:p.value.before},hSlot(t.before)),h("div",{class:["q-splitter__separator",e.separatorClass],style:e.separatorStyle,"aria-disabled":!0===e.disable?"true":void 0},[hDir("div",{class:"q-splitter__separator-area absolute-full"},hSlot(t.separator),"sep",!0!==e.disable,()=>S.value)]),h("div",{ref:i.after,class:["q-splitter__panel q-splitter__after"+(!0===e.reverse?"":" col"),e.afterClass],style:p.value.after},hSlot(t.after))];return h("div",{class:r.value,ref:l},hMergeSlot(t.default,o))}}}),StepHeader=createComponent({name:"StepHeader",props:{stepper:{},step:{},goToPanel:Function},setup(e,{attrs:t}){const{proxy:{$q:o}}=getCurrentInstance(),n=ref(null),a=computed(()=>e.stepper.modelValue===e.step.name),l=computed(()=>{const t=e.step.disable;return!0===t||""===t}),i=computed(()=>{const t=e.step.error;return!0===t||""===t}),r=computed(()=>{const t=e.step.done;return!1===l.value&&(!0===t||""===t)}),s=computed(()=>{const t=e.step.headerNav,o=!0===t||""===t||void 0===t;return!1===l.value&&e.stepper.headerNav&&o}),u=computed(()=>{return e.step.prefix&&!1===a.value&&!1===i.value&&!1===r.value}),c=computed(()=>{return!0===a.value?e.step.activeIcon||e.stepper.activeIcon||o.iconSet.stepper.active:!0===i.value?e.step.errorIcon||e.stepper.errorIcon||o.iconSet.stepper.error:!1===l.value&&!0===r.value?e.step.doneIcon||e.stepper.doneIcon||o.iconSet.stepper.done:e.step.icon||e.stepper.inactiveIcon}),d=computed(()=>{const t=!0===i.value?e.step.errorColor||e.stepper.errorColor:void 0;if(!0===a.value){const o=e.step.activeColor||e.stepper.activeColor||e.step.color;return void 0!==o?o:t}return void 0!==t?t:!1===l.value&&!0===r.value?e.step.doneColor||e.stepper.doneColor||e.step.color||e.stepper.inactiveColor:e.step.color||e.stepper.inactiveColor}),p=computed(()=>{return"q-stepper__tab col-grow flex items-center no-wrap relative-position"+(void 0!==d.value?` text-${d.value}`:"")+(!0===i.value?" q-stepper__tab--error":"")+(!0===a.value?" q-stepper__tab--active":"")+(!0===r.value?" q-stepper__tab--done":"")+(!0===s.value?" q-stepper__tab--navigation q-focusable q-hoverable":"")+(!0===l.value?" q-stepper__tab--disabled":"")}),v=computed(()=>!0===e.stepper.headerNav&&s.value);function m(){null!==n.value&&n.value.focus(),!1===a.value&&e.goToPanel(e.step.name)}function f(t){13===t.keyCode&&!1===a.value&&e.goToPanel(e.step.name)}return()=>{const o={class:p.value};!0===s.value&&(o.onClick=m,o.onKeyup=f,Object.assign(o,!0===l.value?{tabindex:-1,"aria-disabled":"true"}:{tabindex:t.tabindex||0}));const a=[h("div",{class:"q-focus-helper",tabindex:-1,ref:n}),h("div",{class:"q-stepper__dot row flex-center q-stepper__line relative-position"},[h("span",{class:"row flex-center"},[!0===u.value?e.step.prefix:h(QIcon,{name:c.value})])])];if(void 0!==e.step.title&&null!==e.step.title){const t=[h("div",{class:"q-stepper__title"},e.step.title)];void 0!==e.step.caption&&null!==e.step.caption&&t.push(h("div",{class:"q-stepper__caption"},e.step.caption)),a.push(h("div",{class:"q-stepper__label q-stepper__line relative-position"},t))}return withDirectives(h("div",o,a),[[Ripple,v.value]])}}});function getStepWrapper(e){return h("div",{class:"q-stepper__step-content"},[h("div",{class:"q-stepper__step-inner"},hSlot(e.default))])}const PanelWrapper={setup(e,{slots:t}){return()=>getStepWrapper(t)}};var QStep=createComponent({name:"QStep",props:{...usePanelChildProps,icon:String,color:String,title:{type:String,required:!0},caption:String,prefix:[String,Number],doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String,headerNav:{type:Boolean,default:!0},done:Boolean,error:Boolean},setup(e,{attrs:t,slots:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=inject(stepperKey,()=>{console.error("QStep needs to be child of QStepper")}),{getCacheWithFn:l}=useCache(),i=ref(null),r=computed(()=>a.value.modelValue===e.name),s=computed(()=>!0!==n.platform.is.ios&&!0===n.platform.is.chrome||!0!==r.value||!0!==a.value.vertical?{}:{onScroll(e){const{target:o}=e;o.scrollTop>0&&(o.scrollTop=0),void 0!==t.onScroll&&t.onScroll(e)}}),u=computed(()=>"string"===typeof e.name||"number"===typeof e.name?e.name:String(e.name));function c(){const e=a.value.vertical;return!0===e&&!0===a.value.keepAlive?h(KeepAlive,a.value.keepAliveProps.value,!0===r.value?[h(!0===a.value.needsUniqueKeepAliveWrapper.value?l(u.value,()=>({...PanelWrapper,name:u.value})):PanelWrapper,{key:u.value},o.default)]:void 0):!0!==e||!0===r.value?getStepWrapper(o):void 0}return()=>h("div",{ref:i,class:"q-stepper__step",...s.value},!0===a.value.vertical?[h(StepHeader,{stepper:a.value,step:e,goToPanel:a.value.goToPanel}),!0===a.value.animated?h(QSlideTransition,c):c()]:[c()])}});const camelRE=/(-\w)/g;function camelizeProps(e){const t={};for(const o in e){const n=o.replace(camelRE,e=>e[1].toUpperCase());t[n]=e[o]}return t}var QStepper=createComponent({name:"QStepper",props:{...useDarkProps,...usePanelProps,flat:Boolean,bordered:Boolean,alternativeLabels:Boolean,headerNav:Boolean,contracted:Boolean,headerClass:String,inactiveColor:String,inactiveIcon:String,doneIcon:String,doneColor:String,activeIcon:String,activeColor:String,errorIcon:String,errorColor:String},emits:usePanelEmits,setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q),{updatePanelsList:a,isValidPanelName:l,updatePanelIndex:i,getPanelContent:r,getPanels:s,panelDirectives:u,goToPanel:c,keepAliveProps:d,needsUniqueKeepAliveWrapper:p}=usePanel();provide(stepperKey,computed(()=>({goToPanel:c,keepAliveProps:d,needsUniqueKeepAliveWrapper:p,...e})));const v=computed(()=>`q-stepper q-stepper--${!0===e.vertical?"vertical":"horizontal"}`+(!0===e.flat||!0===n.value?" q-stepper--flat no-shadow":"")+(!0===e.bordered||!0===n.value&&!1===e.flat?" q-stepper--bordered":"")+(!0===n.value?" q-stepper--dark q-dark":"")),m=computed(()=>"q-stepper__header row items-stretch justify-between"+` q-stepper__header--${!0===e.alternativeLabels?"alternative":"standard"}-labels`+(!1===e.flat||!0===e.bordered?" q-stepper__header--border":"")+(!0===e.contracted?" q-stepper__header--contracted":"")+(void 0!==e.headerClass?` ${e.headerClass}`:""));function f(){const o=hSlot(t.message,[]);if(!0===e.vertical){l(e.modelValue)&&i();const n=h("div",{class:"q-stepper__content"},hSlot(t.default));return void 0===o?[n]:o.concat(n)}return[h("div",{class:m.value},s().map(t=>{const o=camelizeProps(t.props);return h(StepHeader,{key:o.name,stepper:e,step:o,goToPanel:c})})),o,hDir("div",{class:"q-stepper__content q-panel-parent"},r(),"cont",e.swipeable,()=>u.value)]}return()=>{return a(t),h("div",{class:v.value},hMergeSlot(t.navigation,f()))}}}),QStepperNavigation=createComponent({name:"QStepperNavigation",setup(e,{slots:t}){return()=>h("div",{class:"q-stepper__nav"},hSlot(t.default))}}),QTh=createComponent({name:"QTh",props:{props:Object,autoWidth:Boolean},emits:["click"],setup(e,{slots:t,emit:o}){const n=getCurrentInstance(),{proxy:{$q:a}}=n;return()=>{if(void 0===e.props)return h("th",{class:!0===e.autoWidth?"q-table--col-auto-width":""},hSlot(t.default));let l,i;const r=n.vnode.key;if(r){if(l=e.props.colsMap[r],void 0===l)return}else l=e.props.col;if(!0===l.sortable){const e="right"===l.align?"unshift":"push";i=hUniqueSlot(t.default,[]),i[e](h(QIcon,{class:l.__iconClass,name:a.iconSet.table.arrowUp}))}else i=hSlot(t.default);const s={class:l.__thClass+(!0===e.autoWidth?" q-table--col-auto-width":""),style:l.headerStyle,onClick:t=>{!0===l.sortable&&e.props.sort(l),o("click",t)}};return h("th",s,i)}}});function getTableMiddle(e,t){return h("div",e,[h("table",{class:"q-table"},t)])}const comps={list:QList,table:QMarkupTable},typeOptions=["list","table","__qtable"];var QVirtualScroll=createComponent({name:"QVirtualScroll",props:{...useVirtualScrollProps,type:{type:String,default:"list",validator:e=>typeOptions.includes(e)},items:{type:Array,default:()=>[]},itemsFn:Function,itemsSize:Number,scrollTarget:{default:void 0}},setup(e,{slots:t,attrs:o}){let n;const a=ref(null),l=computed(()=>e.itemsSize>=0&&void 0!==e.itemsFn?parseInt(e.itemsSize,10):Array.isArray(e.items)?e.items.length:0),{virtualScrollSliceRange:i,localResetVirtualScroll:r,padVirtualScroll:s,onVirtualScrollEvt:u}=useVirtualScroll({virtualScrollLength:l,getVirtualScrollTarget:m,getVirtualScrollEl:v}),c=computed(()=>{if(0===l.value)return[];const t=(e,t)=>({index:i.value.from+t,item:e});return void 0===e.itemsFn?e.items.slice(i.value.from,i.value.to).map(t):e.itemsFn(i.value.from,i.value.to-i.value.from).map(t)}),d=computed(()=>"q-virtual-scroll q-virtual-scroll"+(!0===e.virtualScrollHorizontal?"--horizontal":"--vertical")+(void 0!==e.scrollTarget?"":" scroll")),p=computed(()=>void 0!==e.scrollTarget?{}:{tabindex:0});function v(){return a.value.$el||a.value}function m(){return n}function f(){n=getScrollTarget(v(),e.scrollTarget),n.addEventListener("scroll",u,listenOpts.passive)}function g(){void 0!==n&&(n.removeEventListener("scroll",u,listenOpts.passive),n=void 0)}function b(){let o=s("list"===e.type?"div":"tbody",c.value.map(t.default));return void 0!==t.before&&(o=t.before().concat(o)),hMergeSlot(t.after,o)}return watch(l,()=>{r()}),watch(()=>e.scrollTarget,()=>{g(),f()}),onBeforeMount(()=>{r()}),onMounted(()=>{f()}),onBeforeUnmount(()=>{g()}),()=>{if(void 0!==t.default)return"__qtable"===e.type?getTableMiddle({ref:a,class:"q-table__middle "+d.value},b()):h(comps[e.type],{...o,ref:a,class:[o.class,d.value],...p.value},b);console.error("QVirtualScroll: default scoped slot is required for rendering")}}});function sortDate(e,t){return new Date(e)-new Date(t)}const useTableSortProps={sortMethod:Function,binaryStateSort:Boolean,columnSortOrder:{type:String,validator:e=>"ad"===e||"da"===e,default:"ad"}};function useTableSort(e,t,o,n){const a=computed(()=>{const{sortBy:e}=t.value;return e&&o.value.find(t=>t.name===e)||null}),l=computed(()=>void 0!==e.sortMethod?e.sortMethod:(e,t,n)=>{const a=o.value.find(e=>e.name===t);if(void 0===a||void 0===a.field)return e;const l=!0===n?-1:1,i="function"===typeof a.field?e=>a.field(e):e=>e[a.field];return e.sort((e,t)=>{let o=i(e),n=i(t);return null===o||void 0===o?-1*l:null===n||void 0===n?1*l:void 0!==a.sort?a.sort(o,n,e,t)*l:!0===isNumber(o)&&!0===isNumber(n)?(o-n)*l:!0===isDate(o)&&!0===isDate(n)?sortDate(o,n)*l:"boolean"===typeof o&&"boolean"===typeof n?(o-n)*l:([o,n]=[o,n].map(e=>(e+"").toLocaleString().toLowerCase()),o<n?-1*l:o===n?0:l)})});function i(a){let l=e.columnSortOrder;if(a===Object(a))a.sortOrder&&(l=a.sortOrder),a=a.name;else{const e=o.value.find(e=>e.name===a);void 0!==e&&e.sortOrder&&(l=e.sortOrder)}let{sortBy:i,descending:r}=t.value;i!==a?(i=a,r="da"===l):!0===e.binaryStateSort?r=!r:!0===r?"ad"===l?i=null:r=!1:"ad"===l?r=!0:i=null,n({sortBy:i,descending:r,page:1})}return{columnToSort:a,computedSortMethod:l,sort:i}}const useTableFilterProps={filter:[String,Object],filterMethod:Function};function useTableFilter(e,t){const o=computed(()=>void 0!==e.filterMethod?e.filterMethod:(e,t,o,n)=>{const a=t?t.toLowerCase():"";return e.filter(e=>o.some(t=>{const o=n(t,e)+"",l="undefined"===o||"null"===o?"":o.toLowerCase();return-1!==l.indexOf(a)}))});return watch(()=>e.filter,()=>{nextTick(()=>{t({page:1},!0)})},{deep:!0}),{computedFilterMethod:o}}function samePagination(e,t){for(const o in t)if(t[o]!==e[o])return!1;return!0}function fixPagination(e){return e.page<1&&(e.page=1),void 0!==e.rowsPerPage&&e.rowsPerPage<1&&(e.rowsPerPage=0),e}const useTablePaginationProps={pagination:Object,rowsPerPageOptions:{type:Array,default:()=>[5,7,10,15,20,25,50,0]},"onUpdate:pagination":[Function,Array]};function useTablePaginationState(e,t){const{props:o,emit:n}=e,a=ref(Object.assign({sortBy:null,descending:!1,page:1,rowsPerPage:o.rowsPerPageOptions.length>0?o.rowsPerPageOptions[0]:5},o.pagination)),l=computed(()=>{const e=void 0!==o["onUpdate:pagination"]?{...a.value,...o.pagination}:a.value;return fixPagination(e)}),i=computed(()=>void 0!==l.value.rowsNumber);function r(e){s({pagination:e,filter:o.filter})}function s(e={}){nextTick(()=>{n("request",{pagination:e.pagination||l.value,filter:e.filter||o.filter,getCellValue:t})})}function u(e,t){const s=fixPagination({...l.value,...e});!0!==samePagination(l.value,s)?!0!==i.value?void 0!==o.pagination&&void 0!==o["onUpdate:pagination"]?n("update:pagination",s):a.value=s:r(s):!0===i.value&&!0===t&&r(s)}return{innerPagination:a,computedPagination:l,isServerSide:i,requestServerInteraction:s,setPagination:u}}function useTablePagination(e,t,o,n,a,l){const{props:i,emit:r,proxy:{$q:s}}=e,u=computed(()=>!0===n.value?o.value.rowsNumber||0:l.value),c=computed(()=>{const{page:e,rowsPerPage:t}=o.value;return(e-1)*t}),d=computed(()=>{const{page:e,rowsPerPage:t}=o.value;return e*t}),p=computed(()=>1===o.value.page),v=computed(()=>0===o.value.rowsPerPage?1:Math.max(1,Math.ceil(u.value/o.value.rowsPerPage))),m=computed(()=>0===d.value||o.value.page>=v.value),f=computed(()=>{const e=i.rowsPerPageOptions.includes(t.value.rowsPerPage)?i.rowsPerPageOptions:[t.value.rowsPerPage].concat(i.rowsPerPageOptions);return e.map(e=>({label:0===e?s.lang.table.allRows:""+e,value:e}))});function h(){a({page:1})}function g(){const{page:e}=o.value;e>1&&a({page:e-1})}function b(){const{page:e,rowsPerPage:t}=o.value;d.value>0&&e*t<u.value&&a({page:e+1})}function y(){a({page:v.value})}return watch(v,(e,t)=>{if(e===t)return;const n=o.value.page;e&&!n?a({page:1}):e<n&&a({page:e})}),void 0!==i["onUpdate:pagination"]&&r("update:pagination",{...o.value}),{firstRowIndex:c,lastRowIndex:d,isFirstPage:p,isLastPage:m,pagesNumber:v,computedRowsPerPageOptions:f,computedRowsNumber:u,firstPage:h,prevPage:g,nextPage:b,lastPage:y}}const useTableRowSelectionProps={selection:{type:String,default:"none",validator:e=>["single","multiple","none"].includes(e)},selected:{type:Array,default:()=>[]}},useTableRowSelectionEmits=["update:selected","selection"];function useTableRowSelection(e,t,o,n){const a=computed(()=>{const t={};return e.selected.map(n.value).forEach(e=>{t[e]=!0}),t}),l=computed(()=>{return"none"!==e.selection}),i=computed(()=>{return"single"===e.selection}),r=computed(()=>{return"multiple"===e.selection}),s=computed(()=>o.value.length>0&&o.value.every(e=>!0===a.value[n.value(e)])),u=computed(()=>!0!==s.value&&o.value.some(e=>!0===a.value[n.value(e)])),c=computed(()=>e.selected.length);function d(e){return!0===a.value[e]}function p(){t("update:selected",[])}function v(o,a,l,r){t("selection",{rows:a,added:l,keys:o,evt:r});const s=!0===i.value?!0===l?a:[]:!0===l?e.selected.concat(a):e.selected.filter(e=>!1===o.includes(n.value(e)));t("update:selected",s)}return{hasSelectionMode:l,singleSelection:i,multipleSelection:r,allRowsSelected:s,someRowsSelected:u,rowsSelectedNumber:c,isRowSelected:d,clearSelection:p,updateSelection:v}}function getVal(e){return Array.isArray(e)?e.slice():[]}const useTableRowExpandProps={expanded:Array},useTableRowExpandEmits=["update:expanded"];function useTableRowExpand(e,t){const o=ref(getVal(e.expanded));function n(e){return o.value.includes(e)}function a(n){void 0!==e.expanded?t("update:expanded",n):o.value=n}function l(e,t){const n=o.value.slice(),l=n.indexOf(e);!0===t?-1===l&&(n.push(e),a(n)):-1!==l&&(n.splice(l,1),a(n))}return watch(()=>e.expanded,e=>{o.value=getVal(e)}),{isRowExpanded:n,setExpanded:a,updateExpanded:l}}const useTableColumnSelectionProps={visibleColumns:Array};function useTableColumnSelection(e,t,o){const n=computed(()=>{if(void 0!==e.columns)return e.columns;const t=e.rows[0];return void 0!==t?Object.keys(t).map(e=>({name:e,label:e.toUpperCase(),field:e,align:isNumber(t[e])?"right":"left",sortable:!0})):[]}),a=computed(()=>{const{sortBy:o,descending:a}=t.value,l=void 0!==e.visibleColumns?n.value.filter(t=>!0===t.required||!0===e.visibleColumns.includes(t.name)):n.value;return l.map(e=>{const t=e.align||"right",n=`text-${t}`;return{...e,align:t,__iconClass:`q-table__sort-icon q-table__sort-icon--${t}`,__thClass:n+(void 0!==e.headerClasses?" "+e.headerClasses:"")+(!0===e.sortable?" sortable":"")+(e.name===o?` sorted ${!0===a?"sort-desc":""}`:""),__tdStyle:void 0!==e.style?"function"!==typeof e.style?()=>e.style:e.style:()=>null,__tdClass:void 0!==e.classes?"function"!==typeof e.classes?()=>n+" "+e.classes:t=>n+" "+e.classes(t):()=>n}})}),l=computed(()=>{const e={};return a.value.forEach(t=>{e[t.name]=t}),e}),i=computed(()=>{return void 0!==e.tableColspan?e.tableColspan:a.value.length+(!0===o.value?1:0)});return{colList:n,computedCols:a,computedColsMap:l,computedColspan:i}}const bottomClass="q-table__bottom row items-center",commonVirtPropsObj={};commonVirtPropsList.forEach(e=>{commonVirtPropsObj[e]={}});var QTable=createComponent({name:"QTable",props:{rows:{type:Array,default:()=>[]},rowKey:{type:[String,Function],default:"id"},columns:Array,loading:Boolean,iconFirstPage:String,iconPrevPage:String,iconNextPage:String,iconLastPage:String,title:String,hideHeader:Boolean,grid:Boolean,gridHeader:Boolean,dense:Boolean,flat:Boolean,bordered:Boolean,square:Boolean,separator:{type:String,default:"horizontal",validator:e=>["horizontal","vertical","cell","none"].includes(e)},wrapCells:Boolean,virtualScroll:Boolean,...commonVirtPropsObj,noDataLabel:String,noResultsLabel:String,loadingLabel:String,selectedRowsLabel:Function,rowsPerPageLabel:String,paginationLabel:Function,color:{type:String,default:"grey-8"},titleClass:[String,Array,Object],tableStyle:[String,Array,Object],tableClass:[String,Array,Object],tableHeaderStyle:[String,Array,Object],tableHeaderClass:[String,Array,Object],cardContainerClass:[String,Array,Object],cardContainerStyle:[String,Array,Object],cardStyle:[String,Array,Object],cardClass:[String,Array,Object],hideBottom:Boolean,hideSelectedBanner:Boolean,hideNoData:Boolean,hidePagination:Boolean,onRowClick:Function,onRowDblclick:Function,onRowContextmenu:Function,...useDarkProps,...useFullscreenProps,...useTableColumnSelectionProps,...useTableFilterProps,...useTablePaginationProps,...useTableRowExpandProps,...useTableRowSelectionProps,...useTableSortProps},emits:["request","virtual-scroll",...useFullscreenEmits,...useTableRowExpandEmits,...useTableRowSelectionEmits],setup(e,{slots:t,emit:o}){const n=getCurrentInstance(),{proxy:{$q:a}}=n,l=useDark(e,a),{inFullscreen:i,toggleFullscreen:r}=useFullscreen(),s=computed(()=>"function"===typeof e.rowKey?e.rowKey:t=>t[e.rowKey]),u=ref(null),c=ref(null),d=computed(()=>!0!==e.grid&&!0===e.virtualScroll),p=computed(()=>" q-table__card"+(!0===l.value?" q-table__card--dark q-dark":"")+(!0===e.square?" q-table--square":"")+(!0===e.flat?" q-table--flat":"")+(!0===e.bordered?" q-table--bordered":"")),v=computed(()=>`q-table__container q-table--${e.separator}-separator column no-wrap`+(!0===e.loading?" q-table--loading":"")+(!0===e.grid?" q-table--grid":p.value)+(!0===l.value?" q-table--dark":"")+(!0===e.dense?" q-table--dense":"")+(!1===e.wrapCells?" q-table--no-wrap":"")+(!0===i.value?" fullscreen scroll":"")),m=computed(()=>v.value+(!0===e.loading?" q-table--loading":""));watch(()=>e.tableStyle+e.tableClass+e.tableHeaderStyle+e.tableHeaderClass+v.value,()=>{!0===d.value&&null!==c.value&&c.value.reset()});const{innerPagination:f,computedPagination:g,isServerSide:b,requestServerInteraction:y,setPagination:S}=useTablePaginationState(n,me),{computedFilterMethod:w}=useTableFilter(e,S),{isRowExpanded:C,setExpanded:x,updateExpanded:k}=useTableRowExpand(e,o),_=computed(()=>{let t=e.rows;if(!0===b.value||0===t.length)return t;const{sortBy:o,descending:n}=g.value;return e.filter&&(t=w.value(t,e.filter,A.value,me)),null!==I.value&&(t=V.value(e.rows===t?t.slice():t,o,n)),t}),q=computed(()=>_.value.length),T=computed(()=>{let t=_.value;if(!0===b.value)return t;const{rowsPerPage:o}=g.value;return 0!==o&&(0===H.value&&e.rows!==t?t.length>j.value&&(t=t.slice(0,j.value)):t=t.slice(H.value,j.value)),t}),{hasSelectionMode:P,singleSelection:$,multipleSelection:M,allRowsSelected:B,someRowsSelected:Q,rowsSelectedNumber:E,isRowSelected:O,clearSelection:R,updateSelection:L}=useTableRowSelection(e,o,T,s),{colList:z,computedCols:A,computedColsMap:F,computedColspan:D}=useTableColumnSelection(e,g,P),{columnToSort:I,computedSortMethod:V,sort:N}=useTableSort(e,g,z,S),{firstRowIndex:H,lastRowIndex:j,isFirstPage:U,isLastPage:K,pagesNumber:W,computedRowsPerPageOptions:Y,computedRowsNumber:G,firstPage:X,prevPage:Z,nextPage:J,lastPage:ee}=useTablePagination(n,f,g,b,S,q),te=computed(()=>0===T.value.length),oe=computed(()=>{const t={};return commonVirtPropsList.forEach(o=>{t[o]=e[o]}),void 0===t.virtualScrollItemSize&&(t.virtualScrollItemSize=!0===e.dense?28:48),t});function ne(){!0===d.value&&c.value.reset()}function ae(){if(!0===e.grid)return Te();const o=!0!==e.hideHeader?be:null;if(!0===d.value){const n=t["top-row"],a=t["bottom-row"],l={default:e=>se(e.item,t.body,e.index)};if(void 0!==n){const e=h("tbody",n({cols:A.value}));l.before=null===o?()=>e:()=>[o()].concat(e)}else null!==o&&(l.before=o);return void 0!==a&&(l.after=(()=>h("tbody",a({cols:A.value})))),h(QVirtualScroll,{ref:c,class:e.tableClass,style:e.tableStyle,...oe.value,items:T.value,type:"__qtable",tableColspan:D.value,onVirtualScroll:ie},l)}const n=[ue()];return null!==o&&n.unshift(o()),getTableMiddle({class:["q-table__middle scroll",e.tableClass],style:e.tableStyle},n)}function le(e,t){if(null!==c.value)return void c.value.scrollTo(e,t);e=parseInt(e,10);const n=u.value.querySelector(`tbody tr:nth-of-type(${e+1})`);if(null!==n){const t=u.value.querySelector(".q-table__middle.scroll"),{offsetTop:a}=n,l=a<t.scrollTop?"decrease":"increase";t.scrollTop=a,o("virtual-scroll",{index:e,from:0,to:f.value.rowsPerPage-1,direction:l})}}function ie(e){o("virtual-scroll",e)}function re(){return[h(QLinearProgress,{class:"q-table__linear-progress",color:e.color,dark:l.value,indeterminate:!0,trackColor:"transparent"})]}function se(n,a,i){const r=s.value(n),u=O(r);if(void 0!==a)return a(ce({key:r,row:n,pageIndex:i,__trClass:u?"selected":""}));const c=t["body-cell"],d=A.value.map(e=>{const o=t[`body-cell-${e.name}`],a=void 0!==o?o:c;return void 0!==a?a(de({key:r,row:n,pageIndex:i,col:e})):h("td",{class:e.__tdClass(n),style:e.__tdStyle(n)},me(e,n))});if(!0===P.value){const o=t["body-selection"],a=void 0!==o?o(pe({key:r,row:n,pageIndex:i})):[h(QCheckbox,{modelValue:u,color:e.color,dark:l.value,dense:e.dense,"onUpdate:modelValue":(e,t)=>{L([r],[n],e,t)}})];d.unshift(h("td",{class:"q-table--col-auto-width"},a))}const p={key:r,class:{selected:u}};return void 0!==e.onRowClick&&(p.class["cursor-pointer"]=!0,p.onClick=(e=>{o("RowClick",e,n,i)})),void 0!==e.onRowDblclick&&(p.class["cursor-pointer"]=!0,p.onDblclick=(e=>{o("RowDblclick",e,n,i)})),void 0!==e.onRowContextmenu&&(p.class["cursor-pointer"]=!0,p.onContextmenu=(e=>{o("RowContextmenu",e,n,i)})),h("tr",p,d)}function ue(){const e=t.body,o=t["top-row"],n=t["bottom-row"];let a=T.value.map((t,o)=>se(t,e,o));return void 0!==o&&(a=o({cols:A.value}).concat(a)),void 0!==n&&(a=a.concat(n({cols:A.value}))),h("tbody",a)}function ce(e){return ve(e),e.cols=e.cols.map(t=>{const o={...t};return injectProp(o,"value",()=>me(t,e.row)),o}),e}function de(e){return ve(e),injectProp(e,"value",()=>me(e.col,e.row)),e}function pe(e){return ve(e),e}function ve(t){Object.assign(t,{cols:A.value,colsMap:F.value,sort:N,rowIndex:H.value+t.pageIndex,color:e.color,dark:l.value,dense:e.dense}),!0===P.value&&injectProp(t,"selected",()=>O(t.key),(e,o)=>{L([t.key],[t.row],e,o)}),injectProp(t,"expand",()=>C(t.key),e=>{k(t.key,e)})}function me(e,t){const o="function"===typeof e.field?e.field(t):t[e.field];return void 0!==e.format?e.format(o,t):o}const fe=computed(()=>({pagination:g.value,pagesNumber:W.value,isFirstPage:U.value,isLastPage:K.value,firstPage:X,prevPage:Z,nextPage:J,lastPage:ee,inFullscreen:i.value,toggleFullscreen:r}));function he(){const o=t.top,n=t["top-left"],a=t["top-right"],l=t["top-selection"],i=!0===P.value&&void 0!==l&&E.value>0,r="q-table__top relative-position row items-center";if(void 0!==o)return h("div",{class:r},[o(fe.value)]);let s;return!0===i?s=l(fe.value).slice():(s=[],void 0!==n?s.push(h("div",{class:"q-table-control"},[n(fe.value)])):e.title&&s.push(h("div",{class:"q-table__control"},[h("div",{class:["q-table__title",e.titleClass]},e.title)]))),void 0!==a&&(s.push(h("div",{class:"q-table__separator col"})),s.push(h("div",{class:"q-table__control"},[a(fe.value)]))),0!==s.length?h("div",{class:r},s):void 0}const ge=computed(()=>!0===Q.value?null:B.value);function be(){const o=ye();return!0===e.loading&&void 0===t.loading&&o.push(h("tr",{class:"q-table__progress"},[h("th",{class:"relative-position",colspan:D.value},re())])),h("thead",o)}function ye(){const o=t.header,n=t["header-cell"];if(void 0!==o)return o(Se({header:!0})).slice();const a=A.value.map(e=>{const o=t[`header-cell-${e.name}`],a=void 0!==o?o:n,l=Se({col:e});return void 0!==a?a(l):h(QTh,{key:e.name,props:l},()=>e.label)});if(!0===$.value&&!0!==e.grid)a.unshift(h("th",{class:"q-table--col-auto-width"}," "));else if(!0===M.value){const o=t["header-selection"],n=void 0!==o?o(Se({})):[h(QCheckbox,{color:e.color,modelValue:ge.value,dark:l.value,dense:e.dense,"onUpdate:modelValue":we})];a.unshift(h("th",{class:"q-table--col-auto-width"},n))}return[h("tr",{class:e.tableHeaderClass,style:e.tableHeaderStyle},a)]}function Se(t){return Object.assign(t,{cols:A.value,sort:N,colsMap:F.value,color:e.color,dark:l.value,dense:e.dense}),!0===M.value&&injectProp(t,"selected",()=>ge.value,we),t}function we(e){!0===Q.value&&(e=!1),L(T.value.map(s.value),T.value,e)}const Ce=computed(()=>{const t=[e.iconFirstPage||a.iconSet.table.firstPage,e.iconPrevPage||a.iconSet.table.prevPage,e.iconNextPage||a.iconSet.table.nextPage,e.iconLastPage||a.iconSet.table.lastPage];return!0===a.lang.rtl?t.reverse():t});function xe(){if(!0===e.hideBottom)return;if(!0===te.value){if(!0===e.hideNoData)return;const o=!0===e.loading?e.loadingLabel||a.lang.table.loading:e.filter?e.noResultsLabel||a.lang.table.noResults:e.noDataLabel||a.lang.table.noData,n=t["no-data"],l=void 0!==n?[n({message:o,icon:a.iconSet.table.warning,filter:e.filter})]:[h(QIcon,{class:"q-table__bottom-nodata-icon",name:a.iconSet.table.warning}),o];return h("div",{class:bottomClass+" q-table__bottom--nodata"},l)}const o=t.bottom;if(void 0!==o)return h("div",{class:bottomClass},[o(fe.value)]);const n=!0!==e.hideSelectedBanner&&!0===P.value&&E.value>0?[h("div",{class:"q-table__control"},[h("div",[(e.selectedRowsLabel||a.lang.table.selectedRecords)(E.value)])])]:[];return!0!==e.hidePagination?h("div",{class:bottomClass+" justify-end"},_e(n)):n.length>0?h("div",{class:bottomClass},n):void 0}function ke(e){S({page:1,rowsPerPage:e.value})}function _e(o){let n;const{rowsPerPage:i}=g.value,r=e.paginationLabel||a.lang.table.pagination,s=t.pagination,u=e.rowsPerPageOptions.length>1;if(o.push(h("div",{class:"q-table__separator col"})),!0===u&&o.push(h("div",{class:"q-table__control"},[h("span",{class:"q-table__bottom-item"},[e.rowsPerPageLabel||a.lang.table.recordsPerPage]),h(QSelect,{class:"q-table__select inline q-table__bottom-item",color:e.color,modelValue:i,options:Y.value,displayValue:0===i?a.lang.table.allRows:i,dark:l.value,borderless:!0,dense:!0,optionsDense:!0,optionsCover:!0,"onUpdate:modelValue":ke})])),void 0!==s)n=s(fe.value);else if(n=[h("span",0!==i?{class:"q-table__bottom-item"}:{},[i?r(H.value+1,Math.min(j.value,G.value),G.value):r(1,q.value,G.value)])],0!==i&&W.value>1){const t={color:e.color,round:!0,dense:!0,flat:!0};!0===e.dense&&(t.size="sm"),W.value>2&&n.push(h(QBtn,{key:"pgFirst",...t,icon:Ce.value[0],disable:U.value,onClick:X})),n.push(h(QBtn,{key:"pgPrev",...t,icon:Ce.value[1],disable:U.value,onClick:Z}),h(QBtn,{key:"pgNext",...t,icon:Ce.value[2],disable:K.value,onClick:J})),W.value>2&&n.push(h(QBtn,{key:"pgLast",...t,icon:Ce.value[3],disable:K.value,onClick:ee}))}return o.push(h("div",{class:"q-table__control"},n)),o}function qe(){const o=!0===e.gridHeader?[h("table",{class:"q-table"},[be()])]:!0===e.loading&&void 0===t.loading?re():void 0;return h("div",{class:"q-table__middle"},o)}function Te(){const n=void 0!==t.item?t.item:n=>{const a=n.cols.map(e=>h("div",{class:"q-table__grid-item-row"},[h("div",{class:"q-table__grid-item-title"},[e.label]),h("div",{class:"q-table__grid-item-value"},[e.value])]));if(!0===P.value){const o=t["body-selection"],i=void 0!==o?o(n):[h(QCheckbox,{modelValue:n.selected,color:e.color,dark:l.value,dense:e.dense,"onUpdate:modelValue":(e,t)=>{L([n.key],[n.row],e,t)}})];a.unshift(h("div",{class:"q-table__grid-item-row"},i),h(QSeparator,{dark:l.value}))}const i={class:["q-table__grid-item-card"+p.value,e.cardClass],style:e.cardStyle};return void 0===e.onRowClick&&void 0===e.onRowDblclick||(i.class[0]+=" cursor-pointer",void 0!==e.onRowClick&&(i.onClick=(e=>{o("RowClick",e,n.row,n.pageIndex)})),void 0!==e.onRowDblclick&&(i.onDblclick=(e=>{o("RowDblclick",e,n.row,n.pageIndex)}))),h("div",{class:"q-table__grid-item col-xs-12 col-sm-6 col-md-4 col-lg-3"+(!0===n.selected?"q-table__grid-item--selected":"")},[h("div",i,a)])};return h("div",{class:["q-table__grid-content row",e.cardContainerClass],style:e.cardContainerStyle},T.value.map((e,t)=>{return n(ce({key:s.value(e),row:e,pageIndex:t}))}))}return Object.assign(n.proxy,{requestServerInteraction:y,setPagination:S,firstPage:X,prevPage:Z,nextPage:J,lastPage:ee,isRowSelected:O,clearSelection:R,isRowExpanded:C,setExpanded:x,sort:N,resetVirtualScroll:ne,scrollTo:le,getCellValue:me}),injectMultipleProps(n.proxy,{filteredSortedRows:()=>_.value,computedRows:()=>T.value,computedRowsNumber:()=>G.value}),()=>{const o=[he()],n={ref:u,class:m.value};return!0===e.grid?o.push(qe()):Object.assign(n,{class:[n.class,e.cardClass],style:e.cardStyle}),o.push(ae(),xe()),!0===e.loading&&void 0!==t.loading&&o.push(t.loading()),h("div",n,o)}}}),QTr=createComponent({name:"QTr",props:{props:Object,noHover:Boolean},setup(e,{slots:t}){const o=computed(()=>"q-tr"+(void 0===e.props||!0===e.props.header?"":" "+e.props.__trClass)+(!0===e.noHover?" q-tr--no-hover":""));return()=>h("tr",{class:o.value},hSlot(t.default))}}),QTd=createComponent({name:"QTd",props:{props:Object,autoWidth:Boolean,noHover:Boolean},setup(e,{slots:t}){const o=getCurrentInstance(),n=computed(()=>"q-td"+(!0===e.autoWidth?" q-table--col-auto-width":"")+(!0===e.noHover?" q-td--no-hover":"")+" ");return()=>{if(void 0===e.props)return h("td",{class:n.value},hSlot(t.default));const a=o.vnode.key,l=(void 0!==e.props.colsMap?e.props.colsMap[a]:null)||e.props.col;if(void 0===l)return;const{row:i}=e.props;return h("td",{class:n.value+l.__tdClass(i),style:l.__tdStyle(i)},hSlot(t.default))}}}),QRouteTab=createComponent({name:"QRouteTab",props:{...useRouterLinkProps,...useTabProps},emits:useTabEmits,setup(e,{slots:t,emit:o}){const n=useRouterLink(),{renderTab:a,$tabs:l}=useTab(e,t,o,{exact:computed(()=>e.exact),...n});return watch(()=>e.name+e.exact+(n.linkRoute.value||{}).href,()=>{l.verifyRouteModel()}),()=>a(n.linkTag.value,n.linkProps.value)}});function getViewByModel(e,t){if(null!==e.hour){if(null===e.minute)return"minute";if(!0===t&&null===e.second)return"second"}return"hour"}function getCurrentTime(){const e=new Date;return{hour:e.getHours(),minute:e.getMinutes(),second:e.getSeconds(),millisecond:e.getMilliseconds()}}var QTime=createComponent({name:"QTime",props:{...useDarkProps,...useFormProps,...useDatetimeProps,mask:{default:null},format24h:{type:Boolean,default:null},defaultDate:{type:String,validator:e=>/^-?[\d]+\/[0-1]\d\/[0-3]\d$/.test(e)},options:Function,hourOptions:Array,minuteOptions:Array,secondOptions:Array,withSeconds:Boolean,nowBtn:Boolean},emits:useDatetimeEmits,setup(e,{slots:t,emit:o}){const{proxy:{$q:n}}=getCurrentInstance(),a=useDark(e,n),{tabindex:l,headerClass:i,getLocale:r,getCurrentDate:s}=useDatetime(e,n),u=useFormAttrs(e),c=useFormInject(u);let d,p;const v=ref(null),m=computed(()=>I()),f=computed(()=>r()),g=__splitDate(e.modelValue,I(),r(),e.calendar,V()),b=ref(getViewByModel(g)),y=ref(g),S=ref(null===g.hour||g.hour<12),w=computed(()=>`q-time q-time--${!0===e.landscape?"landscape":"portrait"}`+(!0===a.value?" q-time--dark q-dark":"")+(!0===e.disable?" disabled":!0===e.readonly?" q-time--readonly":"")+(!0===e.bordered?" q-time--bordered":"")+(!0===e.square?" q-time--square no-border-radius":"")+(!0===e.flat?" q-time--flat no-shadow":"")),C=computed(()=>{const e=y.value;return{hour:null===e.hour?"--":!0===k.value?pad(e.hour):String(!0===S.value?0===e.hour?12:e.hour:e.hour>12?e.hour-12:e.hour),minute:null===e.minute?"--":pad(e.minute),second:null===e.second?"--":pad(e.second)}}),x=computed(()=>V()),k=computed(()=>null!==e.format24h?e.format24h:n.lang.date.format24h),_=computed(()=>{const e="hour"===b.value,t=!0===e?12:60,o=y.value[b.value],n=Math.round(o*(360/t))-180;let a=`rotate(${n}deg) translateX(-50%)`;return!0===e&&!0===k.value&&y.value.hour>=12&&(a+=" scale(.7)"),{transform:a}}),q=computed(()=>null!==y.value.hour),T=computed(()=>!0===q.value&&null!==y.value.minute),P=computed(()=>void 0!==e.hourOptions?t=>e.hourOptions.includes(t):void 0!==e.options?t=>e.options(t,null,null):null),$=computed(()=>void 0!==e.minuteOptions?t=>e.minuteOptions.includes(t):void 0!==e.options?t=>e.options(y.value.hour,t,null):null),M=computed(()=>void 0!==e.secondOptions?t=>e.secondOptions.includes(t):void 0!==e.options?t=>e.options(y.value.hour,y.value.minute,t):null),B=computed(()=>{if(null===P.value)return null;const e=A(0,11,P.value),t=A(12,11,P.value);return{am:e,pm:t,values:e.values.concat(t.values)}}),Q=computed(()=>null!==$.value?A(0,59,$.value):null),E=computed(()=>null!==M.value?A(0,59,M.value):null),O=computed(()=>{switch(b.value){case"hour":return B.value;case"minute":return Q.value;case"second":return E.value}}),R=computed(()=>{let e,t,o=0,n=1;const a=null!==O.value?O.value.values:void 0;"hour"===b.value?!0===k.value?(e=0,t=23):(e=0,t=11,!1===S.value&&(o=12)):(e=0,t=55,n=5);const l=[];for(let i=e,r=e;i<=t;i+=n,r++){const e=i+o,t=void 0!==a&&!1===a.includes(e),n="hour"===b.value&&0===i?!0===k.value?"00":"12":i;l.push({val:e,index:r,disable:t,label:n})}return l}),L=computed(()=>{return[[TouchPan,j,void 0,{stop:!0,prevent:!0,mouse:!0}]]});function z(){const e={...s(),...getCurrentTime()};ue(e),Object.assign(y.value,e),b.value="hour"}function A(e,t,o){const n=Array.apply(null,{length:t+1}).map((t,n)=>{const a=n+e;return{index:a,val:!0===o(a)}}).filter(e=>!0===e.val).map(e=>e.index);return{min:n[0],max:n[n.length-1],values:n,threshold:t+1}}function F(e,t,o){const n=Math.abs(e-t);return Math.min(n,o-n)}function D(e,{min:t,max:o,values:n,threshold:a}){if(e===t)return t;if(e<t||e>o)return F(e,t,a)<=F(e,o,a)?t:o;const l=n.findIndex(t=>e<=t),i=n[l-1],r=n[l];return e-i<=r-e?i:r}function I(){return"persian"!==e.calendar&&null!==e.mask?e.mask:`HH:mm${!0===e.withSeconds?":ss":""}`}function V(){if("string"!==typeof e.defaultDate){const e=s(!0);return e.dateHash=getDayHash(e),e}return __splitDate(e.defaultDate,"YYYY/MM/DD",void 0,e.calendar)}function N(){return!0===ce.isDeactivated||!0===ce.isUnmounted||null!==O.value&&(0===O.value.values.length||"hour"===b.value&&!0!==k.value&&0===B.value[!0===S.value?"am":"pm"].values.length)}function H(){const e=v.value,{top:t,left:o,width:n}=e.getBoundingClientRect(),a=n/2;return{top:t+a,left:o+a,dist:.7*a}}function j(e){if(!0!==N()){if(!0===e.isFirst)return d=H(),void(p=K(e.evt,d));p=K(e.evt,d,p),!0===e.isFinal&&(d=!1,p=null,U())}}function U(){"hour"===b.value?b.value="minute":e.withSeconds&&"minute"===b.value&&(b.value="second")}function K(e,t,o){const n=position(e),a=Math.abs(n.top-t.top),l=Math.sqrt(Math.pow(Math.abs(n.top-t.top),2)+Math.pow(Math.abs(n.left-t.left),2));let i,r=Math.asin(a/l)*(180/Math.PI);if(r=n.top<t.top?t.left<n.left?90-r:270+r:t.left<n.left?r+90:270-r,"hour"===b.value){if(i=r/30,null!==B.value){const e=!0!==k.value?!0===S.value:B.value.am.values.length>0&&B.value.pm.values.length>0?l>=t.dist:B.value.am.values.length>0;i=D(i+(!0===e?0:12),B.value[!0===e?"am":"pm"])}else i=Math.round(i),!0===k.value?l<t.dist?i<12&&(i+=12):12===i&&(i=0):!0===S.value&&12===i?i=0:!1===S.value&&12!==i&&(i+=12);!0===k.value&&(S.value=i<12)}else i=Math.round(r/6)%60,"minute"===b.value&&null!==Q.value?i=D(i,Q.value):"second"===b.value&&null!==E.value&&(i=D(i,E.value));return o!==i&&le[b.value](i),i}watch(()=>e.modelValue,t=>{const o=__splitDate(t,m.value,f.value,e.calendar,x.value);o.dateHash===y.value.dateHash&&o.timeHash===y.value.timeHash||(y.value=o,null===o.hour?b.value="hour":S.value=o.hour<12)}),watch([m,f],()=>{nextTick(()=>{ue()})});const W={hour(){b.value="hour"},minute(){b.value="minute"},second(){b.value="second"}};function Y(e){13===e.keyCode&&ie()}function G(e){13===e.keyCode&&re()}function X(e){!0!==N()&&(!0!==n.platform.is.desktop&&K(e,H()),U())}function Z(e){!0!==N()&&K(e,H())}function J(e){if(13===e.keyCode)b.value="hour";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==B.value){const e=!0===k.value?B.value.values:B.value[!0===S.value?"am":"pm"].values;if(0===e.length)return;if(null===y.value.hour)oe(e[0]);else{const o=(e.length+e.indexOf(y.value.hour)+t)%e.length;oe(e[o])}}else{const e=!0===k.value?24:12,o=!0!==k.value&&!1===S.value?12:0,n=null===y.value.hour?-t:y.value.hour;oe(o+(24+n+t)%e)}}}function ee(e){if(13===e.keyCode)b.value="minute";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==Q.value){const e=Q.value.values;if(0===e.length)return;if(null===y.value.minute)ne(e[0]);else{const o=(e.length+e.indexOf(y.value.minute)+t)%e.length;ne(e[o])}}else{const e=null===y.value.minute?-t:y.value.minute;ne((60+e+t)%60)}}}function te(e){if(13===e.keyCode)b.value="second";else if([37,39].includes(e.keyCode)){const t=37===e.keyCode?-1:1;if(null!==E.value){const e=E.value.values;if(0===e.length)return;if(null===y.value.seconds)ae(e[0]);else{const o=(e.length+e.indexOf(y.value.second)+t)%e.length;ae(e[o])}}else{const e=null===y.value.second?-t:y.value.second;ae((60+e+t)%60)}}}function oe(e){y.value.hour!==e&&(y.value.hour=e,se())}function ne(e){y.value.minute!==e&&(y.value.minute=e,se())}function ae(e){y.value.second!==e&&(y.value.second=e,se())}const le={hour:oe,minute:ne,second:ae};function ie(){!1===S.value&&(S.value=!0,null!==y.value.hour&&(y.value.hour-=12,se()))}function re(){!0===S.value&&(S.value=!1,null!==y.value.hour&&(y.value.hour+=12,se()))}function se(){return null!==P.value&&!0!==P.value(y.value.hour)?(y.value=__splitDate(),void(b.value="hour")):null!==$.value&&!0!==$.value(y.value.minute)?(y.value.minute=null,y.value.second=null,void(b.value="minute")):!0===e.withSeconds&&null!==M.value&&!0!==M.value(y.value.second)?(y.value.second=null,void(b.value="second")):void(null===y.value.hour||null===y.value.minute||!0===e.withSeconds&&null===y.value.second||ue())}function ue(t){const n=Object.assign({...y.value},t),a="persian"===e.calendar?pad(n.hour)+":"+pad(n.minute)+(!0===e.withSeconds?":"+pad(n.second):""):formatDate(new Date(n.year,null===n.month?null:n.month-1,n.day,n.hour,n.minute,n.second,n.millisecond),m.value,f.value,n.year,n.timezoneOffset);n.changed=a!==e.modelValue,o("update:modelValue",a,n)}const ce=getCurrentInstance();function de(){const t=[h("div",{class:"q-time__link "+("hour"===b.value?"q-time__link--active":"cursor-pointer"),tabindex:l.value,onClick:W.hour,onKeyup:J},C.value.hour),h("div",":"),h("div",!0===q.value?{class:"q-time__link "+("minute"===b.value?"q-time__link--active":"cursor-pointer"),tabindex:l.value,onKeyup:ee,onClick:W.minute}:{class:"q-time__link"},C.value.minute)];!0===e.withSeconds&&t.push(h("div",":"),h("div",!0===T.value?{class:"q-time__link "+("second"===b.value?"q-time__link--active":"cursor-pointer"),tabindex:l.value,onKeyup:te,onClick:W.second}:{class:"q-time__link"},C.value.second));const o=[h("div",{class:"q-time__header-label row items-center no-wrap",dir:"ltr"},t)];return!1===k.value&&o.push(h("div",{class:"q-time__header-ampm column items-between no-wrap"},[h("div",{class:"q-time__link "+(!0===S.value?"q-time__link--active":"cursor-pointer"),tabindex:l.value,onClick:ie,onKeyup:Y},"AM"),h("div",{class:"q-time__link "+(!0!==S.value?"q-time__link--active":"cursor-pointer"),tabindex:l.value,onClick:re,onKeyup:G},"PM")])),h("div",{class:"q-time__header flex flex-center no-wrap "+i.value},o)}function pe(){const t=y.value[b.value];return h("div",{class:"q-time__content col relative-position"},[h(Transition,{name:"q-transition--scale"},()=>h("div",{key:"clock"+b.value,class:"q-time__container-parent absolute-full"},[h("div",{ref:v,class:"q-time__container-child fit overflow-hidden"},[withDirectives(h("div",{class:"q-time__clock cursor-pointer non-selectable",onClick:X,onMousedown:Z},[h("div",{class:"q-time__clock-circle fit"},[h("div",{class:"q-time__clock-pointer"+(null===y.value[b.value]?" hidden":void 0!==e.color?` text-${e.color}`:""),style:_.value}),R.value.map(e=>h("div",{class:`q-time__clock-position row flex-center q-time__clock-pos-${e.index}`+(e.val===t?" q-time__clock-position--active "+i.value:!0===e.disable?" q-time__clock-position--disable":"")},[h("span",e.label)]))])]),L.value)])])),!0===e.nowBtn?h(QBtn,{class:"q-time__now-button absolute",icon:n.iconSet.datetime.now,unelevated:!0,size:"sm",round:!0,color:e.color,textColor:e.textColor,tabindex:l.value,onClick:z}):null])}return Object.assign(ce.proxy,{setNow:z}),()=>{const o=[pe()],n=hSlot(t.default);return void 0!==n&&o.push(h("div",{class:"q-time__actions"},n)),void 0!==e.name&&!0!==e.disable&&c(o,"push"),h("div",{class:w.value,tabindex:-1},[de(),h("div",{class:"q-time__main col overflow-auto"},o)])}}}),QTimeline=createComponent({name:"QTimeline",props:{...useDarkProps,color:{type:String,default:"primary"},side:{type:String,default:"right",validator:e=>["left","right"].includes(e)},layout:{type:String,default:"dense",validator:e=>["dense","comfortable","loose"].includes(e)}},setup(e,{slots:t}){const o=getCurrentInstance(),n=useDark(e,o.proxy.$q);provide(timelineKey,e);const a=computed(()=>`q-timeline q-timeline--${e.layout} q-timeline--${e.layout}--${e.side}`+(!0===n.value?" q-timeline--dark":""));return()=>h("ul",{class:a.value},hSlot(t.default))}}),QTimelineEntry=createComponent({name:"QTimelineEntry",props:{heading:Boolean,tag:{type:String,default:"h3"},side:{type:String,default:"right",validator:e=>["left","right"].includes(e)},icon:String,avatar:String,color:String,title:String,subtitle:String,body:String},setup(e,{slots:t}){const o=inject(timelineKey,()=>{console.error("QTimelineEntry needs to be child of QTimeline")}),n=computed(()=>`q-timeline__entry q-timeline__entry--${e.side}`+(void 0!==e.icon||void 0!==e.avatar?" q-timeline__entry--icon":"")),a=computed(()=>`q-timeline__dot text-${e.color||o.color}`),l=computed(()=>"comfortable"===o.layout&&"left"===o.side);return()=>{const o=hUniqueSlot(t.default,[]);if(void 0!==e.body&&o.unshift(e.body),!0===e.heading){const t=[h("div"),h("div"),h(e.tag,{class:"q-timeline__heading-title"},o)];return h("div",{class:"q-timeline__heading"},!0===l.value?t.reverse():t)}let i;void 0!==e.icon?i=[h(QIcon,{class:"row items-center justify-center",name:e.icon})]:void 0!==e.avatar&&(i=[h("img",{class:"q-timeline__dot-img",src:e.avatar})]);const r=[h("div",{class:"q-timeline__subtitle"},[h("span",{},hSlot(t.subtitle,[e.subtitle]))]),h("div",{class:a.value},i),h("div",{class:"q-timeline__content"},[h("h6",{class:"q-timeline__title"},hSlot(t.title,[e.title]))].concat(o))];return h("li",{class:n.value},!0===l.value?r.reverse():r)}}}),QToolbar=createComponent({name:"QToolbar",props:{inset:Boolean},setup(e,{slots:t}){const o=computed(()=>"q-toolbar row no-wrap items-center"+(!0===e.inset?" q-toolbar--inset":""));return()=>h("div",{class:o.value},hSlot(t.default))}}),QToolbarTitle=createComponent({name:"QToolbarTitle",props:{shrink:Boolean},setup(e,{slots:t}){const o=computed(()=>"q-toolbar__title ellipsis"+(!0===e.shrink?" col-shrink":""));return()=>h("div",{class:o.value},hSlot(t.default))}});const tickStrategyOptions=["none","strict","leaf","leaf-filtered"];var QTree=createComponent({name:"QTree",props:{...useDarkProps,nodes:{type:Array,required:!0},nodeKey:{type:String,required:!0},labelKey:{type:String,default:"label"},childrenKey:{type:String,default:"children"},dense:Boolean,color:String,controlColor:String,textColor:String,selectedColor:String,icon:String,tickStrategy:{type:String,default:"none",validator:e=>tickStrategyOptions.includes(e)},ticked:Array,expanded:Array,selected:{},noSelectionUnset:Boolean,defaultExpandAll:Boolean,accordion:Boolean,filter:String,filterMethod:Function,duration:Number,noConnectors:Boolean,noNodesLabel:String,noResultsLabel:String},emits:["update:expanded","update:ticked","update:selected","lazy-load","after-show","after-hide"],setup(e,{slots:t,emit:o}){const{proxy:n}=getCurrentInstance(),{$q:a}=n,l=useDark(e,a),i=ref({}),r=ref(e.ticked||[]),s=ref(e.expanded||[]);let u={};onBeforeUpdate(()=>{u={}});const c=computed(()=>`q-tree q-tree--${!0===e.dense?"dense":"standard"}`+(!0===e.noConnectors?" q-tree--no-connectors":"")+(!0===l.value?" q-tree--dark":"")+(void 0!==e.color?` text-${e.color}`:"")),d=computed(()=>void 0!==e.selected),p=computed(()=>e.icon||a.iconSet.tree.icon),v=computed(()=>e.controlColor||e.color),m=computed(()=>void 0!==e.textColor?` text-${e.textColor}`:""),f=computed(()=>{const t=e.selectedColor||e.color;return t?` text-${t}`:""}),g=computed(()=>void 0!==e.filterMethod?e.filterMethod:(t,o)=>{const n=o.toLowerCase();return t[e.labelKey]&&t[e.labelKey].toLowerCase().indexOf(n)>-1}),b=computed(()=>{const t={},o=(n,a)=>{const l=n.tickStrategy||(a?a.tickStrategy:e.tickStrategy),u=n[e.nodeKey],c=n[e.childrenKey]&&n[e.childrenKey].length>0,p=!0!==c,v=!0!==n.disabled&&!0===d.value&&!1!==n.selectable,m=!0!==n.disabled&&!1!==n.expandable,f="none"!==l,h="strict"===l,b="leaf-filtered"===l,y="leaf"===l||"leaf-filtered"===l;let S=!0!==n.disabled&&!1!==n.tickable;!0===y&&!0===S&&a&&!0!==a.tickable&&(S=!1);let w=n.lazy;!0===w&&void 0!==i.value[u]&&!0===Array.isArray(n[e.childrenKey])&&(w=i.value[u]);const C={key:u,parent:a,isParent:c,isLeaf:p,lazy:w,disabled:n.disabled,link:!0!==n.disabled&&(!0===v||!0===m&&(!0===c||!0===w)),children:[],matchesFilter:!e.filter||g.value(n,e.filter),selected:u===e.selected&&!0===v,selectable:v,expanded:!0===c&&s.value.includes(u),expandable:m,noTick:!0===n.noTick||!0!==h&&w&&"loaded"!==w,tickable:S,tickStrategy:l,hasTicking:f,strictTicking:h,leafFilteredTicking:b,leafTicking:y,ticked:!0===h?r.value.includes(u):!0===p&&r.value.includes(u)};if(t[u]=C,!0===c&&(C.children=n[e.childrenKey].map(e=>o(e,C)),e.filter&&(!0!==C.matchesFilter?C.matchesFilter=C.children.some(e=>e.matchesFilter):!0!==C.noTick&&!0!==C.disabled&&!0===C.tickable&&!0===b&&!0===C.children.every(e=>!0!==e.matchesFilter||!0===e.noTick||!0!==e.tickable)&&(C.tickable=!1)),!0===C.matchesFilter&&(!0!==C.noTick&&!0!==h&&!0===C.children.every(e=>e.noTick)&&(C.noTick=!0),y))){if(C.ticked=!1,C.indeterminate=C.children.some(e=>!0===e.indeterminate),C.tickable=!0===C.tickable&&C.children.some(e=>e.tickable),!0!==C.indeterminate){const e=C.children.reduce((e,t)=>!0===t.ticked?e+1:e,0);e===C.children.length?C.ticked=!0:e>0&&(C.indeterminate=!0)}!0===C.indeterminate&&(C.indeterminateNextState=C.children.every(e=>!0!==e.tickable||!0!==e.ticked))}return C};return e.nodes.forEach(e=>o(e,null)),t});function y(t){const o=[].reduce,n=(a,l)=>{return a||!l?a:!0===Array.isArray(l)?o.call(Object(l),n,a):l[e.nodeKey]===t?l:l[e.childrenKey]?n(null,l[e.childrenKey]):void 0};return n(null,e.nodes)}function S(){return r.value.map(e=>y(e))}function w(){return s.value.map(e=>y(e))}function C(e){return!(!e||!b.value[e])&&b.value[e].expanded}function x(){void 0!==e.expanded?o("update:expanded",[]):s.value=[]}function k(){const t=s.value,n=o=>{o[e.childrenKey]&&o[e.childrenKey].length>0&&!1!==o.expandable&&!0!==o.disabled&&(t.push(o[e.nodeKey]),o[e.childrenKey].forEach(n))};e.nodes.forEach(n),void 0!==e.expanded?o("update:expanded",t):s.value=t}function _(t,n,a=y(t),l=b.value[t]){if(l.lazy&&"loaded"!==l.lazy){if("loading"===l.lazy)return;i.value[t]="loading",!0!==Array.isArray(a[e.childrenKey])&&(a[e.childrenKey]=[]),o("lazy-load",{node:a,key:t,done:o=>{i.value[t]="loaded",a[e.childrenKey]=!0===Array.isArray(o)?o:[],nextTick(()=>{const e=b.value[t];e&&!0===e.isParent&&q(t,!0)})},fail:()=>{delete i.value[t],0===a[e.childrenKey].length&&delete a[e.childrenKey]}})}else!0===l.isParent&&!0===l.expandable&&q(t,n)}function q(t,n){let a=s.value;const l=void 0!==e.expanded;if(!0===l&&(a=a.slice()),n){if(e.accordion&&b.value[t]){const o=[];b.value[t].parent?b.value[t].parent.children.forEach(e=>{e.key!==t&&!0===e.expandable&&o.push(e.key)}):e.nodes.forEach(n=>{const a=n[e.nodeKey];a!==t&&o.push(a)}),o.length>0&&(a=a.filter(e=>!1===o.includes(e)))}a=a.concat([t]).filter((e,t,o)=>o.indexOf(e)===t)}else a=a.filter(e=>e!==t);!0===l?o("update:expanded",a):s.value=a}function T(e){return!(!e||!b.value[e])&&b.value[e].ticked}function P(t,n){let a=r.value;const l=void 0!==e.ticked;!0===l&&(a=a.slice()),a=n?a.concat(t).filter((e,t,o)=>o.indexOf(e)===t):a.filter(e=>!1===t.includes(e)),!0===l&&o("update:ticked",a)}function $(t,o,a){const i={tree:n,node:t,key:a,color:e.color,dark:l.value};return injectProp(i,"expanded",()=>{return o.expanded},e=>{e!==o.expanded&&_(a,e)}),injectProp(i,"ticked",()=>{return o.ticked},e=>{e!==o.ticked&&P([a],e)}),i}function M(t){return(e.filter?t.filter(t=>b.value[t[e.nodeKey]].matchesFilter):t).map(e=>O(e))}function B(e){if(void 0!==e.icon)return h(QIcon,{class:"q-tree__icon q-mr-sm",name:e.icon,color:e.iconColor});const t=e.img||e.avatar;return t?h("img",{class:`q-tree__${e.img?"img":"avatar"} q-mr-sm`,src:t}):void 0}function Q(){o("after-show")}function E(){o("after-hide")}function O(o){const n=o[e.nodeKey],a=b.value[n],i=o.header&&t[`header-${o.header}`]||t["default-header"],r=!0===a.isParent?M(o[e.childrenKey]):[],s=r.length>0||a.lazy&&"loaded"!==a.lazy;let c=o.body&&t[`body-${o.body}`]||t["default-body"];const d=void 0!==i||void 0!==c?$(o,a,n):null;return void 0!==c&&(c=h("div",{class:"q-tree__node-body relative-position"},[h("div",{class:m.value},[c(d)])])),h("div",{key:n,class:"q-tree__node relative-position"+` q-tree__node--${!0===s?"parent":"child"}`},[h("div",{class:"q-tree__node-header relative-position row no-wrap items-center"+(!0===a.link?" q-tree__node--link q-hoverable q-focusable":"")+(!0===a.selected?" q-tree__node--selected":"")+(!0===a.disabled?" q-tree__node--disabled":""),tabindex:!0===a.link?0:-1,onClick:e=>{L(o,a,e)},onKeypress(e){!0!==shouldIgnoreKey(e)&&(13===e.keyCode?L(o,a,e,!0):32===e.keyCode&&z(o,a,e,!0))}},[h("div",{class:"q-focus-helper",tabindex:-1,ref:e=>{u[a.key]=e}}),"loading"===a.lazy?h(QSpinner,{class:"q-tree__spinner",color:v.value}):!0===s?h(QIcon,{class:"q-tree__arrow"+(!0===a.expanded?" q-tree__arrow--rotate":""),name:p.value,onClick(e){z(o,a,e)}}):null,!0===a.hasTicking&&!0!==a.noTick?h(QCheckbox,{class:"q-tree__tickbox",modelValue:!0===a.indeterminate?null:a.ticked,color:v.value,dark:l.value,dense:!0,keepColor:!0,disable:!0!==a.tickable,onKeydown:stopAndPrevent,"onUpdate:modelValue":e=>{A(a,e)}}):null,h("div",{class:"q-tree__node-header-content col row no-wrap items-center"+(!0===a.selected?f.value:m.value)},[i?i(d):[B(o),h("div",o[e.labelKey])]])]),!0===s?h(QSlideTransition,{duration:e.duration,onShow:Q,onHide:E},()=>withDirectives(h("div",{class:"q-tree__node-collapsible"+m.value,key:`${n}__q`},[c,h("div",{class:"q-tree__children"+(!0===a.disabled?" q-tree__node--disabled":"")},r)]),[[vShow,a.expanded]])):c])}function R(e){const t=u[e];t&&t.focus()}function L(t,n,a,l){!0!==l&&R(n.key),d.value&&n.selectable?!1===e.noSelectionUnset?o("update:selected",n.key!==e.selected?n.key:null):n.key!==e.selected&&o("update:selected",n.key||null):z(t,n,a,l),"function"===typeof t.handler&&t.handler(t)}function z(e,t,o,n){void 0!==o&&stopAndPrevent(o),!0!==n&&R(t.key),_(t.key,!t.expanded,e,t)}function A(e,t){if(!0===e.indeterminate&&(t=e.indeterminateNextState),e.strictTicking)P([e.key],t);else if(e.leafTicking){const o=[],n=e=>{e.isParent?(!0!==t&&!0!==e.noTick&&!0===e.tickable&&o.push(e.key),!0===e.leafTicking&&e.children.forEach(n)):!0===e.noTick||!0!==e.tickable||!0===e.leafFilteredTicking&&!0!==e.matchesFilter||o.push(e.key)};n(e),P(o,t)}}return watch(()=>e.ticked,e=>{r.value=e}),watch(()=>e.expanded,e=>{s.value=e}),Object.assign(n,{getNodeByKey:y,getTickedNodes:S,getExpandedNodes:w,isExpanded:C,collapseAll:x,expandAll:k,setExpanded:_,isTicked:T,setTicked:P}),!0===e.defaultExpandAll&&k(),()=>{const t=M(e.nodes);return h("div",{class:c.value},0===t.length?e.filter?e.noResultsLabel||a.lang.tree.noResults:e.noNodesLabel||a.lang.tree.noNodes:t)}}});function getFn(e){return"function"===typeof e?e:()=>e}const props$2={url:[Function,String],method:{type:[Function,String],default:"POST"},fieldName:{type:[Function,String],default:()=>{return e=>e.name}},headers:[Function,Array],formFields:[Function,Array],withCredentials:[Function,Boolean],sendRaw:[Function,Boolean],batch:[Function,Boolean],factory:Function},emits$1=["factory-failed","uploaded","failed","uploading"];function injectPlugin({props:e,emit:t,helpers:o}){const n=ref([]),a=ref([]),l=ref(0),i=computed(()=>({url:getFn(e.url),method:getFn(e.method),headers:getFn(e.headers),formFields:getFn(e.formFields),fieldName:getFn(e.fieldName),withCredentials:getFn(e.withCredentials),sendRaw:getFn(e.sendRaw),batch:getFn(e.batch)})),r=computed(()=>l.value>0),s=computed(()=>a.value.length>0);let u;function c(){n.value.forEach(e=>{e.abort()}),a.value.length>0&&(u=!0)}function d(){const e=o.queuedFiles.value.slice(0);o.queuedFiles.value=[],i.value.batch(e)?p(e):e.forEach(e=>{p([e])})}function p(n){if(l.value++,"function"!==typeof e.factory)return void v(n,{});const i=e.factory(n);if(i)if("function"===typeof i.catch&&"function"===typeof i.then){a.value.push(i);const e=e=>{!0===o.isAlive()&&(a.value=a.value.filter(e=>e!==i),0===a.value.length&&(u=!1),o.queuedFiles.value=o.queuedFiles.value.concat(n),n.forEach(e=>{o.updateFileStatus(e,"failed")}),t("factory-failed",e,n),l.value--)};i.then(t=>{!0===u?e(new Error("Aborted")):!0===o.isAlive()&&(a.value=a.value.filter(e=>e!==i),v(n,t))}).catch(e)}else v(n,i||{});else t("factory-failed",new Error("QUploader: factory() does not return properly"),n),l.value--}function v(e,a){const r=new FormData,s=new XMLHttpRequest,u=(e,t)=>{return void 0!==a[e]?getFn(a[e])(t):i.value[e](t)},c=u("url",e);if(!c)return console.error("q-uploader: invalid or no URL specified"),void l.value--;const d=u("formFields",e);void 0!==d&&d.forEach(e=>{r.append(e.name,e.value)});let p,v=0,m=0,f=0,h=0;s.upload.addEventListener("progress",t=>{if(!0===p)return;const n=Math.min(h,t.loaded);o.uploadedSize.value+=n-f,f=n;let a=f-m;for(let l=v;a>0&&l<e.length;l++){const t=e[l],n=a>t.size;if(!n)return void o.updateFileStatus(t,"uploading",a);a-=t.size,v++,m+=t.size,o.updateFileStatus(t,"uploading",t.size)}},!1),s.onreadystatechange=(()=>{s.readyState<4||(s.status&&s.status<400?(o.uploadedFiles.value=o.uploadedFiles.value.concat(e),e.forEach(e=>{o.updateFileStatus(e,"uploaded")}),t("uploaded",{files:e,xhr:s})):(p=!0,o.uploadedSize.value-=f,o.queuedFiles.value=o.queuedFiles.value.concat(e),e.forEach(e=>{o.updateFileStatus(e,"failed")}),t("failed",{files:e,xhr:s})),l.value--,n.value=n.value.filter(e=>e!==s))}),s.open(u("method",e),c),!0===u("withCredentials",e)&&(s.withCredentials=!0);const g=u("headers",e);void 0!==g&&g.forEach(e=>{s.setRequestHeader(e.name,e.value)});const b=u("sendRaw",e);e.forEach(e=>{o.updateFileStatus(e,"uploading",0),!0!==b&&r.append(u("fieldName",e),e,e.name),e.xhr=s,e.__abort=(()=>{s.abort()}),h+=e.size}),t("uploading",{files:e,xhr:s}),n.value.push(s),!0===b?s.send(new Blob(e)):s.send(r)}return{isUploading:r,isBusy:s,abort:c,upload:d}}var xhrUploaderPlugin={name:"QUploader",props:props$2,emits:emits$1,injectPlugin:injectPlugin},QUploader=createUploaderComponent(xhrUploaderPlugin),QUploaderAddTrigger=createComponent({name:"QUploaderAddTrigger",setup(){return inject(uploaderKey,()=>{console.error("QUploaderAddTrigger needs to be child of QUploader")})}}),QVideo=createComponent({name:"QVideo",props:{...useRatioProps,src:{type:String,required:!0},title:String},setup(e){const t=useRatio(e),o=computed(()=>"q-video"+(void 0!==e.ratio?" q-video--responsive":""));return()=>h("div",{class:o.value,style:t.value},[h("iframe",{src:e.src,title:e.title,frameborder:"0",allowfullscreen:!0})])}}),components=Object.freeze({__proto__:null,QAjaxBar:QAjaxBar,QAvatar:QAvatar,QBadge:QBadge,QBanner:QBanner,QBar:QBar,QBreadcrumbs:QBreadcrumbs,QBreadcrumbsEl:QBreadcrumbsEl,QBtn:QBtn,QBtnDropdown:QBtnDropdown,QBtnGroup:QBtnGroup,QBtnToggle:QBtnToggle,QCard:QCard,QCardSection:QCardSection,QCardActions:QCardActions,QCarousel:QCarousel,QCarouselSlide:QCarouselSlide,QCarouselControl:QCarouselControl,QChatMessage:QChatMessage,QCheckbox:QCheckbox,QChip:QChip,QCircularProgress:QCircularProgress,QColor:QColor,QDate:QDate,QDialog:QDialog,QDrawer:QDrawer,QEditor:QEditor,QExpansionItem:QExpansionItem,QFab:QFab,QFabAction:QFabAction,QField:QField,QFile:QFile,QFooter:QFooter,QForm:QForm,QFormChildMixin:QFormChildMixin,QHeader:QHeader,QIcon:QIcon,QImg:QImg,QInfiniteScroll:QInfiniteScroll,QInnerLoading:QInnerLoading,QInput:QInput,QIntersection:QIntersection,QList:QList,QItem:QItem,QItemSection:QItemSection,QItemLabel:QItemLabel,QKnob:QKnob,QLayout:QLayout,QMarkupTable:QMarkupTable,QMenu:QMenu,QNoSsr:QNoSsr,QOptionGroup:QOptionGroup,QPage:QPage,QPageContainer:QPageContainer,QPageScroller:QPageScroller,QPageSticky:QPageSticky,QPagination:QPagination,QParallax:QParallax,QPopupEdit:QPopupEdit,QPopupProxy:QPopupProxy,QLinearProgress:QLinearProgress,QPullToRefresh:QPullToRefresh,QRadio:QRadio,QRange:QRange,QRating:QRating,QResizeObserver:QResizeObserver,QResponsive:QResponsive,QScrollArea:QScrollArea,QScrollObserver:QScrollObserver,QSelect:QSelect,QSeparator:QSeparator,QSkeleton:QSkeleton,QSlideItem:QSlideItem,QSlideTransition:QSlideTransition,QSlider:QSlider,QSpace:QSpace,QSpinner:QSpinner,QSpinnerAudio:QSpinnerAudio,QSpinnerBall:QSpinnerBall,QSpinnerBars:QSpinnerBars,QSpinnerBox:QSpinnerBox,QSpinnerClock:QSpinnerClock,QSpinnerComment:QSpinnerComment,QSpinnerCube:QSpinnerCube,QSpinnerDots:QSpinnerDots,QSpinnerFacebook:QSpinnerFacebook,QSpinnerGears:QSpinnerGears,QSpinnerGrid:QSpinnerGrid,QSpinnerHearts:QSpinnerHearts,QSpinnerHourglass:QSpinnerHourglass,QSpinnerInfinity:QSpinnerInfinity,QSpinnerIos:QSpinnerIos,QSpinnerOrbit:QSpinnerOrbit,QSpinnerOval:QSpinnerOval,QSpinnerPie:QSpinnerPie,QSpinnerPuff:QSpinnerPuff,QSpinnerRadio:QSpinnerRadio,QSpinnerRings:QSpinnerRings,QSpinnerTail:QSpinnerTail,QSplitter:QSplitter,QStep:QStep,QStepper:QStepper,QStepperNavigation:QStepperNavigation,QTabPanels:QTabPanels,QTabPanel:QTabPanel,QTable:QTable,QTh:QTh,QTr:QTr,QTd:QTd,QTabs:QTabs,QTab:QTab,QRouteTab:QRouteTab,QTime:QTime,QTimeline:QTimeline,QTimelineEntry:QTimelineEntry,QToggle:QToggle,QToolbar:QToolbar,QToolbarTitle:QToolbarTitle,QTooltip:QTooltip,QTree:QTree,QUploader:QUploader,QUploaderAddTrigger:QUploaderAddTrigger,QVideo:QVideo,QVirtualScroll:QVirtualScroll});function getDepth(e){if(!1===e)return 0;if(!0===e||void 0===e)return 1;const t=parseInt(e,10);return isNaN(t)?0:t}var ClosePopup=createDirective({name:"close-popup",beforeMount(e,{value:t}){const o={depth:getDepth(t),handler(t){0!==o.depth&&setTimeout(()=>{const n=getPortalVm(e);void 0!==n&&closePortals(n,t,o.depth)})},handlerKey(e){!0===isKeyCode(e,13)&&o.handler(e)}};e.__qclosepopup=o,e.addEventListener("click",o.handler),e.addEventListener("keyup",o.handlerKey)},updated(e,{value:t,oldValue:o}){t!==o&&(e.__qclosepopup.depth=getDepth(t))},beforeUnmount(e){const t=e.__qclosepopup;e.removeEventListener("click",t.handler),e.removeEventListener("keyup",t.handlerKey),delete e.__qclosepopup}});const morphGroups={},props$1=["duration","delay","easing","fill","classes","style","duration","resize","useCSS","hideFromClone","keepToClone","tween","tweenFromOpacity","tweenToOpacity","waitFor","onEnd"],mods=["resize","useCSS","hideFromClone","keepToClone","tween"];function changeClass(e,t){e.clsAction!==t&&(e.clsAction=t,e.el.classList[t]("q-morph--invisible"))}function trigger(e){if(!0===e.animating||e.queue.length<2)return;const[t,o]=e.queue;e.animating=!0,t.animating=!0,o.animating=!0,changeClass(t,"remove"),changeClass(o,"remove");const n=morph({from:t.el,to:o.el,onToggle(){changeClass(t,"add"),changeClass(o,"remove")},...o.opts,onEnd(n,a){void 0!==o.opts.onEnd&&o.opts.onEnd(n,a),!0!==a&&(t.animating=!1,o.animating=!1,e.animating=!1,e.cancel=void 0,e.queue.shift(),trigger(e))}});e.cancel=(()=>{n(!0),e.cancel=void 0})}function updateModifiers(e,t){const o=t.opts;mods.forEach(t=>{o[t]=!0===e[t]})}function insertArgs(e,t){const o="string"===typeof e&&e.length>0?e.split(":"):[];t.name=o[0],t.group=o[1],Object.assign(t.opts,{duration:!0===isNaN(o[2])?300:parseFloat(o[2]),waitFor:o[3]})}function updateArgs(e,t){void 0!==e.group&&(t.group=e.group),void 0!==e.name&&(t.name=e.name);const o=t.opts;props$1.forEach(t=>{void 0!==e[t]&&(o[t]=e[t])})}function updateModel(e,t){if(t.name!==e)!1===t.animating&&changeClass(t,"add");else{const o=morphGroups[t.group];void 0===o?(morphGroups[t.group]={name:t.group,model:e,queue:[t],animating:!1},changeClass(t,"remove")):o.model!==e&&(o.model=e,o.queue.push(t),!1===o.animating&&2===o.queue.length&&trigger(o))}}function updateValue(e,t){let o;Object(t)===t?(o=""+t.model,updateArgs(t,e),updateModifiers(t,e)):o=""+t,o!==e.model?(e.model=o,updateModel(o,e)):!1===e.animating&&void 0!==e.clsAction&&e.el.classList[e.clsAction]("q-morph--invisible")}var Morph=createDirective({name:"morph",mounted(e,t){const o={el:e,animating:!1,opts:{}};updateModifiers(t.modifiers,o),insertArgs(t.arg,o),updateValue(o,t.value),e.__qmorph=o},updated(e,t){updateValue(e.__qmorph,t.value)},beforeUnmount(e){const t=e.__qmorph,o=morphGroups[t.group];if(void 0!==o){const e=o.queue.indexOf(t);-1!==e&&(o.queue=o.queue.filter(e=>e!==t),0===o.queue.length&&(void 0!==o.cancel&&o.cancel(),delete morphGroups[t.group]))}"add"===t.clsAction&&e.classList.remove("q-morph--invisible"),delete e.__qmorph}});const defaultCfg={childList:!0,subtree:!0,attributes:!0,characterData:!0,attributeOldValue:!0,characterDataOldValue:!0};function update$2(e,t,o){t.handler=o,void 0!==t.observer&&t.observer.disconnect(),t.observer=new MutationObserver(o=>{if("function"===typeof t.handler){const n=t.handler(o);!1!==n&&!0!==t.once||destroy(e)}}),t.observer.observe(e,t.opts)}function destroy(e){const t=e.__qmutation;void 0!==t&&(void 0!==t.observer&&t.observer.disconnect(),delete e.__qmutation)}var Mutation=createDirective({name:"mutation",mounted(e,{modifiers:{once:t,...o},value:n}){const a={once:t,opts:0===Object.keys(o).length?defaultCfg:o};update$2(e,a,n),e.__qmutation=a},updated(e,{oldValue:t,value:o}){const n=e.__qmutation;void 0!==n&&t!==o&&update$2(e,n,o)},beforeUnmount:destroy});const{passive:passive}=listenOpts;function update$1(e,{value:t,oldValue:o}){"function"===typeof t?(e.handler=t,"function"!==typeof o&&(e.scrollTarget.addEventListener("scroll",e.scroll,passive),e.scroll())):e.scrollTarget.removeEventListener("scroll",e.scroll,passive)}var ScrollFire=createDirective({name:"scroll-fire",mounted(e,t){const o={scrollTarget:getScrollTarget(e),scroll:debounce(()=>{let t,n;o.scrollTarget===window?(n=e.getBoundingClientRect().bottom,t=window.innerHeight):(n=offset(e).top+height(e),t=offset(o.scrollTarget).top+height(o.scrollTarget)),n>0&&n<t&&(o.scrollTarget.removeEventListener("scroll",o.scroll,passive),o.handler(e))},25)};update$1(o,t),e.__qscrollfire=o},updated(e,t){t.value!==t.oldValue&&update$1(e.__qscrollfire,t)},beforeUnmount(e){const t=e.__qscrollfire;t.scrollTarget.removeEventListener("scroll",t.scroll,passive),t.scroll.cancel(),delete e.__qscrollfire}});function update(e,{value:t,oldValue:o}){"function"===typeof t?(e.handler=t,"function"!==typeof o&&e.scrollTarget.addEventListener("scroll",e.scroll,listenOpts.passive)):e.scrollTarget.removeEventListener("scroll",e.scroll,listenOpts.passive)}var Scroll=createDirective({name:"scroll",mounted(e,t){const o={scrollTarget:getScrollTarget(e),scroll(){o.handler(getVerticalScrollPosition(o.scrollTarget),getHorizontalScrollPosition(o.scrollTarget))}};update(o,t),e.__qscroll=o},updated(e,t){void 0!==e.__qscroll&&t.oldValue!==t.value&&update(e.__qscroll,t)},beforeUnmount(e){const t=e.__qscroll;t.scrollTarget.removeEventListener("scroll",t.scroll,listenOpts.passive),delete e.__qscroll}}),TouchHold=createDirective({name:"touch-hold",beforeMount(e,t){const{modifiers:o}=t;if(!0!==o.mouse&&!0!==client.has.touch)return;const n={handler:t.value,noop:noop,mouseStart(e){"function"===typeof n.handler&&!0===leftClick(e)&&(addEvt(n,"temp",[[document,"mousemove","move","passiveCapture"],[document,"click","end","notPassiveCapture"]]),n.start(e,!0))},touchStart(e){if(void 0!==e.target&&"function"===typeof n.handler){const t=e.target;addEvt(n,"temp",[[t,"touchmove","move","passiveCapture"],[t,"touchcancel","end","notPassiveCapture"],[t,"touchend","end","notPassiveCapture"]]),n.start(e)}},start(e,t){n.origin=position(e);const o=Date.now();!0===client.is.mobile&&(document.body.classList.add("non-selectable"),clearSelection(),n.styleCleanup=(e=>{n.styleCleanup=void 0;const t=()=>{document.body.classList.remove("non-selectable")};!0===e?(clearSelection(),setTimeout(t,10)):t()})),n.triggered=!1,n.sensitivity=!0===t?n.mouseSensitivity:n.touchSensitivity,n.timer=setTimeout(()=>{clearSelection(),n.triggered=!0,n.handler({evt:e,touch:!0!==t,mouse:!0===t,position:n.origin,duration:Date.now()-o})},n.duration)},move(e){const{top:t,left:o}=position(e);(Math.abs(o-n.origin.left)>=n.sensitivity||Math.abs(t-n.origin.top)>=n.sensitivity)&&clearTimeout(n.timer)},end(e){cleanEvt(n,"temp"),void 0!==n.styleCleanup&&n.styleCleanup(n.triggered),!0===n.triggered?void 0!==e&&stopAndPrevent(e):clearTimeout(n.timer)}},a=[600,5,7];"string"===typeof t.arg&&t.arg.length>0&&t.arg.split(":").forEach((e,t)=>{const o=parseInt(e,10);o&&(a[t]=o)}),[n.duration,n.touchSensitivity,n.mouseSensitivity]=a,e.__qtouchhold=n,!0===o.mouse&&addEvt(n,"main",[[e,"mousedown","mouseStart",`passive${!0===o.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(n,"main",[[e,"touchstart","touchStart",`passive${!0===o.capture?"Capture":""}`],[e,"touchend","noop","notPassiveCapture"]])},updated(e,t){const o=e.__qtouchhold;void 0!==o&&t.oldValue!==t.value&&("function"!==typeof t.value&&o.end(),o.handler=t.value)},beforeUnmount(e){const t=e.__qtouchhold;void 0!==t&&(cleanEvt(t,"main"),cleanEvt(t,"temp"),clearTimeout(t.timer),void 0!==t.styleCleanup&&t.styleCleanup(),delete e.__qtouchhold)}});const keyCodes={esc:27,tab:9,enter:13,space:32,up:38,left:37,right:39,down:40,delete:[8,46]},keyRegex=new RegExp(`^([\\d+]+|${Object.keys(keyCodes).join("|")})$`,"i");function shouldEnd(e,t){const{top:o,left:n}=position(e);return Math.abs(n-t.left)>=7||Math.abs(o-t.top)>=7}var TouchRepeat=createDirective({name:"touch-repeat",beforeMount(e,{modifiers:t,value:o,arg:n}){const a=Object.keys(t).reduce((e,t)=>{if(!0===keyRegex.test(t)){const o=isNaN(parseInt(t,10))?keyCodes[t.toLowerCase()]:parseInt(t,10);o>=0&&e.push(o)}return e},[]);if(!0!==t.mouse&&!0!==client.has.touch&&0===a.length)return;const l="string"===typeof n&&n.length>0?n.split(":").map(e=>parseInt(e,10)):[0,600,300],i=l.length-1,r={keyboard:a,handler:o,noop:noop,mouseStart(e){void 0===r.event&&"function"===typeof r.handler&&!0===leftClick(e)&&(addEvt(r,"temp",[[document,"mousemove","move","passiveCapture"],[document,"click","end","notPassiveCapture"]]),r.start(e,!0))},keyboardStart(t){if("function"===typeof r.handler&&!0===isKeyCode(t,a)){if((0===l[0]||void 0!==r.event)&&(stopAndPrevent(t),e.focus(),void 0!==r.event))return;addEvt(r,"temp",[[document,"keyup","end","notPassiveCapture"],[document,"click","end","notPassiveCapture"]]),r.start(t,!1,!0)}},touchStart(e){if(void 0!==e.target&&"function"===typeof r.handler){const t=e.target;addEvt(r,"temp",[[t,"touchmove","move","passiveCapture"],[t,"touchcancel","end","notPassiveCapture"],[t,"touchend","end","notPassiveCapture"]]),r.start(e)}},start(e,t,o){function n(e){r.styleCleanup=void 0,document.documentElement.style.cursor="";const t=()=>{document.body.classList.remove("non-selectable")};!0===e?(clearSelection(),setTimeout(t,10)):t()}!0!==o&&(r.origin=position(e)),!0===client.is.mobile&&(document.body.classList.add("non-selectable"),clearSelection(),r.styleCleanup=n),r.event={touch:!0!==t&&!0!==o,mouse:!0===t,keyboard:!0===o,startTime:Date.now(),repeatCount:0};const a=()=>{if(void 0===r.event)return;0===r.event.repeatCount&&(r.event.evt=e,!0===o?r.event.keyCode=e.keyCode:r.event.position=position(e),!0!==client.is.mobile&&(document.documentElement.style.cursor="pointer",document.body.classList.add("non-selectable"),clearSelection(),r.styleCleanup=n)),r.event.duration=Date.now()-r.event.startTime,r.event.repeatCount+=1,r.handler(r.event);const t=i<r.event.repeatCount?i:r.event.repeatCount;r.timer=setTimeout(a,l[t])};0===l[0]?a():r.timer=setTimeout(a,l[0])},move(e){void 0!==r.event&&!0===shouldEnd(e,r.origin)&&clearTimeout(r.timer)},end(e){void 0!==r.event&&(void 0!==r.styleCleanup&&r.styleCleanup(!0),void 0!==e&&r.event.repeatCount>0&&stopAndPrevent(e),cleanEvt(r,"temp"),clearTimeout(r.timer),r.event=void 0)}};e.__qtouchrepeat=r,!0===t.mouse&&addEvt(r,"main",[[e,"mousedown","mouseStart",`passive${!0===t.mouseCapture?"Capture":""}`]]),!0===client.has.touch&&addEvt(r,"main",[[e,"touchstart","touchStart",`passive${!0===t.capture?"Capture":""}`],[e,"touchend","noop","notPassiveCapture"]]),a.length>0&&addEvt(r,"main",[[e,"keydown","keyboardStart",`notPassive${!0===t.keyCapture?"Capture":""}`]])},updated(e,{oldValue:t,value:o}){const n=e.__qtouchrepeat;void 0!==n&&t!==o&&("function"!==typeof o&&n.end(),n.handler=o)},beforeUnmount(e){const t=e.__qtouchrepeat;void 0!==t&&(clearTimeout(t.timer),cleanEvt(t,"main"),cleanEvt(t,"temp"),void 0!==t.styleCleanup&&t.styleCleanup(),delete e.__qtouchrepeat)}}),directives=Object.freeze({__proto__:null,ClosePopup:ClosePopup,Intersection:Intersection,Morph:Morph,Mutation:Mutation,Ripple:Ripple,ScrollFire:ScrollFire,Scroll:Scroll,TouchHold:TouchHold,TouchPan:TouchPan,TouchRepeat:TouchRepeat,TouchSwipe:TouchSwipe});let metaValue;function getProp(){return client.is.winphone?"msapplication-navbutton-color":client.is.safari?"apple-mobile-web-app-status-bar-style":"theme-color"}function getMetaTag(e){const t=document.getElementsByTagName("META");for(const o in t)if(t[o].name===e)return t[o]}function setColor(e){void 0===metaValue&&(metaValue=getProp());let t=getMetaTag(metaValue);const o=void 0===t;o&&(t=document.createElement("meta"),t.setAttribute("name",metaValue)),t.setAttribute("content",e),o&&document.head.appendChild(t)}var AddressbarColor={set:!0!==client.is.mobile||!0!==client.is.nativeMobile&&!0!==client.is.winphone&&!0!==client.is.safari&&!0!==client.is.webkit&&!0!==client.is.vivaldi?noop:e=>{const t=e||getCssVar("primary");!0===client.is.nativeMobile&&window.StatusBar?window.StatusBar.backgroundColorByHexString(t):setColor(t)},install({$q:e}){e.addressbarColor=this,e.config.addressbarColor&&this.set(e.config.addressbarColor)}};const prefixes={};function assignFn(e){Object.assign(Plugin$6,{request:e,exit:e,toggle:e})}function getFullscreenElement(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement||null}function updateEl(){const e=Plugin$6.activeEl=!1===Plugin$6.isActive?null:getFullscreenElement();changeGlobalNodesTarget(null===e||e===document.documentElement?document.body:e)}function togglePluginState(){Plugin$6.isActive=!1===Plugin$6.isActive,updateEl()}function promisify(e,t){try{const o=e[t]();return void 0===o?Promise.resolve():o}catch(e){return Promise.reject(e)}}const Plugin$6=defineReactivePlugin({isActive:!1,activeEl:null},{isCapable:!1,install({$q:e}){e.fullscreen=this}});prefixes.request=["requestFullscreen","msRequestFullscreen","mozRequestFullScreen","webkitRequestFullscreen"].find(e=>void 0!==document.documentElement[e]),Plugin$6.isCapable=void 0!==prefixes.request,!1===Plugin$6.isCapable?assignFn(()=>Promise.reject("Not capable")):(Object.assign(Plugin$6,{request(e){const t=e||document.documentElement,{activeEl:o}=Plugin$6;if(t===o)return Promise.resolve();const n=null!==o&&!0===t.contains(o)?Plugin$6.exit():Promise.resolve();return n.finally(()=>promisify(t,prefixes.request))},exit(){return!0===Plugin$6.isActive?promisify(document,prefixes.exit):Promise.resolve()},toggle(e){return!0===Plugin$6.isActive?Plugin$6.exit():Plugin$6.request(e)}}),prefixes.exit=["exitFullscreen","msExitFullscreen","mozCancelFullScreen","webkitExitFullscreen"].find(e=>document[e]),Plugin$6.isActive=Boolean(getFullscreenElement()),!0===Plugin$6.isActive&&updateEl(),["onfullscreenchange","onmsfullscreenchange","onwebkitfullscreenchange"].forEach(e=>{document[e]=togglePluginState}));const Plugin$5=defineReactivePlugin({appVisible:!0},{install({$q:e}){injectProp(e,"appVisible",()=>this.appVisible)}});{let e,t;if("undefined"!==typeof document.hidden?(e="hidden",t="visibilitychange"):"undefined"!==typeof document.msHidden?(e="msHidden",t="msvisibilitychange"):"undefined"!==typeof document.webkitHidden&&(e="webkitHidden",t="webkitvisibilitychange"),t&&"undefined"!==typeof document[e]){const o=()=>{Plugin$5.appVisible=!document[e]};document.addEventListener(t,o,!1)}}var BottomSheet$1=createComponent({name:"BottomSheetPlugin",props:{...useDarkProps,title:String,message:String,actions:Array,grid:Boolean,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},emits:["ok","hide"],setup(e,{emit:t}){const{proxy:o}=getCurrentInstance(),n=useDark(e,o.$q),a=ref(null);function l(){a.value.show()}function i(){a.value.hide()}function r(e){t("ok",e),i()}function s(){t("hide")}function u(){return e.actions.map(e=>{const t=e.avatar||e.img;return void 0===e.label?h(QSeparator,{class:"col-all",dark:n.value}):h("div",{class:["q-bottom-sheet__item q-hoverable q-focusable cursor-pointer relative-position",e.class],tabindex:0,onClick(){r(e)},onKeyup(t){13===t.keyCode&&r(e)}},[h("div",{class:"q-focus-helper"}),e.icon?h(QIcon,{name:e.icon,color:e.color}):t?h("img",{class:e.avatar?"q-bottom-sheet__avatar":"",src:t}):h("div",{class:"q-bottom-sheet__empty-icon"}),h("div",e.label)])})}function c(){return e.actions.map(e=>{const t=e.avatar||e.img;return void 0===e.label?h(QSeparator,{spaced:!0,dark:n.value}):h(QItem,{class:["q-bottom-sheet__item",e.classes],tabindex:0,clickable:!0,dark:n.value,onClick(){r(e)},onKeyup(t){13===t.keyCode&&r(e)}},()=>[h(QItemSection,{avatar:!0},()=>e.icon?h(QIcon,{name:e.icon,color:e.color}):t?h("img",{class:e.avatar?"q-bottom-sheet__avatar":"",src:t}):null),h(QItemSection,()=>e.label)])})}function d(){const t=[];return e.title&&t.push(h(QCardSection,{class:"q-dialog__title"},()=>e.title)),e.message&&t.push(h(QCardSection,{class:"q-dialog__message"},()=>e.message)),t.push(!0===e.grid?h("div",{class:"row items-stretch justify-start"},u()):h("div",c())),t}function p(){return[h(QCard,{class:[`q-bottom-sheet q-bottom-sheet--${!0===e.grid?"grid":"list"}`+(!0===n.value?" q-bottom-sheet--dark q-dark":""),e.cardClass],style:e.cardStyle},d)]}return Object.assign(o,{show:l,hide:i}),()=>h(QDialog,{ref:a,position:"bottom",onHide:s},p)}});function merge(e,t){for(const o in t)"spinner"!==o&&Object(t[o])===t[o]?(e[o]=Object(e[o])!==e[o]?{}:{...e[o]},merge(e[o],t[o])):e[o]=t[o]}function globalDialog(e,t,o){return n=>{let a,l;const i=!0===t&&void 0!==n.component;if(!0===i){const{component:e,componentProps:t}=n;a="string"===typeof e?o.component(e):e,l=t}else{const{class:t,style:o,...i}=n;a=e,l=i,void 0!==t&&(i.cardClass=t),void 0!==o&&(i.cardStyle=o)}let r,s=!1;const u=ref(null),c=createGlobalNode(),d=e=>{null!==u.value&&void 0!==u.value[e]?u.value[e]():r.$.subTree&&r.$.subTree.component&&r.$.subTree.component.proxy&&r.$.subTree.component.proxy[e]?r.$.subTree.component.proxy[e]():console.error("[Quasar] Incorrectly defined Dialog component")},p=[],v=[],m={onOk(e){return p.push(e),m},onCancel(e){return v.push(e),m},onDismiss(e){return p.push(e),v.push(e),m},hide(){return d("hide"),m},update(e){if(null!==r){if(!0===i)Object.assign(l,e);else{const{class:t,style:o,...n}=e;void 0!==t&&(n.cardClass=t),void 0!==o&&(n.cardStyle=o),merge(l,n)}r.$forceUpdate()}return m}},f=e=>{s=!0,p.forEach(t=>{t(e)})},g=()=>{b.unmount(c),removeGlobalNode(c),b=null,r=null,!0!==s&&v.forEach(e=>{e()})};let b=createChildApp({name:"QGlobalDialog",setup:()=>()=>h(a,{...l,ref:u,onOk:f,onHide:g})},o);function y(){d("show")}return r=b.mount(c),"function"===typeof a.__asyncLoader?a.__asyncLoader().then(()=>{nextTick(y)}):nextTick(y),m}}var BottomSheet={install({$q:e,parentApp:t}){e.bottomSheet=globalDialog(BottomSheet$1,!1,t),!0!==this.__installed&&(this.create=e.bottomSheet)}};function encode$1(e){return encodeURIComponent(e)}function decode$1(e){return decodeURIComponent(e)}function stringifyCookieValue(e){return encode$1(e===Object(e)?JSON.stringify(e):""+e)}function read(e){if(""===e)return e;0===e.indexOf('"')&&(e=e.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,"\\")),e=decode$1(e.replace(/\+/g," "));try{e=JSON.parse(e)}catch(e){}return e}function getString(e){const t=new Date;return t.setMilliseconds(t.getMilliseconds()+e),t.toUTCString()}function parseExpireString(e){let t=0;const o=e.match(/(\d+)d/),n=e.match(/(\d+)h/),a=e.match(/(\d+)m/),l=e.match(/(\d+)s/);return o&&(t+=864e5*o[1]),n&&(t+=36e5*n[1]),a&&(t+=6e4*a[1]),l&&(t+=1e3*l[1]),0===t?e:getString(t)}function set(e,t,o={},n){let a,l;void 0!==o.expires&&("[object Date]"===Object.prototype.toString.call(o.expires)?a=o.expires.toUTCString():"string"===typeof o.expires?a=parseExpireString(o.expires):(l=parseFloat(o.expires),a=!1===isNaN(l)?getString(864e5*l):o.expires));const i=`${encode$1(e)}=${stringifyCookieValue(t)}`,r=[i,void 0!==a?"; Expires="+a:"",o.path?"; Path="+o.path:"",o.domain?"; Domain="+o.domain:"",o.sameSite?"; SameSite="+o.sameSite:"",o.httpOnly?"; HttpOnly":"",o.secure?"; Secure":"",o.other?"; "+o.other:""].join("");if(n){n.req.qCookies?n.req.qCookies.push(r):n.req.qCookies=[r],n.res.setHeader("Set-Cookie",n.req.qCookies);let t=n.req.headers.cookie||"";if(void 0!==a&&l<0){const o=get(e,n);void 0!==o&&(t=t.replace(`${e}=${o}; `,"").replace(`; ${e}=${o}`,"").replace(`${e}=${o}`,""))}else t=t?`${i}; ${t}`:r;n.req.headers.cookie=t}else document.cookie=r}function get(e,t){const o=t?t.req.headers:document,n=o.cookie?o.cookie.split("; "):[],a=n.length;let l,i,r,s=e?null:{},u=0;for(;u<a;u++)if(l=n[u].split("="),i=decode$1(l.shift()),r=l.join("="),e){if(e===i){s=read(r);break}}else s[i]=r;return s}function remove(e,t,o){set(e,"",{expires:-1,...t},o)}function has(e,t){return null!==get(e,t)}function getObject(e){return{get:t=>get(t,e),set:(t,o,n)=>set(t,o,n,e),has:t=>has(t,e),remove:(t,o)=>remove(t,o,e),getAll:()=>get(null,e)}}const Plugin$4={install({$q:e,ssrContext:t}){e.cookies=this}};Object.assign(Plugin$4,getObject());var DialogPlugin=createComponent({name:"DialogPlugin",props:{...useDarkProps,title:String,message:String,prompt:Object,options:Object,progress:[Boolean,Object],html:Boolean,ok:{type:[String,Object,Boolean],default:!0},cancel:[String,Object,Boolean],focus:{type:String,default:"ok",validator:e=>["ok","cancel","none"].includes(e)},stackButtons:Boolean,color:String,cardClass:[String,Array,Object],cardStyle:[String,Array,Object]},emits:["ok","hide"],setup(e,{emit:t}){const{proxy:o}=getCurrentInstance(),{$q:n}=o,a=useDark(e,n),l=ref(null),i=ref(void 0!==e.prompt?e.prompt.model:void 0!==e.options?e.options.model:void 0),r=computed(()=>"q-dialog-plugin"+(!0===a.value?" q-dialog-plugin--dark q-dark":"")+(!1!==e.progress?" q-dialog-plugin--progress":"")),s=computed(()=>e.color||(!0===a.value?"amber":"primary")),u=computed(()=>!1===e.progress?null:Object(e.progress)===e.progress?{component:e.progress.spinner||QSpinner,props:{color:e.progress.color||s.value}}:{component:QSpinner,props:{color:s.value}}),c=computed(()=>void 0!==e.prompt||void 0!==e.options),d=computed(()=>{if(!0!==c.value)return{};const{model:t,isValid:o,items:n,...a}=void 0!==e.prompt?e.prompt:e.options;return a}),p=computed(()=>Object(e.ok)===e.ok?n.lang.label.ok:!0===e.ok?n.lang.label.ok:e.ok),v=computed(()=>Object(e.cancel)===e.cancel?n.lang.label.cancel:!0===e.cancel?n.lang.label.cancel:e.cancel),m=computed(()=>{return void 0!==e.prompt?void 0!==e.prompt.isValid&&!0!==e.prompt.isValid(i.value):void 0!==e.options&&(void 0!==e.options.isValid&&!0!==e.options.isValid(i.value))}),f=computed(()=>({color:s.value,label:p.value,ripple:!1,disable:m.value,...Object(e.ok)===e.ok?e.ok:{flat:!0},"data-autofocus":"ok"===e.focus&&!0!==c.value||void 0,onClick:S})),g=computed(()=>({color:s.value,label:v.value,ripple:!1,...Object(e.cancel)===e.cancel?e.cancel:{flat:!0},"data-autofocus":"cancel"===e.focus&&!0!==c.value||void 0,onClick:w}));function b(){l.value.show()}function y(){l.value.hide()}function S(){t("ok",toRaw(i.value)),y()}function w(){y()}function C(){t("hide")}function x(e){i.value=e}function k(t){!0!==m.value&&"textarea"!==e.prompt.type&&!0===isKeyCode(t,13)&&S()}function _(t,o){return!0===e.html?h(QCardSection,{class:t,innerHTML:o}):h(QCardSection,{class:t},()=>o)}function q(){return[h(QInput,{modelValue:i.value,...d.value,color:s.value,dense:!0,autofocus:!0,dark:a.value,"onUpdate:modelValue":x,onKeyup:k})]}function T(){return[h(QOptionGroup,{modelValue:i.value,...d.value,color:s.value,options:e.options.items,dark:a.value,"onUpdate:modelValue":x})]}function P(){const t=[];return e.cancel&&t.push(h(QBtn,g.value)),e.ok&&t.push(h(QBtn,f.value)),h(QCardActions,{class:!0===e.stackButtons?"items-end":"",vertical:e.stackButtons,align:"right"},()=>t)}function $(){const t=[];return e.title&&t.push(_("q-dialog__title",e.title)),!1!==e.progress&&t.push(h(QCardSection,{class:"q-dialog__progress"},()=>h(u.value.component,u.value.props))),e.message&&t.push(_("q-dialog__message",e.message)),void 0!==e.prompt?t.push(h(QCardSection,{class:"scroll q-dialog-plugin__form"},q)):void 0!==e.options&&t.push(h(QSeparator,{dark:a.value}),h(QCardSection,{class:"scroll q-dialog-plugin__form"},T),h(QSeparator,{dark:a.value})),(e.ok||e.cancel)&&t.push(P()),t}function M(){return[h(QCard,{class:[r.value,e.cardClass],style:e.cardStyle,dark:a.value},$)]}return watch(()=>e.prompt&&e.prompt.model,x),watch(()=>e.options&&e.options.model,x),Object.assign(o,{show:b,hide:y}),()=>h(QDialog,{ref:l,onHide:C},M)}}),Dialog={install({$q:e,parentApp:t}){e.dialog=globalDialog(DialogPlugin,!0,t),!0!==this.__installed&&(this.create=e.dialog)}};const barRef=ref(null),Plugin$3=defineReactivePlugin({isActive:!1},{start:noop,stop:noop,increment:noop,setDefaults:noop,install({$q:e,parentApp:t}){if(e.loadingBar=this,!0===this.__installed)return void(void 0!==e.config.loadingBar&&this.setDefaults(e.config.loadingBar));const o=ref(void 0!==e.config.loadingBar?{...e.config.loadingBar}:{}),n=createGlobalNode("q-loading-bar");createChildApp({name:"LoadingBar",devtools:{hide:!0},setup:()=>()=>h(QAjaxBar,{...o.value,ref:barRef})},t).mount(n),Object.assign(this,{start(e){barRef.value.start(e),Plugin$3.isActive=!0},stop(){const e=barRef.value.stop();Plugin$3.isActive=e>0},increment(){barRef.value.increment.apply(null,arguments)},setDefaults(e){e===Object(e)&&Object.assign(o.value,e)}})}});let app,vm,timeout,uid$1=0,props={};const originalDefaults={delay:0,message:!1,html:!1,spinnerSize:80,spinnerColor:"",messageColor:"",backgroundColor:"",boxClass:"",spinner:QSpinner,customClass:""},defaults$1={...originalDefaults},Plugin$2=defineReactivePlugin({isActive:!1},{show(e){if(props=e===Object(e)&&!0===e.ignoreDefaults?{...originalDefaults,...e}:{...defaults$1,...e},Plugin$2.isActive=!0,void 0!==app)return props.uid=uid$1,void vm.$forceUpdate();props.uid=++uid$1,clearTimeout(timeout),timeout=setTimeout(()=>{timeout=void 0;const e=createGlobalNode("q-loading");app=createApp({name:"QLoading",setup(){function t(){!0!==Plugin$2.isActive&&void 0!==app&&(preventScroll(!1),app.unmount(e),removeGlobalNode(e),app=void 0,vm=void 0)}function o(){if(!0!==Plugin$2.isActive)return null;const e=[h(props.spinner,{class:"q-loading__spinner",color:props.spinnerColor,size:props.spinnerSize})];return props.message&&e.push(h("div",{class:"q-loading__message"+(props.messageColor?` text-${props.messageColor}`:""),[!0===props.html?"innerHTML":"textContent"]:props.message})),h("div",{class:"q-loading fullscreen flex flex-center z-max "+props.customClass.trim(),key:props.uid},[h("div",{class:"q-loading__backdrop"+(props.backgroundColor?` bg-${props.backgroundColor}`:"")}),h("div",{class:"q-loading__box column items-center "+props.boxClass},e)])}return onMounted(()=>{preventScroll(!0)}),()=>h(Transition,{name:"q-transition--fade",appear:!0,onAfterLeave:t},o)}}),vm=app.mount(e)},props.delay)},hide(){!0===Plugin$2.isActive&&(void 0!==timeout&&(clearTimeout(timeout),timeout=void 0),Plugin$2.isActive=!1)},setDefaults(e){e===Object(e)&&Object.assign(defaults$1,e)},install({$q:e}){e.loading=this,void 0!==e.config.loading&&this.setDefaults(e.config.loading)}});let uid=0;const defaults={},groups={},notificationsList={},positionClass={},emptyRE=/^\s*$/,notifRefs=[],positionList=["top-left","top-right","bottom-left","bottom-right","top","bottom","left","right","center"],badgePositions=["top-left","top-right","bottom-left","bottom-right"],notifTypes={positive:{icon:e=>e.iconSet.type.positive,color:"positive"},negative:{icon:e=>e.iconSet.type.negative,color:"negative"},warning:{icon:e=>e.iconSet.type.warning,color:"warning",textColor:"dark"},info:{icon:e=>e.iconSet.type.info,color:"info"},ongoing:{group:!1,timeout:0,spinner:!0,color:"grey-8"}};function addNotification(e,t,o){if(!e)return logError("parameter required");let n;const a={textColor:"white"};if(!0!==e.ignoreDefaults&&Object.assign(a,defaults),Object(e)!==e&&(a.type&&Object.assign(a,notifTypes[a.type]),e={message:e}),Object.assign(a,notifTypes[e.type||a.type],e),"function"===typeof a.icon&&(a.icon=a.icon(t)),a.spinner?(!0===a.spinner&&(a.spinner=QSpinner),a.spinner=markRaw(a.spinner)):a.spinner=!1,a.meta={hasMedia:Boolean(!1!==a.spinner||a.icon||a.avatar),hasText:hasContent(a.message)||hasContent(a.caption)},a.position){if(!1===positionList.includes(a.position))return logError("wrong position",e)}else a.position="bottom";if(void 0===a.timeout)a.timeout=5e3;else{const t=parseInt(a.timeout,10);if(isNaN(t)||t<0)return logError("wrong timeout",e);a.timeout=t}0===a.timeout?a.progress=!1:!0===a.progress&&(a.meta.progressClass="q-notification__progress"+(a.progressClass?` ${a.progressClass}`:""),a.meta.progressStyle={animationDuration:`${a.timeout+1e3}ms`});const l=(!0===Array.isArray(e.actions)?e.actions:[]).concat(!0!==e.ignoreDefaults&&!0===Array.isArray(defaults.actions)?defaults.actions:[]).concat(void 0!==notifTypes[e.type]&&!0===Array.isArray(notifTypes[e.type].actions)?notifTypes[e.type].actions:[]),{closeBtn:i}=a;if(i&&l.push({label:"string"===typeof i?i:t.lang.label.close}),a.actions=l.map(({handler:e,noDismiss:t,...o})=>({flat:!0,...o,onClick:"function"===typeof e?()=>{e(),!0!==t&&r()}:()=>{r()}})),void 0===a.multiLine&&(a.multiLine=a.actions.length>1),Object.assign(a.meta,{class:"q-notification row items-stretch"+` q-notification--${!0===a.multiLine?"multi-line":"standard"}`+(void 0!==a.color?` bg-${a.color}`:"")+(void 0!==a.textColor?` text-${a.textColor}`:"")+(void 0!==a.classes?` ${a.classes}`:""),wrapperClass:"q-notification__wrapper col relative-position border-radius-inherit "+(!0===a.multiLine?"column no-wrap justify-center":"row items-center"),contentClass:"q-notification__content row items-center"+(!0===a.multiLine?"":" col"),leftClass:!0===a.meta.hasText?"additional":"single",attrs:{role:"alert",...a.attrs}}),!1===a.group?(a.group=void 0,a.meta.group=void 0):(void 0!==a.group&&!0!==a.group||(a.group=[a.message,a.caption,a.multiline].concat(a.actions.map(e=>`${e.label}*${e.icon}`)).join("|")),a.meta.group=a.group+"|"+a.position),0===a.actions.length?a.actions=void 0:a.meta.actionsClass="q-notification__actions row items-center "+(!0===a.multiLine?"justify-end":"col-auto")+(!0===a.meta.hasMedia?" q-notification__actions--with-media":""),void 0!==o){clearTimeout(o.notif.meta.timer),a.meta.uid=o.notif.meta.uid;const e=notificationsList[a.position].value.indexOf(o.notif);notificationsList[a.position].value[e]=a}else{const t=groups[a.meta.group];if(void 0===t){if(a.meta.uid=uid++,a.meta.badge=1,-1!==["left","right","center"].indexOf(a.position))notificationsList[a.position].value.splice(Math.floor(notificationsList[a.position].value.length/2),0,a);else{const e=a.position.indexOf("top")>-1?"unshift":"push";notificationsList[a.position].value[e](a)}void 0!==a.group&&(groups[a.meta.group]=a)}else{if(clearTimeout(t.meta.timer),void 0!==a.badgePosition){if(!1===badgePositions.includes(a.badgePosition))return logError("wrong badgePosition",e)}else a.badgePosition=`top-${a.position.indexOf("left")>-1?"right":"left"}`;a.meta.uid=t.meta.uid,a.meta.badge=t.meta.badge+1,a.meta.badgeClass=`q-notification__badge q-notification__badge--${a.badgePosition}`+(void 0!==a.badgeColor?` bg-${a.badgeColor}`:"")+(void 0!==a.badgeTextColor?` text-${a.badgeTextColor}`:"")+(a.badgeClass?` ${a.badgeClass}`:"");const o=notificationsList[a.position].value.indexOf(t);notificationsList[a.position].value[o]=groups[a.meta.group]=a}}const r=()=>{removeNotification(a),n=void 0};return a.timeout>0&&(a.meta.timer=setTimeout(()=>{r()},a.timeout+1e3)),void 0!==a.group?t=>{void 0!==t?logError("trying to update a grouped one which is forbidden",e):r()}:(n={dismiss:r,config:e,notif:a},void 0===o?e=>{if(void 0!==n)if(void 0===e)n.dismiss();else{const o=Object.assign({},n.config,e,{group:!1,position:a.position});addNotification(o,t,n)}}:void Object.assign(o,n))}function removeNotification(e){clearTimeout(e.meta.timer);const t=notificationsList[e.position].value.indexOf(e);if(-1!==t){void 0!==e.group&&delete groups[e.meta.group];const o=notifRefs[""+e.meta.uid];if(o){const{width:e,height:t}=getComputedStyle(o);o.style.left=`${o.offsetLeft}px`,o.style.width=e,o.style.height=t}notificationsList[e.position].value.splice(t,1),"function"===typeof e.onDismiss&&e.onDismiss()}}function hasContent(e){return void 0!==e&&null!==e&&!0!==emptyRE.test(e)}function logError(e,t){return console.error(`Notify: ${e}`,t),!1}function getComponent(){return createComponent({name:"QNotifications",devtools:{hide:!0},setup(){return()=>h("div",{class:"q-notifications"},positionList.map(e=>{return h(TransitionGroup,{key:e,class:positionClass[e],tag:"div",name:`q-notification--${e}`},()=>notificationsList[e].value.map(e=>{const t=e.meta,o=[];if(!0===t.hasMedia&&(!1!==e.spinner?o.push(h(e.spinner,{class:"q-notification__spinner q-notification__spinner--"+t.leftClass})):e.icon?o.push(h(QIcon,{class:"q-notification__icon q-notification__icon--"+t.leftClass,name:e.icon,role:"img"})):e.avatar&&o.push(h(QAvatar,{class:"q-notification__avatar q-notification__avatar--"+t.leftClass},()=>h("img",{src:e.avatar,"aria-hidden":"true"})))),!0===t.hasText){let t;const n={class:"q-notification__message col"};if(!0===e.html)n.innerHTML=e.caption?`<div>${e.message}</div><div class="q-notification__caption">${e.caption}</div>`:e.message;else{const o=[e.message];t=e.caption?[h("div",o),h("div",{class:"q-notification__caption"},[e.caption])]:o}o.push(h("div",n,t))}const n=[h("div",{class:t.contentClass},o)];return!0===e.progress&&n.push(h("div",{key:`${t.uid}|p|${t.badge}`,class:t.progressClass,style:t.progressStyle})),void 0!==e.actions&&n.push(h("div",{class:t.actionsClass},e.actions.map(e=>h(QBtn,e)))),t.badge>1&&n.push(h("div",{key:`${t.uid}|${t.badge}`,class:e.meta.badgeClass,style:e.badgeStyle},[t.badge])),h("div",{ref:e=>{notifRefs[""+t.uid]=e},key:t.uid,class:t.class,...t.attrs},[h("div",{class:t.wrapperClass},n)])}))}))}})}var Notify={setDefaults(e){e===Object(e)&&Object.assign(defaults,e)},registerType(e,t){t===Object(t)&&(notifTypes[e]=t)},install({$q:e,parentApp:t}){if(e.notify=this.create=(t=>addNotification(t,e)),e.notify.setDefaults=this.setDefaults,e.notify.registerType=this.registerType,void 0!==e.config.notify&&this.setDefaults(e.config.notify),!0!==this.__installed){positionList.forEach(e=>{notificationsList[e]=ref([]);const t=!0===["left","center","right"].includes(e)?"center":e.indexOf("top")>-1?"top":"bottom",o=e.indexOf("left")>-1?"start":e.indexOf("right")>-1?"end":"center",n=["left","right"].includes(e)?`items-${"left"===e?"start":"end"} justify-center`:"center"===e?"flex-center":`items-${o}`;positionClass[e]=`q-notifications__list q-notifications__list--${t} fixed column no-wrap ${n}`});const e=createGlobalNode("q-notify");createChildApp(getComponent(),t).mount(e)}}};function encode(e){return"[object Date]"===Object.prototype.toString.call(e)?"__q_date|"+e.toUTCString():"[object RegExp]"===Object.prototype.toString.call(e)?"__q_expr|"+e.source:"number"===typeof e?"__q_numb|"+e:"boolean"===typeof e?"__q_bool|"+(e?"1":"0"):"string"===typeof e?"__q_strn|"+e:"function"===typeof e?"__q_strn|"+e.toString():e===Object(e)?"__q_objt|"+JSON.stringify(e):e}function decode(e){const t=e.length;if(t<9)return e;const o=e.substr(0,8),n=e.substring(9);switch(o){case"__q_date":return new Date(n);case"__q_expr":return new RegExp(n);case"__q_numb":return Number(n);case"__q_bool":return Boolean("1"===n);case"__q_strn":return""+n;case"__q_objt":return JSON.parse(n);default:return e}}function getEmptyStorage(){const e=()=>null;return{has:()=>!1,getLength:()=>0,getItem:e,getIndex:e,getKey:e,getAll:()=>{},getAllKeys:()=>[],set:noop,remove:noop,clear:noop,isEmpty:()=>!0}}function getStorage(e){const t=window[e+"Storage"],o=e=>{const o=t.getItem(e);return o?decode(o):null};return{has:e=>null!==t.getItem(e),getLength:()=>t.length,getItem:o,getIndex:e=>{return e<t.length?o(t.key(e)):null},getKey:e=>{return e<t.length?t.key(e):null},getAll:()=>{let e;const n={},a=t.length;for(let l=0;l<a;l++)e=t.key(l),n[e]=o(e);return n},getAllKeys:()=>{const e=[],o=t.length;for(let n=0;n<o;n++)e.push(t.key(n));return e},set:(e,o)=>{t.setItem(e,encode(o))},remove:e=>{t.removeItem(e)},clear:()=>{t.clear()},isEmpty:()=>0===t.length}}const storage$1=!1===client.has.webStorage?getEmptyStorage():getStorage("local"),Plugin$1={install({$q:e}){e.localStorage=storage$1}};Object.assign(Plugin$1,storage$1);const storage=!1===client.has.webStorage?getEmptyStorage():getStorage("session"),Plugin={install({$q:e}){e.sessionStorage=storage}};function useDialogPluginComponent(){const{emit:e,proxy:t}=getCurrentInstance(),o=ref(null);function n(){o.value.show()}function a(){o.value.hide()}function l(t){e("ok",t),a()}function i(){e("hide")}return Object.assign(t,{show:n,hide:a}),{dialogRef:o,onDialogHide:i,onDialogOK:l,onDialogCancel:a}}Object.assign(Plugin,storage);const emits=["ok","hide"];function useMeta(e){{const t={active:!0};if("function"===typeof e){const o=computed(e);t.val=o.value,watch(o,e=>{t.val=e,!0===t.active&&planClientUpdate()})}else t.val=e;clientList.push(t),planClientUpdate(),onActivated(()=>{t.active=!0,planClientUpdate()}),onDeactivated(()=>{t.active=!1,planClientUpdate()}),onUnmounted(()=>{clientList.splice(clientList.indexOf(t),1),planClientUpdate()})}}function useQuasar(){return inject(quasarKey)}useDialogPluginComponent.emits=emits,useDialogPluginComponent.emitsObject=getEmitsObject(emits);const Quasar={version:"2.5.3",install(e,t,o){installQuasar(e,{components:components,directives:directives,...t})},lang:Plugin$8,iconSet:Plugin$7};export{AddressbarColor,Plugin$6 as AppFullscreen,Plugin$5 as AppVisibility,BottomSheet,ClosePopup,Plugin$4 as Cookies,Plugin$9 as Dark,Dialog,Intersection,Plugin$2 as Loading,Plugin$3 as LoadingBar,Plugin$1 as LocalStorage,Meta,Morph,Mutation,Notify,Platform,QAjaxBar,QAvatar,QBadge,QBanner,QBar,QBreadcrumbs,QBreadcrumbsEl,QBtn,QBtnDropdown,QBtnGroup,QBtnToggle,QCard,QCardActions,QCardSection,QCarousel,QCarouselControl,QCarouselSlide,QChatMessage,QCheckbox,QChip,QCircularProgress,QColor,QDate,QDialog,QDrawer,QEditor,QExpansionItem,QFab,QFabAction,QField,QFile,QFooter,QForm,QFormChildMixin,QHeader,QIcon,QImg,QInfiniteScroll,QInnerLoading,QInput,QIntersection,QItem,QItemLabel,QItemSection,QKnob,QLayout,QLinearProgress,QList,QMarkupTable,QMenu,QNoSsr,QOptionGroup,QPage,QPageContainer,QPageScroller,QPageSticky,QPagination,QParallax,QPopupEdit,QPopupProxy,QPullToRefresh,QRadio,QRange,QRating,QResizeObserver,QResponsive,QRouteTab,QScrollArea,QScrollObserver,QSelect,QSeparator,QSkeleton,QSlideItem,QSlideTransition,QSlider,QSpace,QSpinner,QSpinnerAudio,QSpinnerBall,QSpinnerBars,QSpinnerBox,QSpinnerClock,QSpinnerComment,QSpinnerCube,QSpinnerDots,QSpinnerFacebook,QSpinnerGears,QSpinnerGrid,QSpinnerHearts,QSpinnerHourglass,QSpinnerInfinity,QSpinnerIos,QSpinnerOrbit,QSpinnerOval,QSpinnerPie,QSpinnerPuff,QSpinnerRadio,QSpinnerRings,QSpinnerTail,QSplitter,QStep,QStepper,QStepperNavigation,QTab,QTabPanel,QTabPanels,QTable,QTabs,QTd,QTh,QTime,QTimeline,QTimelineEntry,QToggle,QToolbar,QToolbarTitle,QTooltip,QTr,QTree,QUploader,QUploaderAddTrigger,QVideo,QVirtualScroll,Quasar,Ripple,Screen,Scroll,ScrollFire,Plugin as SessionStorage,TouchHold,TouchPan,TouchRepeat,TouchSwipe,cloneDeep as clone,colors,copyToClipboard,createMetaMixin,createUploaderComponent,date,debounce,dom,event,exportFile,extend,format,frameDebounce,getCssVar,morph,noop,openUrl as openURL,patterns,scroll,setCssVar,throttle,uid$2 as uid,useDialogPluginComponent,useFormChild,useMeta,useQuasar};