import { coreProps, coreEmits, getRenderer } from '../components/uploader/uploader-core.js'

import { createComponent } from './private/create.js'
import getEmitsObject from './private/get-emits-object.js'
import { isObject } from './is.js'

const coreEmitsObject = getEmitsObject(coreEmits)

export default ({ name, props, emits, injectPlugin }) => createComponent({
  name,

  props: {
    ...coreProps,
    ...props
  },

  emits: isObject(emits) === true
    ? { ...coreEmitsObject, ...emits }
    : [ ...coreEmits, ...emits ],

  setup () {
    return getRenderer(injectPlugin)
  }
})
