![Quasar Framework logo](https://cdn.quasar.dev/logo/svg/quasar-logo-full-inline.svg)

## Quasar Framework Extras Package

> Build responsive Single Page Apps, **SSR Apps**, PWAs, Hybrid Mobile Apps and Electron Apps, all using the same codebase!, powered with Vue.

<img src="https://img.shields.io/npm/v/%40quasar/extras.svg?label=@quasar/extras">

[![Join the chat at https://chat.quasar.dev](https://img.shields.io/badge/chat-on%20discord-7289da.svg)](https://chat.quasar.dev)
<a href="https://forum.quasar.dev" target="_blank"><img src="https://img.shields.io/badge/community-forum-brightgreen.svg"></a>
[![https://good-labs.github.io/greater-good-affirmation/assets/images/badge.svg](https://good-labs.github.io/greater-good-affirmation/assets/images/badge.svg)](https://good-labs.github.io/greater-good-affirmation)

## Contents

| Package | quasar.conf.js extras name | Version | Description | Notes |
| --- | --- | --- | --- | --- |
| Roboto Font | `roboto-font` | CDN v19 | Recommended font along Material theme | |
| Roboto Font Latin Extended | `roboto-font-latin-ext` | CDN v19 | Recommended font along Material theme | |
| [Material Icons](https://material.io/tools/icons/?style=baseline) | `material-icons` | CDN v47 | Material icons font | Requires: Quasar 1.0.5+, @quasar/extras 1.2.0+ |
| [Material Icons Outlined](https://material.io/tools/icons/?style=outline) | `material-icons-outlined` | CDN v8 | Material icons outlined font | Requires: Quasar 1.0.5+, @quasar/extras 1.2.0+ |
| [Material Icons Round](https://material.io/tools/icons/?style=round) | `material-icons-round` | CDN v8 | Material icons round font | Requires: Quasar 1.0.5+, @quasar/extras 1.2.0+ |
| [Material Icons Sharp](https://material.io/tools/icons/?style=sharp) | `material-icons-sharp` | CDN v9 | Material icons sharp font | Requires: Quasar 1.0.5+, @quasar/extras 1.2.0+ |
| [MDI](https://materialdesignicons.com/) (Material Design Icons) | `mdi-v3` | 3.6.95 | Extended Material Design icons font | |
| [Font Awesome](https://fontawesome.com/icons?d=gallery) | `fontawesome-v5` | 5.9.0 | Fontawesome icons font | |
| [Ionicons](http://ionicons.com/) | `ionicons-v4` | 4.5.5 | Ionicons font | |
| [Eva Icons](https://akveo.github.io/eva-icons) | `eva-icons` | 1.1.1 | Eva Icons font | |
| [Themify Icons](https://themify.me/themify-icons) | `themify` | 1.0.0 | Themify Icons font | |
| [Animate.css](https://daneden.github.io/animate.css/) | Use `animations` prop | 3.5.2 | Bundle of animations you can use in your website/app | |

Why this package? Because it strips down unnecessary package files (so faster download times), all in one place, tested and ready to use with Quasar. One other reason is that the material icons npm package sometimes fails to be downloaded by NPM.

## Supporting Quasar
Quasar Framework is an MIT-licensed open source project. Its ongoing development is made possible thanks to the support by these awesome [backers](https://github.com/quasarframework/quasar/blob/dev/backers.md).

**Please read our manifest on [Why donations are important](https://quasar.dev/why-donate)**. If you'd like to become a donator, check out [Quasar Framework's Donator campaign](https://donate.quasar.dev).

## Documentation

Head on to the Quasar Framework official website: [https://quasar.dev](https://quasar.dev)

## Stay in Touch

For latest releases and announcements, follow on Twitter: [@quasarframework](https://twitter.quasar.dev)

## Chat Support

Ask questions at the official community Discord server: [https://chat.quasar.dev](https://chat.quasar.dev)

## Community Forum

Head on to the official community forum: [https://forum.quasar.dev](https://forum.quasar.dev)

## Semver
Using [semver 2.0](http://semver.org/) notation for 'quasar-extras' package.

## License

All assets included in this repository are exclusive property of their respective owners. Quasar does not take any credit in packages included here.
